// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4776__auto___114257 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true;

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114304){
var state_val_114305 = (state_114304[(1)]);
if((state_val_114305 === (7))){
var inst_114274 = (state_114304[(7)]);
var state_114304__$1 = state_114304;
var statearr_114306_114327 = state_114304__$1;
(statearr_114306_114327[(2)] = inst_114274);

(statearr_114306_114327[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (1))){
var state_114304__$1 = state_114304;
var statearr_114307_114328 = state_114304__$1;
(statearr_114307_114328[(2)] = null);

(statearr_114307_114328[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114304,(3),Error,null,(2));
var inst_114269 = cljs.core.seq(args);
var inst_114270 = cljs.core.first(inst_114269);
var inst_114271 = cljs.core.next(inst_114269);
var inst_114272 = cljs.core.PersistentVector.EMPTY;
var inst_114273 = args;
var inst_114274 = inst_114272;
var state_114304__$1 = (function (){var statearr_114308 = state_114304;
(statearr_114308[(7)] = inst_114274);

(statearr_114308[(8)] = inst_114271);

(statearr_114308[(9)] = inst_114270);

(statearr_114308[(10)] = inst_114273);

return statearr_114308;
})();
var statearr_114309_114329 = state_114304__$1;
(statearr_114309_114329[(2)] = null);

(statearr_114309_114329[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (13))){
var inst_114274 = (state_114304[(7)]);
var inst_114281 = (state_114304[(11)]);
var inst_114288 = (state_114304[(2)]);
var inst_114289 = fluree.db.util.async.throw_err(inst_114288);
var inst_114290 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114274,inst_114289);
var inst_114273 = inst_114281;
var inst_114274__$1 = inst_114290;
var state_114304__$1 = (function (){var statearr_114310 = state_114304;
(statearr_114310[(7)] = inst_114274__$1);

(statearr_114310[(10)] = inst_114273);

return statearr_114310;
})();
var statearr_114311_114330 = state_114304__$1;
(statearr_114311_114330[(2)] = null);

(statearr_114311_114330[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (6))){
var inst_114300 = (state_114304[(2)]);
var state_114304__$1 = state_114304;
var statearr_114312_114331 = state_114304__$1;
(statearr_114312_114331[(2)] = inst_114300);


cljs.core.async.impl.ioc_helpers.process_exception(state_114304__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (3))){
var inst_114258 = (state_114304[(2)]);
var state_114304__$1 = state_114304;
var statearr_114313_114332 = state_114304__$1;
(statearr_114313_114332[(2)] = inst_114258);


cljs.core.async.impl.ioc_helpers.process_exception(state_114304__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (12))){
var inst_114296 = (state_114304[(2)]);
var state_114304__$1 = state_114304;
var statearr_114314_114333 = state_114304__$1;
(statearr_114314_114333[(2)] = inst_114296);

(statearr_114314_114333[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (2))){
var inst_114302 = (state_114304[(2)]);
var state_114304__$1 = state_114304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114304__$1,inst_114302);
} else {
if((state_val_114305 === (11))){
var inst_114274 = (state_114304[(7)]);
var inst_114281 = (state_114304[(11)]);
var inst_114280 = (state_114304[(12)]);
var inst_114293 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114274,inst_114280);
var inst_114273 = inst_114281;
var inst_114274__$1 = inst_114293;
var state_114304__$1 = (function (){var statearr_114315 = state_114304;
(statearr_114315[(7)] = inst_114274__$1);

(statearr_114315[(10)] = inst_114273);

return statearr_114315;
})();
var statearr_114316_114334 = state_114304__$1;
(statearr_114316_114334[(2)] = null);

(statearr_114316_114334[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (9))){
var inst_114298 = (state_114304[(2)]);
var state_114304__$1 = state_114304;
var statearr_114317_114335 = state_114304__$1;
(statearr_114317_114335[(2)] = inst_114298);

(statearr_114317_114335[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (5))){
var inst_114273 = (state_114304[(10)]);
var inst_114280 = (state_114304[(12)]);
var inst_114279 = cljs.core.seq(inst_114273);
var inst_114280__$1 = cljs.core.first(inst_114279);
var inst_114281 = cljs.core.next(inst_114279);
var inst_114282 = cljs.core.not(inst_114280__$1);
var state_114304__$1 = (function (){var statearr_114318 = state_114304;
(statearr_114318[(11)] = inst_114281);

(statearr_114318[(12)] = inst_114280__$1);

return statearr_114318;
})();
if(inst_114282){
var statearr_114319_114336 = state_114304__$1;
(statearr_114319_114336[(1)] = (7));

} else {
var statearr_114320_114337 = state_114304__$1;
(statearr_114320_114337[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114305 === (10))){
var inst_114280 = (state_114304[(12)]);
var state_114304__$1 = state_114304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114304__$1,(13),inst_114280);
} else {
if((state_val_114305 === (8))){
var inst_114280 = (state_114304[(12)]);
var inst_114285 = fluree.db.util.async.channel_QMARK_(inst_114280);
var state_114304__$1 = state_114304;
if(inst_114285){
var statearr_114321_114338 = state_114304__$1;
(statearr_114321_114338[(1)] = (10));

} else {
var statearr_114322_114339 = state_114304__$1;
(statearr_114322_114339[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____0 = (function (){
var statearr_114323 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114323[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__);

(statearr_114323[(1)] = (1));

return statearr_114323;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____1 = (function (state_114304){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114304);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114324){if((e114324 instanceof Object)){
var ex__99040__auto__ = e114324;
var statearr_114325_114340 = state_114304;
(statearr_114325_114340[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114304);

return cljs.core.cst$kw$recur;
} else {
throw e114324;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114341 = state_114304;
state_114304 = G__114341;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__ = function(state_114304){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____1.call(this,state_114304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114326 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114326[(6)] = c__99059__auto__);

return statearr_114326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__114342 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114342,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__114342,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),((function (vec__114342,res,cost){
return (function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
});})(vec__114342,res,cost))
);
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114387){
var state_val_114388 = (state_114387[(1)]);
if((state_val_114388 === (7))){
var inst_114356 = (state_114387[(7)]);
var inst_114356__$1 = (state_114387[(2)]);
var inst_114357 = cljs.core.set_QMARK_(inst_114356__$1);
var state_114387__$1 = (function (){var statearr_114389 = state_114387;
(statearr_114389[(7)] = inst_114356__$1);

return statearr_114389;
})();
if(inst_114357){
var statearr_114390_114411 = state_114387__$1;
(statearr_114390_114411[(1)] = (9));

} else {
var statearr_114391_114412 = state_114387__$1;
(statearr_114391_114412[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (1))){
var state_114387__$1 = state_114387;
var statearr_114392_114413 = state_114387__$1;
(statearr_114392_114413[(2)] = null);

(statearr_114392_114413[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114387,(3),Error,null,(2));
var inst_114349 = fluree.db.util.async.channel_QMARK_(coll);
var state_114387__$1 = state_114387;
if(inst_114349){
var statearr_114393_114414 = state_114387__$1;
(statearr_114393_114414[(1)] = (5));

} else {
var statearr_114394_114415 = state_114387__$1;
(statearr_114394_114415[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (15))){
var inst_114366 = (state_114387[(2)]);
var inst_114367 = fluree.db.util.async.throw_err(inst_114366);
var state_114387__$1 = state_114387;
var statearr_114395_114416 = state_114387__$1;
(statearr_114395_114416[(2)] = inst_114367);

(statearr_114395_114416[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (13))){
var state_114387__$1 = state_114387;
var statearr_114396_114417 = state_114387__$1;
(statearr_114396_114417[(2)] = key);

(statearr_114396_114417[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (6))){
var state_114387__$1 = state_114387;
var statearr_114397_114418 = state_114387__$1;
(statearr_114397_114418[(2)] = coll);

(statearr_114397_114418[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (3))){
var inst_114345 = (state_114387[(2)]);
var state_114387__$1 = state_114387;
var statearr_114398_114419 = state_114387__$1;
(statearr_114398_114419[(2)] = inst_114345);


cljs.core.async.impl.ioc_helpers.process_exception(state_114387__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (12))){
var state_114387__$1 = state_114387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114387__$1,(15),key);
} else {
if((state_val_114388 === (2))){
var inst_114385 = (state_114387[(2)]);
var state_114387__$1 = state_114387;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114387__$1,inst_114385);
} else {
if((state_val_114388 === (11))){
var inst_114362 = (state_114387[(2)]);
var inst_114363 = fluree.db.util.async.channel_QMARK_(key);
var state_114387__$1 = (function (){var statearr_114399 = state_114387;
(statearr_114399[(8)] = inst_114362);

return statearr_114399;
})();
if(inst_114363){
var statearr_114400_114420 = state_114387__$1;
(statearr_114400_114420[(1)] = (12));

} else {
var statearr_114401_114421 = state_114387__$1;
(statearr_114401_114421[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (9))){
var inst_114356 = (state_114387[(7)]);
var inst_114359 = cljs.core.vec(inst_114356);
var state_114387__$1 = state_114387;
var statearr_114402_114422 = state_114387__$1;
(statearr_114402_114422[(2)] = inst_114359);

(statearr_114402_114422[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (5))){
var state_114387__$1 = state_114387;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114387__$1,(8),coll);
} else {
if((state_val_114388 === (14))){
var inst_114362 = (state_114387[(8)]);
var inst_114370 = (state_114387[(2)]);
var inst_114371 = fluree.db.dbfunctions.internal.nth(inst_114362,inst_114370);
var inst_114372 = cljs.core.count(inst_114362);
var inst_114373 = ((9) + inst_114372);
var inst_114374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114375 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114377 = [inst_114362,inst_114370];
var inst_114378 = (new cljs.core.PersistentVector(null,2,(5),inst_114376,inst_114377,null));
var inst_114379 = ["nth",inst_114378,inst_114371];
var inst_114380 = cljs.core.PersistentHashMap.fromArrays(inst_114375,inst_114379);
var inst_114381 = [inst_114380,inst_114373];
var inst_114382 = (new cljs.core.PersistentVector(null,2,(5),inst_114374,inst_114381,null));
var inst_114383 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114382);
var state_114387__$1 = (function (){var statearr_114403 = state_114387;
(statearr_114403[(9)] = inst_114383);

return statearr_114403;
})();
var statearr_114404_114423 = state_114387__$1;
(statearr_114404_114423[(2)] = inst_114371);


cljs.core.async.impl.ioc_helpers.process_exception(state_114387__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (10))){
var inst_114356 = (state_114387[(7)]);
var state_114387__$1 = state_114387;
var statearr_114405_114424 = state_114387__$1;
(statearr_114405_114424[(2)] = inst_114356);

(statearr_114405_114424[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114388 === (8))){
var inst_114352 = (state_114387[(2)]);
var inst_114353 = fluree.db.util.async.throw_err(inst_114352);
var state_114387__$1 = state_114387;
var statearr_114406_114425 = state_114387__$1;
(statearr_114406_114425[(2)] = inst_114353);

(statearr_114406_114425[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____0 = (function (){
var statearr_114407 = [null,null,null,null,null,null,null,null,null,null];
(statearr_114407[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__);

(statearr_114407[(1)] = (1));

return statearr_114407;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____1 = (function (state_114387){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114387);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114408){if((e114408 instanceof Object)){
var ex__99040__auto__ = e114408;
var statearr_114409_114426 = state_114387;
(statearr_114409_114426[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114387);

return cljs.core.cst$kw$recur;
} else {
throw e114408;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114427 = state_114387;
state_114387 = G__114427;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__ = function(state_114387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____1.call(this,state_114387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114410 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114410[(6)] = c__99059__auto__);

return statearr_114410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114485){
var state_val_114486 = (state_114485[(1)]);
if((state_val_114486 === (7))){
var inst_114442 = (state_114485[(7)]);
var inst_114442__$1 = (state_114485[(2)]);
var state_114485__$1 = (function (){var statearr_114487 = state_114485;
(statearr_114487[(7)] = inst_114442__$1);

return statearr_114487;
})();
if(cljs.core.truth_(inst_114442__$1)){
var statearr_114488_114514 = state_114485__$1;
(statearr_114488_114514[(1)] = (9));

} else {
var statearr_114489_114515 = state_114485__$1;
(statearr_114489_114515[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (1))){
var state_114485__$1 = state_114485;
var statearr_114490_114516 = state_114485__$1;
(statearr_114490_114516[(2)] = null);

(statearr_114490_114516[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114485,(3),Error,null,(2));
var inst_114435 = fluree.db.util.async.channel_QMARK_(test);
var state_114485__$1 = state_114485;
if(inst_114435){
var statearr_114491_114517 = state_114485__$1;
(statearr_114491_114517[(1)] = (5));

} else {
var statearr_114492_114518 = state_114485__$1;
(statearr_114492_114518[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (15))){
var inst_114448 = (state_114485[(2)]);
var inst_114449 = fluree.db.util.async.throw_err(inst_114448);
var state_114485__$1 = state_114485;
var statearr_114493_114519 = state_114485__$1;
(statearr_114493_114519[(2)] = inst_114449);

(statearr_114493_114519[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (13))){
var state_114485__$1 = state_114485;
var statearr_114494_114520 = state_114485__$1;
(statearr_114494_114520[(2)] = t);

(statearr_114494_114520[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (6))){
var state_114485__$1 = state_114485;
var statearr_114495_114521 = state_114485__$1;
(statearr_114495_114521[(2)] = test);

(statearr_114495_114521[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (17))){
var state_114485__$1 = state_114485;
var statearr_114496_114522 = state_114485__$1;
(statearr_114496_114522[(2)] = f);

(statearr_114496_114522[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (3))){
var inst_114428 = (state_114485[(2)]);
var state_114485__$1 = state_114485;
var statearr_114497_114523 = state_114485__$1;
(statearr_114497_114523[(2)] = inst_114428);


cljs.core.async.impl.ioc_helpers.process_exception(state_114485__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (12))){
var state_114485__$1 = state_114485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114485__$1,(15),t);
} else {
if((state_val_114486 === (2))){
var inst_114483 = (state_114485[(2)]);
var state_114485__$1 = state_114485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114485__$1,inst_114483);
} else {
if((state_val_114486 === (19))){
var inst_114460 = (state_114485[(2)]);
var inst_114461 = fluree.db.util.async.throw_err(inst_114460);
var state_114485__$1 = state_114485;
var statearr_114498_114524 = state_114485__$1;
(statearr_114498_114524[(2)] = inst_114461);

(statearr_114498_114524[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (11))){
var inst_114442 = (state_114485[(7)]);
var inst_114468 = (state_114485[(2)]);
var inst_114469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114468,(0),null);
var inst_114470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114468,(1),null);
var inst_114471 = fluree.db.dbfunctions.internal.if_else(inst_114442,inst_114469,inst_114470);
var inst_114472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114473 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114475 = [inst_114442,inst_114469,inst_114470];
var inst_114476 = (new cljs.core.PersistentVector(null,3,(5),inst_114474,inst_114475,null));
var inst_114477 = ["if-else",inst_114476,inst_114471];
var inst_114478 = cljs.core.PersistentHashMap.fromArrays(inst_114473,inst_114477);
var inst_114479 = [inst_114478,(10)];
var inst_114480 = (new cljs.core.PersistentVector(null,2,(5),inst_114472,inst_114479,null));
var inst_114481 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114480);
var state_114485__$1 = (function (){var statearr_114499 = state_114485;
(statearr_114499[(8)] = inst_114481);

return statearr_114499;
})();
var statearr_114500_114525 = state_114485__$1;
(statearr_114500_114525[(2)] = inst_114471);


cljs.core.async.impl.ioc_helpers.process_exception(state_114485__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (9))){
var inst_114444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114445 = fluree.db.util.async.channel_QMARK_(t);
var state_114485__$1 = (function (){var statearr_114501 = state_114485;
(statearr_114501[(9)] = inst_114444);

return statearr_114501;
})();
if(inst_114445){
var statearr_114502_114526 = state_114485__$1;
(statearr_114502_114526[(1)] = (12));

} else {
var statearr_114503_114527 = state_114485__$1;
(statearr_114503_114527[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (5))){
var state_114485__$1 = state_114485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114485__$1,(8),test);
} else {
if((state_val_114486 === (14))){
var inst_114444 = (state_114485[(9)]);
var inst_114452 = (state_114485[(2)]);
var inst_114453 = [inst_114452,f];
var inst_114454 = (new cljs.core.PersistentVector(null,2,(5),inst_114444,inst_114453,null));
var state_114485__$1 = state_114485;
var statearr_114504_114528 = state_114485__$1;
(statearr_114504_114528[(2)] = inst_114454);

(statearr_114504_114528[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (16))){
var state_114485__$1 = state_114485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114485__$1,(19),f);
} else {
if((state_val_114486 === (10))){
var inst_114456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114457 = fluree.db.util.async.channel_QMARK_(f);
var state_114485__$1 = (function (){var statearr_114505 = state_114485;
(statearr_114505[(10)] = inst_114456);

return statearr_114505;
})();
if(inst_114457){
var statearr_114506_114529 = state_114485__$1;
(statearr_114506_114529[(1)] = (16));

} else {
var statearr_114507_114530 = state_114485__$1;
(statearr_114507_114530[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (18))){
var inst_114456 = (state_114485[(10)]);
var inst_114464 = (state_114485[(2)]);
var inst_114465 = [f,inst_114464];
var inst_114466 = (new cljs.core.PersistentVector(null,2,(5),inst_114456,inst_114465,null));
var state_114485__$1 = state_114485;
var statearr_114508_114531 = state_114485__$1;
(statearr_114508_114531[(2)] = inst_114466);

(statearr_114508_114531[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114486 === (8))){
var inst_114438 = (state_114485[(2)]);
var inst_114439 = fluree.db.util.async.throw_err(inst_114438);
var state_114485__$1 = state_114485;
var statearr_114509_114532 = state_114485__$1;
(statearr_114509_114532[(2)] = inst_114439);

(statearr_114509_114532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____0 = (function (){
var statearr_114510 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_114510[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__);

(statearr_114510[(1)] = (1));

return statearr_114510;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____1 = (function (state_114485){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114485);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114511){if((e114511 instanceof Object)){
var ex__99040__auto__ = e114511;
var statearr_114512_114533 = state_114485;
(statearr_114512_114533[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114485);

return cljs.core.cst$kw$recur;
} else {
throw e114511;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114534 = state_114485;
state_114485 = G__114534;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__ = function(state_114485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____1.call(this,state_114485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114513 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114513[(6)] = c__99059__auto__);

return statearr_114513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114561){
var state_val_114562 = (state_114561[(1)]);
if((state_val_114562 === (1))){
var state_114561__$1 = state_114561;
var statearr_114563_114575 = state_114561__$1;
(statearr_114563_114575[(2)] = null);

(statearr_114563_114575[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114562 === (2))){
var inst_114559 = (state_114561[(2)]);
var state_114561__$1 = state_114561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114561__$1,inst_114559);
} else {
if((state_val_114562 === (3))){
var inst_114535 = (state_114561[(2)]);
var state_114561__$1 = state_114561;
var statearr_114564_114576 = state_114561__$1;
(statearr_114564_114576[(2)] = inst_114535);


cljs.core.async.impl.ioc_helpers.process_exception(state_114561__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114562 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114561,(3),Error,null,(2));
var inst_114539 = fluree.db.util.async.channel_QMARK_(arg);
var state_114561__$1 = state_114561;
if(inst_114539){
var statearr_114565_114577 = state_114561__$1;
(statearr_114565_114577[(1)] = (5));

} else {
var statearr_114566_114578 = state_114561__$1;
(statearr_114566_114578[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114562 === (5))){
var state_114561__$1 = state_114561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114561__$1,(8),arg);
} else {
if((state_val_114562 === (6))){
var state_114561__$1 = state_114561;
var statearr_114567_114579 = state_114561__$1;
(statearr_114567_114579[(2)] = arg);

(statearr_114567_114579[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114562 === (7))){
var inst_114546 = (state_114561[(2)]);
var inst_114547 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_114546);
var inst_114548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114549 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114551 = [inst_114546];
var inst_114552 = (new cljs.core.PersistentVector(null,1,(5),inst_114550,inst_114551,null));
var inst_114553 = ["nil?",inst_114552,inst_114547];
var inst_114554 = cljs.core.PersistentHashMap.fromArrays(inst_114549,inst_114553);
var inst_114555 = [inst_114554,(10)];
var inst_114556 = (new cljs.core.PersistentVector(null,2,(5),inst_114548,inst_114555,null));
var inst_114557 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114556);
var state_114561__$1 = (function (){var statearr_114568 = state_114561;
(statearr_114568[(7)] = inst_114557);

return statearr_114568;
})();
var statearr_114569_114580 = state_114561__$1;
(statearr_114569_114580[(2)] = inst_114547);


cljs.core.async.impl.ioc_helpers.process_exception(state_114561__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114562 === (8))){
var inst_114542 = (state_114561[(2)]);
var inst_114543 = fluree.db.util.async.throw_err(inst_114542);
var state_114561__$1 = state_114561;
var statearr_114570_114581 = state_114561__$1;
(statearr_114570_114581[(2)] = inst_114543);

(statearr_114570_114581[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_114571 = [null,null,null,null,null,null,null,null];
(statearr_114571[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__);

(statearr_114571[(1)] = (1));

return statearr_114571;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____1 = (function (state_114561){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114561);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114572){if((e114572 instanceof Object)){
var ex__99040__auto__ = e114572;
var statearr_114573_114582 = state_114561;
(statearr_114573_114582[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114561);

return cljs.core.cst$kw$recur;
} else {
throw e114572;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114583 = state_114561;
state_114561 = G__114583;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__ = function(state_114561){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____1.call(this,state_114561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114574 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114574[(6)] = c__99059__auto__);

return statearr_114574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114610){
var state_val_114611 = (state_114610[(1)]);
if((state_val_114611 === (1))){
var state_114610__$1 = state_114610;
var statearr_114612_114624 = state_114610__$1;
(statearr_114612_114624[(2)] = null);

(statearr_114612_114624[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114611 === (2))){
var inst_114608 = (state_114610[(2)]);
var state_114610__$1 = state_114610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114610__$1,inst_114608);
} else {
if((state_val_114611 === (3))){
var inst_114584 = (state_114610[(2)]);
var state_114610__$1 = state_114610;
var statearr_114613_114625 = state_114610__$1;
(statearr_114613_114625[(2)] = inst_114584);


cljs.core.async.impl.ioc_helpers.process_exception(state_114610__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114611 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114610,(3),Error,null,(2));
var inst_114588 = fluree.db.util.async.channel_QMARK_(arg);
var state_114610__$1 = state_114610;
if(inst_114588){
var statearr_114614_114626 = state_114610__$1;
(statearr_114614_114626[(1)] = (5));

} else {
var statearr_114615_114627 = state_114610__$1;
(statearr_114615_114627[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114611 === (5))){
var state_114610__$1 = state_114610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114610__$1,(8),arg);
} else {
if((state_val_114611 === (6))){
var state_114610__$1 = state_114610;
var statearr_114616_114628 = state_114610__$1;
(statearr_114616_114628[(2)] = arg);

(statearr_114616_114628[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114611 === (7))){
var inst_114595 = (state_114610[(2)]);
var inst_114596 = fluree.db.dbfunctions.internal.not(inst_114595);
var inst_114597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114598 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114600 = [inst_114595];
var inst_114601 = (new cljs.core.PersistentVector(null,1,(5),inst_114599,inst_114600,null));
var inst_114602 = ["not?",inst_114601,inst_114596];
var inst_114603 = cljs.core.PersistentHashMap.fromArrays(inst_114598,inst_114602);
var inst_114604 = [inst_114603,(10)];
var inst_114605 = (new cljs.core.PersistentVector(null,2,(5),inst_114597,inst_114604,null));
var inst_114606 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114605);
var state_114610__$1 = (function (){var statearr_114617 = state_114610;
(statearr_114617[(7)] = inst_114606);

return statearr_114617;
})();
var statearr_114618_114629 = state_114610__$1;
(statearr_114618_114629[(2)] = inst_114596);


cljs.core.async.impl.ioc_helpers.process_exception(state_114610__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114611 === (8))){
var inst_114591 = (state_114610[(2)]);
var inst_114592 = fluree.db.util.async.throw_err(inst_114591);
var state_114610__$1 = state_114610;
var statearr_114619_114630 = state_114610__$1;
(statearr_114619_114630[(2)] = inst_114592);

(statearr_114619_114630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____0 = (function (){
var statearr_114620 = [null,null,null,null,null,null,null,null];
(statearr_114620[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__);

(statearr_114620[(1)] = (1));

return statearr_114620;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____1 = (function (state_114610){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114610);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114621){if((e114621 instanceof Object)){
var ex__99040__auto__ = e114621;
var statearr_114622_114631 = state_114610;
(statearr_114622_114631[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114610);

return cljs.core.cst$kw$recur;
} else {
throw e114621;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114632 = state_114610;
state_114610 = G__114632;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__ = function(state_114610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____1.call(this,state_114610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114623 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114623[(6)] = c__99059__auto__);

return statearr_114623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114659){
var state_val_114660 = (state_114659[(1)]);
if((state_val_114660 === (1))){
var state_114659__$1 = state_114659;
var statearr_114661_114673 = state_114659__$1;
(statearr_114661_114673[(2)] = null);

(statearr_114661_114673[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114660 === (2))){
var inst_114657 = (state_114659[(2)]);
var state_114659__$1 = state_114659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114659__$1,inst_114657);
} else {
if((state_val_114660 === (3))){
var inst_114633 = (state_114659[(2)]);
var state_114659__$1 = state_114659;
var statearr_114662_114674 = state_114659__$1;
(statearr_114662_114674[(2)] = inst_114633);


cljs.core.async.impl.ioc_helpers.process_exception(state_114659__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114660 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114659,(3),Error,null,(2));
var inst_114637 = fluree.db.util.async.channel_QMARK_(arg);
var state_114659__$1 = state_114659;
if(inst_114637){
var statearr_114663_114675 = state_114659__$1;
(statearr_114663_114675[(1)] = (5));

} else {
var statearr_114664_114676 = state_114659__$1;
(statearr_114664_114676[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114660 === (5))){
var state_114659__$1 = state_114659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114659__$1,(8),arg);
} else {
if((state_val_114660 === (6))){
var state_114659__$1 = state_114659;
var statearr_114665_114677 = state_114659__$1;
(statearr_114665_114677[(2)] = arg);

(statearr_114665_114677[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114660 === (7))){
var inst_114644 = (state_114659[(2)]);
var inst_114645 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_114644);
var inst_114646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114647 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114649 = [inst_114644];
var inst_114650 = (new cljs.core.PersistentVector(null,1,(5),inst_114648,inst_114649,null));
var inst_114651 = ["empty?",inst_114650,inst_114645];
var inst_114652 = cljs.core.PersistentHashMap.fromArrays(inst_114647,inst_114651);
var inst_114653 = [inst_114652,(10)];
var inst_114654 = (new cljs.core.PersistentVector(null,2,(5),inst_114646,inst_114653,null));
var inst_114655 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114654);
var state_114659__$1 = (function (){var statearr_114666 = state_114659;
(statearr_114666[(7)] = inst_114655);

return statearr_114666;
})();
var statearr_114667_114678 = state_114659__$1;
(statearr_114667_114678[(2)] = inst_114645);


cljs.core.async.impl.ioc_helpers.process_exception(state_114659__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114660 === (8))){
var inst_114640 = (state_114659[(2)]);
var inst_114641 = fluree.db.util.async.throw_err(inst_114640);
var state_114659__$1 = state_114659;
var statearr_114668_114679 = state_114659__$1;
(statearr_114668_114679[(2)] = inst_114641);

(statearr_114668_114679[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_114669 = [null,null,null,null,null,null,null,null];
(statearr_114669[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__);

(statearr_114669[(1)] = (1));

return statearr_114669;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____1 = (function (state_114659){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114659);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114670){if((e114670 instanceof Object)){
var ex__99040__auto__ = e114670;
var statearr_114671_114680 = state_114659;
(statearr_114671_114680[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114659);

return cljs.core.cst$kw$recur;
} else {
throw e114670;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114681 = state_114659;
state_114659 = G__114681;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__ = function(state_114659){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____1.call(this,state_114659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114672 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114672[(6)] = c__99059__auto__);

return statearr_114672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4736__auto__ = [];
var len__4730__auto___114716 = arguments.length;
var i__4731__auto___114717 = (0);
while(true){
if((i__4731__auto___114717 < len__4730__auto___114716)){
args__4736__auto__.push((arguments[i__4731__auto___114717]));

var G__114718 = (i__4731__auto___114717 + (1));
i__4731__auto___114717 = G__114718;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114706){
var state_val_114707 = (state_114706[(1)]);
if((state_val_114707 === (1))){
var state_114706__$1 = state_114706;
var statearr_114708_114719 = state_114706__$1;
(statearr_114708_114719[(2)] = null);

(statearr_114708_114719[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114707 === (2))){
var inst_114704 = (state_114706[(2)]);
var state_114706__$1 = state_114706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114706__$1,inst_114704);
} else {
if((state_val_114707 === (3))){
var inst_114684 = (state_114706[(2)]);
var state_114706__$1 = state_114706;
var statearr_114709_114720 = state_114706__$1;
(statearr_114709_114720[(2)] = inst_114684);


cljs.core.async.impl.ioc_helpers.process_exception(state_114706__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114707 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114706,(3),Error,null,(2));
var inst_114688 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_114706__$1 = state_114706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114706__$1,(5),inst_114688);
} else {
if((state_val_114707 === (5))){
var inst_114690 = (state_114706[(2)]);
var inst_114691 = fluree.db.util.async.throw_err(inst_114690);
var inst_114692 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_114691);
var inst_114693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114694 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114696 = [inst_114691];
var inst_114697 = (new cljs.core.PersistentVector(null,1,(5),inst_114695,inst_114696,null));
var inst_114698 = ["str",inst_114697,inst_114692];
var inst_114699 = cljs.core.PersistentHashMap.fromArrays(inst_114694,inst_114698);
var inst_114700 = [inst_114699,(10)];
var inst_114701 = (new cljs.core.PersistentVector(null,2,(5),inst_114693,inst_114700,null));
var inst_114702 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114701);
var state_114706__$1 = (function (){var statearr_114710 = state_114706;
(statearr_114710[(7)] = inst_114702);

return statearr_114710;
})();
var statearr_114711_114721 = state_114706__$1;
(statearr_114711_114721[(2)] = inst_114692);


cljs.core.async.impl.ioc_helpers.process_exception(state_114706__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_114712 = [null,null,null,null,null,null,null,null];
(statearr_114712[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_114712[(1)] = (1));

return statearr_114712;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_114706){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114706);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114713){if((e114713 instanceof Object)){
var ex__99040__auto__ = e114713;
var statearr_114714_114722 = state_114706;
(statearr_114714_114722[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114706);

return cljs.core.cst$kw$recur;
} else {
throw e114713;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114723 = state_114706;
state_114706 = G__114723;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_114706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_114706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114715 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114715[(6)] = c__99059__auto__);

return statearr_114715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq114682){
var G__114683 = cljs.core.first(seq114682);
var seq114682__$1 = cljs.core.next(seq114682);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__114683,seq114682__$1);
});

/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114750){
var state_val_114751 = (state_114750[(1)]);
if((state_val_114751 === (1))){
var state_114750__$1 = state_114750;
var statearr_114752_114764 = state_114750__$1;
(statearr_114752_114764[(2)] = null);

(statearr_114752_114764[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114751 === (2))){
var inst_114748 = (state_114750[(2)]);
var state_114750__$1 = state_114750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114750__$1,inst_114748);
} else {
if((state_val_114751 === (3))){
var inst_114724 = (state_114750[(2)]);
var state_114750__$1 = state_114750;
var statearr_114753_114765 = state_114750__$1;
(statearr_114753_114765[(2)] = inst_114724);


cljs.core.async.impl.ioc_helpers.process_exception(state_114750__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114751 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114750,(3),Error,null,(2));
var inst_114728 = fluree.db.util.async.channel_QMARK_(str);
var state_114750__$1 = state_114750;
if(inst_114728){
var statearr_114754_114766 = state_114750__$1;
(statearr_114754_114766[(1)] = (5));

} else {
var statearr_114755_114767 = state_114750__$1;
(statearr_114755_114767[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114751 === (5))){
var state_114750__$1 = state_114750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114750__$1,(8),str);
} else {
if((state_val_114751 === (6))){
var state_114750__$1 = state_114750;
var statearr_114756_114768 = state_114750__$1;
(statearr_114756_114768[(2)] = str);

(statearr_114756_114768[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114751 === (7))){
var inst_114735 = (state_114750[(2)]);
var inst_114736 = fluree.db.dbfunctions.internal.lower_case(inst_114735);
var inst_114737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114738 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114740 = [inst_114735];
var inst_114741 = (new cljs.core.PersistentVector(null,1,(5),inst_114739,inst_114740,null));
var inst_114742 = ["lower-case",inst_114741,inst_114736];
var inst_114743 = cljs.core.PersistentHashMap.fromArrays(inst_114738,inst_114742);
var inst_114744 = [inst_114743,(10)];
var inst_114745 = (new cljs.core.PersistentVector(null,2,(5),inst_114737,inst_114744,null));
var inst_114746 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114745);
var state_114750__$1 = (function (){var statearr_114757 = state_114750;
(statearr_114757[(7)] = inst_114746);

return statearr_114757;
})();
var statearr_114758_114769 = state_114750__$1;
(statearr_114758_114769[(2)] = inst_114736);


cljs.core.async.impl.ioc_helpers.process_exception(state_114750__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114751 === (8))){
var inst_114731 = (state_114750[(2)]);
var inst_114732 = fluree.db.util.async.throw_err(inst_114731);
var state_114750__$1 = state_114750;
var statearr_114759_114770 = state_114750__$1;
(statearr_114759_114770[(2)] = inst_114732);

(statearr_114759_114770[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____0 = (function (){
var statearr_114760 = [null,null,null,null,null,null,null,null];
(statearr_114760[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__);

(statearr_114760[(1)] = (1));

return statearr_114760;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____1 = (function (state_114750){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114750);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114761){if((e114761 instanceof Object)){
var ex__99040__auto__ = e114761;
var statearr_114762_114771 = state_114750;
(statearr_114762_114771[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114750);

return cljs.core.cst$kw$recur;
} else {
throw e114761;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114772 = state_114750;
state_114750 = G__114772;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__ = function(state_114750){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____1.call(this,state_114750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114763 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114763[(6)] = c__99059__auto__);

return statearr_114763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114799){
var state_val_114800 = (state_114799[(1)]);
if((state_val_114800 === (1))){
var state_114799__$1 = state_114799;
var statearr_114801_114813 = state_114799__$1;
(statearr_114801_114813[(2)] = null);

(statearr_114801_114813[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114800 === (2))){
var inst_114797 = (state_114799[(2)]);
var state_114799__$1 = state_114799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114799__$1,inst_114797);
} else {
if((state_val_114800 === (3))){
var inst_114773 = (state_114799[(2)]);
var state_114799__$1 = state_114799;
var statearr_114802_114814 = state_114799__$1;
(statearr_114802_114814[(2)] = inst_114773);


cljs.core.async.impl.ioc_helpers.process_exception(state_114799__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114800 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114799,(3),Error,null,(2));
var inst_114777 = fluree.db.util.async.channel_QMARK_(str);
var state_114799__$1 = state_114799;
if(inst_114777){
var statearr_114803_114815 = state_114799__$1;
(statearr_114803_114815[(1)] = (5));

} else {
var statearr_114804_114816 = state_114799__$1;
(statearr_114804_114816[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114800 === (5))){
var state_114799__$1 = state_114799;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114799__$1,(8),str);
} else {
if((state_val_114800 === (6))){
var state_114799__$1 = state_114799;
var statearr_114805_114817 = state_114799__$1;
(statearr_114805_114817[(2)] = str);

(statearr_114805_114817[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114800 === (7))){
var inst_114784 = (state_114799[(2)]);
var inst_114785 = fluree.db.dbfunctions.internal.upper_case(inst_114784);
var inst_114786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114787 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114789 = [inst_114784];
var inst_114790 = (new cljs.core.PersistentVector(null,1,(5),inst_114788,inst_114789,null));
var inst_114791 = ["upper-case",inst_114790,inst_114785];
var inst_114792 = cljs.core.PersistentHashMap.fromArrays(inst_114787,inst_114791);
var inst_114793 = [inst_114792,(10)];
var inst_114794 = (new cljs.core.PersistentVector(null,2,(5),inst_114786,inst_114793,null));
var inst_114795 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114794);
var state_114799__$1 = (function (){var statearr_114806 = state_114799;
(statearr_114806[(7)] = inst_114795);

return statearr_114806;
})();
var statearr_114807_114818 = state_114799__$1;
(statearr_114807_114818[(2)] = inst_114785);


cljs.core.async.impl.ioc_helpers.process_exception(state_114799__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114800 === (8))){
var inst_114780 = (state_114799[(2)]);
var inst_114781 = fluree.db.util.async.throw_err(inst_114780);
var state_114799__$1 = state_114799;
var statearr_114808_114819 = state_114799__$1;
(statearr_114808_114819[(2)] = inst_114781);

(statearr_114808_114819[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____0 = (function (){
var statearr_114809 = [null,null,null,null,null,null,null,null];
(statearr_114809[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__);

(statearr_114809[(1)] = (1));

return statearr_114809;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____1 = (function (state_114799){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114799);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114810){if((e114810 instanceof Object)){
var ex__99040__auto__ = e114810;
var statearr_114811_114820 = state_114799;
(statearr_114811_114820[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114799);

return cljs.core.cst$kw$recur;
} else {
throw e114810;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114821 = state_114799;
state_114799 = G__114821;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__ = function(state_114799){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____1.call(this,state_114799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114812 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114812[(6)] = c__99059__auto__);

return statearr_114812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4120__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4120__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__114823 = arguments.length;
switch (G__114823) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114848){
var state_val_114849 = (state_114848[(1)]);
if((state_val_114849 === (1))){
var state_114848__$1 = state_114848;
var statearr_114850_114859 = state_114848__$1;
(statearr_114850_114859[(2)] = null);

(statearr_114850_114859[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114849 === (2))){
var inst_114846 = (state_114848[(2)]);
var state_114848__$1 = state_114848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114848__$1,inst_114846);
} else {
if((state_val_114849 === (3))){
var inst_114824 = (state_114848[(2)]);
var state_114848__$1 = state_114848;
var statearr_114851_114860 = state_114848__$1;
(statearr_114851_114860[(2)] = inst_114824);


cljs.core.async.impl.ioc_helpers.process_exception(state_114848__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114849 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114848,(3),Error,null,(2));
var inst_114831 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_114848__$1 = state_114848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114848__$1,(5),inst_114831);
} else {
if((state_val_114849 === (5))){
var inst_114833 = (state_114848[(2)]);
var inst_114834 = fluree.db.util.async.throw_err(inst_114833);
var inst_114835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114834,(0),null);
var inst_114836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114834,(1),null);
var inst_114837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114838 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114839 = ["?s","?ctx",inst_114835];
var inst_114840 = cljs.core.PersistentHashMap.fromArrays(inst_114838,inst_114839);
var inst_114841 = ((10) + inst_114836);
var inst_114842 = [inst_114840,inst_114841];
var inst_114843 = (new cljs.core.PersistentVector(null,2,(5),inst_114837,inst_114842,null));
var inst_114844 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114843);
var state_114848__$1 = (function (){var statearr_114852 = state_114848;
(statearr_114852[(7)] = inst_114844);

return statearr_114852;
})();
var statearr_114853_114861 = state_114848__$1;
(statearr_114853_114861[(2)] = inst_114835);


cljs.core.async.impl.ioc_helpers.process_exception(state_114848__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_114854 = [null,null,null,null,null,null,null,null];
(statearr_114854[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_114854[(1)] = (1));

return statearr_114854;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_114848){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114848);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114855){if((e114855 instanceof Object)){
var ex__99040__auto__ = e114855;
var statearr_114856_114862 = state_114848;
(statearr_114856_114862[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114848);

return cljs.core.cst$kw$recur;
} else {
throw e114855;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114863 = state_114848;
state_114848 = G__114863;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_114848){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_114848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114857 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114857[(6)] = c__99059__auto__);

return statearr_114857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2;

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__114865 = arguments.length;
switch (G__114865) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114900){
var state_val_114901 = (state_114900[(1)]);
if((state_val_114901 === (7))){
var inst_114896 = (state_114900[(2)]);
var state_114900__$1 = state_114900;
var statearr_114902_114915 = state_114900__$1;
(statearr_114902_114915[(2)] = inst_114896);


cljs.core.async.impl.ioc_helpers.process_exception(state_114900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114901 === (1))){
var state_114900__$1 = state_114900;
var statearr_114903_114916 = state_114900__$1;
(statearr_114903_114916[(2)] = null);

(statearr_114903_114916[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114901 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114900,(3),Error,null,(2));
var inst_114870 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_114900__$1 = state_114900;
if(cljs.core.truth_(inst_114870)){
var statearr_114904_114917 = state_114900__$1;
(statearr_114904_114917[(1)] = (5));

} else {
var statearr_114905_114918 = state_114900__$1;
(statearr_114905_114918[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114901 === (6))){
var inst_114894 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_114900__$1 = state_114900;
var statearr_114906_114919 = state_114900__$1;
(statearr_114906_114919[(2)] = inst_114894);

(statearr_114906_114919[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114901 === (3))){
var inst_114866 = (state_114900[(2)]);
var state_114900__$1 = state_114900;
var statearr_114907_114920 = state_114900__$1;
(statearr_114907_114920[(2)] = inst_114866);


cljs.core.async.impl.ioc_helpers.process_exception(state_114900__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114901 === (2))){
var inst_114898 = (state_114900[(2)]);
var state_114900__$1 = state_114900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114900__$1,inst_114898);
} else {
if((state_val_114901 === (9))){
var inst_114877 = (state_114900[(2)]);
var inst_114878 = fluree.db.util.async.throw_err(inst_114877);
var inst_114879 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_114878);
var state_114900__$1 = state_114900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114900__$1,(8),inst_114879);
} else {
if((state_val_114901 === (5))){
var inst_114875 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_114900__$1 = state_114900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114900__$1,(9),inst_114875);
} else {
if((state_val_114901 === (8))){
var inst_114881 = (state_114900[(2)]);
var inst_114882 = fluree.db.util.async.throw_err(inst_114881);
var inst_114883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114882,(0),null);
var inst_114884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114882,(1),null);
var inst_114885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114886 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114887 = ["?p","?ctx",inst_114883];
var inst_114888 = cljs.core.PersistentHashMap.fromArrays(inst_114886,inst_114887);
var inst_114889 = ((10) + inst_114884);
var inst_114890 = [inst_114888,inst_114889];
var inst_114891 = (new cljs.core.PersistentVector(null,2,(5),inst_114885,inst_114890,null));
var inst_114892 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114891);
var state_114900__$1 = (function (){var statearr_114908 = state_114900;
(statearr_114908[(7)] = inst_114892);

return statearr_114908;
})();
var statearr_114909_114921 = state_114900__$1;
(statearr_114909_114921[(2)] = inst_114883);

(statearr_114909_114921[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_114910 = [null,null,null,null,null,null,null,null];
(statearr_114910[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_114910[(1)] = (1));

return statearr_114910;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_114900){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114900);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114911){if((e114911 instanceof Object)){
var ex__99040__auto__ = e114911;
var statearr_114912_114922 = state_114900;
(statearr_114912_114922[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114900);

return cljs.core.cst$kw$recur;
} else {
throw e114911;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114923 = state_114900;
state_114900 = G__114923;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_114900){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_114900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114913 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114913[(6)] = c__99059__auto__);

return statearr_114913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2;

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4736__auto__ = [];
var len__4730__auto___114962 = arguments.length;
var i__4731__auto___114963 = (0);
while(true){
if((i__4731__auto___114963 < len__4730__auto___114962)){
args__4736__auto__.push((arguments[i__4731__auto___114963]));

var G__114964 = (i__4731__auto___114963 + (1));
i__4731__auto___114963 = G__114964;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114952){
var state_val_114953 = (state_114952[(1)]);
if((state_val_114953 === (1))){
var state_114952__$1 = state_114952;
var statearr_114954_114965 = state_114952__$1;
(statearr_114954_114965[(2)] = null);

(statearr_114954_114965[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114953 === (2))){
var inst_114950 = (state_114952[(2)]);
var state_114952__$1 = state_114952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114952__$1,inst_114950);
} else {
if((state_val_114953 === (3))){
var inst_114926 = (state_114952[(2)]);
var state_114952__$1 = state_114952;
var statearr_114955_114966 = state_114952__$1;
(statearr_114955_114966[(2)] = inst_114926);


cljs.core.async.impl.ioc_helpers.process_exception(state_114952__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114953 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114952,(3),Error,null,(2));
var inst_114930 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_114952__$1 = state_114952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114952__$1,(5),inst_114930);
} else {
if((state_val_114953 === (5))){
var inst_114932 = (state_114952[(2)]);
var inst_114933 = fluree.db.util.async.throw_err(inst_114932);
var inst_114934 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_114933);
var inst_114935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114936 = [inst_114933];
var inst_114937 = (new cljs.core.PersistentVector(null,1,(5),inst_114935,inst_114936,null));
var inst_114938 = cljs.core.count(inst_114937);
var inst_114939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114940 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114942 = [inst_114933];
var inst_114943 = (new cljs.core.PersistentVector(null,1,(5),inst_114941,inst_114942,null));
var inst_114944 = ["and",inst_114943,inst_114934];
var inst_114945 = cljs.core.PersistentHashMap.fromArrays(inst_114940,inst_114944);
var inst_114946 = [inst_114945,inst_114938];
var inst_114947 = (new cljs.core.PersistentVector(null,2,(5),inst_114939,inst_114946,null));
var inst_114948 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114947);
var state_114952__$1 = (function (){var statearr_114956 = state_114952;
(statearr_114956[(7)] = inst_114948);

return statearr_114956;
})();
var statearr_114957_114967 = state_114952__$1;
(statearr_114957_114967[(2)] = inst_114934);


cljs.core.async.impl.ioc_helpers.process_exception(state_114952__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_114958 = [null,null,null,null,null,null,null,null];
(statearr_114958[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_114958[(1)] = (1));

return statearr_114958;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_114952){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114952);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114959){if((e114959 instanceof Object)){
var ex__99040__auto__ = e114959;
var statearr_114960_114968 = state_114952;
(statearr_114960_114968[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114952);

return cljs.core.cst$kw$recur;
} else {
throw e114959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114969 = state_114952;
state_114952 = G__114969;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_114952){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_114952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114961 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114961[(6)] = c__99059__auto__);

return statearr_114961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq114924){
var G__114925 = cljs.core.first(seq114924);
var seq114924__$1 = cljs.core.next(seq114924);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__114925,seq114924__$1);
});

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115008 = arguments.length;
var i__4731__auto___115009 = (0);
while(true){
if((i__4731__auto___115009 < len__4730__auto___115008)){
args__4736__auto__.push((arguments[i__4731__auto___115009]));

var G__115010 = (i__4731__auto___115009 + (1));
i__4731__auto___115009 = G__115010;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114998){
var state_val_114999 = (state_114998[(1)]);
if((state_val_114999 === (1))){
var state_114998__$1 = state_114998;
var statearr_115000_115011 = state_114998__$1;
(statearr_115000_115011[(2)] = null);

(statearr_115000_115011[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114999 === (2))){
var inst_114996 = (state_114998[(2)]);
var state_114998__$1 = state_114998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114998__$1,inst_114996);
} else {
if((state_val_114999 === (3))){
var inst_114972 = (state_114998[(2)]);
var state_114998__$1 = state_114998;
var statearr_115001_115012 = state_114998__$1;
(statearr_115001_115012[(2)] = inst_114972);


cljs.core.async.impl.ioc_helpers.process_exception(state_114998__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114999 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114998,(3),Error,null,(2));
var inst_114976 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_114998__$1 = state_114998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114998__$1,(5),inst_114976);
} else {
if((state_val_114999 === (5))){
var inst_114978 = (state_114998[(2)]);
var inst_114979 = fluree.db.util.async.throw_err(inst_114978);
var inst_114980 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_114979);
var inst_114981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114982 = [inst_114979];
var inst_114983 = (new cljs.core.PersistentVector(null,1,(5),inst_114981,inst_114982,null));
var inst_114984 = cljs.core.count(inst_114983);
var inst_114985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114986 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_114987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114988 = [inst_114979];
var inst_114989 = (new cljs.core.PersistentVector(null,1,(5),inst_114987,inst_114988,null));
var inst_114990 = ["or",inst_114989,inst_114980];
var inst_114991 = cljs.core.PersistentHashMap.fromArrays(inst_114986,inst_114990);
var inst_114992 = [inst_114991,inst_114984];
var inst_114993 = (new cljs.core.PersistentVector(null,2,(5),inst_114985,inst_114992,null));
var inst_114994 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_114993);
var state_114998__$1 = (function (){var statearr_115002 = state_114998;
(statearr_115002[(7)] = inst_114994);

return statearr_115002;
})();
var statearr_115003_115013 = state_114998__$1;
(statearr_115003_115013[(2)] = inst_114980);


cljs.core.async.impl.ioc_helpers.process_exception(state_114998__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115004 = [null,null,null,null,null,null,null,null];
(statearr_115004[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115004[(1)] = (1));

return statearr_115004;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_114998){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114998);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115005){if((e115005 instanceof Object)){
var ex__99040__auto__ = e115005;
var statearr_115006_115014 = state_114998;
(statearr_115006_115014[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114998);

return cljs.core.cst$kw$recur;
} else {
throw e115005;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115015 = state_114998;
state_114998 = G__115015;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_114998){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_114998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115007 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115007[(6)] = c__99059__auto__);

return statearr_115007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq114970){
var G__114971 = cljs.core.first(seq114970);
var seq114970__$1 = cljs.core.next(seq114970);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__114971,seq114970__$1);
});

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115050){
var state_val_115051 = (state_115050[(1)]);
if((state_val_115051 === (7))){
var inst_115036 = (state_115050[(2)]);
var inst_115037 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_115036);
var inst_115038 = cljs.core.count(inst_115037);
var inst_115039 = ((9) + inst_115038);
var inst_115040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115041 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115042 = ["count",inst_115036,inst_115038];
var inst_115043 = cljs.core.PersistentHashMap.fromArrays(inst_115041,inst_115042);
var inst_115044 = [inst_115043,inst_115039];
var inst_115045 = (new cljs.core.PersistentVector(null,2,(5),inst_115040,inst_115044,null));
var inst_115046 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115045);
var state_115050__$1 = (function (){var statearr_115052 = state_115050;
(statearr_115052[(7)] = inst_115046);

return statearr_115052;
})();
var statearr_115053_115068 = state_115050__$1;
(statearr_115053_115068[(2)] = inst_115038);


cljs.core.async.impl.ioc_helpers.process_exception(state_115050__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (1))){
var state_115050__$1 = state_115050;
var statearr_115054_115069 = state_115050__$1;
(statearr_115054_115069[(2)] = null);

(statearr_115054_115069[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115050,(3),Error,null,(2));
var inst_115020 = cljs.core.vector_QMARK_(coll);
var state_115050__$1 = state_115050;
if(inst_115020){
var statearr_115055_115070 = state_115050__$1;
(statearr_115055_115070[(1)] = (5));

} else {
var statearr_115056_115071 = state_115050__$1;
(statearr_115056_115071[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (6))){
var inst_115027 = fluree.db.util.async.channel_QMARK_(coll);
var state_115050__$1 = state_115050;
if(inst_115027){
var statearr_115057_115072 = state_115050__$1;
(statearr_115057_115072[(1)] = (9));

} else {
var statearr_115058_115073 = state_115050__$1;
(statearr_115058_115073[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (3))){
var inst_115016 = (state_115050[(2)]);
var state_115050__$1 = state_115050;
var statearr_115059_115074 = state_115050__$1;
(statearr_115059_115074[(2)] = inst_115016);


cljs.core.async.impl.ioc_helpers.process_exception(state_115050__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (12))){
var inst_115030 = (state_115050[(2)]);
var inst_115031 = fluree.db.util.async.throw_err(inst_115030);
var state_115050__$1 = state_115050;
var statearr_115060_115075 = state_115050__$1;
(statearr_115060_115075[(2)] = inst_115031);

(statearr_115060_115075[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (2))){
var inst_115048 = (state_115050[(2)]);
var state_115050__$1 = state_115050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115050__$1,inst_115048);
} else {
if((state_val_115051 === (11))){
var inst_115034 = (state_115050[(2)]);
var state_115050__$1 = state_115050;
var statearr_115061_115076 = state_115050__$1;
(statearr_115061_115076[(2)] = inst_115034);

(statearr_115061_115076[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (9))){
var state_115050__$1 = state_115050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115050__$1,(12),coll);
} else {
if((state_val_115051 === (5))){
var inst_115022 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_115050__$1 = state_115050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115050__$1,(8),inst_115022);
} else {
if((state_val_115051 === (10))){
var state_115050__$1 = state_115050;
var statearr_115062_115077 = state_115050__$1;
(statearr_115062_115077[(2)] = coll);

(statearr_115062_115077[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115051 === (8))){
var inst_115024 = (state_115050[(2)]);
var inst_115025 = fluree.db.util.async.throw_err(inst_115024);
var state_115050__$1 = state_115050;
var statearr_115063_115078 = state_115050__$1;
(statearr_115063_115078[(2)] = inst_115025);

(statearr_115063_115078[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____0 = (function (){
var statearr_115064 = [null,null,null,null,null,null,null,null];
(statearr_115064[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__);

(statearr_115064[(1)] = (1));

return statearr_115064;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____1 = (function (state_115050){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115050);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115065){if((e115065 instanceof Object)){
var ex__99040__auto__ = e115065;
var statearr_115066_115079 = state_115050;
(statearr_115066_115079[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115050);

return cljs.core.cst$kw$recur;
} else {
throw e115065;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115080 = state_115050;
state_115050 = G__115080;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__ = function(state_115050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____1.call(this,state_115050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115067 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115067[(6)] = c__99059__auto__);

return statearr_115067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115127){
var state_val_115128 = (state_115127[(1)]);
if((state_val_115128 === (7))){
var inst_115092 = (state_115127[(2)]);
var inst_115093 = fluree.db.util.async.channel_QMARK_(pred);
var state_115127__$1 = (function (){var statearr_115129 = state_115127;
(statearr_115129[(7)] = inst_115092);

return statearr_115129;
})();
if(inst_115093){
var statearr_115130_115155 = state_115127__$1;
(statearr_115130_115155[(1)] = (9));

} else {
var statearr_115131_115156 = state_115127__$1;
(statearr_115131_115156[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (1))){
var state_115127__$1 = state_115127;
var statearr_115132_115157 = state_115127__$1;
(statearr_115132_115157[(2)] = null);

(statearr_115132_115157[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115127,(3),Error,null,(2));
var inst_115085 = fluree.db.util.async.channel_QMARK_(subject);
var state_115127__$1 = state_115127;
if(inst_115085){
var statearr_115133_115158 = state_115127__$1;
(statearr_115133_115158[(1)] = (5));

} else {
var statearr_115134_115159 = state_115127__$1;
(statearr_115134_115159[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (15))){
var inst_115092 = (state_115127[(7)]);
var inst_115100 = (state_115127[(8)]);
var inst_115112 = (state_115127[(2)]);
var inst_115113 = fluree.db.dbfunctions.internal.get(inst_115112,inst_115100);
var inst_115114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115115 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115117 = [inst_115092,inst_115100];
var inst_115118 = (new cljs.core.PersistentVector(null,2,(5),inst_115116,inst_115117,null));
var inst_115119 = ["get",inst_115118,inst_115113];
var inst_115120 = cljs.core.PersistentHashMap.fromArrays(inst_115115,inst_115119);
var inst_115121 = [inst_115120,(10)];
var inst_115122 = (new cljs.core.PersistentVector(null,2,(5),inst_115114,inst_115121,null));
var inst_115123 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115122);
var state_115127__$1 = (function (){var statearr_115135 = state_115127;
(statearr_115135[(9)] = inst_115123);

return statearr_115135;
})();
var statearr_115136_115160 = state_115127__$1;
(statearr_115136_115160[(2)] = inst_115113);


cljs.core.async.impl.ioc_helpers.process_exception(state_115127__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (13))){
var inst_115092 = (state_115127[(7)]);
var inst_115103 = cljs.core.count(inst_115092);
var inst_115104 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_115103);
var state_115127__$1 = state_115127;
if(inst_115104){
var statearr_115137_115161 = state_115127__$1;
(statearr_115137_115161[(1)] = (16));

} else {
var statearr_115138_115162 = state_115127__$1;
(statearr_115138_115162[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (6))){
var state_115127__$1 = state_115127;
var statearr_115139_115163 = state_115127__$1;
(statearr_115139_115163[(2)] = subject);

(statearr_115139_115163[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (17))){
var inst_115092 = (state_115127[(7)]);
var state_115127__$1 = state_115127;
var statearr_115140_115164 = state_115127__$1;
(statearr_115140_115164[(2)] = inst_115092);

(statearr_115140_115164[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (3))){
var inst_115081 = (state_115127[(2)]);
var state_115127__$1 = state_115127;
var statearr_115141_115165 = state_115127__$1;
(statearr_115141_115165[(2)] = inst_115081);


cljs.core.async.impl.ioc_helpers.process_exception(state_115127__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (12))){
var inst_115096 = (state_115127[(2)]);
var inst_115097 = fluree.db.util.async.throw_err(inst_115096);
var state_115127__$1 = state_115127;
var statearr_115142_115166 = state_115127__$1;
(statearr_115142_115166[(2)] = inst_115097);

(statearr_115142_115166[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (2))){
var inst_115125 = (state_115127[(2)]);
var state_115127__$1 = state_115127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115127__$1,inst_115125);
} else {
if((state_val_115128 === (11))){
var inst_115092 = (state_115127[(7)]);
var inst_115100 = (state_115127[(2)]);
var inst_115101 = cljs.core.vector_QMARK_(inst_115092);
var state_115127__$1 = (function (){var statearr_115143 = state_115127;
(statearr_115143[(8)] = inst_115100);

return statearr_115143;
})();
if(inst_115101){
var statearr_115144_115167 = state_115127__$1;
(statearr_115144_115167[(1)] = (13));

} else {
var statearr_115145_115168 = state_115127__$1;
(statearr_115145_115168[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (9))){
var state_115127__$1 = state_115127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115127__$1,(12),pred);
} else {
if((state_val_115128 === (5))){
var state_115127__$1 = state_115127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115127__$1,(8),subject);
} else {
if((state_val_115128 === (14))){
var inst_115092 = (state_115127[(7)]);
var state_115127__$1 = state_115127;
var statearr_115146_115169 = state_115127__$1;
(statearr_115146_115169[(2)] = inst_115092);

(statearr_115146_115169[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (16))){
var inst_115092 = (state_115127[(7)]);
var inst_115106 = cljs.core.first(inst_115092);
var state_115127__$1 = state_115127;
var statearr_115147_115170 = state_115127__$1;
(statearr_115147_115170[(2)] = inst_115106);

(statearr_115147_115170[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (10))){
var state_115127__$1 = state_115127;
var statearr_115148_115171 = state_115127__$1;
(statearr_115148_115171[(2)] = pred);

(statearr_115148_115171[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (18))){
var inst_115109 = (state_115127[(2)]);
var state_115127__$1 = state_115127;
var statearr_115149_115172 = state_115127__$1;
(statearr_115149_115172[(2)] = inst_115109);

(statearr_115149_115172[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115128 === (8))){
var inst_115088 = (state_115127[(2)]);
var inst_115089 = fluree.db.util.async.throw_err(inst_115088);
var state_115127__$1 = state_115127;
var statearr_115150_115173 = state_115127__$1;
(statearr_115150_115173[(2)] = inst_115089);

(statearr_115150_115173[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____0 = (function (){
var statearr_115151 = [null,null,null,null,null,null,null,null,null,null];
(statearr_115151[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__);

(statearr_115151[(1)] = (1));

return statearr_115151;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____1 = (function (state_115127){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115127);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115152){if((e115152 instanceof Object)){
var ex__99040__auto__ = e115152;
var statearr_115153_115174 = state_115127;
(statearr_115153_115174[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115127);

return cljs.core.cst$kw$recur;
} else {
throw e115152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115175 = state_115127;
state_115127 = G__115175;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__ = function(state_115127){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____1.call(this,state_115127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115154 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115154[(6)] = c__99059__auto__);

return statearr_115154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115211){
var state_val_115212 = (state_115211[(1)]);
if((state_val_115212 === (7))){
var inst_115185 = (state_115211[(2)]);
var state_115211__$1 = state_115211;
if(cljs.core.truth_(inst_115185)){
var statearr_115213_115230 = state_115211__$1;
(statearr_115213_115230[(1)] = (8));

} else {
var statearr_115214_115231 = state_115211__$1;
(statearr_115214_115231[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (1))){
var state_115211__$1 = state_115211;
var statearr_115215_115232 = state_115211__$1;
(statearr_115215_115232[(2)] = null);

(statearr_115215_115232[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (4))){
var inst_115180 = (state_115211[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115211,(3),Error,null,(2));
var inst_115180__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_115211__$1 = (function (){var statearr_115216 = state_115211;
(statearr_115216[(7)] = inst_115180__$1);

return statearr_115216;
})();
if(cljs.core.truth_(inst_115180__$1)){
var statearr_115217_115233 = state_115211__$1;
(statearr_115217_115233[(1)] = (5));

} else {
var statearr_115218_115234 = state_115211__$1;
(statearr_115218_115234[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (6))){
var inst_115180 = (state_115211[(7)]);
var state_115211__$1 = state_115211;
var statearr_115219_115235 = state_115211__$1;
(statearr_115219_115235[(2)] = inst_115180);

(statearr_115219_115235[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (3))){
var inst_115176 = (state_115211[(2)]);
var state_115211__$1 = state_115211;
var statearr_115220_115236 = state_115211__$1;
(statearr_115220_115236[(2)] = inst_115176);


cljs.core.async.impl.ioc_helpers.process_exception(state_115211__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (2))){
var inst_115209 = (state_115211[(2)]);
var state_115211__$1 = state_115211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115211__$1,inst_115209);
} else {
if((state_val_115212 === (11))){
var inst_115192 = (state_115211[(2)]);
var inst_115193 = fluree.db.util.async.throw_err(inst_115192);
var inst_115194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115193,(0),null);
var inst_115195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115193,(1),null);
var inst_115196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115197 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115198 = ["?pO","?ctx",inst_115194];
var inst_115199 = cljs.core.PersistentHashMap.fromArrays(inst_115197,inst_115198);
var inst_115200 = ((10) + inst_115195);
var inst_115201 = [inst_115199,inst_115200];
var inst_115202 = (new cljs.core.PersistentVector(null,2,(5),inst_115196,inst_115201,null));
var inst_115203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115202);
var state_115211__$1 = (function (){var statearr_115221 = state_115211;
(statearr_115221[(8)] = inst_115203);

return statearr_115221;
})();
var statearr_115222_115237 = state_115211__$1;
(statearr_115222_115237[(2)] = inst_115194);

(statearr_115222_115237[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (9))){
var inst_115205 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_115211__$1 = state_115211;
var statearr_115223_115238 = state_115211__$1;
(statearr_115223_115238[(2)] = inst_115205);

(statearr_115223_115238[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (5))){
var inst_115182 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_115211__$1 = state_115211;
var statearr_115224_115239 = state_115211__$1;
(statearr_115224_115239[(2)] = inst_115182);

(statearr_115224_115239[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (10))){
var inst_115207 = (state_115211[(2)]);
var state_115211__$1 = state_115211;
var statearr_115225_115240 = state_115211__$1;
(statearr_115225_115240[(2)] = inst_115207);


cljs.core.async.impl.ioc_helpers.process_exception(state_115211__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115212 === (8))){
var inst_115190 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_115211__$1 = state_115211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115211__$1,(11),inst_115190);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____0 = (function (){
var statearr_115226 = [null,null,null,null,null,null,null,null,null];
(statearr_115226[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__);

(statearr_115226[(1)] = (1));

return statearr_115226;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____1 = (function (state_115211){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115211);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115227){if((e115227 instanceof Object)){
var ex__99040__auto__ = e115227;
var statearr_115228_115241 = state_115211;
(statearr_115228_115241[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115211);

return cljs.core.cst$kw$recur;
} else {
throw e115227;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115242 = state_115211;
state_115211 = G__115242;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__ = function(state_115211){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____1.call(this,state_115211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115229 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115229[(6)] = c__99059__auto__);

return statearr_115229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115291){
var state_val_115292 = (state_115291[(1)]);
if((state_val_115292 === (7))){
var inst_115254 = (state_115291[(2)]);
var inst_115255 = fluree.db.util.async.channel_QMARK_(path);
var state_115291__$1 = (function (){var statearr_115293 = state_115291;
(statearr_115293[(7)] = inst_115254);

return statearr_115293;
})();
if(inst_115255){
var statearr_115294_115319 = state_115291__$1;
(statearr_115294_115319[(1)] = (9));

} else {
var statearr_115295_115320 = state_115291__$1;
(statearr_115295_115320[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (1))){
var state_115291__$1 = state_115291;
var statearr_115296_115321 = state_115291__$1;
(statearr_115296_115321[(2)] = null);

(statearr_115296_115321[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115291,(3),Error,null,(2));
var inst_115247 = fluree.db.util.async.channel_QMARK_(subject);
var state_115291__$1 = state_115291;
if(inst_115247){
var statearr_115297_115322 = state_115291__$1;
(statearr_115297_115322[(1)] = (5));

} else {
var statearr_115298_115323 = state_115291__$1;
(statearr_115298_115323[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (15))){
var inst_115262 = (state_115291[(8)]);
var inst_115254 = (state_115291[(7)]);
var inst_115274 = (state_115291[(2)]);
var inst_115275 = fluree.db.dbfunctions.internal.get_all(inst_115274,inst_115262);
var inst_115276 = cljs.core.count(inst_115262);
var inst_115277 = ((9) + inst_115276);
var inst_115278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115279 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115281 = [inst_115254,inst_115262];
var inst_115282 = (new cljs.core.PersistentVector(null,2,(5),inst_115280,inst_115281,null));
var inst_115283 = ["get-all",inst_115282,inst_115275];
var inst_115284 = cljs.core.PersistentHashMap.fromArrays(inst_115279,inst_115283);
var inst_115285 = [inst_115284,inst_115277];
var inst_115286 = (new cljs.core.PersistentVector(null,2,(5),inst_115278,inst_115285,null));
var inst_115287 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115286);
var state_115291__$1 = (function (){var statearr_115299 = state_115291;
(statearr_115299[(9)] = inst_115287);

return statearr_115299;
})();
var statearr_115300_115324 = state_115291__$1;
(statearr_115300_115324[(2)] = inst_115275);


cljs.core.async.impl.ioc_helpers.process_exception(state_115291__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (13))){
var inst_115254 = (state_115291[(7)]);
var inst_115265 = cljs.core.count(inst_115254);
var inst_115266 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_115265);
var state_115291__$1 = state_115291;
if(inst_115266){
var statearr_115301_115325 = state_115291__$1;
(statearr_115301_115325[(1)] = (16));

} else {
var statearr_115302_115326 = state_115291__$1;
(statearr_115302_115326[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (6))){
var state_115291__$1 = state_115291;
var statearr_115303_115327 = state_115291__$1;
(statearr_115303_115327[(2)] = subject);

(statearr_115303_115327[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (17))){
var inst_115254 = (state_115291[(7)]);
var state_115291__$1 = state_115291;
var statearr_115304_115328 = state_115291__$1;
(statearr_115304_115328[(2)] = inst_115254);

(statearr_115304_115328[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (3))){
var inst_115243 = (state_115291[(2)]);
var state_115291__$1 = state_115291;
var statearr_115305_115329 = state_115291__$1;
(statearr_115305_115329[(2)] = inst_115243);


cljs.core.async.impl.ioc_helpers.process_exception(state_115291__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (12))){
var inst_115258 = (state_115291[(2)]);
var inst_115259 = fluree.db.util.async.throw_err(inst_115258);
var state_115291__$1 = state_115291;
var statearr_115306_115330 = state_115291__$1;
(statearr_115306_115330[(2)] = inst_115259);

(statearr_115306_115330[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (2))){
var inst_115289 = (state_115291[(2)]);
var state_115291__$1 = state_115291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115291__$1,inst_115289);
} else {
if((state_val_115292 === (11))){
var inst_115254 = (state_115291[(7)]);
var inst_115262 = (state_115291[(2)]);
var inst_115263 = cljs.core.vector_QMARK_(inst_115254);
var state_115291__$1 = (function (){var statearr_115307 = state_115291;
(statearr_115307[(8)] = inst_115262);

return statearr_115307;
})();
if(inst_115263){
var statearr_115308_115331 = state_115291__$1;
(statearr_115308_115331[(1)] = (13));

} else {
var statearr_115309_115332 = state_115291__$1;
(statearr_115309_115332[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (9))){
var state_115291__$1 = state_115291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115291__$1,(12),path);
} else {
if((state_val_115292 === (5))){
var state_115291__$1 = state_115291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115291__$1,(8),subject);
} else {
if((state_val_115292 === (14))){
var inst_115254 = (state_115291[(7)]);
var state_115291__$1 = state_115291;
var statearr_115310_115333 = state_115291__$1;
(statearr_115310_115333[(2)] = inst_115254);

(statearr_115310_115333[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (16))){
var inst_115254 = (state_115291[(7)]);
var inst_115268 = cljs.core.first(inst_115254);
var state_115291__$1 = state_115291;
var statearr_115311_115334 = state_115291__$1;
(statearr_115311_115334[(2)] = inst_115268);

(statearr_115311_115334[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (10))){
var state_115291__$1 = state_115291;
var statearr_115312_115335 = state_115291__$1;
(statearr_115312_115335[(2)] = path);

(statearr_115312_115335[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (18))){
var inst_115271 = (state_115291[(2)]);
var state_115291__$1 = state_115291;
var statearr_115313_115336 = state_115291__$1;
(statearr_115313_115336[(2)] = inst_115271);

(statearr_115313_115336[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115292 === (8))){
var inst_115250 = (state_115291[(2)]);
var inst_115251 = fluree.db.util.async.throw_err(inst_115250);
var state_115291__$1 = state_115291;
var statearr_115314_115337 = state_115291__$1;
(statearr_115314_115337[(2)] = inst_115251);

(statearr_115314_115337[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____0 = (function (){
var statearr_115315 = [null,null,null,null,null,null,null,null,null,null];
(statearr_115315[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__);

(statearr_115315[(1)] = (1));

return statearr_115315;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____1 = (function (state_115291){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115291);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115316){if((e115316 instanceof Object)){
var ex__99040__auto__ = e115316;
var statearr_115317_115338 = state_115291;
(statearr_115317_115338[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115291);

return cljs.core.cst$kw$recur;
} else {
throw e115316;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115339 = state_115291;
state_115291 = G__115339;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__ = function(state_115291){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____1.call(this,state_115291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115318 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115318[(6)] = c__99059__auto__);

return statearr_115318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115375){
var state_val_115376 = (state_115375[(1)]);
if((state_val_115376 === (7))){
var inst_115351 = (state_115375[(2)]);
var inst_115352 = fluree.db.util.async.channel_QMARK_(path);
var state_115375__$1 = (function (){var statearr_115377 = state_115375;
(statearr_115377[(7)] = inst_115351);

return statearr_115377;
})();
if(inst_115352){
var statearr_115378_115394 = state_115375__$1;
(statearr_115378_115394[(1)] = (9));

} else {
var statearr_115379_115395 = state_115375__$1;
(statearr_115379_115395[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (1))){
var state_115375__$1 = state_115375;
var statearr_115380_115396 = state_115375__$1;
(statearr_115380_115396[(2)] = null);

(statearr_115380_115396[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115375,(3),Error,null,(2));
var inst_115344 = fluree.db.util.async.channel_QMARK_(subject);
var state_115375__$1 = state_115375;
if(inst_115344){
var statearr_115381_115397 = state_115375__$1;
(statearr_115381_115397[(1)] = (5));

} else {
var statearr_115382_115398 = state_115375__$1;
(statearr_115382_115398[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (6))){
var state_115375__$1 = state_115375;
var statearr_115383_115399 = state_115375__$1;
(statearr_115383_115399[(2)] = subject);

(statearr_115383_115399[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (3))){
var inst_115340 = (state_115375[(2)]);
var state_115375__$1 = state_115375;
var statearr_115384_115400 = state_115375__$1;
(statearr_115384_115400[(2)] = inst_115340);


cljs.core.async.impl.ioc_helpers.process_exception(state_115375__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (12))){
var inst_115355 = (state_115375[(2)]);
var inst_115356 = fluree.db.util.async.throw_err(inst_115355);
var state_115375__$1 = state_115375;
var statearr_115385_115401 = state_115375__$1;
(statearr_115385_115401[(2)] = inst_115356);

(statearr_115385_115401[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (2))){
var inst_115373 = (state_115375[(2)]);
var state_115375__$1 = state_115375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115375__$1,inst_115373);
} else {
if((state_val_115376 === (11))){
var inst_115351 = (state_115375[(7)]);
var inst_115359 = (state_115375[(2)]);
var inst_115360 = fluree.db.dbfunctions.internal.get_in(inst_115351,inst_115359);
var inst_115361 = cljs.core.count(inst_115359);
var inst_115362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115363 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115365 = [inst_115351,inst_115359];
var inst_115366 = (new cljs.core.PersistentVector(null,2,(5),inst_115364,inst_115365,null));
var inst_115367 = ["get-in",inst_115366,inst_115360];
var inst_115368 = cljs.core.PersistentHashMap.fromArrays(inst_115363,inst_115367);
var inst_115369 = [inst_115368,inst_115361];
var inst_115370 = (new cljs.core.PersistentVector(null,2,(5),inst_115362,inst_115369,null));
var inst_115371 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115370);
var state_115375__$1 = (function (){var statearr_115386 = state_115375;
(statearr_115386[(8)] = inst_115371);

return statearr_115386;
})();
var statearr_115387_115402 = state_115375__$1;
(statearr_115387_115402[(2)] = inst_115360);


cljs.core.async.impl.ioc_helpers.process_exception(state_115375__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (9))){
var state_115375__$1 = state_115375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115375__$1,(12),path);
} else {
if((state_val_115376 === (5))){
var state_115375__$1 = state_115375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115375__$1,(8),subject);
} else {
if((state_val_115376 === (10))){
var state_115375__$1 = state_115375;
var statearr_115388_115403 = state_115375__$1;
(statearr_115388_115403[(2)] = path);

(statearr_115388_115403[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115376 === (8))){
var inst_115347 = (state_115375[(2)]);
var inst_115348 = fluree.db.util.async.throw_err(inst_115347);
var state_115375__$1 = state_115375;
var statearr_115389_115404 = state_115375__$1;
(statearr_115389_115404[(2)] = inst_115348);

(statearr_115389_115404[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____0 = (function (){
var statearr_115390 = [null,null,null,null,null,null,null,null,null];
(statearr_115390[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__);

(statearr_115390[(1)] = (1));

return statearr_115390;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____1 = (function (state_115375){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115375);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115391){if((e115391 instanceof Object)){
var ex__99040__auto__ = e115391;
var statearr_115392_115405 = state_115375;
(statearr_115392_115405[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115375);

return cljs.core.cst$kw$recur;
} else {
throw e115391;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115406 = state_115375;
state_115375 = G__115406;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__ = function(state_115375){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____1.call(this,state_115375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115393 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115393[(6)] = c__99059__auto__);

return statearr_115393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115448){
var state_val_115449 = (state_115448[(1)]);
if((state_val_115449 === (7))){
var inst_115418 = (state_115448[(7)]);
var inst_115418__$1 = (state_115448[(2)]);
var inst_115419 = cljs.core.set_QMARK_(inst_115418__$1);
var state_115448__$1 = (function (){var statearr_115450 = state_115448;
(statearr_115450[(7)] = inst_115418__$1);

return statearr_115450;
})();
if(inst_115419){
var statearr_115451_115472 = state_115448__$1;
(statearr_115451_115472[(1)] = (9));

} else {
var statearr_115452_115473 = state_115448__$1;
(statearr_115452_115473[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (1))){
var state_115448__$1 = state_115448;
var statearr_115453_115474 = state_115448__$1;
(statearr_115453_115474[(2)] = null);

(statearr_115453_115474[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115448,(3),Error,null,(2));
var inst_115411 = fluree.db.util.async.channel_QMARK_(coll);
var state_115448__$1 = state_115448;
if(inst_115411){
var statearr_115454_115475 = state_115448__$1;
(statearr_115454_115475[(1)] = (5));

} else {
var statearr_115455_115476 = state_115448__$1;
(statearr_115455_115476[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (15))){
var inst_115429 = (state_115448[(2)]);
var inst_115430 = fluree.db.util.async.throw_err(inst_115429);
var state_115448__$1 = state_115448;
var statearr_115456_115477 = state_115448__$1;
(statearr_115456_115477[(2)] = inst_115430);

(statearr_115456_115477[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (13))){
var state_115448__$1 = state_115448;
var statearr_115457_115478 = state_115448__$1;
(statearr_115457_115478[(2)] = key);

(statearr_115457_115478[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (6))){
var state_115448__$1 = state_115448;
var statearr_115458_115479 = state_115448__$1;
(statearr_115458_115479[(2)] = coll);

(statearr_115458_115479[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (3))){
var inst_115407 = (state_115448[(2)]);
var state_115448__$1 = state_115448;
var statearr_115459_115480 = state_115448__$1;
(statearr_115459_115480[(2)] = inst_115407);


cljs.core.async.impl.ioc_helpers.process_exception(state_115448__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (12))){
var state_115448__$1 = state_115448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115448__$1,(15),key);
} else {
if((state_val_115449 === (2))){
var inst_115446 = (state_115448[(2)]);
var state_115448__$1 = state_115448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115448__$1,inst_115446);
} else {
if((state_val_115449 === (11))){
var inst_115425 = (state_115448[(2)]);
var inst_115426 = fluree.db.util.async.channel_QMARK_(key);
var state_115448__$1 = (function (){var statearr_115460 = state_115448;
(statearr_115460[(8)] = inst_115425);

return statearr_115460;
})();
if(inst_115426){
var statearr_115461_115481 = state_115448__$1;
(statearr_115461_115481[(1)] = (12));

} else {
var statearr_115462_115482 = state_115448__$1;
(statearr_115462_115482[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (9))){
var inst_115418 = (state_115448[(7)]);
var state_115448__$1 = state_115448;
var statearr_115463_115483 = state_115448__$1;
(statearr_115463_115483[(2)] = inst_115418);

(statearr_115463_115483[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (5))){
var state_115448__$1 = state_115448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115448__$1,(8),coll);
} else {
if((state_val_115449 === (14))){
var inst_115425 = (state_115448[(8)]);
var inst_115433 = (state_115448[(2)]);
var inst_115434 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_115425,inst_115433);
var inst_115435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115436 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115438 = [inst_115425,inst_115433];
var inst_115439 = (new cljs.core.PersistentVector(null,2,(5),inst_115437,inst_115438,null));
var inst_115440 = ["contains?",inst_115439,inst_115434];
var inst_115441 = cljs.core.PersistentHashMap.fromArrays(inst_115436,inst_115440);
var inst_115442 = [inst_115441,(10)];
var inst_115443 = (new cljs.core.PersistentVector(null,2,(5),inst_115435,inst_115442,null));
var inst_115444 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115443);
var state_115448__$1 = (function (){var statearr_115464 = state_115448;
(statearr_115464[(9)] = inst_115444);

return statearr_115464;
})();
var statearr_115465_115484 = state_115448__$1;
(statearr_115465_115484[(2)] = inst_115434);


cljs.core.async.impl.ioc_helpers.process_exception(state_115448__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (10))){
var inst_115418 = (state_115448[(7)]);
var inst_115422 = cljs.core.flatten(inst_115418);
var inst_115423 = cljs.core.set(inst_115422);
var state_115448__$1 = state_115448;
var statearr_115466_115485 = state_115448__$1;
(statearr_115466_115485[(2)] = inst_115423);

(statearr_115466_115485[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115449 === (8))){
var inst_115414 = (state_115448[(2)]);
var inst_115415 = fluree.db.util.async.throw_err(inst_115414);
var state_115448__$1 = state_115448;
var statearr_115467_115486 = state_115448__$1;
(statearr_115467_115486[(2)] = inst_115415);

(statearr_115467_115486[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_115468 = [null,null,null,null,null,null,null,null,null,null];
(statearr_115468[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__);

(statearr_115468[(1)] = (1));

return statearr_115468;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____1 = (function (state_115448){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115448);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115469){if((e115469 instanceof Object)){
var ex__99040__auto__ = e115469;
var statearr_115470_115487 = state_115448;
(statearr_115470_115487[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115448);

return cljs.core.cst$kw$recur;
} else {
throw e115469;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115488 = state_115448;
state_115448 = G__115488;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__ = function(state_115448){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____1.call(this,state_115448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115471 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115471[(6)] = c__99059__auto__);

return statearr_115471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115543 = arguments.length;
var i__4731__auto___115544 = (0);
while(true){
if((i__4731__auto___115544 < len__4730__auto___115543)){
args__4736__auto__.push((arguments[i__4731__auto___115544]));

var G__115545 = (i__4731__auto___115544 + (1));
i__4731__auto___115544 = G__115545;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115528){
var state_val_115529 = (state_115528[(1)]);
if((state_val_115529 === (1))){
var state_115528__$1 = state_115528;
var statearr_115530_115546 = state_115528__$1;
(statearr_115530_115546[(2)] = null);

(statearr_115530_115546[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115529 === (2))){
var inst_115526 = (state_115528[(2)]);
var state_115528__$1 = state_115528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115528__$1,inst_115526);
} else {
if((state_val_115529 === (3))){
var inst_115491 = (state_115528[(2)]);
var state_115528__$1 = state_115528;
var statearr_115531_115547 = state_115528__$1;
(statearr_115531_115547[(2)] = inst_115491);


cljs.core.async.impl.ioc_helpers.process_exception(state_115528__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115529 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115528,(3),Error,null,(2));
var inst_115495 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115528__$1 = state_115528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115528__$1,(5),inst_115495);
} else {
if((state_val_115529 === (5))){
var inst_115498 = (state_115528[(7)]);
var inst_115497 = (state_115528[(2)]);
var inst_115498__$1 = fluree.db.util.async.throw_err(inst_115497);
var inst_115499 = cljs.core.count(inst_115498__$1);
var inst_115500 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_115499);
var inst_115501 = cljs.core.first(inst_115498__$1);
var inst_115502 = cljs.core.coll_QMARK_(inst_115501);
var inst_115503 = ((inst_115500) && (inst_115502));
var state_115528__$1 = (function (){var statearr_115532 = state_115528;
(statearr_115532[(7)] = inst_115498__$1);

return statearr_115532;
})();
if(cljs.core.truth_(inst_115503)){
var statearr_115533_115548 = state_115528__$1;
(statearr_115533_115548[(1)] = (6));

} else {
var statearr_115534_115549 = state_115528__$1;
(statearr_115534_115549[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115529 === (6))){
var inst_115498 = (state_115528[(7)]);
var inst_115505 = cljs.core.first(inst_115498);
var state_115528__$1 = state_115528;
var statearr_115535_115550 = state_115528__$1;
(statearr_115535_115550[(2)] = inst_115505);

(statearr_115535_115550[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115529 === (7))){
var inst_115498 = (state_115528[(7)]);
var state_115528__$1 = state_115528;
var statearr_115536_115551 = state_115528__$1;
(statearr_115536_115551[(2)] = inst_115498);

(statearr_115536_115551[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115529 === (8))){
var inst_115508 = (state_115528[(2)]);
var inst_115509 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_115508);
var inst_115510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115511 = [inst_115508];
var inst_115512 = (new cljs.core.PersistentVector(null,1,(5),inst_115510,inst_115511,null));
var inst_115513 = cljs.core.count(inst_115512);
var inst_115514 = ((9) + inst_115513);
var inst_115515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115516 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115518 = [inst_115508];
var inst_115519 = (new cljs.core.PersistentVector(null,1,(5),inst_115517,inst_115518,null));
var inst_115520 = ["hash-set",inst_115519,inst_115509];
var inst_115521 = cljs.core.PersistentHashMap.fromArrays(inst_115516,inst_115520);
var inst_115522 = [inst_115521,inst_115514];
var inst_115523 = (new cljs.core.PersistentVector(null,2,(5),inst_115515,inst_115522,null));
var inst_115524 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115523);
var state_115528__$1 = (function (){var statearr_115537 = state_115528;
(statearr_115537[(8)] = inst_115524);

return statearr_115537;
})();
var statearr_115538_115552 = state_115528__$1;
(statearr_115538_115552[(2)] = inst_115509);


cljs.core.async.impl.ioc_helpers.process_exception(state_115528__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115539 = [null,null,null,null,null,null,null,null,null];
(statearr_115539[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115539[(1)] = (1));

return statearr_115539;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115528){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115528);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115540){if((e115540 instanceof Object)){
var ex__99040__auto__ = e115540;
var statearr_115541_115553 = state_115528;
(statearr_115541_115553[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115528);

return cljs.core.cst$kw$recur;
} else {
throw e115540;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115554 = state_115528;
state_115528 = G__115554;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115528){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115542 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115542[(6)] = c__99059__auto__);

return statearr_115542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq115489){
var G__115490 = cljs.core.first(seq115489);
var seq115489__$1 = cljs.core.next(seq115489);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115490,seq115489__$1);
});

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115594 = arguments.length;
var i__4731__auto___115595 = (0);
while(true){
if((i__4731__auto___115595 < len__4730__auto___115594)){
args__4736__auto__.push((arguments[i__4731__auto___115595]));

var G__115596 = (i__4731__auto___115595 + (1));
i__4731__auto___115595 = G__115596;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115584){
var state_val_115585 = (state_115584[(1)]);
if((state_val_115585 === (1))){
var state_115584__$1 = state_115584;
var statearr_115586_115597 = state_115584__$1;
(statearr_115586_115597[(2)] = null);

(statearr_115586_115597[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115585 === (2))){
var inst_115582 = (state_115584[(2)]);
var state_115584__$1 = state_115584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115584__$1,inst_115582);
} else {
if((state_val_115585 === (3))){
var inst_115557 = (state_115584[(2)]);
var state_115584__$1 = state_115584;
var statearr_115587_115598 = state_115584__$1;
(statearr_115587_115598[(2)] = inst_115557);


cljs.core.async.impl.ioc_helpers.process_exception(state_115584__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115585 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115584,(3),Error,null,(2));
var inst_115561 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115584__$1 = state_115584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115584__$1,(5),inst_115561);
} else {
if((state_val_115585 === (5))){
var inst_115563 = (state_115584[(2)]);
var inst_115564 = fluree.db.util.async.throw_err(inst_115563);
var inst_115565 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_115564);
var inst_115566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115567 = [inst_115564];
var inst_115568 = (new cljs.core.PersistentVector(null,1,(5),inst_115566,inst_115567,null));
var inst_115569 = cljs.core.count(inst_115568);
var inst_115570 = ((9) + inst_115569);
var inst_115571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115572 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115574 = [inst_115564];
var inst_115575 = (new cljs.core.PersistentVector(null,1,(5),inst_115573,inst_115574,null));
var inst_115576 = ["==",inst_115575,inst_115565];
var inst_115577 = cljs.core.PersistentHashMap.fromArrays(inst_115572,inst_115576);
var inst_115578 = [inst_115577,inst_115570];
var inst_115579 = (new cljs.core.PersistentVector(null,2,(5),inst_115571,inst_115578,null));
var inst_115580 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115579);
var state_115584__$1 = (function (){var statearr_115588 = state_115584;
(statearr_115588[(7)] = inst_115580);

return statearr_115588;
})();
var statearr_115589_115599 = state_115584__$1;
(statearr_115589_115599[(2)] = inst_115565);


cljs.core.async.impl.ioc_helpers.process_exception(state_115584__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115590 = [null,null,null,null,null,null,null,null];
(statearr_115590[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115590[(1)] = (1));

return statearr_115590;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115584){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115584);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115591){if((e115591 instanceof Object)){
var ex__99040__auto__ = e115591;
var statearr_115592_115600 = state_115584;
(statearr_115592_115600[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115584);

return cljs.core.cst$kw$recur;
} else {
throw e115591;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115601 = state_115584;
state_115584 = G__115601;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115584){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115593 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115593[(6)] = c__99059__auto__);

return statearr_115593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq115555){
var G__115556 = cljs.core.first(seq115555);
var seq115555__$1 = cljs.core.next(seq115555);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115556,seq115555__$1);
});

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115641 = arguments.length;
var i__4731__auto___115642 = (0);
while(true){
if((i__4731__auto___115642 < len__4730__auto___115641)){
args__4736__auto__.push((arguments[i__4731__auto___115642]));

var G__115643 = (i__4731__auto___115642 + (1));
i__4731__auto___115642 = G__115643;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115631){
var state_val_115632 = (state_115631[(1)]);
if((state_val_115632 === (1))){
var state_115631__$1 = state_115631;
var statearr_115633_115644 = state_115631__$1;
(statearr_115633_115644[(2)] = null);

(statearr_115633_115644[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115632 === (2))){
var inst_115629 = (state_115631[(2)]);
var state_115631__$1 = state_115631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115631__$1,inst_115629);
} else {
if((state_val_115632 === (3))){
var inst_115604 = (state_115631[(2)]);
var state_115631__$1 = state_115631;
var statearr_115634_115645 = state_115631__$1;
(statearr_115634_115645[(2)] = inst_115604);


cljs.core.async.impl.ioc_helpers.process_exception(state_115631__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115632 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115631,(3),Error,null,(2));
var inst_115608 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115631__$1 = state_115631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115631__$1,(5),inst_115608);
} else {
if((state_val_115632 === (5))){
var inst_115610 = (state_115631[(2)]);
var inst_115611 = fluree.db.util.async.throw_err(inst_115610);
var inst_115612 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_115611);
var inst_115613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115614 = [inst_115611];
var inst_115615 = (new cljs.core.PersistentVector(null,1,(5),inst_115613,inst_115614,null));
var inst_115616 = cljs.core.count(inst_115615);
var inst_115617 = ((9) + inst_115616);
var inst_115618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115619 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115621 = [inst_115611];
var inst_115622 = (new cljs.core.PersistentVector(null,1,(5),inst_115620,inst_115621,null));
var inst_115623 = [">",inst_115622,inst_115612];
var inst_115624 = cljs.core.PersistentHashMap.fromArrays(inst_115619,inst_115623);
var inst_115625 = [inst_115624,inst_115617];
var inst_115626 = (new cljs.core.PersistentVector(null,2,(5),inst_115618,inst_115625,null));
var inst_115627 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115626);
var state_115631__$1 = (function (){var statearr_115635 = state_115631;
(statearr_115635[(7)] = inst_115627);

return statearr_115635;
})();
var statearr_115636_115646 = state_115631__$1;
(statearr_115636_115646[(2)] = inst_115612);


cljs.core.async.impl.ioc_helpers.process_exception(state_115631__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115637 = [null,null,null,null,null,null,null,null];
(statearr_115637[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115637[(1)] = (1));

return statearr_115637;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115631){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115631);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115638){if((e115638 instanceof Object)){
var ex__99040__auto__ = e115638;
var statearr_115639_115647 = state_115631;
(statearr_115639_115647[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115631);

return cljs.core.cst$kw$recur;
} else {
throw e115638;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115648 = state_115631;
state_115631 = G__115648;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115640 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115640[(6)] = c__99059__auto__);

return statearr_115640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq115602){
var G__115603 = cljs.core.first(seq115602);
var seq115602__$1 = cljs.core.next(seq115602);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115603,seq115602__$1);
});

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115688 = arguments.length;
var i__4731__auto___115689 = (0);
while(true){
if((i__4731__auto___115689 < len__4730__auto___115688)){
args__4736__auto__.push((arguments[i__4731__auto___115689]));

var G__115690 = (i__4731__auto___115689 + (1));
i__4731__auto___115689 = G__115690;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115678){
var state_val_115679 = (state_115678[(1)]);
if((state_val_115679 === (1))){
var state_115678__$1 = state_115678;
var statearr_115680_115691 = state_115678__$1;
(statearr_115680_115691[(2)] = null);

(statearr_115680_115691[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115679 === (2))){
var inst_115676 = (state_115678[(2)]);
var state_115678__$1 = state_115678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115678__$1,inst_115676);
} else {
if((state_val_115679 === (3))){
var inst_115651 = (state_115678[(2)]);
var state_115678__$1 = state_115678;
var statearr_115681_115692 = state_115678__$1;
(statearr_115681_115692[(2)] = inst_115651);


cljs.core.async.impl.ioc_helpers.process_exception(state_115678__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115679 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115678,(3),Error,null,(2));
var inst_115655 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115678__$1 = state_115678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115678__$1,(5),inst_115655);
} else {
if((state_val_115679 === (5))){
var inst_115657 = (state_115678[(2)]);
var inst_115658 = fluree.db.util.async.throw_err(inst_115657);
var inst_115659 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_115658);
var inst_115660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115661 = [inst_115658];
var inst_115662 = (new cljs.core.PersistentVector(null,1,(5),inst_115660,inst_115661,null));
var inst_115663 = cljs.core.count(inst_115662);
var inst_115664 = ((9) + inst_115663);
var inst_115665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115666 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115668 = [inst_115658];
var inst_115669 = (new cljs.core.PersistentVector(null,1,(5),inst_115667,inst_115668,null));
var inst_115670 = ["<",inst_115669,inst_115659];
var inst_115671 = cljs.core.PersistentHashMap.fromArrays(inst_115666,inst_115670);
var inst_115672 = [inst_115671,inst_115664];
var inst_115673 = (new cljs.core.PersistentVector(null,2,(5),inst_115665,inst_115672,null));
var inst_115674 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115673);
var state_115678__$1 = (function (){var statearr_115682 = state_115678;
(statearr_115682[(7)] = inst_115674);

return statearr_115682;
})();
var statearr_115683_115693 = state_115678__$1;
(statearr_115683_115693[(2)] = inst_115659);


cljs.core.async.impl.ioc_helpers.process_exception(state_115678__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115684 = [null,null,null,null,null,null,null,null];
(statearr_115684[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115684[(1)] = (1));

return statearr_115684;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115678){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115678);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115685){if((e115685 instanceof Object)){
var ex__99040__auto__ = e115685;
var statearr_115686_115694 = state_115678;
(statearr_115686_115694[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115678);

return cljs.core.cst$kw$recur;
} else {
throw e115685;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115695 = state_115678;
state_115678 = G__115695;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115678){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115687 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115687[(6)] = c__99059__auto__);

return statearr_115687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq115649){
var G__115650 = cljs.core.first(seq115649);
var seq115649__$1 = cljs.core.next(seq115649);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115650,seq115649__$1);
});

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115735 = arguments.length;
var i__4731__auto___115736 = (0);
while(true){
if((i__4731__auto___115736 < len__4730__auto___115735)){
args__4736__auto__.push((arguments[i__4731__auto___115736]));

var G__115737 = (i__4731__auto___115736 + (1));
i__4731__auto___115736 = G__115737;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115725){
var state_val_115726 = (state_115725[(1)]);
if((state_val_115726 === (1))){
var state_115725__$1 = state_115725;
var statearr_115727_115738 = state_115725__$1;
(statearr_115727_115738[(2)] = null);

(statearr_115727_115738[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115726 === (2))){
var inst_115723 = (state_115725[(2)]);
var state_115725__$1 = state_115725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115725__$1,inst_115723);
} else {
if((state_val_115726 === (3))){
var inst_115698 = (state_115725[(2)]);
var state_115725__$1 = state_115725;
var statearr_115728_115739 = state_115725__$1;
(statearr_115728_115739[(2)] = inst_115698);


cljs.core.async.impl.ioc_helpers.process_exception(state_115725__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115726 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115725,(3),Error,null,(2));
var inst_115702 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115725__$1 = state_115725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115725__$1,(5),inst_115702);
} else {
if((state_val_115726 === (5))){
var inst_115704 = (state_115725[(2)]);
var inst_115705 = fluree.db.util.async.throw_err(inst_115704);
var inst_115706 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_115705);
var inst_115707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115708 = [inst_115705];
var inst_115709 = (new cljs.core.PersistentVector(null,1,(5),inst_115707,inst_115708,null));
var inst_115710 = cljs.core.count(inst_115709);
var inst_115711 = ((9) + inst_115710);
var inst_115712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115713 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115715 = [inst_115705];
var inst_115716 = (new cljs.core.PersistentVector(null,1,(5),inst_115714,inst_115715,null));
var inst_115717 = ["<=",inst_115716,inst_115706];
var inst_115718 = cljs.core.PersistentHashMap.fromArrays(inst_115713,inst_115717);
var inst_115719 = [inst_115718,inst_115711];
var inst_115720 = (new cljs.core.PersistentVector(null,2,(5),inst_115712,inst_115719,null));
var inst_115721 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115720);
var state_115725__$1 = (function (){var statearr_115729 = state_115725;
(statearr_115729[(7)] = inst_115721);

return statearr_115729;
})();
var statearr_115730_115740 = state_115725__$1;
(statearr_115730_115740[(2)] = inst_115706);


cljs.core.async.impl.ioc_helpers.process_exception(state_115725__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115731 = [null,null,null,null,null,null,null,null];
(statearr_115731[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115731[(1)] = (1));

return statearr_115731;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115725){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115725);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115732){if((e115732 instanceof Object)){
var ex__99040__auto__ = e115732;
var statearr_115733_115741 = state_115725;
(statearr_115733_115741[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115725);

return cljs.core.cst$kw$recur;
} else {
throw e115732;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115742 = state_115725;
state_115725 = G__115742;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115725){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115734 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115734[(6)] = c__99059__auto__);

return statearr_115734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq115696){
var G__115697 = cljs.core.first(seq115696);
var seq115696__$1 = cljs.core.next(seq115696);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115697,seq115696__$1);
});

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115782 = arguments.length;
var i__4731__auto___115783 = (0);
while(true){
if((i__4731__auto___115783 < len__4730__auto___115782)){
args__4736__auto__.push((arguments[i__4731__auto___115783]));

var G__115784 = (i__4731__auto___115783 + (1));
i__4731__auto___115783 = G__115784;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115772){
var state_val_115773 = (state_115772[(1)]);
if((state_val_115773 === (1))){
var state_115772__$1 = state_115772;
var statearr_115774_115785 = state_115772__$1;
(statearr_115774_115785[(2)] = null);

(statearr_115774_115785[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115773 === (2))){
var inst_115770 = (state_115772[(2)]);
var state_115772__$1 = state_115772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115772__$1,inst_115770);
} else {
if((state_val_115773 === (3))){
var inst_115745 = (state_115772[(2)]);
var state_115772__$1 = state_115772;
var statearr_115775_115786 = state_115772__$1;
(statearr_115775_115786[(2)] = inst_115745);


cljs.core.async.impl.ioc_helpers.process_exception(state_115772__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115773 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115772,(3),Error,null,(2));
var inst_115749 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115772__$1 = state_115772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115772__$1,(5),inst_115749);
} else {
if((state_val_115773 === (5))){
var inst_115751 = (state_115772[(2)]);
var inst_115752 = fluree.db.util.async.throw_err(inst_115751);
var inst_115753 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_115752);
var inst_115754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115755 = [inst_115752];
var inst_115756 = (new cljs.core.PersistentVector(null,1,(5),inst_115754,inst_115755,null));
var inst_115757 = cljs.core.count(inst_115756);
var inst_115758 = ((9) + inst_115757);
var inst_115759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115760 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115762 = [inst_115752];
var inst_115763 = (new cljs.core.PersistentVector(null,1,(5),inst_115761,inst_115762,null));
var inst_115764 = [">=",inst_115763,inst_115753];
var inst_115765 = cljs.core.PersistentHashMap.fromArrays(inst_115760,inst_115764);
var inst_115766 = [inst_115765,inst_115758];
var inst_115767 = (new cljs.core.PersistentVector(null,2,(5),inst_115759,inst_115766,null));
var inst_115768 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115767);
var state_115772__$1 = (function (){var statearr_115776 = state_115772;
(statearr_115776[(7)] = inst_115768);

return statearr_115776;
})();
var statearr_115777_115787 = state_115772__$1;
(statearr_115777_115787[(2)] = inst_115753);


cljs.core.async.impl.ioc_helpers.process_exception(state_115772__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115778 = [null,null,null,null,null,null,null,null];
(statearr_115778[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115778[(1)] = (1));

return statearr_115778;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115772){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115772);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115779){if((e115779 instanceof Object)){
var ex__99040__auto__ = e115779;
var statearr_115780_115788 = state_115772;
(statearr_115780_115788[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115772);

return cljs.core.cst$kw$recur;
} else {
throw e115779;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115789 = state_115772;
state_115772 = G__115789;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115781 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115781[(6)] = c__99059__auto__);

return statearr_115781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq115743){
var G__115744 = cljs.core.first(seq115743);
var seq115743__$1 = cljs.core.next(seq115743);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115744,seq115743__$1);
});

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115829 = arguments.length;
var i__4731__auto___115830 = (0);
while(true){
if((i__4731__auto___115830 < len__4730__auto___115829)){
args__4736__auto__.push((arguments[i__4731__auto___115830]));

var G__115831 = (i__4731__auto___115830 + (1));
i__4731__auto___115830 = G__115831;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115819){
var state_val_115820 = (state_115819[(1)]);
if((state_val_115820 === (1))){
var state_115819__$1 = state_115819;
var statearr_115821_115832 = state_115819__$1;
(statearr_115821_115832[(2)] = null);

(statearr_115821_115832[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115820 === (2))){
var inst_115817 = (state_115819[(2)]);
var state_115819__$1 = state_115819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115819__$1,inst_115817);
} else {
if((state_val_115820 === (3))){
var inst_115792 = (state_115819[(2)]);
var state_115819__$1 = state_115819;
var statearr_115822_115833 = state_115819__$1;
(statearr_115822_115833[(2)] = inst_115792);


cljs.core.async.impl.ioc_helpers.process_exception(state_115819__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115820 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115819,(3),Error,null,(2));
var inst_115796 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115819__$1 = state_115819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115819__$1,(5),inst_115796);
} else {
if((state_val_115820 === (5))){
var inst_115798 = (state_115819[(2)]);
var inst_115799 = fluree.db.util.async.throw_err(inst_115798);
var inst_115800 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_115799);
var inst_115801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115802 = [inst_115799];
var inst_115803 = (new cljs.core.PersistentVector(null,1,(5),inst_115801,inst_115802,null));
var inst_115804 = cljs.core.count(inst_115803);
var inst_115805 = ((9) + inst_115804);
var inst_115806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115807 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115809 = [inst_115799];
var inst_115810 = (new cljs.core.PersistentVector(null,1,(5),inst_115808,inst_115809,null));
var inst_115811 = ["max",inst_115810,inst_115800];
var inst_115812 = cljs.core.PersistentHashMap.fromArrays(inst_115807,inst_115811);
var inst_115813 = [inst_115812,inst_115805];
var inst_115814 = (new cljs.core.PersistentVector(null,2,(5),inst_115806,inst_115813,null));
var inst_115815 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115814);
var state_115819__$1 = (function (){var statearr_115823 = state_115819;
(statearr_115823[(7)] = inst_115815);

return statearr_115823;
})();
var statearr_115824_115834 = state_115819__$1;
(statearr_115824_115834[(2)] = inst_115800);


cljs.core.async.impl.ioc_helpers.process_exception(state_115819__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115825 = [null,null,null,null,null,null,null,null];
(statearr_115825[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115825[(1)] = (1));

return statearr_115825;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115819){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115819);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115826){if((e115826 instanceof Object)){
var ex__99040__auto__ = e115826;
var statearr_115827_115835 = state_115819;
(statearr_115827_115835[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115819);

return cljs.core.cst$kw$recur;
} else {
throw e115826;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115836 = state_115819;
state_115819 = G__115836;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115819){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115828 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115828[(6)] = c__99059__auto__);

return statearr_115828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq115790){
var G__115791 = cljs.core.first(seq115790);
var seq115790__$1 = cljs.core.next(seq115790);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115791,seq115790__$1);
});

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4736__auto__ = [];
var len__4730__auto___115875 = arguments.length;
var i__4731__auto___115876 = (0);
while(true){
if((i__4731__auto___115876 < len__4730__auto___115875)){
args__4736__auto__.push((arguments[i__4731__auto___115876]));

var G__115877 = (i__4731__auto___115876 + (1));
i__4731__auto___115876 = G__115877;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115865){
var state_val_115866 = (state_115865[(1)]);
if((state_val_115866 === (1))){
var state_115865__$1 = state_115865;
var statearr_115867_115878 = state_115865__$1;
(statearr_115867_115878[(2)] = null);

(statearr_115867_115878[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115866 === (2))){
var inst_115863 = (state_115865[(2)]);
var state_115865__$1 = state_115865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115865__$1,inst_115863);
} else {
if((state_val_115866 === (3))){
var inst_115839 = (state_115865[(2)]);
var state_115865__$1 = state_115865;
var statearr_115868_115879 = state_115865__$1;
(statearr_115868_115879[(2)] = inst_115839);


cljs.core.async.impl.ioc_helpers.process_exception(state_115865__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115866 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115865,(3),Error,null,(2));
var inst_115843 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_115865__$1 = state_115865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115865__$1,(5),inst_115843);
} else {
if((state_val_115866 === (5))){
var inst_115845 = (state_115865[(2)]);
var inst_115846 = fluree.db.util.async.throw_err(inst_115845);
var inst_115847 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_115846);
var inst_115848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115849 = [inst_115846];
var inst_115850 = (new cljs.core.PersistentVector(null,1,(5),inst_115848,inst_115849,null));
var inst_115851 = cljs.core.count(inst_115850);
var inst_115852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115853 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115855 = [inst_115846];
var inst_115856 = (new cljs.core.PersistentVector(null,1,(5),inst_115854,inst_115855,null));
var inst_115857 = ["min",inst_115856,inst_115847];
var inst_115858 = cljs.core.PersistentHashMap.fromArrays(inst_115853,inst_115857);
var inst_115859 = [inst_115858,inst_115851];
var inst_115860 = (new cljs.core.PersistentVector(null,2,(5),inst_115852,inst_115859,null));
var inst_115861 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115860);
var state_115865__$1 = (function (){var statearr_115869 = state_115865;
(statearr_115869[(7)] = inst_115861);

return statearr_115869;
})();
var statearr_115870_115880 = state_115865__$1;
(statearr_115870_115880[(2)] = inst_115847);


cljs.core.async.impl.ioc_helpers.process_exception(state_115865__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115871 = [null,null,null,null,null,null,null,null];
(statearr_115871[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115871[(1)] = (1));

return statearr_115871;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115865){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115865);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115872){if((e115872 instanceof Object)){
var ex__99040__auto__ = e115872;
var statearr_115873_115881 = state_115865;
(statearr_115873_115881[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115865);

return cljs.core.cst$kw$recur;
} else {
throw e115872;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__115882 = state_115865;
state_115865 = G__115882;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115874 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115874[(6)] = c__99059__auto__);

return statearr_115874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq115837){
var G__115838 = cljs.core.first(seq115837);
var seq115837__$1 = cljs.core.next(seq115837);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__115838,seq115837__$1);
});

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__115884 = arguments.length;
switch (G__115884) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_115926){
var state_val_115927 = (state_115926[(1)]);
if((state_val_115927 === (7))){
var inst_115899 = (state_115926[(7)]);
var inst_115899__$1 = (state_115926[(2)]);
var inst_115900 = typeof inst_115899__$1 === 'string';
var state_115926__$1 = (function (){var statearr_115928 = state_115926;
(statearr_115928[(7)] = inst_115899__$1);

return statearr_115928;
})();
if(cljs.core.truth_(inst_115900)){
var statearr_115929_116048 = state_115926__$1;
(statearr_115929_116048[(1)] = (9));

} else {
var statearr_115930_116049 = state_115926__$1;
(statearr_115930_116049[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (1))){
var state_115926__$1 = state_115926;
var statearr_115931_116050 = state_115926__$1;
(statearr_115931_116050[(2)] = null);

(statearr_115931_116050[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115926,(3),Error,null,(2));
var inst_115892 = fluree.db.util.async.channel_QMARK_(query_map);
var state_115926__$1 = state_115926;
if(inst_115892){
var statearr_115932_116051 = state_115926__$1;
(statearr_115932_116051[(1)] = (5));

} else {
var statearr_115933_116052 = state_115926__$1;
(statearr_115933_116052[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (6))){
var state_115926__$1 = state_115926;
var statearr_115934_116053 = state_115926__$1;
(statearr_115934_116053[(2)] = query_map);

(statearr_115934_116053[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (3))){
var inst_115885 = (state_115926[(2)]);
var state_115926__$1 = state_115926;
var statearr_115935_116054 = state_115926__$1;
(statearr_115935_116054[(2)] = inst_115885);


cljs.core.async.impl.ioc_helpers.process_exception(state_115926__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (12))){
var inst_115905 = (state_115926[(8)]);
var inst_115909 = (state_115926[(2)]);
var inst_115910 = fluree.db.util.async.throw_err(inst_115909);
var inst_115911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115910,(0),null);
var inst_115912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115910,(1),null);
var inst_115913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115914 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_115915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115916 = [inst_115905];
var inst_115917 = (new cljs.core.PersistentVector(null,1,(5),inst_115915,inst_115916,null));
var inst_115918 = ["query",inst_115917,inst_115911];
var inst_115919 = cljs.core.PersistentHashMap.fromArrays(inst_115914,inst_115918);
var inst_115920 = [inst_115919,inst_115912];
var inst_115921 = (new cljs.core.PersistentVector(null,2,(5),inst_115913,inst_115920,null));
var inst_115922 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_115921);
var state_115926__$1 = (function (){var statearr_115936 = state_115926;
(statearr_115936[(9)] = inst_115922);

return statearr_115936;
})();
var statearr_115937_116055 = state_115926__$1;
(statearr_115937_116055[(2)] = inst_115911);


cljs.core.async.impl.ioc_helpers.process_exception(state_115926__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (2))){
var inst_115924 = (state_115926[(2)]);
var state_115926__$1 = state_115926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115926__$1,inst_115924);
} else {
if((state_val_115927 === (11))){
var inst_115905 = (state_115926[(8)]);
var inst_115905__$1 = (state_115926[(2)]);
var inst_115906 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_115907 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_115906,inst_115905__$1);
var state_115926__$1 = (function (){var statearr_115938 = state_115926;
(statearr_115938[(8)] = inst_115905__$1);

return statearr_115938;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115926__$1,(12),inst_115907);
} else {
if((state_val_115927 === (9))){
var inst_115899 = (state_115926[(7)]);
var inst_115902 = fluree.db.util.json.parse(inst_115899);
var state_115926__$1 = state_115926;
var statearr_115939_116056 = state_115926__$1;
(statearr_115939_116056[(2)] = inst_115902);

(statearr_115939_116056[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (5))){
var state_115926__$1 = state_115926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115926__$1,(8),query_map);
} else {
if((state_val_115927 === (10))){
var inst_115899 = (state_115926[(7)]);
var state_115926__$1 = state_115926;
var statearr_115940_116057 = state_115926__$1;
(statearr_115940_116057[(2)] = inst_115899);

(statearr_115940_116057[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115927 === (8))){
var inst_115895 = (state_115926[(2)]);
var inst_115896 = fluree.db.util.async.throw_err(inst_115895);
var state_115926__$1 = state_115926;
var statearr_115941_116058 = state_115926__$1;
(statearr_115941_116058[(2)] = inst_115896);

(statearr_115941_116058[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_115942 = [null,null,null,null,null,null,null,null,null,null];
(statearr_115942[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_115942[(1)] = (1));

return statearr_115942;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_115926){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_115926);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e115943){if((e115943 instanceof Object)){
var ex__99040__auto__ = e115943;
var statearr_115944_116059 = state_115926;
(statearr_115944_116059[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115926);

return cljs.core.cst$kw$recur;
} else {
throw e115943;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116060 = state_115926;
state_115926 = G__116060;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_115926){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_115926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_115945 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_115945[(6)] = c__99059__auto__);

return statearr_115945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116013){
var state_val_116014 = (state_116013[(1)]);
if((state_val_116014 === (7))){
var inst_115960 = (state_116013[(2)]);
var inst_115961 = fluree.db.util.async.channel_QMARK_(from);
var state_116013__$1 = (function (){var statearr_116015 = state_116013;
(statearr_116015[(7)] = inst_115960);

return statearr_116015;
})();
if(inst_115961){
var statearr_116016_116061 = state_116013__$1;
(statearr_116016_116061[(1)] = (9));

} else {
var statearr_116017_116062 = state_116013__$1;
(statearr_116017_116062[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (20))){
var inst_115980 = (state_116013[(2)]);
var inst_115981 = fluree.db.util.async.throw_err(inst_115980);
var state_116013__$1 = state_116013;
var statearr_116018_116063 = state_116013__$1;
(statearr_116018_116063[(2)] = inst_115981);

(statearr_116018_116063[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (1))){
var state_116013__$1 = state_116013;
var statearr_116019_116064 = state_116013__$1;
(statearr_116019_116064[(2)] = null);

(statearr_116019_116064[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (24))){
var inst_115988 = (state_116013[(2)]);
var inst_115989 = fluree.db.util.async.throw_err(inst_115988);
var state_116013__$1 = state_116013;
var statearr_116020_116065 = state_116013__$1;
(statearr_116020_116065[(2)] = inst_115989);

(statearr_116020_116065[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116013,(3),Error,null,(2));
var inst_115953 = fluree.db.util.async.channel_QMARK_(select);
var state_116013__$1 = state_116013;
if(inst_115953){
var statearr_116021_116066 = state_116013__$1;
(statearr_116021_116066[(1)] = (5));

} else {
var statearr_116022_116067 = state_116013__$1;
(statearr_116022_116067[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (15))){
var inst_115976 = (state_116013[(2)]);
var inst_115977 = fluree.db.util.async.channel_QMARK_(block);
var state_116013__$1 = (function (){var statearr_116023 = state_116013;
(statearr_116023[(8)] = inst_115976);

return statearr_116023;
})();
if(inst_115977){
var statearr_116024_116068 = state_116013__$1;
(statearr_116024_116068[(1)] = (17));

} else {
var statearr_116025_116069 = state_116013__$1;
(statearr_116025_116069[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (21))){
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(24),limit);
} else {
if((state_val_116014 === (13))){
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(16),where);
} else {
if((state_val_116014 === (22))){
var state_116013__$1 = state_116013;
var statearr_116026_116070 = state_116013__$1;
(statearr_116026_116070[(2)] = limit);

(statearr_116026_116070[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (6))){
var state_116013__$1 = state_116013;
var statearr_116027_116071 = state_116013__$1;
(statearr_116027_116071[(2)] = select);

(statearr_116027_116071[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (25))){
var inst_115968 = (state_116013[(9)]);
var inst_115976 = (state_116013[(8)]);
var inst_115960 = (state_116013[(7)]);
var inst_115984 = (state_116013[(10)]);
var inst_115996 = (state_116013[(2)]);
var inst_115997 = fluree.db.util.async.throw_err(inst_115996);
var inst_115998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115997,(0),null);
var inst_115999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_115997,(1),null);
var inst_116000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116001 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116003 = [inst_115960,inst_115968,inst_115976,inst_115984];
var inst_116004 = (new cljs.core.PersistentVector(null,4,(5),inst_116002,inst_116003,null));
var inst_116005 = ["query",inst_116004,inst_115998];
var inst_116006 = cljs.core.PersistentHashMap.fromArrays(inst_116001,inst_116005);
var inst_116007 = [inst_116006,inst_115999];
var inst_116008 = (new cljs.core.PersistentVector(null,2,(5),inst_116000,inst_116007,null));
var inst_116009 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116008);
var state_116013__$1 = (function (){var statearr_116028 = state_116013;
(statearr_116028[(11)] = inst_116009);

return statearr_116028;
})();
var statearr_116029_116072 = state_116013__$1;
(statearr_116029_116072[(2)] = inst_115998);


cljs.core.async.impl.ioc_helpers.process_exception(state_116013__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (17))){
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(20),block);
} else {
if((state_val_116014 === (3))){
var inst_115946 = (state_116013[(2)]);
var state_116013__$1 = state_116013;
var statearr_116030_116073 = state_116013__$1;
(statearr_116030_116073[(2)] = inst_115946);


cljs.core.async.impl.ioc_helpers.process_exception(state_116013__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (12))){
var inst_115964 = (state_116013[(2)]);
var inst_115965 = fluree.db.util.async.throw_err(inst_115964);
var state_116013__$1 = state_116013;
var statearr_116031_116074 = state_116013__$1;
(statearr_116031_116074[(2)] = inst_115965);

(statearr_116031_116074[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (2))){
var inst_116011 = (state_116013[(2)]);
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116013__$1,inst_116011);
} else {
if((state_val_116014 === (23))){
var inst_115968 = (state_116013[(9)]);
var inst_115976 = (state_116013[(8)]);
var inst_115960 = (state_116013[(7)]);
var inst_115984 = (state_116013[(10)]);
var inst_115992 = (state_116013[(2)]);
var inst_115993 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_115994 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_115993,inst_115960,inst_115968,inst_115976,inst_115984,inst_115992);
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(25),inst_115994);
} else {
if((state_val_116014 === (19))){
var inst_115984 = (state_116013[(2)]);
var inst_115985 = fluree.db.util.async.channel_QMARK_(limit);
var state_116013__$1 = (function (){var statearr_116032 = state_116013;
(statearr_116032[(10)] = inst_115984);

return statearr_116032;
})();
if(inst_115985){
var statearr_116033_116075 = state_116013__$1;
(statearr_116033_116075[(1)] = (21));

} else {
var statearr_116034_116076 = state_116013__$1;
(statearr_116034_116076[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (11))){
var inst_115968 = (state_116013[(2)]);
var inst_115969 = fluree.db.util.async.channel_QMARK_(where);
var state_116013__$1 = (function (){var statearr_116035 = state_116013;
(statearr_116035[(9)] = inst_115968);

return statearr_116035;
})();
if(inst_115969){
var statearr_116036_116077 = state_116013__$1;
(statearr_116036_116077[(1)] = (13));

} else {
var statearr_116037_116078 = state_116013__$1;
(statearr_116037_116078[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (9))){
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(12),from);
} else {
if((state_val_116014 === (5))){
var state_116013__$1 = state_116013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116013__$1,(8),select);
} else {
if((state_val_116014 === (14))){
var state_116013__$1 = state_116013;
var statearr_116038_116079 = state_116013__$1;
(statearr_116038_116079[(2)] = where);

(statearr_116038_116079[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (16))){
var inst_115972 = (state_116013[(2)]);
var inst_115973 = fluree.db.util.async.throw_err(inst_115972);
var state_116013__$1 = state_116013;
var statearr_116039_116080 = state_116013__$1;
(statearr_116039_116080[(2)] = inst_115973);

(statearr_116039_116080[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (10))){
var state_116013__$1 = state_116013;
var statearr_116040_116081 = state_116013__$1;
(statearr_116040_116081[(2)] = from);

(statearr_116040_116081[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (18))){
var state_116013__$1 = state_116013;
var statearr_116041_116082 = state_116013__$1;
(statearr_116041_116082[(2)] = block);

(statearr_116041_116082[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116014 === (8))){
var inst_115956 = (state_116013[(2)]);
var inst_115957 = fluree.db.util.async.throw_err(inst_115956);
var state_116013__$1 = state_116013;
var statearr_116042_116083 = state_116013__$1;
(statearr_116042_116083[(2)] = inst_115957);

(statearr_116042_116083[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_116043 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116043[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_116043[(1)] = (1));

return statearr_116043;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_116013){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116013);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116044){if((e116044 instanceof Object)){
var ex__99040__auto__ = e116044;
var statearr_116045_116084 = state_116013;
(statearr_116045_116084[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116013);

return cljs.core.cst$kw$recur;
} else {
throw e116044;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116085 = state_116013;
state_116013 = G__116085;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_116013){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_116013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116046 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116046[(6)] = c__99059__auto__);

return statearr_116046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6;

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116138){
var state_val_116139 = (state_116138[(1)]);
if((state_val_116139 === (7))){
var inst_116100 = (state_116138[(2)]);
var inst_116101 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_116138__$1 = (function (){var statearr_116140 = state_116138;
(statearr_116140[(7)] = inst_116100);

return statearr_116140;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116138__$1,(9),inst_116101);
} else {
if((state_val_116139 === (1))){
var state_116138__$1 = state_116138;
var statearr_116141_116164 = state_116138__$1;
(statearr_116141_116164[(2)] = null);

(statearr_116141_116164[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116138,(3),Error,null,(2));
var inst_116093 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_116138__$1 = state_116138;
if(inst_116093){
var statearr_116142_116165 = state_116138__$1;
(statearr_116142_116165[(1)] = (5));

} else {
var statearr_116143_116166 = state_116138__$1;
(statearr_116143_116166[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (15))){
var state_116138__$1 = state_116138;
var statearr_116144_116167 = state_116138__$1;
(statearr_116144_116167[(2)] = false);

(statearr_116144_116167[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (13))){
var inst_116108 = (state_116138[(2)]);
var inst_116109 = fluree.db.util.async.throw_err(inst_116108);
var state_116138__$1 = state_116138;
var statearr_116145_116168 = state_116138__$1;
(statearr_116145_116168[(2)] = inst_116109);

(statearr_116145_116168[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (6))){
var state_116138__$1 = state_116138;
var statearr_116146_116169 = state_116138__$1;
(statearr_116146_116169[(2)] = startSubject);

(statearr_116146_116169[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (17))){
var inst_116104 = (state_116138[(8)]);
var inst_116112 = (state_116138[(9)]);
var inst_116119 = (state_116138[(10)]);
var inst_116100 = (state_116138[(7)]);
var inst_116124 = (state_116138[(2)]);
var inst_116125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116126 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116128 = [inst_116100,inst_116104,inst_116112];
var inst_116129 = (new cljs.core.PersistentVector(null,3,(5),inst_116127,inst_116128,null));
var inst_116130 = ["relationship?",inst_116129,inst_116124];
var inst_116131 = cljs.core.PersistentHashMap.fromArrays(inst_116126,inst_116130);
var inst_116132 = [inst_116131,inst_116119];
var inst_116133 = (new cljs.core.PersistentVector(null,2,(5),inst_116125,inst_116132,null));
var inst_116134 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116133);
var state_116138__$1 = (function (){var statearr_116147 = state_116138;
(statearr_116147[(11)] = inst_116134);

return statearr_116147;
})();
var statearr_116148_116170 = state_116138__$1;
(statearr_116148_116170[(2)] = inst_116124);


cljs.core.async.impl.ioc_helpers.process_exception(state_116138__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (3))){
var inst_116086 = (state_116138[(2)]);
var state_116138__$1 = state_116138;
var statearr_116149_116171 = state_116138__$1;
(statearr_116149_116171[(2)] = inst_116086);


cljs.core.async.impl.ioc_helpers.process_exception(state_116138__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (12))){
var inst_116104 = (state_116138[(8)]);
var inst_116112 = (state_116138[(9)]);
var inst_116100 = (state_116138[(7)]);
var inst_116112__$1 = (state_116138[(2)]);
var inst_116113 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_116114 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_116113,inst_116100,inst_116104,inst_116112__$1);
var state_116138__$1 = (function (){var statearr_116150 = state_116138;
(statearr_116150[(9)] = inst_116112__$1);

return statearr_116150;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116138__$1,(14),inst_116114);
} else {
if((state_val_116139 === (2))){
var inst_116136 = (state_116138[(2)]);
var state_116138__$1 = state_116138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116138__$1,inst_116136);
} else {
if((state_val_116139 === (11))){
var state_116138__$1 = state_116138;
var statearr_116151_116172 = state_116138__$1;
(statearr_116151_116172[(2)] = endSubject);

(statearr_116151_116172[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (9))){
var inst_116103 = (state_116138[(2)]);
var inst_116104 = fluree.db.util.async.throw_err(inst_116103);
var inst_116105 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_116138__$1 = (function (){var statearr_116152 = state_116138;
(statearr_116152[(8)] = inst_116104);

return statearr_116152;
})();
if(inst_116105){
var statearr_116153_116173 = state_116138__$1;
(statearr_116153_116173[(1)] = (10));

} else {
var statearr_116154_116174 = state_116138__$1;
(statearr_116154_116174[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (5))){
var state_116138__$1 = state_116138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116138__$1,(8),startSubject);
} else {
if((state_val_116139 === (14))){
var inst_116116 = (state_116138[(2)]);
var inst_116117 = fluree.db.util.async.throw_err(inst_116116);
var inst_116118 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116117,(0),null);
var inst_116119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116117,(1),null);
var inst_116120 = cljs.core.empty_QMARK_(inst_116118);
var state_116138__$1 = (function (){var statearr_116155 = state_116138;
(statearr_116155[(10)] = inst_116119);

return statearr_116155;
})();
if(inst_116120){
var statearr_116156_116175 = state_116138__$1;
(statearr_116156_116175[(1)] = (15));

} else {
var statearr_116157_116176 = state_116138__$1;
(statearr_116157_116176[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (16))){
var state_116138__$1 = state_116138;
var statearr_116158_116177 = state_116138__$1;
(statearr_116158_116177[(2)] = true);

(statearr_116158_116177[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116139 === (10))){
var state_116138__$1 = state_116138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116138__$1,(13),endSubject);
} else {
if((state_val_116139 === (8))){
var inst_116096 = (state_116138[(2)]);
var inst_116097 = fluree.db.util.async.throw_err(inst_116096);
var state_116138__$1 = state_116138;
var statearr_116159_116178 = state_116138__$1;
(statearr_116159_116178[(2)] = inst_116097);

(statearr_116159_116178[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_116160 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116160[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__);

(statearr_116160[(1)] = (1));

return statearr_116160;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____1 = (function (state_116138){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116138);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116161){if((e116161 instanceof Object)){
var ex__99040__auto__ = e116161;
var statearr_116162_116179 = state_116138;
(statearr_116162_116179[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116138);

return cljs.core.cst$kw$recur;
} else {
throw e116161;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116180 = state_116138;
state_116138 = G__116180;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__ = function(state_116138){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____1.call(this,state_116138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116163 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116163[(6)] = c__99059__auto__);

return statearr_116163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116214){
var state_val_116215 = (state_116214[(1)]);
if((state_val_116215 === (7))){
var inst_116195 = (state_116214[(7)]);
var inst_116195__$1 = (state_116214[(2)]);
var inst_116196 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_116197 = fluree.db.dbfunctions.internal.max_pred_val(inst_116196,inst_116195__$1);
var state_116214__$1 = (function (){var statearr_116216 = state_116214;
(statearr_116216[(7)] = inst_116195__$1);

return statearr_116216;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116214__$1,(9),inst_116197);
} else {
if((state_val_116215 === (1))){
var state_116214__$1 = state_116214;
var statearr_116217_116229 = state_116214__$1;
(statearr_116217_116229[(2)] = null);

(statearr_116217_116229[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116215 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116214,(3),Error,null,(2));
var inst_116188 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_116214__$1 = state_116214;
if(inst_116188){
var statearr_116218_116230 = state_116214__$1;
(statearr_116218_116230[(1)] = (5));

} else {
var statearr_116219_116231 = state_116214__$1;
(statearr_116219_116231[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116215 === (6))){
var state_116214__$1 = state_116214;
var statearr_116220_116232 = state_116214__$1;
(statearr_116220_116232[(2)] = pred_name);

(statearr_116220_116232[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116215 === (3))){
var inst_116181 = (state_116214[(2)]);
var state_116214__$1 = state_116214;
var statearr_116221_116233 = state_116214__$1;
(statearr_116221_116233[(2)] = inst_116181);


cljs.core.async.impl.ioc_helpers.process_exception(state_116214__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116215 === (2))){
var inst_116212 = (state_116214[(2)]);
var state_116214__$1 = state_116214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116214__$1,inst_116212);
} else {
if((state_val_116215 === (9))){
var inst_116195 = (state_116214[(7)]);
var inst_116199 = (state_116214[(2)]);
var inst_116200 = fluree.db.util.async.throw_err(inst_116199);
var inst_116201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116200,(0),null);
var inst_116202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116200,(1),null);
var inst_116203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116204 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116205 = ["max-pred-val",inst_116195,inst_116201];
var inst_116206 = cljs.core.PersistentHashMap.fromArrays(inst_116204,inst_116205);
var inst_116207 = (inst_116202 + (10));
var inst_116208 = [inst_116206,inst_116207];
var inst_116209 = (new cljs.core.PersistentVector(null,2,(5),inst_116203,inst_116208,null));
var inst_116210 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116209);
var state_116214__$1 = (function (){var statearr_116222 = state_116214;
(statearr_116222[(8)] = inst_116210);

return statearr_116222;
})();
var statearr_116223_116234 = state_116214__$1;
(statearr_116223_116234[(2)] = inst_116201);


cljs.core.async.impl.ioc_helpers.process_exception(state_116214__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116215 === (5))){
var state_116214__$1 = state_116214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116214__$1,(8),pred_name);
} else {
if((state_val_116215 === (8))){
var inst_116191 = (state_116214[(2)]);
var inst_116192 = fluree.db.util.async.throw_err(inst_116191);
var state_116214__$1 = state_116214;
var statearr_116224_116235 = state_116214__$1;
(statearr_116224_116235[(2)] = inst_116192);

(statearr_116224_116235[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____0 = (function (){
var statearr_116225 = [null,null,null,null,null,null,null,null,null];
(statearr_116225[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__);

(statearr_116225[(1)] = (1));

return statearr_116225;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____1 = (function (state_116214){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116214);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116226){if((e116226 instanceof Object)){
var ex__99040__auto__ = e116226;
var statearr_116227_116236 = state_116214;
(statearr_116227_116236[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116214);

return cljs.core.cst$kw$recur;
} else {
throw e116226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116237 = state_116214;
state_116214 = G__116237;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__ = function(state_116214){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____1.call(this,state_116214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116228 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116228[(6)] = c__99059__auto__);

return statearr_116228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116261){
var state_val_116262 = (state_116261[(1)]);
if((state_val_116262 === (1))){
var state_116261__$1 = state_116261;
var statearr_116263_116275 = state_116261__$1;
(statearr_116263_116275[(2)] = null);

(statearr_116263_116275[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116262 === (2))){
var inst_116259 = (state_116261[(2)]);
var state_116261__$1 = state_116261;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116261__$1,inst_116259);
} else {
if((state_val_116262 === (3))){
var inst_116238 = (state_116261[(2)]);
var state_116261__$1 = state_116261;
var statearr_116264_116276 = state_116261__$1;
(statearr_116264_116276[(2)] = inst_116238);


cljs.core.async.impl.ioc_helpers.process_exception(state_116261__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116262 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116261,(3),Error,null,(2));
var inst_116242 = fluree.db.util.async.channel_QMARK_(n);
var state_116261__$1 = state_116261;
if(inst_116242){
var statearr_116265_116277 = state_116261__$1;
(statearr_116265_116277[(1)] = (5));

} else {
var statearr_116266_116278 = state_116261__$1;
(statearr_116266_116278[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116262 === (5))){
var state_116261__$1 = state_116261;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116261__$1,(8),n);
} else {
if((state_val_116262 === (6))){
var state_116261__$1 = state_116261;
var statearr_116267_116279 = state_116261__$1;
(statearr_116267_116279[(2)] = n);

(statearr_116267_116279[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116262 === (7))){
var inst_116249 = (state_116261[(2)]);
var inst_116250 = fluree.db.dbfunctions.internal.inc(inst_116249);
var inst_116251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116252 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116253 = ["inc",inst_116249,inst_116250];
var inst_116254 = cljs.core.PersistentHashMap.fromArrays(inst_116252,inst_116253);
var inst_116255 = [inst_116254,(10)];
var inst_116256 = (new cljs.core.PersistentVector(null,2,(5),inst_116251,inst_116255,null));
var inst_116257 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116256);
var state_116261__$1 = (function (){var statearr_116268 = state_116261;
(statearr_116268[(7)] = inst_116257);

return statearr_116268;
})();
var statearr_116269_116280 = state_116261__$1;
(statearr_116269_116280[(2)] = inst_116250);


cljs.core.async.impl.ioc_helpers.process_exception(state_116261__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116262 === (8))){
var inst_116245 = (state_116261[(2)]);
var inst_116246 = fluree.db.util.async.throw_err(inst_116245);
var state_116261__$1 = state_116261;
var statearr_116270_116281 = state_116261__$1;
(statearr_116270_116281[(2)] = inst_116246);

(statearr_116270_116281[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____0 = (function (){
var statearr_116271 = [null,null,null,null,null,null,null,null];
(statearr_116271[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__);

(statearr_116271[(1)] = (1));

return statearr_116271;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____1 = (function (state_116261){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116261);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116272){if((e116272 instanceof Object)){
var ex__99040__auto__ = e116272;
var statearr_116273_116282 = state_116261;
(statearr_116273_116282[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116261);

return cljs.core.cst$kw$recur;
} else {
throw e116272;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116283 = state_116261;
state_116261 = G__116283;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__ = function(state_116261){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____1.call(this,state_116261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116274 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116274[(6)] = c__99059__auto__);

return statearr_116274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116307){
var state_val_116308 = (state_116307[(1)]);
if((state_val_116308 === (1))){
var state_116307__$1 = state_116307;
var statearr_116309_116321 = state_116307__$1;
(statearr_116309_116321[(2)] = null);

(statearr_116309_116321[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (2))){
var inst_116305 = (state_116307[(2)]);
var state_116307__$1 = state_116307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116307__$1,inst_116305);
} else {
if((state_val_116308 === (3))){
var inst_116284 = (state_116307[(2)]);
var state_116307__$1 = state_116307;
var statearr_116310_116322 = state_116307__$1;
(statearr_116310_116322[(2)] = inst_116284);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116307,(3),Error,null,(2));
var inst_116288 = fluree.db.util.async.channel_QMARK_(n);
var state_116307__$1 = state_116307;
if(inst_116288){
var statearr_116311_116323 = state_116307__$1;
(statearr_116311_116323[(1)] = (5));

} else {
var statearr_116312_116324 = state_116307__$1;
(statearr_116312_116324[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (5))){
var state_116307__$1 = state_116307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116307__$1,(8),n);
} else {
if((state_val_116308 === (6))){
var state_116307__$1 = state_116307;
var statearr_116313_116325 = state_116307__$1;
(statearr_116313_116325[(2)] = n);

(statearr_116313_116325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (7))){
var inst_116295 = (state_116307[(2)]);
var inst_116296 = fluree.db.dbfunctions.internal.dec(inst_116295);
var inst_116297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116298 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116299 = ["dec",inst_116295,inst_116296];
var inst_116300 = cljs.core.PersistentHashMap.fromArrays(inst_116298,inst_116299);
var inst_116301 = [inst_116300,(10)];
var inst_116302 = (new cljs.core.PersistentVector(null,2,(5),inst_116297,inst_116301,null));
var inst_116303 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116302);
var state_116307__$1 = (function (){var statearr_116314 = state_116307;
(statearr_116314[(7)] = inst_116303);

return statearr_116314;
})();
var statearr_116315_116326 = state_116307__$1;
(statearr_116315_116326[(2)] = inst_116296);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (8))){
var inst_116291 = (state_116307[(2)]);
var inst_116292 = fluree.db.util.async.throw_err(inst_116291);
var state_116307__$1 = state_116307;
var statearr_116316_116327 = state_116307__$1;
(statearr_116316_116327[(2)] = inst_116292);

(statearr_116316_116327[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____0 = (function (){
var statearr_116317 = [null,null,null,null,null,null,null,null];
(statearr_116317[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__);

(statearr_116317[(1)] = (1));

return statearr_116317;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____1 = (function (state_116307){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116307);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116318){if((e116318 instanceof Object)){
var ex__99040__auto__ = e116318;
var statearr_116319_116328 = state_116307;
(statearr_116319_116328[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307);

return cljs.core.cst$kw$recur;
} else {
throw e116318;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116329 = state_116307;
state_116307 = G__116329;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__ = function(state_116307){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____1.call(this,state_116307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116320 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116320[(6)] = c__99059__auto__);

return statearr_116320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___116369 = arguments.length;
var i__4731__auto___116370 = (0);
while(true){
if((i__4731__auto___116370 < len__4730__auto___116369)){
args__4736__auto__.push((arguments[i__4731__auto___116370]));

var G__116371 = (i__4731__auto___116370 + (1));
i__4731__auto___116370 = G__116371;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116359){
var state_val_116360 = (state_116359[(1)]);
if((state_val_116360 === (1))){
var state_116359__$1 = state_116359;
var statearr_116361_116372 = state_116359__$1;
(statearr_116361_116372[(2)] = null);

(statearr_116361_116372[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116360 === (2))){
var inst_116357 = (state_116359[(2)]);
var state_116359__$1 = state_116359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116359__$1,inst_116357);
} else {
if((state_val_116360 === (3))){
var inst_116332 = (state_116359[(2)]);
var state_116359__$1 = state_116359;
var statearr_116362_116373 = state_116359__$1;
(statearr_116362_116373[(2)] = inst_116332);


cljs.core.async.impl.ioc_helpers.process_exception(state_116359__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116360 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116359,(3),Error,null,(2));
var inst_116336 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_116359__$1 = state_116359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116359__$1,(5),inst_116336);
} else {
if((state_val_116360 === (5))){
var inst_116338 = (state_116359[(2)]);
var inst_116339 = fluree.db.util.async.throw_err(inst_116338);
var inst_116340 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_116339);
var inst_116341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116342 = [inst_116339];
var inst_116343 = (new cljs.core.PersistentVector(null,1,(5),inst_116341,inst_116342,null));
var inst_116344 = cljs.core.count(inst_116343);
var inst_116345 = ((9) + inst_116344);
var inst_116346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116347 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116349 = [inst_116339];
var inst_116350 = (new cljs.core.PersistentVector(null,1,(5),inst_116348,inst_116349,null));
var inst_116351 = ["+",inst_116350,inst_116340];
var inst_116352 = cljs.core.PersistentHashMap.fromArrays(inst_116347,inst_116351);
var inst_116353 = [inst_116352,inst_116345];
var inst_116354 = (new cljs.core.PersistentVector(null,2,(5),inst_116346,inst_116353,null));
var inst_116355 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116354);
var state_116359__$1 = (function (){var statearr_116363 = state_116359;
(statearr_116363[(7)] = inst_116355);

return statearr_116363;
})();
var statearr_116364_116374 = state_116359__$1;
(statearr_116364_116374[(2)] = inst_116340);


cljs.core.async.impl.ioc_helpers.process_exception(state_116359__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_116365 = [null,null,null,null,null,null,null,null];
(statearr_116365[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_116365[(1)] = (1));

return statearr_116365;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_116359){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116359);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116366){if((e116366 instanceof Object)){
var ex__99040__auto__ = e116366;
var statearr_116367_116375 = state_116359;
(statearr_116367_116375[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116359);

return cljs.core.cst$kw$recur;
} else {
throw e116366;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116376 = state_116359;
state_116359 = G__116376;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_116359){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_116359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116368 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116368[(6)] = c__99059__auto__);

return statearr_116368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq116330){
var G__116331 = cljs.core.first(seq116330);
var seq116330__$1 = cljs.core.next(seq116330);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__116331,seq116330__$1);
});

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___116416 = arguments.length;
var i__4731__auto___116417 = (0);
while(true){
if((i__4731__auto___116417 < len__4730__auto___116416)){
args__4736__auto__.push((arguments[i__4731__auto___116417]));

var G__116418 = (i__4731__auto___116417 + (1));
i__4731__auto___116417 = G__116418;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116406){
var state_val_116407 = (state_116406[(1)]);
if((state_val_116407 === (1))){
var state_116406__$1 = state_116406;
var statearr_116408_116419 = state_116406__$1;
(statearr_116408_116419[(2)] = null);

(statearr_116408_116419[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116407 === (2))){
var inst_116404 = (state_116406[(2)]);
var state_116406__$1 = state_116406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116406__$1,inst_116404);
} else {
if((state_val_116407 === (3))){
var inst_116379 = (state_116406[(2)]);
var state_116406__$1 = state_116406;
var statearr_116409_116420 = state_116406__$1;
(statearr_116409_116420[(2)] = inst_116379);


cljs.core.async.impl.ioc_helpers.process_exception(state_116406__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116407 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116406,(3),Error,null,(2));
var inst_116383 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_116406__$1 = state_116406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116406__$1,(5),inst_116383);
} else {
if((state_val_116407 === (5))){
var inst_116385 = (state_116406[(2)]);
var inst_116386 = fluree.db.util.async.throw_err(inst_116385);
var inst_116387 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_116386);
var inst_116388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116389 = [inst_116386];
var inst_116390 = (new cljs.core.PersistentVector(null,1,(5),inst_116388,inst_116389,null));
var inst_116391 = cljs.core.count(inst_116390);
var inst_116392 = ((9) + inst_116391);
var inst_116393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116394 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116396 = [inst_116386];
var inst_116397 = (new cljs.core.PersistentVector(null,1,(5),inst_116395,inst_116396,null));
var inst_116398 = ["-",inst_116397,inst_116387];
var inst_116399 = cljs.core.PersistentHashMap.fromArrays(inst_116394,inst_116398);
var inst_116400 = [inst_116399,inst_116392];
var inst_116401 = (new cljs.core.PersistentVector(null,2,(5),inst_116393,inst_116400,null));
var inst_116402 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116401);
var state_116406__$1 = (function (){var statearr_116410 = state_116406;
(statearr_116410[(7)] = inst_116402);

return statearr_116410;
})();
var statearr_116411_116421 = state_116406__$1;
(statearr_116411_116421[(2)] = inst_116387);


cljs.core.async.impl.ioc_helpers.process_exception(state_116406__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_116412 = [null,null,null,null,null,null,null,null];
(statearr_116412[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_116412[(1)] = (1));

return statearr_116412;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_116406){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116406);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116413){if((e116413 instanceof Object)){
var ex__99040__auto__ = e116413;
var statearr_116414_116422 = state_116406;
(statearr_116414_116422[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116406);

return cljs.core.cst$kw$recur;
} else {
throw e116413;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116423 = state_116406;
state_116406 = G__116423;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_116406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_116406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116415 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116415[(6)] = c__99059__auto__);

return statearr_116415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq116377){
var G__116378 = cljs.core.first(seq116377);
var seq116377__$1 = cljs.core.next(seq116377);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__116378,seq116377__$1);
});

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___116463 = arguments.length;
var i__4731__auto___116464 = (0);
while(true){
if((i__4731__auto___116464 < len__4730__auto___116463)){
args__4736__auto__.push((arguments[i__4731__auto___116464]));

var G__116465 = (i__4731__auto___116464 + (1));
i__4731__auto___116464 = G__116465;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116453){
var state_val_116454 = (state_116453[(1)]);
if((state_val_116454 === (1))){
var state_116453__$1 = state_116453;
var statearr_116455_116466 = state_116453__$1;
(statearr_116455_116466[(2)] = null);

(statearr_116455_116466[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116454 === (2))){
var inst_116451 = (state_116453[(2)]);
var state_116453__$1 = state_116453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116453__$1,inst_116451);
} else {
if((state_val_116454 === (3))){
var inst_116426 = (state_116453[(2)]);
var state_116453__$1 = state_116453;
var statearr_116456_116467 = state_116453__$1;
(statearr_116456_116467[(2)] = inst_116426);


cljs.core.async.impl.ioc_helpers.process_exception(state_116453__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116454 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116453,(3),Error,null,(2));
var inst_116430 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_116453__$1 = state_116453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116453__$1,(5),inst_116430);
} else {
if((state_val_116454 === (5))){
var inst_116432 = (state_116453[(2)]);
var inst_116433 = fluree.db.util.async.throw_err(inst_116432);
var inst_116434 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_116433);
var inst_116435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116436 = [inst_116433];
var inst_116437 = (new cljs.core.PersistentVector(null,1,(5),inst_116435,inst_116436,null));
var inst_116438 = cljs.core.count(inst_116437);
var inst_116439 = ((9) + inst_116438);
var inst_116440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116441 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116443 = [inst_116433];
var inst_116444 = (new cljs.core.PersistentVector(null,1,(5),inst_116442,inst_116443,null));
var inst_116445 = ["*",inst_116444,inst_116434];
var inst_116446 = cljs.core.PersistentHashMap.fromArrays(inst_116441,inst_116445);
var inst_116447 = [inst_116446,inst_116439];
var inst_116448 = (new cljs.core.PersistentVector(null,2,(5),inst_116440,inst_116447,null));
var inst_116449 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116448);
var state_116453__$1 = (function (){var statearr_116457 = state_116453;
(statearr_116457[(7)] = inst_116449);

return statearr_116457;
})();
var statearr_116458_116468 = state_116453__$1;
(statearr_116458_116468[(2)] = inst_116434);


cljs.core.async.impl.ioc_helpers.process_exception(state_116453__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_116459 = [null,null,null,null,null,null,null,null];
(statearr_116459[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_116459[(1)] = (1));

return statearr_116459;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_116453){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116453);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116460){if((e116460 instanceof Object)){
var ex__99040__auto__ = e116460;
var statearr_116461_116469 = state_116453;
(statearr_116461_116469[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116453);

return cljs.core.cst$kw$recur;
} else {
throw e116460;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116470 = state_116453;
state_116453 = G__116470;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_116453){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_116453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116462 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116462[(6)] = c__99059__auto__);

return statearr_116462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq116424){
var G__116425 = cljs.core.first(seq116424);
var seq116424__$1 = cljs.core.next(seq116424);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__116425,seq116424__$1);
});

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___116510 = arguments.length;
var i__4731__auto___116511 = (0);
while(true){
if((i__4731__auto___116511 < len__4730__auto___116510)){
args__4736__auto__.push((arguments[i__4731__auto___116511]));

var G__116512 = (i__4731__auto___116511 + (1));
i__4731__auto___116511 = G__116512;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116500){
var state_val_116501 = (state_116500[(1)]);
if((state_val_116501 === (1))){
var state_116500__$1 = state_116500;
var statearr_116502_116513 = state_116500__$1;
(statearr_116502_116513[(2)] = null);

(statearr_116502_116513[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116501 === (2))){
var inst_116498 = (state_116500[(2)]);
var state_116500__$1 = state_116500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116500__$1,inst_116498);
} else {
if((state_val_116501 === (3))){
var inst_116473 = (state_116500[(2)]);
var state_116500__$1 = state_116500;
var statearr_116503_116514 = state_116500__$1;
(statearr_116503_116514[(2)] = inst_116473);


cljs.core.async.impl.ioc_helpers.process_exception(state_116500__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116501 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116500,(3),Error,null,(2));
var inst_116477 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_116500__$1 = state_116500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116500__$1,(5),inst_116477);
} else {
if((state_val_116501 === (5))){
var inst_116479 = (state_116500[(2)]);
var inst_116480 = fluree.db.util.async.throw_err(inst_116479);
var inst_116481 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_116480);
var inst_116482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116483 = [inst_116480];
var inst_116484 = (new cljs.core.PersistentVector(null,1,(5),inst_116482,inst_116483,null));
var inst_116485 = cljs.core.count(inst_116484);
var inst_116486 = ((9) + inst_116485);
var inst_116487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116488 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116490 = [inst_116480];
var inst_116491 = (new cljs.core.PersistentVector(null,1,(5),inst_116489,inst_116490,null));
var inst_116492 = ["/",inst_116491,inst_116481];
var inst_116493 = cljs.core.PersistentHashMap.fromArrays(inst_116488,inst_116492);
var inst_116494 = [inst_116493,inst_116486];
var inst_116495 = (new cljs.core.PersistentVector(null,2,(5),inst_116487,inst_116494,null));
var inst_116496 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116495);
var state_116500__$1 = (function (){var statearr_116504 = state_116500;
(statearr_116504[(7)] = inst_116496);

return statearr_116504;
})();
var statearr_116505_116515 = state_116500__$1;
(statearr_116505_116515[(2)] = inst_116481);


cljs.core.async.impl.ioc_helpers.process_exception(state_116500__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_116506 = [null,null,null,null,null,null,null,null];
(statearr_116506[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_116506[(1)] = (1));

return statearr_116506;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_116500){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116500);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116507){if((e116507 instanceof Object)){
var ex__99040__auto__ = e116507;
var statearr_116508_116516 = state_116500;
(statearr_116508_116516[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116500);

return cljs.core.cst$kw$recur;
} else {
throw e116507;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116517 = state_116500;
state_116500 = G__116517;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_116500){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_116500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116509 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116509[(6)] = c__99059__auto__);

return statearr_116509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq116471){
var G__116472 = cljs.core.first(seq116471);
var seq116471__$1 = cljs.core.next(seq116471);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__116472,seq116471__$1);
});

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116552){
var state_val_116553 = (state_116552[(1)]);
if((state_val_116553 === (7))){
var inst_116529 = (state_116552[(2)]);
var inst_116530 = fluree.db.util.async.channel_QMARK_(d);
var state_116552__$1 = (function (){var statearr_116554 = state_116552;
(statearr_116554[(7)] = inst_116529);

return statearr_116554;
})();
if(inst_116530){
var statearr_116555_116571 = state_116552__$1;
(statearr_116555_116571[(1)] = (9));

} else {
var statearr_116556_116572 = state_116552__$1;
(statearr_116556_116572[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (1))){
var state_116552__$1 = state_116552;
var statearr_116557_116573 = state_116552__$1;
(statearr_116557_116573[(2)] = null);

(statearr_116557_116573[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116552,(3),Error,null,(2));
var inst_116522 = fluree.db.util.async.channel_QMARK_(n);
var state_116552__$1 = state_116552;
if(inst_116522){
var statearr_116558_116574 = state_116552__$1;
(statearr_116558_116574[(1)] = (5));

} else {
var statearr_116559_116575 = state_116552__$1;
(statearr_116559_116575[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (6))){
var state_116552__$1 = state_116552;
var statearr_116560_116576 = state_116552__$1;
(statearr_116560_116576[(2)] = n);

(statearr_116560_116576[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (3))){
var inst_116518 = (state_116552[(2)]);
var state_116552__$1 = state_116552;
var statearr_116561_116577 = state_116552__$1;
(statearr_116561_116577[(2)] = inst_116518);


cljs.core.async.impl.ioc_helpers.process_exception(state_116552__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (12))){
var inst_116533 = (state_116552[(2)]);
var inst_116534 = fluree.db.util.async.throw_err(inst_116533);
var state_116552__$1 = state_116552;
var statearr_116562_116578 = state_116552__$1;
(statearr_116562_116578[(2)] = inst_116534);

(statearr_116562_116578[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (2))){
var inst_116550 = (state_116552[(2)]);
var state_116552__$1 = state_116552;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116552__$1,inst_116550);
} else {
if((state_val_116553 === (11))){
var inst_116529 = (state_116552[(7)]);
var inst_116537 = (state_116552[(2)]);
var inst_116538 = fluree.db.dbfunctions.internal.quot(inst_116529,inst_116537);
var inst_116539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116540 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116542 = [inst_116529,inst_116537];
var inst_116543 = (new cljs.core.PersistentVector(null,2,(5),inst_116541,inst_116542,null));
var inst_116544 = ["quot",inst_116543,inst_116538];
var inst_116545 = cljs.core.PersistentHashMap.fromArrays(inst_116540,inst_116544);
var inst_116546 = [inst_116545,(2)];
var inst_116547 = (new cljs.core.PersistentVector(null,2,(5),inst_116539,inst_116546,null));
var inst_116548 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116547);
var state_116552__$1 = (function (){var statearr_116563 = state_116552;
(statearr_116563[(8)] = inst_116548);

return statearr_116563;
})();
var statearr_116564_116579 = state_116552__$1;
(statearr_116564_116579[(2)] = inst_116538);


cljs.core.async.impl.ioc_helpers.process_exception(state_116552__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (9))){
var state_116552__$1 = state_116552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116552__$1,(12),d);
} else {
if((state_val_116553 === (5))){
var state_116552__$1 = state_116552;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116552__$1,(8),n);
} else {
if((state_val_116553 === (10))){
var state_116552__$1 = state_116552;
var statearr_116565_116580 = state_116552__$1;
(statearr_116565_116580[(2)] = d);

(statearr_116565_116580[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116553 === (8))){
var inst_116525 = (state_116552[(2)]);
var inst_116526 = fluree.db.util.async.throw_err(inst_116525);
var state_116552__$1 = state_116552;
var statearr_116566_116581 = state_116552__$1;
(statearr_116566_116581[(2)] = inst_116526);

(statearr_116566_116581[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____0 = (function (){
var statearr_116567 = [null,null,null,null,null,null,null,null,null];
(statearr_116567[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__);

(statearr_116567[(1)] = (1));

return statearr_116567;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____1 = (function (state_116552){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116552);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116568){if((e116568 instanceof Object)){
var ex__99040__auto__ = e116568;
var statearr_116569_116582 = state_116552;
(statearr_116569_116582[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116552);

return cljs.core.cst$kw$recur;
} else {
throw e116568;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116583 = state_116552;
state_116552 = G__116583;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__ = function(state_116552){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____1.call(this,state_116552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116570 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116570[(6)] = c__99059__auto__);

return statearr_116570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116618){
var state_val_116619 = (state_116618[(1)]);
if((state_val_116619 === (7))){
var inst_116595 = (state_116618[(2)]);
var inst_116596 = fluree.db.util.async.channel_QMARK_(d);
var state_116618__$1 = (function (){var statearr_116620 = state_116618;
(statearr_116620[(7)] = inst_116595);

return statearr_116620;
})();
if(inst_116596){
var statearr_116621_116637 = state_116618__$1;
(statearr_116621_116637[(1)] = (9));

} else {
var statearr_116622_116638 = state_116618__$1;
(statearr_116622_116638[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (1))){
var state_116618__$1 = state_116618;
var statearr_116623_116639 = state_116618__$1;
(statearr_116623_116639[(2)] = null);

(statearr_116623_116639[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116618,(3),Error,null,(2));
var inst_116588 = fluree.db.util.async.channel_QMARK_(n);
var state_116618__$1 = state_116618;
if(inst_116588){
var statearr_116624_116640 = state_116618__$1;
(statearr_116624_116640[(1)] = (5));

} else {
var statearr_116625_116641 = state_116618__$1;
(statearr_116625_116641[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (6))){
var state_116618__$1 = state_116618;
var statearr_116626_116642 = state_116618__$1;
(statearr_116626_116642[(2)] = n);

(statearr_116626_116642[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (3))){
var inst_116584 = (state_116618[(2)]);
var state_116618__$1 = state_116618;
var statearr_116627_116643 = state_116618__$1;
(statearr_116627_116643[(2)] = inst_116584);


cljs.core.async.impl.ioc_helpers.process_exception(state_116618__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (12))){
var inst_116599 = (state_116618[(2)]);
var inst_116600 = fluree.db.util.async.throw_err(inst_116599);
var state_116618__$1 = state_116618;
var statearr_116628_116644 = state_116618__$1;
(statearr_116628_116644[(2)] = inst_116600);

(statearr_116628_116644[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (2))){
var inst_116616 = (state_116618[(2)]);
var state_116618__$1 = state_116618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116618__$1,inst_116616);
} else {
if((state_val_116619 === (11))){
var inst_116595 = (state_116618[(7)]);
var inst_116603 = (state_116618[(2)]);
var inst_116604 = fluree.db.dbfunctions.internal.mod(inst_116595,inst_116603);
var inst_116605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116606 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116608 = [inst_116595,inst_116603];
var inst_116609 = (new cljs.core.PersistentVector(null,2,(5),inst_116607,inst_116608,null));
var inst_116610 = ["mod",inst_116609,inst_116604];
var inst_116611 = cljs.core.PersistentHashMap.fromArrays(inst_116606,inst_116610);
var inst_116612 = [inst_116611,(2)];
var inst_116613 = (new cljs.core.PersistentVector(null,2,(5),inst_116605,inst_116612,null));
var inst_116614 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116613);
var state_116618__$1 = (function (){var statearr_116629 = state_116618;
(statearr_116629[(8)] = inst_116614);

return statearr_116629;
})();
var statearr_116630_116645 = state_116618__$1;
(statearr_116630_116645[(2)] = inst_116604);


cljs.core.async.impl.ioc_helpers.process_exception(state_116618__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (9))){
var state_116618__$1 = state_116618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116618__$1,(12),d);
} else {
if((state_val_116619 === (5))){
var state_116618__$1 = state_116618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116618__$1,(8),n);
} else {
if((state_val_116619 === (10))){
var state_116618__$1 = state_116618;
var statearr_116631_116646 = state_116618__$1;
(statearr_116631_116646[(2)] = d);

(statearr_116631_116646[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116619 === (8))){
var inst_116591 = (state_116618[(2)]);
var inst_116592 = fluree.db.util.async.throw_err(inst_116591);
var state_116618__$1 = state_116618;
var statearr_116632_116647 = state_116618__$1;
(statearr_116632_116647[(2)] = inst_116592);

(statearr_116632_116647[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____0 = (function (){
var statearr_116633 = [null,null,null,null,null,null,null,null,null];
(statearr_116633[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__);

(statearr_116633[(1)] = (1));

return statearr_116633;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____1 = (function (state_116618){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116618);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116634){if((e116634 instanceof Object)){
var ex__99040__auto__ = e116634;
var statearr_116635_116648 = state_116618;
(statearr_116635_116648[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116618);

return cljs.core.cst$kw$recur;
} else {
throw e116634;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116649 = state_116618;
state_116618 = G__116649;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__ = function(state_116618){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____1.call(this,state_116618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116636 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116636[(6)] = c__99059__auto__);

return statearr_116636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116684){
var state_val_116685 = (state_116684[(1)]);
if((state_val_116685 === (7))){
var inst_116661 = (state_116684[(2)]);
var inst_116662 = fluree.db.util.async.channel_QMARK_(d);
var state_116684__$1 = (function (){var statearr_116686 = state_116684;
(statearr_116686[(7)] = inst_116661);

return statearr_116686;
})();
if(inst_116662){
var statearr_116687_116703 = state_116684__$1;
(statearr_116687_116703[(1)] = (9));

} else {
var statearr_116688_116704 = state_116684__$1;
(statearr_116688_116704[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (1))){
var state_116684__$1 = state_116684;
var statearr_116689_116705 = state_116684__$1;
(statearr_116689_116705[(2)] = null);

(statearr_116689_116705[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116684,(3),Error,null,(2));
var inst_116654 = fluree.db.util.async.channel_QMARK_(n);
var state_116684__$1 = state_116684;
if(inst_116654){
var statearr_116690_116706 = state_116684__$1;
(statearr_116690_116706[(1)] = (5));

} else {
var statearr_116691_116707 = state_116684__$1;
(statearr_116691_116707[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (6))){
var state_116684__$1 = state_116684;
var statearr_116692_116708 = state_116684__$1;
(statearr_116692_116708[(2)] = n);

(statearr_116692_116708[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (3))){
var inst_116650 = (state_116684[(2)]);
var state_116684__$1 = state_116684;
var statearr_116693_116709 = state_116684__$1;
(statearr_116693_116709[(2)] = inst_116650);


cljs.core.async.impl.ioc_helpers.process_exception(state_116684__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (12))){
var inst_116665 = (state_116684[(2)]);
var inst_116666 = fluree.db.util.async.throw_err(inst_116665);
var state_116684__$1 = state_116684;
var statearr_116694_116710 = state_116684__$1;
(statearr_116694_116710[(2)] = inst_116666);

(statearr_116694_116710[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (2))){
var inst_116682 = (state_116684[(2)]);
var state_116684__$1 = state_116684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116684__$1,inst_116682);
} else {
if((state_val_116685 === (11))){
var inst_116661 = (state_116684[(7)]);
var inst_116669 = (state_116684[(2)]);
var inst_116670 = fluree.db.dbfunctions.internal.rem(inst_116661,inst_116669);
var inst_116671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116672 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116674 = [inst_116661,inst_116669];
var inst_116675 = (new cljs.core.PersistentVector(null,2,(5),inst_116673,inst_116674,null));
var inst_116676 = ["rem",inst_116675,inst_116670];
var inst_116677 = cljs.core.PersistentHashMap.fromArrays(inst_116672,inst_116676);
var inst_116678 = [inst_116677,(2)];
var inst_116679 = (new cljs.core.PersistentVector(null,2,(5),inst_116671,inst_116678,null));
var inst_116680 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116679);
var state_116684__$1 = (function (){var statearr_116695 = state_116684;
(statearr_116695[(8)] = inst_116680);

return statearr_116695;
})();
var statearr_116696_116711 = state_116684__$1;
(statearr_116696_116711[(2)] = inst_116670);


cljs.core.async.impl.ioc_helpers.process_exception(state_116684__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (9))){
var state_116684__$1 = state_116684;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116684__$1,(12),d);
} else {
if((state_val_116685 === (5))){
var state_116684__$1 = state_116684;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116684__$1,(8),n);
} else {
if((state_val_116685 === (10))){
var state_116684__$1 = state_116684;
var statearr_116697_116712 = state_116684__$1;
(statearr_116697_116712[(2)] = d);

(statearr_116697_116712[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116685 === (8))){
var inst_116657 = (state_116684[(2)]);
var inst_116658 = fluree.db.util.async.throw_err(inst_116657);
var state_116684__$1 = state_116684;
var statearr_116698_116713 = state_116684__$1;
(statearr_116698_116713[(2)] = inst_116658);

(statearr_116698_116713[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____0 = (function (){
var statearr_116699 = [null,null,null,null,null,null,null,null,null];
(statearr_116699[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__);

(statearr_116699[(1)] = (1));

return statearr_116699;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____1 = (function (state_116684){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116684);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116700){if((e116700 instanceof Object)){
var ex__99040__auto__ = e116700;
var statearr_116701_116714 = state_116684;
(statearr_116701_116714[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116684);

return cljs.core.cst$kw$recur;
} else {
throw e116700;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116715 = state_116684;
state_116684 = G__116715;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__ = function(state_116684){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____1.call(this,state_116684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116702 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116702[(6)] = c__99059__auto__);

return statearr_116702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116739){
var state_val_116740 = (state_116739[(1)]);
if((state_val_116740 === (1))){
var state_116739__$1 = state_116739;
var statearr_116741_116753 = state_116739__$1;
(statearr_116741_116753[(2)] = null);

(statearr_116741_116753[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116740 === (2))){
var inst_116737 = (state_116739[(2)]);
var state_116739__$1 = state_116739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116739__$1,inst_116737);
} else {
if((state_val_116740 === (3))){
var inst_116716 = (state_116739[(2)]);
var state_116739__$1 = state_116739;
var statearr_116742_116754 = state_116739__$1;
(statearr_116742_116754[(2)] = inst_116716);


cljs.core.async.impl.ioc_helpers.process_exception(state_116739__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116740 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116739,(3),Error,null,(2));
var inst_116720 = fluree.db.util.async.channel_QMARK_(x);
var state_116739__$1 = state_116739;
if(inst_116720){
var statearr_116743_116755 = state_116739__$1;
(statearr_116743_116755[(1)] = (5));

} else {
var statearr_116744_116756 = state_116739__$1;
(statearr_116744_116756[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116740 === (5))){
var state_116739__$1 = state_116739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116739__$1,(8),x);
} else {
if((state_val_116740 === (6))){
var state_116739__$1 = state_116739;
var statearr_116745_116757 = state_116739__$1;
(statearr_116745_116757[(2)] = x);

(statearr_116745_116757[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116740 === (7))){
var inst_116727 = (state_116739[(2)]);
var inst_116728 = fluree.db.dbfunctions.internal.boolean$(inst_116727);
var inst_116729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116730 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116731 = ["boolean",inst_116727,inst_116728];
var inst_116732 = cljs.core.PersistentHashMap.fromArrays(inst_116730,inst_116731);
var inst_116733 = [inst_116732,(10)];
var inst_116734 = (new cljs.core.PersistentVector(null,2,(5),inst_116729,inst_116733,null));
var inst_116735 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116734);
var state_116739__$1 = (function (){var statearr_116746 = state_116739;
(statearr_116746[(7)] = inst_116735);

return statearr_116746;
})();
var statearr_116747_116758 = state_116739__$1;
(statearr_116747_116758[(2)] = inst_116728);


cljs.core.async.impl.ioc_helpers.process_exception(state_116739__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116740 === (8))){
var inst_116723 = (state_116739[(2)]);
var inst_116724 = fluree.db.util.async.throw_err(inst_116723);
var state_116739__$1 = state_116739;
var statearr_116748_116759 = state_116739__$1;
(statearr_116748_116759[(2)] = inst_116724);

(statearr_116748_116759[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____0 = (function (){
var statearr_116749 = [null,null,null,null,null,null,null,null];
(statearr_116749[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__);

(statearr_116749[(1)] = (1));

return statearr_116749;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____1 = (function (state_116739){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116739);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116750){if((e116750 instanceof Object)){
var ex__99040__auto__ = e116750;
var statearr_116751_116760 = state_116739;
(statearr_116751_116760[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116739);

return cljs.core.cst$kw$recur;
} else {
throw e116750;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116761 = state_116739;
state_116739 = G__116761;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__ = function(state_116739){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____1.call(this,state_116739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116752 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116752[(6)] = c__99059__auto__);

return statearr_116752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116796){
var state_val_116797 = (state_116796[(1)]);
if((state_val_116797 === (7))){
var inst_116773 = (state_116796[(2)]);
var inst_116774 = fluree.db.util.async.channel_QMARK_(string);
var state_116796__$1 = (function (){var statearr_116798 = state_116796;
(statearr_116798[(7)] = inst_116773);

return statearr_116798;
})();
if(inst_116774){
var statearr_116799_116815 = state_116796__$1;
(statearr_116799_116815[(1)] = (9));

} else {
var statearr_116800_116816 = state_116796__$1;
(statearr_116800_116816[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (1))){
var state_116796__$1 = state_116796;
var statearr_116801_116817 = state_116796__$1;
(statearr_116801_116817[(2)] = null);

(statearr_116801_116817[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116796,(3),Error,null,(2));
var inst_116766 = fluree.db.util.async.channel_QMARK_(pattern);
var state_116796__$1 = state_116796;
if(inst_116766){
var statearr_116802_116818 = state_116796__$1;
(statearr_116802_116818[(1)] = (5));

} else {
var statearr_116803_116819 = state_116796__$1;
(statearr_116803_116819[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (6))){
var state_116796__$1 = state_116796;
var statearr_116804_116820 = state_116796__$1;
(statearr_116804_116820[(2)] = pattern);

(statearr_116804_116820[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (3))){
var inst_116762 = (state_116796[(2)]);
var state_116796__$1 = state_116796;
var statearr_116805_116821 = state_116796__$1;
(statearr_116805_116821[(2)] = inst_116762);


cljs.core.async.impl.ioc_helpers.process_exception(state_116796__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (12))){
var inst_116777 = (state_116796[(2)]);
var inst_116778 = fluree.db.util.async.throw_err(inst_116777);
var state_116796__$1 = state_116796;
var statearr_116806_116822 = state_116796__$1;
(statearr_116806_116822[(2)] = inst_116778);

(statearr_116806_116822[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (2))){
var inst_116794 = (state_116796[(2)]);
var state_116796__$1 = state_116796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116796__$1,inst_116794);
} else {
if((state_val_116797 === (11))){
var inst_116773 = (state_116796[(7)]);
var inst_116781 = (state_116796[(2)]);
var inst_116782 = fluree.db.dbfunctions.internal.re_find(inst_116773,inst_116781);
var inst_116783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116784 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116786 = [inst_116773,inst_116781];
var inst_116787 = (new cljs.core.PersistentVector(null,2,(5),inst_116785,inst_116786,null));
var inst_116788 = ["re-find",inst_116787,inst_116782];
var inst_116789 = cljs.core.PersistentHashMap.fromArrays(inst_116784,inst_116788);
var inst_116790 = [inst_116789,(10)];
var inst_116791 = (new cljs.core.PersistentVector(null,2,(5),inst_116783,inst_116790,null));
var inst_116792 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116791);
var state_116796__$1 = (function (){var statearr_116807 = state_116796;
(statearr_116807[(8)] = inst_116792);

return statearr_116807;
})();
var statearr_116808_116823 = state_116796__$1;
(statearr_116808_116823[(2)] = inst_116782);


cljs.core.async.impl.ioc_helpers.process_exception(state_116796__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (9))){
var state_116796__$1 = state_116796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116796__$1,(12),string);
} else {
if((state_val_116797 === (5))){
var state_116796__$1 = state_116796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116796__$1,(8),pattern);
} else {
if((state_val_116797 === (10))){
var state_116796__$1 = state_116796;
var statearr_116809_116824 = state_116796__$1;
(statearr_116809_116824[(2)] = string);

(statearr_116809_116824[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116797 === (8))){
var inst_116769 = (state_116796[(2)]);
var inst_116770 = fluree.db.util.async.throw_err(inst_116769);
var state_116796__$1 = state_116796;
var statearr_116810_116825 = state_116796__$1;
(statearr_116810_116825[(2)] = inst_116770);

(statearr_116810_116825[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____0 = (function (){
var statearr_116811 = [null,null,null,null,null,null,null,null,null];
(statearr_116811[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__);

(statearr_116811[(1)] = (1));

return statearr_116811;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____1 = (function (state_116796){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116796);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116812){if((e116812 instanceof Object)){
var ex__99040__auto__ = e116812;
var statearr_116813_116826 = state_116796;
(statearr_116813_116826[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116796);

return cljs.core.cst$kw$recur;
} else {
throw e116812;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116827 = state_116796;
state_116796 = G__116827;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__ = function(state_116796){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____1.call(this,state_116796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116814 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116814[(6)] = c__99059__auto__);

return statearr_116814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116851){
var state_val_116852 = (state_116851[(1)]);
if((state_val_116852 === (1))){
var state_116851__$1 = state_116851;
var statearr_116853_116865 = state_116851__$1;
(statearr_116853_116865[(2)] = null);

(statearr_116853_116865[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116852 === (2))){
var inst_116849 = (state_116851[(2)]);
var state_116851__$1 = state_116851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116851__$1,inst_116849);
} else {
if((state_val_116852 === (3))){
var inst_116828 = (state_116851[(2)]);
var state_116851__$1 = state_116851;
var statearr_116854_116866 = state_116851__$1;
(statearr_116854_116866[(2)] = inst_116828);


cljs.core.async.impl.ioc_helpers.process_exception(state_116851__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116852 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116851,(3),Error,null,(2));
var inst_116832 = fluree.db.util.async.channel_QMARK_(email);
var state_116851__$1 = state_116851;
if(inst_116832){
var statearr_116855_116867 = state_116851__$1;
(statearr_116855_116867[(1)] = (5));

} else {
var statearr_116856_116868 = state_116851__$1;
(statearr_116856_116868[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116852 === (5))){
var state_116851__$1 = state_116851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116851__$1,(8),email);
} else {
if((state_val_116852 === (6))){
var state_116851__$1 = state_116851;
var statearr_116857_116869 = state_116851__$1;
(statearr_116857_116869[(2)] = email);

(statearr_116857_116869[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116852 === (7))){
var inst_116839 = (state_116851[(2)]);
var inst_116840 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_116839);
var inst_116841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116842 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116843 = ["re-find",inst_116839,inst_116840];
var inst_116844 = cljs.core.PersistentHashMap.fromArrays(inst_116842,inst_116843);
var inst_116845 = [inst_116844,(10)];
var inst_116846 = (new cljs.core.PersistentVector(null,2,(5),inst_116841,inst_116845,null));
var inst_116847 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116846);
var state_116851__$1 = (function (){var statearr_116858 = state_116851;
(statearr_116858[(7)] = inst_116847);

return statearr_116858;
})();
var statearr_116859_116870 = state_116851__$1;
(statearr_116859_116870[(2)] = inst_116840);


cljs.core.async.impl.ioc_helpers.process_exception(state_116851__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116852 === (8))){
var inst_116835 = (state_116851[(2)]);
var inst_116836 = fluree.db.util.async.throw_err(inst_116835);
var state_116851__$1 = state_116851;
var statearr_116860_116871 = state_116851__$1;
(statearr_116860_116871[(2)] = inst_116836);

(statearr_116860_116871[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_116861 = [null,null,null,null,null,null,null,null];
(statearr_116861[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__);

(statearr_116861[(1)] = (1));

return statearr_116861;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____1 = (function (state_116851){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116851);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116862){if((e116862 instanceof Object)){
var ex__99040__auto__ = e116862;
var statearr_116863_116872 = state_116851;
(statearr_116863_116872[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116851);

return cljs.core.cst$kw$recur;
} else {
throw e116862;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116873 = state_116851;
state_116851 = G__116873;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__ = function(state_116851){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____1.call(this,state_116851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116864 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116864[(6)] = c__99059__auto__);

return statearr_116864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116917){
var state_val_116918 = (state_116917[(1)]);
if((state_val_116918 === (7))){
var inst_116903 = (state_116917[(2)]);
var inst_116904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116903,(0),null);
var inst_116905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_116903,(1),null);
var inst_116906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116907 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116908 = ["?user_id","?ctx",inst_116904];
var inst_116909 = cljs.core.PersistentHashMap.fromArrays(inst_116907,inst_116908);
var inst_116910 = ((10) + inst_116905);
var inst_116911 = [inst_116909,inst_116910];
var inst_116912 = (new cljs.core.PersistentVector(null,2,(5),inst_116906,inst_116911,null));
var inst_116913 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116912);
var state_116917__$1 = (function (){var statearr_116919 = state_116917;
(statearr_116919[(7)] = inst_116913);

return statearr_116919;
})();
var statearr_116920_116939 = state_116917__$1;
(statearr_116920_116939[(2)] = inst_116904);


cljs.core.async.impl.ioc_helpers.process_exception(state_116917__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (1))){
var state_116917__$1 = state_116917;
var statearr_116921_116940 = state_116917__$1;
(statearr_116921_116940[(2)] = null);

(statearr_116921_116940[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116917,(3),Error,null,(2));
var inst_116881 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_116917__$1 = state_116917;
if(cljs.core.truth_(inst_116881)){
var statearr_116922_116941 = state_116917__$1;
(statearr_116922_116941[(1)] = (5));

} else {
var statearr_116923_116942 = state_116917__$1;
(statearr_116923_116942[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (13))){
var state_116917__$1 = state_116917;
var statearr_116924_116943 = state_116917__$1;
(statearr_116924_116943[(2)] = null);

(statearr_116924_116943[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (6))){
var inst_116888 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_116917__$1 = state_116917;
if(cljs.core.truth_(inst_116888)){
var statearr_116925_116944 = state_116917__$1;
(statearr_116925_116944[(1)] = (8));

} else {
var statearr_116926_116945 = state_116917__$1;
(statearr_116926_116945[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (3))){
var inst_116874 = (state_116917[(2)]);
var state_116917__$1 = state_116917;
var statearr_116927_116946 = state_116917__$1;
(statearr_116927_116946[(2)] = inst_116874);


cljs.core.async.impl.ioc_helpers.process_exception(state_116917__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (12))){
var inst_116896 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_116917__$1 = state_116917;
var statearr_116928_116947 = state_116917__$1;
(statearr_116928_116947[(2)] = inst_116896);

(statearr_116928_116947[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (2))){
var inst_116915 = (state_116917[(2)]);
var state_116917__$1 = state_116917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116917__$1,inst_116915);
} else {
if((state_val_116918 === (11))){
var inst_116892 = (state_116917[(2)]);
var inst_116893 = fluree.db.util.async.throw_err(inst_116892);
var state_116917__$1 = state_116917;
var statearr_116929_116948 = state_116917__$1;
(statearr_116929_116948[(2)] = inst_116893);

(statearr_116929_116948[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (9))){
var state_116917__$1 = state_116917;
var statearr_116930_116949 = state_116917__$1;
(statearr_116930_116949[(1)] = (12));



return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (5))){
var inst_116883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116884 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_116885 = [inst_116884,(0)];
var inst_116886 = (new cljs.core.PersistentVector(null,2,(5),inst_116883,inst_116885,null));
var state_116917__$1 = state_116917;
var statearr_116932_116950 = state_116917__$1;
(statearr_116932_116950[(2)] = inst_116886);

(statearr_116932_116950[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (14))){
var inst_116899 = (state_116917[(2)]);
var state_116917__$1 = state_116917;
var statearr_116933_116951 = state_116917__$1;
(statearr_116933_116951[(2)] = inst_116899);

(statearr_116933_116951[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (10))){
var inst_116901 = (state_116917[(2)]);
var state_116917__$1 = state_116917;
var statearr_116934_116952 = state_116917__$1;
(statearr_116934_116952[(2)] = inst_116901);

(statearr_116934_116952[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116918 === (8))){
var inst_116890 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_116917__$1 = state_116917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116917__$1,(11),inst_116890);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____0 = (function (){
var statearr_116935 = [null,null,null,null,null,null,null,null];
(statearr_116935[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__);

(statearr_116935[(1)] = (1));

return statearr_116935;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____1 = (function (state_116917){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116917);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116936){if((e116936 instanceof Object)){
var ex__99040__auto__ = e116936;
var statearr_116937_116953 = state_116917;
(statearr_116937_116953[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116917);

return cljs.core.cst$kw$recur;
} else {
throw e116936;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__116954 = state_116917;
state_116917 = G__116954;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__ = function(state_116917){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____1.call(this,state_116917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116938 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116938[(6)] = c__99059__auto__);

return statearr_116938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_116979){
var state_val_116980 = (state_116979[(1)]);
if((state_val_116980 === (1))){
var state_116979__$1 = state_116979;
var statearr_116981_116993 = state_116979__$1;
(statearr_116981_116993[(2)] = null);

(statearr_116981_116993[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116980 === (2))){
var inst_116977 = (state_116979[(2)]);
var state_116979__$1 = state_116979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116979__$1,inst_116977);
} else {
if((state_val_116980 === (3))){
var inst_116955 = (state_116979[(2)]);
var state_116979__$1 = state_116979;
var statearr_116982_116994 = state_116979__$1;
(statearr_116982_116994[(2)] = inst_116955);


cljs.core.async.impl.ioc_helpers.process_exception(state_116979__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116980 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116979,(3),Error,null,(2));
var inst_116959 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_116979__$1 = state_116979;
if(cljs.core.truth_(inst_116959)){
var statearr_116983_116995 = state_116979__$1;
(statearr_116983_116995[(1)] = (5));

} else {
var statearr_116984_116996 = state_116979__$1;
(statearr_116984_116996[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116980 === (5))){
var inst_116961 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_116979__$1 = state_116979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116979__$1,(8),inst_116961);
} else {
if((state_val_116980 === (6))){
var inst_116973 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_116979__$1 = state_116979;
var statearr_116985_116997 = state_116979__$1;
(statearr_116985_116997[(2)] = inst_116973);

(statearr_116985_116997[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116980 === (7))){
var inst_116975 = (state_116979[(2)]);
var state_116979__$1 = state_116979;
var statearr_116986_116998 = state_116979__$1;
(statearr_116986_116998[(2)] = inst_116975);


cljs.core.async.impl.ioc_helpers.process_exception(state_116979__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116980 === (8))){
var inst_116963 = (state_116979[(2)]);
var inst_116964 = fluree.db.util.async.throw_err(inst_116963);
var inst_116965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116966 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_116967 = ["?auth_id","?ctx",inst_116964];
var inst_116968 = cljs.core.PersistentHashMap.fromArrays(inst_116966,inst_116967);
var inst_116969 = [inst_116968,(10)];
var inst_116970 = (new cljs.core.PersistentVector(null,2,(5),inst_116965,inst_116969,null));
var inst_116971 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_116970);
var state_116979__$1 = (function (){var statearr_116987 = state_116979;
(statearr_116987[(7)] = inst_116971);

return statearr_116987;
})();
var statearr_116988_116999 = state_116979__$1;
(statearr_116988_116999[(2)] = inst_116964);

(statearr_116988_116999[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____0 = (function (){
var statearr_116989 = [null,null,null,null,null,null,null,null];
(statearr_116989[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__);

(statearr_116989[(1)] = (1));

return statearr_116989;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____1 = (function (state_116979){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_116979);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e116990){if((e116990 instanceof Object)){
var ex__99040__auto__ = e116990;
var statearr_116991_117000 = state_116979;
(statearr_116991_117000[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116979);

return cljs.core.cst$kw$recur;
} else {
throw e116990;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117001 = state_116979;
state_116979 = G__117001;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__ = function(state_116979){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____1.call(this,state_116979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_116992 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_116992[(6)] = c__99059__auto__);

return statearr_116992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__117003 = arguments.length;
switch (G__117003) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
});

fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117042){
var state_val_117043 = (state_117042[(1)]);
if((state_val_117043 === (7))){
var inst_117015 = (state_117042[(2)]);
var inst_117016 = fluree.db.util.async.channel_QMARK_(max);
var state_117042__$1 = (function (){var statearr_117044 = state_117042;
(statearr_117044[(7)] = inst_117015);

return statearr_117044;
})();
if(inst_117016){
var statearr_117045_117067 = state_117042__$1;
(statearr_117045_117067[(1)] = (9));

} else {
var statearr_117046_117068 = state_117042__$1;
(statearr_117046_117068[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (1))){
var state_117042__$1 = state_117042;
var statearr_117047_117069 = state_117042__$1;
(statearr_117047_117069[(2)] = null);

(statearr_117047_117069[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117042,(3),Error,null,(2));
var inst_117008 = fluree.db.util.async.channel_QMARK_(seed);
var state_117042__$1 = state_117042;
if(inst_117008){
var statearr_117048_117070 = state_117042__$1;
(statearr_117048_117070[(1)] = (5));

} else {
var statearr_117049_117071 = state_117042__$1;
(statearr_117049_117071[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (15))){
var inst_117015 = (state_117042[(7)]);
var inst_117027 = (state_117042[(2)]);
var inst_117028 = fluree.db.dbfunctions.internal.rand(inst_117015,inst_117027);
var inst_117029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117030 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_117031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117032 = [seed,max];
var inst_117033 = (new cljs.core.PersistentVector(null,2,(5),inst_117031,inst_117032,null));
var inst_117034 = ["rand",inst_117033,inst_117028];
var inst_117035 = cljs.core.PersistentHashMap.fromArrays(inst_117030,inst_117034);
var inst_117036 = [inst_117035,(10)];
var inst_117037 = (new cljs.core.PersistentVector(null,2,(5),inst_117029,inst_117036,null));
var inst_117038 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_117037);
var state_117042__$1 = (function (){var statearr_117050 = state_117042;
(statearr_117050[(8)] = inst_117038);

return statearr_117050;
})();
var statearr_117051_117072 = state_117042__$1;
(statearr_117051_117072[(2)] = inst_117028);


cljs.core.async.impl.ioc_helpers.process_exception(state_117042__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (13))){
var inst_117023 = (state_117042[(9)]);
var state_117042__$1 = state_117042;
var statearr_117052_117073 = state_117042__$1;
(statearr_117052_117073[(2)] = inst_117023);

(statearr_117052_117073[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (6))){
var state_117042__$1 = state_117042;
var statearr_117053_117074 = state_117042__$1;
(statearr_117053_117074[(2)] = seed);

(statearr_117053_117074[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (3))){
var inst_117004 = (state_117042[(2)]);
var state_117042__$1 = state_117042;
var statearr_117054_117075 = state_117042__$1;
(statearr_117054_117075[(2)] = inst_117004);


cljs.core.async.impl.ioc_helpers.process_exception(state_117042__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (12))){
var inst_117019 = (state_117042[(2)]);
var inst_117020 = fluree.db.util.async.throw_err(inst_117019);
var state_117042__$1 = state_117042;
var statearr_117055_117076 = state_117042__$1;
(statearr_117055_117076[(2)] = inst_117020);

(statearr_117055_117076[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (2))){
var inst_117040 = (state_117042[(2)]);
var state_117042__$1 = state_117042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117042__$1,inst_117040);
} else {
if((state_val_117043 === (11))){
var inst_117023 = (state_117042[(9)]);
var inst_117023__$1 = (state_117042[(2)]);
var state_117042__$1 = (function (){var statearr_117056 = state_117042;
(statearr_117056[(9)] = inst_117023__$1);

return statearr_117056;
})();
if(cljs.core.truth_(inst_117023__$1)){
var statearr_117057_117077 = state_117042__$1;
(statearr_117057_117077[(1)] = (13));

} else {
var statearr_117058_117078 = state_117042__$1;
(statearr_117058_117078[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (9))){
var state_117042__$1 = state_117042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117042__$1,(12),max);
} else {
if((state_val_117043 === (5))){
var state_117042__$1 = state_117042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117042__$1,(8),seed);
} else {
if((state_val_117043 === (14))){
var state_117042__$1 = state_117042;
var statearr_117059_117079 = state_117042__$1;
(statearr_117059_117079[(2)] = (10));

(statearr_117059_117079[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (10))){
var state_117042__$1 = state_117042;
var statearr_117060_117080 = state_117042__$1;
(statearr_117060_117080[(2)] = max);

(statearr_117060_117080[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117043 === (8))){
var inst_117011 = (state_117042[(2)]);
var inst_117012 = fluree.db.util.async.throw_err(inst_117011);
var state_117042__$1 = state_117042;
var statearr_117061_117081 = state_117042__$1;
(statearr_117061_117081[(2)] = inst_117012);

(statearr_117061_117081[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__99037__auto____0 = (function (){
var statearr_117062 = [null,null,null,null,null,null,null,null,null,null];
(statearr_117062[(0)] = fluree$db$dbfunctions$fns$state_machine__99037__auto__);

(statearr_117062[(1)] = (1));

return statearr_117062;
});
var fluree$db$dbfunctions$fns$state_machine__99037__auto____1 = (function (state_117042){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117042);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117063){if((e117063 instanceof Object)){
var ex__99040__auto__ = e117063;
var statearr_117064_117082 = state_117042;
(statearr_117064_117082[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117042);

return cljs.core.cst$kw$recur;
} else {
throw e117063;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117083 = state_117042;
state_117042 = G__117083;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__99037__auto__ = function(state_117042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__99037__auto____1.call(this,state_117042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117065 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117065[(6)] = c__99059__auto__);

return statearr_117065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3;

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117101){
var state_val_117102 = (state_117101[(1)]);
if((state_val_117102 === (1))){
var state_117101__$1 = state_117101;
var statearr_117103_117111 = state_117101__$1;
(statearr_117103_117111[(2)] = null);

(statearr_117103_117111[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117102 === (2))){
var inst_117099 = (state_117101[(2)]);
var state_117101__$1 = state_117101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117101__$1,inst_117099);
} else {
if((state_val_117102 === (3))){
var inst_117084 = (state_117101[(2)]);
var state_117101__$1 = state_117101;
var statearr_117104_117112 = state_117101__$1;
(statearr_117104_117112[(2)] = inst_117084);


cljs.core.async.impl.ioc_helpers.process_exception(state_117101__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117102 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117101,(3),Error,null,(2));
var inst_117088 = fluree.db.util.core.random_uuid();
var inst_117089 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117088);
var inst_117090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117091 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_117092 = cljs.core.PersistentVector.EMPTY;
var inst_117093 = ["uuid",inst_117092,inst_117089];
var inst_117094 = cljs.core.PersistentHashMap.fromArrays(inst_117091,inst_117093);
var inst_117095 = [inst_117094,(10)];
var inst_117096 = (new cljs.core.PersistentVector(null,2,(5),inst_117090,inst_117095,null));
var inst_117097 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_117096);
var state_117101__$1 = (function (){var statearr_117105 = state_117101;
(statearr_117105[(7)] = inst_117097);

return statearr_117105;
})();
var statearr_117106_117113 = state_117101__$1;
(statearr_117106_117113[(2)] = inst_117089);


cljs.core.async.impl.ioc_helpers.process_exception(state_117101__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____0 = (function (){
var statearr_117107 = [null,null,null,null,null,null,null,null];
(statearr_117107[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__);

(statearr_117107[(1)] = (1));

return statearr_117107;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____1 = (function (state_117101){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117101);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117108){if((e117108 instanceof Object)){
var ex__99040__auto__ = e117108;
var statearr_117109_117114 = state_117101;
(statearr_117109_117114[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117101);

return cljs.core.cst$kw$recur;
} else {
throw e117108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117115 = state_117101;
state_117101 = G__117115;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__ = function(state_117101){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____1.call(this,state_117101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117110 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117110[(6)] = c__99059__auto__);

return statearr_117110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117142){
var state_val_117143 = (state_117142[(1)]);
if((state_val_117143 === (1))){
var state_117142__$1 = state_117142;
var statearr_117144_117156 = state_117142__$1;
(statearr_117144_117156[(2)] = null);

(statearr_117144_117156[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117143 === (2))){
var inst_117140 = (state_117142[(2)]);
var state_117142__$1 = state_117142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117142__$1,inst_117140);
} else {
if((state_val_117143 === (3))){
var inst_117116 = (state_117142[(2)]);
var state_117142__$1 = state_117142;
var statearr_117145_117157 = state_117142__$1;
(statearr_117145_117157[(2)] = inst_117116);


cljs.core.async.impl.ioc_helpers.process_exception(state_117142__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117143 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117142,(3),Error,null,(2));
var inst_117120 = fluree.db.util.async.channel_QMARK_(num);
var state_117142__$1 = state_117142;
if(inst_117120){
var statearr_117146_117158 = state_117142__$1;
(statearr_117146_117158[(1)] = (5));

} else {
var statearr_117147_117159 = state_117142__$1;
(statearr_117147_117159[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117143 === (5))){
var state_117142__$1 = state_117142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117142__$1,(8),num);
} else {
if((state_val_117143 === (6))){
var state_117142__$1 = state_117142;
var statearr_117148_117160 = state_117142__$1;
(statearr_117148_117160[(2)] = num);

(statearr_117148_117160[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117143 === (7))){
var inst_117127 = (state_117142[(2)]);
var inst_117128 = fluree.db.dbfunctions.internal.ceil(inst_117127);
var inst_117129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117130 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_117131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117132 = [fluree.db.dbfunctions.fns.ceil];
var inst_117133 = (new cljs.core.PersistentVector(null,1,(5),inst_117131,inst_117132,null));
var inst_117134 = ["",inst_117133,inst_117128];
var inst_117135 = cljs.core.PersistentHashMap.fromArrays(inst_117130,inst_117134);
var inst_117136 = [inst_117135,(10)];
var inst_117137 = (new cljs.core.PersistentVector(null,2,(5),inst_117129,inst_117136,null));
var inst_117138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_117137);
var state_117142__$1 = (function (){var statearr_117149 = state_117142;
(statearr_117149[(7)] = inst_117138);

return statearr_117149;
})();
var statearr_117150_117161 = state_117142__$1;
(statearr_117150_117161[(2)] = inst_117128);


cljs.core.async.impl.ioc_helpers.process_exception(state_117142__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117143 === (8))){
var inst_117123 = (state_117142[(2)]);
var inst_117124 = fluree.db.util.async.throw_err(inst_117123);
var state_117142__$1 = state_117142;
var statearr_117151_117162 = state_117142__$1;
(statearr_117151_117162[(2)] = inst_117124);

(statearr_117151_117162[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____0 = (function (){
var statearr_117152 = [null,null,null,null,null,null,null,null];
(statearr_117152[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__);

(statearr_117152[(1)] = (1));

return statearr_117152;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____1 = (function (state_117142){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117142);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117153){if((e117153 instanceof Object)){
var ex__99040__auto__ = e117153;
var statearr_117154_117163 = state_117142;
(statearr_117154_117163[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117142);

return cljs.core.cst$kw$recur;
} else {
throw e117153;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117164 = state_117142;
state_117142 = G__117164;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__ = function(state_117142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____1.call(this,state_117142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117155 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117155[(6)] = c__99059__auto__);

return statearr_117155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_117191){
var state_val_117192 = (state_117191[(1)]);
if((state_val_117192 === (1))){
var state_117191__$1 = state_117191;
var statearr_117193_117205 = state_117191__$1;
(statearr_117193_117205[(2)] = null);

(statearr_117193_117205[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117192 === (2))){
var inst_117189 = (state_117191[(2)]);
var state_117191__$1 = state_117191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117191__$1,inst_117189);
} else {
if((state_val_117192 === (3))){
var inst_117165 = (state_117191[(2)]);
var state_117191__$1 = state_117191;
var statearr_117194_117206 = state_117191__$1;
(statearr_117194_117206[(2)] = inst_117165);


cljs.core.async.impl.ioc_helpers.process_exception(state_117191__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117192 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117191,(3),Error,null,(2));
var inst_117169 = fluree.db.util.async.channel_QMARK_(num);
var state_117191__$1 = state_117191;
if(inst_117169){
var statearr_117195_117207 = state_117191__$1;
(statearr_117195_117207[(1)] = (5));

} else {
var statearr_117196_117208 = state_117191__$1;
(statearr_117196_117208[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117192 === (5))){
var state_117191__$1 = state_117191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117191__$1,(8),num);
} else {
if((state_val_117192 === (6))){
var state_117191__$1 = state_117191;
var statearr_117197_117209 = state_117191__$1;
(statearr_117197_117209[(2)] = num);

(statearr_117197_117209[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117192 === (7))){
var inst_117176 = (state_117191[(2)]);
var inst_117177 = fluree.db.dbfunctions.internal.floor(inst_117176);
var inst_117178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117179 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_117180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117181 = [fluree.db.dbfunctions.fns.floor];
var inst_117182 = (new cljs.core.PersistentVector(null,1,(5),inst_117180,inst_117181,null));
var inst_117183 = ["",inst_117182,inst_117177];
var inst_117184 = cljs.core.PersistentHashMap.fromArrays(inst_117179,inst_117183);
var inst_117185 = [inst_117184,(10)];
var inst_117186 = (new cljs.core.PersistentVector(null,2,(5),inst_117178,inst_117185,null));
var inst_117187 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_117186);
var state_117191__$1 = (function (){var statearr_117198 = state_117191;
(statearr_117198[(7)] = inst_117187);

return statearr_117198;
})();
var statearr_117199_117210 = state_117191__$1;
(statearr_117199_117210[(2)] = inst_117177);


cljs.core.async.impl.ioc_helpers.process_exception(state_117191__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117192 === (8))){
var inst_117172 = (state_117191[(2)]);
var inst_117173 = fluree.db.util.async.throw_err(inst_117172);
var state_117191__$1 = state_117191;
var statearr_117200_117211 = state_117191__$1;
(statearr_117200_117211[(2)] = inst_117173);

(statearr_117200_117211[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____0 = (function (){
var statearr_117201 = [null,null,null,null,null,null,null,null];
(statearr_117201[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__);

(statearr_117201[(1)] = (1));

return statearr_117201;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____1 = (function (state_117191){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_117191);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e117202){if((e117202 instanceof Object)){
var ex__99040__auto__ = e117202;
var statearr_117203_117212 = state_117191;
(statearr_117203_117212[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117191);

return cljs.core.cst$kw$recur;
} else {
throw e117202;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__117213 = state_117191;
state_117191 = G__117213;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__ = function(state_117191){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____1.call(this,state_117191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_117204 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_117204[(6)] = c__99059__auto__);

return statearr_117204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=fns.js.map?rel=1593118621257
