// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__7228 = arguments.length;
switch (G__7228) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async7229 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async7229 = (function (f,blockable,meta7230){
this.f = f;
this.blockable = blockable;
this.meta7230 = meta7230;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7231,meta7230__$1){
var self__ = this;
var _7231__$1 = this;
return (new cljs.core.async.t_cljs$core$async7229(self__.f,self__.blockable,meta7230__$1));
}));

(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7231){
var self__ = this;
var _7231__$1 = this;
return self__.meta7230;
}));

(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async7229.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async7229.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta7230","meta7230",1129732092,null)], null);
}));

(cljs.core.async.t_cljs$core$async7229.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async7229.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async7229");

(cljs.core.async.t_cljs$core$async7229.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async7229");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async7229.
 */
cljs.core.async.__GT_t_cljs$core$async7229 = (function cljs$core$async$__GT_t_cljs$core$async7229(f__$1,blockable__$1,meta7230){
return (new cljs.core.async.t_cljs$core$async7229(f__$1,blockable__$1,meta7230));
});

}

return (new cljs.core.async.t_cljs$core$async7229(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__7235 = arguments.length;
switch (G__7235) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__7238 = arguments.length;
switch (G__7238) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__7241 = arguments.length;
switch (G__7241) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_7243 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_7243);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_7243);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__7245 = arguments.length;
switch (G__7245) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___7247 = n;
var x_7248 = (0);
while(true){
if((x_7248 < n__4613__auto___7247)){
(a[x_7248] = x_7248);

var G__7249 = (x_7248 + (1));
x_7248 = G__7249;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async7250 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async7250 = (function (flag,meta7251){
this.flag = flag;
this.meta7251 = meta7251;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7252,meta7251__$1){
var self__ = this;
var _7252__$1 = this;
return (new cljs.core.async.t_cljs$core$async7250(self__.flag,meta7251__$1));
}));

(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7252){
var self__ = this;
var _7252__$1 = this;
return self__.meta7251;
}));

(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async7250.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async7250.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta7251","meta7251",367368376,null)], null);
}));

(cljs.core.async.t_cljs$core$async7250.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async7250.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async7250");

(cljs.core.async.t_cljs$core$async7250.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async7250");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async7250.
 */
cljs.core.async.__GT_t_cljs$core$async7250 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async7250(flag__$1,meta7251){
return (new cljs.core.async.t_cljs$core$async7250(flag__$1,meta7251));
});

}

return (new cljs.core.async.t_cljs$core$async7250(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async7253 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async7253 = (function (flag,cb,meta7254){
this.flag = flag;
this.cb = cb;
this.meta7254 = meta7254;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7255,meta7254__$1){
var self__ = this;
var _7255__$1 = this;
return (new cljs.core.async.t_cljs$core$async7253(self__.flag,self__.cb,meta7254__$1));
}));

(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7255){
var self__ = this;
var _7255__$1 = this;
return self__.meta7254;
}));

(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async7253.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async7253.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta7254","meta7254",-1428089622,null)], null);
}));

(cljs.core.async.t_cljs$core$async7253.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async7253.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async7253");

(cljs.core.async.t_cljs$core$async7253.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async7253");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async7253.
 */
cljs.core.async.__GT_t_cljs$core$async7253 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async7253(flag__$1,cb__$1,meta7254){
return (new cljs.core.async.t_cljs$core$async7253(flag__$1,cb__$1,meta7254));
});

}

return (new cljs.core.async.t_cljs$core$async7253(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__7256_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__7256_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__7257_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__7257_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__7258 = (i + (1));
i = G__7258;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___7264 = arguments.length;
var i__4737__auto___7265 = (0);
while(true){
if((i__4737__auto___7265 < len__4736__auto___7264)){
args__4742__auto__.push((arguments[i__4737__auto___7265]));

var G__7266 = (i__4737__auto___7265 + (1));
i__4737__auto___7265 = G__7266;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__7261){
var map__7262 = p__7261;
var map__7262__$1 = (((((!((map__7262 == null))))?(((((map__7262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7262):map__7262);
var opts = map__7262__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq7259){
var G__7260 = cljs.core.first.call(null,seq7259);
var seq7259__$1 = cljs.core.next.call(null,seq7259);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7260,seq7259__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__7268 = arguments.length;
switch (G__7268) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7168__auto___7315 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7292){
var state_val_7293 = (state_7292[(1)]);
if((state_val_7293 === (7))){
var inst_7288 = (state_7292[(2)]);
var state_7292__$1 = state_7292;
var statearr_7294_7316 = state_7292__$1;
(statearr_7294_7316[(2)] = inst_7288);

(statearr_7294_7316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (1))){
var state_7292__$1 = state_7292;
var statearr_7295_7317 = state_7292__$1;
(statearr_7295_7317[(2)] = null);

(statearr_7295_7317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (4))){
var inst_7271 = (state_7292[(7)]);
var inst_7271__$1 = (state_7292[(2)]);
var inst_7272 = (inst_7271__$1 == null);
var state_7292__$1 = (function (){var statearr_7296 = state_7292;
(statearr_7296[(7)] = inst_7271__$1);

return statearr_7296;
})();
if(cljs.core.truth_(inst_7272)){
var statearr_7297_7318 = state_7292__$1;
(statearr_7297_7318[(1)] = (5));

} else {
var statearr_7298_7319 = state_7292__$1;
(statearr_7298_7319[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (13))){
var state_7292__$1 = state_7292;
var statearr_7299_7320 = state_7292__$1;
(statearr_7299_7320[(2)] = null);

(statearr_7299_7320[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (6))){
var inst_7271 = (state_7292[(7)]);
var state_7292__$1 = state_7292;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7292__$1,(11),to,inst_7271);
} else {
if((state_val_7293 === (3))){
var inst_7290 = (state_7292[(2)]);
var state_7292__$1 = state_7292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7292__$1,inst_7290);
} else {
if((state_val_7293 === (12))){
var state_7292__$1 = state_7292;
var statearr_7300_7321 = state_7292__$1;
(statearr_7300_7321[(2)] = null);

(statearr_7300_7321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (2))){
var state_7292__$1 = state_7292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7292__$1,(4),from);
} else {
if((state_val_7293 === (11))){
var inst_7281 = (state_7292[(2)]);
var state_7292__$1 = state_7292;
if(cljs.core.truth_(inst_7281)){
var statearr_7301_7322 = state_7292__$1;
(statearr_7301_7322[(1)] = (12));

} else {
var statearr_7302_7323 = state_7292__$1;
(statearr_7302_7323[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (9))){
var state_7292__$1 = state_7292;
var statearr_7303_7324 = state_7292__$1;
(statearr_7303_7324[(2)] = null);

(statearr_7303_7324[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (5))){
var state_7292__$1 = state_7292;
if(cljs.core.truth_(close_QMARK_)){
var statearr_7304_7325 = state_7292__$1;
(statearr_7304_7325[(1)] = (8));

} else {
var statearr_7305_7326 = state_7292__$1;
(statearr_7305_7326[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (14))){
var inst_7286 = (state_7292[(2)]);
var state_7292__$1 = state_7292;
var statearr_7306_7327 = state_7292__$1;
(statearr_7306_7327[(2)] = inst_7286);

(statearr_7306_7327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (10))){
var inst_7278 = (state_7292[(2)]);
var state_7292__$1 = state_7292;
var statearr_7307_7328 = state_7292__$1;
(statearr_7307_7328[(2)] = inst_7278);

(statearr_7307_7328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7293 === (8))){
var inst_7275 = cljs.core.async.close_BANG_.call(null,to);
var state_7292__$1 = state_7292;
var statearr_7308_7329 = state_7292__$1;
(statearr_7308_7329[(2)] = inst_7275);

(statearr_7308_7329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_7309 = [null,null,null,null,null,null,null,null];
(statearr_7309[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_7309[(1)] = (1));

return statearr_7309;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_7292){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7310){var ex__7098__auto__ = e7310;
var statearr_7311_7330 = state_7292;
(statearr_7311_7330[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7292[(4)]))){
var statearr_7312_7331 = state_7292;
(statearr_7312_7331[(1)] = cljs.core.first.call(null,(state_7292[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7332 = state_7292;
state_7292 = G__7332;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_7292){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_7292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7313 = f__7169__auto__.call(null);
(statearr_7313[(6)] = c__7168__auto___7315);

return statearr_7313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__7333){
var vec__7334 = p__7333;
var v = cljs.core.nth.call(null,vec__7334,(0),null);
var p = cljs.core.nth.call(null,vec__7334,(1),null);
var job = vec__7334;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7168__auto___7510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7341){
var state_val_7342 = (state_7341[(1)]);
if((state_val_7342 === (1))){
var state_7341__$1 = state_7341;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7341__$1,(2),res,v);
} else {
if((state_val_7342 === (2))){
var inst_7338 = (state_7341[(2)]);
var inst_7339 = cljs.core.async.close_BANG_.call(null,res);
var state_7341__$1 = (function (){var statearr_7343 = state_7341;
(statearr_7343[(7)] = inst_7338);

return statearr_7343;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7341__$1,inst_7339);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_7344 = [null,null,null,null,null,null,null,null];
(statearr_7344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__);

(statearr_7344[(1)] = (1));

return statearr_7344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1 = (function (state_7341){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7345){var ex__7098__auto__ = e7345;
var statearr_7346_7511 = state_7341;
(statearr_7346_7511[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7341[(4)]))){
var statearr_7347_7512 = state_7341;
(statearr_7347_7512[(1)] = cljs.core.first.call(null,(state_7341[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7513 = state_7341;
state_7341 = G__7513;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = function(state_7341){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1.call(this,state_7341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7348 = f__7169__auto__.call(null);
(statearr_7348[(6)] = c__7168__auto___7510);

return statearr_7348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__7349){
var vec__7350 = p__7349;
var v = cljs.core.nth.call(null,vec__7350,(0),null);
var p = cljs.core.nth.call(null,vec__7350,(1),null);
var job = vec__7350;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___7514 = n;
var __7515 = (0);
while(true){
if((__7515 < n__4613__auto___7514)){
var G__7353_7516 = type;
var G__7353_7517__$1 = (((G__7353_7516 instanceof cljs.core.Keyword))?G__7353_7516.fqn:null);
switch (G__7353_7517__$1) {
case "compute":
var c__7168__auto___7519 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__7515,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = ((function (__7515,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function (state_7366){
var state_val_7367 = (state_7366[(1)]);
if((state_val_7367 === (1))){
var state_7366__$1 = state_7366;
var statearr_7368_7520 = state_7366__$1;
(statearr_7368_7520[(2)] = null);

(statearr_7368_7520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7367 === (2))){
var state_7366__$1 = state_7366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7366__$1,(4),jobs);
} else {
if((state_val_7367 === (3))){
var inst_7364 = (state_7366[(2)]);
var state_7366__$1 = state_7366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7366__$1,inst_7364);
} else {
if((state_val_7367 === (4))){
var inst_7356 = (state_7366[(2)]);
var inst_7357 = process.call(null,inst_7356);
var state_7366__$1 = state_7366;
if(cljs.core.truth_(inst_7357)){
var statearr_7369_7521 = state_7366__$1;
(statearr_7369_7521[(1)] = (5));

} else {
var statearr_7370_7522 = state_7366__$1;
(statearr_7370_7522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7367 === (5))){
var state_7366__$1 = state_7366;
var statearr_7371_7523 = state_7366__$1;
(statearr_7371_7523[(2)] = null);

(statearr_7371_7523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7367 === (6))){
var state_7366__$1 = state_7366;
var statearr_7372_7524 = state_7366__$1;
(statearr_7372_7524[(2)] = null);

(statearr_7372_7524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7367 === (7))){
var inst_7362 = (state_7366[(2)]);
var state_7366__$1 = state_7366;
var statearr_7373_7525 = state_7366__$1;
(statearr_7373_7525[(2)] = inst_7362);

(statearr_7373_7525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__7515,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
;
return ((function (__7515,switch__7094__auto__,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_7374 = [null,null,null,null,null,null,null];
(statearr_7374[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__);

(statearr_7374[(1)] = (1));

return statearr_7374;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1 = (function (state_7366){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7375){var ex__7098__auto__ = e7375;
var statearr_7376_7526 = state_7366;
(statearr_7376_7526[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7366[(4)]))){
var statearr_7377_7527 = state_7366;
(statearr_7377_7527[(1)] = cljs.core.first.call(null,(state_7366[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7528 = state_7366;
state_7366 = G__7528;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = function(state_7366){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1.call(this,state_7366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__;
})()
;})(__7515,switch__7094__auto__,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
})();
var state__7170__auto__ = (function (){var statearr_7378 = f__7169__auto__.call(null);
(statearr_7378[(6)] = c__7168__auto___7519);

return statearr_7378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
});})(__7515,c__7168__auto___7519,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
);


break;
case "async":
var c__7168__auto___7529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__7515,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = ((function (__7515,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function (state_7391){
var state_val_7392 = (state_7391[(1)]);
if((state_val_7392 === (1))){
var state_7391__$1 = state_7391;
var statearr_7393_7530 = state_7391__$1;
(statearr_7393_7530[(2)] = null);

(statearr_7393_7530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7392 === (2))){
var state_7391__$1 = state_7391;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7391__$1,(4),jobs);
} else {
if((state_val_7392 === (3))){
var inst_7389 = (state_7391[(2)]);
var state_7391__$1 = state_7391;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7391__$1,inst_7389);
} else {
if((state_val_7392 === (4))){
var inst_7381 = (state_7391[(2)]);
var inst_7382 = async.call(null,inst_7381);
var state_7391__$1 = state_7391;
if(cljs.core.truth_(inst_7382)){
var statearr_7394_7531 = state_7391__$1;
(statearr_7394_7531[(1)] = (5));

} else {
var statearr_7395_7532 = state_7391__$1;
(statearr_7395_7532[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7392 === (5))){
var state_7391__$1 = state_7391;
var statearr_7396_7533 = state_7391__$1;
(statearr_7396_7533[(2)] = null);

(statearr_7396_7533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7392 === (6))){
var state_7391__$1 = state_7391;
var statearr_7397_7534 = state_7391__$1;
(statearr_7397_7534[(2)] = null);

(statearr_7397_7534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7392 === (7))){
var inst_7387 = (state_7391[(2)]);
var state_7391__$1 = state_7391;
var statearr_7398_7535 = state_7391__$1;
(statearr_7398_7535[(2)] = inst_7387);

(statearr_7398_7535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__7515,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
;
return ((function (__7515,switch__7094__auto__,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_7399 = [null,null,null,null,null,null,null];
(statearr_7399[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__);

(statearr_7399[(1)] = (1));

return statearr_7399;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1 = (function (state_7391){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7391);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7400){var ex__7098__auto__ = e7400;
var statearr_7401_7536 = state_7391;
(statearr_7401_7536[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7391[(4)]))){
var statearr_7402_7537 = state_7391;
(statearr_7402_7537[(1)] = cljs.core.first.call(null,(state_7391[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7538 = state_7391;
state_7391 = G__7538;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = function(state_7391){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1.call(this,state_7391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__;
})()
;})(__7515,switch__7094__auto__,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
})();
var state__7170__auto__ = (function (){var statearr_7403 = f__7169__auto__.call(null);
(statearr_7403[(6)] = c__7168__auto___7529);

return statearr_7403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
});})(__7515,c__7168__auto___7529,G__7353_7516,G__7353_7517__$1,n__4613__auto___7514,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__7353_7517__$1)].join('')));

}

var G__7539 = (__7515 + (1));
__7515 = G__7539;
continue;
} else {
}
break;
}

var c__7168__auto___7540 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7425){
var state_val_7426 = (state_7425[(1)]);
if((state_val_7426 === (7))){
var inst_7421 = (state_7425[(2)]);
var state_7425__$1 = state_7425;
var statearr_7427_7541 = state_7425__$1;
(statearr_7427_7541[(2)] = inst_7421);

(statearr_7427_7541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7426 === (1))){
var state_7425__$1 = state_7425;
var statearr_7428_7542 = state_7425__$1;
(statearr_7428_7542[(2)] = null);

(statearr_7428_7542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7426 === (4))){
var inst_7406 = (state_7425[(7)]);
var inst_7406__$1 = (state_7425[(2)]);
var inst_7407 = (inst_7406__$1 == null);
var state_7425__$1 = (function (){var statearr_7429 = state_7425;
(statearr_7429[(7)] = inst_7406__$1);

return statearr_7429;
})();
if(cljs.core.truth_(inst_7407)){
var statearr_7430_7543 = state_7425__$1;
(statearr_7430_7543[(1)] = (5));

} else {
var statearr_7431_7544 = state_7425__$1;
(statearr_7431_7544[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7426 === (6))){
var inst_7411 = (state_7425[(8)]);
var inst_7406 = (state_7425[(7)]);
var inst_7411__$1 = cljs.core.async.chan.call(null,(1));
var inst_7412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_7413 = [inst_7406,inst_7411__$1];
var inst_7414 = (new cljs.core.PersistentVector(null,2,(5),inst_7412,inst_7413,null));
var state_7425__$1 = (function (){var statearr_7432 = state_7425;
(statearr_7432[(8)] = inst_7411__$1);

return statearr_7432;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7425__$1,(8),jobs,inst_7414);
} else {
if((state_val_7426 === (3))){
var inst_7423 = (state_7425[(2)]);
var state_7425__$1 = state_7425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7425__$1,inst_7423);
} else {
if((state_val_7426 === (2))){
var state_7425__$1 = state_7425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7425__$1,(4),from);
} else {
if((state_val_7426 === (9))){
var inst_7418 = (state_7425[(2)]);
var state_7425__$1 = (function (){var statearr_7433 = state_7425;
(statearr_7433[(9)] = inst_7418);

return statearr_7433;
})();
var statearr_7434_7545 = state_7425__$1;
(statearr_7434_7545[(2)] = null);

(statearr_7434_7545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7426 === (5))){
var inst_7409 = cljs.core.async.close_BANG_.call(null,jobs);
var state_7425__$1 = state_7425;
var statearr_7435_7546 = state_7425__$1;
(statearr_7435_7546[(2)] = inst_7409);

(statearr_7435_7546[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7426 === (8))){
var inst_7411 = (state_7425[(8)]);
var inst_7416 = (state_7425[(2)]);
var state_7425__$1 = (function (){var statearr_7436 = state_7425;
(statearr_7436[(10)] = inst_7416);

return statearr_7436;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7425__$1,(9),results,inst_7411);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_7437 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_7437[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__);

(statearr_7437[(1)] = (1));

return statearr_7437;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1 = (function (state_7425){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7438){var ex__7098__auto__ = e7438;
var statearr_7439_7547 = state_7425;
(statearr_7439_7547[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7425[(4)]))){
var statearr_7440_7548 = state_7425;
(statearr_7440_7548[(1)] = cljs.core.first.call(null,(state_7425[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7549 = state_7425;
state_7425 = G__7549;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = function(state_7425){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1.call(this,state_7425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7441 = f__7169__auto__.call(null);
(statearr_7441[(6)] = c__7168__auto___7540);

return statearr_7441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


var c__7168__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7479){
var state_val_7480 = (state_7479[(1)]);
if((state_val_7480 === (7))){
var inst_7475 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
var statearr_7481_7550 = state_7479__$1;
(statearr_7481_7550[(2)] = inst_7475);

(statearr_7481_7550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (20))){
var state_7479__$1 = state_7479;
var statearr_7482_7551 = state_7479__$1;
(statearr_7482_7551[(2)] = null);

(statearr_7482_7551[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (1))){
var state_7479__$1 = state_7479;
var statearr_7483_7552 = state_7479__$1;
(statearr_7483_7552[(2)] = null);

(statearr_7483_7552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (4))){
var inst_7444 = (state_7479[(7)]);
var inst_7444__$1 = (state_7479[(2)]);
var inst_7445 = (inst_7444__$1 == null);
var state_7479__$1 = (function (){var statearr_7484 = state_7479;
(statearr_7484[(7)] = inst_7444__$1);

return statearr_7484;
})();
if(cljs.core.truth_(inst_7445)){
var statearr_7485_7553 = state_7479__$1;
(statearr_7485_7553[(1)] = (5));

} else {
var statearr_7486_7554 = state_7479__$1;
(statearr_7486_7554[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (15))){
var inst_7457 = (state_7479[(8)]);
var state_7479__$1 = state_7479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7479__$1,(18),to,inst_7457);
} else {
if((state_val_7480 === (21))){
var inst_7470 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
var statearr_7487_7555 = state_7479__$1;
(statearr_7487_7555[(2)] = inst_7470);

(statearr_7487_7555[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (13))){
var inst_7472 = (state_7479[(2)]);
var state_7479__$1 = (function (){var statearr_7488 = state_7479;
(statearr_7488[(9)] = inst_7472);

return statearr_7488;
})();
var statearr_7489_7556 = state_7479__$1;
(statearr_7489_7556[(2)] = null);

(statearr_7489_7556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (6))){
var inst_7444 = (state_7479[(7)]);
var state_7479__$1 = state_7479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7479__$1,(11),inst_7444);
} else {
if((state_val_7480 === (17))){
var inst_7465 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
if(cljs.core.truth_(inst_7465)){
var statearr_7490_7557 = state_7479__$1;
(statearr_7490_7557[(1)] = (19));

} else {
var statearr_7491_7558 = state_7479__$1;
(statearr_7491_7558[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (3))){
var inst_7477 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7479__$1,inst_7477);
} else {
if((state_val_7480 === (12))){
var inst_7454 = (state_7479[(10)]);
var state_7479__$1 = state_7479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7479__$1,(14),inst_7454);
} else {
if((state_val_7480 === (2))){
var state_7479__$1 = state_7479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7479__$1,(4),results);
} else {
if((state_val_7480 === (19))){
var state_7479__$1 = state_7479;
var statearr_7492_7559 = state_7479__$1;
(statearr_7492_7559[(2)] = null);

(statearr_7492_7559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (11))){
var inst_7454 = (state_7479[(2)]);
var state_7479__$1 = (function (){var statearr_7493 = state_7479;
(statearr_7493[(10)] = inst_7454);

return statearr_7493;
})();
var statearr_7494_7560 = state_7479__$1;
(statearr_7494_7560[(2)] = null);

(statearr_7494_7560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (9))){
var state_7479__$1 = state_7479;
var statearr_7495_7561 = state_7479__$1;
(statearr_7495_7561[(2)] = null);

(statearr_7495_7561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (5))){
var state_7479__$1 = state_7479;
if(cljs.core.truth_(close_QMARK_)){
var statearr_7496_7562 = state_7479__$1;
(statearr_7496_7562[(1)] = (8));

} else {
var statearr_7497_7563 = state_7479__$1;
(statearr_7497_7563[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (14))){
var inst_7457 = (state_7479[(8)]);
var inst_7457__$1 = (state_7479[(2)]);
var inst_7458 = (inst_7457__$1 == null);
var inst_7459 = cljs.core.not.call(null,inst_7458);
var state_7479__$1 = (function (){var statearr_7498 = state_7479;
(statearr_7498[(8)] = inst_7457__$1);

return statearr_7498;
})();
if(inst_7459){
var statearr_7499_7564 = state_7479__$1;
(statearr_7499_7564[(1)] = (15));

} else {
var statearr_7500_7565 = state_7479__$1;
(statearr_7500_7565[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (16))){
var state_7479__$1 = state_7479;
var statearr_7501_7566 = state_7479__$1;
(statearr_7501_7566[(2)] = false);

(statearr_7501_7566[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (10))){
var inst_7451 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
var statearr_7502_7567 = state_7479__$1;
(statearr_7502_7567[(2)] = inst_7451);

(statearr_7502_7567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (18))){
var inst_7462 = (state_7479[(2)]);
var state_7479__$1 = state_7479;
var statearr_7503_7568 = state_7479__$1;
(statearr_7503_7568[(2)] = inst_7462);

(statearr_7503_7568[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7480 === (8))){
var inst_7448 = cljs.core.async.close_BANG_.call(null,to);
var state_7479__$1 = state_7479;
var statearr_7504_7569 = state_7479__$1;
(statearr_7504_7569[(2)] = inst_7448);

(statearr_7504_7569[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_7505 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_7505[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__);

(statearr_7505[(1)] = (1));

return statearr_7505;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1 = (function (state_7479){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7506){var ex__7098__auto__ = e7506;
var statearr_7507_7570 = state_7479;
(statearr_7507_7570[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7479[(4)]))){
var statearr_7508_7571 = state_7479;
(statearr_7508_7571[(1)] = cljs.core.first.call(null,(state_7479[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7572 = state_7479;
state_7479 = G__7572;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__ = function(state_7479){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1.call(this,state_7479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7509 = f__7169__auto__.call(null);
(statearr_7509[(6)] = c__7168__auto__);

return statearr_7509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));

return c__7168__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__7574 = arguments.length;
switch (G__7574) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__7577 = arguments.length;
switch (G__7577) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__7580 = arguments.length;
switch (G__7580) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7168__auto___7630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7606){
var state_val_7607 = (state_7606[(1)]);
if((state_val_7607 === (7))){
var inst_7602 = (state_7606[(2)]);
var state_7606__$1 = state_7606;
var statearr_7608_7631 = state_7606__$1;
(statearr_7608_7631[(2)] = inst_7602);

(statearr_7608_7631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (1))){
var state_7606__$1 = state_7606;
var statearr_7609_7632 = state_7606__$1;
(statearr_7609_7632[(2)] = null);

(statearr_7609_7632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (4))){
var inst_7583 = (state_7606[(7)]);
var inst_7583__$1 = (state_7606[(2)]);
var inst_7584 = (inst_7583__$1 == null);
var state_7606__$1 = (function (){var statearr_7610 = state_7606;
(statearr_7610[(7)] = inst_7583__$1);

return statearr_7610;
})();
if(cljs.core.truth_(inst_7584)){
var statearr_7611_7633 = state_7606__$1;
(statearr_7611_7633[(1)] = (5));

} else {
var statearr_7612_7634 = state_7606__$1;
(statearr_7612_7634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (13))){
var state_7606__$1 = state_7606;
var statearr_7613_7635 = state_7606__$1;
(statearr_7613_7635[(2)] = null);

(statearr_7613_7635[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (6))){
var inst_7583 = (state_7606[(7)]);
var inst_7589 = p.call(null,inst_7583);
var state_7606__$1 = state_7606;
if(cljs.core.truth_(inst_7589)){
var statearr_7614_7636 = state_7606__$1;
(statearr_7614_7636[(1)] = (9));

} else {
var statearr_7615_7637 = state_7606__$1;
(statearr_7615_7637[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (3))){
var inst_7604 = (state_7606[(2)]);
var state_7606__$1 = state_7606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7606__$1,inst_7604);
} else {
if((state_val_7607 === (12))){
var state_7606__$1 = state_7606;
var statearr_7616_7638 = state_7606__$1;
(statearr_7616_7638[(2)] = null);

(statearr_7616_7638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (2))){
var state_7606__$1 = state_7606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7606__$1,(4),ch);
} else {
if((state_val_7607 === (11))){
var inst_7583 = (state_7606[(7)]);
var inst_7593 = (state_7606[(2)]);
var state_7606__$1 = state_7606;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7606__$1,(8),inst_7593,inst_7583);
} else {
if((state_val_7607 === (9))){
var state_7606__$1 = state_7606;
var statearr_7617_7639 = state_7606__$1;
(statearr_7617_7639[(2)] = tc);

(statearr_7617_7639[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (5))){
var inst_7586 = cljs.core.async.close_BANG_.call(null,tc);
var inst_7587 = cljs.core.async.close_BANG_.call(null,fc);
var state_7606__$1 = (function (){var statearr_7618 = state_7606;
(statearr_7618[(8)] = inst_7586);

return statearr_7618;
})();
var statearr_7619_7640 = state_7606__$1;
(statearr_7619_7640[(2)] = inst_7587);

(statearr_7619_7640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (14))){
var inst_7600 = (state_7606[(2)]);
var state_7606__$1 = state_7606;
var statearr_7620_7641 = state_7606__$1;
(statearr_7620_7641[(2)] = inst_7600);

(statearr_7620_7641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (10))){
var state_7606__$1 = state_7606;
var statearr_7621_7642 = state_7606__$1;
(statearr_7621_7642[(2)] = fc);

(statearr_7621_7642[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7607 === (8))){
var inst_7595 = (state_7606[(2)]);
var state_7606__$1 = state_7606;
if(cljs.core.truth_(inst_7595)){
var statearr_7622_7643 = state_7606__$1;
(statearr_7622_7643[(1)] = (12));

} else {
var statearr_7623_7644 = state_7606__$1;
(statearr_7623_7644[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_7624 = [null,null,null,null,null,null,null,null,null];
(statearr_7624[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_7624[(1)] = (1));

return statearr_7624;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_7606){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7625){var ex__7098__auto__ = e7625;
var statearr_7626_7645 = state_7606;
(statearr_7626_7645[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7606[(4)]))){
var statearr_7627_7646 = state_7606;
(statearr_7627_7646[(1)] = cljs.core.first.call(null,(state_7606[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7647 = state_7606;
state_7606 = G__7647;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_7606){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_7606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7628 = f__7169__auto__.call(null);
(statearr_7628[(6)] = c__7168__auto___7630);

return statearr_7628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7168__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7669){
var state_val_7670 = (state_7669[(1)]);
if((state_val_7670 === (7))){
var inst_7665 = (state_7669[(2)]);
var state_7669__$1 = state_7669;
var statearr_7671_7690 = state_7669__$1;
(statearr_7671_7690[(2)] = inst_7665);

(statearr_7671_7690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (1))){
var inst_7648 = init;
var inst_7649 = inst_7648;
var state_7669__$1 = (function (){var statearr_7672 = state_7669;
(statearr_7672[(7)] = inst_7649);

return statearr_7672;
})();
var statearr_7673_7691 = state_7669__$1;
(statearr_7673_7691[(2)] = null);

(statearr_7673_7691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (4))){
var inst_7652 = (state_7669[(8)]);
var inst_7652__$1 = (state_7669[(2)]);
var inst_7653 = (inst_7652__$1 == null);
var state_7669__$1 = (function (){var statearr_7674 = state_7669;
(statearr_7674[(8)] = inst_7652__$1);

return statearr_7674;
})();
if(cljs.core.truth_(inst_7653)){
var statearr_7675_7692 = state_7669__$1;
(statearr_7675_7692[(1)] = (5));

} else {
var statearr_7676_7693 = state_7669__$1;
(statearr_7676_7693[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (6))){
var inst_7656 = (state_7669[(9)]);
var inst_7652 = (state_7669[(8)]);
var inst_7649 = (state_7669[(7)]);
var inst_7656__$1 = f.call(null,inst_7649,inst_7652);
var inst_7657 = cljs.core.reduced_QMARK_.call(null,inst_7656__$1);
var state_7669__$1 = (function (){var statearr_7677 = state_7669;
(statearr_7677[(9)] = inst_7656__$1);

return statearr_7677;
})();
if(inst_7657){
var statearr_7678_7694 = state_7669__$1;
(statearr_7678_7694[(1)] = (8));

} else {
var statearr_7679_7695 = state_7669__$1;
(statearr_7679_7695[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (3))){
var inst_7667 = (state_7669[(2)]);
var state_7669__$1 = state_7669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7669__$1,inst_7667);
} else {
if((state_val_7670 === (2))){
var state_7669__$1 = state_7669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7669__$1,(4),ch);
} else {
if((state_val_7670 === (9))){
var inst_7656 = (state_7669[(9)]);
var inst_7649 = inst_7656;
var state_7669__$1 = (function (){var statearr_7680 = state_7669;
(statearr_7680[(7)] = inst_7649);

return statearr_7680;
})();
var statearr_7681_7696 = state_7669__$1;
(statearr_7681_7696[(2)] = null);

(statearr_7681_7696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (5))){
var inst_7649 = (state_7669[(7)]);
var state_7669__$1 = state_7669;
var statearr_7682_7697 = state_7669__$1;
(statearr_7682_7697[(2)] = inst_7649);

(statearr_7682_7697[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (10))){
var inst_7663 = (state_7669[(2)]);
var state_7669__$1 = state_7669;
var statearr_7683_7698 = state_7669__$1;
(statearr_7683_7698[(2)] = inst_7663);

(statearr_7683_7698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7670 === (8))){
var inst_7656 = (state_7669[(9)]);
var inst_7659 = cljs.core.deref.call(null,inst_7656);
var state_7669__$1 = state_7669;
var statearr_7684_7699 = state_7669__$1;
(statearr_7684_7699[(2)] = inst_7659);

(statearr_7684_7699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__7095__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7095__auto____0 = (function (){
var statearr_7685 = [null,null,null,null,null,null,null,null,null,null];
(statearr_7685[(0)] = cljs$core$async$reduce_$_state_machine__7095__auto__);

(statearr_7685[(1)] = (1));

return statearr_7685;
});
var cljs$core$async$reduce_$_state_machine__7095__auto____1 = (function (state_7669){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7686){var ex__7098__auto__ = e7686;
var statearr_7687_7700 = state_7669;
(statearr_7687_7700[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7669[(4)]))){
var statearr_7688_7701 = state_7669;
(statearr_7688_7701[(1)] = cljs.core.first.call(null,(state_7669[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7702 = state_7669;
state_7669 = G__7702;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7095__auto__ = function(state_7669){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7095__auto____1.call(this,state_7669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7095__auto____0;
cljs$core$async$reduce_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7095__auto____1;
return cljs$core$async$reduce_$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7689 = f__7169__auto__.call(null);
(statearr_7689[(6)] = c__7168__auto__);

return statearr_7689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));

return c__7168__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__7168__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7708){
var state_val_7709 = (state_7708[(1)]);
if((state_val_7709 === (1))){
var inst_7703 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_7708__$1 = state_7708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7708__$1,(2),inst_7703);
} else {
if((state_val_7709 === (2))){
var inst_7705 = (state_7708[(2)]);
var inst_7706 = f__$1.call(null,inst_7705);
var state_7708__$1 = state_7708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7708__$1,inst_7706);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__7095__auto__ = null;
var cljs$core$async$transduce_$_state_machine__7095__auto____0 = (function (){
var statearr_7710 = [null,null,null,null,null,null,null];
(statearr_7710[(0)] = cljs$core$async$transduce_$_state_machine__7095__auto__);

(statearr_7710[(1)] = (1));

return statearr_7710;
});
var cljs$core$async$transduce_$_state_machine__7095__auto____1 = (function (state_7708){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7711){var ex__7098__auto__ = e7711;
var statearr_7712_7715 = state_7708;
(statearr_7712_7715[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7708[(4)]))){
var statearr_7713_7716 = state_7708;
(statearr_7713_7716[(1)] = cljs.core.first.call(null,(state_7708[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7717 = state_7708;
state_7708 = G__7717;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__7095__auto__ = function(state_7708){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__7095__auto____1.call(this,state_7708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__7095__auto____0;
cljs$core$async$transduce_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__7095__auto____1;
return cljs$core$async$transduce_$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7714 = f__7169__auto__.call(null);
(statearr_7714[(6)] = c__7168__auto__);

return statearr_7714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));

return c__7168__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__7719 = arguments.length;
switch (G__7719) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7168__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7744){
var state_val_7745 = (state_7744[(1)]);
if((state_val_7745 === (7))){
var inst_7726 = (state_7744[(2)]);
var state_7744__$1 = state_7744;
var statearr_7746_7768 = state_7744__$1;
(statearr_7746_7768[(2)] = inst_7726);

(statearr_7746_7768[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (1))){
var inst_7720 = cljs.core.seq.call(null,coll);
var inst_7721 = inst_7720;
var state_7744__$1 = (function (){var statearr_7747 = state_7744;
(statearr_7747[(7)] = inst_7721);

return statearr_7747;
})();
var statearr_7748_7769 = state_7744__$1;
(statearr_7748_7769[(2)] = null);

(statearr_7748_7769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (4))){
var inst_7721 = (state_7744[(7)]);
var inst_7724 = cljs.core.first.call(null,inst_7721);
var state_7744__$1 = state_7744;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_7744__$1,(7),ch,inst_7724);
} else {
if((state_val_7745 === (13))){
var inst_7738 = (state_7744[(2)]);
var state_7744__$1 = state_7744;
var statearr_7749_7770 = state_7744__$1;
(statearr_7749_7770[(2)] = inst_7738);

(statearr_7749_7770[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (6))){
var inst_7729 = (state_7744[(2)]);
var state_7744__$1 = state_7744;
if(cljs.core.truth_(inst_7729)){
var statearr_7750_7771 = state_7744__$1;
(statearr_7750_7771[(1)] = (8));

} else {
var statearr_7751_7772 = state_7744__$1;
(statearr_7751_7772[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (3))){
var inst_7742 = (state_7744[(2)]);
var state_7744__$1 = state_7744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7744__$1,inst_7742);
} else {
if((state_val_7745 === (12))){
var state_7744__$1 = state_7744;
var statearr_7752_7773 = state_7744__$1;
(statearr_7752_7773[(2)] = null);

(statearr_7752_7773[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (2))){
var inst_7721 = (state_7744[(7)]);
var state_7744__$1 = state_7744;
if(cljs.core.truth_(inst_7721)){
var statearr_7753_7774 = state_7744__$1;
(statearr_7753_7774[(1)] = (4));

} else {
var statearr_7754_7775 = state_7744__$1;
(statearr_7754_7775[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (11))){
var inst_7735 = cljs.core.async.close_BANG_.call(null,ch);
var state_7744__$1 = state_7744;
var statearr_7755_7776 = state_7744__$1;
(statearr_7755_7776[(2)] = inst_7735);

(statearr_7755_7776[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (9))){
var state_7744__$1 = state_7744;
if(cljs.core.truth_(close_QMARK_)){
var statearr_7756_7777 = state_7744__$1;
(statearr_7756_7777[(1)] = (11));

} else {
var statearr_7757_7778 = state_7744__$1;
(statearr_7757_7778[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (5))){
var inst_7721 = (state_7744[(7)]);
var state_7744__$1 = state_7744;
var statearr_7758_7779 = state_7744__$1;
(statearr_7758_7779[(2)] = inst_7721);

(statearr_7758_7779[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (10))){
var inst_7740 = (state_7744[(2)]);
var state_7744__$1 = state_7744;
var statearr_7759_7780 = state_7744__$1;
(statearr_7759_7780[(2)] = inst_7740);

(statearr_7759_7780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7745 === (8))){
var inst_7721 = (state_7744[(7)]);
var inst_7731 = cljs.core.next.call(null,inst_7721);
var inst_7721__$1 = inst_7731;
var state_7744__$1 = (function (){var statearr_7760 = state_7744;
(statearr_7760[(7)] = inst_7721__$1);

return statearr_7760;
})();
var statearr_7761_7781 = state_7744__$1;
(statearr_7761_7781[(2)] = null);

(statearr_7761_7781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_7762 = [null,null,null,null,null,null,null,null];
(statearr_7762[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_7762[(1)] = (1));

return statearr_7762;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_7744){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e7763){var ex__7098__auto__ = e7763;
var statearr_7764_7782 = state_7744;
(statearr_7764_7782[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7744[(4)]))){
var statearr_7765_7783 = state_7744;
(statearr_7765_7783[(1)] = cljs.core.first.call(null,(state_7744[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__7784 = state_7744;
state_7744 = G__7784;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_7744){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_7744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_7766 = f__7169__auto__.call(null);
(statearr_7766[(6)] = c__7168__auto__);

return statearr_7766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));

return c__7168__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__7786 = arguments.length;
switch (G__7786) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_7788 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_7788.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_7789 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_7789.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_7790 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_7790.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_7791 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_7791.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async7792 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async7792 = (function (ch,cs,meta7793){
this.ch = ch;
this.cs = cs;
this.meta7793 = meta7793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7794,meta7793__$1){
var self__ = this;
var _7794__$1 = this;
return (new cljs.core.async.t_cljs$core$async7792(self__.ch,self__.cs,meta7793__$1));
}));

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7794){
var self__ = this;
var _7794__$1 = this;
return self__.meta7793;
}));

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async7792.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async7792.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta7793","meta7793",-373440165,null)], null);
}));

(cljs.core.async.t_cljs$core$async7792.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async7792.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async7792");

(cljs.core.async.t_cljs$core$async7792.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async7792");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async7792.
 */
cljs.core.async.__GT_t_cljs$core$async7792 = (function cljs$core$async$mult_$___GT_t_cljs$core$async7792(ch__$1,cs__$1,meta7793){
return (new cljs.core.async.t_cljs$core$async7792(ch__$1,cs__$1,meta7793));
});

}

return (new cljs.core.async.t_cljs$core$async7792(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__7168__auto___8011 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_7927){
var state_val_7928 = (state_7927[(1)]);
if((state_val_7928 === (7))){
var inst_7923 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7929_8012 = state_7927__$1;
(statearr_7929_8012[(2)] = inst_7923);

(statearr_7929_8012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (20))){
var inst_7828 = (state_7927[(7)]);
var inst_7840 = cljs.core.first.call(null,inst_7828);
var inst_7841 = cljs.core.nth.call(null,inst_7840,(0),null);
var inst_7842 = cljs.core.nth.call(null,inst_7840,(1),null);
var state_7927__$1 = (function (){var statearr_7930 = state_7927;
(statearr_7930[(8)] = inst_7841);

return statearr_7930;
})();
if(cljs.core.truth_(inst_7842)){
var statearr_7931_8013 = state_7927__$1;
(statearr_7931_8013[(1)] = (22));

} else {
var statearr_7932_8014 = state_7927__$1;
(statearr_7932_8014[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (27))){
var inst_7797 = (state_7927[(9)]);
var inst_7877 = (state_7927[(10)]);
var inst_7870 = (state_7927[(11)]);
var inst_7872 = (state_7927[(12)]);
var inst_7877__$1 = cljs.core._nth.call(null,inst_7870,inst_7872);
var inst_7878 = cljs.core.async.put_BANG_.call(null,inst_7877__$1,inst_7797,done);
var state_7927__$1 = (function (){var statearr_7933 = state_7927;
(statearr_7933[(10)] = inst_7877__$1);

return statearr_7933;
})();
if(cljs.core.truth_(inst_7878)){
var statearr_7934_8015 = state_7927__$1;
(statearr_7934_8015[(1)] = (30));

} else {
var statearr_7935_8016 = state_7927__$1;
(statearr_7935_8016[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (1))){
var state_7927__$1 = state_7927;
var statearr_7936_8017 = state_7927__$1;
(statearr_7936_8017[(2)] = null);

(statearr_7936_8017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (24))){
var inst_7828 = (state_7927[(7)]);
var inst_7847 = (state_7927[(2)]);
var inst_7848 = cljs.core.next.call(null,inst_7828);
var inst_7806 = inst_7848;
var inst_7807 = null;
var inst_7808 = (0);
var inst_7809 = (0);
var state_7927__$1 = (function (){var statearr_7937 = state_7927;
(statearr_7937[(13)] = inst_7809);

(statearr_7937[(14)] = inst_7806);

(statearr_7937[(15)] = inst_7847);

(statearr_7937[(16)] = inst_7807);

(statearr_7937[(17)] = inst_7808);

return statearr_7937;
})();
var statearr_7938_8018 = state_7927__$1;
(statearr_7938_8018[(2)] = null);

(statearr_7938_8018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (39))){
var state_7927__$1 = state_7927;
var statearr_7942_8019 = state_7927__$1;
(statearr_7942_8019[(2)] = null);

(statearr_7942_8019[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (4))){
var inst_7797 = (state_7927[(9)]);
var inst_7797__$1 = (state_7927[(2)]);
var inst_7798 = (inst_7797__$1 == null);
var state_7927__$1 = (function (){var statearr_7943 = state_7927;
(statearr_7943[(9)] = inst_7797__$1);

return statearr_7943;
})();
if(cljs.core.truth_(inst_7798)){
var statearr_7944_8020 = state_7927__$1;
(statearr_7944_8020[(1)] = (5));

} else {
var statearr_7945_8021 = state_7927__$1;
(statearr_7945_8021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (15))){
var inst_7809 = (state_7927[(13)]);
var inst_7806 = (state_7927[(14)]);
var inst_7807 = (state_7927[(16)]);
var inst_7808 = (state_7927[(17)]);
var inst_7824 = (state_7927[(2)]);
var inst_7825 = (inst_7809 + (1));
var tmp7939 = inst_7806;
var tmp7940 = inst_7807;
var tmp7941 = inst_7808;
var inst_7806__$1 = tmp7939;
var inst_7807__$1 = tmp7940;
var inst_7808__$1 = tmp7941;
var inst_7809__$1 = inst_7825;
var state_7927__$1 = (function (){var statearr_7946 = state_7927;
(statearr_7946[(13)] = inst_7809__$1);

(statearr_7946[(14)] = inst_7806__$1);

(statearr_7946[(16)] = inst_7807__$1);

(statearr_7946[(17)] = inst_7808__$1);

(statearr_7946[(18)] = inst_7824);

return statearr_7946;
})();
var statearr_7947_8022 = state_7927__$1;
(statearr_7947_8022[(2)] = null);

(statearr_7947_8022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (21))){
var inst_7851 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7951_8023 = state_7927__$1;
(statearr_7951_8023[(2)] = inst_7851);

(statearr_7951_8023[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (31))){
var inst_7877 = (state_7927[(10)]);
var inst_7881 = cljs.core.async.untap_STAR_.call(null,m,inst_7877);
var state_7927__$1 = state_7927;
var statearr_7952_8024 = state_7927__$1;
(statearr_7952_8024[(2)] = inst_7881);

(statearr_7952_8024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (32))){
var inst_7871 = (state_7927[(19)]);
var inst_7869 = (state_7927[(20)]);
var inst_7870 = (state_7927[(11)]);
var inst_7872 = (state_7927[(12)]);
var inst_7883 = (state_7927[(2)]);
var inst_7884 = (inst_7872 + (1));
var tmp7948 = inst_7871;
var tmp7949 = inst_7869;
var tmp7950 = inst_7870;
var inst_7869__$1 = tmp7949;
var inst_7870__$1 = tmp7950;
var inst_7871__$1 = tmp7948;
var inst_7872__$1 = inst_7884;
var state_7927__$1 = (function (){var statearr_7953 = state_7927;
(statearr_7953[(21)] = inst_7883);

(statearr_7953[(19)] = inst_7871__$1);

(statearr_7953[(20)] = inst_7869__$1);

(statearr_7953[(11)] = inst_7870__$1);

(statearr_7953[(12)] = inst_7872__$1);

return statearr_7953;
})();
var statearr_7954_8025 = state_7927__$1;
(statearr_7954_8025[(2)] = null);

(statearr_7954_8025[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (40))){
var inst_7896 = (state_7927[(22)]);
var inst_7900 = cljs.core.async.untap_STAR_.call(null,m,inst_7896);
var state_7927__$1 = state_7927;
var statearr_7955_8026 = state_7927__$1;
(statearr_7955_8026[(2)] = inst_7900);

(statearr_7955_8026[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (33))){
var inst_7887 = (state_7927[(23)]);
var inst_7889 = cljs.core.chunked_seq_QMARK_.call(null,inst_7887);
var state_7927__$1 = state_7927;
if(inst_7889){
var statearr_7956_8027 = state_7927__$1;
(statearr_7956_8027[(1)] = (36));

} else {
var statearr_7957_8028 = state_7927__$1;
(statearr_7957_8028[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (13))){
var inst_7818 = (state_7927[(24)]);
var inst_7821 = cljs.core.async.close_BANG_.call(null,inst_7818);
var state_7927__$1 = state_7927;
var statearr_7958_8029 = state_7927__$1;
(statearr_7958_8029[(2)] = inst_7821);

(statearr_7958_8029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (22))){
var inst_7841 = (state_7927[(8)]);
var inst_7844 = cljs.core.async.close_BANG_.call(null,inst_7841);
var state_7927__$1 = state_7927;
var statearr_7959_8030 = state_7927__$1;
(statearr_7959_8030[(2)] = inst_7844);

(statearr_7959_8030[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (36))){
var inst_7887 = (state_7927[(23)]);
var inst_7891 = cljs.core.chunk_first.call(null,inst_7887);
var inst_7892 = cljs.core.chunk_rest.call(null,inst_7887);
var inst_7893 = cljs.core.count.call(null,inst_7891);
var inst_7869 = inst_7892;
var inst_7870 = inst_7891;
var inst_7871 = inst_7893;
var inst_7872 = (0);
var state_7927__$1 = (function (){var statearr_7960 = state_7927;
(statearr_7960[(19)] = inst_7871);

(statearr_7960[(20)] = inst_7869);

(statearr_7960[(11)] = inst_7870);

(statearr_7960[(12)] = inst_7872);

return statearr_7960;
})();
var statearr_7961_8031 = state_7927__$1;
(statearr_7961_8031[(2)] = null);

(statearr_7961_8031[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (41))){
var inst_7887 = (state_7927[(23)]);
var inst_7902 = (state_7927[(2)]);
var inst_7903 = cljs.core.next.call(null,inst_7887);
var inst_7869 = inst_7903;
var inst_7870 = null;
var inst_7871 = (0);
var inst_7872 = (0);
var state_7927__$1 = (function (){var statearr_7962 = state_7927;
(statearr_7962[(19)] = inst_7871);

(statearr_7962[(20)] = inst_7869);

(statearr_7962[(25)] = inst_7902);

(statearr_7962[(11)] = inst_7870);

(statearr_7962[(12)] = inst_7872);

return statearr_7962;
})();
var statearr_7963_8032 = state_7927__$1;
(statearr_7963_8032[(2)] = null);

(statearr_7963_8032[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (43))){
var state_7927__$1 = state_7927;
var statearr_7964_8033 = state_7927__$1;
(statearr_7964_8033[(2)] = null);

(statearr_7964_8033[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (29))){
var inst_7911 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7965_8034 = state_7927__$1;
(statearr_7965_8034[(2)] = inst_7911);

(statearr_7965_8034[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (44))){
var inst_7920 = (state_7927[(2)]);
var state_7927__$1 = (function (){var statearr_7966 = state_7927;
(statearr_7966[(26)] = inst_7920);

return statearr_7966;
})();
var statearr_7967_8035 = state_7927__$1;
(statearr_7967_8035[(2)] = null);

(statearr_7967_8035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (6))){
var inst_7861 = (state_7927[(27)]);
var inst_7860 = cljs.core.deref.call(null,cs);
var inst_7861__$1 = cljs.core.keys.call(null,inst_7860);
var inst_7862 = cljs.core.count.call(null,inst_7861__$1);
var inst_7863 = cljs.core.reset_BANG_.call(null,dctr,inst_7862);
var inst_7868 = cljs.core.seq.call(null,inst_7861__$1);
var inst_7869 = inst_7868;
var inst_7870 = null;
var inst_7871 = (0);
var inst_7872 = (0);
var state_7927__$1 = (function (){var statearr_7968 = state_7927;
(statearr_7968[(19)] = inst_7871);

(statearr_7968[(20)] = inst_7869);

(statearr_7968[(27)] = inst_7861__$1);

(statearr_7968[(28)] = inst_7863);

(statearr_7968[(11)] = inst_7870);

(statearr_7968[(12)] = inst_7872);

return statearr_7968;
})();
var statearr_7969_8036 = state_7927__$1;
(statearr_7969_8036[(2)] = null);

(statearr_7969_8036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (28))){
var inst_7887 = (state_7927[(23)]);
var inst_7869 = (state_7927[(20)]);
var inst_7887__$1 = cljs.core.seq.call(null,inst_7869);
var state_7927__$1 = (function (){var statearr_7970 = state_7927;
(statearr_7970[(23)] = inst_7887__$1);

return statearr_7970;
})();
if(inst_7887__$1){
var statearr_7971_8037 = state_7927__$1;
(statearr_7971_8037[(1)] = (33));

} else {
var statearr_7972_8038 = state_7927__$1;
(statearr_7972_8038[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (25))){
var inst_7871 = (state_7927[(19)]);
var inst_7872 = (state_7927[(12)]);
var inst_7874 = (inst_7872 < inst_7871);
var inst_7875 = inst_7874;
var state_7927__$1 = state_7927;
if(cljs.core.truth_(inst_7875)){
var statearr_7973_8039 = state_7927__$1;
(statearr_7973_8039[(1)] = (27));

} else {
var statearr_7974_8040 = state_7927__$1;
(statearr_7974_8040[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (34))){
var state_7927__$1 = state_7927;
var statearr_7975_8041 = state_7927__$1;
(statearr_7975_8041[(2)] = null);

(statearr_7975_8041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (17))){
var state_7927__$1 = state_7927;
var statearr_7976_8042 = state_7927__$1;
(statearr_7976_8042[(2)] = null);

(statearr_7976_8042[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (3))){
var inst_7925 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_7927__$1,inst_7925);
} else {
if((state_val_7928 === (12))){
var inst_7856 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7977_8043 = state_7927__$1;
(statearr_7977_8043[(2)] = inst_7856);

(statearr_7977_8043[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (2))){
var state_7927__$1 = state_7927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7927__$1,(4),ch);
} else {
if((state_val_7928 === (23))){
var state_7927__$1 = state_7927;
var statearr_7978_8044 = state_7927__$1;
(statearr_7978_8044[(2)] = null);

(statearr_7978_8044[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (35))){
var inst_7909 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7979_8045 = state_7927__$1;
(statearr_7979_8045[(2)] = inst_7909);

(statearr_7979_8045[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (19))){
var inst_7828 = (state_7927[(7)]);
var inst_7832 = cljs.core.chunk_first.call(null,inst_7828);
var inst_7833 = cljs.core.chunk_rest.call(null,inst_7828);
var inst_7834 = cljs.core.count.call(null,inst_7832);
var inst_7806 = inst_7833;
var inst_7807 = inst_7832;
var inst_7808 = inst_7834;
var inst_7809 = (0);
var state_7927__$1 = (function (){var statearr_7980 = state_7927;
(statearr_7980[(13)] = inst_7809);

(statearr_7980[(14)] = inst_7806);

(statearr_7980[(16)] = inst_7807);

(statearr_7980[(17)] = inst_7808);

return statearr_7980;
})();
var statearr_7981_8046 = state_7927__$1;
(statearr_7981_8046[(2)] = null);

(statearr_7981_8046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (11))){
var inst_7806 = (state_7927[(14)]);
var inst_7828 = (state_7927[(7)]);
var inst_7828__$1 = cljs.core.seq.call(null,inst_7806);
var state_7927__$1 = (function (){var statearr_7982 = state_7927;
(statearr_7982[(7)] = inst_7828__$1);

return statearr_7982;
})();
if(inst_7828__$1){
var statearr_7983_8047 = state_7927__$1;
(statearr_7983_8047[(1)] = (16));

} else {
var statearr_7984_8048 = state_7927__$1;
(statearr_7984_8048[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (9))){
var inst_7858 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7985_8049 = state_7927__$1;
(statearr_7985_8049[(2)] = inst_7858);

(statearr_7985_8049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (5))){
var inst_7804 = cljs.core.deref.call(null,cs);
var inst_7805 = cljs.core.seq.call(null,inst_7804);
var inst_7806 = inst_7805;
var inst_7807 = null;
var inst_7808 = (0);
var inst_7809 = (0);
var state_7927__$1 = (function (){var statearr_7986 = state_7927;
(statearr_7986[(13)] = inst_7809);

(statearr_7986[(14)] = inst_7806);

(statearr_7986[(16)] = inst_7807);

(statearr_7986[(17)] = inst_7808);

return statearr_7986;
})();
var statearr_7987_8050 = state_7927__$1;
(statearr_7987_8050[(2)] = null);

(statearr_7987_8050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (14))){
var state_7927__$1 = state_7927;
var statearr_7988_8051 = state_7927__$1;
(statearr_7988_8051[(2)] = null);

(statearr_7988_8051[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (45))){
var inst_7917 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7989_8052 = state_7927__$1;
(statearr_7989_8052[(2)] = inst_7917);

(statearr_7989_8052[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (26))){
var inst_7861 = (state_7927[(27)]);
var inst_7913 = (state_7927[(2)]);
var inst_7914 = cljs.core.seq.call(null,inst_7861);
var state_7927__$1 = (function (){var statearr_7990 = state_7927;
(statearr_7990[(29)] = inst_7913);

return statearr_7990;
})();
if(inst_7914){
var statearr_7991_8053 = state_7927__$1;
(statearr_7991_8053[(1)] = (42));

} else {
var statearr_7992_8054 = state_7927__$1;
(statearr_7992_8054[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (16))){
var inst_7828 = (state_7927[(7)]);
var inst_7830 = cljs.core.chunked_seq_QMARK_.call(null,inst_7828);
var state_7927__$1 = state_7927;
if(inst_7830){
var statearr_7993_8055 = state_7927__$1;
(statearr_7993_8055[(1)] = (19));

} else {
var statearr_7994_8056 = state_7927__$1;
(statearr_7994_8056[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (38))){
var inst_7906 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_7995_8057 = state_7927__$1;
(statearr_7995_8057[(2)] = inst_7906);

(statearr_7995_8057[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (30))){
var state_7927__$1 = state_7927;
var statearr_7996_8058 = state_7927__$1;
(statearr_7996_8058[(2)] = null);

(statearr_7996_8058[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (10))){
var inst_7809 = (state_7927[(13)]);
var inst_7807 = (state_7927[(16)]);
var inst_7817 = cljs.core._nth.call(null,inst_7807,inst_7809);
var inst_7818 = cljs.core.nth.call(null,inst_7817,(0),null);
var inst_7819 = cljs.core.nth.call(null,inst_7817,(1),null);
var state_7927__$1 = (function (){var statearr_7997 = state_7927;
(statearr_7997[(24)] = inst_7818);

return statearr_7997;
})();
if(cljs.core.truth_(inst_7819)){
var statearr_7998_8059 = state_7927__$1;
(statearr_7998_8059[(1)] = (13));

} else {
var statearr_7999_8060 = state_7927__$1;
(statearr_7999_8060[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (18))){
var inst_7854 = (state_7927[(2)]);
var state_7927__$1 = state_7927;
var statearr_8000_8061 = state_7927__$1;
(statearr_8000_8061[(2)] = inst_7854);

(statearr_8000_8061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (42))){
var state_7927__$1 = state_7927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_7927__$1,(45),dchan);
} else {
if((state_val_7928 === (37))){
var inst_7896 = (state_7927[(22)]);
var inst_7887 = (state_7927[(23)]);
var inst_7797 = (state_7927[(9)]);
var inst_7896__$1 = cljs.core.first.call(null,inst_7887);
var inst_7897 = cljs.core.async.put_BANG_.call(null,inst_7896__$1,inst_7797,done);
var state_7927__$1 = (function (){var statearr_8001 = state_7927;
(statearr_8001[(22)] = inst_7896__$1);

return statearr_8001;
})();
if(cljs.core.truth_(inst_7897)){
var statearr_8002_8062 = state_7927__$1;
(statearr_8002_8062[(1)] = (39));

} else {
var statearr_8003_8063 = state_7927__$1;
(statearr_8003_8063[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_7928 === (8))){
var inst_7809 = (state_7927[(13)]);
var inst_7808 = (state_7927[(17)]);
var inst_7811 = (inst_7809 < inst_7808);
var inst_7812 = inst_7811;
var state_7927__$1 = state_7927;
if(cljs.core.truth_(inst_7812)){
var statearr_8004_8064 = state_7927__$1;
(statearr_8004_8064[(1)] = (10));

} else {
var statearr_8005_8065 = state_7927__$1;
(statearr_8005_8065[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__7095__auto__ = null;
var cljs$core$async$mult_$_state_machine__7095__auto____0 = (function (){
var statearr_8006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8006[(0)] = cljs$core$async$mult_$_state_machine__7095__auto__);

(statearr_8006[(1)] = (1));

return statearr_8006;
});
var cljs$core$async$mult_$_state_machine__7095__auto____1 = (function (state_7927){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_7927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8007){var ex__7098__auto__ = e8007;
var statearr_8008_8066 = state_7927;
(statearr_8008_8066[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_7927[(4)]))){
var statearr_8009_8067 = state_7927;
(statearr_8009_8067[(1)] = cljs.core.first.call(null,(state_7927[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8068 = state_7927;
state_7927 = G__8068;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7095__auto__ = function(state_7927){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7095__auto____1.call(this,state_7927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7095__auto____0;
cljs$core$async$mult_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7095__auto____1;
return cljs$core$async$mult_$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8010 = f__7169__auto__.call(null);
(statearr_8010[(6)] = c__7168__auto___8011);

return statearr_8010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__8070 = arguments.length;
switch (G__8070) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_8072 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_8072.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_8073 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_8073.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_8074 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_8074.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_8075 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_8075.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_8076 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_8076.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___8087 = arguments.length;
var i__4737__auto___8088 = (0);
while(true){
if((i__4737__auto___8088 < len__4736__auto___8087)){
args__4742__auto__.push((arguments[i__4737__auto___8088]));

var G__8089 = (i__4737__auto___8088 + (1));
i__4737__auto___8088 = G__8089;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__8081){
var map__8082 = p__8081;
var map__8082__$1 = (((((!((map__8082 == null))))?(((((map__8082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8082.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8082):map__8082);
var opts = map__8082__$1;
var statearr_8084_8090 = state;
(statearr_8084_8090[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_8085_8091 = state;
(statearr_8085_8091[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_8086_8092 = state;
(statearr_8086_8092[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq8077){
var G__8078 = cljs.core.first.call(null,seq8077);
var seq8077__$1 = cljs.core.next.call(null,seq8077);
var G__8079 = cljs.core.first.call(null,seq8077__$1);
var seq8077__$2 = cljs.core.next.call(null,seq8077__$1);
var G__8080 = cljs.core.first.call(null,seq8077__$2);
var seq8077__$3 = cljs.core.next.call(null,seq8077__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8078,G__8079,G__8080,seq8077__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8093 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8093 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta8094){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta8094 = meta8094;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8095,meta8094__$1){
var self__ = this;
var _8095__$1 = this;
return (new cljs.core.async.t_cljs$core$async8093(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta8094__$1));
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8095){
var self__ = this;
var _8095__$1 = this;
return self__.meta8094;
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async8093.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async8093.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta8094","meta8094",-747121986,null)], null);
}));

(cljs.core.async.t_cljs$core$async8093.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8093.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8093");

(cljs.core.async.t_cljs$core$async8093.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8093");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8093.
 */
cljs.core.async.__GT_t_cljs$core$async8093 = (function cljs$core$async$mix_$___GT_t_cljs$core$async8093(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta8094){
return (new cljs.core.async.t_cljs$core$async8093(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta8094));
});

}

return (new cljs.core.async.t_cljs$core$async8093(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7168__auto___8258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8197){
var state_val_8198 = (state_8197[(1)]);
if((state_val_8198 === (7))){
var inst_8112 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
var statearr_8199_8259 = state_8197__$1;
(statearr_8199_8259[(2)] = inst_8112);

(statearr_8199_8259[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (20))){
var inst_8124 = (state_8197[(7)]);
var state_8197__$1 = state_8197;
var statearr_8200_8260 = state_8197__$1;
(statearr_8200_8260[(2)] = inst_8124);

(statearr_8200_8260[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (27))){
var state_8197__$1 = state_8197;
var statearr_8201_8261 = state_8197__$1;
(statearr_8201_8261[(2)] = null);

(statearr_8201_8261[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (1))){
var inst_8099 = (state_8197[(8)]);
var inst_8099__$1 = calc_state.call(null);
var inst_8101 = (inst_8099__$1 == null);
var inst_8102 = cljs.core.not.call(null,inst_8101);
var state_8197__$1 = (function (){var statearr_8202 = state_8197;
(statearr_8202[(8)] = inst_8099__$1);

return statearr_8202;
})();
if(inst_8102){
var statearr_8203_8262 = state_8197__$1;
(statearr_8203_8262[(1)] = (2));

} else {
var statearr_8204_8263 = state_8197__$1;
(statearr_8204_8263[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (24))){
var inst_8148 = (state_8197[(9)]);
var inst_8157 = (state_8197[(10)]);
var inst_8171 = (state_8197[(11)]);
var inst_8171__$1 = inst_8148.call(null,inst_8157);
var state_8197__$1 = (function (){var statearr_8205 = state_8197;
(statearr_8205[(11)] = inst_8171__$1);

return statearr_8205;
})();
if(cljs.core.truth_(inst_8171__$1)){
var statearr_8206_8264 = state_8197__$1;
(statearr_8206_8264[(1)] = (29));

} else {
var statearr_8207_8265 = state_8197__$1;
(statearr_8207_8265[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (4))){
var inst_8115 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8115)){
var statearr_8208_8266 = state_8197__$1;
(statearr_8208_8266[(1)] = (8));

} else {
var statearr_8209_8267 = state_8197__$1;
(statearr_8209_8267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (15))){
var inst_8142 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8142)){
var statearr_8210_8268 = state_8197__$1;
(statearr_8210_8268[(1)] = (19));

} else {
var statearr_8211_8269 = state_8197__$1;
(statearr_8211_8269[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (21))){
var inst_8147 = (state_8197[(12)]);
var inst_8147__$1 = (state_8197[(2)]);
var inst_8148 = cljs.core.get.call(null,inst_8147__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_8149 = cljs.core.get.call(null,inst_8147__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_8150 = cljs.core.get.call(null,inst_8147__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_8197__$1 = (function (){var statearr_8212 = state_8197;
(statearr_8212[(9)] = inst_8148);

(statearr_8212[(13)] = inst_8149);

(statearr_8212[(12)] = inst_8147__$1);

return statearr_8212;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_8197__$1,(22),inst_8150);
} else {
if((state_val_8198 === (31))){
var inst_8179 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8179)){
var statearr_8213_8270 = state_8197__$1;
(statearr_8213_8270[(1)] = (32));

} else {
var statearr_8214_8271 = state_8197__$1;
(statearr_8214_8271[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (32))){
var inst_8156 = (state_8197[(14)]);
var state_8197__$1 = state_8197;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8197__$1,(35),out,inst_8156);
} else {
if((state_val_8198 === (33))){
var inst_8147 = (state_8197[(12)]);
var inst_8124 = inst_8147;
var state_8197__$1 = (function (){var statearr_8215 = state_8197;
(statearr_8215[(7)] = inst_8124);

return statearr_8215;
})();
var statearr_8216_8272 = state_8197__$1;
(statearr_8216_8272[(2)] = null);

(statearr_8216_8272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (13))){
var inst_8124 = (state_8197[(7)]);
var inst_8131 = inst_8124.cljs$lang$protocol_mask$partition0$;
var inst_8132 = (inst_8131 & (64));
var inst_8133 = inst_8124.cljs$core$ISeq$;
var inst_8134 = (cljs.core.PROTOCOL_SENTINEL === inst_8133);
var inst_8135 = ((inst_8132) || (inst_8134));
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8135)){
var statearr_8217_8273 = state_8197__$1;
(statearr_8217_8273[(1)] = (16));

} else {
var statearr_8218_8274 = state_8197__$1;
(statearr_8218_8274[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (22))){
var inst_8157 = (state_8197[(10)]);
var inst_8156 = (state_8197[(14)]);
var inst_8155 = (state_8197[(2)]);
var inst_8156__$1 = cljs.core.nth.call(null,inst_8155,(0),null);
var inst_8157__$1 = cljs.core.nth.call(null,inst_8155,(1),null);
var inst_8158 = (inst_8156__$1 == null);
var inst_8159 = cljs.core._EQ_.call(null,inst_8157__$1,change);
var inst_8160 = ((inst_8158) || (inst_8159));
var state_8197__$1 = (function (){var statearr_8219 = state_8197;
(statearr_8219[(10)] = inst_8157__$1);

(statearr_8219[(14)] = inst_8156__$1);

return statearr_8219;
})();
if(cljs.core.truth_(inst_8160)){
var statearr_8220_8275 = state_8197__$1;
(statearr_8220_8275[(1)] = (23));

} else {
var statearr_8221_8276 = state_8197__$1;
(statearr_8221_8276[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (36))){
var inst_8147 = (state_8197[(12)]);
var inst_8124 = inst_8147;
var state_8197__$1 = (function (){var statearr_8222 = state_8197;
(statearr_8222[(7)] = inst_8124);

return statearr_8222;
})();
var statearr_8223_8277 = state_8197__$1;
(statearr_8223_8277[(2)] = null);

(statearr_8223_8277[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (29))){
var inst_8171 = (state_8197[(11)]);
var state_8197__$1 = state_8197;
var statearr_8224_8278 = state_8197__$1;
(statearr_8224_8278[(2)] = inst_8171);

(statearr_8224_8278[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (6))){
var state_8197__$1 = state_8197;
var statearr_8225_8279 = state_8197__$1;
(statearr_8225_8279[(2)] = false);

(statearr_8225_8279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (28))){
var inst_8167 = (state_8197[(2)]);
var inst_8168 = calc_state.call(null);
var inst_8124 = inst_8168;
var state_8197__$1 = (function (){var statearr_8226 = state_8197;
(statearr_8226[(7)] = inst_8124);

(statearr_8226[(15)] = inst_8167);

return statearr_8226;
})();
var statearr_8227_8280 = state_8197__$1;
(statearr_8227_8280[(2)] = null);

(statearr_8227_8280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (25))){
var inst_8193 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
var statearr_8228_8281 = state_8197__$1;
(statearr_8228_8281[(2)] = inst_8193);

(statearr_8228_8281[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (34))){
var inst_8191 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
var statearr_8229_8282 = state_8197__$1;
(statearr_8229_8282[(2)] = inst_8191);

(statearr_8229_8282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (17))){
var state_8197__$1 = state_8197;
var statearr_8230_8283 = state_8197__$1;
(statearr_8230_8283[(2)] = false);

(statearr_8230_8283[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (3))){
var state_8197__$1 = state_8197;
var statearr_8231_8284 = state_8197__$1;
(statearr_8231_8284[(2)] = false);

(statearr_8231_8284[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (12))){
var inst_8195 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8197__$1,inst_8195);
} else {
if((state_val_8198 === (2))){
var inst_8099 = (state_8197[(8)]);
var inst_8104 = inst_8099.cljs$lang$protocol_mask$partition0$;
var inst_8105 = (inst_8104 & (64));
var inst_8106 = inst_8099.cljs$core$ISeq$;
var inst_8107 = (cljs.core.PROTOCOL_SENTINEL === inst_8106);
var inst_8108 = ((inst_8105) || (inst_8107));
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8108)){
var statearr_8232_8285 = state_8197__$1;
(statearr_8232_8285[(1)] = (5));

} else {
var statearr_8233_8286 = state_8197__$1;
(statearr_8233_8286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (23))){
var inst_8156 = (state_8197[(14)]);
var inst_8162 = (inst_8156 == null);
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8162)){
var statearr_8234_8287 = state_8197__$1;
(statearr_8234_8287[(1)] = (26));

} else {
var statearr_8235_8288 = state_8197__$1;
(statearr_8235_8288[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (35))){
var inst_8182 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
if(cljs.core.truth_(inst_8182)){
var statearr_8236_8289 = state_8197__$1;
(statearr_8236_8289[(1)] = (36));

} else {
var statearr_8237_8290 = state_8197__$1;
(statearr_8237_8290[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (19))){
var inst_8124 = (state_8197[(7)]);
var inst_8144 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8124);
var state_8197__$1 = state_8197;
var statearr_8238_8291 = state_8197__$1;
(statearr_8238_8291[(2)] = inst_8144);

(statearr_8238_8291[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (11))){
var inst_8124 = (state_8197[(7)]);
var inst_8128 = (inst_8124 == null);
var inst_8129 = cljs.core.not.call(null,inst_8128);
var state_8197__$1 = state_8197;
if(inst_8129){
var statearr_8239_8292 = state_8197__$1;
(statearr_8239_8292[(1)] = (13));

} else {
var statearr_8240_8293 = state_8197__$1;
(statearr_8240_8293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (9))){
var inst_8099 = (state_8197[(8)]);
var state_8197__$1 = state_8197;
var statearr_8241_8294 = state_8197__$1;
(statearr_8241_8294[(2)] = inst_8099);

(statearr_8241_8294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (5))){
var state_8197__$1 = state_8197;
var statearr_8242_8295 = state_8197__$1;
(statearr_8242_8295[(2)] = true);

(statearr_8242_8295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (14))){
var state_8197__$1 = state_8197;
var statearr_8243_8296 = state_8197__$1;
(statearr_8243_8296[(2)] = false);

(statearr_8243_8296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (26))){
var inst_8157 = (state_8197[(10)]);
var inst_8164 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_8157);
var state_8197__$1 = state_8197;
var statearr_8244_8297 = state_8197__$1;
(statearr_8244_8297[(2)] = inst_8164);

(statearr_8244_8297[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (16))){
var state_8197__$1 = state_8197;
var statearr_8245_8298 = state_8197__$1;
(statearr_8245_8298[(2)] = true);

(statearr_8245_8298[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (38))){
var inst_8187 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
var statearr_8246_8299 = state_8197__$1;
(statearr_8246_8299[(2)] = inst_8187);

(statearr_8246_8299[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (30))){
var inst_8148 = (state_8197[(9)]);
var inst_8149 = (state_8197[(13)]);
var inst_8157 = (state_8197[(10)]);
var inst_8174 = cljs.core.empty_QMARK_.call(null,inst_8148);
var inst_8175 = inst_8149.call(null,inst_8157);
var inst_8176 = cljs.core.not.call(null,inst_8175);
var inst_8177 = ((inst_8174) && (inst_8176));
var state_8197__$1 = state_8197;
var statearr_8247_8300 = state_8197__$1;
(statearr_8247_8300[(2)] = inst_8177);

(statearr_8247_8300[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (10))){
var inst_8099 = (state_8197[(8)]);
var inst_8120 = (state_8197[(2)]);
var inst_8121 = cljs.core.get.call(null,inst_8120,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_8122 = cljs.core.get.call(null,inst_8120,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_8123 = cljs.core.get.call(null,inst_8120,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_8124 = inst_8099;
var state_8197__$1 = (function (){var statearr_8248 = state_8197;
(statearr_8248[(16)] = inst_8121);

(statearr_8248[(17)] = inst_8122);

(statearr_8248[(18)] = inst_8123);

(statearr_8248[(7)] = inst_8124);

return statearr_8248;
})();
var statearr_8249_8301 = state_8197__$1;
(statearr_8249_8301[(2)] = null);

(statearr_8249_8301[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (18))){
var inst_8139 = (state_8197[(2)]);
var state_8197__$1 = state_8197;
var statearr_8250_8302 = state_8197__$1;
(statearr_8250_8302[(2)] = inst_8139);

(statearr_8250_8302[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (37))){
var state_8197__$1 = state_8197;
var statearr_8251_8303 = state_8197__$1;
(statearr_8251_8303[(2)] = null);

(statearr_8251_8303[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8198 === (8))){
var inst_8099 = (state_8197[(8)]);
var inst_8117 = cljs.core.apply.call(null,cljs.core.hash_map,inst_8099);
var state_8197__$1 = state_8197;
var statearr_8252_8304 = state_8197__$1;
(statearr_8252_8304[(2)] = inst_8117);

(statearr_8252_8304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__7095__auto__ = null;
var cljs$core$async$mix_$_state_machine__7095__auto____0 = (function (){
var statearr_8253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8253[(0)] = cljs$core$async$mix_$_state_machine__7095__auto__);

(statearr_8253[(1)] = (1));

return statearr_8253;
});
var cljs$core$async$mix_$_state_machine__7095__auto____1 = (function (state_8197){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8254){var ex__7098__auto__ = e8254;
var statearr_8255_8305 = state_8197;
(statearr_8255_8305[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8197[(4)]))){
var statearr_8256_8306 = state_8197;
(statearr_8256_8306[(1)] = cljs.core.first.call(null,(state_8197[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8307 = state_8197;
state_8197 = G__8307;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7095__auto__ = function(state_8197){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7095__auto____1.call(this,state_8197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7095__auto____0;
cljs$core$async$mix_$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7095__auto____1;
return cljs$core$async$mix_$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8257 = f__7169__auto__.call(null);
(statearr_8257[(6)] = c__7168__auto___8258);

return statearr_8257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_8310 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_8310.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_8311 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_8311.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_8312 = (function() {
var G__8313 = null;
var G__8313__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__8313__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__8313 = function(p,v){
switch(arguments.length){
case 1:
return G__8313__1.call(this,p);
case 2:
return G__8313__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8313.cljs$core$IFn$_invoke$arity$1 = G__8313__1;
G__8313.cljs$core$IFn$_invoke$arity$2 = G__8313__2;
return G__8313;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__8309 = arguments.length;
switch (G__8309) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_8312.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_8312.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__8317 = arguments.length;
switch (G__8317) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__8315_SHARP_){
if(cljs.core.truth_(p1__8315_SHARP_.call(null,topic))){
return p1__8315_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__8315_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8318 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8318 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta8319){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta8319 = meta8319;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8320,meta8319__$1){
var self__ = this;
var _8320__$1 = this;
return (new cljs.core.async.t_cljs$core$async8318(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta8319__$1));
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8320){
var self__ = this;
var _8320__$1 = this;
return self__.meta8319;
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async8318.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async8318.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta8319","meta8319",1793274111,null)], null);
}));

(cljs.core.async.t_cljs$core$async8318.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8318.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8318");

(cljs.core.async.t_cljs$core$async8318.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8318");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8318.
 */
cljs.core.async.__GT_t_cljs$core$async8318 = (function cljs$core$async$__GT_t_cljs$core$async8318(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta8319){
return (new cljs.core.async.t_cljs$core$async8318(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta8319));
});

}

return (new cljs.core.async.t_cljs$core$async8318(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7168__auto___8439 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8392){
var state_val_8393 = (state_8392[(1)]);
if((state_val_8393 === (7))){
var inst_8388 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8394_8440 = state_8392__$1;
(statearr_8394_8440[(2)] = inst_8388);

(statearr_8394_8440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (20))){
var state_8392__$1 = state_8392;
var statearr_8395_8441 = state_8392__$1;
(statearr_8395_8441[(2)] = null);

(statearr_8395_8441[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (1))){
var state_8392__$1 = state_8392;
var statearr_8396_8442 = state_8392__$1;
(statearr_8396_8442[(2)] = null);

(statearr_8396_8442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (24))){
var inst_8371 = (state_8392[(7)]);
var inst_8380 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_8371);
var state_8392__$1 = state_8392;
var statearr_8397_8443 = state_8392__$1;
(statearr_8397_8443[(2)] = inst_8380);

(statearr_8397_8443[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (4))){
var inst_8323 = (state_8392[(8)]);
var inst_8323__$1 = (state_8392[(2)]);
var inst_8324 = (inst_8323__$1 == null);
var state_8392__$1 = (function (){var statearr_8398 = state_8392;
(statearr_8398[(8)] = inst_8323__$1);

return statearr_8398;
})();
if(cljs.core.truth_(inst_8324)){
var statearr_8399_8444 = state_8392__$1;
(statearr_8399_8444[(1)] = (5));

} else {
var statearr_8400_8445 = state_8392__$1;
(statearr_8400_8445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (15))){
var inst_8365 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8401_8446 = state_8392__$1;
(statearr_8401_8446[(2)] = inst_8365);

(statearr_8401_8446[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (21))){
var inst_8385 = (state_8392[(2)]);
var state_8392__$1 = (function (){var statearr_8402 = state_8392;
(statearr_8402[(9)] = inst_8385);

return statearr_8402;
})();
var statearr_8403_8447 = state_8392__$1;
(statearr_8403_8447[(2)] = null);

(statearr_8403_8447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (13))){
var inst_8347 = (state_8392[(10)]);
var inst_8349 = cljs.core.chunked_seq_QMARK_.call(null,inst_8347);
var state_8392__$1 = state_8392;
if(inst_8349){
var statearr_8404_8448 = state_8392__$1;
(statearr_8404_8448[(1)] = (16));

} else {
var statearr_8405_8449 = state_8392__$1;
(statearr_8405_8449[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (22))){
var inst_8377 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
if(cljs.core.truth_(inst_8377)){
var statearr_8406_8450 = state_8392__$1;
(statearr_8406_8450[(1)] = (23));

} else {
var statearr_8407_8451 = state_8392__$1;
(statearr_8407_8451[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (6))){
var inst_8323 = (state_8392[(8)]);
var inst_8373 = (state_8392[(11)]);
var inst_8371 = (state_8392[(7)]);
var inst_8371__$1 = topic_fn.call(null,inst_8323);
var inst_8372 = cljs.core.deref.call(null,mults);
var inst_8373__$1 = cljs.core.get.call(null,inst_8372,inst_8371__$1);
var state_8392__$1 = (function (){var statearr_8408 = state_8392;
(statearr_8408[(11)] = inst_8373__$1);

(statearr_8408[(7)] = inst_8371__$1);

return statearr_8408;
})();
if(cljs.core.truth_(inst_8373__$1)){
var statearr_8409_8452 = state_8392__$1;
(statearr_8409_8452[(1)] = (19));

} else {
var statearr_8410_8453 = state_8392__$1;
(statearr_8410_8453[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (25))){
var inst_8382 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8411_8454 = state_8392__$1;
(statearr_8411_8454[(2)] = inst_8382);

(statearr_8411_8454[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (17))){
var inst_8347 = (state_8392[(10)]);
var inst_8356 = cljs.core.first.call(null,inst_8347);
var inst_8357 = cljs.core.async.muxch_STAR_.call(null,inst_8356);
var inst_8358 = cljs.core.async.close_BANG_.call(null,inst_8357);
var inst_8359 = cljs.core.next.call(null,inst_8347);
var inst_8333 = inst_8359;
var inst_8334 = null;
var inst_8335 = (0);
var inst_8336 = (0);
var state_8392__$1 = (function (){var statearr_8412 = state_8392;
(statearr_8412[(12)] = inst_8336);

(statearr_8412[(13)] = inst_8335);

(statearr_8412[(14)] = inst_8334);

(statearr_8412[(15)] = inst_8333);

(statearr_8412[(16)] = inst_8358);

return statearr_8412;
})();
var statearr_8413_8455 = state_8392__$1;
(statearr_8413_8455[(2)] = null);

(statearr_8413_8455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (3))){
var inst_8390 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8392__$1,inst_8390);
} else {
if((state_val_8393 === (12))){
var inst_8367 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8414_8456 = state_8392__$1;
(statearr_8414_8456[(2)] = inst_8367);

(statearr_8414_8456[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (2))){
var state_8392__$1 = state_8392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8392__$1,(4),ch);
} else {
if((state_val_8393 === (23))){
var state_8392__$1 = state_8392;
var statearr_8415_8457 = state_8392__$1;
(statearr_8415_8457[(2)] = null);

(statearr_8415_8457[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (19))){
var inst_8323 = (state_8392[(8)]);
var inst_8373 = (state_8392[(11)]);
var inst_8375 = cljs.core.async.muxch_STAR_.call(null,inst_8373);
var state_8392__$1 = state_8392;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8392__$1,(22),inst_8375,inst_8323);
} else {
if((state_val_8393 === (11))){
var inst_8347 = (state_8392[(10)]);
var inst_8333 = (state_8392[(15)]);
var inst_8347__$1 = cljs.core.seq.call(null,inst_8333);
var state_8392__$1 = (function (){var statearr_8416 = state_8392;
(statearr_8416[(10)] = inst_8347__$1);

return statearr_8416;
})();
if(inst_8347__$1){
var statearr_8417_8458 = state_8392__$1;
(statearr_8417_8458[(1)] = (13));

} else {
var statearr_8418_8459 = state_8392__$1;
(statearr_8418_8459[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (9))){
var inst_8369 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8419_8460 = state_8392__$1;
(statearr_8419_8460[(2)] = inst_8369);

(statearr_8419_8460[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (5))){
var inst_8330 = cljs.core.deref.call(null,mults);
var inst_8331 = cljs.core.vals.call(null,inst_8330);
var inst_8332 = cljs.core.seq.call(null,inst_8331);
var inst_8333 = inst_8332;
var inst_8334 = null;
var inst_8335 = (0);
var inst_8336 = (0);
var state_8392__$1 = (function (){var statearr_8420 = state_8392;
(statearr_8420[(12)] = inst_8336);

(statearr_8420[(13)] = inst_8335);

(statearr_8420[(14)] = inst_8334);

(statearr_8420[(15)] = inst_8333);

return statearr_8420;
})();
var statearr_8421_8461 = state_8392__$1;
(statearr_8421_8461[(2)] = null);

(statearr_8421_8461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (14))){
var state_8392__$1 = state_8392;
var statearr_8425_8462 = state_8392__$1;
(statearr_8425_8462[(2)] = null);

(statearr_8425_8462[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (16))){
var inst_8347 = (state_8392[(10)]);
var inst_8351 = cljs.core.chunk_first.call(null,inst_8347);
var inst_8352 = cljs.core.chunk_rest.call(null,inst_8347);
var inst_8353 = cljs.core.count.call(null,inst_8351);
var inst_8333 = inst_8352;
var inst_8334 = inst_8351;
var inst_8335 = inst_8353;
var inst_8336 = (0);
var state_8392__$1 = (function (){var statearr_8426 = state_8392;
(statearr_8426[(12)] = inst_8336);

(statearr_8426[(13)] = inst_8335);

(statearr_8426[(14)] = inst_8334);

(statearr_8426[(15)] = inst_8333);

return statearr_8426;
})();
var statearr_8427_8463 = state_8392__$1;
(statearr_8427_8463[(2)] = null);

(statearr_8427_8463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (10))){
var inst_8336 = (state_8392[(12)]);
var inst_8335 = (state_8392[(13)]);
var inst_8334 = (state_8392[(14)]);
var inst_8333 = (state_8392[(15)]);
var inst_8341 = cljs.core._nth.call(null,inst_8334,inst_8336);
var inst_8342 = cljs.core.async.muxch_STAR_.call(null,inst_8341);
var inst_8343 = cljs.core.async.close_BANG_.call(null,inst_8342);
var inst_8344 = (inst_8336 + (1));
var tmp8422 = inst_8335;
var tmp8423 = inst_8334;
var tmp8424 = inst_8333;
var inst_8333__$1 = tmp8424;
var inst_8334__$1 = tmp8423;
var inst_8335__$1 = tmp8422;
var inst_8336__$1 = inst_8344;
var state_8392__$1 = (function (){var statearr_8428 = state_8392;
(statearr_8428[(12)] = inst_8336__$1);

(statearr_8428[(13)] = inst_8335__$1);

(statearr_8428[(14)] = inst_8334__$1);

(statearr_8428[(15)] = inst_8333__$1);

(statearr_8428[(17)] = inst_8343);

return statearr_8428;
})();
var statearr_8429_8464 = state_8392__$1;
(statearr_8429_8464[(2)] = null);

(statearr_8429_8464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (18))){
var inst_8362 = (state_8392[(2)]);
var state_8392__$1 = state_8392;
var statearr_8430_8465 = state_8392__$1;
(statearr_8430_8465[(2)] = inst_8362);

(statearr_8430_8465[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8393 === (8))){
var inst_8336 = (state_8392[(12)]);
var inst_8335 = (state_8392[(13)]);
var inst_8338 = (inst_8336 < inst_8335);
var inst_8339 = inst_8338;
var state_8392__$1 = state_8392;
if(cljs.core.truth_(inst_8339)){
var statearr_8431_8466 = state_8392__$1;
(statearr_8431_8466[(1)] = (10));

} else {
var statearr_8432_8467 = state_8392__$1;
(statearr_8432_8467[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8433[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8433[(1)] = (1));

return statearr_8433;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8392){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8434){var ex__7098__auto__ = e8434;
var statearr_8435_8468 = state_8392;
(statearr_8435_8468[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8392[(4)]))){
var statearr_8436_8469 = state_8392;
(statearr_8436_8469[(1)] = cljs.core.first.call(null,(state_8392[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8470 = state_8392;
state_8392 = G__8470;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8392){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8437 = f__7169__auto__.call(null);
(statearr_8437[(6)] = c__7168__auto___8439);

return statearr_8437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__8472 = arguments.length;
switch (G__8472) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__8475 = arguments.length;
switch (G__8475) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__8478 = arguments.length;
switch (G__8478) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__7168__auto___8556 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8521){
var state_val_8522 = (state_8521[(1)]);
if((state_val_8522 === (7))){
var state_8521__$1 = state_8521;
var statearr_8523_8557 = state_8521__$1;
(statearr_8523_8557[(2)] = null);

(statearr_8523_8557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (1))){
var state_8521__$1 = state_8521;
var statearr_8524_8558 = state_8521__$1;
(statearr_8524_8558[(2)] = null);

(statearr_8524_8558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (4))){
var inst_8482 = (state_8521[(7)]);
var inst_8481 = (state_8521[(8)]);
var inst_8484 = (inst_8482 < inst_8481);
var state_8521__$1 = state_8521;
if(cljs.core.truth_(inst_8484)){
var statearr_8525_8559 = state_8521__$1;
(statearr_8525_8559[(1)] = (6));

} else {
var statearr_8526_8560 = state_8521__$1;
(statearr_8526_8560[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (15))){
var inst_8507 = (state_8521[(9)]);
var inst_8512 = cljs.core.apply.call(null,f,inst_8507);
var state_8521__$1 = state_8521;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8521__$1,(17),out,inst_8512);
} else {
if((state_val_8522 === (13))){
var inst_8507 = (state_8521[(9)]);
var inst_8507__$1 = (state_8521[(2)]);
var inst_8508 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_8507__$1);
var state_8521__$1 = (function (){var statearr_8527 = state_8521;
(statearr_8527[(9)] = inst_8507__$1);

return statearr_8527;
})();
if(cljs.core.truth_(inst_8508)){
var statearr_8528_8561 = state_8521__$1;
(statearr_8528_8561[(1)] = (14));

} else {
var statearr_8529_8562 = state_8521__$1;
(statearr_8529_8562[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (6))){
var state_8521__$1 = state_8521;
var statearr_8530_8563 = state_8521__$1;
(statearr_8530_8563[(2)] = null);

(statearr_8530_8563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (17))){
var inst_8514 = (state_8521[(2)]);
var state_8521__$1 = (function (){var statearr_8532 = state_8521;
(statearr_8532[(10)] = inst_8514);

return statearr_8532;
})();
var statearr_8533_8564 = state_8521__$1;
(statearr_8533_8564[(2)] = null);

(statearr_8533_8564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (3))){
var inst_8519 = (state_8521[(2)]);
var state_8521__$1 = state_8521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8521__$1,inst_8519);
} else {
if((state_val_8522 === (12))){
var _ = (function (){var statearr_8534 = state_8521;
(statearr_8534[(4)] = cljs.core.rest.call(null,(state_8521[(4)])));

return statearr_8534;
})();
var state_8521__$1 = state_8521;
var ex8531 = (state_8521__$1[(2)]);
var statearr_8535_8565 = state_8521__$1;
(statearr_8535_8565[(5)] = ex8531);


if((ex8531 instanceof Object)){
var statearr_8536_8566 = state_8521__$1;
(statearr_8536_8566[(1)] = (11));

(statearr_8536_8566[(5)] = null);

} else {
throw ex8531;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (2))){
var inst_8480 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_8481 = cnt;
var inst_8482 = (0);
var state_8521__$1 = (function (){var statearr_8537 = state_8521;
(statearr_8537[(7)] = inst_8482);

(statearr_8537[(8)] = inst_8481);

(statearr_8537[(11)] = inst_8480);

return statearr_8537;
})();
var statearr_8538_8567 = state_8521__$1;
(statearr_8538_8567[(2)] = null);

(statearr_8538_8567[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (11))){
var inst_8486 = (state_8521[(2)]);
var inst_8487 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_8521__$1 = (function (){var statearr_8539 = state_8521;
(statearr_8539[(12)] = inst_8486);

return statearr_8539;
})();
var statearr_8540_8568 = state_8521__$1;
(statearr_8540_8568[(2)] = inst_8487);

(statearr_8540_8568[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (9))){
var inst_8482 = (state_8521[(7)]);
var _ = (function (){var statearr_8541 = state_8521;
(statearr_8541[(4)] = cljs.core.cons.call(null,(12),(state_8521[(4)])));

return statearr_8541;
})();
var inst_8493 = chs__$1.call(null,inst_8482);
var inst_8494 = done.call(null,inst_8482);
var inst_8495 = cljs.core.async.take_BANG_.call(null,inst_8493,inst_8494);
var ___$1 = (function (){var statearr_8542 = state_8521;
(statearr_8542[(4)] = cljs.core.rest.call(null,(state_8521[(4)])));

return statearr_8542;
})();
var state_8521__$1 = state_8521;
var statearr_8543_8569 = state_8521__$1;
(statearr_8543_8569[(2)] = inst_8495);

(statearr_8543_8569[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (5))){
var inst_8505 = (state_8521[(2)]);
var state_8521__$1 = (function (){var statearr_8544 = state_8521;
(statearr_8544[(13)] = inst_8505);

return statearr_8544;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8521__$1,(13),dchan);
} else {
if((state_val_8522 === (14))){
var inst_8510 = cljs.core.async.close_BANG_.call(null,out);
var state_8521__$1 = state_8521;
var statearr_8545_8570 = state_8521__$1;
(statearr_8545_8570[(2)] = inst_8510);

(statearr_8545_8570[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (16))){
var inst_8517 = (state_8521[(2)]);
var state_8521__$1 = state_8521;
var statearr_8546_8571 = state_8521__$1;
(statearr_8546_8571[(2)] = inst_8517);

(statearr_8546_8571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (10))){
var inst_8482 = (state_8521[(7)]);
var inst_8498 = (state_8521[(2)]);
var inst_8499 = (inst_8482 + (1));
var inst_8482__$1 = inst_8499;
var state_8521__$1 = (function (){var statearr_8547 = state_8521;
(statearr_8547[(7)] = inst_8482__$1);

(statearr_8547[(14)] = inst_8498);

return statearr_8547;
})();
var statearr_8548_8572 = state_8521__$1;
(statearr_8548_8572[(2)] = null);

(statearr_8548_8572[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8522 === (8))){
var inst_8503 = (state_8521[(2)]);
var state_8521__$1 = state_8521;
var statearr_8549_8573 = state_8521__$1;
(statearr_8549_8573[(2)] = inst_8503);

(statearr_8549_8573[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8550[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8550[(1)] = (1));

return statearr_8550;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8521){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8551){var ex__7098__auto__ = e8551;
var statearr_8552_8574 = state_8521;
(statearr_8552_8574[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8521[(4)]))){
var statearr_8553_8575 = state_8521;
(statearr_8553_8575[(1)] = cljs.core.first.call(null,(state_8521[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8576 = state_8521;
state_8521 = G__8576;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8521){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8554 = f__7169__auto__.call(null);
(statearr_8554[(6)] = c__7168__auto___8556);

return statearr_8554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__8579 = arguments.length;
switch (G__8579) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___8634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8611){
var state_val_8612 = (state_8611[(1)]);
if((state_val_8612 === (7))){
var inst_8590 = (state_8611[(7)]);
var inst_8591 = (state_8611[(8)]);
var inst_8590__$1 = (state_8611[(2)]);
var inst_8591__$1 = cljs.core.nth.call(null,inst_8590__$1,(0),null);
var inst_8592 = cljs.core.nth.call(null,inst_8590__$1,(1),null);
var inst_8593 = (inst_8591__$1 == null);
var state_8611__$1 = (function (){var statearr_8613 = state_8611;
(statearr_8613[(7)] = inst_8590__$1);

(statearr_8613[(8)] = inst_8591__$1);

(statearr_8613[(9)] = inst_8592);

return statearr_8613;
})();
if(cljs.core.truth_(inst_8593)){
var statearr_8614_8635 = state_8611__$1;
(statearr_8614_8635[(1)] = (8));

} else {
var statearr_8615_8636 = state_8611__$1;
(statearr_8615_8636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (1))){
var inst_8580 = cljs.core.vec.call(null,chs);
var inst_8581 = inst_8580;
var state_8611__$1 = (function (){var statearr_8616 = state_8611;
(statearr_8616[(10)] = inst_8581);

return statearr_8616;
})();
var statearr_8617_8637 = state_8611__$1;
(statearr_8617_8637[(2)] = null);

(statearr_8617_8637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (4))){
var inst_8581 = (state_8611[(10)]);
var state_8611__$1 = state_8611;
return cljs.core.async.ioc_alts_BANG_.call(null,state_8611__$1,(7),inst_8581);
} else {
if((state_val_8612 === (6))){
var inst_8607 = (state_8611[(2)]);
var state_8611__$1 = state_8611;
var statearr_8618_8638 = state_8611__$1;
(statearr_8618_8638[(2)] = inst_8607);

(statearr_8618_8638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (3))){
var inst_8609 = (state_8611[(2)]);
var state_8611__$1 = state_8611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8611__$1,inst_8609);
} else {
if((state_val_8612 === (2))){
var inst_8581 = (state_8611[(10)]);
var inst_8583 = cljs.core.count.call(null,inst_8581);
var inst_8584 = (inst_8583 > (0));
var state_8611__$1 = state_8611;
if(cljs.core.truth_(inst_8584)){
var statearr_8620_8639 = state_8611__$1;
(statearr_8620_8639[(1)] = (4));

} else {
var statearr_8621_8640 = state_8611__$1;
(statearr_8621_8640[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (11))){
var inst_8581 = (state_8611[(10)]);
var inst_8600 = (state_8611[(2)]);
var tmp8619 = inst_8581;
var inst_8581__$1 = tmp8619;
var state_8611__$1 = (function (){var statearr_8622 = state_8611;
(statearr_8622[(10)] = inst_8581__$1);

(statearr_8622[(11)] = inst_8600);

return statearr_8622;
})();
var statearr_8623_8641 = state_8611__$1;
(statearr_8623_8641[(2)] = null);

(statearr_8623_8641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (9))){
var inst_8591 = (state_8611[(8)]);
var state_8611__$1 = state_8611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8611__$1,(11),out,inst_8591);
} else {
if((state_val_8612 === (5))){
var inst_8605 = cljs.core.async.close_BANG_.call(null,out);
var state_8611__$1 = state_8611;
var statearr_8624_8642 = state_8611__$1;
(statearr_8624_8642[(2)] = inst_8605);

(statearr_8624_8642[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (10))){
var inst_8603 = (state_8611[(2)]);
var state_8611__$1 = state_8611;
var statearr_8625_8643 = state_8611__$1;
(statearr_8625_8643[(2)] = inst_8603);

(statearr_8625_8643[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8612 === (8))){
var inst_8590 = (state_8611[(7)]);
var inst_8581 = (state_8611[(10)]);
var inst_8591 = (state_8611[(8)]);
var inst_8592 = (state_8611[(9)]);
var inst_8595 = (function (){var cs = inst_8581;
var vec__8586 = inst_8590;
var v = inst_8591;
var c = inst_8592;
return (function (p1__8577_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__8577_SHARP_);
});
})();
var inst_8596 = cljs.core.filterv.call(null,inst_8595,inst_8581);
var inst_8581__$1 = inst_8596;
var state_8611__$1 = (function (){var statearr_8626 = state_8611;
(statearr_8626[(10)] = inst_8581__$1);

return statearr_8626;
})();
var statearr_8627_8644 = state_8611__$1;
(statearr_8627_8644[(2)] = null);

(statearr_8627_8644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8628 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8628[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8628[(1)] = (1));

return statearr_8628;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8611){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8629){var ex__7098__auto__ = e8629;
var statearr_8630_8645 = state_8611;
(statearr_8630_8645[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8611[(4)]))){
var statearr_8631_8646 = state_8611;
(statearr_8631_8646[(1)] = cljs.core.first.call(null,(state_8611[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8647 = state_8611;
state_8611 = G__8647;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8611){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8632 = f__7169__auto__.call(null);
(statearr_8632[(6)] = c__7168__auto___8634);

return statearr_8632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__8649 = arguments.length;
switch (G__8649) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___8695 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8673){
var state_val_8674 = (state_8673[(1)]);
if((state_val_8674 === (7))){
var inst_8655 = (state_8673[(7)]);
var inst_8655__$1 = (state_8673[(2)]);
var inst_8656 = (inst_8655__$1 == null);
var inst_8657 = cljs.core.not.call(null,inst_8656);
var state_8673__$1 = (function (){var statearr_8675 = state_8673;
(statearr_8675[(7)] = inst_8655__$1);

return statearr_8675;
})();
if(inst_8657){
var statearr_8676_8696 = state_8673__$1;
(statearr_8676_8696[(1)] = (8));

} else {
var statearr_8677_8697 = state_8673__$1;
(statearr_8677_8697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (1))){
var inst_8650 = (0);
var state_8673__$1 = (function (){var statearr_8678 = state_8673;
(statearr_8678[(8)] = inst_8650);

return statearr_8678;
})();
var statearr_8679_8698 = state_8673__$1;
(statearr_8679_8698[(2)] = null);

(statearr_8679_8698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (4))){
var state_8673__$1 = state_8673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8673__$1,(7),ch);
} else {
if((state_val_8674 === (6))){
var inst_8668 = (state_8673[(2)]);
var state_8673__$1 = state_8673;
var statearr_8680_8699 = state_8673__$1;
(statearr_8680_8699[(2)] = inst_8668);

(statearr_8680_8699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (3))){
var inst_8670 = (state_8673[(2)]);
var inst_8671 = cljs.core.async.close_BANG_.call(null,out);
var state_8673__$1 = (function (){var statearr_8681 = state_8673;
(statearr_8681[(9)] = inst_8670);

return statearr_8681;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8673__$1,inst_8671);
} else {
if((state_val_8674 === (2))){
var inst_8650 = (state_8673[(8)]);
var inst_8652 = (inst_8650 < n);
var state_8673__$1 = state_8673;
if(cljs.core.truth_(inst_8652)){
var statearr_8682_8700 = state_8673__$1;
(statearr_8682_8700[(1)] = (4));

} else {
var statearr_8683_8701 = state_8673__$1;
(statearr_8683_8701[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (11))){
var inst_8650 = (state_8673[(8)]);
var inst_8660 = (state_8673[(2)]);
var inst_8661 = (inst_8650 + (1));
var inst_8650__$1 = inst_8661;
var state_8673__$1 = (function (){var statearr_8684 = state_8673;
(statearr_8684[(10)] = inst_8660);

(statearr_8684[(8)] = inst_8650__$1);

return statearr_8684;
})();
var statearr_8685_8702 = state_8673__$1;
(statearr_8685_8702[(2)] = null);

(statearr_8685_8702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (9))){
var state_8673__$1 = state_8673;
var statearr_8686_8703 = state_8673__$1;
(statearr_8686_8703[(2)] = null);

(statearr_8686_8703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (5))){
var state_8673__$1 = state_8673;
var statearr_8687_8704 = state_8673__$1;
(statearr_8687_8704[(2)] = null);

(statearr_8687_8704[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (10))){
var inst_8665 = (state_8673[(2)]);
var state_8673__$1 = state_8673;
var statearr_8688_8705 = state_8673__$1;
(statearr_8688_8705[(2)] = inst_8665);

(statearr_8688_8705[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8674 === (8))){
var inst_8655 = (state_8673[(7)]);
var state_8673__$1 = state_8673;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8673__$1,(11),out,inst_8655);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8689 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8689[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8689[(1)] = (1));

return statearr_8689;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8673){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8690){var ex__7098__auto__ = e8690;
var statearr_8691_8706 = state_8673;
(statearr_8691_8706[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8673[(4)]))){
var statearr_8692_8707 = state_8673;
(statearr_8692_8707[(1)] = cljs.core.first.call(null,(state_8673[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8708 = state_8673;
state_8673 = G__8708;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8673){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8693 = f__7169__auto__.call(null);
(statearr_8693[(6)] = c__7168__auto___8695);

return statearr_8693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8710 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8710 = (function (f,ch,meta8711){
this.f = f;
this.ch = ch;
this.meta8711 = meta8711;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8712,meta8711__$1){
var self__ = this;
var _8712__$1 = this;
return (new cljs.core.async.t_cljs$core$async8710(self__.f,self__.ch,meta8711__$1));
}));

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8712){
var self__ = this;
var _8712__$1 = this;
return self__.meta8711;
}));

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8713 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8713 = (function (f,ch,meta8711,_,fn1,meta8714){
this.f = f;
this.ch = ch;
this.meta8711 = meta8711;
this._ = _;
this.fn1 = fn1;
this.meta8714 = meta8714;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8715,meta8714__$1){
var self__ = this;
var _8715__$1 = this;
return (new cljs.core.async.t_cljs$core$async8713(self__.f,self__.ch,self__.meta8711,self__._,self__.fn1,meta8714__$1));
}));

(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8715){
var self__ = this;
var _8715__$1 = this;
return self__.meta8714;
}));

(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async8713.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__8709_SHARP_){
return f1.call(null,(((p1__8709_SHARP_ == null))?null:self__.f.call(null,p1__8709_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async8713.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta8711","meta8711",-1261517772,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async8710","cljs.core.async/t_cljs$core$async8710",-1339974927,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta8714","meta8714",-730357214,null)], null);
}));

(cljs.core.async.t_cljs$core$async8713.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8713.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8713");

(cljs.core.async.t_cljs$core$async8713.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8713");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8713.
 */
cljs.core.async.__GT_t_cljs$core$async8713 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async8713(f__$1,ch__$1,meta8711__$1,___$2,fn1__$1,meta8714){
return (new cljs.core.async.t_cljs$core$async8713(f__$1,ch__$1,meta8711__$1,___$2,fn1__$1,meta8714));
});

}

return (new cljs.core.async.t_cljs$core$async8713(self__.f,self__.ch,self__.meta8711,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8710.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async8710.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta8711","meta8711",-1261517772,null)], null);
}));

(cljs.core.async.t_cljs$core$async8710.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8710.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8710");

(cljs.core.async.t_cljs$core$async8710.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8710");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8710.
 */
cljs.core.async.__GT_t_cljs$core$async8710 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async8710(f__$1,ch__$1,meta8711){
return (new cljs.core.async.t_cljs$core$async8710(f__$1,ch__$1,meta8711));
});

}

return (new cljs.core.async.t_cljs$core$async8710(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8716 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8716 = (function (f,ch,meta8717){
this.f = f;
this.ch = ch;
this.meta8717 = meta8717;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8718,meta8717__$1){
var self__ = this;
var _8718__$1 = this;
return (new cljs.core.async.t_cljs$core$async8716(self__.f,self__.ch,meta8717__$1));
}));

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8718){
var self__ = this;
var _8718__$1 = this;
return self__.meta8717;
}));

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8716.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async8716.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta8717","meta8717",215960449,null)], null);
}));

(cljs.core.async.t_cljs$core$async8716.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8716.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8716");

(cljs.core.async.t_cljs$core$async8716.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8716");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8716.
 */
cljs.core.async.__GT_t_cljs$core$async8716 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async8716(f__$1,ch__$1,meta8717){
return (new cljs.core.async.t_cljs$core$async8716(f__$1,ch__$1,meta8717));
});

}

return (new cljs.core.async.t_cljs$core$async8716(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8719 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8719 = (function (p,ch,meta8720){
this.p = p;
this.ch = ch;
this.meta8720 = meta8720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8721,meta8720__$1){
var self__ = this;
var _8721__$1 = this;
return (new cljs.core.async.t_cljs$core$async8719(self__.p,self__.ch,meta8720__$1));
}));

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8721){
var self__ = this;
var _8721__$1 = this;
return self__.meta8720;
}));

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8719.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async8719.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta8720","meta8720",-1926114718,null)], null);
}));

(cljs.core.async.t_cljs$core$async8719.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8719.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8719");

(cljs.core.async.t_cljs$core$async8719.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async8719");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8719.
 */
cljs.core.async.__GT_t_cljs$core$async8719 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async8719(p__$1,ch__$1,meta8720){
return (new cljs.core.async.t_cljs$core$async8719(p__$1,ch__$1,meta8720));
});

}

return (new cljs.core.async.t_cljs$core$async8719(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__8723 = arguments.length;
switch (G__8723) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___8764 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8744){
var state_val_8745 = (state_8744[(1)]);
if((state_val_8745 === (7))){
var inst_8740 = (state_8744[(2)]);
var state_8744__$1 = state_8744;
var statearr_8746_8765 = state_8744__$1;
(statearr_8746_8765[(2)] = inst_8740);

(statearr_8746_8765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (1))){
var state_8744__$1 = state_8744;
var statearr_8747_8766 = state_8744__$1;
(statearr_8747_8766[(2)] = null);

(statearr_8747_8766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (4))){
var inst_8726 = (state_8744[(7)]);
var inst_8726__$1 = (state_8744[(2)]);
var inst_8727 = (inst_8726__$1 == null);
var state_8744__$1 = (function (){var statearr_8748 = state_8744;
(statearr_8748[(7)] = inst_8726__$1);

return statearr_8748;
})();
if(cljs.core.truth_(inst_8727)){
var statearr_8749_8767 = state_8744__$1;
(statearr_8749_8767[(1)] = (5));

} else {
var statearr_8750_8768 = state_8744__$1;
(statearr_8750_8768[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (6))){
var inst_8726 = (state_8744[(7)]);
var inst_8731 = p.call(null,inst_8726);
var state_8744__$1 = state_8744;
if(cljs.core.truth_(inst_8731)){
var statearr_8751_8769 = state_8744__$1;
(statearr_8751_8769[(1)] = (8));

} else {
var statearr_8752_8770 = state_8744__$1;
(statearr_8752_8770[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (3))){
var inst_8742 = (state_8744[(2)]);
var state_8744__$1 = state_8744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8744__$1,inst_8742);
} else {
if((state_val_8745 === (2))){
var state_8744__$1 = state_8744;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8744__$1,(4),ch);
} else {
if((state_val_8745 === (11))){
var inst_8734 = (state_8744[(2)]);
var state_8744__$1 = state_8744;
var statearr_8753_8771 = state_8744__$1;
(statearr_8753_8771[(2)] = inst_8734);

(statearr_8753_8771[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (9))){
var state_8744__$1 = state_8744;
var statearr_8754_8772 = state_8744__$1;
(statearr_8754_8772[(2)] = null);

(statearr_8754_8772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (5))){
var inst_8729 = cljs.core.async.close_BANG_.call(null,out);
var state_8744__$1 = state_8744;
var statearr_8755_8773 = state_8744__$1;
(statearr_8755_8773[(2)] = inst_8729);

(statearr_8755_8773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (10))){
var inst_8737 = (state_8744[(2)]);
var state_8744__$1 = (function (){var statearr_8756 = state_8744;
(statearr_8756[(8)] = inst_8737);

return statearr_8756;
})();
var statearr_8757_8774 = state_8744__$1;
(statearr_8757_8774[(2)] = null);

(statearr_8757_8774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8745 === (8))){
var inst_8726 = (state_8744[(7)]);
var state_8744__$1 = state_8744;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8744__$1,(11),out,inst_8726);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8758 = [null,null,null,null,null,null,null,null,null];
(statearr_8758[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8758[(1)] = (1));

return statearr_8758;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8744){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8759){var ex__7098__auto__ = e8759;
var statearr_8760_8775 = state_8744;
(statearr_8760_8775[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8744[(4)]))){
var statearr_8761_8776 = state_8744;
(statearr_8761_8776[(1)] = cljs.core.first.call(null,(state_8744[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8777 = state_8744;
state_8744 = G__8777;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8744){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8762 = f__7169__auto__.call(null);
(statearr_8762[(6)] = c__7168__auto___8764);

return statearr_8762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__8779 = arguments.length;
switch (G__8779) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7168__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8842){
var state_val_8843 = (state_8842[(1)]);
if((state_val_8843 === (7))){
var inst_8838 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
var statearr_8844_8883 = state_8842__$1;
(statearr_8844_8883[(2)] = inst_8838);

(statearr_8844_8883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (20))){
var inst_8808 = (state_8842[(7)]);
var inst_8819 = (state_8842[(2)]);
var inst_8820 = cljs.core.next.call(null,inst_8808);
var inst_8794 = inst_8820;
var inst_8795 = null;
var inst_8796 = (0);
var inst_8797 = (0);
var state_8842__$1 = (function (){var statearr_8845 = state_8842;
(statearr_8845[(8)] = inst_8796);

(statearr_8845[(9)] = inst_8794);

(statearr_8845[(10)] = inst_8797);

(statearr_8845[(11)] = inst_8795);

(statearr_8845[(12)] = inst_8819);

return statearr_8845;
})();
var statearr_8846_8884 = state_8842__$1;
(statearr_8846_8884[(2)] = null);

(statearr_8846_8884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (1))){
var state_8842__$1 = state_8842;
var statearr_8847_8885 = state_8842__$1;
(statearr_8847_8885[(2)] = null);

(statearr_8847_8885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (4))){
var inst_8783 = (state_8842[(13)]);
var inst_8783__$1 = (state_8842[(2)]);
var inst_8784 = (inst_8783__$1 == null);
var state_8842__$1 = (function (){var statearr_8848 = state_8842;
(statearr_8848[(13)] = inst_8783__$1);

return statearr_8848;
})();
if(cljs.core.truth_(inst_8784)){
var statearr_8849_8886 = state_8842__$1;
(statearr_8849_8886[(1)] = (5));

} else {
var statearr_8850_8887 = state_8842__$1;
(statearr_8850_8887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (15))){
var state_8842__$1 = state_8842;
var statearr_8854_8888 = state_8842__$1;
(statearr_8854_8888[(2)] = null);

(statearr_8854_8888[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (21))){
var state_8842__$1 = state_8842;
var statearr_8855_8889 = state_8842__$1;
(statearr_8855_8889[(2)] = null);

(statearr_8855_8889[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (13))){
var inst_8796 = (state_8842[(8)]);
var inst_8794 = (state_8842[(9)]);
var inst_8797 = (state_8842[(10)]);
var inst_8795 = (state_8842[(11)]);
var inst_8804 = (state_8842[(2)]);
var inst_8805 = (inst_8797 + (1));
var tmp8851 = inst_8796;
var tmp8852 = inst_8794;
var tmp8853 = inst_8795;
var inst_8794__$1 = tmp8852;
var inst_8795__$1 = tmp8853;
var inst_8796__$1 = tmp8851;
var inst_8797__$1 = inst_8805;
var state_8842__$1 = (function (){var statearr_8856 = state_8842;
(statearr_8856[(8)] = inst_8796__$1);

(statearr_8856[(14)] = inst_8804);

(statearr_8856[(9)] = inst_8794__$1);

(statearr_8856[(10)] = inst_8797__$1);

(statearr_8856[(11)] = inst_8795__$1);

return statearr_8856;
})();
var statearr_8857_8890 = state_8842__$1;
(statearr_8857_8890[(2)] = null);

(statearr_8857_8890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (22))){
var state_8842__$1 = state_8842;
var statearr_8858_8891 = state_8842__$1;
(statearr_8858_8891[(2)] = null);

(statearr_8858_8891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (6))){
var inst_8783 = (state_8842[(13)]);
var inst_8792 = f.call(null,inst_8783);
var inst_8793 = cljs.core.seq.call(null,inst_8792);
var inst_8794 = inst_8793;
var inst_8795 = null;
var inst_8796 = (0);
var inst_8797 = (0);
var state_8842__$1 = (function (){var statearr_8859 = state_8842;
(statearr_8859[(8)] = inst_8796);

(statearr_8859[(9)] = inst_8794);

(statearr_8859[(10)] = inst_8797);

(statearr_8859[(11)] = inst_8795);

return statearr_8859;
})();
var statearr_8860_8892 = state_8842__$1;
(statearr_8860_8892[(2)] = null);

(statearr_8860_8892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (17))){
var inst_8808 = (state_8842[(7)]);
var inst_8812 = cljs.core.chunk_first.call(null,inst_8808);
var inst_8813 = cljs.core.chunk_rest.call(null,inst_8808);
var inst_8814 = cljs.core.count.call(null,inst_8812);
var inst_8794 = inst_8813;
var inst_8795 = inst_8812;
var inst_8796 = inst_8814;
var inst_8797 = (0);
var state_8842__$1 = (function (){var statearr_8861 = state_8842;
(statearr_8861[(8)] = inst_8796);

(statearr_8861[(9)] = inst_8794);

(statearr_8861[(10)] = inst_8797);

(statearr_8861[(11)] = inst_8795);

return statearr_8861;
})();
var statearr_8862_8893 = state_8842__$1;
(statearr_8862_8893[(2)] = null);

(statearr_8862_8893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (3))){
var inst_8840 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8842__$1,inst_8840);
} else {
if((state_val_8843 === (12))){
var inst_8828 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
var statearr_8863_8894 = state_8842__$1;
(statearr_8863_8894[(2)] = inst_8828);

(statearr_8863_8894[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (2))){
var state_8842__$1 = state_8842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8842__$1,(4),in$);
} else {
if((state_val_8843 === (23))){
var inst_8836 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
var statearr_8864_8895 = state_8842__$1;
(statearr_8864_8895[(2)] = inst_8836);

(statearr_8864_8895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (19))){
var inst_8823 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
var statearr_8865_8896 = state_8842__$1;
(statearr_8865_8896[(2)] = inst_8823);

(statearr_8865_8896[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (11))){
var inst_8808 = (state_8842[(7)]);
var inst_8794 = (state_8842[(9)]);
var inst_8808__$1 = cljs.core.seq.call(null,inst_8794);
var state_8842__$1 = (function (){var statearr_8866 = state_8842;
(statearr_8866[(7)] = inst_8808__$1);

return statearr_8866;
})();
if(inst_8808__$1){
var statearr_8867_8897 = state_8842__$1;
(statearr_8867_8897[(1)] = (14));

} else {
var statearr_8868_8898 = state_8842__$1;
(statearr_8868_8898[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (9))){
var inst_8830 = (state_8842[(2)]);
var inst_8831 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_8842__$1 = (function (){var statearr_8869 = state_8842;
(statearr_8869[(15)] = inst_8830);

return statearr_8869;
})();
if(cljs.core.truth_(inst_8831)){
var statearr_8870_8899 = state_8842__$1;
(statearr_8870_8899[(1)] = (21));

} else {
var statearr_8871_8900 = state_8842__$1;
(statearr_8871_8900[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (5))){
var inst_8786 = cljs.core.async.close_BANG_.call(null,out);
var state_8842__$1 = state_8842;
var statearr_8872_8901 = state_8842__$1;
(statearr_8872_8901[(2)] = inst_8786);

(statearr_8872_8901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (14))){
var inst_8808 = (state_8842[(7)]);
var inst_8810 = cljs.core.chunked_seq_QMARK_.call(null,inst_8808);
var state_8842__$1 = state_8842;
if(inst_8810){
var statearr_8873_8902 = state_8842__$1;
(statearr_8873_8902[(1)] = (17));

} else {
var statearr_8874_8903 = state_8842__$1;
(statearr_8874_8903[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (16))){
var inst_8826 = (state_8842[(2)]);
var state_8842__$1 = state_8842;
var statearr_8875_8904 = state_8842__$1;
(statearr_8875_8904[(2)] = inst_8826);

(statearr_8875_8904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8843 === (10))){
var inst_8797 = (state_8842[(10)]);
var inst_8795 = (state_8842[(11)]);
var inst_8802 = cljs.core._nth.call(null,inst_8795,inst_8797);
var state_8842__$1 = state_8842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8842__$1,(13),out,inst_8802);
} else {
if((state_val_8843 === (18))){
var inst_8808 = (state_8842[(7)]);
var inst_8817 = cljs.core.first.call(null,inst_8808);
var state_8842__$1 = state_8842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8842__$1,(20),out,inst_8817);
} else {
if((state_val_8843 === (8))){
var inst_8796 = (state_8842[(8)]);
var inst_8797 = (state_8842[(10)]);
var inst_8799 = (inst_8797 < inst_8796);
var inst_8800 = inst_8799;
var state_8842__$1 = state_8842;
if(cljs.core.truth_(inst_8800)){
var statearr_8876_8905 = state_8842__$1;
(statearr_8876_8905[(1)] = (10));

} else {
var statearr_8877_8906 = state_8842__$1;
(statearr_8877_8906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____0 = (function (){
var statearr_8878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8878[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__);

(statearr_8878[(1)] = (1));

return statearr_8878;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____1 = (function (state_8842){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8879){var ex__7098__auto__ = e8879;
var statearr_8880_8907 = state_8842;
(statearr_8880_8907[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8842[(4)]))){
var statearr_8881_8908 = state_8842;
(statearr_8881_8908[(1)] = cljs.core.first.call(null,(state_8842[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8909 = state_8842;
state_8842 = G__8909;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__ = function(state_8842){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____1.call(this,state_8842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7095__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8882 = f__7169__auto__.call(null);
(statearr_8882[(6)] = c__7168__auto__);

return statearr_8882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));

return c__7168__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__8911 = arguments.length;
switch (G__8911) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__8914 = arguments.length;
switch (G__8914) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__8917 = arguments.length;
switch (G__8917) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___8965 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_8941){
var state_val_8942 = (state_8941[(1)]);
if((state_val_8942 === (7))){
var inst_8936 = (state_8941[(2)]);
var state_8941__$1 = state_8941;
var statearr_8943_8966 = state_8941__$1;
(statearr_8943_8966[(2)] = inst_8936);

(statearr_8943_8966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (1))){
var inst_8918 = null;
var state_8941__$1 = (function (){var statearr_8944 = state_8941;
(statearr_8944[(7)] = inst_8918);

return statearr_8944;
})();
var statearr_8945_8967 = state_8941__$1;
(statearr_8945_8967[(2)] = null);

(statearr_8945_8967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (4))){
var inst_8921 = (state_8941[(8)]);
var inst_8921__$1 = (state_8941[(2)]);
var inst_8922 = (inst_8921__$1 == null);
var inst_8923 = cljs.core.not.call(null,inst_8922);
var state_8941__$1 = (function (){var statearr_8946 = state_8941;
(statearr_8946[(8)] = inst_8921__$1);

return statearr_8946;
})();
if(inst_8923){
var statearr_8947_8968 = state_8941__$1;
(statearr_8947_8968[(1)] = (5));

} else {
var statearr_8948_8969 = state_8941__$1;
(statearr_8948_8969[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (6))){
var state_8941__$1 = state_8941;
var statearr_8949_8970 = state_8941__$1;
(statearr_8949_8970[(2)] = null);

(statearr_8949_8970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (3))){
var inst_8938 = (state_8941[(2)]);
var inst_8939 = cljs.core.async.close_BANG_.call(null,out);
var state_8941__$1 = (function (){var statearr_8950 = state_8941;
(statearr_8950[(9)] = inst_8938);

return statearr_8950;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8941__$1,inst_8939);
} else {
if((state_val_8942 === (2))){
var state_8941__$1 = state_8941;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8941__$1,(4),ch);
} else {
if((state_val_8942 === (11))){
var inst_8921 = (state_8941[(8)]);
var inst_8930 = (state_8941[(2)]);
var inst_8918 = inst_8921;
var state_8941__$1 = (function (){var statearr_8951 = state_8941;
(statearr_8951[(10)] = inst_8930);

(statearr_8951[(7)] = inst_8918);

return statearr_8951;
})();
var statearr_8952_8971 = state_8941__$1;
(statearr_8952_8971[(2)] = null);

(statearr_8952_8971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (9))){
var inst_8921 = (state_8941[(8)]);
var state_8941__$1 = state_8941;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8941__$1,(11),out,inst_8921);
} else {
if((state_val_8942 === (5))){
var inst_8921 = (state_8941[(8)]);
var inst_8918 = (state_8941[(7)]);
var inst_8925 = cljs.core._EQ_.call(null,inst_8921,inst_8918);
var state_8941__$1 = state_8941;
if(inst_8925){
var statearr_8954_8972 = state_8941__$1;
(statearr_8954_8972[(1)] = (8));

} else {
var statearr_8955_8973 = state_8941__$1;
(statearr_8955_8973[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (10))){
var inst_8933 = (state_8941[(2)]);
var state_8941__$1 = state_8941;
var statearr_8956_8974 = state_8941__$1;
(statearr_8956_8974[(2)] = inst_8933);

(statearr_8956_8974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8942 === (8))){
var inst_8918 = (state_8941[(7)]);
var tmp8953 = inst_8918;
var inst_8918__$1 = tmp8953;
var state_8941__$1 = (function (){var statearr_8957 = state_8941;
(statearr_8957[(7)] = inst_8918__$1);

return statearr_8957;
})();
var statearr_8958_8975 = state_8941__$1;
(statearr_8958_8975[(2)] = null);

(statearr_8958_8975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_8959 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8959[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_8959[(1)] = (1));

return statearr_8959;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_8941){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_8941);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e8960){var ex__7098__auto__ = e8960;
var statearr_8961_8976 = state_8941;
(statearr_8961_8976[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_8941[(4)]))){
var statearr_8962_8977 = state_8941;
(statearr_8962_8977[(1)] = cljs.core.first.call(null,(state_8941[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8978 = state_8941;
state_8941 = G__8978;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_8941){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_8941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_8963 = f__7169__auto__.call(null);
(statearr_8963[(6)] = c__7168__auto___8965);

return statearr_8963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__8980 = arguments.length;
switch (G__8980) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___9047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_9018){
var state_val_9019 = (state_9018[(1)]);
if((state_val_9019 === (7))){
var inst_9014 = (state_9018[(2)]);
var state_9018__$1 = state_9018;
var statearr_9020_9048 = state_9018__$1;
(statearr_9020_9048[(2)] = inst_9014);

(statearr_9020_9048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (1))){
var inst_8981 = (new Array(n));
var inst_8982 = inst_8981;
var inst_8983 = (0);
var state_9018__$1 = (function (){var statearr_9021 = state_9018;
(statearr_9021[(7)] = inst_8982);

(statearr_9021[(8)] = inst_8983);

return statearr_9021;
})();
var statearr_9022_9049 = state_9018__$1;
(statearr_9022_9049[(2)] = null);

(statearr_9022_9049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (4))){
var inst_8986 = (state_9018[(9)]);
var inst_8986__$1 = (state_9018[(2)]);
var inst_8987 = (inst_8986__$1 == null);
var inst_8988 = cljs.core.not.call(null,inst_8987);
var state_9018__$1 = (function (){var statearr_9023 = state_9018;
(statearr_9023[(9)] = inst_8986__$1);

return statearr_9023;
})();
if(inst_8988){
var statearr_9024_9050 = state_9018__$1;
(statearr_9024_9050[(1)] = (5));

} else {
var statearr_9025_9051 = state_9018__$1;
(statearr_9025_9051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (15))){
var inst_9008 = (state_9018[(2)]);
var state_9018__$1 = state_9018;
var statearr_9026_9052 = state_9018__$1;
(statearr_9026_9052[(2)] = inst_9008);

(statearr_9026_9052[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (13))){
var state_9018__$1 = state_9018;
var statearr_9027_9053 = state_9018__$1;
(statearr_9027_9053[(2)] = null);

(statearr_9027_9053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (6))){
var inst_8983 = (state_9018[(8)]);
var inst_9004 = (inst_8983 > (0));
var state_9018__$1 = state_9018;
if(cljs.core.truth_(inst_9004)){
var statearr_9028_9054 = state_9018__$1;
(statearr_9028_9054[(1)] = (12));

} else {
var statearr_9029_9055 = state_9018__$1;
(statearr_9029_9055[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (3))){
var inst_9016 = (state_9018[(2)]);
var state_9018__$1 = state_9018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9018__$1,inst_9016);
} else {
if((state_val_9019 === (12))){
var inst_8982 = (state_9018[(7)]);
var inst_9006 = cljs.core.vec.call(null,inst_8982);
var state_9018__$1 = state_9018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9018__$1,(15),out,inst_9006);
} else {
if((state_val_9019 === (2))){
var state_9018__$1 = state_9018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9018__$1,(4),ch);
} else {
if((state_val_9019 === (11))){
var inst_8998 = (state_9018[(2)]);
var inst_8999 = (new Array(n));
var inst_8982 = inst_8999;
var inst_8983 = (0);
var state_9018__$1 = (function (){var statearr_9030 = state_9018;
(statearr_9030[(7)] = inst_8982);

(statearr_9030[(8)] = inst_8983);

(statearr_9030[(10)] = inst_8998);

return statearr_9030;
})();
var statearr_9031_9056 = state_9018__$1;
(statearr_9031_9056[(2)] = null);

(statearr_9031_9056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (9))){
var inst_8982 = (state_9018[(7)]);
var inst_8996 = cljs.core.vec.call(null,inst_8982);
var state_9018__$1 = state_9018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9018__$1,(11),out,inst_8996);
} else {
if((state_val_9019 === (5))){
var inst_8982 = (state_9018[(7)]);
var inst_8983 = (state_9018[(8)]);
var inst_8991 = (state_9018[(11)]);
var inst_8986 = (state_9018[(9)]);
var inst_8990 = (inst_8982[inst_8983] = inst_8986);
var inst_8991__$1 = (inst_8983 + (1));
var inst_8992 = (inst_8991__$1 < n);
var state_9018__$1 = (function (){var statearr_9032 = state_9018;
(statearr_9032[(12)] = inst_8990);

(statearr_9032[(11)] = inst_8991__$1);

return statearr_9032;
})();
if(cljs.core.truth_(inst_8992)){
var statearr_9033_9057 = state_9018__$1;
(statearr_9033_9057[(1)] = (8));

} else {
var statearr_9034_9058 = state_9018__$1;
(statearr_9034_9058[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (14))){
var inst_9011 = (state_9018[(2)]);
var inst_9012 = cljs.core.async.close_BANG_.call(null,out);
var state_9018__$1 = (function (){var statearr_9036 = state_9018;
(statearr_9036[(13)] = inst_9011);

return statearr_9036;
})();
var statearr_9037_9059 = state_9018__$1;
(statearr_9037_9059[(2)] = inst_9012);

(statearr_9037_9059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (10))){
var inst_9002 = (state_9018[(2)]);
var state_9018__$1 = state_9018;
var statearr_9038_9060 = state_9018__$1;
(statearr_9038_9060[(2)] = inst_9002);

(statearr_9038_9060[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9019 === (8))){
var inst_8982 = (state_9018[(7)]);
var inst_8991 = (state_9018[(11)]);
var tmp9035 = inst_8982;
var inst_8982__$1 = tmp9035;
var inst_8983 = inst_8991;
var state_9018__$1 = (function (){var statearr_9039 = state_9018;
(statearr_9039[(7)] = inst_8982__$1);

(statearr_9039[(8)] = inst_8983);

return statearr_9039;
})();
var statearr_9040_9061 = state_9018__$1;
(statearr_9040_9061[(2)] = null);

(statearr_9040_9061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_9041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9041[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_9041[(1)] = (1));

return statearr_9041;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_9018){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_9018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e9042){var ex__7098__auto__ = e9042;
var statearr_9043_9062 = state_9018;
(statearr_9043_9062[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_9018[(4)]))){
var statearr_9044_9063 = state_9018;
(statearr_9044_9063[(1)] = cljs.core.first.call(null,(state_9018[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9064 = state_9018;
state_9018 = G__9064;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_9018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_9018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_9045 = f__7169__auto__.call(null);
(statearr_9045[(6)] = c__7168__auto___9047);

return statearr_9045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__9066 = arguments.length;
switch (G__9066) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7168__auto___9137 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__7169__auto__ = (function (){var switch__7094__auto__ = (function (state_9108){
var state_val_9109 = (state_9108[(1)]);
if((state_val_9109 === (7))){
var inst_9104 = (state_9108[(2)]);
var state_9108__$1 = state_9108;
var statearr_9110_9138 = state_9108__$1;
(statearr_9110_9138[(2)] = inst_9104);

(statearr_9110_9138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (1))){
var inst_9067 = [];
var inst_9068 = inst_9067;
var inst_9069 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_9108__$1 = (function (){var statearr_9111 = state_9108;
(statearr_9111[(7)] = inst_9068);

(statearr_9111[(8)] = inst_9069);

return statearr_9111;
})();
var statearr_9112_9139 = state_9108__$1;
(statearr_9112_9139[(2)] = null);

(statearr_9112_9139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (4))){
var inst_9072 = (state_9108[(9)]);
var inst_9072__$1 = (state_9108[(2)]);
var inst_9073 = (inst_9072__$1 == null);
var inst_9074 = cljs.core.not.call(null,inst_9073);
var state_9108__$1 = (function (){var statearr_9113 = state_9108;
(statearr_9113[(9)] = inst_9072__$1);

return statearr_9113;
})();
if(inst_9074){
var statearr_9114_9140 = state_9108__$1;
(statearr_9114_9140[(1)] = (5));

} else {
var statearr_9115_9141 = state_9108__$1;
(statearr_9115_9141[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (15))){
var inst_9098 = (state_9108[(2)]);
var state_9108__$1 = state_9108;
var statearr_9116_9142 = state_9108__$1;
(statearr_9116_9142[(2)] = inst_9098);

(statearr_9116_9142[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (13))){
var state_9108__$1 = state_9108;
var statearr_9117_9143 = state_9108__$1;
(statearr_9117_9143[(2)] = null);

(statearr_9117_9143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (6))){
var inst_9068 = (state_9108[(7)]);
var inst_9093 = inst_9068.length;
var inst_9094 = (inst_9093 > (0));
var state_9108__$1 = state_9108;
if(cljs.core.truth_(inst_9094)){
var statearr_9118_9144 = state_9108__$1;
(statearr_9118_9144[(1)] = (12));

} else {
var statearr_9119_9145 = state_9108__$1;
(statearr_9119_9145[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (3))){
var inst_9106 = (state_9108[(2)]);
var state_9108__$1 = state_9108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9108__$1,inst_9106);
} else {
if((state_val_9109 === (12))){
var inst_9068 = (state_9108[(7)]);
var inst_9096 = cljs.core.vec.call(null,inst_9068);
var state_9108__$1 = state_9108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9108__$1,(15),out,inst_9096);
} else {
if((state_val_9109 === (2))){
var state_9108__$1 = state_9108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9108__$1,(4),ch);
} else {
if((state_val_9109 === (11))){
var inst_9076 = (state_9108[(10)]);
var inst_9072 = (state_9108[(9)]);
var inst_9086 = (state_9108[(2)]);
var inst_9087 = [];
var inst_9088 = inst_9087.push(inst_9072);
var inst_9068 = inst_9087;
var inst_9069 = inst_9076;
var state_9108__$1 = (function (){var statearr_9120 = state_9108;
(statearr_9120[(11)] = inst_9086);

(statearr_9120[(12)] = inst_9088);

(statearr_9120[(7)] = inst_9068);

(statearr_9120[(8)] = inst_9069);

return statearr_9120;
})();
var statearr_9121_9146 = state_9108__$1;
(statearr_9121_9146[(2)] = null);

(statearr_9121_9146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (9))){
var inst_9068 = (state_9108[(7)]);
var inst_9084 = cljs.core.vec.call(null,inst_9068);
var state_9108__$1 = state_9108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9108__$1,(11),out,inst_9084);
} else {
if((state_val_9109 === (5))){
var inst_9076 = (state_9108[(10)]);
var inst_9069 = (state_9108[(8)]);
var inst_9072 = (state_9108[(9)]);
var inst_9076__$1 = f.call(null,inst_9072);
var inst_9077 = cljs.core._EQ_.call(null,inst_9076__$1,inst_9069);
var inst_9078 = cljs.core.keyword_identical_QMARK_.call(null,inst_9069,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_9079 = ((inst_9077) || (inst_9078));
var state_9108__$1 = (function (){var statearr_9122 = state_9108;
(statearr_9122[(10)] = inst_9076__$1);

return statearr_9122;
})();
if(cljs.core.truth_(inst_9079)){
var statearr_9123_9147 = state_9108__$1;
(statearr_9123_9147[(1)] = (8));

} else {
var statearr_9124_9148 = state_9108__$1;
(statearr_9124_9148[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (14))){
var inst_9101 = (state_9108[(2)]);
var inst_9102 = cljs.core.async.close_BANG_.call(null,out);
var state_9108__$1 = (function (){var statearr_9126 = state_9108;
(statearr_9126[(13)] = inst_9101);

return statearr_9126;
})();
var statearr_9127_9149 = state_9108__$1;
(statearr_9127_9149[(2)] = inst_9102);

(statearr_9127_9149[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (10))){
var inst_9091 = (state_9108[(2)]);
var state_9108__$1 = state_9108;
var statearr_9128_9150 = state_9108__$1;
(statearr_9128_9150[(2)] = inst_9091);

(statearr_9128_9150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9109 === (8))){
var inst_9068 = (state_9108[(7)]);
var inst_9076 = (state_9108[(10)]);
var inst_9072 = (state_9108[(9)]);
var inst_9081 = inst_9068.push(inst_9072);
var tmp9125 = inst_9068;
var inst_9068__$1 = tmp9125;
var inst_9069 = inst_9076;
var state_9108__$1 = (function (){var statearr_9129 = state_9108;
(statearr_9129[(14)] = inst_9081);

(statearr_9129[(7)] = inst_9068__$1);

(statearr_9129[(8)] = inst_9069);

return statearr_9129;
})();
var statearr_9130_9151 = state_9108__$1;
(statearr_9130_9151[(2)] = null);

(statearr_9130_9151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__7095__auto__ = null;
var cljs$core$async$state_machine__7095__auto____0 = (function (){
var statearr_9131 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9131[(0)] = cljs$core$async$state_machine__7095__auto__);

(statearr_9131[(1)] = (1));

return statearr_9131;
});
var cljs$core$async$state_machine__7095__auto____1 = (function (state_9108){
while(true){
var ret_value__7096__auto__ = (function (){try{while(true){
var result__7097__auto__ = switch__7094__auto__.call(null,state_9108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7097__auto__;
}
break;
}
}catch (e9132){var ex__7098__auto__ = e9132;
var statearr_9133_9152 = state_9108;
(statearr_9133_9152[(2)] = ex__7098__auto__);


if(cljs.core.seq.call(null,(state_9108[(4)]))){
var statearr_9134_9153 = state_9108;
(statearr_9134_9153[(1)] = cljs.core.first.call(null,(state_9108[(4)])));

} else {
throw ex__7098__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7096__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9154 = state_9108;
state_9108 = G__9154;
continue;
} else {
return ret_value__7096__auto__;
}
break;
}
});
cljs$core$async$state_machine__7095__auto__ = function(state_9108){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7095__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7095__auto____1.call(this,state_9108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7095__auto____0;
cljs$core$async$state_machine__7095__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7095__auto____1;
return cljs$core$async$state_machine__7095__auto__;
})()
})();
var state__7170__auto__ = (function (){var statearr_9135 = f__7169__auto__.call(null);
(statearr_9135[(6)] = c__7168__auto___9137);

return statearr_9135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7170__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
