// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__1661){
var map__1662 = p__1661;
var map__1662__$1 = (((((!((map__1662 == null))))?(((((map__1662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1662):map__1662);
var m = map__1662__$1;
var n = cljs.core.get.call(null,map__1662__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__1662__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__1664_1696 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__1665_1697 = null;
var count__1666_1698 = (0);
var i__1667_1699 = (0);
while(true){
if((i__1667_1699 < count__1666_1698)){
var f_1700 = cljs.core._nth.call(null,chunk__1665_1697,i__1667_1699);
cljs.core.println.call(null,"  ",f_1700);


var G__1701 = seq__1664_1696;
var G__1702 = chunk__1665_1697;
var G__1703 = count__1666_1698;
var G__1704 = (i__1667_1699 + (1));
seq__1664_1696 = G__1701;
chunk__1665_1697 = G__1702;
count__1666_1698 = G__1703;
i__1667_1699 = G__1704;
continue;
} else {
var temp__5735__auto___1705 = cljs.core.seq.call(null,seq__1664_1696);
if(temp__5735__auto___1705){
var seq__1664_1706__$1 = temp__5735__auto___1705;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1664_1706__$1)){
var c__4556__auto___1707 = cljs.core.chunk_first.call(null,seq__1664_1706__$1);
var G__1708 = cljs.core.chunk_rest.call(null,seq__1664_1706__$1);
var G__1709 = c__4556__auto___1707;
var G__1710 = cljs.core.count.call(null,c__4556__auto___1707);
var G__1711 = (0);
seq__1664_1696 = G__1708;
chunk__1665_1697 = G__1709;
count__1666_1698 = G__1710;
i__1667_1699 = G__1711;
continue;
} else {
var f_1712 = cljs.core.first.call(null,seq__1664_1706__$1);
cljs.core.println.call(null,"  ",f_1712);


var G__1713 = cljs.core.next.call(null,seq__1664_1706__$1);
var G__1714 = null;
var G__1715 = (0);
var G__1716 = (0);
seq__1664_1696 = G__1713;
chunk__1665_1697 = G__1714;
count__1666_1698 = G__1715;
i__1667_1699 = G__1716;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_1717 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_1717);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_1717)))?cljs.core.second.call(null,arglists_1717):arglists_1717));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__1668_1718 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__1669_1719 = null;
var count__1670_1720 = (0);
var i__1671_1721 = (0);
while(true){
if((i__1671_1721 < count__1670_1720)){
var vec__1682_1722 = cljs.core._nth.call(null,chunk__1669_1719,i__1671_1721);
var name_1723 = cljs.core.nth.call(null,vec__1682_1722,(0),null);
var map__1685_1724 = cljs.core.nth.call(null,vec__1682_1722,(1),null);
var map__1685_1725__$1 = (((((!((map__1685_1724 == null))))?(((((map__1685_1724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1685_1724.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1685_1724):map__1685_1724);
var doc_1726 = cljs.core.get.call(null,map__1685_1725__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_1727 = cljs.core.get.call(null,map__1685_1725__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_1723);

cljs.core.println.call(null," ",arglists_1727);

if(cljs.core.truth_(doc_1726)){
cljs.core.println.call(null," ",doc_1726);
} else {
}


var G__1728 = seq__1668_1718;
var G__1729 = chunk__1669_1719;
var G__1730 = count__1670_1720;
var G__1731 = (i__1671_1721 + (1));
seq__1668_1718 = G__1728;
chunk__1669_1719 = G__1729;
count__1670_1720 = G__1730;
i__1671_1721 = G__1731;
continue;
} else {
var temp__5735__auto___1732 = cljs.core.seq.call(null,seq__1668_1718);
if(temp__5735__auto___1732){
var seq__1668_1733__$1 = temp__5735__auto___1732;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1668_1733__$1)){
var c__4556__auto___1734 = cljs.core.chunk_first.call(null,seq__1668_1733__$1);
var G__1735 = cljs.core.chunk_rest.call(null,seq__1668_1733__$1);
var G__1736 = c__4556__auto___1734;
var G__1737 = cljs.core.count.call(null,c__4556__auto___1734);
var G__1738 = (0);
seq__1668_1718 = G__1735;
chunk__1669_1719 = G__1736;
count__1670_1720 = G__1737;
i__1671_1721 = G__1738;
continue;
} else {
var vec__1687_1739 = cljs.core.first.call(null,seq__1668_1733__$1);
var name_1740 = cljs.core.nth.call(null,vec__1687_1739,(0),null);
var map__1690_1741 = cljs.core.nth.call(null,vec__1687_1739,(1),null);
var map__1690_1742__$1 = (((((!((map__1690_1741 == null))))?(((((map__1690_1741.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1690_1741.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1690_1741):map__1690_1741);
var doc_1743 = cljs.core.get.call(null,map__1690_1742__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_1744 = cljs.core.get.call(null,map__1690_1742__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_1740);

cljs.core.println.call(null," ",arglists_1744);

if(cljs.core.truth_(doc_1743)){
cljs.core.println.call(null," ",doc_1743);
} else {
}


var G__1745 = cljs.core.next.call(null,seq__1668_1733__$1);
var G__1746 = null;
var G__1747 = (0);
var G__1748 = (0);
seq__1668_1718 = G__1745;
chunk__1669_1719 = G__1746;
count__1670_1720 = G__1747;
i__1671_1721 = G__1748;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.call(null,"Spec");

var seq__1692 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__1693 = null;
var count__1694 = (0);
var i__1695 = (0);
while(true){
if((i__1695 < count__1694)){
var role = cljs.core._nth.call(null,chunk__1693,i__1695);
var temp__5735__auto___1749__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___1749__$1)){
var spec_1750 = temp__5735__auto___1749__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_1750));
} else {
}


var G__1751 = seq__1692;
var G__1752 = chunk__1693;
var G__1753 = count__1694;
var G__1754 = (i__1695 + (1));
seq__1692 = G__1751;
chunk__1693 = G__1752;
count__1694 = G__1753;
i__1695 = G__1754;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__1692);
if(temp__5735__auto____$1){
var seq__1692__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1692__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__1692__$1);
var G__1755 = cljs.core.chunk_rest.call(null,seq__1692__$1);
var G__1756 = c__4556__auto__;
var G__1757 = cljs.core.count.call(null,c__4556__auto__);
var G__1758 = (0);
seq__1692 = G__1755;
chunk__1693 = G__1756;
count__1694 = G__1757;
i__1695 = G__1758;
continue;
} else {
var role = cljs.core.first.call(null,seq__1692__$1);
var temp__5735__auto___1759__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5735__auto___1759__$2)){
var spec_1760 = temp__5735__auto___1759__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_1760));
} else {
}


var G__1761 = cljs.core.next.call(null,seq__1692__$1);
var G__1762 = null;
var G__1763 = (0);
var G__1764 = (0);
seq__1692 = G__1761;
chunk__1693 = G__1762;
count__1694 = G__1763;
i__1695 = G__1764;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__1765 = cljs.core.conj.call(null,via,t);
var G__1766 = cljs.core.ex_cause.call(null,t);
via = G__1765;
t = G__1766;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__1769 = datafied_throwable;
var map__1769__$1 = (((((!((map__1769 == null))))?(((((map__1769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1769):map__1769);
var via = cljs.core.get.call(null,map__1769__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__1769__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__1769__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__1770 = cljs.core.last.call(null,via);
var map__1770__$1 = (((((!((map__1770 == null))))?(((((map__1770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1770):map__1770);
var type = cljs.core.get.call(null,map__1770__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__1770__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__1770__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__1771 = data;
var map__1771__$1 = (((((!((map__1771 == null))))?(((((map__1771.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1771.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1771):map__1771);
var problems = cljs.core.get.call(null,map__1771__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__1771__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__1771__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__1772 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__1772__$1 = (((((!((map__1772 == null))))?(((((map__1772.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1772.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1772):map__1772);
var top_data = map__1772__$1;
var source = cljs.core.get.call(null,map__1772__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__1777 = phase;
var G__1777__$1 = (((G__1777 instanceof cljs.core.Keyword))?G__1777.fqn:null);
switch (G__1777__$1) {
case "read-source":
var map__1778 = data;
var map__1778__$1 = (((((!((map__1778 == null))))?(((((map__1778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1778.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1778):map__1778);
var line = cljs.core.get.call(null,map__1778__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__1778__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__1780 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__1780__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__1780,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__1780);
var G__1780__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__1780__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__1780__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__1780__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__1780__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__1781 = top_data;
var G__1781__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__1781,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__1781);
var G__1781__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__1781__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__1781__$1);
var G__1781__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__1781__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__1781__$2);
var G__1781__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__1781__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__1781__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__1781__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__1781__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__1782 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__1782,(0),null);
var method = cljs.core.nth.call(null,vec__1782,(1),null);
var file = cljs.core.nth.call(null,vec__1782,(2),null);
var line = cljs.core.nth.call(null,vec__1782,(3),null);
var G__1785 = top_data;
var G__1785__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__1785,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__1785);
var G__1785__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__1785__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__1785__$1);
var G__1785__$3 = (cljs.core.truth_((function (){var and__4115__auto__ = source__$1;
if(cljs.core.truth_(and__4115__auto__)){
return method;
} else {
return and__4115__auto__;
}
})())?cljs.core.assoc.call(null,G__1785__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__1785__$2);
var G__1785__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__1785__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__1785__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__1785__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__1785__$4;
}

break;
case "execution":
var vec__1786 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__1786,(0),null);
var method = cljs.core.nth.call(null,vec__1786,(1),null);
var file = cljs.core.nth.call(null,vec__1786,(2),null);
var line = cljs.core.nth.call(null,vec__1786,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__1768_SHARP_){
var or__4126__auto__ = (p1__1768_SHARP_ == null);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__1768_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return line;
}
})();
var G__1789 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__1789__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__1789,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__1789);
var G__1789__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__1789__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__1789__$1);
var G__1789__$3 = (cljs.core.truth_((function (){var or__4126__auto__ = fn;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = source__$1;
if(cljs.core.truth_(and__4115__auto__)){
return method;
} else {
return and__4115__auto__;
}
}
})())?cljs.core.assoc.call(null,G__1789__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4126__auto__ = fn;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__1789__$2);
var G__1789__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__1789__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__1789__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__1789__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__1789__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__1777__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__1793){
var map__1794 = p__1793;
var map__1794__$1 = (((((!((map__1794 == null))))?(((((map__1794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__1794.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__1794):map__1794);
var triage_data = map__1794__$1;
var phase = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__1794__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4126__auto__ = class$;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__1796 = phase;
var G__1796__$1 = (((G__1796 instanceof cljs.core.Keyword))?G__1796.fqn:null);
switch (G__1796__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__1797_1806 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__1798_1807 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__1799_1808 = true;
var _STAR_print_fn_STAR__temp_val__1800_1809 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__1799_1808);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__1800_1809);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__1791_SHARP_){
return cljs.core.dissoc.call(null,p1__1791_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__1798_1807);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__1797_1806);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__1801_1810 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__1802_1811 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__1803_1812 = true;
var _STAR_print_fn_STAR__temp_val__1804_1813 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__1803_1812);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__1804_1813);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__1792_SHARP_){
return cljs.core.dissoc.call(null,p1__1792_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__1802_1811);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__1801_1810);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__1796__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
