// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59397 = arguments.length;
switch (G__59397) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2490__auto___59578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_59504){
var state_val_59505 = (state_59504[(1)]);
if((state_val_59505 === (7))){
var inst_59411 = (state_59504[(7)]);
var inst_59416 = inst_59411.cljs$lang$protocol_mask$partition0$;
var inst_59417 = (inst_59416 & (64));
var inst_59418 = inst_59411.cljs$core$ISeq$;
var inst_59419 = (cljs.core.PROTOCOL_SENTINEL === inst_59418);
var inst_59420 = ((inst_59417) || (inst_59419));
var state_59504__$1 = state_59504;
if(cljs.core.truth_(inst_59420)){
var statearr_59506_59579 = state_59504__$1;
(statearr_59506_59579[(1)] = (10));

} else {
var statearr_59507_59580 = state_59504__$1;
(statearr_59507_59580[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (20))){
var state_59504__$1 = state_59504;
var statearr_59508_59581 = state_59504__$1;
(statearr_59508_59581[(2)] = null);

(statearr_59508_59581[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (27))){
var inst_59459 = (state_59504[(8)]);
var state_59504__$1 = state_59504;
if(cljs.core.truth_(inst_59459)){
var statearr_59509_59582 = state_59504__$1;
(statearr_59509_59582[(1)] = (29));

} else {
var statearr_59510_59583 = state_59504__$1;
(statearr_59510_59583[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (1))){
var state_59504__$1 = state_59504;
var statearr_59511_59584 = state_59504__$1;
(statearr_59511_59584[(2)] = null);

(statearr_59511_59584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (24))){
var inst_59435 = (state_59504[(9)]);
var inst_59449 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59435)," unknown."].join('');
var inst_59450 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59451 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59452 = cljs.core.PersistentHashMap.fromArrays(inst_59450,inst_59451);
var inst_59453 = cljs.core.ex_info.call(null,inst_59449,inst_59452);
var inst_59454 = (function(){throw inst_59453})();
var state_59504__$1 = state_59504;
var statearr_59512_59585 = state_59504__$1;
(statearr_59512_59585[(2)] = inst_59454);

(statearr_59512_59585[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (39))){
var inst_59481 = (state_59504[(2)]);
var inst_59482 = fluree.db.util.async.throw_err.call(null,inst_59481);
var state_59504__$1 = state_59504;
var statearr_59513_59586 = state_59504__$1;
(statearr_59513_59586[(2)] = inst_59482);

(statearr_59513_59586[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (46))){
var inst_59490 = (state_59504[(10)]);
var inst_59493 = (state_59504[(2)]);
var inst_59494 = fluree.db.util.async.throw_err.call(null,inst_59493);
var inst_59495 = cljs.core.assoc.call(null,inst_59490,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59494);
var state_59504__$1 = state_59504;
var statearr_59514_59587 = state_59504__$1;
(statearr_59514_59587[(2)] = inst_59495);

(statearr_59514_59587[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (4))){
var inst_59398 = (state_59504[(2)]);
var inst_59399 = cljs.core.async.put_BANG_.call(null,pc,inst_59398);
var inst_59400 = cljs.core.async.close_BANG_.call(null,pc);
var state_59504__$1 = (function (){var statearr_59515 = state_59504;
(statearr_59515[(11)] = inst_59399);

return statearr_59515;
})();
var statearr_59516_59588 = state_59504__$1;
(statearr_59516_59588[(2)] = inst_59400);

(statearr_59516_59588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (15))){
var inst_59435 = (state_59504[(9)]);
var inst_59432 = (state_59504[(2)]);
var inst_59433 = cljs.core.get.call(null,inst_59432,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59434 = cljs.core.get.call(null,inst_59432,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59435__$1 = cljs.core.get.call(null,inst_59432,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59436 = cljs.core.get.call(null,inst_59432,new cljs.core.Keyword(null,"block","block",664686210));
var state_59504__$1 = (function (){var statearr_59517 = state_59504;
(statearr_59517[(12)] = inst_59436);

(statearr_59517[(13)] = inst_59433);

(statearr_59517[(9)] = inst_59435__$1);

(statearr_59517[(14)] = inst_59434);

return statearr_59517;
})();
if(cljs.core.truth_(inst_59435__$1)){
var statearr_59518_59589 = state_59504__$1;
(statearr_59518_59589[(1)] = (16));

} else {
var statearr_59519_59590 = state_59504__$1;
(statearr_59519_59590[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (21))){
var inst_59433 = (state_59504[(13)]);
var inst_59459 = (state_59504[(2)]);
var state_59504__$1 = (function (){var statearr_59520 = state_59504;
(statearr_59520[(8)] = inst_59459);

return statearr_59520;
})();
if(cljs.core.truth_(inst_59433)){
var statearr_59521_59591 = state_59504__$1;
(statearr_59521_59591[(1)] = (26));

} else {
var statearr_59522_59592 = state_59504__$1;
(statearr_59522_59592[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (31))){
var inst_59469 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
var statearr_59523_59593 = state_59504__$1;
(statearr_59523_59593[(2)] = inst_59469);

(statearr_59523_59593[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (32))){
var inst_59465 = (state_59504[(2)]);
var inst_59466 = fluree.db.util.async.throw_err.call(null,inst_59465);
var state_59504__$1 = state_59504;
var statearr_59524_59594 = state_59504__$1;
(statearr_59524_59594[(2)] = inst_59466);

(statearr_59524_59594[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (40))){
var inst_59485 = (state_59504[(15)]);
var inst_59435 = (state_59504[(9)]);
var inst_59487 = cljs.core.assoc.call(null,inst_59485,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59435);
var state_59504__$1 = state_59504;
var statearr_59525_59595 = state_59504__$1;
(statearr_59525_59595[(2)] = inst_59487);

(statearr_59525_59595[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (33))){
var inst_59410 = (state_59504[(16)]);
var inst_59471 = (state_59504[(17)]);
var inst_59473 = fluree.db.permissions.permission_map.call(null,inst_59410,inst_59471,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59504__$1 = state_59504;
var statearr_59526_59596 = state_59504__$1;
(statearr_59526_59596[(2)] = inst_59473);

(statearr_59526_59596[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (13))){
var inst_59411 = (state_59504[(7)]);
var inst_59429 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59411);
var state_59504__$1 = state_59504;
var statearr_59527_59597 = state_59504__$1;
(statearr_59527_59597[(2)] = inst_59429);

(statearr_59527_59597[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (22))){
var inst_59446 = (state_59504[(18)]);
var inst_59445 = (state_59504[(2)]);
var inst_59446__$1 = fluree.db.util.async.throw_err.call(null,inst_59445);
var state_59504__$1 = (function (){var statearr_59528 = state_59504;
(statearr_59528[(18)] = inst_59446__$1);

return statearr_59528;
})();
if(cljs.core.truth_(inst_59446__$1)){
var statearr_59529_59598 = state_59504__$1;
(statearr_59529_59598[(1)] = (23));

} else {
var statearr_59530_59599 = state_59504__$1;
(statearr_59530_59599[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (36))){
var inst_59410 = (state_59504[(16)]);
var inst_59478 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59479 = fluree.db.time_travel.as_of_block.call(null,inst_59410,inst_59478);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59504__$1,(39),inst_59479);
} else {
if((state_val_59505 === (41))){
var inst_59485 = (state_59504[(15)]);
var state_59504__$1 = state_59504;
var statearr_59531_59600 = state_59504__$1;
(statearr_59531_59600[(2)] = inst_59485);

(statearr_59531_59600[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (43))){
var inst_59476 = (state_59504[(19)]);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59504__$1,(46),inst_59476);
} else {
if((state_val_59505 === (29))){
var inst_59459 = (state_59504[(8)]);
var inst_59410 = (state_59504[(16)]);
var inst_59463 = fluree.db.auth.roles.call(null,inst_59410,inst_59459);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59504__$1,(32),inst_59463);
} else {
if((state_val_59505 === (44))){
var inst_59490 = (state_59504[(10)]);
var state_59504__$1 = state_59504;
var statearr_59532_59601 = state_59504__$1;
(statearr_59532_59601[(2)] = inst_59490);

(statearr_59532_59601[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (6))){
var inst_59411 = (state_59504[(7)]);
var inst_59409 = (state_59504[(2)]);
var inst_59410 = fluree.db.util.async.throw_err.call(null,inst_59409);
var inst_59411__$1 = opts;
var inst_59413 = (inst_59411__$1 == null);
var inst_59414 = cljs.core.not.call(null,inst_59413);
var state_59504__$1 = (function (){var statearr_59533 = state_59504;
(statearr_59533[(7)] = inst_59411__$1);

(statearr_59533[(16)] = inst_59410);

return statearr_59533;
})();
if(inst_59414){
var statearr_59534_59602 = state_59504__$1;
(statearr_59534_59602[(1)] = (7));

} else {
var statearr_59535_59603 = state_59504__$1;
(statearr_59535_59603[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (28))){
var inst_59471 = (state_59504[(17)]);
var inst_59471__$1 = (state_59504[(2)]);
var state_59504__$1 = (function (){var statearr_59536 = state_59504;
(statearr_59536[(17)] = inst_59471__$1);

return statearr_59536;
})();
if(cljs.core.truth_(inst_59471__$1)){
var statearr_59537_59604 = state_59504__$1;
(statearr_59537_59604[(1)] = (33));

} else {
var statearr_59538_59605 = state_59504__$1;
(statearr_59538_59605[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (25))){
var inst_59456 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
var statearr_59539_59606 = state_59504__$1;
(statearr_59539_59606[(2)] = inst_59456);

(statearr_59539_59606[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (34))){
var state_59504__$1 = state_59504;
var statearr_59540_59607 = state_59504__$1;
(statearr_59540_59607[(2)] = null);

(statearr_59540_59607[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (17))){
var inst_59435 = (state_59504[(9)]);
var state_59504__$1 = state_59504;
var statearr_59541_59608 = state_59504__$1;
(statearr_59541_59608[(2)] = inst_59435);

(statearr_59541_59608[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (3))){
var inst_59502 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59504__$1,inst_59502);
} else {
if((state_val_59505 === (12))){
var inst_59424 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
var statearr_59542_59609 = state_59504__$1;
(statearr_59542_59609[(2)] = inst_59424);

(statearr_59542_59609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (2))){
var _ = (function (){var statearr_59543 = state_59504;
(statearr_59543[(4)] = cljs.core.cons.call(null,(5),(state_59504[(4)])));

return statearr_59543;
})();
var inst_59407 = fluree.db.session.db.call(null,conn,ledger,null);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59504__$1,(6),inst_59407);
} else {
if((state_val_59505 === (23))){
var inst_59446 = (state_59504[(18)]);
var state_59504__$1 = state_59504;
var statearr_59544_59610 = state_59504__$1;
(statearr_59544_59610[(2)] = inst_59446);

(statearr_59544_59610[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (35))){
var inst_59436 = (state_59504[(12)]);
var inst_59476 = (state_59504[(2)]);
var state_59504__$1 = (function (){var statearr_59545 = state_59504;
(statearr_59545[(19)] = inst_59476);

return statearr_59545;
})();
if(cljs.core.truth_(inst_59436)){
var statearr_59546_59611 = state_59504__$1;
(statearr_59546_59611[(1)] = (36));

} else {
var statearr_59547_59612 = state_59504__$1;
(statearr_59547_59612[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (19))){
var inst_59410 = (state_59504[(16)]);
var inst_59435 = (state_59504[(9)]);
var inst_59443 = fluree.db.dbproto._subid.call(null,inst_59410,inst_59435);
var state_59504__$1 = state_59504;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59504__$1,(22),inst_59443);
} else {
if((state_val_59505 === (11))){
var state_59504__$1 = state_59504;
var statearr_59549_59613 = state_59504__$1;
(statearr_59549_59613[(2)] = false);

(statearr_59549_59613[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (9))){
var inst_59427 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
if(cljs.core.truth_(inst_59427)){
var statearr_59550_59614 = state_59504__$1;
(statearr_59550_59614[(1)] = (13));

} else {
var statearr_59551_59615 = state_59504__$1;
(statearr_59551_59615[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (5))){
var _ = (function (){var statearr_59552 = state_59504;
(statearr_59552[(4)] = cljs.core.rest.call(null,(state_59504[(4)])));

return statearr_59552;
})();
var state_59504__$1 = state_59504;
var ex59548 = (state_59504__$1[(2)]);
var statearr_59553_59616 = state_59504__$1;
(statearr_59553_59616[(5)] = ex59548);


if((ex59548 instanceof java.lang.Exception)){
var statearr_59554_59617 = state_59504__$1;
(statearr_59554_59617[(1)] = (4));

(statearr_59554_59617[(5)] = null);

} else {
throw ex59548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (14))){
var inst_59411 = (state_59504[(7)]);
var state_59504__$1 = state_59504;
var statearr_59555_59618 = state_59504__$1;
(statearr_59555_59618[(2)] = inst_59411);

(statearr_59555_59618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (45))){
var inst_59498 = (state_59504[(2)]);
var inst_59499 = cljs.core.async.put_BANG_.call(null,pc,inst_59498);
var _ = (function (){var statearr_59556 = state_59504;
(statearr_59556[(4)] = cljs.core.rest.call(null,(state_59504[(4)])));

return statearr_59556;
})();
var state_59504__$1 = state_59504;
var statearr_59557_59619 = state_59504__$1;
(statearr_59557_59619[(2)] = inst_59499);

(statearr_59557_59619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (26))){
var inst_59433 = (state_59504[(13)]);
var state_59504__$1 = state_59504;
var statearr_59558_59620 = state_59504__$1;
(statearr_59558_59620[(2)] = inst_59433);

(statearr_59558_59620[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (16))){
var inst_59435 = (state_59504[(9)]);
var inst_59438 = cljs.core.not_EQ_.call(null,(0),inst_59435);
var state_59504__$1 = state_59504;
var statearr_59559_59621 = state_59504__$1;
(statearr_59559_59621[(2)] = inst_59438);

(statearr_59559_59621[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (38))){
var inst_59435 = (state_59504[(9)]);
var inst_59485 = (state_59504[(2)]);
var state_59504__$1 = (function (){var statearr_59560 = state_59504;
(statearr_59560[(15)] = inst_59485);

return statearr_59560;
})();
if(cljs.core.truth_(inst_59435)){
var statearr_59561_59622 = state_59504__$1;
(statearr_59561_59622[(1)] = (40));

} else {
var statearr_59562_59623 = state_59504__$1;
(statearr_59562_59623[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (30))){
var state_59504__$1 = state_59504;
var statearr_59563_59624 = state_59504__$1;
(statearr_59563_59624[(2)] = null);

(statearr_59563_59624[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (10))){
var state_59504__$1 = state_59504;
var statearr_59564_59625 = state_59504__$1;
(statearr_59564_59625[(2)] = true);

(statearr_59564_59625[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (18))){
var inst_59441 = (state_59504[(2)]);
var state_59504__$1 = state_59504;
if(cljs.core.truth_(inst_59441)){
var statearr_59565_59626 = state_59504__$1;
(statearr_59565_59626[(1)] = (19));

} else {
var statearr_59566_59627 = state_59504__$1;
(statearr_59566_59627[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (42))){
var inst_59471 = (state_59504[(17)]);
var inst_59490 = (state_59504[(2)]);
var state_59504__$1 = (function (){var statearr_59567 = state_59504;
(statearr_59567[(10)] = inst_59490);

return statearr_59567;
})();
if(cljs.core.truth_(inst_59471)){
var statearr_59568_59628 = state_59504__$1;
(statearr_59568_59628[(1)] = (43));

} else {
var statearr_59569_59629 = state_59504__$1;
(statearr_59569_59629[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (37))){
var inst_59410 = (state_59504[(16)]);
var state_59504__$1 = state_59504;
var statearr_59570_59630 = state_59504__$1;
(statearr_59570_59630[(2)] = inst_59410);

(statearr_59570_59630[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59505 === (8))){
var state_59504__$1 = state_59504;
var statearr_59571_59631 = state_59504__$1;
(statearr_59571_59631[(2)] = false);

(statearr_59571_59631[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2468__auto__ = null;
var fluree$db$api$query$state_machine__2468__auto____0 = (function (){
var statearr_59572 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59572[(0)] = fluree$db$api$query$state_machine__2468__auto__);

(statearr_59572[(1)] = (1));

return statearr_59572;
});
var fluree$db$api$query$state_machine__2468__auto____1 = (function (state_59504){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_59504);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e59573){var ex__2471__auto__ = e59573;
var statearr_59574_59632 = state_59504;
(statearr_59574_59632[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_59504[(4)]))){
var statearr_59575_59633 = state_59504;
(statearr_59575_59633[(1)] = cljs.core.first.call(null,(state_59504[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59634 = state_59504;
state_59504 = G__59634;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2468__auto__ = function(state_59504){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2468__auto____1.call(this,state_59504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2468__auto____0;
fluree$db$api$query$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2468__auto____1;
return fluree$db$api$query$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_59576 = f__2491__auto__.call(null);
(statearr_59576[(6)] = c__2490__auto___59578);

return statearr_59576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_59772){
var state_val_59773 = (state_59772[(1)]);
if((state_val_59773 === (7))){
var inst_59655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59656 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59657 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59658 = [inst_59656,inst_59657];
var inst_59659 = (new cljs.core.PersistentVector(null,2,(5),inst_59655,inst_59658,null));
var state_59772__$1 = state_59772;
var statearr_59774_59840 = state_59772__$1;
(statearr_59774_59840[(2)] = inst_59659);

(statearr_59774_59840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (20))){
var inst_59685 = (state_59772[(7)]);
var state_59772__$1 = state_59772;
var statearr_59775_59841 = state_59772__$1;
(statearr_59775_59841[(2)] = inst_59685);

(statearr_59775_59841[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (27))){
var state_59772__$1 = state_59772;
var statearr_59776_59842 = state_59772__$1;
(statearr_59776_59842[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (1))){
var state_59772__$1 = state_59772;
var statearr_59778_59843 = state_59772__$1;
(statearr_59778_59843[(2)] = null);

(statearr_59778_59843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (24))){
var inst_59684 = (state_59772[(8)]);
var state_59772__$1 = state_59772;
if(cljs.core.truth_(inst_59684)){
var statearr_59779_59844 = state_59772__$1;
(statearr_59779_59844[(1)] = (26));

} else {
var statearr_59780_59845 = state_59772__$1;
(statearr_59780_59845[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (39))){
var inst_59759 = (state_59772[(9)]);
var state_59772__$1 = state_59772;
var statearr_59781_59846 = state_59772__$1;
(statearr_59781_59846[(2)] = inst_59759);

(statearr_59781_59846[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (4))){
var inst_59635 = (state_59772[(2)]);
var state_59772__$1 = state_59772;
var statearr_59782_59847 = state_59772__$1;
(statearr_59782_59847[(2)] = inst_59635);

(statearr_59782_59847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (15))){
var inst_59669 = (state_59772[(10)]);
var inst_59664 = (state_59772[(11)]);
var inst_59678 = (state_59772[(2)]);
var inst_59679 = [inst_59669,inst_59678];
var inst_59680 = (new cljs.core.PersistentVector(null,2,(5),inst_59664,inst_59679,null));
var state_59772__$1 = state_59772;
var statearr_59783_59848 = state_59772__$1;
(statearr_59783_59848[(2)] = inst_59680);

(statearr_59783_59848[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (21))){
var inst_59684 = (state_59772[(8)]);
var state_59772__$1 = state_59772;
var statearr_59784_59849 = state_59772__$1;
(statearr_59784_59849[(2)] = inst_59684);

(statearr_59784_59849[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (31))){
var inst_59725 = (state_59772[(2)]);
var state_59772__$1 = state_59772;
var statearr_59785_59850 = state_59772__$1;
(statearr_59785_59850[(2)] = inst_59725);

(statearr_59785_59850[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (32))){
var inst_59661 = (state_59772[(12)]);
var inst_59737 = cljs.core.pr_str.call(null,inst_59661);
var inst_59738 = ["Invalid block range provided: ",inst_59737].join('');
var inst_59739 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59740 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59741 = cljs.core.PersistentHashMap.fromArrays(inst_59739,inst_59740);
var inst_59742 = cljs.core.ex_info.call(null,inst_59738,inst_59741);
var inst_59743 = (function(){throw inst_59742})();
var state_59772__$1 = state_59772;
var statearr_59786_59851 = state_59772__$1;
(statearr_59786_59851[(2)] = inst_59743);

(statearr_59786_59851[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (40))){
var inst_59758 = (state_59772[(13)]);
var inst_59764 = (state_59772[(2)]);
var inst_59765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59766 = [inst_59758,inst_59764];
var inst_59767 = (new cljs.core.PersistentVector(null,2,(5),inst_59765,inst_59766,null));
var _ = (function (){var statearr_59787 = state_59772;
(statearr_59787[(4)] = cljs.core.rest.call(null,(state_59772[(4)])));

return statearr_59787;
})();
var state_59772__$1 = state_59772;
var statearr_59788_59852 = state_59772__$1;
(statearr_59788_59852[(2)] = inst_59767);

(statearr_59788_59852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (33))){
var state_59772__$1 = state_59772;
var statearr_59789_59853 = state_59772__$1;
(statearr_59789_59853[(2)] = null);

(statearr_59789_59853[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (13))){
var inst_59670 = (state_59772[(14)]);
var inst_59672 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59670);
var state_59772__$1 = state_59772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59772__$1,(16),inst_59672);
} else {
if((state_val_59773 === (22))){
var inst_59703 = (state_59772[(2)]);
var state_59772__$1 = state_59772;
if(cljs.core.truth_(inst_59703)){
var statearr_59790_59854 = state_59772__$1;
(statearr_59790_59854[(1)] = (23));

} else {
var statearr_59791_59855 = state_59772__$1;
(statearr_59791_59855[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (36))){
var inst_59731 = (state_59772[(15)]);
var inst_59730 = (state_59772[(16)]);
var inst_59753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59754 = [inst_59730,inst_59731];
var inst_59755 = (new cljs.core.PersistentVector(null,2,(5),inst_59753,inst_59754,null));
var state_59772__$1 = state_59772;
var statearr_59792_59856 = state_59772__$1;
(statearr_59792_59856[(2)] = inst_59755);

(statearr_59792_59856[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (29))){
var inst_59661 = (state_59772[(12)]);
var inst_59716 = cljs.core.pr_str.call(null,inst_59661);
var inst_59717 = ["Invalid block range provided: ",inst_59716].join('');
var inst_59718 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59719 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59720 = cljs.core.PersistentHashMap.fromArrays(inst_59718,inst_59719);
var inst_59721 = cljs.core.ex_info.call(null,inst_59717,inst_59720);
var inst_59722 = (function(){throw inst_59721})();
var state_59772__$1 = state_59772;
var statearr_59793_59857 = state_59772__$1;
(statearr_59793_59857[(2)] = inst_59722);

(statearr_59793_59857[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (6))){
var inst_59653 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59772__$1 = state_59772;
var statearr_59794_59858 = state_59772__$1;
(statearr_59794_59858[(2)] = inst_59653);

(statearr_59794_59858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (28))){
var inst_59727 = (state_59772[(2)]);
var state_59772__$1 = state_59772;
var statearr_59795_59859 = state_59772__$1;
(statearr_59795_59859[(2)] = inst_59727);

(statearr_59795_59859[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (25))){
var inst_59731 = (state_59772[(15)]);
var inst_59730 = (state_59772[(16)]);
var inst_59729 = (state_59772[(2)]);
var inst_59730__$1 = cljs.core.nth.call(null,inst_59729,(0),null);
var inst_59731__$1 = cljs.core.nth.call(null,inst_59729,(1),null);
var inst_59732 = cljs.core.pos_int_QMARK_.call(null,inst_59730__$1);
var inst_59733 = cljs.core.pos_int_QMARK_.call(null,inst_59731__$1);
var inst_59734 = ((inst_59732) && (inst_59733));
var inst_59735 = cljs.core.not.call(null,inst_59734);
var state_59772__$1 = (function (){var statearr_59796 = state_59772;
(statearr_59796[(15)] = inst_59731__$1);

(statearr_59796[(16)] = inst_59730__$1);

return statearr_59796;
})();
if(inst_59735){
var statearr_59797_59860 = state_59772__$1;
(statearr_59797_59860[(1)] = (32));

} else {
var statearr_59798_59861 = state_59772__$1;
(statearr_59798_59861[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (34))){
var inst_59731 = (state_59772[(15)]);
var inst_59730 = (state_59772[(16)]);
var inst_59746 = (state_59772[(2)]);
var inst_59747 = (inst_59731 < inst_59730);
var state_59772__$1 = (function (){var statearr_59799 = state_59772;
(statearr_59799[(17)] = inst_59746);

return statearr_59799;
})();
if(cljs.core.truth_(inst_59747)){
var statearr_59800_59862 = state_59772__$1;
(statearr_59800_59862[(1)] = (35));

} else {
var statearr_59801_59863 = state_59772__$1;
(statearr_59801_59863[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (17))){
var inst_59684 = (state_59772[(8)]);
var inst_59686 = (state_59772[(18)]);
var inst_59689 = cljs.core.pr_str.call(null,inst_59684);
var inst_59690 = cljs.core.pr_str.call(null,inst_59686);
var inst_59691 = ["Start block is out of range for this ledger. Start block provided: ",inst_59689,". Database block: ",inst_59690].join('');
var inst_59692 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59693 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59694 = cljs.core.PersistentHashMap.fromArrays(inst_59692,inst_59693);
var inst_59695 = cljs.core.ex_info.call(null,inst_59691,inst_59694);
var inst_59696 = (function(){throw inst_59695})();
var state_59772__$1 = state_59772;
var statearr_59802_59864 = state_59772__$1;
(statearr_59802_59864[(2)] = inst_59696);

(statearr_59802_59864[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (3))){
var inst_59770 = (state_59772[(2)]);
var state_59772__$1 = state_59772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59772__$1,inst_59770);
} else {
if((state_val_59773 === (12))){
var inst_59670 = (state_59772[(14)]);
var inst_59661 = (state_59772[(12)]);
var inst_59668 = (state_59772[(2)]);
var inst_59669 = fluree.db.util.async.throw_err.call(null,inst_59668);
var inst_59670__$1 = cljs.core.second.call(null,inst_59661);
var state_59772__$1 = (function (){var statearr_59803 = state_59772;
(statearr_59803[(14)] = inst_59670__$1);

(statearr_59803[(10)] = inst_59669);

return statearr_59803;
})();
if(cljs.core.truth_(inst_59670__$1)){
var statearr_59804_59865 = state_59772__$1;
(statearr_59804_59865[(1)] = (13));

} else {
var statearr_59805_59866 = state_59772__$1;
(statearr_59805_59866[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (2))){
var _ = (function (){var statearr_59806 = state_59772;
(statearr_59806[(4)] = cljs.core.cons.call(null,(5),(state_59772[(4)])));

return statearr_59806;
})();
var inst_59650 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59651 = cljs.core.sequential_QMARK_.call(null,inst_59650);
var state_59772__$1 = state_59772;
if(inst_59651){
var statearr_59807_59867 = state_59772__$1;
(statearr_59807_59867[(1)] = (6));

} else {
var statearr_59808_59868 = state_59772__$1;
(statearr_59808_59868[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (23))){
var inst_59685 = (state_59772[(7)]);
var inst_59684 = (state_59772[(8)]);
var inst_59705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59706 = [inst_59684,inst_59685];
var inst_59707 = (new cljs.core.PersistentVector(null,2,(5),inst_59705,inst_59706,null));
var state_59772__$1 = state_59772;
var statearr_59809_59869 = state_59772__$1;
(statearr_59809_59869[(2)] = inst_59707);

(statearr_59809_59869[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (35))){
var inst_59731 = (state_59772[(15)]);
var inst_59730 = (state_59772[(16)]);
var inst_59749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59750 = [inst_59731,inst_59730];
var inst_59751 = (new cljs.core.PersistentVector(null,2,(5),inst_59749,inst_59750,null));
var state_59772__$1 = state_59772;
var statearr_59810_59870 = state_59772__$1;
(statearr_59810_59870[(2)] = inst_59751);

(statearr_59810_59870[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (19))){
var inst_59684 = (state_59772[(8)]);
var inst_59699 = (state_59772[(2)]);
var state_59772__$1 = (function (){var statearr_59811 = state_59772;
(statearr_59811[(19)] = inst_59699);

return statearr_59811;
})();
if(cljs.core.truth_(inst_59684)){
var statearr_59812_59871 = state_59772__$1;
(statearr_59812_59871[(1)] = (20));

} else {
var statearr_59813_59872 = state_59772__$1;
(statearr_59813_59872[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (11))){
var inst_59684 = (state_59772[(8)]);
var inst_59686 = (state_59772[(18)]);
var inst_59683 = (state_59772[(2)]);
var inst_59684__$1 = cljs.core.nth.call(null,inst_59683,(0),null);
var inst_59685 = cljs.core.nth.call(null,inst_59683,(1),null);
var inst_59686__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59687 = (inst_59684__$1 > inst_59686__$1);
var state_59772__$1 = (function (){var statearr_59815 = state_59772;
(statearr_59815[(7)] = inst_59685);

(statearr_59815[(8)] = inst_59684__$1);

(statearr_59815[(18)] = inst_59686__$1);

return statearr_59815;
})();
if(cljs.core.truth_(inst_59687)){
var statearr_59816_59873 = state_59772__$1;
(statearr_59816_59873[(1)] = (17));

} else {
var statearr_59817_59874 = state_59772__$1;
(statearr_59817_59874[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (9))){
var inst_59661 = (state_59772[(12)]);
var inst_59664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59665 = cljs.core.first.call(null,inst_59661);
var inst_59666 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_59665);
var state_59772__$1 = (function (){var statearr_59818 = state_59772;
(statearr_59818[(11)] = inst_59664);

return statearr_59818;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59772__$1,(12),inst_59666);
} else {
if((state_val_59773 === (5))){
var _ = (function (){var statearr_59819 = state_59772;
(statearr_59819[(4)] = cljs.core.rest.call(null,(state_59772[(4)])));

return statearr_59819;
})();
var state_59772__$1 = state_59772;
var ex59814 = (state_59772__$1[(2)]);
var statearr_59820_59875 = state_59772__$1;
(statearr_59820_59875[(5)] = ex59814);


if((ex59814 instanceof Error)){
var statearr_59821_59876 = state_59772__$1;
(statearr_59821_59876[(1)] = (4));

(statearr_59821_59876[(5)] = null);

} else {
throw ex59814;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (14))){
var state_59772__$1 = state_59772;
var statearr_59822_59877 = state_59772__$1;
(statearr_59822_59877[(2)] = null);

(statearr_59822_59877[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (26))){
var inst_59684 = (state_59772[(8)]);
var inst_59710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59711 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59712 = [inst_59684,inst_59711];
var inst_59713 = (new cljs.core.PersistentVector(null,2,(5),inst_59710,inst_59712,null));
var state_59772__$1 = state_59772;
var statearr_59823_59878 = state_59772__$1;
(statearr_59823_59878[(2)] = inst_59713);

(statearr_59823_59878[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (16))){
var inst_59674 = (state_59772[(2)]);
var inst_59675 = fluree.db.util.async.throw_err.call(null,inst_59674);
var state_59772__$1 = state_59772;
var statearr_59824_59879 = state_59772__$1;
(statearr_59824_59879[(2)] = inst_59675);

(statearr_59824_59879[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (38))){
var inst_59686 = (state_59772[(18)]);
var state_59772__$1 = state_59772;
var statearr_59825_59880 = state_59772__$1;
(statearr_59825_59880[(2)] = inst_59686);

(statearr_59825_59880[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (30))){
var state_59772__$1 = state_59772;
var statearr_59826_59881 = state_59772__$1;
(statearr_59826_59881[(2)] = null);

(statearr_59826_59881[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (10))){
var inst_59661 = (state_59772[(12)]);
var state_59772__$1 = state_59772;
var statearr_59827_59882 = state_59772__$1;
(statearr_59827_59882[(2)] = inst_59661);

(statearr_59827_59882[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (18))){
var state_59772__$1 = state_59772;
var statearr_59828_59883 = state_59772__$1;
(statearr_59828_59883[(2)] = null);

(statearr_59828_59883[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (37))){
var inst_59759 = (state_59772[(9)]);
var inst_59686 = (state_59772[(18)]);
var inst_59757 = (state_59772[(2)]);
var inst_59758 = cljs.core.nth.call(null,inst_59757,(0),null);
var inst_59759__$1 = cljs.core.nth.call(null,inst_59757,(1),null);
var inst_59760 = (inst_59759__$1 > inst_59686);
var state_59772__$1 = (function (){var statearr_59829 = state_59772;
(statearr_59829[(13)] = inst_59758);

(statearr_59829[(9)] = inst_59759__$1);

return statearr_59829;
})();
if(cljs.core.truth_(inst_59760)){
var statearr_59830_59884 = state_59772__$1;
(statearr_59830_59884[(1)] = (38));

} else {
var statearr_59831_59885 = state_59772__$1;
(statearr_59831_59885[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59773 === (8))){
var inst_59661 = (state_59772[(12)]);
var inst_59661__$1 = (state_59772[(2)]);
var inst_59662 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_59661__$1);
var state_59772__$1 = (function (){var statearr_59832 = state_59772;
(statearr_59832[(12)] = inst_59661__$1);

return statearr_59832;
})();
if(cljs.core.truth_(inst_59662)){
var statearr_59833_59886 = state_59772__$1;
(statearr_59833_59886[(1)] = (9));

} else {
var statearr_59834_59887 = state_59772__$1;
(statearr_59834_59887[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____0 = (function (){
var statearr_59835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59835[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__);

(statearr_59835[(1)] = (1));

return statearr_59835;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____1 = (function (state_59772){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_59772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e59836){var ex__2471__auto__ = e59836;
var statearr_59837_59888 = state_59772;
(statearr_59837_59888[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_59772[(4)]))){
var statearr_59838_59889 = state_59772;
(statearr_59838_59889[(1)] = cljs.core.first.call(null,(state_59772[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59890 = state_59772;
state_59772 = G__59890;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__ = function(state_59772){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____1.call(this,state_59772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_59839 = f__2491__auto__.call(null);
(statearr_59839[(6)] = c__2490__auto__);

return statearr_59839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60040){
var state_val_60041 = (state_60040[(1)]);
if((state_val_60041 === (7))){
var inst_59952 = (state_60040[(2)]);
var inst_59953 = cljs.core.nth.call(null,inst_59952,(0),null);
var inst_59954 = cljs.core.nth.call(null,inst_59952,(1),null);
var inst_59962 = cljs.core.vals.call(null,inst_59954);
var inst_59963 = cljs.core.seq.call(null,inst_59962);
var inst_59964 = cljs.core.first.call(null,inst_59963);
var inst_59965 = cljs.core.next.call(null,inst_59963);
var inst_59966 = cljs.core.PersistentVector.EMPTY;
var inst_59967 = inst_59962;
var inst_59968 = inst_59966;
var state_60040__$1 = (function (){var statearr_60042 = state_60040;
(statearr_60042[(7)] = inst_59964);

(statearr_60042[(8)] = inst_59967);

(statearr_60042[(9)] = inst_59953);

(statearr_60042[(10)] = inst_59968);

(statearr_60042[(11)] = inst_59965);

return statearr_60042;
})();
var statearr_60043_60096 = state_60040__$1;
(statearr_60043_60096[(2)] = null);

(statearr_60043_60096[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (20))){
var inst_59974 = (state_60040[(12)]);
var inst_59979 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59980 = cljs.core.PersistentHashMap.EMPTY;
var inst_59981 = [true,inst_59980];
var inst_59982 = cljs.core.PersistentHashMap.fromArrays(inst_59979,inst_59981);
var inst_59983 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_59982,inst_59974);
var state_60040__$1 = state_60040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60040__$1,(22),inst_59983);
} else {
if((state_val_60041 === (27))){
var inst_60028 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
var statearr_60044_60097 = state_60040__$1;
(statearr_60044_60097[(2)] = inst_60028);

(statearr_60044_60097[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (1))){
var state_60040__$1 = state_60040;
var statearr_60045_60098 = state_60040__$1;
(statearr_60045_60098[(2)] = null);

(statearr_60045_60098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (24))){
var inst_59992 = (state_60040[(13)]);
var inst_60030 = (state_60040[(2)]);
var inst_60031 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60032 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60033 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60034 = [inst_60032,inst_60033,inst_59992,inst_60030];
var inst_60035 = cljs.core.PersistentHashMap.fromArrays(inst_60031,inst_60034);
var _ = (function (){var statearr_60047 = state_60040;
(statearr_60047[(4)] = cljs.core.rest.call(null,(state_60040[(4)])));

return statearr_60047;
})();
var state_60040__$1 = state_60040;
var statearr_60048_60099 = state_60040__$1;
(statearr_60048_60099[(2)] = inst_60035);

(statearr_60048_60099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (4))){
var inst_59893 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
var statearr_60049_60100 = state_60040__$1;
(statearr_60049_60100[(2)] = inst_59893);

(statearr_60049_60100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (15))){
var inst_59912 = (state_60040[(14)]);
var inst_59938 = (state_60040[(15)]);
var inst_59911 = (state_60040[(16)]);
var inst_59915 = (state_60040[(17)]);
var inst_59917 = (state_60040[(18)]);
var inst_59933 = (state_60040[(19)]);
var inst_59909 = (state_60040[(20)]);
var inst_59923 = (state_60040[(21)]);
var inst_59916 = (state_60040[(22)]);
var inst_59931 = (state_60040[(23)]);
var inst_59924 = (state_60040[(24)]);
var inst_59944 = (function (){var subject = inst_59931;
var flake = inst_59923;
var seq__59920 = inst_59924;
var seq__59907 = inst_59912;
var r = inst_59924;
var asserted_subjects = inst_59916;
var first__59921 = inst_59923;
var flake_SINGLEQUOTE_ = inst_59938;
var retracted_subjects = inst_59917;
var first__59908 = inst_59911;
var G__59905 = inst_59915;
var vec__59906 = inst_59909;
var asserted_QMARK_ = inst_59933;
var vec__59919 = inst_59915;
return (function (p1__59892_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59892_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59945 = cljs.core.update.call(null,inst_59917,inst_59931,inst_59944);
var tmp60046 = inst_59916;
var inst_59915__$1 = inst_59924;
var inst_59916__$1 = tmp60046;
var inst_59917__$1 = inst_59945;
var state_60040__$1 = (function (){var statearr_60050 = state_60040;
(statearr_60050[(17)] = inst_59915__$1);

(statearr_60050[(18)] = inst_59917__$1);

(statearr_60050[(22)] = inst_59916__$1);

return statearr_60050;
})();
var statearr_60051_60101 = state_60040__$1;
(statearr_60051_60101[(2)] = null);

(statearr_60051_60101[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (21))){
var inst_59990 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
var statearr_60052_60102 = state_60040__$1;
(statearr_60052_60102[(2)] = inst_59990);

(statearr_60052_60102[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (13))){
var inst_59933 = (state_60040[(19)]);
var inst_59938 = (state_60040[(2)]);
var state_60040__$1 = (function (){var statearr_60053 = state_60040;
(statearr_60053[(15)] = inst_59938);

return statearr_60053;
})();
if(cljs.core.truth_(inst_59933)){
var statearr_60054_60103 = state_60040__$1;
(statearr_60054_60103[(1)] = (14));

} else {
var statearr_60055_60104 = state_60040__$1;
(statearr_60055_60104[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (22))){
var inst_59975 = (state_60040[(25)]);
var inst_59968 = (state_60040[(10)]);
var inst_59985 = (state_60040[(2)]);
var inst_59986 = fluree.db.util.async.throw_err.call(null,inst_59985);
var inst_59987 = cljs.core.conj.call(null,inst_59968,inst_59986);
var inst_59967 = inst_59975;
var inst_59968__$1 = inst_59987;
var state_60040__$1 = (function (){var statearr_60056 = state_60040;
(statearr_60056[(8)] = inst_59967);

(statearr_60056[(10)] = inst_59968__$1);

return statearr_60056;
})();
var statearr_60057_60105 = state_60040__$1;
(statearr_60057_60105[(2)] = null);

(statearr_60057_60105[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (6))){
var inst_59915 = (state_60040[(17)]);
var inst_59923 = (state_60040[(21)]);
var inst_59922 = cljs.core.seq.call(null,inst_59915);
var inst_59923__$1 = cljs.core.first.call(null,inst_59922);
var inst_59924 = cljs.core.next.call(null,inst_59922);
var inst_59925 = cljs.core.not.call(null,inst_59923__$1);
var state_60040__$1 = (function (){var statearr_60058 = state_60040;
(statearr_60058[(21)] = inst_59923__$1);

(statearr_60058[(24)] = inst_59924);

return statearr_60058;
})();
if(inst_59925){
var statearr_60059_60106 = state_60040__$1;
(statearr_60059_60106[(1)] = (8));

} else {
var statearr_60060_60107 = state_60040__$1;
(statearr_60060_60107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (28))){
var inst_60013 = (state_60040[(26)]);
var inst_60006 = (state_60040[(27)]);
var inst_60023 = (state_60040[(2)]);
var inst_60024 = fluree.db.util.async.throw_err.call(null,inst_60023);
var inst_60025 = cljs.core.conj.call(null,inst_60006,inst_60024);
var inst_60005 = inst_60013;
var inst_60006__$1 = inst_60025;
var state_60040__$1 = (function (){var statearr_60061 = state_60040;
(statearr_60061[(28)] = inst_60005);

(statearr_60061[(27)] = inst_60006__$1);

return statearr_60061;
})();
var statearr_60062_60108 = state_60040__$1;
(statearr_60062_60108[(2)] = null);

(statearr_60062_60108[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (25))){
var inst_60006 = (state_60040[(27)]);
var state_60040__$1 = state_60040;
var statearr_60063_60109 = state_60040__$1;
(statearr_60063_60109[(2)] = inst_60006);

(statearr_60063_60109[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (17))){
var inst_59967 = (state_60040[(8)]);
var inst_59974 = (state_60040[(12)]);
var inst_59973 = cljs.core.seq.call(null,inst_59967);
var inst_59974__$1 = cljs.core.first.call(null,inst_59973);
var inst_59975 = cljs.core.next.call(null,inst_59973);
var inst_59976 = cljs.core.not.call(null,inst_59974__$1);
var state_60040__$1 = (function (){var statearr_60064 = state_60040;
(statearr_60064[(12)] = inst_59974__$1);

(statearr_60064[(25)] = inst_59975);

return statearr_60064;
})();
if(inst_59976){
var statearr_60065_60110 = state_60040__$1;
(statearr_60065_60110[(1)] = (19));

} else {
var statearr_60066_60111 = state_60040__$1;
(statearr_60066_60111[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (3))){
var inst_60038 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60040__$1,inst_60038);
} else {
if((state_val_60041 === (12))){
var inst_59923 = (state_60040[(21)]);
var inst_59936 = fluree.db.flake.flip_flake.call(null,inst_59923);
var state_60040__$1 = state_60040;
var statearr_60067_60112 = state_60040__$1;
(statearr_60067_60112[(2)] = inst_59936);

(statearr_60067_60112[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (2))){
var inst_59909 = (state_60040[(20)]);
var _ = (function (){var statearr_60068 = state_60040;
(statearr_60068[(4)] = cljs.core.cons.call(null,(5),(state_60040[(4)])));

return statearr_60068;
})();
var inst_59909__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59910 = cljs.core.seq.call(null,inst_59909__$1);
var inst_59911 = cljs.core.first.call(null,inst_59910);
var inst_59912 = cljs.core.next.call(null,inst_59910);
var inst_59913 = cljs.core.PersistentHashMap.EMPTY;
var inst_59914 = cljs.core.PersistentHashMap.EMPTY;
var inst_59915 = inst_59909__$1;
var inst_59916 = inst_59913;
var inst_59917 = inst_59914;
var state_60040__$1 = (function (){var statearr_60069 = state_60040;
(statearr_60069[(14)] = inst_59912);

(statearr_60069[(16)] = inst_59911);

(statearr_60069[(17)] = inst_59915);

(statearr_60069[(18)] = inst_59917);

(statearr_60069[(20)] = inst_59909__$1);

(statearr_60069[(22)] = inst_59916);

return statearr_60069;
})();
var statearr_60070_60113 = state_60040__$1;
(statearr_60070_60113[(2)] = null);

(statearr_60070_60113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (23))){
var inst_60005 = (state_60040[(28)]);
var inst_60012 = (state_60040[(29)]);
var inst_60011 = cljs.core.seq.call(null,inst_60005);
var inst_60012__$1 = cljs.core.first.call(null,inst_60011);
var inst_60013 = cljs.core.next.call(null,inst_60011);
var inst_60014 = cljs.core.not.call(null,inst_60012__$1);
var state_60040__$1 = (function (){var statearr_60071 = state_60040;
(statearr_60071[(26)] = inst_60013);

(statearr_60071[(29)] = inst_60012__$1);

return statearr_60071;
})();
if(inst_60014){
var statearr_60072_60114 = state_60040__$1;
(statearr_60072_60114[(1)] = (25));

} else {
var statearr_60073_60115 = state_60040__$1;
(statearr_60073_60115[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (19))){
var inst_59968 = (state_60040[(10)]);
var state_60040__$1 = state_60040;
var statearr_60074_60116 = state_60040__$1;
(statearr_60074_60116[(2)] = inst_59968);

(statearr_60074_60116[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (11))){
var inst_59923 = (state_60040[(21)]);
var state_60040__$1 = state_60040;
var statearr_60076_60117 = state_60040__$1;
(statearr_60076_60117[(2)] = inst_59923);

(statearr_60076_60117[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (9))){
var inst_59933 = (state_60040[(19)]);
var inst_59923 = (state_60040[(21)]);
var inst_59931 = inst_59923.s;
var inst_59932 = inst_59923.op;
var inst_59933__$1 = inst_59932 === true;
var state_60040__$1 = (function (){var statearr_60078 = state_60040;
(statearr_60078[(19)] = inst_59933__$1);

(statearr_60078[(23)] = inst_59931);

return statearr_60078;
})();
if(cljs.core.truth_(inst_59933__$1)){
var statearr_60079_60118 = state_60040__$1;
(statearr_60079_60118[(1)] = (11));

} else {
var statearr_60080_60119 = state_60040__$1;
(statearr_60080_60119[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (5))){
var _ = (function (){var statearr_60081 = state_60040;
(statearr_60081[(4)] = cljs.core.rest.call(null,(state_60040[(4)])));

return statearr_60081;
})();
var state_60040__$1 = state_60040;
var ex60075 = (state_60040__$1[(2)]);
var statearr_60082_60120 = state_60040__$1;
(statearr_60082_60120[(5)] = ex60075);


if((ex60075 instanceof Error)){
var statearr_60083_60121 = state_60040__$1;
(statearr_60083_60121[(1)] = (4));

(statearr_60083_60121[(5)] = null);

} else {
throw ex60075;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (14))){
var inst_59912 = (state_60040[(14)]);
var inst_59938 = (state_60040[(15)]);
var inst_59911 = (state_60040[(16)]);
var inst_59915 = (state_60040[(17)]);
var inst_59917 = (state_60040[(18)]);
var inst_59933 = (state_60040[(19)]);
var inst_59909 = (state_60040[(20)]);
var inst_59923 = (state_60040[(21)]);
var inst_59916 = (state_60040[(22)]);
var inst_59931 = (state_60040[(23)]);
var inst_59924 = (state_60040[(24)]);
var inst_59940 = (function (){var subject = inst_59931;
var flake = inst_59923;
var seq__59920 = inst_59924;
var seq__59907 = inst_59912;
var r = inst_59924;
var asserted_subjects = inst_59916;
var first__59921 = inst_59923;
var flake_SINGLEQUOTE_ = inst_59938;
var retracted_subjects = inst_59917;
var first__59908 = inst_59911;
var G__59905 = inst_59915;
var vec__59906 = inst_59909;
var asserted_QMARK_ = inst_59933;
var vec__59919 = inst_59915;
return (function (p1__59891_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__59891_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59941 = cljs.core.update.call(null,inst_59916,inst_59931,inst_59940);
var tmp60077 = inst_59917;
var inst_59915__$1 = inst_59924;
var inst_59916__$1 = inst_59941;
var inst_59917__$1 = tmp60077;
var state_60040__$1 = (function (){var statearr_60084 = state_60040;
(statearr_60084[(17)] = inst_59915__$1);

(statearr_60084[(18)] = inst_59917__$1);

(statearr_60084[(22)] = inst_59916__$1);

return statearr_60084;
})();
var statearr_60085_60122 = state_60040__$1;
(statearr_60085_60122[(2)] = null);

(statearr_60085_60122[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (26))){
var inst_60012 = (state_60040[(29)]);
var inst_60017 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60018 = cljs.core.PersistentHashMap.EMPTY;
var inst_60019 = [true,inst_60018];
var inst_60020 = cljs.core.PersistentHashMap.fromArrays(inst_60017,inst_60019);
var inst_60021 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60020,inst_60012);
var state_60040__$1 = state_60040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60040__$1,(28),inst_60021);
} else {
if((state_val_60041 === (16))){
var inst_59948 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
var statearr_60086_60123 = state_60040__$1;
(statearr_60086_60123[(2)] = inst_59948);

(statearr_60086_60123[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (10))){
var inst_59950 = (state_60040[(2)]);
var state_60040__$1 = state_60040;
var statearr_60087_60124 = state_60040__$1;
(statearr_60087_60124[(2)] = inst_59950);

(statearr_60087_60124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (18))){
var inst_59953 = (state_60040[(9)]);
var inst_59992 = (state_60040[(2)]);
var inst_60000 = cljs.core.vals.call(null,inst_59953);
var inst_60001 = cljs.core.seq.call(null,inst_60000);
var inst_60002 = cljs.core.first.call(null,inst_60001);
var inst_60003 = cljs.core.next.call(null,inst_60001);
var inst_60004 = cljs.core.PersistentVector.EMPTY;
var inst_60005 = inst_60000;
var inst_60006 = inst_60004;
var state_60040__$1 = (function (){var statearr_60088 = state_60040;
(statearr_60088[(30)] = inst_60002);

(statearr_60088[(31)] = inst_60003);

(statearr_60088[(28)] = inst_60005);

(statearr_60088[(27)] = inst_60006);

(statearr_60088[(13)] = inst_59992);

return statearr_60088;
})();
var statearr_60089_60125 = state_60040__$1;
(statearr_60089_60125[(2)] = null);

(statearr_60089_60125[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60041 === (8))){
var inst_59917 = (state_60040[(18)]);
var inst_59916 = (state_60040[(22)]);
var inst_59927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59928 = [inst_59916,inst_59917];
var inst_59929 = (new cljs.core.PersistentVector(null,2,(5),inst_59927,inst_59928,null));
var state_60040__$1 = state_60040;
var statearr_60090_60126 = state_60040__$1;
(statearr_60090_60126[(2)] = inst_59929);

(statearr_60090_60126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____0 = (function (){
var statearr_60091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60091[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__);

(statearr_60091[(1)] = (1));

return statearr_60091;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____1 = (function (state_60040){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60092){var ex__2471__auto__ = e60092;
var statearr_60093_60127 = state_60040;
(statearr_60093_60127[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60040[(4)]))){
var statearr_60094_60128 = state_60040;
(statearr_60094_60128[(1)] = cljs.core.first.call(null,(state_60040[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60129 = state_60040;
state_60040 = G__60129;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__ = function(state_60040){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____1.call(this,state_60040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60095 = f__2491__auto__.call(null);
(statearr_60095[(6)] = c__2490__auto__);

return statearr_60095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60161){
var state_val_60162 = (state_60161[(1)]);
if((state_val_60162 === (1))){
var inst_60130 = cljs.core.volatile_BANG_.call(null,(0));
var inst_60131 = cljs.core.PersistentHashMap.EMPTY;
var inst_60132 = cljs.core.volatile_BANG_.call(null,inst_60131);
var inst_60133 = cljs.core.first.call(null,resp);
var inst_60134 = cljs.core.rest.call(null,resp);
var inst_60135 = cljs.core.PersistentVector.EMPTY;
var inst_60136 = inst_60130;
var inst_60137 = inst_60132;
var inst_60138 = inst_60133;
var inst_60139 = inst_60134;
var inst_60140 = inst_60135;
var state_60161__$1 = (function (){var statearr_60163 = state_60161;
(statearr_60163[(7)] = inst_60140);

(statearr_60163[(8)] = inst_60136);

(statearr_60163[(9)] = inst_60139);

(statearr_60163[(10)] = inst_60137);

(statearr_60163[(11)] = inst_60138);

return statearr_60163;
})();
var statearr_60164_60179 = state_60161__$1;
(statearr_60164_60179[(2)] = null);

(statearr_60164_60179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60162 === (2))){
var inst_60136 = (state_60161[(8)]);
var inst_60137 = (state_60161[(10)]);
var inst_60138 = (state_60161[(11)]);
var inst_60142 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_60138,inst_60137,inst_60136);
var state_60161__$1 = state_60161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60161__$1,(4),inst_60142);
} else {
if((state_val_60162 === (3))){
var inst_60159 = (state_60161[(2)]);
var state_60161__$1 = state_60161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60161__$1,inst_60159);
} else {
if((state_val_60162 === (4))){
var inst_60140 = (state_60161[(7)]);
var inst_60139 = (state_60161[(9)]);
var inst_60144 = (state_60161[(2)]);
var inst_60145 = fluree.db.util.async.throw_err.call(null,inst_60144);
var inst_60146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60147 = [inst_60145];
var inst_60148 = (new cljs.core.PersistentVector(null,1,(5),inst_60146,inst_60147,null));
var inst_60149 = cljs.core.concat.call(null,inst_60140,inst_60148);
var inst_60150 = cljs.core.first.call(null,inst_60139);
var state_60161__$1 = (function (){var statearr_60167 = state_60161;
(statearr_60167[(12)] = inst_60149);

return statearr_60167;
})();
if(cljs.core.truth_(inst_60150)){
var statearr_60168_60180 = state_60161__$1;
(statearr_60168_60180[(1)] = (5));

} else {
var statearr_60169_60181 = state_60161__$1;
(statearr_60169_60181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60162 === (5))){
var inst_60136 = (state_60161[(8)]);
var inst_60139 = (state_60161[(9)]);
var inst_60137 = (state_60161[(10)]);
var inst_60149 = (state_60161[(12)]);
var inst_60152 = cljs.core.first.call(null,inst_60139);
var inst_60153 = cljs.core.rest.call(null,inst_60139);
var tmp60165 = inst_60136;
var tmp60166 = inst_60137;
var inst_60136__$1 = tmp60165;
var inst_60137__$1 = tmp60166;
var inst_60138 = inst_60152;
var inst_60139__$1 = inst_60153;
var inst_60140 = inst_60149;
var state_60161__$1 = (function (){var statearr_60170 = state_60161;
(statearr_60170[(7)] = inst_60140);

(statearr_60170[(8)] = inst_60136__$1);

(statearr_60170[(9)] = inst_60139__$1);

(statearr_60170[(10)] = inst_60137__$1);

(statearr_60170[(11)] = inst_60138);

return statearr_60170;
})();
var statearr_60171_60182 = state_60161__$1;
(statearr_60171_60182[(2)] = null);

(statearr_60171_60182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60162 === (6))){
var inst_60149 = (state_60161[(12)]);
var state_60161__$1 = state_60161;
var statearr_60172_60183 = state_60161__$1;
(statearr_60172_60183[(2)] = inst_60149);

(statearr_60172_60183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60162 === (7))){
var inst_60157 = (state_60161[(2)]);
var state_60161__$1 = state_60161;
var statearr_60173_60184 = state_60161__$1;
(statearr_60173_60184[(2)] = inst_60157);

(statearr_60173_60184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____0 = (function (){
var statearr_60174 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60174[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__);

(statearr_60174[(1)] = (1));

return statearr_60174;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____1 = (function (state_60161){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60175){var ex__2471__auto__ = e60175;
var statearr_60176_60185 = state_60161;
(statearr_60176_60185[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60161[(4)]))){
var statearr_60177_60186 = state_60161;
(statearr_60177_60186[(1)] = cljs.core.first.call(null,(state_60161[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60187 = state_60161;
state_60161 = G__60187;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__ = function(state_60161){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____1.call(this,state_60161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60178 = f__2491__auto__.call(null);
(statearr_60178[(6)] = c__2490__auto__);

return statearr_60178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60190 = arguments.length;
switch (G__60190) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,query_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60307){
var state_val_60308 = (state_60307[(1)]);
if((state_val_60308 === (7))){
var state_60307__$1 = state_60307;
var statearr_60309_60371 = state_60307__$1;
(statearr_60309_60371[(2)] = false);

(statearr_60309_60371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (20))){
var inst_60240 = (state_60307[(7)]);
var inst_60245 = (state_60307[(8)]);
var inst_60246 = (state_60307[(9)]);
var inst_60224 = (state_60307[(10)]);
var inst_60252 = fluree.db.api.query.block_range.call(null,inst_60240,inst_60245,inst_60246,inst_60224);
var state_60307__$1 = state_60307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60307__$1,(23),inst_60252);
} else {
if((state_val_60308 === (27))){
var inst_60274 = (state_60307[(11)]);
var state_60307__$1 = state_60307;
var statearr_60310_60372 = state_60307__$1;
(statearr_60310_60372[(2)] = inst_60274);

(statearr_60310_60372[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (1))){
var state_60307__$1 = state_60307;
var statearr_60311_60373 = state_60307__$1;
(statearr_60311_60373[(2)] = null);

(statearr_60311_60373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (24))){
var inst_60268 = cljs.core.pr_str.call(null,query_map);
var inst_60269 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_60268].join('');
var inst_60270 = fluree.db.util.log.warn.call(null,inst_60269);
var state_60307__$1 = state_60307;
var statearr_60312_60374 = state_60307__$1;
(statearr_60312_60374[(2)] = inst_60270);

(statearr_60312_60374[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (39))){
var inst_60226 = (state_60307[(12)]);
var inst_60290 = (state_60307[(13)]);
var inst_60296 = (state_60307[(2)]);
var inst_60297 = fluree.db.api.query.response_time_formatted.call(null,inst_60226);
var inst_60298 = [(200),inst_60296,(100),inst_60297];
var inst_60299 = cljs.core.PersistentHashMap.fromArrays(inst_60290,inst_60298);
var state_60307__$1 = state_60307;
var statearr_60313_60375 = state_60307__$1;
(statearr_60313_60375[(2)] = inst_60299);

(statearr_60313_60375[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (4))){
var inst_60192 = (state_60307[(2)]);
var state_60307__$1 = state_60307;
var statearr_60314_60376 = state_60307__$1;
(statearr_60314_60376[(2)] = inst_60192);

(statearr_60314_60376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (15))){
var inst_60240 = (state_60307[(7)]);
var inst_60239 = (state_60307[(2)]);
var inst_60240__$1 = fluree.db.util.async.throw_err.call(null,inst_60239);
var inst_60241 = fluree.db.api.query.resolve_block_range.call(null,inst_60240__$1,query_map);
var state_60307__$1 = (function (){var statearr_60315 = state_60307;
(statearr_60315[(7)] = inst_60240__$1);

return statearr_60315;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60307__$1,(19),inst_60241);
} else {
if((state_val_60308 === (21))){
var inst_60257 = cljs.core.pr_str.call(null,query_map);
var inst_60258 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60257].join('');
var inst_60259 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60260 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60261 = cljs.core.PersistentHashMap.fromArrays(inst_60259,inst_60260);
var inst_60262 = cljs.core.ex_info.call(null,inst_60258,inst_60261);
var inst_60263 = (function(){throw inst_60262})();
var state_60307__$1 = state_60307;
var statearr_60316_60377 = state_60307__$1;
(statearr_60316_60377[(2)] = inst_60263);

(statearr_60316_60377[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (31))){
var inst_60265 = (state_60307[(14)]);
var state_60307__$1 = state_60307;
var statearr_60317_60378 = state_60307__$1;
(statearr_60317_60378[(2)] = inst_60265);

(statearr_60317_60378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (32))){
var inst_60224 = (state_60307[(10)]);
var inst_60287 = (state_60307[(2)]);
var inst_60288 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60224);
var state_60307__$1 = (function (){var statearr_60318 = state_60307;
(statearr_60318[(15)] = inst_60287);

return statearr_60318;
})();
if(cljs.core.truth_(inst_60288)){
var statearr_60319_60379 = state_60307__$1;
(statearr_60319_60379[(1)] = (34));

} else {
var statearr_60320_60380 = state_60307__$1;
(statearr_60320_60380[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (33))){
var inst_60283 = (state_60307[(2)]);
var inst_60284 = fluree.db.util.async.throw_err.call(null,inst_60283);
var state_60307__$1 = state_60307;
var statearr_60321_60381 = state_60307__$1;
(statearr_60321_60381[(2)] = inst_60284);

(statearr_60321_60381[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (13))){
var inst_60202 = (state_60307[(16)]);
var state_60307__$1 = state_60307;
var statearr_60322_60382 = state_60307__$1;
(statearr_60322_60382[(2)] = inst_60202);

(statearr_60322_60382[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (22))){
var inst_60265 = (state_60307[(2)]);
var inst_60266 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60307__$1 = (function (){var statearr_60323 = state_60307;
(statearr_60323[(14)] = inst_60265);

return statearr_60323;
})();
if(cljs.core.truth_(inst_60266)){
var statearr_60324_60383 = state_60307__$1;
(statearr_60324_60383[(1)] = (24));

} else {
var statearr_60325_60384 = state_60307__$1;
(statearr_60325_60384[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (36))){
var inst_60302 = (state_60307[(2)]);
var _ = (function (){var statearr_60326 = state_60307;
(statearr_60326[(4)] = cljs.core.rest.call(null,(state_60307[(4)])));

return statearr_60326;
})();
var state_60307__$1 = state_60307;
var statearr_60327_60385 = state_60307__$1;
(statearr_60327_60385[(2)] = inst_60302);

(statearr_60327_60385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (29))){
var inst_60279 = (state_60307[(2)]);
var state_60307__$1 = state_60307;
if(cljs.core.truth_(inst_60279)){
var statearr_60328_60386 = state_60307__$1;
(statearr_60328_60386[(1)] = (30));

} else {
var statearr_60329_60387 = state_60307__$1;
(statearr_60329_60387[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (6))){
var inst_60202 = (state_60307[(16)]);
var inst_60207 = inst_60202.cljs$lang$protocol_mask$partition0$;
var inst_60208 = (inst_60207 & (64));
var inst_60209 = inst_60202.cljs$core$ISeq$;
var inst_60210 = (cljs.core.PROTOCOL_SENTINEL === inst_60209);
var inst_60211 = ((inst_60208) || (inst_60210));
var state_60307__$1 = state_60307;
if(cljs.core.truth_(inst_60211)){
var statearr_60330_60388 = state_60307__$1;
(statearr_60330_60388[(1)] = (9));

} else {
var statearr_60331_60389 = state_60307__$1;
(statearr_60331_60389[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (28))){
var inst_60277 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60307__$1 = state_60307;
var statearr_60332_60390 = state_60307__$1;
(statearr_60332_60390[(2)] = inst_60277);

(statearr_60332_60390[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (25))){
var state_60307__$1 = state_60307;
var statearr_60333_60391 = state_60307__$1;
(statearr_60333_60391[(2)] = null);

(statearr_60333_60391[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (34))){
var inst_60287 = (state_60307[(15)]);
var inst_60290 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60291 = cljs.core.sequential_QMARK_.call(null,inst_60287);
var state_60307__$1 = (function (){var statearr_60334 = state_60307;
(statearr_60334[(13)] = inst_60290);

return statearr_60334;
})();
if(inst_60291){
var statearr_60335_60392 = state_60307__$1;
(statearr_60335_60392[(1)] = (37));

} else {
var statearr_60336_60393 = state_60307__$1;
(statearr_60336_60393[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (17))){
var state_60307__$1 = state_60307;
var statearr_60337_60394 = state_60307__$1;
(statearr_60337_60394[(2)] = null);

(statearr_60337_60394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (3))){
var inst_60305 = (state_60307[(2)]);
var state_60307__$1 = state_60307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60307__$1,inst_60305);
} else {
if((state_val_60308 === (12))){
var inst_60202 = (state_60307[(16)]);
var inst_60220 = cljs.core.apply.call(null,cljs.core.hash_map,inst_60202);
var state_60307__$1 = state_60307;
var statearr_60338_60395 = state_60307__$1;
(statearr_60338_60395[(2)] = inst_60220);

(statearr_60338_60395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (2))){
var inst_60202 = (state_60307[(16)]);
var _ = (function (){var statearr_60339 = state_60307;
(statearr_60339[(4)] = cljs.core.cons.call(null,(5),(state_60307[(4)])));

return statearr_60339;
})();
var inst_60202__$1 = query_map;
var inst_60204 = (inst_60202__$1 == null);
var inst_60205 = cljs.core.not.call(null,inst_60204);
var state_60307__$1 = (function (){var statearr_60340 = state_60307;
(statearr_60340[(16)] = inst_60202__$1);

return statearr_60340;
})();
if(inst_60205){
var statearr_60341_60396 = state_60307__$1;
(statearr_60341_60396[(1)] = (6));

} else {
var statearr_60342_60397 = state_60307__$1;
(statearr_60342_60397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (23))){
var inst_60254 = (state_60307[(2)]);
var inst_60255 = fluree.db.util.async.throw_err.call(null,inst_60254);
var state_60307__$1 = state_60307;
var statearr_60343_60398 = state_60307__$1;
(statearr_60343_60398[(2)] = inst_60255);

(statearr_60343_60398[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (35))){
var inst_60287 = (state_60307[(15)]);
var state_60307__$1 = state_60307;
var statearr_60344_60399 = state_60307__$1;
(statearr_60344_60399[(2)] = inst_60287);

(statearr_60344_60399[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (19))){
var inst_60243 = (state_60307[(2)]);
var inst_60244 = fluree.db.util.async.throw_err.call(null,inst_60243);
var inst_60245 = cljs.core.nth.call(null,inst_60244,(0),null);
var inst_60246 = cljs.core.nth.call(null,inst_60244,(1),null);
var inst_60247 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60248 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60249 = cljs.core.keys.call(null,inst_60248);
var inst_60250 = cljs.core._EQ_.call(null,inst_60247,inst_60249);
var state_60307__$1 = (function (){var statearr_60345 = state_60307;
(statearr_60345[(8)] = inst_60245);

(statearr_60345[(9)] = inst_60246);

return statearr_60345;
})();
if(inst_60250){
var statearr_60346_60400 = state_60307__$1;
(statearr_60346_60400[(1)] = (20));

} else {
var statearr_60347_60401 = state_60307__$1;
(statearr_60347_60401[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (11))){
var inst_60215 = (state_60307[(2)]);
var state_60307__$1 = state_60307;
var statearr_60349_60402 = state_60307__$1;
(statearr_60349_60402[(2)] = inst_60215);

(statearr_60349_60402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (9))){
var state_60307__$1 = state_60307;
var statearr_60350_60403 = state_60307__$1;
(statearr_60350_60403[(2)] = true);

(statearr_60350_60403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (5))){
var _ = (function (){var statearr_60351 = state_60307;
(statearr_60351[(4)] = cljs.core.rest.call(null,(state_60307[(4)])));

return statearr_60351;
})();
var state_60307__$1 = state_60307;
var ex60348 = (state_60307__$1[(2)]);
var statearr_60352_60404 = state_60307__$1;
(statearr_60352_60404[(5)] = ex60348);


if((ex60348 instanceof Error)){
var statearr_60353_60405 = state_60307__$1;
(statearr_60353_60405[(1)] = (4));

(statearr_60353_60405[(5)] = null);

} else {
throw ex60348;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (14))){
var inst_60225 = (state_60307[(17)]);
var inst_60224 = (state_60307[(10)]);
var inst_60223 = (state_60307[(2)]);
var inst_60224__$1 = cljs.core.get.call(null,inst_60223,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60225__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60224__$1);
var inst_60226 = fluree.db.util.core.current_time_millis.call(null);
var inst_60227 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60307__$1 = (function (){var statearr_60354 = state_60307;
(statearr_60354[(12)] = inst_60226);

(statearr_60354[(18)] = inst_60227);

(statearr_60354[(17)] = inst_60225__$1);

(statearr_60354[(10)] = inst_60224__$1);

return statearr_60354;
})();
if(cljs.core.truth_(inst_60225__$1)){
var statearr_60355_60406 = state_60307__$1;
(statearr_60355_60406[(1)] = (16));

} else {
var statearr_60356_60407 = state_60307__$1;
(statearr_60356_60407[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (26))){
var inst_60274 = (state_60307[(11)]);
var inst_60273 = (state_60307[(2)]);
var inst_60274__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60307__$1 = (function (){var statearr_60357 = state_60307;
(statearr_60357[(11)] = inst_60274__$1);

(statearr_60357[(19)] = inst_60273);

return statearr_60357;
})();
if(cljs.core.truth_(inst_60274__$1)){
var statearr_60358_60408 = state_60307__$1;
(statearr_60358_60408[(1)] = (27));

} else {
var statearr_60359_60409 = state_60307__$1;
(statearr_60359_60409[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (16))){
var inst_60225 = (state_60307[(17)]);
var inst_60229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60230 = ["_auth/id",inst_60225];
var inst_60231 = (new cljs.core.PersistentVector(null,2,(5),inst_60229,inst_60230,null));
var state_60307__$1 = state_60307;
var statearr_60360_60410 = state_60307__$1;
(statearr_60360_60410[(2)] = inst_60231);

(statearr_60360_60410[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (38))){
var inst_60287 = (state_60307[(15)]);
var state_60307__$1 = state_60307;
var statearr_60361_60411 = state_60307__$1;
(statearr_60361_60411[(2)] = inst_60287);

(statearr_60361_60411[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (30))){
var inst_60240 = (state_60307[(7)]);
var inst_60265 = (state_60307[(14)]);
var inst_60281 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60240,inst_60265);
var state_60307__$1 = state_60307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60307__$1,(33),inst_60281);
} else {
if((state_val_60308 === (10))){
var state_60307__$1 = state_60307;
var statearr_60362_60412 = state_60307__$1;
(statearr_60362_60412[(2)] = false);

(statearr_60362_60412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (18))){
var inst_60227 = (state_60307[(18)]);
var inst_60234 = (state_60307[(2)]);
var inst_60235 = [inst_60234];
var inst_60236 = cljs.core.PersistentHashMap.fromArrays(inst_60227,inst_60235);
var inst_60237 = fluree.db.api.query.db.call(null,conn,ledger,inst_60236);
var state_60307__$1 = state_60307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60307__$1,(15),inst_60237);
} else {
if((state_val_60308 === (37))){
var inst_60287 = (state_60307[(15)]);
var inst_60293 = cljs.core.doall.call(null,inst_60287);
var state_60307__$1 = state_60307;
var statearr_60363_60413 = state_60307__$1;
(statearr_60363_60413[(2)] = inst_60293);

(statearr_60363_60413[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60308 === (8))){
var inst_60218 = (state_60307[(2)]);
var state_60307__$1 = state_60307;
if(cljs.core.truth_(inst_60218)){
var statearr_60364_60414 = state_60307__$1;
(statearr_60364_60414[(1)] = (12));

} else {
var statearr_60365_60415 = state_60307__$1;
(statearr_60365_60415[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2468__auto____0 = (function (){
var statearr_60366 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60366[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2468__auto__);

(statearr_60366[(1)] = (1));

return statearr_60366;
});
var fluree$db$api$query$block_query_async_$_state_machine__2468__auto____1 = (function (state_60307){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60367){var ex__2471__auto__ = e60367;
var statearr_60368_60416 = state_60307;
(statearr_60368_60416[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60307[(4)]))){
var statearr_60369_60417 = state_60307;
(statearr_60369_60417[(1)] = cljs.core.first.call(null,(state_60307[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60418 = state_60307;
state_60307 = G__60418;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2468__auto__ = function(state_60307){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2468__auto____1.call(this,state_60307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2468__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2468__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60370 = f__2491__auto__.call(null);
(statearr_60370[(6)] = c__2490__auto__);

return statearr_60370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60419 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__60419,(0),null);
var p = cljs.core.nth.call(null,vec__60419,(1),null);
var o = cljs.core.nth.call(null,vec__60419,(2),null);
var t = cljs.core.nth.call(null,vec__60419,(3),null);
var vec__60422 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__60422,(0),null);
var idx = cljs.core.nth.call(null,vec__60422,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60425 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__60425,(0),null);
var id = cljs.core.nth.call(null,vec__60425,(1),null);
var or__4126__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___60429 = arguments.length;
var i__4737__auto___60430 = (0);
while(true){
if((i__4737__auto___60430 < len__4736__auto___60429)){
args__4742__auto__.push((arguments[i__4737__auto___60430]));

var G__60431 = (i__4737__auto___60430 + (1));
i__4737__auto___60430 = G__60431;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60428){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60428));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60647){
var state_val_60648 = (state_60647[(1)]);
if((state_val_60648 === (7))){
var inst_60547 = (state_60647[(7)]);
var inst_60554 = (state_60647[(8)]);
var inst_60553 = cljs.core.seq.call(null,inst_60547);
var inst_60554__$1 = cljs.core.first.call(null,inst_60553);
var inst_60555 = cljs.core.next.call(null,inst_60553);
var state_60647__$1 = (function (){var statearr_60649 = state_60647;
(statearr_60649[(8)] = inst_60554__$1);

(statearr_60649[(9)] = inst_60555);

return statearr_60649;
})();
if(cljs.core.truth_(inst_60554__$1)){
var statearr_60650_60763 = state_60647__$1;
(statearr_60650_60763[(1)] = (9));

} else {
var statearr_60651_60764 = state_60647__$1;
(statearr_60651_60764[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (20))){
var inst_60637 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60652_60765 = state_60647__$1;
(statearr_60652_60765[(2)] = inst_60637);

(statearr_60652_60765[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (27))){
var inst_60573 = (state_60647[(10)]);
var inst_60591 = cljs.core.apply.call(null,cljs.core.hash_map,inst_60573);
var state_60647__$1 = state_60647;
var statearr_60653_60766 = state_60647__$1;
(statearr_60653_60766[(2)] = inst_60591);

(statearr_60653_60766[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (1))){
var state_60647__$1 = state_60647;
var statearr_60654_60767 = state_60647__$1;
(statearr_60654_60767[(2)] = null);

(statearr_60654_60767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (24))){
var state_60647__$1 = state_60647;
var statearr_60655_60768 = state_60647__$1;
(statearr_60655_60768[(2)] = true);

(statearr_60655_60768[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (39))){
var inst_60621 = (state_60647[(11)]);
var inst_60596 = (state_60647[(12)]);
var inst_60595 = (state_60647[(13)]);
var inst_60623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60624 = [inst_60595,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60625 = (new cljs.core.PersistentVector(null,2,(5),inst_60623,inst_60624,null));
var inst_60626 = cljs.core.assoc_in.call(null,inst_60621,inst_60625,inst_60596);
var state_60647__$1 = state_60647;
var statearr_60657_60769 = state_60647__$1;
(statearr_60657_60769[(2)] = inst_60626);

(statearr_60657_60769[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (4))){
var inst_60433 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60658_60770 = state_60647__$1;
(statearr_60658_60770[(2)] = inst_60433);

(statearr_60658_60770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (15))){
var inst_60548 = (state_60647[(14)]);
var inst_60555 = (state_60647[(9)]);
var tmp60656 = inst_60548;
var inst_60547 = inst_60555;
var inst_60548__$1 = tmp60656;
var state_60647__$1 = (function (){var statearr_60659 = state_60647;
(statearr_60659[(7)] = inst_60547);

(statearr_60659[(14)] = inst_60548__$1);

return statearr_60659;
})();
var statearr_60660_60771 = state_60647__$1;
(statearr_60660_60771[(2)] = null);

(statearr_60660_60771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (21))){
var inst_60573 = (state_60647[(10)]);
var inst_60578 = inst_60573.cljs$lang$protocol_mask$partition0$;
var inst_60579 = (inst_60578 & (64));
var inst_60580 = inst_60573.cljs$core$ISeq$;
var inst_60581 = (cljs.core.PROTOCOL_SENTINEL === inst_60580);
var inst_60582 = ((inst_60579) || (inst_60581));
var state_60647__$1 = state_60647;
if(cljs.core.truth_(inst_60582)){
var statearr_60661_60772 = state_60647__$1;
(statearr_60661_60772[(1)] = (24));

} else {
var statearr_60662_60773 = state_60647__$1;
(statearr_60662_60773[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (31))){
var inst_60548 = (state_60647[(14)]);
var state_60647__$1 = state_60647;
var statearr_60663_60774 = state_60647__$1;
(statearr_60663_60774[(2)] = inst_60548);

(statearr_60663_60774[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (32))){
var inst_60605 = (state_60647[(2)]);
var state_60647__$1 = (function (){var statearr_60664 = state_60647;
(statearr_60664[(15)] = inst_60605);

return statearr_60664;
})();
var statearr_60665_60775 = state_60647__$1;
(statearr_60665_60775[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (40))){
var inst_60621 = (state_60647[(11)]);
var state_60647__$1 = state_60647;
var statearr_60667_60776 = state_60647__$1;
(statearr_60667_60776[(2)] = inst_60621);

(statearr_60667_60776[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (33))){
var inst_60605 = (state_60647[(15)]);
var inst_60554 = (state_60647[(8)]);
var inst_60595 = (state_60647[(13)]);
var inst_60607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60608 = [inst_60595,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60609 = (new cljs.core.PersistentVector(null,2,(5),inst_60607,inst_60608,null));
var inst_60610 = cljs.core.update_in.call(null,inst_60605,inst_60609,cljs.core.conj,inst_60554);
var state_60647__$1 = state_60647;
var statearr_60668_60777 = state_60647__$1;
(statearr_60668_60777[(2)] = inst_60610);

(statearr_60668_60777[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (13))){
var inst_60557 = (state_60647[(16)]);
var state_60647__$1 = state_60647;
var statearr_60669_60778 = state_60647__$1;
(statearr_60669_60778[(2)] = inst_60557);

(statearr_60669_60778[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (22))){
var state_60647__$1 = state_60647;
var statearr_60670_60779 = state_60647__$1;
(statearr_60670_60779[(2)] = false);

(statearr_60670_60779[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (36))){
var inst_60572 = (state_60647[(17)]);
var inst_60613 = (state_60647[(18)]);
var inst_60595 = (state_60647[(13)]);
var inst_60615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60616 = [inst_60595,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60617 = (new cljs.core.PersistentVector(null,2,(5),inst_60615,inst_60616,null));
var inst_60618 = cljs.core.update_in.call(null,inst_60613,inst_60617,fluree.db.api.query.min_safe,inst_60572);
var state_60647__$1 = state_60647;
var statearr_60671_60780 = state_60647__$1;
(statearr_60671_60780[(2)] = inst_60618);

(statearr_60671_60780[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (41))){
var inst_60555 = (state_60647[(9)]);
var inst_60629 = (state_60647[(2)]);
var inst_60547 = inst_60555;
var inst_60548 = inst_60629;
var state_60647__$1 = (function (){var statearr_60672 = state_60647;
(statearr_60672[(7)] = inst_60547);

(statearr_60672[(14)] = inst_60548);

return statearr_60672;
})();
var statearr_60673_60781 = state_60647__$1;
(statearr_60673_60781[(2)] = null);

(statearr_60673_60781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (43))){
var state_60647__$1 = state_60647;
var statearr_60674_60782 = state_60647__$1;
(statearr_60674_60782[(2)] = null);

(statearr_60674_60782[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (29))){
var inst_60594 = (state_60647[(2)]);
var inst_60595 = cljs.core.get.call(null,inst_60594,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60596 = cljs.core.get.call(null,inst_60594,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60647__$1 = (function (){var statearr_60675 = state_60647;
(statearr_60675[(12)] = inst_60596);

(statearr_60675[(13)] = inst_60595);

return statearr_60675;
})();
var statearr_60676_60783 = state_60647__$1;
(statearr_60676_60783[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (44))){
var inst_60635 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60678_60784 = state_60647__$1;
(statearr_60678_60784[(2)] = inst_60635);

(statearr_60678_60784[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (6))){
var inst_60533 = (state_60647[(2)]);
var inst_60534 = fluree.db.util.async.throw_err.call(null,inst_60533);
var inst_60542 = resp;
var inst_60543 = cljs.core.seq.call(null,inst_60542);
var inst_60544 = cljs.core.first.call(null,inst_60543);
var inst_60545 = cljs.core.next.call(null,inst_60543);
var inst_60546 = cljs.core.PersistentHashMap.EMPTY;
var inst_60547 = inst_60542;
var inst_60548 = inst_60546;
var state_60647__$1 = (function (){var statearr_60679 = state_60647;
(statearr_60679[(19)] = inst_60545);

(statearr_60679[(7)] = inst_60547);

(statearr_60679[(20)] = inst_60534);

(statearr_60679[(14)] = inst_60548);

(statearr_60679[(21)] = inst_60544);

return statearr_60679;
})();
var statearr_60680_60785 = state_60647__$1;
(statearr_60680_60785[(2)] = null);

(statearr_60680_60785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (28))){
var inst_60573 = (state_60647[(10)]);
var state_60647__$1 = state_60647;
var statearr_60681_60786 = state_60647__$1;
(statearr_60681_60786[(2)] = inst_60573);

(statearr_60681_60786[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (25))){
var state_60647__$1 = state_60647;
var statearr_60682_60787 = state_60647__$1;
(statearr_60682_60787[(2)] = false);

(statearr_60682_60787[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (34))){
var inst_60605 = (state_60647[(15)]);
var state_60647__$1 = state_60647;
var statearr_60683_60788 = state_60647__$1;
(statearr_60683_60788[(2)] = inst_60605);

(statearr_60683_60788[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (17))){
var inst_60639 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60684_60789 = state_60647__$1;
(statearr_60684_60789[(2)] = inst_60639);

(statearr_60684_60789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (3))){
var inst_60645 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60647__$1,inst_60645);
} else {
if((state_val_60648 === (12))){
var inst_60534 = (state_60647[(20)]);
var inst_60554 = (state_60647[(8)]);
var inst_60559 = fluree.db.api.query.auth_match.call(null,auth,inst_60534,inst_60554);
var inst_60560 = cljs.core.not.call(null,inst_60559);
var state_60647__$1 = state_60647;
var statearr_60685_60790 = state_60647__$1;
(statearr_60685_60790[(2)] = inst_60560);

(statearr_60685_60790[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (2))){
var _ = (function (){var statearr_60686 = state_60647;
(statearr_60686[(4)] = cljs.core.cons.call(null,(5),(state_60647[(4)])));

return statearr_60686;
})();
var inst_60439 = (function (){return (function (p1__60432_SHARP_){
return p1__60432_SHARP_.t;
});
})();
var inst_60440 = cljs.core.map.call(null,inst_60439,resp);
var inst_60441 = cljs.core.set.call(null,inst_60440);
var inst_60529 = cljs.core.async.chan.call(null,(1));
var inst_60530 = (function (){var ts = inst_60441;
var c__2490__auto____$1 = inst_60529;
return (function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60527){
var state_val_60528 = (state_60527[(1)]);
if((state_val_60528 === (7))){
var inst_60455 = (state_60527[(7)]);
var inst_60467 = (state_60527[(8)]);
var inst_60461 = (state_60527[(9)]);
var inst_60473 = (state_60527[(10)]);
var inst_60466 = (state_60527[(2)]);
var inst_60467__$1 = fluree.db.util.async.throw_err.call(null,inst_60466);
var inst_60469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60470 = [inst_60461,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60471 = (new cljs.core.PersistentVector(null,2,(5),inst_60469,inst_60470,null));
var inst_60472 = cljs.core.assoc_in.call(null,inst_60455,inst_60471,inst_60467__$1);
var inst_60473__$1 = auth;
var state_60527__$1 = (function (){var statearr_60687 = state_60527;
(statearr_60687[(8)] = inst_60467__$1);

(statearr_60687[(11)] = inst_60472);

(statearr_60687[(10)] = inst_60473__$1);

return statearr_60687;
})();
if(cljs.core.truth_(inst_60473__$1)){
var statearr_60688_60791 = state_60527__$1;
(statearr_60688_60791[(1)] = (8));

} else {
var statearr_60689_60792 = state_60527__$1;
(statearr_60689_60792[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (1))){
var inst_60449 = (state_60527[(12)]);
var inst_60449__$1 = ts;
var inst_60450 = cljs.core.seq.call(null,inst_60449__$1);
var inst_60451 = cljs.core.first.call(null,inst_60450);
var inst_60452 = cljs.core.next.call(null,inst_60450);
var inst_60453 = cljs.core.PersistentHashMap.EMPTY;
var inst_60454 = inst_60449__$1;
var inst_60455 = inst_60453;
var state_60527__$1 = (function (){var statearr_60690 = state_60527;
(statearr_60690[(7)] = inst_60455);

(statearr_60690[(12)] = inst_60449__$1);

(statearr_60690[(13)] = inst_60451);

(statearr_60690[(14)] = inst_60454);

(statearr_60690[(15)] = inst_60452);

return statearr_60690;
})();
var statearr_60691_60793 = state_60527__$1;
(statearr_60691_60793[(2)] = null);

(statearr_60691_60793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (4))){
var inst_60461 = (state_60527[(9)]);
var inst_60464 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_60461);
var state_60527__$1 = state_60527;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60527__$1,(7),inst_60464);
} else {
if((state_val_60528 === (13))){
var inst_60462 = (state_60527[(16)]);
var inst_60519 = (state_60527[(2)]);
var inst_60454 = inst_60462;
var inst_60455 = inst_60519;
var state_60527__$1 = (function (){var statearr_60692 = state_60527;
(statearr_60692[(7)] = inst_60455);

(statearr_60692[(14)] = inst_60454);

return statearr_60692;
})();
var statearr_60693_60794 = state_60527__$1;
(statearr_60693_60794[(2)] = null);

(statearr_60693_60794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (6))){
var inst_60523 = (state_60527[(2)]);
var state_60527__$1 = state_60527;
var statearr_60694_60795 = state_60527__$1;
(statearr_60694_60795[(2)] = inst_60523);

(statearr_60694_60795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (3))){
var inst_60525 = (state_60527[(2)]);
var state_60527__$1 = state_60527;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60527__$1,inst_60525);
} else {
if((state_val_60528 === (12))){
var inst_60472 = (state_60527[(11)]);
var state_60527__$1 = state_60527;
var statearr_60695_60796 = state_60527__$1;
(statearr_60695_60796[(2)] = inst_60472);

(statearr_60695_60796[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (2))){
var inst_60461 = (state_60527[(9)]);
var inst_60454 = (state_60527[(14)]);
var inst_60460 = cljs.core.seq.call(null,inst_60454);
var inst_60461__$1 = cljs.core.first.call(null,inst_60460);
var inst_60462 = cljs.core.next.call(null,inst_60460);
var state_60527__$1 = (function (){var statearr_60696 = state_60527;
(statearr_60696[(9)] = inst_60461__$1);

(statearr_60696[(16)] = inst_60462);

return statearr_60696;
})();
if(cljs.core.truth_(inst_60461__$1)){
var statearr_60697_60797 = state_60527__$1;
(statearr_60697_60797[(1)] = (4));

} else {
var statearr_60698_60798 = state_60527__$1;
(statearr_60698_60798[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (11))){
var inst_60455 = (state_60527[(7)]);
var inst_60467 = (state_60527[(8)]);
var inst_60449 = (state_60527[(12)]);
var inst_60472 = (state_60527[(11)]);
var inst_60461 = (state_60527[(9)]);
var inst_60451 = (state_60527[(13)]);
var inst_60462 = (state_60527[(16)]);
var inst_60454 = (state_60527[(14)]);
var inst_60452 = (state_60527[(15)]);
var inst_60479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60480 = [inst_60461,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60481 = (new cljs.core.PersistentVector(null,2,(5),inst_60479,inst_60480,null));
var inst_60494 = cljs.core.async.chan.call(null,(1));
var inst_60495 = (function (){var G__60468 = inst_60472;
var t = inst_60461;
var first__60448 = inst_60451;
var first__60459 = inst_60461;
var block = inst_60467;
var r = inst_60462;
var seq__60447 = inst_60452;
var G__60445 = inst_60454;
var acc = inst_60455;
var c__2490__auto____$2 = inst_60494;
var seq__60458 = inst_60462;
var vec__60457 = inst_60454;
var vec__60446 = inst_60449;
return (function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_60492){
var state_val_60493 = (state_60492[(1)]);
if((state_val_60493 === (1))){
var state_60492__$1 = state_60492;
var statearr_60699_60799 = state_60492__$1;
(statearr_60699_60799[(2)] = null);

(statearr_60699_60799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (2))){
var ___$1 = (function (){var statearr_60700 = state_60492;
(statearr_60700[(4)] = cljs.core.cons.call(null,(5),(state_60492[(4)])));

return statearr_60700;
})();
var ___$2 = (function (){var statearr_60701 = state_60492;
(statearr_60701[(4)] = cljs.core.rest.call(null,(state_60492[(4)])));

return statearr_60701;
})();
var state_60492__$1 = state_60492;
var statearr_60702_60800 = state_60492__$1;
(statearr_60702_60800[(2)] = db);

(statearr_60702_60800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (3))){
var inst_60490 = (state_60492[(2)]);
var state_60492__$1 = state_60492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60492__$1,inst_60490);
} else {
if((state_val_60493 === (4))){
var inst_60482 = (state_60492[(2)]);
var state_60492__$1 = state_60492;
var statearr_60704_60801 = state_60492__$1;
(statearr_60704_60801[(2)] = inst_60482);

(statearr_60704_60801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60493 === (5))){
var ___$1 = (function (){var statearr_60705 = state_60492;
(statearr_60705[(4)] = cljs.core.rest.call(null,(state_60492[(4)])));

return statearr_60705;
})();
var state_60492__$1 = state_60492;
var ex60703 = (state_60492__$1[(2)]);
var statearr_60706_60802 = state_60492__$1;
(statearr_60706_60802[(5)] = ex60703);


if((ex60703 instanceof Error)){
var statearr_60707_60803 = state_60492__$1;
(statearr_60707_60803[(1)] = (4));

(statearr_60707_60803[(5)] = null);

} else {
throw ex60703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0 = (function (){
var statearr_60708 = [null,null,null,null,null,null,null];
(statearr_60708[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__);

(statearr_60708[(1)] = (1));

return statearr_60708;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1 = (function (state_60492){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60709){var ex__2471__auto__ = e60709;
var statearr_60710_60804 = state_60492;
(statearr_60710_60804[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60492[(4)]))){
var statearr_60711_60805 = state_60492;
(statearr_60711_60805[(1)] = cljs.core.first.call(null,(state_60492[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60806 = state_60492;
state_60492 = G__60806;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = function(state_60492){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1.call(this,state_60492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60712 = f__2491__auto__.call(null);
(statearr_60712[(6)] = c__2490__auto____$2);

return statearr_60712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
});
})();
var inst_60496 = cljs.core.async.impl.dispatch.run.call(null,inst_60495);
var inst_60497 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60499 = ["?auth","?id"];
var inst_60500 = (new cljs.core.PersistentVector(null,2,(5),inst_60498,inst_60499,null));
var inst_60501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60503 = [inst_60461,"_tx/auth","?auth"];
var inst_60504 = (new cljs.core.PersistentVector(null,3,(5),inst_60502,inst_60503,null));
var inst_60505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60506 = ["?auth","_auth/id","?id"];
var inst_60507 = (new cljs.core.PersistentVector(null,3,(5),inst_60505,inst_60506,null));
var inst_60508 = [inst_60504,inst_60507];
var inst_60509 = (new cljs.core.PersistentVector(null,2,(5),inst_60501,inst_60508,null));
var inst_60510 = [inst_60500,inst_60509];
var inst_60511 = cljs.core.PersistentHashMap.fromArrays(inst_60497,inst_60510);
var inst_60512 = fluree.db.api.query.query_async.call(null,inst_60494,inst_60511);
var state_60527__$1 = (function (){var statearr_60713 = state_60527;
(statearr_60713[(17)] = inst_60481);

(statearr_60713[(18)] = inst_60496);

return statearr_60713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60527__$1,(14),inst_60512);
} else {
if((state_val_60528 === (9))){
var state_60527__$1 = state_60527;
var statearr_60714_60807 = state_60527__$1;
(statearr_60714_60807[(2)] = show_auth);

(statearr_60714_60807[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (5))){
var inst_60455 = (state_60527[(7)]);
var state_60527__$1 = state_60527;
var statearr_60715_60808 = state_60527__$1;
(statearr_60715_60808[(2)] = inst_60455);

(statearr_60715_60808[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (14))){
var inst_60481 = (state_60527[(17)]);
var inst_60472 = (state_60527[(11)]);
var inst_60514 = (state_60527[(2)]);
var inst_60515 = fluree.db.util.async.throw_err.call(null,inst_60514);
var inst_60516 = cljs.core.assoc_in.call(null,inst_60472,inst_60481,inst_60515);
var state_60527__$1 = state_60527;
var statearr_60716_60809 = state_60527__$1;
(statearr_60716_60809[(2)] = inst_60516);

(statearr_60716_60809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (10))){
var inst_60477 = (state_60527[(2)]);
var state_60527__$1 = state_60527;
if(cljs.core.truth_(inst_60477)){
var statearr_60717_60810 = state_60527__$1;
(statearr_60717_60810[(1)] = (11));

} else {
var statearr_60718_60811 = state_60527__$1;
(statearr_60718_60811[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60528 === (8))){
var inst_60473 = (state_60527[(10)]);
var state_60527__$1 = state_60527;
var statearr_60719_60812 = state_60527__$1;
(statearr_60719_60812[(2)] = inst_60473);

(statearr_60719_60812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0 = (function (){
var statearr_60720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60720[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__);

(statearr_60720[(1)] = (1));

return statearr_60720;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1 = (function (state_60527){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60527);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60721){var ex__2471__auto__ = e60721;
var statearr_60722_60813 = state_60527;
(statearr_60722_60813[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60527[(4)]))){
var statearr_60723_60814 = state_60527;
(statearr_60723_60814[(1)] = cljs.core.first.call(null,(state_60527[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60815 = state_60527;
state_60527 = G__60815;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = function(state_60527){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1.call(this,state_60527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60724 = f__2491__auto__.call(null);
(statearr_60724[(6)] = c__2490__auto____$1);

return statearr_60724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
});
})();
var inst_60531 = cljs.core.async.impl.dispatch.run.call(null,inst_60530);
var state_60647__$1 = (function (){var statearr_60725 = state_60647;
(statearr_60725[(22)] = inst_60531);

return statearr_60725;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60647__$1,(6),inst_60529);
} else {
if((state_val_60648 === (23))){
var inst_60589 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
if(cljs.core.truth_(inst_60589)){
var statearr_60726_60816 = state_60647__$1;
(statearr_60726_60816[(1)] = (27));

} else {
var statearr_60727_60817 = state_60647__$1;
(statearr_60727_60817[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (35))){
var inst_60613 = (state_60647[(2)]);
var state_60647__$1 = (function (){var statearr_60728 = state_60647;
(statearr_60728[(18)] = inst_60613);

return statearr_60728;
})();
var statearr_60729_60818 = state_60647__$1;
(statearr_60729_60818[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (19))){
var state_60647__$1 = state_60647;
var statearr_60731_60819 = state_60647__$1;
(statearr_60731_60819[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (11))){
var inst_60566 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
if(cljs.core.truth_(inst_60566)){
var statearr_60734_60820 = state_60647__$1;
(statearr_60734_60820[(1)] = (15));

} else {
var statearr_60735_60821 = state_60647__$1;
(statearr_60735_60821[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (9))){
var inst_60557 = (state_60647[(16)]);
var inst_60557__$1 = auth;
var state_60647__$1 = (function (){var statearr_60736 = state_60647;
(statearr_60736[(16)] = inst_60557__$1);

return statearr_60736;
})();
if(cljs.core.truth_(inst_60557__$1)){
var statearr_60737_60822 = state_60647__$1;
(statearr_60737_60822[(1)] = (12));

} else {
var statearr_60738_60823 = state_60647__$1;
(statearr_60738_60823[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (5))){
var _ = (function (){var statearr_60739 = state_60647;
(statearr_60739[(4)] = cljs.core.rest.call(null,(state_60647[(4)])));

return statearr_60739;
})();
var state_60647__$1 = state_60647;
var ex60733 = (state_60647__$1[(2)]);
var statearr_60740_60824 = state_60647__$1;
(statearr_60740_60824[(5)] = ex60733);


if((ex60733 instanceof Error)){
var statearr_60741_60825 = state_60647__$1;
(statearr_60741_60825[(1)] = (4));

(statearr_60741_60825[(5)] = null);

} else {
throw ex60733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (14))){
var inst_60563 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60742_60826 = state_60647__$1;
(statearr_60742_60826[(2)] = inst_60563);

(statearr_60742_60826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (26))){
var inst_60586 = (state_60647[(2)]);
var state_60647__$1 = state_60647;
var statearr_60743_60827 = state_60647__$1;
(statearr_60743_60827[(2)] = inst_60586);

(statearr_60743_60827[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (16))){
var inst_60554 = (state_60647[(8)]);
var state_60647__$1 = state_60647;
if(cljs.core.truth_(inst_60554)){
var statearr_60744_60828 = state_60647__$1;
(statearr_60744_60828[(1)] = (18));

} else {
var statearr_60745_60829 = state_60647__$1;
(statearr_60745_60829[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (38))){
var inst_60621 = (state_60647[(2)]);
var state_60647__$1 = (function (){var statearr_60746 = state_60647;
(statearr_60746[(11)] = inst_60621);

return statearr_60746;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60747_60830 = state_60647__$1;
(statearr_60747_60830[(1)] = (39));

} else {
var statearr_60748_60831 = state_60647__$1;
(statearr_60748_60831[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (30))){
var inst_60548 = (state_60647[(14)]);
var inst_60595 = (state_60647[(13)]);
var inst_60599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60600 = [inst_60595,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60601 = (new cljs.core.PersistentVector(null,2,(5),inst_60599,inst_60600,null));
var inst_60602 = cljs.core.assoc_in.call(null,inst_60548,inst_60601,inst_60595);
var state_60647__$1 = state_60647;
var statearr_60749_60832 = state_60647__$1;
(statearr_60749_60832[(2)] = inst_60602);

(statearr_60749_60832[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (10))){
var inst_60554 = (state_60647[(8)]);
var state_60647__$1 = state_60647;
var statearr_60750_60833 = state_60647__$1;
(statearr_60750_60833[(2)] = inst_60554);

(statearr_60750_60833[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (18))){
var inst_60534 = (state_60647[(20)]);
var inst_60572 = (state_60647[(17)]);
var inst_60554 = (state_60647[(8)]);
var inst_60573 = (state_60647[(10)]);
var inst_60572__$1 = inst_60554.t;
var inst_60573__$1 = cljs.core.get.call(null,inst_60534,inst_60572__$1);
var inst_60575 = (inst_60573__$1 == null);
var inst_60576 = cljs.core.not.call(null,inst_60575);
var state_60647__$1 = (function (){var statearr_60751 = state_60647;
(statearr_60751[(17)] = inst_60572__$1);

(statearr_60751[(10)] = inst_60573__$1);

return statearr_60751;
})();
if(inst_60576){
var statearr_60752_60834 = state_60647__$1;
(statearr_60752_60834[(1)] = (21));

} else {
var statearr_60753_60835 = state_60647__$1;
(statearr_60753_60835[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (42))){
var inst_60548 = (state_60647[(14)]);
var state_60647__$1 = state_60647;
var statearr_60754_60836 = state_60647__$1;
(statearr_60754_60836[(2)] = inst_60548);

(statearr_60754_60836[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (37))){
var inst_60613 = (state_60647[(18)]);
var state_60647__$1 = state_60647;
var statearr_60755_60837 = state_60647__$1;
(statearr_60755_60837[(2)] = inst_60613);

(statearr_60755_60837[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60648 === (8))){
var inst_60641 = (state_60647[(2)]);
var inst_60642 = cljs.core.vals.call(null,inst_60641);
var _ = (function (){var statearr_60756 = state_60647;
(statearr_60756[(4)] = cljs.core.rest.call(null,(state_60647[(4)])));

return statearr_60756;
})();
var state_60647__$1 = state_60647;
var statearr_60757_60838 = state_60647__$1;
(statearr_60757_60838[(2)] = inst_60642);

(statearr_60757_60838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0 = (function (){
var statearr_60758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60758[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__);

(statearr_60758[(1)] = (1));

return statearr_60758;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1 = (function (state_60647){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_60647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e60759){var ex__2471__auto__ = e60759;
var statearr_60760_60839 = state_60647;
(statearr_60760_60839[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_60647[(4)]))){
var statearr_60761_60840 = state_60647;
(statearr_60761_60840[(1)] = cljs.core.first.call(null,(state_60647[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60841 = state_60647;
state_60647 = G__60841;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__ = function(state_60647){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1.call(this,state_60647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2468__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_60762 = f__2491__auto__.call(null);
(statearr_60762[(6)] = c__2490__auto__);

return statearr_60762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_61001){
var state_val_61002 = (state_61001[(1)]);
if((state_val_61002 === (7))){
var state_61001__$1 = state_61001;
var statearr_61003_61089 = state_61001__$1;
(statearr_61003_61089[(2)] = false);

(statearr_61003_61089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (20))){
var state_61001__$1 = state_61001;
var statearr_61004_61090 = state_61001__$1;
(statearr_61004_61090[(2)] = null);

(statearr_61004_61090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (27))){
var inst_60988 = cljs.core.pr_str.call(null,query_map);
var inst_60989 = ["History query not properly formatted. Provided ",inst_60988].join('');
var inst_60990 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60991 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60992 = cljs.core.PersistentHashMap.fromArrays(inst_60990,inst_60991);
var inst_60993 = cljs.core.ex_info.call(null,inst_60989,inst_60992);
var inst_60994 = (function(){throw inst_60993})();
var state_61001__$1 = state_61001;
var statearr_61005_61091 = state_61001__$1;
(statearr_61005_61091[(2)] = inst_60994);

(statearr_61005_61091[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (1))){
var state_61001__$1 = state_61001;
var statearr_61006_61092 = state_61001__$1;
(statearr_61006_61092[(2)] = null);

(statearr_61006_61092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (24))){
var inst_60906 = (state_61001[(2)]);
var inst_60907 = cljs.core.nth.call(null,inst_60906,(0),null);
var inst_60908 = cljs.core.nth.call(null,inst_60906,(1),null);
var inst_60909 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60910 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60911 = cljs.core.keys.call(null,inst_60910);
var inst_60912 = cljs.core._EQ_.call(null,inst_60909,inst_60911);
var state_61001__$1 = (function (){var statearr_61007 = state_61001;
(statearr_61007[(7)] = inst_60907);

(statearr_61007[(8)] = inst_60908);

return statearr_61007;
})();
if(inst_60912){
var statearr_61008_61093 = state_61001__$1;
(statearr_61008_61093[(1)] = (26));

} else {
var statearr_61009_61094 = state_61001__$1;
(statearr_61009_61094[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (55))){
var inst_60953 = (state_61001[(9)]);
var inst_60978 = (state_61001[(10)]);
var inst_60980 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60981 = cljs.core.count.call(null,inst_60953);
var inst_60982 = [inst_60978,inst_60981,(200)];
var inst_60983 = cljs.core.PersistentHashMap.fromArrays(inst_60980,inst_60982);
var state_61001__$1 = state_61001;
var statearr_61010_61095 = state_61001__$1;
(statearr_61010_61095[(2)] = inst_60983);

(statearr_61010_61095[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (39))){
var inst_60937 = (state_61001[(2)]);
var inst_60938 = fluree.db.util.async.throw_err.call(null,inst_60937);
var inst_60939 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60938);
var state_61001__$1 = state_61001;
var statearr_61011_61096 = state_61001__$1;
(statearr_61011_61096[(2)] = inst_60939);

(statearr_61011_61096[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (46))){
var inst_60878 = (state_61001[(11)]);
var state_61001__$1 = state_61001;
var statearr_61012_61097 = state_61001__$1;
(statearr_61012_61097[(2)] = inst_60878);

(statearr_61012_61097[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (4))){
var inst_60842 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
var statearr_61013_61098 = state_61001__$1;
(statearr_61013_61098[(2)] = inst_60842);

(statearr_61013_61098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (54))){
var inst_60974 = (state_61001[(2)]);
var inst_60975 = fluree.db.util.async.throw_err.call(null,inst_60974);
var state_61001__$1 = state_61001;
var statearr_61014_61099 = state_61001__$1;
(statearr_61014_61099[(2)] = inst_60975);

(statearr_61014_61099[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (15))){
var inst_60876 = (state_61001[(12)]);
var inst_60883 = (state_61001[(2)]);
var inst_60884 = fluree.db.util.async.throw_err.call(null,inst_60883);
var state_61001__$1 = (function (){var statearr_61015 = state_61001;
(statearr_61015[(13)] = inst_60884);

return statearr_61015;
})();
if(cljs.core.truth_(inst_60876)){
var statearr_61016_61100 = state_61001__$1;
(statearr_61016_61100[(1)] = (16));

} else {
var statearr_61017_61101 = state_61001__$1;
(statearr_61017_61101[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (48))){
var inst_60877 = (state_61001[(14)]);
var state_61001__$1 = state_61001;
var statearr_61018_61102 = state_61001__$1;
(statearr_61018_61102[(2)] = inst_60877);

(statearr_61018_61102[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (50))){
var inst_60970 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
if(cljs.core.truth_(inst_60970)){
var statearr_61019_61103 = state_61001__$1;
(statearr_61019_61103[(1)] = (51));

} else {
var statearr_61020_61104 = state_61001__$1;
(statearr_61020_61104[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (21))){
var inst_60874 = (state_61001[(15)]);
var inst_60898 = (state_61001[(2)]);
var state_61001__$1 = (function (){var statearr_61021 = state_61001;
(statearr_61021[(16)] = inst_60898);

return statearr_61021;
})();
if(cljs.core.truth_(inst_60874)){
var statearr_61022_61105 = state_61001__$1;
(statearr_61022_61105[(1)] = (22));

} else {
var statearr_61023_61106 = state_61001__$1;
(statearr_61023_61106[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (31))){
var inst_60922 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
if(cljs.core.truth_(inst_60922)){
var statearr_61024_61107 = state_61001__$1;
(statearr_61024_61107[(1)] = (32));

} else {
var statearr_61025_61108 = state_61001__$1;
(statearr_61025_61108[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (32))){
var inst_60907 = (state_61001[(7)]);
var inst_60884 = (state_61001[(13)]);
var inst_60924 = (inst_60907 - (1));
var inst_60925 = fluree.db.time_travel.as_of_block.call(null,inst_60884,inst_60924);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(35),inst_60925);
} else {
if((state_val_61002 === (40))){
var inst_60880 = (state_61001[(17)]);
var inst_60952 = (state_61001[(2)]);
var inst_60953 = fluree.db.util.async.throw_err.call(null,inst_60952);
var state_61001__$1 = (function (){var statearr_61026 = state_61001;
(statearr_61026[(9)] = inst_60953);

return statearr_61026;
})();
if(cljs.core.truth_(inst_60880)){
var statearr_61027_61109 = state_61001__$1;
(statearr_61027_61109[(1)] = (41));

} else {
var statearr_61028_61110 = state_61001__$1;
(statearr_61028_61110[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (56))){
var inst_60978 = (state_61001[(10)]);
var state_61001__$1 = state_61001;
var statearr_61029_61111 = state_61001__$1;
(statearr_61029_61111[(2)] = inst_60978);

(statearr_61029_61111[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (33))){
var state_61001__$1 = state_61001;
var statearr_61030_61112 = state_61001__$1;
(statearr_61030_61112[(2)] = (-1));

(statearr_61030_61112[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (13))){
var inst_60852 = (state_61001[(18)]);
var state_61001__$1 = state_61001;
var statearr_61031_61113 = state_61001__$1;
(statearr_61031_61113[(2)] = inst_60852);

(statearr_61031_61113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (22))){
var inst_60884 = (state_61001[(13)]);
var inst_60900 = fluree.db.api.query.resolve_block_range.call(null,inst_60884,query_map);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(25),inst_60900);
} else {
if((state_val_61002 === (36))){
var inst_60908 = (state_61001[(8)]);
var inst_60884 = (state_61001[(13)]);
var inst_60935 = fluree.db.time_travel.as_of_block.call(null,inst_60884,inst_60908);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(39),inst_60935);
} else {
if((state_val_61002 === (41))){
var inst_60880 = (state_61001[(17)]);
var inst_60955 = cljs.core.set.call(null,inst_60880);
var state_61001__$1 = state_61001;
var statearr_61032_61114 = state_61001__$1;
(statearr_61032_61114[(2)] = inst_60955);

(statearr_61032_61114[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (43))){
var inst_60879 = (state_61001[(19)]);
var inst_60958 = (state_61001[(2)]);
var state_61001__$1 = (function (){var statearr_61033 = state_61001;
(statearr_61033[(20)] = inst_60958);

return statearr_61033;
})();
if(cljs.core.truth_(inst_60879)){
var statearr_61034_61115 = state_61001__$1;
(statearr_61034_61115[(1)] = (45));

} else {
var statearr_61035_61116 = state_61001__$1;
(statearr_61035_61116[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (29))){
var inst_60907 = (state_61001[(7)]);
var inst_60919 = cljs.core.not_EQ_.call(null,(1),inst_60907);
var state_61001__$1 = state_61001;
var statearr_61036_61117 = state_61001__$1;
(statearr_61036_61117[(2)] = inst_60919);

(statearr_61036_61117[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (44))){
var inst_60877 = (state_61001[(14)]);
var inst_60965 = (state_61001[(2)]);
var inst_60966 = fluree.db.util.async.throw_err.call(null,inst_60965);
var state_61001__$1 = (function (){var statearr_61037 = state_61001;
(statearr_61037[(21)] = inst_60966);

return statearr_61037;
})();
if(cljs.core.truth_(inst_60877)){
var statearr_61038_61118 = state_61001__$1;
(statearr_61038_61118[(1)] = (48));

} else {
var statearr_61039_61119 = state_61001__$1;
(statearr_61039_61119[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (6))){
var inst_60852 = (state_61001[(18)]);
var inst_60857 = inst_60852.cljs$lang$protocol_mask$partition0$;
var inst_60858 = (inst_60857 & (64));
var inst_60859 = inst_60852.cljs$core$ISeq$;
var inst_60860 = (cljs.core.PROTOCOL_SENTINEL === inst_60859);
var inst_60861 = ((inst_60858) || (inst_60860));
var state_61001__$1 = state_61001;
if(cljs.core.truth_(inst_60861)){
var statearr_61040_61120 = state_61001__$1;
(statearr_61040_61120[(1)] = (9));

} else {
var statearr_61041_61121 = state_61001__$1;
(statearr_61041_61121[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (28))){
var inst_60996 = (state_61001[(2)]);
var _ = (function (){var statearr_61042 = state_61001;
(statearr_61042[(4)] = cljs.core.rest.call(null,(state_61001[(4)])));

return statearr_61042;
})();
var state_61001__$1 = state_61001;
var statearr_61043_61122 = state_61001__$1;
(statearr_61043_61122[(2)] = inst_60996);

(statearr_61043_61122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (51))){
var inst_60884 = (state_61001[(13)]);
var inst_60966 = (state_61001[(21)]);
var inst_60972 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60884,inst_60966);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(54),inst_60972);
} else {
if((state_val_61002 === (25))){
var inst_60902 = (state_61001[(2)]);
var inst_60903 = fluree.db.util.async.throw_err.call(null,inst_60902);
var state_61001__$1 = state_61001;
var statearr_61044_61123 = state_61001__$1;
(statearr_61044_61123[(2)] = inst_60903);

(statearr_61044_61123[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (34))){
var inst_60908 = (state_61001[(8)]);
var inst_60933 = (state_61001[(2)]);
var state_61001__$1 = (function (){var statearr_61045 = state_61001;
(statearr_61045[(22)] = inst_60933);

return statearr_61045;
})();
if(cljs.core.truth_(inst_60908)){
var statearr_61046_61124 = state_61001__$1;
(statearr_61046_61124[(1)] = (36));

} else {
var statearr_61047_61125 = state_61001__$1;
(statearr_61047_61125[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (17))){
var state_61001__$1 = state_61001;
var statearr_61048_61126 = state_61001__$1;
(statearr_61048_61126[(2)] = null);

(statearr_61048_61126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (3))){
var inst_60999 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61001__$1,inst_60999);
} else {
if((state_val_61002 === (12))){
var inst_60852 = (state_61001[(18)]);
var inst_60870 = cljs.core.apply.call(null,cljs.core.hash_map,inst_60852);
var state_61001__$1 = state_61001;
var statearr_61049_61127 = state_61001__$1;
(statearr_61049_61127[(2)] = inst_60870);

(statearr_61049_61127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (2))){
var inst_60852 = (state_61001[(18)]);
var _ = (function (){var statearr_61050 = state_61001;
(statearr_61050[(4)] = cljs.core.cons.call(null,(5),(state_61001[(4)])));

return statearr_61050;
})();
var inst_60852__$1 = query_map;
var inst_60854 = (inst_60852__$1 == null);
var inst_60855 = cljs.core.not.call(null,inst_60854);
var state_61001__$1 = (function (){var statearr_61051 = state_61001;
(statearr_61051[(18)] = inst_60852__$1);

return statearr_61051;
})();
if(inst_60855){
var statearr_61052_61128 = state_61001__$1;
(statearr_61052_61128[(1)] = (6));

} else {
var statearr_61053_61129 = state_61001__$1;
(statearr_61053_61129[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (23))){
var state_61001__$1 = state_61001;
var statearr_61054_61130 = state_61001__$1;
(statearr_61054_61130[(2)] = null);

(statearr_61054_61130[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (47))){
var inst_60953 = (state_61001[(9)]);
var inst_60958 = (state_61001[(20)]);
var inst_60884 = (state_61001[(13)]);
var inst_60962 = (state_61001[(2)]);
var inst_60963 = fluree.db.api.query.format_history_resp.call(null,inst_60884,inst_60953,inst_60958,inst_60962);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(44),inst_60963);
} else {
if((state_val_61002 === (35))){
var inst_60927 = (state_61001[(2)]);
var inst_60928 = fluree.db.util.async.throw_err.call(null,inst_60927);
var inst_60929 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60928);
var inst_60930 = (inst_60929 - (1));
var state_61001__$1 = state_61001;
var statearr_61055_61131 = state_61001__$1;
(statearr_61055_61131[(2)] = inst_60930);

(statearr_61055_61131[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (19))){
var inst_60893 = cljs.core.pr_str.call(null,query_map);
var inst_60894 = ["The show-auth key should be rename `showAuth`. `pretty-print` is being deprecated. Provided: ",inst_60893].join('');
var inst_60895 = fluree.db.util.log.warn.call(null,inst_60894);
var state_61001__$1 = state_61001;
var statearr_61056_61132 = state_61001__$1;
(statearr_61056_61132[(2)] = inst_60895);

(statearr_61056_61132[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (57))){
var inst_60986 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
var statearr_61057_61133 = state_61001__$1;
(statearr_61057_61133[(2)] = inst_60986);

(statearr_61057_61133[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (11))){
var inst_60865 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
var statearr_61059_61134 = state_61001__$1;
(statearr_61059_61134[(2)] = inst_60865);

(statearr_61059_61134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (9))){
var state_61001__$1 = state_61001;
var statearr_61060_61135 = state_61001__$1;
(statearr_61060_61135[(2)] = true);

(statearr_61060_61135[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (5))){
var _ = (function (){var statearr_61061 = state_61001;
(statearr_61061[(4)] = cljs.core.rest.call(null,(state_61001[(4)])));

return statearr_61061;
})();
var state_61001__$1 = state_61001;
var ex61058 = (state_61001__$1[(2)]);
var statearr_61062_61136 = state_61001__$1;
(statearr_61062_61136[(5)] = ex61058);


if((ex61058 instanceof Error)){
var statearr_61063_61137 = state_61001__$1;
(statearr_61063_61137[(1)] = (4));

(statearr_61063_61137[(5)] = null);

} else {
throw ex61058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (14))){
var inst_60873 = (state_61001[(2)]);
var inst_60874 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60875 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60876 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60877 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60878 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60879 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60880 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60881 = cljs.core.get.call(null,inst_60873,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61001__$1 = (function (){var statearr_61064 = state_61001;
(statearr_61064[(19)] = inst_60879);

(statearr_61064[(12)] = inst_60876);

(statearr_61064[(11)] = inst_60878);

(statearr_61064[(23)] = inst_60881);

(statearr_61064[(14)] = inst_60877);

(statearr_61064[(15)] = inst_60874);

(statearr_61064[(17)] = inst_60880);

(statearr_61064[(24)] = inst_60875);

return statearr_61064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(15),sources);
} else {
if((state_val_61002 === (45))){
var inst_60879 = (state_61001[(19)]);
var state_61001__$1 = state_61001;
var statearr_61065_61138 = state_61001__$1;
(statearr_61065_61138[(2)] = inst_60879);

(statearr_61065_61138[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (53))){
var inst_60917 = (state_61001[(25)]);
var inst_60978 = (state_61001[(2)]);
var state_61001__$1 = (function (){var statearr_61066 = state_61001;
(statearr_61066[(10)] = inst_60978);

return statearr_61066;
})();
if(cljs.core.truth_(inst_60917)){
var statearr_61067_61139 = state_61001__$1;
(statearr_61067_61139[(1)] = (55));

} else {
var statearr_61068_61140 = state_61001__$1;
(statearr_61068_61140[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (26))){
var inst_60907 = (state_61001[(7)]);
var inst_60881 = (state_61001[(23)]);
var inst_60917 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60881);
var state_61001__$1 = (function (){var statearr_61069 = state_61001;
(statearr_61069[(25)] = inst_60917);

return statearr_61069;
})();
if(cljs.core.truth_(inst_60907)){
var statearr_61070_61141 = state_61001__$1;
(statearr_61070_61141[(1)] = (29));

} else {
var statearr_61071_61142 = state_61001__$1;
(statearr_61071_61142[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (16))){
var inst_60886 = cljs.core.pr_str.call(null,query_map);
var inst_60887 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_60886].join('');
var inst_60888 = fluree.db.util.log.warn.call(null,inst_60887);
var state_61001__$1 = state_61001;
var statearr_61072_61143 = state_61001__$1;
(statearr_61072_61143[(2)] = inst_60888);

(statearr_61072_61143[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (38))){
var inst_60933 = (state_61001[(22)]);
var inst_60884 = (state_61001[(13)]);
var inst_60875 = (state_61001[(24)]);
var inst_60943 = (state_61001[(2)]);
var inst_60944 = fluree.db.api.query.get_history_pattern.call(null,inst_60875);
var inst_60945 = cljs.core.nth.call(null,inst_60944,(0),null);
var inst_60946 = cljs.core.nth.call(null,inst_60944,(1),null);
var inst_60947 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60948 = [inst_60933,inst_60943];
var inst_60949 = cljs.core.PersistentHashMap.fromArrays(inst_60947,inst_60948);
var inst_60950 = fluree.db.query.range.time_range.call(null,inst_60884,inst_60946,cljs.core._EQ_,inst_60945,inst_60949);
var state_61001__$1 = state_61001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61001__$1,(40),inst_60950);
} else {
if((state_val_61002 === (30))){
var inst_60907 = (state_61001[(7)]);
var state_61001__$1 = state_61001;
var statearr_61073_61144 = state_61001__$1;
(statearr_61073_61144[(2)] = inst_60907);

(statearr_61073_61144[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (10))){
var state_61001__$1 = state_61001;
var statearr_61074_61145 = state_61001__$1;
(statearr_61074_61145[(2)] = false);

(statearr_61074_61145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (18))){
var inst_60878 = (state_61001[(11)]);
var inst_60891 = (state_61001[(2)]);
var state_61001__$1 = (function (){var statearr_61075 = state_61001;
(statearr_61075[(26)] = inst_60891);

return statearr_61075;
})();
if(cljs.core.truth_(inst_60878)){
var statearr_61076_61146 = state_61001__$1;
(statearr_61076_61146[(1)] = (19));

} else {
var statearr_61077_61147 = state_61001__$1;
(statearr_61077_61147[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (52))){
var inst_60966 = (state_61001[(21)]);
var state_61001__$1 = state_61001;
var statearr_61078_61148 = state_61001__$1;
(statearr_61078_61148[(2)] = inst_60966);

(statearr_61078_61148[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (42))){
var state_61001__$1 = state_61001;
var statearr_61079_61149 = state_61001__$1;
(statearr_61079_61149[(2)] = null);

(statearr_61079_61149[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (37))){
var inst_60884 = (state_61001[(13)]);
var inst_60941 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60884);
var state_61001__$1 = state_61001;
var statearr_61080_61150 = state_61001__$1;
(statearr_61080_61150[(2)] = inst_60941);

(statearr_61080_61150[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (8))){
var inst_60868 = (state_61001[(2)]);
var state_61001__$1 = state_61001;
if(cljs.core.truth_(inst_60868)){
var statearr_61081_61151 = state_61001__$1;
(statearr_61081_61151[(1)] = (12));

} else {
var statearr_61082_61152 = state_61001__$1;
(statearr_61082_61152[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61002 === (49))){
var inst_60876 = (state_61001[(12)]);
var state_61001__$1 = state_61001;
var statearr_61083_61153 = state_61001__$1;
(statearr_61083_61153[(2)] = inst_60876);

(statearr_61083_61153[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2468__auto____0 = (function (){
var statearr_61084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61084[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2468__auto__);

(statearr_61084[(1)] = (1));

return statearr_61084;
});
var fluree$db$api$query$history_query_async_$_state_machine__2468__auto____1 = (function (state_61001){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_61001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e61085){var ex__2471__auto__ = e61085;
var statearr_61086_61154 = state_61001;
(statearr_61086_61154[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_61001[(4)]))){
var statearr_61087_61155 = state_61001;
(statearr_61087_61155[(1)] = cljs.core.first.call(null,(state_61001[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61156 = state_61001;
state_61001 = G__61156;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2468__auto__ = function(state_61001){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2468__auto____1.call(this,state_61001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2468__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2468__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_61088 = f__2491__auto__.call(null);
(statearr_61088[(6)] = c__2490__auto__);

return statearr_61088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_61309){
var state_val_61310 = (state_61309[(1)]);
if((state_val_61310 === (7))){
var state_61309__$1 = state_61309;
var statearr_61311_61403 = state_61309__$1;
(statearr_61311_61403[(2)] = false);

(statearr_61311_61403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (59))){
var inst_61294 = (state_61309[(7)]);
var state_61309__$1 = state_61309;
var statearr_61312_61404 = state_61309__$1;
(statearr_61312_61404[(2)] = inst_61294);

(statearr_61312_61404[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (20))){
var inst_61191 = (state_61309[(8)]);
var inst_61229 = (state_61309[(2)]);
var state_61309__$1 = (function (){var statearr_61313 = state_61309;
(statearr_61313[(9)] = inst_61229);

return statearr_61313;
})();
if(cljs.core.truth_(inst_61191)){
var statearr_61314_61405 = state_61309__$1;
(statearr_61314_61405[(1)] = (24));

} else {
var statearr_61315_61406 = state_61309__$1;
(statearr_61315_61406[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (58))){
var inst_61249 = (state_61309[(10)]);
var inst_61294 = (state_61309[(7)]);
var inst_61289 = (state_61309[(11)]);
var inst_61229 = (state_61309[(9)]);
var inst_61296 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61297 = cljs.core.deref.call(null,inst_61249);
var inst_61298 = fluree.db.api.query.response_time_formatted.call(null,inst_61289);
var inst_61299 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61229);
var inst_61300 = [(200),inst_61294,inst_61297,inst_61298,inst_61299];
var inst_61301 = cljs.core.PersistentHashMap.fromArrays(inst_61296,inst_61300);
var state_61309__$1 = state_61309;
var statearr_61316_61407 = state_61309__$1;
(statearr_61316_61407[(2)] = inst_61301);

(statearr_61316_61407[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (60))){
var inst_61304 = (state_61309[(2)]);
var _ = (function (){var statearr_61317 = state_61309;
(statearr_61317[(4)] = cljs.core.rest.call(null,(state_61309[(4)])));

return statearr_61317;
})();
var state_61309__$1 = state_61309;
var statearr_61318_61408 = state_61309__$1;
(statearr_61318_61408[(2)] = inst_61304);

(statearr_61318_61408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (27))){
var inst_61240 = (state_61309[(12)]);
var state_61309__$1 = state_61309;
var statearr_61319_61409 = state_61309__$1;
(statearr_61319_61409[(2)] = inst_61240);

(statearr_61319_61409[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (1))){
var state_61309__$1 = state_61309;
var statearr_61320_61410 = state_61309__$1;
(statearr_61320_61410[(2)] = null);

(statearr_61320_61410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (24))){
var inst_61191 = (state_61309[(8)]);
var inst_61229 = (state_61309[(9)]);
var inst_61231 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61229);
var inst_61232 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61229);
var inst_61233 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61229);
var inst_61234 = fluree.db.api.query.get_sources.call(null,inst_61231,inst_61232,inst_61233,inst_61191);
var state_61309__$1 = state_61309;
var statearr_61321_61411 = state_61309__$1;
(statearr_61321_61411[(2)] = inst_61234);

(statearr_61321_61411[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (55))){
var inst_61282 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61283 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61284 = cljs.core.PersistentHashMap.fromArrays(inst_61282,inst_61283);
var inst_61285 = cljs.core.ex_info.call(null,"Invalid query.",inst_61284);
var inst_61286 = (function(){throw inst_61285})();
var state_61309__$1 = state_61309;
var statearr_61322_61412 = state_61309__$1;
(statearr_61322_61412[(2)] = inst_61286);

(statearr_61322_61412[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (39))){
var inst_61193 = (state_61309[(13)]);
var state_61309__$1 = state_61309;
var statearr_61323_61413 = state_61309__$1;
(statearr_61323_61413[(2)] = inst_61193);

(statearr_61323_61413[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (46))){
var inst_61187 = (state_61309[(14)]);
var state_61309__$1 = state_61309;
var statearr_61324_61414 = state_61309__$1;
(statearr_61324_61414[(2)] = inst_61187);

(statearr_61324_61414[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (4))){
var inst_61158 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61325_61415 = state_61309__$1;
(statearr_61325_61415[(2)] = inst_61158);

(statearr_61325_61415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (54))){
var state_61309__$1 = state_61309;
var statearr_61326_61416 = state_61309__$1;
(statearr_61326_61416[(2)] = null);

(statearr_61326_61416[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (15))){
var state_61309__$1 = state_61309;
var statearr_61327_61417 = state_61309__$1;
(statearr_61327_61417[(2)] = null);

(statearr_61327_61417[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (48))){
var inst_61194 = (state_61309[(15)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61194)){
var statearr_61328_61418 = state_61309__$1;
(statearr_61328_61418[(1)] = (51));

} else {
var statearr_61329_61419 = state_61309__$1;
(statearr_61329_61419[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (50))){
var inst_61279 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61279)){
var statearr_61330_61420 = state_61309__$1;
(statearr_61330_61420[(1)] = (54));

} else {
var statearr_61331_61421 = state_61309__$1;
(statearr_61331_61421[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (21))){
var inst_61222 = (state_61309[(2)]);
var inst_61223 = fluree.db.util.async.throw_err.call(null,inst_61222);
var state_61309__$1 = state_61309;
var statearr_61332_61422 = state_61309__$1;
(statearr_61332_61422[(2)] = inst_61223);

(statearr_61332_61422[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (31))){
var state_61309__$1 = state_61309;
var statearr_61333_61423 = state_61309__$1;
(statearr_61333_61423[(2)] = null);

(statearr_61333_61423[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (32))){
var inst_61250 = (state_61309[(16)]);
var inst_61195 = (state_61309[(17)]);
var inst_61249 = (state_61309[(2)]);
var inst_61250__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61195);
var state_61309__$1 = (function (){var statearr_61334 = state_61309;
(statearr_61334[(10)] = inst_61249);

(statearr_61334[(16)] = inst_61250__$1);

return statearr_61334;
})();
if(cljs.core.truth_(inst_61250__$1)){
var statearr_61335_61424 = state_61309__$1;
(statearr_61335_61424[(1)] = (33));

} else {
var statearr_61336_61425 = state_61309__$1;
(statearr_61336_61425[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (40))){
var inst_61192 = (state_61309[(18)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61192)){
var statearr_61337_61426 = state_61309__$1;
(statearr_61337_61426[(1)] = (42));

} else {
var statearr_61338_61427 = state_61309__$1;
(statearr_61338_61427[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (56))){
var inst_61255 = (state_61309[(19)]);
var inst_61229 = (state_61309[(9)]);
var inst_61288 = (state_61309[(2)]);
var inst_61289 = fluree.db.util.core.current_time_millis.call(null);
var inst_61290 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61255);
var inst_61291 = fluree.db.query.fql.query.call(null,inst_61229,inst_61290);
var state_61309__$1 = (function (){var statearr_61339 = state_61309;
(statearr_61339[(11)] = inst_61289);

(statearr_61339[(20)] = inst_61288);

return statearr_61339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61309__$1,(57),inst_61291);
} else {
if((state_val_61310 === (33))){
var inst_61250 = (state_61309[(16)]);
var state_61309__$1 = state_61309;
var statearr_61340_61428 = state_61309__$1;
(statearr_61340_61428[(2)] = inst_61250);

(statearr_61340_61428[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (13))){
var inst_61165 = (state_61309[(21)]);
var state_61309__$1 = state_61309;
var statearr_61341_61429 = state_61309__$1;
(statearr_61341_61429[(2)] = inst_61165);

(statearr_61341_61429[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (22))){
var inst_61189 = (state_61309[(22)]);
var inst_61218 = (state_61309[(2)]);
var inst_61219 = fluree.db.util.async.throw_err.call(null,inst_61218);
var inst_61220 = fluree.db.time_travel.as_of_block.call(null,inst_61219,inst_61189);
var state_61309__$1 = state_61309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61309__$1,(21),inst_61220);
} else {
if((state_val_61310 === (36))){
var inst_61188 = (state_61309[(23)]);
var state_61309__$1 = state_61309;
var statearr_61342_61430 = state_61309__$1;
(statearr_61342_61430[(2)] = inst_61188);

(statearr_61342_61430[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (41))){
var inst_61269 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61343_61431 = state_61309__$1;
(statearr_61343_61431[(2)] = inst_61269);

(statearr_61343_61431[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (43))){
var inst_61196 = (state_61309[(24)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61196)){
var statearr_61344_61432 = state_61309__$1;
(statearr_61344_61432[(1)] = (45));

} else {
var statearr_61345_61433 = state_61309__$1;
(statearr_61345_61433[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (29))){
var inst_61244 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61244)){
var statearr_61346_61434 = state_61309__$1;
(statearr_61346_61434[(1)] = (30));

} else {
var statearr_61347_61435 = state_61309__$1;
(statearr_61347_61435[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (44))){
var inst_61267 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61348_61436 = state_61309__$1;
(statearr_61348_61436[(2)] = inst_61267);

(statearr_61348_61436[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (6))){
var inst_61165 = (state_61309[(21)]);
var inst_61170 = inst_61165.cljs$lang$protocol_mask$partition0$;
var inst_61171 = (inst_61170 & (64));
var inst_61172 = inst_61165.cljs$core$ISeq$;
var inst_61173 = (cljs.core.PROTOCOL_SENTINEL === inst_61172);
var inst_61174 = ((inst_61171) || (inst_61173));
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61174)){
var statearr_61349_61437 = state_61309__$1;
(statearr_61349_61437[(1)] = (9));

} else {
var statearr_61350_61438 = state_61309__$1;
(statearr_61350_61438[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (28))){
var inst_61239 = (state_61309[(25)]);
var state_61309__$1 = state_61309;
var statearr_61351_61439 = state_61309__$1;
(statearr_61351_61439[(2)] = inst_61239);

(statearr_61351_61439[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (51))){
var inst_61194 = (state_61309[(15)]);
var state_61309__$1 = state_61309;
var statearr_61352_61440 = state_61309__$1;
(statearr_61352_61440[(2)] = inst_61194);

(statearr_61352_61440[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (25))){
var inst_61236 = cljs.core.PersistentHashMap.EMPTY;
var state_61309__$1 = state_61309;
var statearr_61353_61441 = state_61309__$1;
(statearr_61353_61441[(2)] = inst_61236);

(statearr_61353_61441[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (34))){
var state_61309__$1 = state_61309;
var statearr_61354_61442 = state_61309__$1;
(statearr_61354_61442[(2)] = (1000000));

(statearr_61354_61442[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (17))){
var inst_61189 = (state_61309[(22)]);
var inst_61214 = (state_61309[(2)]);
var inst_61215 = sources;
var state_61309__$1 = (function (){var statearr_61355 = state_61309;
(statearr_61355[(26)] = inst_61215);

(statearr_61355[(27)] = inst_61214);

return statearr_61355;
})();
if(cljs.core.truth_(inst_61189)){
var statearr_61356_61443 = state_61309__$1;
(statearr_61356_61443[(1)] = (18));

} else {
var statearr_61357_61444 = state_61309__$1;
(statearr_61357_61444[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (3))){
var inst_61307 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61309__$1,inst_61307);
} else {
if((state_val_61310 === (12))){
var inst_61165 = (state_61309[(21)]);
var inst_61183 = cljs.core.apply.call(null,cljs.core.hash_map,inst_61165);
var state_61309__$1 = state_61309;
var statearr_61358_61445 = state_61309__$1;
(statearr_61358_61445[(2)] = inst_61183);

(statearr_61358_61445[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (2))){
var inst_61165 = (state_61309[(21)]);
var _ = (function (){var statearr_61359 = state_61309;
(statearr_61359[(4)] = cljs.core.cons.call(null,(5),(state_61309[(4)])));

return statearr_61359;
})();
var inst_61165__$1 = flureeQL;
var inst_61167 = (inst_61165__$1 == null);
var inst_61168 = cljs.core.not.call(null,inst_61167);
var state_61309__$1 = (function (){var statearr_61360 = state_61309;
(statearr_61360[(21)] = inst_61165__$1);

return statearr_61360;
})();
if(inst_61168){
var statearr_61361_61446 = state_61309__$1;
(statearr_61361_61446[(1)] = (6));

} else {
var statearr_61362_61447 = state_61309__$1;
(statearr_61362_61447[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (23))){
var inst_61226 = (state_61309[(2)]);
var inst_61227 = fluree.db.util.async.throw_err.call(null,inst_61226);
var state_61309__$1 = state_61309;
var statearr_61363_61448 = state_61309__$1;
(statearr_61363_61448[(2)] = inst_61227);

(statearr_61363_61448[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (47))){
var inst_61265 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61364_61449 = state_61309__$1;
(statearr_61364_61449[(2)] = inst_61265);

(statearr_61364_61449[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (35))){
var inst_61238 = (state_61309[(28)]);
var inst_61249 = (state_61309[(10)]);
var inst_61188 = (state_61309[(23)]);
var inst_61195 = (state_61309[(17)]);
var inst_61254 = (state_61309[(2)]);
var inst_61255 = cljs.core.assoc.call(null,inst_61195,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61238,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61254,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61249);
var state_61309__$1 = (function (){var statearr_61365 = state_61309;
(statearr_61365[(19)] = inst_61255);

return statearr_61365;
})();
if(cljs.core.truth_(inst_61188)){
var statearr_61366_61450 = state_61309__$1;
(statearr_61366_61450[(1)] = (36));

} else {
var statearr_61367_61451 = state_61309__$1;
(statearr_61367_61451[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (19))){
var inst_61215 = (state_61309[(26)]);
var state_61309__$1 = state_61309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61309__$1,(23),inst_61215);
} else {
if((state_val_61310 === (57))){
var inst_61239 = (state_61309[(25)]);
var inst_61293 = (state_61309[(2)]);
var inst_61294 = fluree.db.util.async.throw_err.call(null,inst_61293);
var state_61309__$1 = (function (){var statearr_61368 = state_61309;
(statearr_61368[(7)] = inst_61294);

return statearr_61368;
})();
if(cljs.core.truth_(inst_61239)){
var statearr_61369_61452 = state_61309__$1;
(statearr_61369_61452[(1)] = (58));

} else {
var statearr_61370_61453 = state_61309__$1;
(statearr_61370_61453[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (11))){
var inst_61178 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61372_61454 = state_61309__$1;
(statearr_61372_61454[(2)] = inst_61178);

(statearr_61372_61454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (9))){
var state_61309__$1 = state_61309;
var statearr_61373_61455 = state_61309__$1;
(statearr_61373_61455[(2)] = true);

(statearr_61373_61455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (5))){
var _ = (function (){var statearr_61374 = state_61309;
(statearr_61374[(4)] = cljs.core.rest.call(null,(state_61309[(4)])));

return statearr_61374;
})();
var state_61309__$1 = state_61309;
var ex61371 = (state_61309__$1[(2)]);
var statearr_61375_61456 = state_61309__$1;
(statearr_61375_61456[(5)] = ex61371);


if((ex61371 instanceof Error)){
var statearr_61376_61457 = state_61309__$1;
(statearr_61376_61457[(1)] = (4));

(statearr_61376_61457[(5)] = null);

} else {
throw ex61371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (14))){
var inst_61190 = (state_61309[(29)]);
var inst_61192 = (state_61309[(18)]);
var inst_61187 = (state_61309[(14)]);
var inst_61188 = (state_61309[(23)]);
var inst_61191 = (state_61309[(8)]);
var inst_61194 = (state_61309[(15)]);
var inst_61196 = (state_61309[(24)]);
var inst_61195 = (state_61309[(17)]);
var inst_61189 = (state_61309[(22)]);
var inst_61193 = (state_61309[(13)]);
var inst_61186 = (state_61309[(2)]);
var inst_61187__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61188__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61189__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61190__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61191__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61192__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61193__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61194__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61195__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61196__$1 = cljs.core.get.call(null,inst_61186,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61197 = (function (){var construct = inst_61187__$1;
var select = inst_61188__$1;
var block = inst_61189__$1;
var where = inst_61190__$1;
var prefixes = inst_61191__$1;
var map__61164 = inst_61186;
var selectDistinct = inst_61192__$1;
var selectOne = inst_61193__$1;
var from = inst_61194__$1;
var opts = inst_61195__$1;
var selectReduced = inst_61196__$1;
return (function (p1__61157_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__61157_SHARP_);
});
})();
var inst_61198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61199 = [inst_61188__$1,inst_61193__$1,inst_61192__$1,inst_61196__$1];
var inst_61200 = (new cljs.core.PersistentVector(null,4,(5),inst_61198,inst_61199,null));
var inst_61201 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_61200);
var inst_61202 = cljs.core.count.call(null,inst_61201);
var inst_61203 = inst_61197.call(null,inst_61202);
var state_61309__$1 = (function (){var statearr_61377 = state_61309;
(statearr_61377[(29)] = inst_61190__$1);

(statearr_61377[(18)] = inst_61192__$1);

(statearr_61377[(14)] = inst_61187__$1);

(statearr_61377[(23)] = inst_61188__$1);

(statearr_61377[(8)] = inst_61191__$1);

(statearr_61377[(15)] = inst_61194__$1);

(statearr_61377[(24)] = inst_61196__$1);

(statearr_61377[(17)] = inst_61195__$1);

(statearr_61377[(22)] = inst_61189__$1);

(statearr_61377[(13)] = inst_61193__$1);

return statearr_61377;
})();
if(cljs.core.truth_(inst_61203)){
var statearr_61378_61458 = state_61309__$1;
(statearr_61378_61458[(1)] = (15));

} else {
var statearr_61379_61459 = state_61309__$1;
(statearr_61379_61459[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (45))){
var inst_61196 = (state_61309[(24)]);
var state_61309__$1 = state_61309;
var statearr_61380_61460 = state_61309__$1;
(statearr_61380_61460[(2)] = inst_61196);

(statearr_61380_61460[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (53))){
var inst_61276 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
var statearr_61381_61461 = state_61309__$1;
(statearr_61381_61461[(2)] = inst_61276);

(statearr_61381_61461[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (26))){
var inst_61240 = (state_61309[(12)]);
var inst_61195 = (state_61309[(17)]);
var inst_61238 = (state_61309[(2)]);
var inst_61239 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61195);
var inst_61240__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61195);
var state_61309__$1 = (function (){var statearr_61382 = state_61309;
(statearr_61382[(28)] = inst_61238);

(statearr_61382[(12)] = inst_61240__$1);

(statearr_61382[(25)] = inst_61239);

return statearr_61382;
})();
if(cljs.core.truth_(inst_61240__$1)){
var statearr_61383_61462 = state_61309__$1;
(statearr_61383_61462[(1)] = (27));

} else {
var statearr_61384_61463 = state_61309__$1;
(statearr_61384_61463[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (16))){
var inst_61206 = cljs.core.pr_str.call(null,flureeQL);
var inst_61207 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61206].join('');
var inst_61208 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61209 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61210 = cljs.core.PersistentHashMap.fromArrays(inst_61208,inst_61209);
var inst_61211 = cljs.core.ex_info.call(null,inst_61207,inst_61210);
var inst_61212 = (function(){throw inst_61211})();
var state_61309__$1 = state_61309;
var statearr_61385_61464 = state_61309__$1;
(statearr_61385_61464[(2)] = inst_61212);

(statearr_61385_61464[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (38))){
var inst_61271 = (state_61309[(30)]);
var inst_61271__$1 = (state_61309[(2)]);
var state_61309__$1 = (function (){var statearr_61386 = state_61309;
(statearr_61386[(30)] = inst_61271__$1);

return statearr_61386;
})();
if(cljs.core.truth_(inst_61271__$1)){
var statearr_61387_61465 = state_61309__$1;
(statearr_61387_61465[(1)] = (48));

} else {
var statearr_61388_61466 = state_61309__$1;
(statearr_61388_61466[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (30))){
var inst_61246 = cljs.core.volatile_BANG_.call(null,(0));
var state_61309__$1 = state_61309;
var statearr_61389_61467 = state_61309__$1;
(statearr_61389_61467[(2)] = inst_61246);

(statearr_61389_61467[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (10))){
var state_61309__$1 = state_61309;
var statearr_61390_61468 = state_61309__$1;
(statearr_61390_61468[(2)] = false);

(statearr_61390_61468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (18))){
var inst_61215 = (state_61309[(26)]);
var state_61309__$1 = state_61309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61309__$1,(22),inst_61215);
} else {
if((state_val_61310 === (52))){
var inst_61190 = (state_61309[(29)]);
var state_61309__$1 = state_61309;
var statearr_61391_61469 = state_61309__$1;
(statearr_61391_61469[(2)] = inst_61190);

(statearr_61391_61469[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (42))){
var inst_61192 = (state_61309[(18)]);
var state_61309__$1 = state_61309;
var statearr_61392_61470 = state_61309__$1;
(statearr_61392_61470[(2)] = inst_61192);

(statearr_61392_61470[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (37))){
var inst_61193 = (state_61309[(13)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61193)){
var statearr_61393_61471 = state_61309__$1;
(statearr_61393_61471[(1)] = (39));

} else {
var statearr_61394_61472 = state_61309__$1;
(statearr_61394_61472[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (8))){
var inst_61181 = (state_61309[(2)]);
var state_61309__$1 = state_61309;
if(cljs.core.truth_(inst_61181)){
var statearr_61395_61473 = state_61309__$1;
(statearr_61395_61473[(1)] = (12));

} else {
var statearr_61396_61474 = state_61309__$1;
(statearr_61396_61474[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61310 === (49))){
var inst_61271 = (state_61309[(30)]);
var state_61309__$1 = state_61309;
var statearr_61397_61475 = state_61309__$1;
(statearr_61397_61475[(2)] = inst_61271);

(statearr_61397_61475[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2468__auto____0 = (function (){
var statearr_61398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61398[(0)] = fluree$db$api$query$query_async_$_state_machine__2468__auto__);

(statearr_61398[(1)] = (1));

return statearr_61398;
});
var fluree$db$api$query$query_async_$_state_machine__2468__auto____1 = (function (state_61309){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_61309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e61399){var ex__2471__auto__ = e61399;
var statearr_61400_61476 = state_61309;
(statearr_61400_61476[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_61309[(4)]))){
var statearr_61401_61477 = state_61309;
(statearr_61401_61477[(1)] = cljs.core.first.call(null,(state_61309[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61478 = state_61309;
state_61309 = G__61478;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2468__auto__ = function(state_61309){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2468__auto____1.call(this,state_61309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2468__auto____0;
fluree$db$api$query$query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2468__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_61402 = f__2491__auto__.call(null);
(statearr_61402[(6)] = c__2490__auto__);

return statearr_61402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_61632){
var state_val_61633 = (state_61632[(1)]);
if((state_val_61633 === (7))){
var inst_61627 = (state_61632[(2)]);
var _ = (function (){var statearr_61634 = state_61632;
(statearr_61634[(4)] = cljs.core.rest.call(null,(state_61632[(4)])));

return statearr_61634;
})();
var state_61632__$1 = state_61632;
var statearr_61635_61714 = state_61632__$1;
(statearr_61635_61714[(2)] = inst_61627);

(statearr_61635_61714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (20))){
var inst_61548 = (state_61632[(7)]);
var inst_61566 = cljs.core.apply.call(null,cljs.core.hash_map,inst_61548);
var state_61632__$1 = state_61632;
var statearr_61636_61715 = state_61632__$1;
(statearr_61636_61715[(2)] = inst_61566);

(statearr_61636_61715[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (27))){
var inst_61576 = (state_61632[(8)]);
var state_61632__$1 = state_61632;
var statearr_61637_61716 = state_61632__$1;
(statearr_61637_61716[(2)] = inst_61576);

(statearr_61637_61716[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (1))){
var state_61632__$1 = state_61632;
var statearr_61638_61717 = state_61632__$1;
(statearr_61638_61717[(2)] = null);

(statearr_61638_61717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (24))){
var inst_61573 = (state_61632[(9)]);
var inst_61518 = (state_61632[(10)]);
var inst_61576 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61573);
var inst_61577 = (inst_61518 == null);
var state_61632__$1 = (function (){var statearr_61639 = state_61632;
(statearr_61639[(8)] = inst_61576);

return statearr_61639;
})();
if(cljs.core.truth_(inst_61577)){
var statearr_61640_61718 = state_61632__$1;
(statearr_61640_61718[(1)] = (27));

} else {
var statearr_61641_61719 = state_61632__$1;
(statearr_61641_61719[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (39))){
var inst_61573 = (state_61632[(9)]);
var inst_61519 = (state_61632[(11)]);
var inst_61604 = cljs.core.get.call(null,inst_61573,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61605 = (inst_61519 + inst_61604);
var state_61632__$1 = state_61632;
var statearr_61642_61720 = state_61632__$1;
(statearr_61642_61720[(2)] = inst_61605);

(statearr_61642_61720[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (46))){
var inst_61573 = (state_61632[(9)]);
var state_61632__$1 = state_61632;
var statearr_61643_61721 = state_61632__$1;
(statearr_61643_61721[(2)] = inst_61573);

(statearr_61643_61721[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (4))){
var inst_61479 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61644_61722 = state_61632__$1;
(statearr_61644_61722[(2)] = inst_61479);

(statearr_61644_61722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (15))){
var state_61632__$1 = state_61632;
var statearr_61645_61723 = state_61632__$1;
(statearr_61645_61723[(2)] = false);

(statearr_61645_61723[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (21))){
var inst_61548 = (state_61632[(7)]);
var state_61632__$1 = state_61632;
var statearr_61646_61724 = state_61632__$1;
(statearr_61646_61724[(2)] = inst_61548);

(statearr_61646_61724[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (31))){
var inst_61576 = (state_61632[(8)]);
var inst_61518 = (state_61632[(10)]);
var inst_61583 = cljs.core._EQ_.call(null,(200),inst_61576);
var inst_61584 = cljs.core._EQ_.call(null,(200),inst_61518);
var inst_61585 = cljs.core._EQ_.call(null,(207),inst_61518);
var inst_61586 = ((inst_61583) || (inst_61584) || (inst_61585));
var state_61632__$1 = state_61632;
if(cljs.core.truth_(inst_61586)){
var statearr_61647_61725 = state_61632__$1;
(statearr_61647_61725[(1)] = (33));

} else {
var statearr_61648_61726 = state_61632__$1;
(statearr_61648_61726[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (32))){
var inst_61597 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61649_61727 = state_61632__$1;
(statearr_61649_61727[(2)] = inst_61597);

(statearr_61649_61727[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (40))){
var state_61632__$1 = state_61632;
var statearr_61650_61728 = state_61632__$1;
(statearr_61650_61728[(2)] = null);

(statearr_61650_61728[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (33))){
var state_61632__$1 = state_61632;
var statearr_61651_61729 = state_61632__$1;
(statearr_61651_61729[(2)] = (207));

(statearr_61651_61729[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (13))){
var inst_61542 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61652_61730 = state_61632__$1;
(statearr_61652_61730[(2)] = inst_61542);

(statearr_61652_61730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (22))){
var inst_61532 = (state_61632[(12)]);
var inst_61569 = (state_61632[(2)]);
var inst_61570 = cljs.core.get.call(null,inst_61569,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61571 = cljs.core.get.call(null,inst_61569,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61632__$1 = (function (){var statearr_61653 = state_61632;
(statearr_61653[(13)] = inst_61570);

(statearr_61653[(14)] = inst_61571);

return statearr_61653;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61632__$1,(23),inst_61532);
} else {
if((state_val_61633 === (36))){
var inst_61576 = (state_61632[(8)]);
var inst_61518 = (state_61632[(10)]);
var inst_61590 = ((inst_61576 > inst_61518) ? inst_61576 : inst_61518);
var state_61632__$1 = state_61632;
var statearr_61654_61731 = state_61632__$1;
(statearr_61654_61731[(2)] = inst_61590);

(statearr_61654_61731[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (41))){
var inst_61574 = (state_61632[(15)]);
var inst_61608 = (state_61632[(2)]);
var state_61632__$1 = (function (){var statearr_61655 = state_61632;
(statearr_61655[(16)] = inst_61608);

return statearr_61655;
})();
if(cljs.core.truth_(inst_61574)){
var statearr_61656_61732 = state_61632__$1;
(statearr_61656_61732[(1)] = (42));

} else {
var statearr_61657_61733 = state_61632__$1;
(statearr_61657_61733[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (43))){
var inst_61571 = (state_61632[(14)]);
var state_61632__$1 = state_61632;
if(cljs.core.truth_(inst_61571)){
var statearr_61658_61734 = state_61632__$1;
(statearr_61658_61734[(1)] = (45));

} else {
var statearr_61659_61735 = state_61632__$1;
(statearr_61659_61735[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (29))){
var inst_61599 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61660_61736 = state_61632__$1;
(statearr_61660_61736[(2)] = inst_61599);

(statearr_61660_61736[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (44))){
var inst_61608 = (state_61632[(16)]);
var inst_61602 = (state_61632[(17)]);
var inst_61530 = (state_61632[(18)]);
var inst_61622 = (state_61632[(2)]);
var inst_61517 = inst_61530;
var inst_61518 = inst_61602;
var inst_61519 = inst_61608;
var inst_61520 = inst_61622;
var state_61632__$1 = (function (){var statearr_61661 = state_61632;
(statearr_61661[(19)] = inst_61520);

(statearr_61661[(20)] = inst_61517);

(statearr_61661[(10)] = inst_61518);

(statearr_61661[(11)] = inst_61519);

return statearr_61661;
})();
var statearr_61662_61737 = state_61632__$1;
(statearr_61662_61737[(2)] = null);

(statearr_61662_61737[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (6))){
var inst_61532 = (state_61632[(12)]);
var inst_61517 = (state_61632[(20)]);
var inst_61528 = cljs.core.seq.call(null,inst_61517);
var inst_61529 = cljs.core.first.call(null,inst_61528);
var inst_61530 = cljs.core.next.call(null,inst_61528);
var inst_61531 = cljs.core.nth.call(null,inst_61529,(0),null);
var inst_61532__$1 = cljs.core.nth.call(null,inst_61529,(1),null);
var inst_61533 = (inst_61532__$1 == null);
var state_61632__$1 = (function (){var statearr_61663 = state_61632;
(statearr_61663[(12)] = inst_61532__$1);

(statearr_61663[(18)] = inst_61530);

(statearr_61663[(21)] = inst_61531);

return statearr_61663;
})();
if(cljs.core.truth_(inst_61533)){
var statearr_61664_61738 = state_61632__$1;
(statearr_61664_61738[(1)] = (8));

} else {
var statearr_61665_61739 = state_61632__$1;
(statearr_61665_61739[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (28))){
var inst_61576 = (state_61632[(8)]);
var inst_61518 = (state_61632[(10)]);
var inst_61580 = cljs.core._EQ_.call(null,inst_61518,inst_61576);
var state_61632__$1 = state_61632;
if(inst_61580){
var statearr_61666_61740 = state_61632__$1;
(statearr_61666_61740[(1)] = (30));

} else {
var statearr_61667_61741 = state_61632__$1;
(statearr_61667_61741[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (25))){
var state_61632__$1 = state_61632;
var statearr_61668_61742 = state_61632__$1;
(statearr_61668_61742[(2)] = null);

(statearr_61668_61742[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (34))){
var state_61632__$1 = state_61632;
var statearr_61669_61743 = state_61632__$1;
(statearr_61669_61743[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (17))){
var state_61632__$1 = state_61632;
var statearr_61671_61744 = state_61632__$1;
(statearr_61671_61744[(2)] = true);

(statearr_61671_61744[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (3))){
var inst_61630 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61632__$1,inst_61630);
} else {
if((state_val_61633 === (12))){
var inst_61520 = (state_61632[(19)]);
var state_61632__$1 = state_61632;
var statearr_61672_61745 = state_61632__$1;
(statearr_61672_61745[(2)] = inst_61520);

(statearr_61672_61745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (2))){
var inst_61493 = (state_61632[(22)]);
var inst_61494 = (state_61632[(23)]);
var inst_61489 = (state_61632[(24)]);
var _ = (function (){var statearr_61673 = state_61632;
(statearr_61673[(4)] = cljs.core.cons.call(null,(5),(state_61632[(4)])));

return statearr_61673;
})();
var inst_61485 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61487 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61488 = (new cljs.core.PersistentVector(null,2,(5),inst_61486,inst_61487,null));
var inst_61489__$1 = cljs.core.get_in.call(null,flureeQL,inst_61488);
var inst_61490 = (function (){var global_block = inst_61485;
var global_meta_QMARK_ = inst_61489__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_61491 = cljs.core.PersistentHashMap.EMPTY;
var inst_61492 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_61493__$1 = cljs.core.reduce_kv.call(null,inst_61490,inst_61491,inst_61492);
var inst_61494__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_61496 = (function (){var global_block = inst_61485;
var global_meta_QMARK_ = inst_61489__$1;
var queries = inst_61493__$1;
var start_time = inst_61494__$1;
return (function (p__61495){
var vec__61674 = p__61495;
var alias = cljs.core.nth.call(null,vec__61674,(0),null);
var q = cljs.core.nth.call(null,vec__61674,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_61497 = cljs.core.map.call(null,inst_61496,inst_61493__$1);
var inst_61511 = cljs.core.seq.call(null,inst_61497);
var inst_61512 = cljs.core.first.call(null,inst_61511);
var inst_61513 = cljs.core.next.call(null,inst_61511);
var inst_61514 = cljs.core.nth.call(null,inst_61512,(0),null);
var inst_61515 = cljs.core.nth.call(null,inst_61512,(1),null);
var inst_61516 = cljs.core.PersistentHashMap.EMPTY;
var inst_61517 = inst_61497;
var inst_61518 = null;
var inst_61519 = (0);
var inst_61520 = inst_61516;
var state_61632__$1 = (function (){var statearr_61677 = state_61632;
(statearr_61677[(19)] = inst_61520);

(statearr_61677[(22)] = inst_61493__$1);

(statearr_61677[(20)] = inst_61517);

(statearr_61677[(23)] = inst_61494__$1);

(statearr_61677[(25)] = inst_61515);

(statearr_61677[(24)] = inst_61489__$1);

(statearr_61677[(26)] = inst_61513);

(statearr_61677[(10)] = inst_61518);

(statearr_61677[(27)] = inst_61514);

(statearr_61677[(11)] = inst_61519);

return statearr_61677;
})();
var statearr_61678_61746 = state_61632__$1;
(statearr_61678_61746[(2)] = null);

(statearr_61678_61746[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (23))){
var inst_61573 = (state_61632[(9)]);
var inst_61570 = (state_61632[(13)]);
var inst_61573__$1 = (state_61632[(2)]);
var inst_61574 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61573__$1);
var state_61632__$1 = (function (){var statearr_61679 = state_61632;
(statearr_61679[(9)] = inst_61573__$1);

(statearr_61679[(15)] = inst_61574);

return statearr_61679;
})();
if(cljs.core.truth_(inst_61570)){
var statearr_61680_61747 = state_61632__$1;
(statearr_61680_61747[(1)] = (24));

} else {
var statearr_61681_61748 = state_61632__$1;
(statearr_61681_61748[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (47))){
var inst_61520 = (state_61632[(19)]);
var inst_61531 = (state_61632[(21)]);
var inst_61619 = (state_61632[(2)]);
var inst_61620 = cljs.core.assoc.call(null,inst_61520,inst_61531,inst_61619);
var state_61632__$1 = state_61632;
var statearr_61682_61749 = state_61632__$1;
(statearr_61682_61749[(2)] = inst_61620);

(statearr_61682_61749[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (35))){
var inst_61595 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61683_61750 = state_61632__$1;
(statearr_61683_61750[(2)] = inst_61595);

(statearr_61683_61750[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (19))){
var inst_61561 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61684_61751 = state_61632__$1;
(statearr_61684_61751[(2)] = inst_61561);

(statearr_61684_61751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (11))){
var inst_61520 = (state_61632[(19)]);
var inst_61494 = (state_61632[(23)]);
var inst_61518 = (state_61632[(10)]);
var inst_61519 = (state_61632[(11)]);
var inst_61536 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61537 = fluree.db.api.query.response_time_formatted.call(null,inst_61494);
var inst_61538 = [inst_61520,inst_61519,inst_61518,inst_61537];
var inst_61539 = cljs.core.PersistentHashMap.fromArrays(inst_61536,inst_61538);
var state_61632__$1 = state_61632;
var statearr_61686_61752 = state_61632__$1;
(statearr_61686_61752[(2)] = inst_61539);

(statearr_61686_61752[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (9))){
var inst_61493 = (state_61632[(22)]);
var inst_61548 = (state_61632[(7)]);
var inst_61531 = (state_61632[(21)]);
var inst_61545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61546 = [inst_61531,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61547 = (new cljs.core.PersistentVector(null,2,(5),inst_61545,inst_61546,null));
var inst_61548__$1 = cljs.core.get_in.call(null,inst_61493,inst_61547);
var inst_61550 = (inst_61548__$1 == null);
var inst_61551 = cljs.core.not.call(null,inst_61550);
var state_61632__$1 = (function (){var statearr_61687 = state_61632;
(statearr_61687[(7)] = inst_61548__$1);

return statearr_61687;
})();
if(inst_61551){
var statearr_61688_61753 = state_61632__$1;
(statearr_61688_61753[(1)] = (14));

} else {
var statearr_61689_61754 = state_61632__$1;
(statearr_61689_61754[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (5))){
var _ = (function (){var statearr_61690 = state_61632;
(statearr_61690[(4)] = cljs.core.rest.call(null,(state_61632[(4)])));

return statearr_61690;
})();
var state_61632__$1 = state_61632;
var ex61685 = (state_61632__$1[(2)]);
var statearr_61691_61755 = state_61632__$1;
(statearr_61691_61755[(5)] = ex61685);


if((ex61685 instanceof java.lang.Exception)){
var statearr_61692_61756 = state_61632__$1;
(statearr_61692_61756[(1)] = (4));

(statearr_61692_61756[(5)] = null);

} else {
throw ex61685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (14))){
var inst_61548 = (state_61632[(7)]);
var inst_61553 = inst_61548.cljs$lang$protocol_mask$partition0$;
var inst_61554 = (inst_61553 & (64));
var inst_61555 = inst_61548.cljs$core$ISeq$;
var inst_61556 = (cljs.core.PROTOCOL_SENTINEL === inst_61555);
var inst_61557 = ((inst_61554) || (inst_61556));
var state_61632__$1 = state_61632;
if(cljs.core.truth_(inst_61557)){
var statearr_61693_61757 = state_61632__$1;
(statearr_61693_61757[(1)] = (17));

} else {
var statearr_61694_61758 = state_61632__$1;
(statearr_61694_61758[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (45))){
var inst_61573 = (state_61632[(9)]);
var inst_61616 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61573);
var state_61632__$1 = state_61632;
var statearr_61695_61759 = state_61632__$1;
(statearr_61695_61759[(2)] = inst_61616);

(statearr_61695_61759[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (26))){
var inst_61570 = (state_61632[(13)]);
var inst_61602 = (state_61632[(2)]);
var state_61632__$1 = (function (){var statearr_61696 = state_61632;
(statearr_61696[(17)] = inst_61602);

return statearr_61696;
})();
if(cljs.core.truth_(inst_61570)){
var statearr_61697_61760 = state_61632__$1;
(statearr_61697_61760[(1)] = (39));

} else {
var statearr_61698_61761 = state_61632__$1;
(statearr_61698_61761[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (16))){
var inst_61564 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
if(cljs.core.truth_(inst_61564)){
var statearr_61699_61762 = state_61632__$1;
(statearr_61699_61762[(1)] = (20));

} else {
var statearr_61700_61763 = state_61632__$1;
(statearr_61700_61763[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (38))){
var inst_61593 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61701_61764 = state_61632__$1;
(statearr_61701_61764[(2)] = inst_61593);

(statearr_61701_61764[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (30))){
var inst_61576 = (state_61632[(8)]);
var state_61632__$1 = state_61632;
var statearr_61702_61765 = state_61632__$1;
(statearr_61702_61765[(2)] = inst_61576);

(statearr_61702_61765[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (10))){
var inst_61625 = (state_61632[(2)]);
var state_61632__$1 = state_61632;
var statearr_61703_61766 = state_61632__$1;
(statearr_61703_61766[(2)] = inst_61625);

(statearr_61703_61766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (18))){
var state_61632__$1 = state_61632;
var statearr_61704_61767 = state_61632__$1;
(statearr_61704_61767[(2)] = false);

(statearr_61704_61767[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (42))){
var inst_61573 = (state_61632[(9)]);
var inst_61520 = (state_61632[(19)]);
var inst_61531 = (state_61632[(21)]);
var inst_61610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61611 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61531];
var inst_61612 = (new cljs.core.PersistentVector(null,2,(5),inst_61610,inst_61611,null));
var inst_61613 = cljs.core.assoc_in.call(null,inst_61520,inst_61612,inst_61573);
var state_61632__$1 = state_61632;
var statearr_61705_61768 = state_61632__$1;
(statearr_61705_61768[(2)] = inst_61613);

(statearr_61705_61768[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (37))){
var state_61632__$1 = state_61632;
var statearr_61706_61769 = state_61632__$1;
(statearr_61706_61769[(2)] = null);

(statearr_61706_61769[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61633 === (8))){
var inst_61489 = (state_61632[(24)]);
var state_61632__$1 = state_61632;
if(cljs.core.truth_(inst_61489)){
var statearr_61707_61770 = state_61632__$1;
(statearr_61707_61770[(1)] = (11));

} else {
var statearr_61708_61771 = state_61632__$1;
(statearr_61708_61771[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____0 = (function (){
var statearr_61709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61709[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__);

(statearr_61709[(1)] = (1));

return statearr_61709;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____1 = (function (state_61632){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_61632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e61710){var ex__2471__auto__ = e61710;
var statearr_61711_61772 = state_61632;
(statearr_61711_61772[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_61632[(4)]))){
var statearr_61712_61773 = state_61632;
(statearr_61712_61773[(1)] = cljs.core.first.call(null,(state_61632[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61774 = state_61632;
state_61632 = G__61774;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__ = function(state_61632){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____1.call(this,state_61632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2468__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_61713 = f__2491__auto__.call(null);
(statearr_61713[(6)] = c__2490__auto__);

return statearr_61713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__61775 = query_type;
var G__61775__$1 = (((G__61775 instanceof cljs.core.Keyword))?G__61775.fqn:null);
switch (G__61775__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61775__$1)].join('')));

}
});

//# sourceMappingURL=query.js.map
