// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18032 = arguments.length;
switch (G__18032) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18035 = arguments.length;
switch (G__18035) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2490__auto___18088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_18066){
var state_val_18067 = (state_18066[(1)]);
if((state_val_18067 === (1))){
var state_18066__$1 = state_18066;
var statearr_18068_18089 = state_18066__$1;
(statearr_18068_18089[(2)] = null);

(statearr_18068_18089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (2))){
var _ = (function (){var statearr_18069 = state_18066;
(statearr_18069[(4)] = cljs.core.cons.call(null,(5),(state_18066[(4)])));

return statearr_18069;
})();
var inst_18043 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_18066__$1 = state_18066;
if(cljs.core.truth_(inst_18043)){
var statearr_18070_18090 = state_18066__$1;
(statearr_18070_18090[(1)] = (6));

} else {
var statearr_18071_18091 = state_18066__$1;
(statearr_18071_18091[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (3))){
var inst_18064 = (state_18066[(2)]);
var state_18066__$1 = state_18066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18066__$1,inst_18064);
} else {
if((state_val_18067 === (4))){
var inst_18036 = (state_18066[(2)]);
var inst_18037 = cljs.core.async.put_BANG_.call(null,pc,inst_18036);
var state_18066__$1 = state_18066;
var statearr_18073_18092 = state_18066__$1;
(statearr_18073_18092[(2)] = inst_18037);

(statearr_18073_18092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (5))){
var _ = (function (){var statearr_18074 = state_18066;
(statearr_18074[(4)] = cljs.core.rest.call(null,(state_18066[(4)])));

return statearr_18074;
})();
var state_18066__$1 = state_18066;
var ex18072 = (state_18066__$1[(2)]);
var statearr_18075_18093 = state_18066__$1;
(statearr_18075_18093[(5)] = ex18072);


if((ex18072 instanceof java.lang.Exception)){
var statearr_18076_18094 = state_18066__$1;
(statearr_18076_18094[(1)] = (4));

(statearr_18076_18094[(5)] = null);

} else {
throw ex18072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (6))){
var inst_18045 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18046 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18047 = cljs.core.PersistentHashMap.fromArrays(inst_18045,inst_18046);
var inst_18048 = cljs.core.ex_info.call(null,"Connection was closed.",inst_18047);
var inst_18049 = (function(){throw inst_18048})();
var state_18066__$1 = state_18066;
var statearr_18077_18095 = state_18066__$1;
(statearr_18077_18095[(2)] = inst_18049);

(statearr_18077_18095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (7))){
var inst_18051 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18053 = [operation,data,pc,opts];
var inst_18054 = (new cljs.core.PersistentVector(null,4,(5),inst_18052,inst_18053,null));
var inst_18055 = cljs.core.async.put_BANG_.call(null,inst_18051,inst_18054);
var inst_18056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18057 = [operation,data,pc,opts];
var inst_18058 = (new cljs.core.PersistentVector(null,4,(5),inst_18056,inst_18057,null));
var inst_18059 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18058);
var state_18066__$1 = (function (){var statearr_18078 = state_18066;
(statearr_18078[(7)] = inst_18055);

return statearr_18078;
})();
var statearr_18079_18096 = state_18066__$1;
(statearr_18079_18096[(2)] = inst_18059);

(statearr_18079_18096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18067 === (8))){
var inst_18061 = (state_18066[(2)]);
var _ = (function (){var statearr_18080 = state_18066;
(statearr_18080[(4)] = cljs.core.rest.call(null,(state_18066[(4)])));

return statearr_18080;
})();
var state_18066__$1 = state_18066;
var statearr_18081_18097 = state_18066__$1;
(statearr_18081_18097[(2)] = inst_18061);

(statearr_18081_18097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2468__auto__ = null;
var fluree$db$operations$state_machine__2468__auto____0 = (function (){
var statearr_18082 = [null,null,null,null,null,null,null,null];
(statearr_18082[(0)] = fluree$db$operations$state_machine__2468__auto__);

(statearr_18082[(1)] = (1));

return statearr_18082;
});
var fluree$db$operations$state_machine__2468__auto____1 = (function (state_18066){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_18066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e18083){var ex__2471__auto__ = e18083;
var statearr_18084_18098 = state_18066;
(statearr_18084_18098[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_18066[(4)]))){
var statearr_18085_18099 = state_18066;
(statearr_18085_18099[(1)] = cljs.core.first.call(null,(state_18066[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18100 = state_18066;
state_18066 = G__18100;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2468__auto__ = function(state_18066){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2468__auto____1.call(this,state_18066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2468__auto____0;
fluree$db$operations$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2468__auto____1;
return fluree$db$operations$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_18086 = f__2491__auto__.call(null);
(statearr_18086[(6)] = c__2490__auto___18088);

return statearr_18086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18102 = arguments.length;
switch (G__18102) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18103){
var map__18104 = p__18103;
var map__18104__$1 = (((((!((map__18104 == null))))?(((((map__18104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18104):map__18104);
var opts = map__18104__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__18104__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18106 = session;
var map__18106__$1 = (((((!((map__18106 == null))))?(((((map__18106.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18106.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18106):map__18106);
var dbid = cljs.core.get.call(null,map__18106__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__18106__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__18106__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___18168 = arguments.length;
var i__4737__auto___18169 = (0);
while(true){
if((i__4737__auto___18169 < len__4736__auto___18168)){
args__4742__auto__.push((arguments[i__4737__auto___18169]));

var G__18170 = (i__4737__auto___18169 + (1));
i__4737__auto___18169 = G__18170;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18111){
var vec__18112 = p__18111;
var map__18115 = cljs.core.nth.call(null,vec__18112,(0),null);
var map__18115__$1 = (((((!((map__18115 == null))))?(((((map__18115.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18115.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18115):map__18115);
var toBlock = cljs.core.get.call(null,map__18115__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__18115__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18112;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_18148){
var state_val_18149 = (state_18148[(1)]);
if((state_val_18149 === (7))){
var inst_18131 = (state_18148[(2)]);
var state_18148__$1 = state_18148;
var statearr_18150_18171 = state_18148__$1;
(statearr_18150_18171[(2)] = inst_18131);

(statearr_18150_18171[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (1))){
var inst_18118 = (state_18148[(7)]);
var inst_18118__$1 = session;
var inst_18120 = (inst_18118__$1 == null);
var inst_18121 = cljs.core.not.call(null,inst_18120);
var state_18148__$1 = (function (){var statearr_18151 = state_18148;
(statearr_18151[(7)] = inst_18118__$1);

return statearr_18151;
})();
if(inst_18121){
var statearr_18152_18172 = state_18148__$1;
(statearr_18152_18172[(1)] = (2));

} else {
var statearr_18153_18173 = state_18148__$1;
(statearr_18153_18173[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (4))){
var inst_18134 = (state_18148[(2)]);
var state_18148__$1 = state_18148;
if(cljs.core.truth_(inst_18134)){
var statearr_18154_18174 = state_18148__$1;
(statearr_18154_18174[(1)] = (8));

} else {
var statearr_18155_18175 = state_18148__$1;
(statearr_18155_18175[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (6))){
var state_18148__$1 = state_18148;
var statearr_18156_18176 = state_18148__$1;
(statearr_18156_18176[(2)] = false);

(statearr_18156_18176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (3))){
var state_18148__$1 = state_18148;
var statearr_18157_18177 = state_18148__$1;
(statearr_18157_18177[(2)] = false);

(statearr_18157_18177[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (2))){
var inst_18118 = (state_18148[(7)]);
var inst_18123 = inst_18118.cljs$lang$protocol_mask$partition0$;
var inst_18124 = (inst_18123 & (64));
var inst_18125 = inst_18118.cljs$core$ISeq$;
var inst_18126 = (cljs.core.PROTOCOL_SENTINEL === inst_18125);
var inst_18127 = ((inst_18124) || (inst_18126));
var state_18148__$1 = state_18148;
if(cljs.core.truth_(inst_18127)){
var statearr_18158_18178 = state_18148__$1;
(statearr_18158_18178[(1)] = (5));

} else {
var statearr_18159_18179 = state_18148__$1;
(statearr_18159_18179[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (9))){
var inst_18118 = (state_18148[(7)]);
var state_18148__$1 = state_18148;
var statearr_18160_18180 = state_18148__$1;
(statearr_18160_18180[(2)] = inst_18118);

(statearr_18160_18180[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (5))){
var state_18148__$1 = state_18148;
var statearr_18161_18181 = state_18148__$1;
(statearr_18161_18181[(2)] = true);

(statearr_18161_18181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18149 === (10))){
var inst_18139 = (state_18148[(2)]);
var inst_18140 = cljs.core.get.call(null,inst_18139,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18141 = cljs.core.get.call(null,inst_18139,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18142 = cljs.core.get.call(null,inst_18139,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18143 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18144 = [inst_18140,inst_18141,toBlock,toTime];
var inst_18145 = cljs.core.PersistentHashMap.fromArrays(inst_18143,inst_18144);
var inst_18146 = fluree.db.operations.send_operation.call(null,inst_18142,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18145);
var state_18148__$1 = state_18148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18148__$1,inst_18146);
} else {
if((state_val_18149 === (8))){
var inst_18118 = (state_18148[(7)]);
var inst_18136 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18118);
var state_18148__$1 = state_18148;
var statearr_18162_18182 = state_18148__$1;
(statearr_18162_18182[(2)] = inst_18136);

(statearr_18162_18182[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2468__auto__ = null;
var fluree$db$operations$state_machine__2468__auto____0 = (function (){
var statearr_18163 = [null,null,null,null,null,null,null,null];
(statearr_18163[(0)] = fluree$db$operations$state_machine__2468__auto__);

(statearr_18163[(1)] = (1));

return statearr_18163;
});
var fluree$db$operations$state_machine__2468__auto____1 = (function (state_18148){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_18148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e18164){var ex__2471__auto__ = e18164;
var statearr_18165_18183 = state_18148;
(statearr_18165_18183[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_18148[(4)]))){
var statearr_18166_18184 = state_18148;
(statearr_18166_18184[(1)] = cljs.core.first.call(null,(state_18148[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18185 = state_18148;
state_18148 = G__18185;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2468__auto__ = function(state_18148){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2468__auto____1.call(this,state_18148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2468__auto____0;
fluree$db$operations$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2468__auto____1;
return fluree$db$operations$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_18167 = f__2491__auto__.call(null);
(statearr_18167[(6)] = c__2490__auto__);

return statearr_18167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18109){
var G__18110 = cljs.core.first.call(null,seq18109);
var seq18109__$1 = cljs.core.next.call(null,seq18109);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18110,seq18109__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18186 = session;
var map__18186__$1 = (((((!((map__18186 == null))))?(((((map__18186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18186):map__18186);
var network = cljs.core.get.call(null,map__18186__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__18186__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__18186__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18189 = arguments.length;
switch (G__18189) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18190 = opts;
var map__18190__$1 = (((((!((map__18190 == null))))?(((((map__18190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18190.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18190):map__18190);
var auth = cljs.core.get.call(null,map__18190__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__18190__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});

//# sourceMappingURL=operations.js.map
