// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_12844){
var state_val_12845 = (state_12844[(1)]);
if((state_val_12845 === (7))){
var inst_12839 = (state_12844[(2)]);
var _ = (function (){var statearr_12846 = state_12844;
(statearr_12846[(4)] = cljs.core.rest.call(null,(state_12844[(4)])));

return statearr_12846;
})();
var state_12844__$1 = state_12844;
var statearr_12847_12869 = state_12844__$1;
(statearr_12847_12869[(2)] = inst_12839);

(statearr_12847_12869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (1))){
var state_12844__$1 = state_12844;
var statearr_12848_12870 = state_12844__$1;
(statearr_12848_12870[(2)] = null);

(statearr_12848_12870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (4))){
var inst_12801 = (state_12844[(2)]);
var state_12844__$1 = state_12844;
var statearr_12849_12871 = state_12844__$1;
(statearr_12849_12871[(2)] = inst_12801);

(statearr_12849_12871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (6))){
var inst_12826 = (state_12844[(7)]);
var inst_12819 = (state_12844[(8)]);
var inst_12825 = cljs.core.seq.call(null,inst_12819);
var inst_12826__$1 = cljs.core.first.call(null,inst_12825);
var inst_12827 = cljs.core.next.call(null,inst_12825);
var inst_12828 = cljs.core.not.call(null,inst_12826__$1);
var state_12844__$1 = (function (){var statearr_12850 = state_12844;
(statearr_12850[(9)] = inst_12827);

(statearr_12850[(7)] = inst_12826__$1);

return statearr_12850;
})();
if(inst_12828){
var statearr_12851_12872 = state_12844__$1;
(statearr_12851_12872[(1)] = (8));

} else {
var statearr_12852_12873 = state_12844__$1;
(statearr_12852_12873[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (3))){
var inst_12842 = (state_12844[(2)]);
var state_12844__$1 = state_12844;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12844__$1,inst_12842);
} else {
if((state_val_12845 === (2))){
var _ = (function (){var statearr_12853 = state_12844;
(statearr_12853[(4)] = cljs.core.cons.call(null,(5),(state_12844[(4)])));

return statearr_12853;
})();
var inst_12814 = chs;
var inst_12815 = cljs.core.seq.call(null,inst_12814);
var inst_12816 = cljs.core.first.call(null,inst_12815);
var inst_12817 = cljs.core.next.call(null,inst_12815);
var inst_12818 = coll;
var inst_12819 = inst_12814;
var inst_12820 = inst_12818;
var state_12844__$1 = (function (){var statearr_12854 = state_12844;
(statearr_12854[(10)] = inst_12820);

(statearr_12854[(11)] = inst_12817);

(statearr_12854[(8)] = inst_12819);

(statearr_12854[(12)] = inst_12816);

return statearr_12854;
})();
var statearr_12855_12874 = state_12844__$1;
(statearr_12855_12874[(2)] = null);

(statearr_12855_12874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (11))){
var inst_12827 = (state_12844[(9)]);
var inst_12820 = (state_12844[(10)]);
var inst_12832 = (state_12844[(2)]);
var inst_12833 = fluree.db.util.async.throw_err.call(null,inst_12832);
var inst_12834 = cljs.core.conj.call(null,inst_12820,inst_12833);
var inst_12819 = inst_12827;
var inst_12820__$1 = inst_12834;
var state_12844__$1 = (function (){var statearr_12857 = state_12844;
(statearr_12857[(10)] = inst_12820__$1);

(statearr_12857[(8)] = inst_12819);

return statearr_12857;
})();
var statearr_12858_12875 = state_12844__$1;
(statearr_12858_12875[(2)] = null);

(statearr_12858_12875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (9))){
var inst_12826 = (state_12844[(7)]);
var state_12844__$1 = state_12844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12844__$1,(11),inst_12826);
} else {
if((state_val_12845 === (5))){
var _ = (function (){var statearr_12859 = state_12844;
(statearr_12859[(4)] = cljs.core.rest.call(null,(state_12844[(4)])));

return statearr_12859;
})();
var state_12844__$1 = state_12844;
var ex12856 = (state_12844__$1[(2)]);
var statearr_12860_12876 = state_12844__$1;
(statearr_12860_12876[(5)] = ex12856);


if((ex12856 instanceof java.lang.Exception)){
var statearr_12861_12877 = state_12844__$1;
(statearr_12861_12877[(1)] = (4));

(statearr_12861_12877[(5)] = null);

} else {
throw ex12856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (10))){
var inst_12837 = (state_12844[(2)]);
var state_12844__$1 = state_12844;
var statearr_12862_12878 = state_12844__$1;
(statearr_12862_12878[(2)] = inst_12837);

(statearr_12862_12878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (8))){
var inst_12820 = (state_12844[(10)]);
var state_12844__$1 = state_12844;
var statearr_12863_12879 = state_12844__$1;
(statearr_12863_12879[(2)] = inst_12820);

(statearr_12863_12879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_12864 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12864[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__);

(statearr_12864[(1)] = (1));

return statearr_12864;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____1 = (function (state_12844){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_12844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e12865){var ex__2471__auto__ = e12865;
var statearr_12866_12880 = state_12844;
(statearr_12866_12880[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_12844[(4)]))){
var statearr_12867_12881 = state_12844;
(statearr_12867_12881[(1)] = cljs.core.first.call(null,(state_12844[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12882 = state_12844;
state_12844 = G__12882;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__ = function(state_12844){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____1.call(this,state_12844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_12868 = f__2491__auto__.call(null);
(statearr_12868[(6)] = c__2490__auto__);

return statearr_12868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_12908){
var state_val_12909 = (state_12908[(1)]);
if((state_val_12909 === (7))){
var inst_12903 = (state_12908[(2)]);
var _ = (function (){var statearr_12910 = state_12908;
(statearr_12910[(4)] = cljs.core.rest.call(null,(state_12908[(4)])));

return statearr_12910;
})();
var state_12908__$1 = state_12908;
var statearr_12911_12933 = state_12908__$1;
(statearr_12911_12933[(2)] = inst_12903);

(statearr_12911_12933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (1))){
var state_12908__$1 = state_12908;
var statearr_12912_12934 = state_12908__$1;
(statearr_12912_12934[(2)] = null);

(statearr_12912_12934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (4))){
var inst_12883 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12913_12935 = state_12908__$1;
(statearr_12913_12935[(2)] = inst_12883);

(statearr_12913_12935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (6))){
var state_12908__$1 = state_12908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12908__$1,(8),chan);
} else {
if((state_val_12909 === (3))){
var inst_12906 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12908__$1,inst_12906);
} else {
if((state_val_12909 === (2))){
var _ = (function (){var statearr_12914 = state_12908;
(statearr_12914[(4)] = cljs.core.cons.call(null,(5),(state_12908[(4)])));

return statearr_12914;
})();
var inst_12889 = coll;
var inst_12890 = inst_12889;
var state_12908__$1 = (function (){var statearr_12915 = state_12908;
(statearr_12915[(7)] = inst_12890);

return statearr_12915;
})();
var statearr_12916_12936 = state_12908__$1;
(statearr_12916_12936[(2)] = null);

(statearr_12916_12936[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (11))){
var inst_12901 = (state_12908[(2)]);
var state_12908__$1 = state_12908;
var statearr_12918_12937 = state_12908__$1;
(statearr_12918_12937[(2)] = inst_12901);

(statearr_12918_12937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (9))){
var inst_12890 = (state_12908[(7)]);
var state_12908__$1 = state_12908;
var statearr_12919_12938 = state_12908__$1;
(statearr_12919_12938[(2)] = inst_12890);

(statearr_12919_12938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (5))){
var _ = (function (){var statearr_12920 = state_12908;
(statearr_12920[(4)] = cljs.core.rest.call(null,(state_12908[(4)])));

return statearr_12920;
})();
var state_12908__$1 = state_12908;
var ex12917 = (state_12908__$1[(2)]);
var statearr_12921_12939 = state_12908__$1;
(statearr_12921_12939[(5)] = ex12917);


if((ex12917 instanceof java.lang.Exception)){
var statearr_12922_12940 = state_12908__$1;
(statearr_12922_12940[(1)] = (4));

(statearr_12922_12940[(5)] = null);

} else {
throw ex12917;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (10))){
var inst_12894 = (state_12908[(8)]);
var inst_12890 = (state_12908[(7)]);
var inst_12898 = cljs.core.conj.call(null,inst_12890,inst_12894);
var inst_12890__$1 = inst_12898;
var state_12908__$1 = (function (){var statearr_12923 = state_12908;
(statearr_12923[(7)] = inst_12890__$1);

return statearr_12923;
})();
var statearr_12924_12941 = state_12908__$1;
(statearr_12924_12941[(2)] = null);

(statearr_12924_12941[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12909 === (8))){
var inst_12894 = (state_12908[(8)]);
var inst_12893 = (state_12908[(2)]);
var inst_12894__$1 = fluree.db.util.async.throw_err.call(null,inst_12893);
var inst_12895 = (inst_12894__$1 == null);
var state_12908__$1 = (function (){var statearr_12925 = state_12908;
(statearr_12925[(8)] = inst_12894__$1);

return statearr_12925;
})();
if(cljs.core.truth_(inst_12895)){
var statearr_12926_12942 = state_12908__$1;
(statearr_12926_12942[(1)] = (9));

} else {
var statearr_12927_12943 = state_12908__$1;
(statearr_12927_12943[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_12928 = [null,null,null,null,null,null,null,null,null];
(statearr_12928[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__);

(statearr_12928[(1)] = (1));

return statearr_12928;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____1 = (function (state_12908){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_12908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e12929){var ex__2471__auto__ = e12929;
var statearr_12930_12944 = state_12908;
(statearr_12930_12944[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_12908[(4)]))){
var statearr_12931_12945 = state_12908;
(statearr_12931_12945[(1)] = cljs.core.first.call(null,(state_12908[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12946 = state_12908;
state_12908 = G__12946;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__ = function(state_12908){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____1.call(this,state_12908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2468__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_12932 = f__2491__auto__.call(null);
(statearr_12932[(6)] = c__2490__auto__);

return statearr_12932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});

//# sourceMappingURL=async.js.map
