// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('fluree.db.util.bytes');
fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.call(null,JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string.call(null,x))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js.call(null,x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8.call(null,fluree.db.util.json.stringify.call(null,x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.call(null,(1),depth)){
return ((cljs.core.every_QMARK_.call(null,cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count.call(null,coordinates))));
} else {
return (((!((coordinates == null)))) && (cljs.core.every_QMARK_.call(null,cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,(function (p1__12979_SHARP_){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(depth - (1)),p1__12979_SHARP_);
}),coordinates))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_.call(null,coordinates)) && (((4) <= cljs.core.count.call(null,coordinates))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,coordinates),cljs.core.last.call(null,coordinates))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Feature",(function (geometry){
var and__4115__auto__ = (function (){var or__4126__auto__ = fluree.db.util.json.valid_geojson_QMARK_.call(null,new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.map_QMARK_.call(null,new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4115__auto__;
}
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,(function (p1__12980_SHARP_){
return cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,p1__12980_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));

//# sourceMappingURL=json.js.map
