// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__104200 = arguments.length;
switch (G__104200) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
});

fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
});

fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3;

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__104203 = arguments.length;
switch (G__104203) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
});

fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___104246 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___104246,pc){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___104246,pc){
return (function (state_104231){
var state_val_104232 = (state_104231[(1)]);
if((state_val_104232 === (1))){
var state_104231__$1 = state_104231;
var statearr_104233_104247 = state_104231__$1;
(statearr_104233_104247[(2)] = null);

(statearr_104233_104247[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104232 === (2))){
var inst_104229 = (state_104231[(2)]);
var state_104231__$1 = state_104231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104231__$1,inst_104229);
} else {
if((state_val_104232 === (3))){
var inst_104204 = (state_104231[(2)]);
var inst_104205 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_104204);
var state_104231__$1 = state_104231;
var statearr_104234_104248 = state_104231__$1;
(statearr_104234_104248[(2)] = inst_104205);


cljs.core.async.impl.ioc_helpers.process_exception(state_104231__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104232 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104231,(3),java.lang.Exception,null,(2));
var inst_104209 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_104231__$1 = state_104231;
if(cljs.core.truth_(inst_104209)){
var statearr_104235_104249 = state_104231__$1;
(statearr_104235_104249[(1)] = (5));

} else {
var statearr_104236_104250 = state_104231__$1;
(statearr_104236_104250[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104232 === (5))){
var inst_104211 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104212 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_104213 = cljs.core.PersistentHashMap.fromArrays(inst_104211,inst_104212);
var inst_104214 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_104213);
var inst_104215 = (function(){throw inst_104214})();
var state_104231__$1 = state_104231;
var statearr_104237_104251 = state_104231__$1;
(statearr_104237_104251[(2)] = inst_104215);

(statearr_104237_104251[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104232 === (6))){
var inst_104217 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_104218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104219 = [operation,data,pc,opts];
var inst_104220 = (new cljs.core.PersistentVector(null,4,(5),inst_104218,inst_104219,null));
var inst_104221 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_104217,inst_104220);
var inst_104222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_104223 = [operation,data,pc,opts];
var inst_104224 = (new cljs.core.PersistentVector(null,4,(5),inst_104222,inst_104223,null));
var inst_104225 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_104224], 0));
var state_104231__$1 = (function (){var statearr_104238 = state_104231;
(statearr_104238[(7)] = inst_104221);

return statearr_104238;
})();
var statearr_104239_104252 = state_104231__$1;
(statearr_104239_104252[(2)] = inst_104225);

(statearr_104239_104252[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104232 === (7))){
var inst_104227 = (state_104231[(2)]);
var state_104231__$1 = state_104231;
var statearr_104240_104253 = state_104231__$1;
(statearr_104240_104253[(2)] = inst_104227);


cljs.core.async.impl.ioc_helpers.process_exception(state_104231__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__99059__auto___104246,pc))
;
return ((function (switch__99036__auto__,c__99059__auto___104246,pc){
return (function() {
var fluree$db$operations$state_machine__99037__auto__ = null;
var fluree$db$operations$state_machine__99037__auto____0 = (function (){
var statearr_104241 = [null,null,null,null,null,null,null,null];
(statearr_104241[(0)] = fluree$db$operations$state_machine__99037__auto__);

(statearr_104241[(1)] = (1));

return statearr_104241;
});
var fluree$db$operations$state_machine__99037__auto____1 = (function (state_104231){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104231);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104242){if((e104242 instanceof Object)){
var ex__99040__auto__ = e104242;
var statearr_104243_104254 = state_104231;
(statearr_104243_104254[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104231);

return cljs.core.cst$kw$recur;
} else {
throw e104242;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104255 = state_104231;
state_104231 = G__104255;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99037__auto__ = function(state_104231){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99037__auto____1.call(this,state_104231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99037__auto____0;
fluree$db$operations$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99037__auto____1;
return fluree$db$operations$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___104246,pc))
})();
var state__99061__auto__ = (function (){var statearr_104244 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104244[(6)] = c__99059__auto___104246);

return statearr_104244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___104246,pc))
);


return pc;
});

fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4;

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__104257 = arguments.length;
switch (G__104257) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
});

fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__104258){
var map__104259 = p__104258;
var map__104259__$1 = (((((!((map__104259 == null))))?(((((map__104259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104259):map__104259);
var opts = map__104259__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104259__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__104261 = session;
var map__104261__$1 = (((((!((map__104261 == null))))?(((((map__104261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104261):map__104261);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104261__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104261__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104261__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
});

fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2;

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4736__auto__ = [];
var len__4730__auto___104320 = arguments.length;
var i__4731__auto___104321 = (0);
while(true){
if((i__4731__auto___104321 < len__4730__auto___104320)){
args__4736__auto__.push((arguments[i__4731__auto___104321]));

var G__104322 = (i__4731__auto___104321 + (1));
i__4731__auto___104321 = G__104322;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__104266){
var vec__104267 = p__104266;
var map__104270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104267,(0),null);
var map__104270__$1 = (((((!((map__104270 == null))))?(((((map__104270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104270.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104270):map__104270);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104270__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104270__$1,cljs.core.cst$kw$toTime);
var opts = vec__104267;
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts){
return (function (state_104302){
var state_val_104303 = (state_104302[(1)]);
if((state_val_104303 === (7))){
var inst_104285 = (state_104302[(2)]);
var state_104302__$1 = state_104302;
var statearr_104304_104323 = state_104302__$1;
(statearr_104304_104323[(2)] = inst_104285);

(statearr_104304_104323[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (1))){
var inst_104274 = (session == null);
var inst_104275 = cljs.core.not(inst_104274);
var state_104302__$1 = state_104302;
if(inst_104275){
var statearr_104305_104324 = state_104302__$1;
(statearr_104305_104324[(1)] = (2));

} else {
var statearr_104306_104325 = state_104302__$1;
(statearr_104306_104325[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (4))){
var inst_104288 = (state_104302[(2)]);
var state_104302__$1 = state_104302;
if(cljs.core.truth_(inst_104288)){
var statearr_104307_104326 = state_104302__$1;
(statearr_104307_104326[(1)] = (8));

} else {
var statearr_104308_104327 = state_104302__$1;
(statearr_104308_104327[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (6))){
var state_104302__$1 = state_104302;
var statearr_104309_104328 = state_104302__$1;
(statearr_104309_104328[(2)] = false);

(statearr_104309_104328[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (3))){
var state_104302__$1 = state_104302;
var statearr_104310_104329 = state_104302__$1;
(statearr_104310_104329[(2)] = false);

(statearr_104310_104329[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (2))){
var inst_104277 = session.cljs$lang$protocol_mask$partition0$;
var inst_104278 = (inst_104277 & (64));
var inst_104279 = session.cljs$core$ISeq$;
var inst_104280 = (cljs.core.PROTOCOL_SENTINEL === inst_104279);
var inst_104281 = ((inst_104278) || (inst_104280));
var state_104302__$1 = state_104302;
if(cljs.core.truth_(inst_104281)){
var statearr_104311_104330 = state_104302__$1;
(statearr_104311_104330[(1)] = (5));

} else {
var statearr_104312_104331 = state_104302__$1;
(statearr_104312_104331[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (9))){
var state_104302__$1 = state_104302;
var statearr_104313_104332 = state_104302__$1;
(statearr_104313_104332[(2)] = session);

(statearr_104313_104332[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (5))){
var state_104302__$1 = state_104302;
var statearr_104314_104333 = state_104302__$1;
(statearr_104314_104333[(2)] = true);

(statearr_104314_104333[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104303 === (10))){
var inst_104293 = (state_104302[(2)]);
var inst_104294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104293,cljs.core.cst$kw$network);
var inst_104295 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104293,cljs.core.cst$kw$dbid);
var inst_104296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_104293,cljs.core.cst$kw$conn);
var inst_104297 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_104298 = [inst_104294,inst_104295,toBlock,toTime];
var inst_104299 = cljs.core.PersistentHashMap.fromArrays(inst_104297,inst_104298);
var inst_104300 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_104296,cljs.core.cst$kw$garbage,inst_104299);
var state_104302__$1 = state_104302;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104302__$1,inst_104300);
} else {
if((state_val_104303 === (8))){
var inst_104290 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_104302__$1 = state_104302;
var statearr_104315_104334 = state_104302__$1;
(statearr_104315_104334[(2)] = inst_104290);

(statearr_104315_104334[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts))
;
return ((function (switch__99036__auto__,c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts){
return (function() {
var fluree$db$operations$state_machine__99037__auto__ = null;
var fluree$db$operations$state_machine__99037__auto____0 = (function (){
var statearr_104316 = [null,null,null,null,null,null,null];
(statearr_104316[(0)] = fluree$db$operations$state_machine__99037__auto__);

(statearr_104316[(1)] = (1));

return statearr_104316;
});
var fluree$db$operations$state_machine__99037__auto____1 = (function (state_104302){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104302);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104317){if((e104317 instanceof Object)){
var ex__99040__auto__ = e104317;
var statearr_104318_104335 = state_104302;
(statearr_104318_104335[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104302);

return cljs.core.cst$kw$recur;
} else {
throw e104317;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104336 = state_104302;
state_104302 = G__104336;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99037__auto__ = function(state_104302){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99037__auto____1.call(this,state_104302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99037__auto____0;
fluree$db$operations$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99037__auto____1;
return fluree$db$operations$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts))
})();
var state__99061__auto__ = (function (){var statearr_104319 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104319[(6)] = c__99059__auto__);

return statearr_104319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,vec__104267,map__104270,map__104270__$1,toBlock,toTime,opts))
);

return c__99059__auto__;
});

fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq104264){
var G__104265 = cljs.core.first(seq104264);
var seq104264__$1 = cljs.core.next(seq104264);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__104265,seq104264__$1);
});

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__104337 = session;
var map__104337__$1 = (((((!((map__104337 == null))))?(((((map__104337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104337.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104337):map__104337);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104337__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104337__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104337__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__104340 = arguments.length;
switch (G__104340) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
});

fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__104341 = opts;
var map__104341__$1 = (((((!((map__104341 == null))))?(((((map__104341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104341):map__104341);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104341__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104341__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4131__auto__ = auth;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
});

fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2;

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});

//# sourceMappingURL=operations.js.map?rel=1593118617227
