// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28020 = arguments.length;
var i__4737__auto___28021 = (0);
while(true){
if((i__4737__auto___28021 < len__4736__auto___28020)){
args__4742__auto__.push((arguments[i__4737__auto___28021]));

var G__28022 = (i__4737__auto___28021 + (1));
i__4737__auto___28021 = G__28022;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28017){
var G__28018 = cljs.core.first.call(null,seq28017);
var seq28017__$1 = cljs.core.next.call(null,seq28017);
var G__28019 = cljs.core.first.call(null,seq28017__$1);
var seq28017__$2 = cljs.core.next.call(null,seq28017__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28018,G__28019,seq28017__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28023){if((e28023 instanceof java.lang.Exception)){
var e = e28023;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
} else {
throw e28023;

}
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28024){if((e28024 instanceof java.lang.Exception)){
var e = e28024;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
} else {
throw e28024;

}
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28025){if((e28025 instanceof java.lang.Exception)){
var e = e28025;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
} else {
throw e28025;

}
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28026){if((e28026 instanceof java.lang.Exception)){
var e = e28026;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
} else {
throw e28026;

}
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28027){if((e28027 instanceof java.lang.Exception)){
var e = e28027;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
} else {
throw e28027;

}
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28030 = arguments.length;
var i__4737__auto___28031 = (0);
while(true){
if((i__4737__auto___28031 < len__4736__auto___28030)){
args__4742__auto__.push((arguments[i__4737__auto___28031]));

var G__28032 = (i__4737__auto___28031 + (1));
i__4737__auto___28031 = G__28032;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28029){if((e28029 instanceof java.lang.Exception)){
var e = e28029;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
} else {
throw e28029;

}
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28028){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28028));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28035 = arguments.length;
var i__4737__auto___28036 = (0);
while(true){
if((i__4737__auto___28036 < len__4736__auto___28035)){
args__4742__auto__.push((arguments[i__4737__auto___28036]));

var G__28037 = (i__4737__auto___28036 + (1));
i__4737__auto___28036 = G__28037;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28034){if((e28034 instanceof java.lang.Exception)){
var e = e28034;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
} else {
throw e28034;

}
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28033){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28033));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28038){if((e28038 instanceof java.lang.Exception)){
var e = e28038;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
} else {
throw e28038;

}
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28041 = arguments.length;
var i__4737__auto___28042 = (0);
while(true){
if((i__4737__auto___28042 < len__4736__auto___28041)){
args__4742__auto__.push((arguments[i__4737__auto___28042]));

var G__28043 = (i__4737__auto___28042 + (1));
i__4737__auto___28042 = G__28043;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28040){if((e28040 instanceof java.lang.Exception)){
var e = e28040;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
} else {
throw e28040;

}
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28039){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28039));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28044){if((e28044 instanceof java.lang.Exception)){
var e = e28044;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
} else {
throw e28044;

}
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28045){if((e28045 instanceof java.lang.Exception)){
var e = e28045;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
} else {
throw e28045;

}
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28048 = arguments.length;
var i__4737__auto___28049 = (0);
while(true){
if((i__4737__auto___28049 < len__4736__auto___28048)){
args__4742__auto__.push((arguments[i__4737__auto___28049]));

var G__28050 = (i__4737__auto___28049 + (1));
i__4737__auto___28049 = G__28050;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28047){if((e28047 instanceof java.lang.Exception)){
var e = e28047;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
} else {
throw e28047;

}
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28046){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28046));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28053 = arguments.length;
var i__4737__auto___28054 = (0);
while(true){
if((i__4737__auto___28054 < len__4736__auto___28053)){
args__4742__auto__.push((arguments[i__4737__auto___28054]));

var G__28055 = (i__4737__auto___28054 + (1));
i__4737__auto___28054 = G__28055;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28052){if((e28052 instanceof java.lang.Exception)){
var e = e28052;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
} else {
throw e28052;

}
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28051){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28051));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28058 = arguments.length;
var i__4737__auto___28059 = (0);
while(true){
if((i__4737__auto___28059 < len__4736__auto___28058)){
args__4742__auto__.push((arguments[i__4737__auto___28059]));

var G__28060 = (i__4737__auto___28059 + (1));
i__4737__auto___28059 = G__28060;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28057){if((e28057 instanceof java.lang.Exception)){
var e = e28057;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
} else {
throw e28057;

}
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28056){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28056));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28063 = arguments.length;
var i__4737__auto___28064 = (0);
while(true){
if((i__4737__auto___28064 < len__4736__auto___28063)){
args__4742__auto__.push((arguments[i__4737__auto___28064]));

var G__28065 = (i__4737__auto___28064 + (1));
i__4737__auto___28064 = G__28065;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28062){if((e28062 instanceof java.lang.Exception)){
var e = e28062;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
} else {
throw e28062;

}
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28061){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28061));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28068 = arguments.length;
var i__4737__auto___28069 = (0);
while(true){
if((i__4737__auto___28069 < len__4736__auto___28068)){
args__4742__auto__.push((arguments[i__4737__auto___28069]));

var G__28070 = (i__4737__auto___28069 + (1));
i__4737__auto___28069 = G__28070;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28067){if((e28067 instanceof java.lang.Exception)){
var e = e28067;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
} else {
throw e28067;

}
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28066){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28066));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28073 = arguments.length;
var i__4737__auto___28074 = (0);
while(true){
if((i__4737__auto___28074 < len__4736__auto___28073)){
args__4742__auto__.push((arguments[i__4737__auto___28074]));

var G__28075 = (i__4737__auto___28074 + (1));
i__4737__auto___28074 = G__28075;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28072){if((e28072 instanceof java.lang.Exception)){
var e = e28072;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
} else {
throw e28072;

}
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28071){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28071));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28077 = arguments.length;
switch (G__28077) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28105){
var state_val_28106 = (state_28105[(1)]);
if((state_val_28106 === (7))){
var inst_28090 = (state_28105[(7)]);
var inst_28093 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28090,"query",query_map);
var state_28105__$1 = state_28105;
var statearr_28107_28193 = state_28105__$1;
(statearr_28107_28193[(2)] = inst_28093);

(statearr_28107_28193[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (1))){
var state_28105__$1 = state_28105;
var statearr_28108_28194 = state_28105__$1;
(statearr_28108_28194[(2)] = null);

(statearr_28108_28194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (4))){
var inst_28078 = (state_28105[(2)]);
var state_28105__$1 = state_28105;
var statearr_28109_28195 = state_28105__$1;
(statearr_28109_28195[(2)] = inst_28078);

(statearr_28109_28195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (6))){
var inst_28090 = (state_28105[(7)]);
var inst_28090__$1 = (state_28105[(2)]);
var inst_28091 = fluree.db.util.core.exception_QMARK_.call(null,inst_28090__$1);
var state_28105__$1 = (function (){var statearr_28110 = state_28105;
(statearr_28110[(7)] = inst_28090__$1);

return statearr_28110;
})();
if(inst_28091){
var statearr_28111_28196 = state_28105__$1;
(statearr_28111_28196[(1)] = (7));

} else {
var statearr_28112_28197 = state_28105__$1;
(statearr_28112_28197[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (3))){
var inst_28103 = (state_28105[(2)]);
var state_28105__$1 = state_28105;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28105__$1,inst_28103);
} else {
if((state_val_28106 === (2))){
var inst_28084 = (state_28105[(8)]);
var _ = (function (){var statearr_28114 = state_28105;
(statearr_28114[(4)] = cljs.core.cons.call(null,(5),(state_28105[(4)])));

return statearr_28114;
})();
var inst_28084__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28085 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28086 = cljs.core.assoc.call(null,inst_28085,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28084__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28087 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28086);
var inst_28088 = fluree.db.query.fql.query.call(null,db,inst_28087);
var state_28105__$1 = (function (){var statearr_28115 = state_28105;
(statearr_28115[(8)] = inst_28084__$1);

return statearr_28115;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28105__$1,(6),inst_28088);
} else {
if((state_val_28106 === (9))){
var inst_28100 = (state_28105[(2)]);
var _ = (function (){var statearr_28116 = state_28105;
(statearr_28116[(4)] = cljs.core.rest.call(null,(state_28105[(4)])));

return statearr_28116;
})();
var state_28105__$1 = state_28105;
var statearr_28117_28198 = state_28105__$1;
(statearr_28117_28198[(2)] = inst_28100);

(statearr_28117_28198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (5))){
var _ = (function (){var statearr_28118 = state_28105;
(statearr_28118[(4)] = cljs.core.rest.call(null,(state_28105[(4)])));

return statearr_28118;
})();
var state_28105__$1 = state_28105;
var ex28113 = (state_28105__$1[(2)]);
var statearr_28119_28199 = state_28105__$1;
(statearr_28119_28199[(5)] = ex28113);


if((ex28113 instanceof Error)){
var statearr_28120_28200 = state_28105__$1;
(statearr_28120_28200[(1)] = (4));

(statearr_28120_28200[(5)] = null);

} else {
throw ex28113;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28106 === (8))){
var inst_28090 = (state_28105[(7)]);
var inst_28084 = (state_28105[(8)]);
var inst_28095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28096 = cljs.core.deref.call(null,inst_28084);
var inst_28097 = [inst_28090,inst_28096];
var inst_28098 = (new cljs.core.PersistentVector(null,2,(5),inst_28095,inst_28097,null));
var state_28105__$1 = state_28105;
var statearr_28121_28201 = state_28105__$1;
(statearr_28121_28201[(2)] = inst_28098);

(statearr_28121_28201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2468__auto____0 = (function (){
var statearr_28122 = [null,null,null,null,null,null,null,null,null];
(statearr_28122[(0)] = fluree$db$dbfunctions$internal$state_machine__2468__auto__);

(statearr_28122[(1)] = (1));

return statearr_28122;
});
var fluree$db$dbfunctions$internal$state_machine__2468__auto____1 = (function (state_28105){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28123){var ex__2471__auto__ = e28123;
var statearr_28124_28202 = state_28105;
(statearr_28124_28202[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28105[(4)]))){
var statearr_28125_28203 = state_28105;
(statearr_28125_28203[(1)] = cljs.core.first.call(null,(state_28105[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28204 = state_28105;
state_28105 = G__28204;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2468__auto__ = function(state_28105){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____1.call(this,state_28105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28126 = f__2491__auto__.call(null);
(statearr_28126[(6)] = c__2490__auto__);

return statearr_28126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28171){
var state_val_28172 = (state_28171[(1)]);
if((state_val_28172 === (7))){
var inst_28157 = (state_28171[(2)]);
var inst_28158 = fluree.db.query.fql.query.call(null,db,inst_28157);
var state_28171__$1 = state_28171;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28171__$1,(8),inst_28158);
} else {
if((state_val_28172 === (1))){
var inst_28127 = typeof select === 'string';
var state_28171__$1 = state_28171;
if(cljs.core.truth_(inst_28127)){
var statearr_28173_28205 = state_28171__$1;
(statearr_28173_28205[(1)] = (2));

} else {
var statearr_28174_28206 = state_28171__$1;
(statearr_28174_28206[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (4))){
var inst_28140 = (state_28171[(7)]);
var inst_28133 = (state_28171[(8)]);
var inst_28132 = (state_28171[(2)]);
var inst_28133__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28134 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28135 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28136 = [inst_28133__$1,(100000)];
var inst_28137 = cljs.core.PersistentHashMap.fromArrays(inst_28135,inst_28136);
var inst_28138 = [inst_28132,from,where,block,limit,inst_28137];
var inst_28139 = cljs.core.PersistentHashMap.fromArrays(inst_28134,inst_28138);
var inst_28140__$1 = fluree.db.util.core.without_nils.call(null,inst_28139);
var inst_28141 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28140__$1);
var inst_28142 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28140__$1);
var inst_28143 = cljs.core.first.call(null,inst_28142);
var inst_28144 = fluree.db.dbfunctions.internal.str.call(null,inst_28143);
var inst_28145 = cljs.core._EQ_.call(null,"[",inst_28144);
var inst_28146 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28140__$1);
var inst_28147 = cljs.core.last.call(null,inst_28146);
var inst_28148 = fluree.db.dbfunctions.internal.str.call(null,inst_28147);
var inst_28149 = cljs.core._EQ_.call(null,"]",inst_28148);
var inst_28150 = fluree.db.dbfunctions.internal.and.call(null,inst_28141,inst_28145,inst_28149);
var state_28171__$1 = (function (){var statearr_28175 = state_28171;
(statearr_28175[(7)] = inst_28140__$1);

(statearr_28175[(8)] = inst_28133__$1);

return statearr_28175;
})();
if(cljs.core.truth_(inst_28150)){
var statearr_28176_28207 = state_28171__$1;
(statearr_28176_28207[(1)] = (5));

} else {
var statearr_28177_28208 = state_28171__$1;
(statearr_28177_28208[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (6))){
var inst_28140 = (state_28171[(7)]);
var state_28171__$1 = state_28171;
var statearr_28178_28209 = state_28171__$1;
(statearr_28178_28209[(2)] = inst_28140);

(statearr_28178_28209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (3))){
var state_28171__$1 = state_28171;
var statearr_28179_28210 = state_28171__$1;
(statearr_28179_28210[(2)] = select);

(statearr_28179_28210[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (2))){
var inst_28129 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28171__$1 = state_28171;
var statearr_28180_28211 = state_28171__$1;
(statearr_28180_28211[(2)] = inst_28129);

(statearr_28180_28211[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (11))){
var inst_28169 = (state_28171[(2)]);
var state_28171__$1 = state_28171;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28171__$1,inst_28169);
} else {
if((state_val_28172 === (9))){
var inst_28160 = (state_28171[(9)]);
var state_28171__$1 = state_28171;
var statearr_28181_28212 = state_28171__$1;
(statearr_28181_28212[(2)] = inst_28160);

(statearr_28181_28212[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (5))){
var inst_28140 = (state_28171[(7)]);
var inst_28152 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28140);
var inst_28153 = cljs.reader.read_string.call(null,inst_28152);
var inst_28154 = cljs.core.assoc.call(null,inst_28140,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28153);
var state_28171__$1 = state_28171;
var statearr_28182_28213 = state_28171__$1;
(statearr_28182_28213[(2)] = inst_28154);

(statearr_28182_28213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (10))){
var inst_28133 = (state_28171[(8)]);
var inst_28160 = (state_28171[(9)]);
var inst_28164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28165 = cljs.core.deref.call(null,inst_28133);
var inst_28166 = [inst_28160,inst_28165];
var inst_28167 = (new cljs.core.PersistentVector(null,2,(5),inst_28164,inst_28166,null));
var state_28171__$1 = state_28171;
var statearr_28183_28214 = state_28171__$1;
(statearr_28183_28214[(2)] = inst_28167);

(statearr_28183_28214[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28172 === (8))){
var inst_28160 = (state_28171[(9)]);
var inst_28160__$1 = (state_28171[(2)]);
var inst_28161 = fluree.db.util.core.exception_QMARK_.call(null,inst_28160__$1);
var state_28171__$1 = (function (){var statearr_28184 = state_28171;
(statearr_28184[(9)] = inst_28160__$1);

return statearr_28184;
})();
if(inst_28161){
var statearr_28185_28215 = state_28171__$1;
(statearr_28185_28215[(1)] = (9));

} else {
var statearr_28186_28216 = state_28171__$1;
(statearr_28186_28216[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2468__auto____0 = (function (){
var statearr_28187 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28187[(0)] = fluree$db$dbfunctions$internal$state_machine__2468__auto__);

(statearr_28187[(1)] = (1));

return statearr_28187;
});
var fluree$db$dbfunctions$internal$state_machine__2468__auto____1 = (function (state_28171){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28171);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28188){var ex__2471__auto__ = e28188;
var statearr_28189_28217 = state_28171;
(statearr_28189_28217[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28171[(4)]))){
var statearr_28190_28218 = state_28171;
(statearr_28190_28218[(1)] = cljs.core.first.call(null,(state_28171[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28219 = state_28171;
state_28171 = G__28219;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2468__auto__ = function(state_28171){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____1.call(this,state_28171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28191 = f__2491__auto__.call(null);
(statearr_28191[(6)] = c__2490__auto__);

return statearr_28191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__28220 = clojure.string.split.call(null,var$,/\//);
var coll = cljs.core.nth.call(null,vec__28220,(0),null);
var pred = cljs.core.nth.call(null,vec__28220,(1),null);
var pred__$1 = cljs.core.subs.call(null,pred,(1));
return fluree.db.dbfunctions.internal.str.call(null,coll,"/",pred__$1);
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28226 = path;
var vec__28227 = G__28226;
var seq__28228 = cljs.core.seq.call(null,vec__28227);
var first__28229 = cljs.core.first.call(null,seq__28228);
var seq__28228__$1 = cljs.core.next.call(null,seq__28228);
var var$ = first__28229;
var r = seq__28228__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28226__$1 = G__28226;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28233 = G__28226__$1;
var seq__28234 = cljs.core.seq.call(null,vec__28233);
var first__28235 = cljs.core.first.call(null,seq__28234);
var seq__28234__$1 = cljs.core.next.call(null,seq__28234);
var var$__$1 = first__28235;
var r__$1 = seq__28234__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28236 = r__$1;
var G__28237 = n__$2;
var G__28238 = next_clauses;
G__28226__$1 = G__28236;
n__$1 = G__28237;
where_clauses__$1 = G__28238;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28239 = r__$1;
var G__28240 = next_n;
var G__28241 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28226__$1 = G__28239;
n__$1 = G__28240;
where_clauses__$1 = G__28241;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28278){
var state_val_28279 = (state_28278[(1)]);
if((state_val_28279 === (7))){
var inst_28251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28252 = [path];
var inst_28253 = (new cljs.core.PersistentVector(null,1,(5),inst_28251,inst_28252,null));
var state_28278__$1 = state_28278;
var statearr_28280_28308 = state_28278__$1;
(statearr_28280_28308[(2)] = inst_28253);

(statearr_28280_28308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (1))){
var state_28278__$1 = state_28278;
var statearr_28281_28309 = state_28278__$1;
(statearr_28281_28309[(2)] = null);

(statearr_28281_28309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (4))){
var inst_28242 = (state_28278[(2)]);
var state_28278__$1 = state_28278;
var statearr_28282_28310 = state_28278__$1;
(statearr_28282_28310[(2)] = inst_28242);

(statearr_28282_28310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (13))){
var inst_28269 = (state_28278[(2)]);
var inst_28270 = fluree.db.util.async.throw_err.call(null,inst_28269);
var _ = (function (){var statearr_28283 = state_28278;
(statearr_28283[(4)] = cljs.core.rest.call(null,(state_28278[(4)])));

return statearr_28283;
})();
var state_28278__$1 = state_28278;
var statearr_28284_28311 = state_28278__$1;
(statearr_28284_28311[(2)] = inst_28270);

(statearr_28284_28311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (6))){
var state_28278__$1 = state_28278;
var statearr_28286_28312 = state_28278__$1;
(statearr_28286_28312[(2)] = path);

(statearr_28286_28312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (3))){
var inst_28276 = (state_28278[(2)]);
var state_28278__$1 = state_28278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28278__$1,inst_28276);
} else {
if((state_val_28279 === (12))){
var _ = (function (){var statearr_28287 = state_28278;
(statearr_28287[(4)] = cljs.core.rest.call(null,(state_28278[(4)])));

return statearr_28287;
})();
var state_28278__$1 = state_28278;
var ex28285 = (state_28278__$1[(2)]);
var statearr_28288_28313 = state_28278__$1;
(statearr_28288_28313[(5)] = ex28285);


if((ex28285 instanceof java.lang.Exception)){
var statearr_28289_28314 = state_28278__$1;
(statearr_28289_28314[(1)] = (11));

(statearr_28289_28314[(5)] = null);

} else {
throw ex28285;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (2))){
var _ = (function (){var statearr_28290 = state_28278;
(statearr_28290[(4)] = cljs.core.cons.call(null,(5),(state_28278[(4)])));

return statearr_28290;
})();
var inst_28248 = cljs.core.vector_QMARK_.call(null,path);
var state_28278__$1 = state_28278;
if(inst_28248){
var statearr_28291_28315 = state_28278__$1;
(statearr_28291_28315[(1)] = (6));

} else {
var statearr_28292_28316 = state_28278__$1;
(statearr_28292_28316[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (11))){
var inst_28255 = (state_28278[(7)]);
var inst_28260 = (state_28278[(2)]);
var inst_28261 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28260,"relationship?",startSubject,inst_28255,endSubject);
var state_28278__$1 = state_28278;
var statearr_28294_28317 = state_28278__$1;
(statearr_28294_28317[(2)] = inst_28261);

(statearr_28294_28317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (9))){
var inst_28259 = (state_28278[(8)]);
var _ = (function (){var statearr_28295 = state_28278;
(statearr_28295[(4)] = cljs.core.cons.call(null,(12),(state_28278[(4)])));

return statearr_28295;
})();
var inst_28267 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28259);
var state_28278__$1 = state_28278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28278__$1,(13),inst_28267);
} else {
if((state_val_28279 === (5))){
var _ = (function (){var statearr_28296 = state_28278;
(statearr_28296[(4)] = cljs.core.rest.call(null,(state_28278[(4)])));

return statearr_28296;
})();
var state_28278__$1 = state_28278;
var ex28293 = (state_28278__$1[(2)]);
var statearr_28297_28318 = state_28278__$1;
(statearr_28297_28318[(5)] = ex28293);


if((ex28293 instanceof Error)){
var statearr_28298_28319 = state_28278__$1;
(statearr_28298_28319[(1)] = (4));

(statearr_28298_28319[(5)] = null);

} else {
throw ex28293;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (10))){
var inst_28273 = (state_28278[(2)]);
var _ = (function (){var statearr_28299 = state_28278;
(statearr_28299[(4)] = cljs.core.rest.call(null,(state_28278[(4)])));

return statearr_28299;
})();
var state_28278__$1 = state_28278;
var statearr_28300_28320 = state_28278__$1;
(statearr_28300_28320[(2)] = inst_28273);

(statearr_28300_28320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28279 === (8))){
var inst_28255 = (state_28278[(7)]);
var inst_28255__$1 = (state_28278[(2)]);
var inst_28256 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28255__$1,endSubject);
var inst_28257 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28258 = ["?var1",inst_28256];
var inst_28259 = cljs.core.PersistentHashMap.fromArrays(inst_28257,inst_28258);
var state_28278__$1 = (function (){var statearr_28301 = state_28278;
(statearr_28301[(8)] = inst_28259);

(statearr_28301[(7)] = inst_28255__$1);

return statearr_28301;
})();
var statearr_28302_28321 = state_28278__$1;
(statearr_28302_28321[(2)] = null);

(statearr_28302_28321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____0 = (function (){
var statearr_28303 = [null,null,null,null,null,null,null,null,null];
(statearr_28303[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__);

(statearr_28303[(1)] = (1));

return statearr_28303;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____1 = (function (state_28278){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28304){var ex__2471__auto__ = e28304;
var statearr_28305_28322 = state_28278;
(statearr_28305_28322[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28278[(4)]))){
var statearr_28306_28323 = state_28278;
(statearr_28306_28323[(1)] = cljs.core.first.call(null,(state_28278[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28324 = state_28278;
state_28278 = G__28324;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__ = function(state_28278){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____1.call(this,state_28278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28307 = f__2491__auto__.call(null);
(statearr_28307[(6)] = c__2490__auto__);

return statearr_28307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28325){if((e28325 instanceof java.lang.Exception)){
var e = e28325;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
} else {
throw e28325;

}
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28326){if((e28326 instanceof java.lang.Exception)){
var e = e28326;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
} else {
throw e28326;

}
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28327){if((e28327 instanceof java.lang.Exception)){
var e = e28327;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
} else {
throw e28327;

}
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28328){if((e28328 instanceof java.lang.Exception)){
var e = e28328;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
} else {
throw e28328;

}
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28331 = arguments.length;
var i__4737__auto___28332 = (0);
while(true){
if((i__4737__auto___28332 < len__4736__auto___28331)){
args__4742__auto__.push((arguments[i__4737__auto___28332]));

var G__28333 = (i__4737__auto___28332 + (1));
i__4737__auto___28332 = G__28333;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28330){if((e28330 instanceof java.lang.Exception)){
var e = e28330;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
} else {
throw e28330;

}
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28329){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28329));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28336 = arguments.length;
var i__4737__auto___28337 = (0);
while(true){
if((i__4737__auto___28337 < len__4736__auto___28336)){
args__4742__auto__.push((arguments[i__4737__auto___28337]));

var G__28338 = (i__4737__auto___28337 + (1));
i__4737__auto___28337 = G__28338;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28335){if((e28335 instanceof java.lang.Exception)){
var e = e28335;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
} else {
throw e28335;

}
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28334){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28334));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28341 = arguments.length;
var i__4737__auto___28342 = (0);
while(true){
if((i__4737__auto___28342 < len__4736__auto___28341)){
args__4742__auto__.push((arguments[i__4737__auto___28342]));

var G__28343 = (i__4737__auto___28342 + (1));
i__4737__auto___28342 = G__28343;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28340){if((e28340 instanceof java.lang.Exception)){
var e = e28340;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
} else {
throw e28340;

}
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28339){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28339));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28346 = arguments.length;
var i__4737__auto___28347 = (0);
while(true){
if((i__4737__auto___28347 < len__4736__auto___28346)){
args__4742__auto__.push((arguments[i__4737__auto___28347]));

var G__28348 = (i__4737__auto___28347 + (1));
i__4737__auto___28347 = G__28348;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28345){if((e28345 instanceof java.lang.Exception)){
var e = e28345;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
} else {
throw e28345;

}
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28344){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28344));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28349){if((e28349 instanceof java.lang.Exception)){
var e = e28349;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
} else {
throw e28349;

}
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28350){if((e28350 instanceof java.lang.Exception)){
var e = e28350;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
} else {
throw e28350;

}
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28351){if((e28351 instanceof java.lang.Exception)){
var e = e28351;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
} else {
throw e28351;

}
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28352){if((e28352 instanceof java.lang.Exception)){
var e = e28352;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
} else {
throw e28352;

}
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28353){if((e28353 instanceof java.lang.Exception)){
var e = e28353;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
} else {
throw e28353;

}
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28359 = path;
var vec__28360 = G__28359;
var seq__28361 = cljs.core.seq.call(null,vec__28360);
var first__28362 = cljs.core.first.call(null,seq__28361);
var seq__28361__$1 = cljs.core.next.call(null,seq__28361);
var pred = first__28362;
var r = seq__28361__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28359__$1 = G__28359;
var subjects__$1 = subjects;
while(true){
var vec__28366 = G__28359__$1;
var seq__28367 = cljs.core.seq.call(null,vec__28366);
var first__28368 = cljs.core.first.call(null,seq__28367);
var seq__28367__$1 = cljs.core.next.call(null,seq__28367);
var pred__$1 = first__28368;
var r__$1 = seq__28367__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28359__$1,subjects__$1,vec__28366,seq__28367,first__28368,seq__28367__$1,pred__$1,r__$1,subjects__$2,G__28359,vec__28360,seq__28361,first__28362,seq__28361__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28359__$1,subjects__$1,vec__28366,seq__28367,first__28368,seq__28367__$1,pred__$1,r__$1,subjects__$2,G__28359,vec__28360,seq__28361,first__28362,seq__28361__$1,pred,r,subjects){
return (function (p1__28354_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28354_SHARP_,pred__$1);
});})(G__28359__$1,subjects__$1,vec__28366,seq__28367,first__28368,seq__28367__$1,pred__$1,r__$1,subjects__$2,G__28359,vec__28360,seq__28361,first__28362,seq__28361__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28359__$1,subjects__$1,vec__28366,seq__28367,first__28368,seq__28367__$1,pred__$1,r__$1,subjects__$2,G__28359,vec__28360,seq__28361,first__28362,seq__28361__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__28369 = r__$1;
var G__28370 = next_subjects;
G__28359__$1 = G__28369;
subjects__$1 = G__28370;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28355){if((e28355 instanceof java.lang.Exception)){
var e = e28355;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
} else {
throw e28355;

}
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28371){if((e28371 instanceof java.lang.Exception)){
var e = e28371;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
} else {
throw e28371;

}
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e28372){if((e28372 instanceof java.lang.Exception)){
var e = e28372;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
} else {
throw e28372;

}
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28375 = arguments.length;
var i__4737__auto___28376 = (0);
while(true){
if((i__4737__auto___28376 < len__4736__auto___28375)){
args__4742__auto__.push((arguments[i__4737__auto___28376]));

var G__28377 = (i__4737__auto___28376 + (1));
i__4737__auto___28376 = G__28377;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28374){if((e28374 instanceof java.lang.Exception)){
var e = e28374;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
} else {
throw e28374;

}
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28373){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28373));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28378){if((e28378 instanceof java.lang.Exception)){
var e = e28378;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
} else {
throw e28378;

}
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28381 = arguments.length;
var i__4737__auto___28382 = (0);
while(true){
if((i__4737__auto___28382 < len__4736__auto___28381)){
args__4742__auto__.push((arguments[i__4737__auto___28382]));

var G__28383 = (i__4737__auto___28382 + (1));
i__4737__auto___28382 = G__28383;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28380){if((e28380 instanceof java.lang.Exception)){
var e = e28380;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
} else {
throw e28380;

}
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28379){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28379));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28384){if((e28384 instanceof java.lang.Exception)){
var e = e28384;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
} else {
throw e28384;

}
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28439){
var state_val_28440 = (state_28439[(1)]);
if((state_val_28440 === (7))){
var inst_28386 = (state_28439[(2)]);
var state_28439__$1 = state_28439;
var statearr_28441_28474 = state_28439__$1;
(statearr_28441_28474[(2)] = inst_28386);

(statearr_28441_28474[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (1))){
var state_28439__$1 = state_28439;
var statearr_28442_28475 = state_28439__$1;
(statearr_28442_28475[(2)] = null);

(statearr_28442_28475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (4))){
var inst_28385 = (state_28439[(2)]);
var state_28439__$1 = (function (){var statearr_28443 = state_28439;
(statearr_28443[(7)] = inst_28385);

return statearr_28443;
})();
var statearr_28444_28476 = state_28439__$1;
(statearr_28444_28476[(2)] = null);

(statearr_28444_28476[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (15))){
var inst_28423 = (state_28439[(8)]);
var inst_28427 = inst_28423.o;
var state_28439__$1 = state_28439;
var statearr_28445_28477 = state_28439__$1;
(statearr_28445_28477[(2)] = inst_28427);

(statearr_28445_28477[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (13))){
var inst_28423 = (state_28439[(8)]);
var inst_28419 = (state_28439[(2)]);
var inst_28420 = fluree.db.util.async.throw_err.call(null,inst_28419);
var inst_28421 = fluree.db.dbfunctions.internal.count.call(null,inst_28420);
var inst_28423__$1 = cljs.core.first.call(null,inst_28420);
var inst_28424 = (inst_28423__$1 == null);
var state_28439__$1 = (function (){var statearr_28446 = state_28439;
(statearr_28446[(8)] = inst_28423__$1);

(statearr_28446[(9)] = inst_28421);

return statearr_28446;
})();
if(cljs.core.truth_(inst_28424)){
var statearr_28447_28478 = state_28439__$1;
(statearr_28447_28478[(1)] = (14));

} else {
var statearr_28448_28479 = state_28439__$1;
(statearr_28448_28479[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (6))){
var inst_28395 = (state_28439[(2)]);
var state_28439__$1 = state_28439;
var statearr_28449_28480 = state_28439__$1;
(statearr_28449_28480[(2)] = inst_28395);

(statearr_28449_28480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (3))){
var inst_28437 = (state_28439[(2)]);
var state_28439__$1 = state_28439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28439__$1,inst_28437);
} else {
if((state_val_28440 === (12))){
var inst_28434 = (state_28439[(2)]);
var _ = (function (){var statearr_28450 = state_28439;
(statearr_28450[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28450;
})();
var state_28439__$1 = state_28439;
var statearr_28451_28481 = state_28439__$1;
(statearr_28451_28481[(2)] = inst_28434);

(statearr_28451_28481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (2))){
var _ = (function (){var statearr_28453 = state_28439;
(statearr_28453[(4)] = cljs.core.cons.call(null,(9),(state_28439[(4)])));

return statearr_28453;
})();
var inst_28401 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28402 = typeof inst_28401 === 'string';
var state_28439__$1 = state_28439;
if(cljs.core.truth_(inst_28402)){
var statearr_28454_28482 = state_28439__$1;
(statearr_28454_28482[(1)] = (10));

} else {
var statearr_28455_28483 = state_28439__$1;
(statearr_28455_28483[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (11))){
var inst_28408 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28409 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28408);
var inst_28410 = fluree.db.dbfunctions.internal.inc.call(null,inst_28409);
var inst_28411 = cljs.core.assoc.call(null,inst_28408,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28410);
var inst_28412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28413 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28414 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28415 = [inst_28413,inst_28414];
var inst_28416 = (new cljs.core.PersistentVector(null,2,(5),inst_28412,inst_28415,null));
var inst_28417 = fluree.db.dbproto._search.call(null,inst_28411,inst_28416);
var state_28439__$1 = state_28439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28439__$1,(13),inst_28417);
} else {
if((state_val_28440 === (9))){
var _ = (function (){var statearr_28456 = state_28439;
(statearr_28456[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28456;
})();
var state_28439__$1 = state_28439;
var ex28452 = (state_28439__$1[(2)]);
var statearr_28457_28484 = state_28439__$1;
(statearr_28457_28484[(5)] = ex28452);


if((ex28452 instanceof java.lang.Exception)){
var statearr_28458_28485 = state_28439__$1;
(statearr_28458_28485[(1)] = (4));

(statearr_28458_28485[(5)] = null);

} else {
throw ex28452;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (5))){
var inst_28385 = (state_28439[(7)]);
var _ = (function (){var statearr_28459 = state_28439;
(statearr_28459[(4)] = cljs.core.cons.call(null,(8),(state_28439[(4)])));

return statearr_28459;
})();
var inst_28392 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28385,"?pO","Context Object");
var ___$1 = (function (){var statearr_28460 = state_28439;
(statearr_28460[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28460;
})();
var state_28439__$1 = state_28439;
var statearr_28461_28486 = state_28439__$1;
(statearr_28461_28486[(2)] = inst_28392);

(statearr_28461_28486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (14))){
var state_28439__$1 = state_28439;
var statearr_28462_28487 = state_28439__$1;
(statearr_28462_28487[(2)] = null);

(statearr_28462_28487[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (16))){
var inst_28421 = (state_28439[(9)]);
var inst_28429 = (state_28439[(2)]);
var inst_28430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28431 = [inst_28429,inst_28421];
var inst_28432 = (new cljs.core.PersistentVector(null,2,(5),inst_28430,inst_28431,null));
var state_28439__$1 = state_28439;
var statearr_28464_28488 = state_28439__$1;
(statearr_28464_28488[(2)] = inst_28432);

(statearr_28464_28488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (10))){
var inst_28404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28405 = [null,(0)];
var inst_28406 = (new cljs.core.PersistentVector(null,2,(5),inst_28404,inst_28405,null));
var state_28439__$1 = state_28439;
var statearr_28465_28489 = state_28439__$1;
(statearr_28465_28489[(2)] = inst_28406);

(statearr_28465_28489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28440 === (8))){
var _ = (function (){var statearr_28466 = state_28439;
(statearr_28466[(4)] = cljs.core.rest.call(null,(state_28439[(4)])));

return statearr_28466;
})();
var state_28439__$1 = state_28439;
var ex28463 = (state_28439__$1[(2)]);
var statearr_28467_28490 = state_28439__$1;
(statearr_28467_28490[(5)] = ex28463);


if((ex28463 instanceof java.lang.Exception)){
var statearr_28468_28491 = state_28439__$1;
(statearr_28468_28491[(1)] = (7));

(statearr_28468_28491[(5)] = null);

} else {
throw ex28463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____0 = (function (){
var statearr_28469 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28469[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__);

(statearr_28469[(1)] = (1));

return statearr_28469;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____1 = (function (state_28439){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28470){var ex__2471__auto__ = e28470;
var statearr_28471_28492 = state_28439;
(statearr_28471_28492[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28439[(4)]))){
var statearr_28472_28493 = state_28439;
(statearr_28472_28493[(1)] = cljs.core.first.call(null,(state_28439[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28494 = state_28439;
state_28439 = G__28494;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__ = function(state_28439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____1.call(this,state_28439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28473 = f__2491__auto__.call(null);
(statearr_28473[(6)] = c__2490__auto__);

return statearr_28473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28546){
var state_val_28547 = (state_28546[(1)]);
if((state_val_28547 === (7))){
var inst_28496 = (state_28546[(2)]);
var state_28546__$1 = state_28546;
var statearr_28548_28577 = state_28546__$1;
(statearr_28548_28577[(2)] = inst_28496);

(statearr_28548_28577[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (1))){
var state_28546__$1 = state_28546;
var statearr_28549_28578 = state_28546__$1;
(statearr_28549_28578[(2)] = null);

(statearr_28549_28578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (4))){
var inst_28495 = (state_28546[(2)]);
var state_28546__$1 = (function (){var statearr_28550 = state_28546;
(statearr_28550[(7)] = inst_28495);

return statearr_28550;
})();
var statearr_28551_28579 = state_28546__$1;
(statearr_28551_28579[(2)] = null);

(statearr_28551_28579[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (13))){
var inst_28541 = (state_28546[(2)]);
var _ = (function (){var statearr_28552 = state_28546;
(statearr_28552[(4)] = cljs.core.rest.call(null,(state_28546[(4)])));

return statearr_28552;
})();
var state_28546__$1 = state_28546;
var statearr_28553_28580 = state_28546__$1;
(statearr_28553_28580[(2)] = inst_28541);

(statearr_28553_28580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (6))){
var inst_28505 = (state_28546[(2)]);
var state_28546__$1 = state_28546;
var statearr_28554_28581 = state_28546__$1;
(statearr_28554_28581[(2)] = inst_28505);

(statearr_28554_28581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (3))){
var inst_28544 = (state_28546[(2)]);
var state_28546__$1 = state_28546;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28546__$1,inst_28544);
} else {
if((state_val_28547 === (12))){
var inst_28528 = (state_28546[(8)]);
var inst_28537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28538 = [null,inst_28528];
var inst_28539 = (new cljs.core.PersistentVector(null,2,(5),inst_28537,inst_28538,null));
var state_28546__$1 = state_28546;
var statearr_28555_28582 = state_28546__$1;
(statearr_28555_28582[(2)] = inst_28539);

(statearr_28555_28582[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (2))){
var _ = (function (){var statearr_28557 = state_28546;
(statearr_28557[(4)] = cljs.core.cons.call(null,(9),(state_28546[(4)])));

return statearr_28557;
})();
var inst_28514 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28517 = [null,pred_name,"?o"];
var inst_28518 = (new cljs.core.PersistentVector(null,3,(5),inst_28516,inst_28517,null));
var inst_28519 = [inst_28518];
var inst_28520 = (new cljs.core.PersistentVector(null,1,(5),inst_28515,inst_28519,null));
var inst_28521 = ["?o",inst_28520,opts];
var inst_28522 = cljs.core.PersistentHashMap.fromArrays(inst_28514,inst_28521);
var inst_28523 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28522);
var state_28546__$1 = state_28546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28546__$1,(10),inst_28523);
} else {
if((state_val_28547 === (11))){
var inst_28527 = (state_28546[(9)]);
var inst_28528 = (state_28546[(8)]);
var inst_28532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28533 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_28527);
var inst_28534 = [inst_28533,inst_28528];
var inst_28535 = (new cljs.core.PersistentVector(null,2,(5),inst_28532,inst_28534,null));
var state_28546__$1 = state_28546;
var statearr_28558_28583 = state_28546__$1;
(statearr_28558_28583[(2)] = inst_28535);

(statearr_28558_28583[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (9))){
var _ = (function (){var statearr_28559 = state_28546;
(statearr_28559[(4)] = cljs.core.rest.call(null,(state_28546[(4)])));

return statearr_28559;
})();
var state_28546__$1 = state_28546;
var ex28556 = (state_28546__$1[(2)]);
var statearr_28560_28584 = state_28546__$1;
(statearr_28560_28584[(5)] = ex28556);


if((ex28556 instanceof java.lang.Exception)){
var statearr_28561_28585 = state_28546__$1;
(statearr_28561_28585[(1)] = (4));

(statearr_28561_28585[(5)] = null);

} else {
throw ex28556;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (5))){
var inst_28495 = (state_28546[(7)]);
var _ = (function (){var statearr_28563 = state_28546;
(statearr_28563[(4)] = cljs.core.cons.call(null,(8),(state_28546[(4)])));

return statearr_28563;
})();
var inst_28502 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28495,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_28564 = state_28546;
(statearr_28564[(4)] = cljs.core.rest.call(null,(state_28546[(4)])));

return statearr_28564;
})();
var state_28546__$1 = state_28546;
var statearr_28565_28586 = state_28546__$1;
(statearr_28565_28586[(2)] = inst_28502);

(statearr_28565_28586[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (10))){
var inst_28527 = (state_28546[(9)]);
var inst_28525 = (state_28546[(2)]);
var inst_28526 = fluree.db.util.async.throw_err.call(null,inst_28525);
var inst_28527__$1 = cljs.core.nth.call(null,inst_28526,(0),null);
var inst_28528 = cljs.core.nth.call(null,inst_28526,(1),null);
var inst_28529 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_28527__$1);
var inst_28530 = cljs.core.not.call(null,inst_28529);
var state_28546__$1 = (function (){var statearr_28566 = state_28546;
(statearr_28566[(9)] = inst_28527__$1);

(statearr_28566[(8)] = inst_28528);

return statearr_28566;
})();
if(inst_28530){
var statearr_28567_28587 = state_28546__$1;
(statearr_28567_28587[(1)] = (11));

} else {
var statearr_28568_28588 = state_28546__$1;
(statearr_28568_28588[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28547 === (8))){
var _ = (function (){var statearr_28569 = state_28546;
(statearr_28569[(4)] = cljs.core.rest.call(null,(state_28546[(4)])));

return statearr_28569;
})();
var state_28546__$1 = state_28546;
var ex28562 = (state_28546__$1[(2)]);
var statearr_28570_28589 = state_28546__$1;
(statearr_28570_28589[(5)] = ex28562);


if((ex28562 instanceof java.lang.Exception)){
var statearr_28571_28590 = state_28546__$1;
(statearr_28571_28590[(1)] = (7));

(statearr_28571_28590[(5)] = null);

} else {
throw ex28562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____0 = (function (){
var statearr_28572 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28572[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__);

(statearr_28572[(1)] = (1));

return statearr_28572;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____1 = (function (state_28546){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28546);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28573){var ex__2471__auto__ = e28573;
var statearr_28574_28591 = state_28546;
(statearr_28574_28591[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28546[(4)]))){
var statearr_28575_28592 = state_28546;
(statearr_28575_28592[(1)] = cljs.core.first.call(null,(state_28546[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28593 = state_28546;
state_28546 = G__28593;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__ = function(state_28546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____1.call(this,state_28546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28576 = f__2491__auto__.call(null);
(statearr_28576[(6)] = c__2490__auto__);

return statearr_28576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,((typeof email === 'string')?cljs.core.re_matches.call(null,pattern,email):false));
}catch (e28594){if((e28594 instanceof java.lang.Exception)){
var e = e28594;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
} else {
throw e28594;

}
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28596 = arguments.length;
switch (G__28596) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28666){
var state_val_28667 = (state_28666[(1)]);
if((state_val_28667 === (7))){
var inst_28598 = (state_28666[(2)]);
var state_28666__$1 = state_28666;
var statearr_28668_28712 = state_28666__$1;
(statearr_28668_28712[(2)] = inst_28598);

(statearr_28668_28712[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (20))){
var inst_28642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28643 = ["*"];
var inst_28644 = (new cljs.core.PersistentVector(null,1,(5),inst_28642,inst_28643,null));
var state_28666__$1 = state_28666;
var statearr_28669_28713 = state_28666__$1;
(statearr_28669_28713[(2)] = inst_28644);

(statearr_28669_28713[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (1))){
var state_28666__$1 = state_28666;
var statearr_28670_28714 = state_28666__$1;
(statearr_28670_28714[(2)] = null);

(statearr_28670_28714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (4))){
var inst_28597 = (state_28666[(2)]);
var state_28666__$1 = (function (){var statearr_28671 = state_28666;
(statearr_28671[(7)] = inst_28597);

return statearr_28671;
})();
var statearr_28672_28715 = state_28666__$1;
(statearr_28672_28715[(2)] = null);

(statearr_28672_28715[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (15))){
var inst_28661 = (state_28666[(2)]);
var _ = (function (){var statearr_28673 = state_28666;
(statearr_28673[(4)] = cljs.core.rest.call(null,(state_28666[(4)])));

return statearr_28673;
})();
var state_28666__$1 = state_28666;
var statearr_28674_28716 = state_28666__$1;
(statearr_28674_28716[(2)] = inst_28661);

(statearr_28674_28716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (21))){
var inst_28625 = (state_28666[(8)]);
var inst_28632 = (state_28666[(9)]);
var inst_28646 = (state_28666[(2)]);
var inst_28647 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_28648 = [inst_28646,inst_28632];
var inst_28649 = cljs.core.PersistentHashMap.fromArrays(inst_28647,inst_28648);
var inst_28650 = cljs.core.PersistentHashMap.EMPTY;
var inst_28651 = fluree.db.dbfunctions.internal.query.call(null,inst_28625,inst_28649,inst_28650);
var state_28666__$1 = state_28666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28666__$1,(22),inst_28651);
} else {
if((state_val_28667 === (13))){
var inst_28620 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28666__$1 = state_28666;
var statearr_28675_28717 = state_28666__$1;
(statearr_28675_28717[(2)] = inst_28620);

(statearr_28675_28717[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (22))){
var inst_28653 = (state_28666[(2)]);
var inst_28654 = fluree.db.util.async.throw_err.call(null,inst_28653);
var inst_28655 = cljs.core.nth.call(null,inst_28654,(0),null);
var inst_28656 = cljs.core.nth.call(null,inst_28654,(1),null);
var inst_28657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28658 = [inst_28655,inst_28656];
var inst_28659 = (new cljs.core.PersistentVector(null,2,(5),inst_28657,inst_28658,null));
var state_28666__$1 = state_28666;
var statearr_28676_28718 = state_28666__$1;
(statearr_28676_28718[(2)] = inst_28659);

(statearr_28676_28718[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (6))){
var inst_28607 = (state_28666[(2)]);
var state_28666__$1 = state_28666;
var statearr_28677_28719 = state_28666__$1;
(statearr_28677_28719[(2)] = inst_28607);

(statearr_28677_28719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (17))){
var inst_28629 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28630 = fluree.db.dbfunctions.internal.get.call(null,inst_28629,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28666__$1 = state_28666;
var statearr_28678_28720 = state_28666__$1;
(statearr_28678_28720[(2)] = inst_28630);

(statearr_28678_28720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (3))){
var inst_28664 = (state_28666[(2)]);
var state_28666__$1 = state_28666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28666__$1,inst_28664);
} else {
if((state_val_28667 === (12))){
var inst_28618 = (state_28666[(2)]);
var state_28666__$1 = state_28666;
if(cljs.core.truth_(inst_28618)){
var statearr_28679_28721 = state_28666__$1;
(statearr_28679_28721[(1)] = (13));

} else {
var statearr_28680_28722 = state_28666__$1;
(statearr_28680_28722[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (2))){
var inst_28613 = (state_28666[(10)]);
var _ = (function (){var statearr_28681 = state_28666;
(statearr_28681[(4)] = cljs.core.cons.call(null,(9),(state_28666[(4)])));

return statearr_28681;
})();
var inst_28613__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28666__$1 = (function (){var statearr_28682 = state_28666;
(statearr_28682[(10)] = inst_28613__$1);

return statearr_28682;
})();
if(cljs.core.truth_(inst_28613__$1)){
var statearr_28683_28723 = state_28666__$1;
(statearr_28683_28723[(1)] = (10));

} else {
var statearr_28684_28724 = state_28666__$1;
(statearr_28684_28724[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (19))){
var inst_28634 = cljs.core.PersistentVector.EMPTY;
var inst_28635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28636 = ["*"];
var inst_28637 = (new cljs.core.PersistentVector(null,1,(5),inst_28635,inst_28636,null));
var inst_28638 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28639 = cljs.core.concat.call(null,inst_28637,inst_28638);
var inst_28640 = cljs.core.into.call(null,inst_28634,inst_28639);
var state_28666__$1 = state_28666;
var statearr_28686_28725 = state_28666__$1;
(statearr_28686_28725[(2)] = inst_28640);

(statearr_28686_28725[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (11))){
var inst_28613 = (state_28666[(10)]);
var state_28666__$1 = state_28666;
var statearr_28687_28726 = state_28666__$1;
(statearr_28687_28726[(2)] = inst_28613);

(statearr_28687_28726[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (9))){
var _ = (function (){var statearr_28688 = state_28666;
(statearr_28688[(4)] = cljs.core.rest.call(null,(state_28666[(4)])));

return statearr_28688;
})();
var state_28666__$1 = state_28666;
var ex28685 = (state_28666__$1[(2)]);
var statearr_28689_28727 = state_28666__$1;
(statearr_28689_28727[(5)] = ex28685);


if((ex28685 instanceof java.lang.Exception)){
var statearr_28690_28728 = state_28666__$1;
(statearr_28690_28728[(1)] = (4));

(statearr_28690_28728[(5)] = null);

} else {
throw ex28685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (5))){
var inst_28597 = (state_28666[(7)]);
var _ = (function (){var statearr_28691 = state_28666;
(statearr_28691[(4)] = cljs.core.cons.call(null,(8),(state_28666[(4)])));

return statearr_28691;
})();
var inst_28604 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28597,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_28692 = state_28666;
(statearr_28692[(4)] = cljs.core.rest.call(null,(state_28666[(4)])));

return statearr_28692;
})();
var state_28666__$1 = state_28666;
var statearr_28693_28729 = state_28666__$1;
(statearr_28693_28729[(2)] = inst_28604);

(statearr_28693_28729[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (14))){
var inst_28626 = (state_28666[(11)]);
var inst_28625 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28626__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28666__$1 = (function (){var statearr_28694 = state_28666;
(statearr_28694[(11)] = inst_28626__$1);

(statearr_28694[(8)] = inst_28625);

return statearr_28694;
})();
if(cljs.core.truth_(inst_28626__$1)){
var statearr_28695_28730 = state_28666__$1;
(statearr_28695_28730[(1)] = (16));

} else {
var statearr_28696_28731 = state_28666__$1;
(statearr_28696_28731[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (16))){
var inst_28626 = (state_28666[(11)]);
var state_28666__$1 = state_28666;
var statearr_28697_28732 = state_28666__$1;
(statearr_28697_28732[(2)] = inst_28626);

(statearr_28697_28732[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (10))){
var inst_28615 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_28666__$1 = state_28666;
var statearr_28699_28733 = state_28666__$1;
(statearr_28699_28733[(2)] = inst_28615);

(statearr_28699_28733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (18))){
var inst_28632 = (state_28666[(2)]);
var state_28666__$1 = (function (){var statearr_28700 = state_28666;
(statearr_28700[(9)] = inst_28632);

return statearr_28700;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28701_28734 = state_28666__$1;
(statearr_28701_28734[(1)] = (19));

} else {
var statearr_28702_28735 = state_28666__$1;
(statearr_28702_28735[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28667 === (8))){
var _ = (function (){var statearr_28703 = state_28666;
(statearr_28703[(4)] = cljs.core.rest.call(null,(state_28666[(4)])));

return statearr_28703;
})();
var state_28666__$1 = state_28666;
var ex28698 = (state_28666__$1[(2)]);
var statearr_28704_28736 = state_28666__$1;
(statearr_28704_28736[(5)] = ex28698);


if((ex28698 instanceof java.lang.Exception)){
var statearr_28705_28737 = state_28666__$1;
(statearr_28705_28737[(1)] = (7));

(statearr_28705_28737[(5)] = null);

} else {
throw ex28698;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2468__auto____0 = (function (){
var statearr_28706 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28706[(0)] = fluree$db$dbfunctions$internal$state_machine__2468__auto__);

(statearr_28706[(1)] = (1));

return statearr_28706;
});
var fluree$db$dbfunctions$internal$state_machine__2468__auto____1 = (function (state_28666){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28707){var ex__2471__auto__ = e28707;
var statearr_28708_28738 = state_28666;
(statearr_28708_28738[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28666[(4)]))){
var statearr_28709_28739 = state_28666;
(statearr_28709_28739[(1)] = cljs.core.first.call(null,(state_28666[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28740 = state_28666;
state_28666 = G__28740;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2468__auto__ = function(state_28666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____1.call(this,state_28666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28710 = f__2491__auto__.call(null);
(statearr_28710[(6)] = c__2490__auto__);

return statearr_28710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28742 = arguments.length;
switch (G__28742) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28786){
var state_val_28787 = (state_28786[(1)]);
if((state_val_28787 === (7))){
var inst_28764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28765 = ["*"];
var inst_28766 = (new cljs.core.PersistentVector(null,1,(5),inst_28764,inst_28765,null));
var state_28786__$1 = state_28786;
var statearr_28788_28808 = state_28786__$1;
(statearr_28788_28808[(2)] = inst_28766);

(statearr_28788_28808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (1))){
var state_28786__$1 = state_28786;
var statearr_28789_28809 = state_28786__$1;
(statearr_28789_28809[(2)] = null);

(statearr_28789_28809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (4))){
var inst_28743 = (state_28786[(2)]);
var inst_28744 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28743,"?p","Context Object",additional_params);
var state_28786__$1 = state_28786;
var statearr_28790_28810 = state_28786__$1;
(statearr_28790_28810[(2)] = inst_28744);

(statearr_28790_28810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (6))){
var inst_28756 = cljs.core.PersistentVector.EMPTY;
var inst_28757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28758 = ["*"];
var inst_28759 = (new cljs.core.PersistentVector(null,1,(5),inst_28757,inst_28758,null));
var inst_28760 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28761 = cljs.core.concat.call(null,inst_28759,inst_28760);
var inst_28762 = cljs.core.into.call(null,inst_28756,inst_28761);
var state_28786__$1 = state_28786;
var statearr_28791_28811 = state_28786__$1;
(statearr_28791_28811[(2)] = inst_28762);

(statearr_28791_28811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (3))){
var inst_28784 = (state_28786[(2)]);
var state_28786__$1 = state_28786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28786__$1,inst_28784);
} else {
if((state_val_28787 === (2))){
var _ = (function (){var statearr_28793 = state_28786;
(statearr_28793[(4)] = cljs.core.cons.call(null,(5),(state_28786[(4)])));

return statearr_28793;
})();
var inst_28753 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28754 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28786__$1 = (function (){var statearr_28794 = state_28786;
(statearr_28794[(7)] = inst_28754);

(statearr_28794[(8)] = inst_28753);

return statearr_28794;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28795_28812 = state_28786__$1;
(statearr_28795_28812[(1)] = (6));

} else {
var statearr_28796_28813 = state_28786__$1;
(statearr_28796_28813[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (9))){
var inst_28775 = (state_28786[(2)]);
var inst_28776 = fluree.db.util.async.throw_err.call(null,inst_28775);
var inst_28777 = cljs.core.nth.call(null,inst_28776,(0),null);
var inst_28778 = cljs.core.nth.call(null,inst_28776,(1),null);
var inst_28779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28780 = [inst_28777,inst_28778];
var inst_28781 = (new cljs.core.PersistentVector(null,2,(5),inst_28779,inst_28780,null));
var _ = (function (){var statearr_28797 = state_28786;
(statearr_28797[(4)] = cljs.core.rest.call(null,(state_28786[(4)])));

return statearr_28797;
})();
var state_28786__$1 = state_28786;
var statearr_28798_28814 = state_28786__$1;
(statearr_28798_28814[(2)] = inst_28781);

(statearr_28798_28814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (5))){
var _ = (function (){var statearr_28799 = state_28786;
(statearr_28799[(4)] = cljs.core.rest.call(null,(state_28786[(4)])));

return statearr_28799;
})();
var state_28786__$1 = state_28786;
var ex28792 = (state_28786__$1[(2)]);
var statearr_28800_28815 = state_28786__$1;
(statearr_28800_28815[(5)] = ex28792);


if((ex28792 instanceof java.lang.Exception)){
var statearr_28801_28816 = state_28786__$1;
(statearr_28801_28816[(1)] = (4));

(statearr_28801_28816[(5)] = null);

} else {
throw ex28792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28787 === (8))){
var inst_28754 = (state_28786[(7)]);
var inst_28753 = (state_28786[(8)]);
var inst_28768 = (state_28786[(2)]);
var inst_28769 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_28770 = [inst_28768,inst_28754];
var inst_28771 = cljs.core.PersistentHashMap.fromArrays(inst_28769,inst_28770);
var inst_28772 = cljs.core.PersistentHashMap.EMPTY;
var inst_28773 = fluree.db.dbfunctions.internal.query.call(null,inst_28753,inst_28771,inst_28772);
var state_28786__$1 = state_28786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28786__$1,(9),inst_28773);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2468__auto____0 = (function (){
var statearr_28802 = [null,null,null,null,null,null,null,null,null];
(statearr_28802[(0)] = fluree$db$dbfunctions$internal$state_machine__2468__auto__);

(statearr_28802[(1)] = (1));

return statearr_28802;
});
var fluree$db$dbfunctions$internal$state_machine__2468__auto____1 = (function (state_28786){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28803){var ex__2471__auto__ = e28803;
var statearr_28804_28817 = state_28786;
(statearr_28804_28817[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28786[(4)]))){
var statearr_28805_28818 = state_28786;
(statearr_28805_28818[(1)] = cljs.core.first.call(null,(state_28786[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28819 = state_28786;
state_28786 = G__28819;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2468__auto__ = function(state_28786){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2468__auto____1.call(this,state_28786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28806 = f__2491__auto__.call(null);
(statearr_28806[(6)] = c__2490__auto__);

return statearr_28806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28863){
var state_val_28864 = (state_28863[(1)]);
if((state_val_28864 === (1))){
var state_28863__$1 = state_28863;
var statearr_28865_28879 = state_28863__$1;
(statearr_28865_28879[(2)] = null);

(statearr_28865_28879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (2))){
var _ = (function (){var statearr_28866 = state_28863;
(statearr_28866[(4)] = cljs.core.cons.call(null,(5),(state_28863[(4)])));

return statearr_28866;
})();
var inst_28830 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_28831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28832 = ["_user/_auth"];
var inst_28833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28834 = ["*"];
var inst_28835 = (new cljs.core.PersistentVector(null,1,(5),inst_28833,inst_28834,null));
var inst_28836 = [inst_28835];
var inst_28837 = cljs.core.PersistentHashMap.fromArrays(inst_28832,inst_28836);
var inst_28838 = [inst_28837];
var inst_28839 = (new cljs.core.PersistentVector(null,1,(5),inst_28831,inst_28838,null));
var inst_28840 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28841 = [inst_28839,inst_28840];
var inst_28842 = cljs.core.PersistentHashMap.fromArrays(inst_28830,inst_28841);
var inst_28843 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28844 = cljs.core.PersistentHashMap.EMPTY;
var inst_28845 = fluree.db.dbfunctions.internal.query.call(null,inst_28843,inst_28842,inst_28844);
var state_28863__$1 = state_28863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28863__$1,(6),inst_28845);
} else {
if((state_val_28864 === (3))){
var inst_28861 = (state_28863[(2)]);
var state_28863__$1 = state_28863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28863__$1,inst_28861);
} else {
if((state_val_28864 === (4))){
var inst_28820 = (state_28863[(2)]);
var inst_28821 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28820,"?user_id-from-auth","Context Object");
var state_28863__$1 = state_28863;
var statearr_28868_28880 = state_28863__$1;
(statearr_28868_28880[(2)] = inst_28821);

(statearr_28868_28880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (5))){
var _ = (function (){var statearr_28869 = state_28863;
(statearr_28869[(4)] = cljs.core.rest.call(null,(state_28863[(4)])));

return statearr_28869;
})();
var state_28863__$1 = state_28863;
var ex28867 = (state_28863__$1[(2)]);
var statearr_28870_28881 = state_28863__$1;
(statearr_28870_28881[(5)] = ex28867);


if((ex28867 instanceof java.lang.Exception)){
var statearr_28871_28882 = state_28863__$1;
(statearr_28871_28882[(1)] = (4));

(statearr_28871_28882[(5)] = null);

} else {
throw ex28867;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28864 === (6))){
var inst_28847 = (state_28863[(2)]);
var inst_28848 = fluree.db.util.async.throw_err.call(null,inst_28847);
var inst_28849 = cljs.core.nth.call(null,inst_28848,(0),null);
var inst_28850 = cljs.core.nth.call(null,inst_28848,(1),null);
var inst_28851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28852 = ["_user/_auth","_id"];
var inst_28853 = (new cljs.core.PersistentVector(null,2,(5),inst_28851,inst_28852,null));
var inst_28854 = fluree.db.dbfunctions.internal.get_in.call(null,inst_28849,inst_28853);
var inst_28855 = cljs.core.first.call(null,inst_28854);
var inst_28856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28857 = [inst_28855,inst_28850];
var inst_28858 = (new cljs.core.PersistentVector(null,2,(5),inst_28856,inst_28857,null));
var _ = (function (){var statearr_28872 = state_28863;
(statearr_28872[(4)] = cljs.core.rest.call(null,(state_28863[(4)])));

return statearr_28872;
})();
var state_28863__$1 = state_28863;
var statearr_28873_28883 = state_28863__$1;
(statearr_28873_28883[(2)] = inst_28858);

(statearr_28873_28883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____0 = (function (){
var statearr_28874 = [null,null,null,null,null,null,null];
(statearr_28874[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__);

(statearr_28874[(1)] = (1));

return statearr_28874;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____1 = (function (state_28863){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28875){var ex__2471__auto__ = e28875;
var statearr_28876_28884 = state_28863;
(statearr_28876_28884[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28863[(4)]))){
var statearr_28877_28885 = state_28863;
(statearr_28877_28885[(1)] = cljs.core.first.call(null,(state_28863[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28886 = state_28863;
state_28863 = G__28886;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__ = function(state_28863){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____1.call(this,state_28863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28878 = f__2491__auto__.call(null);
(statearr_28878[(6)] = c__2490__auto__);

return statearr_28878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_28903){
var state_val_28904 = (state_28903[(1)]);
if((state_val_28904 === (1))){
var state_28903__$1 = state_28903;
var statearr_28905_28919 = state_28903__$1;
(statearr_28905_28919[(2)] = null);

(statearr_28905_28919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (2))){
var _ = (function (){var statearr_28906 = state_28903;
(statearr_28906[(4)] = cljs.core.cons.call(null,(5),(state_28903[(4)])));

return statearr_28906;
})();
var inst_28893 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28894 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28895 = fluree.db.dbproto._subid.call(null,inst_28894,inst_28893);
var state_28903__$1 = state_28903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28903__$1,(6),inst_28895);
} else {
if((state_val_28904 === (3))){
var inst_28901 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28903__$1,inst_28901);
} else {
if((state_val_28904 === (4))){
var inst_28887 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
var statearr_28908_28920 = state_28903__$1;
(statearr_28908_28920[(2)] = inst_28887);

(statearr_28908_28920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (5))){
var _ = (function (){var statearr_28909 = state_28903;
(statearr_28909[(4)] = cljs.core.rest.call(null,(state_28903[(4)])));

return statearr_28909;
})();
var state_28903__$1 = state_28903;
var ex28907 = (state_28903__$1[(2)]);
var statearr_28910_28921 = state_28903__$1;
(statearr_28910_28921[(5)] = ex28907);


if((ex28907 instanceof Error)){
var statearr_28911_28922 = state_28903__$1;
(statearr_28911_28922[(1)] = (4));

(statearr_28911_28922[(5)] = null);

} else {
throw ex28907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (6))){
var inst_28897 = (state_28903[(2)]);
var inst_28898 = fluree.db.util.async.throw_err.call(null,inst_28897);
var _ = (function (){var statearr_28912 = state_28903;
(statearr_28912[(4)] = cljs.core.rest.call(null,(state_28903[(4)])));

return statearr_28912;
})();
var state_28903__$1 = state_28903;
var statearr_28913_28923 = state_28903__$1;
(statearr_28913_28923[(2)] = inst_28898);

(statearr_28913_28923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____0 = (function (){
var statearr_28914 = [null,null,null,null,null,null,null];
(statearr_28914[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__);

(statearr_28914[(1)] = (1));

return statearr_28914;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____1 = (function (state_28903){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_28903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e28915){var ex__2471__auto__ = e28915;
var statearr_28916_28924 = state_28903;
(statearr_28916_28924[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_28903[(4)]))){
var statearr_28917_28925 = state_28903;
(statearr_28917_28925[(1)] = cljs.core.first.call(null,(state_28903[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28926 = state_28903;
state_28903 = G__28926;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__ = function(state_28903){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____1.call(this,state_28903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_28918 = f__2491__auto__.call(null);
(statearr_28918[(6)] = c__2490__auto__);

return statearr_28918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__28927_SHARP_){
return p1__28927_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__28928_SHARP_){
return p1__28928_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e28929){if((e28929 instanceof java.lang.Exception)){
var e = e28929;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
} else {
throw e28929;

}
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__28930_SHARP_){
return p1__28930_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__28931_SHARP_){
return p1__28931_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e28932){if((e28932 instanceof java.lang.Exception)){
var e = e28932;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
} else {
throw e28932;

}
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e28933){if((e28933 instanceof java.lang.Exception)){
var e = e28933;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
} else {
throw e28933;

}
}});

//# sourceMappingURL=internal.js.map
