// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k16089,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__16093 = k16089;
var G__16093__$1 = (((G__16093 instanceof cljs.core.Keyword))?G__16093.fqn:null);
switch (G__16093__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k16089,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__16094){
var vec__16095 = p__16094;
var k__4403__auto__ = cljs.core.nth.call(null,vec__16095,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__16095,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__16088){
var self__ = this;
var G__16088__$1 = this;
return (new cljs.core.RecordIter((0),G__16088__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this16090,other16091){
var self__ = this;
var this16090__$1 = this;
return (((!((other16091 == null)))) && ((this16090__$1.constructor === other16091.constructor)) && (cljs.core._EQ_.call(null,this16090__$1.index_type,other16091.index_type)) && (cljs.core._EQ_.call(null,this16090__$1.comparator,other16091.comparator)) && (cljs.core._EQ_.call(null,this16090__$1.historyComparator,other16091.historyComparator)) && (cljs.core._EQ_.call(null,this16090__$1.__extmap,other16091.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__16088){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__16098 = cljs.core.keyword_identical_QMARK_;
var expr__16099 = k__4388__auto__;
if(cljs.core.truth_(pred__16098.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__16099))){
return (new fluree.db.index.IndexConfig(G__16088,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16098.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__16099))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__16088,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16098.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__16099))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__16088,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__16088),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__16088){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__16088,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__16092){
var extmap__4419__auto__ = (function (){var G__16101 = cljs.core.dissoc.call(null,G__16092,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__16092)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__16101);
} else {
return G__16101;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__16092),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__16092),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__16092),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k16104,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__16108 = k16104;
var G__16108__$1 = (((G__16108 instanceof cljs.core.Keyword))?G__16108.fqn:null);
switch (G__16108__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k16104,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__16109){
var vec__16110 = p__16109;
var k__4403__auto__ = cljs.core.nth.call(null,vec__16110,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__16110,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__16103){
var self__ = this;
var G__16103__$1 = this;
return (new cljs.core.RecordIter((0),G__16103__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16114){
var state_val_16115 = (state_16114[(1)]);
if((state_val_16115 === (1))){
var state_16114__$1 = state_16114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16114__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2468__auto__ = null;
var fluree$db$index$state_machine__2468__auto____0 = (function (){
var statearr_16116 = [null,null,null,null,null,null,null];
(statearr_16116[(0)] = fluree$db$index$state_machine__2468__auto__);

(statearr_16116[(1)] = (1));

return statearr_16116;
});
var fluree$db$index$state_machine__2468__auto____1 = (function (state_16114){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16117){var ex__2471__auto__ = e16117;
var statearr_16118_16216 = state_16114;
(statearr_16118_16216[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16114[(4)]))){
var statearr_16119_16217 = state_16114;
(statearr_16119_16217[(1)] = cljs.core.first.call(null,(state_16114[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16218 = state_16114;
state_16114 = G__16218;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$index$state_machine__2468__auto__ = function(state_16114){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2468__auto____1.call(this,state_16114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2468__auto____0;
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2468__auto____1;
return fluree$db$index$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16120 = f__2491__auto__.call(null);
(statearr_16120[(6)] = c__2490__auto__);

return statearr_16120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16145){
var state_val_16146 = (state_16145[(1)]);
if((state_val_16146 === (7))){
var inst_16127 = (state_16145[(7)]);
var inst_16131 = fluree.db.dbproto._resolve.call(null,inst_16127);
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16145__$1,(10),inst_16131);
} else {
if((state_val_16146 === (1))){
var state_16145__$1 = state_16145;
var statearr_16147_16219 = state_16145__$1;
(statearr_16147_16219[(2)] = null);

(statearr_16147_16219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (4))){
var inst_16121 = (state_16145[(2)]);
var state_16145__$1 = state_16145;
var statearr_16148_16220 = state_16145__$1;
(statearr_16148_16220[(2)] = inst_16121);

(statearr_16148_16220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (6))){
var inst_16127 = (state_16145[(7)]);
var state_16145__$1 = state_16145;
var statearr_16149_16221 = state_16145__$1;
(statearr_16149_16221[(2)] = inst_16127);

(statearr_16149_16221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (3))){
var inst_16143 = (state_16145[(2)]);
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16145__$1,inst_16143);
} else {
if((state_val_16146 === (2))){
var inst_16127 = (state_16145[(7)]);
var _ = (function (){var statearr_16151 = state_16145;
(statearr_16151[(4)] = cljs.core.cons.call(null,(5),(state_16145[(4)])));

return statearr_16151;
})();
var inst_16127__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_16128 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_16127__$1);
var state_16145__$1 = (function (){var statearr_16152 = state_16145;
(statearr_16152[(7)] = inst_16127__$1);

return statearr_16152;
})();
if(cljs.core.truth_(inst_16128)){
var statearr_16153_16222 = state_16145__$1;
(statearr_16153_16222[(1)] = (6));

} else {
var statearr_16154_16223 = state_16145__$1;
(statearr_16154_16223[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (9))){
var inst_16137 = (state_16145[(2)]);
var inst_16138 = fluree.db.util.async.throw_err.call(null,inst_16137);
var state_16145__$1 = state_16145;
var statearr_16155_16224 = state_16145__$1;
(statearr_16155_16224[(2)] = inst_16138);

(statearr_16155_16224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (5))){
var _ = (function (){var statearr_16156 = state_16145;
(statearr_16156[(4)] = cljs.core.rest.call(null,(state_16145[(4)])));

return statearr_16156;
})();
var state_16145__$1 = state_16145;
var ex16150 = (state_16145__$1[(2)]);
var statearr_16157_16225 = state_16145__$1;
(statearr_16157_16225[(5)] = ex16150);


if((ex16150 instanceof Error)){
var statearr_16158_16226 = state_16145__$1;
(statearr_16158_16226[(1)] = (4));

(statearr_16158_16226[(5)] = null);

} else {
throw ex16150;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16146 === (10))){
var inst_16133 = (state_16145[(2)]);
var inst_16134 = fluree.db.util.async.throw_err.call(null,inst_16133);
var inst_16135 = fluree.db.dbproto._lookup_leaf.call(null,inst_16134,flake);
var state_16145__$1 = state_16145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16145__$1,(9),inst_16135);
} else {
if((state_val_16146 === (8))){
var inst_16140 = (state_16145[(2)]);
var _ = (function (){var statearr_16159 = state_16145;
(statearr_16159[(4)] = cljs.core.rest.call(null,(state_16145[(4)])));

return statearr_16159;
})();
var state_16145__$1 = state_16145;
var statearr_16160_16227 = state_16145__$1;
(statearr_16160_16227[(2)] = inst_16140);

(statearr_16160_16227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2468__auto__ = null;
var fluree$db$index$state_machine__2468__auto____0 = (function (){
var statearr_16161 = [null,null,null,null,null,null,null,null];
(statearr_16161[(0)] = fluree$db$index$state_machine__2468__auto__);

(statearr_16161[(1)] = (1));

return statearr_16161;
});
var fluree$db$index$state_machine__2468__auto____1 = (function (state_16145){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16162){var ex__2471__auto__ = e16162;
var statearr_16163_16228 = state_16145;
(statearr_16163_16228[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16145[(4)]))){
var statearr_16164_16229 = state_16145;
(statearr_16164_16229[(1)] = cljs.core.first.call(null,(state_16145[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16230 = state_16145;
state_16145 = G__16230;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$index$state_machine__2468__auto__ = function(state_16145){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2468__auto____1.call(this,state_16145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2468__auto____0;
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2468__auto____1;
return fluree$db$index$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16165 = f__2491__auto__.call(null);
(statearr_16165[(6)] = c__2490__auto__);

return statearr_16165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16190){
var state_val_16191 = (state_16190[(1)]);
if((state_val_16191 === (7))){
var inst_16172 = (state_16190[(7)]);
var inst_16176 = fluree.db.dbproto._resolve.call(null,inst_16172);
var state_16190__$1 = state_16190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16190__$1,(10),inst_16176);
} else {
if((state_val_16191 === (1))){
var state_16190__$1 = state_16190;
var statearr_16192_16231 = state_16190__$1;
(statearr_16192_16231[(2)] = null);

(statearr_16192_16231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (4))){
var inst_16166 = (state_16190[(2)]);
var state_16190__$1 = state_16190;
var statearr_16193_16232 = state_16190__$1;
(statearr_16193_16232[(2)] = inst_16166);

(statearr_16193_16232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (6))){
var inst_16172 = (state_16190[(7)]);
var state_16190__$1 = state_16190;
var statearr_16194_16233 = state_16190__$1;
(statearr_16194_16233[(2)] = inst_16172);

(statearr_16194_16233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (3))){
var inst_16188 = (state_16190[(2)]);
var state_16190__$1 = state_16190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16190__$1,inst_16188);
} else {
if((state_val_16191 === (2))){
var inst_16172 = (state_16190[(7)]);
var _ = (function (){var statearr_16196 = state_16190;
(statearr_16196[(4)] = cljs.core.cons.call(null,(5),(state_16190[(4)])));

return statearr_16196;
})();
var inst_16172__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_16173 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_16172__$1);
var state_16190__$1 = (function (){var statearr_16197 = state_16190;
(statearr_16197[(7)] = inst_16172__$1);

return statearr_16197;
})();
if(cljs.core.truth_(inst_16173)){
var statearr_16198_16234 = state_16190__$1;
(statearr_16198_16234[(1)] = (6));

} else {
var statearr_16199_16235 = state_16190__$1;
(statearr_16199_16235[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (9))){
var inst_16182 = (state_16190[(2)]);
var inst_16183 = fluree.db.util.async.throw_err.call(null,inst_16182);
var state_16190__$1 = state_16190;
var statearr_16200_16236 = state_16190__$1;
(statearr_16200_16236[(2)] = inst_16183);

(statearr_16200_16236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (5))){
var _ = (function (){var statearr_16201 = state_16190;
(statearr_16201[(4)] = cljs.core.rest.call(null,(state_16190[(4)])));

return statearr_16201;
})();
var state_16190__$1 = state_16190;
var ex16195 = (state_16190__$1[(2)]);
var statearr_16202_16237 = state_16190__$1;
(statearr_16202_16237[(5)] = ex16195);


if((ex16195 instanceof Error)){
var statearr_16203_16238 = state_16190__$1;
(statearr_16203_16238[(1)] = (4));

(statearr_16203_16238[(5)] = null);

} else {
throw ex16195;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16191 === (10))){
var inst_16178 = (state_16190[(2)]);
var inst_16179 = fluree.db.util.async.throw_err.call(null,inst_16178);
var inst_16180 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_16179,flake);
var state_16190__$1 = state_16190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16190__$1,(9),inst_16180);
} else {
if((state_val_16191 === (8))){
var inst_16185 = (state_16190[(2)]);
var _ = (function (){var statearr_16204 = state_16190;
(statearr_16204[(4)] = cljs.core.rest.call(null,(state_16190[(4)])));

return statearr_16204;
})();
var state_16190__$1 = state_16190;
var statearr_16205_16239 = state_16190__$1;
(statearr_16205_16239[(2)] = inst_16185);

(statearr_16205_16239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2468__auto__ = null;
var fluree$db$index$state_machine__2468__auto____0 = (function (){
var statearr_16206 = [null,null,null,null,null,null,null,null];
(statearr_16206[(0)] = fluree$db$index$state_machine__2468__auto__);

(statearr_16206[(1)] = (1));

return statearr_16206;
});
var fluree$db$index$state_machine__2468__auto____1 = (function (state_16190){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16207){var ex__2471__auto__ = e16207;
var statearr_16208_16240 = state_16190;
(statearr_16208_16240[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16190[(4)]))){
var statearr_16209_16241 = state_16190;
(statearr_16209_16241[(1)] = cljs.core.first.call(null,(state_16190[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16242 = state_16190;
state_16190 = G__16242;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$index$state_machine__2468__auto__ = function(state_16190){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2468__auto____1.call(this,state_16190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2468__auto____0;
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2468__auto____1;
return fluree$db$index$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16210 = f__2491__auto__.call(null);
(statearr_16210[(6)] = c__2490__auto__);

return statearr_16210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this16105,other16106){
var self__ = this;
var this16105__$1 = this;
return (((!((other16106 == null)))) && ((this16105__$1.constructor === other16106.constructor)) && (cljs.core._EQ_.call(null,this16105__$1.block,other16106.block)) && (cljs.core._EQ_.call(null,this16105__$1.t,other16106.t)) && (cljs.core._EQ_.call(null,this16105__$1.rhs,other16106.rhs)) && (cljs.core._EQ_.call(null,this16105__$1.children,other16106.children)) && (cljs.core._EQ_.call(null,this16105__$1.config,other16106.config)) && (cljs.core._EQ_.call(null,this16105__$1.leftmost_QMARK_,other16106.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this16105__$1.__extmap,other16106.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__16103){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__16211 = cljs.core.keyword_identical_QMARK_;
var expr__16212 = k__4388__auto__;
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__16212))){
return (new fluree.db.index.IndexNode(G__16103,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__16212))){
return (new fluree.db.index.IndexNode(self__.block,G__16103,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__16212))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__16103,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__16212))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__16103,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__16212))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__16103,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16211.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__16212))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__16103,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__16103),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__16103){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__16103,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__16107){
var extmap__4419__auto__ = (function (){var G__16214 = cljs.core.dissoc.call(null,G__16107,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__16107)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__16214);
} else {
return G__16214;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__16107),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__16107),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__16107),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__16107),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__16107),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__16107),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k16244,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__16248 = k16244;
var G__16248__$1 = (((G__16248 instanceof cljs.core.Keyword))?G__16248.fqn:null);
switch (G__16248__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k16244,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__16249){
var vec__16250 = p__16249;
var k__4403__auto__ = cljs.core.nth.call(null,vec__16250,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__16250,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__16243){
var self__ = this;
var G__16243__$1 = this;
return (new cljs.core.RecordIter((0),G__16243__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16254){
var state_val_16255 = (state_16254[(1)]);
if((state_val_16255 === (1))){
var state_16254__$1 = state_16254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16254__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2468__auto__ = null;
var fluree$db$index$state_machine__2468__auto____0 = (function (){
var statearr_16256 = [null,null,null,null,null,null,null];
(statearr_16256[(0)] = fluree$db$index$state_machine__2468__auto__);

(statearr_16256[(1)] = (1));

return statearr_16256;
});
var fluree$db$index$state_machine__2468__auto____1 = (function (state_16254){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16257){var ex__2471__auto__ = e16257;
var statearr_16258_16278 = state_16254;
(statearr_16258_16278[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16254[(4)]))){
var statearr_16259_16279 = state_16254;
(statearr_16259_16279[(1)] = cljs.core.first.call(null,(state_16254[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16280 = state_16254;
state_16254 = G__16280;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$index$state_machine__2468__auto__ = function(state_16254){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2468__auto____1.call(this,state_16254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2468__auto____0;
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2468__auto____1;
return fluree$db$index$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16260 = f__2491__auto__.call(null);
(statearr_16260[(6)] = c__2490__auto__);

return statearr_16260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_16266){
var state_val_16267 = (state_16266[(1)]);
if((state_val_16267 === (1))){
var inst_16261 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16262 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_16263 = cljs.core.PersistentHashMap.fromArrays(inst_16261,inst_16262);
var inst_16264 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_16263);
var state_16266__$1 = state_16266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16266__$1,inst_16264);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2468__auto__ = null;
var fluree$db$index$state_machine__2468__auto____0 = (function (){
var statearr_16268 = [null,null,null,null,null,null,null];
(statearr_16268[(0)] = fluree$db$index$state_machine__2468__auto__);

(statearr_16268[(1)] = (1));

return statearr_16268;
});
var fluree$db$index$state_machine__2468__auto____1 = (function (state_16266){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_16266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e16269){var ex__2471__auto__ = e16269;
var statearr_16270_16281 = state_16266;
(statearr_16270_16281[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_16266[(4)]))){
var statearr_16271_16282 = state_16266;
(statearr_16271_16282[(1)] = cljs.core.first.call(null,(state_16266[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16283 = state_16266;
state_16266 = G__16283;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$index$state_machine__2468__auto__ = function(state_16266){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2468__auto____1.call(this,state_16266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2468__auto____0;
fluree$db$index$state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2468__auto____1;
return fluree$db$index$state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_16272 = f__2491__auto__.call(null);
(statearr_16272[(6)] = c__2490__auto__);

return statearr_16272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this16245,other16246){
var self__ = this;
var this16245__$1 = this;
return (((!((other16246 == null)))) && ((this16245__$1.constructor === other16246.constructor)) && (cljs.core._EQ_.call(null,this16245__$1.block,other16246.block)) && (cljs.core._EQ_.call(null,this16245__$1.t,other16246.t)) && (cljs.core._EQ_.call(null,this16245__$1.flakes,other16246.flakes)) && (cljs.core._EQ_.call(null,this16245__$1.rhs,other16246.rhs)) && (cljs.core._EQ_.call(null,this16245__$1.config,other16246.config)) && (cljs.core._EQ_.call(null,this16245__$1.__extmap,other16246.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__16243){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__16273 = cljs.core.keyword_identical_QMARK_;
var expr__16274 = k__4388__auto__;
if(cljs.core.truth_(pred__16273.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__16274))){
return (new fluree.db.index.DataNode(G__16243,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16273.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__16274))){
return (new fluree.db.index.DataNode(self__.block,G__16243,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16273.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__16274))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__16243,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16273.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__16274))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__16243,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16273.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__16274))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__16243,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__16243),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__16243){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__16243,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__16247){
var extmap__4419__auto__ = (function (){var G__16276 = cljs.core.dissoc.call(null,G__16247,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__16247)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__16276);
} else {
return G__16276;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__16247),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__16247),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__16247),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__16247),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__16247),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});

//# sourceMappingURL=index.js.map
