// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__18991 = cljs.core._EQ_;
var expr__18992 = e.getLastErrorCode();
if(cljs.core.truth_(pred__18991.call(null,goog.net.ErrorCode.NO_ERROR,expr__18992))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__18991.call(null,goog.net.ErrorCode.EXCEPTION,expr__18992))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__18991.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__18992))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__18991.call(null,goog.net.ErrorCode.ABORT,expr__18992))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__18991.call(null,goog.net.ErrorCode.TIMEOUT,expr__18992))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__18994 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__18994,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__18994;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__18995 = opts;
var map__18995__$1 = (((((!((map__18995 == null))))?(((((map__18995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18995):map__18995);
var request_timeout = cljs.core.get.call(null,map__18995__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__18995__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__18995__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__18997 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__18997__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__18997,headers):G__18997);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__18997__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__18997__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e18998){var e_18999 = e18998;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_18999);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19000 = opts;
var map__19000__$1 = (((((!((map__19000 == null))))?(((((map__19000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19000):map__19000);
var request_timeout = cljs.core.get.call(null,map__19000__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__19000__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__19000__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__19000__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__19000__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__19002 = cljs.core.PersistentArrayMap.EMPTY;
var G__19002__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__19002,headers):G__19002);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__19002__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19002__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__19004 = output_format;
var G__19004__$1 = (((G__19004 instanceof cljs.core.Keyword))?G__19004.fqn:null);
switch (G__19004__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e19003){var e_19006 = e19003;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_19006);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19007 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__19007,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19007;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2490__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19040){
var state_val_19041 = (state_19040[(1)]);
if((state_val_19041 === (7))){
var inst_19036 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
var statearr_19042_19067 = state_19040__$1;
(statearr_19042_19067[(2)] = inst_19036);

(statearr_19042_19067[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (1))){
var state_19040__$1 = state_19040;
var statearr_19043_19068 = state_19040__$1;
(statearr_19043_19068[(2)] = null);

(statearr_19043_19068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (4))){
var inst_19011 = (state_19040[(7)]);
var inst_19011__$1 = (state_19040[(2)]);
var inst_19012 = (inst_19011__$1 == null);
var state_19040__$1 = (function (){var statearr_19044 = state_19040;
(statearr_19044[(7)] = inst_19011__$1);

return statearr_19044;
})();
if(cljs.core.truth_(inst_19012)){
var statearr_19045_19069 = state_19040__$1;
(statearr_19045_19069[(1)] = (5));

} else {
var statearr_19046_19070 = state_19040__$1;
(statearr_19046_19070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (6))){
var inst_19011 = (state_19040[(7)]);
var inst_19019 = cljs.core.nth.call(null,inst_19011,(0),null);
var inst_19020 = cljs.core.nth.call(null,inst_19011,(1),null);
var state_19040__$1 = (function (){var statearr_19047 = state_19040;
(statearr_19047[(8)] = inst_19019);

(statearr_19047[(9)] = inst_19020);

return statearr_19047;
})();
var statearr_19048_19071 = state_19040__$1;
(statearr_19048_19071[(2)] = null);

(statearr_19048_19071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (3))){
var inst_19038 = (state_19040[(2)]);
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19040__$1,inst_19038);
} else {
if((state_val_19041 === (2))){
var state_19040__$1 = state_19040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19040__$1,(4),pub_chan);
} else {
if((state_val_19041 === (11))){
var _ = (function (){var statearr_19050 = state_19040;
(statearr_19050[(4)] = cljs.core.rest.call(null,(state_19040[(4)])));

return statearr_19050;
})();
var state_19040__$1 = state_19040;
var ex19049 = (state_19040__$1[(2)]);
var statearr_19051_19072 = state_19040__$1;
(statearr_19051_19072[(5)] = ex19049);


if((ex19049 instanceof Error)){
var statearr_19052_19073 = state_19040__$1;
(statearr_19052_19073[(1)] = (10));

(statearr_19052_19073[(5)] = null);

} else {
throw ex19049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (9))){
var inst_19033 = (state_19040[(2)]);
var state_19040__$1 = (function (){var statearr_19053 = state_19040;
(statearr_19053[(10)] = inst_19033);

return statearr_19053;
})();
var statearr_19054_19074 = state_19040__$1;
(statearr_19054_19074[(2)] = null);

(statearr_19054_19074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (5))){
var inst_19014 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_19040__$1 = state_19040;
var statearr_19055_19075 = state_19040__$1;
(statearr_19055_19075[(2)] = inst_19014);

(statearr_19055_19075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (10))){
var inst_19020 = (state_19040[(9)]);
var inst_19021 = (state_19040[(2)]);
var inst_19022 = fluree.db.util.log.error.call(null,inst_19021,"Websocket send message error:",inst_19021);
var inst_19023 = cljs.core.async.put_BANG_.call(null,inst_19020,false);
var state_19040__$1 = (function (){var statearr_19056 = state_19040;
(statearr_19056[(11)] = inst_19022);

return statearr_19056;
})();
var statearr_19057_19076 = state_19040__$1;
(statearr_19057_19076[(2)] = inst_19023);

(statearr_19057_19076[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19041 === (8))){
var inst_19019 = (state_19040[(8)]);
var inst_19020 = (state_19040[(9)]);
var _ = (function (){var statearr_19058 = state_19040;
(statearr_19058[(4)] = cljs.core.cons.call(null,(11),(state_19040[(4)])));

return statearr_19058;
})();
var inst_19029 = ws.send(inst_19019);
var inst_19030 = cljs.core.async.put_BANG_.call(null,inst_19020,true);
var ___$1 = (function (){var statearr_19059 = state_19040;
(statearr_19059[(4)] = cljs.core.rest.call(null,(state_19040[(4)])));

return statearr_19059;
})();
var state_19040__$1 = (function (){var statearr_19060 = state_19040;
(statearr_19060[(12)] = inst_19029);

return statearr_19060;
})();
var statearr_19061_19077 = state_19040__$1;
(statearr_19061_19077[(2)] = inst_19030);

(statearr_19061_19077[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____0 = (function (){
var statearr_19062 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19062[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__);

(statearr_19062[(1)] = (1));

return statearr_19062;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____1 = (function (state_19040){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19063){var ex__2471__auto__ = e19063;
var statearr_19064_19078 = state_19040;
(statearr_19064_19078[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19040[(4)]))){
var statearr_19065_19079 = state_19040;
(statearr_19065_19079[(1)] = cljs.core.first.call(null,(state_19040[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19080 = state_19040;
state_19040 = G__19080;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__ = function(state_19040){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____1.call(this,state_19040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19066 = f__2491__auto__.call(null);
(statearr_19066[(6)] = c__2490__auto__);

return statearr_19066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));

return c__2490__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2490__auto___19119 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2491__auto__ = (function (){var switch__2467__auto__ = (function (state_19106){
var state_val_19107 = (state_19106[(1)]);
if((state_val_19107 === (1))){
var inst_19085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19086 = [open_QMARK_,timeout_chan];
var inst_19087 = (new cljs.core.PersistentVector(null,2,(5),inst_19085,inst_19086,null));
var state_19106__$1 = state_19106;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19106__$1,(2),inst_19087,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19107 === (2))){
var inst_19089 = (state_19106[(2)]);
var inst_19090 = cljs.core.nth.call(null,inst_19089,(0),null);
var inst_19091 = cljs.core.nth.call(null,inst_19089,(1),null);
var inst_19092 = cljs.core._EQ_.call(null,inst_19091,timeout_chan);
var state_19106__$1 = (function (){var statearr_19108 = state_19106;
(statearr_19108[(7)] = inst_19090);

return statearr_19108;
})();
if(inst_19092){
var statearr_19109_19120 = state_19106__$1;
(statearr_19109_19120[(1)] = (3));

} else {
var statearr_19110_19121 = state_19106__$1;
(statearr_19110_19121[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (3))){
var inst_19094 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19095 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19096 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19097 = cljs.core.PersistentHashMap.fromArrays(inst_19095,inst_19096);
var inst_19098 = cljs.core.ex_info.call(null,inst_19094,inst_19097);
var inst_19099 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_19098);
var inst_19100 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_19106__$1 = (function (){var statearr_19111 = state_19106;
(statearr_19111[(8)] = inst_19099);

return statearr_19111;
})();
var statearr_19112_19122 = state_19106__$1;
(statearr_19112_19122[(2)] = inst_19100);

(statearr_19112_19122[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (4))){
var inst_19102 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_19106__$1 = state_19106;
var statearr_19113_19123 = state_19106__$1;
(statearr_19113_19123[(2)] = inst_19102);

(statearr_19113_19123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (5))){
var inst_19104 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19106__$1,inst_19104);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____0 = (function (){
var statearr_19114 = [null,null,null,null,null,null,null,null,null];
(statearr_19114[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__);

(statearr_19114[(1)] = (1));

return statearr_19114;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____1 = (function (state_19106){
while(true){
var ret_value__2469__auto__ = (function (){try{while(true){
var result__2470__auto__ = switch__2467__auto__.call(null,state_19106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2470__auto__;
}
break;
}
}catch (e19115){var ex__2471__auto__ = e19115;
var statearr_19116_19124 = state_19106;
(statearr_19116_19124[(2)] = ex__2471__auto__);


if(cljs.core.seq.call(null,(state_19106[(4)]))){
var statearr_19117_19125 = state_19106;
(statearr_19117_19125[(1)] = cljs.core.first.call(null,(state_19106[(4)])));

} else {
throw ex__2471__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2469__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19126 = state_19106;
state_19106 = G__19126;
continue;
} else {
return ret_value__2469__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__ = function(state_19106){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____1.call(this,state_19106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2468__auto__;
})()
})();
var state__2492__auto__ = (function (){var statearr_19118 = f__2491__auto__.call(null);
(statearr_19118[(6)] = c__2490__auto___19119);

return statearr_19118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2492__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});

//# sourceMappingURL=xhttp.js.map
