// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__99032 = arguments.length;
switch (G__99032) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async99033 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async99033 = (function (f,blockable,meta99034){
this.f = f;
this.blockable = blockable;
this.meta99034 = meta99034;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_99035,meta99034__$1){
var self__ = this;
var _99035__$1 = this;
return (new cljs.core.async.t_cljs$core$async99033(self__.f,self__.blockable,meta99034__$1));
});

cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_99035){
var self__ = this;
var _99035__$1 = this;
return self__.meta99034;
});

cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async99033.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async99033.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta99034], null);
});

cljs.core.async.t_cljs$core$async99033.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async99033.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async99033";

cljs.core.async.t_cljs$core$async99033.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async99033");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async99033.
 */
cljs.core.async.__GT_t_cljs$core$async99033 = (function cljs$core$async$__GT_t_cljs$core$async99033(f__$1,blockable__$1,meta99034){
return (new cljs.core.async.t_cljs$core$async99033(f__$1,blockable__$1,meta99034));
});

}

return (new cljs.core.async.t_cljs$core$async99033(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__99039 = arguments.length;
switch (G__99039) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__99042 = arguments.length;
switch (G__99042) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__99045 = arguments.length;
switch (G__99045) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_99047 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_99047) : fn1.call(null,val_99047));
} else {
cljs.core.async.impl.dispatch.run(((function (val_99047,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_99047) : fn1.call(null,val_99047));
});})(val_99047,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__99049 = arguments.length;
switch (G__99049) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5733__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___99051 = n;
var x_99052 = (0);
while(true){
if((x_99052 < n__4607__auto___99051)){
(a[x_99052] = (0));

var G__99053 = (x_99052 + (1));
x_99052 = G__99053;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__99054 = (i + (1));
i = G__99054;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async99055 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async99055 = (function (flag,meta99056){
this.flag = flag;
this.meta99056 = meta99056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_99057,meta99056__$1){
var self__ = this;
var _99057__$1 = this;
return (new cljs.core.async.t_cljs$core$async99055(self__.flag,meta99056__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_99057){
var self__ = this;
var _99057__$1 = this;
return self__.meta99056;
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta99056], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async99055.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async99055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async99055";

cljs.core.async.t_cljs$core$async99055.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async99055");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async99055.
 */
cljs.core.async.__GT_t_cljs$core$async99055 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async99055(flag__$1,meta99056){
return (new cljs.core.async.t_cljs$core$async99055(flag__$1,meta99056));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async99055(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async99058 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async99058 = (function (flag,cb,meta99059){
this.flag = flag;
this.cb = cb;
this.meta99059 = meta99059;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_99060,meta99059__$1){
var self__ = this;
var _99060__$1 = this;
return (new cljs.core.async.t_cljs$core$async99058(self__.flag,self__.cb,meta99059__$1));
});

cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_99060){
var self__ = this;
var _99060__$1 = this;
return self__.meta99059;
});

cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async99058.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async99058.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta99059], null);
});

cljs.core.async.t_cljs$core$async99058.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async99058.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async99058";

cljs.core.async.t_cljs$core$async99058.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async99058");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async99058.
 */
cljs.core.async.__GT_t_cljs$core$async99058 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async99058(flag__$1,cb__$1,meta99059){
return (new cljs.core.async.t_cljs$core$async99058(flag__$1,cb__$1,meta99059));
});

}

return (new cljs.core.async.t_cljs$core$async99058(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__99061_SHARP_){
var G__99063 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__99061_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__99063) : fret.call(null,G__99063));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__99062_SHARP_){
var G__99064 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__99062_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__99064) : fret.call(null,G__99064));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__99065 = (i + (1));
i = G__99065;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5735__auto__ = (function (){var and__4120__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4120__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99071 = arguments.length;
var i__4731__auto___99072 = (0);
while(true){
if((i__4731__auto___99072 < len__4730__auto___99071)){
args__4736__auto__.push((arguments[i__4731__auto___99072]));

var G__99073 = (i__4731__auto___99072 + (1));
i__4731__auto___99072 = G__99073;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__99068){
var map__99069 = p__99068;
var map__99069__$1 = (((((!((map__99069 == null))))?(((((map__99069.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99069.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__99069):map__99069);
var opts = map__99069__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq99066){
var G__99067 = cljs.core.first(seq99066);
var seq99066__$1 = cljs.core.next(seq99066);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__99067,seq99066__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__99075 = arguments.length;
switch (G__99075) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__98972__auto___99121 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___99121){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___99121){
return (function (state_99099){
var state_val_99100 = (state_99099[(1)]);
if((state_val_99100 === (7))){
var inst_99095 = (state_99099[(2)]);
var state_99099__$1 = state_99099;
var statearr_99101_99122 = state_99099__$1;
(statearr_99101_99122[(2)] = inst_99095);

(statearr_99101_99122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (1))){
var state_99099__$1 = state_99099;
var statearr_99102_99123 = state_99099__$1;
(statearr_99102_99123[(2)] = null);

(statearr_99102_99123[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (4))){
var inst_99078 = (state_99099[(7)]);
var inst_99078__$1 = (state_99099[(2)]);
var inst_99079 = (inst_99078__$1 == null);
var state_99099__$1 = (function (){var statearr_99103 = state_99099;
(statearr_99103[(7)] = inst_99078__$1);

return statearr_99103;
})();
if(cljs.core.truth_(inst_99079)){
var statearr_99104_99124 = state_99099__$1;
(statearr_99104_99124[(1)] = (5));

} else {
var statearr_99105_99125 = state_99099__$1;
(statearr_99105_99125[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (13))){
var state_99099__$1 = state_99099;
var statearr_99106_99126 = state_99099__$1;
(statearr_99106_99126[(2)] = null);

(statearr_99106_99126[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (6))){
var inst_99078 = (state_99099[(7)]);
var state_99099__$1 = state_99099;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99099__$1,(11),to,inst_99078);
} else {
if((state_val_99100 === (3))){
var inst_99097 = (state_99099[(2)]);
var state_99099__$1 = state_99099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99099__$1,inst_99097);
} else {
if((state_val_99100 === (12))){
var state_99099__$1 = state_99099;
var statearr_99107_99127 = state_99099__$1;
(statearr_99107_99127[(2)] = null);

(statearr_99107_99127[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (2))){
var state_99099__$1 = state_99099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99099__$1,(4),from);
} else {
if((state_val_99100 === (11))){
var inst_99088 = (state_99099[(2)]);
var state_99099__$1 = state_99099;
if(cljs.core.truth_(inst_99088)){
var statearr_99108_99128 = state_99099__$1;
(statearr_99108_99128[(1)] = (12));

} else {
var statearr_99109_99129 = state_99099__$1;
(statearr_99109_99129[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (9))){
var state_99099__$1 = state_99099;
var statearr_99110_99130 = state_99099__$1;
(statearr_99110_99130[(2)] = null);

(statearr_99110_99130[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (5))){
var state_99099__$1 = state_99099;
if(cljs.core.truth_(close_QMARK_)){
var statearr_99111_99131 = state_99099__$1;
(statearr_99111_99131[(1)] = (8));

} else {
var statearr_99112_99132 = state_99099__$1;
(statearr_99112_99132[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (14))){
var inst_99093 = (state_99099[(2)]);
var state_99099__$1 = state_99099;
var statearr_99113_99133 = state_99099__$1;
(statearr_99113_99133[(2)] = inst_99093);

(statearr_99113_99133[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (10))){
var inst_99085 = (state_99099[(2)]);
var state_99099__$1 = state_99099;
var statearr_99114_99134 = state_99099__$1;
(statearr_99114_99134[(2)] = inst_99085);

(statearr_99114_99134[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99100 === (8))){
var inst_99082 = cljs.core.async.close_BANG_(to);
var state_99099__$1 = state_99099;
var statearr_99115_99135 = state_99099__$1;
(statearr_99115_99135[(2)] = inst_99082);

(statearr_99115_99135[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___99121))
;
return ((function (switch__98865__auto__,c__98972__auto___99121){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_99116 = [null,null,null,null,null,null,null,null];
(statearr_99116[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_99116[(1)] = (1));

return statearr_99116;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_99099){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99099);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99117){if((e99117 instanceof Object)){
var ex__98869__auto__ = e99117;
var statearr_99118_99136 = state_99099;
(statearr_99118_99136[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99099);

return cljs.core.cst$kw$recur;
} else {
throw e99117;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99137 = state_99099;
state_99099 = G__99137;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_99099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_99099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___99121))
})();
var state__98974__auto__ = (function (){var statearr_99119 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99119[(6)] = c__98972__auto___99121);

return statearr_99119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___99121))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__99138){
var vec__99139 = p__99138;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99139,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99139,(1),null);
var job = vec__99139;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__98972__auto___99310 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results){
return (function (state_99146){
var state_val_99147 = (state_99146[(1)]);
if((state_val_99147 === (1))){
var state_99146__$1 = state_99146;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99146__$1,(2),res,v);
} else {
if((state_val_99147 === (2))){
var inst_99143 = (state_99146[(2)]);
var inst_99144 = cljs.core.async.close_BANG_(res);
var state_99146__$1 = (function (){var statearr_99148 = state_99146;
(statearr_99148[(7)] = inst_99143);

return statearr_99148;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_99146__$1,inst_99144);
} else {
return null;
}
}
});})(c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results))
;
return ((function (switch__98865__auto__,c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_99149 = [null,null,null,null,null,null,null,null];
(statearr_99149[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__);

(statearr_99149[(1)] = (1));

return statearr_99149;
});
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1 = (function (state_99146){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99146);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99150){if((e99150 instanceof Object)){
var ex__98869__auto__ = e99150;
var statearr_99151_99311 = state_99146;
(statearr_99151_99311[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99146);

return cljs.core.cst$kw$recur;
} else {
throw e99150;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99312 = state_99146;
state_99146 = G__99312;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = function(state_99146){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1.call(this,state_99146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results))
})();
var state__98974__auto__ = (function (){var statearr_99152 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99152[(6)] = c__98972__auto___99310);

return statearr_99152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___99310,res,vec__99139,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__99153){
var vec__99154 = p__99153;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99154,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99154,(1),null);
var job = vec__99154;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___99313 = n;
var __99314 = (0);
while(true){
if((__99314 < n__4607__auto___99313)){
var G__99157_99315 = type;
var G__99157_99316__$1 = (((G__99157_99315 instanceof cljs.core.Keyword))?G__99157_99315.fqn:null);
switch (G__99157_99316__$1) {
case "compute":
var c__98972__auto___99318 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__99314,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (__99314,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function (state_99170){
var state_val_99171 = (state_99170[(1)]);
if((state_val_99171 === (1))){
var state_99170__$1 = state_99170;
var statearr_99172_99319 = state_99170__$1;
(statearr_99172_99319[(2)] = null);

(statearr_99172_99319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99171 === (2))){
var state_99170__$1 = state_99170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99170__$1,(4),jobs);
} else {
if((state_val_99171 === (3))){
var inst_99168 = (state_99170[(2)]);
var state_99170__$1 = state_99170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99170__$1,inst_99168);
} else {
if((state_val_99171 === (4))){
var inst_99160 = (state_99170[(2)]);
var inst_99161 = process(inst_99160);
var state_99170__$1 = state_99170;
if(cljs.core.truth_(inst_99161)){
var statearr_99173_99320 = state_99170__$1;
(statearr_99173_99320[(1)] = (5));

} else {
var statearr_99174_99321 = state_99170__$1;
(statearr_99174_99321[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99171 === (5))){
var state_99170__$1 = state_99170;
var statearr_99175_99322 = state_99170__$1;
(statearr_99175_99322[(2)] = null);

(statearr_99175_99322[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99171 === (6))){
var state_99170__$1 = state_99170;
var statearr_99176_99323 = state_99170__$1;
(statearr_99176_99323[(2)] = null);

(statearr_99176_99323[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99171 === (7))){
var inst_99166 = (state_99170[(2)]);
var state_99170__$1 = state_99170;
var statearr_99177_99324 = state_99170__$1;
(statearr_99177_99324[(2)] = inst_99166);

(statearr_99177_99324[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__99314,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
;
return ((function (__99314,switch__98865__auto__,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_99178 = [null,null,null,null,null,null,null];
(statearr_99178[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__);

(statearr_99178[(1)] = (1));

return statearr_99178;
});
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1 = (function (state_99170){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99170);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99179){if((e99179 instanceof Object)){
var ex__98869__auto__ = e99179;
var statearr_99180_99325 = state_99170;
(statearr_99180_99325[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99170);

return cljs.core.cst$kw$recur;
} else {
throw e99179;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99326 = state_99170;
state_99170 = G__99326;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = function(state_99170){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1.call(this,state_99170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__;
})()
;})(__99314,switch__98865__auto__,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
})();
var state__98974__auto__ = (function (){var statearr_99181 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99181[(6)] = c__98972__auto___99318);

return statearr_99181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(__99314,c__98972__auto___99318,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
);


break;
case "async":
var c__98972__auto___99327 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__99314,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (__99314,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function (state_99194){
var state_val_99195 = (state_99194[(1)]);
if((state_val_99195 === (1))){
var state_99194__$1 = state_99194;
var statearr_99196_99328 = state_99194__$1;
(statearr_99196_99328[(2)] = null);

(statearr_99196_99328[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99195 === (2))){
var state_99194__$1 = state_99194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99194__$1,(4),jobs);
} else {
if((state_val_99195 === (3))){
var inst_99192 = (state_99194[(2)]);
var state_99194__$1 = state_99194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99194__$1,inst_99192);
} else {
if((state_val_99195 === (4))){
var inst_99184 = (state_99194[(2)]);
var inst_99185 = async(inst_99184);
var state_99194__$1 = state_99194;
if(cljs.core.truth_(inst_99185)){
var statearr_99197_99329 = state_99194__$1;
(statearr_99197_99329[(1)] = (5));

} else {
var statearr_99198_99330 = state_99194__$1;
(statearr_99198_99330[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99195 === (5))){
var state_99194__$1 = state_99194;
var statearr_99199_99331 = state_99194__$1;
(statearr_99199_99331[(2)] = null);

(statearr_99199_99331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99195 === (6))){
var state_99194__$1 = state_99194;
var statearr_99200_99332 = state_99194__$1;
(statearr_99200_99332[(2)] = null);

(statearr_99200_99332[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99195 === (7))){
var inst_99190 = (state_99194[(2)]);
var state_99194__$1 = state_99194;
var statearr_99201_99333 = state_99194__$1;
(statearr_99201_99333[(2)] = inst_99190);

(statearr_99201_99333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__99314,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
;
return ((function (__99314,switch__98865__auto__,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_99202 = [null,null,null,null,null,null,null];
(statearr_99202[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__);

(statearr_99202[(1)] = (1));

return statearr_99202;
});
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1 = (function (state_99194){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99194);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99203){if((e99203 instanceof Object)){
var ex__98869__auto__ = e99203;
var statearr_99204_99334 = state_99194;
(statearr_99204_99334[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99194);

return cljs.core.cst$kw$recur;
} else {
throw e99203;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99335 = state_99194;
state_99194 = G__99335;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = function(state_99194){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1.call(this,state_99194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__;
})()
;})(__99314,switch__98865__auto__,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
})();
var state__98974__auto__ = (function (){var statearr_99205 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99205[(6)] = c__98972__auto___99327);

return statearr_99205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(__99314,c__98972__auto___99327,G__99157_99315,G__99157_99316__$1,n__4607__auto___99313,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__99157_99316__$1)].join('')));

}

var G__99336 = (__99314 + (1));
__99314 = G__99336;
continue;
} else {
}
break;
}

var c__98972__auto___99337 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___99337,jobs,results,process,async){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___99337,jobs,results,process,async){
return (function (state_99227){
var state_val_99228 = (state_99227[(1)]);
if((state_val_99228 === (7))){
var inst_99223 = (state_99227[(2)]);
var state_99227__$1 = state_99227;
var statearr_99229_99338 = state_99227__$1;
(statearr_99229_99338[(2)] = inst_99223);

(statearr_99229_99338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99228 === (1))){
var state_99227__$1 = state_99227;
var statearr_99230_99339 = state_99227__$1;
(statearr_99230_99339[(2)] = null);

(statearr_99230_99339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99228 === (4))){
var inst_99208 = (state_99227[(7)]);
var inst_99208__$1 = (state_99227[(2)]);
var inst_99209 = (inst_99208__$1 == null);
var state_99227__$1 = (function (){var statearr_99231 = state_99227;
(statearr_99231[(7)] = inst_99208__$1);

return statearr_99231;
})();
if(cljs.core.truth_(inst_99209)){
var statearr_99232_99340 = state_99227__$1;
(statearr_99232_99340[(1)] = (5));

} else {
var statearr_99233_99341 = state_99227__$1;
(statearr_99233_99341[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99228 === (6))){
var inst_99213 = (state_99227[(8)]);
var inst_99208 = (state_99227[(7)]);
var inst_99213__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_99214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_99215 = [inst_99208,inst_99213__$1];
var inst_99216 = (new cljs.core.PersistentVector(null,2,(5),inst_99214,inst_99215,null));
var state_99227__$1 = (function (){var statearr_99234 = state_99227;
(statearr_99234[(8)] = inst_99213__$1);

return statearr_99234;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99227__$1,(8),jobs,inst_99216);
} else {
if((state_val_99228 === (3))){
var inst_99225 = (state_99227[(2)]);
var state_99227__$1 = state_99227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99227__$1,inst_99225);
} else {
if((state_val_99228 === (2))){
var state_99227__$1 = state_99227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99227__$1,(4),from);
} else {
if((state_val_99228 === (9))){
var inst_99220 = (state_99227[(2)]);
var state_99227__$1 = (function (){var statearr_99235 = state_99227;
(statearr_99235[(9)] = inst_99220);

return statearr_99235;
})();
var statearr_99236_99342 = state_99227__$1;
(statearr_99236_99342[(2)] = null);

(statearr_99236_99342[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99228 === (5))){
var inst_99211 = cljs.core.async.close_BANG_(jobs);
var state_99227__$1 = state_99227;
var statearr_99237_99343 = state_99227__$1;
(statearr_99237_99343[(2)] = inst_99211);

(statearr_99237_99343[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99228 === (8))){
var inst_99213 = (state_99227[(8)]);
var inst_99218 = (state_99227[(2)]);
var state_99227__$1 = (function (){var statearr_99238 = state_99227;
(statearr_99238[(10)] = inst_99218);

return statearr_99238;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99227__$1,(9),results,inst_99213);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___99337,jobs,results,process,async))
;
return ((function (switch__98865__auto__,c__98972__auto___99337,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_99239 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_99239[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__);

(statearr_99239[(1)] = (1));

return statearr_99239;
});
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1 = (function (state_99227){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99227);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99240){if((e99240 instanceof Object)){
var ex__98869__auto__ = e99240;
var statearr_99241_99344 = state_99227;
(statearr_99241_99344[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99227);

return cljs.core.cst$kw$recur;
} else {
throw e99240;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99345 = state_99227;
state_99227 = G__99345;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = function(state_99227){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1.call(this,state_99227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___99337,jobs,results,process,async))
})();
var state__98974__auto__ = (function (){var statearr_99242 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99242[(6)] = c__98972__auto___99337);

return statearr_99242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___99337,jobs,results,process,async))
);


var c__98972__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto__,jobs,results,process,async){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto__,jobs,results,process,async){
return (function (state_99280){
var state_val_99281 = (state_99280[(1)]);
if((state_val_99281 === (7))){
var inst_99276 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
var statearr_99282_99346 = state_99280__$1;
(statearr_99282_99346[(2)] = inst_99276);

(statearr_99282_99346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (20))){
var state_99280__$1 = state_99280;
var statearr_99283_99347 = state_99280__$1;
(statearr_99283_99347[(2)] = null);

(statearr_99283_99347[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (1))){
var state_99280__$1 = state_99280;
var statearr_99284_99348 = state_99280__$1;
(statearr_99284_99348[(2)] = null);

(statearr_99284_99348[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (4))){
var inst_99245 = (state_99280[(7)]);
var inst_99245__$1 = (state_99280[(2)]);
var inst_99246 = (inst_99245__$1 == null);
var state_99280__$1 = (function (){var statearr_99285 = state_99280;
(statearr_99285[(7)] = inst_99245__$1);

return statearr_99285;
})();
if(cljs.core.truth_(inst_99246)){
var statearr_99286_99349 = state_99280__$1;
(statearr_99286_99349[(1)] = (5));

} else {
var statearr_99287_99350 = state_99280__$1;
(statearr_99287_99350[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (15))){
var inst_99258 = (state_99280[(8)]);
var state_99280__$1 = state_99280;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99280__$1,(18),to,inst_99258);
} else {
if((state_val_99281 === (21))){
var inst_99271 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
var statearr_99288_99351 = state_99280__$1;
(statearr_99288_99351[(2)] = inst_99271);

(statearr_99288_99351[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (13))){
var inst_99273 = (state_99280[(2)]);
var state_99280__$1 = (function (){var statearr_99289 = state_99280;
(statearr_99289[(9)] = inst_99273);

return statearr_99289;
})();
var statearr_99290_99352 = state_99280__$1;
(statearr_99290_99352[(2)] = null);

(statearr_99290_99352[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (6))){
var inst_99245 = (state_99280[(7)]);
var state_99280__$1 = state_99280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99280__$1,(11),inst_99245);
} else {
if((state_val_99281 === (17))){
var inst_99266 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
if(cljs.core.truth_(inst_99266)){
var statearr_99291_99353 = state_99280__$1;
(statearr_99291_99353[(1)] = (19));

} else {
var statearr_99292_99354 = state_99280__$1;
(statearr_99292_99354[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (3))){
var inst_99278 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99280__$1,inst_99278);
} else {
if((state_val_99281 === (12))){
var inst_99255 = (state_99280[(10)]);
var state_99280__$1 = state_99280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99280__$1,(14),inst_99255);
} else {
if((state_val_99281 === (2))){
var state_99280__$1 = state_99280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99280__$1,(4),results);
} else {
if((state_val_99281 === (19))){
var state_99280__$1 = state_99280;
var statearr_99293_99355 = state_99280__$1;
(statearr_99293_99355[(2)] = null);

(statearr_99293_99355[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (11))){
var inst_99255 = (state_99280[(2)]);
var state_99280__$1 = (function (){var statearr_99294 = state_99280;
(statearr_99294[(10)] = inst_99255);

return statearr_99294;
})();
var statearr_99295_99356 = state_99280__$1;
(statearr_99295_99356[(2)] = null);

(statearr_99295_99356[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (9))){
var state_99280__$1 = state_99280;
var statearr_99296_99357 = state_99280__$1;
(statearr_99296_99357[(2)] = null);

(statearr_99296_99357[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (5))){
var state_99280__$1 = state_99280;
if(cljs.core.truth_(close_QMARK_)){
var statearr_99297_99358 = state_99280__$1;
(statearr_99297_99358[(1)] = (8));

} else {
var statearr_99298_99359 = state_99280__$1;
(statearr_99298_99359[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (14))){
var inst_99258 = (state_99280[(8)]);
var inst_99260 = (state_99280[(11)]);
var inst_99258__$1 = (state_99280[(2)]);
var inst_99259 = (inst_99258__$1 == null);
var inst_99260__$1 = cljs.core.not(inst_99259);
var state_99280__$1 = (function (){var statearr_99299 = state_99280;
(statearr_99299[(8)] = inst_99258__$1);

(statearr_99299[(11)] = inst_99260__$1);

return statearr_99299;
})();
if(inst_99260__$1){
var statearr_99300_99360 = state_99280__$1;
(statearr_99300_99360[(1)] = (15));

} else {
var statearr_99301_99361 = state_99280__$1;
(statearr_99301_99361[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (16))){
var inst_99260 = (state_99280[(11)]);
var state_99280__$1 = state_99280;
var statearr_99302_99362 = state_99280__$1;
(statearr_99302_99362[(2)] = inst_99260);

(statearr_99302_99362[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (10))){
var inst_99252 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
var statearr_99303_99363 = state_99280__$1;
(statearr_99303_99363[(2)] = inst_99252);

(statearr_99303_99363[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (18))){
var inst_99263 = (state_99280[(2)]);
var state_99280__$1 = state_99280;
var statearr_99304_99364 = state_99280__$1;
(statearr_99304_99364[(2)] = inst_99263);

(statearr_99304_99364[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99281 === (8))){
var inst_99249 = cljs.core.async.close_BANG_(to);
var state_99280__$1 = state_99280;
var statearr_99305_99365 = state_99280__$1;
(statearr_99305_99365[(2)] = inst_99249);

(statearr_99305_99365[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto__,jobs,results,process,async))
;
return ((function (switch__98865__auto__,c__98972__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_99306 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99306[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__);

(statearr_99306[(1)] = (1));

return statearr_99306;
});
var cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1 = (function (state_99280){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99280);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99307){if((e99307 instanceof Object)){
var ex__98869__auto__ = e99307;
var statearr_99308_99366 = state_99280;
(statearr_99308_99366[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99280);

return cljs.core.cst$kw$recur;
} else {
throw e99307;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99367 = state_99280;
state_99280 = G__99367;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__ = function(state_99280){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1.call(this,state_99280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto__,jobs,results,process,async))
})();
var state__98974__auto__ = (function (){var statearr_99309 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99309[(6)] = c__98972__auto__);

return statearr_99309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto__,jobs,results,process,async))
);

return c__98972__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__99369 = arguments.length;
switch (G__99369) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__99372 = arguments.length;
switch (G__99372) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__99375 = arguments.length;
switch (G__99375) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__98972__auto___99424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___99424,tc,fc){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___99424,tc,fc){
return (function (state_99401){
var state_val_99402 = (state_99401[(1)]);
if((state_val_99402 === (7))){
var inst_99397 = (state_99401[(2)]);
var state_99401__$1 = state_99401;
var statearr_99403_99425 = state_99401__$1;
(statearr_99403_99425[(2)] = inst_99397);

(statearr_99403_99425[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (1))){
var state_99401__$1 = state_99401;
var statearr_99404_99426 = state_99401__$1;
(statearr_99404_99426[(2)] = null);

(statearr_99404_99426[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (4))){
var inst_99378 = (state_99401[(7)]);
var inst_99378__$1 = (state_99401[(2)]);
var inst_99379 = (inst_99378__$1 == null);
var state_99401__$1 = (function (){var statearr_99405 = state_99401;
(statearr_99405[(7)] = inst_99378__$1);

return statearr_99405;
})();
if(cljs.core.truth_(inst_99379)){
var statearr_99406_99427 = state_99401__$1;
(statearr_99406_99427[(1)] = (5));

} else {
var statearr_99407_99428 = state_99401__$1;
(statearr_99407_99428[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (13))){
var state_99401__$1 = state_99401;
var statearr_99408_99429 = state_99401__$1;
(statearr_99408_99429[(2)] = null);

(statearr_99408_99429[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (6))){
var inst_99378 = (state_99401[(7)]);
var inst_99384 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_99378) : p.call(null,inst_99378));
var state_99401__$1 = state_99401;
if(cljs.core.truth_(inst_99384)){
var statearr_99409_99430 = state_99401__$1;
(statearr_99409_99430[(1)] = (9));

} else {
var statearr_99410_99431 = state_99401__$1;
(statearr_99410_99431[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (3))){
var inst_99399 = (state_99401[(2)]);
var state_99401__$1 = state_99401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99401__$1,inst_99399);
} else {
if((state_val_99402 === (12))){
var state_99401__$1 = state_99401;
var statearr_99411_99432 = state_99401__$1;
(statearr_99411_99432[(2)] = null);

(statearr_99411_99432[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (2))){
var state_99401__$1 = state_99401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99401__$1,(4),ch);
} else {
if((state_val_99402 === (11))){
var inst_99378 = (state_99401[(7)]);
var inst_99388 = (state_99401[(2)]);
var state_99401__$1 = state_99401;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99401__$1,(8),inst_99388,inst_99378);
} else {
if((state_val_99402 === (9))){
var state_99401__$1 = state_99401;
var statearr_99412_99433 = state_99401__$1;
(statearr_99412_99433[(2)] = tc);

(statearr_99412_99433[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (5))){
var inst_99381 = cljs.core.async.close_BANG_(tc);
var inst_99382 = cljs.core.async.close_BANG_(fc);
var state_99401__$1 = (function (){var statearr_99413 = state_99401;
(statearr_99413[(8)] = inst_99381);

return statearr_99413;
})();
var statearr_99414_99434 = state_99401__$1;
(statearr_99414_99434[(2)] = inst_99382);

(statearr_99414_99434[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (14))){
var inst_99395 = (state_99401[(2)]);
var state_99401__$1 = state_99401;
var statearr_99415_99435 = state_99401__$1;
(statearr_99415_99435[(2)] = inst_99395);

(statearr_99415_99435[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (10))){
var state_99401__$1 = state_99401;
var statearr_99416_99436 = state_99401__$1;
(statearr_99416_99436[(2)] = fc);

(statearr_99416_99436[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99402 === (8))){
var inst_99390 = (state_99401[(2)]);
var state_99401__$1 = state_99401;
if(cljs.core.truth_(inst_99390)){
var statearr_99417_99437 = state_99401__$1;
(statearr_99417_99437[(1)] = (12));

} else {
var statearr_99418_99438 = state_99401__$1;
(statearr_99418_99438[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___99424,tc,fc))
;
return ((function (switch__98865__auto__,c__98972__auto___99424,tc,fc){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_99419 = [null,null,null,null,null,null,null,null,null];
(statearr_99419[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_99419[(1)] = (1));

return statearr_99419;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_99401){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99401);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99420){if((e99420 instanceof Object)){
var ex__98869__auto__ = e99420;
var statearr_99421_99439 = state_99401;
(statearr_99421_99439[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99401);

return cljs.core.cst$kw$recur;
} else {
throw e99420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99440 = state_99401;
state_99401 = G__99440;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_99401){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_99401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___99424,tc,fc))
})();
var state__98974__auto__ = (function (){var statearr_99422 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99422[(6)] = c__98972__auto___99424);

return statearr_99422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___99424,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__98972__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto__){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto__){
return (function (state_99461){
var state_val_99462 = (state_99461[(1)]);
if((state_val_99462 === (7))){
var inst_99457 = (state_99461[(2)]);
var state_99461__$1 = state_99461;
var statearr_99463_99481 = state_99461__$1;
(statearr_99463_99481[(2)] = inst_99457);

(statearr_99463_99481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (1))){
var inst_99441 = init;
var state_99461__$1 = (function (){var statearr_99464 = state_99461;
(statearr_99464[(7)] = inst_99441);

return statearr_99464;
})();
var statearr_99465_99482 = state_99461__$1;
(statearr_99465_99482[(2)] = null);

(statearr_99465_99482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (4))){
var inst_99444 = (state_99461[(8)]);
var inst_99444__$1 = (state_99461[(2)]);
var inst_99445 = (inst_99444__$1 == null);
var state_99461__$1 = (function (){var statearr_99466 = state_99461;
(statearr_99466[(8)] = inst_99444__$1);

return statearr_99466;
})();
if(cljs.core.truth_(inst_99445)){
var statearr_99467_99483 = state_99461__$1;
(statearr_99467_99483[(1)] = (5));

} else {
var statearr_99468_99484 = state_99461__$1;
(statearr_99468_99484[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (6))){
var inst_99444 = (state_99461[(8)]);
var inst_99441 = (state_99461[(7)]);
var inst_99448 = (state_99461[(9)]);
var inst_99448__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_99441,inst_99444) : f.call(null,inst_99441,inst_99444));
var inst_99449 = cljs.core.reduced_QMARK_(inst_99448__$1);
var state_99461__$1 = (function (){var statearr_99469 = state_99461;
(statearr_99469[(9)] = inst_99448__$1);

return statearr_99469;
})();
if(inst_99449){
var statearr_99470_99485 = state_99461__$1;
(statearr_99470_99485[(1)] = (8));

} else {
var statearr_99471_99486 = state_99461__$1;
(statearr_99471_99486[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (3))){
var inst_99459 = (state_99461[(2)]);
var state_99461__$1 = state_99461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99461__$1,inst_99459);
} else {
if((state_val_99462 === (2))){
var state_99461__$1 = state_99461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99461__$1,(4),ch);
} else {
if((state_val_99462 === (9))){
var inst_99448 = (state_99461[(9)]);
var inst_99441 = inst_99448;
var state_99461__$1 = (function (){var statearr_99472 = state_99461;
(statearr_99472[(7)] = inst_99441);

return statearr_99472;
})();
var statearr_99473_99487 = state_99461__$1;
(statearr_99473_99487[(2)] = null);

(statearr_99473_99487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (5))){
var inst_99441 = (state_99461[(7)]);
var state_99461__$1 = state_99461;
var statearr_99474_99488 = state_99461__$1;
(statearr_99474_99488[(2)] = inst_99441);

(statearr_99474_99488[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (10))){
var inst_99455 = (state_99461[(2)]);
var state_99461__$1 = state_99461;
var statearr_99475_99489 = state_99461__$1;
(statearr_99475_99489[(2)] = inst_99455);

(statearr_99475_99489[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99462 === (8))){
var inst_99448 = (state_99461[(9)]);
var inst_99451 = cljs.core.deref(inst_99448);
var state_99461__$1 = state_99461;
var statearr_99476_99490 = state_99461__$1;
(statearr_99476_99490[(2)] = inst_99451);

(statearr_99476_99490[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto__))
;
return ((function (switch__98865__auto__,c__98972__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__98866__auto__ = null;
var cljs$core$async$reduce_$_state_machine__98866__auto____0 = (function (){
var statearr_99477 = [null,null,null,null,null,null,null,null,null,null];
(statearr_99477[(0)] = cljs$core$async$reduce_$_state_machine__98866__auto__);

(statearr_99477[(1)] = (1));

return statearr_99477;
});
var cljs$core$async$reduce_$_state_machine__98866__auto____1 = (function (state_99461){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99461);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99478){if((e99478 instanceof Object)){
var ex__98869__auto__ = e99478;
var statearr_99479_99491 = state_99461;
(statearr_99479_99491[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99461);

return cljs.core.cst$kw$recur;
} else {
throw e99478;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99492 = state_99461;
state_99461 = G__99492;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__98866__auto__ = function(state_99461){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__98866__auto____1.call(this,state_99461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__98866__auto____0;
cljs$core$async$reduce_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__98866__auto____1;
return cljs$core$async$reduce_$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto__))
})();
var state__98974__auto__ = (function (){var statearr_99480 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99480[(6)] = c__98972__auto__);

return statearr_99480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto__))
);

return c__98972__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__98972__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto__,f__$1){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto__,f__$1){
return (function (state_99498){
var state_val_99499 = (state_99498[(1)]);
if((state_val_99499 === (1))){
var inst_99493 = cljs.core.async.reduce(f__$1,init,ch);
var state_99498__$1 = state_99498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99498__$1,(2),inst_99493);
} else {
if((state_val_99499 === (2))){
var inst_99495 = (state_99498[(2)]);
var inst_99496 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_99495) : f__$1.call(null,inst_99495));
var state_99498__$1 = state_99498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99498__$1,inst_99496);
} else {
return null;
}
}
});})(c__98972__auto__,f__$1))
;
return ((function (switch__98865__auto__,c__98972__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__98866__auto__ = null;
var cljs$core$async$transduce_$_state_machine__98866__auto____0 = (function (){
var statearr_99500 = [null,null,null,null,null,null,null];
(statearr_99500[(0)] = cljs$core$async$transduce_$_state_machine__98866__auto__);

(statearr_99500[(1)] = (1));

return statearr_99500;
});
var cljs$core$async$transduce_$_state_machine__98866__auto____1 = (function (state_99498){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99498);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99501){if((e99501 instanceof Object)){
var ex__98869__auto__ = e99501;
var statearr_99502_99504 = state_99498;
(statearr_99502_99504[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99498);

return cljs.core.cst$kw$recur;
} else {
throw e99501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99505 = state_99498;
state_99498 = G__99505;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__98866__auto__ = function(state_99498){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__98866__auto____1.call(this,state_99498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__98866__auto____0;
cljs$core$async$transduce_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__98866__auto____1;
return cljs$core$async$transduce_$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto__,f__$1))
})();
var state__98974__auto__ = (function (){var statearr_99503 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99503[(6)] = c__98972__auto__);

return statearr_99503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto__,f__$1))
);

return c__98972__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__99507 = arguments.length;
switch (G__99507) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__98972__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto__){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto__){
return (function (state_99532){
var state_val_99533 = (state_99532[(1)]);
if((state_val_99533 === (7))){
var inst_99514 = (state_99532[(2)]);
var state_99532__$1 = state_99532;
var statearr_99534_99555 = state_99532__$1;
(statearr_99534_99555[(2)] = inst_99514);

(statearr_99534_99555[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (1))){
var inst_99508 = cljs.core.seq(coll);
var inst_99509 = inst_99508;
var state_99532__$1 = (function (){var statearr_99535 = state_99532;
(statearr_99535[(7)] = inst_99509);

return statearr_99535;
})();
var statearr_99536_99556 = state_99532__$1;
(statearr_99536_99556[(2)] = null);

(statearr_99536_99556[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (4))){
var inst_99509 = (state_99532[(7)]);
var inst_99512 = cljs.core.first(inst_99509);
var state_99532__$1 = state_99532;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99532__$1,(7),ch,inst_99512);
} else {
if((state_val_99533 === (13))){
var inst_99526 = (state_99532[(2)]);
var state_99532__$1 = state_99532;
var statearr_99537_99557 = state_99532__$1;
(statearr_99537_99557[(2)] = inst_99526);

(statearr_99537_99557[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (6))){
var inst_99517 = (state_99532[(2)]);
var state_99532__$1 = state_99532;
if(cljs.core.truth_(inst_99517)){
var statearr_99538_99558 = state_99532__$1;
(statearr_99538_99558[(1)] = (8));

} else {
var statearr_99539_99559 = state_99532__$1;
(statearr_99539_99559[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (3))){
var inst_99530 = (state_99532[(2)]);
var state_99532__$1 = state_99532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99532__$1,inst_99530);
} else {
if((state_val_99533 === (12))){
var state_99532__$1 = state_99532;
var statearr_99540_99560 = state_99532__$1;
(statearr_99540_99560[(2)] = null);

(statearr_99540_99560[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (2))){
var inst_99509 = (state_99532[(7)]);
var state_99532__$1 = state_99532;
if(cljs.core.truth_(inst_99509)){
var statearr_99541_99561 = state_99532__$1;
(statearr_99541_99561[(1)] = (4));

} else {
var statearr_99542_99562 = state_99532__$1;
(statearr_99542_99562[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (11))){
var inst_99523 = cljs.core.async.close_BANG_(ch);
var state_99532__$1 = state_99532;
var statearr_99543_99563 = state_99532__$1;
(statearr_99543_99563[(2)] = inst_99523);

(statearr_99543_99563[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (9))){
var state_99532__$1 = state_99532;
if(cljs.core.truth_(close_QMARK_)){
var statearr_99544_99564 = state_99532__$1;
(statearr_99544_99564[(1)] = (11));

} else {
var statearr_99545_99565 = state_99532__$1;
(statearr_99545_99565[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (5))){
var inst_99509 = (state_99532[(7)]);
var state_99532__$1 = state_99532;
var statearr_99546_99566 = state_99532__$1;
(statearr_99546_99566[(2)] = inst_99509);

(statearr_99546_99566[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (10))){
var inst_99528 = (state_99532[(2)]);
var state_99532__$1 = state_99532;
var statearr_99547_99567 = state_99532__$1;
(statearr_99547_99567[(2)] = inst_99528);

(statearr_99547_99567[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99533 === (8))){
var inst_99509 = (state_99532[(7)]);
var inst_99519 = cljs.core.next(inst_99509);
var inst_99509__$1 = inst_99519;
var state_99532__$1 = (function (){var statearr_99548 = state_99532;
(statearr_99548[(7)] = inst_99509__$1);

return statearr_99548;
})();
var statearr_99549_99568 = state_99532__$1;
(statearr_99549_99568[(2)] = null);

(statearr_99549_99568[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto__))
;
return ((function (switch__98865__auto__,c__98972__auto__){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_99550 = [null,null,null,null,null,null,null,null];
(statearr_99550[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_99550[(1)] = (1));

return statearr_99550;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_99532){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99532);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99551){if((e99551 instanceof Object)){
var ex__98869__auto__ = e99551;
var statearr_99552_99569 = state_99532;
(statearr_99552_99569[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99532);

return cljs.core.cst$kw$recur;
} else {
throw e99551;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99570 = state_99532;
state_99532 = G__99570;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_99532){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_99532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto__))
})();
var state__98974__auto__ = (function (){var statearr_99553 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99553[(6)] = c__98972__auto__);

return statearr_99553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto__))
);

return c__98972__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4434__auto__.call(null,_));
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4431__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4434__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4431__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async99571 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async99571 = (function (ch,cs,meta99572){
this.ch = ch;
this.cs = cs;
this.meta99572 = meta99572;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_99573,meta99572__$1){
var self__ = this;
var _99573__$1 = this;
return (new cljs.core.async.t_cljs$core$async99571(self__.ch,self__.cs,meta99572__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_99573){
var self__ = this;
var _99573__$1 = this;
return self__.meta99572;
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta99572], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async99571.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async99571.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async99571";

cljs.core.async.t_cljs$core$async99571.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async99571");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async99571.
 */
cljs.core.async.__GT_t_cljs$core$async99571 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async99571(ch__$1,cs__$1,meta99572){
return (new cljs.core.async.t_cljs$core$async99571(ch__$1,cs__$1,meta99572));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async99571(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__98972__auto___99793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___99793,cs,m,dchan,dctr,done){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___99793,cs,m,dchan,dctr,done){
return (function (state_99708){
var state_val_99709 = (state_99708[(1)]);
if((state_val_99709 === (7))){
var inst_99704 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99710_99794 = state_99708__$1;
(statearr_99710_99794[(2)] = inst_99704);

(statearr_99710_99794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (20))){
var inst_99607 = (state_99708[(7)]);
var inst_99619 = cljs.core.first(inst_99607);
var inst_99620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99619,(0),null);
var inst_99621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99619,(1),null);
var state_99708__$1 = (function (){var statearr_99711 = state_99708;
(statearr_99711[(8)] = inst_99620);

return statearr_99711;
})();
if(cljs.core.truth_(inst_99621)){
var statearr_99712_99795 = state_99708__$1;
(statearr_99712_99795[(1)] = (22));

} else {
var statearr_99713_99796 = state_99708__$1;
(statearr_99713_99796[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (27))){
var inst_99576 = (state_99708[(9)]);
var inst_99649 = (state_99708[(10)]);
var inst_99656 = (state_99708[(11)]);
var inst_99651 = (state_99708[(12)]);
var inst_99656__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_99649,inst_99651);
var inst_99657 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_99656__$1,inst_99576,done);
var state_99708__$1 = (function (){var statearr_99714 = state_99708;
(statearr_99714[(11)] = inst_99656__$1);

return statearr_99714;
})();
if(cljs.core.truth_(inst_99657)){
var statearr_99715_99797 = state_99708__$1;
(statearr_99715_99797[(1)] = (30));

} else {
var statearr_99716_99798 = state_99708__$1;
(statearr_99716_99798[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (1))){
var state_99708__$1 = state_99708;
var statearr_99717_99799 = state_99708__$1;
(statearr_99717_99799[(2)] = null);

(statearr_99717_99799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (24))){
var inst_99607 = (state_99708[(7)]);
var inst_99626 = (state_99708[(2)]);
var inst_99627 = cljs.core.next(inst_99607);
var inst_99585 = inst_99627;
var inst_99586 = null;
var inst_99587 = (0);
var inst_99588 = (0);
var state_99708__$1 = (function (){var statearr_99718 = state_99708;
(statearr_99718[(13)] = inst_99587);

(statearr_99718[(14)] = inst_99588);

(statearr_99718[(15)] = inst_99626);

(statearr_99718[(16)] = inst_99586);

(statearr_99718[(17)] = inst_99585);

return statearr_99718;
})();
var statearr_99719_99800 = state_99708__$1;
(statearr_99719_99800[(2)] = null);

(statearr_99719_99800[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (39))){
var state_99708__$1 = state_99708;
var statearr_99723_99801 = state_99708__$1;
(statearr_99723_99801[(2)] = null);

(statearr_99723_99801[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (4))){
var inst_99576 = (state_99708[(9)]);
var inst_99576__$1 = (state_99708[(2)]);
var inst_99577 = (inst_99576__$1 == null);
var state_99708__$1 = (function (){var statearr_99724 = state_99708;
(statearr_99724[(9)] = inst_99576__$1);

return statearr_99724;
})();
if(cljs.core.truth_(inst_99577)){
var statearr_99725_99802 = state_99708__$1;
(statearr_99725_99802[(1)] = (5));

} else {
var statearr_99726_99803 = state_99708__$1;
(statearr_99726_99803[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (15))){
var inst_99587 = (state_99708[(13)]);
var inst_99588 = (state_99708[(14)]);
var inst_99586 = (state_99708[(16)]);
var inst_99585 = (state_99708[(17)]);
var inst_99603 = (state_99708[(2)]);
var inst_99604 = (inst_99588 + (1));
var tmp99720 = inst_99587;
var tmp99721 = inst_99586;
var tmp99722 = inst_99585;
var inst_99585__$1 = tmp99722;
var inst_99586__$1 = tmp99721;
var inst_99587__$1 = tmp99720;
var inst_99588__$1 = inst_99604;
var state_99708__$1 = (function (){var statearr_99727 = state_99708;
(statearr_99727[(13)] = inst_99587__$1);

(statearr_99727[(14)] = inst_99588__$1);

(statearr_99727[(16)] = inst_99586__$1);

(statearr_99727[(18)] = inst_99603);

(statearr_99727[(17)] = inst_99585__$1);

return statearr_99727;
})();
var statearr_99728_99804 = state_99708__$1;
(statearr_99728_99804[(2)] = null);

(statearr_99728_99804[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (21))){
var inst_99630 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99732_99805 = state_99708__$1;
(statearr_99732_99805[(2)] = inst_99630);

(statearr_99732_99805[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (31))){
var inst_99656 = (state_99708[(11)]);
var inst_99660 = done(null);
var inst_99661 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_99656);
var state_99708__$1 = (function (){var statearr_99733 = state_99708;
(statearr_99733[(19)] = inst_99660);

return statearr_99733;
})();
var statearr_99734_99806 = state_99708__$1;
(statearr_99734_99806[(2)] = inst_99661);

(statearr_99734_99806[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (32))){
var inst_99650 = (state_99708[(20)]);
var inst_99649 = (state_99708[(10)]);
var inst_99651 = (state_99708[(12)]);
var inst_99648 = (state_99708[(21)]);
var inst_99663 = (state_99708[(2)]);
var inst_99664 = (inst_99651 + (1));
var tmp99729 = inst_99650;
var tmp99730 = inst_99649;
var tmp99731 = inst_99648;
var inst_99648__$1 = tmp99731;
var inst_99649__$1 = tmp99730;
var inst_99650__$1 = tmp99729;
var inst_99651__$1 = inst_99664;
var state_99708__$1 = (function (){var statearr_99735 = state_99708;
(statearr_99735[(20)] = inst_99650__$1);

(statearr_99735[(10)] = inst_99649__$1);

(statearr_99735[(22)] = inst_99663);

(statearr_99735[(12)] = inst_99651__$1);

(statearr_99735[(21)] = inst_99648__$1);

return statearr_99735;
})();
var statearr_99736_99807 = state_99708__$1;
(statearr_99736_99807[(2)] = null);

(statearr_99736_99807[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (40))){
var inst_99676 = (state_99708[(23)]);
var inst_99680 = done(null);
var inst_99681 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_99676);
var state_99708__$1 = (function (){var statearr_99737 = state_99708;
(statearr_99737[(24)] = inst_99680);

return statearr_99737;
})();
var statearr_99738_99808 = state_99708__$1;
(statearr_99738_99808[(2)] = inst_99681);

(statearr_99738_99808[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (33))){
var inst_99667 = (state_99708[(25)]);
var inst_99669 = cljs.core.chunked_seq_QMARK_(inst_99667);
var state_99708__$1 = state_99708;
if(inst_99669){
var statearr_99739_99809 = state_99708__$1;
(statearr_99739_99809[(1)] = (36));

} else {
var statearr_99740_99810 = state_99708__$1;
(statearr_99740_99810[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (13))){
var inst_99597 = (state_99708[(26)]);
var inst_99600 = cljs.core.async.close_BANG_(inst_99597);
var state_99708__$1 = state_99708;
var statearr_99741_99811 = state_99708__$1;
(statearr_99741_99811[(2)] = inst_99600);

(statearr_99741_99811[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (22))){
var inst_99620 = (state_99708[(8)]);
var inst_99623 = cljs.core.async.close_BANG_(inst_99620);
var state_99708__$1 = state_99708;
var statearr_99742_99812 = state_99708__$1;
(statearr_99742_99812[(2)] = inst_99623);

(statearr_99742_99812[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (36))){
var inst_99667 = (state_99708[(25)]);
var inst_99671 = cljs.core.chunk_first(inst_99667);
var inst_99672 = cljs.core.chunk_rest(inst_99667);
var inst_99673 = cljs.core.count(inst_99671);
var inst_99648 = inst_99672;
var inst_99649 = inst_99671;
var inst_99650 = inst_99673;
var inst_99651 = (0);
var state_99708__$1 = (function (){var statearr_99743 = state_99708;
(statearr_99743[(20)] = inst_99650);

(statearr_99743[(10)] = inst_99649);

(statearr_99743[(12)] = inst_99651);

(statearr_99743[(21)] = inst_99648);

return statearr_99743;
})();
var statearr_99744_99813 = state_99708__$1;
(statearr_99744_99813[(2)] = null);

(statearr_99744_99813[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (41))){
var inst_99667 = (state_99708[(25)]);
var inst_99683 = (state_99708[(2)]);
var inst_99684 = cljs.core.next(inst_99667);
var inst_99648 = inst_99684;
var inst_99649 = null;
var inst_99650 = (0);
var inst_99651 = (0);
var state_99708__$1 = (function (){var statearr_99745 = state_99708;
(statearr_99745[(20)] = inst_99650);

(statearr_99745[(10)] = inst_99649);

(statearr_99745[(27)] = inst_99683);

(statearr_99745[(12)] = inst_99651);

(statearr_99745[(21)] = inst_99648);

return statearr_99745;
})();
var statearr_99746_99814 = state_99708__$1;
(statearr_99746_99814[(2)] = null);

(statearr_99746_99814[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (43))){
var state_99708__$1 = state_99708;
var statearr_99747_99815 = state_99708__$1;
(statearr_99747_99815[(2)] = null);

(statearr_99747_99815[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (29))){
var inst_99692 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99748_99816 = state_99708__$1;
(statearr_99748_99816[(2)] = inst_99692);

(statearr_99748_99816[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (44))){
var inst_99701 = (state_99708[(2)]);
var state_99708__$1 = (function (){var statearr_99749 = state_99708;
(statearr_99749[(28)] = inst_99701);

return statearr_99749;
})();
var statearr_99750_99817 = state_99708__$1;
(statearr_99750_99817[(2)] = null);

(statearr_99750_99817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (6))){
var inst_99640 = (state_99708[(29)]);
var inst_99639 = cljs.core.deref(cs);
var inst_99640__$1 = cljs.core.keys(inst_99639);
var inst_99641 = cljs.core.count(inst_99640__$1);
var inst_99642 = cljs.core.reset_BANG_(dctr,inst_99641);
var inst_99647 = cljs.core.seq(inst_99640__$1);
var inst_99648 = inst_99647;
var inst_99649 = null;
var inst_99650 = (0);
var inst_99651 = (0);
var state_99708__$1 = (function (){var statearr_99751 = state_99708;
(statearr_99751[(20)] = inst_99650);

(statearr_99751[(10)] = inst_99649);

(statearr_99751[(12)] = inst_99651);

(statearr_99751[(29)] = inst_99640__$1);

(statearr_99751[(30)] = inst_99642);

(statearr_99751[(21)] = inst_99648);

return statearr_99751;
})();
var statearr_99752_99818 = state_99708__$1;
(statearr_99752_99818[(2)] = null);

(statearr_99752_99818[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (28))){
var inst_99667 = (state_99708[(25)]);
var inst_99648 = (state_99708[(21)]);
var inst_99667__$1 = cljs.core.seq(inst_99648);
var state_99708__$1 = (function (){var statearr_99753 = state_99708;
(statearr_99753[(25)] = inst_99667__$1);

return statearr_99753;
})();
if(inst_99667__$1){
var statearr_99754_99819 = state_99708__$1;
(statearr_99754_99819[(1)] = (33));

} else {
var statearr_99755_99820 = state_99708__$1;
(statearr_99755_99820[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (25))){
var inst_99650 = (state_99708[(20)]);
var inst_99651 = (state_99708[(12)]);
var inst_99653 = (inst_99651 < inst_99650);
var inst_99654 = inst_99653;
var state_99708__$1 = state_99708;
if(cljs.core.truth_(inst_99654)){
var statearr_99756_99821 = state_99708__$1;
(statearr_99756_99821[(1)] = (27));

} else {
var statearr_99757_99822 = state_99708__$1;
(statearr_99757_99822[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (34))){
var state_99708__$1 = state_99708;
var statearr_99758_99823 = state_99708__$1;
(statearr_99758_99823[(2)] = null);

(statearr_99758_99823[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (17))){
var state_99708__$1 = state_99708;
var statearr_99759_99824 = state_99708__$1;
(statearr_99759_99824[(2)] = null);

(statearr_99759_99824[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (3))){
var inst_99706 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99708__$1,inst_99706);
} else {
if((state_val_99709 === (12))){
var inst_99635 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99760_99825 = state_99708__$1;
(statearr_99760_99825[(2)] = inst_99635);

(statearr_99760_99825[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (2))){
var state_99708__$1 = state_99708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99708__$1,(4),ch);
} else {
if((state_val_99709 === (23))){
var state_99708__$1 = state_99708;
var statearr_99761_99826 = state_99708__$1;
(statearr_99761_99826[(2)] = null);

(statearr_99761_99826[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (35))){
var inst_99690 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99762_99827 = state_99708__$1;
(statearr_99762_99827[(2)] = inst_99690);

(statearr_99762_99827[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (19))){
var inst_99607 = (state_99708[(7)]);
var inst_99611 = cljs.core.chunk_first(inst_99607);
var inst_99612 = cljs.core.chunk_rest(inst_99607);
var inst_99613 = cljs.core.count(inst_99611);
var inst_99585 = inst_99612;
var inst_99586 = inst_99611;
var inst_99587 = inst_99613;
var inst_99588 = (0);
var state_99708__$1 = (function (){var statearr_99763 = state_99708;
(statearr_99763[(13)] = inst_99587);

(statearr_99763[(14)] = inst_99588);

(statearr_99763[(16)] = inst_99586);

(statearr_99763[(17)] = inst_99585);

return statearr_99763;
})();
var statearr_99764_99828 = state_99708__$1;
(statearr_99764_99828[(2)] = null);

(statearr_99764_99828[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (11))){
var inst_99607 = (state_99708[(7)]);
var inst_99585 = (state_99708[(17)]);
var inst_99607__$1 = cljs.core.seq(inst_99585);
var state_99708__$1 = (function (){var statearr_99765 = state_99708;
(statearr_99765[(7)] = inst_99607__$1);

return statearr_99765;
})();
if(inst_99607__$1){
var statearr_99766_99829 = state_99708__$1;
(statearr_99766_99829[(1)] = (16));

} else {
var statearr_99767_99830 = state_99708__$1;
(statearr_99767_99830[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (9))){
var inst_99637 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99768_99831 = state_99708__$1;
(statearr_99768_99831[(2)] = inst_99637);

(statearr_99768_99831[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (5))){
var inst_99583 = cljs.core.deref(cs);
var inst_99584 = cljs.core.seq(inst_99583);
var inst_99585 = inst_99584;
var inst_99586 = null;
var inst_99587 = (0);
var inst_99588 = (0);
var state_99708__$1 = (function (){var statearr_99769 = state_99708;
(statearr_99769[(13)] = inst_99587);

(statearr_99769[(14)] = inst_99588);

(statearr_99769[(16)] = inst_99586);

(statearr_99769[(17)] = inst_99585);

return statearr_99769;
})();
var statearr_99770_99832 = state_99708__$1;
(statearr_99770_99832[(2)] = null);

(statearr_99770_99832[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (14))){
var state_99708__$1 = state_99708;
var statearr_99771_99833 = state_99708__$1;
(statearr_99771_99833[(2)] = null);

(statearr_99771_99833[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (45))){
var inst_99698 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99772_99834 = state_99708__$1;
(statearr_99772_99834[(2)] = inst_99698);

(statearr_99772_99834[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (26))){
var inst_99640 = (state_99708[(29)]);
var inst_99694 = (state_99708[(2)]);
var inst_99695 = cljs.core.seq(inst_99640);
var state_99708__$1 = (function (){var statearr_99773 = state_99708;
(statearr_99773[(31)] = inst_99694);

return statearr_99773;
})();
if(inst_99695){
var statearr_99774_99835 = state_99708__$1;
(statearr_99774_99835[(1)] = (42));

} else {
var statearr_99775_99836 = state_99708__$1;
(statearr_99775_99836[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (16))){
var inst_99607 = (state_99708[(7)]);
var inst_99609 = cljs.core.chunked_seq_QMARK_(inst_99607);
var state_99708__$1 = state_99708;
if(inst_99609){
var statearr_99776_99837 = state_99708__$1;
(statearr_99776_99837[(1)] = (19));

} else {
var statearr_99777_99838 = state_99708__$1;
(statearr_99777_99838[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (38))){
var inst_99687 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99778_99839 = state_99708__$1;
(statearr_99778_99839[(2)] = inst_99687);

(statearr_99778_99839[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (30))){
var state_99708__$1 = state_99708;
var statearr_99779_99840 = state_99708__$1;
(statearr_99779_99840[(2)] = null);

(statearr_99779_99840[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (10))){
var inst_99588 = (state_99708[(14)]);
var inst_99586 = (state_99708[(16)]);
var inst_99596 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_99586,inst_99588);
var inst_99597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99596,(0),null);
var inst_99598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99596,(1),null);
var state_99708__$1 = (function (){var statearr_99780 = state_99708;
(statearr_99780[(26)] = inst_99597);

return statearr_99780;
})();
if(cljs.core.truth_(inst_99598)){
var statearr_99781_99841 = state_99708__$1;
(statearr_99781_99841[(1)] = (13));

} else {
var statearr_99782_99842 = state_99708__$1;
(statearr_99782_99842[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (18))){
var inst_99633 = (state_99708[(2)]);
var state_99708__$1 = state_99708;
var statearr_99783_99843 = state_99708__$1;
(statearr_99783_99843[(2)] = inst_99633);

(statearr_99783_99843[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (42))){
var state_99708__$1 = state_99708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99708__$1,(45),dchan);
} else {
if((state_val_99709 === (37))){
var inst_99576 = (state_99708[(9)]);
var inst_99676 = (state_99708[(23)]);
var inst_99667 = (state_99708[(25)]);
var inst_99676__$1 = cljs.core.first(inst_99667);
var inst_99677 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_99676__$1,inst_99576,done);
var state_99708__$1 = (function (){var statearr_99784 = state_99708;
(statearr_99784[(23)] = inst_99676__$1);

return statearr_99784;
})();
if(cljs.core.truth_(inst_99677)){
var statearr_99785_99844 = state_99708__$1;
(statearr_99785_99844[(1)] = (39));

} else {
var statearr_99786_99845 = state_99708__$1;
(statearr_99786_99845[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99709 === (8))){
var inst_99587 = (state_99708[(13)]);
var inst_99588 = (state_99708[(14)]);
var inst_99590 = (inst_99588 < inst_99587);
var inst_99591 = inst_99590;
var state_99708__$1 = state_99708;
if(cljs.core.truth_(inst_99591)){
var statearr_99787_99846 = state_99708__$1;
(statearr_99787_99846[(1)] = (10));

} else {
var statearr_99788_99847 = state_99708__$1;
(statearr_99788_99847[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___99793,cs,m,dchan,dctr,done))
;
return ((function (switch__98865__auto__,c__98972__auto___99793,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__98866__auto__ = null;
var cljs$core$async$mult_$_state_machine__98866__auto____0 = (function (){
var statearr_99789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99789[(0)] = cljs$core$async$mult_$_state_machine__98866__auto__);

(statearr_99789[(1)] = (1));

return statearr_99789;
});
var cljs$core$async$mult_$_state_machine__98866__auto____1 = (function (state_99708){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99708);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e99790){if((e99790 instanceof Object)){
var ex__98869__auto__ = e99790;
var statearr_99791_99848 = state_99708;
(statearr_99791_99848[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99708);

return cljs.core.cst$kw$recur;
} else {
throw e99790;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__99849 = state_99708;
state_99708 = G__99849;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__98866__auto__ = function(state_99708){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__98866__auto____1.call(this,state_99708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__98866__auto____0;
cljs$core$async$mult_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__98866__auto____1;
return cljs$core$async$mult_$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___99793,cs,m,dchan,dctr,done))
})();
var state__98974__auto__ = (function (){var statearr_99792 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_99792[(6)] = c__98972__auto___99793);

return statearr_99792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___99793,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__99851 = arguments.length;
switch (G__99851) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4434__auto__.call(null,m,state_map));
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4431__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4434__auto__.call(null,m,mode));
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4431__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99863 = arguments.length;
var i__4731__auto___99864 = (0);
while(true){
if((i__4731__auto___99864 < len__4730__auto___99863)){
args__4736__auto__.push((arguments[i__4731__auto___99864]));

var G__99865 = (i__4731__auto___99864 + (1));
i__4731__auto___99864 = G__99865;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__99857){
var map__99858 = p__99857;
var map__99858__$1 = (((((!((map__99858 == null))))?(((((map__99858.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__99858.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__99858):map__99858);
var opts = map__99858__$1;
var statearr_99860_99866 = state;
(statearr_99860_99866[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts(((function (map__99858,map__99858__$1,opts){
return (function (val){
var statearr_99861_99867 = state;
(statearr_99861_99867[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__99858,map__99858__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_99862_99868 = state;
(statearr_99862_99868[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq99853){
var G__99854 = cljs.core.first(seq99853);
var seq99853__$1 = cljs.core.next(seq99853);
var G__99855 = cljs.core.first(seq99853__$1);
var seq99853__$2 = cljs.core.next(seq99853__$1);
var G__99856 = cljs.core.first(seq99853__$2);
var seq99853__$3 = cljs.core.next(seq99853__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__99854,G__99855,G__99856,seq99853__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async99869 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async99869 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta99870){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta99870 = meta99870;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_99871,meta99870__$1){
var self__ = this;
var _99871__$1 = this;
return (new cljs.core.async.t_cljs$core$async99869(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta99870__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_99871){
var self__ = this;
var _99871__$1 = this;
return self__.meta99870;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta99870], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async99869.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async99869.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async99869";

cljs.core.async.t_cljs$core$async99869.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async99869");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async99869.
 */
cljs.core.async.__GT_t_cljs$core$async99869 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async99869(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta99870){
return (new cljs.core.async.t_cljs$core$async99869(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta99870));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async99869(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__98972__auto___100033 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_99973){
var state_val_99974 = (state_99973[(1)]);
if((state_val_99974 === (7))){
var inst_99888 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
var statearr_99975_100034 = state_99973__$1;
(statearr_99975_100034[(2)] = inst_99888);

(statearr_99975_100034[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (20))){
var inst_99900 = (state_99973[(7)]);
var state_99973__$1 = state_99973;
var statearr_99976_100035 = state_99973__$1;
(statearr_99976_100035[(2)] = inst_99900);

(statearr_99976_100035[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (27))){
var state_99973__$1 = state_99973;
var statearr_99977_100036 = state_99973__$1;
(statearr_99977_100036[(2)] = null);

(statearr_99977_100036[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (1))){
var inst_99875 = (state_99973[(8)]);
var inst_99875__$1 = calc_state();
var inst_99877 = (inst_99875__$1 == null);
var inst_99878 = cljs.core.not(inst_99877);
var state_99973__$1 = (function (){var statearr_99978 = state_99973;
(statearr_99978[(8)] = inst_99875__$1);

return statearr_99978;
})();
if(inst_99878){
var statearr_99979_100037 = state_99973__$1;
(statearr_99979_100037[(1)] = (2));

} else {
var statearr_99980_100038 = state_99973__$1;
(statearr_99980_100038[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (24))){
var inst_99924 = (state_99973[(9)]);
var inst_99933 = (state_99973[(10)]);
var inst_99947 = (state_99973[(11)]);
var inst_99947__$1 = (inst_99924.cljs$core$IFn$_invoke$arity$1 ? inst_99924.cljs$core$IFn$_invoke$arity$1(inst_99933) : inst_99924.call(null,inst_99933));
var state_99973__$1 = (function (){var statearr_99981 = state_99973;
(statearr_99981[(11)] = inst_99947__$1);

return statearr_99981;
})();
if(cljs.core.truth_(inst_99947__$1)){
var statearr_99982_100039 = state_99973__$1;
(statearr_99982_100039[(1)] = (29));

} else {
var statearr_99983_100040 = state_99973__$1;
(statearr_99983_100040[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (4))){
var inst_99891 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99891)){
var statearr_99984_100041 = state_99973__$1;
(statearr_99984_100041[(1)] = (8));

} else {
var statearr_99985_100042 = state_99973__$1;
(statearr_99985_100042[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (15))){
var inst_99918 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99918)){
var statearr_99986_100043 = state_99973__$1;
(statearr_99986_100043[(1)] = (19));

} else {
var statearr_99987_100044 = state_99973__$1;
(statearr_99987_100044[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (21))){
var inst_99923 = (state_99973[(12)]);
var inst_99923__$1 = (state_99973[(2)]);
var inst_99924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99923__$1,cljs.core.cst$kw$solos);
var inst_99925 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99923__$1,cljs.core.cst$kw$mutes);
var inst_99926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99923__$1,cljs.core.cst$kw$reads);
var state_99973__$1 = (function (){var statearr_99988 = state_99973;
(statearr_99988[(9)] = inst_99924);

(statearr_99988[(12)] = inst_99923__$1);

(statearr_99988[(13)] = inst_99925);

return statearr_99988;
})();
return cljs.core.async.ioc_alts_BANG_(state_99973__$1,(22),inst_99926);
} else {
if((state_val_99974 === (31))){
var inst_99955 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99955)){
var statearr_99989_100045 = state_99973__$1;
(statearr_99989_100045[(1)] = (32));

} else {
var statearr_99990_100046 = state_99973__$1;
(statearr_99990_100046[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (32))){
var inst_99932 = (state_99973[(14)]);
var state_99973__$1 = state_99973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_99973__$1,(35),out,inst_99932);
} else {
if((state_val_99974 === (33))){
var inst_99923 = (state_99973[(12)]);
var inst_99900 = inst_99923;
var state_99973__$1 = (function (){var statearr_99991 = state_99973;
(statearr_99991[(7)] = inst_99900);

return statearr_99991;
})();
var statearr_99992_100047 = state_99973__$1;
(statearr_99992_100047[(2)] = null);

(statearr_99992_100047[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (13))){
var inst_99900 = (state_99973[(7)]);
var inst_99907 = inst_99900.cljs$lang$protocol_mask$partition0$;
var inst_99908 = (inst_99907 & (64));
var inst_99909 = inst_99900.cljs$core$ISeq$;
var inst_99910 = (cljs.core.PROTOCOL_SENTINEL === inst_99909);
var inst_99911 = ((inst_99908) || (inst_99910));
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99911)){
var statearr_99993_100048 = state_99973__$1;
(statearr_99993_100048[(1)] = (16));

} else {
var statearr_99994_100049 = state_99973__$1;
(statearr_99994_100049[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (22))){
var inst_99933 = (state_99973[(10)]);
var inst_99932 = (state_99973[(14)]);
var inst_99931 = (state_99973[(2)]);
var inst_99932__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99931,(0),null);
var inst_99933__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99931,(1),null);
var inst_99934 = (inst_99932__$1 == null);
var inst_99935 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_99933__$1,change);
var inst_99936 = ((inst_99934) || (inst_99935));
var state_99973__$1 = (function (){var statearr_99995 = state_99973;
(statearr_99995[(10)] = inst_99933__$1);

(statearr_99995[(14)] = inst_99932__$1);

return statearr_99995;
})();
if(cljs.core.truth_(inst_99936)){
var statearr_99996_100050 = state_99973__$1;
(statearr_99996_100050[(1)] = (23));

} else {
var statearr_99997_100051 = state_99973__$1;
(statearr_99997_100051[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (36))){
var inst_99923 = (state_99973[(12)]);
var inst_99900 = inst_99923;
var state_99973__$1 = (function (){var statearr_99998 = state_99973;
(statearr_99998[(7)] = inst_99900);

return statearr_99998;
})();
var statearr_99999_100052 = state_99973__$1;
(statearr_99999_100052[(2)] = null);

(statearr_99999_100052[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (29))){
var inst_99947 = (state_99973[(11)]);
var state_99973__$1 = state_99973;
var statearr_100000_100053 = state_99973__$1;
(statearr_100000_100053[(2)] = inst_99947);

(statearr_100000_100053[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (6))){
var state_99973__$1 = state_99973;
var statearr_100001_100054 = state_99973__$1;
(statearr_100001_100054[(2)] = false);

(statearr_100001_100054[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (28))){
var inst_99943 = (state_99973[(2)]);
var inst_99944 = calc_state();
var inst_99900 = inst_99944;
var state_99973__$1 = (function (){var statearr_100002 = state_99973;
(statearr_100002[(7)] = inst_99900);

(statearr_100002[(15)] = inst_99943);

return statearr_100002;
})();
var statearr_100003_100055 = state_99973__$1;
(statearr_100003_100055[(2)] = null);

(statearr_100003_100055[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (25))){
var inst_99969 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
var statearr_100004_100056 = state_99973__$1;
(statearr_100004_100056[(2)] = inst_99969);

(statearr_100004_100056[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (34))){
var inst_99967 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
var statearr_100005_100057 = state_99973__$1;
(statearr_100005_100057[(2)] = inst_99967);

(statearr_100005_100057[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (17))){
var state_99973__$1 = state_99973;
var statearr_100006_100058 = state_99973__$1;
(statearr_100006_100058[(2)] = false);

(statearr_100006_100058[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (3))){
var state_99973__$1 = state_99973;
var statearr_100007_100059 = state_99973__$1;
(statearr_100007_100059[(2)] = false);

(statearr_100007_100059[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (12))){
var inst_99971 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99973__$1,inst_99971);
} else {
if((state_val_99974 === (2))){
var inst_99875 = (state_99973[(8)]);
var inst_99880 = inst_99875.cljs$lang$protocol_mask$partition0$;
var inst_99881 = (inst_99880 & (64));
var inst_99882 = inst_99875.cljs$core$ISeq$;
var inst_99883 = (cljs.core.PROTOCOL_SENTINEL === inst_99882);
var inst_99884 = ((inst_99881) || (inst_99883));
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99884)){
var statearr_100008_100060 = state_99973__$1;
(statearr_100008_100060[(1)] = (5));

} else {
var statearr_100009_100061 = state_99973__$1;
(statearr_100009_100061[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (23))){
var inst_99932 = (state_99973[(14)]);
var inst_99938 = (inst_99932 == null);
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99938)){
var statearr_100010_100062 = state_99973__$1;
(statearr_100010_100062[(1)] = (26));

} else {
var statearr_100011_100063 = state_99973__$1;
(statearr_100011_100063[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (35))){
var inst_99958 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
if(cljs.core.truth_(inst_99958)){
var statearr_100012_100064 = state_99973__$1;
(statearr_100012_100064[(1)] = (36));

} else {
var statearr_100013_100065 = state_99973__$1;
(statearr_100013_100065[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (19))){
var inst_99900 = (state_99973[(7)]);
var inst_99920 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_99900);
var state_99973__$1 = state_99973;
var statearr_100014_100066 = state_99973__$1;
(statearr_100014_100066[(2)] = inst_99920);

(statearr_100014_100066[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (11))){
var inst_99900 = (state_99973[(7)]);
var inst_99904 = (inst_99900 == null);
var inst_99905 = cljs.core.not(inst_99904);
var state_99973__$1 = state_99973;
if(inst_99905){
var statearr_100015_100067 = state_99973__$1;
(statearr_100015_100067[(1)] = (13));

} else {
var statearr_100016_100068 = state_99973__$1;
(statearr_100016_100068[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (9))){
var inst_99875 = (state_99973[(8)]);
var state_99973__$1 = state_99973;
var statearr_100017_100069 = state_99973__$1;
(statearr_100017_100069[(2)] = inst_99875);

(statearr_100017_100069[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (5))){
var state_99973__$1 = state_99973;
var statearr_100018_100070 = state_99973__$1;
(statearr_100018_100070[(2)] = true);

(statearr_100018_100070[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (14))){
var state_99973__$1 = state_99973;
var statearr_100019_100071 = state_99973__$1;
(statearr_100019_100071[(2)] = false);

(statearr_100019_100071[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (26))){
var inst_99933 = (state_99973[(10)]);
var inst_99940 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_99933);
var state_99973__$1 = state_99973;
var statearr_100020_100072 = state_99973__$1;
(statearr_100020_100072[(2)] = inst_99940);

(statearr_100020_100072[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (16))){
var state_99973__$1 = state_99973;
var statearr_100021_100073 = state_99973__$1;
(statearr_100021_100073[(2)] = true);

(statearr_100021_100073[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (38))){
var inst_99963 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
var statearr_100022_100074 = state_99973__$1;
(statearr_100022_100074[(2)] = inst_99963);

(statearr_100022_100074[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (30))){
var inst_99924 = (state_99973[(9)]);
var inst_99933 = (state_99973[(10)]);
var inst_99925 = (state_99973[(13)]);
var inst_99950 = cljs.core.empty_QMARK_(inst_99924);
var inst_99951 = (inst_99925.cljs$core$IFn$_invoke$arity$1 ? inst_99925.cljs$core$IFn$_invoke$arity$1(inst_99933) : inst_99925.call(null,inst_99933));
var inst_99952 = cljs.core.not(inst_99951);
var inst_99953 = ((inst_99950) && (inst_99952));
var state_99973__$1 = state_99973;
var statearr_100023_100075 = state_99973__$1;
(statearr_100023_100075[(2)] = inst_99953);

(statearr_100023_100075[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (10))){
var inst_99875 = (state_99973[(8)]);
var inst_99896 = (state_99973[(2)]);
var inst_99897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99896,cljs.core.cst$kw$solos);
var inst_99898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99896,cljs.core.cst$kw$mutes);
var inst_99899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_99896,cljs.core.cst$kw$reads);
var inst_99900 = inst_99875;
var state_99973__$1 = (function (){var statearr_100024 = state_99973;
(statearr_100024[(16)] = inst_99899);

(statearr_100024[(17)] = inst_99897);

(statearr_100024[(7)] = inst_99900);

(statearr_100024[(18)] = inst_99898);

return statearr_100024;
})();
var statearr_100025_100076 = state_99973__$1;
(statearr_100025_100076[(2)] = null);

(statearr_100025_100076[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (18))){
var inst_99915 = (state_99973[(2)]);
var state_99973__$1 = state_99973;
var statearr_100026_100077 = state_99973__$1;
(statearr_100026_100077[(2)] = inst_99915);

(statearr_100026_100077[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (37))){
var state_99973__$1 = state_99973;
var statearr_100027_100078 = state_99973__$1;
(statearr_100027_100078[(2)] = null);

(statearr_100027_100078[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99974 === (8))){
var inst_99875 = (state_99973[(8)]);
var inst_99893 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_99875);
var state_99973__$1 = state_99973;
var statearr_100028_100079 = state_99973__$1;
(statearr_100028_100079[(2)] = inst_99893);

(statearr_100028_100079[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__98865__auto__,c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__98866__auto__ = null;
var cljs$core$async$mix_$_state_machine__98866__auto____0 = (function (){
var statearr_100029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100029[(0)] = cljs$core$async$mix_$_state_machine__98866__auto__);

(statearr_100029[(1)] = (1));

return statearr_100029;
});
var cljs$core$async$mix_$_state_machine__98866__auto____1 = (function (state_99973){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_99973);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100030){if((e100030 instanceof Object)){
var ex__98869__auto__ = e100030;
var statearr_100031_100080 = state_99973;
(statearr_100031_100080[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99973);

return cljs.core.cst$kw$recur;
} else {
throw e100030;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100081 = state_99973;
state_99973 = G__100081;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__98866__auto__ = function(state_99973){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__98866__auto____1.call(this,state_99973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__98866__auto____0;
cljs$core$async$mix_$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__98866__auto____1;
return cljs$core$async$mix_$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__98974__auto__ = (function (){var statearr_100032 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100032[(6)] = c__98972__auto___100033);

return statearr_100032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100033,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4434__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4431__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4434__auto__.call(null,p,v,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4431__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__100083 = arguments.length;
switch (G__100083) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4434__auto__.call(null,p));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4431__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4434__auto__.call(null,p,v));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4431__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__100087 = arguments.length;
switch (G__100087) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4131__auto__,mults){
return (function (p1__100085_SHARP_){
if(cljs.core.truth_((p1__100085_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__100085_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__100085_SHARP_.call(null,topic)))){
return p1__100085_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__100085_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100088 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100088 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta100089){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta100089 = meta100089;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_100090,meta100089__$1){
var self__ = this;
var _100090__$1 = this;
return (new cljs.core.async.t_cljs$core$async100088(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta100089__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_100090){
var self__ = this;
var _100090__$1 = this;
return self__.meta100089;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta100089], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async100088.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async100088.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100088";

cljs.core.async.t_cljs$core$async100088.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async100088");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100088.
 */
cljs.core.async.__GT_t_cljs$core$async100088 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async100088(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta100089){
return (new cljs.core.async.t_cljs$core$async100088(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta100089));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async100088(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__98972__auto___100208 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100208,mults,ensure_mult,p){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100208,mults,ensure_mult,p){
return (function (state_100162){
var state_val_100163 = (state_100162[(1)]);
if((state_val_100163 === (7))){
var inst_100158 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100164_100209 = state_100162__$1;
(statearr_100164_100209[(2)] = inst_100158);

(statearr_100164_100209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (20))){
var state_100162__$1 = state_100162;
var statearr_100165_100210 = state_100162__$1;
(statearr_100165_100210[(2)] = null);

(statearr_100165_100210[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (1))){
var state_100162__$1 = state_100162;
var statearr_100166_100211 = state_100162__$1;
(statearr_100166_100211[(2)] = null);

(statearr_100166_100211[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (24))){
var inst_100141 = (state_100162[(7)]);
var inst_100150 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_100141);
var state_100162__$1 = state_100162;
var statearr_100167_100212 = state_100162__$1;
(statearr_100167_100212[(2)] = inst_100150);

(statearr_100167_100212[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (4))){
var inst_100093 = (state_100162[(8)]);
var inst_100093__$1 = (state_100162[(2)]);
var inst_100094 = (inst_100093__$1 == null);
var state_100162__$1 = (function (){var statearr_100168 = state_100162;
(statearr_100168[(8)] = inst_100093__$1);

return statearr_100168;
})();
if(cljs.core.truth_(inst_100094)){
var statearr_100169_100213 = state_100162__$1;
(statearr_100169_100213[(1)] = (5));

} else {
var statearr_100170_100214 = state_100162__$1;
(statearr_100170_100214[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (15))){
var inst_100135 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100171_100215 = state_100162__$1;
(statearr_100171_100215[(2)] = inst_100135);

(statearr_100171_100215[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (21))){
var inst_100155 = (state_100162[(2)]);
var state_100162__$1 = (function (){var statearr_100172 = state_100162;
(statearr_100172[(9)] = inst_100155);

return statearr_100172;
})();
var statearr_100173_100216 = state_100162__$1;
(statearr_100173_100216[(2)] = null);

(statearr_100173_100216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (13))){
var inst_100117 = (state_100162[(10)]);
var inst_100119 = cljs.core.chunked_seq_QMARK_(inst_100117);
var state_100162__$1 = state_100162;
if(inst_100119){
var statearr_100174_100217 = state_100162__$1;
(statearr_100174_100217[(1)] = (16));

} else {
var statearr_100175_100218 = state_100162__$1;
(statearr_100175_100218[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (22))){
var inst_100147 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
if(cljs.core.truth_(inst_100147)){
var statearr_100176_100219 = state_100162__$1;
(statearr_100176_100219[(1)] = (23));

} else {
var statearr_100177_100220 = state_100162__$1;
(statearr_100177_100220[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (6))){
var inst_100143 = (state_100162[(11)]);
var inst_100093 = (state_100162[(8)]);
var inst_100141 = (state_100162[(7)]);
var inst_100141__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_100093) : topic_fn.call(null,inst_100093));
var inst_100142 = cljs.core.deref(mults);
var inst_100143__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_100142,inst_100141__$1);
var state_100162__$1 = (function (){var statearr_100178 = state_100162;
(statearr_100178[(11)] = inst_100143__$1);

(statearr_100178[(7)] = inst_100141__$1);

return statearr_100178;
})();
if(cljs.core.truth_(inst_100143__$1)){
var statearr_100179_100221 = state_100162__$1;
(statearr_100179_100221[(1)] = (19));

} else {
var statearr_100180_100222 = state_100162__$1;
(statearr_100180_100222[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (25))){
var inst_100152 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100181_100223 = state_100162__$1;
(statearr_100181_100223[(2)] = inst_100152);

(statearr_100181_100223[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (17))){
var inst_100117 = (state_100162[(10)]);
var inst_100126 = cljs.core.first(inst_100117);
var inst_100127 = cljs.core.async.muxch_STAR_(inst_100126);
var inst_100128 = cljs.core.async.close_BANG_(inst_100127);
var inst_100129 = cljs.core.next(inst_100117);
var inst_100103 = inst_100129;
var inst_100104 = null;
var inst_100105 = (0);
var inst_100106 = (0);
var state_100162__$1 = (function (){var statearr_100182 = state_100162;
(statearr_100182[(12)] = inst_100104);

(statearr_100182[(13)] = inst_100106);

(statearr_100182[(14)] = inst_100105);

(statearr_100182[(15)] = inst_100103);

(statearr_100182[(16)] = inst_100128);

return statearr_100182;
})();
var statearr_100183_100224 = state_100162__$1;
(statearr_100183_100224[(2)] = null);

(statearr_100183_100224[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (3))){
var inst_100160 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100162__$1,inst_100160);
} else {
if((state_val_100163 === (12))){
var inst_100137 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100184_100225 = state_100162__$1;
(statearr_100184_100225[(2)] = inst_100137);

(statearr_100184_100225[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (2))){
var state_100162__$1 = state_100162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100162__$1,(4),ch);
} else {
if((state_val_100163 === (23))){
var state_100162__$1 = state_100162;
var statearr_100185_100226 = state_100162__$1;
(statearr_100185_100226[(2)] = null);

(statearr_100185_100226[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (19))){
var inst_100143 = (state_100162[(11)]);
var inst_100093 = (state_100162[(8)]);
var inst_100145 = cljs.core.async.muxch_STAR_(inst_100143);
var state_100162__$1 = state_100162;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100162__$1,(22),inst_100145,inst_100093);
} else {
if((state_val_100163 === (11))){
var inst_100103 = (state_100162[(15)]);
var inst_100117 = (state_100162[(10)]);
var inst_100117__$1 = cljs.core.seq(inst_100103);
var state_100162__$1 = (function (){var statearr_100186 = state_100162;
(statearr_100186[(10)] = inst_100117__$1);

return statearr_100186;
})();
if(inst_100117__$1){
var statearr_100187_100227 = state_100162__$1;
(statearr_100187_100227[(1)] = (13));

} else {
var statearr_100188_100228 = state_100162__$1;
(statearr_100188_100228[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (9))){
var inst_100139 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100189_100229 = state_100162__$1;
(statearr_100189_100229[(2)] = inst_100139);

(statearr_100189_100229[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (5))){
var inst_100100 = cljs.core.deref(mults);
var inst_100101 = cljs.core.vals(inst_100100);
var inst_100102 = cljs.core.seq(inst_100101);
var inst_100103 = inst_100102;
var inst_100104 = null;
var inst_100105 = (0);
var inst_100106 = (0);
var state_100162__$1 = (function (){var statearr_100190 = state_100162;
(statearr_100190[(12)] = inst_100104);

(statearr_100190[(13)] = inst_100106);

(statearr_100190[(14)] = inst_100105);

(statearr_100190[(15)] = inst_100103);

return statearr_100190;
})();
var statearr_100191_100230 = state_100162__$1;
(statearr_100191_100230[(2)] = null);

(statearr_100191_100230[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (14))){
var state_100162__$1 = state_100162;
var statearr_100195_100231 = state_100162__$1;
(statearr_100195_100231[(2)] = null);

(statearr_100195_100231[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (16))){
var inst_100117 = (state_100162[(10)]);
var inst_100121 = cljs.core.chunk_first(inst_100117);
var inst_100122 = cljs.core.chunk_rest(inst_100117);
var inst_100123 = cljs.core.count(inst_100121);
var inst_100103 = inst_100122;
var inst_100104 = inst_100121;
var inst_100105 = inst_100123;
var inst_100106 = (0);
var state_100162__$1 = (function (){var statearr_100196 = state_100162;
(statearr_100196[(12)] = inst_100104);

(statearr_100196[(13)] = inst_100106);

(statearr_100196[(14)] = inst_100105);

(statearr_100196[(15)] = inst_100103);

return statearr_100196;
})();
var statearr_100197_100232 = state_100162__$1;
(statearr_100197_100232[(2)] = null);

(statearr_100197_100232[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (10))){
var inst_100104 = (state_100162[(12)]);
var inst_100106 = (state_100162[(13)]);
var inst_100105 = (state_100162[(14)]);
var inst_100103 = (state_100162[(15)]);
var inst_100111 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_100104,inst_100106);
var inst_100112 = cljs.core.async.muxch_STAR_(inst_100111);
var inst_100113 = cljs.core.async.close_BANG_(inst_100112);
var inst_100114 = (inst_100106 + (1));
var tmp100192 = inst_100104;
var tmp100193 = inst_100105;
var tmp100194 = inst_100103;
var inst_100103__$1 = tmp100194;
var inst_100104__$1 = tmp100192;
var inst_100105__$1 = tmp100193;
var inst_100106__$1 = inst_100114;
var state_100162__$1 = (function (){var statearr_100198 = state_100162;
(statearr_100198[(12)] = inst_100104__$1);

(statearr_100198[(13)] = inst_100106__$1);

(statearr_100198[(14)] = inst_100105__$1);

(statearr_100198[(17)] = inst_100113);

(statearr_100198[(15)] = inst_100103__$1);

return statearr_100198;
})();
var statearr_100199_100233 = state_100162__$1;
(statearr_100199_100233[(2)] = null);

(statearr_100199_100233[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (18))){
var inst_100132 = (state_100162[(2)]);
var state_100162__$1 = state_100162;
var statearr_100200_100234 = state_100162__$1;
(statearr_100200_100234[(2)] = inst_100132);

(statearr_100200_100234[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100163 === (8))){
var inst_100106 = (state_100162[(13)]);
var inst_100105 = (state_100162[(14)]);
var inst_100108 = (inst_100106 < inst_100105);
var inst_100109 = inst_100108;
var state_100162__$1 = state_100162;
if(cljs.core.truth_(inst_100109)){
var statearr_100201_100235 = state_100162__$1;
(statearr_100201_100235[(1)] = (10));

} else {
var statearr_100202_100236 = state_100162__$1;
(statearr_100202_100236[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100208,mults,ensure_mult,p))
;
return ((function (switch__98865__auto__,c__98972__auto___100208,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100203 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100203[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100203[(1)] = (1));

return statearr_100203;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100162){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100162);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100204){if((e100204 instanceof Object)){
var ex__98869__auto__ = e100204;
var statearr_100205_100237 = state_100162;
(statearr_100205_100237[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100162);

return cljs.core.cst$kw$recur;
} else {
throw e100204;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100238 = state_100162;
state_100162 = G__100238;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100162){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100208,mults,ensure_mult,p))
})();
var state__98974__auto__ = (function (){var statearr_100206 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100206[(6)] = c__98972__auto___100208);

return statearr_100206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100208,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__100240 = arguments.length;
switch (G__100240) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__100243 = arguments.length;
switch (G__100243) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__100246 = arguments.length;
switch (G__100246) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__98972__auto___100313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_100285){
var state_val_100286 = (state_100285[(1)]);
if((state_val_100286 === (7))){
var state_100285__$1 = state_100285;
var statearr_100287_100314 = state_100285__$1;
(statearr_100287_100314[(2)] = null);

(statearr_100287_100314[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (1))){
var state_100285__$1 = state_100285;
var statearr_100288_100315 = state_100285__$1;
(statearr_100288_100315[(2)] = null);

(statearr_100288_100315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (4))){
var inst_100249 = (state_100285[(7)]);
var inst_100251 = (inst_100249 < cnt);
var state_100285__$1 = state_100285;
if(cljs.core.truth_(inst_100251)){
var statearr_100289_100316 = state_100285__$1;
(statearr_100289_100316[(1)] = (6));

} else {
var statearr_100290_100317 = state_100285__$1;
(statearr_100290_100317[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (15))){
var inst_100281 = (state_100285[(2)]);
var state_100285__$1 = state_100285;
var statearr_100291_100318 = state_100285__$1;
(statearr_100291_100318[(2)] = inst_100281);

(statearr_100291_100318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (13))){
var inst_100274 = cljs.core.async.close_BANG_(out);
var state_100285__$1 = state_100285;
var statearr_100292_100319 = state_100285__$1;
(statearr_100292_100319[(2)] = inst_100274);

(statearr_100292_100319[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (6))){
var state_100285__$1 = state_100285;
var statearr_100293_100320 = state_100285__$1;
(statearr_100293_100320[(2)] = null);

(statearr_100293_100320[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (3))){
var inst_100283 = (state_100285[(2)]);
var state_100285__$1 = state_100285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100285__$1,inst_100283);
} else {
if((state_val_100286 === (12))){
var inst_100271 = (state_100285[(8)]);
var inst_100271__$1 = (state_100285[(2)]);
var inst_100272 = cljs.core.some(cljs.core.nil_QMARK_,inst_100271__$1);
var state_100285__$1 = (function (){var statearr_100294 = state_100285;
(statearr_100294[(8)] = inst_100271__$1);

return statearr_100294;
})();
if(cljs.core.truth_(inst_100272)){
var statearr_100295_100321 = state_100285__$1;
(statearr_100295_100321[(1)] = (13));

} else {
var statearr_100296_100322 = state_100285__$1;
(statearr_100296_100322[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (2))){
var inst_100248 = cljs.core.reset_BANG_(dctr,cnt);
var inst_100249 = (0);
var state_100285__$1 = (function (){var statearr_100297 = state_100285;
(statearr_100297[(7)] = inst_100249);

(statearr_100297[(9)] = inst_100248);

return statearr_100297;
})();
var statearr_100298_100323 = state_100285__$1;
(statearr_100298_100323[(2)] = null);

(statearr_100298_100323[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (11))){
var inst_100249 = (state_100285[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_100285,(10),Object,null,(9));
var inst_100258 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_100249) : chs__$1.call(null,inst_100249));
var inst_100259 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_100249) : done.call(null,inst_100249));
var inst_100260 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_100258,inst_100259);
var state_100285__$1 = state_100285;
var statearr_100299_100324 = state_100285__$1;
(statearr_100299_100324[(2)] = inst_100260);


cljs.core.async.impl.ioc_helpers.process_exception(state_100285__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (9))){
var inst_100249 = (state_100285[(7)]);
var inst_100262 = (state_100285[(2)]);
var inst_100263 = (inst_100249 + (1));
var inst_100249__$1 = inst_100263;
var state_100285__$1 = (function (){var statearr_100300 = state_100285;
(statearr_100300[(7)] = inst_100249__$1);

(statearr_100300[(10)] = inst_100262);

return statearr_100300;
})();
var statearr_100301_100325 = state_100285__$1;
(statearr_100301_100325[(2)] = null);

(statearr_100301_100325[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (5))){
var inst_100269 = (state_100285[(2)]);
var state_100285__$1 = (function (){var statearr_100302 = state_100285;
(statearr_100302[(11)] = inst_100269);

return statearr_100302;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100285__$1,(12),dchan);
} else {
if((state_val_100286 === (14))){
var inst_100271 = (state_100285[(8)]);
var inst_100276 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_100271);
var state_100285__$1 = state_100285;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100285__$1,(16),out,inst_100276);
} else {
if((state_val_100286 === (16))){
var inst_100278 = (state_100285[(2)]);
var state_100285__$1 = (function (){var statearr_100303 = state_100285;
(statearr_100303[(12)] = inst_100278);

return statearr_100303;
})();
var statearr_100304_100326 = state_100285__$1;
(statearr_100304_100326[(2)] = null);

(statearr_100304_100326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (10))){
var inst_100253 = (state_100285[(2)]);
var inst_100254 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_100285__$1 = (function (){var statearr_100305 = state_100285;
(statearr_100305[(13)] = inst_100253);

return statearr_100305;
})();
var statearr_100306_100327 = state_100285__$1;
(statearr_100306_100327[(2)] = inst_100254);


cljs.core.async.impl.ioc_helpers.process_exception(state_100285__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_100286 === (8))){
var inst_100267 = (state_100285[(2)]);
var state_100285__$1 = state_100285;
var statearr_100307_100328 = state_100285__$1;
(statearr_100307_100328[(2)] = inst_100267);

(statearr_100307_100328[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__98865__auto__,c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100308[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100308[(1)] = (1));

return statearr_100308;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100285){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100285);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100309){if((e100309 instanceof Object)){
var ex__98869__auto__ = e100309;
var statearr_100310_100329 = state_100285;
(statearr_100310_100329[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100285);

return cljs.core.cst$kw$recur;
} else {
throw e100309;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100330 = state_100285;
state_100285 = G__100330;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100285){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__98974__auto__ = (function (){var statearr_100311 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100311[(6)] = c__98972__auto___100313);

return statearr_100311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100313,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__100333 = arguments.length;
switch (G__100333) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100387 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100387,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100387,out){
return (function (state_100365){
var state_val_100366 = (state_100365[(1)]);
if((state_val_100366 === (7))){
var inst_100345 = (state_100365[(7)]);
var inst_100344 = (state_100365[(8)]);
var inst_100344__$1 = (state_100365[(2)]);
var inst_100345__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100344__$1,(0),null);
var inst_100346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100344__$1,(1),null);
var inst_100347 = (inst_100345__$1 == null);
var state_100365__$1 = (function (){var statearr_100367 = state_100365;
(statearr_100367[(7)] = inst_100345__$1);

(statearr_100367[(9)] = inst_100346);

(statearr_100367[(8)] = inst_100344__$1);

return statearr_100367;
})();
if(cljs.core.truth_(inst_100347)){
var statearr_100368_100388 = state_100365__$1;
(statearr_100368_100388[(1)] = (8));

} else {
var statearr_100369_100389 = state_100365__$1;
(statearr_100369_100389[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (1))){
var inst_100334 = cljs.core.vec(chs);
var inst_100335 = inst_100334;
var state_100365__$1 = (function (){var statearr_100370 = state_100365;
(statearr_100370[(10)] = inst_100335);

return statearr_100370;
})();
var statearr_100371_100390 = state_100365__$1;
(statearr_100371_100390[(2)] = null);

(statearr_100371_100390[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (4))){
var inst_100335 = (state_100365[(10)]);
var state_100365__$1 = state_100365;
return cljs.core.async.ioc_alts_BANG_(state_100365__$1,(7),inst_100335);
} else {
if((state_val_100366 === (6))){
var inst_100361 = (state_100365[(2)]);
var state_100365__$1 = state_100365;
var statearr_100372_100391 = state_100365__$1;
(statearr_100372_100391[(2)] = inst_100361);

(statearr_100372_100391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (3))){
var inst_100363 = (state_100365[(2)]);
var state_100365__$1 = state_100365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100365__$1,inst_100363);
} else {
if((state_val_100366 === (2))){
var inst_100335 = (state_100365[(10)]);
var inst_100337 = cljs.core.count(inst_100335);
var inst_100338 = (inst_100337 > (0));
var state_100365__$1 = state_100365;
if(cljs.core.truth_(inst_100338)){
var statearr_100374_100392 = state_100365__$1;
(statearr_100374_100392[(1)] = (4));

} else {
var statearr_100375_100393 = state_100365__$1;
(statearr_100375_100393[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (11))){
var inst_100335 = (state_100365[(10)]);
var inst_100354 = (state_100365[(2)]);
var tmp100373 = inst_100335;
var inst_100335__$1 = tmp100373;
var state_100365__$1 = (function (){var statearr_100376 = state_100365;
(statearr_100376[(10)] = inst_100335__$1);

(statearr_100376[(11)] = inst_100354);

return statearr_100376;
})();
var statearr_100377_100394 = state_100365__$1;
(statearr_100377_100394[(2)] = null);

(statearr_100377_100394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (9))){
var inst_100345 = (state_100365[(7)]);
var state_100365__$1 = state_100365;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100365__$1,(11),out,inst_100345);
} else {
if((state_val_100366 === (5))){
var inst_100359 = cljs.core.async.close_BANG_(out);
var state_100365__$1 = state_100365;
var statearr_100378_100395 = state_100365__$1;
(statearr_100378_100395[(2)] = inst_100359);

(statearr_100378_100395[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (10))){
var inst_100357 = (state_100365[(2)]);
var state_100365__$1 = state_100365;
var statearr_100379_100396 = state_100365__$1;
(statearr_100379_100396[(2)] = inst_100357);

(statearr_100379_100396[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100366 === (8))){
var inst_100345 = (state_100365[(7)]);
var inst_100335 = (state_100365[(10)]);
var inst_100346 = (state_100365[(9)]);
var inst_100344 = (state_100365[(8)]);
var inst_100349 = (function (){var cs = inst_100335;
var vec__100340 = inst_100344;
var v = inst_100345;
var c = inst_100346;
return ((function (cs,vec__100340,v,c,inst_100345,inst_100335,inst_100346,inst_100344,state_val_100366,c__98972__auto___100387,out){
return (function (p1__100331_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__100331_SHARP_);
});
;})(cs,vec__100340,v,c,inst_100345,inst_100335,inst_100346,inst_100344,state_val_100366,c__98972__auto___100387,out))
})();
var inst_100350 = cljs.core.filterv(inst_100349,inst_100335);
var inst_100335__$1 = inst_100350;
var state_100365__$1 = (function (){var statearr_100380 = state_100365;
(statearr_100380[(10)] = inst_100335__$1);

return statearr_100380;
})();
var statearr_100381_100397 = state_100365__$1;
(statearr_100381_100397[(2)] = null);

(statearr_100381_100397[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100387,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100387,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100382 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100382[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100382[(1)] = (1));

return statearr_100382;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100365){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100365);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100383){if((e100383 instanceof Object)){
var ex__98869__auto__ = e100383;
var statearr_100384_100398 = state_100365;
(statearr_100384_100398[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100365);

return cljs.core.cst$kw$recur;
} else {
throw e100383;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100399 = state_100365;
state_100365 = G__100399;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100365){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100387,out))
})();
var state__98974__auto__ = (function (){var statearr_100385 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100385[(6)] = c__98972__auto___100387);

return statearr_100385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100387,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__100401 = arguments.length;
switch (G__100401) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100446 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100446,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100446,out){
return (function (state_100425){
var state_val_100426 = (state_100425[(1)]);
if((state_val_100426 === (7))){
var inst_100407 = (state_100425[(7)]);
var inst_100407__$1 = (state_100425[(2)]);
var inst_100408 = (inst_100407__$1 == null);
var inst_100409 = cljs.core.not(inst_100408);
var state_100425__$1 = (function (){var statearr_100427 = state_100425;
(statearr_100427[(7)] = inst_100407__$1);

return statearr_100427;
})();
if(inst_100409){
var statearr_100428_100447 = state_100425__$1;
(statearr_100428_100447[(1)] = (8));

} else {
var statearr_100429_100448 = state_100425__$1;
(statearr_100429_100448[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (1))){
var inst_100402 = (0);
var state_100425__$1 = (function (){var statearr_100430 = state_100425;
(statearr_100430[(8)] = inst_100402);

return statearr_100430;
})();
var statearr_100431_100449 = state_100425__$1;
(statearr_100431_100449[(2)] = null);

(statearr_100431_100449[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (4))){
var state_100425__$1 = state_100425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100425__$1,(7),ch);
} else {
if((state_val_100426 === (6))){
var inst_100420 = (state_100425[(2)]);
var state_100425__$1 = state_100425;
var statearr_100432_100450 = state_100425__$1;
(statearr_100432_100450[(2)] = inst_100420);

(statearr_100432_100450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (3))){
var inst_100422 = (state_100425[(2)]);
var inst_100423 = cljs.core.async.close_BANG_(out);
var state_100425__$1 = (function (){var statearr_100433 = state_100425;
(statearr_100433[(9)] = inst_100422);

return statearr_100433;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_100425__$1,inst_100423);
} else {
if((state_val_100426 === (2))){
var inst_100402 = (state_100425[(8)]);
var inst_100404 = (inst_100402 < n);
var state_100425__$1 = state_100425;
if(cljs.core.truth_(inst_100404)){
var statearr_100434_100451 = state_100425__$1;
(statearr_100434_100451[(1)] = (4));

} else {
var statearr_100435_100452 = state_100425__$1;
(statearr_100435_100452[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (11))){
var inst_100402 = (state_100425[(8)]);
var inst_100412 = (state_100425[(2)]);
var inst_100413 = (inst_100402 + (1));
var inst_100402__$1 = inst_100413;
var state_100425__$1 = (function (){var statearr_100436 = state_100425;
(statearr_100436[(8)] = inst_100402__$1);

(statearr_100436[(10)] = inst_100412);

return statearr_100436;
})();
var statearr_100437_100453 = state_100425__$1;
(statearr_100437_100453[(2)] = null);

(statearr_100437_100453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (9))){
var state_100425__$1 = state_100425;
var statearr_100438_100454 = state_100425__$1;
(statearr_100438_100454[(2)] = null);

(statearr_100438_100454[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (5))){
var state_100425__$1 = state_100425;
var statearr_100439_100455 = state_100425__$1;
(statearr_100439_100455[(2)] = null);

(statearr_100439_100455[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (10))){
var inst_100417 = (state_100425[(2)]);
var state_100425__$1 = state_100425;
var statearr_100440_100456 = state_100425__$1;
(statearr_100440_100456[(2)] = inst_100417);

(statearr_100440_100456[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100426 === (8))){
var inst_100407 = (state_100425[(7)]);
var state_100425__$1 = state_100425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100425__$1,(11),out,inst_100407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100446,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100446,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100441 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_100441[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100441[(1)] = (1));

return statearr_100441;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100425){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100425);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100442){if((e100442 instanceof Object)){
var ex__98869__auto__ = e100442;
var statearr_100443_100457 = state_100425;
(statearr_100443_100457[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100425);

return cljs.core.cst$kw$recur;
} else {
throw e100442;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100458 = state_100425;
state_100425 = G__100458;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100446,out))
})();
var state__98974__auto__ = (function (){var statearr_100444 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100444[(6)] = c__98972__auto___100446);

return statearr_100444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100446,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100460 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100460 = (function (f,ch,meta100461){
this.f = f;
this.ch = ch;
this.meta100461 = meta100461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100462,meta100461__$1){
var self__ = this;
var _100462__$1 = this;
return (new cljs.core.async.t_cljs$core$async100460(self__.f,self__.ch,meta100461__$1));
});

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100462){
var self__ = this;
var _100462__$1 = this;
return self__.meta100461;
});

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100463 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100463 = (function (f,ch,meta100461,_,fn1,meta100464){
this.f = f;
this.ch = ch;
this.meta100461 = meta100461;
this._ = _;
this.fn1 = fn1;
this.meta100464 = meta100464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_100465,meta100464__$1){
var self__ = this;
var _100465__$1 = this;
return (new cljs.core.async.t_cljs$core$async100463(self__.f,self__.ch,self__.meta100461,self__._,self__.fn1,meta100464__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_100465){
var self__ = this;
var _100465__$1 = this;
return self__.meta100464;
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__100459_SHARP_){
var G__100466 = (((p1__100459_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__100459_SHARP_) : self__.f.call(null,p1__100459_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__100466) : f1.call(null,G__100466));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta100461,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async100460], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta100464], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async100463.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async100463.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100463";

cljs.core.async.t_cljs$core$async100463.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async100463");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100463.
 */
cljs.core.async.__GT_t_cljs$core$async100463 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async100463(f__$1,ch__$1,meta100461__$1,___$2,fn1__$1,meta100464){
return (new cljs.core.async.t_cljs$core$async100463(f__$1,ch__$1,meta100461__$1,___$2,fn1__$1,meta100464));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async100463(self__.f,self__.ch,self__.meta100461,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__100467 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__100467) : self__.f.call(null,G__100467));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100460.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async100460.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta100461], null);
});

cljs.core.async.t_cljs$core$async100460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async100460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100460";

cljs.core.async.t_cljs$core$async100460.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async100460");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100460.
 */
cljs.core.async.__GT_t_cljs$core$async100460 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async100460(f__$1,ch__$1,meta100461){
return (new cljs.core.async.t_cljs$core$async100460(f__$1,ch__$1,meta100461));
});

}

return (new cljs.core.async.t_cljs$core$async100460(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100468 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100468 = (function (f,ch,meta100469){
this.f = f;
this.ch = ch;
this.meta100469 = meta100469;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100470,meta100469__$1){
var self__ = this;
var _100470__$1 = this;
return (new cljs.core.async.t_cljs$core$async100468(self__.f,self__.ch,meta100469__$1));
});

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100470){
var self__ = this;
var _100470__$1 = this;
return self__.meta100469;
});

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100468.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async100468.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta100469], null);
});

cljs.core.async.t_cljs$core$async100468.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async100468.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100468";

cljs.core.async.t_cljs$core$async100468.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async100468");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100468.
 */
cljs.core.async.__GT_t_cljs$core$async100468 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async100468(f__$1,ch__$1,meta100469){
return (new cljs.core.async.t_cljs$core$async100468(f__$1,ch__$1,meta100469));
});

}

return (new cljs.core.async.t_cljs$core$async100468(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async100471 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async100471 = (function (p,ch,meta100472){
this.p = p;
this.ch = ch;
this.meta100472 = meta100472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_100473,meta100472__$1){
var self__ = this;
var _100473__$1 = this;
return (new cljs.core.async.t_cljs$core$async100471(self__.p,self__.ch,meta100472__$1));
});

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_100473){
var self__ = this;
var _100473__$1 = this;
return self__.meta100472;
});

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async100471.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async100471.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta100472], null);
});

cljs.core.async.t_cljs$core$async100471.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async100471.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async100471";

cljs.core.async.t_cljs$core$async100471.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async100471");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async100471.
 */
cljs.core.async.__GT_t_cljs$core$async100471 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async100471(p__$1,ch__$1,meta100472){
return (new cljs.core.async.t_cljs$core$async100471(p__$1,ch__$1,meta100472));
});

}

return (new cljs.core.async.t_cljs$core$async100471(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__100475 = arguments.length;
switch (G__100475) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100515,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100515,out){
return (function (state_100496){
var state_val_100497 = (state_100496[(1)]);
if((state_val_100497 === (7))){
var inst_100492 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
var statearr_100498_100516 = state_100496__$1;
(statearr_100498_100516[(2)] = inst_100492);

(statearr_100498_100516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (1))){
var state_100496__$1 = state_100496;
var statearr_100499_100517 = state_100496__$1;
(statearr_100499_100517[(2)] = null);

(statearr_100499_100517[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (4))){
var inst_100478 = (state_100496[(7)]);
var inst_100478__$1 = (state_100496[(2)]);
var inst_100479 = (inst_100478__$1 == null);
var state_100496__$1 = (function (){var statearr_100500 = state_100496;
(statearr_100500[(7)] = inst_100478__$1);

return statearr_100500;
})();
if(cljs.core.truth_(inst_100479)){
var statearr_100501_100518 = state_100496__$1;
(statearr_100501_100518[(1)] = (5));

} else {
var statearr_100502_100519 = state_100496__$1;
(statearr_100502_100519[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (6))){
var inst_100478 = (state_100496[(7)]);
var inst_100483 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_100478) : p.call(null,inst_100478));
var state_100496__$1 = state_100496;
if(cljs.core.truth_(inst_100483)){
var statearr_100503_100520 = state_100496__$1;
(statearr_100503_100520[(1)] = (8));

} else {
var statearr_100504_100521 = state_100496__$1;
(statearr_100504_100521[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (3))){
var inst_100494 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100496__$1,inst_100494);
} else {
if((state_val_100497 === (2))){
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100496__$1,(4),ch);
} else {
if((state_val_100497 === (11))){
var inst_100486 = (state_100496[(2)]);
var state_100496__$1 = state_100496;
var statearr_100505_100522 = state_100496__$1;
(statearr_100505_100522[(2)] = inst_100486);

(statearr_100505_100522[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (9))){
var state_100496__$1 = state_100496;
var statearr_100506_100523 = state_100496__$1;
(statearr_100506_100523[(2)] = null);

(statearr_100506_100523[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (5))){
var inst_100481 = cljs.core.async.close_BANG_(out);
var state_100496__$1 = state_100496;
var statearr_100507_100524 = state_100496__$1;
(statearr_100507_100524[(2)] = inst_100481);

(statearr_100507_100524[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (10))){
var inst_100489 = (state_100496[(2)]);
var state_100496__$1 = (function (){var statearr_100508 = state_100496;
(statearr_100508[(8)] = inst_100489);

return statearr_100508;
})();
var statearr_100509_100525 = state_100496__$1;
(statearr_100509_100525[(2)] = null);

(statearr_100509_100525[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100497 === (8))){
var inst_100478 = (state_100496[(7)]);
var state_100496__$1 = state_100496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100496__$1,(11),out,inst_100478);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100515,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100515,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100510 = [null,null,null,null,null,null,null,null,null];
(statearr_100510[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100510[(1)] = (1));

return statearr_100510;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100496){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100496);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100511){if((e100511 instanceof Object)){
var ex__98869__auto__ = e100511;
var statearr_100512_100526 = state_100496;
(statearr_100512_100526[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100496);

return cljs.core.cst$kw$recur;
} else {
throw e100511;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100527 = state_100496;
state_100496 = G__100527;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100515,out))
})();
var state__98974__auto__ = (function (){var statearr_100513 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100513[(6)] = c__98972__auto___100515);

return statearr_100513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100515,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__100529 = arguments.length;
switch (G__100529) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__98972__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto__){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto__){
return (function (state_100592){
var state_val_100593 = (state_100592[(1)]);
if((state_val_100593 === (7))){
var inst_100588 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
var statearr_100594_100632 = state_100592__$1;
(statearr_100594_100632[(2)] = inst_100588);

(statearr_100594_100632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (20))){
var inst_100558 = (state_100592[(7)]);
var inst_100569 = (state_100592[(2)]);
var inst_100570 = cljs.core.next(inst_100558);
var inst_100544 = inst_100570;
var inst_100545 = null;
var inst_100546 = (0);
var inst_100547 = (0);
var state_100592__$1 = (function (){var statearr_100595 = state_100592;
(statearr_100595[(8)] = inst_100544);

(statearr_100595[(9)] = inst_100546);

(statearr_100595[(10)] = inst_100545);

(statearr_100595[(11)] = inst_100547);

(statearr_100595[(12)] = inst_100569);

return statearr_100595;
})();
var statearr_100596_100633 = state_100592__$1;
(statearr_100596_100633[(2)] = null);

(statearr_100596_100633[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (1))){
var state_100592__$1 = state_100592;
var statearr_100597_100634 = state_100592__$1;
(statearr_100597_100634[(2)] = null);

(statearr_100597_100634[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (4))){
var inst_100533 = (state_100592[(13)]);
var inst_100533__$1 = (state_100592[(2)]);
var inst_100534 = (inst_100533__$1 == null);
var state_100592__$1 = (function (){var statearr_100598 = state_100592;
(statearr_100598[(13)] = inst_100533__$1);

return statearr_100598;
})();
if(cljs.core.truth_(inst_100534)){
var statearr_100599_100635 = state_100592__$1;
(statearr_100599_100635[(1)] = (5));

} else {
var statearr_100600_100636 = state_100592__$1;
(statearr_100600_100636[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (15))){
var state_100592__$1 = state_100592;
var statearr_100604_100637 = state_100592__$1;
(statearr_100604_100637[(2)] = null);

(statearr_100604_100637[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (21))){
var state_100592__$1 = state_100592;
var statearr_100605_100638 = state_100592__$1;
(statearr_100605_100638[(2)] = null);

(statearr_100605_100638[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (13))){
var inst_100544 = (state_100592[(8)]);
var inst_100546 = (state_100592[(9)]);
var inst_100545 = (state_100592[(10)]);
var inst_100547 = (state_100592[(11)]);
var inst_100554 = (state_100592[(2)]);
var inst_100555 = (inst_100547 + (1));
var tmp100601 = inst_100544;
var tmp100602 = inst_100546;
var tmp100603 = inst_100545;
var inst_100544__$1 = tmp100601;
var inst_100545__$1 = tmp100603;
var inst_100546__$1 = tmp100602;
var inst_100547__$1 = inst_100555;
var state_100592__$1 = (function (){var statearr_100606 = state_100592;
(statearr_100606[(8)] = inst_100544__$1);

(statearr_100606[(9)] = inst_100546__$1);

(statearr_100606[(14)] = inst_100554);

(statearr_100606[(10)] = inst_100545__$1);

(statearr_100606[(11)] = inst_100547__$1);

return statearr_100606;
})();
var statearr_100607_100639 = state_100592__$1;
(statearr_100607_100639[(2)] = null);

(statearr_100607_100639[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (22))){
var state_100592__$1 = state_100592;
var statearr_100608_100640 = state_100592__$1;
(statearr_100608_100640[(2)] = null);

(statearr_100608_100640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (6))){
var inst_100533 = (state_100592[(13)]);
var inst_100542 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_100533) : f.call(null,inst_100533));
var inst_100543 = cljs.core.seq(inst_100542);
var inst_100544 = inst_100543;
var inst_100545 = null;
var inst_100546 = (0);
var inst_100547 = (0);
var state_100592__$1 = (function (){var statearr_100609 = state_100592;
(statearr_100609[(8)] = inst_100544);

(statearr_100609[(9)] = inst_100546);

(statearr_100609[(10)] = inst_100545);

(statearr_100609[(11)] = inst_100547);

return statearr_100609;
})();
var statearr_100610_100641 = state_100592__$1;
(statearr_100610_100641[(2)] = null);

(statearr_100610_100641[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (17))){
var inst_100558 = (state_100592[(7)]);
var inst_100562 = cljs.core.chunk_first(inst_100558);
var inst_100563 = cljs.core.chunk_rest(inst_100558);
var inst_100564 = cljs.core.count(inst_100562);
var inst_100544 = inst_100563;
var inst_100545 = inst_100562;
var inst_100546 = inst_100564;
var inst_100547 = (0);
var state_100592__$1 = (function (){var statearr_100611 = state_100592;
(statearr_100611[(8)] = inst_100544);

(statearr_100611[(9)] = inst_100546);

(statearr_100611[(10)] = inst_100545);

(statearr_100611[(11)] = inst_100547);

return statearr_100611;
})();
var statearr_100612_100642 = state_100592__$1;
(statearr_100612_100642[(2)] = null);

(statearr_100612_100642[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (3))){
var inst_100590 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100592__$1,inst_100590);
} else {
if((state_val_100593 === (12))){
var inst_100578 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
var statearr_100613_100643 = state_100592__$1;
(statearr_100613_100643[(2)] = inst_100578);

(statearr_100613_100643[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (2))){
var state_100592__$1 = state_100592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100592__$1,(4),in$);
} else {
if((state_val_100593 === (23))){
var inst_100586 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
var statearr_100614_100644 = state_100592__$1;
(statearr_100614_100644[(2)] = inst_100586);

(statearr_100614_100644[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (19))){
var inst_100573 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
var statearr_100615_100645 = state_100592__$1;
(statearr_100615_100645[(2)] = inst_100573);

(statearr_100615_100645[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (11))){
var inst_100544 = (state_100592[(8)]);
var inst_100558 = (state_100592[(7)]);
var inst_100558__$1 = cljs.core.seq(inst_100544);
var state_100592__$1 = (function (){var statearr_100616 = state_100592;
(statearr_100616[(7)] = inst_100558__$1);

return statearr_100616;
})();
if(inst_100558__$1){
var statearr_100617_100646 = state_100592__$1;
(statearr_100617_100646[(1)] = (14));

} else {
var statearr_100618_100647 = state_100592__$1;
(statearr_100618_100647[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (9))){
var inst_100580 = (state_100592[(2)]);
var inst_100581 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_100592__$1 = (function (){var statearr_100619 = state_100592;
(statearr_100619[(15)] = inst_100580);

return statearr_100619;
})();
if(cljs.core.truth_(inst_100581)){
var statearr_100620_100648 = state_100592__$1;
(statearr_100620_100648[(1)] = (21));

} else {
var statearr_100621_100649 = state_100592__$1;
(statearr_100621_100649[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (5))){
var inst_100536 = cljs.core.async.close_BANG_(out);
var state_100592__$1 = state_100592;
var statearr_100622_100650 = state_100592__$1;
(statearr_100622_100650[(2)] = inst_100536);

(statearr_100622_100650[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (14))){
var inst_100558 = (state_100592[(7)]);
var inst_100560 = cljs.core.chunked_seq_QMARK_(inst_100558);
var state_100592__$1 = state_100592;
if(inst_100560){
var statearr_100623_100651 = state_100592__$1;
(statearr_100623_100651[(1)] = (17));

} else {
var statearr_100624_100652 = state_100592__$1;
(statearr_100624_100652[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (16))){
var inst_100576 = (state_100592[(2)]);
var state_100592__$1 = state_100592;
var statearr_100625_100653 = state_100592__$1;
(statearr_100625_100653[(2)] = inst_100576);

(statearr_100625_100653[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100593 === (10))){
var inst_100545 = (state_100592[(10)]);
var inst_100547 = (state_100592[(11)]);
var inst_100552 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_100545,inst_100547);
var state_100592__$1 = state_100592;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100592__$1,(13),out,inst_100552);
} else {
if((state_val_100593 === (18))){
var inst_100558 = (state_100592[(7)]);
var inst_100567 = cljs.core.first(inst_100558);
var state_100592__$1 = state_100592;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100592__$1,(20),out,inst_100567);
} else {
if((state_val_100593 === (8))){
var inst_100546 = (state_100592[(9)]);
var inst_100547 = (state_100592[(11)]);
var inst_100549 = (inst_100547 < inst_100546);
var inst_100550 = inst_100549;
var state_100592__$1 = state_100592;
if(cljs.core.truth_(inst_100550)){
var statearr_100626_100654 = state_100592__$1;
(statearr_100626_100654[(1)] = (10));

} else {
var statearr_100627_100655 = state_100592__$1;
(statearr_100627_100655[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto__))
;
return ((function (switch__98865__auto__,c__98972__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____0 = (function (){
var statearr_100628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100628[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__);

(statearr_100628[(1)] = (1));

return statearr_100628;
});
var cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____1 = (function (state_100592){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100592);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100629){if((e100629 instanceof Object)){
var ex__98869__auto__ = e100629;
var statearr_100630_100656 = state_100592;
(statearr_100630_100656[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100592);

return cljs.core.cst$kw$recur;
} else {
throw e100629;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100657 = state_100592;
state_100592 = G__100657;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__ = function(state_100592){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____1.call(this,state_100592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__98866__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto__))
})();
var state__98974__auto__ = (function (){var statearr_100631 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100631[(6)] = c__98972__auto__);

return statearr_100631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto__))
);

return c__98972__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__100659 = arguments.length;
switch (G__100659) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__100662 = arguments.length;
switch (G__100662) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__100665 = arguments.length;
switch (G__100665) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100712,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100712,out){
return (function (state_100689){
var state_val_100690 = (state_100689[(1)]);
if((state_val_100690 === (7))){
var inst_100684 = (state_100689[(2)]);
var state_100689__$1 = state_100689;
var statearr_100691_100713 = state_100689__$1;
(statearr_100691_100713[(2)] = inst_100684);

(statearr_100691_100713[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (1))){
var inst_100666 = null;
var state_100689__$1 = (function (){var statearr_100692 = state_100689;
(statearr_100692[(7)] = inst_100666);

return statearr_100692;
})();
var statearr_100693_100714 = state_100689__$1;
(statearr_100693_100714[(2)] = null);

(statearr_100693_100714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (4))){
var inst_100669 = (state_100689[(8)]);
var inst_100669__$1 = (state_100689[(2)]);
var inst_100670 = (inst_100669__$1 == null);
var inst_100671 = cljs.core.not(inst_100670);
var state_100689__$1 = (function (){var statearr_100694 = state_100689;
(statearr_100694[(8)] = inst_100669__$1);

return statearr_100694;
})();
if(inst_100671){
var statearr_100695_100715 = state_100689__$1;
(statearr_100695_100715[(1)] = (5));

} else {
var statearr_100696_100716 = state_100689__$1;
(statearr_100696_100716[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (6))){
var state_100689__$1 = state_100689;
var statearr_100697_100717 = state_100689__$1;
(statearr_100697_100717[(2)] = null);

(statearr_100697_100717[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (3))){
var inst_100686 = (state_100689[(2)]);
var inst_100687 = cljs.core.async.close_BANG_(out);
var state_100689__$1 = (function (){var statearr_100698 = state_100689;
(statearr_100698[(9)] = inst_100686);

return statearr_100698;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_100689__$1,inst_100687);
} else {
if((state_val_100690 === (2))){
var state_100689__$1 = state_100689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100689__$1,(4),ch);
} else {
if((state_val_100690 === (11))){
var inst_100669 = (state_100689[(8)]);
var inst_100678 = (state_100689[(2)]);
var inst_100666 = inst_100669;
var state_100689__$1 = (function (){var statearr_100699 = state_100689;
(statearr_100699[(7)] = inst_100666);

(statearr_100699[(10)] = inst_100678);

return statearr_100699;
})();
var statearr_100700_100718 = state_100689__$1;
(statearr_100700_100718[(2)] = null);

(statearr_100700_100718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (9))){
var inst_100669 = (state_100689[(8)]);
var state_100689__$1 = state_100689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100689__$1,(11),out,inst_100669);
} else {
if((state_val_100690 === (5))){
var inst_100666 = (state_100689[(7)]);
var inst_100669 = (state_100689[(8)]);
var inst_100673 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_100669,inst_100666);
var state_100689__$1 = state_100689;
if(inst_100673){
var statearr_100702_100719 = state_100689__$1;
(statearr_100702_100719[(1)] = (8));

} else {
var statearr_100703_100720 = state_100689__$1;
(statearr_100703_100720[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (10))){
var inst_100681 = (state_100689[(2)]);
var state_100689__$1 = state_100689;
var statearr_100704_100721 = state_100689__$1;
(statearr_100704_100721[(2)] = inst_100681);

(statearr_100704_100721[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100690 === (8))){
var inst_100666 = (state_100689[(7)]);
var tmp100701 = inst_100666;
var inst_100666__$1 = tmp100701;
var state_100689__$1 = (function (){var statearr_100705 = state_100689;
(statearr_100705[(7)] = inst_100666__$1);

return statearr_100705;
})();
var statearr_100706_100722 = state_100689__$1;
(statearr_100706_100722[(2)] = null);

(statearr_100706_100722[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100712,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100712,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100707 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_100707[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100707[(1)] = (1));

return statearr_100707;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100689){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100689);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100708){if((e100708 instanceof Object)){
var ex__98869__auto__ = e100708;
var statearr_100709_100723 = state_100689;
(statearr_100709_100723[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100689);

return cljs.core.cst$kw$recur;
} else {
throw e100708;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100724 = state_100689;
state_100689 = G__100724;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100712,out))
})();
var state__98974__auto__ = (function (){var statearr_100710 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100710[(6)] = c__98972__auto___100712);

return statearr_100710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100712,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__100726 = arguments.length;
switch (G__100726) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100792 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100792,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100792,out){
return (function (state_100764){
var state_val_100765 = (state_100764[(1)]);
if((state_val_100765 === (7))){
var inst_100760 = (state_100764[(2)]);
var state_100764__$1 = state_100764;
var statearr_100766_100793 = state_100764__$1;
(statearr_100766_100793[(2)] = inst_100760);

(statearr_100766_100793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (1))){
var inst_100727 = (new Array(n));
var inst_100728 = inst_100727;
var inst_100729 = (0);
var state_100764__$1 = (function (){var statearr_100767 = state_100764;
(statearr_100767[(7)] = inst_100729);

(statearr_100767[(8)] = inst_100728);

return statearr_100767;
})();
var statearr_100768_100794 = state_100764__$1;
(statearr_100768_100794[(2)] = null);

(statearr_100768_100794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (4))){
var inst_100732 = (state_100764[(9)]);
var inst_100732__$1 = (state_100764[(2)]);
var inst_100733 = (inst_100732__$1 == null);
var inst_100734 = cljs.core.not(inst_100733);
var state_100764__$1 = (function (){var statearr_100769 = state_100764;
(statearr_100769[(9)] = inst_100732__$1);

return statearr_100769;
})();
if(inst_100734){
var statearr_100770_100795 = state_100764__$1;
(statearr_100770_100795[(1)] = (5));

} else {
var statearr_100771_100796 = state_100764__$1;
(statearr_100771_100796[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (15))){
var inst_100754 = (state_100764[(2)]);
var state_100764__$1 = state_100764;
var statearr_100772_100797 = state_100764__$1;
(statearr_100772_100797[(2)] = inst_100754);

(statearr_100772_100797[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (13))){
var state_100764__$1 = state_100764;
var statearr_100773_100798 = state_100764__$1;
(statearr_100773_100798[(2)] = null);

(statearr_100773_100798[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (6))){
var inst_100729 = (state_100764[(7)]);
var inst_100750 = (inst_100729 > (0));
var state_100764__$1 = state_100764;
if(cljs.core.truth_(inst_100750)){
var statearr_100774_100799 = state_100764__$1;
(statearr_100774_100799[(1)] = (12));

} else {
var statearr_100775_100800 = state_100764__$1;
(statearr_100775_100800[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (3))){
var inst_100762 = (state_100764[(2)]);
var state_100764__$1 = state_100764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100764__$1,inst_100762);
} else {
if((state_val_100765 === (12))){
var inst_100728 = (state_100764[(8)]);
var inst_100752 = cljs.core.vec(inst_100728);
var state_100764__$1 = state_100764;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100764__$1,(15),out,inst_100752);
} else {
if((state_val_100765 === (2))){
var state_100764__$1 = state_100764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100764__$1,(4),ch);
} else {
if((state_val_100765 === (11))){
var inst_100744 = (state_100764[(2)]);
var inst_100745 = (new Array(n));
var inst_100728 = inst_100745;
var inst_100729 = (0);
var state_100764__$1 = (function (){var statearr_100776 = state_100764;
(statearr_100776[(7)] = inst_100729);

(statearr_100776[(8)] = inst_100728);

(statearr_100776[(10)] = inst_100744);

return statearr_100776;
})();
var statearr_100777_100801 = state_100764__$1;
(statearr_100777_100801[(2)] = null);

(statearr_100777_100801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (9))){
var inst_100728 = (state_100764[(8)]);
var inst_100742 = cljs.core.vec(inst_100728);
var state_100764__$1 = state_100764;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100764__$1,(11),out,inst_100742);
} else {
if((state_val_100765 === (5))){
var inst_100729 = (state_100764[(7)]);
var inst_100728 = (state_100764[(8)]);
var inst_100732 = (state_100764[(9)]);
var inst_100737 = (state_100764[(11)]);
var inst_100736 = (inst_100728[inst_100729] = inst_100732);
var inst_100737__$1 = (inst_100729 + (1));
var inst_100738 = (inst_100737__$1 < n);
var state_100764__$1 = (function (){var statearr_100778 = state_100764;
(statearr_100778[(12)] = inst_100736);

(statearr_100778[(11)] = inst_100737__$1);

return statearr_100778;
})();
if(cljs.core.truth_(inst_100738)){
var statearr_100779_100802 = state_100764__$1;
(statearr_100779_100802[(1)] = (8));

} else {
var statearr_100780_100803 = state_100764__$1;
(statearr_100780_100803[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (14))){
var inst_100757 = (state_100764[(2)]);
var inst_100758 = cljs.core.async.close_BANG_(out);
var state_100764__$1 = (function (){var statearr_100782 = state_100764;
(statearr_100782[(13)] = inst_100757);

return statearr_100782;
})();
var statearr_100783_100804 = state_100764__$1;
(statearr_100783_100804[(2)] = inst_100758);

(statearr_100783_100804[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (10))){
var inst_100748 = (state_100764[(2)]);
var state_100764__$1 = state_100764;
var statearr_100784_100805 = state_100764__$1;
(statearr_100784_100805[(2)] = inst_100748);

(statearr_100784_100805[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100765 === (8))){
var inst_100728 = (state_100764[(8)]);
var inst_100737 = (state_100764[(11)]);
var tmp100781 = inst_100728;
var inst_100728__$1 = tmp100781;
var inst_100729 = inst_100737;
var state_100764__$1 = (function (){var statearr_100785 = state_100764;
(statearr_100785[(7)] = inst_100729);

(statearr_100785[(8)] = inst_100728__$1);

return statearr_100785;
})();
var statearr_100786_100806 = state_100764__$1;
(statearr_100786_100806[(2)] = null);

(statearr_100786_100806[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100792,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100792,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100787[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100787[(1)] = (1));

return statearr_100787;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100764){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100764);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100788){if((e100788 instanceof Object)){
var ex__98869__auto__ = e100788;
var statearr_100789_100807 = state_100764;
(statearr_100789_100807[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100764);

return cljs.core.cst$kw$recur;
} else {
throw e100788;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100808 = state_100764;
state_100764 = G__100808;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100764){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100792,out))
})();
var state__98974__auto__ = (function (){var statearr_100790 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100790[(6)] = c__98972__auto___100792);

return statearr_100790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100792,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__100810 = arguments.length;
switch (G__100810) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__98972__auto___100880 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__98972__auto___100880,out){
return (function (){
var f__98973__auto__ = (function (){var switch__98865__auto__ = ((function (c__98972__auto___100880,out){
return (function (state_100852){
var state_val_100853 = (state_100852[(1)]);
if((state_val_100853 === (7))){
var inst_100848 = (state_100852[(2)]);
var state_100852__$1 = state_100852;
var statearr_100854_100881 = state_100852__$1;
(statearr_100854_100881[(2)] = inst_100848);

(statearr_100854_100881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (1))){
var inst_100811 = [];
var inst_100812 = inst_100811;
var inst_100813 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_100852__$1 = (function (){var statearr_100855 = state_100852;
(statearr_100855[(7)] = inst_100812);

(statearr_100855[(8)] = inst_100813);

return statearr_100855;
})();
var statearr_100856_100882 = state_100852__$1;
(statearr_100856_100882[(2)] = null);

(statearr_100856_100882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (4))){
var inst_100816 = (state_100852[(9)]);
var inst_100816__$1 = (state_100852[(2)]);
var inst_100817 = (inst_100816__$1 == null);
var inst_100818 = cljs.core.not(inst_100817);
var state_100852__$1 = (function (){var statearr_100857 = state_100852;
(statearr_100857[(9)] = inst_100816__$1);

return statearr_100857;
})();
if(inst_100818){
var statearr_100858_100883 = state_100852__$1;
(statearr_100858_100883[(1)] = (5));

} else {
var statearr_100859_100884 = state_100852__$1;
(statearr_100859_100884[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (15))){
var inst_100842 = (state_100852[(2)]);
var state_100852__$1 = state_100852;
var statearr_100860_100885 = state_100852__$1;
(statearr_100860_100885[(2)] = inst_100842);

(statearr_100860_100885[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (13))){
var state_100852__$1 = state_100852;
var statearr_100861_100886 = state_100852__$1;
(statearr_100861_100886[(2)] = null);

(statearr_100861_100886[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (6))){
var inst_100812 = (state_100852[(7)]);
var inst_100837 = inst_100812.length;
var inst_100838 = (inst_100837 > (0));
var state_100852__$1 = state_100852;
if(cljs.core.truth_(inst_100838)){
var statearr_100862_100887 = state_100852__$1;
(statearr_100862_100887[(1)] = (12));

} else {
var statearr_100863_100888 = state_100852__$1;
(statearr_100863_100888[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (3))){
var inst_100850 = (state_100852[(2)]);
var state_100852__$1 = state_100852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100852__$1,inst_100850);
} else {
if((state_val_100853 === (12))){
var inst_100812 = (state_100852[(7)]);
var inst_100840 = cljs.core.vec(inst_100812);
var state_100852__$1 = state_100852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100852__$1,(15),out,inst_100840);
} else {
if((state_val_100853 === (2))){
var state_100852__$1 = state_100852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100852__$1,(4),ch);
} else {
if((state_val_100853 === (11))){
var inst_100820 = (state_100852[(10)]);
var inst_100816 = (state_100852[(9)]);
var inst_100830 = (state_100852[(2)]);
var inst_100831 = [];
var inst_100832 = inst_100831.push(inst_100816);
var inst_100812 = inst_100831;
var inst_100813 = inst_100820;
var state_100852__$1 = (function (){var statearr_100864 = state_100852;
(statearr_100864[(11)] = inst_100830);

(statearr_100864[(12)] = inst_100832);

(statearr_100864[(7)] = inst_100812);

(statearr_100864[(8)] = inst_100813);

return statearr_100864;
})();
var statearr_100865_100889 = state_100852__$1;
(statearr_100865_100889[(2)] = null);

(statearr_100865_100889[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (9))){
var inst_100812 = (state_100852[(7)]);
var inst_100828 = cljs.core.vec(inst_100812);
var state_100852__$1 = state_100852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_100852__$1,(11),out,inst_100828);
} else {
if((state_val_100853 === (5))){
var inst_100820 = (state_100852[(10)]);
var inst_100816 = (state_100852[(9)]);
var inst_100813 = (state_100852[(8)]);
var inst_100820__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_100816) : f.call(null,inst_100816));
var inst_100821 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_100820__$1,inst_100813);
var inst_100822 = cljs.core.keyword_identical_QMARK_(inst_100813,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_100823 = ((inst_100821) || (inst_100822));
var state_100852__$1 = (function (){var statearr_100866 = state_100852;
(statearr_100866[(10)] = inst_100820__$1);

return statearr_100866;
})();
if(cljs.core.truth_(inst_100823)){
var statearr_100867_100890 = state_100852__$1;
(statearr_100867_100890[(1)] = (8));

} else {
var statearr_100868_100891 = state_100852__$1;
(statearr_100868_100891[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (14))){
var inst_100845 = (state_100852[(2)]);
var inst_100846 = cljs.core.async.close_BANG_(out);
var state_100852__$1 = (function (){var statearr_100870 = state_100852;
(statearr_100870[(13)] = inst_100845);

return statearr_100870;
})();
var statearr_100871_100892 = state_100852__$1;
(statearr_100871_100892[(2)] = inst_100846);

(statearr_100871_100892[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (10))){
var inst_100835 = (state_100852[(2)]);
var state_100852__$1 = state_100852;
var statearr_100872_100893 = state_100852__$1;
(statearr_100872_100893[(2)] = inst_100835);

(statearr_100872_100893[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100853 === (8))){
var inst_100820 = (state_100852[(10)]);
var inst_100816 = (state_100852[(9)]);
var inst_100812 = (state_100852[(7)]);
var inst_100825 = inst_100812.push(inst_100816);
var tmp100869 = inst_100812;
var inst_100812__$1 = tmp100869;
var inst_100813 = inst_100820;
var state_100852__$1 = (function (){var statearr_100873 = state_100852;
(statearr_100873[(7)] = inst_100812__$1);

(statearr_100873[(14)] = inst_100825);

(statearr_100873[(8)] = inst_100813);

return statearr_100873;
})();
var statearr_100874_100894 = state_100852__$1;
(statearr_100874_100894[(2)] = null);

(statearr_100874_100894[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__98972__auto___100880,out))
;
return ((function (switch__98865__auto__,c__98972__auto___100880,out){
return (function() {
var cljs$core$async$state_machine__98866__auto__ = null;
var cljs$core$async$state_machine__98866__auto____0 = (function (){
var statearr_100875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100875[(0)] = cljs$core$async$state_machine__98866__auto__);

(statearr_100875[(1)] = (1));

return statearr_100875;
});
var cljs$core$async$state_machine__98866__auto____1 = (function (state_100852){
while(true){
var ret_value__98867__auto__ = (function (){try{while(true){
var result__98868__auto__ = switch__98865__auto__(state_100852);
if(cljs.core.keyword_identical_QMARK_(result__98868__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__98868__auto__;
}
break;
}
}catch (e100876){if((e100876 instanceof Object)){
var ex__98869__auto__ = e100876;
var statearr_100877_100895 = state_100852;
(statearr_100877_100895[(5)] = ex__98869__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100852);

return cljs.core.cst$kw$recur;
} else {
throw e100876;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__98867__auto__,cljs.core.cst$kw$recur)){
var G__100896 = state_100852;
state_100852 = G__100896;
continue;
} else {
return ret_value__98867__auto__;
}
break;
}
});
cljs$core$async$state_machine__98866__auto__ = function(state_100852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__98866__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__98866__auto____1.call(this,state_100852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__98866__auto____0;
cljs$core$async$state_machine__98866__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__98866__auto____1;
return cljs$core$async$state_machine__98866__auto__;
})()
;})(switch__98865__auto__,c__98972__auto___100880,out))
})();
var state__98974__auto__ = (function (){var statearr_100878 = (f__98973__auto__.cljs$core$IFn$_invoke$arity$0 ? f__98973__auto__.cljs$core$IFn$_invoke$arity$0() : f__98973__auto__.call(null));
(statearr_100878[(6)] = c__98972__auto___100880);

return statearr_100878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__98974__auto__);
});})(c__98972__auto___100880,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1593111282965
