// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113490 = arguments.length;
var i__4731__auto___113491 = (0);
while(true){
if((i__4731__auto___113491 < len__4730__auto___113490)){
args__4736__auto__.push((arguments[i__4731__auto___113491]));

var G__113492 = (i__4731__auto___113491 + (1));
i__4731__auto___113491 = G__113492;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
});

fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq113487){
var G__113488 = cljs.core.first(seq113487);
var seq113487__$1 = cljs.core.next(seq113487);
var G__113489 = cljs.core.first(seq113487__$1);
var seq113487__$2 = cljs.core.next(seq113487__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__113488,G__113489,seq113487__$2);
});

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e113493){if((e113493 instanceof java.lang.Exception)){
var e = e113493;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
} else {
throw e113493;

}
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e113494){if((e113494 instanceof java.lang.Exception)){
var e = e113494;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e113494;

}
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e113495){if((e113495 instanceof java.lang.Exception)){
var e = e113495;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e113495;

}
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e113496){if((e113496 instanceof java.lang.Exception)){
var e = e113496;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e113496;

}
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e113497){if((e113497 instanceof java.lang.Exception)){
var e = e113497;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
} else {
throw e113497;

}
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113500 = arguments.length;
var i__4731__auto___113501 = (0);
while(true){
if((i__4731__auto___113501 < len__4730__auto___113500)){
args__4736__auto__.push((arguments[i__4731__auto___113501]));

var G__113502 = (i__4731__auto___113501 + (1));
i__4731__auto___113501 = G__113502;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e113499){if((e113499 instanceof java.lang.Exception)){
var e = e113499;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113499;

}
}});

fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq113498){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113498));
});

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113505 = arguments.length;
var i__4731__auto___113506 = (0);
while(true){
if((i__4731__auto___113506 < len__4730__auto___113505)){
args__4736__auto__.push((arguments[i__4731__auto___113506]));

var G__113507 = (i__4731__auto___113506 + (1));
i__4731__auto___113506 = G__113507;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e113504){if((e113504 instanceof java.lang.Exception)){
var e = e113504;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113504;

}
}});

fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq113503){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113503));
});

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e113508){if((e113508 instanceof java.lang.Exception)){
var e = e113508;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
} else {
throw e113508;

}
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113511 = arguments.length;
var i__4731__auto___113512 = (0);
while(true){
if((i__4731__auto___113512 < len__4730__auto___113511)){
args__4736__auto__.push((arguments[i__4731__auto___113512]));

var G__113513 = (i__4731__auto___113512 + (1));
i__4731__auto___113512 = G__113513;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e113510){if((e113510 instanceof java.lang.Exception)){
var e = e113510;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113510;

}
}});

fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq113509){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113509));
});

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e113514){if((e113514 instanceof java.lang.Exception)){
var e = e113514;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
} else {
throw e113514;

}
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e113515){if((e113515 instanceof java.lang.Exception)){
var e = e113515;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
} else {
throw e113515;

}
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113518 = arguments.length;
var i__4731__auto___113519 = (0);
while(true){
if((i__4731__auto___113519 < len__4730__auto___113518)){
args__4736__auto__.push((arguments[i__4731__auto___113519]));

var G__113520 = (i__4731__auto___113519 + (1));
i__4731__auto___113519 = G__113520;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e113517){if((e113517 instanceof java.lang.Exception)){
var e = e113517;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113517;

}
}});

fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq113516){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113516));
});

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113523 = arguments.length;
var i__4731__auto___113524 = (0);
while(true){
if((i__4731__auto___113524 < len__4730__auto___113523)){
args__4736__auto__.push((arguments[i__4731__auto___113524]));

var G__113525 = (i__4731__auto___113524 + (1));
i__4731__auto___113524 = G__113525;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e113522){if((e113522 instanceof java.lang.Exception)){
var e = e113522;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113522;

}
}});

fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq113521){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113521));
});

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113528 = arguments.length;
var i__4731__auto___113529 = (0);
while(true){
if((i__4731__auto___113529 < len__4730__auto___113528)){
args__4736__auto__.push((arguments[i__4731__auto___113529]));

var G__113530 = (i__4731__auto___113529 + (1));
i__4731__auto___113529 = G__113530;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e113527){if((e113527 instanceof java.lang.Exception)){
var e = e113527;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113527;

}
}});

fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq113526){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113526));
});

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113533 = arguments.length;
var i__4731__auto___113534 = (0);
while(true){
if((i__4731__auto___113534 < len__4730__auto___113533)){
args__4736__auto__.push((arguments[i__4731__auto___113534]));

var G__113535 = (i__4731__auto___113534 + (1));
i__4731__auto___113534 = G__113535;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e113532){if((e113532 instanceof java.lang.Exception)){
var e = e113532;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113532;

}
}});

fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq113531){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113531));
});

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113538 = arguments.length;
var i__4731__auto___113539 = (0);
while(true){
if((i__4731__auto___113539 < len__4730__auto___113538)){
args__4736__auto__.push((arguments[i__4731__auto___113539]));

var G__113540 = (i__4731__auto___113539 + (1));
i__4731__auto___113539 = G__113540;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e113537){if((e113537 instanceof java.lang.Exception)){
var e = e113537;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113537;

}
}});

fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq113536){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113536));
});

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113543 = arguments.length;
var i__4731__auto___113544 = (0);
while(true){
if((i__4731__auto___113544 < len__4730__auto___113543)){
args__4736__auto__.push((arguments[i__4731__auto___113544]));

var G__113545 = (i__4731__auto___113544 + (1));
i__4731__auto___113544 = G__113545;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e113542){if((e113542 instanceof java.lang.Exception)){
var e = e113542;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113542;

}
}});

fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq113541){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113541));
});

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__113547 = arguments.length;
switch (G__113547) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113572){
var state_val_113573 = (state_113572[(1)]);
if((state_val_113573 === (1))){
var state_113572__$1 = state_113572;
var statearr_113574_113652 = state_113572__$1;
(statearr_113574_113652[(2)] = null);

(statearr_113574_113652[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113573 === (2))){
var inst_113570 = (state_113572[(2)]);
var state_113572__$1 = state_113572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113572__$1,inst_113570);
} else {
if((state_val_113573 === (3))){
var inst_113548 = (state_113572[(2)]);
var state_113572__$1 = state_113572;
var statearr_113575_113653 = state_113572__$1;
(statearr_113575_113653[(2)] = inst_113548);


cljs.core.async.impl.ioc_helpers.process_exception(state_113572__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113573 === (4))){
var inst_113552 = (state_113572[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113572,(3),Error,null,(2));
var inst_113552__$1 = cljs.core.volatile_BANG_((0));
var inst_113553 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_113554 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_113553,cljs.core.cst$kw$fuel,inst_113552__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_113555 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_113554);
var inst_113556 = fluree.db.query.fql.query(db,inst_113555);
var state_113572__$1 = (function (){var statearr_113576 = state_113572;
(statearr_113576[(7)] = inst_113552__$1);

return statearr_113576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113572__$1,(5),inst_113556);
} else {
if((state_val_113573 === (5))){
var inst_113558 = (state_113572[(8)]);
var inst_113558__$1 = (state_113572[(2)]);
var inst_113559 = fluree.db.util.core.exception_QMARK_(inst_113558__$1);
var state_113572__$1 = (function (){var statearr_113577 = state_113572;
(statearr_113577[(8)] = inst_113558__$1);

return statearr_113577;
})();
if(inst_113559){
var statearr_113578_113654 = state_113572__$1;
(statearr_113578_113654[(1)] = (6));

} else {
var statearr_113579_113655 = state_113572__$1;
(statearr_113579_113655[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113573 === (6))){
var inst_113558 = (state_113572[(8)]);
var inst_113561 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_113558,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_113572__$1 = state_113572;
var statearr_113580_113656 = state_113572__$1;
(statearr_113580_113656[(2)] = inst_113561);

(statearr_113580_113656[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113573 === (7))){
var inst_113558 = (state_113572[(8)]);
var inst_113552 = (state_113572[(7)]);
var inst_113563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113564 = cljs.core.deref(inst_113552);
var inst_113565 = [inst_113558,inst_113564];
var inst_113566 = (new cljs.core.PersistentVector(null,2,(5),inst_113563,inst_113565,null));
var state_113572__$1 = state_113572;
var statearr_113581_113657 = state_113572__$1;
(statearr_113581_113657[(2)] = inst_113566);

(statearr_113581_113657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113573 === (8))){
var inst_113568 = (state_113572[(2)]);
var state_113572__$1 = state_113572;
var statearr_113582_113658 = state_113572__$1;
(statearr_113582_113658[(2)] = inst_113568);


cljs.core.async.impl.ioc_helpers.process_exception(state_113572__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99037__auto____0 = (function (){
var statearr_113583 = [null,null,null,null,null,null,null,null,null];
(statearr_113583[(0)] = fluree$db$dbfunctions$internal$state_machine__99037__auto__);

(statearr_113583[(1)] = (1));

return statearr_113583;
});
var fluree$db$dbfunctions$internal$state_machine__99037__auto____1 = (function (state_113572){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113572);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113584){if((e113584 instanceof Object)){
var ex__99040__auto__ = e113584;
var statearr_113585_113659 = state_113572;
(statearr_113585_113659[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113572);

return cljs.core.cst$kw$recur;
} else {
throw e113584;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113660 = state_113572;
state_113572 = G__113660;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99037__auto__ = function(state_113572){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____1.call(this,state_113572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113586 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113586[(6)] = c__99059__auto__);

return statearr_113586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113631){
var state_val_113632 = (state_113631[(1)]);
if((state_val_113632 === (7))){
var inst_113617 = (state_113631[(2)]);
var inst_113618 = fluree.db.query.fql.query(db,inst_113617);
var state_113631__$1 = state_113631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113631__$1,(8),inst_113618);
} else {
if((state_val_113632 === (1))){
var inst_113587 = typeof select === 'string';
var state_113631__$1 = state_113631;
if(cljs.core.truth_(inst_113587)){
var statearr_113633_113661 = state_113631__$1;
(statearr_113633_113661[(1)] = (2));

} else {
var statearr_113634_113662 = state_113631__$1;
(statearr_113634_113662[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (4))){
var inst_113600 = (state_113631[(7)]);
var inst_113593 = (state_113631[(8)]);
var inst_113592 = (state_113631[(2)]);
var inst_113593__$1 = cljs.core.volatile_BANG_((0));
var inst_113594 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_113595 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_113596 = [inst_113593__$1,(100000)];
var inst_113597 = cljs.core.PersistentHashMap.fromArrays(inst_113595,inst_113596);
var inst_113598 = [inst_113592,from,where,block,limit,inst_113597];
var inst_113599 = cljs.core.PersistentHashMap.fromArrays(inst_113594,inst_113598);
var inst_113600__$1 = fluree.db.util.core.without_nils(inst_113599);
var inst_113601 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_113600__$1);
var inst_113602 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_113600__$1);
var inst_113603 = cljs.core.first(inst_113602);
var inst_113604 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113603], 0));
var inst_113605 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_113604);
var inst_113606 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_113600__$1);
var inst_113607 = cljs.core.last(inst_113606);
var inst_113608 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113607], 0));
var inst_113609 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_113608);
var inst_113610 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113601,inst_113605,inst_113609], 0));
var state_113631__$1 = (function (){var statearr_113635 = state_113631;
(statearr_113635[(7)] = inst_113600__$1);

(statearr_113635[(8)] = inst_113593__$1);

return statearr_113635;
})();
if(cljs.core.truth_(inst_113610)){
var statearr_113636_113663 = state_113631__$1;
(statearr_113636_113663[(1)] = (5));

} else {
var statearr_113637_113664 = state_113631__$1;
(statearr_113637_113664[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (6))){
var inst_113600 = (state_113631[(7)]);
var state_113631__$1 = state_113631;
var statearr_113638_113665 = state_113631__$1;
(statearr_113638_113665[(2)] = inst_113600);

(statearr_113638_113665[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (3))){
var state_113631__$1 = state_113631;
var statearr_113639_113666 = state_113631__$1;
(statearr_113639_113666[(2)] = select);

(statearr_113639_113666[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (2))){
var inst_113589 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_113631__$1 = state_113631;
var statearr_113640_113667 = state_113631__$1;
(statearr_113640_113667[(2)] = inst_113589);

(statearr_113640_113667[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (11))){
var inst_113629 = (state_113631[(2)]);
var state_113631__$1 = state_113631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113631__$1,inst_113629);
} else {
if((state_val_113632 === (9))){
var inst_113620 = (state_113631[(9)]);
var state_113631__$1 = state_113631;
var statearr_113641_113668 = state_113631__$1;
(statearr_113641_113668[(2)] = inst_113620);

(statearr_113641_113668[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (5))){
var inst_113600 = (state_113631[(7)]);
var inst_113612 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_113600);
var inst_113613 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_113612);
var inst_113614 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_113600,cljs.core.cst$kw$where,inst_113613);
var state_113631__$1 = state_113631;
var statearr_113642_113669 = state_113631__$1;
(statearr_113642_113669[(2)] = inst_113614);

(statearr_113642_113669[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (10))){
var inst_113593 = (state_113631[(8)]);
var inst_113620 = (state_113631[(9)]);
var inst_113624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113625 = cljs.core.deref(inst_113593);
var inst_113626 = [inst_113620,inst_113625];
var inst_113627 = (new cljs.core.PersistentVector(null,2,(5),inst_113624,inst_113626,null));
var state_113631__$1 = state_113631;
var statearr_113643_113670 = state_113631__$1;
(statearr_113643_113670[(2)] = inst_113627);

(statearr_113643_113670[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113632 === (8))){
var inst_113620 = (state_113631[(9)]);
var inst_113620__$1 = (state_113631[(2)]);
var inst_113621 = fluree.db.util.core.exception_QMARK_(inst_113620__$1);
var state_113631__$1 = (function (){var statearr_113644 = state_113631;
(statearr_113644[(9)] = inst_113620__$1);

return statearr_113644;
})();
if(inst_113621){
var statearr_113645_113671 = state_113631__$1;
(statearr_113645_113671[(1)] = (9));

} else {
var statearr_113646_113672 = state_113631__$1;
(statearr_113646_113672[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99037__auto____0 = (function (){
var statearr_113647 = [null,null,null,null,null,null,null,null,null,null];
(statearr_113647[(0)] = fluree$db$dbfunctions$internal$state_machine__99037__auto__);

(statearr_113647[(1)] = (1));

return statearr_113647;
});
var fluree$db$dbfunctions$internal$state_machine__99037__auto____1 = (function (state_113631){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113631);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113648){if((e113648 instanceof Object)){
var ex__99040__auto__ = e113648;
var statearr_113649_113673 = state_113631;
(statearr_113649_113673[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113631);

return cljs.core.cst$kw$recur;
} else {
throw e113648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113674 = state_113631;
state_113631 = G__113674;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99037__auto__ = function(state_113631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____1.call(this,state_113631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113650 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113650[(6)] = c__99059__auto__);

return statearr_113650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6;

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__113675 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(var$,/\//);
var coll = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113675,(0),null);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113675,(1),null);
var pred__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(pred,(1));
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,"/",pred__$1], 0));
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__113681 = path;
var vec__113682 = G__113681;
var seq__113683 = cljs.core.seq(vec__113682);
var first__113684 = cljs.core.first(seq__113683);
var seq__113683__$1 = cljs.core.next(seq__113683);
var var$ = first__113684;
var r = seq__113683__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__113681__$1 = G__113681;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__113688 = G__113681__$1;
var seq__113689 = cljs.core.seq(vec__113688);
var first__113690 = cljs.core.first(seq__113689);
var seq__113689__$1 = cljs.core.next(seq__113689);
var var$__$1 = first__113690;
var r__$1 = seq__113689__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__113691 = r__$1;
var G__113692 = n__$2;
var G__113693 = next_clauses;
G__113681__$1 = G__113691;
n__$1 = G__113692;
where_clauses__$1 = G__113693;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__113694 = r__$1;
var G__113695 = next_n;
var G__113696 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__113681__$1 = G__113694;
n__$1 = G__113695;
where_clauses__$1 = G__113696;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113727){
var state_val_113728 = (state_113727[(1)]);
if((state_val_113728 === (7))){
var inst_113708 = (state_113727[(7)]);
var inst_113708__$1 = (state_113727[(2)]);
var inst_113709 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_113708__$1,endSubject);
var inst_113710 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_113711 = ["?var1",inst_113709];
var inst_113712 = cljs.core.PersistentHashMap.fromArrays(inst_113710,inst_113711);
var state_113727__$1 = (function (){var statearr_113729 = state_113727;
(statearr_113729[(8)] = inst_113712);

(statearr_113729[(7)] = inst_113708__$1);

return statearr_113729;
})();
var statearr_113730_113744 = state_113727__$1;
(statearr_113730_113744[(2)] = null);

(statearr_113730_113744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (1))){
var state_113727__$1 = state_113727;
var statearr_113731_113745 = state_113727__$1;
(statearr_113731_113745[(2)] = null);

(statearr_113731_113745[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113727,(3),Error,null,(2));
var inst_113701 = cljs.core.vector_QMARK_(path);
var state_113727__$1 = state_113727;
if(inst_113701){
var statearr_113732_113746 = state_113727__$1;
(statearr_113732_113746[(1)] = (5));

} else {
var statearr_113733_113747 = state_113727__$1;
(statearr_113733_113747[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (6))){
var inst_113704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113705 = [path];
var inst_113706 = (new cljs.core.PersistentVector(null,1,(5),inst_113704,inst_113705,null));
var state_113727__$1 = state_113727;
var statearr_113734_113748 = state_113727__$1;
(statearr_113734_113748[(2)] = inst_113706);

(statearr_113734_113748[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (3))){
var inst_113697 = (state_113727[(2)]);
var state_113727__$1 = state_113727;
var statearr_113735_113749 = state_113727__$1;
(statearr_113735_113749[(2)] = inst_113697);


cljs.core.async.impl.ioc_helpers.process_exception(state_113727__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (2))){
var inst_113725 = (state_113727[(2)]);
var state_113727__$1 = state_113727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113727__$1,inst_113725);
} else {
if((state_val_113728 === (11))){
var inst_113720 = (state_113727[(2)]);
var inst_113721 = fluree.db.util.async.throw_err(inst_113720);
var state_113727__$1 = state_113727;
var statearr_113736_113750 = state_113727__$1;
(statearr_113736_113750[(2)] = inst_113721);


cljs.core.async.impl.ioc_helpers.process_exception(state_113727__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (9))){
var inst_113708 = (state_113727[(7)]);
var inst_113713 = (state_113727[(2)]);
var inst_113714 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_113713,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_113708,endSubject], 0));
var state_113727__$1 = state_113727;
var statearr_113737_113751 = state_113727__$1;
(statearr_113737_113751[(2)] = inst_113714);


cljs.core.async.impl.ioc_helpers.process_exception(state_113727__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (5))){
var state_113727__$1 = state_113727;
var statearr_113738_113752 = state_113727__$1;
(statearr_113738_113752[(2)] = path);

(statearr_113738_113752[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113728 === (10))){
var inst_113712 = (state_113727[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113727,(9),java.lang.Exception,null,(8));
var inst_113718 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_113712);
var state_113727__$1 = state_113727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113727__$1,(11),inst_113718);
} else {
if((state_val_113728 === (8))){
var inst_113723 = (state_113727[(2)]);
var state_113727__$1 = state_113727;
var statearr_113739_113753 = state_113727__$1;
(statearr_113739_113753[(2)] = inst_113723);


cljs.core.async.impl.ioc_helpers.process_exception(state_113727__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_113740 = [null,null,null,null,null,null,null,null,null];
(statearr_113740[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__);

(statearr_113740[(1)] = (1));

return statearr_113740;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____1 = (function (state_113727){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113727);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113741){if((e113741 instanceof Object)){
var ex__99040__auto__ = e113741;
var statearr_113742_113754 = state_113727;
(statearr_113742_113754[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113727);

return cljs.core.cst$kw$recur;
} else {
throw e113741;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113755 = state_113727;
state_113727 = G__113755;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__ = function(state_113727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____1.call(this,state_113727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113743 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113743[(6)] = c__99059__auto__);

return statearr_113743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e113756){if((e113756 instanceof java.lang.Exception)){
var e = e113756;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
} else {
throw e113756;

}
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e113757){if((e113757 instanceof java.lang.Exception)){
var e = e113757;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
} else {
throw e113757;

}
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e113758){if((e113758 instanceof java.lang.Exception)){
var e = e113758;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
} else {
throw e113758;

}
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e113759){if((e113759 instanceof java.lang.Exception)){
var e = e113759;
return fluree.db.dbfunctions.internal.function_error(e,"now");
} else {
throw e113759;

}
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113762 = arguments.length;
var i__4731__auto___113763 = (0);
while(true){
if((i__4731__auto___113763 < len__4730__auto___113762)){
args__4736__auto__.push((arguments[i__4731__auto___113763]));

var G__113764 = (i__4731__auto___113763 + (1));
i__4731__auto___113763 = G__113764;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e113761){if((e113761 instanceof java.lang.Exception)){
var e = e113761;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113761;

}
}});

fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq113760){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113760));
});

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113767 = arguments.length;
var i__4731__auto___113768 = (0);
while(true){
if((i__4731__auto___113768 < len__4730__auto___113767)){
args__4736__auto__.push((arguments[i__4731__auto___113768]));

var G__113769 = (i__4731__auto___113768 + (1));
i__4731__auto___113768 = G__113769;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e113766){if((e113766 instanceof java.lang.Exception)){
var e = e113766;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113766;

}
}});

fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq113765){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113765));
});

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113772 = arguments.length;
var i__4731__auto___113773 = (0);
while(true){
if((i__4731__auto___113773 < len__4730__auto___113772)){
args__4736__auto__.push((arguments[i__4731__auto___113773]));

var G__113774 = (i__4731__auto___113773 + (1));
i__4731__auto___113773 = G__113774;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4131__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e113771){if((e113771 instanceof java.lang.Exception)){
var e = e113771;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113771;

}
}});

fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq113770){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113770));
});

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113777 = arguments.length;
var i__4731__auto___113778 = (0);
while(true){
if((i__4731__auto___113778 < len__4730__auto___113777)){
args__4736__auto__.push((arguments[i__4731__auto___113778]));

var G__113779 = (i__4731__auto___113778 + (1));
i__4731__auto___113778 = G__113779;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e113776){if((e113776 instanceof java.lang.Exception)){
var e = e113776;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113776;

}
}});

fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq113775){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113775));
});

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e113780){if((e113780 instanceof java.lang.Exception)){
var e = e113780;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e113780;

}
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e113781){if((e113781 instanceof java.lang.Exception)){
var e = e113781;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e113781;

}
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e113782){if((e113782 instanceof java.lang.Exception)){
var e = e113782;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e113782;

}
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e113783){if((e113783 instanceof java.lang.Exception)){
var e = e113783;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
} else {
throw e113783;

}
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e113784){if((e113784 instanceof java.lang.Exception)){
var e = e113784;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
} else {
throw e113784;

}
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__113790 = path;
var vec__113791 = G__113790;
var seq__113792 = cljs.core.seq(vec__113791);
var first__113793 = cljs.core.first(seq__113792);
var seq__113792__$1 = cljs.core.next(seq__113792);
var pred = first__113793;
var r = seq__113792__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__113790__$1 = G__113790;
var subjects__$1 = subjects;
while(true){
var vec__113797 = G__113790__$1;
var seq__113798 = cljs.core.seq(vec__113797);
var first__113799 = cljs.core.first(seq__113798);
var seq__113798__$1 = cljs.core.next(seq__113798);
var pred__$1 = first__113799;
var r__$1 = seq__113798__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__113790__$1,subjects__$1,vec__113797,seq__113798,first__113799,seq__113798__$1,pred__$1,r__$1,subjects__$2,G__113790,vec__113791,seq__113792,first__113793,seq__113792__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__113790__$1,subjects__$1,vec__113797,seq__113798,first__113799,seq__113798__$1,pred__$1,r__$1,subjects__$2,G__113790,vec__113791,seq__113792,first__113793,seq__113792__$1,pred,r,subjects){
return (function (p1__113785_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__113785_SHARP_,pred__$1);
});})(G__113790__$1,subjects__$1,vec__113797,seq__113798,first__113799,seq__113798__$1,pred__$1,r__$1,subjects__$2,G__113790,vec__113791,seq__113792,first__113793,seq__113792__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__113790__$1,subjects__$1,vec__113797,seq__113798,first__113799,seq__113798__$1,pred__$1,r__$1,subjects__$2,G__113790,vec__113791,seq__113792,first__113793,seq__113792__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4120__auto__ = r__$1;
if(and__4120__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4120__auto__;
}
})())){
var G__113800 = r__$1;
var G__113801 = next_subjects;
G__113790__$1 = G__113800;
subjects__$1 = G__113801;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e113786){if((e113786 instanceof java.lang.Exception)){
var e = e113786;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
} else {
throw e113786;

}
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e113802){if((e113802 instanceof java.lang.Exception)){
var e = e113802;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
} else {
throw e113802;

}
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e113803){if((e113803 instanceof java.lang.Exception)){
var e = e113803;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
} else {
throw e113803;

}
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113806 = arguments.length;
var i__4731__auto___113807 = (0);
while(true){
if((i__4731__auto___113807 < len__4730__auto___113806)){
args__4736__auto__.push((arguments[i__4731__auto___113807]));

var G__113808 = (i__4731__auto___113807 + (1));
i__4731__auto___113807 = G__113808;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e113805){if((e113805 instanceof java.lang.Exception)){
var e = e113805;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113805;

}
}});

fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq113804){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113804));
});

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e113809){if((e113809 instanceof java.lang.Exception)){
var e = e113809;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
} else {
throw e113809;

}
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___113812 = arguments.length;
var i__4731__auto___113813 = (0);
while(true){
if((i__4731__auto___113813 < len__4730__auto___113812)){
args__4736__auto__.push((arguments[i__4731__auto___113813]));

var G__113814 = (i__4731__auto___113813 + (1));
i__4731__auto___113813 = G__113814;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e113811){if((e113811 instanceof java.lang.Exception)){
var e = e113811;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e113811;

}
}});

fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq113810){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq113810));
});

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e113815){if((e113815 instanceof java.lang.Exception)){
var e = e113815;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
} else {
throw e113815;

}
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113864){
var state_val_113865 = (state_113864[(1)]);
if((state_val_113865 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113864,(3),java.lang.Exception,null,(2));
var inst_113827 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_113828 = typeof inst_113827 === 'string';
var state_113864__$1 = state_113864;
if(cljs.core.truth_(inst_113828)){
var statearr_113866_113886 = state_113864__$1;
(statearr_113866_113886[(1)] = (8));

} else {
var statearr_113867_113887 = state_113864__$1;
(statearr_113867_113887[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (1))){
var state_113864__$1 = state_113864;
var statearr_113868_113888 = state_113864__$1;
(statearr_113868_113888[(2)] = null);

(statearr_113868_113888[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (4))){
var inst_113823 = (state_113864[(2)]);
var state_113864__$1 = state_113864;
var statearr_113869_113889 = state_113864__$1;
(statearr_113869_113889[(2)] = inst_113823);


cljs.core.async.impl.ioc_helpers.process_exception(state_113864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (13))){
var inst_113849 = (state_113864[(7)]);
var inst_113853 = inst_113849.o;
var state_113864__$1 = state_113864;
var statearr_113870_113890 = state_113864__$1;
(statearr_113870_113890[(2)] = inst_113853);

(statearr_113870_113890[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (6))){
var inst_113816 = (state_113864[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113864,(5),java.lang.Exception,null,(4));
var inst_113821 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_113816,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_113864__$1 = state_113864;
var statearr_113871_113891 = state_113864__$1;
(statearr_113871_113891[(2)] = inst_113821);


cljs.core.async.impl.ioc_helpers.process_exception(state_113864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (3))){
var inst_113816 = (state_113864[(2)]);
var state_113864__$1 = (function (){var statearr_113872 = state_113864;
(statearr_113872[(8)] = inst_113816);

return statearr_113872;
})();
var statearr_113873_113892 = state_113864__$1;
(statearr_113873_113892[(2)] = null);

(statearr_113873_113892[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (12))){
var state_113864__$1 = state_113864;
var statearr_113874_113893 = state_113864__$1;
(statearr_113874_113893[(2)] = null);

(statearr_113874_113893[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (2))){
var inst_113862 = (state_113864[(2)]);
var state_113864__$1 = state_113864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113864__$1,inst_113862);
} else {
if((state_val_113865 === (11))){
var inst_113849 = (state_113864[(7)]);
var inst_113845 = (state_113864[(2)]);
var inst_113846 = fluree.db.util.async.throw_err(inst_113845);
var inst_113847 = fluree.db.dbfunctions.internal.count(inst_113846);
var inst_113849__$1 = cljs.core.first(inst_113846);
var inst_113850 = (inst_113849__$1 == null);
var state_113864__$1 = (function (){var statearr_113875 = state_113864;
(statearr_113875[(9)] = inst_113847);

(statearr_113875[(7)] = inst_113849__$1);

return statearr_113875;
})();
if(cljs.core.truth_(inst_113850)){
var statearr_113876_113894 = state_113864__$1;
(statearr_113876_113894[(1)] = (12));

} else {
var statearr_113877_113895 = state_113864__$1;
(statearr_113877_113895[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (9))){
var inst_113834 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_113835 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_113834);
var inst_113836 = fluree.db.dbfunctions.internal.inc(inst_113835);
var inst_113837 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_113834,cljs.core.cst$kw$t,inst_113836);
var inst_113838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113839 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_113840 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_113841 = [inst_113839,inst_113840];
var inst_113842 = (new cljs.core.PersistentVector(null,2,(5),inst_113838,inst_113841,null));
var inst_113843 = fluree.db.dbproto._search(inst_113837,inst_113842);
var state_113864__$1 = state_113864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113864__$1,(11),inst_113843);
} else {
if((state_val_113865 === (5))){
var inst_113817 = (state_113864[(2)]);
var state_113864__$1 = state_113864;
var statearr_113878_113896 = state_113864__$1;
(statearr_113878_113896[(2)] = inst_113817);


cljs.core.async.impl.ioc_helpers.process_exception(state_113864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (14))){
var inst_113847 = (state_113864[(9)]);
var inst_113855 = (state_113864[(2)]);
var inst_113856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113857 = [inst_113855,inst_113847];
var inst_113858 = (new cljs.core.PersistentVector(null,2,(5),inst_113856,inst_113857,null));
var state_113864__$1 = state_113864;
var statearr_113879_113897 = state_113864__$1;
(statearr_113879_113897[(2)] = inst_113858);

(statearr_113879_113897[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (10))){
var inst_113860 = (state_113864[(2)]);
var state_113864__$1 = state_113864;
var statearr_113880_113898 = state_113864__$1;
(statearr_113880_113898[(2)] = inst_113860);


cljs.core.async.impl.ioc_helpers.process_exception(state_113864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113865 === (8))){
var inst_113830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113831 = [null,(0)];
var inst_113832 = (new cljs.core.PersistentVector(null,2,(5),inst_113830,inst_113831,null));
var state_113864__$1 = state_113864;
var statearr_113881_113899 = state_113864__$1;
(statearr_113881_113899[(2)] = inst_113832);

(statearr_113881_113899[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____0 = (function (){
var statearr_113882 = [null,null,null,null,null,null,null,null,null,null];
(statearr_113882[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__);

(statearr_113882[(1)] = (1));

return statearr_113882;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____1 = (function (state_113864){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113864);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113883){if((e113883 instanceof Object)){
var ex__99040__auto__ = e113883;
var statearr_113884_113900 = state_113864;
(statearr_113884_113900[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113864);

return cljs.core.cst$kw$recur;
} else {
throw e113883;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113901 = state_113864;
state_113864 = G__113901;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__ = function(state_113864){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____1.call(this,state_113864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113885 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113885[(6)] = c__99059__auto__);

return statearr_113885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113947){
var state_val_113948 = (state_113947[(1)]);
if((state_val_113948 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113947,(3),java.lang.Exception,null,(2));
var inst_113916 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_113917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113919 = [null,pred_name,"?o"];
var inst_113920 = (new cljs.core.PersistentVector(null,3,(5),inst_113918,inst_113919,null));
var inst_113921 = [inst_113920];
var inst_113922 = (new cljs.core.PersistentVector(null,1,(5),inst_113917,inst_113921,null));
var inst_113923 = ["?o",inst_113922,opts];
var inst_113924 = cljs.core.PersistentHashMap.fromArrays(inst_113916,inst_113923);
var inst_113925 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_113924);
var state_113947__$1 = state_113947;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113947__$1,(8),inst_113925);
} else {
if((state_val_113948 === (1))){
var state_113947__$1 = state_113947;
var statearr_113949_113965 = state_113947__$1;
(statearr_113949_113965[(2)] = null);

(statearr_113949_113965[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (4))){
var inst_113909 = (state_113947[(2)]);
var state_113947__$1 = state_113947;
var statearr_113950_113966 = state_113947__$1;
(statearr_113950_113966[(2)] = inst_113909);


cljs.core.async.impl.ioc_helpers.process_exception(state_113947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (6))){
var inst_113902 = (state_113947[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113947,(5),java.lang.Exception,null,(4));
var inst_113907 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_113902,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var state_113947__$1 = state_113947;
var statearr_113951_113967 = state_113947__$1;
(statearr_113951_113967[(2)] = inst_113907);


cljs.core.async.impl.ioc_helpers.process_exception(state_113947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (3))){
var inst_113902 = (state_113947[(2)]);
var state_113947__$1 = (function (){var statearr_113952 = state_113947;
(statearr_113952[(7)] = inst_113902);

return statearr_113952;
})();
var statearr_113953_113968 = state_113947__$1;
(statearr_113953_113968[(2)] = null);

(statearr_113953_113968[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (2))){
var inst_113945 = (state_113947[(2)]);
var state_113947__$1 = state_113947;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113947__$1,inst_113945);
} else {
if((state_val_113948 === (11))){
var inst_113943 = (state_113947[(2)]);
var state_113947__$1 = state_113947;
var statearr_113954_113969 = state_113947__$1;
(statearr_113954_113969[(2)] = inst_113943);


cljs.core.async.impl.ioc_helpers.process_exception(state_113947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (9))){
var inst_113930 = (state_113947[(8)]);
var inst_113929 = (state_113947[(9)]);
var inst_113934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113935 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_113929);
var inst_113936 = [inst_113935,inst_113930];
var inst_113937 = (new cljs.core.PersistentVector(null,2,(5),inst_113934,inst_113936,null));
var state_113947__$1 = state_113947;
var statearr_113955_113970 = state_113947__$1;
(statearr_113955_113970[(2)] = inst_113937);

(statearr_113955_113970[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (5))){
var inst_113903 = (state_113947[(2)]);
var state_113947__$1 = state_113947;
var statearr_113956_113971 = state_113947__$1;
(statearr_113956_113971[(2)] = inst_113903);


cljs.core.async.impl.ioc_helpers.process_exception(state_113947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (10))){
var inst_113930 = (state_113947[(8)]);
var inst_113939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113940 = [null,inst_113930];
var inst_113941 = (new cljs.core.PersistentVector(null,2,(5),inst_113939,inst_113940,null));
var state_113947__$1 = state_113947;
var statearr_113957_113972 = state_113947__$1;
(statearr_113957_113972[(2)] = inst_113941);

(statearr_113957_113972[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113948 === (8))){
var inst_113929 = (state_113947[(9)]);
var inst_113927 = (state_113947[(2)]);
var inst_113928 = fluree.db.util.async.throw_err(inst_113927);
var inst_113929__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113928,(0),null);
var inst_113930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113928,(1),null);
var inst_113931 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_113929__$1);
var inst_113932 = cljs.core.not(inst_113931);
var state_113947__$1 = (function (){var statearr_113958 = state_113947;
(statearr_113958[(8)] = inst_113930);

(statearr_113958[(9)] = inst_113929__$1);

return statearr_113958;
})();
if(inst_113932){
var statearr_113959_113973 = state_113947__$1;
(statearr_113959_113973[(1)] = (9));

} else {
var statearr_113960_113974 = state_113947__$1;
(statearr_113960_113974[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____0 = (function (){
var statearr_113961 = [null,null,null,null,null,null,null,null,null,null];
(statearr_113961[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__);

(statearr_113961[(1)] = (1));

return statearr_113961;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____1 = (function (state_113947){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113947);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113962){if((e113962 instanceof Object)){
var ex__99040__auto__ = e113962;
var statearr_113963_113975 = state_113947;
(statearr_113963_113975[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113947);

return cljs.core.cst$kw$recur;
} else {
throw e113962;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113976 = state_113947;
state_113947 = G__113976;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__ = function(state_113947){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____1.call(this,state_113947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113964 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113964[(6)] = c__99059__auto__);

return statearr_113964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4120__auto__ = typeof email === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4120__auto__;
}
})());
}catch (e113977){if((e113977 instanceof java.lang.Exception)){
var e = e113977;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
} else {
throw e113977;

}
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__113979 = arguments.length;
switch (G__113979) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114043){
var state_val_114044 = (state_114043[(1)]);
if((state_val_114044 === (7))){
var inst_113991 = (state_114043[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114043,(3),java.lang.Exception,null,(2));
var inst_113991__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_114043__$1 = (function (){var statearr_114045 = state_114043;
(statearr_114045[(7)] = inst_113991__$1);

return statearr_114045;
})();
if(cljs.core.truth_(inst_113991__$1)){
var statearr_114046_114076 = state_114043__$1;
(statearr_114046_114076[(1)] = (8));

} else {
var statearr_114047_114077 = state_114043__$1;
(statearr_114047_114077[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (20))){
var inst_114031 = (state_114043[(2)]);
var inst_114032 = fluree.db.util.async.throw_err(inst_114031);
var inst_114033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114032,(0),null);
var inst_114034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114032,(1),null);
var inst_114035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114036 = [inst_114033,inst_114034];
var inst_114037 = (new cljs.core.PersistentVector(null,2,(5),inst_114035,inst_114036,null));
var state_114043__$1 = state_114043;
var statearr_114048_114078 = state_114043__$1;
(statearr_114048_114078[(2)] = inst_114037);

(statearr_114048_114078[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (1))){
var state_114043__$1 = state_114043;
var statearr_114049_114079 = state_114043__$1;
(statearr_114049_114079[(2)] = null);

(statearr_114049_114079[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (4))){
var inst_113987 = (state_114043[(2)]);
var state_114043__$1 = state_114043;
var statearr_114050_114080 = state_114043__$1;
(statearr_114050_114080[(2)] = inst_113987);


cljs.core.async.impl.ioc_helpers.process_exception(state_114043__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (15))){
var inst_114007 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114008 = fluree.db.dbfunctions.internal.get(inst_114007,cljs.core.cst$kw$_id);
var state_114043__$1 = state_114043;
var statearr_114051_114081 = state_114043__$1;
(statearr_114051_114081[(2)] = inst_114008);

(statearr_114051_114081[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (13))){
var inst_114039 = (state_114043[(2)]);
var state_114043__$1 = state_114043;
var statearr_114052_114082 = state_114043__$1;
(statearr_114052_114082[(2)] = inst_114039);


cljs.core.async.impl.ioc_helpers.process_exception(state_114043__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (6))){
var inst_113980 = (state_114043[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114043,(5),java.lang.Exception,null,(4));
var inst_113985 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_113980,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_114043__$1 = state_114043;
var statearr_114053_114083 = state_114043__$1;
(statearr_114053_114083[(2)] = inst_113985);


cljs.core.async.impl.ioc_helpers.process_exception(state_114043__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (17))){
var inst_114012 = cljs.core.PersistentVector.EMPTY;
var inst_114013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114014 = ["*"];
var inst_114015 = (new cljs.core.PersistentVector(null,1,(5),inst_114013,inst_114014,null));
var inst_114016 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_114017 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_114015,inst_114016);
var inst_114018 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114012,inst_114017);
var state_114043__$1 = state_114043;
var statearr_114054_114084 = state_114043__$1;
(statearr_114054_114084[(2)] = inst_114018);

(statearr_114054_114084[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (3))){
var inst_113980 = (state_114043[(2)]);
var state_114043__$1 = (function (){var statearr_114055 = state_114043;
(statearr_114055[(8)] = inst_113980);

return statearr_114055;
})();
var statearr_114056_114085 = state_114043__$1;
(statearr_114056_114085[(2)] = null);

(statearr_114056_114085[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (12))){
var inst_114004 = (state_114043[(9)]);
var inst_114003 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114004__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_114043__$1 = (function (){var statearr_114057 = state_114043;
(statearr_114057[(10)] = inst_114003);

(statearr_114057[(9)] = inst_114004__$1);

return statearr_114057;
})();
if(cljs.core.truth_(inst_114004__$1)){
var statearr_114058_114086 = state_114043__$1;
(statearr_114058_114086[(1)] = (14));

} else {
var statearr_114059_114087 = state_114043__$1;
(statearr_114059_114087[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (2))){
var inst_114041 = (state_114043[(2)]);
var state_114043__$1 = state_114043;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114043__$1,inst_114041);
} else {
if((state_val_114044 === (19))){
var inst_114010 = (state_114043[(11)]);
var inst_114003 = (state_114043[(10)]);
var inst_114024 = (state_114043[(2)]);
var inst_114025 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_114026 = [inst_114024,inst_114010];
var inst_114027 = cljs.core.PersistentHashMap.fromArrays(inst_114025,inst_114026);
var inst_114028 = cljs.core.PersistentHashMap.EMPTY;
var inst_114029 = fluree.db.dbfunctions.internal.query(inst_114003,inst_114027,inst_114028);
var state_114043__$1 = state_114043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114043__$1,(20),inst_114029);
} else {
if((state_val_114044 === (11))){
var inst_113998 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_114043__$1 = state_114043;
var statearr_114060_114088 = state_114043__$1;
(statearr_114060_114088[(2)] = inst_113998);

(statearr_114060_114088[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (9))){
var inst_113991 = (state_114043[(7)]);
var state_114043__$1 = state_114043;
var statearr_114061_114089 = state_114043__$1;
(statearr_114061_114089[(2)] = inst_113991);

(statearr_114061_114089[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (5))){
var inst_113981 = (state_114043[(2)]);
var state_114043__$1 = state_114043;
var statearr_114062_114090 = state_114043__$1;
(statearr_114062_114090[(2)] = inst_113981);


cljs.core.async.impl.ioc_helpers.process_exception(state_114043__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (14))){
var inst_114004 = (state_114043[(9)]);
var state_114043__$1 = state_114043;
var statearr_114063_114091 = state_114043__$1;
(statearr_114063_114091[(2)] = inst_114004);

(statearr_114063_114091[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (16))){
var inst_114010 = (state_114043[(2)]);
var state_114043__$1 = (function (){var statearr_114064 = state_114043;
(statearr_114064[(11)] = inst_114010);

return statearr_114064;
})();
if(cljs.core.truth_(additional_params)){
var statearr_114065_114092 = state_114043__$1;
(statearr_114065_114092[(1)] = (17));

} else {
var statearr_114066_114093 = state_114043__$1;
(statearr_114066_114093[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (10))){
var inst_113996 = (state_114043[(2)]);
var state_114043__$1 = state_114043;
if(cljs.core.truth_(inst_113996)){
var statearr_114067_114094 = state_114043__$1;
(statearr_114067_114094[(1)] = (11));

} else {
var statearr_114068_114095 = state_114043__$1;
(statearr_114068_114095[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (18))){
var inst_114020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114021 = ["*"];
var inst_114022 = (new cljs.core.PersistentVector(null,1,(5),inst_114020,inst_114021,null));
var state_114043__$1 = state_114043;
var statearr_114069_114096 = state_114043__$1;
(statearr_114069_114096[(2)] = inst_114022);

(statearr_114069_114096[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114044 === (8))){
var inst_113993 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_114043__$1 = state_114043;
var statearr_114070_114097 = state_114043__$1;
(statearr_114070_114097[(2)] = inst_113993);

(statearr_114070_114097[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99037__auto____0 = (function (){
var statearr_114071 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114071[(0)] = fluree$db$dbfunctions$internal$state_machine__99037__auto__);

(statearr_114071[(1)] = (1));

return statearr_114071;
});
var fluree$db$dbfunctions$internal$state_machine__99037__auto____1 = (function (state_114043){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114043);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114072){if((e114072 instanceof Object)){
var ex__99040__auto__ = e114072;
var statearr_114073_114098 = state_114043;
(statearr_114073_114098[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114043);

return cljs.core.cst$kw$recur;
} else {
throw e114072;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114099 = state_114043;
state_114043 = G__114099;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99037__auto__ = function(state_114043){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____1.call(this,state_114043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114074 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114074[(6)] = c__99059__auto__);

return statearr_114074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2;

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__114101 = arguments.length;
switch (G__114101) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114142){
var state_val_114143 = (state_114142[(1)]);
if((state_val_114143 === (1))){
var state_114142__$1 = state_114142;
var statearr_114144_114157 = state_114142__$1;
(statearr_114144_114157[(2)] = null);

(statearr_114144_114157[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114143 === (2))){
var inst_114140 = (state_114142[(2)]);
var state_114142__$1 = state_114142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114142__$1,inst_114140);
} else {
if((state_val_114143 === (3))){
var inst_114102 = (state_114142[(2)]);
var inst_114103 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_114102,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_114142__$1 = state_114142;
var statearr_114145_114158 = state_114142__$1;
(statearr_114145_114158[(2)] = inst_114103);


cljs.core.async.impl.ioc_helpers.process_exception(state_114142__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114143 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114142,(3),java.lang.Exception,null,(2));
var inst_114110 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114111 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_114142__$1 = (function (){var statearr_114146 = state_114142;
(statearr_114146[(7)] = inst_114110);

(statearr_114146[(8)] = inst_114111);

return statearr_114146;
})();
if(cljs.core.truth_(additional_params)){
var statearr_114147_114159 = state_114142__$1;
(statearr_114147_114159[(1)] = (5));

} else {
var statearr_114148_114160 = state_114142__$1;
(statearr_114148_114160[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114143 === (5))){
var inst_114113 = cljs.core.PersistentVector.EMPTY;
var inst_114114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114115 = ["*"];
var inst_114116 = (new cljs.core.PersistentVector(null,1,(5),inst_114114,inst_114115,null));
var inst_114117 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_114118 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_114116,inst_114117);
var inst_114119 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_114113,inst_114118);
var state_114142__$1 = state_114142;
var statearr_114149_114161 = state_114142__$1;
(statearr_114149_114161[(2)] = inst_114119);

(statearr_114149_114161[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114143 === (6))){
var inst_114121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114122 = ["*"];
var inst_114123 = (new cljs.core.PersistentVector(null,1,(5),inst_114121,inst_114122,null));
var state_114142__$1 = state_114142;
var statearr_114150_114162 = state_114142__$1;
(statearr_114150_114162[(2)] = inst_114123);

(statearr_114150_114162[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114143 === (7))){
var inst_114110 = (state_114142[(7)]);
var inst_114111 = (state_114142[(8)]);
var inst_114125 = (state_114142[(2)]);
var inst_114126 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_114127 = [inst_114125,inst_114111];
var inst_114128 = cljs.core.PersistentHashMap.fromArrays(inst_114126,inst_114127);
var inst_114129 = cljs.core.PersistentHashMap.EMPTY;
var inst_114130 = fluree.db.dbfunctions.internal.query(inst_114110,inst_114128,inst_114129);
var state_114142__$1 = state_114142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114142__$1,(8),inst_114130);
} else {
if((state_val_114143 === (8))){
var inst_114132 = (state_114142[(2)]);
var inst_114133 = fluree.db.util.async.throw_err(inst_114132);
var inst_114134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114133,(0),null);
var inst_114135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114133,(1),null);
var inst_114136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114137 = [inst_114134,inst_114135];
var inst_114138 = (new cljs.core.PersistentVector(null,2,(5),inst_114136,inst_114137,null));
var state_114142__$1 = state_114142;
var statearr_114151_114163 = state_114142__$1;
(statearr_114151_114163[(2)] = inst_114138);


cljs.core.async.impl.ioc_helpers.process_exception(state_114142__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__99037__auto____0 = (function (){
var statearr_114152 = [null,null,null,null,null,null,null,null,null];
(statearr_114152[(0)] = fluree$db$dbfunctions$internal$state_machine__99037__auto__);

(statearr_114152[(1)] = (1));

return statearr_114152;
});
var fluree$db$dbfunctions$internal$state_machine__99037__auto____1 = (function (state_114142){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114142);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114153){if((e114153 instanceof Object)){
var ex__99040__auto__ = e114153;
var statearr_114154_114164 = state_114142;
(statearr_114154_114164[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114142);

return cljs.core.cst$kw$recur;
} else {
throw e114153;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114165 = state_114142;
state_114142 = G__114165;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__99037__auto__ = function(state_114142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__99037__auto____1.call(this,state_114142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114155 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114155[(6)] = c__99059__auto__);

return statearr_114155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2;

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114206){
var state_val_114207 = (state_114206[(1)]);
if((state_val_114207 === (1))){
var state_114206__$1 = state_114206;
var statearr_114208_114215 = state_114206__$1;
(statearr_114208_114215[(2)] = null);

(statearr_114208_114215[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114207 === (2))){
var inst_114204 = (state_114206[(2)]);
var state_114206__$1 = state_114206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114206__$1,inst_114204);
} else {
if((state_val_114207 === (3))){
var inst_114166 = (state_114206[(2)]);
var inst_114167 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_114166,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_114206__$1 = state_114206;
var statearr_114209_114216 = state_114206__$1;
(statearr_114209_114216[(2)] = inst_114167);


cljs.core.async.impl.ioc_helpers.process_exception(state_114206__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114207 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114206,(3),java.lang.Exception,null,(2));
var inst_114174 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_114175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114176 = ["_user/_auth"];
var inst_114177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114178 = ["*"];
var inst_114179 = (new cljs.core.PersistentVector(null,1,(5),inst_114177,inst_114178,null));
var inst_114180 = [inst_114179];
var inst_114181 = cljs.core.PersistentHashMap.fromArrays(inst_114176,inst_114180);
var inst_114182 = [inst_114181];
var inst_114183 = (new cljs.core.PersistentVector(null,1,(5),inst_114175,inst_114182,null));
var inst_114184 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114185 = [inst_114183,inst_114184];
var inst_114186 = cljs.core.PersistentHashMap.fromArrays(inst_114174,inst_114185);
var inst_114187 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114188 = cljs.core.PersistentHashMap.EMPTY;
var inst_114189 = fluree.db.dbfunctions.internal.query(inst_114187,inst_114186,inst_114188);
var state_114206__$1 = state_114206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114206__$1,(5),inst_114189);
} else {
if((state_val_114207 === (5))){
var inst_114191 = (state_114206[(2)]);
var inst_114192 = fluree.db.util.async.throw_err(inst_114191);
var inst_114193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114192,(0),null);
var inst_114194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114192,(1),null);
var inst_114195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114196 = ["_user/_auth","_id"];
var inst_114197 = (new cljs.core.PersistentVector(null,2,(5),inst_114195,inst_114196,null));
var inst_114198 = fluree.db.dbfunctions.internal.get_in(inst_114193,inst_114197);
var inst_114199 = cljs.core.first(inst_114198);
var inst_114200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114201 = [inst_114199,inst_114194];
var inst_114202 = (new cljs.core.PersistentVector(null,2,(5),inst_114200,inst_114201,null));
var state_114206__$1 = state_114206;
var statearr_114210_114217 = state_114206__$1;
(statearr_114210_114217[(2)] = inst_114202);


cljs.core.async.impl.ioc_helpers.process_exception(state_114206__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____0 = (function (){
var statearr_114211 = [null,null,null,null,null,null,null];
(statearr_114211[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__);

(statearr_114211[(1)] = (1));

return statearr_114211;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____1 = (function (state_114206){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114206);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114212){if((e114212 instanceof Object)){
var ex__99040__auto__ = e114212;
var statearr_114213_114218 = state_114206;
(statearr_114213_114218[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114206);

return cljs.core.cst$kw$recur;
} else {
throw e114212;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114219 = state_114206;
state_114206 = G__114219;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__ = function(state_114206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____1.call(this,state_114206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114214 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114214[(6)] = c__99059__auto__);

return statearr_114214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_114233){
var state_val_114234 = (state_114233[(1)]);
if((state_val_114234 === (1))){
var state_114233__$1 = state_114233;
var statearr_114235_114242 = state_114233__$1;
(statearr_114235_114242[(2)] = null);

(statearr_114235_114242[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114234 === (2))){
var inst_114231 = (state_114233[(2)]);
var state_114233__$1 = state_114233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114233__$1,inst_114231);
} else {
if((state_val_114234 === (3))){
var inst_114220 = (state_114233[(2)]);
var state_114233__$1 = state_114233;
var statearr_114236_114243 = state_114233__$1;
(statearr_114236_114243[(2)] = inst_114220);


cljs.core.async.impl.ioc_helpers.process_exception(state_114233__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114234 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114233,(3),Error,null,(2));
var inst_114224 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114225 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_114226 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_114225,inst_114224);
var state_114233__$1 = state_114233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114233__$1,(5),inst_114226);
} else {
if((state_val_114234 === (5))){
var inst_114228 = (state_114233[(2)]);
var inst_114229 = fluree.db.util.async.throw_err(inst_114228);
var state_114233__$1 = state_114233;
var statearr_114237_114244 = state_114233__$1;
(statearr_114237_114244[(2)] = inst_114229);


cljs.core.async.impl.ioc_helpers.process_exception(state_114233__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____0 = (function (){
var statearr_114238 = [null,null,null,null,null,null,null];
(statearr_114238[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__);

(statearr_114238[(1)] = (1));

return statearr_114238;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____1 = (function (state_114233){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_114233);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e114239){if((e114239 instanceof Object)){
var ex__99040__auto__ = e114239;
var statearr_114240_114245 = state_114233;
(statearr_114240_114245[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114233);

return cljs.core.cst$kw$recur;
} else {
throw e114239;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__114246 = state_114233;
state_114233 = G__114246;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__ = function(state_114233){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____1.call(this,state_114233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_114241 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_114241[(6)] = c__99059__auto__);

return statearr_114241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__114247_SHARP_){
return p1__114247_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (trueF){
return (function (p1__114248_SHARP_){
return p1__114248_SHARP_.o;
});})(trueF))
,trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e114249){if((e114249 instanceof java.lang.Exception)){
var e = e114249;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
} else {
throw e114249;

}
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__114250_SHARP_){
return p1__114250_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (falseF){
return (function (p1__114251_SHARP_){
return p1__114251_SHARP_.o;
});})(falseF))
,falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e114252){if((e114252 instanceof java.lang.Exception)){
var e = e114252;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
} else {
throw e114252;

}
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__114254 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__114254);
})() | (0));
return num;
}catch (e114253){if((e114253 instanceof java.lang.Exception)){
var e = e114253;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
} else {
throw e114253;

}
}});

//# sourceMappingURL=internal.js.map?rel=1593118620453
