// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__105214_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105214_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(joined_group)," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars))," ) { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_group_str)," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__105218 = coll;
var vec__105219 = G__105218;
var seq__105220 = cljs.core.seq(vec__105219);
var first__105221 = cljs.core.first(seq__105220);
var seq__105220__$1 = cljs.core.next(seq__105220);
var clause = first__105221;
var r = seq__105220__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105218__$1 = G__105218;
var res__$1 = res;
while(true){
var vec__105225 = G__105218__$1;
var seq__105226 = cljs.core.seq(vec__105225);
var first__105227 = cljs.core.first(seq__105226);
var seq__105226__$1 = cljs.core.next(seq__105226);
var clause__$1 = first__105227;
var r__$1 = seq__105226__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__105228 = r__$1;
var G__105229 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__105218__$1 = G__105228;
res__$1 = G__105229;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__105233 = coll;
var vec__105234 = G__105233;
var seq__105235 = cljs.core.seq(vec__105234);
var first__105236 = cljs.core.first(seq__105235);
var seq__105235__$1 = cljs.core.next(seq__105235);
var clause = first__105236;
var r = seq__105235__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105233__$1 = G__105233;
var res__$1 = res;
while(true){
var vec__105240 = G__105233__$1;
var seq__105241 = cljs.core.seq(vec__105240);
var first__105242 = cljs.core.first(seq__105241);
var seq__105241__$1 = cljs.core.next(seq__105241);
var clause__$1 = first__105242;
var r__$1 = seq__105241__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__105243 = r__$1;
var G__105244 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__105233__$1 = G__105243;
res__$1 = G__105244;
continue;
} else {
var G__105245 = r__$1;
var G__105246 = res__$2;
G__105233__$1 = G__105245;
res__$1 = G__105246;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__105250 = coll;
var vec__105251 = G__105250;
var seq__105252 = cljs.core.seq(vec__105251);
var first__105253 = cljs.core.first(seq__105252);
var seq__105252__$1 = cljs.core.next(seq__105252);
var clause = first__105253;
var r = seq__105252__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105250__$1 = G__105250;
var res__$1 = res;
while(true){
var vec__105257 = G__105250__$1;
var seq__105258 = cljs.core.seq(vec__105257);
var first__105259 = cljs.core.first(seq__105258);
var seq__105258__$1 = cljs.core.next(seq__105258);
var clause__$1 = first__105259;
var r__$1 = seq__105258__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__105260 = r__$1;
var G__105261 = res__$2;
G__105250__$1 = G__105260;
res__$1 = G__105261;
continue;
} else {
var G__105262 = r__$1;
var G__105263 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__105250__$1 = G__105262;
res__$1 = G__105263;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4120__auto__ = typeof string === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4120__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause))),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix))),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0))].join('')], 0)):null);
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__105267 = opts;
var map__105267__$1 = (((((!((map__105267 == null))))?(((((map__105267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105267):map__105267);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105267__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105267__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105267__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105267__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105267__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1){
return (function (p1__105264_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105264_SHARP_),"Label"].join('');
});})(_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1))
,select_vars)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars))].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt){
return (function (p1__105265_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__105265_SHARP_,false);
});})(_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt))
,clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt,where_smt){
return (function (p1__105266_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__105266_SHARP_,true);
});})(_,opts,map__105267,map__105267__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt,where_smt))
,optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = language;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(optional_smt)," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105282){
var state_val_105283 = (state_105282[(1)]);
if((state_val_105283 === (1))){
var inst_105269 = fluree.db.util.core.url_encode(query);
var inst_105270 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105269)].join('');
var inst_105271 = ["User-Agent","Accept"];
var inst_105272 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_105273 = cljs.core.PersistentHashMap.fromArrays(inst_105271,inst_105272);
var inst_105274 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_105275 = [inst_105273,(30000),cljs.core.cst$kw$wikidata];
var inst_105276 = cljs.core.PersistentHashMap.fromArrays(inst_105274,inst_105275);
var inst_105277 = fluree.db.util.xhttp.get(inst_105270,inst_105276);
var state_105282__$1 = state_105282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105282__$1,(2),inst_105277);
} else {
if((state_val_105283 === (2))){
var inst_105279 = (state_105282[(2)]);
var inst_105280 = fluree.db.util.async.throw_err(inst_105279);
var state_105282__$1 = state_105282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105282__$1,inst_105280);
} else {
return null;
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____0 = (function (){
var statearr_105284 = [null,null,null,null,null,null,null];
(statearr_105284[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__);

(statearr_105284[(1)] = (1));

return statearr_105284;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____1 = (function (state_105282){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105282);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105285){if((e105285 instanceof Object)){
var ex__99040__auto__ = e105285;
var statearr_105286_105288 = state_105282;
(statearr_105286_105288[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105282);

return cljs.core.cst$kw$recur;
} else {
throw e105285;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105289 = state_105282;
state_105282 = G__105289;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__ = function(state_105282){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____1.call(this,state_105282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105287 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105287[(6)] = c__99059__auto__);

return statearr_105287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105307){
var state_val_105308 = (state_105307[(1)]);
if((state_val_105308 === (1))){
var inst_105290 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_105307__$1 = state_105307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105307__$1,(2),inst_105290);
} else {
if((state_val_105308 === (2))){
var inst_105293 = (state_105307[(7)]);
var inst_105292 = (state_105307[(2)]);
var inst_105293__$1 = fluree.db.util.async.throw_err(inst_105292);
var inst_105294 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_105293__$1);
var inst_105295 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_105294);
var state_105307__$1 = (function (){var statearr_105309 = state_105307;
(statearr_105309[(7)] = inst_105293__$1);

return statearr_105309;
})();
if(inst_105295){
var statearr_105310_105318 = state_105307__$1;
(statearr_105310_105318[(1)] = (3));

} else {
var statearr_105311_105319 = state_105307__$1;
(statearr_105311_105319[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105308 === (3))){
var inst_105293 = (state_105307[(7)]);
var state_105307__$1 = state_105307;
var statearr_105312_105320 = state_105307__$1;
(statearr_105312_105320[(2)] = inst_105293);

(statearr_105312_105320[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105308 === (4))){
var inst_105293 = (state_105307[(7)]);
var inst_105298 = (function (){var body = inst_105293;
return ((function (body,inst_105293,state_val_105308,c__99059__auto__){
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (body,inst_105293,state_val_105308,c__99059__auto__){
return (function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
});})(body,inst_105293,state_val_105308,c__99059__auto__))
,cljs.core.PersistentArrayMap.EMPTY,item);
});
;})(body,inst_105293,state_val_105308,c__99059__auto__))
})();
var inst_105299 = cljs.core.second(inst_105293);
var inst_105300 = cljs.core.second(inst_105299);
var inst_105301 = cljs.core.first(inst_105300);
var inst_105302 = cljs.core.second(inst_105301);
var inst_105303 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_105298,inst_105302);
var state_105307__$1 = state_105307;
var statearr_105313_105321 = state_105307__$1;
(statearr_105313_105321[(2)] = inst_105303);

(statearr_105313_105321[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105308 === (5))){
var inst_105305 = (state_105307[(2)]);
var state_105307__$1 = state_105307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105307__$1,inst_105305);
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____0 = (function (){
var statearr_105314 = [null,null,null,null,null,null,null,null];
(statearr_105314[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__);

(statearr_105314[(1)] = (1));

return statearr_105314;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____1 = (function (state_105307){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105307);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105315){if((e105315 instanceof Object)){
var ex__99040__auto__ = e105315;
var statearr_105316_105322 = state_105307;
(statearr_105316_105322[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105307);

return cljs.core.cst$kw$recur;
} else {
throw e105315;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105323 = state_105307;
state_105307 = G__105323;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__ = function(state_105307){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____1.call(this,state_105307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105317 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105317[(6)] = c__99059__auto__);

return statearr_105317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__105324_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105324_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers){
return (function (p1__105325_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105325_SHARP_),(1)));
});})(labelVars,headers))
,headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers,headers_as_kws,results){
return (function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers,headers_as_kws,results){
return (function (p1__105326_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__105326_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__105326_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__105326_SHARP_.call(null,res)));
});})(labelVars,headers,headers_as_kws,results))
,headers_as_kws);
});})(labelVars,headers,headers_as_kws,results))
,results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_105361){
var state_val_105362 = (state_105361[(1)]);
if((state_val_105362 === (7))){
var inst_105336 = (state_105361[(2)]);
var inst_105337 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_105336,optional_clauses);
var inst_105338 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_105337);
var state_105361__$1 = state_105361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_105361__$1,(8),inst_105338);
} else {
if((state_val_105362 === (1))){
var state_105361__$1 = state_105361;
var statearr_105363_105379 = state_105361__$1;
(statearr_105363_105379[(2)] = null);

(statearr_105363_105379[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_105361,(3),Error,null,(2));
var inst_105331 = cljs.core.empty_QMARK_(matching_vars);
var state_105361__$1 = state_105361;
if(inst_105331){
var statearr_105364_105380 = state_105361__$1;
(statearr_105364_105380[(1)] = (5));

} else {
var statearr_105365_105381 = state_105361__$1;
(statearr_105365_105381[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (6))){
var inst_105334 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_105361__$1 = state_105361;
var statearr_105366_105382 = state_105361__$1;
(statearr_105366_105382[(2)] = inst_105334);

(statearr_105366_105382[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (3))){
var inst_105327 = (state_105361[(2)]);
var state_105361__$1 = state_105361;
var statearr_105367_105383 = state_105361__$1;
(statearr_105367_105383[(2)] = inst_105327);


cljs.core.async.impl.ioc_helpers.process_exception(state_105361__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (2))){
var inst_105359 = (state_105361[(2)]);
var state_105361__$1 = state_105361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_105361__$1,inst_105359);
} else {
if((state_val_105362 === (11))){
var inst_105357 = (state_105361[(2)]);
var state_105361__$1 = state_105361;
var statearr_105368_105384 = state_105361__$1;
(statearr_105368_105384[(2)] = inst_105357);


cljs.core.async.impl.ioc_helpers.process_exception(state_105361__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (9))){
var inst_105341 = (state_105361[(7)]);
var inst_105345 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_105341);
var inst_105346 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_105345,(0),(1000));
var inst_105347 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_105348 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_105341);
var inst_105349 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_105341);
var inst_105350 = [inst_105348,inst_105349];
var inst_105351 = cljs.core.PersistentHashMap.fromArrays(inst_105347,inst_105350);
var inst_105352 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_105346,inst_105351);
var inst_105353 = (function(){throw inst_105352})();
var state_105361__$1 = state_105361;
var statearr_105369_105385 = state_105361__$1;
(statearr_105369_105385[(2)] = inst_105353);

(statearr_105369_105385[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (5))){
var state_105361__$1 = state_105361;
var statearr_105370_105386 = state_105361__$1;
(statearr_105370_105386[(2)] = null);

(statearr_105370_105386[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (10))){
var inst_105341 = (state_105361[(7)]);
var inst_105355 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_105341,all_vars);
var state_105361__$1 = state_105361;
var statearr_105371_105387 = state_105361__$1;
(statearr_105371_105387[(2)] = inst_105355);

(statearr_105371_105387[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_105362 === (8))){
var inst_105341 = (state_105361[(7)]);
var inst_105340 = (state_105361[(2)]);
var inst_105341__$1 = fluree.db.util.async.throw_err(inst_105340);
var inst_105342 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_105341__$1);
var inst_105343 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_105342);
var state_105361__$1 = (function (){var statearr_105372 = state_105361;
(statearr_105372[(7)] = inst_105341__$1);

return statearr_105372;
})();
if(inst_105343){
var statearr_105373_105388 = state_105361__$1;
(statearr_105373_105388[(1)] = (9));

} else {
var statearr_105374_105389 = state_105361__$1;
(statearr_105374_105389[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_105375 = [null,null,null,null,null,null,null,null];
(statearr_105375[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__);

(statearr_105375[(1)] = (1));

return statearr_105375;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____1 = (function (state_105361){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_105361);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e105376){if((e105376 instanceof Object)){
var ex__99040__auto__ = e105376;
var statearr_105377_105390 = state_105361;
(statearr_105377_105390[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_105361);

return cljs.core.cst$kw$recur;
} else {
throw e105376;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__105391 = state_105361;
state_105361 = G__105391;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__ = function(state_105361){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____1.call(this,state_105361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_105378 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_105378[(6)] = c__99059__auto__);

return statearr_105378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=analytical_wikidata.js.map?rel=1593118617627
