// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__107086 = null;
var G__107086__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__107086__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__107086__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__107086 = function(result,flake){
switch(arguments.length){
case 0:
return G__107086__0.call(this);
case 1:
return G__107086__1.call(this,result);
case 2:
return G__107086__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__107086.cljs$core$IFn$_invoke$arity$0 = G__107086__0;
G__107086.cljs$core$IFn$_invoke$arity$1 = G__107086__1;
G__107086.cljs$core$IFn$_invoke$arity$2 = G__107086__2;
return G__107086;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__107087 = null;
var G__107087__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__107087__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__107087__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__107087 = function(result,flakes){
switch(arguments.length){
case 0:
return G__107087__0.call(this);
case 1:
return G__107087__1.call(this,result);
case 2:
return G__107087__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__107087.cljs$core$IFn$_invoke$arity$0 = G__107087__0;
G__107087.cljs$core$IFn$_invoke$arity$1 = G__107087__1;
G__107087.cljs$core$IFn$_invoke$arity$2 = G__107087__2;
return G__107087;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__107089 = res;
var G__107089__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(((function (G__107089){
return (function (p1__107088_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__107088_SHARP_,sortPred);
});})(G__107089))
,fluree.db.query.fql.compare_fn,G__107089):G__107089);
var G__107089__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__107089__$1):G__107089__$1);
var G__107089__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__107089__$2):G__107089__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__107089__$3);
} else {
return G__107089__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__107091 = arguments.length;
switch (G__107091) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_107390){
var state_val_107391 = (state_107390[(1)]);
if((state_val_107391 === (65))){
var state_107390__$1 = state_107390;
if(cljs.core.truth_(componentFollow_QMARK_)){
var statearr_107392_107552 = state_107390__$1;
(statearr_107392_107552[(1)] = (71));

} else {
var statearr_107393_107553 = state_107390__$1;
(statearr_107393_107553[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (70))){
var inst_107119 = (state_107390[(7)]);
var inst_107257 = (state_107390[(2)]);
var inst_107258 = fluree.db.util.async.throw_err(inst_107257);
var inst_107259 = cljs.core._deref(cache);
var inst_107260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107261 = flake.o;
var inst_107262 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_107119);
var inst_107263 = [inst_107261,inst_107262];
var inst_107264 = (new cljs.core.PersistentVector(null,2,(5),inst_107260,inst_107263,null));
var inst_107265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107259,inst_107264,inst_107258);
var inst_107266 = cljs.core._vreset_BANG_(cache,inst_107265);
var state_107390__$1 = (function (){var statearr_107394 = state_107390;
(statearr_107394[(8)] = inst_107266);

return statearr_107394;
})();
var statearr_107395_107554 = state_107390__$1;
(statearr_107395_107554[(2)] = inst_107258);

(statearr_107395_107554[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (62))){
var inst_107228 = (state_107390[(9)]);
var state_107390__$1 = state_107390;
var statearr_107396_107555 = state_107390__$1;
(statearr_107396_107555[(2)] = inst_107228);

(statearr_107396_107555[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (74))){
var inst_107119 = (state_107390[(7)]);
var inst_107278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107279 = flake.o;
var inst_107280 = [inst_107279];
var inst_107281 = (new cljs.core.PersistentVector(null,1,(5),inst_107278,inst_107280,null));
var inst_107282 = [cljs.core.cst$kw$limit];
var inst_107283 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_107119);
var inst_107284 = [inst_107283];
var inst_107285 = cljs.core.PersistentHashMap.fromArrays(inst_107282,inst_107284);
var inst_107286 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_107281,inst_107285);
var state_107390__$1 = state_107390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107390__$1,(77),inst_107286);
} else {
if((state_val_107391 === (7))){
var inst_107106 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107106)){
var statearr_107397_107556 = state_107390__$1;
(statearr_107397_107556[(1)] = (8));

} else {
var statearr_107398_107557 = state_107390__$1;
(statearr_107398_107557[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (59))){
var inst_107222 = (state_107390[(10)]);
var state_107390__$1 = state_107390;
var statearr_107399_107558 = state_107390__$1;
(statearr_107399_107558[(2)] = inst_107222);

(statearr_107399_107558[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (86))){
var inst_107307 = (state_107390[(11)]);
var state_107390__$1 = state_107390;
var statearr_107400_107559 = state_107390__$1;
(statearr_107400_107559[(2)] = inst_107307);

(statearr_107400_107559[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (20))){
var inst_107119 = (state_107390[(7)]);
var inst_107135 = inst_107119.cljs$lang$protocol_mask$partition0$;
var inst_107136 = (inst_107135 & (64));
var inst_107137 = inst_107119.cljs$core$ISeq$;
var inst_107138 = (cljs.core.PROTOCOL_SENTINEL === inst_107137);
var inst_107139 = ((inst_107136) || (inst_107138));
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107139)){
var statearr_107401_107560 = state_107390__$1;
(statearr_107401_107560[(1)] = (23));

} else {
var statearr_107402_107561 = state_107390__$1;
(statearr_107402_107561[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (72))){
var state_107390__$1 = state_107390;
var statearr_107403_107562 = state_107390__$1;
(statearr_107403_107562[(2)] = componentFollow_QMARK_);

(statearr_107403_107562[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (58))){
var inst_107222 = (state_107390[(10)]);
var inst_107224 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_107225 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_107224,inst_107222);
var state_107390__$1 = state_107390;
var statearr_107404_107563 = state_107390__$1;
(statearr_107404_107563[(2)] = inst_107225);

(statearr_107404_107563[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (60))){
var inst_107228 = (state_107390[(2)]);
var state_107390__$1 = (function (){var statearr_107405 = state_107390;
(statearr_107405[(9)] = inst_107228);

return statearr_107405;
})();
var statearr_107406_107564 = state_107390__$1;
(statearr_107406_107564[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (27))){
var inst_107119 = (state_107390[(7)]);
var state_107390__$1 = state_107390;
var statearr_107408_107565 = state_107390__$1;
(statearr_107408_107565[(2)] = inst_107119);

(statearr_107408_107565[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (1))){
var state_107390__$1 = state_107390;
var statearr_107409_107566 = state_107390__$1;
(statearr_107409_107566[(2)] = null);

(statearr_107409_107566[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (69))){
var inst_107243 = (state_107390[(12)]);
var inst_107268 = (state_107390[(2)]);
var inst_107269 = [inst_107268,offset_map];
var inst_107270 = (new cljs.core.PersistentVector(null,2,(5),inst_107243,inst_107269,null));
var state_107390__$1 = state_107390;
var statearr_107410_107567 = state_107390__$1;
(statearr_107410_107567[(2)] = inst_107270);

(statearr_107410_107567[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (101))){
var state_107390__$1 = state_107390;
var statearr_107411_107568 = state_107390__$1;
(statearr_107411_107568[(1)] = (103));



return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (24))){
var state_107390__$1 = state_107390;
var statearr_107413_107569 = state_107390__$1;
(statearr_107413_107569[(2)] = false);

(statearr_107413_107569[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (102))){
var inst_107384 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107414_107570 = state_107390__$1;
(statearr_107414_107570[(2)] = inst_107384);

(statearr_107414_107570[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (55))){
var inst_107346 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107415_107571 = state_107390__$1;
(statearr_107415_107571[(2)] = inst_107346);

(statearr_107415_107571[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (85))){
var inst_107156 = (state_107390[(13)]);
var inst_107307 = (state_107390[(11)]);
var inst_107130 = (state_107390[(14)]);
var inst_107289 = (state_107390[(15)]);
var inst_107157 = (state_107390[(16)]);
var inst_107153 = (state_107390[(17)]);
var inst_107152 = (state_107390[(18)]);
var inst_107151 = (state_107390[(19)]);
var inst_107154 = (state_107390[(20)]);
var inst_107155 = (state_107390[(21)]);
var inst_107113 = (state_107390[(22)]);
var inst_107119 = (state_107390[(7)]);
var inst_107309 = (function (){var p = inst_107157;
var pred_spec__$1 = inst_107113;
var orderBy = inst_107155;
var G__107301 = inst_107307;
var children = inst_107289;
var multi_QMARK_ = inst_107152;
var limit = inst_107154;
var offset = inst_107156;
var map__107096 = inst_107151;
var k = inst_107130;
var pred_spec_SINGLEQUOTE_ = inst_107119;
var ref_QMARK_ = inst_107153;
return ((function (p,pred_spec__$1,orderBy,G__107301,children,multi_QMARK_,limit,offset,map__107096,k,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_107156,inst_107307,inst_107130,inst_107289,inst_107157,inst_107153,inst_107152,inst_107151,inst_107154,inst_107155,inst_107113,inst_107119,state_val_107391,c__99059__auto__){
return (function (n){
var G__107416 = db;
var G__107417 = cache;
var G__107418 = fuel;
var G__107419 = max_fuel;
var G__107420 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__107421 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__107416,G__107417,G__107418,G__107419,G__107420,G__107421) : fluree.db.query.fql.flakes__GT_res.call(null,G__107416,G__107417,G__107418,G__107419,G__107420,G__107421));
});
;})(p,pred_spec__$1,orderBy,G__107301,children,multi_QMARK_,limit,offset,map__107096,k,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_107156,inst_107307,inst_107130,inst_107289,inst_107157,inst_107153,inst_107152,inst_107151,inst_107154,inst_107155,inst_107113,inst_107119,state_val_107391,c__99059__auto__))
})();
var inst_107310 = (inst_107309.cljs$core$IFn$_invoke$arity$1 ? inst_107309.cljs$core$IFn$_invoke$arity$1(inst_107307) : inst_107309.call(null,inst_107307));
var state_107390__$1 = state_107390;
var statearr_107422_107572 = state_107390__$1;
(statearr_107422_107572[(2)] = inst_107310);

(statearr_107422_107572[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (39))){
var inst_107156 = (state_107390[(13)]);
var inst_107157 = (state_107390[(16)]);
var inst_107176 = (inst_107156 - (1));
var inst_107177 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_107157,inst_107176);
var state_107390__$1 = state_107390;
var statearr_107423_107573 = state_107390__$1;
(statearr_107423_107573[(2)] = inst_107177);

(statearr_107423_107573[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (88))){
var inst_107323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107324 = ["_id"];
var inst_107325 = flake.o;
var inst_107326 = [inst_107325];
var inst_107327 = cljs.core.PersistentHashMap.fromArrays(inst_107324,inst_107326);
var inst_107328 = [inst_107327,offset_map];
var inst_107329 = (new cljs.core.PersistentVector(null,2,(5),inst_107323,inst_107328,null));
var state_107390__$1 = state_107390;
var statearr_107424_107574 = state_107390__$1;
(statearr_107424_107574[(2)] = inst_107329);

(statearr_107424_107574[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (46))){
var inst_107348 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107425_107575 = state_107390__$1;
(statearr_107425_107575[(2)] = inst_107348);

(statearr_107425_107575[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (4))){
var inst_107100 = (state_107390[(23)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107390,(3),Error,null,(2));
var inst_107100__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_107390__$1 = (function (){var statearr_107426 = state_107390;
(statearr_107426[(23)] = inst_107100__$1);

return statearr_107426;
})();
if(cljs.core.truth_(inst_107100__$1)){
var statearr_107427_107576 = state_107390__$1;
(statearr_107427_107576[(1)] = (5));

} else {
var statearr_107428_107577 = state_107390__$1;
(statearr_107428_107577[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (77))){
var inst_107289 = (state_107390[(15)]);
var inst_107288 = (state_107390[(2)]);
var inst_107289__$1 = fluree.db.util.async.throw_err(inst_107288);
var inst_107290 = cljs.core.empty_QMARK_(inst_107289__$1);
var state_107390__$1 = (function (){var statearr_107429 = state_107390;
(statearr_107429[(15)] = inst_107289__$1);

return statearr_107429;
})();
if(inst_107290){
var statearr_107430_107578 = state_107390__$1;
(statearr_107430_107578[(1)] = (78));

} else {
var statearr_107431_107579 = state_107390__$1;
(statearr_107431_107579[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (95))){
var inst_107354 = (state_107390[(24)]);
var state_107390__$1 = state_107390;
var statearr_107432_107580 = state_107390__$1;
(statearr_107432_107580[(2)] = inst_107354);

(statearr_107432_107580[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (54))){
var inst_107119 = (state_107390[(7)]);
var inst_107241 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107241)){
var statearr_107433_107581 = state_107390__$1;
(statearr_107433_107581[(1)] = (64));

} else {
var statearr_107434_107582 = state_107390__$1;
(statearr_107434_107582[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (92))){
var state_107390__$1 = state_107390;
var statearr_107435_107583 = state_107390__$1;
(statearr_107435_107583[(2)] = null);

(statearr_107435_107583[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (104))){
var state_107390__$1 = state_107390;
var statearr_107436_107584 = state_107390__$1;
(statearr_107436_107584[(2)] = null);

(statearr_107436_107584[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (15))){
var inst_107123 = (state_107390[(25)]);
var inst_107119 = (state_107390[(7)]);
var inst_107123__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = (function (){var statearr_107437 = state_107390;
(statearr_107437[(25)] = inst_107123__$1);

return statearr_107437;
})();
if(cljs.core.truth_(inst_107123__$1)){
var statearr_107438_107585 = state_107390__$1;
(statearr_107438_107585[(1)] = (17));

} else {
var statearr_107439_107586 = state_107390__$1;
(statearr_107439_107586[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (48))){
var inst_107197 = (state_107390[(26)]);
var state_107390__$1 = state_107390;
var statearr_107440_107587 = state_107390__$1;
(statearr_107440_107587[(2)] = inst_107197);

(statearr_107440_107587[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (50))){
var inst_107199 = (state_107390[(27)]);
var state_107390__$1 = state_107390;
var statearr_107441_107588 = state_107390__$1;
(statearr_107441_107588[(2)] = inst_107199);

(statearr_107441_107588[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (75))){
var inst_107153 = (state_107390[(17)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107153)){
var statearr_107442_107589 = state_107390__$1;
(statearr_107442_107589[(1)] = (88));

} else {
var statearr_107443_107590 = state_107390__$1;
(statearr_107443_107590[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (99))){
var inst_107386 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107444_107591 = state_107390__$1;
(statearr_107444_107591[(2)] = inst_107386);


cljs.core.async.impl.ioc_helpers.process_exception(state_107390__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (21))){
var state_107390__$1 = state_107390;
var statearr_107445_107592 = state_107390__$1;
(statearr_107445_107592[(2)] = false);

(statearr_107445_107592[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (31))){
var inst_107169 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107169)){
var statearr_107446_107593 = state_107390__$1;
(statearr_107446_107593[(1)] = (35));

} else {
var statearr_107447_107594 = state_107390__$1;
(statearr_107447_107594[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (32))){
var inst_107156 = (state_107390[(13)]);
var inst_107157 = (state_107390[(16)]);
var inst_107160 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_107156);
var inst_107161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_107157);
var inst_107162 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_107161);
var inst_107163 = ((inst_107160) && (inst_107162));
var state_107390__$1 = state_107390;
var statearr_107448_107595 = state_107390__$1;
(statearr_107448_107595[(2)] = inst_107163);

(statearr_107448_107595[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (40))){
var inst_107171 = (state_107390[(28)]);
var inst_107179 = (state_107390[(2)]);
var inst_107180 = [null,inst_107179];
var inst_107181 = (new cljs.core.PersistentVector(null,2,(5),inst_107171,inst_107180,null));
var state_107390__$1 = state_107390;
var statearr_107449_107596 = state_107390__$1;
(statearr_107449_107596[(2)] = inst_107181);

(statearr_107449_107596[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (91))){
var inst_107332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107333 = flake.o;
var inst_107334 = [inst_107333,offset_map];
var inst_107335 = (new cljs.core.PersistentVector(null,2,(5),inst_107332,inst_107334,null));
var state_107390__$1 = state_107390;
var statearr_107450_107597 = state_107390__$1;
(statearr_107450_107597[(2)] = inst_107335);

(statearr_107450_107597[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (56))){
var inst_107213 = (state_107390[(29)]);
var inst_107236 = (state_107390[(2)]);
var inst_107237 = fluree.db.util.async.throw_err(inst_107236);
var inst_107238 = [inst_107237,offset_map];
var inst_107239 = (new cljs.core.PersistentVector(null,2,(5),inst_107213,inst_107238,null));
var state_107390__$1 = state_107390;
var statearr_107451_107598 = state_107390__$1;
(statearr_107451_107598[(2)] = inst_107239);

(statearr_107451_107598[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (33))){
var inst_107156 = (state_107390[(13)]);
var state_107390__$1 = state_107390;
var statearr_107452_107599 = state_107390__$1;
(statearr_107452_107599[(2)] = inst_107156);

(statearr_107452_107599[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (13))){
var inst_107120 = (state_107390[(30)]);
var inst_107119 = (state_107390[(7)]);
var inst_107119__$1 = (state_107390[(2)]);
var inst_107120__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_107119__$1);
var state_107390__$1 = (function (){var statearr_107453 = state_107390;
(statearr_107453[(30)] = inst_107120__$1);

(statearr_107453[(7)] = inst_107119__$1);

return statearr_107453;
})();
if(cljs.core.truth_(inst_107120__$1)){
var statearr_107454_107600 = state_107390__$1;
(statearr_107454_107600[(1)] = (14));

} else {
var statearr_107455_107601 = state_107390__$1;
(statearr_107455_107601[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (22))){
var inst_107146 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107146)){
var statearr_107456_107602 = state_107390__$1;
(statearr_107456_107602[(1)] = (26));

} else {
var statearr_107457_107603 = state_107390__$1;
(statearr_107457_107603[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (90))){
var inst_107340 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107458_107604 = state_107390__$1;
(statearr_107458_107604[(2)] = inst_107340);

(statearr_107458_107604[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (36))){
var inst_107152 = (state_107390[(18)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107152)){
var statearr_107459_107605 = state_107390__$1;
(statearr_107459_107605[(1)] = (41));

} else {
var statearr_107460_107606 = state_107390__$1;
(statearr_107460_107606[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (41))){
var inst_107130 = (state_107390[(14)]);
var inst_107154 = (state_107390[(20)]);
var inst_107155 = (state_107390[(21)]);
var inst_107184 = cljs.core.not(inst_107155);
var inst_107185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_107130);
var inst_107186 = cljs.core.count(inst_107185);
var inst_107187 = (inst_107186 >= inst_107154);
var inst_107188 = ((inst_107184) && (inst_107187));
var state_107390__$1 = state_107390;
var statearr_107461_107607 = state_107390__$1;
(statearr_107461_107607[(2)] = inst_107188);

(statearr_107461_107607[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (89))){
var state_107390__$1 = state_107390;
var statearr_107462_107608 = state_107390__$1;
(statearr_107462_107608[(1)] = (91));



return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (100))){
var inst_107130 = (state_107390[(14)]);
var inst_107352 = (state_107390[(31)]);
var inst_107351 = (state_107390[(32)]);
var inst_107371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_107130,inst_107351);
var inst_107373 = [inst_107372,inst_107352];
var inst_107374 = (new cljs.core.PersistentVector(null,2,(5),inst_107371,inst_107373,null));
var state_107390__$1 = state_107390;
var statearr_107464_107609 = state_107390__$1;
(statearr_107464_107609[(2)] = inst_107374);

(statearr_107464_107609[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (43))){
var inst_107191 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107191)){
var statearr_107465_107610 = state_107390__$1;
(statearr_107465_107610[(1)] = (44));

} else {
var statearr_107466_107611 = state_107390__$1;
(statearr_107466_107611[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (61))){
var inst_107156 = (state_107390[(13)]);
var inst_107130 = (state_107390[(14)]);
var inst_107157 = (state_107390[(16)]);
var inst_107153 = (state_107390[(17)]);
var inst_107152 = (state_107390[(18)]);
var inst_107151 = (state_107390[(19)]);
var inst_107154 = (state_107390[(20)]);
var inst_107228 = (state_107390[(9)]);
var inst_107155 = (state_107390[(21)]);
var inst_107113 = (state_107390[(22)]);
var inst_107212 = (state_107390[(33)]);
var inst_107119 = (state_107390[(7)]);
var inst_107230 = (function (){var p = inst_107157;
var pred_spec__$1 = inst_107113;
var orderBy = inst_107155;
var nested_select_spec = inst_107212;
var multi_QMARK_ = inst_107152;
var limit = inst_107154;
var offset = inst_107156;
var map__107096 = inst_107151;
var k = inst_107130;
var G__107214 = inst_107228;
var pred_spec_SINGLEQUOTE_ = inst_107119;
var ref_QMARK_ = inst_107153;
return ((function (p,pred_spec__$1,orderBy,nested_select_spec,multi_QMARK_,limit,offset,map__107096,k,G__107214,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_107156,inst_107130,inst_107157,inst_107153,inst_107152,inst_107151,inst_107154,inst_107228,inst_107155,inst_107113,inst_107212,inst_107119,state_val_107391,c__99059__auto__){
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
;})(p,pred_spec__$1,orderBy,nested_select_spec,multi_QMARK_,limit,offset,map__107096,k,G__107214,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_107156,inst_107130,inst_107157,inst_107153,inst_107152,inst_107151,inst_107154,inst_107228,inst_107155,inst_107113,inst_107212,inst_107119,state_val_107391,c__99059__auto__))
})();
var inst_107231 = (inst_107230.cljs$core$IFn$_invoke$arity$1 ? inst_107230.cljs$core$IFn$_invoke$arity$1(inst_107228) : inst_107230.call(null,inst_107228));
var state_107390__$1 = state_107390;
var statearr_107467_107612 = state_107390__$1;
(statearr_107467_107612[(2)] = inst_107231);

(statearr_107467_107612[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (29))){
var inst_107156 = (state_107390[(13)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107156)){
var statearr_107468_107613 = state_107390__$1;
(statearr_107468_107613[(1)] = (32));

} else {
var statearr_107469_107614 = state_107390__$1;
(statearr_107469_107614[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (44))){
var inst_107193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107194 = [null,offset_map];
var inst_107195 = (new cljs.core.PersistentVector(null,2,(5),inst_107193,inst_107194,null));
var state_107390__$1 = state_107390;
var statearr_107470_107615 = state_107390__$1;
(statearr_107470_107615[(2)] = inst_107195);

(statearr_107470_107615[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (93))){
var inst_107338 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107471_107616 = state_107390__$1;
(statearr_107471_107616[(2)] = inst_107338);

(statearr_107471_107616[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (6))){
var inst_107100 = (state_107390[(23)]);
var state_107390__$1 = state_107390;
var statearr_107472_107617 = state_107390__$1;
(statearr_107472_107617[(2)] = inst_107100);

(statearr_107472_107617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (28))){
var inst_107152 = (state_107390[(18)]);
var inst_107151 = (state_107390[(19)]);
var inst_107151__$1 = (state_107390[(2)]);
var inst_107152__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_107153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_107154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$limit);
var inst_107155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$orderBy);
var inst_107156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$offset);
var inst_107157 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107151__$1,cljs.core.cst$kw$p);
var state_107390__$1 = (function (){var statearr_107473 = state_107390;
(statearr_107473[(13)] = inst_107156);

(statearr_107473[(16)] = inst_107157);

(statearr_107473[(17)] = inst_107153);

(statearr_107473[(18)] = inst_107152__$1);

(statearr_107473[(19)] = inst_107151__$1);

(statearr_107473[(20)] = inst_107154);

(statearr_107473[(21)] = inst_107155);

return statearr_107473;
})();
if(cljs.core.truth_(inst_107152__$1)){
var statearr_107474_107618 = state_107390__$1;
(statearr_107474_107618[(1)] = (29));

} else {
var statearr_107475_107619 = state_107390__$1;
(statearr_107475_107619[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (64))){
var inst_107119 = (state_107390[(7)]);
var inst_107250 = (state_107390[(34)]);
var inst_107243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107244 = cljs.core.deref(cache);
var inst_107245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107246 = flake.o;
var inst_107247 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_107119);
var inst_107248 = [inst_107246,inst_107247];
var inst_107249 = (new cljs.core.PersistentVector(null,2,(5),inst_107245,inst_107248,null));
var inst_107250__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107244,inst_107249);
var state_107390__$1 = (function (){var statearr_107476 = state_107390;
(statearr_107476[(12)] = inst_107243);

(statearr_107476[(34)] = inst_107250__$1);

return statearr_107476;
})();
if(cljs.core.truth_(inst_107250__$1)){
var statearr_107477_107620 = state_107390__$1;
(statearr_107477_107620[(1)] = (67));

} else {
var statearr_107478_107621 = state_107390__$1;
(statearr_107478_107621[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (103))){
var inst_107352 = (state_107390[(31)]);
var inst_107377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107378 = [acc,inst_107352];
var inst_107379 = (new cljs.core.PersistentVector(null,2,(5),inst_107377,inst_107378,null));
var state_107390__$1 = state_107390;
var statearr_107479_107622 = state_107390__$1;
(statearr_107479_107622[(2)] = inst_107379);

(statearr_107479_107622[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (51))){
var inst_107119 = (state_107390[(7)]);
var inst_107202 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = state_107390;
var statearr_107480_107623 = state_107390__$1;
(statearr_107480_107623[(2)] = inst_107202);

(statearr_107480_107623[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (25))){
var inst_107143 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107481_107624 = state_107390__$1;
(statearr_107481_107624[(2)] = inst_107143);

(statearr_107481_107624[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (34))){
var inst_107166 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107482_107625 = state_107390__$1;
(statearr_107482_107625[(2)] = inst_107166);

(statearr_107482_107625[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (17))){
var inst_107123 = (state_107390[(25)]);
var state_107390__$1 = state_107390;
var statearr_107483_107626 = state_107390__$1;
(statearr_107483_107626[(2)] = inst_107123);

(statearr_107483_107626[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (3))){
var inst_107092 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107484_107627 = state_107390__$1;
(statearr_107484_107627[(2)] = inst_107092);


cljs.core.async.impl.ioc_helpers.process_exception(state_107390__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (12))){
var inst_107113 = (state_107390[(22)]);
var inst_107117 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107113,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_107390__$1 = state_107390;
var statearr_107485_107628 = state_107390__$1;
(statearr_107485_107628[(2)] = inst_107117);

(statearr_107485_107628[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (2))){
var inst_107388 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107390__$1,inst_107388);
} else {
if((state_val_107391 === (66))){
var inst_107344 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107486_107629 = state_107390__$1;
(statearr_107486_107629[(2)] = inst_107344);

(statearr_107486_107629[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (23))){
var state_107390__$1 = state_107390;
var statearr_107487_107630 = state_107390__$1;
(statearr_107487_107630[(2)] = true);

(statearr_107487_107630[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (47))){
var inst_107199 = (state_107390[(27)]);
var inst_107119 = (state_107390[(7)]);
var inst_107199__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = (function (){var statearr_107488 = state_107390;
(statearr_107488[(27)] = inst_107199__$1);

return statearr_107488;
})();
if(cljs.core.truth_(inst_107199__$1)){
var statearr_107489_107631 = state_107390__$1;
(statearr_107489_107631[(1)] = (50));

} else {
var statearr_107490_107632 = state_107390__$1;
(statearr_107490_107632[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (35))){
var inst_107157 = (state_107390[(16)]);
var inst_107171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_107157);
var state_107390__$1 = (function (){var statearr_107491 = state_107390;
(statearr_107491[(28)] = inst_107171);

return statearr_107491;
})();
if(cljs.core.truth_(inst_107172)){
var statearr_107492_107633 = state_107390__$1;
(statearr_107492_107633[(1)] = (38));

} else {
var statearr_107493_107634 = state_107390__$1;
(statearr_107493_107634[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (82))){
var inst_107289 = (state_107390[(15)]);
var inst_107303 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_107304 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_107303,inst_107289);
var state_107390__$1 = state_107390;
var statearr_107494_107635 = state_107390__$1;
(statearr_107494_107635[(2)] = inst_107304);

(statearr_107494_107635[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (76))){
var inst_107342 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107495_107636 = state_107390__$1;
(statearr_107495_107636[(2)] = inst_107342);

(statearr_107495_107636[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (97))){
var inst_107130 = (state_107390[(14)]);
var inst_107352 = (state_107390[(31)]);
var inst_107351 = (state_107390[(32)]);
var inst_107360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107361 = cljs.core.PersistentVector.EMPTY;
var inst_107362 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_107130,inst_107361);
var inst_107363 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_107362,inst_107351);
var inst_107364 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_107130,inst_107363);
var inst_107365 = [inst_107364,inst_107352];
var inst_107366 = (new cljs.core.PersistentVector(null,2,(5),inst_107360,inst_107365,null));
var state_107390__$1 = state_107390;
var statearr_107496_107637 = state_107390__$1;
(statearr_107496_107637[(2)] = inst_107366);

(statearr_107496_107637[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (19))){
var inst_107128 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107497_107638 = state_107390__$1;
(statearr_107497_107638[(2)] = inst_107128);

(statearr_107497_107638[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (57))){
var inst_107221 = (state_107390[(2)]);
var inst_107222 = fluree.db.util.async.throw_err(inst_107221);
var state_107390__$1 = (function (){var statearr_107498 = state_107390;
(statearr_107498[(10)] = inst_107222);

return statearr_107498;
})();
if(cljs.core.truth_(fuel)){
var statearr_107499_107639 = state_107390__$1;
(statearr_107499_107639[(1)] = (58));

} else {
var statearr_107500_107640 = state_107390__$1;
(statearr_107500_107640[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (68))){
var inst_107119 = (state_107390[(7)]);
var inst_107253 = flake.o;
var inst_107254 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_107119);
var inst_107255 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_107253,inst_107254);
var state_107390__$1 = state_107390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107390__$1,(70),inst_107255);
} else {
if((state_val_107391 === (11))){
var inst_107113 = (state_107390[(22)]);
var state_107390__$1 = state_107390;
var statearr_107501_107641 = state_107390__$1;
(statearr_107501_107641[(2)] = inst_107113);

(statearr_107501_107641[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (9))){
var state_107390__$1 = state_107390;
var statearr_107502_107642 = state_107390__$1;
(statearr_107502_107642[(2)] = pred_spec);

(statearr_107502_107642[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (5))){
var inst_107102 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_107103 = (inst_107102 == null);
var state_107390__$1 = state_107390;
var statearr_107503_107643 = state_107390__$1;
(statearr_107503_107643[(2)] = inst_107103);

(statearr_107503_107643[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (83))){
var inst_107289 = (state_107390[(15)]);
var state_107390__$1 = state_107390;
var statearr_107504_107644 = state_107390__$1;
(statearr_107504_107644[(2)] = inst_107289);

(statearr_107504_107644[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (14))){
var inst_107120 = (state_107390[(30)]);
var state_107390__$1 = state_107390;
var statearr_107505_107645 = state_107390__$1;
(statearr_107505_107645[(2)] = inst_107120);

(statearr_107505_107645[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (45))){
var inst_107197 = (state_107390[(26)]);
var inst_107197__$1 = cljs.core.not(recur_QMARK_);
var state_107390__$1 = (function (){var statearr_107506 = state_107390;
(statearr_107506[(26)] = inst_107197__$1);

return statearr_107506;
})();
if(inst_107197__$1){
var statearr_107507_107646 = state_107390__$1;
(statearr_107507_107646[(1)] = (47));

} else {
var statearr_107508_107647 = state_107390__$1;
(statearr_107508_107647[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (53))){
var inst_107119 = (state_107390[(7)]);
var inst_107209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107210 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_107211 = (new cljs.core.PersistentVector(null,3,(5),inst_107209,inst_107210,null));
var inst_107212 = cljs.core.select_keys(inst_107119,inst_107211);
var inst_107213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107216 = flake.o;
var inst_107217 = [inst_107216];
var inst_107218 = (new cljs.core.PersistentVector(null,1,(5),inst_107215,inst_107217,null));
var inst_107219 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_107218);
var state_107390__$1 = (function (){var statearr_107509 = state_107390;
(statearr_107509[(29)] = inst_107213);

(statearr_107509[(33)] = inst_107212);

return statearr_107509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107390__$1,(57),inst_107219);
} else {
if((state_val_107391 === (78))){
var inst_107292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107293 = ["_id"];
var inst_107294 = flake.o;
var inst_107295 = [inst_107294];
var inst_107296 = cljs.core.PersistentHashMap.fromArrays(inst_107293,inst_107295);
var inst_107297 = [inst_107296,offset_map];
var inst_107298 = (new cljs.core.PersistentVector(null,2,(5),inst_107292,inst_107297,null));
var state_107390__$1 = state_107390;
var statearr_107510_107648 = state_107390__$1;
(statearr_107510_107648[(2)] = inst_107298);

(statearr_107510_107648[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (26))){
var inst_107119 = (state_107390[(7)]);
var inst_107148 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_107119);
var state_107390__$1 = state_107390;
var statearr_107511_107649 = state_107390__$1;
(statearr_107511_107649[(2)] = inst_107148);

(statearr_107511_107649[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (16))){
var inst_107119 = (state_107390[(7)]);
var inst_107130 = (state_107390[(2)]);
var inst_107132 = (inst_107119 == null);
var inst_107133 = cljs.core.not(inst_107132);
var state_107390__$1 = (function (){var statearr_107512 = state_107390;
(statearr_107512[(14)] = inst_107130);

return statearr_107512;
})();
if(inst_107133){
var statearr_107513_107650 = state_107390__$1;
(statearr_107513_107650[(1)] = (20));

} else {
var statearr_107514_107651 = state_107390__$1;
(statearr_107514_107651[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (81))){
var inst_107300 = (state_107390[(35)]);
var inst_107315 = (state_107390[(2)]);
var inst_107316 = fluree.db.util.async.throw_err(inst_107315);
var inst_107317 = [inst_107316,offset_map];
var inst_107318 = (new cljs.core.PersistentVector(null,2,(5),inst_107300,inst_107317,null));
var state_107390__$1 = state_107390;
var statearr_107515_107652 = state_107390__$1;
(statearr_107515_107652[(2)] = inst_107318);

(statearr_107515_107652[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (79))){
var inst_107300 = cljs.core.PersistentVector.EMPTY_NODE;
var state_107390__$1 = (function (){var statearr_107516 = state_107390;
(statearr_107516[(35)] = inst_107300);

return statearr_107516;
})();
if(cljs.core.truth_(fuel)){
var statearr_107517_107653 = state_107390__$1;
(statearr_107517_107653[(1)] = (82));

} else {
var statearr_107518_107654 = state_107390__$1;
(statearr_107518_107654[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (38))){
var inst_107157 = (state_107390[(16)]);
var inst_107174 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_107157,cljs.core.dec);
var state_107390__$1 = state_107390;
var statearr_107519_107655 = state_107390__$1;
(statearr_107519_107655[(2)] = inst_107174);

(statearr_107519_107655[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (98))){
var inst_107351 = (state_107390[(32)]);
var inst_107368 = (inst_107351 == null);
var inst_107369 = cljs.core.not(inst_107368);
var state_107390__$1 = state_107390;
if(inst_107369){
var statearr_107520_107656 = state_107390__$1;
(statearr_107520_107656[(1)] = (100));

} else {
var statearr_107521_107657 = state_107390__$1;
(statearr_107521_107657[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (87))){
var inst_107313 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107390__$1,(81),inst_107313);
} else {
if((state_val_107391 === (30))){
var inst_107152 = (state_107390[(18)]);
var state_107390__$1 = state_107390;
var statearr_107522_107658 = state_107390__$1;
(statearr_107522_107658[(2)] = inst_107152);

(statearr_107522_107658[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (73))){
var inst_107276 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107276)){
var statearr_107523_107659 = state_107390__$1;
(statearr_107523_107659[(1)] = (74));

} else {
var statearr_107524_107660 = state_107390__$1;
(statearr_107524_107660[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (96))){
var inst_107358 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107358)){
var statearr_107525_107661 = state_107390__$1;
(statearr_107525_107661[(1)] = (97));

} else {
var statearr_107526_107662 = state_107390__$1;
(statearr_107526_107662[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (10))){
var inst_107113 = (state_107390[(22)]);
var inst_107113__$1 = (state_107390[(2)]);
var inst_107114 = cljs.core.contains_QMARK_(inst_107113__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_107390__$1 = (function (){var statearr_107527 = state_107390;
(statearr_107527[(22)] = inst_107113__$1);

return statearr_107527;
})();
if(inst_107114){
var statearr_107528_107663 = state_107390__$1;
(statearr_107528_107663[(1)] = (11));

} else {
var statearr_107529_107664 = state_107390__$1;
(statearr_107529_107664[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (18))){
var inst_107119 = (state_107390[(7)]);
var inst_107126 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = state_107390;
var statearr_107530_107665 = state_107390__$1;
(statearr_107530_107665[(2)] = inst_107126);

(statearr_107530_107665[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (105))){
var inst_107382 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107531_107666 = state_107390__$1;
(statearr_107531_107666[(2)] = inst_107382);

(statearr_107531_107666[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (52))){
var inst_107204 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107532_107667 = state_107390__$1;
(statearr_107532_107667[(2)] = inst_107204);

(statearr_107532_107667[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (67))){
var inst_107250 = (state_107390[(34)]);
var state_107390__$1 = state_107390;
var statearr_107533_107668 = state_107390__$1;
(statearr_107533_107668[(2)] = inst_107250);

(statearr_107533_107668[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (71))){
var inst_107119 = (state_107390[(7)]);
var inst_107273 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_107119);
var state_107390__$1 = state_107390;
var statearr_107534_107669 = state_107390__$1;
(statearr_107534_107669[(2)] = inst_107273);

(statearr_107534_107669[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (42))){
var inst_107152 = (state_107390[(18)]);
var state_107390__$1 = state_107390;
var statearr_107535_107670 = state_107390__$1;
(statearr_107535_107670[(2)] = inst_107152);

(statearr_107535_107670[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (80))){
var inst_107320 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
var statearr_107536_107671 = state_107390__$1;
(statearr_107536_107671[(2)] = inst_107320);

(statearr_107536_107671[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (37))){
var inst_107354 = (state_107390[(24)]);
var inst_107351 = (state_107390[(32)]);
var inst_107350 = (state_107390[(2)]);
var inst_107351__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_107350,(0),null);
var inst_107352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_107350,(1),null);
var inst_107353 = (inst_107351__$1 == null);
var inst_107354__$1 = cljs.core.not(inst_107353);
var state_107390__$1 = (function (){var statearr_107537 = state_107390;
(statearr_107537[(31)] = inst_107352);

(statearr_107537[(24)] = inst_107354__$1);

(statearr_107537[(32)] = inst_107351__$1);

return statearr_107537;
})();
if(inst_107354__$1){
var statearr_107538_107672 = state_107390__$1;
(statearr_107538_107672[(1)] = (94));

} else {
var statearr_107539_107673 = state_107390__$1;
(statearr_107539_107673[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (63))){
var inst_107234 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107390__$1,(56),inst_107234);
} else {
if((state_val_107391 === (94))){
var inst_107152 = (state_107390[(18)]);
var state_107390__$1 = state_107390;
var statearr_107540_107674 = state_107390__$1;
(statearr_107540_107674[(2)] = inst_107152);

(statearr_107540_107674[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (8))){
var inst_107108 = flake.p;
var inst_107109 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_107110 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_107108,inst_107109);
var state_107390__$1 = state_107390;
var statearr_107541_107675 = state_107390__$1;
(statearr_107541_107675[(2)] = inst_107110);

(statearr_107541_107675[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (49))){
var inst_107207 = (state_107390[(2)]);
var state_107390__$1 = state_107390;
if(cljs.core.truth_(inst_107207)){
var statearr_107542_107676 = state_107390__$1;
(statearr_107542_107676[(1)] = (53));

} else {
var statearr_107543_107677 = state_107390__$1;
(statearr_107543_107677[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107391 === (84))){
var inst_107307 = (state_107390[(2)]);
var state_107390__$1 = (function (){var statearr_107544 = state_107390;
(statearr_107544[(11)] = inst_107307);

return statearr_107544;
})();
var statearr_107545_107678 = state_107390__$1;
(statearr_107545_107678[(1)] = (85));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$state_machine__99037__auto__ = null;
var fluree$db$query$fql$state_machine__99037__auto____0 = (function (){
var statearr_107547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107547[(0)] = fluree$db$query$fql$state_machine__99037__auto__);

(statearr_107547[(1)] = (1));

return statearr_107547;
});
var fluree$db$query$fql$state_machine__99037__auto____1 = (function (state_107390){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_107390);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e107548){if((e107548 instanceof Object)){
var ex__99040__auto__ = e107548;
var statearr_107549_107679 = state_107390;
(statearr_107549_107679[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107390);

return cljs.core.cst$kw$recur;
} else {
throw e107548;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__107680 = state_107390;
state_107390 = G__107680;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99037__auto__ = function(state_107390){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99037__auto____1.call(this,state_107390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99037__auto____0;
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99037__auto____1;
return fluree$db$query$fql$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_107550 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_107550[(6)] = c__99059__auto__);

return statearr_107550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10;

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,((function (lookup_specs,or__4131__auto__,coll_id){
return (function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
});})(lookup_specs,or__4131__auto__,coll_id))
);
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_107856){
var state_val_107857 = (state_107856[(1)]);
if((state_val_107857 === (7))){
var inst_107696 = (state_107856[(7)]);
var state_107856__$1 = state_107856;
var statearr_107858_107947 = state_107856__$1;
(statearr_107858_107947[(2)] = inst_107696);

(statearr_107858_107947[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (59))){
var inst_107844 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107859_107948 = state_107856__$1;
(statearr_107859_107948[(2)] = inst_107844);

(statearr_107859_107948[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (20))){
var state_107856__$1 = state_107856;
var statearr_107860_107949 = state_107856__$1;
(statearr_107860_107949[(2)] = fuel);

(statearr_107860_107949[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (58))){
var inst_107738 = (state_107856[(8)]);
var state_107856__$1 = state_107856;
var statearr_107861_107950 = state_107856__$1;
(statearr_107861_107950[(2)] = inst_107738);

(statearr_107861_107950[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (27))){
var inst_107736 = (state_107856[(9)]);
var inst_107838 = (state_107856[(2)]);
var state_107856__$1 = (function (){var statearr_107862 = state_107856;
(statearr_107862[(10)] = inst_107838);

return statearr_107862;
})();
if(cljs.core.truth_(inst_107736)){
var statearr_107863_107951 = state_107856__$1;
(statearr_107863_107951[(1)] = (54));

} else {
var statearr_107864_107952 = state_107856__$1;
(statearr_107864_107952[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (1))){
var state_107856__$1 = state_107856;
var statearr_107865_107953 = state_107856__$1;
(statearr_107865_107953[(2)] = null);

(statearr_107865_107953[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (24))){
var state_107856__$1 = state_107856;
var statearr_107866_107954 = state_107856__$1;
(statearr_107866_107954[(2)] = null);

(statearr_107866_107954[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (55))){
var inst_107737 = (state_107856[(11)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107737)){
var statearr_107867_107955 = state_107856__$1;
(statearr_107867_107955[(1)] = (57));

} else {
var statearr_107868_107956 = state_107856__$1;
(statearr_107868_107956[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (39))){
var inst_107795 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107795)){
var statearr_107869_107957 = state_107856__$1;
(statearr_107869_107957[(1)] = (40));

} else {
var statearr_107870_107958 = state_107856__$1;
(statearr_107870_107958[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (46))){
var inst_107712 = (state_107856[(12)]);
var inst_107807 = (state_107856[(13)]);
var inst_107806 = (state_107856[(2)]);
var inst_107807__$1 = fluree.db.util.async.throw_err(inst_107806);
var inst_107808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107809 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_107810 = (new cljs.core.PersistentVector(null,4,(5),inst_107808,inst_107809,null));
var inst_107811 = cljs.core.select_keys(inst_107712,inst_107810);
var inst_107812 = cljs.core.empty_QMARK_(inst_107807__$1);
var state_107856__$1 = (function (){var statearr_107871 = state_107856;
(statearr_107871[(14)] = inst_107811);

(statearr_107871[(13)] = inst_107807__$1);

return statearr_107871;
})();
if(inst_107812){
var statearr_107872_107959 = state_107856__$1;
(statearr_107872_107959[(1)] = (47));

} else {
var statearr_107873_107960 = state_107856__$1;
(statearr_107873_107960[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_107856,(3),Error,null,(2));
var inst_107692 = cljs.core.seq(reverse_refs_specs);
var inst_107693 = cljs.core.first(inst_107692);
var inst_107694 = cljs.core.next(inst_107692);
var inst_107695 = reverse_refs_specs;
var inst_107696 = null;
var state_107856__$1 = (function (){var statearr_107874 = state_107856;
(statearr_107874[(15)] = inst_107695);

(statearr_107874[(16)] = inst_107694);

(statearr_107874[(17)] = inst_107693);

(statearr_107874[(7)] = inst_107696);

return statearr_107874;
})();
var statearr_107875_107961 = state_107856__$1;
(statearr_107875_107961[(2)] = null);

(statearr_107875_107961[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (54))){
var inst_107736 = (state_107856[(9)]);
var state_107856__$1 = state_107856;
var statearr_107876_107962 = state_107856__$1;
(statearr_107876_107962[(2)] = inst_107736);

(statearr_107876_107962[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (15))){
var inst_107725 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107877_107963 = state_107856__$1;
(statearr_107877_107963[(2)] = inst_107725);

(statearr_107877_107963[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (48))){
var state_107856__$1 = state_107856;
if(cljs.core.truth_(fuel)){
var statearr_107878_107964 = state_107856__$1;
(statearr_107878_107964[(1)] = (50));

} else {
var statearr_107879_107965 = state_107856__$1;
(statearr_107879_107965[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (50))){
var inst_107807 = (state_107856[(13)]);
var inst_107816 = cljs.core.count(inst_107807);
var inst_107817 = fluree.db.query.fql.add_fuel(fuel,inst_107816,max_fuel);
var state_107856__$1 = state_107856;
var statearr_107880_107966 = state_107856__$1;
(statearr_107880_107966[(2)] = inst_107817);

(statearr_107880_107966[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (21))){
var inst_107747 = (state_107856[(18)]);
var state_107856__$1 = state_107856;
var statearr_107881_107967 = state_107856__$1;
(statearr_107881_107967[(2)] = inst_107747);

(statearr_107881_107967[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (31))){
var inst_107735 = (state_107856[(19)]);
var inst_107770 = (state_107856[(20)]);
var inst_107783 = (inst_107770 >= inst_107735);
var state_107856__$1 = state_107856;
var statearr_107883_107968 = state_107856__$1;
(statearr_107883_107968[(2)] = inst_107783);

(statearr_107883_107968[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (32))){
var inst_107735 = (state_107856[(19)]);
var state_107856__$1 = state_107856;
var statearr_107884_107969 = state_107856__$1;
(statearr_107884_107969[(2)] = inst_107735);

(statearr_107884_107969[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (40))){
var inst_107778 = (state_107856[(21)]);
var inst_107771 = (state_107856[(22)]);
var inst_107770 = (state_107856[(20)]);
var inst_107797 = (inst_107770 + (1));
var tmp107882 = inst_107771;
var inst_107769 = inst_107778;
var inst_107770__$1 = inst_107797;
var inst_107771__$1 = tmp107882;
var state_107856__$1 = (function (){var statearr_107885 = state_107856;
(statearr_107885[(23)] = inst_107769);

(statearr_107885[(22)] = inst_107771__$1);

(statearr_107885[(20)] = inst_107770__$1);

return statearr_107885;
})();
var statearr_107886_107970 = state_107856__$1;
(statearr_107886_107970[(2)] = null);

(statearr_107886_107970[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (56))){
var inst_107703 = (state_107856[(24)]);
var inst_107696 = (state_107856[(7)]);
var inst_107838 = (state_107856[(10)]);
var inst_107846 = (state_107856[(2)]);
var inst_107847 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_107696,inst_107846,inst_107838);
var inst_107695 = inst_107703;
var inst_107696__$1 = inst_107847;
var state_107856__$1 = (function (){var statearr_107887 = state_107856;
(statearr_107887[(15)] = inst_107695);

(statearr_107887[(7)] = inst_107696__$1);

return statearr_107887;
})();
var statearr_107888_107971 = state_107856__$1;
(statearr_107888_107971[(2)] = null);

(statearr_107888_107971[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (33))){
var inst_107786 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107889_107972 = state_107856__$1;
(statearr_107889_107972[(2)] = inst_107786);

(statearr_107889_107972[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (13))){
var state_107856__$1 = state_107856;
var statearr_107890_107973 = state_107856__$1;
(statearr_107890_107973[(2)] = true);

(statearr_107890_107973[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (22))){
var inst_107751 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107751)){
var statearr_107891_107974 = state_107856__$1;
(statearr_107891_107974[(1)] = (23));

} else {
var statearr_107892_107975 = state_107856__$1;
(statearr_107892_107975[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (36))){
var inst_107836 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107893_107976 = state_107856__$1;
(statearr_107893_107976[(2)] = inst_107836);

(statearr_107893_107976[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (41))){
var state_107856__$1 = state_107856;
var statearr_107894_107977 = state_107856__$1;
(statearr_107894_107977[(1)] = (43));



return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (43))){
var inst_107777 = (state_107856[(25)]);
var inst_107801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107802 = [inst_107777];
var inst_107803 = (new cljs.core.PersistentVector(null,1,(5),inst_107801,inst_107802,null));
var inst_107804 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_107803);
var state_107856__$1 = state_107856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107856__$1,(46),inst_107804);
} else {
if((state_val_107857 === (29))){
var inst_107735 = (state_107856[(19)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107735)){
var statearr_107896_107978 = state_107856__$1;
(statearr_107896_107978[(1)] = (31));

} else {
var statearr_107897_107979 = state_107856__$1;
(statearr_107897_107979[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (44))){
var state_107856__$1 = state_107856;
var statearr_107898_107980 = state_107856__$1;
(statearr_107898_107980[(2)] = null);

(statearr_107898_107980[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (6))){
var inst_107852 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107899_107981 = state_107856__$1;
(statearr_107899_107981[(2)] = inst_107852);


cljs.core.async.impl.ioc_helpers.process_exception(state_107856__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (28))){
var inst_107779 = (state_107856[(26)]);
var state_107856__$1 = state_107856;
var statearr_107900_107982 = state_107856__$1;
(statearr_107900_107982[(2)] = inst_107779);

(statearr_107900_107982[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (51))){
var state_107856__$1 = state_107856;
var statearr_107901_107983 = state_107856__$1;
(statearr_107901_107983[(2)] = null);

(statearr_107901_107983[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (25))){
var inst_107747 = (state_107856[(18)]);
var inst_107757 = (state_107856[(2)]);
var inst_107765 = cljs.core.seq(inst_107747);
var inst_107766 = cljs.core.first(inst_107765);
var inst_107767 = cljs.core.next(inst_107765);
var inst_107768 = cljs.core.PersistentVector.EMPTY;
var inst_107769 = inst_107747;
var inst_107770 = (0);
var inst_107771 = inst_107768;
var state_107856__$1 = (function (){var statearr_107902 = state_107856;
(statearr_107902[(27)] = inst_107766);

(statearr_107902[(28)] = inst_107767);

(statearr_107902[(23)] = inst_107769);

(statearr_107902[(22)] = inst_107771);

(statearr_107902[(20)] = inst_107770);

(statearr_107902[(29)] = inst_107757);

return statearr_107902;
})();
var statearr_107903_107984 = state_107856__$1;
(statearr_107903_107984[(2)] = null);

(statearr_107903_107984[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (34))){
var inst_107771 = (state_107856[(22)]);
var state_107856__$1 = state_107856;
var statearr_107904_107985 = state_107856__$1;
(statearr_107904_107985[(2)] = inst_107771);

(statearr_107904_107985[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (17))){
var inst_107712 = (state_107856[(12)]);
var state_107856__$1 = state_107856;
var statearr_107905_107986 = state_107856__$1;
(statearr_107905_107986[(2)] = inst_107712);

(statearr_107905_107986[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (3))){
var inst_107681 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107906_107987 = state_107856__$1;
(statearr_107906_107987[(2)] = inst_107681);


cljs.core.async.impl.ioc_helpers.process_exception(state_107856__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (12))){
var inst_107728 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107728)){
var statearr_107907_107988 = state_107856__$1;
(statearr_107907_107988[(1)] = (16));

} else {
var statearr_107908_107989 = state_107856__$1;
(statearr_107908_107989[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (2))){
var inst_107854 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_107856__$1,inst_107854);
} else {
if((state_val_107857 === (23))){
var inst_107747 = (state_107856[(18)]);
var inst_107753 = cljs.core.count(inst_107747);
var inst_107754 = fluree.db.query.fql.add_fuel(fuel,inst_107753,max_fuel);
var state_107856__$1 = state_107856;
var statearr_107909_107990 = state_107856__$1;
(statearr_107909_107990[(2)] = inst_107754);

(statearr_107909_107990[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (47))){
var inst_107771 = (state_107856[(22)]);
var state_107856__$1 = state_107856;
var statearr_107910_107991 = state_107856__$1;
(statearr_107910_107991[(2)] = inst_107771);

(statearr_107910_107991[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (35))){
var inst_107734 = (state_107856[(30)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107734)){
var statearr_107911_107992 = state_107856__$1;
(statearr_107911_107992[(1)] = (37));

} else {
var statearr_107912_107993 = state_107856__$1;
(statearr_107912_107993[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (19))){
var inst_107747 = (state_107856[(18)]);
var inst_107744 = (state_107856[(2)]);
var inst_107745 = fluree.db.util.async.throw_err(inst_107744);
var inst_107746 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_107745);
var inst_107747__$1 = cljs.core.not_empty(inst_107746);
var state_107856__$1 = (function (){var statearr_107913 = state_107856;
(statearr_107913[(18)] = inst_107747__$1);

return statearr_107913;
})();
if(cljs.core.truth_(inst_107747__$1)){
var statearr_107914_107994 = state_107856__$1;
(statearr_107914_107994[(1)] = (20));

} else {
var statearr_107915_107995 = state_107856__$1;
(statearr_107915_107995[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (57))){
var inst_107737 = (state_107856[(11)]);
var state_107856__$1 = state_107856;
var statearr_107916_107996 = state_107856__$1;
(statearr_107916_107996[(2)] = inst_107737);

(statearr_107916_107996[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (11))){
var state_107856__$1 = state_107856;
var statearr_107917_107997 = state_107856__$1;
(statearr_107917_107997[(2)] = false);

(statearr_107917_107997[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (9))){
var inst_107850 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107918_107998 = state_107856__$1;
(statearr_107918_107998[(2)] = inst_107850);

(statearr_107918_107998[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (5))){
var inst_107702 = (state_107856[(31)]);
var inst_107695 = (state_107856[(15)]);
var inst_107701 = cljs.core.seq(inst_107695);
var inst_107702__$1 = cljs.core.first(inst_107701);
var inst_107703 = cljs.core.next(inst_107701);
var inst_107704 = cljs.core.not(inst_107702__$1);
var state_107856__$1 = (function (){var statearr_107919 = state_107856;
(statearr_107919[(31)] = inst_107702__$1);

(statearr_107919[(24)] = inst_107703);

return statearr_107919;
})();
if(inst_107704){
var statearr_107920_107999 = state_107856__$1;
(statearr_107920_107999[(1)] = (7));

} else {
var statearr_107921_108000 = state_107856__$1;
(statearr_107921_108000[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (14))){
var state_107856__$1 = state_107856;
var statearr_107922_108001 = state_107856__$1;
(statearr_107922_108001[(2)] = false);

(statearr_107922_108001[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (45))){
var inst_107832 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107923_108002 = state_107856__$1;
(statearr_107923_108002[(2)] = inst_107832);

(statearr_107923_108002[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (53))){
var inst_107771 = (state_107856[(22)]);
var inst_107823 = (state_107856[(2)]);
var inst_107824 = fluree.db.util.async.throw_err(inst_107823);
var inst_107825 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_107771,inst_107824);
var state_107856__$1 = state_107856;
var statearr_107924_108003 = state_107856__$1;
(statearr_107924_108003[(2)] = inst_107825);

(statearr_107924_108003[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (26))){
var inst_107777 = (state_107856[(25)]);
var inst_107769 = (state_107856[(23)]);
var inst_107779 = (state_107856[(26)]);
var inst_107776 = cljs.core.seq(inst_107769);
var inst_107777__$1 = cljs.core.first(inst_107776);
var inst_107778 = cljs.core.next(inst_107776);
var inst_107779__$1 = cljs.core.not(inst_107777__$1);
var state_107856__$1 = (function (){var statearr_107925 = state_107856;
(statearr_107925[(25)] = inst_107777__$1);

(statearr_107925[(21)] = inst_107778);

(statearr_107925[(26)] = inst_107779__$1);

return statearr_107925;
})();
if(inst_107779__$1){
var statearr_107926_108004 = state_107856__$1;
(statearr_107926_108004[(1)] = (28));

} else {
var statearr_107927_108005 = state_107856__$1;
(statearr_107927_108005[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (16))){
var inst_107712 = (state_107856[(12)]);
var inst_107730 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_107712);
var state_107856__$1 = state_107856;
var statearr_107928_108006 = state_107856__$1;
(statearr_107928_108006[(2)] = inst_107730);

(statearr_107928_108006[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (38))){
var inst_107734 = (state_107856[(30)]);
var state_107856__$1 = state_107856;
var statearr_107929_108007 = state_107856__$1;
(statearr_107929_108007[(2)] = inst_107734);

(statearr_107929_108007[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (30))){
var inst_107788 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107788)){
var statearr_107930_108008 = state_107856__$1;
(statearr_107930_108008[(1)] = (34));

} else {
var statearr_107931_108009 = state_107856__$1;
(statearr_107931_108009[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (10))){
var inst_107712 = (state_107856[(12)]);
var inst_107717 = inst_107712.cljs$lang$protocol_mask$partition0$;
var inst_107718 = (inst_107717 & (64));
var inst_107719 = inst_107712.cljs$core$ISeq$;
var inst_107720 = (cljs.core.PROTOCOL_SENTINEL === inst_107719);
var inst_107721 = ((inst_107718) || (inst_107720));
var state_107856__$1 = state_107856;
if(cljs.core.truth_(inst_107721)){
var statearr_107932_108010 = state_107856__$1;
(statearr_107932_108010[(1)] = (13));

} else {
var statearr_107933_108011 = state_107856__$1;
(statearr_107933_108011[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (18))){
var inst_107711 = (state_107856[(32)]);
var inst_107733 = (state_107856[(2)]);
var inst_107734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107733,cljs.core.cst$kw$offset);
var inst_107735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107733,cljs.core.cst$kw$limit);
var inst_107736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107733,cljs.core.cst$kw$as);
var inst_107737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107733,cljs.core.cst$kw$name);
var inst_107738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_107733,cljs.core.cst$kw$p);
var inst_107739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107740 = [subject_id,inst_107711];
var inst_107741 = (new cljs.core.PersistentVector(null,2,(5),inst_107739,inst_107740,null));
var inst_107742 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_107741);
var state_107856__$1 = (function (){var statearr_107934 = state_107856;
(statearr_107934[(19)] = inst_107735);

(statearr_107934[(9)] = inst_107736);

(statearr_107934[(11)] = inst_107737);

(statearr_107934[(30)] = inst_107734);

(statearr_107934[(8)] = inst_107738);

return statearr_107934;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107856__$1,(19),inst_107742);
} else {
if((state_val_107857 === (52))){
var inst_107811 = (state_107856[(14)]);
var inst_107807 = (state_107856[(13)]);
var inst_107820 = (state_107856[(2)]);
var inst_107821 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_107811,inst_107807) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_107811,inst_107807));
var state_107856__$1 = (function (){var statearr_107935 = state_107856;
(statearr_107935[(33)] = inst_107820);

return statearr_107935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_107856__$1,(53),inst_107821);
} else {
if((state_val_107857 === (42))){
var inst_107834 = (state_107856[(2)]);
var state_107856__$1 = state_107856;
var statearr_107936_108012 = state_107856__$1;
(statearr_107936_108012[(2)] = inst_107834);

(statearr_107936_108012[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (37))){
var inst_107734 = (state_107856[(30)]);
var inst_107770 = (state_107856[(20)]);
var inst_107792 = (inst_107770 < inst_107734);
var state_107856__$1 = state_107856;
var statearr_107937_108013 = state_107856__$1;
(statearr_107937_108013[(2)] = inst_107792);

(statearr_107937_108013[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (8))){
var inst_107712 = (state_107856[(12)]);
var inst_107702 = (state_107856[(31)]);
var inst_107711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_107702,(0),null);
var inst_107712__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_107702,(1),null);
var inst_107714 = (inst_107712__$1 == null);
var inst_107715 = cljs.core.not(inst_107714);
var state_107856__$1 = (function (){var statearr_107938 = state_107856;
(statearr_107938[(12)] = inst_107712__$1);

(statearr_107938[(32)] = inst_107711);

return statearr_107938;
})();
if(inst_107715){
var statearr_107939_108014 = state_107856__$1;
(statearr_107939_108014[(1)] = (10));

} else {
var statearr_107940_108015 = state_107856__$1;
(statearr_107940_108015[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_107857 === (49))){
var inst_107778 = (state_107856[(21)]);
var inst_107770 = (state_107856[(20)]);
var inst_107827 = (state_107856[(2)]);
var inst_107828 = (inst_107770 + (1));
var inst_107769 = inst_107778;
var inst_107770__$1 = inst_107828;
var inst_107771 = inst_107827;
var state_107856__$1 = (function (){var statearr_107941 = state_107856;
(statearr_107941[(23)] = inst_107769);

(statearr_107941[(22)] = inst_107771);

(statearr_107941[(20)] = inst_107770__$1);

return statearr_107941;
})();
var statearr_107942_108016 = state_107856__$1;
(statearr_107942_108016[(2)] = null);

(statearr_107942_108016[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____0 = (function (){
var statearr_107943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107943[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__);

(statearr_107943[(1)] = (1));

return statearr_107943;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____1 = (function (state_107856){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_107856);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e107944){if((e107944 instanceof Object)){
var ex__99040__auto__ = e107944;
var statearr_107945_108017 = state_107856;
(statearr_107945_108017[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_107856);

return cljs.core.cst$kw$recur;
} else {
throw e107944;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__108018 = state_107856;
state_107856 = G__108018;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__ = function(state_107856){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____1.call(this,state_107856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_107946 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_107946[(6)] = c__99059__auto__);

return statearr_107946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null),cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o(f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.cst$kw$depth], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_108132){
var state_val_108133 = (state_108132[(1)]);
if((state_val_108133 === (7))){
var inst_108035 = (state_108132[(7)]);
var state_108132__$1 = state_108132;
var statearr_108134_108183 = state_108132__$1;
(statearr_108134_108183[(2)] = inst_108035);

(statearr_108134_108183[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (20))){
var inst_108079 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
var statearr_108135_108184 = state_108132__$1;
(statearr_108135_108184[(2)] = inst_108079);

(statearr_108135_108184[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (27))){
var inst_108102 = (state_108132[(2)]);
var inst_108103 = fluree.db.util.async.throw_err(inst_108102);
var state_108132__$1 = state_108132;
var statearr_108136_108185 = state_108132__$1;
(statearr_108136_108185[(2)] = inst_108103);

(statearr_108136_108185[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (1))){
var state_108132__$1 = state_108132;
var statearr_108137_108186 = state_108132__$1;
(statearr_108137_108186[(2)] = null);

(statearr_108137_108186[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (24))){
var inst_108035 = (state_108132[(7)]);
var inst_108100 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_108035,pred_spec,f,component_follow_QMARK_,true);
var state_108132__$1 = state_108132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108132__$1,(27),inst_108100);
} else {
if((state_val_108133 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108132,(3),Error,null,(2));
var inst_108031 = cljs.core.seq(new_child_paths);
var inst_108032 = cljs.core.first(inst_108031);
var inst_108033 = cljs.core.next(inst_108031);
var inst_108034 = new_child_paths;
var inst_108035 = acc;
var state_108132__$1 = (function (){var statearr_108138 = state_108132;
(statearr_108138[(8)] = inst_108034);

(statearr_108138[(7)] = inst_108035);

(statearr_108138[(9)] = inst_108032);

(statearr_108138[(10)] = inst_108033);

return statearr_108138;
})();
var statearr_108139_108187 = state_108132__$1;
(statearr_108139_108187[(2)] = null);

(statearr_108139_108187[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (15))){
var inst_108084 = (state_108132[(11)]);
var inst_108084__$1 = (state_108132[(2)]);
var inst_108085 = cljs.core.count(inst_108084__$1);
var inst_108086 = (inst_108085 > (1));
var state_108132__$1 = (function (){var statearr_108140 = state_108132;
(statearr_108140[(11)] = inst_108084__$1);

return statearr_108140;
})();
if(cljs.core.truth_(inst_108086)){
var statearr_108141_108188 = state_108132__$1;
(statearr_108141_108188[(1)] = (21));

} else {
var statearr_108142_108189 = state_108132__$1;
(statearr_108142_108189[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (21))){
var inst_108084 = (state_108132[(11)]);
var inst_108088 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_108084);
var state_108132__$1 = state_108132;
var statearr_108143_108190 = state_108132__$1;
(statearr_108143_108190[(2)] = inst_108088);

(statearr_108143_108190[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (31))){
var inst_108035 = (state_108132[(7)]);
var inst_108042 = (state_108132[(12)]);
var inst_108122 = (state_108132[(2)]);
var inst_108123 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_108035,inst_108122);
var inst_108034 = inst_108042;
var inst_108035__$1 = inst_108123;
var state_108132__$1 = (function (){var statearr_108144 = state_108132;
(statearr_108144[(8)] = inst_108034);

(statearr_108144[(7)] = inst_108035__$1);

return statearr_108144;
})();
var statearr_108145_108191 = state_108132__$1;
(statearr_108145_108191[(2)] = null);

(statearr_108145_108191[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (13))){
var inst_108053 = (state_108132[(13)]);
var inst_108050 = (state_108132[(14)]);
var inst_108061 = inst_108050;
var inst_108062 = inst_108053;
var state_108132__$1 = (function (){var statearr_108146 = state_108132;
(statearr_108146[(15)] = inst_108061);

(statearr_108146[(16)] = inst_108062);

return statearr_108146;
})();
var statearr_108147_108192 = state_108132__$1;
(statearr_108147_108192[(2)] = null);

(statearr_108147_108192[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (22))){
var inst_108084 = (state_108132[(11)]);
var state_108132__$1 = state_108132;
var statearr_108148_108193 = state_108132__$1;
(statearr_108148_108193[(2)] = inst_108084);

(statearr_108148_108193[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (29))){
var inst_108111 = (state_108132[(17)]);
var state_108132__$1 = state_108132;
var statearr_108149_108194 = state_108132__$1;
(statearr_108149_108194[(2)] = inst_108111);

(statearr_108149_108194[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (6))){
var inst_108128 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
var statearr_108150_108195 = state_108132__$1;
(statearr_108150_108195[(2)] = inst_108128);


cljs.core.async.impl.ioc_helpers.process_exception(state_108132__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (28))){
var inst_108107 = (state_108132[(2)]);
var inst_108108 = fluree.db.util.async.throw_err(inst_108107);
var state_108132__$1 = state_108132;
var statearr_108151_108196 = state_108132__$1;
(statearr_108151_108196[(2)] = inst_108108);

(statearr_108151_108196[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (25))){
var inst_108092 = (state_108132[(18)]);
var inst_108105 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_108092,pred_spec,f,component_follow_QMARK_,true);
var state_108132__$1 = state_108132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108132__$1,(28),inst_108105);
} else {
if((state_val_108133 === (17))){
var inst_108081 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
var statearr_108152_108197 = state_108132__$1;
(statearr_108152_108197[(2)] = inst_108081);

(statearr_108152_108197[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (3))){
var inst_108020 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
var statearr_108153_108198 = state_108132__$1;
(statearr_108153_108198[(2)] = inst_108020);


cljs.core.async.impl.ioc_helpers.process_exception(state_108132__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (12))){
var inst_108035 = (state_108132[(7)]);
var inst_108050 = (state_108132[(14)]);
var inst_108050__$1 = (state_108132[(2)]);
var inst_108051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108052 = [k];
var inst_108053 = (new cljs.core.PersistentVector(null,1,(5),inst_108051,inst_108052,null));
var inst_108054 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_108035);
var inst_108055 = fluree.db.query.fql.s(f);
var inst_108056 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_108054,inst_108055);
var inst_108057 = cljs.core.empty_QMARK_(inst_108050__$1);
var inst_108058 = (!(inst_108057));
var inst_108059 = ((inst_108056) && (inst_108058));
var state_108132__$1 = (function (){var statearr_108154 = state_108132;
(statearr_108154[(13)] = inst_108053);

(statearr_108154[(14)] = inst_108050__$1);

return statearr_108154;
})();
if(cljs.core.truth_(inst_108059)){
var statearr_108155_108199 = state_108132__$1;
(statearr_108155_108199[(1)] = (13));

} else {
var statearr_108156_108200 = state_108132__$1;
(statearr_108156_108200[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (2))){
var inst_108130 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108132__$1,inst_108130);
} else {
if((state_val_108133 === (23))){
var inst_108035 = (state_108132[(7)]);
var inst_108091 = (state_108132[(19)]);
var inst_108091__$1 = (state_108132[(2)]);
var inst_108092 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108035,inst_108091__$1);
var inst_108096 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_108035);
var inst_108097 = fluree.db.query.fql.s(f);
var inst_108098 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_108096,inst_108097);
var state_108132__$1 = (function (){var statearr_108157 = state_108132;
(statearr_108157[(19)] = inst_108091__$1);

(statearr_108157[(18)] = inst_108092);

return statearr_108157;
})();
if(inst_108098){
var statearr_108158_108201 = state_108132__$1;
(statearr_108158_108201[(1)] = (24));

} else {
var statearr_108159_108202 = state_108132__$1;
(statearr_108159_108202[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (19))){
var inst_108070 = (state_108132[(20)]);
var state_108132__$1 = state_108132;
var statearr_108160_108203 = state_108132__$1;
(statearr_108160_108203[(2)] = inst_108070);

(statearr_108160_108203[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (11))){
var inst_108041 = (state_108132[(21)]);
var inst_108048 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_108041);
var state_108132__$1 = state_108132;
var statearr_108161_108204 = state_108132__$1;
(statearr_108161_108204[(2)] = inst_108048);

(statearr_108161_108204[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (9))){
var inst_108126 = (state_108132[(2)]);
var state_108132__$1 = state_108132;
var statearr_108162_108205 = state_108132__$1;
(statearr_108162_108205[(2)] = inst_108126);

(statearr_108162_108205[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (5))){
var inst_108034 = (state_108132[(8)]);
var inst_108041 = (state_108132[(21)]);
var inst_108040 = cljs.core.seq(inst_108034);
var inst_108041__$1 = cljs.core.first(inst_108040);
var inst_108042 = cljs.core.next(inst_108040);
var inst_108043 = cljs.core.not(inst_108041__$1);
var state_108132__$1 = (function (){var statearr_108163 = state_108132;
(statearr_108163[(21)] = inst_108041__$1);

(statearr_108163[(12)] = inst_108042);

return statearr_108163;
})();
if(inst_108043){
var statearr_108164_108206 = state_108132__$1;
(statearr_108164_108206[(1)] = (7));

} else {
var statearr_108165_108207 = state_108132__$1;
(statearr_108165_108207[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (14))){
var inst_108053 = (state_108132[(13)]);
var state_108132__$1 = state_108132;
var statearr_108166_108208 = state_108132__$1;
(statearr_108166_108208[(2)] = inst_108053);

(statearr_108166_108208[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (26))){
var inst_108035 = (state_108132[(7)]);
var inst_108091 = (state_108132[(19)]);
var inst_108110 = (state_108132[(2)]);
var inst_108111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108110,(0),null);
var inst_108112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108110,(1),null);
var inst_108113 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_108035);
var inst_108114 = fluree.db.query.fql.s(f);
var inst_108115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_108113,inst_108114);
var inst_108116 = cljs.core.empty_QMARK_(inst_108091);
var inst_108117 = ((inst_108115) || (inst_108116));
var state_108132__$1 = (function (){var statearr_108167 = state_108132;
(statearr_108167[(22)] = inst_108112);

(statearr_108167[(17)] = inst_108111);

return statearr_108167;
})();
if(cljs.core.truth_(inst_108117)){
var statearr_108168_108209 = state_108132__$1;
(statearr_108168_108209[(1)] = (29));

} else {
var statearr_108169_108210 = state_108132__$1;
(statearr_108169_108210[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (16))){
var inst_108034 = (state_108132[(8)]);
var inst_108035 = (state_108132[(7)]);
var inst_108041 = (state_108132[(21)]);
var inst_108032 = (state_108132[(9)]);
var inst_108033 = (state_108132[(10)]);
var inst_108061 = (state_108132[(15)]);
var inst_108062 = (state_108132[(16)]);
var inst_108042 = (state_108132[(12)]);
var inst_108064 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108035,inst_108062);
var inst_108065 = (function (){var G__108027 = inst_108034;
var keys_SINGLEQUOTE_ = inst_108062;
var seq__108038 = inst_108042;
var r = inst_108042;
var first__108030 = inst_108032;
var vec__108037 = inst_108034;
var child_path = inst_108061;
var acc__$1 = inst_108035;
var value = inst_108064;
var seq__108029 = inst_108033;
var first__108039 = inst_108041;
var vec__108028 = new_child_paths;
return ((function (G__108027,keys_SINGLEQUOTE_,seq__108038,r,first__108030,vec__108037,child_path,acc__$1,value,seq__108029,first__108039,vec__108028,inst_108034,inst_108035,inst_108041,inst_108032,inst_108033,inst_108061,inst_108062,inst_108042,inst_108064,state_val_108133,c__99059__auto__){
return (function (p1__108019_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(p1__108019_SHARP_),cljs.core.first(child_path));
});
;})(G__108027,keys_SINGLEQUOTE_,seq__108038,r,first__108030,vec__108037,child_path,acc__$1,value,seq__108029,first__108039,vec__108028,inst_108034,inst_108035,inst_108041,inst_108032,inst_108033,inst_108061,inst_108062,inst_108042,inst_108064,state_val_108133,c__99059__auto__))
})();
var inst_108066 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_108065,inst_108064);
var inst_108067 = cljs.core.first(inst_108066);
var inst_108068 = inst_108064.indexOf(inst_108067);
var inst_108069 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_108062,inst_108068);
var inst_108070 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_108069,k);
var inst_108071 = cljs.core.rest(inst_108061);
var inst_108072 = cljs.core.count(inst_108071);
var inst_108073 = (inst_108072 > (0));
var state_108132__$1 = (function (){var statearr_108170 = state_108132;
(statearr_108170[(20)] = inst_108070);

return statearr_108170;
})();
if(cljs.core.truth_(inst_108073)){
var statearr_108171_108211 = state_108132__$1;
(statearr_108171_108211[(1)] = (18));

} else {
var statearr_108172_108212 = state_108132__$1;
(statearr_108172_108212[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (30))){
var inst_108035 = (state_108132[(7)]);
var inst_108091 = (state_108132[(19)]);
var inst_108111 = (state_108132[(17)]);
var inst_108120 = cljs.core.assoc_in(inst_108035,inst_108091,inst_108111);
var state_108132__$1 = state_108132;
var statearr_108173_108213 = state_108132__$1;
(statearr_108173_108213[(2)] = inst_108120);

(statearr_108173_108213[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (10))){
var inst_108041 = (state_108132[(21)]);
var state_108132__$1 = state_108132;
var statearr_108174_108214 = state_108132__$1;
(statearr_108174_108214[(2)] = inst_108041);

(statearr_108174_108214[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (18))){
var inst_108061 = (state_108132[(15)]);
var inst_108070 = (state_108132[(20)]);
var inst_108075 = cljs.core.rest(inst_108061);
var inst_108061__$1 = inst_108075;
var inst_108062 = inst_108070;
var state_108132__$1 = (function (){var statearr_108175 = state_108132;
(statearr_108175[(15)] = inst_108061__$1);

(statearr_108175[(16)] = inst_108062);

return statearr_108175;
})();
var statearr_108176_108215 = state_108132__$1;
(statearr_108176_108215[(2)] = null);

(statearr_108176_108215[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108133 === (8))){
var state_108132__$1 = state_108132;
if(cljs.core.truth_(parent_exists)){
var statearr_108177_108216 = state_108132__$1;
(statearr_108177_108216[(1)] = (10));

} else {
var statearr_108178_108217 = state_108132__$1;
(statearr_108178_108217[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____0 = (function (){
var statearr_108179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108179[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__);

(statearr_108179[(1)] = (1));

return statearr_108179;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____1 = (function (state_108132){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_108132);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e108180){if((e108180 instanceof Object)){
var ex__99040__auto__ = e108180;
var statearr_108181_108218 = state_108132;
(statearr_108181_108218[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108132);

return cljs.core.cst$kw$recur;
} else {
throw e108180;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__108219 = state_108132;
state_108132 = G__108219;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__ = function(state_108132){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____1.call(this,state_108132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_108182 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_108182[(6)] = c__99059__auto__);

return statearr_108182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_108329){
var state_val_108330 = (state_108329[(1)]);
if((state_val_108330 === (7))){
var inst_108240 = (state_108329[(7)]);
var inst_108244 = (state_108329[(8)]);
var inst_108229 = (state_108329[(9)]);
var inst_108240__$1 = (state_108329[(2)]);
var inst_108241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108242 = [inst_108240__$1,inst_108229];
var inst_108243 = (new cljs.core.PersistentVector(null,2,(5),inst_108241,inst_108242,null));
var inst_108244__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_108243);
var state_108329__$1 = (function (){var statearr_108331 = state_108329;
(statearr_108331[(7)] = inst_108240__$1);

(statearr_108331[(8)] = inst_108244__$1);

return statearr_108331;
})();
if(cljs.core.truth_(inst_108244__$1)){
var statearr_108332_108391 = state_108329__$1;
(statearr_108332_108391[(1)] = (11));

} else {
var statearr_108333_108392 = state_108329__$1;
(statearr_108333_108392[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (20))){
var inst_108271 = (state_108329[(10)]);
var inst_108273 = f.o;
var inst_108274 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_108273,inst_108271);
var state_108329__$1 = state_108329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108329__$1,(23),inst_108274);
} else {
if((state_val_108330 === (27))){
var inst_108291 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
if(cljs.core.truth_(inst_108291)){
var statearr_108334_108393 = state_108329__$1;
(statearr_108334_108393[(1)] = (28));

} else {
var statearr_108335_108394 = state_108329__$1;
(statearr_108335_108394[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (1))){
var state_108329__$1 = state_108329;
var statearr_108336_108395 = state_108329__$1;
(statearr_108336_108395[(2)] = null);

(statearr_108336_108395[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (24))){
var inst_108258 = (state_108329[(11)]);
var inst_108285 = (state_108329[(2)]);
var inst_108286 = fluree.db.util.async.throw_err(inst_108285);
var state_108329__$1 = (function (){var statearr_108337 = state_108329;
(statearr_108337[(12)] = inst_108286);

return statearr_108337;
})();
if(cljs.core.truth_(inst_108258)){
var statearr_108338_108396 = state_108329__$1;
(statearr_108338_108396[(1)] = (25));

} else {
var statearr_108339_108397 = state_108329__$1;
(statearr_108339_108397[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (39))){
var inst_108308 = (state_108329[(13)]);
var state_108329__$1 = state_108329;
var statearr_108340_108398 = state_108329__$1;
(statearr_108340_108398[(2)] = inst_108308);

(statearr_108340_108398[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (4))){
var inst_108230 = (state_108329[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108329,(3),Error,null,(2));
var inst_108227 = fluree.db.query.fql.s(f);
var inst_108228 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$_id,inst_108227);
var inst_108229 = fluree.db.query.fql.o(f);
var inst_108230__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108329__$1 = (function (){var statearr_108341 = state_108329;
(statearr_108341[(15)] = inst_108228);

(statearr_108341[(14)] = inst_108230__$1);

(statearr_108341[(9)] = inst_108229);

return statearr_108341;
})();
if(cljs.core.truth_(inst_108230__$1)){
var statearr_108342_108399 = state_108329__$1;
(statearr_108342_108399[(1)] = (5));

} else {
var statearr_108343_108400 = state_108329__$1;
(statearr_108343_108400[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (15))){
var inst_108252 = (state_108329[(16)]);
var inst_108261 = cljs.core.not(inst_108252);
var state_108329__$1 = state_108329;
var statearr_108344_108401 = state_108329__$1;
(statearr_108344_108401[(2)] = inst_108261);

(statearr_108344_108401[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (21))){
var state_108329__$1 = state_108329;
var statearr_108345_108402 = state_108329__$1;
(statearr_108345_108402[(2)] = null);

(statearr_108345_108402[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (31))){
var inst_108282 = (state_108329[(17)]);
var inst_108296 = cljs.core.rest(flakes);
var inst_108297 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_108296,inst_108282);
var state_108329__$1 = state_108329;
var statearr_108346_108403 = state_108329__$1;
(statearr_108346_108403[(2)] = inst_108297);

(statearr_108346_108403[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (32))){
var state_108329__$1 = state_108329;
var statearr_108347_108404 = state_108329__$1;
(statearr_108347_108404[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (40))){
var inst_108300 = (state_108329[(18)]);
var inst_108314 = (state_108329[(2)]);
var inst_108315 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_108300,inst_108314);
var state_108329__$1 = state_108329;
var statearr_108349_108405 = state_108329__$1;
(statearr_108349_108405[(2)] = inst_108315);

(statearr_108349_108405[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (33))){
var inst_108320 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
var statearr_108350_108406 = state_108329__$1;
(statearr_108350_108406[(2)] = inst_108320);

(statearr_108350_108406[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (13))){
var inst_108240 = (state_108329[(7)]);
var inst_108251 = (state_108329[(19)]);
var inst_108258 = (state_108329[(11)]);
var inst_108248 = (state_108329[(2)]);
var inst_108249 = fluree.db.query.fql.get_recursion_map_multi(recursion_map,inst_108240,f,select_spec,inst_108248);
var inst_108250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108249,(0),null);
var inst_108251__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108249,(1),null);
var inst_108252 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108249,(2),null);
var inst_108253 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_108254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108255 = [inst_108240,cljs.core.cst$kw$depth];
var inst_108256 = (new cljs.core.PersistentVector(null,2,(5),inst_108254,inst_108255,null));
var inst_108257 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108251__$1,inst_108256);
var inst_108258__$1 = (inst_108253 < inst_108257);
var state_108329__$1 = (function (){var statearr_108351 = state_108329;
(statearr_108351[(16)] = inst_108252);

(statearr_108351[(19)] = inst_108251__$1);

(statearr_108351[(11)] = inst_108258__$1);

(statearr_108351[(20)] = inst_108250);

return statearr_108351;
})();
if(cljs.core.truth_(inst_108258__$1)){
var statearr_108352_108407 = state_108329__$1;
(statearr_108352_108407[(1)] = (14));

} else {
var statearr_108353_108408 = state_108329__$1;
(statearr_108353_108408[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (22))){
var inst_108280 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
var statearr_108354_108409 = state_108329__$1;
(statearr_108354_108409[(2)] = inst_108280);

(statearr_108354_108409[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (36))){
var inst_108318 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
var statearr_108355_108410 = state_108329__$1;
(statearr_108355_108410[(2)] = inst_108318);

(statearr_108355_108410[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (29))){
var inst_108282 = (state_108329[(17)]);
var state_108329__$1 = state_108329;
if(cljs.core.truth_(inst_108282)){
var statearr_108356_108411 = state_108329__$1;
(statearr_108356_108411[(1)] = (31));

} else {
var statearr_108357_108412 = state_108329__$1;
(statearr_108357_108412[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (6))){
var inst_108233 = (state_108329[(21)]);
var inst_108233__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108329__$1 = (function (){var statearr_108358 = state_108329;
(statearr_108358[(21)] = inst_108233__$1);

return statearr_108358;
})();
if(cljs.core.truth_(inst_108233__$1)){
var statearr_108359_108413 = state_108329__$1;
(statearr_108359_108413[(1)] = (8));

} else {
var statearr_108360_108414 = state_108329__$1;
(statearr_108360_108414[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (28))){
var inst_108293 = cljs.core.rest(flakes);
var state_108329__$1 = state_108329;
var statearr_108361_108415 = state_108329__$1;
(statearr_108361_108415[(2)] = inst_108293);

(statearr_108361_108415[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (25))){
var inst_108258 = (state_108329[(11)]);
var state_108329__$1 = state_108329;
var statearr_108362_108416 = state_108329__$1;
(statearr_108362_108416[(2)] = inst_108258);

(statearr_108362_108416[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (34))){
var inst_108229 = (state_108329[(9)]);
var inst_108300 = cljs.core.rest(flakes);
var inst_108302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108303 = [inst_108229];
var inst_108304 = (new cljs.core.PersistentVector(null,1,(5),inst_108302,inst_108303,null));
var inst_108305 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_108304);
var state_108329__$1 = (function (){var statearr_108363 = state_108329;
(statearr_108363[(18)] = inst_108300);

return statearr_108363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108329__$1,(37),inst_108305);
} else {
if((state_val_108330 === (17))){
var state_108329__$1 = state_108329;
var statearr_108364_108417 = state_108329__$1;
(statearr_108364_108417[(2)] = null);

(statearr_108364_108417[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (3))){
var inst_108220 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
var statearr_108365_108418 = state_108329__$1;
(statearr_108365_108418[(2)] = inst_108220);


cljs.core.async.impl.ioc_helpers.process_exception(state_108329__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (12))){
var state_108329__$1 = state_108329;
var statearr_108366_108419 = state_108329__$1;
(statearr_108366_108419[(2)] = false);

(statearr_108366_108419[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (2))){
var inst_108327 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108329__$1,inst_108327);
} else {
if((state_val_108330 === (23))){
var inst_108276 = (state_108329[(2)]);
var inst_108277 = fluree.db.util.async.throw_err(inst_108276);
var state_108329__$1 = state_108329;
var statearr_108367_108420 = state_108329__$1;
(statearr_108367_108420[(2)] = inst_108277);

(statearr_108367_108420[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (35))){
var state_108329__$1 = state_108329;
var statearr_108368_108421 = state_108329__$1;
(statearr_108368_108421[(2)] = null);

(statearr_108368_108421[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (19))){
var inst_108228 = (state_108329[(15)]);
var inst_108240 = (state_108329[(7)]);
var inst_108250 = (state_108329[(20)]);
var inst_108282 = (state_108329[(2)]);
var inst_108283 = fluree.db.query.fql.add_in_multi_flakes(inst_108228,inst_108250,inst_108240,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_108329__$1 = (function (){var statearr_108369 = state_108329;
(statearr_108369[(17)] = inst_108282);

return statearr_108369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108329__$1,(24),inst_108283);
} else {
if((state_val_108330 === (11))){
var inst_108244 = (state_108329[(8)]);
var state_108329__$1 = state_108329;
var statearr_108370_108422 = state_108329__$1;
(statearr_108370_108422[(2)] = inst_108244);

(statearr_108370_108422[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (9))){
var inst_108236 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108329__$1 = state_108329;
var statearr_108371_108423 = state_108329__$1;
(statearr_108371_108423[(2)] = inst_108236);

(statearr_108371_108423[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (5))){
var inst_108230 = (state_108329[(14)]);
var state_108329__$1 = state_108329;
var statearr_108372_108424 = state_108329__$1;
(statearr_108372_108424[(2)] = inst_108230);

(statearr_108372_108424[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (14))){
var inst_108258 = (state_108329[(11)]);
var state_108329__$1 = state_108329;
var statearr_108373_108425 = state_108329__$1;
(statearr_108373_108425[(2)] = inst_108258);

(statearr_108373_108425[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (26))){
var inst_108252 = (state_108329[(16)]);
var inst_108289 = cljs.core.not(inst_108252);
var state_108329__$1 = state_108329;
var statearr_108374_108426 = state_108329__$1;
(statearr_108374_108426[(2)] = inst_108289);

(statearr_108374_108426[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (16))){
var inst_108263 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
if(cljs.core.truth_(inst_108263)){
var statearr_108375_108427 = state_108329__$1;
(statearr_108375_108427[(1)] = (17));

} else {
var statearr_108376_108428 = state_108329__$1;
(statearr_108376_108428[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (38))){
var inst_108308 = (state_108329[(13)]);
var inst_108310 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_108311 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_108310,inst_108308);
var state_108329__$1 = state_108329;
var statearr_108377_108429 = state_108329__$1;
(statearr_108377_108429[(2)] = inst_108311);

(statearr_108377_108429[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (30))){
var inst_108251 = (state_108329[(19)]);
var inst_108286 = (state_108329[(12)]);
var inst_108322 = (state_108329[(2)]);
var inst_108323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108324 = [inst_108286,inst_108322,inst_108251];
var inst_108325 = (new cljs.core.PersistentVector(null,3,(5),inst_108323,inst_108324,null));
var state_108329__$1 = state_108329;
var statearr_108378_108430 = state_108329__$1;
(statearr_108378_108430[(2)] = inst_108325);


cljs.core.async.impl.ioc_helpers.process_exception(state_108329__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (10))){
var inst_108238 = (state_108329[(2)]);
var state_108329__$1 = state_108329;
var statearr_108379_108431 = state_108329__$1;
(statearr_108379_108431[(2)] = inst_108238);

(statearr_108379_108431[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (18))){
var inst_108271 = (state_108329[(10)]);
var inst_108251 = (state_108329[(19)]);
var inst_108266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108267 = f.p;
var inst_108268 = [cljs.core.cst$kw$select_DASH_specs,inst_108267];
var inst_108269 = (new cljs.core.PersistentVector(null,2,(5),inst_108266,inst_108268,null));
var inst_108270 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108251,inst_108269);
var inst_108271__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_108270);
var state_108329__$1 = (function (){var statearr_108380 = state_108329;
(statearr_108380[(10)] = inst_108271__$1);

return statearr_108380;
})();
if(cljs.core.truth_(inst_108271__$1)){
var statearr_108381_108432 = state_108329__$1;
(statearr_108381_108432[(1)] = (20));

} else {
var statearr_108382_108433 = state_108329__$1;
(statearr_108382_108433[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (37))){
var inst_108307 = (state_108329[(2)]);
var inst_108308 = fluree.db.util.async.throw_err(inst_108307);
var state_108329__$1 = (function (){var statearr_108383 = state_108329;
(statearr_108383[(13)] = inst_108308);

return statearr_108383;
})();
if(cljs.core.truth_(fuel)){
var statearr_108384_108434 = state_108329__$1;
(statearr_108384_108434[(1)] = (38));

} else {
var statearr_108385_108435 = state_108329__$1;
(statearr_108385_108435[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108330 === (8))){
var inst_108233 = (state_108329[(21)]);
var state_108329__$1 = state_108329;
var statearr_108386_108436 = state_108329__$1;
(statearr_108386_108436[(2)] = inst_108233);

(statearr_108386_108436[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____0 = (function (){
var statearr_108387 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108387[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__);

(statearr_108387[(1)] = (1));

return statearr_108387;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____1 = (function (state_108329){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_108329);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e108388){if((e108388 instanceof Object)){
var ex__99040__auto__ = e108388;
var statearr_108389_108437 = state_108329;
(statearr_108389_108437[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108329);

return cljs.core.cst$kw$recur;
} else {
throw e108388;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__108438 = state_108329;
state_108329 = G__108438;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__ = function(state_108329){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____1.call(this,state_108329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_108390 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_108390[(6)] = c__99059__auto__);

return statearr_108390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_(select_spec__$1))?fluree.db.query.fql.full_select_spec(db,cache,select_spec__$1,fluree.db.query.fql.s(f)):select_spec__$1);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s(f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_108598){
var state_val_108599 = (state_108598[(1)]);
if((state_val_108599 === (7))){
var inst_108455 = (state_108598[(7)]);
var inst_108463 = (state_108598[(8)]);
var inst_108443 = (state_108598[(9)]);
var inst_108455__$1 = (state_108598[(2)]);
var inst_108456 = cljs.core.PersistentVector.EMPTY;
var inst_108457 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_108455__$1);
var inst_108458 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_108456,inst_108457);
var inst_108459 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc,inst_108458);
var inst_108460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108461 = [inst_108455__$1,inst_108443];
var inst_108462 = (new cljs.core.PersistentVector(null,2,(5),inst_108460,inst_108461,null));
var inst_108463__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_108462);
var state_108598__$1 = (function (){var statearr_108600 = state_108598;
(statearr_108600[(7)] = inst_108455__$1);

(statearr_108600[(8)] = inst_108463__$1);

(statearr_108600[(10)] = inst_108459);

return statearr_108600;
})();
if(cljs.core.truth_(inst_108463__$1)){
var statearr_108601_108692 = state_108598__$1;
(statearr_108601_108692[(1)] = (11));

} else {
var statearr_108602_108693 = state_108598__$1;
(statearr_108602_108693[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (59))){
var inst_108580 = (state_108598[(11)]);
var state_108598__$1 = state_108598;
var statearr_108603_108694 = state_108598__$1;
(statearr_108603_108694[(2)] = inst_108580);

(statearr_108603_108694[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (20))){
var inst_108487 = (state_108598[(12)]);
var state_108598__$1 = state_108598;
var statearr_108604_108695 = state_108598__$1;
(statearr_108604_108695[(2)] = inst_108487);

(statearr_108604_108695[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (58))){
var inst_108580 = (state_108598[(11)]);
var inst_108582 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_108583 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_108582,inst_108580);
var state_108598__$1 = state_108598;
var statearr_108605_108696 = state_108598__$1;
(statearr_108605_108696[(2)] = inst_108583);

(statearr_108605_108696[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (60))){
var inst_108572 = (state_108598[(13)]);
var inst_108586 = (state_108598[(2)]);
var inst_108587 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_108572,inst_108586);
var state_108598__$1 = state_108598;
var statearr_108606_108697 = state_108598__$1;
(statearr_108606_108697[(2)] = inst_108587);

(statearr_108606_108697[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (27))){
var state_108598__$1 = state_108598;
var statearr_108607_108698 = state_108598__$1;
(statearr_108607_108698[(2)] = null);

(statearr_108607_108698[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (1))){
var state_108598__$1 = state_108598;
var statearr_108608_108699 = state_108598__$1;
(statearr_108608_108699[(2)] = null);

(statearr_108608_108699[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (24))){
var inst_108499 = (state_108598[(14)]);
var inst_108482 = (state_108598[(15)]);
var inst_108494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108495 = f.p;
var inst_108496 = [cljs.core.cst$kw$select_DASH_specs,inst_108495];
var inst_108497 = (new cljs.core.PersistentVector(null,2,(5),inst_108494,inst_108496,null));
var inst_108498 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108482,inst_108497);
var inst_108499__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_108498);
var state_108598__$1 = (function (){var statearr_108609 = state_108598;
(statearr_108609[(14)] = inst_108499__$1);

return statearr_108609;
})();
if(cljs.core.truth_(inst_108499__$1)){
var statearr_108610_108700 = state_108598__$1;
(statearr_108610_108700[(1)] = (26));

} else {
var statearr_108611_108701 = state_108598__$1;
(statearr_108611_108701[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (55))){
var inst_108443 = (state_108598[(9)]);
var inst_108572 = cljs.core.rest(flakes);
var inst_108574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108575 = [inst_108443];
var inst_108576 = (new cljs.core.PersistentVector(null,1,(5),inst_108574,inst_108575,null));
var inst_108577 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_108576);
var state_108598__$1 = (function (){var statearr_108612 = state_108598;
(statearr_108612[(13)] = inst_108572);

return statearr_108612;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108598__$1,(57),inst_108577);
} else {
if((state_val_108599 === (39))){
var inst_108455 = (state_108598[(7)]);
var inst_108540 = (state_108598[(16)]);
var inst_108510 = (state_108598[(17)]);
var inst_108542 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108540,inst_108455);
var inst_108543 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_108542,inst_108510], 0));
var inst_108544 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_108540,inst_108455,inst_108543);
var state_108598__$1 = state_108598;
var statearr_108613_108702 = state_108598__$1;
(statearr_108613_108702[(2)] = inst_108544);

(statearr_108613_108702[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (46))){
var state_108598__$1 = state_108598;
var statearr_108614_108703 = state_108598__$1;
(statearr_108614_108703[(1)] = (48));



return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (4))){
var inst_108445 = (state_108598[(18)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108598,(3),Error,null,(2));
var inst_108443 = f.o;
var inst_108444 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_108445__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108598__$1 = (function (){var statearr_108616 = state_108598;
(statearr_108616[(19)] = inst_108444);

(statearr_108616[(18)] = inst_108445__$1);

(statearr_108616[(9)] = inst_108443);

return statearr_108616;
})();
if(cljs.core.truth_(inst_108445__$1)){
var statearr_108617_108704 = state_108598__$1;
(statearr_108617_108704[(1)] = (5));

} else {
var statearr_108618_108705 = state_108598__$1;
(statearr_108618_108705[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (54))){
var inst_108570 = cljs.core.rest(flakes);
var state_108598__$1 = state_108598;
var statearr_108619_108706 = state_108598__$1;
(statearr_108619_108706[(2)] = inst_108570);

(statearr_108619_108706[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (15))){
var state_108598__$1 = state_108598;
var statearr_108620_108707 = state_108598__$1;
(statearr_108620_108707[(2)] = recursion_map);

(statearr_108620_108707[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (48))){
var inst_108547 = (state_108598[(20)]);
var inst_108455 = (state_108598[(7)]);
var inst_108554 = cljs.core.PersistentVector.EMPTY;
var inst_108555 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_108455);
var inst_108556 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_108554,inst_108555);
var inst_108557 = cljs.core.assoc_in(acc,inst_108556,inst_108547);
var state_108598__$1 = state_108598;
var statearr_108621_108708 = state_108598__$1;
(statearr_108621_108708[(2)] = inst_108557);

(statearr_108621_108708[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (50))){
var inst_108560 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108622_108709 = state_108598__$1;
(statearr_108622_108709[(2)] = inst_108560);

(statearr_108622_108709[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (21))){
var inst_108467 = (state_108598[(21)]);
var state_108598__$1 = state_108598;
var statearr_108623_108710 = state_108598__$1;
(statearr_108623_108710[(2)] = inst_108467);

(statearr_108623_108710[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (31))){
var inst_108444 = (state_108598[(19)]);
var state_108598__$1 = state_108598;
var statearr_108624_108711 = state_108598__$1;
(statearr_108624_108711[(2)] = inst_108444);

(statearr_108624_108711[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (32))){
var inst_108518 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
if(cljs.core.truth_(inst_108518)){
var statearr_108625_108712 = state_108598__$1;
(statearr_108625_108712[(1)] = (33));

} else {
var statearr_108626_108713 = state_108598__$1;
(statearr_108626_108713[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (40))){
var inst_108540 = (state_108598[(16)]);
var state_108598__$1 = state_108598;
var statearr_108627_108714 = state_108598__$1;
(statearr_108627_108714[(2)] = inst_108540);

(statearr_108627_108714[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (56))){
var inst_108482 = (state_108598[(15)]);
var inst_108564 = (state_108598[(22)]);
var inst_108589 = (state_108598[(2)]);
var inst_108590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108591 = [inst_108564,inst_108589,inst_108482];
var inst_108592 = (new cljs.core.PersistentVector(null,3,(5),inst_108590,inst_108591,null));
var state_108598__$1 = state_108598;
var statearr_108628_108715 = state_108598__$1;
(statearr_108628_108715[(2)] = inst_108592);

(statearr_108628_108715[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (33))){
var inst_108482 = (state_108598[(15)]);
var inst_108520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108521 = cljs.core.rest(flakes);
var inst_108522 = [acc,inst_108521,inst_108482];
var inst_108523 = (new cljs.core.PersistentVector(null,3,(5),inst_108520,inst_108522,null));
var state_108598__$1 = state_108598;
var statearr_108629_108716 = state_108598__$1;
(statearr_108629_108716[(2)] = inst_108523);

(statearr_108629_108716[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (13))){
var inst_108467 = (state_108598[(21)]);
var inst_108467__$1 = (state_108598[(2)]);
var inst_108468 = cljs.core.not(inst_108467__$1);
var state_108598__$1 = (function (){var statearr_108630 = state_108598;
(statearr_108630[(21)] = inst_108467__$1);

return statearr_108630;
})();
if(inst_108468){
var statearr_108631_108717 = state_108598__$1;
(statearr_108631_108717[(1)] = (14));

} else {
var statearr_108632_108718 = state_108598__$1;
(statearr_108632_108718[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (22))){
var inst_108491 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
if(cljs.core.truth_(inst_108491)){
var statearr_108633_108719 = state_108598__$1;
(statearr_108633_108719[(1)] = (23));

} else {
var statearr_108634_108720 = state_108598__$1;
(statearr_108634_108720[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (36))){
var inst_108455 = (state_108598[(7)]);
var inst_108459 = (state_108598[(10)]);
var inst_108443 = (state_108598[(9)]);
var inst_108526 = cljs.core.PersistentVector.EMPTY;
var inst_108527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108459,inst_108455);
var inst_108528 = [cljs.core.cst$kw$_id];
var inst_108529 = [inst_108443];
var inst_108530 = cljs.core.PersistentHashMap.fromArrays(inst_108528,inst_108529);
var inst_108531 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_108527,inst_108530);
var inst_108532 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_108526,inst_108531);
var inst_108533 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_108459,inst_108455,inst_108532);
var state_108598__$1 = state_108598;
var statearr_108635_108721 = state_108598__$1;
(statearr_108635_108721[(2)] = inst_108533);

(statearr_108635_108721[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (41))){
var inst_108467 = (state_108598[(21)]);
var inst_108547 = (state_108598[(2)]);
var inst_108548 = cljs.core.not(inst_108467);
var state_108598__$1 = (function (){var statearr_108636 = state_108598;
(statearr_108636[(20)] = inst_108547);

return statearr_108636;
})();
if(inst_108548){
var statearr_108637_108722 = state_108598__$1;
(statearr_108637_108722[(1)] = (42));

} else {
var statearr_108638_108723 = state_108598__$1;
(statearr_108638_108723[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (43))){
var inst_108467 = (state_108598[(21)]);
var state_108598__$1 = state_108598;
if(cljs.core.truth_(inst_108467)){
var statearr_108639_108724 = state_108598__$1;
(statearr_108639_108724[(1)] = (45));

} else {
var statearr_108640_108725 = state_108598__$1;
(statearr_108640_108725[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (29))){
var inst_108504 = (state_108598[(2)]);
var inst_108505 = fluree.db.util.async.throw_err(inst_108504);
var state_108598__$1 = state_108598;
var statearr_108641_108726 = state_108598__$1;
(statearr_108641_108726[(2)] = inst_108505);

(statearr_108641_108726[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (44))){
var inst_108487 = (state_108598[(12)]);
var inst_108564 = (state_108598[(2)]);
var state_108598__$1 = (function (){var statearr_108642 = state_108598;
(statearr_108642[(22)] = inst_108564);

return statearr_108642;
})();
if(cljs.core.truth_(inst_108487)){
var statearr_108643_108727 = state_108598__$1;
(statearr_108643_108727[(1)] = (51));

} else {
var statearr_108644_108728 = state_108598__$1;
(statearr_108644_108728[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (6))){
var inst_108448 = (state_108598[(23)]);
var inst_108448__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108598__$1 = (function (){var statearr_108645 = state_108598;
(statearr_108645[(23)] = inst_108448__$1);

return statearr_108645;
})();
if(cljs.core.truth_(inst_108448__$1)){
var statearr_108646_108729 = state_108598__$1;
(statearr_108646_108729[(1)] = (8));

} else {
var statearr_108647_108730 = state_108598__$1;
(statearr_108647_108730[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (28))){
var inst_108508 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108648_108731 = state_108598__$1;
(statearr_108648_108731[(2)] = inst_108508);

(statearr_108648_108731[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (51))){
var inst_108487 = (state_108598[(12)]);
var state_108598__$1 = state_108598;
var statearr_108649_108732 = state_108598__$1;
(statearr_108649_108732[(2)] = inst_108487);

(statearr_108649_108732[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (25))){
var inst_108444 = (state_108598[(19)]);
var inst_108510 = (state_108598[(2)]);
var state_108598__$1 = (function (){var statearr_108650 = state_108598;
(statearr_108650[(17)] = inst_108510);

return statearr_108650;
})();
if(cljs.core.truth_(inst_108444)){
var statearr_108651_108733 = state_108598__$1;
(statearr_108651_108733[(1)] = (30));

} else {
var statearr_108652_108734 = state_108598__$1;
(statearr_108652_108734[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (34))){
var inst_108444 = (state_108598[(19)]);
var state_108598__$1 = state_108598;
if(cljs.core.truth_(inst_108444)){
var statearr_108653_108735 = state_108598__$1;
(statearr_108653_108735[(1)] = (36));

} else {
var statearr_108654_108736 = state_108598__$1;
(statearr_108654_108736[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (17))){
var inst_108473 = (state_108598[(24)]);
var state_108598__$1 = state_108598;
var statearr_108655_108737 = state_108598__$1;
(statearr_108655_108737[(2)] = inst_108473);

(statearr_108655_108737[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (3))){
var inst_108439 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108656_108738 = state_108598__$1;
(statearr_108656_108738[(2)] = inst_108439);


cljs.core.async.impl.ioc_helpers.process_exception(state_108598__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (12))){
var state_108598__$1 = state_108598;
var statearr_108657_108739 = state_108598__$1;
(statearr_108657_108739[(2)] = false);

(statearr_108657_108739[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (2))){
var inst_108596 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108598__$1,inst_108596);
} else {
if((state_val_108599 === (23))){
var state_108598__$1 = state_108598;
var statearr_108658_108740 = state_108598__$1;
(statearr_108658_108740[(2)] = null);

(statearr_108658_108740[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (47))){
var inst_108562 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108659_108741 = state_108598__$1;
(statearr_108659_108741[(2)] = inst_108562);

(statearr_108659_108741[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (35))){
var inst_108594 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108660_108742 = state_108598__$1;
(statearr_108660_108742[(2)] = inst_108594);


cljs.core.async.impl.ioc_helpers.process_exception(state_108598__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (19))){
var inst_108482 = (state_108598[(15)]);
var inst_108487 = (state_108598[(12)]);
var inst_108455 = (state_108598[(7)]);
var inst_108482__$1 = (state_108598[(2)]);
var inst_108483 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_108484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108482__$1,inst_108455);
var inst_108485 = cljs.core.vals(inst_108484);
var inst_108486 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,inst_108485);
var inst_108487__$1 = (inst_108483 < inst_108486);
var state_108598__$1 = (function (){var statearr_108661 = state_108598;
(statearr_108661[(15)] = inst_108482__$1);

(statearr_108661[(12)] = inst_108487__$1);

return statearr_108661;
})();
if(cljs.core.truth_(inst_108487__$1)){
var statearr_108662_108743 = state_108598__$1;
(statearr_108662_108743[(1)] = (20));

} else {
var statearr_108663_108744 = state_108598__$1;
(statearr_108663_108744[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (57))){
var inst_108579 = (state_108598[(2)]);
var inst_108580 = fluree.db.util.async.throw_err(inst_108579);
var state_108598__$1 = (function (){var statearr_108664 = state_108598;
(statearr_108664[(11)] = inst_108580);

return statearr_108664;
})();
if(cljs.core.truth_(fuel)){
var statearr_108665_108745 = state_108598__$1;
(statearr_108665_108745[(1)] = (58));

} else {
var statearr_108666_108746 = state_108598__$1;
(statearr_108666_108746[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (11))){
var inst_108463 = (state_108598[(8)]);
var state_108598__$1 = state_108598;
var statearr_108667_108747 = state_108598__$1;
(statearr_108667_108747[(2)] = inst_108463);

(statearr_108667_108747[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (9))){
var inst_108451 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_108598__$1 = state_108598;
var statearr_108668_108748 = state_108598__$1;
(statearr_108668_108748[(2)] = inst_108451);

(statearr_108668_108748[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (5))){
var inst_108445 = (state_108598[(18)]);
var state_108598__$1 = state_108598;
var statearr_108669_108749 = state_108598__$1;
(statearr_108669_108749[(2)] = inst_108445);

(statearr_108669_108749[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (14))){
var inst_108455 = (state_108598[(7)]);
var inst_108470 = fluree.db.query.fql.get_recursion_map(db,recursion_map,select_spec,cache,inst_108455,f);
var state_108598__$1 = state_108598;
var statearr_108670_108750 = state_108598__$1;
(statearr_108670_108750[(2)] = inst_108470);

(statearr_108670_108750[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (45))){
var state_108598__$1 = state_108598;
var statearr_108671_108751 = state_108598__$1;
(statearr_108671_108751[(2)] = acc);

(statearr_108671_108751[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (53))){
var inst_108568 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
if(cljs.core.truth_(inst_108568)){
var statearr_108672_108752 = state_108598__$1;
(statearr_108672_108752[(1)] = (54));

} else {
var statearr_108673_108753 = state_108598__$1;
(statearr_108673_108753[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (26))){
var inst_108499 = (state_108598[(14)]);
var inst_108501 = f.o;
var inst_108502 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_108501,inst_108499);
var state_108598__$1 = state_108598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108598__$1,(29),inst_108502);
} else {
if((state_val_108599 === (16))){
var inst_108467 = (state_108598[(21)]);
var inst_108473 = (state_108598[(2)]);
var state_108598__$1 = (function (){var statearr_108674 = state_108598;
(statearr_108674[(24)] = inst_108473);

return statearr_108674;
})();
if(cljs.core.truth_(inst_108467)){
var statearr_108675_108754 = state_108598__$1;
(statearr_108675_108754[(1)] = (17));

} else {
var statearr_108676_108755 = state_108598__$1;
(statearr_108676_108755[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (38))){
var inst_108510 = (state_108598[(17)]);
var inst_108540 = (state_108598[(2)]);
var state_108598__$1 = (function (){var statearr_108677 = state_108598;
(statearr_108677[(16)] = inst_108540);

return statearr_108677;
})();
if(cljs.core.truth_(inst_108510)){
var statearr_108678_108756 = state_108598__$1;
(statearr_108678_108756[(1)] = (39));

} else {
var statearr_108679_108757 = state_108598__$1;
(statearr_108679_108757[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (30))){
var inst_108455 = (state_108598[(7)]);
var inst_108459 = (state_108598[(10)]);
var inst_108512 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_108459,inst_108455);
var inst_108513 = cljs.core.count(inst_108512);
var inst_108514 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_108515 = (inst_108513 > inst_108514);
var state_108598__$1 = state_108598;
var statearr_108680_108758 = state_108598__$1;
(statearr_108680_108758[(2)] = inst_108515);

(statearr_108680_108758[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (10))){
var inst_108453 = (state_108598[(2)]);
var state_108598__$1 = state_108598;
var statearr_108681_108759 = state_108598__$1;
(statearr_108681_108759[(2)] = inst_108453);

(statearr_108681_108759[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (18))){
var inst_108455 = (state_108598[(7)]);
var inst_108473 = (state_108598[(24)]);
var inst_108443 = (state_108598[(9)]);
var inst_108476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108477 = [inst_108455,inst_108443];
var inst_108478 = (new cljs.core.PersistentVector(null,2,(5),inst_108476,inst_108477,null));
var inst_108479 = ((0) + (1));
var inst_108480 = cljs.core.assoc_in(inst_108473,inst_108478,inst_108479);
var state_108598__$1 = state_108598;
var statearr_108682_108760 = state_108598__$1;
(statearr_108682_108760[(2)] = inst_108480);

(statearr_108682_108760[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (52))){
var inst_108467 = (state_108598[(21)]);
var state_108598__$1 = state_108598;
var statearr_108683_108761 = state_108598__$1;
(statearr_108683_108761[(2)] = inst_108467);

(statearr_108683_108761[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (42))){
var inst_108547 = (state_108598[(20)]);
var state_108598__$1 = state_108598;
var statearr_108684_108762 = state_108598__$1;
(statearr_108684_108762[(2)] = inst_108547);

(statearr_108684_108762[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (37))){
var inst_108455 = (state_108598[(7)]);
var inst_108459 = (state_108598[(10)]);
var inst_108443 = (state_108598[(9)]);
var inst_108535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108536 = [inst_108455,cljs.core.cst$kw$_id];
var inst_108537 = (new cljs.core.PersistentVector(null,2,(5),inst_108535,inst_108536,null));
var inst_108538 = cljs.core.assoc_in(inst_108459,inst_108537,inst_108443);
var state_108598__$1 = state_108598;
var statearr_108685_108763 = state_108598__$1;
(statearr_108685_108763[(2)] = inst_108538);

(statearr_108685_108763[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (8))){
var inst_108448 = (state_108598[(23)]);
var state_108598__$1 = state_108598;
var statearr_108686_108764 = state_108598__$1;
(statearr_108686_108764[(2)] = inst_108448);

(statearr_108686_108764[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108599 === (49))){
var state_108598__$1 = state_108598;
var statearr_108687_108765 = state_108598__$1;
(statearr_108687_108765[(2)] = null);

(statearr_108687_108765[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____0 = (function (){
var statearr_108688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108688[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__);

(statearr_108688[(1)] = (1));

return statearr_108688;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____1 = (function (state_108598){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_108598);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e108689){if((e108689 instanceof Object)){
var ex__99040__auto__ = e108689;
var statearr_108690_108766 = state_108598;
(statearr_108690_108766[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108598);

return cljs.core.cst$kw$recur;
} else {
throw e108689;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__108767 = state_108598;
state_108598 = G__108767;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__ = function(state_108598){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____1.call(this,state_108598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_108691 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_108691[(6)] = c__99059__auto__);

return statearr_108691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_108951){
var state_val_108952 = (state_108951[(1)]);
if((state_val_108952 === (7))){
var inst_108947 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_108953_109033 = state_108951__$1;
(statearr_108953_109033[(2)] = inst_108947);


cljs.core.async.impl.ioc_helpers.process_exception(state_108951__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (20))){
var inst_108789 = (state_108951[(7)]);
var inst_108809 = cljs.core.first(flakes);
var inst_108810 = fluree.db.query.fql.s(inst_108809);
var inst_108811 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_108789);
var inst_108812 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_108810,inst_108811);
var state_108951__$1 = state_108951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108951__$1,(23),inst_108812);
} else {
if((state_val_108952 === (27))){
var inst_108789 = (state_108951[(7)]);
var inst_108822 = (state_108951[(8)]);
var inst_108833 = (state_108951[(9)]);
var inst_108840 = (state_108951[(10)]);
var inst_108838 = (state_108951[(11)]);
var inst_108833__$1 = cljs.core.first(inst_108822);
var inst_108834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108835 = inst_108833__$1.p;
var inst_108836 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_108835];
var inst_108837 = (new cljs.core.PersistentVector(null,3,(5),inst_108834,inst_108836,null));
var inst_108838__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108789,inst_108837);
var inst_108839 = fluree.db.query.fql.component_follow_QMARK_(inst_108838__$1,inst_108789);
var inst_108840__$1 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_108838__$1);
var state_108951__$1 = (function (){var statearr_108954 = state_108951;
(statearr_108954[(9)] = inst_108833__$1);

(statearr_108954[(10)] = inst_108840__$1);

(statearr_108954[(12)] = inst_108839);

(statearr_108954[(11)] = inst_108838__$1);

return statearr_108954;
})();
if(cljs.core.truth_(inst_108840__$1)){
var statearr_108955_109034 = state_108951__$1;
(statearr_108955_109034[(1)] = (29));

} else {
var statearr_108956_109035 = state_108951__$1;
(statearr_108956_109035[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (1))){
var state_108951__$1 = state_108951;
var statearr_108957_109036 = state_108951__$1;
(statearr_108957_109036[(2)] = null);

(statearr_108957_109036[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (24))){
var inst_108822 = (state_108951[(8)]);
var inst_108827 = cljs.core.empty_QMARK_(inst_108822);
var state_108951__$1 = state_108951;
if(inst_108827){
var statearr_108958_109037 = state_108951__$1;
(statearr_108958_109037[(1)] = (26));

} else {
var statearr_108959_109038 = state_108951__$1;
(statearr_108959_109038[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (55))){
var state_108951__$1 = state_108951;
var statearr_108960_109039 = state_108951__$1;
(statearr_108960_109039[(2)] = null);

(statearr_108960_109039[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (39))){
var inst_108856 = (state_108951[(2)]);
var inst_108857 = fluree.db.util.async.throw_err(inst_108856);
var state_108951__$1 = state_108951;
var statearr_108961_109040 = state_108951__$1;
(statearr_108961_109040[(2)] = inst_108857);

(statearr_108961_109040[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (46))){
var inst_108914 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_108962_109041 = state_108951__$1;
(statearr_108962_109041[(2)] = inst_108914);

(statearr_108962_109041[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108951,(3),Error,null,(2));
var inst_108772 = cljs.core.not_empty(flakes);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108772)){
var statearr_108963_109042 = state_108951__$1;
(statearr_108963_109042[(1)] = (5));

} else {
var statearr_108964_109043 = state_108951__$1;
(statearr_108964_109043[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (54))){
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108825 = (state_108951[(14)]);
var inst_108823 = (state_108951[(15)]);
var inst_108904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108905 = cljs.core.rest(inst_108822);
var inst_108906 = [inst_108823,inst_108905,inst_108824,inst_108825];
var inst_108907 = (new cljs.core.PersistentVector(null,4,(5),inst_108904,inst_108906,null));
var state_108951__$1 = state_108951;
var statearr_108965_109044 = state_108951__$1;
(statearr_108965_109044[(2)] = inst_108907);

(statearr_108965_109044[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (15))){
var inst_108789 = (state_108951[(7)]);
var inst_108793 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_108789);
var state_108951__$1 = state_108951;
var statearr_108966_109045 = state_108951__$1;
(statearr_108966_109045[(2)] = inst_108793);

(statearr_108966_109045[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (48))){
var inst_108789 = (state_108951[(7)]);
var inst_108889 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_108789);
var state_108951__$1 = state_108951;
var statearr_108967_109046 = state_108951__$1;
(statearr_108967_109046[(2)] = inst_108889);

(statearr_108967_109046[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (50))){
var inst_108892 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108892)){
var statearr_108968_109047 = state_108951__$1;
(statearr_108968_109047[(1)] = (51));

} else {
var statearr_108969_109048 = state_108951__$1;
(statearr_108969_109048[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (21))){
var inst_108803 = (state_108951[(16)]);
var state_108951__$1 = state_108951;
var statearr_108970_109049 = state_108951__$1;
(statearr_108970_109049[(2)] = inst_108803);

(statearr_108970_109049[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (31))){
var inst_108845 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108845)){
var statearr_108971_109050 = state_108951__$1;
(statearr_108971_109050[(1)] = (32));

} else {
var statearr_108972_109051 = state_108951__$1;
(statearr_108972_109051[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (32))){
var inst_108789 = (state_108951[(7)]);
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108833 = (state_108951[(9)]);
var inst_108838 = (state_108951[(11)]);
var inst_108823 = (state_108951[(15)]);
var inst_108847 = fluree.db.query.fql.flake__GT_recur_multi(db,inst_108833,inst_108838,inst_108824,inst_108822,inst_108823,fuel,max_fuel,inst_108789,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_108951__$1 = state_108951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108951__$1,(35),inst_108847);
} else {
if((state_val_108952 === (40))){
var inst_108833 = (state_108951[(9)]);
var inst_108825 = (state_108951[(14)]);
var inst_108839 = (state_108951[(12)]);
var inst_108838 = (state_108951[(11)]);
var inst_108823 = (state_108951[(15)]);
var inst_108863 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_108823,inst_108838,inst_108833,inst_108839,false,inst_108825);
var state_108951__$1 = state_108951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108951__$1,(43),inst_108863);
} else {
if((state_val_108952 === (56))){
var inst_108910 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_108973_109052 = state_108951__$1;
(statearr_108973_109052[(2)] = inst_108910);

(statearr_108973_109052[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (33))){
var inst_108838 = (state_108951[(11)]);
var inst_108852 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_108838);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108852)){
var statearr_108974_109053 = state_108951__$1;
(statearr_108974_109053[(1)] = (36));

} else {
var statearr_108975_109054 = state_108951__$1;
(statearr_108975_109054[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (13))){
var inst_108789 = (state_108951[(7)]);
var inst_108790 = (state_108951[(17)]);
var inst_108789__$1 = (state_108951[(2)]);
var inst_108790__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_108789__$1);
var state_108951__$1 = (function (){var statearr_108976 = state_108951;
(statearr_108976[(7)] = inst_108789__$1);

(statearr_108976[(17)] = inst_108790__$1);

return statearr_108976;
})();
if(cljs.core.truth_(inst_108790__$1)){
var statearr_108977_109055 = state_108951__$1;
(statearr_108977_109055[(1)] = (14));

} else {
var statearr_108978_109056 = state_108951__$1;
(statearr_108978_109056[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (22))){
var inst_108819 = (state_108951[(18)]);
var inst_108819__$1 = (state_108951[(2)]);
var inst_108820 = cljs.core.PersistentHashMap.EMPTY;
var inst_108821 = cljs.core.PersistentHashMap.EMPTY;
var inst_108822 = flakes;
var inst_108823 = inst_108819__$1;
var inst_108824 = inst_108820;
var inst_108825 = inst_108821;
var state_108951__$1 = (function (){var statearr_108979 = state_108951;
(statearr_108979[(8)] = inst_108822);

(statearr_108979[(13)] = inst_108824);

(statearr_108979[(14)] = inst_108825);

(statearr_108979[(15)] = inst_108823);

(statearr_108979[(18)] = inst_108819__$1);

return statearr_108979;
})();
var statearr_108980_109057 = state_108951__$1;
(statearr_108980_109057[(2)] = null);

(statearr_108980_109057[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (36))){
var inst_108789 = (state_108951[(7)]);
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108833 = (state_108951[(9)]);
var inst_108838 = (state_108951[(11)]);
var inst_108823 = (state_108951[(15)]);
var inst_108854 = fluree.db.query.fql.flake__GT_recur(db,inst_108833,inst_108838,inst_108824,inst_108822,inst_108823,fuel,max_fuel,inst_108789,cache);
var state_108951__$1 = state_108951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108951__$1,(39),inst_108854);
} else {
if((state_val_108952 === (41))){
var inst_108789 = (state_108951[(7)]);
var inst_108874 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_108789);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108874)){
var statearr_108981_109058 = state_108951__$1;
(statearr_108981_109058[(1)] = (44));

} else {
var statearr_108982_109059 = state_108951__$1;
(statearr_108982_109059[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (43))){
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108865 = (state_108951[(2)]);
var inst_108866 = fluree.db.util.async.throw_err(inst_108865);
var inst_108867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108866,(0),null);
var inst_108868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108866,(1),null);
var inst_108869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108870 = cljs.core.rest(inst_108822);
var inst_108871 = [inst_108867,inst_108870,inst_108824,inst_108868];
var inst_108872 = (new cljs.core.PersistentVector(null,4,(5),inst_108869,inst_108871,null));
var state_108951__$1 = state_108951;
var statearr_108983_109060 = state_108951__$1;
(statearr_108983_109060[(2)] = inst_108872);

(statearr_108983_109060[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (29))){
var inst_108838 = (state_108951[(11)]);
var inst_108842 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_108838);
var state_108951__$1 = state_108951;
var statearr_108984_109061 = state_108951__$1;
(statearr_108984_109061[(2)] = inst_108842);

(statearr_108984_109061[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (44))){
var inst_108789 = (state_108951[(7)]);
var inst_108833 = (state_108951[(9)]);
var inst_108839 = (state_108951[(12)]);
var inst_108823 = (state_108951[(15)]);
var inst_108876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108877 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_108823,inst_108789,inst_108833,inst_108839,false);
var state_108951__$1 = (function (){var statearr_108985 = state_108951;
(statearr_108985[(19)] = inst_108876);

return statearr_108985;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_108951__$1,(47),inst_108877);
} else {
if((state_val_108952 === (6))){
var state_108951__$1 = state_108951;
var statearr_108986_109062 = state_108951__$1;
(statearr_108986_109062[(2)] = null);

(statearr_108986_109062[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (28))){
var inst_108929 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_108987_109063 = state_108951__$1;
(statearr_108987_109063[(2)] = inst_108929);

(statearr_108987_109063[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (51))){
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108833 = (state_108951[(9)]);
var inst_108825 = (state_108951[(14)]);
var inst_108894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108895 = ["_id"];
var inst_108896 = inst_108833.s;
var inst_108897 = [inst_108896];
var inst_108898 = cljs.core.PersistentHashMap.fromArrays(inst_108895,inst_108897);
var inst_108899 = cljs.core.rest(inst_108822);
var inst_108900 = [inst_108898,inst_108899,inst_108824,inst_108825];
var inst_108901 = (new cljs.core.PersistentVector(null,4,(5),inst_108894,inst_108900,null));
var state_108951__$1 = state_108951;
var statearr_108988_109064 = state_108951__$1;
(statearr_108988_109064[(2)] = inst_108901);

(statearr_108988_109064[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (25))){
var inst_108789 = (state_108951[(7)]);
var inst_108783 = (state_108951[(20)]);
var inst_108803 = (state_108951[(16)]);
var inst_108819 = (state_108951[(18)]);
var inst_108931 = (state_108951[(2)]);
var inst_108932 = (function (){var top_level_subject = inst_108783;
var select_spec = inst_108789;
var base_acc = inst_108803;
var acc_PLUS_refs = inst_108819;
var result = inst_108931;
return ((function (top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,inst_108789,inst_108783,inst_108803,inst_108819,inst_108931,state_val_108952,c__99059__auto__){
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4131__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4120__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
;})(top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,inst_108789,inst_108783,inst_108803,inst_108819,inst_108931,state_val_108952,c__99059__auto__))
})();
var inst_108933 = cljs.core.PersistentVector.EMPTY;
var inst_108934 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_108789);
var inst_108935 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_108934);
var inst_108936 = cljs.core.vals(inst_108935);
var inst_108937 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_108789);
var inst_108938 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_108937);
var inst_108939 = cljs.core.vals(inst_108938);
var inst_108940 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_108936,inst_108939);
var inst_108941 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_108932,inst_108933,inst_108940);
var inst_108943 = (function (){var top_level_subject = inst_108783;
var select_spec = inst_108789;
var base_acc = inst_108803;
var acc_PLUS_refs = inst_108819;
var result = inst_108931;
var sort_preds = inst_108941;
return ((function (top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,sort_preds,inst_108789,inst_108783,inst_108803,inst_108819,inst_108931,inst_108932,inst_108933,inst_108934,inst_108935,inst_108936,inst_108937,inst_108938,inst_108939,inst_108940,inst_108941,state_val_108952,c__99059__auto__){
return (function (acc,p__108942){
var vec__108989 = p__108942;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__108989,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__108989,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__108989,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__108989,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
;})(top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,sort_preds,inst_108789,inst_108783,inst_108803,inst_108819,inst_108931,inst_108932,inst_108933,inst_108934,inst_108935,inst_108936,inst_108937,inst_108938,inst_108939,inst_108940,inst_108941,state_val_108952,c__99059__auto__))
})();
var inst_108944 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_108943,inst_108931,inst_108941);
var state_108951__$1 = state_108951;
var statearr_108992_109065 = state_108951__$1;
(statearr_108992_109065[(2)] = inst_108944);

(statearr_108992_109065[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (34))){
var inst_108833 = (state_108951[(9)]);
var inst_108920 = (state_108951[(2)]);
var inst_108921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108920,(0),null);
var inst_108922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108920,(1),null);
var inst_108923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108920,(2),null);
var inst_108924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_108920,(3),null);
var inst_108925 = inst_108833.s;
var inst_108926 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_108921,cljs.core.cst$kw$_id,inst_108925);
var inst_108822 = inst_108922;
var inst_108823 = inst_108926;
var inst_108824 = inst_108923;
var inst_108825 = inst_108924;
var state_108951__$1 = (function (){var statearr_108993 = state_108951;
(statearr_108993[(8)] = inst_108822);

(statearr_108993[(13)] = inst_108824);

(statearr_108993[(14)] = inst_108825);

(statearr_108993[(15)] = inst_108823);

return statearr_108993;
})();
var statearr_108994_109066 = state_108951__$1;
(statearr_108994_109066[(2)] = null);

(statearr_108994_109066[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (17))){
var inst_108783 = (state_108951[(20)]);
var inst_108797 = ["_id"];
var inst_108798 = [inst_108783];
var inst_108799 = cljs.core.PersistentHashMap.fromArrays(inst_108797,inst_108798);
var state_108951__$1 = state_108951;
var statearr_108995_109067 = state_108951__$1;
(statearr_108995_109067[(2)] = inst_108799);

(statearr_108995_109067[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (3))){
var inst_108768 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_108996_109068 = state_108951__$1;
(statearr_108996_109068[(2)] = inst_108768);


cljs.core.async.impl.ioc_helpers.process_exception(state_108951__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (12))){
var state_108951__$1 = state_108951;
var statearr_108997_109069 = state_108951__$1;
(statearr_108997_109069[(2)] = base_select_spec);

(statearr_108997_109069[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (2))){
var inst_108949 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_108951__$1,inst_108949);
} else {
if((state_val_108952 === (23))){
var inst_108803 = (state_108951[(16)]);
var inst_108814 = (state_108951[(2)]);
var inst_108815 = fluree.db.util.async.throw_err(inst_108814);
var inst_108816 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_108803,inst_108815], 0));
var state_108951__$1 = state_108951;
var statearr_108998_109070 = state_108951__$1;
(statearr_108998_109070[(2)] = inst_108816);

(statearr_108998_109070[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (47))){
var inst_108822 = (state_108951[(8)]);
var inst_108824 = (state_108951[(13)]);
var inst_108876 = (state_108951[(19)]);
var inst_108825 = (state_108951[(14)]);
var inst_108879 = (state_108951[(2)]);
var inst_108880 = fluree.db.util.async.throw_err(inst_108879);
var inst_108881 = cljs.core.first(inst_108880);
var inst_108882 = cljs.core.rest(inst_108822);
var inst_108883 = [inst_108881,inst_108882,inst_108824,inst_108825];
var inst_108884 = (new cljs.core.PersistentVector(null,4,(5),inst_108876,inst_108883,null));
var state_108951__$1 = state_108951;
var statearr_108999_109071 = state_108951__$1;
(statearr_108999_109071[(2)] = inst_108884);

(statearr_108999_109071[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (35))){
var inst_108849 = (state_108951[(2)]);
var inst_108850 = fluree.db.util.async.throw_err(inst_108849);
var state_108951__$1 = state_108951;
var statearr_109000_109072 = state_108951__$1;
(statearr_109000_109072[(2)] = inst_108850);

(statearr_109000_109072[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (19))){
var inst_108789 = (state_108951[(7)]);
var inst_108803 = (state_108951[(2)]);
var inst_108804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108805 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_108806 = (new cljs.core.PersistentVector(null,2,(5),inst_108804,inst_108805,null));
var inst_108807 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_108789,inst_108806);
var state_108951__$1 = (function (){var statearr_109001 = state_108951;
(statearr_109001[(16)] = inst_108803);

return statearr_109001;
})();
if(cljs.core.truth_(inst_108807)){
var statearr_109002_109073 = state_108951__$1;
(statearr_109002_109073[(1)] = (20));

} else {
var statearr_109003_109074 = state_108951__$1;
(statearr_109003_109074[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (11))){
var inst_108783 = (state_108951[(20)]);
var inst_108786 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_108783);
var state_108951__$1 = state_108951;
var statearr_109004_109075 = state_108951__$1;
(statearr_109004_109075[(2)] = inst_108786);

(statearr_109004_109075[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (9))){
var inst_108774 = (state_108951[(2)]);
var inst_108775 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_108774], 0));
var inst_108776 = (function(){throw inst_108774})();
var state_108951__$1 = (function (){var statearr_109005 = state_108951;
(statearr_109005[(21)] = inst_108775);

return statearr_109005;
})();
var statearr_109006_109076 = state_108951__$1;
(statearr_109006_109076[(2)] = inst_108776);


cljs.core.async.impl.ioc_helpers.process_exception(state_108951__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (5))){
var state_108951__$1 = state_108951;
var statearr_109007_109077 = state_108951__$1;
(statearr_109007_109077[(2)] = null);

(statearr_109007_109077[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (14))){
var inst_108790 = (state_108951[(17)]);
var state_108951__$1 = state_108951;
var statearr_109008_109078 = state_108951__$1;
(statearr_109008_109078[(2)] = inst_108790);

(statearr_109008_109078[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (45))){
var inst_108789 = (state_108951[(7)]);
var inst_108887 = (state_108951[(22)]);
var inst_108886 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_108789);
var inst_108887__$1 = cljs.core.empty_QMARK_(inst_108886);
var state_108951__$1 = (function (){var statearr_109009 = state_108951;
(statearr_109009[(22)] = inst_108887__$1);

return statearr_109009;
})();
if(inst_108887__$1){
var statearr_109010_109079 = state_108951__$1;
(statearr_109010_109079[(1)] = (48));

} else {
var statearr_109011_109080 = state_108951__$1;
(statearr_109011_109080[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (53))){
var inst_108912 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_109012_109081 = state_108951__$1;
(statearr_109012_109081[(2)] = inst_108912);

(statearr_109012_109081[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (26))){
var inst_108823 = (state_108951[(15)]);
var state_108951__$1 = state_108951;
var statearr_109013_109082 = state_108951__$1;
(statearr_109013_109082[(2)] = inst_108823);

(statearr_109013_109082[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (16))){
var inst_108795 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108795)){
var statearr_109014_109083 = state_108951__$1;
(statearr_109014_109083[(1)] = (17));

} else {
var statearr_109015_109084 = state_108951__$1;
(statearr_109015_109084[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (38))){
var inst_108918 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_109016_109085 = state_108951__$1;
(statearr_109016_109085[(2)] = inst_108918);

(statearr_109016_109085[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (30))){
var inst_108840 = (state_108951[(10)]);
var state_108951__$1 = state_108951;
var statearr_109017_109086 = state_108951__$1;
(statearr_109017_109086[(2)] = inst_108840);

(statearr_109017_109086[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_108951,(9),java.lang.Exception,null,(8));
var inst_108780 = cljs.core.first(flakes);
var inst_108781 = fluree.db.query.fql.s(inst_108780);
var state_108951__$1 = state_108951;
var statearr_109018_109087 = state_108951__$1;
(statearr_109018_109087[(2)] = inst_108781);


cljs.core.async.impl.ioc_helpers.process_exception(state_108951__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (18))){
var inst_108801 = cljs.core.PersistentHashMap.EMPTY;
var state_108951__$1 = state_108951;
var statearr_109019_109088 = state_108951__$1;
(statearr_109019_109088[(2)] = inst_108801);

(statearr_109019_109088[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (52))){
var state_108951__$1 = state_108951;
var statearr_109020_109089 = state_108951__$1;
(statearr_109020_109089[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (42))){
var inst_108916 = (state_108951[(2)]);
var state_108951__$1 = state_108951;
var statearr_109022_109090 = state_108951__$1;
(statearr_109022_109090[(2)] = inst_108916);

(statearr_109022_109090[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (37))){
var inst_108838 = (state_108951[(11)]);
var state_108951__$1 = state_108951;
if(cljs.core.truth_(inst_108838)){
var statearr_109023_109091 = state_108951__$1;
(statearr_109023_109091[(1)] = (40));

} else {
var statearr_109024_109092 = state_108951__$1;
(statearr_109024_109092[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (8))){
var inst_108783 = (state_108951[(2)]);
var inst_108784 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_108951__$1 = (function (){var statearr_109025 = state_108951;
(statearr_109025[(20)] = inst_108783);

return statearr_109025;
})();
if(cljs.core.truth_(inst_108784)){
var statearr_109026_109093 = state_108951__$1;
(statearr_109026_109093[(1)] = (11));

} else {
var statearr_109027_109094 = state_108951__$1;
(statearr_109027_109094[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_108952 === (49))){
var inst_108887 = (state_108951[(22)]);
var state_108951__$1 = state_108951;
var statearr_109028_109095 = state_108951__$1;
(statearr_109028_109095[(2)] = inst_108887);

(statearr_109028_109095[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____0 = (function (){
var statearr_109029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109029[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__);

(statearr_109029[(1)] = (1));

return statearr_109029;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____1 = (function (state_108951){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_108951);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109030){if((e109030 instanceof Object)){
var ex__99040__auto__ = e109030;
var statearr_109031_109096 = state_108951;
(statearr_109031_109096[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_108951);

return cljs.core.cst$kw$recur;
} else {
throw e109030;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109097 = state_108951;
state_108951 = G__109097;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__ = function(state_108951){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____1.call(this,state_108951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_109032 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109032[(6)] = c__99059__auto__);

return statearr_109032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__109100 = arguments.length;
switch (G__109100) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_109139){
var state_val_109140 = (state_109139[(1)]);
if((state_val_109140 === (7))){
var inst_109112 = (state_109139[(2)]);
var state_109139__$1 = (function (){var statearr_109141 = state_109139;
(statearr_109141[(7)] = inst_109112);

return statearr_109141;
})();
if(cljs.core.truth_(offset)){
var statearr_109142_109164 = state_109139__$1;
(statearr_109142_109164[(1)] = (8));

} else {
var statearr_109143_109165 = state_109139__$1;
(statearr_109143_109165[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (1))){
var state_109139__$1 = state_109139;
var statearr_109144_109166 = state_109139__$1;
(statearr_109144_109166[(2)] = null);

(statearr_109144_109166[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109139,(3),Error,null,(2));
var inst_109106 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_109139__$1 = (function (){var statearr_109145 = state_109139;
(statearr_109145[(8)] = inst_109106);

return statearr_109145;
})();
if(cljs.core.truth_(fuel)){
var statearr_109146_109167 = state_109139__$1;
(statearr_109146_109167[(1)] = (5));

} else {
var statearr_109147_109168 = state_109139__$1;
(statearr_109147_109168[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (13))){
var inst_109124 = (state_109139[(2)]);
var inst_109125 = (function (){return ((function (inst_109124,state_val_109140,c__99059__auto__){
return (function (x){
var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4120__auto__;
}
});
;})(inst_109124,state_val_109140,c__99059__auto__))
})();
var inst_109126 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_109125);
var inst_109127 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_109124,inst_109126);
var inst_109128 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_109127,flakes);
var inst_109129 = cljs.core.PersistentVector.EMPTY;
var inst_109130 = (function (){var xf = inst_109127;
var flakes_by_sub = inst_109128;
return ((function (xf,flakes_by_sub,inst_109124,inst_109125,inst_109126,inst_109127,inst_109128,inst_109129,state_val_109140,c__99059__auto__){
return (function (p1__109098_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__109098_SHARP_);
});
;})(xf,flakes_by_sub,inst_109124,inst_109125,inst_109126,inst_109127,inst_109128,inst_109129,state_val_109140,c__99059__auto__))
})();
var inst_109131 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109130,inst_109128);
var inst_109132 = fluree.db.util.async.merge_into_QMARK_(inst_109129,inst_109131);
var state_109139__$1 = state_109139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109139__$1,(14),inst_109132);
} else {
if((state_val_109140 === (6))){
var inst_109106 = (state_109139[(8)]);
var state_109139__$1 = state_109139;
var statearr_109148_109169 = state_109139__$1;
(statearr_109148_109169[(2)] = inst_109106);

(statearr_109148_109169[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (3))){
var inst_109101 = (state_109139[(2)]);
var state_109139__$1 = state_109139;
var statearr_109149_109170 = state_109139__$1;
(statearr_109149_109170[(2)] = inst_109101);


cljs.core.async.impl.ioc_helpers.process_exception(state_109139__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (12))){
var inst_109118 = (state_109139[(9)]);
var state_109139__$1 = state_109139;
var statearr_109150_109171 = state_109139__$1;
(statearr_109150_109171[(2)] = inst_109118);

(statearr_109150_109171[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (2))){
var inst_109137 = (state_109139[(2)]);
var state_109139__$1 = state_109139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109139__$1,inst_109137);
} else {
if((state_val_109140 === (11))){
var inst_109118 = (state_109139[(9)]);
var inst_109120 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_109121 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_109118,inst_109120);
var state_109139__$1 = state_109139;
var statearr_109151_109172 = state_109139__$1;
(statearr_109151_109172[(2)] = inst_109121);

(statearr_109151_109172[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (9))){
var inst_109112 = (state_109139[(7)]);
var state_109139__$1 = state_109139;
var statearr_109152_109173 = state_109139__$1;
(statearr_109152_109173[(2)] = inst_109112);

(statearr_109152_109173[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (5))){
var inst_109106 = (state_109139[(8)]);
var inst_109108 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_109109 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_109106,inst_109108);
var state_109139__$1 = state_109139;
var statearr_109153_109174 = state_109139__$1;
(statearr_109153_109174[(2)] = inst_109109);

(statearr_109153_109174[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (14))){
var inst_109134 = (state_109139[(2)]);
var inst_109135 = fluree.db.util.async.throw_err(inst_109134);
var state_109139__$1 = state_109139;
var statearr_109154_109175 = state_109139__$1;
(statearr_109154_109175[(2)] = inst_109135);


cljs.core.async.impl.ioc_helpers.process_exception(state_109139__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (10))){
var inst_109118 = (state_109139[(2)]);
var state_109139__$1 = (function (){var statearr_109155 = state_109139;
(statearr_109155[(9)] = inst_109118);

return statearr_109155;
})();
if(cljs.core.truth_(limit)){
var statearr_109156_109176 = state_109139__$1;
(statearr_109156_109176[(1)] = (11));

} else {
var statearr_109157_109177 = state_109139__$1;
(statearr_109157_109177[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109140 === (8))){
var inst_109112 = (state_109139[(7)]);
var inst_109114 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_109115 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_109112,inst_109114);
var state_109139__$1 = state_109139;
var statearr_109158_109178 = state_109139__$1;
(statearr_109158_109178[(2)] = inst_109115);

(statearr_109158_109178[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$state_machine__99037__auto__ = null;
var fluree$db$query$fql$state_machine__99037__auto____0 = (function (){
var statearr_109159 = [null,null,null,null,null,null,null,null,null,null];
(statearr_109159[(0)] = fluree$db$query$fql$state_machine__99037__auto__);

(statearr_109159[(1)] = (1));

return statearr_109159;
});
var fluree$db$query$fql$state_machine__99037__auto____1 = (function (state_109139){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109139);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109160){if((e109160 instanceof Object)){
var ex__99040__auto__ = e109160;
var statearr_109161_109179 = state_109139;
(statearr_109161_109179[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109139);

return cljs.core.cst$kw$recur;
} else {
throw e109160;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109180 = state_109139;
state_109139 = G__109180;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99037__auto__ = function(state_109139){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99037__auto____1.call(this,state_109139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99037__auto____0;
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99037__auto____1;
return fluree$db$query$fql$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_109162 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109162[(6)] = c__99059__auto__);

return statearr_109162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8;

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__109182 = arguments.length;
switch (G__109182) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_109260){
var state_val_109261 = (state_109260[(1)]);
if((state_val_109261 === (7))){
var inst_109208 = (state_109260[(7)]);
var state_109260__$1 = state_109260;
var statearr_109262_109302 = state_109260__$1;
(statearr_109262_109302[(2)] = inst_109208);

(statearr_109262_109302[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (20))){
var state_109260__$1 = state_109260;
var statearr_109263_109303 = state_109260__$1;
(statearr_109263_109303[(1)] = (22));



return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (1))){
var state_109260__$1 = state_109260;
var statearr_109265_109304 = state_109260__$1;
(statearr_109265_109304[(2)] = null);

(statearr_109265_109304[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (24))){
var inst_109250 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109266_109305 = state_109260__$1;
(statearr_109266_109305[(2)] = inst_109250);

(statearr_109266_109305[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109260,(3),Error,null,(2));
var inst_109194 = cljs.core.seq(subjects);
var inst_109195 = cljs.core.first(inst_109194);
var inst_109196 = cljs.core.next(inst_109194);
var inst_109197 = cljs.core.PersistentVector.EMPTY;
var inst_109198 = subjects;
var inst_109199 = (0);
var inst_109200 = inst_109197;
var state_109260__$1 = (function (){var statearr_109267 = state_109260;
(statearr_109267[(8)] = inst_109195);

(statearr_109267[(9)] = inst_109199);

(statearr_109267[(10)] = inst_109196);

(statearr_109267[(11)] = inst_109198);

(statearr_109267[(12)] = inst_109200);

return statearr_109267;
})();
var statearr_109268_109306 = state_109260__$1;
(statearr_109268_109306[(2)] = null);

(statearr_109268_109306[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (15))){
var inst_109254 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109269_109307 = state_109260__$1;
(statearr_109269_109307[(2)] = inst_109254);

(statearr_109269_109307[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (21))){
var inst_109252 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109270_109308 = state_109260__$1;
(statearr_109270_109308[(2)] = inst_109252);

(statearr_109270_109308[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (13))){
var inst_109200 = (state_109260[(12)]);
var state_109260__$1 = state_109260;
var statearr_109271_109309 = state_109260__$1;
(statearr_109271_109309[(2)] = inst_109200);

(statearr_109271_109309[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (22))){
var inst_109195 = (state_109260[(8)]);
var inst_109207 = (state_109260[(13)]);
var inst_109199 = (state_109260[(9)]);
var inst_109196 = (state_109260[(10)]);
var inst_109198 = (state_109260[(11)]);
var inst_109206 = (state_109260[(14)]);
var inst_109200 = (state_109260[(12)]);
var inst_109230 = (inst_109199 + (1));
var inst_109231 = (function (){var G__109190 = inst_109198;
var vec__109202 = inst_109198;
var r = inst_109207;
var first__109193 = inst_109195;
var acc = inst_109200;
var n = inst_109199;
var seq__109192 = inst_109196;
var s = inst_109206;
var vec__109191 = subjects;
var seq__109203 = inst_109207;
var first__109204 = inst_109206;
return ((function (G__109190,vec__109202,r,first__109193,acc,n,seq__109192,s,vec__109191,seq__109203,first__109204,inst_109195,inst_109207,inst_109199,inst_109196,inst_109198,inst_109206,inst_109200,inst_109230,state_val_109261,c__99059__auto__){
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
;})(G__109190,vec__109202,r,first__109193,acc,n,seq__109192,s,vec__109191,seq__109203,first__109204,inst_109195,inst_109207,inst_109199,inst_109196,inst_109198,inst_109206,inst_109200,inst_109230,state_val_109261,c__99059__auto__))
})();
var inst_109232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109233 = [inst_109206];
var inst_109234 = (new cljs.core.PersistentVector(null,1,(5),inst_109232,inst_109233,null));
var inst_109235 = [cljs.core.cst$kw$limit];
var inst_109236 = [limit];
var inst_109237 = cljs.core.PersistentHashMap.fromArrays(inst_109235,inst_109236);
var inst_109238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_109234,inst_109237);
var state_109260__$1 = (function (){var statearr_109272 = state_109260;
(statearr_109272[(15)] = inst_109230);

(statearr_109272[(16)] = inst_109231);

return statearr_109272;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109260__$1,(26),inst_109238);
} else {
if((state_val_109261 === (6))){
var inst_109256 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109273_109310 = state_109260__$1;
(statearr_109273_109310[(2)] = inst_109256);


cljs.core.async.impl.ioc_helpers.process_exception(state_109260__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (25))){
var inst_109207 = (state_109260[(13)]);
var inst_109230 = (state_109260[(15)]);
var inst_109200 = (state_109260[(12)]);
var inst_109244 = (state_109260[(2)]);
var inst_109245 = fluree.db.util.async.throw_err(inst_109244);
var inst_109246 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_109200,inst_109245);
var inst_109198 = inst_109207;
var inst_109199 = inst_109230;
var inst_109200__$1 = inst_109246;
var state_109260__$1 = (function (){var statearr_109274 = state_109260;
(statearr_109274[(9)] = inst_109199);

(statearr_109274[(11)] = inst_109198);

(statearr_109274[(12)] = inst_109200__$1);

return statearr_109274;
})();
var statearr_109275_109311 = state_109260__$1;
(statearr_109275_109311[(2)] = null);

(statearr_109275_109311[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (17))){
var state_109260__$1 = state_109260;
var statearr_109276_109312 = state_109260__$1;
(statearr_109276_109312[(2)] = offset);

(statearr_109276_109312[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (3))){
var inst_109183 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109277_109313 = state_109260__$1;
(statearr_109277_109313[(2)] = inst_109183);


cljs.core.async.impl.ioc_helpers.process_exception(state_109260__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (12))){
var inst_109215 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
var statearr_109278_109314 = state_109260__$1;
(statearr_109278_109314[(2)] = inst_109215);

(statearr_109278_109314[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (2))){
var inst_109258 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109260__$1,inst_109258);
} else {
if((state_val_109261 === (23))){
var state_109260__$1 = state_109260;
var statearr_109280_109315 = state_109260__$1;
(statearr_109280_109315[(2)] = null);

(statearr_109280_109315[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (19))){
var inst_109207 = (state_109260[(13)]);
var inst_109199 = (state_109260[(9)]);
var inst_109200 = (state_109260[(12)]);
var inst_109226 = (inst_109199 + (1));
var tmp109279 = inst_109200;
var inst_109198 = inst_109207;
var inst_109199__$1 = inst_109226;
var inst_109200__$1 = tmp109279;
var state_109260__$1 = (function (){var statearr_109281 = state_109260;
(statearr_109281[(9)] = inst_109199__$1);

(statearr_109281[(11)] = inst_109198);

(statearr_109281[(12)] = inst_109200__$1);

return statearr_109281;
})();
var statearr_109282_109316 = state_109260__$1;
(statearr_109282_109316[(2)] = null);

(statearr_109282_109316[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (11))){
var state_109260__$1 = state_109260;
var statearr_109283_109317 = state_109260__$1;
(statearr_109283_109317[(2)] = limit);

(statearr_109283_109317[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (9))){
var inst_109217 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
if(cljs.core.truth_(inst_109217)){
var statearr_109284_109318 = state_109260__$1;
(statearr_109284_109318[(1)] = (13));

} else {
var statearr_109285_109319 = state_109260__$1;
(statearr_109285_109319[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (5))){
var inst_109198 = (state_109260[(11)]);
var inst_109206 = (state_109260[(14)]);
var inst_109208 = (state_109260[(7)]);
var inst_109205 = cljs.core.seq(inst_109198);
var inst_109206__$1 = cljs.core.first(inst_109205);
var inst_109207 = cljs.core.next(inst_109205);
var inst_109208__$1 = (inst_109206__$1 == null);
var state_109260__$1 = (function (){var statearr_109286 = state_109260;
(statearr_109286[(13)] = inst_109207);

(statearr_109286[(14)] = inst_109206__$1);

(statearr_109286[(7)] = inst_109208__$1);

return statearr_109286;
})();
if(cljs.core.truth_(inst_109208__$1)){
var statearr_109287_109320 = state_109260__$1;
(statearr_109287_109320[(1)] = (7));

} else {
var statearr_109288_109321 = state_109260__$1;
(statearr_109288_109321[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (14))){
var state_109260__$1 = state_109260;
if(cljs.core.truth_(offset)){
var statearr_109289_109322 = state_109260__$1;
(statearr_109289_109322[(1)] = (16));

} else {
var statearr_109290_109323 = state_109260__$1;
(statearr_109290_109323[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (26))){
var inst_109231 = (state_109260[(16)]);
var inst_109240 = (state_109260[(2)]);
var inst_109241 = fluree.db.util.async.throw_err(inst_109240);
var inst_109242 = (inst_109231.cljs$core$IFn$_invoke$arity$1 ? inst_109231.cljs$core$IFn$_invoke$arity$1(inst_109241) : inst_109231.call(null,inst_109241));
var state_109260__$1 = state_109260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109260__$1,(25),inst_109242);
} else {
if((state_val_109261 === (16))){
var inst_109199 = (state_109260[(9)]);
var inst_109221 = (inst_109199 < offset);
var state_109260__$1 = state_109260;
var statearr_109291_109324 = state_109260__$1;
(statearr_109291_109324[(2)] = inst_109221);

(statearr_109291_109324[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (10))){
var inst_109199 = (state_109260[(9)]);
var inst_109212 = (inst_109199 > limit);
var state_109260__$1 = state_109260;
var statearr_109292_109325 = state_109260__$1;
(statearr_109292_109325[(2)] = inst_109212);

(statearr_109292_109325[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (18))){
var inst_109224 = (state_109260[(2)]);
var state_109260__$1 = state_109260;
if(cljs.core.truth_(inst_109224)){
var statearr_109293_109326 = state_109260__$1;
(statearr_109293_109326[(1)] = (19));

} else {
var statearr_109294_109327 = state_109260__$1;
(statearr_109294_109327[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109261 === (8))){
var state_109260__$1 = state_109260;
if(cljs.core.truth_(limit)){
var statearr_109295_109328 = state_109260__$1;
(statearr_109295_109328[(1)] = (10));

} else {
var statearr_109296_109329 = state_109260__$1;
(statearr_109296_109329[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$state_machine__99037__auto__ = null;
var fluree$db$query$fql$state_machine__99037__auto____0 = (function (){
var statearr_109297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109297[(0)] = fluree$db$query$fql$state_machine__99037__auto__);

(statearr_109297[(1)] = (1));

return statearr_109297;
});
var fluree$db$query$fql$state_machine__99037__auto____1 = (function (state_109260){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109260);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109298){if((e109298 instanceof Object)){
var ex__99040__auto__ = e109298;
var statearr_109299_109330 = state_109260;
(statearr_109299_109330[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109260);

return cljs.core.cst$kw$recur;
} else {
throw e109298;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109331 = state_109260;
state_109260 = G__109331;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99037__auto__ = function(state_109260){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99037__auto____1.call(this,state_109260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99037__auto____0;
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99037__auto____1;
return fluree$db$query$fql$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_109300 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109300[(6)] = c__99059__auto__);

return statearr_109300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8;

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4131__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__109333 = arguments.length;
switch (G__109333) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
});

fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_109517){
var state_val_109518 = (state_109517[(1)]);
if((state_val_109518 === (7))){
var inst_109513 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109519_109583 = state_109517__$1;
(statearr_109519_109583[(2)] = inst_109513);


cljs.core.async.impl.ioc_helpers.process_exception(state_109517__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (20))){
var inst_109402 = (state_109517[(7)]);
var inst_109411 = (state_109517[(2)]);
var inst_109412 = fluree.db.util.async.throw_err(inst_109411);
var inst_109413 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_109402,inst_109412);
var state_109517__$1 = state_109517;
var statearr_109520_109584 = state_109517__$1;
(statearr_109520_109584[(2)] = inst_109413);

(statearr_109520_109584[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (27))){
var inst_109485 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109521_109585 = state_109517__$1;
(statearr_109521_109585[(2)] = inst_109485);

(statearr_109521_109585[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (1))){
var state_109517__$1 = state_109517;
var statearr_109522_109586 = state_109517__$1;
(statearr_109522_109586[(2)] = null);

(statearr_109522_109586[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (24))){
var inst_109422 = (state_109517[(2)]);
var inst_109423 = fluree.db.util.async.throw_err(inst_109422);
var state_109517__$1 = state_109517;
var statearr_109523_109587 = state_109517__$1;
(statearr_109523_109587[(2)] = inst_109423);

(statearr_109523_109587[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (39))){
var inst_109479 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109524_109588 = state_109517__$1;
(statearr_109524_109588[(2)] = inst_109479);

(statearr_109524_109588[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (46))){
var inst_109506 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109525_109589 = state_109517__$1;
(statearr_109525_109589[(2)] = inst_109506);

(statearr_109525_109589[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (4))){
var inst_109343 = (state_109517[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109517,(3),Error,null,(2));
var inst_109341 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_109342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109341,(0),null);
var inst_109343__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109341,(1),null);
var inst_109344 = cljs.core.not_empty(inst_109343__$1);
var state_109517__$1 = (function (){var statearr_109526 = state_109517;
(statearr_109526[(9)] = inst_109342);

(statearr_109526[(8)] = inst_109343__$1);

return statearr_109526;
})();
if(cljs.core.truth_(inst_109344)){
var statearr_109527_109590 = state_109517__$1;
(statearr_109527_109590[(1)] = (5));

} else {
var statearr_109528_109591 = state_109517__$1;
(statearr_109528_109591[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (15))){
var inst_109373 = (state_109517[(10)]);
var inst_109387 = (state_109517[(2)]);
var inst_109391 = (cljs.core.not_EQ_ === inst_109373);
var state_109517__$1 = (function (){var statearr_109529 = state_109517;
(statearr_109529[(11)] = inst_109387);

return statearr_109529;
})();
if(inst_109391){
var statearr_109530_109592 = state_109517__$1;
(statearr_109530_109592[(1)] = (16));

} else {
var statearr_109531_109593 = state_109517__$1;
(statearr_109531_109593[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (21))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109418 = [inst_109372,inst_109374];
var inst_109419 = (new cljs.core.PersistentVector(null,2,(5),inst_109417,inst_109418,null));
var inst_109420 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_109419);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(24),inst_109420);
} else {
if((state_val_109518 === (31))){
var inst_109483 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109532_109594 = state_109517__$1;
(statearr_109532_109594[(2)] = inst_109483);

(statearr_109532_109594[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (32))){
var inst_109448 = (state_109517[(2)]);
var inst_109449 = fluree.db.util.async.throw_err(inst_109448);
var state_109517__$1 = state_109517;
var statearr_109533_109595 = state_109517__$1;
(statearr_109533_109595[(2)] = inst_109449);

(statearr_109533_109595[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (40))){
var inst_109474 = (state_109517[(2)]);
var inst_109475 = fluree.db.util.async.throw_err(inst_109474);
var state_109517__$1 = state_109517;
var statearr_109534_109596 = state_109517__$1;
(statearr_109534_109596[(2)] = inst_109475);

(statearr_109534_109596[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (33))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109454 = [inst_109372];
var inst_109455 = (new cljs.core.PersistentVector(null,1,(5),inst_109453,inst_109454,null));
var inst_109456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109457 = [inst_109372,inst_109374];
var inst_109458 = (new cljs.core.PersistentVector(null,2,(5),inst_109456,inst_109457,null));
var inst_109459 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_109455,cljs.core._LT_,inst_109458);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(36),inst_109459);
} else {
if((state_val_109518 === (13))){
var inst_109372 = (state_109517[(12)]);
var inst_109378 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_109372);
var inst_109379 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_109378)].join('');
var inst_109380 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_109381 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_109382 = cljs.core.PersistentHashMap.fromArrays(inst_109380,inst_109381);
var inst_109383 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_109379,inst_109382);
var inst_109384 = (function(){throw inst_109383})();
var state_109517__$1 = state_109517;
var statearr_109535_109597 = state_109517__$1;
(statearr_109535_109597[(2)] = inst_109384);

(statearr_109535_109597[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (22))){
var inst_109373 = (state_109517[(10)]);
var inst_109425 = (cljs.core._GT_ === inst_109373);
var state_109517__$1 = state_109517;
if(inst_109425){
var statearr_109536_109598 = state_109517__$1;
(statearr_109536_109598[(1)] = (25));

} else {
var statearr_109537_109599 = state_109517__$1;
(statearr_109537_109599[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (36))){
var inst_109461 = (state_109517[(2)]);
var inst_109462 = fluree.db.util.async.throw_err(inst_109461);
var state_109517__$1 = state_109517;
var statearr_109538_109600 = state_109517__$1;
(statearr_109538_109600[(2)] = inst_109462);

(statearr_109538_109600[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (41))){
var inst_109342 = (state_109517[(9)]);
var inst_109498 = (state_109517[(14)]);
var inst_109498__$1 = (state_109517[(2)]);
var inst_109499 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_109342);
var inst_109500 = cljs.core.empty_QMARK_(inst_109498__$1);
var inst_109501 = ((inst_109499) && (inst_109500));
var state_109517__$1 = (function (){var statearr_109539 = state_109517;
(statearr_109539[(14)] = inst_109498__$1);

return statearr_109539;
})();
if(cljs.core.truth_(inst_109501)){
var statearr_109540_109601 = state_109517__$1;
(statearr_109540_109601[(1)] = (44));

} else {
var statearr_109541_109602 = state_109517__$1;
(statearr_109541_109602[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (43))){
var inst_109358 = (state_109517[(15)]);
var inst_109490 = (state_109517[(16)]);
var inst_109493 = cljs.core.PersistentHashSet.EMPTY;
var inst_109494 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_109493,inst_109490);
var inst_109495 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_109358,inst_109494);
var state_109517__$1 = state_109517;
var statearr_109542_109603 = state_109517__$1;
(statearr_109542_109603[(2)] = inst_109495);

(statearr_109542_109603[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (29))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109441 = [inst_109372,inst_109374];
var inst_109442 = (new cljs.core.PersistentVector(null,2,(5),inst_109440,inst_109441,null));
var inst_109443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109444 = [inst_109372];
var inst_109445 = (new cljs.core.PersistentVector(null,1,(5),inst_109443,inst_109444,null));
var inst_109446 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_109442,cljs.core._LT__EQ_,inst_109445);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(32),inst_109446);
} else {
if((state_val_109518 === (44))){
var inst_109498 = (state_109517[(14)]);
var state_109517__$1 = state_109517;
var statearr_109543_109604 = state_109517__$1;
(statearr_109543_109604[(2)] = inst_109498);

(statearr_109543_109604[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (6))){
var state_109517__$1 = state_109517;
var statearr_109544_109605 = state_109517__$1;
(statearr_109544_109605[(2)] = null);

(statearr_109544_109605[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (28))){
var inst_109435 = (state_109517[(2)]);
var inst_109436 = fluree.db.util.async.throw_err(inst_109435);
var state_109517__$1 = state_109517;
var statearr_109545_109606 = state_109517__$1;
(statearr_109545_109606[(2)] = inst_109436);

(statearr_109545_109606[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (25))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109428 = [inst_109372,inst_109374];
var inst_109429 = (new cljs.core.PersistentVector(null,2,(5),inst_109427,inst_109428,null));
var inst_109430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109431 = [inst_109372];
var inst_109432 = (new cljs.core.PersistentVector(null,1,(5),inst_109430,inst_109431,null));
var inst_109433 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_109429,cljs.core._LT__EQ_,inst_109432);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(28),inst_109433);
} else {
if((state_val_109518 === (34))){
var inst_109373 = (state_109517[(10)]);
var inst_109464 = (cljs.core._LT__EQ_ === inst_109373);
var state_109517__$1 = state_109517;
if(inst_109464){
var statearr_109546_109607 = state_109517__$1;
(statearr_109546_109607[(1)] = (37));

} else {
var statearr_109547_109608 = state_109517__$1;
(statearr_109547_109608[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (17))){
var inst_109373 = (state_109517[(10)]);
var inst_109415 = (cljs.core._EQ_ === inst_109373);
var state_109517__$1 = state_109517;
if(inst_109415){
var statearr_109548_109609 = state_109517__$1;
(statearr_109548_109609[(1)] = (21));

} else {
var statearr_109549_109610 = state_109517__$1;
(statearr_109549_109610[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (3))){
var inst_109334 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109550_109611 = state_109517__$1;
(statearr_109550_109611[(2)] = inst_109334);


cljs.core.async.impl.ioc_helpers.process_exception(state_109517__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (12))){
var inst_109508 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109551_109612 = state_109517__$1;
(statearr_109551_109612[(2)] = inst_109508);

(statearr_109551_109612[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (2))){
var inst_109515 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109517__$1,inst_109515);
} else {
if((state_val_109518 === (23))){
var inst_109487 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109552_109613 = state_109517__$1;
(statearr_109552_109613[(2)] = inst_109487);

(statearr_109552_109613[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (35))){
var inst_109481 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109553_109614 = state_109517__$1;
(statearr_109553_109614[(2)] = inst_109481);

(statearr_109553_109614[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (19))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109401 = (state_109517[(2)]);
var inst_109402 = fluree.db.util.async.throw_err(inst_109401);
var inst_109403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109404 = [inst_109372];
var inst_109405 = (new cljs.core.PersistentVector(null,1,(5),inst_109403,inst_109404,null));
var inst_109406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109407 = [inst_109372,inst_109374];
var inst_109408 = (new cljs.core.PersistentVector(null,2,(5),inst_109406,inst_109407,null));
var inst_109409 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_109405,cljs.core._LT_,inst_109408);
var state_109517__$1 = (function (){var statearr_109554 = state_109517;
(statearr_109554[(7)] = inst_109402);

return statearr_109554;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(20),inst_109409);
} else {
if((state_val_109518 === (11))){
var inst_109372 = (state_109517[(12)]);
var inst_109364 = (state_109517[(17)]);
var inst_109372__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109364,(0),null);
var inst_109373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109364,(1),null);
var inst_109374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_109364,(2),null);
var inst_109375 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_109372__$1);
var inst_109376 = cljs.core.not(inst_109375);
var state_109517__$1 = (function (){var statearr_109555 = state_109517;
(statearr_109555[(12)] = inst_109372__$1);

(statearr_109555[(13)] = inst_109374);

(statearr_109555[(10)] = inst_109373);

return statearr_109555;
})();
if(inst_109376){
var statearr_109556_109615 = state_109517__$1;
(statearr_109556_109615[(1)] = (13));

} else {
var statearr_109557_109616 = state_109517__$1;
(statearr_109557_109616[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (9))){
var inst_109510 = (state_109517[(2)]);
var state_109517__$1 = state_109517;
var statearr_109558_109617 = state_109517__$1;
(statearr_109558_109617[(2)] = inst_109510);

(statearr_109558_109617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (5))){
var inst_109343 = (state_109517[(8)]);
var inst_109353 = cljs.core.seq(inst_109343);
var inst_109354 = cljs.core.first(inst_109353);
var inst_109355 = cljs.core.next(inst_109353);
var inst_109356 = cljs.core.PersistentHashSet.EMPTY;
var inst_109357 = inst_109343;
var inst_109358 = inst_109356;
var state_109517__$1 = (function (){var statearr_109559 = state_109517;
(statearr_109559[(15)] = inst_109358);

(statearr_109559[(18)] = inst_109354);

(statearr_109559[(19)] = inst_109357);

(statearr_109559[(20)] = inst_109355);

return statearr_109559;
})();
var statearr_109560_109618 = state_109517__$1;
(statearr_109560_109618[(2)] = null);

(statearr_109560_109618[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (14))){
var state_109517__$1 = state_109517;
var statearr_109561_109619 = state_109517__$1;
(statearr_109561_109619[(2)] = null);

(statearr_109561_109619[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (45))){
var inst_109365 = (state_109517[(21)]);
var inst_109498 = (state_109517[(14)]);
var inst_109357 = inst_109365;
var inst_109358 = inst_109498;
var state_109517__$1 = (function (){var statearr_109562 = state_109517;
(statearr_109562[(15)] = inst_109358);

(statearr_109562[(19)] = inst_109357);

return statearr_109562;
})();
var statearr_109563_109620 = state_109517__$1;
(statearr_109563_109620[(2)] = null);

(statearr_109563_109620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (26))){
var inst_109373 = (state_109517[(10)]);
var inst_109438 = (cljs.core._GT__EQ_ === inst_109373);
var state_109517__$1 = state_109517;
if(inst_109438){
var statearr_109564_109621 = state_109517__$1;
(statearr_109564_109621[(1)] = (29));

} else {
var statearr_109565_109622 = state_109517__$1;
(statearr_109565_109622[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (16))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109394 = [inst_109372,inst_109374];
var inst_109395 = (new cljs.core.PersistentVector(null,2,(5),inst_109393,inst_109394,null));
var inst_109396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109397 = [inst_109372];
var inst_109398 = (new cljs.core.PersistentVector(null,1,(5),inst_109396,inst_109397,null));
var inst_109399 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_109395,cljs.core._LT__EQ_,inst_109398);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(19),inst_109399);
} else {
if((state_val_109518 === (38))){
var inst_109477 = null;
var state_109517__$1 = state_109517;
var statearr_109566_109623 = state_109517__$1;
(statearr_109566_109623[(2)] = inst_109477);

(statearr_109566_109623[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (30))){
var inst_109373 = (state_109517[(10)]);
var inst_109451 = (cljs.core._LT_ === inst_109373);
var state_109517__$1 = state_109517;
if(inst_109451){
var statearr_109567_109624 = state_109517__$1;
(statearr_109567_109624[(1)] = (33));

} else {
var statearr_109568_109625 = state_109517__$1;
(statearr_109568_109625[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (10))){
var inst_109358 = (state_109517[(15)]);
var state_109517__$1 = state_109517;
var statearr_109569_109626 = state_109517__$1;
(statearr_109569_109626[(2)] = inst_109358);

(statearr_109569_109626[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (18))){
var inst_109342 = (state_109517[(9)]);
var inst_109489 = (state_109517[(2)]);
var inst_109490 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_109489);
var state_109517__$1 = (function (){var statearr_109570 = state_109517;
(statearr_109570[(16)] = inst_109490);

return statearr_109570;
})();
var G__109571_109627 = inst_109342;
var G__109571_109628__$1 = (((G__109571_109627 instanceof cljs.core.Keyword))?G__109571_109627.fqn:null);
switch (G__109571_109628__$1) {
case "or":
var statearr_109572_109630 = state_109517__$1;
(statearr_109572_109630[(1)] = (42));


break;
case "and":
var statearr_109573_109631 = state_109517__$1;
(statearr_109573_109631[(1)] = (43));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__109571_109628__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (42))){
var inst_109358 = (state_109517[(15)]);
var inst_109490 = (state_109517[(16)]);
var inst_109491 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_109358,inst_109490);
var state_109517__$1 = state_109517;
var statearr_109574_109632 = state_109517__$1;
(statearr_109574_109632[(2)] = inst_109491);

(statearr_109574_109632[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109518 === (37))){
var inst_109372 = (state_109517[(12)]);
var inst_109374 = (state_109517[(13)]);
var inst_109466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109467 = [inst_109372];
var inst_109468 = (new cljs.core.PersistentVector(null,1,(5),inst_109466,inst_109467,null));
var inst_109469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_109470 = [inst_109372,inst_109374];
var inst_109471 = (new cljs.core.PersistentVector(null,2,(5),inst_109469,inst_109470,null));
var inst_109472 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_109468,cljs.core._LT__EQ_,inst_109471);
var state_109517__$1 = state_109517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109517__$1,(40),inst_109472);
} else {
if((state_val_109518 === (8))){
var inst_109357 = (state_109517[(19)]);
var inst_109364 = (state_109517[(17)]);
var inst_109363 = cljs.core.seq(inst_109357);
var inst_109364__$1 = cljs.core.first(inst_109363);
var inst_109365 = cljs.core.next(inst_109363);
var inst_109366 = cljs.core.not(inst_109364__$1);
var state_109517__$1 = (function (){var statearr_109575 = state_109517;
(statearr_109575[(21)] = inst_109365);

(statearr_109575[(17)] = inst_109364__$1);

return statearr_109575;
})();
if(inst_109366){
var statearr_109576_109633 = state_109517__$1;
(statearr_109576_109633[(1)] = (10));

} else {
var statearr_109577_109634 = state_109517__$1;
(statearr_109577_109634[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$state_machine__99037__auto__ = null;
var fluree$db$query$fql$state_machine__99037__auto____0 = (function (){
var statearr_109578 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109578[(0)] = fluree$db$query$fql$state_machine__99037__auto__);

(statearr_109578[(1)] = (1));

return statearr_109578;
});
var fluree$db$query$fql$state_machine__99037__auto____1 = (function (state_109517){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109517);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109579){if((e109579 instanceof Object)){
var ex__99040__auto__ = e109579;
var statearr_109580_109635 = state_109517;
(statearr_109580_109635[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109517);

return cljs.core.cst$kw$recur;
} else {
throw e109579;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109636 = state_109517;
state_109517 = G__109636;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99037__auto__ = function(state_109517){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99037__auto____1.call(this,state_109517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99037__auto____0;
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99037__auto____1;
return fluree$db$query$fql$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_109581 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109581[(6)] = c__99059__auto__);

return statearr_109581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3;

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__109638,offset,limit){
var map__109639 = p__109638;
var map__109639__$1 = (((((!((map__109639 == null))))?(((((map__109639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109639):map__109639);
var res = map__109639__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109639__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109639__$1,cljs.core.cst$kw$tuples);
var vec__109641 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109641,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__109641,(1),null);
var indexOfFind = (function (){var or__4131__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__109644 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(((function (vec__109641,order,var$,indexOfFind,map__109639,map__109639__$1,res,headers,tuples){
return (function (p1__109637_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__109637_SHARP_,indexOfFind);
});})(vec__109641,order,var$,indexOfFind,map__109639,map__109639__$1,res,headers,tuples))
,fluree.db.query.fql.compare_fn,tuples);
var G__109644__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__109644):G__109644);
var G__109644__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__109644__$1):G__109644__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__109644__$2);
} else {
return G__109644__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4131__auto__ = cljs.core.every_QMARK_((function (p1__109645_SHARP_){
return ((typeof p1__109645_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__109645_SHARP_)));
}),select_smt);
if(or__4131__auto__){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_,vars__$1,all_vars){
return (function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
});})(_,vars__$1,all_vars))
,select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_(((function (vars,freqs){
return (function (p1__109646_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__109646_SHARP_);
});})(vars,freqs))
,cljs.core.vals(freqs))){
return vars;
} else {
var G__109650 = vars;
var vec__109651 = G__109650;
var seq__109652 = cljs.core.seq(vec__109651);
var first__109653 = cljs.core.first(seq__109652);
var seq__109652__$1 = cljs.core.next(seq__109652);
var var$ = first__109653;
var r = seq__109652__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__109650__$1 = G__109650;
var all_vars__$1 = all_vars;
while(true){
var vec__109658 = G__109650__$1;
var seq__109659 = cljs.core.seq(vec__109658);
var first__109660 = cljs.core.first(seq__109659);
var seq__109659__$1 = cljs.core.next(seq__109659);
var var$__$1 = first__109660;
var r__$1 = seq__109659__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__109661 = cljs.core.set(all_vars__$2);
return (fexpr__109661.cljs$core$IFn$_invoke$arity$1 ? fexpr__109661.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__109661.call(null,var$__$1));
})())){
var G__109662 = r__$1;
var G__109663 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__109650__$1 = G__109662;
all_vars__$1 = G__109663;
continue;
} else {
var G__109664 = r__$1;
var G__109665 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__109650__$1 = G__109664;
all_vars__$1 = G__109665;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_109699){
var state_val_109700 = (state_109699[(1)]);
if((state_val_109700 === (1))){
var inst_109673 = cljs.core.seq(functionArray);
var inst_109674 = cljs.core.first(inst_109673);
var inst_109675 = cljs.core.next(inst_109673);
var inst_109676 = cljs.core.PersistentVector.EMPTY;
var inst_109677 = functionArray;
var inst_109678 = inst_109676;
var state_109699__$1 = (function (){var statearr_109701 = state_109699;
(statearr_109701[(7)] = inst_109678);

(statearr_109701[(8)] = inst_109675);

(statearr_109701[(9)] = inst_109677);

(statearr_109701[(10)] = inst_109674);

return statearr_109701;
})();
var statearr_109702_109714 = state_109699__$1;
(statearr_109702_109714[(2)] = null);

(statearr_109702_109714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109700 === (2))){
var inst_109684 = (state_109699[(11)]);
var inst_109677 = (state_109699[(9)]);
var inst_109683 = cljs.core.seq(inst_109677);
var inst_109684__$1 = cljs.core.first(inst_109683);
var inst_109685 = cljs.core.next(inst_109683);
var state_109699__$1 = (function (){var statearr_109703 = state_109699;
(statearr_109703[(11)] = inst_109684__$1);

(statearr_109703[(12)] = inst_109685);

return statearr_109703;
})();
if(cljs.core.truth_(inst_109684__$1)){
var statearr_109704_109715 = state_109699__$1;
(statearr_109704_109715[(1)] = (4));

} else {
var statearr_109705_109716 = state_109699__$1;
(statearr_109705_109716[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109700 === (3))){
var inst_109697 = (state_109699[(2)]);
var state_109699__$1 = state_109699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109699__$1,inst_109697);
} else {
if((state_val_109700 === (4))){
var inst_109684 = (state_109699[(11)]);
var inst_109687 = (inst_109684.cljs$core$IFn$_invoke$arity$1 ? inst_109684.cljs$core$IFn$_invoke$arity$1(tuple) : inst_109684.call(null,tuple));
var state_109699__$1 = state_109699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109699__$1,(7),inst_109687);
} else {
if((state_val_109700 === (5))){
var inst_109678 = (state_109699[(7)]);
var state_109699__$1 = state_109699;
var statearr_109706_109717 = state_109699__$1;
(statearr_109706_109717[(2)] = inst_109678);

(statearr_109706_109717[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109700 === (6))){
var inst_109695 = (state_109699[(2)]);
var state_109699__$1 = state_109699;
var statearr_109707_109718 = state_109699__$1;
(statearr_109707_109718[(2)] = inst_109695);

(statearr_109707_109718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109700 === (7))){
var inst_109678 = (state_109699[(7)]);
var inst_109685 = (state_109699[(12)]);
var inst_109689 = (state_109699[(2)]);
var inst_109690 = fluree.db.util.async.throw_err(inst_109689);
var inst_109691 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_109678,inst_109690);
var inst_109677 = inst_109685;
var inst_109678__$1 = inst_109691;
var state_109699__$1 = (function (){var statearr_109708 = state_109699;
(statearr_109708[(7)] = inst_109678__$1);

(statearr_109708[(9)] = inst_109677);

return statearr_109708;
})();
var statearr_109709_109719 = state_109699__$1;
(statearr_109709_109719[(2)] = null);

(statearr_109709_109719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____0 = (function (){
var statearr_109710 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109710[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__);

(statearr_109710[(1)] = (1));

return statearr_109710;
});
var fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____1 = (function (state_109699){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109699);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109711){if((e109711 instanceof Object)){
var ex__99040__auto__ = e109711;
var statearr_109712_109720 = state_109699;
(statearr_109712_109720[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109699);

return cljs.core.cst$kw$recur;
} else {
throw e109711;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109721 = state_109699;
state_109699 = G__109721;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__ = function(state_109699){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____1.call(this,state_109699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__99037__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_109713 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109713[(6)] = c__99059__auto__);

return statearr_109713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__109723,headers,vars,opts){
var map__109724 = p__109723;
var map__109724__$1 = (((((!((map__109724 == null))))?(((((map__109724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109724.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109724):map__109724);
var select_spec = map__109724__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109724__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109724__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109724__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109724__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_109807){
var state_val_109808 = (state_109807[(1)]);
if((state_val_109808 === (7))){
var inst_109734 = (state_109807[(2)]);
var state_109807__$1 = (function (){var statearr_109809 = state_109807;
(statearr_109809[(7)] = inst_109734);

return statearr_109809;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_109810_109923 = state_109807__$1;
(statearr_109810_109923[(1)] = (8));

} else {
var statearr_109811_109924 = state_109807__$1;
(statearr_109811_109924[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (1))){
var state_109807__$1 = state_109807;
var statearr_109812_109925 = state_109807__$1;
(statearr_109812_109925[(2)] = null);

(statearr_109812_109925[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109807,(3),Error,null,(2));
var state_109807__$1 = state_109807;
if(cljs.core.truth_(prettyPrint)){
var statearr_109813_109926 = state_109807__$1;
(statearr_109813_109926[(1)] = (5));

} else {
var statearr_109814_109927 = state_109807__$1;
(statearr_109814_109927[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (13))){
var inst_109803 = (state_109807[(2)]);
var state_109807__$1 = state_109807;
var statearr_109815_109928 = state_109807__$1;
(statearr_109815_109928[(2)] = inst_109803);


cljs.core.async.impl.ioc_helpers.process_exception(state_109807__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (6))){
var state_109807__$1 = state_109807;
var statearr_109816_109929 = state_109807__$1;
(statearr_109816_109929[(2)] = null);

(statearr_109816_109929[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (3))){
var inst_109726 = (state_109807[(2)]);
var state_109807__$1 = state_109807;
var statearr_109817_109930 = state_109807__$1;
(statearr_109817_109930[(2)] = inst_109726);


cljs.core.async.impl.ioc_helpers.process_exception(state_109807__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (12))){
var inst_109742 = (state_109807[(8)]);
var inst_109734 = (state_109807[(7)]);
var inst_109800 = (function (){var pp = inst_109734;
var functionArray = inst_109742;
return ((function (pp,functionArray,inst_109742,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (pp,functionArray,inst_109742,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (p1__109722_SHARP_){
return (p1__109722_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__109722_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__109722_SHARP_.call(null,tuple));
});})(pp,functionArray,inst_109742,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
,functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
;})(pp,functionArray,inst_109742,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_109801 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109800,tuples);
var state_109807__$1 = state_109807;
var statearr_109818_109931 = state_109807__$1;
(statearr_109818_109931[(2)] = inst_109801);

(statearr_109818_109931[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (2))){
var inst_109805 = (state_109807[(2)]);
var state_109807__$1 = state_109807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109807__$1,inst_109805);
} else {
if((state_val_109808 === (11))){
var inst_109742 = (state_109807[(8)]);
var inst_109734 = (state_109807[(7)]);
var inst_109793 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_109794 = (function (){var pp = inst_109734;
var functionArray = inst_109742;
var c__99059__auto____$1 = inst_109793;
return ((function (pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_109791){
var state_val_109792 = (state_109791[(1)]);
if((state_val_109792 === (7))){
var inst_109767 = (state_109791[(2)]);
var inst_109768 = fluree.db.util.async.throw_err(inst_109767);
var state_109791__$1 = (function (){var statearr_109819 = state_109791;
(statearr_109819[(7)] = inst_109768);

return statearr_109819;
})();
if(cljs.core.truth_(pp)){
var statearr_109820_109932 = state_109791__$1;
(statearr_109820_109932[(1)] = (8));

} else {
var statearr_109821_109933 = state_109791__$1;
(statearr_109821_109933[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (1))){
var inst_109751 = cljs.core.seq(tuples);
var inst_109752 = cljs.core.first(inst_109751);
var inst_109753 = cljs.core.next(inst_109751);
var inst_109754 = cljs.core.PersistentVector.EMPTY;
var inst_109755 = tuples;
var inst_109756 = inst_109754;
var state_109791__$1 = (function (){var statearr_109822 = state_109791;
(statearr_109822[(8)] = inst_109752);

(statearr_109822[(9)] = inst_109753);

(statearr_109822[(10)] = inst_109756);

(statearr_109822[(11)] = inst_109755);

return statearr_109822;
})();
var statearr_109823_109934 = state_109791__$1;
(statearr_109823_109934[(2)] = null);

(statearr_109823_109934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (4))){
var inst_109762 = (state_109791[(12)]);
var inst_109765 = fluree.db.query.fql.format_tuple(functionArray,inst_109762);
var state_109791__$1 = state_109791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109791__$1,(7),inst_109765);
} else {
if((state_val_109792 === (15))){
var state_109791__$1 = state_109791;
var statearr_109824_109935 = state_109791__$1;
(statearr_109824_109935[(2)] = null);

(statearr_109824_109935[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (13))){
var inst_109780 = (state_109791[(2)]);
var state_109791__$1 = state_109791;
var statearr_109825_109936 = state_109791__$1;
(statearr_109825_109936[(2)] = inst_109780);

(statearr_109825_109936[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (6))){
var inst_109787 = (state_109791[(2)]);
var state_109791__$1 = state_109791;
var statearr_109826_109937 = state_109791__$1;
(statearr_109826_109937[(2)] = inst_109787);

(statearr_109826_109937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (3))){
var inst_109789 = (state_109791[(2)]);
var state_109791__$1 = state_109791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109791__$1,inst_109789);
} else {
if((state_val_109792 === (12))){
var state_109791__$1 = state_109791;
var statearr_109827_109938 = state_109791__$1;
(statearr_109827_109938[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (2))){
var inst_109762 = (state_109791[(12)]);
var inst_109755 = (state_109791[(11)]);
var inst_109761 = cljs.core.seq(inst_109755);
var inst_109762__$1 = cljs.core.first(inst_109761);
var inst_109763 = cljs.core.next(inst_109761);
var state_109791__$1 = (function (){var statearr_109829 = state_109791;
(statearr_109829[(13)] = inst_109763);

(statearr_109829[(12)] = inst_109762__$1);

return statearr_109829;
})();
if(cljs.core.truth_(inst_109762__$1)){
var statearr_109830_109939 = state_109791__$1;
(statearr_109830_109939[(1)] = (4));

} else {
var statearr_109831_109940 = state_109791__$1;
(statearr_109831_109940[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (11))){
var inst_109768 = (state_109791[(7)]);
var state_109791__$1 = state_109791;
var statearr_109832_109941 = state_109791__$1;
(statearr_109832_109941[(2)] = inst_109768);

(statearr_109832_109941[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (9))){
var state_109791__$1 = state_109791;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_109833_109942 = state_109791__$1;
(statearr_109833_109942[(1)] = (11));

} else {
var statearr_109834_109943 = state_109791__$1;
(statearr_109834_109943[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (5))){
var inst_109756 = (state_109791[(10)]);
var state_109791__$1 = state_109791;
var statearr_109835_109944 = state_109791__$1;
(statearr_109835_109944[(2)] = inst_109756);

(statearr_109835_109944[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (14))){
var inst_109768 = (state_109791[(7)]);
var inst_109775 = cljs.core.first(inst_109768);
var state_109791__$1 = state_109791;
var statearr_109836_109945 = state_109791__$1;
(statearr_109836_109945[(2)] = inst_109775);

(statearr_109836_109945[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (16))){
var inst_109778 = (state_109791[(2)]);
var state_109791__$1 = state_109791;
var statearr_109837_109946 = state_109791__$1;
(statearr_109837_109946[(2)] = inst_109778);

(statearr_109837_109946[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (10))){
var inst_109763 = (state_109791[(13)]);
var inst_109756 = (state_109791[(10)]);
var inst_109782 = (state_109791[(2)]);
var inst_109783 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_109756,inst_109782);
var inst_109755 = inst_109763;
var inst_109756__$1 = inst_109783;
var state_109791__$1 = (function (){var statearr_109838 = state_109791;
(statearr_109838[(10)] = inst_109756__$1);

(statearr_109838[(11)] = inst_109755);

return statearr_109838;
})();
var statearr_109839_109947 = state_109791__$1;
(statearr_109839_109947[(2)] = null);

(statearr_109839_109947[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109792 === (8))){
var inst_109768 = (state_109791[(7)]);
var inst_109770 = cljs.core.zipmap(pp,inst_109768);
var state_109791__$1 = state_109791;
var statearr_109840_109948 = state_109791__$1;
(statearr_109840_109948[(2)] = inst_109770);

(statearr_109840_109948[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__99036__auto__,pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_109841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_109841[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__);

(statearr_109841[(1)] = (1));

return statearr_109841;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1 = (function (state_109791){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109791);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109842){if((e109842 instanceof Object)){
var ex__99040__auto__ = e109842;
var statearr_109843_109949 = state_109791;
(statearr_109843_109949[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109791);

return cljs.core.cst$kw$recur;
} else {
throw e109842;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109950 = state_109791;
state_109791 = G__109950;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = function(state_109791){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1.call(this,state_109791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__99061__auto__ = (function (){var statearr_109844 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109844[(6)] = c__99059__auto____$1);

return statearr_109844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});
;})(pp,functionArray,c__99059__auto____$1,inst_109742,inst_109734,inst_109793,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_109795 = cljs.core.async.impl.dispatch.run(inst_109794);
var state_109807__$1 = (function (){var statearr_109845 = state_109807;
(statearr_109845[(9)] = inst_109795);

return statearr_109845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109807__$1,(14),inst_109793);
} else {
if((state_val_109808 === (9))){
var inst_109734 = (state_109807[(7)]);
var inst_109739 = (function (){var pp = inst_109734;
return ((function (pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return ((function (val,temp__5733__auto__,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (x){
return val;
});
;})(val,temp__5733__auto__,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return ((function (idx,temp__5733__auto__,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
;})(idx,temp__5733__auto__,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
}
});
;})(pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_109740 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109739,select);
var state_109807__$1 = state_109807;
var statearr_109846_109951 = state_109807__$1;
(statearr_109846_109951[(2)] = inst_109740);

(statearr_109846_109951[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (5))){
var inst_109731 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_109807__$1 = state_109807;
var statearr_109847_109952 = state_109807__$1;
(statearr_109847_109952[(2)] = inst_109731);

(statearr_109847_109952[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (14))){
var inst_109797 = (state_109807[(2)]);
var inst_109798 = fluree.db.util.async.throw_err(inst_109797);
var state_109807__$1 = state_109807;
var statearr_109848_109953 = state_109807__$1;
(statearr_109848_109953[(2)] = inst_109798);

(statearr_109848_109953[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (10))){
var inst_109742 = (state_109807[(2)]);
var state_109807__$1 = (function (){var statearr_109849 = state_109807;
(statearr_109849[(8)] = inst_109742);

return statearr_109849;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_109850_109954 = state_109807__$1;
(statearr_109850_109954[(1)] = (11));

} else {
var statearr_109851_109955 = state_109807__$1;
(statearr_109851_109955[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109808 === (8))){
var inst_109734 = (state_109807[(7)]);
var inst_109736 = (function (){var pp = inst_109734;
return ((function (pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (select__$1){
var select_val = (function (){var or__4131__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?((function (select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});})(select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?((function (select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
});})(select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?((function (select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
});})(select_val,idx,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return ((function (select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var c__99059__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_109883){
var state_val_109884 = (state_109883[(1)]);
if((state_val_109884 === (7))){
var inst_109879 = (state_109883[(2)]);
var state_109883__$1 = state_109883;
var statearr_109885_109956 = state_109883__$1;
(statearr_109885_109956[(2)] = inst_109879);


cljs.core.async.impl.ioc_helpers.process_exception(state_109883__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (1))){
var state_109883__$1 = state_109883;
var statearr_109886_109957 = state_109883__$1;
(statearr_109886_109957[(2)] = null);

(statearr_109886_109957[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109883,(3),Error,null,(2));
var inst_109856 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_109883__$1 = state_109883;
if(cljs.core.truth_(inst_109856)){
var statearr_109887_109958 = state_109883__$1;
(statearr_109887_109958[(1)] = (5));

} else {
var statearr_109888_109959 = state_109883__$1;
(statearr_109888_109959[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (6))){
var state_109883__$1 = state_109883;
var statearr_109889_109960 = state_109883__$1;
(statearr_109889_109960[(2)] = null);

(statearr_109889_109960[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (3))){
var inst_109852 = (state_109883[(2)]);
var state_109883__$1 = state_109883;
var statearr_109890_109961 = state_109883__$1;
(statearr_109890_109961[(2)] = inst_109852);


cljs.core.async.impl.ioc_helpers.process_exception(state_109883__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (2))){
var inst_109881 = (state_109883[(2)]);
var state_109883__$1 = state_109883;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109883__$1,inst_109881);
} else {
if((state_val_109884 === (11))){
var inst_109876 = (state_109883[(2)]);
var state_109883__$1 = state_109883;
var statearr_109891_109962 = state_109883__$1;
(statearr_109891_109962[(2)] = inst_109876);

(statearr_109891_109962[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (9))){
var inst_109868 = (state_109883[(7)]);
var state_109883__$1 = state_109883;
var statearr_109892_109963 = state_109883__$1;
(statearr_109892_109963[(2)] = inst_109868);

(statearr_109892_109963[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (5))){
var inst_109860 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_109861 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_109862 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_109863 = [inst_109861,inst_109862,opts];
var inst_109864 = cljs.core.PersistentHashMap.fromArrays(inst_109860,inst_109863);
var inst_109865 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_109864) : fluree.db.query.fql.query.call(null,db,inst_109864));
var state_109883__$1 = state_109883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_109883__$1,(8),inst_109865);
} else {
if((state_val_109884 === (10))){
var inst_109871 = [cljs.core.cst$kw$_id];
var inst_109872 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_109873 = [inst_109872];
var inst_109874 = cljs.core.PersistentHashMap.fromArrays(inst_109871,inst_109873);
var state_109883__$1 = state_109883;
var statearr_109893_109964 = state_109883__$1;
(statearr_109893_109964[(2)] = inst_109874);

(statearr_109893_109964[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109884 === (8))){
var inst_109868 = (state_109883[(7)]);
var inst_109867 = (state_109883[(2)]);
var inst_109868__$1 = fluree.db.util.async.throw_err(inst_109867);
var state_109883__$1 = (function (){var statearr_109894 = state_109883;
(statearr_109894[(7)] = inst_109868__$1);

return statearr_109894;
})();
if(cljs.core.truth_(inst_109868__$1)){
var statearr_109895_109965 = state_109883__$1;
(statearr_109895_109965[(1)] = (9));

} else {
var statearr_109896_109966 = state_109883__$1;
(statearr_109896_109966[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__99036__auto__,c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_109897 = [null,null,null,null,null,null,null,null];
(statearr_109897[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__);

(statearr_109897[(1)] = (1));

return statearr_109897;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1 = (function (state_109883){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109883);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109898){if((e109898 instanceof Object)){
var ex__99040__auto__ = e109898;
var statearr_109899_109967 = state_109883;
(statearr_109899_109967[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109883);

return cljs.core.cst$kw$recur;
} else {
throw e109898;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109968 = state_109883;
state_109883 = G__109968;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = function(state_109883){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1.call(this,state_109883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__99061__auto__ = (function (){var statearr_109900 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109900[(6)] = c__99059__auto____$1);

return statearr_109900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__99059__auto____$1;
});
;})(select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
} else {
return ((function (select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var c__99059__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_109909){
var state_val_109910 = (state_109909[(1)]);
if((state_val_109910 === (1))){
var state_109909__$1 = state_109909;
var statearr_109911_109969 = state_109909__$1;
(statearr_109911_109969[(2)] = null);

(statearr_109911_109969[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_109910 === (2))){
var inst_109907 = (state_109909[(2)]);
var state_109909__$1 = state_109909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_109909__$1,inst_109907);
} else {
if((state_val_109910 === (3))){
var inst_109901 = (state_109909[(2)]);
var state_109909__$1 = state_109909;
var statearr_109912_109970 = state_109909__$1;
(statearr_109912_109970[(2)] = inst_109901);


cljs.core.async.impl.ioc_helpers.process_exception(state_109909__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_109910 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_109909,(3),Error,null,(2));
var inst_109905 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_109909__$1 = state_109909;
var statearr_109913_109971 = state_109909__$1;
(statearr_109913_109971[(2)] = inst_109905);


cljs.core.async.impl.ioc_helpers.process_exception(state_109909__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__99036__auto__,c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_109914 = [null,null,null,null,null,null,null];
(statearr_109914[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__);

(statearr_109914[(1)] = (1));

return statearr_109914;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1 = (function (state_109909){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109909);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109915){if((e109915 instanceof Object)){
var ex__99040__auto__ = e109915;
var statearr_109916_109972 = state_109909;
(statearr_109916_109972[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109909);

return cljs.core.cst$kw$recur;
} else {
throw e109915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109973 = state_109909;
state_109909 = G__109973;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = function(state_109909){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1.call(this,state_109909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__99061__auto__ = (function (){var statearr_109917 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109917[(6)] = c__99059__auto____$1);

return statearr_109917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto____$1,select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__99059__auto____$1;
});
;})(select_val,idx,select_fn,pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
}
});
;})(pp,inst_109734,state_val_109808,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_109737 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_109736,select);
var state_109807__$1 = state_109807;
var statearr_109918_109974 = state_109807__$1;
(statearr_109918_109974[(2)] = inst_109737);

(statearr_109918_109974[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0 = (function (){
var statearr_109919 = [null,null,null,null,null,null,null,null,null,null];
(statearr_109919[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__);

(statearr_109919[(1)] = (1));

return statearr_109919;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1 = (function (state_109807){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_109807);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e109920){if((e109920 instanceof Object)){
var ex__99040__auto__ = e109920;
var statearr_109921_109975 = state_109807;
(statearr_109921_109975[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_109807);

return cljs.core.cst$kw$recur;
} else {
throw e109920;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__109976 = state_109807;
state_109807 = G__109976;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__ = function(state_109807){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1.call(this,state_109807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__99061__auto__ = (function (){var statearr_109922 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_109922[(6)] = c__99059__auto__);

return statearr_109922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__109724,map__109724__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__99059__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__109978 = arguments.length;
switch (G__109978) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
});

fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__109979,p__109980,group_limit,opts){
var map__109981 = p__109979;
var map__109981__$1 = (((((!((map__109981 == null))))?(((((map__109981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109981.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109981):map__109981);
var res = map__109981__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109981__$1,cljs.core.cst$kw$vars);
var map__109982 = p__109980;
var map__109982__$1 = (((((!((map__109982 == null))))?(((((map__109982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__109982.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__109982):map__109982);
var select_spec = map__109982__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__109982__$1,cljs.core.cst$kw$groupBy);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function (state_110088){
var state_val_110089 = (state_110088[(1)]);
if((state_val_110089 === (7))){
var inst_109994 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
if(cljs.core.truth_(inst_109994)){
var statearr_110090_110161 = state_110088__$1;
(statearr_110090_110161[(1)] = (8));

} else {
var statearr_110091_110162 = state_110088__$1;
(statearr_110091_110162[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (20))){
var state_110088__$1 = state_110088;
var statearr_110092_110163 = state_110088__$1;
(statearr_110092_110163[(2)] = (0));

(statearr_110092_110163[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (27))){
var state_110088__$1 = state_110088;
var statearr_110093_110164 = state_110088__$1;
(statearr_110093_110164[(2)] = false);

(statearr_110093_110164[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (1))){
var state_110088__$1 = state_110088;
var statearr_110094_110165 = state_110088__$1;
(statearr_110094_110165[(2)] = null);

(statearr_110094_110165[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (24))){
var inst_110023 = (state_110088[(7)]);
var state_110088__$1 = state_110088;
var statearr_110095_110166 = state_110088__$1;
(statearr_110095_110166[(2)] = inst_110023);

(statearr_110095_110166[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (39))){
var inst_110027 = (state_110088[(8)]);
var state_110088__$1 = state_110088;
var statearr_110096_110167 = state_110088__$1;
(statearr_110096_110167[(2)] = inst_110027);

(statearr_110096_110167[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (46))){
var inst_110074 = (state_110088[(9)]);
var state_110088__$1 = state_110088;
var statearr_110097_110168 = state_110088__$1;
(statearr_110097_110168[(2)] = inst_110074);

(statearr_110097_110168[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110088,(3),Error,null,(2));
var state_110088__$1 = state_110088;
if(cljs.core.truth_(aggregates)){
var statearr_110098_110169 = state_110088__$1;
(statearr_110098_110169[(1)] = (5));

} else {
var statearr_110099_110170 = state_110088__$1;
(statearr_110099_110170[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (15))){
var inst_110009 = (state_110088[(10)]);
var state_110088__$1 = state_110088;
var statearr_110100_110171 = state_110088__$1;
(statearr_110100_110171[(2)] = inst_110009);

(statearr_110100_110171[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (21))){
var state_110088__$1 = state_110088;
var statearr_110101_110172 = state_110088__$1;
(statearr_110101_110172[(2)] = offset);

(statearr_110101_110172[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (31))){
var inst_110045 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110102_110173 = state_110088__$1;
(statearr_110102_110173[(2)] = inst_110045);

(statearr_110102_110173[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (32))){
var inst_110032 = (state_110088[(11)]);
var inst_110050 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_110032);
var state_110088__$1 = state_110088;
var statearr_110103_110174 = state_110088__$1;
(statearr_110103_110174[(2)] = inst_110050);

(statearr_110103_110174[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (40))){
var inst_110061 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110104_110175 = state_110088__$1;
(statearr_110104_110175[(2)] = inst_110061);

(statearr_110104_110175[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (33))){
var inst_110032 = (state_110088[(11)]);
var state_110088__$1 = state_110088;
var statearr_110105_110176 = state_110088__$1;
(statearr_110105_110176[(2)] = inst_110032);

(statearr_110105_110176[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (13))){
var inst_110009 = (state_110088[(2)]);
var state_110088__$1 = (function (){var statearr_110106 = state_110088;
(statearr_110106[(10)] = inst_110009);

return statearr_110106;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_110107_110177 = state_110088__$1;
(statearr_110107_110177[(1)] = (14));

} else {
var statearr_110108_110178 = state_110088__$1;
(statearr_110108_110178[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (22))){
var inst_110027 = (state_110088[(2)]);
var state_110088__$1 = (function (){var statearr_110109 = state_110088;
(statearr_110109[(8)] = inst_110027);

return statearr_110109;
})();
if(cljs.core.truth_(orderBy)){
var statearr_110110_110179 = state_110088__$1;
(statearr_110110_110179[(1)] = (23));

} else {
var statearr_110111_110180 = state_110088__$1;
(statearr_110111_110180[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (36))){
var inst_110056 = (state_110088[(12)]);
var state_110088__$1 = state_110088;
var statearr_110112_110181 = state_110088__$1;
(statearr_110112_110181[(2)] = inst_110056);

(statearr_110112_110181[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (41))){
var inst_110055 = (state_110088[(13)]);
var inst_110027 = (state_110088[(8)]);
var inst_110066 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_110027,inst_110055);
var inst_110067 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_110066);
var state_110088__$1 = state_110088;
var statearr_110113_110182 = state_110088__$1;
(statearr_110113_110182[(2)] = inst_110067);

(statearr_110113_110182[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (43))){
var inst_110054 = (state_110088[(14)]);
var inst_110070 = (state_110088[(2)]);
var inst_110071 = fluree.db.query.fql.format_filter_tuples(db,inst_110070,select_spec,inst_110054,vars,opts);
var state_110088__$1 = state_110088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110088__$1,(44),inst_110071);
} else {
if((state_val_110089 === (29))){
var state_110088__$1 = state_110088;
var statearr_110114_110183 = state_110088__$1;
(statearr_110114_110183[(2)] = true);

(statearr_110114_110183[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (44))){
var inst_110073 = (state_110088[(2)]);
var inst_110074 = fluree.db.util.async.throw_err(inst_110073);
var state_110088__$1 = (function (){var statearr_110115 = state_110088;
(statearr_110115[(9)] = inst_110074);

return statearr_110115;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_110116_110184 = state_110088__$1;
(statearr_110116_110184[(1)] = (45));

} else {
var statearr_110117_110185 = state_110088__$1;
(statearr_110117_110185[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (6))){
var state_110088__$1 = state_110088;
var statearr_110118_110186 = state_110088__$1;
(statearr_110118_110186[(2)] = aggregates);

(statearr_110118_110186[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (28))){
var inst_110048 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
if(cljs.core.truth_(inst_110048)){
var statearr_110119_110187 = state_110088__$1;
(statearr_110119_110187[(1)] = (32));

} else {
var statearr_110120_110188 = state_110088__$1;
(statearr_110120_110188[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (25))){
var inst_110032 = (state_110088[(11)]);
var inst_110032__$1 = (state_110088[(2)]);
var inst_110034 = (inst_110032__$1 == null);
var inst_110035 = cljs.core.not(inst_110034);
var state_110088__$1 = (function (){var statearr_110121 = state_110088;
(statearr_110121[(11)] = inst_110032__$1);

return statearr_110121;
})();
if(inst_110035){
var statearr_110122_110189 = state_110088__$1;
(statearr_110122_110189[(1)] = (26));

} else {
var statearr_110123_110190 = state_110088__$1;
(statearr_110123_110190[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (34))){
var inst_110056 = (state_110088[(12)]);
var inst_110053 = (state_110088[(2)]);
var inst_110054 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110053,cljs.core.cst$kw$headers);
var inst_110055 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110053,cljs.core.cst$kw$tuples);
var inst_110056__$1 = cljs.core.not(orderBy);
var state_110088__$1 = (function (){var statearr_110124 = state_110088;
(statearr_110124[(14)] = inst_110054);

(statearr_110124[(13)] = inst_110055);

(statearr_110124[(12)] = inst_110056__$1);

return statearr_110124;
})();
if(inst_110056__$1){
var statearr_110125_110191 = state_110088__$1;
(statearr_110125_110191[(1)] = (35));

} else {
var statearr_110126_110192 = state_110088__$1;
(statearr_110126_110192[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (17))){
var inst_110020 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_110088__$1 = state_110088;
var statearr_110127_110193 = state_110088__$1;
(statearr_110127_110193[(2)] = inst_110020);

(statearr_110127_110193[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (3))){
var inst_109985 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110128_110194 = state_110088__$1;
(statearr_110128_110194[(2)] = inst_109985);


cljs.core.async.impl.ioc_helpers.process_exception(state_110088__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (12))){
var inst_109998 = (state_110088[(15)]);
var state_110088__$1 = state_110088;
var statearr_110129_110195 = state_110088__$1;
(statearr_110129_110195[(2)] = inst_109998);

(statearr_110129_110195[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (2))){
var inst_110086 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110088__$1,inst_110086);
} else {
if((state_val_110089 === (23))){
var inst_110023 = (state_110088[(7)]);
var inst_110027 = (state_110088[(8)]);
var inst_110029 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_110023,inst_110027,group_limit);
var state_110088__$1 = state_110088;
var statearr_110130_110196 = state_110088__$1;
(statearr_110130_110196[(2)] = inst_110029);

(statearr_110130_110196[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (47))){
var inst_110082 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110131_110197 = state_110088__$1;
(statearr_110131_110197[(2)] = inst_110082);

(statearr_110131_110197[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (35))){
var state_110088__$1 = state_110088;
if(cljs.core.truth_(limit)){
var statearr_110132_110198 = state_110088__$1;
(statearr_110132_110198[(1)] = (38));

} else {
var statearr_110133_110199 = state_110088__$1;
(statearr_110133_110199[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (19))){
var inst_110023 = (state_110088[(2)]);
var state_110088__$1 = (function (){var statearr_110134 = state_110088;
(statearr_110134[(7)] = inst_110023);

return statearr_110134;
})();
if(cljs.core.truth_(groupBy)){
var statearr_110135_110200 = state_110088__$1;
(statearr_110135_110200[(1)] = (20));

} else {
var statearr_110136_110201 = state_110088__$1;
(statearr_110136_110201[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (11))){
var inst_109998 = (state_110088[(15)]);
var inst_110000 = cljs.core.first(select);
var inst_110001 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_110000);
var inst_110002 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_110001);
var inst_110003 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_110002,(1));
var inst_110004 = [inst_110003];
var inst_110005 = [inst_109998];
var inst_110006 = cljs.core.PersistentHashMap.fromArrays(inst_110004,inst_110005);
var state_110088__$1 = state_110088;
var statearr_110137_110202 = state_110088__$1;
(statearr_110137_110202[(2)] = inst_110006);

(statearr_110137_110202[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (9))){
var state_110088__$1 = state_110088;
if(cljs.core.truth_(aggregates)){
var statearr_110138_110203 = state_110088__$1;
(statearr_110138_110203[(1)] = (17));

} else {
var statearr_110139_110204 = state_110088__$1;
(statearr_110139_110204[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (5))){
var inst_109990 = cljs.core.count(select);
var inst_109991 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_109990);
var state_110088__$1 = state_110088;
var statearr_110140_110205 = state_110088__$1;
(statearr_110140_110205[(2)] = inst_109991);

(statearr_110140_110205[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (14))){
var inst_110009 = (state_110088[(10)]);
var inst_110011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110012 = [inst_110009];
var inst_110013 = (new cljs.core.PersistentVector(null,1,(5),inst_110011,inst_110012,null));
var state_110088__$1 = state_110088;
var statearr_110141_110206 = state_110088__$1;
(statearr_110141_110206[(2)] = inst_110013);

(statearr_110141_110206[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (45))){
var inst_110074 = (state_110088[(9)]);
var inst_110076 = cljs.core.PersistentVector.EMPTY;
var inst_110077 = cljs.core.PersistentHashSet.EMPTY;
var inst_110078 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_110077,inst_110074);
var inst_110079 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_110076,inst_110078);
var state_110088__$1 = state_110088;
var statearr_110142_110207 = state_110088__$1;
(statearr_110142_110207[(2)] = inst_110079);

(statearr_110142_110207[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (26))){
var inst_110032 = (state_110088[(11)]);
var inst_110037 = inst_110032.cljs$lang$protocol_mask$partition0$;
var inst_110038 = (inst_110037 & (64));
var inst_110039 = inst_110032.cljs$core$ISeq$;
var inst_110040 = (cljs.core.PROTOCOL_SENTINEL === inst_110039);
var inst_110041 = ((inst_110038) || (inst_110040));
var state_110088__$1 = state_110088;
if(cljs.core.truth_(inst_110041)){
var statearr_110143_110208 = state_110088__$1;
(statearr_110143_110208[(1)] = (29));

} else {
var statearr_110144_110209 = state_110088__$1;
(statearr_110144_110209[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (16))){
var inst_110016 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110145_110210 = state_110088__$1;
(statearr_110145_110210[(2)] = inst_110016);

(statearr_110145_110210[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (38))){
var state_110088__$1 = state_110088;
var statearr_110146_110211 = state_110088__$1;
(statearr_110146_110211[(2)] = limit);

(statearr_110146_110211[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (30))){
var state_110088__$1 = state_110088;
var statearr_110147_110212 = state_110088__$1;
(statearr_110147_110212[(2)] = false);

(statearr_110147_110212[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (10))){
var inst_110084 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
var statearr_110148_110213 = state_110088__$1;
(statearr_110148_110213[(2)] = inst_110084);


cljs.core.async.impl.ioc_helpers.process_exception(state_110088__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (18))){
var state_110088__$1 = state_110088;
var statearr_110149_110214 = state_110088__$1;
(statearr_110149_110214[(2)] = res);

(statearr_110149_110214[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (42))){
var inst_110055 = (state_110088[(13)]);
var state_110088__$1 = state_110088;
var statearr_110150_110215 = state_110088__$1;
(statearr_110150_110215[(2)] = inst_110055);

(statearr_110150_110215[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (37))){
var inst_110064 = (state_110088[(2)]);
var state_110088__$1 = state_110088;
if(cljs.core.truth_(inst_110064)){
var statearr_110151_110216 = state_110088__$1;
(statearr_110151_110216[(1)] = (41));

} else {
var statearr_110152_110217 = state_110088__$1;
(statearr_110152_110217[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110089 === (8))){
var inst_109996 = cljs.core.first(aggregates);
var inst_109997 = fluree.db.query.analytical.calculate_aggregate(res,inst_109996);
var inst_109998 = cljs.core.second(inst_109997);
var state_110088__$1 = (function (){var statearr_110153 = state_110088;
(statearr_110153[(15)] = inst_109998);

return statearr_110153;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_110154_110218 = state_110088__$1;
(statearr_110154_110218[(1)] = (11));

} else {
var statearr_110155_110219 = state_110088__$1;
(statearr_110155_110219[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function() {
var fluree$db$query$fql$state_machine__99037__auto__ = null;
var fluree$db$query$fql$state_machine__99037__auto____0 = (function (){
var statearr_110156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110156[(0)] = fluree$db$query$fql$state_machine__99037__auto__);

(statearr_110156[(1)] = (1));

return statearr_110156;
});
var fluree$db$query$fql$state_machine__99037__auto____1 = (function (state_110088){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_110088);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e110157){if((e110157 instanceof Object)){
var ex__99040__auto__ = e110157;
var statearr_110158_110220 = state_110088;
(statearr_110158_110220[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110088);

return cljs.core.cst$kw$recur;
} else {
throw e110157;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__110221 = state_110088;
state_110088 = G__110221;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__99037__auto__ = function(state_110088){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__99037__auto____1.call(this,state_110088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__99037__auto____0;
fluree$db$query$fql$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__99037__auto____1;
return fluree$db$query$fql$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
})();
var state__99061__auto__ = (function (){var statearr_110159 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_110159[(6)] = c__99059__auto__);

return statearr_110159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__109981,map__109981__$1,res,vars,map__109982,map__109982__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
);

return c__99059__auto__;
});

fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5;

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__110224,groupBy){
var map__110225 = p__110224;
var map__110225__$1 = (((((!((map__110225 == null))))?(((((map__110225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110225.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110225):map__110225);
var res = map__110225__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110225__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110225__$1,cljs.core.cst$kw$tuples);
var vec__110227 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110227,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110227,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__110227,inVector_QMARK_,groupBy__$1,map__110225,map__110225__$1,res,headers,tuples){
return (function (p1__110222_SHARP_){
return fluree.db.util.core.index_of(headers,p1__110222_SHARP_);
});})(vec__110227,inVector_QMARK_,groupBy__$1,map__110225,map__110225__$1,res,headers,tuples))
,groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__110227,inVector_QMARK_,groupBy__$1,group_idxs,_,map__110225,map__110225__$1,res,headers,tuples){
return (function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__110227,inVector_QMARK_,groupBy__$1,group_idxs,_,map__110225,map__110225__$1,res,headers,tuples){
return (function (p1__110223_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__110223_SHARP_);
});})(vec__110227,inVector_QMARK_,groupBy__$1,group_idxs,_,map__110225,map__110225__$1,res,headers,tuples))
,group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
});})(vec__110227,inVector_QMARK_,groupBy__$1,group_idxs,_,map__110225,map__110225__$1,res,headers,tuples))
,cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__110230,p__110231,opts){
var map__110232 = p__110230;
var map__110232__$1 = (((((!((map__110232 == null))))?(((((map__110232.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110232.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110232):map__110232);
var res = map__110232__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110232__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110232__$1,cljs.core.cst$kw$vars);
var map__110233 = p__110231;
var map__110233__$1 = (((((!((map__110233 == null))))?(((((map__110233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110233.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110233):map__110233);
var select_spec = map__110233__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110233__$1,cljs.core.cst$kw$offset);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (state_110452){
var state_val_110453 = (state_110452[(1)]);
if((state_val_110453 === (65))){
var inst_110419 = (state_110452[(7)]);
var inst_110418 = (state_110452[(2)]);
var inst_110419__$1 = fluree.db.util.async.throw_err(inst_110418);
var inst_110420 = cljs.core.coll_QMARK_(inst_110419__$1);
var inst_110421 = (!(inst_110420));
var state_110452__$1 = (function (){var statearr_110454 = state_110452;
(statearr_110454[(7)] = inst_110419__$1);

return statearr_110454;
})();
if(inst_110421){
var statearr_110455_110569 = state_110452__$1;
(statearr_110455_110569[(1)] = (66));

} else {
var statearr_110456_110570 = state_110452__$1;
(statearr_110456_110570[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (70))){
var inst_110419 = (state_110452[(7)]);
var state_110452__$1 = state_110452;
var statearr_110457_110571 = state_110452__$1;
(statearr_110457_110571[(2)] = inst_110419);

(statearr_110457_110571[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (62))){
var state_110452__$1 = state_110452;
var statearr_110458_110572 = state_110452__$1;
(statearr_110458_110572[(2)] = (1));

(statearr_110458_110572[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (74))){
var inst_110444 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110459_110573 = state_110452__$1;
(statearr_110459_110573[(2)] = inst_110444);

(statearr_110459_110573[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (7))){
var inst_110448 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110460_110574 = state_110452__$1;
(statearr_110460_110574[(2)] = inst_110448);


cljs.core.async.impl.ioc_helpers.process_exception(state_110452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (59))){
var inst_110288 = (state_110452[(8)]);
var inst_110402 = (state_110452[(9)]);
var inst_110404 = cljs.core.sorted_map_by(inst_110288);
var inst_110405 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_110404,inst_110402);
var state_110452__$1 = state_110452;
var statearr_110461_110575 = state_110452__$1;
(statearr_110461_110575[(2)] = inst_110405);

(statearr_110461_110575[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (20))){
var inst_110261 = cljs.core.set(groupBy);
var inst_110262 = cljs.core.second(orderBy);
var inst_110263 = (inst_110261.cljs$core$IFn$_invoke$arity$1 ? inst_110261.cljs$core$IFn$_invoke$arity$1(inst_110262) : inst_110261.call(null,inst_110262));
var state_110452__$1 = state_110452;
var statearr_110462_110576 = state_110452__$1;
(statearr_110462_110576[(2)] = inst_110263);

(statearr_110462_110576[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (72))){
var inst_110419 = (state_110452[(7)]);
var inst_110432 = cljs.core.first(inst_110419);
var state_110452__$1 = state_110452;
var statearr_110463_110577 = state_110452__$1;
(statearr_110463_110577[(2)] = inst_110432);

(statearr_110463_110577[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (58))){
var inst_110341 = (state_110452[(10)]);
var inst_110332 = (state_110452[(11)]);
var inst_110384 = (state_110452[(2)]);
var inst_110385 = fluree.db.util.async.throw_err(inst_110384);
var inst_110386 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110332,inst_110341,inst_110385);
var state_110452__$1 = state_110452;
var statearr_110464_110578 = state_110452__$1;
(statearr_110464_110578[(2)] = inst_110386);

(statearr_110464_110578[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (60))){
var inst_110402 = (state_110452[(9)]);
var state_110452__$1 = state_110452;
var statearr_110465_110579 = state_110452__$1;
(statearr_110465_110579[(2)] = inst_110402);

(statearr_110465_110579[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (27))){
var inst_110269 = (state_110452[(12)]);
var inst_110270 = (state_110452[(13)]);
var inst_110241 = (state_110452[(14)]);
var inst_110275 = (function (){var group_map = inst_110241;
var orderByIdx = inst_110269;
var orderDirection = inst_110270;
return ((function (group_map,orderByIdx,orderDirection,inst_110269,inst_110270,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
;})(group_map,orderByIdx,orderDirection,inst_110269,inst_110270,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_110452__$1 = state_110452;
var statearr_110466_110580 = state_110452__$1;
(statearr_110466_110580[(2)] = inst_110275);

(statearr_110466_110580[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (1))){
var state_110452__$1 = state_110452;
var statearr_110467_110581 = state_110452__$1;
(statearr_110467_110581[(2)] = null);

(statearr_110467_110581[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (69))){
var inst_110419 = (state_110452[(7)]);
var inst_110424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110425 = [inst_110419];
var inst_110426 = (new cljs.core.PersistentVector(null,1,(5),inst_110424,inst_110425,null));
var state_110452__$1 = state_110452;
var statearr_110468_110582 = state_110452__$1;
(statearr_110468_110582[(2)] = inst_110426);

(statearr_110468_110582[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (24))){
var state_110452__$1 = state_110452;
var statearr_110469_110583 = state_110452__$1;
(statearr_110469_110583[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (55))){
var inst_110356 = (state_110452[(15)]);
var inst_110359 = (state_110452[(16)]);
var inst_110344 = (state_110452[(17)]);
var inst_110379 = cljs.core.count(inst_110344);
var inst_110380 = (inst_110356 - limit);
var inst_110381 = (inst_110379 - inst_110380);
var inst_110382 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_110359,select_spec,inst_110381,opts);
var state_110452__$1 = state_110452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110452__$1,(58),inst_110382);
} else {
if((state_val_110453 === (39))){
var inst_110331 = (state_110452[(18)]);
var inst_110349 = (inst_110331 > (0));
var state_110452__$1 = state_110452;
if(cljs.core.truth_(inst_110349)){
var statearr_110471_110584 = state_110452__$1;
(statearr_110471_110584[(1)] = (41));

} else {
var statearr_110472_110585 = state_110452__$1;
(statearr_110472_110585[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (46))){
var inst_110396 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110473_110586 = state_110452__$1;
(statearr_110473_110586[(2)] = inst_110396);

(statearr_110473_110586[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110452,(3),Error,null,(2));
var state_110452__$1 = state_110452;
if(cljs.core.truth_(groupBy)){
var statearr_110474_110587 = state_110452__$1;
(statearr_110474_110587[(1)] = (5));

} else {
var statearr_110475_110588 = state_110452__$1;
(statearr_110475_110588[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (77))){
var inst_110442 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110476_110589 = state_110452__$1;
(statearr_110476_110589[(2)] = inst_110442);

(statearr_110476_110589[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (54))){
var inst_110341 = (state_110452[(10)]);
var inst_110332 = (state_110452[(11)]);
var inst_110373 = (state_110452[(2)]);
var inst_110374 = fluree.db.util.async.throw_err(inst_110373);
var inst_110375 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110332,inst_110341,inst_110374);
var state_110452__$1 = state_110452;
var statearr_110477_110590 = state_110452__$1;
(statearr_110477_110590[(2)] = inst_110375);

(statearr_110477_110590[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (15))){
var state_110452__$1 = state_110452;
var statearr_110479_110591 = state_110452__$1;
(statearr_110479_110591[(2)] = fluree.db.query.fql.compare_fn);

(statearr_110479_110591[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (48))){
var inst_110356 = (state_110452[(15)]);
var inst_110369 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_110356);
var state_110452__$1 = state_110452;
if(inst_110369){
var statearr_110480_110592 = state_110452__$1;
(statearr_110480_110592[(1)] = (51));

} else {
var statearr_110481_110593 = state_110452__$1;
(statearr_110481_110593[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (50))){
var inst_110345 = (state_110452[(19)]);
var inst_110341 = (state_110452[(10)]);
var inst_110331 = (state_110452[(18)]);
var inst_110342 = (state_110452[(20)]);
var inst_110356 = (state_110452[(15)]);
var inst_110332 = (state_110452[(11)]);
var inst_110364 = (state_110452[(2)]);
var inst_110365 = fluree.db.util.async.throw_err(inst_110364);
var inst_110366 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110332,inst_110341,inst_110365);
var tmp110478 = inst_110331;
var inst_110328 = inst_110342;
var inst_110329 = inst_110345;
var inst_110330 = inst_110356;
var inst_110331__$1 = tmp110478;
var inst_110332__$1 = inst_110366;
var state_110452__$1 = (function (){var statearr_110482 = state_110452;
(statearr_110482[(18)] = inst_110331__$1);

(statearr_110482[(21)] = inst_110330);

(statearr_110482[(11)] = inst_110332__$1);

(statearr_110482[(22)] = inst_110328);

(statearr_110482[(23)] = inst_110329);

return statearr_110482;
})();
var statearr_110483_110594 = state_110452__$1;
(statearr_110483_110594[(2)] = null);

(statearr_110483_110594[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (75))){
var inst_110419 = (state_110452[(7)]);
var inst_110435 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_110419);
var state_110452__$1 = state_110452;
var statearr_110484_110595 = state_110452__$1;
(statearr_110484_110595[(2)] = inst_110435);

(statearr_110484_110595[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (21))){
var state_110452__$1 = state_110452;
var statearr_110485_110596 = state_110452__$1;
(statearr_110485_110596[(2)] = orderBy);

(statearr_110485_110596[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (31))){
var inst_110282 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110486_110597 = state_110452__$1;
(statearr_110486_110597[(2)] = inst_110282);

(statearr_110486_110597[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (32))){
var inst_110241 = (state_110452[(14)]);
var inst_110290 = cljs.core.keys(inst_110241);
var inst_110291 = cljs.core.first(inst_110290);
var inst_110292 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_110293 = cljs.core.vals(inst_110241);
var inst_110294 = cljs.core.first(inst_110293);
var inst_110295 = [headers,vars,inst_110294];
var inst_110296 = cljs.core.PersistentHashMap.fromArrays(inst_110292,inst_110295);
var inst_110297 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_110296,select_spec,limit,opts);
var state_110452__$1 = (function (){var statearr_110487 = state_110452;
(statearr_110487[(24)] = inst_110291);

return statearr_110487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110452__$1,(35),inst_110297);
} else {
if((state_val_110453 === (40))){
var inst_110400 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110488_110598 = state_110452__$1;
(statearr_110488_110598[(2)] = inst_110400);

(statearr_110488_110598[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (56))){
var state_110452__$1 = state_110452;
var statearr_110489_110599 = state_110452__$1;
(statearr_110489_110599[(2)] = null);

(statearr_110489_110599[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (33))){
var inst_110241 = (state_110452[(14)]);
var inst_110319 = cljs.core.keys(inst_110241);
var inst_110320 = cljs.core.seq(inst_110319);
var inst_110321 = cljs.core.first(inst_110320);
var inst_110322 = cljs.core.next(inst_110320);
var inst_110323 = cljs.core.vals(inst_110241);
var inst_110324 = cljs.core.seq(inst_110323);
var inst_110325 = cljs.core.first(inst_110324);
var inst_110326 = cljs.core.next(inst_110324);
var inst_110327 = cljs.core.PersistentHashMap.EMPTY;
var inst_110328 = inst_110319;
var inst_110329 = inst_110323;
var inst_110330 = (0);
var inst_110331 = offset;
var inst_110332 = inst_110327;
var state_110452__$1 = (function (){var statearr_110490 = state_110452;
(statearr_110490[(25)] = inst_110322);

(statearr_110490[(26)] = inst_110326);

(statearr_110490[(18)] = inst_110331);

(statearr_110490[(21)] = inst_110330);

(statearr_110490[(11)] = inst_110332);

(statearr_110490[(22)] = inst_110328);

(statearr_110490[(27)] = inst_110325);

(statearr_110490[(23)] = inst_110329);

(statearr_110490[(28)] = inst_110321);

return statearr_110490;
})();
var statearr_110491_110600 = state_110452__$1;
(statearr_110491_110600[(2)] = null);

(statearr_110491_110600[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (13))){
var inst_110288 = (state_110452[(2)]);
var state_110452__$1 = (function (){var statearr_110492 = state_110452;
(statearr_110492[(8)] = inst_110288);

return statearr_110492;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_110493_110601 = state_110452__$1;
(statearr_110493_110601[(1)] = (32));

} else {
var statearr_110494_110602 = state_110452__$1;
(statearr_110494_110602[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (22))){
var inst_110266 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
if(cljs.core.truth_(inst_110266)){
var statearr_110497_110603 = state_110452__$1;
(statearr_110497_110603[(1)] = (23));

} else {
var statearr_110498_110604 = state_110452__$1;
(statearr_110498_110604[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (36))){
var inst_110328 = (state_110452[(22)]);
var inst_110329 = (state_110452[(23)]);
var inst_110344 = (state_110452[(17)]);
var inst_110340 = cljs.core.seq(inst_110328);
var inst_110341 = cljs.core.first(inst_110340);
var inst_110342 = cljs.core.next(inst_110340);
var inst_110343 = cljs.core.seq(inst_110329);
var inst_110344__$1 = cljs.core.first(inst_110343);
var inst_110345 = cljs.core.next(inst_110343);
var inst_110346 = (inst_110344__$1 == null);
var state_110452__$1 = (function (){var statearr_110499 = state_110452;
(statearr_110499[(19)] = inst_110345);

(statearr_110499[(10)] = inst_110341);

(statearr_110499[(20)] = inst_110342);

(statearr_110499[(17)] = inst_110344__$1);

return statearr_110499;
})();
if(cljs.core.truth_(inst_110346)){
var statearr_110500_110605 = state_110452__$1;
(statearr_110500_110605[(1)] = (38));

} else {
var statearr_110501_110606 = state_110452__$1;
(statearr_110501_110606[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (41))){
var inst_110345 = (state_110452[(19)]);
var inst_110331 = (state_110452[(18)]);
var inst_110342 = (state_110452[(20)]);
var inst_110330 = (state_110452[(21)]);
var inst_110332 = (state_110452[(11)]);
var inst_110351 = (inst_110331 - (1));
var tmp110495 = inst_110330;
var tmp110496 = inst_110332;
var inst_110328 = inst_110342;
var inst_110329 = inst_110345;
var inst_110330__$1 = tmp110495;
var inst_110331__$1 = inst_110351;
var inst_110332__$1 = tmp110496;
var state_110452__$1 = (function (){var statearr_110502 = state_110452;
(statearr_110502[(18)] = inst_110331__$1);

(statearr_110502[(21)] = inst_110330__$1);

(statearr_110502[(11)] = inst_110332__$1);

(statearr_110502[(22)] = inst_110328);

(statearr_110502[(23)] = inst_110329);

return statearr_110502;
})();
var statearr_110503_110607 = state_110452__$1;
(statearr_110503_110607[(2)] = null);

(statearr_110503_110607[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (43))){
var inst_110398 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110504_110608 = state_110452__$1;
(statearr_110504_110608[(2)] = inst_110398);

(statearr_110504_110608[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (61))){
var inst_110408 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110505_110609 = state_110452__$1;
(statearr_110505_110609[(2)] = inst_110408);

(statearr_110505_110609[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (29))){
var state_110452__$1 = state_110452;
var statearr_110506_110610 = state_110452__$1;
(statearr_110506_110610[(2)] = null);

(statearr_110506_110610[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (44))){
var inst_110356 = (state_110452[(15)]);
var inst_110330 = (state_110452[(21)]);
var inst_110344 = (state_110452[(17)]);
var inst_110355 = cljs.core.count(inst_110344);
var inst_110356__$1 = (inst_110330 + inst_110355);
var inst_110357 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_110358 = [headers,vars,inst_110344];
var inst_110359 = cljs.core.PersistentHashMap.fromArrays(inst_110357,inst_110358);
var inst_110360 = (limit > inst_110356__$1);
var state_110452__$1 = (function (){var statearr_110507 = state_110452;
(statearr_110507[(15)] = inst_110356__$1);

(statearr_110507[(16)] = inst_110359);

return statearr_110507;
})();
if(cljs.core.truth_(inst_110360)){
var statearr_110508_110611 = state_110452__$1;
(statearr_110508_110611[(1)] = (47));

} else {
var statearr_110509_110612 = state_110452__$1;
(statearr_110509_110612[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (6))){
var state_110452__$1 = state_110452;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_110510_110613 = state_110452__$1;
(statearr_110510_110613[(1)] = (62));

} else {
var statearr_110511_110614 = state_110452__$1;
(statearr_110511_110614[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (28))){
var inst_110277 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110512_110615 = state_110452__$1;
(statearr_110512_110615[(2)] = inst_110277);

(statearr_110512_110615[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (64))){
var inst_110415 = (state_110452[(2)]);
var inst_110416 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_110415,opts);
var state_110452__$1 = state_110452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110452__$1,(65),inst_110416);
} else {
if((state_val_110453 === (51))){
var inst_110359 = (state_110452[(16)]);
var inst_110371 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_110359,select_spec,opts);
var state_110452__$1 = state_110452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110452__$1,(54),inst_110371);
} else {
if((state_val_110453 === (25))){
var inst_110284 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110513_110616 = state_110452__$1;
(statearr_110513_110616[(2)] = inst_110284);

(statearr_110513_110616[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (34))){
var inst_110410 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110514_110617 = state_110452__$1;
(statearr_110514_110617[(2)] = inst_110410);

(statearr_110514_110617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (17))){
var state_110452__$1 = state_110452;
var statearr_110515_110618 = state_110452__$1;
(statearr_110515_110618[(2)] = null);

(statearr_110515_110618[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (3))){
var inst_110236 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110516_110619 = state_110452__$1;
(statearr_110516_110619[(2)] = inst_110236);


cljs.core.async.impl.ioc_helpers.process_exception(state_110452__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (12))){
var inst_110257 = cljs.core.not(orderBy);
var state_110452__$1 = state_110452;
if(inst_110257){
var statearr_110517_110620 = state_110452__$1;
(statearr_110517_110620[(1)] = (17));

} else {
var statearr_110518_110621 = state_110452__$1;
(statearr_110518_110621[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (2))){
var inst_110450 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110452__$1,inst_110450);
} else {
if((state_val_110453 === (66))){
var state_110452__$1 = state_110452;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_110519_110622 = state_110452__$1;
(statearr_110519_110622[(1)] = (69));

} else {
var statearr_110520_110623 = state_110452__$1;
(statearr_110520_110623[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (23))){
var inst_110270 = (state_110452[(13)]);
var inst_110268 = cljs.core.second(orderBy);
var inst_110269 = fluree.db.util.core.index_of(groupBy,inst_110268);
var inst_110270__$1 = cljs.core.first(orderBy);
var inst_110271 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_110270__$1);
var state_110452__$1 = (function (){var statearr_110521 = state_110452;
(statearr_110521[(12)] = inst_110269);

(statearr_110521[(13)] = inst_110270__$1);

return statearr_110521;
})();
if(inst_110271){
var statearr_110522_110624 = state_110452__$1;
(statearr_110522_110624[(1)] = (26));

} else {
var statearr_110523_110625 = state_110452__$1;
(statearr_110523_110625[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (47))){
var inst_110359 = (state_110452[(16)]);
var inst_110362 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_110359,select_spec,opts);
var state_110452__$1 = state_110452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110452__$1,(50),inst_110362);
} else {
if((state_val_110453 === (35))){
var inst_110291 = (state_110452[(24)]);
var inst_110299 = (state_110452[(2)]);
var inst_110300 = fluree.db.util.async.throw_err(inst_110299);
var inst_110301 = [inst_110291];
var inst_110302 = [inst_110300];
var inst_110303 = cljs.core.PersistentHashMap.fromArrays(inst_110301,inst_110302);
var state_110452__$1 = state_110452;
var statearr_110524_110626 = state_110452__$1;
(statearr_110524_110626[(2)] = inst_110303);

(statearr_110524_110626[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (76))){
var state_110452__$1 = state_110452;
var statearr_110525_110627 = state_110452__$1;
(statearr_110525_110627[(1)] = (78));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (19))){
var inst_110286 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110527_110628 = state_110452__$1;
(statearr_110527_110628[(2)] = inst_110286);

(statearr_110527_110628[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (57))){
var inst_110389 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110528_110629 = state_110452__$1;
(statearr_110528_110629[(2)] = inst_110389);

(statearr_110528_110629[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (68))){
var inst_110446 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110529_110630 = state_110452__$1;
(statearr_110529_110630[(2)] = inst_110446);

(statearr_110529_110630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (11))){
var inst_110249 = cljs.core.first(orderBy);
var inst_110250 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_110249,"DESC");
var state_110452__$1 = state_110452;
if(inst_110250){
var statearr_110530_110631 = state_110452__$1;
(statearr_110530_110631[(1)] = (14));

} else {
var statearr_110531_110632 = state_110452__$1;
(statearr_110531_110632[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (9))){
var state_110452__$1 = state_110452;
var statearr_110532_110633 = state_110452__$1;
(statearr_110532_110633[(2)] = orderBy);

(statearr_110532_110633[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (5))){
var inst_110241 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_110452__$1 = (function (){var statearr_110533 = state_110452;
(statearr_110533[(14)] = inst_110241);

return statearr_110533;
})();
if(cljs.core.truth_(orderBy)){
var statearr_110534_110634 = state_110452__$1;
(statearr_110534_110634[(1)] = (8));

} else {
var statearr_110535_110635 = state_110452__$1;
(statearr_110535_110635[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (14))){
var inst_110241 = (state_110452[(14)]);
var inst_110252 = (function (){var group_map = inst_110241;
return ((function (group_map,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
;})(group_map,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_110452__$1 = state_110452;
var statearr_110536_110636 = state_110452__$1;
(statearr_110536_110636[(2)] = inst_110252);

(statearr_110536_110636[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (45))){
var state_110452__$1 = state_110452;
var statearr_110537_110637 = state_110452__$1;
(statearr_110537_110637[(2)] = null);

(statearr_110537_110637[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (53))){
var inst_110391 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110538_110638 = state_110452__$1;
(statearr_110538_110638[(2)] = inst_110391);

(statearr_110538_110638[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (78))){
var inst_110419 = (state_110452[(7)]);
var state_110452__$1 = state_110452;
var statearr_110539_110639 = state_110452__$1;
(statearr_110539_110639[(2)] = inst_110419);

(statearr_110539_110639[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (26))){
var inst_110269 = (state_110452[(12)]);
var inst_110270 = (state_110452[(13)]);
var inst_110241 = (state_110452[(14)]);
var inst_110273 = (function (){var group_map = inst_110241;
var orderByIdx = inst_110269;
var orderDirection = inst_110270;
return ((function (group_map,orderByIdx,orderDirection,inst_110269,inst_110270,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
;})(group_map,orderByIdx,orderDirection,inst_110269,inst_110270,inst_110241,state_val_110453,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_110452__$1 = state_110452;
var statearr_110540_110640 = state_110452__$1;
(statearr_110540_110640[(2)] = inst_110273);

(statearr_110540_110640[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (16))){
var inst_110255 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110541_110641 = state_110452__$1;
(statearr_110541_110641[(2)] = inst_110255);

(statearr_110541_110641[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (79))){
var state_110452__$1 = state_110452;
var statearr_110542_110642 = state_110452__$1;
(statearr_110542_110642[(2)] = null);

(statearr_110542_110642[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (38))){
var inst_110332 = (state_110452[(11)]);
var state_110452__$1 = state_110452;
var statearr_110543_110643 = state_110452__$1;
(statearr_110543_110643[(2)] = inst_110332);

(statearr_110543_110643[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (30))){
var state_110452__$1 = state_110452;
var statearr_110544_110644 = state_110452__$1;
(statearr_110544_110644[(2)] = null);

(statearr_110544_110644[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (73))){
var state_110452__$1 = state_110452;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_110545_110645 = state_110452__$1;
(statearr_110545_110645[(1)] = (75));

} else {
var statearr_110546_110646 = state_110452__$1;
(statearr_110546_110646[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (10))){
var inst_110247 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
if(cljs.core.truth_(inst_110247)){
var statearr_110547_110647 = state_110452__$1;
(statearr_110547_110647[(1)] = (11));

} else {
var statearr_110548_110648 = state_110452__$1;
(statearr_110548_110648[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (18))){
var state_110452__$1 = state_110452;
if(cljs.core.truth_(orderBy)){
var statearr_110549_110649 = state_110452__$1;
(statearr_110549_110649[(1)] = (20));

} else {
var statearr_110550_110650 = state_110452__$1;
(statearr_110550_110650[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (52))){
var inst_110356 = (state_110452[(15)]);
var inst_110377 = (limit < inst_110356);
var state_110452__$1 = state_110452;
if(cljs.core.truth_(inst_110377)){
var statearr_110551_110651 = state_110452__$1;
(statearr_110551_110651[(1)] = (55));

} else {
var statearr_110552_110652 = state_110452__$1;
(statearr_110552_110652[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (67))){
var state_110452__$1 = state_110452;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_110553_110653 = state_110452__$1;
(statearr_110553_110653[(1)] = (72));

} else {
var statearr_110554_110654 = state_110452__$1;
(statearr_110554_110654[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (71))){
var inst_110429 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110555_110655 = state_110452__$1;
(statearr_110555_110655[(2)] = inst_110429);

(statearr_110555_110655[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (42))){
var state_110452__$1 = state_110452;
var statearr_110556_110656 = state_110452__$1;
(statearr_110556_110656[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (80))){
var inst_110440 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110558_110657 = state_110452__$1;
(statearr_110558_110657[(2)] = inst_110440);

(statearr_110558_110657[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (37))){
var inst_110288 = (state_110452[(8)]);
var inst_110402 = (state_110452[(2)]);
var state_110452__$1 = (function (){var statearr_110559 = state_110452;
(statearr_110559[(9)] = inst_110402);

return statearr_110559;
})();
if(cljs.core.truth_(inst_110288)){
var statearr_110560_110658 = state_110452__$1;
(statearr_110560_110658[(1)] = (59));

} else {
var statearr_110561_110659 = state_110452__$1;
(statearr_110561_110659[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (63))){
var state_110452__$1 = state_110452;
var statearr_110562_110660 = state_110452__$1;
(statearr_110562_110660[(2)] = limit);

(statearr_110562_110660[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (8))){
var inst_110243 = cljs.core.second(orderBy);
var inst_110244 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_110243,groupBy);
var state_110452__$1 = state_110452;
var statearr_110563_110661 = state_110452__$1;
(statearr_110563_110661[(2)] = inst_110244);

(statearr_110563_110661[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110453 === (49))){
var inst_110393 = (state_110452[(2)]);
var state_110452__$1 = state_110452;
var statearr_110564_110662 = state_110452__$1;
(statearr_110564_110662[(2)] = inst_110393);

(statearr_110564_110662[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____0 = (function (){
var statearr_110565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_110565[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__);

(statearr_110565[(1)] = (1));

return statearr_110565;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____1 = (function (state_110452){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_110452);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e110566){if((e110566 instanceof Object)){
var ex__99040__auto__ = e110566;
var statearr_110567_110663 = state_110452;
(statearr_110567_110663[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110452);

return cljs.core.cst$kw$recur;
} else {
throw e110566;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__110664 = state_110452;
state_110452 = G__110664;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__ = function(state_110452){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____1.call(this,state_110452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state__99061__auto__ = (function (){var statearr_110568 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_110568[(6)] = c__99059__auto__);

return statearr_110568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__110232,map__110232__$1,res,headers,vars,map__110233,map__110233__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
);

return c__99059__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__110667,opts){
var map__110668 = p__110667;
var map__110668__$1 = (((((!((map__110668 == null))))?(((((map__110668.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110668.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110668):map__110668);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110668__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110668__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110668__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110668__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4131__auto__ = selectOne;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = select;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (select_smt,inVector_QMARK_,select_smt__$1,parsed_select,map__110668,map__110668__$1,selectOne,select,selectDistinct,selectReduced){
return (function (p1__110665_SHARP_){
return cljs.core.contains_QMARK_(p1__110665_SHARP_,cljs.core.cst$kw$code);
});})(select_smt,inVector_QMARK_,select_smt__$1,parsed_select,map__110668,map__110668__$1,selectOne,select,selectDistinct,selectReduced))
,parsed_select);
var expandMap_QMARK_ = cljs.core.some(((function (select_smt,inVector_QMARK_,select_smt__$1,parsed_select,aggregates,map__110668,map__110668__$1,selectOne,select,selectDistinct,selectReduced){
return (function (p1__110666_SHARP_){
return cljs.core.contains_QMARK_(p1__110666_SHARP_,cljs.core.cst$kw$selection);
});})(select_smt,inVector_QMARK_,select_smt__$1,parsed_select,aggregates,map__110668,map__110668__$1,selectOne,select,selectDistinct,selectReduced))
,parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4131__auto__ = typeof orderBy === 'string';
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4120__auto__){
var G__110677 = cljs.core.first(orderBy);
var fexpr__110676 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__110676.cljs$core$IFn$_invoke$arity$1 ? fexpr__110676.cljs$core$IFn$_invoke$arity$1(G__110677) : fexpr__110676.call(null,G__110677));
} else {
return and__4120__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4131__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (100);
}
})(),(function (){var or__4131__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4131__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4131__auto__ = selectDistinct;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__110678,p__110679){
var map__110680 = p__110678;
var map__110680__$1 = (((((!((map__110680 == null))))?(((((map__110680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110680):map__110680);
var query_map = map__110680__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110680__$1,cljs.core.cst$kw$construct);
var map__110681 = p__110679;
var map__110681__$1 = (((((!((map__110681 == null))))?(((((map__110681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110681.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110681):map__110681);
var where_result = map__110681__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110681__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110681__$1,cljs.core.cst$kw$tuples);
var vec__110684 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples){
return (function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return ((function (index_of,temp__5733__auto__,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples){
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
;})(index_of,temp__5733__auto__,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples))
} else {
return ((function (temp__5733__auto__,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples){
return (function (row){
return construct_item;
});
;})(temp__5733__auto__,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples))
}
});})(map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples))
,construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110684,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110684,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__110684,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__110684,fn1,fn2,fn3,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples){
return (function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
});})(vec__110684,fn1,fn2,fn3,map__110680,map__110680__$1,query_map,construct,map__110681,map__110681__$1,where_result,headers,tuples))
,tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_110714){
var state_val_110715 = (state_110714[(1)]);
if((state_val_110715 === (7))){
var state_110714__$1 = state_110714;
var statearr_110716_110732 = state_110714__$1;
(statearr_110716_110732[(1)] = (9));



return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (1))){
var state_110714__$1 = state_110714;
var statearr_110718_110733 = state_110714__$1;
(statearr_110718_110733[(2)] = null);

(statearr_110718_110733[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_110714,(3),Error,null,(2));
var inst_110691 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_110714__$1 = state_110714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110714__$1,(5),inst_110691);
} else {
if((state_val_110715 === (6))){
var inst_110694 = (state_110714[(7)]);
var state_110714__$1 = state_110714;
var statearr_110719_110734 = state_110714__$1;
(statearr_110719_110734[(2)] = inst_110694);

(statearr_110719_110734[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (3))){
var inst_110687 = (state_110714[(2)]);
var state_110714__$1 = state_110714;
var statearr_110720_110735 = state_110714__$1;
(statearr_110720_110735[(2)] = inst_110687);


cljs.core.async.impl.ioc_helpers.process_exception(state_110714__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (12))){
var inst_110704 = (state_110714[(2)]);
var inst_110705 = fluree.db.util.async.throw_err(inst_110704);
var state_110714__$1 = state_110714;
var statearr_110721_110736 = state_110714__$1;
(statearr_110721_110736[(2)] = inst_110705);

(statearr_110721_110736[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (2))){
var inst_110712 = (state_110714[(2)]);
var state_110714__$1 = state_110714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_110714__$1,inst_110712);
} else {
if((state_val_110715 === (11))){
var inst_110708 = (state_110714[(2)]);
var state_110714__$1 = state_110714;
var statearr_110722_110737 = state_110714__$1;
(statearr_110722_110737[(2)] = inst_110708);

(statearr_110722_110737[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (9))){
var inst_110694 = (state_110714[(7)]);
var inst_110699 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_110694);
var inst_110700 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_110694);
var inst_110701 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_110699,inst_110700,query_map,opts);
var inst_110702 = fluree.db.query.fql.process_ad_hoc_res(db,inst_110694,inst_110701,opts);
var state_110714__$1 = state_110714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_110714__$1,(12),inst_110702);
} else {
if((state_val_110715 === (5))){
var inst_110694 = (state_110714[(7)]);
var inst_110693 = (state_110714[(2)]);
var inst_110694__$1 = fluree.db.util.async.throw_err(inst_110693);
var inst_110695 = fluree.db.util.core.exception_QMARK_(inst_110694__$1);
var state_110714__$1 = (function (){var statearr_110723 = state_110714;
(statearr_110723[(7)] = inst_110694__$1);

return statearr_110723;
})();
if(inst_110695){
var statearr_110724_110738 = state_110714__$1;
(statearr_110724_110738[(1)] = (6));

} else {
var statearr_110725_110739 = state_110714__$1;
(statearr_110725_110739[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (10))){
var state_110714__$1 = state_110714;
var statearr_110726_110740 = state_110714__$1;
(statearr_110726_110740[(2)] = null);

(statearr_110726_110740[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_110715 === (8))){
var inst_110710 = (state_110714[(2)]);
var state_110714__$1 = state_110714;
var statearr_110727_110741 = state_110714__$1;
(statearr_110727_110741[(2)] = inst_110710);


cljs.core.async.impl.ioc_helpers.process_exception(state_110714__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____0 = (function (){
var statearr_110728 = [null,null,null,null,null,null,null,null];
(statearr_110728[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__);

(statearr_110728[(1)] = (1));

return statearr_110728;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____1 = (function (state_110714){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_110714);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e110729){if((e110729 instanceof Object)){
var ex__99040__auto__ = e110729;
var statearr_110730_110742 = state_110714;
(statearr_110730_110742[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_110714);

return cljs.core.cst$kw$recur;
} else {
throw e110729;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__110743 = state_110714;
state_110714 = G__110743;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__ = function(state_110714){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____1.call(this,state_110714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_110731 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_110731[(6)] = c__99059__auto__);

return statearr_110731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__110744 = query_map;
var map__110744__$1 = (((((!((map__110744 == null))))?(((((map__110744.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110744.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__110744):map__110744);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__110744__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4131__auto__ = offset;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,cljs.core.cst$kw$limit,(1)):opts_SINGLEQUOTE_);
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE__SINGLEQUOTE_);
var fuel = (function (){var or__4131__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.truth_((function (){var or__4131__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
} else {
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function (state_111098){
var state_val_111099 = (state_111098[(1)]);
if((state_val_111099 === (121))){
var inst_111081 = (state_111098[(7)]);
var inst_111083 = cljs.core.coll_QMARK_(inst_111081);
var inst_111084 = fluree.db.util.core.exception_QMARK_(inst_111081);
var inst_111085 = (!(inst_111084));
var inst_111086 = ((inst_111083) && (inst_111085));
var state_111098__$1 = state_111098;
var statearr_111100_111273 = state_111098__$1;
(statearr_111100_111273[(2)] = inst_111086);

(statearr_111100_111273[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (65))){
var inst_110926 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110926)){
var statearr_111101_111274 = state_111098__$1;
(statearr_111101_111274[(1)] = (66));

} else {
var statearr_111102_111275 = state_111098__$1;
(statearr_111102_111275[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (70))){
var inst_110812 = (state_111098[(8)]);
var inst_110810 = (state_111098[(9)]);
var inst_110931 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_110932 = [inst_110810,inst_110812];
var inst_110933 = cljs.core.PersistentHashMap.fromArrays(inst_110931,inst_110932);
var state_111098__$1 = state_111098;
var statearr_111103_111276 = state_111098__$1;
(statearr_111103_111276[(2)] = inst_110933);

(statearr_111103_111276[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (62))){
var inst_110914 = (state_111098[(2)]);
var inst_110915 = fluree.db.util.async.throw_err(inst_110914);
var state_111098__$1 = state_111098;
var statearr_111104_111277 = state_111098__$1;
(statearr_111104_111277[(2)] = inst_110915);

(statearr_111104_111277[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (74))){
var inst_110809 = (state_111098[(10)]);
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110809)){
var statearr_111105_111278 = state_111098__$1;
(statearr_111105_111278[(1)] = (77));

} else {
var statearr_111106_111279 = state_111098__$1;
(statearr_111106_111279[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (110))){
var inst_111014 = (state_111098[(11)]);
var inst_111038 = (state_111098[(2)]);
var inst_111006 = inst_111014;
var inst_111007 = inst_111038;
var state_111098__$1 = (function (){var statearr_111107 = state_111098;
(statearr_111107[(12)] = inst_111007);

(statearr_111107[(13)] = inst_111006);

return statearr_111107;
})();
var statearr_111108_111280 = state_111098__$1;
(statearr_111108_111280[(2)] = null);

(statearr_111108_111280[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (7))){
var inst_110787 = (state_111098[(2)]);
var inst_110789 = (opts_SINGLEQUOTE__SINGLEQUOTE_ == null);
var inst_110790 = cljs.core.not(inst_110789);
var state_111098__$1 = (function (){var statearr_111109 = state_111098;
(statearr_111109[(14)] = inst_110787);

return statearr_111109;
})();
if(inst_110790){
var statearr_111110_111281 = state_111098__$1;
(statearr_111110_111281[(1)] = (14));

} else {
var statearr_111111_111282 = state_111098__$1;
(statearr_111111_111282[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (59))){
var inst_110812 = (state_111098[(8)]);
var inst_110810 = (state_111098[(9)]);
var inst_110899 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_110900 = [inst_110810,inst_110812];
var inst_110901 = cljs.core.PersistentHashMap.fromArrays(inst_110899,inst_110900);
var state_111098__$1 = state_111098;
var statearr_111112_111283 = state_111098__$1;
(statearr_111112_111283[(2)] = inst_110901);

(statearr_111112_111283[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (86))){
var state_111098__$1 = state_111098;
var statearr_111113_111284 = state_111098__$1;
(statearr_111113_111284[(2)] = null);

(statearr_111113_111284[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (20))){
var inst_110805 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
var state_111098__$1 = state_111098;
var statearr_111114_111285 = state_111098__$1;
(statearr_111114_111285[(2)] = inst_110805);

(statearr_111114_111285[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (72))){
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_110938 = (state_111098[(2)]);
var inst_110939 = fluree.db.util.async.throw_err(inst_110938);
var inst_110940 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_110822,fuel,max_fuel,inst_110820,inst_110939);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(73),inst_110940);
} else {
if((state_val_111099 === (58))){
var inst_110897 = cljs.core.PersistentHashMap.EMPTY;
var state_111098__$1 = state_111098;
var statearr_111115_111286 = state_111098__$1;
(statearr_111115_111286[(2)] = inst_110897);

(statearr_111115_111286[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (60))){
var inst_110903 = (state_111098[(2)]);
var inst_110904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110905 = [from];
var inst_110906 = (new cljs.core.PersistentVector(null,1,(5),inst_110904,inst_110905,null));
var inst_110907 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_110906,inst_110903);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(61),inst_110907);
} else {
if((state_val_111099 === (27))){
var inst_110850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110851 = [null,null];
var inst_110852 = (new cljs.core.PersistentVector(null,2,(5),inst_110850,inst_110851,null));
var state_111098__$1 = state_111098;
var statearr_111116_111287 = state_111098__$1;
(statearr_111116_111287[(2)] = inst_110852);

(statearr_111116_111287[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (1))){
var state_111098__$1 = state_111098;
var statearr_111117_111288 = state_111098__$1;
(statearr_111117_111288[(2)] = null);

(statearr_111117_111288[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (69))){
var inst_110929 = cljs.core.PersistentHashMap.EMPTY;
var state_111098__$1 = state_111098;
var statearr_111118_111289 = state_111098__$1;
(statearr_111118_111289[(2)] = inst_110929);

(statearr_111118_111289[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (101))){
var inst_111013 = (state_111098[(17)]);
var state_111098__$1 = state_111098;
var statearr_111119_111290 = state_111098__$1;
(statearr_111119_111290[(2)] = inst_111013);

(statearr_111119_111290[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (24))){
var inst_110813 = (state_111098[(18)]);
var state_111098__$1 = state_111098;
var statearr_111120_111291 = state_111098__$1;
(statearr_111120_111291[(2)] = inst_110813);

(statearr_111120_111291[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (102))){
var state_111098__$1 = state_111098;
if(cljs.core.truth_(fuel)){
var statearr_111121_111292 = state_111098__$1;
(statearr_111121_111292[(1)] = (104));

} else {
var statearr_111122_111293 = state_111098__$1;
(statearr_111122_111293[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (55))){
var inst_110889 = (state_111098[(19)]);
var inst_110891 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_110892 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_110889,inst_110891);
var state_111098__$1 = state_111098;
var statearr_111123_111294 = state_111098__$1;
(statearr_111123_111294[(2)] = inst_110892);

(statearr_111123_111294[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (85))){
var inst_110970 = (state_111098[(20)]);
var inst_110969 = (state_111098[(2)]);
var inst_110970__$1 = fluree.db.util.async.throw_err(inst_110969);
var inst_110971 = (inst_110970__$1 == null);
var state_111098__$1 = (function (){var statearr_111124 = state_111098;
(statearr_111124[(20)] = inst_110970__$1);

return statearr_111124;
})();
if(cljs.core.truth_(inst_110971)){
var statearr_111125_111295 = state_111098__$1;
(statearr_111125_111295[(1)] = (86));

} else {
var statearr_111126_111296 = state_111098__$1;
(statearr_111126_111296[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (39))){
var inst_110877 = typeof from === 'string';
var inst_110878 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_110879 = clojure.string.includes_QMARK_(inst_110878,"/");
var inst_110880 = ((inst_110877) && (inst_110879));
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110880)){
var statearr_111127_111297 = state_111098__$1;
(statearr_111127_111297[(1)] = (49));

} else {
var statearr_111128_111298 = state_111098__$1;
(statearr_111128_111298[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (88))){
var inst_110812 = (state_111098[(8)]);
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_110810 = (state_111098[(9)]);
var inst_110978 = (state_111098[(2)]);
var inst_110979 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_110822,fuel,max_fuel,inst_110820,inst_110978,inst_110810,inst_110812);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(89),inst_110979);
} else {
if((state_val_111099 === (46))){
var state_111098__$1 = state_111098;
var statearr_111129_111299 = state_111098__$1;
(statearr_111129_111299[(2)] = null);

(statearr_111129_111299[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_111098,(3),Error,null,(2));
var state_111098__$1 = state_111098;
if(cljs.core.truth_(select)){
var statearr_111130_111300 = state_111098__$1;
(statearr_111130_111300[(1)] = (5));

} else {
var statearr_111131_111301 = state_111098__$1;
(statearr_111131_111301[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (77))){
var inst_110948 = cljs.core.PersistentHashMap.EMPTY;
var state_111098__$1 = state_111098;
var statearr_111132_111302 = state_111098__$1;
(statearr_111132_111302[(2)] = inst_110948);

(statearr_111132_111302[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (106))){
var inst_111013 = (state_111098[(17)]);
var inst_111027 = (state_111098[(2)]);
var inst_111028 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_111013,false);
var state_111098__$1 = (function (){var statearr_111133 = state_111098;
(statearr_111133[(21)] = inst_111027);

return statearr_111133;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(107),inst_111028);
} else {
if((state_val_111099 === (119))){
var inst_111076 = (state_111098[(22)]);
var state_111098__$1 = state_111098;
var statearr_111134_111303 = state_111098__$1;
(statearr_111134_111303[(2)] = inst_111076);

(statearr_111134_111303[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (95))){
var inst_111066 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111135_111304 = state_111098__$1;
(statearr_111135_111304[(2)] = inst_111066);

(statearr_111135_111304[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (54))){
var inst_110889 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111136 = state_111098;
(statearr_111136[(19)] = inst_110889);

return statearr_111136;
})();
var statearr_111137_111305 = state_111098__$1;
(statearr_111137_111305[(1)] = (55));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (92))){
var inst_110982 = (state_111098[(23)]);
var inst_110989 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111139 = state_111098;
(statearr_111139[(24)] = inst_110989);

return statearr_111139;
})();
var statearr_111140_111306 = state_111098__$1;
(statearr_111140_111306[(2)] = inst_110982);

(statearr_111140_111306[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (104))){
var inst_111022 = cljs.core._deref(fuel);
var inst_111023 = (inst_111022 + (1));
var inst_111024 = cljs.core._vreset_BANG_(fuel,inst_111023);
var state_111098__$1 = state_111098;
var statearr_111141_111307 = state_111098__$1;
(statearr_111141_111307[(2)] = inst_111024);

(statearr_111141_111307[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (15))){
var state_111098__$1 = state_111098;
var statearr_111142_111308 = state_111098__$1;
(statearr_111142_111308[(2)] = false);

(statearr_111142_111308[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (48))){
var inst_110812 = (state_111098[(8)]);
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_110867 = (state_111098[(25)]);
var inst_110871 = (state_111098[(2)]);
var inst_110872 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_110822,fuel,max_fuel,inst_110820,inst_110867,inst_110871,inst_110812);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(45),inst_110872);
} else {
if((state_val_111099 === (50))){
var inst_110918 = (state_111098[(26)]);
var inst_110918__$1 = typeof from === 'string';
var state_111098__$1 = (function (){var statearr_111143 = state_111098;
(statearr_111143[(26)] = inst_110918__$1);

return statearr_111143;
})();
if(cljs.core.truth_(inst_110918__$1)){
var statearr_111144_111309 = state_111098__$1;
(statearr_111144_111309[(1)] = (63));

} else {
var statearr_111145_111310 = state_111098__$1;
(statearr_111145_111310[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (116))){
var state_111098__$1 = state_111098;
var statearr_111146_111311 = state_111098__$1;
(statearr_111146_111311[(2)] = null);

(statearr_111146_111311[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (75))){
var inst_110964 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_111098__$1 = state_111098;
if(inst_110964){
var statearr_111147_111312 = state_111098__$1;
(statearr_111147_111312[(1)] = (82));

} else {
var statearr_111148_111313 = state_111098__$1;
(statearr_111148_111313[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (99))){
var inst_111013 = (state_111098[(17)]);
var inst_111018 = cljs.core.int_QMARK_(inst_111013);
var state_111098__$1 = state_111098;
if(inst_111018){
var statearr_111149_111314 = state_111098__$1;
(statearr_111149_111314[(1)] = (101));

} else {
var statearr_111150_111315 = state_111098__$1;
(statearr_111150_111315[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (21))){
var state_111098__$1 = state_111098;
var statearr_111151_111316 = state_111098__$1;
(statearr_111151_111316[(2)] = opts_SINGLEQUOTE__SINGLEQUOTE_);

(statearr_111151_111316[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (31))){
var inst_110848 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111152_111317 = state_111098__$1;
(statearr_111152_111317[(2)] = inst_110848);

(statearr_111152_111317[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (113))){
var inst_110810 = (state_111098[(9)]);
var state_111098__$1 = state_111098;
var statearr_111153_111318 = state_111098__$1;
(statearr_111153_111318[(2)] = inst_110810);

(statearr_111153_111318[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (32))){
var inst_110809 = (state_111098[(10)]);
var inst_110834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110835 = [inst_110809,"ASC"];
var inst_110836 = (new cljs.core.PersistentVector(null,2,(5),inst_110834,inst_110835,null));
var state_111098__$1 = state_111098;
var statearr_111154_111319 = state_111098__$1;
(statearr_111154_111319[(2)] = inst_110836);

(statearr_111154_111319[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (40))){
var inst_110855 = (state_111098[(27)]);
var inst_111076 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111155 = state_111098;
(statearr_111155[(22)] = inst_111076);

return statearr_111155;
})();
if(cljs.core.truth_(inst_110855)){
var statearr_111156_111320 = state_111098__$1;
(statearr_111156_111320[(1)] = (118));

} else {
var statearr_111157_111321 = state_111098__$1;
(statearr_111157_111321[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (91))){
var state_111098__$1 = state_111098;
var statearr_111158_111322 = state_111098__$1;
(statearr_111158_111322[(2)] = null);

(statearr_111158_111322[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (117))){
var inst_111064 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111159_111323 = state_111098__$1;
(statearr_111159_111323[(2)] = inst_111064);

(statearr_111159_111323[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (108))){
var inst_111007 = (state_111098[(12)]);
var inst_111033 = (state_111098[(28)]);
var inst_111035 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_111007,inst_111033);
var state_111098__$1 = state_111098;
var statearr_111160_111324 = state_111098__$1;
(statearr_111160_111324[(2)] = inst_111035);

(statearr_111160_111324[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (56))){
var inst_110889 = (state_111098[(19)]);
var state_111098__$1 = state_111098;
var statearr_111161_111325 = state_111098__$1;
(statearr_111161_111325[(2)] = inst_110889);

(statearr_111161_111325[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (33))){
var state_111098__$1 = state_111098;
var statearr_111162_111326 = state_111098__$1;
(statearr_111162_111326[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (13))){
var inst_110783 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111164_111327 = state_111098__$1;
(statearr_111164_111327[(2)] = inst_110783);

(statearr_111164_111327[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (22))){
var inst_110811 = (state_111098[(29)]);
var inst_110787 = (state_111098[(14)]);
var inst_110808 = (state_111098[(2)]);
var inst_110809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110808,cljs.core.cst$kw$orderBy);
var inst_110810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110808,cljs.core.cst$kw$limit);
var inst_110811__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110808,cljs.core.cst$kw$component);
var inst_110812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_110808,cljs.core.cst$kw$offset);
var inst_110813 = fluree.db.query.fql_parser.parse_db(db,inst_110787,opts_SINGLEQUOTE__SINGLEQUOTE_);
var inst_110814 = (inst_110811__$1 == null);
var inst_110815 = cljs.core.not(inst_110814);
var state_111098__$1 = (function (){var statearr_111165 = state_111098;
(statearr_111165[(8)] = inst_110812);

(statearr_111165[(10)] = inst_110809);

(statearr_111165[(29)] = inst_110811__$1);

(statearr_111165[(9)] = inst_110810);

(statearr_111165[(18)] = inst_110813);

return statearr_111165;
})();
if(inst_110815){
var statearr_111166_111328 = state_111098__$1;
(statearr_111166_111328[(1)] = (23));

} else {
var statearr_111167_111329 = state_111098__$1;
(statearr_111167_111329[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (90))){
var inst_110984 = cljs.core._deref(fuel);
var inst_110985 = (inst_110984 + (1));
var inst_110986 = cljs.core._vreset_BANG_(fuel,inst_110985);
var state_111098__$1 = state_111098;
var statearr_111168_111330 = state_111098__$1;
(statearr_111168_111330[(2)] = inst_110986);

(statearr_111168_111330[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (109))){
var inst_111007 = (state_111098[(12)]);
var state_111098__$1 = state_111098;
var statearr_111169_111331 = state_111098__$1;
(statearr_111169_111331[(2)] = inst_111007);

(statearr_111169_111331[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (36))){
var state_111098__$1 = state_111098;
var statearr_111170_111332 = state_111098__$1;
(statearr_111170_111332[(2)] = null);

(statearr_111170_111332[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (41))){
var state_111098__$1 = state_111098;
var statearr_111171_111333 = state_111098__$1;
(statearr_111171_111333[(2)] = from);

(statearr_111171_111333[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (118))){
var inst_110812 = (state_111098[(8)]);
var inst_110810 = (state_111098[(9)]);
var inst_111076 = (state_111098[(22)]);
var inst_110856 = (state_111098[(30)]);
var inst_110855 = (state_111098[(27)]);
var inst_111078 = fluree.db.query.fql.sort_offset_and_limit_res(inst_110855,inst_110856,inst_110812,inst_110810,inst_111076);
var state_111098__$1 = state_111098;
var statearr_111172_111334 = state_111098__$1;
(statearr_111172_111334[(2)] = inst_111078);

(statearr_111172_111334[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (89))){
var inst_110981 = (state_111098[(2)]);
var inst_110982 = fluree.db.util.async.throw_err(inst_110981);
var state_111098__$1 = (function (){var statearr_111173 = state_111098;
(statearr_111173[(23)] = inst_110982);

return statearr_111173;
})();
if(cljs.core.truth_(fuel)){
var statearr_111174_111335 = state_111098__$1;
(statearr_111174_111335[(1)] = (90));

} else {
var statearr_111175_111336 = state_111098__$1;
(statearr_111175_111336[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (100))){
var inst_111041 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111176_111337 = state_111098__$1;
(statearr_111176_111337[(2)] = inst_111041);

(statearr_111176_111337[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (122))){
var state_111098__$1 = state_111098;
var statearr_111177_111338 = state_111098__$1;
(statearr_111177_111338[(2)] = selectOne);

(statearr_111177_111338[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (43))){
var inst_110863 = (state_111098[(2)]);
var inst_110864 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_110863);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(44),inst_110864);
} else {
if((state_val_111099 === (61))){
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_110895 = (state_111098[(31)]);
var inst_110810 = (state_111098[(9)]);
var inst_110909 = (state_111098[(2)]);
var inst_110910 = fluree.db.util.async.throw_err(inst_110909);
var inst_110911 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_110895,inst_110910);
var inst_110912 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_110822,fuel,max_fuel,inst_110820,inst_110911,inst_110810);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(62),inst_110912);
} else {
if((state_val_111099 === (29))){
var inst_110809 = (state_111098[(10)]);
var inst_110826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110827 = cljs.core.second(inst_110809);
var inst_110828 = cljs.core.first(inst_110809);
var inst_110829 = [inst_110827,inst_110828];
var inst_110830 = (new cljs.core.PersistentVector(null,2,(5),inst_110826,inst_110829,null));
var state_111098__$1 = state_111098;
var statearr_111178_111339 = state_111098__$1;
(statearr_111178_111339[(2)] = inst_110830);

(statearr_111178_111339[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (44))){
var inst_110809 = (state_111098[(10)]);
var inst_110866 = (state_111098[(2)]);
var inst_110867 = fluree.db.util.async.throw_err(inst_110866);
var state_111098__$1 = (function (){var statearr_111179 = state_111098;
(statearr_111179[(25)] = inst_110867);

return statearr_111179;
})();
if(cljs.core.truth_(inst_110809)){
var statearr_111180_111340 = state_111098__$1;
(statearr_111180_111340[(1)] = (46));

} else {
var statearr_111181_111341 = state_111098__$1;
(statearr_111181_111341[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (93))){
var inst_111002 = cljs.core.seq(from);
var inst_111003 = cljs.core.first(inst_111002);
var inst_111004 = cljs.core.next(inst_111002);
var inst_111005 = cljs.core.PersistentVector.EMPTY;
var inst_111006 = from;
var inst_111007 = inst_111005;
var state_111098__$1 = (function (){var statearr_111182 = state_111098;
(statearr_111182[(12)] = inst_111007);

(statearr_111182[(32)] = inst_111003);

(statearr_111182[(33)] = inst_111004);

(statearr_111182[(13)] = inst_111006);

return statearr_111182;
})();
var statearr_111183_111342 = state_111098__$1;
(statearr_111183_111342[(2)] = null);

(statearr_111183_111342[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (6))){
var state_111098__$1 = state_111098;
if(cljs.core.truth_(selectOne)){
var statearr_111184_111343 = state_111098__$1;
(statearr_111184_111343[(1)] = (8));

} else {
var statearr_111185_111344 = state_111098__$1;
(statearr_111185_111344[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (111))){
var inst_111052 = (state_111098[(2)]);
var inst_111053 = fluree.db.util.async.throw_err(inst_111052);
var state_111098__$1 = state_111098;
var statearr_111186_111345 = state_111098__$1;
(statearr_111186_111345[(2)] = inst_111053);

(statearr_111186_111345[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (28))){
var inst_110854 = (state_111098[(2)]);
var inst_110855 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110854,(0),null);
var inst_110856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_110854,(1),null);
var inst_110857 = typeof where === 'string';
var state_111098__$1 = (function (){var statearr_111187 = state_111098;
(statearr_111187[(30)] = inst_110856);

(statearr_111187[(27)] = inst_110855);

return statearr_111187;
})();
if(cljs.core.truth_(inst_110857)){
var statearr_111188_111346 = state_111098__$1;
(statearr_111188_111346[(1)] = (38));

} else {
var statearr_111189_111347 = state_111098__$1;
(statearr_111189_111347[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (64))){
var inst_110918 = (state_111098[(26)]);
var state_111098__$1 = state_111098;
var statearr_111190_111348 = state_111098__$1;
(statearr_111190_111348[(2)] = inst_110918);

(statearr_111190_111348[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (103))){
var inst_111033 = (state_111098[(28)]);
var inst_111033__$1 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111191 = state_111098;
(statearr_111191[(28)] = inst_111033__$1);

return statearr_111191;
})();
if(cljs.core.truth_(inst_111033__$1)){
var statearr_111192_111349 = state_111098__$1;
(statearr_111192_111349[(1)] = (108));

} else {
var statearr_111193_111350 = state_111098__$1;
(statearr_111193_111350[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (51))){
var inst_111074 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111194_111351 = state_111098__$1;
(statearr_111194_111351[(2)] = inst_111074);

(statearr_111194_111351[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (25))){
var inst_110809 = (state_111098[(10)]);
var inst_110820 = (state_111098[(2)]);
var inst_110821 = cljs.core.PersistentHashMap.EMPTY;
var inst_110822 = cljs.core.volatile_BANG_(inst_110821);
var state_111098__$1 = (function (){var statearr_111195 = state_111098;
(statearr_111195[(15)] = inst_110820);

(statearr_111195[(16)] = inst_110822);

return statearr_111195;
})();
if(cljs.core.truth_(inst_110809)){
var statearr_111196_111352 = state_111098__$1;
(statearr_111196_111352[(1)] = (26));

} else {
var statearr_111197_111353 = state_111098__$1;
(statearr_111197_111353[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (34))){
var inst_110846 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111198_111354 = state_111098__$1;
(statearr_111198_111354[(2)] = inst_110846);

(statearr_111198_111354[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (125))){
var inst_111081 = (state_111098[(7)]);
var state_111098__$1 = state_111098;
var statearr_111199_111355 = state_111098__$1;
(statearr_111199_111355[(2)] = inst_111081);

(statearr_111199_111355[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (17))){
var state_111098__$1 = state_111098;
var statearr_111200_111356 = state_111098__$1;
(statearr_111200_111356[(2)] = true);

(statearr_111200_111356[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (3))){
var inst_110763 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111201_111357 = state_111098__$1;
(statearr_111201_111357[(2)] = inst_110763);


cljs.core.async.impl.ioc_helpers.process_exception(state_111098__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (12))){
var inst_110777 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_110778 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_110779 = cljs.core.PersistentHashMap.fromArrays(inst_110777,inst_110778);
var inst_110780 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_110779);
var inst_110781 = (function(){throw inst_110780})();
var state_111098__$1 = state_111098;
var statearr_111202_111358 = state_111098__$1;
(statearr_111202_111358[(2)] = inst_110781);

(statearr_111202_111358[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (2))){
var inst_111096 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_111098__$1,inst_111096);
} else {
if((state_val_111099 === (66))){
var inst_110809 = (state_111098[(10)]);
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110809)){
var statearr_111203_111359 = state_111098__$1;
(statearr_111203_111359[(1)] = (69));

} else {
var statearr_111204_111360 = state_111098__$1;
(statearr_111204_111360[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (107))){
var inst_111030 = (state_111098[(2)]);
var inst_111031 = fluree.db.util.async.throw_err(inst_111030);
var state_111098__$1 = state_111098;
var statearr_111205_111361 = state_111098__$1;
(statearr_111205_111361[(2)] = inst_111031);

(statearr_111205_111361[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (23))){
var inst_110811 = (state_111098[(29)]);
var inst_110813 = (state_111098[(18)]);
var inst_110817 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_110813,cljs.core.cst$kw$componentFollow_QMARK_,inst_110811);
var state_111098__$1 = state_111098;
var statearr_111206_111362 = state_111098__$1;
(statearr_111206_111362[(2)] = inst_110817);

(statearr_111206_111362[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (47))){
var inst_110810 = (state_111098[(9)]);
var state_111098__$1 = state_111098;
var statearr_111207_111363 = state_111098__$1;
(statearr_111207_111363[(2)] = inst_110810);

(statearr_111207_111363[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (35))){
var inst_110839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110840 = [null,null];
var inst_110841 = (new cljs.core.PersistentVector(null,2,(5),inst_110839,inst_110840,null));
var state_111098__$1 = state_111098;
var statearr_111208_111364 = state_111098__$1;
(statearr_111208_111364[(2)] = inst_110841);

(statearr_111208_111364[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (82))){
var inst_110967 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(85),inst_110967);
} else {
if((state_val_111099 === (76))){
var inst_111070 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111209_111365 = state_111098__$1;
(statearr_111209_111365[(2)] = inst_111070);

(statearr_111209_111365[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (97))){
var inst_110809 = (state_111098[(10)]);
var inst_111043 = (state_111098[(2)]);
var inst_111044 = cljs.core.PersistentVector.EMPTY;
var inst_111045 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_111044,inst_111043);
var state_111098__$1 = (function (){var statearr_111210 = state_111098;
(statearr_111210[(34)] = inst_111045);

return statearr_111210;
})();
if(cljs.core.truth_(inst_110809)){
var statearr_111211_111366 = state_111098__$1;
(statearr_111211_111366[(1)] = (112));

} else {
var statearr_111212_111367 = state_111098__$1;
(statearr_111212_111367[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (19))){
var inst_110800 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111213_111368 = state_111098__$1;
(statearr_111213_111368[(2)] = inst_110800);

(statearr_111213_111368[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (57))){
var inst_110809 = (state_111098[(10)]);
var inst_110895 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111214 = state_111098;
(statearr_111214[(31)] = inst_110895);

return statearr_111214;
})();
if(cljs.core.truth_(inst_110809)){
var statearr_111215_111369 = state_111098__$1;
(statearr_111215_111369[(1)] = (58));

} else {
var statearr_111216_111370 = state_111098__$1;
(statearr_111216_111370[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (68))){
var inst_111072 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111217_111371 = state_111098__$1;
(statearr_111217_111371[(2)] = inst_111072);

(statearr_111217_111371[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (11))){
var state_111098__$1 = state_111098;
var statearr_111218_111372 = state_111098__$1;
(statearr_111218_111372[(2)] = selectDistinct);

(statearr_111218_111372[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (115))){
var inst_111056 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_111057 = ["Invalid 'from' in query:",inst_111056].join('');
var inst_111058 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_111059 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_111060 = cljs.core.PersistentHashMap.fromArrays(inst_111058,inst_111059);
var inst_111061 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_111057,inst_111060);
var state_111098__$1 = state_111098;
var statearr_111219_111373 = state_111098__$1;
(statearr_111219_111373[(2)] = inst_111061);

(statearr_111219_111373[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (9))){
var state_111098__$1 = state_111098;
if(cljs.core.truth_(selectDistinct)){
var statearr_111220_111374 = state_111098__$1;
(statearr_111220_111374[(1)] = (11));

} else {
var statearr_111221_111375 = state_111098__$1;
(statearr_111221_111375[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (5))){
var state_111098__$1 = state_111098;
var statearr_111222_111376 = state_111098__$1;
(statearr_111222_111376[(2)] = select);

(statearr_111222_111376[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (112))){
var state_111098__$1 = state_111098;
var statearr_111223_111377 = state_111098__$1;
(statearr_111223_111377[(2)] = null);

(statearr_111223_111377[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (83))){
var inst_110991 = cljs.core.sequential_QMARK_(from);
var inst_110992 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_110993 = ((inst_110991) && (inst_110992));
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110993)){
var statearr_111224_111378 = state_111098__$1;
(statearr_111224_111378[(1)] = (93));

} else {
var statearr_111225_111379 = state_111098__$1;
(statearr_111225_111379[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (14))){
var inst_110792 = opts_SINGLEQUOTE__SINGLEQUOTE_.cljs$lang$protocol_mask$partition0$;
var inst_110793 = (inst_110792 & (64));
var inst_110794 = opts_SINGLEQUOTE__SINGLEQUOTE_.cljs$core$ISeq$;
var inst_110795 = (cljs.core.PROTOCOL_SENTINEL === inst_110794);
var inst_110796 = ((inst_110793) || (inst_110795));
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110796)){
var statearr_111226_111380 = state_111098__$1;
(statearr_111226_111380[(1)] = (17));

} else {
var statearr_111227_111381 = state_111098__$1;
(statearr_111227_111381[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (45))){
var inst_110874 = (state_111098[(2)]);
var inst_110875 = fluree.db.util.async.throw_err(inst_110874);
var state_111098__$1 = state_111098;
var statearr_111228_111382 = state_111098__$1;
(statearr_111228_111382[(2)] = inst_110875);

(statearr_111228_111382[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (53))){
var inst_110883 = (state_111098[(35)]);
var state_111098__$1 = state_111098;
var statearr_111229_111383 = state_111098__$1;
(statearr_111229_111383[(2)] = inst_110883);

(statearr_111229_111383[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (78))){
var inst_110812 = (state_111098[(8)]);
var inst_110810 = (state_111098[(9)]);
var inst_110950 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_110951 = [inst_110810,inst_110812];
var inst_110952 = cljs.core.PersistentHashMap.fromArrays(inst_110950,inst_110951);
var state_111098__$1 = state_111098;
var statearr_111230_111384 = state_111098__$1;
(statearr_111230_111384[(2)] = inst_110952);

(statearr_111230_111384[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (26))){
var inst_110809 = (state_111098[(10)]);
var inst_110824 = cljs.core.vector_QMARK_(inst_110809);
var state_111098__$1 = state_111098;
if(inst_110824){
var statearr_111231_111385 = state_111098__$1;
(statearr_111231_111385[(1)] = (29));

} else {
var statearr_111232_111386 = state_111098__$1;
(statearr_111232_111386[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (123))){
var inst_111089 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_111089)){
var statearr_111233_111387 = state_111098__$1;
(statearr_111233_111387[(1)] = (124));

} else {
var statearr_111234_111388 = state_111098__$1;
(statearr_111234_111388[(1)] = (125));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (16))){
var inst_110803 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110803)){
var statearr_111235_111389 = state_111098__$1;
(statearr_111235_111389[(1)] = (20));

} else {
var statearr_111236_111390 = state_111098__$1;
(statearr_111236_111390[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (81))){
var inst_110961 = (state_111098[(2)]);
var inst_110962 = fluree.db.util.async.throw_err(inst_110961);
var state_111098__$1 = state_111098;
var statearr_111237_111391 = state_111098__$1;
(statearr_111237_111391[(2)] = inst_110962);

(statearr_111237_111391[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (120))){
var inst_111081 = (state_111098[(2)]);
var state_111098__$1 = (function (){var statearr_111238 = state_111098;
(statearr_111238[(7)] = inst_111081);

return statearr_111238;
})();
if(cljs.core.truth_(selectOne)){
var statearr_111239_111392 = state_111098__$1;
(statearr_111239_111392[(1)] = (121));

} else {
var statearr_111240_111393 = state_111098__$1;
(statearr_111240_111393[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (79))){
var inst_110954 = (state_111098[(2)]);
var inst_110955 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_110954);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(80),inst_110955);
} else {
if((state_val_111099 === (38))){
var inst_110859 = typeof from === 'string';
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110859)){
var statearr_111241_111394 = state_111098__$1;
(statearr_111241_111394[(1)] = (41));

} else {
var statearr_111242_111395 = state_111098__$1;
(statearr_111242_111395[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (126))){
var inst_111094 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111243_111396 = state_111098__$1;
(statearr_111243_111396[(2)] = inst_111094);


cljs.core.async.impl.ioc_helpers.process_exception(state_111098__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (98))){
var inst_111007 = (state_111098[(12)]);
var state_111098__$1 = state_111098;
var statearr_111244_111397 = state_111098__$1;
(statearr_111244_111397[(2)] = inst_111007);

(statearr_111244_111397[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (124))){
var inst_111081 = (state_111098[(7)]);
var inst_111091 = cljs.core.first(inst_111081);
var state_111098__$1 = state_111098;
var statearr_111245_111398 = state_111098__$1;
(statearr_111245_111398[(2)] = inst_111091);

(statearr_111245_111398[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (87))){
var inst_110970 = (state_111098[(20)]);
var inst_110974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110975 = [inst_110970];
var inst_110976 = (new cljs.core.PersistentVector(null,1,(5),inst_110974,inst_110975,null));
var state_111098__$1 = state_111098;
var statearr_111246_111399 = state_111098__$1;
(statearr_111246_111399[(2)] = inst_110976);

(statearr_111246_111399[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (30))){
var inst_110809 = (state_111098[(10)]);
var inst_110832 = typeof inst_110809 === 'string';
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110832)){
var statearr_111247_111400 = state_111098__$1;
(statearr_111247_111400[(1)] = (32));

} else {
var statearr_111248_111401 = state_111098__$1;
(statearr_111248_111401[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (73))){
var inst_110942 = (state_111098[(2)]);
var inst_110943 = fluree.db.util.async.throw_err(inst_110942);
var state_111098__$1 = state_111098;
var statearr_111249_111402 = state_111098__$1;
(statearr_111249_111402[(2)] = inst_110943);

(statearr_111249_111402[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (96))){
var inst_111006 = (state_111098[(13)]);
var inst_111013 = (state_111098[(17)]);
var inst_111012 = cljs.core.seq(inst_111006);
var inst_111013__$1 = cljs.core.first(inst_111012);
var inst_111014 = cljs.core.next(inst_111012);
var inst_111015 = cljs.core.not(inst_111013__$1);
var state_111098__$1 = (function (){var statearr_111250 = state_111098;
(statearr_111250[(11)] = inst_111014);

(statearr_111250[(17)] = inst_111013__$1);

return statearr_111250;
})();
if(inst_111015){
var statearr_111251_111403 = state_111098__$1;
(statearr_111251_111403[(1)] = (98));

} else {
var statearr_111252_111404 = state_111098__$1;
(statearr_111252_111404[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (10))){
var inst_110785 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111253_111405 = state_111098__$1;
(statearr_111253_111405[(2)] = inst_110785);

(statearr_111253_111405[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (18))){
var state_111098__$1 = state_111098;
var statearr_111254_111406 = state_111098__$1;
(statearr_111254_111406[(2)] = false);

(statearr_111254_111406[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (105))){
var state_111098__$1 = state_111098;
var statearr_111255_111407 = state_111098__$1;
(statearr_111255_111407[(2)] = null);

(statearr_111255_111407[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (52))){
var inst_110883 = (state_111098[(35)]);
var inst_110885 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_110886 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_110883,inst_110885);
var state_111098__$1 = state_111098;
var statearr_111256_111408 = state_111098__$1;
(statearr_111256_111408[(2)] = inst_110886);

(statearr_111256_111408[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (114))){
var inst_110812 = (state_111098[(8)]);
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_111045 = (state_111098[(34)]);
var inst_111049 = (state_111098[(2)]);
var inst_111050 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_110822,fuel,max_fuel,inst_110820,inst_111045,inst_111049,inst_110812);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(111),inst_111050);
} else {
if((state_val_111099 === (67))){
var inst_110945 = typeof from === 'string';
var state_111098__$1 = state_111098;
if(cljs.core.truth_(inst_110945)){
var statearr_111257_111409 = state_111098__$1;
(statearr_111257_111409[(1)] = (74));

} else {
var statearr_111258_111410 = state_111098__$1;
(statearr_111258_111410[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (71))){
var inst_110935 = (state_111098[(2)]);
var inst_110936 = fluree.db.query.range._block_or_tx_collection(db,inst_110935);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(72),inst_110936);
} else {
if((state_val_111099 === (42))){
var state_111098__$1 = state_111098;
var statearr_111259_111411 = state_111098__$1;
(statearr_111259_111411[(2)] = null);

(statearr_111259_111411[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (80))){
var inst_110820 = (state_111098[(15)]);
var inst_110822 = (state_111098[(16)]);
var inst_110957 = (state_111098[(2)]);
var inst_110958 = fluree.db.util.async.throw_err(inst_110957);
var inst_110959 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_110822,fuel,max_fuel,inst_110820,inst_110958);
var state_111098__$1 = state_111098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_111098__$1,(81),inst_110959);
} else {
if((state_val_111099 === (37))){
var inst_110844 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111260_111412 = state_111098__$1;
(statearr_111260_111412[(2)] = inst_110844);

(statearr_111260_111412[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (63))){
var inst_110920 = ["_tx",null,"_block",null];
var inst_110921 = (new cljs.core.PersistentArrayMap(null,2,inst_110920,null));
var inst_110922 = (new cljs.core.PersistentHashSet(null,inst_110921,null));
var inst_110923 = (inst_110922.cljs$core$IFn$_invoke$arity$1 ? inst_110922.cljs$core$IFn$_invoke$arity$1(from) : inst_110922.call(null,from));
var state_111098__$1 = state_111098;
var statearr_111261_111413 = state_111098__$1;
(statearr_111261_111413[(2)] = inst_110923);

(statearr_111261_111413[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (94))){
var state_111098__$1 = state_111098;
var statearr_111262_111414 = state_111098__$1;
(statearr_111262_111414[(1)] = (115));



return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (8))){
var state_111098__$1 = state_111098;
var statearr_111264_111415 = state_111098__$1;
(statearr_111264_111415[(2)] = selectOne);

(statearr_111264_111415[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (49))){
var inst_110883 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_111098__$1 = (function (){var statearr_111265 = state_111098;
(statearr_111265[(35)] = inst_110883);

return statearr_111265;
})();
if(cljs.core.truth_(fuel)){
var statearr_111266_111416 = state_111098__$1;
(statearr_111266_111416[(1)] = (52));

} else {
var statearr_111267_111417 = state_111098__$1;
(statearr_111267_111417[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_111099 === (84))){
var inst_111068 = (state_111098[(2)]);
var state_111098__$1 = state_111098;
var statearr_111268_111418 = state_111098__$1;
(statearr_111268_111418[(2)] = inst_111068);

(statearr_111268_111418[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
;
return ((function (switch__99036__auto__,c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function() {
var fluree$db$query$fql$query_$_state_machine__99037__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__99037__auto____0 = (function (){
var statearr_111269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_111269[(0)] = fluree$db$query$fql$query_$_state_machine__99037__auto__);

(statearr_111269[(1)] = (1));

return statearr_111269;
});
var fluree$db$query$fql$query_$_state_machine__99037__auto____1 = (function (state_111098){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_111098);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e111270){if((e111270 instanceof Object)){
var ex__99040__auto__ = e111270;
var statearr_111271_111419 = state_111098;
(statearr_111271_111419[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_111098);

return cljs.core.cst$kw$recur;
} else {
throw e111270;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__111420 = state_111098;
state_111098 = G__111420;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__99037__auto__ = function(state_111098){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__99037__auto____1.call(this,state_111098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__99037__auto____0;
fluree$db$query$fql$query_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__99037__auto____1;
return fluree$db$query$fql$query_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
})();
var state__99061__auto__ = (function (){var statearr_111272 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_111272[(6)] = c__99059__auto__);

return statearr_111272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,max_fuel,fuel,map__110744,map__110744__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
);

return c__99059__auto__;
}

});

//# sourceMappingURL=fql.js.map?rel=1593118619212
