// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k112730,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__112734 = k112730;
var G__112734__$1 = (((G__112734 instanceof cljs.core.Keyword))?G__112734.fqn:null);
switch (G__112734__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k112730,else__4388__auto__);

}
});

fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__112735){
var vec__112736 = p__112735;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112736,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112736,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__112729){
var self__ = this;
var G__112729__$1 = this;
return (new cljs.core.RecordIter((0),G__112729__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__112739 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__112739(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this112731,other112732){
var self__ = this;
var this112731__$1 = this;
return (((!((other112732 == null)))) && ((this112731__$1.constructor === other112732.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.conn,other112732.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.network,other112732.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.dbid,other112732.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.db_name,other112732.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.update_chan,other112732.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.transact_chan,other112732.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.state,other112732.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.schema_cache,other112732.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.blank_db,other112732.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.close,other112732.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.id,other112732.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this112731__$1.__extmap,other112732.__extmap)));
});

fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__112729){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__112740 = cljs.core.keyword_identical_QMARK_;
var expr__112741 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__112743 = cljs.core.cst$kw$conn;
var G__112744 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112743,G__112744) : pred__112740.call(null,G__112743,G__112744));
})())){
return (new fluree.db.session.DbSession(G__112729,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112745 = cljs.core.cst$kw$network;
var G__112746 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112745,G__112746) : pred__112740.call(null,G__112745,G__112746));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__112729,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112747 = cljs.core.cst$kw$dbid;
var G__112748 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112747,G__112748) : pred__112740.call(null,G__112747,G__112748));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__112729,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112749 = cljs.core.cst$kw$db_DASH_name;
var G__112750 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112749,G__112750) : pred__112740.call(null,G__112749,G__112750));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__112729,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112751 = cljs.core.cst$kw$update_DASH_chan;
var G__112752 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112751,G__112752) : pred__112740.call(null,G__112751,G__112752));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__112729,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112753 = cljs.core.cst$kw$transact_DASH_chan;
var G__112754 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112753,G__112754) : pred__112740.call(null,G__112753,G__112754));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__112729,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112755 = cljs.core.cst$kw$state;
var G__112756 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112755,G__112756) : pred__112740.call(null,G__112755,G__112756));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__112729,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112757 = cljs.core.cst$kw$schema_DASH_cache;
var G__112758 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112757,G__112758) : pred__112740.call(null,G__112757,G__112758));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__112729,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112759 = cljs.core.cst$kw$blank_DASH_db;
var G__112760 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112759,G__112760) : pred__112740.call(null,G__112759,G__112760));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__112729,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112761 = cljs.core.cst$kw$close;
var G__112762 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112761,G__112762) : pred__112740.call(null,G__112761,G__112762));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__112729,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__112763 = cljs.core.cst$kw$id;
var G__112764 = expr__112741;
return (pred__112740.cljs$core$IFn$_invoke$arity$2 ? pred__112740.cljs$core$IFn$_invoke$arity$2(G__112763,G__112764) : pred__112740.call(null,G__112763,G__112764));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__112729,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__112729),null));
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__112729){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__112729,self__.__extmap,self__.__hash));
});

fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
});

fluree.db.session.DbSession.cljs$lang$type = true;

fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
});

fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.session/DbSession");
});

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__112733){
var extmap__4424__auto__ = (function (){var G__112765 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__112733,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__112733)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__112765);
} else {
return G__112765;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__112733),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__112733),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__112767 = session;
var map__112767__$1 = (((((!((map__112767 == null))))?(((((map__112767.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__112767.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__112767):map__112767);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__112767__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__112767__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,((function (map__112767,map__112767__$1,network,dbid,cache_key){
return (function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
});})(map__112767,map__112767__$1,network,dbid,cache_key))
);

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___112974 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___112974,pc){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___112974,pc){
return (function (state_112908){
var state_val_112909 = (state_112908[(1)]);
if((state_val_112909 === (7))){
var inst_112791 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
if(cljs.core.truth_(inst_112791)){
var statearr_112910_112975 = state_112908__$1;
(statearr_112910_112975[(1)] = (11));

} else {
var statearr_112911_112976 = state_112908__$1;
(statearr_112911_112976[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (20))){
var inst_112818 = (state_112908[(2)]);
var inst_112819 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112820 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_112821 = cljs.core.PersistentHashMap.fromArrays(inst_112819,inst_112820);
var inst_112822 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_112818,inst_112821);
var inst_112823 = (function(){throw inst_112822})();
var state_112908__$1 = state_112908;
var statearr_112912_112977 = state_112908__$1;
(statearr_112912_112977[(2)] = inst_112823);

(statearr_112912_112977[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (27))){
var inst_112836 = (state_112908[(7)]);
var state_112908__$1 = state_112908;
var statearr_112913_112978 = state_112908__$1;
(statearr_112913_112978[(2)] = inst_112836);

(statearr_112913_112978[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (1))){
var state_112908__$1 = state_112908;
var statearr_112914_112979 = state_112908__$1;
(statearr_112914_112979[(2)] = null);

(statearr_112914_112979[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (24))){
var inst_112893 = (state_112908[(8)]);
var inst_112893__$1 = (state_112908[(2)]);
var inst_112894 = fluree.db.query.schema.schema_map(inst_112893__$1);
var state_112908__$1 = (function (){var statearr_112915 = state_112908;
(statearr_112915[(8)] = inst_112893__$1);

return statearr_112915;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(44),inst_112894);
} else {
if((state_val_112909 === (39))){
var inst_112860 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
var statearr_112916_112980 = state_112908__$1;
(statearr_112916_112980[(2)] = inst_112860);

(statearr_112916_112980[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112908,(3),java.lang.Exception,null,(2));
var inst_112775 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_112777 = (session == null);
var inst_112778 = cljs.core.not(inst_112777);
var state_112908__$1 = (function (){var statearr_112917 = state_112908;
(statearr_112917[(9)] = inst_112775);

return statearr_112917;
})();
if(inst_112778){
var statearr_112918_112981 = state_112908__$1;
(statearr_112918_112981[(1)] = (5));

} else {
var statearr_112919_112982 = state_112908__$1;
(statearr_112919_112982[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (15))){
var inst_112806 = (state_112908[(10)]);
var inst_112811 = cljs.core.empty_QMARK_(inst_112806);
var state_112908__$1 = state_112908;
if(inst_112811){
var statearr_112920_112983 = state_112908__$1;
(statearr_112920_112983[(1)] = (18));

} else {
var statearr_112921_112984 = state_112908__$1;
(statearr_112921_112984[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (21))){
var inst_112806 = (state_112908[(10)]);
var inst_112831 = (state_112908[(11)]);
var inst_112830 = (state_112908[(2)]);
var inst_112831__$1 = fluree.db.util.async.throw_err(inst_112830);
var inst_112832 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_112806);
var state_112908__$1 = (function (){var statearr_112922 = state_112908;
(statearr_112922[(12)] = inst_112832);

(statearr_112922[(11)] = inst_112831__$1);

return statearr_112922;
})();
if(cljs.core.truth_(inst_112831__$1)){
var statearr_112923_112985 = state_112908__$1;
(statearr_112923_112985[(1)] = (22));

} else {
var statearr_112924_112986 = state_112908__$1;
(statearr_112924_112986[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (31))){
var inst_112845 = (state_112908[(13)]);
var inst_112849 = (inst_112845 == null);
var inst_112850 = cljs.core.not(inst_112849);
var state_112908__$1 = state_112908;
if(inst_112850){
var statearr_112925_112987 = state_112908__$1;
(statearr_112925_112987[(1)] = (34));

} else {
var statearr_112926_112988 = state_112908__$1;
(statearr_112926_112988[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (32))){
var inst_112837 = (state_112908[(14)]);
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112879 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112837)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112798),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112799),"."].join('');
var inst_112880 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_112881 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_112882 = cljs.core.PersistentHashMap.fromArrays(inst_112880,inst_112881);
var inst_112883 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_112879,inst_112882);
var inst_112884 = (function(){throw inst_112883})();
var state_112908__$1 = state_112908;
var statearr_112927_112989 = state_112908__$1;
(statearr_112927_112989[(2)] = inst_112884);

(statearr_112927_112989[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (40))){
var inst_112845 = (state_112908[(13)]);
var inst_112865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_112845);
var state_112908__$1 = state_112908;
var statearr_112928_112990 = state_112908__$1;
(statearr_112928_112990[(2)] = inst_112865);

(statearr_112928_112990[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (33))){
var inst_112886 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
var statearr_112929_112991 = state_112908__$1;
(statearr_112929_112991[(2)] = inst_112886);

(statearr_112929_112991[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (13))){
var inst_112797 = (state_112908[(17)]);
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112796 = (state_112908[(2)]);
var inst_112797__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112796,cljs.core.cst$kw$conn);
var inst_112798__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112796,cljs.core.cst$kw$network);
var inst_112799__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112796,cljs.core.cst$kw$dbid);
var inst_112800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112801 = [inst_112798__$1,inst_112799__$1];
var inst_112802 = (new cljs.core.PersistentVector(null,2,(5),inst_112800,inst_112801,null));
var inst_112803 = fluree.db.operations.ledger_info_async(inst_112797__$1,inst_112802);
var state_112908__$1 = (function (){var statearr_112930 = state_112908;
(statearr_112930[(17)] = inst_112797__$1);

(statearr_112930[(15)] = inst_112799__$1);

(statearr_112930[(16)] = inst_112798__$1);

return statearr_112930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(14),inst_112803);
} else {
if((state_val_112909 === (22))){
var inst_112831 = (state_112908[(11)]);
var inst_112834 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_112831);
var inst_112835 = (inst_112834 + (1));
var inst_112836 = inst_112831;
var inst_112837 = inst_112835;
var state_112908__$1 = (function (){var statearr_112931 = state_112908;
(statearr_112931[(14)] = inst_112837);

(statearr_112931[(7)] = inst_112836);

return statearr_112931;
})();
var statearr_112932_112992 = state_112908__$1;
(statearr_112932_112992[(2)] = null);

(statearr_112932_112992[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (36))){
var inst_112863 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
if(cljs.core.truth_(inst_112863)){
var statearr_112933_112993 = state_112908__$1;
(statearr_112933_112993[(1)] = (40));

} else {
var statearr_112934_112994 = state_112908__$1;
(statearr_112934_112994[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (41))){
var inst_112845 = (state_112908[(13)]);
var state_112908__$1 = state_112908;
var statearr_112935_112995 = state_112908__$1;
(statearr_112935_112995[(2)] = inst_112845);

(statearr_112935_112995[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (43))){
var inst_112837 = (state_112908[(14)]);
var inst_112874 = (state_112908[(2)]);
var inst_112875 = fluree.db.util.async.throw_err(inst_112874);
var inst_112876 = (inst_112837 + (1));
var inst_112836 = inst_112875;
var inst_112837__$1 = inst_112876;
var state_112908__$1 = (function (){var statearr_112936 = state_112908;
(statearr_112936[(14)] = inst_112837__$1);

(statearr_112936[(7)] = inst_112836);

return statearr_112936;
})();
var statearr_112937_112996 = state_112908__$1;
(statearr_112937_112996[(2)] = null);

(statearr_112937_112996[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (29))){
var inst_112888 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
var statearr_112938_112997 = state_112908__$1;
(statearr_112938_112997[(2)] = inst_112888);

(statearr_112938_112997[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (44))){
var inst_112893 = (state_112908[(8)]);
var inst_112898 = (state_112908[(18)]);
var inst_112896 = (state_112908[(2)]);
var inst_112897 = fluree.db.util.async.throw_err(inst_112896);
var inst_112898__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_112893,cljs.core.cst$kw$schema,inst_112897);
var inst_112899 = fluree.db.query.schema.setting_map(inst_112898__$1);
var state_112908__$1 = (function (){var statearr_112939 = state_112908;
(statearr_112939[(18)] = inst_112898__$1);

return statearr_112939;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(45),inst_112899);
} else {
if((state_val_112909 === (6))){
var state_112908__$1 = state_112908;
var statearr_112940_112998 = state_112908__$1;
(statearr_112940_112998[(2)] = false);

(statearr_112940_112998[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (28))){
var inst_112837 = (state_112908[(14)]);
var inst_112797 = (state_112908[(17)]);
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112842 = fluree.db.storage.core.read_block(inst_112797,inst_112798,inst_112799,inst_112837);
var state_112908__$1 = state_112908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(30),inst_112842);
} else {
if((state_val_112909 === (25))){
var inst_112832 = (state_112908[(12)]);
var inst_112837 = (state_112908[(14)]);
var inst_112839 = (inst_112837 > inst_112832);
var state_112908__$1 = state_112908;
if(cljs.core.truth_(inst_112839)){
var statearr_112941_112999 = state_112908__$1;
(statearr_112941_112999[(1)] = (27));

} else {
var statearr_112942_113000 = state_112908__$1;
(statearr_112942_113000[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (34))){
var inst_112845 = (state_112908[(13)]);
var inst_112852 = inst_112845.cljs$lang$protocol_mask$partition0$;
var inst_112853 = (inst_112852 & (64));
var inst_112854 = inst_112845.cljs$core$ISeq$;
var inst_112855 = (cljs.core.PROTOCOL_SENTINEL === inst_112854);
var inst_112856 = ((inst_112853) || (inst_112855));
var state_112908__$1 = state_112908;
if(cljs.core.truth_(inst_112856)){
var statearr_112943_113001 = state_112908__$1;
(statearr_112943_113001[(1)] = (37));

} else {
var statearr_112944_113002 = state_112908__$1;
(statearr_112944_113002[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (17))){
var inst_112775 = (state_112908[(9)]);
var inst_112806 = (state_112908[(10)]);
var inst_112797 = (state_112908[(17)]);
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112826 = (state_112908[(2)]);
var inst_112827 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_112806);
var inst_112828 = fluree.db.storage.core.reify_db(inst_112797,inst_112798,inst_112799,inst_112775,inst_112827);
var state_112908__$1 = (function (){var statearr_112945 = state_112908;
(statearr_112945[(19)] = inst_112826);

return statearr_112945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(21),inst_112828);
} else {
if((state_val_112909 === (3))){
var inst_112769 = (state_112908[(2)]);
var inst_112770 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_112769);
var state_112908__$1 = state_112908;
var statearr_112946_113003 = state_112908__$1;
(statearr_112946_113003[(2)] = inst_112770);


cljs.core.async.impl.ioc_helpers.process_exception(state_112908__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (12))){
var state_112908__$1 = state_112908;
var statearr_112947_113004 = state_112908__$1;
(statearr_112947_113004[(2)] = session);

(statearr_112947_113004[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (2))){
var inst_112906 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112908__$1,inst_112906);
} else {
if((state_val_112909 === (23))){
var state_112908__$1 = state_112908;
var statearr_112948_113005 = state_112908__$1;
(statearr_112948_113005[(2)] = null);

(statearr_112948_113005[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (35))){
var state_112908__$1 = state_112908;
var statearr_112949_113006 = state_112908__$1;
(statearr_112949_113006[(2)] = false);

(statearr_112949_113006[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (19))){
var inst_112806 = (state_112908[(10)]);
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112815 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_112806);
var inst_112816 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112798),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112799)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112815),"."].join('');
var state_112908__$1 = state_112908;
var statearr_112950_113007 = state_112908__$1;
(statearr_112950_113007[(2)] = inst_112816);

(statearr_112950_113007[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (11))){
var inst_112793 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_112908__$1 = state_112908;
var statearr_112951_113008 = state_112908__$1;
(statearr_112951_113008[(2)] = inst_112793);

(statearr_112951_113008[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (9))){
var state_112908__$1 = state_112908;
var statearr_112952_113009 = state_112908__$1;
(statearr_112952_113009[(2)] = false);

(statearr_112952_113009[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (5))){
var inst_112780 = session.cljs$lang$protocol_mask$partition0$;
var inst_112781 = (inst_112780 & (64));
var inst_112782 = session.cljs$core$ISeq$;
var inst_112783 = (cljs.core.PROTOCOL_SENTINEL === inst_112782);
var inst_112784 = ((inst_112781) || (inst_112783));
var state_112908__$1 = state_112908;
if(cljs.core.truth_(inst_112784)){
var statearr_112953_113010 = state_112908__$1;
(statearr_112953_113010[(1)] = (8));

} else {
var statearr_112954_113011 = state_112908__$1;
(statearr_112954_113011[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (14))){
var inst_112806 = (state_112908[(10)]);
var inst_112805 = (state_112908[(2)]);
var inst_112806__$1 = fluree.db.util.async.throw_err(inst_112805);
var inst_112807 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_112806__$1);
var inst_112808 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_112807);
var inst_112809 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_112808);
var state_112908__$1 = (function (){var statearr_112955 = state_112908;
(statearr_112955[(10)] = inst_112806__$1);

return statearr_112955;
})();
if(inst_112809){
var statearr_112956_113012 = state_112908__$1;
(statearr_112956_113012[(1)] = (15));

} else {
var statearr_112957_113013 = state_112908__$1;
(statearr_112957_113013[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (45))){
var inst_112898 = (state_112908[(18)]);
var inst_112901 = (state_112908[(2)]);
var inst_112902 = fluree.db.util.async.throw_err(inst_112901);
var inst_112903 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_112898,cljs.core.cst$kw$settings,inst_112902);
var inst_112904 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_112903);
var state_112908__$1 = state_112908;
var statearr_112958_113014 = state_112908__$1;
(statearr_112958_113014[(2)] = inst_112904);


cljs.core.async.impl.ioc_helpers.process_exception(state_112908__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (26))){
var inst_112890 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
var statearr_112959_113015 = state_112908__$1;
(statearr_112959_113015[(2)] = inst_112890);

(statearr_112959_113015[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (16))){
var state_112908__$1 = state_112908;
var statearr_112960_113016 = state_112908__$1;
(statearr_112960_113016[(2)] = null);

(statearr_112960_113016[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (38))){
var state_112908__$1 = state_112908;
var statearr_112961_113017 = state_112908__$1;
(statearr_112961_113017[(2)] = false);

(statearr_112961_113017[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (30))){
var inst_112845 = (state_112908[(13)]);
var inst_112844 = (state_112908[(2)]);
var inst_112845__$1 = fluree.db.util.async.throw_err(inst_112844);
var state_112908__$1 = (function (){var statearr_112962 = state_112908;
(statearr_112962[(13)] = inst_112845__$1);

return statearr_112962;
})();
if(cljs.core.truth_(inst_112845__$1)){
var statearr_112963_113018 = state_112908__$1;
(statearr_112963_113018[(1)] = (31));

} else {
var statearr_112964_113019 = state_112908__$1;
(statearr_112964_113019[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (10))){
var inst_112788 = (state_112908[(2)]);
var state_112908__$1 = state_112908;
var statearr_112965_113020 = state_112908__$1;
(statearr_112965_113020[(2)] = inst_112788);

(statearr_112965_113020[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (18))){
var inst_112799 = (state_112908[(15)]);
var inst_112798 = (state_112908[(16)]);
var inst_112813 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112798),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_112799)," is not found on this ledger group."].join('');
var state_112908__$1 = state_112908;
var statearr_112966_113021 = state_112908__$1;
(statearr_112966_113021[(2)] = inst_112813);

(statearr_112966_113021[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (42))){
var inst_112836 = (state_112908[(7)]);
var inst_112868 = (state_112908[(2)]);
var inst_112869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112868,cljs.core.cst$kw$flakes);
var inst_112870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112868,cljs.core.cst$kw$block);
var inst_112871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_112868,cljs.core.cst$kw$t);
var inst_112872 = fluree.db.dbproto._with(inst_112836,inst_112870,inst_112869);
var state_112908__$1 = (function (){var statearr_112967 = state_112908;
(statearr_112967[(20)] = inst_112871);

return statearr_112967;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112908__$1,(43),inst_112872);
} else {
if((state_val_112909 === (37))){
var state_112908__$1 = state_112908;
var statearr_112968_113022 = state_112908__$1;
(statearr_112968_113022[(2)] = true);

(statearr_112968_113022[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112909 === (8))){
var state_112908__$1 = state_112908;
var statearr_112969_113023 = state_112908__$1;
(statearr_112969_113023[(2)] = true);

(statearr_112969_113023[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___112974,pc))
;
return ((function (switch__99036__auto__,c__99059__auto___112974,pc){
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____0 = (function (){
var statearr_112970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112970[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__);

(statearr_112970[(1)] = (1));

return statearr_112970;
});
var fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____1 = (function (state_112908){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_112908);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e112971){if((e112971 instanceof Object)){
var ex__99040__auto__ = e112971;
var statearr_112972_113024 = state_112908;
(statearr_112972_113024[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112908);

return cljs.core.cst$kw$recur;
} else {
throw e112971;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113025 = state_112908;
state_112908 = G__113025;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__ = function(state_112908){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____1.call(this,state_112908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__99037__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___112974,pc))
})();
var state__99061__auto__ = (function (){var statearr_112973 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_112973[(6)] = c__99059__auto___112974);

return statearr_112973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___112974,pc))
);


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__113026 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__113026,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__113026;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4120__auto__ = network;
if(cljs.core.truth_(and__4120__auto__)){
return maybe_alias;
} else {
return and__4120__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__113027 = cljs.core.get_global_hierarchy;
return (fexpr__113027.cljs$core$IFn$_invoke$arity$0 ? fexpr__113027.cljs$core$IFn$_invoke$arity$0() : fexpr__113027.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (_,event_type,___$1){
return event_type;
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__113029){
var map__113030 = p__113029;
var map__113030__$1 = (((((!((map__113030 == null))))?(((((map__113030.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113030.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113030):map__113030);
var data = map__113030__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113030__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113030__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113030__$1,cljs.core.cst$kw$flakes);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes){
return (function (state_113076){
var state_val_113077 = (state_113076[(1)]);
if((state_val_113077 === (7))){
var inst_113040 = (state_113076[(7)]);
var inst_113048 = ((1) + inst_113040);
var inst_113049 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_113048);
var state_113076__$1 = state_113076;
if(inst_113049){
var statearr_113078_113101 = state_113076__$1;
(statearr_113078_113101[(1)] = (9));

} else {
var statearr_113079_113102 = state_113076__$1;
(statearr_113079_113102[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (1))){
var state_113076__$1 = state_113076;
var statearr_113080_113103 = state_113076__$1;
(statearr_113080_113103[(2)] = null);

(statearr_113080_113103[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (4))){
var inst_113036 = (state_113076[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113076,(3),Error,null,(2));
var inst_113036__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_113076__$1 = (function (){var statearr_113081 = state_113076;
(statearr_113081[(8)] = inst_113036__$1);

return statearr_113081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113076__$1,(5),inst_113036__$1);
} else {
if((state_val_113077 === (13))){
var state_113076__$1 = state_113076;
var statearr_113082_113104 = state_113076__$1;
(statearr_113082_113104[(2)] = null);

(statearr_113082_113104[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (6))){
var inst_113043 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_113044 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_113045 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113043),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113044),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_113046 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113045], 0));
var state_113076__$1 = state_113076;
var statearr_113083_113105 = state_113076__$1;
(statearr_113083_113105[(2)] = inst_113046);

(statearr_113083_113105[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (3))){
var inst_113032 = (state_113076[(2)]);
var state_113076__$1 = state_113076;
var statearr_113084_113106 = state_113076__$1;
(statearr_113084_113106[(2)] = inst_113032);


cljs.core.async.impl.ioc_helpers.process_exception(state_113076__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (12))){
var inst_113040 = (state_113076[(7)]);
var inst_113061 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_113062 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_113063 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113061),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113062),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113040),". Forcing a db reload."].join('');
var inst_113064 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113063], 0));
var inst_113065 = fluree.db.session.reload_db_BANG_(session);
var state_113076__$1 = (function (){var statearr_113085 = state_113076;
(statearr_113085[(9)] = inst_113064);

return statearr_113085;
})();
var statearr_113086_113107 = state_113076__$1;
(statearr_113086_113107[(2)] = inst_113065);

(statearr_113086_113107[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (2))){
var inst_113074 = (state_113076[(2)]);
var state_113076__$1 = state_113076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113076__$1,inst_113074);
} else {
if((state_val_113077 === (11))){
var inst_113070 = (state_113076[(2)]);
var state_113076__$1 = state_113076;
var statearr_113087_113108 = state_113076__$1;
(statearr_113087_113108[(2)] = inst_113070);

(statearr_113087_113108[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (9))){
var inst_113039 = (state_113076[(10)]);
var inst_113040 = (state_113076[(7)]);
var inst_113036 = (state_113076[(8)]);
var inst_113051 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_113052 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_113053 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113051),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113052),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_113054 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113053], 0));
var inst_113055 = (function (){var current_db_ch = inst_113036;
var current_db = inst_113039;
var current_block = inst_113040;
return ((function (current_db_ch,current_db,current_block,inst_113039,inst_113040,inst_113036,inst_113051,inst_113052,inst_113053,inst_113054,state_val_113077,c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes){
return (function (p1__113028_SHARP_){
if((p1__113028_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__113028_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__113028_SHARP_);
}
});
;})(current_db_ch,current_db,current_block,inst_113039,inst_113040,inst_113036,inst_113051,inst_113052,inst_113053,inst_113054,state_val_113077,c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes))
})();
var inst_113056 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_113055,flakes);
var inst_113057 = fluree.db.dbproto._with(inst_113039,block,inst_113056);
var inst_113058 = fluree.db.session.cas_db_BANG_(session,inst_113036,inst_113057);
var state_113076__$1 = (function (){var statearr_113088 = state_113076;
(statearr_113088[(11)] = inst_113054);

return statearr_113088;
})();
var statearr_113089_113109 = state_113076__$1;
(statearr_113089_113109[(2)] = inst_113058);

(statearr_113089_113109[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (5))){
var inst_113039 = (state_113076[(10)]);
var inst_113040 = (state_113076[(7)]);
var inst_113038 = (state_113076[(2)]);
var inst_113039__$1 = fluree.db.util.async.throw_err(inst_113038);
var inst_113040__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_113039__$1);
var inst_113041 = (block <= inst_113040__$1);
var state_113076__$1 = (function (){var statearr_113090 = state_113076;
(statearr_113090[(10)] = inst_113039__$1);

(statearr_113090[(7)] = inst_113040__$1);

return statearr_113090;
})();
if(cljs.core.truth_(inst_113041)){
var statearr_113091_113110 = state_113076__$1;
(statearr_113091_113110[(1)] = (6));

} else {
var statearr_113092_113111 = state_113076__$1;
(statearr_113092_113111[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (14))){
var inst_113068 = (state_113076[(2)]);
var state_113076__$1 = state_113076;
var statearr_113093_113112 = state_113076__$1;
(statearr_113093_113112[(2)] = inst_113068);

(statearr_113093_113112[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (10))){
var state_113076__$1 = state_113076;
var statearr_113094_113113 = state_113076__$1;
(statearr_113094_113113[(1)] = (12));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113077 === (8))){
var inst_113072 = (state_113076[(2)]);
var state_113076__$1 = state_113076;
var statearr_113096_113114 = state_113076__$1;
(statearr_113096_113114[(2)] = inst_113072);


cljs.core.async.impl.ioc_helpers.process_exception(state_113076__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes){
return (function() {
var fluree$db$session$state_machine__99037__auto__ = null;
var fluree$db$session$state_machine__99037__auto____0 = (function (){
var statearr_113097 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113097[(0)] = fluree$db$session$state_machine__99037__auto__);

(statearr_113097[(1)] = (1));

return statearr_113097;
});
var fluree$db$session$state_machine__99037__auto____1 = (function (state_113076){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113076);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113098){if((e113098 instanceof Object)){
var ex__99040__auto__ = e113098;
var statearr_113099_113115 = state_113076;
(statearr_113099_113115[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113076);

return cljs.core.cst$kw$recur;
} else {
throw e113098;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113116 = state_113076;
state_113076 = G__113116;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$session$state_machine__99037__auto__ = function(state_113076){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99037__auto____1.call(this,state_113076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99037__auto____0;
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99037__auto____1;
return fluree$db$session$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes))
})();
var state__99061__auto__ = (function (){var statearr_113100 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113100[(6)] = c__99059__auto__);

return statearr_113100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__113030,map__113030__$1,data,block,t,flakes))
);

return c__99059__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113123){
var state_val_113124 = (state_113123[(1)]);
if((state_val_113124 === (1))){
var inst_113117 = fluree.db.session.clear_db_BANG_(session);
var inst_113118 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_113119 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_113120 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113118),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_113119)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_113121 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113120], 0));
var state_113123__$1 = (function (){var statearr_113125 = state_113123;
(statearr_113125[(7)] = inst_113121);

(statearr_113125[(8)] = inst_113117);

return statearr_113125;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_113123__$1,true);
} else {
return null;
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$session$state_machine__99037__auto__ = null;
var fluree$db$session$state_machine__99037__auto____0 = (function (){
var statearr_113126 = [null,null,null,null,null,null,null,null,null];
(statearr_113126[(0)] = fluree$db$session$state_machine__99037__auto__);

(statearr_113126[(1)] = (1));

return statearr_113126;
});
var fluree$db$session$state_machine__99037__auto____1 = (function (state_113123){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113123);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113127){if((e113127 instanceof Object)){
var ex__99040__auto__ = e113127;
var statearr_113128_113130 = state_113123;
(statearr_113128_113130[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113123);

return cljs.core.cst$kw$recur;
} else {
throw e113127;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113131 = state_113123;
state_113123 = G__113131;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$session$state_machine__99037__auto__ = function(state_113123){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99037__auto____1.call(this,state_113123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99037__auto____0;
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99037__auto____1;
return fluree$db$session$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113129 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113129[(6)] = c__99059__auto__);

return statearr_113129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__113133 = arguments.length;
switch (G__113133) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__113134 = session;
var map__113134__$1 = (((((!((map__113134 == null))))?(((((map__113134.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113134.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113134):map__113134);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113134__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__113136_113139 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__113136_113139.cljs$core$IFn$_invoke$arity$3 ? fexpr__113136_113139.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__113136_113139.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__113137_113140 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__113137_113140.cljs$core$IFn$_invoke$arity$0 ? fexpr__113137_113140.cljs$core$IFn$_invoke$arity$0() : fexpr__113137_113140.call(null));
} else {
}

return true;
}
}
});

fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
});

fluree.db.session.close.cljs$lang$maxFixedArity = 2;

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_113190){
var state_val_113191 = (state_113190[(1)]);
if((state_val_113191 === (7))){
var inst_113186 = (state_113190[(2)]);
var state_113190__$1 = state_113190;
var statearr_113192_113216 = state_113190__$1;
(statearr_113192_113216[(2)] = inst_113186);

(statearr_113192_113216[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (1))){
var state_113190__$1 = state_113190;
var statearr_113193_113217 = state_113190__$1;
(statearr_113193_113217[(2)] = null);

(statearr_113193_113217[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (4))){
var inst_113144 = (state_113190[(7)]);
var inst_113143 = (state_113190[(2)]);
var inst_113144__$1 = fluree.db.util.async.throw_err(inst_113143);
var inst_113145 = fluree.db.session.from_cache(network,ledger_id);
var inst_113146 = (inst_113144__$1 == null);
var state_113190__$1 = (function (){var statearr_113194 = state_113190;
(statearr_113194[(7)] = inst_113144__$1);

(statearr_113194[(8)] = inst_113145);

return statearr_113194;
})();
if(cljs.core.truth_(inst_113146)){
var statearr_113195_113218 = state_113190__$1;
(statearr_113195_113218[(1)] = (5));

} else {
var statearr_113196_113219 = state_113190__$1;
(statearr_113196_113219[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (15))){
var inst_113144 = (state_113190[(7)]);
var inst_113159 = (state_113190[(2)]);
var inst_113160 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113159,"Exception processing ledger updates for message: ",inst_113144], 0));
var state_113190__$1 = state_113190;
var statearr_113197_113220 = state_113190__$1;
(statearr_113197_113220[(2)] = inst_113160);


cljs.core.async.impl.ioc_helpers.process_exception(state_113190__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (13))){
var inst_113182 = (state_113190[(2)]);
var state_113190__$1 = state_113190;
var statearr_113198_113221 = state_113190__$1;
(statearr_113198_113221[(2)] = inst_113182);

(statearr_113198_113221[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (6))){
var inst_113145 = (state_113190[(8)]);
var inst_113151 = (inst_113145 == null);
var state_113190__$1 = state_113190;
if(cljs.core.truth_(inst_113151)){
var statearr_113199_113222 = state_113190__$1;
(statearr_113199_113222[(1)] = (8));

} else {
var statearr_113200_113223 = state_113190__$1;
(statearr_113200_113223[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (17))){
var inst_113175 = (state_113190[(2)]);
var inst_113176 = fluree.db.util.async.throw_err(inst_113175);
var state_113190__$1 = state_113190;
var statearr_113201_113224 = state_113190__$1;
(statearr_113201_113224[(2)] = inst_113176);


cljs.core.async.impl.ioc_helpers.process_exception(state_113190__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (3))){
var inst_113188 = (state_113190[(2)]);
var state_113190__$1 = state_113190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113190__$1,inst_113188);
} else {
if((state_val_113191 === (12))){
var state_113190__$1 = state_113190;
var statearr_113202_113225 = state_113190__$1;
(statearr_113202_113225[(2)] = null);

(statearr_113202_113225[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (2))){
var state_113190__$1 = state_113190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113190__$1,(4),update_chan);
} else {
if((state_val_113191 === (11))){
var state_113190__$1 = state_113190;
var statearr_113203_113226 = state_113190__$1;
(statearr_113203_113226[(2)] = null);

(statearr_113203_113226[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (9))){
var state_113190__$1 = state_113190;
var statearr_113204_113227 = state_113190__$1;
(statearr_113204_113227[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (5))){
var inst_113148 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_113149 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113148], 0));
var state_113190__$1 = state_113190;
var statearr_113206_113228 = state_113190__$1;
(statearr_113206_113228[(2)] = inst_113149);

(statearr_113206_113228[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (14))){
var inst_113178 = (state_113190[(2)]);
var state_113190__$1 = (function (){var statearr_113207 = state_113190;
(statearr_113207[(9)] = inst_113178);

return statearr_113207;
})();
var statearr_113208_113229 = state_113190__$1;
(statearr_113208_113229[(2)] = null);

(statearr_113208_113229[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (16))){
var inst_113144 = (state_113190[(7)]);
var inst_113145 = (state_113190[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113190,(15),java.lang.Exception,null,(14));
var inst_113167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113144,(0),null);
var inst_113168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113144,(1),null);
var inst_113169 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_113170 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113144], 0));
var inst_113171 = fluree.db.util.core.trunc(inst_113170,(200));
var inst_113172 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113169,inst_113171], 0));
var inst_113173 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_113145,inst_113167,inst_113168) : fluree.db.session.process_ledger_update.call(null,inst_113145,inst_113167,inst_113168));
var state_113190__$1 = (function (){var statearr_113209 = state_113190;
(statearr_113209[(10)] = inst_113172);

return statearr_113209;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113190__$1,(17),inst_113173);
} else {
if((state_val_113191 === (10))){
var inst_113184 = (state_113190[(2)]);
var state_113190__$1 = state_113190;
var statearr_113210_113230 = state_113190__$1;
(statearr_113210_113230[(2)] = inst_113184);

(statearr_113210_113230[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113191 === (8))){
var inst_113144 = (state_113190[(7)]);
var inst_113153 = cljs.core.first(inst_113144);
var inst_113154 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113153], 0));
var inst_113155 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_113154].join('');
var inst_113156 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113155], 0));
var state_113190__$1 = state_113190;
var statearr_113211_113231 = state_113190__$1;
(statearr_113211_113231[(2)] = inst_113156);

(statearr_113211_113231[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____0 = (function (){
var statearr_113212 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_113212[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__);

(statearr_113212[(1)] = (1));

return statearr_113212;
});
var fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____1 = (function (state_113190){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113190);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113213){if((e113213 instanceof Object)){
var ex__99040__auto__ = e113213;
var statearr_113214_113232 = state_113190;
(statearr_113214_113232[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113190);

return cljs.core.cst$kw$recur;
} else {
throw e113213;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113233 = state_113190;
state_113190 = G__113233;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__ = function(state_113190){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____1.call(this,state_113190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__99037__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_113215 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113215[(6)] = c__99059__auto__);

return statearr_113215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__113234){
var map__113235 = p__113234;
var map__113235__$1 = (((((!((map__113235 == null))))?(((((map__113235.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113235.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113235):map__113235);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113235__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = ((function (schema_cache,update_chan,transact_chan,state__$1,session,map__113235,map__113235__$1,network,conn,dbid,db,transactor_QMARK_,db_name,state,close,id){
return (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});})(schema_cache,update_chan,transact_chan,state__$1,session,map__113235,map__113235__$1,network,conn,dbid,db,transactor_QMARK_,db_name,state,close,id))
;
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__113240 = block_result;
var map__113240__$1 = (((((!((map__113240 == null))))?(((((map__113240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113240):map__113240);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113240__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113240__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113240__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113240__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113240__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__113241 = tx_result;
var map__113241__$1 = (((((!((map__113241 == null))))?(((((map__113241.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113241.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113241):map__113241);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113241__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113241__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?((function (map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status){
return (function (p1__113237_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__113237_SHARP_.t);
});})(map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status))
:((function (map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status){
return (function (p1__113238_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__113238_SHARP_,(3)));
});})(map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status))
);
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some(((function (map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status,t_filter,response){
return (function (p1__113239_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__113239_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__113239_SHARP_,(2));
} else {
return null;
}
});})(map__113240,map__113240__$1,block,hash,instant,txns,flakes,tx_result,_,map__113241,map__113241__$1,t,status,t_filter,response))
,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__113244 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113244,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113244,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113244,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113244,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = message;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = fluree.db.util.core.random_uuid();
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__113248 = arguments.length;
switch (G__113248) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__113249){
var map__113250 = p__113249;
var map__113250__$1 = (((((!((map__113250 == null))))?(((((map__113250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__113250.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__113250):map__113250);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113250__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113250__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113250__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__113250__$1,cljs.core.cst$kw$jwt);
var vec__113252 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113252,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113252,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113252,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4131__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4131__auto____$1 = state;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__113256_113375 = network;
var G__113257_113376 = ledger_id;
var G__113258_113377 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__113259_113378 = ((function (G__113256_113375,G__113257_113376,G__113258_113377,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt){
return (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__113260 = cljs.core.seq(tids);
var chunk__113261 = null;
var count__113262 = (0);
var i__113263 = (0);
while(true){
if((i__113263 < count__113262)){
var tid = chunk__113261.cljs$core$IIndexed$_nth$arity$2(null,i__113263);
var temp__5735__auto___113380__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___113380__$1)){
var keyed_callbacks_113381 = temp__5735__auto___113380__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_113382 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__113304_113383 = cljs.core.seq(keyed_callbacks_113381);
var chunk__113305_113384 = null;
var count__113306_113385 = (0);
var i__113307_113386 = (0);
while(true){
if((i__113307_113386 < count__113306_113385)){
var vec__113316_113387 = chunk__113305_113384.cljs$core$IIndexed$_nth$arity$2(null,i__113307_113386);
var k_113388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113316_113387,(0),null);
var f_113389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113316_113387,(1),null);
try{(f_113389.cljs$core$IFn$_invoke$arity$1 ? f_113389.cljs$core$IFn$_invoke$arity$1(tx_response_113382) : f_113389.call(null,tx_response_113382));
}catch (e113319){if((e113319 instanceof java.lang.Exception)){
var e_113390 = e113319;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_113390,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e113319;

}
}

var G__113391 = seq__113304_113383;
var G__113392 = chunk__113305_113384;
var G__113393 = count__113306_113385;
var G__113394 = (i__113307_113386 + (1));
seq__113304_113383 = G__113391;
chunk__113305_113384 = G__113392;
count__113306_113385 = G__113393;
i__113307_113386 = G__113394;
continue;
} else {
var temp__5735__auto___113395__$2 = cljs.core.seq(seq__113304_113383);
if(temp__5735__auto___113395__$2){
var seq__113304_113396__$1 = temp__5735__auto___113395__$2;
if(cljs.core.chunked_seq_QMARK_(seq__113304_113396__$1)){
var c__4550__auto___113397 = cljs.core.chunk_first(seq__113304_113396__$1);
var G__113398 = cljs.core.chunk_rest(seq__113304_113396__$1);
var G__113399 = c__4550__auto___113397;
var G__113400 = cljs.core.count(c__4550__auto___113397);
var G__113401 = (0);
seq__113304_113383 = G__113398;
chunk__113305_113384 = G__113399;
count__113306_113385 = G__113400;
i__113307_113386 = G__113401;
continue;
} else {
var vec__113320_113402 = cljs.core.first(seq__113304_113396__$1);
var k_113403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113320_113402,(0),null);
var f_113404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113320_113402,(1),null);
try{(f_113404.cljs$core$IFn$_invoke$arity$1 ? f_113404.cljs$core$IFn$_invoke$arity$1(tx_response_113382) : f_113404.call(null,tx_response_113382));
}catch (e113323){if((e113323 instanceof java.lang.Exception)){
var e_113405 = e113323;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_113405,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e113323;

}
}

var G__113406 = cljs.core.next(seq__113304_113396__$1);
var G__113407 = null;
var G__113408 = (0);
var G__113409 = (0);
seq__113304_113383 = G__113406;
chunk__113305_113384 = G__113407;
count__113306_113385 = G__113408;
i__113307_113386 = G__113409;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__113410 = seq__113260;
var G__113411 = chunk__113261;
var G__113412 = count__113262;
var G__113413 = (i__113263 + (1));
seq__113260 = G__113410;
chunk__113261 = G__113411;
count__113262 = G__113412;
i__113263 = G__113413;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__113260);
if(temp__5735__auto____$1){
var seq__113260__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__113260__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__113260__$1);
var G__113414 = cljs.core.chunk_rest(seq__113260__$1);
var G__113415 = c__4550__auto__;
var G__113416 = cljs.core.count(c__4550__auto__);
var G__113417 = (0);
seq__113260 = G__113414;
chunk__113261 = G__113415;
count__113262 = G__113416;
i__113263 = G__113417;
continue;
} else {
var tid = cljs.core.first(seq__113260__$1);
var temp__5735__auto___113418__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___113418__$2)){
var keyed_callbacks_113419 = temp__5735__auto___113418__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_113420 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__113324_113421 = cljs.core.seq(keyed_callbacks_113419);
var chunk__113325_113422 = null;
var count__113326_113423 = (0);
var i__113327_113424 = (0);
while(true){
if((i__113327_113424 < count__113326_113423)){
var vec__113336_113425 = chunk__113325_113422.cljs$core$IIndexed$_nth$arity$2(null,i__113327_113424);
var k_113426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113336_113425,(0),null);
var f_113427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113336_113425,(1),null);
try{(f_113427.cljs$core$IFn$_invoke$arity$1 ? f_113427.cljs$core$IFn$_invoke$arity$1(tx_response_113420) : f_113427.call(null,tx_response_113420));
}catch (e113339){if((e113339 instanceof java.lang.Exception)){
var e_113428 = e113339;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_113428,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e113339;

}
}

var G__113429 = seq__113324_113421;
var G__113430 = chunk__113325_113422;
var G__113431 = count__113326_113423;
var G__113432 = (i__113327_113424 + (1));
seq__113324_113421 = G__113429;
chunk__113325_113422 = G__113430;
count__113326_113423 = G__113431;
i__113327_113424 = G__113432;
continue;
} else {
var temp__5735__auto___113433__$3 = cljs.core.seq(seq__113324_113421);
if(temp__5735__auto___113433__$3){
var seq__113324_113434__$1 = temp__5735__auto___113433__$3;
if(cljs.core.chunked_seq_QMARK_(seq__113324_113434__$1)){
var c__4550__auto___113435 = cljs.core.chunk_first(seq__113324_113434__$1);
var G__113436 = cljs.core.chunk_rest(seq__113324_113434__$1);
var G__113437 = c__4550__auto___113435;
var G__113438 = cljs.core.count(c__4550__auto___113435);
var G__113439 = (0);
seq__113324_113421 = G__113436;
chunk__113325_113422 = G__113437;
count__113326_113423 = G__113438;
i__113327_113424 = G__113439;
continue;
} else {
var vec__113340_113440 = cljs.core.first(seq__113324_113434__$1);
var k_113441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113340_113440,(0),null);
var f_113442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113340_113440,(1),null);
try{(f_113442.cljs$core$IFn$_invoke$arity$1 ? f_113442.cljs$core$IFn$_invoke$arity$1(tx_response_113420) : f_113442.call(null,tx_response_113420));
}catch (e113343){if((e113343 instanceof java.lang.Exception)){
var e_113443 = e113343;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_113443,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e113343;

}
}

var G__113444 = cljs.core.next(seq__113324_113434__$1);
var G__113445 = null;
var G__113446 = (0);
var G__113447 = (0);
seq__113324_113421 = G__113444;
chunk__113325_113422 = G__113445;
count__113326_113423 = G__113446;
i__113327_113424 = G__113447;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__113448 = cljs.core.next(seq__113260__$1);
var G__113449 = null;
var G__113450 = (0);
var G__113451 = (0);
seq__113260 = G__113448;
chunk__113261 = G__113449;
count__113262 = G__113450;
i__113263 = G__113451;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});})(G__113256_113375,G__113257_113376,G__113258_113377,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt))
;
var fexpr__113255_113379 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__113255_113379.cljs$core$IFn$_invoke$arity$4 ? fexpr__113255_113379.cljs$core$IFn$_invoke$arity$4(G__113256_113375,G__113257_113376,G__113258_113377,G__113259_113378) : fexpr__113255_113379.call(null,G__113256_113375,G__113257_113376,G__113258_113377,G__113259_113378));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_113452 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__99059__auto___113453 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt){
return (function (state_113360){
var state_val_113361 = (state_113360[(1)]);
if((state_val_113361 === (1))){
var state_113360__$1 = state_113360;
var statearr_113362_113454 = state_113360__$1;
(statearr_113362_113454[(2)] = null);

(statearr_113362_113454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113361 === (2))){
var inst_113345 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_113360__$1 = state_113360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113360__$1,(4),inst_113345);
} else {
if((state_val_113361 === (3))){
var inst_113358 = (state_113360[(2)]);
var state_113360__$1 = state_113360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113360__$1,inst_113358);
} else {
if((state_val_113361 === (4))){
var inst_113347 = (state_113360[(7)]);
var inst_113347__$1 = (state_113360[(2)]);
var inst_113348 = (inst_113347__$1 == null);
var state_113360__$1 = (function (){var statearr_113363 = state_113360;
(statearr_113363[(7)] = inst_113347__$1);

return statearr_113363;
})();
if(cljs.core.truth_(inst_113348)){
var statearr_113364_113455 = state_113360__$1;
(statearr_113364_113455[(1)] = (5));

} else {
var statearr_113365_113456 = state_113360__$1;
(statearr_113365_113456[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113361 === (5))){
var inst_113350 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_113351 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_113350], 0));
var state_113360__$1 = state_113360;
var statearr_113366_113457 = state_113360__$1;
(statearr_113366_113457[(2)] = inst_113351);

(statearr_113366_113457[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113361 === (6))){
var inst_113347 = (state_113360[(7)]);
var inst_113353 = (transact_handler_113452.cljs$core$IFn$_invoke$arity$2 ? transact_handler_113452.cljs$core$IFn$_invoke$arity$2(conn,inst_113347) : transact_handler_113452.call(null,conn,inst_113347));
var state_113360__$1 = (function (){var statearr_113367 = state_113360;
(statearr_113367[(8)] = inst_113353);

return statearr_113367;
})();
var statearr_113368_113458 = state_113360__$1;
(statearr_113368_113458[(2)] = null);

(statearr_113368_113458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113361 === (7))){
var inst_113356 = (state_113360[(2)]);
var state_113360__$1 = state_113360;
var statearr_113369_113459 = state_113360__$1;
(statearr_113369_113459[(2)] = inst_113356);

(statearr_113369_113459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt))
;
return ((function (switch__99036__auto__,c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt){
return (function() {
var fluree$db$session$state_machine__99037__auto__ = null;
var fluree$db$session$state_machine__99037__auto____0 = (function (){
var statearr_113370 = [null,null,null,null,null,null,null,null,null];
(statearr_113370[(0)] = fluree$db$session$state_machine__99037__auto__);

(statearr_113370[(1)] = (1));

return statearr_113370;
});
var fluree$db$session$state_machine__99037__auto____1 = (function (state_113360){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_113360);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e113371){if((e113371 instanceof Object)){
var ex__99040__auto__ = e113371;
var statearr_113372_113460 = state_113360;
(statearr_113372_113460[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113360);

return cljs.core.cst$kw$recur;
} else {
throw e113371;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__113461 = state_113360;
state_113360 = G__113461;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$session$state_machine__99037__auto__ = function(state_113360){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99037__auto____1.call(this,state_113360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99037__auto____0;
fluree$db$session$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99037__auto____1;
return fluree$db$session$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt))
})();
var state__99061__auto__ = (function (){var statearr_113373 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_113373[(6)] = c__99059__auto___113453);

return statearr_113373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___113453,transact_handler_113452,session,new_QMARK_,or__4131__auto__,vec__113252,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__113250,map__113250__$1,state,connect_QMARK_,auth,jwt))
);

} else {
}
} else {
}

return session;
}
});

fluree.db.session.session.cljs$lang$maxFixedArity = 3;

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__113462_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__113462_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__113462_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),((function (db){
return (function (p1__113463_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__113463_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});})(db))
);

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__113466 = arguments.length;
switch (G__113466) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
});

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__113467 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__113467){
return (function (p1__113464_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__113464_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
});})(G__113467))
,G__113467);
} else {
return G__113467;
}
})();
var seq__113468 = cljs.core.seq(sessions);
var chunk__113469 = null;
var count__113470 = (0);
var i__113471 = (0);
while(true){
if((i__113471 < count__113470)){
var session = chunk__113469.cljs$core$IIndexed$_nth$arity$2(null,i__113471);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__113473 = seq__113468;
var G__113474 = chunk__113469;
var G__113475 = count__113470;
var G__113476 = (i__113471 + (1));
seq__113468 = G__113473;
chunk__113469 = G__113474;
count__113470 = G__113475;
i__113471 = G__113476;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__113468);
if(temp__5735__auto__){
var seq__113468__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__113468__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__113468__$1);
var G__113477 = cljs.core.chunk_rest(seq__113468__$1);
var G__113478 = c__4550__auto__;
var G__113479 = cljs.core.count(c__4550__auto__);
var G__113480 = (0);
seq__113468 = G__113477;
chunk__113469 = G__113478;
count__113470 = G__113479;
i__113471 = G__113480;
continue;
} else {
var session = cljs.core.first(seq__113468__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__113481 = cljs.core.next(seq__113468__$1);
var G__113482 = null;
var G__113483 = (0);
var G__113484 = (0);
seq__113468 = G__113481;
chunk__113469 = G__113482;
count__113470 = G__113483;
i__113471 = G__113484;
continue;
}
} else {
return null;
}
}
break;
}
});

fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1;

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});

//# sourceMappingURL=session.js.map?rel=1593118620129
