// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k108643,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__108647 = k108643;
var G__108647__$1 = (((G__108647 instanceof cljs.core.Keyword))?G__108647.fqn:null);
switch (G__108647__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k108643,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__108648){
var vec__108649 = p__108648;
var k__4403__auto__ = cljs.core.nth.call(null,vec__108649,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__108649,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__108642){
var self__ = this;
var G__108642__$1 = this;
return (new cljs.core.RecordIter((0),G__108642__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this108644,other108645){
var self__ = this;
var this108644__$1 = this;
return (((!((other108645 == null)))) && ((this108644__$1.constructor === other108645.constructor)) && (cljs.core._EQ_.call(null,this108644__$1.index_type,other108645.index_type)) && (cljs.core._EQ_.call(null,this108644__$1.comparator,other108645.comparator)) && (cljs.core._EQ_.call(null,this108644__$1.historyComparator,other108645.historyComparator)) && (cljs.core._EQ_.call(null,this108644__$1.__extmap,other108645.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__108642){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__108652 = cljs.core.keyword_identical_QMARK_;
var expr__108653 = k__4388__auto__;
if(cljs.core.truth_(pred__108652.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__108653))){
return (new fluree.db.index.IndexConfig(G__108642,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108652.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__108653))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__108642,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108652.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__108653))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__108642,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__108642),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__108642){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__108642,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__108646){
var extmap__4419__auto__ = (function (){var G__108655 = cljs.core.dissoc.call(null,G__108646,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__108646)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__108655);
} else {
return G__108655;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__108646),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__108646),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__108646),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k108658,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__108662 = k108658;
var G__108662__$1 = (((G__108662 instanceof cljs.core.Keyword))?G__108662.fqn:null);
switch (G__108662__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k108658,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__108663){
var vec__108664 = p__108663;
var k__4403__auto__ = cljs.core.nth.call(null,vec__108664,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__108664,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__108657){
var self__ = this;
var G__108657__$1 = this;
return (new cljs.core.RecordIter((0),G__108657__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108668){
var state_val_108669 = (state_108668[(1)]);
if((state_val_108669 === (1))){
var state_108668__$1 = state_108668;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108668__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_108670 = [null,null,null,null,null,null,null];
(statearr_108670[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_108670[(1)] = (1));

return statearr_108670;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_108668){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108671){if((e108671 instanceof Object)){
var ex__99978__auto__ = e108671;
var statearr_108672_108749 = state_108668;
(statearr_108672_108749[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108668);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108750 = state_108668;
state_108668 = G__108750;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_108668){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_108668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108673 = f__100070__auto__.call(null);
(statearr_108673[(6)] = c__100069__auto__);

return statearr_108673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108695){
var state_val_108696 = (state_108695[(1)]);
if((state_val_108696 === (7))){
var inst_108691 = (state_108695[(2)]);
var state_108695__$1 = state_108695;
var statearr_108697_108751 = state_108695__$1;
(statearr_108697_108751[(2)] = inst_108691);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108695__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108696 === (1))){
var state_108695__$1 = state_108695;
var statearr_108698_108752 = state_108695__$1;
(statearr_108698_108752[(2)] = null);

(statearr_108698_108752[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108696 === (4))){
var inst_108678 = (state_108695[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108695,(3),Error,null,(2));
var inst_108678__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_108679 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_108678__$1);
var state_108695__$1 = (function (){var statearr_108699 = state_108695;
(statearr_108699[(7)] = inst_108678__$1);

return statearr_108699;
})();
if(cljs.core.truth_(inst_108679)){
var statearr_108700_108753 = state_108695__$1;
(statearr_108700_108753[(1)] = (5));

} else {
var statearr_108701_108754 = state_108695__$1;
(statearr_108701_108754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108696 === (6))){
var inst_108678 = (state_108695[(7)]);
var inst_108682 = fluree.db.dbproto._resolve.call(null,inst_108678);
var state_108695__$1 = state_108695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108695__$1,(9),inst_108682);
} else {
if((state_val_108696 === (3))){
var inst_108674 = (state_108695[(2)]);
var state_108695__$1 = state_108695;
var statearr_108702_108755 = state_108695__$1;
(statearr_108702_108755[(2)] = inst_108674);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108695__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108696 === (2))){
var inst_108693 = (state_108695[(2)]);
var state_108695__$1 = state_108695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108695__$1,inst_108693);
} else {
if((state_val_108696 === (9))){
var inst_108684 = (state_108695[(2)]);
var inst_108685 = fluree.db.util.async.throw_err.call(null,inst_108684);
var inst_108686 = fluree.db.dbproto._lookup_leaf.call(null,inst_108685,flake);
var state_108695__$1 = state_108695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108695__$1,(8),inst_108686);
} else {
if((state_val_108696 === (5))){
var inst_108678 = (state_108695[(7)]);
var state_108695__$1 = state_108695;
var statearr_108703_108756 = state_108695__$1;
(statearr_108703_108756[(2)] = inst_108678);

(statearr_108703_108756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108696 === (8))){
var inst_108688 = (state_108695[(2)]);
var inst_108689 = fluree.db.util.async.throw_err.call(null,inst_108688);
var state_108695__$1 = state_108695;
var statearr_108704_108757 = state_108695__$1;
(statearr_108704_108757[(2)] = inst_108689);

(statearr_108704_108757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_108705 = [null,null,null,null,null,null,null,null];
(statearr_108705[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_108705[(1)] = (1));

return statearr_108705;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_108695){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108706){if((e108706 instanceof Object)){
var ex__99978__auto__ = e108706;
var statearr_108707_108758 = state_108695;
(statearr_108707_108758[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108706;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108759 = state_108695;
state_108695 = G__108759;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_108695){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_108695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108708 = f__100070__auto__.call(null);
(statearr_108708[(6)] = c__100069__auto__);

return statearr_108708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108730){
var state_val_108731 = (state_108730[(1)]);
if((state_val_108731 === (7))){
var inst_108726 = (state_108730[(2)]);
var state_108730__$1 = state_108730;
var statearr_108732_108760 = state_108730__$1;
(statearr_108732_108760[(2)] = inst_108726);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108730__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108731 === (1))){
var state_108730__$1 = state_108730;
var statearr_108733_108761 = state_108730__$1;
(statearr_108733_108761[(2)] = null);

(statearr_108733_108761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108731 === (4))){
var inst_108713 = (state_108730[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108730,(3),Error,null,(2));
var inst_108713__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_108714 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_108713__$1);
var state_108730__$1 = (function (){var statearr_108734 = state_108730;
(statearr_108734[(7)] = inst_108713__$1);

return statearr_108734;
})();
if(cljs.core.truth_(inst_108714)){
var statearr_108735_108762 = state_108730__$1;
(statearr_108735_108762[(1)] = (5));

} else {
var statearr_108736_108763 = state_108730__$1;
(statearr_108736_108763[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108731 === (6))){
var inst_108713 = (state_108730[(7)]);
var inst_108717 = fluree.db.dbproto._resolve.call(null,inst_108713);
var state_108730__$1 = state_108730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108730__$1,(9),inst_108717);
} else {
if((state_val_108731 === (3))){
var inst_108709 = (state_108730[(2)]);
var state_108730__$1 = state_108730;
var statearr_108737_108764 = state_108730__$1;
(statearr_108737_108764[(2)] = inst_108709);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108730__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108731 === (2))){
var inst_108728 = (state_108730[(2)]);
var state_108730__$1 = state_108730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108730__$1,inst_108728);
} else {
if((state_val_108731 === (9))){
var inst_108719 = (state_108730[(2)]);
var inst_108720 = fluree.db.util.async.throw_err.call(null,inst_108719);
var inst_108721 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_108720,flake);
var state_108730__$1 = state_108730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108730__$1,(8),inst_108721);
} else {
if((state_val_108731 === (5))){
var inst_108713 = (state_108730[(7)]);
var state_108730__$1 = state_108730;
var statearr_108738_108765 = state_108730__$1;
(statearr_108738_108765[(2)] = inst_108713);

(statearr_108738_108765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108731 === (8))){
var inst_108723 = (state_108730[(2)]);
var inst_108724 = fluree.db.util.async.throw_err.call(null,inst_108723);
var state_108730__$1 = state_108730;
var statearr_108739_108766 = state_108730__$1;
(statearr_108739_108766[(2)] = inst_108724);

(statearr_108739_108766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_108740 = [null,null,null,null,null,null,null,null];
(statearr_108740[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_108740[(1)] = (1));

return statearr_108740;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_108730){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108741){if((e108741 instanceof Object)){
var ex__99978__auto__ = e108741;
var statearr_108742_108767 = state_108730;
(statearr_108742_108767[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108768 = state_108730;
state_108730 = G__108768;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_108730){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_108730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108743 = f__100070__auto__.call(null);
(statearr_108743[(6)] = c__100069__auto__);

return statearr_108743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this108659,other108660){
var self__ = this;
var this108659__$1 = this;
return (((!((other108660 == null)))) && ((this108659__$1.constructor === other108660.constructor)) && (cljs.core._EQ_.call(null,this108659__$1.block,other108660.block)) && (cljs.core._EQ_.call(null,this108659__$1.t,other108660.t)) && (cljs.core._EQ_.call(null,this108659__$1.rhs,other108660.rhs)) && (cljs.core._EQ_.call(null,this108659__$1.children,other108660.children)) && (cljs.core._EQ_.call(null,this108659__$1.config,other108660.config)) && (cljs.core._EQ_.call(null,this108659__$1.leftmost_QMARK_,other108660.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this108659__$1.__extmap,other108660.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__108657){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__108744 = cljs.core.keyword_identical_QMARK_;
var expr__108745 = k__4388__auto__;
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__108745))){
return (new fluree.db.index.IndexNode(G__108657,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__108745))){
return (new fluree.db.index.IndexNode(self__.block,G__108657,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__108745))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__108657,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__108745))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__108657,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__108745))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__108657,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108744.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__108745))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__108657,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__108657),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__108657){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__108657,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__108661){
var extmap__4419__auto__ = (function (){var G__108747 = cljs.core.dissoc.call(null,G__108661,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__108661)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__108747);
} else {
return G__108747;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__108661),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__108661),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__108661),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__108661),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__108661),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__108661),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k108770,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__108774 = k108770;
var G__108774__$1 = (((G__108774 instanceof cljs.core.Keyword))?G__108774.fqn:null);
switch (G__108774__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k108770,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__108775){
var vec__108776 = p__108775;
var k__4403__auto__ = cljs.core.nth.call(null,vec__108776,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__108776,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__108769){
var self__ = this;
var G__108769__$1 = this;
return (new cljs.core.RecordIter((0),G__108769__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108780){
var state_val_108781 = (state_108780[(1)]);
if((state_val_108781 === (1))){
var state_108780__$1 = state_108780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108780__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_108782 = [null,null,null,null,null,null,null];
(statearr_108782[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_108782[(1)] = (1));

return statearr_108782;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_108780){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108783){if((e108783 instanceof Object)){
var ex__99978__auto__ = e108783;
var statearr_108784_108802 = state_108780;
(statearr_108784_108802[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108780);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108783;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108803 = state_108780;
state_108780 = G__108803;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_108780){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_108780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108785 = f__100070__auto__.call(null);
(statearr_108785[(6)] = c__100069__auto__);

return statearr_108785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108791){
var state_val_108792 = (state_108791[(1)]);
if((state_val_108792 === (1))){
var inst_108786 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_108787 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_108788 = cljs.core.PersistentHashMap.fromArrays(inst_108786,inst_108787);
var inst_108789 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_108788);
var state_108791__$1 = state_108791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108791__$1,inst_108789);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__99975__auto__ = null;
var fluree$db$index$state_machine__99975__auto____0 = (function (){
var statearr_108793 = [null,null,null,null,null,null,null];
(statearr_108793[(0)] = fluree$db$index$state_machine__99975__auto__);

(statearr_108793[(1)] = (1));

return statearr_108793;
});
var fluree$db$index$state_machine__99975__auto____1 = (function (state_108791){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108794){if((e108794 instanceof Object)){
var ex__99978__auto__ = e108794;
var statearr_108795_108804 = state_108791;
(statearr_108795_108804[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108805 = state_108791;
state_108791 = G__108805;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$index$state_machine__99975__auto__ = function(state_108791){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__99975__auto____1.call(this,state_108791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__99975__auto____0;
fluree$db$index$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__99975__auto____1;
return fluree$db$index$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108796 = f__100070__auto__.call(null);
(statearr_108796[(6)] = c__100069__auto__);

return statearr_108796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this108771,other108772){
var self__ = this;
var this108771__$1 = this;
return (((!((other108772 == null)))) && ((this108771__$1.constructor === other108772.constructor)) && (cljs.core._EQ_.call(null,this108771__$1.block,other108772.block)) && (cljs.core._EQ_.call(null,this108771__$1.t,other108772.t)) && (cljs.core._EQ_.call(null,this108771__$1.flakes,other108772.flakes)) && (cljs.core._EQ_.call(null,this108771__$1.rhs,other108772.rhs)) && (cljs.core._EQ_.call(null,this108771__$1.config,other108772.config)) && (cljs.core._EQ_.call(null,this108771__$1.__extmap,other108772.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__108769){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__108797 = cljs.core.keyword_identical_QMARK_;
var expr__108798 = k__4388__auto__;
if(cljs.core.truth_(pred__108797.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__108798))){
return (new fluree.db.index.DataNode(G__108769,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108797.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__108798))){
return (new fluree.db.index.DataNode(self__.block,G__108769,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108797.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__108798))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__108769,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108797.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__108798))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__108769,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__108797.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__108798))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__108769,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__108769),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__108769){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__108769,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__108773){
var extmap__4419__auto__ = (function (){var G__108800 = cljs.core.dissoc.call(null,G__108773,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__108773)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__108800);
} else {
return G__108800;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__108773),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__108773),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__108773),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__108773),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__108773),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
