// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e105926){var e = e105926;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__105927_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__105927_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__105927_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__105927_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (cljs.core.not.call(null,key_as_var)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105928_SHARP_){
return cljs.core.conj.call(null,p1__105928_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105929_SHARP_){
return cljs.core.conj.call(null,p1__105929_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__105934 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__105934,(0),null);
var _ = cljs.core.nth.call(null,vec__105934,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105930_SHARP_){
return cljs.core.conj.call(null,p1__105930_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.call(null,idx,(1)))?cljs.core.re_find.call(null,/\+/,key):false))){
var vec__105937 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__105937,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__105937,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105931_SHARP_){
return cljs.core.conj.call(null,p1__105931_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105932_SHARP_){
return cljs.core.conj.call(null,p1__105932_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__105933_SHARP_){
return cljs.core.conj.call(null,p1__105933_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__105940_SHARP_){
return cljs.core.nth.call(null,array,p1__105940_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5733__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__105943,optional_QMARK_,fuel,max_fuel){
var map__105944 = p__105943;
var map__105944__$1 = (((((!((map__105944 == null))))?(((((map__105944.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105944.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__105944):map__105944);
var res = map__105944__$1;
var vars = cljs.core.get.call(null,map__105944__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106007){
var state_val_106008 = (state_106007[(1)]);
if((state_val_106008 === (7))){
var inst_106003 = (state_106007[(2)]);
var state_106007__$1 = state_106007;
var statearr_106009_106030 = state_106007__$1;
(statearr_106009_106030[(2)] = inst_106003);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106007__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (1))){
var state_106007__$1 = state_106007;
var statearr_106010_106031 = state_106007__$1;
(statearr_106010_106031[(2)] = null);

(statearr_106010_106031[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106007,(3),Error,null,(2));
var inst_105950 = (r == null);
var state_106007__$1 = state_106007;
if(cljs.core.truth_(inst_105950)){
var statearr_106011_106032 = state_106007__$1;
(statearr_106011_106032[(1)] = (5));

} else {
var statearr_106012_106033 = state_106007__$1;
(statearr_106012_106033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (13))){
var inst_105995 = (state_106007[(2)]);
var state_106007__$1 = state_106007;
var statearr_106013_106034 = state_106007__$1;
(statearr_106013_106034[(2)] = inst_105995);

(statearr_106013_106034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (6))){
var inst_105997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105998 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_105999 = cljs.core.conj.call(null,inst_105998,clause);
var inst_106000 = [null,inst_105999];
var inst_106001 = (new cljs.core.PersistentVector(null,2,(5),inst_105997,inst_106000,null));
var state_106007__$1 = state_106007;
var statearr_106014_106035 = state_106007__$1;
(statearr_106014_106035[(2)] = inst_106001);

(statearr_106014_106035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (3))){
var inst_105946 = (state_106007[(2)]);
var state_106007__$1 = state_106007;
var statearr_106015_106036 = state_106007__$1;
(statearr_106015_106036[(2)] = inst_105946);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106007__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (12))){
var inst_105953 = (state_106007[(7)]);
var inst_105965 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_105966 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_105965);
var inst_105967 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_105953);
var inst_105968 = cljs.core.apply.call(null,cljs.core.concat,inst_105967);
var inst_105969 = cljs.core.set.call(null,inst_105968);
var inst_105970 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_105966);
var inst_105971 = cljs.core.apply.call(null,cljs.core.concat,inst_105970);
var inst_105972 = cljs.core.into.call(null,inst_105969,inst_105971);
var inst_105973 = (function (){var all_wd = inst_105953;
var optional = inst_105966;
var all_wd_vars = inst_105969;
var all_vars = inst_105972;
return (function (p1__105941_SHARP_){
return all_vars.call(null,p1__105941_SHARP_);
});
})();
var inst_105974 = cljs.core.keys.call(null,vars);
var inst_105975 = cljs.core.map.call(null,inst_105973,inst_105974);
var inst_105976 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_105975);
var inst_105977 = cljs.core.set.call(null,inst_105976);
var inst_105978 = (function (){var all_wd = inst_105953;
var optional = inst_105966;
var all_wd_vars = inst_105969;
var all_vars = inst_105972;
var intersecting_vars = inst_105977;
return (function (p1__105942_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__105942_SHARP_);
});
})();
var inst_105979 = cljs.core.map.call(null,inst_105978,inst_105953);
var inst_105980 = cljs.core.apply.call(null,cljs.core.concat,inst_105979);
var inst_105981 = fluree.db.query.analytical.select_from_tuples.call(null,inst_105980,res);
var inst_105982 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_105953,inst_105977,vars);
var inst_105983 = cljs.core.remove.call(null,inst_105977,inst_105972);
var inst_105984 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_105982,inst_105980,inst_105981,inst_105983,inst_105966);
var state_106007__$1 = state_106007;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106007__$1,(14),inst_105984);
} else {
if((state_val_106008 === (2))){
var inst_106005 = (state_106007[(2)]);
var state_106007__$1 = state_106007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106007__$1,inst_106005);
} else {
if((state_val_106008 === (11))){
var inst_105961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105962 = [null,r];
var inst_105963 = (new cljs.core.PersistentVector(null,2,(5),inst_105961,inst_105962,null));
var state_106007__$1 = state_106007;
var statearr_106016_106037 = state_106007__$1;
(statearr_106016_106037[(2)] = inst_105963);

(statearr_106016_106037[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (9))){
var state_106007__$1 = state_106007;
var statearr_106017_106038 = state_106007__$1;
(statearr_106017_106038[(2)] = optional_QMARK_);

(statearr_106017_106038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (5))){
var inst_105952 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_105953 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_105952);
var state_106007__$1 = (function (){var statearr_106018 = state_106007;
(statearr_106018[(7)] = inst_105953);

return statearr_106018;
})();
if(cljs.core.truth_(optional_QMARK_)){
var statearr_106019_106039 = state_106007__$1;
(statearr_106019_106039[(1)] = (8));

} else {
var statearr_106020_106040 = state_106007__$1;
(statearr_106020_106040[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (14))){
var inst_105986 = (state_106007[(2)]);
var inst_105987 = fluree.db.util.async.throw_err.call(null,inst_105986);
var inst_105988 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_105987);
var inst_105989 = cljs.core.count.call(null,inst_105988);
var inst_105990 = fluree.db.query.analytical.add_fuel.call(null,inst_105989,fuel,max_fuel);
var inst_105991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_105992 = [inst_105987,r];
var inst_105993 = (new cljs.core.PersistentVector(null,2,(5),inst_105991,inst_105992,null));
var state_106007__$1 = (function (){var statearr_106021 = state_106007;
(statearr_106021[(8)] = inst_105990);

return statearr_106021;
})();
var statearr_106022_106041 = state_106007__$1;
(statearr_106022_106041[(2)] = inst_105993);

(statearr_106022_106041[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (10))){
var inst_105959 = (state_106007[(2)]);
var state_106007__$1 = state_106007;
if(cljs.core.truth_(inst_105959)){
var statearr_106023_106042 = state_106007__$1;
(statearr_106023_106042[(1)] = (11));

} else {
var statearr_106024_106043 = state_106007__$1;
(statearr_106024_106043[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106008 === (8))){
var inst_105953 = (state_106007[(7)]);
var inst_105955 = cljs.core.empty_QMARK_.call(null,inst_105953);
var inst_105956 = (!(inst_105955));
var state_106007__$1 = state_106007;
var statearr_106025_106044 = state_106007__$1;
(statearr_106025_106044[(2)] = inst_105956);

(statearr_106025_106044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_106026 = [null,null,null,null,null,null,null,null,null];
(statearr_106026[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__);

(statearr_106026[(1)] = (1));

return statearr_106026;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1 = (function (state_106007){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106027){if((e106027 instanceof Object)){
var ex__99978__auto__ = e106027;
var statearr_106028_106045 = state_106007;
(statearr_106028_106045[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106007);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106027;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106046 = state_106007;
state_106007 = G__106046;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__ = function(state_106007){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1.call(this,state_106007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106029 = f__100070__auto__.call(null);
(statearr_106029[(6)] = c__100069__auto__);

return statearr_106029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__106048 = arguments.length;
switch (G__106048) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106139){
var state_val_106140 = (state_106139[(1)]);
if((state_val_106140 === (7))){
var inst_106135 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106141_106183 = state_106139__$1;
(statearr_106141_106183[(2)] = inst_106135);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106139__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (20))){
var inst_106129 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106142_106184 = state_106139__$1;
(statearr_106142_106184[(2)] = inst_106129);

(statearr_106142_106184[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (27))){
var inst_106111 = (state_106139[(2)]);
var inst_106112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106113 = cljs.core.PersistentVector.EMPTY;
var inst_106114 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_106115 = cljs.core.into.call(null,inst_106113,inst_106114);
var inst_106116 = [inst_106111,inst_106115];
var inst_106117 = (new cljs.core.PersistentVector(null,2,(5),inst_106112,inst_106116,null));
var state_106139__$1 = state_106139;
var statearr_106143_106185 = state_106139__$1;
(statearr_106143_106185[(2)] = inst_106117);

(statearr_106143_106185[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (1))){
var state_106139__$1 = state_106139;
var statearr_106144_106186 = state_106139__$1;
(statearr_106144_106186[(2)] = null);

(statearr_106144_106186[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (24))){
var inst_106096 = (state_106139[(7)]);
var inst_106102 = (state_106139[(2)]);
var inst_106103 = fluree.db.util.async.throw_err.call(null,inst_106102);
var state_106139__$1 = (function (){var statearr_106145 = state_106139;
(statearr_106145[(8)] = inst_106103);

return statearr_106145;
})();
if(cljs.core.truth_(inst_106096)){
var statearr_106146_106187 = state_106139__$1;
(statearr_106146_106187[(1)] = (25));

} else {
var statearr_106147_106188 = state_106139__$1;
(statearr_106147_106188[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (4))){
var inst_106053 = (state_106139[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106139,(3),Error,null,(2));
var inst_106053__$1 = cljs.core.first.call(null,clause);
var inst_106054 = cljs.core._EQ_.call(null,"$fdb",inst_106053__$1);
var state_106139__$1 = (function (){var statearr_106148 = state_106139;
(statearr_106148[(9)] = inst_106053__$1);

return statearr_106148;
})();
if(inst_106054){
var statearr_106149_106189 = state_106139__$1;
(statearr_106149_106189[(1)] = (5));

} else {
var statearr_106150_106190 = state_106139__$1;
(statearr_106150_106190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (15))){
var inst_106086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106087 = ["$wd",clause];
var inst_106088 = (new cljs.core.PersistentVector(null,2,(5),inst_106086,inst_106087,null));
var state_106139__$1 = state_106139;
var statearr_106151_106191 = state_106139__$1;
(statearr_106151_106191[(2)] = inst_106088);

(statearr_106151_106191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (21))){
var inst_106094 = (state_106139[(10)]);
var inst_106092 = (state_106139[(11)]);
var inst_106096 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_106092);
var inst_106097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106098 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_106094];
var inst_106099 = (new cljs.core.PersistentVector(null,2,(5),inst_106097,inst_106098,null));
var inst_106100 = cljs.core.get_in.call(null,opts,inst_106099);
var state_106139__$1 = (function (){var statearr_106152 = state_106139;
(statearr_106152[(7)] = inst_106096);

return statearr_106152;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106139__$1,(24),inst_106100);
} else {
if((state_val_106140 === (13))){
var state_106139__$1 = state_106139;
var statearr_106153_106192 = state_106139__$1;
(statearr_106153_106192[(2)] = null);

(statearr_106153_106192[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (22))){
var inst_106053 = (state_106139[(9)]);
var inst_106119 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106053)," is not supported in Fluree"].join('');
var inst_106120 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106121 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_106122 = cljs.core.PersistentHashMap.fromArrays(inst_106120,inst_106121);
var inst_106123 = cljs.core.ex_info.call(null,inst_106119,inst_106122);
var inst_106124 = (function(){throw inst_106123})();
var state_106139__$1 = state_106139;
var statearr_106154_106193 = state_106139__$1;
(statearr_106154_106193[(2)] = inst_106124);

(statearr_106154_106193[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (6))){
var inst_106053 = (state_106139[(9)]);
var inst_106063 = clojure.string.starts_with_QMARK_.call(null,inst_106053,"$fdb");
var state_106139__$1 = state_106139;
if(inst_106063){
var statearr_106155_106194 = state_106139__$1;
(statearr_106155_106194[(1)] = (8));

} else {
var statearr_106156_106195 = state_106139__$1;
(statearr_106156_106195[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (28))){
var inst_106107 = (state_106139[(2)]);
var inst_106108 = fluree.db.util.async.throw_err.call(null,inst_106107);
var state_106139__$1 = state_106139;
var statearr_106157_106196 = state_106139__$1;
(statearr_106157_106196[(2)] = inst_106108);

(statearr_106157_106196[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (25))){
var inst_106103 = (state_106139[(8)]);
var inst_106096 = (state_106139[(7)]);
var inst_106105 = fluree.db.time_travel.as_of_block.call(null,inst_106103,inst_106096);
var state_106139__$1 = state_106139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106139__$1,(28),inst_106105);
} else {
if((state_val_106140 === (17))){
var inst_106131 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106158_106197 = state_106139__$1;
(statearr_106158_106197[(2)] = inst_106131);

(statearr_106158_106197[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (3))){
var inst_106049 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106159_106198 = state_106139__$1;
(statearr_106159_106198[(2)] = inst_106049);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106139__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (12))){
var inst_106070 = (state_106139[(12)]);
var inst_106073 = (function(){throw inst_106070})();
var state_106139__$1 = state_106139;
var statearr_106160_106199 = state_106139__$1;
(statearr_106160_106199[(2)] = inst_106073);

(statearr_106160_106199[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (2))){
var inst_106137 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106139__$1,inst_106137);
} else {
if((state_val_106140 === (23))){
var inst_106126 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106161_106200 = state_106139__$1;
(statearr_106161_106200[(2)] = inst_106126);

(statearr_106161_106200[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (19))){
var state_106139__$1 = state_106139;
var statearr_106162_106201 = state_106139__$1;
(statearr_106162_106201[(2)] = null);

(statearr_106162_106201[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (11))){
var inst_106070 = (state_106139[(12)]);
var inst_106069 = (state_106139[(2)]);
var inst_106070__$1 = fluree.db.util.async.throw_err.call(null,inst_106069);
var inst_106071 = fluree.db.util.core.exception_QMARK_.call(null,inst_106070__$1);
var state_106139__$1 = (function (){var statearr_106163 = state_106139;
(statearr_106163[(12)] = inst_106070__$1);

return statearr_106163;
})();
if(inst_106071){
var statearr_106164_106202 = state_106139__$1;
(statearr_106164_106202[(1)] = (12));

} else {
var statearr_106165_106203 = state_106139__$1;
(statearr_106165_106203[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (9))){
var inst_106053 = (state_106139[(9)]);
var inst_106084 = cljs.core._EQ_.call(null,"$wd",inst_106053);
var state_106139__$1 = state_106139;
if(inst_106084){
var statearr_106166_106204 = state_106139__$1;
(statearr_106166_106204[(1)] = (15));

} else {
var statearr_106167_106205 = state_106139__$1;
(statearr_106167_106205[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (5))){
var inst_106056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106057 = cljs.core.PersistentVector.EMPTY;
var inst_106058 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_106059 = cljs.core.into.call(null,inst_106057,inst_106058);
var inst_106060 = [db,inst_106059];
var inst_106061 = (new cljs.core.PersistentVector(null,2,(5),inst_106056,inst_106060,null));
var state_106139__$1 = state_106139;
var statearr_106168_106206 = state_106139__$1;
(statearr_106168_106206[(2)] = inst_106061);

(statearr_106168_106206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (14))){
var inst_106070 = (state_106139[(12)]);
var inst_106076 = (state_106139[(2)]);
var inst_106077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106078 = cljs.core.PersistentVector.EMPTY;
var inst_106079 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_106080 = cljs.core.into.call(null,inst_106078,inst_106079);
var inst_106081 = [inst_106070,inst_106080];
var inst_106082 = (new cljs.core.PersistentVector(null,2,(5),inst_106077,inst_106081,null));
var state_106139__$1 = (function (){var statearr_106169 = state_106139;
(statearr_106169[(13)] = inst_106076);

return statearr_106169;
})();
var statearr_106170_106207 = state_106139__$1;
(statearr_106170_106207[(2)] = inst_106082);

(statearr_106170_106207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (26))){
var inst_106103 = (state_106139[(8)]);
var state_106139__$1 = state_106139;
var statearr_106171_106208 = state_106139__$1;
(statearr_106171_106208[(2)] = inst_106103);

(statearr_106171_106208[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (16))){
var state_106139__$1 = state_106139;
var statearr_106172_106209 = state_106139__$1;
(statearr_106172_106209[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (10))){
var inst_106133 = (state_106139[(2)]);
var state_106139__$1 = state_106139;
var statearr_106174_106210 = state_106139__$1;
(statearr_106174_106210[(2)] = inst_106133);

(statearr_106174_106210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (18))){
var inst_106094 = (state_106139[(10)]);
var inst_106053 = (state_106139[(9)]);
var inst_106091 = fluree.db.query.analytical.isolate_source_name.call(null,inst_106053);
var inst_106092 = fluree.db.query.analytical.isolate_source_block.call(null,inst_106053);
var inst_106093 = cljs.core.keyword.call(null,inst_106091);
var inst_106094__$1 = cljs.core.get.call(null,prefixes,inst_106093);
var state_106139__$1 = (function (){var statearr_106175 = state_106139;
(statearr_106175[(10)] = inst_106094__$1);

(statearr_106175[(11)] = inst_106092);

return statearr_106175;
})();
if(cljs.core.truth_(inst_106094__$1)){
var statearr_106176_106211 = state_106139__$1;
(statearr_106176_106211[(1)] = (21));

} else {
var statearr_106177_106212 = state_106139__$1;
(statearr_106177_106212[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106140 === (8))){
var inst_106053 = (state_106139[(9)]);
var inst_106065 = cljs.core.subs.call(null,inst_106053,(4));
var inst_106066 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_106065);
var inst_106067 = fluree.db.time_travel.as_of_block.call(null,db,inst_106066);
var state_106139__$1 = state_106139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106139__$1,(11),inst_106067);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__99975__auto__ = null;
var fluree$db$query$analytical$state_machine__99975__auto____0 = (function (){
var statearr_106178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106178[(0)] = fluree$db$query$analytical$state_machine__99975__auto__);

(statearr_106178[(1)] = (1));

return statearr_106178;
});
var fluree$db$query$analytical$state_machine__99975__auto____1 = (function (state_106139){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106179){if((e106179 instanceof Object)){
var ex__99978__auto__ = e106179;
var statearr_106180_106213 = state_106139;
(statearr_106180_106213[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106214 = state_106139;
state_106139 = G__106214;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99975__auto__ = function(state_106139){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99975__auto____1.call(this,state_106139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99975__auto____0;
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99975__auto____1;
return fluree$db$query$analytical$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106181 = f__100070__auto__.call(null);
(statearr_106181[(6)] = c__100069__auto__);

return statearr_106181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__106215){
var vec__106216 = p__106215;
var sub = cljs.core.nth.call(null,vec__106216,(0),null);
var obj = cljs.core.nth.call(null,vec__106216,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__106219_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__106219_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__106223 = subjects;
var vec__106224 = G__106223;
var seq__106225 = cljs.core.seq.call(null,vec__106224);
var first__106226 = cljs.core.first.call(null,seq__106225);
var seq__106225__$1 = cljs.core.next.call(null,seq__106225);
var subject = first__106226;
var r = seq__106225__$1;
var acc = expanded_map;
var G__106223__$1 = G__106223;
var acc__$1 = acc;
while(true){
var vec__106230 = G__106223__$1;
var seq__106231 = cljs.core.seq.call(null,vec__106230);
var first__106232 = cljs.core.first.call(null,seq__106231);
var seq__106231__$1 = cljs.core.next.call(null,seq__106231);
var subject__$1 = first__106232;
var r__$1 = seq__106231__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__106233 = r__$1;
var G__106234 = acc__$2;
G__106223__$1 = G__106233;
acc__$1 = G__106234;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__106223__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__106223__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__106223__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__106223__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__106223__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__106223__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__106230,seq__106231,first__106232,seq__106231__$1,subject__$1,r__$1,acc__$2,G__106223,vec__106224,seq__106225,first__106226,seq__106225__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__106235 = r__$1;
var G__106236 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__106223__$1 = G__106235;
acc__$1 = G__106236;
continue;
} else {
var G__106237 = subjects;
var G__106238 = acc_STAR_;
G__106223__$1 = G__106237;
acc__$1 = G__106238;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__106239_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__106239_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106325){
var state_val_106326 = (state_106325[(1)]);
if((state_val_106326 === (7))){
var inst_106248 = (state_106325[(2)]);
var inst_106249 = recur_map;
var inst_106250 = (1);
var state_106325__$1 = (function (){var statearr_106327 = state_106325;
(statearr_106327[(7)] = inst_106249);

(statearr_106327[(8)] = inst_106248);

(statearr_106327[(9)] = inst_106250);

return statearr_106327;
})();
var statearr_106328_106365 = state_106325__$1;
(statearr_106328_106365[(2)] = null);

(statearr_106328_106365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (20))){
var inst_106296 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
var statearr_106329_106366 = state_106325__$1;
(statearr_106329_106366[(2)] = inst_106296);

(statearr_106329_106366[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (1))){
var state_106325__$1 = state_106325;
var statearr_106330_106367 = state_106325__$1;
(statearr_106330_106367[(2)] = null);

(statearr_106330_106367[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (24))){
var inst_106321 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
var statearr_106331_106368 = state_106325__$1;
(statearr_106331_106368[(2)] = inst_106321);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106325__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106325,(3),Error,null,(2));
var state_106325__$1 = state_106325;
if(cljs.core.truth_(depth)){
var statearr_106332_106369 = state_106325__$1;
(statearr_106332_106369[(1)] = (5));

} else {
var statearr_106333_106370 = state_106325__$1;
(statearr_106333_106370[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (15))){
var inst_106307 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
var statearr_106334_106371 = state_106325__$1;
(statearr_106334_106371[(2)] = inst_106307);

(statearr_106334_106371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (21))){
var inst_106283 = (state_106325[(10)]);
var inst_106275 = (state_106325[(11)]);
var inst_106290 = (state_106325[(2)]);
var inst_106291 = fluree.db.util.async.throw_err.call(null,inst_106290);
var inst_106292 = cljs.core.concat.call(null,inst_106275,inst_106291);
var inst_106275__$1 = inst_106292;
var inst_106276 = inst_106283;
var state_106325__$1 = (function (){var statearr_106335 = state_106325;
(statearr_106335[(11)] = inst_106275__$1);

(statearr_106335[(12)] = inst_106276);

return statearr_106335;
})();
var statearr_106336_106372 = state_106325__$1;
(statearr_106336_106372[(2)] = null);

(statearr_106336_106372[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (13))){
var inst_106249 = (state_106325[(7)]);
var state_106325__$1 = state_106325;
var statearr_106337_106373 = state_106325__$1;
(statearr_106337_106373[(2)] = inst_106249);

(statearr_106337_106373[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (22))){
var inst_106314 = (state_106325[(13)]);
var state_106325__$1 = state_106325;
var statearr_106338_106374 = state_106325__$1;
(statearr_106338_106374[(2)] = inst_106314);

(statearr_106338_106374[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (6))){
var state_106325__$1 = state_106325;
var statearr_106339_106375 = state_106325__$1;
(statearr_106339_106375[(2)] = (100));

(statearr_106339_106375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (17))){
var inst_106249 = (state_106325[(7)]);
var inst_106250 = (state_106325[(9)]);
var inst_106298 = (state_106325[(2)]);
var inst_106299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106300 = [(0),(2)];
var inst_106301 = (new cljs.core.PersistentVector(null,2,(5),inst_106299,inst_106300,null));
var inst_106302 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_106301,inst_106298);
var inst_106303 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_106249,inst_106302);
var inst_106304 = (inst_106250 + (1));
var inst_106249__$1 = inst_106303;
var inst_106250__$1 = inst_106304;
var state_106325__$1 = (function (){var statearr_106340 = state_106325;
(statearr_106340[(7)] = inst_106249__$1);

(statearr_106340[(9)] = inst_106250__$1);

return statearr_106340;
})();
var statearr_106341_106376 = state_106325__$1;
(statearr_106341_106376[(2)] = null);

(statearr_106341_106376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (3))){
var inst_106241 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
var statearr_106342_106377 = state_106325__$1;
(statearr_106342_106377[(2)] = inst_106241);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106325__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (12))){
var inst_106309 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
var statearr_106343_106378 = state_106325__$1;
(statearr_106343_106378[(2)] = inst_106309);

(statearr_106343_106378[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (2))){
var inst_106323 = (state_106325[(2)]);
var state_106325__$1 = state_106325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106325__$1,inst_106323);
} else {
if((state_val_106326 === (23))){
var inst_106248 = (state_106325[(8)]);
var inst_106312 = (state_106325[(14)]);
var inst_106313 = (state_106325[(15)]);
var inst_106314 = (state_106325[(13)]);
var inst_106317 = (function (){var max_depth = inst_106248;
var recur_map__$1 = inst_106313;
var subjects = inst_106312;
var tuples = inst_106314;
return (function (p1__106240_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__106240_SHARP_)],null));
});
})();
var inst_106318 = cljs.core.map.call(null,inst_106317,inst_106314);
var inst_106319 = cljs.core.distinct.call(null,inst_106318);
var state_106325__$1 = state_106325;
var statearr_106344_106379 = state_106325__$1;
(statearr_106344_106379[(2)] = inst_106319);

(statearr_106344_106379[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (19))){
var inst_106275 = (state_106325[(11)]);
var state_106325__$1 = state_106325;
var statearr_106345_106380 = state_106325__$1;
(statearr_106345_106380[(2)] = inst_106275);

(statearr_106345_106380[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (11))){
var inst_106249 = (state_106325[(7)]);
var inst_106260 = (state_106325[(16)]);
var inst_106255 = cljs.core.vals.call(null,inst_106249);
var inst_106256 = cljs.core.flatten.call(null,inst_106255);
var inst_106257 = cljs.core.set.call(null,inst_106256);
var inst_106258 = cljs.core.keys.call(null,inst_106249);
var inst_106259 = cljs.core.set.call(null,inst_106258);
var inst_106260__$1 = clojure.set.difference.call(null,inst_106257,inst_106259);
var inst_106261 = cljs.core.empty_QMARK_.call(null,inst_106260__$1);
var state_106325__$1 = (function (){var statearr_106346 = state_106325;
(statearr_106346[(16)] = inst_106260__$1);

return statearr_106346;
})();
if(inst_106261){
var statearr_106347_106381 = state_106325__$1;
(statearr_106347_106381[(1)] = (13));

} else {
var statearr_106348_106382 = state_106325__$1;
(statearr_106348_106382[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (9))){
var inst_106312 = (state_106325[(14)]);
var inst_106313 = (state_106325[(15)]);
var inst_106311 = (state_106325[(2)]);
var inst_106312__$1 = cljs.core.keys.call(null,inst_106311);
var inst_106313__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_106312__$1,inst_106311);
var inst_106314 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_106312__$1,inst_106313__$1);
var state_106325__$1 = (function (){var statearr_106349 = state_106325;
(statearr_106349[(14)] = inst_106312__$1);

(statearr_106349[(15)] = inst_106313__$1);

(statearr_106349[(13)] = inst_106314);

return statearr_106349;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_106350_106383 = state_106325__$1;
(statearr_106350_106383[(1)] = (22));

} else {
var statearr_106351_106384 = state_106325__$1;
(statearr_106351_106384[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (5))){
var state_106325__$1 = state_106325;
var statearr_106352_106385 = state_106325__$1;
(statearr_106352_106385[(2)] = depth);

(statearr_106352_106385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (14))){
var inst_106260 = (state_106325[(16)]);
var inst_106271 = cljs.core.PersistentVector.EMPTY;
var inst_106272 = cljs.core.seq.call(null,inst_106260);
var inst_106273 = cljs.core.first.call(null,inst_106272);
var inst_106274 = cljs.core.next.call(null,inst_106272);
var inst_106275 = inst_106271;
var inst_106276 = inst_106260;
var state_106325__$1 = (function (){var statearr_106353 = state_106325;
(statearr_106353[(11)] = inst_106275);

(statearr_106353[(12)] = inst_106276);

(statearr_106353[(17)] = inst_106274);

(statearr_106353[(18)] = inst_106273);

return statearr_106353;
})();
var statearr_106354_106386 = state_106325__$1;
(statearr_106354_106386[(2)] = null);

(statearr_106354_106386[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (16))){
var inst_106276 = (state_106325[(12)]);
var inst_106282 = (state_106325[(19)]);
var inst_106281 = cljs.core.seq.call(null,inst_106276);
var inst_106282__$1 = cljs.core.first.call(null,inst_106281);
var inst_106283 = cljs.core.next.call(null,inst_106281);
var state_106325__$1 = (function (){var statearr_106355 = state_106325;
(statearr_106355[(10)] = inst_106283);

(statearr_106355[(19)] = inst_106282__$1);

return statearr_106355;
})();
if(cljs.core.truth_(inst_106282__$1)){
var statearr_106356_106387 = state_106325__$1;
(statearr_106356_106387[(1)] = (18));

} else {
var statearr_106357_106388 = state_106325__$1;
(statearr_106357_106388[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (10))){
var inst_106249 = (state_106325[(7)]);
var state_106325__$1 = state_106325;
var statearr_106358_106389 = state_106325__$1;
(statearr_106358_106389[(2)] = inst_106249);

(statearr_106358_106389[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106326 === (18))){
var inst_106282 = (state_106325[(19)]);
var inst_106285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106286 = [inst_106282,predicate];
var inst_106287 = (new cljs.core.PersistentVector(null,2,(5),inst_106285,inst_106286,null));
var inst_106288 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_106287);
var state_106325__$1 = state_106325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106325__$1,(21),inst_106288);
} else {
if((state_val_106326 === (8))){
var inst_106248 = (state_106325[(8)]);
var inst_106250 = (state_106325[(9)]);
var inst_106252 = (inst_106250 >= inst_106248);
var state_106325__$1 = state_106325;
if(cljs.core.truth_(inst_106252)){
var statearr_106359_106390 = state_106325__$1;
(statearr_106359_106390[(1)] = (10));

} else {
var statearr_106360_106391 = state_106325__$1;
(statearr_106360_106391[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0 = (function (){
var statearr_106361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106361[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__);

(statearr_106361[(1)] = (1));

return statearr_106361;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1 = (function (state_106325){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106362){if((e106362 instanceof Object)){
var ex__99978__auto__ = e106362;
var statearr_106363_106392 = state_106325;
(statearr_106363_106392[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106393 = state_106325;
state_106325 = G__106393;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__ = function(state_106325){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1.call(this,state_106325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106364 = f__100070__auto__.call(null);
(statearr_106364[(6)] = c__100069__auto__);

return statearr_106364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__106394,clause,fuel,max_fuel){
var map__106395 = p__106394;
var map__106395__$1 = (((((!((map__106395 == null))))?(((((map__106395.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106395.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106395):map__106395);
var res = map__106395__$1;
var headers = cljs.core.get.call(null,map__106395__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__106395__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__106395__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106524){
var state_val_106525 = (state_106524[(1)]);
if((state_val_106525 === (7))){
var inst_106421 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
if(cljs.core.truth_(inst_106421)){
var statearr_106526_106585 = state_106524__$1;
(statearr_106526_106585[(1)] = (11));

} else {
var statearr_106527_106586 = state_106524__$1;
(statearr_106527_106586[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (20))){
var inst_106428 = (state_106524[(7)]);
var inst_106516 = (state_106524[(2)]);
var inst_106517 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_106518 = cljs.core.keys.call(null,inst_106428);
var inst_106519 = [inst_106518,vars,inst_106516];
var inst_106520 = cljs.core.PersistentHashMap.fromArrays(inst_106517,inst_106519);
var state_106524__$1 = state_106524;
var statearr_106528_106587 = state_106524__$1;
(statearr_106528_106587[(2)] = inst_106520);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106524__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (27))){
var inst_106457 = (state_106524[(8)]);
var inst_106487 = cljs.core.PersistentHashMap.EMPTY;
var inst_106488 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_106487,inst_106457);
var state_106524__$1 = state_106524;
var statearr_106529_106588 = state_106524__$1;
(statearr_106529_106588[(2)] = inst_106488);

(statearr_106529_106588[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (1))){
var state_106524__$1 = state_106524;
var statearr_106530_106589 = state_106524__$1;
(statearr_106530_106589[(2)] = null);

(statearr_106530_106589[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (24))){
var state_106524__$1 = state_106524;
var statearr_106531_106590 = state_106524__$1;
(statearr_106531_106590[(2)] = null);

(statearr_106531_106590[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (4))){
var inst_106405 = (state_106524[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106524,(3),Error,null,(2));
var inst_106405__$1 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_106407 = (inst_106405__$1 == null);
var inst_106408 = cljs.core.not.call(null,inst_106407);
var state_106524__$1 = (function (){var statearr_106532 = state_106524;
(statearr_106532[(9)] = inst_106405__$1);

return statearr_106532;
})();
if(inst_106408){
var statearr_106533_106591 = state_106524__$1;
(statearr_106533_106591[(1)] = (5));

} else {
var statearr_106534_106592 = state_106524__$1;
(statearr_106534_106592[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (15))){
var inst_106431 = (state_106524[(10)]);
var state_106524__$1 = state_106524;
var statearr_106535_106593 = state_106524__$1;
(statearr_106535_106593[(2)] = inst_106431);

(statearr_106535_106593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (21))){
var inst_106441 = (state_106524[(11)]);
var inst_106465 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106441)].join('');
var inst_106466 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106467 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_106468 = cljs.core.PersistentHashMap.fromArrays(inst_106466,inst_106467);
var inst_106469 = cljs.core.ex_info.call(null,inst_106465,inst_106468);
var inst_106470 = (function(){throw inst_106469})();
var state_106524__$1 = state_106524;
var statearr_106536_106594 = state_106524__$1;
(statearr_106536_106594[(2)] = inst_106470);

(statearr_106536_106594[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (31))){
var inst_106459 = (state_106524[(12)]);
var inst_106496 = cljs.core.coll_QMARK_.call(null,inst_106459);
var state_106524__$1 = state_106524;
if(inst_106496){
var statearr_106537_106595 = state_106524__$1;
(statearr_106537_106595[(1)] = (33));

} else {
var statearr_106538_106596 = state_106524__$1;
(statearr_106538_106596[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (32))){
var inst_106507 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
var statearr_106539_106597 = state_106524__$1;
(statearr_106539_106597[(2)] = inst_106507);

(statearr_106539_106597[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (33))){
var inst_106453 = (state_106524[(13)]);
var inst_106457 = (state_106524[(8)]);
var inst_106498 = cljs.core.PersistentHashMap.EMPTY;
var inst_106499 = cljs.core.first.call(null,inst_106453);
var inst_106500 = cljs.core.first.call(null,inst_106499);
var inst_106501 = cljs.core.flatten.call(null,inst_106457);
var inst_106502 = cljs.core.assoc.call(null,inst_106498,inst_106500,inst_106501);
var state_106524__$1 = state_106524;
var statearr_106540_106598 = state_106524__$1;
(statearr_106540_106598[(2)] = inst_106502);

(statearr_106540_106598[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (13))){
var inst_106443 = (state_106524[(14)]);
var inst_106431 = (state_106524[(10)]);
var inst_106428 = (state_106524[(7)]);
var inst_106432 = (state_106524[(15)]);
var inst_106426 = (state_106524[(2)]);
var inst_106427 = cljs.core.get.call(null,inst_106426,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_106428__$1 = cljs.core.get.call(null,inst_106426,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_106429 = cljs.core.get.call(null,inst_106426,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_106430 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_106431__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_106429);
var inst_106432__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_106429);
var inst_106434 = (function (){var map__106401 = inst_106426;
var search = inst_106427;
var rel = inst_106428__$1;
var opts = inst_106429;
var common_keys = inst_106430;
var object_fn = inst_106431__$1;
var recur_depth = inst_106432__$1;
return (function (p__106433,common_key){
var vec__106541 = p__106433;
var acc = cljs.core.nth.call(null,vec__106541,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__106541,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__106544 = cljs.core._EQ_;
var expr__106545 = idx_of;
if(cljs.core.truth_(pred__106544.call(null,(0),expr__106545))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__106544.call(null,(1),expr__106545))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__106544.call(null,(2),expr__106545))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__106545)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_106435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106436 = cljs.core.PersistentHashMap.EMPTY;
var inst_106437 = [inst_106436,inst_106427];
var inst_106438 = (new cljs.core.PersistentVector(null,2,(5),inst_106435,inst_106437,null));
var inst_106439 = cljs.core.reduce.call(null,inst_106434,inst_106438,inst_106430);
var inst_106440 = cljs.core.nth.call(null,inst_106439,(0),null);
var inst_106441 = cljs.core.nth.call(null,inst_106439,(1),null);
var inst_106442 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_106443__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_106440);
var state_106524__$1 = (function (){var statearr_106547 = state_106524;
(statearr_106547[(14)] = inst_106443__$1);

(statearr_106547[(11)] = inst_106441);

(statearr_106547[(10)] = inst_106431__$1);

(statearr_106547[(7)] = inst_106428__$1);

(statearr_106547[(16)] = inst_106442);

(statearr_106547[(15)] = inst_106432__$1);

return statearr_106547;
})();
if(cljs.core.truth_(inst_106443__$1)){
var statearr_106548_106599 = state_106524__$1;
(statearr_106548_106599[(1)] = (14));

} else {
var statearr_106549_106600 = state_106524__$1;
(statearr_106549_106600[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (22))){
var state_106524__$1 = state_106524;
var statearr_106550_106601 = state_106524__$1;
(statearr_106550_106601[(2)] = null);

(statearr_106550_106601[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (36))){
var inst_106512 = (state_106524[(2)]);
var inst_106513 = fluree.db.util.async.throw_err.call(null,inst_106512);
var state_106524__$1 = state_106524;
var statearr_106551_106602 = state_106524__$1;
(statearr_106551_106602[(2)] = inst_106513);

(statearr_106551_106602[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (29))){
var inst_106462 = (state_106524[(17)]);
var inst_106461 = (state_106524[(18)]);
var inst_106432 = (state_106524[(15)]);
var inst_106509 = (state_106524[(2)]);
var inst_106510 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_106462,inst_106509,inst_106432,inst_106461);
var state_106524__$1 = state_106524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106524__$1,(36),inst_106510);
} else {
if((state_val_106525 === (6))){
var state_106524__$1 = state_106524;
var statearr_106552_106603 = state_106524__$1;
(statearr_106552_106603[(2)] = false);

(statearr_106552_106603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (28))){
var inst_106459 = (state_106524[(12)]);
var inst_106490 = typeof inst_106459 === 'number';
var state_106524__$1 = state_106524;
if(cljs.core.truth_(inst_106490)){
var statearr_106553_106604 = state_106524__$1;
(statearr_106553_106604[(1)] = (30));

} else {
var statearr_106554_106605 = state_106524__$1;
(statearr_106554_106605[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (25))){
var inst_106441 = (state_106524[(11)]);
var inst_106478 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106441)].join('');
var inst_106479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106480 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_106481 = cljs.core.PersistentHashMap.fromArrays(inst_106479,inst_106480);
var inst_106482 = cljs.core.ex_info.call(null,inst_106478,inst_106481);
var inst_106483 = (function(){throw inst_106482})();
var state_106524__$1 = state_106524;
var statearr_106555_106606 = state_106524__$1;
(statearr_106555_106606[(2)] = inst_106483);

(statearr_106555_106606[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (34))){
var state_106524__$1 = state_106524;
var statearr_106556_106607 = state_106524__$1;
(statearr_106556_106607[(2)] = null);

(statearr_106556_106607[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (17))){
var inst_106453 = (state_106524[(13)]);
var inst_106428 = (state_106524[(7)]);
var inst_106432 = (state_106524[(15)]);
var inst_106452 = (state_106524[(2)]);
var inst_106453__$1 = fluree.db.util.async.throw_err.call(null,inst_106452);
var inst_106454 = cljs.core.count.call(null,inst_106453__$1);
var inst_106455 = fluree.db.query.analytical.add_fuel.call(null,inst_106454,fuel,max_fuel);
var inst_106456 = cljs.core.vals.call(null,inst_106428);
var inst_106457 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_106456,inst_106453__$1);
var state_106524__$1 = (function (){var statearr_106557 = state_106524;
(statearr_106557[(13)] = inst_106453__$1);

(statearr_106557[(19)] = inst_106455);

(statearr_106557[(8)] = inst_106457);

return statearr_106557;
})();
if(cljs.core.truth_(inst_106432)){
var statearr_106558_106608 = state_106524__$1;
(statearr_106558_106608[(1)] = (18));

} else {
var statearr_106559_106609 = state_106524__$1;
(statearr_106559_106609[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (3))){
var inst_106397 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
var statearr_106560_106610 = state_106524__$1;
(statearr_106560_106610[(2)] = inst_106397);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106524__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (12))){
var inst_106405 = (state_106524[(9)]);
var state_106524__$1 = state_106524;
var statearr_106561_106611 = state_106524__$1;
(statearr_106561_106611[(2)] = inst_106405);

(statearr_106561_106611[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (2))){
var inst_106522 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106524__$1,inst_106522);
} else {
if((state_val_106525 === (23))){
var inst_106473 = (state_106524[(2)]);
var inst_106474 = cljs.core.nth.call(null,clause,(2));
var inst_106475 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_106474);
var state_106524__$1 = (function (){var statearr_106562 = state_106524;
(statearr_106562[(20)] = inst_106473);

return statearr_106562;
})();
if(cljs.core.truth_(inst_106475)){
var statearr_106563_106612 = state_106524__$1;
(statearr_106563_106612[(1)] = (24));

} else {
var statearr_106564_106613 = state_106524__$1;
(statearr_106564_106613[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (35))){
var inst_106505 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
var statearr_106565_106614 = state_106524__$1;
(statearr_106565_106614[(2)] = inst_106505);

(statearr_106565_106614[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (19))){
var inst_106457 = (state_106524[(8)]);
var state_106524__$1 = state_106524;
var statearr_106566_106615 = state_106524__$1;
(statearr_106566_106615[(2)] = inst_106457);

(statearr_106566_106615[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (11))){
var inst_106405 = (state_106524[(9)]);
var inst_106423 = cljs.core.apply.call(null,cljs.core.hash_map,inst_106405);
var state_106524__$1 = state_106524;
var statearr_106567_106616 = state_106524__$1;
(statearr_106567_106616[(2)] = inst_106423);

(statearr_106567_106616[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (9))){
var state_106524__$1 = state_106524;
var statearr_106568_106617 = state_106524__$1;
(statearr_106568_106617[(2)] = false);

(statearr_106568_106617[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (5))){
var inst_106405 = (state_106524[(9)]);
var inst_106410 = inst_106405.cljs$lang$protocol_mask$partition0$;
var inst_106411 = (inst_106410 & (64));
var inst_106412 = inst_106405.cljs$core$ISeq$;
var inst_106413 = (cljs.core.PROTOCOL_SENTINEL === inst_106412);
var inst_106414 = ((inst_106411) || (inst_106413));
var state_106524__$1 = state_106524;
if(cljs.core.truth_(inst_106414)){
var statearr_106569_106618 = state_106524__$1;
(statearr_106569_106618[(1)] = (8));

} else {
var statearr_106570_106619 = state_106524__$1;
(statearr_106570_106619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (14))){
var inst_106443 = (state_106524[(14)]);
var state_106524__$1 = state_106524;
var statearr_106571_106620 = state_106524__$1;
(statearr_106571_106620[(2)] = inst_106443);

(statearr_106571_106620[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (26))){
var inst_106461 = (state_106524[(18)]);
var inst_106485 = (state_106524[(2)]);
var state_106524__$1 = (function (){var statearr_106572 = state_106524;
(statearr_106572[(21)] = inst_106485);

return statearr_106572;
})();
if(cljs.core.truth_(inst_106461)){
var statearr_106573_106621 = state_106524__$1;
(statearr_106573_106621[(1)] = (27));

} else {
var statearr_106574_106622 = state_106524__$1;
(statearr_106574_106622[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (16))){
var inst_106441 = (state_106524[(11)]);
var inst_106442 = (state_106524[(16)]);
var inst_106447 = (state_106524[(2)]);
var inst_106448 = [inst_106447];
var inst_106449 = cljs.core.PersistentHashMap.fromArrays(inst_106442,inst_106448);
var inst_106450 = fluree.db.query.range.search.call(null,db,inst_106441,inst_106449);
var state_106524__$1 = state_106524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106524__$1,(17),inst_106450);
} else {
if((state_val_106525 === (30))){
var inst_106457 = (state_106524[(8)]);
var inst_106459 = (state_106524[(12)]);
var inst_106492 = cljs.core.PersistentHashMap.EMPTY;
var inst_106493 = cljs.core.flatten.call(null,inst_106457);
var inst_106494 = cljs.core.assoc.call(null,inst_106492,inst_106459,inst_106493);
var state_106524__$1 = state_106524;
var statearr_106575_106623 = state_106524__$1;
(statearr_106575_106623[(2)] = inst_106494);

(statearr_106575_106623[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (10))){
var inst_106418 = (state_106524[(2)]);
var state_106524__$1 = state_106524;
var statearr_106576_106624 = state_106524__$1;
(statearr_106576_106624[(2)] = inst_106418);

(statearr_106576_106624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (18))){
var inst_106441 = (state_106524[(11)]);
var inst_106462 = (state_106524[(17)]);
var inst_106459 = cljs.core.first.call(null,inst_106441);
var inst_106460 = cljs.core.first.call(null,clause);
var inst_106461 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_106460);
var inst_106462__$1 = cljs.core.nth.call(null,inst_106441,(1));
var inst_106463 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_106462__$1);
var state_106524__$1 = (function (){var statearr_106577 = state_106524;
(statearr_106577[(17)] = inst_106462__$1);

(statearr_106577[(18)] = inst_106461);

(statearr_106577[(12)] = inst_106459);

return statearr_106577;
})();
if(cljs.core.truth_(inst_106463)){
var statearr_106578_106625 = state_106524__$1;
(statearr_106578_106625[(1)] = (21));

} else {
var statearr_106579_106626 = state_106524__$1;
(statearr_106579_106626[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106525 === (8))){
var state_106524__$1 = state_106524;
var statearr_106580_106627 = state_106524__$1;
(statearr_106580_106627[(2)] = true);

(statearr_106580_106627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_106581 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106581[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__);

(statearr_106581[(1)] = (1));

return statearr_106581;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1 = (function (state_106524){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106582){if((e106582 instanceof Object)){
var ex__99978__auto__ = e106582;
var statearr_106583_106628 = state_106524;
(statearr_106583_106628[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106582;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106629 = state_106524;
state_106524 = G__106629;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__ = function(state_106524){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1.call(this,state_106524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106584 = f__100070__auto__.call(null);
(statearr_106584[(6)] = c__100069__auto__);

return statearr_106584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106725){
var state_val_106726 = (state_106725[(1)]);
if((state_val_106726 === (7))){
var inst_106643 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
if(cljs.core.truth_(inst_106643)){
var statearr_106727_106760 = state_106725__$1;
(statearr_106727_106760[(1)] = (8));

} else {
var statearr_106728_106761 = state_106725__$1;
(statearr_106728_106761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (20))){
var inst_106690 = (state_106725[(7)]);
var state_106725__$1 = state_106725;
var statearr_106729_106762 = state_106725__$1;
(statearr_106729_106762[(2)] = inst_106690);

(statearr_106729_106762[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (1))){
var state_106725__$1 = state_106725;
var statearr_106730_106763 = state_106725__$1;
(statearr_106730_106763[(2)] = null);

(statearr_106730_106763[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (4))){
var inst_106637 = (state_106725[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_106725,(3),Error,null,(2));
var inst_106636 = cljs.core.first.call(null,clause);
var inst_106637__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_106636);
var inst_106638 = cljs.core.last.call(null,clause);
var inst_106639 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_106638);
var state_106725__$1 = (function (){var statearr_106731 = state_106725;
(statearr_106731[(9)] = inst_106639);

(statearr_106731[(8)] = inst_106637__$1);

return statearr_106731;
})();
if(cljs.core.truth_(inst_106637__$1)){
var statearr_106732_106764 = state_106725__$1;
(statearr_106732_106764[(1)] = (5));

} else {
var statearr_106733_106765 = state_106725__$1;
(statearr_106733_106765[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (15))){
var inst_106639 = (state_106725[(9)]);
var inst_106637 = (state_106725[(8)]);
var inst_106670 = cljs.core.last.call(null,clause);
var inst_106671 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_106670);
var inst_106672 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_106673 = cljs.core.get.call(null,inst_106672,inst_106671);
var inst_106674 = fluree.db.flake.min_subject_id.call(null,inst_106671);
var inst_106675 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_106676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106677 = [inst_106637];
var inst_106678 = (new cljs.core.PersistentVector(null,1,(5),inst_106676,inst_106677,null));
var inst_106679 = (function (){var subject_var = inst_106637;
var object_var = inst_106639;
var cid = inst_106671;
var max_sid = inst_106673;
var min_sid = inst_106674;
return (function (p1__106631_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__106631_SHARP_);
});
})();
var inst_106680 = (inst_106673 + (1));
var inst_106681 = cljs.core.range.call(null,inst_106674,inst_106680);
var inst_106682 = cljs.core.map.call(null,inst_106679,inst_106681);
var inst_106683 = cljs.core.PersistentHashMap.EMPTY;
var inst_106684 = [inst_106678,inst_106682,inst_106683];
var inst_106685 = cljs.core.PersistentHashMap.fromArrays(inst_106675,inst_106684);
var state_106725__$1 = state_106725;
var statearr_106734_106766 = state_106725__$1;
(statearr_106734_106766[(2)] = inst_106685);

(statearr_106734_106766[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (21))){
var inst_106690 = (state_106725[(7)]);
var inst_106694 = fluree.db.dbproto._subid.call(null,db,inst_106690);
var state_106725__$1 = state_106725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106725__$1,(23),inst_106694);
} else {
if((state_val_106726 === (13))){
var inst_106719 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
var statearr_106735_106767 = state_106725__$1;
(statearr_106735_106767[(2)] = inst_106719);

(statearr_106735_106767[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (22))){
var inst_106639 = (state_106725[(9)]);
var inst_106699 = (state_106725[(2)]);
var inst_106700 = fluree.db.flake.sid__GT_cid.call(null,inst_106699);
var inst_106701 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_106700);
var inst_106702 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_106703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106704 = [inst_106639];
var inst_106705 = (new cljs.core.PersistentVector(null,1,(5),inst_106703,inst_106704,null));
var inst_106706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106708 = [inst_106701];
var inst_106709 = (new cljs.core.PersistentVector(null,1,(5),inst_106707,inst_106708,null));
var inst_106710 = [inst_106709];
var inst_106711 = (new cljs.core.PersistentVector(null,1,(5),inst_106706,inst_106710,null));
var inst_106712 = cljs.core.PersistentHashMap.EMPTY;
var inst_106713 = [inst_106705,inst_106711,inst_106712];
var inst_106714 = cljs.core.PersistentHashMap.fromArrays(inst_106702,inst_106713);
var state_106725__$1 = state_106725;
var statearr_106736_106768 = state_106725__$1;
(statearr_106736_106768[(2)] = inst_106714);

(statearr_106736_106768[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (6))){
var inst_106637 = (state_106725[(8)]);
var state_106725__$1 = state_106725;
var statearr_106737_106769 = state_106725__$1;
(statearr_106737_106769[(2)] = inst_106637);

(statearr_106737_106769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (17))){
var inst_106690 = (state_106725[(7)]);
var inst_106690__$1 = cljs.core.first.call(null,clause);
var inst_106691 = typeof inst_106690__$1 === 'number';
var state_106725__$1 = (function (){var statearr_106738 = state_106725;
(statearr_106738[(7)] = inst_106690__$1);

return statearr_106738;
})();
if(cljs.core.truth_(inst_106691)){
var statearr_106739_106770 = state_106725__$1;
(statearr_106739_106770[(1)] = (20));

} else {
var statearr_106740_106771 = state_106725__$1;
(statearr_106740_106771[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (3))){
var inst_106632 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
var statearr_106741_106772 = state_106725__$1;
(statearr_106741_106772[(2)] = inst_106632);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106725__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (12))){
var inst_106639 = (state_106725[(9)]);
var state_106725__$1 = state_106725;
if(cljs.core.truth_(inst_106639)){
var statearr_106742_106773 = state_106725__$1;
(statearr_106742_106773[(1)] = (17));

} else {
var statearr_106743_106774 = state_106725__$1;
(statearr_106743_106774[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (2))){
var inst_106723 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106725__$1,inst_106723);
} else {
if((state_val_106726 === (23))){
var inst_106696 = (state_106725[(2)]);
var inst_106697 = fluree.db.util.async.throw_err.call(null,inst_106696);
var state_106725__$1 = state_106725;
var statearr_106744_106775 = state_106725__$1;
(statearr_106744_106775[(2)] = inst_106697);

(statearr_106744_106775[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (19))){
var inst_106717 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
var statearr_106745_106776 = state_106725__$1;
(statearr_106745_106776[(2)] = inst_106717);

(statearr_106745_106776[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (11))){
var inst_106652 = ["_tx",null,"_block",null];
var inst_106653 = (new cljs.core.PersistentArrayMap(null,2,inst_106652,null));
var inst_106654 = (new cljs.core.PersistentHashSet(null,inst_106653,null));
var inst_106655 = cljs.core.last.call(null,clause);
var inst_106656 = inst_106654.call(null,inst_106655);
var state_106725__$1 = state_106725;
if(cljs.core.truth_(inst_106656)){
var statearr_106746_106777 = state_106725__$1;
(statearr_106746_106777[(1)] = (14));

} else {
var statearr_106747_106778 = state_106725__$1;
(statearr_106747_106778[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (9))){
var inst_106637 = (state_106725[(8)]);
var state_106725__$1 = state_106725;
if(cljs.core.truth_(inst_106637)){
var statearr_106748_106779 = state_106725__$1;
(statearr_106748_106779[(1)] = (11));

} else {
var statearr_106749_106780 = state_106725__$1;
(statearr_106749_106780[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (5))){
var inst_106639 = (state_106725[(9)]);
var state_106725__$1 = state_106725;
var statearr_106750_106781 = state_106725__$1;
(statearr_106750_106781[(2)] = inst_106639);

(statearr_106750_106781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (14))){
var inst_106639 = (state_106725[(9)]);
var inst_106637 = (state_106725[(8)]);
var inst_106658 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_106659 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_106660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106661 = [inst_106637];
var inst_106662 = (new cljs.core.PersistentVector(null,1,(5),inst_106660,inst_106661,null));
var inst_106663 = (function (){var subject_var = inst_106637;
var object_var = inst_106639;
var min_sid = inst_106658;
var max_sid = (0);
return (function (p1__106630_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__106630_SHARP_);
});
})();
var inst_106664 = cljs.core.range.call(null,inst_106658,(0));
var inst_106665 = cljs.core.map.call(null,inst_106663,inst_106664);
var inst_106666 = cljs.core.PersistentHashMap.EMPTY;
var inst_106667 = [inst_106662,inst_106665,inst_106666];
var inst_106668 = cljs.core.PersistentHashMap.fromArrays(inst_106659,inst_106667);
var state_106725__$1 = state_106725;
var statearr_106751_106782 = state_106725__$1;
(statearr_106751_106782[(2)] = inst_106668);

(statearr_106751_106782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (16))){
var inst_106687 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
var statearr_106752_106783 = state_106725__$1;
(statearr_106752_106783[(2)] = inst_106687);

(statearr_106752_106783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (10))){
var inst_106721 = (state_106725[(2)]);
var state_106725__$1 = state_106725;
var statearr_106753_106784 = state_106725__$1;
(statearr_106753_106784[(2)] = inst_106721);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106725__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (18))){
var state_106725__$1 = state_106725;
var statearr_106754_106785 = state_106725__$1;
(statearr_106754_106785[(2)] = null);

(statearr_106754_106785[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106726 === (8))){
var inst_106645 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_106646 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_106647 = cljs.core.PersistentHashMap.fromArrays(inst_106645,inst_106646);
var inst_106648 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_106647);
var inst_106649 = (function(){throw inst_106648})();
var state_106725__$1 = state_106725;
var statearr_106755_106786 = state_106725__$1;
(statearr_106755_106786[(2)] = inst_106649);

(statearr_106755_106786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_106756 = [null,null,null,null,null,null,null,null,null,null];
(statearr_106756[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__);

(statearr_106756[(1)] = (1));

return statearr_106756;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1 = (function (state_106725){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106757){if((e106757 instanceof Object)){
var ex__99978__auto__ = e106757;
var statearr_106758_106787 = state_106725;
(statearr_106758_106787[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106757;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106788 = state_106725;
state_106725 = G__106788;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__ = function(state_106725){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1.call(this,state_106725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106759 = f__100070__auto__.call(null);
(statearr_106759[(6)] = c__100069__auto__);

return statearr_106759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__106794 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__106794 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__106794;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__106795(s__106796){
return (new cljs.core.LazySeq(null,(function (){
var s__106796__$1 = s__106796;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__106796__$1);
if(temp__5735__auto__){
var s__106796__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__106796__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__106796__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__106798 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__106797 = (0);
while(true){
if((i__106797 < size__4528__auto__)){
var x = cljs.core._nth.call(null,c__4527__auto__,i__106797);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__106798,(delta * delta));

var G__106799 = (i__106797 + (1));
i__106797 = G__106799;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__106798),fluree$db$query$analytical$variance_$_iter__106795.call(null,cljs.core.chunk_rest.call(null,s__106796__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__106798),null);
}
} else {
var x = cljs.core.first.call(null,s__106796__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__106795.call(null,cljs.core.rest.call(null,s__106796__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__106800 = null;
var G__106800__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__106800__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__106800 = function(n,coll){
switch(arguments.length){
case 1:
return G__106800__1.call(this,n);
case 2:
return G__106800__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106800.cljs$core$IFn$_invoke$arity$1 = G__106800__1;
G__106800.cljs$core$IFn$_invoke$arity$2 = G__106800__2;
return G__106800;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__106801 = null;
var G__106801__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__106801__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__106801 = function(n,coll){
switch(arguments.length){
case 1:
return G__106801__1.call(this,n);
case 2:
return G__106801__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106801.cljs$core$IFn$_invoke$arity$1 = G__106801__1;
G__106801.cljs$core$IFn$_invoke$arity$2 = G__106801__2;
return G__106801;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__106802 = null;
var G__106802__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__106802__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__106802 = function(n,coll){
switch(arguments.length){
case 1:
return G__106802__1.call(this,n);
case 2:
return G__106802__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__106802.cljs$core$IFn$_invoke$arity$1 = G__106802__1;
G__106802.cljs$core$IFn$_invoke$arity$2 = G__106802__2;
return G__106802;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__106803 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__106803,(0),null);
var arg = cljs.core.nth.call(null,vec__106803,(1),null);
var var$ = cljs.core.nth.call(null,vec__106803,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__106806 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__106806,(0),null);
var variable = cljs.core.nth.call(null,vec__106806,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__106809 = agg;
var map__106809__$1 = (((((!((map__106809 == null))))?(((((map__106809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106809.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106809):map__106809);
var variable = cljs.core.get.call(null,map__106809__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__106809__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__106809__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__106812 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__106812,(0),null);
var agg_result = cljs.core.nth.call(null,vec__106812,(1),null);
var map__106815 = res__$1;
var map__106815__$1 = (((((!((map__106815 == null))))?(((((map__106815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106815.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106815):map__106815);
var headers = cljs.core.get.call(null,map__106815__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__106815__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__106811_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__106811_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__106817_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__106817_SHARP_);
}),a_idxs);
return cljs.core.reduce.call(null,(function (acc,b_tuple){
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__106818_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__106818_SHARP_);
}),b_idxs))){
return cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__106819_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__106819_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__106820_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__106820_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__106823,row,b_tuple){
var vec__106824 = p__106823;
var acc = cljs.core.nth.call(null,vec__106824,(0),null);
var b_rows = cljs.core.nth.call(null,vec__106824,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__106821_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__106821_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__106822_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__106822_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__106827_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__106827_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__106828_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__106828_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__106830_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__106830_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__106829_SHARP_){
return cljs.core.range.call(null,(0),p1__106829_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
return fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__106831_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__106831_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__106832_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__106832_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__106833_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106833_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__106835_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__106835_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__106834_SHARP_){
return cljs.core.range.call(null,(0),p1__106834_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (a_tuple){
var matches = fluree.db.query.analytical.find_match.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__106836_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106836_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__106837_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__106837_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__106838_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106838_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__106840_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__106840_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__106839_SHARP_){
return cljs.core.range.call(null,(0),p1__106839_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__106843 = cljs.core.reduce.call(null,(function (p__106846,a_tuple){
var vec__106847 = p__106846;
var c_tuples = cljs.core.nth.call(null,vec__106847,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__106847,(1),null);
var vec__106850 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__106850,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__106850,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,c_tuples,matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__106843,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__106843,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__106841_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106841_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__106842_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__106842_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__106854 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__106854,(0),null);
var _ = cljs.core.nth.call(null,vec__106854,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__106853_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__106853_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__106859 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__106859,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__106859,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__106857_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__106857_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__106858_SHARP_){
return cljs.core.nth.call(null,clause,p1__106858_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__106862,filters,optional_QMARK_){
var map__106863 = p__106862;
var map__106863__$1 = (((((!((map__106863 == null))))?(((((map__106863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106863.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106863):map__106863);
var tuple_map = map__106863__$1;
var headers = cljs.core.get.call(null,map__106863__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__106863__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__106863__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__106865 = clause;
var k = cljs.core.nth.call(null,vec__106865,(0),null);
var v = cljs.core.nth.call(null,vec__106865,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__106868 = res;
var map__106868__$1 = (((((!((map__106868 == null))))?(((((map__106868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106868):map__106868);
var headers = cljs.core.get.call(null,map__106868__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__106868__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5733__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_106923){
var state_val_106924 = (state_106923[(1)]);
if((state_val_106924 === (7))){
var inst_106897 = (state_106923[(7)]);
var inst_106895 = (state_106923[(2)]);
var inst_106896 = fluree.db.util.async.throw_err.call(null,inst_106895);
var inst_106897__$1 = cljs.core.nth.call(null,inst_106896,(0),null);
var inst_106898 = cljs.core.nth.call(null,inst_106896,(1),null);
var inst_106899 = (inst_106897__$1 == null);
var state_106923__$1 = (function (){var statearr_106925 = state_106923;
(statearr_106925[(7)] = inst_106897__$1);

(statearr_106925[(8)] = inst_106898);

return statearr_106925;
})();
if(cljs.core.truth_(inst_106899)){
var statearr_106926_106954 = state_106923__$1;
(statearr_106926_106954[(1)] = (8));

} else {
var statearr_106927_106955 = state_106923__$1;
(statearr_106927_106955[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (1))){
var inst_106877 = cljs.core.seq.call(null,optional_clauses);
var inst_106878 = cljs.core.first.call(null,inst_106877);
var inst_106879 = cljs.core.next.call(null,inst_106877);
var inst_106880 = optional_clauses;
var inst_106881 = where_tuples;
var state_106923__$1 = (function (){var statearr_106928 = state_106923;
(statearr_106928[(9)] = inst_106878);

(statearr_106928[(10)] = inst_106880);

(statearr_106928[(11)] = inst_106881);

(statearr_106928[(12)] = inst_106879);

return statearr_106928;
})();
var statearr_106929_106956 = state_106923__$1;
(statearr_106929_106956[(2)] = null);

(statearr_106929_106956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (4))){
var inst_106881 = (state_106923[(11)]);
var inst_106887 = (state_106923[(13)]);
var inst_106888 = (state_106923[(14)]);
var inst_106893 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_106881,inst_106887,inst_106888,true,fuel,max_fuel,opts);
var state_106923__$1 = state_106923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_106923__$1,(7),inst_106893);
} else {
if((state_val_106924 === (15))){
var state_106923__$1 = state_106923;
var statearr_106930_106957 = state_106923__$1;
(statearr_106930_106957[(2)] = null);

(statearr_106930_106957[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (13))){
var inst_106914 = (state_106923[(2)]);
var state_106923__$1 = state_106923;
var statearr_106931_106958 = state_106923__$1;
(statearr_106931_106958[(2)] = inst_106914);

(statearr_106931_106958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (6))){
var inst_106919 = (state_106923[(2)]);
var state_106923__$1 = state_106923;
var statearr_106932_106959 = state_106923__$1;
(statearr_106932_106959[(2)] = inst_106919);

(statearr_106932_106959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (3))){
var inst_106921 = (state_106923[(2)]);
var state_106923__$1 = state_106923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_106923__$1,inst_106921);
} else {
if((state_val_106924 === (12))){
var state_106923__$1 = state_106923;
var statearr_106933_106960 = state_106923__$1;
(statearr_106933_106960[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (2))){
var inst_106880 = (state_106923[(10)]);
var inst_106887 = (state_106923[(13)]);
var inst_106886 = cljs.core.seq.call(null,inst_106880);
var inst_106887__$1 = cljs.core.first.call(null,inst_106886);
var inst_106888 = cljs.core.next.call(null,inst_106886);
var state_106923__$1 = (function (){var statearr_106935 = state_106923;
(statearr_106935[(13)] = inst_106887__$1);

(statearr_106935[(14)] = inst_106888);

return statearr_106935;
})();
if(cljs.core.truth_(inst_106887__$1)){
var statearr_106936_106961 = state_106923__$1;
(statearr_106936_106961[(1)] = (4));

} else {
var statearr_106937_106962 = state_106923__$1;
(statearr_106937_106962[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (11))){
var inst_106897 = (state_106923[(7)]);
var inst_106898 = (state_106923[(8)]);
var inst_106880 = inst_106898;
var inst_106881 = inst_106897;
var state_106923__$1 = (function (){var statearr_106938 = state_106923;
(statearr_106938[(10)] = inst_106880);

(statearr_106938[(11)] = inst_106881);

return statearr_106938;
})();
var statearr_106939_106963 = state_106923__$1;
(statearr_106939_106963[(2)] = null);

(statearr_106939_106963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (9))){
var inst_106887 = (state_106923[(13)]);
var inst_106903 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_106887);
var state_106923__$1 = state_106923;
if(cljs.core.truth_(inst_106903)){
var statearr_106940_106964 = state_106923__$1;
(statearr_106940_106964[(1)] = (11));

} else {
var statearr_106941_106965 = state_106923__$1;
(statearr_106941_106965[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (5))){
var inst_106881 = (state_106923[(11)]);
var state_106923__$1 = state_106923;
var statearr_106942_106966 = state_106923__$1;
(statearr_106942_106966[(2)] = inst_106881);

(statearr_106942_106966[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (14))){
var inst_106897 = (state_106923[(7)]);
var inst_106881 = (state_106923[(11)]);
var inst_106898 = (state_106923[(8)]);
var inst_106908 = fluree.db.query.analytical.left_outer_join.call(null,inst_106881,inst_106897);
var inst_106880 = inst_106898;
var inst_106881__$1 = inst_106908;
var state_106923__$1 = (function (){var statearr_106943 = state_106923;
(statearr_106943[(10)] = inst_106880);

(statearr_106943[(11)] = inst_106881__$1);

return statearr_106943;
})();
var statearr_106944_106967 = state_106923__$1;
(statearr_106944_106967[(2)] = null);

(statearr_106944_106967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (16))){
var inst_106912 = (state_106923[(2)]);
var state_106923__$1 = state_106923;
var statearr_106946_106968 = state_106923__$1;
(statearr_106946_106968[(2)] = inst_106912);

(statearr_106946_106968[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (10))){
var inst_106916 = (state_106923[(2)]);
var state_106923__$1 = state_106923;
var statearr_106947_106969 = state_106923__$1;
(statearr_106947_106969[(2)] = inst_106916);

(statearr_106947_106969[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_106924 === (8))){
var inst_106881 = (state_106923[(11)]);
var inst_106898 = (state_106923[(8)]);
var tmp106945 = inst_106881;
var inst_106880 = inst_106898;
var inst_106881__$1 = tmp106945;
var state_106923__$1 = (function (){var statearr_106948 = state_106923;
(statearr_106948[(10)] = inst_106880);

(statearr_106948[(11)] = inst_106881__$1);

return statearr_106948;
})();
var statearr_106949_106970 = state_106923__$1;
(statearr_106949_106970[(2)] = null);

(statearr_106949_106970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0 = (function (){
var statearr_106950 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_106950[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__);

(statearr_106950[(1)] = (1));

return statearr_106950;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1 = (function (state_106923){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_106923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e106951){if((e106951 instanceof Object)){
var ex__99978__auto__ = e106951;
var statearr_106952_106971 = state_106923;
(statearr_106952_106971[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_106923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e106951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__106972 = state_106923;
state_106923 = G__106972;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__ = function(state_106923){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1.call(this,state_106923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_106953 = f__100070__auto__.call(null);
(statearr_106953[(6)] = c__100069__auto__);

return statearr_106953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__106974){
var vec__106975 = p__106974;
var var_name = cljs.core.nth.call(null,vec__106975,(0),null);
var var_val = cljs.core.nth.call(null,vec__106975,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__106973_SHARP_){
return cljs.core.conj.call(null,p1__106973_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__106979,p__106980,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__106981 = p__106979;
var map__106981__$1 = (((((!((map__106981 == null))))?(((((map__106981.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106981.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106981):map__106981);
var q_map = map__106981__$1;
var prefixes = cljs.core.get.call(null,map__106981__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__106982 = p__106980;
var map__106982__$1 = (((((!((map__106982 == null))))?(((((map__106982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__106982.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__106982):map__106982);
var res = map__106982__$1;
var vars = cljs.core.get.call(null,map__106982__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107187){
var state_val_107188 = (state_107187[(1)]);
if((state_val_107188 === (7))){
var inst_107183 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107189_107269 = state_107187__$1;
(statearr_107189_107269[(2)] = inst_107183);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (20))){
var inst_107020 = (state_107187[(7)]);
var inst_107027 = (state_107187[(8)]);
var inst_107016 = (state_107187[(9)]);
var inst_107021 = (state_107187[(10)]);
var inst_107019 = (state_107187[(11)]);
var inst_107028 = (state_107187[(12)]);
var inst_106992 = (state_107187[(13)]);
var inst_107018 = (state_107187[(14)]);
var inst_107032 = (state_107187[(2)]);
var inst_107033 = fluree.db.util.async.throw_err.call(null,inst_107032);
var inst_107034 = (function (){var expr__106994 = inst_106992;
var vec__107023 = inst_107020;
var new_res = inst_107033;
var rest = inst_107028;
var tuples = inst_107021;
var G__107012 = inst_107020;
var first__107025 = inst_107027;
var pred__106993 = cljs.core._EQ_;
var vec__107013 = inst_107016;
var seq__107014 = inst_107019;
var first__107015 = inst_107018;
var seq__107024 = inst_107028;
var segment_type = inst_106992;
var clause_group = inst_107027;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_107035 = cljs.core.keys.call(null,vars);
var inst_107036 = cljs.core.reduce.call(null,inst_107034,inst_107033,inst_107035);
var inst_107037 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_107036);
var state_107187__$1 = (function (){var statearr_107190 = state_107187;
(statearr_107190[(15)] = inst_107037);

return statearr_107190;
})();
if(cljs.core.truth_(inst_107021)){
var statearr_107191_107270 = state_107187__$1;
(statearr_107191_107270[(1)] = (21));

} else {
var statearr_107192_107271 = state_107187__$1;
(statearr_107192_107271[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (58))){
var inst_107157 = (state_107187[(16)]);
var inst_107160 = (state_107187[(2)]);
var inst_107161 = fluree.db.util.async.throw_err.call(null,inst_107160);
var inst_107162 = [inst_107161,r];
var inst_107163 = (new cljs.core.PersistentVector(null,2,(5),inst_107157,inst_107162,null));
var state_107187__$1 = state_107187;
var statearr_107193_107272 = state_107187__$1;
(statearr_107193_107272[(2)] = inst_107163);

(statearr_107193_107272[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (27))){
var inst_107068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107069 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_107070 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_107069,optional_QMARK_);
var inst_107071 = [inst_107070,r];
var inst_107072 = (new cljs.core.PersistentVector(null,2,(5),inst_107068,inst_107071,null));
var state_107187__$1 = state_107187;
var statearr_107194_107273 = state_107187__$1;
(statearr_107194_107273[(2)] = inst_107072);

(statearr_107194_107273[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (1))){
var state_107187__$1 = state_107187;
var statearr_107195_107274 = state_107187__$1;
(statearr_107195_107274[(2)] = null);

(statearr_107195_107274[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (24))){
var inst_106992 = (state_107187[(13)]);
var inst_107056 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_107057 = (function (){var segment_type = inst_106992;
var pred__106993 = cljs.core._EQ_;
var expr__106994 = inst_106992;
var bindings = inst_107056;
return (function (p1__106978_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__106978_SHARP_);
});
})();
var inst_107058 = cljs.core.map.call(null,inst_107057,inst_107056);
var inst_107059 = cljs.core.PersistentHashMap.EMPTY;
var inst_107060 = cljs.core.into.call(null,inst_107059,inst_107058);
var inst_107061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107062 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_107060);
var inst_107063 = [inst_107062,r];
var inst_107064 = (new cljs.core.PersistentVector(null,2,(5),inst_107061,inst_107063,null));
var state_107187__$1 = state_107187;
var statearr_107196_107275 = state_107187__$1;
(statearr_107196_107275[(2)] = inst_107064);

(statearr_107196_107275[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (55))){
var inst_107140 = (state_107187[(17)]);
var inst_107139 = (state_107187[(18)]);
var inst_107157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107158 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_107139,res,inst_107140,fuel,max_fuel);
var state_107187__$1 = (function (){var statearr_107197 = state_107187;
(statearr_107197[(16)] = inst_107157);

return statearr_107197;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(58),inst_107158);
} else {
if((state_val_107188 === (39))){
var inst_107177 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107198_107276 = state_107187__$1;
(statearr_107198_107276[(2)] = inst_107177);

(statearr_107198_107276[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (46))){
var inst_107173 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107199_107277 = state_107187__$1;
(statearr_107199_107277[(2)] = inst_107173);

(statearr_107199_107277[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107187,(3),Error,null,(2));
var inst_106989 = cljs.core.map_QMARK_.call(null,clause);
var state_107187__$1 = state_107187;
if(inst_106989){
var statearr_107200_107278 = state_107187__$1;
(statearr_107200_107278[(1)] = (5));

} else {
var statearr_107201_107279 = state_107187__$1;
(statearr_107201_107279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (54))){
var inst_107168 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107202_107280 = state_107187__$1;
(statearr_107202_107280[(2)] = inst_107168);

(statearr_107202_107280[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (15))){
var inst_107020 = (state_107187[(7)]);
var inst_107027 = (state_107187[(8)]);
var inst_107026 = cljs.core.seq.call(null,inst_107020);
var inst_107027__$1 = cljs.core.first.call(null,inst_107026);
var inst_107028 = cljs.core.next.call(null,inst_107026);
var state_107187__$1 = (function (){var statearr_107203 = state_107187;
(statearr_107203[(8)] = inst_107027__$1);

(statearr_107203[(12)] = inst_107028);

return statearr_107203;
})();
if(cljs.core.truth_(inst_107027__$1)){
var statearr_107204_107281 = state_107187__$1;
(statearr_107204_107281[(1)] = (17));

} else {
var statearr_107205_107282 = state_107187__$1;
(statearr_107205_107282[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (48))){
var inst_107140 = (state_107187[(17)]);
var inst_107143 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_107140,r,res,optional_QMARK_,fuel,max_fuel);
var state_107187__$1 = state_107187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(51),inst_107143);
} else {
if((state_val_107188 === (50))){
var inst_107170 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107206_107283 = state_107187__$1;
(statearr_107206_107283[(2)] = inst_107170);

(statearr_107206_107283[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (21))){
var inst_107021 = (state_107187[(10)]);
var inst_107028 = (state_107187[(12)]);
var inst_107037 = (state_107187[(15)]);
var inst_107039 = fluree.db.query.analytical.outer_union.call(null,inst_107021,inst_107037);
var inst_107020 = inst_107028;
var inst_107021__$1 = inst_107039;
var state_107187__$1 = (function (){var statearr_107207 = state_107187;
(statearr_107207[(7)] = inst_107020);

(statearr_107207[(10)] = inst_107021__$1);

return statearr_107207;
})();
var statearr_107208_107284 = state_107187__$1;
(statearr_107208_107284[(2)] = null);

(statearr_107208_107284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (31))){
var inst_107097 = cljs.core.count.call(null,clause);
var inst_107098 = cljs.core._EQ_.call(null,(3),inst_107097);
var inst_107099 = cljs.core.second.call(null,clause);
var inst_107100 = cljs.core._EQ_.call(null,inst_107099,"rdf:type");
var inst_107101 = ((inst_107098) && (inst_107100));
var state_107187__$1 = state_107187;
if(cljs.core.truth_(inst_107101)){
var statearr_107209_107285 = state_107187__$1;
(statearr_107209_107285[(1)] = (33));

} else {
var statearr_107210_107286 = state_107187__$1;
(statearr_107210_107286[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (32))){
var inst_107181 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107211_107287 = state_107187__$1;
(statearr_107211_107287[(2)] = inst_107181);

(statearr_107211_107287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (40))){
var inst_107114 = (state_107187[(19)]);
var inst_107117 = (state_107187[(2)]);
var inst_107118 = fluree.db.util.async.throw_err.call(null,inst_107117);
var inst_107119 = [inst_107118,r];
var inst_107120 = (new cljs.core.PersistentVector(null,2,(5),inst_107114,inst_107119,null));
var state_107187__$1 = state_107187;
var statearr_107212_107288 = state_107187__$1;
(statearr_107212_107288[(2)] = inst_107120);

(statearr_107212_107288[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (56))){
var state_107187__$1 = state_107187;
var statearr_107213_107289 = state_107187__$1;
(statearr_107213_107289[(2)] = null);

(statearr_107213_107289[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (33))){
var inst_107103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107104 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_107187__$1 = (function (){var statearr_107214 = state_107187;
(statearr_107214[(20)] = inst_107103);

return statearr_107214;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(36),inst_107104);
} else {
if((state_val_107188 === (13))){
var inst_106992 = (state_107187[(13)]);
var inst_107054 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_106992);
var state_107187__$1 = state_107187;
if(inst_107054){
var statearr_107215_107290 = state_107187__$1;
(statearr_107215_107290[(1)] = (24));

} else {
var statearr_107216_107291 = state_107187__$1;
(statearr_107216_107291[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (22))){
var inst_107028 = (state_107187[(12)]);
var inst_107037 = (state_107187[(15)]);
var inst_107020 = inst_107028;
var inst_107021 = inst_107037;
var state_107187__$1 = (function (){var statearr_107217 = state_107187;
(statearr_107217[(7)] = inst_107020);

(statearr_107217[(10)] = inst_107021);

return statearr_107217;
})();
var statearr_107218_107292 = state_107187__$1;
(statearr_107218_107292[(2)] = null);

(statearr_107218_107292[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (36))){
var inst_107103 = (state_107187[(20)]);
var inst_107106 = (state_107187[(2)]);
var inst_107107 = fluree.db.util.async.throw_err.call(null,inst_107106);
var inst_107108 = [inst_107107,r];
var inst_107109 = (new cljs.core.PersistentVector(null,2,(5),inst_107103,inst_107108,null));
var state_107187__$1 = state_107187;
var statearr_107219_107293 = state_107187__$1;
(statearr_107219_107293[(2)] = inst_107109);

(statearr_107219_107293[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (41))){
var inst_107125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107126 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_107127 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_107126);
var inst_107128 = [inst_107127,r];
var inst_107129 = (new cljs.core.PersistentVector(null,2,(5),inst_107125,inst_107128,null));
var state_107187__$1 = state_107187;
var statearr_107220_107294 = state_107187__$1;
(statearr_107220_107294[(2)] = inst_107129);

(statearr_107220_107294[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (43))){
var inst_107175 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107221_107295 = state_107187__$1;
(statearr_107221_107295[(2)] = inst_107175);

(statearr_107221_107295[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (29))){
var inst_107078 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107222_107296 = state_107187__$1;
(statearr_107222_107296[(2)] = inst_107078);

(statearr_107222_107296[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (44))){
var inst_107135 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_107187__$1 = state_107187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(47),inst_107135);
} else {
if((state_val_107188 === (6))){
var inst_107086 = cljs.core.count.call(null,clause);
var inst_107087 = cljs.core._EQ_.call(null,(3),inst_107086);
var inst_107088 = cljs.core.second.call(null,clause);
var inst_107089 = clojure.string.starts_with_QMARK_.call(null,inst_107088,"fullText:");
var inst_107090 = ((inst_107087) && (inst_107089));
var state_107187__$1 = state_107187;
if(cljs.core.truth_(inst_107090)){
var statearr_107223_107297 = state_107187__$1;
(statearr_107223_107297[(1)] = (30));

} else {
var statearr_107224_107298 = state_107187__$1;
(statearr_107224_107298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (28))){
var inst_106992 = (state_107187[(13)]);
var inst_107074 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_106992)].join('');
var inst_107075 = (new Error(inst_107074));
var inst_107076 = (function(){throw inst_107075})();
var state_107187__$1 = state_107187;
var statearr_107225_107299 = state_107187__$1;
(statearr_107225_107299[(2)] = inst_107076);

(statearr_107225_107299[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (51))){
var inst_107145 = (state_107187[(2)]);
var inst_107146 = fluree.db.util.async.throw_err.call(null,inst_107145);
var state_107187__$1 = state_107187;
var statearr_107226_107300 = state_107187__$1;
(statearr_107226_107300[(2)] = inst_107146);

(statearr_107226_107300[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (25))){
var inst_106992 = (state_107187[(13)]);
var inst_107066 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_106992);
var state_107187__$1 = state_107187;
if(inst_107066){
var statearr_107227_107301 = state_107187__$1;
(statearr_107227_107301[(1)] = (27));

} else {
var statearr_107228_107302 = state_107187__$1;
(statearr_107228_107302[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (34))){
var inst_107111 = cljs.core.count.call(null,clause);
var inst_107112 = cljs.core._EQ_.call(null,(3),inst_107111);
var state_107187__$1 = state_107187;
if(inst_107112){
var statearr_107229_107303 = state_107187__$1;
(statearr_107229_107303[(1)] = (37));

} else {
var statearr_107230_107304 = state_107187__$1;
(statearr_107230_107304[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (17))){
var inst_107027 = (state_107187[(8)]);
var inst_107030 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_107027,q_map,vars,fuel,max_fuel,opts);
var state_107187__$1 = state_107187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(20),inst_107030);
} else {
if((state_val_107188 === (3))){
var inst_106985 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107231_107305 = state_107187__$1;
(statearr_107231_107305[(2)] = inst_106985);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107187__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (12))){
var inst_107016 = (state_107187[(9)]);
var inst_107016__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_107017 = cljs.core.seq.call(null,inst_107016__$1);
var inst_107018 = cljs.core.first.call(null,inst_107017);
var inst_107019 = cljs.core.next.call(null,inst_107017);
var inst_107020 = inst_107016__$1;
var inst_107021 = null;
var state_107187__$1 = (function (){var statearr_107232 = state_107187;
(statearr_107232[(7)] = inst_107020);

(statearr_107232[(9)] = inst_107016__$1);

(statearr_107232[(10)] = inst_107021);

(statearr_107232[(11)] = inst_107019);

(statearr_107232[(14)] = inst_107018);

return statearr_107232;
})();
var statearr_107233_107306 = state_107187__$1;
(statearr_107233_107306[(2)] = null);

(statearr_107233_107306[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (2))){
var inst_107185 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107187__$1,inst_107185);
} else {
if((state_val_107188 === (23))){
var inst_107044 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107234_107307 = state_107187__$1;
(statearr_107234_107307[(2)] = inst_107044);

(statearr_107234_107307[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (47))){
var inst_107139 = (state_107187[(18)]);
var inst_107137 = (state_107187[(2)]);
var inst_107138 = fluree.db.util.async.throw_err.call(null,inst_107137);
var inst_107139__$1 = cljs.core.nth.call(null,inst_107138,(0),null);
var inst_107140 = cljs.core.nth.call(null,inst_107138,(1),null);
var inst_107141 = cljs.core._EQ_.call(null,"$wd",inst_107139__$1);
var state_107187__$1 = (function (){var statearr_107235 = state_107187;
(statearr_107235[(17)] = inst_107140);

(statearr_107235[(18)] = inst_107139__$1);

return statearr_107235;
})();
if(inst_107141){
var statearr_107236_107308 = state_107187__$1;
(statearr_107236_107308[(1)] = (48));

} else {
var statearr_107237_107309 = state_107187__$1;
(statearr_107237_107309[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (35))){
var inst_107179 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107238_107310 = state_107187__$1;
(statearr_107238_107310[(2)] = inst_107179);

(statearr_107238_107310[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (19))){
var inst_107050 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107239_107311 = state_107187__$1;
(statearr_107239_107311[(2)] = inst_107050);

(statearr_107239_107311[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (57))){
var inst_107166 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107240_107312 = state_107187__$1;
(statearr_107240_107312[(2)] = inst_107166);

(statearr_107240_107312[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (11))){
var inst_106998 = (state_107187[(21)]);
var inst_107002 = (state_107187[(2)]);
var inst_107003 = fluree.db.util.async.throw_err.call(null,inst_107002);
var inst_107004 = [inst_107003,r];
var inst_107005 = (new cljs.core.PersistentVector(null,2,(5),inst_106998,inst_107004,null));
var state_107187__$1 = state_107187;
var statearr_107241_107313 = state_107187__$1;
(statearr_107241_107313[(2)] = inst_107005);

(statearr_107241_107313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (9))){
var inst_106992 = (state_107187[(13)]);
var inst_107007 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_106992);
var state_107187__$1 = state_107187;
if(inst_107007){
var statearr_107242_107314 = state_107187__$1;
(statearr_107242_107314[(1)] = (12));

} else {
var statearr_107243_107315 = state_107187__$1;
(statearr_107243_107315[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (5))){
var inst_106992 = (state_107187[(13)]);
var inst_106991 = cljs.core.keys.call(null,clause);
var inst_106992__$1 = cljs.core.first.call(null,inst_106991);
var inst_106996 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_106992__$1);
var state_107187__$1 = (function (){var statearr_107244 = state_107187;
(statearr_107244[(13)] = inst_106992__$1);

return statearr_107244;
})();
if(inst_106996){
var statearr_107245_107316 = state_107187__$1;
(statearr_107245_107316[(1)] = (8));

} else {
var statearr_107246_107317 = state_107187__$1;
(statearr_107246_107317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (14))){
var inst_107082 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107247_107318 = state_107187__$1;
(statearr_107247_107318[(2)] = inst_107082);

(statearr_107247_107318[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (45))){
var state_107187__$1 = state_107187;
var statearr_107248_107319 = state_107187__$1;
(statearr_107248_107319[(2)] = null);

(statearr_107248_107319[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (53))){
var state_107187__$1 = state_107187;
var statearr_107249_107320 = state_107187__$1;
(statearr_107249_107320[(1)] = (55));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (26))){
var inst_107080 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107251_107321 = state_107187__$1;
(statearr_107251_107321[(2)] = inst_107080);

(statearr_107251_107321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (16))){
var inst_107052 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107252_107322 = state_107187__$1;
(statearr_107252_107322[(2)] = inst_107052);

(statearr_107252_107322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (38))){
var inst_107122 = cljs.core.count.call(null,clause);
var inst_107123 = cljs.core._EQ_.call(null,(2),inst_107122);
var state_107187__$1 = state_107187;
if(inst_107123){
var statearr_107253_107323 = state_107187__$1;
(statearr_107253_107323[(1)] = (41));

} else {
var statearr_107254_107324 = state_107187__$1;
(statearr_107254_107324[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (30))){
var inst_107092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107093 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_107094 = [inst_107093,r];
var inst_107095 = (new cljs.core.PersistentVector(null,2,(5),inst_107092,inst_107094,null));
var state_107187__$1 = state_107187;
var statearr_107255_107325 = state_107187__$1;
(statearr_107255_107325[(2)] = inst_107095);

(statearr_107255_107325[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (10))){
var inst_107084 = (state_107187[(2)]);
var state_107187__$1 = state_107187;
var statearr_107256_107326 = state_107187__$1;
(statearr_107256_107326[(2)] = inst_107084);

(statearr_107256_107326[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (18))){
var inst_107021 = (state_107187[(10)]);
var inst_107046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107047 = [inst_107021,r];
var inst_107048 = (new cljs.core.PersistentVector(null,2,(5),inst_107046,inst_107047,null));
var state_107187__$1 = state_107187;
var statearr_107257_107327 = state_107187__$1;
(statearr_107257_107327[(2)] = inst_107048);

(statearr_107257_107327[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (52))){
var inst_107140 = (state_107187[(17)]);
var inst_107139 = (state_107187[(18)]);
var inst_107151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107152 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_107139,res,inst_107140);
var inst_107153 = [inst_107152,r];
var inst_107154 = (new cljs.core.PersistentVector(null,2,(5),inst_107151,inst_107153,null));
var state_107187__$1 = state_107187;
var statearr_107258_107328 = state_107187__$1;
(statearr_107258_107328[(2)] = inst_107154);

(statearr_107258_107328[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (42))){
var state_107187__$1 = state_107187;
var statearr_107259_107329 = state_107187__$1;
(statearr_107259_107329[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107188 === (37))){
var inst_107114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107115 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_107187__$1 = (function (){var statearr_107261 = state_107187;
(statearr_107261[(19)] = inst_107114);

return statearr_107261;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(40),inst_107115);
} else {
if((state_val_107188 === (8))){
var inst_106998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_106999 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_107000 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_106999,res,fuel,max_fuel,opts);
var state_107187__$1 = (function (){var statearr_107262 = state_107187;
(statearr_107262[(21)] = inst_106998);

return statearr_107262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107187__$1,(11),inst_107000);
} else {
if((state_val_107188 === (49))){
var inst_107140 = (state_107187[(17)]);
var inst_107148 = cljs.core.second.call(null,inst_107140);
var inst_107149 = clojure.string.starts_with_QMARK_.call(null,inst_107148,"fullText:");
var state_107187__$1 = state_107187;
if(inst_107149){
var statearr_107263_107330 = state_107187__$1;
(statearr_107263_107330[(1)] = (52));

} else {
var statearr_107264_107331 = state_107187__$1;
(statearr_107264_107331[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_107265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107265[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__);

(statearr_107265[(1)] = (1));

return statearr_107265;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1 = (function (state_107187){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107266){if((e107266 instanceof Object)){
var ex__99978__auto__ = e107266;
var statearr_107267_107332 = state_107187;
(statearr_107267_107332[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107333 = state_107187;
state_107187 = G__107333;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__ = function(state_107187){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1.call(this,state_107187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107268 = f__100070__auto__.call(null);
(statearr_107268[(6)] = c__100069__auto__);

return statearr_107268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__107335 = arguments.length;
switch (G__107335) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107411){
var state_val_107412 = (state_107411[(1)]);
if((state_val_107412 === (7))){
var inst_107362 = (state_107411[(7)]);
var inst_107355 = (state_107411[(8)]);
var inst_107361 = (state_107411[(9)]);
var inst_107367 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_107355,inst_107361,inst_107362,false,fuel,max_fuel,opts);
var state_107411__$1 = state_107411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107411__$1,(10),inst_107367);
} else {
if((state_val_107412 === (20))){
var inst_107355 = (state_107411[(8)]);
var inst_107372 = (state_107411[(10)]);
var tmp107413 = inst_107355;
var inst_107354 = inst_107372;
var inst_107355__$1 = tmp107413;
var state_107411__$1 = (function (){var statearr_107414 = state_107411;
(statearr_107414[(8)] = inst_107355__$1);

(statearr_107414[(11)] = inst_107354);

return statearr_107414;
})();
var statearr_107415_107455 = state_107411__$1;
(statearr_107415_107455[(2)] = null);

(statearr_107415_107455[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (1))){
var state_107411__$1 = state_107411;
var statearr_107416_107456 = state_107411__$1;
(statearr_107416_107456[(2)] = null);

(statearr_107416_107456[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (24))){
var state_107411__$1 = state_107411;
var statearr_107417_107457 = state_107411__$1;
(statearr_107417_107457[(2)] = null);

(statearr_107417_107457[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107411,(3),Error,null,(2));
var inst_107347 = cljs.core.seq.call(null,where);
var inst_107348 = cljs.core.first.call(null,inst_107347);
var inst_107349 = cljs.core.next.call(null,inst_107347);
var inst_107350 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_107351 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_107352 = [inst_107351];
var inst_107353 = cljs.core.PersistentHashMap.fromArrays(inst_107350,inst_107352);
var inst_107354 = where;
var inst_107355 = inst_107353;
var state_107411__$1 = (function (){var statearr_107418 = state_107411;
(statearr_107418[(8)] = inst_107355);

(statearr_107418[(12)] = inst_107349);

(statearr_107418[(11)] = inst_107354);

(statearr_107418[(13)] = inst_107348);

return statearr_107418;
})();
var statearr_107419_107458 = state_107411__$1;
(statearr_107419_107458[(2)] = null);

(statearr_107419_107458[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (15))){
var inst_107371 = (state_107411[(14)]);
var inst_107387 = (inst_107371 == null);
var state_107411__$1 = state_107411;
if(cljs.core.truth_(inst_107387)){
var statearr_107420_107459 = state_107411__$1;
(statearr_107420_107459[(1)] = (20));

} else {
var statearr_107421_107460 = state_107411__$1;
(statearr_107421_107460[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (21))){
var state_107411__$1 = state_107411;
var statearr_107422_107461 = state_107411__$1;
(statearr_107422_107461[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (13))){
var inst_107402 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107424_107462 = state_107411__$1;
(statearr_107424_107462[(2)] = inst_107402);

(statearr_107424_107462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (22))){
var inst_107398 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107425_107463 = state_107411__$1;
(statearr_107425_107463[(2)] = inst_107398);

(statearr_107425_107463[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (6))){
var inst_107407 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107426_107464 = state_107411__$1;
(statearr_107426_107464[(2)] = inst_107407);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107411__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (25))){
var inst_107396 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107427_107465 = state_107411__$1;
(statearr_107427_107465[(2)] = inst_107396);

(statearr_107427_107465[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (17))){
var inst_107371 = (state_107411[(14)]);
var state_107411__$1 = state_107411;
var statearr_107428_107466 = state_107411__$1;
(statearr_107428_107466[(2)] = inst_107371);

(statearr_107428_107466[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (3))){
var inst_107336 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107429_107467 = state_107411__$1;
(statearr_107429_107467[(2)] = inst_107336);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107411__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (12))){
var inst_107355 = (state_107411[(8)]);
var inst_107378 = cljs.core.dissoc.call(null,inst_107355,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_107379 = cljs.core.empty_QMARK_.call(null,inst_107378);
var state_107411__$1 = state_107411;
if(inst_107379){
var statearr_107430_107468 = state_107411__$1;
(statearr_107430_107468[(1)] = (14));

} else {
var statearr_107431_107469 = state_107411__$1;
(statearr_107431_107469[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (2))){
var inst_107409 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107411__$1,inst_107409);
} else {
if((state_val_107412 === (23))){
var inst_107355 = (state_107411[(8)]);
var inst_107372 = (state_107411[(10)]);
var inst_107371 = (state_107411[(14)]);
var inst_107392 = fluree.db.query.analytical.inner_join.call(null,inst_107355,inst_107371);
var inst_107354 = inst_107372;
var inst_107355__$1 = inst_107392;
var state_107411__$1 = (function (){var statearr_107432 = state_107411;
(statearr_107432[(8)] = inst_107355__$1);

(statearr_107432[(11)] = inst_107354);

return statearr_107432;
})();
var statearr_107433_107470 = state_107411__$1;
(statearr_107433_107470[(2)] = null);

(statearr_107433_107470[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (19))){
var inst_107372 = (state_107411[(10)]);
var inst_107384 = (state_107411[(2)]);
var inst_107354 = inst_107372;
var inst_107355 = inst_107384;
var state_107411__$1 = (function (){var statearr_107434 = state_107411;
(statearr_107434[(8)] = inst_107355);

(statearr_107434[(11)] = inst_107354);

return statearr_107434;
})();
var statearr_107435_107471 = state_107411__$1;
(statearr_107435_107471[(2)] = null);

(statearr_107435_107471[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (11))){
var inst_107372 = (state_107411[(10)]);
var inst_107371 = (state_107411[(14)]);
var inst_107354 = inst_107372;
var inst_107355 = inst_107371;
var state_107411__$1 = (function (){var statearr_107436 = state_107411;
(statearr_107436[(8)] = inst_107355);

(statearr_107436[(11)] = inst_107354);

return statearr_107436;
})();
var statearr_107437_107472 = state_107411__$1;
(statearr_107437_107472[(2)] = null);

(statearr_107437_107472[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (9))){
var inst_107405 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107438_107473 = state_107411__$1;
(statearr_107438_107473[(2)] = inst_107405);

(statearr_107438_107473[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (5))){
var inst_107361 = (state_107411[(9)]);
var inst_107354 = (state_107411[(11)]);
var inst_107360 = cljs.core.seq.call(null,inst_107354);
var inst_107361__$1 = cljs.core.first.call(null,inst_107360);
var inst_107362 = cljs.core.next.call(null,inst_107360);
var state_107411__$1 = (function (){var statearr_107439 = state_107411;
(statearr_107439[(7)] = inst_107362);

(statearr_107439[(9)] = inst_107361__$1);

return statearr_107439;
})();
if(cljs.core.truth_(inst_107361__$1)){
var statearr_107440_107474 = state_107411__$1;
(statearr_107440_107474[(1)] = (7));

} else {
var statearr_107441_107475 = state_107411__$1;
(statearr_107441_107475[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (14))){
var inst_107371 = (state_107411[(14)]);
var state_107411__$1 = state_107411;
if(cljs.core.truth_(inst_107371)){
var statearr_107442_107476 = state_107411__$1;
(statearr_107442_107476[(1)] = (17));

} else {
var statearr_107443_107477 = state_107411__$1;
(statearr_107443_107477[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (16))){
var inst_107400 = (state_107411[(2)]);
var state_107411__$1 = state_107411;
var statearr_107444_107478 = state_107411__$1;
(statearr_107444_107478[(2)] = inst_107400);

(statearr_107444_107478[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (10))){
var inst_107361 = (state_107411[(9)]);
var inst_107369 = (state_107411[(2)]);
var inst_107370 = fluree.db.util.async.throw_err.call(null,inst_107369);
var inst_107371 = cljs.core.nth.call(null,inst_107370,(0),null);
var inst_107372 = cljs.core.nth.call(null,inst_107370,(1),null);
var inst_107373 = cljs.core.count.call(null,inst_107361);
var inst_107374 = cljs.core._EQ_.call(null,(2),inst_107373);
var state_107411__$1 = (function (){var statearr_107445 = state_107411;
(statearr_107445[(10)] = inst_107372);

(statearr_107445[(14)] = inst_107371);

return statearr_107445;
})();
if(inst_107374){
var statearr_107446_107479 = state_107411__$1;
(statearr_107446_107479[(1)] = (11));

} else {
var statearr_107447_107480 = state_107411__$1;
(statearr_107447_107480[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (18))){
var inst_107355 = (state_107411[(8)]);
var state_107411__$1 = state_107411;
var statearr_107448_107481 = state_107411__$1;
(statearr_107448_107481[(2)] = inst_107355);

(statearr_107448_107481[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107412 === (8))){
var inst_107355 = (state_107411[(8)]);
var state_107411__$1 = state_107411;
var statearr_107449_107482 = state_107411__$1;
(statearr_107449_107482[(2)] = inst_107355);

(statearr_107449_107482[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__99975__auto__ = null;
var fluree$db$query$analytical$state_machine__99975__auto____0 = (function (){
var statearr_107450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107450[(0)] = fluree$db$query$analytical$state_machine__99975__auto__);

(statearr_107450[(1)] = (1));

return statearr_107450;
});
var fluree$db$query$analytical$state_machine__99975__auto____1 = (function (state_107411){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107451){if((e107451 instanceof Object)){
var ex__99978__auto__ = e107451;
var statearr_107452_107483 = state_107411;
(statearr_107452_107483[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107411);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107451;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107484 = state_107411;
state_107411 = G__107484;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__99975__auto__ = function(state_107411){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__99975__auto____1.call(this,state_107411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__99975__auto____0;
fluree$db$query$analytical$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__99975__auto____1;
return fluree$db$query$analytical$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107453 = f__100070__auto__.call(null);
(statearr_107453[(6)] = c__100069__auto__);

return statearr_107453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107541){
var state_val_107542 = (state_107541[(1)]);
if((state_val_107542 === (7))){
var inst_107505 = (state_107541[(2)]);
var state_107541__$1 = state_107541;
if(cljs.core.truth_(inst_107505)){
var statearr_107543_107575 = state_107541__$1;
(statearr_107543_107575[(1)] = (11));

} else {
var statearr_107544_107576 = state_107541__$1;
(statearr_107544_107576[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (20))){
var inst_107529 = (state_107541[(7)]);
var state_107541__$1 = state_107541;
var statearr_107545_107577 = state_107541__$1;
(statearr_107545_107577[(2)] = inst_107529);

(statearr_107545_107577[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (1))){
var state_107541__$1 = state_107541;
var statearr_107546_107578 = state_107541__$1;
(statearr_107546_107578[(2)] = null);

(statearr_107546_107578[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107541,(3),Error,null,(2));
var inst_107491 = (q_map == null);
var inst_107492 = cljs.core.not.call(null,inst_107491);
var state_107541__$1 = state_107541;
if(inst_107492){
var statearr_107547_107579 = state_107541__$1;
(statearr_107547_107579[(1)] = (5));

} else {
var statearr_107548_107580 = state_107541__$1;
(statearr_107548_107580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (15))){
var inst_107518 = (state_107541[(8)]);
var inst_107513 = (state_107541[(9)]);
var inst_107520 = cljs.core.pr_str.call(null,q_map);
var inst_107521 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_107520].join('');
var inst_107522 = fluree.db.util.log.warn.call(null,inst_107521);
var inst_107523 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_107513,inst_107518,fuel,max_fuel,opts);
var state_107541__$1 = (function (){var statearr_107549 = state_107541;
(statearr_107549[(10)] = inst_107522);

return statearr_107549;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107541__$1,(18),inst_107523);
} else {
if((state_val_107542 === (21))){
var inst_107537 = (state_107541[(2)]);
var state_107541__$1 = state_107541;
var statearr_107550_107581 = state_107541__$1;
(statearr_107550_107581[(2)] = inst_107537);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107541__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (13))){
var inst_107510 = (state_107541[(2)]);
var inst_107511 = cljs.core.get.call(null,inst_107510,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_107512 = cljs.core.get.call(null,inst_107510,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_107513 = cljs.core.get.call(null,inst_107510,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_107514 = cljs.core.get.call(null,inst_107510,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_107515 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_107512,q_map,inst_107511,fuel,max_fuel,opts);
var state_107541__$1 = (function (){var statearr_107551 = state_107541;
(statearr_107551[(9)] = inst_107513);

(statearr_107551[(11)] = inst_107514);

return statearr_107551;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107541__$1,(14),inst_107515);
} else {
if((state_val_107542 === (6))){
var state_107541__$1 = state_107541;
var statearr_107552_107582 = state_107541__$1;
(statearr_107552_107582[(2)] = false);

(statearr_107552_107582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (17))){
var inst_107514 = (state_107541[(11)]);
var inst_107529 = (state_107541[(2)]);
var state_107541__$1 = (function (){var statearr_107553 = state_107541;
(statearr_107553[(7)] = inst_107529);

return statearr_107553;
})();
if(cljs.core.truth_(inst_107514)){
var statearr_107554_107583 = state_107541__$1;
(statearr_107554_107583[(1)] = (19));

} else {
var statearr_107555_107584 = state_107541__$1;
(statearr_107555_107584[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (3))){
var inst_107485 = (state_107541[(2)]);
var state_107541__$1 = state_107541;
var statearr_107556_107585 = state_107541__$1;
(statearr_107556_107585[(2)] = inst_107485);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107541__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (12))){
var state_107541__$1 = state_107541;
var statearr_107557_107586 = state_107541__$1;
(statearr_107557_107586[(2)] = q_map);

(statearr_107557_107586[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (2))){
var inst_107539 = (state_107541[(2)]);
var state_107541__$1 = state_107541;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107541__$1,inst_107539);
} else {
if((state_val_107542 === (19))){
var inst_107529 = (state_107541[(7)]);
var inst_107514 = (state_107541[(11)]);
var inst_107531 = cljs.core.pr_str.call(null,q_map);
var inst_107532 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_107531].join('');
var inst_107533 = fluree.db.util.log.warn.call(null,inst_107532);
var inst_107534 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_107529,inst_107514,null);
var state_107541__$1 = (function (){var statearr_107558 = state_107541;
(statearr_107558[(12)] = inst_107533);

return statearr_107558;
})();
var statearr_107559_107587 = state_107541__$1;
(statearr_107559_107587[(2)] = inst_107534);

(statearr_107559_107587[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (11))){
var inst_107507 = cljs.core.apply.call(null,cljs.core.hash_map,q_map);
var state_107541__$1 = state_107541;
var statearr_107560_107588 = state_107541__$1;
(statearr_107560_107588[(2)] = inst_107507);

(statearr_107560_107588[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (9))){
var state_107541__$1 = state_107541;
var statearr_107561_107589 = state_107541__$1;
(statearr_107561_107589[(2)] = false);

(statearr_107561_107589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (5))){
var inst_107494 = q_map.cljs$lang$protocol_mask$partition0$;
var inst_107495 = (inst_107494 & (64));
var inst_107496 = q_map.cljs$core$ISeq$;
var inst_107497 = (cljs.core.PROTOCOL_SENTINEL === inst_107496);
var inst_107498 = ((inst_107495) || (inst_107497));
var state_107541__$1 = state_107541;
if(cljs.core.truth_(inst_107498)){
var statearr_107562_107590 = state_107541__$1;
(statearr_107562_107590[(1)] = (8));

} else {
var statearr_107563_107591 = state_107541__$1;
(statearr_107563_107591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (14))){
var inst_107513 = (state_107541[(9)]);
var inst_107517 = (state_107541[(2)]);
var inst_107518 = fluree.db.util.async.throw_err.call(null,inst_107517);
var state_107541__$1 = (function (){var statearr_107564 = state_107541;
(statearr_107564[(8)] = inst_107518);

return statearr_107564;
})();
if(cljs.core.truth_(inst_107513)){
var statearr_107565_107592 = state_107541__$1;
(statearr_107565_107592[(1)] = (15));

} else {
var statearr_107566_107593 = state_107541__$1;
(statearr_107566_107593[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (16))){
var inst_107518 = (state_107541[(8)]);
var state_107541__$1 = state_107541;
var statearr_107567_107594 = state_107541__$1;
(statearr_107567_107594[(2)] = inst_107518);

(statearr_107567_107594[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (10))){
var inst_107502 = (state_107541[(2)]);
var state_107541__$1 = state_107541;
var statearr_107568_107595 = state_107541__$1;
(statearr_107568_107595[(2)] = inst_107502);

(statearr_107568_107595[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (18))){
var inst_107525 = (state_107541[(2)]);
var inst_107526 = fluree.db.util.async.throw_err.call(null,inst_107525);
var state_107541__$1 = state_107541;
var statearr_107569_107596 = state_107541__$1;
(statearr_107569_107596[(2)] = inst_107526);

(statearr_107569_107596[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107542 === (8))){
var state_107541__$1 = state_107541;
var statearr_107570_107597 = state_107541__$1;
(statearr_107570_107597[(2)] = true);

(statearr_107570_107597[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__99975__auto____0 = (function (){
var statearr_107571 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107571[(0)] = fluree$db$query$analytical$q_$_state_machine__99975__auto__);

(statearr_107571[(1)] = (1));

return statearr_107571;
});
var fluree$db$query$analytical$q_$_state_machine__99975__auto____1 = (function (state_107541){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107541);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107572){if((e107572 instanceof Object)){
var ex__99978__auto__ = e107572;
var statearr_107573_107598 = state_107541;
(statearr_107573_107598[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107541);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107599 = state_107541;
state_107541 = G__107599;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__99975__auto__ = function(state_107541){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__99975__auto____1.call(this,state_107541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__99975__auto____0;
fluree$db$query$analytical$q_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__99975__auto____1;
return fluree$db$query$analytical$q_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107574 = f__100070__auto__.call(null);
(statearr_107574[(6)] = c__100069__auto__);

return statearr_107574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
