// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__105746_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105746_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__105750 = coll;
var vec__105751 = G__105750;
var seq__105752 = cljs.core.seq.call(null,vec__105751);
var first__105753 = cljs.core.first.call(null,seq__105752);
var seq__105752__$1 = cljs.core.next.call(null,seq__105752);
var clause = first__105753;
var r = seq__105752__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105750__$1 = G__105750;
var res__$1 = res;
while(true){
var vec__105757 = G__105750__$1;
var seq__105758 = cljs.core.seq.call(null,vec__105757);
var first__105759 = cljs.core.first.call(null,seq__105758);
var seq__105758__$1 = cljs.core.next.call(null,seq__105758);
var clause__$1 = first__105759;
var r__$1 = seq__105758__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__105760 = r__$1;
var G__105761 = cljs.core.conj.call(null,res__$2,clause__$1);
G__105750__$1 = G__105760;
res__$1 = G__105761;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__105765 = coll;
var vec__105766 = G__105765;
var seq__105767 = cljs.core.seq.call(null,vec__105766);
var first__105768 = cljs.core.first.call(null,seq__105767);
var seq__105767__$1 = cljs.core.next.call(null,seq__105767);
var clause = first__105768;
var r = seq__105767__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105765__$1 = G__105765;
var res__$1 = res;
while(true){
var vec__105772 = G__105765__$1;
var seq__105773 = cljs.core.seq.call(null,vec__105772);
var first__105774 = cljs.core.first.call(null,seq__105773);
var seq__105773__$1 = cljs.core.next.call(null,seq__105773);
var clause__$1 = first__105774;
var r__$1 = seq__105773__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__105775 = r__$1;
var G__105776 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__105765__$1 = G__105775;
res__$1 = G__105776;
continue;
} else {
var G__105777 = r__$1;
var G__105778 = res__$2;
G__105765__$1 = G__105777;
res__$1 = G__105778;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__105782 = coll;
var vec__105783 = G__105782;
var seq__105784 = cljs.core.seq.call(null,vec__105783);
var first__105785 = cljs.core.first.call(null,seq__105784);
var seq__105784__$1 = cljs.core.next.call(null,seq__105784);
var clause = first__105785;
var r = seq__105784__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__105782__$1 = G__105782;
var res__$1 = res;
while(true){
var vec__105789 = G__105782__$1;
var seq__105790 = cljs.core.seq.call(null,vec__105789);
var first__105791 = cljs.core.first.call(null,seq__105790);
var seq__105790__$1 = cljs.core.next.call(null,seq__105790);
var clause__$1 = first__105791;
var r__$1 = seq__105790__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__105792 = r__$1;
var G__105793 = res__$2;
G__105782__$1 = G__105792;
res__$1 = G__105793;
continue;
} else {
var G__105794 = r__$1;
var G__105795 = cljs.core.conj.call(null,res__$2,clause__$1);
G__105782__$1 = G__105794;
res__$1 = G__105795;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.call(null,["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.call(null,q_map)].join('')):null);
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__105799 = opts;
var map__105799__$1 = (((((!((map__105799 == null))))?(((((map__105799.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105799.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__105799):map__105799);
var limit = cljs.core.get.call(null,map__105799__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__105799__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__105799__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__105799__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__105799__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__105796_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105796_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__105797_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__105797_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__105798_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__105798_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105814){
var state_val_105815 = (state_105814[(1)]);
if((state_val_105815 === (1))){
var inst_105801 = fluree.db.util.core.url_encode.call(null,query);
var inst_105802 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_105801)].join('');
var inst_105803 = ["User-Agent","Accept"];
var inst_105804 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_105805 = cljs.core.PersistentHashMap.fromArrays(inst_105803,inst_105804);
var inst_105806 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_105807 = [inst_105805,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_105808 = cljs.core.PersistentHashMap.fromArrays(inst_105806,inst_105807);
var inst_105809 = fluree.db.util.xhttp.get.call(null,inst_105802,inst_105808);
var state_105814__$1 = state_105814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105814__$1,(2),inst_105809);
} else {
if((state_val_105815 === (2))){
var inst_105811 = (state_105814[(2)]);
var inst_105812 = fluree.db.util.async.throw_err.call(null,inst_105811);
var state_105814__$1 = state_105814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105814__$1,inst_105812);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0 = (function (){
var statearr_105816 = [null,null,null,null,null,null,null];
(statearr_105816[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__);

(statearr_105816[(1)] = (1));

return statearr_105816;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1 = (function (state_105814){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105817){if((e105817 instanceof Object)){
var ex__99978__auto__ = e105817;
var statearr_105818_105820 = state_105814;
(statearr_105818_105820[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105817;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105821 = state_105814;
state_105814 = G__105821;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__ = function(state_105814){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1.call(this,state_105814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105819 = f__100070__auto__.call(null);
(statearr_105819[(6)] = c__100069__auto__);

return statearr_105819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105839){
var state_val_105840 = (state_105839[(1)]);
if((state_val_105840 === (1))){
var inst_105822 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_105839__$1 = state_105839;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105839__$1,(2),inst_105822);
} else {
if((state_val_105840 === (2))){
var inst_105825 = (state_105839[(7)]);
var inst_105824 = (state_105839[(2)]);
var inst_105825__$1 = fluree.db.util.async.throw_err.call(null,inst_105824);
var inst_105826 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_105825__$1);
var inst_105827 = cljs.core.not_EQ_.call(null,(200),inst_105826);
var state_105839__$1 = (function (){var statearr_105841 = state_105839;
(statearr_105841[(7)] = inst_105825__$1);

return statearr_105841;
})();
if(inst_105827){
var statearr_105842_105850 = state_105839__$1;
(statearr_105842_105850[(1)] = (3));

} else {
var statearr_105843_105851 = state_105839__$1;
(statearr_105843_105851[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105840 === (3))){
var inst_105825 = (state_105839[(7)]);
var state_105839__$1 = state_105839;
var statearr_105844_105852 = state_105839__$1;
(statearr_105844_105852[(2)] = inst_105825);

(statearr_105844_105852[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105840 === (4))){
var inst_105825 = (state_105839[(7)]);
var inst_105830 = (function (){var body = inst_105825;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_105831 = cljs.core.second.call(null,inst_105825);
var inst_105832 = cljs.core.second.call(null,inst_105831);
var inst_105833 = cljs.core.first.call(null,inst_105832);
var inst_105834 = cljs.core.second.call(null,inst_105833);
var inst_105835 = cljs.core.mapv.call(null,inst_105830,inst_105834);
var state_105839__$1 = state_105839;
var statearr_105845_105853 = state_105839__$1;
(statearr_105845_105853[(2)] = inst_105835);

(statearr_105845_105853[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105840 === (5))){
var inst_105837 = (state_105839[(2)]);
var state_105839__$1 = state_105839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105839__$1,inst_105837);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0 = (function (){
var statearr_105846 = [null,null,null,null,null,null,null,null];
(statearr_105846[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__);

(statearr_105846[(1)] = (1));

return statearr_105846;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1 = (function (state_105839){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105847){if((e105847 instanceof Object)){
var ex__99978__auto__ = e105847;
var statearr_105848_105854 = state_105839;
(statearr_105848_105854[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105839);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105847;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105855 = state_105839;
state_105839 = G__105855;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__ = function(state_105839){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1.call(this,state_105839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105849 = f__100070__auto__.call(null);
(statearr_105849[(6)] = c__100069__auto__);

return statearr_105849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__105856_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105856_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__105857_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__105857_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__105858_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__105858_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_105893){
var state_val_105894 = (state_105893[(1)]);
if((state_val_105894 === (7))){
var inst_105868 = (state_105893[(2)]);
var inst_105869 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_105868,optional_clauses);
var inst_105870 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_105869);
var state_105893__$1 = state_105893;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_105893__$1,(8),inst_105870);
} else {
if((state_val_105894 === (1))){
var state_105893__$1 = state_105893;
var statearr_105895_105911 = state_105893__$1;
(statearr_105895_105911[(2)] = null);

(statearr_105895_105911[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_105893,(3),Error,null,(2));
var inst_105863 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_105893__$1 = state_105893;
if(inst_105863){
var statearr_105896_105912 = state_105893__$1;
(statearr_105896_105912[(1)] = (5));

} else {
var statearr_105897_105913 = state_105893__$1;
(statearr_105897_105913[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (6))){
var inst_105866 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_105893__$1 = state_105893;
var statearr_105898_105914 = state_105893__$1;
(statearr_105898_105914[(2)] = inst_105866);

(statearr_105898_105914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (3))){
var inst_105859 = (state_105893[(2)]);
var state_105893__$1 = state_105893;
var statearr_105899_105915 = state_105893__$1;
(statearr_105899_105915[(2)] = inst_105859);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105893__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (2))){
var inst_105891 = (state_105893[(2)]);
var state_105893__$1 = state_105893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_105893__$1,inst_105891);
} else {
if((state_val_105894 === (11))){
var inst_105889 = (state_105893[(2)]);
var state_105893__$1 = state_105893;
var statearr_105900_105916 = state_105893__$1;
(statearr_105900_105916[(2)] = inst_105889);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105893__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (9))){
var inst_105873 = (state_105893[(7)]);
var inst_105877 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_105873);
var inst_105878 = cljs.core.subs.call(null,inst_105877,(0),(1000));
var inst_105879 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_105880 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_105873);
var inst_105881 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_105873);
var inst_105882 = [inst_105880,inst_105881];
var inst_105883 = cljs.core.PersistentHashMap.fromArrays(inst_105879,inst_105882);
var inst_105884 = cljs.core.ex_info.call(null,inst_105878,inst_105883);
var inst_105885 = (function(){throw inst_105884})();
var state_105893__$1 = state_105893;
var statearr_105901_105917 = state_105893__$1;
(statearr_105901_105917[(2)] = inst_105885);

(statearr_105901_105917[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (5))){
var state_105893__$1 = state_105893;
var statearr_105902_105918 = state_105893__$1;
(statearr_105902_105918[(2)] = null);

(statearr_105902_105918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (10))){
var inst_105873 = (state_105893[(7)]);
var inst_105887 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_105873,all_vars);
var state_105893__$1 = state_105893;
var statearr_105903_105919 = state_105893__$1;
(statearr_105903_105919[(2)] = inst_105887);

(statearr_105903_105919[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_105894 === (8))){
var inst_105873 = (state_105893[(7)]);
var inst_105872 = (state_105893[(2)]);
var inst_105873__$1 = fluree.db.util.async.throw_err.call(null,inst_105872);
var inst_105874 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_105873__$1);
var inst_105875 = cljs.core._EQ_.call(null,(400),inst_105874);
var state_105893__$1 = (function (){var statearr_105904 = state_105893;
(statearr_105904[(7)] = inst_105873__$1);

return statearr_105904;
})();
if(inst_105875){
var statearr_105905_105920 = state_105893__$1;
(statearr_105905_105920[(1)] = (9));

} else {
var statearr_105906_105921 = state_105893__$1;
(statearr_105906_105921[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0 = (function (){
var statearr_105907 = [null,null,null,null,null,null,null,null];
(statearr_105907[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__);

(statearr_105907[(1)] = (1));

return statearr_105907;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1 = (function (state_105893){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_105893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e105908){if((e105908 instanceof Object)){
var ex__99978__auto__ = e105908;
var statearr_105909_105922 = state_105893;
(statearr_105909_105922[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_105893);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e105908;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__105923 = state_105893;
state_105893 = G__105923;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__ = function(state_105893){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1.call(this,state_105893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_105910 = f__100070__auto__.call(null);
(statearr_105910[(6)] = c__100069__auto__);

return statearr_105910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
