// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107622){
var state_val_107623 = (state_107622[(1)]);
if((state_val_107623 === (1))){
var state_107622__$1 = state_107622;
var statearr_107624_107631 = state_107622__$1;
(statearr_107624_107631[(2)] = null);

(statearr_107624_107631[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107623 === (2))){
var inst_107620 = (state_107622[(2)]);
var state_107622__$1 = state_107622;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107622__$1,inst_107620);
} else {
if((state_val_107623 === (3))){
var inst_107610 = (state_107622[(2)]);
var state_107622__$1 = state_107622;
var statearr_107625_107632 = state_107622__$1;
(statearr_107625_107632[(2)] = inst_107610);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107622__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107623 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107622,(3),Error,null,(2));
var inst_107614 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_107622__$1 = state_107622;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107622__$1,(5),inst_107614);
} else {
if((state_val_107623 === (5))){
var inst_107616 = (state_107622[(2)]);
var inst_107617 = fluree.db.util.async.throw_err.call(null,inst_107616);
var inst_107618 = cljs.core.keyword.call(null,inst_107617);
var state_107622__$1 = state_107622;
var statearr_107626_107633 = state_107622__$1;
(statearr_107626_107633[(2)] = inst_107618);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107622__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0 = (function (){
var statearr_107627 = [null,null,null,null,null,null,null];
(statearr_107627[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__);

(statearr_107627[(1)] = (1));

return statearr_107627;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1 = (function (state_107622){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107622);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107628){if((e107628 instanceof Object)){
var ex__99978__auto__ = e107628;
var statearr_107629_107634 = state_107622;
(statearr_107629_107634[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107622);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107628;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107635 = state_107622;
state_107622 = G__107635;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__ = function(state_107622){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1.call(this,state_107622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107630 = f__100070__auto__.call(null);
(statearr_107630[(6)] = c__100069__auto__);

return statearr_107630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107664){
var state_val_107665 = (state_107664[(1)]);
if((state_val_107665 === (7))){
var inst_107649 = (state_107664[(7)]);
var state_107664__$1 = state_107664;
var statearr_107666_107683 = state_107664__$1;
(statearr_107666_107683[(2)] = inst_107649);

(statearr_107666_107683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (1))){
var state_107664__$1 = state_107664;
var statearr_107667_107684 = state_107664__$1;
(statearr_107667_107684[(2)] = null);

(statearr_107667_107684[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107664,(3),Error,null,(2));
var inst_107641 = (function (){return (function (p1__107636_SHARP_){
return p1__107636_SHARP_.o;
});
})();
var inst_107642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107643 = [pred_id];
var inst_107644 = (new cljs.core.PersistentVector(null,1,(5),inst_107642,inst_107643,null));
var inst_107645 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_107644);
var state_107664__$1 = (function (){var statearr_107668 = state_107664;
(statearr_107668[(8)] = inst_107641);

return statearr_107668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107664__$1,(5),inst_107645);
} else {
if((state_val_107665 === (6))){
var inst_107649 = (state_107664[(7)]);
var inst_107651 = cljs.core.empty_QMARK_.call(null,inst_107649);
var inst_107652 = (!(inst_107651));
var state_107664__$1 = state_107664;
var statearr_107669_107685 = state_107664__$1;
(statearr_107669_107685[(2)] = inst_107652);

(statearr_107669_107685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (3))){
var inst_107637 = (state_107664[(2)]);
var state_107664__$1 = state_107664;
var statearr_107670_107686 = state_107664__$1;
(statearr_107670_107686[(2)] = inst_107637);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107664__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (2))){
var inst_107662 = (state_107664[(2)]);
var state_107664__$1 = state_107664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107664__$1,inst_107662);
} else {
if((state_val_107665 === (11))){
var inst_107660 = (state_107664[(2)]);
var state_107664__$1 = state_107664;
var statearr_107671_107687 = state_107664__$1;
(statearr_107671_107687[(2)] = inst_107660);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107664__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (9))){
var inst_107649 = (state_107664[(7)]);
var inst_107657 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_107649);
var state_107664__$1 = state_107664;
var statearr_107672_107688 = state_107664__$1;
(statearr_107672_107688[(2)] = inst_107657);

(statearr_107672_107688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (5))){
var inst_107641 = (state_107664[(8)]);
var inst_107649 = (state_107664[(7)]);
var inst_107647 = (state_107664[(2)]);
var inst_107648 = fluree.db.util.async.throw_err.call(null,inst_107647);
var inst_107649__$1 = cljs.core.map.call(null,inst_107641,inst_107648);
var state_107664__$1 = (function (){var statearr_107673 = state_107664;
(statearr_107673[(7)] = inst_107649__$1);

return statearr_107673;
})();
if(cljs.core.truth_(inst_107649__$1)){
var statearr_107674_107689 = state_107664__$1;
(statearr_107674_107689[(1)] = (6));

} else {
var statearr_107675_107690 = state_107664__$1;
(statearr_107675_107690[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (10))){
var state_107664__$1 = state_107664;
var statearr_107676_107691 = state_107664__$1;
(statearr_107676_107691[(2)] = true);

(statearr_107676_107691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107665 === (8))){
var inst_107655 = (state_107664[(2)]);
var state_107664__$1 = state_107664;
if(cljs.core.truth_(inst_107655)){
var statearr_107677_107692 = state_107664__$1;
(statearr_107677_107692[(1)] = (9));

} else {
var statearr_107678_107693 = state_107664__$1;
(statearr_107678_107693[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_107679 = [null,null,null,null,null,null,null,null,null];
(statearr_107679[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__);

(statearr_107679[(1)] = (1));

return statearr_107679;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1 = (function (state_107664){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107680){if((e107680 instanceof Object)){
var ex__99978__auto__ = e107680;
var statearr_107681_107694 = state_107664;
(statearr_107681_107694[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107664);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107680;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107695 = state_107664;
state_107664 = G__107695;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__ = function(state_107664){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1.call(this,state_107664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107682 = f__100070__auto__.call(null);
(statearr_107682[(6)] = c__100069__auto__);

return statearr_107682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_107769){
var state_val_107770 = (state_107769[(1)]);
if((state_val_107770 === (7))){
var inst_107720 = (state_107769[(7)]);
var state_107769__$1 = state_107769;
var statearr_107771_107797 = state_107769__$1;
(statearr_107771_107797[(2)] = inst_107720);

(statearr_107771_107797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (1))){
var state_107769__$1 = state_107769;
var statearr_107772_107798 = state_107769__$1;
(statearr_107772_107798[(2)] = null);

(statearr_107772_107798[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_107769,(3),Error,null,(2));
var inst_107702 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_107703 = cljs.core.PersistentHashSet.EMPTY;
var inst_107704 = cljs.core.vals.call(null,tempids);
var inst_107705 = cljs.core.into.call(null,inst_107703,inst_107704);
var inst_107706 = (function (){var pred_flakes = inst_107702;
var is_new_QMARK_ = inst_107705;
return (function (p1__107696_SHARP_,p2__107697_SHARP_){
return cljs.core.assoc_in.call(null,p1__107696_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__107697_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__107697_SHARP_.s)));
});
})();
var inst_107707 = cljs.core.PersistentHashMap.EMPTY;
var inst_107708 = cljs.core.reduce.call(null,inst_107706,inst_107707,inst_107702);
var inst_107716 = cljs.core.seq.call(null,inst_107702);
var inst_107717 = cljs.core.first.call(null,inst_107716);
var inst_107718 = cljs.core.next.call(null,inst_107716);
var inst_107719 = inst_107702;
var inst_107720 = inst_107708;
var state_107769__$1 = (function (){var statearr_107773 = state_107769;
(statearr_107773[(8)] = inst_107719);

(statearr_107773[(9)] = inst_107718);

(statearr_107773[(7)] = inst_107720);

(statearr_107773[(10)] = inst_107717);

return statearr_107773;
})();
var statearr_107774_107799 = state_107769__$1;
(statearr_107774_107799[(2)] = null);

(statearr_107774_107799[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (15))){
var inst_107726 = (state_107769[(11)]);
var inst_107720 = (state_107769[(7)]);
var inst_107746 = (state_107769[(12)]);
var inst_107733 = (state_107769[(13)]);
var inst_107754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107755 = inst_107726.s;
var inst_107756 = [inst_107755,inst_107733,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_107757 = (new cljs.core.PersistentVector(null,3,(5),inst_107754,inst_107756,null));
var inst_107758 = cljs.core.assoc_in.call(null,inst_107720,inst_107757,inst_107746);
var state_107769__$1 = state_107769;
var statearr_107775_107800 = state_107769__$1;
(statearr_107775_107800[(2)] = inst_107758);

(statearr_107775_107800[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (13))){
var inst_107741 = (state_107769[(2)]);
var inst_107742 = fluree.db.util.async.throw_err.call(null,inst_107741);
var state_107769__$1 = state_107769;
var statearr_107776_107801 = state_107769__$1;
(statearr_107776_107801[(2)] = inst_107742);

(statearr_107776_107801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (6))){
var inst_107765 = (state_107769[(2)]);
var state_107769__$1 = state_107769;
var statearr_107777_107802 = state_107769__$1;
(statearr_107777_107802[(2)] = inst_107765);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107769__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (3))){
var inst_107698 = (state_107769[(2)]);
var state_107769__$1 = state_107769;
var statearr_107778_107803 = state_107769__$1;
(statearr_107778_107803[(2)] = inst_107698);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107769__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (12))){
var inst_107735 = (state_107769[(14)]);
var inst_107746 = (state_107769[(2)]);
var state_107769__$1 = (function (){var statearr_107779 = state_107769;
(statearr_107779[(12)] = inst_107746);

return statearr_107779;
})();
if(cljs.core.truth_(inst_107735)){
var statearr_107780_107804 = state_107769__$1;
(statearr_107780_107804[(1)] = (14));

} else {
var statearr_107781_107805 = state_107769__$1;
(statearr_107781_107805[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (2))){
var inst_107767 = (state_107769[(2)]);
var state_107769__$1 = state_107769;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_107769__$1,inst_107767);
} else {
if((state_val_107770 === (11))){
var inst_107726 = (state_107769[(11)]);
var inst_107744 = inst_107726.o;
var state_107769__$1 = state_107769;
var statearr_107782_107806 = state_107769__$1;
(statearr_107782_107806[(2)] = inst_107744);

(statearr_107782_107806[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (9))){
var inst_107763 = (state_107769[(2)]);
var state_107769__$1 = state_107769;
var statearr_107783_107807 = state_107769__$1;
(statearr_107783_107807[(2)] = inst_107763);

(statearr_107783_107807[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (5))){
var inst_107719 = (state_107769[(8)]);
var inst_107726 = (state_107769[(11)]);
var inst_107725 = cljs.core.seq.call(null,inst_107719);
var inst_107726__$1 = cljs.core.first.call(null,inst_107725);
var inst_107727 = cljs.core.next.call(null,inst_107725);
var inst_107728 = cljs.core.not.call(null,inst_107726__$1);
var state_107769__$1 = (function (){var statearr_107784 = state_107769;
(statearr_107784[(11)] = inst_107726__$1);

(statearr_107784[(15)] = inst_107727);

return statearr_107784;
})();
if(inst_107728){
var statearr_107785_107808 = state_107769__$1;
(statearr_107785_107808[(1)] = (7));

} else {
var statearr_107786_107809 = state_107769__$1;
(statearr_107786_107809[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (14))){
var inst_107726 = (state_107769[(11)]);
var inst_107720 = (state_107769[(7)]);
var inst_107746 = (state_107769[(12)]);
var inst_107733 = (state_107769[(13)]);
var inst_107748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_107749 = inst_107726.s;
var inst_107750 = [inst_107749,inst_107733,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_107751 = (new cljs.core.PersistentVector(null,3,(5),inst_107748,inst_107750,null));
var inst_107752 = cljs.core.assoc_in.call(null,inst_107720,inst_107751,inst_107746);
var state_107769__$1 = state_107769;
var statearr_107787_107810 = state_107769__$1;
(statearr_107787_107810[(2)] = inst_107752);

(statearr_107787_107810[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (16))){
var inst_107727 = (state_107769[(15)]);
var inst_107760 = (state_107769[(2)]);
var inst_107719 = inst_107727;
var inst_107720 = inst_107760;
var state_107769__$1 = (function (){var statearr_107788 = state_107769;
(statearr_107788[(8)] = inst_107719);

(statearr_107788[(7)] = inst_107720);

return statearr_107788;
})();
var statearr_107789_107811 = state_107769__$1;
(statearr_107789_107811[(2)] = null);

(statearr_107789_107811[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_107770 === (10))){
var inst_107726 = (state_107769[(11)]);
var inst_107738 = inst_107726.o;
var inst_107739 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_107738,db);
var state_107769__$1 = state_107769;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_107769__$1,(13),inst_107739);
} else {
if((state_val_107770 === (8))){
var inst_107726 = (state_107769[(11)]);
var inst_107733 = (state_107769[(13)]);
var inst_107731 = inst_107726.p;
var inst_107732 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_107731);
var inst_107733__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_107732);
var inst_107734 = inst_107726.op;
var inst_107735 = inst_107734 === false;
var inst_107736 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_107733__$1);
var state_107769__$1 = (function (){var statearr_107790 = state_107769;
(statearr_107790[(14)] = inst_107735);

(statearr_107790[(13)] = inst_107733__$1);

return statearr_107790;
})();
if(inst_107736){
var statearr_107791_107812 = state_107769__$1;
(statearr_107791_107812[(1)] = (10));

} else {
var statearr_107792_107813 = state_107769__$1;
(statearr_107792_107813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0 = (function (){
var statearr_107793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_107793[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__);

(statearr_107793[(1)] = (1));

return statearr_107793;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1 = (function (state_107769){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_107769);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e107794){if((e107794 instanceof Object)){
var ex__99978__auto__ = e107794;
var statearr_107795_107814 = state_107769;
(statearr_107795_107814[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_107769);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e107794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__107815 = state_107769;
state_107769 = G__107815;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__ = function(state_107769){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1.call(this,state_107769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_107796 = f__100070__auto__.call(null);
(statearr_107796[(6)] = c__100069__auto__);

return statearr_107796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__107817 = arguments.length;
switch (G__107817) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__107820 = arguments.length;
switch (G__107820) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108124){
var state_val_108125 = (state_108124[(1)]);
if((state_val_108125 === (65))){
var inst_107988 = (state_108124[(7)]);
var state_108124__$1 = state_108124;
var G__108126_108291 = inst_107988;
var G__108126_108292__$1 = (((G__108126_108291 instanceof cljs.core.Keyword))?G__108126_108291.fqn:null);
switch (G__108126_108292__$1) {
case "long":
var statearr_108127_108294 = state_108124__$1;
(statearr_108127_108294[(1)] = (69));


break;
case "bigint":
var statearr_108128_108295 = state_108124__$1;
(statearr_108128_108295[(1)] = (73));


break;
case "double":
var statearr_108129_108296 = state_108124__$1;
(statearr_108129_108296[(1)] = (77));


break;
case "float":
var statearr_108130_108297 = state_108124__$1;
(statearr_108130_108297[(1)] = (81));


break;
case "bigdec":
var statearr_108131_108298 = state_108124__$1;
(statearr_108131_108298[(1)] = (85));


break;
case "string":
var statearr_108132_108299 = state_108124__$1;
(statearr_108132_108299[(1)] = (89));


break;
case "instant":
var statearr_108133_108300 = state_108124__$1;
(statearr_108133_108300[(1)] = (93));


break;
default:
var statearr_108134_108301 = state_108124__$1;
(statearr_108134_108301[(1)] = (97));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (70))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108135_108302 = state_108124__$1;
(statearr_108135_108302[(2)] = inst_107955);

(statearr_108135_108302[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (62))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_107997 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108136_108303 = state_108124__$1;
(statearr_108136_108303[(2)] = inst_107997);

(statearr_108136_108303[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (74))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108137_108304 = state_108124__$1;
(statearr_108137_108304[(2)] = inst_107955);

(statearr_108137_108304[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (7))){
var inst_107844 = (state_108124[(10)]);
var state_108124__$1 = state_108124;
var statearr_108138_108305 = state_108124__$1;
(statearr_108138_108305[(2)] = inst_107844);

(statearr_108138_108305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (59))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108139_108306 = state_108124__$1;
(statearr_108139_108306[(2)] = inst_107955);

(statearr_108139_108306[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (86))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108140_108307 = state_108124__$1;
(statearr_108140_108307[(2)] = inst_107955);

(statearr_108140_108307[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (20))){
var inst_107879 = (state_108124[(11)]);
var state_108124__$1 = state_108124;
var statearr_108141_108308 = state_108124__$1;
(statearr_108141_108308[(2)] = inst_107879);

(statearr_108141_108308[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (72))){
var inst_108008 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108142_108309 = state_108124__$1;
(statearr_108142_108309[(2)] = inst_108008);

(statearr_108142_108309[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (58))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_107986 = (state_108124[(2)]);
var inst_107987__$1 = cljs.core.get.call(null,inst_107986,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_107988__$1 = cljs.core.get.call(null,inst_107986,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_107989 = cljs.core._EQ_.call(null,inst_107988__$1,inst_107987__$1);
var state_108124__$1 = (function (){var statearr_108143 = state_108124;
(statearr_108143[(9)] = inst_107987__$1);

(statearr_108143[(7)] = inst_107988__$1);

return statearr_108143;
})();
if(inst_107989){
var statearr_108144_108310 = state_108124__$1;
(statearr_108144_108310[(1)] = (59));

} else {
var statearr_108145_108311 = state_108124__$1;
(statearr_108145_108311[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (60))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_107992 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_107993 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,3,inst_107992,null);
var inst_107994 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_107993,null);
var inst_107995 = inst_107994.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107995)){
var statearr_108146_108312 = state_108124__$1;
(statearr_108146_108312[(1)] = (62));

} else {
var statearr_108147_108313 = state_108124__$1;
(statearr_108147_108313[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (27))){
var inst_107905 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108148_108314 = state_108124__$1;
(statearr_108148_108314[(2)] = inst_107905);

(statearr_108148_108314[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (1))){
var state_108124__$1 = state_108124;
var statearr_108149_108315 = state_108124__$1;
(statearr_108149_108315[(2)] = null);

(statearr_108149_108315[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (69))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108000 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_108001 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,2,inst_108000,null);
var inst_108002 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108001,null);
var inst_108003 = inst_108002.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108003)){
var statearr_108150_108316 = state_108124__$1;
(statearr_108150_108316[(1)] = (70));

} else {
var statearr_108151_108317 = state_108124__$1;
(statearr_108151_108317[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (101))){
var inst_107856 = (state_108124[(12)]);
var inst_108089 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_108090 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_108089);
var inst_108091 = inst_108090 === true;
var inst_108092 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_108093 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_108092);
var inst_108094 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_108093);
var inst_108095 = (!(inst_108094));
var inst_108096 = ((inst_108091) && (inst_108095));
var state_108124__$1 = state_108124;
var statearr_108152_108318 = state_108124__$1;
(statearr_108152_108318[(2)] = inst_108096);

(statearr_108152_108318[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (24))){
var inst_107856 = (state_108124[(12)]);
var inst_107909 = (state_108124[(13)]);
var inst_107908 = (state_108124[(2)]);
var inst_107909__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108153 = state_108124;
(statearr_108153[(14)] = inst_107908);

(statearr_108153[(13)] = inst_107909__$1);

return statearr_108153;
})();
if(cljs.core.truth_(inst_107909__$1)){
var statearr_108154_108319 = state_108124__$1;
(statearr_108154_108319[(1)] = (28));

} else {
var statearr_108155_108320 = state_108124__$1;
(statearr_108155_108320[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (102))){
var inst_108087 = (state_108124[(15)]);
var state_108124__$1 = state_108124;
var statearr_108156_108321 = state_108124__$1;
(statearr_108156_108321[(2)] = inst_108087);

(statearr_108156_108321[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (55))){
var inst_107978 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108157_108322 = state_108124__$1;
(statearr_108157_108322[(2)] = inst_107978);

(statearr_108157_108322[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (85))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108040 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_108041 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,5,inst_108040,null);
var inst_108042 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108041,null);
var inst_108043 = inst_108042.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108043)){
var statearr_108158_108323 = state_108124__$1;
(statearr_108158_108323[(1)] = (86));

} else {
var statearr_108159_108324 = state_108124__$1;
(statearr_108159_108324[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (39))){
var inst_107924 = (state_108124[(16)]);
var state_108124__$1 = state_108124;
var statearr_108160_108325 = state_108124__$1;
(statearr_108160_108325[(2)] = inst_107924);

(statearr_108160_108325[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (88))){
var inst_108048 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108161_108326 = state_108124__$1;
(statearr_108161_108326[(2)] = inst_108048);

(statearr_108161_108326[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (46))){
var inst_107962 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107962)){
var statearr_108162_108327 = state_108124__$1;
(statearr_108162_108327[(1)] = (47));

} else {
var statearr_108163_108328 = state_108124__$1;
(statearr_108163_108328[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108124,(3),Error,null,(2));
var inst_107838 = cljs.core.seq.call(null,pred_changes);
var inst_107839 = cljs.core.first.call(null,inst_107838);
var inst_107840 = cljs.core.next.call(null,inst_107838);
var inst_107841 = cljs.core.nth.call(null,inst_107839,(0),null);
var inst_107842 = cljs.core.nth.call(null,inst_107839,(1),null);
var inst_107843 = pred_changes;
var inst_107844 = db;
var state_108124__$1 = (function (){var statearr_108164 = state_108124;
(statearr_108164[(10)] = inst_107844);

(statearr_108164[(17)] = inst_107841);

(statearr_108164[(18)] = inst_107842);

(statearr_108164[(19)] = inst_107843);

(statearr_108164[(20)] = inst_107840);

return statearr_108164;
})();
var statearr_108165_108329 = state_108124__$1;
(statearr_108165_108329[(2)] = null);

(statearr_108165_108329[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (77))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108020 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_108021 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,3,inst_108020,null);
var inst_108022 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108021,null);
var inst_108023 = inst_108022.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108023)){
var statearr_108166_108330 = state_108124__$1;
(statearr_108166_108330[(1)] = (78));

} else {
var statearr_108167_108331 = state_108124__$1;
(statearr_108167_108331[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (106))){
var inst_107854 = (state_108124[(21)]);
var inst_108115 = (state_108124[(2)]);
var inst_107843 = inst_107854;
var inst_107844 = inst_108115;
var state_108124__$1 = (function (){var statearr_108168 = state_108124;
(statearr_108168[(10)] = inst_107844);

(statearr_108168[(19)] = inst_107843);

return statearr_108168;
})();
var statearr_108169_108332 = state_108124__$1;
(statearr_108169_108332[(2)] = null);

(statearr_108169_108332[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (95))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108066 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108170_108333 = state_108124__$1;
(statearr_108170_108333[(2)] = inst_108066);

(statearr_108170_108333[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (54))){
var state_108124__$1 = state_108124;
var statearr_108171_108334 = state_108124__$1;
(statearr_108171_108334[(2)] = false);

(statearr_108171_108334[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (92))){
var inst_108058 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108172_108335 = state_108124__$1;
(statearr_108172_108335[(2)] = inst_108058);

(statearr_108172_108335[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (104))){
var state_108124__$1 = state_108124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_108173_108336 = state_108124__$1;
(statearr_108173_108336[(1)] = (107));

} else {
var statearr_108174_108337 = state_108124__$1;
(statearr_108174_108337[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (15))){
var inst_107856 = (state_108124[(12)]);
var inst_107877 = (state_108124[(22)]);
var inst_107876 = (state_108124[(2)]);
var inst_107877__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108175 = state_108124;
(statearr_108175[(22)] = inst_107877__$1);

(statearr_108175[(23)] = inst_107876);

return statearr_108175;
})();
if(cljs.core.truth_(inst_107877__$1)){
var statearr_108176_108338 = state_108124__$1;
(statearr_108176_108338[(1)] = (16));

} else {
var statearr_108177_108339 = state_108124__$1;
(statearr_108177_108339[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (48))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108178_108340 = state_108124__$1;
(statearr_108178_108340[(2)] = inst_107955);

(statearr_108178_108340[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (50))){
var inst_107965 = (state_108124[(24)]);
var inst_107970 = inst_107965.cljs$lang$protocol_mask$partition0$;
var inst_107971 = (inst_107970 & (64));
var inst_107972 = inst_107965.cljs$core$ISeq$;
var inst_107973 = (cljs.core.PROTOCOL_SENTINEL === inst_107972);
var inst_107974 = ((inst_107971) || (inst_107973));
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107974)){
var statearr_108179_108341 = state_108124__$1;
(statearr_108179_108341[(1)] = (53));

} else {
var statearr_108180_108342 = state_108124__$1;
(statearr_108180_108342[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (75))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108016 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108181_108343 = state_108124__$1;
(statearr_108181_108343[(2)] = inst_108016);

(statearr_108181_108343[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (99))){
var state_108124__$1 = state_108124;
var statearr_108182_108344 = state_108124__$1;
(statearr_108182_108344[(2)] = false);

(statearr_108182_108344[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (21))){
var inst_107892 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108183_108345 = state_108124__$1;
(statearr_108183_108345[(2)] = inst_107892);

(statearr_108183_108345[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (31))){
var inst_107908 = (state_108124[(14)]);
var inst_107921 = fluree.db.query.schema.type_error.call(null,inst_107908,"a component","a non-component",throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108184_108346 = state_108124__$1;
(statearr_108184_108346[(2)] = inst_107921);

(statearr_108184_108346[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (32))){
var inst_107908 = (state_108124[(14)]);
var state_108124__$1 = state_108124;
var statearr_108185_108347 = state_108124__$1;
(statearr_108185_108347[(2)] = inst_107908);

(statearr_108185_108347[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (40))){
var inst_107856 = (state_108124[(12)]);
var inst_107956 = (state_108124[(25)]);
var inst_107955 = (state_108124[(2)]);
var inst_107956__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108186 = state_108124;
(statearr_108186[(25)] = inst_107956__$1);

(statearr_108186[(8)] = inst_107955);

return statearr_108186;
})();
if(cljs.core.truth_(inst_107956__$1)){
var statearr_108187_108348 = state_108124__$1;
(statearr_108187_108348[(1)] = (44));

} else {
var statearr_108188_108349 = state_108124__$1;
(statearr_108188_108349[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (91))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108056 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108189_108350 = state_108124__$1;
(statearr_108189_108350[(2)] = inst_108056);

(statearr_108189_108350[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (108))){
var inst_108083 = (state_108124[(26)]);
var state_108124__$1 = state_108124;
var statearr_108190_108351 = state_108124__$1;
(statearr_108190_108351[(2)] = inst_108083);

(statearr_108190_108351[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (56))){
var inst_107965 = (state_108124[(24)]);
var inst_107983 = cljs.core.apply.call(null,cljs.core.hash_map,inst_107965);
var state_108124__$1 = state_108124;
var statearr_108191_108352 = state_108124__$1;
(statearr_108191_108352[(2)] = inst_107983);

(statearr_108191_108352[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (33))){
var inst_107856 = (state_108124[(12)]);
var inst_107925 = (state_108124[(27)]);
var inst_107924 = (state_108124[(2)]);
var inst_107925__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108192 = state_108124;
(statearr_108192[(16)] = inst_107924);

(statearr_108192[(27)] = inst_107925__$1);

return statearr_108192;
})();
if(cljs.core.truth_(inst_107925__$1)){
var statearr_108193_108353 = state_108124__$1;
(statearr_108193_108353[(1)] = (34));

} else {
var statearr_108194_108354 = state_108124__$1;
(statearr_108194_108354[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (13))){
var inst_107844 = (state_108124[(10)]);
var inst_107873 = fluree.db.query.schema.type_error.call(null,inst_107844,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108195_108355 = state_108124__$1;
(statearr_108195_108355[(2)] = inst_107873);

(statearr_108195_108355[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (22))){
var state_108124__$1 = state_108124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_108196_108356 = state_108124__$1;
(statearr_108196_108356[(1)] = (25));

} else {
var statearr_108197_108357 = state_108124__$1;
(statearr_108197_108357[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (90))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108198_108358 = state_108124__$1;
(statearr_108198_108358[(2)] = inst_107955);

(statearr_108198_108358[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (109))){
var inst_108112 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108199_108359 = state_108124__$1;
(statearr_108199_108359[(2)] = inst_108112);

(statearr_108199_108359[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (36))){
var inst_107940 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107940)){
var statearr_108200_108360 = state_108124__$1;
(statearr_108200_108360[(1)] = (38));

} else {
var statearr_108201_108361 = state_108124__$1;
(statearr_108201_108361[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (41))){
var inst_107844 = (state_108124[(10)]);
var inst_107855 = (state_108124[(28)]);
var inst_107943 = fluree.db.dbproto._p_prop.call(null,inst_107844,new cljs.core.Keyword(null,"name","name",1843675177),inst_107855);
var inst_107944 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_107943)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_107945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_107946 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_107947 = cljs.core.PersistentHashMap.fromArrays(inst_107945,inst_107946);
var inst_107948 = cljs.core.ex_info.call(null,inst_107944,inst_107947);
var inst_107949 = (function(){throw inst_107948})();
var state_108124__$1 = state_108124;
var statearr_108202_108362 = state_108124__$1;
(statearr_108202_108362[(2)] = inst_107949);

(statearr_108202_108362[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (89))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108050 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_108051 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,5,inst_108050,null);
var inst_108052 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108051,null);
var inst_108053 = inst_108052.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108053)){
var statearr_108203_108363 = state_108124__$1;
(statearr_108203_108363[(1)] = (90));

} else {
var statearr_108204_108364 = state_108124__$1;
(statearr_108204_108364[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (100))){
var inst_108102 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108102)){
var statearr_108205_108365 = state_108124__$1;
(statearr_108205_108365[(1)] = (104));

} else {
var statearr_108206_108366 = state_108124__$1;
(statearr_108206_108366[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (43))){
var inst_107952 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108207_108367 = state_108124__$1;
(statearr_108207_108367[(2)] = inst_107952);

(statearr_108207_108367[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (61))){
var inst_108080 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108208_108368 = state_108124__$1;
(statearr_108208_108368[(2)] = inst_108080);

(statearr_108208_108368[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (29))){
var inst_107909 = (state_108124[(13)]);
var state_108124__$1 = state_108124;
var statearr_108209_108369 = state_108124__$1;
(statearr_108209_108369[(2)] = inst_107909);

(statearr_108209_108369[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (44))){
var inst_107856 = (state_108124[(12)]);
var inst_107958 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107959 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_107958);
var state_108124__$1 = state_108124;
var statearr_108210_108370 = state_108124__$1;
(statearr_108210_108370[(2)] = inst_107959);

(statearr_108210_108370[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (93))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108060 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_108061 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,2,inst_108060,null);
var inst_108062 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108061,null);
var inst_108063 = inst_108062.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108063)){
var statearr_108211_108371 = state_108124__$1;
(statearr_108211_108371[(1)] = (94));

} else {
var statearr_108212_108372 = state_108124__$1;
(statearr_108212_108372[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (6))){
var inst_108120 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108213_108373 = state_108124__$1;
(statearr_108213_108373[(2)] = inst_108120);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108124__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (28))){
var inst_107856 = (state_108124[(12)]);
var inst_107911 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107912 = cljs.core.not.call(null,inst_107911);
var inst_107913 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107914 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_107913);
var inst_107915 = inst_107914 === true;
var inst_107916 = ((inst_107912) && (inst_107915));
var state_108124__$1 = state_108124;
var statearr_108214_108374 = state_108124__$1;
(statearr_108214_108374[(2)] = inst_107916);

(statearr_108214_108374[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (64))){
var inst_108078 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108215_108375 = state_108124__$1;
(statearr_108215_108375[(2)] = inst_108078);

(statearr_108215_108375[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (103))){
var inst_108099 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108216_108376 = state_108124__$1;
(statearr_108216_108376[(2)] = inst_108099);

(statearr_108216_108376[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (51))){
var state_108124__$1 = state_108124;
var statearr_108217_108377 = state_108124__$1;
(statearr_108217_108377[(2)] = false);

(statearr_108217_108377[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (25))){
var inst_107898 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_107899 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_107900 = cljs.core.PersistentHashMap.fromArrays(inst_107898,inst_107899);
var inst_107901 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_107900);
var inst_107902 = (function(){throw inst_107901})();
var state_108124__$1 = state_108124;
var statearr_108218_108378 = state_108124__$1;
(statearr_108218_108378[(2)] = inst_107902);

(statearr_108218_108378[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (34))){
var inst_107856 = (state_108124[(12)]);
var inst_107844 = (state_108124[(10)]);
var inst_107855 = (state_108124[(28)]);
var inst_107927 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107928 = cljs.core.not.call(null,inst_107927);
var inst_107929 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107930 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_107929);
var inst_107931 = inst_107930 === true;
var inst_107932 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_107844,inst_107855);
var state_108124__$1 = (function (){var statearr_108219 = state_108124;
(statearr_108219[(29)] = inst_107931);

(statearr_108219[(30)] = inst_107928);

return statearr_108219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108124__$1,(37),inst_107932);
} else {
if((state_val_108125 === (17))){
var inst_107877 = (state_108124[(22)]);
var state_108124__$1 = state_108124;
var statearr_108220_108379 = state_108124__$1;
(statearr_108220_108379[(2)] = inst_107877);

(statearr_108220_108379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (3))){
var inst_107821 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108221_108380 = state_108124__$1;
(statearr_108221_108380[(2)] = inst_107821);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108124__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (12))){
var inst_107871 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107871)){
var statearr_108222_108381 = state_108124__$1;
(statearr_108222_108381[(1)] = (13));

} else {
var statearr_108223_108382 = state_108124__$1;
(statearr_108223_108382[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (2))){
var inst_108122 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108124__$1,inst_108122);
} else {
if((state_val_108125 === (66))){
var state_108124__$1 = state_108124;
var statearr_108224_108383 = state_108124__$1;
(statearr_108224_108383[(2)] = null);

(statearr_108224_108383[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (107))){
var inst_108105 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_108106 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_108107 = cljs.core.PersistentHashMap.fromArrays(inst_108105,inst_108106);
var inst_108108 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_108107);
var inst_108109 = (function(){throw inst_108108})();
var state_108124__$1 = state_108124;
var statearr_108225_108384 = state_108124__$1;
(statearr_108225_108384[(2)] = inst_108109);

(statearr_108225_108384[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (23))){
var inst_107876 = (state_108124[(23)]);
var state_108124__$1 = state_108124;
var statearr_108226_108385 = state_108124__$1;
(statearr_108226_108385[(2)] = inst_107876);

(statearr_108226_108385[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (47))){
var inst_107856 = (state_108124[(12)]);
var inst_107965 = (state_108124[(24)]);
var inst_107965__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107967 = (inst_107965__$1 == null);
var inst_107968 = cljs.core.not.call(null,inst_107967);
var state_108124__$1 = (function (){var statearr_108227 = state_108124;
(statearr_108227[(24)] = inst_107965__$1);

return statearr_108227;
})();
if(inst_107968){
var statearr_108228_108386 = state_108124__$1;
(statearr_108228_108386[(1)] = (50));

} else {
var statearr_108229_108387 = state_108124__$1;
(statearr_108229_108387[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (35))){
var inst_107925 = (state_108124[(27)]);
var state_108124__$1 = state_108124;
var statearr_108230_108388 = state_108124__$1;
(statearr_108230_108388[(2)] = inst_107925);

(statearr_108230_108388[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (82))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108231_108389 = state_108124__$1;
(statearr_108231_108389[(2)] = inst_107955);

(statearr_108231_108389[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (76))){
var inst_108018 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108232_108390 = state_108124__$1;
(statearr_108232_108390[(2)] = inst_108018);

(statearr_108232_108390[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (97))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108070 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108233_108391 = state_108124__$1;
(statearr_108233_108391[(2)] = inst_108070);

(statearr_108233_108391[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (19))){
var inst_107856 = (state_108124[(12)]);
var inst_107881 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107882 = inst_107881 === true;
var inst_107883 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107884 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_107883);
var inst_107885 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_107884);
var inst_107886 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107887 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_107886);
var inst_107888 = inst_107887 === true;
var inst_107889 = ((inst_107882) && (inst_107885) && (inst_107888));
var state_108124__$1 = state_108124;
var statearr_108234_108392 = state_108124__$1;
(statearr_108234_108392[(2)] = inst_107889);

(statearr_108234_108392[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (57))){
var inst_107965 = (state_108124[(24)]);
var state_108124__$1 = state_108124;
var statearr_108235_108393 = state_108124__$1;
(statearr_108235_108393[(2)] = inst_107965);

(statearr_108235_108393[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (68))){
var inst_108073 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108236_108394 = state_108124__$1;
(statearr_108236_108394[(2)] = inst_108073);

(statearr_108236_108394[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (11))){
var inst_107860 = (state_108124[(31)]);
var state_108124__$1 = state_108124;
var statearr_108237_108395 = state_108124__$1;
(statearr_108237_108395[(2)] = inst_107860);

(statearr_108237_108395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (9))){
var inst_108118 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108238_108396 = state_108124__$1;
(statearr_108238_108396[(2)] = inst_108118);

(statearr_108238_108396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (5))){
var inst_107855 = (state_108124[(28)]);
var inst_107843 = (state_108124[(19)]);
var inst_107852 = cljs.core.seq.call(null,inst_107843);
var inst_107853 = cljs.core.first.call(null,inst_107852);
var inst_107854 = cljs.core.next.call(null,inst_107852);
var inst_107855__$1 = cljs.core.nth.call(null,inst_107853,(0),null);
var inst_107856 = cljs.core.nth.call(null,inst_107853,(1),null);
var inst_107857 = cljs.core.not.call(null,inst_107855__$1);
var state_108124__$1 = (function (){var statearr_108239 = state_108124;
(statearr_108239[(12)] = inst_107856);

(statearr_108239[(21)] = inst_107854);

(statearr_108239[(28)] = inst_107855__$1);

return statearr_108239;
})();
if(inst_107857){
var statearr_108240_108397 = state_108124__$1;
(statearr_108240_108397[(1)] = (7));

} else {
var statearr_108241_108398 = state_108124__$1;
(statearr_108241_108398[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (83))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108036 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108242_108399 = state_108124__$1;
(statearr_108242_108399[(2)] = inst_108036);

(statearr_108242_108399[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (14))){
var inst_107844 = (state_108124[(10)]);
var state_108124__$1 = state_108124;
var statearr_108243_108400 = state_108124__$1;
(statearr_108243_108400[(2)] = inst_107844);

(statearr_108243_108400[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (45))){
var inst_107956 = (state_108124[(25)]);
var state_108124__$1 = state_108124;
var statearr_108244_108401 = state_108124__$1;
(statearr_108244_108401[(2)] = inst_107956);

(statearr_108244_108401[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (53))){
var state_108124__$1 = state_108124;
var statearr_108245_108402 = state_108124__$1;
(statearr_108245_108402[(2)] = true);

(statearr_108245_108402[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (78))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108246_108403 = state_108124__$1;
(statearr_108246_108403[(2)] = inst_107955);

(statearr_108246_108403[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (26))){
var inst_107876 = (state_108124[(23)]);
var state_108124__$1 = state_108124;
var statearr_108247_108404 = state_108124__$1;
(statearr_108247_108404[(2)] = inst_107876);

(statearr_108247_108404[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (16))){
var inst_107856 = (state_108124[(12)]);
var inst_107879 = (state_108124[(11)]);
var inst_107879__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108248 = state_108124;
(statearr_108248[(11)] = inst_107879__$1);

return statearr_108248;
})();
if(cljs.core.truth_(inst_107879__$1)){
var statearr_108249_108405 = state_108124__$1;
(statearr_108249_108405[(1)] = (19));

} else {
var statearr_108250_108406 = state_108124__$1;
(statearr_108250_108406[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (81))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108030 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_108031 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,3,inst_108030,null);
var inst_108032 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108031,null);
var inst_108033 = inst_108032.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108033)){
var statearr_108251_108407 = state_108124__$1;
(statearr_108251_108407[(1)] = (82));

} else {
var statearr_108252_108408 = state_108124__$1;
(statearr_108252_108408[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (79))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108026 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108253_108409 = state_108124__$1;
(statearr_108253_108409[(2)] = inst_108026);

(statearr_108253_108409[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (38))){
var state_108124__$1 = state_108124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_108254_108410 = state_108124__$1;
(statearr_108254_108410[(1)] = (41));

} else {
var statearr_108255_108411 = state_108124__$1;
(statearr_108255_108411[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (98))){
var inst_108087 = (state_108124[(15)]);
var inst_107856 = (state_108124[(12)]);
var inst_108087__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108256 = state_108124;
(statearr_108256[(15)] = inst_108087__$1);

return statearr_108256;
})();
if(cljs.core.truth_(inst_108087__$1)){
var statearr_108257_108412 = state_108124__$1;
(statearr_108257_108412[(1)] = (101));

} else {
var statearr_108258_108413 = state_108124__$1;
(statearr_108258_108413[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (87))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108046 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108259_108414 = state_108124__$1;
(statearr_108259_108414[(2)] = inst_108046);

(statearr_108259_108414[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (30))){
var inst_107919 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107919)){
var statearr_108260_108415 = state_108124__$1;
(statearr_108260_108415[(1)] = (31));

} else {
var statearr_108261_108416 = state_108124__$1;
(statearr_108261_108416[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (73))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108010 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_108011 = inst_107988.call(null,cljs.core.PersistentArrayMap,null,3,inst_108010,null);
var inst_108012 = inst_107988.call(null,cljs.core.PersistentHashSet,null,inst_108011,null);
var inst_108013 = inst_108012.call(null,inst_107987);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_108013)){
var statearr_108262_108417 = state_108124__$1;
(statearr_108262_108417[(1)] = (74));

} else {
var statearr_108263_108418 = state_108124__$1;
(statearr_108263_108418[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (96))){
var inst_108068 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108264_108419 = state_108124__$1;
(statearr_108264_108419[(2)] = inst_108068);

(statearr_108264_108419[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (10))){
var inst_107856 = (state_108124[(12)]);
var inst_107862 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107863 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_107862);
var inst_107864 = inst_107863 === false;
var inst_107865 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_107866 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_107865);
var inst_107867 = inst_107866 === true;
var inst_107868 = ((inst_107864) && (inst_107867));
var state_108124__$1 = state_108124;
var statearr_108265_108420 = state_108124__$1;
(statearr_108265_108420[(2)] = inst_107868);

(statearr_108265_108420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (18))){
var inst_107895 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107895)){
var statearr_108266_108421 = state_108124__$1;
(statearr_108266_108421[(1)] = (22));

} else {
var statearr_108267_108422 = state_108124__$1;
(statearr_108267_108422[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (105))){
var inst_108083 = (state_108124[(26)]);
var state_108124__$1 = state_108124;
var statearr_108268_108423 = state_108124__$1;
(statearr_108268_108423[(2)] = inst_108083);

(statearr_108268_108423[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (52))){
var inst_107981 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
if(cljs.core.truth_(inst_107981)){
var statearr_108269_108424 = state_108124__$1;
(statearr_108269_108424[(1)] = (56));

} else {
var statearr_108270_108425 = state_108124__$1;
(statearr_108270_108425[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (67))){
var inst_108076 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108271_108426 = state_108124__$1;
(statearr_108271_108426[(2)] = inst_108076);

(statearr_108271_108426[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (71))){
var inst_107987 = (state_108124[(9)]);
var inst_107988 = (state_108124[(7)]);
var inst_108006 = fluree.db.query.schema.type_error.call(null,inst_107987,inst_107988,throw_QMARK_);
var state_108124__$1 = state_108124;
var statearr_108272_108427 = state_108124__$1;
(statearr_108272_108427[(2)] = inst_108006);

(statearr_108272_108427[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (42))){
var inst_107924 = (state_108124[(16)]);
var state_108124__$1 = state_108124;
var statearr_108273_108428 = state_108124__$1;
(statearr_108273_108428[(2)] = inst_107924);

(statearr_108273_108428[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (80))){
var inst_108028 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108274_108429 = state_108124__$1;
(statearr_108274_108429[(2)] = inst_108028);

(statearr_108274_108429[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (37))){
var inst_107931 = (state_108124[(29)]);
var inst_107928 = (state_108124[(30)]);
var inst_107934 = (state_108124[(2)]);
var inst_107935 = fluree.db.util.async.throw_err.call(null,inst_107934);
var inst_107936 = cljs.core.not.call(null,inst_107935);
var inst_107937 = ((inst_107928) && (inst_107931) && (inst_107936));
var state_108124__$1 = state_108124;
var statearr_108275_108430 = state_108124__$1;
(statearr_108275_108430[(2)] = inst_107937);

(statearr_108275_108430[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (63))){
var state_108124__$1 = state_108124;
var statearr_108276_108431 = state_108124__$1;
(statearr_108276_108431[(1)] = (65));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (94))){
var inst_107955 = (state_108124[(8)]);
var state_108124__$1 = state_108124;
var statearr_108278_108432 = state_108124__$1;
(statearr_108278_108432[(2)] = inst_107955);

(statearr_108278_108432[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (8))){
var inst_107856 = (state_108124[(12)]);
var inst_107860 = (state_108124[(31)]);
var inst_107860__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_107856);
var state_108124__$1 = (function (){var statearr_108279 = state_108124;
(statearr_108279[(31)] = inst_107860__$1);

return statearr_108279;
})();
if(cljs.core.truth_(inst_107860__$1)){
var statearr_108280_108433 = state_108124__$1;
(statearr_108280_108433[(1)] = (10));

} else {
var statearr_108281_108434 = state_108124__$1;
(statearr_108281_108434[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (49))){
var inst_107856 = (state_108124[(12)]);
var inst_108083 = (state_108124[(2)]);
var inst_108084 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_107856);
var inst_108085 = inst_108084 === true;
var state_108124__$1 = (function (){var statearr_108282 = state_108124;
(statearr_108282[(26)] = inst_108083);

return statearr_108282;
})();
if(cljs.core.truth_(inst_108085)){
var statearr_108283_108435 = state_108124__$1;
(statearr_108283_108435[(1)] = (98));

} else {
var statearr_108284_108436 = state_108124__$1;
(statearr_108284_108436[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108125 === (84))){
var inst_108038 = (state_108124[(2)]);
var state_108124__$1 = state_108124;
var statearr_108285_108437 = state_108124__$1;
(statearr_108285_108437[(2)] = inst_108038);

(statearr_108285_108437[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__99975__auto__ = null;
var fluree$db$query$schema$state_machine__99975__auto____0 = (function (){
var statearr_108286 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_108286[(0)] = fluree$db$query$schema$state_machine__99975__auto__);

(statearr_108286[(1)] = (1));

return statearr_108286;
});
var fluree$db$query$schema$state_machine__99975__auto____1 = (function (state_108124){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108287){if((e108287 instanceof Object)){
var ex__99978__auto__ = e108287;
var statearr_108288_108438 = state_108124;
(statearr_108288_108438[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108124);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108439 = state_108124;
state_108124 = G__108439;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__99975__auto__ = function(state_108124){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__99975__auto____1.call(this,state_108124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__99975__auto____0;
fluree$db$query$schema$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__99975__auto____1;
return fluree$db$query$schema$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108289 = f__100070__auto__.call(null);
(statearr_108289[(6)] = c__100069__auto__);

return statearr_108289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108460){
var state_val_108461 = (state_108460[(1)]);
if((state_val_108461 === (7))){
var inst_108447 = (state_108460[(7)]);
var inst_108451 = fluree.db.query.schema.predicate_change_error.call(null,inst_108447,db,true);
var state_108460__$1 = state_108460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108460__$1,(9),inst_108451);
} else {
if((state_val_108461 === (1))){
var state_108460__$1 = state_108460;
var statearr_108462_108474 = state_108460__$1;
(statearr_108462_108474[(2)] = null);

(statearr_108462_108474[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108461 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108460,(3),Error,null,(2));
var inst_108444 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_108460__$1 = state_108460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108460__$1,(5),inst_108444);
} else {
if((state_val_108461 === (6))){
var state_108460__$1 = state_108460;
var statearr_108463_108475 = state_108460__$1;
(statearr_108463_108475[(2)] = db);

(statearr_108463_108475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108461 === (3))){
var inst_108440 = (state_108460[(2)]);
var state_108460__$1 = state_108460;
var statearr_108464_108476 = state_108460__$1;
(statearr_108464_108476[(2)] = inst_108440);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108460__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108461 === (2))){
var inst_108458 = (state_108460[(2)]);
var state_108460__$1 = state_108460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108460__$1,inst_108458);
} else {
if((state_val_108461 === (9))){
var inst_108453 = (state_108460[(2)]);
var inst_108454 = fluree.db.util.async.throw_err.call(null,inst_108453);
var state_108460__$1 = state_108460;
var statearr_108465_108477 = state_108460__$1;
(statearr_108465_108477[(2)] = inst_108454);

(statearr_108465_108477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108461 === (5))){
var inst_108447 = (state_108460[(7)]);
var inst_108446 = (state_108460[(2)]);
var inst_108447__$1 = fluree.db.util.async.throw_err.call(null,inst_108446);
var inst_108448 = cljs.core.empty_QMARK_.call(null,inst_108447__$1);
var state_108460__$1 = (function (){var statearr_108466 = state_108460;
(statearr_108466[(7)] = inst_108447__$1);

return statearr_108466;
})();
if(inst_108448){
var statearr_108467_108478 = state_108460__$1;
(statearr_108467_108478[(1)] = (6));

} else {
var statearr_108468_108479 = state_108460__$1;
(statearr_108468_108479[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108461 === (8))){
var inst_108456 = (state_108460[(2)]);
var state_108460__$1 = state_108460;
var statearr_108469_108480 = state_108460__$1;
(statearr_108469_108480[(2)] = inst_108456);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108460__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0 = (function (){
var statearr_108470 = [null,null,null,null,null,null,null,null];
(statearr_108470[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__);

(statearr_108470[(1)] = (1));

return statearr_108470;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1 = (function (state_108460){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108471){if((e108471 instanceof Object)){
var ex__99978__auto__ = e108471;
var statearr_108472_108481 = state_108460;
(statearr_108472_108481[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108482 = state_108460;
state_108460 = G__108482;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__ = function(state_108460){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1.call(this,state_108460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108473 = f__100070__auto__.call(null);
(statearr_108473[(6)] = c__100069__auto__);

return statearr_108473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__108484 = arguments.length;
switch (G__108484) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__108486 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__108486,(0),null);
var ns = cljs.core.nth.call(null,vec__108486,(1),null);
var name = cljs.core.nth.call(null,vec__108486,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__108489_SHARP_,p2__108490_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__108489_SHARP_,p2__108490_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108553){
var state_val_108554 = (state_108553[(1)]);
if((state_val_108554 === (1))){
var state_108553__$1 = state_108553;
var statearr_108555_108565 = state_108553__$1;
(statearr_108555_108565[(2)] = null);

(statearr_108555_108565[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108554 === (2))){
var inst_108551 = (state_108553[(2)]);
var state_108553__$1 = state_108553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108553__$1,inst_108551);
} else {
if((state_val_108554 === (3))){
var inst_108496 = (state_108553[(2)]);
var state_108553__$1 = state_108553;
var statearr_108556_108566 = state_108553__$1;
(statearr_108556_108566[(2)] = inst_108496);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108554 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108553,(3),Error,null,(2));
var inst_108506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108507 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_108508 = [inst_108507];
var inst_108509 = (new cljs.core.PersistentVector(null,1,(5),inst_108506,inst_108508,null));
var inst_108510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108511 = [(0)];
var inst_108512 = (new cljs.core.PersistentVector(null,1,(5),inst_108510,inst_108511,null));
var inst_108513 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_108509,cljs.core._LT__EQ_,inst_108512);
var state_108553__$1 = state_108553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108553__$1,(5),inst_108513);
} else {
if((state_val_108554 === (5))){
var inst_108515 = (state_108553[(2)]);
var inst_108516 = fluree.db.util.async.throw_err.call(null,inst_108515);
var inst_108517 = (function (){var schema_flakes = inst_108516;
return (function (p1__108491_SHARP_){
return (p1__108491_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_108518 = cljs.core.partition_by.call(null,inst_108517,inst_108516);
var inst_108519 = cljs.core.nth.call(null,inst_108518,(0),null);
var inst_108520 = cljs.core.nth.call(null,inst_108518,(1),null);
var inst_108521 = (function (){var schema_flakes = inst_108516;
var vec__108500 = inst_108518;
var collection_flakes = inst_108519;
var predicate_flakes = inst_108520;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__108493_SHARP_,p2__108494_SHARP_){
return cljs.core.assoc.call(null,p1__108493_SHARP_,p2__108494_SHARP_.p,p2__108494_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_108522 = [(-1),"_tx"];
var inst_108523 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_108524 = ["_tx",(-1),(-1)];
var inst_108525 = cljs.core.PersistentHashMap.fromArrays(inst_108523,inst_108524);
var inst_108526 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_108527 = ["_tx",(-1),(-1)];
var inst_108528 = cljs.core.PersistentHashMap.fromArrays(inst_108526,inst_108527);
var inst_108529 = [inst_108525,inst_108528];
var inst_108530 = cljs.core.PersistentHashMap.fromArrays(inst_108522,inst_108529);
var inst_108531 = (function (){var schema_flakes = inst_108516;
var vec__108500 = inst_108518;
var collection_flakes = inst_108519;
var predicate_flakes = inst_108520;
return (function (p1__108492_SHARP_){
return p1__108492_SHARP_.s;
});
})();
var inst_108532 = cljs.core.partition_by.call(null,inst_108531,inst_108519);
var inst_108533 = cljs.core.reduce.call(null,inst_108521,inst_108530,inst_108532);
var inst_108535 = (function (){var schema_flakes = inst_108516;
var vec__108500 = inst_108518;
var collection_flakes = inst_108519;
var predicate_flakes = inst_108520;
var coll = inst_108533;
return (function (p__108534,pred_flakes){
var vec__108557 = p__108534;
var pred = cljs.core.nth.call(null,vec__108557,(0),null);
var fullText = cljs.core.nth.call(null,vec__108557,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_108536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108537 = cljs.core.PersistentHashMap.EMPTY;
var inst_108538 = cljs.core.PersistentHashSet.EMPTY;
var inst_108539 = [inst_108537,inst_108538];
var inst_108540 = (new cljs.core.PersistentVector(null,2,(5),inst_108536,inst_108539,null));
var inst_108541 = (function (){var schema_flakes = inst_108516;
var vec__108500 = inst_108518;
var collection_flakes = inst_108519;
var predicate_flakes = inst_108520;
var coll = inst_108533;
return (function (p1__108495_SHARP_){
return p1__108495_SHARP_.s;
});
})();
var inst_108542 = cljs.core.partition_by.call(null,inst_108541,inst_108520);
var inst_108543 = cljs.core.reduce.call(null,inst_108535,inst_108540,inst_108542);
var inst_108544 = cljs.core.nth.call(null,inst_108543,(0),null);
var inst_108545 = cljs.core.nth.call(null,inst_108543,(1),null);
var inst_108546 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_108547 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_108548 = [inst_108547,inst_108533,inst_108544,inst_108545];
var inst_108549 = cljs.core.PersistentHashMap.fromArrays(inst_108546,inst_108548);
var state_108553__$1 = state_108553;
var statearr_108560_108567 = state_108553__$1;
(statearr_108560_108567[(2)] = inst_108549);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108553__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0 = (function (){
var statearr_108561 = [null,null,null,null,null,null,null];
(statearr_108561[(0)] = fluree$db$query$schema$schema_map_$_state_machine__99975__auto__);

(statearr_108561[(1)] = (1));

return statearr_108561;
});
var fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1 = (function (state_108553){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108562){if((e108562 instanceof Object)){
var ex__99978__auto__ = e108562;
var statearr_108563_108568 = state_108553;
(statearr_108563_108568[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108553);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108562;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108569 = state_108553;
state_108553 = G__108569;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__ = function(state_108553){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1.call(this,state_108553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__99975__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__99975__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108564 = f__100070__auto__.call(null);
(statearr_108564[(6)] = c__100069__auto__);

return statearr_108564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_108605){
var state_val_108606 = (state_108605[(1)]);
if((state_val_108606 === (1))){
var state_108605__$1 = state_108605;
var statearr_108607_108618 = state_108605__$1;
(statearr_108607_108618[(2)] = null);

(statearr_108607_108618[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108606 === (2))){
var inst_108603 = (state_108605[(2)]);
var state_108605__$1 = state_108605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_108605__$1,inst_108603);
} else {
if((state_val_108606 === (3))){
var inst_108570 = (state_108605[(2)]);
var state_108605__$1 = state_108605;
var statearr_108608_108619 = state_108605__$1;
(statearr_108608_108619[(2)] = inst_108570);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108606 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108605,(3),Error,null,(2));
var state_108605__$1 = state_108605;
var statearr_108609_108620 = state_108605__$1;
(statearr_108609_108620[(2)] = null);

(statearr_108609_108620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108606 === (5))){
var inst_108589 = (state_108605[(2)]);
var inst_108590 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_108589);
var inst_108591 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_108592 = cljs.core.get.call(null,inst_108590,(114));
var inst_108593 = cljs.core.boolean$.call(null,inst_108592);
var inst_108594 = cljs.core.get.call(null,inst_108590,(110));
var inst_108595 = cljs.core.get.call(null,inst_108590,(117));
var inst_108596 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_108595);
var inst_108597 = cljs.core.get.call(null,inst_108590,(111));
var inst_108598 = cljs.core.get.call(null,inst_108590,(115));
var inst_108599 = cljs.core.get.call(null,inst_108590,(112));
var inst_108600 = [inst_108593,inst_108594,inst_108596,inst_108597,inst_108598,inst_108599];
var inst_108601 = cljs.core.PersistentHashMap.fromArrays(inst_108591,inst_108600);
var state_108605__$1 = state_108605;
var statearr_108610_108621 = state_108605__$1;
(statearr_108610_108621[(2)] = inst_108601);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108606 === (6))){
var inst_108574 = (state_108605[(2)]);
var state_108605__$1 = (function (){var statearr_108611 = state_108605;
(statearr_108611[(7)] = inst_108574);

return statearr_108611;
})();
var statearr_108612_108622 = state_108605__$1;
(statearr_108612_108622[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_108606 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_108605,(6),new cljs.core.Keyword(null,"default","default",-1987822328),null,(5));
var inst_108578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_108580 = ["_setting/id","root"];
var inst_108581 = (new cljs.core.PersistentVector(null,2,(5),inst_108579,inst_108580,null));
var inst_108582 = [inst_108581];
var inst_108583 = (new cljs.core.PersistentVector(null,1,(5),inst_108578,inst_108582,null));
var inst_108584 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_108583);
var state_108605__$1 = state_108605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_108605__$1,(8),inst_108584);
} else {
if((state_val_108606 === (8))){
var inst_108586 = (state_108605[(2)]);
var inst_108587 = fluree.db.util.async.throw_err.call(null,inst_108586);
var state_108605__$1 = state_108605;
var statearr_108613_108623 = state_108605__$1;
(statearr_108613_108623[(2)] = inst_108587);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108605__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0 = (function (){
var statearr_108614 = [null,null,null,null,null,null,null,null];
(statearr_108614[(0)] = fluree$db$query$schema$setting_map_$_state_machine__99975__auto__);

(statearr_108614[(1)] = (1));

return statearr_108614;
});
var fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1 = (function (state_108605){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_108605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e108615){if((e108615 instanceof Object)){
var ex__99978__auto__ = e108615;
var statearr_108616_108624 = state_108605;
(statearr_108616_108624[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_108605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e108615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__108625 = state_108605;
state_108605 = G__108625;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__ = function(state_108605){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1.call(this,state_108605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__99975__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__99975__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_108617 = f__100070__auto__.call(null);
(statearr_108617[(6)] = c__100069__auto__);

return statearr_108617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
