// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.string.format');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
var st_134780 = cljs.js.empty_state.call(null);
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_134780,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs.app_state !== 'undefined')){
} else {
flureenjs.app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v0.15.4"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)));
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.set_logging = (function flureenjs$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__134781 = opts_SINGLEQUOTE_;
var map__134781__$1 = (((((!((map__134781 == null))))?(((((map__134781.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__134781.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__134781):map__134781);
var level = cljs.core.get.call(null,map__134781__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.set_logging', flureenjs.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var G__134784 = arguments.length;
switch (G__134784) {
case 1:
return flureenjs.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureenjs.connect.call(null,servers_string,null);
}));

(flureenjs.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect.call(null,servers_string,opts_SINGLEQUOTE_);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect_p = (function flureenjs$connect_p(var_args){
var G__134787 = arguments.length;
switch (G__134787) {
case 1:
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.connect_p', flureenjs.connect_p);

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureenjs.connect_p.call(null,servers_string,null);
}));

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,opts_SINGLEQUOTE_);
}));

(flureenjs.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 */
flureenjs.password_generate = (function flureenjs$password_generate(var_args){
var G__134790 = arguments.length;
switch (G__134790) {
case 4:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_generate', flureenjs.password_generate);

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.password_generate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
var data = cljs.core.assoc.call(null,opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureenjs.password_login = (function flureenjs$password_login(var_args){
var G__134793 = arguments.length;
switch (G__134793) {
case 4:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_login', flureenjs.password_login);

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renew_token = (function flureenjs$renew_token(var_args){
var G__134796 = arguments.length;
switch (G__134796) {
case 2:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renew_token', flureenjs.renew_token);

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.close_listener = (function flureenjs$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.close_listener', flureenjs.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___134805 = arguments.length;
var i__4737__auto___134806 = (0);
while(true){
if((i__4737__auto___134806 < len__4736__auto___134805)){
args__4742__auto__.push((arguments[i__4737__auto___134806]));

var G__134807 = (i__4737__auto___134806 + (1));
i__4737__auto___134806 = G__134807;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__134801){
var vec__134802 = p__134801;
var opts = cljs.core.nth.call(null,vec__134802,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return flureenjs.db_instance.call(null,conn,ledger,opts__$1);
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq134798){
var G__134799 = cljs.core.first.call(null,seq134798);
var seq134798__$1 = cljs.core.next.call(null,seq134798);
var G__134800 = cljs.core.first.call(null,seq134798__$1);
var seq134798__$2 = cljs.core.next.call(null,seq134798__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__134799,G__134800,seq134798__$2);
}));

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_instance = (function flureenjs$db_instance(var_args){
var args__4742__auto__ = [];
var len__4736__auto___134945 = arguments.length;
var i__4737__auto___134946 = (0);
while(true){
if((i__4737__auto___134946 < len__4736__auto___134945)){
args__4742__auto__.push((arguments[i__4737__auto___134946]));

var G__134947 = (i__4737__auto___134946 + (1));
i__4737__auto___134946 = G__134947;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__134811){
var vec__134812 = p__134811;
var opts = cljs.core.nth.call(null,vec__134812,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___134948 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_134898){
var state_val_134899 = (state_134898[(1)]);
if((state_val_134899 === (7))){
var inst_134841 = (state_134898[(2)]);
var state_134898__$1 = state_134898;
if(cljs.core.truth_(inst_134841)){
var statearr_134900_134949 = state_134898__$1;
(statearr_134900_134949[(1)] = (11));

} else {
var statearr_134901_134950 = state_134898__$1;
(statearr_134901_134950[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (20))){
var inst_134869 = (state_134898[(2)]);
var state_134898__$1 = state_134898;
var statearr_134902_134951 = state_134898__$1;
(statearr_134902_134951[(2)] = inst_134869);

(statearr_134902_134951[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (27))){
var inst_134871 = (state_134898[(7)]);
var inst_134885 = (state_134898[(2)]);
var state_134898__$1 = (function (){var statearr_134903 = state_134898;
(statearr_134903[(8)] = inst_134885);

return statearr_134903;
})();
if(cljs.core.truth_(inst_134871)){
var statearr_134904_134952 = state_134898__$1;
(statearr_134904_134952[(1)] = (29));

} else {
var statearr_134905_134953 = state_134898__$1;
(statearr_134905_134953[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (1))){
var state_134898__$1 = state_134898;
var statearr_134906_134954 = state_134898__$1;
(statearr_134906_134954[(2)] = null);

(statearr_134906_134954[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (24))){
var inst_134850 = (state_134898[(9)]);
var inst_134876 = (state_134898[(2)]);
var state_134898__$1 = (function (){var statearr_134907 = state_134898;
(statearr_134907[(10)] = inst_134876);

return statearr_134907;
})();
if(cljs.core.truth_(inst_134850)){
var statearr_134908_134955 = state_134898__$1;
(statearr_134908_134955[(1)] = (25));

} else {
var statearr_134909_134956 = state_134898__$1;
(statearr_134909_134956[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_134898,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_134827 = (opts == null);
var inst_134828 = cljs.core.not.call(null,inst_134827);
var state_134898__$1 = state_134898;
if(inst_134828){
var statearr_134910_134957 = state_134898__$1;
(statearr_134910_134957[(1)] = (5));

} else {
var statearr_134911_134958 = state_134898__$1;
(statearr_134911_134958[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (15))){
var inst_134847 = (state_134898[(11)]);
var state_134898__$1 = state_134898;
var statearr_134912_134959 = state_134898__$1;
(statearr_134912_134959[(2)] = inst_134847);

(statearr_134912_134959[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (21))){
var inst_134865 = (state_134898[(2)]);
var inst_134866 = fluree.db.util.async.throw_err.call(null,inst_134865);
var state_134898__$1 = state_134898;
var statearr_134913_134960 = state_134898__$1;
(statearr_134913_134960[(2)] = inst_134866);

(statearr_134913_134960[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (31))){
var inst_134893 = (state_134898[(2)]);
var inst_134894 = cljs.core.async.put_BANG_.call(null,pc,inst_134893);
var state_134898__$1 = state_134898;
var statearr_134914_134961 = state_134898__$1;
(statearr_134914_134961[(2)] = inst_134894);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_134898__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (32))){
var inst_134885 = (state_134898[(8)]);
var inst_134888 = (state_134898[(2)]);
var inst_134889 = fluree.db.util.async.throw_err.call(null,inst_134888);
var inst_134890 = cljs.core.assoc.call(null,inst_134885,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_134889);
var state_134898__$1 = state_134898;
var statearr_134915_134962 = state_134898__$1;
(statearr_134915_134962[(2)] = inst_134890);

(statearr_134915_134962[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (13))){
var inst_134846 = (state_134898[(2)]);
var inst_134847 = cljs.core.get.call(null,inst_134846,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_134848 = cljs.core.get.call(null,inst_134846,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_134849 = cljs.core.get.call(null,inst_134846,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_134850 = cljs.core.get.call(null,inst_134846,new cljs.core.Keyword(null,"block","block",664686210));
var inst_134851 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_134852 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_134853 = cljs.core.nth.call(null,inst_134852,(0),null);
var inst_134854 = cljs.core.nth.call(null,inst_134852,(1),null);
var inst_134855 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_134898__$1 = (function (){var statearr_134916 = state_134898;
(statearr_134916[(12)] = inst_134848);

(statearr_134916[(13)] = inst_134854);

(statearr_134916[(11)] = inst_134847);

(statearr_134916[(14)] = inst_134851);

(statearr_134916[(15)] = inst_134853);

(statearr_134916[(9)] = inst_134850);

(statearr_134916[(16)] = inst_134849);

return statearr_134916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_134898__$1,(14),inst_134855);
} else {
if((state_val_134899 === (22))){
var inst_134871 = (state_134898[(7)]);
var inst_134859 = (state_134898[(17)]);
var inst_134873 = fluree.db.permissions.permission_map.call(null,inst_134859,inst_134871,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_134898__$1 = state_134898;
var statearr_134917_134963 = state_134898__$1;
(statearr_134917_134963[(2)] = inst_134873);

(statearr_134917_134963[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (29))){
var inst_134876 = (state_134898[(10)]);
var state_134898__$1 = state_134898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_134898__$1,(32),inst_134876);
} else {
if((state_val_134899 === (6))){
var state_134898__$1 = state_134898;
var statearr_134918_134964 = state_134898__$1;
(statearr_134918_134964[(2)] = false);

(statearr_134918_134964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (28))){
var inst_134881 = (state_134898[(2)]);
var inst_134882 = fluree.db.util.async.throw_err.call(null,inst_134881);
var state_134898__$1 = state_134898;
var statearr_134919_134965 = state_134898__$1;
(statearr_134919_134965[(2)] = inst_134882);

(statearr_134919_134965[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (25))){
var inst_134859 = (state_134898[(17)]);
var inst_134878 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_134879 = fluree.db.time_travel.as_of_block.call(null,inst_134859,inst_134878);
var state_134898__$1 = state_134898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_134898__$1,(28),inst_134879);
} else {
if((state_val_134899 === (17))){
var inst_134871 = (state_134898[(7)]);
var inst_134871__$1 = (state_134898[(2)]);
var state_134898__$1 = (function (){var statearr_134920 = state_134898;
(statearr_134920[(7)] = inst_134871__$1);

return statearr_134920;
})();
if(cljs.core.truth_(inst_134871__$1)){
var statearr_134921_134966 = state_134898__$1;
(statearr_134921_134966[(1)] = (22));

} else {
var statearr_134922_134967 = state_134898__$1;
(statearr_134922_134967[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (3))){
var inst_134815 = (state_134898[(2)]);
var inst_134816 = fluree.db.util.log.error.call(null,inst_134815);
var inst_134817 = cljs.core.async.put_BANG_.call(null,pc,inst_134815);
var inst_134818 = cljs.core.async.close_BANG_.call(null,pc);
var state_134898__$1 = (function (){var statearr_134923 = state_134898;
(statearr_134923[(18)] = inst_134816);

(statearr_134923[(19)] = inst_134817);

return statearr_134923;
})();
var statearr_134924_134968 = state_134898__$1;
(statearr_134924_134968[(2)] = inst_134818);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_134898__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (12))){
var state_134898__$1 = state_134898;
var statearr_134925_134969 = state_134898__$1;
(statearr_134925_134969[(2)] = opts);

(statearr_134925_134969[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (2))){
var inst_134896 = (state_134898[(2)]);
var state_134898__$1 = state_134898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_134898__$1,inst_134896);
} else {
if((state_val_134899 === (23))){
var state_134898__$1 = state_134898;
var statearr_134926_134970 = state_134898__$1;
(statearr_134926_134970[(2)] = null);

(statearr_134926_134970[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (19))){
var state_134898__$1 = state_134898;
var statearr_134927_134971 = state_134898__$1;
(statearr_134927_134971[(2)] = null);

(statearr_134927_134971[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (11))){
var inst_134843 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var state_134898__$1 = state_134898;
var statearr_134928_134972 = state_134898__$1;
(statearr_134928_134972[(2)] = inst_134843);

(statearr_134928_134972[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (9))){
var state_134898__$1 = state_134898;
var statearr_134929_134973 = state_134898__$1;
(statearr_134929_134973[(2)] = false);

(statearr_134929_134973[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (5))){
var inst_134830 = opts.cljs$lang$protocol_mask$partition0$;
var inst_134831 = (inst_134830 & (64));
var inst_134832 = opts.cljs$core$ISeq$;
var inst_134833 = (cljs.core.PROTOCOL_SENTINEL === inst_134832);
var inst_134834 = ((inst_134831) || (inst_134833));
var state_134898__$1 = state_134898;
if(cljs.core.truth_(inst_134834)){
var statearr_134930_134974 = state_134898__$1;
(statearr_134930_134974[(1)] = (8));

} else {
var statearr_134931_134975 = state_134898__$1;
(statearr_134931_134975[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (14))){
var inst_134854 = (state_134898[(13)]);
var inst_134847 = (state_134898[(11)]);
var inst_134853 = (state_134898[(15)]);
var inst_134857 = (state_134898[(2)]);
var inst_134858 = fluree.db.util.async.throw_err.call(null,inst_134857);
var inst_134859 = cljs.core.assoc.call(null,inst_134858,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_134853,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_134854);
var state_134898__$1 = (function (){var statearr_134932 = state_134898;
(statearr_134932[(17)] = inst_134859);

return statearr_134932;
})();
if(cljs.core.truth_(inst_134847)){
var statearr_134933_134976 = state_134898__$1;
(statearr_134933_134976[(1)] = (15));

} else {
var statearr_134934_134977 = state_134898__$1;
(statearr_134934_134977[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (26))){
var inst_134859 = (state_134898[(17)]);
var state_134898__$1 = state_134898;
var statearr_134935_134978 = state_134898__$1;
(statearr_134935_134978[(2)] = inst_134859);

(statearr_134935_134978[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (16))){
var inst_134849 = (state_134898[(16)]);
var state_134898__$1 = state_134898;
if(cljs.core.truth_(inst_134849)){
var statearr_134936_134979 = state_134898__$1;
(statearr_134936_134979[(1)] = (18));

} else {
var statearr_134937_134980 = state_134898__$1;
(statearr_134937_134980[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (30))){
var inst_134885 = (state_134898[(8)]);
var state_134898__$1 = state_134898;
var statearr_134938_134981 = state_134898__$1;
(statearr_134938_134981[(2)] = inst_134885);

(statearr_134938_134981[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (10))){
var inst_134838 = (state_134898[(2)]);
var state_134898__$1 = state_134898;
var statearr_134939_134982 = state_134898__$1;
(statearr_134939_134982[(2)] = inst_134838);

(statearr_134939_134982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_134899 === (18))){
var inst_134849 = (state_134898[(16)]);
var inst_134859 = (state_134898[(17)]);
var inst_134863 = fluree.db.auth.roles.call(null,inst_134859,inst_134849);
var state_134898__$1 = state_134898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_134898__$1,(21),inst_134863);
} else {
if((state_val_134899 === (8))){
var state_134898__$1 = state_134898;
var statearr_134940_134983 = state_134898__$1;
(statearr_134940_134983[(2)] = true);

(statearr_134940_134983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_134941 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_134941[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_134941[(1)] = (1));

return statearr_134941;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_134898){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_134898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e134942){if((e134942 instanceof Object)){
var ex__99978__auto__ = e134942;
var statearr_134943_134984 = state_134898;
(statearr_134943_134984[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_134898);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e134942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__134985 = state_134898;
state_134898 = G__134985;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_134898){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_134898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_134944 = f__100070__auto__.call(null);
(statearr_134944[(6)] = c__100069__auto___134948);

return statearr_134944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
}));

(flureenjs.db_instance.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db_instance.cljs$lang$applyTo = (function (seq134808){
var G__134809 = cljs.core.first.call(null,seq134808);
var seq134808__$1 = cljs.core.next.call(null,seq134808);
var G__134810 = cljs.core.first.call(null,seq134808__$1);
var seq134808__$2 = cljs.core.next.call(null,seq134808__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__134809,G__134810,seq134808__$2);
}));

/**
 * Returns db's schema map.
 */
flureenjs.db_schema = (function flureenjs$db_schema(db){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135001){
var state_val_135002 = (state_135001[(1)]);
if((state_val_135002 === (1))){
var state_135001__$1 = state_135001;
var statearr_135003_135011 = state_135001__$1;
(statearr_135003_135011[(2)] = null);

(statearr_135003_135011[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135002 === (2))){
var inst_134999 = (state_135001[(2)]);
var state_135001__$1 = state_135001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135001__$1,inst_134999);
} else {
if((state_val_135002 === (3))){
var inst_134986 = (state_135001[(2)]);
var inst_134987 = fluree.db.util.log.error.call(null,inst_134986);
var inst_134988 = reject.call(null,inst_134986);
var state_135001__$1 = (function (){var statearr_135004 = state_135001;
(statearr_135004[(7)] = inst_134987);

return statearr_135004;
})();
var statearr_135005_135012 = state_135001__$1;
(statearr_135005_135012[(2)] = inst_134988);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135001__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135002 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135001,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var state_135001__$1 = state_135001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135001__$1,(5),db);
} else {
if((state_val_135002 === (5))){
var inst_134993 = (state_135001[(2)]);
var inst_134994 = fluree.db.util.async.throw_err.call(null,inst_134993);
var inst_134995 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_134994);
var inst_134996 = cljs.core.clj__GT_js.call(null,inst_134995);
var inst_134997 = resolve.call(null,inst_134996);
var state_135001__$1 = state_135001;
var statearr_135006_135013 = state_135001__$1;
(statearr_135006_135013[(2)] = inst_134997);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135001__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$db_schema_$_state_machine__99975__auto__ = null;
var flureenjs$db_schema_$_state_machine__99975__auto____0 = (function (){
var statearr_135007 = [null,null,null,null,null,null,null,null];
(statearr_135007[(0)] = flureenjs$db_schema_$_state_machine__99975__auto__);

(statearr_135007[(1)] = (1));

return statearr_135007;
});
var flureenjs$db_schema_$_state_machine__99975__auto____1 = (function (state_135001){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135008){if((e135008 instanceof Object)){
var ex__99978__auto__ = e135008;
var statearr_135009_135014 = state_135001;
(statearr_135009_135014[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135001);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135015 = state_135001;
state_135001 = G__135015;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$db_schema_$_state_machine__99975__auto__ = function(state_135001){
switch(arguments.length){
case 0:
return flureenjs$db_schema_$_state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$db_schema_$_state_machine__99975__auto____1.call(this,state_135001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$db_schema_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$db_schema_$_state_machine__99975__auto____0;
flureenjs$db_schema_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$db_schema_$_state_machine__99975__auto____1;
return flureenjs$db_schema_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135010 = f__100070__auto__.call(null);
(statearr_135010[(6)] = c__100069__auto__);

return statearr_135010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
goog.exportSymbol('flureenjs.db_schema', flureenjs.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.delete_ledger = (function flureenjs$delete_ledger(var_args){
var G__135017 = arguments.length;
switch (G__135017) {
case 2:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.delete_ledger', flureenjs.delete_ledger);

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.delete_ledger.call(null,conn,ledger,null);
}));

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135104){
var state_val_135105 = (state_135104[(1)]);
if((state_val_135105 === (7))){
var inst_135030 = (state_135104[(7)]);
var inst_135030__$1 = (state_135104[(2)]);
var inst_135031 = fluree.db.connection_js.check_connection.call(null,conn,inst_135030__$1);
var inst_135033 = (inst_135030__$1 == null);
var inst_135034 = cljs.core.not.call(null,inst_135033);
var state_135104__$1 = (function (){var statearr_135106 = state_135104;
(statearr_135106[(7)] = inst_135030__$1);

(statearr_135106[(8)] = inst_135031);

return statearr_135106;
})();
if(inst_135034){
var statearr_135107_135157 = state_135104__$1;
(statearr_135107_135157[(1)] = (8));

} else {
var statearr_135108_135158 = state_135104__$1;
(statearr_135108_135158[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (20))){
var inst_135054 = (state_135104[(9)]);
var state_135104__$1 = state_135104;
var statearr_135109_135159 = state_135104__$1;
(statearr_135109_135159[(2)] = inst_135054);

(statearr_135109_135159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (27))){
var state_135104__$1 = state_135104;
var statearr_135110_135160 = state_135104__$1;
(statearr_135110_135160[(2)] = null);

(statearr_135110_135160[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (1))){
var state_135104__$1 = state_135104;
var statearr_135111_135161 = state_135104__$1;
(statearr_135111_135161[(2)] = null);

(statearr_135111_135161[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (24))){
var state_135104__$1 = state_135104;
var statearr_135112_135162 = state_135104__$1;
(statearr_135112_135162[(2)] = null);

(statearr_135112_135162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135104,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135025 = (opts == null);
var state_135104__$1 = state_135104;
if(cljs.core.truth_(inst_135025)){
var statearr_135113_135163 = state_135104__$1;
(statearr_135113_135163[(1)] = (5));

} else {
var statearr_135114_135164 = state_135104__$1;
(statearr_135114_135164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (15))){
var inst_135030 = (state_135104[(7)]);
var state_135104__$1 = state_135104;
var statearr_135115_135165 = state_135104__$1;
(statearr_135115_135165[(2)] = inst_135030);

(statearr_135115_135165[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (21))){
var inst_135057 = (state_135104[(10)]);
var inst_135064 = (inst_135057 + (30000));
var state_135104__$1 = state_135104;
var statearr_135116_135166 = state_135104__$1;
(statearr_135116_135166[(2)] = inst_135064);

(statearr_135116_135166[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (31))){
var inst_135095 = (state_135104[(2)]);
var inst_135096 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_135097 = [(200),inst_135095];
var inst_135098 = cljs.core.PersistentHashMap.fromArrays(inst_135096,inst_135097);
var inst_135099 = cljs.core.clj__GT_js.call(null,inst_135098);
var inst_135100 = resolve.call(null,inst_135099);
var state_135104__$1 = state_135104;
var statearr_135117_135167 = state_135104__$1;
(statearr_135117_135167[(2)] = inst_135100);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135104__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (32))){
var inst_135087 = (state_135104[(2)]);
var inst_135088 = fluree.db.util.async.throw_err.call(null,inst_135087);
var state_135104__$1 = state_135104;
var statearr_135118_135168 = state_135104__$1;
(statearr_135118_135168[(2)] = inst_135088);

(statearr_135118_135168[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (33))){
var inst_135092 = (state_135104[(2)]);
var inst_135093 = fluree.db.util.async.throw_err.call(null,inst_135092);
var state_135104__$1 = state_135104;
var statearr_135119_135169 = state_135104__$1;
(statearr_135119_135169[(2)] = inst_135093);

(statearr_135119_135169[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (13))){
var inst_135044 = (state_135104[(2)]);
var state_135104__$1 = state_135104;
var statearr_135120_135170 = state_135104__$1;
(statearr_135120_135170[(2)] = inst_135044);

(statearr_135120_135170[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (22))){
var inst_135061 = (state_135104[(11)]);
var inst_135056 = (state_135104[(12)]);
var inst_135066 = (state_135104[(2)]);
var inst_135067 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_135068 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_135061,inst_135066];
var inst_135069 = cljs.core.PersistentHashMap.fromArrays(inst_135067,inst_135068);
var state_135104__$1 = (function (){var statearr_135121 = state_135104;
(statearr_135121[(13)] = inst_135069);

return statearr_135121;
})();
if(cljs.core.truth_(inst_135056)){
var statearr_135122_135171 = state_135104__$1;
(statearr_135122_135171[(1)] = (23));

} else {
var statearr_135123_135172 = state_135104__$1;
(statearr_135123_135172[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (29))){
var inst_135080 = (state_135104[(14)]);
var inst_135075 = (state_135104[(15)]);
var inst_135082 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_135083 = [inst_135075,inst_135080];
var inst_135084 = cljs.core.PersistentHashMap.fromArrays(inst_135082,inst_135083);
var inst_135085 = fluree.db.operations.command_async.call(null,conn,inst_135084);
var state_135104__$1 = state_135104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135104__$1,(32),inst_135085);
} else {
if((state_val_135105 === (6))){
var inst_135028 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135104__$1 = state_135104;
var statearr_135124_135173 = state_135104__$1;
(statearr_135124_135173[(2)] = inst_135028);

(statearr_135124_135173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (28))){
var inst_135056 = (state_135104[(12)]);
var inst_135080 = (state_135104[(2)]);
var state_135104__$1 = (function (){var statearr_135125 = state_135104;
(statearr_135125[(14)] = inst_135080);

return statearr_135125;
})();
if(cljs.core.truth_(inst_135056)){
var statearr_135126_135174 = state_135104__$1;
(statearr_135126_135174[(1)] = (29));

} else {
var statearr_135127_135175 = state_135104__$1;
(statearr_135127_135175[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (25))){
var inst_135056 = (state_135104[(12)]);
var inst_135075 = (state_135104[(2)]);
var state_135104__$1 = (function (){var statearr_135128 = state_135104;
(statearr_135128[(15)] = inst_135075);

return statearr_135128;
})();
if(cljs.core.truth_(inst_135056)){
var statearr_135129_135176 = state_135104__$1;
(statearr_135129_135176[(1)] = (26));

} else {
var statearr_135130_135177 = state_135104__$1;
(statearr_135130_135177[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (17))){
var inst_135053 = (state_135104[(16)]);
var state_135104__$1 = state_135104;
var statearr_135131_135178 = state_135104__$1;
(statearr_135131_135178[(2)] = inst_135053);

(statearr_135131_135178[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (3))){
var inst_135018 = (state_135104[(2)]);
var inst_135019 = fluree.db.util.log.error.call(null,inst_135018);
var inst_135020 = reject.call(null,inst_135018);
var state_135104__$1 = (function (){var statearr_135132 = state_135104;
(statearr_135132[(17)] = inst_135019);

return statearr_135132;
})();
var statearr_135133_135179 = state_135104__$1;
(statearr_135133_135179[(2)] = inst_135020);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135104__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (12))){
var state_135104__$1 = state_135104;
var statearr_135134_135180 = state_135104__$1;
(statearr_135134_135180[(2)] = false);

(statearr_135134_135180[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (2))){
var inst_135102 = (state_135104[(2)]);
var state_135104__$1 = state_135104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135104__$1,inst_135102);
} else {
if((state_val_135105 === (23))){
var inst_135069 = (state_135104[(13)]);
var inst_135071 = fluree.db.util.core.without_nils.call(null,inst_135069);
var inst_135072 = fluree.db.util.json.stringify.call(null,inst_135071);
var state_135104__$1 = state_135104;
var statearr_135135_135181 = state_135104__$1;
(statearr_135135_135181[(2)] = inst_135072);

(statearr_135135_135181[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (19))){
var inst_135054 = (state_135104[(9)]);
var inst_135061 = (state_135104[(2)]);
var state_135104__$1 = (function (){var statearr_135136 = state_135104;
(statearr_135136[(11)] = inst_135061);

return statearr_135136;
})();
if(cljs.core.truth_(inst_135054)){
var statearr_135137_135182 = state_135104__$1;
(statearr_135137_135182[(1)] = (20));

} else {
var statearr_135138_135183 = state_135104__$1;
(statearr_135138_135183[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (11))){
var state_135104__$1 = state_135104;
var statearr_135139_135184 = state_135104__$1;
(statearr_135139_135184[(2)] = true);

(statearr_135139_135184[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (9))){
var state_135104__$1 = state_135104;
var statearr_135140_135185 = state_135104__$1;
(statearr_135140_135185[(2)] = false);

(statearr_135140_135185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (5))){
var state_135104__$1 = state_135104;
var statearr_135141_135186 = state_135104__$1;
(statearr_135141_135186[(2)] = null);

(statearr_135141_135186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (14))){
var inst_135030 = (state_135104[(7)]);
var inst_135049 = cljs.core.apply.call(null,cljs.core.hash_map,inst_135030);
var state_135104__$1 = state_135104;
var statearr_135142_135187 = state_135104__$1;
(statearr_135142_135187[(2)] = inst_135049);

(statearr_135142_135187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (26))){
var inst_135056 = (state_135104[(12)]);
var inst_135075 = (state_135104[(15)]);
var inst_135077 = fluree.crypto.sign_message.call(null,inst_135075,inst_135056);
var state_135104__$1 = state_135104;
var statearr_135143_135188 = state_135104__$1;
(statearr_135143_135188[(2)] = inst_135077);

(statearr_135143_135188[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (16))){
var inst_135053 = (state_135104[(16)]);
var inst_135052 = (state_135104[(2)]);
var inst_135053__$1 = cljs.core.get.call(null,inst_135052,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_135054 = cljs.core.get.call(null,inst_135052,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_135055 = cljs.core.get.call(null,inst_135052,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_135056 = cljs.core.get.call(null,inst_135052,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_135057 = fluree.db.util.core.current_time_millis.call(null);
var state_135104__$1 = (function (){var statearr_135144 = state_135104;
(statearr_135144[(18)] = inst_135055);

(statearr_135144[(9)] = inst_135054);

(statearr_135144[(10)] = inst_135057);

(statearr_135144[(12)] = inst_135056);

(statearr_135144[(16)] = inst_135053__$1);

return statearr_135144;
})();
if(cljs.core.truth_(inst_135053__$1)){
var statearr_135145_135189 = state_135104__$1;
(statearr_135145_135189[(1)] = (17));

} else {
var statearr_135146_135190 = state_135104__$1;
(statearr_135146_135190[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (30))){
var inst_135069 = (state_135104[(13)]);
var inst_135090 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_135069);
var state_135104__$1 = state_135104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135104__$1,(33),inst_135090);
} else {
if((state_val_135105 === (10))){
var inst_135047 = (state_135104[(2)]);
var state_135104__$1 = state_135104;
if(cljs.core.truth_(inst_135047)){
var statearr_135147_135191 = state_135104__$1;
(statearr_135147_135191[(1)] = (14));

} else {
var statearr_135148_135192 = state_135104__$1;
(statearr_135148_135192[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (18))){
var inst_135057 = (state_135104[(10)]);
var state_135104__$1 = state_135104;
var statearr_135149_135193 = state_135104__$1;
(statearr_135149_135193[(2)] = inst_135057);

(statearr_135149_135193[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135105 === (8))){
var inst_135030 = (state_135104[(7)]);
var inst_135036 = inst_135030.cljs$lang$protocol_mask$partition0$;
var inst_135037 = (inst_135036 & (64));
var inst_135038 = inst_135030.cljs$core$ISeq$;
var inst_135039 = (cljs.core.PROTOCOL_SENTINEL === inst_135038);
var inst_135040 = ((inst_135037) || (inst_135039));
var state_135104__$1 = state_135104;
if(cljs.core.truth_(inst_135040)){
var statearr_135150_135194 = state_135104__$1;
(statearr_135150_135194[(1)] = (11));

} else {
var statearr_135151_135195 = state_135104__$1;
(statearr_135151_135195[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135152 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135152[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135152[(1)] = (1));

return statearr_135152;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135104){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135153){if((e135153 instanceof Object)){
var ex__99978__auto__ = e135153;
var statearr_135154_135196 = state_135104;
(statearr_135154_135196[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135104);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135153;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135197 = state_135104;
state_135104 = G__135197;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135104){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135155 = f__100070__auto__.call(null);
(statearr_135155[(6)] = c__100069__auto__);

return statearr_135155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's  with ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_stats = (function flureenjs$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135213){
var state_val_135214 = (state_135213[(1)]);
if((state_val_135214 === (1))){
var state_135213__$1 = state_135213;
var statearr_135215_135223 = state_135213__$1;
(statearr_135215_135223[(2)] = null);

(statearr_135215_135223[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135214 === (2))){
var inst_135211 = (state_135213[(2)]);
var state_135213__$1 = state_135213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135213__$1,inst_135211);
} else {
if((state_val_135214 === (3))){
var inst_135198 = (state_135213[(2)]);
var inst_135199 = fluree.db.util.log.error.call(null,inst_135198);
var inst_135200 = reject.call(null,inst_135198);
var state_135213__$1 = (function (){var statearr_135216 = state_135213;
(statearr_135216[(7)] = inst_135199);

return statearr_135216;
})();
var statearr_135217_135224 = state_135213__$1;
(statearr_135217_135224[(2)] = inst_135200);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135214 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135213,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135204 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_135213__$1 = state_135213;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135213__$1,(5),inst_135204);
} else {
if((state_val_135214 === (5))){
var inst_135206 = (state_135213[(2)]);
var inst_135207 = fluree.db.util.async.throw_err.call(null,inst_135206);
var inst_135208 = cljs.core.clj__GT_js.call(null,inst_135207);
var inst_135209 = resolve.call(null,inst_135208);
var state_135213__$1 = state_135213;
var statearr_135218_135225 = state_135213__$1;
(statearr_135218_135225[(2)] = inst_135209);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_stats_$_state_machine__99975__auto__ = null;
var flureenjs$ledger_stats_$_state_machine__99975__auto____0 = (function (){
var statearr_135219 = [null,null,null,null,null,null,null,null];
(statearr_135219[(0)] = flureenjs$ledger_stats_$_state_machine__99975__auto__);

(statearr_135219[(1)] = (1));

return statearr_135219;
});
var flureenjs$ledger_stats_$_state_machine__99975__auto____1 = (function (state_135213){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135220){if((e135220 instanceof Object)){
var ex__99978__auto__ = e135220;
var statearr_135221_135226 = state_135213;
(statearr_135221_135226[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135213);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135220;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135227 = state_135213;
state_135213 = G__135227;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$ledger_stats_$_state_machine__99975__auto__ = function(state_135213){
switch(arguments.length){
case 0:
return flureenjs$ledger_stats_$_state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$ledger_stats_$_state_machine__99975__auto____1.call(this,state_135213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_stats_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_stats_$_state_machine__99975__auto____0;
flureenjs$ledger_stats_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_stats_$_state_machine__99975__auto____1;
return flureenjs$ledger_stats_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135222 = f__100070__auto__.call(null);
(statearr_135222[(6)] = c__100069__auto__);

return statearr_135222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_stats', flureenjs.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.new_ledger = (function flureenjs$new_ledger(var_args){
var G__135229 = arguments.length;
switch (G__135229) {
case 2:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.new_ledger', flureenjs.new_ledger);

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.new_ledger.call(null,conn,ledger,null);
}));

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135364){
var state_val_135365 = (state_135364[(1)]);
if((state_val_135365 === (7))){
var inst_135252 = (state_135364[(7)]);
var inst_135252__$1 = (state_135364[(2)]);
var inst_135253 = fluree.db.connection_js.check_connection.call(null,conn,inst_135252__$1);
var inst_135255 = (inst_135252__$1 == null);
var inst_135256 = cljs.core.not.call(null,inst_135255);
var state_135364__$1 = (function (){var statearr_135366 = state_135364;
(statearr_135366[(8)] = inst_135253);

(statearr_135366[(7)] = inst_135252__$1);

return statearr_135366;
})();
if(inst_135256){
var statearr_135367_135437 = state_135364__$1;
(statearr_135367_135437[(1)] = (8));

} else {
var statearr_135368_135438 = state_135364__$1;
(statearr_135368_135438[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (20))){
var inst_135300 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_135364__$1 = state_135364;
var statearr_135369_135439 = state_135364__$1;
(statearr_135369_135439[(2)] = inst_135300);

(statearr_135369_135439[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (27))){
var state_135364__$1 = state_135364;
var statearr_135370_135440 = state_135364__$1;
(statearr_135370_135440[(2)] = null);

(statearr_135370_135440[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (1))){
var state_135364__$1 = state_135364;
var statearr_135371_135441 = state_135364__$1;
(statearr_135371_135441[(2)] = null);

(statearr_135371_135441[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (24))){
var state_135364__$1 = state_135364;
var statearr_135372_135442 = state_135364__$1;
(statearr_135372_135442[(2)] = null);

(statearr_135372_135442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (39))){
var state_135364__$1 = state_135364;
var statearr_135373_135443 = state_135364__$1;
(statearr_135373_135443[(2)] = null);

(statearr_135373_135443[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135364,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135247 = (opts == null);
var state_135364__$1 = state_135364;
if(cljs.core.truth_(inst_135247)){
var statearr_135374_135444 = state_135364__$1;
(statearr_135374_135444[(1)] = (5));

} else {
var statearr_135375_135445 = state_135364__$1;
(statearr_135375_135445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (15))){
var inst_135252 = (state_135364[(7)]);
var state_135364__$1 = state_135364;
var statearr_135376_135446 = state_135364__$1;
(statearr_135376_135446[(2)] = inst_135252);

(statearr_135376_135446[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (21))){
var state_135364__$1 = state_135364;
var statearr_135377_135447 = state_135364__$1;
(statearr_135377_135447[(2)] = null);

(statearr_135377_135447[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (31))){
var inst_135283 = (state_135364[(9)]);
var inst_135320 = (state_135364[(2)]);
var state_135364__$1 = (function (){var statearr_135378 = state_135364;
(statearr_135378[(10)] = inst_135320);

return statearr_135378;
})();
if(cljs.core.truth_(inst_135283)){
var statearr_135379_135448 = state_135364__$1;
(statearr_135379_135448[(1)] = (32));

} else {
var statearr_135380_135449 = state_135364__$1;
(statearr_135380_135449[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (32))){
var inst_135283 = (state_135364[(9)]);
var state_135364__$1 = state_135364;
var statearr_135381_135450 = state_135364__$1;
(statearr_135381_135450[(2)] = inst_135283);

(statearr_135381_135450[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (40))){
var inst_135279 = (state_135364[(11)]);
var inst_135340 = (state_135364[(2)]);
var state_135364__$1 = (function (){var statearr_135382 = state_135364;
(statearr_135382[(12)] = inst_135340);

return statearr_135382;
})();
if(cljs.core.truth_(inst_135279)){
var statearr_135383_135451 = state_135364__$1;
(statearr_135383_135451[(1)] = (41));

} else {
var statearr_135384_135452 = state_135364__$1;
(statearr_135384_135452[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (33))){
var inst_135316 = (state_135364[(13)]);
var inst_135323 = (inst_135316 + (30000));
var state_135364__$1 = state_135364;
var statearr_135385_135453 = state_135364__$1;
(statearr_135385_135453[(2)] = inst_135323);

(statearr_135385_135453[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (13))){
var inst_135266 = (state_135364[(2)]);
var state_135364__$1 = state_135364;
var statearr_135386_135454 = state_135364__$1;
(statearr_135386_135454[(2)] = inst_135266);

(statearr_135386_135454[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (22))){
var inst_135286 = (state_135364[(14)]);
var inst_135303 = (state_135364[(2)]);
var inst_135304 = cljs.core.nth.call(null,inst_135303,(0),null);
var inst_135305 = cljs.core.nth.call(null,inst_135303,(1),null);
var state_135364__$1 = (function (){var statearr_135387 = state_135364;
(statearr_135387[(15)] = inst_135304);

(statearr_135387[(16)] = inst_135305);

return statearr_135387;
})();
if(cljs.core.truth_(inst_135286)){
var statearr_135388_135455 = state_135364__$1;
(statearr_135388_135455[(1)] = (23));

} else {
var statearr_135389_135456 = state_135364__$1;
(statearr_135389_135456[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (36))){
var state_135364__$1 = state_135364;
var statearr_135390_135457 = state_135364__$1;
(statearr_135390_135457[(2)] = null);

(statearr_135390_135457[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (41))){
var inst_135340 = (state_135364[(12)]);
var inst_135335 = (state_135364[(17)]);
var inst_135342 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_135343 = [inst_135335,inst_135340];
var inst_135344 = cljs.core.PersistentHashMap.fromArrays(inst_135342,inst_135343);
var inst_135345 = fluree.db.operations.command_async.call(null,conn,inst_135344);
var state_135364__$1 = state_135364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135364__$1,(44),inst_135345);
} else {
if((state_val_135365 === (43))){
var inst_135355 = (state_135364[(2)]);
var inst_135356 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_135357 = [(200),inst_135355];
var inst_135358 = cljs.core.PersistentHashMap.fromArrays(inst_135356,inst_135357);
var inst_135359 = cljs.core.clj__GT_js.call(null,inst_135358);
var inst_135360 = resolve.call(null,inst_135359);
var state_135364__$1 = state_135364;
var statearr_135391_135458 = state_135364__$1;
(statearr_135391_135458[(2)] = inst_135360);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135364__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (29))){
var inst_135277 = (state_135364[(18)]);
var state_135364__$1 = state_135364;
var statearr_135392_135459 = state_135364__$1;
(statearr_135392_135459[(2)] = inst_135277);

(statearr_135392_135459[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (44))){
var inst_135347 = (state_135364[(2)]);
var inst_135348 = fluree.db.util.async.throw_err.call(null,inst_135347);
var state_135364__$1 = state_135364;
var statearr_135393_135460 = state_135364__$1;
(statearr_135393_135460[(2)] = inst_135348);

(statearr_135393_135460[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (6))){
var inst_135250 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135364__$1 = state_135364;
var statearr_135394_135461 = state_135364__$1;
(statearr_135394_135461[(2)] = inst_135250);

(statearr_135394_135461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (28))){
var inst_135277 = (state_135364[(18)]);
var inst_135315 = (state_135364[(2)]);
var inst_135316 = fluree.db.util.core.current_time_millis.call(null);
var state_135364__$1 = (function (){var statearr_135395 = state_135364;
(statearr_135395[(13)] = inst_135316);

(statearr_135395[(19)] = inst_135315);

return statearr_135395;
})();
if(cljs.core.truth_(inst_135277)){
var statearr_135396_135462 = state_135364__$1;
(statearr_135396_135462[(1)] = (29));

} else {
var statearr_135397_135463 = state_135364__$1;
(statearr_135397_135463[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (25))){
var inst_135286 = (state_135364[(14)]);
var inst_135310 = (state_135364[(2)]);
var state_135364__$1 = (function (){var statearr_135398 = state_135364;
(statearr_135398[(20)] = inst_135310);

return statearr_135398;
})();
if(cljs.core.truth_(inst_135286)){
var statearr_135399_135464 = state_135364__$1;
(statearr_135399_135464[(1)] = (26));

} else {
var statearr_135400_135465 = state_135364__$1;
(statearr_135400_135465[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (34))){
var inst_135282 = (state_135364[(21)]);
var inst_135287 = (state_135364[(22)]);
var inst_135276 = (state_135364[(23)]);
var inst_135280 = (state_135364[(24)]);
var inst_135289 = (state_135364[(25)]);
var inst_135315 = (state_135364[(19)]);
var inst_135284 = (state_135364[(26)]);
var inst_135320 = (state_135364[(10)]);
var inst_135279 = (state_135364[(11)]);
var inst_135296 = (state_135364[(27)]);
var inst_135285 = (state_135364[(28)]);
var inst_135281 = (state_135364[(29)]);
var inst_135278 = (state_135364[(30)]);
var inst_135325 = (state_135364[(2)]);
var inst_135326 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_135327 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135289),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135296)].join('');
var inst_135328 = [inst_135281,inst_135282,inst_135327,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_135325,inst_135284,inst_135315,inst_135287,inst_135285,inst_135276,inst_135320,inst_135278,inst_135280];
var inst_135329 = cljs.core.PersistentHashMap.fromArrays(inst_135326,inst_135328);
var state_135364__$1 = (function (){var statearr_135401 = state_135364;
(statearr_135401[(31)] = inst_135329);

return statearr_135401;
})();
if(cljs.core.truth_(inst_135279)){
var statearr_135402_135466 = state_135364__$1;
(statearr_135402_135466[(1)] = (35));

} else {
var statearr_135403_135467 = state_135364__$1;
(statearr_135403_135467[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (17))){
var inst_135290 = (state_135364[(32)]);
var inst_135293 = cljs.core.subs.call(null,inst_135290,(1));
var state_135364__$1 = state_135364;
var statearr_135404_135468 = state_135364__$1;
(statearr_135404_135468[(2)] = inst_135293);

(statearr_135404_135468[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (3))){
var inst_135230 = (state_135364[(2)]);
var inst_135231 = fluree.db.util.log.error.call(null,inst_135230);
var inst_135232 = cljs.core.ex_data.call(null,inst_135230);
var inst_135233 = cljs.core.ex_message.call(null,inst_135230);
var inst_135234 = cljs.core.assoc.call(null,inst_135232,new cljs.core.Keyword(null,"message","message",-406056002),inst_135233);
var inst_135235 = cljs.core.clj__GT_js.call(null,inst_135234);
var inst_135236 = reject.call(null,inst_135235);
var state_135364__$1 = (function (){var statearr_135405 = state_135364;
(statearr_135405[(33)] = inst_135231);

return statearr_135405;
})();
var statearr_135406_135469 = state_135364__$1;
(statearr_135406_135469[(2)] = inst_135236);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135364__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (12))){
var state_135364__$1 = state_135364;
var statearr_135407_135470 = state_135364__$1;
(statearr_135407_135470[(2)] = false);

(statearr_135407_135470[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (2))){
var inst_135362 = (state_135364[(2)]);
var state_135364__$1 = state_135364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135364__$1,inst_135362);
} else {
if((state_val_135365 === (23))){
var inst_135305 = (state_135364[(16)]);
var inst_135307 = fluree.db.graphdb.validate_ledger_name.call(null,inst_135305,"alias");
var state_135364__$1 = state_135364;
var statearr_135408_135471 = state_135364__$1;
(statearr_135408_135471[(2)] = inst_135307);

(statearr_135408_135471[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (35))){
var inst_135329 = (state_135364[(31)]);
var inst_135331 = fluree.db.util.core.without_nils.call(null,inst_135329);
var inst_135332 = fluree.db.util.json.stringify.call(null,inst_135331);
var state_135364__$1 = state_135364;
var statearr_135409_135472 = state_135364__$1;
(statearr_135409_135472[(2)] = inst_135332);

(statearr_135409_135472[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (19))){
var inst_135289 = (state_135364[(25)]);
var inst_135286 = (state_135364[(14)]);
var inst_135296 = (state_135364[(27)]);
var inst_135296__$1 = (state_135364[(2)]);
var inst_135297 = fluree.db.graphdb.validate_ledger_name.call(null,inst_135296__$1,"ledger");
var inst_135298 = fluree.db.graphdb.validate_ledger_name.call(null,inst_135289,"network");
var state_135364__$1 = (function (){var statearr_135410 = state_135364;
(statearr_135410[(34)] = inst_135297);

(statearr_135410[(35)] = inst_135298);

(statearr_135410[(27)] = inst_135296__$1);

return statearr_135410;
})();
if(cljs.core.truth_(inst_135286)){
var statearr_135411_135473 = state_135364__$1;
(statearr_135411_135473[(1)] = (20));

} else {
var statearr_135412_135474 = state_135364__$1;
(statearr_135412_135474[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (11))){
var state_135364__$1 = state_135364;
var statearr_135413_135475 = state_135364__$1;
(statearr_135413_135475[(2)] = true);

(statearr_135413_135475[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (9))){
var state_135364__$1 = state_135364;
var statearr_135414_135476 = state_135364__$1;
(statearr_135414_135476[(2)] = false);

(statearr_135414_135476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (5))){
var state_135364__$1 = state_135364;
var statearr_135415_135477 = state_135364__$1;
(statearr_135415_135477[(2)] = null);

(statearr_135415_135477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (14))){
var inst_135252 = (state_135364[(7)]);
var inst_135271 = cljs.core.apply.call(null,cljs.core.hash_map,inst_135252);
var state_135364__$1 = state_135364;
var statearr_135416_135478 = state_135364__$1;
(statearr_135416_135478[(2)] = inst_135271);

(statearr_135416_135478[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (45))){
var inst_135352 = (state_135364[(2)]);
var inst_135353 = fluree.db.util.async.throw_err.call(null,inst_135352);
var state_135364__$1 = state_135364;
var statearr_135417_135479 = state_135364__$1;
(statearr_135417_135479[(2)] = inst_135353);

(statearr_135417_135479[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (26))){
var inst_135304 = (state_135364[(15)]);
var inst_135305 = (state_135364[(16)]);
var inst_135312 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135304),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135305)].join('');
var state_135364__$1 = state_135364;
var statearr_135418_135480 = state_135364__$1;
(statearr_135418_135480[(2)] = inst_135312);

(statearr_135418_135480[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (16))){
var inst_135290 = (state_135364[(32)]);
var inst_135274 = (state_135364[(2)]);
var inst_135275 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_135276 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_135277 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_135278 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_135279 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_135280 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_135281 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_135282 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_135283 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_135284 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_135285 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_135286 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_135287 = cljs.core.get.call(null,inst_135274,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_135288 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_135289 = cljs.core.nth.call(null,inst_135288,(0),null);
var inst_135290__$1 = cljs.core.nth.call(null,inst_135288,(1),null);
var inst_135291 = clojure.string.starts_with_QMARK_.call(null,inst_135290__$1,"$");
var state_135364__$1 = (function (){var statearr_135419 = state_135364;
(statearr_135419[(21)] = inst_135282);

(statearr_135419[(22)] = inst_135287);

(statearr_135419[(23)] = inst_135276);

(statearr_135419[(24)] = inst_135280);

(statearr_135419[(25)] = inst_135289);

(statearr_135419[(9)] = inst_135283);

(statearr_135419[(36)] = inst_135275);

(statearr_135419[(26)] = inst_135284);

(statearr_135419[(14)] = inst_135286);

(statearr_135419[(11)] = inst_135279);

(statearr_135419[(28)] = inst_135285);

(statearr_135419[(32)] = inst_135290__$1);

(statearr_135419[(18)] = inst_135277);

(statearr_135419[(29)] = inst_135281);

(statearr_135419[(30)] = inst_135278);

return statearr_135419;
})();
if(inst_135291){
var statearr_135420_135481 = state_135364__$1;
(statearr_135420_135481[(1)] = (17));

} else {
var statearr_135421_135482 = state_135364__$1;
(statearr_135421_135482[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (38))){
var inst_135335 = (state_135364[(17)]);
var inst_135279 = (state_135364[(11)]);
var inst_135337 = fluree.crypto.sign_message.call(null,inst_135335,inst_135279);
var state_135364__$1 = state_135364;
var statearr_135422_135483 = state_135364__$1;
(statearr_135422_135483[(2)] = inst_135337);

(statearr_135422_135483[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (30))){
var inst_135316 = (state_135364[(13)]);
var state_135364__$1 = state_135364;
var statearr_135423_135484 = state_135364__$1;
(statearr_135423_135484[(2)] = inst_135316);

(statearr_135423_135484[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (10))){
var inst_135269 = (state_135364[(2)]);
var state_135364__$1 = state_135364;
if(cljs.core.truth_(inst_135269)){
var statearr_135424_135485 = state_135364__$1;
(statearr_135424_135485[(1)] = (14));

} else {
var statearr_135425_135486 = state_135364__$1;
(statearr_135425_135486[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (18))){
var inst_135290 = (state_135364[(32)]);
var state_135364__$1 = state_135364;
var statearr_135426_135487 = state_135364__$1;
(statearr_135426_135487[(2)] = inst_135290);

(statearr_135426_135487[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (42))){
var inst_135329 = (state_135364[(31)]);
var inst_135350 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_135329);
var state_135364__$1 = state_135364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135364__$1,(45),inst_135350);
} else {
if((state_val_135365 === (37))){
var inst_135279 = (state_135364[(11)]);
var inst_135335 = (state_135364[(2)]);
var state_135364__$1 = (function (){var statearr_135427 = state_135364;
(statearr_135427[(17)] = inst_135335);

return statearr_135427;
})();
if(cljs.core.truth_(inst_135279)){
var statearr_135428_135488 = state_135364__$1;
(statearr_135428_135488[(1)] = (38));

} else {
var statearr_135429_135489 = state_135364__$1;
(statearr_135429_135489[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135365 === (8))){
var inst_135252 = (state_135364[(7)]);
var inst_135258 = inst_135252.cljs$lang$protocol_mask$partition0$;
var inst_135259 = (inst_135258 & (64));
var inst_135260 = inst_135252.cljs$core$ISeq$;
var inst_135261 = (cljs.core.PROTOCOL_SENTINEL === inst_135260);
var inst_135262 = ((inst_135259) || (inst_135261));
var state_135364__$1 = state_135364;
if(cljs.core.truth_(inst_135262)){
var statearr_135430_135490 = state_135364__$1;
(statearr_135430_135490[(1)] = (11));

} else {
var statearr_135431_135491 = state_135364__$1;
(statearr_135431_135491[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135432 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135432[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135432[(1)] = (1));

return statearr_135432;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135364){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135433){if((e135433 instanceof Object)){
var ex__99978__auto__ = e135433;
var statearr_135434_135492 = state_135364;
(statearr_135434_135492[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135364);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135433;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135493 = state_135364;
state_135364 = G__135493;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135364){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135435 = f__100070__auto__.call(null);
(statearr_135435[(6)] = c__100069__auto__);

return statearr_135435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitor_tx = (function flureenjs$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135510){
var state_val_135511 = (state_135510[(1)]);
if((state_val_135511 === (1))){
var state_135510__$1 = state_135510;
var statearr_135512_135521 = state_135510__$1;
(statearr_135512_135521[(2)] = null);

(statearr_135512_135521[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135511 === (2))){
var inst_135508 = (state_135510[(2)]);
var state_135510__$1 = state_135510;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135510__$1,inst_135508);
} else {
if((state_val_135511 === (3))){
var inst_135494 = (state_135510[(2)]);
var inst_135495 = fluree.db.util.log.error.call(null,inst_135494);
var inst_135496 = cljs.core.clj__GT_js.call(null,inst_135494);
var inst_135497 = reject.call(null,inst_135496);
var state_135510__$1 = (function (){var statearr_135513 = state_135510;
(statearr_135513[(7)] = inst_135495);

return statearr_135513;
})();
var statearr_135514_135522 = state_135510__$1;
(statearr_135514_135522[(2)] = inst_135497);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135510__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135511 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135510,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135501 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_135502 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_135510__$1 = (function (){var statearr_135515 = state_135510;
(statearr_135515[(8)] = inst_135501);

return statearr_135515;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135510__$1,(5),inst_135502);
} else {
if((state_val_135511 === (5))){
var inst_135504 = (state_135510[(2)]);
var inst_135505 = cljs.core.clj__GT_js.call(null,inst_135504);
var inst_135506 = resolve.call(null,inst_135505);
var state_135510__$1 = state_135510;
var statearr_135516_135523 = state_135510__$1;
(statearr_135516_135523[(2)] = inst_135506);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135510__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$monitor_tx_$_state_machine__99975__auto__ = null;
var flureenjs$monitor_tx_$_state_machine__99975__auto____0 = (function (){
var statearr_135517 = [null,null,null,null,null,null,null,null,null];
(statearr_135517[(0)] = flureenjs$monitor_tx_$_state_machine__99975__auto__);

(statearr_135517[(1)] = (1));

return statearr_135517;
});
var flureenjs$monitor_tx_$_state_machine__99975__auto____1 = (function (state_135510){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135518){if((e135518 instanceof Object)){
var ex__99978__auto__ = e135518;
var statearr_135519_135524 = state_135510;
(statearr_135519_135524[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135510);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135525 = state_135510;
state_135510 = G__135525;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$monitor_tx_$_state_machine__99975__auto__ = function(state_135510){
switch(arguments.length){
case 0:
return flureenjs$monitor_tx_$_state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$monitor_tx_$_state_machine__99975__auto____1.call(this,state_135510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitor_tx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitor_tx_$_state_machine__99975__auto____0;
flureenjs$monitor_tx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitor_tx_$_state_machine__99975__auto____1;
return flureenjs$monitor_tx_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135520 = f__100070__auto__.call(null);
(statearr_135520[(6)] = c__100069__auto__);

return statearr_135520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
goog.exportSymbol('flureenjs.monitor_tx', flureenjs.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__135527 = arguments.length;
switch (G__135527) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135550){
var state_val_135551 = (state_135550[(1)]);
if((state_val_135551 === (1))){
var state_135550__$1 = state_135550;
var statearr_135552_135566 = state_135550__$1;
(statearr_135552_135566[(2)] = null);

(statearr_135552_135566[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135551 === (2))){
var inst_135548 = (state_135550[(2)]);
var state_135550__$1 = state_135550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135550__$1,inst_135548);
} else {
if((state_val_135551 === (3))){
var inst_135528 = (state_135550[(2)]);
var inst_135529 = fluree.db.util.log.error.call(null,inst_135528);
var inst_135530 = reject.call(null,inst_135528);
var state_135550__$1 = (function (){var statearr_135553 = state_135550;
(statearr_135553[(7)] = inst_135529);

return statearr_135553;
})();
var statearr_135554_135567 = state_135550__$1;
(statearr_135554_135567[(2)] = inst_135530);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135550__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135551 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135550,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135534 = (opts == null);
var state_135550__$1 = state_135550;
if(cljs.core.truth_(inst_135534)){
var statearr_135555_135568 = state_135550__$1;
(statearr_135555_135568[(1)] = (5));

} else {
var statearr_135556_135569 = state_135550__$1;
(statearr_135556_135569[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135551 === (5))){
var state_135550__$1 = state_135550;
var statearr_135557_135570 = state_135550__$1;
(statearr_135557_135570[(2)] = null);

(statearr_135557_135570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135551 === (6))){
var inst_135537 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135550__$1 = state_135550;
var statearr_135558_135571 = state_135550__$1;
(statearr_135558_135571[(2)] = inst_135537);

(statearr_135558_135571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135551 === (7))){
var inst_135539 = (state_135550[(2)]);
var inst_135540 = fluree.db.connection_js.check_connection.call(null,conn,inst_135539);
var inst_135541 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_135542 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_135541,inst_135539);
var state_135550__$1 = (function (){var statearr_135559 = state_135550;
(statearr_135559[(8)] = inst_135540);

return statearr_135559;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135550__$1,(8),inst_135542);
} else {
if((state_val_135551 === (8))){
var inst_135544 = (state_135550[(2)]);
var inst_135545 = cljs.core.clj__GT_js.call(null,inst_135544);
var inst_135546 = resolve.call(null,inst_135545);
var state_135550__$1 = state_135550;
var statearr_135560_135572 = state_135550__$1;
(statearr_135560_135572[(2)] = inst_135546);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135550__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135561 = [null,null,null,null,null,null,null,null,null];
(statearr_135561[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135561[(1)] = (1));

return statearr_135561;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135550){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135562){if((e135562 instanceof Object)){
var ex__99978__auto__ = e135562;
var statearr_135563_135573 = state_135550;
(statearr_135563_135573[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135562;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135574 = state_135550;
state_135550 = G__135574;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135550){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135564 = f__100070__auto__.call(null);
(statearr_135564[(6)] = c__100069__auto__);

return statearr_135564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureenjs.block_range = (function flureenjs$block_range(var_args){
var G__135576 = arguments.length;
switch (G__135576) {
case 3:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range', flureenjs.block_range);

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureenjs.block_range.call(null,conn,ledger,start,start,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureenjs.block_range.call(null,conn,ledger,start,end,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135601){
var state_val_135602 = (state_135601[(1)]);
if((state_val_135602 === (7))){
var inst_135588 = (state_135601[(7)]);
var inst_135588__$1 = (state_135601[(2)]);
var inst_135589 = flureenjs.db_instance.call(null,conn,ledger,inst_135588__$1);
var state_135601__$1 = (function (){var statearr_135603 = state_135601;
(statearr_135603[(7)] = inst_135588__$1);

return statearr_135603;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135601__$1,(8),inst_135589);
} else {
if((state_val_135602 === (1))){
var state_135601__$1 = state_135601;
var statearr_135604_135617 = state_135601__$1;
(statearr_135604_135617[(2)] = null);

(statearr_135604_135617[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135601,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135583 = (opts == null);
var state_135601__$1 = state_135601;
if(cljs.core.truth_(inst_135583)){
var statearr_135605_135618 = state_135601__$1;
(statearr_135605_135618[(1)] = (5));

} else {
var statearr_135606_135619 = state_135601__$1;
(statearr_135606_135619[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (6))){
var inst_135586 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135601__$1 = state_135601;
var statearr_135607_135620 = state_135601__$1;
(statearr_135607_135620[(2)] = inst_135586);

(statearr_135607_135620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (3))){
var inst_135577 = (state_135601[(2)]);
var inst_135578 = fluree.db.util.log.error.call(null,inst_135577);
var inst_135579 = reject.call(null,inst_135577);
var state_135601__$1 = (function (){var statearr_135608 = state_135601;
(statearr_135608[(8)] = inst_135578);

return statearr_135608;
})();
var statearr_135609_135621 = state_135601__$1;
(statearr_135609_135621[(2)] = inst_135579);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135601__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (2))){
var inst_135599 = (state_135601[(2)]);
var state_135601__$1 = state_135601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135601__$1,inst_135599);
} else {
if((state_val_135602 === (9))){
var inst_135594 = (state_135601[(2)]);
var inst_135595 = fluree.db.util.async.throw_err.call(null,inst_135594);
var inst_135596 = cljs.core.clj__GT_js.call(null,inst_135595);
var inst_135597 = resolve.call(null,inst_135596);
var state_135601__$1 = state_135601;
var statearr_135610_135622 = state_135601__$1;
(statearr_135610_135622[(2)] = inst_135597);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135601__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (5))){
var state_135601__$1 = state_135601;
var statearr_135611_135623 = state_135601__$1;
(statearr_135611_135623[(2)] = null);

(statearr_135611_135623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135602 === (8))){
var inst_135588 = (state_135601[(7)]);
var inst_135591 = (state_135601[(2)]);
var inst_135592 = fluree.db.query.block.block_range.call(null,inst_135591,start,end,inst_135588);
var state_135601__$1 = state_135601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135601__$1,(9),inst_135592);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135612 = [null,null,null,null,null,null,null,null,null];
(statearr_135612[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135612[(1)] = (1));

return statearr_135612;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135601){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135613){if((e135613 instanceof Object)){
var ex__99978__auto__ = e135613;
var statearr_135614_135624 = state_135601;
(statearr_135614_135624[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135613;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135625 = state_135601;
state_135601 = G__135625;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135601){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135615 = f__100070__auto__.call(null);
(statearr_135615[(6)] = c__100069__auto__);

return statearr_135615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.block_range_with_txn = (function flureenjs$block_range_with_txn(var_args){
var G__135627 = arguments.length;
switch (G__135627) {
case 3:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range_with_txn', flureenjs.block_range_with_txn);

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.block_range_with_txn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135683){
var state_val_135684 = (state_135683[(1)]);
if((state_val_135684 === (7))){
var inst_135640 = (state_135683[(2)]);
var inst_135641 = (block_map == null);
var state_135683__$1 = (function (){var statearr_135685 = state_135683;
(statearr_135685[(7)] = inst_135640);

return statearr_135685;
})();
if(cljs.core.truth_(inst_135641)){
var statearr_135686_135717 = state_135683__$1;
(statearr_135686_135717[(1)] = (8));

} else {
var statearr_135687_135718 = state_135683__$1;
(statearr_135687_135718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (20))){
var inst_135640 = (state_135683[(7)]);
var inst_135668 = (state_135683[(8)]);
var inst_135669 = (state_135683[(9)]);
var inst_135672 = (state_135683[(2)]);
var inst_135673 = fluree.db.query.block.block_range.call(null,inst_135672,inst_135668,inst_135669,inst_135640);
var state_135683__$1 = state_135683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135683__$1,(21),inst_135673);
} else {
if((state_val_135684 === (1))){
var state_135683__$1 = state_135683;
var statearr_135688_135719 = state_135683__$1;
(statearr_135688_135719[(2)] = null);

(statearr_135688_135719[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135683,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135635 = (opts == null);
var state_135683__$1 = state_135683;
if(cljs.core.truth_(inst_135635)){
var statearr_135689_135720 = state_135683__$1;
(statearr_135689_135720[(1)] = (5));

} else {
var statearr_135690_135721 = state_135683__$1;
(statearr_135690_135721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (15))){
var state_135683__$1 = state_135683;
var statearr_135691_135722 = state_135683__$1;
(statearr_135691_135722[(2)] = false);

(statearr_135691_135722[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (21))){
var inst_135675 = (state_135683[(2)]);
var inst_135676 = fluree.db.util.async.throw_err.call(null,inst_135675);
var inst_135677 = fluree.db.query.range.block_with_tx_data.call(null,inst_135676);
var inst_135678 = cljs.core.clj__GT_js.call(null,inst_135677);
var inst_135679 = resolve.call(null,inst_135678);
var state_135683__$1 = state_135683;
var statearr_135692_135723 = state_135683__$1;
(statearr_135692_135723[(2)] = inst_135679);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135683__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (13))){
var inst_135662 = (state_135683[(2)]);
var state_135683__$1 = state_135683;
if(cljs.core.truth_(inst_135662)){
var statearr_135693_135724 = state_135683__$1;
(statearr_135693_135724[(1)] = (17));

} else {
var statearr_135694_135725 = state_135683__$1;
(statearr_135694_135725[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (6))){
var inst_135638 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135683__$1 = state_135683;
var statearr_135695_135726 = state_135683__$1;
(statearr_135695_135726[(2)] = inst_135638);

(statearr_135695_135726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (17))){
var inst_135646 = (state_135683[(10)]);
var inst_135664 = cljs.core.apply.call(null,cljs.core.hash_map,inst_135646);
var state_135683__$1 = state_135683;
var statearr_135696_135727 = state_135683__$1;
(statearr_135696_135727[(2)] = inst_135664);

(statearr_135696_135727[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (3))){
var inst_135628 = (state_135683[(2)]);
var inst_135629 = fluree.db.util.log.error.call(null,inst_135628);
var inst_135630 = reject.call(null,inst_135628);
var state_135683__$1 = (function (){var statearr_135697 = state_135683;
(statearr_135697[(11)] = inst_135629);

return statearr_135697;
})();
var statearr_135698_135728 = state_135683__$1;
(statearr_135698_135728[(2)] = inst_135630);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135683__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (12))){
var state_135683__$1 = state_135683;
var statearr_135699_135729 = state_135683__$1;
(statearr_135699_135729[(2)] = false);

(statearr_135699_135729[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (2))){
var inst_135681 = (state_135683[(2)]);
var state_135683__$1 = state_135683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135683__$1,inst_135681);
} else {
if((state_val_135684 === (19))){
var inst_135640 = (state_135683[(7)]);
var inst_135667 = (state_135683[(2)]);
var inst_135668 = cljs.core.get.call(null,inst_135667,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_135669 = cljs.core.get.call(null,inst_135667,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_135670 = flureenjs.db_instance.call(null,conn,ledger,inst_135640);
var state_135683__$1 = (function (){var statearr_135700 = state_135683;
(statearr_135700[(8)] = inst_135668);

(statearr_135700[(9)] = inst_135669);

return statearr_135700;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135683__$1,(20),inst_135670);
} else {
if((state_val_135684 === (11))){
var inst_135646 = (state_135683[(10)]);
var inst_135651 = inst_135646.cljs$lang$protocol_mask$partition0$;
var inst_135652 = (inst_135651 & (64));
var inst_135653 = inst_135646.cljs$core$ISeq$;
var inst_135654 = (cljs.core.PROTOCOL_SENTINEL === inst_135653);
var inst_135655 = ((inst_135652) || (inst_135654));
var state_135683__$1 = state_135683;
if(cljs.core.truth_(inst_135655)){
var statearr_135701_135730 = state_135683__$1;
(statearr_135701_135730[(1)] = (14));

} else {
var statearr_135702_135731 = state_135683__$1;
(statearr_135702_135731[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (9))){
var inst_135644 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135683__$1 = state_135683;
var statearr_135703_135732 = state_135683__$1;
(statearr_135703_135732[(2)] = inst_135644);

(statearr_135703_135732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (5))){
var state_135683__$1 = state_135683;
var statearr_135704_135733 = state_135683__$1;
(statearr_135704_135733[(2)] = null);

(statearr_135704_135733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (14))){
var state_135683__$1 = state_135683;
var statearr_135705_135734 = state_135683__$1;
(statearr_135705_135734[(2)] = true);

(statearr_135705_135734[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (16))){
var inst_135659 = (state_135683[(2)]);
var state_135683__$1 = state_135683;
var statearr_135706_135735 = state_135683__$1;
(statearr_135706_135735[(2)] = inst_135659);

(statearr_135706_135735[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (10))){
var inst_135646 = (state_135683[(10)]);
var inst_135646__$1 = (state_135683[(2)]);
var inst_135648 = (inst_135646__$1 == null);
var inst_135649 = cljs.core.not.call(null,inst_135648);
var state_135683__$1 = (function (){var statearr_135707 = state_135683;
(statearr_135707[(10)] = inst_135646__$1);

return statearr_135707;
})();
if(inst_135649){
var statearr_135708_135736 = state_135683__$1;
(statearr_135708_135736[(1)] = (11));

} else {
var statearr_135709_135737 = state_135683__$1;
(statearr_135709_135737[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (18))){
var inst_135646 = (state_135683[(10)]);
var state_135683__$1 = state_135683;
var statearr_135710_135738 = state_135683__$1;
(statearr_135710_135738[(2)] = inst_135646);

(statearr_135710_135738[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135684 === (8))){
var state_135683__$1 = state_135683;
var statearr_135711_135739 = state_135683__$1;
(statearr_135711_135739[(2)] = null);

(statearr_135711_135739[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135712 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135712[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135712[(1)] = (1));

return statearr_135712;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135683){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135713){if((e135713 instanceof Object)){
var ex__99978__auto__ = e135713;
var statearr_135714_135740 = state_135683;
(statearr_135714_135740[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135683);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135741 = state_135683;
state_135683 = G__135741;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135683){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135715 = f__100070__auto__.call(null);
(statearr_135715[(6)] = c__100069__auto__);

return statearr_135715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureenjs.block_query = (function flureenjs$block_query(var_args){
var G__135743 = arguments.length;
switch (G__135743) {
case 3:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_query', flureenjs.block_query);

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.block_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135807){
var state_val_135808 = (state_135807[(1)]);
if((state_val_135808 === (7))){
var inst_135756 = (state_135807[(7)]);
var inst_135758 = (state_135807[(8)]);
var inst_135756__$1 = (state_135807[(2)]);
var inst_135757 = fluree.db.connection_js.check_connection.call(null,conn,inst_135756__$1);
var inst_135758__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_135756__$1);
var state_135807__$1 = (function (){var statearr_135809 = state_135807;
(statearr_135809[(7)] = inst_135756__$1);

(statearr_135809[(9)] = inst_135757);

(statearr_135809[(8)] = inst_135758__$1);

return statearr_135809;
})();
if(cljs.core.truth_(inst_135758__$1)){
var statearr_135810_135843 = state_135807__$1;
(statearr_135810_135843[(1)] = (8));

} else {
var statearr_135811_135844 = state_135807__$1;
(statearr_135811_135844[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (20))){
var inst_135801 = (state_135807[(2)]);
var inst_135802 = cljs.core.clj__GT_js.call(null,inst_135801);
var inst_135803 = resolve.call(null,inst_135802);
var state_135807__$1 = state_135807;
var statearr_135812_135845 = state_135807__$1;
(statearr_135812_135845[(2)] = inst_135803);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135807__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (1))){
var state_135807__$1 = state_135807;
var statearr_135813_135846 = state_135807__$1;
(statearr_135813_135846[(2)] = null);

(statearr_135813_135846[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135807,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135750 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_135751 = (opts == null);
var state_135807__$1 = (function (){var statearr_135814 = state_135807;
(statearr_135814[(10)] = inst_135750);

return statearr_135814;
})();
if(cljs.core.truth_(inst_135751)){
var statearr_135815_135847 = state_135807__$1;
(statearr_135815_135847[(1)] = (5));

} else {
var statearr_135816_135848 = state_135807__$1;
(statearr_135816_135848[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (15))){
var inst_135763 = (state_135807[(11)]);
var inst_135770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135771 = ["_auth/id",inst_135763];
var inst_135772 = (new cljs.core.PersistentVector(null,2,(5),inst_135770,inst_135771,null));
var state_135807__$1 = state_135807;
var statearr_135817_135849 = state_135807__$1;
(statearr_135817_135849[(2)] = inst_135772);

(statearr_135817_135849[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (21))){
var inst_135789 = (state_135807[(2)]);
var inst_135790 = fluree.db.util.async.throw_err.call(null,inst_135789);
var state_135807__$1 = state_135807;
var statearr_135818_135850 = state_135807__$1;
(statearr_135818_135850[(2)] = inst_135790);

(statearr_135818_135850[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (13))){
var inst_135765 = (state_135807[(12)]);
var inst_135784 = (state_135807[(2)]);
var inst_135785 = (inst_135765 == null);
var state_135807__$1 = (function (){var statearr_135819 = state_135807;
(statearr_135819[(13)] = inst_135784);

return statearr_135819;
})();
if(cljs.core.truth_(inst_135785)){
var statearr_135820_135851 = state_135807__$1;
(statearr_135820_135851[(1)] = (18));

} else {
var statearr_135821_135852 = state_135807__$1;
(statearr_135821_135852[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (22))){
var inst_135798 = (state_135807[(2)]);
var inst_135799 = fluree.db.util.async.throw_err.call(null,inst_135798);
var state_135807__$1 = state_135807;
var statearr_135822_135853 = state_135807__$1;
(statearr_135822_135853[(2)] = inst_135799);

(statearr_135822_135853[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (6))){
var inst_135754 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_135807__$1 = state_135807;
var statearr_135823_135854 = state_135807__$1;
(statearr_135823_135854[(2)] = inst_135754);

(statearr_135823_135854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (17))){
var inst_135768 = (state_135807[(14)]);
var inst_135764 = (state_135807[(15)]);
var inst_135775 = (state_135807[(2)]);
var inst_135776 = [inst_135775,inst_135764];
var inst_135777 = cljs.core.PersistentHashMap.fromArrays(inst_135768,inst_135776);
var inst_135778 = flureenjs.db_instance.call(null,conn,ledger,inst_135777);
var state_135807__$1 = state_135807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135807__$1,(14),inst_135778);
} else {
if((state_val_135808 === (3))){
var inst_135744 = (state_135807[(2)]);
var inst_135745 = fluree.db.util.log.error.call(null,inst_135744);
var inst_135746 = reject.call(null,inst_135744);
var state_135807__$1 = (function (){var statearr_135824 = state_135807;
(statearr_135824[(16)] = inst_135745);

return statearr_135824;
})();
var statearr_135825_135855 = state_135807__$1;
(statearr_135825_135855[(2)] = inst_135746);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135807__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (12))){
var state_135807__$1 = state_135807;
var statearr_135826_135856 = state_135807__$1;
(statearr_135826_135856[(2)] = null);

(statearr_135826_135856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (2))){
var inst_135805 = (state_135807[(2)]);
var state_135807__$1 = state_135807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135807__$1,inst_135805);
} else {
if((state_val_135808 === (19))){
var inst_135756 = (state_135807[(7)]);
var inst_135750 = (state_135807[(10)]);
var inst_135792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135793 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_135794 = (new cljs.core.PersistentVector(null,1,(5),inst_135792,inst_135793,null));
var inst_135795 = cljs.core.assoc_in.call(null,inst_135756,inst_135794,new cljs.core.Keyword(null,"block","block",664686210));
var inst_135796 = fluree.db.api_js.signed_query_async.call(null,conn,ledger,inst_135750,inst_135795);
var state_135807__$1 = state_135807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135807__$1,(22),inst_135796);
} else {
if((state_val_135808 === (11))){
var inst_135763 = (state_135807[(11)]);
var inst_135768 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_135807__$1 = (function (){var statearr_135827 = state_135807;
(statearr_135827[(14)] = inst_135768);

return statearr_135827;
})();
if(cljs.core.truth_(inst_135763)){
var statearr_135828_135857 = state_135807__$1;
(statearr_135828_135857[(1)] = (15));

} else {
var statearr_135829_135858 = state_135807__$1;
(statearr_135829_135858[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (9))){
var inst_135756 = (state_135807[(7)]);
var inst_135761 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_135756);
var state_135807__$1 = state_135807;
var statearr_135830_135859 = state_135807__$1;
(statearr_135830_135859[(2)] = inst_135761);

(statearr_135830_135859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (5))){
var state_135807__$1 = state_135807;
var statearr_135831_135860 = state_135807__$1;
(statearr_135831_135860[(2)] = null);

(statearr_135831_135860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (14))){
var inst_135780 = (state_135807[(2)]);
var inst_135781 = fluree.db.util.async.throw_err.call(null,inst_135780);
var state_135807__$1 = state_135807;
var statearr_135832_135861 = state_135807__$1;
(statearr_135832_135861[(2)] = inst_135781);

(statearr_135832_135861[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (16))){
var state_135807__$1 = state_135807;
var statearr_135833_135862 = state_135807__$1;
(statearr_135833_135862[(2)] = null);

(statearr_135833_135862[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (10))){
var inst_135756 = (state_135807[(7)]);
var inst_135765 = (state_135807[(12)]);
var inst_135763 = (state_135807[(2)]);
var inst_135764 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_135756);
var inst_135765__$1 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_135756);
var inst_135766 = (inst_135765__$1 == null);
var state_135807__$1 = (function (){var statearr_135834 = state_135807;
(statearr_135834[(15)] = inst_135764);

(statearr_135834[(11)] = inst_135763);

(statearr_135834[(12)] = inst_135765__$1);

return statearr_135834;
})();
if(cljs.core.truth_(inst_135766)){
var statearr_135835_135863 = state_135807__$1;
(statearr_135835_135863[(1)] = (11));

} else {
var statearr_135836_135864 = state_135807__$1;
(statearr_135836_135864[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135808 === (18))){
var inst_135784 = (state_135807[(13)]);
var inst_135756 = (state_135807[(7)]);
var inst_135750 = (state_135807[(10)]);
var inst_135787 = fluree.db.api_js.block_query_async.call(null,inst_135784,inst_135750,inst_135756);
var state_135807__$1 = state_135807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_135807__$1,(21),inst_135787);
} else {
if((state_val_135808 === (8))){
var inst_135758 = (state_135807[(8)]);
var state_135807__$1 = state_135807;
var statearr_135837_135865 = state_135807__$1;
(statearr_135837_135865[(2)] = inst_135758);

(statearr_135837_135865[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_135838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135838[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_135838[(1)] = (1));

return statearr_135838;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_135807){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135839){if((e135839 instanceof Object)){
var ex__99978__auto__ = e135839;
var statearr_135840_135866 = state_135807;
(statearr_135840_135866[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135867 = state_135807;
state_135807 = G__135867;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_135807){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_135807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135841 = f__100070__auto__.call(null);
(statearr_135841[(6)] = c__100069__auto__);

return statearr_135841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.block_query.cljs$lang$maxFixedArity = 4);

/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A forward-time-travel db can be further forward-time-traveled.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
flureenjs.forward_time_travel = (function flureenjs$forward_time_travel(db,flakes){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135880){
var state_val_135881 = (state_135880[(1)]);
if((state_val_135881 === (1))){
var state_135880__$1 = state_135880;
var statearr_135882_135890 = state_135880__$1;
(statearr_135882_135890[(2)] = null);

(statearr_135882_135890[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135881 === (2))){
var inst_135878 = (state_135880[(2)]);
var state_135880__$1 = state_135880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135880__$1,inst_135878);
} else {
if((state_val_135881 === (3))){
var inst_135868 = (state_135880[(2)]);
var inst_135869 = fluree.db.util.log.error.call(null,inst_135868);
var inst_135870 = reject.call(null,inst_135868);
var state_135880__$1 = (function (){var statearr_135883 = state_135880;
(statearr_135883[(7)] = inst_135869);

return statearr_135883;
})();
var statearr_135884_135891 = state_135880__$1;
(statearr_135884_135891[(2)] = inst_135870);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135880__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135881 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135880,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135874 = fluree.db.graphdb.forward_time_travel.call(null,db,null,flakes);
var inst_135875 = cljs.core.clj__GT_js.call(null,inst_135874);
var inst_135876 = resolve.call(null,inst_135875);
var state_135880__$1 = state_135880;
var statearr_135885_135892 = state_135880__$1;
(statearr_135885_135892[(2)] = inst_135876);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135880__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_$_state_machine__99975__auto__ = null;
var flureenjs$forward_time_travel_$_state_machine__99975__auto____0 = (function (){
var statearr_135886 = [null,null,null,null,null,null,null,null];
(statearr_135886[(0)] = flureenjs$forward_time_travel_$_state_machine__99975__auto__);

(statearr_135886[(1)] = (1));

return statearr_135886;
});
var flureenjs$forward_time_travel_$_state_machine__99975__auto____1 = (function (state_135880){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135887){if((e135887 instanceof Object)){
var ex__99978__auto__ = e135887;
var statearr_135888_135893 = state_135880;
(statearr_135888_135893[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135894 = state_135880;
state_135880 = G__135894;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$forward_time_travel_$_state_machine__99975__auto__ = function(state_135880){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_$_state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_$_state_machine__99975__auto____1.call(this,state_135880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_$_state_machine__99975__auto____0;
flureenjs$forward_time_travel_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_$_state_machine__99975__auto____1;
return flureenjs$forward_time_travel_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135889 = f__100070__auto__.call(null);
(statearr_135889[(6)] = c__100069__auto__);

return statearr_135889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.forward_time_travel_db_QMARK_ = (function flureenjs$forward_time_travel_db_QMARK_(db){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_135907){
var state_val_135908 = (state_135907[(1)]);
if((state_val_135908 === (1))){
var state_135907__$1 = state_135907;
var statearr_135909_135917 = state_135907__$1;
(statearr_135909_135917[(2)] = null);

(statearr_135909_135917[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135908 === (2))){
var inst_135905 = (state_135907[(2)]);
var state_135907__$1 = state_135907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_135907__$1,inst_135905);
} else {
if((state_val_135908 === (3))){
var inst_135895 = (state_135907[(2)]);
var inst_135896 = fluree.db.util.log.error.call(null,inst_135895);
var inst_135897 = reject.call(null,inst_135895);
var state_135907__$1 = (function (){var statearr_135910 = state_135907;
(statearr_135910[(7)] = inst_135896);

return statearr_135910;
})();
var statearr_135911_135918 = state_135907__$1;
(statearr_135911_135918[(2)] = inst_135897);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135907__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_135908 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_135907,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135901 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,db);
var inst_135902 = cljs.core.clj__GT_js.call(null,inst_135901);
var inst_135903 = resolve.call(null,inst_135902);
var state_135907__$1 = state_135907;
var statearr_135912_135919 = state_135907__$1;
(statearr_135912_135919[(2)] = inst_135903);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135907__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__ = null;
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____0 = (function (){
var statearr_135913 = [null,null,null,null,null,null,null,null];
(statearr_135913[(0)] = flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__);

(statearr_135913[(1)] = (1));

return statearr_135913;
});
var flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____1 = (function (state_135907){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_135907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e135914){if((e135914 instanceof Object)){
var ex__99978__auto__ = e135914;
var statearr_135915_135920 = state_135907;
(statearr_135915_135920[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_135907);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e135914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__135921 = state_135907;
state_135907 = G__135921;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__ = function(state_135907){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____1.call(this,state_135907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____0;
flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto____1;
return flureenjs$forward_time_travel_db_QMARK__$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_135916 = f__100070__auto__.call(null);
(statearr_135916[(6)] = c__100069__auto__);

return statearr_135916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
});
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__135923 = arguments.length;
switch (G__135923) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,db_name,param){
return flureenjs.graphql.call(null,conn,db_name,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,db_name,param,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136043){
var state_val_136044 = (state_136043[(1)]);
if((state_val_136044 === (7))){
var inst_135951 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
if(cljs.core.truth_(inst_135951)){
var statearr_136045_136103 = state_136043__$1;
(statearr_136045_136103[(1)] = (11));

} else {
var statearr_136046_136104 = state_136043__$1;
(statearr_136046_136104[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (20))){
var inst_135976 = (state_136043[(7)]);
var inst_135980 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_135981 = (new cljs.core.PersistentArrayMap(null,2,inst_135980,null));
var inst_135982 = (new cljs.core.PersistentHashSet(null,inst_135981,null));
var inst_135983 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_135976);
var inst_135984 = inst_135982.call(null,inst_135983);
var state_136043__$1 = state_136043;
if(cljs.core.truth_(inst_135984)){
var statearr_136047_136105 = state_136043__$1;
(statearr_136047_136105[(1)] = (22));

} else {
var statearr_136048_136106 = state_136043__$1;
(statearr_136048_136106[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (27))){
var inst_135992 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136049_136107 = state_136043__$1;
(statearr_136049_136107[(2)] = inst_135992);

(statearr_136049_136107[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (1))){
var state_136043__$1 = state_136043;
var statearr_136050_136108 = state_136043__$1;
(statearr_136050_136108[(2)] = null);

(statearr_136050_136108[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (24))){
var inst_136035 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136051_136109 = state_136043__$1;
(statearr_136051_136109[(2)] = inst_136035);

(statearr_136051_136109[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (39))){
var inst_136017 = (state_136043[(2)]);
var inst_136018 = fluree.db.util.async.throw_err.call(null,inst_136017);
var state_136043__$1 = state_136043;
var statearr_136052_136110 = state_136043__$1;
(statearr_136052_136110[(2)] = inst_136018);

(statearr_136052_136110[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (4))){
var inst_135934 = (state_136043[(8)]);
var inst_135933 = (state_136043[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136043,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_135932 = fluree.db.util.json.parse.call(null,param);
var inst_135933__$1 = cljs.core.js__GT_clj.call(null,inst_135932,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_135934__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_135935 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_135934__$1);
var inst_135937 = (inst_135933__$1 == null);
var inst_135938 = cljs.core.not.call(null,inst_135937);
var state_136043__$1 = (function (){var statearr_136053 = state_136043;
(statearr_136053[(8)] = inst_135934__$1);

(statearr_136053[(9)] = inst_135933__$1);

(statearr_136053[(10)] = inst_135935);

return statearr_136053;
})();
if(inst_135938){
var statearr_136054_136111 = state_136043__$1;
(statearr_136054_136111[(1)] = (5));

} else {
var statearr_136055_136112 = state_136043__$1;
(statearr_136055_136112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (15))){
var state_136043__$1 = state_136043;
var statearr_136056_136113 = state_136043__$1;
(statearr_136056_136113[(2)] = null);

(statearr_136056_136113[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (21))){
var inst_136037 = (state_136043[(2)]);
var inst_136038 = cljs.core.clj__GT_js.call(null,inst_136037);
var inst_136039 = resolve.call(null,inst_136038);
var state_136043__$1 = state_136043;
var statearr_136057_136114 = state_136043__$1;
(statearr_136057_136114[(2)] = inst_136039);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136043__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (31))){
var inst_136000 = (state_136043[(2)]);
var inst_136001 = fluree.db.util.async.throw_err.call(null,inst_136000);
var state_136043__$1 = state_136043;
var statearr_136058_136115 = state_136043__$1;
(statearr_136058_136115[(2)] = inst_136001);

(statearr_136058_136115[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (32))){
var inst_135934 = (state_136043[(8)]);
var inst_135972 = (state_136043[(11)]);
var inst_135976 = (state_136043[(7)]);
var inst_136006 = cljs.core.dissoc.call(null,inst_135976,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_136007 = fluree.db.api_js.block_query_async.call(null,inst_135972,inst_136006,inst_135934);
var state_136043__$1 = state_136043;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(35),inst_136007);
} else {
if((state_val_136044 === (40))){
var inst_135934 = (state_136043[(8)]);
var inst_135976 = (state_136043[(7)]);
var inst_135969 = (state_136043[(12)]);
var inst_136021 = fluree.db.api_js.multi_query_async.call(null,inst_135969,inst_135976,inst_135934);
var state_136043__$1 = state_136043;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(43),inst_136021);
} else {
if((state_val_136044 === (33))){
var inst_135976 = (state_136043[(7)]);
var inst_136012 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_135976);
var state_136043__$1 = state_136043;
if(cljs.core.truth_(inst_136012)){
var statearr_136059_136116 = state_136043__$1;
(statearr_136059_136116[(1)] = (36));

} else {
var statearr_136060_136117 = state_136043__$1;
(statearr_136060_136117[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (13))){
var inst_135935 = (state_136043[(10)]);
var inst_135956 = (state_136043[(2)]);
var inst_135957 = cljs.core.get.call(null,inst_135956,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_135958 = cljs.core.get.call(null,inst_135956,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_135959 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_136043__$1 = (function (){var statearr_136061 = state_136043;
(statearr_136061[(13)] = inst_135959);

(statearr_136061[(14)] = inst_135958);

(statearr_136061[(15)] = inst_135957);

return statearr_136061;
})();
if(cljs.core.truth_(inst_135935)){
var statearr_136062_136118 = state_136043__$1;
(statearr_136062_136118[(1)] = (14));

} else {
var statearr_136063_136119 = state_136043__$1;
(statearr_136063_136119[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (22))){
var inst_135934 = (state_136043[(8)]);
var inst_135986 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_135934);
var state_136043__$1 = state_136043;
if(cljs.core.truth_(inst_135986)){
var statearr_136064_136120 = state_136043__$1;
(statearr_136064_136120[(1)] = (25));

} else {
var statearr_136065_136121 = state_136043__$1;
(statearr_136065_136121[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (36))){
var inst_135934 = (state_136043[(8)]);
var inst_135976 = (state_136043[(7)]);
var inst_136014 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_135976);
var inst_136015 = fluree.db.api_js.transact_async.call(null,conn,db_name,inst_136014,inst_135934);
var state_136043__$1 = state_136043;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(39),inst_136015);
} else {
if((state_val_136044 === (41))){
var state_136043__$1 = state_136043;
var statearr_136066_136122 = state_136043__$1;
(statearr_136066_136122[(2)] = null);

(statearr_136066_136122[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (43))){
var inst_136023 = (state_136043[(2)]);
var inst_136024 = fluree.db.util.async.throw_err.call(null,inst_136023);
var state_136043__$1 = state_136043;
var statearr_136067_136123 = state_136043__$1;
(statearr_136067_136123[(2)] = inst_136024);

(statearr_136067_136123[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (29))){
var inst_135976 = (state_136043[(7)]);
var inst_136003 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_135976);
var inst_136004 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_136003);
var state_136043__$1 = state_136043;
if(inst_136004){
var statearr_136068_136124 = state_136043__$1;
(statearr_136068_136124[(1)] = (32));

} else {
var statearr_136069_136125 = state_136043__$1;
(statearr_136069_136125[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (6))){
var state_136043__$1 = state_136043;
var statearr_136070_136126 = state_136043__$1;
(statearr_136070_136126[(2)] = false);

(statearr_136070_136126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (28))){
var inst_135934 = (state_136043[(8)]);
var inst_135972 = (state_136043[(11)]);
var inst_135976 = (state_136043[(7)]);
var inst_135997 = cljs.core.dissoc.call(null,inst_135976,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_135998 = fluree.db.api_js.history_query_async.call(null,inst_135972,inst_135997,inst_135934);
var state_136043__$1 = state_136043;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(31),inst_135998);
} else {
if((state_val_136044 === (25))){
var inst_135976 = (state_136043[(7)]);
var inst_135988 = cljs.core.dissoc.call(null,inst_135976,new cljs.core.Keyword(null,"type","type",1174270348));
var state_136043__$1 = state_136043;
var statearr_136071_136127 = state_136043__$1;
(statearr_136071_136127[(2)] = inst_135988);

(statearr_136071_136127[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (34))){
var inst_136031 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136072_136128 = state_136043__$1;
(statearr_136072_136128[(2)] = inst_136031);

(statearr_136072_136128[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (17))){
var inst_135934 = (state_136043[(8)]);
var inst_135972 = (state_136043[(11)]);
var inst_135958 = (state_136043[(14)]);
var inst_135957 = (state_136043[(15)]);
var inst_135971 = (state_136043[(2)]);
var inst_135972__$1 = fluree.db.util.async.throw_err.call(null,inst_135971);
var inst_135973 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_135972__$1,inst_135957,inst_135958,inst_135934);
var state_136043__$1 = (function (){var statearr_136073 = state_136043;
(statearr_136073[(11)] = inst_135972__$1);

return statearr_136073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(18),inst_135973);
} else {
if((state_val_136044 === (3))){
var inst_135924 = (state_136043[(2)]);
var inst_135925 = fluree.db.util.log.error.call(null,inst_135924);
var inst_135926 = cljs.core.clj__GT_js.call(null,inst_135924);
var inst_135927 = reject.call(null,inst_135926);
var state_136043__$1 = (function (){var statearr_136074 = state_136043;
(statearr_136074[(16)] = inst_135925);

return statearr_136074;
})();
var statearr_136075_136129 = state_136043__$1;
(statearr_136075_136129[(2)] = inst_135927);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136043__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (12))){
var inst_135933 = (state_136043[(9)]);
var state_136043__$1 = state_136043;
var statearr_136076_136130 = state_136043__$1;
(statearr_136076_136130[(2)] = inst_135933);

(statearr_136076_136130[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (2))){
var inst_136041 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136043__$1,inst_136041);
} else {
if((state_val_136044 === (23))){
var inst_135976 = (state_136043[(7)]);
var inst_135994 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_135976);
var inst_135995 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_135994);
var state_136043__$1 = state_136043;
if(inst_135995){
var statearr_136077_136131 = state_136043__$1;
(statearr_136077_136131[(1)] = (28));

} else {
var statearr_136078_136132 = state_136043__$1;
(statearr_136078_136132[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (35))){
var inst_136009 = (state_136043[(2)]);
var inst_136010 = fluree.db.util.async.throw_err.call(null,inst_136009);
var state_136043__$1 = state_136043;
var statearr_136079_136133 = state_136043__$1;
(statearr_136079_136133[(2)] = inst_136010);

(statearr_136079_136133[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (19))){
var inst_135976 = (state_136043[(7)]);
var state_136043__$1 = state_136043;
var statearr_136080_136134 = state_136043__$1;
(statearr_136080_136134[(2)] = inst_135976);

(statearr_136080_136134[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (11))){
var inst_135933 = (state_136043[(9)]);
var inst_135953 = cljs.core.apply.call(null,cljs.core.hash_map,inst_135933);
var state_136043__$1 = state_136043;
var statearr_136081_136135 = state_136043__$1;
(statearr_136081_136135[(2)] = inst_135953);

(statearr_136081_136135[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (9))){
var state_136043__$1 = state_136043;
var statearr_136082_136136 = state_136043__$1;
(statearr_136082_136136[(2)] = false);

(statearr_136082_136136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (5))){
var inst_135933 = (state_136043[(9)]);
var inst_135940 = inst_135933.cljs$lang$protocol_mask$partition0$;
var inst_135941 = (inst_135940 & (64));
var inst_135942 = inst_135933.cljs$core$ISeq$;
var inst_135943 = (cljs.core.PROTOCOL_SENTINEL === inst_135942);
var inst_135944 = ((inst_135941) || (inst_135943));
var state_136043__$1 = state_136043;
if(cljs.core.truth_(inst_135944)){
var statearr_136083_136137 = state_136043__$1;
(statearr_136083_136137[(1)] = (8));

} else {
var statearr_136084_136138 = state_136043__$1;
(statearr_136084_136138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (14))){
var inst_135935 = (state_136043[(10)]);
var inst_135961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135962 = ["_auth/id",inst_135935];
var inst_135963 = (new cljs.core.PersistentVector(null,2,(5),inst_135961,inst_135962,null));
var state_136043__$1 = state_136043;
var statearr_136085_136139 = state_136043__$1;
(statearr_136085_136139[(2)] = inst_135963);

(statearr_136085_136139[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (26))){
var inst_135976 = (state_136043[(7)]);
var inst_135990 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_135976);
var state_136043__$1 = state_136043;
var statearr_136086_136140 = state_136043__$1;
(statearr_136086_136140[(2)] = inst_135990);

(statearr_136086_136140[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (16))){
var inst_135959 = (state_136043[(13)]);
var inst_135969 = (state_136043[(12)]);
var inst_135966 = (state_136043[(2)]);
var inst_135967 = [inst_135966];
var inst_135968 = cljs.core.PersistentHashMap.fromArrays(inst_135959,inst_135967);
var inst_135969__$1 = flureenjs.db_instance.call(null,conn,db_name,inst_135968);
var state_136043__$1 = (function (){var statearr_136087 = state_136043;
(statearr_136087[(12)] = inst_135969__$1);

return statearr_136087;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136043__$1,(17),inst_135969__$1);
} else {
if((state_val_136044 === (38))){
var inst_136029 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136088_136141 = state_136043__$1;
(statearr_136088_136141[(2)] = inst_136029);

(statearr_136088_136141[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (30))){
var inst_136033 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136089_136142 = state_136043__$1;
(statearr_136089_136142[(2)] = inst_136033);

(statearr_136089_136142[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (10))){
var inst_135948 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136090_136143 = state_136043__$1;
(statearr_136090_136143[(2)] = inst_135948);

(statearr_136090_136143[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (18))){
var inst_135976 = (state_136043[(7)]);
var inst_135975 = (state_136043[(2)]);
var inst_135976__$1 = fluree.db.util.async.throw_err.call(null,inst_135975);
var inst_135977 = fluree.db.util.core.exception_QMARK_.call(null,inst_135976__$1);
var state_136043__$1 = (function (){var statearr_136091 = state_136043;
(statearr_136091[(7)] = inst_135976__$1);

return statearr_136091;
})();
if(inst_135977){
var statearr_136092_136144 = state_136043__$1;
(statearr_136092_136144[(1)] = (19));

} else {
var statearr_136093_136145 = state_136043__$1;
(statearr_136093_136145[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (42))){
var inst_136027 = (state_136043[(2)]);
var state_136043__$1 = state_136043;
var statearr_136094_136146 = state_136043__$1;
(statearr_136094_136146[(2)] = inst_136027);

(statearr_136094_136146[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (37))){
var state_136043__$1 = state_136043;
var statearr_136095_136147 = state_136043__$1;
(statearr_136095_136147[(1)] = (40));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136044 === (8))){
var state_136043__$1 = state_136043;
var statearr_136097_136148 = state_136043__$1;
(statearr_136097_136148[(2)] = true);

(statearr_136097_136148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136098 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_136098[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136098[(1)] = (1));

return statearr_136098;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136043){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136043);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136099){if((e136099 instanceof Object)){
var ex__99978__auto__ = e136099;
var statearr_136100_136149 = state_136043;
(statearr_136100_136149[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136043);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136150 = state_136043;
state_136043 = G__136150;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136043){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136101 = f__100070__auto__.call(null);
(statearr_136101[(6)] = c__100069__auto__);

return statearr_136101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.history_query = (function flureenjs$history_query(var_args){
var G__136152 = arguments.length;
switch (G__136152) {
case 2:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.history_query', flureenjs.history_query);

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.history_query.call(null,sources,query_map,null);
}));

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136177){
var state_val_136178 = (state_136177[(1)]);
if((state_val_136178 === (1))){
var state_136177__$1 = state_136177;
var statearr_136179_136193 = state_136177__$1;
(statearr_136179_136193[(2)] = null);

(statearr_136179_136193[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136178 === (2))){
var inst_136175 = (state_136177[(2)]);
var state_136177__$1 = state_136177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136177__$1,inst_136175);
} else {
if((state_val_136178 === (3))){
var inst_136153 = (state_136177[(2)]);
var inst_136154 = fluree.db.util.log.error.call(null,inst_136153);
var inst_136155 = reject.call(null,inst_136153);
var state_136177__$1 = (function (){var statearr_136180 = state_136177;
(statearr_136180[(7)] = inst_136154);

return statearr_136180;
})();
var statearr_136181_136194 = state_136177__$1;
(statearr_136181_136194[(2)] = inst_136155);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136177__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136178 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136177,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_136159 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136160 = (opts == null);
var inst_136161 = cljs.core.empty_QMARK_.call(null,opts);
var inst_136162 = ((inst_136160) || (inst_136161));
var state_136177__$1 = (function (){var statearr_136182 = state_136177;
(statearr_136182[(8)] = inst_136159);

return statearr_136182;
})();
if(cljs.core.truth_(inst_136162)){
var statearr_136183_136195 = state_136177__$1;
(statearr_136183_136195[(1)] = (5));

} else {
var statearr_136184_136196 = state_136177__$1;
(statearr_136184_136196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136178 === (5))){
var state_136177__$1 = state_136177;
var statearr_136185_136197 = state_136177__$1;
(statearr_136185_136197[(2)] = null);

(statearr_136185_136197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136178 === (6))){
var inst_136165 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_136177__$1 = state_136177;
var statearr_136186_136198 = state_136177__$1;
(statearr_136186_136198[(2)] = inst_136165);

(statearr_136186_136198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136178 === (7))){
var inst_136159 = (state_136177[(8)]);
var inst_136167 = (state_136177[(2)]);
var inst_136168 = fluree.db.api_js.history_query_async.call(null,sources,inst_136159,inst_136167);
var state_136177__$1 = state_136177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136177__$1,(8),inst_136168);
} else {
if((state_val_136178 === (8))){
var inst_136170 = (state_136177[(2)]);
var inst_136171 = fluree.db.util.async.throw_err.call(null,inst_136170);
var inst_136172 = cljs.core.clj__GT_js.call(null,inst_136171);
var inst_136173 = resolve.call(null,inst_136172);
var state_136177__$1 = state_136177;
var statearr_136187_136199 = state_136177__$1;
(statearr_136187_136199[(2)] = inst_136173);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136177__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136188 = [null,null,null,null,null,null,null,null,null];
(statearr_136188[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136188[(1)] = (1));

return statearr_136188;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136177){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136189){if((e136189 instanceof Object)){
var ex__99978__auto__ = e136189;
var statearr_136190_136200 = state_136177;
(statearr_136190_136200[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136177);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136201 = state_136177;
state_136177 = G__136201;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136177){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136191 = f__100070__auto__.call(null);
(statearr_136191[(6)] = c__100069__auto__);

return statearr_136191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.history_query.cljs$lang$maxFixedArity = 3);

flureenjs.multi_query = (function flureenjs$multi_query(var_args){
var G__136203 = arguments.length;
switch (G__136203) {
case 2:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multi_query', flureenjs.multi_query);

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return flureenjs.multi_query.call(null,sources,multi_query_map,null);
}));

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136221){
var state_val_136222 = (state_136221[(1)]);
if((state_val_136222 === (1))){
var state_136221__$1 = state_136221;
var statearr_136223_136232 = state_136221__$1;
(statearr_136223_136232[(2)] = null);

(statearr_136223_136232[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136222 === (2))){
var inst_136219 = (state_136221[(2)]);
var state_136221__$1 = state_136221;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136221__$1,inst_136219);
} else {
if((state_val_136222 === (3))){
var inst_136204 = (state_136221[(2)]);
var inst_136205 = fluree.db.util.log.error.call(null,inst_136204);
var inst_136206 = reject.call(null,inst_136204);
var state_136221__$1 = (function (){var statearr_136224 = state_136221;
(statearr_136224[(7)] = inst_136205);

return statearr_136224;
})();
var statearr_136225_136233 = state_136221__$1;
(statearr_136225_136233[(2)] = inst_136206);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136221__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136222 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136221,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_136210 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136211 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136212 = fluree.db.api_js.multi_query_async.call(null,sources,inst_136210,inst_136211,flureenjs.db_instance);
var state_136221__$1 = state_136221;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136221__$1,(5),inst_136212);
} else {
if((state_val_136222 === (5))){
var inst_136214 = (state_136221[(2)]);
var inst_136215 = fluree.db.util.async.throw_err.call(null,inst_136214);
var inst_136216 = cljs.core.clj__GT_js.call(null,inst_136215);
var inst_136217 = resolve.call(null,inst_136216);
var state_136221__$1 = state_136221;
var statearr_136226_136234 = state_136221__$1;
(statearr_136226_136234[(2)] = inst_136217);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136221__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136227 = [null,null,null,null,null,null,null,null];
(statearr_136227[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136227[(1)] = (1));

return statearr_136227;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136221){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136221);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136228){if((e136228 instanceof Object)){
var ex__99978__auto__ = e136228;
var statearr_136229_136235 = state_136221;
(statearr_136229_136235[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136221);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136228;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136236 = state_136221;
state_136221 = G__136236;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136221){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136230 = f__100070__auto__.call(null);
(statearr_136230[(6)] = c__100069__auto__);

return statearr_136230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.multi_query.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureenjs.q = (function flureenjs$q(var_args){
var G__136238 = arguments.length;
switch (G__136238) {
case 2:
return flureenjs.q.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.q.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.q', flureenjs.q);

(flureenjs.q.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.q.call(null,sources,query_map,null);
}));

(flureenjs.q.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136261){
var state_val_136262 = (state_136261[(1)]);
if((state_val_136262 === (1))){
var state_136261__$1 = state_136261;
var statearr_136263_136277 = state_136261__$1;
(statearr_136263_136277[(2)] = null);

(statearr_136263_136277[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136262 === (2))){
var inst_136259 = (state_136261[(2)]);
var state_136261__$1 = state_136261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136261__$1,inst_136259);
} else {
if((state_val_136262 === (3))){
var inst_136239 = (state_136261[(2)]);
var inst_136240 = fluree.db.util.log.error.call(null,inst_136239);
var inst_136241 = cljs.core.clj__GT_js.call(null,inst_136239);
var inst_136242 = reject.call(null,inst_136241);
var state_136261__$1 = (function (){var statearr_136264 = state_136261;
(statearr_136264[(7)] = inst_136240);

return statearr_136264;
})();
var statearr_136265_136278 = state_136261__$1;
(statearr_136265_136278[(2)] = inst_136242);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136261__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136262 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136261,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_136246 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136247 = (opts == null);
var state_136261__$1 = (function (){var statearr_136266 = state_136261;
(statearr_136266[(8)] = inst_136246);

return statearr_136266;
})();
if(cljs.core.truth_(inst_136247)){
var statearr_136267_136279 = state_136261__$1;
(statearr_136267_136279[(1)] = (5));

} else {
var statearr_136268_136280 = state_136261__$1;
(statearr_136268_136280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136262 === (5))){
var state_136261__$1 = state_136261;
var statearr_136269_136281 = state_136261__$1;
(statearr_136269_136281[(2)] = null);

(statearr_136269_136281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136262 === (6))){
var inst_136250 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_136261__$1 = state_136261;
var statearr_136270_136282 = state_136261__$1;
(statearr_136270_136282[(2)] = inst_136250);

(statearr_136270_136282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136262 === (7))){
var inst_136246 = (state_136261[(8)]);
var inst_136252 = (state_136261[(2)]);
var inst_136253 = fluree.db.api_js.query_async.call(null,sources,inst_136246,inst_136252,flureenjs.db_instance);
var state_136261__$1 = state_136261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136261__$1,(8),inst_136253);
} else {
if((state_val_136262 === (8))){
var inst_136255 = (state_136261[(2)]);
var inst_136256 = cljs.core.clj__GT_js.call(null,inst_136255);
var inst_136257 = resolve.call(null,inst_136256);
var state_136261__$1 = state_136261;
var statearr_136271_136283 = state_136261__$1;
(statearr_136271_136283[(2)] = inst_136257);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136261__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136272 = [null,null,null,null,null,null,null,null,null];
(statearr_136272[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136272[(1)] = (1));

return statearr_136272;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136261){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136273){if((e136273 instanceof Object)){
var ex__99978__auto__ = e136273;
var statearr_136274_136284 = state_136261;
(statearr_136274_136284[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136285 = state_136261;
state_136261 = G__136285;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136261){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136275 = f__100070__auto__.call(null);
(statearr_136275[(6)] = c__100069__auto__);

return statearr_136275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.q.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureenjs.signed_query = (function flureenjs$signed_query(var_args){
var G__136287 = arguments.length;
switch (G__136287) {
case 3:
return flureenjs.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.signed_query', flureenjs.signed_query);

(flureenjs.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.signed_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136311){
var state_val_136312 = (state_136311[(1)]);
if((state_val_136312 === (1))){
var state_136311__$1 = state_136311;
var statearr_136313_136327 = state_136311__$1;
(statearr_136313_136327[(2)] = null);

(statearr_136313_136327[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136312 === (2))){
var inst_136309 = (state_136311[(2)]);
var state_136311__$1 = state_136311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136311__$1,inst_136309);
} else {
if((state_val_136312 === (3))){
var inst_136288 = (state_136311[(2)]);
var inst_136289 = fluree.db.util.log.error.call(null,inst_136288);
var inst_136290 = cljs.core.clj__GT_js.call(null,inst_136288);
var inst_136291 = reject.call(null,inst_136290);
var state_136311__$1 = (function (){var statearr_136314 = state_136311;
(statearr_136314[(7)] = inst_136289);

return statearr_136314;
})();
var statearr_136315_136328 = state_136311__$1;
(statearr_136315_136328[(2)] = inst_136291);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136311__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136312 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136311,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_136295 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136296 = (opts == null);
var state_136311__$1 = (function (){var statearr_136316 = state_136311;
(statearr_136316[(8)] = inst_136295);

return statearr_136316;
})();
if(cljs.core.truth_(inst_136296)){
var statearr_136317_136329 = state_136311__$1;
(statearr_136317_136329[(1)] = (5));

} else {
var statearr_136318_136330 = state_136311__$1;
(statearr_136318_136330[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136312 === (5))){
var state_136311__$1 = state_136311;
var statearr_136319_136331 = state_136311__$1;
(statearr_136319_136331[(2)] = null);

(statearr_136319_136331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136312 === (6))){
var inst_136299 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_136311__$1 = state_136311;
var statearr_136320_136332 = state_136311__$1;
(statearr_136320_136332[(2)] = inst_136299);

(statearr_136320_136332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136312 === (7))){
var inst_136295 = (state_136311[(8)]);
var inst_136301 = (state_136311[(2)]);
var inst_136302 = fluree.db.api_js.signed_query_async.call(null,conn,ledger,inst_136295,inst_136301);
var state_136311__$1 = state_136311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136311__$1,(8),inst_136302);
} else {
if((state_val_136312 === (8))){
var inst_136304 = (state_136311[(2)]);
var inst_136305 = fluree.db.util.async.throw_err.call(null,inst_136304);
var inst_136306 = cljs.core.clj__GT_js.call(null,inst_136305);
var inst_136307 = resolve.call(null,inst_136306);
var state_136311__$1 = state_136311;
var statearr_136321_136333 = state_136311__$1;
(statearr_136321_136333[(2)] = inst_136307);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136311__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136322 = [null,null,null,null,null,null,null,null,null];
(statearr_136322[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136322[(1)] = (1));

return statearr_136322;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136311){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136323){if((e136323 instanceof Object)){
var ex__99978__auto__ = e136323;
var statearr_136324_136334 = state_136311;
(statearr_136324_136334[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136311);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136323;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136335 = state_136311;
state_136311 = G__136335;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136311){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136325 = f__100070__auto__.call(null);
(statearr_136325[(6)] = c__100069__auto__);

return statearr_136325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__136337 = arguments.length;
switch (G__136337) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_136357){
var state_val_136358 = (state_136357[(1)]);
if((state_val_136358 === (1))){
var state_136357__$1 = state_136357;
var statearr_136359_136368 = state_136357__$1;
(statearr_136359_136368[(2)] = null);

(statearr_136359_136368[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136358 === (2))){
var inst_136355 = (state_136357[(2)]);
var state_136357__$1 = state_136357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_136357__$1,inst_136355);
} else {
if((state_val_136358 === (3))){
var inst_136338 = (state_136357[(2)]);
var inst_136339 = fluree.db.util.log.error.call(null,inst_136338);
var inst_136340 = cljs.core.clj__GT_js.call(null,inst_136338);
var inst_136341 = reject.call(null,inst_136340);
var state_136357__$1 = (function (){var statearr_136360 = state_136357;
(statearr_136360[(7)] = inst_136339);

return statearr_136360;
})();
var statearr_136361_136369 = state_136357__$1;
(statearr_136361_136369[(2)] = inst_136341);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136357__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_136358 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_136357,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_136345 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_136346 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_136347 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_136346);
var inst_136348 = fluree.db.api_js.query_async.call(null,db,inst_136347,inst_136345,flureenjs.db_instance);
var state_136357__$1 = state_136357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_136357__$1,(5),inst_136348);
} else {
if((state_val_136358 === (5))){
var inst_136350 = (state_136357[(2)]);
var inst_136351 = fluree.db.util.async.throw_err.call(null,inst_136350);
var inst_136352 = cljs.core.clj__GT_js.call(null,inst_136351);
var inst_136353 = resolve.call(null,inst_136352);
var state_136357__$1 = state_136357;
var statearr_136362_136370 = state_136357__$1;
(statearr_136362_136370[(2)] = inst_136353);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136357__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__99975__auto__ = null;
var flureenjs$state_machine__99975__auto____0 = (function (){
var statearr_136363 = [null,null,null,null,null,null,null,null];
(statearr_136363[(0)] = flureenjs$state_machine__99975__auto__);

(statearr_136363[(1)] = (1));

return statearr_136363;
});
var flureenjs$state_machine__99975__auto____1 = (function (state_136357){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_136357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e136364){if((e136364 instanceof Object)){
var ex__99978__auto__ = e136364;
var statearr_136365_136371 = state_136357;
(statearr_136365_136371[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_136357);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e136364;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__136372 = state_136357;
state_136357 = G__136372;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
flureenjs$state_machine__99975__auto__ = function(state_136357){
switch(arguments.length){
case 0:
return flureenjs$state_machine__99975__auto____0.call(this);
case 1:
return flureenjs$state_machine__99975__auto____1.call(this,state_136357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__99975__auto____0;
flureenjs$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__99975__auto____1;
return flureenjs$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_136366 = f__100070__auto__.call(null);
(statearr_136366[(6)] = c__100069__auto__);

return statearr_136366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.http_signature = (function flureenjs$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureenjs.http_signature', flureenjs.http_signature);
