// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30353 = arguments.length;
var i__4737__auto___30354 = (0);
while(true){
if((i__4737__auto___30354 < len__4736__auto___30353)){
args__4742__auto__.push((arguments[i__4737__auto___30354]));

var G__30355 = (i__4737__auto___30354 + (1));
i__4737__auto___30354 = G__30355;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__30252){
var vec__30253 = p__30252;
var opts = cljs.core.nth.call(null,vec__30253,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2476__auto___30356 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30317){
var state_val_30318 = (state_30317[(1)]);
if((state_val_30318 === (7))){
var state_30317__$1 = state_30317;
var statearr_30319_30357 = state_30317__$1;
(statearr_30319_30357[(2)] = false);

(statearr_30319_30357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (1))){
var state_30317__$1 = state_30317;
var statearr_30320_30358 = state_30317__$1;
(statearr_30320_30358[(2)] = null);

(statearr_30320_30358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (4))){
var inst_30256 = (state_30317[(2)]);
var inst_30257 = fluree.db.util.log.error.call(null,inst_30256);
var inst_30258 = cljs.core.async.put_BANG_.call(null,pc,inst_30256);
var inst_30259 = cljs.core.async.close_BANG_.call(null,pc);
var state_30317__$1 = (function (){var statearr_30321 = state_30317;
(statearr_30321[(7)] = inst_30258);

(statearr_30321[(8)] = inst_30257);

return statearr_30321;
})();
var statearr_30322_30359 = state_30317__$1;
(statearr_30322_30359[(2)] = inst_30259);

(statearr_30322_30359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (15))){
var inst_30297 = (state_30317[(9)]);
var inst_30294 = (state_30317[(10)]);
var inst_30298 = (state_30317[(11)]);
var inst_30301 = (state_30317[(2)]);
var inst_30302 = fluree.db.util.async.throw_err.call(null,inst_30301);
var inst_30303 = cljs.core.assoc.call(null,inst_30302,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_30297,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_30298);
var state_30317__$1 = (function (){var statearr_30323 = state_30317;
(statearr_30323[(12)] = inst_30303);

return statearr_30323;
})();
if(cljs.core.truth_(inst_30294)){
var statearr_30324_30360 = state_30317__$1;
(statearr_30324_30360[(1)] = (16));

} else {
var statearr_30325_30361 = state_30317__$1;
(statearr_30325_30361[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (13))){
var inst_30269 = (state_30317[(13)]);
var state_30317__$1 = state_30317;
var statearr_30326_30362 = state_30317__$1;
(statearr_30326_30362[(2)] = inst_30269);

(statearr_30326_30362[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (6))){
var inst_30269 = (state_30317[(13)]);
var inst_30274 = inst_30269.cljs$lang$protocol_mask$partition0$;
var inst_30275 = (inst_30274 & (64));
var inst_30276 = inst_30269.cljs$core$ISeq$;
var inst_30277 = (cljs.core.PROTOCOL_SENTINEL === inst_30276);
var inst_30278 = ((inst_30275) || (inst_30277));
var state_30317__$1 = state_30317;
if(cljs.core.truth_(inst_30278)){
var statearr_30327_30363 = state_30317__$1;
(statearr_30327_30363[(1)] = (9));

} else {
var statearr_30328_30364 = state_30317__$1;
(statearr_30328_30364[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (17))){
var inst_30303 = (state_30317[(12)]);
var state_30317__$1 = state_30317;
var statearr_30329_30365 = state_30317__$1;
(statearr_30329_30365[(2)] = inst_30303);

(statearr_30329_30365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (3))){
var inst_30315 = (state_30317[(2)]);
var state_30317__$1 = state_30317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30317__$1,inst_30315);
} else {
if((state_val_30318 === (12))){
var inst_30269 = (state_30317[(13)]);
var inst_30287 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30269);
var state_30317__$1 = state_30317;
var statearr_30330_30366 = state_30317__$1;
(statearr_30330_30366[(2)] = inst_30287);

(statearr_30330_30366[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (2))){
var inst_30269 = (state_30317[(13)]);
var _ = (function (){var statearr_30331 = state_30317;
(statearr_30331[(4)] = cljs.core.cons.call(null,(5),(state_30317[(4)])));

return statearr_30331;
})();
var inst_30269__$1 = opts;
var inst_30271 = (inst_30269__$1 == null);
var inst_30272 = cljs.core.not.call(null,inst_30271);
var state_30317__$1 = (function (){var statearr_30332 = state_30317;
(statearr_30332[(13)] = inst_30269__$1);

return statearr_30332;
})();
if(inst_30272){
var statearr_30333_30367 = state_30317__$1;
(statearr_30333_30367[(1)] = (6));

} else {
var statearr_30334_30368 = state_30317__$1;
(statearr_30334_30368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (19))){
var inst_30307 = (state_30317[(2)]);
var inst_30308 = fluree.db.util.async.throw_err.call(null,inst_30307);
var state_30317__$1 = state_30317;
var statearr_30335_30369 = state_30317__$1;
(statearr_30335_30369[(2)] = inst_30308);

(statearr_30335_30369[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (11))){
var inst_30282 = (state_30317[(2)]);
var state_30317__$1 = state_30317;
var statearr_30337_30370 = state_30317__$1;
(statearr_30337_30370[(2)] = inst_30282);

(statearr_30337_30370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (9))){
var state_30317__$1 = state_30317;
var statearr_30338_30371 = state_30317__$1;
(statearr_30338_30371[(2)] = true);

(statearr_30338_30371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (5))){
var _ = (function (){var statearr_30339 = state_30317;
(statearr_30339[(4)] = cljs.core.rest.call(null,(state_30317[(4)])));

return statearr_30339;
})();
var state_30317__$1 = state_30317;
var ex30336 = (state_30317__$1[(2)]);
var statearr_30340_30372 = state_30317__$1;
(statearr_30340_30372[(5)] = ex30336);


var statearr_30341_30373 = state_30317__$1;
(statearr_30341_30373[(1)] = (4));

(statearr_30341_30373[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (14))){
var inst_30290 = (state_30317[(2)]);
var inst_30291 = cljs.core.get.call(null,inst_30290,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_30292 = cljs.core.get.call(null,inst_30290,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_30293 = cljs.core.get.call(null,inst_30290,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_30294 = cljs.core.get.call(null,inst_30290,new cljs.core.Keyword(null,"block","block",664686210));
var inst_30295 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_30296 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_30297 = cljs.core.nth.call(null,inst_30296,(0),null);
var inst_30298 = cljs.core.nth.call(null,inst_30296,(1),null);
var inst_30299 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_30317__$1 = (function (){var statearr_30342 = state_30317;
(statearr_30342[(14)] = inst_30293);

(statearr_30342[(9)] = inst_30297);

(statearr_30342[(10)] = inst_30294);

(statearr_30342[(15)] = inst_30292);

(statearr_30342[(16)] = inst_30291);

(statearr_30342[(17)] = inst_30295);

(statearr_30342[(11)] = inst_30298);

return statearr_30342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30317__$1,(15),inst_30299);
} else {
if((state_val_30318 === (16))){
var inst_30294 = (state_30317[(10)]);
var inst_30303 = (state_30317[(12)]);
var inst_30305 = fluree.db.time_travel.as_of_block.call(null,inst_30303,inst_30294);
var state_30317__$1 = state_30317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30317__$1,(19),inst_30305);
} else {
if((state_val_30318 === (10))){
var state_30317__$1 = state_30317;
var statearr_30343_30374 = state_30317__$1;
(statearr_30343_30374[(2)] = false);

(statearr_30343_30374[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (18))){
var inst_30311 = (state_30317[(2)]);
var inst_30312 = cljs.core.async.put_BANG_.call(null,pc,inst_30311);
var _ = (function (){var statearr_30344 = state_30317;
(statearr_30344[(4)] = cljs.core.rest.call(null,(state_30317[(4)])));

return statearr_30344;
})();
var state_30317__$1 = state_30317;
var statearr_30345_30375 = state_30317__$1;
(statearr_30345_30375[(2)] = inst_30312);

(statearr_30345_30375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30318 === (8))){
var inst_30285 = (state_30317[(2)]);
var state_30317__$1 = state_30317;
if(cljs.core.truth_(inst_30285)){
var statearr_30346_30376 = state_30317__$1;
(statearr_30346_30376[(1)] = (12));

} else {
var statearr_30347_30377 = state_30317__$1;
(statearr_30347_30377[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_30348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30348[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_30348[(1)] = (1));

return statearr_30348;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_30317){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30349){var ex__2457__auto__ = e30349;
var statearr_30350_30378 = state_30317;
(statearr_30350_30378[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30317[(4)]))){
var statearr_30351_30379 = state_30317;
(statearr_30351_30379[(1)] = cljs.core.first.call(null,(state_30317[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30380 = state_30317;
state_30317 = G__30380;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_30317){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_30317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30352 = f__2477__auto__.call(null);
(statearr_30352[(6)] = c__2476__auto___30356);

return statearr_30352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq30249){
var G__30250 = cljs.core.first.call(null,seq30249);
var seq30249__$1 = cljs.core.next.call(null,seq30249);
var G__30251 = cljs.core.first.call(null,seq30249__$1);
var seq30249__$2 = cljs.core.next.call(null,seq30249__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30250,G__30251,seq30249__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?open_api:false))){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__30383 = arguments.length;
switch (G__30383) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30533){
var state_val_30534 = (state_30533[(1)]);
if((state_val_30534 === (7))){
var state_30533__$1 = state_30533;
var statearr_30535_30629 = state_30533__$1;
(statearr_30535_30629[(2)] = false);

(statearr_30535_30629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (59))){
var inst_30522 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30536_30630 = state_30533__$1;
(statearr_30536_30630[(2)] = inst_30522);

(statearr_30536_30630[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (20))){
var inst_30438 = (state_30533[(7)]);
var inst_30437 = (state_30533[(8)]);
var inst_30421 = (state_30533[(9)]);
var inst_30440 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_30437);
var inst_30441 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_30438);
var inst_30442 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_30437);
var inst_30443 = fluree.db.api_js.get_sources.call(null,inst_30438,inst_30440,inst_30441,inst_30442,inst_30421,db_fn);
var state_30533__$1 = state_30533;
var statearr_30537_30631 = state_30533__$1;
(statearr_30537_30631[(2)] = inst_30443);

(statearr_30537_30631[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (58))){
var state_30533__$1 = state_30533;
var statearr_30538_30632 = state_30533__$1;
(statearr_30538_30632[(2)] = null);

(statearr_30538_30632[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (27))){
var inst_30423 = (state_30533[(10)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30423)){
var statearr_30539_30633 = state_30533__$1;
(statearr_30539_30633[(1)] = (29));

} else {
var statearr_30540_30634 = state_30533__$1;
(statearr_30540_30634[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (1))){
var state_30533__$1 = state_30533;
var statearr_30541_30635 = state_30533__$1;
(statearr_30541_30635[(2)] = null);

(statearr_30541_30635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (24))){
var state_30533__$1 = state_30533;
var statearr_30542_30636 = state_30533__$1;
(statearr_30542_30636[(2)] = (1000000));

(statearr_30542_30636[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (55))){
var inst_30491 = (state_30533[(11)]);
var state_30533__$1 = state_30533;
var statearr_30543_30637 = state_30533__$1;
(statearr_30543_30637[(2)] = inst_30491);

(statearr_30543_30637[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (39))){
var inst_30472 = (state_30533[(12)]);
var state_30533__$1 = state_30533;
var statearr_30544_30638 = state_30533__$1;
(statearr_30544_30638[(2)] = inst_30472);

(statearr_30544_30638[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (46))){
var inst_30528 = (state_30533[(2)]);
var _ = (function (){var statearr_30545 = state_30533;
(statearr_30545[(4)] = cljs.core.rest.call(null,(state_30533[(4)])));

return statearr_30545;
})();
var state_30533__$1 = state_30533;
var statearr_30546_30639 = state_30533__$1;
(statearr_30546_30639[(2)] = inst_30528);

(statearr_30546_30639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (4))){
var inst_30384 = (state_30533[(2)]);
var inst_30385 = fluree.db.util.log.error.call(null,inst_30384);
var inst_30386 = cljs.core.ex_data.call(null,inst_30384);
var inst_30387 = cljs.core.ex_message.call(null,inst_30384);
var inst_30388 = cljs.core.assoc.call(null,inst_30386,new cljs.core.Keyword(null,"message","message",-406056002),inst_30387);
var state_30533__$1 = (function (){var statearr_30547 = state_30533;
(statearr_30547[(13)] = inst_30385);

return statearr_30547;
})();
var statearr_30548_30640 = state_30533__$1;
(statearr_30548_30640[(2)] = inst_30388);

(statearr_30548_30640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (54))){
var inst_30491 = (state_30533[(11)]);
var inst_30505 = cljs.core.doall.call(null,inst_30491);
var state_30533__$1 = state_30533;
var statearr_30549_30641 = state_30533__$1;
(statearr_30549_30641[(2)] = inst_30505);

(statearr_30549_30641[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (15))){
var inst_30419 = (state_30533[(14)]);
var inst_30428 = (state_30533[(2)]);
var inst_30429 = fluree.db.util.async.throw_err.call(null,inst_30428);
var state_30533__$1 = (function (){var statearr_30550 = state_30533;
(statearr_30550[(15)] = inst_30429);

return statearr_30550;
})();
if(cljs.core.truth_(inst_30419)){
var statearr_30551_30642 = state_30533__$1;
(statearr_30551_30642[(1)] = (16));

} else {
var statearr_30552_30643 = state_30533__$1;
(statearr_30552_30643[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (48))){
var inst_30491 = (state_30533[(11)]);
var inst_30494 = cljs.core.ex_data.call(null,inst_30491);
var inst_30495 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30496 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_30494);
var inst_30497 = cljs.core.ex_message.call(null,inst_30491);
var inst_30498 = [inst_30496,inst_30497,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30499 = cljs.core.PersistentHashMap.fromArrays(inst_30495,inst_30498);
var state_30533__$1 = state_30533;
var statearr_30553_30644 = state_30533__$1;
(statearr_30553_30644[(2)] = inst_30499);

(statearr_30553_30644[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (50))){
var inst_30526 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30554_30645 = state_30533__$1;
(statearr_30554_30645[(2)] = inst_30526);

(statearr_30554_30645[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (21))){
var inst_30445 = cljs.core.PersistentHashMap.EMPTY;
var state_30533__$1 = state_30533;
var statearr_30555_30646 = state_30533__$1;
(statearr_30555_30646[(2)] = inst_30445);

(statearr_30555_30646[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (31))){
var inst_30470 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30556_30647 = state_30533__$1;
(statearr_30556_30647[(2)] = inst_30470);

(statearr_30556_30647[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (32))){
var inst_30422 = (state_30533[(16)]);
var state_30533__$1 = state_30533;
var statearr_30557_30648 = state_30533__$1;
(statearr_30557_30648[(2)] = inst_30422);

(statearr_30557_30648[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (40))){
var inst_30480 = (state_30533[(17)]);
var inst_30480__$1 = (state_30533[(2)]);
var inst_30481 = cljs.core.not.call(null,inst_30480__$1);
var state_30533__$1 = (function (){var statearr_30558 = state_30533;
(statearr_30558[(17)] = inst_30480__$1);

return statearr_30558;
})();
if(inst_30481){
var statearr_30559_30649 = state_30533__$1;
(statearr_30559_30649[(1)] = (44));

} else {
var statearr_30560_30650 = state_30533__$1;
(statearr_30560_30650[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (56))){
var inst_30416 = (state_30533[(18)]);
var inst_30420 = (state_30533[(19)]);
var inst_30447 = (state_30533[(20)]);
var inst_30480 = (state_30533[(17)]);
var inst_30418 = (state_30533[(21)]);
var inst_30423 = (state_30533[(10)]);
var inst_30426 = (state_30533[(22)]);
var inst_30424 = (state_30533[(23)]);
var inst_30491 = (state_30533[(11)]);
var inst_30492 = (state_30533[(24)]);
var inst_30453 = (state_30533[(25)]);
var inst_30455 = (state_30533[(26)]);
var inst_30502 = (state_30533[(27)]);
var inst_30454 = (state_30533[(28)]);
var inst_30448 = (state_30533[(29)]);
var inst_30419 = (state_30533[(14)]);
var inst_30438 = (state_30533[(7)]);
var inst_30422 = (state_30533[(16)]);
var inst_30429 = (state_30533[(15)]);
var inst_30437 = (state_30533[(8)]);
var inst_30456 = (state_30533[(30)]);
var inst_30421 = (state_30533[(9)]);
var inst_30417 = (state_30533[(31)]);
var inst_30508 = (state_30533[(2)]);
var inst_30509 = cljs.core.deref.call(null,inst_30448);
var inst_30510 = (function (){var error_QMARK_ = inst_30492;
var construct = inst_30417;
var map__30394 = inst_30416;
var valid_query_QMARK_ = inst_30480;
var conn = inst_30438;
var select = inst_30418;
var block = inst_30419;
var where = inst_30420;
var prefixes = inst_30421;
var db = inst_30429;
var meta_QMARK_ = inst_30454;
var source_opts = inst_30447;
var fuel = inst_30448;
var db_STAR_ = inst_30437;
var selectDistinct = inst_30422;
var result = inst_30491;
var start_ms = inst_30455;
var selectOne = inst_30423;
var from = inst_30424;
var max_fuel = inst_30453;
var opts = inst_30456;
var selectReduced = inst_30426;
return (function (p1__30381_SHARP_){
return goog.string.format("%.2fms",p1__30381_SHARP_);
});
})();
var inst_30511 = fluree.db.util.core.current_time_millis.call(null);
var inst_30512 = (inst_30511 - inst_30455);
var inst_30513 = (inst_30512 / (1000000));
var inst_30514 = inst_30510.call(null,inst_30513);
var inst_30515 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_30437);
var inst_30516 = [(200),inst_30508,inst_30509,inst_30514,inst_30515];
var inst_30517 = cljs.core.PersistentHashMap.fromArrays(inst_30502,inst_30516);
var state_30533__$1 = state_30533;
var statearr_30561_30651 = state_30533__$1;
(statearr_30561_30651[(2)] = inst_30517);

(statearr_30561_30651[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (33))){
var inst_30426 = (state_30533[(22)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30426)){
var statearr_30562_30652 = state_30533__$1;
(statearr_30562_30652[(1)] = (35));

} else {
var statearr_30563_30653 = state_30533__$1;
(statearr_30563_30653[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (13))){
var inst_30395 = (state_30533[(32)]);
var state_30533__$1 = state_30533;
var statearr_30564_30654 = state_30533__$1;
(statearr_30564_30654[(2)] = inst_30395);

(statearr_30564_30654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (22))){
var inst_30449 = (state_30533[(33)]);
var inst_30425 = (state_30533[(34)]);
var inst_30447 = (state_30533[(2)]);
var inst_30448 = cljs.core.volatile_BANG_.call(null,(0));
var inst_30449__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_30425);
var state_30533__$1 = (function (){var statearr_30565 = state_30533;
(statearr_30565[(20)] = inst_30447);

(statearr_30565[(33)] = inst_30449__$1);

(statearr_30565[(29)] = inst_30448);

return statearr_30565;
})();
if(cljs.core.truth_(inst_30449__$1)){
var statearr_30566_30655 = state_30533__$1;
(statearr_30566_30655[(1)] = (23));

} else {
var statearr_30567_30656 = state_30533__$1;
(statearr_30567_30656[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (36))){
var inst_30417 = (state_30533[(31)]);
var state_30533__$1 = state_30533;
var statearr_30568_30657 = state_30533__$1;
(statearr_30568_30657[(2)] = inst_30417);

(statearr_30568_30657[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (41))){
var inst_30424 = (state_30533[(23)]);
var state_30533__$1 = state_30533;
var statearr_30569_30658 = state_30533__$1;
(statearr_30569_30658[(2)] = inst_30424);

(statearr_30569_30658[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (43))){
var inst_30477 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30570_30659 = state_30533__$1;
(statearr_30570_30659[(2)] = inst_30477);

(statearr_30570_30659[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (29))){
var inst_30423 = (state_30533[(10)]);
var state_30533__$1 = state_30533;
var statearr_30571_30660 = state_30533__$1;
(statearr_30571_30660[(2)] = inst_30423);

(statearr_30571_30660[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (44))){
var inst_30483 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30484 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_30485 = cljs.core.PersistentHashMap.fromArrays(inst_30483,inst_30484);
var state_30533__$1 = state_30533;
var statearr_30572_30661 = state_30533__$1;
(statearr_30572_30661[(2)] = inst_30485);

(statearr_30572_30661[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (6))){
var inst_30395 = (state_30533[(32)]);
var inst_30400 = inst_30395.cljs$lang$protocol_mask$partition0$;
var inst_30401 = (inst_30400 & (64));
var inst_30402 = inst_30395.cljs$core$ISeq$;
var inst_30403 = (cljs.core.PROTOCOL_SENTINEL === inst_30402);
var inst_30404 = ((inst_30401) || (inst_30403));
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30404)){
var statearr_30573_30662 = state_30533__$1;
(statearr_30573_30662[(1)] = (9));

} else {
var statearr_30574_30663 = state_30533__$1;
(statearr_30574_30663[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (28))){
var inst_30472 = (state_30533[(12)]);
var inst_30472__$1 = (state_30533[(2)]);
var state_30533__$1 = (function (){var statearr_30575 = state_30533;
(statearr_30575[(12)] = inst_30472__$1);

return statearr_30575;
})();
if(cljs.core.truth_(inst_30472__$1)){
var statearr_30576_30664 = state_30533__$1;
(statearr_30576_30664[(1)] = (38));

} else {
var statearr_30577_30665 = state_30533__$1;
(statearr_30577_30665[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (51))){
var inst_30491 = (state_30533[(11)]);
var inst_30502 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_30503 = cljs.core.sequential_QMARK_.call(null,inst_30491);
var state_30533__$1 = (function (){var statearr_30578 = state_30533;
(statearr_30578[(27)] = inst_30502);

return statearr_30578;
})();
if(inst_30503){
var statearr_30579_30666 = state_30533__$1;
(statearr_30579_30666[(1)] = (54));

} else {
var statearr_30580_30667 = state_30533__$1;
(statearr_30580_30667[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (25))){
var inst_30447 = (state_30533[(20)]);
var inst_30418 = (state_30533[(21)]);
var inst_30453 = (state_30533[(25)]);
var inst_30448 = (state_30533[(29)]);
var inst_30425 = (state_30533[(34)]);
var inst_30453__$1 = (state_30533[(2)]);
var inst_30454 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_30425);
var inst_30455 = fluree.db.util.core.current_time_millis.call(null);
var inst_30456 = cljs.core.assoc.call(null,inst_30425,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_30447,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_30453__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_30448);
var state_30533__$1 = (function (){var statearr_30581 = state_30533;
(statearr_30581[(25)] = inst_30453__$1);

(statearr_30581[(26)] = inst_30455);

(statearr_30581[(28)] = inst_30454);

(statearr_30581[(30)] = inst_30456);

return statearr_30581;
})();
if(cljs.core.truth_(inst_30418)){
var statearr_30582_30668 = state_30533__$1;
(statearr_30582_30668[(1)] = (26));

} else {
var statearr_30583_30669 = state_30533__$1;
(statearr_30583_30669[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (34))){
var inst_30468 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30584_30670 = state_30533__$1;
(statearr_30584_30670[(2)] = inst_30468);

(statearr_30584_30670[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (17))){
var inst_30429 = (state_30533[(15)]);
var state_30533__$1 = state_30533;
var statearr_30585_30671 = state_30533__$1;
(statearr_30585_30671[(2)] = inst_30429);

(statearr_30585_30671[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (3))){
var inst_30531 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30533__$1,inst_30531);
} else {
if((state_val_30534 === (12))){
var inst_30395 = (state_30533[(32)]);
var inst_30413 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30395);
var state_30533__$1 = state_30533;
var statearr_30586_30672 = state_30533__$1;
(statearr_30586_30672[(2)] = inst_30413);

(statearr_30586_30672[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (2))){
var inst_30395 = (state_30533[(32)]);
var _ = (function (){var statearr_30587 = state_30533;
(statearr_30587[(4)] = cljs.core.cons.call(null,(5),(state_30533[(4)])));

return statearr_30587;
})();
var inst_30395__$1 = query_map;
var inst_30397 = (inst_30395__$1 == null);
var inst_30398 = cljs.core.not.call(null,inst_30397);
var state_30533__$1 = (function (){var statearr_30588 = state_30533;
(statearr_30588[(32)] = inst_30395__$1);

return statearr_30588;
})();
if(inst_30398){
var statearr_30589_30673 = state_30533__$1;
(statearr_30589_30673[(1)] = (6));

} else {
var statearr_30590_30674 = state_30533__$1;
(statearr_30590_30674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (23))){
var inst_30449 = (state_30533[(33)]);
var state_30533__$1 = state_30533;
var statearr_30591_30675 = state_30533__$1;
(statearr_30591_30675[(2)] = inst_30449);

(statearr_30591_30675[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (47))){
var inst_30491 = (state_30533[(11)]);
var inst_30492 = (state_30533[(24)]);
var inst_30490 = (state_30533[(2)]);
var inst_30491__$1 = fluree.db.util.async.throw_err.call(null,inst_30490);
var inst_30492__$1 = (inst_30491__$1 instanceof cljs.core.ExceptionInfo);
var state_30533__$1 = (function (){var statearr_30592 = state_30533;
(statearr_30592[(11)] = inst_30491__$1);

(statearr_30592[(24)] = inst_30492__$1);

return statearr_30592;
})();
if(cljs.core.truth_(inst_30492__$1)){
var statearr_30593_30676 = state_30533__$1;
(statearr_30593_30676[(1)] = (48));

} else {
var statearr_30594_30677 = state_30533__$1;
(statearr_30594_30677[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (35))){
var inst_30426 = (state_30533[(22)]);
var state_30533__$1 = state_30533;
var statearr_30595_30678 = state_30533__$1;
(statearr_30595_30678[(2)] = inst_30426);

(statearr_30595_30678[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (19))){
var inst_30433 = (state_30533[(2)]);
var inst_30434 = fluree.db.util.async.throw_err.call(null,inst_30433);
var state_30533__$1 = state_30533;
var statearr_30596_30679 = state_30533__$1;
(statearr_30596_30679[(2)] = inst_30434);

(statearr_30596_30679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (57))){
var inst_30491 = (state_30533[(11)]);
var state_30533__$1 = state_30533;
var statearr_30597_30680 = state_30533__$1;
(statearr_30597_30680[(2)] = inst_30491);

(statearr_30597_30680[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (11))){
var inst_30408 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30599_30681 = state_30533__$1;
(statearr_30599_30681[(2)] = inst_30408);

(statearr_30599_30681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (9))){
var state_30533__$1 = state_30533;
var statearr_30600_30682 = state_30533__$1;
(statearr_30600_30682[(2)] = true);

(statearr_30600_30682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (5))){
var _ = (function (){var statearr_30601 = state_30533;
(statearr_30601[(4)] = cljs.core.rest.call(null,(state_30533[(4)])));

return statearr_30601;
})();
var state_30533__$1 = state_30533;
var ex30598 = (state_30533__$1[(2)]);
var statearr_30602_30683 = state_30533__$1;
(statearr_30602_30683[(5)] = ex30598);


var statearr_30603_30684 = state_30533__$1;
(statearr_30603_30684[(1)] = (4));

(statearr_30603_30684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (14))){
var inst_30416 = (state_30533[(18)]);
var inst_30416__$1 = (state_30533[(2)]);
var inst_30417 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_30418 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_30419 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_30420 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_30421 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_30422 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_30423 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_30424 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_30425 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_30426 = cljs.core.get.call(null,inst_30416__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_30533__$1 = (function (){var statearr_30604 = state_30533;
(statearr_30604[(18)] = inst_30416__$1);

(statearr_30604[(19)] = inst_30420);

(statearr_30604[(21)] = inst_30418);

(statearr_30604[(10)] = inst_30423);

(statearr_30604[(22)] = inst_30426);

(statearr_30604[(23)] = inst_30424);

(statearr_30604[(14)] = inst_30419);

(statearr_30604[(16)] = inst_30422);

(statearr_30604[(9)] = inst_30421);

(statearr_30604[(31)] = inst_30417);

(statearr_30604[(34)] = inst_30425);

return statearr_30604;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30533__$1,(15),sources);
} else {
if((state_val_30534 === (45))){
var inst_30437 = (state_30533[(8)]);
var inst_30456 = (state_30533[(30)]);
var inst_30487 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_30456);
var inst_30488 = fluree.db.query.fql.query.call(null,inst_30437,inst_30487);
var state_30533__$1 = state_30533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30533__$1,(47),inst_30488);
} else {
if((state_val_30534 === (53))){
var inst_30524 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30605_30685 = state_30533__$1;
(statearr_30605_30685[(2)] = inst_30524);

(statearr_30605_30685[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (26))){
var inst_30418 = (state_30533[(21)]);
var state_30533__$1 = state_30533;
var statearr_30606_30686 = state_30533__$1;
(statearr_30606_30686[(2)] = inst_30418);

(statearr_30606_30686[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (16))){
var inst_30419 = (state_30533[(14)]);
var inst_30429 = (state_30533[(15)]);
var inst_30431 = fluree.db.time_travel.as_of_block.call(null,inst_30429,inst_30419);
var state_30533__$1 = state_30533;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30533__$1,(19),inst_30431);
} else {
if((state_val_30534 === (38))){
var inst_30424 = (state_30533[(23)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30424)){
var statearr_30607_30687 = state_30533__$1;
(statearr_30607_30687[(1)] = (41));

} else {
var statearr_30608_30688 = state_30533__$1;
(statearr_30608_30688[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (30))){
var inst_30422 = (state_30533[(16)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30422)){
var statearr_30609_30689 = state_30533__$1;
(statearr_30609_30689[(1)] = (32));

} else {
var statearr_30610_30690 = state_30533__$1;
(statearr_30610_30690[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (10))){
var state_30533__$1 = state_30533;
var statearr_30611_30691 = state_30533__$1;
(statearr_30611_30691[(2)] = false);

(statearr_30611_30691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (18))){
var inst_30437 = (state_30533[(8)]);
var inst_30421 = (state_30533[(9)]);
var inst_30437__$1 = (state_30533[(2)]);
var inst_30438 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_30437__$1);
var state_30533__$1 = (function (){var statearr_30612 = state_30533;
(statearr_30612[(7)] = inst_30438);

(statearr_30612[(8)] = inst_30437__$1);

return statearr_30612;
})();
if(cljs.core.truth_(inst_30421)){
var statearr_30613_30692 = state_30533__$1;
(statearr_30613_30692[(1)] = (20));

} else {
var statearr_30614_30693 = state_30533__$1;
(statearr_30614_30693[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (52))){
var state_30533__$1 = state_30533;
var statearr_30615_30694 = state_30533__$1;
(statearr_30615_30694[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (42))){
var inst_30420 = (state_30533[(19)]);
var state_30533__$1 = state_30533;
var statearr_30617_30695 = state_30533__$1;
(statearr_30617_30695[(2)] = inst_30420);

(statearr_30617_30695[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (37))){
var inst_30466 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
var statearr_30618_30696 = state_30533__$1;
(statearr_30618_30696[(2)] = inst_30466);

(statearr_30618_30696[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (8))){
var inst_30411 = (state_30533[(2)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30411)){
var statearr_30619_30697 = state_30533__$1;
(statearr_30619_30697[(1)] = (12));

} else {
var statearr_30620_30698 = state_30533__$1;
(statearr_30620_30698[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30534 === (49))){
var inst_30454 = (state_30533[(28)]);
var state_30533__$1 = state_30533;
if(cljs.core.truth_(inst_30454)){
var statearr_30621_30699 = state_30533__$1;
(statearr_30621_30699[(1)] = (51));

} else {
var statearr_30622_30700 = state_30533__$1;
(statearr_30622_30700[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_30623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30623[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_30623[(1)] = (1));

return statearr_30623;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_30533){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30624){var ex__2457__auto__ = e30624;
var statearr_30625_30701 = state_30533;
(statearr_30625_30701[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30533[(4)]))){
var statearr_30626_30702 = state_30533;
(statearr_30626_30702[(1)] = cljs.core.first.call(null,(state_30533[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30703 = state_30533;
state_30533 = G__30703;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_30533){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_30533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30627 = f__2477__auto__.call(null);
(statearr_30627[(6)] = c__2476__auto__);

return statearr_30627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__30704_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__30704_SHARP_);
}));

var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30726){
var state_val_30727 = (state_30726[(1)]);
if((state_val_30727 === (1))){
var inst_30708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30709 = [resp_chan,timeout_chan];
var inst_30710 = (new cljs.core.PersistentVector(null,2,(5),inst_30708,inst_30709,null));
var state_30726__$1 = state_30726;
return cljs.core.async.ioc_alts_BANG_.call(null,state_30726__$1,(2),inst_30710);
} else {
if((state_val_30727 === (2))){
var inst_30712 = (state_30726[(2)]);
var inst_30713 = cljs.core.nth.call(null,inst_30712,(0),null);
var inst_30714 = cljs.core.nth.call(null,inst_30712,(1),null);
var inst_30715 = cljs.core._EQ_.call(null,timeout_chan,inst_30714);
var state_30726__$1 = (function (){var statearr_30728 = state_30726;
(statearr_30728[(7)] = inst_30713);

return statearr_30728;
})();
if(inst_30715){
var statearr_30729_30739 = state_30726__$1;
(statearr_30729_30739[(1)] = (3));

} else {
var statearr_30730_30740 = state_30726__$1;
(statearr_30730_30740[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30727 === (3))){
var inst_30717 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_30718 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_30719 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_30720 = [tid,(408),inst_30719];
var inst_30721 = cljs.core.PersistentHashMap.fromArrays(inst_30718,inst_30720);
var state_30726__$1 = (function (){var statearr_30731 = state_30726;
(statearr_30731[(8)] = inst_30717);

return statearr_30731;
})();
var statearr_30732_30741 = state_30726__$1;
(statearr_30732_30741[(2)] = inst_30721);

(statearr_30732_30741[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30727 === (4))){
var inst_30713 = (state_30726[(7)]);
var state_30726__$1 = state_30726;
var statearr_30733_30742 = state_30726__$1;
(statearr_30733_30742[(2)] = inst_30713);

(statearr_30733_30742[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30727 === (5))){
var inst_30724 = (state_30726[(2)]);
var state_30726__$1 = state_30726;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30726__$1,inst_30724);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____0 = (function (){
var statearr_30734 = [null,null,null,null,null,null,null,null,null];
(statearr_30734[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__);

(statearr_30734[(1)] = (1));

return statearr_30734;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____1 = (function (state_30726){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30726);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30735){var ex__2457__auto__ = e30735;
var statearr_30736_30743 = state_30726;
(statearr_30736_30743[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30726[(4)]))){
var statearr_30737_30744 = state_30726;
(statearr_30737_30744[(1)] = cljs.core.first.call(null,(state_30726[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30745 = state_30726;
state_30726 = G__30745;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__ = function(state_30726){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____1.call(this,state_30726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2454__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30738 = f__2477__auto__.call(null);
(statearr_30738[(6)] = c__2476__auto__);

return statearr_30738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__30747 = arguments.length;
switch (G__30747) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__30748 = opts;
var map__30748__$1 = (((((!((map__30748 == null))))?(((((map__30748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30748):map__30748);
var auth = cljs.core.get.call(null,map__30748__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__30748__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__30748__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__30748__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__30749 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__30749,(0),null);
var authority = cljs.core.nth.call(null,vec__30749,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e30753){var e = e30753;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__30756 = arguments.length;
switch (G__30756) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30842){
var state_val_30843 = (state_30842[(1)]);
if((state_val_30843 === (7))){
var state_30842__$1 = state_30842;
var statearr_30844_30893 = state_30842__$1;
(statearr_30844_30893[(2)] = false);

(statearr_30844_30893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (20))){
var inst_30809 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30845_30894 = state_30842__$1;
(statearr_30845_30894[(2)] = inst_30809);

(statearr_30845_30894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (27))){
var inst_30822 = (state_30842[(7)]);
var inst_30825 = cljs.core.ex_data.call(null,inst_30822);
var inst_30826 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30827 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_30825);
var inst_30828 = cljs.core.ex_message.call(null,inst_30822);
var inst_30829 = [inst_30827,inst_30828,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_30830 = cljs.core.PersistentHashMap.fromArrays(inst_30826,inst_30829);
var state_30842__$1 = state_30842;
var statearr_30846_30895 = state_30842__$1;
(statearr_30846_30895[(2)] = inst_30830);

(statearr_30846_30895[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (1))){
var state_30842__$1 = state_30842;
var statearr_30847_30896 = state_30842__$1;
(statearr_30847_30896[(2)] = null);

(statearr_30847_30896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (24))){
var inst_30817 = (state_30842[(8)]);
var inst_30792 = (state_30842[(9)]);
var inst_30820 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_30817,inst_30792);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30842__$1,(26),inst_30820);
} else {
if((state_val_30843 === (4))){
var inst_30757 = (state_30842[(2)]);
var inst_30758 = fluree.db.util.log.error.call(null,inst_30757);
var inst_30759 = cljs.core.ex_data.call(null,inst_30757);
var inst_30760 = cljs.core.ex_message.call(null,inst_30757);
var inst_30761 = cljs.core.assoc.call(null,inst_30759,new cljs.core.Keyword(null,"message","message",-406056002),inst_30760);
var state_30842__$1 = (function (){var statearr_30848 = state_30842;
(statearr_30848[(10)] = inst_30758);

return statearr_30848;
})();
var statearr_30849_30897 = state_30842__$1;
(statearr_30849_30897[(2)] = inst_30761);

(statearr_30849_30897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (15))){
var inst_30790 = (state_30842[(11)]);
var inst_30791 = (state_30842[(12)]);
var inst_30800 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_30790,opts);
var inst_30801 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_30800);
var inst_30802 = fluree.db.operations.command_async.call(null,conn,inst_30800);
var state_30842__$1 = (function (){var statearr_30850 = state_30842;
(statearr_30850[(13)] = inst_30802);

(statearr_30850[(14)] = inst_30801);

return statearr_30850;
})();
if(cljs.core.truth_(inst_30791)){
var statearr_30851_30898 = state_30842__$1;
(statearr_30851_30898[(1)] = (18));

} else {
var statearr_30852_30899 = state_30842__$1;
(statearr_30852_30899[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (21))){
var inst_30807 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30853_30900 = state_30842__$1;
(statearr_30853_30900[(2)] = inst_30807);

(statearr_30853_30900[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (13))){
var inst_30768 = (state_30842[(15)]);
var state_30842__$1 = state_30842;
var statearr_30854_30901 = state_30842__$1;
(statearr_30854_30901[(2)] = inst_30768);

(statearr_30854_30901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (22))){
var inst_30791 = (state_30842[(12)]);
var inst_30817 = (state_30842[(2)]);
var state_30842__$1 = (function (){var statearr_30855 = state_30842;
(statearr_30855[(8)] = inst_30817);

return statearr_30855;
})();
if(cljs.core.truth_(inst_30791)){
var statearr_30856_30902 = state_30842__$1;
(statearr_30856_30902[(1)] = (23));

} else {
var statearr_30857_30903 = state_30842__$1;
(statearr_30857_30903[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (29))){
var inst_30833 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30858_30904 = state_30842__$1;
(statearr_30858_30904[(2)] = inst_30833);

(statearr_30858_30904[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (6))){
var inst_30768 = (state_30842[(15)]);
var inst_30773 = inst_30768.cljs$lang$protocol_mask$partition0$;
var inst_30774 = (inst_30773 & (64));
var inst_30775 = inst_30768.cljs$core$ISeq$;
var inst_30776 = (cljs.core.PROTOCOL_SENTINEL === inst_30775);
var inst_30777 = ((inst_30774) || (inst_30776));
var state_30842__$1 = state_30842;
if(cljs.core.truth_(inst_30777)){
var statearr_30859_30905 = state_30842__$1;
(statearr_30859_30905[(1)] = (9));

} else {
var statearr_30860_30906 = state_30842__$1;
(statearr_30860_30906[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (28))){
var inst_30822 = (state_30842[(7)]);
var state_30842__$1 = state_30842;
var statearr_30861_30907 = state_30842__$1;
(statearr_30861_30907[(2)] = inst_30822);

(statearr_30861_30907[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (25))){
var inst_30835 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30862_30908 = state_30842__$1;
(statearr_30862_30908[(2)] = inst_30835);

(statearr_30862_30908[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (17))){
var inst_30837 = (state_30842[(2)]);
var _ = (function (){var statearr_30863 = state_30842;
(statearr_30863[(4)] = cljs.core.rest.call(null,(state_30842[(4)])));

return statearr_30863;
})();
var state_30842__$1 = state_30842;
var statearr_30864_30909 = state_30842__$1;
(statearr_30864_30909[(2)] = inst_30837);

(statearr_30864_30909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (3))){
var inst_30840 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30842__$1,inst_30840);
} else {
if((state_val_30843 === (12))){
var inst_30768 = (state_30842[(15)]);
var inst_30786 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30768);
var state_30842__$1 = state_30842;
var statearr_30865_30910 = state_30842__$1;
(statearr_30865_30910[(2)] = inst_30786);

(statearr_30865_30910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (2))){
var inst_30768 = (state_30842[(15)]);
var _ = (function (){var statearr_30866 = state_30842;
(statearr_30866[(4)] = cljs.core.cons.call(null,(5),(state_30842[(4)])));

return statearr_30866;
})();
var inst_30768__$1 = opts;
var inst_30770 = (inst_30768__$1 == null);
var inst_30771 = cljs.core.not.call(null,inst_30770);
var state_30842__$1 = (function (){var statearr_30867 = state_30842;
(statearr_30867[(15)] = inst_30768__$1);

return statearr_30867;
})();
if(inst_30771){
var statearr_30868_30911 = state_30842__$1;
(statearr_30868_30911[(1)] = (6));

} else {
var statearr_30869_30912 = state_30842__$1;
(statearr_30869_30912[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (23))){
var inst_30817 = (state_30842[(8)]);
var state_30842__$1 = state_30842;
var statearr_30870_30913 = state_30842__$1;
(statearr_30870_30913[(2)] = inst_30817);

(statearr_30870_30913[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (19))){
var inst_30792 = (state_30842[(9)]);
var inst_30801 = (state_30842[(14)]);
var inst_30805 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_30801,inst_30792);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30842__$1,(21),inst_30805);
} else {
if((state_val_30843 === (11))){
var inst_30781 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
var statearr_30872_30914 = state_30842__$1;
(statearr_30872_30914[(2)] = inst_30781);

(statearr_30872_30914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (9))){
var state_30842__$1 = state_30842;
var statearr_30873_30915 = state_30842__$1;
(statearr_30873_30915[(2)] = true);

(statearr_30873_30915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (5))){
var _ = (function (){var statearr_30874 = state_30842;
(statearr_30874[(4)] = cljs.core.rest.call(null,(state_30842[(4)])));

return statearr_30874;
})();
var state_30842__$1 = state_30842;
var ex30871 = (state_30842__$1[(2)]);
var statearr_30875_30916 = state_30842__$1;
(statearr_30875_30916[(5)] = ex30871);


var statearr_30876_30917 = state_30842__$1;
(statearr_30876_30917[(1)] = (4));

(statearr_30876_30917[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (14))){
var inst_30790 = (state_30842[(11)]);
var inst_30789 = (state_30842[(2)]);
var inst_30790__$1 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_30791 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_30792 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_30793 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_30794 = fluree.db.util.core.current_time_millis.call(null);
var inst_30795 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_30794);
var inst_30796 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_30797 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_30798 = cljs.core.get.call(null,inst_30789,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_30842__$1 = (function (){var statearr_30877 = state_30842;
(statearr_30877[(16)] = inst_30797);

(statearr_30877[(11)] = inst_30790__$1);

(statearr_30877[(17)] = inst_30795);

(statearr_30877[(18)] = inst_30796);

(statearr_30877[(12)] = inst_30791);

(statearr_30877[(9)] = inst_30792);

(statearr_30877[(19)] = inst_30798);

(statearr_30877[(20)] = inst_30793);

return statearr_30877;
})();
if(cljs.core.truth_(inst_30790__$1)){
var statearr_30878_30918 = state_30842__$1;
(statearr_30878_30918[(1)] = (15));

} else {
var statearr_30879_30919 = state_30842__$1;
(statearr_30879_30919[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (26))){
var inst_30822 = (state_30842[(7)]);
var inst_30822__$1 = (state_30842[(2)]);
var inst_30823 = (inst_30822__$1 instanceof cljs.core.ExceptionInfo);
var state_30842__$1 = (function (){var statearr_30880 = state_30842;
(statearr_30880[(7)] = inst_30822__$1);

return statearr_30880;
})();
if(cljs.core.truth_(inst_30823)){
var statearr_30881_30920 = state_30842__$1;
(statearr_30881_30920[(1)] = (27));

} else {
var statearr_30882_30921 = state_30842__$1;
(statearr_30882_30921[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (16))){
var inst_30797 = (state_30842[(16)]);
var inst_30795 = (state_30842[(17)]);
var inst_30796 = (state_30842[(18)]);
var inst_30798 = (state_30842[(19)]);
var inst_30793 = (state_30842[(20)]);
var inst_30811 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_30812 = [ledger,txn,inst_30793,inst_30795,inst_30796,inst_30797,inst_30798];
var inst_30813 = cljs.core.PersistentHashMap.fromArrays(inst_30811,inst_30812);
var inst_30814 = fluree.db.util.core.without_nils.call(null,inst_30813);
var inst_30815 = fluree.db.operations.transact_async.call(null,conn,inst_30814);
var state_30842__$1 = state_30842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30842__$1,(22),inst_30815);
} else {
if((state_val_30843 === (10))){
var state_30842__$1 = state_30842;
var statearr_30883_30922 = state_30842__$1;
(statearr_30883_30922[(2)] = false);

(statearr_30883_30922[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (18))){
var inst_30802 = (state_30842[(13)]);
var state_30842__$1 = state_30842;
var statearr_30884_30923 = state_30842__$1;
(statearr_30884_30923[(2)] = inst_30802);

(statearr_30884_30923[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30843 === (8))){
var inst_30784 = (state_30842[(2)]);
var state_30842__$1 = state_30842;
if(cljs.core.truth_(inst_30784)){
var statearr_30885_30924 = state_30842__$1;
(statearr_30885_30924[(1)] = (12));

} else {
var statearr_30886_30925 = state_30842__$1;
(statearr_30886_30925[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_30887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30887[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_30887[(1)] = (1));

return statearr_30887;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_30842){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30888){var ex__2457__auto__ = e30888;
var statearr_30889_30926 = state_30842;
(statearr_30889_30926[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30842[(4)]))){
var statearr_30890_30927 = state_30842;
(statearr_30890_30927[(1)] = cljs.core.first.call(null,(state_30842[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30928 = state_30842;
state_30842 = G__30928;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_30842){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_30842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30891 = f__2477__auto__.call(null);
(statearr_30891[(6)] = c__2476__auto__);

return statearr_30891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30930 = arguments.length;
var i__4737__auto___30931 = (0);
while(true){
if((i__4737__auto___30931 < len__4736__auto___30930)){
args__4742__auto__.push((arguments[i__4737__auto___30931]));

var G__30932 = (i__4737__auto___30931 + (1));
i__4737__auto___30931 = G__30932;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq30929){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq30929));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30963){
var state_val_30964 = (state_30963[(1)]);
if((state_val_30964 === (1))){
var inst_30933 = cljs.core.first.call(null,flakes);
var inst_30934 = cljs.core.rest.call(null,flakes);
var inst_30935 = cljs.core.PersistentVector.EMPTY;
var inst_30936 = inst_30933;
var inst_30937 = inst_30934;
var inst_30938 = inst_30935;
var state_30963__$1 = (function (){var statearr_30965 = state_30963;
(statearr_30965[(7)] = inst_30938);

(statearr_30965[(8)] = inst_30936);

(statearr_30965[(9)] = inst_30937);

return statearr_30965;
})();
var statearr_30966_30979 = state_30963__$1;
(statearr_30966_30979[(2)] = null);

(statearr_30966_30979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30964 === (2))){
var inst_30936 = (state_30963[(8)]);
var inst_30940 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_30941 = cljs.core.PersistentHashMap.EMPTY;
var inst_30942 = [true,inst_30941];
var inst_30943 = cljs.core.PersistentHashMap.fromArrays(inst_30940,inst_30942);
var inst_30944 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_30943,inst_30936);
var state_30963__$1 = state_30963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30963__$1,(4),inst_30944);
} else {
if((state_val_30964 === (3))){
var inst_30961 = (state_30963[(2)]);
var state_30963__$1 = state_30963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30963__$1,inst_30961);
} else {
if((state_val_30964 === (4))){
var inst_30938 = (state_30963[(7)]);
var inst_30937 = (state_30963[(9)]);
var inst_30946 = (state_30963[(2)]);
var inst_30947 = fluree.db.util.async.throw_err.call(null,inst_30946);
var inst_30948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30949 = [inst_30947];
var inst_30950 = (new cljs.core.PersistentVector(null,1,(5),inst_30948,inst_30949,null));
var inst_30951 = cljs.core.concat.call(null,inst_30938,inst_30950);
var inst_30952 = cljs.core.first.call(null,inst_30937);
var state_30963__$1 = (function (){var statearr_30967 = state_30963;
(statearr_30967[(10)] = inst_30951);

return statearr_30967;
})();
if(cljs.core.truth_(inst_30952)){
var statearr_30968_30980 = state_30963__$1;
(statearr_30968_30980[(1)] = (5));

} else {
var statearr_30969_30981 = state_30963__$1;
(statearr_30969_30981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30964 === (5))){
var inst_30937 = (state_30963[(9)]);
var inst_30951 = (state_30963[(10)]);
var inst_30954 = cljs.core.first.call(null,inst_30937);
var inst_30955 = cljs.core.rest.call(null,inst_30937);
var inst_30936 = inst_30954;
var inst_30937__$1 = inst_30955;
var inst_30938 = inst_30951;
var state_30963__$1 = (function (){var statearr_30970 = state_30963;
(statearr_30970[(7)] = inst_30938);

(statearr_30970[(8)] = inst_30936);

(statearr_30970[(9)] = inst_30937__$1);

return statearr_30970;
})();
var statearr_30971_30982 = state_30963__$1;
(statearr_30971_30982[(2)] = null);

(statearr_30971_30982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30964 === (6))){
var inst_30951 = (state_30963[(10)]);
var state_30963__$1 = state_30963;
var statearr_30972_30983 = state_30963__$1;
(statearr_30972_30983[(2)] = inst_30951);

(statearr_30972_30983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30964 === (7))){
var inst_30959 = (state_30963[(2)]);
var state_30963__$1 = state_30963;
var statearr_30973_30984 = state_30963__$1;
(statearr_30973_30984[(2)] = inst_30959);

(statearr_30973_30984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____0 = (function (){
var statearr_30974 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30974[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__);

(statearr_30974[(1)] = (1));

return statearr_30974;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____1 = (function (state_30963){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30975){var ex__2457__auto__ = e30975;
var statearr_30976_30985 = state_30963;
(statearr_30976_30985[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30963[(4)]))){
var statearr_30977_30986 = state_30963;
(statearr_30977_30986[(1)] = cljs.core.first.call(null,(state_30963[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30987 = state_30963;
state_30963 = G__30987;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__ = function(state_30963){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____1.call(this,state_30963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30978 = f__2477__auto__.call(null);
(statearr_30978[(6)] = c__2476__auto__);

return statearr_30978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31055){
var state_val_31056 = (state_31055[(1)]);
if((state_val_31056 === (7))){
var inst_31015 = (state_31055[(2)]);
var inst_31016 = fluree.db.util.async.throw_err.call(null,inst_31015);
var state_31055__$1 = state_31055;
var statearr_31057_31083 = state_31055__$1;
(statearr_31057_31083[(2)] = inst_31016);

(statearr_31057_31083[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (1))){
var inst_30992 = cljs.core.volatile_BANG_.call(null,(0));
var inst_30993 = cljs.core.PersistentHashMap.EMPTY;
var inst_30994 = cljs.core.volatile_BANG_.call(null,inst_30993);
var inst_30995 = cljs.core.first.call(null,resp);
var inst_30996 = cljs.core.rest.call(null,resp);
var inst_30997 = cljs.core.PersistentVector.EMPTY;
var inst_30998 = inst_30992;
var inst_30999 = inst_30994;
var inst_31000 = inst_30995;
var inst_31001 = inst_30996;
var inst_31002 = inst_30997;
var state_31055__$1 = (function (){var statearr_31058 = state_31055;
(statearr_31058[(7)] = inst_31002);

(statearr_31058[(8)] = inst_31000);

(statearr_31058[(9)] = inst_30998);

(statearr_31058[(10)] = inst_31001);

(statearr_31058[(11)] = inst_30999);

return statearr_31058;
})();
var statearr_31059_31084 = state_31055__$1;
(statearr_31059_31084[(2)] = null);

(statearr_31059_31084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (4))){
var inst_31004 = (state_31055[(12)]);
var inst_31002 = (state_31055[(7)]);
var inst_31000 = (state_31055[(8)]);
var inst_31006 = (state_31055[(13)]);
var inst_30998 = (state_31055[(9)]);
var inst_31001 = (state_31055[(10)]);
var inst_30999 = (state_31055[(11)]);
var inst_31010 = (function (){var fuel = inst_30998;
var cache = inst_30999;
var curr_block = inst_31000;
var rest_blocks = inst_31001;
var acc = inst_31002;
var flakes = inst_31004;
var asserted = inst_31006;
return (function (p1__30989_SHARP_){
return p1__30989_SHARP_.s;
});
})();
var inst_31011 = cljs.core.group_by.call(null,inst_31010,inst_31006);
var inst_31012 = cljs.core.vals.call(null,inst_31011);
var inst_31013 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_30999,inst_30998,inst_31012);
var state_31055__$1 = state_31055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31055__$1,(7),inst_31013);
} else {
if((state_val_31056 === (13))){
var inst_31043 = (state_31055[(14)]);
var state_31055__$1 = state_31055;
var statearr_31060_31085 = state_31055__$1;
(statearr_31060_31085[(2)] = inst_31043);

(statearr_31060_31085[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (6))){
var inst_31004 = (state_31055[(12)]);
var inst_31021 = (state_31055[(15)]);
var inst_31002 = (state_31055[(7)]);
var inst_31000 = (state_31055[(8)]);
var inst_31006 = (state_31055[(13)]);
var inst_30998 = (state_31055[(9)]);
var inst_31001 = (state_31055[(10)]);
var inst_30999 = (state_31055[(11)]);
var inst_31019 = (state_31055[(16)]);
var inst_31019__$1 = (state_31055[(2)]);
var inst_31020 = (function (){var fuel = inst_30998;
var cache = inst_30999;
var curr_block = inst_31000;
var rest_blocks = inst_31001;
var acc = inst_31002;
var flakes = inst_31004;
var asserted = inst_31006;
var asserted_SINGLEQUOTE_ = inst_31019__$1;
return (function (p1__30990_SHARP_){
return p1__30990_SHARP_.op === false;
});
})();
var inst_31021__$1 = cljs.core.filter.call(null,inst_31020,inst_31004);
var inst_31022 = cljs.core.empty_QMARK_.call(null,inst_31021__$1);
var inst_31023 = (!(inst_31022));
var state_31055__$1 = (function (){var statearr_31063 = state_31055;
(statearr_31063[(15)] = inst_31021__$1);

(statearr_31063[(16)] = inst_31019__$1);

return statearr_31063;
})();
if(inst_31023){
var statearr_31064_31086 = state_31055__$1;
(statearr_31064_31086[(1)] = (8));

} else {
var statearr_31065_31087 = state_31055__$1;
(statearr_31065_31087[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (3))){
var inst_31053 = (state_31055[(2)]);
var state_31055__$1 = state_31055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31055__$1,inst_31053);
} else {
if((state_val_31056 === (12))){
var inst_31043 = (state_31055[(14)]);
var inst_30998 = (state_31055[(9)]);
var inst_31001 = (state_31055[(10)]);
var inst_30999 = (state_31055[(11)]);
var inst_31046 = cljs.core.first.call(null,inst_31001);
var inst_31047 = cljs.core.rest.call(null,inst_31001);
var tmp31061 = inst_30998;
var tmp31062 = inst_30999;
var inst_30998__$1 = tmp31061;
var inst_30999__$1 = tmp31062;
var inst_31000 = inst_31046;
var inst_31001__$1 = inst_31047;
var inst_31002 = inst_31043;
var state_31055__$1 = (function (){var statearr_31066 = state_31055;
(statearr_31066[(7)] = inst_31002);

(statearr_31066[(8)] = inst_31000);

(statearr_31066[(9)] = inst_30998__$1);

(statearr_31066[(10)] = inst_31001__$1);

(statearr_31066[(11)] = inst_30999__$1);

return statearr_31066;
})();
var statearr_31067_31088 = state_31055__$1;
(statearr_31067_31088[(2)] = null);

(statearr_31067_31088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (2))){
var inst_31004 = (state_31055[(12)]);
var inst_31002 = (state_31055[(7)]);
var inst_31000 = (state_31055[(8)]);
var inst_31006 = (state_31055[(13)]);
var inst_30998 = (state_31055[(9)]);
var inst_31001 = (state_31055[(10)]);
var inst_30999 = (state_31055[(11)]);
var inst_31004__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_31000);
var inst_31005 = (function (){var fuel = inst_30998;
var cache = inst_30999;
var curr_block = inst_31000;
var rest_blocks = inst_31001;
var acc = inst_31002;
var flakes = inst_31004__$1;
return (function (p1__30988_SHARP_){
return p1__30988_SHARP_.op;
});
})();
var inst_31006__$1 = cljs.core.filter.call(null,inst_31005,inst_31004__$1);
var inst_31007 = cljs.core.empty_QMARK_.call(null,inst_31006__$1);
var inst_31008 = (!(inst_31007));
var state_31055__$1 = (function (){var statearr_31068 = state_31055;
(statearr_31068[(12)] = inst_31004__$1);

(statearr_31068[(13)] = inst_31006__$1);

return statearr_31068;
})();
if(inst_31008){
var statearr_31069_31089 = state_31055__$1;
(statearr_31069_31089[(1)] = (4));

} else {
var statearr_31070_31090 = state_31055__$1;
(statearr_31070_31090[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (11))){
var inst_31031 = (state_31055[(2)]);
var inst_31032 = fluree.db.util.async.throw_err.call(null,inst_31031);
var state_31055__$1 = state_31055;
var statearr_31071_31091 = state_31055__$1;
(statearr_31071_31091[(2)] = inst_31032);

(statearr_31071_31091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (9))){
var state_31055__$1 = state_31055;
var statearr_31072_31092 = state_31055__$1;
(statearr_31072_31092[(2)] = null);

(statearr_31072_31092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (5))){
var state_31055__$1 = state_31055;
var statearr_31073_31093 = state_31055__$1;
(statearr_31073_31093[(2)] = null);

(statearr_31073_31093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (14))){
var inst_31051 = (state_31055[(2)]);
var state_31055__$1 = state_31055;
var statearr_31074_31094 = state_31055__$1;
(statearr_31074_31094[(2)] = inst_31051);

(statearr_31074_31094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (10))){
var inst_31002 = (state_31055[(7)]);
var inst_31000 = (state_31055[(8)]);
var inst_31001 = (state_31055[(10)]);
var inst_31019 = (state_31055[(16)]);
var inst_31035 = (state_31055[(2)]);
var inst_31036 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_31037 = [inst_31019,inst_31035];
var inst_31038 = cljs.core.PersistentHashMap.fromArrays(inst_31036,inst_31037);
var inst_31039 = cljs.core.assoc.call(null,inst_31000,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_31038);
var inst_31040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31041 = [inst_31039];
var inst_31042 = (new cljs.core.PersistentVector(null,1,(5),inst_31040,inst_31041,null));
var inst_31043 = cljs.core.concat.call(null,inst_31002,inst_31042);
var inst_31044 = cljs.core.first.call(null,inst_31001);
var state_31055__$1 = (function (){var statearr_31075 = state_31055;
(statearr_31075[(14)] = inst_31043);

return statearr_31075;
})();
if(cljs.core.truth_(inst_31044)){
var statearr_31076_31095 = state_31055__$1;
(statearr_31076_31095[(1)] = (12));

} else {
var statearr_31077_31096 = state_31055__$1;
(statearr_31077_31096[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31056 === (8))){
var inst_31004 = (state_31055[(12)]);
var inst_31021 = (state_31055[(15)]);
var inst_31002 = (state_31055[(7)]);
var inst_31000 = (state_31055[(8)]);
var inst_31006 = (state_31055[(13)]);
var inst_30998 = (state_31055[(9)]);
var inst_31001 = (state_31055[(10)]);
var inst_30999 = (state_31055[(11)]);
var inst_31019 = (state_31055[(16)]);
var inst_31025 = (function (){var flakes = inst_31004;
var rest_blocks = inst_31001;
var curr_block = inst_31000;
var asserted_SINGLEQUOTE_ = inst_31019;
var acc = inst_31002;
var fuel = inst_30998;
var cache = inst_30999;
var retracted = inst_31021;
var asserted = inst_31006;
return (function (p1__30991_SHARP_){
return p1__30991_SHARP_.s;
});
})();
var inst_31026 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_31021);
var inst_31027 = cljs.core.group_by.call(null,inst_31025,inst_31026);
var inst_31028 = cljs.core.vals.call(null,inst_31027);
var inst_31029 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_30999,inst_30998,inst_31028);
var state_31055__$1 = state_31055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31055__$1,(11),inst_31029);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____0 = (function (){
var statearr_31078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31078[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__);

(statearr_31078[(1)] = (1));

return statearr_31078;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____1 = (function (state_31055){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e31079){var ex__2457__auto__ = e31079;
var statearr_31080_31097 = state_31055;
(statearr_31080_31097[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31055[(4)]))){
var statearr_31081_31098 = state_31055;
(statearr_31081_31098[(1)] = cljs.core.first.call(null,(state_31055[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31099 = state_31055;
state_31055 = G__31099;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__ = function(state_31055){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____1.call(this,state_31055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_31082 = f__2477__auto__.call(null);
(statearr_31082[(6)] = c__2476__auto__);

return statearr_31082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31199){
var state_val_31200 = (state_31199[(1)]);
if((state_val_31200 === (7))){
var inst_31171 = (state_31199[(7)]);
var inst_31164 = (state_31199[(8)]);
var inst_31170 = cljs.core.seq.call(null,inst_31164);
var inst_31171__$1 = cljs.core.first.call(null,inst_31170);
var inst_31172 = cljs.core.next.call(null,inst_31170);
var state_31199__$1 = (function (){var statearr_31201 = state_31199;
(statearr_31201[(7)] = inst_31171__$1);

(statearr_31201[(9)] = inst_31172);

return statearr_31201;
})();
if(cljs.core.truth_(inst_31171__$1)){
var statearr_31202_31239 = state_31199__$1;
(statearr_31202_31239[(1)] = (9));

} else {
var statearr_31203_31240 = state_31199__$1;
(statearr_31203_31240[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (1))){
var state_31199__$1 = state_31199;
var statearr_31204_31241 = state_31199__$1;
(statearr_31204_31241[(2)] = null);

(statearr_31204_31241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (4))){
var inst_31101 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31205_31242 = state_31199__$1;
(statearr_31205_31242[(2)] = inst_31101);

(statearr_31205_31242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (6))){
var inst_31150 = (state_31199[(2)]);
var inst_31151 = fluree.db.util.async.throw_err.call(null,inst_31150);
var inst_31159 = resp;
var inst_31160 = cljs.core.seq.call(null,inst_31159);
var inst_31161 = cljs.core.first.call(null,inst_31160);
var inst_31162 = cljs.core.next.call(null,inst_31160);
var inst_31163 = cljs.core.PersistentHashMap.EMPTY;
var inst_31164 = inst_31159;
var inst_31165 = inst_31163;
var state_31199__$1 = (function (){var statearr_31206 = state_31199;
(statearr_31206[(10)] = inst_31162);

(statearr_31206[(11)] = inst_31151);

(statearr_31206[(12)] = inst_31165);

(statearr_31206[(8)] = inst_31164);

(statearr_31206[(13)] = inst_31161);

return statearr_31206;
})();
var statearr_31207_31243 = state_31199__$1;
(statearr_31207_31243[(2)] = null);

(statearr_31207_31243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (3))){
var inst_31197 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31199__$1,inst_31197);
} else {
if((state_val_31200 === (2))){
var _ = (function (){var statearr_31208 = state_31199;
(statearr_31208[(4)] = cljs.core.cons.call(null,(5),(state_31199[(4)])));

return statearr_31208;
})();
var inst_31107 = (function (){return (function (p1__31100_SHARP_){
return p1__31100_SHARP_.t;
});
})();
var inst_31108 = cljs.core.map.call(null,inst_31107,resp);
var inst_31109 = cljs.core.set.call(null,inst_31108);
var inst_31146 = cljs.core.async.chan.call(null,(1));
var inst_31147 = (function (){var ts = inst_31109;
var c__2476__auto____$1 = inst_31146;
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31144){
var state_val_31145 = (state_31144[(1)]);
if((state_val_31145 === (1))){
var inst_31117 = ts;
var inst_31118 = cljs.core.seq.call(null,inst_31117);
var inst_31119 = cljs.core.first.call(null,inst_31118);
var inst_31120 = cljs.core.next.call(null,inst_31118);
var inst_31121 = cljs.core.PersistentHashMap.EMPTY;
var inst_31122 = inst_31117;
var inst_31123 = inst_31121;
var state_31144__$1 = (function (){var statearr_31209 = state_31144;
(statearr_31209[(7)] = inst_31123);

(statearr_31209[(8)] = inst_31122);

(statearr_31209[(9)] = inst_31119);

(statearr_31209[(10)] = inst_31120);

return statearr_31209;
})();
var statearr_31210_31244 = state_31144__$1;
(statearr_31210_31244[(2)] = null);

(statearr_31210_31244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31145 === (2))){
var inst_31129 = (state_31144[(11)]);
var inst_31122 = (state_31144[(8)]);
var inst_31128 = cljs.core.seq.call(null,inst_31122);
var inst_31129__$1 = cljs.core.first.call(null,inst_31128);
var inst_31130 = cljs.core.next.call(null,inst_31128);
var state_31144__$1 = (function (){var statearr_31211 = state_31144;
(statearr_31211[(11)] = inst_31129__$1);

(statearr_31211[(12)] = inst_31130);

return statearr_31211;
})();
if(cljs.core.truth_(inst_31129__$1)){
var statearr_31212_31245 = state_31144__$1;
(statearr_31212_31245[(1)] = (4));

} else {
var statearr_31213_31246 = state_31144__$1;
(statearr_31213_31246[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31145 === (3))){
var inst_31142 = (state_31144[(2)]);
var state_31144__$1 = state_31144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31144__$1,inst_31142);
} else {
if((state_val_31145 === (4))){
var inst_31129 = (state_31144[(11)]);
var inst_31132 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_31129);
var state_31144__$1 = state_31144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31144__$1,(7),inst_31132);
} else {
if((state_val_31145 === (5))){
var inst_31123 = (state_31144[(7)]);
var state_31144__$1 = state_31144;
var statearr_31214_31247 = state_31144__$1;
(statearr_31214_31247[(2)] = inst_31123);

(statearr_31214_31247[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31145 === (6))){
var inst_31140 = (state_31144[(2)]);
var state_31144__$1 = state_31144;
var statearr_31215_31248 = state_31144__$1;
(statearr_31215_31248[(2)] = inst_31140);

(statearr_31215_31248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31145 === (7))){
var inst_31129 = (state_31144[(11)]);
var inst_31123 = (state_31144[(7)]);
var inst_31130 = (state_31144[(12)]);
var inst_31134 = (state_31144[(2)]);
var inst_31135 = fluree.db.util.async.throw_err.call(null,inst_31134);
var inst_31136 = cljs.core.assoc.call(null,inst_31123,inst_31129,inst_31135);
var inst_31122 = inst_31130;
var inst_31123__$1 = inst_31136;
var state_31144__$1 = (function (){var statearr_31216 = state_31144;
(statearr_31216[(7)] = inst_31123__$1);

(statearr_31216[(8)] = inst_31122);

return statearr_31216;
})();
var statearr_31217_31249 = state_31144__$1;
(statearr_31217_31249[(2)] = null);

(statearr_31217_31249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0 = (function (){
var statearr_31218 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31218[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__);

(statearr_31218[(1)] = (1));

return statearr_31218;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1 = (function (state_31144){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e31219){var ex__2457__auto__ = e31219;
var statearr_31220_31250 = state_31144;
(statearr_31220_31250[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31144[(4)]))){
var statearr_31221_31251 = state_31144;
(statearr_31221_31251[(1)] = cljs.core.first.call(null,(state_31144[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31252 = state_31144;
state_31144 = G__31252;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__ = function(state_31144){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1.call(this,state_31144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_31222 = f__2477__auto__.call(null);
(statearr_31222[(6)] = c__2476__auto____$1);

return statearr_31222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});
})();
var inst_31148 = cljs.core.async.impl.dispatch.run.call(null,inst_31147);
var state_31199__$1 = (function (){var statearr_31223 = state_31199;
(statearr_31223[(14)] = inst_31148);

return statearr_31223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31199__$1,(6),inst_31146);
} else {
if((state_val_31200 === (11))){
var inst_31191 = (state_31199[(2)]);
var state_31199__$1 = state_31199;
var statearr_31225_31253 = state_31199__$1;
(statearr_31225_31253[(2)] = inst_31191);

(statearr_31225_31253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (9))){
var inst_31171 = (state_31199[(7)]);
var inst_31172 = (state_31199[(9)]);
var inst_31151 = (state_31199[(11)]);
var inst_31165 = (state_31199[(12)]);
var inst_31174 = inst_31171.t;
var inst_31175 = cljs.core.get.call(null,inst_31151,inst_31174);
var inst_31176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31177 = [inst_31175,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_31178 = (new cljs.core.PersistentVector(null,2,(5),inst_31176,inst_31177,null));
var inst_31179 = cljs.core.assoc_in.call(null,inst_31165,inst_31178,inst_31175);
var inst_31180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31181 = [inst_31175,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_31182 = (new cljs.core.PersistentVector(null,2,(5),inst_31180,inst_31181,null));
var inst_31183 = cljs.core.update_in.call(null,inst_31179,inst_31182,cljs.core.conj,inst_31171);
var inst_31184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31185 = [inst_31175,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_31186 = (new cljs.core.PersistentVector(null,2,(5),inst_31184,inst_31185,null));
var inst_31187 = cljs.core.update_in.call(null,inst_31183,inst_31186,fluree.db.api_js.min_safe,inst_31174);
var inst_31164 = inst_31172;
var inst_31165__$1 = inst_31187;
var state_31199__$1 = (function (){var statearr_31226 = state_31199;
(statearr_31226[(12)] = inst_31165__$1);

(statearr_31226[(8)] = inst_31164);

return statearr_31226;
})();
var statearr_31227_31254 = state_31199__$1;
(statearr_31227_31254[(2)] = null);

(statearr_31227_31254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (5))){
var _ = (function (){var statearr_31228 = state_31199;
(statearr_31228[(4)] = cljs.core.rest.call(null,(state_31199[(4)])));

return statearr_31228;
})();
var state_31199__$1 = state_31199;
var ex31224 = (state_31199__$1[(2)]);
var statearr_31229_31255 = state_31199__$1;
(statearr_31229_31255[(5)] = ex31224);


if((ex31224 instanceof Error)){
var statearr_31230_31256 = state_31199__$1;
(statearr_31230_31256[(1)] = (4));

(statearr_31230_31256[(5)] = null);

} else {
throw ex31224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (10))){
var inst_31165 = (state_31199[(12)]);
var state_31199__$1 = state_31199;
var statearr_31231_31257 = state_31199__$1;
(statearr_31231_31257[(2)] = inst_31165);

(statearr_31231_31257[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31200 === (8))){
var inst_31193 = (state_31199[(2)]);
var inst_31194 = cljs.core.vals.call(null,inst_31193);
var _ = (function (){var statearr_31232 = state_31199;
(statearr_31232[(4)] = cljs.core.rest.call(null,(state_31199[(4)])));

return statearr_31232;
})();
var state_31199__$1 = state_31199;
var statearr_31233_31258 = state_31199__$1;
(statearr_31233_31258[(2)] = inst_31194);

(statearr_31233_31258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0 = (function (){
var statearr_31234 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31234[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__);

(statearr_31234[(1)] = (1));

return statearr_31234;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1 = (function (state_31199){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e31235){var ex__2457__auto__ = e31235;
var statearr_31236_31259 = state_31199;
(statearr_31236_31259[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31199[(4)]))){
var statearr_31237_31260 = state_31199;
(statearr_31237_31260[(1)] = cljs.core.first.call(null,(state_31199[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31261 = state_31199;
state_31199 = G__31261;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__ = function(state_31199){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1.call(this,state_31199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2454__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_31238 = f__2477__auto__.call(null);
(statearr_31238[(6)] = c__2476__auto__);

return statearr_31238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31403){
var state_val_31404 = (state_31403[(1)]);
if((state_val_31404 === (7))){
var inst_31286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31287 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_31288 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_31289 = [inst_31287,inst_31288];
var inst_31290 = (new cljs.core.PersistentVector(null,2,(5),inst_31286,inst_31289,null));
var state_31403__$1 = state_31403;
var statearr_31405_31472 = state_31403__$1;
(statearr_31405_31472[(2)] = inst_31290);

(statearr_31405_31472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (20))){
var inst_31316 = (state_31403[(7)]);
var state_31403__$1 = state_31403;
var statearr_31406_31473 = state_31403__$1;
(statearr_31406_31473[(2)] = inst_31316);

(statearr_31406_31473[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (27))){
var state_31403__$1 = state_31403;
var statearr_31407_31474 = state_31403__$1;
(statearr_31407_31474[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (1))){
var state_31403__$1 = state_31403;
var statearr_31409_31475 = state_31403__$1;
(statearr_31409_31475[(2)] = null);

(statearr_31409_31475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (24))){
var inst_31315 = (state_31403[(8)]);
var state_31403__$1 = state_31403;
if(cljs.core.truth_(inst_31315)){
var statearr_31410_31476 = state_31403__$1;
(statearr_31410_31476[(1)] = (26));

} else {
var statearr_31411_31477 = state_31403__$1;
(statearr_31411_31477[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (39))){
var inst_31390 = (state_31403[(9)]);
var state_31403__$1 = state_31403;
var statearr_31412_31478 = state_31403__$1;
(statearr_31412_31478[(2)] = inst_31390);

(statearr_31412_31478[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (4))){
var inst_31262 = (state_31403[(2)]);
var inst_31263 = fluree.db.util.log.error.call(null,inst_31262);
var inst_31264 = cljs.core.ex_data.call(null,inst_31262);
var inst_31265 = cljs.core.ex_message.call(null,inst_31262);
var inst_31266 = cljs.core.assoc.call(null,inst_31264,new cljs.core.Keyword(null,"message","message",-406056002),inst_31265);
var state_31403__$1 = (function (){var statearr_31413 = state_31403;
(statearr_31413[(10)] = inst_31263);

return statearr_31413;
})();
var statearr_31414_31479 = state_31403__$1;
(statearr_31414_31479[(2)] = inst_31266);

(statearr_31414_31479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (15))){
var inst_31295 = (state_31403[(11)]);
var inst_31300 = (state_31403[(12)]);
var inst_31309 = (state_31403[(2)]);
var inst_31310 = [inst_31300,inst_31309];
var inst_31311 = (new cljs.core.PersistentVector(null,2,(5),inst_31295,inst_31310,null));
var state_31403__$1 = state_31403;
var statearr_31415_31480 = state_31403__$1;
(statearr_31415_31480[(2)] = inst_31311);

(statearr_31415_31480[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (21))){
var inst_31315 = (state_31403[(8)]);
var state_31403__$1 = state_31403;
var statearr_31416_31481 = state_31403__$1;
(statearr_31416_31481[(2)] = inst_31315);

(statearr_31416_31481[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (31))){
var inst_31356 = (state_31403[(2)]);
var state_31403__$1 = state_31403;
var statearr_31417_31482 = state_31403__$1;
(statearr_31417_31482[(2)] = inst_31356);

(statearr_31417_31482[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (32))){
var inst_31292 = (state_31403[(13)]);
var inst_31368 = cljs.core.pr_str.call(null,inst_31292);
var inst_31369 = ["Invalid block range provided: ",inst_31368].join('');
var inst_31370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31371 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31372 = cljs.core.PersistentHashMap.fromArrays(inst_31370,inst_31371);
var inst_31373 = cljs.core.ex_info.call(null,inst_31369,inst_31372);
var inst_31374 = (function(){throw inst_31373})();
var state_31403__$1 = state_31403;
var statearr_31418_31483 = state_31403__$1;
(statearr_31418_31483[(2)] = inst_31374);

(statearr_31418_31483[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (40))){
var inst_31389 = (state_31403[(14)]);
var inst_31395 = (state_31403[(2)]);
var inst_31396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31397 = [inst_31389,inst_31395];
var inst_31398 = (new cljs.core.PersistentVector(null,2,(5),inst_31396,inst_31397,null));
var _ = (function (){var statearr_31419 = state_31403;
(statearr_31419[(4)] = cljs.core.rest.call(null,(state_31403[(4)])));

return statearr_31419;
})();
var state_31403__$1 = state_31403;
var statearr_31420_31484 = state_31403__$1;
(statearr_31420_31484[(2)] = inst_31398);

(statearr_31420_31484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (33))){
var state_31403__$1 = state_31403;
var statearr_31421_31485 = state_31403__$1;
(statearr_31421_31485[(2)] = null);

(statearr_31421_31485[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (13))){
var inst_31301 = (state_31403[(15)]);
var inst_31303 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_31301);
var state_31403__$1 = state_31403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31403__$1,(16),inst_31303);
} else {
if((state_val_31404 === (22))){
var inst_31334 = (state_31403[(2)]);
var state_31403__$1 = state_31403;
if(cljs.core.truth_(inst_31334)){
var statearr_31422_31486 = state_31403__$1;
(statearr_31422_31486[(1)] = (23));

} else {
var statearr_31423_31487 = state_31403__$1;
(statearr_31423_31487[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (36))){
var inst_31362 = (state_31403[(16)]);
var inst_31361 = (state_31403[(17)]);
var inst_31384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31385 = [inst_31361,inst_31362];
var inst_31386 = (new cljs.core.PersistentVector(null,2,(5),inst_31384,inst_31385,null));
var state_31403__$1 = state_31403;
var statearr_31424_31488 = state_31403__$1;
(statearr_31424_31488[(2)] = inst_31386);

(statearr_31424_31488[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (29))){
var inst_31292 = (state_31403[(13)]);
var inst_31347 = cljs.core.pr_str.call(null,inst_31292);
var inst_31348 = ["Invalid block range provided: ",inst_31347].join('');
var inst_31349 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31350 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31351 = cljs.core.PersistentHashMap.fromArrays(inst_31349,inst_31350);
var inst_31352 = cljs.core.ex_info.call(null,inst_31348,inst_31351);
var inst_31353 = (function(){throw inst_31352})();
var state_31403__$1 = state_31403;
var statearr_31425_31489 = state_31403__$1;
(statearr_31425_31489[(2)] = inst_31353);

(statearr_31425_31489[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (6))){
var inst_31284 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_31403__$1 = state_31403;
var statearr_31426_31490 = state_31403__$1;
(statearr_31426_31490[(2)] = inst_31284);

(statearr_31426_31490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (28))){
var inst_31358 = (state_31403[(2)]);
var state_31403__$1 = state_31403;
var statearr_31427_31491 = state_31403__$1;
(statearr_31427_31491[(2)] = inst_31358);

(statearr_31427_31491[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (25))){
var inst_31362 = (state_31403[(16)]);
var inst_31361 = (state_31403[(17)]);
var inst_31360 = (state_31403[(2)]);
var inst_31361__$1 = cljs.core.nth.call(null,inst_31360,(0),null);
var inst_31362__$1 = cljs.core.nth.call(null,inst_31360,(1),null);
var inst_31363 = cljs.core.pos_int_QMARK_.call(null,inst_31361__$1);
var inst_31364 = cljs.core.pos_int_QMARK_.call(null,inst_31362__$1);
var inst_31365 = ((inst_31363) && (inst_31364));
var inst_31366 = cljs.core.not.call(null,inst_31365);
var state_31403__$1 = (function (){var statearr_31428 = state_31403;
(statearr_31428[(16)] = inst_31362__$1);

(statearr_31428[(17)] = inst_31361__$1);

return statearr_31428;
})();
if(inst_31366){
var statearr_31429_31492 = state_31403__$1;
(statearr_31429_31492[(1)] = (32));

} else {
var statearr_31430_31493 = state_31403__$1;
(statearr_31430_31493[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (34))){
var inst_31362 = (state_31403[(16)]);
var inst_31361 = (state_31403[(17)]);
var inst_31377 = (state_31403[(2)]);
var inst_31378 = (inst_31362 < inst_31361);
var state_31403__$1 = (function (){var statearr_31431 = state_31403;
(statearr_31431[(18)] = inst_31377);

return statearr_31431;
})();
if(cljs.core.truth_(inst_31378)){
var statearr_31432_31494 = state_31403__$1;
(statearr_31432_31494[(1)] = (35));

} else {
var statearr_31433_31495 = state_31403__$1;
(statearr_31433_31495[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (17))){
var inst_31317 = (state_31403[(19)]);
var inst_31315 = (state_31403[(8)]);
var inst_31320 = cljs.core.pr_str.call(null,inst_31315);
var inst_31321 = cljs.core.pr_str.call(null,inst_31317);
var inst_31322 = ["Start block is out of range for this ledger. Start block provided: ",inst_31320,". Database block: ",inst_31321].join('');
var inst_31323 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31324 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31325 = cljs.core.PersistentHashMap.fromArrays(inst_31323,inst_31324);
var inst_31326 = cljs.core.ex_info.call(null,inst_31322,inst_31325);
var inst_31327 = (function(){throw inst_31326})();
var state_31403__$1 = state_31403;
var statearr_31434_31496 = state_31403__$1;
(statearr_31434_31496[(2)] = inst_31327);

(statearr_31434_31496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (3))){
var inst_31401 = (state_31403[(2)]);
var state_31403__$1 = state_31403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31403__$1,inst_31401);
} else {
if((state_val_31404 === (12))){
var inst_31292 = (state_31403[(13)]);
var inst_31301 = (state_31403[(15)]);
var inst_31299 = (state_31403[(2)]);
var inst_31300 = fluree.db.util.async.throw_err.call(null,inst_31299);
var inst_31301__$1 = cljs.core.second.call(null,inst_31292);
var state_31403__$1 = (function (){var statearr_31435 = state_31403;
(statearr_31435[(15)] = inst_31301__$1);

(statearr_31435[(12)] = inst_31300);

return statearr_31435;
})();
if(cljs.core.truth_(inst_31301__$1)){
var statearr_31436_31497 = state_31403__$1;
(statearr_31436_31497[(1)] = (13));

} else {
var statearr_31437_31498 = state_31403__$1;
(statearr_31437_31498[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (2))){
var _ = (function (){var statearr_31438 = state_31403;
(statearr_31438[(4)] = cljs.core.cons.call(null,(5),(state_31403[(4)])));

return statearr_31438;
})();
var inst_31281 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_31282 = cljs.core.sequential_QMARK_.call(null,inst_31281);
var state_31403__$1 = state_31403;
if(inst_31282){
var statearr_31439_31499 = state_31403__$1;
(statearr_31439_31499[(1)] = (6));

} else {
var statearr_31440_31500 = state_31403__$1;
(statearr_31440_31500[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (23))){
var inst_31316 = (state_31403[(7)]);
var inst_31315 = (state_31403[(8)]);
var inst_31336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31337 = [inst_31315,inst_31316];
var inst_31338 = (new cljs.core.PersistentVector(null,2,(5),inst_31336,inst_31337,null));
var state_31403__$1 = state_31403;
var statearr_31441_31501 = state_31403__$1;
(statearr_31441_31501[(2)] = inst_31338);

(statearr_31441_31501[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (35))){
var inst_31362 = (state_31403[(16)]);
var inst_31361 = (state_31403[(17)]);
var inst_31380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31381 = [inst_31362,inst_31361];
var inst_31382 = (new cljs.core.PersistentVector(null,2,(5),inst_31380,inst_31381,null));
var state_31403__$1 = state_31403;
var statearr_31442_31502 = state_31403__$1;
(statearr_31442_31502[(2)] = inst_31382);

(statearr_31442_31502[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (19))){
var inst_31315 = (state_31403[(8)]);
var inst_31330 = (state_31403[(2)]);
var state_31403__$1 = (function (){var statearr_31443 = state_31403;
(statearr_31443[(20)] = inst_31330);

return statearr_31443;
})();
if(cljs.core.truth_(inst_31315)){
var statearr_31444_31503 = state_31403__$1;
(statearr_31444_31503[(1)] = (20));

} else {
var statearr_31445_31504 = state_31403__$1;
(statearr_31445_31504[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (11))){
var inst_31317 = (state_31403[(19)]);
var inst_31315 = (state_31403[(8)]);
var inst_31314 = (state_31403[(2)]);
var inst_31315__$1 = cljs.core.nth.call(null,inst_31314,(0),null);
var inst_31316 = cljs.core.nth.call(null,inst_31314,(1),null);
var inst_31317__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_31318 = (inst_31315__$1 > inst_31317__$1);
var state_31403__$1 = (function (){var statearr_31447 = state_31403;
(statearr_31447[(7)] = inst_31316);

(statearr_31447[(19)] = inst_31317__$1);

(statearr_31447[(8)] = inst_31315__$1);

return statearr_31447;
})();
if(cljs.core.truth_(inst_31318)){
var statearr_31448_31505 = state_31403__$1;
(statearr_31448_31505[(1)] = (17));

} else {
var statearr_31449_31506 = state_31403__$1;
(statearr_31449_31506[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (9))){
var inst_31292 = (state_31403[(13)]);
var inst_31295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31296 = cljs.core.first.call(null,inst_31292);
var inst_31297 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_31296);
var state_31403__$1 = (function (){var statearr_31450 = state_31403;
(statearr_31450[(11)] = inst_31295);

return statearr_31450;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31403__$1,(12),inst_31297);
} else {
if((state_val_31404 === (5))){
var _ = (function (){var statearr_31451 = state_31403;
(statearr_31451[(4)] = cljs.core.rest.call(null,(state_31403[(4)])));

return statearr_31451;
})();
var state_31403__$1 = state_31403;
var ex31446 = (state_31403__$1[(2)]);
var statearr_31452_31507 = state_31403__$1;
(statearr_31452_31507[(5)] = ex31446);


var statearr_31453_31508 = state_31403__$1;
(statearr_31453_31508[(1)] = (4));

(statearr_31453_31508[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (14))){
var state_31403__$1 = state_31403;
var statearr_31454_31509 = state_31403__$1;
(statearr_31454_31509[(2)] = null);

(statearr_31454_31509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (26))){
var inst_31315 = (state_31403[(8)]);
var inst_31341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31342 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_31343 = [inst_31315,inst_31342];
var inst_31344 = (new cljs.core.PersistentVector(null,2,(5),inst_31341,inst_31343,null));
var state_31403__$1 = state_31403;
var statearr_31455_31510 = state_31403__$1;
(statearr_31455_31510[(2)] = inst_31344);

(statearr_31455_31510[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (16))){
var inst_31305 = (state_31403[(2)]);
var inst_31306 = fluree.db.util.async.throw_err.call(null,inst_31305);
var state_31403__$1 = state_31403;
var statearr_31456_31511 = state_31403__$1;
(statearr_31456_31511[(2)] = inst_31306);

(statearr_31456_31511[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (38))){
var inst_31317 = (state_31403[(19)]);
var state_31403__$1 = state_31403;
var statearr_31457_31512 = state_31403__$1;
(statearr_31457_31512[(2)] = inst_31317);

(statearr_31457_31512[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (30))){
var state_31403__$1 = state_31403;
var statearr_31458_31513 = state_31403__$1;
(statearr_31458_31513[(2)] = null);

(statearr_31458_31513[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (10))){
var inst_31292 = (state_31403[(13)]);
var state_31403__$1 = state_31403;
var statearr_31459_31514 = state_31403__$1;
(statearr_31459_31514[(2)] = inst_31292);

(statearr_31459_31514[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (18))){
var state_31403__$1 = state_31403;
var statearr_31460_31515 = state_31403__$1;
(statearr_31460_31515[(2)] = null);

(statearr_31460_31515[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (37))){
var inst_31390 = (state_31403[(9)]);
var inst_31317 = (state_31403[(19)]);
var inst_31388 = (state_31403[(2)]);
var inst_31389 = cljs.core.nth.call(null,inst_31388,(0),null);
var inst_31390__$1 = cljs.core.nth.call(null,inst_31388,(1),null);
var inst_31391 = (inst_31390__$1 > inst_31317);
var state_31403__$1 = (function (){var statearr_31461 = state_31403;
(statearr_31461[(9)] = inst_31390__$1);

(statearr_31461[(14)] = inst_31389);

return statearr_31461;
})();
if(cljs.core.truth_(inst_31391)){
var statearr_31462_31516 = state_31403__$1;
(statearr_31462_31516[(1)] = (38));

} else {
var statearr_31463_31517 = state_31403__$1;
(statearr_31463_31517[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31404 === (8))){
var inst_31292 = (state_31403[(13)]);
var inst_31292__$1 = (state_31403[(2)]);
var inst_31293 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_31292__$1);
var state_31403__$1 = (function (){var statearr_31464 = state_31403;
(statearr_31464[(13)] = inst_31292__$1);

return statearr_31464;
})();
if(cljs.core.truth_(inst_31293)){
var statearr_31465_31518 = state_31403__$1;
(statearr_31465_31518[(1)] = (9));

} else {
var statearr_31466_31519 = state_31403__$1;
(statearr_31466_31519[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____0 = (function (){
var statearr_31467 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31467[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__);

(statearr_31467[(1)] = (1));

return statearr_31467;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____1 = (function (state_31403){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e31468){var ex__2457__auto__ = e31468;
var statearr_31469_31520 = state_31403;
(statearr_31469_31520[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31403[(4)]))){
var statearr_31470_31521 = state_31403;
(statearr_31470_31521[(1)] = cljs.core.first.call(null,(state_31403[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31522 = state_31403;
state_31403 = G__31522;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__ = function(state_31403){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____1.call(this,state_31403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_31471 = f__2477__auto__.call(null);
(statearr_31471[(6)] = c__2476__auto__);

return statearr_31471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__31525 = arguments.length;
switch (G__31525) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31640){
var state_val_31641 = (state_31640[(1)]);
if((state_val_31641 === (7))){
var state_31640__$1 = state_31640;
var statearr_31642_31706 = state_31640__$1;
(statearr_31642_31706[(2)] = false);

(statearr_31642_31706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (20))){
var state_31640__$1 = state_31640;
var statearr_31643_31707 = state_31640__$1;
(statearr_31643_31707[(2)] = null);

(statearr_31643_31707[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (27))){
var inst_31607 = (state_31640[(2)]);
var inst_31608 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_31640__$1 = (function (){var statearr_31644 = state_31640;
(statearr_31644[(7)] = inst_31607);

return statearr_31644;
})();
if(cljs.core.truth_(inst_31608)){
var statearr_31645_31708 = state_31640__$1;
(statearr_31645_31708[(1)] = (29));

} else {
var statearr_31646_31709 = state_31640__$1;
(statearr_31646_31709[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (1))){
var state_31640__$1 = state_31640;
var statearr_31647_31710 = state_31640__$1;
(statearr_31647_31710[(2)] = null);

(statearr_31647_31710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (24))){
var inst_31568 = (state_31640[(8)]);
var inst_31581 = (state_31640[(2)]);
var inst_31582 = cljs.core.ex_info.call(null,inst_31581,inst_31568);
var inst_31583 = (function(){throw inst_31582})();
var state_31640__$1 = state_31640;
var statearr_31648_31711 = state_31640__$1;
(statearr_31648_31711[(2)] = inst_31583);

(statearr_31648_31711[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (4))){
var inst_31526 = (state_31640[(2)]);
var inst_31527 = fluree.db.util.log.error.call(null,inst_31526);
var inst_31528 = cljs.core.ex_data.call(null,inst_31526);
var inst_31529 = cljs.core.ex_message.call(null,inst_31526);
var inst_31530 = cljs.core.assoc.call(null,inst_31528,new cljs.core.Keyword(null,"message","message",-406056002),inst_31529);
var state_31640__$1 = (function (){var statearr_31649 = state_31640;
(statearr_31649[(9)] = inst_31527);

return statearr_31649;
})();
var statearr_31650_31712 = state_31640__$1;
(statearr_31650_31712[(2)] = inst_31530);

(statearr_31650_31712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (15))){
var inst_31568 = (state_31640[(8)]);
var inst_31567 = (state_31640[(2)]);
var inst_31568__$1 = fluree.db.util.async.throw_err.call(null,inst_31567);
var inst_31569 = cljs.core.map_QMARK_.call(null,inst_31568__$1);
var state_31640__$1 = (function (){var statearr_31651 = state_31640;
(statearr_31651[(8)] = inst_31568__$1);

return statearr_31651;
})();
if(inst_31569){
var statearr_31652_31713 = state_31640__$1;
(statearr_31652_31713[(1)] = (16));

} else {
var statearr_31653_31714 = state_31640__$1;
(statearr_31653_31714[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (21))){
var inst_31568 = (state_31640[(8)]);
var inst_31586 = (state_31640[(2)]);
var inst_31587 = cljs.core.nth.call(null,inst_31568,(0),null);
var inst_31588 = cljs.core.nth.call(null,inst_31568,(1),null);
var inst_31589 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_31590 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_31591 = cljs.core.keys.call(null,inst_31590);
var inst_31592 = cljs.core._EQ_.call(null,inst_31589,inst_31591);
var state_31640__$1 = (function (){var statearr_31654 = state_31640;
(statearr_31654[(10)] = inst_31586);

(statearr_31654[(11)] = inst_31587);

(statearr_31654[(12)] = inst_31588);

return statearr_31654;
})();
if(inst_31592){
var statearr_31655_31715 = state_31640__$1;
(statearr_31655_31715[(1)] = (25));

} else {
var statearr_31656_31716 = state_31640__$1;
(statearr_31656_31716[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (31))){
var inst_31616 = (state_31640[(2)]);
var inst_31617 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_31640__$1 = (function (){var statearr_31657 = state_31640;
(statearr_31657[(13)] = inst_31616);

return statearr_31657;
})();
if(cljs.core.truth_(inst_31617)){
var statearr_31658_31717 = state_31640__$1;
(statearr_31658_31717[(1)] = (33));

} else {
var statearr_31659_31718 = state_31640__$1;
(statearr_31659_31718[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (32))){
var inst_31612 = (state_31640[(2)]);
var inst_31613 = fluree.db.util.async.throw_err.call(null,inst_31612);
var state_31640__$1 = state_31640;
var statearr_31660_31719 = state_31640__$1;
(statearr_31660_31719[(2)] = inst_31613);

(statearr_31660_31719[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (33))){
var inst_31616 = (state_31640[(13)]);
var inst_31619 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_31620 = cljs.core.sequential_QMARK_.call(null,inst_31616);
var state_31640__$1 = (function (){var statearr_31661 = state_31640;
(statearr_31661[(14)] = inst_31619);

return statearr_31661;
})();
if(inst_31620){
var statearr_31662_31720 = state_31640__$1;
(statearr_31662_31720[(1)] = (36));

} else {
var statearr_31663_31721 = state_31640__$1;
(statearr_31663_31721[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (13))){
var inst_31541 = (state_31640[(15)]);
var state_31640__$1 = state_31640;
var statearr_31664_31722 = state_31640__$1;
(statearr_31664_31722[(2)] = inst_31541);

(statearr_31664_31722[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (22))){
var inst_31576 = (state_31640[(16)]);
var state_31640__$1 = state_31640;
var statearr_31665_31723 = state_31640__$1;
(statearr_31665_31723[(2)] = inst_31576);

(statearr_31665_31723[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (36))){
var inst_31616 = (state_31640[(13)]);
var inst_31622 = cljs.core.doall.call(null,inst_31616);
var state_31640__$1 = state_31640;
var statearr_31666_31724 = state_31640__$1;
(statearr_31666_31724[(2)] = inst_31622);

(statearr_31666_31724[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (29))){
var inst_31607 = (state_31640[(7)]);
var inst_31610 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_31607);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31640__$1,(32),inst_31610);
} else {
if((state_val_31641 === (6))){
var inst_31541 = (state_31640[(15)]);
var inst_31546 = inst_31541.cljs$lang$protocol_mask$partition0$;
var inst_31547 = (inst_31546 & (64));
var inst_31548 = inst_31541.cljs$core$ISeq$;
var inst_31549 = (cljs.core.PROTOCOL_SENTINEL === inst_31548);
var inst_31550 = ((inst_31547) || (inst_31549));
var state_31640__$1 = state_31640;
if(cljs.core.truth_(inst_31550)){
var statearr_31667_31725 = state_31640__$1;
(statearr_31667_31725[(1)] = (9));

} else {
var statearr_31668_31726 = state_31640__$1;
(statearr_31668_31726[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (28))){
var inst_31596 = (state_31640[(2)]);
var inst_31597 = fluree.db.util.async.throw_err.call(null,inst_31596);
var state_31640__$1 = state_31640;
var statearr_31669_31727 = state_31640__$1;
(statearr_31669_31727[(2)] = inst_31597);

(statearr_31669_31727[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (25))){
var inst_31587 = (state_31640[(11)]);
var inst_31588 = (state_31640[(12)]);
var inst_31594 = fluree.db.query.block.block_range.call(null,db,inst_31587,inst_31588,opts);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31640__$1,(28),inst_31594);
} else {
if((state_val_31641 === (34))){
var inst_31616 = (state_31640[(13)]);
var state_31640__$1 = state_31640;
var statearr_31670_31728 = state_31640__$1;
(statearr_31670_31728[(2)] = inst_31616);

(statearr_31670_31728[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (17))){
var state_31640__$1 = state_31640;
var statearr_31671_31729 = state_31640__$1;
(statearr_31671_31729[(2)] = false);

(statearr_31671_31729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (3))){
var inst_31638 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31640__$1,inst_31638);
} else {
if((state_val_31641 === (12))){
var inst_31541 = (state_31640[(15)]);
var inst_31559 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31541);
var state_31640__$1 = state_31640;
var statearr_31672_31730 = state_31640__$1;
(statearr_31672_31730[(2)] = inst_31559);

(statearr_31672_31730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (2))){
var inst_31541 = (state_31640[(15)]);
var _ = (function (){var statearr_31673 = state_31640;
(statearr_31673[(4)] = cljs.core.cons.call(null,(5),(state_31640[(4)])));

return statearr_31673;
})();
var inst_31540 = fluree.db.util.core.current_time_millis.call(null);
var inst_31541__$1 = db;
var inst_31543 = (inst_31541__$1 == null);
var inst_31544 = cljs.core.not.call(null,inst_31543);
var state_31640__$1 = (function (){var statearr_31674 = state_31640;
(statearr_31674[(17)] = inst_31540);

(statearr_31674[(15)] = inst_31541__$1);

return statearr_31674;
})();
if(inst_31544){
var statearr_31675_31731 = state_31640__$1;
(statearr_31675_31731[(1)] = (6));

} else {
var statearr_31676_31732 = state_31640__$1;
(statearr_31676_31732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (23))){
var inst_31563 = (state_31640[(18)]);
var inst_31564 = (state_31640[(19)]);
var inst_31579 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31563),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31564)].join('');
var state_31640__$1 = state_31640;
var statearr_31677_31733 = state_31640__$1;
(statearr_31677_31733[(2)] = inst_31579);

(statearr_31677_31733[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (35))){
var inst_31635 = (state_31640[(2)]);
var _ = (function (){var statearr_31678 = state_31640;
(statearr_31678[(4)] = cljs.core.rest.call(null,(state_31640[(4)])));

return statearr_31678;
})();
var state_31640__$1 = state_31640;
var statearr_31679_31734 = state_31640__$1;
(statearr_31679_31734[(2)] = inst_31635);

(statearr_31679_31734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (19))){
var inst_31576 = (state_31640[(16)]);
var inst_31568 = (state_31640[(8)]);
var inst_31576__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_31568);
var state_31640__$1 = (function (){var statearr_31680 = state_31640;
(statearr_31680[(16)] = inst_31576__$1);

return statearr_31680;
})();
if(cljs.core.truth_(inst_31576__$1)){
var statearr_31681_31735 = state_31640__$1;
(statearr_31681_31735[(1)] = (22));

} else {
var statearr_31682_31736 = state_31640__$1;
(statearr_31682_31736[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (11))){
var inst_31554 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
var statearr_31684_31737 = state_31640__$1;
(statearr_31684_31737[(2)] = inst_31554);

(statearr_31684_31737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (9))){
var state_31640__$1 = state_31640;
var statearr_31685_31738 = state_31640__$1;
(statearr_31685_31738[(2)] = true);

(statearr_31685_31738[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (5))){
var _ = (function (){var statearr_31686 = state_31640;
(statearr_31686[(4)] = cljs.core.rest.call(null,(state_31640[(4)])));

return statearr_31686;
})();
var state_31640__$1 = state_31640;
var ex31683 = (state_31640__$1[(2)]);
var statearr_31687_31739 = state_31640__$1;
(statearr_31687_31739[(5)] = ex31683);


var statearr_31688_31740 = state_31640__$1;
(statearr_31688_31740[(1)] = (4));

(statearr_31688_31740[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (14))){
var inst_31562 = (state_31640[(20)]);
var inst_31562__$1 = (state_31640[(2)]);
var inst_31563 = cljs.core.get.call(null,inst_31562__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_31564 = cljs.core.get.call(null,inst_31562__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_31565 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_31640__$1 = (function (){var statearr_31689 = state_31640;
(statearr_31689[(18)] = inst_31563);

(statearr_31689[(20)] = inst_31562__$1);

(statearr_31689[(19)] = inst_31564);

return statearr_31689;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31640__$1,(15),inst_31565);
} else {
if((state_val_31641 === (26))){
var inst_31599 = cljs.core.pr_str.call(null,query_map);
var inst_31600 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_31599].join('');
var inst_31601 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31602 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31603 = cljs.core.PersistentHashMap.fromArrays(inst_31601,inst_31602);
var inst_31604 = cljs.core.ex_info.call(null,inst_31600,inst_31603);
var inst_31605 = (function(){throw inst_31604})();
var state_31640__$1 = state_31640;
var statearr_31690_31741 = state_31640__$1;
(statearr_31690_31741[(2)] = inst_31605);

(statearr_31690_31741[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (16))){
var inst_31568 = (state_31640[(8)]);
var inst_31571 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_31568);
var state_31640__$1 = state_31640;
var statearr_31691_31742 = state_31640__$1;
(statearr_31691_31742[(2)] = inst_31571);

(statearr_31691_31742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (38))){
var inst_31540 = (state_31640[(17)]);
var inst_31563 = (state_31640[(18)]);
var inst_31619 = (state_31640[(14)]);
var inst_31586 = (state_31640[(10)]);
var inst_31568 = (state_31640[(8)]);
var inst_31607 = (state_31640[(7)]);
var inst_31587 = (state_31640[(11)]);
var inst_31562 = (state_31640[(20)]);
var inst_31616 = (state_31640[(13)]);
var inst_31588 = (state_31640[(12)]);
var inst_31564 = (state_31640[(19)]);
var inst_31625 = (state_31640[(2)]);
var inst_31626 = (function (){var network = inst_31563;
var block_start = inst_31587;
var block_end = inst_31588;
var range = inst_31568;
var db_id = inst_31564;
var _ = inst_31586;
var start = inst_31540;
var vec__31537 = inst_31568;
var result_SINGLEQUOTE_ = inst_31616;
var result = inst_31607;
var map__31536 = inst_31562;
return (function (p1__31523_SHARP_){
return goog.string.format("%.2fms",p1__31523_SHARP_);
});
})();
var inst_31627 = fluree.db.util.core.current_time_millis.call(null);
var inst_31628 = (inst_31627 - inst_31540);
var inst_31629 = (inst_31628 / (1000000));
var inst_31630 = inst_31626.call(null,inst_31629);
var inst_31631 = [(200),inst_31625,(100),inst_31630];
var inst_31632 = cljs.core.PersistentHashMap.fromArrays(inst_31619,inst_31631);
var state_31640__$1 = state_31640;
var statearr_31692_31743 = state_31640__$1;
(statearr_31692_31743[(2)] = inst_31632);

(statearr_31692_31743[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (30))){
var inst_31607 = (state_31640[(7)]);
var state_31640__$1 = state_31640;
var statearr_31693_31744 = state_31640__$1;
(statearr_31693_31744[(2)] = inst_31607);

(statearr_31693_31744[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (10))){
var state_31640__$1 = state_31640;
var statearr_31694_31745 = state_31640__$1;
(statearr_31694_31745[(2)] = false);

(statearr_31694_31745[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (18))){
var inst_31574 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
if(cljs.core.truth_(inst_31574)){
var statearr_31695_31746 = state_31640__$1;
(statearr_31695_31746[(1)] = (19));

} else {
var statearr_31696_31747 = state_31640__$1;
(statearr_31696_31747[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (37))){
var inst_31616 = (state_31640[(13)]);
var state_31640__$1 = state_31640;
var statearr_31697_31748 = state_31640__$1;
(statearr_31697_31748[(2)] = inst_31616);

(statearr_31697_31748[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31641 === (8))){
var inst_31557 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
if(cljs.core.truth_(inst_31557)){
var statearr_31698_31749 = state_31640__$1;
(statearr_31698_31749[(1)] = (12));

} else {
var statearr_31699_31750 = state_31640__$1;
(statearr_31699_31750[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_31700 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31700[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_31700[(1)] = (1));

return statearr_31700;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_31640){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e31701){var ex__2457__auto__ = e31701;
var statearr_31702_31751 = state_31640;
(statearr_31702_31751[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31640[(4)]))){
var statearr_31703_31752 = state_31640;
(statearr_31703_31752[(1)] = cljs.core.first.call(null,(state_31640[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31753 = state_31640;
state_31640 = G__31753;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_31640){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_31640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_31704 = f__2477__auto__.call(null);
(statearr_31704[(6)] = c__2476__auto__);

return statearr_31704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__31755 = arguments.length;
switch (G__31755) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_31956){
var state_val_31957 = (state_31956[(1)]);
if((state_val_31957 === (7))){
var inst_31773 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31958_32042 = state_31956__$1;
(statearr_31958_32042[(2)] = inst_31773);

(statearr_31958_32042[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (59))){
var inst_31954 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31956__$1,inst_31954);
} else {
if((state_val_31957 === (20))){
var state_31956__$1 = state_31956;
var statearr_31959_32043 = state_31956__$1;
(statearr_31959_32043[(2)] = (-1));

(statearr_31959_32043[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (58))){
var inst_31946 = (state_31956[(7)]);
var state_31956__$1 = state_31956;
var statearr_31960_32044 = state_31956__$1;
(statearr_31960_32044[(2)] = inst_31946);

(statearr_31960_32044[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (27))){
var inst_31783 = (state_31956[(8)]);
var inst_31833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31834 = [inst_31783];
var inst_31835 = (new cljs.core.PersistentVector(null,1,(5),inst_31833,inst_31834,null));
var state_31956__$1 = state_31956;
var statearr_31961_32045 = state_31956__$1;
(statearr_31961_32045[(2)] = inst_31835);

(statearr_31961_32045[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (1))){
var inst_31760 = (state_31956[(9)]);
var inst_31760__$1 = query_map;
var inst_31762 = (inst_31760__$1 == null);
var inst_31763 = cljs.core.not.call(null,inst_31762);
var state_31956__$1 = (function (){var statearr_31962 = state_31956;
(statearr_31962[(9)] = inst_31760__$1);

return statearr_31962;
})();
if(inst_31763){
var statearr_31963_32046 = state_31956__$1;
(statearr_31963_32046[(1)] = (2));

} else {
var statearr_31964_32047 = state_31956__$1;
(statearr_31964_32047[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (24))){
var inst_31787 = (state_31956[(10)]);
var inst_31828 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_31787);
var state_31956__$1 = state_31956;
var statearr_31965_32048 = state_31956__$1;
(statearr_31965_32048[(2)] = inst_31828);

(statearr_31965_32048[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (55))){
var inst_31804 = (state_31956[(11)]);
var inst_31946 = (state_31956[(2)]);
var state_31956__$1 = (function (){var statearr_31966 = state_31956;
(statearr_31966[(7)] = inst_31946);

return statearr_31966;
})();
if(cljs.core.truth_(inst_31804)){
var statearr_31967_32049 = state_31956__$1;
(statearr_31967_32049[(1)] = (57));

} else {
var statearr_31968_32050 = state_31956__$1;
(statearr_31968_32050[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (39))){
var inst_31864 = (state_31956[(12)]);
var inst_31879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31880 = [inst_31864,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_31881 = (new cljs.core.PersistentVector(null,2,(5),inst_31879,inst_31880,null));
var state_31956__$1 = state_31956;
var statearr_31969_32051 = state_31956__$1;
(statearr_31969_32051[(2)] = inst_31881);

(statearr_31969_32051[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (46))){
var state_31956__$1 = state_31956;
var statearr_31970_32052 = state_31956__$1;
(statearr_31970_32052[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (4))){
var inst_31776 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
if(cljs.core.truth_(inst_31776)){
var statearr_31972_32053 = state_31956__$1;
(statearr_31972_32053[(1)] = (8));

} else {
var statearr_31973_32054 = state_31956__$1;
(statearr_31973_32054[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (54))){
var inst_31938 = (state_31956[(13)]);
var state_31956__$1 = state_31956;
var statearr_31974_32055 = state_31956__$1;
(statearr_31974_32055[(2)] = inst_31938);

(statearr_31974_32055[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (15))){
var inst_31791 = (state_31956[(2)]);
var inst_31792 = fluree.db.util.async.throw_err.call(null,inst_31791);
var state_31956__$1 = state_31956;
var statearr_31975_32056 = state_31956__$1;
(statearr_31975_32056[(2)] = inst_31792);

(statearr_31975_32056[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (48))){
var inst_31783 = (state_31956[(8)]);
var inst_31911 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31783)].join('');
var inst_31912 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31913 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31914 = cljs.core.PersistentHashMap.fromArrays(inst_31912,inst_31913);
var inst_31915 = cljs.core.ex_info.call(null,inst_31911,inst_31914);
var inst_31916 = (function(){throw inst_31915})();
var state_31956__$1 = state_31956;
var statearr_31976_32057 = state_31956__$1;
(statearr_31976_32057[(2)] = inst_31916);

(statearr_31976_32057[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (50))){
var inst_31919 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31977_32058 = state_31956__$1;
(statearr_31977_32058[(2)] = inst_31919);

(statearr_31977_32058[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (21))){
var inst_31797 = (state_31956[(14)]);
var inst_31820 = (state_31956[(2)]);
var state_31956__$1 = (function (){var statearr_31978 = state_31956;
(statearr_31978[(15)] = inst_31820);

return statearr_31978;
})();
if(cljs.core.truth_(inst_31797)){
var statearr_31979_32059 = state_31956__$1;
(statearr_31979_32059[(1)] = (23));

} else {
var statearr_31980_32060 = state_31956__$1;
(statearr_31980_32060[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (31))){
var state_31956__$1 = state_31956;
var statearr_31981_32061 = state_31956__$1;
(statearr_31981_32061[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (32))){
var inst_31862 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31983_32062 = state_31956__$1;
(statearr_31983_32062[(2)] = inst_31862);

(statearr_31983_32062[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (40))){
var inst_31873 = (state_31956[(16)]);
var inst_31872 = (state_31956[(17)]);
var inst_31874 = (state_31956[(18)]);
var inst_31883 = (inst_31872 == null);
var inst_31884 = (inst_31873 == null);
var inst_31885 = cljs.core.not.call(null,inst_31884);
var inst_31886 = (inst_31874 == null);
var inst_31887 = ((inst_31883) && (inst_31885) && (inst_31886));
var state_31956__$1 = state_31956;
if(cljs.core.truth_(inst_31887)){
var statearr_31984_32063 = state_31956__$1;
(statearr_31984_32063[(1)] = (42));

} else {
var statearr_31985_32064 = state_31956__$1;
(statearr_31985_32064[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (56))){
var inst_31942 = (state_31956[(2)]);
var inst_31943 = fluree.db.util.async.throw_err.call(null,inst_31942);
var state_31956__$1 = state_31956;
var statearr_31986_32065 = state_31956__$1;
(statearr_31986_32065[(2)] = inst_31943);

(statearr_31986_32065[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (33))){
var inst_31783 = (state_31956[(8)]);
var inst_31841 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31783)].join('');
var inst_31842 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31843 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31844 = cljs.core.PersistentHashMap.fromArrays(inst_31842,inst_31843);
var inst_31845 = cljs.core.ex_info.call(null,inst_31841,inst_31844);
var inst_31846 = (function(){throw inst_31845})();
var state_31956__$1 = state_31956;
var statearr_31987_32066 = state_31956__$1;
(statearr_31987_32066[(2)] = inst_31846);

(statearr_31987_32066[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (13))){
var state_31956__$1 = state_31956;
var statearr_31988_32067 = state_31956__$1;
(statearr_31988_32067[(2)] = null);

(statearr_31988_32067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (22))){
var inst_31814 = (state_31956[(2)]);
var inst_31815 = fluree.db.util.async.throw_err.call(null,inst_31814);
var inst_31816 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_31815);
var inst_31817 = (inst_31816 - (1));
var state_31956__$1 = state_31956;
var statearr_31989_32068 = state_31956__$1;
(statearr_31989_32068[(2)] = inst_31817);

(statearr_31989_32068[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (36))){
var inst_31783 = (state_31956[(8)]);
var inst_31852 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31783)].join('');
var inst_31853 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_31854 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_31855 = cljs.core.PersistentHashMap.fromArrays(inst_31853,inst_31854);
var inst_31856 = cljs.core.ex_info.call(null,inst_31852,inst_31855);
var inst_31857 = (function(){throw inst_31856})();
var state_31956__$1 = state_31956;
var statearr_31990_32069 = state_31956__$1;
(statearr_31990_32069[(2)] = inst_31857);

(statearr_31990_32069[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (41))){
var inst_31820 = (state_31956[(15)]);
var inst_31830 = (state_31956[(19)]);
var inst_31787 = (state_31956[(10)]);
var inst_31925 = (state_31956[(2)]);
var inst_31926 = cljs.core.nth.call(null,inst_31925,(0),null);
var inst_31927 = cljs.core.nth.call(null,inst_31925,(1),null);
var inst_31928 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_31929 = [inst_31820,inst_31830];
var inst_31930 = cljs.core.PersistentHashMap.fromArrays(inst_31928,inst_31929);
var inst_31931 = fluree.db.query.range.time_range.call(null,inst_31787,inst_31927,cljs.core._EQ_,inst_31926,inst_31930);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(51),inst_31931);
} else {
if((state_val_31957 === (43))){
var inst_31873 = (state_31956[(16)]);
var inst_31872 = (state_31956[(17)]);
var inst_31874 = (state_31956[(18)]);
var inst_31896 = (inst_31872 == null);
var inst_31897 = (inst_31873 == null);
var inst_31898 = cljs.core.not.call(null,inst_31897);
var inst_31899 = (inst_31874 == null);
var inst_31900 = cljs.core.not.call(null,inst_31899);
var inst_31901 = ((inst_31896) && (inst_31898) && (inst_31900));
var state_31956__$1 = state_31956;
if(cljs.core.truth_(inst_31901)){
var statearr_31991_32070 = state_31956__$1;
(statearr_31991_32070[(1)] = (45));

} else {
var statearr_31992_32071 = state_31956__$1;
(statearr_31992_32071[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (29))){
var inst_31864 = (state_31956[(12)]);
var inst_31872 = (state_31956[(17)]);
var inst_31864__$1 = (state_31956[(2)]);
var inst_31865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31866 = cljs.core.get.call(null,inst_31864__$1,(0));
var inst_31867 = cljs.core.get.call(null,inst_31864__$1,(1));
var inst_31868 = cljs.core.get.call(null,inst_31864__$1,(2));
var inst_31869 = cljs.core.get.call(null,inst_31864__$1,(3));
var inst_31870 = [inst_31866,inst_31867,inst_31868,inst_31869];
var inst_31871 = (new cljs.core.PersistentVector(null,4,(5),inst_31865,inst_31870,null));
var inst_31872__$1 = cljs.core.nth.call(null,inst_31871,(0),null);
var inst_31873 = cljs.core.nth.call(null,inst_31871,(1),null);
var inst_31874 = cljs.core.nth.call(null,inst_31871,(2),null);
var inst_31875 = cljs.core.nth.call(null,inst_31871,(3),null);
var inst_31876 = (inst_31872__$1 == null);
var inst_31877 = cljs.core.not.call(null,inst_31876);
var state_31956__$1 = (function (){var statearr_31993 = state_31956;
(statearr_31993[(12)] = inst_31864__$1);

(statearr_31993[(20)] = inst_31875);

(statearr_31993[(16)] = inst_31873);

(statearr_31993[(17)] = inst_31872__$1);

(statearr_31993[(18)] = inst_31874);

return statearr_31993;
})();
if(inst_31877){
var statearr_31994_32072 = state_31956__$1;
(statearr_31994_32072[(1)] = (39));

} else {
var statearr_31995_32073 = state_31956__$1;
(statearr_31995_32073[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (44))){
var inst_31923 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31996_32074 = state_31956__$1;
(statearr_31996_32074[(2)] = inst_31923);

(statearr_31996_32074[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (6))){
var state_31956__$1 = state_31956;
var statearr_31997_32075 = state_31956__$1;
(statearr_31997_32075[(2)] = false);

(statearr_31997_32075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (28))){
var inst_31783 = (state_31956[(8)]);
var inst_31837 = cljs.core.sequential_QMARK_.call(null,inst_31783);
var state_31956__$1 = state_31956;
if(inst_31837){
var statearr_31998_32076 = state_31956__$1;
(statearr_31998_32076[(1)] = (30));

} else {
var statearr_31999_32077 = state_31956__$1;
(statearr_31999_32077[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (51))){
var inst_31934 = (state_31956[(21)]);
var inst_31787 = (state_31956[(10)]);
var inst_31933 = (state_31956[(2)]);
var inst_31934__$1 = fluree.db.util.async.throw_err.call(null,inst_31933);
var inst_31935 = fluree.db.api_js.format_history_resp.call(null,inst_31787,inst_31934__$1);
var state_31956__$1 = (function (){var statearr_32000 = state_31956;
(statearr_32000[(21)] = inst_31934__$1);

return statearr_32000;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(52),inst_31935);
} else {
if((state_val_31957 === (25))){
var inst_31783 = (state_31956[(8)]);
var inst_31830 = (state_31956[(2)]);
var inst_31831 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_31783);
var state_31956__$1 = (function (){var statearr_32001 = state_31956;
(statearr_32001[(19)] = inst_31830);

return statearr_32001;
})();
if(inst_31831){
var statearr_32002_32078 = state_31956__$1;
(statearr_32002_32078[(1)] = (27));

} else {
var statearr_32003_32079 = state_31956__$1;
(statearr_32003_32079[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (34))){
var inst_31783 = (state_31956[(8)]);
var state_31956__$1 = state_31956;
var statearr_32004_32080 = state_31956__$1;
(statearr_32004_32080[(2)] = inst_31783);

(statearr_32004_32080[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (17))){
var inst_31796 = (state_31956[(22)]);
var state_31956__$1 = state_31956;
var statearr_32005_32081 = state_31956__$1;
(statearr_32005_32081[(2)] = inst_31796);

(statearr_32005_32081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (3))){
var state_31956__$1 = state_31956;
var statearr_32006_32082 = state_31956__$1;
(statearr_32006_32082[(2)] = false);

(statearr_32006_32082[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (12))){
var inst_31787 = (state_31956[(10)]);
var inst_31789 = fluree.db.api_js.resolve_block_range.call(null,inst_31787,query_map);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(15),inst_31789);
} else {
if((state_val_31957 === (2))){
var inst_31760 = (state_31956[(9)]);
var inst_31765 = inst_31760.cljs$lang$protocol_mask$partition0$;
var inst_31766 = (inst_31765 & (64));
var inst_31767 = inst_31760.cljs$core$ISeq$;
var inst_31768 = (cljs.core.PROTOCOL_SENTINEL === inst_31767);
var inst_31769 = ((inst_31766) || (inst_31768));
var state_31956__$1 = state_31956;
if(cljs.core.truth_(inst_31769)){
var statearr_32007_32083 = state_31956__$1;
(statearr_32007_32083[(1)] = (5));

} else {
var statearr_32008_32084 = state_31956__$1;
(statearr_32008_32084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (23))){
var inst_31797 = (state_31956[(14)]);
var inst_31787 = (state_31956[(10)]);
var inst_31822 = fluree.db.time_travel.as_of_block.call(null,inst_31787,inst_31797);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(26),inst_31822);
} else {
if((state_val_31957 === (47))){
var inst_31921 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_32009_32085 = state_31956__$1;
(statearr_32009_32085[(2)] = inst_31921);

(statearr_32009_32085[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (35))){
var inst_31849 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_32010_32086 = state_31956__$1;
(statearr_32010_32086[(2)] = inst_31849);

(statearr_32010_32086[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (19))){
var inst_31796 = (state_31956[(22)]);
var inst_31787 = (state_31956[(10)]);
var inst_31811 = (inst_31796 - (1));
var inst_31812 = fluree.db.time_travel.as_of_block.call(null,inst_31787,inst_31811);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(22),inst_31812);
} else {
if((state_val_31957 === (57))){
var inst_31934 = (state_31956[(21)]);
var inst_31946 = (state_31956[(7)]);
var inst_31948 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_31949 = cljs.core.count.call(null,inst_31934);
var inst_31950 = [inst_31946,inst_31949,(200)];
var inst_31951 = cljs.core.PersistentHashMap.fromArrays(inst_31948,inst_31950);
var state_31956__$1 = state_31956;
var statearr_32011_32087 = state_31956__$1;
(statearr_32011_32087[(2)] = inst_31951);

(statearr_32011_32087[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (11))){
var inst_31782 = (state_31956[(23)]);
var inst_31786 = (state_31956[(2)]);
var inst_31787 = fluree.db.util.async.throw_err.call(null,inst_31786);
var state_31956__$1 = (function (){var statearr_32012 = state_31956;
(statearr_32012[(10)] = inst_31787);

return statearr_32012;
})();
if(cljs.core.truth_(inst_31782)){
var statearr_32013_32088 = state_31956__$1;
(statearr_32013_32088[(1)] = (12));

} else {
var statearr_32014_32089 = state_31956__$1;
(statearr_32014_32089[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (9))){
var inst_31760 = (state_31956[(9)]);
var state_31956__$1 = state_31956;
var statearr_32015_32090 = state_31956__$1;
(statearr_32015_32090[(2)] = inst_31760);

(statearr_32015_32090[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (5))){
var state_31956__$1 = state_31956;
var statearr_32016_32091 = state_31956__$1;
(statearr_32016_32091[(2)] = true);

(statearr_32016_32091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (14))){
var inst_31796 = (state_31956[(22)]);
var inst_31795 = (state_31956[(2)]);
var inst_31796__$1 = cljs.core.nth.call(null,inst_31795,(0),null);
var inst_31797 = cljs.core.nth.call(null,inst_31795,(1),null);
var inst_31804 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_31956__$1 = (function (){var statearr_32017 = state_31956;
(statearr_32017[(14)] = inst_31797);

(statearr_32017[(11)] = inst_31804);

(statearr_32017[(22)] = inst_31796__$1);

return statearr_32017;
})();
if(cljs.core.truth_(inst_31796__$1)){
var statearr_32018_32092 = state_31956__$1;
(statearr_32018_32092[(1)] = (16));

} else {
var statearr_32019_32093 = state_31956__$1;
(statearr_32019_32093[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (45))){
var inst_31875 = (state_31956[(20)]);
var inst_31873 = (state_31956[(16)]);
var inst_31872 = (state_31956[(17)]);
var inst_31874 = (state_31956[(18)]);
var inst_31903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31905 = [inst_31873,inst_31874,inst_31872,inst_31875];
var inst_31906 = (new cljs.core.PersistentVector(null,4,(5),inst_31904,inst_31905,null));
var inst_31907 = [inst_31906,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_31908 = (new cljs.core.PersistentVector(null,2,(5),inst_31903,inst_31907,null));
var state_31956__$1 = state_31956;
var statearr_32020_32094 = state_31956__$1;
(statearr_32020_32094[(2)] = inst_31908);

(statearr_32020_32094[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (53))){
var inst_31938 = (state_31956[(13)]);
var inst_31787 = (state_31956[(10)]);
var inst_31940 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_31787,inst_31938);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(56),inst_31940);
} else {
if((state_val_31957 === (26))){
var inst_31824 = (state_31956[(2)]);
var inst_31825 = fluree.db.util.async.throw_err.call(null,inst_31824);
var inst_31826 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_31825);
var state_31956__$1 = state_31956;
var statearr_32021_32095 = state_31956__$1;
(statearr_32021_32095[(2)] = inst_31826);

(statearr_32021_32095[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (16))){
var inst_31796 = (state_31956[(22)]);
var inst_31806 = cljs.core.not_EQ_.call(null,(1),inst_31796);
var state_31956__$1 = state_31956;
var statearr_32022_32096 = state_31956__$1;
(statearr_32022_32096[(2)] = inst_31806);

(statearr_32022_32096[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (38))){
var inst_31860 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_32023_32097 = state_31956__$1;
(statearr_32023_32097[(2)] = inst_31860);

(statearr_32023_32097[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (30))){
var inst_31783 = (state_31956[(8)]);
var inst_31839 = cljs.core.empty_QMARK_.call(null,inst_31783);
var state_31956__$1 = state_31956;
if(inst_31839){
var statearr_32024_32098 = state_31956__$1;
(statearr_32024_32098[(1)] = (33));

} else {
var statearr_32025_32099 = state_31956__$1;
(statearr_32025_32099[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (10))){
var inst_31781 = (state_31956[(2)]);
var inst_31782 = cljs.core.get.call(null,inst_31781,new cljs.core.Keyword(null,"block","block",664686210));
var inst_31783 = cljs.core.get.call(null,inst_31781,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_31784 = cljs.core.get.call(null,inst_31781,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_31956__$1 = (function (){var statearr_32026 = state_31956;
(statearr_32026[(23)] = inst_31782);

(statearr_32026[(24)] = inst_31784);

(statearr_32026[(8)] = inst_31783);

return statearr_32026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31956__$1,(11),sources);
} else {
if((state_val_31957 === (18))){
var inst_31809 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
if(cljs.core.truth_(inst_31809)){
var statearr_32027_32100 = state_31956__$1;
(statearr_32027_32100[(1)] = (19));

} else {
var statearr_32028_32101 = state_31956__$1;
(statearr_32028_32101[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (52))){
var inst_31784 = (state_31956[(24)]);
var inst_31937 = (state_31956[(2)]);
var inst_31938 = fluree.db.util.async.throw_err.call(null,inst_31937);
var state_31956__$1 = (function (){var statearr_32029 = state_31956;
(statearr_32029[(13)] = inst_31938);

return statearr_32029;
})();
if(cljs.core.truth_(inst_31784)){
var statearr_32030_32102 = state_31956__$1;
(statearr_32030_32102[(1)] = (53));

} else {
var statearr_32031_32103 = state_31956__$1;
(statearr_32031_32103[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (42))){
var inst_31875 = (state_31956[(20)]);
var inst_31873 = (state_31956[(16)]);
var inst_31872 = (state_31956[(17)]);
var inst_31874 = (state_31956[(18)]);
var inst_31889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31891 = [inst_31873,inst_31872,inst_31874,inst_31875];
var inst_31892 = (new cljs.core.PersistentVector(null,4,(5),inst_31890,inst_31891,null));
var inst_31893 = [inst_31892,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_31894 = (new cljs.core.PersistentVector(null,2,(5),inst_31889,inst_31893,null));
var state_31956__$1 = state_31956;
var statearr_32032_32104 = state_31956__$1;
(statearr_32032_32104[(2)] = inst_31894);

(statearr_32032_32104[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (37))){
var state_31956__$1 = state_31956;
var statearr_32033_32105 = state_31956__$1;
(statearr_32033_32105[(2)] = null);

(statearr_32033_32105[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (8))){
var inst_31760 = (state_31956[(9)]);
var inst_31778 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31760);
var state_31956__$1 = state_31956;
var statearr_32034_32106 = state_31956__$1;
(statearr_32034_32106[(2)] = inst_31778);

(statearr_32034_32106[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31957 === (49))){
var state_31956__$1 = state_31956;
var statearr_32035_32107 = state_31956__$1;
(statearr_32035_32107[(2)] = null);

(statearr_32035_32107[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_32036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32036[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_32036[(1)] = (1));

return statearr_32036;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_31956){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_31956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e32037){var ex__2457__auto__ = e32037;
var statearr_32038_32108 = state_31956;
(statearr_32038_32108[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_31956[(4)]))){
var statearr_32039_32109 = state_31956;
(statearr_32039_32109[(1)] = cljs.core.first.call(null,(state_31956[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32110 = state_31956;
state_31956 = G__32110;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_31956){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_31956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_32040 = f__2477__auto__.call(null);
(statearr_32040[(6)] = c__2476__auto__);

return statearr_32040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__32118 = arguments.length;
switch (G__32118) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__32111_SHARP_){
return cljs.core.dissoc.call(null,p1__32111_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_32207){
var state_val_32208 = (state_32207[(1)]);
if((state_val_32208 === (7))){
var inst_32164 = (state_32207[(7)]);
var inst_32161 = (state_32207[(8)]);
var inst_32158 = (state_32207[(9)]);
var inst_32168 = (state_32207[(10)]);
var inst_32174 = (function (){var responses = inst_32158;
var responses_STAR_ = inst_32161;
var statuses = inst_32164;
var fuel = inst_32168;
return (function (p1__32114_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__32114_SHARP_);
});
})();
var inst_32175 = cljs.core.some.call(null,inst_32174,inst_32164);
var state_32207__$1 = state_32207;
if(cljs.core.truth_(inst_32175)){
var statearr_32209_32257 = state_32207__$1;
(statearr_32209_32257[(1)] = (9));

} else {
var statearr_32210_32258 = state_32207__$1;
(statearr_32210_32258[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (20))){
var inst_32202 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
var statearr_32211_32259 = state_32207__$1;
(statearr_32211_32259[(2)] = inst_32202);

(statearr_32211_32259[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (1))){
var inst_32153 = cljs.core.async.chan.call(null,(1));
var inst_32154 = (function (){var c__2476__auto____$1 = inst_32153;
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_32151){
var state_val_32152 = (state_32151[(1)]);
if((state_val_32152 === (1))){
var inst_32119 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_32120 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_32121 = cljs.core.assoc.call(null,inst_32120,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_32122 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_32123 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_32124 = cljs.core.PersistentHashMap.EMPTY;
var inst_32125 = inst_32119;
var inst_32126 = inst_32121;
var inst_32127 = inst_32122;
var inst_32128 = inst_32123;
var inst_32129 = inst_32124;
var state_32151__$1 = (function (){var statearr_32212 = state_32151;
(statearr_32212[(7)] = inst_32127);

(statearr_32212[(8)] = inst_32126);

(statearr_32212[(9)] = inst_32129);

(statearr_32212[(10)] = inst_32128);

(statearr_32212[(11)] = inst_32125);

return statearr_32212;
})();
var statearr_32213_32260 = state_32151__$1;
(statearr_32213_32260[(2)] = null);

(statearr_32213_32260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (2))){
var inst_32126 = (state_32151[(8)]);
var inst_32131 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_32126);
var inst_32132 = cljs.core.merge.call(null,opts,inst_32131);
var inst_32133 = cljs.core.assoc.call(null,inst_32126,new cljs.core.Keyword(null,"opts","opts",155075701),inst_32132);
var inst_32134 = fluree.db.api_js.query_async.call(null,db,inst_32133,db_fn);
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32151__$1,(4),inst_32134);
} else {
if((state_val_32152 === (3))){
var inst_32149 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32151__$1,inst_32149);
} else {
if((state_val_32152 === (4))){
var inst_32127 = (state_32151[(7)]);
var inst_32129 = (state_32151[(9)]);
var inst_32125 = (state_32151[(11)]);
var inst_32136 = (state_32151[(2)]);
var inst_32137 = cljs.core.assoc.call(null,inst_32129,inst_32125,inst_32136);
var inst_32138 = cljs.core.first.call(null,inst_32127);
var state_32151__$1 = (function (){var statearr_32214 = state_32151;
(statearr_32214[(12)] = inst_32137);

return statearr_32214;
})();
if(cljs.core.truth_(inst_32138)){
var statearr_32215_32261 = state_32151__$1;
(statearr_32215_32261[(1)] = (5));

} else {
var statearr_32216_32262 = state_32151__$1;
(statearr_32216_32262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (5))){
var inst_32127 = (state_32151[(7)]);
var inst_32137 = (state_32151[(12)]);
var inst_32128 = (state_32151[(10)]);
var inst_32140 = cljs.core.first.call(null,inst_32127);
var inst_32141 = cljs.core.first.call(null,inst_32128);
var inst_32142 = cljs.core.rest.call(null,inst_32127);
var inst_32143 = cljs.core.rest.call(null,inst_32128);
var inst_32125 = inst_32140;
var inst_32126 = inst_32141;
var inst_32127__$1 = inst_32142;
var inst_32128__$1 = inst_32143;
var inst_32129 = inst_32137;
var state_32151__$1 = (function (){var statearr_32217 = state_32151;
(statearr_32217[(7)] = inst_32127__$1);

(statearr_32217[(8)] = inst_32126);

(statearr_32217[(9)] = inst_32129);

(statearr_32217[(10)] = inst_32128__$1);

(statearr_32217[(11)] = inst_32125);

return statearr_32217;
})();
var statearr_32218_32263 = state_32151__$1;
(statearr_32218_32263[(2)] = null);

(statearr_32218_32263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (6))){
var inst_32137 = (state_32151[(12)]);
var state_32151__$1 = state_32151;
var statearr_32219_32264 = state_32151__$1;
(statearr_32219_32264[(2)] = inst_32137);

(statearr_32219_32264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (7))){
var inst_32147 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32220_32265 = state_32151__$1;
(statearr_32220_32265[(2)] = inst_32147);

(statearr_32220_32265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_32221 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32221[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_32221[(1)] = (1));

return statearr_32221;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_32151){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_32151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e32222){var ex__2457__auto__ = e32222;
var statearr_32223_32266 = state_32151;
(statearr_32223_32266[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_32151[(4)]))){
var statearr_32224_32267 = state_32151;
(statearr_32224_32267[(1)] = cljs.core.first.call(null,(state_32151[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32268 = state_32151;
state_32151 = G__32268;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_32151){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_32151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_32225 = f__2477__auto__.call(null);
(statearr_32225[(6)] = c__2476__auto____$1);

return statearr_32225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});
})();
var inst_32155 = cljs.core.async.impl.dispatch.run.call(null,inst_32154);
var state_32207__$1 = (function (){var statearr_32226 = state_32207;
(statearr_32226[(11)] = inst_32155);

return statearr_32226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32207__$1,(2),inst_32153);
} else {
if((state_val_32208 === (4))){
var inst_32158 = (state_32207[(9)]);
var state_32207__$1 = state_32207;
var statearr_32227_32269 = state_32207__$1;
(statearr_32227_32269[(2)] = inst_32158);

(statearr_32227_32269[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (15))){
var state_32207__$1 = state_32207;
var statearr_32228_32270 = state_32207__$1;
(statearr_32228_32270[(2)] = (400));

(statearr_32228_32270[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (13))){
var state_32207__$1 = state_32207;
var statearr_32229_32271 = state_32207__$1;
(statearr_32229_32271[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (6))){
var inst_32164 = (state_32207[(7)]);
var inst_32172 = cljs.core.first.call(null,inst_32164);
var state_32207__$1 = state_32207;
var statearr_32231_32272 = state_32207__$1;
(statearr_32231_32272[(2)] = inst_32172);

(statearr_32231_32272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (17))){
var inst_32185 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
var statearr_32232_32273 = state_32207__$1;
(statearr_32232_32273[(2)] = inst_32185);

(statearr_32232_32273[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (3))){
var inst_32164 = (state_32207[(7)]);
var inst_32161 = (state_32207[(8)]);
var inst_32158 = (state_32207[(9)]);
var inst_32168 = (state_32207[(10)]);
var inst_32163 = cljs.core.vals.call(null,inst_32158);
var inst_32164__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_32163);
var inst_32165 = (function (){var responses = inst_32158;
var responses_STAR_ = inst_32161;
var statuses = inst_32164__$1;
return (function (p1__32112_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__32112_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_32166 = cljs.core.vals.call(null,inst_32158);
var inst_32167 = cljs.core.map.call(null,inst_32165,inst_32166);
var inst_32168__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_32167);
var inst_32169 = (function (){var responses = inst_32158;
var responses_STAR_ = inst_32161;
var statuses = inst_32164__$1;
var fuel = inst_32168__$1;
return (function (p1__32113_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__32113_SHARP_);
});
})();
var inst_32170 = cljs.core.every_QMARK_.call(null,inst_32169,inst_32164__$1);
var state_32207__$1 = (function (){var statearr_32233 = state_32207;
(statearr_32233[(7)] = inst_32164__$1);

(statearr_32233[(10)] = inst_32168__$1);

return statearr_32233;
})();
if(inst_32170){
var statearr_32234_32274 = state_32207__$1;
(statearr_32234_32274[(1)] = (6));

} else {
var statearr_32235_32275 = state_32207__$1;
(statearr_32235_32275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (12))){
var state_32207__$1 = state_32207;
var statearr_32236_32276 = state_32207__$1;
(statearr_32236_32276[(2)] = (500));

(statearr_32236_32276[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (2))){
var inst_32158 = (state_32207[(9)]);
var inst_32157 = (state_32207[(2)]);
var inst_32158__$1 = fluree.db.util.async.throw_err.call(null,inst_32157);
var inst_32159 = (function (){var responses = inst_32158__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_32160 = cljs.core.PersistentHashMap.EMPTY;
var inst_32161 = cljs.core.reduce_kv.call(null,inst_32159,inst_32160,inst_32158__$1);
var state_32207__$1 = (function (){var statearr_32237 = state_32207;
(statearr_32237[(8)] = inst_32161);

(statearr_32237[(9)] = inst_32158__$1);

return statearr_32237;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_32238_32277 = state_32207__$1;
(statearr_32238_32277[(1)] = (3));

} else {
var statearr_32239_32278 = state_32207__$1;
(statearr_32239_32278[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (19))){
var inst_32191 = (state_32207[(12)]);
var inst_32161 = (state_32207[(8)]);
var inst_32168 = (state_32207[(10)]);
var inst_32200 = cljs.core.assoc.call(null,inst_32161,new cljs.core.Keyword(null,"status","status",-1997798413),inst_32191,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_32168);
var state_32207__$1 = state_32207;
var statearr_32240_32279 = state_32207__$1;
(statearr_32240_32279[(2)] = inst_32200);

(statearr_32240_32279[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (11))){
var inst_32189 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
var statearr_32241_32280 = state_32207__$1;
(statearr_32241_32280[(2)] = inst_32189);

(statearr_32241_32280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (9))){
var state_32207__$1 = state_32207;
var statearr_32242_32281 = state_32207__$1;
(statearr_32242_32281[(2)] = (207));

(statearr_32242_32281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (5))){
var inst_32205 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32207__$1,inst_32205);
} else {
if((state_val_32208 === (14))){
var inst_32187 = (state_32207[(2)]);
var state_32207__$1 = state_32207;
var statearr_32243_32282 = state_32207__$1;
(statearr_32243_32282[(2)] = inst_32187);

(statearr_32243_32282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (16))){
var state_32207__$1 = state_32207;
var statearr_32244_32283 = state_32207__$1;
(statearr_32244_32283[(2)] = null);

(statearr_32244_32283[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (10))){
var inst_32164 = (state_32207[(7)]);
var inst_32161 = (state_32207[(8)]);
var inst_32158 = (state_32207[(9)]);
var inst_32168 = (state_32207[(10)]);
var inst_32178 = (function (){var responses = inst_32158;
var responses_STAR_ = inst_32161;
var statuses = inst_32164;
var fuel = inst_32168;
return (function (p1__32115_SHARP_){
return ((499) < p1__32115_SHARP_);
});
})();
var inst_32179 = cljs.core.some.call(null,inst_32178,inst_32164);
var state_32207__$1 = state_32207;
if(cljs.core.truth_(inst_32179)){
var statearr_32245_32284 = state_32207__$1;
(statearr_32245_32284[(1)] = (12));

} else {
var statearr_32246_32285 = state_32207__$1;
(statearr_32246_32285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (18))){
var inst_32191 = (state_32207[(12)]);
var inst_32196 = (state_32207[(13)]);
var inst_32161 = (state_32207[(8)]);
var inst_32168 = (state_32207[(10)]);
var inst_32198 = cljs.core.assoc.call(null,inst_32161,new cljs.core.Keyword(null,"status","status",-1997798413),inst_32191,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_32168,new cljs.core.Keyword(null,"block","block",664686210),inst_32196);
var state_32207__$1 = state_32207;
var statearr_32247_32286 = state_32207__$1;
(statearr_32247_32286[(2)] = inst_32198);

(statearr_32247_32286[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32208 === (8))){
var inst_32191 = (state_32207[(12)]);
var inst_32164 = (state_32207[(7)]);
var inst_32196 = (state_32207[(13)]);
var inst_32161 = (state_32207[(8)]);
var inst_32158 = (state_32207[(9)]);
var inst_32168 = (state_32207[(10)]);
var inst_32191__$1 = (state_32207[(2)]);
var inst_32192 = (function (){var responses = inst_32158;
var responses_STAR_ = inst_32161;
var statuses = inst_32164;
var fuel = inst_32168;
var status = inst_32191__$1;
return (function (p1__32116_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__32116_SHARP_));
});
})();
var inst_32193 = cljs.core.vals.call(null,inst_32158);
var inst_32194 = cljs.core.filter.call(null,inst_32192,inst_32193);
var inst_32195 = cljs.core.first.call(null,inst_32194);
var inst_32196__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_32195);
var state_32207__$1 = (function (){var statearr_32248 = state_32207;
(statearr_32248[(12)] = inst_32191__$1);

(statearr_32248[(13)] = inst_32196__$1);

return statearr_32248;
})();
if(cljs.core.truth_(inst_32196__$1)){
var statearr_32249_32287 = state_32207__$1;
(statearr_32249_32287[(1)] = (18));

} else {
var statearr_32250_32288 = state_32207__$1;
(statearr_32250_32288[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_32251 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32251[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_32251[(1)] = (1));

return statearr_32251;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_32207){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_32207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e32252){var ex__2457__auto__ = e32252;
var statearr_32253_32289 = state_32207;
(statearr_32253_32289[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_32207[(4)]))){
var statearr_32254_32290 = state_32207;
(statearr_32254_32290[(1)] = cljs.core.first.call(null,(state_32207[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32291 = state_32207;
state_32207 = G__32291;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_32207){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_32207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_32255 = f__2477__auto__.call(null);
(statearr_32255[(6)] = c__2476__auto__);

return statearr_32255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__32293 = arguments.length;
switch (G__32293) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__32294 = opts;
var map__32294__$1 = (((((!((map__32294 == null))))?(((((map__32294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32294):map__32294);
var auth = cljs.core.get.call(null,map__32294__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__32294__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__32294__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__32294__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__32295 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__32295,(0),null);
var authority = cljs.core.nth.call(null,vec__32295,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e32299){var e = e32299;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__32302 = arguments.length;
switch (G__32302) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_32333){
var state_val_32334 = (state_32333[(1)]);
if((state_val_32334 === (7))){
var state_32333__$1 = state_32333;
var statearr_32335_32356 = state_32333__$1;
(statearr_32335_32356[(2)] = opts);

(statearr_32335_32356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (1))){
var state_32333__$1 = state_32333;
var statearr_32336_32357 = state_32333__$1;
(statearr_32336_32357[(2)] = null);

(statearr_32336_32357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (4))){
var inst_32303 = (state_32333[(2)]);
var inst_32304 = fluree.db.util.log.error.call(null,inst_32303);
var inst_32305 = cljs.core.ex_data.call(null,inst_32303);
var inst_32306 = cljs.core.ex_message.call(null,inst_32303);
var inst_32307 = cljs.core.assoc.call(null,inst_32305,new cljs.core.Keyword(null,"message","message",-406056002),inst_32306);
var state_32333__$1 = (function (){var statearr_32337 = state_32333;
(statearr_32337[(7)] = inst_32304);

return statearr_32337;
})();
var statearr_32338_32358 = state_32333__$1;
(statearr_32338_32358[(2)] = inst_32307);

(statearr_32338_32358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (6))){
var inst_32317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32318 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_32319 = (new cljs.core.PersistentVector(null,1,(5),inst_32317,inst_32318,null));
var inst_32320 = cljs.core.assoc_in.call(null,opts,inst_32319,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_32333__$1 = state_32333;
var statearr_32339_32359 = state_32333__$1;
(statearr_32339_32359[(2)] = inst_32320);

(statearr_32339_32359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (3))){
var inst_32331 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32333__$1,inst_32331);
} else {
if((state_val_32334 === (2))){
var _ = (function (){var statearr_32341 = state_32333;
(statearr_32341[(4)] = cljs.core.cons.call(null,(5),(state_32333[(4)])));

return statearr_32341;
})();
var inst_32313 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_32314 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_32315 = (inst_32314 == null);
var state_32333__$1 = (function (){var statearr_32342 = state_32333;
(statearr_32342[(8)] = inst_32313);

return statearr_32342;
})();
if(cljs.core.truth_(inst_32315)){
var statearr_32343_32360 = state_32333__$1;
(statearr_32343_32360[(1)] = (6));

} else {
var statearr_32344_32361 = state_32333__$1;
(statearr_32344_32361[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (9))){
var inst_32327 = (state_32333[(2)]);
var inst_32328 = fluree.db.util.async.throw_err.call(null,inst_32327);
var _ = (function (){var statearr_32345 = state_32333;
(statearr_32345[(4)] = cljs.core.rest.call(null,(state_32333[(4)])));

return statearr_32345;
})();
var state_32333__$1 = state_32333;
var statearr_32346_32362 = state_32333__$1;
(statearr_32346_32362[(2)] = inst_32328);

(statearr_32346_32362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (5))){
var _ = (function (){var statearr_32347 = state_32333;
(statearr_32347[(4)] = cljs.core.rest.call(null,(state_32333[(4)])));

return statearr_32347;
})();
var state_32333__$1 = state_32333;
var ex32340 = (state_32333__$1[(2)]);
var statearr_32348_32363 = state_32333__$1;
(statearr_32348_32363[(5)] = ex32340);


var statearr_32349_32364 = state_32333__$1;
(statearr_32349_32364[(1)] = (4));

(statearr_32349_32364[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (8))){
var inst_32313 = (state_32333[(8)]);
var inst_32323 = (state_32333[(2)]);
var inst_32324 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_32313,inst_32323);
var inst_32325 = fluree.db.operations.command_async.call(null,conn,inst_32324);
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32333__$1,(9),inst_32325);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2454__auto__ = null;
var fluree$db$api_js$state_machine__2454__auto____0 = (function (){
var statearr_32350 = [null,null,null,null,null,null,null,null,null];
(statearr_32350[(0)] = fluree$db$api_js$state_machine__2454__auto__);

(statearr_32350[(1)] = (1));

return statearr_32350;
});
var fluree$db$api_js$state_machine__2454__auto____1 = (function (state_32333){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_32333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e32351){var ex__2457__auto__ = e32351;
var statearr_32352_32365 = state_32333;
(statearr_32352_32365[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_32333[(4)]))){
var statearr_32353_32366 = state_32333;
(statearr_32353_32366[(1)] = cljs.core.first.call(null,(state_32333[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32367 = state_32333;
state_32333 = G__32367;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2454__auto__ = function(state_32333){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2454__auto____1.call(this,state_32333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2454__auto____0;
fluree$db$api_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2454__auto____1;
return fluree$db$api_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_32354 = f__2477__auto__.call(null);
(statearr_32354[(6)] = c__2476__auto__);

return statearr_32354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

