// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 * 
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
if(fluree.db.connection_js.dbaas_QMARK_.call(null,conn)){
return true;
} else {
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
}
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__29559 = arguments.length;
switch (G__29559) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29601){
var state_val_29602 = (state_29601[(1)]);
if((state_val_29602 === (7))){
var inst_29571 = typeof user === 'string';
var state_29601__$1 = state_29601;
if(cljs.core.truth_(inst_29571)){
var statearr_29603_29632 = state_29601__$1;
(statearr_29603_29632[(1)] = (9));

} else {
var statearr_29604_29633 = state_29601__$1;
(statearr_29604_29633[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (1))){
var state_29601__$1 = state_29601;
var statearr_29605_29634 = state_29601__$1;
(statearr_29605_29634[(2)] = null);

(statearr_29605_29634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (4))){
var inst_29560 = (state_29601[(2)]);
var inst_29561 = fluree.db.util.log.error.call(null,inst_29560);
var inst_29562 = reject.call(null,inst_29560);
var state_29601__$1 = (function (){var statearr_29606 = state_29601;
(statearr_29606[(7)] = inst_29561);

return statearr_29606;
})();
var statearr_29607_29635 = state_29601__$1;
(statearr_29607_29635[(2)] = inst_29562);

(statearr_29607_29635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (15))){
var inst_29590 = (state_29601[(2)]);
var inst_29591 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_29590);
var inst_29592 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29593 = cljs.core.constantly.call(null,inst_29591);
var inst_29594 = cljs.core.swap_BANG_.call(null,inst_29592,inst_29593);
var inst_29595 = fluree.db.connection.add_token.call(null,conn,inst_29591);
var inst_29596 = resolve.call(null,inst_29590);
var _ = (function (){var statearr_29608 = state_29601;
(statearr_29608[(4)] = cljs.core.rest.call(null,(state_29601[(4)])));

return statearr_29608;
})();
var state_29601__$1 = (function (){var statearr_29609 = state_29601;
(statearr_29609[(8)] = inst_29594);

(statearr_29609[(9)] = inst_29595);

return statearr_29609;
})();
var statearr_29610_29636 = state_29601__$1;
(statearr_29610_29636[(2)] = inst_29596);

(statearr_29610_29636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (13))){
var state_29601__$1 = state_29601;
var statearr_29611_29637 = state_29601__$1;
(statearr_29611_29637[(2)] = null);

(statearr_29611_29637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (6))){
var state_29601__$1 = state_29601;
var statearr_29612_29638 = state_29601__$1;
(statearr_29612_29638[(2)] = user);

(statearr_29612_29638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (3))){
var inst_29599 = (state_29601[(2)]);
var state_29601__$1 = state_29601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29601__$1,inst_29599);
} else {
if((state_val_29602 === (12))){
var state_29601__$1 = state_29601;
var statearr_29613_29639 = state_29601__$1;
(statearr_29613_29639[(2)] = user);

(statearr_29613_29639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (2))){
var _ = (function (){var statearr_29614 = state_29601;
(statearr_29614[(4)] = cljs.core.cons.call(null,(5),(state_29601[(4)])));

return statearr_29614;
})();
var inst_29568 = typeof user === 'number';
var state_29601__$1 = state_29601;
if(cljs.core.truth_(inst_29568)){
var statearr_29615_29640 = state_29601__$1;
(statearr_29615_29640[(1)] = (6));

} else {
var statearr_29616_29641 = state_29601__$1;
(statearr_29616_29641[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (11))){
var inst_29582 = (state_29601[(2)]);
var state_29601__$1 = state_29601;
var statearr_29618_29642 = state_29601__$1;
(statearr_29618_29642[(2)] = inst_29582);

(statearr_29618_29642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (9))){
var inst_29573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29574 = ["_user/username",user];
var inst_29575 = (new cljs.core.PersistentVector(null,2,(5),inst_29573,inst_29574,null));
var state_29601__$1 = state_29601;
var statearr_29619_29643 = state_29601__$1;
(statearr_29619_29643[(2)] = inst_29575);

(statearr_29619_29643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (5))){
var _ = (function (){var statearr_29620 = state_29601;
(statearr_29620[(4)] = cljs.core.rest.call(null,(state_29601[(4)])));

return statearr_29620;
})();
var state_29601__$1 = state_29601;
var ex29617 = (state_29601__$1[(2)]);
var statearr_29621_29644 = state_29601__$1;
(statearr_29621_29644[(5)] = ex29617);


var statearr_29622_29645 = state_29601__$1;
(statearr_29622_29645[(1)] = (4));

(statearr_29622_29645[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (14))){
var inst_29580 = (state_29601[(2)]);
var state_29601__$1 = state_29601;
var statearr_29623_29646 = state_29601__$1;
(statearr_29623_29646[(2)] = inst_29580);

(statearr_29623_29646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (10))){
var state_29601__$1 = state_29601;
var statearr_29624_29647 = state_29601__$1;
(statearr_29624_29647[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29602 === (8))){
var inst_29584 = (state_29601[(2)]);
var inst_29585 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_29586 = [account,inst_29584,password,expireSeconds,syncTo];
var inst_29587 = cljs.core.PersistentHashMap.fromArrays(inst_29585,inst_29586);
var inst_29588 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_29587);
var state_29601__$1 = state_29601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29601__$1,(15),inst_29588);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2454__auto__ = null;
var fluree$db$connection_js$state_machine__2454__auto____0 = (function (){
var statearr_29626 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29626[(0)] = fluree$db$connection_js$state_machine__2454__auto__);

(statearr_29626[(1)] = (1));

return statearr_29626;
});
var fluree$db$connection_js$state_machine__2454__auto____1 = (function (state_29601){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29627){var ex__2457__auto__ = e29627;
var statearr_29628_29648 = state_29601;
(statearr_29628_29648[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29601[(4)]))){
var statearr_29629_29649 = state_29601;
(statearr_29629_29649[(1)] = cljs.core.first.call(null,(state_29601[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29650 = state_29601;
state_29601 = G__29650;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2454__auto__ = function(state_29601){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2454__auto____1.call(this,state_29601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2454__auto____0;
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2454__auto____1;
return fluree$db$connection_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29630 = f__2477__auto__.call(null);
(statearr_29630[(6)] = c__2476__auto__);

return statearr_29630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__29652 = arguments.length;
switch (G__29652) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29661){
var state_val_29662 = (state_29661[(1)]);
if((state_val_29662 === (1))){
var inst_29653 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29655 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_29656 = (new cljs.core.PersistentVector(null,4,(5),inst_29654,inst_29655,null));
var inst_29657 = cljs.core.async.put_BANG_.call(null,inst_29653,inst_29656);
var inst_29658 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__29663 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__29664 = null;
var count__29665 = (0);
var i__29666 = (0);
while(true){
if((i__29666 < count__29665)){
var k = cljs.core._nth.call(null,chunk__29664,i__29666);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__29674 = seq__29663;
var G__29675 = chunk__29664;
var G__29676 = count__29665;
var G__29677 = (i__29666 + (1));
seq__29663 = G__29674;
chunk__29664 = G__29675;
count__29665 = G__29676;
i__29666 = G__29677;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__29663);
if(temp__5735__auto__){
var seq__29663__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29663__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__29663__$1);
var G__29678 = cljs.core.chunk_rest.call(null,seq__29663__$1);
var G__29679 = c__4556__auto__;
var G__29680 = cljs.core.count.call(null,c__4556__auto__);
var G__29681 = (0);
seq__29663 = G__29678;
chunk__29664 = G__29679;
count__29665 = G__29680;
i__29666 = G__29681;
continue;
} else {
var k = cljs.core.first.call(null,seq__29663__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__29682 = cljs.core.next.call(null,seq__29663__$1);
var G__29683 = null;
var G__29684 = (0);
var G__29685 = (0);
seq__29663 = G__29682;
chunk__29664 = G__29683;
count__29665 = G__29684;
i__29666 = G__29685;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_29659 = cljs.core.async.take_BANG_.call(null,pc,inst_29658);
var state_29661__$1 = (function (){var statearr_29667 = state_29661;
(statearr_29667[(7)] = inst_29657);

return statearr_29667;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29661__$1,inst_29659);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2454__auto__ = null;
var fluree$db$connection_js$state_machine__2454__auto____0 = (function (){
var statearr_29668 = [null,null,null,null,null,null,null,null];
(statearr_29668[(0)] = fluree$db$connection_js$state_machine__2454__auto__);

(statearr_29668[(1)] = (1));

return statearr_29668;
});
var fluree$db$connection_js$state_machine__2454__auto____1 = (function (state_29661){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29669){var ex__2457__auto__ = e29669;
var statearr_29670_29686 = state_29661;
(statearr_29670_29686[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29661[(4)]))){
var statearr_29671_29687 = state_29661;
(statearr_29671_29687[(1)] = cljs.core.first.call(null,(state_29661[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29688 = state_29661;
state_29661 = G__29688;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2454__auto__ = function(state_29661){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2454__auto____1.call(this,state_29661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2454__auto____0;
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2454__auto____1;
return fluree$db$connection_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29672 = f__2477__auto__.call(null);
(statearr_29672[(6)] = c__2476__auto__);

return statearr_29672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__29690 = arguments.length;
switch (G__29690) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29724){
var state_val_29725 = (state_29724[(1)]);
if((state_val_29725 === (1))){
var state_29724__$1 = state_29724;
var statearr_29726_29747 = state_29724__$1;
(statearr_29726_29747[(2)] = null);

(statearr_29726_29747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29725 === (2))){
var _ = (function (){var statearr_29727 = state_29724;
(statearr_29727[(4)] = cljs.core.cons.call(null,(5),(state_29724[(4)])));

return statearr_29727;
})();
var inst_29699 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_29700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29701 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_29702 = (new cljs.core.PersistentVector(null,1,(5),inst_29700,inst_29701,null));
var inst_29703 = cljs.core.PersistentHashMap.EMPTY;
var inst_29704 = cljs.core.atom.call(null,inst_29703);
var inst_29705 = cljs.core.assoc_in.call(null,inst_29699,inst_29702,inst_29704);
var inst_29706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29707 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_29708 = (new cljs.core.PersistentVector(null,1,(5),inst_29706,inst_29707,null));
var inst_29709 = cljs.core.PersistentHashMap.EMPTY;
var inst_29710 = cljs.core.atom.call(null,inst_29709);
var inst_29711 = cljs.core.assoc_in.call(null,inst_29705,inst_29708,inst_29710);
var inst_29712 = cljs.core.async.promise_chan.call(null);
var inst_29713 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_29711);
var inst_29714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29715 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_29712,null];
var inst_29716 = (new cljs.core.PersistentVector(null,4,(5),inst_29714,inst_29715,null));
var inst_29717 = cljs.core.async.put_BANG_.call(null,inst_29713,inst_29716);
var inst_29718 = (function (){var conn = inst_29711;
var pc = inst_29712;
return (function (x){
if((x == null)){
} else {
var seq__29728_29748 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__29729_29749 = null;
var count__29730_29750 = (0);
var i__29731_29751 = (0);
while(true){
if((i__29731_29751 < count__29730_29750)){
var k_29752 = cljs.core._nth.call(null,chunk__29729_29749,i__29731_29751);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_29752], null),cljs.core.get.call(null,x,k_29752,null));


var G__29753 = seq__29728_29748;
var G__29754 = chunk__29729_29749;
var G__29755 = count__29730_29750;
var G__29756 = (i__29731_29751 + (1));
seq__29728_29748 = G__29753;
chunk__29729_29749 = G__29754;
count__29730_29750 = G__29755;
i__29731_29751 = G__29756;
continue;
} else {
var temp__5735__auto___29757 = cljs.core.seq.call(null,seq__29728_29748);
if(temp__5735__auto___29757){
var seq__29728_29758__$1 = temp__5735__auto___29757;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__29728_29758__$1)){
var c__4556__auto___29759 = cljs.core.chunk_first.call(null,seq__29728_29758__$1);
var G__29760 = cljs.core.chunk_rest.call(null,seq__29728_29758__$1);
var G__29761 = c__4556__auto___29759;
var G__29762 = cljs.core.count.call(null,c__4556__auto___29759);
var G__29763 = (0);
seq__29728_29748 = G__29760;
chunk__29729_29749 = G__29761;
count__29730_29750 = G__29762;
i__29731_29751 = G__29763;
continue;
} else {
var k_29764 = cljs.core.first.call(null,seq__29728_29758__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_29764], null),cljs.core.get.call(null,x,k_29764,null));


var G__29765 = cljs.core.next.call(null,seq__29728_29758__$1);
var G__29766 = null;
var G__29767 = (0);
var G__29768 = (0);
seq__29728_29748 = G__29765;
chunk__29729_29749 = G__29766;
count__29730_29750 = G__29767;
i__29731_29751 = G__29768;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_29719 = cljs.core.async.take_BANG_.call(null,inst_29712,inst_29718);
var ___$1 = (function (){var statearr_29732 = state_29724;
(statearr_29732[(4)] = cljs.core.rest.call(null,(state_29724[(4)])));

return statearr_29732;
})();
var state_29724__$1 = (function (){var statearr_29733 = state_29724;
(statearr_29733[(7)] = inst_29717);

return statearr_29733;
})();
var statearr_29734_29769 = state_29724__$1;
(statearr_29734_29769[(2)] = inst_29719);

(statearr_29734_29769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29725 === (3))){
var inst_29722 = (state_29724[(2)]);
var state_29724__$1 = state_29724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29724__$1,inst_29722);
} else {
if((state_val_29725 === (4))){
var inst_29691 = (state_29724[(2)]);
var inst_29692 = fluree.db.util.log.error.call(null,inst_29691);
var inst_29693 = reject.call(null,inst_29691);
var state_29724__$1 = (function (){var statearr_29736 = state_29724;
(statearr_29736[(8)] = inst_29692);

return statearr_29736;
})();
var statearr_29737_29770 = state_29724__$1;
(statearr_29737_29770[(2)] = inst_29693);

(statearr_29737_29770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29725 === (5))){
var _ = (function (){var statearr_29738 = state_29724;
(statearr_29738[(4)] = cljs.core.rest.call(null,(state_29724[(4)])));

return statearr_29738;
})();
var state_29724__$1 = state_29724;
var ex29735 = (state_29724__$1[(2)]);
var statearr_29739_29771 = state_29724__$1;
(statearr_29739_29771[(5)] = ex29735);


var statearr_29740_29772 = state_29724__$1;
(statearr_29740_29772[(1)] = (4));

(statearr_29740_29772[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2454__auto__ = null;
var fluree$db$connection_js$state_machine__2454__auto____0 = (function (){
var statearr_29741 = [null,null,null,null,null,null,null,null,null];
(statearr_29741[(0)] = fluree$db$connection_js$state_machine__2454__auto__);

(statearr_29741[(1)] = (1));

return statearr_29741;
});
var fluree$db$connection_js$state_machine__2454__auto____1 = (function (state_29724){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29742){var ex__2457__auto__ = e29742;
var statearr_29743_29773 = state_29724;
(statearr_29743_29773[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29724[(4)]))){
var statearr_29744_29774 = state_29724;
(statearr_29744_29774[(1)] = cljs.core.first.call(null,(state_29724[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29775 = state_29724;
state_29724 = G__29775;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2454__auto__ = function(state_29724){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2454__auto____1.call(this,state_29724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2454__auto____0;
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2454__auto____1;
return fluree$db$connection_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29745 = f__2477__auto__.call(null);
(statearr_29745[(6)] = c__2476__auto__);

return statearr_29745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__29777 = arguments.length;
switch (G__29777) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__29779 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__29779,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__29779,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__29782 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__29782,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__29782,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29835){
var state_val_29836 = (state_29835[(1)]);
if((state_val_29836 === (7))){
var inst_29796 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29797 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_29798 = cljs.core.PersistentHashMap.fromArrays(inst_29796,inst_29797);
var inst_29799 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_29798);
var inst_29800 = (function(){throw inst_29799})();
var state_29835__$1 = state_29835;
var statearr_29837_29866 = state_29835__$1;
(statearr_29837_29866[(2)] = inst_29800);

(statearr_29837_29866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (1))){
var state_29835__$1 = state_29835;
var statearr_29838_29867 = state_29835__$1;
(statearr_29838_29867[(2)] = null);

(statearr_29838_29867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (4))){
var inst_29785 = (state_29835[(2)]);
var inst_29786 = cljs.core.clj__GT_js.call(null,inst_29785);
var inst_29787 = reject.call(null,inst_29786);
var state_29835__$1 = state_29835;
var statearr_29839_29868 = state_29835__$1;
(statearr_29839_29868[(2)] = inst_29787);

(statearr_29839_29868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (13))){
var inst_29814 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29815 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_29816 = cljs.core.PersistentHashMap.fromArrays(inst_29814,inst_29815);
var inst_29817 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_29816);
var inst_29818 = (function(){throw inst_29817})();
var state_29835__$1 = state_29835;
var statearr_29840_29869 = state_29835__$1;
(statearr_29840_29869[(2)] = inst_29818);

(statearr_29840_29869[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (6))){
var state_29835__$1 = state_29835;
var statearr_29841_29870 = state_29835__$1;
(statearr_29841_29870[(2)] = null);

(statearr_29841_29870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (3))){
var inst_29833 = (state_29835[(2)]);
var state_29835__$1 = state_29835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29835__$1,inst_29833);
} else {
if((state_val_29836 === (12))){
var state_29835__$1 = state_29835;
var statearr_29842_29871 = state_29835__$1;
(statearr_29842_29871[(2)] = null);

(statearr_29842_29871[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (2))){
var _ = (function (){var statearr_29843 = state_29835;
(statearr_29843[(4)] = cljs.core.cons.call(null,(5),(state_29835[(4)])));

return statearr_29843;
})();
var inst_29793 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_29835__$1 = state_29835;
if(cljs.core.truth_(inst_29793)){
var statearr_29844_29872 = state_29835__$1;
(statearr_29844_29872[(1)] = (6));

} else {
var statearr_29845_29873 = state_29835__$1;
(statearr_29845_29873[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (11))){
var inst_29811 = (state_29835[(2)]);
var state_29835__$1 = (function (){var statearr_29847 = state_29835;
(statearr_29847[(7)] = inst_29811);

return statearr_29847;
})();
if(cljs.core.truth_(password)){
var statearr_29848_29874 = state_29835__$1;
(statearr_29848_29874[(1)] = (12));

} else {
var statearr_29849_29875 = state_29835__$1;
(statearr_29849_29875[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (9))){
var state_29835__$1 = state_29835;
var statearr_29850_29876 = state_29835__$1;
(statearr_29850_29876[(2)] = null);

(statearr_29850_29876[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (5))){
var _ = (function (){var statearr_29851 = state_29835;
(statearr_29851[(4)] = cljs.core.rest.call(null,(state_29835[(4)])));

return statearr_29851;
})();
var state_29835__$1 = state_29835;
var ex29846 = (state_29835__$1[(2)]);
var statearr_29852_29877 = state_29835__$1;
(statearr_29852_29877[(5)] = ex29846);


var statearr_29853_29878 = state_29835__$1;
(statearr_29853_29878[(1)] = (4));

(statearr_29853_29878[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (14))){
var inst_29820 = (state_29835[(2)]);
var inst_29821 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_29822 = fluree.db.util.core.without_nils.call(null,inst_29821);
var inst_29823 = cljs.core.async.promise_chan.call(null);
var inst_29824 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29826 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_29822,inst_29823,null];
var inst_29827 = (new cljs.core.PersistentVector(null,4,(5),inst_29825,inst_29826,null));
var inst_29828 = cljs.core.async.put_BANG_.call(null,inst_29824,inst_29827);
var inst_29829 = (function (){var _ = inst_29820;
var data = inst_29822;
var pc = inst_29823;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_29830 = cljs.core.async.take_BANG_.call(null,inst_29823,inst_29829);
var _ = (function (){var statearr_29854 = state_29835;
(statearr_29854[(4)] = cljs.core.rest.call(null,(state_29835[(4)])));

return statearr_29854;
})();
var state_29835__$1 = (function (){var statearr_29855 = state_29835;
(statearr_29855[(8)] = inst_29828);

return statearr_29855;
})();
var statearr_29856_29879 = state_29835__$1;
(statearr_29856_29879[(2)] = inst_29830);

(statearr_29856_29879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (10))){
var inst_29805 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29806 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_29807 = cljs.core.PersistentHashMap.fromArrays(inst_29805,inst_29806);
var inst_29808 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_29807);
var inst_29809 = (function(){throw inst_29808})();
var state_29835__$1 = state_29835;
var statearr_29857_29880 = state_29835__$1;
(statearr_29857_29880[(2)] = inst_29809);

(statearr_29857_29880[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29836 === (8))){
var inst_29802 = (state_29835[(2)]);
var state_29835__$1 = (function (){var statearr_29858 = state_29835;
(statearr_29858[(9)] = inst_29802);

return statearr_29858;
})();
if(cljs.core.truth_(ledger)){
var statearr_29859_29881 = state_29835__$1;
(statearr_29859_29881[(1)] = (9));

} else {
var statearr_29860_29882 = state_29835__$1;
(statearr_29860_29882[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2454__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2454__auto____0 = (function (){
var statearr_29861 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29861[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2454__auto__);

(statearr_29861[(1)] = (1));

return statearr_29861;
});
var fluree$db$connection_js$password_generate_$_state_machine__2454__auto____1 = (function (state_29835){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29862){var ex__2457__auto__ = e29862;
var statearr_29863_29883 = state_29835;
(statearr_29863_29883[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29835[(4)]))){
var statearr_29864_29884 = state_29835;
(statearr_29864_29884[(1)] = cljs.core.first.call(null,(state_29835[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29885 = state_29835;
state_29835 = G__29885;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2454__auto__ = function(state_29835){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2454__auto____1.call(this,state_29835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2454__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2454__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29865 = f__2477__auto__.call(null);
(statearr_29865[(6)] = c__2476__auto__);

return statearr_29865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__29887 = arguments.length;
switch (G__29887) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_29954){
var state_val_29955 = (state_29954[(1)]);
if((state_val_29955 === (7))){
var inst_29899 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29900 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_29901 = cljs.core.PersistentHashMap.fromArrays(inst_29899,inst_29900);
var inst_29902 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_29901);
var inst_29903 = (function(){throw inst_29902})();
var state_29954__$1 = state_29954;
var statearr_29956_29995 = state_29954__$1;
(statearr_29956_29995[(2)] = inst_29903);

(statearr_29956_29995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (20))){
var inst_29937 = (state_29954[(2)]);
var inst_29938 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_29939 = [ledger,password,user,auth,expire];
var inst_29940 = cljs.core.PersistentHashMap.fromArrays(inst_29938,inst_29939);
var inst_29941 = fluree.db.util.core.without_nils.call(null,inst_29940);
var inst_29942 = cljs.core.async.promise_chan.call(null);
var inst_29943 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_29944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29945 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_29941,inst_29942,null];
var inst_29946 = (new cljs.core.PersistentVector(null,4,(5),inst_29944,inst_29945,null));
var inst_29947 = cljs.core.async.put_BANG_.call(null,inst_29943,inst_29946);
var inst_29948 = (function (){var _ = inst_29937;
var data = inst_29941;
var pc = inst_29942;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_29949 = cljs.core.async.take_BANG_.call(null,inst_29942,inst_29948);
var _ = (function (){var statearr_29957 = state_29954;
(statearr_29957[(4)] = cljs.core.rest.call(null,(state_29954[(4)])));

return statearr_29957;
})();
var state_29954__$1 = (function (){var statearr_29958 = state_29954;
(statearr_29958[(7)] = inst_29947);

return statearr_29958;
})();
var statearr_29959_29996 = state_29954__$1;
(statearr_29959_29996[(2)] = inst_29949);

(statearr_29959_29996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (1))){
var state_29954__$1 = state_29954;
var statearr_29960_29997 = state_29954__$1;
(statearr_29960_29997[(2)] = null);

(statearr_29960_29997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (4))){
var inst_29888 = (state_29954[(2)]);
var inst_29889 = cljs.core.clj__GT_js.call(null,inst_29888);
var inst_29890 = reject.call(null,inst_29889);
var state_29954__$1 = state_29954;
var statearr_29961_29998 = state_29954__$1;
(statearr_29961_29998[(2)] = inst_29890);

(statearr_29961_29998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (15))){
var inst_29924 = (state_29954[(8)]);
var state_29954__$1 = state_29954;
var statearr_29962_29999 = state_29954__$1;
(statearr_29962_29999[(2)] = inst_29924);

(statearr_29962_29999[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (13))){
var inst_29917 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29918 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_29919 = cljs.core.PersistentHashMap.fromArrays(inst_29917,inst_29918);
var inst_29920 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_29919);
var inst_29921 = (function(){throw inst_29920})();
var state_29954__$1 = state_29954;
var statearr_29963_30000 = state_29954__$1;
(statearr_29963_30000[(2)] = inst_29921);

(statearr_29963_30000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (6))){
var state_29954__$1 = state_29954;
var statearr_29964_30001 = state_29954__$1;
(statearr_29964_30001[(2)] = null);

(statearr_29964_30001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (17))){
var inst_29928 = (state_29954[(2)]);
var state_29954__$1 = state_29954;
if(cljs.core.truth_(inst_29928)){
var statearr_29965_30002 = state_29954__$1;
(statearr_29965_30002[(1)] = (18));

} else {
var statearr_29966_30003 = state_29954__$1;
(statearr_29966_30003[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (3))){
var inst_29952 = (state_29954[(2)]);
var state_29954__$1 = state_29954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29954__$1,inst_29952);
} else {
if((state_val_29955 === (12))){
var state_29954__$1 = state_29954;
var statearr_29967_30004 = state_29954__$1;
(statearr_29967_30004[(2)] = null);

(statearr_29967_30004[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (2))){
var _ = (function (){var statearr_29968 = state_29954;
(statearr_29968[(4)] = cljs.core.cons.call(null,(5),(state_29954[(4)])));

return statearr_29968;
})();
var inst_29896 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_29954__$1 = state_29954;
if(cljs.core.truth_(inst_29896)){
var statearr_29969_30005 = state_29954__$1;
(statearr_29969_30005[(1)] = (6));

} else {
var statearr_29970_30006 = state_29954__$1;
(statearr_29970_30006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (19))){
var inst_29931 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29932 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_29933 = cljs.core.PersistentHashMap.fromArrays(inst_29931,inst_29932);
var inst_29934 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_29933);
var inst_29935 = (function(){throw inst_29934})();
var state_29954__$1 = state_29954;
var statearr_29971_30007 = state_29954__$1;
(statearr_29971_30007[(2)] = inst_29935);

(statearr_29971_30007[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (11))){
var inst_29914 = (state_29954[(2)]);
var state_29954__$1 = (function (){var statearr_29973 = state_29954;
(statearr_29973[(9)] = inst_29914);

return statearr_29973;
})();
if(cljs.core.truth_(password)){
var statearr_29974_30008 = state_29954__$1;
(statearr_29974_30008[(1)] = (12));

} else {
var statearr_29975_30009 = state_29954__$1;
(statearr_29975_30009[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (9))){
var state_29954__$1 = state_29954;
var statearr_29976_30010 = state_29954__$1;
(statearr_29976_30010[(2)] = null);

(statearr_29976_30010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (5))){
var _ = (function (){var statearr_29977 = state_29954;
(statearr_29977[(4)] = cljs.core.rest.call(null,(state_29954[(4)])));

return statearr_29977;
})();
var state_29954__$1 = state_29954;
var ex29972 = (state_29954__$1[(2)]);
var statearr_29978_30011 = state_29954__$1;
(statearr_29978_30011[(5)] = ex29972);


var statearr_29979_30012 = state_29954__$1;
(statearr_29979_30012[(1)] = (4));

(statearr_29979_30012[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (14))){
var inst_29924 = (state_29954[(8)]);
var inst_29923 = (state_29954[(2)]);
var inst_29924__$1 = user;
var state_29954__$1 = (function (){var statearr_29980 = state_29954;
(statearr_29980[(10)] = inst_29923);

(statearr_29980[(8)] = inst_29924__$1);

return statearr_29980;
})();
if(cljs.core.truth_(inst_29924__$1)){
var statearr_29981_30013 = state_29954__$1;
(statearr_29981_30013[(1)] = (15));

} else {
var statearr_29982_30014 = state_29954__$1;
(statearr_29982_30014[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (16))){
var state_29954__$1 = state_29954;
var statearr_29983_30015 = state_29954__$1;
(statearr_29983_30015[(2)] = auth);

(statearr_29983_30015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (10))){
var inst_29908 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29909 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_29910 = cljs.core.PersistentHashMap.fromArrays(inst_29908,inst_29909);
var inst_29911 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_29910);
var inst_29912 = (function(){throw inst_29911})();
var state_29954__$1 = state_29954;
var statearr_29984_30016 = state_29954__$1;
(statearr_29984_30016[(2)] = inst_29912);

(statearr_29984_30016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (18))){
var state_29954__$1 = state_29954;
var statearr_29985_30017 = state_29954__$1;
(statearr_29985_30017[(2)] = null);

(statearr_29985_30017[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29955 === (8))){
var inst_29905 = (state_29954[(2)]);
var state_29954__$1 = (function (){var statearr_29986 = state_29954;
(statearr_29986[(11)] = inst_29905);

return statearr_29986;
})();
if(cljs.core.truth_(ledger)){
var statearr_29987_30018 = state_29954__$1;
(statearr_29987_30018[(1)] = (9));

} else {
var statearr_29988_30019 = state_29954__$1;
(statearr_29988_30019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2454__auto__ = null;
var fluree$db$connection_js$state_machine__2454__auto____0 = (function (){
var statearr_29989 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29989[(0)] = fluree$db$connection_js$state_machine__2454__auto__);

(statearr_29989[(1)] = (1));

return statearr_29989;
});
var fluree$db$connection_js$state_machine__2454__auto____1 = (function (state_29954){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_29954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e29990){var ex__2457__auto__ = e29990;
var statearr_29991_30020 = state_29954;
(statearr_29991_30020[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_29954[(4)]))){
var statearr_29992_30021 = state_29954;
(statearr_29992_30021[(1)] = cljs.core.first.call(null,(state_29954[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30022 = state_29954;
state_29954 = G__30022;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2454__auto__ = function(state_29954){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2454__auto____1.call(this,state_29954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2454__auto____0;
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2454__auto____1;
return fluree$db$connection_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_29993 = f__2477__auto__.call(null);
(statearr_29993[(6)] = c__2476__auto__);

return statearr_29993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__30024 = arguments.length;
switch (G__30024) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_30059){
var state_val_30060 = (state_30059[(1)]);
if((state_val_30060 === (1))){
var state_30059__$1 = state_30059;
var statearr_30061_30081 = state_30059__$1;
(statearr_30061_30081[(2)] = null);

(statearr_30061_30081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (2))){
var _ = (function (){var statearr_30062 = state_30059;
(statearr_30062[(4)] = cljs.core.cons.call(null,(5),(state_30059[(4)])));

return statearr_30062;
})();
var inst_30033 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_30059__$1 = state_30059;
if(cljs.core.truth_(inst_30033)){
var statearr_30063_30082 = state_30059__$1;
(statearr_30063_30082[(1)] = (6));

} else {
var statearr_30064_30083 = state_30059__$1;
(statearr_30064_30083[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (3))){
var inst_30057 = (state_30059[(2)]);
var state_30059__$1 = state_30059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30059__$1,inst_30057);
} else {
if((state_val_30060 === (4))){
var inst_30025 = (state_30059[(2)]);
var inst_30026 = cljs.core.clj__GT_js.call(null,inst_30025);
var inst_30027 = reject.call(null,inst_30026);
var state_30059__$1 = state_30059;
var statearr_30066_30084 = state_30059__$1;
(statearr_30066_30084[(2)] = inst_30027);

(statearr_30066_30084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (5))){
var _ = (function (){var statearr_30067 = state_30059;
(statearr_30067[(4)] = cljs.core.rest.call(null,(state_30059[(4)])));

return statearr_30067;
})();
var state_30059__$1 = state_30059;
var ex30065 = (state_30059__$1[(2)]);
var statearr_30068_30085 = state_30059__$1;
(statearr_30068_30085[(5)] = ex30065);


var statearr_30069_30086 = state_30059__$1;
(statearr_30069_30086[(1)] = (4));

(statearr_30069_30086[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (6))){
var state_30059__$1 = state_30059;
var statearr_30070_30087 = state_30059__$1;
(statearr_30070_30087[(2)] = null);

(statearr_30070_30087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (7))){
var inst_30036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30037 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_30038 = cljs.core.PersistentHashMap.fromArrays(inst_30036,inst_30037);
var inst_30039 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_30038);
var inst_30040 = (function(){throw inst_30039})();
var state_30059__$1 = state_30059;
var statearr_30071_30088 = state_30059__$1;
(statearr_30071_30088[(2)] = inst_30040);

(statearr_30071_30088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30060 === (8))){
var inst_30042 = (state_30059[(2)]);
var inst_30043 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_30044 = [jwt,expire];
var inst_30045 = cljs.core.PersistentHashMap.fromArrays(inst_30043,inst_30044);
var inst_30046 = fluree.db.util.core.without_nils.call(null,inst_30045);
var inst_30047 = cljs.core.async.promise_chan.call(null);
var inst_30048 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_30049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30050 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_30046,inst_30047,null];
var inst_30051 = (new cljs.core.PersistentVector(null,4,(5),inst_30049,inst_30050,null));
var inst_30052 = cljs.core.async.put_BANG_.call(null,inst_30048,inst_30051);
var inst_30053 = (function (){var _ = inst_30042;
var data = inst_30046;
var pc = inst_30047;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_30054 = cljs.core.async.take_BANG_.call(null,inst_30047,inst_30053);
var _ = (function (){var statearr_30072 = state_30059;
(statearr_30072[(4)] = cljs.core.rest.call(null,(state_30059[(4)])));

return statearr_30072;
})();
var state_30059__$1 = (function (){var statearr_30073 = state_30059;
(statearr_30073[(7)] = inst_30052);

return statearr_30073;
})();
var statearr_30074_30089 = state_30059__$1;
(statearr_30074_30089[(2)] = inst_30054);

(statearr_30074_30089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2454__auto__ = null;
var fluree$db$connection_js$state_machine__2454__auto____0 = (function (){
var statearr_30075 = [null,null,null,null,null,null,null,null];
(statearr_30075[(0)] = fluree$db$connection_js$state_machine__2454__auto__);

(statearr_30075[(1)] = (1));

return statearr_30075;
});
var fluree$db$connection_js$state_machine__2454__auto____1 = (function (state_30059){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_30059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e30076){var ex__2457__auto__ = e30076;
var statearr_30077_30090 = state_30059;
(statearr_30077_30090[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_30059[(4)]))){
var statearr_30078_30091 = state_30059;
(statearr_30078_30091[(1)] = cljs.core.first.call(null,(state_30059[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30092 = state_30059;
state_30059 = G__30092;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2454__auto__ = function(state_30059){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2454__auto____1.call(this,state_30059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2454__auto____0;
fluree$db$connection_js$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2454__auto____1;
return fluree$db$connection_js$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_30079 = f__2477__auto__.call(null);
(statearr_30079[(6)] = c__2476__auto__);

return statearr_30079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

