// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__15986_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__15986_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__15990 = coll;
var vec__15991 = G__15990;
var seq__15992 = cljs.core.seq.call(null,vec__15991);
var first__15993 = cljs.core.first.call(null,seq__15992);
var seq__15992__$1 = cljs.core.next.call(null,seq__15992);
var clause = first__15993;
var r = seq__15992__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__15990__$1 = G__15990;
var res__$1 = res;
while(true){
var vec__15997 = G__15990__$1;
var seq__15998 = cljs.core.seq.call(null,vec__15997);
var first__15999 = cljs.core.first.call(null,seq__15998);
var seq__15998__$1 = cljs.core.next.call(null,seq__15998);
var clause__$1 = first__15999;
var r__$1 = seq__15998__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16000 = r__$1;
var G__16001 = cljs.core.conj.call(null,res__$2,clause__$1);
G__15990__$1 = G__16000;
res__$1 = G__16001;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__16005 = coll;
var vec__16006 = G__16005;
var seq__16007 = cljs.core.seq.call(null,vec__16006);
var first__16008 = cljs.core.first.call(null,seq__16007);
var seq__16007__$1 = cljs.core.next.call(null,seq__16007);
var clause = first__16008;
var r = seq__16007__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16005__$1 = G__16005;
var res__$1 = res;
while(true){
var vec__16012 = G__16005__$1;
var seq__16013 = cljs.core.seq.call(null,vec__16012);
var first__16014 = cljs.core.first.call(null,seq__16013);
var seq__16013__$1 = cljs.core.next.call(null,seq__16013);
var clause__$1 = first__16014;
var r__$1 = seq__16013__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16015 = r__$1;
var G__16016 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__16005__$1 = G__16015;
res__$1 = G__16016;
continue;
} else {
var G__16017 = r__$1;
var G__16018 = res__$2;
G__16005__$1 = G__16017;
res__$1 = G__16018;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__16022 = coll;
var vec__16023 = G__16022;
var seq__16024 = cljs.core.seq.call(null,vec__16023);
var first__16025 = cljs.core.first.call(null,seq__16024);
var seq__16024__$1 = cljs.core.next.call(null,seq__16024);
var clause = first__16025;
var r = seq__16024__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16022__$1 = G__16022;
var res__$1 = res;
while(true){
var vec__16029 = G__16022__$1;
var seq__16030 = cljs.core.seq.call(null,vec__16029);
var first__16031 = cljs.core.first.call(null,seq__16030);
var seq__16030__$1 = cljs.core.next.call(null,seq__16030);
var clause__$1 = first__16031;
var r__$1 = seq__16030__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16032 = r__$1;
var G__16033 = res__$2;
G__16022__$1 = G__16032;
res__$1 = G__16033;
continue;
} else {
var G__16034 = r__$1;
var G__16035 = cljs.core.conj.call(null,res__$2,clause__$1);
G__16022__$1 = G__16034;
res__$1 = G__16035;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.call(null,["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.call(null,q_map)].join('')):null);
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__16039 = opts;
var map__16039__$1 = (((((!((map__16039 == null))))?(((((map__16039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16039):map__16039);
var limit = cljs.core.get.call(null,map__16039__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__16039__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__16039__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__16039__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__16039__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__16036_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16036_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__16037_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__16037_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__16038_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__16038_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16054){
var state_val_16055 = (state_16054[(1)]);
if((state_val_16055 === (1))){
var inst_16041 = fluree.db.util.core.url_encode.call(null,query);
var inst_16042 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16041)].join('');
var inst_16043 = ["User-Agent","Accept"];
var inst_16044 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_16045 = cljs.core.PersistentHashMap.fromArrays(inst_16043,inst_16044);
var inst_16046 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_16047 = [inst_16045,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_16048 = cljs.core.PersistentHashMap.fromArrays(inst_16046,inst_16047);
var inst_16049 = fluree.db.util.xhttp.get.call(null,inst_16042,inst_16048);
var state_16054__$1 = state_16054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16054__$1,(2),inst_16049);
} else {
if((state_val_16055 === (2))){
var inst_16051 = (state_16054[(2)]);
var inst_16052 = fluree.db.util.async.throw_err.call(null,inst_16051);
var state_16054__$1 = state_16054;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16054__$1,inst_16052);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____0 = (function (){
var statearr_16056 = [null,null,null,null,null,null,null];
(statearr_16056[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__);

(statearr_16056[(1)] = (1));

return statearr_16056;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____1 = (function (state_16054){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16054);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16057){var ex__2457__auto__ = e16057;
var statearr_16058_16061 = state_16054;
(statearr_16058_16061[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16054[(4)]))){
var statearr_16059_16062 = state_16054;
(statearr_16059_16062[(1)] = cljs.core.first.call(null,(state_16054[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16063 = state_16054;
state_16054 = G__16063;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__ = function(state_16054){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____1.call(this,state_16054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16060 = f__2477__auto__.call(null);
(statearr_16060[(6)] = c__2476__auto__);

return statearr_16060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16081){
var state_val_16082 = (state_16081[(1)]);
if((state_val_16082 === (1))){
var inst_16064 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_16081__$1 = state_16081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16081__$1,(2),inst_16064);
} else {
if((state_val_16082 === (2))){
var inst_16067 = (state_16081[(7)]);
var inst_16066 = (state_16081[(2)]);
var inst_16067__$1 = fluree.db.util.async.throw_err.call(null,inst_16066);
var inst_16068 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_16067__$1);
var inst_16069 = cljs.core.not_EQ_.call(null,(200),inst_16068);
var state_16081__$1 = (function (){var statearr_16083 = state_16081;
(statearr_16083[(7)] = inst_16067__$1);

return statearr_16083;
})();
if(inst_16069){
var statearr_16084_16093 = state_16081__$1;
(statearr_16084_16093[(1)] = (3));

} else {
var statearr_16085_16094 = state_16081__$1;
(statearr_16085_16094[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16082 === (3))){
var inst_16067 = (state_16081[(7)]);
var state_16081__$1 = state_16081;
var statearr_16086_16095 = state_16081__$1;
(statearr_16086_16095[(2)] = inst_16067);

(statearr_16086_16095[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16082 === (4))){
var inst_16067 = (state_16081[(7)]);
var inst_16072 = (function (){var body = inst_16067;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_16073 = cljs.core.second.call(null,inst_16067);
var inst_16074 = cljs.core.second.call(null,inst_16073);
var inst_16075 = cljs.core.first.call(null,inst_16074);
var inst_16076 = cljs.core.second.call(null,inst_16075);
var inst_16077 = cljs.core.mapv.call(null,inst_16072,inst_16076);
var state_16081__$1 = state_16081;
var statearr_16087_16096 = state_16081__$1;
(statearr_16087_16096[(2)] = inst_16077);

(statearr_16087_16096[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16082 === (5))){
var inst_16079 = (state_16081[(2)]);
var state_16081__$1 = state_16081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16081__$1,inst_16079);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____0 = (function (){
var statearr_16088 = [null,null,null,null,null,null,null,null];
(statearr_16088[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__);

(statearr_16088[(1)] = (1));

return statearr_16088;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____1 = (function (state_16081){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16089){var ex__2457__auto__ = e16089;
var statearr_16090_16097 = state_16081;
(statearr_16090_16097[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16081[(4)]))){
var statearr_16091_16098 = state_16081;
(statearr_16091_16098[(1)] = cljs.core.first.call(null,(state_16081[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16099 = state_16081;
state_16081 = G__16099;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__ = function(state_16081){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____1.call(this,state_16081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16092 = f__2477__auto__.call(null);
(statearr_16092[(6)] = c__2476__auto__);

return statearr_16092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__16100_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16100_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__16101_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16101_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__16102_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__16102_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_16168){
var state_val_16169 = (state_16168[(1)]);
if((state_val_16169 === (7))){
var inst_16113 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_16168__$1 = state_16168;
var statearr_16170_16211 = state_16168__$1;
(statearr_16170_16211[(2)] = inst_16113);

(statearr_16170_16211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (20))){
var inst_16141 = (state_16168[(7)]);
var inst_16161 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_16141,all_vars);
var state_16168__$1 = state_16168;
var statearr_16171_16212 = state_16168__$1;
(statearr_16171_16212[(2)] = inst_16161);

(statearr_16171_16212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (1))){
var state_16168__$1 = state_16168;
var statearr_16172_16213 = state_16168__$1;
(statearr_16172_16213[(2)] = null);

(statearr_16172_16213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (24))){
var inst_16142 = (state_16168[(8)]);
var inst_16141 = (state_16168[(7)]);
var inst_16147 = (state_16168[(9)]);
var inst_16152 = (state_16168[(2)]);
var inst_16153 = cljs.core.subs.call(null,inst_16147,(0),inst_16152);
var inst_16154 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16155 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_16141);
var inst_16156 = [inst_16142,inst_16155];
var inst_16157 = cljs.core.PersistentHashMap.fromArrays(inst_16154,inst_16156);
var inst_16158 = cljs.core.ex_info.call(null,inst_16153,inst_16157);
var inst_16159 = (function(){throw inst_16158})();
var state_16168__$1 = state_16168;
var statearr_16173_16214 = state_16168__$1;
(statearr_16173_16214[(2)] = inst_16159);

(statearr_16173_16214[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (4))){
var inst_16103 = (state_16168[(2)]);
var state_16168__$1 = state_16168;
var statearr_16174_16215 = state_16168__$1;
(statearr_16174_16215[(2)] = inst_16103);

(statearr_16174_16215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (15))){
var inst_16133 = (state_16168[(2)]);
var state_16168__$1 = state_16168;
var statearr_16175_16216 = state_16168__$1;
(statearr_16175_16216[(2)] = inst_16133);

(statearr_16175_16216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (21))){
var inst_16163 = (state_16168[(2)]);
var _ = (function (){var statearr_16176 = state_16168;
(statearr_16176[(4)] = cljs.core.rest.call(null,(state_16168[(4)])));

return statearr_16176;
})();
var state_16168__$1 = state_16168;
var statearr_16177_16217 = state_16168__$1;
(statearr_16177_16217[(2)] = inst_16163);

(statearr_16177_16217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (13))){
var state_16168__$1 = state_16168;
var statearr_16178_16218 = state_16168__$1;
(statearr_16178_16218[(2)] = true);

(statearr_16178_16218[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (22))){
var inst_16146 = (state_16168[(10)]);
var state_16168__$1 = state_16168;
var statearr_16179_16219 = state_16168__$1;
(statearr_16179_16219[(2)] = inst_16146);

(statearr_16179_16219[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (6))){
var state_16168__$1 = state_16168;
var statearr_16180_16220 = state_16168__$1;
(statearr_16180_16220[(2)] = null);

(statearr_16180_16220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (17))){
var inst_16120 = (state_16168[(11)]);
var state_16168__$1 = state_16168;
var statearr_16181_16221 = state_16168__$1;
(statearr_16181_16221[(2)] = inst_16120);

(statearr_16181_16221[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (3))){
var inst_16166 = (state_16168[(2)]);
var state_16168__$1 = state_16168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16168__$1,inst_16166);
} else {
if((state_val_16169 === (12))){
var inst_16136 = (state_16168[(2)]);
var state_16168__$1 = state_16168;
if(cljs.core.truth_(inst_16136)){
var statearr_16182_16222 = state_16168__$1;
(statearr_16182_16222[(1)] = (16));

} else {
var statearr_16183_16223 = state_16168__$1;
(statearr_16183_16223[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (2))){
var _ = (function (){var statearr_16184 = state_16168;
(statearr_16184[(4)] = cljs.core.cons.call(null,(5),(state_16168[(4)])));

return statearr_16184;
})();
var inst_16110 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_16168__$1 = state_16168;
if(inst_16110){
var statearr_16185_16224 = state_16168__$1;
(statearr_16185_16224[(1)] = (6));

} else {
var statearr_16186_16225 = state_16168__$1;
(statearr_16186_16225[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (23))){
var state_16168__$1 = state_16168;
var statearr_16187_16226 = state_16168__$1;
(statearr_16187_16226[(2)] = (1000));

(statearr_16187_16226[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (19))){
var inst_16146 = (state_16168[(10)]);
var inst_16143 = (state_16168[(12)]);
var inst_16141 = (state_16168[(7)]);
var inst_16146__$1 = cljs.core.count.call(null,inst_16143);
var inst_16147 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_16141);
var inst_16148 = (inst_16146__$1 < (1000));
var state_16168__$1 = (function (){var statearr_16188 = state_16168;
(statearr_16188[(10)] = inst_16146__$1);

(statearr_16188[(9)] = inst_16147);

return statearr_16188;
})();
if(cljs.core.truth_(inst_16148)){
var statearr_16189_16227 = state_16168__$1;
(statearr_16189_16227[(1)] = (22));

} else {
var statearr_16190_16228 = state_16168__$1;
(statearr_16190_16228[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (11))){
var state_16168__$1 = state_16168;
var statearr_16192_16229 = state_16168__$1;
(statearr_16192_16229[(2)] = false);

(statearr_16192_16229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (9))){
var inst_16120 = (state_16168[(11)]);
var inst_16119 = (state_16168[(2)]);
var inst_16120__$1 = fluree.db.util.async.throw_err.call(null,inst_16119);
var inst_16122 = (inst_16120__$1 == null);
var inst_16123 = cljs.core.not.call(null,inst_16122);
var state_16168__$1 = (function (){var statearr_16193 = state_16168;
(statearr_16193[(11)] = inst_16120__$1);

return statearr_16193;
})();
if(inst_16123){
var statearr_16194_16230 = state_16168__$1;
(statearr_16194_16230[(1)] = (10));

} else {
var statearr_16195_16231 = state_16168__$1;
(statearr_16195_16231[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (5))){
var _ = (function (){var statearr_16196 = state_16168;
(statearr_16196[(4)] = cljs.core.rest.call(null,(state_16168[(4)])));

return statearr_16196;
})();
var state_16168__$1 = state_16168;
var ex16191 = (state_16168__$1[(2)]);
var statearr_16197_16232 = state_16168__$1;
(statearr_16197_16232[(5)] = ex16191);


if((ex16191 instanceof Error)){
var statearr_16198_16233 = state_16168__$1;
(statearr_16198_16233[(1)] = (4));

(statearr_16198_16233[(5)] = null);

} else {
throw ex16191;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (14))){
var state_16168__$1 = state_16168;
var statearr_16199_16234 = state_16168__$1;
(statearr_16199_16234[(2)] = false);

(statearr_16199_16234[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (16))){
var inst_16120 = (state_16168[(11)]);
var inst_16138 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16120);
var state_16168__$1 = state_16168;
var statearr_16200_16235 = state_16168__$1;
(statearr_16200_16235[(2)] = inst_16138);

(statearr_16200_16235[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (10))){
var inst_16120 = (state_16168[(11)]);
var inst_16125 = inst_16120.cljs$lang$protocol_mask$partition0$;
var inst_16126 = (inst_16125 & (64));
var inst_16127 = inst_16120.cljs$core$ISeq$;
var inst_16128 = (cljs.core.PROTOCOL_SENTINEL === inst_16127);
var inst_16129 = ((inst_16126) || (inst_16128));
var state_16168__$1 = state_16168;
if(cljs.core.truth_(inst_16129)){
var statearr_16201_16236 = state_16168__$1;
(statearr_16201_16236[(1)] = (13));

} else {
var statearr_16202_16237 = state_16168__$1;
(statearr_16202_16237[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (18))){
var inst_16142 = (state_16168[(8)]);
var inst_16141 = (state_16168[(7)]);
var inst_16141__$1 = (state_16168[(2)]);
var inst_16142__$1 = cljs.core.get.call(null,inst_16141__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_16143 = cljs.core.get.call(null,inst_16141__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_16144 = cljs.core._EQ_.call(null,(400),inst_16142__$1);
var state_16168__$1 = (function (){var statearr_16203 = state_16168;
(statearr_16203[(12)] = inst_16143);

(statearr_16203[(8)] = inst_16142__$1);

(statearr_16203[(7)] = inst_16141__$1);

return statearr_16203;
})();
if(inst_16144){
var statearr_16204_16238 = state_16168__$1;
(statearr_16204_16238[(1)] = (19));

} else {
var statearr_16205_16239 = state_16168__$1;
(statearr_16205_16239[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16169 === (8))){
var inst_16115 = (state_16168[(2)]);
var inst_16116 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_16115,optional_clauses);
var inst_16117 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_16116);
var state_16168__$1 = state_16168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16168__$1,(9),inst_16117);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_16206 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16206[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__);

(statearr_16206[(1)] = (1));

return statearr_16206;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____1 = (function (state_16168){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_16168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e16207){var ex__2457__auto__ = e16207;
var statearr_16208_16240 = state_16168;
(statearr_16208_16240[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_16168[(4)]))){
var statearr_16209_16241 = state_16168;
(statearr_16209_16241[(1)] = cljs.core.first.call(null,(state_16168[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16242 = state_16168;
state_16168 = G__16242;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__ = function(state_16168){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____1.call(this,state_16168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_16210 = f__2477__auto__.call(null);
(statearr_16210[(6)] = c__2476__auto__);

return statearr_16210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
