// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21462 = null;
var G__21462__0 = (function (){
return xf.call(null);
});
var G__21462__1 = (function (result){
return xf.call(null,result);
});
var G__21462__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__21462 = function(result,flake){
switch(arguments.length){
case 0:
return G__21462__0.call(this);
case 1:
return G__21462__1.call(this,result);
case 2:
return G__21462__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21462.cljs$core$IFn$_invoke$arity$0 = G__21462__0;
G__21462.cljs$core$IFn$_invoke$arity$1 = G__21462__1;
G__21462.cljs$core$IFn$_invoke$arity$2 = G__21462__2;
return G__21462;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__21463 = null;
var G__21463__0 = (function (){
return xf.call(null);
});
var G__21463__1 = (function (result){
return xf.call(null,result);
});
var G__21463__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__21463 = function(result,flakes){
switch(arguments.length){
case 0:
return G__21463__0.call(this);
case 1:
return G__21463__1.call(this,result);
case 2:
return G__21463__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21463.cljs$core$IFn$_invoke$arity$0 = G__21463__0;
G__21463.cljs$core$IFn$_invoke$arity$1 = G__21463__1;
G__21463.cljs$core$IFn$_invoke$arity$2 = G__21463__2;
return G__21463;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__21465 = res;
var G__21465__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__21464_SHARP_){
return cljs.core.get.call(null,p1__21464_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__21465):G__21465);
var G__21465__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__21465__$1):G__21465__$1);
var G__21465__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__21465__$2):G__21465__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__21465__$3);
} else {
return G__21465__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__21467 = arguments.length;
switch (G__21467) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_21770){
var state_val_21771 = (state_21770[(1)]);
if((state_val_21771 === (65))){
var inst_21497 = (state_21770[(7)]);
var inst_21628 = (state_21770[(8)]);
var inst_21621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21622 = cljs.core.deref.call(null,cache);
var inst_21623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21624 = flake.o;
var inst_21625 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21497);
var inst_21626 = [inst_21624,inst_21625];
var inst_21627 = (new cljs.core.PersistentVector(null,2,(5),inst_21623,inst_21626,null));
var inst_21628__$1 = cljs.core.get.call(null,inst_21622,inst_21627);
var state_21770__$1 = (function (){var statearr_21772 = state_21770;
(statearr_21772[(9)] = inst_21621);

(statearr_21772[(8)] = inst_21628__$1);

return statearr_21772;
})();
if(cljs.core.truth_(inst_21628__$1)){
var statearr_21773_21933 = state_21770__$1;
(statearr_21773_21933[(1)] = (68));

} else {
var statearr_21774_21934 = state_21770__$1;
(statearr_21774_21934[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (70))){
var inst_21621 = (state_21770[(9)]);
var inst_21646 = (state_21770[(2)]);
var inst_21647 = [inst_21646,offset_map];
var inst_21648 = (new cljs.core.PersistentVector(null,2,(5),inst_21621,inst_21647,null));
var state_21770__$1 = state_21770;
var statearr_21775_21935 = state_21770__$1;
(statearr_21775_21935[(2)] = inst_21648);

(statearr_21775_21935[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (62))){
var inst_21532 = (state_21770[(10)]);
var inst_21531 = (state_21770[(11)]);
var inst_21590 = (state_21770[(12)]);
var inst_21497 = (state_21770[(7)]);
var inst_21529 = (state_21770[(13)]);
var inst_21530 = (state_21770[(14)]);
var inst_21508 = (state_21770[(15)]);
var inst_21533 = (state_21770[(16)]);
var inst_21606 = (state_21770[(17)]);
var inst_21535 = (state_21770[(18)]);
var inst_21491 = (state_21770[(19)]);
var inst_21534 = (state_21770[(20)]);
var inst_21608 = (function (){var p = inst_21535;
var pred_spec__$1 = inst_21491;
var orderBy = inst_21533;
var nested_select_spec = inst_21590;
var map__21474 = inst_21529;
var multi_QMARK_ = inst_21530;
var limit = inst_21532;
var offset = inst_21534;
var G__21592 = inst_21606;
var k = inst_21508;
var pred_spec_SINGLEQUOTE_ = inst_21497;
var ref_QMARK_ = inst_21531;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_21609 = inst_21608.call(null,inst_21606);
var state_21770__$1 = state_21770;
var statearr_21776_21936 = state_21770__$1;
(statearr_21776_21936[(2)] = inst_21609);

(statearr_21776_21936[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (74))){
var inst_21655 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21655)){
var statearr_21777_21937 = state_21770__$1;
(statearr_21777_21937[(1)] = (75));

} else {
var statearr_21778_21938 = state_21770__$1;
(statearr_21778_21938[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (7))){
var inst_21478 = (state_21770[(21)]);
var state_21770__$1 = state_21770;
var statearr_21779_21939 = state_21770__$1;
(statearr_21779_21939[(2)] = inst_21478);

(statearr_21779_21939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (59))){
var inst_21600 = (state_21770[(22)]);
var inst_21602 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_21603 = cljs.core.sequence.call(null,inst_21602,inst_21600);
var state_21770__$1 = state_21770;
var statearr_21780_21940 = state_21770__$1;
(statearr_21780_21940[(2)] = inst_21603);

(statearr_21780_21940[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (86))){
var inst_21532 = (state_21770[(10)]);
var inst_21531 = (state_21770[(11)]);
var inst_21497 = (state_21770[(7)]);
var inst_21529 = (state_21770[(13)]);
var inst_21530 = (state_21770[(14)]);
var inst_21508 = (state_21770[(15)]);
var inst_21533 = (state_21770[(16)]);
var inst_21686 = (state_21770[(23)]);
var inst_21535 = (state_21770[(18)]);
var inst_21491 = (state_21770[(19)]);
var inst_21668 = (state_21770[(24)]);
var inst_21534 = (state_21770[(20)]);
var inst_21688 = (function (){var p = inst_21535;
var pred_spec__$1 = inst_21491;
var orderBy = inst_21533;
var map__21474 = inst_21529;
var children = inst_21668;
var multi_QMARK_ = inst_21530;
var limit = inst_21532;
var G__21680 = inst_21686;
var offset = inst_21534;
var k = inst_21508;
var pred_spec_SINGLEQUOTE_ = inst_21497;
var ref_QMARK_ = inst_21531;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null),n);
});
})();
var inst_21689 = inst_21688.call(null,inst_21686);
var state_21770__$1 = state_21770;
var statearr_21781_21941 = state_21770__$1;
(statearr_21781_21941[(2)] = inst_21689);

(statearr_21781_21941[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (20))){
var inst_21506 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21782_21942 = state_21770__$1;
(statearr_21782_21942[(2)] = inst_21506);

(statearr_21782_21942[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (72))){
var inst_21497 = (state_21770[(7)]);
var inst_21652 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = state_21770;
var statearr_21783_21943 = state_21770__$1;
(statearr_21783_21943[(2)] = inst_21652);

(statearr_21783_21943[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (58))){
var inst_21599 = (state_21770[(2)]);
var inst_21600 = fluree.db.util.async.throw_err.call(null,inst_21599);
var state_21770__$1 = (function (){var statearr_21784 = state_21770;
(statearr_21784[(22)] = inst_21600);

return statearr_21784;
})();
if(cljs.core.truth_(fuel)){
var statearr_21785_21944 = state_21770__$1;
(statearr_21785_21944[(1)] = (59));

} else {
var statearr_21786_21945 = state_21770__$1;
(statearr_21786_21945[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (60))){
var inst_21600 = (state_21770[(22)]);
var state_21770__$1 = state_21770;
var statearr_21787_21946 = state_21770__$1;
(statearr_21787_21946[(2)] = inst_21600);

(statearr_21787_21946[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (27))){
var inst_21497 = (state_21770[(7)]);
var inst_21526 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21497);
var state_21770__$1 = state_21770;
var statearr_21788_21947 = state_21770__$1;
(statearr_21788_21947[(2)] = inst_21526);

(statearr_21788_21947[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (1))){
var state_21770__$1 = state_21770;
var statearr_21789_21948 = state_21770__$1;
(statearr_21789_21948[(2)] = null);

(statearr_21789_21948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (69))){
var inst_21497 = (state_21770[(7)]);
var inst_21631 = flake.o;
var inst_21632 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21497);
var inst_21633 = fluree.db.dbproto._tag.call(null,db,inst_21631,inst_21632);
var state_21770__$1 = state_21770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21770__$1,(71),inst_21633);
} else {
if((state_val_21771 === (101))){
var inst_21730 = (state_21770[(25)]);
var inst_21508 = (state_21770[(15)]);
var inst_21731 = (state_21770[(26)]);
var inst_21750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21751 = cljs.core.assoc.call(null,acc,inst_21508,inst_21730);
var inst_21752 = [inst_21751,inst_21731];
var inst_21753 = (new cljs.core.PersistentVector(null,2,(5),inst_21750,inst_21752,null));
var state_21770__$1 = state_21770;
var statearr_21790_21949 = state_21770__$1;
(statearr_21790_21949[(2)] = inst_21753);

(statearr_21790_21949[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (24))){
var state_21770__$1 = state_21770;
var statearr_21791_21950 = state_21770__$1;
(statearr_21791_21950[(2)] = true);

(statearr_21791_21950[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (102))){
var state_21770__$1 = state_21770;
var statearr_21792_21951 = state_21770__$1;
(statearr_21792_21951[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (55))){
var inst_21497 = (state_21770[(7)]);
var inst_21619 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21619)){
var statearr_21794_21952 = state_21770__$1;
(statearr_21794_21952[(1)] = (65));

} else {
var statearr_21795_21953 = state_21770__$1;
(statearr_21795_21953[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (85))){
var inst_21686 = (state_21770[(2)]);
var state_21770__$1 = (function (){var statearr_21796 = state_21770;
(statearr_21796[(23)] = inst_21686);

return statearr_21796;
})();
var statearr_21797_21954 = state_21770__$1;
(statearr_21797_21954[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (39))){
var inst_21535 = (state_21770[(18)]);
var inst_21552 = cljs.core.update.call(null,offset_map,inst_21535,cljs.core.dec);
var state_21770__$1 = state_21770;
var statearr_21799_21955 = state_21770__$1;
(statearr_21799_21955[(2)] = inst_21552);

(statearr_21799_21955[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (88))){
var inst_21692 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21770__$1,(82),inst_21692);
} else {
if((state_val_21771 === (46))){
var inst_21575 = cljs.core.not.call(null,recur_QMARK_);
var state_21770__$1 = state_21770;
if(inst_21575){
var statearr_21800_21956 = state_21770__$1;
(statearr_21800_21956[(1)] = (48));

} else {
var statearr_21801_21957 = state_21770__$1;
(statearr_21801_21957[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (4))){
var inst_21468 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21802_21958 = state_21770__$1;
(statearr_21802_21958[(2)] = inst_21468);

(statearr_21802_21958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (77))){
var inst_21721 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21803_21959 = state_21770__$1;
(statearr_21803_21959[(2)] = inst_21721);

(statearr_21803_21959[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (106))){
var inst_21761 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21804_21960 = state_21770__$1;
(statearr_21804_21960[(2)] = inst_21761);

(statearr_21804_21960[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (95))){
var inst_21530 = (state_21770[(14)]);
var state_21770__$1 = state_21770;
var statearr_21805_21961 = state_21770__$1;
(statearr_21805_21961[(2)] = inst_21530);

(statearr_21805_21961[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (54))){
var inst_21497 = (state_21770[(7)]);
var inst_21587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21588 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21589 = (new cljs.core.PersistentVector(null,3,(5),inst_21587,inst_21588,null));
var inst_21590 = cljs.core.select_keys.call(null,inst_21497,inst_21589);
var inst_21591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21594 = flake.o;
var inst_21595 = [inst_21594];
var inst_21596 = (new cljs.core.PersistentVector(null,1,(5),inst_21593,inst_21595,null));
var inst_21597 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21596);
var state_21770__$1 = (function (){var statearr_21806 = state_21770;
(statearr_21806[(12)] = inst_21590);

(statearr_21806[(27)] = inst_21591);

return statearr_21806;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21770__$1,(58),inst_21597);
} else {
if((state_val_21771 === (92))){
var inst_21711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21712 = flake.o;
var inst_21713 = [inst_21712,offset_map];
var inst_21714 = (new cljs.core.PersistentVector(null,2,(5),inst_21711,inst_21713,null));
var state_21770__$1 = state_21770;
var statearr_21807_21962 = state_21770__$1;
(statearr_21807_21962[(2)] = inst_21714);

(statearr_21807_21962[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (104))){
var inst_21731 = (state_21770[(26)]);
var inst_21756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21757 = [acc,inst_21731];
var inst_21758 = (new cljs.core.PersistentVector(null,2,(5),inst_21756,inst_21757,null));
var state_21770__$1 = state_21770;
var statearr_21808_21963 = state_21770__$1;
(statearr_21808_21963[(2)] = inst_21758);

(statearr_21808_21963[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (15))){
var inst_21498 = (state_21770[(28)]);
var state_21770__$1 = state_21770;
var statearr_21809_21964 = state_21770__$1;
(statearr_21809_21964[(2)] = inst_21498);

(statearr_21809_21964[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (48))){
var inst_21497 = (state_21770[(7)]);
var inst_21577 = (state_21770[(29)]);
var inst_21577__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = (function (){var statearr_21810 = state_21770;
(statearr_21810[(29)] = inst_21577__$1);

return statearr_21810;
})();
if(cljs.core.truth_(inst_21577__$1)){
var statearr_21811_21965 = state_21770__$1;
(statearr_21811_21965[(1)] = (51));

} else {
var statearr_21812_21966 = state_21770__$1;
(statearr_21812_21966[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (50))){
var inst_21585 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21585)){
var statearr_21813_21967 = state_21770__$1;
(statearr_21813_21967[(1)] = (54));

} else {
var statearr_21814_21968 = state_21770__$1;
(statearr_21814_21968[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (75))){
var inst_21497 = (state_21770[(7)]);
var inst_21657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21658 = flake.o;
var inst_21659 = [inst_21658];
var inst_21660 = (new cljs.core.PersistentVector(null,1,(5),inst_21657,inst_21659,null));
var inst_21661 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21662 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21497);
var inst_21663 = [inst_21662];
var inst_21664 = cljs.core.PersistentHashMap.fromArrays(inst_21661,inst_21663);
var inst_21665 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21660,inst_21664);
var state_21770__$1 = state_21770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21770__$1,(78),inst_21665);
} else {
if((state_val_21771 === (99))){
var inst_21730 = (state_21770[(25)]);
var inst_21747 = (inst_21730 == null);
var inst_21748 = cljs.core.not.call(null,inst_21747);
var state_21770__$1 = state_21770;
if(inst_21748){
var statearr_21815_21969 = state_21770__$1;
(statearr_21815_21969[(1)] = (101));

} else {
var statearr_21816_21970 = state_21770__$1;
(statearr_21816_21970[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (21))){
var inst_21497 = (state_21770[(7)]);
var inst_21513 = inst_21497.cljs$lang$protocol_mask$partition0$;
var inst_21514 = (inst_21513 & (64));
var inst_21515 = inst_21497.cljs$core$ISeq$;
var inst_21516 = (cljs.core.PROTOCOL_SENTINEL === inst_21515);
var inst_21517 = ((inst_21514) || (inst_21516));
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21517)){
var statearr_21817_21971 = state_21770__$1;
(statearr_21817_21971[(1)] = (24));

} else {
var statearr_21818_21972 = state_21770__$1;
(statearr_21818_21972[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (31))){
var inst_21530 = (state_21770[(14)]);
var state_21770__$1 = state_21770;
var statearr_21819_21973 = state_21770__$1;
(statearr_21819_21973[(2)] = inst_21530);

(statearr_21819_21973[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (32))){
var inst_21547 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21547)){
var statearr_21820_21974 = state_21770__$1;
(statearr_21820_21974[(1)] = (36));

} else {
var statearr_21821_21975 = state_21770__$1;
(statearr_21821_21975[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (40))){
var inst_21535 = (state_21770[(18)]);
var inst_21534 = (state_21770[(20)]);
var inst_21554 = (inst_21534 - (1));
var inst_21555 = cljs.core.assoc.call(null,offset_map,inst_21535,inst_21554);
var state_21770__$1 = state_21770;
var statearr_21822_21976 = state_21770__$1;
(statearr_21822_21976[(2)] = inst_21555);

(statearr_21822_21976[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (91))){
var inst_21719 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21823_21977 = state_21770__$1;
(statearr_21823_21977[(2)] = inst_21719);

(statearr_21823_21977[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (56))){
var inst_21725 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21824_21978 = state_21770__$1;
(statearr_21824_21978[(2)] = inst_21725);

(statearr_21824_21978[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (33))){
var inst_21535 = (state_21770[(18)]);
var inst_21534 = (state_21770[(20)]);
var inst_21538 = cljs.core.not_EQ_.call(null,(0),inst_21534);
var inst_21539 = cljs.core.get.call(null,offset_map,inst_21535);
var inst_21540 = cljs.core.not_EQ_.call(null,(0),inst_21539);
var inst_21541 = ((inst_21538) && (inst_21540));
var state_21770__$1 = state_21770;
var statearr_21825_21979 = state_21770__$1;
(statearr_21825_21979[(2)] = inst_21541);

(statearr_21825_21979[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (13))){
var inst_21491 = (state_21770[(19)]);
var inst_21495 = cljs.core.assoc.call(null,inst_21491,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_21770__$1 = state_21770;
var statearr_21826_21980 = state_21770__$1;
(statearr_21826_21980[(2)] = inst_21495);

(statearr_21826_21980[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (22))){
var state_21770__$1 = state_21770;
var statearr_21827_21981 = state_21770__$1;
(statearr_21827_21981[(2)] = false);

(statearr_21827_21981[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (90))){
var state_21770__$1 = state_21770;
var statearr_21828_21982 = state_21770__$1;
(statearr_21828_21982[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (36))){
var inst_21535 = (state_21770[(18)]);
var inst_21549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21550 = cljs.core.get.call(null,offset_map,inst_21535);
var state_21770__$1 = (function (){var statearr_21830 = state_21770;
(statearr_21830[(30)] = inst_21549);

return statearr_21830;
})();
if(cljs.core.truth_(inst_21550)){
var statearr_21831_21983 = state_21770__$1;
(statearr_21831_21983[(1)] = (39));

} else {
var statearr_21832_21984 = state_21770__$1;
(statearr_21832_21984[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (41))){
var inst_21549 = (state_21770[(30)]);
var inst_21557 = (state_21770[(2)]);
var inst_21558 = [null,inst_21557];
var inst_21559 = (new cljs.core.PersistentVector(null,2,(5),inst_21549,inst_21558,null));
var state_21770__$1 = state_21770;
var statearr_21833_21985 = state_21770__$1;
(statearr_21833_21985[(2)] = inst_21559);

(statearr_21833_21985[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (89))){
var inst_21702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21703 = ["_id"];
var inst_21704 = flake.o;
var inst_21705 = [inst_21704];
var inst_21706 = cljs.core.PersistentHashMap.fromArrays(inst_21703,inst_21705);
var inst_21707 = [inst_21706,offset_map];
var inst_21708 = (new cljs.core.PersistentVector(null,2,(5),inst_21702,inst_21707,null));
var state_21770__$1 = state_21770;
var statearr_21834_21986 = state_21770__$1;
(statearr_21834_21986[(2)] = inst_21708);

(statearr_21834_21986[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (100))){
var inst_21765 = (state_21770[(2)]);
var _ = (function (){var statearr_21835 = state_21770;
(statearr_21835[(4)] = cljs.core.rest.call(null,(state_21770[(4)])));

return statearr_21835;
})();
var state_21770__$1 = state_21770;
var statearr_21836_21987 = state_21770__$1;
(statearr_21836_21987[(2)] = inst_21765);

(statearr_21836_21987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (43))){
var inst_21530 = (state_21770[(14)]);
var state_21770__$1 = state_21770;
var statearr_21837_21988 = state_21770__$1;
(statearr_21837_21988[(2)] = inst_21530);

(statearr_21837_21988[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (61))){
var inst_21606 = (state_21770[(2)]);
var state_21770__$1 = (function (){var statearr_21838 = state_21770;
(statearr_21838[(17)] = inst_21606);

return statearr_21838;
})();
var statearr_21839_21989 = state_21770__$1;
(statearr_21839_21989[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (29))){
var inst_21529 = (state_21770[(13)]);
var inst_21530 = (state_21770[(14)]);
var inst_21529__$1 = (state_21770[(2)]);
var inst_21530__$1 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21531 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21532 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21533 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21534 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21535 = cljs.core.get.call(null,inst_21529__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_21770__$1 = (function (){var statearr_21841 = state_21770;
(statearr_21841[(10)] = inst_21532);

(statearr_21841[(11)] = inst_21531);

(statearr_21841[(13)] = inst_21529__$1);

(statearr_21841[(14)] = inst_21530__$1);

(statearr_21841[(16)] = inst_21533);

(statearr_21841[(18)] = inst_21535);

(statearr_21841[(20)] = inst_21534);

return statearr_21841;
})();
if(cljs.core.truth_(inst_21530__$1)){
var statearr_21842_21990 = state_21770__$1;
(statearr_21842_21990[(1)] = (30));

} else {
var statearr_21843_21991 = state_21770__$1;
(statearr_21843_21991[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (44))){
var inst_21569 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21569)){
var statearr_21844_21992 = state_21770__$1;
(statearr_21844_21992[(1)] = (45));

} else {
var statearr_21845_21993 = state_21770__$1;
(statearr_21845_21993[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (93))){
var state_21770__$1 = state_21770;
var statearr_21846_21994 = state_21770__$1;
(statearr_21846_21994[(2)] = null);

(statearr_21846_21994[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (6))){
var inst_21480 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21481 = (inst_21480 == null);
var state_21770__$1 = state_21770;
var statearr_21847_21995 = state_21770__$1;
(statearr_21847_21995[(2)] = inst_21481);

(statearr_21847_21995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (28))){
var inst_21497 = (state_21770[(7)]);
var state_21770__$1 = state_21770;
var statearr_21848_21996 = state_21770__$1;
(statearr_21848_21996[(2)] = inst_21497);

(statearr_21848_21996[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (64))){
var inst_21612 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21770__$1,(57),inst_21612);
} else {
if((state_val_21771 === (103))){
var inst_21763 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21849_21997 = state_21770__$1;
(statearr_21849_21997[(2)] = inst_21763);

(statearr_21849_21997[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (51))){
var inst_21577 = (state_21770[(29)]);
var state_21770__$1 = state_21770;
var statearr_21850_21998 = state_21770__$1;
(statearr_21850_21998[(2)] = inst_21577);

(statearr_21850_21998[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (25))){
var state_21770__$1 = state_21770;
var statearr_21851_21999 = state_21770__$1;
(statearr_21851_21999[(2)] = false);

(statearr_21851_21999[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (34))){
var inst_21534 = (state_21770[(20)]);
var state_21770__$1 = state_21770;
var statearr_21852_22000 = state_21770__$1;
(statearr_21852_22000[(2)] = inst_21534);

(statearr_21852_22000[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (17))){
var inst_21497 = (state_21770[(7)]);
var inst_21508 = (state_21770[(2)]);
var inst_21510 = (inst_21497 == null);
var inst_21511 = cljs.core.not.call(null,inst_21510);
var state_21770__$1 = (function (){var statearr_21853 = state_21770;
(statearr_21853[(15)] = inst_21508);

return statearr_21853;
})();
if(inst_21511){
var statearr_21854_22001 = state_21770__$1;
(statearr_21854_22001[(1)] = (21));

} else {
var statearr_21855_22002 = state_21770__$1;
(statearr_21855_22002[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (3))){
var inst_21768 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21770__$1,inst_21768);
} else {
if((state_val_21771 === (12))){
var inst_21491 = (state_21770[(19)]);
var state_21770__$1 = state_21770;
var statearr_21856_22003 = state_21770__$1;
(statearr_21856_22003[(2)] = inst_21491);

(statearr_21856_22003[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (2))){
var inst_21478 = (state_21770[(21)]);
var _ = (function (){var statearr_21857 = state_21770;
(statearr_21857[(4)] = cljs.core.cons.call(null,(5),(state_21770[(4)])));

return statearr_21857;
})();
var inst_21478__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_21770__$1 = (function (){var statearr_21858 = state_21770;
(statearr_21858[(21)] = inst_21478__$1);

return statearr_21858;
})();
if(cljs.core.truth_(inst_21478__$1)){
var statearr_21859_22004 = state_21770__$1;
(statearr_21859_22004[(1)] = (6));

} else {
var statearr_21860_22005 = state_21770__$1;
(statearr_21860_22005[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (66))){
var inst_21650 = (state_21770[(31)]);
var inst_21650__$1 = componentFollow_QMARK_;
var state_21770__$1 = (function (){var statearr_21861 = state_21770;
(statearr_21861[(31)] = inst_21650__$1);

return statearr_21861;
})();
if(cljs.core.truth_(inst_21650__$1)){
var statearr_21862_22006 = state_21770__$1;
(statearr_21862_22006[(1)] = (72));

} else {
var statearr_21863_22007 = state_21770__$1;
(statearr_21863_22007[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (23))){
var inst_21524 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21524)){
var statearr_21864_22008 = state_21770__$1;
(statearr_21864_22008[(1)] = (27));

} else {
var statearr_21865_22009 = state_21770__$1;
(statearr_21865_22009[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (47))){
var inst_21727 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21866_22010 = state_21770__$1;
(statearr_21866_22010[(2)] = inst_21727);

(statearr_21866_22010[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (35))){
var inst_21544 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21867_22011 = state_21770__$1;
(statearr_21867_22011[(2)] = inst_21544);

(statearr_21867_22011[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (82))){
var inst_21679 = (state_21770[(32)]);
var inst_21694 = (state_21770[(2)]);
var inst_21695 = fluree.db.util.async.throw_err.call(null,inst_21694);
var inst_21696 = [inst_21695,offset_map];
var inst_21697 = (new cljs.core.PersistentVector(null,2,(5),inst_21679,inst_21696,null));
var state_21770__$1 = state_21770;
var statearr_21868_22012 = state_21770__$1;
(statearr_21868_22012[(2)] = inst_21697);

(statearr_21868_22012[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (76))){
var inst_21531 = (state_21770[(11)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21531)){
var statearr_21869_22013 = state_21770__$1;
(statearr_21869_22013[(1)] = (89));

} else {
var statearr_21870_22014 = state_21770__$1;
(statearr_21870_22014[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (97))){
var inst_21737 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21737)){
var statearr_21871_22015 = state_21770__$1;
(statearr_21871_22015[(1)] = (98));

} else {
var statearr_21872_22016 = state_21770__$1;
(statearr_21872_22016[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (19))){
var inst_21497 = (state_21770[(7)]);
var inst_21504 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = state_21770;
var statearr_21873_22017 = state_21770__$1;
(statearr_21873_22017[(2)] = inst_21504);

(statearr_21873_22017[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (57))){
var inst_21591 = (state_21770[(27)]);
var inst_21614 = (state_21770[(2)]);
var inst_21615 = fluree.db.util.async.throw_err.call(null,inst_21614);
var inst_21616 = [inst_21615,offset_map];
var inst_21617 = (new cljs.core.PersistentVector(null,2,(5),inst_21591,inst_21616,null));
var state_21770__$1 = state_21770;
var statearr_21874_22018 = state_21770__$1;
(statearr_21874_22018[(2)] = inst_21617);

(statearr_21874_22018[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (68))){
var inst_21628 = (state_21770[(8)]);
var state_21770__$1 = state_21770;
var statearr_21875_22019 = state_21770__$1;
(statearr_21875_22019[(2)] = inst_21628);

(statearr_21875_22019[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (11))){
var inst_21491 = (state_21770[(19)]);
var inst_21491__$1 = (state_21770[(2)]);
var inst_21492 = cljs.core.contains_QMARK_.call(null,inst_21491__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_21770__$1 = (function (){var statearr_21877 = state_21770;
(statearr_21877[(19)] = inst_21491__$1);

return statearr_21877;
})();
if(inst_21492){
var statearr_21878_22020 = state_21770__$1;
(statearr_21878_22020[(1)] = (12));

} else {
var statearr_21879_22021 = state_21770__$1;
(statearr_21879_22021[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (9))){
var inst_21486 = flake.p;
var inst_21487 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21488 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_21486,inst_21487);
var state_21770__$1 = state_21770;
var statearr_21880_22022 = state_21770__$1;
(statearr_21880_22022[(2)] = inst_21488);

(statearr_21880_22022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (5))){
var _ = (function (){var statearr_21881 = state_21770;
(statearr_21881[(4)] = cljs.core.rest.call(null,(state_21770[(4)])));

return statearr_21881;
})();
var state_21770__$1 = state_21770;
var ex21876 = (state_21770__$1[(2)]);
var statearr_21882_22023 = state_21770__$1;
(statearr_21882_22023[(5)] = ex21876);


if((ex21876 instanceof Error)){
var statearr_21883_22024 = state_21770__$1;
(statearr_21883_22024[(1)] = (4));

(statearr_21883_22024[(5)] = null);

} else {
throw ex21876;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (83))){
var inst_21668 = (state_21770[(24)]);
var inst_21682 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_21683 = cljs.core.sequence.call(null,inst_21682,inst_21668);
var state_21770__$1 = state_21770;
var statearr_21884_22025 = state_21770__$1;
(statearr_21884_22025[(2)] = inst_21683);

(statearr_21884_22025[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (14))){
var inst_21497 = (state_21770[(7)]);
var inst_21498 = (state_21770[(28)]);
var inst_21497__$1 = (state_21770[(2)]);
var inst_21498__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21497__$1);
var state_21770__$1 = (function (){var statearr_21885 = state_21770;
(statearr_21885[(7)] = inst_21497__$1);

(statearr_21885[(28)] = inst_21498__$1);

return statearr_21885;
})();
if(cljs.core.truth_(inst_21498__$1)){
var statearr_21886_22026 = state_21770__$1;
(statearr_21886_22026[(1)] = (15));

} else {
var statearr_21887_22027 = state_21770__$1;
(statearr_21887_22027[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (45))){
var inst_21571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21572 = [null,offset_map];
var inst_21573 = (new cljs.core.PersistentVector(null,2,(5),inst_21571,inst_21572,null));
var state_21770__$1 = state_21770;
var statearr_21888_22028 = state_21770__$1;
(statearr_21888_22028[(2)] = inst_21573);

(statearr_21888_22028[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (53))){
var inst_21582 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21889_22029 = state_21770__$1;
(statearr_21889_22029[(2)] = inst_21582);

(statearr_21889_22029[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (78))){
var inst_21668 = (state_21770[(24)]);
var inst_21667 = (state_21770[(2)]);
var inst_21668__$1 = fluree.db.util.async.throw_err.call(null,inst_21667);
var inst_21669 = cljs.core.empty_QMARK_.call(null,inst_21668__$1);
var state_21770__$1 = (function (){var statearr_21890 = state_21770;
(statearr_21890[(24)] = inst_21668__$1);

return statearr_21890;
})();
if(inst_21669){
var statearr_21891_22030 = state_21770__$1;
(statearr_21891_22030[(1)] = (79));

} else {
var statearr_21892_22031 = state_21770__$1;
(statearr_21892_22031[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (26))){
var inst_21521 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21893_22032 = state_21770__$1;
(statearr_21893_22032[(2)] = inst_21521);

(statearr_21893_22032[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (16))){
var inst_21497 = (state_21770[(7)]);
var inst_21501 = (state_21770[(33)]);
var inst_21501__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = (function (){var statearr_21894 = state_21770;
(statearr_21894[(33)] = inst_21501__$1);

return statearr_21894;
})();
if(cljs.core.truth_(inst_21501__$1)){
var statearr_21895_22033 = state_21770__$1;
(statearr_21895_22033[(1)] = (18));

} else {
var statearr_21896_22034 = state_21770__$1;
(statearr_21896_22034[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (81))){
var inst_21699 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21897_22035 = state_21770__$1;
(statearr_21897_22035[(2)] = inst_21699);

(statearr_21897_22035[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (79))){
var inst_21671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21672 = ["_id"];
var inst_21673 = flake.o;
var inst_21674 = [inst_21673];
var inst_21675 = cljs.core.PersistentHashMap.fromArrays(inst_21672,inst_21674);
var inst_21676 = [inst_21675,offset_map];
var inst_21677 = (new cljs.core.PersistentVector(null,2,(5),inst_21671,inst_21676,null));
var state_21770__$1 = state_21770;
var statearr_21898_22036 = state_21770__$1;
(statearr_21898_22036[(2)] = inst_21677);

(statearr_21898_22036[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (38))){
var inst_21730 = (state_21770[(25)]);
var inst_21729 = (state_21770[(2)]);
var inst_21730__$1 = cljs.core.nth.call(null,inst_21729,(0),null);
var inst_21731 = cljs.core.nth.call(null,inst_21729,(1),null);
var inst_21732 = (inst_21730__$1 == null);
var inst_21733 = cljs.core.not.call(null,inst_21732);
var state_21770__$1 = (function (){var statearr_21899 = state_21770;
(statearr_21899[(25)] = inst_21730__$1);

(statearr_21899[(26)] = inst_21731);

return statearr_21899;
})();
if(inst_21733){
var statearr_21900_22037 = state_21770__$1;
(statearr_21900_22037[(1)] = (95));

} else {
var statearr_21901_22038 = state_21770__$1;
(statearr_21901_22038[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (98))){
var inst_21730 = (state_21770[(25)]);
var inst_21508 = (state_21770[(15)]);
var inst_21731 = (state_21770[(26)]);
var inst_21739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21740 = cljs.core.PersistentVector.EMPTY;
var inst_21741 = cljs.core.get.call(null,acc,inst_21508,inst_21740);
var inst_21742 = cljs.core.conj.call(null,inst_21741,inst_21730);
var inst_21743 = cljs.core.assoc.call(null,acc,inst_21508,inst_21742);
var inst_21744 = [inst_21743,inst_21731];
var inst_21745 = (new cljs.core.PersistentVector(null,2,(5),inst_21739,inst_21744,null));
var state_21770__$1 = state_21770;
var statearr_21902_22039 = state_21770__$1;
(statearr_21902_22039[(2)] = inst_21745);

(statearr_21902_22039[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (87))){
var inst_21686 = (state_21770[(23)]);
var state_21770__$1 = state_21770;
var statearr_21903_22040 = state_21770__$1;
(statearr_21903_22040[(2)] = inst_21686);

(statearr_21903_22040[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (30))){
var inst_21534 = (state_21770[(20)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21534)){
var statearr_21904_22041 = state_21770__$1;
(statearr_21904_22041[(1)] = (33));

} else {
var statearr_21905_22042 = state_21770__$1;
(statearr_21905_22042[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (73))){
var inst_21650 = (state_21770[(31)]);
var state_21770__$1 = state_21770;
var statearr_21906_22043 = state_21770__$1;
(statearr_21906_22043[(2)] = inst_21650);

(statearr_21906_22043[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (96))){
var state_21770__$1 = state_21770;
var statearr_21907_22044 = state_21770__$1;
(statearr_21907_22044[(2)] = false);

(statearr_21907_22044[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (10))){
var state_21770__$1 = state_21770;
var statearr_21908_22045 = state_21770__$1;
(statearr_21908_22045[(2)] = pred_spec);

(statearr_21908_22045[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (18))){
var inst_21501 = (state_21770[(33)]);
var state_21770__$1 = state_21770;
var statearr_21909_22046 = state_21770__$1;
(statearr_21909_22046[(2)] = inst_21501);

(statearr_21909_22046[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (105))){
var state_21770__$1 = state_21770;
var statearr_21910_22047 = state_21770__$1;
(statearr_21910_22047[(2)] = null);

(statearr_21910_22047[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (52))){
var inst_21497 = (state_21770[(7)]);
var inst_21580 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21497);
var state_21770__$1 = state_21770;
var statearr_21911_22048 = state_21770__$1;
(statearr_21911_22048[(2)] = inst_21580);

(statearr_21911_22048[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (67))){
var inst_21723 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21912_22049 = state_21770__$1;
(statearr_21912_22049[(2)] = inst_21723);

(statearr_21912_22049[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (71))){
var inst_21497 = (state_21770[(7)]);
var inst_21635 = (state_21770[(2)]);
var inst_21636 = fluree.db.util.async.throw_err.call(null,inst_21635);
var inst_21637 = cljs.core._deref.call(null,cache);
var inst_21638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21639 = flake.o;
var inst_21640 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21497);
var inst_21641 = [inst_21639,inst_21640];
var inst_21642 = (new cljs.core.PersistentVector(null,2,(5),inst_21638,inst_21641,null));
var inst_21643 = cljs.core.assoc.call(null,inst_21637,inst_21642,inst_21636);
var inst_21644 = cljs.core._vreset_BANG_.call(null,cache,inst_21643);
var state_21770__$1 = (function (){var statearr_21913 = state_21770;
(statearr_21913[(34)] = inst_21644);

return statearr_21913;
})();
var statearr_21914_22050 = state_21770__$1;
(statearr_21914_22050[(2)] = inst_21636);

(statearr_21914_22050[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (42))){
var inst_21532 = (state_21770[(10)]);
var inst_21508 = (state_21770[(15)]);
var inst_21533 = (state_21770[(16)]);
var inst_21562 = cljs.core.not.call(null,inst_21533);
var inst_21563 = cljs.core.get.call(null,acc,inst_21508);
var inst_21564 = cljs.core.count.call(null,inst_21563);
var inst_21565 = (inst_21564 >= inst_21532);
var inst_21566 = ((inst_21562) && (inst_21565));
var state_21770__$1 = state_21770;
var statearr_21915_22051 = state_21770__$1;
(statearr_21915_22051[(2)] = inst_21566);

(statearr_21915_22051[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (80))){
var inst_21679 = cljs.core.PersistentVector.EMPTY_NODE;
var state_21770__$1 = (function (){var statearr_21916 = state_21770;
(statearr_21916[(32)] = inst_21679);

return statearr_21916;
})();
if(cljs.core.truth_(fuel)){
var statearr_21917_22052 = state_21770__$1;
(statearr_21917_22052[(1)] = (83));

} else {
var statearr_21918_22053 = state_21770__$1;
(statearr_21918_22053[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (37))){
var inst_21530 = (state_21770[(14)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21530)){
var statearr_21919_22054 = state_21770__$1;
(statearr_21919_22054[(1)] = (42));

} else {
var statearr_21920_22055 = state_21770__$1;
(statearr_21920_22055[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (63))){
var inst_21606 = (state_21770[(17)]);
var state_21770__$1 = state_21770;
var statearr_21921_22056 = state_21770__$1;
(statearr_21921_22056[(2)] = inst_21606);

(statearr_21921_22056[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (94))){
var inst_21717 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
var statearr_21922_22057 = state_21770__$1;
(statearr_21922_22057[(2)] = inst_21717);

(statearr_21922_22057[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (8))){
var inst_21484 = (state_21770[(2)]);
var state_21770__$1 = state_21770;
if(cljs.core.truth_(inst_21484)){
var statearr_21923_22058 = state_21770__$1;
(statearr_21923_22058[(1)] = (9));

} else {
var statearr_21924_22059 = state_21770__$1;
(statearr_21924_22059[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (49))){
var state_21770__$1 = state_21770;
var statearr_21925_22060 = state_21770__$1;
(statearr_21925_22060[(2)] = false);

(statearr_21925_22060[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21771 === (84))){
var inst_21668 = (state_21770[(24)]);
var state_21770__$1 = state_21770;
var statearr_21926_22061 = state_21770__$1;
(statearr_21926_22061[(2)] = inst_21668);

(statearr_21926_22061[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2454__auto__ = null;
var fluree$db$query$fql$state_machine__2454__auto____0 = (function (){
var statearr_21927 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21927[(0)] = fluree$db$query$fql$state_machine__2454__auto__);

(statearr_21927[(1)] = (1));

return statearr_21927;
});
var fluree$db$query$fql$state_machine__2454__auto____1 = (function (state_21770){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_21770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e21928){var ex__2457__auto__ = e21928;
var statearr_21929_22062 = state_21770;
(statearr_21929_22062[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_21770[(4)]))){
var statearr_21930_22063 = state_21770;
(statearr_21930_22063[(1)] = cljs.core.first.call(null,(state_21770[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22064 = state_21770;
state_21770 = G__22064;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2454__auto__ = function(state_21770){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2454__auto____1.call(this,state_21770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2454__auto____0;
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2454__auto____1;
return fluree$db$query$fql$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_21931 = f__2477__auto__.call(null);
(statearr_21931[(6)] = c__2476__auto__);

return statearr_21931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_22244){
var state_val_22245 = (state_22244[(1)]);
if((state_val_22245 === (7))){
var inst_22239 = (state_22244[(2)]);
var _ = (function (){var statearr_22246 = state_22244;
(statearr_22246[(4)] = cljs.core.rest.call(null,(state_22244[(4)])));

return statearr_22246;
})();
var state_22244__$1 = state_22244;
var statearr_22247_22342 = state_22244__$1;
(statearr_22247_22342[(2)] = inst_22239);

(statearr_22247_22342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (59))){
var inst_22125 = (state_22244[(7)]);
var state_22244__$1 = state_22244;
var statearr_22248_22343 = state_22244__$1;
(statearr_22248_22343[(2)] = inst_22125);

(statearr_22248_22343[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (20))){
var inst_22134 = (state_22244[(8)]);
var inst_22131 = (state_22244[(2)]);
var inst_22132 = fluree.db.util.async.throw_err.call(null,inst_22131);
var inst_22133 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_22132);
var inst_22134__$1 = cljs.core.not_empty.call(null,inst_22133);
var state_22244__$1 = (function (){var statearr_22249 = state_22244;
(statearr_22249[(8)] = inst_22134__$1);

return statearr_22249;
})();
if(cljs.core.truth_(inst_22134__$1)){
var statearr_22250_22344 = state_22244__$1;
(statearr_22250_22344[(1)] = (21));

} else {
var statearr_22251_22345 = state_22244__$1;
(statearr_22251_22345[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (58))){
var inst_22124 = (state_22244[(9)]);
var state_22244__$1 = state_22244;
var statearr_22252_22346 = state_22244__$1;
(statearr_22252_22346[(2)] = inst_22124);

(statearr_22252_22346[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (60))){
var inst_22231 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22253_22347 = state_22244__$1;
(statearr_22253_22347[(2)] = inst_22231);

(statearr_22253_22347[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (27))){
var inst_22156 = (state_22244[(10)]);
var inst_22164 = (state_22244[(11)]);
var inst_22166 = (state_22244[(12)]);
var inst_22163 = cljs.core.seq.call(null,inst_22156);
var inst_22164__$1 = cljs.core.first.call(null,inst_22163);
var inst_22165 = cljs.core.next.call(null,inst_22163);
var inst_22166__$1 = cljs.core.not.call(null,inst_22164__$1);
var state_22244__$1 = (function (){var statearr_22254 = state_22244;
(statearr_22254[(11)] = inst_22164__$1);

(statearr_22254[(12)] = inst_22166__$1);

(statearr_22254[(13)] = inst_22165);

return statearr_22254;
})();
if(inst_22166__$1){
var statearr_22255_22348 = state_22244__$1;
(statearr_22255_22348[(1)] = (29));

} else {
var statearr_22256_22349 = state_22244__$1;
(statearr_22256_22349[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (1))){
var state_22244__$1 = state_22244;
var statearr_22257_22350 = state_22244__$1;
(statearr_22257_22350[(2)] = null);

(statearr_22257_22350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (24))){
var inst_22134 = (state_22244[(8)]);
var inst_22140 = cljs.core.count.call(null,inst_22134);
var inst_22141 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22140,max_fuel);
var state_22244__$1 = state_22244;
var statearr_22258_22351 = state_22244__$1;
(statearr_22258_22351[(2)] = inst_22141);

(statearr_22258_22351[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (55))){
var inst_22123 = (state_22244[(14)]);
var state_22244__$1 = state_22244;
var statearr_22259_22352 = state_22244__$1;
(statearr_22259_22352[(2)] = inst_22123);

(statearr_22259_22352[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (39))){
var inst_22121 = (state_22244[(15)]);
var state_22244__$1 = state_22244;
var statearr_22260_22353 = state_22244__$1;
(statearr_22260_22353[(2)] = inst_22121);

(statearr_22260_22353[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (46))){
var inst_22219 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22261_22354 = state_22244__$1;
(statearr_22261_22354[(2)] = inst_22219);

(statearr_22261_22354[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (4))){
var inst_22065 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22262_22355 = state_22244__$1;
(statearr_22262_22355[(2)] = inst_22065);

(statearr_22262_22355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (54))){
var inst_22158 = (state_22244[(16)]);
var inst_22210 = (state_22244[(2)]);
var inst_22211 = fluree.db.util.async.throw_err.call(null,inst_22210);
var inst_22212 = cljs.core.conj.call(null,inst_22158,inst_22211);
var state_22244__$1 = state_22244;
var statearr_22263_22356 = state_22244__$1;
(statearr_22263_22356[(2)] = inst_22212);

(statearr_22263_22356[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (15))){
var state_22244__$1 = state_22244;
var statearr_22264_22357 = state_22244__$1;
(statearr_22264_22357[(2)] = false);

(statearr_22264_22357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (48))){
var inst_22158 = (state_22244[(16)]);
var state_22244__$1 = state_22244;
var statearr_22265_22358 = state_22244__$1;
(statearr_22265_22358[(2)] = inst_22158);

(statearr_22265_22358[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (50))){
var inst_22157 = (state_22244[(17)]);
var inst_22165 = (state_22244[(13)]);
var inst_22214 = (state_22244[(2)]);
var inst_22215 = (inst_22157 + (1));
var inst_22156 = inst_22165;
var inst_22157__$1 = inst_22215;
var inst_22158 = inst_22214;
var state_22244__$1 = (function (){var statearr_22266 = state_22244;
(statearr_22266[(10)] = inst_22156);

(statearr_22266[(16)] = inst_22158);

(statearr_22266[(17)] = inst_22157__$1);

return statearr_22266;
})();
var statearr_22267_22359 = state_22244__$1;
(statearr_22267_22359[(2)] = null);

(statearr_22267_22359[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (21))){
var state_22244__$1 = state_22244;
var statearr_22268_22360 = state_22244__$1;
(statearr_22268_22360[(2)] = fuel);

(statearr_22268_22360[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (31))){
var inst_22175 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22175)){
var statearr_22269_22361 = state_22244__$1;
(statearr_22269_22361[(1)] = (35));

} else {
var statearr_22270_22362 = state_22244__$1;
(statearr_22270_22362[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (32))){
var inst_22122 = (state_22244[(18)]);
var inst_22157 = (state_22244[(17)]);
var inst_22170 = (inst_22157 >= inst_22122);
var state_22244__$1 = state_22244;
var statearr_22271_22363 = state_22244__$1;
(statearr_22271_22363[(2)] = inst_22170);

(statearr_22271_22363[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (40))){
var inst_22182 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22182)){
var statearr_22272_22364 = state_22244__$1;
(statearr_22272_22364[(1)] = (41));

} else {
var statearr_22273_22365 = state_22244__$1;
(statearr_22273_22365[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (56))){
var inst_22124 = (state_22244[(9)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22124)){
var statearr_22274_22366 = state_22244__$1;
(statearr_22274_22366[(1)] = (58));

} else {
var statearr_22275_22367 = state_22244__$1;
(statearr_22275_22367[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (33))){
var inst_22122 = (state_22244[(18)]);
var state_22244__$1 = state_22244;
var statearr_22276_22368 = state_22244__$1;
(statearr_22276_22368[(2)] = inst_22122);

(statearr_22276_22368[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (13))){
var inst_22115 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22115)){
var statearr_22277_22369 = state_22244__$1;
(statearr_22277_22369[(1)] = (17));

} else {
var statearr_22278_22370 = state_22244__$1;
(statearr_22278_22370[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (22))){
var inst_22134 = (state_22244[(8)]);
var state_22244__$1 = state_22244;
var statearr_22280_22371 = state_22244__$1;
(statearr_22280_22371[(2)] = inst_22134);

(statearr_22280_22371[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (36))){
var inst_22121 = (state_22244[(15)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22121)){
var statearr_22281_22372 = state_22244__$1;
(statearr_22281_22372[(1)] = (38));

} else {
var statearr_22282_22373 = state_22244__$1;
(statearr_22282_22373[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (41))){
var inst_22158 = (state_22244[(16)]);
var inst_22157 = (state_22244[(17)]);
var inst_22165 = (state_22244[(13)]);
var inst_22184 = (inst_22157 + (1));
var tmp22279 = inst_22158;
var inst_22156 = inst_22165;
var inst_22157__$1 = inst_22184;
var inst_22158__$1 = tmp22279;
var state_22244__$1 = (function (){var statearr_22283 = state_22244;
(statearr_22283[(10)] = inst_22156);

(statearr_22283[(16)] = inst_22158__$1);

(statearr_22283[(17)] = inst_22157__$1);

return statearr_22283;
})();
var statearr_22284_22374 = state_22244__$1;
(statearr_22284_22374[(2)] = null);

(statearr_22284_22374[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (43))){
var inst_22221 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22285_22375 = state_22244__$1;
(statearr_22285_22375[(2)] = inst_22221);

(statearr_22285_22375[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (29))){
var inst_22166 = (state_22244[(12)]);
var state_22244__$1 = state_22244;
var statearr_22286_22376 = state_22244__$1;
(statearr_22286_22376[(2)] = inst_22166);

(statearr_22286_22376[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (44))){
var inst_22164 = (state_22244[(11)]);
var inst_22188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22189 = [inst_22164];
var inst_22190 = (new cljs.core.PersistentVector(null,1,(5),inst_22188,inst_22189,null));
var inst_22191 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22190);
var state_22244__$1 = state_22244;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22244__$1,(47),inst_22191);
} else {
if((state_val_22245 === (6))){
var inst_22082 = (state_22244[(19)]);
var inst_22089 = (state_22244[(20)]);
var inst_22088 = cljs.core.seq.call(null,inst_22082);
var inst_22089__$1 = cljs.core.first.call(null,inst_22088);
var inst_22090 = cljs.core.next.call(null,inst_22088);
var inst_22091 = cljs.core.not.call(null,inst_22089__$1);
var state_22244__$1 = (function (){var statearr_22287 = state_22244;
(statearr_22287[(20)] = inst_22089__$1);

(statearr_22287[(21)] = inst_22090);

return statearr_22287;
})();
if(inst_22091){
var statearr_22288_22377 = state_22244__$1;
(statearr_22288_22377[(1)] = (8));

} else {
var statearr_22289_22378 = state_22244__$1;
(statearr_22289_22378[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (28))){
var inst_22123 = (state_22244[(14)]);
var inst_22225 = (state_22244[(2)]);
var state_22244__$1 = (function (){var statearr_22290 = state_22244;
(statearr_22290[(22)] = inst_22225);

return statearr_22290;
})();
if(cljs.core.truth_(inst_22123)){
var statearr_22291_22379 = state_22244__$1;
(statearr_22291_22379[(1)] = (55));

} else {
var statearr_22292_22380 = state_22244__$1;
(statearr_22292_22380[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (51))){
var inst_22194 = (state_22244[(23)]);
var inst_22203 = cljs.core.count.call(null,inst_22194);
var inst_22204 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22203,max_fuel);
var state_22244__$1 = state_22244;
var statearr_22293_22381 = state_22244__$1;
(statearr_22293_22381[(2)] = inst_22204);

(statearr_22293_22381[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (25))){
var state_22244__$1 = state_22244;
var statearr_22294_22382 = state_22244__$1;
(statearr_22294_22382[(2)] = null);

(statearr_22294_22382[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (34))){
var inst_22173 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22295_22383 = state_22244__$1;
(statearr_22295_22383[(2)] = inst_22173);

(statearr_22295_22383[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (17))){
var inst_22099 = (state_22244[(24)]);
var inst_22117 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22099);
var state_22244__$1 = state_22244;
var statearr_22296_22384 = state_22244__$1;
(statearr_22296_22384[(2)] = inst_22117);

(statearr_22296_22384[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (3))){
var inst_22242 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22244__$1,inst_22242);
} else {
if((state_val_22245 === (12))){
var state_22244__$1 = state_22244;
var statearr_22297_22385 = state_22244__$1;
(statearr_22297_22385[(2)] = false);

(statearr_22297_22385[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (2))){
var _ = (function (){var statearr_22298 = state_22244;
(statearr_22298[(4)] = cljs.core.cons.call(null,(5),(state_22244[(4)])));

return statearr_22298;
})();
var inst_22078 = reverse_refs_specs;
var inst_22079 = cljs.core.seq.call(null,inst_22078);
var inst_22080 = cljs.core.first.call(null,inst_22079);
var inst_22081 = cljs.core.next.call(null,inst_22079);
var inst_22082 = inst_22078;
var inst_22083 = null;
var state_22244__$1 = (function (){var statearr_22299 = state_22244;
(statearr_22299[(25)] = inst_22081);

(statearr_22299[(26)] = inst_22080);

(statearr_22299[(19)] = inst_22082);

(statearr_22299[(27)] = inst_22083);

return statearr_22299;
})();
var statearr_22300_22386 = state_22244__$1;
(statearr_22300_22386[(2)] = null);

(statearr_22300_22386[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (23))){
var inst_22138 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22138)){
var statearr_22301_22387 = state_22244__$1;
(statearr_22301_22387[(1)] = (24));

} else {
var statearr_22302_22388 = state_22244__$1;
(statearr_22302_22388[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (47))){
var inst_22194 = (state_22244[(23)]);
var inst_22099 = (state_22244[(24)]);
var inst_22193 = (state_22244[(2)]);
var inst_22194__$1 = fluree.db.util.async.throw_err.call(null,inst_22193);
var inst_22195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22196 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22197 = (new cljs.core.PersistentVector(null,4,(5),inst_22195,inst_22196,null));
var inst_22198 = cljs.core.select_keys.call(null,inst_22099,inst_22197);
var inst_22199 = cljs.core.empty_QMARK_.call(null,inst_22194__$1);
var state_22244__$1 = (function (){var statearr_22303 = state_22244;
(statearr_22303[(23)] = inst_22194__$1);

(statearr_22303[(28)] = inst_22198);

return statearr_22303;
})();
if(inst_22199){
var statearr_22304_22389 = state_22244__$1;
(statearr_22304_22389[(1)] = (48));

} else {
var statearr_22305_22390 = state_22244__$1;
(statearr_22305_22390[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (35))){
var inst_22158 = (state_22244[(16)]);
var state_22244__$1 = state_22244;
var statearr_22306_22391 = state_22244__$1;
(statearr_22306_22391[(2)] = inst_22158);

(statearr_22306_22391[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (19))){
var inst_22098 = (state_22244[(29)]);
var inst_22120 = (state_22244[(2)]);
var inst_22121 = cljs.core.get.call(null,inst_22120,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22122 = cljs.core.get.call(null,inst_22120,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22123 = cljs.core.get.call(null,inst_22120,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22124 = cljs.core.get.call(null,inst_22120,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22125 = cljs.core.get.call(null,inst_22120,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22127 = [subject_id,inst_22098];
var inst_22128 = (new cljs.core.PersistentVector(null,2,(5),inst_22126,inst_22127,null));
var inst_22129 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22128);
var state_22244__$1 = (function (){var statearr_22307 = state_22244;
(statearr_22307[(9)] = inst_22124);

(statearr_22307[(7)] = inst_22125);

(statearr_22307[(18)] = inst_22122);

(statearr_22307[(15)] = inst_22121);

(statearr_22307[(14)] = inst_22123);

return statearr_22307;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22244__$1,(20),inst_22129);
} else {
if((state_val_22245 === (57))){
var inst_22083 = (state_22244[(27)]);
var inst_22225 = (state_22244[(22)]);
var inst_22090 = (state_22244[(21)]);
var inst_22233 = (state_22244[(2)]);
var inst_22234 = cljs.core.assoc.call(null,inst_22083,inst_22233,inst_22225);
var inst_22082 = inst_22090;
var inst_22083__$1 = inst_22234;
var state_22244__$1 = (function (){var statearr_22308 = state_22244;
(statearr_22308[(19)] = inst_22082);

(statearr_22308[(27)] = inst_22083__$1);

return statearr_22308;
})();
var statearr_22309_22392 = state_22244__$1;
(statearr_22309_22392[(2)] = null);

(statearr_22309_22392[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (11))){
var inst_22099 = (state_22244[(24)]);
var inst_22104 = inst_22099.cljs$lang$protocol_mask$partition0$;
var inst_22105 = (inst_22104 & (64));
var inst_22106 = inst_22099.cljs$core$ISeq$;
var inst_22107 = (cljs.core.PROTOCOL_SENTINEL === inst_22106);
var inst_22108 = ((inst_22105) || (inst_22107));
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22108)){
var statearr_22311_22393 = state_22244__$1;
(statearr_22311_22393[(1)] = (14));

} else {
var statearr_22312_22394 = state_22244__$1;
(statearr_22312_22394[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (9))){
var inst_22089 = (state_22244[(20)]);
var inst_22099 = (state_22244[(24)]);
var inst_22098 = cljs.core.nth.call(null,inst_22089,(0),null);
var inst_22099__$1 = cljs.core.nth.call(null,inst_22089,(1),null);
var inst_22101 = (inst_22099__$1 == null);
var inst_22102 = cljs.core.not.call(null,inst_22101);
var state_22244__$1 = (function (){var statearr_22313 = state_22244;
(statearr_22313[(24)] = inst_22099__$1);

(statearr_22313[(29)] = inst_22098);

return statearr_22313;
})();
if(inst_22102){
var statearr_22314_22395 = state_22244__$1;
(statearr_22314_22395[(1)] = (11));

} else {
var statearr_22315_22396 = state_22244__$1;
(statearr_22315_22396[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (5))){
var _ = (function (){var statearr_22316 = state_22244;
(statearr_22316[(4)] = cljs.core.rest.call(null,(state_22244[(4)])));

return statearr_22316;
})();
var state_22244__$1 = state_22244;
var ex22310 = (state_22244__$1[(2)]);
var statearr_22317_22397 = state_22244__$1;
(statearr_22317_22397[(5)] = ex22310);


if((ex22310 instanceof Error)){
var statearr_22318_22398 = state_22244__$1;
(statearr_22318_22398[(1)] = (4));

(statearr_22318_22398[(5)] = null);

} else {
throw ex22310;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (14))){
var state_22244__$1 = state_22244;
var statearr_22319_22399 = state_22244__$1;
(statearr_22319_22399[(2)] = true);

(statearr_22319_22399[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (45))){
var state_22244__$1 = state_22244;
var statearr_22320_22400 = state_22244__$1;
(statearr_22320_22400[(2)] = null);

(statearr_22320_22400[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (53))){
var inst_22194 = (state_22244[(23)]);
var inst_22198 = (state_22244[(28)]);
var inst_22207 = (state_22244[(2)]);
var inst_22208 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22198,inst_22194);
var state_22244__$1 = (function (){var statearr_22321 = state_22244;
(statearr_22321[(30)] = inst_22207);

return statearr_22321;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22244__$1,(54),inst_22208);
} else {
if((state_val_22245 === (26))){
var inst_22134 = (state_22244[(8)]);
var inst_22144 = (state_22244[(2)]);
var inst_22152 = cljs.core.seq.call(null,inst_22134);
var inst_22153 = cljs.core.first.call(null,inst_22152);
var inst_22154 = cljs.core.next.call(null,inst_22152);
var inst_22155 = cljs.core.PersistentVector.EMPTY;
var inst_22156 = inst_22134;
var inst_22157 = (0);
var inst_22158 = inst_22155;
var state_22244__$1 = (function (){var statearr_22322 = state_22244;
(statearr_22322[(10)] = inst_22156);

(statearr_22322[(16)] = inst_22158);

(statearr_22322[(31)] = inst_22154);

(statearr_22322[(32)] = inst_22144);

(statearr_22322[(17)] = inst_22157);

(statearr_22322[(33)] = inst_22153);

return statearr_22322;
})();
var statearr_22323_22401 = state_22244__$1;
(statearr_22323_22401[(2)] = null);

(statearr_22323_22401[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (16))){
var inst_22112 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22324_22402 = state_22244__$1;
(statearr_22324_22402[(2)] = inst_22112);

(statearr_22324_22402[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (38))){
var inst_22157 = (state_22244[(17)]);
var inst_22121 = (state_22244[(15)]);
var inst_22179 = (inst_22157 < inst_22121);
var state_22244__$1 = state_22244;
var statearr_22325_22403 = state_22244__$1;
(statearr_22325_22403[(2)] = inst_22179);

(statearr_22325_22403[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (30))){
var inst_22122 = (state_22244[(18)]);
var state_22244__$1 = state_22244;
if(cljs.core.truth_(inst_22122)){
var statearr_22326_22404 = state_22244__$1;
(statearr_22326_22404[(1)] = (32));

} else {
var statearr_22327_22405 = state_22244__$1;
(statearr_22327_22405[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (10))){
var inst_22237 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22328_22406 = state_22244__$1;
(statearr_22328_22406[(2)] = inst_22237);

(statearr_22328_22406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (18))){
var inst_22099 = (state_22244[(24)]);
var state_22244__$1 = state_22244;
var statearr_22329_22407 = state_22244__$1;
(statearr_22329_22407[(2)] = inst_22099);

(statearr_22329_22407[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (52))){
var state_22244__$1 = state_22244;
var statearr_22330_22408 = state_22244__$1;
(statearr_22330_22408[(2)] = null);

(statearr_22330_22408[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (42))){
var state_22244__$1 = state_22244;
var statearr_22331_22409 = state_22244__$1;
(statearr_22331_22409[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (37))){
var inst_22223 = (state_22244[(2)]);
var state_22244__$1 = state_22244;
var statearr_22333_22410 = state_22244__$1;
(statearr_22333_22410[(2)] = inst_22223);

(statearr_22333_22410[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (8))){
var inst_22083 = (state_22244[(27)]);
var state_22244__$1 = state_22244;
var statearr_22334_22411 = state_22244__$1;
(statearr_22334_22411[(2)] = inst_22083);

(statearr_22334_22411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22245 === (49))){
var state_22244__$1 = state_22244;
if(cljs.core.truth_(fuel)){
var statearr_22335_22412 = state_22244__$1;
(statearr_22335_22412[(1)] = (51));

} else {
var statearr_22336_22413 = state_22244__$1;
(statearr_22336_22413[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____0 = (function (){
var statearr_22337 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22337[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__);

(statearr_22337[(1)] = (1));

return statearr_22337;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____1 = (function (state_22244){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_22244);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e22338){var ex__2457__auto__ = e22338;
var statearr_22339_22414 = state_22244;
(statearr_22339_22414[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_22244[(4)]))){
var statearr_22340_22415 = state_22244;
(statearr_22340_22415[(1)] = cljs.core.first.call(null,(state_22244[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22416 = state_22244;
state_22244 = G__22416;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__ = function(state_22244){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____1.call(this,state_22244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_22341 = f__2477__auto__.call(null);
(statearr_22341[(6)] = c__2476__auto__);

return statearr_22341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null),cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o.call(null,f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o.call(null,f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Keyword(null,"depth","depth",1768663640)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_22535){
var state_val_22536 = (state_22535[(1)]);
if((state_val_22536 === (7))){
var inst_22530 = (state_22535[(2)]);
var _ = (function (){var statearr_22537 = state_22535;
(statearr_22537[(4)] = cljs.core.rest.call(null,(state_22535[(4)])));

return statearr_22537;
})();
var state_22535__$1 = state_22535;
var statearr_22538_22593 = state_22535__$1;
(statearr_22538_22593[(2)] = inst_22530);

(statearr_22538_22593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (20))){
var inst_22472 = (state_22535[(7)]);
var state_22535__$1 = state_22535;
var statearr_22539_22594 = state_22535__$1;
(statearr_22539_22594[(2)] = inst_22472);

(statearr_22539_22594[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (27))){
var inst_22437 = (state_22535[(8)]);
var inst_22493 = (state_22535[(9)]);
var inst_22512 = (state_22535[(2)]);
var inst_22513 = cljs.core.nth.call(null,inst_22512,(0),null);
var inst_22514 = cljs.core.nth.call(null,inst_22512,(1),null);
var inst_22515 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22437);
var inst_22516 = fluree.db.query.fql.s.call(null,f);
var inst_22517 = cljs.core._EQ_.call(null,inst_22515,inst_22516);
var inst_22518 = cljs.core.empty_QMARK_.call(null,inst_22493);
var inst_22519 = ((inst_22517) || (inst_22518));
var state_22535__$1 = (function (){var statearr_22540 = state_22535;
(statearr_22540[(10)] = inst_22514);

(statearr_22540[(11)] = inst_22513);

return statearr_22540;
})();
if(cljs.core.truth_(inst_22519)){
var statearr_22541_22595 = state_22535__$1;
(statearr_22541_22595[(1)] = (30));

} else {
var statearr_22542_22596 = state_22535__$1;
(statearr_22542_22596[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (1))){
var state_22535__$1 = state_22535;
var statearr_22543_22597 = state_22535__$1;
(statearr_22543_22597[(2)] = null);

(statearr_22543_22597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (24))){
var inst_22437 = (state_22535[(8)]);
var inst_22493 = (state_22535[(9)]);
var inst_22493__$1 = (state_22535[(2)]);
var inst_22494 = cljs.core.get_in.call(null,inst_22437,inst_22493__$1);
var inst_22498 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22437);
var inst_22499 = fluree.db.query.fql.s.call(null,f);
var inst_22500 = cljs.core._EQ_.call(null,inst_22498,inst_22499);
var state_22535__$1 = (function (){var statearr_22544 = state_22535;
(statearr_22544[(9)] = inst_22493__$1);

(statearr_22544[(12)] = inst_22494);

return statearr_22544;
})();
if(inst_22500){
var statearr_22545_22598 = state_22535__$1;
(statearr_22545_22598[(1)] = (25));

} else {
var statearr_22546_22599 = state_22535__$1;
(statearr_22546_22599[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (4))){
var inst_22418 = (state_22535[(2)]);
var state_22535__$1 = state_22535;
var statearr_22547_22600 = state_22535__$1;
(statearr_22547_22600[(2)] = inst_22418);

(statearr_22547_22600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (15))){
var inst_22455 = (state_22535[(13)]);
var state_22535__$1 = state_22535;
var statearr_22548_22601 = state_22535__$1;
(statearr_22548_22601[(2)] = inst_22455);

(statearr_22548_22601[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (21))){
var inst_22481 = (state_22535[(2)]);
var state_22535__$1 = state_22535;
var statearr_22549_22602 = state_22535__$1;
(statearr_22549_22602[(2)] = inst_22481);

(statearr_22549_22602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (31))){
var inst_22437 = (state_22535[(8)]);
var inst_22493 = (state_22535[(9)]);
var inst_22513 = (state_22535[(11)]);
var inst_22522 = cljs.core.assoc_in.call(null,inst_22437,inst_22493,inst_22513);
var state_22535__$1 = state_22535;
var statearr_22550_22603 = state_22535__$1;
(statearr_22550_22603[(2)] = inst_22522);

(statearr_22550_22603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (32))){
var inst_22444 = (state_22535[(14)]);
var inst_22437 = (state_22535[(8)]);
var inst_22524 = (state_22535[(2)]);
var inst_22525 = cljs.core.conj.call(null,inst_22437,inst_22524);
var inst_22436 = inst_22444;
var inst_22437__$1 = inst_22525;
var state_22535__$1 = (function (){var statearr_22551 = state_22535;
(statearr_22551[(15)] = inst_22436);

(statearr_22551[(8)] = inst_22437__$1);

return statearr_22551;
})();
var statearr_22552_22604 = state_22535__$1;
(statearr_22552_22604[(2)] = null);

(statearr_22552_22604[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (13))){
var inst_22437 = (state_22535[(8)]);
var inst_22452 = (state_22535[(16)]);
var inst_22452__$1 = (state_22535[(2)]);
var inst_22453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22454 = [k];
var inst_22455 = (new cljs.core.PersistentVector(null,1,(5),inst_22453,inst_22454,null));
var inst_22456 = new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(inst_22437);
var inst_22457 = fluree.db.query.fql.s.call(null,f);
var inst_22458 = cljs.core.not_EQ_.call(null,inst_22456,inst_22457);
var inst_22459 = cljs.core.empty_QMARK_.call(null,inst_22452__$1);
var inst_22460 = (!(inst_22459));
var inst_22461 = ((inst_22458) && (inst_22460));
var state_22535__$1 = (function (){var statearr_22553 = state_22535;
(statearr_22553[(16)] = inst_22452__$1);

(statearr_22553[(13)] = inst_22455);

return statearr_22553;
})();
if(cljs.core.truth_(inst_22461)){
var statearr_22554_22605 = state_22535__$1;
(statearr_22554_22605[(1)] = (14));

} else {
var statearr_22555_22606 = state_22535__$1;
(statearr_22555_22606[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (22))){
var inst_22486 = (state_22535[(17)]);
var inst_22490 = cljs.core.drop_last.call(null,inst_22486);
var state_22535__$1 = state_22535;
var statearr_22556_22607 = state_22535__$1;
(statearr_22556_22607[(2)] = inst_22490);

(statearr_22556_22607[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (29))){
var inst_22509 = (state_22535[(2)]);
var inst_22510 = fluree.db.util.async.throw_err.call(null,inst_22509);
var state_22535__$1 = state_22535;
var statearr_22557_22608 = state_22535__$1;
(statearr_22557_22608[(2)] = inst_22510);

(statearr_22557_22608[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (6))){
var inst_22436 = (state_22535[(15)]);
var inst_22443 = (state_22535[(18)]);
var inst_22442 = cljs.core.seq.call(null,inst_22436);
var inst_22443__$1 = cljs.core.first.call(null,inst_22442);
var inst_22444 = cljs.core.next.call(null,inst_22442);
var inst_22445 = cljs.core.not.call(null,inst_22443__$1);
var state_22535__$1 = (function (){var statearr_22558 = state_22535;
(statearr_22558[(14)] = inst_22444);

(statearr_22558[(18)] = inst_22443__$1);

return statearr_22558;
})();
if(inst_22445){
var statearr_22559_22609 = state_22535__$1;
(statearr_22559_22609[(1)] = (8));

} else {
var statearr_22560_22610 = state_22535__$1;
(statearr_22560_22610[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (28))){
var inst_22504 = (state_22535[(2)]);
var inst_22505 = fluree.db.util.async.throw_err.call(null,inst_22504);
var state_22535__$1 = state_22535;
var statearr_22561_22611 = state_22535__$1;
(statearr_22561_22611[(2)] = inst_22505);

(statearr_22561_22611[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (25))){
var inst_22437 = (state_22535[(8)]);
var inst_22502 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_22437,pred_spec,f,component_follow_QMARK_,true);
var state_22535__$1 = state_22535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22535__$1,(28),inst_22502);
} else {
if((state_val_22536 === (17))){
var inst_22444 = (state_22535[(14)]);
var inst_22436 = (state_22535[(15)]);
var inst_22434 = (state_22535[(19)]);
var inst_22437 = (state_22535[(8)]);
var inst_22463 = (state_22535[(20)]);
var inst_22431 = (state_22535[(21)]);
var inst_22464 = (state_22535[(22)]);
var inst_22443 = (state_22535[(18)]);
var inst_22433 = (state_22535[(23)]);
var inst_22466 = cljs.core.get_in.call(null,inst_22437,inst_22464);
var inst_22467 = (function (){var G__22427 = inst_22436;
var seq__22440 = inst_22444;
var keys_SINGLEQUOTE_ = inst_22464;
var r = inst_22444;
var vec__22439 = inst_22436;
var vec__22428 = inst_22431;
var child_path = inst_22463;
var acc__$1 = inst_22437;
var value = inst_22466;
var seq__22429 = inst_22434;
var first__22441 = inst_22443;
var first__22430 = inst_22433;
return (function (p1__22417_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287).cljs$core$IFn$_invoke$arity$1(p1__22417_SHARP_),cljs.core.first.call(null,child_path));
});
})();
var inst_22468 = cljs.core.filter.call(null,inst_22467,inst_22466);
var inst_22469 = cljs.core.first.call(null,inst_22468);
var inst_22470 = inst_22466.indexOf(inst_22469);
var inst_22471 = cljs.core.conj.call(null,inst_22464,inst_22470);
var inst_22472 = cljs.core.conj.call(null,inst_22471,k);
var inst_22473 = cljs.core.rest.call(null,inst_22463);
var inst_22474 = cljs.core.count.call(null,inst_22473);
var inst_22475 = (inst_22474 > (0));
var state_22535__$1 = (function (){var statearr_22562 = state_22535;
(statearr_22562[(7)] = inst_22472);

return statearr_22562;
})();
if(cljs.core.truth_(inst_22475)){
var statearr_22563_22612 = state_22535__$1;
(statearr_22563_22612[(1)] = (19));

} else {
var statearr_22564_22613 = state_22535__$1;
(statearr_22564_22613[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (3))){
var inst_22533 = (state_22535[(2)]);
var state_22535__$1 = state_22535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22535__$1,inst_22533);
} else {
if((state_val_22536 === (12))){
var inst_22443 = (state_22535[(18)]);
var inst_22450 = cljs.core.drop_last.call(null,inst_22443);
var state_22535__$1 = state_22535;
var statearr_22565_22614 = state_22535__$1;
(statearr_22565_22614[(2)] = inst_22450);

(statearr_22565_22614[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (2))){
var inst_22431 = (state_22535[(21)]);
var _ = (function (){var statearr_22566 = state_22535;
(statearr_22566[(4)] = cljs.core.cons.call(null,(5),(state_22535[(4)])));

return statearr_22566;
})();
var inst_22431__$1 = new_child_paths;
var inst_22432 = cljs.core.seq.call(null,inst_22431__$1);
var inst_22433 = cljs.core.first.call(null,inst_22432);
var inst_22434 = cljs.core.next.call(null,inst_22432);
var inst_22435 = acc;
var inst_22436 = inst_22431__$1;
var inst_22437 = inst_22435;
var state_22535__$1 = (function (){var statearr_22567 = state_22535;
(statearr_22567[(15)] = inst_22436);

(statearr_22567[(19)] = inst_22434);

(statearr_22567[(8)] = inst_22437);

(statearr_22567[(21)] = inst_22431__$1);

(statearr_22567[(23)] = inst_22433);

return statearr_22567;
})();
var statearr_22568_22615 = state_22535__$1;
(statearr_22568_22615[(2)] = null);

(statearr_22568_22615[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (23))){
var inst_22486 = (state_22535[(17)]);
var state_22535__$1 = state_22535;
var statearr_22569_22616 = state_22535__$1;
(statearr_22569_22616[(2)] = inst_22486);

(statearr_22569_22616[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (19))){
var inst_22463 = (state_22535[(20)]);
var inst_22472 = (state_22535[(7)]);
var inst_22477 = cljs.core.rest.call(null,inst_22463);
var inst_22463__$1 = inst_22477;
var inst_22464 = inst_22472;
var state_22535__$1 = (function (){var statearr_22570 = state_22535;
(statearr_22570[(20)] = inst_22463__$1);

(statearr_22570[(22)] = inst_22464);

return statearr_22570;
})();
var statearr_22571_22617 = state_22535__$1;
(statearr_22571_22617[(2)] = null);

(statearr_22571_22617[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (11))){
var inst_22443 = (state_22535[(18)]);
var state_22535__$1 = state_22535;
var statearr_22573_22618 = state_22535__$1;
(statearr_22573_22618[(2)] = inst_22443);

(statearr_22573_22618[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (9))){
var state_22535__$1 = state_22535;
if(cljs.core.truth_(parent_exists)){
var statearr_22574_22619 = state_22535__$1;
(statearr_22574_22619[(1)] = (11));

} else {
var statearr_22575_22620 = state_22535__$1;
(statearr_22575_22620[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (5))){
var _ = (function (){var statearr_22576 = state_22535;
(statearr_22576[(4)] = cljs.core.rest.call(null,(state_22535[(4)])));

return statearr_22576;
})();
var state_22535__$1 = state_22535;
var ex22572 = (state_22535__$1[(2)]);
var statearr_22577_22621 = state_22535__$1;
(statearr_22577_22621[(5)] = ex22572);


if((ex22572 instanceof Error)){
var statearr_22578_22622 = state_22535__$1;
(statearr_22578_22622[(1)] = (4));

(statearr_22578_22622[(5)] = null);

} else {
throw ex22572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (14))){
var inst_22452 = (state_22535[(16)]);
var inst_22455 = (state_22535[(13)]);
var inst_22463 = inst_22452;
var inst_22464 = inst_22455;
var state_22535__$1 = (function (){var statearr_22579 = state_22535;
(statearr_22579[(20)] = inst_22463);

(statearr_22579[(22)] = inst_22464);

return statearr_22579;
})();
var statearr_22580_22623 = state_22535__$1;
(statearr_22580_22623[(2)] = null);

(statearr_22580_22623[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (26))){
var inst_22494 = (state_22535[(12)]);
var inst_22507 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_22494,pred_spec,f,component_follow_QMARK_,true);
var state_22535__$1 = state_22535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22535__$1,(29),inst_22507);
} else {
if((state_val_22536 === (16))){
var inst_22486 = (state_22535[(17)]);
var inst_22486__$1 = (state_22535[(2)]);
var inst_22487 = cljs.core.count.call(null,inst_22486__$1);
var inst_22488 = (inst_22487 > (1));
var state_22535__$1 = (function (){var statearr_22581 = state_22535;
(statearr_22581[(17)] = inst_22486__$1);

return statearr_22581;
})();
if(cljs.core.truth_(inst_22488)){
var statearr_22582_22624 = state_22535__$1;
(statearr_22582_22624[(1)] = (22));

} else {
var statearr_22583_22625 = state_22535__$1;
(statearr_22583_22625[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (30))){
var inst_22513 = (state_22535[(11)]);
var state_22535__$1 = state_22535;
var statearr_22584_22626 = state_22535__$1;
(statearr_22584_22626[(2)] = inst_22513);

(statearr_22584_22626[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (10))){
var inst_22528 = (state_22535[(2)]);
var state_22535__$1 = state_22535;
var statearr_22585_22627 = state_22535__$1;
(statearr_22585_22627[(2)] = inst_22528);

(statearr_22585_22627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (18))){
var inst_22483 = (state_22535[(2)]);
var state_22535__$1 = state_22535;
var statearr_22586_22628 = state_22535__$1;
(statearr_22586_22628[(2)] = inst_22483);

(statearr_22586_22628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22536 === (8))){
var inst_22437 = (state_22535[(8)]);
var state_22535__$1 = state_22535;
var statearr_22587_22629 = state_22535__$1;
(statearr_22587_22629[(2)] = inst_22437);

(statearr_22587_22629[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____0 = (function (){
var statearr_22588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22588[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__);

(statearr_22588[(1)] = (1));

return statearr_22588;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____1 = (function (state_22535){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_22535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e22589){var ex__2457__auto__ = e22589;
var statearr_22590_22630 = state_22535;
(statearr_22590_22630[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_22535[(4)]))){
var statearr_22591_22631 = state_22535;
(statearr_22591_22631[(1)] = cljs.core.first.call(null,(state_22535[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22632 = state_22535;
state_22535 = G__22632;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__ = function(state_22535){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____1.call(this,state_22535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_22592 = f__2477__auto__.call(null);
(statearr_22592[(6)] = c__2476__auto__);

return statearr_22592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_22745){
var state_val_22746 = (state_22745[(1)]);
if((state_val_22746 === (7))){
var inst_22648 = (state_22745[(7)]);
var inst_22648__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22745__$1 = (function (){var statearr_22747 = state_22745;
(statearr_22747[(7)] = inst_22648__$1);

return statearr_22747;
})();
if(cljs.core.truth_(inst_22648__$1)){
var statearr_22748_22814 = state_22745__$1;
(statearr_22748_22814[(1)] = (9));

} else {
var statearr_22749_22815 = state_22745__$1;
(statearr_22749_22815[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (20))){
var inst_22655 = (state_22745[(8)]);
var inst_22643 = (state_22745[(9)]);
var inst_22665 = (state_22745[(10)]);
var inst_22697 = (state_22745[(2)]);
var inst_22698 = fluree.db.query.fql.add_in_multi_flakes.call(null,inst_22643,inst_22665,inst_22655,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_22745__$1 = (function (){var statearr_22750 = state_22745;
(statearr_22750[(11)] = inst_22697);

return statearr_22750;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22745__$1,(25),inst_22698);
} else {
if((state_val_22746 === (27))){
var inst_22667 = (state_22745[(12)]);
var inst_22704 = cljs.core.not.call(null,inst_22667);
var state_22745__$1 = state_22745;
var statearr_22751_22816 = state_22745__$1;
(statearr_22751_22816[(2)] = inst_22704);

(statearr_22751_22816[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (1))){
var state_22745__$1 = state_22745;
var statearr_22752_22817 = state_22745__$1;
(statearr_22752_22817[(2)] = null);

(statearr_22752_22817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (24))){
var inst_22691 = (state_22745[(2)]);
var inst_22692 = fluree.db.util.async.throw_err.call(null,inst_22691);
var state_22745__$1 = state_22745;
var statearr_22753_22818 = state_22745__$1;
(statearr_22753_22818[(2)] = inst_22692);

(statearr_22753_22818[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (39))){
var inst_22723 = (state_22745[(13)]);
var inst_22725 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22726 = cljs.core.sequence.call(null,inst_22725,inst_22723);
var state_22745__$1 = state_22745;
var statearr_22754_22819 = state_22745__$1;
(statearr_22754_22819[(2)] = inst_22726);

(statearr_22754_22819[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (4))){
var inst_22633 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
var statearr_22755_22820 = state_22745__$1;
(statearr_22755_22820[(2)] = inst_22633);

(statearr_22755_22820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (15))){
var inst_22673 = (state_22745[(14)]);
var state_22745__$1 = state_22745;
var statearr_22756_22821 = state_22745__$1;
(statearr_22756_22821[(2)] = inst_22673);

(statearr_22756_22821[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (21))){
var inst_22686 = (state_22745[(15)]);
var inst_22688 = f.o;
var inst_22689 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_22688,inst_22686);
var state_22745__$1 = state_22745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22745__$1,(24),inst_22689);
} else {
if((state_val_22746 === (31))){
var inst_22666 = (state_22745[(16)]);
var inst_22701 = (state_22745[(17)]);
var inst_22737 = (state_22745[(2)]);
var inst_22738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22739 = [inst_22701,inst_22737,inst_22666];
var inst_22740 = (new cljs.core.PersistentVector(null,3,(5),inst_22738,inst_22739,null));
var _ = (function (){var statearr_22757 = state_22745;
(statearr_22757[(4)] = cljs.core.rest.call(null,(state_22745[(4)])));

return statearr_22757;
})();
var state_22745__$1 = state_22745;
var statearr_22758_22822 = state_22745__$1;
(statearr_22758_22822[(2)] = inst_22740);

(statearr_22758_22822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (32))){
var inst_22697 = (state_22745[(11)]);
var inst_22711 = cljs.core.rest.call(null,flakes);
var inst_22712 = cljs.core.concat.call(null,inst_22711,inst_22697);
var state_22745__$1 = state_22745;
var statearr_22759_22823 = state_22745__$1;
(statearr_22759_22823[(2)] = inst_22712);

(statearr_22759_22823[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (40))){
var inst_22723 = (state_22745[(13)]);
var state_22745__$1 = state_22745;
var statearr_22760_22824 = state_22745__$1;
(statearr_22760_22824[(2)] = inst_22723);

(statearr_22760_22824[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (33))){
var state_22745__$1 = state_22745;
var statearr_22761_22825 = state_22745__$1;
(statearr_22761_22825[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (13))){
var state_22745__$1 = state_22745;
var statearr_22763_22826 = state_22745__$1;
(statearr_22763_22826[(2)] = false);

(statearr_22763_22826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (22))){
var state_22745__$1 = state_22745;
var statearr_22764_22827 = state_22745__$1;
(statearr_22764_22827[(2)] = null);

(statearr_22764_22827[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (36))){
var state_22745__$1 = state_22745;
var statearr_22765_22828 = state_22745__$1;
(statearr_22765_22828[(2)] = null);

(statearr_22765_22828[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (41))){
var inst_22715 = (state_22745[(18)]);
var inst_22729 = (state_22745[(2)]);
var inst_22730 = cljs.core.concat.call(null,inst_22715,inst_22729);
var state_22745__$1 = state_22745;
var statearr_22766_22829 = state_22745__$1;
(statearr_22766_22829[(2)] = inst_22730);

(statearr_22766_22829[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (29))){
var inst_22708 = cljs.core.rest.call(null,flakes);
var state_22745__$1 = state_22745;
var statearr_22767_22830 = state_22745__$1;
(statearr_22767_22830[(2)] = inst_22708);

(statearr_22767_22830[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (6))){
var inst_22645 = (state_22745[(19)]);
var state_22745__$1 = state_22745;
var statearr_22768_22831 = state_22745__$1;
(statearr_22768_22831[(2)] = inst_22645);

(statearr_22768_22831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (28))){
var inst_22706 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
if(cljs.core.truth_(inst_22706)){
var statearr_22769_22832 = state_22745__$1;
(statearr_22769_22832[(1)] = (29));

} else {
var statearr_22770_22833 = state_22745__$1;
(statearr_22770_22833[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (25))){
var inst_22673 = (state_22745[(14)]);
var inst_22700 = (state_22745[(2)]);
var inst_22701 = fluree.db.util.async.throw_err.call(null,inst_22700);
var state_22745__$1 = (function (){var statearr_22771 = state_22745;
(statearr_22771[(17)] = inst_22701);

return statearr_22771;
})();
if(cljs.core.truth_(inst_22673)){
var statearr_22772_22834 = state_22745__$1;
(statearr_22772_22834[(1)] = (26));

} else {
var statearr_22773_22835 = state_22745__$1;
(statearr_22773_22835[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (34))){
var inst_22735 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
var statearr_22774_22836 = state_22745__$1;
(statearr_22774_22836[(2)] = inst_22735);

(statearr_22774_22836[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (17))){
var inst_22678 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
if(cljs.core.truth_(inst_22678)){
var statearr_22775_22837 = state_22745__$1;
(statearr_22775_22837[(1)] = (18));

} else {
var statearr_22776_22838 = state_22745__$1;
(statearr_22776_22838[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (3))){
var inst_22743 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22745__$1,inst_22743);
} else {
if((state_val_22746 === (12))){
var inst_22659 = (state_22745[(20)]);
var state_22745__$1 = state_22745;
var statearr_22777_22839 = state_22745__$1;
(statearr_22777_22839[(2)] = inst_22659);

(statearr_22777_22839[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (2))){
var inst_22645 = (state_22745[(19)]);
var _ = (function (){var statearr_22778 = state_22745;
(statearr_22778[(4)] = cljs.core.cons.call(null,(5),(state_22745[(4)])));

return statearr_22778;
})();
var inst_22642 = fluree.db.query.fql.s.call(null,f);
var inst_22643 = cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22642);
var inst_22644 = fluree.db.query.fql.o.call(null,f);
var inst_22645__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22745__$1 = (function (){var statearr_22779 = state_22745;
(statearr_22779[(9)] = inst_22643);

(statearr_22779[(21)] = inst_22644);

(statearr_22779[(19)] = inst_22645__$1);

return statearr_22779;
})();
if(cljs.core.truth_(inst_22645__$1)){
var statearr_22780_22840 = state_22745__$1;
(statearr_22780_22840[(1)] = (6));

} else {
var statearr_22781_22841 = state_22745__$1;
(statearr_22781_22841[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (23))){
var inst_22695 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
var statearr_22782_22842 = state_22745__$1;
(statearr_22782_22842[(2)] = inst_22695);

(statearr_22782_22842[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (35))){
var inst_22644 = (state_22745[(21)]);
var inst_22715 = cljs.core.rest.call(null,flakes);
var inst_22717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22718 = [inst_22644];
var inst_22719 = (new cljs.core.PersistentVector(null,1,(5),inst_22717,inst_22718,null));
var inst_22720 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22719);
var state_22745__$1 = (function (){var statearr_22783 = state_22745;
(statearr_22783[(18)] = inst_22715);

return statearr_22783;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22745__$1,(38),inst_22720);
} else {
if((state_val_22746 === (19))){
var inst_22686 = (state_22745[(15)]);
var inst_22666 = (state_22745[(16)]);
var inst_22681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22682 = f.p;
var inst_22683 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_22682];
var inst_22684 = (new cljs.core.PersistentVector(null,2,(5),inst_22681,inst_22683,null));
var inst_22685 = cljs.core.get_in.call(null,inst_22666,inst_22684);
var inst_22686__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_22685);
var state_22745__$1 = (function (){var statearr_22784 = state_22745;
(statearr_22784[(15)] = inst_22686__$1);

return statearr_22784;
})();
if(cljs.core.truth_(inst_22686__$1)){
var statearr_22785_22843 = state_22745__$1;
(statearr_22785_22843[(1)] = (21));

} else {
var statearr_22786_22844 = state_22745__$1;
(statearr_22786_22844[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (11))){
var inst_22653 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
var statearr_22788_22845 = state_22745__$1;
(statearr_22788_22845[(2)] = inst_22653);

(statearr_22788_22845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (9))){
var inst_22648 = (state_22745[(7)]);
var state_22745__$1 = state_22745;
var statearr_22789_22846 = state_22745__$1;
(statearr_22789_22846[(2)] = inst_22648);

(statearr_22789_22846[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (5))){
var _ = (function (){var statearr_22790 = state_22745;
(statearr_22790[(4)] = cljs.core.rest.call(null,(state_22745[(4)])));

return statearr_22790;
})();
var state_22745__$1 = state_22745;
var ex22787 = (state_22745__$1[(2)]);
var statearr_22791_22847 = state_22745__$1;
(statearr_22791_22847[(5)] = ex22787);


if((ex22787 instanceof Error)){
var statearr_22792_22848 = state_22745__$1;
(statearr_22792_22848[(1)] = (4));

(statearr_22792_22848[(5)] = null);

} else {
throw ex22787;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (14))){
var inst_22655 = (state_22745[(8)]);
var inst_22673 = (state_22745[(14)]);
var inst_22666 = (state_22745[(16)]);
var inst_22663 = (state_22745[(2)]);
var inst_22664 = fluree.db.query.fql.get_recursion_map_multi.call(null,recursion_map,inst_22655,f,select_spec,inst_22663);
var inst_22665 = cljs.core.nth.call(null,inst_22664,(0),null);
var inst_22666__$1 = cljs.core.nth.call(null,inst_22664,(1),null);
var inst_22667 = cljs.core.nth.call(null,inst_22664,(2),null);
var inst_22668 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22670 = [inst_22655,new cljs.core.Keyword(null,"depth","depth",1768663640)];
var inst_22671 = (new cljs.core.PersistentVector(null,2,(5),inst_22669,inst_22670,null));
var inst_22672 = cljs.core.get_in.call(null,inst_22666__$1,inst_22671);
var inst_22673__$1 = (inst_22668 < inst_22672);
var state_22745__$1 = (function (){var statearr_22793 = state_22745;
(statearr_22793[(14)] = inst_22673__$1);

(statearr_22793[(12)] = inst_22667);

(statearr_22793[(10)] = inst_22665);

(statearr_22793[(16)] = inst_22666__$1);

return statearr_22793;
})();
if(cljs.core.truth_(inst_22673__$1)){
var statearr_22794_22849 = state_22745__$1;
(statearr_22794_22849[(1)] = (15));

} else {
var statearr_22795_22850 = state_22745__$1;
(statearr_22795_22850[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (26))){
var inst_22673 = (state_22745[(14)]);
var state_22745__$1 = state_22745;
var statearr_22796_22851 = state_22745__$1;
(statearr_22796_22851[(2)] = inst_22673);

(statearr_22796_22851[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (16))){
var inst_22667 = (state_22745[(12)]);
var inst_22676 = cljs.core.not.call(null,inst_22667);
var state_22745__$1 = state_22745;
var statearr_22797_22852 = state_22745__$1;
(statearr_22797_22852[(2)] = inst_22676);

(statearr_22797_22852[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (38))){
var inst_22722 = (state_22745[(2)]);
var inst_22723 = fluree.db.util.async.throw_err.call(null,inst_22722);
var state_22745__$1 = (function (){var statearr_22798 = state_22745;
(statearr_22798[(13)] = inst_22723);

return statearr_22798;
})();
if(cljs.core.truth_(fuel)){
var statearr_22799_22853 = state_22745__$1;
(statearr_22799_22853[(1)] = (39));

} else {
var statearr_22800_22854 = state_22745__$1;
(statearr_22800_22854[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (30))){
var inst_22697 = (state_22745[(11)]);
var state_22745__$1 = state_22745;
if(cljs.core.truth_(inst_22697)){
var statearr_22801_22855 = state_22745__$1;
(statearr_22801_22855[(1)] = (32));

} else {
var statearr_22802_22856 = state_22745__$1;
(statearr_22802_22856[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (10))){
var inst_22651 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22745__$1 = state_22745;
var statearr_22803_22857 = state_22745__$1;
(statearr_22803_22857[(2)] = inst_22651);

(statearr_22803_22857[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (18))){
var state_22745__$1 = state_22745;
var statearr_22804_22858 = state_22745__$1;
(statearr_22804_22858[(2)] = null);

(statearr_22804_22858[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (37))){
var inst_22733 = (state_22745[(2)]);
var state_22745__$1 = state_22745;
var statearr_22805_22859 = state_22745__$1;
(statearr_22805_22859[(2)] = inst_22733);

(statearr_22805_22859[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22746 === (8))){
var inst_22655 = (state_22745[(8)]);
var inst_22659 = (state_22745[(20)]);
var inst_22644 = (state_22745[(21)]);
var inst_22655__$1 = (state_22745[(2)]);
var inst_22656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22657 = [inst_22655__$1,inst_22644];
var inst_22658 = (new cljs.core.PersistentVector(null,2,(5),inst_22656,inst_22657,null));
var inst_22659__$1 = cljs.core.get_in.call(null,recursion_map,inst_22658);
var state_22745__$1 = (function (){var statearr_22806 = state_22745;
(statearr_22806[(8)] = inst_22655__$1);

(statearr_22806[(20)] = inst_22659__$1);

return statearr_22806;
})();
if(cljs.core.truth_(inst_22659__$1)){
var statearr_22807_22860 = state_22745__$1;
(statearr_22807_22860[(1)] = (12));

} else {
var statearr_22808_22861 = state_22745__$1;
(statearr_22808_22861[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____0 = (function (){
var statearr_22809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22809[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__);

(statearr_22809[(1)] = (1));

return statearr_22809;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____1 = (function (state_22745){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_22745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e22810){var ex__2457__auto__ = e22810;
var statearr_22811_22862 = state_22745;
(statearr_22811_22862[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_22745[(4)]))){
var statearr_22812_22863 = state_22745;
(statearr_22812_22863[(1)] = cljs.core.first.call(null,(state_22745[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22864 = state_22745;
state_22745 = G__22864;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__ = function(state_22745){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____1.call(this,state_22745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_22813 = f__2477__auto__.call(null);
(statearr_22813[(6)] = c__2476__auto__);

return statearr_22813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,select_spec__$1))?fluree.db.query.fql.full_select_spec.call(null,db,cache,select_spec__$1,fluree.db.query.fql.s.call(null,f)):select_spec__$1);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s.call(null,f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred-ids","pred-ids",-1902141555),k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_23027){
var state_val_23028 = (state_23027[(1)]);
if((state_val_23028 === (7))){
var inst_22876 = (state_23027[(7)]);
var inst_22876__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23027__$1 = (function (){var statearr_23029 = state_23027;
(statearr_23029[(7)] = inst_22876__$1);

return statearr_23029;
})();
if(cljs.core.truth_(inst_22876__$1)){
var statearr_23030_23128 = state_23027__$1;
(statearr_23030_23128[(1)] = (9));

} else {
var statearr_23031_23129 = state_23027__$1;
(statearr_23031_23129[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (59))){
var inst_23008 = (state_23027[(8)]);
var inst_23010 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23011 = cljs.core.sequence.call(null,inst_23010,inst_23008);
var state_23027__$1 = state_23027;
var statearr_23032_23130 = state_23027__$1;
(statearr_23032_23130[(2)] = inst_23011);

(statearr_23032_23130[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (20))){
var inst_22910 = (state_23027[(9)]);
var inst_22915 = (state_23027[(10)]);
var inst_22883 = (state_23027[(11)]);
var inst_22910__$1 = (state_23027[(2)]);
var inst_22911 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22912 = cljs.core.get.call(null,inst_22910__$1,inst_22883);
var inst_22913 = cljs.core.vals.call(null,inst_22912);
var inst_22914 = cljs.core.apply.call(null,cljs.core.max,inst_22913);
var inst_22915__$1 = (inst_22911 < inst_22914);
var state_23027__$1 = (function (){var statearr_23033 = state_23027;
(statearr_23033[(9)] = inst_22910__$1);

(statearr_23033[(10)] = inst_22915__$1);

return statearr_23033;
})();
if(cljs.core.truth_(inst_22915__$1)){
var statearr_23034_23131 = state_23027__$1;
(statearr_23034_23131[(1)] = (21));

} else {
var statearr_23035_23132 = state_23027__$1;
(statearr_23035_23132[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (58))){
var inst_23007 = (state_23027[(2)]);
var inst_23008 = fluree.db.util.async.throw_err.call(null,inst_23007);
var state_23027__$1 = (function (){var statearr_23036 = state_23027;
(statearr_23036[(8)] = inst_23008);

return statearr_23036;
})();
if(cljs.core.truth_(fuel)){
var statearr_23037_23133 = state_23027__$1;
(statearr_23037_23133[(1)] = (59));

} else {
var statearr_23038_23134 = state_23027__$1;
(statearr_23038_23134[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (60))){
var inst_23008 = (state_23027[(8)]);
var state_23027__$1 = state_23027;
var statearr_23039_23135 = state_23027__$1;
(statearr_23039_23135[(2)] = inst_23008);

(statearr_23039_23135[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (27))){
var inst_22927 = (state_23027[(12)]);
var inst_22929 = f.o;
var inst_22930 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_22929,inst_22927);
var state_23027__$1 = state_23027;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23027__$1,(30),inst_22930);
} else {
if((state_val_23028 === (1))){
var state_23027__$1 = state_23027;
var statearr_23040_23136 = state_23027__$1;
(statearr_23040_23136[(2)] = null);

(statearr_23040_23136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (24))){
var state_23027__$1 = state_23027;
var statearr_23041_23137 = state_23027__$1;
(statearr_23041_23137[(2)] = null);

(statearr_23041_23137[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (55))){
var inst_22998 = cljs.core.rest.call(null,flakes);
var state_23027__$1 = state_23027;
var statearr_23042_23138 = state_23027__$1;
(statearr_23042_23138[(2)] = inst_22998);

(statearr_23042_23138[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (39))){
var inst_22938 = (state_23027[(13)]);
var inst_22968 = (state_23027[(2)]);
var state_23027__$1 = (function (){var statearr_23043 = state_23027;
(statearr_23043[(14)] = inst_22968);

return statearr_23043;
})();
if(cljs.core.truth_(inst_22938)){
var statearr_23044_23139 = state_23027__$1;
(statearr_23044_23139[(1)] = (40));

} else {
var statearr_23045_23140 = state_23027__$1;
(statearr_23045_23140[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (46))){
var state_23027__$1 = state_23027;
var statearr_23046_23141 = state_23027__$1;
(statearr_23046_23141[(2)] = acc);

(statearr_23046_23141[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (4))){
var inst_22865 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
var statearr_23047_23142 = state_23027__$1;
(statearr_23047_23142[(2)] = inst_22865);

(statearr_23047_23142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (54))){
var inst_22996 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
if(cljs.core.truth_(inst_22996)){
var statearr_23048_23143 = state_23027__$1;
(statearr_23048_23143[(1)] = (55));

} else {
var statearr_23049_23144 = state_23027__$1;
(statearr_23049_23144[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (15))){
var inst_22883 = (state_23027[(11)]);
var inst_22898 = fluree.db.query.fql.get_recursion_map.call(null,db,recursion_map,select_spec,cache,inst_22883,f);
var state_23027__$1 = state_23027;
var statearr_23050_23145 = state_23027__$1;
(statearr_23050_23145[(2)] = inst_22898);

(statearr_23050_23145[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (48))){
var inst_22990 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
var statearr_23051_23146 = state_23027__$1;
(statearr_23051_23146[(2)] = inst_22990);

(statearr_23051_23146[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (50))){
var state_23027__$1 = state_23027;
var statearr_23052_23147 = state_23027__$1;
(statearr_23052_23147[(2)] = null);

(statearr_23052_23147[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (21))){
var inst_22915 = (state_23027[(10)]);
var state_23027__$1 = state_23027;
var statearr_23053_23148 = state_23027__$1;
(statearr_23053_23148[(2)] = inst_22915);

(statearr_23053_23148[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (31))){
var inst_22883 = (state_23027[(11)]);
var inst_22887 = (state_23027[(15)]);
var inst_22940 = cljs.core.get.call(null,inst_22887,inst_22883);
var inst_22941 = cljs.core.count.call(null,inst_22940);
var inst_22942 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22943 = (inst_22941 > inst_22942);
var state_23027__$1 = state_23027;
var statearr_23054_23149 = state_23027__$1;
(statearr_23054_23149[(2)] = inst_22943);

(statearr_23054_23149[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (32))){
var inst_22872 = (state_23027[(16)]);
var state_23027__$1 = state_23027;
var statearr_23055_23150 = state_23027__$1;
(statearr_23055_23150[(2)] = inst_22872);

(statearr_23055_23150[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (40))){
var inst_22938 = (state_23027[(13)]);
var inst_22968 = (state_23027[(14)]);
var inst_22883 = (state_23027[(11)]);
var inst_22970 = cljs.core.get.call(null,inst_22968,inst_22883);
var inst_22971 = cljs.core.merge.call(null,inst_22970,inst_22938);
var inst_22972 = cljs.core.assoc.call(null,inst_22968,inst_22883,inst_22971);
var state_23027__$1 = state_23027;
var statearr_23056_23151 = state_23027__$1;
(statearr_23056_23151[(2)] = inst_22972);

(statearr_23056_23151[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (56))){
var inst_22871 = (state_23027[(17)]);
var inst_23000 = cljs.core.rest.call(null,flakes);
var inst_23002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23003 = [inst_22871];
var inst_23004 = (new cljs.core.PersistentVector(null,1,(5),inst_23002,inst_23003,null));
var inst_23005 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23004);
var state_23027__$1 = (function (){var statearr_23057 = state_23027;
(statearr_23057[(18)] = inst_23000);

return statearr_23057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23027__$1,(58),inst_23005);
} else {
if((state_val_23028 === (33))){
var inst_22946 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
if(cljs.core.truth_(inst_22946)){
var statearr_23058_23152 = state_23027__$1;
(statearr_23058_23152[(1)] = (34));

} else {
var statearr_23059_23153 = state_23027__$1;
(statearr_23059_23153[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (13))){
var state_23027__$1 = state_23027;
var statearr_23060_23154 = state_23027__$1;
(statearr_23060_23154[(2)] = false);

(statearr_23060_23154[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (22))){
var inst_22895 = (state_23027[(19)]);
var state_23027__$1 = state_23027;
var statearr_23061_23155 = state_23027__$1;
(statearr_23061_23155[(2)] = inst_22895);

(statearr_23061_23155[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (36))){
var inst_23022 = (state_23027[(2)]);
var _ = (function (){var statearr_23062 = state_23027;
(statearr_23062[(4)] = cljs.core.rest.call(null,(state_23027[(4)])));

return statearr_23062;
})();
var state_23027__$1 = state_23027;
var statearr_23063_23156 = state_23027__$1;
(statearr_23063_23156[(2)] = inst_23022);

(statearr_23063_23156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (41))){
var inst_22968 = (state_23027[(14)]);
var state_23027__$1 = state_23027;
var statearr_23064_23157 = state_23027__$1;
(statearr_23064_23157[(2)] = inst_22968);

(statearr_23064_23157[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (43))){
var inst_22975 = (state_23027[(20)]);
var state_23027__$1 = state_23027;
var statearr_23065_23158 = state_23027__$1;
(statearr_23065_23158[(2)] = inst_22975);

(statearr_23065_23158[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (61))){
var inst_23000 = (state_23027[(18)]);
var inst_23014 = (state_23027[(2)]);
var inst_23015 = cljs.core.concat.call(null,inst_23000,inst_23014);
var state_23027__$1 = state_23027;
var statearr_23066_23159 = state_23027__$1;
(statearr_23066_23159[(2)] = inst_23015);

(statearr_23066_23159[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (29))){
var inst_22936 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
var statearr_23067_23160 = state_23027__$1;
(statearr_23067_23160[(2)] = inst_22936);

(statearr_23067_23160[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (44))){
var inst_22895 = (state_23027[(19)]);
var state_23027__$1 = state_23027;
if(cljs.core.truth_(inst_22895)){
var statearr_23068_23161 = state_23027__$1;
(statearr_23068_23161[(1)] = (46));

} else {
var statearr_23069_23162 = state_23027__$1;
(statearr_23069_23162[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (6))){
var inst_22873 = (state_23027[(21)]);
var state_23027__$1 = state_23027;
var statearr_23070_23163 = state_23027__$1;
(statearr_23070_23163[(2)] = inst_22873);

(statearr_23070_23163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (28))){
var state_23027__$1 = state_23027;
var statearr_23071_23164 = state_23027__$1;
(statearr_23071_23164[(2)] = null);

(statearr_23071_23164[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (51))){
var inst_22988 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
var statearr_23072_23165 = state_23027__$1;
(statearr_23072_23165[(2)] = inst_22988);

(statearr_23072_23165[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (25))){
var inst_22927 = (state_23027[(12)]);
var inst_22910 = (state_23027[(9)]);
var inst_22922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22923 = f.p;
var inst_22924 = [new cljs.core.Keyword(null,"select-specs","select-specs",-681748023),inst_22923];
var inst_22925 = (new cljs.core.PersistentVector(null,2,(5),inst_22922,inst_22924,null));
var inst_22926 = cljs.core.get_in.call(null,inst_22910,inst_22925);
var inst_22927__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_22926);
var state_23027__$1 = (function (){var statearr_23073 = state_23027;
(statearr_23073[(12)] = inst_22927__$1);

return statearr_23073;
})();
if(cljs.core.truth_(inst_22927__$1)){
var statearr_23074_23166 = state_23027__$1;
(statearr_23074_23166[(1)] = (27));

} else {
var statearr_23075_23167 = state_23027__$1;
(statearr_23075_23167[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (34))){
var inst_22910 = (state_23027[(9)]);
var inst_22948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22949 = cljs.core.rest.call(null,flakes);
var inst_22950 = [acc,inst_22949,inst_22910];
var inst_22951 = (new cljs.core.PersistentVector(null,3,(5),inst_22948,inst_22950,null));
var state_23027__$1 = state_23027;
var statearr_23076_23168 = state_23027__$1;
(statearr_23076_23168[(2)] = inst_22951);

(statearr_23076_23168[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (17))){
var inst_22895 = (state_23027[(19)]);
var inst_22901 = (state_23027[(2)]);
var state_23027__$1 = (function (){var statearr_23077 = state_23027;
(statearr_23077[(22)] = inst_22901);

return statearr_23077;
})();
if(cljs.core.truth_(inst_22895)){
var statearr_23078_23169 = state_23027__$1;
(statearr_23078_23169[(1)] = (18));

} else {
var statearr_23079_23170 = state_23027__$1;
(statearr_23079_23170[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (3))){
var inst_23025 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23027__$1,inst_23025);
} else {
if((state_val_23028 === (12))){
var inst_22891 = (state_23027[(23)]);
var state_23027__$1 = state_23027;
var statearr_23080_23171 = state_23027__$1;
(statearr_23080_23171[(2)] = inst_22891);

(statearr_23080_23171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (2))){
var inst_22873 = (state_23027[(21)]);
var _ = (function (){var statearr_23081 = state_23027;
(statearr_23081[(4)] = cljs.core.cons.call(null,(5),(state_23027[(4)])));

return statearr_23081;
})();
var inst_22871 = f.o;
var inst_22872 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22873__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23027__$1 = (function (){var statearr_23082 = state_23027;
(statearr_23082[(21)] = inst_22873__$1);

(statearr_23082[(17)] = inst_22871);

(statearr_23082[(16)] = inst_22872);

return statearr_23082;
})();
if(cljs.core.truth_(inst_22873__$1)){
var statearr_23083_23172 = state_23027__$1;
(statearr_23083_23172[(1)] = (6));

} else {
var statearr_23084_23173 = state_23027__$1;
(statearr_23084_23173[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (23))){
var inst_22919 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
if(cljs.core.truth_(inst_22919)){
var statearr_23085_23174 = state_23027__$1;
(statearr_23085_23174[(1)] = (24));

} else {
var statearr_23086_23175 = state_23027__$1;
(statearr_23086_23175[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (47))){
var state_23027__$1 = state_23027;
var statearr_23087_23176 = state_23027__$1;
(statearr_23087_23176[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (35))){
var inst_22872 = (state_23027[(16)]);
var state_23027__$1 = state_23027;
if(cljs.core.truth_(inst_22872)){
var statearr_23089_23177 = state_23027__$1;
(statearr_23089_23177[(1)] = (37));

} else {
var statearr_23090_23178 = state_23027__$1;
(statearr_23090_23178[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (19))){
var inst_22901 = (state_23027[(22)]);
var inst_22871 = (state_23027[(17)]);
var inst_22883 = (state_23027[(11)]);
var inst_22904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22905 = [inst_22883,inst_22871];
var inst_22906 = (new cljs.core.PersistentVector(null,2,(5),inst_22904,inst_22905,null));
var inst_22907 = ((0) + (1));
var inst_22908 = cljs.core.assoc_in.call(null,inst_22901,inst_22906,inst_22907);
var state_23027__$1 = state_23027;
var statearr_23091_23179 = state_23027__$1;
(statearr_23091_23179[(2)] = inst_22908);

(statearr_23091_23179[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (57))){
var inst_22992 = (state_23027[(24)]);
var inst_22910 = (state_23027[(9)]);
var inst_23017 = (state_23027[(2)]);
var inst_23018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23019 = [inst_22992,inst_23017,inst_22910];
var inst_23020 = (new cljs.core.PersistentVector(null,3,(5),inst_23018,inst_23019,null));
var state_23027__$1 = state_23027;
var statearr_23092_23180 = state_23027__$1;
(statearr_23092_23180[(2)] = inst_23020);

(statearr_23092_23180[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (11))){
var inst_22881 = (state_23027[(2)]);
var state_23027__$1 = state_23027;
var statearr_23094_23181 = state_23027__$1;
(statearr_23094_23181[(2)] = inst_22881);

(statearr_23094_23181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (9))){
var inst_22876 = (state_23027[(7)]);
var state_23027__$1 = state_23027;
var statearr_23095_23182 = state_23027__$1;
(statearr_23095_23182[(2)] = inst_22876);

(statearr_23095_23182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (5))){
var _ = (function (){var statearr_23096 = state_23027;
(statearr_23096[(4)] = cljs.core.rest.call(null,(state_23027[(4)])));

return statearr_23096;
})();
var state_23027__$1 = state_23027;
var ex23093 = (state_23027__$1[(2)]);
var statearr_23097_23183 = state_23027__$1;
(statearr_23097_23183[(5)] = ex23093);


if((ex23093 instanceof Error)){
var statearr_23098_23184 = state_23027__$1;
(statearr_23098_23184[(1)] = (4));

(statearr_23098_23184[(5)] = null);

} else {
throw ex23093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (14))){
var inst_22895 = (state_23027[(19)]);
var inst_22895__$1 = (state_23027[(2)]);
var inst_22896 = cljs.core.not.call(null,inst_22895__$1);
var state_23027__$1 = (function (){var statearr_23099 = state_23027;
(statearr_23099[(19)] = inst_22895__$1);

return statearr_23099;
})();
if(inst_22896){
var statearr_23100_23185 = state_23027__$1;
(statearr_23100_23185[(1)] = (15));

} else {
var statearr_23101_23186 = state_23027__$1;
(statearr_23101_23186[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (45))){
var inst_22915 = (state_23027[(10)]);
var inst_22992 = (state_23027[(2)]);
var state_23027__$1 = (function (){var statearr_23102 = state_23027;
(statearr_23102[(24)] = inst_22992);

return statearr_23102;
})();
if(cljs.core.truth_(inst_22915)){
var statearr_23103_23187 = state_23027__$1;
(statearr_23103_23187[(1)] = (52));

} else {
var statearr_23104_23188 = state_23027__$1;
(statearr_23104_23188[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (53))){
var inst_22895 = (state_23027[(19)]);
var state_23027__$1 = state_23027;
var statearr_23105_23189 = state_23027__$1;
(statearr_23105_23189[(2)] = inst_22895);

(statearr_23105_23189[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (26))){
var inst_22872 = (state_23027[(16)]);
var inst_22938 = (state_23027[(2)]);
var state_23027__$1 = (function (){var statearr_23106 = state_23027;
(statearr_23106[(13)] = inst_22938);

return statearr_23106;
})();
if(cljs.core.truth_(inst_22872)){
var statearr_23107_23190 = state_23027__$1;
(statearr_23107_23190[(1)] = (31));

} else {
var statearr_23108_23191 = state_23027__$1;
(statearr_23108_23191[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (16))){
var state_23027__$1 = state_23027;
var statearr_23109_23192 = state_23027__$1;
(statearr_23109_23192[(2)] = recursion_map);

(statearr_23109_23192[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (38))){
var inst_22871 = (state_23027[(17)]);
var inst_22883 = (state_23027[(11)]);
var inst_22887 = (state_23027[(15)]);
var inst_22963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22964 = [inst_22883,new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22965 = (new cljs.core.PersistentVector(null,2,(5),inst_22963,inst_22964,null));
var inst_22966 = cljs.core.assoc_in.call(null,inst_22887,inst_22965,inst_22871);
var state_23027__$1 = state_23027;
var statearr_23110_23193 = state_23027__$1;
(statearr_23110_23193[(2)] = inst_22966);

(statearr_23110_23193[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (30))){
var inst_22932 = (state_23027[(2)]);
var inst_22933 = fluree.db.util.async.throw_err.call(null,inst_22932);
var state_23027__$1 = state_23027;
var statearr_23111_23194 = state_23027__$1;
(statearr_23111_23194[(2)] = inst_22933);

(statearr_23111_23194[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (10))){
var inst_22879 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_23027__$1 = state_23027;
var statearr_23112_23195 = state_23027__$1;
(statearr_23112_23195[(2)] = inst_22879);

(statearr_23112_23195[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (18))){
var inst_22901 = (state_23027[(22)]);
var state_23027__$1 = state_23027;
var statearr_23113_23196 = state_23027__$1;
(statearr_23113_23196[(2)] = inst_22901);

(statearr_23113_23196[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (52))){
var inst_22915 = (state_23027[(10)]);
var state_23027__$1 = state_23027;
var statearr_23114_23197 = state_23027__$1;
(statearr_23114_23197[(2)] = inst_22915);

(statearr_23114_23197[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (42))){
var inst_22895 = (state_23027[(19)]);
var inst_22975 = (state_23027[(2)]);
var inst_22976 = cljs.core.not.call(null,inst_22895);
var state_23027__$1 = (function (){var statearr_23115 = state_23027;
(statearr_23115[(20)] = inst_22975);

return statearr_23115;
})();
if(inst_22976){
var statearr_23116_23198 = state_23027__$1;
(statearr_23116_23198[(1)] = (43));

} else {
var statearr_23117_23199 = state_23027__$1;
(statearr_23117_23199[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (37))){
var inst_22871 = (state_23027[(17)]);
var inst_22883 = (state_23027[(11)]);
var inst_22887 = (state_23027[(15)]);
var inst_22954 = cljs.core.PersistentVector.EMPTY;
var inst_22955 = cljs.core.get.call(null,inst_22887,inst_22883);
var inst_22956 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22957 = [inst_22871];
var inst_22958 = cljs.core.PersistentHashMap.fromArrays(inst_22956,inst_22957);
var inst_22959 = cljs.core.conj.call(null,inst_22955,inst_22958);
var inst_22960 = cljs.core.into.call(null,inst_22954,inst_22959);
var inst_22961 = cljs.core.assoc.call(null,inst_22887,inst_22883,inst_22960);
var state_23027__$1 = state_23027;
var statearr_23118_23200 = state_23027__$1;
(statearr_23118_23200[(2)] = inst_22961);

(statearr_23118_23200[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (8))){
var inst_22891 = (state_23027[(23)]);
var inst_22871 = (state_23027[(17)]);
var inst_22883 = (state_23027[(11)]);
var inst_22883__$1 = (state_23027[(2)]);
var inst_22884 = cljs.core.PersistentVector.EMPTY;
var inst_22885 = cljs.core.repeat.call(null,(0),inst_22883__$1);
var inst_22886 = cljs.core.into.call(null,inst_22884,inst_22885);
var inst_22887 = cljs.core.get_in.call(null,acc,inst_22886);
var inst_22888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22889 = [inst_22883__$1,inst_22871];
var inst_22890 = (new cljs.core.PersistentVector(null,2,(5),inst_22888,inst_22889,null));
var inst_22891__$1 = cljs.core.get_in.call(null,recursion_map,inst_22890);
var state_23027__$1 = (function (){var statearr_23119 = state_23027;
(statearr_23119[(23)] = inst_22891__$1);

(statearr_23119[(11)] = inst_22883__$1);

(statearr_23119[(15)] = inst_22887);

return statearr_23119;
})();
if(cljs.core.truth_(inst_22891__$1)){
var statearr_23120_23201 = state_23027__$1;
(statearr_23120_23201[(1)] = (12));

} else {
var statearr_23121_23202 = state_23027__$1;
(statearr_23121_23202[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23028 === (49))){
var inst_22975 = (state_23027[(20)]);
var inst_22883 = (state_23027[(11)]);
var inst_22982 = cljs.core.PersistentVector.EMPTY;
var inst_22983 = cljs.core.repeat.call(null,(0),inst_22883);
var inst_22984 = cljs.core.into.call(null,inst_22982,inst_22983);
var inst_22985 = cljs.core.assoc_in.call(null,acc,inst_22984,inst_22975);
var state_23027__$1 = state_23027;
var statearr_23122_23203 = state_23027__$1;
(statearr_23122_23203[(2)] = inst_22985);

(statearr_23122_23203[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____0 = (function (){
var statearr_23123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23123[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__);

(statearr_23123[(1)] = (1));

return statearr_23123;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____1 = (function (state_23027){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_23027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e23124){var ex__2457__auto__ = e23124;
var statearr_23125_23204 = state_23027;
(statearr_23125_23204[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_23027[(4)]))){
var statearr_23126_23205 = state_23027;
(statearr_23126_23205[(1)] = cljs.core.first.call(null,(state_23027[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23206 = state_23027;
state_23027 = G__23206;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__ = function(state_23027){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____1.call(this,state_23027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_23127 = f__2477__auto__.call(null);
(statearr_23127[(6)] = c__2476__auto__);

return statearr_23127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_23397){
var state_val_23398 = (state_23397[(1)]);
if((state_val_23398 === (7))){
var state_23397__$1 = state_23397;
var statearr_23399_23491 = state_23397__$1;
(statearr_23399_23491[(2)] = null);

(statearr_23399_23491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (20))){
var inst_23245 = cljs.core.PersistentHashMap.EMPTY;
var state_23397__$1 = state_23397;
var statearr_23400_23492 = state_23397__$1;
(statearr_23400_23492[(2)] = inst_23245);

(statearr_23400_23492[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (58))){
var inst_23355 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23401_23493 = state_23397__$1;
(statearr_23401_23493[(2)] = inst_23355);

(statearr_23401_23493[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (27))){
var inst_23263 = (state_23397[(7)]);
var inst_23227 = (state_23397[(8)]);
var inst_23247 = (state_23397[(9)]);
var inst_23233 = (state_23397[(10)]);
var inst_23376 = (state_23397[(2)]);
var inst_23377 = (function (){var top_level_subject = inst_23227;
var select_spec = inst_23233;
var base_acc = inst_23247;
var acc_PLUS_refs = inst_23263;
var result = inst_23376;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23378 = cljs.core.PersistentVector.EMPTY;
var inst_23379 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23233);
var inst_23380 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23379);
var inst_23381 = cljs.core.vals.call(null,inst_23380);
var inst_23382 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23233);
var inst_23383 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23382);
var inst_23384 = cljs.core.vals.call(null,inst_23383);
var inst_23385 = cljs.core.concat.call(null,inst_23381,inst_23384);
var inst_23386 = cljs.core.reduce.call(null,inst_23377,inst_23378,inst_23385);
var inst_23388 = (function (){var top_level_subject = inst_23227;
var select_spec = inst_23233;
var base_acc = inst_23247;
var acc_PLUS_refs = inst_23263;
var result = inst_23376;
var sort_preds = inst_23386;
return (function (acc,p__23387){
var vec__23402 = p__23387;
var selectPred = cljs.core.nth.call(null,vec__23402,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23402,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23402,(2),null);
var limit = cljs.core.nth.call(null,vec__23402,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23389 = cljs.core.reduce.call(null,inst_23388,inst_23376,inst_23386);
var state_23397__$1 = state_23397;
var statearr_23405_23494 = state_23397__$1;
(statearr_23405_23494[(2)] = inst_23389);

(statearr_23405_23494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (1))){
var state_23397__$1 = state_23397;
var statearr_23406_23495 = state_23397__$1;
(statearr_23406_23495[(2)] = null);

(statearr_23406_23495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (24))){
var inst_23263 = (state_23397[(7)]);
var inst_23263__$1 = (state_23397[(2)]);
var inst_23264 = flakes;
var inst_23265 = cljs.core.PersistentHashMap.EMPTY;
var inst_23266 = cljs.core.PersistentHashMap.EMPTY;
var inst_23267 = inst_23264;
var inst_23268 = inst_23263__$1;
var inst_23269 = inst_23265;
var inst_23270 = inst_23266;
var state_23397__$1 = (function (){var statearr_23407 = state_23397;
(statearr_23407[(11)] = inst_23268);

(statearr_23407[(7)] = inst_23263__$1);

(statearr_23407[(12)] = inst_23267);

(statearr_23407[(13)] = inst_23270);

(statearr_23407[(14)] = inst_23269);

return statearr_23407;
})();
var statearr_23408_23496 = state_23397__$1;
(statearr_23408_23496[(2)] = null);

(statearr_23408_23496[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (55))){
var inst_23357 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23409_23497 = state_23397__$1;
(statearr_23409_23497[(2)] = inst_23357);

(statearr_23409_23497[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (39))){
var inst_23283 = (state_23397[(15)]);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23283)){
var statearr_23410_23498 = state_23397__$1;
(statearr_23410_23498[(1)] = (42));

} else {
var statearr_23411_23499 = state_23397__$1;
(statearr_23411_23499[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (46))){
var inst_23268 = (state_23397[(11)]);
var inst_23284 = (state_23397[(16)]);
var inst_23233 = (state_23397[(10)]);
var inst_23278 = (state_23397[(17)]);
var inst_23321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23322 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23268,inst_23233,inst_23278,inst_23284,false);
var state_23397__$1 = (function (){var statearr_23412 = state_23397;
(statearr_23412[(18)] = inst_23321);

return statearr_23412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23397__$1,(49),inst_23322);
} else {
if((state_val_23398 === (4))){
var inst_23207 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23413_23500 = state_23397__$1;
(statearr_23413_23500[(2)] = inst_23207);

(statearr_23413_23500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (54))){
var state_23397__$1 = state_23397;
var statearr_23414_23501 = state_23397__$1;
(statearr_23414_23501[(1)] = (56));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (15))){
var inst_23234 = (state_23397[(19)]);
var inst_23233 = (state_23397[(10)]);
var inst_23233__$1 = (state_23397[(2)]);
var inst_23234__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23233__$1);
var state_23397__$1 = (function (){var statearr_23416 = state_23397;
(statearr_23416[(19)] = inst_23234__$1);

(statearr_23416[(10)] = inst_23233__$1);

return statearr_23416;
})();
if(cljs.core.truth_(inst_23234__$1)){
var statearr_23417_23502 = state_23397__$1;
(statearr_23417_23502[(1)] = (16));

} else {
var statearr_23418_23503 = state_23397__$1;
(statearr_23418_23503[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (48))){
var inst_23359 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23419_23504 = state_23397__$1;
(statearr_23419_23504[(2)] = inst_23359);

(statearr_23419_23504[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (50))){
var inst_23233 = (state_23397[(10)]);
var inst_23334 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23233);
var state_23397__$1 = state_23397;
var statearr_23420_23505 = state_23397__$1;
(statearr_23420_23505[(2)] = inst_23334);

(statearr_23420_23505[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (21))){
var inst_23233 = (state_23397[(10)]);
var inst_23247 = (state_23397[(2)]);
var inst_23248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23249 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23250 = (new cljs.core.PersistentVector(null,2,(5),inst_23248,inst_23249,null));
var inst_23251 = cljs.core.get_in.call(null,inst_23233,inst_23250);
var state_23397__$1 = (function (){var statearr_23421 = state_23397;
(statearr_23421[(9)] = inst_23247);

return statearr_23421;
})();
if(cljs.core.truth_(inst_23251)){
var statearr_23422_23506 = state_23397__$1;
(statearr_23422_23506[(1)] = (22));

} else {
var statearr_23423_23507 = state_23397__$1;
(statearr_23423_23507[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (31))){
var inst_23283 = (state_23397[(15)]);
var inst_23287 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23283);
var state_23397__$1 = state_23397;
var statearr_23424_23508 = state_23397__$1;
(statearr_23424_23508[(2)] = inst_23287);

(statearr_23424_23508[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (32))){
var inst_23285 = (state_23397[(20)]);
var state_23397__$1 = state_23397;
var statearr_23425_23509 = state_23397__$1;
(statearr_23425_23509[(2)] = inst_23285);

(statearr_23425_23509[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (40))){
var inst_23363 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23426_23510 = state_23397__$1;
(statearr_23426_23510[(2)] = inst_23363);

(statearr_23426_23510[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (56))){
var inst_23268 = (state_23397[(11)]);
var inst_23267 = (state_23397[(12)]);
var inst_23270 = (state_23397[(13)]);
var inst_23269 = (state_23397[(14)]);
var inst_23349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23350 = cljs.core.rest.call(null,inst_23267);
var inst_23351 = [inst_23268,inst_23350,inst_23269,inst_23270];
var inst_23352 = (new cljs.core.PersistentVector(null,4,(5),inst_23349,inst_23351,null));
var state_23397__$1 = state_23397;
var statearr_23427_23511 = state_23397__$1;
(statearr_23427_23511[(2)] = inst_23352);

(statearr_23427_23511[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (33))){
var inst_23290 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23290)){
var statearr_23428_23512 = state_23397__$1;
(statearr_23428_23512[(1)] = (34));

} else {
var statearr_23429_23513 = state_23397__$1;
(statearr_23429_23513[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (13))){
var inst_23227 = (state_23397[(8)]);
var inst_23230 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23227);
var state_23397__$1 = state_23397;
var statearr_23430_23514 = state_23397__$1;
(statearr_23430_23514[(2)] = inst_23230);

(statearr_23430_23514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (22))){
var inst_23233 = (state_23397[(10)]);
var inst_23253 = cljs.core.first.call(null,flakes);
var inst_23254 = fluree.db.query.fql.s.call(null,inst_23253);
var inst_23255 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23233);
var inst_23256 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23254,inst_23255);
var state_23397__$1 = state_23397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23397__$1,(25),inst_23256);
} else {
if((state_val_23398 === (36))){
var inst_23278 = (state_23397[(17)]);
var inst_23365 = (state_23397[(2)]);
var inst_23366 = cljs.core.nth.call(null,inst_23365,(0),null);
var inst_23367 = cljs.core.nth.call(null,inst_23365,(1),null);
var inst_23368 = cljs.core.nth.call(null,inst_23365,(2),null);
var inst_23369 = cljs.core.nth.call(null,inst_23365,(3),null);
var inst_23370 = inst_23278.s;
var inst_23371 = cljs.core.assoc.call(null,inst_23366,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23370);
var inst_23267 = inst_23367;
var inst_23268 = inst_23371;
var inst_23269 = inst_23368;
var inst_23270 = inst_23369;
var state_23397__$1 = (function (){var statearr_23431 = state_23397;
(statearr_23431[(11)] = inst_23268);

(statearr_23431[(12)] = inst_23267);

(statearr_23431[(13)] = inst_23270);

(statearr_23431[(14)] = inst_23269);

return statearr_23431;
})();
var statearr_23432_23515 = state_23397__$1;
(statearr_23432_23515[(2)] = null);

(statearr_23432_23515[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (41))){
var inst_23301 = (state_23397[(2)]);
var inst_23302 = fluree.db.util.async.throw_err.call(null,inst_23301);
var state_23397__$1 = state_23397;
var statearr_23433_23516 = state_23397__$1;
(statearr_23433_23516[(2)] = inst_23302);

(statearr_23433_23516[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (43))){
var inst_23233 = (state_23397[(10)]);
var inst_23319 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23233);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23319)){
var statearr_23434_23517 = state_23397__$1;
(statearr_23434_23517[(1)] = (46));

} else {
var statearr_23435_23518 = state_23397__$1;
(statearr_23435_23518[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (29))){
var inst_23267 = (state_23397[(12)]);
var inst_23285 = (state_23397[(20)]);
var inst_23283 = (state_23397[(15)]);
var inst_23233 = (state_23397[(10)]);
var inst_23278 = (state_23397[(17)]);
var inst_23278__$1 = cljs.core.first.call(null,inst_23267);
var inst_23279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23280 = inst_23278__$1.p;
var inst_23281 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23280];
var inst_23282 = (new cljs.core.PersistentVector(null,3,(5),inst_23279,inst_23281,null));
var inst_23283__$1 = cljs.core.get_in.call(null,inst_23233,inst_23282);
var inst_23284 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23283__$1,inst_23233);
var inst_23285__$1 = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(inst_23283__$1);
var state_23397__$1 = (function (){var statearr_23436 = state_23397;
(statearr_23436[(20)] = inst_23285__$1);

(statearr_23436[(16)] = inst_23284);

(statearr_23436[(15)] = inst_23283__$1);

(statearr_23436[(17)] = inst_23278__$1);

return statearr_23436;
})();
if(cljs.core.truth_(inst_23285__$1)){
var statearr_23437_23519 = state_23397__$1;
(statearr_23437_23519[(1)] = (31));

} else {
var statearr_23438_23520 = state_23397__$1;
(statearr_23438_23520[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (44))){
var inst_23361 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23439_23521 = state_23397__$1;
(statearr_23439_23521[(2)] = inst_23361);

(statearr_23439_23521[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (6))){
var state_23397__$1 = state_23397;
var statearr_23440_23522 = state_23397__$1;
(statearr_23440_23522[(2)] = null);

(statearr_23440_23522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (28))){
var inst_23268 = (state_23397[(11)]);
var state_23397__$1 = state_23397;
var statearr_23441_23523 = state_23397__$1;
(statearr_23441_23523[(2)] = inst_23268);

(statearr_23441_23523[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (51))){
var state_23397__$1 = state_23397;
var statearr_23442_23524 = state_23397__$1;
(statearr_23442_23524[(2)] = false);

(statearr_23442_23524[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (25))){
var inst_23247 = (state_23397[(9)]);
var inst_23258 = (state_23397[(2)]);
var inst_23259 = fluree.db.util.async.throw_err.call(null,inst_23258);
var inst_23260 = cljs.core.merge.call(null,inst_23247,inst_23259);
var state_23397__$1 = state_23397;
var statearr_23443_23525 = state_23397__$1;
(statearr_23443_23525[(2)] = inst_23260);

(statearr_23443_23525[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (34))){
var inst_23268 = (state_23397[(11)]);
var inst_23267 = (state_23397[(12)]);
var inst_23269 = (state_23397[(14)]);
var inst_23283 = (state_23397[(15)]);
var inst_23233 = (state_23397[(10)]);
var inst_23278 = (state_23397[(17)]);
var inst_23292 = fluree.db.query.fql.flake__GT_recur_multi.call(null,db,inst_23278,inst_23283,inst_23269,inst_23267,inst_23268,fuel,max_fuel,inst_23233,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_23397__$1 = state_23397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23397__$1,(37),inst_23292);
} else {
if((state_val_23398 === (17))){
var inst_23233 = (state_23397[(10)]);
var inst_23237 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23233);
var state_23397__$1 = state_23397;
var statearr_23445_23526 = state_23397__$1;
(statearr_23445_23526[(2)] = inst_23237);

(statearr_23445_23526[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (3))){
var inst_23395 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23397__$1,inst_23395);
} else {
if((state_val_23398 === (12))){
var _ = (function (){var statearr_23446 = state_23397;
(statearr_23446[(4)] = cljs.core.rest.call(null,(state_23397[(4)])));

return statearr_23446;
})();
var state_23397__$1 = state_23397;
var ex23444 = (state_23397__$1[(2)]);
var statearr_23447_23527 = state_23397__$1;
(statearr_23447_23527[(5)] = ex23444);


if((ex23444 instanceof java.lang.Exception)){
var statearr_23448_23528 = state_23397__$1;
(statearr_23448_23528[(1)] = (11));

(statearr_23448_23528[(5)] = null);

} else {
throw ex23444;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (2))){
var _ = (function (){var statearr_23449 = state_23397;
(statearr_23449[(4)] = cljs.core.cons.call(null,(5),(state_23397[(4)])));

return statearr_23449;
})();
var inst_23213 = cljs.core.not_empty.call(null,flakes);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23213)){
var statearr_23450_23529 = state_23397__$1;
(statearr_23450_23529[(1)] = (6));

} else {
var statearr_23451_23530 = state_23397__$1;
(statearr_23451_23530[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (23))){
var inst_23247 = (state_23397[(9)]);
var state_23397__$1 = state_23397;
var statearr_23452_23531 = state_23397__$1;
(statearr_23452_23531[(2)] = inst_23247);

(statearr_23452_23531[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (47))){
var inst_23233 = (state_23397[(10)]);
var inst_23331 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23233);
var inst_23332 = cljs.core.empty_QMARK_.call(null,inst_23331);
var state_23397__$1 = state_23397;
if(inst_23332){
var statearr_23453_23532 = state_23397__$1;
(statearr_23453_23532[(1)] = (50));

} else {
var statearr_23454_23533 = state_23397__$1;
(statearr_23454_23533[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (35))){
var inst_23283 = (state_23397[(15)]);
var inst_23297 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23283);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23297)){
var statearr_23455_23534 = state_23397__$1;
(statearr_23455_23534[(1)] = (38));

} else {
var statearr_23456_23535 = state_23397__$1;
(statearr_23456_23535[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (19))){
var inst_23227 = (state_23397[(8)]);
var inst_23241 = ["_id"];
var inst_23242 = [inst_23227];
var inst_23243 = cljs.core.PersistentHashMap.fromArrays(inst_23241,inst_23242);
var state_23397__$1 = state_23397;
var statearr_23457_23536 = state_23397__$1;
(statearr_23457_23536[(2)] = inst_23243);

(statearr_23457_23536[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (57))){
var state_23397__$1 = state_23397;
var statearr_23458_23537 = state_23397__$1;
(statearr_23458_23537[(2)] = null);

(statearr_23458_23537[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (11))){
var inst_23215 = (state_23397[(2)]);
var inst_23216 = fluree.db.util.log.error.call(null,inst_23215);
var inst_23217 = (function(){throw inst_23215})();
var state_23397__$1 = (function (){var statearr_23460 = state_23397;
(statearr_23460[(21)] = inst_23216);

return statearr_23460;
})();
var statearr_23461_23538 = state_23397__$1;
(statearr_23461_23538[(2)] = inst_23217);

(statearr_23461_23538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (9))){
var _ = (function (){var statearr_23462 = state_23397;
(statearr_23462[(4)] = cljs.core.cons.call(null,(12),(state_23397[(4)])));

return statearr_23462;
})();
var inst_23223 = cljs.core.first.call(null,flakes);
var inst_23224 = fluree.db.query.fql.s.call(null,inst_23223);
var ___$1 = (function (){var statearr_23463 = state_23397;
(statearr_23463[(4)] = cljs.core.rest.call(null,(state_23397[(4)])));

return statearr_23463;
})();
var state_23397__$1 = state_23397;
var statearr_23464_23539 = state_23397__$1;
(statearr_23464_23539[(2)] = inst_23224);

(statearr_23464_23539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (5))){
var _ = (function (){var statearr_23465 = state_23397;
(statearr_23465[(4)] = cljs.core.rest.call(null,(state_23397[(4)])));

return statearr_23465;
})();
var state_23397__$1 = state_23397;
var ex23459 = (state_23397__$1[(2)]);
var statearr_23466_23540 = state_23397__$1;
(statearr_23466_23540[(5)] = ex23459);


if((ex23459 instanceof Error)){
var statearr_23467_23541 = state_23397__$1;
(statearr_23467_23541[(1)] = (4));

(statearr_23467_23541[(5)] = null);

} else {
throw ex23459;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (14))){
var state_23397__$1 = state_23397;
var statearr_23468_23542 = state_23397__$1;
(statearr_23468_23542[(2)] = base_select_spec);

(statearr_23468_23542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (45))){
var inst_23267 = (state_23397[(12)]);
var inst_23269 = (state_23397[(14)]);
var inst_23310 = (state_23397[(2)]);
var inst_23311 = fluree.db.util.async.throw_err.call(null,inst_23310);
var inst_23312 = cljs.core.nth.call(null,inst_23311,(0),null);
var inst_23313 = cljs.core.nth.call(null,inst_23311,(1),null);
var inst_23314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23315 = cljs.core.rest.call(null,inst_23267);
var inst_23316 = [inst_23312,inst_23315,inst_23269,inst_23313];
var inst_23317 = (new cljs.core.PersistentVector(null,4,(5),inst_23314,inst_23316,null));
var state_23397__$1 = state_23397;
var statearr_23469_23543 = state_23397__$1;
(statearr_23469_23543[(2)] = inst_23317);

(statearr_23469_23543[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (53))){
var inst_23267 = (state_23397[(12)]);
var inst_23270 = (state_23397[(13)]);
var inst_23269 = (state_23397[(14)]);
var inst_23278 = (state_23397[(17)]);
var inst_23339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23340 = ["_id"];
var inst_23341 = inst_23278.s;
var inst_23342 = [inst_23341];
var inst_23343 = cljs.core.PersistentHashMap.fromArrays(inst_23340,inst_23342);
var inst_23344 = cljs.core.rest.call(null,inst_23267);
var inst_23345 = [inst_23343,inst_23344,inst_23269,inst_23270];
var inst_23346 = (new cljs.core.PersistentVector(null,4,(5),inst_23339,inst_23345,null));
var state_23397__$1 = state_23397;
var statearr_23470_23544 = state_23397__$1;
(statearr_23470_23544[(2)] = inst_23346);

(statearr_23470_23544[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (26))){
var inst_23267 = (state_23397[(12)]);
var inst_23272 = cljs.core.empty_QMARK_.call(null,inst_23267);
var state_23397__$1 = state_23397;
if(inst_23272){
var statearr_23471_23545 = state_23397__$1;
(statearr_23471_23545[(1)] = (28));

} else {
var statearr_23472_23546 = state_23397__$1;
(statearr_23472_23546[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (16))){
var inst_23234 = (state_23397[(19)]);
var state_23397__$1 = state_23397;
var statearr_23473_23547 = state_23397__$1;
(statearr_23473_23547[(2)] = inst_23234);

(statearr_23473_23547[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (38))){
var inst_23268 = (state_23397[(11)]);
var inst_23267 = (state_23397[(12)]);
var inst_23269 = (state_23397[(14)]);
var inst_23283 = (state_23397[(15)]);
var inst_23233 = (state_23397[(10)]);
var inst_23278 = (state_23397[(17)]);
var inst_23299 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23278,inst_23283,inst_23269,inst_23267,inst_23268,fuel,max_fuel,inst_23233,cache);
var state_23397__$1 = state_23397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23397__$1,(41),inst_23299);
} else {
if((state_val_23398 === (30))){
var inst_23374 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
var statearr_23474_23548 = state_23397__$1;
(statearr_23474_23548[(2)] = inst_23374);

(statearr_23474_23548[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (10))){
var inst_23227 = (state_23397[(2)]);
var inst_23228 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23397__$1 = (function (){var statearr_23475 = state_23397;
(statearr_23475[(8)] = inst_23227);

return statearr_23475;
})();
if(cljs.core.truth_(inst_23228)){
var statearr_23476_23549 = state_23397__$1;
(statearr_23476_23549[(1)] = (13));

} else {
var statearr_23477_23550 = state_23397__$1;
(statearr_23477_23550[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (18))){
var inst_23239 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23239)){
var statearr_23478_23551 = state_23397__$1;
(statearr_23478_23551[(1)] = (19));

} else {
var statearr_23479_23552 = state_23397__$1;
(statearr_23479_23552[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (52))){
var inst_23337 = (state_23397[(2)]);
var state_23397__$1 = state_23397;
if(cljs.core.truth_(inst_23337)){
var statearr_23480_23553 = state_23397__$1;
(statearr_23480_23553[(1)] = (53));

} else {
var statearr_23481_23554 = state_23397__$1;
(statearr_23481_23554[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (42))){
var inst_23268 = (state_23397[(11)]);
var inst_23270 = (state_23397[(13)]);
var inst_23284 = (state_23397[(16)]);
var inst_23283 = (state_23397[(15)]);
var inst_23278 = (state_23397[(17)]);
var inst_23308 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23268,inst_23283,inst_23278,inst_23284,false,inst_23270);
var state_23397__$1 = state_23397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23397__$1,(45),inst_23308);
} else {
if((state_val_23398 === (37))){
var inst_23294 = (state_23397[(2)]);
var inst_23295 = fluree.db.util.async.throw_err.call(null,inst_23294);
var state_23397__$1 = state_23397;
var statearr_23482_23555 = state_23397__$1;
(statearr_23482_23555[(2)] = inst_23295);

(statearr_23482_23555[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (8))){
var inst_23392 = (state_23397[(2)]);
var _ = (function (){var statearr_23483 = state_23397;
(statearr_23483[(4)] = cljs.core.rest.call(null,(state_23397[(4)])));

return statearr_23483;
})();
var state_23397__$1 = state_23397;
var statearr_23484_23556 = state_23397__$1;
(statearr_23484_23556[(2)] = inst_23392);

(statearr_23484_23556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23398 === (49))){
var inst_23267 = (state_23397[(12)]);
var inst_23321 = (state_23397[(18)]);
var inst_23270 = (state_23397[(13)]);
var inst_23269 = (state_23397[(14)]);
var inst_23324 = (state_23397[(2)]);
var inst_23325 = fluree.db.util.async.throw_err.call(null,inst_23324);
var inst_23326 = cljs.core.first.call(null,inst_23325);
var inst_23327 = cljs.core.rest.call(null,inst_23267);
var inst_23328 = [inst_23326,inst_23327,inst_23269,inst_23270];
var inst_23329 = (new cljs.core.PersistentVector(null,4,(5),inst_23321,inst_23328,null));
var state_23397__$1 = state_23397;
var statearr_23485_23557 = state_23397__$1;
(statearr_23485_23557[(2)] = inst_23329);

(statearr_23485_23557[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____0 = (function (){
var statearr_23486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23486[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__);

(statearr_23486[(1)] = (1));

return statearr_23486;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____1 = (function (state_23397){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_23397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e23487){var ex__2457__auto__ = e23487;
var statearr_23488_23558 = state_23397;
(statearr_23488_23558[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_23397[(4)]))){
var statearr_23489_23559 = state_23397;
(statearr_23489_23559[(1)] = cljs.core.first.call(null,(state_23397[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23560 = state_23397;
state_23397 = G__23560;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__ = function(state_23397){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____1.call(this,state_23397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_23490 = f__2477__auto__.call(null);
(statearr_23490[(6)] = c__2476__auto__);

return statearr_23490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23563 = arguments.length;
switch (G__23563) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_23605){
var state_val_23606 = (state_23605[(1)]);
if((state_val_23606 === (7))){
var inst_23571 = (state_23605[(7)]);
var state_23605__$1 = state_23605;
var statearr_23607_23637 = state_23605__$1;
(statearr_23607_23637[(2)] = inst_23571);

(statearr_23607_23637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (1))){
var state_23605__$1 = state_23605;
var statearr_23608_23638 = state_23605__$1;
(statearr_23608_23638[(2)] = null);

(statearr_23608_23638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (4))){
var inst_23564 = (state_23605[(2)]);
var state_23605__$1 = state_23605;
var statearr_23609_23639 = state_23605__$1;
(statearr_23609_23639[(2)] = inst_23564);

(statearr_23609_23639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (15))){
var inst_23599 = (state_23605[(2)]);
var inst_23600 = fluree.db.util.async.throw_err.call(null,inst_23599);
var _ = (function (){var statearr_23610 = state_23605;
(statearr_23610[(4)] = cljs.core.rest.call(null,(state_23605[(4)])));

return statearr_23610;
})();
var state_23605__$1 = state_23605;
var statearr_23611_23640 = state_23605__$1;
(statearr_23611_23640[(2)] = inst_23600);

(statearr_23611_23640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (13))){
var inst_23583 = (state_23605[(8)]);
var state_23605__$1 = state_23605;
var statearr_23612_23641 = state_23605__$1;
(statearr_23612_23641[(2)] = inst_23583);

(statearr_23612_23641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (6))){
var inst_23571 = (state_23605[(7)]);
var inst_23573 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23574 = cljs.core.comp.call(null,inst_23571,inst_23573);
var state_23605__$1 = state_23605;
var statearr_23613_23642 = state_23605__$1;
(statearr_23613_23642[(2)] = inst_23574);

(statearr_23613_23642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (3))){
var inst_23603 = (state_23605[(2)]);
var state_23605__$1 = state_23605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23605__$1,inst_23603);
} else {
if((state_val_23606 === (12))){
var inst_23583 = (state_23605[(8)]);
var inst_23585 = cljs.core.take.call(null,limit);
var inst_23586 = cljs.core.comp.call(null,inst_23583,inst_23585);
var state_23605__$1 = state_23605;
var statearr_23614_23643 = state_23605__$1;
(statearr_23614_23643[(2)] = inst_23586);

(statearr_23614_23643[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (2))){
var _ = (function (){var statearr_23615 = state_23605;
(statearr_23615[(4)] = cljs.core.cons.call(null,(5),(state_23605[(4)])));

return statearr_23615;
})();
var inst_23571 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23605__$1 = (function (){var statearr_23616 = state_23605;
(statearr_23616[(7)] = inst_23571);

return statearr_23616;
})();
if(cljs.core.truth_(fuel)){
var statearr_23617_23644 = state_23605__$1;
(statearr_23617_23644[(1)] = (6));

} else {
var statearr_23618_23645 = state_23605__$1;
(statearr_23618_23645[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (11))){
var inst_23583 = (state_23605[(2)]);
var state_23605__$1 = (function (){var statearr_23620 = state_23605;
(statearr_23620[(8)] = inst_23583);

return statearr_23620;
})();
if(cljs.core.truth_(limit)){
var statearr_23621_23646 = state_23605__$1;
(statearr_23621_23646[(1)] = (12));

} else {
var statearr_23622_23647 = state_23605__$1;
(statearr_23622_23647[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (9))){
var inst_23577 = (state_23605[(9)]);
var inst_23579 = cljs.core.drop.call(null,offset);
var inst_23580 = cljs.core.comp.call(null,inst_23577,inst_23579);
var state_23605__$1 = state_23605;
var statearr_23623_23648 = state_23605__$1;
(statearr_23623_23648[(2)] = inst_23580);

(statearr_23623_23648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (5))){
var _ = (function (){var statearr_23624 = state_23605;
(statearr_23624[(4)] = cljs.core.rest.call(null,(state_23605[(4)])));

return statearr_23624;
})();
var state_23605__$1 = state_23605;
var ex23619 = (state_23605__$1[(2)]);
var statearr_23625_23649 = state_23605__$1;
(statearr_23625_23649[(5)] = ex23619);


if((ex23619 instanceof Error)){
var statearr_23626_23650 = state_23605__$1;
(statearr_23626_23650[(1)] = (4));

(statearr_23626_23650[(5)] = null);

} else {
throw ex23619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (14))){
var inst_23589 = (state_23605[(2)]);
var inst_23590 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23591 = cljs.core.halt_when.call(null,inst_23590);
var inst_23592 = cljs.core.comp.call(null,inst_23589,inst_23591);
var inst_23593 = cljs.core.sequence.call(null,inst_23592,flakes);
var inst_23594 = cljs.core.PersistentVector.EMPTY;
var inst_23595 = (function (){var xf = inst_23592;
var flakes_by_sub = inst_23593;
return (function (p1__23561_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23561_SHARP_);
});
})();
var inst_23596 = cljs.core.map.call(null,inst_23595,inst_23593);
var inst_23597 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23594,inst_23596);
var state_23605__$1 = state_23605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23605__$1,(15),inst_23597);
} else {
if((state_val_23606 === (10))){
var inst_23577 = (state_23605[(9)]);
var state_23605__$1 = state_23605;
var statearr_23627_23651 = state_23605__$1;
(statearr_23627_23651[(2)] = inst_23577);

(statearr_23627_23651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23606 === (8))){
var inst_23577 = (state_23605[(2)]);
var state_23605__$1 = (function (){var statearr_23628 = state_23605;
(statearr_23628[(9)] = inst_23577);

return statearr_23628;
})();
if(cljs.core.truth_(offset)){
var statearr_23629_23652 = state_23605__$1;
(statearr_23629_23652[(1)] = (9));

} else {
var statearr_23630_23653 = state_23605__$1;
(statearr_23630_23653[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2454__auto__ = null;
var fluree$db$query$fql$state_machine__2454__auto____0 = (function (){
var statearr_23631 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23631[(0)] = fluree$db$query$fql$state_machine__2454__auto__);

(statearr_23631[(1)] = (1));

return statearr_23631;
});
var fluree$db$query$fql$state_machine__2454__auto____1 = (function (state_23605){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_23605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e23632){var ex__2457__auto__ = e23632;
var statearr_23633_23654 = state_23605;
(statearr_23633_23654[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_23605[(4)]))){
var statearr_23634_23655 = state_23605;
(statearr_23634_23655[(1)] = cljs.core.first.call(null,(state_23605[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23656 = state_23605;
state_23605 = G__23656;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2454__auto__ = function(state_23605){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2454__auto____1.call(this,state_23605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2454__auto____0;
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2454__auto____1;
return fluree$db$query$fql$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_23635 = f__2477__auto__.call(null);
(statearr_23635[(6)] = c__2476__auto__);

return statearr_23635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23658 = arguments.length;
switch (G__23658) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_23742){
var state_val_23743 = (state_23742[(1)]);
if((state_val_23743 === (7))){
var inst_23737 = (state_23742[(2)]);
var _ = (function (){var statearr_23745 = state_23742;
(statearr_23745[(4)] = cljs.core.rest.call(null,(state_23742[(4)])));

return statearr_23745;
})();
var state_23742__$1 = state_23742;
var statearr_23746_23793 = state_23742__$1;
(statearr_23746_23793[(2)] = inst_23737);

(statearr_23746_23793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (20))){
var inst_23679 = (state_23742[(7)]);
var inst_23678 = (state_23742[(8)]);
var inst_23686 = (state_23742[(9)]);
var inst_23707 = (inst_23678 + (1));
var tmp23744 = inst_23679;
var inst_23677 = inst_23686;
var inst_23678__$1 = inst_23707;
var inst_23679__$1 = tmp23744;
var state_23742__$1 = (function (){var statearr_23747 = state_23742;
(statearr_23747[(7)] = inst_23679__$1);

(statearr_23747[(8)] = inst_23678__$1);

(statearr_23747[(10)] = inst_23677);

return statearr_23747;
})();
var statearr_23748_23794 = state_23742__$1;
(statearr_23748_23794[(2)] = null);

(statearr_23748_23794[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (27))){
var inst_23712 = (state_23742[(11)]);
var inst_23721 = (state_23742[(2)]);
var inst_23722 = fluree.db.util.async.throw_err.call(null,inst_23721);
var inst_23723 = inst_23712.call(null,inst_23722);
var state_23742__$1 = state_23742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23742__$1,(26),inst_23723);
} else {
if((state_val_23743 === (1))){
var state_23742__$1 = state_23742;
var statearr_23749_23795 = state_23742__$1;
(statearr_23749_23795[(2)] = null);

(statearr_23749_23795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (24))){
var state_23742__$1 = state_23742;
var statearr_23750_23796 = state_23742__$1;
(statearr_23750_23796[(2)] = null);

(statearr_23750_23796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (4))){
var inst_23659 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
var statearr_23751_23797 = state_23742__$1;
(statearr_23751_23797[(2)] = inst_23659);

(statearr_23751_23797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (15))){
var inst_23700 = (state_23742[(12)]);
var inst_23700__$1 = offset;
var state_23742__$1 = (function (){var statearr_23752 = state_23742;
(statearr_23752[(12)] = inst_23700__$1);

return statearr_23752;
})();
if(cljs.core.truth_(inst_23700__$1)){
var statearr_23753_23798 = state_23742__$1;
(statearr_23753_23798[(1)] = (17));

} else {
var statearr_23754_23799 = state_23742__$1;
(statearr_23754_23799[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (21))){
var state_23742__$1 = state_23742;
var statearr_23755_23800 = state_23742__$1;
(statearr_23755_23800[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (13))){
var inst_23695 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
var statearr_23757_23801 = state_23742__$1;
(statearr_23757_23801[(2)] = inst_23695);

(statearr_23757_23801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (22))){
var inst_23733 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
var statearr_23758_23802 = state_23742__$1;
(statearr_23758_23802[(2)] = inst_23733);

(statearr_23758_23802[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (6))){
var inst_23687 = (state_23742[(13)]);
var inst_23685 = (state_23742[(14)]);
var inst_23677 = (state_23742[(10)]);
var inst_23684 = cljs.core.seq.call(null,inst_23677);
var inst_23685__$1 = cljs.core.first.call(null,inst_23684);
var inst_23686 = cljs.core.next.call(null,inst_23684);
var inst_23687__$1 = (inst_23685__$1 == null);
var state_23742__$1 = (function (){var statearr_23759 = state_23742;
(statearr_23759[(13)] = inst_23687__$1);

(statearr_23759[(14)] = inst_23685__$1);

(statearr_23759[(9)] = inst_23686);

return statearr_23759;
})();
if(cljs.core.truth_(inst_23687__$1)){
var statearr_23760_23803 = state_23742__$1;
(statearr_23760_23803[(1)] = (8));

} else {
var statearr_23761_23804 = state_23742__$1;
(statearr_23761_23804[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (25))){
var inst_23731 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
var statearr_23762_23805 = state_23742__$1;
(statearr_23762_23805[(2)] = inst_23731);

(statearr_23762_23805[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (17))){
var inst_23678 = (state_23742[(8)]);
var inst_23702 = (inst_23678 < offset);
var state_23742__$1 = state_23742;
var statearr_23763_23806 = state_23742__$1;
(statearr_23763_23806[(2)] = inst_23702);

(statearr_23763_23806[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (3))){
var inst_23740 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23742__$1,inst_23740);
} else {
if((state_val_23743 === (12))){
var inst_23690 = (state_23742[(15)]);
var state_23742__$1 = state_23742;
var statearr_23764_23807 = state_23742__$1;
(statearr_23764_23807[(2)] = inst_23690);

(statearr_23764_23807[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (2))){
var inst_23672 = (state_23742[(16)]);
var _ = (function (){var statearr_23765 = state_23742;
(statearr_23765[(4)] = cljs.core.cons.call(null,(5),(state_23742[(4)])));

return statearr_23765;
})();
var inst_23672__$1 = subjects;
var inst_23673 = cljs.core.seq.call(null,inst_23672__$1);
var inst_23674 = cljs.core.first.call(null,inst_23673);
var inst_23675 = cljs.core.next.call(null,inst_23673);
var inst_23676 = cljs.core.PersistentVector.EMPTY;
var inst_23677 = inst_23672__$1;
var inst_23678 = (0);
var inst_23679 = inst_23676;
var state_23742__$1 = (function (){var statearr_23766 = state_23742;
(statearr_23766[(7)] = inst_23679);

(statearr_23766[(8)] = inst_23678);

(statearr_23766[(17)] = inst_23675);

(statearr_23766[(18)] = inst_23674);

(statearr_23766[(16)] = inst_23672__$1);

(statearr_23766[(10)] = inst_23677);

return statearr_23766;
})();
var statearr_23767_23808 = state_23742__$1;
(statearr_23767_23808[(2)] = null);

(statearr_23767_23808[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (23))){
var inst_23679 = (state_23742[(7)]);
var inst_23678 = (state_23742[(8)]);
var inst_23675 = (state_23742[(17)]);
var inst_23674 = (state_23742[(18)]);
var inst_23685 = (state_23742[(14)]);
var inst_23686 = (state_23742[(9)]);
var inst_23672 = (state_23742[(16)]);
var inst_23677 = (state_23742[(10)]);
var inst_23711 = (inst_23678 + (1));
var inst_23712 = (function (){var G__23668 = inst_23677;
var seq__23670 = inst_23675;
var first__23671 = inst_23674;
var r = inst_23686;
var seq__23682 = inst_23686;
var first__23683 = inst_23685;
var acc = inst_23679;
var n = inst_23678;
var s = inst_23685;
var vec__23681 = inst_23677;
var vec__23669 = inst_23672;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23714 = [inst_23685];
var inst_23715 = (new cljs.core.PersistentVector(null,1,(5),inst_23713,inst_23714,null));
var inst_23716 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23717 = [limit];
var inst_23718 = cljs.core.PersistentHashMap.fromArrays(inst_23716,inst_23717);
var inst_23719 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23715,inst_23718);
var state_23742__$1 = (function (){var statearr_23768 = state_23742;
(statearr_23768[(11)] = inst_23712);

(statearr_23768[(19)] = inst_23711);

return statearr_23768;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23742__$1,(27),inst_23719);
} else {
if((state_val_23743 === (19))){
var inst_23705 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
if(cljs.core.truth_(inst_23705)){
var statearr_23769_23809 = state_23742__$1;
(statearr_23769_23809[(1)] = (20));

} else {
var statearr_23770_23810 = state_23742__$1;
(statearr_23770_23810[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (11))){
var inst_23678 = (state_23742[(8)]);
var inst_23692 = (inst_23678 > limit);
var state_23742__$1 = state_23742;
var statearr_23772_23811 = state_23742__$1;
(statearr_23772_23811[(2)] = inst_23692);

(statearr_23772_23811[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (9))){
var inst_23690 = (state_23742[(15)]);
var inst_23690__$1 = limit;
var state_23742__$1 = (function (){var statearr_23773 = state_23742;
(statearr_23773[(15)] = inst_23690__$1);

return statearr_23773;
})();
if(cljs.core.truth_(inst_23690__$1)){
var statearr_23774_23812 = state_23742__$1;
(statearr_23774_23812[(1)] = (11));

} else {
var statearr_23775_23813 = state_23742__$1;
(statearr_23775_23813[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (5))){
var _ = (function (){var statearr_23776 = state_23742;
(statearr_23776[(4)] = cljs.core.rest.call(null,(state_23742[(4)])));

return statearr_23776;
})();
var state_23742__$1 = state_23742;
var ex23771 = (state_23742__$1[(2)]);
var statearr_23777_23814 = state_23742__$1;
(statearr_23777_23814[(5)] = ex23771);


if((ex23771 instanceof Error)){
var statearr_23778_23815 = state_23742__$1;
(statearr_23778_23815[(1)] = (4));

(statearr_23778_23815[(5)] = null);

} else {
throw ex23771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (14))){
var inst_23679 = (state_23742[(7)]);
var state_23742__$1 = state_23742;
var statearr_23779_23816 = state_23742__$1;
(statearr_23779_23816[(2)] = inst_23679);

(statearr_23779_23816[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (26))){
var inst_23679 = (state_23742[(7)]);
var inst_23711 = (state_23742[(19)]);
var inst_23686 = (state_23742[(9)]);
var inst_23725 = (state_23742[(2)]);
var inst_23726 = fluree.db.util.async.throw_err.call(null,inst_23725);
var inst_23727 = cljs.core.conj.call(null,inst_23679,inst_23726);
var inst_23677 = inst_23686;
var inst_23678 = inst_23711;
var inst_23679__$1 = inst_23727;
var state_23742__$1 = (function (){var statearr_23780 = state_23742;
(statearr_23780[(7)] = inst_23679__$1);

(statearr_23780[(8)] = inst_23678);

(statearr_23780[(10)] = inst_23677);

return statearr_23780;
})();
var statearr_23781_23817 = state_23742__$1;
(statearr_23781_23817[(2)] = null);

(statearr_23781_23817[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (16))){
var inst_23735 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
var statearr_23782_23818 = state_23742__$1;
(statearr_23782_23818[(2)] = inst_23735);

(statearr_23782_23818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (10))){
var inst_23697 = (state_23742[(2)]);
var state_23742__$1 = state_23742;
if(cljs.core.truth_(inst_23697)){
var statearr_23783_23819 = state_23742__$1;
(statearr_23783_23819[(1)] = (14));

} else {
var statearr_23784_23820 = state_23742__$1;
(statearr_23784_23820[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (18))){
var inst_23700 = (state_23742[(12)]);
var state_23742__$1 = state_23742;
var statearr_23785_23821 = state_23742__$1;
(statearr_23785_23821[(2)] = inst_23700);

(statearr_23785_23821[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23743 === (8))){
var inst_23687 = (state_23742[(13)]);
var state_23742__$1 = state_23742;
var statearr_23786_23822 = state_23742__$1;
(statearr_23786_23822[(2)] = inst_23687);

(statearr_23786_23822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2454__auto__ = null;
var fluree$db$query$fql$state_machine__2454__auto____0 = (function (){
var statearr_23787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23787[(0)] = fluree$db$query$fql$state_machine__2454__auto__);

(statearr_23787[(1)] = (1));

return statearr_23787;
});
var fluree$db$query$fql$state_machine__2454__auto____1 = (function (state_23742){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_23742);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e23788){var ex__2457__auto__ = e23788;
var statearr_23789_23823 = state_23742;
(statearr_23789_23823[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_23742[(4)]))){
var statearr_23790_23824 = state_23742;
(statearr_23790_23824[(1)] = cljs.core.first.call(null,(state_23742[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23825 = state_23742;
state_23742 = G__23825;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2454__auto__ = function(state_23742){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2454__auto____1.call(this,state_23742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2454__auto____0;
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2454__auto____1;
return fluree$db$query$fql$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_23791 = f__2477__auto__.call(null);
(statearr_23791[(6)] = c__2476__auto__);

return statearr_23791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23827 = arguments.length;
switch (G__23827) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24015){
var state_val_24016 = (state_24015[(1)]);
if((state_val_24016 === (7))){
var state_24015__$1 = state_24015;
var statearr_24017_24088 = state_24015__$1;
(statearr_24017_24088[(2)] = null);

(statearr_24017_24088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (20))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23898 = (state_24015[(2)]);
var inst_23899 = fluree.db.util.async.throw_err.call(null,inst_23898);
var inst_23900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23901 = [inst_23868];
var inst_23902 = (new cljs.core.PersistentVector(null,1,(5),inst_23900,inst_23901,null));
var inst_23903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23904 = [inst_23868,inst_23870];
var inst_23905 = (new cljs.core.PersistentVector(null,2,(5),inst_23903,inst_23904,null));
var inst_23906 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23902,cljs.core._LT_,inst_23905);
var state_24015__$1 = (function (){var statearr_24018 = state_24015;
(statearr_24018[(9)] = inst_23899);

return statearr_24018;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(21),inst_23906);
} else {
if((state_val_24016 === (27))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23935 = inst_23887.call(null,cljs.core._GT__EQ_,inst_23869);
var state_24015__$1 = state_24015;
if(cljs.core.truth_(inst_23935)){
var statearr_24019_24089 = state_24015__$1;
(statearr_24019_24089[(1)] = (30));

} else {
var statearr_24020_24090 = state_24015__$1;
(statearr_24020_24090[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (1))){
var state_24015__$1 = state_24015;
var statearr_24021_24091 = state_24015__$1;
(statearr_24021_24091[(2)] = null);

(statearr_24021_24091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (24))){
var inst_23984 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24022_24092 = state_24015__$1;
(statearr_24022_24092[(2)] = inst_23984);

(statearr_24022_24092[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (39))){
var inst_23974 = null;
var state_24015__$1 = state_24015;
var statearr_24023_24093 = state_24015__$1;
(statearr_24023_24093[(2)] = inst_23974);

(statearr_24023_24093[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (46))){
var inst_23861 = (state_24015[(12)]);
var inst_23995 = (state_24015[(13)]);
var inst_23853 = inst_23861;
var inst_23854 = inst_23995;
var state_24015__$1 = (function (){var statearr_24024 = state_24015;
(statearr_24024[(14)] = inst_23854);

(statearr_24024[(15)] = inst_23853);

return statearr_24024;
})();
var statearr_24025_24094 = state_24015__$1;
(statearr_24025_24094[(2)] = null);

(statearr_24025_24094[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (4))){
var inst_23828 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24026_24095 = state_24015__$1;
(statearr_24026_24095[(2)] = inst_23828);

(statearr_24026_24095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (15))){
var state_24015__$1 = state_24015;
var statearr_24027_24096 = state_24015__$1;
(statearr_24027_24096[(2)] = null);

(statearr_24027_24096[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (21))){
var inst_23899 = (state_24015[(9)]);
var inst_23908 = (state_24015[(2)]);
var inst_23909 = fluree.db.util.async.throw_err.call(null,inst_23908);
var inst_23910 = cljs.core.concat.call(null,inst_23899,inst_23909);
var state_24015__$1 = state_24015;
var statearr_24028_24097 = state_24015__$1;
(statearr_24028_24097[(2)] = inst_23910);

(statearr_24028_24097[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (31))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23948 = inst_23887.call(null,cljs.core._LT_,inst_23869);
var state_24015__$1 = state_24015;
if(cljs.core.truth_(inst_23948)){
var statearr_24029_24098 = state_24015__$1;
(statearr_24029_24098[(1)] = (34));

} else {
var statearr_24030_24099 = state_24015__$1;
(statearr_24030_24099[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (32))){
var inst_23980 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24031_24100 = state_24015__$1;
(statearr_24031_24100[(2)] = inst_23980);

(statearr_24031_24100[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (40))){
var inst_23976 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24032_24101 = state_24015__$1;
(statearr_24032_24101[(2)] = inst_23976);

(statearr_24032_24101[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (33))){
var inst_23945 = (state_24015[(2)]);
var inst_23946 = fluree.db.util.async.throw_err.call(null,inst_23945);
var state_24015__$1 = state_24015;
var statearr_24033_24102 = state_24015__$1;
(statearr_24033_24102[(2)] = inst_23946);

(statearr_24033_24102[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (13))){
var inst_24005 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24034_24103 = state_24015__$1;
(statearr_24034_24103[(2)] = inst_24005);

(statearr_24034_24103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (22))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23915 = [inst_23868,inst_23870];
var inst_23916 = (new cljs.core.PersistentVector(null,2,(5),inst_23914,inst_23915,null));
var inst_23917 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23916);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(25),inst_23917);
} else {
if((state_val_24016 === (36))){
var inst_23978 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24035_24104 = state_24015__$1;
(statearr_24035_24104[(2)] = inst_23978);

(statearr_24035_24104[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (41))){
var inst_23971 = (state_24015[(2)]);
var inst_23972 = fluree.db.util.async.throw_err.call(null,inst_23971);
var state_24015__$1 = state_24015;
var statearr_24036_24105 = state_24015__$1;
(statearr_24036_24105[(2)] = inst_23972);

(statearr_24036_24105[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (43))){
var inst_23987 = (state_24015[(16)]);
var inst_23854 = (state_24015[(14)]);
var inst_23988 = cljs.core.into.call(null,inst_23854,inst_23987);
var state_24015__$1 = state_24015;
var statearr_24037_24106 = state_24015__$1;
(statearr_24037_24106[(2)] = inst_23988);

(statearr_24037_24106[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (29))){
var inst_23932 = (state_24015[(2)]);
var inst_23933 = fluree.db.util.async.throw_err.call(null,inst_23932);
var state_24015__$1 = state_24015;
var statearr_24038_24107 = state_24015__$1;
(statearr_24038_24107[(2)] = inst_23933);

(statearr_24038_24107[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (44))){
var inst_23987 = (state_24015[(16)]);
var inst_23854 = (state_24015[(14)]);
var inst_23990 = cljs.core.PersistentHashSet.EMPTY;
var inst_23991 = cljs.core.into.call(null,inst_23990,inst_23987);
var inst_23992 = clojure.set.intersection.call(null,inst_23854,inst_23991);
var state_24015__$1 = state_24015;
var statearr_24039_24108 = state_24015__$1;
(statearr_24039_24108[(2)] = inst_23992);

(statearr_24039_24108[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (6))){
var inst_23839 = (state_24015[(17)]);
var inst_23849 = cljs.core.seq.call(null,inst_23839);
var inst_23850 = cljs.core.first.call(null,inst_23849);
var inst_23851 = cljs.core.next.call(null,inst_23849);
var inst_23852 = cljs.core.PersistentHashSet.EMPTY;
var inst_23853 = inst_23839;
var inst_23854 = inst_23852;
var state_24015__$1 = (function (){var statearr_24040 = state_24015;
(statearr_24040[(18)] = inst_23851);

(statearr_24040[(14)] = inst_23854);

(statearr_24040[(15)] = inst_23853);

(statearr_24040[(19)] = inst_23850);

return statearr_24040;
})();
var statearr_24041_24109 = state_24015__$1;
(statearr_24041_24109[(2)] = null);

(statearr_24041_24109[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (28))){
var inst_23982 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24042_24110 = state_24015__$1;
(statearr_24042_24110[(2)] = inst_23982);

(statearr_24042_24110[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (25))){
var inst_23919 = (state_24015[(2)]);
var inst_23920 = fluree.db.util.async.throw_err.call(null,inst_23919);
var state_24015__$1 = state_24015;
var statearr_24043_24111 = state_24015__$1;
(statearr_24043_24111[(2)] = inst_23920);

(statearr_24043_24111[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (34))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23951 = [inst_23868];
var inst_23952 = (new cljs.core.PersistentVector(null,1,(5),inst_23950,inst_23951,null));
var inst_23953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23954 = [inst_23868,inst_23870];
var inst_23955 = (new cljs.core.PersistentVector(null,2,(5),inst_23953,inst_23954,null));
var inst_23956 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23952,cljs.core._LT_,inst_23955);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(37),inst_23956);
} else {
if((state_val_24016 === (17))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23891 = [inst_23868,inst_23870];
var inst_23892 = (new cljs.core.PersistentVector(null,2,(5),inst_23890,inst_23891,null));
var inst_23893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23894 = [inst_23868];
var inst_23895 = (new cljs.core.PersistentVector(null,1,(5),inst_23893,inst_23894,null));
var inst_23896 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23892,cljs.core._LT__EQ_,inst_23895);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(20),inst_23896);
} else {
if((state_val_24016 === (3))){
var inst_24013 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24015__$1,inst_24013);
} else {
if((state_val_24016 === (12))){
var inst_23868 = (state_24015[(7)]);
var inst_23860 = (state_24015[(20)]);
var inst_23868__$1 = cljs.core.nth.call(null,inst_23860,(0),null);
var inst_23869 = cljs.core.nth.call(null,inst_23860,(1),null);
var inst_23870 = cljs.core.nth.call(null,inst_23860,(2),null);
var inst_23871 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_23868__$1);
var inst_23872 = cljs.core.not.call(null,inst_23871);
var state_24015__$1 = (function (){var statearr_24044 = state_24015;
(statearr_24044[(7)] = inst_23868__$1);

(statearr_24044[(11)] = inst_23869);

(statearr_24044[(8)] = inst_23870);

return statearr_24044;
})();
if(inst_23872){
var statearr_24045_24112 = state_24015__$1;
(statearr_24045_24112[(1)] = (14));

} else {
var statearr_24046_24113 = state_24015__$1;
(statearr_24046_24113[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (2))){
var inst_23839 = (state_24015[(17)]);
var _ = (function (){var statearr_24047 = state_24015;
(statearr_24047[(4)] = cljs.core.cons.call(null,(5),(state_24015[(4)])));

return statearr_24047;
})();
var inst_23837 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_23838 = cljs.core.nth.call(null,inst_23837,(0),null);
var inst_23839__$1 = cljs.core.nth.call(null,inst_23837,(1),null);
var inst_23840 = cljs.core.not_empty.call(null,inst_23839__$1);
var state_24015__$1 = (function (){var statearr_24048 = state_24015;
(statearr_24048[(17)] = inst_23839__$1);

(statearr_24048[(21)] = inst_23838);

return statearr_24048;
})();
if(cljs.core.truth_(inst_23840)){
var statearr_24049_24114 = state_24015__$1;
(statearr_24049_24114[(1)] = (6));

} else {
var statearr_24050_24115 = state_24015__$1;
(statearr_24050_24115[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (23))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23922 = inst_23887.call(null,cljs.core._GT_,inst_23869);
var state_24015__$1 = state_24015;
if(cljs.core.truth_(inst_23922)){
var statearr_24051_24116 = state_24015__$1;
(statearr_24051_24116[(1)] = (26));

} else {
var statearr_24052_24117 = state_24015__$1;
(statearr_24052_24117[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (47))){
var inst_24003 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24053_24118 = state_24015__$1;
(statearr_24053_24118[(2)] = inst_24003);

(statearr_24053_24118[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (35))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23961 = inst_23887.call(null,cljs.core._LT__EQ_,inst_23869);
var state_24015__$1 = state_24015;
if(cljs.core.truth_(inst_23961)){
var statearr_24054_24119 = state_24015__$1;
(statearr_24054_24119[(1)] = (38));

} else {
var statearr_24055_24120 = state_24015__$1;
(statearr_24055_24120[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (19))){
var inst_23838 = (state_24015[(21)]);
var inst_23986 = (state_24015[(2)]);
var inst_23987 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23986);
var state_24015__$1 = (function (){var statearr_24056 = state_24015;
(statearr_24056[(16)] = inst_23987);

return statearr_24056;
})();
var G__24057_24121 = inst_23838;
var G__24057_24122__$1 = (((G__24057_24121 instanceof cljs.core.Keyword))?G__24057_24121.fqn:null);
switch (G__24057_24122__$1) {
case "or":
var statearr_24058_24124 = state_24015__$1;
(statearr_24058_24124[(1)] = (43));


break;
case "and":
var statearr_24059_24125 = state_24015__$1;
(statearr_24059_24125[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24057_24122__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (11))){
var inst_23854 = (state_24015[(14)]);
var state_24015__$1 = state_24015;
var statearr_24061_24126 = state_24015__$1;
(statearr_24061_24126[(2)] = inst_23854);

(statearr_24061_24126[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (9))){
var inst_23860 = (state_24015[(20)]);
var inst_23853 = (state_24015[(15)]);
var inst_23859 = cljs.core.seq.call(null,inst_23853);
var inst_23860__$1 = cljs.core.first.call(null,inst_23859);
var inst_23861 = cljs.core.next.call(null,inst_23859);
var inst_23862 = cljs.core.not.call(null,inst_23860__$1);
var state_24015__$1 = (function (){var statearr_24062 = state_24015;
(statearr_24062[(12)] = inst_23861);

(statearr_24062[(20)] = inst_23860__$1);

return statearr_24062;
})();
if(inst_23862){
var statearr_24063_24127 = state_24015__$1;
(statearr_24063_24127[(1)] = (11));

} else {
var statearr_24064_24128 = state_24015__$1;
(statearr_24064_24128[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (5))){
var _ = (function (){var statearr_24065 = state_24015;
(statearr_24065[(4)] = cljs.core.rest.call(null,(state_24015[(4)])));

return statearr_24065;
})();
var state_24015__$1 = state_24015;
var ex24060 = (state_24015__$1[(2)]);
var statearr_24066_24129 = state_24015__$1;
(statearr_24066_24129[(5)] = ex24060);


if((ex24060 instanceof Error)){
var statearr_24067_24130 = state_24015__$1;
(statearr_24067_24130[(1)] = (4));

(statearr_24067_24130[(5)] = null);

} else {
throw ex24060;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (14))){
var inst_23868 = (state_24015[(7)]);
var inst_23874 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23868);
var inst_23875 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23874)].join('');
var inst_23876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23877 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23878 = cljs.core.PersistentHashMap.fromArrays(inst_23876,inst_23877);
var inst_23879 = cljs.core.ex_info.call(null,inst_23875,inst_23878);
var inst_23880 = (function(){throw inst_23879})();
var state_24015__$1 = state_24015;
var statearr_24068_24131 = state_24015__$1;
(statearr_24068_24131[(2)] = inst_23880);

(statearr_24068_24131[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (45))){
var inst_23995 = (state_24015[(13)]);
var state_24015__$1 = state_24015;
var statearr_24069_24132 = state_24015__$1;
(statearr_24069_24132[(2)] = inst_23995);

(statearr_24069_24132[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (26))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23925 = [inst_23868,inst_23870];
var inst_23926 = (new cljs.core.PersistentVector(null,2,(5),inst_23924,inst_23925,null));
var inst_23927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23928 = [inst_23868];
var inst_23929 = (new cljs.core.PersistentVector(null,1,(5),inst_23927,inst_23928,null));
var inst_23930 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23926,cljs.core._LT__EQ_,inst_23929);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(29),inst_23930);
} else {
if((state_val_24016 === (16))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23883 = (state_24015[(2)]);
var inst_23887__$1 = cljs.core.identical_QMARK_;
var inst_23888 = inst_23887__$1.call(null,cljs.core.not_EQ_,inst_23869);
var state_24015__$1 = (function (){var statearr_24070 = state_24015;
(statearr_24070[(10)] = inst_23887__$1);

(statearr_24070[(22)] = inst_23883);

return statearr_24070;
})();
if(cljs.core.truth_(inst_23888)){
var statearr_24071_24133 = state_24015__$1;
(statearr_24071_24133[(1)] = (17));

} else {
var statearr_24072_24134 = state_24015__$1;
(statearr_24072_24134[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (38))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23964 = [inst_23868];
var inst_23965 = (new cljs.core.PersistentVector(null,1,(5),inst_23963,inst_23964,null));
var inst_23966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23967 = [inst_23868,inst_23870];
var inst_23968 = (new cljs.core.PersistentVector(null,2,(5),inst_23966,inst_23967,null));
var inst_23969 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23965,cljs.core._LT__EQ_,inst_23968);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(41),inst_23969);
} else {
if((state_val_24016 === (30))){
var inst_23868 = (state_24015[(7)]);
var inst_23870 = (state_24015[(8)]);
var inst_23937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23938 = [inst_23868,inst_23870];
var inst_23939 = (new cljs.core.PersistentVector(null,2,(5),inst_23937,inst_23938,null));
var inst_23940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23941 = [inst_23868];
var inst_23942 = (new cljs.core.PersistentVector(null,1,(5),inst_23940,inst_23941,null));
var inst_23943 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23939,cljs.core._LT__EQ_,inst_23942);
var state_24015__$1 = state_24015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24015__$1,(33),inst_23943);
} else {
if((state_val_24016 === (10))){
var inst_24007 = (state_24015[(2)]);
var state_24015__$1 = state_24015;
var statearr_24073_24135 = state_24015__$1;
(statearr_24073_24135[(2)] = inst_24007);

(statearr_24073_24135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (18))){
var inst_23887 = (state_24015[(10)]);
var inst_23869 = (state_24015[(11)]);
var inst_23912 = inst_23887.call(null,cljs.core._EQ_,inst_23869);
var state_24015__$1 = state_24015;
if(cljs.core.truth_(inst_23912)){
var statearr_24074_24136 = state_24015__$1;
(statearr_24074_24136[(1)] = (22));

} else {
var statearr_24075_24137 = state_24015__$1;
(statearr_24075_24137[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (42))){
var inst_23838 = (state_24015[(21)]);
var inst_23995 = (state_24015[(13)]);
var inst_23995__$1 = (state_24015[(2)]);
var inst_23996 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_23838);
var inst_23997 = cljs.core.empty_QMARK_.call(null,inst_23995__$1);
var inst_23998 = ((inst_23996) && (inst_23997));
var state_24015__$1 = (function (){var statearr_24076 = state_24015;
(statearr_24076[(13)] = inst_23995__$1);

return statearr_24076;
})();
if(cljs.core.truth_(inst_23998)){
var statearr_24077_24138 = state_24015__$1;
(statearr_24077_24138[(1)] = (45));

} else {
var statearr_24078_24139 = state_24015__$1;
(statearr_24078_24139[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (37))){
var inst_23958 = (state_24015[(2)]);
var inst_23959 = fluree.db.util.async.throw_err.call(null,inst_23958);
var state_24015__$1 = state_24015;
var statearr_24079_24140 = state_24015__$1;
(statearr_24079_24140[(2)] = inst_23959);

(statearr_24079_24140[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24016 === (8))){
var inst_24010 = (state_24015[(2)]);
var _ = (function (){var statearr_24080 = state_24015;
(statearr_24080[(4)] = cljs.core.rest.call(null,(state_24015[(4)])));

return statearr_24080;
})();
var state_24015__$1 = state_24015;
var statearr_24081_24141 = state_24015__$1;
(statearr_24081_24141[(2)] = inst_24010);

(statearr_24081_24141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2454__auto__ = null;
var fluree$db$query$fql$state_machine__2454__auto____0 = (function (){
var statearr_24082 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24082[(0)] = fluree$db$query$fql$state_machine__2454__auto__);

(statearr_24082[(1)] = (1));

return statearr_24082;
});
var fluree$db$query$fql$state_machine__2454__auto____1 = (function (state_24015){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24083){var ex__2457__auto__ = e24083;
var statearr_24084_24142 = state_24015;
(statearr_24084_24142[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24015[(4)]))){
var statearr_24085_24143 = state_24015;
(statearr_24085_24143[(1)] = cljs.core.first.call(null,(state_24015[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24144 = state_24015;
state_24015 = G__24144;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2454__auto__ = function(state_24015){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2454__auto____1.call(this,state_24015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2454__auto____0;
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2454__auto____1;
return fluree$db$query$fql$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24086 = f__2477__auto__.call(null);
(statearr_24086[(6)] = c__2476__auto__);

return statearr_24086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__24146,offset,limit){
var map__24147 = p__24146;
var map__24147__$1 = (((((!((map__24147 == null))))?(((((map__24147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24147):map__24147);
var res = map__24147__$1;
var headers = cljs.core.get.call(null,map__24147__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24147__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24149 = orderBy;
var order = cljs.core.nth.call(null,vec__24149,(0),null);
var var$ = cljs.core.nth.call(null,vec__24149,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__24152 = cljs.core.sort_by.call(null,(function (p1__24145_SHARP_){
return cljs.core.nth.call(null,p1__24145_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__24152__$1 = ((cljs.core._EQ_.call(null,"DESC",order))?cljs.core.reverse.call(null,G__24152):G__24152);
var G__24152__$2 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__24152__$1):G__24152__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__24152__$2);
} else {
return G__24152__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__24153_SHARP_){
return ((typeof p1__24153_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__24153_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24154_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24154_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24158 = vars;
var vec__24159 = G__24158;
var seq__24160 = cljs.core.seq.call(null,vec__24159);
var first__24161 = cljs.core.first.call(null,seq__24160);
var seq__24160__$1 = cljs.core.next.call(null,seq__24160);
var var$ = first__24161;
var r = seq__24160__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24158__$1 = G__24158;
var all_vars__$1 = all_vars;
while(true){
var vec__24165 = G__24158__$1;
var seq__24166 = cljs.core.seq.call(null,vec__24165);
var first__24167 = cljs.core.first.call(null,seq__24166);
var seq__24166__$1 = cljs.core.next.call(null,seq__24166);
var var$__$1 = first__24167;
var r__$1 = seq__24166__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24168 = r__$1;
var G__24169 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24158__$1 = G__24168;
all_vars__$1 = G__24169;
continue;
} else {
var G__24170 = r__$1;
var G__24171 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24158__$1 = G__24170;
all_vars__$1 = G__24171;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24206){
var state_val_24207 = (state_24206[(1)]);
if((state_val_24207 === (1))){
var inst_24179 = functionArray;
var inst_24180 = cljs.core.seq.call(null,inst_24179);
var inst_24181 = cljs.core.first.call(null,inst_24180);
var inst_24182 = cljs.core.next.call(null,inst_24180);
var inst_24183 = cljs.core.PersistentVector.EMPTY;
var inst_24184 = inst_24179;
var inst_24185 = inst_24183;
var state_24206__$1 = (function (){var statearr_24208 = state_24206;
(statearr_24208[(7)] = inst_24185);

(statearr_24208[(8)] = inst_24184);

(statearr_24208[(9)] = inst_24182);

(statearr_24208[(10)] = inst_24181);

return statearr_24208;
})();
var statearr_24209_24222 = state_24206__$1;
(statearr_24209_24222[(2)] = null);

(statearr_24209_24222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24207 === (2))){
var inst_24184 = (state_24206[(8)]);
var inst_24191 = (state_24206[(11)]);
var inst_24190 = cljs.core.seq.call(null,inst_24184);
var inst_24191__$1 = cljs.core.first.call(null,inst_24190);
var inst_24192 = cljs.core.next.call(null,inst_24190);
var state_24206__$1 = (function (){var statearr_24210 = state_24206;
(statearr_24210[(12)] = inst_24192);

(statearr_24210[(11)] = inst_24191__$1);

return statearr_24210;
})();
if(cljs.core.truth_(inst_24191__$1)){
var statearr_24211_24223 = state_24206__$1;
(statearr_24211_24223[(1)] = (4));

} else {
var statearr_24212_24224 = state_24206__$1;
(statearr_24212_24224[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24207 === (3))){
var inst_24204 = (state_24206[(2)]);
var state_24206__$1 = state_24206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24206__$1,inst_24204);
} else {
if((state_val_24207 === (4))){
var inst_24191 = (state_24206[(11)]);
var inst_24194 = inst_24191.call(null,tuple);
var state_24206__$1 = state_24206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24206__$1,(7),inst_24194);
} else {
if((state_val_24207 === (5))){
var inst_24185 = (state_24206[(7)]);
var state_24206__$1 = state_24206;
var statearr_24213_24225 = state_24206__$1;
(statearr_24213_24225[(2)] = inst_24185);

(statearr_24213_24225[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24207 === (6))){
var inst_24202 = (state_24206[(2)]);
var state_24206__$1 = state_24206;
var statearr_24214_24226 = state_24206__$1;
(statearr_24214_24226[(2)] = inst_24202);

(statearr_24214_24226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24207 === (7))){
var inst_24185 = (state_24206[(7)]);
var inst_24192 = (state_24206[(12)]);
var inst_24196 = (state_24206[(2)]);
var inst_24197 = fluree.db.util.async.throw_err.call(null,inst_24196);
var inst_24198 = cljs.core.conj.call(null,inst_24185,inst_24197);
var inst_24184 = inst_24192;
var inst_24185__$1 = inst_24198;
var state_24206__$1 = (function (){var statearr_24215 = state_24206;
(statearr_24215[(7)] = inst_24185__$1);

(statearr_24215[(8)] = inst_24184);

return statearr_24215;
})();
var statearr_24216_24227 = state_24206__$1;
(statearr_24216_24227[(2)] = null);

(statearr_24216_24227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____0 = (function (){
var statearr_24217 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24217[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__);

(statearr_24217[(1)] = (1));

return statearr_24217;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____1 = (function (state_24206){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24218){var ex__2457__auto__ = e24218;
var statearr_24219_24228 = state_24206;
(statearr_24219_24228[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24206[(4)]))){
var statearr_24220_24229 = state_24206;
(statearr_24220_24229[(1)] = cljs.core.first.call(null,(state_24206[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24230 = state_24206;
state_24206 = G__24230;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__ = function(state_24206){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____1.call(this,state_24206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2454__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24221 = f__2477__auto__.call(null);
(statearr_24221[(6)] = c__2476__auto__);

return statearr_24221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__24232,headers,vars,opts){
var map__24233 = p__24232;
var map__24233__$1 = (((((!((map__24233 == null))))?(((((map__24233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24233.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24233):map__24233);
var select_spec = map__24233__$1;
var prettyPrint = cljs.core.get.call(null,map__24233__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.call(null,map__24233__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.call(null,map__24233__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24233__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24320){
var state_val_24321 = (state_24320[(1)]);
if((state_val_24321 === (7))){
var state_24320__$1 = state_24320;
var statearr_24322_24462 = state_24320__$1;
(statearr_24322_24462[(2)] = null);

(statearr_24322_24462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (1))){
var state_24320__$1 = state_24320;
var statearr_24323_24463 = state_24320__$1;
(statearr_24323_24463[(2)] = null);

(statearr_24323_24463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (4))){
var inst_24235 = (state_24320[(2)]);
var state_24320__$1 = state_24320;
var statearr_24324_24464 = state_24320__$1;
(statearr_24324_24464[(2)] = inst_24235);

(statearr_24324_24464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (15))){
var inst_24309 = (state_24320[(2)]);
var inst_24310 = fluree.db.util.async.throw_err.call(null,inst_24309);
var state_24320__$1 = state_24320;
var statearr_24325_24465 = state_24320__$1;
(statearr_24325_24465[(2)] = inst_24310);

(statearr_24325_24465[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (13))){
var inst_24245 = (state_24320[(7)]);
var inst_24253 = (state_24320[(8)]);
var inst_24312 = (function (){var pp = inst_24245;
var functionArray = inst_24253;
return (function (tuple){
var tuple_res = cljs.core.map.call(null,(function (p1__24231_SHARP_){
return p1__24231_SHARP_.call(null,tuple);
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap.call(null,pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first.call(null,tuple_res);

}
}
});
})();
var inst_24313 = cljs.core.map.call(null,inst_24312,tuples);
var state_24320__$1 = state_24320;
var statearr_24326_24466 = state_24320__$1;
(statearr_24326_24466[(2)] = inst_24313);

(statearr_24326_24466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (6))){
var inst_24242 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24320__$1 = state_24320;
var statearr_24327_24467 = state_24320__$1;
(statearr_24327_24467[(2)] = inst_24242);

(statearr_24327_24467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (3))){
var inst_24318 = (state_24320[(2)]);
var state_24320__$1 = state_24320;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24320__$1,inst_24318);
} else {
if((state_val_24321 === (12))){
var inst_24245 = (state_24320[(7)]);
var inst_24253 = (state_24320[(8)]);
var inst_24305 = cljs.core.async.chan.call(null,(1));
var inst_24306 = (function (){var pp = inst_24245;
var functionArray = inst_24253;
var c__2476__auto____$1 = inst_24305;
return (function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24303){
var state_val_24304 = (state_24303[(1)]);
if((state_val_24304 === (7))){
var inst_24279 = (state_24303[(2)]);
var inst_24280 = fluree.db.util.async.throw_err.call(null,inst_24279);
var state_24303__$1 = (function (){var statearr_24328 = state_24303;
(statearr_24328[(7)] = inst_24280);

return statearr_24328;
})();
if(cljs.core.truth_(pp)){
var statearr_24329_24468 = state_24303__$1;
(statearr_24329_24468[(1)] = (8));

} else {
var statearr_24330_24469 = state_24303__$1;
(statearr_24330_24469[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (1))){
var inst_24262 = tuples;
var inst_24263 = cljs.core.seq.call(null,inst_24262);
var inst_24264 = cljs.core.first.call(null,inst_24263);
var inst_24265 = cljs.core.next.call(null,inst_24263);
var inst_24266 = cljs.core.PersistentVector.EMPTY;
var inst_24267 = inst_24262;
var inst_24268 = inst_24266;
var state_24303__$1 = (function (){var statearr_24331 = state_24303;
(statearr_24331[(8)] = inst_24264);

(statearr_24331[(9)] = inst_24268);

(statearr_24331[(10)] = inst_24267);

(statearr_24331[(11)] = inst_24265);

return statearr_24331;
})();
var statearr_24332_24470 = state_24303__$1;
(statearr_24332_24470[(2)] = null);

(statearr_24332_24470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (4))){
var inst_24274 = (state_24303[(12)]);
var inst_24277 = fluree.db.query.fql.format_tuple.call(null,functionArray,inst_24274);
var state_24303__$1 = state_24303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24303__$1,(7),inst_24277);
} else {
if((state_val_24304 === (15))){
var state_24303__$1 = state_24303;
var statearr_24333_24471 = state_24303__$1;
(statearr_24333_24471[(2)] = null);

(statearr_24333_24471[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (13))){
var inst_24292 = (state_24303[(2)]);
var state_24303__$1 = state_24303;
var statearr_24334_24472 = state_24303__$1;
(statearr_24334_24472[(2)] = inst_24292);

(statearr_24334_24472[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (6))){
var inst_24299 = (state_24303[(2)]);
var state_24303__$1 = state_24303;
var statearr_24335_24473 = state_24303__$1;
(statearr_24335_24473[(2)] = inst_24299);

(statearr_24335_24473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (3))){
var inst_24301 = (state_24303[(2)]);
var state_24303__$1 = state_24303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24303__$1,inst_24301);
} else {
if((state_val_24304 === (12))){
var state_24303__$1 = state_24303;
var statearr_24336_24474 = state_24303__$1;
(statearr_24336_24474[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (2))){
var inst_24274 = (state_24303[(12)]);
var inst_24267 = (state_24303[(10)]);
var inst_24273 = cljs.core.seq.call(null,inst_24267);
var inst_24274__$1 = cljs.core.first.call(null,inst_24273);
var inst_24275 = cljs.core.next.call(null,inst_24273);
var state_24303__$1 = (function (){var statearr_24338 = state_24303;
(statearr_24338[(13)] = inst_24275);

(statearr_24338[(12)] = inst_24274__$1);

return statearr_24338;
})();
if(cljs.core.truth_(inst_24274__$1)){
var statearr_24339_24475 = state_24303__$1;
(statearr_24339_24475[(1)] = (4));

} else {
var statearr_24340_24476 = state_24303__$1;
(statearr_24340_24476[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (11))){
var inst_24280 = (state_24303[(7)]);
var state_24303__$1 = state_24303;
var statearr_24341_24477 = state_24303__$1;
(statearr_24341_24477[(2)] = inst_24280);

(statearr_24341_24477[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (9))){
var state_24303__$1 = state_24303;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24342_24478 = state_24303__$1;
(statearr_24342_24478[(1)] = (11));

} else {
var statearr_24343_24479 = state_24303__$1;
(statearr_24343_24479[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (5))){
var inst_24268 = (state_24303[(9)]);
var state_24303__$1 = state_24303;
var statearr_24344_24480 = state_24303__$1;
(statearr_24344_24480[(2)] = inst_24268);

(statearr_24344_24480[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (14))){
var inst_24280 = (state_24303[(7)]);
var inst_24287 = cljs.core.first.call(null,inst_24280);
var state_24303__$1 = state_24303;
var statearr_24345_24481 = state_24303__$1;
(statearr_24345_24481[(2)] = inst_24287);

(statearr_24345_24481[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (16))){
var inst_24290 = (state_24303[(2)]);
var state_24303__$1 = state_24303;
var statearr_24346_24482 = state_24303__$1;
(statearr_24346_24482[(2)] = inst_24290);

(statearr_24346_24482[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (10))){
var inst_24275 = (state_24303[(13)]);
var inst_24268 = (state_24303[(9)]);
var inst_24294 = (state_24303[(2)]);
var inst_24295 = cljs.core.conj.call(null,inst_24268,inst_24294);
var inst_24267 = inst_24275;
var inst_24268__$1 = inst_24295;
var state_24303__$1 = (function (){var statearr_24347 = state_24303;
(statearr_24347[(9)] = inst_24268__$1);

(statearr_24347[(10)] = inst_24267);

return statearr_24347;
})();
var statearr_24348_24483 = state_24303__$1;
(statearr_24348_24483[(2)] = null);

(statearr_24348_24483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24304 === (8))){
var inst_24280 = (state_24303[(7)]);
var inst_24282 = cljs.core.zipmap.call(null,pp,inst_24280);
var state_24303__$1 = state_24303;
var statearr_24349_24484 = state_24303__$1;
(statearr_24349_24484[(2)] = inst_24282);

(statearr_24349_24484[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_24350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24350[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__);

(statearr_24350[(1)] = (1));

return statearr_24350;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1 = (function (state_24303){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24351){var ex__2457__auto__ = e24351;
var statearr_24352_24485 = state_24303;
(statearr_24352_24485[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24303[(4)]))){
var statearr_24353_24486 = state_24303;
(statearr_24353_24486[(1)] = cljs.core.first.call(null,(state_24303[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24487 = state_24303;
state_24303 = G__24487;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = function(state_24303){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1.call(this,state_24303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24354 = f__2477__auto__.call(null);
(statearr_24354[(6)] = c__2476__auto____$1);

return statearr_24354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
});
})();
var inst_24307 = cljs.core.async.impl.dispatch.run.call(null,inst_24306);
var state_24320__$1 = (function (){var statearr_24355 = state_24320;
(statearr_24355[(9)] = inst_24307);

return statearr_24355;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24320__$1,(15),inst_24305);
} else {
if((state_val_24321 === (2))){
var _ = (function (){var statearr_24356 = state_24320;
(statearr_24356[(4)] = cljs.core.cons.call(null,(5),(state_24320[(4)])));

return statearr_24356;
})();
var state_24320__$1 = state_24320;
if(cljs.core.truth_(prettyPrint)){
var statearr_24357_24488 = state_24320__$1;
(statearr_24357_24488[(1)] = (6));

} else {
var statearr_24358_24489 = state_24320__$1;
(statearr_24358_24489[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (11))){
var inst_24253 = (state_24320[(2)]);
var state_24320__$1 = (function (){var statearr_24360 = state_24320;
(statearr_24360[(8)] = inst_24253);

return statearr_24360;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24361_24490 = state_24320__$1;
(statearr_24361_24490[(1)] = (12));

} else {
var statearr_24362_24491 = state_24320__$1;
(statearr_24362_24491[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (9))){
var inst_24245 = (state_24320[(7)]);
var inst_24247 = (function (){var pp = inst_24245;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of.call(null,headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?(function (tuple){
return cljs.core.get.call(null,vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2476__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24395){
var state_val_24396 = (state_24395[(1)]);
if((state_val_24396 === (7))){
var state_24395__$1 = state_24395;
var statearr_24397_24492 = state_24395__$1;
(statearr_24397_24492[(2)] = null);

(statearr_24397_24492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (1))){
var state_24395__$1 = state_24395;
var statearr_24398_24493 = state_24395__$1;
(statearr_24398_24493[(2)] = null);

(statearr_24398_24493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (4))){
var inst_24363 = (state_24395[(2)]);
var state_24395__$1 = state_24395;
var statearr_24399_24494 = state_24395__$1;
(statearr_24399_24494[(2)] = inst_24363);

(statearr_24399_24494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (6))){
var inst_24371 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24372 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_24373 = select_fn.call(null,tuple);
var inst_24374 = [inst_24372,inst_24373,opts];
var inst_24375 = cljs.core.PersistentHashMap.fromArrays(inst_24371,inst_24374);
var inst_24376 = fluree.db.query.fql.query.call(null,db,inst_24375);
var state_24395__$1 = state_24395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24395__$1,(9),inst_24376);
} else {
if((state_val_24396 === (3))){
var inst_24393 = (state_24395[(2)]);
var state_24395__$1 = state_24395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24395__$1,inst_24393);
} else {
if((state_val_24396 === (12))){
var inst_24387 = (state_24395[(2)]);
var state_24395__$1 = state_24395;
var statearr_24400_24495 = state_24395__$1;
(statearr_24400_24495[(2)] = inst_24387);

(statearr_24400_24495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (2))){
var _ = (function (){var statearr_24401 = state_24395;
(statearr_24401[(4)] = cljs.core.cons.call(null,(5),(state_24395[(4)])));

return statearr_24401;
})();
var inst_24369 = select_fn.call(null,tuple);
var state_24395__$1 = state_24395;
if(cljs.core.truth_(inst_24369)){
var statearr_24402_24496 = state_24395__$1;
(statearr_24402_24496[(1)] = (6));

} else {
var statearr_24403_24497 = state_24395__$1;
(statearr_24403_24497[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (11))){
var inst_24382 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24383 = select_fn.call(null,tuple);
var inst_24384 = [inst_24383];
var inst_24385 = cljs.core.PersistentHashMap.fromArrays(inst_24382,inst_24384);
var state_24395__$1 = state_24395;
var statearr_24405_24498 = state_24395__$1;
(statearr_24405_24498[(2)] = inst_24385);

(statearr_24405_24498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (9))){
var inst_24379 = (state_24395[(7)]);
var inst_24378 = (state_24395[(2)]);
var inst_24379__$1 = fluree.db.util.async.throw_err.call(null,inst_24378);
var state_24395__$1 = (function (){var statearr_24406 = state_24395;
(statearr_24406[(7)] = inst_24379__$1);

return statearr_24406;
})();
if(cljs.core.truth_(inst_24379__$1)){
var statearr_24407_24499 = state_24395__$1;
(statearr_24407_24499[(1)] = (10));

} else {
var statearr_24408_24500 = state_24395__$1;
(statearr_24408_24500[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (5))){
var _ = (function (){var statearr_24409 = state_24395;
(statearr_24409[(4)] = cljs.core.rest.call(null,(state_24395[(4)])));

return statearr_24409;
})();
var state_24395__$1 = state_24395;
var ex24404 = (state_24395__$1[(2)]);
var statearr_24410_24501 = state_24395__$1;
(statearr_24410_24501[(5)] = ex24404);


if((ex24404 instanceof Error)){
var statearr_24411_24502 = state_24395__$1;
(statearr_24411_24502[(1)] = (4));

(statearr_24411_24502[(5)] = null);

} else {
throw ex24404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (10))){
var inst_24379 = (state_24395[(7)]);
var state_24395__$1 = state_24395;
var statearr_24412_24503 = state_24395__$1;
(statearr_24412_24503[(2)] = inst_24379);

(statearr_24412_24503[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24396 === (8))){
var inst_24390 = (state_24395[(2)]);
var _ = (function (){var statearr_24413 = state_24395;
(statearr_24413[(4)] = cljs.core.rest.call(null,(state_24395[(4)])));

return statearr_24413;
})();
var state_24395__$1 = state_24395;
var statearr_24414_24504 = state_24395__$1;
(statearr_24414_24504[(2)] = inst_24390);

(statearr_24414_24504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_24415 = [null,null,null,null,null,null,null,null];
(statearr_24415[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__);

(statearr_24415[(1)] = (1));

return statearr_24415;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1 = (function (state_24395){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24416){var ex__2457__auto__ = e24416;
var statearr_24417_24505 = state_24395;
(statearr_24417_24505[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24395[(4)]))){
var statearr_24418_24506 = state_24395;
(statearr_24418_24506[(1)] = cljs.core.first.call(null,(state_24395[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24507 = state_24395;
state_24395 = G__24507;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = function(state_24395){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1.call(this,state_24395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24419 = f__2477__auto__.call(null);
(statearr_24419[(6)] = c__2476__auto____$1);

return statearr_24419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto____$1;
});
} else {
return (function (tuple){
var c__2476__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24431){
var state_val_24432 = (state_24431[(1)]);
if((state_val_24432 === (1))){
var state_24431__$1 = state_24431;
var statearr_24433_24508 = state_24431__$1;
(statearr_24433_24508[(2)] = null);

(statearr_24433_24508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24432 === (2))){
var _ = (function (){var statearr_24434 = state_24431;
(statearr_24434[(4)] = cljs.core.cons.call(null,(5),(state_24431[(4)])));

return statearr_24434;
})();
var inst_24426 = select_fn.call(null,tuple);
var ___$1 = (function (){var statearr_24435 = state_24431;
(statearr_24435[(4)] = cljs.core.rest.call(null,(state_24431[(4)])));

return statearr_24435;
})();
var state_24431__$1 = state_24431;
var statearr_24436_24509 = state_24431__$1;
(statearr_24436_24509[(2)] = inst_24426);

(statearr_24436_24509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24432 === (3))){
var inst_24429 = (state_24431[(2)]);
var state_24431__$1 = state_24431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24431__$1,inst_24429);
} else {
if((state_val_24432 === (4))){
var inst_24420 = (state_24431[(2)]);
var state_24431__$1 = state_24431;
var statearr_24438_24510 = state_24431__$1;
(statearr_24438_24510[(2)] = inst_24420);

(statearr_24438_24510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24432 === (5))){
var _ = (function (){var statearr_24439 = state_24431;
(statearr_24439[(4)] = cljs.core.rest.call(null,(state_24431[(4)])));

return statearr_24439;
})();
var state_24431__$1 = state_24431;
var ex24437 = (state_24431__$1[(2)]);
var statearr_24440_24511 = state_24431__$1;
(statearr_24440_24511[(5)] = ex24437);


if((ex24437 instanceof Error)){
var statearr_24441_24512 = state_24431__$1;
(statearr_24441_24512[(1)] = (4));

(statearr_24441_24512[(5)] = null);

} else {
throw ex24437;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_24442 = [null,null,null,null,null,null,null];
(statearr_24442[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__);

(statearr_24442[(1)] = (1));

return statearr_24442;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1 = (function (state_24431){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24443){var ex__2457__auto__ = e24443;
var statearr_24444_24513 = state_24431;
(statearr_24444_24513[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24431[(4)]))){
var statearr_24445_24514 = state_24431;
(statearr_24445_24514[(1)] = cljs.core.first.call(null,(state_24431[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24515 = state_24431;
state_24431 = G__24515;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = function(state_24431){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1.call(this,state_24431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24446 = f__2477__auto__.call(null);
(statearr_24446[(6)] = c__2476__auto____$1);

return statearr_24446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto____$1;
});
}
});
})();
var inst_24248 = cljs.core.map.call(null,inst_24247,select);
var state_24320__$1 = state_24320;
var statearr_24447_24516 = state_24320__$1;
(statearr_24447_24516[(2)] = inst_24248);

(statearr_24447_24516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (5))){
var _ = (function (){var statearr_24448 = state_24320;
(statearr_24448[(4)] = cljs.core.rest.call(null,(state_24320[(4)])));

return statearr_24448;
})();
var state_24320__$1 = state_24320;
var ex24359 = (state_24320__$1[(2)]);
var statearr_24449_24517 = state_24320__$1;
(statearr_24449_24517[(5)] = ex24359);


if((ex24359 instanceof Error)){
var statearr_24450_24518 = state_24320__$1;
(statearr_24450_24518[(1)] = (4));

(statearr_24450_24518[(5)] = null);

} else {
throw ex24359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (14))){
var inst_24315 = (state_24320[(2)]);
var _ = (function (){var statearr_24451 = state_24320;
(statearr_24451[(4)] = cljs.core.rest.call(null,(state_24320[(4)])));

return statearr_24451;
})();
var state_24320__$1 = state_24320;
var statearr_24452_24519 = state_24320__$1;
(statearr_24452_24519[(2)] = inst_24315);

(statearr_24452_24519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (10))){
var inst_24245 = (state_24320[(7)]);
var inst_24250 = (function (){var pp = inst_24245;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select__$1);
return (function (tuple){
return cljs.core.nth.call(null,tuple,idx);
});
}
});
})();
var inst_24251 = cljs.core.map.call(null,inst_24250,select);
var state_24320__$1 = state_24320;
var statearr_24453_24520 = state_24320__$1;
(statearr_24453_24520[(2)] = inst_24251);

(statearr_24453_24520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24321 === (8))){
var inst_24245 = (state_24320[(2)]);
var state_24320__$1 = (function (){var statearr_24454 = state_24320;
(statearr_24454[(7)] = inst_24245);

return statearr_24454;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24455_24521 = state_24320__$1;
(statearr_24455_24521[(1)] = (9));

} else {
var statearr_24456_24522 = state_24320__$1;
(statearr_24456_24522[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0 = (function (){
var statearr_24457 = [null,null,null,null,null,null,null,null,null,null];
(statearr_24457[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__);

(statearr_24457[(1)] = (1));

return statearr_24457;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1 = (function (state_24320){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24320);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24458){var ex__2457__auto__ = e24458;
var statearr_24459_24523 = state_24320;
(statearr_24459_24523[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24320[(4)]))){
var statearr_24460_24524 = state_24320;
(statearr_24460_24524[(1)] = cljs.core.first.call(null,(state_24320[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24525 = state_24320;
state_24320 = G__24525;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__ = function(state_24320){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1.call(this,state_24320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24461 = f__2477__auto__.call(null);
(statearr_24461[(6)] = c__2476__auto__);

return statearr_24461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24527 = arguments.length;
switch (G__24527) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24528,p__24529,group_limit,opts){
var map__24530 = p__24528;
var map__24530__$1 = (((((!((map__24530 == null))))?(((((map__24530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24530):map__24530);
var res = map__24530__$1;
var vars = cljs.core.get.call(null,map__24530__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24531 = p__24529;
var map__24531__$1 = (((((!((map__24531 == null))))?(((((map__24531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24531):map__24531);
var select_spec = map__24531__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24531__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_24643){
var state_val_24644 = (state_24643[(1)]);
if((state_val_24644 === (7))){
var inst_24540 = (state_24643[(7)]);
var state_24643__$1 = state_24643;
var statearr_24645_24725 = state_24643__$1;
(statearr_24645_24725[(2)] = inst_24540);

(statearr_24645_24725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (20))){
var inst_24575 = (state_24643[(2)]);
var state_24643__$1 = (function (){var statearr_24646 = state_24643;
(statearr_24646[(8)] = inst_24575);

return statearr_24646;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24647_24726 = state_24643__$1;
(statearr_24647_24726[(1)] = (21));

} else {
var statearr_24648_24727 = state_24643__$1;
(statearr_24648_24727[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (27))){
var inst_24584 = (state_24643[(9)]);
var inst_24589 = inst_24584.cljs$lang$protocol_mask$partition0$;
var inst_24590 = (inst_24589 & (64));
var inst_24591 = inst_24584.cljs$core$ISeq$;
var inst_24592 = (cljs.core.PROTOCOL_SENTINEL === inst_24591);
var inst_24593 = ((inst_24590) || (inst_24592));
var state_24643__$1 = state_24643;
if(cljs.core.truth_(inst_24593)){
var statearr_24649_24728 = state_24643__$1;
(statearr_24649_24728[(1)] = (30));

} else {
var statearr_24650_24729 = state_24643__$1;
(statearr_24650_24729[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (1))){
var state_24643__$1 = state_24643;
var statearr_24651_24730 = state_24643__$1;
(statearr_24651_24730[(2)] = null);

(statearr_24651_24730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (24))){
var inst_24575 = (state_24643[(8)]);
var inst_24579 = (state_24643[(10)]);
var inst_24581 = fluree.db.query.fql.order_offset_and_limit_results.call(null,orderBy,inst_24575,inst_24579,group_limit);
var state_24643__$1 = state_24643;
var statearr_24652_24731 = state_24643__$1;
(statearr_24652_24731[(2)] = inst_24581);

(statearr_24652_24731[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (39))){
var inst_24610 = (state_24643[(11)]);
var state_24643__$1 = state_24643;
var statearr_24653_24732 = state_24643__$1;
(statearr_24653_24732[(2)] = inst_24610);

(statearr_24653_24732[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (46))){
var inst_24628 = (state_24643[(12)]);
var inst_24630 = cljs.core.PersistentVector.EMPTY;
var inst_24631 = cljs.core.PersistentHashSet.EMPTY;
var inst_24632 = cljs.core.into.call(null,inst_24631,inst_24628);
var inst_24633 = cljs.core.into.call(null,inst_24630,inst_24632);
var state_24643__$1 = state_24643;
var statearr_24654_24733 = state_24643__$1;
(statearr_24654_24733[(2)] = inst_24633);

(statearr_24654_24733[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (4))){
var inst_24534 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
var statearr_24655_24734 = state_24643__$1;
(statearr_24655_24734[(2)] = inst_24534);

(statearr_24655_24734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (15))){
var inst_24561 = (state_24643[(13)]);
var inst_24563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24564 = [inst_24561];
var inst_24565 = (new cljs.core.PersistentVector(null,1,(5),inst_24563,inst_24564,null));
var state_24643__$1 = state_24643;
var statearr_24656_24735 = state_24643__$1;
(statearr_24656_24735[(2)] = inst_24565);

(statearr_24656_24735[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (48))){
var inst_24636 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
var statearr_24657_24736 = state_24643__$1;
(statearr_24657_24736[(2)] = inst_24636);

(statearr_24657_24736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (21))){
var state_24643__$1 = state_24643;
var statearr_24658_24737 = state_24643__$1;
(statearr_24658_24737[(2)] = (0));

(statearr_24658_24737[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (31))){
var state_24643__$1 = state_24643;
var statearr_24659_24738 = state_24643__$1;
(statearr_24659_24738[(2)] = false);

(statearr_24659_24738[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (32))){
var inst_24597 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
var statearr_24660_24739 = state_24643__$1;
(statearr_24660_24739[(2)] = inst_24597);

(statearr_24660_24739[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (40))){
var inst_24579 = (state_24643[(10)]);
var state_24643__$1 = state_24643;
var statearr_24661_24740 = state_24643__$1;
(statearr_24661_24740[(2)] = inst_24579);

(statearr_24661_24740[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (33))){
var inst_24584 = (state_24643[(9)]);
var inst_24602 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24584);
var state_24643__$1 = state_24643;
var statearr_24662_24741 = state_24643__$1;
(statearr_24662_24741[(2)] = inst_24602);

(statearr_24662_24741[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (13))){
var inst_24550 = (state_24643[(14)]);
var state_24643__$1 = state_24643;
var statearr_24663_24742 = state_24643__$1;
(statearr_24663_24742[(2)] = inst_24550);

(statearr_24663_24742[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (22))){
var state_24643__$1 = state_24643;
var statearr_24664_24743 = state_24643__$1;
(statearr_24664_24743[(2)] = offset);

(statearr_24664_24743[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (36))){
var inst_24610 = (state_24643[(11)]);
var inst_24610__$1 = limit;
var state_24643__$1 = (function (){var statearr_24665 = state_24643;
(statearr_24665[(11)] = inst_24610__$1);

return statearr_24665;
})();
if(cljs.core.truth_(inst_24610__$1)){
var statearr_24666_24744 = state_24643__$1;
(statearr_24666_24744[(1)] = (39));

} else {
var statearr_24667_24745 = state_24643__$1;
(statearr_24667_24745[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (41))){
var inst_24614 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
var statearr_24668_24746 = state_24643__$1;
(statearr_24668_24746[(2)] = inst_24614);

(statearr_24668_24746[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (43))){
var inst_24607 = (state_24643[(15)]);
var state_24643__$1 = state_24643;
var statearr_24669_24747 = state_24643__$1;
(statearr_24669_24747[(2)] = inst_24607);

(statearr_24669_24747[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (29))){
var inst_24600 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
if(cljs.core.truth_(inst_24600)){
var statearr_24670_24748 = state_24643__$1;
(statearr_24670_24748[(1)] = (33));

} else {
var statearr_24671_24749 = state_24643__$1;
(statearr_24671_24749[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (44))){
var inst_24606 = (state_24643[(16)]);
var inst_24623 = (state_24643[(2)]);
var inst_24624 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24625 = fluree.db.query.fql.format_filter_tuples.call(null,db,inst_24623,select_spec,inst_24606,vars,inst_24624);
var state_24643__$1 = state_24643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24643__$1,(45),inst_24625);
} else {
if((state_val_24644 === (6))){
var inst_24542 = cljs.core.count.call(null,select);
var inst_24543 = cljs.core._EQ_.call(null,(1),inst_24542);
var state_24643__$1 = state_24643;
var statearr_24672_24750 = state_24643__$1;
(statearr_24672_24750[(2)] = inst_24543);

(statearr_24672_24750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (28))){
var state_24643__$1 = state_24643;
var statearr_24673_24751 = state_24643__$1;
(statearr_24673_24751[(2)] = false);

(statearr_24673_24751[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (25))){
var inst_24575 = (state_24643[(8)]);
var state_24643__$1 = state_24643;
var statearr_24674_24752 = state_24643__$1;
(statearr_24674_24752[(2)] = inst_24575);

(statearr_24674_24752[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (34))){
var inst_24584 = (state_24643[(9)]);
var state_24643__$1 = state_24643;
var statearr_24675_24753 = state_24643__$1;
(statearr_24675_24753[(2)] = inst_24584);

(statearr_24675_24753[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (17))){
var inst_24568 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
var statearr_24676_24754 = state_24643__$1;
(statearr_24676_24754[(2)] = inst_24568);

(statearr_24676_24754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (3))){
var inst_24641 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24643__$1,inst_24641);
} else {
if((state_val_24644 === (12))){
var inst_24550 = (state_24643[(14)]);
var inst_24552 = cljs.core.first.call(null,select);
var inst_24553 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24552);
var inst_24554 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24553);
var inst_24555 = cljs.core.subs.call(null,inst_24554,(1));
var inst_24556 = [inst_24555];
var inst_24557 = [inst_24550];
var inst_24558 = cljs.core.PersistentHashMap.fromArrays(inst_24556,inst_24557);
var state_24643__$1 = state_24643;
var statearr_24677_24755 = state_24643__$1;
(statearr_24677_24755[(2)] = inst_24558);

(statearr_24677_24755[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (2))){
var inst_24540 = (state_24643[(7)]);
var _ = (function (){var statearr_24678 = state_24643;
(statearr_24678[(4)] = cljs.core.cons.call(null,(5),(state_24643[(4)])));

return statearr_24678;
})();
var inst_24540__$1 = aggregates;
var state_24643__$1 = (function (){var statearr_24679 = state_24643;
(statearr_24679[(7)] = inst_24540__$1);

return statearr_24679;
})();
if(cljs.core.truth_(inst_24540__$1)){
var statearr_24680_24756 = state_24643__$1;
(statearr_24680_24756[(1)] = (6));

} else {
var statearr_24681_24757 = state_24643__$1;
(statearr_24681_24757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (23))){
var inst_24579 = (state_24643[(2)]);
var state_24643__$1 = (function (){var statearr_24682 = state_24643;
(statearr_24682[(10)] = inst_24579);

return statearr_24682;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24683_24758 = state_24643__$1;
(statearr_24683_24758[(1)] = (24));

} else {
var statearr_24684_24759 = state_24643__$1;
(statearr_24684_24759[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (47))){
var inst_24628 = (state_24643[(12)]);
var state_24643__$1 = state_24643;
var statearr_24685_24760 = state_24643__$1;
(statearr_24685_24760[(2)] = inst_24628);

(statearr_24685_24760[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (35))){
var inst_24605 = (state_24643[(2)]);
var inst_24606 = cljs.core.get.call(null,inst_24605,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24607 = cljs.core.get.call(null,inst_24605,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24608 = cljs.core.not.call(null,orderBy);
var state_24643__$1 = (function (){var statearr_24686 = state_24643;
(statearr_24686[(15)] = inst_24607);

(statearr_24686[(16)] = inst_24606);

return statearr_24686;
})();
if(inst_24608){
var statearr_24687_24761 = state_24643__$1;
(statearr_24687_24761[(1)] = (36));

} else {
var statearr_24688_24762 = state_24643__$1;
(statearr_24688_24762[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (19))){
var state_24643__$1 = state_24643;
var statearr_24689_24763 = state_24643__$1;
(statearr_24689_24763[(2)] = res);

(statearr_24689_24763[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (11))){
var inst_24638 = (state_24643[(2)]);
var _ = (function (){var statearr_24691 = state_24643;
(statearr_24691[(4)] = cljs.core.rest.call(null,(state_24643[(4)])));

return statearr_24691;
})();
var state_24643__$1 = state_24643;
var statearr_24692_24764 = state_24643__$1;
(statearr_24692_24764[(2)] = inst_24638);

(statearr_24692_24764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (9))){
var inst_24548 = cljs.core.first.call(null,aggregates);
var inst_24549 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24548);
var inst_24550 = cljs.core.second.call(null,inst_24549);
var state_24643__$1 = (function (){var statearr_24693 = state_24643;
(statearr_24693[(14)] = inst_24550);

return statearr_24693;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24694_24765 = state_24643__$1;
(statearr_24694_24765[(1)] = (12));

} else {
var statearr_24695_24766 = state_24643__$1;
(statearr_24695_24766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (5))){
var _ = (function (){var statearr_24696 = state_24643;
(statearr_24696[(4)] = cljs.core.rest.call(null,(state_24643[(4)])));

return statearr_24696;
})();
var state_24643__$1 = state_24643;
var ex24690 = (state_24643__$1[(2)]);
var statearr_24697_24767 = state_24643__$1;
(statearr_24697_24767[(5)] = ex24690);


if((ex24690 instanceof Error)){
var statearr_24698_24768 = state_24643__$1;
(statearr_24698_24768[(1)] = (4));

(statearr_24698_24768[(5)] = null);

} else {
throw ex24690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (14))){
var inst_24561 = (state_24643[(2)]);
var state_24643__$1 = (function (){var statearr_24699 = state_24643;
(statearr_24699[(13)] = inst_24561);

return statearr_24699;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24700_24769 = state_24643__$1;
(statearr_24700_24769[(1)] = (15));

} else {
var statearr_24701_24770 = state_24643__$1;
(statearr_24701_24770[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (45))){
var inst_24627 = (state_24643[(2)]);
var inst_24628 = fluree.db.util.async.throw_err.call(null,inst_24627);
var state_24643__$1 = (function (){var statearr_24702 = state_24643;
(statearr_24702[(12)] = inst_24628);

return statearr_24702;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24703_24771 = state_24643__$1;
(statearr_24703_24771[(1)] = (46));

} else {
var statearr_24704_24772 = state_24643__$1;
(statearr_24704_24772[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (26))){
var inst_24584 = (state_24643[(9)]);
var inst_24584__$1 = (state_24643[(2)]);
var inst_24586 = (inst_24584__$1 == null);
var inst_24587 = cljs.core.not.call(null,inst_24586);
var state_24643__$1 = (function (){var statearr_24705 = state_24643;
(statearr_24705[(9)] = inst_24584__$1);

return statearr_24705;
})();
if(inst_24587){
var statearr_24706_24773 = state_24643__$1;
(statearr_24706_24773[(1)] = (27));

} else {
var statearr_24707_24774 = state_24643__$1;
(statearr_24707_24774[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (16))){
var inst_24561 = (state_24643[(13)]);
var state_24643__$1 = state_24643;
var statearr_24708_24775 = state_24643__$1;
(statearr_24708_24775[(2)] = inst_24561);

(statearr_24708_24775[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (38))){
var inst_24617 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
if(cljs.core.truth_(inst_24617)){
var statearr_24709_24776 = state_24643__$1;
(statearr_24709_24776[(1)] = (42));

} else {
var statearr_24710_24777 = state_24643__$1;
(statearr_24710_24777[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (30))){
var state_24643__$1 = state_24643;
var statearr_24711_24778 = state_24643__$1;
(statearr_24711_24778[(2)] = true);

(statearr_24711_24778[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (10))){
var state_24643__$1 = state_24643;
if(cljs.core.truth_(aggregates)){
var statearr_24712_24779 = state_24643__$1;
(statearr_24712_24779[(1)] = (18));

} else {
var statearr_24713_24780 = state_24643__$1;
(statearr_24713_24780[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (18))){
var inst_24572 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24643__$1 = state_24643;
var statearr_24714_24781 = state_24643__$1;
(statearr_24714_24781[(2)] = inst_24572);

(statearr_24714_24781[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (42))){
var inst_24579 = (state_24643[(10)]);
var inst_24607 = (state_24643[(15)]);
var inst_24619 = cljs.core.drop.call(null,inst_24579,inst_24607);
var inst_24620 = cljs.core.take.call(null,limit,inst_24619);
var state_24643__$1 = state_24643;
var statearr_24715_24782 = state_24643__$1;
(statearr_24715_24782[(2)] = inst_24620);

(statearr_24715_24782[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (37))){
var state_24643__$1 = state_24643;
var statearr_24716_24783 = state_24643__$1;
(statearr_24716_24783[(2)] = false);

(statearr_24716_24783[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24644 === (8))){
var inst_24546 = (state_24643[(2)]);
var state_24643__$1 = state_24643;
if(cljs.core.truth_(inst_24546)){
var statearr_24717_24784 = state_24643__$1;
(statearr_24717_24784[(1)] = (9));

} else {
var statearr_24718_24785 = state_24643__$1;
(statearr_24718_24785[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2454__auto__ = null;
var fluree$db$query$fql$state_machine__2454__auto____0 = (function (){
var statearr_24719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24719[(0)] = fluree$db$query$fql$state_machine__2454__auto__);

(statearr_24719[(1)] = (1));

return statearr_24719;
});
var fluree$db$query$fql$state_machine__2454__auto____1 = (function (state_24643){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_24643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e24720){var ex__2457__auto__ = e24720;
var statearr_24721_24786 = state_24643;
(statearr_24721_24786[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_24643[(4)]))){
var statearr_24722_24787 = state_24643;
(statearr_24722_24787[(1)] = cljs.core.first.call(null,(state_24643[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24788 = state_24643;
state_24643 = G__24788;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2454__auto__ = function(state_24643){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2454__auto____1.call(this,state_24643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2454__auto____0;
fluree$db$query$fql$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2454__auto____1;
return fluree$db$query$fql$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_24723 = f__2477__auto__.call(null);
(statearr_24723[(6)] = c__2476__auto__);

return statearr_24723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24791,groupBy){
var map__24792 = p__24791;
var map__24792__$1 = (((((!((map__24792 == null))))?(((((map__24792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24792):map__24792);
var res = map__24792__$1;
var headers = cljs.core.get.call(null,map__24792__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24792__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24794 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__24794,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__24794,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__24789_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__24789_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__24790_SHARP_){
return cljs.core.nth.call(null,tuple,p1__24790_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__24797,p__24798,opts){
var map__24799 = p__24797;
var map__24799__$1 = (((((!((map__24799 == null))))?(((((map__24799.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24799.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24799):map__24799);
var res = map__24799__$1;
var headers = cljs.core.get.call(null,map__24799__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__24799__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24800 = p__24798;
var map__24800__$1 = (((((!((map__24800 == null))))?(((((map__24800.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24800.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24800):map__24800);
var select_spec = map__24800__$1;
var groupBy = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__24800__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_25025){
var state_val_25026 = (state_25025[(1)]);
if((state_val_25026 === (65))){
var inst_24987 = (state_25025[(2)]);
var inst_24988 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,inst_24987,opts);
var state_25025__$1 = state_25025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25025__$1,(66),inst_24988);
} else {
if((state_val_25026 === (70))){
var inst_24991 = (state_25025[(7)]);
var inst_24996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24997 = [inst_24991];
var inst_24998 = (new cljs.core.PersistentVector(null,1,(5),inst_24996,inst_24997,null));
var state_25025__$1 = state_25025;
var statearr_25027_25150 = state_25025__$1;
(statearr_25027_25150[(2)] = inst_24998);

(statearr_25027_25150[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (62))){
var inst_24980 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25028_25151 = state_25025__$1;
(statearr_25028_25151[(2)] = inst_24980);

(statearr_25028_25151[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (74))){
var state_25025__$1 = state_25025;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25029_25152 = state_25025__$1;
(statearr_25029_25152[(1)] = (76));

} else {
var statearr_25030_25153 = state_25025__$1;
(statearr_25030_25153[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (7))){
var state_25025__$1 = state_25025;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25031_25154 = state_25025__$1;
(statearr_25031_25154[(1)] = (63));

} else {
var statearr_25032_25155 = state_25025__$1;
(statearr_25032_25155[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (59))){
var inst_24913 = (state_25025[(8)]);
var inst_24904 = (state_25025[(9)]);
var inst_24956 = (state_25025[(2)]);
var inst_24957 = fluree.db.util.async.throw_err.call(null,inst_24956);
var inst_24958 = cljs.core.assoc.call(null,inst_24904,inst_24913,inst_24957);
var state_25025__$1 = state_25025;
var statearr_25033_25156 = state_25025__$1;
(statearr_25033_25156[(2)] = inst_24958);

(statearr_25033_25156[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (20))){
var inst_24857 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25034_25157 = state_25025__$1;
(statearr_25034_25157[(2)] = inst_24857);

(statearr_25034_25157[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (72))){
var inst_25001 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25035_25158 = state_25025__$1;
(statearr_25035_25158[(2)] = inst_25001);

(statearr_25035_25158[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (58))){
var inst_24961 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25036_25159 = state_25025__$1;
(statearr_25036_25159[(2)] = inst_24961);

(statearr_25036_25159[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (60))){
var inst_24859 = (state_25025[(10)]);
var inst_24974 = (state_25025[(11)]);
var inst_24976 = cljs.core.sorted_map_by.call(null,inst_24859);
var inst_24977 = cljs.core.into.call(null,inst_24976,inst_24974);
var state_25025__$1 = state_25025;
var statearr_25037_25160 = state_25025__$1;
(statearr_25037_25160[(2)] = inst_24977);

(statearr_25037_25160[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (27))){
var inst_24810 = (state_25025[(12)]);
var inst_24840 = (state_25025[(13)]);
var inst_24841 = (state_25025[(14)]);
var inst_24844 = (function (){var group_map = inst_24810;
var orderByIdx = inst_24840;
var orderDirection = inst_24841;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
})();
var state_25025__$1 = state_25025;
var statearr_25038_25161 = state_25025__$1;
(statearr_25038_25161[(2)] = inst_24844);

(statearr_25038_25161[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (1))){
var state_25025__$1 = state_25025;
var statearr_25039_25162 = state_25025__$1;
(statearr_25039_25162[(2)] = null);

(statearr_25039_25162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (69))){
var inst_25018 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25040_25163 = state_25025__$1;
(statearr_25040_25163[(2)] = inst_25018);

(statearr_25040_25163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (24))){
var inst_24841 = (state_25025[(14)]);
var inst_24839 = cljs.core.second.call(null,orderBy);
var inst_24840 = fluree.db.util.core.index_of.call(null,groupBy,inst_24839);
var inst_24841__$1 = cljs.core.first.call(null,orderBy);
var inst_24842 = cljs.core._EQ_.call(null,"DESC",inst_24841__$1);
var state_25025__$1 = (function (){var statearr_25041 = state_25025;
(statearr_25041[(13)] = inst_24840);

(statearr_25041[(14)] = inst_24841__$1);

return statearr_25041;
})();
if(inst_24842){
var statearr_25042_25164 = state_25025__$1;
(statearr_25042_25164[(1)] = (27));

} else {
var statearr_25043_25165 = state_25025__$1;
(statearr_25043_25165[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (55))){
var inst_24913 = (state_25025[(8)]);
var inst_24904 = (state_25025[(9)]);
var inst_24945 = (state_25025[(2)]);
var inst_24946 = fluree.db.util.async.throw_err.call(null,inst_24945);
var inst_24947 = cljs.core.assoc.call(null,inst_24904,inst_24913,inst_24946);
var state_25025__$1 = state_25025;
var statearr_25044_25166 = state_25025__$1;
(statearr_25044_25166[(2)] = inst_24947);

(statearr_25044_25166[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (39))){
var inst_24904 = (state_25025[(9)]);
var state_25025__$1 = state_25025;
var statearr_25045_25167 = state_25025__$1;
(statearr_25045_25167[(2)] = inst_24904);

(statearr_25045_25167[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (46))){
var state_25025__$1 = state_25025;
var statearr_25046_25168 = state_25025__$1;
(statearr_25046_25168[(2)] = null);

(statearr_25046_25168[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (4))){
var inst_24803 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25047_25169 = state_25025__$1;
(statearr_25047_25169[(2)] = inst_24803);

(statearr_25047_25169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (77))){
var state_25025__$1 = state_25025;
var statearr_25048_25170 = state_25025__$1;
(statearr_25048_25170[(1)] = (79));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (54))){
var inst_24963 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25050_25171 = state_25025__$1;
(statearr_25050_25171[(2)] = inst_24963);

(statearr_25050_25171[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (15))){
var inst_24810 = (state_25025[(12)]);
var inst_24822 = (function (){var group_map = inst_24810;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
})();
var state_25025__$1 = state_25025;
var statearr_25051_25172 = state_25025__$1;
(statearr_25051_25172[(2)] = inst_24822);

(statearr_25051_25172[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (48))){
var inst_24931 = (state_25025[(15)]);
var inst_24934 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24931,select_spec,opts);
var state_25025__$1 = state_25025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25025__$1,(51),inst_24934);
} else {
if((state_val_25026 === (50))){
var inst_24965 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25052_25173 = state_25025__$1;
(statearr_25052_25173[(2)] = inst_24965);

(statearr_25052_25173[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (75))){
var inst_25016 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25053_25174 = state_25025__$1;
(statearr_25053_25174[(2)] = inst_25016);

(statearr_25053_25174[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (21))){
var inst_24832 = cljs.core.set.call(null,groupBy);
var inst_24833 = cljs.core.second.call(null,orderBy);
var inst_24834 = inst_24832.call(null,inst_24833);
var state_25025__$1 = state_25025;
var statearr_25054_25175 = state_25025__$1;
(statearr_25054_25175[(2)] = inst_24834);

(statearr_25054_25175[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (31))){
var state_25025__$1 = state_25025;
var statearr_25055_25176 = state_25025__$1;
(statearr_25055_25176[(2)] = null);

(statearr_25055_25176[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (32))){
var inst_24853 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25056_25177 = state_25025__$1;
(statearr_25056_25177[(2)] = inst_24853);

(statearr_25056_25177[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (40))){
var inst_24903 = (state_25025[(16)]);
var inst_24921 = (inst_24903 > (0));
var state_25025__$1 = state_25025;
if(cljs.core.truth_(inst_24921)){
var statearr_25057_25178 = state_25025__$1;
(statearr_25057_25178[(1)] = (42));

} else {
var statearr_25058_25179 = state_25025__$1;
(statearr_25058_25179[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (56))){
var inst_24928 = (state_25025[(17)]);
var inst_24916 = (state_25025[(18)]);
var inst_24931 = (state_25025[(15)]);
var inst_24951 = cljs.core.count.call(null,inst_24916);
var inst_24952 = (inst_24928 - limit);
var inst_24953 = (inst_24951 - inst_24952);
var inst_24954 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24931,select_spec,inst_24953,opts);
var state_25025__$1 = state_25025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25025__$1,(59),inst_24954);
} else {
if((state_val_25026 === (33))){
var inst_24810 = (state_25025[(12)]);
var inst_24861 = cljs.core.keys.call(null,inst_24810);
var inst_24862 = cljs.core.first.call(null,inst_24861);
var inst_24863 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24864 = cljs.core.vals.call(null,inst_24810);
var inst_24865 = cljs.core.first.call(null,inst_24864);
var inst_24866 = [headers,vars,inst_24865];
var inst_24867 = cljs.core.PersistentHashMap.fromArrays(inst_24863,inst_24866);
var inst_24868 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24867,select_spec,limit,opts);
var state_25025__$1 = (function (){var statearr_25059 = state_25025;
(statearr_25059[(19)] = inst_24862);

return statearr_25059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25025__$1,(36),inst_24868);
} else {
if((state_val_25026 === (13))){
var inst_24827 = cljs.core.not.call(null,orderBy);
var state_25025__$1 = state_25025;
if(inst_24827){
var statearr_25060_25180 = state_25025__$1;
(statearr_25060_25180[(1)] = (18));

} else {
var statearr_25061_25181 = state_25025__$1;
(statearr_25061_25181[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (22))){
var inst_24830 = (state_25025[(20)]);
var state_25025__$1 = state_25025;
var statearr_25062_25182 = state_25025__$1;
(statearr_25062_25182[(2)] = inst_24830);

(statearr_25062_25182[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (36))){
var inst_24862 = (state_25025[(19)]);
var inst_24870 = (state_25025[(2)]);
var inst_24871 = fluree.db.util.async.throw_err.call(null,inst_24870);
var inst_24872 = [inst_24862];
var inst_24873 = [inst_24871];
var inst_24874 = cljs.core.PersistentHashMap.fromArrays(inst_24872,inst_24873);
var state_25025__$1 = state_25025;
var statearr_25063_25183 = state_25025__$1;
(statearr_25063_25183[(2)] = inst_24874);

(statearr_25063_25183[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (41))){
var inst_24972 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25064_25184 = state_25025__$1;
(statearr_25064_25184[(2)] = inst_24972);

(statearr_25064_25184[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (43))){
var state_25025__$1 = state_25025;
var statearr_25065_25185 = state_25025__$1;
(statearr_25065_25185[(1)] = (45));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (61))){
var inst_24974 = (state_25025[(11)]);
var state_25025__$1 = state_25025;
var statearr_25067_25186 = state_25025__$1;
(statearr_25067_25186[(2)] = inst_24974);

(statearr_25067_25186[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (29))){
var inst_24848 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25068_25187 = state_25025__$1;
(statearr_25068_25187[(2)] = inst_24848);

(statearr_25068_25187[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (44))){
var inst_24970 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25069_25188 = state_25025__$1;
(statearr_25069_25188[(2)] = inst_24970);

(statearr_25069_25188[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (6))){
var inst_24811 = (state_25025[(21)]);
var inst_24810 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var inst_24811__$1 = orderBy;
var state_25025__$1 = (function (){var statearr_25070 = state_25025;
(statearr_25070[(12)] = inst_24810);

(statearr_25070[(21)] = inst_24811__$1);

return statearr_25070;
})();
if(cljs.core.truth_(inst_24811__$1)){
var statearr_25071_25189 = state_25025__$1;
(statearr_25071_25189[(1)] = (9));

} else {
var statearr_25072_25190 = state_25025__$1;
(statearr_25072_25190[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (28))){
var inst_24810 = (state_25025[(12)]);
var inst_24840 = (state_25025[(13)]);
var inst_24841 = (state_25025[(14)]);
var inst_24846 = (function (){var group_map = inst_24810;
var orderByIdx = inst_24840;
var orderDirection = inst_24841;
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
})();
var state_25025__$1 = state_25025;
var statearr_25074_25191 = state_25025__$1;
(statearr_25074_25191[(2)] = inst_24846);

(statearr_25074_25191[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (64))){
var state_25025__$1 = state_25025;
var statearr_25075_25192 = state_25025__$1;
(statearr_25075_25192[(2)] = limit);

(statearr_25075_25192[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (51))){
var inst_24903 = (state_25025[(16)]);
var inst_24928 = (state_25025[(17)]);
var inst_24914 = (state_25025[(22)]);
var inst_24913 = (state_25025[(8)]);
var inst_24917 = (state_25025[(23)]);
var inst_24904 = (state_25025[(9)]);
var inst_24936 = (state_25025[(2)]);
var inst_24937 = fluree.db.util.async.throw_err.call(null,inst_24936);
var inst_24938 = cljs.core.assoc.call(null,inst_24904,inst_24913,inst_24937);
var tmp25073 = inst_24903;
var inst_24900 = inst_24914;
var inst_24901 = inst_24917;
var inst_24902 = inst_24928;
var inst_24903__$1 = tmp25073;
var inst_24904__$1 = inst_24938;
var state_25025__$1 = (function (){var statearr_25076 = state_25025;
(statearr_25076[(16)] = inst_24903__$1);

(statearr_25076[(24)] = inst_24901);

(statearr_25076[(25)] = inst_24900);

(statearr_25076[(26)] = inst_24902);

(statearr_25076[(9)] = inst_24904__$1);

return statearr_25076;
})();
var statearr_25077_25193 = state_25025__$1;
(statearr_25077_25193[(2)] = null);

(statearr_25077_25193[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (25))){
var state_25025__$1 = state_25025;
var statearr_25078_25194 = state_25025__$1;
(statearr_25078_25194[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (34))){
var inst_24810 = (state_25025[(12)]);
var inst_24890 = cljs.core.keys.call(null,inst_24810);
var inst_24891 = cljs.core.seq.call(null,inst_24890);
var inst_24892 = cljs.core.first.call(null,inst_24891);
var inst_24893 = cljs.core.next.call(null,inst_24891);
var inst_24894 = cljs.core.vals.call(null,inst_24810);
var inst_24895 = cljs.core.seq.call(null,inst_24894);
var inst_24896 = cljs.core.first.call(null,inst_24895);
var inst_24897 = cljs.core.next.call(null,inst_24895);
var inst_24898 = offset;
var inst_24899 = cljs.core.PersistentHashMap.EMPTY;
var inst_24900 = inst_24890;
var inst_24901 = inst_24894;
var inst_24902 = (0);
var inst_24903 = inst_24898;
var inst_24904 = inst_24899;
var state_25025__$1 = (function (){var statearr_25080 = state_25025;
(statearr_25080[(16)] = inst_24903);

(statearr_25080[(27)] = inst_24893);

(statearr_25080[(28)] = inst_24896);

(statearr_25080[(24)] = inst_24901);

(statearr_25080[(29)] = inst_24897);

(statearr_25080[(30)] = inst_24892);

(statearr_25080[(25)] = inst_24900);

(statearr_25080[(26)] = inst_24902);

(statearr_25080[(9)] = inst_24904);

return statearr_25080;
})();
var statearr_25081_25195 = state_25025__$1;
(statearr_25081_25195[(2)] = null);

(statearr_25081_25195[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (17))){
var inst_24825 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25082_25196 = state_25025__$1;
(statearr_25082_25196[(2)] = inst_24825);

(statearr_25082_25196[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (3))){
var inst_25023 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25025__$1,inst_25023);
} else {
if((state_val_25026 === (12))){
var inst_24819 = cljs.core.first.call(null,orderBy);
var inst_24820 = cljs.core._EQ_.call(null,inst_24819,"DESC");
var state_25025__$1 = state_25025;
if(inst_24820){
var statearr_25083_25197 = state_25025__$1;
(statearr_25083_25197[(1)] = (15));

} else {
var statearr_25084_25198 = state_25025__$1;
(statearr_25084_25198[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (2))){
var _ = (function (){var statearr_25085 = state_25025;
(statearr_25085[(4)] = cljs.core.cons.call(null,(5),(state_25025[(4)])));

return statearr_25085;
})();
var state_25025__$1 = state_25025;
if(cljs.core.truth_(groupBy)){
var statearr_25086_25199 = state_25025__$1;
(statearr_25086_25199[(1)] = (6));

} else {
var statearr_25087_25200 = state_25025__$1;
(statearr_25087_25200[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (66))){
var inst_24991 = (state_25025[(7)]);
var inst_24990 = (state_25025[(2)]);
var inst_24991__$1 = fluree.db.util.async.throw_err.call(null,inst_24990);
var inst_24992 = cljs.core.coll_QMARK_.call(null,inst_24991__$1);
var inst_24993 = (!(inst_24992));
var state_25025__$1 = (function (){var statearr_25088 = state_25025;
(statearr_25088[(7)] = inst_24991__$1);

return statearr_25088;
})();
if(inst_24993){
var statearr_25089_25201 = state_25025__$1;
(statearr_25089_25201[(1)] = (67));

} else {
var statearr_25090_25202 = state_25025__$1;
(statearr_25090_25202[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (23))){
var inst_24837 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
if(cljs.core.truth_(inst_24837)){
var statearr_25091_25203 = state_25025__$1;
(statearr_25091_25203[(1)] = (24));

} else {
var statearr_25092_25204 = state_25025__$1;
(statearr_25092_25204[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (47))){
var inst_24968 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25093_25205 = state_25025__$1;
(statearr_25093_25205[(2)] = inst_24968);

(statearr_25093_25205[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (35))){
var inst_24982 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25094_25206 = state_25025__$1;
(statearr_25094_25206[(2)] = inst_24982);

(statearr_25094_25206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (76))){
var inst_24991 = (state_25025[(7)]);
var inst_25007 = cljs.core.distinct.call(null,inst_24991);
var state_25025__$1 = state_25025;
var statearr_25095_25207 = state_25025__$1;
(statearr_25095_25207[(2)] = inst_25007);

(statearr_25095_25207[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (19))){
var inst_24830 = (state_25025[(20)]);
var inst_24830__$1 = orderBy;
var state_25025__$1 = (function (){var statearr_25096 = state_25025;
(statearr_25096[(20)] = inst_24830__$1);

return statearr_25096;
})();
if(cljs.core.truth_(inst_24830__$1)){
var statearr_25097_25208 = state_25025__$1;
(statearr_25097_25208[(1)] = (21));

} else {
var statearr_25098_25209 = state_25025__$1;
(statearr_25098_25209[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (57))){
var state_25025__$1 = state_25025;
var statearr_25099_25210 = state_25025__$1;
(statearr_25099_25210[(2)] = null);

(statearr_25099_25210[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (68))){
var state_25025__$1 = state_25025;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25100_25211 = state_25025__$1;
(statearr_25100_25211[(1)] = (73));

} else {
var statearr_25101_25212 = state_25025__$1;
(statearr_25101_25212[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (11))){
var inst_24817 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
if(cljs.core.truth_(inst_24817)){
var statearr_25103_25213 = state_25025__$1;
(statearr_25103_25213[(1)] = (12));

} else {
var statearr_25104_25214 = state_25025__$1;
(statearr_25104_25214[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (9))){
var inst_24813 = cljs.core.second.call(null,orderBy);
var inst_24814 = cljs.core._EQ_.call(null,inst_24813,groupBy);
var state_25025__$1 = state_25025;
var statearr_25105_25215 = state_25025__$1;
(statearr_25105_25215[(2)] = inst_24814);

(statearr_25105_25215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (5))){
var _ = (function (){var statearr_25106 = state_25025;
(statearr_25106[(4)] = cljs.core.rest.call(null,(state_25025[(4)])));

return statearr_25106;
})();
var state_25025__$1 = state_25025;
var ex25102 = (state_25025__$1[(2)]);
var statearr_25107_25216 = state_25025__$1;
(statearr_25107_25216[(5)] = ex25102);


if((ex25102 instanceof Error)){
var statearr_25108_25217 = state_25025__$1;
(statearr_25108_25217[(1)] = (4));

(statearr_25108_25217[(5)] = null);

} else {
throw ex25102;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (14))){
var inst_24859 = (state_25025[(2)]);
var state_25025__$1 = (function (){var statearr_25109 = state_25025;
(statearr_25109[(10)] = inst_24859);

return statearr_25109;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25110_25218 = state_25025__$1;
(statearr_25110_25218[(1)] = (33));

} else {
var statearr_25111_25219 = state_25025__$1;
(statearr_25111_25219[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (45))){
var inst_24928 = (state_25025[(17)]);
var inst_24916 = (state_25025[(18)]);
var inst_24902 = (state_25025[(26)]);
var inst_24927 = cljs.core.count.call(null,inst_24916);
var inst_24928__$1 = (inst_24902 + inst_24927);
var inst_24929 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24930 = [headers,vars,inst_24916];
var inst_24931 = cljs.core.PersistentHashMap.fromArrays(inst_24929,inst_24930);
var inst_24932 = (limit > inst_24928__$1);
var state_25025__$1 = (function (){var statearr_25112 = state_25025;
(statearr_25112[(17)] = inst_24928__$1);

(statearr_25112[(15)] = inst_24931);

return statearr_25112;
})();
if(cljs.core.truth_(inst_24932)){
var statearr_25113_25220 = state_25025__$1;
(statearr_25113_25220[(1)] = (48));

} else {
var statearr_25114_25221 = state_25025__$1;
(statearr_25114_25221[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (53))){
var inst_24928 = (state_25025[(17)]);
var inst_24949 = (limit < inst_24928);
var state_25025__$1 = state_25025;
if(cljs.core.truth_(inst_24949)){
var statearr_25115_25222 = state_25025__$1;
(statearr_25115_25222[(1)] = (56));

} else {
var statearr_25116_25223 = state_25025__$1;
(statearr_25116_25223[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (78))){
var inst_25014 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25117_25224 = state_25025__$1;
(statearr_25117_25224[(2)] = inst_25014);

(statearr_25117_25224[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (26))){
var inst_24855 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25118_25225 = state_25025__$1;
(statearr_25118_25225[(2)] = inst_24855);

(statearr_25118_25225[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (16))){
var state_25025__$1 = state_25025;
var statearr_25119_25226 = state_25025__$1;
(statearr_25119_25226[(2)] = fluree.db.query.fql.compare_fn);

(statearr_25119_25226[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (81))){
var inst_25012 = (state_25025[(2)]);
var state_25025__$1 = state_25025;
var statearr_25120_25227 = state_25025__$1;
(statearr_25120_25227[(2)] = inst_25012);

(statearr_25120_25227[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (79))){
var inst_24991 = (state_25025[(7)]);
var state_25025__$1 = state_25025;
var statearr_25121_25228 = state_25025__$1;
(statearr_25121_25228[(2)] = inst_24991);

(statearr_25121_25228[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (38))){
var inst_24859 = (state_25025[(10)]);
var inst_24974 = (state_25025[(2)]);
var state_25025__$1 = (function (){var statearr_25122 = state_25025;
(statearr_25122[(11)] = inst_24974);

return statearr_25122;
})();
if(cljs.core.truth_(inst_24859)){
var statearr_25123_25229 = state_25025__$1;
(statearr_25123_25229[(1)] = (60));

} else {
var statearr_25124_25230 = state_25025__$1;
(statearr_25124_25230[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (30))){
var state_25025__$1 = state_25025;
var statearr_25125_25231 = state_25025__$1;
(statearr_25125_25231[(2)] = null);

(statearr_25125_25231[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (73))){
var inst_24991 = (state_25025[(7)]);
var inst_25004 = cljs.core.first.call(null,inst_24991);
var state_25025__$1 = state_25025;
var statearr_25126_25232 = state_25025__$1;
(statearr_25126_25232[(2)] = inst_25004);

(statearr_25126_25232[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (10))){
var inst_24811 = (state_25025[(21)]);
var state_25025__$1 = state_25025;
var statearr_25127_25233 = state_25025__$1;
(statearr_25127_25233[(2)] = inst_24811);

(statearr_25127_25233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (18))){
var state_25025__$1 = state_25025;
var statearr_25128_25234 = state_25025__$1;
(statearr_25128_25234[(2)] = null);

(statearr_25128_25234[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (52))){
var inst_24931 = (state_25025[(15)]);
var inst_24943 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24931,select_spec,opts);
var state_25025__$1 = state_25025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25025__$1,(55),inst_24943);
} else {
if((state_val_25026 === (67))){
var state_25025__$1 = state_25025;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25131_25235 = state_25025__$1;
(statearr_25131_25235[(1)] = (70));

} else {
var statearr_25132_25236 = state_25025__$1;
(statearr_25132_25236[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (71))){
var inst_24991 = (state_25025[(7)]);
var state_25025__$1 = state_25025;
var statearr_25133_25237 = state_25025__$1;
(statearr_25133_25237[(2)] = inst_24991);

(statearr_25133_25237[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (42))){
var inst_24903 = (state_25025[(16)]);
var inst_24914 = (state_25025[(22)]);
var inst_24902 = (state_25025[(26)]);
var inst_24917 = (state_25025[(23)]);
var inst_24904 = (state_25025[(9)]);
var inst_24923 = (inst_24903 - (1));
var tmp25129 = inst_24902;
var tmp25130 = inst_24904;
var inst_24900 = inst_24914;
var inst_24901 = inst_24917;
var inst_24902__$1 = tmp25129;
var inst_24903__$1 = inst_24923;
var inst_24904__$1 = tmp25130;
var state_25025__$1 = (function (){var statearr_25134 = state_25025;
(statearr_25134[(16)] = inst_24903__$1);

(statearr_25134[(24)] = inst_24901);

(statearr_25134[(25)] = inst_24900);

(statearr_25134[(26)] = inst_24902__$1);

(statearr_25134[(9)] = inst_24904__$1);

return statearr_25134;
})();
var statearr_25135_25238 = state_25025__$1;
(statearr_25135_25238[(2)] = null);

(statearr_25135_25238[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (80))){
var state_25025__$1 = state_25025;
var statearr_25136_25239 = state_25025__$1;
(statearr_25136_25239[(2)] = null);

(statearr_25136_25239[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (37))){
var inst_24901 = (state_25025[(24)]);
var inst_24916 = (state_25025[(18)]);
var inst_24900 = (state_25025[(25)]);
var inst_24912 = cljs.core.seq.call(null,inst_24900);
var inst_24913 = cljs.core.first.call(null,inst_24912);
var inst_24914 = cljs.core.next.call(null,inst_24912);
var inst_24915 = cljs.core.seq.call(null,inst_24901);
var inst_24916__$1 = cljs.core.first.call(null,inst_24915);
var inst_24917 = cljs.core.next.call(null,inst_24915);
var inst_24918 = (inst_24916__$1 == null);
var state_25025__$1 = (function (){var statearr_25137 = state_25025;
(statearr_25137[(18)] = inst_24916__$1);

(statearr_25137[(22)] = inst_24914);

(statearr_25137[(8)] = inst_24913);

(statearr_25137[(23)] = inst_24917);

return statearr_25137;
})();
if(cljs.core.truth_(inst_24918)){
var statearr_25138_25240 = state_25025__$1;
(statearr_25138_25240[(1)] = (39));

} else {
var statearr_25139_25241 = state_25025__$1;
(statearr_25139_25241[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (63))){
var state_25025__$1 = state_25025;
var statearr_25140_25242 = state_25025__$1;
(statearr_25140_25242[(2)] = (1));

(statearr_25140_25242[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (8))){
var inst_25020 = (state_25025[(2)]);
var _ = (function (){var statearr_25141 = state_25025;
(statearr_25141[(4)] = cljs.core.rest.call(null,(state_25025[(4)])));

return statearr_25141;
})();
var state_25025__$1 = state_25025;
var statearr_25142_25243 = state_25025__$1;
(statearr_25142_25243[(2)] = inst_25020);

(statearr_25142_25243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25026 === (49))){
var inst_24928 = (state_25025[(17)]);
var inst_24941 = cljs.core._EQ_.call(null,limit,inst_24928);
var state_25025__$1 = state_25025;
if(inst_24941){
var statearr_25143_25244 = state_25025__$1;
(statearr_25143_25244[(1)] = (52));

} else {
var statearr_25144_25245 = state_25025__$1;
(statearr_25144_25245[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____0 = (function (){
var statearr_25145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25145[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__);

(statearr_25145[(1)] = (1));

return statearr_25145;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____1 = (function (state_25025){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_25025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e25146){var ex__2457__auto__ = e25146;
var statearr_25147_25246 = state_25025;
(statearr_25147_25246[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_25025[(4)]))){
var statearr_25148_25247 = state_25025;
(statearr_25148_25247[(1)] = cljs.core.first.call(null,(state_25025[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25248 = state_25025;
state_25025 = G__25248;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__ = function(state_25025){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____1.call(this,state_25025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_25149 = f__2477__auto__.call(null);
(statearr_25149[(6)] = c__2476__auto__);

return statearr_25149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25251,opts){
var map__25252 = p__25251;
var map__25252__$1 = (((((!((map__25252 == null))))?(((((map__25252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25252):map__25252);
var selectOne = cljs.core.get.call(null,map__25252__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25252__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25252__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25252__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25249_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25249_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25250_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25250_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25254,p__25255){
var map__25256 = p__25254;
var map__25256__$1 = (((((!((map__25256 == null))))?(((((map__25256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25256):map__25256);
var query_map = map__25256__$1;
var construct = cljs.core.get.call(null,map__25256__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25257 = p__25255;
var map__25257__$1 = (((((!((map__25257 == null))))?(((((map__25257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25257.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25257):map__25257);
var where_result = map__25257__$1;
var headers = cljs.core.get.call(null,map__25257__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25257__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25260 = cljs.core.map.call(null,(function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25260,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25260,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25260,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_25293){
var state_val_25294 = (state_25293[(1)]);
if((state_val_25294 === (7))){
var inst_25272 = (state_25293[(7)]);
var state_25293__$1 = state_25293;
var statearr_25295_25318 = state_25293__$1;
(statearr_25295_25318[(2)] = inst_25272);

(statearr_25295_25318[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (1))){
var state_25293__$1 = state_25293;
var statearr_25296_25319 = state_25293__$1;
(statearr_25296_25319[(2)] = null);

(statearr_25296_25319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (4))){
var inst_25263 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25297_25320 = state_25293__$1;
(statearr_25297_25320[(2)] = inst_25263);

(statearr_25297_25320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (13))){
var inst_25282 = (state_25293[(2)]);
var inst_25283 = fluree.db.util.async.throw_err.call(null,inst_25282);
var state_25293__$1 = state_25293;
var statearr_25298_25321 = state_25293__$1;
(statearr_25298_25321[(2)] = inst_25283);

(statearr_25298_25321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (6))){
var inst_25272 = (state_25293[(7)]);
var inst_25271 = (state_25293[(2)]);
var inst_25272__$1 = fluree.db.util.async.throw_err.call(null,inst_25271);
var inst_25273 = fluree.db.util.core.exception_QMARK_.call(null,inst_25272__$1);
var state_25293__$1 = (function (){var statearr_25299 = state_25293;
(statearr_25299[(7)] = inst_25272__$1);

return statearr_25299;
})();
if(inst_25273){
var statearr_25300_25322 = state_25293__$1;
(statearr_25300_25322[(1)] = (7));

} else {
var statearr_25301_25323 = state_25293__$1;
(statearr_25301_25323[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (3))){
var inst_25291 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25293__$1,inst_25291);
} else {
if((state_val_25294 === (12))){
var inst_25286 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25302_25324 = state_25293__$1;
(statearr_25302_25324[(2)] = inst_25286);

(statearr_25302_25324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (2))){
var _ = (function (){var statearr_25303 = state_25293;
(statearr_25303[(4)] = cljs.core.cons.call(null,(5),(state_25293[(4)])));

return statearr_25303;
})();
var inst_25269 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25293__$1,(6),inst_25269);
} else {
if((state_val_25294 === (11))){
var state_25293__$1 = state_25293;
var statearr_25305_25325 = state_25293__$1;
(statearr_25305_25325[(2)] = null);

(statearr_25305_25325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (9))){
var inst_25288 = (state_25293[(2)]);
var _ = (function (){var statearr_25306 = state_25293;
(statearr_25306[(4)] = cljs.core.rest.call(null,(state_25293[(4)])));

return statearr_25306;
})();
var state_25293__$1 = state_25293;
var statearr_25307_25326 = state_25293__$1;
(statearr_25307_25326[(2)] = inst_25288);

(statearr_25307_25326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (5))){
var _ = (function (){var statearr_25308 = state_25293;
(statearr_25308[(4)] = cljs.core.rest.call(null,(state_25293[(4)])));

return statearr_25308;
})();
var state_25293__$1 = state_25293;
var ex25304 = (state_25293__$1[(2)]);
var statearr_25309_25327 = state_25293__$1;
(statearr_25309_25327[(5)] = ex25304);


if((ex25304 instanceof Error)){
var statearr_25310_25328 = state_25293__$1;
(statearr_25310_25328[(1)] = (4));

(statearr_25310_25328[(5)] = null);

} else {
throw ex25304;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (10))){
var inst_25272 = (state_25293[(7)]);
var inst_25277 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25272);
var inst_25278 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25272);
var inst_25279 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25277,inst_25278,query_map,opts);
var inst_25280 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_25272,inst_25279,opts);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25293__$1,(13),inst_25280);
} else {
if((state_val_25294 === (8))){
var state_25293__$1 = state_25293;
var statearr_25311_25329 = state_25293__$1;
(statearr_25311_25329[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____0 = (function (){
var statearr_25313 = [null,null,null,null,null,null,null,null];
(statearr_25313[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__);

(statearr_25313[(1)] = (1));

return statearr_25313;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____1 = (function (state_25293){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_25293);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e25314){var ex__2457__auto__ = e25314;
var statearr_25315_25330 = state_25293;
(statearr_25315_25330[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_25293[(4)]))){
var statearr_25316_25331 = state_25293;
(statearr_25316_25331[(1)] = cljs.core.first.call(null,(state_25293[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25332 = state_25293;
state_25293 = G__25332;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__ = function(state_25293){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____1.call(this,state_25293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_25317 = f__2477__auto__.call(null);
(statearr_25317[(6)] = c__2476__auto__);

return statearr_25317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25333 = query_map;
var map__25333__$1 = (((((!((map__25333 == null))))?(((((map__25333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25333.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25333):map__25333);
var select = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25333__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):opts_SINGLEQUOTE_);
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE__SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
} else {
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_25702){
var state_val_25703 = (state_25702[(1)]);
if((state_val_25703 === (121))){
var inst_25647 = (state_25702[(7)]);
var inst_25643 = (state_25702[(8)]);
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25651 = (state_25702[(2)]);
var inst_25652 = fluree.db.query.fql.subject_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25643,inst_25647,inst_25651);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(115),inst_25652);
} else {
if((state_val_25703 === (65))){
var inst_25493 = (state_25702[(11)]);
var inst_25404 = (state_25702[(12)]);
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25507 = (state_25702[(2)]);
var inst_25508 = fluree.db.util.async.throw_err.call(null,inst_25507);
var inst_25509 = cljs.core.sequence.call(null,inst_25493,inst_25508);
var inst_25510 = fluree.db.query.fql.subject_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25509,inst_25404);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(66),inst_25510);
} else {
if((state_val_25703 === (70))){
var inst_25403 = (state_25702[(13)]);
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25403)){
var statearr_25704_25896 = state_25702__$1;
(statearr_25704_25896[(1)] = (73));

} else {
var statearr_25705_25897 = state_25702__$1;
(statearr_25705_25897[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (62))){
var inst_25495 = cljs.core.PersistentHashMap.EMPTY;
var state_25702__$1 = state_25702;
var statearr_25706_25898 = state_25702__$1;
(statearr_25706_25898[(2)] = inst_25495);

(statearr_25706_25898[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (74))){
var inst_25406 = (state_25702[(14)]);
var inst_25404 = (state_25702[(12)]);
var inst_25528 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25529 = [inst_25404,inst_25406];
var inst_25530 = cljs.core.PersistentHashMap.fromArrays(inst_25528,inst_25529);
var state_25702__$1 = state_25702;
var statearr_25707_25899 = state_25702__$1;
(statearr_25707_25899[(2)] = inst_25530);

(statearr_25707_25899[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (110))){
var inst_25611 = (state_25702[(15)]);
var inst_25625 = (state_25702[(2)]);
var inst_25626 = fluree.db.dbproto._subid.call(null,db,inst_25611,false);
var state_25702__$1 = (function (){var statearr_25708 = state_25702;
(statearr_25708[(16)] = inst_25625);

return statearr_25708;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(111),inst_25626);
} else {
if((state_val_25703 === (130))){
var inst_25692 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25692)){
var statearr_25709_25900 = state_25702__$1;
(statearr_25709_25900[(1)] = (131));

} else {
var statearr_25710_25901 = state_25702__$1;
(statearr_25710_25901[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (128))){
var inst_25683 = (state_25702[(17)]);
var inst_25686 = cljs.core.coll_QMARK_.call(null,inst_25683);
var inst_25687 = fluree.db.util.core.exception_QMARK_.call(null,inst_25683);
var inst_25688 = (!(inst_25687));
var inst_25689 = ((inst_25686) && (inst_25688));
var state_25702__$1 = state_25702;
var statearr_25711_25902 = state_25702__$1;
(statearr_25711_25902[(2)] = inst_25689);

(statearr_25711_25902[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (7))){
var inst_25364 = (state_25702[(18)]);
var inst_25364__$1 = selectOne;
var state_25702__$1 = (function (){var statearr_25712 = state_25702;
(statearr_25712[(18)] = inst_25364__$1);

return statearr_25712;
})();
if(cljs.core.truth_(inst_25364__$1)){
var statearr_25713_25903 = state_25702__$1;
(statearr_25713_25903[(1)] = (9));

} else {
var statearr_25714_25904 = state_25702__$1;
(statearr_25714_25904[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (59))){
var inst_25487 = (state_25702[(19)]);
var inst_25489 = cljs.core.distinct.call(null);
var inst_25490 = cljs.core.comp.call(null,inst_25487,inst_25489);
var state_25702__$1 = state_25702;
var statearr_25715_25905 = state_25702__$1;
(statearr_25715_25905[(2)] = inst_25490);

(statearr_25715_25905[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (86))){
var inst_25564 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(89),inst_25564);
} else {
if((state_val_25703 === (20))){
var inst_25394 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25716_25906 = state_25702__$1;
(statearr_25716_25906[(2)] = inst_25394);

(statearr_25716_25906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (72))){
var inst_25674 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25717_25907 = state_25702__$1;
(statearr_25717_25907[(2)] = inst_25674);

(statearr_25717_25907[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (58))){
var inst_25487 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25718 = state_25702;
(statearr_25718[(19)] = inst_25487);

return statearr_25718;
})();
var statearr_25719_25908 = state_25702__$1;
(statearr_25719_25908[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (60))){
var inst_25487 = (state_25702[(19)]);
var state_25702__$1 = state_25702;
var statearr_25721_25909 = state_25702__$1;
(statearr_25721_25909[(2)] = inst_25487);

(statearr_25721_25909[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (27))){
var inst_25403 = (state_25702[(13)]);
var inst_25418 = cljs.core.vector_QMARK_.call(null,inst_25403);
var state_25702__$1 = state_25702;
if(inst_25418){
var statearr_25722_25910 = state_25702__$1;
(statearr_25722_25910[(1)] = (30));

} else {
var statearr_25723_25911 = state_25702__$1;
(statearr_25723_25911[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (1))){
var state_25702__$1 = state_25702;
var statearr_25724_25912 = state_25702__$1;
(statearr_25724_25912[(2)] = null);

(statearr_25724_25912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (69))){
var inst_25523 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25523)){
var statearr_25725_25913 = state_25702__$1;
(statearr_25725_25913[(1)] = (70));

} else {
var statearr_25726_25914 = state_25702__$1;
(statearr_25726_25914[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (101))){
var inst_25403 = (state_25702[(13)]);
var inst_25641 = (state_25702[(2)]);
var inst_25642 = cljs.core.PersistentVector.EMPTY;
var inst_25643 = cljs.core.into.call(null,inst_25642,inst_25641);
var state_25702__$1 = (function (){var statearr_25727 = state_25702;
(statearr_25727[(8)] = inst_25643);

return statearr_25727;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25728_25915 = state_25702__$1;
(statearr_25728_25915[(1)] = (116));

} else {
var statearr_25729_25916 = state_25702__$1;
(statearr_25729_25916[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (24))){
var inst_25405 = (state_25702[(20)]);
var inst_25407 = (state_25702[(21)]);
var inst_25411 = cljs.core.assoc.call(null,inst_25407,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25405);
var state_25702__$1 = state_25702;
var statearr_25730_25917 = state_25702__$1;
(statearr_25730_25917[(2)] = inst_25411);

(statearr_25730_25917[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (102))){
var inst_25605 = (state_25702[(22)]);
var state_25702__$1 = state_25702;
var statearr_25731_25918 = state_25702__$1;
(statearr_25731_25918[(2)] = inst_25605);

(statearr_25731_25918[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (55))){
var inst_25676 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25732_25919 = state_25702__$1;
(statearr_25732_25919[(2)] = inst_25676);

(statearr_25732_25919[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (85))){
var inst_25558 = (state_25702[(2)]);
var inst_25559 = fluree.db.util.async.throw_err.call(null,inst_25558);
var state_25702__$1 = state_25702;
var statearr_25733_25920 = state_25702__$1;
(statearr_25733_25920[(2)] = inst_25559);

(statearr_25733_25920[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (39))){
var inst_25453 = typeof from === 'string';
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25453)){
var statearr_25734_25921 = state_25702__$1;
(statearr_25734_25921[(1)] = (42));

} else {
var statearr_25735_25922 = state_25702__$1;
(statearr_25735_25922[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (88))){
var inst_25670 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25736_25923 = state_25702__$1;
(statearr_25736_25923[(2)] = inst_25670);

(statearr_25736_25923[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (46))){
var inst_25472 = (state_25702[(2)]);
var inst_25473 = fluree.db.util.async.throw_err.call(null,inst_25472);
var state_25702__$1 = state_25702;
var statearr_25737_25924 = state_25702__$1;
(statearr_25737_25924[(2)] = inst_25473);

(statearr_25737_25924[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (4))){
var inst_25351 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25738_25925 = state_25702__$1;
(statearr_25738_25925[(2)] = inst_25351);

(statearr_25738_25925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (77))){
var inst_25539 = (state_25702[(2)]);
var inst_25540 = fluree.db.util.async.throw_err.call(null,inst_25539);
var state_25702__$1 = state_25702;
var statearr_25739_25926 = state_25702__$1;
(statearr_25739_25926[(2)] = inst_25540);

(statearr_25739_25926[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (106))){
var state_25702__$1 = state_25702;
if(cljs.core.truth_(fuel)){
var statearr_25740_25927 = state_25702__$1;
(statearr_25740_25927[(1)] = (108));

} else {
var statearr_25741_25928 = state_25702__$1;
(statearr_25741_25928[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (119))){
var state_25702__$1 = state_25702;
var statearr_25742_25929 = state_25702__$1;
(statearr_25742_25929[(2)] = null);

(statearr_25742_25929[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (95))){
var state_25702__$1 = state_25702;
var statearr_25743_25930 = state_25702__$1;
(statearr_25743_25930[(2)] = null);

(statearr_25743_25930[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (54))){
var inst_25515 = typeof from === 'string';
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25515)){
var statearr_25744_25931 = state_25702__$1;
(statearr_25744_25931[(1)] = (67));

} else {
var statearr_25745_25932 = state_25702__$1;
(statearr_25745_25932[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (92))){
var inst_25406 = (state_25702[(14)]);
var inst_25404 = (state_25702[(12)]);
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25575 = (state_25702[(2)]);
var inst_25576 = fluree.db.query.fql.subject_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25575,inst_25404,inst_25406);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(93),inst_25576);
} else {
if((state_val_25703 === (104))){
var inst_25639 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25746_25933 = state_25702__$1;
(statearr_25746_25933[(2)] = inst_25639);

(statearr_25746_25933[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (15))){
var inst_25381 = (state_25702[(23)]);
var inst_25386 = inst_25381.cljs$lang$protocol_mask$partition0$;
var inst_25387 = (inst_25386 & (64));
var inst_25388 = inst_25381.cljs$core$ISeq$;
var inst_25389 = (cljs.core.PROTOCOL_SENTINEL === inst_25388);
var inst_25390 = ((inst_25387) || (inst_25389));
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25390)){
var statearr_25747_25934 = state_25702__$1;
(statearr_25747_25934[(1)] = (18));

} else {
var statearr_25748_25935 = state_25702__$1;
(statearr_25748_25935[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (48))){
var inst_25404 = (state_25702[(12)]);
var state_25702__$1 = state_25702;
var statearr_25749_25936 = state_25702__$1;
(statearr_25749_25936[(2)] = inst_25404);

(statearr_25749_25936[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (50))){
var state_25702__$1 = state_25702;
var statearr_25750_25937 = state_25702__$1;
(statearr_25750_25937[(2)] = null);

(statearr_25750_25937[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (116))){
var state_25702__$1 = state_25702;
var statearr_25751_25938 = state_25702__$1;
(statearr_25751_25938[(2)] = null);

(statearr_25751_25938[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (75))){
var inst_25532 = (state_25702[(2)]);
var inst_25533 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25532);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(76),inst_25533);
} else {
if((state_val_25703 === (99))){
var inst_25668 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25752_25939 = state_25702__$1;
(statearr_25752_25939[(2)] = inst_25668);

(statearr_25752_25939[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (21))){
var inst_25381 = (state_25702[(23)]);
var inst_25399 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25381);
var state_25702__$1 = state_25702;
var statearr_25753_25940 = state_25702__$1;
(statearr_25753_25940[(2)] = inst_25399);

(statearr_25753_25940[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (31))){
var inst_25403 = (state_25702[(13)]);
var inst_25426 = typeof inst_25403 === 'string';
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25426)){
var statearr_25754_25941 = state_25702__$1;
(statearr_25754_25941[(1)] = (33));

} else {
var statearr_25755_25942 = state_25702__$1;
(statearr_25755_25942[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (113))){
var inst_25605 = (state_25702[(22)]);
var state_25702__$1 = state_25702;
var statearr_25756_25943 = state_25702__$1;
(statearr_25756_25943[(2)] = inst_25605);

(statearr_25756_25943[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (32))){
var inst_25442 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25757_25944 = state_25702__$1;
(statearr_25757_25944[(2)] = inst_25442);

(statearr_25757_25944[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (40))){
var inst_25475 = typeof from === 'string';
var inst_25476 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25477 = clojure.string.includes_QMARK_.call(null,inst_25476,"/");
var inst_25478 = ((inst_25475) && (inst_25477));
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25478)){
var statearr_25758_25945 = state_25702__$1;
(statearr_25758_25945[(1)] = (53));

} else {
var statearr_25759_25946 = state_25702__$1;
(statearr_25759_25946[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (129))){
var inst_25684 = (state_25702[(24)]);
var state_25702__$1 = state_25702;
var statearr_25760_25947 = state_25702__$1;
(statearr_25760_25947[(2)] = inst_25684);

(statearr_25760_25947[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (91))){
var inst_25567 = (state_25702[(25)]);
var inst_25571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25572 = [inst_25567];
var inst_25573 = (new cljs.core.PersistentVector(null,1,(5),inst_25571,inst_25572,null));
var state_25702__$1 = state_25702;
var statearr_25761_25948 = state_25702__$1;
(statearr_25761_25948[(2)] = inst_25573);

(statearr_25761_25948[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (117))){
var inst_25404 = (state_25702[(12)]);
var state_25702__$1 = state_25702;
var statearr_25762_25949 = state_25702__$1;
(statearr_25762_25949[(2)] = inst_25404);

(statearr_25762_25949[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (108))){
var inst_25620 = cljs.core._deref.call(null,fuel);
var inst_25621 = (inst_25620 + (1));
var inst_25622 = cljs.core._vreset_BANG_.call(null,fuel,inst_25621);
var state_25702__$1 = state_25702;
var statearr_25763_25950 = state_25702__$1;
(statearr_25763_25950[(2)] = inst_25622);

(statearr_25763_25950[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (56))){
var inst_25481 = (state_25702[(26)]);
var inst_25483 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25484 = cljs.core.comp.call(null,inst_25481,inst_25483);
var state_25702__$1 = state_25702;
var statearr_25764_25951 = state_25702__$1;
(statearr_25764_25951[(2)] = inst_25484);

(statearr_25764_25951[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (33))){
var inst_25403 = (state_25702[(13)]);
var inst_25428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25429 = [inst_25403,"ASC"];
var inst_25430 = (new cljs.core.PersistentVector(null,2,(5),inst_25428,inst_25429,null));
var state_25702__$1 = state_25702;
var statearr_25765_25952 = state_25702__$1;
(statearr_25765_25952[(2)] = inst_25430);

(statearr_25765_25952[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (13))){
var inst_25370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25371 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25372 = cljs.core.PersistentHashMap.fromArrays(inst_25370,inst_25371);
var inst_25373 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25372);
var inst_25374 = (function(){throw inst_25373})();
var state_25702__$1 = state_25702;
var statearr_25766_25953 = state_25702__$1;
(statearr_25766_25953[(2)] = inst_25374);

(statearr_25766_25953[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (22))){
var inst_25381 = (state_25702[(23)]);
var state_25702__$1 = state_25702;
var statearr_25767_25954 = state_25702__$1;
(statearr_25767_25954[(2)] = inst_25381);

(statearr_25767_25954[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (90))){
var state_25702__$1 = state_25702;
var statearr_25768_25955 = state_25702__$1;
(statearr_25768_25955[(2)] = null);

(statearr_25768_25955[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (109))){
var state_25702__$1 = state_25702;
var statearr_25769_25956 = state_25702__$1;
(statearr_25769_25956[(2)] = null);

(statearr_25769_25956[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (36))){
var inst_25433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25434 = [null,null];
var inst_25435 = (new cljs.core.PersistentVector(null,2,(5),inst_25433,inst_25434,null));
var state_25702__$1 = state_25702;
var statearr_25770_25957 = state_25702__$1;
(statearr_25770_25957[(2)] = inst_25435);

(statearr_25770_25957[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (41))){
var inst_25449 = (state_25702[(27)]);
var inst_25678 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25771 = state_25702;
(statearr_25771[(28)] = inst_25678);

return statearr_25771;
})();
if(cljs.core.truth_(inst_25449)){
var statearr_25772_25958 = state_25702__$1;
(statearr_25772_25958[(1)] = (125));

} else {
var statearr_25773_25959 = state_25702__$1;
(statearr_25773_25959[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (118))){
var inst_25403 = (state_25702[(13)]);
var inst_25647 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25774 = state_25702;
(statearr_25774[(7)] = inst_25647);

return statearr_25774;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25775_25960 = state_25702__$1;
(statearr_25775_25960[(1)] = (119));

} else {
var statearr_25776_25961 = state_25702__$1;
(statearr_25776_25961[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (89))){
var inst_25567 = (state_25702[(25)]);
var inst_25566 = (state_25702[(2)]);
var inst_25567__$1 = fluree.db.util.async.throw_err.call(null,inst_25566);
var inst_25568 = (inst_25567__$1 == null);
var state_25702__$1 = (function (){var statearr_25777 = state_25702;
(statearr_25777[(25)] = inst_25567__$1);

return statearr_25777;
})();
if(cljs.core.truth_(inst_25568)){
var statearr_25778_25962 = state_25702__$1;
(statearr_25778_25962[(1)] = (90));

} else {
var statearr_25779_25963 = state_25702__$1;
(statearr_25779_25963[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (100))){
var inst_25604 = (state_25702[(29)]);
var inst_25611 = (state_25702[(15)]);
var inst_25610 = cljs.core.seq.call(null,inst_25604);
var inst_25611__$1 = cljs.core.first.call(null,inst_25610);
var inst_25612 = cljs.core.next.call(null,inst_25610);
var inst_25613 = cljs.core.not.call(null,inst_25611__$1);
var state_25702__$1 = (function (){var statearr_25780 = state_25702;
(statearr_25780[(30)] = inst_25612);

(statearr_25780[(15)] = inst_25611__$1);

return statearr_25780;
})();
if(inst_25613){
var statearr_25781_25964 = state_25702__$1;
(statearr_25781_25964[(1)] = (102));

} else {
var statearr_25782_25965 = state_25702__$1;
(statearr_25782_25965[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (131))){
var inst_25683 = (state_25702[(17)]);
var inst_25694 = cljs.core.first.call(null,inst_25683);
var state_25702__$1 = state_25702;
var statearr_25783_25966 = state_25702__$1;
(statearr_25783_25966[(2)] = inst_25694);

(statearr_25783_25966[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (122))){
var inst_25658 = cljs.core.pr_str.call(null,query_map);
var inst_25659 = ["Invalid 'from' in query:",inst_25658].join('');
var inst_25660 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25661 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25662 = cljs.core.PersistentHashMap.fromArrays(inst_25660,inst_25661);
var inst_25663 = cljs.core.ex_info.call(null,inst_25659,inst_25662);
var state_25702__$1 = state_25702;
var statearr_25784_25967 = state_25702__$1;
(statearr_25784_25967[(2)] = inst_25663);

(statearr_25784_25967[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (43))){
var state_25702__$1 = state_25702;
var statearr_25785_25968 = state_25702__$1;
(statearr_25785_25968[(2)] = null);

(statearr_25785_25968[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (61))){
var inst_25403 = (state_25702[(13)]);
var inst_25493 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25786 = state_25702;
(statearr_25786[(11)] = inst_25493);

return statearr_25786;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25787_25969 = state_25702__$1;
(statearr_25787_25969[(1)] = (62));

} else {
var statearr_25788_25970 = state_25702__$1;
(statearr_25788_25970[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (29))){
var inst_25448 = (state_25702[(2)]);
var inst_25449 = cljs.core.nth.call(null,inst_25448,(0),null);
var inst_25450 = cljs.core.nth.call(null,inst_25448,(1),null);
var inst_25451 = typeof where === 'string';
var state_25702__$1 = (function (){var statearr_25789 = state_25702;
(statearr_25789[(31)] = inst_25450);

(statearr_25789[(27)] = inst_25449);

return statearr_25789;
})();
if(cljs.core.truth_(inst_25451)){
var statearr_25790_25971 = state_25702__$1;
(statearr_25790_25971[(1)] = (39));

} else {
var statearr_25791_25972 = state_25702__$1;
(statearr_25791_25972[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (44))){
var inst_25457 = (state_25702[(2)]);
var inst_25458 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25457);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(45),inst_25458);
} else {
if((state_val_25703 === (93))){
var inst_25578 = (state_25702[(2)]);
var inst_25579 = fluree.db.util.async.throw_err.call(null,inst_25578);
var state_25702__$1 = (function (){var statearr_25792 = state_25702;
(statearr_25792[(32)] = inst_25579);

return statearr_25792;
})();
if(cljs.core.truth_(fuel)){
var statearr_25793_25973 = state_25702__$1;
(statearr_25793_25973[(1)] = (94));

} else {
var statearr_25794_25974 = state_25702__$1;
(statearr_25794_25974[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (6))){
var inst_25361 = (state_25702[(33)]);
var state_25702__$1 = state_25702;
var statearr_25795_25975 = state_25702__$1;
(statearr_25795_25975[(2)] = inst_25361);

(statearr_25795_25975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (111))){
var inst_25628 = (state_25702[(2)]);
var inst_25629 = fluree.db.util.async.throw_err.call(null,inst_25628);
var state_25702__$1 = state_25702;
var statearr_25796_25976 = state_25702__$1;
(statearr_25796_25976[(2)] = inst_25629);

(statearr_25796_25976[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (28))){
var inst_25444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25445 = [null,null];
var inst_25446 = (new cljs.core.PersistentVector(null,2,(5),inst_25444,inst_25445,null));
var state_25702__$1 = state_25702;
var statearr_25797_25977 = state_25702__$1;
(statearr_25797_25977[(2)] = inst_25446);

(statearr_25797_25977[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (64))){
var inst_25501 = (state_25702[(2)]);
var inst_25502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25503 = [from];
var inst_25504 = (new cljs.core.PersistentVector(null,1,(5),inst_25502,inst_25503,null));
var inst_25505 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25504,inst_25501);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(65),inst_25505);
} else {
if((state_val_25703 === (103))){
var inst_25611 = (state_25702[(15)]);
var inst_25616 = cljs.core.int_QMARK_.call(null,inst_25611);
var state_25702__$1 = state_25702;
if(inst_25616){
var statearr_25798_25978 = state_25702__$1;
(statearr_25798_25978[(1)] = (105));

} else {
var statearr_25799_25979 = state_25702__$1;
(statearr_25799_25979[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (51))){
var inst_25406 = (state_25702[(14)]);
var state_25702__$1 = state_25702;
var statearr_25800_25980 = state_25702__$1;
(statearr_25800_25980[(2)] = inst_25406);

(statearr_25800_25980[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (25))){
var inst_25407 = (state_25702[(21)]);
var state_25702__$1 = state_25702;
var statearr_25801_25981 = state_25702__$1;
(statearr_25801_25981[(2)] = inst_25407);

(statearr_25801_25981[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (34))){
var state_25702__$1 = state_25702;
var statearr_25802_25982 = state_25702__$1;
(statearr_25802_25982[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (125))){
var inst_25450 = (state_25702[(31)]);
var inst_25406 = (state_25702[(14)]);
var inst_25404 = (state_25702[(12)]);
var inst_25678 = (state_25702[(28)]);
var inst_25449 = (state_25702[(27)]);
var inst_25680 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25449,inst_25450,inst_25406,inst_25404,inst_25678);
var state_25702__$1 = state_25702;
var statearr_25804_25983 = state_25702__$1;
(statearr_25804_25983[(2)] = inst_25680);

(statearr_25804_25983[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (17))){
var inst_25397 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25397)){
var statearr_25805_25984 = state_25702__$1;
(statearr_25805_25984[(1)] = (21));

} else {
var statearr_25806_25985 = state_25702__$1;
(statearr_25806_25985[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (3))){
var inst_25700 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25702__$1,inst_25700);
} else {
if((state_val_25703 === (12))){
var inst_25367 = (state_25702[(34)]);
var state_25702__$1 = state_25702;
var statearr_25807_25986 = state_25702__$1;
(statearr_25807_25986[(2)] = inst_25367);

(statearr_25807_25986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (2))){
var inst_25361 = (state_25702[(33)]);
var _ = (function (){var statearr_25808 = state_25702;
(statearr_25808[(4)] = cljs.core.cons.call(null,(5),(state_25702[(4)])));

return statearr_25808;
})();
var inst_25361__$1 = select;
var state_25702__$1 = (function (){var statearr_25809 = state_25702;
(statearr_25809[(33)] = inst_25361__$1);

return statearr_25809;
})();
if(cljs.core.truth_(inst_25361__$1)){
var statearr_25810_25987 = state_25702__$1;
(statearr_25810_25987[(1)] = (6));

} else {
var statearr_25811_25988 = state_25702__$1;
(statearr_25811_25988[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (66))){
var inst_25512 = (state_25702[(2)]);
var inst_25513 = fluree.db.util.async.throw_err.call(null,inst_25512);
var state_25702__$1 = state_25702;
var statearr_25812_25989 = state_25702__$1;
(statearr_25812_25989[(2)] = inst_25513);

(statearr_25812_25989[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (107))){
var inst_25631 = (state_25702[(35)]);
var inst_25631__$1 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25813 = state_25702;
(statearr_25813[(35)] = inst_25631__$1);

return statearr_25813;
})();
if(cljs.core.truth_(inst_25631__$1)){
var statearr_25814_25990 = state_25702__$1;
(statearr_25814_25990[(1)] = (112));

} else {
var statearr_25815_25991 = state_25702__$1;
(statearr_25815_25991[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (23))){
var inst_25380 = (state_25702[(36)]);
var inst_25405 = (state_25702[(20)]);
var inst_25402 = (state_25702[(2)]);
var inst_25403 = cljs.core.get.call(null,inst_25402,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25404 = cljs.core.get.call(null,inst_25402,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25405__$1 = cljs.core.get.call(null,inst_25402,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25406 = cljs.core.get.call(null,inst_25402,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25407 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25380,opts_SINGLEQUOTE__SINGLEQUOTE_);
var inst_25408 = (inst_25405__$1 == null);
var inst_25409 = cljs.core.not.call(null,inst_25408);
var state_25702__$1 = (function (){var statearr_25816 = state_25702;
(statearr_25816[(20)] = inst_25405__$1);

(statearr_25816[(14)] = inst_25406);

(statearr_25816[(12)] = inst_25404);

(statearr_25816[(21)] = inst_25407);

(statearr_25816[(13)] = inst_25403);

return statearr_25816;
})();
if(inst_25409){
var statearr_25817_25992 = state_25702__$1;
(statearr_25817_25992[(1)] = (24));

} else {
var statearr_25818_25993 = state_25702__$1;
(statearr_25818_25993[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (47))){
var state_25702__$1 = state_25702;
var statearr_25819_25994 = state_25702__$1;
(statearr_25819_25994[(2)] = null);

(statearr_25819_25994[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (35))){
var inst_25440 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25820_25995 = state_25702__$1;
(statearr_25820_25995[(2)] = inst_25440);

(statearr_25820_25995[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (127))){
var inst_25684 = (state_25702[(24)]);
var inst_25683 = (state_25702[(2)]);
var inst_25684__$1 = selectOne;
var state_25702__$1 = (function (){var statearr_25821 = state_25702;
(statearr_25821[(24)] = inst_25684__$1);

(statearr_25821[(17)] = inst_25683);

return statearr_25821;
})();
if(cljs.core.truth_(inst_25684__$1)){
var statearr_25822_25996 = state_25702__$1;
(statearr_25822_25996[(1)] = (128));

} else {
var statearr_25823_25997 = state_25702__$1;
(statearr_25823_25997[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (82))){
var inst_25406 = (state_25702[(14)]);
var inst_25404 = (state_25702[(12)]);
var inst_25547 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25548 = [inst_25404,inst_25406];
var inst_25549 = cljs.core.PersistentHashMap.fromArrays(inst_25547,inst_25548);
var state_25702__$1 = state_25702;
var statearr_25824_25998 = state_25702__$1;
(statearr_25824_25998[(2)] = inst_25549);

(statearr_25824_25998[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (76))){
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25535 = (state_25702[(2)]);
var inst_25536 = fluree.db.util.async.throw_err.call(null,inst_25535);
var inst_25537 = fluree.db.query.fql.flake_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25536);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(77),inst_25537);
} else {
if((state_val_25703 === (97))){
var inst_25599 = from;
var inst_25600 = cljs.core.seq.call(null,inst_25599);
var inst_25601 = cljs.core.first.call(null,inst_25600);
var inst_25602 = cljs.core.next.call(null,inst_25600);
var inst_25603 = cljs.core.PersistentVector.EMPTY;
var inst_25604 = inst_25599;
var inst_25605 = inst_25603;
var state_25702__$1 = (function (){var statearr_25825 = state_25702;
(statearr_25825[(37)] = inst_25602);

(statearr_25825[(29)] = inst_25604);

(statearr_25825[(38)] = inst_25601);

(statearr_25825[(22)] = inst_25605);

return statearr_25825;
})();
var statearr_25826_25999 = state_25702__$1;
(statearr_25826_25999[(2)] = null);

(statearr_25826_25999[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (19))){
var state_25702__$1 = state_25702;
var statearr_25827_26000 = state_25702__$1;
(statearr_25827_26000[(2)] = false);

(statearr_25827_26000[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (57))){
var inst_25481 = (state_25702[(26)]);
var state_25702__$1 = state_25702;
var statearr_25828_26001 = state_25702__$1;
(statearr_25828_26001[(2)] = inst_25481);

(statearr_25828_26001[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (68))){
var state_25702__$1 = state_25702;
var statearr_25829_26002 = state_25702__$1;
(statearr_25829_26002[(2)] = false);

(statearr_25829_26002[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (11))){
var inst_25378 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25830_26003 = state_25702__$1;
(statearr_25830_26003[(2)] = inst_25378);

(statearr_25830_26003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (115))){
var inst_25654 = (state_25702[(2)]);
var inst_25655 = fluree.db.util.async.throw_err.call(null,inst_25654);
var state_25702__$1 = state_25702;
var statearr_25832_26004 = state_25702__$1;
(statearr_25832_26004[(2)] = inst_25655);

(statearr_25832_26004[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (9))){
var inst_25364 = (state_25702[(18)]);
var state_25702__$1 = state_25702;
var statearr_25833_26005 = state_25702__$1;
(statearr_25833_26005[(2)] = inst_25364);

(statearr_25833_26005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (5))){
var _ = (function (){var statearr_25834 = state_25702;
(statearr_25834[(4)] = cljs.core.rest.call(null,(state_25702[(4)])));

return statearr_25834;
})();
var state_25702__$1 = state_25702;
var ex25831 = (state_25702__$1[(2)]);
var statearr_25835_26006 = state_25702__$1;
(statearr_25835_26006[(5)] = ex25831);


if((ex25831 instanceof Error)){
var statearr_25836_26007 = state_25702__$1;
(statearr_25836_26007[(1)] = (4));

(statearr_25836_26007[(5)] = null);

} else {
throw ex25831;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (112))){
var inst_25631 = (state_25702[(35)]);
var inst_25605 = (state_25702[(22)]);
var inst_25633 = cljs.core.conj.call(null,inst_25605,inst_25631);
var state_25702__$1 = state_25702;
var statearr_25837_26008 = state_25702__$1;
(statearr_25837_26008[(2)] = inst_25633);

(statearr_25837_26008[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (83))){
var inst_25551 = (state_25702[(2)]);
var inst_25552 = fluree.db.query.range.collection.call(null,db,from,inst_25551);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(84),inst_25552);
} else {
if((state_val_25703 === (14))){
var inst_25376 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25838_26009 = state_25702__$1;
(statearr_25838_26009[(2)] = inst_25376);

(statearr_25838_26009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (45))){
var inst_25403 = (state_25702[(13)]);
var inst_25460 = (state_25702[(2)]);
var inst_25461 = fluree.db.util.async.throw_err.call(null,inst_25460);
var state_25702__$1 = (function (){var statearr_25839 = state_25702;
(statearr_25839[(39)] = inst_25461);

return statearr_25839;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25840_26010 = state_25702__$1;
(statearr_25840_26010[(1)] = (47));

} else {
var statearr_25841_26011 = state_25702__$1;
(statearr_25841_26011[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (53))){
var inst_25481 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_25702__$1 = (function (){var statearr_25842 = state_25702;
(statearr_25842[(26)] = inst_25481);

return statearr_25842;
})();
if(cljs.core.truth_(fuel)){
var statearr_25843_26012 = state_25702__$1;
(statearr_25843_26012[(1)] = (56));

} else {
var statearr_25844_26013 = state_25702__$1;
(statearr_25844_26013[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (78))){
var inst_25403 = (state_25702[(13)]);
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25403)){
var statearr_25845_26014 = state_25702__$1;
(statearr_25845_26014[(1)] = (81));

} else {
var statearr_25846_26015 = state_25702__$1;
(statearr_25846_26015[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (132))){
var inst_25683 = (state_25702[(17)]);
var state_25702__$1 = state_25702;
var statearr_25847_26016 = state_25702__$1;
(statearr_25847_26016[(2)] = inst_25683);

(statearr_25847_26016[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (26))){
var inst_25403 = (state_25702[(13)]);
var inst_25414 = (state_25702[(2)]);
var inst_25415 = cljs.core.PersistentHashMap.EMPTY;
var inst_25416 = cljs.core.volatile_BANG_.call(null,inst_25415);
var state_25702__$1 = (function (){var statearr_25848 = state_25702;
(statearr_25848[(9)] = inst_25414);

(statearr_25848[(10)] = inst_25416);

return statearr_25848;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25849_26017 = state_25702__$1;
(statearr_25849_26017[(1)] = (27));

} else {
var statearr_25850_26018 = state_25702__$1;
(statearr_25850_26018[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (123))){
var state_25702__$1 = state_25702;
var statearr_25851_26019 = state_25702__$1;
(statearr_25851_26019[(2)] = null);

(statearr_25851_26019[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (16))){
var state_25702__$1 = state_25702;
var statearr_25852_26020 = state_25702__$1;
(statearr_25852_26020[(2)] = false);

(statearr_25852_26020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (133))){
var inst_25697 = (state_25702[(2)]);
var _ = (function (){var statearr_25853 = state_25702;
(statearr_25853[(4)] = cljs.core.rest.call(null,(state_25702[(4)])));

return statearr_25853;
})();
var state_25702__$1 = state_25702;
var statearr_25854_26021 = state_25702__$1;
(statearr_25854_26021[(2)] = inst_25697);

(statearr_25854_26021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (81))){
var inst_25545 = cljs.core.PersistentHashMap.EMPTY;
var state_25702__$1 = state_25702;
var statearr_25855_26022 = state_25702__$1;
(statearr_25855_26022[(2)] = inst_25545);

(statearr_25855_26022[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (120))){
var inst_25406 = (state_25702[(14)]);
var state_25702__$1 = state_25702;
var statearr_25856_26023 = state_25702__$1;
(statearr_25856_26023[(2)] = inst_25406);

(statearr_25856_26023[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (79))){
var inst_25561 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_25702__$1 = state_25702;
if(inst_25561){
var statearr_25857_26024 = state_25702__$1;
(statearr_25857_26024[(1)] = (86));

} else {
var statearr_25858_26025 = state_25702__$1;
(statearr_25858_26025[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (38))){
var inst_25438 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25859_26026 = state_25702__$1;
(statearr_25859_26026[(2)] = inst_25438);

(statearr_25859_26026[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (126))){
var inst_25678 = (state_25702[(28)]);
var state_25702__$1 = state_25702;
var statearr_25860_26027 = state_25702__$1;
(statearr_25860_26027[(2)] = inst_25678);

(statearr_25860_26027[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (98))){
var state_25702__$1 = state_25702;
var statearr_25861_26028 = state_25702__$1;
(statearr_25861_26028[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (124))){
var inst_25666 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25863_26029 = state_25702__$1;
(statearr_25863_26029[(2)] = inst_25666);

(statearr_25863_26029[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (87))){
var inst_25588 = cljs.core.sequential_QMARK_.call(null,from);
var inst_25589 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25590 = ((inst_25588) && (inst_25589));
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25590)){
var statearr_25864_26030 = state_25702__$1;
(statearr_25864_26030[(1)] = (97));

} else {
var statearr_25865_26031 = state_25702__$1;
(statearr_25865_26031[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (30))){
var inst_25403 = (state_25702[(13)]);
var inst_25420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25421 = cljs.core.second.call(null,inst_25403);
var inst_25422 = cljs.core.first.call(null,inst_25403);
var inst_25423 = [inst_25421,inst_25422];
var inst_25424 = (new cljs.core.PersistentVector(null,2,(5),inst_25420,inst_25423,null));
var state_25702__$1 = state_25702;
var statearr_25866_26032 = state_25702__$1;
(statearr_25866_26032[(2)] = inst_25424);

(statearr_25866_26032[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (73))){
var inst_25526 = cljs.core.PersistentHashMap.EMPTY;
var state_25702__$1 = state_25702;
var statearr_25867_26033 = state_25702__$1;
(statearr_25867_26033[(2)] = inst_25526);

(statearr_25867_26033[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (96))){
var inst_25579 = (state_25702[(32)]);
var inst_25586 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25868 = state_25702;
(statearr_25868[(40)] = inst_25586);

return statearr_25868;
})();
var statearr_25869_26034 = state_25702__$1;
(statearr_25869_26034[(2)] = inst_25579);

(statearr_25869_26034[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (10))){
var inst_25367 = (state_25702[(34)]);
var inst_25367__$1 = selectDistinct;
var state_25702__$1 = (function (){var statearr_25870 = state_25702;
(statearr_25870[(34)] = inst_25367__$1);

return statearr_25870;
})();
if(cljs.core.truth_(inst_25367__$1)){
var statearr_25871_26035 = state_25702__$1;
(statearr_25871_26035[(1)] = (12));

} else {
var statearr_25872_26036 = state_25702__$1;
(statearr_25872_26036[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (18))){
var state_25702__$1 = state_25702;
var statearr_25873_26037 = state_25702__$1;
(statearr_25873_26037[(2)] = true);

(statearr_25873_26037[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (105))){
var inst_25611 = (state_25702[(15)]);
var state_25702__$1 = state_25702;
var statearr_25874_26038 = state_25702__$1;
(statearr_25874_26038[(2)] = inst_25611);

(statearr_25874_26038[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (52))){
var inst_25461 = (state_25702[(39)]);
var inst_25465 = (state_25702[(41)]);
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25469 = (state_25702[(2)]);
var inst_25470 = fluree.db.query.fql.subject_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25461,inst_25465,inst_25469);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(46),inst_25470);
} else {
if((state_val_25703 === (114))){
var inst_25612 = (state_25702[(30)]);
var inst_25636 = (state_25702[(2)]);
var inst_25604 = inst_25612;
var inst_25605 = inst_25636;
var state_25702__$1 = (function (){var statearr_25875 = state_25702;
(statearr_25875[(29)] = inst_25604);

(statearr_25875[(22)] = inst_25605);

return statearr_25875;
})();
var statearr_25876_26039 = state_25702__$1;
(statearr_25876_26039[(2)] = null);

(statearr_25876_26039[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (67))){
var inst_25517 = ["_tx",null,"_block",null];
var inst_25518 = (new cljs.core.PersistentArrayMap(null,2,inst_25517,null));
var inst_25519 = (new cljs.core.PersistentHashSet(null,inst_25518,null));
var inst_25520 = inst_25519.call(null,from);
var state_25702__$1 = state_25702;
var statearr_25877_26040 = state_25702__$1;
(statearr_25877_26040[(2)] = inst_25520);

(statearr_25877_26040[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (71))){
var inst_25542 = typeof from === 'string';
var state_25702__$1 = state_25702;
if(cljs.core.truth_(inst_25542)){
var statearr_25878_26041 = state_25702__$1;
(statearr_25878_26041[(1)] = (78));

} else {
var statearr_25879_26042 = state_25702__$1;
(statearr_25879_26042[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (42))){
var state_25702__$1 = state_25702;
var statearr_25880_26043 = state_25702__$1;
(statearr_25880_26043[(2)] = from);

(statearr_25880_26043[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (80))){
var inst_25672 = (state_25702[(2)]);
var state_25702__$1 = state_25702;
var statearr_25881_26044 = state_25702__$1;
(statearr_25881_26044[(2)] = inst_25672);

(statearr_25881_26044[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (37))){
var state_25702__$1 = state_25702;
var statearr_25882_26045 = state_25702__$1;
(statearr_25882_26045[(2)] = null);

(statearr_25882_26045[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (63))){
var inst_25406 = (state_25702[(14)]);
var inst_25404 = (state_25702[(12)]);
var inst_25497 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25498 = [inst_25404,inst_25406];
var inst_25499 = cljs.core.PersistentHashMap.fromArrays(inst_25497,inst_25498);
var state_25702__$1 = state_25702;
var statearr_25883_26046 = state_25702__$1;
(statearr_25883_26046[(2)] = inst_25499);

(statearr_25883_26046[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (94))){
var inst_25581 = cljs.core._deref.call(null,fuel);
var inst_25582 = (inst_25581 + (1));
var inst_25583 = cljs.core._vreset_BANG_.call(null,fuel,inst_25582);
var state_25702__$1 = state_25702;
var statearr_25884_26047 = state_25702__$1;
(statearr_25884_26047[(2)] = inst_25583);

(statearr_25884_26047[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (8))){
var inst_25381 = (state_25702[(23)]);
var inst_25380 = (state_25702[(2)]);
var inst_25381__$1 = opts_SINGLEQUOTE__SINGLEQUOTE_;
var inst_25383 = (inst_25381__$1 == null);
var inst_25384 = cljs.core.not.call(null,inst_25383);
var state_25702__$1 = (function (){var statearr_25885 = state_25702;
(statearr_25885[(36)] = inst_25380);

(statearr_25885[(23)] = inst_25381__$1);

return statearr_25885;
})();
if(inst_25384){
var statearr_25886_26048 = state_25702__$1;
(statearr_25886_26048[(1)] = (15));

} else {
var statearr_25887_26049 = state_25702__$1;
(statearr_25887_26049[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (49))){
var inst_25403 = (state_25702[(13)]);
var inst_25465 = (state_25702[(2)]);
var state_25702__$1 = (function (){var statearr_25888 = state_25702;
(statearr_25888[(41)] = inst_25465);

return statearr_25888;
})();
if(cljs.core.truth_(inst_25403)){
var statearr_25889_26050 = state_25702__$1;
(statearr_25889_26050[(1)] = (50));

} else {
var statearr_25890_26051 = state_25702__$1;
(statearr_25890_26051[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25703 === (84))){
var inst_25414 = (state_25702[(9)]);
var inst_25416 = (state_25702[(10)]);
var inst_25554 = (state_25702[(2)]);
var inst_25555 = fluree.db.util.async.throw_err.call(null,inst_25554);
var inst_25556 = fluree.db.query.fql.flake_select.call(null,db,inst_25416,fuel,max_fuel,inst_25414,inst_25555);
var state_25702__$1 = state_25702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25702__$1,(85),inst_25556);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2454__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2454__auto____0 = (function (){
var statearr_25891 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25891[(0)] = fluree$db$query$fql$query_$_state_machine__2454__auto__);

(statearr_25891[(1)] = (1));

return statearr_25891;
});
var fluree$db$query$fql$query_$_state_machine__2454__auto____1 = (function (state_25702){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_25702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e25892){var ex__2457__auto__ = e25892;
var statearr_25893_26052 = state_25702;
(statearr_25893_26052[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_25702[(4)]))){
var statearr_25894_26053 = state_25702;
(statearr_25894_26053[(1)] = cljs.core.first.call(null,(state_25702[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26054 = state_25702;
state_25702 = G__26054;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2454__auto__ = function(state_25702){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2454__auto____1.call(this,state_25702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2454__auto____0;
fluree$db$query$fql$query_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2454__auto____1;
return fluree$db$query$fql$query_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_25895 = f__2477__auto__.call(null);
(statearr_25895[(6)] = c__2476__auto__);

return statearr_25895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}

});
