// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_18060){
var state_val_18061 = (state_18060[(1)]);
if((state_val_18061 === (1))){
var state_18060__$1 = state_18060;
var statearr_18062_18076 = state_18060__$1;
(statearr_18062_18076[(2)] = null);

(statearr_18062_18076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18061 === (2))){
var _ = (function (){var statearr_18063 = state_18060;
(statearr_18063[(4)] = cljs.core.cons.call(null,(5),(state_18060[(4)])));

return statearr_18063;
})();
var inst_18051 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_18060__$1 = state_18060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18060__$1,(6),inst_18051);
} else {
if((state_val_18061 === (3))){
var inst_18058 = (state_18060[(2)]);
var state_18060__$1 = state_18060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18060__$1,inst_18058);
} else {
if((state_val_18061 === (4))){
var inst_18045 = (state_18060[(2)]);
var state_18060__$1 = state_18060;
var statearr_18065_18077 = state_18060__$1;
(statearr_18065_18077[(2)] = inst_18045);

(statearr_18065_18077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18061 === (5))){
var _ = (function (){var statearr_18066 = state_18060;
(statearr_18066[(4)] = cljs.core.rest.call(null,(state_18060[(4)])));

return statearr_18066;
})();
var state_18060__$1 = state_18060;
var ex18064 = (state_18060__$1[(2)]);
var statearr_18067_18078 = state_18060__$1;
(statearr_18067_18078[(5)] = ex18064);


if((ex18064 instanceof Error)){
var statearr_18068_18079 = state_18060__$1;
(statearr_18068_18079[(1)] = (4));

(statearr_18068_18079[(5)] = null);

} else {
throw ex18064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18061 === (6))){
var inst_18053 = (state_18060[(2)]);
var inst_18054 = fluree.db.util.async.throw_err.call(null,inst_18053);
var inst_18055 = cljs.core.keyword.call(null,inst_18054);
var _ = (function (){var statearr_18069 = state_18060;
(statearr_18069[(4)] = cljs.core.rest.call(null,(state_18060[(4)])));

return statearr_18069;
})();
var state_18060__$1 = state_18060;
var statearr_18070_18080 = state_18060__$1;
(statearr_18070_18080[(2)] = inst_18055);

(statearr_18070_18080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____0 = (function (){
var statearr_18071 = [null,null,null,null,null,null,null];
(statearr_18071[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__);

(statearr_18071[(1)] = (1));

return statearr_18071;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____1 = (function (state_18060){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_18060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18072){var ex__2457__auto__ = e18072;
var statearr_18073_18081 = state_18060;
(statearr_18073_18081[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_18060[(4)]))){
var statearr_18074_18082 = state_18060;
(statearr_18074_18082[(1)] = cljs.core.first.call(null,(state_18060[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18083 = state_18060;
state_18060 = G__18083;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__ = function(state_18060){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____1.call(this,state_18060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18075 = f__2477__auto__.call(null);
(statearr_18075[(6)] = c__2476__auto__);

return statearr_18075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_18115){
var state_val_18116 = (state_18115[(1)]);
if((state_val_18116 === (7))){
var inst_18099 = (state_18115[(7)]);
var inst_18101 = cljs.core.empty_QMARK_.call(null,inst_18099);
var inst_18102 = (!(inst_18101));
var state_18115__$1 = state_18115;
var statearr_18117_18141 = state_18115__$1;
(statearr_18117_18141[(2)] = inst_18102);

(statearr_18117_18141[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (1))){
var state_18115__$1 = state_18115;
var statearr_18118_18142 = state_18115__$1;
(statearr_18118_18142[(2)] = null);

(statearr_18118_18142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (4))){
var inst_18085 = (state_18115[(2)]);
var state_18115__$1 = state_18115;
var statearr_18119_18143 = state_18115__$1;
(statearr_18119_18143[(2)] = inst_18085);

(statearr_18119_18143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (6))){
var inst_18099 = (state_18115[(7)]);
var inst_18091 = (state_18115[(8)]);
var inst_18097 = (state_18115[(2)]);
var inst_18098 = fluree.db.util.async.throw_err.call(null,inst_18097);
var inst_18099__$1 = cljs.core.map.call(null,inst_18091,inst_18098);
var state_18115__$1 = (function (){var statearr_18120 = state_18115;
(statearr_18120[(7)] = inst_18099__$1);

return statearr_18120;
})();
if(cljs.core.truth_(inst_18099__$1)){
var statearr_18121_18144 = state_18115__$1;
(statearr_18121_18144[(1)] = (7));

} else {
var statearr_18122_18145 = state_18115__$1;
(statearr_18122_18145[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (3))){
var inst_18113 = (state_18115[(2)]);
var state_18115__$1 = state_18115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18115__$1,inst_18113);
} else {
if((state_val_18116 === (12))){
var inst_18110 = (state_18115[(2)]);
var _ = (function (){var statearr_18123 = state_18115;
(statearr_18123[(4)] = cljs.core.rest.call(null,(state_18115[(4)])));

return statearr_18123;
})();
var state_18115__$1 = state_18115;
var statearr_18124_18146 = state_18115__$1;
(statearr_18124_18146[(2)] = inst_18110);

(statearr_18124_18146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (2))){
var _ = (function (){var statearr_18125 = state_18115;
(statearr_18125[(4)] = cljs.core.cons.call(null,(5),(state_18115[(4)])));

return statearr_18125;
})();
var inst_18091 = (function (){return (function (p1__18084_SHARP_){
return p1__18084_SHARP_.o;
});
})();
var inst_18092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18093 = [pred_id];
var inst_18094 = (new cljs.core.PersistentVector(null,1,(5),inst_18092,inst_18093,null));
var inst_18095 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_18094);
var state_18115__$1 = (function (){var statearr_18126 = state_18115;
(statearr_18126[(8)] = inst_18091);

return statearr_18126;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18115__$1,(6),inst_18095);
} else {
if((state_val_18116 === (11))){
var state_18115__$1 = state_18115;
var statearr_18128_18147 = state_18115__$1;
(statearr_18128_18147[(2)] = true);

(statearr_18128_18147[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (9))){
var inst_18105 = (state_18115[(2)]);
var state_18115__$1 = state_18115;
if(cljs.core.truth_(inst_18105)){
var statearr_18129_18148 = state_18115__$1;
(statearr_18129_18148[(1)] = (10));

} else {
var statearr_18130_18149 = state_18115__$1;
(statearr_18130_18149[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (5))){
var _ = (function (){var statearr_18131 = state_18115;
(statearr_18131[(4)] = cljs.core.rest.call(null,(state_18115[(4)])));

return statearr_18131;
})();
var state_18115__$1 = state_18115;
var ex18127 = (state_18115__$1[(2)]);
var statearr_18132_18150 = state_18115__$1;
(statearr_18132_18150[(5)] = ex18127);


if((ex18127 instanceof Error)){
var statearr_18133_18151 = state_18115__$1;
(statearr_18133_18151[(1)] = (4));

(statearr_18133_18151[(5)] = null);

} else {
throw ex18127;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (10))){
var inst_18099 = (state_18115[(7)]);
var inst_18107 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_18099);
var state_18115__$1 = state_18115;
var statearr_18134_18152 = state_18115__$1;
(statearr_18134_18152[(2)] = inst_18107);

(statearr_18134_18152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18116 === (8))){
var inst_18099 = (state_18115[(7)]);
var state_18115__$1 = state_18115;
var statearr_18135_18153 = state_18115__$1;
(statearr_18135_18153[(2)] = inst_18099);

(statearr_18135_18153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_18136 = [null,null,null,null,null,null,null,null,null];
(statearr_18136[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__);

(statearr_18136[(1)] = (1));

return statearr_18136;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____1 = (function (state_18115){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_18115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18137){var ex__2457__auto__ = e18137;
var statearr_18138_18154 = state_18115;
(statearr_18138_18154[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_18115[(4)]))){
var statearr_18139_18155 = state_18115;
(statearr_18139_18155[(1)] = cljs.core.first.call(null,(state_18115[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18156 = state_18115;
state_18115 = G__18156;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__ = function(state_18115){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____1.call(this,state_18115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18140 = f__2477__auto__.call(null);
(statearr_18140[(6)] = c__2476__auto__);

return statearr_18140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_18233){
var state_val_18234 = (state_18233[(1)]);
if((state_val_18234 === (7))){
var inst_18228 = (state_18233[(2)]);
var _ = (function (){var statearr_18235 = state_18233;
(statearr_18235[(4)] = cljs.core.rest.call(null,(state_18233[(4)])));

return statearr_18235;
})();
var state_18233__$1 = state_18233;
var statearr_18236_18268 = state_18233__$1;
(statearr_18236_18268[(2)] = inst_18228);

(statearr_18236_18268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (1))){
var state_18233__$1 = state_18233;
var statearr_18237_18269 = state_18233__$1;
(statearr_18237_18269[(2)] = null);

(statearr_18237_18269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (4))){
var inst_18159 = (state_18233[(2)]);
var state_18233__$1 = state_18233;
var statearr_18238_18270 = state_18233__$1;
(statearr_18238_18270[(2)] = inst_18159);

(statearr_18238_18270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (15))){
var inst_18183 = (state_18233[(7)]);
var inst_18209 = (state_18233[(8)]);
var inst_18189 = (state_18233[(9)]);
var inst_18196 = (state_18233[(10)]);
var inst_18211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18212 = inst_18189.s;
var inst_18213 = [inst_18212,inst_18196,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_18214 = (new cljs.core.PersistentVector(null,3,(5),inst_18211,inst_18213,null));
var inst_18215 = cljs.core.assoc_in.call(null,inst_18183,inst_18214,inst_18209);
var state_18233__$1 = state_18233;
var statearr_18239_18271 = state_18233__$1;
(statearr_18239_18271[(2)] = inst_18215);

(statearr_18239_18271[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (13))){
var inst_18198 = (state_18233[(11)]);
var inst_18209 = (state_18233[(2)]);
var state_18233__$1 = (function (){var statearr_18240 = state_18233;
(statearr_18240[(8)] = inst_18209);

return statearr_18240;
})();
if(cljs.core.truth_(inst_18198)){
var statearr_18241_18272 = state_18233__$1;
(statearr_18241_18272[(1)] = (15));

} else {
var statearr_18242_18273 = state_18233__$1;
(statearr_18242_18273[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (6))){
var inst_18182 = (state_18233[(12)]);
var inst_18189 = (state_18233[(9)]);
var inst_18188 = cljs.core.seq.call(null,inst_18182);
var inst_18189__$1 = cljs.core.first.call(null,inst_18188);
var inst_18190 = cljs.core.next.call(null,inst_18188);
var inst_18191 = cljs.core.not.call(null,inst_18189__$1);
var state_18233__$1 = (function (){var statearr_18243 = state_18233;
(statearr_18243[(9)] = inst_18189__$1);

(statearr_18243[(13)] = inst_18190);

return statearr_18243;
})();
if(inst_18191){
var statearr_18244_18274 = state_18233__$1;
(statearr_18244_18274[(1)] = (8));

} else {
var statearr_18245_18275 = state_18233__$1;
(statearr_18245_18275[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (17))){
var inst_18190 = (state_18233[(13)]);
var inst_18223 = (state_18233[(2)]);
var inst_18182 = inst_18190;
var inst_18183 = inst_18223;
var state_18233__$1 = (function (){var statearr_18246 = state_18233;
(statearr_18246[(7)] = inst_18183);

(statearr_18246[(12)] = inst_18182);

return statearr_18246;
})();
var statearr_18247_18276 = state_18233__$1;
(statearr_18247_18276[(2)] = null);

(statearr_18247_18276[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (3))){
var inst_18231 = (state_18233[(2)]);
var state_18233__$1 = state_18233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18233__$1,inst_18231);
} else {
if((state_val_18234 === (12))){
var inst_18189 = (state_18233[(9)]);
var inst_18207 = inst_18189.o;
var state_18233__$1 = state_18233;
var statearr_18248_18277 = state_18233__$1;
(statearr_18248_18277[(2)] = inst_18207);

(statearr_18248_18277[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (2))){
var _ = (function (){var statearr_18249 = state_18233;
(statearr_18249[(4)] = cljs.core.cons.call(null,(5),(state_18233[(4)])));

return statearr_18249;
})();
var inst_18165 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_18166 = cljs.core.PersistentHashSet.EMPTY;
var inst_18167 = cljs.core.vals.call(null,tempids);
var inst_18168 = cljs.core.into.call(null,inst_18166,inst_18167);
var inst_18169 = (function (){var pred_flakes = inst_18165;
var is_new_QMARK_ = inst_18168;
return (function (p1__18157_SHARP_,p2__18158_SHARP_){
return cljs.core.assoc_in.call(null,p1__18157_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__18158_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__18158_SHARP_.s)));
});
})();
var inst_18170 = cljs.core.PersistentHashMap.EMPTY;
var inst_18171 = cljs.core.reduce.call(null,inst_18169,inst_18170,inst_18165);
var inst_18179 = cljs.core.seq.call(null,inst_18165);
var inst_18180 = cljs.core.first.call(null,inst_18179);
var inst_18181 = cljs.core.next.call(null,inst_18179);
var inst_18182 = inst_18165;
var inst_18183 = inst_18171;
var state_18233__$1 = (function (){var statearr_18250 = state_18233;
(statearr_18250[(7)] = inst_18183);

(statearr_18250[(14)] = inst_18180);

(statearr_18250[(12)] = inst_18182);

(statearr_18250[(15)] = inst_18181);

return statearr_18250;
})();
var statearr_18251_18278 = state_18233__$1;
(statearr_18251_18278[(2)] = null);

(statearr_18251_18278[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (11))){
var inst_18189 = (state_18233[(9)]);
var inst_18201 = inst_18189.o;
var inst_18202 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_18201,db);
var state_18233__$1 = state_18233;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18233__$1,(14),inst_18202);
} else {
if((state_val_18234 === (9))){
var inst_18189 = (state_18233[(9)]);
var inst_18196 = (state_18233[(10)]);
var inst_18194 = inst_18189.p;
var inst_18195 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18194);
var inst_18196__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_18195);
var inst_18197 = inst_18189.op;
var inst_18198 = inst_18197 === false;
var inst_18199 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_18196__$1);
var state_18233__$1 = (function (){var statearr_18253 = state_18233;
(statearr_18253[(11)] = inst_18198);

(statearr_18253[(10)] = inst_18196__$1);

return statearr_18253;
})();
if(inst_18199){
var statearr_18254_18279 = state_18233__$1;
(statearr_18254_18279[(1)] = (11));

} else {
var statearr_18255_18280 = state_18233__$1;
(statearr_18255_18280[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (5))){
var _ = (function (){var statearr_18256 = state_18233;
(statearr_18256[(4)] = cljs.core.rest.call(null,(state_18233[(4)])));

return statearr_18256;
})();
var state_18233__$1 = state_18233;
var ex18252 = (state_18233__$1[(2)]);
var statearr_18257_18281 = state_18233__$1;
(statearr_18257_18281[(5)] = ex18252);


if((ex18252 instanceof Error)){
var statearr_18258_18282 = state_18233__$1;
(statearr_18258_18282[(1)] = (4));

(statearr_18258_18282[(5)] = null);

} else {
throw ex18252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (14))){
var inst_18204 = (state_18233[(2)]);
var inst_18205 = fluree.db.util.async.throw_err.call(null,inst_18204);
var state_18233__$1 = state_18233;
var statearr_18259_18283 = state_18233__$1;
(statearr_18259_18283[(2)] = inst_18205);

(statearr_18259_18283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (16))){
var inst_18183 = (state_18233[(7)]);
var inst_18209 = (state_18233[(8)]);
var inst_18189 = (state_18233[(9)]);
var inst_18196 = (state_18233[(10)]);
var inst_18217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18218 = inst_18189.s;
var inst_18219 = [inst_18218,inst_18196,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_18220 = (new cljs.core.PersistentVector(null,3,(5),inst_18217,inst_18219,null));
var inst_18221 = cljs.core.assoc_in.call(null,inst_18183,inst_18220,inst_18209);
var state_18233__$1 = state_18233;
var statearr_18260_18284 = state_18233__$1;
(statearr_18260_18284[(2)] = inst_18221);

(statearr_18260_18284[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (10))){
var inst_18226 = (state_18233[(2)]);
var state_18233__$1 = state_18233;
var statearr_18261_18285 = state_18233__$1;
(statearr_18261_18285[(2)] = inst_18226);

(statearr_18261_18285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18234 === (8))){
var inst_18183 = (state_18233[(7)]);
var state_18233__$1 = state_18233;
var statearr_18262_18286 = state_18233__$1;
(statearr_18262_18286[(2)] = inst_18183);

(statearr_18262_18286[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____0 = (function (){
var statearr_18263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18263[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__);

(statearr_18263[(1)] = (1));

return statearr_18263;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____1 = (function (state_18233){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_18233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18264){var ex__2457__auto__ = e18264;
var statearr_18265_18287 = state_18233;
(statearr_18265_18287[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_18233[(4)]))){
var statearr_18266_18288 = state_18233;
(statearr_18266_18288[(1)] = cljs.core.first.call(null,(state_18233[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18289 = state_18233;
state_18233 = G__18289;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__ = function(state_18233){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____1.call(this,state_18233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18267 = f__2477__auto__.call(null);
(statearr_18267[(6)] = c__2476__auto__);

return statearr_18267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__18291 = arguments.length;
switch (G__18291) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__18294 = arguments.length;
switch (G__18294) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_18603){
var state_val_18604 = (state_18603[(1)]);
if((state_val_18604 === (65))){
var inst_18556 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18605_18777 = state_18603__$1;
(statearr_18605_18777[(2)] = inst_18556);

(statearr_18605_18777[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (70))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18478 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18479 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,2,inst_18478,null);
var inst_18480 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18479,null);
var inst_18481 = inst_18480.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18481)){
var statearr_18606_18778 = state_18603__$1;
(statearr_18606_18778[(1)] = (71));

} else {
var statearr_18607_18779 = state_18603__$1;
(statearr_18607_18779[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (62))){
var inst_18558 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18608_18780 = state_18603__$1;
(statearr_18608_18780[(2)] = inst_18558);

(statearr_18608_18780[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (74))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18488 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18489 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,3,inst_18488,null);
var inst_18490 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18489,null);
var inst_18491 = inst_18490.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18491)){
var statearr_18609_18781 = state_18603__$1;
(statearr_18609_18781[(1)] = (75));

} else {
var statearr_18610_18782 = state_18603__$1;
(statearr_18610_18782[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (110))){
var inst_18590 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18611_18783 = state_18603__$1;
(statearr_18611_18783[(2)] = inst_18590);

(statearr_18611_18783[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (7))){
var inst_18598 = (state_18603[(2)]);
var _ = (function (){var statearr_18612 = state_18603;
(statearr_18612[(4)] = cljs.core.rest.call(null,(state_18603[(4)])));

return statearr_18612;
})();
var state_18603__$1 = state_18603;
var statearr_18613_18784 = state_18603__$1;
(statearr_18613_18784[(2)] = inst_18598);

(statearr_18613_18784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (59))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18464 = (state_18603[(2)]);
var inst_18465__$1 = cljs.core.get.call(null,inst_18464,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_18466__$1 = cljs.core.get.call(null,inst_18464,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_18467 = cljs.core._EQ_.call(null,inst_18466__$1,inst_18465__$1);
var state_18603__$1 = (function (){var statearr_18614 = state_18603;
(statearr_18614[(7)] = inst_18465__$1);

(statearr_18614[(8)] = inst_18466__$1);

return statearr_18614;
})();
if(inst_18467){
var statearr_18615_18785 = state_18603__$1;
(statearr_18615_18785[(1)] = (60));

} else {
var statearr_18616_18786 = state_18603__$1;
(statearr_18616_18786[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (86))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18518 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18519 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,5,inst_18518,null);
var inst_18520 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18519,null);
var inst_18521 = inst_18520.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18521)){
var statearr_18617_18787 = state_18603__$1;
(statearr_18617_18787[(1)] = (87));

} else {
var statearr_18618_18788 = state_18603__$1;
(statearr_18618_18788[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (20))){
var inst_18334 = (state_18603[(9)]);
var inst_18359 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18360 = inst_18359 === true;
var inst_18361 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18362 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18361);
var inst_18363 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_18362);
var inst_18364 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18365 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18364);
var inst_18366 = inst_18365 === true;
var inst_18367 = ((inst_18360) && (inst_18363) && (inst_18366));
var state_18603__$1 = state_18603;
var statearr_18619_18789 = state_18603__$1;
(statearr_18619_18789[(2)] = inst_18367);

(statearr_18619_18789[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (72))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18484 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18620_18790 = state_18603__$1;
(statearr_18620_18790[(2)] = inst_18484);

(statearr_18620_18790[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (58))){
var inst_18443 = (state_18603[(10)]);
var state_18603__$1 = state_18603;
var statearr_18621_18791 = state_18603__$1;
(statearr_18621_18791[(2)] = inst_18443);

(statearr_18621_18791[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (60))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18622_18792 = state_18603__$1;
(statearr_18622_18792[(2)] = inst_18433);

(statearr_18622_18792[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (27))){
var inst_18354 = (state_18603[(12)]);
var state_18603__$1 = state_18603;
var statearr_18623_18793 = state_18603__$1;
(statearr_18623_18793[(2)] = inst_18354);

(statearr_18623_18793[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (1))){
var state_18603__$1 = state_18603;
var statearr_18624_18794 = state_18603__$1;
(statearr_18624_18794[(2)] = null);

(statearr_18624_18794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (69))){
var inst_18551 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18625_18795 = state_18603__$1;
(statearr_18625_18795[(2)] = inst_18551);

(statearr_18625_18795[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (101))){
var inst_18580 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18580)){
var statearr_18626_18796 = state_18603__$1;
(statearr_18626_18796[(1)] = (105));

} else {
var statearr_18627_18797 = state_18603__$1;
(statearr_18627_18797[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (24))){
var inst_18354 = (state_18603[(12)]);
var state_18603__$1 = state_18603;
var statearr_18628_18798 = state_18603__$1;
(statearr_18628_18798[(2)] = inst_18354);

(statearr_18628_18798[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (102))){
var inst_18334 = (state_18603[(9)]);
var inst_18567 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18568 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18567);
var inst_18569 = inst_18568 === true;
var inst_18570 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18571 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18570);
var inst_18572 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_18571);
var inst_18573 = (!(inst_18572));
var inst_18574 = ((inst_18569) && (inst_18573));
var state_18603__$1 = state_18603;
var statearr_18629_18799 = state_18603__$1;
(statearr_18629_18799[(2)] = inst_18574);

(statearr_18629_18799[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (55))){
var state_18603__$1 = state_18603;
var statearr_18630_18800 = state_18603__$1;
(statearr_18630_18800[(2)] = false);

(statearr_18630_18800[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (85))){
var inst_18516 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18631_18801 = state_18603__$1;
(statearr_18631_18801[(2)] = inst_18516);

(statearr_18631_18801[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (39))){
var state_18603__$1 = state_18603;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18632_18802 = state_18603__$1;
(statearr_18632_18802[(1)] = (42));

} else {
var statearr_18633_18803 = state_18603__$1;
(statearr_18633_18803[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (88))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18524 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18634_18804 = state_18603__$1;
(statearr_18634_18804[(2)] = inst_18524);

(statearr_18634_18804[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (46))){
var inst_18434 = (state_18603[(13)]);
var state_18603__$1 = state_18603;
var statearr_18635_18805 = state_18603__$1;
(statearr_18635_18805[(2)] = inst_18434);

(statearr_18635_18805[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (4))){
var inst_18295 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18636_18806 = state_18603__$1;
(statearr_18636_18806[(2)] = inst_18295);

(statearr_18636_18806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (77))){
var inst_18496 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18637_18807 = state_18603__$1;
(statearr_18637_18807[(2)] = inst_18496);

(statearr_18637_18807[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (106))){
var inst_18561 = (state_18603[(14)]);
var state_18603__$1 = state_18603;
var statearr_18638_18808 = state_18603__$1;
(statearr_18638_18808[(2)] = inst_18561);

(statearr_18638_18808[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (95))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18639_18809 = state_18603__$1;
(statearr_18639_18809[(2)] = inst_18433);

(statearr_18639_18809[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (54))){
var state_18603__$1 = state_18603;
var statearr_18640_18810 = state_18603__$1;
(statearr_18640_18810[(2)] = true);

(statearr_18640_18810[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (92))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18534 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18641_18811 = state_18603__$1;
(statearr_18641_18811[(2)] = inst_18534);

(statearr_18641_18811[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (104))){
var inst_18577 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18642_18812 = state_18603__$1;
(statearr_18642_18812[(2)] = inst_18577);

(statearr_18642_18812[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (15))){
var inst_18322 = (state_18603[(15)]);
var state_18603__$1 = state_18603;
var statearr_18643_18813 = state_18603__$1;
(statearr_18643_18813[(2)] = inst_18322);

(statearr_18643_18813[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (48))){
var inst_18443 = (state_18603[(10)]);
var inst_18334 = (state_18603[(9)]);
var inst_18443__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18445 = (inst_18443__$1 == null);
var inst_18446 = cljs.core.not.call(null,inst_18445);
var state_18603__$1 = (function (){var statearr_18644 = state_18603;
(statearr_18644[(10)] = inst_18443__$1);

return statearr_18644;
})();
if(inst_18446){
var statearr_18645_18814 = state_18603__$1;
(statearr_18645_18814[(1)] = (51));

} else {
var statearr_18646_18815 = state_18603__$1;
(statearr_18646_18815[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (50))){
var inst_18334 = (state_18603[(9)]);
var inst_18561 = (state_18603[(2)]);
var inst_18562 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18563 = inst_18562 === true;
var state_18603__$1 = (function (){var statearr_18647 = state_18603;
(statearr_18647[(14)] = inst_18561);

return statearr_18647;
})();
if(cljs.core.truth_(inst_18563)){
var statearr_18648_18816 = state_18603__$1;
(statearr_18648_18816[(1)] = (99));

} else {
var statearr_18649_18817 = state_18603__$1;
(statearr_18649_18817[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (75))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18650_18818 = state_18603__$1;
(statearr_18650_18818[(2)] = inst_18433);

(statearr_18650_18818[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (99))){
var inst_18565 = (state_18603[(16)]);
var inst_18334 = (state_18603[(9)]);
var inst_18565__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18651 = state_18603;
(statearr_18651[(16)] = inst_18565__$1);

return statearr_18651;
})();
if(cljs.core.truth_(inst_18565__$1)){
var statearr_18652_18819 = state_18603__$1;
(statearr_18652_18819[(1)] = (102));

} else {
var statearr_18653_18820 = state_18603__$1;
(statearr_18653_18820[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (21))){
var inst_18357 = (state_18603[(17)]);
var state_18603__$1 = state_18603;
var statearr_18654_18821 = state_18603__$1;
(statearr_18654_18821[(2)] = inst_18357);

(statearr_18654_18821[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (31))){
var inst_18397 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18397)){
var statearr_18655_18822 = state_18603__$1;
(statearr_18655_18822[(1)] = (32));

} else {
var statearr_18656_18823 = state_18603__$1;
(statearr_18656_18823[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (32))){
var inst_18386 = (state_18603[(18)]);
var inst_18399 = fluree.db.query.schema.type_error.call(null,inst_18386,"a component","a non-component",throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18657_18824 = state_18603__$1;
(statearr_18657_18824[(2)] = inst_18399);

(statearr_18657_18824[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (40))){
var inst_18402 = (state_18603[(19)]);
var state_18603__$1 = state_18603;
var statearr_18658_18825 = state_18603__$1;
(statearr_18658_18825[(2)] = inst_18402);

(statearr_18658_18825[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (91))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18659_18826 = state_18603__$1;
(statearr_18659_18826[(2)] = inst_18433);

(statearr_18659_18826[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (108))){
var inst_18583 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18584 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18585 = cljs.core.PersistentHashMap.fromArrays(inst_18583,inst_18584);
var inst_18586 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_18585);
var inst_18587 = (function(){throw inst_18586})();
var state_18603__$1 = state_18603;
var statearr_18660_18827 = state_18603__$1;
(statearr_18660_18827[(2)] = inst_18587);

(statearr_18660_18827[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (56))){
var inst_18456 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18661_18828 = state_18603__$1;
(statearr_18661_18828[(2)] = inst_18456);

(statearr_18661_18828[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (33))){
var inst_18386 = (state_18603[(18)]);
var state_18603__$1 = state_18603;
var statearr_18662_18829 = state_18603__$1;
(statearr_18662_18829[(2)] = inst_18386);

(statearr_18662_18829[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (13))){
var inst_18349 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18349)){
var statearr_18663_18830 = state_18603__$1;
(statearr_18663_18830[(1)] = (14));

} else {
var statearr_18664_18831 = state_18603__$1;
(statearr_18664_18831[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (22))){
var inst_18370 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18665_18832 = state_18603__$1;
(statearr_18665_18832[(2)] = inst_18370);

(statearr_18665_18832[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (90))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18528 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_18529 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,5,inst_18528,null);
var inst_18530 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18529,null);
var inst_18531 = inst_18530.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18531)){
var statearr_18666_18833 = state_18603__$1;
(statearr_18666_18833[(1)] = (91));

} else {
var statearr_18667_18834 = state_18603__$1;
(statearr_18667_18834[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (109))){
var inst_18561 = (state_18603[(14)]);
var state_18603__$1 = state_18603;
var statearr_18668_18835 = state_18603__$1;
(statearr_18668_18835[(2)] = inst_18561);

(statearr_18668_18835[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (36))){
var inst_18403 = (state_18603[(20)]);
var state_18603__$1 = state_18603;
var statearr_18669_18836 = state_18603__$1;
(statearr_18669_18836[(2)] = inst_18403);

(statearr_18669_18836[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (41))){
var inst_18434 = (state_18603[(13)]);
var inst_18334 = (state_18603[(9)]);
var inst_18433 = (state_18603[(2)]);
var inst_18434__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18670 = state_18603;
(statearr_18670[(13)] = inst_18434__$1);

(statearr_18670[(11)] = inst_18433);

return statearr_18670;
})();
if(cljs.core.truth_(inst_18434__$1)){
var statearr_18671_18837 = state_18603__$1;
(statearr_18671_18837[(1)] = (45));

} else {
var statearr_18672_18838 = state_18603__$1;
(statearr_18672_18838[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (89))){
var inst_18526 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18673_18839 = state_18603__$1;
(statearr_18673_18839[(2)] = inst_18526);

(statearr_18673_18839[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (100))){
var state_18603__$1 = state_18603;
var statearr_18674_18840 = state_18603__$1;
(statearr_18674_18840[(2)] = false);

(statearr_18674_18840[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (43))){
var inst_18402 = (state_18603[(19)]);
var state_18603__$1 = state_18603;
var statearr_18675_18841 = state_18603__$1;
(statearr_18675_18841[(2)] = inst_18402);

(statearr_18675_18841[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (61))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18470 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_18471 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,3,inst_18470,null);
var inst_18472 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18471,null);
var inst_18473 = inst_18472.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18473)){
var statearr_18676_18842 = state_18603__$1;
(statearr_18676_18842[(1)] = (63));

} else {
var statearr_18677_18843 = state_18603__$1;
(statearr_18677_18843[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (29))){
var inst_18334 = (state_18603[(9)]);
var inst_18389 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18390 = cljs.core.not.call(null,inst_18389);
var inst_18391 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18392 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18391);
var inst_18393 = inst_18392 === true;
var inst_18394 = ((inst_18390) && (inst_18393));
var state_18603__$1 = state_18603;
var statearr_18678_18844 = state_18603__$1;
(statearr_18678_18844[(2)] = inst_18394);

(statearr_18678_18844[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (44))){
var inst_18430 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18679_18845 = state_18603__$1;
(statearr_18679_18845[(2)] = inst_18430);

(statearr_18679_18845[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (93))){
var inst_18536 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18680_18846 = state_18603__$1;
(statearr_18680_18846[(2)] = inst_18536);

(statearr_18680_18846[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (6))){
var inst_18333 = (state_18603[(21)]);
var inst_18321 = (state_18603[(22)]);
var inst_18330 = cljs.core.seq.call(null,inst_18321);
var inst_18331 = cljs.core.first.call(null,inst_18330);
var inst_18332 = cljs.core.next.call(null,inst_18330);
var inst_18333__$1 = cljs.core.nth.call(null,inst_18331,(0),null);
var inst_18334 = cljs.core.nth.call(null,inst_18331,(1),null);
var inst_18335 = cljs.core.not.call(null,inst_18333__$1);
var state_18603__$1 = (function (){var statearr_18681 = state_18603;
(statearr_18681[(21)] = inst_18333__$1);

(statearr_18681[(9)] = inst_18334);

(statearr_18681[(23)] = inst_18332);

return statearr_18681;
})();
if(inst_18335){
var statearr_18682_18847 = state_18603__$1;
(statearr_18682_18847[(1)] = (8));

} else {
var statearr_18683_18848 = state_18603__$1;
(statearr_18683_18848[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (28))){
var inst_18383 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18684_18849 = state_18603__$1;
(statearr_18684_18849[(2)] = inst_18383);

(statearr_18684_18849[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (64))){
var state_18603__$1 = state_18603;
var statearr_18685_18850 = state_18603__$1;
(statearr_18685_18850[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (103))){
var inst_18565 = (state_18603[(16)]);
var state_18603__$1 = state_18603;
var statearr_18687_18851 = state_18603__$1;
(statearr_18687_18851[(2)] = inst_18565);

(statearr_18687_18851[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (51))){
var inst_18443 = (state_18603[(10)]);
var inst_18448 = inst_18443.cljs$lang$protocol_mask$partition0$;
var inst_18449 = (inst_18448 & (64));
var inst_18450 = inst_18443.cljs$core$ISeq$;
var inst_18451 = (cljs.core.PROTOCOL_SENTINEL === inst_18450);
var inst_18452 = ((inst_18449) || (inst_18451));
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18452)){
var statearr_18688_18852 = state_18603__$1;
(statearr_18688_18852[(1)] = (54));

} else {
var statearr_18689_18853 = state_18603__$1;
(statearr_18689_18853[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (25))){
var inst_18387 = (state_18603[(24)]);
var inst_18334 = (state_18603[(9)]);
var inst_18386 = (state_18603[(2)]);
var inst_18387__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18690 = state_18603;
(statearr_18690[(24)] = inst_18387__$1);

(statearr_18690[(18)] = inst_18386);

return statearr_18690;
})();
if(cljs.core.truth_(inst_18387__$1)){
var statearr_18691_18854 = state_18603__$1;
(statearr_18691_18854[(1)] = (29));

} else {
var statearr_18692_18855 = state_18603__$1;
(statearr_18692_18855[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (34))){
var inst_18403 = (state_18603[(20)]);
var inst_18334 = (state_18603[(9)]);
var inst_18402 = (state_18603[(2)]);
var inst_18403__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18693 = state_18603;
(statearr_18693[(19)] = inst_18402);

(statearr_18693[(20)] = inst_18403__$1);

return statearr_18693;
})();
if(cljs.core.truth_(inst_18403__$1)){
var statearr_18694_18856 = state_18603__$1;
(statearr_18694_18856[(1)] = (35));

} else {
var statearr_18695_18857 = state_18603__$1;
(statearr_18695_18857[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (17))){
var inst_18334 = (state_18603[(9)]);
var inst_18357 = (state_18603[(17)]);
var inst_18357__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18696 = state_18603;
(statearr_18696[(17)] = inst_18357__$1);

return statearr_18696;
})();
if(cljs.core.truth_(inst_18357__$1)){
var statearr_18697_18858 = state_18603__$1;
(statearr_18697_18858[(1)] = (20));

} else {
var statearr_18698_18859 = state_18603__$1;
(statearr_18698_18859[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (3))){
var inst_18601 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18603__$1,inst_18601);
} else {
if((state_val_18604 === (12))){
var inst_18338 = (state_18603[(25)]);
var state_18603__$1 = state_18603;
var statearr_18699_18860 = state_18603__$1;
(statearr_18699_18860[(2)] = inst_18338);

(statearr_18699_18860[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (2))){
var _ = (function (){var statearr_18700 = state_18603;
(statearr_18700[(4)] = cljs.core.cons.call(null,(5),(state_18603[(4)])));

return statearr_18700;
})();
var inst_18314 = pred_changes;
var inst_18315 = cljs.core.seq.call(null,inst_18314);
var inst_18316 = cljs.core.first.call(null,inst_18315);
var inst_18317 = cljs.core.next.call(null,inst_18315);
var inst_18318 = cljs.core.nth.call(null,inst_18316,(0),null);
var inst_18319 = cljs.core.nth.call(null,inst_18316,(1),null);
var inst_18320 = db;
var inst_18321 = inst_18314;
var inst_18322 = inst_18320;
var state_18603__$1 = (function (){var statearr_18701 = state_18603;
(statearr_18701[(15)] = inst_18322);

(statearr_18701[(22)] = inst_18321);

(statearr_18701[(26)] = inst_18318);

(statearr_18701[(27)] = inst_18317);

(statearr_18701[(28)] = inst_18319);

return statearr_18701;
})();
var statearr_18702_18861 = state_18603__$1;
(statearr_18702_18861[(2)] = null);

(statearr_18702_18861[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (66))){
var inst_18466 = (state_18603[(8)]);
var state_18603__$1 = state_18603;
var G__18703_18862 = inst_18466;
var G__18703_18863__$1 = (((G__18703_18862 instanceof cljs.core.Keyword))?G__18703_18862.fqn:null);
switch (G__18703_18863__$1) {
case "long":
var statearr_18704_18865 = state_18603__$1;
(statearr_18704_18865[(1)] = (70));


break;
case "bigint":
var statearr_18705_18866 = state_18603__$1;
(statearr_18705_18866[(1)] = (74));


break;
case "double":
var statearr_18706_18867 = state_18603__$1;
(statearr_18706_18867[(1)] = (78));


break;
case "float":
var statearr_18707_18868 = state_18603__$1;
(statearr_18707_18868[(1)] = (82));


break;
case "bigdec":
var statearr_18708_18869 = state_18603__$1;
(statearr_18708_18869[(1)] = (86));


break;
case "string":
var statearr_18709_18870 = state_18603__$1;
(statearr_18709_18870[(1)] = (90));


break;
case "instant":
var statearr_18710_18871 = state_18603__$1;
(statearr_18710_18871[(1)] = (94));


break;
default:
var statearr_18711_18872 = state_18603__$1;
(statearr_18711_18872[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (107))){
var inst_18332 = (state_18603[(23)]);
var inst_18593 = (state_18603[(2)]);
var inst_18321 = inst_18332;
var inst_18322 = inst_18593;
var state_18603__$1 = (function (){var statearr_18712 = state_18603;
(statearr_18712[(15)] = inst_18322);

(statearr_18712[(22)] = inst_18321);

return statearr_18712;
})();
var statearr_18713_18873 = state_18603__$1;
(statearr_18713_18873[(2)] = null);

(statearr_18713_18873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (23))){
var state_18603__$1 = state_18603;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18714_18874 = state_18603__$1;
(statearr_18714_18874[(1)] = (26));

} else {
var statearr_18715_18875 = state_18603__$1;
(statearr_18715_18875[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (47))){
var inst_18440 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18440)){
var statearr_18716_18876 = state_18603__$1;
(statearr_18716_18876[(1)] = (48));

} else {
var statearr_18717_18877 = state_18603__$1;
(statearr_18717_18877[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (35))){
var inst_18333 = (state_18603[(21)]);
var inst_18322 = (state_18603[(15)]);
var inst_18334 = (state_18603[(9)]);
var inst_18405 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18406 = cljs.core.not.call(null,inst_18405);
var inst_18407 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18408 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18407);
var inst_18409 = inst_18408 === true;
var inst_18410 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_18322,inst_18333);
var state_18603__$1 = (function (){var statearr_18718 = state_18603;
(statearr_18718[(29)] = inst_18406);

(statearr_18718[(30)] = inst_18409);

return statearr_18718;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18603__$1,(38),inst_18410);
} else {
if((state_val_18604 === (82))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18508 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18509 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,3,inst_18508,null);
var inst_18510 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18509,null);
var inst_18511 = inst_18510.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18511)){
var statearr_18719_18878 = state_18603__$1;
(statearr_18719_18878[(1)] = (83));

} else {
var statearr_18720_18879 = state_18603__$1;
(statearr_18720_18879[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (76))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18494 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18721_18880 = state_18603__$1;
(statearr_18721_18880[(2)] = inst_18494);

(statearr_18721_18880[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (97))){
var inst_18546 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18722_18881 = state_18603__$1;
(statearr_18722_18881[(2)] = inst_18546);

(statearr_18722_18881[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (19))){
var inst_18373 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18373)){
var statearr_18723_18882 = state_18603__$1;
(statearr_18723_18882[(1)] = (23));

} else {
var statearr_18724_18883 = state_18603__$1;
(statearr_18724_18883[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (57))){
var inst_18443 = (state_18603[(10)]);
var inst_18461 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18443);
var state_18603__$1 = state_18603;
var statearr_18725_18884 = state_18603__$1;
(statearr_18725_18884[(2)] = inst_18461);

(statearr_18725_18884[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (68))){
var inst_18554 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18726_18885 = state_18603__$1;
(statearr_18726_18885[(2)] = inst_18554);

(statearr_18726_18885[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (11))){
var inst_18334 = (state_18603[(9)]);
var inst_18340 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18341 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18340);
var inst_18342 = inst_18341 === false;
var inst_18343 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18344 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18343);
var inst_18345 = inst_18344 === true;
var inst_18346 = ((inst_18342) && (inst_18345));
var state_18603__$1 = state_18603;
var statearr_18728_18886 = state_18603__$1;
(statearr_18728_18886[(2)] = inst_18346);

(statearr_18728_18886[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (9))){
var inst_18338 = (state_18603[(25)]);
var inst_18334 = (state_18603[(9)]);
var inst_18338__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18729 = state_18603;
(statearr_18729[(25)] = inst_18338__$1);

return statearr_18729;
})();
if(cljs.core.truth_(inst_18338__$1)){
var statearr_18730_18887 = state_18603__$1;
(statearr_18730_18887[(1)] = (11));

} else {
var statearr_18731_18888 = state_18603__$1;
(statearr_18731_18888[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (5))){
var _ = (function (){var statearr_18732 = state_18603;
(statearr_18732[(4)] = cljs.core.rest.call(null,(state_18603[(4)])));

return statearr_18732;
})();
var state_18603__$1 = state_18603;
var ex18727 = (state_18603__$1[(2)]);
var statearr_18733_18889 = state_18603__$1;
(statearr_18733_18889[(5)] = ex18727);


if((ex18727 instanceof Error)){
var statearr_18734_18890 = state_18603__$1;
(statearr_18734_18890[(1)] = (4));

(statearr_18734_18890[(5)] = null);

} else {
throw ex18727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (83))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18735_18891 = state_18603__$1;
(statearr_18735_18891[(2)] = inst_18433);

(statearr_18735_18891[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (14))){
var inst_18322 = (state_18603[(15)]);
var inst_18351 = fluree.db.query.schema.type_error.call(null,inst_18322,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18736_18892 = state_18603__$1;
(statearr_18736_18892[(2)] = inst_18351);

(statearr_18736_18892[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (45))){
var inst_18334 = (state_18603[(9)]);
var inst_18436 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18334);
var inst_18437 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18436);
var state_18603__$1 = state_18603;
var statearr_18737_18893 = state_18603__$1;
(statearr_18737_18893[(2)] = inst_18437);

(statearr_18737_18893[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (53))){
var inst_18459 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18459)){
var statearr_18738_18894 = state_18603__$1;
(statearr_18738_18894[(1)] = (57));

} else {
var statearr_18739_18895 = state_18603__$1;
(statearr_18739_18895[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (78))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18498 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_18499 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,3,inst_18498,null);
var inst_18500 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18499,null);
var inst_18501 = inst_18500.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18501)){
var statearr_18740_18896 = state_18603__$1;
(statearr_18740_18896[(1)] = (79));

} else {
var statearr_18741_18897 = state_18603__$1;
(statearr_18741_18897[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (26))){
var inst_18376 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18377 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18378 = cljs.core.PersistentHashMap.fromArrays(inst_18376,inst_18377);
var inst_18379 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_18378);
var inst_18380 = (function(){throw inst_18379})();
var state_18603__$1 = state_18603;
var statearr_18742_18898 = state_18603__$1;
(statearr_18742_18898[(2)] = inst_18380);

(statearr_18742_18898[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (16))){
var inst_18355 = (state_18603[(31)]);
var inst_18334 = (state_18603[(9)]);
var inst_18354 = (state_18603[(2)]);
var inst_18355__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18334);
var state_18603__$1 = (function (){var statearr_18743 = state_18603;
(statearr_18743[(31)] = inst_18355__$1);

(statearr_18743[(12)] = inst_18354);

return statearr_18743;
})();
if(cljs.core.truth_(inst_18355__$1)){
var statearr_18744_18899 = state_18603__$1;
(statearr_18744_18899[(1)] = (17));

} else {
var statearr_18745_18900 = state_18603__$1;
(statearr_18745_18900[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (81))){
var inst_18506 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18746_18901 = state_18603__$1;
(statearr_18746_18901[(2)] = inst_18506);

(statearr_18746_18901[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (79))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18747_18902 = state_18603__$1;
(statearr_18747_18902[(2)] = inst_18433);

(statearr_18747_18902[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (38))){
var inst_18406 = (state_18603[(29)]);
var inst_18409 = (state_18603[(30)]);
var inst_18412 = (state_18603[(2)]);
var inst_18413 = fluree.db.util.async.throw_err.call(null,inst_18412);
var inst_18414 = cljs.core.not.call(null,inst_18413);
var inst_18415 = ((inst_18406) && (inst_18409) && (inst_18414));
var state_18603__$1 = state_18603;
var statearr_18748_18903 = state_18603__$1;
(statearr_18748_18903[(2)] = inst_18415);

(statearr_18748_18903[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (98))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18548 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18749_18904 = state_18603__$1;
(statearr_18749_18904[(2)] = inst_18548);

(statearr_18749_18904[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (87))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18750_18905 = state_18603__$1;
(statearr_18750_18905[(2)] = inst_18433);

(statearr_18750_18905[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (30))){
var inst_18387 = (state_18603[(24)]);
var state_18603__$1 = state_18603;
var statearr_18751_18906 = state_18603__$1;
(statearr_18751_18906[(2)] = inst_18387);

(statearr_18751_18906[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (73))){
var inst_18486 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18752_18907 = state_18603__$1;
(statearr_18752_18907[(2)] = inst_18486);

(statearr_18752_18907[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (96))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18544 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18753_18908 = state_18603__$1;
(statearr_18753_18908[(2)] = inst_18544);

(statearr_18753_18908[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (10))){
var inst_18596 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18754_18909 = state_18603__$1;
(statearr_18754_18909[(2)] = inst_18596);

(statearr_18754_18909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (18))){
var inst_18355 = (state_18603[(31)]);
var state_18603__$1 = state_18603;
var statearr_18755_18910 = state_18603__$1;
(statearr_18755_18910[(2)] = inst_18355);

(statearr_18755_18910[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (105))){
var state_18603__$1 = state_18603;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_18756_18911 = state_18603__$1;
(statearr_18756_18911[(1)] = (108));

} else {
var statearr_18757_18912 = state_18603__$1;
(statearr_18757_18912[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (52))){
var state_18603__$1 = state_18603;
var statearr_18758_18913 = state_18603__$1;
(statearr_18758_18913[(2)] = false);

(statearr_18758_18913[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (67))){
var state_18603__$1 = state_18603;
var statearr_18759_18914 = state_18603__$1;
(statearr_18759_18914[(2)] = null);

(statearr_18759_18914[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (71))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18760_18915 = state_18603__$1;
(statearr_18760_18915[(2)] = inst_18433);

(statearr_18760_18915[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (42))){
var inst_18333 = (state_18603[(21)]);
var inst_18322 = (state_18603[(15)]);
var inst_18421 = fluree.db.dbproto._p_prop.call(null,inst_18322,new cljs.core.Keyword(null,"name","name",1843675177),inst_18333);
var inst_18422 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18421)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_18423 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18424 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18425 = cljs.core.PersistentHashMap.fromArrays(inst_18423,inst_18424);
var inst_18426 = cljs.core.ex_info.call(null,inst_18422,inst_18425);
var inst_18427 = (function(){throw inst_18426})();
var state_18603__$1 = state_18603;
var statearr_18761_18916 = state_18603__$1;
(statearr_18761_18916[(2)] = inst_18427);

(statearr_18761_18916[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (80))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18504 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18762_18917 = state_18603__$1;
(statearr_18762_18917[(2)] = inst_18504);

(statearr_18762_18917[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (37))){
var inst_18418 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18418)){
var statearr_18763_18918 = state_18603__$1;
(statearr_18763_18918[(1)] = (39));

} else {
var statearr_18764_18919 = state_18603__$1;
(statearr_18764_18919[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (63))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18475 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18765_18920 = state_18603__$1;
(statearr_18765_18920[(2)] = inst_18475);

(statearr_18765_18920[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (94))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18538 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_18539 = inst_18466.call(null,cljs.core.PersistentArrayMap,null,2,inst_18538,null);
var inst_18540 = inst_18466.call(null,cljs.core.PersistentHashSet,null,inst_18539,null);
var inst_18541 = inst_18540.call(null,inst_18465);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18541)){
var statearr_18766_18921 = state_18603__$1;
(statearr_18766_18921[(1)] = (95));

} else {
var statearr_18767_18922 = state_18603__$1;
(statearr_18767_18922[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (8))){
var inst_18322 = (state_18603[(15)]);
var state_18603__$1 = state_18603;
var statearr_18768_18923 = state_18603__$1;
(statearr_18768_18923[(2)] = inst_18322);

(statearr_18768_18923[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (49))){
var inst_18433 = (state_18603[(11)]);
var state_18603__$1 = state_18603;
var statearr_18769_18924 = state_18603__$1;
(statearr_18769_18924[(2)] = inst_18433);

(statearr_18769_18924[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18604 === (84))){
var inst_18465 = (state_18603[(7)]);
var inst_18466 = (state_18603[(8)]);
var inst_18514 = fluree.db.query.schema.type_error.call(null,inst_18465,inst_18466,throw_QMARK_);
var state_18603__$1 = state_18603;
var statearr_18770_18925 = state_18603__$1;
(statearr_18770_18925[(2)] = inst_18514);

(statearr_18770_18925[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2454__auto__ = null;
var fluree$db$query$schema$state_machine__2454__auto____0 = (function (){
var statearr_18771 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18771[(0)] = fluree$db$query$schema$state_machine__2454__auto__);

(statearr_18771[(1)] = (1));

return statearr_18771;
});
var fluree$db$query$schema$state_machine__2454__auto____1 = (function (state_18603){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_18603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18772){var ex__2457__auto__ = e18772;
var statearr_18773_18926 = state_18603;
(statearr_18773_18926[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_18603[(4)]))){
var statearr_18774_18927 = state_18603;
(statearr_18774_18927[(1)] = cljs.core.first.call(null,(state_18603[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18928 = state_18603;
state_18603 = G__18928;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2454__auto__ = function(state_18603){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2454__auto____1.call(this,state_18603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2454__auto____0;
fluree$db$query$schema$state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2454__auto____1;
return fluree$db$query$schema$state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18775 = f__2477__auto__.call(null);
(statearr_18775[(6)] = c__2476__auto__);

return statearr_18775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_18952){
var state_val_18953 = (state_18952[(1)]);
if((state_val_18953 === (7))){
var state_18952__$1 = state_18952;
var statearr_18954_18973 = state_18952__$1;
(statearr_18954_18973[(2)] = db);

(statearr_18954_18973[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (1))){
var state_18952__$1 = state_18952;
var statearr_18955_18974 = state_18952__$1;
(statearr_18955_18974[(2)] = null);

(statearr_18955_18974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (4))){
var inst_18929 = (state_18952[(2)]);
var state_18952__$1 = state_18952;
var statearr_18956_18975 = state_18952__$1;
(statearr_18956_18975[(2)] = inst_18929);

(statearr_18956_18975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (6))){
var inst_18938 = (state_18952[(7)]);
var inst_18937 = (state_18952[(2)]);
var inst_18938__$1 = fluree.db.util.async.throw_err.call(null,inst_18937);
var inst_18939 = cljs.core.empty_QMARK_.call(null,inst_18938__$1);
var state_18952__$1 = (function (){var statearr_18957 = state_18952;
(statearr_18957[(7)] = inst_18938__$1);

return statearr_18957;
})();
if(inst_18939){
var statearr_18958_18976 = state_18952__$1;
(statearr_18958_18976[(1)] = (7));

} else {
var statearr_18959_18977 = state_18952__$1;
(statearr_18959_18977[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (3))){
var inst_18950 = (state_18952[(2)]);
var state_18952__$1 = state_18952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18952__$1,inst_18950);
} else {
if((state_val_18953 === (2))){
var _ = (function (){var statearr_18961 = state_18952;
(statearr_18961[(4)] = cljs.core.cons.call(null,(5),(state_18952[(4)])));

return statearr_18961;
})();
var inst_18935 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_18952__$1 = state_18952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18952__$1,(6),inst_18935);
} else {
if((state_val_18953 === (9))){
var inst_18947 = (state_18952[(2)]);
var _ = (function (){var statearr_18962 = state_18952;
(statearr_18962[(4)] = cljs.core.rest.call(null,(state_18952[(4)])));

return statearr_18962;
})();
var state_18952__$1 = state_18952;
var statearr_18963_18978 = state_18952__$1;
(statearr_18963_18978[(2)] = inst_18947);

(statearr_18963_18978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (5))){
var _ = (function (){var statearr_18964 = state_18952;
(statearr_18964[(4)] = cljs.core.rest.call(null,(state_18952[(4)])));

return statearr_18964;
})();
var state_18952__$1 = state_18952;
var ex18960 = (state_18952__$1[(2)]);
var statearr_18965_18979 = state_18952__$1;
(statearr_18965_18979[(5)] = ex18960);


if((ex18960 instanceof Error)){
var statearr_18966_18980 = state_18952__$1;
(statearr_18966_18980[(1)] = (4));

(statearr_18966_18980[(5)] = null);

} else {
throw ex18960;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (10))){
var inst_18944 = (state_18952[(2)]);
var inst_18945 = fluree.db.util.async.throw_err.call(null,inst_18944);
var state_18952__$1 = state_18952;
var statearr_18967_18981 = state_18952__$1;
(statearr_18967_18981[(2)] = inst_18945);

(statearr_18967_18981[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18953 === (8))){
var inst_18938 = (state_18952[(7)]);
var inst_18942 = fluree.db.query.schema.predicate_change_error.call(null,inst_18938,db,true);
var state_18952__$1 = state_18952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18952__$1,(10),inst_18942);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____0 = (function (){
var statearr_18968 = [null,null,null,null,null,null,null,null];
(statearr_18968[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__);

(statearr_18968[(1)] = (1));

return statearr_18968;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____1 = (function (state_18952){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_18952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e18969){var ex__2457__auto__ = e18969;
var statearr_18970_18982 = state_18952;
(statearr_18970_18982[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_18952[(4)]))){
var statearr_18971_18983 = state_18952;
(statearr_18971_18983[(1)] = cljs.core.first.call(null,(state_18952[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18984 = state_18952;
state_18952 = G__18984;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__ = function(state_18952){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____1.call(this,state_18952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_18972 = f__2477__auto__.call(null);
(statearr_18972[(6)] = c__2476__auto__);

return statearr_18972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__18986 = arguments.length;
switch (G__18986) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__18988 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__18988,(0),null);
var ns = cljs.core.nth.call(null,vec__18988,(1),null);
var name = cljs.core.nth.call(null,vec__18988,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__18991_SHARP_,p2__18992_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18991_SHARP_,p2__18992_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19058){
var state_val_19059 = (state_19058[(1)]);
if((state_val_19059 === (1))){
var state_19058__$1 = state_19058;
var statearr_19060_19077 = state_19058__$1;
(statearr_19060_19077[(2)] = null);

(statearr_19060_19077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19059 === (2))){
var _ = (function (){var statearr_19061 = state_19058;
(statearr_19061[(4)] = cljs.core.cons.call(null,(5),(state_19058[(4)])));

return statearr_19061;
})();
var inst_19010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19011 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_19012 = [inst_19011];
var inst_19013 = (new cljs.core.PersistentVector(null,1,(5),inst_19010,inst_19012,null));
var inst_19014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19015 = [(0)];
var inst_19016 = (new cljs.core.PersistentVector(null,1,(5),inst_19014,inst_19015,null));
var inst_19017 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_19013,cljs.core._LT__EQ_,inst_19016);
var state_19058__$1 = state_19058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19058__$1,(6),inst_19017);
} else {
if((state_val_19059 === (3))){
var inst_19056 = (state_19058[(2)]);
var state_19058__$1 = state_19058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19058__$1,inst_19056);
} else {
if((state_val_19059 === (4))){
var inst_18998 = (state_19058[(2)]);
var state_19058__$1 = state_19058;
var statearr_19063_19078 = state_19058__$1;
(statearr_19063_19078[(2)] = inst_18998);

(statearr_19063_19078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19059 === (5))){
var _ = (function (){var statearr_19064 = state_19058;
(statearr_19064[(4)] = cljs.core.rest.call(null,(state_19058[(4)])));

return statearr_19064;
})();
var state_19058__$1 = state_19058;
var ex19062 = (state_19058__$1[(2)]);
var statearr_19065_19079 = state_19058__$1;
(statearr_19065_19079[(5)] = ex19062);


if((ex19062 instanceof Error)){
var statearr_19066_19080 = state_19058__$1;
(statearr_19066_19080[(1)] = (4));

(statearr_19066_19080[(5)] = null);

} else {
throw ex19062;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19059 === (6))){
var inst_19019 = (state_19058[(2)]);
var inst_19020 = fluree.db.util.async.throw_err.call(null,inst_19019);
var inst_19021 = (function (){var schema_flakes = inst_19020;
return (function (p1__18993_SHARP_){
return (p1__18993_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_19022 = cljs.core.partition_by.call(null,inst_19021,inst_19020);
var inst_19023 = cljs.core.nth.call(null,inst_19022,(0),null);
var inst_19024 = cljs.core.nth.call(null,inst_19022,(1),null);
var inst_19025 = (function (){var schema_flakes = inst_19020;
var vec__19004 = inst_19022;
var collection_flakes = inst_19023;
var predicate_flakes = inst_19024;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__18995_SHARP_,p2__18996_SHARP_){
return cljs.core.assoc.call(null,p1__18995_SHARP_,p2__18996_SHARP_.p,p2__18996_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_19026 = [(-1),"_tx"];
var inst_19027 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19028 = ["_tx",(-1),(-1)];
var inst_19029 = cljs.core.PersistentHashMap.fromArrays(inst_19027,inst_19028);
var inst_19030 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19031 = ["_tx",(-1),(-1)];
var inst_19032 = cljs.core.PersistentHashMap.fromArrays(inst_19030,inst_19031);
var inst_19033 = [inst_19029,inst_19032];
var inst_19034 = cljs.core.PersistentHashMap.fromArrays(inst_19026,inst_19033);
var inst_19035 = (function (){var schema_flakes = inst_19020;
var vec__19004 = inst_19022;
var collection_flakes = inst_19023;
var predicate_flakes = inst_19024;
return (function (p1__18994_SHARP_){
return p1__18994_SHARP_.s;
});
})();
var inst_19036 = cljs.core.partition_by.call(null,inst_19035,inst_19023);
var inst_19037 = cljs.core.reduce.call(null,inst_19025,inst_19034,inst_19036);
var inst_19039 = (function (){var schema_flakes = inst_19020;
var vec__19004 = inst_19022;
var collection_flakes = inst_19023;
var predicate_flakes = inst_19024;
var coll = inst_19037;
return (function (p__19038,pred_flakes){
var vec__19067 = p__19038;
var pred = cljs.core.nth.call(null,vec__19067,(0),null);
var fullText = cljs.core.nth.call(null,vec__19067,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_19040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19041 = cljs.core.PersistentHashMap.EMPTY;
var inst_19042 = cljs.core.PersistentHashSet.EMPTY;
var inst_19043 = [inst_19041,inst_19042];
var inst_19044 = (new cljs.core.PersistentVector(null,2,(5),inst_19040,inst_19043,null));
var inst_19045 = (function (){var schema_flakes = inst_19020;
var vec__19004 = inst_19022;
var collection_flakes = inst_19023;
var predicate_flakes = inst_19024;
var coll = inst_19037;
return (function (p1__18997_SHARP_){
return p1__18997_SHARP_.s;
});
})();
var inst_19046 = cljs.core.partition_by.call(null,inst_19045,inst_19024);
var inst_19047 = cljs.core.reduce.call(null,inst_19039,inst_19044,inst_19046);
var inst_19048 = cljs.core.nth.call(null,inst_19047,(0),null);
var inst_19049 = cljs.core.nth.call(null,inst_19047,(1),null);
var inst_19050 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_19051 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_19052 = [inst_19051,inst_19037,inst_19048,inst_19049];
var inst_19053 = cljs.core.PersistentHashMap.fromArrays(inst_19050,inst_19052);
var _ = (function (){var statearr_19070 = state_19058;
(statearr_19070[(4)] = cljs.core.rest.call(null,(state_19058[(4)])));

return statearr_19070;
})();
var state_19058__$1 = state_19058;
var statearr_19071_19081 = state_19058__$1;
(statearr_19071_19081[(2)] = inst_19053);

(statearr_19071_19081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2454__auto____0 = (function (){
var statearr_19072 = [null,null,null,null,null,null,null];
(statearr_19072[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2454__auto__);

(statearr_19072[(1)] = (1));

return statearr_19072;
});
var fluree$db$query$schema$schema_map_$_state_machine__2454__auto____1 = (function (state_19058){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19073){var ex__2457__auto__ = e19073;
var statearr_19074_19082 = state_19058;
(statearr_19074_19082[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19058[(4)]))){
var statearr_19075_19083 = state_19058;
(statearr_19075_19083[(1)] = cljs.core.first.call(null,(state_19058[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19084 = state_19058;
state_19058 = G__19084;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2454__auto__ = function(state_19058){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2454__auto____1.call(this,state_19058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2454__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2454__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19076 = f__2477__auto__.call(null);
(statearr_19076[(6)] = c__2476__auto__);

return statearr_19076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_19126){
var state_val_19127 = (state_19126[(1)]);
if((state_val_19127 === (7))){
var inst_19109 = (state_19126[(2)]);
var inst_19110 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_19109);
var inst_19111 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_19112 = cljs.core.get.call(null,inst_19110,(114));
var inst_19113 = cljs.core.boolean$.call(null,inst_19112);
var inst_19114 = cljs.core.get.call(null,inst_19110,(110));
var inst_19115 = cljs.core.get.call(null,inst_19110,(117));
var inst_19116 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_19115);
var inst_19117 = cljs.core.get.call(null,inst_19110,(111));
var inst_19118 = cljs.core.get.call(null,inst_19110,(115));
var inst_19119 = cljs.core.get.call(null,inst_19110,(112));
var inst_19120 = [inst_19113,inst_19114,inst_19116,inst_19117,inst_19118,inst_19119];
var inst_19121 = cljs.core.PersistentHashMap.fromArrays(inst_19111,inst_19120);
var _ = (function (){var statearr_19128 = state_19126;
(statearr_19128[(4)] = cljs.core.rest.call(null,(state_19126[(4)])));

return statearr_19128;
})();
var state_19126__$1 = state_19126;
var statearr_19129_19152 = state_19126__$1;
(statearr_19129_19152[(2)] = inst_19121);

(statearr_19129_19152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (1))){
var state_19126__$1 = state_19126;
var statearr_19130_19153 = state_19126__$1;
(statearr_19130_19153[(2)] = null);

(statearr_19130_19153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (4))){
var inst_19085 = (state_19126[(2)]);
var state_19126__$1 = state_19126;
var statearr_19131_19154 = state_19126__$1;
(statearr_19131_19154[(2)] = inst_19085);

(statearr_19131_19154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (6))){
var _ = (function (){var statearr_19132 = state_19126;
(statearr_19132[(4)] = cljs.core.cons.call(null,(9),(state_19126[(4)])));

return statearr_19132;
})();
var inst_19097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19099 = ["_setting/id","root"];
var inst_19100 = (new cljs.core.PersistentVector(null,2,(5),inst_19098,inst_19099,null));
var inst_19101 = [inst_19100];
var inst_19102 = (new cljs.core.PersistentVector(null,1,(5),inst_19097,inst_19101,null));
var inst_19103 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19102);
var state_19126__$1 = state_19126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19126__$1,(10),inst_19103);
} else {
if((state_val_19127 === (3))){
var inst_19124 = (state_19126[(2)]);
var state_19126__$1 = state_19126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19126__$1,inst_19124);
} else {
if((state_val_19127 === (2))){
var _ = (function (){var statearr_19135 = state_19126;
(statearr_19135[(4)] = cljs.core.cons.call(null,(5),(state_19126[(4)])));

return statearr_19135;
})();
var state_19126__$1 = state_19126;
var statearr_19136_19155 = state_19126__$1;
(statearr_19136_19155[(2)] = null);

(statearr_19136_19155[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (9))){
var _ = (function (){var statearr_19137 = state_19126;
(statearr_19137[(4)] = cljs.core.rest.call(null,(state_19126[(4)])));

return statearr_19137;
})();
var state_19126__$1 = state_19126;
var ex19133 = (state_19126__$1[(2)]);
var statearr_19138_19156 = state_19126__$1;
(statearr_19138_19156[(5)] = ex19133);


if((ex19133 instanceof java.lang.Exception)){
var statearr_19139_19157 = state_19126__$1;
(statearr_19139_19157[(1)] = (8));

(statearr_19139_19157[(5)] = null);

} else {
throw ex19133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (5))){
var _ = (function (){var statearr_19140 = state_19126;
(statearr_19140[(4)] = cljs.core.rest.call(null,(state_19126[(4)])));

return statearr_19140;
})();
var state_19126__$1 = state_19126;
var ex19134 = (state_19126__$1[(2)]);
var statearr_19141_19158 = state_19126__$1;
(statearr_19141_19158[(5)] = ex19134);


if((ex19134 instanceof Error)){
var statearr_19142_19159 = state_19126__$1;
(statearr_19142_19159[(1)] = (4));

(statearr_19142_19159[(5)] = null);

} else {
throw ex19134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (10))){
var inst_19105 = (state_19126[(2)]);
var inst_19106 = fluree.db.util.async.throw_err.call(null,inst_19105);
var _ = (function (){var statearr_19143 = state_19126;
(statearr_19143[(4)] = cljs.core.rest.call(null,(state_19126[(4)])));

return statearr_19143;
})();
var state_19126__$1 = state_19126;
var statearr_19144_19160 = state_19126__$1;
(statearr_19144_19160[(2)] = inst_19106);

(statearr_19144_19160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19127 === (8))){
var inst_19091 = (state_19126[(2)]);
var state_19126__$1 = (function (){var statearr_19145 = state_19126;
(statearr_19145[(7)] = inst_19091);

return statearr_19145;
})();
var statearr_19146_19161 = state_19126__$1;
(statearr_19146_19161[(2)] = null);

(statearr_19146_19161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2454__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2454__auto____0 = (function (){
var statearr_19147 = [null,null,null,null,null,null,null,null];
(statearr_19147[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2454__auto__);

(statearr_19147[(1)] = (1));

return statearr_19147;
});
var fluree$db$query$schema$setting_map_$_state_machine__2454__auto____1 = (function (state_19126){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_19126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e19148){var ex__2457__auto__ = e19148;
var statearr_19149_19162 = state_19126;
(statearr_19149_19162[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_19126[(4)]))){
var statearr_19150_19163 = state_19126;
(statearr_19150_19163[(1)] = cljs.core.first.call(null,(state_19126[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19164 = state_19126;
state_19126 = G__19164;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2454__auto__ = function(state_19126){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2454__auto____1.call(this,state_19126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2454__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2454__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_19151 = f__2477__auto__.call(null);
(statearr_19151[(6)] = c__2476__auto__);

return statearr_19151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
