// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_11164){
var state_val_11165 = (state_11164[(1)]);
if((state_val_11165 === (7))){
var inst_11159 = (state_11164[(2)]);
var _ = (function (){var statearr_11166 = state_11164;
(statearr_11166[(4)] = cljs.core.rest.call(null,(state_11164[(4)])));

return statearr_11166;
})();
var state_11164__$1 = state_11164;
var statearr_11167_11189 = state_11164__$1;
(statearr_11167_11189[(2)] = inst_11159);

(statearr_11167_11189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (1))){
var state_11164__$1 = state_11164;
var statearr_11168_11190 = state_11164__$1;
(statearr_11168_11190[(2)] = null);

(statearr_11168_11190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (4))){
var inst_11121 = (state_11164[(2)]);
var state_11164__$1 = state_11164;
var statearr_11169_11191 = state_11164__$1;
(statearr_11169_11191[(2)] = inst_11121);

(statearr_11169_11191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (6))){
var inst_11146 = (state_11164[(7)]);
var inst_11139 = (state_11164[(8)]);
var inst_11145 = cljs.core.seq.call(null,inst_11139);
var inst_11146__$1 = cljs.core.first.call(null,inst_11145);
var inst_11147 = cljs.core.next.call(null,inst_11145);
var inst_11148 = cljs.core.not.call(null,inst_11146__$1);
var state_11164__$1 = (function (){var statearr_11170 = state_11164;
(statearr_11170[(7)] = inst_11146__$1);

(statearr_11170[(9)] = inst_11147);

return statearr_11170;
})();
if(inst_11148){
var statearr_11171_11192 = state_11164__$1;
(statearr_11171_11192[(1)] = (8));

} else {
var statearr_11172_11193 = state_11164__$1;
(statearr_11172_11193[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (3))){
var inst_11162 = (state_11164[(2)]);
var state_11164__$1 = state_11164;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11164__$1,inst_11162);
} else {
if((state_val_11165 === (2))){
var _ = (function (){var statearr_11173 = state_11164;
(statearr_11173[(4)] = cljs.core.cons.call(null,(5),(state_11164[(4)])));

return statearr_11173;
})();
var inst_11134 = chs;
var inst_11135 = cljs.core.seq.call(null,inst_11134);
var inst_11136 = cljs.core.first.call(null,inst_11135);
var inst_11137 = cljs.core.next.call(null,inst_11135);
var inst_11138 = coll;
var inst_11139 = inst_11134;
var inst_11140 = inst_11138;
var state_11164__$1 = (function (){var statearr_11174 = state_11164;
(statearr_11174[(10)] = inst_11137);

(statearr_11174[(8)] = inst_11139);

(statearr_11174[(11)] = inst_11140);

(statearr_11174[(12)] = inst_11136);

return statearr_11174;
})();
var statearr_11175_11194 = state_11164__$1;
(statearr_11175_11194[(2)] = null);

(statearr_11175_11194[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (11))){
var inst_11147 = (state_11164[(9)]);
var inst_11140 = (state_11164[(11)]);
var inst_11152 = (state_11164[(2)]);
var inst_11153 = fluree.db.util.async.throw_err.call(null,inst_11152);
var inst_11154 = cljs.core.conj.call(null,inst_11140,inst_11153);
var inst_11139 = inst_11147;
var inst_11140__$1 = inst_11154;
var state_11164__$1 = (function (){var statearr_11177 = state_11164;
(statearr_11177[(8)] = inst_11139);

(statearr_11177[(11)] = inst_11140__$1);

return statearr_11177;
})();
var statearr_11178_11195 = state_11164__$1;
(statearr_11178_11195[(2)] = null);

(statearr_11178_11195[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (9))){
var inst_11146 = (state_11164[(7)]);
var state_11164__$1 = state_11164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11164__$1,(11),inst_11146);
} else {
if((state_val_11165 === (5))){
var _ = (function (){var statearr_11179 = state_11164;
(statearr_11179[(4)] = cljs.core.rest.call(null,(state_11164[(4)])));

return statearr_11179;
})();
var state_11164__$1 = state_11164;
var ex11176 = (state_11164__$1[(2)]);
var statearr_11180_11196 = state_11164__$1;
(statearr_11180_11196[(5)] = ex11176);


if((ex11176 instanceof java.lang.Exception)){
var statearr_11181_11197 = state_11164__$1;
(statearr_11181_11197[(1)] = (4));

(statearr_11181_11197[(5)] = null);

} else {
throw ex11176;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (10))){
var inst_11157 = (state_11164[(2)]);
var state_11164__$1 = state_11164;
var statearr_11182_11198 = state_11164__$1;
(statearr_11182_11198[(2)] = inst_11157);

(statearr_11182_11198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11165 === (8))){
var inst_11140 = (state_11164[(11)]);
var state_11164__$1 = state_11164;
var statearr_11183_11199 = state_11164__$1;
(statearr_11183_11199[(2)] = inst_11140);

(statearr_11183_11199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_11184 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11184[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__);

(statearr_11184[(1)] = (1));

return statearr_11184;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____1 = (function (state_11164){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_11164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e11185){var ex__2457__auto__ = e11185;
var statearr_11186_11200 = state_11164;
(statearr_11186_11200[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_11164[(4)]))){
var statearr_11187_11201 = state_11164;
(statearr_11187_11201[(1)] = cljs.core.first.call(null,(state_11164[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11202 = state_11164;
state_11164 = G__11202;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__ = function(state_11164){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____1.call(this,state_11164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_11188 = f__2477__auto__.call(null);
(statearr_11188[(6)] = c__2476__auto__);

return statearr_11188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2476__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2477__auto__ = (function (){var switch__2453__auto__ = (function (state_11228){
var state_val_11229 = (state_11228[(1)]);
if((state_val_11229 === (7))){
var inst_11223 = (state_11228[(2)]);
var _ = (function (){var statearr_11230 = state_11228;
(statearr_11230[(4)] = cljs.core.rest.call(null,(state_11228[(4)])));

return statearr_11230;
})();
var state_11228__$1 = state_11228;
var statearr_11231_11253 = state_11228__$1;
(statearr_11231_11253[(2)] = inst_11223);

(statearr_11231_11253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (1))){
var state_11228__$1 = state_11228;
var statearr_11232_11254 = state_11228__$1;
(statearr_11232_11254[(2)] = null);

(statearr_11232_11254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (4))){
var inst_11203 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
var statearr_11233_11255 = state_11228__$1;
(statearr_11233_11255[(2)] = inst_11203);

(statearr_11233_11255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (6))){
var state_11228__$1 = state_11228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11228__$1,(8),chan);
} else {
if((state_val_11229 === (3))){
var inst_11226 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11228__$1,inst_11226);
} else {
if((state_val_11229 === (2))){
var _ = (function (){var statearr_11234 = state_11228;
(statearr_11234[(4)] = cljs.core.cons.call(null,(5),(state_11228[(4)])));

return statearr_11234;
})();
var inst_11209 = coll;
var inst_11210 = inst_11209;
var state_11228__$1 = (function (){var statearr_11235 = state_11228;
(statearr_11235[(7)] = inst_11210);

return statearr_11235;
})();
var statearr_11236_11256 = state_11228__$1;
(statearr_11236_11256[(2)] = null);

(statearr_11236_11256[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (11))){
var inst_11221 = (state_11228[(2)]);
var state_11228__$1 = state_11228;
var statearr_11238_11257 = state_11228__$1;
(statearr_11238_11257[(2)] = inst_11221);

(statearr_11238_11257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (9))){
var inst_11210 = (state_11228[(7)]);
var state_11228__$1 = state_11228;
var statearr_11239_11258 = state_11228__$1;
(statearr_11239_11258[(2)] = inst_11210);

(statearr_11239_11258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (5))){
var _ = (function (){var statearr_11240 = state_11228;
(statearr_11240[(4)] = cljs.core.rest.call(null,(state_11228[(4)])));

return statearr_11240;
})();
var state_11228__$1 = state_11228;
var ex11237 = (state_11228__$1[(2)]);
var statearr_11241_11259 = state_11228__$1;
(statearr_11241_11259[(5)] = ex11237);


if((ex11237 instanceof java.lang.Exception)){
var statearr_11242_11260 = state_11228__$1;
(statearr_11242_11260[(1)] = (4));

(statearr_11242_11260[(5)] = null);

} else {
throw ex11237;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (10))){
var inst_11214 = (state_11228[(8)]);
var inst_11210 = (state_11228[(7)]);
var inst_11218 = cljs.core.conj.call(null,inst_11210,inst_11214);
var inst_11210__$1 = inst_11218;
var state_11228__$1 = (function (){var statearr_11243 = state_11228;
(statearr_11243[(7)] = inst_11210__$1);

return statearr_11243;
})();
var statearr_11244_11261 = state_11228__$1;
(statearr_11244_11261[(2)] = null);

(statearr_11244_11261[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11229 === (8))){
var inst_11214 = (state_11228[(8)]);
var inst_11213 = (state_11228[(2)]);
var inst_11214__$1 = fluree.db.util.async.throw_err.call(null,inst_11213);
var inst_11215 = (inst_11214__$1 == null);
var state_11228__$1 = (function (){var statearr_11245 = state_11228;
(statearr_11245[(8)] = inst_11214__$1);

return statearr_11245;
})();
if(cljs.core.truth_(inst_11215)){
var statearr_11246_11262 = state_11228__$1;
(statearr_11246_11262[(1)] = (9));

} else {
var statearr_11247_11263 = state_11228__$1;
(statearr_11247_11263[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____0 = (function (){
var statearr_11248 = [null,null,null,null,null,null,null,null,null];
(statearr_11248[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__);

(statearr_11248[(1)] = (1));

return statearr_11248;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____1 = (function (state_11228){
while(true){
var ret_value__2455__auto__ = (function (){try{while(true){
var result__2456__auto__ = switch__2453__auto__.call(null,state_11228);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2456__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2456__auto__;
}
break;
}
}catch (e11249){var ex__2457__auto__ = e11249;
var statearr_11250_11264 = state_11228;
(statearr_11250_11264[(2)] = ex__2457__auto__);


if(cljs.core.seq.call(null,(state_11228[(4)]))){
var statearr_11251_11265 = state_11228;
(statearr_11251_11265[(1)] = cljs.core.first.call(null,(state_11228[(4)])));

} else {
throw ex__2457__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2455__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11266 = state_11228;
state_11228 = G__11266;
continue;
} else {
return ret_value__2455__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__ = function(state_11228){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____1.call(this,state_11228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2454__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2454__auto__;
})()
})();
var state__2478__auto__ = (function (){var statearr_11252 = f__2477__auto__.call(null);
(statearr_11252[(6)] = c__2476__auto__);

return statearr_11252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2478__auto__);
}));

return c__2476__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
