// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data.avl');
goog.require('cljs.core');
goog.require('cljs.core.constants');

/**
* @constructor
 * @implements {clojure.data.avl.Object}
*/
clojure.data.avl.AVLNode = (function (edit,key,val,left,right,height,rank){
this.edit = edit;
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.height = height;
this.rank = rank;
});
clojure.data.avl.AVLNode.prototype.setHeight = (function (h){
var self__ = this;
var this$ = this;
self__.height = h;

return this$;
});

clojure.data.avl.AVLNode.prototype.setKey = (function (k){
var self__ = this;
var this$ = this;
self__.key = k;

return this$;
});

clojure.data.avl.AVLNode.prototype.getRank = (function (){
var self__ = this;
var this$ = this;
return self__.rank;
});

clojure.data.avl.AVLNode.prototype.setLeft = (function (l){
var self__ = this;
var this$ = this;
self__.left = l;

return this$;
});

clojure.data.avl.AVLNode.prototype.getKey = (function (){
var self__ = this;
var this$ = this;
return self__.key;
});

clojure.data.avl.AVLNode.prototype.setVal = (function (v){
var self__ = this;
var this$ = this;
self__.val = v;

return this$;
});

clojure.data.avl.AVLNode.prototype.getVal = (function (){
var self__ = this;
var this$ = this;
return self__.val;
});

clojure.data.avl.AVLNode.prototype.setRight = (function (r){
var self__ = this;
var this$ = this;
self__.right = r;

return this$;
});

clojure.data.avl.AVLNode.prototype.getHeight = (function (){
var self__ = this;
var this$ = this;
return self__.height;
});

clojure.data.avl.AVLNode.prototype.getRight = (function (){
var self__ = this;
var this$ = this;
return self__.right;
});

clojure.data.avl.AVLNode.prototype.setRank = (function (r){
var self__ = this;
var this$ = this;
self__.rank = r;

return this$;
});

clojure.data.avl.AVLNode.prototype.getLeft = (function (){
var self__ = this;
var this$ = this;
return self__.left;
});

clojure.data.avl.AVLNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$left,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$right,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$height,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rank,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLNode.cljs$lang$type = true;

clojure.data.avl.AVLNode.cljs$lang$ctorStr = "clojure.data.avl/AVLNode";

clojure.data.avl.AVLNode.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLNode");
});

/**
 * Positional factory function for clojure.data.avl/AVLNode.
 */
clojure.data.avl.__GT_AVLNode = (function clojure$data$avl$__GT_AVLNode(edit,key,val,left,right,height,rank){
return (new clojure.data.avl.AVLNode(edit,key,val,left,right,height,rank));
});

clojure.data.avl.height = (function clojure$data$avl$height(node){
if((node == null)){
return (0);
} else {
return node.height;
}
});
clojure.data.avl.ensure_editable = (function clojure$data$avl$ensure_editable(var_args){
var G__99351 = arguments.length;
switch (G__99351) {
case 1:
return clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$1 = (function (edit){
if(cljs.core.not(edit)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transient used after persistent! call",cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
});

clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2 = (function (edit,node){
if((edit === node.edit)){
return node;
} else {
return (new clojure.data.avl.AVLNode(edit,node.getKey(),node.getVal(),node.getLeft(),node.getRight(),node.getHeight(),node.getRank()));
}
});

clojure.data.avl.ensure_editable.cljs$lang$maxFixedArity = 2;

clojure.data.avl.rotate_left = (function clojure$data$avl$rotate_left(node){
var l = node.getLeft();
var r = node.getRight();
var rl = r.getLeft();
var rr = r.getRight();
var lh = clojure.data.avl.height(l);
var rlh = clojure.data.avl.height(rl);
var rrh = clojure.data.avl.height(rr);
var rnk = node.getRank();
var rnkr = r.getRank();
return (new clojure.data.avl.AVLNode(null,r.getKey(),r.getVal(),(new clojure.data.avl.AVLNode(null,node.getKey(),node.getVal(),l,rl,((function (){var x__4219__auto__ = lh;
var y__4220__auto__ = rlh;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),rnk)),rr,(function (){var x__4219__auto__ = (function (){var x__4219__auto__ = (lh + (2));
var y__4220__auto__ = (rlh + (2));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var y__4220__auto__ = (rrh + (1));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})(),((rnk + rnkr) + (1))));
});
clojure.data.avl.rotate_left_BANG_ = (function clojure$data$avl$rotate_left_BANG_(edit,node){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var l = node__$1.getLeft();
var r = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node__$1.getRight());
var rl = r.getLeft();
var rr = r.getRight();
var lh = clojure.data.avl.height(l);
var rlh = clojure.data.avl.height(rl);
var rrh = clojure.data.avl.height(rr);
var rnk = node__$1.getRank();
var rnkr = r.getRank();
r.setLeft(node__$1);

r.setHeight((function (){var x__4219__auto__ = (function (){var x__4219__auto__ = (lh + (2));
var y__4220__auto__ = (rlh + (2));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var y__4220__auto__ = (rrh + (1));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})());

r.setRank(((rnk + rnkr) + (1)));

node__$1.setRight(rl);

node__$1.setHeight(((function (){var x__4219__auto__ = lh;
var y__4220__auto__ = rlh;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return r;
});
clojure.data.avl.rotate_right = (function clojure$data$avl$rotate_right(node){
var r = node.getRight();
var l = node.getLeft();
var lr = l.getRight();
var ll = l.getLeft();
var rh = clojure.data.avl.height(r);
var lrh = clojure.data.avl.height(lr);
var llh = clojure.data.avl.height(ll);
var rnk = node.getRank();
var rnkl = l.getRank();
return (new clojure.data.avl.AVLNode(null,l.getKey(),l.getVal(),ll,(new clojure.data.avl.AVLNode(null,node.getKey(),node.getVal(),lr,r,((function (){var x__4219__auto__ = rh;
var y__4220__auto__ = lrh;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),((rnk - rnkl) - (1)))),(function (){var x__4219__auto__ = (function (){var x__4219__auto__ = (rh + (2));
var y__4220__auto__ = (lrh + (2));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var y__4220__auto__ = (llh + (1));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})(),rnkl));
});
clojure.data.avl.rotate_right_BANG_ = (function clojure$data$avl$rotate_right_BANG_(edit,node){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var r = node__$1.getRight();
var l = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node__$1.getLeft());
var lr = l.getRight();
var ll = l.getLeft();
var rh = clojure.data.avl.height(r);
var lrh = clojure.data.avl.height(lr);
var llh = clojure.data.avl.height(ll);
var rnk = node__$1.getRank();
var rnkl = l.getRank();
l.setRight(node__$1);

l.setHeight((function (){var x__4219__auto__ = (function (){var x__4219__auto__ = (rh + (2));
var y__4220__auto__ = (lrh + (2));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var y__4220__auto__ = (llh + (1));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})());

node__$1.setLeft(lr);

node__$1.setHeight(((function (){var x__4219__auto__ = rh;
var y__4220__auto__ = lrh;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

node__$1.setRank(((rnk - rnkl) - (1)));

return l;
});
clojure.data.avl.lookup = (function clojure$data$avl$lookup(comp,node,k){
while(true){
if((node == null)){
return null;
} else {
var c = (function (){var G__99353 = k;
var G__99354 = node.getKey();
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__99353,G__99354) : comp.call(null,G__99353,G__99354));
})();
if((c === (0))){
return node;
} else {
if((c < (0))){
var G__99355 = comp;
var G__99356 = node.getLeft();
var G__99357 = k;
comp = G__99355;
node = G__99356;
k = G__99357;
continue;
} else {
var G__99358 = comp;
var G__99359 = node.getRight();
var G__99360 = k;
comp = G__99358;
node = G__99359;
k = G__99360;
continue;

}
}
}
break;
}
});
clojure.data.avl.lookup_nearest = (function clojure$data$avl$lookup_nearest(comp,node,test,k){
var below_QMARK_ = (((cljs.core._LT_ === test)) || ((cljs.core._LT__EQ_ === test)));
var equal_QMARK_ = (((cljs.core._LT__EQ_ === test)) || ((cljs.core._GT__EQ_ === test)));
var back_QMARK_ = ((below_QMARK_)?cljs.core.neg_QMARK_:cljs.core.pos_QMARK_);
var backward = ((below_QMARK_)?((function (below_QMARK_,equal_QMARK_,back_QMARK_){
return (function (p1__99361_SHARP_){
return p1__99361_SHARP_.getLeft();
});})(below_QMARK_,equal_QMARK_,back_QMARK_))
:((function (below_QMARK_,equal_QMARK_,back_QMARK_){
return (function (p1__99362_SHARP_){
return p1__99362_SHARP_.getRight();
});})(below_QMARK_,equal_QMARK_,back_QMARK_))
);
var forward = ((below_QMARK_)?((function (below_QMARK_,equal_QMARK_,back_QMARK_,backward){
return (function (p1__99363_SHARP_){
return p1__99363_SHARP_.getRight();
});})(below_QMARK_,equal_QMARK_,back_QMARK_,backward))
:((function (below_QMARK_,equal_QMARK_,back_QMARK_,backward){
return (function (p1__99364_SHARP_){
return p1__99364_SHARP_.getLeft();
});})(below_QMARK_,equal_QMARK_,back_QMARK_,backward))
);
var prev = null;
var node__$1 = node;
while(true){
if((node__$1 == null)){
return prev;
} else {
var c = (function (){var G__99367 = k;
var G__99368 = node__$1.getKey();
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__99367,G__99368) : comp.call(null,G__99367,G__99368));
})();
if((c === (0))){
if(equal_QMARK_){
return node__$1;
} else {
var G__99369 = prev;
var G__99370 = (backward.cljs$core$IFn$_invoke$arity$1 ? backward.cljs$core$IFn$_invoke$arity$1(node__$1) : backward.call(null,node__$1));
prev = G__99369;
node__$1 = G__99370;
continue;
}
} else {
if(cljs.core.truth_((back_QMARK_.cljs$core$IFn$_invoke$arity$1 ? back_QMARK_.cljs$core$IFn$_invoke$arity$1(c) : back_QMARK_.call(null,c)))){
var G__99371 = prev;
var G__99372 = (backward.cljs$core$IFn$_invoke$arity$1 ? backward.cljs$core$IFn$_invoke$arity$1(node__$1) : backward.call(null,node__$1));
prev = G__99371;
node__$1 = G__99372;
continue;
} else {
var G__99373 = node__$1;
var G__99374 = (forward.cljs$core$IFn$_invoke$arity$1 ? forward.cljs$core$IFn$_invoke$arity$1(node__$1) : forward.call(null,node__$1));
prev = G__99373;
node__$1 = G__99374;
continue;

}
}
}
break;
}
});
clojure.data.avl.select = (function clojure$data$avl$select(node,rank){
while(true){
if((node == null)){
return null;
} else {
var node_rank = node.getRank();
if((node_rank === rank)){
return node;
} else {
if((node_rank < rank)){
var G__99375 = node.getRight();
var G__99376 = ((rank - node_rank) - (1));
node = G__99375;
rank = G__99376;
continue;
} else {
var G__99377 = node.getLeft();
var G__99378 = rank;
node = G__99377;
rank = G__99378;
continue;

}
}
}
break;
}
});
clojure.data.avl.rank = (function clojure$data$avl$rank(comp,node,k){
while(true){
if((node == null)){
return (-1);
} else {
var c = (function (){var G__99379 = k;
var G__99380 = node.getKey();
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__99379,G__99380) : comp.call(null,G__99379,G__99380));
})();
if((c === (0))){
return node.getRank();
} else {
if((c < (0))){
var G__99384 = comp;
var G__99385 = node.getLeft();
var G__99386 = k;
comp = G__99384;
node = G__99385;
k = G__99386;
continue;
} else {
var r = (function (){var G__99381 = comp;
var G__99382 = node.getRight();
var G__99383 = k;
return (clojure.data.avl.rank.cljs$core$IFn$_invoke$arity$3 ? clojure.data.avl.rank.cljs$core$IFn$_invoke$arity$3(G__99381,G__99382,G__99383) : clojure.data.avl.rank.call(null,G__99381,G__99382,G__99383));
})();
if(((-1) === r)){
return (-1);
} else {
return ((node.getRank() + r) + (1));
}

}
}
}
break;
}
});
clojure.data.avl.maybe_rebalance = (function clojure$data$avl$maybe_rebalance(node){
var l = node.getLeft();
var r = node.getRight();
var lh = clojure.data.avl.height(l);
var rh = clojure.data.avl.height(r);
var b = (lh - rh);
if((b < (-1))){
var rl = r.getLeft();
var rr = r.getRight();
var rlh = clojure.data.avl.height(rl);
var rrh = clojure.data.avl.height(rr);
if(((rlh - rrh) === (1))){
var new_right = clojure.data.avl.rotate_right(r);
return clojure.data.avl.rotate_left((new clojure.data.avl.AVLNode(null,node.getKey(),node.getVal(),node.getLeft(),new_right,((function (){var x__4219__auto__ = lh;
var y__4220__auto__ = clojure.data.avl.height(new_right);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),node.getRank())));
} else {
return clojure.data.avl.rotate_left(node);
}
} else {
if((b > (1))){
var ll = l.getLeft();
var lr = l.getRight();
var llh = clojure.data.avl.height(ll);
var lrh = clojure.data.avl.height(lr);
if(((lrh - llh) === (1))){
var new_left = clojure.data.avl.rotate_left(l);
return clojure.data.avl.rotate_right((new clojure.data.avl.AVLNode(null,node.getKey(),node.getVal(),new_left,node.getRight(),((function (){var x__4219__auto__ = rh;
var y__4220__auto__ = clojure.data.avl.height(new_left);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),node.getRank())));
} else {
return clojure.data.avl.rotate_right(node);
}
} else {
return node;

}
}
});
clojure.data.avl.maybe_rebalance_BANG_ = (function clojure$data$avl$maybe_rebalance_BANG_(edit,node){
var l = node.getLeft();
var r = node.getRight();
var lh = clojure.data.avl.height(l);
var rh = clojure.data.avl.height(r);
var b = (lh - rh);
if((b < (-1))){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var rl = r.getLeft();
var rr = r.getRight();
var rlh = clojure.data.avl.height(rl);
var rrh = clojure.data.avl.height(rr);
if(((rlh - rrh) === (1))){
var new_right = clojure.data.avl.rotate_right_BANG_(edit,r);
node__$1.setRight(new_right);

node__$1.setHeight(((function (){var x__4219__auto__ = lh;
var y__4220__auto__ = clojure.data.avl.height(new_right);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.rotate_left_BANG_(edit,node__$1);
} else {
return clojure.data.avl.rotate_left_BANG_(edit,node__$1);
}
} else {
if((b > (1))){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var ll = l.getLeft();
var lr = l.getRight();
var llh = clojure.data.avl.height(ll);
var lrh = clojure.data.avl.height(lr);
if(((lrh - llh) === (1))){
var new_left = clojure.data.avl.rotate_left_BANG_(edit,l);
node__$1.setLeft(new_left);

node__$1.setHeight(((function (){var x__4219__auto__ = rh;
var y__4220__auto__ = clojure.data.avl.height(new_left);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.rotate_right_BANG_(edit,node__$1);
} else {
return clojure.data.avl.rotate_right_BANG_(edit,node__$1);
}
} else {
return node;

}
}
});
clojure.data.avl.insert = (function clojure$data$avl$insert(comp,node,k,v,found_QMARK_){
if((node == null)){
return (new clojure.data.avl.AVLNode(null,k,v,null,null,(1),(0)));
} else {
var nk = node.getKey();
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,nk) : comp.call(null,k,nk));
if((c === (0))){
found_QMARK_.val = true;

return (new clojure.data.avl.AVLNode(null,k,v,node.getLeft(),node.getRight(),node.getHeight(),node.getRank()));
} else {
if((c < (0))){
var new_child = (function (){var G__99387 = comp;
var G__99388 = node.getLeft();
var G__99389 = k;
var G__99390 = v;
var G__99391 = found_QMARK_;
return (clojure.data.avl.insert.cljs$core$IFn$_invoke$arity$5 ? clojure.data.avl.insert.cljs$core$IFn$_invoke$arity$5(G__99387,G__99388,G__99389,G__99390,G__99391) : clojure.data.avl.insert.call(null,G__99387,G__99388,G__99389,G__99390,G__99391));
})();
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,nk,node.getVal(),new_child,node.getRight(),((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = clojure.data.avl.height(node.getRight());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),(cljs.core.truth_(found_QMARK_.val)?node.getRank():(node.getRank() + (1))))));
} else {
var new_child = (function (){var G__99392 = comp;
var G__99393 = node.getRight();
var G__99394 = k;
var G__99395 = v;
var G__99396 = found_QMARK_;
return (clojure.data.avl.insert.cljs$core$IFn$_invoke$arity$5 ? clojure.data.avl.insert.cljs$core$IFn$_invoke$arity$5(G__99392,G__99393,G__99394,G__99395,G__99396) : clojure.data.avl.insert.call(null,G__99392,G__99393,G__99394,G__99395,G__99396));
})();
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,nk,node.getVal(),node.getLeft(),new_child,((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = clojure.data.avl.height(node.getLeft());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),node.getRank())));

}
}
}
});
clojure.data.avl.insert_BANG_ = (function clojure$data$avl$insert_BANG_(edit,comp,node,k,v,found_QMARK_){
if((node == null)){
return (new clojure.data.avl.AVLNode(edit,k,v,null,null,(1),(0)));
} else {
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var nk = node__$1.getKey();
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,nk) : comp.call(null,k,nk));
if((c === (0))){
found_QMARK_.val = true;

node__$1.setKey(k);

node__$1.setVal(v);

return node__$1;
} else {
if((c < (0))){
var new_child = (function (){var G__99397 = edit;
var G__99398 = comp;
var G__99399 = node__$1.getLeft();
var G__99400 = k;
var G__99401 = v;
var G__99402 = found_QMARK_;
return (clojure.data.avl.insert_BANG_.cljs$core$IFn$_invoke$arity$6 ? clojure.data.avl.insert_BANG_.cljs$core$IFn$_invoke$arity$6(G__99397,G__99398,G__99399,G__99400,G__99401,G__99402) : clojure.data.avl.insert_BANG_.call(null,G__99397,G__99398,G__99399,G__99400,G__99401,G__99402));
})();
node__$1.setLeft(new_child);

node__$1.setHeight(((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = clojure.data.avl.height(node__$1.getRight());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

if(cljs.core.not(found_QMARK_.val)){
node__$1.setRank((node__$1.getRank() + (1)));
} else {
}

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);
} else {
var new_child = (function (){var G__99403 = edit;
var G__99404 = comp;
var G__99405 = node__$1.getRight();
var G__99406 = k;
var G__99407 = v;
var G__99408 = found_QMARK_;
return (clojure.data.avl.insert_BANG_.cljs$core$IFn$_invoke$arity$6 ? clojure.data.avl.insert_BANG_.cljs$core$IFn$_invoke$arity$6(G__99403,G__99404,G__99405,G__99406,G__99407,G__99408) : clojure.data.avl.insert_BANG_.call(null,G__99403,G__99404,G__99405,G__99406,G__99407,G__99408));
})();
node__$1.setRight(new_child);

node__$1.setHeight(((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = clojure.data.avl.height(node__$1.getLeft());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);

}
}
}
});
clojure.data.avl.get_rightmost = (function clojure$data$avl$get_rightmost(node){
while(true){
var temp__5733__auto__ = node.getRight();
if(cljs.core.truth_(temp__5733__auto__)){
var r = temp__5733__auto__;
var G__99409 = r;
node = G__99409;
continue;
} else {
return node;
}
break;
}
});
clojure.data.avl.get_leftmost = (function clojure$data$avl$get_leftmost(node){
while(true){
var temp__5733__auto__ = node.getLeft();
if(cljs.core.truth_(temp__5733__auto__)){
var l = temp__5733__auto__;
var G__99410 = l;
node = G__99410;
continue;
} else {
return node;
}
break;
}
});
clojure.data.avl.delete_rightmost = (function clojure$data$avl$delete_rightmost(node){
var temp__5733__auto__ = node.getRight();
if(cljs.core.truth_(temp__5733__auto__)){
var r = temp__5733__auto__;
var l = node.getLeft();
var new_right = (clojure.data.avl.delete_rightmost.cljs$core$IFn$_invoke$arity$1 ? clojure.data.avl.delete_rightmost.cljs$core$IFn$_invoke$arity$1(r) : clojure.data.avl.delete_rightmost.call(null,r));
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,node.getKey(),node.getVal(),l,new_right,((function (){var x__4219__auto__ = clojure.data.avl.height(l);
var y__4220__auto__ = clojure.data.avl.height(new_right);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),node.getRank())));
} else {
return node.getLeft();
}
});
clojure.data.avl.delete_rightmost_BANG_ = (function clojure$data$avl$delete_rightmost_BANG_(edit,node){
if((!((node == null)))){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var r = node__$1.getRight();
if((r == null)){
var temp__5733__auto__ = node__$1.getLeft();
if(cljs.core.truth_(temp__5733__auto__)){
var l = temp__5733__auto__;
return clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,l);
} else {
return null;
}
} else {
if((r.getRight() == null)){
node__$1.setRight(r.getLeft());

node__$1.setHeight(((function (){var x__4219__auto__ = clojure.data.avl.height(node__$1.getLeft());
var y__4220__auto__ = clojure.data.avl.height(r.getLeft());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);
} else {
var new_right = (clojure.data.avl.delete_rightmost_BANG_.cljs$core$IFn$_invoke$arity$2 ? clojure.data.avl.delete_rightmost_BANG_.cljs$core$IFn$_invoke$arity$2(edit,r) : clojure.data.avl.delete_rightmost_BANG_.call(null,edit,r));
node__$1.setRight(new_right);

node__$1.setHeight(((function (){var x__4219__auto__ = clojure.data.avl.height(node__$1.getLeft());
var y__4220__auto__ = clojure.data.avl.height(new_right);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);

}
}
} else {
return null;
}
});
clojure.data.avl.delete$ = (function clojure$data$avl$delete(comp,node,k,found_QMARK_){
if((node == null)){
return null;
} else {
var nk = node.getKey();
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,nk) : comp.call(null,k,nk));
if((c === (0))){
var l = node.getLeft();
var r = node.getRight();
found_QMARK_.val = true;

if(cljs.core.truth_((function (){var and__4120__auto__ = l;
if(cljs.core.truth_(and__4120__auto__)){
return r;
} else {
return and__4120__auto__;
}
})())){
var p = clojure.data.avl.get_rightmost(l);
var l_SINGLEQUOTE_ = clojure.data.avl.delete_rightmost(l);
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,p.getKey(),p.getVal(),l_SINGLEQUOTE_,r,((function (){var x__4219__auto__ = clojure.data.avl.height(l_SINGLEQUOTE_);
var y__4220__auto__ = clojure.data.avl.height(r);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),(node.getRank() - (1)))));
} else {
var or__4131__auto__ = l;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return r;
}
}
} else {
if((c < (0))){
var new_child = (function (){var G__99411 = comp;
var G__99412 = node.getLeft();
var G__99413 = k;
var G__99414 = found_QMARK_;
return (clojure.data.avl.delete$.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.delete$.cljs$core$IFn$_invoke$arity$4(G__99411,G__99412,G__99413,G__99414) : clojure.data.avl.delete$.call(null,G__99411,G__99412,G__99413,G__99414));
})();
if((new_child === node.getLeft())){
return node;
} else {
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,nk,node.getVal(),new_child,node.getRight(),((function (){var x__4219__auto__ = clojure.data.avl.height(new_child);
var y__4220__auto__ = clojure.data.avl.height(node.getRight());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),(cljs.core.truth_(found_QMARK_.val)?(node.getRank() - (1)):node.getRank()))));
}
} else {
var new_child = (function (){var G__99415 = comp;
var G__99416 = node.getRight();
var G__99417 = k;
var G__99418 = found_QMARK_;
return (clojure.data.avl.delete$.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.delete$.cljs$core$IFn$_invoke$arity$4(G__99415,G__99416,G__99417,G__99418) : clojure.data.avl.delete$.call(null,G__99415,G__99416,G__99417,G__99418));
})();
if((new_child === node.getRight())){
return node;
} else {
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,nk,node.getVal(),node.getLeft(),new_child,((function (){var x__4219__auto__ = clojure.data.avl.height(new_child);
var y__4220__auto__ = clojure.data.avl.height(node.getLeft());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),node.getRank())));
}

}
}
}
});
clojure.data.avl.delete_BANG_ = (function clojure$data$avl$delete_BANG_(edit,comp,node,k,found_QMARK_){
if((node == null)){
return null;
} else {
var nk = node.getKey();
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,nk) : comp.call(null,k,nk));
if((c === (0))){
var l = node.getLeft();
var r = node.getRight();
found_QMARK_.val = true;

if(cljs.core.truth_((function (){var and__4120__auto__ = l;
if(cljs.core.truth_(and__4120__auto__)){
return r;
} else {
return and__4120__auto__;
}
})())){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
var p = clojure.data.avl.get_rightmost(l);
var l_SINGLEQUOTE_ = clojure.data.avl.delete_rightmost_BANG_(edit,l);
node__$1.setKey(p.getKey());

node__$1.setVal(p.getVal());

node__$1.setLeft(l_SINGLEQUOTE_);

node__$1.setHeight(((function (){var x__4219__auto__ = clojure.data.avl.height(l_SINGLEQUOTE_);
var y__4220__auto__ = clojure.data.avl.height(r);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

node__$1.setRank((node__$1.getRank() - (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);
} else {
if(cljs.core.truth_(l)){
return l;
} else {
if(cljs.core.truth_(r)){
return r;
} else {
return null;

}
}
}
} else {
if((c < (0))){
var new_child = (function (){var G__99419 = edit;
var G__99420 = comp;
var G__99421 = node.getLeft();
var G__99422 = k;
var G__99423 = found_QMARK_;
return (clojure.data.avl.delete_BANG_.cljs$core$IFn$_invoke$arity$5 ? clojure.data.avl.delete_BANG_.cljs$core$IFn$_invoke$arity$5(G__99419,G__99420,G__99421,G__99422,G__99423) : clojure.data.avl.delete_BANG_.call(null,G__99419,G__99420,G__99421,G__99422,G__99423));
})();
if(cljs.core.truth_(found_QMARK_.val)){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
node__$1.setLeft(new_child);

node__$1.setHeight(((function (){var x__4219__auto__ = clojure.data.avl.height(new_child);
var y__4220__auto__ = clojure.data.avl.height(node__$1.getRight());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

node__$1.setRank((node__$1.getRank() - (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);
} else {
return node;
}
} else {
var new_child = (function (){var G__99424 = edit;
var G__99425 = comp;
var G__99426 = node.getRight();
var G__99427 = k;
var G__99428 = found_QMARK_;
return (clojure.data.avl.delete_BANG_.cljs$core$IFn$_invoke$arity$5 ? clojure.data.avl.delete_BANG_.cljs$core$IFn$_invoke$arity$5(G__99424,G__99425,G__99426,G__99427,G__99428) : clojure.data.avl.delete_BANG_.call(null,G__99424,G__99425,G__99426,G__99427,G__99428));
})();
if(cljs.core.truth_(found_QMARK_.val)){
var node__$1 = clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$2(edit,node);
node__$1.setRight(new_child);

node__$1.setHeight(((function (){var x__4219__auto__ = clojure.data.avl.height(new_child);
var y__4220__auto__ = clojure.data.avl.height(node__$1.getLeft());
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)));

return clojure.data.avl.maybe_rebalance_BANG_(edit,node__$1);
} else {
return node;
}

}
}
}
});
clojure.data.avl.join = (function clojure$data$avl$join(comp,left_count,left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
var lh = left.getHeight();
var rh = right.getHeight();
if((lh === rh)){
var left_min = clojure.data.avl.get_rightmost(left);
var new_left = clojure.data.avl.delete$(comp,left,left_min.getKey(),(new cljs.core.Box(false)));
return (new clojure.data.avl.AVLNode(null,left_min.getKey(),left_min.getVal(),new_left,right,(rh + (1)),(left_count - (1))));
} else {
if((lh < rh)){
var step = ((function (lh,rh){
return (function clojure$data$avl$join_$_step(current,lvl){
if((lvl === (0))){
return (clojure.data.avl.join.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.join.cljs$core$IFn$_invoke$arity$4(comp,left_count,left,current) : clojure.data.avl.join.call(null,comp,left_count,left,current));
} else {
if((current.getLeft() == null)){
return (new clojure.data.avl.AVLNode(null,current.getKey(),current.getVal(),left,current.getRight(),(2),left_count));
} else {
var new_child = clojure$data$avl$join_$_step(current.getLeft(),(lvl - (1)));
var current_r = current.getRight();
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,current.getKey(),current.getVal(),new_child,current_r,((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = (cljs.core.truth_(current_r)?current_r.getHeight():(0));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),(left_count + current.getRank()))));

}
}
});})(lh,rh))
;
return step(right,(rh - lh));
} else {
var step = ((function (lh,rh){
return (function clojure$data$avl$join_$_step(current,cnt,lvl){
if((lvl === (0))){
return (clojure.data.avl.join.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.join.cljs$core$IFn$_invoke$arity$4(comp,cnt,current,right) : clojure.data.avl.join.call(null,comp,cnt,current,right));
} else {
if((current.getRight() == null)){
return (new clojure.data.avl.AVLNode(null,current.getKey(),current.getVal(),current.getLeft(),right,(2),current.getRank()));
} else {
var new_child = clojure$data$avl$join_$_step(current.getRight(),((cnt - current.getRank()) - (1)),(lvl - (1)));
var current_l = current.getLeft();
return clojure.data.avl.maybe_rebalance((new clojure.data.avl.AVLNode(null,current.getKey(),current.getVal(),current_l,new_child,((function (){var x__4219__auto__ = new_child.getHeight();
var y__4220__auto__ = (cljs.core.truth_(current_l)?current_l.getHeight():(0));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() + (1)),current.getRank())));

}
}
});})(lh,rh))
;
return step(left,left_count,(lh - rh));

}
}

}
}
});
clojure.data.avl.split = (function clojure$data$avl$split(comp,node,k){
var step = (function clojure$data$avl$split_$_step(node__$1){
if((node__$1 == null)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null);
} else {
var c = (function (){var G__99437 = k;
var G__99438 = node__$1.getKey();
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__99437,G__99438) : comp.call(null,G__99437,G__99438));
})();
if((c === (0))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [node__$1.getLeft(),(new cljs.core.MapEntry(node__$1.getKey(),node__$1.getVal(),null)),node__$1.getRight()], null);
} else {
if((c < (0))){
var vec__99439 = clojure$data$avl$split_$_step(node__$1.getLeft());
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99439,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99439,(1),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99439,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [l,e,clojure.data.avl.join(comp,(node__$1.getRank() - (cljs.core.truth_(e)?(clojure.data.avl.rank(comp,node__$1.getLeft(),cljs.core.key(e)) + (1)):(cljs.core.truth_(r)?clojure.data.avl.rank(comp,node__$1.getLeft(),clojure.data.avl.get_leftmost(r).getKey()):node__$1.getRank()
))),r,clojure.data.avl.insert(comp,node__$1.getRight(),node__$1.getKey(),node__$1.getVal(),(new cljs.core.Box(false))))], null);
} else {
var vec__99442 = clojure$data$avl$split_$_step(node__$1.getRight());
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99442,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99442,(1),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99442,(2),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.data.avl.join(comp,(node__$1.getRank() + (1)),clojure.data.avl.insert(comp,node__$1.getLeft(),node__$1.getKey(),node__$1.getVal(),(new cljs.core.Box(false))),l),e,r], null);

}
}
}
});
return step(node);
});
clojure.data.avl.range = (function clojure$data$avl$range(comp,node,low,high){
var vec__99445 = clojure.data.avl.split(comp,node,low);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99445,(0),null);
var low_e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99445,(1),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99445,(2),null);
var vec__99448 = clojure.data.avl.split(comp,r,high);
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99448,(0),null);
var high_e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99448,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99448,(2),null);
var G__99451 = l;
var G__99451__$1 = (cljs.core.truth_(low_e)?(function (){var node__$1 = G__99451;
return clojure.data.avl.insert(comp,node__$1,cljs.core.key(low_e),cljs.core.val(low_e),(new cljs.core.Box(false)));
})():G__99451);
if(cljs.core.truth_(high_e)){
var node__$1 = G__99451__$1;
return clojure.data.avl.insert(comp,node__$1,cljs.core.key(high_e),cljs.core.val(high_e),(new cljs.core.Box(false)));
} else {
return G__99451__$1;
}
});
clojure.data.avl.seq_push = (function clojure$data$avl$seq_push(node,stack,ascending_QMARK_){
var node__$1 = node;
var stack__$1 = stack;
while(true){
if((node__$1 == null)){
return stack__$1;
} else {
var G__99452 = (cljs.core.truth_(ascending_QMARK_)?node__$1.left:node__$1.right);
var G__99453 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,node__$1);
node__$1 = G__99452;
stack__$1 = G__99453;
continue;
}
break;
}
});
clojure.data.avl.create_seq = (function clojure$data$avl$create_seq(node,ascending_QMARK_,cnt){
var G__99454 = null;
var G__99455 = clojure.data.avl.seq_push(node,null,ascending_QMARK_);
var G__99456 = ascending_QMARK_;
var G__99457 = cnt;
var G__99458 = null;
return (clojure.data.avl.__GT_AVLMapSeq.cljs$core$IFn$_invoke$arity$5 ? clojure.data.avl.__GT_AVLMapSeq.cljs$core$IFn$_invoke$arity$5(G__99454,G__99455,G__99456,G__99457,G__99458) : clojure.data.avl.__GT_AVLMapSeq.call(null,G__99454,G__99455,G__99456,G__99457,G__99458));
});
clojure.data.avl.avl_map_kv_reduce = (function clojure$data$avl$avl_map_kv_reduce(node,f,init){
while(true){
var init__$1 = (((node.getLeft() == null))?init:(function (){var G__99459 = node.getLeft();
var G__99460 = f;
var G__99461 = init;
return (clojure.data.avl.avl_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? clojure.data.avl.avl_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__99459,G__99460,G__99461) : clojure.data.avl.avl_map_kv_reduce.call(null,G__99459,G__99460,G__99461));
})());
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__99462 = init__$1;
var G__99463 = node.getKey();
var G__99464 = node.getVal();
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__99462,G__99463,G__99464) : f.call(null,G__99462,G__99463,G__99464));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((node.getRight() == null)){
return init__$2;
} else {
var G__99465 = node.getRight();
var G__99466 = f;
var G__99467 = init__$2;
node = G__99465;
f = G__99466;
init = G__99467;
continue;
}
}
}
break;
}
});
clojure.data.avl.avl_map_reduce = (function clojure$data$avl$avl_map_reduce(node,f,init){
while(true){
var init__$1 = (((node.getLeft() == null))?init:(function (){var G__99468 = node.getLeft();
var G__99469 = f;
var G__99470 = init;
return (clojure.data.avl.avl_map_reduce.cljs$core$IFn$_invoke$arity$3 ? clojure.data.avl.avl_map_reduce.cljs$core$IFn$_invoke$arity$3(G__99468,G__99469,G__99470) : clojure.data.avl.avl_map_reduce.call(null,G__99468,G__99469,G__99470));
})());
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__99471 = init__$1;
var G__99472 = (new cljs.core.MapEntry(node.getKey(),node.getVal(),null));
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__99471,G__99472) : f.call(null,G__99471,G__99472));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((node.getRight() == null)){
return init__$2;
} else {
var G__99473 = node.getRight();
var G__99474 = f;
var G__99475 = init__$2;
node = G__99473;
f = G__99474;
init = G__99475;
continue;
}
}
}
break;
}
});
clojure.data.avl.avl_map_reduce_skip = (function clojure$data$avl$avl_map_reduce_skip(node,f,init,skip_node){
while(true){
var init__$1 = (((node.getLeft() == null))?init:(function (){var G__99476 = node.getLeft();
var G__99477 = f;
var G__99478 = init;
var G__99479 = skip_node;
return (clojure.data.avl.avl_map_reduce_skip.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.avl_map_reduce_skip.cljs$core$IFn$_invoke$arity$4(G__99476,G__99477,G__99478,G__99479) : clojure.data.avl.avl_map_reduce_skip.call(null,G__99476,G__99477,G__99478,G__99479));
})());
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
if((skip_node === node)){
if((node.getRight() == null)){
return init__$1;
} else {
return clojure.data.avl.avl_map_reduce(node.getRight(),f,init__$1);
}
} else {
var init__$2 = (function (){var G__99480 = init__$1;
var G__99481 = (new cljs.core.MapEntry(node.getKey(),node.getVal(),null));
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__99480,G__99481) : f.call(null,G__99480,G__99481));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((node.getRight() == null)){
return init__$2;
} else {
var G__99482 = node.getRight();
var G__99483 = f;
var G__99484 = init__$2;
var G__99485 = skip_node;
node = G__99482;
f = G__99483;
init = G__99484;
skip_node = G__99485;
continue;
}
}
}
}
break;
}
});
clojure.data.avl.avl_set_reduce = (function clojure$data$avl$avl_set_reduce(node,f,init){
while(true){
var init__$1 = (((node.getLeft() == null))?init:(function (){var G__99486 = node.getLeft();
var G__99487 = f;
var G__99488 = init;
return (clojure.data.avl.avl_set_reduce.cljs$core$IFn$_invoke$arity$3 ? clojure.data.avl.avl_set_reduce.cljs$core$IFn$_invoke$arity$3(G__99486,G__99487,G__99488) : clojure.data.avl.avl_set_reduce.call(null,G__99486,G__99487,G__99488));
})());
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__99489 = init__$1;
var G__99490 = node.getKey();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__99489,G__99490) : f.call(null,G__99489,G__99490));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((node.getRight() == null)){
return init__$2;
} else {
var G__99491 = node.getRight();
var G__99492 = f;
var G__99493 = init__$2;
node = G__99491;
f = G__99492;
init = G__99493;
continue;
}
}
}
break;
}
});
clojure.data.avl.avl_set_reduce_skip = (function clojure$data$avl$avl_set_reduce_skip(node,f,init,skip_node){
var init__$1 = (((node.getLeft() == null))?init:(function (){var G__99494 = node.getLeft();
var G__99495 = f;
var G__99496 = init;
var G__99497 = skip_node;
return (clojure.data.avl.avl_set_reduce_skip.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.avl_set_reduce_skip.cljs$core$IFn$_invoke$arity$4(G__99494,G__99495,G__99496,G__99497) : clojure.data.avl.avl_set_reduce_skip.call(null,G__99494,G__99495,G__99496,G__99497));
})());
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
if((skip_node === node)){
if((node.getRight() == null)){
return init__$1;
} else {
return clojure.data.avl.avl_set_reduce(node.getRight(),f,init__$1);
}
} else {
var init__$2 = (function (){var G__99498 = init__$1;
var G__99499 = node.getKey();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__99498,G__99499) : f.call(null,G__99498,G__99499));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((node.getRight() == null)){
return init__$2;
} else {
return clojure.data.avl.avl_set_reduce(node.getRight(),f,init__$2);
}
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {clojure.data.avl.Object}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
clojure.data.avl.AVLMapSeq = (function (_meta,stack,ascending_QMARK_,cnt,_hash){
this._meta = _meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
clojure.data.avl.AVLMapSeq.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str_STAR_(this$);
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__._meta;
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._seq(this$__$1.cljs$core$ISeq$_rest$arity$1(null));
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.cnt < (0))){
return (cljs.core._count(this$__$1.cljs$core$INext$_next$arity$1(null)) + (1));
} else {
return self__.cnt;
}
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4243__auto__ = self__._hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_coll(this$__$1);
self__._hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,that){
var self__ = this;
var this$__$1 = this;
return cljs.core.equiv_sequential(this$__$1,that);
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f){
var self__ = this;
var this$__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,this$__$1);
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (this$,f,start){
var self__ = this;
var this$__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,this$__$1);
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var node = cljs.core.peek(self__.stack);
return (new cljs.core.MapEntry(node.key,node.val,null));
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var node = cljs.core.first(self__.stack);
var next_stack = clojure.data.avl.seq_push((cljs.core.truth_(self__.ascending_QMARK_)?node.right:node.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return cljs.core.List.EMPTY;
} else {
return (new clojure.data.avl.AVLMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLMapSeq(meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__._hash));
});

clojure.data.avl.AVLMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(x,this$__$1);
});

clojure.data.avl.AVLMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_meta,cljs.core.cst$sym$stack,cljs.core.cst$sym$ascending_QMARK_,cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLMapSeq.cljs$lang$type = true;

clojure.data.avl.AVLMapSeq.cljs$lang$ctorStr = "clojure.data.avl/AVLMapSeq";

clojure.data.avl.AVLMapSeq.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLMapSeq");
});

/**
 * Positional factory function for clojure.data.avl/AVLMapSeq.
 */
clojure.data.avl.__GT_AVLMapSeq = (function clojure$data$avl$__GT_AVLMapSeq(_meta,stack,ascending_QMARK_,cnt,_hash){
return (new clojure.data.avl.AVLMapSeq(_meta,stack,ascending_QMARK_,cnt,_hash));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {clojure.data.avl.Object}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
clojure.data.avl.AVLMap = (function (comp,tree,cnt,_meta,_hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this._meta = _meta;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 419301151;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
clojure.data.avl.AVLMap.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str_STAR_(this$);
});

clojure.data.avl.AVLMap.prototype.getTree = (function (){
var self__ = this;
var this$ = this;
return self__.tree;
});

clojure.data.avl.AVLMap.prototype.nearest = (function (test,k){
var self__ = this;
var this$ = this;
var temp__5733__auto__ = clojure.data.avl.lookup_nearest(self__.comp,self__.tree,test,k);
if(cljs.core.truth_(temp__5733__auto__)){
var node = temp__5733__auto__;
return (new cljs.core.MapEntry(node.getKey(),node.getVal(),null));
} else {
return null;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return this$__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

clojure.data.avl.AVLMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,not_found){
var self__ = this;
var this$__$1 = this;
var n = clojure.data.avl.lookup(self__.comp,self__.tree,k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
if((self__.tree == null)){
return init;
} else {
var init__$1 = clojure.data.avl.avl_map_kv_reduce(self__.tree,f,init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
return init__$1;
}
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,i){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = clojure.data.avl.select(self__.tree,i);
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return (new cljs.core.MapEntry(n.getKey(),n.getVal(),null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("nth index out of bounds in AVL tree",cljs.core.PersistentArrayMap.EMPTY);
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,i,not_found){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = clojure.data.avl.select(self__.tree,i);
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return (new cljs.core.MapEntry(n.getKey(),n.getVal(),null));
} else {
return not_found;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__._meta;
});

clojure.data.avl.AVLMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.cnt;
});

clojure.data.avl.AVLMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.cnt > (0))){
return clojure.data.avl.create_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4243__auto__ = self__._hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
self__._hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,that){
var self__ = this;
var this$__$1 = this;
return cljs.core.equiv_map(this$__$1,that);
});

clojure.data.avl.AVLMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__99501 = ({});
var G__99502 = self__.comp;
var G__99503 = self__.tree;
var G__99504 = self__.cnt;
return (clojure.data.avl.__GT_AVLTransientMap.cljs$core$IFn$_invoke$arity$4 ? clojure.data.avl.__GT_AVLTransientMap.cljs$core$IFn$_invoke$arity$4(G__99501,G__99502,G__99503,G__99504) : clojure.data.avl.__GT_AVLTransientMap.call(null,G__99501,G__99502,G__99503,G__99504));
});

clojure.data.avl.AVLMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLMap(self__.comp,null,(0),self__._meta,(0)));
});

clojure.data.avl.AVLMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f){
var self__ = this;
var this$__$1 = this;
var G__99507 = self__.cnt;
switch (G__99507) {
case (0):
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));

break;
case (1):
return (new cljs.core.MapEntry(self__.tree.getKey(),self__.tree.getVal(),null));

break;
default:
var n0 = clojure.data.avl.select(self__.tree,(0));
var init = clojure.data.avl.avl_map_reduce_skip(self__.tree,f,(new cljs.core.MapEntry(n0.getKey(),n0.getVal(),null)),n0);
if(cljs.core.reduced_QMARK_(init)){
return init.cljs$core$IDeref$_deref$arity$1(null);
} else {
return init;
}

}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
if((self__.tree == null)){
return init;
} else {
var init__$1 = clojure.data.avl.avl_map_reduce(self__.tree,f,init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1.cljs$core$IDeref$_deref$arity$1(null);
} else {
return init__$1;
}
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
var found_QMARK_ = (new cljs.core.Box(false));
var new_tree = clojure.data.avl.delete$(self__.comp,self__.tree,k,found_QMARK_);
if(cljs.core.truth_(found_QMARK_.val)){
return (new clojure.data.avl.AVLMap(self__.comp,new_tree,(self__.cnt - (1)),self__._meta,null));
} else {
return this$__$1;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,k,v){
var self__ = this;
var this$__$1 = this;
var found_QMARK_ = (new cljs.core.Box(false));
var new_tree = clojure.data.avl.insert(self__.comp,self__.tree,k,v,found_QMARK_);
return (new clojure.data.avl.AVLMap(self__.comp,new_tree,(cljs.core.truth_(found_QMARK_.val)?self__.cnt:(self__.cnt + (1))),self__._meta,null));
});

clojure.data.avl.AVLMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return (!((clojure.data.avl.lookup(self__.comp,self__.tree,k) == null)));
});

clojure.data.avl.AVLMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.cnt > (0))){
return clojure.data.avl.create_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLMap(self__.comp,self__.tree,self__.cnt,meta,self__._hash));
});

clojure.data.avl.AVLMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
});

clojure.data.avl.AVLMap.prototype.call = (function() {
var G__99513 = null;
var G__99513__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__99513__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__99513 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__99513__2.call(this,self__,k);
case 3:
return G__99513__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__99513.cljs$core$IFn$_invoke$arity$2 = G__99513__2;
G__99513.cljs$core$IFn$_invoke$arity$3 = G__99513__3;
return G__99513;
})()
;

clojure.data.avl.AVLMap.prototype.apply = (function (self__,args99500){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args99500)));
});

clojure.data.avl.AVLMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});

clojure.data.avl.AVLMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

clojure.data.avl.AVLMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
if((self__.cnt > (0))){
return clojure.data.avl.create_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__99510 = k;
var G__99511 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__99510,G__99511) : self__.comp.call(null,G__99510,G__99511));
})();
if((c === (0))){
return (new clojure.data.avl.AVLMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__99514 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__99515 = t.left;
stack = G__99514;
t = G__99515;
continue;
} else {
var G__99516 = stack;
var G__99517 = t.right;
stack = G__99516;
t = G__99517;
continue;
}
} else {
if((c > (0))){
var G__99518 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__99519 = t.right;
stack = G__99518;
t = G__99519;
continue;
} else {
var G__99520 = stack;
var G__99521 = t.left;
stack = G__99520;
t = G__99521;
continue;
}

}
}
} else {
if((!((stack == null)))){
return (new clojure.data.avl.AVLMapSeq(null,stack,ascending_QMARK_,(-1),null));
} else {
return null;
}
}
break;
}
} else {
return null;
}
});

clojure.data.avl.AVLMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return cljs.core.key(entry);
});

clojure.data.avl.AVLMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.comp;
});

clojure.data.avl.AVLMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$_meta,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLMap.cljs$lang$type = true;

clojure.data.avl.AVLMap.cljs$lang$ctorStr = "clojure.data.avl/AVLMap";

clojure.data.avl.AVLMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLMap");
});

/**
 * Positional factory function for clojure.data.avl/AVLMap.
 */
clojure.data.avl.__GT_AVLMap = (function clojure$data$avl$__GT_AVLMap(comp,tree,cnt,_meta,_hash){
return (new clojure.data.avl.AVLMap(comp,tree,cnt,_meta,_hash));
});


/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
clojure.data.avl.AVLTransientMap = (function (edit,comp,tree,cnt){
this.edit = edit;
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
clojure.data.avl.AVLTransientMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.cnt;
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return this$__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,not_found){
var self__ = this;
var this$__$1 = this;
var n = clojure.data.avl.lookup(self__.comp,self__.tree,k);
if((!((n == null)))){
return n.getVal();
} else {
return not_found;
}
});

clojure.data.avl.AVLTransientMap.prototype.call = (function() {
var G__99523 = null;
var G__99523__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__99523__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__99523 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__99523__2.call(this,self__,k);
case 3:
return G__99523__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__99523.cljs$core$IFn$_invoke$arity$2 = G__99523__2;
G__99523.cljs$core$IFn$_invoke$arity$3 = G__99523__3;
return G__99523;
})()
;

clojure.data.avl.AVLTransientMap.prototype.apply = (function (self__,args99522){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args99522)));
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj_BANG_,this$__$1,entry);
}
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$1(self__.edit);

self__.edit = null;

return (new clojure.data.avl.AVLMap(self__.comp,self__.tree,self__.cnt,null,null));
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (this$,k,v){
var self__ = this;
var this$__$1 = this;
clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$1(self__.edit);

var found_QMARK_ = (new cljs.core.Box(false));
var new_tree = clojure.data.avl.insert_BANG_(self__.edit,self__.comp,self__.tree,k,v,found_QMARK_);
self__.tree = new_tree;

if(cljs.core.not(found_QMARK_.val)){
self__.cnt = (self__.cnt + (1));
} else {
}

return this$__$1;
});

clojure.data.avl.AVLTransientMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
clojure.data.avl.ensure_editable.cljs$core$IFn$_invoke$arity$1(self__.edit);

var found_QMARK_ = (new cljs.core.Box(false));
var new_tree = clojure.data.avl.delete_BANG_(self__.edit,self__.comp,self__.tree,k,found_QMARK_);
if(cljs.core.truth_(found_QMARK_.val)){
self__.tree = new_tree;

self__.cnt = (self__.cnt - (1));
} else {
}

return this$__$1;
});

clojure.data.avl.AVLTransientMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$comp,cljs.core.with_meta(cljs.core.cst$sym$tree,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLTransientMap.cljs$lang$type = true;

clojure.data.avl.AVLTransientMap.cljs$lang$ctorStr = "clojure.data.avl/AVLTransientMap";

clojure.data.avl.AVLTransientMap.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLTransientMap");
});

/**
 * Positional factory function for clojure.data.avl/AVLTransientMap.
 */
clojure.data.avl.__GT_AVLTransientMap = (function clojure$data$avl$__GT_AVLTransientMap(edit,comp,tree,cnt){
return (new clojure.data.avl.AVLTransientMap(edit,comp,tree,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {clojure.data.avl.Object}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
clojure.data.avl.AVLSet = (function (_meta,avl_map,_hash){
this._meta = _meta;
this.avl_map = avl_map;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 418255135;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
clojure.data.avl.AVLSet.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str_STAR_(this$);
});

clojure.data.avl.AVLSet.prototype.getTree = (function (){
var self__ = this;
var this$ = this;
return self__.avl_map.tree;
});

clojure.data.avl.AVLSet.prototype.nearest = (function (test,k){
var self__ = this;
var this$ = this;
var temp__5733__auto__ = clojure.data.avl.lookup_nearest(self__.avl_map.comp,self__.avl_map.getTree(),test,k);
if(cljs.core.truth_(temp__5733__auto__)){
var node = temp__5733__auto__;
return node.getKey();
} else {
return null;
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,v){
var self__ = this;
var this$__$1 = this;
return this$__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

clojure.data.avl.AVLSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,v,not_found){
var self__ = this;
var this$__$1 = this;
var n = clojure.data.avl.lookup(self__.avl_map.comp,self__.avl_map.tree,v);
if((!((n == null)))){
return n.key;
} else {
return not_found;
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,i){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = clojure.data.avl.select(self__.avl_map.tree,i);
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return n.getVal();
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("nth index out of bounds in AVL tree",cljs.core.PersistentArrayMap.EMPTY);
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,i,not_found){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = clojure.data.avl.select(self__.avl_map.tree,i);
if(cljs.core.truth_(temp__5733__auto__)){
var n = temp__5733__auto__;
return n.getVal();
} else {
return not_found;
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__._meta;
});

clojure.data.avl.AVLSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._count(self__.avl_map);
});

clojure.data.avl.AVLSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.avl_map));
});

clojure.data.avl.AVLSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4243__auto__ = self__._hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
self__._hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,that){
var self__ = this;
var this$__$1 = this;
return ((cljs.core.set_QMARK_(that)) && ((cljs.core.count(this$__$1) === cljs.core.count(that))) && (cljs.core.every_QMARK_(((function (this$__$1){
return (function (p1__99524_SHARP_){
return cljs.core.contains_QMARK_(this$__$1,p1__99524_SHARP_);
});})(this$__$1))
,that)));
});

clojure.data.avl.AVLSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__99526 = cljs.core._as_transient(self__.avl_map);
return (clojure.data.avl.__GT_AVLTransientSet.cljs$core$IFn$_invoke$arity$1 ? clojure.data.avl.__GT_AVLTransientSet.cljs$core$IFn$_invoke$arity$1(G__99526) : clojure.data.avl.__GT_AVLTransientSet.call(null,G__99526));
});

clojure.data.avl.AVLSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLSet(self__._meta,cljs.core.empty(self__.avl_map),(0)));
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (this$,v){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLSet(self__._meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.avl_map,v),null));
});

clojure.data.avl.AVLSet.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (this$,f){
var self__ = this;
var this$__$1 = this;
var G__99527 = cljs.core._count(self__.avl_map);
switch (G__99527) {
case (0):
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));

break;
case (1):
return self__.avl_map.getTree().getKey();

break;
default:
var tree = self__.avl_map.getTree();
var n0 = clojure.data.avl.select(tree,(0));
var init = clojure.data.avl.avl_set_reduce_skip(tree,f,n0.getKey(),n0);
if(cljs.core.reduced_QMARK_(init)){
return init.cljs$core$IDeref$_deref$arity$1(null);
} else {
return init;
}

}
});

clojure.data.avl.AVLSet.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (this$,f,init){
var self__ = this;
var this$__$1 = this;
var tree = self__.avl_map.getTree();
if((tree == null)){
return init;
} else {
var init__$1 = clojure.data.avl.avl_set_reduce(tree,f,init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1.cljs$core$IDeref$_deref$arity$1(null);
} else {
return init__$1;
}
}
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.keys(self__.avl_map);
});

clojure.data.avl.AVLSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLSet(meta,self__.avl_map,self__._hash));
});

clojure.data.avl.AVLSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return (new clojure.data.avl.AVLSet(self__._meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.avl_map,x,x),null));
});

clojure.data.avl.AVLSet.prototype.call = (function() {
var G__99529 = null;
var G__99529__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__99529__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__99529 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__99529__2.call(this,self__,k);
case 3:
return G__99529__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__99529.cljs$core$IFn$_invoke$arity$2 = G__99529__2;
G__99529.cljs$core$IFn$_invoke$arity$3 = G__99529__3;
return G__99529;
})()
;

clojure.data.avl.AVLSet.prototype.apply = (function (self__,args99525){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args99525)));
});

clojure.data.avl.AVLSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,k);
});

clojure.data.avl.AVLSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return cljs.core.keys(cljs.core._sorted_seq(self__.avl_map,ascending_QMARK_));
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return cljs.core.keys(cljs.core._sorted_seq_from(self__.avl_map,k,ascending_QMARK_));
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return entry;
});

clojure.data.avl.AVLSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._comparator(self__.avl_map);
});

clojure.data.avl.AVLSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_meta,cljs.core.cst$sym$avl_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLSet.cljs$lang$type = true;

clojure.data.avl.AVLSet.cljs$lang$ctorStr = "clojure.data.avl/AVLSet";

clojure.data.avl.AVLSet.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLSet");
});

/**
 * Positional factory function for clojure.data.avl/AVLSet.
 */
clojure.data.avl.__GT_AVLSet = (function clojure$data$avl$__GT_AVLSet(_meta,avl_map,_hash){
return (new clojure.data.avl.AVLSet(_meta,avl_map,_hash));
});


/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
clojure.data.avl.AVLTransientSet = (function (transient_avl_map){
this.transient_avl_map = transient_avl_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
});
clojure.data.avl.AVLTransientSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
self__.transient_avl_map = cljs.core._assoc_BANG_(self__.transient_avl_map,k,k);

return this$__$1;
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.transient_avl_map.edit == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("persistent! used twice",cljs.core.PersistentArrayMap.EMPTY);
} else {
return (new clojure.data.avl.AVLSet(null,cljs.core._persistent_BANG_(self__.transient_avl_map),null));
}
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
self__.transient_avl_map = cljs.core._dissoc_BANG_(self__.transient_avl_map,k);

return this$__$1;
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._count(self__.transient_avl_map);
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return this$__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,not_found){
var self__ = this;
var this$__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_avl_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

clojure.data.avl.AVLTransientSet.prototype.call = (function() {
var G__99531 = null;
var G__99531__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.transient_avl_map,k);
});
var G__99531__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_avl_map,k,not_found);
});
G__99531 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__99531__2.call(this,self__,k);
case 3:
return G__99531__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__99531.cljs$core$IFn$_invoke$arity$2 = G__99531__2;
G__99531.cljs$core$IFn$_invoke$arity$3 = G__99531__3;
return G__99531;
})()
;

clojure.data.avl.AVLTransientSet.prototype.apply = (function (self__,args99530){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args99530)));
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var this$ = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.transient_avl_map,k);
});

clojure.data.avl.AVLTransientSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_avl_map,k,not_found);
});

clojure.data.avl.AVLTransientSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_avl_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

clojure.data.avl.AVLTransientSet.cljs$lang$type = true;

clojure.data.avl.AVLTransientSet.cljs$lang$ctorStr = "clojure.data.avl/AVLTransientSet";

clojure.data.avl.AVLTransientSet.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"clojure.data.avl/AVLTransientSet");
});

/**
 * Positional factory function for clojure.data.avl/AVLTransientSet.
 */
clojure.data.avl.__GT_AVLTransientSet = (function clojure$data$avl$__GT_AVLTransientSet(transient_avl_map){
return (new clojure.data.avl.AVLTransientSet(transient_avl_map));
});

clojure.data.avl.empty_map = (new clojure.data.avl.AVLMap(cljs.core.compare,null,(0),null,(0)));
clojure.data.avl.empty_set = (new clojure.data.avl.AVLSet(null,clojure.data.avl.empty_map,(0)));
clojure.data.avl.AVLMapSeq.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

clojure.data.avl.AVLMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this$__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,this$__$1);
});

clojure.data.avl.AVLMap.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

clojure.data.avl.AVLMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this$__$1 = this;
var pr_pair = ((function (this$__$1){
return (function clojure$data$avl$pr_pair(keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});})(this$__$1))
;
return cljs.core.pr_sequential_writer(writer,pr_pair,"{",", ","}",opts,this$__$1);
});

clojure.data.avl.AVLSet.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

clojure.data.avl.AVLSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this$__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,this$__$1);
});
/**
 * keyval => key val
 *   Returns a new AVL map with supplied mappings.
 */
clojure.data.avl.sorted_map = (function clojure$data$avl$sorted_map(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99533 = arguments.length;
var i__4731__auto___99534 = (0);
while(true){
if((i__4731__auto___99534 < len__4730__auto___99533)){
args__4736__auto__.push((arguments[i__4731__auto___99534]));

var G__99535 = (i__4731__auto___99534 + (1));
i__4731__auto___99534 = G__99535;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return clojure.data.avl.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

clojure.data.avl.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(clojure.data.avl.empty_map);
while(true){
if(in$){
var temp__5733__auto__ = cljs.core.next(in$);
if(temp__5733__auto__){
var nin = temp__5733__auto__;
var G__99536 = cljs.core.next(nin);
var G__99537 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.first(nin));
in$ = G__99536;
out = G__99537;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["sorted-map: no value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(in$))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

clojure.data.avl.sorted_map.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
clojure.data.avl.sorted_map.cljs$lang$applyTo = (function (seq99532){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq99532));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied
 *   comparator.
 */
clojure.data.avl.sorted_map_by = (function clojure$data$avl$sorted_map_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99544 = arguments.length;
var i__4731__auto___99545 = (0);
while(true){
if((i__4731__auto___99545 < len__4730__auto___99544)){
args__4736__auto__.push((arguments[i__4731__auto___99545]));

var G__99546 = (i__4731__auto___99545 + (1));
i__4731__auto___99545 = G__99546;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new clojure.data.avl.AVLTransientMap(({}),cljs.core.fn__GT_comparator(comparator),null,(0)));
while(true){
if(in$){
var temp__5733__auto__ = cljs.core.next(in$);
if(temp__5733__auto__){
var nin = temp__5733__auto__;
var G__99547 = cljs.core.next(nin);
var G__99548 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.first(nin));
in$ = G__99547;
out = G__99548;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["sorted-map-by: no value supplied for key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(in$))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

clojure.data.avl.sorted_map_by.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
clojure.data.avl.sorted_map_by.cljs$lang$applyTo = (function (seq99538){
var G__99539 = cljs.core.first(seq99538);
var seq99538__$1 = cljs.core.next(seq99538);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__99539,seq99538__$1);
});

/**
 * Returns a new sorted set with supplied keys.
 */
clojure.data.avl.sorted_set = (function clojure$data$avl$sorted_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99550 = arguments.length;
var i__4731__auto___99551 = (0);
while(true){
if((i__4731__auto___99551 < len__4730__auto___99550)){
args__4736__auto__.push((arguments[i__4731__auto___99551]));

var G__99552 = (i__4731__auto___99551 + (1));
i__4731__auto___99551 = G__99552;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return clojure.data.avl.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

clojure.data.avl.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj_BANG_,cljs.core.transient$(clojure.data.avl.empty_set),keys));
});

clojure.data.avl.sorted_set.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
clojure.data.avl.sorted_set.cljs$lang$applyTo = (function (seq99549){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq99549));
});

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
clojure.data.avl.sorted_set_by = (function clojure$data$avl$sorted_set_by(var_args){
var args__4736__auto__ = [];
var len__4730__auto___99555 = arguments.length;
var i__4731__auto___99556 = (0);
while(true){
if((i__4731__auto___99556 < len__4730__auto___99555)){
args__4736__auto__.push((arguments[i__4731__auto___99556]));

var G__99557 = (i__4731__auto___99556 + (1));
i__4731__auto___99556 = G__99557;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return clojure.data.avl.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

clojure.data.avl.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj_BANG_,(new clojure.data.avl.AVLTransientSet(cljs.core._as_transient(clojure.data.avl.sorted_map_by(cljs.core.fn__GT_comparator(comparator))))),keys));
});

clojure.data.avl.sorted_set_by.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
clojure.data.avl.sorted_set_by.cljs$lang$applyTo = (function (seq99553){
var G__99554 = cljs.core.first(seq99553);
var seq99553__$1 = cljs.core.next(seq99553);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__99554,seq99553__$1);
});

/**
 * Returns the rank of x in coll or -1 if not present.
 */
clojure.data.avl.rank_of = (function clojure$data$avl$rank_of(coll,x){
return clojure.data.avl.rank(cljs.core._comparator(coll),coll.getTree(),x);
});
/**
 * (alpha)
 * 
 *   Equivalent to, but more efficient than, (first (subseq* coll test x)),
 *   where subseq* is clojure.core/subseq for test in #{>, >=} and
 *   clojure.core/rsubseq for test in #{<, <=}.
 */
clojure.data.avl.nearest = (function clojure$data$avl$nearest(coll,test,x){
return coll.nearest(test,x);
});
/**
 * (alpha)
 * 
 *   Returns [left e? right], where left and right are collections of
 *   the same type as coll and containing, respectively, the keys below
 *   and above k in the ordering determined by coll's comparator, while
 *   e? is the entry at key k for maps, the stored copy of the key k for
 *   sets, nil if coll does not contain k.
 */
clojure.data.avl.split_key = (function clojure$data$avl$split_key(k,coll){
var comp = cljs.core._comparator(coll);
var vec__99558 = clojure.data.avl.split(comp,coll.getTree(),k);
var left = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99558,(0),null);
var e_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99558,(1),null);
var right = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99558,(2),null);
var keyfn = ((cljs.core.map_QMARK_(coll))?cljs.core.key:cljs.core.identity);
var wrap = ((cljs.core.map_QMARK_(coll))?((function (comp,vec__99558,left,e_QMARK_,right,keyfn){
return (function clojure$data$avl$split_key_$_wrap_map(tree,cnt){
return (new clojure.data.avl.AVLMap(comp,tree,cnt,null,(-1)));
});})(comp,vec__99558,left,e_QMARK_,right,keyfn))
:((function (comp,vec__99558,left,e_QMARK_,right,keyfn){
return (function clojure$data$avl$split_key_$_wrap_set(tree,cnt){
return (new clojure.data.avl.AVLSet(null,(new clojure.data.avl.AVLMap(comp,tree,cnt,null,(-1))),(-1)));
});})(comp,vec__99558,left,e_QMARK_,right,keyfn))
);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__99561 = left;
var G__99562 = (cljs.core.truth_((function (){var or__4131__auto__ = e_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return right;
}
})())?clojure.data.avl.rank_of(coll,(function (){var G__99563 = clojure.data.avl.nearest(coll,cljs.core._GT__EQ_,k);
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__99563) : keyfn.call(null,G__99563));
})()):cljs.core.count(coll));
return (wrap.cljs$core$IFn$_invoke$arity$2 ? wrap.cljs$core$IFn$_invoke$arity$2(G__99561,G__99562) : wrap.call(null,G__99561,G__99562));
})(),(cljs.core.truth_((function (){var and__4120__auto__ = e_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.set_QMARK_(coll);
} else {
return and__4120__auto__;
}
})())?cljs.core.key(e_QMARK_):e_QMARK_),(function (){var G__99564 = right;
var G__99565 = (cljs.core.truth_(right)?(cljs.core.count(coll) - clojure.data.avl.rank_of(coll,(function (){var G__99566 = clojure.data.avl.nearest(coll,cljs.core._GT_,k);
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__99566) : keyfn.call(null,G__99566));
})())):(0));
return (wrap.cljs$core$IFn$_invoke$arity$2 ? wrap.cljs$core$IFn$_invoke$arity$2(G__99564,G__99565) : wrap.call(null,G__99564,G__99565));
})()], null);
});
/**
 * (alpha)
 * 
 *   Equivalent to, but more efficient than,
 *   [(into (empty coll) (take n coll))
 * (into (empty coll) (drop n coll))].
 */
clojure.data.avl.split_at = (function clojure$data$avl$split_at(n,coll){
if((n >= cljs.core.count(coll))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll,cljs.core.empty(coll)], null);
} else {
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,n);
var k__$1 = ((cljs.core.map_QMARK_(coll))?cljs.core.key(k):k);
var vec__99567 = clojure.data.avl.split_key(k__$1,coll);
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99567,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99567,(1),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99567,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [l,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(r,e)], null);
}
});
/**
 * (alpha)
 * 
 *   Returns an AVL collection comprising the entries of coll between
 *   start and end (in the sense determined by coll's comparator) in
 *   logarithmic time. Whether the endpoints are themselves included in
 *   the returned collection depends on the provided tests; start-test
 *   must be either > or >=, end-test must be either < or <=.
 * 
 *   When passed a single test and limit, subrange infers the other end
 *   of the range from the test: > / >= mean to include items up to the
 *   end of coll, < / <= mean to include items taken from the beginning
 *   of coll.
 * 
 *   (subrange coll >= start <= end) is equivalent to, but more efficient
 *   than, (into (empty coll) (subseq coll >= start <= end).
 */
clojure.data.avl.subrange = (function clojure$data$avl$subrange(var_args){
var G__99571 = arguments.length;
switch (G__99571) {
case 3:
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3 = (function (coll,test,limit){
if((cljs.core.count(coll) === (0))){
return coll;
} else {
var comp = cljs.core._comparator(coll);
if(cljs.core.truth_((function (){var fexpr__99572 = cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._GT_,cljs.core._GT__EQ_]);
return (fexpr__99572.cljs$core$IFn$_invoke$arity$1 ? fexpr__99572.cljs$core$IFn$_invoke$arity$1(test) : fexpr__99572.call(null,test));
})())){
var n = clojure.data.avl.select(coll.getTree(),(cljs.core.count(coll) - (1)));
var k = n.getKey();
if(((comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(limit,k) : comp.call(null,limit,k)) > (0))){
return cljs.core.empty(coll);
} else {
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(coll,test,limit,cljs.core._LT__EQ_,k);
}
} else {
var n = clojure.data.avl.select(coll.getTree(),(0));
var k = n.getKey();
if(((comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(limit,k) : comp.call(null,limit,k)) < (0))){
return cljs.core.empty(coll);
} else {
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(coll,cljs.core._GT__EQ_,k,test,limit);
}
}
}
});

clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5 = (function (coll,start_test,start,end_test,end){
if((cljs.core.count(coll) === (0))){
return coll;
} else {
var comp = cljs.core._comparator(coll);
if(((comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(start,end) : comp.call(null,start,end)) > (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("start greater than end in subrange",cljs.core.PersistentArrayMap.EMPTY);
} else {
var input_tree = coll.getTree();
var l = clojure.data.avl.lookup_nearest(comp,input_tree,start_test,start);
var h = clojure.data.avl.lookup_nearest(comp,input_tree,end_test,end);
if(cljs.core.truth_((function (){var and__4120__auto__ = l;
if(cljs.core.truth_(and__4120__auto__)){
return h;
} else {
return and__4120__auto__;
}
})())){
var lk = l.getKey();
var hk = h.getKey();
if(((comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(hk,lk) : comp.call(null,hk,lk)) < (0))){
return cljs.core.empty(coll);
} else {
var tree = clojure.data.avl.range(comp,coll.getTree(),lk,hk);
var cnt = ((clojure.data.avl.rank_of(coll,hk) - clojure.data.avl.rank_of(coll,lk)) + (1));
var m = (new clojure.data.avl.AVLMap(comp,tree,cnt,null,(-1)));
if(cljs.core.map_QMARK_(coll)){
return m;
} else {
return (new clojure.data.avl.AVLSet(null,m,(-1)));
}
}
} else {
return cljs.core.empty(coll);
}
}
}
});

clojure.data.avl.subrange.cljs$lang$maxFixedArity = 5;


//# sourceMappingURL=avl.js.map?rel=1593117269323
