// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102702){
var state_val_102703 = (state_102702[(1)]);
if((state_val_102703 === (1))){
var state_102702__$1 = state_102702;
var statearr_102704_102716 = state_102702__$1;
(statearr_102704_102716[(2)] = null);

(statearr_102704_102716[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102703 === (2))){
var inst_102700 = (state_102702[(2)]);
var state_102702__$1 = state_102702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102702__$1,inst_102700);
} else {
if((state_val_102703 === (3))){
var inst_102684 = (state_102702[(2)]);
var state_102702__$1 = state_102702;
var statearr_102705_102717 = state_102702__$1;
(statearr_102705_102717[(2)] = inst_102684);


cljs.core.async.impl.ioc_helpers.process_exception(state_102702__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102703 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102702,(3),Error,null,(2));
var inst_102688 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_102689 = fluree.db.storage.core.storage_read(conn,inst_102688);
var state_102702__$1 = state_102702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102702__$1,(5),inst_102689);
} else {
if((state_val_102703 === (5))){
var inst_102692 = (state_102702[(7)]);
var inst_102691 = (state_102702[(2)]);
var inst_102692__$1 = fluree.db.util.async.throw_err(inst_102691);
var state_102702__$1 = (function (){var statearr_102706 = state_102702;
(statearr_102706[(7)] = inst_102692__$1);

return statearr_102706;
})();
if(cljs.core.truth_(inst_102692__$1)){
var statearr_102707_102718 = state_102702__$1;
(statearr_102707_102718[(1)] = (6));

} else {
var statearr_102708_102719 = state_102702__$1;
(statearr_102708_102719[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102703 === (6))){
var inst_102692 = (state_102702[(7)]);
var inst_102694 = fluree.db.storage.core.serde(conn);
var inst_102695 = fluree.db.serde.protocol._deserialize_block(inst_102694,inst_102692);
var state_102702__$1 = state_102702;
var statearr_102709_102720 = state_102702__$1;
(statearr_102709_102720[(2)] = inst_102695);

(statearr_102709_102720[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102703 === (7))){
var state_102702__$1 = state_102702;
var statearr_102710_102721 = state_102702__$1;
(statearr_102710_102721[(2)] = null);

(statearr_102710_102721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102703 === (8))){
var inst_102698 = (state_102702[(2)]);
var state_102702__$1 = state_102702;
var statearr_102711_102722 = state_102702__$1;
(statearr_102711_102722[(2)] = inst_102698);


cljs.core.async.impl.ioc_helpers.process_exception(state_102702__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__99037__auto____0 = (function (){
var statearr_102712 = [null,null,null,null,null,null,null,null];
(statearr_102712[(0)] = fluree$db$storage$core$read_block_$_state_machine__99037__auto__);

(statearr_102712[(1)] = (1));

return statearr_102712;
});
var fluree$db$storage$core$read_block_$_state_machine__99037__auto____1 = (function (state_102702){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102702);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102713){if((e102713 instanceof Object)){
var ex__99040__auto__ = e102713;
var statearr_102714_102723 = state_102702;
(statearr_102714_102723[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102702);

return cljs.core.cst$kw$recur;
} else {
throw e102713;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102724 = state_102702;
state_102702 = G__102724;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__99037__auto__ = function(state_102702){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__99037__auto____1.call(this,state_102702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102715 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102715[(6)] = c__99059__auto__);

return statearr_102715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102744){
var state_val_102745 = (state_102744[(1)]);
if((state_val_102745 === (1))){
var state_102744__$1 = state_102744;
var statearr_102746_102758 = state_102744__$1;
(statearr_102746_102758[(2)] = null);

(statearr_102746_102758[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102745 === (2))){
var inst_102742 = (state_102744[(2)]);
var state_102744__$1 = state_102744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102744__$1,inst_102742);
} else {
if((state_val_102745 === (3))){
var inst_102725 = (state_102744[(2)]);
var state_102744__$1 = state_102744;
var statearr_102747_102759 = state_102744__$1;
(statearr_102747_102759[(2)] = inst_102725);


cljs.core.async.impl.ioc_helpers.process_exception(state_102744__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102745 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102744,(3),Error,null,(2));
var inst_102729 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_102730 = [inst_102729,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_102731 = fluree.db.storage.core.storage_read(conn,inst_102730);
var state_102744__$1 = state_102744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102744__$1,(5),inst_102731);
} else {
if((state_val_102745 === (5))){
var inst_102734 = (state_102744[(7)]);
var inst_102733 = (state_102744[(2)]);
var inst_102734__$1 = fluree.db.util.async.throw_err(inst_102733);
var state_102744__$1 = (function (){var statearr_102748 = state_102744;
(statearr_102748[(7)] = inst_102734__$1);

return statearr_102748;
})();
if(cljs.core.truth_(inst_102734__$1)){
var statearr_102749_102760 = state_102744__$1;
(statearr_102749_102760[(1)] = (6));

} else {
var statearr_102750_102761 = state_102744__$1;
(statearr_102750_102761[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102745 === (6))){
var inst_102734 = (state_102744[(7)]);
var inst_102736 = fluree.db.storage.core.serde(conn);
var inst_102737 = fluree.db.serde.protocol._deserialize_block(inst_102736,inst_102734);
var state_102744__$1 = state_102744;
var statearr_102751_102762 = state_102744__$1;
(statearr_102751_102762[(2)] = inst_102737);

(statearr_102751_102762[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102745 === (7))){
var state_102744__$1 = state_102744;
var statearr_102752_102763 = state_102744__$1;
(statearr_102752_102763[(2)] = null);

(statearr_102752_102763[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102745 === (8))){
var inst_102740 = (state_102744[(2)]);
var state_102744__$1 = state_102744;
var statearr_102753_102764 = state_102744__$1;
(statearr_102753_102764[(2)] = inst_102740);


cljs.core.async.impl.ioc_helpers.process_exception(state_102744__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____0 = (function (){
var statearr_102754 = [null,null,null,null,null,null,null,null];
(statearr_102754[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__);

(statearr_102754[(1)] = (1));

return statearr_102754;
});
var fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____1 = (function (state_102744){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102744);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102755){if((e102755 instanceof Object)){
var ex__99040__auto__ = e102755;
var statearr_102756_102765 = state_102744;
(statearr_102756_102765[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102744);

return cljs.core.cst$kw$recur;
} else {
throw e102755;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102766 = state_102744;
state_102744 = G__102766;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__ = function(state_102744){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____1.call(this,state_102744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102757 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102757[(6)] = c__99059__auto__);

return statearr_102757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102787){
var state_val_102788 = (state_102787[(1)]);
if((state_val_102788 === (1))){
var state_102787__$1 = state_102787;
var statearr_102789_102796 = state_102787__$1;
(statearr_102789_102796[(2)] = null);

(statearr_102789_102796[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102788 === (2))){
var inst_102785 = (state_102787[(2)]);
var state_102787__$1 = state_102787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102787__$1,inst_102785);
} else {
if((state_val_102788 === (3))){
var inst_102767 = (state_102787[(2)]);
var state_102787__$1 = state_102787;
var statearr_102790_102797 = state_102787__$1;
(statearr_102790_102797[(2)] = inst_102767);


cljs.core.async.impl.ioc_helpers.process_exception(state_102787__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102788 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102787,(3),Error,null,(2));
var inst_102771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102772 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_102773 = (new cljs.core.PersistentVector(null,3,(5),inst_102771,inst_102772,null));
var inst_102774 = cljs.core.select_keys(block_data,inst_102773);
var inst_102775 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_102774);
var inst_102776 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_102775);
var inst_102777 = [inst_102776,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_102778 = fluree.db.storage.core.serde(conn);
var inst_102779 = fluree.db.serde.protocol._serialize_block(inst_102778,inst_102774);
var inst_102780 = fluree.db.storage.core.storage_write(conn,inst_102777,inst_102779);
var state_102787__$1 = state_102787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102787__$1,(5),inst_102780);
} else {
if((state_val_102788 === (5))){
var inst_102782 = (state_102787[(2)]);
var inst_102783 = fluree.db.util.async.throw_err(inst_102782);
var state_102787__$1 = state_102787;
var statearr_102791_102798 = state_102787__$1;
(statearr_102791_102798[(2)] = inst_102783);


cljs.core.async.impl.ioc_helpers.process_exception(state_102787__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____0 = (function (){
var statearr_102792 = [null,null,null,null,null,null,null];
(statearr_102792[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__);

(statearr_102792[(1)] = (1));

return statearr_102792;
});
var fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____1 = (function (state_102787){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102787);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102793){if((e102793 instanceof Object)){
var ex__99040__auto__ = e102793;
var statearr_102794_102799 = state_102787;
(statearr_102794_102799[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102787);

return cljs.core.cst$kw$recur;
} else {
throw e102793;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102800 = state_102787;
state_102787 = G__102800;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__ = function(state_102787){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____1.call(this,state_102787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102795 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102795[(6)] = c__99059__auto__);

return statearr_102795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102820){
var state_val_102821 = (state_102820[(1)]);
if((state_val_102821 === (1))){
var state_102820__$1 = state_102820;
var statearr_102822_102829 = state_102820__$1;
(statearr_102822_102829[(2)] = null);

(statearr_102822_102829[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102821 === (2))){
var inst_102818 = (state_102820[(2)]);
var state_102820__$1 = state_102820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102820__$1,inst_102818);
} else {
if((state_val_102821 === (3))){
var inst_102801 = (state_102820[(2)]);
var state_102820__$1 = state_102820;
var statearr_102823_102830 = state_102820__$1;
(statearr_102823_102830[(2)] = inst_102801);


cljs.core.async.impl.ioc_helpers.process_exception(state_102820__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102821 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102820,(3),Error,null,(2));
var inst_102805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_102806 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_102807 = (new cljs.core.PersistentVector(null,3,(5),inst_102805,inst_102806,null));
var inst_102808 = cljs.core.select_keys(block_data,inst_102807);
var inst_102809 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_102808);
var inst_102810 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_102809);
var inst_102811 = fluree.db.storage.core.serde(conn);
var inst_102812 = fluree.db.serde.protocol._serialize_block(inst_102811,inst_102808);
var inst_102813 = fluree.db.storage.core.storage_write(conn,inst_102810,inst_102812);
var state_102820__$1 = state_102820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102820__$1,(5),inst_102813);
} else {
if((state_val_102821 === (5))){
var inst_102815 = (state_102820[(2)]);
var inst_102816 = fluree.db.util.async.throw_err(inst_102815);
var state_102820__$1 = state_102820;
var statearr_102824_102831 = state_102820__$1;
(statearr_102824_102831[(2)] = inst_102816);


cljs.core.async.impl.ioc_helpers.process_exception(state_102820__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__99037__auto____0 = (function (){
var statearr_102825 = [null,null,null,null,null,null,null];
(statearr_102825[(0)] = fluree$db$storage$core$write_block_$_state_machine__99037__auto__);

(statearr_102825[(1)] = (1));

return statearr_102825;
});
var fluree$db$storage$core$write_block_$_state_machine__99037__auto____1 = (function (state_102820){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102820);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102826){if((e102826 instanceof Object)){
var ex__99040__auto__ = e102826;
var statearr_102827_102832 = state_102820;
(statearr_102827_102832[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102820);

return cljs.core.cst$kw$recur;
} else {
throw e102826;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102833 = state_102820;
state_102820 = G__102833;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__99037__auto__ = function(state_102820){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__99037__auto____1.call(this,state_102820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102828 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102828[(6)] = c__99059__auto__);

return statearr_102828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102850){
var state_val_102851 = (state_102850[(1)]);
if((state_val_102851 === (1))){
var state_102850__$1 = state_102850;
var statearr_102852_102859 = state_102850__$1;
(statearr_102852_102859[(2)] = null);

(statearr_102852_102859[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102851 === (2))){
var inst_102848 = (state_102850[(2)]);
var state_102850__$1 = state_102850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102850__$1,inst_102848);
} else {
if((state_val_102851 === (3))){
var inst_102834 = (state_102850[(2)]);
var state_102850__$1 = state_102850;
var statearr_102853_102860 = state_102850__$1;
(statearr_102853_102860[(2)] = inst_102834);


cljs.core.async.impl.ioc_helpers.process_exception(state_102850__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102851 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102850,(3),Error,null,(2));
var inst_102838 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_102839 = [history,next_his_key];
var inst_102840 = cljs.core.PersistentHashMap.fromArrays(inst_102838,inst_102839);
var inst_102841 = fluree.db.storage.core.serde(conn);
var inst_102842 = fluree.db.serde.protocol._serialize_leaf(inst_102841,inst_102840);
var inst_102843 = fluree.db.storage.core.storage_write(conn,his_key,inst_102842);
var state_102850__$1 = state_102850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102850__$1,(5),inst_102843);
} else {
if((state_val_102851 === (5))){
var inst_102845 = (state_102850[(2)]);
var inst_102846 = fluree.db.util.async.throw_err(inst_102845);
var state_102850__$1 = state_102850;
var statearr_102854_102861 = state_102850__$1;
(statearr_102854_102861[(2)] = inst_102846);


cljs.core.async.impl.ioc_helpers.process_exception(state_102850__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__99037__auto____0 = (function (){
var statearr_102855 = [null,null,null,null,null,null,null];
(statearr_102855[(0)] = fluree$db$storage$core$write_history_$_state_machine__99037__auto__);

(statearr_102855[(1)] = (1));

return statearr_102855;
});
var fluree$db$storage$core$write_history_$_state_machine__99037__auto____1 = (function (state_102850){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102850);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102856){if((e102856 instanceof Object)){
var ex__99040__auto__ = e102856;
var statearr_102857_102862 = state_102850;
(statearr_102857_102862[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102850);

return cljs.core.cst$kw$recur;
} else {
throw e102856;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102863 = state_102850;
state_102850 = G__102863;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__99037__auto__ = function(state_102850){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__99037__auto____1.call(this,state_102850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_history_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102858 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102858[(6)] = c__99059__auto__);

return statearr_102858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102886){
var state_val_102887 = (state_102886[(1)]);
if((state_val_102887 === (1))){
var state_102886__$1 = state_102886;
var statearr_102888_102898 = state_102886__$1;
(statearr_102888_102898[(2)] = null);

(statearr_102888_102898[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102887 === (2))){
var inst_102884 = (state_102886[(2)]);
var state_102886__$1 = state_102886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102886__$1,inst_102884);
} else {
if((state_val_102887 === (3))){
var inst_102864 = (state_102886[(2)]);
var state_102886__$1 = state_102886;
var statearr_102889_102899 = state_102886__$1;
(statearr_102889_102899[(2)] = inst_102864);


cljs.core.async.impl.ioc_helpers.process_exception(state_102886__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102887 === (4))){
var inst_102868 = (state_102886[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102886,(3),Error,null,(2));
var inst_102868__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_102869 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_102868__$1),"-his"].join('');
var inst_102870 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_102871 = [flakes,inst_102869];
var inst_102872 = cljs.core.PersistentHashMap.fromArrays(inst_102870,inst_102871);
var inst_102873 = fluree.db.storage.core.serde(conn);
var inst_102874 = fluree.db.serde.protocol._serialize_leaf(inst_102873,inst_102872);
var inst_102875 = fluree.db.storage.core.write_history(conn,history,inst_102869,null);
var inst_102876 = fluree.db.storage.core.storage_write(conn,inst_102868__$1,inst_102874);
var state_102886__$1 = (function (){var statearr_102890 = state_102886;
(statearr_102890[(7)] = inst_102868__$1);

(statearr_102890[(8)] = inst_102876);

return statearr_102890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102886__$1,(5),inst_102875);
} else {
if((state_val_102887 === (5))){
var inst_102876 = (state_102886[(8)]);
var inst_102878 = (state_102886[(2)]);
var inst_102879 = fluree.db.util.async.throw_err(inst_102878);
var state_102886__$1 = (function (){var statearr_102891 = state_102886;
(statearr_102891[(9)] = inst_102879);

return statearr_102891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102886__$1,(6),inst_102876);
} else {
if((state_val_102887 === (6))){
var inst_102868 = (state_102886[(7)]);
var inst_102881 = (state_102886[(2)]);
var inst_102882 = fluree.db.util.async.throw_err(inst_102881);
var state_102886__$1 = (function (){var statearr_102892 = state_102886;
(statearr_102892[(10)] = inst_102882);

return statearr_102892;
})();
var statearr_102893_102900 = state_102886__$1;
(statearr_102893_102900[(2)] = inst_102868);


cljs.core.async.impl.ioc_helpers.process_exception(state_102886__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____0 = (function (){
var statearr_102894 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_102894[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__);

(statearr_102894[(1)] = (1));

return statearr_102894;
});
var fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____1 = (function (state_102886){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102886);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102895){if((e102895 instanceof Object)){
var ex__99040__auto__ = e102895;
var statearr_102896_102901 = state_102886;
(statearr_102896_102901[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102886);

return cljs.core.cst$kw$recur;
} else {
throw e102895;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102902 = state_102886;
state_102886 = G__102902;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__ = function(state_102886){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____1.call(this,state_102886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102897 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102897[(6)] = c__99059__auto__);

return statearr_102897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_102916){
var state_val_102917 = (state_102916[(1)]);
if((state_val_102917 === (1))){
var state_102916__$1 = state_102916;
var statearr_102918_102926 = state_102916__$1;
(statearr_102918_102926[(2)] = null);

(statearr_102918_102926[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102917 === (2))){
var inst_102914 = (state_102916[(2)]);
var state_102916__$1 = state_102916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102916__$1,inst_102914);
} else {
if((state_val_102917 === (3))){
var inst_102903 = (state_102916[(2)]);
var state_102916__$1 = state_102916;
var statearr_102919_102927 = state_102916__$1;
(statearr_102919_102927[(2)] = inst_102903);


cljs.core.async.impl.ioc_helpers.process_exception(state_102916__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102917 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102916,(3),Error,null,(2));
var inst_102907 = fluree.db.storage.core.serde(conn);
var inst_102908 = fluree.db.serde.protocol._serialize_branch(inst_102907,data);
var inst_102909 = fluree.db.storage.core.storage_write(conn,key,inst_102908);
var state_102916__$1 = state_102916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102916__$1,(5),inst_102909);
} else {
if((state_val_102917 === (5))){
var inst_102911 = (state_102916[(2)]);
var inst_102912 = fluree.db.util.async.throw_err(inst_102911);
var state_102916__$1 = (function (){var statearr_102920 = state_102916;
(statearr_102920[(7)] = inst_102912);

return statearr_102920;
})();
var statearr_102921_102928 = state_102916__$1;
(statearr_102921_102928[(2)] = key);


cljs.core.async.impl.ioc_helpers.process_exception(state_102916__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____0 = (function (){
var statearr_102922 = [null,null,null,null,null,null,null,null];
(statearr_102922[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__);

(statearr_102922[(1)] = (1));

return statearr_102922;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____1 = (function (state_102916){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102916);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102923){if((e102923 instanceof Object)){
var ex__99040__auto__ = e102923;
var statearr_102924_102929 = state_102916;
(statearr_102924_102929[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102916);

return cljs.core.cst$kw$recur;
} else {
throw e102923;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__102930 = state_102916;
state_102916 = G__102930;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__ = function(state_102916){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____1.call(this,state_102916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_102925 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_102925[(6)] = c__99059__auto__);

return statearr_102925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (branch_key){
return (function (p1__102931_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__102931_SHARP_));
});})(branch_key))
,children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__102932){
var map__102933 = p__102932;
var map__102933__$1 = (((((!((map__102933 == null))))?(((((map__102933.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__102933.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__102933):map__102933);
var progress = map__102933__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__102933__$1,cljs.core.cst$kw$garbage);
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__,map__102933,map__102933__$1,progress,garbage){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__,map__102933,map__102933__$1,progress,garbage){
return (function (state_102978){
var state_val_102979 = (state_102978[(1)]);
if((state_val_102979 === (7))){
var inst_102955 = (state_102978[(2)]);
var state_102978__$1 = state_102978;
if(cljs.core.truth_(inst_102955)){
var statearr_102980_103001 = state_102978__$1;
(statearr_102980_103001[(1)] = (11));

} else {
var statearr_102981_103002 = state_102978__$1;
(statearr_102981_103002[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (1))){
var state_102978__$1 = state_102978;
var statearr_102982_103003 = state_102978__$1;
(statearr_102982_103003[(2)] = null);

(statearr_102982_103003[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_102978,(3),Error,null,(2));
var inst_102941 = (db == null);
var inst_102942 = cljs.core.not(inst_102941);
var state_102978__$1 = state_102978;
if(inst_102942){
var statearr_102983_103004 = state_102978__$1;
(statearr_102983_103004[(1)] = (5));

} else {
var statearr_102984_103005 = state_102978__$1;
(statearr_102984_103005[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (13))){
var inst_102965 = (state_102978[(7)]);
var inst_102960 = (state_102978[(2)]);
var inst_102961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102960,cljs.core.cst$kw$conn);
var inst_102962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102960,cljs.core.cst$kw$network);
var inst_102963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102960,cljs.core.cst$kw$dbid);
var inst_102964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_102960,cljs.core.cst$kw$block);
var inst_102965__$1 = fluree.db.storage.core.ledger_garbage_key(inst_102962,inst_102963,inst_102964);
var inst_102966 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_102967 = [inst_102963,inst_102964,garbage];
var inst_102968 = cljs.core.PersistentHashMap.fromArrays(inst_102966,inst_102967);
var inst_102969 = fluree.db.storage.core.serde(inst_102961);
var inst_102970 = fluree.db.serde.protocol._serialize_garbage(inst_102969,inst_102968);
var inst_102971 = fluree.db.storage.core.storage_write(inst_102961,inst_102965__$1,inst_102970);
var state_102978__$1 = (function (){var statearr_102985 = state_102978;
(statearr_102985[(7)] = inst_102965__$1);

return statearr_102985;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_102978__$1,(14),inst_102971);
} else {
if((state_val_102979 === (6))){
var state_102978__$1 = state_102978;
var statearr_102986_103006 = state_102978__$1;
(statearr_102986_103006[(2)] = false);

(statearr_102986_103006[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (3))){
var inst_102935 = (state_102978[(2)]);
var state_102978__$1 = state_102978;
var statearr_102987_103007 = state_102978__$1;
(statearr_102987_103007[(2)] = inst_102935);


cljs.core.async.impl.ioc_helpers.process_exception(state_102978__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (12))){
var state_102978__$1 = state_102978;
var statearr_102988_103008 = state_102978__$1;
(statearr_102988_103008[(2)] = db);

(statearr_102988_103008[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (2))){
var inst_102976 = (state_102978[(2)]);
var state_102978__$1 = state_102978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_102978__$1,inst_102976);
} else {
if((state_val_102979 === (11))){
var inst_102957 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_102978__$1 = state_102978;
var statearr_102989_103009 = state_102978__$1;
(statearr_102989_103009[(2)] = inst_102957);

(statearr_102989_103009[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (9))){
var state_102978__$1 = state_102978;
var statearr_102990_103010 = state_102978__$1;
(statearr_102990_103010[(2)] = false);

(statearr_102990_103010[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (5))){
var inst_102944 = db.cljs$lang$protocol_mask$partition0$;
var inst_102945 = (inst_102944 & (64));
var inst_102946 = db.cljs$core$ISeq$;
var inst_102947 = (cljs.core.PROTOCOL_SENTINEL === inst_102946);
var inst_102948 = ((inst_102945) || (inst_102947));
var state_102978__$1 = state_102978;
if(cljs.core.truth_(inst_102948)){
var statearr_102991_103011 = state_102978__$1;
(statearr_102991_103011[(1)] = (8));

} else {
var statearr_102992_103012 = state_102978__$1;
(statearr_102992_103012[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (14))){
var inst_102965 = (state_102978[(7)]);
var inst_102973 = (state_102978[(2)]);
var inst_102974 = fluree.db.util.async.throw_err(inst_102973);
var state_102978__$1 = (function (){var statearr_102993 = state_102978;
(statearr_102993[(8)] = inst_102974);

return statearr_102993;
})();
var statearr_102994_103013 = state_102978__$1;
(statearr_102994_103013[(2)] = inst_102965);


cljs.core.async.impl.ioc_helpers.process_exception(state_102978__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (10))){
var inst_102952 = (state_102978[(2)]);
var state_102978__$1 = state_102978;
var statearr_102995_103014 = state_102978__$1;
(statearr_102995_103014[(2)] = inst_102952);

(statearr_102995_103014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_102979 === (8))){
var state_102978__$1 = state_102978;
var statearr_102996_103015 = state_102978__$1;
(statearr_102996_103015[(2)] = true);

(statearr_102996_103015[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__,map__102933,map__102933__$1,progress,garbage))
;
return ((function (switch__99036__auto__,c__99059__auto__,map__102933,map__102933__$1,progress,garbage){
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____0 = (function (){
var statearr_102997 = [null,null,null,null,null,null,null,null,null];
(statearr_102997[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__);

(statearr_102997[(1)] = (1));

return statearr_102997;
});
var fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____1 = (function (state_102978){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_102978);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e102998){if((e102998 instanceof Object)){
var ex__99040__auto__ = e102998;
var statearr_102999_103016 = state_102978;
(statearr_102999_103016[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_102978);

return cljs.core.cst$kw$recur;
} else {
throw e102998;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103017 = state_102978;
state_102978 = G__103017;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__ = function(state_102978){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____1.call(this,state_102978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__99037__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__,map__102933,map__102933__$1,progress,garbage))
})();
var state__99061__auto__ = (function (){var statearr_103000 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103000[(6)] = c__99059__auto__);

return statearr_103000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__,map__102933,map__102933__$1,progress,garbage))
);

return c__99059__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__103019 = arguments.length;
switch (G__103019) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
});

fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103090){
var state_val_103091 = (state_103090[(1)]);
if((state_val_103091 === (7))){
var inst_103040 = (state_103090[(2)]);
var state_103090__$1 = state_103090;
if(cljs.core.truth_(inst_103040)){
var statearr_103092_103123 = state_103090__$1;
(statearr_103092_103123[(1)] = (11));

} else {
var statearr_103093_103124 = state_103090__$1;
(statearr_103093_103124[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (20))){
var inst_103059 = (state_103090[(7)]);
var inst_103085 = (state_103090[(2)]);
var inst_103086 = fluree.db.util.async.throw_err(inst_103085);
var state_103090__$1 = (function (){var statearr_103094 = state_103090;
(statearr_103094[(8)] = inst_103086);

return statearr_103094;
})();
var statearr_103095_103125 = state_103090__$1;
(statearr_103095_103125[(2)] = inst_103059);


cljs.core.async.impl.ioc_helpers.process_exception(state_103090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (1))){
var state_103090__$1 = state_103090;
var statearr_103096_103126 = state_103090__$1;
(statearr_103096_103126[(2)] = null);

(statearr_103096_103126[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103090,(3),Error,null,(2));
var inst_103026 = (db == null);
var inst_103027 = cljs.core.not(inst_103026);
var state_103090__$1 = state_103090;
if(inst_103027){
var statearr_103097_103127 = state_103090__$1;
(statearr_103097_103127[(1)] = (5));

} else {
var statearr_103098_103128 = state_103090__$1;
(statearr_103098_103128[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (15))){
var state_103090__$1 = state_103090;
var statearr_103099_103129 = state_103090__$1;
(statearr_103099_103129[(2)] = (0));

(statearr_103099_103129[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (13))){
var inst_103050 = (state_103090[(9)]);
var inst_103054 = (state_103090[(10)]);
var inst_103052 = (state_103090[(11)]);
var inst_103062 = (state_103090[(12)]);
var inst_103045 = (state_103090[(2)]);
var inst_103046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$network);
var inst_103047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$t);
var inst_103048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$fork);
var inst_103049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$spot);
var inst_103050__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$stats);
var inst_103051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$conn);
var inst_103052__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$block);
var inst_103053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$psot);
var inst_103054__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$dbid);
var inst_103055 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$ecount);
var inst_103056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$opst);
var inst_103057 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$fork_DASH_block);
var inst_103058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103045,cljs.core.cst$kw$post);
var inst_103059 = fluree.db.storage.core.ledger_root_key(inst_103046,inst_103054__$1,inst_103052__$1);
var inst_103060 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_103061 = fluree.db.storage.core.child_data(inst_103053);
var inst_103062__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_103050__$1);
var state_103090__$1 = (function (){var statearr_103100 = state_103090;
(statearr_103100[(13)] = inst_103057);

(statearr_103100[(9)] = inst_103050__$1);

(statearr_103100[(14)] = inst_103051);

(statearr_103100[(15)] = inst_103055);

(statearr_103100[(16)] = inst_103058);

(statearr_103100[(10)] = inst_103054__$1);

(statearr_103100[(11)] = inst_103052__$1);

(statearr_103100[(17)] = inst_103061);

(statearr_103100[(7)] = inst_103059);

(statearr_103100[(18)] = inst_103047);

(statearr_103100[(19)] = inst_103056);

(statearr_103100[(20)] = inst_103060);

(statearr_103100[(12)] = inst_103062__$1);

(statearr_103100[(21)] = inst_103048);

(statearr_103100[(22)] = inst_103049);

return statearr_103100;
})();
if(cljs.core.truth_(inst_103062__$1)){
var statearr_103101_103130 = state_103090__$1;
(statearr_103101_103130[(1)] = (14));

} else {
var statearr_103102_103131 = state_103090__$1;
(statearr_103102_103131[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (6))){
var state_103090__$1 = state_103090;
var statearr_103103_103132 = state_103090__$1;
(statearr_103103_103132[(2)] = false);

(statearr_103103_103132[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (17))){
var state_103090__$1 = state_103090;
var statearr_103104_103133 = state_103090__$1;
(statearr_103104_103133[(2)] = custom_ecount);

(statearr_103104_103133[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (3))){
var inst_103020 = (state_103090[(2)]);
var state_103090__$1 = state_103090;
var statearr_103105_103134 = state_103090__$1;
(statearr_103105_103134[(2)] = inst_103020);


cljs.core.async.impl.ioc_helpers.process_exception(state_103090__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (12))){
var state_103090__$1 = state_103090;
var statearr_103106_103135 = state_103090__$1;
(statearr_103106_103135[(2)] = db);

(statearr_103106_103135[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (2))){
var inst_103088 = (state_103090[(2)]);
var state_103090__$1 = state_103090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103090__$1,inst_103088);
} else {
if((state_val_103091 === (19))){
var inst_103057 = (state_103090[(13)]);
var inst_103050 = (state_103090[(9)]);
var inst_103051 = (state_103090[(14)]);
var inst_103066 = (state_103090[(23)]);
var inst_103058 = (state_103090[(16)]);
var inst_103054 = (state_103090[(10)]);
var inst_103052 = (state_103090[(11)]);
var inst_103061 = (state_103090[(17)]);
var inst_103059 = (state_103090[(7)]);
var inst_103047 = (state_103090[(18)]);
var inst_103056 = (state_103090[(19)]);
var inst_103060 = (state_103090[(20)]);
var inst_103048 = (state_103090[(21)]);
var inst_103049 = (state_103090[(22)]);
var inst_103070 = (state_103090[(2)]);
var inst_103071 = fluree.db.storage.core.child_data(inst_103056);
var inst_103072 = fluree.db.storage.core.child_data(inst_103058);
var inst_103073 = fluree.db.util.core.current_time_millis();
var inst_103074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_103075 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_103076 = (new cljs.core.PersistentVector(null,2,(5),inst_103074,inst_103075,null));
var inst_103077 = cljs.core.select_keys(inst_103050,inst_103076);
var inst_103078 = fluree.db.storage.core.child_data(inst_103049);
var inst_103079 = [inst_103052,inst_103061,inst_103054,inst_103066,inst_103070,inst_103071,inst_103072,inst_103047,inst_103073,inst_103048,inst_103057,inst_103077,inst_103078];
var inst_103080 = cljs.core.PersistentHashMap.fromArrays(inst_103060,inst_103079);
var inst_103081 = fluree.db.storage.core.serde(inst_103051);
var inst_103082 = fluree.db.serde.protocol._serialize_db_root(inst_103081,inst_103080);
var inst_103083 = fluree.db.storage.core.storage_write(inst_103051,inst_103059,inst_103082);
var state_103090__$1 = state_103090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103090__$1,(20),inst_103083);
} else {
if((state_val_103091 === (11))){
var inst_103042 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_103090__$1 = state_103090;
var statearr_103107_103136 = state_103090__$1;
(statearr_103107_103136[(2)] = inst_103042);

(statearr_103107_103136[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (9))){
var state_103090__$1 = state_103090;
var statearr_103108_103137 = state_103090__$1;
(statearr_103108_103137[(2)] = false);

(statearr_103108_103137[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (5))){
var inst_103029 = db.cljs$lang$protocol_mask$partition0$;
var inst_103030 = (inst_103029 & (64));
var inst_103031 = db.cljs$core$ISeq$;
var inst_103032 = (cljs.core.PROTOCOL_SENTINEL === inst_103031);
var inst_103033 = ((inst_103030) || (inst_103032));
var state_103090__$1 = state_103090;
if(cljs.core.truth_(inst_103033)){
var statearr_103109_103138 = state_103090__$1;
(statearr_103109_103138[(1)] = (8));

} else {
var statearr_103110_103139 = state_103090__$1;
(statearr_103110_103139[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (14))){
var inst_103062 = (state_103090[(12)]);
var state_103090__$1 = state_103090;
var statearr_103111_103140 = state_103090__$1;
(statearr_103111_103140[(2)] = inst_103062);

(statearr_103111_103140[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (16))){
var inst_103066 = (state_103090[(2)]);
var state_103090__$1 = (function (){var statearr_103112 = state_103090;
(statearr_103112[(23)] = inst_103066);

return statearr_103112;
})();
if(cljs.core.truth_(custom_ecount)){
var statearr_103113_103141 = state_103090__$1;
(statearr_103113_103141[(1)] = (17));

} else {
var statearr_103114_103142 = state_103090__$1;
(statearr_103114_103142[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (10))){
var inst_103037 = (state_103090[(2)]);
var state_103090__$1 = state_103090;
var statearr_103115_103143 = state_103090__$1;
(statearr_103115_103143[(2)] = inst_103037);

(statearr_103115_103143[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (18))){
var inst_103055 = (state_103090[(15)]);
var state_103090__$1 = state_103090;
var statearr_103116_103144 = state_103090__$1;
(statearr_103116_103144[(2)] = inst_103055);

(statearr_103116_103144[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103091 === (8))){
var state_103090__$1 = state_103090;
var statearr_103117_103145 = state_103090__$1;
(statearr_103117_103145[(2)] = true);

(statearr_103117_103145[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$state_machine__99037__auto__ = null;
var fluree$db$storage$core$state_machine__99037__auto____0 = (function (){
var statearr_103118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103118[(0)] = fluree$db$storage$core$state_machine__99037__auto__);

(statearr_103118[(1)] = (1));

return statearr_103118;
});
var fluree$db$storage$core$state_machine__99037__auto____1 = (function (state_103090){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103090);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103119){if((e103119 instanceof Object)){
var ex__99040__auto__ = e103119;
var statearr_103120_103146 = state_103090;
(statearr_103120_103146[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103090);

return cljs.core.cst$kw$recur;
} else {
throw e103119;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103147 = state_103090;
state_103090 = G__103147;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99037__auto__ = function(state_103090){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99037__auto____1.call(this,state_103090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99037__auto____0;
fluree$db$storage$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99037__auto____1;
return fluree$db$storage$core$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_103121 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103121[(6)] = c__99059__auto__);

return statearr_103121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2;

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___103189 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___103189,return_ch){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___103189,return_ch){
return (function (state_103174){
var state_val_103175 = (state_103174[(1)]);
if((state_val_103175 === (1))){
var state_103174__$1 = state_103174;
var statearr_103176_103190 = state_103174__$1;
(statearr_103176_103190[(2)] = null);

(statearr_103176_103190[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103175 === (2))){
var inst_103172 = (state_103174[(2)]);
var state_103174__$1 = state_103174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103174__$1,inst_103172);
} else {
if((state_val_103175 === (3))){
var inst_103148 = (state_103174[(2)]);
var inst_103149 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_103150 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103148);
var inst_103151 = cljs.core.async.close_BANG_(return_ch);
var state_103174__$1 = (function (){var statearr_103177 = state_103174;
(statearr_103177[(7)] = inst_103150);

(statearr_103177[(8)] = inst_103149);

return statearr_103177;
})();
var statearr_103178_103191 = state_103174__$1;
(statearr_103178_103191[(2)] = inst_103151);


cljs.core.async.impl.ioc_helpers.process_exception(state_103174__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103175 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103174,(3),java.lang.Exception,null,(2));
var inst_103155 = fluree.db.storage.core.storage_read(conn,key);
var state_103174__$1 = state_103174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103174__$1,(5),inst_103155);
} else {
if((state_val_103175 === (5))){
var inst_103157 = (state_103174[(9)]);
var inst_103157__$1 = (state_103174[(2)]);
var inst_103158 = (inst_103157__$1 == null);
var inst_103159 = (inst_103157__$1 instanceof Error);
var inst_103160 = ((inst_103158) || (inst_103159));
var state_103174__$1 = (function (){var statearr_103179 = state_103174;
(statearr_103179[(9)] = inst_103157__$1);

return statearr_103179;
})();
if(cljs.core.truth_(inst_103160)){
var statearr_103180_103192 = state_103174__$1;
(statearr_103180_103192[(1)] = (6));

} else {
var statearr_103181_103193 = state_103174__$1;
(statearr_103181_103193[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103175 === (6))){
var inst_103162 = cljs.core.async.close_BANG_(return_ch);
var state_103174__$1 = state_103174;
var statearr_103182_103194 = state_103174__$1;
(statearr_103182_103194[(2)] = inst_103162);

(statearr_103182_103194[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103175 === (7))){
var inst_103157 = (state_103174[(9)]);
var inst_103164 = fluree.db.storage.core.serde(conn);
var inst_103165 = fluree.db.serde.protocol._deserialize_leaf(inst_103164,inst_103157);
var inst_103166 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_103165);
var inst_103167 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_103166);
var inst_103168 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103167);
var state_103174__$1 = state_103174;
var statearr_103183_103195 = state_103174__$1;
(statearr_103183_103195[(2)] = inst_103168);

(statearr_103183_103195[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103175 === (8))){
var inst_103170 = (state_103174[(2)]);
var state_103174__$1 = state_103174;
var statearr_103184_103196 = state_103174__$1;
(statearr_103184_103196[(2)] = inst_103170);


cljs.core.async.impl.ioc_helpers.process_exception(state_103174__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto___103189,return_ch))
;
return ((function (switch__99036__auto__,c__99059__auto___103189,return_ch){
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__99037__auto____0 = (function (){
var statearr_103185 = [null,null,null,null,null,null,null,null,null,null];
(statearr_103185[(0)] = fluree$db$storage$core$reify_history_$_state_machine__99037__auto__);

(statearr_103185[(1)] = (1));

return statearr_103185;
});
var fluree$db$storage$core$reify_history_$_state_machine__99037__auto____1 = (function (state_103174){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103174);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103186){if((e103186 instanceof Object)){
var ex__99040__auto__ = e103186;
var statearr_103187_103197 = state_103174;
(statearr_103187_103197[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103174);

return cljs.core.cst$kw$recur;
} else {
throw e103186;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103198 = state_103174;
state_103174 = G__103198;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__99037__auto__ = function(state_103174){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__99037__auto____1.call(this,state_103174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__99037__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__99037__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___103189,return_ch))
})();
var state__99061__auto__ = (function (){var statearr_103188 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103188[(6)] = c__99059__auto___103189);

return statearr_103188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___103189,return_ch))
);


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__103200 = arguments.length;
switch (G__103200) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
});

fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4120__auto__ = rhs;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4120__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4120__auto__ = rhs;
if(cljs.core.truth_(and__4120__auto__)){
return leftmost_QMARK_;
} else {
return and__4120__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4120__auto__ = (rhs == null);
if(and__4120__auto__){
return leftmost_QMARK_;
} else {
return and__4120__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (novelty_subrange){
return (function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
});})(novelty_subrange))
,novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
});

fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5;

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___103302 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___103302,result_ch){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___103302,result_ch){
return (function (state_103260){
var state_val_103261 = (state_103260[(1)]);
if((state_val_103261 === (7))){
var inst_103215 = (state_103260[(7)]);
var inst_103219 = (inst_103215 < t);
var state_103260__$1 = state_103260;
if(cljs.core.truth_(inst_103219)){
var statearr_103262_103303 = state_103260__$1;
(statearr_103262_103303[(1)] = (9));

} else {
var statearr_103263_103304 = state_103260__$1;
(statearr_103263_103304[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (20))){
var inst_103215 = (state_103260[(7)]);
var inst_103213 = (state_103260[(8)]);
var inst_103243 = (state_103260[(9)]);
var inst_103214 = (state_103260[(10)]);
var inst_103230 = (state_103260[(11)]);
var inst_103250 = (state_103260[(2)]);
var inst_103251 = (function (){var base_node = inst_103213;
var first_flake = inst_103214;
var node_t = inst_103215;
var source = inst_103230;
var coll = inst_103243;
var conj_QMARK_ = inst_103250;
return ((function (base_node,first_flake,node_t,source,coll,conj_QMARK_,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,inst_103250,state_val_103261,c__99059__auto___103302,result_ch){
return (function (acc,f){
if(cljs.core.truth_((function (){var G__103265 = f.p;
var fexpr__103264 = (function (){var or__4131__auto__ = remove_preds;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__103264.cljs$core$IFn$_invoke$arity$1 ? fexpr__103264.cljs$core$IFn$_invoke$arity$1(G__103265) : fexpr__103264.call(null,G__103265));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
;})(base_node,first_flake,node_t,source,coll,conj_QMARK_,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,inst_103250,state_val_103261,c__99059__auto___103302,result_ch))
})();
var inst_103252 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_103213);
var inst_103253 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_103251,inst_103252,inst_103243);
var inst_103254 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_103253);
var inst_103255 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_103213,cljs.core.cst$kw$flakes,inst_103254);
var inst_103256 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_103255);
var state_103260__$1 = state_103260;
var statearr_103266_103305 = state_103260__$1;
(statearr_103266_103305[(2)] = inst_103256);


cljs.core.async.impl.ioc_helpers.process_exception(state_103260__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (1))){
var state_103260__$1 = state_103260;
var statearr_103267_103306 = state_103260__$1;
(statearr_103267_103306[(2)] = null);

(statearr_103267_103306[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103260,(3),java.lang.Exception,null,(2));
var inst_103210 = fluree.db.dbproto._resolve(node);
var state_103260__$1 = state_103260;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103260__$1,(5),inst_103210);
} else {
if((state_val_103261 === (15))){
var inst_103230 = (state_103260[(11)]);
var inst_103243 = (state_103260[(2)]);
var state_103260__$1 = (function (){var statearr_103268 = state_103260;
(statearr_103268[(9)] = inst_103243);

return statearr_103268;
})();
var G__103269_103307 = inst_103230;
var G__103269_103308__$1 = (((G__103269_103307 instanceof cljs.core.Keyword))?G__103269_103307.fqn:null);
switch (G__103269_103308__$1) {
case "novelty":
var statearr_103270_103310 = state_103260__$1;
(statearr_103270_103310[(1)] = (21));


break;
case "history":
var statearr_103271_103311 = state_103260__$1;
(statearr_103271_103311[(1)] = (22));


break;
case "none":
var statearr_103272_103312 = state_103260__$1;
(statearr_103272_103312[(1)] = (23));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103269_103308__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (21))){
var inst_103215 = (state_103260[(7)]);
var inst_103213 = (state_103260[(8)]);
var inst_103243 = (state_103260[(9)]);
var inst_103214 = (state_103260[(10)]);
var inst_103230 = (state_103260[(11)]);
var inst_103244 = (function (){var base_node = inst_103213;
var first_flake = inst_103214;
var node_t = inst_103215;
var source = inst_103230;
var coll = inst_103243;
return ((function (base_node,first_flake,node_t,source,coll,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch){
return (function (f){
return f.op === true;
});
;})(base_node,first_flake,node_t,source,coll,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch))
})();
var state_103260__$1 = state_103260;
var statearr_103273_103313 = state_103260__$1;
(statearr_103273_103313[(2)] = inst_103244);

(statearr_103273_103313[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (13))){
var state_103260__$1 = state_103260;
var statearr_103274_103314 = state_103260__$1;
(statearr_103274_103314[(2)] = null);

(statearr_103274_103314[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (22))){
var inst_103215 = (state_103260[(7)]);
var inst_103213 = (state_103260[(8)]);
var inst_103243 = (state_103260[(9)]);
var inst_103214 = (state_103260[(10)]);
var inst_103230 = (state_103260[(11)]);
var inst_103246 = (function (){var base_node = inst_103213;
var first_flake = inst_103214;
var node_t = inst_103215;
var source = inst_103230;
var coll = inst_103243;
return ((function (base_node,first_flake,node_t,source,coll,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch){
return (function (f){
return f.op === false;
});
;})(base_node,first_flake,node_t,source,coll,inst_103215,inst_103213,inst_103243,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch))
})();
var state_103260__$1 = state_103260;
var statearr_103275_103315 = state_103260__$1;
(statearr_103275_103315[(2)] = inst_103246);

(statearr_103275_103315[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (6))){
var state_103260__$1 = state_103260;
var statearr_103276_103316 = state_103260__$1;
(statearr_103276_103316[(2)] = cljs.core.cst$kw$novelty);

(statearr_103276_103316[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (17))){
var inst_103215 = (state_103260[(7)]);
var inst_103213 = (state_103260[(8)]);
var inst_103214 = (state_103260[(10)]);
var inst_103230 = (state_103260[(11)]);
var inst_103233 = (function (){var base_node = inst_103213;
var first_flake = inst_103214;
var node_t = inst_103215;
var source = inst_103230;
return ((function (base_node,first_flake,node_t,source,inst_103215,inst_103213,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch){
return (function (p1__103202_SHARP_){
return (p1__103202_SHARP_.t <= t);
});
;})(base_node,first_flake,node_t,source,inst_103215,inst_103213,inst_103214,inst_103230,state_val_103261,c__99059__auto___103302,result_ch))
})();
var inst_103234 = fluree.db.dbproto._resolve_history(node);
var state_103260__$1 = (function (){var statearr_103277 = state_103260;
(statearr_103277[(12)] = inst_103233);

return statearr_103277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103260__$1,(18),inst_103234);
} else {
if((state_val_103261 === (3))){
var inst_103203 = (state_103260[(2)]);
var inst_103204 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_103205 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_103203);
var inst_103206 = cljs.core.async.close_BANG_(result_ch);
var state_103260__$1 = (function (){var statearr_103278 = state_103260;
(statearr_103278[(13)] = inst_103205);

(statearr_103278[(14)] = inst_103204);

return statearr_103278;
})();
var statearr_103279_103317 = state_103260__$1;
(statearr_103279_103317[(2)] = inst_103206);


cljs.core.async.impl.ioc_helpers.process_exception(state_103260__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (12))){
var state_103260__$1 = state_103260;
var statearr_103280_103318 = state_103260__$1;
(statearr_103280_103318[(2)] = cljs.core.cst$kw$none);

(statearr_103280_103318[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (2))){
var inst_103258 = (state_103260[(2)]);
var state_103260__$1 = state_103260;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103260__$1,inst_103258);
} else {
if((state_val_103261 === (23))){
var state_103260__$1 = state_103260;
var statearr_103281_103319 = state_103260__$1;
(statearr_103281_103319[(2)] = null);

(statearr_103281_103319[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (19))){
var inst_103240 = cljs.core.PersistentVector.EMPTY;
var state_103260__$1 = state_103260;
var statearr_103282_103320 = state_103260__$1;
(statearr_103282_103320[(2)] = inst_103240);

(statearr_103282_103320[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (11))){
var inst_103228 = (state_103260[(2)]);
var state_103260__$1 = state_103260;
var statearr_103283_103321 = state_103260__$1;
(statearr_103283_103321[(2)] = inst_103228);

(statearr_103283_103321[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (9))){
var state_103260__$1 = state_103260;
var statearr_103284_103322 = state_103260__$1;
(statearr_103284_103322[(2)] = cljs.core.cst$kw$history);

(statearr_103284_103322[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (5))){
var inst_103215 = (state_103260[(7)]);
var inst_103213 = (state_103260[(8)]);
var inst_103212 = (state_103260[(2)]);
var inst_103213__$1 = fluree.db.util.async.throw_err(inst_103212);
var inst_103214 = fluree.db.dbproto._first_flake(inst_103213__$1);
var inst_103215__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_103213__$1);
var inst_103216 = (inst_103215__$1 > t);
var state_103260__$1 = (function (){var statearr_103285 = state_103260;
(statearr_103285[(7)] = inst_103215__$1);

(statearr_103285[(8)] = inst_103213__$1);

(statearr_103285[(10)] = inst_103214);

return statearr_103285;
})();
if(cljs.core.truth_(inst_103216)){
var statearr_103286_103323 = state_103260__$1;
(statearr_103286_103323[(1)] = (6));

} else {
var statearr_103287_103324 = state_103260__$1;
(statearr_103287_103324[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (14))){
var inst_103226 = (state_103260[(2)]);
var state_103260__$1 = state_103260;
var statearr_103288_103325 = state_103260__$1;
(statearr_103288_103325[(2)] = inst_103226);

(statearr_103288_103325[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (16))){
var inst_103214 = (state_103260[(10)]);
var inst_103231 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_103214,rhs,leftmost_QMARK_,t);
var state_103260__$1 = state_103260;
var statearr_103289_103326 = state_103260__$1;
(statearr_103289_103326[(2)] = inst_103231);

(statearr_103289_103326[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (10))){
var inst_103215 = (state_103260[(7)]);
var inst_103222 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_103215,t);
var state_103260__$1 = state_103260;
if(inst_103222){
var statearr_103290_103327 = state_103260__$1;
(statearr_103290_103327[(1)] = (12));

} else {
var statearr_103291_103328 = state_103260__$1;
(statearr_103291_103328[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (18))){
var inst_103233 = (state_103260[(12)]);
var inst_103236 = (state_103260[(2)]);
var inst_103237 = fluree.db.util.async.throw_err(inst_103236);
var inst_103238 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_103233,inst_103237);
var state_103260__$1 = state_103260;
var statearr_103292_103329 = state_103260__$1;
(statearr_103292_103329[(2)] = inst_103238);

(statearr_103292_103329[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103261 === (8))){
var inst_103230 = (state_103260[(11)]);
var inst_103230__$1 = (state_103260[(2)]);
var state_103260__$1 = (function (){var statearr_103293 = state_103260;
(statearr_103293[(11)] = inst_103230__$1);

return statearr_103293;
})();
var G__103294_103330 = inst_103230__$1;
var G__103294_103331__$1 = (((G__103294_103330 instanceof cljs.core.Keyword))?G__103294_103330.fqn:null);
switch (G__103294_103331__$1) {
case "novelty":
var statearr_103295_103333 = state_103260__$1;
(statearr_103295_103333[(1)] = (16));


break;
case "history":
var statearr_103296_103334 = state_103260__$1;
(statearr_103296_103334[(1)] = (17));


break;
case "none":
var statearr_103297_103335 = state_103260__$1;
(statearr_103297_103335[(1)] = (19));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__103294_103331__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___103302,result_ch))
;
return ((function (switch__99036__auto__,c__99059__auto___103302,result_ch){
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____0 = (function (){
var statearr_103298 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103298[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__);

(statearr_103298[(1)] = (1));

return statearr_103298;
});
var fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____1 = (function (state_103260){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103260);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103299){if((e103299 instanceof Object)){
var ex__99040__auto__ = e103299;
var statearr_103300_103336 = state_103260;
(statearr_103300_103336[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103260);

return cljs.core.cst$kw$recur;
} else {
throw e103299;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103337 = state_103260;
state_103260 = G__103337;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__ = function(state_103260){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____1.call(this,state_103260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__99037__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___103302,result_ch))
})();
var state__99061__auto__ = (function (){var statearr_103301 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103301[(6)] = c__99059__auto___103302);

return statearr_103301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___103302,result_ch))
);


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103391){
var state_val_103392 = (state_103391[(1)]);
if((state_val_103392 === (7))){
var inst_103371 = (state_103391[(2)]);
var inst_103372 = fluree.db.dbproto._first_flake(node);
var inst_103373 = fluree.db.dbproto._rhs(node);
var inst_103374 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_103391__$1 = (function (){var statearr_103393 = state_103391;
(statearr_103393[(7)] = inst_103372);

(statearr_103393[(8)] = inst_103373);

(statearr_103393[(9)] = inst_103371);

return statearr_103393;
})();
if(cljs.core.truth_(inst_103374)){
var statearr_103394_103422 = state_103391__$1;
(statearr_103394_103422[(1)] = (15));

} else {
var statearr_103395_103423 = state_103391__$1;
(statearr_103395_103423[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (1))){
var state_103391__$1 = state_103391;
var statearr_103396_103424 = state_103391__$1;
(statearr_103396_103424[(2)] = null);

(statearr_103396_103424[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (4))){
var inst_103346 = (state_103391[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103391,(3),java.lang.Exception,null,(2));
var inst_103346__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_103347 = (from_t == null);
var inst_103348 = (inst_103346__$1 <= from_t);
var inst_103349 = ((inst_103347) || (inst_103348));
var state_103391__$1 = (function (){var statearr_103397 = state_103391;
(statearr_103397[(10)] = inst_103346__$1);

return statearr_103397;
})();
if(cljs.core.truth_(inst_103349)){
var statearr_103398_103425 = state_103391__$1;
(statearr_103398_103425[(1)] = (5));

} else {
var statearr_103399_103426 = state_103391__$1;
(statearr_103399_103426[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (15))){
var state_103391__$1 = state_103391;
var statearr_103400_103427 = state_103391__$1;
(statearr_103400_103427[(2)] = null);

(statearr_103400_103427[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (13))){
var inst_103362 = (state_103391[(11)]);
var state_103391__$1 = state_103391;
var statearr_103401_103428 = state_103391__$1;
(statearr_103401_103428[(2)] = inst_103362);

(statearr_103401_103428[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (6))){
var state_103391__$1 = state_103391;
var statearr_103402_103429 = state_103391__$1;
(statearr_103402_103429[(2)] = null);

(statearr_103402_103429[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (17))){
var inst_103372 = (state_103391[(7)]);
var inst_103373 = (state_103391[(8)]);
var inst_103371 = (state_103391[(9)]);
var inst_103385 = (state_103391[(2)]);
var inst_103386 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_103372,inst_103373,leftmost_QMARK_,to_t);
var inst_103387 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_103386,inst_103371);
var state_103391__$1 = (function (){var statearr_103403 = state_103391;
(statearr_103403[(12)] = inst_103385);

return statearr_103403;
})();
var statearr_103404_103430 = state_103391__$1;
(statearr_103404_103430[(2)] = inst_103387);


cljs.core.async.impl.ioc_helpers.process_exception(state_103391__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (3))){
var inst_103340 = (state_103391[(2)]);
var inst_103341 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_103340], 0));
var inst_103342 = (function(){throw inst_103340})();
var state_103391__$1 = (function (){var statearr_103405 = state_103391;
(statearr_103405[(13)] = inst_103341);

return statearr_103405;
})();
var statearr_103406_103431 = state_103391__$1;
(statearr_103406_103431[(2)] = inst_103342);


cljs.core.async.impl.ioc_helpers.process_exception(state_103391__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (12))){
var inst_103362 = (state_103391[(11)]);
var inst_103346 = (state_103391[(10)]);
var inst_103364 = (function (){var node_t = inst_103346;
var G__103351 = inst_103362;
return ((function (node_t,G__103351,inst_103362,inst_103346,state_val_103392,c__99059__auto__){
return (function (p1__103339_SHARP_){
return (p1__103339_SHARP_.t <= from_t);
});
;})(node_t,G__103351,inst_103362,inst_103346,state_val_103392,c__99059__auto__))
})();
var inst_103365 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_103364,inst_103362);
var state_103391__$1 = state_103391;
var statearr_103407_103432 = state_103391__$1;
(statearr_103407_103432[(2)] = inst_103365);

(statearr_103407_103432[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (2))){
var inst_103389 = (state_103391[(2)]);
var state_103391__$1 = state_103391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103391__$1,inst_103389);
} else {
if((state_val_103392 === (11))){
var inst_103362 = (state_103391[(2)]);
var state_103391__$1 = (function (){var statearr_103408 = state_103391;
(statearr_103408[(11)] = inst_103362);

return statearr_103408;
})();
if(cljs.core.truth_(from_t)){
var statearr_103409_103433 = state_103391__$1;
(statearr_103409_103433[(1)] = (12));

} else {
var statearr_103410_103434 = state_103391__$1;
(statearr_103410_103434[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (9))){
var inst_103355 = (state_103391[(14)]);
var inst_103346 = (state_103391[(10)]);
var inst_103358 = (function (){var node_t = inst_103346;
var G__103351 = inst_103355;
return ((function (node_t,G__103351,inst_103355,inst_103346,state_val_103392,c__99059__auto__){
return (function (p1__103338_SHARP_){
return (p1__103338_SHARP_.t < to_t);
});
;})(node_t,G__103351,inst_103355,inst_103346,state_val_103392,c__99059__auto__))
})();
var inst_103359 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_103358,inst_103355);
var state_103391__$1 = state_103391;
var statearr_103411_103435 = state_103391__$1;
(statearr_103411_103435[(2)] = inst_103359);

(statearr_103411_103435[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (5))){
var inst_103352 = fluree.db.dbproto._resolve_history(node);
var state_103391__$1 = state_103391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103391__$1,(8),inst_103352);
} else {
if((state_val_103392 === (14))){
var inst_103368 = (state_103391[(2)]);
var state_103391__$1 = state_103391;
var statearr_103412_103436 = state_103391__$1;
(statearr_103412_103436[(2)] = inst_103368);

(statearr_103412_103436[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (16))){
var inst_103377 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_103378 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_103377)].join('');
var inst_103379 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_103380 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_103381 = cljs.core.PersistentHashMap.fromArrays(inst_103379,inst_103380);
var inst_103382 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_103378,inst_103381);
var inst_103383 = (function(){throw inst_103382})();
var state_103391__$1 = state_103391;
var statearr_103413_103437 = state_103391__$1;
(statearr_103413_103437[(2)] = inst_103383);

(statearr_103413_103437[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (10))){
var inst_103355 = (state_103391[(14)]);
var state_103391__$1 = state_103391;
var statearr_103414_103438 = state_103391__$1;
(statearr_103414_103438[(2)] = inst_103355);

(statearr_103414_103438[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103392 === (8))){
var inst_103346 = (state_103391[(10)]);
var inst_103354 = (state_103391[(2)]);
var inst_103355 = fluree.db.util.async.throw_err(inst_103354);
var inst_103356 = (to_t > inst_103346);
var state_103391__$1 = (function (){var statearr_103415 = state_103391;
(statearr_103415[(14)] = inst_103355);

return statearr_103415;
})();
if(cljs.core.truth_(inst_103356)){
var statearr_103416_103439 = state_103391__$1;
(statearr_103416_103439[(1)] = (9));

} else {
var statearr_103417_103440 = state_103391__$1;
(statearr_103417_103440[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____0 = (function (){
var statearr_103418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103418[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__);

(statearr_103418[(1)] = (1));

return statearr_103418;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____1 = (function (state_103391){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103391);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103419){if((e103419 instanceof Object)){
var ex__99040__auto__ = e103419;
var statearr_103420_103441 = state_103391;
(statearr_103420_103441[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103391);

return cljs.core.cst$kw$recur;
} else {
throw e103419;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103442 = state_103391;
state_103391 = G__103442;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__ = function(state_103391){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____1.call(this,state_103391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_103421 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103421[(6)] = c__99059__auto__);

return statearr_103421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4131__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__103443_103453 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__103444_103454 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103443_103453,G__103444_103454) : object_cache.call(null,G__103443_103453,G__103444_103454));

var G__103445 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__103446 = ((function (G__103445,object_cache){
return (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,((function (G__103445,object_cache){
return (function (){
var G__103447 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__103448 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103447,G__103448) : object_cache.call(null,G__103447,G__103448));
});})(G__103445,object_cache))
);
});})(G__103445,object_cache))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103445,G__103446) : object_cache.call(null,G__103445,G__103446));
} else {
var G__103449 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__103450 = ((function (G__103449,object_cache){
return (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,((function (G__103449,object_cache){
return (function (){
var G__103451 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__103452 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103451,G__103452) : object_cache.call(null,G__103451,G__103452));
});})(G__103449,object_cache))
);
});})(G__103449,object_cache))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103449,G__103450) : object_cache.call(null,G__103449,G__103450));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103472){
var state_val_103473 = (state_103472[(1)]);
if((state_val_103473 === (1))){
var state_103472__$1 = state_103472;
var statearr_103474_103487 = state_103472__$1;
(statearr_103474_103487[(2)] = null);

(statearr_103474_103487[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103473 === (2))){
var inst_103470 = (state_103472[(2)]);
var state_103472__$1 = state_103472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103472__$1,inst_103470);
} else {
if((state_val_103473 === (3))){
var inst_103455 = (state_103472[(2)]);
var state_103472__$1 = state_103472;
var statearr_103475_103488 = state_103472__$1;
(statearr_103475_103488[(2)] = inst_103455);


cljs.core.async.impl.ioc_helpers.process_exception(state_103472__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103473 === (4))){
var inst_103459 = (state_103472[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103472,(3),Error,null,(2));
var inst_103459__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_103472__$1 = (function (){var statearr_103476 = state_103472;
(statearr_103476[(7)] = inst_103459__$1);

return statearr_103476;
})();
if(cljs.core.truth_(inst_103459__$1)){
var statearr_103477_103489 = state_103472__$1;
(statearr_103477_103489[(1)] = (5));

} else {
var statearr_103478_103490 = state_103472__$1;
(statearr_103478_103490[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103473 === (5))){
var inst_103459 = (state_103472[(7)]);
var inst_103461 = fluree.db.storage.core.serde(conn);
var state_103472__$1 = (function (){var statearr_103479 = state_103472;
(statearr_103479[(8)] = inst_103461);

return statearr_103479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103472__$1,(8),inst_103459);
} else {
if((state_val_103473 === (6))){
var state_103472__$1 = state_103472;
var statearr_103480_103491 = state_103472__$1;
(statearr_103480_103491[(2)] = null);

(statearr_103480_103491[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103473 === (7))){
var inst_103468 = (state_103472[(2)]);
var state_103472__$1 = state_103472;
var statearr_103481_103492 = state_103472__$1;
(statearr_103481_103492[(2)] = inst_103468);


cljs.core.async.impl.ioc_helpers.process_exception(state_103472__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103473 === (8))){
var inst_103461 = (state_103472[(8)]);
var inst_103463 = (state_103472[(2)]);
var inst_103464 = fluree.db.util.async.throw_err(inst_103463);
var inst_103465 = fluree.db.serde.protocol._deserialize_branch(inst_103461,inst_103464);
var state_103472__$1 = state_103472;
var statearr_103482_103493 = state_103472__$1;
(statearr_103482_103493[(2)] = inst_103465);

(statearr_103482_103493[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__99037__auto____0 = (function (){
var statearr_103483 = [null,null,null,null,null,null,null,null,null];
(statearr_103483[(0)] = fluree$db$storage$core$read_branch_$_state_machine__99037__auto__);

(statearr_103483[(1)] = (1));

return statearr_103483;
});
var fluree$db$storage$core$read_branch_$_state_machine__99037__auto____1 = (function (state_103472){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103472);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103484){if((e103484 instanceof Object)){
var ex__99040__auto__ = e103484;
var statearr_103485_103494 = state_103472;
(statearr_103485_103494[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103472);

return cljs.core.cst$kw$recur;
} else {
throw e103484;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103495 = state_103472;
state_103472 = G__103495;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__99037__auto__ = function(state_103472){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__99037__auto____1.call(this,state_103472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_103486 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103486[(6)] = c__99059__auto__);

return statearr_103486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___103630 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___103630,return_ch){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___103630,return_ch){
return (function (state_103582){
var state_val_103583 = (state_103582[(1)]);
if((state_val_103583 === (7))){
var state_103582__$1 = state_103582;
var statearr_103584_103631 = state_103582__$1;
(statearr_103584_103631[(2)] = null);

(statearr_103584_103631[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (20))){
var inst_103546 = (state_103582[(7)]);
var inst_103546__$1 = (state_103582[(2)]);
var inst_103547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103546__$1,cljs.core.cst$kw$children);
var inst_103548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103546__$1,cljs.core.cst$kw$rhs);
var inst_103550 = (config == null);
var inst_103551 = cljs.core.not(inst_103550);
var state_103582__$1 = (function (){var statearr_103585 = state_103582;
(statearr_103585[(7)] = inst_103546__$1);

(statearr_103585[(8)] = inst_103548);

(statearr_103585[(9)] = inst_103547);

return statearr_103585;
})();
if(inst_103551){
var statearr_103586_103632 = state_103582__$1;
(statearr_103586_103632[(1)] = (21));

} else {
var statearr_103587_103633 = state_103582__$1;
(statearr_103587_103633[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (27))){
var inst_103566 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_103582__$1 = state_103582;
var statearr_103588_103634 = state_103582__$1;
(statearr_103588_103634[(2)] = inst_103566);

(statearr_103588_103634[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (1))){
var state_103582__$1 = state_103582;
var statearr_103589_103635 = state_103582__$1;
(statearr_103589_103635[(2)] = null);

(statearr_103589_103635[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (24))){
var state_103582__$1 = state_103582;
var statearr_103590_103636 = state_103582__$1;
(statearr_103590_103636[(2)] = true);

(statearr_103590_103636[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103582,(3),java.lang.Exception,null,(2));
var inst_103505 = fluree.db.storage.core.read_branch(conn,key);
var state_103582__$1 = state_103582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103582__$1,(5),inst_103505);
} else {
if((state_val_103583 === (15))){
var state_103582__$1 = state_103582;
var statearr_103591_103637 = state_103582__$1;
(statearr_103591_103637[(2)] = true);

(statearr_103591_103637[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (21))){
var inst_103553 = config.cljs$lang$protocol_mask$partition0$;
var inst_103554 = (inst_103553 & (64));
var inst_103555 = config.cljs$core$ISeq$;
var inst_103556 = (cljs.core.PROTOCOL_SENTINEL === inst_103555);
var inst_103557 = ((inst_103554) || (inst_103556));
var state_103582__$1 = state_103582;
if(cljs.core.truth_(inst_103557)){
var statearr_103592_103638 = state_103582__$1;
(statearr_103592_103638[(1)] = (24));

} else {
var statearr_103593_103639 = state_103582__$1;
(statearr_103593_103639[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (13))){
var state_103582__$1 = state_103582;
var statearr_103594_103640 = state_103582__$1;
(statearr_103594_103640[(2)] = false);

(statearr_103594_103640[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (22))){
var state_103582__$1 = state_103582;
var statearr_103595_103641 = state_103582__$1;
(statearr_103595_103641[(2)] = false);

(statearr_103595_103641[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (29))){
var inst_103546 = (state_103582[(7)]);
var inst_103508 = (state_103582[(10)]);
var inst_103548 = (state_103582[(8)]);
var inst_103547 = (state_103582[(9)]);
var inst_103525 = (state_103582[(11)]);
var inst_103569 = (state_103582[(2)]);
var inst_103570 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103569,cljs.core.cst$kw$comparator);
var inst_103572 = (function (){var data = inst_103508;
var _ = inst_103525;
var map__103503 = inst_103546;
var children = inst_103547;
var rhs = inst_103548;
var map__103504 = inst_103569;
var comparator = inst_103570;
return ((function (data,_,map__103503,children,rhs,map__103504,comparator,inst_103546,inst_103508,inst_103548,inst_103547,inst_103525,inst_103569,inst_103570,state_val_103583,c__99059__auto___103630,return_ch){
return (function (idx,p__103571){
var map__103596 = p__103571;
var map__103596__$1 = (((((!((map__103596 == null))))?(((((map__103596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__103596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__103596):map__103596);
var child = map__103596__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103596__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103596__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103596__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103596__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103596__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4120__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (idx === (0));
} else {
return and__4120__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
;})(data,_,map__103503,children,rhs,map__103504,comparator,inst_103546,inst_103508,inst_103548,inst_103547,inst_103525,inst_103569,inst_103570,state_val_103583,c__99059__auto___103630,return_ch))
})();
var inst_103573 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_103572,inst_103547);
var inst_103574 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_103573);
var inst_103575 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_103574,inst_103573);
var inst_103576 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_103570,inst_103575);
var inst_103577 = fluree.db.index.__GT_IndexNode(block,t,inst_103548,inst_103576,config,leftmost_QMARK_);
var inst_103578 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103577);
var state_103582__$1 = state_103582;
var statearr_103598_103642 = state_103582__$1;
(statearr_103598_103642[(2)] = inst_103578);


cljs.core.async.impl.ioc_helpers.process_exception(state_103582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (6))){
var inst_103511 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_103512 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_103513 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_103514 = cljs.core.PersistentHashMap.fromArrays(inst_103512,inst_103513);
var inst_103515 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_103511,inst_103514);
var inst_103516 = (function(){throw inst_103515})();
var state_103582__$1 = state_103582;
var statearr_103599_103643 = state_103582__$1;
(statearr_103599_103643[(2)] = inst_103516);

(statearr_103599_103643[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (28))){
var state_103582__$1 = state_103582;
var statearr_103600_103644 = state_103582__$1;
(statearr_103600_103644[(2)] = config);

(statearr_103600_103644[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (25))){
var state_103582__$1 = state_103582;
var statearr_103601_103645 = state_103582__$1;
(statearr_103601_103645[(2)] = false);

(statearr_103601_103645[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (17))){
var inst_103538 = (state_103582[(2)]);
var state_103582__$1 = state_103582;
var statearr_103602_103646 = state_103582__$1;
(statearr_103602_103646[(2)] = inst_103538);

(statearr_103602_103646[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (3))){
var inst_103496 = (state_103582[(2)]);
var inst_103497 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_103498 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103496);
var inst_103499 = cljs.core.async.close_BANG_(return_ch);
var state_103582__$1 = (function (){var statearr_103603 = state_103582;
(statearr_103603[(12)] = inst_103497);

(statearr_103603[(13)] = inst_103498);

return statearr_103603;
})();
var statearr_103604_103647 = state_103582__$1;
(statearr_103604_103647[(2)] = inst_103499);


cljs.core.async.impl.ioc_helpers.process_exception(state_103582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (12))){
var inst_103508 = (state_103582[(10)]);
var inst_103530 = inst_103508.cljs$lang$protocol_mask$partition0$;
var inst_103531 = (inst_103530 & (64));
var inst_103532 = inst_103508.cljs$core$ISeq$;
var inst_103533 = (cljs.core.PROTOCOL_SENTINEL === inst_103532);
var inst_103534 = ((inst_103531) || (inst_103533));
var state_103582__$1 = state_103582;
if(cljs.core.truth_(inst_103534)){
var statearr_103605_103648 = state_103582__$1;
(statearr_103605_103648[(1)] = (15));

} else {
var statearr_103606_103649 = state_103582__$1;
(statearr_103606_103649[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (2))){
var inst_103580 = (state_103582[(2)]);
var state_103582__$1 = state_103582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103582__$1,inst_103580);
} else {
if((state_val_103583 === (23))){
var inst_103564 = (state_103582[(2)]);
var state_103582__$1 = state_103582;
if(cljs.core.truth_(inst_103564)){
var statearr_103607_103650 = state_103582__$1;
(statearr_103607_103650[(1)] = (27));

} else {
var statearr_103608_103651 = state_103582__$1;
(statearr_103608_103651[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (19))){
var inst_103508 = (state_103582[(10)]);
var state_103582__$1 = state_103582;
var statearr_103609_103652 = state_103582__$1;
(statearr_103609_103652[(2)] = inst_103508);

(statearr_103609_103652[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (11))){
var inst_103508 = (state_103582[(10)]);
var inst_103525 = (state_103582[(2)]);
var inst_103527 = (inst_103508 == null);
var inst_103528 = cljs.core.not(inst_103527);
var state_103582__$1 = (function (){var statearr_103610 = state_103582;
(statearr_103610[(11)] = inst_103525);

return statearr_103610;
})();
if(inst_103528){
var statearr_103611_103653 = state_103582__$1;
(statearr_103611_103653[(1)] = (12));

} else {
var statearr_103612_103654 = state_103582__$1;
(statearr_103612_103654[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (9))){
var inst_103508 = (state_103582[(10)]);
var inst_103522 = (function(){throw inst_103508})();
var state_103582__$1 = state_103582;
var statearr_103613_103655 = state_103582__$1;
(statearr_103613_103655[(2)] = inst_103522);

(statearr_103613_103655[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (5))){
var inst_103508 = (state_103582[(10)]);
var inst_103507 = (state_103582[(2)]);
var inst_103508__$1 = fluree.db.util.async.throw_err(inst_103507);
var inst_103509 = (inst_103508__$1 == null);
var state_103582__$1 = (function (){var statearr_103614 = state_103582;
(statearr_103614[(10)] = inst_103508__$1);

return statearr_103614;
})();
if(cljs.core.truth_(inst_103509)){
var statearr_103615_103656 = state_103582__$1;
(statearr_103615_103656[(1)] = (6));

} else {
var statearr_103616_103657 = state_103582__$1;
(statearr_103616_103657[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (14))){
var inst_103541 = (state_103582[(2)]);
var state_103582__$1 = state_103582;
if(cljs.core.truth_(inst_103541)){
var statearr_103617_103658 = state_103582__$1;
(statearr_103617_103658[(1)] = (18));

} else {
var statearr_103618_103659 = state_103582__$1;
(statearr_103618_103659[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (26))){
var inst_103561 = (state_103582[(2)]);
var state_103582__$1 = state_103582;
var statearr_103619_103660 = state_103582__$1;
(statearr_103619_103660[(2)] = inst_103561);

(statearr_103619_103660[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (16))){
var state_103582__$1 = state_103582;
var statearr_103620_103661 = state_103582__$1;
(statearr_103620_103661[(2)] = false);

(statearr_103620_103661[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (10))){
var state_103582__$1 = state_103582;
var statearr_103621_103662 = state_103582__$1;
(statearr_103621_103662[(2)] = null);

(statearr_103621_103662[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (18))){
var inst_103508 = (state_103582[(10)]);
var inst_103543 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_103508);
var state_103582__$1 = state_103582;
var statearr_103622_103663 = state_103582__$1;
(statearr_103622_103663[(2)] = inst_103543);

(statearr_103622_103663[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103583 === (8))){
var inst_103508 = (state_103582[(10)]);
var inst_103519 = (state_103582[(2)]);
var inst_103520 = fluree.db.util.core.exception_QMARK_(inst_103508);
var state_103582__$1 = (function (){var statearr_103623 = state_103582;
(statearr_103623[(14)] = inst_103519);

return statearr_103623;
})();
if(inst_103520){
var statearr_103624_103664 = state_103582__$1;
(statearr_103624_103664[(1)] = (9));

} else {
var statearr_103625_103665 = state_103582__$1;
(statearr_103625_103665[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___103630,return_ch))
;
return ((function (switch__99036__auto__,c__99059__auto___103630,return_ch){
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____0 = (function (){
var statearr_103626 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103626[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__);

(statearr_103626[(1)] = (1));

return statearr_103626;
});
var fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____1 = (function (state_103582){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103582);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103627){if((e103627 instanceof Object)){
var ex__99040__auto__ = e103627;
var statearr_103628_103666 = state_103582;
(statearr_103628_103666[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103582);

return cljs.core.cst$kw$recur;
} else {
throw e103627;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103667 = state_103582;
state_103582 = G__103667;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__ = function(state_103582){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____1.call(this,state_103582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__99037__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___103630,return_ch))
})();
var state__99061__auto__ = (function (){var statearr_103629 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103629[(6)] = c__99059__auto___103630);

return statearr_103629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___103630,return_ch))
);


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103685){
var state_val_103686 = (state_103685[(1)]);
if((state_val_103686 === (1))){
var state_103685__$1 = state_103685;
var statearr_103687_103700 = state_103685__$1;
(statearr_103687_103700[(2)] = null);

(statearr_103687_103700[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103686 === (2))){
var inst_103683 = (state_103685[(2)]);
var state_103685__$1 = state_103685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103685__$1,inst_103683);
} else {
if((state_val_103686 === (3))){
var inst_103668 = (state_103685[(2)]);
var state_103685__$1 = state_103685;
var statearr_103688_103701 = state_103685__$1;
(statearr_103688_103701[(2)] = inst_103668);


cljs.core.async.impl.ioc_helpers.process_exception(state_103685__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103686 === (4))){
var inst_103672 = (state_103685[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103685,(3),Error,null,(2));
var inst_103672__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_103685__$1 = (function (){var statearr_103689 = state_103685;
(statearr_103689[(7)] = inst_103672__$1);

return statearr_103689;
})();
if(cljs.core.truth_(inst_103672__$1)){
var statearr_103690_103702 = state_103685__$1;
(statearr_103690_103702[(1)] = (5));

} else {
var statearr_103691_103703 = state_103685__$1;
(statearr_103691_103703[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103686 === (5))){
var inst_103672 = (state_103685[(7)]);
var inst_103674 = fluree.db.storage.core.serde(conn);
var state_103685__$1 = (function (){var statearr_103692 = state_103685;
(statearr_103692[(8)] = inst_103674);

return statearr_103692;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103685__$1,(8),inst_103672);
} else {
if((state_val_103686 === (6))){
var state_103685__$1 = state_103685;
var statearr_103693_103704 = state_103685__$1;
(statearr_103693_103704[(2)] = null);

(statearr_103693_103704[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103686 === (7))){
var inst_103681 = (state_103685[(2)]);
var state_103685__$1 = state_103685;
var statearr_103694_103705 = state_103685__$1;
(statearr_103694_103705[(2)] = inst_103681);


cljs.core.async.impl.ioc_helpers.process_exception(state_103685__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103686 === (8))){
var inst_103674 = (state_103685[(8)]);
var inst_103676 = (state_103685[(2)]);
var inst_103677 = fluree.db.util.async.throw_err(inst_103676);
var inst_103678 = fluree.db.serde.protocol._deserialize_leaf(inst_103674,inst_103677);
var state_103685__$1 = state_103685;
var statearr_103695_103706 = state_103685__$1;
(statearr_103695_103706[(2)] = inst_103678);

(statearr_103695_103706[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____0 = (function (){
var statearr_103696 = [null,null,null,null,null,null,null,null,null];
(statearr_103696[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__);

(statearr_103696[(1)] = (1));

return statearr_103696;
});
var fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____1 = (function (state_103685){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103685);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103697){if((e103697 instanceof Object)){
var ex__99040__auto__ = e103697;
var statearr_103698_103707 = state_103685;
(statearr_103698_103707[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103685);

return cljs.core.cst$kw$recur;
} else {
throw e103697;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103708 = state_103685;
state_103685 = G__103708;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__ = function(state_103685){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____1.call(this,state_103685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_103699 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103699[(6)] = c__99059__auto__);

return statearr_103699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__99059__auto___103835 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto___103835,return_ch){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto___103835,return_ch){
return (function (state_103789){
var state_val_103790 = (state_103789[(1)]);
if((state_val_103790 === (7))){
var state_103789__$1 = state_103789;
var statearr_103791_103836 = state_103789__$1;
(statearr_103791_103836[(2)] = null);

(statearr_103791_103836[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (20))){
var inst_103758 = (state_103789[(2)]);
var inst_103759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103758,cljs.core.cst$kw$flakes);
var inst_103760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103758,cljs.core.cst$kw$his);
var inst_103762 = (config == null);
var inst_103763 = cljs.core.not(inst_103762);
var state_103789__$1 = (function (){var statearr_103792 = state_103789;
(statearr_103792[(7)] = inst_103759);

(statearr_103792[(8)] = inst_103760);

return statearr_103792;
})();
if(inst_103763){
var statearr_103793_103837 = state_103789__$1;
(statearr_103793_103837[(1)] = (21));

} else {
var statearr_103794_103838 = state_103789__$1;
(statearr_103794_103838[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (27))){
var inst_103778 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_103789__$1 = state_103789;
var statearr_103795_103839 = state_103789__$1;
(statearr_103795_103839[(2)] = inst_103778);

(statearr_103795_103839[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (1))){
var state_103789__$1 = state_103789;
var statearr_103796_103840 = state_103789__$1;
(statearr_103796_103840[(2)] = null);

(statearr_103796_103840[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (24))){
var state_103789__$1 = state_103789;
var statearr_103797_103841 = state_103789__$1;
(statearr_103797_103841[(2)] = true);

(statearr_103797_103841[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103789,(3),java.lang.Exception,null,(2));
var inst_103718 = fluree.db.storage.core.read_leaf(conn,key);
var state_103789__$1 = state_103789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103789__$1,(5),inst_103718);
} else {
if((state_val_103790 === (15))){
var state_103789__$1 = state_103789;
var statearr_103798_103842 = state_103789__$1;
(statearr_103798_103842[(2)] = true);

(statearr_103798_103842[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (21))){
var inst_103765 = config.cljs$lang$protocol_mask$partition0$;
var inst_103766 = (inst_103765 & (64));
var inst_103767 = config.cljs$core$ISeq$;
var inst_103768 = (cljs.core.PROTOCOL_SENTINEL === inst_103767);
var inst_103769 = ((inst_103766) || (inst_103768));
var state_103789__$1 = state_103789;
if(cljs.core.truth_(inst_103769)){
var statearr_103799_103843 = state_103789__$1;
(statearr_103799_103843[(1)] = (24));

} else {
var statearr_103800_103844 = state_103789__$1;
(statearr_103800_103844[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (13))){
var state_103789__$1 = state_103789;
var statearr_103801_103845 = state_103789__$1;
(statearr_103801_103845[(2)] = false);

(statearr_103801_103845[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (22))){
var state_103789__$1 = state_103789;
var statearr_103802_103846 = state_103789__$1;
(statearr_103802_103846[(2)] = false);

(statearr_103802_103846[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (29))){
var inst_103759 = (state_103789[(7)]);
var inst_103781 = (state_103789[(2)]);
var inst_103782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_103781,cljs.core.cst$kw$comparator);
var inst_103783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_103782,inst_103759);
var inst_103784 = fluree.db.index.data_node(block,t,inst_103783,rhs,config);
var inst_103785 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103784);
var state_103789__$1 = state_103789;
var statearr_103803_103847 = state_103789__$1;
(statearr_103803_103847[(2)] = inst_103785);


cljs.core.async.impl.ioc_helpers.process_exception(state_103789__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (6))){
var inst_103723 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_103724 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_103725 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_103726 = cljs.core.PersistentHashMap.fromArrays(inst_103724,inst_103725);
var inst_103727 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_103723,inst_103726);
var inst_103728 = (function(){throw inst_103727})();
var state_103789__$1 = state_103789;
var statearr_103804_103848 = state_103789__$1;
(statearr_103804_103848[(2)] = inst_103728);

(statearr_103804_103848[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (28))){
var state_103789__$1 = state_103789;
var statearr_103805_103849 = state_103789__$1;
(statearr_103805_103849[(2)] = config);

(statearr_103805_103849[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (25))){
var state_103789__$1 = state_103789;
var statearr_103806_103850 = state_103789__$1;
(statearr_103806_103850[(2)] = false);

(statearr_103806_103850[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (17))){
var inst_103750 = (state_103789[(2)]);
var state_103789__$1 = state_103789;
var statearr_103807_103851 = state_103789__$1;
(statearr_103807_103851[(2)] = inst_103750);

(statearr_103807_103851[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (3))){
var inst_103709 = (state_103789[(2)]);
var inst_103710 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_103711 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_103709);
var inst_103712 = cljs.core.async.close_BANG_(return_ch);
var state_103789__$1 = (function (){var statearr_103808 = state_103789;
(statearr_103808[(9)] = inst_103710);

(statearr_103808[(10)] = inst_103711);

return statearr_103808;
})();
var statearr_103809_103852 = state_103789__$1;
(statearr_103809_103852[(2)] = inst_103712);


cljs.core.async.impl.ioc_helpers.process_exception(state_103789__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (12))){
var inst_103720 = (state_103789[(11)]);
var inst_103742 = inst_103720.cljs$lang$protocol_mask$partition0$;
var inst_103743 = (inst_103742 & (64));
var inst_103744 = inst_103720.cljs$core$ISeq$;
var inst_103745 = (cljs.core.PROTOCOL_SENTINEL === inst_103744);
var inst_103746 = ((inst_103743) || (inst_103745));
var state_103789__$1 = state_103789;
if(cljs.core.truth_(inst_103746)){
var statearr_103810_103853 = state_103789__$1;
(statearr_103810_103853[(1)] = (15));

} else {
var statearr_103811_103854 = state_103789__$1;
(statearr_103811_103854[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (2))){
var inst_103787 = (state_103789[(2)]);
var state_103789__$1 = state_103789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103789__$1,inst_103787);
} else {
if((state_val_103790 === (23))){
var inst_103776 = (state_103789[(2)]);
var state_103789__$1 = state_103789;
if(cljs.core.truth_(inst_103776)){
var statearr_103812_103855 = state_103789__$1;
(statearr_103812_103855[(1)] = (27));

} else {
var statearr_103813_103856 = state_103789__$1;
(statearr_103813_103856[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (19))){
var inst_103720 = (state_103789[(11)]);
var state_103789__$1 = state_103789;
var statearr_103814_103857 = state_103789__$1;
(statearr_103814_103857[(2)] = inst_103720);

(statearr_103814_103857[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (11))){
var inst_103720 = (state_103789[(11)]);
var inst_103737 = (state_103789[(2)]);
var inst_103739 = (inst_103720 == null);
var inst_103740 = cljs.core.not(inst_103739);
var state_103789__$1 = (function (){var statearr_103815 = state_103789;
(statearr_103815[(12)] = inst_103737);

return statearr_103815;
})();
if(inst_103740){
var statearr_103816_103858 = state_103789__$1;
(statearr_103816_103858[(1)] = (12));

} else {
var statearr_103817_103859 = state_103789__$1;
(statearr_103817_103859[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (9))){
var inst_103720 = (state_103789[(11)]);
var inst_103734 = (function(){throw inst_103720})();
var state_103789__$1 = state_103789;
var statearr_103818_103860 = state_103789__$1;
(statearr_103818_103860[(2)] = inst_103734);

(statearr_103818_103860[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (5))){
var inst_103720 = (state_103789[(11)]);
var inst_103720__$1 = (state_103789[(2)]);
var inst_103721 = (inst_103720__$1 == null);
var state_103789__$1 = (function (){var statearr_103819 = state_103789;
(statearr_103819[(11)] = inst_103720__$1);

return statearr_103819;
})();
if(cljs.core.truth_(inst_103721)){
var statearr_103820_103861 = state_103789__$1;
(statearr_103820_103861[(1)] = (6));

} else {
var statearr_103821_103862 = state_103789__$1;
(statearr_103821_103862[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (14))){
var inst_103753 = (state_103789[(2)]);
var state_103789__$1 = state_103789;
if(cljs.core.truth_(inst_103753)){
var statearr_103822_103863 = state_103789__$1;
(statearr_103822_103863[(1)] = (18));

} else {
var statearr_103823_103864 = state_103789__$1;
(statearr_103823_103864[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (26))){
var inst_103773 = (state_103789[(2)]);
var state_103789__$1 = state_103789;
var statearr_103824_103865 = state_103789__$1;
(statearr_103824_103865[(2)] = inst_103773);

(statearr_103824_103865[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (16))){
var state_103789__$1 = state_103789;
var statearr_103825_103866 = state_103789__$1;
(statearr_103825_103866[(2)] = false);

(statearr_103825_103866[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (10))){
var state_103789__$1 = state_103789;
var statearr_103826_103867 = state_103789__$1;
(statearr_103826_103867[(2)] = null);

(statearr_103826_103867[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (18))){
var inst_103720 = (state_103789[(11)]);
var inst_103755 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_103720);
var state_103789__$1 = state_103789;
var statearr_103827_103868 = state_103789__$1;
(statearr_103827_103868[(2)] = inst_103755);

(statearr_103827_103868[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103790 === (8))){
var inst_103720 = (state_103789[(11)]);
var inst_103731 = (state_103789[(2)]);
var inst_103732 = fluree.db.util.core.exception_QMARK_(inst_103720);
var state_103789__$1 = (function (){var statearr_103828 = state_103789;
(statearr_103828[(13)] = inst_103731);

return statearr_103828;
})();
if(inst_103732){
var statearr_103829_103869 = state_103789__$1;
(statearr_103829_103869[(1)] = (9));

} else {
var statearr_103830_103870 = state_103789__$1;
(statearr_103830_103870[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto___103835,return_ch))
;
return ((function (switch__99036__auto__,c__99059__auto___103835,return_ch){
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____0 = (function (){
var statearr_103831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_103831[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__);

(statearr_103831[(1)] = (1));

return statearr_103831;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____1 = (function (state_103789){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103789);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103832){if((e103832 instanceof Object)){
var ex__99040__auto__ = e103832;
var statearr_103833_103871 = state_103789;
(statearr_103833_103871[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103789);

return cljs.core.cst$kw$recur;
} else {
throw e103832;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103872 = state_103789;
state_103789 = G__103872;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__ = function(state_103789){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____1.call(this,state_103789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto___103835,return_ch))
})();
var state__99061__auto__ = (function (){var statearr_103834 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103834[(6)] = c__99059__auto___103835);

return statearr_103834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto___103835,return_ch))
);


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k103874,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__103878 = k103874;
var G__103878__$1 = (((G__103878 instanceof cljs.core.Keyword))?G__103878.fqn:null);
switch (G__103878__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k103874,else__4388__auto__);

}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__103879){
var vec__103880 = p__103879;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103880,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__103880,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__103873){
var self__ = this;
var G__103873__$1 = this;
return (new cljs.core.RecordIter((0),G__103873__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__103883 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__103884 = ((function (G__103883,object_cache,___$1){
return (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,((function (G__103883,object_cache,___$1){
return (function (){
var G__103885 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__103886 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103885,G__103886) : object_cache.call(null,G__103885,G__103886));
});})(G__103883,object_cache,___$1))
);
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,((function (G__103883,object_cache,___$1){
return (function (){
var G__103887 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__103888 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103887,G__103888) : object_cache.call(null,G__103887,G__103888));
});})(G__103883,object_cache,___$1))
);
}
});})(G__103883,object_cache,___$1))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103883,G__103884) : object_cache.call(null,G__103883,G__103884));
}
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = ((function (history_id,object_cache,___$1){
return (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});})(history_id,object_cache,___$1))
;
var G__103889 = history_id;
var G__103890 = ((function (G__103889,history_id,object_cache,error_fn,___$1){
return (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});})(G__103889,history_id,object_cache,error_fn,___$1))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__103889,G__103890) : object_cache.call(null,G__103889,G__103890));
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__103891 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__103891(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this103875,other103876){
var self__ = this;
var this103875__$1 = this;
return (((!((other103876 == null)))) && ((this103875__$1.constructor === other103876.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.conn,other103876.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.config,other103876.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.network,other103876.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.dbid,other103876.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.id,other103876.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.leaf,other103876.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.first,other103876.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.rhs,other103876.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.size,other103876.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.block,other103876.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.t,other103876.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.tt_id,other103876.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.leftmost_QMARK_,other103876.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.tempid,other103876.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this103875__$1.__extmap,other103876.__extmap)));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__103873){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__103892 = cljs.core.keyword_identical_QMARK_;
var expr__103893 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__103895 = cljs.core.cst$kw$conn;
var G__103896 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103895,G__103896) : pred__103892.call(null,G__103895,G__103896));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__103873,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103897 = cljs.core.cst$kw$config;
var G__103898 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103897,G__103898) : pred__103892.call(null,G__103897,G__103898));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__103873,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103899 = cljs.core.cst$kw$network;
var G__103900 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103899,G__103900) : pred__103892.call(null,G__103899,G__103900));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__103873,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103901 = cljs.core.cst$kw$dbid;
var G__103902 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103901,G__103902) : pred__103892.call(null,G__103901,G__103902));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__103873,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103903 = cljs.core.cst$kw$id;
var G__103904 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103903,G__103904) : pred__103892.call(null,G__103903,G__103904));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__103873,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103905 = cljs.core.cst$kw$leaf;
var G__103906 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103905,G__103906) : pred__103892.call(null,G__103905,G__103906));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__103873,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103907 = cljs.core.cst$kw$first;
var G__103908 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103907,G__103908) : pred__103892.call(null,G__103907,G__103908));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__103873,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103909 = cljs.core.cst$kw$rhs;
var G__103910 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103909,G__103910) : pred__103892.call(null,G__103909,G__103910));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__103873,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103911 = cljs.core.cst$kw$size;
var G__103912 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103911,G__103912) : pred__103892.call(null,G__103911,G__103912));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__103873,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103913 = cljs.core.cst$kw$block;
var G__103914 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103913,G__103914) : pred__103892.call(null,G__103913,G__103914));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__103873,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103915 = cljs.core.cst$kw$t;
var G__103916 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103915,G__103916) : pred__103892.call(null,G__103915,G__103916));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__103873,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103917 = cljs.core.cst$kw$tt_DASH_id;
var G__103918 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103917,G__103918) : pred__103892.call(null,G__103917,G__103918));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__103873,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103919 = cljs.core.cst$kw$leftmost_QMARK_;
var G__103920 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103919,G__103920) : pred__103892.call(null,G__103919,G__103920));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__103873,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__103921 = cljs.core.cst$kw$tempid;
var G__103922 = expr__103893;
return (pred__103892.cljs$core$IFn$_invoke$arity$2 ? pred__103892.cljs$core$IFn$_invoke$arity$2(G__103921,G__103922) : pred__103892.call(null,G__103921,G__103922));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__103873,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__103873),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__103873){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__103873,self__.__extmap,self__.__hash));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
});

fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true;

fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
});

fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.storage.core/UnresolvedNode");
});

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__103877){
var extmap__4424__auto__ = (function (){var G__103923 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__103877,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__103877)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__103923);
} else {
return G__103923;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__103877),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__103877),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__103925 = blank_db;
var map__103925__$1 = (((((!((map__103925 == null))))?(((((map__103925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__103925.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__103925):map__103925);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103925__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103925__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103925__$1,cljs.core.cst$kw$index_DASH_configs);
var map__103926 = root_data;
var map__103926__$1 = (((((!((map__103926 == null))))?(((((map__103926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__103926.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__103926):map__103926);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103926__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103926__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103926__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__103926__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__103925,map__103925__$1,network,dbid,index_configs,map__103926,map__103926__$1,block,t,ecount,stats,db_STAR_){
return (function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
});})(map__103925,map__103925__$1,network,dbid,index_configs,map__103926,map__103926__$1,block,t,ecount,stats,db_STAR_))
,db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103947){
var state_val_103948 = (state_103947[(1)]);
if((state_val_103948 === (1))){
var state_103947__$1 = state_103947;
var statearr_103949_103962 = state_103947__$1;
(statearr_103949_103962[(2)] = null);

(statearr_103949_103962[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103948 === (2))){
var inst_103945 = (state_103947[(2)]);
var state_103947__$1 = state_103947;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103947__$1,inst_103945);
} else {
if((state_val_103948 === (3))){
var inst_103929 = (state_103947[(2)]);
var state_103947__$1 = state_103947;
var statearr_103950_103963 = state_103947__$1;
(statearr_103950_103963[(2)] = inst_103929);


cljs.core.async.impl.ioc_helpers.process_exception(state_103947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103948 === (4))){
var inst_103934 = (state_103947[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103947,(3),Error,null,(2));
var inst_103933 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_103934__$1 = fluree.db.storage.core.storage_read(conn,inst_103933);
var state_103947__$1 = (function (){var statearr_103951 = state_103947;
(statearr_103951[(7)] = inst_103934__$1);

return statearr_103951;
})();
if(cljs.core.truth_(inst_103934__$1)){
var statearr_103952_103964 = state_103947__$1;
(statearr_103952_103964[(1)] = (5));

} else {
var statearr_103953_103965 = state_103947__$1;
(statearr_103953_103965[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103948 === (5))){
var inst_103934 = (state_103947[(7)]);
var inst_103936 = fluree.db.storage.core.serde(conn);
var state_103947__$1 = (function (){var statearr_103954 = state_103947;
(statearr_103954[(8)] = inst_103936);

return statearr_103954;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103947__$1,(8),inst_103934);
} else {
if((state_val_103948 === (6))){
var state_103947__$1 = state_103947;
var statearr_103955_103966 = state_103947__$1;
(statearr_103955_103966[(2)] = null);

(statearr_103955_103966[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103948 === (7))){
var inst_103943 = (state_103947[(2)]);
var state_103947__$1 = state_103947;
var statearr_103956_103967 = state_103947__$1;
(statearr_103956_103967[(2)] = inst_103943);


cljs.core.async.impl.ioc_helpers.process_exception(state_103947__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103948 === (8))){
var inst_103936 = (state_103947[(8)]);
var inst_103938 = (state_103947[(2)]);
var inst_103939 = fluree.db.util.async.throw_err(inst_103938);
var inst_103940 = fluree.db.serde.protocol._deserialize_garbage(inst_103936,inst_103939);
var state_103947__$1 = state_103947;
var statearr_103957_103968 = state_103947__$1;
(statearr_103957_103968[(2)] = inst_103940);

(statearr_103957_103968[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____0 = (function (){
var statearr_103958 = [null,null,null,null,null,null,null,null,null];
(statearr_103958[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__);

(statearr_103958[(1)] = (1));

return statearr_103958;
});
var fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____1 = (function (state_103947){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103947);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e103959){if((e103959 instanceof Object)){
var ex__99040__auto__ = e103959;
var statearr_103960_103969 = state_103947;
(statearr_103960_103969[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103947);

return cljs.core.cst$kw$recur;
} else {
throw e103959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__103970 = state_103947;
state_103947 = G__103970;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__ = function(state_103947){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____1.call(this,state_103947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_103961 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_103961[(6)] = c__99059__auto__);

return statearr_103961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_103989){
var state_val_103990 = (state_103989[(1)]);
if((state_val_103990 === (1))){
var state_103989__$1 = state_103989;
var statearr_103991_104004 = state_103989__$1;
(statearr_103991_104004[(2)] = null);

(statearr_103991_104004[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103990 === (2))){
var inst_103987 = (state_103989[(2)]);
var state_103989__$1 = state_103989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_103989__$1,inst_103987);
} else {
if((state_val_103990 === (3))){
var inst_103971 = (state_103989[(2)]);
var state_103989__$1 = state_103989;
var statearr_103992_104005 = state_103989__$1;
(statearr_103992_104005[(2)] = inst_103971);


cljs.core.async.impl.ioc_helpers.process_exception(state_103989__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103990 === (4))){
var inst_103976 = (state_103989[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_103989,(3),Error,null,(2));
var inst_103975 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_103976__$1 = fluree.db.storage.core.storage_read(conn,inst_103975);
var state_103989__$1 = (function (){var statearr_103993 = state_103989;
(statearr_103993[(7)] = inst_103976__$1);

return statearr_103993;
})();
if(cljs.core.truth_(inst_103976__$1)){
var statearr_103994_104006 = state_103989__$1;
(statearr_103994_104006[(1)] = (5));

} else {
var statearr_103995_104007 = state_103989__$1;
(statearr_103995_104007[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_103990 === (5))){
var inst_103976 = (state_103989[(7)]);
var inst_103978 = fluree.db.storage.core.serde(conn);
var state_103989__$1 = (function (){var statearr_103996 = state_103989;
(statearr_103996[(8)] = inst_103978);

return statearr_103996;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_103989__$1,(8),inst_103976);
} else {
if((state_val_103990 === (6))){
var state_103989__$1 = state_103989;
var statearr_103997_104008 = state_103989__$1;
(statearr_103997_104008[(2)] = null);

(statearr_103997_104008[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_103990 === (7))){
var inst_103985 = (state_103989[(2)]);
var state_103989__$1 = state_103989;
var statearr_103998_104009 = state_103989__$1;
(statearr_103998_104009[(2)] = inst_103985);


cljs.core.async.impl.ioc_helpers.process_exception(state_103989__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_103990 === (8))){
var inst_103978 = (state_103989[(8)]);
var inst_103980 = (state_103989[(2)]);
var inst_103981 = fluree.db.util.async.throw_err(inst_103980);
var inst_103982 = fluree.db.serde.protocol._deserialize_db_root(inst_103978,inst_103981);
var state_103989__$1 = state_103989;
var statearr_103999_104010 = state_103989__$1;
(statearr_103999_104010[(2)] = inst_103982);

(statearr_103999_104010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____0 = (function (){
var statearr_104000 = [null,null,null,null,null,null,null,null,null];
(statearr_104000[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__);

(statearr_104000[(1)] = (1));

return statearr_104000;
});
var fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____1 = (function (state_103989){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_103989);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104001){if((e104001 instanceof Object)){
var ex__99040__auto__ = e104001;
var statearr_104002_104011 = state_103989;
(statearr_104002_104011[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_103989);

return cljs.core.cst$kw$recur;
} else {
throw e104001;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104012 = state_103989;
state_103989 = G__104012;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__ = function(state_103989){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____1.call(this,state_103989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__99037__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104003 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104003[(6)] = c__99059__auto__);

return statearr_104003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104045){
var state_val_104046 = (state_104045[(1)]);
if((state_val_104046 === (7))){
var inst_104017 = (state_104045[(7)]);
var inst_104027 = (state_104045[(2)]);
var state_104045__$1 = (function (){var statearr_104047 = state_104045;
(statearr_104047[(8)] = inst_104027);

return statearr_104047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104045__$1,(8),inst_104017);
} else {
if((state_val_104046 === (1))){
var state_104045__$1 = state_104045;
var statearr_104048_104062 = state_104045__$1;
(statearr_104048_104062[(2)] = null);

(statearr_104048_104062[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (4))){
var inst_104017 = (state_104045[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104045,(3),Error,null,(2));
var inst_104017__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_104045__$1 = (function (){var statearr_104049 = state_104045;
(statearr_104049[(7)] = inst_104017__$1);

return statearr_104049;
})();
if(cljs.core.truth_(inst_104017__$1)){
var statearr_104050_104063 = state_104045__$1;
(statearr_104050_104063[(1)] = (5));

} else {
var statearr_104051_104064 = state_104045__$1;
(statearr_104051_104064[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (6))){
var inst_104020 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_104021 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_104022 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_104023 = cljs.core.PersistentHashMap.fromArrays(inst_104021,inst_104022);
var inst_104024 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_104020,inst_104023);
var inst_104025 = (function(){throw inst_104024})();
var state_104045__$1 = state_104045;
var statearr_104052_104065 = state_104045__$1;
(statearr_104052_104065[(2)] = inst_104025);

(statearr_104052_104065[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (3))){
var inst_104013 = (state_104045[(2)]);
var state_104045__$1 = state_104045;
var statearr_104053_104066 = state_104045__$1;
(statearr_104053_104066[(2)] = inst_104013);


cljs.core.async.impl.ioc_helpers.process_exception(state_104045__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (2))){
var inst_104043 = (state_104045[(2)]);
var state_104045__$1 = state_104045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104045__$1,inst_104043);
} else {
if((state_val_104046 === (9))){
var inst_104036 = (state_104045[(9)]);
var inst_104031 = (state_104045[(10)]);
var inst_104034 = (state_104045[(2)]);
var inst_104035 = fluree.db.util.async.throw_err(inst_104034);
var inst_104036__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_104031,cljs.core.cst$kw$schema,inst_104035);
var inst_104037 = fluree.db.query.schema.setting_map(inst_104036__$1);
var state_104045__$1 = (function (){var statearr_104054 = state_104045;
(statearr_104054[(9)] = inst_104036__$1);

return statearr_104054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104045__$1,(10),inst_104037);
} else {
if((state_val_104046 === (5))){
var state_104045__$1 = state_104045;
var statearr_104055_104067 = state_104045__$1;
(statearr_104055_104067[(2)] = null);

(statearr_104055_104067[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (10))){
var inst_104036 = (state_104045[(9)]);
var inst_104039 = (state_104045[(2)]);
var inst_104040 = fluree.db.util.async.throw_err(inst_104039);
var inst_104041 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_104036,cljs.core.cst$kw$settings,inst_104040);
var state_104045__$1 = state_104045;
var statearr_104056_104068 = state_104045__$1;
(statearr_104056_104068[(2)] = inst_104041);


cljs.core.async.impl.ioc_helpers.process_exception(state_104045__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104046 === (8))){
var inst_104031 = (state_104045[(10)]);
var inst_104029 = (state_104045[(2)]);
var inst_104030 = fluree.db.util.async.throw_err(inst_104029);
var inst_104031__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_104030);
var inst_104032 = fluree.db.query.schema.schema_map(inst_104031__$1);
var state_104045__$1 = (function (){var statearr_104057 = state_104045;
(statearr_104057[(10)] = inst_104031__$1);

return statearr_104057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104045__$1,(9),inst_104032);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__99037__auto____0 = (function (){
var statearr_104058 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_104058[(0)] = fluree$db$storage$core$reify_db_$_state_machine__99037__auto__);

(statearr_104058[(1)] = (1));

return statearr_104058;
});
var fluree$db$storage$core$reify_db_$_state_machine__99037__auto____1 = (function (state_104045){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104045);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104059){if((e104059 instanceof Object)){
var ex__99040__auto__ = e104059;
var statearr_104060_104069 = state_104045;
(statearr_104060_104069[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104045);

return cljs.core.cst$kw$recur;
} else {
throw e104059;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104070 = state_104045;
state_104045 = G__104070;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__99037__auto__ = function(state_104045){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__99037__auto____1.call(this,state_104045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__99037__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__99037__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104061 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104061[(6)] = c__99059__auto__);

return statearr_104061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__104072 = arguments.length;
switch (G__104072) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
});

fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104118){
var state_val_104119 = (state_104118[(1)]);
if((state_val_104119 === (7))){
var inst_104084 = (state_104118[(2)]);
var inst_104085 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_104086 = cljs.core.PersistentVector.EMPTY;
var inst_104087 = start;
var inst_104088 = inst_104086;
var state_104118__$1 = (function (){var statearr_104120 = state_104118;
(statearr_104120[(7)] = inst_104087);

(statearr_104120[(8)] = inst_104084);

(statearr_104120[(9)] = inst_104088);

(statearr_104120[(10)] = inst_104085);

return statearr_104120;
})();
var statearr_104121_104149 = state_104118__$1;
(statearr_104121_104149[(2)] = null);

(statearr_104121_104149[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (1))){
var state_104118__$1 = state_104118;
var statearr_104122_104150 = state_104118__$1;
(statearr_104122_104150[(2)] = null);

(statearr_104122_104150[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104118,(3),Error,null,(2));
var inst_104077 = (end >= start);
var state_104118__$1 = state_104118;
if(cljs.core.truth_(inst_104077)){
var statearr_104123_104151 = state_104118__$1;
(statearr_104123_104151[(1)] = (5));

} else {
var statearr_104124_104152 = state_104118__$1;
(statearr_104124_104152[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (15))){
var state_104118__$1 = state_104118;
var statearr_104125_104153 = state_104118__$1;
(statearr_104125_104153[(1)] = (17));



return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (13))){
var inst_104112 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
var statearr_104127_104154 = state_104118__$1;
(statearr_104127_104154[(2)] = inst_104112);

(statearr_104127_104154[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (6))){
var inst_104080 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_104081 = (new Error(inst_104080));
var inst_104082 = (function(){throw inst_104081})();
var state_104118__$1 = state_104118;
var statearr_104128_104155 = state_104118__$1;
(statearr_104128_104155[(2)] = inst_104082);

(statearr_104128_104155[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (17))){
var inst_104087 = (state_104118[(7)]);
var inst_104088 = (state_104118[(9)]);
var inst_104092 = (state_104118[(11)]);
var inst_104103 = (inst_104087 + (1));
var inst_104104 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_104088,inst_104092);
var inst_104087__$1 = inst_104103;
var inst_104088__$1 = inst_104104;
var state_104118__$1 = (function (){var statearr_104129 = state_104118;
(statearr_104129[(7)] = inst_104087__$1);

(statearr_104129[(9)] = inst_104088__$1);

return statearr_104129;
})();
var statearr_104130_104156 = state_104118__$1;
(statearr_104130_104156[(2)] = null);

(statearr_104130_104156[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (3))){
var inst_104073 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
var statearr_104131_104157 = state_104118__$1;
(statearr_104131_104157[(2)] = inst_104073);


cljs.core.async.impl.ioc_helpers.process_exception(state_104118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (12))){
var inst_104087 = (state_104118[(7)]);
var inst_104098 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_104087,end);
var state_104118__$1 = state_104118;
if(inst_104098){
var statearr_104132_104158 = state_104118__$1;
(statearr_104132_104158[(1)] = (14));

} else {
var statearr_104133_104159 = state_104118__$1;
(statearr_104133_104159[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (2))){
var inst_104116 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104118__$1,inst_104116);
} else {
if((state_val_104119 === (19))){
var inst_104108 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
var statearr_104134_104160 = state_104118__$1;
(statearr_104134_104160[(2)] = inst_104108);

(statearr_104134_104160[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (11))){
var inst_104088 = (state_104118[(9)]);
var state_104118__$1 = state_104118;
var statearr_104135_104161 = state_104118__$1;
(statearr_104135_104161[(2)] = inst_104088);

(statearr_104135_104161[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (9))){
var inst_104114 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
var statearr_104136_104162 = state_104118__$1;
(statearr_104136_104162[(2)] = inst_104114);


cljs.core.async.impl.ioc_helpers.process_exception(state_104118__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (5))){
var state_104118__$1 = state_104118;
var statearr_104137_104163 = state_104118__$1;
(statearr_104137_104163[(2)] = null);

(statearr_104137_104163[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (14))){
var inst_104088 = (state_104118[(9)]);
var inst_104092 = (state_104118[(11)]);
var inst_104100 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_104088,inst_104092);
var state_104118__$1 = state_104118;
var statearr_104138_104164 = state_104118__$1;
(statearr_104138_104164[(2)] = inst_104100);

(statearr_104138_104164[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (16))){
var inst_104110 = (state_104118[(2)]);
var state_104118__$1 = state_104118;
var statearr_104139_104165 = state_104118__$1;
(statearr_104139_104165[(2)] = inst_104110);

(statearr_104139_104165[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (10))){
var inst_104092 = (state_104118[(11)]);
var inst_104092__$1 = (state_104118[(2)]);
var inst_104093 = (inst_104092__$1 == null);
var inst_104094 = (inst_104092__$1 instanceof Error);
var inst_104095 = ((inst_104093) || (inst_104094));
var state_104118__$1 = (function (){var statearr_104140 = state_104118;
(statearr_104140[(11)] = inst_104092__$1);

return statearr_104140;
})();
if(cljs.core.truth_(inst_104095)){
var statearr_104141_104166 = state_104118__$1;
(statearr_104141_104166[(1)] = (11));

} else {
var statearr_104142_104167 = state_104118__$1;
(statearr_104142_104167[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (18))){
var state_104118__$1 = state_104118;
var statearr_104143_104168 = state_104118__$1;
(statearr_104143_104168[(2)] = null);

(statearr_104143_104168[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104119 === (8))){
var inst_104087 = (state_104118[(7)]);
var inst_104090 = fluree.db.storage.core.read_block(conn,network,dbid,inst_104087);
var state_104118__$1 = state_104118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104118__$1,(10),inst_104090);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$state_machine__99037__auto__ = null;
var fluree$db$storage$core$state_machine__99037__auto____0 = (function (){
var statearr_104144 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_104144[(0)] = fluree$db$storage$core$state_machine__99037__auto__);

(statearr_104144[(1)] = (1));

return statearr_104144;
});
var fluree$db$storage$core$state_machine__99037__auto____1 = (function (state_104118){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104118);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104145){if((e104145 instanceof Object)){
var ex__99040__auto__ = e104145;
var statearr_104146_104169 = state_104118;
(statearr_104146_104169[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104118);

return cljs.core.cst$kw$recur;
} else {
throw e104145;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104170 = state_104118;
state_104118 = G__104170;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__99037__auto__ = function(state_104118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__99037__auto____1.call(this,state_104118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__99037__auto____0;
fluree$db$storage$core$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__99037__auto____1;
return fluree$db$storage$core$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104147 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104147[(6)] = c__99059__auto__);

return statearr_104147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5;

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_104183){
var state_val_104184 = (state_104183[(1)]);
if((state_val_104184 === (1))){
var state_104183__$1 = state_104183;
var statearr_104185_104192 = state_104183__$1;
(statearr_104185_104192[(2)] = null);

(statearr_104185_104192[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_104184 === (2))){
var inst_104181 = (state_104183[(2)]);
var state_104183__$1 = state_104183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_104183__$1,inst_104181);
} else {
if((state_val_104184 === (3))){
var inst_104171 = (state_104183[(2)]);
var state_104183__$1 = state_104183;
var statearr_104186_104193 = state_104183__$1;
(statearr_104186_104193[(2)] = inst_104171);


cljs.core.async.impl.ioc_helpers.process_exception(state_104183__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_104184 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_104183,(3),Error,null,(2));
var inst_104175 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_104183__$1 = state_104183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_104183__$1,(5),inst_104175);
} else {
if((state_val_104184 === (5))){
var inst_104177 = (state_104183[(2)]);
var inst_104178 = fluree.db.util.async.throw_err(inst_104177);
var inst_104179 = cljs.core.first(inst_104178);
var state_104183__$1 = state_104183;
var statearr_104187_104194 = state_104183__$1;
(statearr_104187_104194[(2)] = inst_104179);


cljs.core.async.impl.ioc_helpers.process_exception(state_104183__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$storage$core$block_$_state_machine__99037__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__99037__auto____0 = (function (){
var statearr_104188 = [null,null,null,null,null,null,null];
(statearr_104188[(0)] = fluree$db$storage$core$block_$_state_machine__99037__auto__);

(statearr_104188[(1)] = (1));

return statearr_104188;
});
var fluree$db$storage$core$block_$_state_machine__99037__auto____1 = (function (state_104183){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_104183);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e104189){if((e104189 instanceof Object)){
var ex__99040__auto__ = e104189;
var statearr_104190_104195 = state_104183;
(statearr_104190_104195[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_104183);

return cljs.core.cst$kw$recur;
} else {
throw e104189;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__104196 = state_104183;
state_104183 = G__104196;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__99037__auto__ = function(state_104183){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__99037__auto____1.call(this,state_104183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__99037__auto____0;
fluree$db$storage$core$block_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__99037__auto____1;
return fluree$db$storage$core$block_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_104191 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_104191[(6)] = c__99059__auto__);

return statearr_104191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

//# sourceMappingURL=core.js.map?rel=1593118617071
