// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4131__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_99216){
var state_val_99217 = (state_99216[(1)]);
if((state_val_99217 === (7))){
var inst_99193 = (state_99216[(7)]);
var state_99216__$1 = state_99216;
var statearr_99218_99234 = state_99216__$1;
(statearr_99218_99234[(2)] = inst_99193);

(statearr_99218_99234[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (1))){
var state_99216__$1 = state_99216;
var statearr_99219_99235 = state_99216__$1;
(statearr_99219_99235[(2)] = null);

(statearr_99219_99235[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_99216,(3),java.lang.Exception,null,(2));
var inst_99189 = cljs.core.seq(chs);
var inst_99190 = cljs.core.first(inst_99189);
var inst_99191 = cljs.core.next(inst_99189);
var inst_99192 = chs;
var inst_99193 = coll;
var state_99216__$1 = (function (){var statearr_99220 = state_99216;
(statearr_99220[(8)] = inst_99192);

(statearr_99220[(9)] = inst_99190);

(statearr_99220[(10)] = inst_99191);

(statearr_99220[(7)] = inst_99193);

return statearr_99220;
})();
var statearr_99221_99236 = state_99216__$1;
(statearr_99221_99236[(2)] = null);

(statearr_99221_99236[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (6))){
var inst_99212 = (state_99216[(2)]);
var state_99216__$1 = state_99216;
var statearr_99222_99237 = state_99216__$1;
(statearr_99222_99237[(2)] = inst_99212);


cljs.core.async.impl.ioc_helpers.process_exception(state_99216__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (3))){
var inst_99178 = (state_99216[(2)]);
var state_99216__$1 = state_99216;
var statearr_99223_99238 = state_99216__$1;
(statearr_99223_99238[(2)] = inst_99178);


cljs.core.async.impl.ioc_helpers.process_exception(state_99216__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (2))){
var inst_99214 = (state_99216[(2)]);
var state_99216__$1 = state_99216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99216__$1,inst_99214);
} else {
if((state_val_99217 === (9))){
var inst_99210 = (state_99216[(2)]);
var state_99216__$1 = state_99216;
var statearr_99224_99239 = state_99216__$1;
(statearr_99224_99239[(2)] = inst_99210);

(statearr_99224_99239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (5))){
var inst_99192 = (state_99216[(8)]);
var inst_99199 = (state_99216[(11)]);
var inst_99198 = cljs.core.seq(inst_99192);
var inst_99199__$1 = cljs.core.first(inst_99198);
var inst_99200 = cljs.core.next(inst_99198);
var inst_99201 = cljs.core.not(inst_99199__$1);
var state_99216__$1 = (function (){var statearr_99225 = state_99216;
(statearr_99225[(12)] = inst_99200);

(statearr_99225[(11)] = inst_99199__$1);

return statearr_99225;
})();
if(inst_99201){
var statearr_99226_99240 = state_99216__$1;
(statearr_99226_99240[(1)] = (7));

} else {
var statearr_99227_99241 = state_99216__$1;
(statearr_99227_99241[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (10))){
var inst_99200 = (state_99216[(12)]);
var inst_99193 = (state_99216[(7)]);
var inst_99205 = (state_99216[(2)]);
var inst_99206 = fluree.db.util.async.throw_err(inst_99205);
var inst_99207 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_99193,inst_99206);
var inst_99192 = inst_99200;
var inst_99193__$1 = inst_99207;
var state_99216__$1 = (function (){var statearr_99228 = state_99216;
(statearr_99228[(8)] = inst_99192);

(statearr_99228[(7)] = inst_99193__$1);

return statearr_99228;
})();
var statearr_99229_99242 = state_99216__$1;
(statearr_99229_99242[(2)] = null);

(statearr_99229_99242[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99217 === (8))){
var inst_99199 = (state_99216[(11)]);
var state_99216__$1 = state_99216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99216__$1,(10),inst_99199);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_99230 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99230[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__);

(statearr_99230[(1)] = (1));

return statearr_99230;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____1 = (function (state_99216){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_99216);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e99231){if((e99231 instanceof Object)){
var ex__99040__auto__ = e99231;
var statearr_99232_99243 = state_99216;
(statearr_99232_99243[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99216);

return cljs.core.cst$kw$recur;
} else {
throw e99231;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__99244 = state_99216;
state_99216 = G__99244;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__ = function(state_99216){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____1.call(this,state_99216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_99233 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_99233[(6)] = c__99059__auto__);

return statearr_99233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_99266){
var state_val_99267 = (state_99266[(1)]);
if((state_val_99267 === (7))){
var inst_99253 = (state_99266[(7)]);
var inst_99252 = (state_99266[(2)]);
var inst_99253__$1 = fluree.db.util.async.throw_err(inst_99252);
var inst_99254 = (inst_99253__$1 == null);
var state_99266__$1 = (function (){var statearr_99268 = state_99266;
(statearr_99268[(7)] = inst_99253__$1);

return statearr_99268;
})();
if(cljs.core.truth_(inst_99254)){
var statearr_99269_99284 = state_99266__$1;
(statearr_99269_99284[(1)] = (8));

} else {
var statearr_99270_99285 = state_99266__$1;
(statearr_99270_99285[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (1))){
var state_99266__$1 = state_99266;
var statearr_99271_99286 = state_99266__$1;
(statearr_99271_99286[(2)] = null);

(statearr_99271_99286[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_99266,(3),java.lang.Exception,null,(2));
var inst_99249 = coll;
var state_99266__$1 = (function (){var statearr_99272 = state_99266;
(statearr_99272[(8)] = inst_99249);

return statearr_99272;
})();
var statearr_99273_99287 = state_99266__$1;
(statearr_99273_99287[(2)] = null);

(statearr_99273_99287[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (6))){
var inst_99262 = (state_99266[(2)]);
var state_99266__$1 = state_99266;
var statearr_99274_99288 = state_99266__$1;
(statearr_99274_99288[(2)] = inst_99262);


cljs.core.async.impl.ioc_helpers.process_exception(state_99266__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (3))){
var inst_99245 = (state_99266[(2)]);
var state_99266__$1 = state_99266;
var statearr_99275_99289 = state_99266__$1;
(statearr_99275_99289[(2)] = inst_99245);


cljs.core.async.impl.ioc_helpers.process_exception(state_99266__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (2))){
var inst_99264 = (state_99266[(2)]);
var state_99266__$1 = state_99266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99266__$1,inst_99264);
} else {
if((state_val_99267 === (9))){
var inst_99253 = (state_99266[(7)]);
var inst_99249 = (state_99266[(8)]);
var inst_99257 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_99249,inst_99253);
var inst_99249__$1 = inst_99257;
var state_99266__$1 = (function (){var statearr_99276 = state_99266;
(statearr_99276[(8)] = inst_99249__$1);

return statearr_99276;
})();
var statearr_99277_99290 = state_99266__$1;
(statearr_99277_99290[(2)] = null);

(statearr_99277_99290[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (5))){
var state_99266__$1 = state_99266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99266__$1,(7),chan);
} else {
if((state_val_99267 === (10))){
var inst_99260 = (state_99266[(2)]);
var state_99266__$1 = state_99266;
var statearr_99278_99291 = state_99266__$1;
(statearr_99278_99291[(2)] = inst_99260);

(statearr_99278_99291[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99267 === (8))){
var inst_99249 = (state_99266[(8)]);
var state_99266__$1 = state_99266;
var statearr_99279_99292 = state_99266__$1;
(statearr_99279_99292[(2)] = inst_99249);

(statearr_99279_99292[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____0 = (function (){
var statearr_99280 = [null,null,null,null,null,null,null,null,null];
(statearr_99280[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__);

(statearr_99280[(1)] = (1));

return statearr_99280;
});
var fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____1 = (function (state_99266){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_99266);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e99281){if((e99281 instanceof Object)){
var ex__99040__auto__ = e99281;
var statearr_99282_99293 = state_99266;
(statearr_99282_99293[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99266);

return cljs.core.cst$kw$recur;
} else {
throw e99281;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__99294 = state_99266;
state_99266 = G__99294;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__ = function(state_99266){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____1.call(this,state_99266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__99037__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_99283 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_99283[(6)] = c__99059__auto__);

return statearr_99283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});

//# sourceMappingURL=async.js.map?rel=1593118614911
