// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__118341){
var vec__118342 = p__118341;
var i = cljs.core.nth.call(null,vec__118342,(0),null);
var v = cljs.core.nth.call(null,vec__118342,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__118345 = seg;
var gcol = cljs.core.nth.call(null,vec__118345,(0),null);
var source = cljs.core.nth.call(null,vec__118345,(1),null);
var line = cljs.core.nth.call(null,vec__118345,(2),null);
var col = cljs.core.nth.call(null,vec__118345,(3),null);
var name = cljs.core.nth.call(null,vec__118345,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__118348 = seg;
var gcol = cljs.core.nth.call(null,vec__118348,(0),null);
var source = cljs.core.nth.call(null,vec__118348,(1),null);
var line = cljs.core.nth.call(null,vec__118348,(2),null);
var col = cljs.core.nth.call(null,vec__118348,(3),null);
var name = cljs.core.nth.call(null,vec__118348,(4),null);
var vec__118351 = relseg;
var rgcol = cljs.core.nth.call(null,vec__118351,(0),null);
var rsource = cljs.core.nth.call(null,vec__118351,(1),null);
var rline = cljs.core.nth.call(null,vec__118351,(2),null);
var rcol = cljs.core.nth.call(null,vec__118351,(3),null);
var rname = cljs.core.nth.call(null,vec__118351,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__118354 = segmap;
var map__118354__$1 = (((((!((map__118354 == null))))?(((((map__118354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118354.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__118354):map__118354);
var gcol = cljs.core.get.call(null,map__118354__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__118354__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__118354__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__118354__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__118354__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__118357 = arguments.length;
switch (G__118357) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__118361 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__118365 = cljs.core.next.call(null,segs__$1);
var G__118366 = nrelseg;
var G__118367 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__118365;
relseg__$1 = G__118366;
result__$1 = G__118367;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__118361,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__118361,(1),null);
var G__118368 = (gline + (1));
var G__118369 = cljs.core.next.call(null,lines__$1);
var G__118370 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__118371 = result__$1;
gline = G__118368;
lines__$1 = G__118369;
relseg = G__118370;
result = G__118371;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__118373 = segmap;
var map__118373__$1 = (((((!((map__118373 == null))))?(((((map__118373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__118373):map__118373);
var gcol = cljs.core.get.call(null,map__118373__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__118373__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__118373__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__118373__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__118373__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__118372_SHARP_){
return cljs.core.conj.call(null,p1__118372_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__118376 = arguments.length;
switch (G__118376) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__118380 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__118384 = cljs.core.next.call(null,segs__$1);
var G__118385 = nrelseg;
var G__118386 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__118384;
relseg__$1 = G__118385;
result__$1 = G__118386;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__118380,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__118380,(1),null);
var G__118387 = (gline + (1));
var G__118388 = cljs.core.next.call(null,lines__$1);
var G__118389 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__118390 = result__$1;
gline = G__118387;
lines__$1 = G__118388;
relseg = G__118389;
result = G__118390;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__118391){
var vec__118392 = p__118391;
var _ = cljs.core.nth.call(null,vec__118392,(0),null);
var source = cljs.core.nth.call(null,vec__118392,(1),null);
var line = cljs.core.nth.call(null,vec__118392,(2),null);
var col = cljs.core.nth.call(null,vec__118392,(3),null);
var name = cljs.core.nth.call(null,vec__118392,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__118395){
var vec__118396 = p__118395;
var gcol = cljs.core.nth.call(null,vec__118396,(0),null);
var sidx = cljs.core.nth.call(null,vec__118396,(1),null);
var line = cljs.core.nth.call(null,vec__118396,(2),null);
var col = cljs.core.nth.call(null,vec__118396,(3),null);
var name = cljs.core.nth.call(null,vec__118396,(4),null);
var seg = vec__118396;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__118399){
var vec__118400 = p__118399;
var _ = cljs.core.nth.call(null,vec__118400,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__118400,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__118400,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__118400,(3),null);
var lname = cljs.core.nth.call(null,vec__118400,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__118406 = cljs.core.seq.call(null,infos);
var chunk__118407 = null;
var count__118408 = (0);
var i__118409 = (0);
while(true){
if((i__118409 < count__118408)){
var info = cljs.core._nth.call(null,chunk__118407,i__118409);
var segv_118760 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_118761 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_118762 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_118761 > (lc_118762 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__118406,chunk__118407,count__118408,i__118409,segv_118760,gline_118761,lc_118762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_118761 - (lc_118762 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_118760], null));
});})(seq__118406,chunk__118407,count__118408,i__118409,segv_118760,gline_118761,lc_118762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__118406,chunk__118407,count__118408,i__118409,segv_118760,gline_118761,lc_118762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_118761], null),cljs.core.conj,segv_118760);
});})(seq__118406,chunk__118407,count__118408,i__118409,segv_118760,gline_118761,lc_118762,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__118763 = seq__118406;
var G__118764 = chunk__118407;
var G__118765 = count__118408;
var G__118766 = (i__118409 + (1));
seq__118406 = G__118763;
chunk__118407 = G__118764;
count__118408 = G__118765;
i__118409 = G__118766;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__118406);
if(temp__5735__auto__){
var seq__118406__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118406__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__118406__$1);
var G__118767 = cljs.core.chunk_rest.call(null,seq__118406__$1);
var G__118768 = c__4556__auto__;
var G__118769 = cljs.core.count.call(null,c__4556__auto__);
var G__118770 = (0);
seq__118406 = G__118767;
chunk__118407 = G__118768;
count__118408 = G__118769;
i__118409 = G__118770;
continue;
} else {
var info = cljs.core.first.call(null,seq__118406__$1);
var segv_118771 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_118772 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_118773 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_118772 > (lc_118773 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__118406,chunk__118407,count__118408,i__118409,segv_118771,gline_118772,lc_118773,info,seq__118406__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_118772 - (lc_118773 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_118771], null));
});})(seq__118406,chunk__118407,count__118408,i__118409,segv_118771,gline_118772,lc_118773,info,seq__118406__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__118406,chunk__118407,count__118408,i__118409,segv_118771,gline_118772,lc_118773,info,seq__118406__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_118772], null),cljs.core.conj,segv_118771);
});})(seq__118406,chunk__118407,count__118408,i__118409,segv_118771,gline_118772,lc_118773,info,seq__118406__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__118774 = cljs.core.next.call(null,seq__118406__$1);
var G__118775 = null;
var G__118776 = (0);
var G__118777 = (0);
seq__118406 = G__118774;
chunk__118407 = G__118775;
count__118408 = G__118776;
i__118409 = G__118777;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__118410_118778 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__118411_118779 = null;
var count__118412_118780 = (0);
var i__118413_118781 = (0);
while(true){
if((i__118413_118781 < count__118412_118780)){
var vec__118586_118782 = cljs.core._nth.call(null,chunk__118411_118779,i__118413_118781);
var source_idx_118783 = cljs.core.nth.call(null,vec__118586_118782,(0),null);
var vec__118589_118784 = cljs.core.nth.call(null,vec__118586_118782,(1),null);
var __118785 = cljs.core.nth.call(null,vec__118589_118784,(0),null);
var lines_118786__$1 = cljs.core.nth.call(null,vec__118589_118784,(1),null);
var seq__118592_118787 = cljs.core.seq.call(null,lines_118786__$1);
var chunk__118593_118788 = null;
var count__118594_118789 = (0);
var i__118595_118790 = (0);
while(true){
if((i__118595_118790 < count__118594_118789)){
var vec__118634_118791 = cljs.core._nth.call(null,chunk__118593_118788,i__118595_118790);
var line_118792 = cljs.core.nth.call(null,vec__118634_118791,(0),null);
var cols_118793 = cljs.core.nth.call(null,vec__118634_118791,(1),null);
var seq__118637_118794 = cljs.core.seq.call(null,cols_118793);
var chunk__118638_118795 = null;
var count__118639_118796 = (0);
var i__118640_118797 = (0);
while(true){
if((i__118640_118797 < count__118639_118796)){
var vec__118647_118798 = cljs.core._nth.call(null,chunk__118638_118795,i__118640_118797);
var col_118799 = cljs.core.nth.call(null,vec__118647_118798,(0),null);
var infos_118800 = cljs.core.nth.call(null,vec__118647_118798,(1),null);
encode_cols.call(null,infos_118800,source_idx_118783,line_118792,col_118799);


var G__118801 = seq__118637_118794;
var G__118802 = chunk__118638_118795;
var G__118803 = count__118639_118796;
var G__118804 = (i__118640_118797 + (1));
seq__118637_118794 = G__118801;
chunk__118638_118795 = G__118802;
count__118639_118796 = G__118803;
i__118640_118797 = G__118804;
continue;
} else {
var temp__5735__auto___118805 = cljs.core.seq.call(null,seq__118637_118794);
if(temp__5735__auto___118805){
var seq__118637_118806__$1 = temp__5735__auto___118805;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118637_118806__$1)){
var c__4556__auto___118807 = cljs.core.chunk_first.call(null,seq__118637_118806__$1);
var G__118808 = cljs.core.chunk_rest.call(null,seq__118637_118806__$1);
var G__118809 = c__4556__auto___118807;
var G__118810 = cljs.core.count.call(null,c__4556__auto___118807);
var G__118811 = (0);
seq__118637_118794 = G__118808;
chunk__118638_118795 = G__118809;
count__118639_118796 = G__118810;
i__118640_118797 = G__118811;
continue;
} else {
var vec__118650_118812 = cljs.core.first.call(null,seq__118637_118806__$1);
var col_118813 = cljs.core.nth.call(null,vec__118650_118812,(0),null);
var infos_118814 = cljs.core.nth.call(null,vec__118650_118812,(1),null);
encode_cols.call(null,infos_118814,source_idx_118783,line_118792,col_118813);


var G__118815 = cljs.core.next.call(null,seq__118637_118806__$1);
var G__118816 = null;
var G__118817 = (0);
var G__118818 = (0);
seq__118637_118794 = G__118815;
chunk__118638_118795 = G__118816;
count__118639_118796 = G__118817;
i__118640_118797 = G__118818;
continue;
}
} else {
}
}
break;
}


var G__118819 = seq__118592_118787;
var G__118820 = chunk__118593_118788;
var G__118821 = count__118594_118789;
var G__118822 = (i__118595_118790 + (1));
seq__118592_118787 = G__118819;
chunk__118593_118788 = G__118820;
count__118594_118789 = G__118821;
i__118595_118790 = G__118822;
continue;
} else {
var temp__5735__auto___118823 = cljs.core.seq.call(null,seq__118592_118787);
if(temp__5735__auto___118823){
var seq__118592_118824__$1 = temp__5735__auto___118823;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118592_118824__$1)){
var c__4556__auto___118825 = cljs.core.chunk_first.call(null,seq__118592_118824__$1);
var G__118826 = cljs.core.chunk_rest.call(null,seq__118592_118824__$1);
var G__118827 = c__4556__auto___118825;
var G__118828 = cljs.core.count.call(null,c__4556__auto___118825);
var G__118829 = (0);
seq__118592_118787 = G__118826;
chunk__118593_118788 = G__118827;
count__118594_118789 = G__118828;
i__118595_118790 = G__118829;
continue;
} else {
var vec__118653_118830 = cljs.core.first.call(null,seq__118592_118824__$1);
var line_118831 = cljs.core.nth.call(null,vec__118653_118830,(0),null);
var cols_118832 = cljs.core.nth.call(null,vec__118653_118830,(1),null);
var seq__118656_118833 = cljs.core.seq.call(null,cols_118832);
var chunk__118657_118834 = null;
var count__118658_118835 = (0);
var i__118659_118836 = (0);
while(true){
if((i__118659_118836 < count__118658_118835)){
var vec__118666_118837 = cljs.core._nth.call(null,chunk__118657_118834,i__118659_118836);
var col_118838 = cljs.core.nth.call(null,vec__118666_118837,(0),null);
var infos_118839 = cljs.core.nth.call(null,vec__118666_118837,(1),null);
encode_cols.call(null,infos_118839,source_idx_118783,line_118831,col_118838);


var G__118840 = seq__118656_118833;
var G__118841 = chunk__118657_118834;
var G__118842 = count__118658_118835;
var G__118843 = (i__118659_118836 + (1));
seq__118656_118833 = G__118840;
chunk__118657_118834 = G__118841;
count__118658_118835 = G__118842;
i__118659_118836 = G__118843;
continue;
} else {
var temp__5735__auto___118844__$1 = cljs.core.seq.call(null,seq__118656_118833);
if(temp__5735__auto___118844__$1){
var seq__118656_118845__$1 = temp__5735__auto___118844__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118656_118845__$1)){
var c__4556__auto___118846 = cljs.core.chunk_first.call(null,seq__118656_118845__$1);
var G__118847 = cljs.core.chunk_rest.call(null,seq__118656_118845__$1);
var G__118848 = c__4556__auto___118846;
var G__118849 = cljs.core.count.call(null,c__4556__auto___118846);
var G__118850 = (0);
seq__118656_118833 = G__118847;
chunk__118657_118834 = G__118848;
count__118658_118835 = G__118849;
i__118659_118836 = G__118850;
continue;
} else {
var vec__118669_118851 = cljs.core.first.call(null,seq__118656_118845__$1);
var col_118852 = cljs.core.nth.call(null,vec__118669_118851,(0),null);
var infos_118853 = cljs.core.nth.call(null,vec__118669_118851,(1),null);
encode_cols.call(null,infos_118853,source_idx_118783,line_118831,col_118852);


var G__118854 = cljs.core.next.call(null,seq__118656_118845__$1);
var G__118855 = null;
var G__118856 = (0);
var G__118857 = (0);
seq__118656_118833 = G__118854;
chunk__118657_118834 = G__118855;
count__118658_118835 = G__118856;
i__118659_118836 = G__118857;
continue;
}
} else {
}
}
break;
}


var G__118858 = cljs.core.next.call(null,seq__118592_118824__$1);
var G__118859 = null;
var G__118860 = (0);
var G__118861 = (0);
seq__118592_118787 = G__118858;
chunk__118593_118788 = G__118859;
count__118594_118789 = G__118860;
i__118595_118790 = G__118861;
continue;
}
} else {
}
}
break;
}


var G__118862 = seq__118410_118778;
var G__118863 = chunk__118411_118779;
var G__118864 = count__118412_118780;
var G__118865 = (i__118413_118781 + (1));
seq__118410_118778 = G__118862;
chunk__118411_118779 = G__118863;
count__118412_118780 = G__118864;
i__118413_118781 = G__118865;
continue;
} else {
var temp__5735__auto___118866 = cljs.core.seq.call(null,seq__118410_118778);
if(temp__5735__auto___118866){
var seq__118410_118867__$1 = temp__5735__auto___118866;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118410_118867__$1)){
var c__4556__auto___118868 = cljs.core.chunk_first.call(null,seq__118410_118867__$1);
var G__118869 = cljs.core.chunk_rest.call(null,seq__118410_118867__$1);
var G__118870 = c__4556__auto___118868;
var G__118871 = cljs.core.count.call(null,c__4556__auto___118868);
var G__118872 = (0);
seq__118410_118778 = G__118869;
chunk__118411_118779 = G__118870;
count__118412_118780 = G__118871;
i__118413_118781 = G__118872;
continue;
} else {
var vec__118672_118873 = cljs.core.first.call(null,seq__118410_118867__$1);
var source_idx_118874 = cljs.core.nth.call(null,vec__118672_118873,(0),null);
var vec__118675_118875 = cljs.core.nth.call(null,vec__118672_118873,(1),null);
var __118876 = cljs.core.nth.call(null,vec__118675_118875,(0),null);
var lines_118877__$1 = cljs.core.nth.call(null,vec__118675_118875,(1),null);
var seq__118678_118878 = cljs.core.seq.call(null,lines_118877__$1);
var chunk__118679_118879 = null;
var count__118680_118880 = (0);
var i__118681_118881 = (0);
while(true){
if((i__118681_118881 < count__118680_118880)){
var vec__118720_118882 = cljs.core._nth.call(null,chunk__118679_118879,i__118681_118881);
var line_118883 = cljs.core.nth.call(null,vec__118720_118882,(0),null);
var cols_118884 = cljs.core.nth.call(null,vec__118720_118882,(1),null);
var seq__118723_118885 = cljs.core.seq.call(null,cols_118884);
var chunk__118724_118886 = null;
var count__118725_118887 = (0);
var i__118726_118888 = (0);
while(true){
if((i__118726_118888 < count__118725_118887)){
var vec__118733_118889 = cljs.core._nth.call(null,chunk__118724_118886,i__118726_118888);
var col_118890 = cljs.core.nth.call(null,vec__118733_118889,(0),null);
var infos_118891 = cljs.core.nth.call(null,vec__118733_118889,(1),null);
encode_cols.call(null,infos_118891,source_idx_118874,line_118883,col_118890);


var G__118892 = seq__118723_118885;
var G__118893 = chunk__118724_118886;
var G__118894 = count__118725_118887;
var G__118895 = (i__118726_118888 + (1));
seq__118723_118885 = G__118892;
chunk__118724_118886 = G__118893;
count__118725_118887 = G__118894;
i__118726_118888 = G__118895;
continue;
} else {
var temp__5735__auto___118896__$1 = cljs.core.seq.call(null,seq__118723_118885);
if(temp__5735__auto___118896__$1){
var seq__118723_118897__$1 = temp__5735__auto___118896__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118723_118897__$1)){
var c__4556__auto___118898 = cljs.core.chunk_first.call(null,seq__118723_118897__$1);
var G__118899 = cljs.core.chunk_rest.call(null,seq__118723_118897__$1);
var G__118900 = c__4556__auto___118898;
var G__118901 = cljs.core.count.call(null,c__4556__auto___118898);
var G__118902 = (0);
seq__118723_118885 = G__118899;
chunk__118724_118886 = G__118900;
count__118725_118887 = G__118901;
i__118726_118888 = G__118902;
continue;
} else {
var vec__118736_118903 = cljs.core.first.call(null,seq__118723_118897__$1);
var col_118904 = cljs.core.nth.call(null,vec__118736_118903,(0),null);
var infos_118905 = cljs.core.nth.call(null,vec__118736_118903,(1),null);
encode_cols.call(null,infos_118905,source_idx_118874,line_118883,col_118904);


var G__118906 = cljs.core.next.call(null,seq__118723_118897__$1);
var G__118907 = null;
var G__118908 = (0);
var G__118909 = (0);
seq__118723_118885 = G__118906;
chunk__118724_118886 = G__118907;
count__118725_118887 = G__118908;
i__118726_118888 = G__118909;
continue;
}
} else {
}
}
break;
}


var G__118910 = seq__118678_118878;
var G__118911 = chunk__118679_118879;
var G__118912 = count__118680_118880;
var G__118913 = (i__118681_118881 + (1));
seq__118678_118878 = G__118910;
chunk__118679_118879 = G__118911;
count__118680_118880 = G__118912;
i__118681_118881 = G__118913;
continue;
} else {
var temp__5735__auto___118914__$1 = cljs.core.seq.call(null,seq__118678_118878);
if(temp__5735__auto___118914__$1){
var seq__118678_118915__$1 = temp__5735__auto___118914__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118678_118915__$1)){
var c__4556__auto___118916 = cljs.core.chunk_first.call(null,seq__118678_118915__$1);
var G__118917 = cljs.core.chunk_rest.call(null,seq__118678_118915__$1);
var G__118918 = c__4556__auto___118916;
var G__118919 = cljs.core.count.call(null,c__4556__auto___118916);
var G__118920 = (0);
seq__118678_118878 = G__118917;
chunk__118679_118879 = G__118918;
count__118680_118880 = G__118919;
i__118681_118881 = G__118920;
continue;
} else {
var vec__118739_118921 = cljs.core.first.call(null,seq__118678_118915__$1);
var line_118922 = cljs.core.nth.call(null,vec__118739_118921,(0),null);
var cols_118923 = cljs.core.nth.call(null,vec__118739_118921,(1),null);
var seq__118742_118924 = cljs.core.seq.call(null,cols_118923);
var chunk__118743_118925 = null;
var count__118744_118926 = (0);
var i__118745_118927 = (0);
while(true){
if((i__118745_118927 < count__118744_118926)){
var vec__118752_118928 = cljs.core._nth.call(null,chunk__118743_118925,i__118745_118927);
var col_118929 = cljs.core.nth.call(null,vec__118752_118928,(0),null);
var infos_118930 = cljs.core.nth.call(null,vec__118752_118928,(1),null);
encode_cols.call(null,infos_118930,source_idx_118874,line_118922,col_118929);


var G__118931 = seq__118742_118924;
var G__118932 = chunk__118743_118925;
var G__118933 = count__118744_118926;
var G__118934 = (i__118745_118927 + (1));
seq__118742_118924 = G__118931;
chunk__118743_118925 = G__118932;
count__118744_118926 = G__118933;
i__118745_118927 = G__118934;
continue;
} else {
var temp__5735__auto___118935__$2 = cljs.core.seq.call(null,seq__118742_118924);
if(temp__5735__auto___118935__$2){
var seq__118742_118936__$1 = temp__5735__auto___118935__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118742_118936__$1)){
var c__4556__auto___118937 = cljs.core.chunk_first.call(null,seq__118742_118936__$1);
var G__118938 = cljs.core.chunk_rest.call(null,seq__118742_118936__$1);
var G__118939 = c__4556__auto___118937;
var G__118940 = cljs.core.count.call(null,c__4556__auto___118937);
var G__118941 = (0);
seq__118742_118924 = G__118938;
chunk__118743_118925 = G__118939;
count__118744_118926 = G__118940;
i__118745_118927 = G__118941;
continue;
} else {
var vec__118755_118942 = cljs.core.first.call(null,seq__118742_118936__$1);
var col_118943 = cljs.core.nth.call(null,vec__118755_118942,(0),null);
var infos_118944 = cljs.core.nth.call(null,vec__118755_118942,(1),null);
encode_cols.call(null,infos_118944,source_idx_118874,line_118922,col_118943);


var G__118945 = cljs.core.next.call(null,seq__118742_118936__$1);
var G__118946 = null;
var G__118947 = (0);
var G__118948 = (0);
seq__118742_118924 = G__118945;
chunk__118743_118925 = G__118946;
count__118744_118926 = G__118947;
i__118745_118927 = G__118948;
continue;
}
} else {
}
}
break;
}


var G__118949 = cljs.core.next.call(null,seq__118678_118915__$1);
var G__118950 = null;
var G__118951 = (0);
var G__118952 = (0);
seq__118678_118878 = G__118949;
chunk__118679_118879 = G__118950;
count__118680_118880 = G__118951;
i__118681_118881 = G__118952;
continue;
}
} else {
}
}
break;
}


var G__118953 = cljs.core.next.call(null,seq__118410_118867__$1);
var G__118954 = null;
var G__118955 = (0);
var G__118956 = (0);
seq__118410_118778 = G__118953;
chunk__118411_118779 = G__118954;
count__118412_118780 = G__118955;
i__118413_118781 = G__118956;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__118758 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__118403_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__118403_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__118404_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__118404_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__118405_SHARP_){
return clojure.string.join.call(null,",",p1__118405_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__118759 = G__118758;
goog.object.set(G__118759,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__118759;
} else {
return G__118758;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__118957 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__118957,(0),null);
var col_map = cljs.core.nth.call(null,vec__118957,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__118960 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__118960,(0),null);
var infos = cljs.core.nth.call(null,vec__118960,(1),null);
var G__118966 = cljs.core.next.call(null,col_map_seq);
var G__118967 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__118960,col,infos,vec__118957,line,col_map){
return (function (v,p__118963){
var map__118964 = p__118963;
var map__118964__$1 = (((((!((map__118964 == null))))?(((((map__118964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__118964):map__118964);
var gline = cljs.core.get.call(null,map__118964__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__118964__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__118960,col,infos,vec__118957,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__118966;
new_cols = G__118967;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__118968 = cljs.core.next.call(null,line_map_seq);
var G__118969 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__118968;
new_lines = G__118969;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__118970_119242 = cljs.core.seq.call(null,reverse_map);
var chunk__118971_119243 = null;
var count__118972_119244 = (0);
var i__118973_119245 = (0);
while(true){
if((i__118973_119245 < count__118972_119244)){
var vec__119108_119246 = cljs.core._nth.call(null,chunk__118971_119243,i__118973_119245);
var line_119247 = cljs.core.nth.call(null,vec__119108_119246,(0),null);
var columns_119248 = cljs.core.nth.call(null,vec__119108_119246,(1),null);
var seq__119111_119249 = cljs.core.seq.call(null,columns_119248);
var chunk__119112_119250 = null;
var count__119113_119251 = (0);
var i__119114_119252 = (0);
while(true){
if((i__119114_119252 < count__119113_119251)){
var vec__119145_119253 = cljs.core._nth.call(null,chunk__119112_119250,i__119114_119252);
var column_119254 = cljs.core.nth.call(null,vec__119145_119253,(0),null);
var column_info_119255 = cljs.core.nth.call(null,vec__119145_119253,(1),null);
var seq__119148_119256 = cljs.core.seq.call(null,column_info_119255);
var chunk__119149_119257 = null;
var count__119150_119258 = (0);
var i__119151_119259 = (0);
while(true){
if((i__119151_119259 < count__119150_119258)){
var map__119156_119260 = cljs.core._nth.call(null,chunk__119149_119257,i__119151_119259);
var map__119156_119261__$1 = (((((!((map__119156_119260 == null))))?(((((map__119156_119260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119156_119260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119156_119260):map__119156_119260);
var gline_119262 = cljs.core.get.call(null,map__119156_119261__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119263 = cljs.core.get.call(null,map__119156_119261__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119264 = cljs.core.get.call(null,map__119156_119261__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119262], null),cljs.core.fnil.call(null,((function (seq__119148_119256,chunk__119149_119257,count__119150_119258,i__119151_119259,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119156_119260,map__119156_119261__$1,gline_119262,gcol_119263,name_119264,vec__119145_119253,column_119254,column_info_119255,vec__119108_119246,line_119247,columns_119248,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119263], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119247,new cljs.core.Keyword(null,"col","col",-1959363084),column_119254,new cljs.core.Keyword(null,"name","name",1843675177),name_119264], null));
});})(seq__119148_119256,chunk__119149_119257,count__119150_119258,i__119151_119259,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119156_119260,map__119156_119261__$1,gline_119262,gcol_119263,name_119264,vec__119145_119253,column_119254,column_info_119255,vec__119108_119246,line_119247,columns_119248,inverted))
,cljs.core.sorted_map.call(null)));


var G__119265 = seq__119148_119256;
var G__119266 = chunk__119149_119257;
var G__119267 = count__119150_119258;
var G__119268 = (i__119151_119259 + (1));
seq__119148_119256 = G__119265;
chunk__119149_119257 = G__119266;
count__119150_119258 = G__119267;
i__119151_119259 = G__119268;
continue;
} else {
var temp__5735__auto___119269 = cljs.core.seq.call(null,seq__119148_119256);
if(temp__5735__auto___119269){
var seq__119148_119270__$1 = temp__5735__auto___119269;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119148_119270__$1)){
var c__4556__auto___119271 = cljs.core.chunk_first.call(null,seq__119148_119270__$1);
var G__119272 = cljs.core.chunk_rest.call(null,seq__119148_119270__$1);
var G__119273 = c__4556__auto___119271;
var G__119274 = cljs.core.count.call(null,c__4556__auto___119271);
var G__119275 = (0);
seq__119148_119256 = G__119272;
chunk__119149_119257 = G__119273;
count__119150_119258 = G__119274;
i__119151_119259 = G__119275;
continue;
} else {
var map__119158_119276 = cljs.core.first.call(null,seq__119148_119270__$1);
var map__119158_119277__$1 = (((((!((map__119158_119276 == null))))?(((((map__119158_119276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119158_119276.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119158_119276):map__119158_119276);
var gline_119278 = cljs.core.get.call(null,map__119158_119277__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119279 = cljs.core.get.call(null,map__119158_119277__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119280 = cljs.core.get.call(null,map__119158_119277__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119278], null),cljs.core.fnil.call(null,((function (seq__119148_119256,chunk__119149_119257,count__119150_119258,i__119151_119259,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119158_119276,map__119158_119277__$1,gline_119278,gcol_119279,name_119280,seq__119148_119270__$1,temp__5735__auto___119269,vec__119145_119253,column_119254,column_info_119255,vec__119108_119246,line_119247,columns_119248,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119279], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119247,new cljs.core.Keyword(null,"col","col",-1959363084),column_119254,new cljs.core.Keyword(null,"name","name",1843675177),name_119280], null));
});})(seq__119148_119256,chunk__119149_119257,count__119150_119258,i__119151_119259,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119158_119276,map__119158_119277__$1,gline_119278,gcol_119279,name_119280,seq__119148_119270__$1,temp__5735__auto___119269,vec__119145_119253,column_119254,column_info_119255,vec__119108_119246,line_119247,columns_119248,inverted))
,cljs.core.sorted_map.call(null)));


var G__119281 = cljs.core.next.call(null,seq__119148_119270__$1);
var G__119282 = null;
var G__119283 = (0);
var G__119284 = (0);
seq__119148_119256 = G__119281;
chunk__119149_119257 = G__119282;
count__119150_119258 = G__119283;
i__119151_119259 = G__119284;
continue;
}
} else {
}
}
break;
}


var G__119285 = seq__119111_119249;
var G__119286 = chunk__119112_119250;
var G__119287 = count__119113_119251;
var G__119288 = (i__119114_119252 + (1));
seq__119111_119249 = G__119285;
chunk__119112_119250 = G__119286;
count__119113_119251 = G__119287;
i__119114_119252 = G__119288;
continue;
} else {
var temp__5735__auto___119289 = cljs.core.seq.call(null,seq__119111_119249);
if(temp__5735__auto___119289){
var seq__119111_119290__$1 = temp__5735__auto___119289;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119111_119290__$1)){
var c__4556__auto___119291 = cljs.core.chunk_first.call(null,seq__119111_119290__$1);
var G__119292 = cljs.core.chunk_rest.call(null,seq__119111_119290__$1);
var G__119293 = c__4556__auto___119291;
var G__119294 = cljs.core.count.call(null,c__4556__auto___119291);
var G__119295 = (0);
seq__119111_119249 = G__119292;
chunk__119112_119250 = G__119293;
count__119113_119251 = G__119294;
i__119114_119252 = G__119295;
continue;
} else {
var vec__119160_119296 = cljs.core.first.call(null,seq__119111_119290__$1);
var column_119297 = cljs.core.nth.call(null,vec__119160_119296,(0),null);
var column_info_119298 = cljs.core.nth.call(null,vec__119160_119296,(1),null);
var seq__119163_119299 = cljs.core.seq.call(null,column_info_119298);
var chunk__119164_119300 = null;
var count__119165_119301 = (0);
var i__119166_119302 = (0);
while(true){
if((i__119166_119302 < count__119165_119301)){
var map__119171_119303 = cljs.core._nth.call(null,chunk__119164_119300,i__119166_119302);
var map__119171_119304__$1 = (((((!((map__119171_119303 == null))))?(((((map__119171_119303.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119171_119303.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119171_119303):map__119171_119303);
var gline_119305 = cljs.core.get.call(null,map__119171_119304__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119306 = cljs.core.get.call(null,map__119171_119304__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119307 = cljs.core.get.call(null,map__119171_119304__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119305], null),cljs.core.fnil.call(null,((function (seq__119163_119299,chunk__119164_119300,count__119165_119301,i__119166_119302,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119171_119303,map__119171_119304__$1,gline_119305,gcol_119306,name_119307,vec__119160_119296,column_119297,column_info_119298,seq__119111_119290__$1,temp__5735__auto___119289,vec__119108_119246,line_119247,columns_119248,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119306], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119247,new cljs.core.Keyword(null,"col","col",-1959363084),column_119297,new cljs.core.Keyword(null,"name","name",1843675177),name_119307], null));
});})(seq__119163_119299,chunk__119164_119300,count__119165_119301,i__119166_119302,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119171_119303,map__119171_119304__$1,gline_119305,gcol_119306,name_119307,vec__119160_119296,column_119297,column_info_119298,seq__119111_119290__$1,temp__5735__auto___119289,vec__119108_119246,line_119247,columns_119248,inverted))
,cljs.core.sorted_map.call(null)));


var G__119308 = seq__119163_119299;
var G__119309 = chunk__119164_119300;
var G__119310 = count__119165_119301;
var G__119311 = (i__119166_119302 + (1));
seq__119163_119299 = G__119308;
chunk__119164_119300 = G__119309;
count__119165_119301 = G__119310;
i__119166_119302 = G__119311;
continue;
} else {
var temp__5735__auto___119312__$1 = cljs.core.seq.call(null,seq__119163_119299);
if(temp__5735__auto___119312__$1){
var seq__119163_119313__$1 = temp__5735__auto___119312__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119163_119313__$1)){
var c__4556__auto___119314 = cljs.core.chunk_first.call(null,seq__119163_119313__$1);
var G__119315 = cljs.core.chunk_rest.call(null,seq__119163_119313__$1);
var G__119316 = c__4556__auto___119314;
var G__119317 = cljs.core.count.call(null,c__4556__auto___119314);
var G__119318 = (0);
seq__119163_119299 = G__119315;
chunk__119164_119300 = G__119316;
count__119165_119301 = G__119317;
i__119166_119302 = G__119318;
continue;
} else {
var map__119173_119319 = cljs.core.first.call(null,seq__119163_119313__$1);
var map__119173_119320__$1 = (((((!((map__119173_119319 == null))))?(((((map__119173_119319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119173_119319.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119173_119319):map__119173_119319);
var gline_119321 = cljs.core.get.call(null,map__119173_119320__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119322 = cljs.core.get.call(null,map__119173_119320__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119323 = cljs.core.get.call(null,map__119173_119320__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119321], null),cljs.core.fnil.call(null,((function (seq__119163_119299,chunk__119164_119300,count__119165_119301,i__119166_119302,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119173_119319,map__119173_119320__$1,gline_119321,gcol_119322,name_119323,seq__119163_119313__$1,temp__5735__auto___119312__$1,vec__119160_119296,column_119297,column_info_119298,seq__119111_119290__$1,temp__5735__auto___119289,vec__119108_119246,line_119247,columns_119248,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119322], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119247,new cljs.core.Keyword(null,"col","col",-1959363084),column_119297,new cljs.core.Keyword(null,"name","name",1843675177),name_119323], null));
});})(seq__119163_119299,chunk__119164_119300,count__119165_119301,i__119166_119302,seq__119111_119249,chunk__119112_119250,count__119113_119251,i__119114_119252,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119173_119319,map__119173_119320__$1,gline_119321,gcol_119322,name_119323,seq__119163_119313__$1,temp__5735__auto___119312__$1,vec__119160_119296,column_119297,column_info_119298,seq__119111_119290__$1,temp__5735__auto___119289,vec__119108_119246,line_119247,columns_119248,inverted))
,cljs.core.sorted_map.call(null)));


var G__119324 = cljs.core.next.call(null,seq__119163_119313__$1);
var G__119325 = null;
var G__119326 = (0);
var G__119327 = (0);
seq__119163_119299 = G__119324;
chunk__119164_119300 = G__119325;
count__119165_119301 = G__119326;
i__119166_119302 = G__119327;
continue;
}
} else {
}
}
break;
}


var G__119328 = cljs.core.next.call(null,seq__119111_119290__$1);
var G__119329 = null;
var G__119330 = (0);
var G__119331 = (0);
seq__119111_119249 = G__119328;
chunk__119112_119250 = G__119329;
count__119113_119251 = G__119330;
i__119114_119252 = G__119331;
continue;
}
} else {
}
}
break;
}


var G__119332 = seq__118970_119242;
var G__119333 = chunk__118971_119243;
var G__119334 = count__118972_119244;
var G__119335 = (i__118973_119245 + (1));
seq__118970_119242 = G__119332;
chunk__118971_119243 = G__119333;
count__118972_119244 = G__119334;
i__118973_119245 = G__119335;
continue;
} else {
var temp__5735__auto___119336 = cljs.core.seq.call(null,seq__118970_119242);
if(temp__5735__auto___119336){
var seq__118970_119337__$1 = temp__5735__auto___119336;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__118970_119337__$1)){
var c__4556__auto___119338 = cljs.core.chunk_first.call(null,seq__118970_119337__$1);
var G__119339 = cljs.core.chunk_rest.call(null,seq__118970_119337__$1);
var G__119340 = c__4556__auto___119338;
var G__119341 = cljs.core.count.call(null,c__4556__auto___119338);
var G__119342 = (0);
seq__118970_119242 = G__119339;
chunk__118971_119243 = G__119340;
count__118972_119244 = G__119341;
i__118973_119245 = G__119342;
continue;
} else {
var vec__119175_119343 = cljs.core.first.call(null,seq__118970_119337__$1);
var line_119344 = cljs.core.nth.call(null,vec__119175_119343,(0),null);
var columns_119345 = cljs.core.nth.call(null,vec__119175_119343,(1),null);
var seq__119178_119346 = cljs.core.seq.call(null,columns_119345);
var chunk__119179_119347 = null;
var count__119180_119348 = (0);
var i__119181_119349 = (0);
while(true){
if((i__119181_119349 < count__119180_119348)){
var vec__119212_119350 = cljs.core._nth.call(null,chunk__119179_119347,i__119181_119349);
var column_119351 = cljs.core.nth.call(null,vec__119212_119350,(0),null);
var column_info_119352 = cljs.core.nth.call(null,vec__119212_119350,(1),null);
var seq__119215_119353 = cljs.core.seq.call(null,column_info_119352);
var chunk__119216_119354 = null;
var count__119217_119355 = (0);
var i__119218_119356 = (0);
while(true){
if((i__119218_119356 < count__119217_119355)){
var map__119223_119357 = cljs.core._nth.call(null,chunk__119216_119354,i__119218_119356);
var map__119223_119358__$1 = (((((!((map__119223_119357 == null))))?(((((map__119223_119357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119223_119357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119223_119357):map__119223_119357);
var gline_119359 = cljs.core.get.call(null,map__119223_119358__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119360 = cljs.core.get.call(null,map__119223_119358__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119361 = cljs.core.get.call(null,map__119223_119358__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119359], null),cljs.core.fnil.call(null,((function (seq__119215_119353,chunk__119216_119354,count__119217_119355,i__119218_119356,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119223_119357,map__119223_119358__$1,gline_119359,gcol_119360,name_119361,vec__119212_119350,column_119351,column_info_119352,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119360], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119344,new cljs.core.Keyword(null,"col","col",-1959363084),column_119351,new cljs.core.Keyword(null,"name","name",1843675177),name_119361], null));
});})(seq__119215_119353,chunk__119216_119354,count__119217_119355,i__119218_119356,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119223_119357,map__119223_119358__$1,gline_119359,gcol_119360,name_119361,vec__119212_119350,column_119351,column_info_119352,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted))
,cljs.core.sorted_map.call(null)));


var G__119362 = seq__119215_119353;
var G__119363 = chunk__119216_119354;
var G__119364 = count__119217_119355;
var G__119365 = (i__119218_119356 + (1));
seq__119215_119353 = G__119362;
chunk__119216_119354 = G__119363;
count__119217_119355 = G__119364;
i__119218_119356 = G__119365;
continue;
} else {
var temp__5735__auto___119366__$1 = cljs.core.seq.call(null,seq__119215_119353);
if(temp__5735__auto___119366__$1){
var seq__119215_119367__$1 = temp__5735__auto___119366__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119215_119367__$1)){
var c__4556__auto___119368 = cljs.core.chunk_first.call(null,seq__119215_119367__$1);
var G__119369 = cljs.core.chunk_rest.call(null,seq__119215_119367__$1);
var G__119370 = c__4556__auto___119368;
var G__119371 = cljs.core.count.call(null,c__4556__auto___119368);
var G__119372 = (0);
seq__119215_119353 = G__119369;
chunk__119216_119354 = G__119370;
count__119217_119355 = G__119371;
i__119218_119356 = G__119372;
continue;
} else {
var map__119225_119373 = cljs.core.first.call(null,seq__119215_119367__$1);
var map__119225_119374__$1 = (((((!((map__119225_119373 == null))))?(((((map__119225_119373.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119225_119373.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119225_119373):map__119225_119373);
var gline_119375 = cljs.core.get.call(null,map__119225_119374__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119376 = cljs.core.get.call(null,map__119225_119374__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119377 = cljs.core.get.call(null,map__119225_119374__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119375], null),cljs.core.fnil.call(null,((function (seq__119215_119353,chunk__119216_119354,count__119217_119355,i__119218_119356,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119225_119373,map__119225_119374__$1,gline_119375,gcol_119376,name_119377,seq__119215_119367__$1,temp__5735__auto___119366__$1,vec__119212_119350,column_119351,column_info_119352,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119376], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119344,new cljs.core.Keyword(null,"col","col",-1959363084),column_119351,new cljs.core.Keyword(null,"name","name",1843675177),name_119377], null));
});})(seq__119215_119353,chunk__119216_119354,count__119217_119355,i__119218_119356,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119225_119373,map__119225_119374__$1,gline_119375,gcol_119376,name_119377,seq__119215_119367__$1,temp__5735__auto___119366__$1,vec__119212_119350,column_119351,column_info_119352,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted))
,cljs.core.sorted_map.call(null)));


var G__119378 = cljs.core.next.call(null,seq__119215_119367__$1);
var G__119379 = null;
var G__119380 = (0);
var G__119381 = (0);
seq__119215_119353 = G__119378;
chunk__119216_119354 = G__119379;
count__119217_119355 = G__119380;
i__119218_119356 = G__119381;
continue;
}
} else {
}
}
break;
}


var G__119382 = seq__119178_119346;
var G__119383 = chunk__119179_119347;
var G__119384 = count__119180_119348;
var G__119385 = (i__119181_119349 + (1));
seq__119178_119346 = G__119382;
chunk__119179_119347 = G__119383;
count__119180_119348 = G__119384;
i__119181_119349 = G__119385;
continue;
} else {
var temp__5735__auto___119386__$1 = cljs.core.seq.call(null,seq__119178_119346);
if(temp__5735__auto___119386__$1){
var seq__119178_119387__$1 = temp__5735__auto___119386__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119178_119387__$1)){
var c__4556__auto___119388 = cljs.core.chunk_first.call(null,seq__119178_119387__$1);
var G__119389 = cljs.core.chunk_rest.call(null,seq__119178_119387__$1);
var G__119390 = c__4556__auto___119388;
var G__119391 = cljs.core.count.call(null,c__4556__auto___119388);
var G__119392 = (0);
seq__119178_119346 = G__119389;
chunk__119179_119347 = G__119390;
count__119180_119348 = G__119391;
i__119181_119349 = G__119392;
continue;
} else {
var vec__119227_119393 = cljs.core.first.call(null,seq__119178_119387__$1);
var column_119394 = cljs.core.nth.call(null,vec__119227_119393,(0),null);
var column_info_119395 = cljs.core.nth.call(null,vec__119227_119393,(1),null);
var seq__119230_119396 = cljs.core.seq.call(null,column_info_119395);
var chunk__119231_119397 = null;
var count__119232_119398 = (0);
var i__119233_119399 = (0);
while(true){
if((i__119233_119399 < count__119232_119398)){
var map__119238_119400 = cljs.core._nth.call(null,chunk__119231_119397,i__119233_119399);
var map__119238_119401__$1 = (((((!((map__119238_119400 == null))))?(((((map__119238_119400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119238_119400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119238_119400):map__119238_119400);
var gline_119402 = cljs.core.get.call(null,map__119238_119401__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119403 = cljs.core.get.call(null,map__119238_119401__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119404 = cljs.core.get.call(null,map__119238_119401__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119402], null),cljs.core.fnil.call(null,((function (seq__119230_119396,chunk__119231_119397,count__119232_119398,i__119233_119399,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119238_119400,map__119238_119401__$1,gline_119402,gcol_119403,name_119404,vec__119227_119393,column_119394,column_info_119395,seq__119178_119387__$1,temp__5735__auto___119386__$1,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119403], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119344,new cljs.core.Keyword(null,"col","col",-1959363084),column_119394,new cljs.core.Keyword(null,"name","name",1843675177),name_119404], null));
});})(seq__119230_119396,chunk__119231_119397,count__119232_119398,i__119233_119399,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119238_119400,map__119238_119401__$1,gline_119402,gcol_119403,name_119404,vec__119227_119393,column_119394,column_info_119395,seq__119178_119387__$1,temp__5735__auto___119386__$1,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted))
,cljs.core.sorted_map.call(null)));


var G__119405 = seq__119230_119396;
var G__119406 = chunk__119231_119397;
var G__119407 = count__119232_119398;
var G__119408 = (i__119233_119399 + (1));
seq__119230_119396 = G__119405;
chunk__119231_119397 = G__119406;
count__119232_119398 = G__119407;
i__119233_119399 = G__119408;
continue;
} else {
var temp__5735__auto___119409__$2 = cljs.core.seq.call(null,seq__119230_119396);
if(temp__5735__auto___119409__$2){
var seq__119230_119410__$1 = temp__5735__auto___119409__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__119230_119410__$1)){
var c__4556__auto___119411 = cljs.core.chunk_first.call(null,seq__119230_119410__$1);
var G__119412 = cljs.core.chunk_rest.call(null,seq__119230_119410__$1);
var G__119413 = c__4556__auto___119411;
var G__119414 = cljs.core.count.call(null,c__4556__auto___119411);
var G__119415 = (0);
seq__119230_119396 = G__119412;
chunk__119231_119397 = G__119413;
count__119232_119398 = G__119414;
i__119233_119399 = G__119415;
continue;
} else {
var map__119240_119416 = cljs.core.first.call(null,seq__119230_119410__$1);
var map__119240_119417__$1 = (((((!((map__119240_119416 == null))))?(((((map__119240_119416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119240_119416.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__119240_119416):map__119240_119416);
var gline_119418 = cljs.core.get.call(null,map__119240_119417__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_119419 = cljs.core.get.call(null,map__119240_119417__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_119420 = cljs.core.get.call(null,map__119240_119417__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_119418], null),cljs.core.fnil.call(null,((function (seq__119230_119396,chunk__119231_119397,count__119232_119398,i__119233_119399,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119240_119416,map__119240_119417__$1,gline_119418,gcol_119419,name_119420,seq__119230_119410__$1,temp__5735__auto___119409__$2,vec__119227_119393,column_119394,column_info_119395,seq__119178_119387__$1,temp__5735__auto___119386__$1,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_119419], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_119344,new cljs.core.Keyword(null,"col","col",-1959363084),column_119394,new cljs.core.Keyword(null,"name","name",1843675177),name_119420], null));
});})(seq__119230_119396,chunk__119231_119397,count__119232_119398,i__119233_119399,seq__119178_119346,chunk__119179_119347,count__119180_119348,i__119181_119349,seq__118970_119242,chunk__118971_119243,count__118972_119244,i__118973_119245,map__119240_119416,map__119240_119417__$1,gline_119418,gcol_119419,name_119420,seq__119230_119410__$1,temp__5735__auto___119409__$2,vec__119227_119393,column_119394,column_info_119395,seq__119178_119387__$1,temp__5735__auto___119386__$1,vec__119175_119343,line_119344,columns_119345,seq__118970_119337__$1,temp__5735__auto___119336,inverted))
,cljs.core.sorted_map.call(null)));


var G__119421 = cljs.core.next.call(null,seq__119230_119410__$1);
var G__119422 = null;
var G__119423 = (0);
var G__119424 = (0);
seq__119230_119396 = G__119421;
chunk__119231_119397 = G__119422;
count__119232_119398 = G__119423;
i__119233_119399 = G__119424;
continue;
}
} else {
}
}
break;
}


var G__119425 = cljs.core.next.call(null,seq__119178_119387__$1);
var G__119426 = null;
var G__119427 = (0);
var G__119428 = (0);
seq__119178_119346 = G__119425;
chunk__119179_119347 = G__119426;
count__119180_119348 = G__119427;
i__119181_119349 = G__119428;
continue;
}
} else {
}
}
break;
}


var G__119429 = cljs.core.next.call(null,seq__118970_119337__$1);
var G__119430 = null;
var G__119431 = (0);
var G__119432 = (0);
seq__118970_119242 = G__119429;
chunk__118971_119243 = G__119430;
count__118972_119244 = G__119431;
i__118973_119245 = G__119432;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
