// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__114990 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__114990,(0),null);
var network = cljs.core.nth.call(null,vec__114990,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__114990,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115084){
var state_val_115085 = (state_115084[(1)]);
if((state_val_115085 === (7))){
var state_115084__$1 = state_115084;
var statearr_115086_115125 = state_115084__$1;
(statearr_115086_115125[(2)] = false);

(statearr_115086_115125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (20))){
var inst_115048 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
var statearr_115087_115126 = state_115084__$1;
(statearr_115087_115126[(2)] = inst_115048);

(statearr_115087_115126[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (1))){
var state_115084__$1 = state_115084;
var statearr_115088_115127 = state_115084__$1;
(statearr_115088_115127[(2)] = null);

(statearr_115088_115127[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (24))){
var inst_115061 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_115062 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_115063 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_115064 = cljs.core.PersistentHashMap.fromArrays(inst_115062,inst_115063);
var inst_115065 = cljs.core.ex_info.call(null,inst_115061,inst_115064);
var inst_115066 = (function(){throw inst_115065})();
var state_115084__$1 = state_115084;
var statearr_115089_115128 = state_115084__$1;
(statearr_115089_115128[(2)] = inst_115066);

(statearr_115089_115128[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115084,(3),Error,null,(2));
var inst_114999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115000 = [pred_id];
var inst_115001 = (new cljs.core.PersistentVector(null,1,(5),inst_114999,inst_115000,null));
var inst_115002 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_115001);
var state_115084__$1 = state_115084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115084__$1,(5),inst_115002);
} else {
if((state_val_115085 === (15))){
var inst_115035 = (state_115084[(7)]);
var inst_115040 = inst_115035.cljs$lang$protocol_mask$partition0$;
var inst_115041 = (inst_115040 & (64));
var inst_115042 = inst_115035.cljs$core$ISeq$;
var inst_115043 = (cljs.core.PROTOCOL_SENTINEL === inst_115042);
var inst_115044 = ((inst_115041) || (inst_115043));
var state_115084__$1 = state_115084;
if(cljs.core.truth_(inst_115044)){
var statearr_115090_115129 = state_115084__$1;
(statearr_115090_115129[(1)] = (18));

} else {
var statearr_115091_115130 = state_115084__$1;
(statearr_115091_115130[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (21))){
var inst_115035 = (state_115084[(7)]);
var inst_115053 = cljs.core.apply.call(null,cljs.core.hash_map,inst_115035);
var state_115084__$1 = state_115084;
var statearr_115092_115131 = state_115084__$1;
(statearr_115092_115131[(2)] = inst_115053);

(statearr_115092_115131[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (13))){
var inst_115006 = (state_115084[(8)]);
var state_115084__$1 = state_115084;
var statearr_115093_115132 = state_115084__$1;
(statearr_115093_115132[(2)] = inst_115006);

(statearr_115093_115132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (22))){
var inst_115035 = (state_115084[(7)]);
var state_115084__$1 = state_115084;
var statearr_115094_115133 = state_115084__$1;
(statearr_115094_115133[(2)] = inst_115035);

(statearr_115094_115133[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (6))){
var inst_115006 = (state_115084[(8)]);
var inst_115011 = inst_115006.cljs$lang$protocol_mask$partition0$;
var inst_115012 = (inst_115011 & (64));
var inst_115013 = inst_115006.cljs$core$ISeq$;
var inst_115014 = (cljs.core.PROTOCOL_SENTINEL === inst_115013);
var inst_115015 = ((inst_115012) || (inst_115014));
var state_115084__$1 = state_115084;
if(cljs.core.truth_(inst_115015)){
var statearr_115095_115134 = state_115084__$1;
(statearr_115095_115134[(1)] = (9));

} else {
var statearr_115096_115135 = state_115084__$1;
(statearr_115096_115135[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (25))){
var state_115084__$1 = state_115084;
var statearr_115097_115136 = state_115084__$1;
(statearr_115097_115136[(2)] = null);

(statearr_115097_115136[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (17))){
var inst_115051 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
if(cljs.core.truth_(inst_115051)){
var statearr_115098_115137 = state_115084__$1;
(statearr_115098_115137[(1)] = (21));

} else {
var statearr_115099_115138 = state_115084__$1;
(statearr_115099_115138[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (3))){
var inst_114993 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
var statearr_115100_115139 = state_115084__$1;
(statearr_115100_115139[(2)] = inst_114993);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115084__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (12))){
var inst_115006 = (state_115084[(8)]);
var inst_115024 = cljs.core.apply.call(null,cljs.core.hash_map,inst_115006);
var state_115084__$1 = state_115084;
var statearr_115101_115140 = state_115084__$1;
(statearr_115101_115140[(2)] = inst_115024);

(statearr_115101_115140[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (2))){
var inst_115082 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115084__$1,inst_115082);
} else {
if((state_val_115085 === (23))){
var inst_115031 = (state_115084[(9)]);
var inst_115056 = (state_115084[(2)]);
var inst_115057 = cljs.core.get.call(null,inst_115056,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_115058 = cljs.core.get.call(null,inst_115056,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_115059 = (inst_115031 > inst_115058);
var state_115084__$1 = (function (){var statearr_115102 = state_115084;
(statearr_115102[(10)] = inst_115057);

return statearr_115102;
})();
if(cljs.core.truth_(inst_115059)){
var statearr_115103_115141 = state_115084__$1;
(statearr_115103_115141[(1)] = (24));

} else {
var statearr_115104_115142 = state_115084__$1;
(statearr_115104_115142[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (19))){
var state_115084__$1 = state_115084;
var statearr_115105_115143 = state_115084__$1;
(statearr_115105_115143[(2)] = false);

(statearr_115105_115143[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (11))){
var inst_115019 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
var statearr_115106_115144 = state_115084__$1;
(statearr_115106_115144[(2)] = inst_115019);

(statearr_115106_115144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (9))){
var state_115084__$1 = state_115084;
var statearr_115107_115145 = state_115084__$1;
(statearr_115107_115145[(2)] = true);

(statearr_115107_115145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (5))){
var inst_115006 = (state_115084[(8)]);
var inst_115004 = (state_115084[(2)]);
var inst_115005 = fluree.db.util.async.throw_err.call(null,inst_115004);
var inst_115006__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_115008 = (inst_115006__$1 == null);
var inst_115009 = cljs.core.not.call(null,inst_115008);
var state_115084__$1 = (function (){var statearr_115108 = state_115084;
(statearr_115108[(11)] = inst_115005);

(statearr_115108[(8)] = inst_115006__$1);

return statearr_115108;
})();
if(inst_115009){
var statearr_115109_115146 = state_115084__$1;
(statearr_115109_115146[(1)] = (6));

} else {
var statearr_115110_115147 = state_115084__$1;
(statearr_115110_115147[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (14))){
var inst_115035 = (state_115084[(7)]);
var inst_115005 = (state_115084[(11)]);
var inst_115027 = (state_115084[(2)]);
var inst_115028 = cljs.core.get.call(null,inst_115027,new cljs.core.Keyword(null,"post","post",269697687));
var inst_115029 = cljs.core.get.call(null,inst_115027,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_115030 = fluree.db.flake.size_bytes.call(null,inst_115005);
var inst_115031 = (inst_115029 + inst_115030);
var inst_115032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115033 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_115034 = (new cljs.core.PersistentVector(null,2,(5),inst_115032,inst_115033,null));
var inst_115035__$1 = cljs.core.get_in.call(null,db,inst_115034);
var inst_115037 = (inst_115035__$1 == null);
var inst_115038 = cljs.core.not.call(null,inst_115037);
var state_115084__$1 = (function (){var statearr_115111 = state_115084;
(statearr_115111[(7)] = inst_115035__$1);

(statearr_115111[(9)] = inst_115031);

(statearr_115111[(12)] = inst_115028);

return statearr_115111;
})();
if(inst_115038){
var statearr_115112_115148 = state_115084__$1;
(statearr_115112_115148[(1)] = (15));

} else {
var statearr_115113_115149 = state_115084__$1;
(statearr_115113_115149[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (26))){
var inst_115031 = (state_115084[(9)]);
var inst_115005 = (state_115084[(11)]);
var inst_115028 = (state_115084[(12)]);
var inst_115069 = (state_115084[(2)]);
var inst_115070 = cljs.core.into.call(null,inst_115028,inst_115005);
var inst_115071 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_115072 = cljs.core.swap_BANG_.call(null,inst_115071,cljs.core.empty);
var inst_115073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115074 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_115075 = (new cljs.core.PersistentVector(null,2,(5),inst_115073,inst_115074,null));
var inst_115076 = cljs.core.assoc_in.call(null,db,inst_115075,inst_115070);
var inst_115077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115078 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_115079 = (new cljs.core.PersistentVector(null,2,(5),inst_115077,inst_115078,null));
var inst_115080 = cljs.core.assoc_in.call(null,inst_115076,inst_115079,inst_115031);
var state_115084__$1 = (function (){var statearr_115114 = state_115084;
(statearr_115114[(13)] = inst_115072);

(statearr_115114[(14)] = inst_115069);

return statearr_115114;
})();
var statearr_115115_115150 = state_115084__$1;
(statearr_115115_115150[(2)] = inst_115080);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115084__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (16))){
var state_115084__$1 = state_115084;
var statearr_115116_115151 = state_115084__$1;
(statearr_115116_115151[(2)] = false);

(statearr_115116_115151[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (10))){
var state_115084__$1 = state_115084;
var statearr_115117_115152 = state_115084__$1;
(statearr_115117_115152[(2)] = false);

(statearr_115117_115152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (18))){
var state_115084__$1 = state_115084;
var statearr_115118_115153 = state_115084__$1;
(statearr_115118_115153[(2)] = true);

(statearr_115118_115153[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115085 === (8))){
var inst_115022 = (state_115084[(2)]);
var state_115084__$1 = state_115084;
if(cljs.core.truth_(inst_115022)){
var statearr_115119_115154 = state_115084__$1;
(statearr_115119_115154[(1)] = (12));

} else {
var statearr_115120_115155 = state_115084__$1;
(statearr_115120_115155[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____0 = (function (){
var statearr_115121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115121[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__);

(statearr_115121[(1)] = (1));

return statearr_115121;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____1 = (function (state_115084){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115122){if((e115122 instanceof Object)){
var ex__99978__auto__ = e115122;
var statearr_115123_115156 = state_115084;
(statearr_115123_115156[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115084);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115122;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__115157 = state_115084;
state_115084 = G__115157;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__ = function(state_115084){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____1.call(this,state_115084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115124 = f__100070__auto__.call(null);
(statearr_115124[(6)] = c__100069__auto__);

return statearr_115124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115352){
var state_val_115353 = (state_115352[(1)]);
if((state_val_115353 === (7))){
var inst_115191 = (state_115352[(7)]);
var inst_115183 = (state_115352[(8)]);
var inst_115181 = (state_115352[(9)]);
var inst_115187 = (state_115352[(10)]);
var inst_115166 = (state_115352[(11)]);
var inst_115197 = (state_115352[(12)]);
var inst_115181__$1 = (state_115352[(2)]);
var inst_115182 = (function (){var t = inst_115166;
var _ = inst_115181__$1;
return (function (p1__115158_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__115158_SHARP_.p));
});
})();
var inst_115183__$1 = cljs.core.filter.call(null,inst_115182,flakes);
var inst_115184 = cljs.core.PersistentHashSet.EMPTY;
var inst_115185 = (function (){var t = inst_115166;
var _ = inst_115181__$1;
var add_flakes = inst_115183__$1;
return (function (p1__115159_SHARP_){
return p1__115159_SHARP_.p;
});
})();
var inst_115186 = cljs.core.map.call(null,inst_115185,inst_115183__$1);
var inst_115187__$1 = cljs.core.into.call(null,inst_115184,inst_115186);
var inst_115188 = cljs.core.PersistentHashMap.EMPTY;
var inst_115189 = (function (){var t = inst_115166;
var _ = inst_115181__$1;
var add_flakes = inst_115183__$1;
var add_preds = inst_115187__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_115190 = cljs.core.map.call(null,inst_115189,inst_115187__$1);
var inst_115191__$1 = cljs.core.into.call(null,inst_115188,inst_115190);
var inst_115192 = cljs.core.PersistentHashMap.EMPTY;
var inst_115193 = (function (){var t = inst_115166;
var _ = inst_115181__$1;
var add_flakes = inst_115183__$1;
var add_preds = inst_115187__$1;
var idx_QMARK__map = inst_115191__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_115194 = cljs.core.map.call(null,inst_115193,inst_115187__$1);
var inst_115195 = cljs.core.into.call(null,inst_115192,inst_115194);
var inst_115196 = fluree.db.flake.size_bytes.call(null,inst_115183__$1);
var inst_115197__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_115183__$1);
var inst_115198 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_115183__$1);
var inst_115199 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_115200 = cljs.core.get.call(null,inst_115199,(0));
var state_115352__$1 = (function (){var statearr_115354 = state_115352;
(statearr_115354[(7)] = inst_115191__$1);

(statearr_115354[(13)] = inst_115198);

(statearr_115354[(8)] = inst_115183__$1);

(statearr_115354[(14)] = inst_115196);

(statearr_115354[(15)] = inst_115200);

(statearr_115354[(9)] = inst_115181__$1);

(statearr_115354[(10)] = inst_115187__$1);

(statearr_115354[(16)] = inst_115195);

(statearr_115354[(12)] = inst_115197__$1);

return statearr_115354;
})();
if(cljs.core.truth_(inst_115197__$1)){
var statearr_115355_115413 = state_115352__$1;
(statearr_115355_115413[(1)] = (8));

} else {
var statearr_115356_115414 = state_115352__$1;
(statearr_115356_115414[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (20))){
var inst_115191 = (state_115352[(7)]);
var inst_115198 = (state_115352[(13)]);
var inst_115183 = (state_115352[(8)]);
var inst_115285 = (state_115352[(17)]);
var inst_115196 = (state_115352[(14)]);
var inst_115278 = (state_115352[(18)]);
var inst_115286 = (state_115352[(19)]);
var inst_115200 = (state_115352[(15)]);
var inst_115276 = (state_115352[(20)]);
var inst_115277 = (state_115352[(21)]);
var inst_115181 = (state_115352[(9)]);
var inst_115255 = (state_115352[(22)]);
var inst_115279 = (state_115352[(23)]);
var inst_115246 = (state_115352[(24)]);
var inst_115256 = (state_115352[(25)]);
var inst_115187 = (state_115352[(10)]);
var inst_115206 = (state_115352[(26)]);
var inst_115275 = (state_115352[(27)]);
var inst_115195 = (state_115352[(16)]);
var inst_115274 = (state_115352[(28)]);
var inst_115166 = (state_115352[(11)]);
var inst_115197 = (state_115352[(12)]);
var inst_115324 = inst_115285.s;
var inst_115325 = fluree.db.flake.sid__GT_cid.call(null,inst_115324);
var inst_115326 = (function (){var flakes_bytes = inst_115196;
var t = inst_115166;
var spot = inst_115275;
var add_flakes = inst_115183;
var root_setting_change_QMARK_ = inst_115198;
var vec__115281 = inst_115274;
var seq__115282 = inst_115286;
var ref_QMARK__map = inst_115195;
var first__115253 = inst_115255;
var r = inst_115286;
var psot = inst_115276;
var G__115250 = inst_115274;
var add_pred_to_idx_QMARK_ = inst_115206;
var first__115283 = inst_115285;
var _ = inst_115181;
var cid = inst_115325;
var ecount = inst_115279;
var pred_ecount = inst_115200;
var db_STAR_ = inst_115246;
var schema_change_QMARK_ = inst_115197;
var seq__115252 = inst_115256;
var vec__115251 = inst_115183;
var add_preds = inst_115187;
var opst = inst_115278;
var idx_QMARK__map = inst_115191;
var post = inst_115277;
var f = inst_115285;
return (function (p1__115160_SHARP_){
if(cljs.core.truth_(p1__115160_SHARP_)){
var x__4214__auto__ = p1__115160_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_115327 = cljs.core.update.call(null,inst_115279,inst_115325,inst_115326);
var inst_115328 = cljs.core.conj.call(null,inst_115275,inst_115285);
var inst_115329 = cljs.core.conj.call(null,inst_115276,inst_115285);
var inst_115330 = inst_115285.p;
var inst_115331 = cljs.core.get.call(null,inst_115191,inst_115330);
var state_115352__$1 = (function (){var statearr_115357 = state_115352;
(statearr_115357[(29)] = inst_115328);

(statearr_115357[(30)] = inst_115327);

(statearr_115357[(31)] = inst_115329);

return statearr_115357;
})();
if(cljs.core.truth_(inst_115331)){
var statearr_115358_115415 = state_115352__$1;
(statearr_115358_115415[(1)] = (33));

} else {
var statearr_115359_115416 = state_115352__$1;
(statearr_115359_115416[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (27))){
var inst_115198 = (state_115352[(13)]);
var inst_115312 = (state_115352[(2)]);
var state_115352__$1 = (function (){var statearr_115360 = state_115352;
(statearr_115360[(32)] = inst_115312);

return statearr_115360;
})();
if(cljs.core.truth_(inst_115198)){
var statearr_115361_115417 = state_115352__$1;
(statearr_115361_115417[(1)] = (29));

} else {
var statearr_115362_115418 = state_115352__$1;
(statearr_115362_115418[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (1))){
var state_115352__$1 = state_115352;
var statearr_115363_115419 = state_115352__$1;
(statearr_115363_115419[(2)] = null);

(statearr_115363_115419[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (24))){
var inst_115303 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
if(cljs.core.truth_(inst_115303)){
var statearr_115364_115420 = state_115352__$1;
(statearr_115364_115420[(1)] = (25));

} else {
var statearr_115365_115421 = state_115352__$1;
(statearr_115365_115421[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (4))){
var inst_115166 = (state_115352[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115352,(3),Error,null,(2));
var inst_115165 = cljs.core.first.call(null,flakes);
var inst_115166__$1 = inst_115165.t;
var inst_115167 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_115168 = (inst_115167 - (1));
var inst_115169 = cljs.core.not_EQ_.call(null,inst_115166__$1,inst_115168);
var state_115352__$1 = (function (){var statearr_115366 = state_115352;
(statearr_115366[(11)] = inst_115166__$1);

return statearr_115366;
})();
if(inst_115169){
var statearr_115367_115422 = state_115352__$1;
(statearr_115367_115422[(1)] = (5));

} else {
var statearr_115368_115423 = state_115352__$1;
(statearr_115368_115423[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (15))){
var inst_115234 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
var statearr_115369_115424 = state_115352__$1;
(statearr_115369_115424[(2)] = inst_115234);

(statearr_115369_115424[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (21))){
var inst_115346 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
var statearr_115370_115425 = state_115352__$1;
(statearr_115370_115425[(2)] = inst_115346);

(statearr_115370_115425[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (31))){
var inst_115322 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
var statearr_115371_115426 = state_115352__$1;
(statearr_115371_115426[(2)] = inst_115322);

(statearr_115371_115426[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (32))){
var inst_115312 = (state_115352[(32)]);
var inst_115317 = (state_115352[(2)]);
var inst_115318 = fluree.db.util.async.throw_err.call(null,inst_115317);
var inst_115319 = cljs.core.assoc.call(null,inst_115312,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_115318);
var state_115352__$1 = state_115352;
var statearr_115372_115427 = state_115352__$1;
(statearr_115372_115427[(2)] = inst_115319);

(statearr_115372_115427[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (33))){
var inst_115285 = (state_115352[(17)]);
var inst_115277 = (state_115352[(21)]);
var inst_115333 = cljs.core.conj.call(null,inst_115277,inst_115285);
var state_115352__$1 = state_115352;
var statearr_115373_115428 = state_115352__$1;
(statearr_115373_115428[(2)] = inst_115333);

(statearr_115373_115428[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (13))){
var inst_115218 = (state_115352[(33)]);
var inst_115224 = (state_115352[(34)]);
var inst_115227 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_115218,inst_115224);
var state_115352__$1 = state_115352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115352__$1,(16),inst_115227);
} else {
if((state_val_115353 === (22))){
var inst_115197 = (state_115352[(12)]);
var state_115352__$1 = state_115352;
var statearr_115374_115429 = state_115352__$1;
(statearr_115374_115429[(2)] = inst_115197);

(statearr_115374_115429[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (36))){
var inst_115285 = (state_115352[(17)]);
var inst_115278 = (state_115352[(18)]);
var inst_115340 = cljs.core.conj.call(null,inst_115278,inst_115285);
var state_115352__$1 = state_115352;
var statearr_115375_115430 = state_115352__$1;
(statearr_115375_115430[(2)] = inst_115340);

(statearr_115375_115430[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (29))){
var inst_115312 = (state_115352[(32)]);
var inst_115315 = fluree.db.query.schema.setting_map.call(null,inst_115312);
var state_115352__$1 = state_115352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115352__$1,(32),inst_115315);
} else {
if((state_val_115353 === (6))){
var state_115352__$1 = state_115352;
var statearr_115376_115431 = state_115352__$1;
(statearr_115376_115431[(2)] = null);

(statearr_115376_115431[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (28))){
var inst_115297 = (state_115352[(35)]);
var inst_115307 = (state_115352[(2)]);
var inst_115308 = fluree.db.util.async.throw_err.call(null,inst_115307);
var inst_115309 = cljs.core.assoc.call(null,inst_115297,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_115308);
var state_115352__$1 = state_115352;
var statearr_115377_115432 = state_115352__$1;
(statearr_115377_115432[(2)] = inst_115309);

(statearr_115377_115432[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (25))){
var inst_115297 = (state_115352[(35)]);
var inst_115305 = fluree.db.query.schema.schema_map.call(null,inst_115297);
var state_115352__$1 = state_115352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115352__$1,(28),inst_115305);
} else {
if((state_val_115353 === (34))){
var inst_115277 = (state_115352[(21)]);
var state_115352__$1 = state_115352;
var statearr_115378_115433 = state_115352__$1;
(statearr_115378_115433[(2)] = inst_115277);

(statearr_115378_115433[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (17))){
var inst_115285 = (state_115352[(17)]);
var inst_115274 = (state_115352[(28)]);
var inst_115284 = cljs.core.seq.call(null,inst_115274);
var inst_115285__$1 = cljs.core.first.call(null,inst_115284);
var inst_115286 = cljs.core.next.call(null,inst_115284);
var inst_115287 = cljs.core.not.call(null,inst_115285__$1);
var state_115352__$1 = (function (){var statearr_115379 = state_115352;
(statearr_115379[(17)] = inst_115285__$1);

(statearr_115379[(19)] = inst_115286);

return statearr_115379;
})();
if(inst_115287){
var statearr_115380_115434 = state_115352__$1;
(statearr_115380_115434[(1)] = (19));

} else {
var statearr_115381_115435 = state_115352__$1;
(statearr_115381_115435[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (3))){
var inst_115161 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
var statearr_115382_115436 = state_115352__$1;
(statearr_115382_115436[(2)] = inst_115161);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115352__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (12))){
var inst_115183 = (state_115352[(8)]);
var inst_115196 = (state_115352[(14)]);
var inst_115246 = (state_115352[(24)]);
var inst_115166 = (state_115352[(11)]);
var inst_115236 = (state_115352[(2)]);
var inst_115237 = cljs.core.assoc.call(null,inst_115236,new cljs.core.Keyword(null,"t","t",-1397832519),inst_115166);
var inst_115238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115239 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_115240 = (new cljs.core.PersistentVector(null,2,(5),inst_115238,inst_115239,null));
var inst_115241 = cljs.core.update_in.call(null,inst_115237,inst_115240,cljs.core._PLUS_,inst_115196);
var inst_115242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115243 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_115244 = (new cljs.core.PersistentVector(null,2,(5),inst_115242,inst_115243,null));
var inst_115245 = cljs.core.count.call(null,inst_115183);
var inst_115246__$1 = cljs.core.update_in.call(null,inst_115241,inst_115244,cljs.core._PLUS_,inst_115245);
var inst_115254 = cljs.core.seq.call(null,inst_115183);
var inst_115255 = cljs.core.first.call(null,inst_115254);
var inst_115256 = cljs.core.next.call(null,inst_115254);
var inst_115257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115258 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_115259 = (new cljs.core.PersistentVector(null,2,(5),inst_115257,inst_115258,null));
var inst_115260 = cljs.core.get_in.call(null,inst_115246__$1,inst_115259);
var inst_115261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115262 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_115263 = (new cljs.core.PersistentVector(null,2,(5),inst_115261,inst_115262,null));
var inst_115264 = cljs.core.get_in.call(null,inst_115246__$1,inst_115263);
var inst_115265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115266 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_115267 = (new cljs.core.PersistentVector(null,2,(5),inst_115265,inst_115266,null));
var inst_115268 = cljs.core.get_in.call(null,inst_115246__$1,inst_115267);
var inst_115269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115270 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_115271 = (new cljs.core.PersistentVector(null,2,(5),inst_115269,inst_115270,null));
var inst_115272 = cljs.core.get_in.call(null,inst_115246__$1,inst_115271);
var inst_115273 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_115274 = inst_115183;
var inst_115275 = inst_115260;
var inst_115276 = inst_115264;
var inst_115277 = inst_115268;
var inst_115278 = inst_115272;
var inst_115279 = inst_115273;
var state_115352__$1 = (function (){var statearr_115383 = state_115352;
(statearr_115383[(18)] = inst_115278);

(statearr_115383[(20)] = inst_115276);

(statearr_115383[(21)] = inst_115277);

(statearr_115383[(22)] = inst_115255);

(statearr_115383[(23)] = inst_115279);

(statearr_115383[(24)] = inst_115246__$1);

(statearr_115383[(25)] = inst_115256);

(statearr_115383[(27)] = inst_115275);

(statearr_115383[(28)] = inst_115274);

return statearr_115383;
})();
var statearr_115384_115437 = state_115352__$1;
(statearr_115384_115437[(2)] = null);

(statearr_115384_115437[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (2))){
var inst_115350 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115352__$1,inst_115350);
} else {
if((state_val_115353 === (23))){
var inst_115297 = (state_115352[(35)]);
var inst_115300 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_115297);
var inst_115301 = (inst_115300 == null);
var state_115352__$1 = state_115352;
var statearr_115385_115438 = state_115352__$1;
(statearr_115385_115438[(2)] = inst_115301);

(statearr_115385_115438[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (35))){
var inst_115285 = (state_115352[(17)]);
var inst_115195 = (state_115352[(16)]);
var inst_115336 = (state_115352[(2)]);
var inst_115337 = inst_115285.p;
var inst_115338 = cljs.core.get.call(null,inst_115195,inst_115337);
var state_115352__$1 = (function (){var statearr_115386 = state_115352;
(statearr_115386[(36)] = inst_115336);

return statearr_115386;
})();
if(cljs.core.truth_(inst_115338)){
var statearr_115387_115439 = state_115352__$1;
(statearr_115387_115439[(1)] = (36));

} else {
var statearr_115388_115440 = state_115352__$1;
(statearr_115388_115440[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (19))){
var inst_115196 = (state_115352[(14)]);
var inst_115278 = (state_115352[(18)]);
var inst_115276 = (state_115352[(20)]);
var inst_115277 = (state_115352[(21)]);
var inst_115279 = (state_115352[(23)]);
var inst_115246 = (state_115352[(24)]);
var inst_115275 = (state_115352[(27)]);
var inst_115197 = (state_115352[(12)]);
var inst_115289 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_115290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115291 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_115292 = (new cljs.core.PersistentVector(null,2,(5),inst_115290,inst_115291,null));
var inst_115293 = cljs.core.get_in.call(null,inst_115246,inst_115292);
var inst_115294 = (inst_115196 + inst_115293);
var inst_115295 = [inst_115275,inst_115276,inst_115277,inst_115278,inst_115294];
var inst_115296 = cljs.core.PersistentHashMap.fromArrays(inst_115289,inst_115295);
var inst_115297 = cljs.core.assoc.call(null,inst_115246,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_115279,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_115296);
var state_115352__$1 = (function (){var statearr_115389 = state_115352;
(statearr_115389[(35)] = inst_115297);

return statearr_115389;
})();
if(cljs.core.truth_(inst_115197)){
var statearr_115390_115441 = state_115352__$1;
(statearr_115390_115441[(1)] = (22));

} else {
var statearr_115391_115442 = state_115352__$1;
(statearr_115391_115442[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (11))){
var inst_115217 = (state_115352[(37)]);
var inst_115224 = (state_115352[(34)]);
var inst_115223 = cljs.core.seq.call(null,inst_115217);
var inst_115224__$1 = cljs.core.first.call(null,inst_115223);
var inst_115225 = cljs.core.next.call(null,inst_115223);
var state_115352__$1 = (function (){var statearr_115392 = state_115352;
(statearr_115392[(38)] = inst_115225);

(statearr_115392[(34)] = inst_115224__$1);

return statearr_115392;
})();
if(cljs.core.truth_(inst_115224__$1)){
var statearr_115393_115443 = state_115352__$1;
(statearr_115393_115443[(1)] = (13));

} else {
var statearr_115394_115444 = state_115352__$1;
(statearr_115394_115444[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (9))){
var inst_115204 = cljs.core.PersistentVector.EMPTY;
var state_115352__$1 = state_115352;
var statearr_115395_115445 = state_115352__$1;
(statearr_115395_115445[(2)] = inst_115204);

(statearr_115395_115445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (5))){
var inst_115166 = (state_115352[(11)]);
var inst_115171 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_115172 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_115173 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115171)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115172)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115166),"."].join('');
var inst_115174 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115175 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_115176 = cljs.core.PersistentHashMap.fromArrays(inst_115174,inst_115175);
var inst_115177 = cljs.core.ex_info.call(null,inst_115173,inst_115176);
var inst_115178 = (function(){throw inst_115177})();
var state_115352__$1 = state_115352;
var statearr_115396_115446 = state_115352__$1;
(statearr_115396_115446[(2)] = inst_115178);

(statearr_115396_115446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (14))){
var inst_115218 = (state_115352[(33)]);
var state_115352__$1 = state_115352;
var statearr_115397_115447 = state_115352__$1;
(statearr_115397_115447[(2)] = inst_115218);

(statearr_115397_115447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (26))){
var inst_115297 = (state_115352[(35)]);
var state_115352__$1 = state_115352;
var statearr_115398_115448 = state_115352__$1;
(statearr_115398_115448[(2)] = inst_115297);

(statearr_115398_115448[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (16))){
var inst_115225 = (state_115352[(38)]);
var inst_115229 = (state_115352[(2)]);
var inst_115230 = fluree.db.util.async.throw_err.call(null,inst_115229);
var inst_115217 = inst_115225;
var inst_115218 = inst_115230;
var state_115352__$1 = (function (){var statearr_115399 = state_115352;
(statearr_115399[(33)] = inst_115218);

(statearr_115399[(37)] = inst_115217);

return statearr_115399;
})();
var statearr_115400_115449 = state_115352__$1;
(statearr_115400_115449[(2)] = null);

(statearr_115400_115449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (38))){
var inst_115336 = (state_115352[(36)]);
var inst_115286 = (state_115352[(19)]);
var inst_115328 = (state_115352[(29)]);
var inst_115327 = (state_115352[(30)]);
var inst_115329 = (state_115352[(31)]);
var inst_115343 = (state_115352[(2)]);
var inst_115274 = inst_115286;
var inst_115275 = inst_115328;
var inst_115276 = inst_115329;
var inst_115277 = inst_115336;
var inst_115278 = inst_115343;
var inst_115279 = inst_115327;
var state_115352__$1 = (function (){var statearr_115401 = state_115352;
(statearr_115401[(18)] = inst_115278);

(statearr_115401[(20)] = inst_115276);

(statearr_115401[(21)] = inst_115277);

(statearr_115401[(23)] = inst_115279);

(statearr_115401[(27)] = inst_115275);

(statearr_115401[(28)] = inst_115274);

return statearr_115401;
})();
var statearr_115402_115450 = state_115352__$1;
(statearr_115402_115450[(2)] = null);

(statearr_115402_115450[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (30))){
var inst_115312 = (state_115352[(32)]);
var state_115352__$1 = state_115352;
var statearr_115403_115451 = state_115352__$1;
(statearr_115403_115451[(2)] = inst_115312);

(statearr_115403_115451[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (10))){
var inst_115206 = (state_115352[(26)]);
var inst_115206__$1 = (state_115352[(2)]);
var inst_115214 = cljs.core.seq.call(null,inst_115206__$1);
var inst_115215 = cljs.core.first.call(null,inst_115214);
var inst_115216 = cljs.core.next.call(null,inst_115214);
var inst_115217 = inst_115206__$1;
var inst_115218 = db;
var state_115352__$1 = (function (){var statearr_115404 = state_115352;
(statearr_115404[(33)] = inst_115218);

(statearr_115404[(37)] = inst_115217);

(statearr_115404[(39)] = inst_115216);

(statearr_115404[(26)] = inst_115206__$1);

(statearr_115404[(40)] = inst_115215);

return statearr_115404;
})();
var statearr_115405_115452 = state_115352__$1;
(statearr_115405_115452[(2)] = null);

(statearr_115405_115452[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (18))){
var inst_115348 = (state_115352[(2)]);
var state_115352__$1 = state_115352;
var statearr_115406_115453 = state_115352__$1;
(statearr_115406_115453[(2)] = inst_115348);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115352__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (37))){
var inst_115278 = (state_115352[(18)]);
var state_115352__$1 = state_115352;
var statearr_115407_115454 = state_115352__$1;
(statearr_115407_115454[(2)] = inst_115278);

(statearr_115407_115454[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115353 === (8))){
var inst_115183 = (state_115352[(8)]);
var inst_115200 = (state_115352[(15)]);
var inst_115202 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_115183,inst_115200);
var state_115352__$1 = state_115352;
var statearr_115408_115455 = state_115352__$1;
(statearr_115408_115455[(2)] = inst_115202);

(statearr_115408_115455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__99975__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__99975__auto____0 = (function (){
var statearr_115409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115409[(0)] = fluree$db$graphdb$with_t_$_state_machine__99975__auto__);

(statearr_115409[(1)] = (1));

return statearr_115409;
});
var fluree$db$graphdb$with_t_$_state_machine__99975__auto____1 = (function (state_115352){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115410){if((e115410 instanceof Object)){
var ex__99978__auto__ = e115410;
var statearr_115411_115456 = state_115352;
(statearr_115411_115456[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115410;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__115457 = state_115352;
state_115352 = G__115457;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__99975__auto__ = function(state_115352){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__99975__auto____1.call(this,state_115352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__99975__auto____0;
fluree$db$graphdb$with_t_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__99975__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115412 = f__100070__auto__.call(null);
(statearr_115412[(6)] = c__100069__auto__);

return statearr_115412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__100069__auto___115592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115549){
var state_val_115550 = (state_115549[(1)]);
if((state_val_115550 === (7))){
var inst_115477 = (state_115549[(2)]);
var inst_115478 = cljs.core.empty_QMARK_.call(null,flakes);
var state_115549__$1 = (function (){var statearr_115551 = state_115549;
(statearr_115551[(7)] = inst_115477);

return statearr_115551;
})();
if(inst_115478){
var statearr_115552_115593 = state_115549__$1;
(statearr_115552_115593[(1)] = (8));

} else {
var statearr_115553_115594 = state_115549__$1;
(statearr_115553_115594[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (20))){
var state_115549__$1 = state_115549;
var statearr_115554_115595 = state_115549__$1;
(statearr_115554_115595[(2)] = null);

(statearr_115554_115595[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (1))){
var state_115549__$1 = state_115549;
var statearr_115555_115596 = state_115549__$1;
(statearr_115555_115596[(2)] = null);

(statearr_115555_115596[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (24))){
var inst_115524 = (state_115549[(8)]);
var inst_115507 = (state_115549[(9)]);
var inst_115506 = (state_115549[(10)]);
var inst_115529 = inst_115506.t;
var inst_115530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115531 = [inst_115506];
var inst_115532 = (new cljs.core.PersistentVector(null,1,(5),inst_115530,inst_115531,null));
var inst_115497 = inst_115507;
var inst_115498 = inst_115529;
var inst_115499 = inst_115532;
var inst_115500 = inst_115524;
var state_115549__$1 = (function (){var statearr_115556 = state_115549;
(statearr_115556[(11)] = inst_115498);

(statearr_115556[(12)] = inst_115497);

(statearr_115556[(13)] = inst_115499);

(statearr_115556[(14)] = inst_115500);

return statearr_115556;
})();
var statearr_115557_115597 = state_115549__$1;
(statearr_115557_115597[(2)] = null);

(statearr_115557_115597[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115549,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_115463 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_115464 = (inst_115463 + (1));
var inst_115465 = cljs.core.not_EQ_.call(null,block,inst_115464);
var state_115549__$1 = state_115549;
if(inst_115465){
var statearr_115558_115598 = state_115549__$1;
(statearr_115558_115598[(1)] = (5));

} else {
var statearr_115559_115599 = state_115549__$1;
(statearr_115559_115599[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (15))){
var inst_115513 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
if(cljs.core.truth_(inst_115513)){
var statearr_115560_115600 = state_115549__$1;
(statearr_115560_115600[(1)] = (16));

} else {
var statearr_115561_115601 = state_115549__$1;
(statearr_115561_115601[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (21))){
var inst_115538 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
var statearr_115562_115602 = state_115549__$1;
(statearr_115562_115602[(2)] = inst_115538);

(statearr_115562_115602[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (13))){
var inst_115498 = (state_115549[(11)]);
var inst_115506 = (state_115549[(10)]);
var inst_115509 = inst_115506.t;
var inst_115510 = cljs.core._EQ_.call(null,inst_115498,inst_115509);
var state_115549__$1 = state_115549;
var statearr_115563_115603 = state_115549__$1;
(statearr_115563_115603[(2)] = inst_115510);

(statearr_115563_115603[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (22))){
var inst_115506 = (state_115549[(10)]);
var inst_115523 = (state_115549[(2)]);
var inst_115524 = fluree.db.util.async.throw_err.call(null,inst_115523);
var inst_115525 = (inst_115506 == null);
var state_115549__$1 = (function (){var statearr_115564 = state_115549;
(statearr_115564[(8)] = inst_115524);

return statearr_115564;
})();
if(cljs.core.truth_(inst_115525)){
var statearr_115565_115604 = state_115549__$1;
(statearr_115565_115604[(1)] = (23));

} else {
var statearr_115566_115605 = state_115549__$1;
(statearr_115566_115605[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (6))){
var state_115549__$1 = state_115549;
var statearr_115567_115606 = state_115549__$1;
(statearr_115567_115606[(2)] = null);

(statearr_115567_115606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (25))){
var inst_115535 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
var statearr_115568_115607 = state_115549__$1;
(statearr_115568_115607[(2)] = inst_115535);

(statearr_115568_115607[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (17))){
var state_115549__$1 = state_115549;
var statearr_115569_115608 = state_115549__$1;
(statearr_115569_115608[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (3))){
var inst_115458 = (state_115549[(2)]);
var inst_115459 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_115458);
var state_115549__$1 = state_115549;
var statearr_115571_115609 = state_115549__$1;
(statearr_115571_115609[(2)] = inst_115459);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (12))){
var inst_115542 = (state_115549[(2)]);
var inst_115543 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_115542);
var state_115549__$1 = state_115549;
var statearr_115572_115610 = state_115549__$1;
(statearr_115572_115610[(2)] = inst_115543);

(statearr_115572_115610[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (2))){
var inst_115547 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115549__$1,inst_115547);
} else {
if((state_val_115550 === (23))){
var inst_115524 = (state_115549[(8)]);
var inst_115527 = cljs.core.assoc.call(null,inst_115524,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_115549__$1 = state_115549;
var statearr_115573_115611 = state_115549__$1;
(statearr_115573_115611[(2)] = inst_115527);

(statearr_115573_115611[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (19))){
var inst_115498 = (state_115549[(11)]);
var inst_115499 = (state_115549[(13)]);
var inst_115500 = (state_115549[(14)]);
var inst_115519 = (inst_115498 + (1));
var inst_115520 = cljs.core.assoc.call(null,inst_115500,new cljs.core.Keyword(null,"t","t",-1397832519),inst_115519);
var inst_115521 = fluree.db.graphdb.with_t.call(null,inst_115520,inst_115499);
var state_115549__$1 = state_115549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115549__$1,(22),inst_115521);
} else {
if((state_val_115550 === (11))){
var inst_115497 = (state_115549[(12)]);
var inst_115506 = (state_115549[(10)]);
var inst_115505 = cljs.core.seq.call(null,inst_115497);
var inst_115506__$1 = cljs.core.first.call(null,inst_115505);
var inst_115507 = cljs.core.next.call(null,inst_115505);
var state_115549__$1 = (function (){var statearr_115574 = state_115549;
(statearr_115574[(9)] = inst_115507);

(statearr_115574[(10)] = inst_115506__$1);

return statearr_115574;
})();
if(cljs.core.truth_(inst_115506__$1)){
var statearr_115575_115612 = state_115549__$1;
(statearr_115575_115612[(1)] = (13));

} else {
var statearr_115576_115613 = state_115549__$1;
(statearr_115576_115613[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (9))){
var inst_115483 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_115491 = cljs.core.seq.call(null,inst_115483);
var inst_115492 = cljs.core.first.call(null,inst_115491);
var inst_115493 = cljs.core.next.call(null,inst_115491);
var inst_115494 = cljs.core.first.call(null,inst_115483);
var inst_115495 = inst_115494.t;
var inst_115496 = cljs.core.PersistentVector.EMPTY;
var inst_115497 = inst_115483;
var inst_115498 = inst_115495;
var inst_115499 = inst_115496;
var inst_115500 = db;
var state_115549__$1 = (function (){var statearr_115577 = state_115549;
(statearr_115577[(11)] = inst_115498);

(statearr_115577[(12)] = inst_115497);

(statearr_115577[(15)] = inst_115492);

(statearr_115577[(13)] = inst_115499);

(statearr_115577[(16)] = inst_115493);

(statearr_115577[(14)] = inst_115500);

return statearr_115577;
})();
var statearr_115578_115614 = state_115549__$1;
(statearr_115578_115614[(2)] = null);

(statearr_115578_115614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (5))){
var inst_115467 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_115468 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_115469 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115467)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115468)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_115470 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115471 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_115472 = cljs.core.PersistentHashMap.fromArrays(inst_115470,inst_115471);
var inst_115473 = cljs.core.ex_info.call(null,inst_115469,inst_115472);
var inst_115474 = (function(){throw inst_115473})();
var state_115549__$1 = state_115549;
var statearr_115581_115615 = state_115549__$1;
(statearr_115581_115615[(2)] = inst_115474);

(statearr_115581_115615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (14))){
var inst_115506 = (state_115549[(10)]);
var state_115549__$1 = state_115549;
var statearr_115582_115616 = state_115549__$1;
(statearr_115582_115616[(2)] = inst_115506);

(statearr_115582_115616[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (16))){
var inst_115498 = (state_115549[(11)]);
var inst_115499 = (state_115549[(13)]);
var inst_115507 = (state_115549[(9)]);
var inst_115506 = (state_115549[(10)]);
var inst_115500 = (state_115549[(14)]);
var inst_115515 = cljs.core.conj.call(null,inst_115499,inst_115506);
var tmp115579 = inst_115498;
var tmp115580 = inst_115500;
var inst_115497 = inst_115507;
var inst_115498__$1 = tmp115579;
var inst_115499__$1 = inst_115515;
var inst_115500__$1 = tmp115580;
var state_115549__$1 = (function (){var statearr_115583 = state_115549;
(statearr_115583[(11)] = inst_115498__$1);

(statearr_115583[(12)] = inst_115497);

(statearr_115583[(13)] = inst_115499__$1);

(statearr_115583[(14)] = inst_115500__$1);

return statearr_115583;
})();
var statearr_115584_115617 = state_115549__$1;
(statearr_115584_115617[(2)] = null);

(statearr_115584_115617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (10))){
var inst_115545 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
var statearr_115585_115618 = state_115549__$1;
(statearr_115585_115618[(2)] = inst_115545);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115549__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (18))){
var inst_115540 = (state_115549[(2)]);
var state_115549__$1 = state_115549;
var statearr_115586_115619 = state_115549__$1;
(statearr_115586_115619[(2)] = inst_115540);

(statearr_115586_115619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115550 === (8))){
var inst_115480 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_115481 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_115480);
var state_115549__$1 = state_115549;
var statearr_115587_115620 = state_115549__$1;
(statearr_115587_115620[(2)] = inst_115481);

(statearr_115587_115620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__99975__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__99975__auto____0 = (function (){
var statearr_115588 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115588[(0)] = fluree$db$graphdb$with_$_state_machine__99975__auto__);

(statearr_115588[(1)] = (1));

return statearr_115588;
});
var fluree$db$graphdb$with_$_state_machine__99975__auto____1 = (function (state_115549){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115589){if((e115589 instanceof Object)){
var ex__99978__auto__ = e115589;
var statearr_115590_115621 = state_115549;
(statearr_115590_115621[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115589;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__115622 = state_115549;
state_115549 = G__115622;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__99975__auto__ = function(state_115549){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__99975__auto____1.call(this,state_115549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__99975__auto____0;
fluree$db$graphdb$with_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__99975__auto____1;
return fluree$db$graphdb$with_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115591 = f__100070__auto__.call(null);
(statearr_115591[(6)] = c__100069__auto___115592);

return statearr_115591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115675){
var state_val_115676 = (state_115675[(1)]);
if((state_val_115676 === (7))){
var inst_115632 = (state_115675[(2)]);
var inst_115633 = (function (){var tt_id_SINGLEQUOTE_ = inst_115632;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_115634 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_115632);
var inst_115635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115636 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_115637 = (new cljs.core.PersistentVector(null,4,(5),inst_115635,inst_115636,null));
var inst_115638 = cljs.core.reduce.call(null,inst_115633,inst_115634,inst_115637);
var inst_115639 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_115640 = cljs.core.reverse.call(null,inst_115639);
var inst_115641 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_115640);
var inst_115649 = cljs.core.seq.call(null,inst_115641);
var inst_115650 = cljs.core.first.call(null,inst_115649);
var inst_115651 = cljs.core.next.call(null,inst_115649);
var inst_115652 = inst_115638;
var inst_115653 = inst_115641;
var state_115675__$1 = (function (){var statearr_115677 = state_115675;
(statearr_115677[(7)] = inst_115653);

(statearr_115677[(8)] = inst_115650);

(statearr_115677[(9)] = inst_115652);

(statearr_115677[(10)] = inst_115651);

return statearr_115677;
})();
var statearr_115678_115697 = state_115675__$1;
(statearr_115678_115697[(2)] = null);

(statearr_115678_115697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (1))){
var state_115675__$1 = state_115675;
var statearr_115679_115698 = state_115675__$1;
(statearr_115679_115698[(2)] = null);

(statearr_115679_115698[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115675,(3),Error,null,(2));
var inst_115627 = (tt_id == null);
var state_115675__$1 = state_115675;
if(cljs.core.truth_(inst_115627)){
var statearr_115680_115699 = state_115675__$1;
(statearr_115680_115699[(1)] = (5));

} else {
var statearr_115681_115700 = state_115675__$1;
(statearr_115681_115700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (13))){
var inst_115660 = (state_115675[(11)]);
var inst_115664 = (state_115675[(2)]);
var inst_115665 = fluree.db.util.async.throw_err.call(null,inst_115664);
var inst_115652 = inst_115665;
var inst_115653 = inst_115660;
var state_115675__$1 = (function (){var statearr_115682 = state_115675;
(statearr_115682[(7)] = inst_115653);

(statearr_115682[(9)] = inst_115652);

return statearr_115682;
})();
var statearr_115683_115701 = state_115675__$1;
(statearr_115683_115701[(2)] = null);

(statearr_115683_115701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (6))){
var state_115675__$1 = state_115675;
var statearr_115684_115702 = state_115675__$1;
(statearr_115684_115702[(2)] = tt_id);

(statearr_115684_115702[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (3))){
var inst_115623 = (state_115675[(2)]);
var state_115675__$1 = state_115675;
var statearr_115685_115703 = state_115675__$1;
(statearr_115685_115703[(2)] = inst_115623);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115675__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (12))){
var inst_115669 = (state_115675[(2)]);
var state_115675__$1 = state_115675;
var statearr_115686_115704 = state_115675__$1;
(statearr_115686_115704[(2)] = inst_115669);

(statearr_115686_115704[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (2))){
var inst_115673 = (state_115675[(2)]);
var state_115675__$1 = state_115675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115675__$1,inst_115673);
} else {
if((state_val_115676 === (11))){
var inst_115652 = (state_115675[(9)]);
var state_115675__$1 = state_115675;
var statearr_115687_115705 = state_115675__$1;
(statearr_115687_115705[(2)] = inst_115652);

(statearr_115687_115705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (9))){
var inst_115671 = (state_115675[(2)]);
var state_115675__$1 = state_115675;
var statearr_115688_115706 = state_115675__$1;
(statearr_115688_115706[(2)] = inst_115671);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115675__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (5))){
var inst_115629 = fluree.db.util.core.random_uuid.call(null);
var state_115675__$1 = state_115675;
var statearr_115689_115707 = state_115675__$1;
(statearr_115689_115707[(2)] = inst_115629);

(statearr_115689_115707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115676 === (10))){
var inst_115659 = (state_115675[(12)]);
var inst_115652 = (state_115675[(9)]);
var inst_115662 = fluree.db.graphdb.with_t.call(null,inst_115652,inst_115659);
var state_115675__$1 = state_115675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115675__$1,(13),inst_115662);
} else {
if((state_val_115676 === (8))){
var inst_115653 = (state_115675[(7)]);
var inst_115659 = (state_115675[(12)]);
var inst_115658 = cljs.core.seq.call(null,inst_115653);
var inst_115659__$1 = cljs.core.first.call(null,inst_115658);
var inst_115660 = cljs.core.next.call(null,inst_115658);
var state_115675__$1 = (function (){var statearr_115690 = state_115675;
(statearr_115690[(12)] = inst_115659__$1);

(statearr_115690[(11)] = inst_115660);

return statearr_115690;
})();
if(cljs.core.truth_(inst_115659__$1)){
var statearr_115691_115708 = state_115675__$1;
(statearr_115691_115708[(1)] = (10));

} else {
var statearr_115692_115709 = state_115675__$1;
(statearr_115692_115709[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____0 = (function (){
var statearr_115693 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_115693[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__);

(statearr_115693[(1)] = (1));

return statearr_115693;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____1 = (function (state_115675){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115694){if((e115694 instanceof Object)){
var ex__99978__auto__ = e115694;
var statearr_115695_115710 = state_115675;
(statearr_115695_115710[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115675);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115694;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__115711 = state_115675;
state_115675 = G__115711;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__ = function(state_115675){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____1.call(this,state_115675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115696 = f__100070__auto__.call(null);
(statearr_115696[(6)] = c__100069__auto__);

return statearr_115696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__100069__auto___115879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115823){
var state_val_115824 = (state_115823[(1)]);
if((state_val_115824 === (7))){
var inst_115794 = (state_115823[(7)]);
var inst_115794__$1 = (state_115823[(2)]);
var state_115823__$1 = (function (){var statearr_115825 = state_115823;
(statearr_115825[(7)] = inst_115794__$1);

return statearr_115825;
})();
if(cljs.core.truth_(inst_115794__$1)){
var statearr_115826_115880 = state_115823__$1;
(statearr_115826_115880[(1)] = (28));

} else {
var statearr_115827_115881 = state_115823__$1;
(statearr_115827_115881[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (20))){
var inst_115764 = (state_115823[(8)]);
var inst_115768 = cljs.core.first.call(null,inst_115764);
var state_115823__$1 = state_115823;
var statearr_115828_115882 = state_115823__$1;
(statearr_115828_115882[(2)] = inst_115768);

(statearr_115828_115882[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (27))){
var inst_115788 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115829_115883 = state_115823__$1;
(statearr_115829_115883[(2)] = inst_115788);

(statearr_115829_115883[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (1))){
var state_115823__$1 = state_115823;
var statearr_115830_115884 = state_115823__$1;
(statearr_115830_115884[(2)] = null);

(statearr_115830_115884[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (24))){
var inst_115776 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115831_115885 = state_115823__$1;
(statearr_115831_115885[(2)] = inst_115776);

(statearr_115831_115885[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (39))){
var inst_115815 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115832_115886 = state_115823__$1;
(statearr_115832_115886[(2)] = inst_115815);

(statearr_115832_115886[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115823,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_115722 = typeof ident === 'number';
var state_115823__$1 = state_115823;
if(cljs.core.truth_(inst_115722)){
var statearr_115833_115887 = state_115823__$1;
(statearr_115833_115887[(1)] = (5));

} else {
var statearr_115834_115888 = state_115823__$1;
(statearr_115834_115888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (15))){
var inst_115755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115756 = cljs.core.first.call(null,ident);
var inst_115757 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_115756);
var inst_115758 = cljs.core.second.call(null,ident);
var inst_115759 = [inst_115757,inst_115758];
var inst_115760 = (new cljs.core.PersistentVector(null,2,(5),inst_115755,inst_115759,null));
var inst_115761 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_115760);
var state_115823__$1 = state_115823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115823__$1,(18),inst_115761);
} else {
if((state_val_115824 === (21))){
var inst_115770 = (state_115823[(9)]);
var inst_115770__$1 = (state_115823[(2)]);
var inst_115771 = (inst_115770__$1 == null);
var state_115823__$1 = (function (){var statearr_115835 = state_115823;
(statearr_115835[(9)] = inst_115770__$1);

return statearr_115835;
})();
if(cljs.core.truth_(inst_115771)){
var statearr_115836_115889 = state_115823__$1;
(statearr_115836_115889[(1)] = (22));

} else {
var statearr_115837_115890 = state_115823__$1;
(statearr_115837_115890[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (31))){
var state_115823__$1 = state_115823;
var statearr_115838_115891 = state_115823__$1;
(statearr_115838_115891[(2)] = strict_QMARK_);

(statearr_115838_115891[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (32))){
var state_115823__$1 = state_115823;
var statearr_115839_115892 = state_115823__$1;
(statearr_115839_115892[(2)] = false);

(statearr_115839_115892[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (33))){
var inst_115802 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
if(cljs.core.truth_(inst_115802)){
var statearr_115840_115893 = state_115823__$1;
(statearr_115840_115893[(1)] = (34));

} else {
var statearr_115841_115894 = state_115823__$1;
(statearr_115841_115894[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (13))){
var inst_115752 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_115823__$1 = state_115823;
if(inst_115752){
var statearr_115842_115895 = state_115823__$1;
(statearr_115842_115895[(1)] = (15));

} else {
var statearr_115843_115896 = state_115823__$1;
(statearr_115843_115896[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (22))){
var state_115823__$1 = state_115823;
var statearr_115844_115897 = state_115823__$1;
(statearr_115844_115897[(2)] = null);

(statearr_115844_115897[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (36))){
var inst_115817 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115845_115898 = state_115823__$1;
(statearr_115845_115898[(2)] = inst_115817);

(statearr_115845_115898[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (29))){
var inst_115794 = (state_115823[(7)]);
var inst_115798 = (inst_115794 == null);
var state_115823__$1 = state_115823;
if(cljs.core.truth_(inst_115798)){
var statearr_115846_115899 = state_115823__$1;
(statearr_115846_115899[(1)] = (31));

} else {
var statearr_115847_115900 = state_115823__$1;
(statearr_115847_115900[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (6))){
var inst_115737 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var inst_115738 = cljs.core.first.call(null,ident);
var inst_115739 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_115738);
var inst_115740 = (inst_115739 == null);
var inst_115741 = ((inst_115737) && (inst_115740));
var state_115823__$1 = state_115823;
if(cljs.core.truth_(inst_115741)){
var statearr_115848_115901 = state_115823__$1;
(statearr_115848_115901[(1)] = (12));

} else {
var statearr_115849_115902 = state_115823__$1;
(statearr_115849_115902[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (28))){
var inst_115794 = (state_115823[(7)]);
var inst_115796 = cljs.core.async.put_BANG_.call(null,return_chan,inst_115794);
var state_115823__$1 = state_115823;
var statearr_115850_115903 = state_115823__$1;
(statearr_115850_115903[(2)] = inst_115796);

(statearr_115850_115903[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (25))){
var inst_115779 = cljs.core.pr_str.call(null,ident);
var inst_115780 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_115779].join('');
var inst_115781 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115782 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_115783 = cljs.core.PersistentHashMap.fromArrays(inst_115781,inst_115782);
var inst_115784 = cljs.core.ex_info.call(null,inst_115780,inst_115783);
var inst_115785 = (function(){throw inst_115784})();
var state_115823__$1 = state_115823;
var statearr_115851_115904 = state_115823__$1;
(statearr_115851_115904[(2)] = inst_115785);

(statearr_115851_115904[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (34))){
var inst_115804 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_115805 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115806 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_115807 = cljs.core.PersistentHashMap.fromArrays(inst_115805,inst_115806);
var inst_115808 = cljs.core.ex_info.call(null,inst_115804,inst_115807);
var inst_115809 = cljs.core.async.put_BANG_.call(null,return_chan,inst_115808);
var state_115823__$1 = state_115823;
var statearr_115852_115905 = state_115823__$1;
(statearr_115852_115905[(2)] = inst_115809);

(statearr_115852_115905[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (17))){
var inst_115790 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115853_115906 = state_115823__$1;
(statearr_115853_115906[(2)] = inst_115790);

(statearr_115853_115906[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (3))){
var inst_115712 = (state_115823[(2)]);
var inst_115713 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_115714 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115715 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_115716 = cljs.core.PersistentHashMap.fromArrays(inst_115714,inst_115715);
var inst_115717 = cljs.core.ex_info.call(null,inst_115713,inst_115716,inst_115712);
var inst_115718 = cljs.core.async.put_BANG_.call(null,return_chan,inst_115717);
var state_115823__$1 = state_115823;
var statearr_115854_115907 = state_115823__$1;
(statearr_115854_115907[(2)] = inst_115718);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115823__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (12))){
var inst_115743 = cljs.core.first.call(null,ident);
var inst_115744 = cljs.core.pr_str.call(null,inst_115743);
var inst_115745 = ["Subject ID lookup failed. The predicate ",inst_115744," does not exist."].join('');
var inst_115746 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_115747 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_115748 = cljs.core.PersistentHashMap.fromArrays(inst_115746,inst_115747);
var inst_115749 = cljs.core.ex_info.call(null,inst_115745,inst_115748);
var inst_115750 = (function(){throw inst_115749})();
var state_115823__$1 = state_115823;
var statearr_115855_115908 = state_115823__$1;
(statearr_115855_115908[(2)] = inst_115750);

(statearr_115855_115908[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (2))){
var inst_115821 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115823__$1,inst_115821);
} else {
if((state_val_115824 === (23))){
var inst_115770 = (state_115823[(9)]);
var inst_115774 = inst_115770.s;
var state_115823__$1 = state_115823;
var statearr_115856_115909 = state_115823__$1;
(statearr_115856_115909[(2)] = inst_115774);

(statearr_115856_115909[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (35))){
var state_115823__$1 = state_115823;
var statearr_115857_115910 = state_115823__$1;
(statearr_115857_115910[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (19))){
var state_115823__$1 = state_115823;
var statearr_115859_115911 = state_115823__$1;
(statearr_115859_115911[(2)] = null);

(statearr_115859_115911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (11))){
var inst_115735 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115860_115912 = state_115823__$1;
(statearr_115860_115912[(2)] = inst_115735);

(statearr_115860_115912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (9))){
var state_115823__$1 = state_115823;
var statearr_115861_115913 = state_115823__$1;
(statearr_115861_115913[(2)] = ident);

(statearr_115861_115913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (5))){
var inst_115724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115725 = [ident];
var inst_115726 = (new cljs.core.PersistentVector(null,1,(5),inst_115724,inst_115725,null));
var inst_115727 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_115726);
var state_115823__$1 = state_115823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115823__$1,(8),inst_115727);
} else {
if((state_val_115824 === (14))){
var inst_115792 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115862_115914 = state_115823__$1;
(statearr_115862_115914[(2)] = inst_115792);

(statearr_115862_115914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (26))){
var state_115823__$1 = state_115823;
var statearr_115863_115915 = state_115823__$1;
(statearr_115863_115915[(2)] = null);

(statearr_115863_115915[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (16))){
var state_115823__$1 = state_115823;
var statearr_115864_115916 = state_115823__$1;
(statearr_115864_115916[(1)] = (25));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (38))){
var state_115823__$1 = state_115823;
var statearr_115866_115917 = state_115823__$1;
(statearr_115866_115917[(2)] = null);

(statearr_115866_115917[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (30))){
var inst_115819 = (state_115823[(2)]);
var state_115823__$1 = state_115823;
var statearr_115867_115918 = state_115823__$1;
(statearr_115867_115918[(2)] = inst_115819);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115823__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (10))){
var state_115823__$1 = state_115823;
var statearr_115868_115919 = state_115823__$1;
(statearr_115868_115919[(2)] = null);

(statearr_115868_115919[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (18))){
var inst_115764 = (state_115823[(8)]);
var inst_115763 = (state_115823[(2)]);
var inst_115764__$1 = fluree.db.util.async.throw_err.call(null,inst_115763);
var inst_115765 = (inst_115764__$1 == null);
var state_115823__$1 = (function (){var statearr_115869 = state_115823;
(statearr_115869[(8)] = inst_115764__$1);

return statearr_115869;
})();
if(cljs.core.truth_(inst_115765)){
var statearr_115870_115920 = state_115823__$1;
(statearr_115870_115920[(1)] = (19));

} else {
var statearr_115871_115921 = state_115823__$1;
(statearr_115871_115921[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (37))){
var inst_115812 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_115823__$1 = state_115823;
var statearr_115872_115922 = state_115823__$1;
(statearr_115872_115922[(2)] = inst_115812);

(statearr_115872_115922[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115824 === (8))){
var inst_115729 = (state_115823[(2)]);
var inst_115730 = fluree.db.util.async.throw_err.call(null,inst_115729);
var inst_115731 = cljs.core.not_empty.call(null,inst_115730);
var state_115823__$1 = state_115823;
if(cljs.core.truth_(inst_115731)){
var statearr_115873_115923 = state_115823__$1;
(statearr_115873_115923[(1)] = (9));

} else {
var statearr_115874_115924 = state_115823__$1;
(statearr_115874_115924[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__99975__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__99975__auto____0 = (function (){
var statearr_115875 = [null,null,null,null,null,null,null,null,null,null];
(statearr_115875[(0)] = fluree$db$graphdb$subid_$_state_machine__99975__auto__);

(statearr_115875[(1)] = (1));

return statearr_115875;
});
var fluree$db$graphdb$subid_$_state_machine__99975__auto____1 = (function (state_115823){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115876){if((e115876 instanceof Object)){
var ex__99978__auto__ = e115876;
var statearr_115877_115925 = state_115823;
(statearr_115877_115925[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115823);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115876;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__115926 = state_115823;
state_115823 = G__115926;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__99975__auto__ = function(state_115823){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__99975__auto____1.call(this,state_115823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__99975__auto____0;
fluree$db$graphdb$subid_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__99975__auto____1;
return fluree$db$graphdb$subid_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115878 = f__100070__auto__.call(null);
(statearr_115878[(6)] = c__100069__auto___115879);

return statearr_115878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k115928,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__115932 = k115928;
var G__115932__$1 = (((G__115932 instanceof cljs.core.Keyword))?G__115932.fqn:null);
switch (G__115932__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k115928,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__115933){
var vec__115934 = p__115933;
var k__4403__auto__ = cljs.core.nth.call(null,vec__115934,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__115934,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__115927){
var self__ = this;
var G__115927__$1 = this;
return (new cljs.core.RecordIter((0),G__115927__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this115929,other115930){
var self__ = this;
var this115929__$1 = this;
return (((!((other115930 == null)))) && ((this115929__$1.constructor === other115930.constructor)) && (cljs.core._EQ_.call(null,this115929__$1.conn,other115930.conn)) && (cljs.core._EQ_.call(null,this115929__$1.network,other115930.network)) && (cljs.core._EQ_.call(null,this115929__$1.dbid,other115930.dbid)) && (cljs.core._EQ_.call(null,this115929__$1.block,other115930.block)) && (cljs.core._EQ_.call(null,this115929__$1.t,other115930.t)) && (cljs.core._EQ_.call(null,this115929__$1.tt_id,other115930.tt_id)) && (cljs.core._EQ_.call(null,this115929__$1.stats,other115930.stats)) && (cljs.core._EQ_.call(null,this115929__$1.spot,other115930.spot)) && (cljs.core._EQ_.call(null,this115929__$1.psot,other115930.psot)) && (cljs.core._EQ_.call(null,this115929__$1.post,other115930.post)) && (cljs.core._EQ_.call(null,this115929__$1.opst,other115930.opst)) && (cljs.core._EQ_.call(null,this115929__$1.schema,other115930.schema)) && (cljs.core._EQ_.call(null,this115929__$1.settings,other115930.settings)) && (cljs.core._EQ_.call(null,this115929__$1.index_configs,other115930.index_configs)) && (cljs.core._EQ_.call(null,this115929__$1.schema_cache,other115930.schema_cache)) && (cljs.core._EQ_.call(null,this115929__$1.novelty,other115930.novelty)) && (cljs.core._EQ_.call(null,this115929__$1.permissions,other115930.permissions)) && (cljs.core._EQ_.call(null,this115929__$1.fork,other115930.fork)) && (cljs.core._EQ_.call(null,this115929__$1.fork_block,other115930.fork_block)) && (cljs.core._EQ_.call(null,this115929__$1.current_db_fn,other115930.current_db_fn)) && (cljs.core._EQ_.call(null,this115929__$1.__extmap,other115930.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__115927){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__115937 = cljs.core.keyword_identical_QMARK_;
var expr__115938 = k__4388__auto__;
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__115938))){
return (new fluree.db.graphdb.GraphDb(G__115927,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__115927,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__115927,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__115927,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__115927,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__115927,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__115927,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__115927,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__115927,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__115927,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__115927,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__115927,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__115927,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__115927,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__115927,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__115927,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__115927,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__115927,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__115927,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__115937.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__115938))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__115927,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__115927),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__115927){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__115927,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115952){
var state_val_115953 = (state_115952[(1)]);
if((state_val_115953 === (1))){
var state_115952__$1 = state_115952;
var statearr_115954_116170 = state_115952__$1;
(statearr_115954_116170[(2)] = null);

(statearr_115954_116170[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115953 === (2))){
var inst_115950 = (state_115952[(2)]);
var state_115952__$1 = state_115952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115952__$1,inst_115950);
} else {
if((state_val_115953 === (3))){
var inst_115940 = (state_115952[(2)]);
var state_115952__$1 = state_115952;
var statearr_115955_116171 = state_115952__$1;
(statearr_115955_116171[(2)] = inst_115940);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115952__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115953 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115952,(3),Error,null,(2));
var inst_115944 = self__.current_db_fn.call(null);
var state_115952__$1 = state_115952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115952__$1,(5),inst_115944);
} else {
if((state_val_115953 === (5))){
var inst_115946 = (state_115952[(2)]);
var inst_115947 = fluree.db.util.async.throw_err.call(null,inst_115946);
var inst_115948 = cljs.core.assoc.call(null,inst_115947,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var state_115952__$1 = state_115952;
var statearr_115956_116172 = state_115952__$1;
(statearr_115956_116172[(2)] = inst_115948);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115952__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__99975__auto__ = null;
var fluree$db$graphdb$state_machine__99975__auto____0 = (function (){
var statearr_115957 = [null,null,null,null,null,null,null];
(statearr_115957[(0)] = fluree$db$graphdb$state_machine__99975__auto__);

(statearr_115957[(1)] = (1));

return statearr_115957;
});
var fluree$db$graphdb$state_machine__99975__auto____1 = (function (state_115952){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e115958){if((e115958 instanceof Object)){
var ex__99978__auto__ = e115958;
var statearr_115959_116173 = state_115952;
(statearr_115959_116173[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e115958;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116174 = state_115952;
state_115952 = G__116174;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99975__auto__ = function(state_115952){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99975__auto____1.call(this,state_115952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99975__auto____0;
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99975__auto____1;
return fluree$db$graphdb$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_115960 = f__100070__auto__.call(null);
(statearr_115960[(6)] = c__100069__auto__);

return statearr_115960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__115961 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__115961);
} else {
return G__115961;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$3 = (function (this$,query_map,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_115990){
var state_val_115991 = (state_115990[(1)]);
if((state_val_115991 === (7))){
var inst_115974 = (state_115990[(7)]);
var inst_115978 = cljs.core.first.call(null,inst_115974);
var state_115990__$1 = state_115990;
var statearr_115992_116175 = state_115990__$1;
(statearr_115992_116175[(2)] = inst_115978);

(statearr_115992_116175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (1))){
var state_115990__$1 = state_115990;
var statearr_115993_116176 = state_115990__$1;
(statearr_115993_116176[(2)] = null);

(statearr_115993_116176[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_115990,(3),Error,null,(2));
var inst_115967 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_115968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115969 = [tag_id,(30)];
var inst_115970 = (new cljs.core.PersistentVector(null,2,(5),inst_115968,inst_115969,null));
var inst_115971 = fluree.db.query.range.index_range.call(null,inst_115967,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_115970);
var state_115990__$1 = state_115990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_115990__$1,(5),inst_115971);
} else {
if((state_val_115991 === (6))){
var state_115990__$1 = state_115990;
var statearr_115994_116177 = state_115990__$1;
(statearr_115994_116177[(2)] = null);

(statearr_115994_116177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (3))){
var inst_115962 = (state_115990[(2)]);
var state_115990__$1 = state_115990;
var statearr_115995_116178 = state_115990__$1;
(statearr_115995_116178[(2)] = inst_115962);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115990__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (2))){
var inst_115988 = (state_115990[(2)]);
var state_115990__$1 = state_115990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_115990__$1,inst_115988);
} else {
if((state_val_115991 === (11))){
var inst_115986 = (state_115990[(2)]);
var state_115990__$1 = state_115990;
var statearr_115996_116179 = state_115990__$1;
(statearr_115996_116179[(2)] = inst_115986);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115990__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (9))){
var state_115990__$1 = state_115990;
var statearr_115997_116180 = state_115990__$1;
(statearr_115997_116180[(2)] = null);

(statearr_115997_116180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (5))){
var inst_115974 = (state_115990[(7)]);
var inst_115973 = (state_115990[(2)]);
var inst_115974__$1 = fluree.db.util.async.throw_err.call(null,inst_115973);
var inst_115975 = (inst_115974__$1 == null);
var state_115990__$1 = (function (){var statearr_115998 = state_115990;
(statearr_115998[(7)] = inst_115974__$1);

return statearr_115998;
})();
if(cljs.core.truth_(inst_115975)){
var statearr_115999_116181 = state_115990__$1;
(statearr_115999_116181[(1)] = (6));

} else {
var statearr_116000_116182 = state_115990__$1;
(statearr_116000_116182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (10))){
var inst_115980 = (state_115990[(8)]);
var inst_115984 = inst_115980.o;
var state_115990__$1 = state_115990;
var statearr_116001_116183 = state_115990__$1;
(statearr_116001_116183[(2)] = inst_115984);

(statearr_116001_116183[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_115991 === (8))){
var inst_115980 = (state_115990[(8)]);
var inst_115980__$1 = (state_115990[(2)]);
var inst_115981 = (inst_115980__$1 == null);
var state_115990__$1 = (function (){var statearr_116002 = state_115990;
(statearr_116002[(8)] = inst_115980__$1);

return statearr_116002;
})();
if(cljs.core.truth_(inst_115981)){
var statearr_116003_116184 = state_115990__$1;
(statearr_116003_116184[(1)] = (9));

} else {
var statearr_116004_116185 = state_115990__$1;
(statearr_116004_116185[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__99975__auto__ = null;
var fluree$db$graphdb$state_machine__99975__auto____0 = (function (){
var statearr_116005 = [null,null,null,null,null,null,null,null,null];
(statearr_116005[(0)] = fluree$db$graphdb$state_machine__99975__auto__);

(statearr_116005[(1)] = (1));

return statearr_116005;
});
var fluree$db$graphdb$state_machine__99975__auto____1 = (function (state_115990){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_115990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116006){if((e116006 instanceof Object)){
var ex__99978__auto__ = e116006;
var statearr_116007_116186 = state_115990;
(statearr_116007_116186[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_115990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116187 = state_115990;
state_115990 = G__116187;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99975__auto__ = function(state_115990){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99975__auto____1.call(this,state_115990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99975__auto____0;
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99975__auto____1;
return fluree$db$graphdb$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116008 = f__100070__auto__.call(null);
(statearr_116008[(6)] = c__100069__auto__);

return statearr_116008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116041){
var state_val_116042 = (state_116041[(1)]);
if((state_val_116042 === (7))){
var inst_116018 = (state_116041[(2)]);
var inst_116019 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_116041__$1 = (function (){var statearr_116043 = state_116041;
(statearr_116043[(7)] = inst_116018);

return statearr_116043;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116041__$1,(8),inst_116019);
} else {
if((state_val_116042 === (1))){
var state_116041__$1 = state_116041;
var statearr_116044_116188 = state_116041__$1;
(statearr_116044_116188[(2)] = null);

(statearr_116044_116188[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116041,(3),Error,null,(2));
var inst_116013 = typeof pred === 'string';
var state_116041__$1 = state_116041;
if(cljs.core.truth_(inst_116013)){
var statearr_116045_116189 = state_116041__$1;
(statearr_116045_116189[(1)] = (5));

} else {
var statearr_116046_116190 = state_116041__$1;
(statearr_116046_116190[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (15))){
var inst_116022 = (state_116041[(8)]);
var inst_116030 = clojure.string.split.call(null,inst_116022,/:/);
var inst_116031 = cljs.core.second.call(null,inst_116030);
var state_116041__$1 = state_116041;
var statearr_116047_116191 = state_116041__$1;
(statearr_116047_116191[(2)] = inst_116031);

(statearr_116047_116191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (13))){
var state_116041__$1 = state_116041;
var statearr_116048_116192 = state_116041__$1;
(statearr_116048_116192[(2)] = null);

(statearr_116048_116192[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (6))){
var inst_116016 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_116041__$1 = state_116041;
var statearr_116049_116193 = state_116041__$1;
(statearr_116049_116193[(2)] = inst_116016);

(statearr_116049_116193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (17))){
var inst_116034 = (state_116041[(2)]);
var state_116041__$1 = state_116041;
var statearr_116050_116194 = state_116041__$1;
(statearr_116050_116194[(2)] = inst_116034);

(statearr_116050_116194[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (3))){
var inst_116009 = (state_116041[(2)]);
var state_116041__$1 = state_116041;
var statearr_116051_116195 = state_116041__$1;
(statearr_116051_116195[(2)] = inst_116009);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116041__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (12))){
var inst_116022 = (state_116041[(8)]);
var inst_116028 = clojure.string.includes_QMARK_.call(null,inst_116022,":");
var state_116041__$1 = state_116041;
if(inst_116028){
var statearr_116052_116196 = state_116041__$1;
(statearr_116052_116196[(1)] = (15));

} else {
var statearr_116053_116197 = state_116041__$1;
(statearr_116053_116197[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (2))){
var inst_116039 = (state_116041[(2)]);
var state_116041__$1 = state_116041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116041__$1,inst_116039);
} else {
if((state_val_116042 === (11))){
var inst_116026 = (state_116041[(2)]);
var state_116041__$1 = state_116041;
if(cljs.core.truth_(inst_116026)){
var statearr_116054_116198 = state_116041__$1;
(statearr_116054_116198[(1)] = (12));

} else {
var statearr_116055_116199 = state_116041__$1;
(statearr_116055_116199[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (9))){
var inst_116022 = (state_116041[(8)]);
var state_116041__$1 = state_116041;
var statearr_116056_116200 = state_116041__$1;
(statearr_116056_116200[(2)] = inst_116022);

(statearr_116056_116200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (5))){
var state_116041__$1 = state_116041;
var statearr_116057_116201 = state_116041__$1;
(statearr_116057_116201[(2)] = pred);

(statearr_116057_116201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (14))){
var inst_116037 = (state_116041[(2)]);
var state_116041__$1 = state_116041;
var statearr_116058_116202 = state_116041__$1;
(statearr_116058_116202[(2)] = inst_116037);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116041__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (16))){
var inst_116022 = (state_116041[(8)]);
var state_116041__$1 = state_116041;
var statearr_116059_116203 = state_116041__$1;
(statearr_116059_116203[(2)] = inst_116022);

(statearr_116059_116203[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (10))){
var inst_116018 = (state_116041[(7)]);
var state_116041__$1 = state_116041;
var statearr_116060_116204 = state_116041__$1;
(statearr_116060_116204[(2)] = inst_116018);

(statearr_116060_116204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116042 === (8))){
var inst_116018 = (state_116041[(7)]);
var inst_116021 = (state_116041[(2)]);
var inst_116022 = fluree.db.util.async.throw_err.call(null,inst_116021);
var state_116041__$1 = (function (){var statearr_116061 = state_116041;
(statearr_116061[(8)] = inst_116022);

return statearr_116061;
})();
if(cljs.core.truth_(inst_116018)){
var statearr_116062_116205 = state_116041__$1;
(statearr_116062_116205[(1)] = (9));

} else {
var statearr_116063_116206 = state_116041__$1;
(statearr_116063_116206[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__99975__auto__ = null;
var fluree$db$graphdb$state_machine__99975__auto____0 = (function (){
var statearr_116064 = [null,null,null,null,null,null,null,null,null];
(statearr_116064[(0)] = fluree$db$graphdb$state_machine__99975__auto__);

(statearr_116064[(1)] = (1));

return statearr_116064;
});
var fluree$db$graphdb$state_machine__99975__auto____1 = (function (state_116041){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116065){if((e116065 instanceof Object)){
var ex__99978__auto__ = e116065;
var statearr_116066_116207 = state_116041;
(statearr_116066_116207[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116065;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116208 = state_116041;
state_116041 = G__116208;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99975__auto__ = function(state_116041){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99975__auto____1.call(this,state_116041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99975__auto____0;
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99975__auto____1;
return fluree$db$graphdb$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116067 = f__100070__auto__.call(null);
(statearr_116067[(6)] = c__100069__auto__);

return statearr_116067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116096){
var state_val_116097 = (state_116096[(1)]);
if((state_val_116097 === (7))){
var inst_116080 = (state_116096[(7)]);
var inst_116084 = cljs.core.first.call(null,inst_116080);
var state_116096__$1 = state_116096;
var statearr_116098_116209 = state_116096__$1;
(statearr_116098_116209[(2)] = inst_116084);

(statearr_116098_116209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (1))){
var state_116096__$1 = state_116096;
var statearr_116099_116210 = state_116096__$1;
(statearr_116099_116210[(2)] = null);

(statearr_116099_116210[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116096,(3),Error,null,(2));
var inst_116073 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_116074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116075 = [(30),tag_name];
var inst_116076 = (new cljs.core.PersistentVector(null,2,(5),inst_116074,inst_116075,null));
var inst_116077 = fluree.db.query.range.index_range.call(null,inst_116073,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_116076);
var state_116096__$1 = state_116096;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116096__$1,(5),inst_116077);
} else {
if((state_val_116097 === (6))){
var state_116096__$1 = state_116096;
var statearr_116100_116211 = state_116096__$1;
(statearr_116100_116211[(2)] = null);

(statearr_116100_116211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (3))){
var inst_116068 = (state_116096[(2)]);
var state_116096__$1 = state_116096;
var statearr_116101_116212 = state_116096__$1;
(statearr_116101_116212[(2)] = inst_116068);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116096__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (2))){
var inst_116094 = (state_116096[(2)]);
var state_116096__$1 = state_116096;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116096__$1,inst_116094);
} else {
if((state_val_116097 === (11))){
var inst_116092 = (state_116096[(2)]);
var state_116096__$1 = state_116096;
var statearr_116102_116213 = state_116096__$1;
(statearr_116102_116213[(2)] = inst_116092);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116096__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (9))){
var state_116096__$1 = state_116096;
var statearr_116103_116214 = state_116096__$1;
(statearr_116103_116214[(2)] = null);

(statearr_116103_116214[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (5))){
var inst_116080 = (state_116096[(7)]);
var inst_116079 = (state_116096[(2)]);
var inst_116080__$1 = fluree.db.util.async.throw_err.call(null,inst_116079);
var inst_116081 = (inst_116080__$1 == null);
var state_116096__$1 = (function (){var statearr_116104 = state_116096;
(statearr_116104[(7)] = inst_116080__$1);

return statearr_116104;
})();
if(cljs.core.truth_(inst_116081)){
var statearr_116105_116215 = state_116096__$1;
(statearr_116105_116215[(1)] = (6));

} else {
var statearr_116106_116216 = state_116096__$1;
(statearr_116106_116216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (10))){
var inst_116086 = (state_116096[(8)]);
var inst_116090 = inst_116086.s;
var state_116096__$1 = state_116096;
var statearr_116107_116217 = state_116096__$1;
(statearr_116107_116217[(2)] = inst_116090);

(statearr_116107_116217[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116097 === (8))){
var inst_116086 = (state_116096[(8)]);
var inst_116086__$1 = (state_116096[(2)]);
var inst_116087 = (inst_116086__$1 == null);
var state_116096__$1 = (function (){var statearr_116108 = state_116096;
(statearr_116108[(8)] = inst_116086__$1);

return statearr_116108;
})();
if(cljs.core.truth_(inst_116087)){
var statearr_116109_116218 = state_116096__$1;
(statearr_116109_116218[(1)] = (9));

} else {
var statearr_116110_116219 = state_116096__$1;
(statearr_116110_116219[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__99975__auto__ = null;
var fluree$db$graphdb$state_machine__99975__auto____0 = (function (){
var statearr_116111 = [null,null,null,null,null,null,null,null,null];
(statearr_116111[(0)] = fluree$db$graphdb$state_machine__99975__auto__);

(statearr_116111[(1)] = (1));

return statearr_116111;
});
var fluree$db$graphdb$state_machine__99975__auto____1 = (function (state_116096){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116112){if((e116112 instanceof Object)){
var ex__99978__auto__ = e116112;
var statearr_116113_116220 = state_116096;
(statearr_116113_116220[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116221 = state_116096;
state_116096 = G__116221;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99975__auto__ = function(state_116096){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99975__auto____1.call(this,state_116096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99975__auto____0;
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99975__auto____1;
return fluree$db$graphdb$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116114 = f__100070__auto__.call(null);
(statearr_116114[(6)] = c__100069__auto__);

return statearr_116114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116146){
var state_val_116147 = (state_116146[(1)]);
if((state_val_116147 === (7))){
var inst_116142 = (state_116146[(2)]);
var state_116146__$1 = state_116146;
var statearr_116148_116222 = state_116146__$1;
(statearr_116148_116222[(2)] = inst_116142);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116146__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (1))){
var state_116146__$1 = state_116146;
var statearr_116149_116223 = state_116146__$1;
(statearr_116149_116223[(2)] = null);

(statearr_116149_116223[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116146,(3),Error,null,(2));
var inst_116119 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_116146__$1 = state_116146;
if(inst_116119){
var statearr_116150_116224 = state_116146__$1;
(statearr_116150_116224[(1)] = (5));

} else {
var statearr_116151_116225 = state_116146__$1;
(statearr_116151_116225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (15))){
var inst_116136 = (state_116146[(2)]);
var inst_116137 = fluree.db.util.async.throw_err.call(null,inst_116136);
var state_116146__$1 = state_116146;
var statearr_116152_116226 = state_116146__$1;
(statearr_116152_116226[(2)] = inst_116137);

(statearr_116152_116226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (13))){
var state_116146__$1 = state_116146;
var statearr_116153_116227 = state_116146__$1;
(statearr_116153_116227[(2)] = null);

(statearr_116153_116227[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (6))){
var inst_116126 = typeof pred === 'string';
var state_116146__$1 = state_116146;
if(cljs.core.truth_(inst_116126)){
var statearr_116154_116228 = state_116146__$1;
(statearr_116154_116228[(1)] = (9));

} else {
var statearr_116155_116229 = state_116146__$1;
(statearr_116155_116229[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (3))){
var inst_116115 = (state_116146[(2)]);
var state_116146__$1 = state_116146;
var statearr_116156_116230 = state_116146__$1;
(statearr_116156_116230[(2)] = inst_116115);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116146__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (12))){
var inst_116131 = (state_116146[(7)]);
var inst_116133 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116131),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_116134 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_116133);
var state_116146__$1 = state_116146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116146__$1,(15),inst_116134);
} else {
if((state_val_116147 === (2))){
var inst_116144 = (state_116146[(2)]);
var state_116146__$1 = state_116146;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116146__$1,inst_116144);
} else {
if((state_val_116147 === (11))){
var inst_116131 = (state_116146[(7)]);
var inst_116131__$1 = (state_116146[(2)]);
var state_116146__$1 = (function (){var statearr_116157 = state_116146;
(statearr_116157[(7)] = inst_116131__$1);

return statearr_116157;
})();
if(cljs.core.truth_(inst_116131__$1)){
var statearr_116158_116231 = state_116146__$1;
(statearr_116158_116231[(1)] = (12));

} else {
var statearr_116159_116232 = state_116146__$1;
(statearr_116159_116232[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (9))){
var state_116146__$1 = state_116146;
var statearr_116160_116233 = state_116146__$1;
(statearr_116160_116233[(2)] = pred);

(statearr_116160_116233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (5))){
var inst_116121 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_116146__$1 = state_116146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116146__$1,(8),inst_116121);
} else {
if((state_val_116147 === (14))){
var inst_116140 = (state_116146[(2)]);
var state_116146__$1 = state_116146;
var statearr_116161_116234 = state_116146__$1;
(statearr_116161_116234[(2)] = inst_116140);

(statearr_116161_116234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (10))){
var inst_116129 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_116146__$1 = state_116146;
var statearr_116162_116235 = state_116146__$1;
(statearr_116162_116235[(2)] = inst_116129);

(statearr_116162_116235[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116147 === (8))){
var inst_116123 = (state_116146[(2)]);
var inst_116124 = fluree.db.util.async.throw_err.call(null,inst_116123);
var state_116146__$1 = state_116146;
var statearr_116163_116236 = state_116146__$1;
(statearr_116163_116236[(2)] = inst_116124);

(statearr_116163_116236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__99975__auto__ = null;
var fluree$db$graphdb$state_machine__99975__auto____0 = (function (){
var statearr_116164 = [null,null,null,null,null,null,null,null];
(statearr_116164[(0)] = fluree$db$graphdb$state_machine__99975__auto__);

(statearr_116164[(1)] = (1));

return statearr_116164;
});
var fluree$db$graphdb$state_machine__99975__auto____1 = (function (state_116146){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116165){if((e116165 instanceof Object)){
var ex__99978__auto__ = e116165;
var statearr_116166_116237 = state_116146;
(statearr_116166_116237[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116146);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116165;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116238 = state_116146;
state_116146 = G__116238;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__99975__auto__ = function(state_116146){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__99975__auto____1.call(this,state_116146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__99975__auto____0;
fluree$db$graphdb$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__99975__auto____1;
return fluree$db$graphdb$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116167 = f__100070__auto__.call(null);
(statearr_116167[(6)] = c__100069__auto__);

return statearr_116167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__115931){
var extmap__4419__auto__ = (function (){var G__116168 = cljs.core.dissoc.call(null,G__115931,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__115931)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__116168);
} else {
return G__116168;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__115931),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__115931),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
