// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__110273 = arguments.length;
switch (G__110273) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__110276 = arguments.length;
switch (G__110276) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___110319 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110304){
var state_val_110305 = (state_110304[(1)]);
if((state_val_110305 === (1))){
var state_110304__$1 = state_110304;
var statearr_110306_110320 = state_110304__$1;
(statearr_110306_110320[(2)] = null);

(statearr_110306_110320[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110305 === (2))){
var inst_110302 = (state_110304[(2)]);
var state_110304__$1 = state_110304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110304__$1,inst_110302);
} else {
if((state_val_110305 === (3))){
var inst_110277 = (state_110304[(2)]);
var inst_110278 = cljs.core.async.put_BANG_.call(null,pc,inst_110277);
var state_110304__$1 = state_110304;
var statearr_110307_110321 = state_110304__$1;
(statearr_110307_110321[(2)] = inst_110278);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110304__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110305 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_110304,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_110282 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_110304__$1 = state_110304;
if(cljs.core.truth_(inst_110282)){
var statearr_110308_110322 = state_110304__$1;
(statearr_110308_110322[(1)] = (5));

} else {
var statearr_110309_110323 = state_110304__$1;
(statearr_110309_110323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110305 === (5))){
var inst_110284 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_110285 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_110286 = cljs.core.PersistentHashMap.fromArrays(inst_110284,inst_110285);
var inst_110287 = cljs.core.ex_info.call(null,"Connection was closed.",inst_110286);
var inst_110288 = (function(){throw inst_110287})();
var state_110304__$1 = state_110304;
var statearr_110310_110324 = state_110304__$1;
(statearr_110310_110324[(2)] = inst_110288);

(statearr_110310_110324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110305 === (6))){
var inst_110290 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_110291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110292 = [operation,data,pc,opts];
var inst_110293 = (new cljs.core.PersistentVector(null,4,(5),inst_110291,inst_110292,null));
var inst_110294 = cljs.core.async.put_BANG_.call(null,inst_110290,inst_110293);
var inst_110295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_110296 = [operation,data,pc,opts];
var inst_110297 = (new cljs.core.PersistentVector(null,4,(5),inst_110295,inst_110296,null));
var inst_110298 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_110297);
var state_110304__$1 = (function (){var statearr_110311 = state_110304;
(statearr_110311[(7)] = inst_110294);

return statearr_110311;
})();
var statearr_110312_110325 = state_110304__$1;
(statearr_110312_110325[(2)] = inst_110298);

(statearr_110312_110325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110305 === (7))){
var inst_110300 = (state_110304[(2)]);
var state_110304__$1 = state_110304;
var statearr_110313_110326 = state_110304__$1;
(statearr_110313_110326[(2)] = inst_110300);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110304__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__99975__auto__ = null;
var fluree$db$operations$state_machine__99975__auto____0 = (function (){
var statearr_110314 = [null,null,null,null,null,null,null,null];
(statearr_110314[(0)] = fluree$db$operations$state_machine__99975__auto__);

(statearr_110314[(1)] = (1));

return statearr_110314;
});
var fluree$db$operations$state_machine__99975__auto____1 = (function (state_110304){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110315){if((e110315 instanceof Object)){
var ex__99978__auto__ = e110315;
var statearr_110316_110327 = state_110304;
(statearr_110316_110327[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110304);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110315;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110328 = state_110304;
state_110304 = G__110328;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99975__auto__ = function(state_110304){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99975__auto____1.call(this,state_110304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99975__auto____0;
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99975__auto____1;
return fluree$db$operations$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110317 = f__100070__auto__.call(null);
(statearr_110317[(6)] = c__100069__auto___110319);

return statearr_110317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__110330 = arguments.length;
switch (G__110330) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__110331){
var map__110332 = p__110331;
var map__110332__$1 = (((((!((map__110332 == null))))?(((((map__110332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__110332):map__110332);
var opts = map__110332__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__110332__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__110334 = session;
var map__110334__$1 = (((((!((map__110334 == null))))?(((((map__110334.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110334.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__110334):map__110334);
var dbid = cljs.core.get.call(null,map__110334__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__110334__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__110334__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___110393 = arguments.length;
var i__4737__auto___110394 = (0);
while(true){
if((i__4737__auto___110394 < len__4736__auto___110393)){
args__4742__auto__.push((arguments[i__4737__auto___110394]));

var G__110395 = (i__4737__auto___110394 + (1));
i__4737__auto___110394 = G__110395;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__110339){
var vec__110340 = p__110339;
var map__110343 = cljs.core.nth.call(null,vec__110340,(0),null);
var map__110343__$1 = (((((!((map__110343 == null))))?(((((map__110343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110343.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__110343):map__110343);
var toBlock = cljs.core.get.call(null,map__110343__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__110343__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__110340;
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_110375){
var state_val_110376 = (state_110375[(1)]);
if((state_val_110376 === (7))){
var inst_110358 = (state_110375[(2)]);
var state_110375__$1 = state_110375;
var statearr_110377_110396 = state_110375__$1;
(statearr_110377_110396[(2)] = inst_110358);

(statearr_110377_110396[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (1))){
var inst_110347 = (session == null);
var inst_110348 = cljs.core.not.call(null,inst_110347);
var state_110375__$1 = state_110375;
if(inst_110348){
var statearr_110378_110397 = state_110375__$1;
(statearr_110378_110397[(1)] = (2));

} else {
var statearr_110379_110398 = state_110375__$1;
(statearr_110379_110398[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (4))){
var inst_110361 = (state_110375[(2)]);
var state_110375__$1 = state_110375;
if(cljs.core.truth_(inst_110361)){
var statearr_110380_110399 = state_110375__$1;
(statearr_110380_110399[(1)] = (8));

} else {
var statearr_110381_110400 = state_110375__$1;
(statearr_110381_110400[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (6))){
var state_110375__$1 = state_110375;
var statearr_110382_110401 = state_110375__$1;
(statearr_110382_110401[(2)] = false);

(statearr_110382_110401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (3))){
var state_110375__$1 = state_110375;
var statearr_110383_110402 = state_110375__$1;
(statearr_110383_110402[(2)] = false);

(statearr_110383_110402[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (2))){
var inst_110350 = session.cljs$lang$protocol_mask$partition0$;
var inst_110351 = (inst_110350 & (64));
var inst_110352 = session.cljs$core$ISeq$;
var inst_110353 = (cljs.core.PROTOCOL_SENTINEL === inst_110352);
var inst_110354 = ((inst_110351) || (inst_110353));
var state_110375__$1 = state_110375;
if(cljs.core.truth_(inst_110354)){
var statearr_110384_110403 = state_110375__$1;
(statearr_110384_110403[(1)] = (5));

} else {
var statearr_110385_110404 = state_110375__$1;
(statearr_110385_110404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (9))){
var state_110375__$1 = state_110375;
var statearr_110386_110405 = state_110375__$1;
(statearr_110386_110405[(2)] = session);

(statearr_110386_110405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (5))){
var state_110375__$1 = state_110375;
var statearr_110387_110406 = state_110375__$1;
(statearr_110387_110406[(2)] = true);

(statearr_110387_110406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_110376 === (10))){
var inst_110366 = (state_110375[(2)]);
var inst_110367 = cljs.core.get.call(null,inst_110366,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_110368 = cljs.core.get.call(null,inst_110366,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_110369 = cljs.core.get.call(null,inst_110366,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_110370 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_110371 = [inst_110367,inst_110368,toBlock,toTime];
var inst_110372 = cljs.core.PersistentHashMap.fromArrays(inst_110370,inst_110371);
var inst_110373 = fluree.db.operations.send_operation.call(null,inst_110369,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_110372);
var state_110375__$1 = state_110375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_110375__$1,inst_110373);
} else {
if((state_val_110376 === (8))){
var inst_110363 = cljs.core.apply.call(null,cljs.core.hash_map,session);
var state_110375__$1 = state_110375;
var statearr_110388_110407 = state_110375__$1;
(statearr_110388_110407[(2)] = inst_110363);

(statearr_110388_110407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__99975__auto__ = null;
var fluree$db$operations$state_machine__99975__auto____0 = (function (){
var statearr_110389 = [null,null,null,null,null,null,null];
(statearr_110389[(0)] = fluree$db$operations$state_machine__99975__auto__);

(statearr_110389[(1)] = (1));

return statearr_110389;
});
var fluree$db$operations$state_machine__99975__auto____1 = (function (state_110375){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_110375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e110390){if((e110390 instanceof Object)){
var ex__99978__auto__ = e110390;
var statearr_110391_110408 = state_110375;
(statearr_110391_110408[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_110375);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e110390;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__110409 = state_110375;
state_110375 = G__110409;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$operations$state_machine__99975__auto__ = function(state_110375){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__99975__auto____1.call(this,state_110375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__99975__auto____0;
fluree$db$operations$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__99975__auto____1;
return fluree$db$operations$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_110392 = f__100070__auto__.call(null);
(statearr_110392[(6)] = c__100069__auto__);

return statearr_110392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq110337){
var G__110338 = cljs.core.first.call(null,seq110337);
var seq110337__$1 = cljs.core.next.call(null,seq110337);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__110338,seq110337__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__110410 = session;
var map__110410__$1 = (((((!((map__110410 == null))))?(((((map__110410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110410.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__110410):map__110410);
var network = cljs.core.get.call(null,map__110410__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__110410__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__110410__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__110413 = arguments.length;
switch (G__110413) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__110414 = opts;
var map__110414__$1 = (((((!((map__110414 == null))))?(((((map__110414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__110414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__110414):map__110414);
var auth = cljs.core.get.call(null,map__110414__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__110414__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
