// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k116426,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__116430 = k116426;
var G__116430__$1 = (((G__116430 instanceof cljs.core.Keyword))?G__116430.fqn:null);
switch (G__116430__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k116426,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__116431){
var vec__116432 = p__116431;
var k__4403__auto__ = cljs.core.nth.call(null,vec__116432,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__116432,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__116425){
var self__ = this;
var G__116425__$1 = this;
return (new cljs.core.RecordIter((0),G__116425__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this116427,other116428){
var self__ = this;
var this116427__$1 = this;
return (((!((other116428 == null)))) && ((this116427__$1.constructor === other116428.constructor)) && (cljs.core._EQ_.call(null,this116427__$1.conn,other116428.conn)) && (cljs.core._EQ_.call(null,this116427__$1.network,other116428.network)) && (cljs.core._EQ_.call(null,this116427__$1.dbid,other116428.dbid)) && (cljs.core._EQ_.call(null,this116427__$1.db_name,other116428.db_name)) && (cljs.core._EQ_.call(null,this116427__$1.update_chan,other116428.update_chan)) && (cljs.core._EQ_.call(null,this116427__$1.transact_chan,other116428.transact_chan)) && (cljs.core._EQ_.call(null,this116427__$1.state,other116428.state)) && (cljs.core._EQ_.call(null,this116427__$1.schema_cache,other116428.schema_cache)) && (cljs.core._EQ_.call(null,this116427__$1.blank_db,other116428.blank_db)) && (cljs.core._EQ_.call(null,this116427__$1.close,other116428.close)) && (cljs.core._EQ_.call(null,this116427__$1.id,other116428.id)) && (cljs.core._EQ_.call(null,this116427__$1.__extmap,other116428.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__116425){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__116435 = cljs.core.keyword_identical_QMARK_;
var expr__116436 = k__4388__auto__;
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__116436))){
return (new fluree.db.session.DbSession(G__116425,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,G__116425,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__116425,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__116425,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__116425,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__116425,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__116425,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__116425,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__116425,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__116425,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__116435.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__116436))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__116425,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__116425),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__116425){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__116425,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__116429){
var extmap__4419__auto__ = (function (){var G__116438 = cljs.core.dissoc.call(null,G__116429,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__116429)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__116438);
} else {
return G__116438;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__116429),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__116429),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__116440 = session;
var map__116440__$1 = (((((!((map__116440 == null))))?(((((map__116440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116440):map__116440);
var network = cljs.core.get.call(null,map__116440__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__116440__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__100069__auto___116647 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116581){
var state_val_116582 = (state_116581[(1)]);
if((state_val_116582 === (7))){
var inst_116464 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
if(cljs.core.truth_(inst_116464)){
var statearr_116583_116648 = state_116581__$1;
(statearr_116583_116648[(1)] = (11));

} else {
var statearr_116584_116649 = state_116581__$1;
(statearr_116584_116649[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (20))){
var inst_116491 = (state_116581[(2)]);
var inst_116492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_116493 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_116494 = cljs.core.PersistentHashMap.fromArrays(inst_116492,inst_116493);
var inst_116495 = cljs.core.ex_info.call(null,inst_116491,inst_116494);
var inst_116496 = (function(){throw inst_116495})();
var state_116581__$1 = state_116581;
var statearr_116585_116650 = state_116581__$1;
(statearr_116585_116650[(2)] = inst_116496);

(statearr_116585_116650[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (27))){
var inst_116509 = (state_116581[(7)]);
var state_116581__$1 = state_116581;
var statearr_116586_116651 = state_116581__$1;
(statearr_116586_116651[(2)] = inst_116509);

(statearr_116586_116651[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (1))){
var state_116581__$1 = state_116581;
var statearr_116587_116652 = state_116581__$1;
(statearr_116587_116652[(2)] = null);

(statearr_116587_116652[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (24))){
var inst_116566 = (state_116581[(8)]);
var inst_116566__$1 = (state_116581[(2)]);
var inst_116567 = fluree.db.query.schema.schema_map.call(null,inst_116566__$1);
var state_116581__$1 = (function (){var statearr_116588 = state_116581;
(statearr_116588[(8)] = inst_116566__$1);

return statearr_116588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(44),inst_116567);
} else {
if((state_val_116582 === (39))){
var inst_116533 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
var statearr_116589_116653 = state_116581__$1;
(statearr_116589_116653[(2)] = inst_116533);

(statearr_116589_116653[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116581,(3),new cljs.core.Keyword(null,"default","default",-1987822328),null,(2));
var inst_116448 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_116450 = (session == null);
var inst_116451 = cljs.core.not.call(null,inst_116450);
var state_116581__$1 = (function (){var statearr_116590 = state_116581;
(statearr_116590[(9)] = inst_116448);

return statearr_116590;
})();
if(inst_116451){
var statearr_116591_116654 = state_116581__$1;
(statearr_116591_116654[(1)] = (5));

} else {
var statearr_116592_116655 = state_116581__$1;
(statearr_116592_116655[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (15))){
var inst_116479 = (state_116581[(10)]);
var inst_116484 = cljs.core.empty_QMARK_.call(null,inst_116479);
var state_116581__$1 = state_116581;
if(inst_116484){
var statearr_116593_116656 = state_116581__$1;
(statearr_116593_116656[(1)] = (18));

} else {
var statearr_116594_116657 = state_116581__$1;
(statearr_116594_116657[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (21))){
var inst_116504 = (state_116581[(11)]);
var inst_116479 = (state_116581[(10)]);
var inst_116503 = (state_116581[(2)]);
var inst_116504__$1 = fluree.db.util.async.throw_err.call(null,inst_116503);
var inst_116505 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_116479);
var state_116581__$1 = (function (){var statearr_116595 = state_116581;
(statearr_116595[(12)] = inst_116505);

(statearr_116595[(11)] = inst_116504__$1);

return statearr_116595;
})();
if(cljs.core.truth_(inst_116504__$1)){
var statearr_116596_116658 = state_116581__$1;
(statearr_116596_116658[(1)] = (22));

} else {
var statearr_116597_116659 = state_116581__$1;
(statearr_116597_116659[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (31))){
var inst_116518 = (state_116581[(13)]);
var inst_116522 = (inst_116518 == null);
var inst_116523 = cljs.core.not.call(null,inst_116522);
var state_116581__$1 = state_116581;
if(inst_116523){
var statearr_116598_116660 = state_116581__$1;
(statearr_116598_116660[(1)] = (34));

} else {
var statearr_116599_116661 = state_116581__$1;
(statearr_116599_116661[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (32))){
var inst_116471 = (state_116581[(14)]);
var inst_116510 = (state_116581[(15)]);
var inst_116472 = (state_116581[(16)]);
var inst_116552 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116510)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116471),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116472),"."].join('');
var inst_116553 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_116554 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_116555 = cljs.core.PersistentHashMap.fromArrays(inst_116553,inst_116554);
var inst_116556 = cljs.core.ex_info.call(null,inst_116552,inst_116555);
var inst_116557 = (function(){throw inst_116556})();
var state_116581__$1 = state_116581;
var statearr_116600_116662 = state_116581__$1;
(statearr_116600_116662[(2)] = inst_116557);

(statearr_116600_116662[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (40))){
var inst_116518 = (state_116581[(13)]);
var inst_116538 = cljs.core.apply.call(null,cljs.core.hash_map,inst_116518);
var state_116581__$1 = state_116581;
var statearr_116601_116663 = state_116581__$1;
(statearr_116601_116663[(2)] = inst_116538);

(statearr_116601_116663[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (33))){
var inst_116559 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
var statearr_116602_116664 = state_116581__$1;
(statearr_116602_116664[(2)] = inst_116559);

(statearr_116602_116664[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (13))){
var inst_116471 = (state_116581[(14)]);
var inst_116470 = (state_116581[(17)]);
var inst_116472 = (state_116581[(16)]);
var inst_116469 = (state_116581[(2)]);
var inst_116470__$1 = cljs.core.get.call(null,inst_116469,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_116471__$1 = cljs.core.get.call(null,inst_116469,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_116472__$1 = cljs.core.get.call(null,inst_116469,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_116473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116474 = [inst_116471__$1,inst_116472__$1];
var inst_116475 = (new cljs.core.PersistentVector(null,2,(5),inst_116473,inst_116474,null));
var inst_116476 = fluree.db.operations.ledger_info_async.call(null,inst_116470__$1,inst_116475);
var state_116581__$1 = (function (){var statearr_116603 = state_116581;
(statearr_116603[(14)] = inst_116471__$1);

(statearr_116603[(17)] = inst_116470__$1);

(statearr_116603[(16)] = inst_116472__$1);

return statearr_116603;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(14),inst_116476);
} else {
if((state_val_116582 === (22))){
var inst_116504 = (state_116581[(11)]);
var inst_116507 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_116504);
var inst_116508 = (inst_116507 + (1));
var inst_116509 = inst_116504;
var inst_116510 = inst_116508;
var state_116581__$1 = (function (){var statearr_116604 = state_116581;
(statearr_116604[(15)] = inst_116510);

(statearr_116604[(7)] = inst_116509);

return statearr_116604;
})();
var statearr_116605_116665 = state_116581__$1;
(statearr_116605_116665[(2)] = null);

(statearr_116605_116665[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (36))){
var inst_116536 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
if(cljs.core.truth_(inst_116536)){
var statearr_116606_116666 = state_116581__$1;
(statearr_116606_116666[(1)] = (40));

} else {
var statearr_116607_116667 = state_116581__$1;
(statearr_116607_116667[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (41))){
var inst_116518 = (state_116581[(13)]);
var state_116581__$1 = state_116581;
var statearr_116608_116668 = state_116581__$1;
(statearr_116608_116668[(2)] = inst_116518);

(statearr_116608_116668[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (43))){
var inst_116510 = (state_116581[(15)]);
var inst_116547 = (state_116581[(2)]);
var inst_116548 = fluree.db.util.async.throw_err.call(null,inst_116547);
var inst_116549 = (inst_116510 + (1));
var inst_116509 = inst_116548;
var inst_116510__$1 = inst_116549;
var state_116581__$1 = (function (){var statearr_116609 = state_116581;
(statearr_116609[(15)] = inst_116510__$1);

(statearr_116609[(7)] = inst_116509);

return statearr_116609;
})();
var statearr_116610_116669 = state_116581__$1;
(statearr_116610_116669[(2)] = null);

(statearr_116610_116669[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (29))){
var inst_116561 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
var statearr_116611_116670 = state_116581__$1;
(statearr_116611_116670[(2)] = inst_116561);

(statearr_116611_116670[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (44))){
var inst_116571 = (state_116581[(18)]);
var inst_116566 = (state_116581[(8)]);
var inst_116569 = (state_116581[(2)]);
var inst_116570 = fluree.db.util.async.throw_err.call(null,inst_116569);
var inst_116571__$1 = cljs.core.assoc.call(null,inst_116566,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_116570);
var inst_116572 = fluree.db.query.schema.setting_map.call(null,inst_116571__$1);
var state_116581__$1 = (function (){var statearr_116612 = state_116581;
(statearr_116612[(18)] = inst_116571__$1);

return statearr_116612;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(45),inst_116572);
} else {
if((state_val_116582 === (6))){
var state_116581__$1 = state_116581;
var statearr_116613_116671 = state_116581__$1;
(statearr_116613_116671[(2)] = false);

(statearr_116613_116671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (28))){
var inst_116471 = (state_116581[(14)]);
var inst_116510 = (state_116581[(15)]);
var inst_116470 = (state_116581[(17)]);
var inst_116472 = (state_116581[(16)]);
var inst_116515 = fluree.db.storage.core.read_block.call(null,inst_116470,inst_116471,inst_116472,inst_116510);
var state_116581__$1 = state_116581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(30),inst_116515);
} else {
if((state_val_116582 === (25))){
var inst_116505 = (state_116581[(12)]);
var inst_116510 = (state_116581[(15)]);
var inst_116512 = (inst_116510 > inst_116505);
var state_116581__$1 = state_116581;
if(cljs.core.truth_(inst_116512)){
var statearr_116614_116672 = state_116581__$1;
(statearr_116614_116672[(1)] = (27));

} else {
var statearr_116615_116673 = state_116581__$1;
(statearr_116615_116673[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (34))){
var inst_116518 = (state_116581[(13)]);
var inst_116525 = inst_116518.cljs$lang$protocol_mask$partition0$;
var inst_116526 = (inst_116525 & (64));
var inst_116527 = inst_116518.cljs$core$ISeq$;
var inst_116528 = (cljs.core.PROTOCOL_SENTINEL === inst_116527);
var inst_116529 = ((inst_116526) || (inst_116528));
var state_116581__$1 = state_116581;
if(cljs.core.truth_(inst_116529)){
var statearr_116616_116674 = state_116581__$1;
(statearr_116616_116674[(1)] = (37));

} else {
var statearr_116617_116675 = state_116581__$1;
(statearr_116617_116675[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (17))){
var inst_116448 = (state_116581[(9)]);
var inst_116471 = (state_116581[(14)]);
var inst_116470 = (state_116581[(17)]);
var inst_116472 = (state_116581[(16)]);
var inst_116479 = (state_116581[(10)]);
var inst_116499 = (state_116581[(2)]);
var inst_116500 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_116479);
var inst_116501 = fluree.db.storage.core.reify_db.call(null,inst_116470,inst_116471,inst_116472,inst_116448,inst_116500);
var state_116581__$1 = (function (){var statearr_116618 = state_116581;
(statearr_116618[(19)] = inst_116499);

return statearr_116618;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(21),inst_116501);
} else {
if((state_val_116582 === (3))){
var inst_116442 = (state_116581[(2)]);
var inst_116443 = cljs.core.async.put_BANG_.call(null,pc,inst_116442);
var state_116581__$1 = state_116581;
var statearr_116619_116676 = state_116581__$1;
(statearr_116619_116676[(2)] = inst_116443);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116581__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (12))){
var state_116581__$1 = state_116581;
var statearr_116620_116677 = state_116581__$1;
(statearr_116620_116677[(2)] = session);

(statearr_116620_116677[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (2))){
var inst_116579 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116581__$1,inst_116579);
} else {
if((state_val_116582 === (23))){
var state_116581__$1 = state_116581;
var statearr_116621_116678 = state_116581__$1;
(statearr_116621_116678[(2)] = null);

(statearr_116621_116678[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (35))){
var state_116581__$1 = state_116581;
var statearr_116622_116679 = state_116581__$1;
(statearr_116622_116679[(2)] = false);

(statearr_116622_116679[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (19))){
var inst_116471 = (state_116581[(14)]);
var inst_116472 = (state_116581[(16)]);
var inst_116479 = (state_116581[(10)]);
var inst_116488 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_116479);
var inst_116489 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116471),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116472)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116488),"."].join('');
var state_116581__$1 = state_116581;
var statearr_116623_116680 = state_116581__$1;
(statearr_116623_116680[(2)] = inst_116489);

(statearr_116623_116680[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (11))){
var inst_116466 = cljs.core.apply.call(null,cljs.core.hash_map,session);
var state_116581__$1 = state_116581;
var statearr_116624_116681 = state_116581__$1;
(statearr_116624_116681[(2)] = inst_116466);

(statearr_116624_116681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (9))){
var state_116581__$1 = state_116581;
var statearr_116625_116682 = state_116581__$1;
(statearr_116625_116682[(2)] = false);

(statearr_116625_116682[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (5))){
var inst_116453 = session.cljs$lang$protocol_mask$partition0$;
var inst_116454 = (inst_116453 & (64));
var inst_116455 = session.cljs$core$ISeq$;
var inst_116456 = (cljs.core.PROTOCOL_SENTINEL === inst_116455);
var inst_116457 = ((inst_116454) || (inst_116456));
var state_116581__$1 = state_116581;
if(cljs.core.truth_(inst_116457)){
var statearr_116626_116683 = state_116581__$1;
(statearr_116626_116683[(1)] = (8));

} else {
var statearr_116627_116684 = state_116581__$1;
(statearr_116627_116684[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (14))){
var inst_116479 = (state_116581[(10)]);
var inst_116478 = (state_116581[(2)]);
var inst_116479__$1 = fluree.db.util.async.throw_err.call(null,inst_116478);
var inst_116480 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_116479__$1);
var inst_116481 = cljs.core.keyword.call(null,inst_116480);
var inst_116482 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_116481);
var state_116581__$1 = (function (){var statearr_116628 = state_116581;
(statearr_116628[(10)] = inst_116479__$1);

return statearr_116628;
})();
if(inst_116482){
var statearr_116629_116685 = state_116581__$1;
(statearr_116629_116685[(1)] = (15));

} else {
var statearr_116630_116686 = state_116581__$1;
(statearr_116630_116686[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (45))){
var inst_116571 = (state_116581[(18)]);
var inst_116574 = (state_116581[(2)]);
var inst_116575 = fluree.db.util.async.throw_err.call(null,inst_116574);
var inst_116576 = cljs.core.assoc.call(null,inst_116571,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_116575);
var inst_116577 = cljs.core.async.put_BANG_.call(null,pc,inst_116576);
var state_116581__$1 = state_116581;
var statearr_116631_116687 = state_116581__$1;
(statearr_116631_116687[(2)] = inst_116577);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116581__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (26))){
var inst_116563 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
var statearr_116632_116688 = state_116581__$1;
(statearr_116632_116688[(2)] = inst_116563);

(statearr_116632_116688[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (16))){
var state_116581__$1 = state_116581;
var statearr_116633_116689 = state_116581__$1;
(statearr_116633_116689[(2)] = null);

(statearr_116633_116689[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (38))){
var state_116581__$1 = state_116581;
var statearr_116634_116690 = state_116581__$1;
(statearr_116634_116690[(2)] = false);

(statearr_116634_116690[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (30))){
var inst_116518 = (state_116581[(13)]);
var inst_116517 = (state_116581[(2)]);
var inst_116518__$1 = fluree.db.util.async.throw_err.call(null,inst_116517);
var state_116581__$1 = (function (){var statearr_116635 = state_116581;
(statearr_116635[(13)] = inst_116518__$1);

return statearr_116635;
})();
if(cljs.core.truth_(inst_116518__$1)){
var statearr_116636_116691 = state_116581__$1;
(statearr_116636_116691[(1)] = (31));

} else {
var statearr_116637_116692 = state_116581__$1;
(statearr_116637_116692[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (10))){
var inst_116461 = (state_116581[(2)]);
var state_116581__$1 = state_116581;
var statearr_116638_116693 = state_116581__$1;
(statearr_116638_116693[(2)] = inst_116461);

(statearr_116638_116693[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (18))){
var inst_116471 = (state_116581[(14)]);
var inst_116472 = (state_116581[(16)]);
var inst_116486 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116471),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116472)," is not found on this ledger group."].join('');
var state_116581__$1 = state_116581;
var statearr_116639_116694 = state_116581__$1;
(statearr_116639_116694[(2)] = inst_116486);

(statearr_116639_116694[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (42))){
var inst_116509 = (state_116581[(7)]);
var inst_116541 = (state_116581[(2)]);
var inst_116542 = cljs.core.get.call(null,inst_116541,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_116543 = cljs.core.get.call(null,inst_116541,new cljs.core.Keyword(null,"block","block",664686210));
var inst_116544 = cljs.core.get.call(null,inst_116541,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_116545 = fluree.db.dbproto._with.call(null,inst_116509,inst_116543,inst_116542);
var state_116581__$1 = (function (){var statearr_116640 = state_116581;
(statearr_116640[(20)] = inst_116544);

return statearr_116640;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116581__$1,(43),inst_116545);
} else {
if((state_val_116582 === (37))){
var state_116581__$1 = state_116581;
var statearr_116641_116695 = state_116581__$1;
(statearr_116641_116695[(2)] = true);

(statearr_116641_116695[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116582 === (8))){
var state_116581__$1 = state_116581;
var statearr_116642_116696 = state_116581__$1;
(statearr_116642_116696[(2)] = true);

(statearr_116642_116696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____0 = (function (){
var statearr_116643 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116643[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__);

(statearr_116643[(1)] = (1));

return statearr_116643;
});
var fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____1 = (function (state_116581){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116644){if((e116644 instanceof Object)){
var ex__99978__auto__ = e116644;
var statearr_116645_116697 = state_116581;
(statearr_116645_116697[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116644;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116698 = state_116581;
state_116581 = G__116698;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__ = function(state_116581){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____1.call(this,state_116581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__99975__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116646 = f__100070__auto__.call(null);
(statearr_116646[(6)] = c__100069__auto___116647);

return statearr_116646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__116699 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__116699,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__116699;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__116701){
var map__116702 = p__116701;
var map__116702__$1 = (((((!((map__116702 == null))))?(((((map__116702.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116702.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116702):map__116702);
var data = map__116702__$1;
var block = cljs.core.get.call(null,map__116702__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__116702__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__116702__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116748){
var state_val_116749 = (state_116748[(1)]);
if((state_val_116749 === (7))){
var inst_116712 = (state_116748[(7)]);
var inst_116720 = ((1) + inst_116712);
var inst_116721 = cljs.core._EQ_.call(null,block,inst_116720);
var state_116748__$1 = state_116748;
if(inst_116721){
var statearr_116750_116773 = state_116748__$1;
(statearr_116750_116773[(1)] = (9));

} else {
var statearr_116751_116774 = state_116748__$1;
(statearr_116751_116774[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (1))){
var state_116748__$1 = state_116748;
var statearr_116752_116775 = state_116748__$1;
(statearr_116752_116775[(2)] = null);

(statearr_116752_116775[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (4))){
var inst_116708 = (state_116748[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116748,(3),Error,null,(2));
var inst_116708__$1 = fluree.db.session.current_db.call(null,session);
var state_116748__$1 = (function (){var statearr_116753 = state_116748;
(statearr_116753[(8)] = inst_116708__$1);

return statearr_116753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116748__$1,(5),inst_116708__$1);
} else {
if((state_val_116749 === (13))){
var state_116748__$1 = state_116748;
var statearr_116754_116776 = state_116748__$1;
(statearr_116754_116776[(2)] = null);

(statearr_116754_116776[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (6))){
var inst_116715 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_116716 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_116717 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116715),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116716),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_116718 = fluree.db.util.log.info.call(null,inst_116717);
var state_116748__$1 = state_116748;
var statearr_116755_116777 = state_116748__$1;
(statearr_116755_116777[(2)] = inst_116718);

(statearr_116755_116777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (3))){
var inst_116704 = (state_116748[(2)]);
var state_116748__$1 = state_116748;
var statearr_116756_116778 = state_116748__$1;
(statearr_116756_116778[(2)] = inst_116704);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116748__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (12))){
var inst_116712 = (state_116748[(7)]);
var inst_116733 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_116734 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_116735 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116733),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116734),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116712),". Forcing a db reload."].join('');
var inst_116736 = fluree.db.util.log.info.call(null,inst_116735);
var inst_116737 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_116748__$1 = (function (){var statearr_116757 = state_116748;
(statearr_116757[(9)] = inst_116736);

return statearr_116757;
})();
var statearr_116758_116779 = state_116748__$1;
(statearr_116758_116779[(2)] = inst_116737);

(statearr_116758_116779[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (2))){
var inst_116746 = (state_116748[(2)]);
var state_116748__$1 = state_116748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116748__$1,inst_116746);
} else {
if((state_val_116749 === (11))){
var inst_116742 = (state_116748[(2)]);
var state_116748__$1 = state_116748;
var statearr_116759_116780 = state_116748__$1;
(statearr_116759_116780[(2)] = inst_116742);

(statearr_116759_116780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (9))){
var inst_116712 = (state_116748[(7)]);
var inst_116708 = (state_116748[(8)]);
var inst_116711 = (state_116748[(10)]);
var inst_116723 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_116724 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_116725 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116723),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116724),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_116726 = fluree.db.util.log.trace.call(null,inst_116725);
var inst_116727 = (function (){var current_db_ch = inst_116708;
var current_db = inst_116711;
var current_block = inst_116712;
return (function (p1__116700_SHARP_){
if((p1__116700_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__116700_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__116700_SHARP_);
}
});
})();
var inst_116728 = cljs.core.map.call(null,inst_116727,flakes);
var inst_116729 = fluree.db.dbproto._with.call(null,inst_116711,block,inst_116728);
var inst_116730 = fluree.db.session.cas_db_BANG_.call(null,session,inst_116708,inst_116729);
var state_116748__$1 = (function (){var statearr_116760 = state_116748;
(statearr_116760[(11)] = inst_116726);

return statearr_116760;
})();
var statearr_116761_116781 = state_116748__$1;
(statearr_116761_116781[(2)] = inst_116730);

(statearr_116761_116781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (5))){
var inst_116712 = (state_116748[(7)]);
var inst_116711 = (state_116748[(10)]);
var inst_116710 = (state_116748[(2)]);
var inst_116711__$1 = fluree.db.util.async.throw_err.call(null,inst_116710);
var inst_116712__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_116711__$1);
var inst_116713 = (block <= inst_116712__$1);
var state_116748__$1 = (function (){var statearr_116762 = state_116748;
(statearr_116762[(7)] = inst_116712__$1);

(statearr_116762[(10)] = inst_116711__$1);

return statearr_116762;
})();
if(cljs.core.truth_(inst_116713)){
var statearr_116763_116782 = state_116748__$1;
(statearr_116763_116782[(1)] = (6));

} else {
var statearr_116764_116783 = state_116748__$1;
(statearr_116764_116783[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (14))){
var inst_116740 = (state_116748[(2)]);
var state_116748__$1 = state_116748;
var statearr_116765_116784 = state_116748__$1;
(statearr_116765_116784[(2)] = inst_116740);

(statearr_116765_116784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (10))){
var state_116748__$1 = state_116748;
var statearr_116766_116785 = state_116748__$1;
(statearr_116766_116785[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116749 === (8))){
var inst_116744 = (state_116748[(2)]);
var state_116748__$1 = state_116748;
var statearr_116768_116786 = state_116748__$1;
(statearr_116768_116786[(2)] = inst_116744);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116748__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__99975__auto__ = null;
var fluree$db$session$state_machine__99975__auto____0 = (function (){
var statearr_116769 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116769[(0)] = fluree$db$session$state_machine__99975__auto__);

(statearr_116769[(1)] = (1));

return statearr_116769;
});
var fluree$db$session$state_machine__99975__auto____1 = (function (state_116748){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116770){if((e116770 instanceof Object)){
var ex__99978__auto__ = e116770;
var statearr_116771_116787 = state_116748;
(statearr_116771_116787[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116748);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116788 = state_116748;
state_116748 = G__116788;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$session$state_machine__99975__auto__ = function(state_116748){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99975__auto____1.call(this,state_116748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99975__auto____0;
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99975__auto____1;
return fluree$db$session$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116772 = f__100070__auto__.call(null);
(statearr_116772[(6)] = c__100069__auto__);

return statearr_116772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116795){
var state_val_116796 = (state_116795[(1)]);
if((state_val_116796 === (1))){
var inst_116789 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_116790 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_116791 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_116792 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116790),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116791)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_116793 = fluree.db.util.log.debug.call(null,inst_116792);
var state_116795__$1 = (function (){var statearr_116797 = state_116795;
(statearr_116797[(7)] = inst_116793);

(statearr_116797[(8)] = inst_116789);

return statearr_116797;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116795__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__99975__auto__ = null;
var fluree$db$session$state_machine__99975__auto____0 = (function (){
var statearr_116798 = [null,null,null,null,null,null,null,null,null];
(statearr_116798[(0)] = fluree$db$session$state_machine__99975__auto__);

(statearr_116798[(1)] = (1));

return statearr_116798;
});
var fluree$db$session$state_machine__99975__auto____1 = (function (state_116795){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116799){if((e116799 instanceof Object)){
var ex__99978__auto__ = e116799;
var statearr_116800_116802 = state_116795;
(statearr_116800_116802[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116799;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116803 = state_116795;
state_116795 = G__116803;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$session$state_machine__99975__auto__ = function(state_116795){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99975__auto____1.call(this,state_116795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99975__auto____0;
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99975__auto____1;
return fluree$db$session$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116801 = f__100070__auto__.call(null);
(statearr_116801[(6)] = c__100069__auto__);

return statearr_116801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__116805 = arguments.length;
switch (G__116805) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__116806 = session;
var map__116806__$1 = (((((!((map__116806 == null))))?(((((map__116806.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116806.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116806):map__116806);
var conn = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__116806__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__100069__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_116858){
var state_val_116859 = (state_116858[(1)]);
if((state_val_116859 === (7))){
var inst_116854 = (state_116858[(2)]);
var state_116858__$1 = state_116858;
var statearr_116860_116884 = state_116858__$1;
(statearr_116860_116884[(2)] = inst_116854);

(statearr_116860_116884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (1))){
var state_116858__$1 = state_116858;
var statearr_116861_116885 = state_116858__$1;
(statearr_116861_116885[(2)] = null);

(statearr_116861_116885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (4))){
var inst_116812 = (state_116858[(7)]);
var inst_116811 = (state_116858[(2)]);
var inst_116812__$1 = fluree.db.util.async.throw_err.call(null,inst_116811);
var inst_116813 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_116814 = (inst_116812__$1 == null);
var state_116858__$1 = (function (){var statearr_116862 = state_116858;
(statearr_116862[(7)] = inst_116812__$1);

(statearr_116862[(8)] = inst_116813);

return statearr_116862;
})();
if(cljs.core.truth_(inst_116814)){
var statearr_116863_116886 = state_116858__$1;
(statearr_116863_116886[(1)] = (5));

} else {
var statearr_116864_116887 = state_116858__$1;
(statearr_116864_116887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (15))){
var inst_116812 = (state_116858[(7)]);
var inst_116827 = (state_116858[(2)]);
var inst_116828 = fluree.db.util.log.error.call(null,inst_116827,"Exception processing ledger updates for message: ",inst_116812);
var state_116858__$1 = state_116858;
var statearr_116865_116888 = state_116858__$1;
(statearr_116865_116888[(2)] = inst_116828);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116858__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (13))){
var inst_116850 = (state_116858[(2)]);
var state_116858__$1 = state_116858;
var statearr_116866_116889 = state_116858__$1;
(statearr_116866_116889[(2)] = inst_116850);

(statearr_116866_116889[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (6))){
var inst_116813 = (state_116858[(8)]);
var inst_116819 = (inst_116813 == null);
var state_116858__$1 = state_116858;
if(cljs.core.truth_(inst_116819)){
var statearr_116867_116890 = state_116858__$1;
(statearr_116867_116890[(1)] = (8));

} else {
var statearr_116868_116891 = state_116858__$1;
(statearr_116868_116891[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (17))){
var inst_116843 = (state_116858[(2)]);
var inst_116844 = fluree.db.util.async.throw_err.call(null,inst_116843);
var state_116858__$1 = state_116858;
var statearr_116869_116892 = state_116858__$1;
(statearr_116869_116892[(2)] = inst_116844);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116858__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (3))){
var inst_116856 = (state_116858[(2)]);
var state_116858__$1 = state_116858;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_116858__$1,inst_116856);
} else {
if((state_val_116859 === (12))){
var state_116858__$1 = state_116858;
var statearr_116870_116893 = state_116858__$1;
(statearr_116870_116893[(2)] = null);

(statearr_116870_116893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (2))){
var state_116858__$1 = state_116858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116858__$1,(4),update_chan);
} else {
if((state_val_116859 === (11))){
var state_116858__$1 = state_116858;
var statearr_116871_116894 = state_116858__$1;
(statearr_116871_116894[(2)] = null);

(statearr_116871_116894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (9))){
var state_116858__$1 = state_116858;
var statearr_116872_116895 = state_116858__$1;
(statearr_116872_116895[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (5))){
var inst_116816 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_116817 = fluree.db.util.log.info.call(null,inst_116816);
var state_116858__$1 = state_116858;
var statearr_116874_116896 = state_116858__$1;
(statearr_116874_116896[(2)] = inst_116817);

(statearr_116874_116896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (14))){
var inst_116846 = (state_116858[(2)]);
var state_116858__$1 = (function (){var statearr_116875 = state_116858;
(statearr_116875[(9)] = inst_116846);

return statearr_116875;
})();
var statearr_116876_116897 = state_116858__$1;
(statearr_116876_116897[(2)] = null);

(statearr_116876_116897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (16))){
var inst_116812 = (state_116858[(7)]);
var inst_116813 = (state_116858[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_116858,(15),new cljs.core.Keyword(null,"default","default",-1987822328),null,(14));
var inst_116835 = cljs.core.nth.call(null,inst_116812,(0),null);
var inst_116836 = cljs.core.nth.call(null,inst_116812,(1),null);
var inst_116837 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_116838 = cljs.core.pr_str.call(null,inst_116812);
var inst_116839 = fluree.db.util.core.trunc.call(null,inst_116838,(200));
var inst_116840 = fluree.db.util.log.trace.call(null,inst_116837,inst_116839);
var inst_116841 = fluree.db.session.process_ledger_update.call(null,inst_116813,inst_116835,inst_116836);
var state_116858__$1 = (function (){var statearr_116877 = state_116858;
(statearr_116877[(10)] = inst_116840);

return statearr_116877;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_116858__$1,(17),inst_116841);
} else {
if((state_val_116859 === (10))){
var inst_116852 = (state_116858[(2)]);
var state_116858__$1 = state_116858;
var statearr_116878_116898 = state_116858__$1;
(statearr_116878_116898[(2)] = inst_116852);

(statearr_116878_116898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_116859 === (8))){
var inst_116812 = (state_116858[(7)]);
var inst_116821 = cljs.core.first.call(null,inst_116812);
var inst_116822 = cljs.core.pr_str.call(null,inst_116821);
var inst_116823 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_116822].join('');
var inst_116824 = fluree.db.util.log.warn.call(null,inst_116823);
var state_116858__$1 = state_116858;
var statearr_116879_116899 = state_116858__$1;
(statearr_116879_116899[(2)] = inst_116824);

(statearr_116879_116899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____0 = (function (){
var statearr_116880 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_116880[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__);

(statearr_116880[(1)] = (1));

return statearr_116880;
});
var fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____1 = (function (state_116858){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_116858);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e116881){if((e116881 instanceof Object)){
var ex__99978__auto__ = e116881;
var statearr_116882_116900 = state_116858;
(statearr_116882_116900[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_116858);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e116881;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__116901 = state_116858;
state_116858 = G__116901;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__ = function(state_116858){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____1.call(this,state_116858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__99975__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_116883 = f__100070__auto__.call(null);
(statearr_116883[(6)] = c__100069__auto__);

return statearr_116883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

return c__100069__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__116902){
var map__116903 = p__116902;
var map__116903__$1 = (((((!((map__116903 == null))))?(((((map__116903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116903):map__116903);
var network = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__116903__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__116908 = block_result;
var map__116908__$1 = (((((!((map__116908 == null))))?(((((map__116908.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116908.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116908):map__116908);
var block = cljs.core.get.call(null,map__116908__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__116908__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__116908__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__116908__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__116908__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__116909 = tx_result;
var map__116909__$1 = (((((!((map__116909 == null))))?(((((map__116909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116909):map__116909);
var t = cljs.core.get.call(null,map__116909__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__116909__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__116905_SHARP_){
return cljs.core._EQ_.call(null,t,p1__116905_SHARP_.t);
}):(function (p1__116906_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__116906_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__116907_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__116907_SHARP_))){
return cljs.core.nth.call(null,p1__116907_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__116912 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__116912,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__116912,(1),null);
var error = cljs.core.nth.call(null,vec__116912,(2),null);
var message = cljs.core.nth.call(null,vec__116912,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = fluree.db.util.core.random_uuid.call(null);
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__116916 = arguments.length;
switch (G__116916) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__116917){
var map__116918 = p__116917;
var map__116918__$1 = (((((!((map__116918 == null))))?(((((map__116918.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116918.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__116918):map__116918);
var state = cljs.core.get.call(null,map__116918__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__116918__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__116918__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__116918__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__116920 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__116920,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__116920,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__116920,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__116923 = cljs.core.seq.call(null,tids);
var chunk__116924 = null;
var count__116925 = (0);
var i__116926 = (0);
while(true){
if((i__116926 < count__116925)){
var tid = cljs.core._nth.call(null,chunk__116924,i__116926);
var temp__5735__auto___117038__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___117038__$1)){
var keyed_callbacks_117039 = temp__5735__auto___117038__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_117040 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__116967_117041 = cljs.core.seq.call(null,keyed_callbacks_117039);
var chunk__116968_117042 = null;
var count__116969_117043 = (0);
var i__116970_117044 = (0);
while(true){
if((i__116970_117044 < count__116969_117043)){
var vec__116979_117045 = cljs.core._nth.call(null,chunk__116968_117042,i__116970_117044);
var k_117046 = cljs.core.nth.call(null,vec__116979_117045,(0),null);
var f_117047 = cljs.core.nth.call(null,vec__116979_117045,(1),null);
try{f_117047.call(null,tx_response_117040);
}catch (e116982){var e_117048 = e116982;
fluree.db.util.log.error.call(null,e_117048,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__117049 = seq__116967_117041;
var G__117050 = chunk__116968_117042;
var G__117051 = count__116969_117043;
var G__117052 = (i__116970_117044 + (1));
seq__116967_117041 = G__117049;
chunk__116968_117042 = G__117050;
count__116969_117043 = G__117051;
i__116970_117044 = G__117052;
continue;
} else {
var temp__5735__auto___117053__$2 = cljs.core.seq.call(null,seq__116967_117041);
if(temp__5735__auto___117053__$2){
var seq__116967_117054__$1 = temp__5735__auto___117053__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__116967_117054__$1)){
var c__4556__auto___117055 = cljs.core.chunk_first.call(null,seq__116967_117054__$1);
var G__117056 = cljs.core.chunk_rest.call(null,seq__116967_117054__$1);
var G__117057 = c__4556__auto___117055;
var G__117058 = cljs.core.count.call(null,c__4556__auto___117055);
var G__117059 = (0);
seq__116967_117041 = G__117056;
chunk__116968_117042 = G__117057;
count__116969_117043 = G__117058;
i__116970_117044 = G__117059;
continue;
} else {
var vec__116983_117060 = cljs.core.first.call(null,seq__116967_117054__$1);
var k_117061 = cljs.core.nth.call(null,vec__116983_117060,(0),null);
var f_117062 = cljs.core.nth.call(null,vec__116983_117060,(1),null);
try{f_117062.call(null,tx_response_117040);
}catch (e116986){var e_117063 = e116986;
fluree.db.util.log.error.call(null,e_117063,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__117064 = cljs.core.next.call(null,seq__116967_117054__$1);
var G__117065 = null;
var G__117066 = (0);
var G__117067 = (0);
seq__116967_117041 = G__117064;
chunk__116968_117042 = G__117065;
count__116969_117043 = G__117066;
i__116970_117044 = G__117067;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__117068 = seq__116923;
var G__117069 = chunk__116924;
var G__117070 = count__116925;
var G__117071 = (i__116926 + (1));
seq__116923 = G__117068;
chunk__116924 = G__117069;
count__116925 = G__117070;
i__116926 = G__117071;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__116923);
if(temp__5735__auto____$1){
var seq__116923__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__116923__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__116923__$1);
var G__117072 = cljs.core.chunk_rest.call(null,seq__116923__$1);
var G__117073 = c__4556__auto__;
var G__117074 = cljs.core.count.call(null,c__4556__auto__);
var G__117075 = (0);
seq__116923 = G__117072;
chunk__116924 = G__117073;
count__116925 = G__117074;
i__116926 = G__117075;
continue;
} else {
var tid = cljs.core.first.call(null,seq__116923__$1);
var temp__5735__auto___117076__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___117076__$2)){
var keyed_callbacks_117077 = temp__5735__auto___117076__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_117078 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__116987_117079 = cljs.core.seq.call(null,keyed_callbacks_117077);
var chunk__116988_117080 = null;
var count__116989_117081 = (0);
var i__116990_117082 = (0);
while(true){
if((i__116990_117082 < count__116989_117081)){
var vec__116999_117083 = cljs.core._nth.call(null,chunk__116988_117080,i__116990_117082);
var k_117084 = cljs.core.nth.call(null,vec__116999_117083,(0),null);
var f_117085 = cljs.core.nth.call(null,vec__116999_117083,(1),null);
try{f_117085.call(null,tx_response_117078);
}catch (e117002){var e_117086 = e117002;
fluree.db.util.log.error.call(null,e_117086,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__117087 = seq__116987_117079;
var G__117088 = chunk__116988_117080;
var G__117089 = count__116989_117081;
var G__117090 = (i__116990_117082 + (1));
seq__116987_117079 = G__117087;
chunk__116988_117080 = G__117088;
count__116989_117081 = G__117089;
i__116990_117082 = G__117090;
continue;
} else {
var temp__5735__auto___117091__$3 = cljs.core.seq.call(null,seq__116987_117079);
if(temp__5735__auto___117091__$3){
var seq__116987_117092__$1 = temp__5735__auto___117091__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__116987_117092__$1)){
var c__4556__auto___117093 = cljs.core.chunk_first.call(null,seq__116987_117092__$1);
var G__117094 = cljs.core.chunk_rest.call(null,seq__116987_117092__$1);
var G__117095 = c__4556__auto___117093;
var G__117096 = cljs.core.count.call(null,c__4556__auto___117093);
var G__117097 = (0);
seq__116987_117079 = G__117094;
chunk__116988_117080 = G__117095;
count__116989_117081 = G__117096;
i__116990_117082 = G__117097;
continue;
} else {
var vec__117003_117098 = cljs.core.first.call(null,seq__116987_117092__$1);
var k_117099 = cljs.core.nth.call(null,vec__117003_117098,(0),null);
var f_117100 = cljs.core.nth.call(null,vec__117003_117098,(1),null);
try{f_117100.call(null,tx_response_117078);
}catch (e117006){var e_117101 = e117006;
fluree.db.util.log.error.call(null,e_117101,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__117102 = cljs.core.next.call(null,seq__116987_117092__$1);
var G__117103 = null;
var G__117104 = (0);
var G__117105 = (0);
seq__116987_117079 = G__117102;
chunk__116988_117080 = G__117103;
count__116989_117081 = G__117104;
i__116990_117082 = G__117105;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__117106 = cljs.core.next.call(null,seq__116923__$1);
var G__117107 = null;
var G__117108 = (0);
var G__117109 = (0);
seq__116923 = G__117106;
chunk__116924 = G__117107;
count__116925 = G__117108;
i__116926 = G__117109;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_117110 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__100069__auto___117111 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__100070__auto__ = (function (){var switch__99974__auto__ = (function (state_117023){
var state_val_117024 = (state_117023[(1)]);
if((state_val_117024 === (1))){
var state_117023__$1 = state_117023;
var statearr_117025_117112 = state_117023__$1;
(statearr_117025_117112[(2)] = null);

(statearr_117025_117112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_117024 === (2))){
var inst_117008 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_117023__$1 = state_117023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_117023__$1,(4),inst_117008);
} else {
if((state_val_117024 === (3))){
var inst_117021 = (state_117023[(2)]);
var state_117023__$1 = state_117023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_117023__$1,inst_117021);
} else {
if((state_val_117024 === (4))){
var inst_117010 = (state_117023[(7)]);
var inst_117010__$1 = (state_117023[(2)]);
var inst_117011 = (inst_117010__$1 == null);
var state_117023__$1 = (function (){var statearr_117026 = state_117023;
(statearr_117026[(7)] = inst_117010__$1);

return statearr_117026;
})();
if(cljs.core.truth_(inst_117011)){
var statearr_117027_117113 = state_117023__$1;
(statearr_117027_117113[(1)] = (5));

} else {
var statearr_117028_117114 = state_117023__$1;
(statearr_117028_117114[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_117024 === (5))){
var inst_117013 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_117014 = fluree.db.util.log.info.call(null,inst_117013);
var state_117023__$1 = state_117023;
var statearr_117029_117115 = state_117023__$1;
(statearr_117029_117115[(2)] = inst_117014);

(statearr_117029_117115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_117024 === (6))){
var inst_117010 = (state_117023[(7)]);
var inst_117016 = transact_handler_117110.call(null,conn,inst_117010);
var state_117023__$1 = (function (){var statearr_117030 = state_117023;
(statearr_117030[(8)] = inst_117016);

return statearr_117030;
})();
var statearr_117031_117116 = state_117023__$1;
(statearr_117031_117116[(2)] = null);

(statearr_117031_117116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_117024 === (7))){
var inst_117019 = (state_117023[(2)]);
var state_117023__$1 = state_117023;
var statearr_117032_117117 = state_117023__$1;
(statearr_117032_117117[(2)] = inst_117019);

(statearr_117032_117117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__99975__auto__ = null;
var fluree$db$session$state_machine__99975__auto____0 = (function (){
var statearr_117033 = [null,null,null,null,null,null,null,null,null];
(statearr_117033[(0)] = fluree$db$session$state_machine__99975__auto__);

(statearr_117033[(1)] = (1));

return statearr_117033;
});
var fluree$db$session$state_machine__99975__auto____1 = (function (state_117023){
while(true){
var ret_value__99976__auto__ = (function (){try{while(true){
var result__99977__auto__ = switch__99974__auto__.call(null,state_117023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__99977__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__99977__auto__;
}
break;
}
}catch (e117034){if((e117034 instanceof Object)){
var ex__99978__auto__ = e117034;
var statearr_117035_117118 = state_117023;
(statearr_117035_117118[(5)] = ex__99978__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_117023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e117034;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__99976__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__117119 = state_117023;
state_117023 = G__117119;
continue;
} else {
return ret_value__99976__auto__;
}
break;
}
});
fluree$db$session$state_machine__99975__auto__ = function(state_117023){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__99975__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__99975__auto____1.call(this,state_117023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__99975__auto____0;
fluree$db$session$state_machine__99975__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__99975__auto____1;
return fluree$db$session$state_machine__99975__auto__;
})()
})();
var state__100071__auto__ = (function (){var statearr_117036 = f__100070__auto__.call(null);
(statearr_117036[(6)] = c__100069__auto___117111);

return statearr_117036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__100071__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__117120_SHARP_){
return cljs.core.assoc.call(null,p1__117120_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__117120_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__117121_SHARP_){
return cljs.core.assoc.call(null,p1__117121_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__117124 = arguments.length;
switch (G__117124) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__117125 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__117122_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__117122_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__117125);
} else {
return G__117125;
}
})();
var seq__117126 = cljs.core.seq.call(null,sessions);
var chunk__117127 = null;
var count__117128 = (0);
var i__117129 = (0);
while(true){
if((i__117129 < count__117128)){
var session = cljs.core._nth.call(null,chunk__117127,i__117129);
fluree.db.session.close.call(null,session);


var G__117131 = seq__117126;
var G__117132 = chunk__117127;
var G__117133 = count__117128;
var G__117134 = (i__117129 + (1));
seq__117126 = G__117131;
chunk__117127 = G__117132;
count__117128 = G__117133;
i__117129 = G__117134;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__117126);
if(temp__5735__auto__){
var seq__117126__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__117126__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__117126__$1);
var G__117135 = cljs.core.chunk_rest.call(null,seq__117126__$1);
var G__117136 = c__4556__auto__;
var G__117137 = cljs.core.count.call(null,c__4556__auto__);
var G__117138 = (0);
seq__117126 = G__117135;
chunk__117127 = G__117136;
count__117128 = G__117137;
i__117129 = G__117138;
continue;
} else {
var session = cljs.core.first.call(null,seq__117126__$1);
fluree.db.session.close.call(null,session);


var G__117139 = cljs.core.next.call(null,seq__117126__$1);
var G__117140 = null;
var G__117141 = (0);
var G__117142 = (0);
seq__117126 = G__117139;
chunk__117127 = G__117140;
count__117128 = G__117141;
i__117129 = G__117142;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
