// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4131__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__99444 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99444,(5),null);
var G__99447 = idx;
var G__99447__$1 = (((G__99447 instanceof cljs.core.Keyword))?G__99447.fqn:null);
switch (G__99447__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__99447__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__99449 = idx;
var G__99449__$1 = (((G__99449 instanceof cljs.core.Keyword))?G__99449.fqn:null);
switch (G__99449__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__99449__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__99451 = idx;
var G__99451__$1 = (((G__99451 instanceof cljs.core.Keyword))?G__99451.fqn:null);
switch (G__99451__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__99451__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__99454 = arguments.length;
switch (G__99454) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__99455 = (function (){var pred__99458 = cljs.core.identical_QMARK_;
var expr__99459 = test;
if(cljs.core.truth_((pred__99458.cljs$core$IFn$_invoke$arity$2 ? pred__99458.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__99459) : pred__99458.call(null,cljs.core._EQ_,expr__99459)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__99458.cljs$core$IFn$_invoke$arity$2 ? pred__99458.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__99459) : pred__99458.call(null,cljs.core._LT_,expr__99459)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__99458.cljs$core$IFn$_invoke$arity$2 ? pred__99458.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__99459) : pred__99458.call(null,cljs.core._LT__EQ_,expr__99459)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__99458.cljs$core$IFn$_invoke$arity$2 ? pred__99458.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__99459) : pred__99458.call(null,cljs.core._GT_,expr__99459)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__99458.cljs$core$IFn$_invoke$arity$2 ? pred__99458.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__99459) : pred__99458.call(null,cljs.core._GT__EQ_,expr__99459)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__99459)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99455,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99455,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99455,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__99455,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_99669){
var state_val_99670 = (state_99669[(1)]);
if((state_val_99670 === (65))){
var inst_99622 = (state_99669[(7)]);
var inst_99623 = (state_99669[(8)]);
var inst_99630 = (state_99669[(9)]);
var inst_99637 = (inst_99622 + (1));
var tmp99671 = inst_99623;
var inst_99621 = inst_99630;
var inst_99622__$1 = inst_99637;
var inst_99623__$1 = tmp99671;
var state_99669__$1 = (function (){var statearr_99672 = state_99669;
(statearr_99672[(7)] = inst_99622__$1);

(statearr_99672[(8)] = inst_99623__$1);

(statearr_99672[(10)] = inst_99621);

return statearr_99672;
})();
var statearr_99673_99780 = state_99669__$1;
(statearr_99673_99780[(2)] = null);

(statearr_99673_99780[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (70))){
var inst_99644 = (state_99669[(11)]);
var state_99669__$1 = state_99669;
var statearr_99674_99781 = state_99669__$1;
(statearr_99674_99781[(2)] = inst_99644);

(statearr_99674_99781[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (62))){
var inst_99622 = (state_99669[(7)]);
var inst_99563 = (state_99669[(12)]);
var inst_99621 = (state_99669[(10)]);
var inst_99628 = cljs.core.seq(inst_99621);
var inst_99629 = cljs.core.first(inst_99628);
var inst_99630 = cljs.core.next(inst_99628);
var inst_99631 = (inst_99629 == null);
var inst_99632 = (inst_99622 > inst_99563);
var inst_99633 = ((inst_99631) || (inst_99632));
var state_99669__$1 = (function (){var statearr_99675 = state_99669;
(statearr_99675[(9)] = inst_99630);

return statearr_99675;
})();
if(cljs.core.truth_(inst_99633)){
var statearr_99676_99782 = state_99669__$1;
(statearr_99676_99782[(1)] = (64));

} else {
var statearr_99677_99783 = state_99669__$1;
(statearr_99677_99783[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (7))){
var inst_99479 = (state_99669[(13)]);
var inst_99493 = (state_99669[(2)]);
var inst_99494 = fluree.db.util.core.pred_ident_QMARK_(inst_99479);
var state_99669__$1 = (function (){var statearr_99678 = state_99669;
(statearr_99678[(14)] = inst_99493);

return statearr_99678;
})();
if(inst_99494){
var statearr_99679_99784 = state_99669__$1;
(statearr_99679_99784[(1)] = (9));

} else {
var statearr_99680_99785 = state_99669__$1;
(statearr_99680_99785[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (59))){
var inst_99591 = (state_99669[(15)]);
var inst_99563 = (state_99669[(12)]);
var inst_99604 = (state_99669[(16)]);
var inst_99590 = (state_99669[(17)]);
var inst_99607 = (inst_99563 - inst_99590);
var inst_99608 = fluree.db.flake.take(inst_99607,inst_99604);
var inst_99609 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_99608,inst_99591);
var state_99669__$1 = state_99669;
var statearr_99681_99786 = state_99669__$1;
(statearr_99681_99786[(2)] = inst_99609);

(statearr_99681_99786[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (20))){
var inst_99516 = (state_99669[(2)]);
var inst_99517 = fluree.db.util.async.throw_err(inst_99516);
var state_99669__$1 = state_99669;
var statearr_99682_99787 = state_99669__$1;
(statearr_99682_99787[(2)] = inst_99517);

(statearr_99682_99787[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (72))){
var inst_99663 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99683_99788 = state_99669__$1;
(statearr_99683_99788[(2)] = inst_99663);

(statearr_99683_99788[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (58))){
var inst_99589 = (state_99669[(18)]);
var inst_99604 = (state_99669[(2)]);
var inst_99605 = fluree.db.dbproto._rhs(inst_99589);
var state_99669__$1 = (function (){var statearr_99684 = state_99669;
(statearr_99684[(19)] = inst_99605);

(statearr_99684[(16)] = inst_99604);

return statearr_99684;
})();
var statearr_99685_99789 = state_99669__$1;
(statearr_99685_99789[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (60))){
var inst_99604 = (state_99669[(16)]);
var inst_99590 = (state_99669[(17)]);
var inst_99618 = cljs.core.seq(inst_99604);
var inst_99619 = cljs.core.first(inst_99618);
var inst_99620 = cljs.core.next(inst_99618);
var inst_99621 = inst_99604;
var inst_99622 = inst_99590;
var inst_99623 = inst_99604;
var state_99669__$1 = (function (){var statearr_99687 = state_99669;
(statearr_99687[(20)] = inst_99620);

(statearr_99687[(7)] = inst_99622);

(statearr_99687[(8)] = inst_99623);

(statearr_99687[(21)] = inst_99619);

(statearr_99687[(10)] = inst_99621);

return statearr_99687;
})();
var statearr_99688_99790 = state_99669__$1;
(statearr_99688_99790[(2)] = null);

(statearr_99688_99790[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (27))){
var inst_99520 = (state_99669[(22)]);
var state_99669__$1 = state_99669;
var statearr_99689_99791 = state_99669__$1;
(statearr_99689_99791[(2)] = inst_99520);

(statearr_99689_99791[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (1))){
var state_99669__$1 = state_99669;
var statearr_99690_99792 = state_99669__$1;
(statearr_99690_99792[(2)] = null);

(statearr_99690_99792[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (69))){
var inst_99653 = (state_99669[(2)]);
var inst_99654 = cljs.core.not(inst_99653);
var state_99669__$1 = state_99669;
if(inst_99654){
var statearr_99691_99793 = state_99669__$1;
(statearr_99691_99793[(1)] = (70));

} else {
var statearr_99692_99794 = state_99669__$1;
(statearr_99692_99794[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (24))){
var state_99669__$1 = state_99669;
var statearr_99693_99795 = state_99669__$1;
(statearr_99693_99795[(2)] = (-1));

(statearr_99693_99795[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (55))){
var inst_99596 = (state_99669[(23)]);
var inst_99558 = (state_99669[(24)]);
var inst_99557 = (state_99669[(25)]);
var inst_99595 = (state_99669[(2)]);
var inst_99596__$1 = fluree.db.util.async.throw_err(inst_99595);
var inst_99597 = fluree.db.flake.subrange(inst_99596__$1,start_test,inst_99557,end_test,inst_99558);
var inst_99598 = fluree.db.query.range.value_with_nil_pred(idx,inst_99557,inst_99558);
var state_99669__$1 = (function (){var statearr_99694 = state_99669;
(statearr_99694[(23)] = inst_99596__$1);

(statearr_99694[(26)] = inst_99597);

return statearr_99694;
})();
if(inst_99598){
var statearr_99695_99796 = state_99669__$1;
(statearr_99695_99796[(1)] = (56));

} else {
var statearr_99696_99797 = state_99669__$1;
(statearr_99696_99797[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (39))){
var inst_99484 = (state_99669[(27)]);
var state_99669__$1 = state_99669;
var statearr_99697_99798 = state_99669__$1;
(statearr_99697_99798[(2)] = inst_99484);

(statearr_99697_99798[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (46))){
var state_99669__$1 = state_99669;
var statearr_99698_99799 = state_99669__$1;
(statearr_99698_99799[(2)] = fluree.db.util.core.max_long);

(statearr_99698_99799[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (4))){
var inst_99472 = (state_99669[(28)]);
var inst_99478 = (state_99669[(29)]);
var inst_99471 = (state_99669[(30)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_99669,(3),Error,null,(2));
var inst_99471__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_99472__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(0),null);
var inst_99473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(1),null);
var inst_99474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(2),null);
var inst_99475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(3),null);
var inst_99476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(4),null);
var inst_99477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99471__$1,(5),null);
var inst_99478__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_99479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(0),null);
var inst_99480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(1),null);
var inst_99481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(2),null);
var inst_99482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(3),null);
var inst_99483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(4),null);
var inst_99484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_99478__$1,(5),null);
var inst_99485 = fluree.db.util.core.pred_ident_QMARK_(inst_99472__$1);
var state_99669__$1 = (function (){var statearr_99699 = state_99669;
(statearr_99699[(28)] = inst_99472__$1);

(statearr_99699[(31)] = inst_99477);

(statearr_99699[(32)] = inst_99483);

(statearr_99699[(33)] = inst_99480);

(statearr_99699[(13)] = inst_99479);

(statearr_99699[(34)] = inst_99475);

(statearr_99699[(35)] = inst_99473);

(statearr_99699[(36)] = inst_99482);

(statearr_99699[(29)] = inst_99478__$1);

(statearr_99699[(27)] = inst_99484);

(statearr_99699[(30)] = inst_99471__$1);

(statearr_99699[(37)] = inst_99481);

(statearr_99699[(38)] = inst_99474);

(statearr_99699[(39)] = inst_99476);

return statearr_99699;
})();
if(inst_99485){
var statearr_99700_99800 = state_99669__$1;
(statearr_99700_99800[(1)] = (5));

} else {
var statearr_99701_99801 = state_99669__$1;
(statearr_99701_99801[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (54))){
var inst_99665 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99702_99802 = state_99669__$1;
(statearr_99702_99802[(2)] = inst_99665);


cljs.core.async.impl.ioc_helpers.process_exception(state_99669__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (15))){
var inst_99481 = (state_99669[(37)]);
var inst_99511 = (state_99669[(2)]);
var inst_99512 = fluree.db.util.core.pred_ident_QMARK_(inst_99481);
var state_99669__$1 = (function (){var statearr_99703 = state_99669;
(statearr_99703[(40)] = inst_99511);

return statearr_99703;
})();
if(inst_99512){
var statearr_99704_99803 = state_99669__$1;
(statearr_99704_99803[(1)] = (17));

} else {
var statearr_99705_99804 = state_99669__$1;
(statearr_99705_99804[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (48))){
var inst_99569 = (state_99669[(41)]);
var state_99669__$1 = state_99669;
var statearr_99706_99805 = state_99669__$1;
(statearr_99706_99805[(2)] = inst_99569);

(statearr_99706_99805[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (50))){
var inst_99574 = (state_99669[(2)]);
var inst_99575 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_99576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_99577 = [cljs.core.cst$kw$novelty,idx];
var inst_99578 = (new cljs.core.PersistentVector(null,2,(5),inst_99576,inst_99577,null));
var inst_99579 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_99578);
var inst_99580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_99581 = fluree.db.dbproto._resolve(inst_99580);
var state_99669__$1 = (function (){var statearr_99707 = state_99669;
(statearr_99707[(42)] = inst_99579);

(statearr_99707[(43)] = inst_99575);

(statearr_99707[(44)] = inst_99574);

return statearr_99707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(51),inst_99581);
} else {
if((state_val_99670 === (21))){
var inst_99511 = (state_99669[(40)]);
var state_99669__$1 = state_99669;
var statearr_99708_99806 = state_99669__$1;
(statearr_99708_99806[(2)] = inst_99511);

(statearr_99708_99806[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (31))){
var inst_99480 = (state_99669[(33)]);
var state_99669__$1 = state_99669;
var statearr_99709_99807 = state_99669__$1;
(statearr_99709_99807[(2)] = inst_99480);

(statearr_99709_99807[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (32))){
var inst_99477 = (state_99669[(31)]);
var inst_99538 = (state_99669[(2)]);
var state_99669__$1 = (function (){var statearr_99710 = state_99669;
(statearr_99710[(45)] = inst_99538);

return statearr_99710;
})();
if(cljs.core.truth_(inst_99477)){
var statearr_99711_99808 = state_99669__$1;
(statearr_99711_99808[(1)] = (33));

} else {
var statearr_99712_99809 = state_99669__$1;
(statearr_99712_99809[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (40))){
var inst_99550 = (cljs.core._LT__EQ_ === end_test);
var state_99669__$1 = state_99669;
if(cljs.core.truth_(inst_99550)){
var statearr_99713_99810 = state_99669__$1;
(statearr_99713_99810[(1)] = (42));

} else {
var statearr_99714_99811 = state_99669__$1;
(statearr_99714_99811[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (56))){
var inst_99579 = (state_99669[(42)]);
var inst_99584 = (state_99669[(46)]);
var inst_99568 = (state_99669[(47)]);
var inst_99483 = (state_99669[(32)]);
var inst_99475 = (state_99669[(34)]);
var inst_99502 = (state_99669[(48)]);
var inst_99529 = (state_99669[(49)]);
var inst_99564 = (state_99669[(50)]);
var inst_99482 = (state_99669[(36)]);
var inst_99478 = (state_99669[(29)]);
var inst_99596 = (state_99669[(23)]);
var inst_99591 = (state_99669[(15)]);
var inst_99471 = (state_99669[(30)]);
var inst_99556 = (state_99669[(51)]);
var inst_99520 = (state_99669[(22)]);
var inst_99597 = (state_99669[(26)]);
var inst_99476 = (state_99669[(39)]);
var inst_99547 = (state_99669[(52)]);
var inst_99575 = (state_99669[(43)]);
var inst_99538 = (state_99669[(45)]);
var inst_99574 = (state_99669[(44)]);
var inst_99563 = (state_99669[(12)]);
var inst_99558 = (state_99669[(24)]);
var inst_99589 = (state_99669[(18)]);
var inst_99511 = (state_99669[(40)]);
var inst_99557 = (state_99669[(25)]);
var inst_99493 = (state_99669[(14)]);
var inst_99590 = (state_99669[(17)]);
var inst_99600 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_99589;
var flakes = inst_99596;
var s1 = inst_99493;
var o2 = inst_99520;
var t1 = inst_99475;
var i = inst_99590;
var m1 = inst_99547;
var root_node = inst_99584;
var to_t = inst_99575;
var s2 = inst_99502;
var p2 = inst_99538;
var permissions = inst_99564;
var limit = inst_99563;
var start_flake = inst_99557;
var acc = inst_99591;
var t2 = inst_99482;
var op1 = inst_99476;
var o1 = inst_99511;
var end_flake = inst_99558;
var base_result = inst_99597;
var vec__99468 = inst_99478;
var p1 = inst_99529;
var idx_compare = inst_99568;
var op2 = inst_99483;
var from_t = inst_99574;
var vec__99465 = inst_99471;
var m2 = inst_99556;
var novelty = inst_99579;
return ((function (no_filter_QMARK_,next_node,flakes,s1,o2,t1,i,m1,root_node,to_t,s2,p2,permissions,limit,start_flake,acc,t2,op1,o1,end_flake,base_result,vec__99468,p1,idx_compare,op2,from_t,vec__99465,m2,novelty,inst_99579,inst_99584,inst_99568,inst_99483,inst_99475,inst_99502,inst_99529,inst_99564,inst_99482,inst_99478,inst_99596,inst_99591,inst_99471,inst_99556,inst_99520,inst_99597,inst_99476,inst_99547,inst_99575,inst_99538,inst_99574,inst_99563,inst_99558,inst_99589,inst_99511,inst_99557,inst_99493,inst_99590,state_val_99670,c__99059__auto__){
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
;})(no_filter_QMARK_,next_node,flakes,s1,o2,t1,i,m1,root_node,to_t,s2,p2,permissions,limit,start_flake,acc,t2,op1,o1,end_flake,base_result,vec__99468,p1,idx_compare,op2,from_t,vec__99465,m2,novelty,inst_99579,inst_99584,inst_99568,inst_99483,inst_99475,inst_99502,inst_99529,inst_99564,inst_99482,inst_99478,inst_99596,inst_99591,inst_99471,inst_99556,inst_99520,inst_99597,inst_99476,inst_99547,inst_99575,inst_99538,inst_99574,inst_99563,inst_99558,inst_99589,inst_99511,inst_99557,inst_99493,inst_99590,state_val_99670,c__99059__auto__))
})();
var inst_99601 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_99600,inst_99597,inst_99597);
var state_99669__$1 = state_99669;
var statearr_99715_99812 = state_99669__$1;
(statearr_99715_99812[(2)] = inst_99601);

(statearr_99715_99812[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (33))){
var inst_99477 = (state_99669[(31)]);
var state_99669__$1 = state_99669;
var statearr_99716_99813 = state_99669__$1;
(statearr_99716_99813[(2)] = inst_99477);

(statearr_99716_99813[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (13))){
var inst_99474 = (state_99669[(38)]);
var inst_99505 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_99474);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(16),inst_99505);
} else {
if((state_val_99670 === (22))){
var inst_99521 = (state_99669[(53)]);
var state_99669__$1 = state_99669;
var statearr_99717_99814 = state_99669__$1;
(statearr_99717_99814[(2)] = inst_99521);

(statearr_99717_99814[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (36))){
var state_99669__$1 = state_99669;
var statearr_99718_99815 = state_99669__$1;
(statearr_99718_99815[(2)] = fluree.db.util.core.min_integer);

(statearr_99718_99815[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (41))){
var inst_99483 = (state_99669[(32)]);
var inst_99475 = (state_99669[(34)]);
var inst_99502 = (state_99669[(48)]);
var inst_99529 = (state_99669[(49)]);
var inst_99482 = (state_99669[(36)]);
var inst_99556 = (state_99669[(51)]);
var inst_99520 = (state_99669[(22)]);
var inst_99476 = (state_99669[(39)]);
var inst_99547 = (state_99669[(52)]);
var inst_99538 = (state_99669[(45)]);
var inst_99511 = (state_99669[(40)]);
var inst_99559 = (state_99669[(54)]);
var inst_99493 = (state_99669[(14)]);
var inst_99556__$1 = (state_99669[(2)]);
var inst_99557 = fluree.db.flake.__GT_Flake(inst_99493,inst_99529,inst_99511,inst_99475,inst_99476,inst_99547);
var inst_99558 = fluree.db.flake.__GT_Flake(inst_99502,inst_99538,inst_99520,inst_99482,inst_99483,inst_99556__$1);
var inst_99559__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_99669__$1 = (function (){var statearr_99719 = state_99669;
(statearr_99719[(51)] = inst_99556__$1);

(statearr_99719[(24)] = inst_99558);

(statearr_99719[(54)] = inst_99559__$1);

(statearr_99719[(25)] = inst_99557);

return statearr_99719;
})();
if(cljs.core.truth_(inst_99559__$1)){
var statearr_99720_99816 = state_99669__$1;
(statearr_99720_99816[(1)] = (45));

} else {
var statearr_99721_99817 = state_99669__$1;
(statearr_99721_99817[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (43))){
var state_99669__$1 = state_99669;
var statearr_99722_99818 = state_99669__$1;
(statearr_99722_99818[(2)] = fluree.db.util.core.min_integer);

(statearr_99722_99818[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (61))){
var inst_99644 = (state_99669[(11)]);
var inst_99605 = (state_99669[(19)]);
var inst_99644__$1 = (state_99669[(2)]);
var inst_99645 = cljs.core.count(inst_99644__$1);
var state_99669__$1 = (function (){var statearr_99723 = state_99669;
(statearr_99723[(11)] = inst_99644__$1);

(statearr_99723[(55)] = inst_99645);

return statearr_99723;
})();
if(cljs.core.truth_(inst_99605)){
var statearr_99724_99819 = state_99669__$1;
(statearr_99724_99819[(1)] = (67));

} else {
var statearr_99725_99820 = state_99669__$1;
(statearr_99725_99820[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (29))){
var inst_99534 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
if(cljs.core.truth_(inst_99534)){
var statearr_99726_99821 = state_99669__$1;
(statearr_99726_99821[(1)] = (30));

} else {
var statearr_99727_99822 = state_99669__$1;
(statearr_99727_99822[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (44))){
var inst_99554 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99728_99823 = state_99669__$1;
(statearr_99728_99823[(2)] = inst_99554);

(statearr_99728_99823[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (6))){
var inst_99472 = (state_99669[(28)]);
var state_99669__$1 = state_99669;
var statearr_99729_99824 = state_99669__$1;
(statearr_99729_99824[(2)] = inst_99472);

(statearr_99729_99824[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (28))){
var inst_99530 = (state_99669[(56)]);
var state_99669__$1 = state_99669;
var statearr_99730_99825 = state_99669__$1;
(statearr_99730_99825[(2)] = inst_99530);

(statearr_99730_99825[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (64))){
var inst_99591 = (state_99669[(15)]);
var inst_99623 = (state_99669[(8)]);
var inst_99635 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_99623,inst_99591);
var state_99669__$1 = state_99669;
var statearr_99731_99826 = state_99669__$1;
(statearr_99731_99826[(2)] = inst_99635);

(statearr_99731_99826[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (51))){
var inst_99584 = (state_99669[(46)]);
var inst_99557 = (state_99669[(25)]);
var inst_99583 = (state_99669[(2)]);
var inst_99584__$1 = fluree.db.util.async.throw_err(inst_99583);
var inst_99585 = fluree.db.dbproto._lookup_leaf(inst_99584__$1,inst_99557);
var state_99669__$1 = (function (){var statearr_99732 = state_99669;
(statearr_99732[(46)] = inst_99584__$1);

return statearr_99732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(52),inst_99585);
} else {
if((state_val_99670 === (25))){
var inst_99473 = (state_99669[(35)]);
var state_99669__$1 = state_99669;
var statearr_99733_99827 = state_99669__$1;
(statearr_99733_99827[(2)] = inst_99473);

(statearr_99733_99827[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (34))){
var inst_99541 = (cljs.core._GT__EQ_ === start_test);
var state_99669__$1 = state_99669;
if(cljs.core.truth_(inst_99541)){
var statearr_99734_99828 = state_99669__$1;
(statearr_99734_99828[(1)] = (36));

} else {
var statearr_99735_99829 = state_99669__$1;
(statearr_99735_99829[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (17))){
var inst_99481 = (state_99669[(37)]);
var inst_99514 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_99481);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(20),inst_99514);
} else {
if((state_val_99670 === (3))){
var inst_99461 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99736_99830 = state_99669__$1;
(statearr_99736_99830[(2)] = inst_99461);


cljs.core.async.impl.ioc_helpers.process_exception(state_99669__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (12))){
var inst_99498 = (state_99669[(2)]);
var inst_99499 = fluree.db.util.async.throw_err(inst_99498);
var state_99669__$1 = state_99669;
var statearr_99737_99831 = state_99669__$1;
(statearr_99737_99831[(2)] = inst_99499);

(statearr_99737_99831[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (2))){
var inst_99667 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99669__$1,inst_99667);
} else {
if((state_val_99670 === (66))){
var inst_99640 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99738_99832 = state_99669__$1;
(statearr_99738_99832[(2)] = inst_99640);

(statearr_99738_99832[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (23))){
var inst_99525 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
if(cljs.core.truth_(inst_99525)){
var statearr_99739_99833 = state_99669__$1;
(statearr_99739_99833[(1)] = (24));

} else {
var statearr_99740_99834 = state_99669__$1;
(statearr_99740_99834[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (47))){
var inst_99569 = (state_99669[(41)]);
var inst_99563 = (state_99669[(2)]);
var inst_99564 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_99565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_99566 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_99567 = (new cljs.core.PersistentVector(null,3,(5),inst_99565,inst_99566,null));
var inst_99568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_99567);
var inst_99569__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_99669__$1 = (function (){var statearr_99741 = state_99669;
(statearr_99741[(47)] = inst_99568);

(statearr_99741[(41)] = inst_99569__$1);

(statearr_99741[(50)] = inst_99564);

(statearr_99741[(12)] = inst_99563);

return statearr_99741;
})();
if(cljs.core.truth_(inst_99569__$1)){
var statearr_99742_99835 = state_99669__$1;
(statearr_99742_99835[(1)] = (48));

} else {
var statearr_99743_99836 = state_99669__$1;
(statearr_99743_99836[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (35))){
var inst_99484 = (state_99669[(27)]);
var inst_99547 = (state_99669[(2)]);
var state_99669__$1 = (function (){var statearr_99744 = state_99669;
(statearr_99744[(52)] = inst_99547);

return statearr_99744;
})();
if(cljs.core.truth_(inst_99484)){
var statearr_99745_99837 = state_99669__$1;
(statearr_99745_99837[(1)] = (39));

} else {
var statearr_99746_99838 = state_99669__$1;
(statearr_99746_99838[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (19))){
var inst_99473 = (state_99669[(35)]);
var inst_99521 = (state_99669[(53)]);
var inst_99520 = (state_99669[(2)]);
var inst_99521__$1 = (inst_99473 == null);
var state_99669__$1 = (function (){var statearr_99747 = state_99669;
(statearr_99747[(53)] = inst_99521__$1);

(statearr_99747[(22)] = inst_99520);

return statearr_99747;
})();
if(cljs.core.truth_(inst_99521__$1)){
var statearr_99748_99839 = state_99669__$1;
(statearr_99748_99839[(1)] = (21));

} else {
var statearr_99749_99840 = state_99669__$1;
(statearr_99749_99840[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (57))){
var inst_99597 = (state_99669[(26)]);
var state_99669__$1 = state_99669;
var statearr_99750_99841 = state_99669__$1;
(statearr_99750_99841[(2)] = inst_99597);

(statearr_99750_99841[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (68))){
var inst_99605 = (state_99669[(19)]);
var state_99669__$1 = state_99669;
var statearr_99751_99842 = state_99669__$1;
(statearr_99751_99842[(2)] = inst_99605);

(statearr_99751_99842[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (11))){
var inst_99474 = (state_99669[(38)]);
var inst_99502 = (state_99669[(2)]);
var inst_99503 = fluree.db.util.core.pred_ident_QMARK_(inst_99474);
var state_99669__$1 = (function (){var statearr_99752 = state_99669;
(statearr_99752[(48)] = inst_99502);

return statearr_99752;
})();
if(inst_99503){
var statearr_99753_99843 = state_99669__$1;
(statearr_99753_99843[(1)] = (13));

} else {
var statearr_99754_99844 = state_99669__$1;
(statearr_99754_99844[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (9))){
var inst_99479 = (state_99669[(13)]);
var inst_99496 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_99479);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(12),inst_99496);
} else {
if((state_val_99670 === (5))){
var inst_99472 = (state_99669[(28)]);
var inst_99487 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_99472);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(8),inst_99487);
} else {
if((state_val_99670 === (14))){
var inst_99474 = (state_99669[(38)]);
var state_99669__$1 = state_99669;
var statearr_99755_99845 = state_99669__$1;
(statearr_99755_99845[(2)] = inst_99474);

(statearr_99755_99845[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (45))){
var inst_99559 = (state_99669[(54)]);
var state_99669__$1 = state_99669;
var statearr_99756_99846 = state_99669__$1;
(statearr_99756_99846[(2)] = inst_99559);

(statearr_99756_99846[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (53))){
var inst_99579 = (state_99669[(42)]);
var inst_99575 = (state_99669[(43)]);
var inst_99574 = (state_99669[(44)]);
var inst_99589 = (state_99669[(18)]);
var inst_99593 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_99589,inst_99574,inst_99575,inst_99579);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(55),inst_99593);
} else {
if((state_val_99670 === (26))){
var inst_99480 = (state_99669[(33)]);
var inst_99530 = (state_99669[(56)]);
var inst_99529 = (state_99669[(2)]);
var inst_99530__$1 = (inst_99480 == null);
var state_99669__$1 = (function (){var statearr_99757 = state_99669;
(statearr_99757[(49)] = inst_99529);

(statearr_99757[(56)] = inst_99530__$1);

return statearr_99757;
})();
if(cljs.core.truth_(inst_99530__$1)){
var statearr_99758_99847 = state_99669__$1;
(statearr_99758_99847[(1)] = (27));

} else {
var statearr_99759_99848 = state_99669__$1;
(statearr_99759_99848[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (16))){
var inst_99507 = (state_99669[(2)]);
var inst_99508 = fluree.db.util.async.throw_err(inst_99507);
var state_99669__$1 = state_99669;
var statearr_99760_99849 = state_99669__$1;
(statearr_99760_99849[(2)] = inst_99508);

(statearr_99760_99849[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (38))){
var inst_99545 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99761_99850 = state_99669__$1;
(statearr_99761_99850[(2)] = inst_99545);

(statearr_99761_99850[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (30))){
var state_99669__$1 = state_99669;
var statearr_99762_99851 = state_99669__$1;
(statearr_99762_99851[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_99762_99851[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (73))){
var inst_99644 = (state_99669[(11)]);
var inst_99645 = (state_99669[(55)]);
var inst_99659 = (state_99669[(2)]);
var inst_99660 = fluree.db.util.async.throw_err(inst_99659);
var inst_99589 = inst_99660;
var inst_99590 = inst_99645;
var inst_99591 = inst_99644;
var state_99669__$1 = (function (){var statearr_99763 = state_99669;
(statearr_99763[(15)] = inst_99591);

(statearr_99763[(18)] = inst_99589);

(statearr_99763[(17)] = inst_99590);

return statearr_99763;
})();
var statearr_99764_99852 = state_99669__$1;
(statearr_99764_99852[(2)] = null);

(statearr_99764_99852[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (10))){
var inst_99479 = (state_99669[(13)]);
var state_99669__$1 = state_99669;
var statearr_99765_99853 = state_99669__$1;
(statearr_99765_99853[(2)] = inst_99479);

(statearr_99765_99853[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (18))){
var inst_99481 = (state_99669[(37)]);
var state_99669__$1 = state_99669;
var statearr_99766_99854 = state_99669__$1;
(statearr_99766_99854[(2)] = inst_99481);

(statearr_99766_99854[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (52))){
var inst_99587 = (state_99669[(2)]);
var inst_99588 = fluree.db.util.async.throw_err(inst_99587);
var inst_99589 = inst_99588;
var inst_99590 = (0);
var inst_99591 = null;
var state_99669__$1 = (function (){var statearr_99767 = state_99669;
(statearr_99767[(15)] = inst_99591);

(statearr_99767[(18)] = inst_99589);

(statearr_99767[(17)] = inst_99590);

return statearr_99767;
})();
var statearr_99768_99855 = state_99669__$1;
(statearr_99768_99855[(2)] = null);

(statearr_99768_99855[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (67))){
var inst_99568 = (state_99669[(47)]);
var inst_99605 = (state_99669[(19)]);
var inst_99645 = (state_99669[(55)]);
var inst_99563 = (state_99669[(12)]);
var inst_99558 = (state_99669[(24)]);
var inst_99647 = (inst_99568.cljs$core$IFn$_invoke$arity$2 ? inst_99568.cljs$core$IFn$_invoke$arity$2(inst_99605,inst_99558) : inst_99568.call(null,inst_99605,inst_99558));
var inst_99648 = (inst_99647 < (0));
var inst_99649 = (inst_99645 < inst_99563);
var inst_99650 = ((inst_99648) && (inst_99649));
var state_99669__$1 = state_99669;
var statearr_99769_99856 = state_99669__$1;
(statearr_99769_99856[(2)] = inst_99650);

(statearr_99769_99856[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (71))){
var inst_99584 = (state_99669[(46)]);
var inst_99605 = (state_99669[(19)]);
var inst_99657 = fluree.db.dbproto._lookup_leaf(inst_99584,inst_99605);
var state_99669__$1 = state_99669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99669__$1,(73),inst_99657);
} else {
if((state_val_99670 === (42))){
var state_99669__$1 = state_99669;
var statearr_99770_99857 = state_99669__$1;
(statearr_99770_99857[(2)] = (2147483647));

(statearr_99770_99857[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (37))){
var state_99669__$1 = state_99669;
var statearr_99771_99858 = state_99669__$1;
(statearr_99771_99858[(2)] = (2147483647));

(statearr_99771_99858[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (63))){
var inst_99642 = (state_99669[(2)]);
var state_99669__$1 = state_99669;
var statearr_99772_99859 = state_99669__$1;
(statearr_99772_99859[(2)] = inst_99642);

(statearr_99772_99859[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (8))){
var inst_99489 = (state_99669[(2)]);
var inst_99490 = fluree.db.util.async.throw_err(inst_99489);
var state_99669__$1 = state_99669;
var statearr_99773_99860 = state_99669__$1;
(statearr_99773_99860[(2)] = inst_99490);

(statearr_99773_99860[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99670 === (49))){
var inst_99572 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_99669__$1 = state_99669;
var statearr_99774_99861 = state_99669__$1;
(statearr_99774_99861[(2)] = inst_99572);

(statearr_99774_99861[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$state_machine__99037__auto__ = null;
var fluree$db$query$range$state_machine__99037__auto____0 = (function (){
var statearr_99775 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99775[(0)] = fluree$db$query$range$state_machine__99037__auto__);

(statearr_99775[(1)] = (1));

return statearr_99775;
});
var fluree$db$query$range$state_machine__99037__auto____1 = (function (state_99669){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_99669);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e99776){if((e99776 instanceof Object)){
var ex__99040__auto__ = e99776;
var statearr_99777_99862 = state_99669;
(statearr_99777_99862[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99669);

return cljs.core.cst$kw$recur;
} else {
throw e99776;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__99863 = state_99669;
state_99669 = G__99863;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99037__auto__ = function(state_99669){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99037__auto____1.call(this,state_99669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99037__auto____0;
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99037__auto____1;
return fluree$db$query$range$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_99778 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_99778[(6)] = c__99059__auto__);

return statearr_99778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7;

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_99910){
var state_val_99911 = (state_99910[(1)]);
if((state_val_99911 === (7))){
var state_99910__$1 = state_99910;
var statearr_99912_99930 = state_99910__$1;
(statearr_99912_99930[(2)] = (0));

(statearr_99912_99930[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (1))){
var inst_99871 = cljs.core.seq(subject_groups);
var inst_99872 = cljs.core.first(inst_99871);
var inst_99873 = cljs.core.next(inst_99871);
var inst_99874 = cljs.core.PersistentVector.EMPTY;
var inst_99875 = subject_groups;
var inst_99876 = flake_start;
var inst_99877 = subject_start;
var inst_99878 = inst_99874;
var state_99910__$1 = (function (){var statearr_99913 = state_99910;
(statearr_99913[(7)] = inst_99877);

(statearr_99913[(8)] = inst_99872);

(statearr_99913[(9)] = inst_99878);

(statearr_99913[(10)] = inst_99873);

(statearr_99913[(11)] = inst_99876);

(statearr_99913[(12)] = inst_99875);

return statearr_99913;
})();
var statearr_99914_99931 = state_99910__$1;
(statearr_99914_99931[(2)] = null);

(statearr_99914_99931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (4))){
var inst_99877 = (state_99910[(7)]);
var inst_99878 = (state_99910[(9)]);
var inst_99876 = (state_99910[(11)]);
var inst_99891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_99892 = [inst_99876,inst_99877,inst_99878];
var inst_99893 = (new cljs.core.PersistentVector(null,3,(5),inst_99891,inst_99892,null));
var state_99910__$1 = state_99910;
var statearr_99915_99932 = state_99910__$1;
(statearr_99915_99932[(2)] = inst_99893);

(statearr_99915_99932[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (6))){
var inst_99906 = (state_99910[(2)]);
var state_99910__$1 = state_99910;
var statearr_99916_99933 = state_99910__$1;
(statearr_99916_99933[(2)] = inst_99906);

(statearr_99916_99933[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (3))){
var inst_99908 = (state_99910[(2)]);
var state_99910__$1 = state_99910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99910__$1,inst_99908);
} else {
if((state_val_99911 === (2))){
var inst_99877 = (state_99910[(7)]);
var inst_99884 = (state_99910[(13)]);
var inst_99876 = (state_99910[(11)]);
var inst_99875 = (state_99910[(12)]);
var inst_99883 = cljs.core.seq(inst_99875);
var inst_99884__$1 = cljs.core.first(inst_99883);
var inst_99885 = cljs.core.next(inst_99883);
var inst_99886 = (inst_99884__$1 == null);
var inst_99887 = (inst_99876 >= flake_limit);
var inst_99888 = (inst_99877 >= subject_limit);
var inst_99889 = ((inst_99886) || (inst_99887) || (inst_99888));
var state_99910__$1 = (function (){var statearr_99917 = state_99910;
(statearr_99917[(13)] = inst_99884__$1);

(statearr_99917[(14)] = inst_99885);

return statearr_99917;
})();
if(cljs.core.truth_(inst_99889)){
var statearr_99918_99934 = state_99910__$1;
(statearr_99918_99934[(1)] = (4));

} else {
var statearr_99919_99935 = state_99910__$1;
(statearr_99919_99935[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (9))){
var inst_99877 = (state_99910[(7)]);
var inst_99884 = (state_99910[(13)]);
var inst_99895 = (state_99910[(15)]);
var inst_99878 = (state_99910[(9)]);
var inst_99876 = (state_99910[(11)]);
var inst_99885 = (state_99910[(14)]);
var inst_99900 = (state_99910[(2)]);
var inst_99901 = (inst_99876 + inst_99895);
var inst_99902 = (inst_99877 + inst_99900);
var inst_99903 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_99878,inst_99884);
var inst_99875 = inst_99885;
var inst_99876__$1 = inst_99901;
var inst_99877__$1 = inst_99902;
var inst_99878__$1 = inst_99903;
var state_99910__$1 = (function (){var statearr_99920 = state_99910;
(statearr_99920[(7)] = inst_99877__$1);

(statearr_99920[(9)] = inst_99878__$1);

(statearr_99920[(11)] = inst_99876__$1);

(statearr_99920[(12)] = inst_99875);

return statearr_99920;
})();
var statearr_99921_99936 = state_99910__$1;
(statearr_99921_99936[(2)] = null);

(statearr_99921_99936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (5))){
var inst_99884 = (state_99910[(13)]);
var inst_99895 = (state_99910[(15)]);
var inst_99895__$1 = cljs.core.count(inst_99884);
var inst_99896 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_99895__$1);
var state_99910__$1 = (function (){var statearr_99922 = state_99910;
(statearr_99922[(15)] = inst_99895__$1);

return statearr_99922;
})();
if(inst_99896){
var statearr_99923_99937 = state_99910__$1;
(statearr_99923_99937[(1)] = (7));

} else {
var statearr_99924_99938 = state_99910__$1;
(statearr_99924_99938[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99911 === (8))){
var state_99910__$1 = state_99910;
var statearr_99925_99939 = state_99910__$1;
(statearr_99925_99939[(2)] = (1));

(statearr_99925_99939[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____0 = (function (){
var statearr_99926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_99926[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__);

(statearr_99926[(1)] = (1));

return statearr_99926;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____1 = (function (state_99910){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_99910);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e99927){if((e99927 instanceof Object)){
var ex__99040__auto__ = e99927;
var statearr_99928_99940 = state_99910;
(statearr_99928_99940[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99910);

return cljs.core.cst$kw$recur;
} else {
throw e99927;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__99941 = state_99910;
state_99910 = G__99941;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__ = function(state_99910){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____1.call(this,state_99910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_99929 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_99929[(6)] = c__99059__auto__);

return statearr_99929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_99981){
var state_val_99982 = (state_99981[(1)]);
if((state_val_99982 === (7))){
var inst_99977 = (state_99981[(2)]);
var state_99981__$1 = state_99981;
var statearr_99983_100008 = state_99981__$1;
(statearr_99983_100008[(2)] = inst_99977);


cljs.core.async.impl.ioc_helpers.process_exception(state_99981__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (1))){
var state_99981__$1 = state_99981;
var statearr_99984_100009 = state_99981__$1;
(statearr_99984_100009[(2)] = null);

(statearr_99984_100009[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_99981,(3),Error,null,(2));
var inst_99946 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_99981__$1 = state_99981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99981__$1,(5),inst_99946);
} else {
if((state_val_99982 === (15))){
var inst_99964 = (state_99981[(7)]);
var inst_99966 = fluree.db.dbproto._lookup_leaf(root_node,inst_99964);
var state_99981__$1 = state_99981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99981__$1,(18),inst_99966);
} else {
if((state_val_99982 === (13))){
var inst_99964 = (state_99981[(7)]);
var inst_99950 = (state_99981[(8)]);
var inst_99964__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_99950);
var state_99981__$1 = (function (){var statearr_99985 = state_99981;
(statearr_99985[(7)] = inst_99964__$1);

return statearr_99985;
})();
if(cljs.core.truth_(inst_99964__$1)){
var statearr_99986_100010 = state_99981__$1;
(statearr_99986_100010[(1)] = (15));

} else {
var statearr_99987_100011 = state_99981__$1;
(statearr_99987_100011[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (6))){
var state_99981__$1 = state_99981;
var statearr_99988_100012 = state_99981__$1;
(statearr_99988_100012[(2)] = null);

(statearr_99988_100012[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (17))){
var inst_99973 = (state_99981[(2)]);
var state_99981__$1 = state_99981;
var statearr_99989_100013 = state_99981__$1;
(statearr_99989_100013[(2)] = inst_99973);

(statearr_99989_100013[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (3))){
var inst_99942 = (state_99981[(2)]);
var state_99981__$1 = state_99981;
var statearr_99990_100014 = state_99981__$1;
(statearr_99990_100014[(2)] = inst_99942);


cljs.core.async.impl.ioc_helpers.process_exception(state_99981__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (12))){
var inst_99961 = (state_99981[(9)]);
var state_99981__$1 = state_99981;
var statearr_99991_100015 = state_99981__$1;
(statearr_99991_100015[(2)] = inst_99961);

(statearr_99991_100015[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (2))){
var inst_99979 = (state_99981[(2)]);
var state_99981__$1 = state_99981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_99981__$1,inst_99979);
} else {
if((state_val_99982 === (11))){
var inst_99958 = (state_99981[(2)]);
var inst_99959 = fluree.db.util.async.throw_err(inst_99958);
var state_99981__$1 = state_99981;
var statearr_99992_100016 = state_99981__$1;
(statearr_99992_100016[(2)] = inst_99959);


cljs.core.async.impl.ioc_helpers.process_exception(state_99981__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (9))){
var inst_99952 = (state_99981[(2)]);
var state_99981__$1 = (function (){var statearr_99993 = state_99981;
(statearr_99993[(10)] = inst_99952);

return statearr_99993;
})();
var statearr_99994_100017 = state_99981__$1;
(statearr_99994_100017[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_99981__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (5))){
var inst_99948 = (state_99981[(2)]);
var inst_99949 = fluree.db.util.async.throw_err(inst_99948);
var inst_99950 = inst_99949;
var state_99981__$1 = (function (){var statearr_99995 = state_99981;
(statearr_99995[(8)] = inst_99950);

return statearr_99995;
})();
var statearr_99996_100018 = state_99981__$1;
(statearr_99996_100018[(2)] = null);

(statearr_99996_100018[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (14))){
var inst_99975 = (state_99981[(2)]);
var state_99981__$1 = state_99981;
var statearr_99997_100019 = state_99981__$1;
(statearr_99997_100019[(2)] = inst_99975);

(statearr_99997_100019[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (16))){
var state_99981__$1 = state_99981;
var statearr_99998_100020 = state_99981__$1;
(statearr_99998_100020[(2)] = null);

(statearr_99998_100020[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (10))){
var inst_99950 = (state_99981[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_99981,(9),java.lang.Exception,null,(8));
var inst_99956 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_99950,t,novelty,fast_forward_db_QMARK_);
var state_99981__$1 = state_99981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_99981__$1,(11),inst_99956);
} else {
if((state_val_99982 === (18))){
var inst_99968 = (state_99981[(2)]);
var inst_99969 = fluree.db.util.async.throw_err(inst_99968);
var inst_99950 = inst_99969;
var state_99981__$1 = (function (){var statearr_99999 = state_99981;
(statearr_99999[(8)] = inst_99950);

return statearr_99999;
})();
var statearr_100000_100021 = state_99981__$1;
(statearr_100000_100021[(2)] = null);

(statearr_100000_100021[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_99982 === (8))){
var inst_99961 = (state_99981[(9)]);
var inst_99961__$1 = (state_99981[(2)]);
var state_99981__$1 = (function (){var statearr_100001 = state_99981;
(statearr_100001[(9)] = inst_99961__$1);

return statearr_100001;
})();
if(cljs.core.truth_(inst_99961__$1)){
var statearr_100002_100022 = state_99981__$1;
(statearr_100002_100022[(1)] = (12));

} else {
var statearr_100003_100023 = state_99981__$1;
(statearr_100003_100023[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____0 = (function (){
var statearr_100004 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_100004[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__);

(statearr_100004[(1)] = (1));

return statearr_100004;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____1 = (function (state_99981){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_99981);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e100005){if((e100005 instanceof Object)){
var ex__99040__auto__ = e100005;
var statearr_100006_100024 = state_99981;
(statearr_100006_100024[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_99981);

return cljs.core.cst$kw$recur;
} else {
throw e100005;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__100025 = state_99981;
state_99981 = G__100025;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__ = function(state_99981){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____1.call(this,state_99981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_100007 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_100007[(6)] = c__99059__auto__);

return statearr_100007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__100032 = arguments.length;
switch (G__100032) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__100033 = (function (){var pred__100036 = cljs.core.identical_QMARK_;
var expr__100037 = test;
if(cljs.core.truth_((pred__100036.cljs$core$IFn$_invoke$arity$2 ? pred__100036.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__100037) : pred__100036.call(null,cljs.core._EQ_,expr__100037)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__100036.cljs$core$IFn$_invoke$arity$2 ? pred__100036.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__100037) : pred__100036.call(null,cljs.core._LT_,expr__100037)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__100036.cljs$core$IFn$_invoke$arity$2 ? pred__100036.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__100037) : pred__100036.call(null,cljs.core._LT__EQ_,expr__100037)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__100036.cljs$core$IFn$_invoke$arity$2 ? pred__100036.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__100037) : pred__100036.call(null,cljs.core._GT_,expr__100037)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__100036.cljs$core$IFn$_invoke$arity$2 ? pred__100036.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__100037) : pred__100036.call(null,cljs.core._GT__EQ_,expr__100037)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__100037)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100033,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100033,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100033,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__100033,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_100430){
var state_val_100431 = (state_100430[(1)]);
if((state_val_100431 === (121))){
var inst_100403 = (state_100430[(7)]);
var inst_100403__$1 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100432 = state_100430;
(statearr_100432[(7)] = inst_100403__$1);

return statearr_100432;
})();
if(cljs.core.truth_(inst_100403__$1)){
var statearr_100433_100632 = state_100430__$1;
(statearr_100433_100632[(1)] = (122));

} else {
var statearr_100434_100633 = state_100430__$1;
(statearr_100434_100633[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (65))){
var inst_100199 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100435_100634 = state_100430__$1;
(statearr_100435_100634[(2)] = inst_100199);

(statearr_100435_100634[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (70))){
var state_100430__$1 = state_100430;
var statearr_100436_100635 = state_100430__$1;
(statearr_100436_100635[(2)] = false);

(statearr_100436_100635[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (62))){
var inst_100183 = (state_100430[(8)]);
var inst_100062 = (state_100430[(9)]);
var inst_100069 = (state_100430[(10)]);
var inst_100192 = (state_100430[(11)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100112 = (state_100430[(15)]);
var inst_100103 = (state_100430[(16)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100201__$1 = (state_100430[(2)]);
var inst_100202 = fluree.db.flake.__GT_Flake(inst_100103,inst_100174,inst_100156,inst_100061,inst_100062,inst_100192);
var inst_100203 = fluree.db.flake.__GT_Flake(inst_100112,inst_100183,inst_100165,inst_100068,inst_100069,inst_100201__$1);
var inst_100205 = (opts == null);
var inst_100206 = cljs.core.not(inst_100205);
var state_100430__$1 = (function (){var statearr_100437 = state_100430;
(statearr_100437[(20)] = inst_100203);

(statearr_100437[(21)] = inst_100202);

(statearr_100437[(18)] = inst_100201__$1);

return statearr_100437;
})();
if(inst_100206){
var statearr_100438_100636 = state_100430__$1;
(statearr_100438_100636[(1)] = (66));

} else {
var statearr_100439_100637 = state_100430__$1;
(statearr_100439_100637[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (74))){
var inst_100224 = (state_100430[(22)]);
var inst_100226 = (state_100430[(23)]);
var inst_100224__$1 = (state_100430[(2)]);
var inst_100225 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_100224__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_100226__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_100224__$1,cljs.core.cst$kw$limit);
var inst_100227 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_100224__$1,cljs.core.cst$kw$offset,(0));
var state_100430__$1 = (function (){var statearr_100440 = state_100430;
(statearr_100440[(22)] = inst_100224__$1);

(statearr_100440[(23)] = inst_100226__$1);

(statearr_100440[(24)] = inst_100225);

(statearr_100440[(25)] = inst_100227);

return statearr_100440;
})();
if(cljs.core.truth_(inst_100226__$1)){
var statearr_100441_100638 = state_100430__$1;
(statearr_100441_100638[(1)] = (75));

} else {
var statearr_100442_100639 = state_100430__$1;
(statearr_100442_100639[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (110))){
var inst_100258 = (state_100430[(26)]);
var inst_100325 = (state_100430[(27)]);
var inst_100257 = (state_100430[(28)]);
var inst_100231 = (state_100430[(29)]);
var inst_100225 = (state_100430[(24)]);
var inst_100374 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_100325,inst_100257,inst_100258,inst_100225,inst_100231);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(118),inst_100374);
} else {
if((state_val_100431 === (130))){
var inst_100393 = (state_100430[(30)]);
var inst_100392 = (state_100430[(31)]);
var inst_100411 = (state_100430[(32)]);
var inst_100391 = (state_100430[(33)]);
var inst_100394 = (state_100430[(34)]);
var inst_100255 = inst_100411;
var inst_100256 = inst_100391;
var inst_100257 = inst_100392;
var inst_100258 = inst_100393;
var inst_100259 = inst_100394;
var state_100430__$1 = (function (){var statearr_100443 = state_100430;
(statearr_100443[(26)] = inst_100258);

(statearr_100443[(35)] = inst_100256);

(statearr_100443[(36)] = inst_100255);

(statearr_100443[(28)] = inst_100257);

(statearr_100443[(37)] = inst_100259);

return statearr_100443;
})();
var statearr_100444_100640 = state_100430__$1;
(statearr_100444_100640[(2)] = null);

(statearr_100444_100640[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (128))){
var inst_100415 = (state_100430[(2)]);
var inst_100416 = cljs.core.not(inst_100415);
var state_100430__$1 = state_100430;
if(inst_100416){
var statearr_100445_100641 = state_100430__$1;
(statearr_100445_100641[(1)] = (129));

} else {
var statearr_100446_100642 = state_100430__$1;
(statearr_100446_100642[(1)] = (130));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (7))){
var inst_100086 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100086)){
var statearr_100447_100643 = state_100430__$1;
(statearr_100447_100643[(1)] = (11));

} else {
var statearr_100448_100644 = state_100430__$1;
(statearr_100448_100644[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (59))){
var inst_100190 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100449_100645 = state_100430__$1;
(statearr_100449_100645[(2)] = inst_100190);

(statearr_100449_100645[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (86))){
var inst_100265 = (state_100430[(38)]);
var state_100430__$1 = state_100430;
var statearr_100450_100646 = state_100430__$1;
(statearr_100450_100646[(2)] = inst_100265);

(statearr_100450_100646[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (20))){
var inst_100060 = (state_100430[(39)]);
var inst_100112 = (state_100430[(2)]);
var inst_100113 = cljs.core.boolean_QMARK_(inst_100060);
var state_100430__$1 = (function (){var statearr_100451 = state_100430;
(statearr_100451[(15)] = inst_100112);

return statearr_100451;
})();
if(inst_100113){
var statearr_100452_100647 = state_100430__$1;
(statearr_100452_100647[(1)] = (22));

} else {
var statearr_100453_100648 = state_100430__$1;
(statearr_100453_100648[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (72))){
var inst_100221 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_100430__$1 = state_100430;
var statearr_100454_100649 = state_100430__$1;
(statearr_100454_100649[(2)] = inst_100221);

(statearr_100454_100649[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (58))){
var state_100430__$1 = state_100430;
var statearr_100455_100650 = state_100430__$1;
(statearr_100455_100650[(2)] = (2147483647));

(statearr_100455_100650[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (60))){
var inst_100070 = (state_100430[(40)]);
var state_100430__$1 = state_100430;
var statearr_100456_100651 = state_100430__$1;
(statearr_100456_100651[(2)] = inst_100070);

(statearr_100456_100651[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (27))){
var inst_100124 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100457_100652 = state_100430__$1;
(statearr_100457_100652[(2)] = inst_100124);

(statearr_100457_100652[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (1))){
var state_100430__$1 = state_100430;
var statearr_100458_100653 = state_100430__$1;
(statearr_100458_100653[(2)] = null);

(statearr_100458_100653[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (69))){
var state_100430__$1 = state_100430;
var statearr_100459_100654 = state_100430__$1;
(statearr_100459_100654[(2)] = true);

(statearr_100459_100654[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (101))){
var inst_100294 = (state_100430[(41)]);
var state_100430__$1 = state_100430;
var statearr_100460_100655 = state_100430__$1;
(statearr_100460_100655[(2)] = inst_100294);

(statearr_100460_100655[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (24))){
var inst_100126 = (state_100430[(42)]);
var inst_100126__$1 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100461 = state_100430;
(statearr_100461[(42)] = inst_100126__$1);

return statearr_100461;
})();
if(cljs.core.truth_(inst_100126__$1)){
var statearr_100462_100656 = state_100430__$1;
(statearr_100462_100656[(1)] = (31));

} else {
var statearr_100463_100657 = state_100430__$1;
(statearr_100463_100657[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (102))){
var inst_100298 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100464_100658 = state_100430__$1;
(statearr_100464_100658[(2)] = inst_100298);

(statearr_100464_100658[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (55))){
var inst_100186 = (cljs.core._GT__EQ_ === start_test);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100186)){
var statearr_100465_100659 = state_100430__$1;
(statearr_100465_100659[(1)] = (57));

} else {
var statearr_100466_100660 = state_100430__$1;
(statearr_100466_100660[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (85))){
var inst_100183 = (state_100430[(8)]);
var inst_100147 = (state_100430[(43)]);
var inst_100258 = (state_100430[(26)]);
var inst_100143 = (state_100430[(44)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100237 = (state_100430[(46)]);
var inst_100093 = (state_100430[(47)]);
var inst_100242 = (state_100430[(48)]);
var inst_100203 = (state_100430[(20)]);
var inst_100256 = (state_100430[(35)]);
var inst_100069 = (state_100430[(10)]);
var inst_100255 = (state_100430[(36)]);
var inst_100257 = (state_100430[(28)]);
var inst_100232 = (state_100430[(49)]);
var inst_100243 = (state_100430[(50)]);
var inst_100224 = (state_100430[(22)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100202 = (state_100430[(21)]);
var inst_100144 = (state_100430[(53)]);
var inst_100192 = (state_100430[(11)]);
var inst_100238 = (state_100430[(54)]);
var inst_100265 = (state_100430[(38)]);
var inst_100231 = (state_100430[(29)]);
var inst_100233 = (state_100430[(55)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100252 = (state_100430[(56)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100225 = (state_100430[(24)]);
var inst_100248 = (state_100430[(58)]);
var inst_100259 = (state_100430[(37)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100269 = (function (){var no_filter_QMARK_ = true;
var t = inst_100238;
var max_limit_QMARK_ = inst_100232;
var next_node = inst_100255;
var fast_forward_db_QMARK_ = inst_100243;
var s1 = inst_100103;
var o2 = inst_100165;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var i = inst_100257;
var m1 = inst_100192;
var root_node = inst_100248;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100183;
var vec__100050 = inst_100143;
var G__100266 = inst_100265;
var map__100049 = inst_100091;
var permissions = inst_100233;
var limit = inst_100231;
var start_flake = inst_100202;
var flake_limit = inst_100225;
var offset = inst_100256;
var vec__100053 = inst_100144;
var acc = inst_100259;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100156;
var end_flake = inst_100203;
var base_result = inst_100265;
var s = inst_100258;
var node_start = inst_100252;
var p1 = inst_100174;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100147;
var map__100056 = inst_100224;
var idx_compare = inst_100237;
var op2 = inst_100069;
var m2 = inst_100201;
var novelty = inst_100242;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__){
return (function (p1__100026_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__100026_SHARP_.o,start_flake.o);
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__))
})();
var inst_100270 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_100269,inst_100265);
var state_100430__$1 = state_100430;
var statearr_100467_100661 = state_100430__$1;
(statearr_100467_100661[(2)] = inst_100270);

(statearr_100467_100661[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (39))){
var inst_100146 = (state_100430[(59)]);
var state_100430__$1 = state_100430;
var statearr_100468_100662 = state_100430__$1;
(statearr_100468_100662[(2)] = inst_100146);

(statearr_100468_100662[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (88))){
var inst_100183 = (state_100430[(8)]);
var inst_100147 = (state_100430[(43)]);
var inst_100258 = (state_100430[(26)]);
var inst_100143 = (state_100430[(44)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100237 = (state_100430[(46)]);
var inst_100093 = (state_100430[(47)]);
var inst_100242 = (state_100430[(48)]);
var inst_100203 = (state_100430[(20)]);
var inst_100273 = (state_100430[(60)]);
var inst_100256 = (state_100430[(35)]);
var inst_100069 = (state_100430[(10)]);
var inst_100255 = (state_100430[(36)]);
var inst_100257 = (state_100430[(28)]);
var inst_100232 = (state_100430[(49)]);
var inst_100243 = (state_100430[(50)]);
var inst_100224 = (state_100430[(22)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100202 = (state_100430[(21)]);
var inst_100144 = (state_100430[(53)]);
var inst_100192 = (state_100430[(11)]);
var inst_100238 = (state_100430[(54)]);
var inst_100265 = (state_100430[(38)]);
var inst_100231 = (state_100430[(29)]);
var inst_100233 = (state_100430[(55)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100252 = (state_100430[(56)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100225 = (state_100430[(24)]);
var inst_100248 = (state_100430[(58)]);
var inst_100259 = (state_100430[(37)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100275 = (function (){var no_filter_QMARK_ = true;
var t = inst_100238;
var max_limit_QMARK_ = inst_100232;
var next_node = inst_100255;
var fast_forward_db_QMARK_ = inst_100243;
var s1 = inst_100103;
var o2 = inst_100165;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var i = inst_100257;
var m1 = inst_100192;
var root_node = inst_100248;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100183;
var vec__100050 = inst_100143;
var G__100266 = inst_100273;
var map__100049 = inst_100091;
var permissions = inst_100233;
var limit = inst_100231;
var start_flake = inst_100202;
var flake_limit = inst_100225;
var offset = inst_100256;
var vec__100053 = inst_100144;
var acc = inst_100259;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100156;
var end_flake = inst_100203;
var base_result = inst_100265;
var s = inst_100258;
var node_start = inst_100252;
var p1 = inst_100174;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100147;
var map__100056 = inst_100224;
var idx_compare = inst_100237;
var op2 = inst_100069;
var m2 = inst_100201;
var novelty = inst_100242;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100273,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__){
return (function (p1__100027_SHARP_){
var G__100469 = p1__100027_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__100469) : subject_fn.call(null,G__100469));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100273,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__))
})();
var inst_100276 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_100275,inst_100273);
var state_100430__$1 = state_100430;
var statearr_100470_100663 = state_100430__$1;
(statearr_100470_100663[(2)] = inst_100276);

(statearr_100470_100663[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (46))){
var inst_100059 = (state_100430[(61)]);
var state_100430__$1 = state_100430;
var statearr_100471_100664 = state_100430__$1;
(statearr_100471_100664[(2)] = inst_100059);

(statearr_100471_100664[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (4))){
var inst_100057 = (state_100430[(52)]);
var inst_100064 = (state_100430[(57)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_100430,(3),Error,null,(2));
var inst_100057__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_100058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(0),null);
var inst_100059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(1),null);
var inst_100060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(2),null);
var inst_100061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(3),null);
var inst_100062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(4),null);
var inst_100063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100057__$1,(5),null);
var inst_100064__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_100065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(0),null);
var inst_100066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(1),null);
var inst_100067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(2),null);
var inst_100068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(3),null);
var inst_100069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(4),null);
var inst_100070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100064__$1,(5),null);
var inst_100072 = (opts == null);
var inst_100073 = cljs.core.not(inst_100072);
var state_100430__$1 = (function (){var statearr_100472 = state_100430;
(statearr_100472[(62)] = inst_100066);

(statearr_100472[(9)] = inst_100062);

(statearr_100472[(40)] = inst_100070);

(statearr_100472[(63)] = inst_100065);

(statearr_100472[(10)] = inst_100069);

(statearr_100472[(39)] = inst_100060);

(statearr_100472[(64)] = inst_100067);

(statearr_100472[(52)] = inst_100057__$1);

(statearr_100472[(65)] = inst_100058);

(statearr_100472[(66)] = inst_100063);

(statearr_100472[(61)] = inst_100059);

(statearr_100472[(12)] = inst_100068);

(statearr_100472[(14)] = inst_100061);

(statearr_100472[(57)] = inst_100064__$1);

return statearr_100472;
})();
if(inst_100073){
var statearr_100473_100665 = state_100430__$1;
(statearr_100473_100665[(1)] = (5));

} else {
var statearr_100474_100666 = state_100430__$1;
(statearr_100474_100666[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (77))){
var inst_100231 = (state_100430[(29)]);
var inst_100231__$1 = (state_100430[(2)]);
var inst_100232 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_100231__$1,fluree.db.util.core.max_long);
var inst_100233 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_100234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100235 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_100236 = (new cljs.core.PersistentVector(null,3,(5),inst_100234,inst_100235,null));
var inst_100237 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_100236);
var inst_100238 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_100239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100240 = [cljs.core.cst$kw$novelty,idx];
var inst_100241 = (new cljs.core.PersistentVector(null,2,(5),inst_100239,inst_100240,null));
var inst_100242 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_100241);
var inst_100243 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_100244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_100245 = fluree.db.dbproto._resolve(inst_100244);
var state_100430__$1 = (function (){var statearr_100475 = state_100430;
(statearr_100475[(46)] = inst_100237);

(statearr_100475[(48)] = inst_100242);

(statearr_100475[(49)] = inst_100232);

(statearr_100475[(50)] = inst_100243);

(statearr_100475[(54)] = inst_100238);

(statearr_100475[(29)] = inst_100231__$1);

(statearr_100475[(55)] = inst_100233);

return statearr_100475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(78),inst_100245);
} else {
if((state_val_100431 === (106))){
var inst_100258 = (state_100430[(26)]);
var inst_100256 = (state_100430[(35)]);
var inst_100257 = (state_100430[(28)]);
var inst_100314 = (state_100430[(67)]);
var inst_100259 = (state_100430[(37)]);
var inst_100317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100318 = (inst_100256 - inst_100314);
var inst_100319 = [inst_100318,inst_100257,inst_100258,inst_100259];
var inst_100320 = (new cljs.core.PersistentVector(null,4,(5),inst_100317,inst_100319,null));
var state_100430__$1 = state_100430;
var statearr_100476_100667 = state_100430__$1;
(statearr_100476_100667[(2)] = inst_100320);

(statearr_100476_100667[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (119))){
var inst_100393 = (state_100430[(30)]);
var inst_100237 = (state_100430[(46)]);
var inst_100392 = (state_100430[(31)]);
var inst_100203 = (state_100430[(20)]);
var inst_100231 = (state_100430[(29)]);
var inst_100292 = (state_100430[(68)]);
var inst_100225 = (state_100430[(24)]);
var inst_100396 = (inst_100237.cljs$core$IFn$_invoke$arity$2 ? inst_100237.cljs$core$IFn$_invoke$arity$2(inst_100292,inst_100203) : inst_100237.call(null,inst_100292,inst_100203));
var inst_100397 = (inst_100396 < (0));
var inst_100398 = (inst_100392 < inst_100225);
var inst_100399 = (inst_100393 < inst_100231);
var inst_100400 = ((inst_100397) && (inst_100398) && (inst_100399));
var state_100430__$1 = state_100430;
var statearr_100477_100668 = state_100430__$1;
(statearr_100477_100668[(2)] = inst_100400);

(statearr_100477_100668[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (95))){
var inst_100285 = (state_100430[(69)]);
var state_100430__$1 = state_100430;
var statearr_100478_100669 = state_100430__$1;
(statearr_100478_100669[(2)] = inst_100285);

(statearr_100478_100669[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (54))){
var inst_100063 = (state_100430[(66)]);
var state_100430__$1 = state_100430;
var statearr_100479_100670 = state_100430__$1;
(statearr_100479_100670[(2)] = inst_100063);

(statearr_100479_100670[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (92))){
var inst_100279 = (state_100430[(70)]);
var state_100430__$1 = state_100430;
var statearr_100480_100671 = state_100430__$1;
(statearr_100480_100671[(2)] = inst_100279);

(statearr_100480_100671[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (104))){
var inst_100183 = (state_100430[(8)]);
var inst_100147 = (state_100430[(43)]);
var inst_100258 = (state_100430[(26)]);
var inst_100143 = (state_100430[(44)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100237 = (state_100430[(46)]);
var inst_100093 = (state_100430[(47)]);
var inst_100242 = (state_100430[(48)]);
var inst_100203 = (state_100430[(20)]);
var inst_100256 = (state_100430[(35)]);
var inst_100069 = (state_100430[(10)]);
var inst_100255 = (state_100430[(36)]);
var inst_100257 = (state_100430[(28)]);
var inst_100232 = (state_100430[(49)]);
var inst_100243 = (state_100430[(50)]);
var inst_100224 = (state_100430[(22)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100202 = (state_100430[(21)]);
var inst_100144 = (state_100430[(53)]);
var inst_100192 = (state_100430[(11)]);
var inst_100238 = (state_100430[(54)]);
var inst_100265 = (state_100430[(38)]);
var inst_100314 = (state_100430[(67)]);
var inst_100231 = (state_100430[(29)]);
var inst_100233 = (state_100430[(55)]);
var inst_100291 = (state_100430[(71)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100252 = (state_100430[(56)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100292 = (state_100430[(68)]);
var inst_100225 = (state_100430[(24)]);
var inst_100248 = (state_100430[(58)]);
var inst_100313 = (state_100430[(72)]);
var inst_100259 = (state_100430[(37)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100312 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_100291;
var t = inst_100238;
var max_limit_QMARK_ = inst_100232;
var next_node = inst_100255;
var fast_forward_db_QMARK_ = inst_100243;
var s1 = inst_100103;
var o2 = inst_100165;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var i = inst_100257;
var rhs = inst_100292;
var m1 = inst_100192;
var root_node = inst_100248;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100183;
var vec__100050 = inst_100143;
var map__100049 = inst_100091;
var permissions = inst_100233;
var limit = inst_100231;
var start_flake = inst_100202;
var flake_limit = inst_100225;
var offset = inst_100256;
var vec__100053 = inst_100144;
var acc = inst_100259;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100156;
var end_flake = inst_100203;
var base_result = inst_100265;
var s = inst_100258;
var node_start = inst_100252;
var p1 = inst_100174;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100147;
var map__100056 = inst_100224;
var idx_compare = inst_100237;
var op2 = inst_100069;
var m2 = inst_100201;
var novelty = inst_100242;
return ((function (no_filter_QMARK_,base_result_SINGLEQUOTE_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,rhs,m1,root_node,vec__100043,s2,p2,vec__100050,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100314,inst_100231,inst_100233,inst_100291,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100292,inst_100225,inst_100248,inst_100313,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__){
return (function (p1__100030_SHARP_){
return p1__100030_SHARP_.s;
});
;})(no_filter_QMARK_,base_result_SINGLEQUOTE_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,rhs,m1,root_node,vec__100043,s2,p2,vec__100050,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100314,inst_100231,inst_100233,inst_100291,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100292,inst_100225,inst_100248,inst_100313,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__))
})();
var inst_100313__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_100312,inst_100291);
var inst_100314__$1 = cljs.core.count(inst_100313__$1);
var inst_100315 = (inst_100256 > inst_100314__$1);
var state_100430__$1 = (function (){var statearr_100481 = state_100430;
(statearr_100481[(67)] = inst_100314__$1);

(statearr_100481[(72)] = inst_100313__$1);

return statearr_100481;
})();
if(cljs.core.truth_(inst_100315)){
var statearr_100482_100672 = state_100430__$1;
(statearr_100482_100672[(1)] = (106));

} else {
var statearr_100483_100673 = state_100430__$1;
(statearr_100483_100673[(1)] = (107));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (15))){
var inst_100058 = (state_100430[(65)]);
var state_100430__$1 = state_100430;
var statearr_100484_100674 = state_100430__$1;
(statearr_100484_100674[(2)] = inst_100058);

(statearr_100484_100674[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (48))){
var inst_100165 = (state_100430[(17)]);
var state_100430__$1 = state_100430;
var statearr_100485_100675 = state_100430__$1;
(statearr_100485_100675[(2)] = inst_100165);

(statearr_100485_100675[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (50))){
var inst_100179 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100179)){
var statearr_100486_100676 = state_100430__$1;
(statearr_100486_100676[(1)] = (51));

} else {
var statearr_100487_100677 = state_100430__$1;
(statearr_100487_100677[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (116))){
var inst_100353 = (state_100430[(73)]);
var inst_100351 = (state_100430[(74)]);
var inst_100363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100364 = [inst_100353,inst_100351];
var inst_100365 = (new cljs.core.PersistentVector(null,2,(5),inst_100363,inst_100364,null));
var state_100430__$1 = state_100430;
var statearr_100488_100678 = state_100430__$1;
(statearr_100488_100678[(2)] = inst_100365);

(statearr_100488_100678[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (75))){
var inst_100226 = (state_100430[(23)]);
var state_100430__$1 = state_100430;
var statearr_100489_100679 = state_100430__$1;
(statearr_100489_100679[(2)] = inst_100226);

(statearr_100489_100679[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (99))){
var inst_100301 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100301)){
var statearr_100490_100680 = state_100430__$1;
(statearr_100490_100680[(1)] = (103));

} else {
var statearr_100491_100681 = state_100430__$1;
(statearr_100491_100681[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (21))){
var inst_100108 = (state_100430[(2)]);
var inst_100109 = fluree.db.util.async.throw_err(inst_100108);
var state_100430__$1 = state_100430;
var statearr_100492_100682 = state_100430__$1;
(statearr_100492_100682[(2)] = inst_100109);

(statearr_100492_100682[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (31))){
var inst_100066 = (state_100430[(62)]);
var inst_100126 = (state_100430[(42)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100093 = (state_100430[(47)]);
var inst_100070 = (state_100430[(40)]);
var inst_100069 = (state_100430[(10)]);
var inst_100060 = (state_100430[(39)]);
var inst_100067 = (state_100430[(64)]);
var inst_100094 = (state_100430[(75)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100063 = (state_100430[(66)]);
var inst_100059 = (state_100430[(61)]);
var inst_100068 = (state_100430[(12)]);
var inst_100061 = (state_100430[(14)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100130 = [null,null];
var inst_100131 = (new cljs.core.PersistentVector(null,2,(5),inst_100129,inst_100130,null));
var inst_100132 = (function (){var bool = inst_100126;
var temp__5733__auto__ = inst_100126;
var s1 = inst_100103;
var o2 = inst_100067;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var m1 = inst_100063;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100066;
var map__100049 = inst_100091;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100060;
var p1 = inst_100059;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100094;
var op2 = inst_100069;
var m2 = inst_100070;
return ((function (bool,temp__5733__auto__,s1,o2,t1,predicate_fn,m1,vec__100043,s2,p2,map__100049,t2,op1,o1,p1,vec__100046,subject_fn,object_fn,op2,m2,inst_100066,inst_100126,inst_100092,inst_100062,inst_100093,inst_100070,inst_100069,inst_100060,inst_100067,inst_100094,inst_100091,inst_100057,inst_100063,inst_100059,inst_100068,inst_100061,inst_100112,inst_100064,inst_100103,inst_100128,inst_100129,inst_100130,inst_100131,state_val_100431,c__99059__auto__){
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
;})(bool,temp__5733__auto__,s1,o2,t1,predicate_fn,m1,vec__100043,s2,p2,map__100049,t2,op1,o1,p1,vec__100046,subject_fn,object_fn,op2,m2,inst_100066,inst_100126,inst_100092,inst_100062,inst_100093,inst_100070,inst_100069,inst_100060,inst_100067,inst_100094,inst_100091,inst_100057,inst_100063,inst_100059,inst_100068,inst_100061,inst_100112,inst_100064,inst_100103,inst_100128,inst_100129,inst_100130,inst_100131,state_val_100431,c__99059__auto__))
})();
var inst_100133 = [inst_100131,inst_100132];
var inst_100134 = (new cljs.core.PersistentVector(null,2,(5),inst_100128,inst_100133,null));
var state_100430__$1 = state_100430;
var statearr_100493_100683 = state_100430__$1;
(statearr_100493_100683[(2)] = inst_100134);

(statearr_100493_100683[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (113))){
var inst_100334 = (state_100430[(76)]);
var inst_100343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100344 = [inst_100334,inst_100334];
var inst_100345 = (new cljs.core.PersistentVector(null,2,(5),inst_100343,inst_100344,null));
var state_100430__$1 = state_100430;
var statearr_100494_100684 = state_100430__$1;
(statearr_100494_100684[(2)] = inst_100345);

(statearr_100494_100684[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (32))){
var inst_100060 = (state_100430[(39)]);
var inst_100067 = (state_100430[(64)]);
var inst_100094 = (state_100430[(75)]);
var inst_100136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100138 = [inst_100060,inst_100067];
var inst_100139 = (new cljs.core.PersistentVector(null,2,(5),inst_100137,inst_100138,null));
var inst_100140 = [inst_100139,inst_100094];
var inst_100141 = (new cljs.core.PersistentVector(null,2,(5),inst_100136,inst_100140,null));
var state_100430__$1 = state_100430;
var statearr_100495_100685 = state_100430__$1;
(statearr_100495_100685[(2)] = inst_100141);

(statearr_100495_100685[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (40))){
var inst_100166 = (state_100430[(77)]);
var inst_100059 = (state_100430[(61)]);
var inst_100165 = (state_100430[(2)]);
var inst_100166__$1 = (inst_100059 == null);
var state_100430__$1 = (function (){var statearr_100496 = state_100430;
(statearr_100496[(77)] = inst_100166__$1);

(statearr_100496[(17)] = inst_100165);

return statearr_100496;
})();
if(cljs.core.truth_(inst_100166__$1)){
var statearr_100497_100686 = state_100430__$1;
(statearr_100497_100686[(1)] = (42));

} else {
var statearr_100498_100687 = state_100430__$1;
(statearr_100498_100687[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (129))){
var inst_100394 = (state_100430[(34)]);
var state_100430__$1 = state_100430;
var statearr_100499_100688 = state_100430__$1;
(statearr_100499_100688[(2)] = inst_100394);

(statearr_100499_100688[(1)] = (131));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (91))){
var inst_100183 = (state_100430[(8)]);
var inst_100147 = (state_100430[(43)]);
var inst_100258 = (state_100430[(26)]);
var inst_100143 = (state_100430[(44)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100237 = (state_100430[(46)]);
var inst_100093 = (state_100430[(47)]);
var inst_100242 = (state_100430[(48)]);
var inst_100203 = (state_100430[(20)]);
var inst_100256 = (state_100430[(35)]);
var inst_100069 = (state_100430[(10)]);
var inst_100255 = (state_100430[(36)]);
var inst_100257 = (state_100430[(28)]);
var inst_100232 = (state_100430[(49)]);
var inst_100243 = (state_100430[(50)]);
var inst_100224 = (state_100430[(22)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100202 = (state_100430[(21)]);
var inst_100144 = (state_100430[(53)]);
var inst_100192 = (state_100430[(11)]);
var inst_100238 = (state_100430[(54)]);
var inst_100279 = (state_100430[(70)]);
var inst_100265 = (state_100430[(38)]);
var inst_100231 = (state_100430[(29)]);
var inst_100233 = (state_100430[(55)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100252 = (state_100430[(56)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100225 = (state_100430[(24)]);
var inst_100248 = (state_100430[(58)]);
var inst_100259 = (state_100430[(37)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100281 = (function (){var no_filter_QMARK_ = true;
var t = inst_100238;
var max_limit_QMARK_ = inst_100232;
var next_node = inst_100255;
var fast_forward_db_QMARK_ = inst_100243;
var s1 = inst_100103;
var o2 = inst_100165;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var i = inst_100257;
var m1 = inst_100192;
var root_node = inst_100248;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100183;
var vec__100050 = inst_100143;
var G__100266 = inst_100279;
var map__100049 = inst_100091;
var permissions = inst_100233;
var limit = inst_100231;
var start_flake = inst_100202;
var flake_limit = inst_100225;
var offset = inst_100256;
var vec__100053 = inst_100144;
var acc = inst_100259;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100156;
var end_flake = inst_100203;
var base_result = inst_100265;
var s = inst_100258;
var node_start = inst_100252;
var p1 = inst_100174;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100147;
var map__100056 = inst_100224;
var idx_compare = inst_100237;
var op2 = inst_100069;
var m2 = inst_100201;
var novelty = inst_100242;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100279,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__){
return (function (p1__100028_SHARP_){
var G__100500 = p1__100028_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__100500) : predicate_fn.call(null,G__100500));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100279,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__))
})();
var inst_100282 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_100281,inst_100279);
var state_100430__$1 = state_100430;
var statearr_100501_100689 = state_100430__$1;
(statearr_100501_100689[(2)] = inst_100282);

(statearr_100501_100689[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (117))){
var inst_100348 = (state_100430[(78)]);
var inst_100367 = (state_100430[(2)]);
var inst_100368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100367,(0),null);
var inst_100369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100367,(1),null);
var inst_100370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100371 = [inst_100368,inst_100348,inst_100369];
var inst_100372 = (new cljs.core.PersistentVector(null,3,(5),inst_100370,inst_100371,null));
var state_100430__$1 = state_100430;
var statearr_100502_100690 = state_100430__$1;
(statearr_100502_100690[(2)] = inst_100372);

(statearr_100502_100690[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (108))){
var inst_100388 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100503_100691 = state_100430__$1;
(statearr_100503_100691[(2)] = inst_100388);

(statearr_100503_100691[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (56))){
var inst_100070 = (state_100430[(40)]);
var inst_100192 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100504 = state_100430;
(statearr_100504[(11)] = inst_100192);

return statearr_100504;
})();
if(cljs.core.truth_(inst_100070)){
var statearr_100505_100692 = state_100430__$1;
(statearr_100505_100692[(1)] = (60));

} else {
var statearr_100506_100693 = state_100430__$1;
(statearr_100506_100693[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (33))){
var inst_100143 = (state_100430[(44)]);
var inst_100144 = (state_100430[(53)]);
var inst_100145 = (state_100430[(79)]);
var inst_100143__$1 = (state_100430[(2)]);
var inst_100144__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100143__$1,(0),null);
var inst_100145__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100144__$1,(0),null);
var inst_100146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100144__$1,(1),null);
var inst_100147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100143__$1,(1),null);
var inst_100148 = fluree.db.util.core.pred_ident_QMARK_(inst_100145__$1);
var state_100430__$1 = (function (){var statearr_100507 = state_100430;
(statearr_100507[(43)] = inst_100147);

(statearr_100507[(59)] = inst_100146);

(statearr_100507[(44)] = inst_100143__$1);

(statearr_100507[(53)] = inst_100144__$1);

(statearr_100507[(79)] = inst_100145__$1);

return statearr_100507;
})();
if(inst_100148){
var statearr_100508_100694 = state_100430__$1;
(statearr_100508_100694[(1)] = (34));

} else {
var statearr_100509_100695 = state_100430__$1;
(statearr_100509_100695[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (13))){
var inst_100091 = (state_100430[(51)]);
var inst_100058 = (state_100430[(65)]);
var inst_100091__$1 = (state_100430[(2)]);
var inst_100092 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_100091__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_100093 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_100091__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_100094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_100091__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_100095 = fluree.db.util.core.pred_ident_QMARK_(inst_100058);
var state_100430__$1 = (function (){var statearr_100510 = state_100430;
(statearr_100510[(45)] = inst_100092);

(statearr_100510[(47)] = inst_100093);

(statearr_100510[(75)] = inst_100094);

(statearr_100510[(51)] = inst_100091__$1);

return statearr_100510;
})();
if(inst_100095){
var statearr_100511_100696 = state_100430__$1;
(statearr_100511_100696[(1)] = (14));

} else {
var statearr_100512_100697 = state_100430__$1;
(statearr_100512_100697[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (22))){
var inst_100060 = (state_100430[(39)]);
var state_100430__$1 = state_100430;
var statearr_100513_100698 = state_100430__$1;
(statearr_100513_100698[(2)] = inst_100060);

(statearr_100513_100698[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (90))){
var inst_100093 = (state_100430[(47)]);
var inst_100279 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100514 = state_100430;
(statearr_100514[(70)] = inst_100279);

return statearr_100514;
})();
if(cljs.core.truth_(inst_100093)){
var statearr_100515_100699 = state_100430__$1;
(statearr_100515_100699[(1)] = (91));

} else {
var statearr_100516_100700 = state_100430__$1;
(statearr_100516_100700[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (109))){
var inst_100258 = (state_100430[(26)]);
var inst_100325 = (state_100430[(27)]);
var inst_100333 = (state_100430[(80)]);
var inst_100335 = (state_100430[(81)]);
var inst_100334 = (state_100430[(76)]);
var inst_100231 = (state_100430[(29)]);
var inst_100333__$1 = cljs.core.count(inst_100325);
var inst_100334__$1 = (inst_100258 + inst_100333__$1);
var inst_100335__$1 = (inst_100334__$1 - inst_100231);
var inst_100336 = cljs.core.pos_int_QMARK_(inst_100335__$1);
var state_100430__$1 = (function (){var statearr_100517 = state_100430;
(statearr_100517[(80)] = inst_100333__$1);

(statearr_100517[(81)] = inst_100335__$1);

(statearr_100517[(76)] = inst_100334__$1);

return statearr_100517;
})();
if(inst_100336){
var statearr_100518_100701 = state_100430__$1;
(statearr_100518_100701[(1)] = (112));

} else {
var statearr_100519_100702 = state_100430__$1;
(statearr_100519_100702[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (36))){
var inst_100146 = (state_100430[(59)]);
var inst_100156 = (state_100430[(2)]);
var inst_100157 = fluree.db.util.core.pred_ident_QMARK_(inst_100146);
var state_100430__$1 = (function (){var statearr_100520 = state_100430;
(statearr_100520[(13)] = inst_100156);

return statearr_100520;
})();
if(inst_100157){
var statearr_100521_100703 = state_100430__$1;
(statearr_100521_100703[(1)] = (38));

} else {
var statearr_100522_100704 = state_100430__$1;
(statearr_100522_100704[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (41))){
var inst_100161 = (state_100430[(2)]);
var inst_100162 = fluree.db.util.async.throw_err(inst_100161);
var state_100430__$1 = state_100430;
var statearr_100523_100705 = state_100430__$1;
(statearr_100523_100705[(2)] = inst_100162);

(statearr_100523_100705[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (118))){
var inst_100376 = (state_100430[(2)]);
var inst_100377 = fluree.db.util.async.throw_err(inst_100376);
var state_100430__$1 = state_100430;
var statearr_100524_100706 = state_100430__$1;
(statearr_100524_100706[(2)] = inst_100377);

(statearr_100524_100706[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (89))){
var inst_100273 = (state_100430[(60)]);
var state_100430__$1 = state_100430;
var statearr_100525_100707 = state_100430__$1;
(statearr_100525_100707[(2)] = inst_100273);

(statearr_100525_100707[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (100))){
var state_100430__$1 = state_100430;
var statearr_100526_100708 = state_100430__$1;
(statearr_100526_100708[(2)] = true);

(statearr_100526_100708[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (131))){
var inst_100421 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100527_100709 = state_100430__$1;
(statearr_100527_100709[(2)] = inst_100421);

(statearr_100527_100709[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (122))){
var inst_100242 = (state_100430[(48)]);
var inst_100243 = (state_100430[(50)]);
var inst_100238 = (state_100430[(54)]);
var inst_100292 = (state_100430[(68)]);
var inst_100248 = (state_100430[(58)]);
var inst_100405 = fluree.db.query.range.find_next_valid_node(inst_100248,inst_100292,inst_100238,inst_100242,inst_100243);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(125),inst_100405);
} else {
if((state_val_100431 === (43))){
var inst_100166 = (state_100430[(77)]);
var state_100430__$1 = state_100430;
var statearr_100528_100710 = state_100430__$1;
(statearr_100528_100710[(2)] = inst_100166);

(statearr_100528_100710[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (61))){
var inst_100195 = (cljs.core._LT__EQ_ === end_test);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100195)){
var statearr_100529_100711 = state_100430__$1;
(statearr_100529_100711[(1)] = (63));

} else {
var statearr_100530_100712 = state_100430__$1;
(statearr_100530_100712[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (29))){
var state_100430__$1 = state_100430;
var statearr_100531_100713 = state_100430__$1;
(statearr_100531_100713[(2)] = null);

(statearr_100531_100713[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (44))){
var inst_100170 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100170)){
var statearr_100532_100714 = state_100430__$1;
(statearr_100532_100714[(1)] = (45));

} else {
var statearr_100533_100715 = state_100430__$1;
(statearr_100533_100715[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (93))){
var inst_100147 = (state_100430[(43)]);
var inst_100285 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100534 = state_100430;
(statearr_100534[(69)] = inst_100285);

return statearr_100534;
})();
if(cljs.core.truth_(inst_100147)){
var statearr_100535_100716 = state_100430__$1;
(statearr_100535_100716[(1)] = (94));

} else {
var statearr_100536_100717 = state_100430__$1;
(statearr_100536_100717[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (6))){
var state_100430__$1 = state_100430;
var statearr_100537_100718 = state_100430__$1;
(statearr_100537_100718[(2)] = false);

(statearr_100537_100718[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (111))){
var inst_100259 = (state_100430[(37)]);
var inst_100379 = (state_100430[(2)]);
var inst_100380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100379,(0),null);
var inst_100381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100379,(1),null);
var inst_100382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100379,(2),null);
var inst_100383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100384 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_100259,inst_100382);
var inst_100385 = [(0),inst_100380,inst_100381,inst_100384];
var inst_100386 = (new cljs.core.PersistentVector(null,4,(5),inst_100383,inst_100385,null));
var state_100430__$1 = state_100430;
var statearr_100538_100719 = state_100430__$1;
(statearr_100538_100719[(2)] = inst_100386);

(statearr_100538_100719[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (28))){
var state_100430__$1 = state_100430;
var statearr_100539_100720 = state_100430__$1;
(statearr_100539_100720[(2)] = null);

(statearr_100539_100720[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (64))){
var state_100430__$1 = state_100430;
var statearr_100540_100721 = state_100430__$1;
(statearr_100540_100721[(2)] = fluree.db.util.core.min_integer);

(statearr_100540_100721[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (103))){
var inst_100258 = (state_100430[(26)]);
var inst_100257 = (state_100430[(28)]);
var inst_100291 = (state_100430[(71)]);
var inst_100225 = (state_100430[(24)]);
var inst_100259 = (state_100430[(37)]);
var inst_100303 = cljs.core.count(inst_100291);
var inst_100304 = (inst_100225 - inst_100257);
var inst_100305 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_100304,inst_100291);
var inst_100306 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_100259,inst_100305);
var inst_100307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100308 = (inst_100257 + inst_100303);
var inst_100309 = [(0),inst_100308,inst_100258,inst_100306];
var inst_100310 = (new cljs.core.PersistentVector(null,4,(5),inst_100307,inst_100309,null));
var state_100430__$1 = state_100430;
var statearr_100541_100722 = state_100430__$1;
(statearr_100541_100722[(2)] = inst_100310);

(statearr_100541_100722[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (51))){
var state_100430__$1 = state_100430;
var statearr_100542_100723 = state_100430__$1;
(statearr_100542_100723[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_100542_100723[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (25))){
var inst_100067 = (state_100430[(64)]);
var state_100430__$1 = state_100430;
var statearr_100543_100724 = state_100430__$1;
(statearr_100543_100724[(2)] = inst_100067);

(statearr_100543_100724[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (34))){
var inst_100145 = (state_100430[(79)]);
var inst_100150 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_100145);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(37),inst_100150);
} else {
if((state_val_100431 === (125))){
var inst_100407 = (state_100430[(2)]);
var inst_100408 = fluree.db.util.async.throw_err(inst_100407);
var state_100430__$1 = state_100430;
var statearr_100544_100725 = state_100430__$1;
(statearr_100544_100725[(2)] = inst_100408);

(statearr_100544_100725[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (17))){
var inst_100099 = (state_100430[(2)]);
var inst_100100 = fluree.db.util.async.throw_err(inst_100099);
var state_100430__$1 = state_100430;
var statearr_100545_100726 = state_100430__$1;
(statearr_100545_100726[(2)] = inst_100100);

(statearr_100545_100726[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (3))){
var inst_100039 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100546_100727 = state_100430__$1;
(statearr_100546_100727[(2)] = inst_100039);


cljs.core.async.impl.ioc_helpers.process_exception(state_100430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (12))){
var state_100430__$1 = state_100430;
var statearr_100547_100728 = state_100430__$1;
(statearr_100547_100728[(2)] = opts);

(statearr_100547_100728[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (2))){
var inst_100428 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100430__$1,inst_100428);
} else {
if((state_val_100431 === (66))){
var inst_100208 = opts.cljs$lang$protocol_mask$partition0$;
var inst_100209 = (inst_100208 & (64));
var inst_100210 = opts.cljs$core$ISeq$;
var inst_100211 = (cljs.core.PROTOCOL_SENTINEL === inst_100210);
var inst_100212 = ((inst_100209) || (inst_100211));
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100212)){
var statearr_100548_100729 = state_100430__$1;
(statearr_100548_100729[(1)] = (69));

} else {
var statearr_100549_100730 = state_100430__$1;
(statearr_100549_100730[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (107))){
var inst_100256 = (state_100430[(35)]);
var inst_100313 = (state_100430[(72)]);
var inst_100325 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_100256,inst_100313);
var state_100430__$1 = (function (){var statearr_100550 = state_100430;
(statearr_100550[(27)] = inst_100325);

return statearr_100550;
})();
var statearr_100551_100731 = state_100430__$1;
(statearr_100551_100731[(1)] = (109));



return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (23))){
var inst_100067 = (state_100430[(64)]);
var inst_100116 = cljs.core.boolean_QMARK_(inst_100067);
var state_100430__$1 = state_100430;
if(inst_100116){
var statearr_100553_100732 = state_100430__$1;
(statearr_100553_100732[(1)] = (25));

} else {
var statearr_100554_100733 = state_100430__$1;
(statearr_100554_100733[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (47))){
var inst_100066 = (state_100430[(62)]);
var inst_100175 = (state_100430[(82)]);
var inst_100174 = (state_100430[(2)]);
var inst_100175__$1 = (inst_100066 == null);
var state_100430__$1 = (function (){var statearr_100555 = state_100430;
(statearr_100555[(82)] = inst_100175__$1);

(statearr_100555[(19)] = inst_100174);

return statearr_100555;
})();
if(cljs.core.truth_(inst_100175__$1)){
var statearr_100556_100734 = state_100430__$1;
(statearr_100556_100734[(1)] = (48));

} else {
var statearr_100557_100735 = state_100430__$1;
(statearr_100557_100735[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (35))){
var inst_100145 = (state_100430[(79)]);
var state_100430__$1 = state_100430;
var statearr_100558_100736 = state_100430__$1;
(statearr_100558_100736[(2)] = inst_100145);

(statearr_100558_100736[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (127))){
var inst_100403 = (state_100430[(7)]);
var state_100430__$1 = state_100430;
var statearr_100559_100737 = state_100430__$1;
(statearr_100559_100737[(2)] = inst_100403);

(statearr_100559_100737[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (82))){
var inst_100426 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100560_100738 = state_100430__$1;
(statearr_100560_100738[(2)] = inst_100426);


cljs.core.async.impl.ioc_helpers.process_exception(state_100430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (76))){
var state_100430__$1 = state_100430;
var statearr_100561_100739 = state_100430__$1;
(statearr_100561_100739[(2)] = fluree.db.util.core.max_long);

(statearr_100561_100739[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (97))){
var inst_100256 = (state_100430[(35)]);
var inst_100294 = (state_100430[(41)]);
var inst_100294__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_100256);
var state_100430__$1 = (function (){var statearr_100562 = state_100430;
(statearr_100562[(41)] = inst_100294__$1);

return statearr_100562;
})();
if(inst_100294__$1){
var statearr_100563_100740 = state_100430__$1;
(statearr_100563_100740[(1)] = (100));

} else {
var statearr_100564_100741 = state_100430__$1;
(statearr_100564_100741[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (19))){
var inst_100065 = (state_100430[(63)]);
var state_100430__$1 = state_100430;
var statearr_100565_100742 = state_100430__$1;
(statearr_100565_100742[(2)] = inst_100065);

(statearr_100565_100742[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (57))){
var state_100430__$1 = state_100430;
var statearr_100566_100743 = state_100430__$1;
(statearr_100566_100743[(2)] = fluree.db.util.core.min_integer);

(statearr_100566_100743[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (68))){
var inst_100219 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100219)){
var statearr_100567_100744 = state_100430__$1;
(statearr_100567_100744[(1)] = (72));

} else {
var statearr_100568_100745 = state_100430__$1;
(statearr_100568_100745[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (11))){
var inst_100088 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_100430__$1 = state_100430;
var statearr_100569_100746 = state_100430__$1;
(statearr_100569_100746[(2)] = inst_100088);

(statearr_100569_100746[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (115))){
var inst_100352 = (state_100430[(83)]);
var inst_100353 = (state_100430[(73)]);
var inst_100351 = (state_100430[(74)]);
var inst_100225 = (state_100430[(24)]);
var inst_100356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100357 = (inst_100353 - inst_100225);
var inst_100358 = (inst_100352 - inst_100357);
var inst_100359 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_100358,inst_100351);
var inst_100360 = [inst_100225,inst_100359];
var inst_100361 = (new cljs.core.PersistentVector(null,2,(5),inst_100356,inst_100360,null));
var state_100430__$1 = state_100430;
var statearr_100570_100747 = state_100430__$1;
(statearr_100570_100747[(2)] = inst_100361);

(statearr_100570_100747[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (9))){
var state_100430__$1 = state_100430;
var statearr_100571_100748 = state_100430__$1;
(statearr_100571_100748[(2)] = false);

(statearr_100571_100748[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (5))){
var inst_100075 = opts.cljs$lang$protocol_mask$partition0$;
var inst_100076 = (inst_100075 & (64));
var inst_100077 = opts.cljs$core$ISeq$;
var inst_100078 = (cljs.core.PROTOCOL_SENTINEL === inst_100077);
var inst_100079 = ((inst_100076) || (inst_100078));
var state_100430__$1 = state_100430;
if(cljs.core.truth_(inst_100079)){
var statearr_100572_100749 = state_100430__$1;
(statearr_100572_100749[(1)] = (8));

} else {
var statearr_100573_100750 = state_100430__$1;
(statearr_100573_100750[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (112))){
var inst_100333 = (state_100430[(80)]);
var inst_100335 = (state_100430[(81)]);
var inst_100231 = (state_100430[(29)]);
var inst_100338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100339 = (inst_100333 - inst_100335);
var inst_100340 = [inst_100231,inst_100339];
var inst_100341 = (new cljs.core.PersistentVector(null,2,(5),inst_100338,inst_100340,null));
var state_100430__$1 = state_100430;
var statearr_100574_100751 = state_100430__$1;
(statearr_100574_100751[(2)] = inst_100341);

(statearr_100574_100751[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (83))){
var inst_100203 = (state_100430[(20)]);
var inst_100255 = (state_100430[(36)]);
var inst_100202 = (state_100430[(21)]);
var inst_100264 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_100255);
var inst_100265 = fluree.db.flake.subrange(inst_100264,start_test,inst_100202,end_test,inst_100203);
var inst_100267 = fluree.db.query.range.value_with_nil_pred(idx,inst_100202,inst_100203);
var state_100430__$1 = (function (){var statearr_100575 = state_100430;
(statearr_100575[(38)] = inst_100265);

return statearr_100575;
})();
if(inst_100267){
var statearr_100576_100752 = state_100430__$1;
(statearr_100576_100752[(1)] = (85));

} else {
var statearr_100577_100753 = state_100430__$1;
(statearr_100577_100753[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (14))){
var inst_100058 = (state_100430[(65)]);
var inst_100097 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_100058);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(17),inst_100097);
} else {
if((state_val_100431 === (45))){
var state_100430__$1 = state_100430;
var statearr_100578_100754 = state_100430__$1;
(statearr_100578_100754[(2)] = (-1));

(statearr_100578_100754[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (53))){
var inst_100063 = (state_100430[(66)]);
var inst_100183 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100579 = state_100430;
(statearr_100579[(8)] = inst_100183);

return statearr_100579;
})();
if(cljs.core.truth_(inst_100063)){
var statearr_100580_100755 = state_100430__$1;
(statearr_100580_100755[(1)] = (54));

} else {
var statearr_100581_100756 = state_100430__$1;
(statearr_100581_100756[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (78))){
var inst_100242 = (state_100430[(48)]);
var inst_100243 = (state_100430[(50)]);
var inst_100202 = (state_100430[(21)]);
var inst_100238 = (state_100430[(54)]);
var inst_100248 = (state_100430[(58)]);
var inst_100247 = (state_100430[(2)]);
var inst_100248__$1 = fluree.db.util.async.throw_err(inst_100247);
var inst_100249 = fluree.db.query.range.find_next_valid_node(inst_100248__$1,inst_100202,inst_100238,inst_100242,inst_100243);
var state_100430__$1 = (function (){var statearr_100582 = state_100430;
(statearr_100582[(58)] = inst_100248__$1);

return statearr_100582;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(79),inst_100249);
} else {
if((state_val_100431 === (26))){
var state_100430__$1 = state_100430;
var statearr_100583_100757 = state_100430__$1;
(statearr_100583_100757[(1)] = (28));



return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (123))){
var state_100430__$1 = state_100430;
var statearr_100585_100758 = state_100430__$1;
(statearr_100585_100758[(2)] = null);

(statearr_100585_100758[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (16))){
var inst_100065 = (state_100430[(63)]);
var inst_100103 = (state_100430[(2)]);
var inst_100104 = fluree.db.util.core.pred_ident_QMARK_(inst_100065);
var state_100430__$1 = (function (){var statearr_100586 = state_100430;
(statearr_100586[(16)] = inst_100103);

return statearr_100586;
})();
if(inst_100104){
var statearr_100587_100759 = state_100430__$1;
(statearr_100587_100759[(1)] = (18));

} else {
var statearr_100588_100760 = state_100430__$1;
(statearr_100588_100760[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (81))){
var state_100430__$1 = state_100430;
var statearr_100589_100761 = state_100430__$1;
(statearr_100589_100761[(2)] = null);

(statearr_100589_100761[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (120))){
var inst_100292 = (state_100430[(68)]);
var state_100430__$1 = state_100430;
var statearr_100590_100762 = state_100430__$1;
(statearr_100590_100762[(2)] = inst_100292);

(statearr_100590_100762[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (79))){
var inst_100252 = (state_100430[(56)]);
var inst_100251 = (state_100430[(2)]);
var inst_100252__$1 = fluree.db.util.async.throw_err(inst_100251);
var state_100430__$1 = (function (){var statearr_100591 = state_100430;
(statearr_100591[(56)] = inst_100252__$1);

return statearr_100591;
})();
if(cljs.core.truth_(inst_100252__$1)){
var statearr_100592_100763 = state_100430__$1;
(statearr_100592_100763[(1)] = (80));

} else {
var statearr_100593_100764 = state_100430__$1;
(statearr_100593_100764[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (38))){
var inst_100146 = (state_100430[(59)]);
var inst_100159 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_100146);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(41),inst_100159);
} else {
if((state_val_100431 === (126))){
var inst_100411 = (state_100430[(32)]);
var state_100430__$1 = state_100430;
var statearr_100594_100765 = state_100430__$1;
(statearr_100594_100765[(2)] = inst_100411);

(statearr_100594_100765[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (98))){
var inst_100232 = (state_100430[(49)]);
var state_100430__$1 = state_100430;
var statearr_100595_100766 = state_100430__$1;
(statearr_100595_100766[(2)] = inst_100232);

(statearr_100595_100766[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (124))){
var inst_100403 = (state_100430[(7)]);
var inst_100411 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100596 = state_100430;
(statearr_100596[(32)] = inst_100411);

return statearr_100596;
})();
if(cljs.core.truth_(inst_100403)){
var statearr_100597_100767 = state_100430__$1;
(statearr_100597_100767[(1)] = (126));

} else {
var statearr_100598_100768 = state_100430__$1;
(statearr_100598_100768[(1)] = (127));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (87))){
var inst_100092 = (state_100430[(45)]);
var inst_100273 = (state_100430[(2)]);
var state_100430__$1 = (function (){var statearr_100599 = state_100430;
(statearr_100599[(60)] = inst_100273);

return statearr_100599;
})();
if(cljs.core.truth_(inst_100092)){
var statearr_100600_100769 = state_100430__$1;
(statearr_100600_100769[(1)] = (88));

} else {
var statearr_100601_100770 = state_100430__$1;
(statearr_100601_100770[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (30))){
var inst_100122 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100602_100771 = state_100430__$1;
(statearr_100602_100771[(2)] = inst_100122);

(statearr_100602_100771[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (73))){
var state_100430__$1 = state_100430;
var statearr_100603_100772 = state_100430__$1;
(statearr_100603_100772[(2)] = opts);

(statearr_100603_100772[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (96))){
var inst_100255 = (state_100430[(36)]);
var inst_100232 = (state_100430[(49)]);
var inst_100291 = (state_100430[(2)]);
var inst_100292 = fluree.db.dbproto._rhs(inst_100255);
var state_100430__$1 = (function (){var statearr_100604 = state_100430;
(statearr_100604[(71)] = inst_100291);

(statearr_100604[(68)] = inst_100292);

return statearr_100604;
})();
if(cljs.core.truth_(inst_100232)){
var statearr_100605_100773 = state_100430__$1;
(statearr_100605_100773[(1)] = (97));

} else {
var statearr_100606_100774 = state_100430__$1;
(statearr_100606_100774[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (10))){
var inst_100083 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100607_100775 = state_100430__$1;
(statearr_100607_100775[(2)] = inst_100083);

(statearr_100607_100775[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (18))){
var inst_100065 = (state_100430[(63)]);
var inst_100106 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_100065);
var state_100430__$1 = state_100430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100430__$1,(21),inst_100106);
} else {
if((state_val_100431 === (105))){
var inst_100292 = (state_100430[(68)]);
var inst_100390 = (state_100430[(2)]);
var inst_100391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100390,(0),null);
var inst_100392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100390,(1),null);
var inst_100393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100390,(2),null);
var inst_100394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100390,(3),null);
var state_100430__$1 = (function (){var statearr_100608 = state_100430;
(statearr_100608[(30)] = inst_100393);

(statearr_100608[(31)] = inst_100392);

(statearr_100608[(33)] = inst_100391);

(statearr_100608[(34)] = inst_100394);

return statearr_100608;
})();
if(cljs.core.truth_(inst_100292)){
var statearr_100609_100776 = state_100430__$1;
(statearr_100609_100776[(1)] = (119));

} else {
var statearr_100610_100777 = state_100430__$1;
(statearr_100610_100777[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (52))){
var inst_100066 = (state_100430[(62)]);
var state_100430__$1 = state_100430;
var statearr_100611_100778 = state_100430__$1;
(statearr_100611_100778[(2)] = inst_100066);

(statearr_100611_100778[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (114))){
var inst_100352 = (state_100430[(83)]);
var inst_100325 = (state_100430[(27)]);
var inst_100353 = (state_100430[(73)]);
var inst_100351 = (state_100430[(74)]);
var inst_100257 = (state_100430[(28)]);
var inst_100225 = (state_100430[(24)]);
var inst_100347 = (state_100430[(2)]);
var inst_100348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100347,(0),null);
var inst_100349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100347,(1),null);
var inst_100350 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_100349,inst_100325);
var inst_100351__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_100350);
var inst_100352__$1 = cljs.core.count(inst_100351__$1);
var inst_100353__$1 = (inst_100257 + inst_100352__$1);
var inst_100354 = (inst_100353__$1 > inst_100225);
var state_100430__$1 = (function (){var statearr_100612 = state_100430;
(statearr_100612[(78)] = inst_100348);

(statearr_100612[(83)] = inst_100352__$1);

(statearr_100612[(73)] = inst_100353__$1);

(statearr_100612[(74)] = inst_100351__$1);

return statearr_100612;
})();
if(cljs.core.truth_(inst_100354)){
var statearr_100613_100779 = state_100430__$1;
(statearr_100613_100779[(1)] = (115));

} else {
var statearr_100614_100780 = state_100430__$1;
(statearr_100614_100780[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (67))){
var state_100430__$1 = state_100430;
var statearr_100615_100781 = state_100430__$1;
(statearr_100615_100781[(2)] = false);

(statearr_100615_100781[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (71))){
var inst_100216 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100616_100782 = state_100430__$1;
(statearr_100616_100782[(2)] = inst_100216);

(statearr_100616_100782[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (42))){
var inst_100156 = (state_100430[(13)]);
var state_100430__$1 = state_100430;
var statearr_100617_100783 = state_100430__$1;
(statearr_100617_100783[(2)] = inst_100156);

(statearr_100617_100783[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (80))){
var inst_100252 = (state_100430[(56)]);
var inst_100227 = (state_100430[(25)]);
var inst_100254 = cljs.core.PersistentVector.EMPTY;
var inst_100255 = inst_100252;
var inst_100256 = inst_100227;
var inst_100257 = (0);
var inst_100258 = (0);
var inst_100259 = inst_100254;
var state_100430__$1 = (function (){var statearr_100618 = state_100430;
(statearr_100618[(26)] = inst_100258);

(statearr_100618[(35)] = inst_100256);

(statearr_100618[(36)] = inst_100255);

(statearr_100618[(28)] = inst_100257);

(statearr_100618[(37)] = inst_100259);

return statearr_100618;
})();
var statearr_100619_100784 = state_100430__$1;
(statearr_100619_100784[(2)] = null);

(statearr_100619_100784[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (37))){
var inst_100152 = (state_100430[(2)]);
var inst_100153 = fluree.db.util.async.throw_err(inst_100152);
var state_100430__$1 = state_100430;
var statearr_100620_100785 = state_100430__$1;
(statearr_100620_100785[(2)] = inst_100153);

(statearr_100620_100785[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (63))){
var state_100430__$1 = state_100430;
var statearr_100621_100786 = state_100430__$1;
(statearr_100621_100786[(2)] = (2147483647));

(statearr_100621_100786[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (94))){
var inst_100183 = (state_100430[(8)]);
var inst_100147 = (state_100430[(43)]);
var inst_100285 = (state_100430[(69)]);
var inst_100258 = (state_100430[(26)]);
var inst_100143 = (state_100430[(44)]);
var inst_100092 = (state_100430[(45)]);
var inst_100062 = (state_100430[(9)]);
var inst_100237 = (state_100430[(46)]);
var inst_100093 = (state_100430[(47)]);
var inst_100242 = (state_100430[(48)]);
var inst_100203 = (state_100430[(20)]);
var inst_100256 = (state_100430[(35)]);
var inst_100069 = (state_100430[(10)]);
var inst_100255 = (state_100430[(36)]);
var inst_100257 = (state_100430[(28)]);
var inst_100232 = (state_100430[(49)]);
var inst_100243 = (state_100430[(50)]);
var inst_100224 = (state_100430[(22)]);
var inst_100091 = (state_100430[(51)]);
var inst_100057 = (state_100430[(52)]);
var inst_100202 = (state_100430[(21)]);
var inst_100144 = (state_100430[(53)]);
var inst_100192 = (state_100430[(11)]);
var inst_100238 = (state_100430[(54)]);
var inst_100265 = (state_100430[(38)]);
var inst_100231 = (state_100430[(29)]);
var inst_100233 = (state_100430[(55)]);
var inst_100068 = (state_100430[(12)]);
var inst_100156 = (state_100430[(13)]);
var inst_100061 = (state_100430[(14)]);
var inst_100252 = (state_100430[(56)]);
var inst_100112 = (state_100430[(15)]);
var inst_100064 = (state_100430[(57)]);
var inst_100103 = (state_100430[(16)]);
var inst_100225 = (state_100430[(24)]);
var inst_100248 = (state_100430[(58)]);
var inst_100259 = (state_100430[(37)]);
var inst_100165 = (state_100430[(17)]);
var inst_100201 = (state_100430[(18)]);
var inst_100174 = (state_100430[(19)]);
var inst_100287 = (function (){var no_filter_QMARK_ = true;
var t = inst_100238;
var max_limit_QMARK_ = inst_100232;
var next_node = inst_100255;
var fast_forward_db_QMARK_ = inst_100243;
var s1 = inst_100103;
var o2 = inst_100165;
var t1 = inst_100061;
var predicate_fn = inst_100093;
var i = inst_100257;
var m1 = inst_100192;
var root_node = inst_100248;
var vec__100043 = inst_100057;
var s2 = inst_100112;
var p2 = inst_100183;
var vec__100050 = inst_100143;
var G__100266 = inst_100285;
var map__100049 = inst_100091;
var permissions = inst_100233;
var limit = inst_100231;
var start_flake = inst_100202;
var flake_limit = inst_100225;
var offset = inst_100256;
var vec__100053 = inst_100144;
var acc = inst_100259;
var t2 = inst_100068;
var op1 = inst_100062;
var o1 = inst_100156;
var end_flake = inst_100203;
var base_result = inst_100265;
var s = inst_100258;
var node_start = inst_100252;
var p1 = inst_100174;
var vec__100046 = inst_100064;
var subject_fn = inst_100092;
var object_fn = inst_100147;
var map__100056 = inst_100224;
var idx_compare = inst_100237;
var op2 = inst_100069;
var m2 = inst_100201;
var novelty = inst_100242;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100285,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__){
return (function (p1__100029_SHARP_){
var G__100622 = p1__100029_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__100622) : object_fn.call(null,G__100622));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,m1,root_node,vec__100043,s2,p2,vec__100050,G__100266,map__100049,permissions,limit,start_flake,flake_limit,offset,vec__100053,acc,t2,op1,o1,end_flake,base_result,s,node_start,p1,vec__100046,subject_fn,object_fn,map__100056,idx_compare,op2,m2,novelty,inst_100183,inst_100147,inst_100285,inst_100258,inst_100143,inst_100092,inst_100062,inst_100237,inst_100093,inst_100242,inst_100203,inst_100256,inst_100069,inst_100255,inst_100257,inst_100232,inst_100243,inst_100224,inst_100091,inst_100057,inst_100202,inst_100144,inst_100192,inst_100238,inst_100265,inst_100231,inst_100233,inst_100068,inst_100156,inst_100061,inst_100252,inst_100112,inst_100064,inst_100103,inst_100225,inst_100248,inst_100259,inst_100165,inst_100201,inst_100174,state_val_100431,c__99059__auto__))
})();
var inst_100288 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_100287,inst_100285);
var state_100430__$1 = state_100430;
var statearr_100623_100787 = state_100430__$1;
(statearr_100623_100787[(2)] = inst_100288);

(statearr_100623_100787[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (8))){
var state_100430__$1 = state_100430;
var statearr_100624_100788 = state_100430__$1;
(statearr_100624_100788[(2)] = true);

(statearr_100624_100788[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (49))){
var inst_100175 = (state_100430[(82)]);
var state_100430__$1 = state_100430;
var statearr_100625_100789 = state_100430__$1;
(statearr_100625_100789[(2)] = inst_100175);

(statearr_100625_100789[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100431 === (84))){
var inst_100423 = (state_100430[(2)]);
var state_100430__$1 = state_100430;
var statearr_100626_100790 = state_100430__$1;
(statearr_100626_100790[(2)] = inst_100423);

(statearr_100626_100790[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$state_machine__99037__auto__ = null;
var fluree$db$query$range$state_machine__99037__auto____0 = (function (){
var statearr_100627 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100627[(0)] = fluree$db$query$range$state_machine__99037__auto__);

(statearr_100627[(1)] = (1));

return statearr_100627;
});
var fluree$db$query$range$state_machine__99037__auto____1 = (function (state_100430){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_100430);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e100628){if((e100628 instanceof Object)){
var ex__99040__auto__ = e100628;
var statearr_100629_100791 = state_100430;
(statearr_100629_100791[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100430);

return cljs.core.cst$kw$recur;
} else {
throw e100628;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__100792 = state_100430;
state_100430 = G__100792;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99037__auto__ = function(state_100430){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99037__auto____1.call(this,state_100430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99037__auto____0;
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99037__auto____1;
return fluree$db$query$range$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_100630 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_100630[(6)] = c__99059__auto__);

return statearr_100630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7;

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_100847){
var state_val_100848 = (state_100847[(1)]);
if((state_val_100848 === (7))){
var inst_100811 = (state_100847[(7)]);
var inst_100821 = (state_100847[(8)]);
var inst_100819 = fluree.db.flake.Flake__GT_parts(inst_100811);
var inst_100820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(0),null);
var inst_100821__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(1),null);
var inst_100822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(2),null);
var inst_100823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(3),null);
var inst_100824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(4),null);
var inst_100825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_100819,(5),null);
var inst_100826 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_100822,inst_100821__$1);
var state_100847__$1 = (function (){var statearr_100849 = state_100847;
(statearr_100849[(9)] = inst_100820);

(statearr_100849[(10)] = inst_100824);

(statearr_100849[(11)] = inst_100825);

(statearr_100849[(8)] = inst_100821__$1);

(statearr_100849[(12)] = inst_100823);

return statearr_100849;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_100847__$1,(10),inst_100826);
} else {
if((state_val_100848 === (1))){
var inst_100800 = cljs.core.seq(flakes);
var inst_100801 = cljs.core.first(inst_100800);
var inst_100802 = cljs.core.next(inst_100800);
var inst_100803 = cljs.core.PersistentVector.EMPTY;
var inst_100804 = flakes;
var inst_100805 = inst_100803;
var state_100847__$1 = (function (){var statearr_100850 = state_100847;
(statearr_100850[(13)] = inst_100801);

(statearr_100850[(14)] = inst_100802);

(statearr_100850[(15)] = inst_100805);

(statearr_100850[(16)] = inst_100804);

return statearr_100850;
})();
var statearr_100851_100868 = state_100847__$1;
(statearr_100851_100868[(2)] = null);

(statearr_100851_100868[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (4))){
var inst_100811 = (state_100847[(7)]);
var inst_100814 = fluree.db.query.range.is_tag_flake_QMARK_(inst_100811);
var state_100847__$1 = state_100847;
if(inst_100814){
var statearr_100852_100869 = state_100847__$1;
(statearr_100852_100869[(1)] = (7));

} else {
var statearr_100853_100870 = state_100847__$1;
(statearr_100853_100870[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (6))){
var inst_100843 = (state_100847[(2)]);
var state_100847__$1 = state_100847;
var statearr_100854_100871 = state_100847__$1;
(statearr_100854_100871[(2)] = inst_100843);

(statearr_100854_100871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (3))){
var inst_100845 = (state_100847[(2)]);
var state_100847__$1 = state_100847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_100847__$1,inst_100845);
} else {
if((state_val_100848 === (2))){
var inst_100811 = (state_100847[(7)]);
var inst_100804 = (state_100847[(16)]);
var inst_100810 = cljs.core.seq(inst_100804);
var inst_100811__$1 = cljs.core.first(inst_100810);
var inst_100812 = cljs.core.next(inst_100810);
var state_100847__$1 = (function (){var statearr_100855 = state_100847;
(statearr_100855[(7)] = inst_100811__$1);

(statearr_100855[(17)] = inst_100812);

return statearr_100855;
})();
if(cljs.core.truth_(inst_100811__$1)){
var statearr_100856_100872 = state_100847__$1;
(statearr_100856_100872[(1)] = (4));

} else {
var statearr_100857_100873 = state_100847__$1;
(statearr_100857_100873[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (9))){
var inst_100840 = (state_100847[(2)]);
var state_100847__$1 = state_100847;
var statearr_100858_100874 = state_100847__$1;
(statearr_100858_100874[(2)] = inst_100840);

(statearr_100858_100874[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (5))){
var inst_100805 = (state_100847[(15)]);
var state_100847__$1 = state_100847;
var statearr_100859_100875 = state_100847__$1;
(statearr_100859_100875[(2)] = inst_100805);

(statearr_100859_100875[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (10))){
var inst_100820 = (state_100847[(9)]);
var inst_100824 = (state_100847[(10)]);
var inst_100805 = (state_100847[(15)]);
var inst_100812 = (state_100847[(17)]);
var inst_100825 = (state_100847[(11)]);
var inst_100821 = (state_100847[(8)]);
var inst_100823 = (state_100847[(12)]);
var inst_100828 = (state_100847[(2)]);
var inst_100829 = fluree.db.util.async.throw_err(inst_100828);
var inst_100830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100831 = [inst_100820,inst_100821,inst_100829,inst_100823,inst_100824,inst_100825];
var inst_100832 = (new cljs.core.PersistentVector(null,6,(5),inst_100830,inst_100831,null));
var inst_100833 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_100832);
var inst_100834 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_100805,inst_100833);
var inst_100804 = inst_100812;
var inst_100805__$1 = inst_100834;
var state_100847__$1 = (function (){var statearr_100860 = state_100847;
(statearr_100860[(15)] = inst_100805__$1);

(statearr_100860[(16)] = inst_100804);

return statearr_100860;
})();
var statearr_100861_100876 = state_100847__$1;
(statearr_100861_100876[(2)] = null);

(statearr_100861_100876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_100848 === (8))){
var inst_100811 = (state_100847[(7)]);
var inst_100805 = (state_100847[(15)]);
var inst_100812 = (state_100847[(17)]);
var inst_100837 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_100805,inst_100811);
var inst_100804 = inst_100812;
var inst_100805__$1 = inst_100837;
var state_100847__$1 = (function (){var statearr_100862 = state_100847;
(statearr_100862[(15)] = inst_100805__$1);

(statearr_100862[(16)] = inst_100804);

return statearr_100862;
})();
var statearr_100863_100877 = state_100847__$1;
(statearr_100863_100877[(2)] = null);

(statearr_100863_100877[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____0 = (function (){
var statearr_100864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_100864[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__);

(statearr_100864[(1)] = (1));

return statearr_100864;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____1 = (function (state_100847){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_100847);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e100865){if((e100865 instanceof Object)){
var ex__99040__auto__ = e100865;
var statearr_100866_100878 = state_100847;
(statearr_100866_100878[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_100847);

return cljs.core.cst$kw$recur;
} else {
throw e100865;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__100879 = state_100847;
state_100847 = G__100879;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__ = function(state_100847){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____1.call(this,state_100847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_100867 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_100867[(6)] = c__99059__auto__);

return statearr_100867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__100881 = arguments.length;
switch (G__100881) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101028){
var state_val_101029 = (state_101028[(1)]);
if((state_val_101029 === (62))){
var inst_101024 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101030_101114 = state_101028__$1;
(statearr_101030_101114[(2)] = inst_101024);


cljs.core.async.impl.ioc_helpers.process_exception(state_101028__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (7))){
var inst_100899 = (state_101028[(7)]);
var inst_100899__$1 = (state_101028[(2)]);
var state_101028__$1 = (function (){var statearr_101031 = state_101028;
(statearr_101031[(7)] = inst_100899__$1);

return statearr_101031;
})();
if(cljs.core.truth_(inst_100899__$1)){
var statearr_101032_101115 = state_101028__$1;
(statearr_101032_101115[(1)] = (8));

} else {
var statearr_101033_101116 = state_101028__$1;
(statearr_101033_101116[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (59))){
var inst_101004 = (state_101028[(2)]);
var inst_101005 = fluree.db.util.async.throw_err(inst_101004);
var state_101028__$1 = state_101028;
var statearr_101034_101117 = state_101028__$1;
(statearr_101034_101117[(2)] = inst_101005);

(statearr_101034_101117[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (20))){
var inst_100925 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101035_101118 = state_101028__$1;
(statearr_101035_101118[(2)] = inst_100925);

(statearr_101035_101118[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (58))){
var inst_101008 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101036_101119 = state_101028__$1;
(statearr_101036_101119[(2)] = inst_101008);

(statearr_101036_101119[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (60))){
var inst_101016 = (state_101028[(8)]);
var inst_101018 = fluree.db.query.range.coerce_tag_flakes(db,inst_101016);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(63),inst_101018);
} else {
if((state_val_101029 === (27))){
var inst_100890 = (state_101028[(9)]);
var state_101028__$1 = state_101028;
var statearr_101037_101120 = state_101028__$1;
(statearr_101037_101120[(2)] = inst_100890);

(statearr_101037_101120[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (1))){
var state_101028__$1 = state_101028;
var statearr_101038_101121 = state_101028__$1;
(statearr_101038_101121[(2)] = null);

(statearr_101038_101121[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (24))){
var inst_100899 = (state_101028[(7)]);
var inst_101016 = (state_101028[(2)]);
var state_101028__$1 = (function (){var statearr_101039 = state_101028;
(statearr_101039[(8)] = inst_101016);

return statearr_101039;
})();
if(cljs.core.truth_(inst_100899)){
var statearr_101040_101122 = state_101028__$1;
(statearr_101040_101122[(1)] = (60));

} else {
var statearr_101041_101123 = state_101028__$1;
(statearr_101041_101123[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (55))){
var inst_100995 = (state_101028[(2)]);
var inst_100996 = fluree.db.util.async.throw_err(inst_100995);
var state_101028__$1 = state_101028;
var statearr_101042_101124 = state_101028__$1;
(statearr_101042_101124[(2)] = inst_100996);

(statearr_101042_101124[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (39))){
var inst_100964 = (state_101028[(10)]);
var inst_100893 = (state_101028[(11)]);
var inst_100964__$1 = cljs.core.not(inst_100893);
var state_101028__$1 = (function (){var statearr_101043 = state_101028;
(statearr_101043[(10)] = inst_100964__$1);

return statearr_101043;
})();
if(inst_100964__$1){
var statearr_101044_101125 = state_101028__$1;
(statearr_101044_101125[(1)] = (42));

} else {
var statearr_101045_101126 = state_101028__$1;
(statearr_101045_101126[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (46))){
var inst_100890 = (state_101028[(9)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100890)){
var statearr_101046_101127 = state_101028__$1;
(statearr_101046_101127[(1)] = (52));

} else {
var statearr_101047_101128 = state_101028__$1;
(statearr_101047_101128[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (4))){
var inst_100890 = (state_101028[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101028,(3),Error,null,(2));
var inst_100889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(0),null);
var inst_100890__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(1),null);
var inst_100891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(2),null);
var inst_100892 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(3),null);
var inst_100893 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_100890__$1);
var state_101028__$1 = (function (){var statearr_101048 = state_101028;
(statearr_101048[(12)] = inst_100891);

(statearr_101048[(13)] = inst_100889);

(statearr_101048[(14)] = inst_100892);

(statearr_101048[(11)] = inst_100893);

(statearr_101048[(9)] = inst_100890__$1);

return statearr_101048;
})();
if(cljs.core.truth_(inst_100890__$1)){
var statearr_101049_101129 = state_101028__$1;
(statearr_101049_101129[(1)] = (5));

} else {
var statearr_101050_101130 = state_101028__$1;
(statearr_101050_101130[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (54))){
var inst_101010 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101051_101131 = state_101028__$1;
(statearr_101051_101131[(2)] = inst_101010);

(statearr_101051_101131[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (15))){
var inst_100891 = (state_101028[(12)]);
var inst_100915 = typeof inst_100891 === 'string';
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100915)){
var statearr_101052_101132 = state_101028__$1;
(statearr_101052_101132[(1)] = (18));

} else {
var statearr_101053_101133 = state_101028__$1;
(statearr_101053_101133[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (48))){
var inst_100973 = (state_101028[(15)]);
var inst_100899 = (state_101028[(7)]);
var inst_100889 = (state_101028[(13)]);
var inst_100904 = (state_101028[(16)]);
var inst_100892 = (state_101028[(14)]);
var inst_100893 = (state_101028[(11)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100975 = (function (){var obj_fn = inst_100973;
var t = inst_100892;
var temp__5733__auto__ = inst_100973;
var p = inst_100890;
var idx_predicate_QMARK_ = inst_100893;
var vec__100886 = fparts;
var o = inst_100929;
var tag_predicate_QMARK_ = inst_100899;
var s = inst_100889;
var o_coerce_QMARK_ = inst_100904;
return ((function (obj_fn,t,temp__5733__auto__,p,idx_predicate_QMARK_,vec__100886,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,inst_100973,inst_100899,inst_100889,inst_100904,inst_100892,inst_100893,inst_100890,inst_100929,state_val_101029,c__99059__auto__){
return (function (x){
var and__4120__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4120__auto__;
}
});
;})(obj_fn,t,temp__5733__auto__,p,idx_predicate_QMARK_,vec__100886,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,inst_100973,inst_100899,inst_100889,inst_100904,inst_100892,inst_100893,inst_100890,inst_100929,state_val_101029,c__99059__auto__))
})();
var state_101028__$1 = state_101028;
var statearr_101054_101134 = state_101028__$1;
(statearr_101054_101134[(2)] = inst_100975);

(statearr_101054_101134[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (50))){
var inst_100889 = (state_101028[(13)]);
var inst_100892 = (state_101028[(14)]);
var inst_100890 = (state_101028[(9)]);
var inst_100979 = (state_101028[(2)]);
var inst_100980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100981 = [inst_100890,inst_100889,null,inst_100892];
var inst_100982 = (new cljs.core.PersistentVector(null,4,(5),inst_100980,inst_100981,null));
var inst_100983 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_100979);
var inst_100984 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_100982,inst_100983);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(51),inst_100984);
} else {
if((state_val_101029 === (21))){
var inst_100921 = (state_101028[(2)]);
var inst_100922 = fluree.db.util.async.throw_err(inst_100921);
var state_101028__$1 = state_101028;
var statearr_101055_101135 = state_101028__$1;
(statearr_101055_101135[(2)] = inst_100922);

(statearr_101055_101135[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (31))){
var inst_100950 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101056_101136 = state_101028__$1;
(statearr_101056_101136[(2)] = inst_100950);

(statearr_101056_101136[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (32))){
var inst_100929 = (state_101028[(17)]);
var inst_100943 = cljs.core.fn_QMARK_(inst_100929);
var inst_100944 = (!(inst_100943));
var state_101028__$1 = state_101028;
var statearr_101057_101137 = state_101028__$1;
(statearr_101057_101137[(2)] = inst_100944);

(statearr_101057_101137[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (40))){
var inst_100890 = (state_101028[(9)]);
var state_101028__$1 = state_101028;
var statearr_101058_101138 = state_101028__$1;
(statearr_101058_101138[(2)] = inst_100890);

(statearr_101058_101138[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (56))){
var inst_100889 = (state_101028[(13)]);
var inst_100892 = (state_101028[(14)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101000 = [inst_100929,inst_100890,inst_100889,inst_100892];
var inst_101001 = (new cljs.core.PersistentVector(null,4,(5),inst_100999,inst_101000,null));
var inst_101002 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_101001,opts);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(59),inst_101002);
} else {
if((state_val_101029 === (33))){
var inst_100893 = (state_101028[(11)]);
var state_101028__$1 = state_101028;
var statearr_101059_101139 = state_101028__$1;
(statearr_101059_101139[(2)] = inst_100893);

(statearr_101059_101139[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (13))){
var inst_100889 = (state_101028[(13)]);
var inst_100929 = (state_101028[(2)]);
var state_101028__$1 = (function (){var statearr_101060 = state_101028;
(statearr_101060[(17)] = inst_100929);

return statearr_101060;
})();
if(cljs.core.truth_(inst_100889)){
var statearr_101061_101140 = state_101028__$1;
(statearr_101061_101140[(1)] = (22));

} else {
var statearr_101062_101141 = state_101028__$1;
(statearr_101062_101141[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (22))){
var inst_100889 = (state_101028[(13)]);
var inst_100892 = (state_101028[(14)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100932 = [inst_100889,inst_100890,inst_100929,inst_100892];
var inst_100933 = (new cljs.core.PersistentVector(null,4,(5),inst_100931,inst_100932,null));
var inst_100934 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_100933,opts);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(25),inst_100934);
} else {
if((state_val_101029 === (36))){
var inst_100890 = (state_101028[(9)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100890)){
var statearr_101063_101142 = state_101028__$1;
(statearr_101063_101142[(1)] = (39));

} else {
var statearr_101064_101143 = state_101028__$1;
(statearr_101064_101143[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (41))){
var inst_100971 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100971)){
var statearr_101065_101144 = state_101028__$1;
(statearr_101065_101144[(1)] = (45));

} else {
var statearr_101066_101145 = state_101028__$1;
(statearr_101066_101145[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (43))){
var inst_100964 = (state_101028[(10)]);
var state_101028__$1 = state_101028;
var statearr_101067_101146 = state_101028__$1;
(statearr_101067_101146[(2)] = inst_100964);

(statearr_101067_101146[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (61))){
var inst_101016 = (state_101028[(8)]);
var state_101028__$1 = state_101028;
var statearr_101068_101147 = state_101028__$1;
(statearr_101068_101147[(2)] = inst_101016);

(statearr_101068_101147[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (29))){
var inst_100893 = (state_101028[(11)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100893)){
var statearr_101069_101148 = state_101028__$1;
(statearr_101069_101148[(1)] = (32));

} else {
var statearr_101070_101149 = state_101028__$1;
(statearr_101070_101149[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (44))){
var inst_100968 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101071_101150 = state_101028__$1;
(statearr_101071_101150[(2)] = inst_100968);

(statearr_101071_101150[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (6))){
var state_101028__$1 = state_101028;
var statearr_101072_101151 = state_101028__$1;
(statearr_101072_101151[(2)] = false);

(statearr_101072_101151[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (28))){
var inst_100953 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100953)){
var statearr_101073_101152 = state_101028__$1;
(statearr_101073_101152[(1)] = (35));

} else {
var statearr_101074_101153 = state_101028__$1;
(statearr_101074_101153[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (51))){
var inst_100986 = (state_101028[(2)]);
var inst_100987 = fluree.db.util.async.throw_err(inst_100986);
var state_101028__$1 = state_101028;
var statearr_101075_101154 = state_101028__$1;
(statearr_101075_101154[(2)] = inst_100987);

(statearr_101075_101154[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (25))){
var inst_100936 = (state_101028[(2)]);
var inst_100937 = fluree.db.util.async.throw_err(inst_100936);
var state_101028__$1 = state_101028;
var statearr_101076_101155 = state_101028__$1;
(statearr_101076_101155[(2)] = inst_100937);

(statearr_101076_101155[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (34))){
var inst_100947 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101077_101156 = state_101028__$1;
(statearr_101077_101156[(2)] = inst_100947);

(statearr_101077_101156[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (17))){
var inst_100912 = (state_101028[(2)]);
var inst_100913 = fluree.db.util.async.throw_err(inst_100912);
var state_101028__$1 = state_101028;
var statearr_101078_101157 = state_101028__$1;
(statearr_101078_101157[(2)] = inst_100913);

(statearr_101078_101157[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (3))){
var inst_100882 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101079_101158 = state_101028__$1;
(statearr_101079_101158[(2)] = inst_100882);


cljs.core.async.impl.ioc_helpers.process_exception(state_101028__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (12))){
var inst_100891 = (state_101028[(12)]);
var inst_100908 = fluree.db.query.range.tag_string_QMARK_(inst_100891);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100908)){
var statearr_101080_101159 = state_101028__$1;
(statearr_101080_101159[(1)] = (14));

} else {
var statearr_101081_101160 = state_101028__$1;
(statearr_101081_101160[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (2))){
var inst_101026 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101028__$1,inst_101026);
} else {
if((state_val_101029 === (23))){
var inst_100890 = (state_101028[(9)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100890)){
var statearr_101082_101161 = state_101028__$1;
(statearr_101082_101161[(1)] = (26));

} else {
var statearr_101083_101162 = state_101028__$1;
(statearr_101083_101162[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (47))){
var inst_101012 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101084_101163 = state_101028__$1;
(statearr_101084_101163[(2)] = inst_101012);

(statearr_101084_101163[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (35))){
var inst_100889 = (state_101028[(13)]);
var inst_100892 = (state_101028[(14)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100956 = [inst_100890,inst_100929,inst_100889,inst_100892];
var inst_100957 = (new cljs.core.PersistentVector(null,4,(5),inst_100955,inst_100956,null));
var inst_100958 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_100957,opts);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(38),inst_100958);
} else {
if((state_val_101029 === (19))){
var state_101028__$1 = state_101028;
var statearr_101085_101164 = state_101028__$1;
(statearr_101085_101164[(2)] = null);

(statearr_101085_101164[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (57))){
var state_101028__$1 = state_101028;
var statearr_101086_101165 = state_101028__$1;
(statearr_101086_101165[(2)] = null);

(statearr_101086_101165[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (11))){
var inst_100891 = (state_101028[(12)]);
var state_101028__$1 = state_101028;
var statearr_101087_101166 = state_101028__$1;
(statearr_101087_101166[(2)] = inst_100891);

(statearr_101087_101166[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (9))){
var inst_100899 = (state_101028[(7)]);
var state_101028__$1 = state_101028;
var statearr_101088_101167 = state_101028__$1;
(statearr_101088_101167[(2)] = inst_100899);

(statearr_101088_101167[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (5))){
var inst_100890 = (state_101028[(9)]);
var inst_100895 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_100890);
var inst_100896 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_100895);
var state_101028__$1 = state_101028;
var statearr_101089_101168 = state_101028__$1;
(statearr_101089_101168[(2)] = inst_100896);

(statearr_101089_101168[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (14))){
var inst_100891 = (state_101028[(12)]);
var inst_100910 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_100891);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(17),inst_100910);
} else {
if((state_val_101029 === (45))){
var inst_100973 = (state_101028[(15)]);
var inst_100973__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_101028__$1 = (function (){var statearr_101090 = state_101028;
(statearr_101090[(15)] = inst_100973__$1);

return statearr_101090;
})();
if(cljs.core.truth_(inst_100973__$1)){
var statearr_101091_101169 = state_101028__$1;
(statearr_101091_101169[(1)] = (48));

} else {
var statearr_101092_101170 = state_101028__$1;
(statearr_101092_101170[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (53))){
var inst_100929 = (state_101028[(17)]);
var state_101028__$1 = state_101028;
if(cljs.core.truth_(inst_100929)){
var statearr_101093_101171 = state_101028__$1;
(statearr_101093_101171[(1)] = (56));

} else {
var statearr_101094_101172 = state_101028__$1;
(statearr_101094_101172[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (26))){
var inst_100940 = (state_101028[(18)]);
var inst_100929 = (state_101028[(17)]);
var inst_100940__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_100929);
var state_101028__$1 = (function (){var statearr_101095 = state_101028;
(statearr_101095[(18)] = inst_100940__$1);

return statearr_101095;
})();
if(inst_100940__$1){
var statearr_101096_101173 = state_101028__$1;
(statearr_101096_101173[(1)] = (29));

} else {
var statearr_101097_101174 = state_101028__$1;
(statearr_101097_101174[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (16))){
var inst_100927 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101098_101175 = state_101028__$1;
(statearr_101098_101175[(2)] = inst_100927);

(statearr_101098_101175[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (38))){
var inst_100960 = (state_101028[(2)]);
var inst_100961 = fluree.db.util.async.throw_err(inst_100960);
var state_101028__$1 = state_101028;
var statearr_101099_101176 = state_101028__$1;
(statearr_101099_101176[(2)] = inst_100961);

(statearr_101099_101176[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (30))){
var inst_100940 = (state_101028[(18)]);
var state_101028__$1 = state_101028;
var statearr_101100_101177 = state_101028__$1;
(statearr_101100_101177[(2)] = inst_100940);

(statearr_101100_101177[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (10))){
var inst_100904 = (state_101028[(16)]);
var inst_100904__$1 = (state_101028[(2)]);
var inst_100905 = cljs.core.not(inst_100904__$1);
var state_101028__$1 = (function (){var statearr_101101 = state_101028;
(statearr_101101[(16)] = inst_100904__$1);

return statearr_101101;
})();
if(inst_100905){
var statearr_101102_101178 = state_101028__$1;
(statearr_101102_101178[(1)] = (11));

} else {
var statearr_101103_101179 = state_101028__$1;
(statearr_101103_101179[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (18))){
var inst_100891 = (state_101028[(12)]);
var inst_100890 = (state_101028[(9)]);
var inst_100917 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_100890);
var inst_100918 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_100917),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_100891)].join('');
var inst_100919 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_100918);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(21),inst_100919);
} else {
if((state_val_101029 === (52))){
var inst_100889 = (state_101028[(13)]);
var inst_100892 = (state_101028[(14)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_100991 = [inst_100890,inst_100889,inst_100929,inst_100892];
var inst_100992 = (new cljs.core.PersistentVector(null,4,(5),inst_100990,inst_100991,null));
var inst_100993 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_100992,opts);
var state_101028__$1 = state_101028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101028__$1,(55),inst_100993);
} else {
if((state_val_101029 === (42))){
var inst_100929 = (state_101028[(17)]);
var state_101028__$1 = state_101028;
var statearr_101104_101180 = state_101028__$1;
(statearr_101104_101180[(2)] = inst_100929);

(statearr_101104_101180[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (37))){
var inst_101014 = (state_101028[(2)]);
var state_101028__$1 = state_101028;
var statearr_101105_101181 = state_101028__$1;
(statearr_101105_101181[(2)] = inst_101014);

(statearr_101105_101181[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (63))){
var inst_101020 = (state_101028[(2)]);
var inst_101021 = fluree.db.util.async.throw_err(inst_101020);
var state_101028__$1 = state_101028;
var statearr_101106_101182 = state_101028__$1;
(statearr_101106_101182[(2)] = inst_101021);

(statearr_101106_101182[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (8))){
var inst_100891 = (state_101028[(12)]);
var inst_100901 = typeof inst_100891 === 'string';
var state_101028__$1 = state_101028;
var statearr_101107_101183 = state_101028__$1;
(statearr_101107_101183[(2)] = inst_100901);

(statearr_101107_101183[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101029 === (49))){
var inst_100973 = (state_101028[(15)]);
var inst_100899 = (state_101028[(7)]);
var inst_100889 = (state_101028[(13)]);
var inst_100904 = (state_101028[(16)]);
var inst_100892 = (state_101028[(14)]);
var inst_100893 = (state_101028[(11)]);
var inst_100890 = (state_101028[(9)]);
var inst_100929 = (state_101028[(17)]);
var inst_100977 = (function (){var t = inst_100892;
var temp__5733__auto__ = inst_100973;
var p = inst_100890;
var idx_predicate_QMARK_ = inst_100893;
var vec__100886 = fparts;
var o = inst_100929;
var tag_predicate_QMARK_ = inst_100899;
var s = inst_100889;
var o_coerce_QMARK_ = inst_100904;
return ((function (t,temp__5733__auto__,p,idx_predicate_QMARK_,vec__100886,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,inst_100973,inst_100899,inst_100889,inst_100904,inst_100892,inst_100893,inst_100890,inst_100929,state_val_101029,c__99059__auto__){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
;})(t,temp__5733__auto__,p,idx_predicate_QMARK_,vec__100886,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,inst_100973,inst_100899,inst_100889,inst_100904,inst_100892,inst_100893,inst_100890,inst_100929,state_val_101029,c__99059__auto__))
})();
var state_101028__$1 = state_101028;
var statearr_101108_101184 = state_101028__$1;
(statearr_101108_101184[(2)] = inst_100977);

(statearr_101108_101184[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$state_machine__99037__auto__ = null;
var fluree$db$query$range$state_machine__99037__auto____0 = (function (){
var statearr_101109 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_101109[(0)] = fluree$db$query$range$state_machine__99037__auto__);

(statearr_101109[(1)] = (1));

return statearr_101109;
});
var fluree$db$query$range$state_machine__99037__auto____1 = (function (state_101028){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101028);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101110){if((e101110 instanceof Object)){
var ex__99040__auto__ = e101110;
var statearr_101111_101185 = state_101028;
(statearr_101111_101185[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101028);

return cljs.core.cst$kw$recur;
} else {
throw e101110;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__101186 = state_101028;
state_101028 = G__101186;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99037__auto__ = function(state_101028){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99037__auto____1.call(this,state_101028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99037__auto____0;
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99037__auto____1;
return fluree$db$query$range$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101112 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101112[(6)] = c__99059__auto__);

return statearr_101112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.range.search.cljs$lang$maxFixedArity = 3;

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__101188 = arguments.length;
switch (G__101188) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
});

fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__99059__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__99059__auto__){
return (function (){
var f__99060__auto__ = (function (){var switch__99036__auto__ = ((function (c__99059__auto__){
return (function (state_101220){
var state_val_101221 = (state_101220[(1)]);
if((state_val_101221 === (1))){
var state_101220__$1 = state_101220;
var statearr_101222_101235 = state_101220__$1;
(statearr_101222_101235[(2)] = null);

(statearr_101222_101235[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101221 === (2))){
var inst_101218 = (state_101220[(2)]);
var state_101220__$1 = state_101220;
return cljs.core.async.impl.ioc_helpers.return_chan(state_101220__$1,inst_101218);
} else {
if((state_val_101221 === (3))){
var inst_101189 = (state_101220[(2)]);
var state_101220__$1 = state_101220;
var statearr_101223_101236 = state_101220__$1;
(statearr_101223_101236[(2)] = inst_101189);


cljs.core.async.impl.ioc_helpers.process_exception(state_101220__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101221 === (4))){
var inst_101193 = (state_101220[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_101220,(3),java.lang.Exception,null,(2));
var inst_101193__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_101220__$1 = (function (){var statearr_101224 = state_101220;
(statearr_101224[(7)] = inst_101193__$1);

return statearr_101224;
})();
if(cljs.core.truth_(inst_101193__$1)){
var statearr_101225_101237 = state_101220__$1;
(statearr_101225_101237[(1)] = (5));

} else {
var statearr_101226_101238 = state_101220__$1;
(statearr_101226_101238[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_101221 === (5))){
var inst_101193 = (state_101220[(7)]);
var inst_101195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101196 = fluree.db.flake.max_subject_id(inst_101193);
var inst_101197 = [inst_101196];
var inst_101198 = (new cljs.core.PersistentVector(null,1,(5),inst_101195,inst_101197,null));
var inst_101199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_101200 = fluree.db.flake.min_subject_id(inst_101193);
var inst_101201 = [inst_101200];
var inst_101202 = (new cljs.core.PersistentVector(null,1,(5),inst_101199,inst_101201,null));
var inst_101203 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_101198,cljs.core._LT__EQ_,inst_101202,opts);
var state_101220__$1 = state_101220;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_101220__$1,(8),inst_101203);
} else {
if((state_val_101221 === (6))){
var inst_101208 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_101209 = ["Invalid collection name: ",inst_101208].join('');
var inst_101210 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_101211 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_101212 = cljs.core.PersistentHashMap.fromArrays(inst_101210,inst_101211);
var inst_101213 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_101209,inst_101212);
var inst_101214 = (function(){throw inst_101213})();
var state_101220__$1 = state_101220;
var statearr_101227_101239 = state_101220__$1;
(statearr_101227_101239[(2)] = inst_101214);

(statearr_101227_101239[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_101221 === (7))){
var inst_101216 = (state_101220[(2)]);
var state_101220__$1 = state_101220;
var statearr_101228_101240 = state_101220__$1;
(statearr_101228_101240[(2)] = inst_101216);


cljs.core.async.impl.ioc_helpers.process_exception(state_101220__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_101221 === (8))){
var inst_101205 = (state_101220[(2)]);
var inst_101206 = fluree.db.util.async.throw_err(inst_101205);
var state_101220__$1 = state_101220;
var statearr_101229_101241 = state_101220__$1;
(statearr_101229_101241[(2)] = inst_101206);

(statearr_101229_101241[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__99059__auto__))
;
return ((function (switch__99036__auto__,c__99059__auto__){
return (function() {
var fluree$db$query$range$state_machine__99037__auto__ = null;
var fluree$db$query$range$state_machine__99037__auto____0 = (function (){
var statearr_101230 = [null,null,null,null,null,null,null,null];
(statearr_101230[(0)] = fluree$db$query$range$state_machine__99037__auto__);

(statearr_101230[(1)] = (1));

return statearr_101230;
});
var fluree$db$query$range$state_machine__99037__auto____1 = (function (state_101220){
while(true){
var ret_value__99038__auto__ = (function (){try{while(true){
var result__99039__auto__ = switch__99036__auto__(state_101220);
if(cljs.core.keyword_identical_QMARK_(result__99039__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__99039__auto__;
}
break;
}
}catch (e101231){if((e101231 instanceof Object)){
var ex__99040__auto__ = e101231;
var statearr_101232_101242 = state_101220;
(statearr_101232_101242[(5)] = ex__99040__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_101220);

return cljs.core.cst$kw$recur;
} else {
throw e101231;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__99038__auto__,cljs.core.cst$kw$recur)){
var G__101243 = state_101220;
state_101220 = G__101243;
continue;
} else {
return ret_value__99038__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__99037__auto__ = function(state_101220){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__99037__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__99037__auto____1.call(this,state_101220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__99037__auto____0;
fluree$db$query$range$state_machine__99037__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__99037__auto____1;
return fluree$db$query$range$state_machine__99037__auto__;
})()
;})(switch__99036__auto__,c__99059__auto__))
})();
var state__99061__auto__ = (function (){var statearr_101233 = (f__99060__auto__.cljs$core$IFn$_invoke$arity$0 ? f__99060__auto__.cljs$core$IFn$_invoke$arity$0() : f__99060__auto__.call(null));
(statearr_101233[(6)] = c__99059__auto__);

return statearr_101233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__99061__auto__);
});})(c__99059__auto__))
);

return c__99059__auto__;
});

fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3;

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__101247 = flakes;
var vec__101248 = G__101247;
var seq__101249 = cljs.core.seq(vec__101248);
var first__101250 = cljs.core.first(seq__101249);
var seq__101249__$1 = cljs.core.next(seq__101249);
var flake_SINGLEQUOTE_ = first__101250;
var r = seq__101249__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__101247__$1 = G__101247;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__101257 = G__101247__$1;
var seq__101258 = cljs.core.seq(vec__101257);
var first__101259 = cljs.core.first(seq__101258);
var seq__101258__$1 = cljs.core.next(seq__101258);
var flake_SINGLEQUOTE___$1 = first__101259;
var r__$1 = seq__101258__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e101261){if((e101261 instanceof java.lang.Exception)){
var e = e101261;
return null;
} else {
throw e101261;

}
}})();
var map__101260 = cmd_map;
var map__101260__$1 = (((((!((map__101260 == null))))?(((((map__101260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101260):map__101260);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101260__$1,cljs.core.cst$kw$expire);
var G__101263 = r__$1;
var G__101264 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__101247__$1 = G__101263;
result_STAR___$1 = G__101264;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__101273 = blocks;
var vec__101274 = G__101273;
var seq__101275 = cljs.core.seq(vec__101274);
var first__101276 = cljs.core.first(seq__101275);
var seq__101275__$1 = cljs.core.next(seq__101275);
var block_SINGLEQUOTE_ = first__101276;
var r = seq__101275__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__101273__$1 = G__101273;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__101282 = G__101273__$1;
var seq__101283 = cljs.core.seq(vec__101282);
var first__101284 = cljs.core.first(seq__101283);
var seq__101283__$1 = cljs.core.next(seq__101283);
var block_SINGLEQUOTE___$1 = first__101284;
var r__$1 = seq__101283__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__101285 = block_SINGLEQUOTE___$1;
var map__101285__$1 = (((((!((map__101285 == null))))?(((((map__101285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__101285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__101285):map__101285);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101285__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101285__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__101285__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__101265_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__101265_SHARP_.p,(2))){
return p1__101265_SHARP_.o;
} else {
return null;
}
});})(G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__101266_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__101266_SHARP_.p,(1))){
return p1__101266_SHARP_.o;
} else {
return null;
}
});})(G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__101267_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__101267_SHARP_.p,(5))){
return p1__101267_SHARP_.o;
} else {
return null;
}
});})(G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,instant,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__101268_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__101268_SHARP_.p,(7))){
return p1__101268_SHARP_.o;
} else {
return null;
}
});})(G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,instant,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__101269_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__101269_SHARP_.p,(106));
});})(G__101273__$1,result_STAR___$1,map__101285,map__101285__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__101282,seq__101283,first__101284,seq__101283__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__101273,vec__101274,seq__101275,first__101276,seq__101275__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__101287 = r__$1;
var G__101288 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__101273__$1 = G__101287;
result_STAR___$1 = G__101288;
continue;
}
break;
}
});

//# sourceMappingURL=range.js.map?rel=1593118615924
