// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.api.ledger');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectOne.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$history.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$history;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectDistinct.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$selectReduced.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$standard;
} else {
if(cljs.core.truth_(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(flureeQL))){
return cljs.core.cst$kw$block;
} else {
return cljs.core.cst$kw$multi;

}
}
}
}
}
}
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_133071){
var state_val_133072 = (state_133071[(1)]);
if((state_val_133072 === (7))){
var inst_132961 = (state_133071[(7)]);
var inst_132961__$1 = (state_133071[(2)]);
var inst_132962 = cljs.core.some(cljs.core.string_QMARK_,inst_132961__$1);
var state_133071__$1 = (function (){var statearr_133073 = state_133071;
(statearr_133073[(7)] = inst_132961__$1);

return statearr_133073;
})();
if(cljs.core.truth_(inst_132962)){
var statearr_133074_133132 = state_133071__$1;
(statearr_133074_133132[(1)] = (8));

} else {
var statearr_133075_133133 = state_133071__$1;
(statearr_133075_133133[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (20))){
var inst_132984 = (state_133071[(8)]);
var state_133071__$1 = state_133071;
var statearr_133076_133134 = state_133071__$1;
(statearr_133076_133134[(2)] = inst_132984);

(statearr_133076_133134[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (27))){
var inst_133027 = (state_133071[(2)]);
var state_133071__$1 = state_133071;
var statearr_133077_133135 = state_133071__$1;
(statearr_133077_133135[(2)] = inst_133027);

(statearr_133077_133135[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (1))){
var state_133071__$1 = state_133071;
var statearr_133078_133136 = state_133071__$1;
(statearr_133078_133136[(2)] = null);

(statearr_133078_133136[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (24))){
var inst_133030 = (state_133071[(9)]);
var inst_133031 = (state_133071[(10)]);
var inst_133029 = (state_133071[(2)]);
var inst_133030__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133029,(0),null);
var inst_133031__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133029,(1),null);
var inst_133032 = cljs.core.pos_int_QMARK_(inst_133030__$1);
var inst_133033 = cljs.core.pos_int_QMARK_(inst_133031__$1);
var inst_133034 = ((inst_133032) && (inst_133033));
var inst_133035 = cljs.core.not(inst_133034);
var state_133071__$1 = (function (){var statearr_133079 = state_133071;
(statearr_133079[(9)] = inst_133030__$1);

(statearr_133079[(10)] = inst_133031__$1);

return statearr_133079;
})();
if(inst_133035){
var statearr_133080_133137 = state_133071__$1;
(statearr_133080_133137[(1)] = (31));

} else {
var statearr_133081_133138 = state_133071__$1;
(statearr_133081_133138[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (39))){
var inst_133058 = (state_133071[(11)]);
var inst_133064 = (state_133071[(2)]);
var inst_133065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133066 = [inst_133058,inst_133064];
var inst_133067 = (new cljs.core.PersistentVector(null,2,(5),inst_133065,inst_133066,null));
var state_133071__$1 = state_133071;
var statearr_133082_133139 = state_133071__$1;
(statearr_133082_133139[(2)] = inst_133067);


cljs.core.async.impl.ioc_helpers.process_exception(state_133071__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_133071,(3),Error,null,(2));
var inst_132950 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_132951 = cljs.core.sequential_QMARK_(inst_132950);
var state_133071__$1 = state_133071;
if(inst_132951){
var statearr_133083_133140 = state_133071__$1;
(statearr_133083_133140[(1)] = (5));

} else {
var statearr_133084_133141 = state_133071__$1;
(statearr_133084_133141[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (15))){
var inst_132974 = (state_133071[(2)]);
var inst_132975 = fluree.db.util.async.throw_err(inst_132974);
var state_133071__$1 = state_133071;
var statearr_133085_133142 = state_133071__$1;
(statearr_133085_133142[(2)] = inst_132975);

(statearr_133085_133142[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (21))){
var inst_133003 = (state_133071[(2)]);
var state_133071__$1 = state_133071;
if(cljs.core.truth_(inst_133003)){
var statearr_133086_133143 = state_133071__$1;
(statearr_133086_133143[(1)] = (22));

} else {
var statearr_133087_133144 = state_133071__$1;
(statearr_133087_133144[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (31))){
var inst_132961 = (state_133071[(7)]);
var inst_133037 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_132961], 0));
var inst_133038 = ["Invalid block range provided: ",inst_133037].join('');
var inst_133039 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_133040 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_133041 = cljs.core.PersistentHashMap.fromArrays(inst_133039,inst_133040);
var inst_133042 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_133038,inst_133041);
var inst_133043 = (function(){throw inst_133042})();
var state_133071__$1 = state_133071;
var statearr_133088_133145 = state_133071__$1;
(statearr_133088_133145[(2)] = inst_133043);

(statearr_133088_133145[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (32))){
var state_133071__$1 = state_133071;
var statearr_133089_133146 = state_133071__$1;
(statearr_133089_133146[(2)] = null);

(statearr_133089_133146[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (33))){
var inst_133030 = (state_133071[(9)]);
var inst_133031 = (state_133071[(10)]);
var inst_133046 = (state_133071[(2)]);
var inst_133047 = (inst_133031 < inst_133030);
var state_133071__$1 = (function (){var statearr_133090 = state_133071;
(statearr_133090[(12)] = inst_133046);

return statearr_133090;
})();
if(cljs.core.truth_(inst_133047)){
var statearr_133091_133147 = state_133071__$1;
(statearr_133091_133147[(1)] = (34));

} else {
var statearr_133092_133148 = state_133071__$1;
(statearr_133092_133148[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (13))){
var state_133071__$1 = state_133071;
var statearr_133093_133149 = state_133071__$1;
(statearr_133093_133149[(2)] = null);

(statearr_133093_133149[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (22))){
var inst_132985 = (state_133071[(13)]);
var inst_132984 = (state_133071[(8)]);
var inst_133005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133006 = [inst_132984,inst_132985];
var inst_133007 = (new cljs.core.PersistentVector(null,2,(5),inst_133005,inst_133006,null));
var state_133071__$1 = state_133071;
var statearr_133094_133150 = state_133071__$1;
(statearr_133094_133150[(2)] = inst_133007);

(statearr_133094_133150[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (36))){
var inst_132986 = (state_133071[(14)]);
var inst_133059 = (state_133071[(15)]);
var inst_133057 = (state_133071[(2)]);
var inst_133058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133057,(0),null);
var inst_133059__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133057,(1),null);
var inst_133060 = (inst_133059__$1 > inst_132986);
var state_133071__$1 = (function (){var statearr_133095 = state_133071;
(statearr_133095[(11)] = inst_133058);

(statearr_133095[(15)] = inst_133059__$1);

return statearr_133095;
})();
if(cljs.core.truth_(inst_133060)){
var statearr_133096_133151 = state_133071__$1;
(statearr_133096_133151[(1)] = (37));

} else {
var statearr_133097_133152 = state_133071__$1;
(statearr_133097_133152[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (29))){
var state_133071__$1 = state_133071;
var statearr_133098_133153 = state_133071__$1;
(statearr_133098_133153[(2)] = null);

(statearr_133098_133153[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (6))){
var inst_132955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132956 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_132957 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_132958 = [inst_132956,inst_132957];
var inst_132959 = (new cljs.core.PersistentVector(null,2,(5),inst_132955,inst_132958,null));
var state_133071__$1 = state_133071;
var statearr_133099_133154 = state_133071__$1;
(statearr_133099_133154[(2)] = inst_132959);

(statearr_133099_133154[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (28))){
var inst_132961 = (state_133071[(7)]);
var inst_133016 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_132961], 0));
var inst_133017 = ["Invalid block range provided: ",inst_133016].join('');
var inst_133018 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_133019 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_133020 = cljs.core.PersistentHashMap.fromArrays(inst_133018,inst_133019);
var inst_133021 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_133017,inst_133020);
var inst_133022 = (function(){throw inst_133021})();
var state_133071__$1 = state_133071;
var statearr_133100_133155 = state_133071__$1;
(statearr_133100_133155[(2)] = inst_133022);

(statearr_133100_133155[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (25))){
var inst_132984 = (state_133071[(8)]);
var inst_133010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133011 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_133012 = [inst_132984,inst_133011];
var inst_133013 = (new cljs.core.PersistentVector(null,2,(5),inst_133010,inst_133012,null));
var state_133071__$1 = state_133071;
var statearr_133101_133156 = state_133071__$1;
(statearr_133101_133156[(2)] = inst_133013);

(statearr_133101_133156[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (34))){
var inst_133030 = (state_133071[(9)]);
var inst_133031 = (state_133071[(10)]);
var inst_133049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133050 = [inst_133031,inst_133030];
var inst_133051 = (new cljs.core.PersistentVector(null,2,(5),inst_133049,inst_133050,null));
var state_133071__$1 = state_133071;
var statearr_133102_133157 = state_133071__$1;
(statearr_133102_133157[(2)] = inst_133051);

(statearr_133102_133157[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (17))){
var state_133071__$1 = state_133071;
var statearr_133103_133158 = state_133071__$1;
(statearr_133103_133158[(2)] = null);

(statearr_133103_133158[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (3))){
var inst_132937 = (state_133071[(2)]);
var state_133071__$1 = state_133071;
var statearr_133104_133159 = state_133071__$1;
(statearr_133104_133159[(2)] = inst_132937);


cljs.core.async.impl.ioc_helpers.process_exception(state_133071__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (12))){
var inst_132970 = (state_133071[(16)]);
var inst_132972 = fluree.db.time_travel.block_to_int_format(db,inst_132970);
var state_133071__$1 = state_133071;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133071__$1,(15),inst_132972);
} else {
if((state_val_133072 === (2))){
var inst_133069 = (state_133071[(2)]);
var state_133071__$1 = state_133071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133071__$1,inst_133069);
} else {
if((state_val_133072 === (23))){
var inst_132984 = (state_133071[(8)]);
var state_133071__$1 = state_133071;
if(cljs.core.truth_(inst_132984)){
var statearr_133105_133160 = state_133071__$1;
(statearr_133105_133160[(1)] = (25));

} else {
var statearr_133106_133161 = state_133071__$1;
(statearr_133106_133161[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (35))){
var inst_133030 = (state_133071[(9)]);
var inst_133031 = (state_133071[(10)]);
var inst_133053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133054 = [inst_133030,inst_133031];
var inst_133055 = (new cljs.core.PersistentVector(null,2,(5),inst_133053,inst_133054,null));
var state_133071__$1 = state_133071;
var statearr_133107_133162 = state_133071__$1;
(statearr_133107_133162[(2)] = inst_133055);

(statearr_133107_133162[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (19))){
var inst_132985 = (state_133071[(13)]);
var state_133071__$1 = state_133071;
var statearr_133108_133163 = state_133071__$1;
(statearr_133108_133163[(2)] = inst_132985);

(statearr_133108_133163[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (11))){
var inst_132961 = (state_133071[(7)]);
var inst_132970 = (state_133071[(16)]);
var inst_132968 = (state_133071[(2)]);
var inst_132969 = fluree.db.util.async.throw_err(inst_132968);
var inst_132970__$1 = cljs.core.second(inst_132961);
var state_133071__$1 = (function (){var statearr_133109 = state_133071;
(statearr_133109[(17)] = inst_132969);

(statearr_133109[(16)] = inst_132970__$1);

return statearr_133109;
})();
if(cljs.core.truth_(inst_132970__$1)){
var statearr_133110_133164 = state_133071__$1;
(statearr_133110_133164[(1)] = (12));

} else {
var statearr_133111_133165 = state_133071__$1;
(statearr_133111_133165[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (9))){
var inst_132961 = (state_133071[(7)]);
var state_133071__$1 = state_133071;
var statearr_133112_133166 = state_133071__$1;
(statearr_133112_133166[(2)] = inst_132961);

(statearr_133112_133166[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (5))){
var inst_132953 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query_map);
var state_133071__$1 = state_133071;
var statearr_133113_133167 = state_133071__$1;
(statearr_133113_133167[(2)] = inst_132953);

(statearr_133113_133167[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (14))){
var inst_132969 = (state_133071[(17)]);
var inst_132964 = (state_133071[(18)]);
var inst_132978 = (state_133071[(2)]);
var inst_132979 = [inst_132969,inst_132978];
var inst_132980 = (new cljs.core.PersistentVector(null,2,(5),inst_132964,inst_132979,null));
var state_133071__$1 = state_133071;
var statearr_133114_133168 = state_133071__$1;
(statearr_133114_133168[(2)] = inst_132980);

(statearr_133114_133168[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (26))){
var state_133071__$1 = state_133071;
var statearr_133115_133169 = state_133071__$1;
(statearr_133115_133169[(1)] = (28));



return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (16))){
var inst_132986 = (state_133071[(14)]);
var inst_132984 = (state_133071[(8)]);
var inst_132989 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_132984], 0));
var inst_132990 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_132986], 0));
var inst_132991 = ["Start block is out of range for this ledger. Start block provided: ",inst_132989,". Database block: ",inst_132990].join('');
var inst_132992 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_132993 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_132994 = cljs.core.PersistentHashMap.fromArrays(inst_132992,inst_132993);
var inst_132995 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_132991,inst_132994);
var inst_132996 = (function(){throw inst_132995})();
var state_133071__$1 = state_133071;
var statearr_133117_133170 = state_133071__$1;
(statearr_133117_133170[(2)] = inst_132996);

(statearr_133117_133170[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (38))){
var inst_133059 = (state_133071[(15)]);
var state_133071__$1 = state_133071;
var statearr_133118_133171 = state_133071__$1;
(statearr_133118_133171[(2)] = inst_133059);

(statearr_133118_133171[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (30))){
var inst_133025 = (state_133071[(2)]);
var state_133071__$1 = state_133071;
var statearr_133119_133172 = state_133071__$1;
(statearr_133119_133172[(2)] = inst_133025);

(statearr_133119_133172[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (10))){
var inst_132986 = (state_133071[(14)]);
var inst_132984 = (state_133071[(8)]);
var inst_132983 = (state_133071[(2)]);
var inst_132984__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_132983,(0),null);
var inst_132985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_132983,(1),null);
var inst_132986__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_132987 = (inst_132984__$1 > inst_132986__$1);
var state_133071__$1 = (function (){var statearr_133120 = state_133071;
(statearr_133120[(14)] = inst_132986__$1);

(statearr_133120[(13)] = inst_132985);

(statearr_133120[(8)] = inst_132984__$1);

return statearr_133120;
})();
if(cljs.core.truth_(inst_132987)){
var statearr_133121_133173 = state_133071__$1;
(statearr_133121_133173[(1)] = (16));

} else {
var statearr_133122_133174 = state_133071__$1;
(statearr_133122_133174[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (18))){
var inst_132984 = (state_133071[(8)]);
var inst_132999 = (state_133071[(2)]);
var state_133071__$1 = (function (){var statearr_133123 = state_133071;
(statearr_133123[(19)] = inst_132999);

return statearr_133123;
})();
if(cljs.core.truth_(inst_132984)){
var statearr_133124_133175 = state_133071__$1;
(statearr_133124_133175[(1)] = (19));

} else {
var statearr_133125_133176 = state_133071__$1;
(statearr_133125_133176[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (37))){
var inst_132986 = (state_133071[(14)]);
var state_133071__$1 = state_133071;
var statearr_133126_133177 = state_133071__$1;
(statearr_133126_133177[(2)] = inst_132986);

(statearr_133126_133177[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133072 === (8))){
var inst_132961 = (state_133071[(7)]);
var inst_132964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132965 = cljs.core.first(inst_132961);
var inst_132966 = fluree.db.time_travel.block_to_int_format(db,inst_132965);
var state_133071__$1 = (function (){var statearr_133127 = state_133071;
(statearr_133127[(18)] = inst_132964);

return statearr_133127;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133071__$1,(11),inst_132966);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____0 = (function (){
var statearr_133128 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133128[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__);

(statearr_133128[(1)] = (1));

return statearr_133128;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____1 = (function (state_133071){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133071);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133129){if((e133129 instanceof Object)){
var ex__109974__auto__ = e133129;
var statearr_133130_133178 = state_133071;
(statearr_133130_133178[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133071);

return cljs.core.cst$kw$recur;
} else {
throw e133129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__133179 = state_133071;
state_133071 = G__133179;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__ = function(state_133071){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____1.call(this,state_133071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133131 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133131[(6)] = c__110077__auto__);

return statearr_133131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_133326){
var state_val_133327 = (state_133326[(1)]);
if((state_val_133327 === (7))){
var inst_133204 = (state_133326[(7)]);
var inst_133203 = (state_133326[(8)]);
var inst_133214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133215 = [inst_133203,inst_133204];
var inst_133216 = (new cljs.core.PersistentVector(null,2,(5),inst_133214,inst_133215,null));
var state_133326__$1 = state_133326;
var statearr_133328_133375 = state_133326__$1;
(statearr_133328_133375[(2)] = inst_133216);

(statearr_133328_133375[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (20))){
var inst_133277 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
var statearr_133329_133376 = state_133326__$1;
(statearr_133329_133376[(2)] = inst_133277);

(statearr_133329_133376[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (27))){
var inst_133300 = (state_133326[(9)]);
var inst_133293 = (state_133326[(10)]);
var inst_133310 = (state_133326[(2)]);
var inst_133311 = fluree.db.util.async.throw_err(inst_133310);
var inst_133312 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_133293,inst_133311);
var inst_133292 = inst_133300;
var inst_133293__$1 = inst_133312;
var state_133326__$1 = (function (){var statearr_133330 = state_133326;
(statearr_133330[(11)] = inst_133292);

(statearr_133330[(10)] = inst_133293__$1);

return statearr_133330;
})();
var statearr_133331_133377 = state_133326__$1;
(statearr_133331_133377[(2)] = null);

(statearr_133331_133377[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (1))){
var state_133326__$1 = state_133326;
var statearr_133332_133378 = state_133326__$1;
(statearr_133332_133378[(2)] = null);

(statearr_133332_133378[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (24))){
var inst_133293 = (state_133326[(10)]);
var state_133326__$1 = state_133326;
var statearr_133333_133379 = state_133326__$1;
(statearr_133333_133379[(2)] = inst_133293);

(statearr_133333_133379[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (4))){
var inst_133196 = (state_133326[(12)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_133326,(3),Error,null,(2));
var inst_133196__$1 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_133197 = cljs.core.seq(inst_133196__$1);
var inst_133198 = cljs.core.first(inst_133197);
var inst_133199 = cljs.core.next(inst_133197);
var inst_133200 = cljs.core.PersistentHashMap.EMPTY;
var inst_133201 = cljs.core.PersistentHashMap.EMPTY;
var inst_133202 = inst_133196__$1;
var inst_133203 = inst_133200;
var inst_133204 = inst_133201;
var state_133326__$1 = (function (){var statearr_133334 = state_133326;
(statearr_133334[(7)] = inst_133204);

(statearr_133334[(13)] = inst_133198);

(statearr_133334[(14)] = inst_133202);

(statearr_133334[(8)] = inst_133203);

(statearr_133334[(12)] = inst_133196__$1);

(statearr_133334[(15)] = inst_133199);

return statearr_133334;
})();
var statearr_133335_133380 = state_133326__$1;
(statearr_133335_133380[(2)] = null);

(statearr_133335_133380[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (15))){
var inst_133235 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
var statearr_133337_133381 = state_133326__$1;
(statearr_133337_133381[(2)] = inst_133235);

(statearr_133337_133381[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (21))){
var inst_133255 = (state_133326[(16)]);
var inst_133262 = (state_133326[(17)]);
var inst_133272 = (state_133326[(2)]);
var inst_133273 = fluree.db.util.async.throw_err(inst_133272);
var inst_133274 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_133255,inst_133273);
var inst_133254 = inst_133262;
var inst_133255__$1 = inst_133274;
var state_133326__$1 = (function (){var statearr_133338 = state_133326;
(statearr_133338[(16)] = inst_133255__$1);

(statearr_133338[(18)] = inst_133254);

return statearr_133338;
})();
var statearr_133339_133382 = state_133326__$1;
(statearr_133339_133382[(2)] = null);

(statearr_133339_133382[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (13))){
var inst_133204 = (state_133326[(7)]);
var inst_133220 = (state_133326[(19)]);
var inst_133198 = (state_133326[(13)]);
var inst_133202 = (state_133326[(14)]);
var inst_133203 = (state_133326[(8)]);
var inst_133196 = (state_133326[(12)]);
var inst_133210 = (state_133326[(20)]);
var inst_133211 = (state_133326[(21)]);
var inst_133199 = (state_133326[(15)]);
var inst_133225 = (state_133326[(22)]);
var inst_133218 = (state_133326[(23)]);
var inst_133227 = (function (){var G__133192 = inst_133202;
var subject = inst_133218;
var flake = inst_133210;
var vec__133206 = inst_133202;
var first__133208 = inst_133210;
var r = inst_133211;
var asserted_subjects = inst_133203;
var flake_SINGLEQUOTE_ = inst_133225;
var retracted_subjects = inst_133204;
var vec__133193 = inst_133196;
var seq__133207 = inst_133211;
var first__133195 = inst_133198;
var asserted_QMARK_ = inst_133220;
var seq__133194 = inst_133199;
return ((function (G__133192,subject,flake,vec__133206,first__133208,r,asserted_subjects,flake_SINGLEQUOTE_,retracted_subjects,vec__133193,seq__133207,first__133195,asserted_QMARK_,seq__133194,inst_133204,inst_133220,inst_133198,inst_133202,inst_133203,inst_133196,inst_133210,inst_133211,inst_133199,inst_133225,inst_133218,state_val_133327,c__110077__auto__){
return (function (p1__133180_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__133180_SHARP_,flake_SINGLEQUOTE_));
});
;})(G__133192,subject,flake,vec__133206,first__133208,r,asserted_subjects,flake_SINGLEQUOTE_,retracted_subjects,vec__133193,seq__133207,first__133195,asserted_QMARK_,seq__133194,inst_133204,inst_133220,inst_133198,inst_133202,inst_133203,inst_133196,inst_133210,inst_133211,inst_133199,inst_133225,inst_133218,state_val_133327,c__110077__auto__))
})();
var inst_133228 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_133203,inst_133218,inst_133227);
var tmp133336 = inst_133204;
var inst_133202__$1 = inst_133211;
var inst_133203__$1 = inst_133228;
var inst_133204__$1 = tmp133336;
var state_133326__$1 = (function (){var statearr_133340 = state_133326;
(statearr_133340[(7)] = inst_133204__$1);

(statearr_133340[(14)] = inst_133202__$1);

(statearr_133340[(8)] = inst_133203__$1);

return statearr_133340;
})();
var statearr_133341_133383 = state_133326__$1;
(statearr_133341_133383[(2)] = null);

(statearr_133341_133383[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (22))){
var inst_133292 = (state_133326[(11)]);
var inst_133299 = (state_133326[(24)]);
var inst_133298 = cljs.core.seq(inst_133292);
var inst_133299__$1 = cljs.core.first(inst_133298);
var inst_133300 = cljs.core.next(inst_133298);
var inst_133301 = cljs.core.not(inst_133299__$1);
var state_133326__$1 = (function (){var statearr_133342 = state_133326;
(statearr_133342[(9)] = inst_133300);

(statearr_133342[(24)] = inst_133299__$1);

return statearr_133342;
})();
if(inst_133301){
var statearr_133343_133384 = state_133326__$1;
(statearr_133343_133384[(1)] = (24));

} else {
var statearr_133344_133385 = state_133326__$1;
(statearr_133344_133385[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (6))){
var inst_133239 = (state_133326[(2)]);
var inst_133240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133239,(0),null);
var inst_133241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133239,(1),null);
var inst_133249 = cljs.core.vals(inst_133241);
var inst_133250 = cljs.core.seq(inst_133249);
var inst_133251 = cljs.core.first(inst_133250);
var inst_133252 = cljs.core.next(inst_133250);
var inst_133253 = cljs.core.PersistentVector.EMPTY;
var inst_133254 = inst_133249;
var inst_133255 = inst_133253;
var state_133326__$1 = (function (){var statearr_133345 = state_133326;
(statearr_133345[(16)] = inst_133255);

(statearr_133345[(18)] = inst_133254);

(statearr_133345[(25)] = inst_133240);

(statearr_133345[(26)] = inst_133251);

(statearr_133345[(27)] = inst_133252);

return statearr_133345;
})();
var statearr_133346_133386 = state_133326__$1;
(statearr_133346_133386[(2)] = null);

(statearr_133346_133386[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (25))){
var inst_133299 = (state_133326[(24)]);
var inst_133304 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$select];
var inst_133305 = cljs.core.PersistentHashMap.EMPTY;
var inst_133306 = [true,inst_133305];
var inst_133307 = cljs.core.PersistentHashMap.fromArrays(inst_133304,inst_133306);
var inst_133308 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_133307,inst_133299);
var state_133326__$1 = state_133326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133326__$1,(27),inst_133308);
} else {
if((state_val_133327 === (17))){
var inst_133240 = (state_133326[(25)]);
var inst_133279 = (state_133326[(2)]);
var inst_133287 = cljs.core.vals(inst_133240);
var inst_133288 = cljs.core.seq(inst_133287);
var inst_133289 = cljs.core.first(inst_133288);
var inst_133290 = cljs.core.next(inst_133288);
var inst_133291 = cljs.core.PersistentVector.EMPTY;
var inst_133292 = inst_133287;
var inst_133293 = inst_133291;
var state_133326__$1 = (function (){var statearr_133347 = state_133326;
(statearr_133347[(11)] = inst_133292);

(statearr_133347[(28)] = inst_133290);

(statearr_133347[(29)] = inst_133289);

(statearr_133347[(10)] = inst_133293);

(statearr_133347[(30)] = inst_133279);

return statearr_133347;
})();
var statearr_133348_133387 = state_133326__$1;
(statearr_133348_133387[(2)] = null);

(statearr_133348_133387[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (3))){
var inst_133182 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
var statearr_133349_133388 = state_133326__$1;
(statearr_133349_133388[(2)] = inst_133182);


cljs.core.async.impl.ioc_helpers.process_exception(state_133326__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (12))){
var inst_133220 = (state_133326[(19)]);
var inst_133225 = (state_133326[(2)]);
var state_133326__$1 = (function (){var statearr_133350 = state_133326;
(statearr_133350[(22)] = inst_133225);

return statearr_133350;
})();
if(cljs.core.truth_(inst_133220)){
var statearr_133351_133389 = state_133326__$1;
(statearr_133351_133389[(1)] = (13));

} else {
var statearr_133352_133390 = state_133326__$1;
(statearr_133352_133390[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (2))){
var inst_133324 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133326__$1,inst_133324);
} else {
if((state_val_133327 === (23))){
var inst_133279 = (state_133326[(30)]);
var inst_133317 = (state_133326[(2)]);
var inst_133318 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$retracted,cljs.core.cst$kw$asserted];
var inst_133319 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_133320 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_133321 = [inst_133319,inst_133320,inst_133279,inst_133317];
var inst_133322 = cljs.core.PersistentHashMap.fromArrays(inst_133318,inst_133321);
var state_133326__$1 = state_133326;
var statearr_133353_133391 = state_133326__$1;
(statearr_133353_133391[(2)] = inst_133322);


cljs.core.async.impl.ioc_helpers.process_exception(state_133326__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (19))){
var inst_133261 = (state_133326[(31)]);
var inst_133266 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$select];
var inst_133267 = cljs.core.PersistentHashMap.EMPTY;
var inst_133268 = [true,inst_133267];
var inst_133269 = cljs.core.PersistentHashMap.fromArrays(inst_133266,inst_133268);
var inst_133270 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_133269,inst_133261);
var state_133326__$1 = state_133326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133326__$1,(21),inst_133270);
} else {
if((state_val_133327 === (11))){
var inst_133210 = (state_133326[(20)]);
var inst_133223 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_133210);
var state_133326__$1 = state_133326;
var statearr_133354_133392 = state_133326__$1;
(statearr_133354_133392[(2)] = inst_133223);

(statearr_133354_133392[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (9))){
var inst_133237 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
var statearr_133356_133393 = state_133326__$1;
(statearr_133356_133393[(2)] = inst_133237);

(statearr_133356_133393[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (5))){
var inst_133202 = (state_133326[(14)]);
var inst_133210 = (state_133326[(20)]);
var inst_133209 = cljs.core.seq(inst_133202);
var inst_133210__$1 = cljs.core.first(inst_133209);
var inst_133211 = cljs.core.next(inst_133209);
var inst_133212 = cljs.core.not(inst_133210__$1);
var state_133326__$1 = (function (){var statearr_133357 = state_133326;
(statearr_133357[(20)] = inst_133210__$1);

(statearr_133357[(21)] = inst_133211);

return statearr_133357;
})();
if(inst_133212){
var statearr_133358_133394 = state_133326__$1;
(statearr_133358_133394[(1)] = (7));

} else {
var statearr_133359_133395 = state_133326__$1;
(statearr_133359_133395[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (14))){
var inst_133204 = (state_133326[(7)]);
var inst_133220 = (state_133326[(19)]);
var inst_133198 = (state_133326[(13)]);
var inst_133202 = (state_133326[(14)]);
var inst_133203 = (state_133326[(8)]);
var inst_133196 = (state_133326[(12)]);
var inst_133210 = (state_133326[(20)]);
var inst_133211 = (state_133326[(21)]);
var inst_133199 = (state_133326[(15)]);
var inst_133225 = (state_133326[(22)]);
var inst_133218 = (state_133326[(23)]);
var inst_133231 = (function (){var G__133192 = inst_133202;
var subject = inst_133218;
var flake = inst_133210;
var vec__133206 = inst_133202;
var first__133208 = inst_133210;
var r = inst_133211;
var asserted_subjects = inst_133203;
var flake_SINGLEQUOTE_ = inst_133225;
var retracted_subjects = inst_133204;
var vec__133193 = inst_133196;
var seq__133207 = inst_133211;
var first__133195 = inst_133198;
var asserted_QMARK_ = inst_133220;
var seq__133194 = inst_133199;
return ((function (G__133192,subject,flake,vec__133206,first__133208,r,asserted_subjects,flake_SINGLEQUOTE_,retracted_subjects,vec__133193,seq__133207,first__133195,asserted_QMARK_,seq__133194,inst_133204,inst_133220,inst_133198,inst_133202,inst_133203,inst_133196,inst_133210,inst_133211,inst_133199,inst_133225,inst_133218,state_val_133327,c__110077__auto__){
return (function (p1__133181_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__133181_SHARP_,flake_SINGLEQUOTE_));
});
;})(G__133192,subject,flake,vec__133206,first__133208,r,asserted_subjects,flake_SINGLEQUOTE_,retracted_subjects,vec__133193,seq__133207,first__133195,asserted_QMARK_,seq__133194,inst_133204,inst_133220,inst_133198,inst_133202,inst_133203,inst_133196,inst_133210,inst_133211,inst_133199,inst_133225,inst_133218,state_val_133327,c__110077__auto__))
})();
var inst_133232 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_133204,inst_133218,inst_133231);
var tmp133355 = inst_133203;
var inst_133202__$1 = inst_133211;
var inst_133203__$1 = tmp133355;
var inst_133204__$1 = inst_133232;
var state_133326__$1 = (function (){var statearr_133360 = state_133326;
(statearr_133360[(7)] = inst_133204__$1);

(statearr_133360[(14)] = inst_133202__$1);

(statearr_133360[(8)] = inst_133203__$1);

return statearr_133360;
})();
var statearr_133361_133396 = state_133326__$1;
(statearr_133361_133396[(2)] = null);

(statearr_133361_133396[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (26))){
var inst_133315 = (state_133326[(2)]);
var state_133326__$1 = state_133326;
var statearr_133362_133397 = state_133326__$1;
(statearr_133362_133397[(2)] = inst_133315);

(statearr_133362_133397[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (16))){
var inst_133254 = (state_133326[(18)]);
var inst_133261 = (state_133326[(31)]);
var inst_133260 = cljs.core.seq(inst_133254);
var inst_133261__$1 = cljs.core.first(inst_133260);
var inst_133262 = cljs.core.next(inst_133260);
var inst_133263 = cljs.core.not(inst_133261__$1);
var state_133326__$1 = (function (){var statearr_133363 = state_133326;
(statearr_133363[(17)] = inst_133262);

(statearr_133363[(31)] = inst_133261__$1);

return statearr_133363;
})();
if(inst_133263){
var statearr_133364_133398 = state_133326__$1;
(statearr_133364_133398[(1)] = (18));

} else {
var statearr_133365_133399 = state_133326__$1;
(statearr_133365_133399[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (10))){
var inst_133210 = (state_133326[(20)]);
var state_133326__$1 = state_133326;
var statearr_133366_133400 = state_133326__$1;
(statearr_133366_133400[(2)] = inst_133210);

(statearr_133366_133400[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (18))){
var inst_133255 = (state_133326[(16)]);
var state_133326__$1 = state_133326;
var statearr_133367_133401 = state_133326__$1;
(statearr_133367_133401[(2)] = inst_133255);

(statearr_133367_133401[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133327 === (8))){
var inst_133220 = (state_133326[(19)]);
var inst_133210 = (state_133326[(20)]);
var inst_133218 = inst_133210.s;
var inst_133219 = inst_133210.op;
var inst_133220__$1 = inst_133219 === true;
var state_133326__$1 = (function (){var statearr_133368 = state_133326;
(statearr_133368[(19)] = inst_133220__$1);

(statearr_133368[(23)] = inst_133218);

return statearr_133368;
})();
if(cljs.core.truth_(inst_133220__$1)){
var statearr_133369_133402 = state_133326__$1;
(statearr_133369_133402[(1)] = (10));

} else {
var statearr_133370_133403 = state_133326__$1;
(statearr_133370_133403[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____0 = (function (){
var statearr_133371 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133371[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__);

(statearr_133371[(1)] = (1));

return statearr_133371;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____1 = (function (state_133326){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133326);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133372){if((e133372 instanceof Object)){
var ex__109974__auto__ = e133372;
var statearr_133373_133404 = state_133326;
(statearr_133373_133404[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133326);

return cljs.core.cst$kw$recur;
} else {
throw e133372;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__133405 = state_133326;
state_133326 = G__133405;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__ = function(state_133326){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____1.call(this,state_133326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133374 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133374[(6)] = c__110077__auto__);

return statearr_133374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_133437){
var state_val_133438 = (state_133437[(1)]);
if((state_val_133438 === (1))){
var inst_133406 = cljs.core.volatile_BANG_((0));
var inst_133407 = cljs.core.PersistentHashMap.EMPTY;
var inst_133408 = cljs.core.volatile_BANG_(inst_133407);
var inst_133409 = cljs.core.first(resp);
var inst_133410 = cljs.core.rest(resp);
var inst_133411 = cljs.core.PersistentVector.EMPTY;
var inst_133412 = inst_133406;
var inst_133413 = inst_133408;
var inst_133414 = inst_133409;
var inst_133415 = inst_133410;
var inst_133416 = inst_133411;
var state_133437__$1 = (function (){var statearr_133439 = state_133437;
(statearr_133439[(7)] = inst_133416);

(statearr_133439[(8)] = inst_133415);

(statearr_133439[(9)] = inst_133412);

(statearr_133439[(10)] = inst_133413);

(statearr_133439[(11)] = inst_133414);

return statearr_133439;
})();
var statearr_133440_133454 = state_133437__$1;
(statearr_133440_133454[(2)] = null);

(statearr_133440_133454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133438 === (2))){
var inst_133412 = (state_133437[(9)]);
var inst_133413 = (state_133437[(10)]);
var inst_133414 = (state_133437[(11)]);
var inst_133418 = fluree.db.api.query.format_block_resp_pretty(db,inst_133414,inst_133413,inst_133412);
var state_133437__$1 = state_133437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133437__$1,(4),inst_133418);
} else {
if((state_val_133438 === (3))){
var inst_133435 = (state_133437[(2)]);
var state_133437__$1 = state_133437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133437__$1,inst_133435);
} else {
if((state_val_133438 === (4))){
var inst_133416 = (state_133437[(7)]);
var inst_133415 = (state_133437[(8)]);
var inst_133420 = (state_133437[(2)]);
var inst_133421 = fluree.db.util.async.throw_err(inst_133420);
var inst_133422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133423 = [inst_133421];
var inst_133424 = (new cljs.core.PersistentVector(null,1,(5),inst_133422,inst_133423,null));
var inst_133425 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_133416,inst_133424);
var inst_133426 = cljs.core.first(inst_133415);
var state_133437__$1 = (function (){var statearr_133443 = state_133437;
(statearr_133443[(12)] = inst_133425);

return statearr_133443;
})();
if(cljs.core.truth_(inst_133426)){
var statearr_133444_133455 = state_133437__$1;
(statearr_133444_133455[(1)] = (5));

} else {
var statearr_133445_133456 = state_133437__$1;
(statearr_133445_133456[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133438 === (5))){
var inst_133415 = (state_133437[(8)]);
var inst_133425 = (state_133437[(12)]);
var inst_133412 = (state_133437[(9)]);
var inst_133413 = (state_133437[(10)]);
var inst_133428 = cljs.core.first(inst_133415);
var inst_133429 = cljs.core.rest(inst_133415);
var tmp133441 = inst_133412;
var tmp133442 = inst_133413;
var inst_133412__$1 = tmp133441;
var inst_133413__$1 = tmp133442;
var inst_133414 = inst_133428;
var inst_133415__$1 = inst_133429;
var inst_133416 = inst_133425;
var state_133437__$1 = (function (){var statearr_133446 = state_133437;
(statearr_133446[(7)] = inst_133416);

(statearr_133446[(8)] = inst_133415__$1);

(statearr_133446[(9)] = inst_133412__$1);

(statearr_133446[(10)] = inst_133413__$1);

(statearr_133446[(11)] = inst_133414);

return statearr_133446;
})();
var statearr_133447_133457 = state_133437__$1;
(statearr_133447_133457[(2)] = null);

(statearr_133447_133457[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133438 === (6))){
var inst_133425 = (state_133437[(12)]);
var state_133437__$1 = state_133437;
var statearr_133448_133458 = state_133437__$1;
(statearr_133448_133458[(2)] = inst_133425);

(statearr_133448_133458[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133438 === (7))){
var inst_133433 = (state_133437[(2)]);
var state_133437__$1 = state_133437;
var statearr_133449_133459 = state_133437__$1;
(statearr_133449_133459[(2)] = inst_133433);

(statearr_133449_133459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____0 = (function (){
var statearr_133450 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133450[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__);

(statearr_133450[(1)] = (1));

return statearr_133450;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____1 = (function (state_133437){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133437);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133451){if((e133451 instanceof Object)){
var ex__109974__auto__ = e133451;
var statearr_133452_133460 = state_133437;
(statearr_133452_133460[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133437);

return cljs.core.cst$kw$recur;
} else {
throw e133451;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__133461 = state_133437;
state_133437 = G__133461;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__ = function(state_133437){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____1.call(this,state_133437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133453 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133453[(6)] = c__110077__auto__);

return statearr_133453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__133464 = arguments.length;
switch (G__133464) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
});

fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
});

fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4;

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,query_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_133577){
var state_val_133578 = (state_133577[(1)]);
if((state_val_133578 === (7))){
var inst_133489 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
if(cljs.core.truth_(inst_133489)){
var statearr_133579_133633 = state_133577__$1;
(statearr_133579_133633[(1)] = (11));

} else {
var statearr_133580_133634 = state_133577__$1;
(statearr_133580_133634[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (20))){
var inst_133528 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_133529 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_133528].join('');
var inst_133530 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_133531 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_133532 = cljs.core.PersistentHashMap.fromArrays(inst_133530,inst_133531);
var inst_133533 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_133529,inst_133532);
var inst_133534 = (function(){throw inst_133533})();
var state_133577__$1 = state_133577;
var statearr_133581_133635 = state_133577__$1;
(statearr_133581_133635[(2)] = inst_133534);

(statearr_133581_133635[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (27))){
var inst_133548 = cljs.core.cst$kw$pretty_DASH_print.cljs$core$IFn$_invoke$arity$1(query_map);
var state_133577__$1 = state_133577;
var statearr_133582_133636 = state_133577__$1;
(statearr_133582_133636[(2)] = inst_133548);

(statearr_133582_133636[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (1))){
var state_133577__$1 = state_133577;
var statearr_133583_133637 = state_133577__$1;
(statearr_133583_133637[(2)] = null);

(statearr_133583_133637[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (24))){
var state_133577__$1 = state_133577;
var statearr_133584_133638 = state_133577__$1;
(statearr_133584_133638[(2)] = null);

(statearr_133584_133638[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_133577,(3),Error,null,(2));
var inst_133475 = (query_map == null);
var inst_133476 = cljs.core.not(inst_133475);
var state_133577__$1 = state_133577;
if(inst_133476){
var statearr_133585_133639 = state_133577__$1;
(statearr_133585_133639[(1)] = (5));

} else {
var statearr_133586_133640 = state_133577__$1;
(statearr_133586_133640[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (15))){
var inst_133496 = (state_133577[(7)]);
var inst_133500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133501 = ["_auth/id",inst_133496];
var inst_133502 = (new cljs.core.PersistentVector(null,2,(5),inst_133500,inst_133501,null));
var state_133577__$1 = state_133577;
var statearr_133587_133641 = state_133577__$1;
(statearr_133587_133641[(2)] = inst_133502);

(statearr_133587_133641[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (21))){
var inst_133536 = (state_133577[(2)]);
var inst_133537 = cljs.core.cst$kw$pretty_DASH_print.cljs$core$IFn$_invoke$arity$1(query_map);
var state_133577__$1 = (function (){var statearr_133588 = state_133577;
(statearr_133588[(8)] = inst_133536);

return statearr_133588;
})();
if(cljs.core.truth_(inst_133537)){
var statearr_133589_133642 = state_133577__$1;
(statearr_133589_133642[(1)] = (23));

} else {
var statearr_133590_133643 = state_133577__$1;
(statearr_133590_133643[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (31))){
var inst_133495 = (state_133577[(9)]);
var inst_133558 = (state_133577[(2)]);
var inst_133559 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_133495);
var state_133577__$1 = (function (){var statearr_133591 = state_133577;
(statearr_133591[(10)] = inst_133558);

return statearr_133591;
})();
if(cljs.core.truth_(inst_133559)){
var statearr_133592_133644 = state_133577__$1;
(statearr_133592_133644[(1)] = (33));

} else {
var statearr_133593_133645 = state_133577__$1;
(statearr_133593_133645[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (32))){
var inst_133554 = (state_133577[(2)]);
var inst_133555 = fluree.db.util.async.throw_err(inst_133554);
var state_133577__$1 = state_133577;
var statearr_133594_133646 = state_133577__$1;
(statearr_133594_133646[(2)] = inst_133555);

(statearr_133594_133646[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (33))){
var inst_133558 = (state_133577[(10)]);
var inst_133561 = [cljs.core.cst$kw$status,cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$time];
var inst_133562 = cljs.core.sequential_QMARK_(inst_133558);
var state_133577__$1 = (function (){var statearr_133595 = state_133577;
(statearr_133595[(11)] = inst_133561);

return statearr_133595;
})();
if(inst_133562){
var statearr_133596_133647 = state_133577__$1;
(statearr_133596_133647[(1)] = (36));

} else {
var statearr_133597_133648 = state_133577__$1;
(statearr_133597_133648[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (13))){
var inst_133495 = (state_133577[(9)]);
var inst_133496 = (state_133577[(7)]);
var inst_133494 = (state_133577[(2)]);
var inst_133495__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_133494,cljs.core.cst$kw$opts);
var inst_133496__$1 = cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(inst_133495__$1);
var inst_133497 = fluree.db.util.core.current_time_millis();
var inst_133498 = [cljs.core.cst$kw$auth];
var state_133577__$1 = (function (){var statearr_133598 = state_133577;
(statearr_133598[(9)] = inst_133495__$1);

(statearr_133598[(7)] = inst_133496__$1);

(statearr_133598[(12)] = inst_133497);

(statearr_133598[(13)] = inst_133498);

return statearr_133598;
})();
if(cljs.core.truth_(inst_133496__$1)){
var statearr_133599_133649 = state_133577__$1;
(statearr_133599_133649[(1)] = (15));

} else {
var statearr_133600_133650 = state_133577__$1;
(statearr_133600_133650[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (22))){
var inst_133525 = (state_133577[(2)]);
var inst_133526 = fluree.db.util.async.throw_err(inst_133525);
var state_133577__$1 = state_133577;
var statearr_133601_133651 = state_133577__$1;
(statearr_133601_133651[(2)] = inst_133526);

(statearr_133601_133651[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (36))){
var inst_133558 = (state_133577[(10)]);
var inst_133564 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_133558);
var state_133577__$1 = state_133577;
var statearr_133602_133652 = state_133577__$1;
(statearr_133602_133652[(2)] = inst_133564);

(statearr_133602_133652[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (29))){
var inst_133511 = (state_133577[(14)]);
var inst_133536 = (state_133577[(8)]);
var inst_133552 = fluree.db.api.query.format_blocks_resp_pretty(inst_133511,inst_133536);
var state_133577__$1 = state_133577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133577__$1,(32),inst_133552);
} else {
if((state_val_133578 === (6))){
var state_133577__$1 = state_133577;
var statearr_133603_133653 = state_133577__$1;
(statearr_133603_133653[(2)] = false);

(statearr_133603_133653[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (28))){
var inst_133550 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
if(cljs.core.truth_(inst_133550)){
var statearr_133604_133654 = state_133577__$1;
(statearr_133604_133654[(1)] = (29));

} else {
var statearr_133605_133655 = state_133577__$1;
(statearr_133605_133655[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (25))){
var inst_133545 = (state_133577[(15)]);
var inst_133544 = (state_133577[(2)]);
var inst_133545__$1 = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(query_map);
var state_133577__$1 = (function (){var statearr_133606 = state_133577;
(statearr_133606[(15)] = inst_133545__$1);

(statearr_133606[(16)] = inst_133544);

return statearr_133606;
})();
if(cljs.core.truth_(inst_133545__$1)){
var statearr_133607_133656 = state_133577__$1;
(statearr_133607_133656[(1)] = (26));

} else {
var statearr_133608_133657 = state_133577__$1;
(statearr_133608_133657[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (34))){
var inst_133558 = (state_133577[(10)]);
var state_133577__$1 = state_133577;
var statearr_133609_133658 = state_133577__$1;
(statearr_133609_133658[(2)] = inst_133558);

(statearr_133609_133658[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (17))){
var inst_133498 = (state_133577[(13)]);
var inst_133505 = (state_133577[(2)]);
var inst_133506 = [inst_133505];
var inst_133507 = cljs.core.PersistentHashMap.fromArrays(inst_133498,inst_133506);
var inst_133508 = fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_133507);
var state_133577__$1 = state_133577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133577__$1,(14),inst_133508);
} else {
if((state_val_133578 === (3))){
var inst_133466 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
var statearr_133610_133659 = state_133577__$1;
(statearr_133610_133659[(2)] = inst_133466);


cljs.core.async.impl.ioc_helpers.process_exception(state_133577__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (12))){
var state_133577__$1 = state_133577;
var statearr_133611_133660 = state_133577__$1;
(statearr_133611_133660[(2)] = query_map);

(statearr_133611_133660[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (2))){
var inst_133575 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133577__$1,inst_133575);
} else {
if((state_val_133578 === (23))){
var inst_133539 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_133540 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_133539].join('');
var inst_133541 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_133540], 0));
var state_133577__$1 = state_133577;
var statearr_133612_133661 = state_133577__$1;
(statearr_133612_133661[(2)] = inst_133541);

(statearr_133612_133661[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (35))){
var inst_133573 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
var statearr_133613_133662 = state_133577__$1;
(statearr_133613_133662[(2)] = inst_133573);


cljs.core.async.impl.ioc_helpers.process_exception(state_133577__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (19))){
var inst_133495 = (state_133577[(9)]);
var inst_133516 = (state_133577[(17)]);
var inst_133517 = (state_133577[(18)]);
var inst_133511 = (state_133577[(14)]);
var inst_133523 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_133511,inst_133516,inst_133517,inst_133495);
var state_133577__$1 = state_133577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133577__$1,(22),inst_133523);
} else {
if((state_val_133578 === (11))){
var inst_133491 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,query_map);
var state_133577__$1 = state_133577;
var statearr_133614_133663 = state_133577__$1;
(statearr_133614_133663[(2)] = inst_133491);

(statearr_133614_133663[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (9))){
var state_133577__$1 = state_133577;
var statearr_133615_133664 = state_133577__$1;
(statearr_133615_133664[(2)] = false);

(statearr_133615_133664[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (5))){
var inst_133478 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_133479 = (inst_133478 & (64));
var inst_133480 = query_map.cljs$core$ISeq$;
var inst_133481 = (cljs.core.PROTOCOL_SENTINEL === inst_133480);
var inst_133482 = ((inst_133479) || (inst_133481));
var state_133577__$1 = state_133577;
if(cljs.core.truth_(inst_133482)){
var statearr_133616_133665 = state_133577__$1;
(statearr_133616_133665[(1)] = (8));

} else {
var statearr_133617_133666 = state_133577__$1;
(statearr_133617_133666[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (14))){
var inst_133511 = (state_133577[(14)]);
var inst_133510 = (state_133577[(2)]);
var inst_133511__$1 = fluree.db.util.async.throw_err(inst_133510);
var inst_133512 = fluree.db.api.query.resolve_block_range(inst_133511__$1,query_map);
var state_133577__$1 = (function (){var statearr_133618 = state_133577;
(statearr_133618[(14)] = inst_133511__$1);

return statearr_133618;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133577__$1,(18),inst_133512);
} else {
if((state_val_133578 === (26))){
var inst_133545 = (state_133577[(15)]);
var state_133577__$1 = state_133577;
var statearr_133619_133667 = state_133577__$1;
(statearr_133619_133667[(2)] = inst_133545);

(statearr_133619_133667[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (16))){
var state_133577__$1 = state_133577;
var statearr_133620_133668 = state_133577__$1;
(statearr_133620_133668[(2)] = null);

(statearr_133620_133668[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (38))){
var inst_133497 = (state_133577[(12)]);
var inst_133561 = (state_133577[(11)]);
var inst_133567 = (state_133577[(2)]);
var inst_133568 = fluree.db.api.query.response_time_formatted(inst_133497);
var inst_133569 = [(200),inst_133567,(100),inst_133568];
var inst_133570 = cljs.core.PersistentHashMap.fromArrays(inst_133561,inst_133569);
var state_133577__$1 = state_133577;
var statearr_133621_133669 = state_133577__$1;
(statearr_133621_133669[(2)] = inst_133570);

(statearr_133621_133669[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (30))){
var inst_133536 = (state_133577[(8)]);
var state_133577__$1 = state_133577;
var statearr_133622_133670 = state_133577__$1;
(statearr_133622_133670[(2)] = inst_133536);

(statearr_133622_133670[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (10))){
var inst_133486 = (state_133577[(2)]);
var state_133577__$1 = state_133577;
var statearr_133623_133671 = state_133577__$1;
(statearr_133623_133671[(2)] = inst_133486);

(statearr_133623_133671[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (18))){
var inst_133514 = (state_133577[(2)]);
var inst_133515 = fluree.db.util.async.throw_err(inst_133514);
var inst_133516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133515,(0),null);
var inst_133517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_133515,(1),null);
var inst_133518 = cljs.core.list(cljs.core.cst$kw$block);
var inst_133519 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,cljs.core.cst$kw$pretty_DASH_print);
var inst_133520 = cljs.core.keys(inst_133519);
var inst_133521 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_133518,inst_133520);
var state_133577__$1 = (function (){var statearr_133624 = state_133577;
(statearr_133624[(17)] = inst_133516);

(statearr_133624[(18)] = inst_133517);

return statearr_133624;
})();
if(inst_133521){
var statearr_133625_133672 = state_133577__$1;
(statearr_133625_133672[(1)] = (19));

} else {
var statearr_133626_133673 = state_133577__$1;
(statearr_133626_133673[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (37))){
var inst_133558 = (state_133577[(10)]);
var state_133577__$1 = state_133577;
var statearr_133627_133674 = state_133577__$1;
(statearr_133627_133674[(2)] = inst_133558);

(statearr_133627_133674[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133578 === (8))){
var state_133577__$1 = state_133577;
var statearr_133628_133675 = state_133577__$1;
(statearr_133628_133675[(2)] = true);

(statearr_133628_133675[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__109971__auto____0 = (function (){
var statearr_133629 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133629[(0)] = fluree$db$api$query$block_query_async_$_state_machine__109971__auto__);

(statearr_133629[(1)] = (1));

return statearr_133629;
});
var fluree$db$api$query$block_query_async_$_state_machine__109971__auto____1 = (function (state_133577){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133577);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133630){if((e133630 instanceof Object)){
var ex__109974__auto__ = e133630;
var statearr_133631_133676 = state_133577;
(statearr_133631_133676[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133577);

return cljs.core.cst$kw$recur;
} else {
throw e133630;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__133677 = state_133577;
state_133577 = G__133677;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__109971__auto__ = function(state_133577){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__109971__auto____1.call(this,state_133577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__109971__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__109971__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133632 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133632[(6)] = c__110077__auto__);

return statearr_133632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var vec__133678 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133678,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133678,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133678,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133678,(3),null);
var vec__133681 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$spot], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),cljs.core.cst$kw$psot], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),cljs.core.cst$kw$post], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133681,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133681,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__133684 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,cljs.core.cst$kw$auth], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133684,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__133684,(1),null);
var or__4131__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4736__auto__ = [];
var len__4730__auto___133688 = arguments.length;
var i__4731__auto___133689 = (0);
while(true){
if((i__4731__auto___133689 < len__4730__auto___133688)){
args__4736__auto__.push((arguments[i__4731__auto___133689]));

var G__133690 = (i__4731__auto___133689 + (1));
i__4731__auto___133689 = G__133690;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
});

fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq133687){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq133687));
});

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_133896){
var state_val_133897 = (state_133896[(1)]);
if((state_val_133897 === (7))){
var inst_133891 = (state_133896[(2)]);
var inst_133892 = cljs.core.vals(inst_133891);
var state_133896__$1 = state_133896;
var statearr_133898_133996 = state_133896__$1;
(statearr_133898_133996[(2)] = inst_133892);


cljs.core.async.impl.ioc_helpers.process_exception(state_133896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (20))){
var inst_133823 = (state_133896[(7)]);
var inst_133828 = inst_133823.cljs$lang$protocol_mask$partition0$;
var inst_133829 = (inst_133828 & (64));
var inst_133830 = inst_133823.cljs$core$ISeq$;
var inst_133831 = (cljs.core.PROTOCOL_SENTINEL === inst_133830);
var inst_133832 = ((inst_133829) || (inst_133831));
var state_133896__$1 = state_133896;
if(cljs.core.truth_(inst_133832)){
var statearr_133899_133997 = state_133896__$1;
(statearr_133899_133997[(1)] = (23));

} else {
var statearr_133900_133998 = state_133896__$1;
(statearr_133900_133998[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (27))){
var inst_133823 = (state_133896[(7)]);
var state_133896__$1 = state_133896;
var statearr_133901_133999 = state_133896__$1;
(statearr_133901_133999[(2)] = inst_133823);

(statearr_133901_133999[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (1))){
var state_133896__$1 = state_133896;
var statearr_133902_134000 = state_133896__$1;
(statearr_133902_134000[(2)] = null);

(statearr_133902_134000[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (24))){
var state_133896__$1 = state_133896;
var statearr_133903_134001 = state_133896__$1;
(statearr_133903_134001[(2)] = false);

(statearr_133903_134001[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (39))){
var inst_133871 = (state_133896[(8)]);
var state_133896__$1 = state_133896;
var statearr_133904_134002 = state_133896__$1;
(statearr_133904_134002[(2)] = inst_133871);

(statearr_133904_134002[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_133896,(3),Error,null,(2));
var inst_133696 = (function (){return ((function (_,state_val_133897,c__110077__auto__){
return (function (p1__133691_SHARP_){
return p1__133691_SHARP_.t;
});
;})(_,state_val_133897,c__110077__auto__))
})();
var inst_133697 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_133696,resp);
var inst_133698 = cljs.core.set(inst_133697);
var inst_133781 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_133782 = (function (){var ts = inst_133698;
var c__110077__auto____$1 = inst_133781;
return ((function (ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function (state_133779){
var state_val_133780 = (state_133779[(1)]);
if((state_val_133780 === (7))){
var inst_133711 = (state_133779[(7)]);
var inst_133717 = (state_133779[(8)]);
var inst_133723 = (state_133779[(9)]);
var inst_133722 = (state_133779[(2)]);
var inst_133723__$1 = fluree.db.util.async.throw_err(inst_133722);
var inst_133725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133726 = [inst_133717,cljs.core.cst$kw$block];
var inst_133727 = (new cljs.core.PersistentVector(null,2,(5),inst_133725,inst_133726,null));
var inst_133728 = cljs.core.assoc_in(inst_133711,inst_133727,inst_133723__$1);
var state_133779__$1 = (function (){var statearr_133905 = state_133779;
(statearr_133905[(9)] = inst_133723__$1);

(statearr_133905[(10)] = inst_133728);

return statearr_133905;
})();
if(cljs.core.truth_(auth)){
var statearr_133906_134003 = state_133779__$1;
(statearr_133906_134003[(1)] = (8));

} else {
var statearr_133907_134004 = state_133779__$1;
(statearr_133907_134004[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (1))){
var inst_133706 = cljs.core.seq(ts);
var inst_133707 = cljs.core.first(inst_133706);
var inst_133708 = cljs.core.next(inst_133706);
var inst_133709 = cljs.core.PersistentHashMap.EMPTY;
var inst_133710 = ts;
var inst_133711 = inst_133709;
var state_133779__$1 = (function (){var statearr_133908 = state_133779;
(statearr_133908[(7)] = inst_133711);

(statearr_133908[(11)] = inst_133708);

(statearr_133908[(12)] = inst_133710);

(statearr_133908[(13)] = inst_133707);

return statearr_133908;
})();
var statearr_133909_134005 = state_133779__$1;
(statearr_133909_134005[(2)] = null);

(statearr_133909_134005[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (4))){
var inst_133717 = (state_133779[(8)]);
var inst_133720 = fluree.db.time_travel.non_border_t_to_block(db,inst_133717);
var state_133779__$1 = state_133779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133779__$1,(7),inst_133720);
} else {
if((state_val_133780 === (13))){
var inst_133718 = (state_133779[(14)]);
var inst_133771 = (state_133779[(2)]);
var inst_133710 = inst_133718;
var inst_133711 = inst_133771;
var state_133779__$1 = (function (){var statearr_133910 = state_133779;
(statearr_133910[(7)] = inst_133711);

(statearr_133910[(12)] = inst_133710);

return statearr_133910;
})();
var statearr_133911_134006 = state_133779__$1;
(statearr_133911_134006[(2)] = null);

(statearr_133911_134006[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (6))){
var inst_133775 = (state_133779[(2)]);
var state_133779__$1 = state_133779;
var statearr_133912_134007 = state_133779__$1;
(statearr_133912_134007[(2)] = inst_133775);

(statearr_133912_134007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (3))){
var inst_133777 = (state_133779[(2)]);
var state_133779__$1 = state_133779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133779__$1,inst_133777);
} else {
if((state_val_133780 === (12))){
var inst_133728 = (state_133779[(10)]);
var state_133779__$1 = state_133779;
var statearr_133913_134008 = state_133779__$1;
(statearr_133913_134008[(2)] = inst_133728);

(statearr_133913_134008[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (2))){
var inst_133710 = (state_133779[(12)]);
var inst_133717 = (state_133779[(8)]);
var inst_133716 = cljs.core.seq(inst_133710);
var inst_133717__$1 = cljs.core.first(inst_133716);
var inst_133718 = cljs.core.next(inst_133716);
var state_133779__$1 = (function (){var statearr_133914 = state_133779;
(statearr_133914[(14)] = inst_133718);

(statearr_133914[(8)] = inst_133717__$1);

return statearr_133914;
})();
if(cljs.core.truth_(inst_133717__$1)){
var statearr_133915_134009 = state_133779__$1;
(statearr_133915_134009[(1)] = (4));

} else {
var statearr_133916_134010 = state_133779__$1;
(statearr_133916_134010[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (11))){
var inst_133718 = (state_133779[(14)]);
var inst_133711 = (state_133779[(7)]);
var inst_133708 = (state_133779[(11)]);
var inst_133710 = (state_133779[(12)]);
var inst_133707 = (state_133779[(13)]);
var inst_133717 = (state_133779[(8)]);
var inst_133723 = (state_133779[(9)]);
var inst_133728 = (state_133779[(10)]);
var inst_133734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133735 = [inst_133717,cljs.core.cst$kw$auth];
var inst_133736 = (new cljs.core.PersistentVector(null,2,(5),inst_133734,inst_133735,null));
var inst_133746 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_133747 = (function (){var G__133702 = inst_133710;
var t = inst_133717;
var G__133724 = inst_133728;
var block = inst_133723;
var r = inst_133718;
var first__133715 = inst_133717;
var seq__133714 = inst_133718;
var seq__133704 = inst_133708;
var acc = inst_133711;
var c__110077__auto____$2 = inst_133746;
var first__133705 = inst_133707;
var vec__133713 = inst_133710;
var vec__133703 = ts;
return ((function (G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function (state_133744){
var state_val_133745 = (state_133744[(1)]);
if((state_val_133745 === (1))){
var state_133744__$1 = state_133744;
var statearr_133917_134011 = state_133744__$1;
(statearr_133917_134011[(2)] = null);

(statearr_133917_134011[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133745 === (2))){
var inst_133742 = (state_133744[(2)]);
var state_133744__$1 = state_133744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133744__$1,inst_133742);
} else {
if((state_val_133745 === (3))){
var inst_133737 = (state_133744[(2)]);
var state_133744__$1 = state_133744;
var statearr_133918_134012 = state_133744__$1;
(statearr_133918_134012[(2)] = inst_133737);


cljs.core.async.impl.ioc_helpers.process_exception(state_133744__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133745 === (4))){
var ___$1 = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_133744,(3),Error,null,(2));
var state_133744__$1 = state_133744;
var statearr_133919_134013 = state_133744__$1;
(statearr_133919_134013[(2)] = db);


cljs.core.async.impl.ioc_helpers.process_exception(state_133744__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
;
return ((function (switch__109970__auto__,G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0 = (function (){
var statearr_133920 = [null,null,null,null,null,null,null];
(statearr_133920[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__);

(statearr_133920[(1)] = (1));

return statearr_133920;
});
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1 = (function (state_133744){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133744);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133921){if((e133921 instanceof Object)){
var ex__109974__auto__ = e133921;
var statearr_133922_134014 = state_133744;
(statearr_133922_134014[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133744);

return cljs.core.cst$kw$recur;
} else {
throw e133921;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134015 = state_133744;
state_133744 = G__134015;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = function(state_133744){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1.call(this,state_133744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133923 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133923[(6)] = c__110077__auto____$2);

return statearr_133923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});
;})(G__133702,t,G__133724,block,r,first__133715,seq__133714,seq__133704,acc,c__110077__auto____$2,first__133705,vec__133713,vec__133703,inst_133718,inst_133711,inst_133708,inst_133710,inst_133707,inst_133717,inst_133723,inst_133728,inst_133734,inst_133735,inst_133736,inst_133746,state_val_133780,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
})();
var inst_133748 = cljs.core.async.impl.dispatch.run(inst_133747);
var inst_133749 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$where];
var inst_133750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133751 = ["?auth","?id"];
var inst_133752 = (new cljs.core.PersistentVector(null,2,(5),inst_133750,inst_133751,null));
var inst_133753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133755 = [inst_133717,"_tx/auth","?auth"];
var inst_133756 = (new cljs.core.PersistentVector(null,3,(5),inst_133754,inst_133755,null));
var inst_133757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133758 = ["?auth","_auth/id","?id"];
var inst_133759 = (new cljs.core.PersistentVector(null,3,(5),inst_133757,inst_133758,null));
var inst_133760 = [inst_133756,inst_133759];
var inst_133761 = (new cljs.core.PersistentVector(null,2,(5),inst_133753,inst_133760,null));
var inst_133762 = [inst_133752,inst_133761];
var inst_133763 = cljs.core.PersistentHashMap.fromArrays(inst_133749,inst_133762);
var inst_133764 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_133746,inst_133763) : fluree.db.api.query.query_async.call(null,inst_133746,inst_133763));
var state_133779__$1 = (function (){var statearr_133924 = state_133779;
(statearr_133924[(15)] = inst_133748);

(statearr_133924[(16)] = inst_133736);

return statearr_133924;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133779__$1,(14),inst_133764);
} else {
if((state_val_133780 === (9))){
var state_133779__$1 = state_133779;
var statearr_133925_134016 = state_133779__$1;
(statearr_133925_134016[(2)] = show_auth);

(statearr_133925_134016[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (5))){
var inst_133711 = (state_133779[(7)]);
var state_133779__$1 = state_133779;
var statearr_133926_134017 = state_133779__$1;
(statearr_133926_134017[(2)] = inst_133711);

(statearr_133926_134017[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (14))){
var inst_133736 = (state_133779[(16)]);
var inst_133728 = (state_133779[(10)]);
var inst_133766 = (state_133779[(2)]);
var inst_133767 = fluree.db.util.async.throw_err(inst_133766);
var inst_133768 = cljs.core.assoc_in(inst_133728,inst_133736,inst_133767);
var state_133779__$1 = state_133779;
var statearr_133927_134018 = state_133779__$1;
(statearr_133927_134018[(2)] = inst_133768);

(statearr_133927_134018[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (10))){
var inst_133732 = (state_133779[(2)]);
var state_133779__$1 = state_133779;
if(cljs.core.truth_(inst_133732)){
var statearr_133928_134019 = state_133779__$1;
(statearr_133928_134019[(1)] = (11));

} else {
var statearr_133929_134020 = state_133779__$1;
(statearr_133929_134020[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133780 === (8))){
var state_133779__$1 = state_133779;
var statearr_133930_134021 = state_133779__$1;
(statearr_133930_134021[(2)] = auth);

(statearr_133930_134021[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
;
return ((function (switch__109970__auto__,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0 = (function (){
var statearr_133931 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133931[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__);

(statearr_133931[(1)] = (1));

return statearr_133931;
});
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1 = (function (state_133779){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133779);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133932){if((e133932 instanceof Object)){
var ex__109974__auto__ = e133932;
var statearr_133933_134022 = state_133779;
(statearr_133933_134022[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133779);

return cljs.core.cst$kw$recur;
} else {
throw e133932;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134023 = state_133779;
state_133779 = G__134023;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = function(state_133779){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1.call(this,state_133779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133934 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133934[(6)] = c__110077__auto____$1);

return statearr_133934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});
;})(ts,c__110077__auto____$1,_,inst_133696,inst_133697,inst_133698,inst_133781,state_val_133897,c__110077__auto__))
})();
var inst_133783 = cljs.core.async.impl.dispatch.run(inst_133782);
var state_133896__$1 = (function (){var statearr_133935 = state_133896;
(statearr_133935[(9)] = inst_133783);

return statearr_133935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_133896__$1,(5),inst_133781);
} else {
if((state_val_133897 === (15))){
var inst_133805 = (state_133896[(10)]);
var state_133896__$1 = state_133896;
if(cljs.core.truth_(inst_133805)){
var statearr_133936_134024 = state_133896__$1;
(statearr_133936_134024[(1)] = (17));

} else {
var statearr_133937_134025 = state_133896__$1;
(statearr_133937_134025[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (21))){
var state_133896__$1 = state_133896;
var statearr_133938_134026 = state_133896__$1;
(statearr_133938_134026[(2)] = false);

(statearr_133938_134026[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (31))){
var inst_133855 = (state_133896[(2)]);
var state_133896__$1 = (function (){var statearr_133939 = state_133896;
(statearr_133939[(11)] = inst_133855);

return statearr_133939;
})();
var statearr_133940_134027 = state_133896__$1;
(statearr_133940_134027[(1)] = (32));



return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (32))){
var inst_133805 = (state_133896[(10)]);
var inst_133855 = (state_133896[(11)]);
var inst_133845 = (state_133896[(12)]);
var inst_133857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133858 = [inst_133845,cljs.core.cst$kw$flakes];
var inst_133859 = (new cljs.core.PersistentVector(null,2,(5),inst_133857,inst_133858,null));
var inst_133860 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_133855,inst_133859,cljs.core.conj,inst_133805);
var state_133896__$1 = state_133896;
var statearr_133942_134028 = state_133896__$1;
(statearr_133942_134028[(2)] = inst_133860);

(statearr_133942_134028[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (40))){
var inst_133806 = (state_133896[(13)]);
var inst_133879 = (state_133896[(2)]);
var inst_133798 = inst_133806;
var inst_133799 = inst_133879;
var state_133896__$1 = (function (){var statearr_133943 = state_133896;
(statearr_133943[(14)] = inst_133798);

(statearr_133943[(15)] = inst_133799);

return statearr_133943;
})();
var statearr_133944_134029 = state_133896__$1;
(statearr_133944_134029[(2)] = null);

(statearr_133944_134029[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (33))){
var inst_133855 = (state_133896[(11)]);
var state_133896__$1 = state_133896;
var statearr_133945_134030 = state_133896__$1;
(statearr_133945_134030[(2)] = inst_133855);

(statearr_133945_134030[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (13))){
var inst_133813 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133946_134031 = state_133896__$1;
(statearr_133946_134031[(2)] = inst_133813);

(statearr_133946_134031[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (22))){
var inst_133839 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
if(cljs.core.truth_(inst_133839)){
var statearr_133947_134032 = state_133896__$1;
(statearr_133947_134032[(1)] = (26));

} else {
var statearr_133948_134033 = state_133896__$1;
(statearr_133948_134033[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (36))){
var inst_133863 = (state_133896[(16)]);
var state_133896__$1 = state_133896;
var statearr_133949_134034 = state_133896__$1;
(statearr_133949_134034[(2)] = inst_133863);

(statearr_133949_134034[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (41))){
var inst_133799 = (state_133896[(15)]);
var state_133896__$1 = state_133896;
var statearr_133950_134035 = state_133896__$1;
(statearr_133950_134035[(2)] = inst_133799);

(statearr_133950_134035[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (43))){
var inst_133885 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133951_134036 = state_133896__$1;
(statearr_133951_134036[(2)] = inst_133885);

(statearr_133951_134036[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (29))){
var inst_133845 = (state_133896[(12)]);
var inst_133799 = (state_133896[(15)]);
var inst_133849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133850 = [inst_133845,cljs.core.cst$kw$block];
var inst_133851 = (new cljs.core.PersistentVector(null,2,(5),inst_133849,inst_133850,null));
var inst_133852 = cljs.core.assoc_in(inst_133799,inst_133851,inst_133845);
var state_133896__$1 = state_133896;
var statearr_133952_134037 = state_133896__$1;
(statearr_133952_134037[(2)] = inst_133852);

(statearr_133952_134037[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (6))){
var inst_133805 = (state_133896[(10)]);
var inst_133798 = (state_133896[(14)]);
var inst_133804 = cljs.core.seq(inst_133798);
var inst_133805__$1 = cljs.core.first(inst_133804);
var inst_133806 = cljs.core.next(inst_133804);
var state_133896__$1 = (function (){var statearr_133953 = state_133896;
(statearr_133953[(10)] = inst_133805__$1);

(statearr_133953[(13)] = inst_133806);

return statearr_133953;
})();
if(cljs.core.truth_(inst_133805__$1)){
var statearr_133954_134038 = state_133896__$1;
(statearr_133954_134038[(1)] = (8));

} else {
var statearr_133955_134039 = state_133896__$1;
(statearr_133955_134039[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (28))){
var inst_133844 = (state_133896[(2)]);
var inst_133845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_133844,cljs.core.cst$kw$block);
var inst_133846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_133844,cljs.core.cst$kw$auth);
var state_133896__$1 = (function (){var statearr_133956 = state_133896;
(statearr_133956[(17)] = inst_133846);

(statearr_133956[(12)] = inst_133845);

return statearr_133956;
})();
var statearr_133957_134040 = state_133896__$1;
(statearr_133957_134040[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (25))){
var inst_133836 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133959_134041 = state_133896__$1;
(statearr_133959_134041[(2)] = inst_133836);

(statearr_133959_134041[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (34))){
var inst_133863 = (state_133896[(2)]);
var state_133896__$1 = (function (){var statearr_133960 = state_133896;
(statearr_133960[(16)] = inst_133863);

return statearr_133960;
})();
var statearr_133961_134042 = state_133896__$1;
(statearr_133961_134042[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (17))){
var inst_133805 = (state_133896[(10)]);
var inst_133823 = (state_133896[(7)]);
var inst_133822 = (state_133896[(18)]);
var inst_133786 = (state_133896[(19)]);
var inst_133822__$1 = inst_133805.t;
var inst_133823__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_133786,inst_133822__$1);
var inst_133825 = (inst_133823__$1 == null);
var inst_133826 = cljs.core.not(inst_133825);
var state_133896__$1 = (function (){var statearr_133963 = state_133896;
(statearr_133963[(7)] = inst_133823__$1);

(statearr_133963[(18)] = inst_133822__$1);

return statearr_133963;
})();
if(inst_133826){
var statearr_133964_134043 = state_133896__$1;
(statearr_133964_134043[(1)] = (20));

} else {
var statearr_133965_134044 = state_133896__$1;
(statearr_133965_134044[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (3))){
var inst_133692 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133966_134045 = state_133896__$1;
(statearr_133966_134045[(2)] = inst_133692);


cljs.core.async.impl.ioc_helpers.process_exception(state_133896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (12))){
var state_133896__$1 = state_133896;
var statearr_133967_134046 = state_133896__$1;
(statearr_133967_134046[(2)] = auth);

(statearr_133967_134046[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (2))){
var inst_133894 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_133896__$1,inst_133894);
} else {
if((state_val_133897 === (23))){
var state_133896__$1 = state_133896;
var statearr_133968_134047 = state_133896__$1;
(statearr_133968_134047[(2)] = true);

(statearr_133968_134047[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (35))){
var inst_133863 = (state_133896[(16)]);
var inst_133845 = (state_133896[(12)]);
var inst_133822 = (state_133896[(18)]);
var inst_133865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133866 = [inst_133845,cljs.core.cst$kw$t];
var inst_133867 = (new cljs.core.PersistentVector(null,2,(5),inst_133865,inst_133866,null));
var inst_133868 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_133863,inst_133867,fluree.db.api.query.min_safe,inst_133822);
var state_133896__$1 = state_133896;
var statearr_133969_134048 = state_133896__$1;
(statearr_133969_134048[(2)] = inst_133868);

(statearr_133969_134048[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (19))){
var inst_133887 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133970_134049 = state_133896__$1;
(statearr_133970_134049[(2)] = inst_133887);

(statearr_133970_134049[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (11))){
var inst_133805 = (state_133896[(10)]);
var inst_133786 = (state_133896[(19)]);
var inst_133809 = fluree.db.api.query.auth_match(auth,inst_133786,inst_133805);
var inst_133810 = cljs.core.not(inst_133809);
var state_133896__$1 = state_133896;
var statearr_133971_134050 = state_133896__$1;
(statearr_133971_134050[(2)] = inst_133810);

(statearr_133971_134050[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (9))){
var inst_133805 = (state_133896[(10)]);
var state_133896__$1 = state_133896;
var statearr_133973_134051 = state_133896__$1;
(statearr_133973_134051[(2)] = inst_133805);

(statearr_133973_134051[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (5))){
var inst_133785 = (state_133896[(2)]);
var inst_133786 = fluree.db.util.async.throw_err(inst_133785);
var inst_133794 = cljs.core.seq(resp);
var inst_133795 = cljs.core.first(inst_133794);
var inst_133796 = cljs.core.next(inst_133794);
var inst_133797 = cljs.core.PersistentHashMap.EMPTY;
var inst_133798 = resp;
var inst_133799 = inst_133797;
var state_133896__$1 = (function (){var statearr_133974 = state_133896;
(statearr_133974[(20)] = inst_133795);

(statearr_133974[(21)] = inst_133796);

(statearr_133974[(14)] = inst_133798);

(statearr_133974[(15)] = inst_133799);

(statearr_133974[(19)] = inst_133786);

return statearr_133974;
})();
var statearr_133975_134052 = state_133896__$1;
(statearr_133975_134052[(2)] = null);

(statearr_133975_134052[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (14))){
var inst_133806 = (state_133896[(13)]);
var inst_133799 = (state_133896[(15)]);
var tmp133972 = inst_133799;
var inst_133798 = inst_133806;
var inst_133799__$1 = tmp133972;
var state_133896__$1 = (function (){var statearr_133976 = state_133896;
(statearr_133976[(14)] = inst_133798);

(statearr_133976[(15)] = inst_133799__$1);

return statearr_133976;
})();
var statearr_133977_134053 = state_133896__$1;
(statearr_133977_134053[(2)] = null);

(statearr_133977_134053[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (26))){
var inst_133823 = (state_133896[(7)]);
var inst_133841 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_133823);
var state_133896__$1 = state_133896;
var statearr_133978_134054 = state_133896__$1;
(statearr_133978_134054[(2)] = inst_133841);

(statearr_133978_134054[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (16))){
var inst_133889 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
var statearr_133979_134055 = state_133896__$1;
(statearr_133979_134055[(2)] = inst_133889);

(statearr_133979_134055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (38))){
var inst_133846 = (state_133896[(17)]);
var inst_133871 = (state_133896[(8)]);
var inst_133845 = (state_133896[(12)]);
var inst_133873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_133874 = [inst_133845,cljs.core.cst$kw$auth];
var inst_133875 = (new cljs.core.PersistentVector(null,2,(5),inst_133873,inst_133874,null));
var inst_133876 = cljs.core.assoc_in(inst_133871,inst_133875,inst_133846);
var state_133896__$1 = state_133896;
var statearr_133980_134056 = state_133896__$1;
(statearr_133980_134056[(2)] = inst_133876);

(statearr_133980_134056[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (30))){
var inst_133799 = (state_133896[(15)]);
var state_133896__$1 = state_133896;
var statearr_133981_134057 = state_133896__$1;
(statearr_133981_134057[(2)] = inst_133799);

(statearr_133981_134057[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (10))){
var inst_133816 = (state_133896[(2)]);
var state_133896__$1 = state_133896;
if(cljs.core.truth_(inst_133816)){
var statearr_133982_134058 = state_133896__$1;
(statearr_133982_134058[(1)] = (14));

} else {
var statearr_133983_134059 = state_133896__$1;
(statearr_133983_134059[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (18))){
var state_133896__$1 = state_133896;
var statearr_133984_134060 = state_133896__$1;
(statearr_133984_134060[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (42))){
var state_133896__$1 = state_133896;
var statearr_133986_134061 = state_133896__$1;
(statearr_133986_134061[(2)] = null);

(statearr_133986_134061[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (37))){
var inst_133871 = (state_133896[(2)]);
var state_133896__$1 = (function (){var statearr_133987 = state_133896;
(statearr_133987[(8)] = inst_133871);

return statearr_133987;
})();
if(cljs.core.truth_(show_auth)){
var statearr_133988_134062 = state_133896__$1;
(statearr_133988_134062[(1)] = (38));

} else {
var statearr_133989_134063 = state_133896__$1;
(statearr_133989_134063[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_133897 === (8))){
var state_133896__$1 = state_133896;
if(cljs.core.truth_(auth)){
var statearr_133990_134064 = state_133896__$1;
(statearr_133990_134064[(1)] = (11));

} else {
var statearr_133991_134065 = state_133896__$1;
(statearr_133991_134065[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0 = (function (){
var statearr_133992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_133992[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__);

(statearr_133992[(1)] = (1));

return statearr_133992;
});
var fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1 = (function (state_133896){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_133896);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e133993){if((e133993 instanceof Object)){
var ex__109974__auto__ = e133993;
var statearr_133994_134066 = state_133896;
(statearr_133994_134066[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_133896);

return cljs.core.cst$kw$recur;
} else {
throw e133993;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134067 = state_133896;
state_133896 = G__134067;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__ = function(state_133896){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1.call(this,state_133896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__109971__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_133995 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_133995[(6)] = c__110077__auto__);

return statearr_133995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_134223){
var state_val_134224 = (state_134223[(1)]);
if((state_val_134224 === (7))){
var inst_134091 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
if(cljs.core.truth_(inst_134091)){
var statearr_134225_134303 = state_134223__$1;
(statearr_134225_134303[(1)] = (11));

} else {
var statearr_134226_134304 = state_134223__$1;
(statearr_134226_134304[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (20))){
var inst_134097 = (state_134223[(7)]);
var inst_134121 = (state_134223[(2)]);
var state_134223__$1 = (function (){var statearr_134227 = state_134223;
(statearr_134227[(8)] = inst_134121);

return statearr_134227;
})();
if(cljs.core.truth_(inst_134097)){
var statearr_134228_134305 = state_134223__$1;
(statearr_134228_134305[(1)] = (21));

} else {
var statearr_134229_134306 = state_134223__$1;
(statearr_134229_134306[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (27))){
var inst_134219 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
var statearr_134230_134307 = state_134223__$1;
(statearr_134230_134307[(2)] = inst_134219);


cljs.core.async.impl.ioc_helpers.process_exception(state_134223__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (1))){
var state_134223__$1 = state_134223;
var statearr_134231_134308 = state_134223__$1;
(statearr_134231_134308[(2)] = null);

(statearr_134231_134308[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (24))){
var inst_134125 = (state_134223[(2)]);
var inst_134126 = fluree.db.util.async.throw_err(inst_134125);
var state_134223__$1 = state_134223;
var statearr_134232_134309 = state_134223__$1;
(statearr_134232_134309[(2)] = inst_134126);

(statearr_134232_134309[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (55))){
var inst_134201 = (state_134223[(9)]);
var state_134223__$1 = state_134223;
var statearr_134233_134310 = state_134223__$1;
(statearr_134233_134310[(2)] = inst_134201);

(statearr_134233_134310[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (39))){
var inst_134103 = (state_134223[(10)]);
var inst_134175 = (state_134223[(2)]);
var inst_134176 = fluree.db.util.async.throw_err(inst_134175);
var state_134223__$1 = (function (){var statearr_134234 = state_134223;
(statearr_134234[(11)] = inst_134176);

return statearr_134234;
})();
if(cljs.core.truth_(inst_134103)){
var statearr_134235_134311 = state_134223__$1;
(statearr_134235_134311[(1)] = (40));

} else {
var statearr_134236_134312 = state_134223__$1;
(statearr_134236_134312[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (46))){
var inst_134181 = (state_134223[(12)]);
var inst_134176 = (state_134223[(11)]);
var inst_134107 = (state_134223[(13)]);
var inst_134185 = (state_134223[(2)]);
var inst_134186 = fluree.db.api.query.format_history_resp(inst_134107,inst_134176,inst_134181,inst_134185);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(43),inst_134186);
} else {
if((state_val_134224 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_134223,(3),Error,null,(2));
var inst_134077 = (query_map == null);
var inst_134078 = cljs.core.not(inst_134077);
var state_134223__$1 = state_134223;
if(inst_134078){
var statearr_134237_134313 = state_134223__$1;
(statearr_134237_134313[(1)] = (5));

} else {
var statearr_134238_134314 = state_134223__$1;
(statearr_134238_134314[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (54))){
var inst_134201 = (state_134223[(9)]);
var inst_134176 = (state_134223[(11)]);
var inst_134203 = [cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$status];
var inst_134204 = cljs.core.count(inst_134176);
var inst_134205 = [inst_134201,inst_134204,(200)];
var inst_134206 = cljs.core.PersistentHashMap.fromArrays(inst_134203,inst_134205);
var state_134223__$1 = state_134223;
var statearr_134239_134315 = state_134223__$1;
(statearr_134239_134315[(2)] = inst_134206);

(statearr_134239_134315[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (15))){
var inst_134109 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_134110 = ["The pretty-print key should be rename `prettyPrint`. `pretty-print` is being deprecated. Provided: ",inst_134109].join('');
var inst_134111 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_134110], 0));
var state_134223__$1 = state_134223;
var statearr_134240_134316 = state_134223__$1;
(statearr_134240_134316[(2)] = inst_134111);

(statearr_134240_134316[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (48))){
var inst_134099 = (state_134223[(14)]);
var state_134223__$1 = state_134223;
var statearr_134241_134317 = state_134223__$1;
(statearr_134241_134317[(2)] = inst_134099);

(statearr_134241_134317[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (50))){
var inst_134107 = (state_134223[(13)]);
var inst_134189 = (state_134223[(15)]);
var inst_134195 = fluree.db.api.query.format_blocks_resp_pretty(inst_134107,inst_134189);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(53),inst_134195);
} else {
if((state_val_134224 === (21))){
var inst_134107 = (state_134223[(13)]);
var inst_134123 = fluree.db.api.query.resolve_block_range(inst_134107,query_map);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(24),inst_134123);
} else {
if((state_val_134224 === (31))){
var inst_134130 = (state_134223[(16)]);
var inst_134107 = (state_134223[(13)]);
var inst_134147 = (inst_134130 - (1));
var inst_134148 = fluree.db.time_travel.as_of_block(inst_134107,inst_134147);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(34),inst_134148);
} else {
if((state_val_134224 === (32))){
var state_134223__$1 = state_134223;
var statearr_134242_134318 = state_134223__$1;
(statearr_134242_134318[(2)] = (-1));

(statearr_134242_134318[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (40))){
var inst_134103 = (state_134223[(10)]);
var inst_134178 = cljs.core.set(inst_134103);
var state_134223__$1 = state_134223;
var statearr_134243_134319 = state_134223__$1;
(statearr_134243_134319[(2)] = inst_134178);

(statearr_134243_134319[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (56))){
var inst_134209 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
var statearr_134244_134320 = state_134223__$1;
(statearr_134244_134320[(2)] = inst_134209);

(statearr_134244_134320[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (33))){
var inst_134131 = (state_134223[(17)]);
var inst_134156 = (state_134223[(2)]);
var state_134223__$1 = (function (){var statearr_134245 = state_134223;
(statearr_134245[(18)] = inst_134156);

return statearr_134245;
})();
if(cljs.core.truth_(inst_134131)){
var statearr_134246_134321 = state_134223__$1;
(statearr_134246_134321[(1)] = (35));

} else {
var statearr_134247_134322 = state_134223__$1;
(statearr_134247_134322[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (13))){
var inst_134096 = (state_134223[(2)]);
var inst_134097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$block);
var inst_134098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$history);
var inst_134099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$pretty_DASH_print);
var inst_134100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$prettyPrint);
var inst_134101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$show_DASH_auth);
var inst_134102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$showAuth);
var inst_134103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$auth);
var inst_134104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134096,cljs.core.cst$kw$opts);
var state_134223__$1 = (function (){var statearr_134248 = state_134223;
(statearr_134248[(19)] = inst_134102);

(statearr_134248[(14)] = inst_134099);

(statearr_134248[(10)] = inst_134103);

(statearr_134248[(7)] = inst_134097);

(statearr_134248[(20)] = inst_134098);

(statearr_134248[(21)] = inst_134101);

(statearr_134248[(22)] = inst_134100);

(statearr_134248[(23)] = inst_134104);

return statearr_134248;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(14),sources);
} else {
if((state_val_134224 === (22))){
var state_134223__$1 = state_134223;
var statearr_134249_134323 = state_134223__$1;
(statearr_134249_134323[(2)] = null);

(statearr_134249_134323[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (36))){
var inst_134107 = (state_134223[(13)]);
var inst_134164 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_134107);
var state_134223__$1 = state_134223;
var statearr_134250_134324 = state_134223__$1;
(statearr_134250_134324[(2)] = inst_134164);

(statearr_134250_134324[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (41))){
var state_134223__$1 = state_134223;
var statearr_134251_134325 = state_134223__$1;
(statearr_134251_134325[(2)] = null);

(statearr_134251_134325[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (43))){
var inst_134100 = (state_134223[(22)]);
var inst_134188 = (state_134223[(2)]);
var inst_134189 = fluree.db.util.async.throw_err(inst_134188);
var state_134223__$1 = (function (){var statearr_134252 = state_134223;
(statearr_134252[(15)] = inst_134189);

return statearr_134252;
})();
if(cljs.core.truth_(inst_134100)){
var statearr_134253_134326 = state_134223__$1;
(statearr_134253_134326[(1)] = (47));

} else {
var statearr_134254_134327 = state_134223__$1;
(statearr_134254_134327[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (29))){
var inst_134130 = (state_134223[(16)]);
var state_134223__$1 = state_134223;
var statearr_134255_134328 = state_134223__$1;
(statearr_134255_134328[(2)] = inst_134130);

(statearr_134255_134328[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (44))){
var inst_134102 = (state_134223[(19)]);
var state_134223__$1 = state_134223;
var statearr_134256_134329 = state_134223__$1;
(statearr_134256_134329[(2)] = inst_134102);

(statearr_134256_134329[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (6))){
var state_134223__$1 = state_134223;
var statearr_134257_134330 = state_134223__$1;
(statearr_134257_134330[(2)] = false);

(statearr_134257_134330[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (28))){
var inst_134130 = (state_134223[(16)]);
var inst_134142 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_134130);
var state_134223__$1 = state_134223;
var statearr_134258_134331 = state_134223__$1;
(statearr_134258_134331[(2)] = inst_134142);

(statearr_134258_134331[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (51))){
var inst_134189 = (state_134223[(15)]);
var state_134223__$1 = state_134223;
var statearr_134259_134332 = state_134223__$1;
(statearr_134259_134332[(2)] = inst_134189);

(statearr_134259_134332[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (25))){
var inst_134130 = (state_134223[(16)]);
var inst_134104 = (state_134223[(23)]);
var inst_134140 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_134104);
var state_134223__$1 = (function (){var statearr_134260 = state_134223;
(statearr_134260[(24)] = inst_134140);

return statearr_134260;
})();
if(cljs.core.truth_(inst_134130)){
var statearr_134261_134333 = state_134223__$1;
(statearr_134261_134333[(1)] = (28));

} else {
var statearr_134262_134334 = state_134223__$1;
(statearr_134262_134334[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (34))){
var inst_134150 = (state_134223[(2)]);
var inst_134151 = fluree.db.util.async.throw_err(inst_134150);
var inst_134152 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_134151);
var inst_134153 = (inst_134152 - (1));
var state_134223__$1 = state_134223;
var statearr_134263_134335 = state_134223__$1;
(statearr_134263_134335[(2)] = inst_134153);

(statearr_134263_134335[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (17))){
var inst_134101 = (state_134223[(21)]);
var inst_134114 = (state_134223[(2)]);
var state_134223__$1 = (function (){var statearr_134264 = state_134223;
(statearr_134264[(25)] = inst_134114);

return statearr_134264;
})();
if(cljs.core.truth_(inst_134101)){
var statearr_134265_134336 = state_134223__$1;
(statearr_134265_134336[(1)] = (18));

} else {
var statearr_134266_134337 = state_134223__$1;
(statearr_134266_134337[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (3))){
var inst_134068 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
var statearr_134267_134338 = state_134223__$1;
(statearr_134267_134338[(2)] = inst_134068);


cljs.core.async.impl.ioc_helpers.process_exception(state_134223__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (12))){
var state_134223__$1 = state_134223;
var statearr_134268_134339 = state_134223__$1;
(statearr_134268_134339[(2)] = query_map);

(statearr_134268_134339[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (2))){
var inst_134221 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_134223__$1,inst_134221);
} else {
if((state_val_134224 === (23))){
var inst_134129 = (state_134223[(2)]);
var inst_134130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134129,(0),null);
var inst_134131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134129,(1),null);
var inst_134132 = cljs.core.list(cljs.core.cst$kw$history);
var inst_134133 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$pretty_DASH_print,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$auth,cljs.core.cst$kw$show_DASH_auth,cljs.core.cst$kw$showAuth,cljs.core.cst$kw$opts], 0));
var inst_134134 = cljs.core.keys(inst_134133);
var inst_134135 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_134132,inst_134134);
var state_134223__$1 = (function (){var statearr_134269 = state_134223;
(statearr_134269[(16)] = inst_134130);

(statearr_134269[(17)] = inst_134131);

return statearr_134269;
})();
if(inst_134135){
var statearr_134270_134340 = state_134223__$1;
(statearr_134270_134340[(1)] = (25));

} else {
var statearr_134271_134341 = state_134223__$1;
(statearr_134271_134341[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (47))){
var inst_134100 = (state_134223[(22)]);
var state_134223__$1 = state_134223;
var statearr_134272_134342 = state_134223__$1;
(statearr_134272_134342[(2)] = inst_134100);

(statearr_134272_134342[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (35))){
var inst_134131 = (state_134223[(17)]);
var inst_134107 = (state_134223[(13)]);
var inst_134158 = fluree.db.time_travel.as_of_block(inst_134107,inst_134131);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(38),inst_134158);
} else {
if((state_val_134224 === (19))){
var state_134223__$1 = state_134223;
var statearr_134273_134343 = state_134223__$1;
(statearr_134273_134343[(2)] = null);

(statearr_134273_134343[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (11))){
var inst_134093 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,query_map);
var state_134223__$1 = state_134223;
var statearr_134274_134344 = state_134223__$1;
(statearr_134274_134344[(2)] = inst_134093);

(statearr_134274_134344[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (9))){
var state_134223__$1 = state_134223;
var statearr_134275_134345 = state_134223__$1;
(statearr_134275_134345[(2)] = false);

(statearr_134275_134345[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (5))){
var inst_134080 = query_map.cljs$lang$protocol_mask$partition0$;
var inst_134081 = (inst_134080 & (64));
var inst_134082 = query_map.cljs$core$ISeq$;
var inst_134083 = (cljs.core.PROTOCOL_SENTINEL === inst_134082);
var inst_134084 = ((inst_134081) || (inst_134083));
var state_134223__$1 = state_134223;
if(cljs.core.truth_(inst_134084)){
var statearr_134276_134346 = state_134223__$1;
(statearr_134276_134346[(1)] = (8));

} else {
var statearr_134277_134347 = state_134223__$1;
(statearr_134277_134347[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (14))){
var inst_134099 = (state_134223[(14)]);
var inst_134106 = (state_134223[(2)]);
var inst_134107 = fluree.db.util.async.throw_err(inst_134106);
var state_134223__$1 = (function (){var statearr_134278 = state_134223;
(statearr_134278[(13)] = inst_134107);

return statearr_134278;
})();
if(cljs.core.truth_(inst_134099)){
var statearr_134279_134348 = state_134223__$1;
(statearr_134279_134348[(1)] = (15));

} else {
var statearr_134280_134349 = state_134223__$1;
(statearr_134280_134349[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (45))){
var inst_134101 = (state_134223[(21)]);
var state_134223__$1 = state_134223;
var statearr_134281_134350 = state_134223__$1;
(statearr_134281_134350[(2)] = inst_134101);

(statearr_134281_134350[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (53))){
var inst_134197 = (state_134223[(2)]);
var inst_134198 = fluree.db.util.async.throw_err(inst_134197);
var state_134223__$1 = state_134223;
var statearr_134282_134351 = state_134223__$1;
(statearr_134282_134351[(2)] = inst_134198);

(statearr_134282_134351[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (26))){
var inst_134211 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_134212 = ["History query not properly formatted. Provided ",inst_134211].join('');
var inst_134213 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_134214 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_134215 = cljs.core.PersistentHashMap.fromArrays(inst_134213,inst_134214);
var inst_134216 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_134212,inst_134215);
var inst_134217 = (function(){throw inst_134216})();
var state_134223__$1 = state_134223;
var statearr_134283_134352 = state_134223__$1;
(statearr_134283_134352[(2)] = inst_134217);

(statearr_134283_134352[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (16))){
var state_134223__$1 = state_134223;
var statearr_134284_134353 = state_134223__$1;
(statearr_134284_134353[(2)] = null);

(statearr_134284_134353[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (38))){
var inst_134160 = (state_134223[(2)]);
var inst_134161 = fluree.db.util.async.throw_err(inst_134160);
var inst_134162 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_134161);
var state_134223__$1 = state_134223;
var statearr_134285_134354 = state_134223__$1;
(statearr_134285_134354[(2)] = inst_134162);

(statearr_134285_134354[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (30))){
var inst_134145 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
if(cljs.core.truth_(inst_134145)){
var statearr_134286_134355 = state_134223__$1;
(statearr_134286_134355[(1)] = (31));

} else {
var statearr_134287_134356 = state_134223__$1;
(statearr_134287_134356[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (10))){
var inst_134088 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
var statearr_134288_134357 = state_134223__$1;
(statearr_134288_134357[(2)] = inst_134088);

(statearr_134288_134357[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (18))){
var inst_134116 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_134117 = ["The show-auth key should be rename `showAuth`. `pretty-print` is being deprecated. Provided: ",inst_134116].join('');
var inst_134118 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_134117], 0));
var state_134223__$1 = state_134223;
var statearr_134289_134358 = state_134223__$1;
(statearr_134289_134358[(2)] = inst_134118);

(statearr_134289_134358[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (52))){
var inst_134140 = (state_134223[(24)]);
var inst_134201 = (state_134223[(2)]);
var state_134223__$1 = (function (){var statearr_134290 = state_134223;
(statearr_134290[(9)] = inst_134201);

return statearr_134290;
})();
if(cljs.core.truth_(inst_134140)){
var statearr_134291_134359 = state_134223__$1;
(statearr_134291_134359[(1)] = (54));

} else {
var statearr_134292_134360 = state_134223__$1;
(statearr_134292_134360[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (42))){
var inst_134102 = (state_134223[(19)]);
var inst_134181 = (state_134223[(2)]);
var state_134223__$1 = (function (){var statearr_134293 = state_134223;
(statearr_134293[(12)] = inst_134181);

return statearr_134293;
})();
if(cljs.core.truth_(inst_134102)){
var statearr_134294_134361 = state_134223__$1;
(statearr_134294_134361[(1)] = (44));

} else {
var statearr_134295_134362 = state_134223__$1;
(statearr_134295_134362[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (37))){
var inst_134156 = (state_134223[(18)]);
var inst_134107 = (state_134223[(13)]);
var inst_134098 = (state_134223[(20)]);
var inst_134166 = (state_134223[(2)]);
var inst_134167 = fluree.db.api.query.get_history_pattern(inst_134098);
var inst_134168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134167,(0),null);
var inst_134169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134167,(1),null);
var inst_134170 = [cljs.core.cst$kw$from_DASH_t,cljs.core.cst$kw$to_DASH_t];
var inst_134171 = [inst_134156,inst_134166];
var inst_134172 = cljs.core.PersistentHashMap.fromArrays(inst_134170,inst_134171);
var inst_134173 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_134107,inst_134169,cljs.core._EQ_,inst_134168,inst_134172);
var state_134223__$1 = state_134223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134223__$1,(39),inst_134173);
} else {
if((state_val_134224 === (8))){
var state_134223__$1 = state_134223;
var statearr_134296_134363 = state_134223__$1;
(statearr_134296_134363[(2)] = true);

(statearr_134296_134363[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134224 === (49))){
var inst_134193 = (state_134223[(2)]);
var state_134223__$1 = state_134223;
if(cljs.core.truth_(inst_134193)){
var statearr_134297_134364 = state_134223__$1;
(statearr_134297_134364[(1)] = (50));

} else {
var statearr_134298_134365 = state_134223__$1;
(statearr_134298_134365[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__109971__auto____0 = (function (){
var statearr_134299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_134299[(0)] = fluree$db$api$query$history_query_async_$_state_machine__109971__auto__);

(statearr_134299[(1)] = (1));

return statearr_134299;
});
var fluree$db$api$query$history_query_async_$_state_machine__109971__auto____1 = (function (state_134223){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_134223);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e134300){if((e134300 instanceof Object)){
var ex__109974__auto__ = e134300;
var statearr_134301_134366 = state_134223;
(statearr_134301_134366[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_134223);

return cljs.core.cst$kw$recur;
} else {
throw e134300;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134367 = state_134223;
state_134223 = G__134367;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__109971__auto__ = function(state_134223){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__109971__auto____1.call(this,state_134223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__109971__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__109971__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_134302 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_134302[(6)] = c__110077__auto__);

return statearr_134302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_134515){
var state_val_134516 = (state_134515[(1)]);
if((state_val_134516 === (7))){
var inst_134389 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134389)){
var statearr_134517_134601 = state_134515__$1;
(statearr_134517_134601[(1)] = (11));

} else {
var statearr_134518_134602 = state_134515__$1;
(statearr_134518_134602[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (59))){
var inst_134511 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134519_134603 = state_134515__$1;
(statearr_134519_134603[(2)] = inst_134511);


cljs.core.async.impl.ioc_helpers.process_exception(state_134515__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (20))){
var inst_134429 = (state_134515[(2)]);
var inst_134430 = fluree.db.util.async.throw_err(inst_134429);
var state_134515__$1 = state_134515;
var statearr_134520_134604 = state_134515__$1;
(statearr_134520_134604[(2)] = inst_134430);

(statearr_134520_134604[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (58))){
var inst_134501 = (state_134515[(7)]);
var state_134515__$1 = state_134515;
var statearr_134521_134605 = state_134515__$1;
(statearr_134521_134605[(2)] = inst_134501);

(statearr_134521_134605[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (27))){
var inst_134446 = (state_134515[(8)]);
var state_134515__$1 = state_134515;
var statearr_134522_134606 = state_134515__$1;
(statearr_134522_134606[(2)] = inst_134446);

(statearr_134522_134606[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (1))){
var state_134515__$1 = state_134515;
var statearr_134523_134607 = state_134515__$1;
(statearr_134523_134607[(2)] = null);

(statearr_134523_134607[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (24))){
var inst_134443 = cljs.core.PersistentHashMap.EMPTY;
var state_134515__$1 = state_134515;
var statearr_134524_134608 = state_134515__$1;
(statearr_134524_134608[(2)] = inst_134443);

(statearr_134524_134608[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (55))){
var inst_134462 = (state_134515[(9)]);
var inst_134436 = (state_134515[(10)]);
var inst_134495 = (state_134515[(2)]);
var inst_134496 = fluree.db.util.core.current_time_millis();
var inst_134497 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,cljs.core.cst$kw$opts,inst_134462);
var inst_134498 = fluree.db.query.fql.query(inst_134436,inst_134497);
var state_134515__$1 = (function (){var statearr_134525 = state_134515;
(statearr_134525[(11)] = inst_134495);

(statearr_134525[(12)] = inst_134496);

return statearr_134525;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134515__$1,(56),inst_134498);
} else {
if((state_val_134516 === (39))){
var inst_134400 = (state_134515[(13)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134400)){
var statearr_134526_134609 = state_134515__$1;
(statearr_134526_134609[(1)] = (41));

} else {
var statearr_134527_134610 = state_134515__$1;
(statearr_134527_134610[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (46))){
var inst_134472 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134528_134611 = state_134515__$1;
(statearr_134528_134611[(2)] = inst_134472);

(statearr_134528_134611[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_134515,(3),Error,null,(2));
var inst_134375 = (flureeQL == null);
var inst_134376 = cljs.core.not(inst_134375);
var state_134515__$1 = state_134515;
if(inst_134376){
var statearr_134529_134612 = state_134515__$1;
(statearr_134529_134612[(1)] = (5));

} else {
var statearr_134530_134613 = state_134515__$1;
(statearr_134530_134613[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (54))){
var inst_134489 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_134490 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_134491 = cljs.core.PersistentHashMap.fromArrays(inst_134489,inst_134490);
var inst_134492 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_134491);
var inst_134493 = (function(){throw inst_134492})();
var state_134515__$1 = state_134515;
var statearr_134531_134614 = state_134515__$1;
(statearr_134531_134614[(2)] = inst_134493);

(statearr_134531_134614[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (15))){
var inst_134414 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_134415 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_134414].join('');
var inst_134416 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_134417 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_134418 = cljs.core.PersistentHashMap.fromArrays(inst_134416,inst_134417);
var inst_134419 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_134415,inst_134418);
var inst_134420 = (function(){throw inst_134419})();
var state_134515__$1 = state_134515;
var statearr_134532_134615 = state_134515__$1;
(statearr_134532_134615[(2)] = inst_134420);

(statearr_134532_134615[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (48))){
var inst_134478 = (state_134515[(14)]);
var state_134515__$1 = state_134515;
var statearr_134533_134616 = state_134515__$1;
(statearr_134533_134616[(2)] = inst_134478);

(statearr_134533_134616[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (50))){
var inst_134402 = (state_134515[(15)]);
var state_134515__$1 = state_134515;
var statearr_134534_134617 = state_134515__$1;
(statearr_134534_134617[(2)] = inst_134402);

(statearr_134534_134617[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (21))){
var inst_134397 = (state_134515[(16)]);
var inst_134425 = (state_134515[(2)]);
var inst_134426 = fluree.db.util.async.throw_err(inst_134425);
var inst_134427 = fluree.db.time_travel.as_of_block(inst_134426,inst_134397);
var state_134515__$1 = state_134515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134515__$1,(20),inst_134427);
} else {
if((state_val_134516 === (31))){
var inst_134403 = (state_134515[(17)]);
var inst_134457 = (state_134515[(18)]);
var inst_134456 = (state_134515[(2)]);
var inst_134457__$1 = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(inst_134403);
var state_134515__$1 = (function (){var statearr_134535 = state_134515;
(statearr_134535[(18)] = inst_134457__$1);

(statearr_134535[(19)] = inst_134456);

return statearr_134535;
})();
if(cljs.core.truth_(inst_134457__$1)){
var statearr_134536_134618 = state_134515__$1;
(statearr_134536_134618[(1)] = (32));

} else {
var statearr_134537_134619 = state_134515__$1;
(statearr_134537_134619[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (32))){
var inst_134457 = (state_134515[(18)]);
var state_134515__$1 = state_134515;
var statearr_134538_134620 = state_134515__$1;
(statearr_134538_134620[(2)] = inst_134457);

(statearr_134538_134620[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (40))){
var inst_134476 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134539_134621 = state_134515__$1;
(statearr_134539_134621[(2)] = inst_134476);

(statearr_134539_134621[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (56))){
var inst_134446 = (state_134515[(8)]);
var inst_134500 = (state_134515[(2)]);
var inst_134501 = fluree.db.util.async.throw_err(inst_134500);
var state_134515__$1 = (function (){var statearr_134540 = state_134515;
(statearr_134540[(7)] = inst_134501);

return statearr_134540;
})();
if(cljs.core.truth_(inst_134446)){
var statearr_134541_134622 = state_134515__$1;
(statearr_134541_134622[(1)] = (57));

} else {
var statearr_134542_134623 = state_134515__$1;
(statearr_134542_134623[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (33))){
var state_134515__$1 = state_134515;
var statearr_134543_134624 = state_134515__$1;
(statearr_134543_134624[(2)] = (1000000));

(statearr_134543_134624[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (13))){
var inst_134395 = (state_134515[(20)]);
var inst_134399 = (state_134515[(21)]);
var inst_134403 = (state_134515[(17)]);
var inst_134397 = (state_134515[(16)]);
var inst_134401 = (state_134515[(22)]);
var inst_134404 = (state_134515[(23)]);
var inst_134396 = (state_134515[(24)]);
var inst_134402 = (state_134515[(15)]);
var inst_134398 = (state_134515[(25)]);
var inst_134400 = (state_134515[(13)]);
var inst_134394 = (state_134515[(2)]);
var inst_134395__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$construct);
var inst_134396__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$select);
var inst_134397__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$block);
var inst_134398__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$where);
var inst_134399__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$prefixes);
var inst_134400__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$selectDistinct);
var inst_134401__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$selectOne);
var inst_134402__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$from);
var inst_134403__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$opts);
var inst_134404__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134394,cljs.core.cst$kw$selectReduced);
var inst_134405 = (function (){var construct = inst_134395__$1;
var map__134373 = inst_134394;
var select = inst_134396__$1;
var block = inst_134397__$1;
var where = inst_134398__$1;
var prefixes = inst_134399__$1;
var selectDistinct = inst_134400__$1;
var selectOne = inst_134401__$1;
var from = inst_134402__$1;
var opts = inst_134403__$1;
var selectReduced = inst_134404__$1;
return ((function (construct,map__134373,select,block,where,prefixes,selectDistinct,selectOne,from,opts,selectReduced,inst_134395,inst_134399,inst_134403,inst_134397,inst_134401,inst_134404,inst_134396,inst_134402,inst_134398,inst_134400,inst_134394,inst_134395__$1,inst_134396__$1,inst_134397__$1,inst_134398__$1,inst_134399__$1,inst_134400__$1,inst_134401__$1,inst_134402__$1,inst_134403__$1,inst_134404__$1,state_val_134516,c__110077__auto__){
return (function (p1__134368_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__134368_SHARP_);
});
;})(construct,map__134373,select,block,where,prefixes,selectDistinct,selectOne,from,opts,selectReduced,inst_134395,inst_134399,inst_134403,inst_134397,inst_134401,inst_134404,inst_134396,inst_134402,inst_134398,inst_134400,inst_134394,inst_134395__$1,inst_134396__$1,inst_134397__$1,inst_134398__$1,inst_134399__$1,inst_134400__$1,inst_134401__$1,inst_134402__$1,inst_134403__$1,inst_134404__$1,state_val_134516,c__110077__auto__))
})();
var inst_134406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_134407 = [inst_134396__$1,inst_134401__$1,inst_134400__$1,inst_134404__$1];
var inst_134408 = (new cljs.core.PersistentVector(null,4,(5),inst_134406,inst_134407,null));
var inst_134409 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_134408);
var inst_134410 = cljs.core.count(inst_134409);
var inst_134411 = (inst_134405.cljs$core$IFn$_invoke$arity$1 ? inst_134405.cljs$core$IFn$_invoke$arity$1(inst_134410) : inst_134405.call(null,inst_134410));
var state_134515__$1 = (function (){var statearr_134544 = state_134515;
(statearr_134544[(20)] = inst_134395__$1);

(statearr_134544[(21)] = inst_134399__$1);

(statearr_134544[(17)] = inst_134403__$1);

(statearr_134544[(16)] = inst_134397__$1);

(statearr_134544[(22)] = inst_134401__$1);

(statearr_134544[(23)] = inst_134404__$1);

(statearr_134544[(24)] = inst_134396__$1);

(statearr_134544[(15)] = inst_134402__$1);

(statearr_134544[(25)] = inst_134398__$1);

(statearr_134544[(13)] = inst_134400__$1);

return statearr_134544;
})();
if(cljs.core.truth_(inst_134411)){
var statearr_134545_134625 = state_134515__$1;
(statearr_134545_134625[(1)] = (14));

} else {
var statearr_134546_134626 = state_134515__$1;
(statearr_134546_134626[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (22))){
var inst_134433 = (state_134515[(2)]);
var inst_134434 = fluree.db.util.async.throw_err(inst_134433);
var state_134515__$1 = state_134515;
var statearr_134547_134627 = state_134515__$1;
(statearr_134547_134627[(2)] = inst_134434);

(statearr_134547_134627[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (36))){
var inst_134401 = (state_134515[(22)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134401)){
var statearr_134548_134628 = state_134515__$1;
(statearr_134548_134628[(1)] = (38));

} else {
var statearr_134549_134629 = state_134515__$1;
(statearr_134549_134629[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (41))){
var inst_134400 = (state_134515[(13)]);
var state_134515__$1 = state_134515;
var statearr_134550_134630 = state_134515__$1;
(statearr_134550_134630[(2)] = inst_134400);

(statearr_134550_134630[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (43))){
var inst_134474 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134551_134631 = state_134515__$1;
(statearr_134551_134631[(2)] = inst_134474);

(statearr_134551_134631[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (29))){
var inst_134453 = cljs.core.volatile_BANG_((0));
var state_134515__$1 = state_134515;
var statearr_134552_134632 = state_134515__$1;
(statearr_134552_134632[(2)] = inst_134453);

(statearr_134552_134632[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (44))){
var inst_134404 = (state_134515[(23)]);
var state_134515__$1 = state_134515;
var statearr_134553_134633 = state_134515__$1;
(statearr_134553_134633[(2)] = inst_134404);

(statearr_134553_134633[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (6))){
var state_134515__$1 = state_134515;
var statearr_134554_134634 = state_134515__$1;
(statearr_134554_134634[(2)] = false);

(statearr_134554_134634[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (28))){
var inst_134451 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134451)){
var statearr_134555_134635 = state_134515__$1;
(statearr_134555_134635[(1)] = (29));

} else {
var statearr_134556_134636 = state_134515__$1;
(statearr_134556_134636[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (51))){
var inst_134398 = (state_134515[(25)]);
var state_134515__$1 = state_134515;
var statearr_134557_134637 = state_134515__$1;
(statearr_134557_134637[(2)] = inst_134398);

(statearr_134557_134637[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (25))){
var inst_134403 = (state_134515[(17)]);
var inst_134447 = (state_134515[(26)]);
var inst_134445 = (state_134515[(2)]);
var inst_134446 = cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(inst_134403);
var inst_134447__$1 = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(inst_134403);
var state_134515__$1 = (function (){var statearr_134558 = state_134515;
(statearr_134558[(8)] = inst_134446);

(statearr_134558[(27)] = inst_134445);

(statearr_134558[(26)] = inst_134447__$1);

return statearr_134558;
})();
if(cljs.core.truth_(inst_134447__$1)){
var statearr_134559_134638 = state_134515__$1;
(statearr_134559_134638[(1)] = (26));

} else {
var statearr_134560_134639 = state_134515__$1;
(statearr_134560_134639[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (34))){
var inst_134403 = (state_134515[(17)]);
var inst_134445 = (state_134515[(27)]);
var inst_134396 = (state_134515[(24)]);
var inst_134456 = (state_134515[(19)]);
var inst_134461 = (state_134515[(2)]);
var inst_134462 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_134403,cljs.core.cst$kw$sources,inst_134445,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,inst_134461,cljs.core.cst$kw$fuel,inst_134456], 0));
var state_134515__$1 = (function (){var statearr_134561 = state_134515;
(statearr_134561[(9)] = inst_134462);

return statearr_134561;
})();
if(cljs.core.truth_(inst_134396)){
var statearr_134562_134640 = state_134515__$1;
(statearr_134562_134640[(1)] = (35));

} else {
var statearr_134563_134641 = state_134515__$1;
(statearr_134563_134641[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (17))){
var state_134515__$1 = state_134515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134515__$1,(21),sources);
} else {
if((state_val_134516 === (3))){
var inst_134369 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134564_134642 = state_134515__$1;
(statearr_134564_134642[(2)] = inst_134369);


cljs.core.async.impl.ioc_helpers.process_exception(state_134515__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (12))){
var state_134515__$1 = state_134515;
var statearr_134565_134643 = state_134515__$1;
(statearr_134565_134643[(2)] = flureeQL);

(statearr_134565_134643[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (2))){
var inst_134513 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_134515__$1,inst_134513);
} else {
if((state_val_134516 === (23))){
var inst_134399 = (state_134515[(21)]);
var inst_134436 = (state_134515[(10)]);
var inst_134438 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(inst_134436);
var inst_134439 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(inst_134436);
var inst_134440 = cljs.core.cst$kw$auth.cljs$core$IFn$_invoke$arity$1(inst_134436);
var inst_134441 = fluree.db.api.ledger.get_sources(inst_134438,inst_134439,inst_134440,inst_134399);
var state_134515__$1 = state_134515;
var statearr_134566_134644 = state_134515__$1;
(statearr_134566_134644[(2)] = inst_134441);

(statearr_134566_134644[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (47))){
var inst_134402 = (state_134515[(15)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134402)){
var statearr_134567_134645 = state_134515__$1;
(statearr_134567_134645[(1)] = (50));

} else {
var statearr_134568_134646 = state_134515__$1;
(statearr_134568_134646[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (35))){
var inst_134396 = (state_134515[(24)]);
var state_134515__$1 = state_134515;
var statearr_134569_134647 = state_134515__$1;
(statearr_134569_134647[(2)] = inst_134396);

(statearr_134569_134647[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (19))){
var inst_134399 = (state_134515[(21)]);
var inst_134436 = (state_134515[(2)]);
var state_134515__$1 = (function (){var statearr_134570 = state_134515;
(statearr_134570[(10)] = inst_134436);

return statearr_134570;
})();
if(cljs.core.truth_(inst_134399)){
var statearr_134571_134648 = state_134515__$1;
(statearr_134571_134648[(1)] = (23));

} else {
var statearr_134572_134649 = state_134515__$1;
(statearr_134572_134649[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (57))){
var inst_134436 = (state_134515[(10)]);
var inst_134501 = (state_134515[(7)]);
var inst_134496 = (state_134515[(12)]);
var inst_134456 = (state_134515[(19)]);
var inst_134503 = [cljs.core.cst$kw$status,cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$time,cljs.core.cst$kw$block];
var inst_134504 = cljs.core.deref(inst_134456);
var inst_134505 = fluree.db.api.query.response_time_formatted(inst_134496);
var inst_134506 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_134436);
var inst_134507 = [(200),inst_134501,inst_134504,inst_134505,inst_134506];
var inst_134508 = cljs.core.PersistentHashMap.fromArrays(inst_134503,inst_134507);
var state_134515__$1 = state_134515;
var statearr_134573_134650 = state_134515__$1;
(statearr_134573_134650[(2)] = inst_134508);

(statearr_134573_134650[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (11))){
var inst_134391 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,flureeQL);
var state_134515__$1 = state_134515;
var statearr_134574_134651 = state_134515__$1;
(statearr_134574_134651[(2)] = inst_134391);

(statearr_134574_134651[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (9))){
var state_134515__$1 = state_134515;
var statearr_134575_134652 = state_134515__$1;
(statearr_134575_134652[(2)] = false);

(statearr_134575_134652[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (5))){
var inst_134378 = flureeQL.cljs$lang$protocol_mask$partition0$;
var inst_134379 = (inst_134378 & (64));
var inst_134380 = flureeQL.cljs$core$ISeq$;
var inst_134381 = (cljs.core.PROTOCOL_SENTINEL === inst_134380);
var inst_134382 = ((inst_134379) || (inst_134381));
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134382)){
var statearr_134576_134653 = state_134515__$1;
(statearr_134576_134653[(1)] = (8));

} else {
var statearr_134577_134654 = state_134515__$1;
(statearr_134577_134654[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (14))){
var state_134515__$1 = state_134515;
var statearr_134578_134655 = state_134515__$1;
(statearr_134578_134655[(2)] = null);

(statearr_134578_134655[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (45))){
var inst_134395 = (state_134515[(20)]);
var state_134515__$1 = state_134515;
var statearr_134579_134656 = state_134515__$1;
(statearr_134579_134656[(2)] = inst_134395);

(statearr_134579_134656[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (53))){
var state_134515__$1 = state_134515;
var statearr_134580_134657 = state_134515__$1;
(statearr_134580_134657[(2)] = null);

(statearr_134580_134657[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (26))){
var inst_134447 = (state_134515[(26)]);
var state_134515__$1 = state_134515;
var statearr_134581_134658 = state_134515__$1;
(statearr_134581_134658[(2)] = inst_134447);

(statearr_134581_134658[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (16))){
var inst_134397 = (state_134515[(16)]);
var inst_134422 = (state_134515[(2)]);
var state_134515__$1 = (function (){var statearr_134582 = state_134515;
(statearr_134582[(28)] = inst_134422);

return statearr_134582;
})();
if(cljs.core.truth_(inst_134397)){
var statearr_134583_134659 = state_134515__$1;
(statearr_134583_134659[(1)] = (17));

} else {
var statearr_134584_134660 = state_134515__$1;
(statearr_134584_134660[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (38))){
var inst_134401 = (state_134515[(22)]);
var state_134515__$1 = state_134515;
var statearr_134585_134661 = state_134515__$1;
(statearr_134585_134661[(2)] = inst_134401);

(statearr_134585_134661[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (30))){
var state_134515__$1 = state_134515;
var statearr_134586_134662 = state_134515__$1;
(statearr_134586_134662[(2)] = null);

(statearr_134586_134662[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (10))){
var inst_134386 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134587_134663 = state_134515__$1;
(statearr_134587_134663[(2)] = inst_134386);

(statearr_134587_134663[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (18))){
var state_134515__$1 = state_134515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134515__$1,(22),sources);
} else {
if((state_val_134516 === (52))){
var inst_134483 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
var statearr_134588_134664 = state_134515__$1;
(statearr_134588_134664[(2)] = inst_134483);

(statearr_134588_134664[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (42))){
var inst_134404 = (state_134515[(23)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134404)){
var statearr_134589_134665 = state_134515__$1;
(statearr_134589_134665[(1)] = (44));

} else {
var statearr_134590_134666 = state_134515__$1;
(statearr_134590_134666[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (37))){
var inst_134478 = (state_134515[(14)]);
var inst_134478__$1 = (state_134515[(2)]);
var state_134515__$1 = (function (){var statearr_134591 = state_134515;
(statearr_134591[(14)] = inst_134478__$1);

return statearr_134591;
})();
if(cljs.core.truth_(inst_134478__$1)){
var statearr_134592_134667 = state_134515__$1;
(statearr_134592_134667[(1)] = (47));

} else {
var statearr_134593_134668 = state_134515__$1;
(statearr_134593_134668[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (8))){
var state_134515__$1 = state_134515;
var statearr_134594_134669 = state_134515__$1;
(statearr_134594_134669[(2)] = true);

(statearr_134594_134669[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134516 === (49))){
var inst_134486 = (state_134515[(2)]);
var state_134515__$1 = state_134515;
if(cljs.core.truth_(inst_134486)){
var statearr_134595_134670 = state_134515__$1;
(statearr_134595_134670[(1)] = (53));

} else {
var statearr_134596_134671 = state_134515__$1;
(statearr_134596_134671[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$query_async_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__109971__auto____0 = (function (){
var statearr_134597 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_134597[(0)] = fluree$db$api$query$query_async_$_state_machine__109971__auto__);

(statearr_134597[(1)] = (1));

return statearr_134597;
});
var fluree$db$api$query$query_async_$_state_machine__109971__auto____1 = (function (state_134515){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_134515);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e134598){if((e134598 instanceof Object)){
var ex__109974__auto__ = e134598;
var statearr_134599_134672 = state_134515;
(statearr_134599_134672[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_134515);

return cljs.core.cst$kw$recur;
} else {
throw e134598;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134673 = state_134515;
state_134515 = G__134673;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__109971__auto__ = function(state_134515){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__109971__auto____1.call(this,state_134515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__109971__auto____0;
fluree$db$api$query$query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__109971__auto____1;
return fluree$db$api$query$query_async_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_134600 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_134600[(6)] = c__110077__auto__);

return statearr_134600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_134824){
var state_val_134825 = (state_134824[(1)]);
if((state_val_134825 === (7))){
var inst_134682 = (state_134824[(7)]);
var state_134824__$1 = state_134824;
if(cljs.core.truth_(inst_134682)){
var statearr_134826_134899 = state_134824__$1;
(statearr_134826_134899[(1)] = (10));

} else {
var statearr_134827_134900 = state_134824__$1;
(statearr_134827_134900[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (20))){
var inst_134741 = (state_134824[(8)]);
var state_134824__$1 = state_134824;
var statearr_134828_134901 = state_134824__$1;
(statearr_134828_134901[(2)] = inst_134741);

(statearr_134828_134901[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (27))){
var inst_134769 = (state_134824[(9)]);
var inst_134711 = (state_134824[(10)]);
var inst_134773 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_134711,inst_134769);
var state_134824__$1 = state_134824;
if(inst_134773){
var statearr_134829_134902 = state_134824__$1;
(statearr_134829_134902[(1)] = (29));

} else {
var statearr_134830_134903 = state_134824__$1;
(statearr_134830_134903[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (1))){
var state_134824__$1 = state_134824;
var statearr_134831_134904 = state_134824__$1;
(statearr_134831_134904[(2)] = null);

(statearr_134831_134904[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (24))){
var state_134824__$1 = state_134824;
var statearr_134832_134905 = state_134824__$1;
(statearr_134832_134905[(2)] = null);

(statearr_134832_134905[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (39))){
var state_134824__$1 = state_134824;
var statearr_134833_134906 = state_134824__$1;
(statearr_134833_134906[(2)] = null);

(statearr_134833_134906[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (46))){
var inst_134724 = (state_134824[(11)]);
var inst_134713 = (state_134824[(12)]);
var inst_134812 = (state_134824[(2)]);
var inst_134813 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_134713,inst_134724,inst_134812);
var state_134824__$1 = state_134824;
var statearr_134834_134907 = state_134824__$1;
(statearr_134834_134907[(2)] = inst_134813);

(statearr_134834_134907[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (4))){
var inst_134687 = (state_134824[(13)]);
var inst_134682 = (state_134824[(7)]);
var inst_134686 = (state_134824[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_134824,(3),java.lang.Exception,null,(2));
var inst_134678 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_134679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_134680 = [cljs.core.cst$kw$opts,cljs.core.cst$kw$meta];
var inst_134681 = (new cljs.core.PersistentVector(null,2,(5),inst_134679,inst_134680,null));
var inst_134682__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_134681);
var inst_134683 = (function (){var global_block = inst_134678;
var global_meta_QMARK_ = inst_134682__$1;
return ((function (global_block,global_meta_QMARK_,inst_134687,inst_134682,inst_134686,_,inst_134678,inst_134679,inst_134680,inst_134681,inst_134682__$1,state_val_134825,c__110077__auto__){
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$meta], null));
var meta_QMARK_ = (function (){var or__4131__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4120__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4120__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query),cljs.core.cst$kw$meta,meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$_remove_DASH_meta_QMARK_,remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,cljs.core.cst$kw$opts,opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,(function (){var or__4131__auto__ = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
;})(global_block,global_meta_QMARK_,inst_134687,inst_134682,inst_134686,_,inst_134678,inst_134679,inst_134680,inst_134681,inst_134682__$1,state_val_134825,c__110077__auto__))
})();
var inst_134684 = cljs.core.PersistentHashMap.EMPTY;
var inst_134685 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,cljs.core.cst$kw$opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block], 0));
var inst_134686__$1 = cljs.core.reduce_kv(inst_134683,inst_134684,inst_134685);
var inst_134687__$1 = fluree.db.util.core.current_time_millis();
var inst_134689 = (function (){var global_block = inst_134678;
var global_meta_QMARK_ = inst_134682__$1;
var queries = inst_134686__$1;
var start_time = inst_134687__$1;
return ((function (global_block,global_meta_QMARK_,queries,start_time,inst_134687,inst_134682,inst_134686,_,inst_134678,inst_134679,inst_134680,inst_134681,inst_134682__$1,inst_134683,inst_134684,inst_134685,inst_134686__$1,inst_134687__$1,state_val_134825,c__110077__auto__){
return (function (p__134688){
var vec__134835 = p__134688;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__134835,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__134835,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
;})(global_block,global_meta_QMARK_,queries,start_time,inst_134687,inst_134682,inst_134686,_,inst_134678,inst_134679,inst_134680,inst_134681,inst_134682__$1,inst_134683,inst_134684,inst_134685,inst_134686__$1,inst_134687__$1,state_val_134825,c__110077__auto__))
})();
var inst_134690 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_134689,inst_134686__$1);
var inst_134704 = cljs.core.seq(inst_134690);
var inst_134705 = cljs.core.first(inst_134704);
var inst_134706 = cljs.core.next(inst_134704);
var inst_134707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134705,(0),null);
var inst_134708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134705,(1),null);
var inst_134709 = cljs.core.PersistentHashMap.EMPTY;
var inst_134710 = inst_134690;
var inst_134711 = null;
var inst_134712 = (0);
var inst_134713 = inst_134709;
var state_134824__$1 = (function (){var statearr_134838 = state_134824;
(statearr_134838[(15)] = inst_134707);

(statearr_134838[(16)] = inst_134706);

(statearr_134838[(13)] = inst_134687__$1);

(statearr_134838[(7)] = inst_134682__$1);

(statearr_134838[(17)] = inst_134710);

(statearr_134838[(14)] = inst_134686__$1);

(statearr_134838[(18)] = inst_134708);

(statearr_134838[(10)] = inst_134711);

(statearr_134838[(12)] = inst_134713);

(statearr_134838[(19)] = inst_134712);

return statearr_134838;
})();
var statearr_134839_134908 = state_134824__$1;
(statearr_134839_134908[(2)] = null);

(statearr_134839_134908[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (15))){
var inst_134757 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
if(cljs.core.truth_(inst_134757)){
var statearr_134840_134909 = state_134824__$1;
(statearr_134840_134909[(1)] = (19));

} else {
var statearr_134841_134910 = state_134824__$1;
(statearr_134841_134910[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (21))){
var inst_134725 = (state_134824[(20)]);
var inst_134762 = (state_134824[(2)]);
var inst_134763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134762,cljs.core.cst$kw$meta);
var inst_134764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_134762,cljs.core.cst$kw$_remove_DASH_meta_QMARK_);
var state_134824__$1 = (function (){var statearr_134842 = state_134824;
(statearr_134842[(21)] = inst_134763);

(statearr_134842[(22)] = inst_134764);

return statearr_134842;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_134824__$1,(22),inst_134725);
} else {
if((state_val_134825 === (31))){
var inst_134790 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134843_134911 = state_134824__$1;
(statearr_134843_134911[(2)] = inst_134790);

(statearr_134843_134911[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (32))){
var state_134824__$1 = state_134824;
var statearr_134844_134912 = state_134824__$1;
(statearr_134844_134912[(2)] = (207));

(statearr_134844_134912[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (40))){
var inst_134767 = (state_134824[(23)]);
var inst_134801 = (state_134824[(2)]);
var state_134824__$1 = (function (){var statearr_134845 = state_134824;
(statearr_134845[(24)] = inst_134801);

return statearr_134845;
})();
if(cljs.core.truth_(inst_134767)){
var statearr_134846_134913 = state_134824__$1;
(statearr_134846_134913[(1)] = (41));

} else {
var statearr_134847_134914 = state_134824__$1;
(statearr_134847_134914[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (33))){
var state_134824__$1 = state_134824;
var statearr_134848_134915 = state_134824__$1;
(statearr_134848_134915[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (13))){
var inst_134741 = (state_134824[(8)]);
var inst_134746 = inst_134741.cljs$lang$protocol_mask$partition0$;
var inst_134747 = (inst_134746 & (64));
var inst_134748 = inst_134741.cljs$core$ISeq$;
var inst_134749 = (cljs.core.PROTOCOL_SENTINEL === inst_134748);
var inst_134750 = ((inst_134747) || (inst_134749));
var state_134824__$1 = state_134824;
if(cljs.core.truth_(inst_134750)){
var statearr_134850_134916 = state_134824__$1;
(statearr_134850_134916[(1)] = (16));

} else {
var statearr_134851_134917 = state_134824__$1;
(statearr_134851_134917[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (22))){
var inst_134763 = (state_134824[(21)]);
var inst_134766 = (state_134824[(25)]);
var inst_134766__$1 = (state_134824[(2)]);
var inst_134767 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_134766__$1);
var state_134824__$1 = (function (){var statearr_134852 = state_134824;
(statearr_134852[(25)] = inst_134766__$1);

(statearr_134852[(23)] = inst_134767);

return statearr_134852;
})();
if(cljs.core.truth_(inst_134763)){
var statearr_134853_134918 = state_134824__$1;
(statearr_134853_134918[(1)] = (23));

} else {
var statearr_134854_134919 = state_134824__$1;
(statearr_134854_134919[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (36))){
var state_134824__$1 = state_134824;
var statearr_134855_134920 = state_134824__$1;
(statearr_134855_134920[(2)] = null);

(statearr_134855_134920[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (41))){
var inst_134724 = (state_134824[(11)]);
var inst_134766 = (state_134824[(25)]);
var inst_134713 = (state_134824[(12)]);
var inst_134803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_134804 = [cljs.core.cst$kw$errors,inst_134724];
var inst_134805 = (new cljs.core.PersistentVector(null,2,(5),inst_134803,inst_134804,null));
var inst_134806 = cljs.core.assoc_in(inst_134713,inst_134805,inst_134766);
var state_134824__$1 = state_134824;
var statearr_134856_134921 = state_134824__$1;
(statearr_134856_134921[(2)] = inst_134806);

(statearr_134856_134921[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (43))){
var inst_134795 = (state_134824[(26)]);
var inst_134723 = (state_134824[(27)]);
var inst_134801 = (state_134824[(24)]);
var inst_134815 = (state_134824[(2)]);
var inst_134710 = inst_134723;
var inst_134711 = inst_134795;
var inst_134712 = inst_134801;
var inst_134713 = inst_134815;
var state_134824__$1 = (function (){var statearr_134857 = state_134824;
(statearr_134857[(17)] = inst_134710);

(statearr_134857[(10)] = inst_134711);

(statearr_134857[(12)] = inst_134713);

(statearr_134857[(19)] = inst_134712);

return statearr_134857;
})();
var statearr_134858_134922 = state_134824__$1;
(statearr_134858_134922[(2)] = null);

(statearr_134858_134922[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (29))){
var inst_134769 = (state_134824[(9)]);
var state_134824__$1 = state_134824;
var statearr_134859_134923 = state_134824__$1;
(statearr_134859_134923[(2)] = inst_134769);

(statearr_134859_134923[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (44))){
var inst_134766 = (state_134824[(25)]);
var inst_134809 = cljs.core.cst$kw$result.cljs$core$IFn$_invoke$arity$1(inst_134766);
var state_134824__$1 = state_134824;
var statearr_134860_134924 = state_134824__$1;
(statearr_134860_134924[(2)] = inst_134809);

(statearr_134860_134924[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (6))){
var inst_134820 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134861_134925 = state_134824__$1;
(statearr_134861_134925[(2)] = inst_134820);


cljs.core.async.impl.ioc_helpers.process_exception(state_134824__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (28))){
var inst_134792 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134862_134926 = state_134824__$1;
(statearr_134862_134926[(2)] = inst_134792);

(statearr_134862_134926[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (25))){
var inst_134763 = (state_134824[(21)]);
var inst_134795 = (state_134824[(2)]);
var state_134824__$1 = (function (){var statearr_134863 = state_134824;
(statearr_134863[(26)] = inst_134795);

return statearr_134863;
})();
if(cljs.core.truth_(inst_134763)){
var statearr_134864_134927 = state_134824__$1;
(statearr_134864_134927[(1)] = (38));

} else {
var statearr_134865_134928 = state_134824__$1;
(statearr_134865_134928[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (34))){
var inst_134788 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134866_134929 = state_134824__$1;
(statearr_134866_134929[(2)] = inst_134788);

(statearr_134866_134929[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (17))){
var state_134824__$1 = state_134824;
var statearr_134867_134930 = state_134824__$1;
(statearr_134867_134930[(2)] = false);

(statearr_134867_134930[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (3))){
var inst_134674 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134868_134931 = state_134824__$1;
(statearr_134868_134931[(2)] = inst_134674);


cljs.core.async.impl.ioc_helpers.process_exception(state_134824__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (12))){
var inst_134735 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134869_134932 = state_134824__$1;
(statearr_134869_134932[(2)] = inst_134735);

(statearr_134869_134932[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (2))){
var inst_134822 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_134824__$1,inst_134822);
} else {
if((state_val_134825 === (23))){
var inst_134766 = (state_134824[(25)]);
var inst_134711 = (state_134824[(10)]);
var inst_134769 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_134766);
var inst_134770 = (inst_134711 == null);
var state_134824__$1 = (function (){var statearr_134870 = state_134824;
(statearr_134870[(9)] = inst_134769);

return statearr_134870;
})();
if(cljs.core.truth_(inst_134770)){
var statearr_134871_134933 = state_134824__$1;
(statearr_134871_134933[(1)] = (26));

} else {
var statearr_134872_134934 = state_134824__$1;
(statearr_134872_134934[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (35))){
var inst_134769 = (state_134824[(9)]);
var inst_134711 = (state_134824[(10)]);
var inst_134783 = ((inst_134769 > inst_134711) ? inst_134769 : inst_134711);
var state_134824__$1 = state_134824;
var statearr_134873_134935 = state_134824__$1;
(statearr_134873_134935[(2)] = inst_134783);

(statearr_134873_134935[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (19))){
var inst_134741 = (state_134824[(8)]);
var inst_134759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_134741);
var state_134824__$1 = state_134824;
var statearr_134874_134936 = state_134824__$1;
(statearr_134874_134936[(2)] = inst_134759);

(statearr_134874_134936[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (11))){
var inst_134713 = (state_134824[(12)]);
var state_134824__$1 = state_134824;
var statearr_134875_134937 = state_134824__$1;
(statearr_134875_134937[(2)] = inst_134713);

(statearr_134875_134937[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (9))){
var inst_134818 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134876_134938 = state_134824__$1;
(statearr_134876_134938[(2)] = inst_134818);

(statearr_134876_134938[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (5))){
var inst_134725 = (state_134824[(20)]);
var inst_134710 = (state_134824[(17)]);
var inst_134721 = cljs.core.seq(inst_134710);
var inst_134722 = cljs.core.first(inst_134721);
var inst_134723 = cljs.core.next(inst_134721);
var inst_134724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134722,(0),null);
var inst_134725__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_134722,(1),null);
var inst_134726 = (inst_134725__$1 == null);
var state_134824__$1 = (function (){var statearr_134877 = state_134824;
(statearr_134877[(11)] = inst_134724);

(statearr_134877[(20)] = inst_134725__$1);

(statearr_134877[(27)] = inst_134723);

return statearr_134877;
})();
if(cljs.core.truth_(inst_134726)){
var statearr_134878_134939 = state_134824__$1;
(statearr_134878_134939[(1)] = (7));

} else {
var statearr_134879_134940 = state_134824__$1;
(statearr_134879_134940[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (14))){
var state_134824__$1 = state_134824;
var statearr_134880_134941 = state_134824__$1;
(statearr_134880_134941[(2)] = false);

(statearr_134880_134941[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (45))){
var inst_134766 = (state_134824[(25)]);
var state_134824__$1 = state_134824;
var statearr_134881_134942 = state_134824__$1;
(statearr_134881_134942[(2)] = inst_134766);

(statearr_134881_134942[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (26))){
var inst_134769 = (state_134824[(9)]);
var state_134824__$1 = state_134824;
var statearr_134882_134943 = state_134824__$1;
(statearr_134882_134943[(2)] = inst_134769);

(statearr_134882_134943[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (16))){
var state_134824__$1 = state_134824;
var statearr_134883_134944 = state_134824__$1;
(statearr_134883_134944[(2)] = true);

(statearr_134883_134944[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (38))){
var inst_134766 = (state_134824[(25)]);
var inst_134712 = (state_134824[(19)]);
var inst_134797 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_134766,cljs.core.cst$kw$fuel,(0));
var inst_134798 = (inst_134712 + inst_134797);
var state_134824__$1 = state_134824;
var statearr_134884_134945 = state_134824__$1;
(statearr_134884_134945[(2)] = inst_134798);

(statearr_134884_134945[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (30))){
var inst_134769 = (state_134824[(9)]);
var inst_134711 = (state_134824[(10)]);
var inst_134776 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_134769);
var inst_134777 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_134711);
var inst_134778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_134711);
var inst_134779 = ((inst_134776) || (inst_134777) || (inst_134778));
var state_134824__$1 = state_134824;
if(cljs.core.truth_(inst_134779)){
var statearr_134885_134946 = state_134824__$1;
(statearr_134885_134946[(1)] = (32));

} else {
var statearr_134886_134947 = state_134824__$1;
(statearr_134886_134947[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (10))){
var inst_134687 = (state_134824[(13)]);
var inst_134711 = (state_134824[(10)]);
var inst_134713 = (state_134824[(12)]);
var inst_134712 = (state_134824[(19)]);
var inst_134729 = [cljs.core.cst$kw$result,cljs.core.cst$kw$fuel,cljs.core.cst$kw$status,cljs.core.cst$kw$time];
var inst_134730 = fluree.db.api.query.response_time_formatted(inst_134687);
var inst_134731 = [inst_134713,inst_134712,inst_134711,inst_134730];
var inst_134732 = cljs.core.PersistentHashMap.fromArrays(inst_134729,inst_134731);
var state_134824__$1 = state_134824;
var statearr_134887_134948 = state_134824__$1;
(statearr_134887_134948[(2)] = inst_134732);

(statearr_134887_134948[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (18))){
var inst_134754 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134888_134949 = state_134824__$1;
(statearr_134888_134949[(2)] = inst_134754);

(statearr_134888_134949[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (42))){
var inst_134764 = (state_134824[(22)]);
var state_134824__$1 = state_134824;
if(cljs.core.truth_(inst_134764)){
var statearr_134889_134950 = state_134824__$1;
(statearr_134889_134950[(1)] = (44));

} else {
var statearr_134890_134951 = state_134824__$1;
(statearr_134890_134951[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (37))){
var inst_134786 = (state_134824[(2)]);
var state_134824__$1 = state_134824;
var statearr_134891_134952 = state_134824__$1;
(statearr_134891_134952[(2)] = inst_134786);

(statearr_134891_134952[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_134825 === (8))){
var inst_134724 = (state_134824[(11)]);
var inst_134686 = (state_134824[(14)]);
var inst_134741 = (state_134824[(8)]);
var inst_134738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_134739 = [inst_134724,cljs.core.cst$kw$opts];
var inst_134740 = (new cljs.core.PersistentVector(null,2,(5),inst_134738,inst_134739,null));
var inst_134741__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_134686,inst_134740);
var inst_134743 = (inst_134741__$1 == null);
var inst_134744 = cljs.core.not(inst_134743);
var state_134824__$1 = (function (){var statearr_134892 = state_134824;
(statearr_134892[(8)] = inst_134741__$1);

return statearr_134892;
})();
if(inst_134744){
var statearr_134893_134953 = state_134824__$1;
(statearr_134893_134953[(1)] = (13));

} else {
var statearr_134894_134954 = state_134824__$1;
(statearr_134894_134954[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____0 = (function (){
var statearr_134895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_134895[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__);

(statearr_134895[(1)] = (1));

return statearr_134895;
});
var fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____1 = (function (state_134824){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_134824);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e134896){if((e134896 instanceof Object)){
var ex__109974__auto__ = e134896;
var statearr_134897_134955 = state_134824;
(statearr_134897_134955[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_134824);

return cljs.core.cst$kw$recur;
} else {
throw e134896;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__134956 = state_134824;
state_134824 = G__134956;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__ = function(state_134824){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____1.call(this,state_134824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__109971__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_134898 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_134898[(6)] = c__110077__auto__);

return statearr_134898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__134957 = query_type;
var G__134957__$1 = (((G__134957 instanceof cljs.core.Keyword))?G__134957.fqn:null);
switch (G__134957__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(source),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__134957__$1)].join('')));

}
});
