// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbproto');
goog.require('cljs.core');
goog.require('cljs.core.constants');

/**
 * All nodes must implement this protocol. It's includes the minimal functionality
 * necessary to avoid resolving nodes unless strictly necessary.
 * @interface
 */
fluree.db.dbproto.IResolve = function(){};

/**
 * Returns the first flake in this node
 */
fluree.db.dbproto._first_flake = (function fluree$db$dbproto$_first_flake(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_first_flake$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_first_flake$arity$1(node);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._first_flake[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4434__auto__.call(null,node));
} else {
var m__4431__auto__ = (fluree.db.dbproto._first_flake["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4431__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-first-flake",node);
}
}
}
});

/**
 * Returns the next node's first flake
 */
fluree.db.dbproto._rhs = (function fluree$db$dbproto$_rhs(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_rhs$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_rhs$arity$1(node);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._rhs[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4434__auto__.call(null,node));
} else {
var m__4431__auto__ = (fluree.db.dbproto._rhs["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4431__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-rhs",node);
}
}
}
});

/**
 * Returns how many history nodes are present for this node (if a leaf)
 */
fluree.db.dbproto._history_count = (function fluree$db$dbproto$_history_count(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_history_count$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_history_count$arity$1(node);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._history_count[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4434__auto__.call(null,node));
} else {
var m__4431__auto__ = (fluree.db.dbproto._history_count["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4431__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-history-count",node);
}
}
}
});

/**
 * Returns node resolved with data as async channel
 */
fluree.db.dbproto._resolve = (function fluree$db$dbproto$_resolve(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve$arity$1(node);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4434__auto__.call(null,node));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4431__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve",node);
}
}
}
});

/**
 * Resolves this node at specified transaction 't'. Novelty included for the specified index.
 */
fluree.db.dbproto._resolve_to_t = (function fluree$db$dbproto$_resolve_to_t(var_args){
var G__112642 = arguments.length;
switch (G__112642) {
case 3:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3 = (function (node,t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3(node,t,idx_novelty);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(node,t,idx_novelty) : m__4434__auto__.call(null,node,t,idx_novelty));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(node,t,idx_novelty) : m__4431__auto__.call(null,node,t,idx_novelty));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
}
});

fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_) : m__4434__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_) : m__4431__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
}
});

fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes) : m__4434__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes) : m__4431__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
}
});

fluree.db.dbproto._resolve_to_t.cljs$lang$maxFixedArity = 5;


/**
 * Returns the history for data nodes.
 */
fluree.db.dbproto._resolve_history = (function fluree$db$dbproto$_resolve_history(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history$arity$1(node);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_history[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4434__auto__.call(null,node));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_history["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4431__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history",node);
}
}
}
});

/**
 * Returns the history within specified range of 't' values. From is most recent time.
 */
fluree.db.dbproto._resolve_history_range = (function fluree$db$dbproto$_resolve_history_range(var_args){
var G__112644 = arguments.length;
switch (G__112644) {
case 3:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3 = (function (node,from_t,to_t){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3(node,from_t,to_t);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(node,from_t,to_t) : m__4434__auto__.call(null,node,from_t,to_t));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(node,from_t,to_t) : m__4431__auto__.call(null,node,from_t,to_t));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history-range",node);
}
}
}
});

fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4 = (function (node,from_t,to_t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4(node,from_t,to_t,idx_novelty);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(node,from_t,to_t,idx_novelty) : m__4434__auto__.call(null,node,from_t,to_t,idx_novelty));
} else {
var m__4431__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(node,from_t,to_t,idx_novelty) : m__4431__auto__.call(null,node,from_t,to_t,idx_novelty));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history-range",node);
}
}
}
});

fluree.db.dbproto._resolve_history_range.cljs$lang$maxFixedArity = 4;



/**
 * @interface
 */
fluree.db.dbproto.INode = function(){};

/**
 * Returns the child node which contains the given key
 */
fluree.db.dbproto._lookup = (function fluree$db$dbproto$_lookup(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup$arity$2(node,flake);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._lookup[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4434__auto__.call(null,node,flake));
} else {
var m__4431__auto__ = (fluree.db.dbproto._lookup["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4431__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup",node);
}
}
}
});

/**
 * Returns the child node which comes after the given key
 */
fluree.db.dbproto._lookup_after = (function fluree$db$dbproto$_lookup_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_after$arity$2(node,flake);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._lookup_after[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4434__auto__.call(null,node,flake));
} else {
var m__4431__auto__ = (fluree.db.dbproto._lookup_after["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4431__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-after",node);
}
}
}
});

/**
 * Returns the leaf node which contains the given key
 */
fluree.db.dbproto._lookup_leaf = (function fluree$db$dbproto$_lookup_leaf(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf$arity$2(node,flake);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._lookup_leaf[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4434__auto__.call(null,node,flake));
} else {
var m__4431__auto__ = (fluree.db.dbproto._lookup_leaf["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4431__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-leaf",node);
}
}
}
});

/**
 * Returns the leaf node which comes after the given key
 */
fluree.db.dbproto._lookup_leaf_after = (function fluree$db$dbproto$_lookup_leaf_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2(node,flake);
} else {
var x__4433__auto__ = (((node == null))?null:node);
var m__4434__auto__ = (fluree.db.dbproto._lookup_leaf_after[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4434__auto__.call(null,node,flake));
} else {
var m__4431__auto__ = (fluree.db.dbproto._lookup_leaf_after["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4431__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-leaf-after",node);
}
}
}
});


/**
 * @interface
 */
fluree.db.dbproto.IFlureeDb = function(){};

/**
 * Updates a db to the most current version of the db known to this server. Maintains existing permissions
 */
fluree.db.dbproto._latest_db = (function fluree$db$dbproto$_latest_db(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1(db);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._latest_db[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4434__auto__.call(null,db));
} else {
var m__4431__auto__ = (fluree.db.dbproto._latest_db["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4431__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-latest-db",db);
}
}
}
});

/**
 * Returns root db version of this db.
 */
fluree.db.dbproto._rootdb = (function fluree$db$dbproto$_rootdb(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(db);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._rootdb[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4434__auto__.call(null,db));
} else {
var m__4431__auto__ = (fluree.db.dbproto._rootdb["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4431__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-rootdb",db);
}
}
}
});

fluree.db.dbproto._forward_time_travel = (function fluree$db$dbproto$_forward_time_travel(var_args){
var G__112648 = arguments.length;
switch (G__112648) {
case 2:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2(db,flakes);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4434__auto__.call(null,db,flakes));
} else {
var m__4431__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4431__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
}
});

fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3 = (function (db,tt_id,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3(db,tt_id,flakes);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4434__auto__.call(null,db,tt_id,flakes));
} else {
var m__4431__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4431__auto__.call(null,db,tt_id,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
}
});

fluree.db.dbproto._forward_time_travel.cljs$lang$maxFixedArity = 3;


/**
 * Returns schema property for a collection.
 */
fluree.db.dbproto._c_prop = (function fluree$db$dbproto$_c_prop(db,property,collection){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(db,property,collection);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._c_prop[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4434__auto__.call(null,db,property,collection));
} else {
var m__4431__auto__ = (fluree.db.dbproto._c_prop["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4431__auto__.call(null,db,property,collection));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-c-prop",db);
}
}
}
});

/**
 * Returns the property specified for the given predicate.
 */
fluree.db.dbproto._p_prop = (function fluree$db$dbproto$_p_prop(db,property,predicate){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(db,property,predicate);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._p_prop[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4434__auto__.call(null,db,property,predicate));
} else {
var m__4431__auto__ = (fluree.db.dbproto._p_prop["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4431__auto__.call(null,db,property,predicate));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-p-prop",db);
}
}
}
});

/**
 * Returns resolved tag, shortens namespace if pred provided.
 */
fluree.db.dbproto._tag = (function fluree$db$dbproto$_tag(var_args){
var G__112650 = arguments.length;
switch (G__112650) {
case 2:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$2(db,tag_id);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4434__auto__.call(null,db,tag_id));
} else {
var m__4431__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4431__auto__.call(null,db,tag_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
}
});

fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_id,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$3(db,tag_id,pred);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4434__auto__.call(null,db,tag_id,pred));
} else {
var m__4431__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4431__auto__.call(null,db,tag_id,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
}
});

fluree.db.dbproto._tag.cljs$lang$maxFixedArity = 3;


/**
 * Returns the tag sid. If pred provided will namespace tag if not already.
 */
fluree.db.dbproto._tag_id = (function fluree$db$dbproto$_tag_id(var_args){
var G__112652 = arguments.length;
switch (G__112652) {
case 2:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_name){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(db,tag_name);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4434__auto__.call(null,db,tag_name));
} else {
var m__4431__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4431__auto__.call(null,db,tag_name));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
}
});

fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_name,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3(db,tag_name,pred);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4434__auto__.call(null,db,tag_name,pred));
} else {
var m__4431__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4431__auto__.call(null,db,tag_name,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
}
});

fluree.db.dbproto._tag_id.cljs$lang$maxFixedArity = 3;


/**
 * Returns subject ID if exists, else nil
 */
fluree.db.dbproto._subid = (function fluree$db$dbproto$_subid(var_args){
var G__112654 = arguments.length;
switch (G__112654) {
case 2:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2 = (function (db,ident){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$2(db,ident);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4434__auto__.call(null,db,ident));
} else {
var m__4431__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4431__auto__.call(null,db,ident));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
}
});

fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3 = (function (db,ident,strict_QMARK_){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$3(db,ident,strict_QMARK_);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4434__auto__.call(null,db,ident,strict_QMARK_));
} else {
var m__4431__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4431__auto__.call(null,db,ident,strict_QMARK_));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
}
});

fluree.db.dbproto._subid.cljs$lang$maxFixedArity = 3;


/**
 * Performs a slice, but determines best index to use.
 */
fluree.db.dbproto._search = (function fluree$db$dbproto$_search(db,fparts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_search$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_search$arity$2(db,fparts);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._search[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4434__auto__.call(null,db,fparts));
} else {
var m__4431__auto__ = (fluree.db.dbproto._search["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4431__auto__.call(null,db,fparts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-search",db);
}
}
}
});

/**
 * Performs a query.
 */
fluree.db.dbproto._query = (function fluree$db$dbproto$_query(var_args){
var G__112656 = arguments.length;
switch (G__112656) {
case 2:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2 = (function (db,query){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$2(db,query);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4434__auto__.call(null,db,query));
} else {
var m__4431__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4431__auto__.call(null,db,query));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
}
});

fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3 = (function (db,query,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$3(db,query,opts);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4434__auto__.call(null,db,query,opts));
} else {
var m__4431__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4431__auto__.call(null,db,query,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
}
});

fluree.db.dbproto._query.cljs$lang$maxFixedArity = 3;


/**
 * Applies flakes to this db as a new block with possibly multiple 't' transactions.
 */
fluree.db.dbproto._with = (function fluree$db$dbproto$_with(db,block,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$3(db,block,flakes);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4434__auto__.call(null,db,block,flakes));
} else {
var m__4431__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4431__auto__.call(null,db,block,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with",db);
}
}
}
});

/**
 * Applies flakes to this db as a new 't', but retains current block.
 */
fluree.db.dbproto._with_t = (function fluree$db$dbproto$_with_t(db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2(db,flakes);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4434__auto__.call(null,db,flakes));
} else {
var m__4431__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4431__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with-t",db);
}
}
}
});

/**
 * Adds predicate to idx, return updated db.
 */
fluree.db.dbproto._add_predicate_to_idx = (function fluree$db$dbproto$_add_predicate_to_idx(db,pred_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2(db,pred_id);
} else {
var x__4433__auto__ = (((db == null))?null:db);
var m__4434__auto__ = (fluree.db.dbproto._add_predicate_to_idx[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4434__auto__.call(null,db,pred_id));
} else {
var m__4431__auto__ = (fluree.db.dbproto._add_predicate_to_idx["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4431__auto__.call(null,db,pred_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-add-predicate-to-idx",db);
}
}
}
});

fluree.db.dbproto.db_QMARK_ = (function fluree$db$dbproto$db_QMARK_(db){
if((!((db == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === db.fluree$db$dbproto$IFlureeDb$)))){
return true;
} else {
if((!db.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
}
});
