// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115749){
var state_val_115750 = (state_115749[(1)]);
if((state_val_115750 === (1))){
var state_115749__$1 = state_115749;
var statearr_115751_115763 = state_115749__$1;
(statearr_115751_115763[(2)] = null);

(statearr_115751_115763[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115750 === (2))){
var inst_115747 = (state_115749[(2)]);
var state_115749__$1 = state_115749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115749__$1,inst_115747);
} else {
if((state_val_115750 === (3))){
var inst_115731 = (state_115749[(2)]);
var state_115749__$1 = state_115749;
var statearr_115752_115764 = state_115749__$1;
(statearr_115752_115764[(2)] = inst_115731);


cljs.core.async.impl.ioc_helpers.process_exception(state_115749__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115750 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115749,(3),Error,null,(2));
var inst_115735 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_115736 = fluree.db.storage.core.storage_read(conn,inst_115735);
var state_115749__$1 = state_115749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115749__$1,(5),inst_115736);
} else {
if((state_val_115750 === (5))){
var inst_115739 = (state_115749[(7)]);
var inst_115738 = (state_115749[(2)]);
var inst_115739__$1 = fluree.db.util.async.throw_err(inst_115738);
var state_115749__$1 = (function (){var statearr_115753 = state_115749;
(statearr_115753[(7)] = inst_115739__$1);

return statearr_115753;
})();
if(cljs.core.truth_(inst_115739__$1)){
var statearr_115754_115765 = state_115749__$1;
(statearr_115754_115765[(1)] = (6));

} else {
var statearr_115755_115766 = state_115749__$1;
(statearr_115755_115766[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115750 === (6))){
var inst_115739 = (state_115749[(7)]);
var inst_115741 = fluree.db.storage.core.serde(conn);
var inst_115742 = fluree.db.serde.protocol._deserialize_block(inst_115741,inst_115739);
var state_115749__$1 = state_115749;
var statearr_115756_115767 = state_115749__$1;
(statearr_115756_115767[(2)] = inst_115742);

(statearr_115756_115767[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115750 === (7))){
var state_115749__$1 = state_115749;
var statearr_115757_115768 = state_115749__$1;
(statearr_115757_115768[(2)] = null);

(statearr_115757_115768[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115750 === (8))){
var inst_115745 = (state_115749[(2)]);
var state_115749__$1 = state_115749;
var statearr_115758_115769 = state_115749__$1;
(statearr_115758_115769[(2)] = inst_115745);


cljs.core.async.impl.ioc_helpers.process_exception(state_115749__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__109971__auto____0 = (function (){
var statearr_115759 = [null,null,null,null,null,null,null,null];
(statearr_115759[(0)] = fluree$db$storage$core$read_block_$_state_machine__109971__auto__);

(statearr_115759[(1)] = (1));

return statearr_115759;
});
var fluree$db$storage$core$read_block_$_state_machine__109971__auto____1 = (function (state_115749){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115749);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115760){if((e115760 instanceof Object)){
var ex__109974__auto__ = e115760;
var statearr_115761_115770 = state_115749;
(statearr_115761_115770[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115749);

return cljs.core.cst$kw$recur;
} else {
throw e115760;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115771 = state_115749;
state_115749 = G__115771;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__109971__auto__ = function(state_115749){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__109971__auto____1.call(this,state_115749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115762 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115762[(6)] = c__110077__auto__);

return statearr_115762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115791){
var state_val_115792 = (state_115791[(1)]);
if((state_val_115792 === (1))){
var state_115791__$1 = state_115791;
var statearr_115793_115805 = state_115791__$1;
(statearr_115793_115805[(2)] = null);

(statearr_115793_115805[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115792 === (2))){
var inst_115789 = (state_115791[(2)]);
var state_115791__$1 = state_115791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115791__$1,inst_115789);
} else {
if((state_val_115792 === (3))){
var inst_115772 = (state_115791[(2)]);
var state_115791__$1 = state_115791;
var statearr_115794_115806 = state_115791__$1;
(statearr_115794_115806[(2)] = inst_115772);


cljs.core.async.impl.ioc_helpers.process_exception(state_115791__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115792 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115791,(3),Error,null,(2));
var inst_115776 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_115777 = [inst_115776,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_115778 = fluree.db.storage.core.storage_read(conn,inst_115777);
var state_115791__$1 = state_115791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115791__$1,(5),inst_115778);
} else {
if((state_val_115792 === (5))){
var inst_115781 = (state_115791[(7)]);
var inst_115780 = (state_115791[(2)]);
var inst_115781__$1 = fluree.db.util.async.throw_err(inst_115780);
var state_115791__$1 = (function (){var statearr_115795 = state_115791;
(statearr_115795[(7)] = inst_115781__$1);

return statearr_115795;
})();
if(cljs.core.truth_(inst_115781__$1)){
var statearr_115796_115807 = state_115791__$1;
(statearr_115796_115807[(1)] = (6));

} else {
var statearr_115797_115808 = state_115791__$1;
(statearr_115797_115808[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115792 === (6))){
var inst_115781 = (state_115791[(7)]);
var inst_115783 = fluree.db.storage.core.serde(conn);
var inst_115784 = fluree.db.serde.protocol._deserialize_block(inst_115783,inst_115781);
var state_115791__$1 = state_115791;
var statearr_115798_115809 = state_115791__$1;
(statearr_115798_115809[(2)] = inst_115784);

(statearr_115798_115809[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115792 === (7))){
var state_115791__$1 = state_115791;
var statearr_115799_115810 = state_115791__$1;
(statearr_115799_115810[(2)] = null);

(statearr_115799_115810[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115792 === (8))){
var inst_115787 = (state_115791[(2)]);
var state_115791__$1 = state_115791;
var statearr_115800_115811 = state_115791__$1;
(statearr_115800_115811[(2)] = inst_115787);


cljs.core.async.impl.ioc_helpers.process_exception(state_115791__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____0 = (function (){
var statearr_115801 = [null,null,null,null,null,null,null,null];
(statearr_115801[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__);

(statearr_115801[(1)] = (1));

return statearr_115801;
});
var fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____1 = (function (state_115791){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115791);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115802){if((e115802 instanceof Object)){
var ex__109974__auto__ = e115802;
var statearr_115803_115812 = state_115791;
(statearr_115803_115812[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115791);

return cljs.core.cst$kw$recur;
} else {
throw e115802;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115813 = state_115791;
state_115791 = G__115813;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__ = function(state_115791){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____1.call(this,state_115791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115804 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115804[(6)] = c__110077__auto__);

return statearr_115804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115834){
var state_val_115835 = (state_115834[(1)]);
if((state_val_115835 === (1))){
var state_115834__$1 = state_115834;
var statearr_115836_115843 = state_115834__$1;
(statearr_115836_115843[(2)] = null);

(statearr_115836_115843[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115835 === (2))){
var inst_115832 = (state_115834[(2)]);
var state_115834__$1 = state_115834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115834__$1,inst_115832);
} else {
if((state_val_115835 === (3))){
var inst_115814 = (state_115834[(2)]);
var state_115834__$1 = state_115834;
var statearr_115837_115844 = state_115834__$1;
(statearr_115837_115844[(2)] = inst_115814);


cljs.core.async.impl.ioc_helpers.process_exception(state_115834__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115835 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115834,(3),Error,null,(2));
var inst_115818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115819 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_115820 = (new cljs.core.PersistentVector(null,3,(5),inst_115818,inst_115819,null));
var inst_115821 = cljs.core.select_keys(block_data,inst_115820);
var inst_115822 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_115821);
var inst_115823 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_115822);
var inst_115824 = [inst_115823,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_115825 = fluree.db.storage.core.serde(conn);
var inst_115826 = fluree.db.serde.protocol._serialize_block(inst_115825,inst_115821);
var inst_115827 = fluree.db.storage.core.storage_write(conn,inst_115824,inst_115826);
var state_115834__$1 = state_115834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115834__$1,(5),inst_115827);
} else {
if((state_val_115835 === (5))){
var inst_115829 = (state_115834[(2)]);
var inst_115830 = fluree.db.util.async.throw_err(inst_115829);
var state_115834__$1 = state_115834;
var statearr_115838_115845 = state_115834__$1;
(statearr_115838_115845[(2)] = inst_115830);


cljs.core.async.impl.ioc_helpers.process_exception(state_115834__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____0 = (function (){
var statearr_115839 = [null,null,null,null,null,null,null];
(statearr_115839[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__);

(statearr_115839[(1)] = (1));

return statearr_115839;
});
var fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____1 = (function (state_115834){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115834);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115840){if((e115840 instanceof Object)){
var ex__109974__auto__ = e115840;
var statearr_115841_115846 = state_115834;
(statearr_115841_115846[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115834);

return cljs.core.cst$kw$recur;
} else {
throw e115840;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115847 = state_115834;
state_115834 = G__115847;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__ = function(state_115834){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____1.call(this,state_115834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115842 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115842[(6)] = c__110077__auto__);

return statearr_115842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115867){
var state_val_115868 = (state_115867[(1)]);
if((state_val_115868 === (1))){
var state_115867__$1 = state_115867;
var statearr_115869_115876 = state_115867__$1;
(statearr_115869_115876[(2)] = null);

(statearr_115869_115876[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115868 === (2))){
var inst_115865 = (state_115867[(2)]);
var state_115867__$1 = state_115867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115867__$1,inst_115865);
} else {
if((state_val_115868 === (3))){
var inst_115848 = (state_115867[(2)]);
var state_115867__$1 = state_115867;
var statearr_115870_115877 = state_115867__$1;
(statearr_115870_115877[(2)] = inst_115848);


cljs.core.async.impl.ioc_helpers.process_exception(state_115867__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115868 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115867,(3),Error,null,(2));
var inst_115852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_115853 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_115854 = (new cljs.core.PersistentVector(null,3,(5),inst_115852,inst_115853,null));
var inst_115855 = cljs.core.select_keys(block_data,inst_115854);
var inst_115856 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_115855);
var inst_115857 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_115856);
var inst_115858 = fluree.db.storage.core.serde(conn);
var inst_115859 = fluree.db.serde.protocol._serialize_block(inst_115858,inst_115855);
var inst_115860 = fluree.db.storage.core.storage_write(conn,inst_115857,inst_115859);
var state_115867__$1 = state_115867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115867__$1,(5),inst_115860);
} else {
if((state_val_115868 === (5))){
var inst_115862 = (state_115867[(2)]);
var inst_115863 = fluree.db.util.async.throw_err(inst_115862);
var state_115867__$1 = state_115867;
var statearr_115871_115878 = state_115867__$1;
(statearr_115871_115878[(2)] = inst_115863);


cljs.core.async.impl.ioc_helpers.process_exception(state_115867__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__109971__auto____0 = (function (){
var statearr_115872 = [null,null,null,null,null,null,null];
(statearr_115872[(0)] = fluree$db$storage$core$write_block_$_state_machine__109971__auto__);

(statearr_115872[(1)] = (1));

return statearr_115872;
});
var fluree$db$storage$core$write_block_$_state_machine__109971__auto____1 = (function (state_115867){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115867);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115873){if((e115873 instanceof Object)){
var ex__109974__auto__ = e115873;
var statearr_115874_115879 = state_115867;
(statearr_115874_115879[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115867);

return cljs.core.cst$kw$recur;
} else {
throw e115873;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115880 = state_115867;
state_115867 = G__115880;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__109971__auto__ = function(state_115867){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__109971__auto____1.call(this,state_115867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115875 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115875[(6)] = c__110077__auto__);

return statearr_115875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115897){
var state_val_115898 = (state_115897[(1)]);
if((state_val_115898 === (1))){
var state_115897__$1 = state_115897;
var statearr_115899_115906 = state_115897__$1;
(statearr_115899_115906[(2)] = null);

(statearr_115899_115906[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115898 === (2))){
var inst_115895 = (state_115897[(2)]);
var state_115897__$1 = state_115897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115897__$1,inst_115895);
} else {
if((state_val_115898 === (3))){
var inst_115881 = (state_115897[(2)]);
var state_115897__$1 = state_115897;
var statearr_115900_115907 = state_115897__$1;
(statearr_115900_115907[(2)] = inst_115881);


cljs.core.async.impl.ioc_helpers.process_exception(state_115897__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115898 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115897,(3),Error,null,(2));
var inst_115885 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_115886 = [history,next_his_key];
var inst_115887 = cljs.core.PersistentHashMap.fromArrays(inst_115885,inst_115886);
var inst_115888 = fluree.db.storage.core.serde(conn);
var inst_115889 = fluree.db.serde.protocol._serialize_leaf(inst_115888,inst_115887);
var inst_115890 = fluree.db.storage.core.storage_write(conn,his_key,inst_115889);
var state_115897__$1 = state_115897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115897__$1,(5),inst_115890);
} else {
if((state_val_115898 === (5))){
var inst_115892 = (state_115897[(2)]);
var inst_115893 = fluree.db.util.async.throw_err(inst_115892);
var state_115897__$1 = state_115897;
var statearr_115901_115908 = state_115897__$1;
(statearr_115901_115908[(2)] = inst_115893);


cljs.core.async.impl.ioc_helpers.process_exception(state_115897__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__109971__auto____0 = (function (){
var statearr_115902 = [null,null,null,null,null,null,null];
(statearr_115902[(0)] = fluree$db$storage$core$write_history_$_state_machine__109971__auto__);

(statearr_115902[(1)] = (1));

return statearr_115902;
});
var fluree$db$storage$core$write_history_$_state_machine__109971__auto____1 = (function (state_115897){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115897);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115903){if((e115903 instanceof Object)){
var ex__109974__auto__ = e115903;
var statearr_115904_115909 = state_115897;
(statearr_115904_115909[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115897);

return cljs.core.cst$kw$recur;
} else {
throw e115903;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115910 = state_115897;
state_115897 = G__115910;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__109971__auto__ = function(state_115897){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__109971__auto____1.call(this,state_115897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_history_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115905 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115905[(6)] = c__110077__auto__);

return statearr_115905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115933){
var state_val_115934 = (state_115933[(1)]);
if((state_val_115934 === (1))){
var state_115933__$1 = state_115933;
var statearr_115935_115945 = state_115933__$1;
(statearr_115935_115945[(2)] = null);

(statearr_115935_115945[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115934 === (2))){
var inst_115931 = (state_115933[(2)]);
var state_115933__$1 = state_115933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115933__$1,inst_115931);
} else {
if((state_val_115934 === (3))){
var inst_115911 = (state_115933[(2)]);
var state_115933__$1 = state_115933;
var statearr_115936_115946 = state_115933__$1;
(statearr_115936_115946[(2)] = inst_115911);


cljs.core.async.impl.ioc_helpers.process_exception(state_115933__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115934 === (4))){
var inst_115915 = (state_115933[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115933,(3),Error,null,(2));
var inst_115915__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_115916 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_115915__$1),"-his"].join('');
var inst_115917 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_115918 = [flakes,inst_115916];
var inst_115919 = cljs.core.PersistentHashMap.fromArrays(inst_115917,inst_115918);
var inst_115920 = fluree.db.storage.core.serde(conn);
var inst_115921 = fluree.db.serde.protocol._serialize_leaf(inst_115920,inst_115919);
var inst_115922 = fluree.db.storage.core.write_history(conn,history,inst_115916,null);
var inst_115923 = fluree.db.storage.core.storage_write(conn,inst_115915__$1,inst_115921);
var state_115933__$1 = (function (){var statearr_115937 = state_115933;
(statearr_115937[(7)] = inst_115915__$1);

(statearr_115937[(8)] = inst_115923);

return statearr_115937;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115933__$1,(5),inst_115922);
} else {
if((state_val_115934 === (5))){
var inst_115923 = (state_115933[(8)]);
var inst_115925 = (state_115933[(2)]);
var inst_115926 = fluree.db.util.async.throw_err(inst_115925);
var state_115933__$1 = (function (){var statearr_115938 = state_115933;
(statearr_115938[(9)] = inst_115926);

return statearr_115938;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115933__$1,(6),inst_115923);
} else {
if((state_val_115934 === (6))){
var inst_115915 = (state_115933[(7)]);
var inst_115928 = (state_115933[(2)]);
var inst_115929 = fluree.db.util.async.throw_err(inst_115928);
var state_115933__$1 = (function (){var statearr_115939 = state_115933;
(statearr_115939[(10)] = inst_115929);

return statearr_115939;
})();
var statearr_115940_115947 = state_115933__$1;
(statearr_115940_115947[(2)] = inst_115915);


cljs.core.async.impl.ioc_helpers.process_exception(state_115933__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____0 = (function (){
var statearr_115941 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_115941[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__);

(statearr_115941[(1)] = (1));

return statearr_115941;
});
var fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____1 = (function (state_115933){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115933);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115942){if((e115942 instanceof Object)){
var ex__109974__auto__ = e115942;
var statearr_115943_115948 = state_115933;
(statearr_115943_115948[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115933);

return cljs.core.cst$kw$recur;
} else {
throw e115942;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115949 = state_115933;
state_115933 = G__115949;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__ = function(state_115933){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____1.call(this,state_115933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115944 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115944[(6)] = c__110077__auto__);

return statearr_115944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_115963){
var state_val_115964 = (state_115963[(1)]);
if((state_val_115964 === (1))){
var state_115963__$1 = state_115963;
var statearr_115965_115973 = state_115963__$1;
(statearr_115965_115973[(2)] = null);

(statearr_115965_115973[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115964 === (2))){
var inst_115961 = (state_115963[(2)]);
var state_115963__$1 = state_115963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115963__$1,inst_115961);
} else {
if((state_val_115964 === (3))){
var inst_115950 = (state_115963[(2)]);
var state_115963__$1 = state_115963;
var statearr_115966_115974 = state_115963__$1;
(statearr_115966_115974[(2)] = inst_115950);


cljs.core.async.impl.ioc_helpers.process_exception(state_115963__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115964 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115963,(3),Error,null,(2));
var inst_115954 = fluree.db.storage.core.serde(conn);
var inst_115955 = fluree.db.serde.protocol._serialize_branch(inst_115954,data);
var inst_115956 = fluree.db.storage.core.storage_write(conn,key,inst_115955);
var state_115963__$1 = state_115963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115963__$1,(5),inst_115956);
} else {
if((state_val_115964 === (5))){
var inst_115958 = (state_115963[(2)]);
var inst_115959 = fluree.db.util.async.throw_err(inst_115958);
var state_115963__$1 = (function (){var statearr_115967 = state_115963;
(statearr_115967[(7)] = inst_115959);

return statearr_115967;
})();
var statearr_115968_115975 = state_115963__$1;
(statearr_115968_115975[(2)] = key);


cljs.core.async.impl.ioc_helpers.process_exception(state_115963__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____0 = (function (){
var statearr_115969 = [null,null,null,null,null,null,null,null];
(statearr_115969[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__);

(statearr_115969[(1)] = (1));

return statearr_115969;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____1 = (function (state_115963){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115963);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115970){if((e115970 instanceof Object)){
var ex__109974__auto__ = e115970;
var statearr_115971_115976 = state_115963;
(statearr_115971_115976[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115963);

return cljs.core.cst$kw$recur;
} else {
throw e115970;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115977 = state_115963;
state_115963 = G__115977;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__ = function(state_115963){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____1.call(this,state_115963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_115972 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115972[(6)] = c__110077__auto__);

return statearr_115972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (branch_key){
return (function (p1__115978_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__115978_SHARP_));
});})(branch_key))
,children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__115979){
var map__115980 = p__115979;
var map__115980__$1 = (((((!((map__115980 == null))))?(((((map__115980.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__115980.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__115980):map__115980);
var progress = map__115980__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__115980__$1,cljs.core.cst$kw$garbage);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__115980,map__115980__$1,progress,garbage){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__115980,map__115980__$1,progress,garbage){
return (function (state_116025){
var state_val_116026 = (state_116025[(1)]);
if((state_val_116026 === (7))){
var inst_116002 = (state_116025[(2)]);
var state_116025__$1 = state_116025;
if(cljs.core.truth_(inst_116002)){
var statearr_116027_116048 = state_116025__$1;
(statearr_116027_116048[(1)] = (11));

} else {
var statearr_116028_116049 = state_116025__$1;
(statearr_116028_116049[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (1))){
var state_116025__$1 = state_116025;
var statearr_116029_116050 = state_116025__$1;
(statearr_116029_116050[(2)] = null);

(statearr_116029_116050[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116025,(3),Error,null,(2));
var inst_115988 = (db == null);
var inst_115989 = cljs.core.not(inst_115988);
var state_116025__$1 = state_116025;
if(inst_115989){
var statearr_116030_116051 = state_116025__$1;
(statearr_116030_116051[(1)] = (5));

} else {
var statearr_116031_116052 = state_116025__$1;
(statearr_116031_116052[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (13))){
var inst_116012 = (state_116025[(7)]);
var inst_116007 = (state_116025[(2)]);
var inst_116008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116007,cljs.core.cst$kw$conn);
var inst_116009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116007,cljs.core.cst$kw$network);
var inst_116010 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116007,cljs.core.cst$kw$dbid);
var inst_116011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116007,cljs.core.cst$kw$block);
var inst_116012__$1 = fluree.db.storage.core.ledger_garbage_key(inst_116009,inst_116010,inst_116011);
var inst_116013 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_116014 = [inst_116010,inst_116011,garbage];
var inst_116015 = cljs.core.PersistentHashMap.fromArrays(inst_116013,inst_116014);
var inst_116016 = fluree.db.storage.core.serde(inst_116008);
var inst_116017 = fluree.db.serde.protocol._serialize_garbage(inst_116016,inst_116015);
var inst_116018 = fluree.db.storage.core.storage_write(inst_116008,inst_116012__$1,inst_116017);
var state_116025__$1 = (function (){var statearr_116032 = state_116025;
(statearr_116032[(7)] = inst_116012__$1);

return statearr_116032;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116025__$1,(14),inst_116018);
} else {
if((state_val_116026 === (6))){
var state_116025__$1 = state_116025;
var statearr_116033_116053 = state_116025__$1;
(statearr_116033_116053[(2)] = false);

(statearr_116033_116053[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (3))){
var inst_115982 = (state_116025[(2)]);
var state_116025__$1 = state_116025;
var statearr_116034_116054 = state_116025__$1;
(statearr_116034_116054[(2)] = inst_115982);


cljs.core.async.impl.ioc_helpers.process_exception(state_116025__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (12))){
var state_116025__$1 = state_116025;
var statearr_116035_116055 = state_116025__$1;
(statearr_116035_116055[(2)] = db);

(statearr_116035_116055[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (2))){
var inst_116023 = (state_116025[(2)]);
var state_116025__$1 = state_116025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116025__$1,inst_116023);
} else {
if((state_val_116026 === (11))){
var inst_116004 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_116025__$1 = state_116025;
var statearr_116036_116056 = state_116025__$1;
(statearr_116036_116056[(2)] = inst_116004);

(statearr_116036_116056[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (9))){
var state_116025__$1 = state_116025;
var statearr_116037_116057 = state_116025__$1;
(statearr_116037_116057[(2)] = false);

(statearr_116037_116057[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (5))){
var inst_115991 = db.cljs$lang$protocol_mask$partition0$;
var inst_115992 = (inst_115991 & (64));
var inst_115993 = db.cljs$core$ISeq$;
var inst_115994 = (cljs.core.PROTOCOL_SENTINEL === inst_115993);
var inst_115995 = ((inst_115992) || (inst_115994));
var state_116025__$1 = state_116025;
if(cljs.core.truth_(inst_115995)){
var statearr_116038_116058 = state_116025__$1;
(statearr_116038_116058[(1)] = (8));

} else {
var statearr_116039_116059 = state_116025__$1;
(statearr_116039_116059[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (14))){
var inst_116012 = (state_116025[(7)]);
var inst_116020 = (state_116025[(2)]);
var inst_116021 = fluree.db.util.async.throw_err(inst_116020);
var state_116025__$1 = (function (){var statearr_116040 = state_116025;
(statearr_116040[(8)] = inst_116021);

return statearr_116040;
})();
var statearr_116041_116060 = state_116025__$1;
(statearr_116041_116060[(2)] = inst_116012);


cljs.core.async.impl.ioc_helpers.process_exception(state_116025__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (10))){
var inst_115999 = (state_116025[(2)]);
var state_116025__$1 = state_116025;
var statearr_116042_116061 = state_116025__$1;
(statearr_116042_116061[(2)] = inst_115999);

(statearr_116042_116061[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116026 === (8))){
var state_116025__$1 = state_116025;
var statearr_116043_116062 = state_116025__$1;
(statearr_116043_116062[(2)] = true);

(statearr_116043_116062[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__115980,map__115980__$1,progress,garbage))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__115980,map__115980__$1,progress,garbage){
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____0 = (function (){
var statearr_116044 = [null,null,null,null,null,null,null,null,null];
(statearr_116044[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__);

(statearr_116044[(1)] = (1));

return statearr_116044;
});
var fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____1 = (function (state_116025){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116025);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116045){if((e116045 instanceof Object)){
var ex__109974__auto__ = e116045;
var statearr_116046_116063 = state_116025;
(statearr_116046_116063[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116025);

return cljs.core.cst$kw$recur;
} else {
throw e116045;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116064 = state_116025;
state_116025 = G__116064;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__ = function(state_116025){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____1.call(this,state_116025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__109971__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__115980,map__115980__$1,progress,garbage))
})();
var state__110079__auto__ = (function (){var statearr_116047 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116047[(6)] = c__110077__auto__);

return statearr_116047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__115980,map__115980__$1,progress,garbage))
);

return c__110077__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__116066 = arguments.length;
switch (G__116066) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
});

fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_116137){
var state_val_116138 = (state_116137[(1)]);
if((state_val_116138 === (7))){
var inst_116087 = (state_116137[(2)]);
var state_116137__$1 = state_116137;
if(cljs.core.truth_(inst_116087)){
var statearr_116139_116170 = state_116137__$1;
(statearr_116139_116170[(1)] = (11));

} else {
var statearr_116140_116171 = state_116137__$1;
(statearr_116140_116171[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (20))){
var inst_116106 = (state_116137[(7)]);
var inst_116132 = (state_116137[(2)]);
var inst_116133 = fluree.db.util.async.throw_err(inst_116132);
var state_116137__$1 = (function (){var statearr_116141 = state_116137;
(statearr_116141[(8)] = inst_116133);

return statearr_116141;
})();
var statearr_116142_116172 = state_116137__$1;
(statearr_116142_116172[(2)] = inst_116106);


cljs.core.async.impl.ioc_helpers.process_exception(state_116137__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (1))){
var state_116137__$1 = state_116137;
var statearr_116143_116173 = state_116137__$1;
(statearr_116143_116173[(2)] = null);

(statearr_116143_116173[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116137,(3),Error,null,(2));
var inst_116073 = (db == null);
var inst_116074 = cljs.core.not(inst_116073);
var state_116137__$1 = state_116137;
if(inst_116074){
var statearr_116144_116174 = state_116137__$1;
(statearr_116144_116174[(1)] = (5));

} else {
var statearr_116145_116175 = state_116137__$1;
(statearr_116145_116175[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (15))){
var state_116137__$1 = state_116137;
var statearr_116146_116176 = state_116137__$1;
(statearr_116146_116176[(2)] = (0));

(statearr_116146_116176[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (13))){
var inst_116101 = (state_116137[(9)]);
var inst_116109 = (state_116137[(10)]);
var inst_116099 = (state_116137[(11)]);
var inst_116097 = (state_116137[(12)]);
var inst_116092 = (state_116137[(2)]);
var inst_116093 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$network);
var inst_116094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$t);
var inst_116095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$fork);
var inst_116096 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$spot);
var inst_116097__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$stats);
var inst_116098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$conn);
var inst_116099__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$block);
var inst_116100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$psot);
var inst_116101__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$dbid);
var inst_116102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$ecount);
var inst_116103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$opst);
var inst_116104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$fork_DASH_block);
var inst_116105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116092,cljs.core.cst$kw$post);
var inst_116106 = fluree.db.storage.core.ledger_root_key(inst_116093,inst_116101__$1,inst_116099__$1);
var inst_116107 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_116108 = fluree.db.storage.core.child_data(inst_116100);
var inst_116109__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_116097__$1);
var state_116137__$1 = (function (){var statearr_116147 = state_116137;
(statearr_116147[(9)] = inst_116101__$1);

(statearr_116147[(13)] = inst_116104);

(statearr_116147[(14)] = inst_116096);

(statearr_116147[(10)] = inst_116109__$1);

(statearr_116147[(7)] = inst_116106);

(statearr_116147[(15)] = inst_116094);

(statearr_116147[(16)] = inst_116095);

(statearr_116147[(17)] = inst_116098);

(statearr_116147[(18)] = inst_116103);

(statearr_116147[(19)] = inst_116107);

(statearr_116147[(11)] = inst_116099__$1);

(statearr_116147[(12)] = inst_116097__$1);

(statearr_116147[(20)] = inst_116102);

(statearr_116147[(21)] = inst_116105);

(statearr_116147[(22)] = inst_116108);

return statearr_116147;
})();
if(cljs.core.truth_(inst_116109__$1)){
var statearr_116148_116177 = state_116137__$1;
(statearr_116148_116177[(1)] = (14));

} else {
var statearr_116149_116178 = state_116137__$1;
(statearr_116149_116178[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (6))){
var state_116137__$1 = state_116137;
var statearr_116150_116179 = state_116137__$1;
(statearr_116150_116179[(2)] = false);

(statearr_116150_116179[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (17))){
var state_116137__$1 = state_116137;
var statearr_116151_116180 = state_116137__$1;
(statearr_116151_116180[(2)] = custom_ecount);

(statearr_116151_116180[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (3))){
var inst_116067 = (state_116137[(2)]);
var state_116137__$1 = state_116137;
var statearr_116152_116181 = state_116137__$1;
(statearr_116152_116181[(2)] = inst_116067);


cljs.core.async.impl.ioc_helpers.process_exception(state_116137__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (12))){
var state_116137__$1 = state_116137;
var statearr_116153_116182 = state_116137__$1;
(statearr_116153_116182[(2)] = db);

(statearr_116153_116182[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (2))){
var inst_116135 = (state_116137[(2)]);
var state_116137__$1 = state_116137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116137__$1,inst_116135);
} else {
if((state_val_116138 === (19))){
var inst_116101 = (state_116137[(9)]);
var inst_116104 = (state_116137[(13)]);
var inst_116096 = (state_116137[(14)]);
var inst_116106 = (state_116137[(7)]);
var inst_116094 = (state_116137[(15)]);
var inst_116095 = (state_116137[(16)]);
var inst_116098 = (state_116137[(17)]);
var inst_116103 = (state_116137[(18)]);
var inst_116113 = (state_116137[(23)]);
var inst_116107 = (state_116137[(19)]);
var inst_116099 = (state_116137[(11)]);
var inst_116097 = (state_116137[(12)]);
var inst_116105 = (state_116137[(21)]);
var inst_116108 = (state_116137[(22)]);
var inst_116117 = (state_116137[(2)]);
var inst_116118 = fluree.db.storage.core.child_data(inst_116103);
var inst_116119 = fluree.db.storage.core.child_data(inst_116105);
var inst_116120 = fluree.db.util.core.current_time_millis();
var inst_116121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_116122 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_116123 = (new cljs.core.PersistentVector(null,2,(5),inst_116121,inst_116122,null));
var inst_116124 = cljs.core.select_keys(inst_116097,inst_116123);
var inst_116125 = fluree.db.storage.core.child_data(inst_116096);
var inst_116126 = [inst_116099,inst_116108,inst_116101,inst_116113,inst_116117,inst_116118,inst_116119,inst_116094,inst_116120,inst_116095,inst_116104,inst_116124,inst_116125];
var inst_116127 = cljs.core.PersistentHashMap.fromArrays(inst_116107,inst_116126);
var inst_116128 = fluree.db.storage.core.serde(inst_116098);
var inst_116129 = fluree.db.serde.protocol._serialize_db_root(inst_116128,inst_116127);
var inst_116130 = fluree.db.storage.core.storage_write(inst_116098,inst_116106,inst_116129);
var state_116137__$1 = state_116137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116137__$1,(20),inst_116130);
} else {
if((state_val_116138 === (11))){
var inst_116089 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,db);
var state_116137__$1 = state_116137;
var statearr_116154_116183 = state_116137__$1;
(statearr_116154_116183[(2)] = inst_116089);

(statearr_116154_116183[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (9))){
var state_116137__$1 = state_116137;
var statearr_116155_116184 = state_116137__$1;
(statearr_116155_116184[(2)] = false);

(statearr_116155_116184[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (5))){
var inst_116076 = db.cljs$lang$protocol_mask$partition0$;
var inst_116077 = (inst_116076 & (64));
var inst_116078 = db.cljs$core$ISeq$;
var inst_116079 = (cljs.core.PROTOCOL_SENTINEL === inst_116078);
var inst_116080 = ((inst_116077) || (inst_116079));
var state_116137__$1 = state_116137;
if(cljs.core.truth_(inst_116080)){
var statearr_116156_116185 = state_116137__$1;
(statearr_116156_116185[(1)] = (8));

} else {
var statearr_116157_116186 = state_116137__$1;
(statearr_116157_116186[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (14))){
var inst_116109 = (state_116137[(10)]);
var state_116137__$1 = state_116137;
var statearr_116158_116187 = state_116137__$1;
(statearr_116158_116187[(2)] = inst_116109);

(statearr_116158_116187[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (16))){
var inst_116113 = (state_116137[(2)]);
var state_116137__$1 = (function (){var statearr_116159 = state_116137;
(statearr_116159[(23)] = inst_116113);

return statearr_116159;
})();
if(cljs.core.truth_(custom_ecount)){
var statearr_116160_116188 = state_116137__$1;
(statearr_116160_116188[(1)] = (17));

} else {
var statearr_116161_116189 = state_116137__$1;
(statearr_116161_116189[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (10))){
var inst_116084 = (state_116137[(2)]);
var state_116137__$1 = state_116137;
var statearr_116162_116190 = state_116137__$1;
(statearr_116162_116190[(2)] = inst_116084);

(statearr_116162_116190[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (18))){
var inst_116102 = (state_116137[(20)]);
var state_116137__$1 = state_116137;
var statearr_116163_116191 = state_116137__$1;
(statearr_116163_116191[(2)] = inst_116102);

(statearr_116163_116191[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116138 === (8))){
var state_116137__$1 = state_116137;
var statearr_116164_116192 = state_116137__$1;
(statearr_116164_116192[(2)] = true);

(statearr_116164_116192[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$state_machine__109971__auto__ = null;
var fluree$db$storage$core$state_machine__109971__auto____0 = (function (){
var statearr_116165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116165[(0)] = fluree$db$storage$core$state_machine__109971__auto__);

(statearr_116165[(1)] = (1));

return statearr_116165;
});
var fluree$db$storage$core$state_machine__109971__auto____1 = (function (state_116137){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116137);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116166){if((e116166 instanceof Object)){
var ex__109974__auto__ = e116166;
var statearr_116167_116193 = state_116137;
(statearr_116167_116193[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116137);

return cljs.core.cst$kw$recur;
} else {
throw e116166;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116194 = state_116137;
state_116137 = G__116194;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__109971__auto__ = function(state_116137){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__109971__auto____1.call(this,state_116137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__109971__auto____0;
fluree$db$storage$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__109971__auto____1;
return fluree$db$storage$core$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_116168 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116168[(6)] = c__110077__auto__);

return statearr_116168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2;

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___116236 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___116236,return_ch){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___116236,return_ch){
return (function (state_116221){
var state_val_116222 = (state_116221[(1)]);
if((state_val_116222 === (1))){
var state_116221__$1 = state_116221;
var statearr_116223_116237 = state_116221__$1;
(statearr_116223_116237[(2)] = null);

(statearr_116223_116237[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116222 === (2))){
var inst_116219 = (state_116221[(2)]);
var state_116221__$1 = state_116221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116221__$1,inst_116219);
} else {
if((state_val_116222 === (3))){
var inst_116195 = (state_116221[(2)]);
var inst_116196 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_116197 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116195);
var inst_116198 = cljs.core.async.close_BANG_(return_ch);
var state_116221__$1 = (function (){var statearr_116224 = state_116221;
(statearr_116224[(7)] = inst_116196);

(statearr_116224[(8)] = inst_116197);

return statearr_116224;
})();
var statearr_116225_116238 = state_116221__$1;
(statearr_116225_116238[(2)] = inst_116198);


cljs.core.async.impl.ioc_helpers.process_exception(state_116221__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116222 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116221,(3),java.lang.Exception,null,(2));
var inst_116202 = fluree.db.storage.core.storage_read(conn,key);
var state_116221__$1 = state_116221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116221__$1,(5),inst_116202);
} else {
if((state_val_116222 === (5))){
var inst_116204 = (state_116221[(9)]);
var inst_116204__$1 = (state_116221[(2)]);
var inst_116205 = (inst_116204__$1 == null);
var inst_116206 = (inst_116204__$1 instanceof Error);
var inst_116207 = ((inst_116205) || (inst_116206));
var state_116221__$1 = (function (){var statearr_116226 = state_116221;
(statearr_116226[(9)] = inst_116204__$1);

return statearr_116226;
})();
if(cljs.core.truth_(inst_116207)){
var statearr_116227_116239 = state_116221__$1;
(statearr_116227_116239[(1)] = (6));

} else {
var statearr_116228_116240 = state_116221__$1;
(statearr_116228_116240[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116222 === (6))){
var inst_116209 = cljs.core.async.close_BANG_(return_ch);
var state_116221__$1 = state_116221;
var statearr_116229_116241 = state_116221__$1;
(statearr_116229_116241[(2)] = inst_116209);

(statearr_116229_116241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116222 === (7))){
var inst_116204 = (state_116221[(9)]);
var inst_116211 = fluree.db.storage.core.serde(conn);
var inst_116212 = fluree.db.serde.protocol._deserialize_leaf(inst_116211,inst_116204);
var inst_116213 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_116212);
var inst_116214 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_116213);
var inst_116215 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116214);
var state_116221__$1 = state_116221;
var statearr_116230_116242 = state_116221__$1;
(statearr_116230_116242[(2)] = inst_116215);

(statearr_116230_116242[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116222 === (8))){
var inst_116217 = (state_116221[(2)]);
var state_116221__$1 = state_116221;
var statearr_116231_116243 = state_116221__$1;
(statearr_116231_116243[(2)] = inst_116217);


cljs.core.async.impl.ioc_helpers.process_exception(state_116221__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto___116236,return_ch))
;
return ((function (switch__109970__auto__,c__110077__auto___116236,return_ch){
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__109971__auto____0 = (function (){
var statearr_116232 = [null,null,null,null,null,null,null,null,null,null];
(statearr_116232[(0)] = fluree$db$storage$core$reify_history_$_state_machine__109971__auto__);

(statearr_116232[(1)] = (1));

return statearr_116232;
});
var fluree$db$storage$core$reify_history_$_state_machine__109971__auto____1 = (function (state_116221){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116221);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116233){if((e116233 instanceof Object)){
var ex__109974__auto__ = e116233;
var statearr_116234_116244 = state_116221;
(statearr_116234_116244[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116221);

return cljs.core.cst$kw$recur;
} else {
throw e116233;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116245 = state_116221;
state_116221 = G__116245;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__109971__auto__ = function(state_116221){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__109971__auto____1.call(this,state_116221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__109971__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__109971__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___116236,return_ch))
})();
var state__110079__auto__ = (function (){var statearr_116235 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116235[(6)] = c__110077__auto___116236);

return statearr_116235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___116236,return_ch))
);


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__116247 = arguments.length;
switch (G__116247) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
});

fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4120__auto__ = rhs;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4120__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4120__auto__ = rhs;
if(cljs.core.truth_(and__4120__auto__)){
return leftmost_QMARK_;
} else {
return and__4120__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4120__auto__ = (rhs == null);
if(and__4120__auto__){
return leftmost_QMARK_;
} else {
return and__4120__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (novelty_subrange){
return (function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
});})(novelty_subrange))
,novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
});

fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5;

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___116349 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___116349,result_ch){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___116349,result_ch){
return (function (state_116307){
var state_val_116308 = (state_116307[(1)]);
if((state_val_116308 === (7))){
var inst_116262 = (state_116307[(7)]);
var inst_116266 = (inst_116262 < t);
var state_116307__$1 = state_116307;
if(cljs.core.truth_(inst_116266)){
var statearr_116309_116350 = state_116307__$1;
(statearr_116309_116350[(1)] = (9));

} else {
var statearr_116310_116351 = state_116307__$1;
(statearr_116310_116351[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (20))){
var inst_116260 = (state_116307[(8)]);
var inst_116277 = (state_116307[(9)]);
var inst_116261 = (state_116307[(10)]);
var inst_116290 = (state_116307[(11)]);
var inst_116262 = (state_116307[(7)]);
var inst_116297 = (state_116307[(2)]);
var inst_116298 = (function (){var base_node = inst_116260;
var first_flake = inst_116261;
var node_t = inst_116262;
var source = inst_116277;
var coll = inst_116290;
var conj_QMARK_ = inst_116297;
return ((function (base_node,first_flake,node_t,source,coll,conj_QMARK_,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,inst_116297,state_val_116308,c__110077__auto___116349,result_ch){
return (function (acc,f){
if(cljs.core.truth_((function (){var G__116312 = f.p;
var fexpr__116311 = (function (){var or__4131__auto__ = remove_preds;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__116311.cljs$core$IFn$_invoke$arity$1 ? fexpr__116311.cljs$core$IFn$_invoke$arity$1(G__116312) : fexpr__116311.call(null,G__116312));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
;})(base_node,first_flake,node_t,source,coll,conj_QMARK_,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,inst_116297,state_val_116308,c__110077__auto___116349,result_ch))
})();
var inst_116299 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_116260);
var inst_116300 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_116298,inst_116299,inst_116290);
var inst_116301 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_116300);
var inst_116302 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_116260,cljs.core.cst$kw$flakes,inst_116301);
var inst_116303 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_116302);
var state_116307__$1 = state_116307;
var statearr_116313_116352 = state_116307__$1;
(statearr_116313_116352[(2)] = inst_116303);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (1))){
var state_116307__$1 = state_116307;
var statearr_116314_116353 = state_116307__$1;
(statearr_116314_116353[(2)] = null);

(statearr_116314_116353[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116307,(3),java.lang.Exception,null,(2));
var inst_116257 = fluree.db.dbproto._resolve(node);
var state_116307__$1 = state_116307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116307__$1,(5),inst_116257);
} else {
if((state_val_116308 === (15))){
var inst_116277 = (state_116307[(9)]);
var inst_116290 = (state_116307[(2)]);
var state_116307__$1 = (function (){var statearr_116315 = state_116307;
(statearr_116315[(11)] = inst_116290);

return statearr_116315;
})();
var G__116316_116354 = inst_116277;
var G__116316_116355__$1 = (((G__116316_116354 instanceof cljs.core.Keyword))?G__116316_116354.fqn:null);
switch (G__116316_116355__$1) {
case "novelty":
var statearr_116317_116357 = state_116307__$1;
(statearr_116317_116357[(1)] = (21));


break;
case "history":
var statearr_116318_116358 = state_116307__$1;
(statearr_116318_116358[(1)] = (22));


break;
case "none":
var statearr_116319_116359 = state_116307__$1;
(statearr_116319_116359[(1)] = (23));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__116316_116355__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (21))){
var inst_116260 = (state_116307[(8)]);
var inst_116277 = (state_116307[(9)]);
var inst_116261 = (state_116307[(10)]);
var inst_116290 = (state_116307[(11)]);
var inst_116262 = (state_116307[(7)]);
var inst_116291 = (function (){var base_node = inst_116260;
var first_flake = inst_116261;
var node_t = inst_116262;
var source = inst_116277;
var coll = inst_116290;
return ((function (base_node,first_flake,node_t,source,coll,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,state_val_116308,c__110077__auto___116349,result_ch){
return (function (f){
return f.op === true;
});
;})(base_node,first_flake,node_t,source,coll,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,state_val_116308,c__110077__auto___116349,result_ch))
})();
var state_116307__$1 = state_116307;
var statearr_116320_116360 = state_116307__$1;
(statearr_116320_116360[(2)] = inst_116291);

(statearr_116320_116360[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (13))){
var state_116307__$1 = state_116307;
var statearr_116321_116361 = state_116307__$1;
(statearr_116321_116361[(2)] = null);

(statearr_116321_116361[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (22))){
var inst_116260 = (state_116307[(8)]);
var inst_116277 = (state_116307[(9)]);
var inst_116261 = (state_116307[(10)]);
var inst_116290 = (state_116307[(11)]);
var inst_116262 = (state_116307[(7)]);
var inst_116293 = (function (){var base_node = inst_116260;
var first_flake = inst_116261;
var node_t = inst_116262;
var source = inst_116277;
var coll = inst_116290;
return ((function (base_node,first_flake,node_t,source,coll,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,state_val_116308,c__110077__auto___116349,result_ch){
return (function (f){
return f.op === false;
});
;})(base_node,first_flake,node_t,source,coll,inst_116260,inst_116277,inst_116261,inst_116290,inst_116262,state_val_116308,c__110077__auto___116349,result_ch))
})();
var state_116307__$1 = state_116307;
var statearr_116322_116362 = state_116307__$1;
(statearr_116322_116362[(2)] = inst_116293);

(statearr_116322_116362[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (6))){
var state_116307__$1 = state_116307;
var statearr_116323_116363 = state_116307__$1;
(statearr_116323_116363[(2)] = cljs.core.cst$kw$novelty);

(statearr_116323_116363[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (17))){
var inst_116260 = (state_116307[(8)]);
var inst_116277 = (state_116307[(9)]);
var inst_116261 = (state_116307[(10)]);
var inst_116262 = (state_116307[(7)]);
var inst_116280 = (function (){var base_node = inst_116260;
var first_flake = inst_116261;
var node_t = inst_116262;
var source = inst_116277;
return ((function (base_node,first_flake,node_t,source,inst_116260,inst_116277,inst_116261,inst_116262,state_val_116308,c__110077__auto___116349,result_ch){
return (function (p1__116249_SHARP_){
return (p1__116249_SHARP_.t <= t);
});
;})(base_node,first_flake,node_t,source,inst_116260,inst_116277,inst_116261,inst_116262,state_val_116308,c__110077__auto___116349,result_ch))
})();
var inst_116281 = fluree.db.dbproto._resolve_history(node);
var state_116307__$1 = (function (){var statearr_116324 = state_116307;
(statearr_116324[(12)] = inst_116280);

return statearr_116324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116307__$1,(18),inst_116281);
} else {
if((state_val_116308 === (3))){
var inst_116250 = (state_116307[(2)]);
var inst_116251 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_116252 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_116250);
var inst_116253 = cljs.core.async.close_BANG_(result_ch);
var state_116307__$1 = (function (){var statearr_116325 = state_116307;
(statearr_116325[(13)] = inst_116252);

(statearr_116325[(14)] = inst_116251);

return statearr_116325;
})();
var statearr_116326_116364 = state_116307__$1;
(statearr_116326_116364[(2)] = inst_116253);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (12))){
var state_116307__$1 = state_116307;
var statearr_116327_116365 = state_116307__$1;
(statearr_116327_116365[(2)] = cljs.core.cst$kw$none);

(statearr_116327_116365[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (2))){
var inst_116305 = (state_116307[(2)]);
var state_116307__$1 = state_116307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116307__$1,inst_116305);
} else {
if((state_val_116308 === (23))){
var state_116307__$1 = state_116307;
var statearr_116328_116366 = state_116307__$1;
(statearr_116328_116366[(2)] = null);

(statearr_116328_116366[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (19))){
var inst_116287 = cljs.core.PersistentVector.EMPTY;
var state_116307__$1 = state_116307;
var statearr_116329_116367 = state_116307__$1;
(statearr_116329_116367[(2)] = inst_116287);

(statearr_116329_116367[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (11))){
var inst_116275 = (state_116307[(2)]);
var state_116307__$1 = state_116307;
var statearr_116330_116368 = state_116307__$1;
(statearr_116330_116368[(2)] = inst_116275);

(statearr_116330_116368[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (9))){
var state_116307__$1 = state_116307;
var statearr_116331_116369 = state_116307__$1;
(statearr_116331_116369[(2)] = cljs.core.cst$kw$history);

(statearr_116331_116369[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (5))){
var inst_116260 = (state_116307[(8)]);
var inst_116262 = (state_116307[(7)]);
var inst_116259 = (state_116307[(2)]);
var inst_116260__$1 = fluree.db.util.async.throw_err(inst_116259);
var inst_116261 = fluree.db.dbproto._first_flake(inst_116260__$1);
var inst_116262__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_116260__$1);
var inst_116263 = (inst_116262__$1 > t);
var state_116307__$1 = (function (){var statearr_116332 = state_116307;
(statearr_116332[(8)] = inst_116260__$1);

(statearr_116332[(10)] = inst_116261);

(statearr_116332[(7)] = inst_116262__$1);

return statearr_116332;
})();
if(cljs.core.truth_(inst_116263)){
var statearr_116333_116370 = state_116307__$1;
(statearr_116333_116370[(1)] = (6));

} else {
var statearr_116334_116371 = state_116307__$1;
(statearr_116334_116371[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (14))){
var inst_116273 = (state_116307[(2)]);
var state_116307__$1 = state_116307;
var statearr_116335_116372 = state_116307__$1;
(statearr_116335_116372[(2)] = inst_116273);

(statearr_116335_116372[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (16))){
var inst_116261 = (state_116307[(10)]);
var inst_116278 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_116261,rhs,leftmost_QMARK_,t);
var state_116307__$1 = state_116307;
var statearr_116336_116373 = state_116307__$1;
(statearr_116336_116373[(2)] = inst_116278);

(statearr_116336_116373[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (10))){
var inst_116262 = (state_116307[(7)]);
var inst_116269 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_116262,t);
var state_116307__$1 = state_116307;
if(inst_116269){
var statearr_116337_116374 = state_116307__$1;
(statearr_116337_116374[(1)] = (12));

} else {
var statearr_116338_116375 = state_116307__$1;
(statearr_116338_116375[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (18))){
var inst_116280 = (state_116307[(12)]);
var inst_116283 = (state_116307[(2)]);
var inst_116284 = fluree.db.util.async.throw_err(inst_116283);
var inst_116285 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_116280,inst_116284);
var state_116307__$1 = state_116307;
var statearr_116339_116376 = state_116307__$1;
(statearr_116339_116376[(2)] = inst_116285);

(statearr_116339_116376[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116308 === (8))){
var inst_116277 = (state_116307[(9)]);
var inst_116277__$1 = (state_116307[(2)]);
var state_116307__$1 = (function (){var statearr_116340 = state_116307;
(statearr_116340[(9)] = inst_116277__$1);

return statearr_116340;
})();
var G__116341_116377 = inst_116277__$1;
var G__116341_116378__$1 = (((G__116341_116377 instanceof cljs.core.Keyword))?G__116341_116377.fqn:null);
switch (G__116341_116378__$1) {
case "novelty":
var statearr_116342_116380 = state_116307__$1;
(statearr_116342_116380[(1)] = (16));


break;
case "history":
var statearr_116343_116381 = state_116307__$1;
(statearr_116343_116381[(1)] = (17));


break;
case "none":
var statearr_116344_116382 = state_116307__$1;
(statearr_116344_116382[(1)] = (19));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__116341_116378__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___116349,result_ch))
;
return ((function (switch__109970__auto__,c__110077__auto___116349,result_ch){
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____0 = (function (){
var statearr_116345 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116345[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__);

(statearr_116345[(1)] = (1));

return statearr_116345;
});
var fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____1 = (function (state_116307){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116307);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116346){if((e116346 instanceof Object)){
var ex__109974__auto__ = e116346;
var statearr_116347_116383 = state_116307;
(statearr_116347_116383[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116307);

return cljs.core.cst$kw$recur;
} else {
throw e116346;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116384 = state_116307;
state_116307 = G__116384;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__ = function(state_116307){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____1.call(this,state_116307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__109971__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___116349,result_ch))
})();
var state__110079__auto__ = (function (){var statearr_116348 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116348[(6)] = c__110077__auto___116349);

return statearr_116348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___116349,result_ch))
);


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_116438){
var state_val_116439 = (state_116438[(1)]);
if((state_val_116439 === (7))){
var inst_116418 = (state_116438[(2)]);
var inst_116419 = fluree.db.dbproto._first_flake(node);
var inst_116420 = fluree.db.dbproto._rhs(node);
var inst_116421 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_116438__$1 = (function (){var statearr_116440 = state_116438;
(statearr_116440[(7)] = inst_116419);

(statearr_116440[(8)] = inst_116420);

(statearr_116440[(9)] = inst_116418);

return statearr_116440;
})();
if(cljs.core.truth_(inst_116421)){
var statearr_116441_116469 = state_116438__$1;
(statearr_116441_116469[(1)] = (15));

} else {
var statearr_116442_116470 = state_116438__$1;
(statearr_116442_116470[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (1))){
var state_116438__$1 = state_116438;
var statearr_116443_116471 = state_116438__$1;
(statearr_116443_116471[(2)] = null);

(statearr_116443_116471[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (4))){
var inst_116393 = (state_116438[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116438,(3),java.lang.Exception,null,(2));
var inst_116393__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_116394 = (from_t == null);
var inst_116395 = (inst_116393__$1 <= from_t);
var inst_116396 = ((inst_116394) || (inst_116395));
var state_116438__$1 = (function (){var statearr_116444 = state_116438;
(statearr_116444[(10)] = inst_116393__$1);

return statearr_116444;
})();
if(cljs.core.truth_(inst_116396)){
var statearr_116445_116472 = state_116438__$1;
(statearr_116445_116472[(1)] = (5));

} else {
var statearr_116446_116473 = state_116438__$1;
(statearr_116446_116473[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (15))){
var state_116438__$1 = state_116438;
var statearr_116447_116474 = state_116438__$1;
(statearr_116447_116474[(2)] = null);

(statearr_116447_116474[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (13))){
var inst_116409 = (state_116438[(11)]);
var state_116438__$1 = state_116438;
var statearr_116448_116475 = state_116438__$1;
(statearr_116448_116475[(2)] = inst_116409);

(statearr_116448_116475[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (6))){
var state_116438__$1 = state_116438;
var statearr_116449_116476 = state_116438__$1;
(statearr_116449_116476[(2)] = null);

(statearr_116449_116476[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (17))){
var inst_116419 = (state_116438[(7)]);
var inst_116420 = (state_116438[(8)]);
var inst_116418 = (state_116438[(9)]);
var inst_116432 = (state_116438[(2)]);
var inst_116433 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_116419,inst_116420,leftmost_QMARK_,to_t);
var inst_116434 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_116433,inst_116418);
var state_116438__$1 = (function (){var statearr_116450 = state_116438;
(statearr_116450[(12)] = inst_116432);

return statearr_116450;
})();
var statearr_116451_116477 = state_116438__$1;
(statearr_116451_116477[(2)] = inst_116434);


cljs.core.async.impl.ioc_helpers.process_exception(state_116438__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (3))){
var inst_116387 = (state_116438[(2)]);
var inst_116388 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_116387], 0));
var inst_116389 = (function(){throw inst_116387})();
var state_116438__$1 = (function (){var statearr_116452 = state_116438;
(statearr_116452[(13)] = inst_116388);

return statearr_116452;
})();
var statearr_116453_116478 = state_116438__$1;
(statearr_116453_116478[(2)] = inst_116389);


cljs.core.async.impl.ioc_helpers.process_exception(state_116438__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (12))){
var inst_116409 = (state_116438[(11)]);
var inst_116393 = (state_116438[(10)]);
var inst_116411 = (function (){var node_t = inst_116393;
var G__116398 = inst_116409;
return ((function (node_t,G__116398,inst_116409,inst_116393,state_val_116439,c__110077__auto__){
return (function (p1__116386_SHARP_){
return (p1__116386_SHARP_.t <= from_t);
});
;})(node_t,G__116398,inst_116409,inst_116393,state_val_116439,c__110077__auto__))
})();
var inst_116412 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_116411,inst_116409);
var state_116438__$1 = state_116438;
var statearr_116454_116479 = state_116438__$1;
(statearr_116454_116479[(2)] = inst_116412);

(statearr_116454_116479[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (2))){
var inst_116436 = (state_116438[(2)]);
var state_116438__$1 = state_116438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116438__$1,inst_116436);
} else {
if((state_val_116439 === (11))){
var inst_116409 = (state_116438[(2)]);
var state_116438__$1 = (function (){var statearr_116455 = state_116438;
(statearr_116455[(11)] = inst_116409);

return statearr_116455;
})();
if(cljs.core.truth_(from_t)){
var statearr_116456_116480 = state_116438__$1;
(statearr_116456_116480[(1)] = (12));

} else {
var statearr_116457_116481 = state_116438__$1;
(statearr_116457_116481[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (9))){
var inst_116393 = (state_116438[(10)]);
var inst_116402 = (state_116438[(14)]);
var inst_116405 = (function (){var node_t = inst_116393;
var G__116398 = inst_116402;
return ((function (node_t,G__116398,inst_116393,inst_116402,state_val_116439,c__110077__auto__){
return (function (p1__116385_SHARP_){
return (p1__116385_SHARP_.t < to_t);
});
;})(node_t,G__116398,inst_116393,inst_116402,state_val_116439,c__110077__auto__))
})();
var inst_116406 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_116405,inst_116402);
var state_116438__$1 = state_116438;
var statearr_116458_116482 = state_116438__$1;
(statearr_116458_116482[(2)] = inst_116406);

(statearr_116458_116482[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (5))){
var inst_116399 = fluree.db.dbproto._resolve_history(node);
var state_116438__$1 = state_116438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116438__$1,(8),inst_116399);
} else {
if((state_val_116439 === (14))){
var inst_116415 = (state_116438[(2)]);
var state_116438__$1 = state_116438;
var statearr_116459_116483 = state_116438__$1;
(statearr_116459_116483[(2)] = inst_116415);

(statearr_116459_116483[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (16))){
var inst_116424 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_116425 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_116424)].join('');
var inst_116426 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116427 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_116428 = cljs.core.PersistentHashMap.fromArrays(inst_116426,inst_116427);
var inst_116429 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116425,inst_116428);
var inst_116430 = (function(){throw inst_116429})();
var state_116438__$1 = state_116438;
var statearr_116460_116484 = state_116438__$1;
(statearr_116460_116484[(2)] = inst_116430);

(statearr_116460_116484[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (10))){
var inst_116402 = (state_116438[(14)]);
var state_116438__$1 = state_116438;
var statearr_116461_116485 = state_116438__$1;
(statearr_116461_116485[(2)] = inst_116402);

(statearr_116461_116485[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116439 === (8))){
var inst_116393 = (state_116438[(10)]);
var inst_116401 = (state_116438[(2)]);
var inst_116402 = fluree.db.util.async.throw_err(inst_116401);
var inst_116403 = (to_t > inst_116393);
var state_116438__$1 = (function (){var statearr_116462 = state_116438;
(statearr_116462[(14)] = inst_116402);

return statearr_116462;
})();
if(cljs.core.truth_(inst_116403)){
var statearr_116463_116486 = state_116438__$1;
(statearr_116463_116486[(1)] = (9));

} else {
var statearr_116464_116487 = state_116438__$1;
(statearr_116464_116487[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____0 = (function (){
var statearr_116465 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116465[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__);

(statearr_116465[(1)] = (1));

return statearr_116465;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____1 = (function (state_116438){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116438);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116466){if((e116466 instanceof Object)){
var ex__109974__auto__ = e116466;
var statearr_116467_116488 = state_116438;
(statearr_116467_116488[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116438);

return cljs.core.cst$kw$recur;
} else {
throw e116466;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116489 = state_116438;
state_116438 = G__116489;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__ = function(state_116438){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____1.call(this,state_116438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_116468 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116468[(6)] = c__110077__auto__);

return statearr_116468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4131__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__116490_116500 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__116491_116501 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116490_116500,G__116491_116501) : object_cache.call(null,G__116490_116500,G__116491_116501));

var G__116492 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__116493 = ((function (G__116492,object_cache){
return (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,((function (G__116492,object_cache){
return (function (){
var G__116494 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__116495 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116494,G__116495) : object_cache.call(null,G__116494,G__116495));
});})(G__116492,object_cache))
);
});})(G__116492,object_cache))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116492,G__116493) : object_cache.call(null,G__116492,G__116493));
} else {
var G__116496 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__116497 = ((function (G__116496,object_cache){
return (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,((function (G__116496,object_cache){
return (function (){
var G__116498 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__116499 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116498,G__116499) : object_cache.call(null,G__116498,G__116499));
});})(G__116496,object_cache))
);
});})(G__116496,object_cache))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116496,G__116497) : object_cache.call(null,G__116496,G__116497));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_116519){
var state_val_116520 = (state_116519[(1)]);
if((state_val_116520 === (1))){
var state_116519__$1 = state_116519;
var statearr_116521_116534 = state_116519__$1;
(statearr_116521_116534[(2)] = null);

(statearr_116521_116534[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116520 === (2))){
var inst_116517 = (state_116519[(2)]);
var state_116519__$1 = state_116519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116519__$1,inst_116517);
} else {
if((state_val_116520 === (3))){
var inst_116502 = (state_116519[(2)]);
var state_116519__$1 = state_116519;
var statearr_116522_116535 = state_116519__$1;
(statearr_116522_116535[(2)] = inst_116502);


cljs.core.async.impl.ioc_helpers.process_exception(state_116519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116520 === (4))){
var inst_116506 = (state_116519[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116519,(3),Error,null,(2));
var inst_116506__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_116519__$1 = (function (){var statearr_116523 = state_116519;
(statearr_116523[(7)] = inst_116506__$1);

return statearr_116523;
})();
if(cljs.core.truth_(inst_116506__$1)){
var statearr_116524_116536 = state_116519__$1;
(statearr_116524_116536[(1)] = (5));

} else {
var statearr_116525_116537 = state_116519__$1;
(statearr_116525_116537[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116520 === (5))){
var inst_116506 = (state_116519[(7)]);
var inst_116508 = fluree.db.storage.core.serde(conn);
var state_116519__$1 = (function (){var statearr_116526 = state_116519;
(statearr_116526[(8)] = inst_116508);

return statearr_116526;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116519__$1,(8),inst_116506);
} else {
if((state_val_116520 === (6))){
var state_116519__$1 = state_116519;
var statearr_116527_116538 = state_116519__$1;
(statearr_116527_116538[(2)] = null);

(statearr_116527_116538[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116520 === (7))){
var inst_116515 = (state_116519[(2)]);
var state_116519__$1 = state_116519;
var statearr_116528_116539 = state_116519__$1;
(statearr_116528_116539[(2)] = inst_116515);


cljs.core.async.impl.ioc_helpers.process_exception(state_116519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116520 === (8))){
var inst_116508 = (state_116519[(8)]);
var inst_116510 = (state_116519[(2)]);
var inst_116511 = fluree.db.util.async.throw_err(inst_116510);
var inst_116512 = fluree.db.serde.protocol._deserialize_branch(inst_116508,inst_116511);
var state_116519__$1 = state_116519;
var statearr_116529_116540 = state_116519__$1;
(statearr_116529_116540[(2)] = inst_116512);

(statearr_116529_116540[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__109971__auto____0 = (function (){
var statearr_116530 = [null,null,null,null,null,null,null,null,null];
(statearr_116530[(0)] = fluree$db$storage$core$read_branch_$_state_machine__109971__auto__);

(statearr_116530[(1)] = (1));

return statearr_116530;
});
var fluree$db$storage$core$read_branch_$_state_machine__109971__auto____1 = (function (state_116519){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116519);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116531){if((e116531 instanceof Object)){
var ex__109974__auto__ = e116531;
var statearr_116532_116541 = state_116519;
(statearr_116532_116541[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116519);

return cljs.core.cst$kw$recur;
} else {
throw e116531;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116542 = state_116519;
state_116519 = G__116542;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__109971__auto__ = function(state_116519){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__109971__auto____1.call(this,state_116519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_116533 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116533[(6)] = c__110077__auto__);

return statearr_116533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___116677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___116677,return_ch){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___116677,return_ch){
return (function (state_116629){
var state_val_116630 = (state_116629[(1)]);
if((state_val_116630 === (7))){
var state_116629__$1 = state_116629;
var statearr_116631_116678 = state_116629__$1;
(statearr_116631_116678[(2)] = null);

(statearr_116631_116678[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (20))){
var inst_116593 = (state_116629[(7)]);
var inst_116593__$1 = (state_116629[(2)]);
var inst_116594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116593__$1,cljs.core.cst$kw$children);
var inst_116595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116593__$1,cljs.core.cst$kw$rhs);
var inst_116597 = (config == null);
var inst_116598 = cljs.core.not(inst_116597);
var state_116629__$1 = (function (){var statearr_116632 = state_116629;
(statearr_116632[(7)] = inst_116593__$1);

(statearr_116632[(8)] = inst_116595);

(statearr_116632[(9)] = inst_116594);

return statearr_116632;
})();
if(inst_116598){
var statearr_116633_116679 = state_116629__$1;
(statearr_116633_116679[(1)] = (21));

} else {
var statearr_116634_116680 = state_116629__$1;
(statearr_116634_116680[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (27))){
var inst_116613 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_116629__$1 = state_116629;
var statearr_116635_116681 = state_116629__$1;
(statearr_116635_116681[(2)] = inst_116613);

(statearr_116635_116681[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (1))){
var state_116629__$1 = state_116629;
var statearr_116636_116682 = state_116629__$1;
(statearr_116636_116682[(2)] = null);

(statearr_116636_116682[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (24))){
var state_116629__$1 = state_116629;
var statearr_116637_116683 = state_116629__$1;
(statearr_116637_116683[(2)] = true);

(statearr_116637_116683[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116629,(3),java.lang.Exception,null,(2));
var inst_116552 = fluree.db.storage.core.read_branch(conn,key);
var state_116629__$1 = state_116629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116629__$1,(5),inst_116552);
} else {
if((state_val_116630 === (15))){
var state_116629__$1 = state_116629;
var statearr_116638_116684 = state_116629__$1;
(statearr_116638_116684[(2)] = true);

(statearr_116638_116684[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (21))){
var inst_116600 = config.cljs$lang$protocol_mask$partition0$;
var inst_116601 = (inst_116600 & (64));
var inst_116602 = config.cljs$core$ISeq$;
var inst_116603 = (cljs.core.PROTOCOL_SENTINEL === inst_116602);
var inst_116604 = ((inst_116601) || (inst_116603));
var state_116629__$1 = state_116629;
if(cljs.core.truth_(inst_116604)){
var statearr_116639_116685 = state_116629__$1;
(statearr_116639_116685[(1)] = (24));

} else {
var statearr_116640_116686 = state_116629__$1;
(statearr_116640_116686[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (13))){
var state_116629__$1 = state_116629;
var statearr_116641_116687 = state_116629__$1;
(statearr_116641_116687[(2)] = false);

(statearr_116641_116687[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (22))){
var state_116629__$1 = state_116629;
var statearr_116642_116688 = state_116629__$1;
(statearr_116642_116688[(2)] = false);

(statearr_116642_116688[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (29))){
var inst_116572 = (state_116629[(10)]);
var inst_116593 = (state_116629[(7)]);
var inst_116595 = (state_116629[(8)]);
var inst_116594 = (state_116629[(9)]);
var inst_116555 = (state_116629[(11)]);
var inst_116616 = (state_116629[(2)]);
var inst_116617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116616,cljs.core.cst$kw$comparator);
var inst_116619 = (function (){var data = inst_116555;
var _ = inst_116572;
var map__116550 = inst_116593;
var children = inst_116594;
var rhs = inst_116595;
var map__116551 = inst_116616;
var comparator = inst_116617;
return ((function (data,_,map__116550,children,rhs,map__116551,comparator,inst_116572,inst_116593,inst_116595,inst_116594,inst_116555,inst_116616,inst_116617,state_val_116630,c__110077__auto___116677,return_ch){
return (function (idx,p__116618){
var map__116643 = p__116618;
var map__116643__$1 = (((((!((map__116643 == null))))?(((((map__116643.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116643.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__116643):map__116643);
var child = map__116643__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116643__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116643__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116643__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116643__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116643__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4120__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (idx === (0));
} else {
return and__4120__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
;})(data,_,map__116550,children,rhs,map__116551,comparator,inst_116572,inst_116593,inst_116595,inst_116594,inst_116555,inst_116616,inst_116617,state_val_116630,c__110077__auto___116677,return_ch))
})();
var inst_116620 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_116619,inst_116594);
var inst_116621 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_116620);
var inst_116622 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_116621,inst_116620);
var inst_116623 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_116617,inst_116622);
var inst_116624 = fluree.db.index.__GT_IndexNode(block,t,inst_116595,inst_116623,config,leftmost_QMARK_);
var inst_116625 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116624);
var state_116629__$1 = state_116629;
var statearr_116645_116689 = state_116629__$1;
(statearr_116645_116689[(2)] = inst_116625);


cljs.core.async.impl.ioc_helpers.process_exception(state_116629__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (6))){
var inst_116558 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_116559 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116560 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_116561 = cljs.core.PersistentHashMap.fromArrays(inst_116559,inst_116560);
var inst_116562 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116558,inst_116561);
var inst_116563 = (function(){throw inst_116562})();
var state_116629__$1 = state_116629;
var statearr_116646_116690 = state_116629__$1;
(statearr_116646_116690[(2)] = inst_116563);

(statearr_116646_116690[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (28))){
var state_116629__$1 = state_116629;
var statearr_116647_116691 = state_116629__$1;
(statearr_116647_116691[(2)] = config);

(statearr_116647_116691[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (25))){
var state_116629__$1 = state_116629;
var statearr_116648_116692 = state_116629__$1;
(statearr_116648_116692[(2)] = false);

(statearr_116648_116692[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (17))){
var inst_116585 = (state_116629[(2)]);
var state_116629__$1 = state_116629;
var statearr_116649_116693 = state_116629__$1;
(statearr_116649_116693[(2)] = inst_116585);

(statearr_116649_116693[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (3))){
var inst_116543 = (state_116629[(2)]);
var inst_116544 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_116545 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116543);
var inst_116546 = cljs.core.async.close_BANG_(return_ch);
var state_116629__$1 = (function (){var statearr_116650 = state_116629;
(statearr_116650[(12)] = inst_116545);

(statearr_116650[(13)] = inst_116544);

return statearr_116650;
})();
var statearr_116651_116694 = state_116629__$1;
(statearr_116651_116694[(2)] = inst_116546);


cljs.core.async.impl.ioc_helpers.process_exception(state_116629__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (12))){
var inst_116555 = (state_116629[(11)]);
var inst_116577 = inst_116555.cljs$lang$protocol_mask$partition0$;
var inst_116578 = (inst_116577 & (64));
var inst_116579 = inst_116555.cljs$core$ISeq$;
var inst_116580 = (cljs.core.PROTOCOL_SENTINEL === inst_116579);
var inst_116581 = ((inst_116578) || (inst_116580));
var state_116629__$1 = state_116629;
if(cljs.core.truth_(inst_116581)){
var statearr_116652_116695 = state_116629__$1;
(statearr_116652_116695[(1)] = (15));

} else {
var statearr_116653_116696 = state_116629__$1;
(statearr_116653_116696[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (2))){
var inst_116627 = (state_116629[(2)]);
var state_116629__$1 = state_116629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116629__$1,inst_116627);
} else {
if((state_val_116630 === (23))){
var inst_116611 = (state_116629[(2)]);
var state_116629__$1 = state_116629;
if(cljs.core.truth_(inst_116611)){
var statearr_116654_116697 = state_116629__$1;
(statearr_116654_116697[(1)] = (27));

} else {
var statearr_116655_116698 = state_116629__$1;
(statearr_116655_116698[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (19))){
var inst_116555 = (state_116629[(11)]);
var state_116629__$1 = state_116629;
var statearr_116656_116699 = state_116629__$1;
(statearr_116656_116699[(2)] = inst_116555);

(statearr_116656_116699[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (11))){
var inst_116555 = (state_116629[(11)]);
var inst_116572 = (state_116629[(2)]);
var inst_116574 = (inst_116555 == null);
var inst_116575 = cljs.core.not(inst_116574);
var state_116629__$1 = (function (){var statearr_116657 = state_116629;
(statearr_116657[(10)] = inst_116572);

return statearr_116657;
})();
if(inst_116575){
var statearr_116658_116700 = state_116629__$1;
(statearr_116658_116700[(1)] = (12));

} else {
var statearr_116659_116701 = state_116629__$1;
(statearr_116659_116701[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (9))){
var inst_116555 = (state_116629[(11)]);
var inst_116569 = (function(){throw inst_116555})();
var state_116629__$1 = state_116629;
var statearr_116660_116702 = state_116629__$1;
(statearr_116660_116702[(2)] = inst_116569);

(statearr_116660_116702[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (5))){
var inst_116555 = (state_116629[(11)]);
var inst_116554 = (state_116629[(2)]);
var inst_116555__$1 = fluree.db.util.async.throw_err(inst_116554);
var inst_116556 = (inst_116555__$1 == null);
var state_116629__$1 = (function (){var statearr_116661 = state_116629;
(statearr_116661[(11)] = inst_116555__$1);

return statearr_116661;
})();
if(cljs.core.truth_(inst_116556)){
var statearr_116662_116703 = state_116629__$1;
(statearr_116662_116703[(1)] = (6));

} else {
var statearr_116663_116704 = state_116629__$1;
(statearr_116663_116704[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (14))){
var inst_116588 = (state_116629[(2)]);
var state_116629__$1 = state_116629;
if(cljs.core.truth_(inst_116588)){
var statearr_116664_116705 = state_116629__$1;
(statearr_116664_116705[(1)] = (18));

} else {
var statearr_116665_116706 = state_116629__$1;
(statearr_116665_116706[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (26))){
var inst_116608 = (state_116629[(2)]);
var state_116629__$1 = state_116629;
var statearr_116666_116707 = state_116629__$1;
(statearr_116666_116707[(2)] = inst_116608);

(statearr_116666_116707[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (16))){
var state_116629__$1 = state_116629;
var statearr_116667_116708 = state_116629__$1;
(statearr_116667_116708[(2)] = false);

(statearr_116667_116708[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (10))){
var state_116629__$1 = state_116629;
var statearr_116668_116709 = state_116629__$1;
(statearr_116668_116709[(2)] = null);

(statearr_116668_116709[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (18))){
var inst_116555 = (state_116629[(11)]);
var inst_116590 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_116555);
var state_116629__$1 = state_116629;
var statearr_116669_116710 = state_116629__$1;
(statearr_116669_116710[(2)] = inst_116590);

(statearr_116669_116710[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116630 === (8))){
var inst_116555 = (state_116629[(11)]);
var inst_116566 = (state_116629[(2)]);
var inst_116567 = fluree.db.util.core.exception_QMARK_(inst_116555);
var state_116629__$1 = (function (){var statearr_116670 = state_116629;
(statearr_116670[(14)] = inst_116566);

return statearr_116670;
})();
if(inst_116567){
var statearr_116671_116711 = state_116629__$1;
(statearr_116671_116711[(1)] = (9));

} else {
var statearr_116672_116712 = state_116629__$1;
(statearr_116672_116712[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___116677,return_ch))
;
return ((function (switch__109970__auto__,c__110077__auto___116677,return_ch){
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____0 = (function (){
var statearr_116673 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116673[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__);

(statearr_116673[(1)] = (1));

return statearr_116673;
});
var fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____1 = (function (state_116629){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116629);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116674){if((e116674 instanceof Object)){
var ex__109974__auto__ = e116674;
var statearr_116675_116713 = state_116629;
(statearr_116675_116713[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116629);

return cljs.core.cst$kw$recur;
} else {
throw e116674;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116714 = state_116629;
state_116629 = G__116714;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__ = function(state_116629){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____1.call(this,state_116629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__109971__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___116677,return_ch))
})();
var state__110079__auto__ = (function (){var statearr_116676 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116676[(6)] = c__110077__auto___116677);

return statearr_116676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___116677,return_ch))
);


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_116732){
var state_val_116733 = (state_116732[(1)]);
if((state_val_116733 === (1))){
var state_116732__$1 = state_116732;
var statearr_116734_116747 = state_116732__$1;
(statearr_116734_116747[(2)] = null);

(statearr_116734_116747[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116733 === (2))){
var inst_116730 = (state_116732[(2)]);
var state_116732__$1 = state_116732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116732__$1,inst_116730);
} else {
if((state_val_116733 === (3))){
var inst_116715 = (state_116732[(2)]);
var state_116732__$1 = state_116732;
var statearr_116735_116748 = state_116732__$1;
(statearr_116735_116748[(2)] = inst_116715);


cljs.core.async.impl.ioc_helpers.process_exception(state_116732__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116733 === (4))){
var inst_116719 = (state_116732[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116732,(3),Error,null,(2));
var inst_116719__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_116732__$1 = (function (){var statearr_116736 = state_116732;
(statearr_116736[(7)] = inst_116719__$1);

return statearr_116736;
})();
if(cljs.core.truth_(inst_116719__$1)){
var statearr_116737_116749 = state_116732__$1;
(statearr_116737_116749[(1)] = (5));

} else {
var statearr_116738_116750 = state_116732__$1;
(statearr_116738_116750[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116733 === (5))){
var inst_116719 = (state_116732[(7)]);
var inst_116721 = fluree.db.storage.core.serde(conn);
var state_116732__$1 = (function (){var statearr_116739 = state_116732;
(statearr_116739[(8)] = inst_116721);

return statearr_116739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116732__$1,(8),inst_116719);
} else {
if((state_val_116733 === (6))){
var state_116732__$1 = state_116732;
var statearr_116740_116751 = state_116732__$1;
(statearr_116740_116751[(2)] = null);

(statearr_116740_116751[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116733 === (7))){
var inst_116728 = (state_116732[(2)]);
var state_116732__$1 = state_116732;
var statearr_116741_116752 = state_116732__$1;
(statearr_116741_116752[(2)] = inst_116728);


cljs.core.async.impl.ioc_helpers.process_exception(state_116732__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116733 === (8))){
var inst_116721 = (state_116732[(8)]);
var inst_116723 = (state_116732[(2)]);
var inst_116724 = fluree.db.util.async.throw_err(inst_116723);
var inst_116725 = fluree.db.serde.protocol._deserialize_leaf(inst_116721,inst_116724);
var state_116732__$1 = state_116732;
var statearr_116742_116753 = state_116732__$1;
(statearr_116742_116753[(2)] = inst_116725);

(statearr_116742_116753[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____0 = (function (){
var statearr_116743 = [null,null,null,null,null,null,null,null,null];
(statearr_116743[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__);

(statearr_116743[(1)] = (1));

return statearr_116743;
});
var fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____1 = (function (state_116732){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116732);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116744){if((e116744 instanceof Object)){
var ex__109974__auto__ = e116744;
var statearr_116745_116754 = state_116732;
(statearr_116745_116754[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116732);

return cljs.core.cst$kw$recur;
} else {
throw e116744;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116755 = state_116732;
state_116732 = G__116755;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__ = function(state_116732){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____1.call(this,state_116732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_116746 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116746[(6)] = c__110077__auto__);

return statearr_116746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___116882 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___116882,return_ch){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___116882,return_ch){
return (function (state_116836){
var state_val_116837 = (state_116836[(1)]);
if((state_val_116837 === (7))){
var state_116836__$1 = state_116836;
var statearr_116838_116883 = state_116836__$1;
(statearr_116838_116883[(2)] = null);

(statearr_116838_116883[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (20))){
var inst_116805 = (state_116836[(2)]);
var inst_116806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116805,cljs.core.cst$kw$flakes);
var inst_116807 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116805,cljs.core.cst$kw$his);
var inst_116809 = (config == null);
var inst_116810 = cljs.core.not(inst_116809);
var state_116836__$1 = (function (){var statearr_116839 = state_116836;
(statearr_116839[(7)] = inst_116807);

(statearr_116839[(8)] = inst_116806);

return statearr_116839;
})();
if(inst_116810){
var statearr_116840_116884 = state_116836__$1;
(statearr_116840_116884[(1)] = (21));

} else {
var statearr_116841_116885 = state_116836__$1;
(statearr_116841_116885[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (27))){
var inst_116825 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,config);
var state_116836__$1 = state_116836;
var statearr_116842_116886 = state_116836__$1;
(statearr_116842_116886[(2)] = inst_116825);

(statearr_116842_116886[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (1))){
var state_116836__$1 = state_116836;
var statearr_116843_116887 = state_116836__$1;
(statearr_116843_116887[(2)] = null);

(statearr_116843_116887[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (24))){
var state_116836__$1 = state_116836;
var statearr_116844_116888 = state_116836__$1;
(statearr_116844_116888[(2)] = true);

(statearr_116844_116888[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116836,(3),java.lang.Exception,null,(2));
var inst_116765 = fluree.db.storage.core.read_leaf(conn,key);
var state_116836__$1 = state_116836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116836__$1,(5),inst_116765);
} else {
if((state_val_116837 === (15))){
var state_116836__$1 = state_116836;
var statearr_116845_116889 = state_116836__$1;
(statearr_116845_116889[(2)] = true);

(statearr_116845_116889[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (21))){
var inst_116812 = config.cljs$lang$protocol_mask$partition0$;
var inst_116813 = (inst_116812 & (64));
var inst_116814 = config.cljs$core$ISeq$;
var inst_116815 = (cljs.core.PROTOCOL_SENTINEL === inst_116814);
var inst_116816 = ((inst_116813) || (inst_116815));
var state_116836__$1 = state_116836;
if(cljs.core.truth_(inst_116816)){
var statearr_116846_116890 = state_116836__$1;
(statearr_116846_116890[(1)] = (24));

} else {
var statearr_116847_116891 = state_116836__$1;
(statearr_116847_116891[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (13))){
var state_116836__$1 = state_116836;
var statearr_116848_116892 = state_116836__$1;
(statearr_116848_116892[(2)] = false);

(statearr_116848_116892[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (22))){
var state_116836__$1 = state_116836;
var statearr_116849_116893 = state_116836__$1;
(statearr_116849_116893[(2)] = false);

(statearr_116849_116893[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (29))){
var inst_116806 = (state_116836[(8)]);
var inst_116828 = (state_116836[(2)]);
var inst_116829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_116828,cljs.core.cst$kw$comparator);
var inst_116830 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_116829,inst_116806);
var inst_116831 = fluree.db.index.data_node(block,t,inst_116830,rhs,config);
var inst_116832 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116831);
var state_116836__$1 = state_116836;
var statearr_116850_116894 = state_116836__$1;
(statearr_116850_116894[(2)] = inst_116832);


cljs.core.async.impl.ioc_helpers.process_exception(state_116836__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (6))){
var inst_116770 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_116771 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_116772 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_116773 = cljs.core.PersistentHashMap.fromArrays(inst_116771,inst_116772);
var inst_116774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_116770,inst_116773);
var inst_116775 = (function(){throw inst_116774})();
var state_116836__$1 = state_116836;
var statearr_116851_116895 = state_116836__$1;
(statearr_116851_116895[(2)] = inst_116775);

(statearr_116851_116895[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (28))){
var state_116836__$1 = state_116836;
var statearr_116852_116896 = state_116836__$1;
(statearr_116852_116896[(2)] = config);

(statearr_116852_116896[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (25))){
var state_116836__$1 = state_116836;
var statearr_116853_116897 = state_116836__$1;
(statearr_116853_116897[(2)] = false);

(statearr_116853_116897[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (17))){
var inst_116797 = (state_116836[(2)]);
var state_116836__$1 = state_116836;
var statearr_116854_116898 = state_116836__$1;
(statearr_116854_116898[(2)] = inst_116797);

(statearr_116854_116898[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (3))){
var inst_116756 = (state_116836[(2)]);
var inst_116757 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_116758 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_116756);
var inst_116759 = cljs.core.async.close_BANG_(return_ch);
var state_116836__$1 = (function (){var statearr_116855 = state_116836;
(statearr_116855[(9)] = inst_116757);

(statearr_116855[(10)] = inst_116758);

return statearr_116855;
})();
var statearr_116856_116899 = state_116836__$1;
(statearr_116856_116899[(2)] = inst_116759);


cljs.core.async.impl.ioc_helpers.process_exception(state_116836__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (12))){
var inst_116767 = (state_116836[(11)]);
var inst_116789 = inst_116767.cljs$lang$protocol_mask$partition0$;
var inst_116790 = (inst_116789 & (64));
var inst_116791 = inst_116767.cljs$core$ISeq$;
var inst_116792 = (cljs.core.PROTOCOL_SENTINEL === inst_116791);
var inst_116793 = ((inst_116790) || (inst_116792));
var state_116836__$1 = state_116836;
if(cljs.core.truth_(inst_116793)){
var statearr_116857_116900 = state_116836__$1;
(statearr_116857_116900[(1)] = (15));

} else {
var statearr_116858_116901 = state_116836__$1;
(statearr_116858_116901[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (2))){
var inst_116834 = (state_116836[(2)]);
var state_116836__$1 = state_116836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116836__$1,inst_116834);
} else {
if((state_val_116837 === (23))){
var inst_116823 = (state_116836[(2)]);
var state_116836__$1 = state_116836;
if(cljs.core.truth_(inst_116823)){
var statearr_116859_116902 = state_116836__$1;
(statearr_116859_116902[(1)] = (27));

} else {
var statearr_116860_116903 = state_116836__$1;
(statearr_116860_116903[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (19))){
var inst_116767 = (state_116836[(11)]);
var state_116836__$1 = state_116836;
var statearr_116861_116904 = state_116836__$1;
(statearr_116861_116904[(2)] = inst_116767);

(statearr_116861_116904[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (11))){
var inst_116767 = (state_116836[(11)]);
var inst_116784 = (state_116836[(2)]);
var inst_116786 = (inst_116767 == null);
var inst_116787 = cljs.core.not(inst_116786);
var state_116836__$1 = (function (){var statearr_116862 = state_116836;
(statearr_116862[(12)] = inst_116784);

return statearr_116862;
})();
if(inst_116787){
var statearr_116863_116905 = state_116836__$1;
(statearr_116863_116905[(1)] = (12));

} else {
var statearr_116864_116906 = state_116836__$1;
(statearr_116864_116906[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (9))){
var inst_116767 = (state_116836[(11)]);
var inst_116781 = (function(){throw inst_116767})();
var state_116836__$1 = state_116836;
var statearr_116865_116907 = state_116836__$1;
(statearr_116865_116907[(2)] = inst_116781);

(statearr_116865_116907[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (5))){
var inst_116767 = (state_116836[(11)]);
var inst_116767__$1 = (state_116836[(2)]);
var inst_116768 = (inst_116767__$1 == null);
var state_116836__$1 = (function (){var statearr_116866 = state_116836;
(statearr_116866[(11)] = inst_116767__$1);

return statearr_116866;
})();
if(cljs.core.truth_(inst_116768)){
var statearr_116867_116908 = state_116836__$1;
(statearr_116867_116908[(1)] = (6));

} else {
var statearr_116868_116909 = state_116836__$1;
(statearr_116868_116909[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (14))){
var inst_116800 = (state_116836[(2)]);
var state_116836__$1 = state_116836;
if(cljs.core.truth_(inst_116800)){
var statearr_116869_116910 = state_116836__$1;
(statearr_116869_116910[(1)] = (18));

} else {
var statearr_116870_116911 = state_116836__$1;
(statearr_116870_116911[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (26))){
var inst_116820 = (state_116836[(2)]);
var state_116836__$1 = state_116836;
var statearr_116871_116912 = state_116836__$1;
(statearr_116871_116912[(2)] = inst_116820);

(statearr_116871_116912[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (16))){
var state_116836__$1 = state_116836;
var statearr_116872_116913 = state_116836__$1;
(statearr_116872_116913[(2)] = false);

(statearr_116872_116913[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (10))){
var state_116836__$1 = state_116836;
var statearr_116873_116914 = state_116836__$1;
(statearr_116873_116914[(2)] = null);

(statearr_116873_116914[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (18))){
var inst_116767 = (state_116836[(11)]);
var inst_116802 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_116767);
var state_116836__$1 = state_116836;
var statearr_116874_116915 = state_116836__$1;
(statearr_116874_116915[(2)] = inst_116802);

(statearr_116874_116915[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116837 === (8))){
var inst_116767 = (state_116836[(11)]);
var inst_116778 = (state_116836[(2)]);
var inst_116779 = fluree.db.util.core.exception_QMARK_(inst_116767);
var state_116836__$1 = (function (){var statearr_116875 = state_116836;
(statearr_116875[(13)] = inst_116778);

return statearr_116875;
})();
if(inst_116779){
var statearr_116876_116916 = state_116836__$1;
(statearr_116876_116916[(1)] = (9));

} else {
var statearr_116877_116917 = state_116836__$1;
(statearr_116877_116917[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___116882,return_ch))
;
return ((function (switch__109970__auto__,c__110077__auto___116882,return_ch){
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____0 = (function (){
var statearr_116878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_116878[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__);

(statearr_116878[(1)] = (1));

return statearr_116878;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____1 = (function (state_116836){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116836);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e116879){if((e116879 instanceof Object)){
var ex__109974__auto__ = e116879;
var statearr_116880_116918 = state_116836;
(statearr_116880_116918[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116836);

return cljs.core.cst$kw$recur;
} else {
throw e116879;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__116919 = state_116836;
state_116836 = G__116919;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__ = function(state_116836){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____1.call(this,state_116836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___116882,return_ch))
})();
var state__110079__auto__ = (function (){var statearr_116881 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_116881[(6)] = c__110077__auto___116882);

return statearr_116881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___116882,return_ch))
);


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k116921,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__116925 = k116921;
var G__116925__$1 = (((G__116925 instanceof cljs.core.Keyword))?G__116925.fqn:null);
switch (G__116925__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k116921,else__4388__auto__);

}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__116926){
var vec__116927 = p__116926;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__116927,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__116927,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__116920){
var self__ = this;
var G__116920__$1 = this;
return (new cljs.core.RecordIter((0),G__116920__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__116930 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__116931 = ((function (G__116930,object_cache,___$1){
return (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,((function (G__116930,object_cache,___$1){
return (function (){
var G__116932 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__116933 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116932,G__116933) : object_cache.call(null,G__116932,G__116933));
});})(G__116930,object_cache,___$1))
);
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,((function (G__116930,object_cache,___$1){
return (function (){
var G__116934 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__116935 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116934,G__116935) : object_cache.call(null,G__116934,G__116935));
});})(G__116930,object_cache,___$1))
);
}
});})(G__116930,object_cache,___$1))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116930,G__116931) : object_cache.call(null,G__116930,G__116931));
}
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = ((function (history_id,object_cache,___$1){
return (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});})(history_id,object_cache,___$1))
;
var G__116936 = history_id;
var G__116937 = ((function (G__116936,history_id,object_cache,error_fn,___$1){
return (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});})(G__116936,history_id,object_cache,error_fn,___$1))
;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__116936,G__116937) : object_cache.call(null,G__116936,G__116937));
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
});

fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__116938 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__116938(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this116922,other116923){
var self__ = this;
var this116922__$1 = this;
return (((!((other116923 == null)))) && ((this116922__$1.constructor === other116923.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.conn,other116923.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.config,other116923.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.network,other116923.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.dbid,other116923.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.id,other116923.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.leaf,other116923.leaf)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.first,other116923.first)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.rhs,other116923.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.size,other116923.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.block,other116923.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.t,other116923.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.tt_id,other116923.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.leftmost_QMARK_,other116923.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.tempid,other116923.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this116922__$1.__extmap,other116923.__extmap)));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__116920){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__116939 = cljs.core.keyword_identical_QMARK_;
var expr__116940 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__116942 = cljs.core.cst$kw$conn;
var G__116943 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116942,G__116943) : pred__116939.call(null,G__116942,G__116943));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__116920,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116944 = cljs.core.cst$kw$config;
var G__116945 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116944,G__116945) : pred__116939.call(null,G__116944,G__116945));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__116920,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116946 = cljs.core.cst$kw$network;
var G__116947 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116946,G__116947) : pred__116939.call(null,G__116946,G__116947));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__116920,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116948 = cljs.core.cst$kw$dbid;
var G__116949 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116948,G__116949) : pred__116939.call(null,G__116948,G__116949));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__116920,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116950 = cljs.core.cst$kw$id;
var G__116951 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116950,G__116951) : pred__116939.call(null,G__116950,G__116951));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__116920,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116952 = cljs.core.cst$kw$leaf;
var G__116953 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116952,G__116953) : pred__116939.call(null,G__116952,G__116953));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__116920,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116954 = cljs.core.cst$kw$first;
var G__116955 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116954,G__116955) : pred__116939.call(null,G__116954,G__116955));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__116920,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116956 = cljs.core.cst$kw$rhs;
var G__116957 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116956,G__116957) : pred__116939.call(null,G__116956,G__116957));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__116920,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116958 = cljs.core.cst$kw$size;
var G__116959 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116958,G__116959) : pred__116939.call(null,G__116958,G__116959));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__116920,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116960 = cljs.core.cst$kw$block;
var G__116961 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116960,G__116961) : pred__116939.call(null,G__116960,G__116961));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__116920,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116962 = cljs.core.cst$kw$t;
var G__116963 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116962,G__116963) : pred__116939.call(null,G__116962,G__116963));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__116920,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116964 = cljs.core.cst$kw$tt_DASH_id;
var G__116965 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116964,G__116965) : pred__116939.call(null,G__116964,G__116965));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__116920,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116966 = cljs.core.cst$kw$leftmost_QMARK_;
var G__116967 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116966,G__116967) : pred__116939.call(null,G__116966,G__116967));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__116920,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__116968 = cljs.core.cst$kw$tempid;
var G__116969 = expr__116940;
return (pred__116939.cljs$core$IFn$_invoke$arity$2 ? pred__116939.cljs$core$IFn$_invoke$arity$2(G__116968,G__116969) : pred__116939.call(null,G__116968,G__116969));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__116920,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__116920),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__116920){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__116920,self__.__extmap,self__.__hash));
});

fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
});

fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true;

fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
});

fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.storage.core/UnresolvedNode");
});

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__116924){
var extmap__4424__auto__ = (function (){var G__116970 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__116924,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__116924)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__116970);
} else {
return G__116970;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__116924),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__116924),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__116972 = blank_db;
var map__116972__$1 = (((((!((map__116972 == null))))?(((((map__116972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__116972):map__116972);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116972__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116972__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116972__$1,cljs.core.cst$kw$index_DASH_configs);
var map__116973 = root_data;
var map__116973__$1 = (((((!((map__116973 == null))))?(((((map__116973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__116973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__116973):map__116973);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116973__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116973__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116973__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__116973__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__116972,map__116972__$1,network,dbid,index_configs,map__116973,map__116973__$1,block,t,ecount,stats,db_STAR_){
return (function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
});})(map__116972,map__116972__$1,network,dbid,index_configs,map__116973,map__116973__$1,block,t,ecount,stats,db_STAR_))
,db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_116994){
var state_val_116995 = (state_116994[(1)]);
if((state_val_116995 === (1))){
var state_116994__$1 = state_116994;
var statearr_116996_117009 = state_116994__$1;
(statearr_116996_117009[(2)] = null);

(statearr_116996_117009[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116995 === (2))){
var inst_116992 = (state_116994[(2)]);
var state_116994__$1 = state_116994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_116994__$1,inst_116992);
} else {
if((state_val_116995 === (3))){
var inst_116976 = (state_116994[(2)]);
var state_116994__$1 = state_116994;
var statearr_116997_117010 = state_116994__$1;
(statearr_116997_117010[(2)] = inst_116976);


cljs.core.async.impl.ioc_helpers.process_exception(state_116994__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116995 === (4))){
var inst_116981 = (state_116994[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_116994,(3),Error,null,(2));
var inst_116980 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_116981__$1 = fluree.db.storage.core.storage_read(conn,inst_116980);
var state_116994__$1 = (function (){var statearr_116998 = state_116994;
(statearr_116998[(7)] = inst_116981__$1);

return statearr_116998;
})();
if(cljs.core.truth_(inst_116981__$1)){
var statearr_116999_117011 = state_116994__$1;
(statearr_116999_117011[(1)] = (5));

} else {
var statearr_117000_117012 = state_116994__$1;
(statearr_117000_117012[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_116995 === (5))){
var inst_116981 = (state_116994[(7)]);
var inst_116983 = fluree.db.storage.core.serde(conn);
var state_116994__$1 = (function (){var statearr_117001 = state_116994;
(statearr_117001[(8)] = inst_116983);

return statearr_117001;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_116994__$1,(8),inst_116981);
} else {
if((state_val_116995 === (6))){
var state_116994__$1 = state_116994;
var statearr_117002_117013 = state_116994__$1;
(statearr_117002_117013[(2)] = null);

(statearr_117002_117013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_116995 === (7))){
var inst_116990 = (state_116994[(2)]);
var state_116994__$1 = state_116994;
var statearr_117003_117014 = state_116994__$1;
(statearr_117003_117014[(2)] = inst_116990);


cljs.core.async.impl.ioc_helpers.process_exception(state_116994__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_116995 === (8))){
var inst_116983 = (state_116994[(8)]);
var inst_116985 = (state_116994[(2)]);
var inst_116986 = fluree.db.util.async.throw_err(inst_116985);
var inst_116987 = fluree.db.serde.protocol._deserialize_garbage(inst_116983,inst_116986);
var state_116994__$1 = state_116994;
var statearr_117004_117015 = state_116994__$1;
(statearr_117004_117015[(2)] = inst_116987);

(statearr_117004_117015[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____0 = (function (){
var statearr_117005 = [null,null,null,null,null,null,null,null,null];
(statearr_117005[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__);

(statearr_117005[(1)] = (1));

return statearr_117005;
});
var fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____1 = (function (state_116994){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_116994);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117006){if((e117006 instanceof Object)){
var ex__109974__auto__ = e117006;
var statearr_117007_117016 = state_116994;
(statearr_117007_117016[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_116994);

return cljs.core.cst$kw$recur;
} else {
throw e117006;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117017 = state_116994;
state_116994 = G__117017;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__ = function(state_116994){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____1.call(this,state_116994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117008 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117008[(6)] = c__110077__auto__);

return statearr_117008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117036){
var state_val_117037 = (state_117036[(1)]);
if((state_val_117037 === (1))){
var state_117036__$1 = state_117036;
var statearr_117038_117051 = state_117036__$1;
(statearr_117038_117051[(2)] = null);

(statearr_117038_117051[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117037 === (2))){
var inst_117034 = (state_117036[(2)]);
var state_117036__$1 = state_117036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117036__$1,inst_117034);
} else {
if((state_val_117037 === (3))){
var inst_117018 = (state_117036[(2)]);
var state_117036__$1 = state_117036;
var statearr_117039_117052 = state_117036__$1;
(statearr_117039_117052[(2)] = inst_117018);


cljs.core.async.impl.ioc_helpers.process_exception(state_117036__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117037 === (4))){
var inst_117023 = (state_117036[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117036,(3),Error,null,(2));
var inst_117022 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_117023__$1 = fluree.db.storage.core.storage_read(conn,inst_117022);
var state_117036__$1 = (function (){var statearr_117040 = state_117036;
(statearr_117040[(7)] = inst_117023__$1);

return statearr_117040;
})();
if(cljs.core.truth_(inst_117023__$1)){
var statearr_117041_117053 = state_117036__$1;
(statearr_117041_117053[(1)] = (5));

} else {
var statearr_117042_117054 = state_117036__$1;
(statearr_117042_117054[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117037 === (5))){
var inst_117023 = (state_117036[(7)]);
var inst_117025 = fluree.db.storage.core.serde(conn);
var state_117036__$1 = (function (){var statearr_117043 = state_117036;
(statearr_117043[(8)] = inst_117025);

return statearr_117043;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117036__$1,(8),inst_117023);
} else {
if((state_val_117037 === (6))){
var state_117036__$1 = state_117036;
var statearr_117044_117055 = state_117036__$1;
(statearr_117044_117055[(2)] = null);

(statearr_117044_117055[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117037 === (7))){
var inst_117032 = (state_117036[(2)]);
var state_117036__$1 = state_117036;
var statearr_117045_117056 = state_117036__$1;
(statearr_117045_117056[(2)] = inst_117032);


cljs.core.async.impl.ioc_helpers.process_exception(state_117036__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117037 === (8))){
var inst_117025 = (state_117036[(8)]);
var inst_117027 = (state_117036[(2)]);
var inst_117028 = fluree.db.util.async.throw_err(inst_117027);
var inst_117029 = fluree.db.serde.protocol._deserialize_db_root(inst_117025,inst_117028);
var state_117036__$1 = state_117036;
var statearr_117046_117057 = state_117036__$1;
(statearr_117046_117057[(2)] = inst_117029);

(statearr_117046_117057[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____0 = (function (){
var statearr_117047 = [null,null,null,null,null,null,null,null,null];
(statearr_117047[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__);

(statearr_117047[(1)] = (1));

return statearr_117047;
});
var fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____1 = (function (state_117036){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117036);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117048){if((e117048 instanceof Object)){
var ex__109974__auto__ = e117048;
var statearr_117049_117058 = state_117036;
(statearr_117049_117058[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117036);

return cljs.core.cst$kw$recur;
} else {
throw e117048;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117059 = state_117036;
state_117036 = G__117059;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__ = function(state_117036){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____1.call(this,state_117036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__109971__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117050 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117050[(6)] = c__110077__auto__);

return statearr_117050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117092){
var state_val_117093 = (state_117092[(1)]);
if((state_val_117093 === (7))){
var inst_117064 = (state_117092[(7)]);
var inst_117074 = (state_117092[(2)]);
var state_117092__$1 = (function (){var statearr_117094 = state_117092;
(statearr_117094[(8)] = inst_117074);

return statearr_117094;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117092__$1,(8),inst_117064);
} else {
if((state_val_117093 === (1))){
var state_117092__$1 = state_117092;
var statearr_117095_117109 = state_117092__$1;
(statearr_117095_117109[(2)] = null);

(statearr_117095_117109[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (4))){
var inst_117064 = (state_117092[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117092,(3),Error,null,(2));
var inst_117064__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_117092__$1 = (function (){var statearr_117096 = state_117092;
(statearr_117096[(7)] = inst_117064__$1);

return statearr_117096;
})();
if(cljs.core.truth_(inst_117064__$1)){
var statearr_117097_117110 = state_117092__$1;
(statearr_117097_117110[(1)] = (5));

} else {
var statearr_117098_117111 = state_117092__$1;
(statearr_117098_117111[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (6))){
var inst_117067 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_117068 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117069 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_117070 = cljs.core.PersistentHashMap.fromArrays(inst_117068,inst_117069);
var inst_117071 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117067,inst_117070);
var inst_117072 = (function(){throw inst_117071})();
var state_117092__$1 = state_117092;
var statearr_117099_117112 = state_117092__$1;
(statearr_117099_117112[(2)] = inst_117072);

(statearr_117099_117112[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (3))){
var inst_117060 = (state_117092[(2)]);
var state_117092__$1 = state_117092;
var statearr_117100_117113 = state_117092__$1;
(statearr_117100_117113[(2)] = inst_117060);


cljs.core.async.impl.ioc_helpers.process_exception(state_117092__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (2))){
var inst_117090 = (state_117092[(2)]);
var state_117092__$1 = state_117092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117092__$1,inst_117090);
} else {
if((state_val_117093 === (9))){
var inst_117078 = (state_117092[(9)]);
var inst_117083 = (state_117092[(10)]);
var inst_117081 = (state_117092[(2)]);
var inst_117082 = fluree.db.util.async.throw_err(inst_117081);
var inst_117083__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_117078,cljs.core.cst$kw$schema,inst_117082);
var inst_117084 = fluree.db.query.schema.setting_map(inst_117083__$1);
var state_117092__$1 = (function (){var statearr_117101 = state_117092;
(statearr_117101[(10)] = inst_117083__$1);

return statearr_117101;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117092__$1,(10),inst_117084);
} else {
if((state_val_117093 === (5))){
var state_117092__$1 = state_117092;
var statearr_117102_117114 = state_117092__$1;
(statearr_117102_117114[(2)] = null);

(statearr_117102_117114[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (10))){
var inst_117083 = (state_117092[(10)]);
var inst_117086 = (state_117092[(2)]);
var inst_117087 = fluree.db.util.async.throw_err(inst_117086);
var inst_117088 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_117083,cljs.core.cst$kw$settings,inst_117087);
var state_117092__$1 = state_117092;
var statearr_117103_117115 = state_117092__$1;
(statearr_117103_117115[(2)] = inst_117088);


cljs.core.async.impl.ioc_helpers.process_exception(state_117092__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117093 === (8))){
var inst_117078 = (state_117092[(9)]);
var inst_117076 = (state_117092[(2)]);
var inst_117077 = fluree.db.util.async.throw_err(inst_117076);
var inst_117078__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_117077);
var inst_117079 = fluree.db.query.schema.schema_map(inst_117078__$1);
var state_117092__$1 = (function (){var statearr_117104 = state_117092;
(statearr_117104[(9)] = inst_117078__$1);

return statearr_117104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117092__$1,(9),inst_117079);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__109971__auto____0 = (function (){
var statearr_117105 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_117105[(0)] = fluree$db$storage$core$reify_db_$_state_machine__109971__auto__);

(statearr_117105[(1)] = (1));

return statearr_117105;
});
var fluree$db$storage$core$reify_db_$_state_machine__109971__auto____1 = (function (state_117092){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117092);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117106){if((e117106 instanceof Object)){
var ex__109974__auto__ = e117106;
var statearr_117107_117116 = state_117092;
(statearr_117107_117116[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117092);

return cljs.core.cst$kw$recur;
} else {
throw e117106;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117117 = state_117092;
state_117092 = G__117117;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__109971__auto__ = function(state_117092){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__109971__auto____1.call(this,state_117092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__109971__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__109971__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117108 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117108[(6)] = c__110077__auto__);

return statearr_117108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__117119 = arguments.length;
switch (G__117119) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
});

fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117165){
var state_val_117166 = (state_117165[(1)]);
if((state_val_117166 === (7))){
var inst_117131 = (state_117165[(2)]);
var inst_117132 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_117133 = cljs.core.PersistentVector.EMPTY;
var inst_117134 = start;
var inst_117135 = inst_117133;
var state_117165__$1 = (function (){var statearr_117167 = state_117165;
(statearr_117167[(7)] = inst_117135);

(statearr_117167[(8)] = inst_117131);

(statearr_117167[(9)] = inst_117132);

(statearr_117167[(10)] = inst_117134);

return statearr_117167;
})();
var statearr_117168_117196 = state_117165__$1;
(statearr_117168_117196[(2)] = null);

(statearr_117168_117196[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (1))){
var state_117165__$1 = state_117165;
var statearr_117169_117197 = state_117165__$1;
(statearr_117169_117197[(2)] = null);

(statearr_117169_117197[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117165,(3),Error,null,(2));
var inst_117124 = (end >= start);
var state_117165__$1 = state_117165;
if(cljs.core.truth_(inst_117124)){
var statearr_117170_117198 = state_117165__$1;
(statearr_117170_117198[(1)] = (5));

} else {
var statearr_117171_117199 = state_117165__$1;
(statearr_117171_117199[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (15))){
var state_117165__$1 = state_117165;
var statearr_117172_117200 = state_117165__$1;
(statearr_117172_117200[(1)] = (17));



return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (13))){
var inst_117159 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
var statearr_117174_117201 = state_117165__$1;
(statearr_117174_117201[(2)] = inst_117159);

(statearr_117174_117201[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (6))){
var inst_117127 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_117128 = (new Error(inst_117127));
var inst_117129 = (function(){throw inst_117128})();
var state_117165__$1 = state_117165;
var statearr_117175_117202 = state_117165__$1;
(statearr_117175_117202[(2)] = inst_117129);

(statearr_117175_117202[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (17))){
var inst_117135 = (state_117165[(7)]);
var inst_117139 = (state_117165[(11)]);
var inst_117134 = (state_117165[(10)]);
var inst_117150 = (inst_117134 + (1));
var inst_117151 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_117135,inst_117139);
var inst_117134__$1 = inst_117150;
var inst_117135__$1 = inst_117151;
var state_117165__$1 = (function (){var statearr_117176 = state_117165;
(statearr_117176[(7)] = inst_117135__$1);

(statearr_117176[(10)] = inst_117134__$1);

return statearr_117176;
})();
var statearr_117177_117203 = state_117165__$1;
(statearr_117177_117203[(2)] = null);

(statearr_117177_117203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (3))){
var inst_117120 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
var statearr_117178_117204 = state_117165__$1;
(statearr_117178_117204[(2)] = inst_117120);


cljs.core.async.impl.ioc_helpers.process_exception(state_117165__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (12))){
var inst_117134 = (state_117165[(10)]);
var inst_117145 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_117134,end);
var state_117165__$1 = state_117165;
if(inst_117145){
var statearr_117179_117205 = state_117165__$1;
(statearr_117179_117205[(1)] = (14));

} else {
var statearr_117180_117206 = state_117165__$1;
(statearr_117180_117206[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (2))){
var inst_117163 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117165__$1,inst_117163);
} else {
if((state_val_117166 === (19))){
var inst_117155 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
var statearr_117181_117207 = state_117165__$1;
(statearr_117181_117207[(2)] = inst_117155);

(statearr_117181_117207[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (11))){
var inst_117135 = (state_117165[(7)]);
var state_117165__$1 = state_117165;
var statearr_117182_117208 = state_117165__$1;
(statearr_117182_117208[(2)] = inst_117135);

(statearr_117182_117208[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (9))){
var inst_117161 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
var statearr_117183_117209 = state_117165__$1;
(statearr_117183_117209[(2)] = inst_117161);


cljs.core.async.impl.ioc_helpers.process_exception(state_117165__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (5))){
var state_117165__$1 = state_117165;
var statearr_117184_117210 = state_117165__$1;
(statearr_117184_117210[(2)] = null);

(statearr_117184_117210[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (14))){
var inst_117135 = (state_117165[(7)]);
var inst_117139 = (state_117165[(11)]);
var inst_117147 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_117135,inst_117139);
var state_117165__$1 = state_117165;
var statearr_117185_117211 = state_117165__$1;
(statearr_117185_117211[(2)] = inst_117147);

(statearr_117185_117211[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (16))){
var inst_117157 = (state_117165[(2)]);
var state_117165__$1 = state_117165;
var statearr_117186_117212 = state_117165__$1;
(statearr_117186_117212[(2)] = inst_117157);

(statearr_117186_117212[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (10))){
var inst_117139 = (state_117165[(11)]);
var inst_117139__$1 = (state_117165[(2)]);
var inst_117140 = (inst_117139__$1 == null);
var inst_117141 = (inst_117139__$1 instanceof Error);
var inst_117142 = ((inst_117140) || (inst_117141));
var state_117165__$1 = (function (){var statearr_117187 = state_117165;
(statearr_117187[(11)] = inst_117139__$1);

return statearr_117187;
})();
if(cljs.core.truth_(inst_117142)){
var statearr_117188_117213 = state_117165__$1;
(statearr_117188_117213[(1)] = (11));

} else {
var statearr_117189_117214 = state_117165__$1;
(statearr_117189_117214[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (18))){
var state_117165__$1 = state_117165;
var statearr_117190_117215 = state_117165__$1;
(statearr_117190_117215[(2)] = null);

(statearr_117190_117215[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117166 === (8))){
var inst_117134 = (state_117165[(10)]);
var inst_117137 = fluree.db.storage.core.read_block(conn,network,dbid,inst_117134);
var state_117165__$1 = state_117165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117165__$1,(10),inst_117137);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$state_machine__109971__auto__ = null;
var fluree$db$storage$core$state_machine__109971__auto____0 = (function (){
var statearr_117191 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117191[(0)] = fluree$db$storage$core$state_machine__109971__auto__);

(statearr_117191[(1)] = (1));

return statearr_117191;
});
var fluree$db$storage$core$state_machine__109971__auto____1 = (function (state_117165){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117165);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117192){if((e117192 instanceof Object)){
var ex__109974__auto__ = e117192;
var statearr_117193_117216 = state_117165;
(statearr_117193_117216[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117165);

return cljs.core.cst$kw$recur;
} else {
throw e117192;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117217 = state_117165;
state_117165 = G__117217;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__109971__auto__ = function(state_117165){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__109971__auto____1.call(this,state_117165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__109971__auto____0;
fluree$db$storage$core$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__109971__auto____1;
return fluree$db$storage$core$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117194 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117194[(6)] = c__110077__auto__);

return statearr_117194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5;

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117230){
var state_val_117231 = (state_117230[(1)]);
if((state_val_117231 === (1))){
var state_117230__$1 = state_117230;
var statearr_117232_117239 = state_117230__$1;
(statearr_117232_117239[(2)] = null);

(statearr_117232_117239[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117231 === (2))){
var inst_117228 = (state_117230[(2)]);
var state_117230__$1 = state_117230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117230__$1,inst_117228);
} else {
if((state_val_117231 === (3))){
var inst_117218 = (state_117230[(2)]);
var state_117230__$1 = state_117230;
var statearr_117233_117240 = state_117230__$1;
(statearr_117233_117240[(2)] = inst_117218);


cljs.core.async.impl.ioc_helpers.process_exception(state_117230__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117231 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117230,(3),Error,null,(2));
var inst_117222 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_117230__$1 = state_117230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117230__$1,(5),inst_117222);
} else {
if((state_val_117231 === (5))){
var inst_117224 = (state_117230[(2)]);
var inst_117225 = fluree.db.util.async.throw_err(inst_117224);
var inst_117226 = cljs.core.first(inst_117225);
var state_117230__$1 = state_117230;
var statearr_117234_117241 = state_117230__$1;
(statearr_117234_117241[(2)] = inst_117226);


cljs.core.async.impl.ioc_helpers.process_exception(state_117230__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$storage$core$block_$_state_machine__109971__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__109971__auto____0 = (function (){
var statearr_117235 = [null,null,null,null,null,null,null];
(statearr_117235[(0)] = fluree$db$storage$core$block_$_state_machine__109971__auto__);

(statearr_117235[(1)] = (1));

return statearr_117235;
});
var fluree$db$storage$core$block_$_state_machine__109971__auto____1 = (function (state_117230){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117230);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117236){if((e117236 instanceof Object)){
var ex__109974__auto__ = e117236;
var statearr_117237_117242 = state_117230;
(statearr_117237_117242[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117230);

return cljs.core.cst$kw$recur;
} else {
throw e117236;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117243 = state_117230;
state_117230 = G__117243;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__109971__auto__ = function(state_117230){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__109971__auto____1.call(this,state_117230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__109971__auto____0;
fluree$db$storage$core$block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__109971__auto____1;
return fluree$db$storage$core$block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117238 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117238[(6)] = c__110077__auto__);

return statearr_117238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
