// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4131__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_112102){
var state_val_112103 = (state_112102[(1)]);
if((state_val_112103 === (7))){
var inst_112079 = (state_112102[(7)]);
var state_112102__$1 = state_112102;
var statearr_112104_112120 = state_112102__$1;
(statearr_112104_112120[(2)] = inst_112079);

(statearr_112104_112120[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (1))){
var state_112102__$1 = state_112102;
var statearr_112105_112121 = state_112102__$1;
(statearr_112105_112121[(2)] = null);

(statearr_112105_112121[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112102,(3),java.lang.Exception,null,(2));
var inst_112075 = cljs.core.seq(chs);
var inst_112076 = cljs.core.first(inst_112075);
var inst_112077 = cljs.core.next(inst_112075);
var inst_112078 = chs;
var inst_112079 = coll;
var state_112102__$1 = (function (){var statearr_112106 = state_112102;
(statearr_112106[(8)] = inst_112077);

(statearr_112106[(9)] = inst_112076);

(statearr_112106[(7)] = inst_112079);

(statearr_112106[(10)] = inst_112078);

return statearr_112106;
})();
var statearr_112107_112122 = state_112102__$1;
(statearr_112107_112122[(2)] = null);

(statearr_112107_112122[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (6))){
var inst_112098 = (state_112102[(2)]);
var state_112102__$1 = state_112102;
var statearr_112108_112123 = state_112102__$1;
(statearr_112108_112123[(2)] = inst_112098);


cljs.core.async.impl.ioc_helpers.process_exception(state_112102__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (3))){
var inst_112064 = (state_112102[(2)]);
var state_112102__$1 = state_112102;
var statearr_112109_112124 = state_112102__$1;
(statearr_112109_112124[(2)] = inst_112064);


cljs.core.async.impl.ioc_helpers.process_exception(state_112102__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (2))){
var inst_112100 = (state_112102[(2)]);
var state_112102__$1 = state_112102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112102__$1,inst_112100);
} else {
if((state_val_112103 === (9))){
var inst_112096 = (state_112102[(2)]);
var state_112102__$1 = state_112102;
var statearr_112110_112125 = state_112102__$1;
(statearr_112110_112125[(2)] = inst_112096);

(statearr_112110_112125[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (5))){
var inst_112085 = (state_112102[(11)]);
var inst_112078 = (state_112102[(10)]);
var inst_112084 = cljs.core.seq(inst_112078);
var inst_112085__$1 = cljs.core.first(inst_112084);
var inst_112086 = cljs.core.next(inst_112084);
var inst_112087 = cljs.core.not(inst_112085__$1);
var state_112102__$1 = (function (){var statearr_112111 = state_112102;
(statearr_112111[(12)] = inst_112086);

(statearr_112111[(11)] = inst_112085__$1);

return statearr_112111;
})();
if(inst_112087){
var statearr_112112_112126 = state_112102__$1;
(statearr_112112_112126[(1)] = (7));

} else {
var statearr_112113_112127 = state_112102__$1;
(statearr_112113_112127[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (10))){
var inst_112086 = (state_112102[(12)]);
var inst_112079 = (state_112102[(7)]);
var inst_112091 = (state_112102[(2)]);
var inst_112092 = fluree.db.util.async.throw_err(inst_112091);
var inst_112093 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112079,inst_112092);
var inst_112078 = inst_112086;
var inst_112079__$1 = inst_112093;
var state_112102__$1 = (function (){var statearr_112114 = state_112102;
(statearr_112114[(7)] = inst_112079__$1);

(statearr_112114[(10)] = inst_112078);

return statearr_112114;
})();
var statearr_112115_112128 = state_112102__$1;
(statearr_112115_112128[(2)] = null);

(statearr_112115_112128[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112103 === (8))){
var inst_112085 = (state_112102[(11)]);
var state_112102__$1 = state_112102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112102__$1,(10),inst_112085);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_112116 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112116[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__);

(statearr_112116[(1)] = (1));

return statearr_112116;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____1 = (function (state_112102){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_112102);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e112117){if((e112117 instanceof Object)){
var ex__109974__auto__ = e112117;
var statearr_112118_112129 = state_112102;
(statearr_112118_112129[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112102);

return cljs.core.cst$kw$recur;
} else {
throw e112117;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__112130 = state_112102;
state_112102 = G__112130;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__ = function(state_112102){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____1.call(this,state_112102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_112119 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_112119[(6)] = c__110077__auto__);

return statearr_112119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_112152){
var state_val_112153 = (state_112152[(1)]);
if((state_val_112153 === (7))){
var inst_112139 = (state_112152[(7)]);
var inst_112138 = (state_112152[(2)]);
var inst_112139__$1 = fluree.db.util.async.throw_err(inst_112138);
var inst_112140 = (inst_112139__$1 == null);
var state_112152__$1 = (function (){var statearr_112154 = state_112152;
(statearr_112154[(7)] = inst_112139__$1);

return statearr_112154;
})();
if(cljs.core.truth_(inst_112140)){
var statearr_112155_112170 = state_112152__$1;
(statearr_112155_112170[(1)] = (8));

} else {
var statearr_112156_112171 = state_112152__$1;
(statearr_112156_112171[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (1))){
var state_112152__$1 = state_112152;
var statearr_112157_112172 = state_112152__$1;
(statearr_112157_112172[(2)] = null);

(statearr_112157_112172[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112152,(3),java.lang.Exception,null,(2));
var inst_112135 = coll;
var state_112152__$1 = (function (){var statearr_112158 = state_112152;
(statearr_112158[(8)] = inst_112135);

return statearr_112158;
})();
var statearr_112159_112173 = state_112152__$1;
(statearr_112159_112173[(2)] = null);

(statearr_112159_112173[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (6))){
var inst_112148 = (state_112152[(2)]);
var state_112152__$1 = state_112152;
var statearr_112160_112174 = state_112152__$1;
(statearr_112160_112174[(2)] = inst_112148);


cljs.core.async.impl.ioc_helpers.process_exception(state_112152__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (3))){
var inst_112131 = (state_112152[(2)]);
var state_112152__$1 = state_112152;
var statearr_112161_112175 = state_112152__$1;
(statearr_112161_112175[(2)] = inst_112131);


cljs.core.async.impl.ioc_helpers.process_exception(state_112152__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (2))){
var inst_112150 = (state_112152[(2)]);
var state_112152__$1 = state_112152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112152__$1,inst_112150);
} else {
if((state_val_112153 === (9))){
var inst_112139 = (state_112152[(7)]);
var inst_112135 = (state_112152[(8)]);
var inst_112143 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_112135,inst_112139);
var inst_112135__$1 = inst_112143;
var state_112152__$1 = (function (){var statearr_112162 = state_112152;
(statearr_112162[(8)] = inst_112135__$1);

return statearr_112162;
})();
var statearr_112163_112176 = state_112152__$1;
(statearr_112163_112176[(2)] = null);

(statearr_112163_112176[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (5))){
var state_112152__$1 = state_112152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112152__$1,(7),chan);
} else {
if((state_val_112153 === (10))){
var inst_112146 = (state_112152[(2)]);
var state_112152__$1 = state_112152;
var statearr_112164_112177 = state_112152__$1;
(statearr_112164_112177[(2)] = inst_112146);

(statearr_112164_112177[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112153 === (8))){
var inst_112135 = (state_112152[(8)]);
var state_112152__$1 = state_112152;
var statearr_112165_112178 = state_112152__$1;
(statearr_112165_112178[(2)] = inst_112135);

(statearr_112165_112178[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_112166 = [null,null,null,null,null,null,null,null,null];
(statearr_112166[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__);

(statearr_112166[(1)] = (1));

return statearr_112166;
});
var fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____1 = (function (state_112152){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_112152);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e112167){if((e112167 instanceof Object)){
var ex__109974__auto__ = e112167;
var statearr_112168_112179 = state_112152;
(statearr_112168_112179[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112152);

return cljs.core.cst$kw$recur;
} else {
throw e112167;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__112180 = state_112152;
state_112152 = G__112180;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__ = function(state_112152){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____1.call(this,state_112152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__109971__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_112169 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_112169[(6)] = c__110077__auto__);

return statearr_112169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
