// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__104359){
var vec__104360 = p__104359;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104360,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104360,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__104363 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104363,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104363,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104363,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104363,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104363,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5735__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__104366 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104366,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104366,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104366,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104366,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104366,(4),null);
var vec__104369 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104369,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104369,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104369,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104369,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104369,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4131__auto__ = col;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__104372 = segmap;
var map__104372__$1 = (((((!((map__104372 == null))))?(((((map__104372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104372):map__104372);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104372__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104372__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104372__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104372__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104372__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
});})(map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});})(map__104372,map__104372__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__104375 = arguments.length;
switch (G__104375) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__104379 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__104383 = cljs.core.next(segs__$1);
var G__104384 = nrelseg;
var G__104385 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__104383;
relseg__$1 = G__104384;
result__$1 = G__104385;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104379,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104379,(1),null);
var G__104386 = (gline + (1));
var G__104387 = cljs.core.next(lines__$1);
var G__104388 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__104389 = result__$1;
gline = G__104386;
lines__$1 = G__104387;
relseg = G__104388;
result = G__104389;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__104391 = segmap;
var map__104391__$1 = (((((!((map__104391 == null))))?(((((map__104391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104391):map__104391);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104391__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104391__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104391__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104391__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104391__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__104391,map__104391__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (map__104391,map__104391__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__104390_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__104390_SHARP_,d__$1);
});})(map__104391,map__104391__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__104391,map__104391__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__104394 = arguments.length;
switch (G__104394) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__104398 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__104402 = cljs.core.next(segs__$1);
var G__104403 = nrelseg;
var G__104404 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__104402;
relseg__$1 = G__104403;
result__$1 = G__104404;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104398,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104398,(1),null);
var G__104405 = (gline + (1));
var G__104406 = cljs.core.next(lines__$1);
var G__104407 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__104408 = result__$1;
gline = G__104405;
lines__$1 = G__104406;
relseg = G__104407;
result = G__104408;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,((function (relseg){
return (function (p__104409){
var vec__104410 = p__104409;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104410,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104410,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104410,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104410,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104410,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (relseg){
return (function (cols__$1,p__104413){
var vec__104414 = p__104413;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104414,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104414,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104414,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104414,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104414,(4),null);
var seg = vec__104414;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,((function (offset,vec__104414,gcol,sidx,line,col,name,seg,relseg){
return (function (p__104417){
var vec__104418 = p__104417;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104418,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104418,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104418,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104418,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104418,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4131__auto__ = name;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__104414,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__104424 = cljs.core.seq(infos);
var chunk__104425 = null;
var count__104426 = (0);
var i__104427 = (0);
while(true){
if((i__104427 < count__104426)){
var info = chunk__104425.cljs$core$IIndexed$_nth$arity$2(null,i__104427);
var segv_104781 = info__GT_segv(info,source_idx,line,col);
var gline_104782 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_104783 = cljs.core.count(cljs.core.deref(lines));
if((gline_104782 > (lc_104783 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__104424,chunk__104425,count__104426,i__104427,segv_104781,gline_104782,lc_104783,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_104782 - (lc_104783 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_104781], null));
});})(seq__104424,chunk__104425,count__104426,i__104427,segv_104781,gline_104782,lc_104783,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__104424,chunk__104425,count__104426,i__104427,segv_104781,gline_104782,lc_104783,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_104782], null),cljs.core.conj,segv_104781);
});})(seq__104424,chunk__104425,count__104426,i__104427,segv_104781,gline_104782,lc_104783,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__104784 = seq__104424;
var G__104785 = chunk__104425;
var G__104786 = count__104426;
var G__104787 = (i__104427 + (1));
seq__104424 = G__104784;
chunk__104425 = G__104785;
count__104426 = G__104786;
i__104427 = G__104787;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__104424);
if(temp__5735__auto__){
var seq__104424__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__104424__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__104424__$1);
var G__104788 = cljs.core.chunk_rest(seq__104424__$1);
var G__104789 = c__4550__auto__;
var G__104790 = cljs.core.count(c__4550__auto__);
var G__104791 = (0);
seq__104424 = G__104788;
chunk__104425 = G__104789;
count__104426 = G__104790;
i__104427 = G__104791;
continue;
} else {
var info = cljs.core.first(seq__104424__$1);
var segv_104792 = info__GT_segv(info,source_idx,line,col);
var gline_104793 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_104794 = cljs.core.count(cljs.core.deref(lines));
if((gline_104793 > (lc_104794 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__104424,chunk__104425,count__104426,i__104427,segv_104792,gline_104793,lc_104794,info,seq__104424__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_104793 - (lc_104794 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_104792], null));
});})(seq__104424,chunk__104425,count__104426,i__104427,segv_104792,gline_104793,lc_104794,info,seq__104424__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__104424,chunk__104425,count__104426,i__104427,segv_104792,gline_104793,lc_104794,info,seq__104424__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_104793], null),cljs.core.conj,segv_104792);
});})(seq__104424,chunk__104425,count__104426,i__104427,segv_104792,gline_104793,lc_104794,info,seq__104424__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__104795 = cljs.core.next(seq__104424__$1);
var G__104796 = null;
var G__104797 = (0);
var G__104798 = (0);
seq__104424 = G__104795;
chunk__104425 = G__104796;
count__104426 = G__104797;
i__104427 = G__104798;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__104428_104799 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__104429_104800 = null;
var count__104430_104801 = (0);
var i__104431_104802 = (0);
while(true){
if((i__104431_104802 < count__104430_104801)){
var vec__104604_104803 = chunk__104429_104800.cljs$core$IIndexed$_nth$arity$2(null,i__104431_104802);
var source_idx_104804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104604_104803,(0),null);
var vec__104607_104805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104604_104803,(1),null);
var __104806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104607_104805,(0),null);
var lines_104807__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104607_104805,(1),null);
var seq__104610_104808 = cljs.core.seq(lines_104807__$1);
var chunk__104611_104809 = null;
var count__104612_104810 = (0);
var i__104613_104811 = (0);
while(true){
if((i__104613_104811 < count__104612_104810)){
var vec__104652_104812 = chunk__104611_104809.cljs$core$IIndexed$_nth$arity$2(null,i__104613_104811);
var line_104813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104652_104812,(0),null);
var cols_104814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104652_104812,(1),null);
var seq__104655_104815 = cljs.core.seq(cols_104814);
var chunk__104656_104816 = null;
var count__104657_104817 = (0);
var i__104658_104818 = (0);
while(true){
if((i__104658_104818 < count__104657_104817)){
var vec__104665_104819 = chunk__104656_104816.cljs$core$IIndexed$_nth$arity$2(null,i__104658_104818);
var col_104820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104665_104819,(0),null);
var infos_104821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104665_104819,(1),null);
encode_cols(infos_104821,source_idx_104804,line_104813,col_104820);


var G__104822 = seq__104655_104815;
var G__104823 = chunk__104656_104816;
var G__104824 = count__104657_104817;
var G__104825 = (i__104658_104818 + (1));
seq__104655_104815 = G__104822;
chunk__104656_104816 = G__104823;
count__104657_104817 = G__104824;
i__104658_104818 = G__104825;
continue;
} else {
var temp__5735__auto___104826 = cljs.core.seq(seq__104655_104815);
if(temp__5735__auto___104826){
var seq__104655_104827__$1 = temp__5735__auto___104826;
if(cljs.core.chunked_seq_QMARK_(seq__104655_104827__$1)){
var c__4550__auto___104828 = cljs.core.chunk_first(seq__104655_104827__$1);
var G__104829 = cljs.core.chunk_rest(seq__104655_104827__$1);
var G__104830 = c__4550__auto___104828;
var G__104831 = cljs.core.count(c__4550__auto___104828);
var G__104832 = (0);
seq__104655_104815 = G__104829;
chunk__104656_104816 = G__104830;
count__104657_104817 = G__104831;
i__104658_104818 = G__104832;
continue;
} else {
var vec__104668_104833 = cljs.core.first(seq__104655_104827__$1);
var col_104834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104668_104833,(0),null);
var infos_104835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104668_104833,(1),null);
encode_cols(infos_104835,source_idx_104804,line_104813,col_104834);


var G__104836 = cljs.core.next(seq__104655_104827__$1);
var G__104837 = null;
var G__104838 = (0);
var G__104839 = (0);
seq__104655_104815 = G__104836;
chunk__104656_104816 = G__104837;
count__104657_104817 = G__104838;
i__104658_104818 = G__104839;
continue;
}
} else {
}
}
break;
}


var G__104840 = seq__104610_104808;
var G__104841 = chunk__104611_104809;
var G__104842 = count__104612_104810;
var G__104843 = (i__104613_104811 + (1));
seq__104610_104808 = G__104840;
chunk__104611_104809 = G__104841;
count__104612_104810 = G__104842;
i__104613_104811 = G__104843;
continue;
} else {
var temp__5735__auto___104844 = cljs.core.seq(seq__104610_104808);
if(temp__5735__auto___104844){
var seq__104610_104845__$1 = temp__5735__auto___104844;
if(cljs.core.chunked_seq_QMARK_(seq__104610_104845__$1)){
var c__4550__auto___104846 = cljs.core.chunk_first(seq__104610_104845__$1);
var G__104847 = cljs.core.chunk_rest(seq__104610_104845__$1);
var G__104848 = c__4550__auto___104846;
var G__104849 = cljs.core.count(c__4550__auto___104846);
var G__104850 = (0);
seq__104610_104808 = G__104847;
chunk__104611_104809 = G__104848;
count__104612_104810 = G__104849;
i__104613_104811 = G__104850;
continue;
} else {
var vec__104671_104851 = cljs.core.first(seq__104610_104845__$1);
var line_104852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104671_104851,(0),null);
var cols_104853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104671_104851,(1),null);
var seq__104674_104854 = cljs.core.seq(cols_104853);
var chunk__104675_104855 = null;
var count__104676_104856 = (0);
var i__104677_104857 = (0);
while(true){
if((i__104677_104857 < count__104676_104856)){
var vec__104684_104858 = chunk__104675_104855.cljs$core$IIndexed$_nth$arity$2(null,i__104677_104857);
var col_104859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104684_104858,(0),null);
var infos_104860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104684_104858,(1),null);
encode_cols(infos_104860,source_idx_104804,line_104852,col_104859);


var G__104861 = seq__104674_104854;
var G__104862 = chunk__104675_104855;
var G__104863 = count__104676_104856;
var G__104864 = (i__104677_104857 + (1));
seq__104674_104854 = G__104861;
chunk__104675_104855 = G__104862;
count__104676_104856 = G__104863;
i__104677_104857 = G__104864;
continue;
} else {
var temp__5735__auto___104865__$1 = cljs.core.seq(seq__104674_104854);
if(temp__5735__auto___104865__$1){
var seq__104674_104866__$1 = temp__5735__auto___104865__$1;
if(cljs.core.chunked_seq_QMARK_(seq__104674_104866__$1)){
var c__4550__auto___104867 = cljs.core.chunk_first(seq__104674_104866__$1);
var G__104868 = cljs.core.chunk_rest(seq__104674_104866__$1);
var G__104869 = c__4550__auto___104867;
var G__104870 = cljs.core.count(c__4550__auto___104867);
var G__104871 = (0);
seq__104674_104854 = G__104868;
chunk__104675_104855 = G__104869;
count__104676_104856 = G__104870;
i__104677_104857 = G__104871;
continue;
} else {
var vec__104687_104872 = cljs.core.first(seq__104674_104866__$1);
var col_104873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104687_104872,(0),null);
var infos_104874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104687_104872,(1),null);
encode_cols(infos_104874,source_idx_104804,line_104852,col_104873);


var G__104875 = cljs.core.next(seq__104674_104866__$1);
var G__104876 = null;
var G__104877 = (0);
var G__104878 = (0);
seq__104674_104854 = G__104875;
chunk__104675_104855 = G__104876;
count__104676_104856 = G__104877;
i__104677_104857 = G__104878;
continue;
}
} else {
}
}
break;
}


var G__104879 = cljs.core.next(seq__104610_104845__$1);
var G__104880 = null;
var G__104881 = (0);
var G__104882 = (0);
seq__104610_104808 = G__104879;
chunk__104611_104809 = G__104880;
count__104612_104810 = G__104881;
i__104613_104811 = G__104882;
continue;
}
} else {
}
}
break;
}


var G__104883 = seq__104428_104799;
var G__104884 = chunk__104429_104800;
var G__104885 = count__104430_104801;
var G__104886 = (i__104431_104802 + (1));
seq__104428_104799 = G__104883;
chunk__104429_104800 = G__104884;
count__104430_104801 = G__104885;
i__104431_104802 = G__104886;
continue;
} else {
var temp__5735__auto___104887 = cljs.core.seq(seq__104428_104799);
if(temp__5735__auto___104887){
var seq__104428_104888__$1 = temp__5735__auto___104887;
if(cljs.core.chunked_seq_QMARK_(seq__104428_104888__$1)){
var c__4550__auto___104889 = cljs.core.chunk_first(seq__104428_104888__$1);
var G__104890 = cljs.core.chunk_rest(seq__104428_104888__$1);
var G__104891 = c__4550__auto___104889;
var G__104892 = cljs.core.count(c__4550__auto___104889);
var G__104893 = (0);
seq__104428_104799 = G__104890;
chunk__104429_104800 = G__104891;
count__104430_104801 = G__104892;
i__104431_104802 = G__104893;
continue;
} else {
var vec__104690_104894 = cljs.core.first(seq__104428_104888__$1);
var source_idx_104895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104690_104894,(0),null);
var vec__104693_104896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104690_104894,(1),null);
var __104897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104693_104896,(0),null);
var lines_104898__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104693_104896,(1),null);
var seq__104696_104899 = cljs.core.seq(lines_104898__$1);
var chunk__104697_104900 = null;
var count__104698_104901 = (0);
var i__104699_104902 = (0);
while(true){
if((i__104699_104902 < count__104698_104901)){
var vec__104738_104903 = chunk__104697_104900.cljs$core$IIndexed$_nth$arity$2(null,i__104699_104902);
var line_104904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104738_104903,(0),null);
var cols_104905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104738_104903,(1),null);
var seq__104741_104906 = cljs.core.seq(cols_104905);
var chunk__104742_104907 = null;
var count__104743_104908 = (0);
var i__104744_104909 = (0);
while(true){
if((i__104744_104909 < count__104743_104908)){
var vec__104751_104910 = chunk__104742_104907.cljs$core$IIndexed$_nth$arity$2(null,i__104744_104909);
var col_104911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104751_104910,(0),null);
var infos_104912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104751_104910,(1),null);
encode_cols(infos_104912,source_idx_104895,line_104904,col_104911);


var G__104913 = seq__104741_104906;
var G__104914 = chunk__104742_104907;
var G__104915 = count__104743_104908;
var G__104916 = (i__104744_104909 + (1));
seq__104741_104906 = G__104913;
chunk__104742_104907 = G__104914;
count__104743_104908 = G__104915;
i__104744_104909 = G__104916;
continue;
} else {
var temp__5735__auto___104917__$1 = cljs.core.seq(seq__104741_104906);
if(temp__5735__auto___104917__$1){
var seq__104741_104918__$1 = temp__5735__auto___104917__$1;
if(cljs.core.chunked_seq_QMARK_(seq__104741_104918__$1)){
var c__4550__auto___104919 = cljs.core.chunk_first(seq__104741_104918__$1);
var G__104920 = cljs.core.chunk_rest(seq__104741_104918__$1);
var G__104921 = c__4550__auto___104919;
var G__104922 = cljs.core.count(c__4550__auto___104919);
var G__104923 = (0);
seq__104741_104906 = G__104920;
chunk__104742_104907 = G__104921;
count__104743_104908 = G__104922;
i__104744_104909 = G__104923;
continue;
} else {
var vec__104754_104924 = cljs.core.first(seq__104741_104918__$1);
var col_104925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104754_104924,(0),null);
var infos_104926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104754_104924,(1),null);
encode_cols(infos_104926,source_idx_104895,line_104904,col_104925);


var G__104927 = cljs.core.next(seq__104741_104918__$1);
var G__104928 = null;
var G__104929 = (0);
var G__104930 = (0);
seq__104741_104906 = G__104927;
chunk__104742_104907 = G__104928;
count__104743_104908 = G__104929;
i__104744_104909 = G__104930;
continue;
}
} else {
}
}
break;
}


var G__104931 = seq__104696_104899;
var G__104932 = chunk__104697_104900;
var G__104933 = count__104698_104901;
var G__104934 = (i__104699_104902 + (1));
seq__104696_104899 = G__104931;
chunk__104697_104900 = G__104932;
count__104698_104901 = G__104933;
i__104699_104902 = G__104934;
continue;
} else {
var temp__5735__auto___104935__$1 = cljs.core.seq(seq__104696_104899);
if(temp__5735__auto___104935__$1){
var seq__104696_104936__$1 = temp__5735__auto___104935__$1;
if(cljs.core.chunked_seq_QMARK_(seq__104696_104936__$1)){
var c__4550__auto___104937 = cljs.core.chunk_first(seq__104696_104936__$1);
var G__104938 = cljs.core.chunk_rest(seq__104696_104936__$1);
var G__104939 = c__4550__auto___104937;
var G__104940 = cljs.core.count(c__4550__auto___104937);
var G__104941 = (0);
seq__104696_104899 = G__104938;
chunk__104697_104900 = G__104939;
count__104698_104901 = G__104940;
i__104699_104902 = G__104941;
continue;
} else {
var vec__104757_104942 = cljs.core.first(seq__104696_104936__$1);
var line_104943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104757_104942,(0),null);
var cols_104944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104757_104942,(1),null);
var seq__104760_104945 = cljs.core.seq(cols_104944);
var chunk__104761_104946 = null;
var count__104762_104947 = (0);
var i__104763_104948 = (0);
while(true){
if((i__104763_104948 < count__104762_104947)){
var vec__104770_104949 = chunk__104761_104946.cljs$core$IIndexed$_nth$arity$2(null,i__104763_104948);
var col_104950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104770_104949,(0),null);
var infos_104951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104770_104949,(1),null);
encode_cols(infos_104951,source_idx_104895,line_104943,col_104950);


var G__104952 = seq__104760_104945;
var G__104953 = chunk__104761_104946;
var G__104954 = count__104762_104947;
var G__104955 = (i__104763_104948 + (1));
seq__104760_104945 = G__104952;
chunk__104761_104946 = G__104953;
count__104762_104947 = G__104954;
i__104763_104948 = G__104955;
continue;
} else {
var temp__5735__auto___104956__$2 = cljs.core.seq(seq__104760_104945);
if(temp__5735__auto___104956__$2){
var seq__104760_104957__$1 = temp__5735__auto___104956__$2;
if(cljs.core.chunked_seq_QMARK_(seq__104760_104957__$1)){
var c__4550__auto___104958 = cljs.core.chunk_first(seq__104760_104957__$1);
var G__104959 = cljs.core.chunk_rest(seq__104760_104957__$1);
var G__104960 = c__4550__auto___104958;
var G__104961 = cljs.core.count(c__4550__auto___104958);
var G__104962 = (0);
seq__104760_104945 = G__104959;
chunk__104761_104946 = G__104960;
count__104762_104947 = G__104961;
i__104763_104948 = G__104962;
continue;
} else {
var vec__104773_104963 = cljs.core.first(seq__104760_104957__$1);
var col_104964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104773_104963,(0),null);
var infos_104965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104773_104963,(1),null);
encode_cols(infos_104965,source_idx_104895,line_104943,col_104964);


var G__104966 = cljs.core.next(seq__104760_104957__$1);
var G__104967 = null;
var G__104968 = (0);
var G__104969 = (0);
seq__104760_104945 = G__104966;
chunk__104761_104946 = G__104967;
count__104762_104947 = G__104968;
i__104763_104948 = G__104969;
continue;
}
} else {
}
}
break;
}


var G__104970 = cljs.core.next(seq__104696_104936__$1);
var G__104971 = null;
var G__104972 = (0);
var G__104973 = (0);
seq__104696_104899 = G__104970;
chunk__104697_104900 = G__104971;
count__104698_104901 = G__104972;
i__104699_104902 = G__104973;
continue;
}
} else {
}
}
break;
}


var G__104974 = cljs.core.next(seq__104428_104888__$1);
var G__104975 = null;
var G__104976 = (0);
var G__104977 = (0);
seq__104428_104799 = G__104974;
chunk__104429_104800 = G__104975;
count__104430_104801 = G__104976;
i__104431_104802 = G__104977;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__104776 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__104421_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__104421_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__104422_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__104422_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__104423_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__104423_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__104777 = G__104776;
var G__104778_104978 = G__104777;
var G__104779_104979 = "sourcesContent";
var G__104780_104980 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts));
goog.object.set(G__104778_104978,G__104779_104979,G__104780_104980);

return G__104777;
} else {
return G__104776;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__104981 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104981,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104981,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__104984 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104984,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__104984,(1),null);
var G__104990 = cljs.core.next(col_map_seq);
var G__104991 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__104984,col,infos,vec__104981,line,col_map){
return (function (v,p__104987){
var map__104988 = p__104987;
var map__104988__$1 = (((((!((map__104988 == null))))?(((((map__104988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__104988.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__104988):map__104988);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104988__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__104988__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__104984,col,infos,vec__104981,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__104990;
new_cols = G__104991;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__104992 = cljs.core.next(line_map_seq);
var G__104993 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__104992;
new_lines = G__104993;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__104994_105266 = cljs.core.seq(reverse_map);
var chunk__104995_105267 = null;
var count__104996_105268 = (0);
var i__104997_105269 = (0);
while(true){
if((i__104997_105269 < count__104996_105268)){
var vec__105132_105270 = chunk__104995_105267.cljs$core$IIndexed$_nth$arity$2(null,i__104997_105269);
var line_105271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105132_105270,(0),null);
var columns_105272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105132_105270,(1),null);
var seq__105135_105273 = cljs.core.seq(columns_105272);
var chunk__105136_105274 = null;
var count__105137_105275 = (0);
var i__105138_105276 = (0);
while(true){
if((i__105138_105276 < count__105137_105275)){
var vec__105169_105277 = chunk__105136_105274.cljs$core$IIndexed$_nth$arity$2(null,i__105138_105276);
var column_105278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105169_105277,(0),null);
var column_info_105279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105169_105277,(1),null);
var seq__105172_105280 = cljs.core.seq(column_info_105279);
var chunk__105173_105281 = null;
var count__105174_105282 = (0);
var i__105175_105283 = (0);
while(true){
if((i__105175_105283 < count__105174_105282)){
var map__105180_105284 = chunk__105173_105281.cljs$core$IIndexed$_nth$arity$2(null,i__105175_105283);
var map__105180_105285__$1 = (((((!((map__105180_105284 == null))))?(((((map__105180_105284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105180_105284.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105180_105284):map__105180_105284);
var gline_105286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105180_105285__$1,cljs.core.cst$kw$gline);
var gcol_105287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105180_105285__$1,cljs.core.cst$kw$gcol);
var name_105288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105180_105285__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105286], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105172_105280,chunk__105173_105281,count__105174_105282,i__105175_105283,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105180_105284,map__105180_105285__$1,gline_105286,gcol_105287,name_105288,vec__105169_105277,column_105278,column_info_105279,vec__105132_105270,line_105271,columns_105272,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105287], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105271,cljs.core.cst$kw$col,column_105278,cljs.core.cst$kw$name,name_105288], null));
});})(seq__105172_105280,chunk__105173_105281,count__105174_105282,i__105175_105283,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105180_105284,map__105180_105285__$1,gline_105286,gcol_105287,name_105288,vec__105169_105277,column_105278,column_info_105279,vec__105132_105270,line_105271,columns_105272,inverted))
,cljs.core.sorted_map()));


var G__105289 = seq__105172_105280;
var G__105290 = chunk__105173_105281;
var G__105291 = count__105174_105282;
var G__105292 = (i__105175_105283 + (1));
seq__105172_105280 = G__105289;
chunk__105173_105281 = G__105290;
count__105174_105282 = G__105291;
i__105175_105283 = G__105292;
continue;
} else {
var temp__5735__auto___105293 = cljs.core.seq(seq__105172_105280);
if(temp__5735__auto___105293){
var seq__105172_105294__$1 = temp__5735__auto___105293;
if(cljs.core.chunked_seq_QMARK_(seq__105172_105294__$1)){
var c__4550__auto___105295 = cljs.core.chunk_first(seq__105172_105294__$1);
var G__105296 = cljs.core.chunk_rest(seq__105172_105294__$1);
var G__105297 = c__4550__auto___105295;
var G__105298 = cljs.core.count(c__4550__auto___105295);
var G__105299 = (0);
seq__105172_105280 = G__105296;
chunk__105173_105281 = G__105297;
count__105174_105282 = G__105298;
i__105175_105283 = G__105299;
continue;
} else {
var map__105182_105300 = cljs.core.first(seq__105172_105294__$1);
var map__105182_105301__$1 = (((((!((map__105182_105300 == null))))?(((((map__105182_105300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105182_105300.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105182_105300):map__105182_105300);
var gline_105302 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105182_105301__$1,cljs.core.cst$kw$gline);
var gcol_105303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105182_105301__$1,cljs.core.cst$kw$gcol);
var name_105304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105182_105301__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105302], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105172_105280,chunk__105173_105281,count__105174_105282,i__105175_105283,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105182_105300,map__105182_105301__$1,gline_105302,gcol_105303,name_105304,seq__105172_105294__$1,temp__5735__auto___105293,vec__105169_105277,column_105278,column_info_105279,vec__105132_105270,line_105271,columns_105272,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105303], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105271,cljs.core.cst$kw$col,column_105278,cljs.core.cst$kw$name,name_105304], null));
});})(seq__105172_105280,chunk__105173_105281,count__105174_105282,i__105175_105283,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105182_105300,map__105182_105301__$1,gline_105302,gcol_105303,name_105304,seq__105172_105294__$1,temp__5735__auto___105293,vec__105169_105277,column_105278,column_info_105279,vec__105132_105270,line_105271,columns_105272,inverted))
,cljs.core.sorted_map()));


var G__105305 = cljs.core.next(seq__105172_105294__$1);
var G__105306 = null;
var G__105307 = (0);
var G__105308 = (0);
seq__105172_105280 = G__105305;
chunk__105173_105281 = G__105306;
count__105174_105282 = G__105307;
i__105175_105283 = G__105308;
continue;
}
} else {
}
}
break;
}


var G__105309 = seq__105135_105273;
var G__105310 = chunk__105136_105274;
var G__105311 = count__105137_105275;
var G__105312 = (i__105138_105276 + (1));
seq__105135_105273 = G__105309;
chunk__105136_105274 = G__105310;
count__105137_105275 = G__105311;
i__105138_105276 = G__105312;
continue;
} else {
var temp__5735__auto___105313 = cljs.core.seq(seq__105135_105273);
if(temp__5735__auto___105313){
var seq__105135_105314__$1 = temp__5735__auto___105313;
if(cljs.core.chunked_seq_QMARK_(seq__105135_105314__$1)){
var c__4550__auto___105315 = cljs.core.chunk_first(seq__105135_105314__$1);
var G__105316 = cljs.core.chunk_rest(seq__105135_105314__$1);
var G__105317 = c__4550__auto___105315;
var G__105318 = cljs.core.count(c__4550__auto___105315);
var G__105319 = (0);
seq__105135_105273 = G__105316;
chunk__105136_105274 = G__105317;
count__105137_105275 = G__105318;
i__105138_105276 = G__105319;
continue;
} else {
var vec__105184_105320 = cljs.core.first(seq__105135_105314__$1);
var column_105321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105184_105320,(0),null);
var column_info_105322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105184_105320,(1),null);
var seq__105187_105323 = cljs.core.seq(column_info_105322);
var chunk__105188_105324 = null;
var count__105189_105325 = (0);
var i__105190_105326 = (0);
while(true){
if((i__105190_105326 < count__105189_105325)){
var map__105195_105327 = chunk__105188_105324.cljs$core$IIndexed$_nth$arity$2(null,i__105190_105326);
var map__105195_105328__$1 = (((((!((map__105195_105327 == null))))?(((((map__105195_105327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105195_105327.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105195_105327):map__105195_105327);
var gline_105329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105195_105328__$1,cljs.core.cst$kw$gline);
var gcol_105330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105195_105328__$1,cljs.core.cst$kw$gcol);
var name_105331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105195_105328__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105329], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105187_105323,chunk__105188_105324,count__105189_105325,i__105190_105326,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105195_105327,map__105195_105328__$1,gline_105329,gcol_105330,name_105331,vec__105184_105320,column_105321,column_info_105322,seq__105135_105314__$1,temp__5735__auto___105313,vec__105132_105270,line_105271,columns_105272,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105330], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105271,cljs.core.cst$kw$col,column_105321,cljs.core.cst$kw$name,name_105331], null));
});})(seq__105187_105323,chunk__105188_105324,count__105189_105325,i__105190_105326,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105195_105327,map__105195_105328__$1,gline_105329,gcol_105330,name_105331,vec__105184_105320,column_105321,column_info_105322,seq__105135_105314__$1,temp__5735__auto___105313,vec__105132_105270,line_105271,columns_105272,inverted))
,cljs.core.sorted_map()));


var G__105332 = seq__105187_105323;
var G__105333 = chunk__105188_105324;
var G__105334 = count__105189_105325;
var G__105335 = (i__105190_105326 + (1));
seq__105187_105323 = G__105332;
chunk__105188_105324 = G__105333;
count__105189_105325 = G__105334;
i__105190_105326 = G__105335;
continue;
} else {
var temp__5735__auto___105336__$1 = cljs.core.seq(seq__105187_105323);
if(temp__5735__auto___105336__$1){
var seq__105187_105337__$1 = temp__5735__auto___105336__$1;
if(cljs.core.chunked_seq_QMARK_(seq__105187_105337__$1)){
var c__4550__auto___105338 = cljs.core.chunk_first(seq__105187_105337__$1);
var G__105339 = cljs.core.chunk_rest(seq__105187_105337__$1);
var G__105340 = c__4550__auto___105338;
var G__105341 = cljs.core.count(c__4550__auto___105338);
var G__105342 = (0);
seq__105187_105323 = G__105339;
chunk__105188_105324 = G__105340;
count__105189_105325 = G__105341;
i__105190_105326 = G__105342;
continue;
} else {
var map__105197_105343 = cljs.core.first(seq__105187_105337__$1);
var map__105197_105344__$1 = (((((!((map__105197_105343 == null))))?(((((map__105197_105343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105197_105343.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105197_105343):map__105197_105343);
var gline_105345 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105197_105344__$1,cljs.core.cst$kw$gline);
var gcol_105346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105197_105344__$1,cljs.core.cst$kw$gcol);
var name_105347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105197_105344__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105345], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105187_105323,chunk__105188_105324,count__105189_105325,i__105190_105326,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105197_105343,map__105197_105344__$1,gline_105345,gcol_105346,name_105347,seq__105187_105337__$1,temp__5735__auto___105336__$1,vec__105184_105320,column_105321,column_info_105322,seq__105135_105314__$1,temp__5735__auto___105313,vec__105132_105270,line_105271,columns_105272,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105346], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105271,cljs.core.cst$kw$col,column_105321,cljs.core.cst$kw$name,name_105347], null));
});})(seq__105187_105323,chunk__105188_105324,count__105189_105325,i__105190_105326,seq__105135_105273,chunk__105136_105274,count__105137_105275,i__105138_105276,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105197_105343,map__105197_105344__$1,gline_105345,gcol_105346,name_105347,seq__105187_105337__$1,temp__5735__auto___105336__$1,vec__105184_105320,column_105321,column_info_105322,seq__105135_105314__$1,temp__5735__auto___105313,vec__105132_105270,line_105271,columns_105272,inverted))
,cljs.core.sorted_map()));


var G__105348 = cljs.core.next(seq__105187_105337__$1);
var G__105349 = null;
var G__105350 = (0);
var G__105351 = (0);
seq__105187_105323 = G__105348;
chunk__105188_105324 = G__105349;
count__105189_105325 = G__105350;
i__105190_105326 = G__105351;
continue;
}
} else {
}
}
break;
}


var G__105352 = cljs.core.next(seq__105135_105314__$1);
var G__105353 = null;
var G__105354 = (0);
var G__105355 = (0);
seq__105135_105273 = G__105352;
chunk__105136_105274 = G__105353;
count__105137_105275 = G__105354;
i__105138_105276 = G__105355;
continue;
}
} else {
}
}
break;
}


var G__105356 = seq__104994_105266;
var G__105357 = chunk__104995_105267;
var G__105358 = count__104996_105268;
var G__105359 = (i__104997_105269 + (1));
seq__104994_105266 = G__105356;
chunk__104995_105267 = G__105357;
count__104996_105268 = G__105358;
i__104997_105269 = G__105359;
continue;
} else {
var temp__5735__auto___105360 = cljs.core.seq(seq__104994_105266);
if(temp__5735__auto___105360){
var seq__104994_105361__$1 = temp__5735__auto___105360;
if(cljs.core.chunked_seq_QMARK_(seq__104994_105361__$1)){
var c__4550__auto___105362 = cljs.core.chunk_first(seq__104994_105361__$1);
var G__105363 = cljs.core.chunk_rest(seq__104994_105361__$1);
var G__105364 = c__4550__auto___105362;
var G__105365 = cljs.core.count(c__4550__auto___105362);
var G__105366 = (0);
seq__104994_105266 = G__105363;
chunk__104995_105267 = G__105364;
count__104996_105268 = G__105365;
i__104997_105269 = G__105366;
continue;
} else {
var vec__105199_105367 = cljs.core.first(seq__104994_105361__$1);
var line_105368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105199_105367,(0),null);
var columns_105369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105199_105367,(1),null);
var seq__105202_105370 = cljs.core.seq(columns_105369);
var chunk__105203_105371 = null;
var count__105204_105372 = (0);
var i__105205_105373 = (0);
while(true){
if((i__105205_105373 < count__105204_105372)){
var vec__105236_105374 = chunk__105203_105371.cljs$core$IIndexed$_nth$arity$2(null,i__105205_105373);
var column_105375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105236_105374,(0),null);
var column_info_105376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105236_105374,(1),null);
var seq__105239_105377 = cljs.core.seq(column_info_105376);
var chunk__105240_105378 = null;
var count__105241_105379 = (0);
var i__105242_105380 = (0);
while(true){
if((i__105242_105380 < count__105241_105379)){
var map__105247_105381 = chunk__105240_105378.cljs$core$IIndexed$_nth$arity$2(null,i__105242_105380);
var map__105247_105382__$1 = (((((!((map__105247_105381 == null))))?(((((map__105247_105381.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105247_105381.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105247_105381):map__105247_105381);
var gline_105383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105247_105382__$1,cljs.core.cst$kw$gline);
var gcol_105384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105247_105382__$1,cljs.core.cst$kw$gcol);
var name_105385 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105247_105382__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105383], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105239_105377,chunk__105240_105378,count__105241_105379,i__105242_105380,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105247_105381,map__105247_105382__$1,gline_105383,gcol_105384,name_105385,vec__105236_105374,column_105375,column_info_105376,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105384], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105368,cljs.core.cst$kw$col,column_105375,cljs.core.cst$kw$name,name_105385], null));
});})(seq__105239_105377,chunk__105240_105378,count__105241_105379,i__105242_105380,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105247_105381,map__105247_105382__$1,gline_105383,gcol_105384,name_105385,vec__105236_105374,column_105375,column_info_105376,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted))
,cljs.core.sorted_map()));


var G__105386 = seq__105239_105377;
var G__105387 = chunk__105240_105378;
var G__105388 = count__105241_105379;
var G__105389 = (i__105242_105380 + (1));
seq__105239_105377 = G__105386;
chunk__105240_105378 = G__105387;
count__105241_105379 = G__105388;
i__105242_105380 = G__105389;
continue;
} else {
var temp__5735__auto___105390__$1 = cljs.core.seq(seq__105239_105377);
if(temp__5735__auto___105390__$1){
var seq__105239_105391__$1 = temp__5735__auto___105390__$1;
if(cljs.core.chunked_seq_QMARK_(seq__105239_105391__$1)){
var c__4550__auto___105392 = cljs.core.chunk_first(seq__105239_105391__$1);
var G__105393 = cljs.core.chunk_rest(seq__105239_105391__$1);
var G__105394 = c__4550__auto___105392;
var G__105395 = cljs.core.count(c__4550__auto___105392);
var G__105396 = (0);
seq__105239_105377 = G__105393;
chunk__105240_105378 = G__105394;
count__105241_105379 = G__105395;
i__105242_105380 = G__105396;
continue;
} else {
var map__105249_105397 = cljs.core.first(seq__105239_105391__$1);
var map__105249_105398__$1 = (((((!((map__105249_105397 == null))))?(((((map__105249_105397.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105249_105397.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105249_105397):map__105249_105397);
var gline_105399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105249_105398__$1,cljs.core.cst$kw$gline);
var gcol_105400 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105249_105398__$1,cljs.core.cst$kw$gcol);
var name_105401 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105249_105398__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105399], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105239_105377,chunk__105240_105378,count__105241_105379,i__105242_105380,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105249_105397,map__105249_105398__$1,gline_105399,gcol_105400,name_105401,seq__105239_105391__$1,temp__5735__auto___105390__$1,vec__105236_105374,column_105375,column_info_105376,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105400], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105368,cljs.core.cst$kw$col,column_105375,cljs.core.cst$kw$name,name_105401], null));
});})(seq__105239_105377,chunk__105240_105378,count__105241_105379,i__105242_105380,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105249_105397,map__105249_105398__$1,gline_105399,gcol_105400,name_105401,seq__105239_105391__$1,temp__5735__auto___105390__$1,vec__105236_105374,column_105375,column_info_105376,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted))
,cljs.core.sorted_map()));


var G__105402 = cljs.core.next(seq__105239_105391__$1);
var G__105403 = null;
var G__105404 = (0);
var G__105405 = (0);
seq__105239_105377 = G__105402;
chunk__105240_105378 = G__105403;
count__105241_105379 = G__105404;
i__105242_105380 = G__105405;
continue;
}
} else {
}
}
break;
}


var G__105406 = seq__105202_105370;
var G__105407 = chunk__105203_105371;
var G__105408 = count__105204_105372;
var G__105409 = (i__105205_105373 + (1));
seq__105202_105370 = G__105406;
chunk__105203_105371 = G__105407;
count__105204_105372 = G__105408;
i__105205_105373 = G__105409;
continue;
} else {
var temp__5735__auto___105410__$1 = cljs.core.seq(seq__105202_105370);
if(temp__5735__auto___105410__$1){
var seq__105202_105411__$1 = temp__5735__auto___105410__$1;
if(cljs.core.chunked_seq_QMARK_(seq__105202_105411__$1)){
var c__4550__auto___105412 = cljs.core.chunk_first(seq__105202_105411__$1);
var G__105413 = cljs.core.chunk_rest(seq__105202_105411__$1);
var G__105414 = c__4550__auto___105412;
var G__105415 = cljs.core.count(c__4550__auto___105412);
var G__105416 = (0);
seq__105202_105370 = G__105413;
chunk__105203_105371 = G__105414;
count__105204_105372 = G__105415;
i__105205_105373 = G__105416;
continue;
} else {
var vec__105251_105417 = cljs.core.first(seq__105202_105411__$1);
var column_105418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105251_105417,(0),null);
var column_info_105419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__105251_105417,(1),null);
var seq__105254_105420 = cljs.core.seq(column_info_105419);
var chunk__105255_105421 = null;
var count__105256_105422 = (0);
var i__105257_105423 = (0);
while(true){
if((i__105257_105423 < count__105256_105422)){
var map__105262_105424 = chunk__105255_105421.cljs$core$IIndexed$_nth$arity$2(null,i__105257_105423);
var map__105262_105425__$1 = (((((!((map__105262_105424 == null))))?(((((map__105262_105424.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105262_105424.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105262_105424):map__105262_105424);
var gline_105426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105262_105425__$1,cljs.core.cst$kw$gline);
var gcol_105427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105262_105425__$1,cljs.core.cst$kw$gcol);
var name_105428 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105262_105425__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105426], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105254_105420,chunk__105255_105421,count__105256_105422,i__105257_105423,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105262_105424,map__105262_105425__$1,gline_105426,gcol_105427,name_105428,vec__105251_105417,column_105418,column_info_105419,seq__105202_105411__$1,temp__5735__auto___105410__$1,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105427], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105368,cljs.core.cst$kw$col,column_105418,cljs.core.cst$kw$name,name_105428], null));
});})(seq__105254_105420,chunk__105255_105421,count__105256_105422,i__105257_105423,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105262_105424,map__105262_105425__$1,gline_105426,gcol_105427,name_105428,vec__105251_105417,column_105418,column_info_105419,seq__105202_105411__$1,temp__5735__auto___105410__$1,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted))
,cljs.core.sorted_map()));


var G__105429 = seq__105254_105420;
var G__105430 = chunk__105255_105421;
var G__105431 = count__105256_105422;
var G__105432 = (i__105257_105423 + (1));
seq__105254_105420 = G__105429;
chunk__105255_105421 = G__105430;
count__105256_105422 = G__105431;
i__105257_105423 = G__105432;
continue;
} else {
var temp__5735__auto___105433__$2 = cljs.core.seq(seq__105254_105420);
if(temp__5735__auto___105433__$2){
var seq__105254_105434__$1 = temp__5735__auto___105433__$2;
if(cljs.core.chunked_seq_QMARK_(seq__105254_105434__$1)){
var c__4550__auto___105435 = cljs.core.chunk_first(seq__105254_105434__$1);
var G__105436 = cljs.core.chunk_rest(seq__105254_105434__$1);
var G__105437 = c__4550__auto___105435;
var G__105438 = cljs.core.count(c__4550__auto___105435);
var G__105439 = (0);
seq__105254_105420 = G__105436;
chunk__105255_105421 = G__105437;
count__105256_105422 = G__105438;
i__105257_105423 = G__105439;
continue;
} else {
var map__105264_105440 = cljs.core.first(seq__105254_105434__$1);
var map__105264_105441__$1 = (((((!((map__105264_105440 == null))))?(((((map__105264_105440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__105264_105440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__105264_105440):map__105264_105440);
var gline_105442 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105264_105441__$1,cljs.core.cst$kw$gline);
var gcol_105443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105264_105441__$1,cljs.core.cst$kw$gcol);
var name_105444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__105264_105441__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_105442], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__105254_105420,chunk__105255_105421,count__105256_105422,i__105257_105423,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105264_105440,map__105264_105441__$1,gline_105442,gcol_105443,name_105444,seq__105254_105434__$1,temp__5735__auto___105433__$2,vec__105251_105417,column_105418,column_info_105419,seq__105202_105411__$1,temp__5735__auto___105410__$1,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_105443], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_105368,cljs.core.cst$kw$col,column_105418,cljs.core.cst$kw$name,name_105444], null));
});})(seq__105254_105420,chunk__105255_105421,count__105256_105422,i__105257_105423,seq__105202_105370,chunk__105203_105371,count__105204_105372,i__105205_105373,seq__104994_105266,chunk__104995_105267,count__104996_105268,i__104997_105269,map__105264_105440,map__105264_105441__$1,gline_105442,gcol_105443,name_105444,seq__105254_105434__$1,temp__5735__auto___105433__$2,vec__105251_105417,column_105418,column_info_105419,seq__105202_105411__$1,temp__5735__auto___105410__$1,vec__105199_105367,line_105368,columns_105369,seq__104994_105361__$1,temp__5735__auto___105360,inverted))
,cljs.core.sorted_map()));


var G__105445 = cljs.core.next(seq__105254_105434__$1);
var G__105446 = null;
var G__105447 = (0);
var G__105448 = (0);
seq__105254_105420 = G__105445;
chunk__105255_105421 = G__105446;
count__105256_105422 = G__105447;
i__105257_105423 = G__105448;
continue;
}
} else {
}
}
break;
}


var G__105449 = cljs.core.next(seq__105202_105411__$1);
var G__105450 = null;
var G__105451 = (0);
var G__105452 = (0);
seq__105202_105370 = G__105449;
chunk__105203_105371 = G__105450;
count__105204_105372 = G__105451;
i__105205_105373 = G__105452;
continue;
}
} else {
}
}
break;
}


var G__105453 = cljs.core.next(seq__104994_105361__$1);
var G__105454 = null;
var G__105455 = (0);
var G__105456 = (0);
seq__104994_105266 = G__105453;
chunk__104995_105267 = G__105454;
count__104996_105268 = G__105455;
i__104997_105269 = G__105456;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
