// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.sha3');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('goog.crypt.Pkcs7');
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___134983 = arguments.length;
var i__4731__auto___134984 = (0);
while(true){
if((i__4731__auto___134984 < len__4730__auto___134983)){
args__4736__auto__.push((arguments[i__4731__auto___134984]));

var G__134985 = (i__4731__auto___134984 + (1));
i__4731__auto___134984 = G__134985;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__134976){
var vec__134977 = p__134976;
var map__134980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__134977,(0),null);
var map__134980__$1 = (((((!((map__134980 == null))))?(((((map__134980.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__134980.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__134980):map__134980);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__134980__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__134980__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$hex);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
var padded = pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
})();
var G__134982 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__134982__$1 = (((G__134982 instanceof cljs.core.Keyword))?G__134982.fqn:null);
switch (G__134982__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__134982__$1)].join('')));

}
});

fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq134973){
var G__134974 = cljs.core.first(seq134973);
var seq134973__$1 = cljs.core.next(seq134973);
var G__134975 = cljs.core.first(seq134973__$1);
var seq134973__$2 = cljs.core.next(seq134973__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__134974,G__134975,seq134973__$2);
});

/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4736__auto__ = [];
var len__4730__auto___134999 = arguments.length;
var i__4731__auto___135000 = (0);
while(true){
if((i__4731__auto___135000 < len__4730__auto___134999)){
args__4736__auto__.push((arguments[i__4731__auto___135000]));

var G__135001 = (i__4731__auto___135000 + (1));
i__4731__auto___135000 = G__135001;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__134991){
var vec__134992 = p__134991;
var map__134995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__134992,(0),null);
var map__134995__$1 = (((((!((map__134995 == null))))?(((((map__134995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__134995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__134995):map__134995);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__134995__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__134995__$1,cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$hex);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__134995__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$string);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__134997 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__134997__$1 = (((G__134997 instanceof cljs.core.Keyword))?G__134997.fqn:null);
switch (G__134997__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__134997__$1)].join('')));

}
})():x);
var decrypt_ba = (function (){var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var pkcs7 = (new goog.crypt.Pkcs7());
return pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
})();
var G__134998 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__134998__$1 = (((G__134998 instanceof cljs.core.Keyword))?G__134998.fqn:null);
switch (G__134998__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__134998__$1)].join('')));

}
});

fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq134988){
var G__134989 = cljs.core.first(seq134988);
var seq134988__$1 = cljs.core.next(seq134988);
var G__134990 = cljs.core.first(seq134988__$1);
var seq134988__$2 = cljs.core.next(seq134988__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__134989,G__134990,seq134988__$2);
});

