// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.crypto.sha2');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.crypt.Sha256');
goog.require('goog.crypt.Sha512');
fluree.crypto.sha2.hash = (function fluree$crypto$sha2$hash(ba,hash_size){
if(cljs.core.truth_((function (){var fexpr__135006 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(512),null,(256),null], null), null);
return (fexpr__135006.cljs$core$IFn$_invoke$arity$1 ? fexpr__135006.cljs$core$IFn$_invoke$arity$1(hash_size) : fexpr__135006.call(null,hash_size));
})())){
} else {
throw (new Error("Assert failed: (#{512 256} hash-size)"));
}

var digest = (function (){var G__135007 = hash_size;
switch (G__135007) {
case (256):
var G__135008 = (new goog.crypt.Sha256());
G__135008.update(ba);

return G__135008;

break;
case (512):
var G__135009 = (new goog.crypt.Sha512());
G__135009.update(ba);

return G__135009;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__135007)].join('')));

}
})();
return digest.digest();
});
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_256 = (function fluree$crypto$sha2$sha2_256(ba){
return fluree.crypto.sha2.hash(ba,(256));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_256', fluree.crypto.sha2.sha2_256);
/**
 * Create a sha2 hash from byte-array.
 */
fluree.crypto.sha2.sha2_512 = (function fluree$crypto$sha2$sha2_512(ba){
return fluree.crypto.sha2.hash(ba,(512));
});
goog.exportSymbol('fluree.crypto.sha2.sha2_512', fluree.crypto.sha2.sha2_512);
