// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__135194_135357 = cljs.core.seq(servers);
var chunk__135195_135358 = null;
var count__135196_135359 = (0);
var i__135197_135360 = (0);
while(true){
if((i__135197_135360 < count__135196_135359)){
var server_135361 = chunk__135195_135358.cljs$core$IIndexed$_nth$arity$2(null,i__135197_135360);
var healthcheck_uri_135362 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_135361),"/fdb/health"].join('');
var resp_chan_135363 = fluree.db.util.xhttp.post_json(healthcheck_uri_135362,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__110077__auto___135364 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361){
return (function (state_135256){
var state_val_135257 = (state_135256[(1)]);
if((state_val_135257 === (1))){
var state_135256__$1 = state_135256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135256__$1,(2),resp_chan_135363);
} else {
if((state_val_135257 === (2))){
var inst_135245 = (state_135256[(7)]);
var inst_135245__$1 = (state_135256[(2)]);
var inst_135246 = fluree.db.util.core.exception_QMARK_(inst_135245__$1);
var state_135256__$1 = (function (){var statearr_135258 = state_135256;
(statearr_135258[(7)] = inst_135245__$1);

return statearr_135258;
})();
if(inst_135246){
var statearr_135259_135365 = state_135256__$1;
(statearr_135259_135365[(1)] = (3));

} else {
var statearr_135260_135366 = state_135256__$1;
(statearr_135260_135366[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135257 === (3))){
var inst_135245 = (state_135256[(7)]);
var inst_135248 = cljs.core.ex_message(inst_135245);
var inst_135249 = cljs.core.ex_data(inst_135245);
var inst_135250 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_135248,inst_135249], 0));
var state_135256__$1 = state_135256;
var statearr_135261_135367 = state_135256__$1;
(statearr_135261_135367[(2)] = inst_135250);

(statearr_135261_135367[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135257 === (4))){
var inst_135252 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_135361);
var state_135256__$1 = state_135256;
var statearr_135262_135368 = state_135256__$1;
(statearr_135262_135368[(2)] = inst_135252);

(statearr_135262_135368[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135257 === (5))){
var inst_135254 = (state_135256[(2)]);
var state_135256__$1 = state_135256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135256__$1,inst_135254);
} else {
return null;
}
}
}
}
}
});})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361))
;
return ((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,switch__109970__auto__,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0 = (function (){
var statearr_135263 = [null,null,null,null,null,null,null,null];
(statearr_135263[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__);

(statearr_135263[(1)] = (1));

return statearr_135263;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1 = (function (state_135256){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135256);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135264){if((e135264 instanceof Object)){
var ex__109974__auto__ = e135264;
var statearr_135265_135369 = state_135256;
(statearr_135265_135369[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135256);

return cljs.core.cst$kw$recur;
} else {
throw e135264;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135370 = state_135256;
state_135256 = G__135370;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = function(state_135256){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1.call(this,state_135256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__;
})()
;})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,switch__109970__auto__,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361))
})();
var state__110079__auto__ = (function (){var statearr_135266 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135266[(6)] = c__110077__auto___135364);

return statearr_135266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135364,healthcheck_uri_135362,resp_chan_135363,server_135361))
);



var G__135371 = seq__135194_135357;
var G__135372 = chunk__135195_135358;
var G__135373 = count__135196_135359;
var G__135374 = (i__135197_135360 + (1));
seq__135194_135357 = G__135371;
chunk__135195_135358 = G__135372;
count__135196_135359 = G__135373;
i__135197_135360 = G__135374;
continue;
} else {
var temp__5735__auto___135375 = cljs.core.seq(seq__135194_135357);
if(temp__5735__auto___135375){
var seq__135194_135376__$1 = temp__5735__auto___135375;
if(cljs.core.chunked_seq_QMARK_(seq__135194_135376__$1)){
var c__4550__auto___135377 = cljs.core.chunk_first(seq__135194_135376__$1);
var G__135378 = cljs.core.chunk_rest(seq__135194_135376__$1);
var G__135379 = c__4550__auto___135377;
var G__135380 = cljs.core.count(c__4550__auto___135377);
var G__135381 = (0);
seq__135194_135357 = G__135378;
chunk__135195_135358 = G__135379;
count__135196_135359 = G__135380;
i__135197_135360 = G__135381;
continue;
} else {
var server_135382 = cljs.core.first(seq__135194_135376__$1);
var healthcheck_uri_135383 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_135382),"/fdb/health"].join('');
var resp_chan_135384 = fluree.db.util.xhttp.post_json(healthcheck_uri_135383,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__110077__auto___135385 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375){
return (function (state_135279){
var state_val_135280 = (state_135279[(1)]);
if((state_val_135280 === (1))){
var state_135279__$1 = state_135279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135279__$1,(2),resp_chan_135384);
} else {
if((state_val_135280 === (2))){
var inst_135268 = (state_135279[(7)]);
var inst_135268__$1 = (state_135279[(2)]);
var inst_135269 = fluree.db.util.core.exception_QMARK_(inst_135268__$1);
var state_135279__$1 = (function (){var statearr_135281 = state_135279;
(statearr_135281[(7)] = inst_135268__$1);

return statearr_135281;
})();
if(inst_135269){
var statearr_135282_135386 = state_135279__$1;
(statearr_135282_135386[(1)] = (3));

} else {
var statearr_135283_135387 = state_135279__$1;
(statearr_135283_135387[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135280 === (3))){
var inst_135268 = (state_135279[(7)]);
var inst_135271 = cljs.core.ex_message(inst_135268);
var inst_135272 = cljs.core.ex_data(inst_135268);
var inst_135273 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_135271,inst_135272], 0));
var state_135279__$1 = state_135279;
var statearr_135284_135388 = state_135279__$1;
(statearr_135284_135388[(2)] = inst_135273);

(statearr_135284_135388[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135280 === (4))){
var inst_135275 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_135382);
var state_135279__$1 = state_135279;
var statearr_135285_135389 = state_135279__$1;
(statearr_135285_135389[(2)] = inst_135275);

(statearr_135285_135389[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135280 === (5))){
var inst_135277 = (state_135279[(2)]);
var state_135279__$1 = state_135279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135279__$1,inst_135277);
} else {
return null;
}
}
}
}
}
});})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375))
;
return ((function (seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,switch__109970__auto__,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0 = (function (){
var statearr_135286 = [null,null,null,null,null,null,null,null];
(statearr_135286[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__);

(statearr_135286[(1)] = (1));

return statearr_135286;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1 = (function (state_135279){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135279);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135287){if((e135287 instanceof Object)){
var ex__109974__auto__ = e135287;
var statearr_135288_135390 = state_135279;
(statearr_135288_135390[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135279);

return cljs.core.cst$kw$recur;
} else {
throw e135287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135391 = state_135279;
state_135279 = G__135391;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = function(state_135279){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1.call(this,state_135279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__;
})()
;})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,switch__109970__auto__,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375))
})();
var state__110079__auto__ = (function (){var statearr_135289 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135289[(6)] = c__110077__auto___135385);

return statearr_135289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(seq__135194_135357,chunk__135195_135358,count__135196_135359,i__135197_135360,c__110077__auto___135385,healthcheck_uri_135383,resp_chan_135384,server_135382,seq__135194_135376__$1,temp__5735__auto___135375))
);



var G__135392 = cljs.core.next(seq__135194_135376__$1);
var G__135393 = null;
var G__135394 = (0);
var G__135395 = (0);
seq__135194_135357 = G__135392;
chunk__135195_135358 = G__135393;
count__135196_135359 = G__135394;
i__135197_135360 = G__135395;
continue;
}
} else {
}
}
break;
}

var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_135332){
var state_val_135333 = (state_135332[(1)]);
if((state_val_135333 === (7))){
var inst_135304 = (state_135332[(7)]);
var inst_135311 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135304,cljs.core.cst$kw$default);
var state_135332__$1 = state_135332;
if(inst_135311){
var statearr_135334_135396 = state_135332__$1;
(statearr_135334_135396[(1)] = (9));

} else {
var statearr_135335_135397 = state_135332__$1;
(statearr_135335_135397[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (1))){
var inst_135297 = (state_135332[(8)]);
var inst_135297__$1 = cljs.core.async.timeout((60000));
var inst_135298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135299 = [promise_chan,inst_135297__$1];
var inst_135300 = (new cljs.core.PersistentVector(null,2,(5),inst_135298,inst_135299,null));
var state_135332__$1 = (function (){var statearr_135336 = state_135332;
(statearr_135336[(8)] = inst_135297__$1);

return statearr_135336;
})();
return cljs.core.async.ioc_alts_BANG_(state_135332__$1,(2),inst_135300);
} else {
if((state_val_135333 === (4))){
var inst_135297 = (state_135332[(8)]);
var inst_135304 = (state_135332[(7)]);
var inst_135308 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135304,inst_135297);
var state_135332__$1 = state_135332;
if(inst_135308){
var statearr_135337_135398 = state_135332__$1;
(statearr_135337_135398[(1)] = (6));

} else {
var statearr_135338_135399 = state_135332__$1;
(statearr_135338_135399[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (13))){
var state_135332__$1 = state_135332;
var statearr_135339_135400 = state_135332__$1;
(statearr_135339_135400[(2)] = null);

(statearr_135339_135400[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (6))){
var state_135332__$1 = state_135332;
var statearr_135340_135401 = state_135332__$1;
(statearr_135340_135401[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_135340_135401[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (3))){
var state_135332__$1 = state_135332;
var statearr_135341_135402 = state_135332__$1;
(statearr_135341_135402[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_135341_135402[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (12))){
var inst_135322 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_135323 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_135324 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_135325 = cljs.core.PersistentHashMap.fromArrays(inst_135323,inst_135324);
var inst_135326 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_135325);
var inst_135327 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_135326);
var state_135332__$1 = (function (){var statearr_135342 = state_135332;
(statearr_135342[(9)] = inst_135322);

return statearr_135342;
})();
var statearr_135343_135403 = state_135332__$1;
(statearr_135343_135403[(2)] = inst_135327);

(statearr_135343_135403[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (2))){
var inst_135304 = (state_135332[(7)]);
var inst_135302 = (state_135332[(2)]);
var inst_135303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135302,(0),null);
var inst_135304__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135302,(1),null);
var inst_135305 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135304__$1,promise_chan);
var state_135332__$1 = (function (){var statearr_135344 = state_135332;
(statearr_135344[(10)] = inst_135303);

(statearr_135344[(7)] = inst_135304__$1);

return statearr_135344;
})();
if(inst_135305){
var statearr_135345_135404 = state_135332__$1;
(statearr_135345_135404[(1)] = (3));

} else {
var statearr_135346_135405 = state_135332__$1;
(statearr_135346_135405[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (11))){
var inst_135315 = (state_135332[(2)]);
var state_135332__$1 = state_135332;
var statearr_135347_135406 = state_135332__$1;
(statearr_135347_135406[(2)] = inst_135315);

(statearr_135347_135406[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (9))){
var inst_135303 = (state_135332[(10)]);
var state_135332__$1 = state_135332;
var statearr_135348_135407 = state_135332__$1;
(statearr_135348_135407[(2)] = inst_135303);

(statearr_135348_135407[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (5))){
var inst_135319 = (state_135332[(2)]);
var inst_135320 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_135319);
var state_135332__$1 = state_135332;
if(inst_135320){
var statearr_135349_135408 = state_135332__$1;
(statearr_135349_135408[(1)] = (12));

} else {
var statearr_135350_135409 = state_135332__$1;
(statearr_135350_135409[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (14))){
var inst_135330 = (state_135332[(2)]);
var state_135332__$1 = state_135332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135332__$1,inst_135330);
} else {
if((state_val_135333 === (10))){
var state_135332__$1 = state_135332;
var statearr_135351_135410 = state_135332__$1;
(statearr_135351_135410[(2)] = null);

(statearr_135351_135410[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135333 === (8))){
var inst_135317 = (state_135332[(2)]);
var state_135332__$1 = state_135332;
var statearr_135352_135411 = state_135332__$1;
(statearr_135352_135411[(2)] = inst_135317);

(statearr_135352_135411[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0 = (function (){
var statearr_135353 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_135353[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__);

(statearr_135353[(1)] = (1));

return statearr_135353;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1 = (function (state_135332){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135332);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135354){if((e135354 instanceof Object)){
var ex__109974__auto__ = e135354;
var statearr_135355_135412 = state_135332;
(statearr_135355_135412[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135332);

return cljs.core.cst$kw$recur;
} else {
throw e135354;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135413 = state_135332;
state_135332 = G__135413;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__ = function(state_135332){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1.call(this,state_135332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_135356 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135356[(6)] = c__110077__auto__);

return statearr_135356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),((function (lock_id){
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});})(lock_id))
);
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_135454){
var state_val_135455 = (state_135454[(1)]);
if((state_val_135455 === (7))){
var inst_135432 = (state_135454[(7)]);
var inst_135450 = (state_135454[(2)]);
var state_135454__$1 = (function (){var statearr_135456 = state_135454;
(statearr_135456[(8)] = inst_135450);

return statearr_135456;
})();
var statearr_135457_135475 = state_135454__$1;
(statearr_135457_135475[(2)] = inst_135432);


cljs.core.async.impl.ioc_helpers.process_exception(state_135454__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (1))){
var state_135454__$1 = state_135454;
var statearr_135458_135476 = state_135454__$1;
(statearr_135458_135476[(2)] = null);

(statearr_135458_135476[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (4))){
var inst_135418 = (state_135454[(9)]);
var inst_135423 = (state_135454[(10)]);
var inst_135428 = (state_135454[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_135454,(3),Error,null,(2));
var inst_135418__$1 = fluree.db.util.core.random_uuid();
var inst_135419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135420 = [conn_id,cljs.core.cst$kw$ws];
var inst_135421 = (new cljs.core.PersistentVector(null,2,(5),inst_135419,inst_135420,null));
var inst_135422 = (function (){var lock_id = inst_135418__$1;
return ((function (lock_id,inst_135418,inst_135423,inst_135428,_,inst_135418__$1,inst_135419,inst_135420,inst_135421,state_val_135455,c__110077__auto__){
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
;})(lock_id,inst_135418,inst_135423,inst_135428,_,inst_135418__$1,inst_135419,inst_135420,inst_135421,state_val_135455,c__110077__auto__))
})();
var inst_135423__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_135421,inst_135422);
var inst_135424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135425 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_135426 = (new cljs.core.PersistentVector(null,3,(5),inst_135424,inst_135425,null));
var inst_135427 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_135423__$1,inst_135426);
var inst_135428__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135418__$1,inst_135427);
var inst_135429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135430 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_135431 = (new cljs.core.PersistentVector(null,3,(5),inst_135429,inst_135430,null));
var inst_135432 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_135423__$1,inst_135431);
var state_135454__$1 = (function (){var statearr_135459 = state_135454;
(statearr_135459[(9)] = inst_135418__$1);

(statearr_135459[(7)] = inst_135432);

(statearr_135459[(10)] = inst_135423__$1);

(statearr_135459[(11)] = inst_135428__$1);

return statearr_135459;
})();
if(inst_135428__$1){
var statearr_135460_135477 = state_135454__$1;
(statearr_135460_135477[(1)] = (5));

} else {
var statearr_135461_135478 = state_135454__$1;
(statearr_135461_135478[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (6))){
var state_135454__$1 = state_135454;
var statearr_135462_135479 = state_135454__$1;
(statearr_135462_135479[(2)] = null);

(statearr_135462_135479[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (3))){
var inst_135414 = (state_135454[(2)]);
var state_135454__$1 = state_135454;
var statearr_135463_135480 = state_135454__$1;
(statearr_135463_135480[(2)] = inst_135414);


cljs.core.async.impl.ioc_helpers.process_exception(state_135454__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (2))){
var inst_135452 = (state_135454[(2)]);
var state_135454__$1 = state_135454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135454__$1,inst_135452);
} else {
if((state_val_135455 === (11))){
var inst_135447 = (state_135454[(2)]);
var state_135454__$1 = state_135454;
var statearr_135464_135481 = state_135454__$1;
(statearr_135464_135481[(2)] = inst_135447);

(statearr_135464_135481[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (9))){
var inst_135432 = (state_135454[(7)]);
var inst_135436 = (state_135454[(12)]);
var inst_135442 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_135443 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_135432,inst_135436);
var state_135454__$1 = (function (){var statearr_135465 = state_135454;
(statearr_135465[(13)] = inst_135442);

return statearr_135465;
})();
var statearr_135466_135482 = state_135454__$1;
(statearr_135466_135482[(2)] = inst_135443);

(statearr_135466_135482[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (5))){
var inst_135434 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_135454__$1 = state_135454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135454__$1,(8),inst_135434);
} else {
if((state_val_135455 === (10))){
var inst_135439 = (state_135454[(14)]);
var inst_135438 = (state_135454[(15)]);
var inst_135432 = (state_135454[(7)]);
var inst_135445 = fluree.db.util.xhttp.try_socket(inst_135438,sub_chan,pub_chan,inst_135432,(60000),inst_135439);
var state_135454__$1 = state_135454;
var statearr_135467_135483 = state_135454__$1;
(statearr_135467_135483[(2)] = inst_135445);

(statearr_135467_135483[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135455 === (8))){
var inst_135418 = (state_135454[(9)]);
var inst_135438 = (state_135454[(15)]);
var inst_135432 = (state_135454[(7)]);
var inst_135423 = (state_135454[(10)]);
var inst_135428 = (state_135454[(11)]);
var inst_135436 = (state_135454[(12)]);
var inst_135436__$1 = (state_135454[(2)]);
var inst_135437 = clojure.string.replace(inst_135436__$1,"http","ws");
var inst_135438__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135437),"/fdb/ws"].join('');
var inst_135439 = (function (){var lock_id = inst_135418;
var state = inst_135423;
var have_lock_QMARK_ = inst_135428;
var resp_chan = inst_135432;
var healthy_server = inst_135436__$1;
var ws_url = inst_135438__$1;
var timeout = (60000);
return ((function (lock_id,state,have_lock_QMARK_,resp_chan,healthy_server,ws_url,timeout,inst_135418,inst_135438,inst_135432,inst_135423,inst_135428,inst_135436,inst_135436__$1,inst_135437,inst_135438__$1,state_val_135455,c__110077__auto__){
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
;})(lock_id,state,have_lock_QMARK_,resp_chan,healthy_server,ws_url,timeout,inst_135418,inst_135438,inst_135432,inst_135423,inst_135428,inst_135436,inst_135436__$1,inst_135437,inst_135438__$1,state_val_135455,c__110077__auto__))
})();
var inst_135440 = fluree.db.util.core.exception_QMARK_(inst_135436__$1);
var state_135454__$1 = (function (){var statearr_135468 = state_135454;
(statearr_135468[(14)] = inst_135439);

(statearr_135468[(15)] = inst_135438__$1);

(statearr_135468[(12)] = inst_135436__$1);

return statearr_135468;
})();
if(inst_135440){
var statearr_135469_135484 = state_135454__$1;
(statearr_135469_135484[(1)] = (9));

} else {
var statearr_135470_135485 = state_135454__$1;
(statearr_135470_135485[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__109971__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__109971__auto____0 = (function (){
var statearr_135471 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135471[(0)] = fluree$db$connection$establish_socket_$_state_machine__109971__auto__);

(statearr_135471[(1)] = (1));

return statearr_135471;
});
var fluree$db$connection$establish_socket_$_state_machine__109971__auto____1 = (function (state_135454){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135454);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135472){if((e135472 instanceof Object)){
var ex__109974__auto__ = e135472;
var statearr_135473_135486 = state_135454;
(statearr_135473_135486[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135454);

return cljs.core.cst$kw$recur;
} else {
throw e135472;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135487 = state_135454;
state_135454 = G__135487;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__109971__auto__ = function(state_135454){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__109971__auto____1.call(this,state_135454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__109971__auto____0;
fluree$db$connection$establish_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__109971__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_135474 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135474[(6)] = c__110077__auto__);

return statearr_135474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k135489,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__135493 = k135489;
var G__135493__$1 = (((G__135493 instanceof cljs.core.Keyword))?G__135493.fqn:null);
switch (G__135493__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k135489,else__4388__auto__);

}
});

fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__135494){
var vec__135495 = p__135494;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135495,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135495,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
});

fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__135488){
var self__ = this;
var G__135488__$1 = this;
return (new cljs.core.RecordIter((0),G__135488__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
});

fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__135498 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__135498(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this135490,other135491){
var self__ = this;
var this135490__$1 = this;
return (((!((other135491 == null)))) && ((this135490__$1.constructor === other135491.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.id,other135491.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.servers,other135491.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.state,other135491.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.req_chan,other135491.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.sub_chan,other135491.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.pub_chan,other135491.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.storage_read,other135491.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.storage_write,other135491.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.object_cache,other135491.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.parallelism,other135491.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.serializer,other135491.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.default_network,other135491.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.transactor_QMARK_,other135491.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.publish,other135491.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.transact_handler,other135491.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.tx_private_key,other135491.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.tx_key_id,other135491.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.meta,other135491.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.add_listener,other135491.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.remove_listener,other135491.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.close,other135491.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this135490__$1.__extmap,other135491.__extmap)));
});

fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__135488){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__135499 = cljs.core.keyword_identical_QMARK_;
var expr__135500 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__135502 = cljs.core.cst$kw$id;
var G__135503 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135502,G__135503) : pred__135499.call(null,G__135502,G__135503));
})())){
return (new fluree.db.connection.Connection(G__135488,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135504 = cljs.core.cst$kw$servers;
var G__135505 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135504,G__135505) : pred__135499.call(null,G__135504,G__135505));
})())){
return (new fluree.db.connection.Connection(self__.id,G__135488,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135506 = cljs.core.cst$kw$state;
var G__135507 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135506,G__135507) : pred__135499.call(null,G__135506,G__135507));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__135488,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135508 = cljs.core.cst$kw$req_DASH_chan;
var G__135509 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135508,G__135509) : pred__135499.call(null,G__135508,G__135509));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__135488,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135510 = cljs.core.cst$kw$sub_DASH_chan;
var G__135511 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135510,G__135511) : pred__135499.call(null,G__135510,G__135511));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__135488,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135512 = cljs.core.cst$kw$pub_DASH_chan;
var G__135513 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135512,G__135513) : pred__135499.call(null,G__135512,G__135513));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__135488,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135514 = cljs.core.cst$kw$storage_DASH_read;
var G__135515 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135514,G__135515) : pred__135499.call(null,G__135514,G__135515));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__135488,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135516 = cljs.core.cst$kw$storage_DASH_write;
var G__135517 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135516,G__135517) : pred__135499.call(null,G__135516,G__135517));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__135488,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135518 = cljs.core.cst$kw$object_DASH_cache;
var G__135519 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135518,G__135519) : pred__135499.call(null,G__135518,G__135519));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__135488,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135520 = cljs.core.cst$kw$parallelism;
var G__135521 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135520,G__135521) : pred__135499.call(null,G__135520,G__135521));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__135488,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135522 = cljs.core.cst$kw$serializer;
var G__135523 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135522,G__135523) : pred__135499.call(null,G__135522,G__135523));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__135488,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135524 = cljs.core.cst$kw$default_DASH_network;
var G__135525 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135524,G__135525) : pred__135499.call(null,G__135524,G__135525));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__135488,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135526 = cljs.core.cst$kw$transactor_QMARK_;
var G__135527 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135526,G__135527) : pred__135499.call(null,G__135526,G__135527));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__135488,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135528 = cljs.core.cst$kw$publish;
var G__135529 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135528,G__135529) : pred__135499.call(null,G__135528,G__135529));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__135488,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135530 = cljs.core.cst$kw$transact_DASH_handler;
var G__135531 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135530,G__135531) : pred__135499.call(null,G__135530,G__135531));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__135488,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135532 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__135533 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135532,G__135533) : pred__135499.call(null,G__135532,G__135533));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__135488,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135534 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__135535 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135534,G__135535) : pred__135499.call(null,G__135534,G__135535));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__135488,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135536 = cljs.core.cst$kw$meta;
var G__135537 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135536,G__135537) : pred__135499.call(null,G__135536,G__135537));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__135488,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135538 = cljs.core.cst$kw$add_DASH_listener;
var G__135539 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135538,G__135539) : pred__135499.call(null,G__135538,G__135539));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__135488,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135540 = cljs.core.cst$kw$remove_DASH_listener;
var G__135541 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135540,G__135541) : pred__135499.call(null,G__135540,G__135541));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__135488,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__135542 = cljs.core.cst$kw$close;
var G__135543 = expr__135500;
return (pred__135499.cljs$core$IFn$_invoke$arity$2 ? pred__135499.cljs$core$IFn$_invoke$arity$2(G__135542,G__135543) : pred__135499.call(null,G__135542,G__135543));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__135488,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__135488),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
});

fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__135488){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__135488,self__.__extmap,self__.__hash));
});

fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
});

fluree.db.connection.Connection.cljs$lang$type = true;

fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
});

fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.connection/Connection");
});

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__135492){
var extmap__4424__auto__ = (function (){var G__135544 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__135492,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__135492)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__135544);
} else {
return G__135544;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__135492),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__135492),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__135549 = servers_STAR_;
var vec__135550 = G__135549;
var seq__135551 = cljs.core.seq(vec__135550);
var first__135552 = cljs.core.first(seq__135551);
var seq__135551__$1 = cljs.core.next(seq__135551);
var server = first__135552;
var r = seq__135551__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__135549__$1 = G__135549;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__135556 = G__135549__$1;
var seq__135557 = cljs.core.seq(vec__135556);
var first__135558 = cljs.core.first(seq__135557);
var seq__135557__$1 = cljs.core.next(seq__135557);
var server__$1 = first__135558;
var r__$1 = seq__135557__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(server__$2)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(server__$2)].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_STAR_),":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(server__$2)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4120__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__135559 = r__$1;
var G__135560 = is_https_QMARK_;
var G__135561 = result_STAR_;
G__135549__$1 = G__135559;
https_QMARK___$1 = G__135560;
result__$1 = G__135561;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.connection !== 'undefined') && (typeof fluree.db.connection.process_event !== 'undefined')){
} else {
fluree.db.connection.process_event = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__135562 = cljs.core.get_global_hierarchy;
return (fexpr__135562.cljs$core$IFn$_invoke$arity$0 ? fexpr__135562.cljs$core$IFn$_invoke$arity$0() : fexpr__135562.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.connection","process-event"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (_,event_type,___$1,___$2){
return event_type;
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
fluree.db.connection.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.connection.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__135563 = cljs.core.seq(callbacks);
var chunk__135564 = null;
var count__135565 = (0);
var i__135566 = (0);
while(true){
if((i__135566 < count__135565)){
var vec__135575 = chunk__135564.cljs$core$IIndexed$_nth$arity$2(null,i__135566);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135575,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135575,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e135578){if((e135578 instanceof java.lang.Exception)){
var e_135583 = e135578;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_135583,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
} else {
throw e135578;

}
}

var G__135584 = seq__135563;
var G__135585 = chunk__135564;
var G__135586 = count__135565;
var G__135587 = (i__135566 + (1));
seq__135563 = G__135584;
chunk__135564 = G__135585;
count__135565 = G__135586;
i__135566 = G__135587;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__135563);
if(temp__5735__auto__){
var seq__135563__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__135563__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__135563__$1);
var G__135588 = cljs.core.chunk_rest(seq__135563__$1);
var G__135589 = c__4550__auto__;
var G__135590 = cljs.core.count(c__4550__auto__);
var G__135591 = (0);
seq__135563 = G__135588;
chunk__135564 = G__135589;
count__135565 = G__135590;
i__135566 = G__135591;
continue;
} else {
var vec__135579 = cljs.core.first(seq__135563__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135579,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135579,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e135582){if((e135582 instanceof java.lang.Exception)){
var e_135592 = e135582;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_135592,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
} else {
throw e135582;

}
}

var G__135593 = cljs.core.next(seq__135563__$1);
var G__135594 = null;
var G__135595 = (0);
var G__135596 = (0);
seq__135563 = G__135593;
chunk__135564 = G__135594;
count__135565 = G__135595;
i__135566 = G__135596;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.connection.process_events = (function fluree$db$connection$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__135599 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135599,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135599,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135599,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__135599,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__135602 = conn;
var map__135602__$1 = (((((!((map__135602 == null))))?(((((map__135602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__135602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__135602):map__135602);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135602__$1,cljs.core.cst$kw$state);
var G__135604 = event_type__$1;
var G__135604__$1 = (((G__135604 instanceof cljs.core.Keyword))?G__135604.fqn:null);
switch (G__135604__$1) {
case "response":
var temp__5735__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5735__auto__)){
var res_chan = temp__5735__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,((function (res_chan,temp__5735__auto__,G__135604,G__135604__$1,_,vec__135599,event_type,subject,event_data,error_data,event_type__$1,map__135602,map__135602__$1,state){
return (function (p1__135597_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__135597_SHARP_,subject);
});})(res_chan,temp__5735__auto__,G__135604,G__135604__$1,_,vec__135599,event_type,subject,event_data,error_data,event_type__$1,map__135602,map__135602__$1,state))
);

if(cljs.core.truth_(error_data)){
var map__135605 = error_data;
var map__135605__$1 = (((((!((map__135605 == null))))?(((((map__135605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__135605.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__135605):map__135605);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135605__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = message;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.connection.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.connection.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.connection.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e135598){if((e135598 instanceof java.lang.Exception)){
var e = e135598;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
} else {
throw e135598;

}
}});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__135608 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__135608 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__135608);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_135634){
var state_val_135635 = (state_135634[(1)]);
if((state_val_135635 === (1))){
var state_135634__$1 = state_135634;
var statearr_135636_135648 = state_135634__$1;
(statearr_135636_135648[(2)] = null);

(statearr_135636_135648[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135635 === (2))){
var inst_135632 = (state_135634[(2)]);
var state_135634__$1 = state_135634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135634__$1,inst_135632);
} else {
if((state_val_135635 === (3))){
var inst_135609 = (state_135634[(2)]);
var state_135634__$1 = state_135634;
var statearr_135637_135649 = state_135634__$1;
(statearr_135637_135649[(2)] = inst_135609);


cljs.core.async.impl.ioc_helpers.process_exception(state_135634__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135635 === (4))){
var inst_135618 = (state_135634[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_135634,(3),Error,null,(2));
var inst_135613 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_135614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135615 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135616 = [inst_135615,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_135617 = (new cljs.core.PersistentVector(null,3,(5),inst_135614,inst_135616,null));
var inst_135618__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_135613,inst_135617);
var state_135634__$1 = (function (){var statearr_135638 = state_135634;
(statearr_135638[(7)] = inst_135618__$1);

return statearr_135638;
})();
if(cljs.core.truth_(inst_135618__$1)){
var statearr_135639_135650 = state_135634__$1;
(statearr_135639_135650[(1)] = (5));

} else {
var statearr_135640_135651 = state_135634__$1;
(statearr_135640_135651[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135635 === (5))){
var inst_135618 = (state_135634[(7)]);
var state_135634__$1 = state_135634;
var statearr_135641_135652 = state_135634__$1;
(statearr_135641_135652[(2)] = inst_135618);

(statearr_135641_135652[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135635 === (6))){
var inst_135621 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135622 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135623 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135624 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135625 = fluree.db.connection.establish_socket(inst_135621,inst_135622,inst_135623,inst_135624);
var state_135634__$1 = state_135634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135634__$1,(8),inst_135625);
} else {
if((state_val_135635 === (7))){
var inst_135630 = (state_135634[(2)]);
var state_135634__$1 = state_135634;
var statearr_135642_135653 = state_135634__$1;
(statearr_135642_135653[(2)] = inst_135630);


cljs.core.async.impl.ioc_helpers.process_exception(state_135634__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135635 === (8))){
var inst_135627 = (state_135634[(2)]);
var inst_135628 = fluree.db.util.async.throw_err(inst_135627);
var state_135634__$1 = state_135634;
var statearr_135643_135654 = state_135634__$1;
(statearr_135643_135654[(2)] = inst_135628);

(statearr_135643_135654[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$connection$get_socket_$_state_machine__109971__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__109971__auto____0 = (function (){
var statearr_135644 = [null,null,null,null,null,null,null,null];
(statearr_135644[(0)] = fluree$db$connection$get_socket_$_state_machine__109971__auto__);

(statearr_135644[(1)] = (1));

return statearr_135644;
});
var fluree$db$connection$get_socket_$_state_machine__109971__auto____1 = (function (state_135634){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135634);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135645){if((e135645 instanceof Object)){
var ex__109974__auto__ = e135645;
var statearr_135646_135655 = state_135634;
(statearr_135646_135655[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135634);

return cljs.core.cst$kw$recur;
} else {
throw e135645;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135656 = state_135634;
state_135634 = G__135656;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__109971__auto__ = function(state_135634){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__109971__auto____1.call(this,state_135634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__109971__auto____0;
fluree$db$connection$get_socket_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__109971__auto____1;
return fluree$db$connection$get_socket_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_135647 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135647[(6)] = c__110077__auto__);

return statearr_135647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e135657){if((e135657 instanceof java.lang.Exception)){
var e = e135657;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
} else {
throw e135657;

}
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4131__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,state,req_chan,publish_fn){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,state,req_chan,publish_fn){
return (function (state_135801){
var state_val_135802 = (state_135801[(1)]);
if((state_val_135802 === (7))){
var inst_135797 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135803_135879 = state_135801__$1;
(statearr_135803_135879[(2)] = inst_135797);

(statearr_135803_135879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (20))){
var inst_135700 = (state_135801[(7)]);
var inst_135705 = inst_135700.cljs$lang$protocol_mask$partition0$;
var inst_135706 = (inst_135705 & (64));
var inst_135707 = inst_135700.cljs$core$ISeq$;
var inst_135708 = (cljs.core.PROTOCOL_SENTINEL === inst_135707);
var inst_135709 = ((inst_135706) || (inst_135708));
var state_135801__$1 = state_135801;
if(cljs.core.truth_(inst_135709)){
var statearr_135804_135880 = state_135801__$1;
(statearr_135804_135880[(1)] = (23));

} else {
var statearr_135805_135881 = state_135801__$1;
(statearr_135805_135881[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (27))){
var inst_135700 = (state_135801[(7)]);
var state_135801__$1 = state_135801;
var statearr_135806_135882 = state_135801__$1;
(statearr_135806_135882[(2)] = inst_135700);

(statearr_135806_135882[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (1))){
var inst_135659 = (0);
var state_135801__$1 = (function (){var statearr_135807 = state_135801;
(statearr_135807[(8)] = inst_135659);

return statearr_135807;
})();
var statearr_135808_135883 = state_135801__$1;
(statearr_135808_135883[(2)] = null);

(statearr_135808_135883[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (24))){
var state_135801__$1 = state_135801;
var statearr_135809_135884 = state_135801__$1;
(statearr_135809_135884[(2)] = false);

(statearr_135809_135884[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (39))){
var inst_135778 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_135801__$1 = state_135801;
var statearr_135810_135885 = state_135801__$1;
(statearr_135810_135885[(2)] = inst_135778);

(statearr_135810_135885[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (4))){
var inst_135662 = (state_135801[(9)]);
var inst_135662__$1 = (state_135801[(2)]);
var state_135801__$1 = (function (){var statearr_135811 = state_135801;
(statearr_135811[(9)] = inst_135662__$1);

return statearr_135811;
})();
if(cljs.core.truth_(inst_135662__$1)){
var statearr_135812_135886 = state_135801__$1;
(statearr_135812_135886[(1)] = (5));

} else {
var statearr_135813_135887 = state_135801__$1;
(statearr_135813_135887[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (15))){
var inst_135680 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
if(cljs.core.truth_(inst_135680)){
var statearr_135814_135888 = state_135801__$1;
(statearr_135814_135888[(1)] = (16));

} else {
var statearr_135815_135889 = state_135801__$1;
(statearr_135815_135889[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (21))){
var state_135801__$1 = state_135801;
var statearr_135816_135890 = state_135801__$1;
(statearr_135816_135890[(2)] = false);

(statearr_135816_135890[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (31))){
var inst_135724 = (state_135801[(10)]);
var inst_135697 = (state_135801[(11)]);
var inst_135698 = (state_135801[(12)]);
var inst_135762 = (state_135801[(2)]);
var inst_135763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135764 = [inst_135697,inst_135724,inst_135698];
var inst_135765 = (new cljs.core.PersistentVector(null,3,(5),inst_135763,inst_135764,null));
var inst_135766 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_135765) : publish_fn.call(null,conn,inst_135765));
var state_135801__$1 = (function (){var statearr_135817 = state_135801;
(statearr_135817[(13)] = inst_135762);

return statearr_135817;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135801__$1,(32),inst_135766);
} else {
if((state_val_135802 === (32))){
var inst_135768 = (state_135801[(14)]);
var inst_135768__$1 = (state_135801[(2)]);
var inst_135769 = inst_135768__$1 === true;
var state_135801__$1 = (function (){var statearr_135818 = state_135801;
(statearr_135818[(14)] = inst_135768__$1);

return statearr_135818;
})();
if(cljs.core.truth_(inst_135769)){
var statearr_135819_135891 = state_135801__$1;
(statearr_135819_135891[(1)] = (33));

} else {
var statearr_135820_135892 = state_135801__$1;
(statearr_135820_135892[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (40))){
var state_135801__$1 = state_135801;
var statearr_135821_135893 = state_135801__$1;
(statearr_135821_135893[(1)] = (42));



return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (33))){
var state_135801__$1 = state_135801;
var statearr_135823_135894 = state_135801__$1;
(statearr_135823_135894[(2)] = null);

(statearr_135823_135894[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (13))){
var inst_135675 = (state_135801[(15)]);
var inst_135677 = fluree.db.util.async.channel_QMARK_(inst_135675);
var state_135801__$1 = state_135801;
var statearr_135824_135895 = state_135801__$1;
(statearr_135824_135895[(2)] = inst_135677);

(statearr_135824_135895[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (22))){
var inst_135716 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
if(cljs.core.truth_(inst_135716)){
var statearr_135825_135896 = state_135801__$1;
(statearr_135825_135896[(1)] = (26));

} else {
var statearr_135826_135897 = state_135801__$1;
(statearr_135826_135897[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (36))){
var inst_135768 = (state_135801[(14)]);
var inst_135774 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_135768,"Error processing message in producer."], 0));
var state_135801__$1 = state_135801;
var statearr_135827_135898 = state_135801__$1;
(statearr_135827_135898[(2)] = inst_135774);

(statearr_135827_135898[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (41))){
var inst_135786 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135828_135899 = state_135801__$1;
(statearr_135828_135899[(2)] = inst_135786);

(statearr_135828_135899[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (43))){
var state_135801__$1 = state_135801;
var statearr_135829_135900 = state_135801__$1;
(statearr_135829_135900[(2)] = null);

(statearr_135829_135900[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (29))){
var inst_135721 = (state_135801[(16)]);
var inst_135662 = (state_135801[(9)]);
var inst_135725 = (state_135801[(17)]);
var inst_135724 = (state_135801[(10)]);
var inst_135659 = (state_135801[(8)]);
var inst_135696 = (state_135801[(18)]);
var inst_135699 = (state_135801[(19)]);
var inst_135700 = (state_135801[(7)]);
var inst_135697 = (state_135801[(11)]);
var inst_135698 = (state_135801[(12)]);
var inst_135727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135728 = [cljs.core.cst$kw$pending_DASH_req,inst_135724];
var inst_135729 = (new cljs.core.PersistentVector(null,2,(5),inst_135727,inst_135728,null));
var inst_135730 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_135729,inst_135699);
var inst_135757 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_135758 = (function (){var resp_chan = inst_135699;
var timeout = inst_135725;
var i = inst_135659;
var data = inst_135698;
var _ = inst_135696;
var req_id = inst_135724;
var operation = inst_135697;
var map__135695 = inst_135721;
var msg = inst_135662;
var vec__135692 = inst_135662;
var c__110077__auto____$1 = inst_135757;
var opts = inst_135700;
return ((function (resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn){
return (function (state_135755){
var state_val_135756 = (state_135755[(1)]);
if((state_val_135756 === (1))){
var inst_135734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135735 = cljs.core.async.timeout(timeout);
var inst_135736 = [resp_chan,inst_135735];
var inst_135737 = (new cljs.core.PersistentVector(null,2,(5),inst_135734,inst_135736,null));
var state_135755__$1 = state_135755;
return cljs.core.async.ioc_alts_BANG_(state_135755__$1,(2),inst_135737);
} else {
if((state_val_135756 === (2))){
var inst_135740 = (state_135755[(7)]);
var inst_135739 = (state_135755[(2)]);
var inst_135740__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135739,(0),null);
var inst_135741 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135739,(1),null);
var inst_135742 = (function (){var vec__135731 = inst_135739;
var resp = inst_135740__$1;
var c = inst_135741;
return ((function (vec__135731,resp,c,inst_135740,inst_135739,inst_135740__$1,inst_135741,state_val_135756,resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn){
return (function (p1__135658_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__135658_SHARP_,req_id);
});
;})(vec__135731,resp,c,inst_135740,inst_135739,inst_135740__$1,inst_135741,state_val_135756,resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn))
})();
var inst_135743 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_135742);
var inst_135744 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135741,resp_chan);
var state_135755__$1 = (function (){var statearr_135830 = state_135755;
(statearr_135830[(7)] = inst_135740__$1);

(statearr_135830[(8)] = inst_135743);

return statearr_135830;
})();
if(inst_135744){
var statearr_135831_135901 = state_135755__$1;
(statearr_135831_135901[(1)] = (3));

} else {
var statearr_135832_135902 = state_135755__$1;
(statearr_135832_135902[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135756 === (3))){
var inst_135740 = (state_135755[(7)]);
var state_135755__$1 = state_135755;
var statearr_135833_135903 = state_135755__$1;
(statearr_135833_135903[(2)] = inst_135740);

(statearr_135833_135903[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135756 === (4))){
var inst_135747 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_135748 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_135749 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_135750 = cljs.core.PersistentHashMap.fromArrays(inst_135748,inst_135749);
var inst_135751 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_135747,inst_135750);
var state_135755__$1 = state_135755;
var statearr_135834_135904 = state_135755__$1;
(statearr_135834_135904[(2)] = inst_135751);

(statearr_135834_135904[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135756 === (5))){
var inst_135753 = (state_135755[(2)]);
var state_135755__$1 = state_135755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135755__$1,inst_135753);
} else {
return null;
}
}
}
}
}
});})(resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn))
;
return ((function (switch__109970__auto__,resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn){
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__109971__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__109971__auto____0 = (function (){
var statearr_135835 = [null,null,null,null,null,null,null,null,null];
(statearr_135835[(0)] = fluree$db$connection$msg_producer_$_state_machine__109971__auto__);

(statearr_135835[(1)] = (1));

return statearr_135835;
});
var fluree$db$connection$msg_producer_$_state_machine__109971__auto____1 = (function (state_135755){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135755);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135836){if((e135836 instanceof Object)){
var ex__109974__auto__ = e135836;
var statearr_135837_135905 = state_135755;
(statearr_135837_135905[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135755);

return cljs.core.cst$kw$recur;
} else {
throw e135836;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135906 = state_135755;
state_135755 = G__135906;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__109971__auto__ = function(state_135755){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__109971__auto____1.call(this,state_135755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__109971__auto____0;
fluree$db$connection$msg_producer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__109971__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn))
})();
var state__110079__auto__ = (function (){var statearr_135838 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135838[(6)] = c__110077__auto____$1);

return statearr_135838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});
;})(resp_chan,timeout,i,data,_,req_id,operation,map__135695,msg,vec__135692,c__110077__auto____$1,opts,inst_135721,inst_135662,inst_135725,inst_135724,inst_135659,inst_135696,inst_135699,inst_135700,inst_135697,inst_135698,inst_135727,inst_135728,inst_135729,inst_135730,inst_135757,state_val_135802,c__110077__auto__,state,req_chan,publish_fn))
})();
var inst_135759 = cljs.core.async.impl.dispatch.run(inst_135758);
var state_135801__$1 = (function (){var statearr_135839 = state_135801;
(statearr_135839[(20)] = inst_135759);

(statearr_135839[(21)] = inst_135730);

return statearr_135839;
})();
var statearr_135840_135907 = state_135801__$1;
(statearr_135840_135907[(2)] = inst_135757);

(statearr_135840_135907[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (44))){
var inst_135784 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135841_135908 = state_135801__$1;
(statearr_135841_135908[(2)] = inst_135784);

(statearr_135841_135908[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (6))){
var state_135801__$1 = state_135801;
var statearr_135842_135909 = state_135801__$1;
(statearr_135842_135909[(2)] = null);

(statearr_135842_135909[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (28))){
var inst_135721 = (state_135801[(16)]);
var inst_135699 = (state_135801[(19)]);
var inst_135721__$1 = (state_135801[(2)]);
var inst_135722 = fluree.db.util.core.random_uuid();
var inst_135723 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_135722);
var inst_135724 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_135721__$1,cljs.core.cst$kw$req_DASH_id,inst_135723);
var inst_135725 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_135721__$1,cljs.core.cst$kw$timeout,(60000));
var state_135801__$1 = (function (){var statearr_135843 = state_135801;
(statearr_135843[(16)] = inst_135721__$1);

(statearr_135843[(17)] = inst_135725);

(statearr_135843[(10)] = inst_135724);

return statearr_135843;
})();
if(cljs.core.truth_(inst_135699)){
var statearr_135844_135910 = state_135801__$1;
(statearr_135844_135910[(1)] = (29));

} else {
var statearr_135845_135911 = state_135801__$1;
(statearr_135845_135911[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (25))){
var inst_135713 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135846_135912 = state_135801__$1;
(statearr_135846_135912[(2)] = inst_135713);

(statearr_135846_135912[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (34))){
var inst_135768 = (state_135801[(14)]);
var inst_135772 = fluree.db.util.core.exception_QMARK_(inst_135768);
var state_135801__$1 = state_135801;
if(inst_135772){
var statearr_135847_135913 = state_135801__$1;
(statearr_135847_135913[(1)] = (36));

} else {
var statearr_135848_135914 = state_135801__$1;
(statearr_135848_135914[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (17))){
var inst_135664 = (state_135801[(22)]);
var inst_135662 = (state_135801[(9)]);
var inst_135684 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_135662], 0));
var inst_135685 = ["Error processing ledger request, no valid return channel: ",inst_135684].join('');
var inst_135686 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_135664,inst_135685], 0));
var state_135801__$1 = state_135801;
var statearr_135849_135915 = state_135801__$1;
(statearr_135849_135915[(2)] = inst_135686);

(statearr_135849_135915[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (3))){
var inst_135799 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_135801__$1,inst_135799);
} else {
if((state_val_135802 === (12))){
var inst_135675 = (state_135801[(15)]);
var inst_135672 = (state_135801[(2)]);
var inst_135673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135672,(0),null);
var inst_135674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135672,(1),null);
var inst_135675__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135672,(2),null);
var state_135801__$1 = (function (){var statearr_135850 = state_135801;
(statearr_135850[(15)] = inst_135675__$1);

(statearr_135850[(23)] = inst_135673);

(statearr_135850[(24)] = inst_135674);

return statearr_135850;
})();
if(cljs.core.truth_(inst_135675__$1)){
var statearr_135851_135916 = state_135801__$1;
(statearr_135851_135916[(1)] = (13));

} else {
var statearr_135852_135917 = state_135801__$1;
(statearr_135852_135917[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (2))){
var state_135801__$1 = state_135801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_135801__$1,(4),req_chan);
} else {
if((state_val_135802 === (23))){
var state_135801__$1 = state_135801;
var statearr_135853_135918 = state_135801__$1;
(statearr_135853_135918[(2)] = true);

(statearr_135853_135918[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (35))){
var inst_135790 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135854_135919 = state_135801__$1;
(statearr_135854_135919[(2)] = inst_135790);


cljs.core.async.impl.ioc_helpers.process_exception(state_135801__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (19))){
var inst_135662 = (state_135801[(9)]);
var inst_135700 = (state_135801[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_135801,(9),java.lang.Exception,null,(8));
var inst_135696 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_135662], 0));
var inst_135697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135662,(0),null);
var inst_135698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135662,(1),null);
var inst_135699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135662,(2),null);
var inst_135700__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135662,(3),null);
var inst_135702 = (inst_135700__$1 == null);
var inst_135703 = cljs.core.not(inst_135702);
var state_135801__$1 = (function (){var statearr_135855 = state_135801;
(statearr_135855[(18)] = inst_135696);

(statearr_135855[(19)] = inst_135699);

(statearr_135855[(7)] = inst_135700__$1);

(statearr_135855[(11)] = inst_135697);

(statearr_135855[(12)] = inst_135698);

return statearr_135855;
})();
if(inst_135703){
var statearr_135856_135920 = state_135801__$1;
(statearr_135856_135920[(1)] = (20));

} else {
var statearr_135857_135921 = state_135801__$1;
(statearr_135857_135921[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (11))){
var state_135801__$1 = state_135801;
var statearr_135858_135922 = state_135801__$1;
(statearr_135858_135922[(2)] = null);

(statearr_135858_135922[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (9))){
var inst_135662 = (state_135801[(9)]);
var inst_135664 = (state_135801[(2)]);
var inst_135668 = cljs.core.sequential_QMARK_(inst_135662);
var state_135801__$1 = (function (){var statearr_135859 = state_135801;
(statearr_135859[(22)] = inst_135664);

return statearr_135859;
})();
if(inst_135668){
var statearr_135860_135923 = state_135801__$1;
(statearr_135860_135923[(1)] = (10));

} else {
var statearr_135861_135924 = state_135801__$1;
(statearr_135861_135924[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (5))){
var state_135801__$1 = state_135801;
var statearr_135862_135925 = state_135801__$1;
(statearr_135862_135925[(2)] = null);

(statearr_135862_135925[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (14))){
var inst_135675 = (state_135801[(15)]);
var state_135801__$1 = state_135801;
var statearr_135863_135926 = state_135801__$1;
(statearr_135863_135926[(2)] = inst_135675);

(statearr_135863_135926[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (26))){
var inst_135700 = (state_135801[(7)]);
var inst_135718 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_135700);
var state_135801__$1 = state_135801;
var statearr_135864_135927 = state_135801__$1;
(statearr_135864_135927[(2)] = inst_135718);

(statearr_135864_135927[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (16))){
var inst_135664 = (state_135801[(22)]);
var inst_135675 = (state_135801[(15)]);
var inst_135682 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_135675,inst_135664);
var state_135801__$1 = state_135801;
var statearr_135865_135928 = state_135801__$1;
(statearr_135865_135928[(2)] = inst_135682);

(statearr_135865_135928[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (38))){
var inst_135788 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135866_135929 = state_135801__$1;
(statearr_135866_135929[(2)] = inst_135788);

(statearr_135866_135929[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (30))){
var state_135801__$1 = state_135801;
var statearr_135867_135930 = state_135801__$1;
(statearr_135867_135930[(2)] = null);

(statearr_135867_135930[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (10))){
var inst_135662 = (state_135801[(9)]);
var state_135801__$1 = state_135801;
var statearr_135868_135931 = state_135801__$1;
(statearr_135868_135931[(2)] = inst_135662);

(statearr_135868_135931[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (18))){
var inst_135688 = (state_135801[(2)]);
var state_135801__$1 = state_135801;
var statearr_135869_135932 = state_135801__$1;
(statearr_135869_135932[(2)] = inst_135688);


cljs.core.async.impl.ioc_helpers.process_exception(state_135801__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (42))){
var inst_135768 = (state_135801[(14)]);
var inst_135781 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_135768], 0));
var state_135801__$1 = state_135801;
var statearr_135870_135933 = state_135801__$1;
(statearr_135870_135933[(2)] = inst_135781);

(statearr_135870_135933[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (37))){
var inst_135768 = (state_135801[(14)]);
var inst_135776 = (inst_135768 == null);
var state_135801__$1 = state_135801;
if(cljs.core.truth_(inst_135776)){
var statearr_135871_135934 = state_135801__$1;
(statearr_135871_135934[(1)] = (39));

} else {
var statearr_135872_135935 = state_135801__$1;
(statearr_135872_135935[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_135802 === (8))){
var inst_135659 = (state_135801[(8)]);
var inst_135792 = (state_135801[(2)]);
var inst_135793 = (inst_135659 + (1));
var inst_135659__$1 = inst_135793;
var state_135801__$1 = (function (){var statearr_135873 = state_135801;
(statearr_135873[(8)] = inst_135659__$1);

(statearr_135873[(25)] = inst_135792);

return statearr_135873;
})();
var statearr_135874_135936 = state_135801__$1;
(statearr_135874_135936[(2)] = null);

(statearr_135874_135936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,state,req_chan,publish_fn))
;
return ((function (switch__109970__auto__,c__110077__auto__,state,req_chan,publish_fn){
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__109971__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__109971__auto____0 = (function (){
var statearr_135875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_135875[(0)] = fluree$db$connection$msg_producer_$_state_machine__109971__auto__);

(statearr_135875[(1)] = (1));

return statearr_135875;
});
var fluree$db$connection$msg_producer_$_state_machine__109971__auto____1 = (function (state_135801){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_135801);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e135876){if((e135876 instanceof Object)){
var ex__109974__auto__ = e135876;
var statearr_135877_135937 = state_135801;
(statearr_135877_135937[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_135801);

return cljs.core.cst$kw$recur;
} else {
throw e135876;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__135938 = state_135801;
state_135801 = G__135938;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__109971__auto__ = function(state_135801){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__109971__auto____1.call(this,state_135801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__109971__auto____0;
fluree$db$connection$msg_producer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__109971__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,state,req_chan,publish_fn))
})();
var state__110079__auto__ = (function (){var statearr_135878 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_135878[(6)] = c__110077__auto__);

return statearr_135878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,state,req_chan,publish_fn))
);

return c__110077__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__135939 = conn;
var map__135939__$1 = (((((!((map__135939 == null))))?(((((map__135939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__135939.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__135939):map__135939);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__135939__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan){
return (function (state_136022){
var state_val_136023 = (state_136022[(1)]);
if((state_val_136023 === (7))){
var inst_136018 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136024_136074 = state_136022__$1;
(statearr_136024_136074[(2)] = inst_136018);

(statearr_136024_136074[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (20))){
var inst_135959 = (state_136022[(7)]);
var inst_135973 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_135974 = [inst_135959];
var inst_135975 = cljs.core.PersistentHashMap.fromArrays(inst_135973,inst_135974);
var inst_135976 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_135975], 0));
var state_136022__$1 = state_136022;
var statearr_136025_136075 = state_136022__$1;
(statearr_136025_136075[(2)] = inst_135976);

(statearr_136025_136075[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (27))){
var state_136022__$1 = state_136022;
var statearr_136026_136076 = state_136022__$1;
(statearr_136026_136076[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (1))){
var inst_135941 = (0);
var state_136022__$1 = (function (){var statearr_136028 = state_136022;
(statearr_136028[(8)] = inst_135941);

return statearr_136028;
})();
var statearr_136029_136077 = state_136022__$1;
(statearr_136029_136077[(2)] = null);

(statearr_136029_136077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (24))){
var inst_135952 = (state_136022[(9)]);
var inst_136001 = fluree.db.util.core.exception_QMARK_(inst_135952);
var state_136022__$1 = state_136022;
if(inst_136001){
var statearr_136030_136078 = state_136022__$1;
(statearr_136030_136078[(1)] = (26));

} else {
var statearr_136031_136079 = state_136022__$1;
(statearr_136031_136079[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (4))){
var inst_135946 = (state_136022[(10)]);
var inst_135951 = (state_136022[(2)]);
var inst_135952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135951,(0),null);
var inst_135953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_135951,(1),null);
var inst_135954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_135953,inst_135946);
var state_136022__$1 = (function (){var statearr_136032 = state_136022;
(statearr_136032[(9)] = inst_135952);

return statearr_136032;
})();
if(inst_135954){
var statearr_136033_136080 = state_136022__$1;
(statearr_136033_136080[(1)] = (5));

} else {
var statearr_136034_136081 = state_136022__$1;
(statearr_136034_136081[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (15))){
var inst_135959 = (state_136022[(7)]);
var inst_135968 = typeof inst_135959 === 'string';
var state_136022__$1 = state_136022;
if(cljs.core.truth_(inst_135968)){
var statearr_136035_136082 = state_136022__$1;
(statearr_136035_136082[(1)] = (17));

} else {
var statearr_136036_136083 = state_136022__$1;
(statearr_136036_136083[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (21))){
var state_136022__$1 = state_136022;
var statearr_136037_136084 = state_136022__$1;
(statearr_136037_136084[(2)] = null);

(statearr_136037_136084[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (31))){
var inst_136012 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136038_136085 = state_136022__$1;
(statearr_136038_136085[(2)] = inst_136012);

(statearr_136038_136085[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (13))){
var inst_135985 = (state_136022[(2)]);
var inst_135986 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135987 = fluree.db.connection.close_websocket(inst_135986);
var inst_135988 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135989 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_135988);
var state_136022__$1 = (function (){var statearr_136039 = state_136022;
(statearr_136039[(11)] = inst_135987);

(statearr_136039[(12)] = inst_135985);

return statearr_136039;
})();
var statearr_136040_136086 = state_136022__$1;
(statearr_136040_136086[(2)] = inst_135989);

(statearr_136040_136086[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (22))){
var inst_135979 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136041_136087 = state_136022__$1;
(statearr_136041_136087[(2)] = inst_135979);

(statearr_136041_136087[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (29))){
var inst_135952 = (state_136022[(9)]);
var inst_136007 = fluree.db.util.json.parse(inst_135952);
var inst_136008 = fluree.db.connection.process_events(conn,inst_136007);
var inst_135941 = (0);
var state_136022__$1 = (function (){var statearr_136042 = state_136022;
(statearr_136042[(13)] = inst_136008);

(statearr_136042[(8)] = inst_135941);

return statearr_136042;
})();
var statearr_136043_136088 = state_136022__$1;
(statearr_136043_136088[(2)] = null);

(statearr_136043_136088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (6))){
var inst_135952 = (state_136022[(9)]);
var inst_135997 = (inst_135952 == null);
var state_136022__$1 = state_136022;
if(cljs.core.truth_(inst_135997)){
var statearr_136044_136089 = state_136022__$1;
(statearr_136044_136089[(1)] = (23));

} else {
var statearr_136045_136090 = state_136022__$1;
(statearr_136045_136090[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (28))){
var inst_136014 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136046_136091 = state_136022__$1;
(statearr_136046_136091[(2)] = inst_136014);

(statearr_136046_136091[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (25))){
var inst_136016 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136047_136092 = state_136022__$1;
(statearr_136047_136092[(2)] = inst_136016);

(statearr_136047_136092[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (17))){
var inst_135959 = (state_136022[(7)]);
var inst_135970 = cljs.core.eval(inst_135959);
var state_136022__$1 = state_136022;
var statearr_136048_136093 = state_136022__$1;
(statearr_136048_136093[(2)] = inst_135970);

(statearr_136048_136093[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (3))){
var inst_136020 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_136022__$1,inst_136020);
} else {
if((state_val_136023 === (12))){
var inst_135959 = (state_136022[(7)]);
var inst_135964 = cljs.core.fn_QMARK_(inst_135959);
var state_136022__$1 = state_136022;
if(inst_135964){
var statearr_136049_136094 = state_136022__$1;
(statearr_136049_136094[(1)] = (14));

} else {
var statearr_136050_136095 = state_136022__$1;
(statearr_136050_136095[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (2))){
var inst_135946 = (state_136022[(10)]);
var inst_135946__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_135947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_135948 = [sub_chan,inst_135946__$1];
var inst_135949 = (new cljs.core.PersistentVector(null,2,(5),inst_135947,inst_135948,null));
var state_136022__$1 = (function (){var statearr_136051 = state_136022;
(statearr_136051[(10)] = inst_135946__$1);

return statearr_136051;
})();
return cljs.core.async.ioc_alts_BANG_(state_136022__$1,(4),inst_135949);
} else {
if((state_val_136023 === (23))){
var inst_135999 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_136022__$1 = state_136022;
var statearr_136052_136096 = state_136022__$1;
(statearr_136052_136096[(2)] = inst_135999);

(statearr_136052_136096[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (19))){
var inst_135981 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136053_136097 = state_136022__$1;
(statearr_136053_136097[(2)] = inst_135981);

(statearr_136053_136097[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (11))){
var inst_135962 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_136022__$1 = state_136022;
var statearr_136054_136098 = state_136022__$1;
(statearr_136054_136098[(2)] = inst_135962);

(statearr_136054_136098[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (9))){
var inst_135941 = (state_136022[(8)]);
var inst_135991 = fluree.db.connection.ping_transactor(conn);
var inst_135992 = (inst_135941 + (1));
var inst_135941__$1 = inst_135992;
var state_136022__$1 = (function (){var statearr_136055 = state_136022;
(statearr_136055[(14)] = inst_135991);

(statearr_136055[(8)] = inst_135941__$1);

return statearr_136055;
})();
var statearr_136056_136099 = state_136022__$1;
(statearr_136056_136099[(2)] = null);

(statearr_136056_136099[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (5))){
var inst_135941 = (state_136022[(8)]);
var inst_135956 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_135941);
var state_136022__$1 = state_136022;
if(inst_135956){
var statearr_136057_136100 = state_136022__$1;
(statearr_136057_136100[(1)] = (8));

} else {
var statearr_136058_136101 = state_136022__$1;
(statearr_136058_136101[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (14))){
var inst_135959 = (state_136022[(7)]);
var inst_135966 = (inst_135959.cljs$core$IFn$_invoke$arity$0 ? inst_135959.cljs$core$IFn$_invoke$arity$0() : inst_135959.call(null));
var state_136022__$1 = state_136022;
var statearr_136059_136102 = state_136022__$1;
(statearr_136059_136102[(2)] = inst_135966);

(statearr_136059_136102[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (26))){
var inst_135952 = (state_136022[(9)]);
var inst_136003 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_135952], 0));
var inst_135941 = (0);
var state_136022__$1 = (function (){var statearr_136060 = state_136022;
(statearr_136060[(8)] = inst_135941);

(statearr_136060[(15)] = inst_136003);

return statearr_136060;
})();
var statearr_136061_136103 = state_136022__$1;
(statearr_136061_136103[(2)] = null);

(statearr_136061_136103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (16))){
var inst_135983 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136062_136104 = state_136022__$1;
(statearr_136062_136104[(2)] = inst_135983);

(statearr_136062_136104[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (30))){
var state_136022__$1 = state_136022;
var statearr_136063_136105 = state_136022__$1;
(statearr_136063_136105[(2)] = null);

(statearr_136063_136105[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (10))){
var inst_135995 = (state_136022[(2)]);
var state_136022__$1 = state_136022;
var statearr_136064_136106 = state_136022__$1;
(statearr_136064_136106[(2)] = inst_135995);

(statearr_136064_136106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (18))){
var state_136022__$1 = state_136022;
var statearr_136065_136107 = state_136022__$1;
(statearr_136065_136107[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_136023 === (8))){
var inst_135959 = (state_136022[(7)]);
var inst_135958 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_135959__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_135960 = (inst_135959__$1 == null);
var state_136022__$1 = (function (){var statearr_136067 = state_136022;
(statearr_136067[(7)] = inst_135959__$1);

(statearr_136067[(16)] = inst_135958);

return statearr_136067;
})();
if(cljs.core.truth_(inst_135960)){
var statearr_136068_136108 = state_136022__$1;
(statearr_136068_136108[(1)] = (11));

} else {
var statearr_136069_136109 = state_136022__$1;
(statearr_136069_136109[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan))
;
return ((function (switch__109970__auto__,c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan){
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__109971__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__109971__auto____0 = (function (){
var statearr_136070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_136070[(0)] = fluree$db$connection$msg_consumer_$_state_machine__109971__auto__);

(statearr_136070[(1)] = (1));

return statearr_136070;
});
var fluree$db$connection$msg_consumer_$_state_machine__109971__auto____1 = (function (state_136022){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_136022);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e136071){if((e136071 instanceof Object)){
var ex__109974__auto__ = e136071;
var statearr_136072_136110 = state_136022;
(statearr_136072_136110[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_136022);

return cljs.core.cst$kw$recur;
} else {
throw e136071;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__136111 = state_136022;
state_136022 = G__136111;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__109971__auto__ = function(state_136022){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__109971__auto____1.call(this,state_136022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__109971__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__109971__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan))
})();
var state__110079__auto__ = (function (){var statearr_136073 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_136073[(6)] = c__110077__auto__);

return statearr_136073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,ping_transactor_after,map__135939,map__135939__$1,sub_chan))
);

return c__110077__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__136113 = arguments.length;
switch (G__136113) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
});

fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__136114 = opts;
var map__136114__$1 = (((((!((map__136114 == null))))?(((((map__136114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__136114.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__136114):map__136114);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136114__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136114__$1,cljs.core.cst$kw$jwt);
return ((function (map__136114,map__136114__$1,private$,jwt){
return (function (k){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__136114,map__136114__$1,private$,jwt){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__136114,map__136114__$1,private$,jwt){
return (function (state_136173){
var state_val_136174 = (state_136173[(1)]);
if((state_val_136174 === (7))){
var inst_136128 = (state_136173[(2)]);
var inst_136129 = clojure.string.replace(k,"_","/");
var inst_136130 = fluree.db.connection.get_server(conn_id,servers);
var state_136173__$1 = (function (){var statearr_136175 = state_136173;
(statearr_136175[(7)] = inst_136129);

(statearr_136175[(8)] = inst_136128);

return statearr_136175;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_136173__$1,(8),inst_136130);
} else {
if((state_val_136174 === (20))){
var inst_136133 = (state_136173[(9)]);
var inst_136162 = (state_136173[(2)]);
var inst_136163 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_136164 = [(5000),inst_136162,cljs.core.cst$kw$text];
var inst_136165 = cljs.core.PersistentHashMap.fromArrays(inst_136163,inst_136164);
var inst_136166 = fluree.db.util.xhttp.get(inst_136133,inst_136165);
var state_136173__$1 = state_136173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_136173__$1,(21),inst_136166);
} else {
if((state_val_136174 === (1))){
var state_136173__$1 = state_136173;
var statearr_136176_136208 = state_136173__$1;
(statearr_136176_136208[(2)] = null);

(statearr_136176_136208[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_136173,(3),Error,null,(2));
var state_136173__$1 = state_136173;
if(cljs.core.truth_(jwt)){
var statearr_136177_136209 = state_136173__$1;
(statearr_136177_136209[(1)] = (5));

} else {
var statearr_136178_136210 = state_136173__$1;
(statearr_136178_136210[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (15))){
var inst_136147 = (state_136173[(10)]);
var inst_136128 = (state_136173[(8)]);
var inst_136149 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_136128)].join('');
var inst_136150 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_136147,"Authorization",inst_136149);
var state_136173__$1 = state_136173;
var statearr_136179_136211 = state_136173__$1;
(statearr_136179_136211[(2)] = inst_136150);

(statearr_136179_136211[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (21))){
var inst_136168 = (state_136173[(2)]);
var inst_136169 = fluree.db.util.async.throw_err(inst_136168);
var state_136173__$1 = state_136173;
var statearr_136180_136212 = state_136173__$1;
(statearr_136180_136212[(2)] = inst_136169);


cljs.core.async.impl.ioc_helpers.process_exception(state_136173__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (13))){
var inst_136142 = (state_136173[(11)]);
var state_136173__$1 = state_136173;
var statearr_136181_136213 = state_136173__$1;
(statearr_136181_136213[(2)] = inst_136142);

(statearr_136181_136213[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (6))){
var inst_136122 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_136123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_136124 = [conn_id,cljs.core.cst$kw$token];
var inst_136125 = (new cljs.core.PersistentVector(null,2,(5),inst_136123,inst_136124,null));
var inst_136126 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_136122,inst_136125);
var state_136173__$1 = state_136173;
var statearr_136182_136214 = state_136173__$1;
(statearr_136182_136214[(2)] = inst_136126);

(statearr_136182_136214[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (17))){
var inst_136153 = (state_136173[(2)]);
var state_136173__$1 = (function (){var statearr_136183 = state_136173;
(statearr_136183[(12)] = inst_136153);

return statearr_136183;
})();
if(cljs.core.truth_(private$)){
var statearr_136184_136215 = state_136173__$1;
(statearr_136184_136215[(1)] = (18));

} else {
var statearr_136185_136216 = state_136173__$1;
(statearr_136185_136216[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (3))){
var inst_136116 = (state_136173[(2)]);
var state_136173__$1 = state_136173;
var statearr_136186_136217 = state_136173__$1;
(statearr_136186_136217[(2)] = inst_136116);


cljs.core.async.impl.ioc_helpers.process_exception(state_136173__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (12))){
var inst_136142 = (state_136173[(11)]);
var inst_136128 = (state_136173[(8)]);
var inst_136144 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_136142,"X-fdb-jwt",inst_136128);
var state_136173__$1 = state_136173;
var statearr_136187_136218 = state_136173__$1;
(statearr_136187_136218[(2)] = inst_136144);

(statearr_136187_136218[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (2))){
var inst_136171 = (state_136173[(2)]);
var state_136173__$1 = state_136173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_136173__$1,inst_136171);
} else {
if((state_val_136174 === (19))){
var inst_136153 = (state_136173[(12)]);
var state_136173__$1 = state_136173;
var statearr_136188_136219 = state_136173__$1;
(statearr_136188_136219[(2)] = inst_136153);

(statearr_136188_136219[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (11))){
var inst_136128 = (state_136173[(8)]);
var inst_136142 = (state_136173[(2)]);
var state_136173__$1 = (function (){var statearr_136189 = state_136173;
(statearr_136189[(11)] = inst_136142);

return statearr_136189;
})();
if(cljs.core.truth_(inst_136128)){
var statearr_136190_136220 = state_136173__$1;
(statearr_136190_136220[(1)] = (12));

} else {
var statearr_136191_136221 = state_136173__$1;
(statearr_136191_136221[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (9))){
var inst_136137 = (state_136173[(13)]);
var inst_136139 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_136137,"X-fdb-pri",private$);
var state_136173__$1 = state_136173;
var statearr_136192_136222 = state_136173__$1;
(statearr_136192_136222[(2)] = inst_136139);

(statearr_136192_136222[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (5))){
var state_136173__$1 = state_136173;
var statearr_136193_136223 = state_136173__$1;
(statearr_136193_136223[(2)] = jwt);

(statearr_136193_136223[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (14))){
var inst_136128 = (state_136173[(8)]);
var inst_136147 = (state_136173[(2)]);
var state_136173__$1 = (function (){var statearr_136194 = state_136173;
(statearr_136194[(10)] = inst_136147);

return statearr_136194;
})();
if(cljs.core.truth_(inst_136128)){
var statearr_136195_136224 = state_136173__$1;
(statearr_136195_136224[(1)] = (15));

} else {
var statearr_136196_136225 = state_136173__$1;
(statearr_136196_136225[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (16))){
var inst_136147 = (state_136173[(10)]);
var state_136173__$1 = state_136173;
var statearr_136197_136226 = state_136173__$1;
(statearr_136197_136226[(2)] = inst_136147);

(statearr_136197_136226[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (10))){
var inst_136137 = (state_136173[(13)]);
var state_136173__$1 = state_136173;
var statearr_136198_136227 = state_136173__$1;
(statearr_136198_136227[(2)] = inst_136137);

(statearr_136198_136227[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (18))){
var inst_136153 = (state_136173[(12)]);
var inst_136133 = (state_136173[(9)]);
var inst_136155 = [cljs.core.cst$kw$headers];
var inst_136156 = [inst_136153];
var inst_136157 = cljs.core.PersistentHashMap.fromArrays(inst_136155,inst_136156);
var inst_136158 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_136133,inst_136157,private$);
var inst_136159 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_136158);
var state_136173__$1 = state_136173;
var statearr_136199_136228 = state_136173__$1;
(statearr_136199_136228[(2)] = inst_136159);

(statearr_136199_136228[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136174 === (8))){
var inst_136129 = (state_136173[(7)]);
var inst_136132 = (state_136173[(2)]);
var inst_136133 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_136132),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_136129)].join('');
var inst_136135 = ["Accept"];
var inst_136136 = ["application/json"];
var inst_136137 = cljs.core.PersistentHashMap.fromArrays(inst_136135,inst_136136);
var state_136173__$1 = (function (){var statearr_136200 = state_136173;
(statearr_136200[(9)] = inst_136133);

(statearr_136200[(13)] = inst_136137);

return statearr_136200;
})();
if(cljs.core.truth_(private$)){
var statearr_136201_136229 = state_136173__$1;
(statearr_136201_136229[(1)] = (9));

} else {
var statearr_136202_136230 = state_136173__$1;
(statearr_136202_136230[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__136114,map__136114__$1,private$,jwt))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__136114,map__136114__$1,private$,jwt){
return (function() {
var fluree$db$connection$state_machine__109971__auto__ = null;
var fluree$db$connection$state_machine__109971__auto____0 = (function (){
var statearr_136203 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_136203[(0)] = fluree$db$connection$state_machine__109971__auto__);

(statearr_136203[(1)] = (1));

return statearr_136203;
});
var fluree$db$connection$state_machine__109971__auto____1 = (function (state_136173){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_136173);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e136204){if((e136204 instanceof Object)){
var ex__109974__auto__ = e136204;
var statearr_136205_136231 = state_136173;
(statearr_136205_136231[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_136173);

return cljs.core.cst$kw$recur;
} else {
throw e136204;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__136232 = state_136173;
state_136173 = G__136232;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$state_machine__109971__auto__ = function(state_136173){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__109971__auto____1.call(this,state_136173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__109971__auto____0;
fluree$db$connection$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__109971__auto____1;
return fluree$db$connection$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__136114,map__136114__$1,private$,jwt))
})();
var state__110079__auto__ = (function (){var statearr_136206 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_136206[(6)] = c__110077__auto__);

return statearr_136206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__136114,map__136114__$1,private$,jwt))
);

return c__110077__auto__;
});
;})(map__136114,map__136114__$1,private$,jwt))
});

fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3;

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn_state){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(conn_state));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__136233_SHARP_){
if(cljs.core.truth_(p1__136233_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__136234 = opts;
var map__136234__$1 = (((((!((map__136234 == null))))?(((((map__136234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__136234.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__136234):map__136234);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__136234__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$storage_DASH_write,((function (state_atom,map__136234,map__136234__$1,sub_chan,storage_rename,keep_alive_fn,publish,close_fn,default_network,object_cache,transact_handler,parallelism,meta,tx_private_key,private$,storage_read,transactor_QMARK_,serializer,memory,storage_exists){
return (function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(state_atom,map__136234,map__136234__$1,sub_chan,storage_rename,keep_alive_fn,publish,close_fn,default_network,object_cache,transact_handler,parallelism,meta,tx_private_key,private$,storage_read,transactor_QMARK_,serializer,memory,storage_exists))
);
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__136234__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4131__auto__ = object_cache;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = ((function (state_atom,map__136234,map__136234__$1,sub_chan,storage_rename,keep_alive_fn,publish,close_fn,default_network,object_cache,transact_handler,parallelism,meta,tx_private_key,private$,storage_read,transactor_QMARK_,serializer,memory,storage_exists,storage_write,memory_QMARK_,req_chan,pub_chan,private_key_file,memory_object_size,_,default_cache_atom,object_cache_fn,conn_id){
return (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});})(state_atom,map__136234,map__136234__$1,sub_chan,storage_rename,keep_alive_fn,publish,close_fn,default_network,object_cache,transact_handler,parallelism,meta,tx_private_key,private$,storage_read,transactor_QMARK_,serializer,memory,storage_exists,storage_write,memory_QMARK_,req_chan,pub_chan,private_key_file,memory_object_size,_,default_cache_atom,object_cache_fn,conn_id))
;
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4131__auto__ = storage_read;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4131__auto__ = storage_exists;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = storage_read;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4120__auto__ = storage_write;
if(cljs.core.truth_(and__4120__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4120__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),((function (conn_id){
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
});})(conn_id))
);

return true;
}catch (e136236){var _ = e136236;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__136237_136238 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__136237_136238.cljs$core$IFn$_invoke$arity$0 ? fexpr__136237_136238.cljs$core$IFn$_invoke$arity$0() : fexpr__136237_136238.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___136270 = arguments.length;
var i__4731__auto___136271 = (0);
while(true){
if((i__4731__auto___136271 < len__4730__auto___136270)){
args__4736__auto__.push((arguments[i__4731__auto___136271]));

var G__136272 = (i__4731__auto___136271 + (1));
i__4731__auto___136271 = G__136272;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__136241){
var vec__136242 = p__136241;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__136242,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(conn));
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__110077__auto___136273 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts){
return (function (state_136259){
var state_val_136260 = (state_136259[(1)]);
if((state_val_136260 === (1))){
var inst_136245 = fluree.db.connection.get_socket(conn);
var state_136259__$1 = state_136259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_136259__$1,(2),inst_136245);
} else {
if((state_val_136260 === (2))){
var inst_136247 = (state_136259[(2)]);
var inst_136248 = (inst_136247 == null);
var inst_136249 = fluree.db.util.core.exception_QMARK_(inst_136247);
var inst_136250 = ((inst_136248) || (inst_136249));
var state_136259__$1 = state_136259;
if(cljs.core.truth_(inst_136250)){
var statearr_136261_136274 = state_136259__$1;
(statearr_136261_136274[(1)] = (3));

} else {
var statearr_136262_136275 = state_136259__$1;
(statearr_136262_136275[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_136260 === (3))){
var inst_136252 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_136253 = cljs.core.async.close_BANG_(conn);
var state_136259__$1 = (function (){var statearr_136263 = state_136259;
(statearr_136263[(7)] = inst_136252);

return statearr_136263;
})();
var statearr_136264_136276 = state_136259__$1;
(statearr_136264_136276[(2)] = inst_136253);

(statearr_136264_136276[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136260 === (4))){
var inst_136255 = fluree.db.connection.msg_consumer(conn);
var state_136259__$1 = state_136259;
var statearr_136265_136277 = state_136259__$1;
(statearr_136265_136277[(2)] = inst_136255);

(statearr_136265_136277[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_136260 === (5))){
var inst_136257 = (state_136259[(2)]);
var state_136259__$1 = state_136259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_136259__$1,inst_136257);
} else {
return null;
}
}
}
}
}
});})(c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts))
;
return ((function (switch__109970__auto__,c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts){
return (function() {
var fluree$db$connection$state_machine__109971__auto__ = null;
var fluree$db$connection$state_machine__109971__auto____0 = (function (){
var statearr_136266 = [null,null,null,null,null,null,null,null];
(statearr_136266[(0)] = fluree$db$connection$state_machine__109971__auto__);

(statearr_136266[(1)] = (1));

return statearr_136266;
});
var fluree$db$connection$state_machine__109971__auto____1 = (function (state_136259){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_136259);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e136267){if((e136267 instanceof Object)){
var ex__109974__auto__ = e136267;
var statearr_136268_136278 = state_136259;
(statearr_136268_136278[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_136259);

return cljs.core.cst$kw$recur;
} else {
throw e136267;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__136279 = state_136259;
state_136259 = G__136279;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$connection$state_machine__109971__auto__ = function(state_136259){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__109971__auto____1.call(this,state_136259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__109971__auto____0;
fluree$db$connection$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__109971__auto____1;
return fluree$db$connection$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts))
})();
var state__110079__auto__ = (function (){var statearr_136269 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_136269[(6)] = c__110077__auto___136273);

return statearr_136269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___136273,conn,transactor_QMARK_,dev_QMARK_,vec__136242,opts))
);

}

fluree.db.connection.msg_producer(conn);

return conn;
});

fluree.db.connection.connect.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.connection.connect.cljs$lang$applyTo = (function (seq136239){
var G__136240 = cljs.core.first(seq136239);
var seq136239__$1 = cljs.core.next(seq136239);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__136240,seq136239__$1);
});

