// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k115535,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__115539 = k115535;
var G__115539__$1 = (((G__115539 instanceof cljs.core.Keyword))?G__115539.fqn:null);
switch (G__115539__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k115535,else__4388__auto__);

}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__115540){
var vec__115541 = p__115540;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115541,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115541,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__115534){
var self__ = this;
var G__115534__$1 = this;
return (new cljs.core.RecordIter((0),G__115534__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__115544 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__115544(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this115536,other115537){
var self__ = this;
var this115536__$1 = this;
return (((!((other115537 == null)))) && ((this115536__$1.constructor === other115537.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115536__$1.index_type,other115537.index_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115536__$1.comparator,other115537.comparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115536__$1.historyComparator,other115537.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115536__$1.__extmap,other115537.__extmap)));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__115534){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__115545 = cljs.core.keyword_identical_QMARK_;
var expr__115546 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__115548 = cljs.core.cst$kw$index_DASH_type;
var G__115549 = expr__115546;
return (pred__115545.cljs$core$IFn$_invoke$arity$2 ? pred__115545.cljs$core$IFn$_invoke$arity$2(G__115548,G__115549) : pred__115545.call(null,G__115548,G__115549));
})())){
return (new fluree.db.index.IndexConfig(G__115534,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115550 = cljs.core.cst$kw$comparator;
var G__115551 = expr__115546;
return (pred__115545.cljs$core$IFn$_invoke$arity$2 ? pred__115545.cljs$core$IFn$_invoke$arity$2(G__115550,G__115551) : pred__115545.call(null,G__115550,G__115551));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__115534,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115552 = cljs.core.cst$kw$historyComparator;
var G__115553 = expr__115546;
return (pred__115545.cljs$core$IFn$_invoke$arity$2 ? pred__115545.cljs$core$IFn$_invoke$arity$2(G__115552,G__115553) : pred__115545.call(null,G__115552,G__115553));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__115534,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__115534),null));
}
}
}
});

fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
});

fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__115534){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__115534,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
});

fluree.db.index.IndexConfig.cljs$lang$type = true;

fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
});

fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/IndexConfig");
});

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__115538){
var extmap__4424__auto__ = (function (){var G__115554 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__115538,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__115538)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__115554);
} else {
return G__115554;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__115538),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__115538),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__115538),null,cljs.core.not_empty(extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k115557,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__115561 = k115557;
var G__115561__$1 = (((G__115561 instanceof cljs.core.Keyword))?G__115561.fqn:null);
switch (G__115561__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k115557,else__4388__auto__);

}
});

fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__115562){
var vec__115563 = p__115562;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115563,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115563,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
});

fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__115556){
var self__ = this;
var G__115556__$1 = this;
return (new cljs.core.RecordIter((0),G__115556__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_115567){
var state_val_115568 = (state_115567[(1)]);
if((state_val_115568 === (1))){
var state_115567__$1 = state_115567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115567__$1,this$__$1);
} else {
return null;
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__109971__auto__ = null;
var fluree$db$index$state_machine__109971__auto____0 = (function (){
var statearr_115569 = [null,null,null,null,null,null,null];
(statearr_115569[(0)] = fluree$db$index$state_machine__109971__auto__);

(statearr_115569[(1)] = (1));

return statearr_115569;
});
var fluree$db$index$state_machine__109971__auto____1 = (function (state_115567){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115567);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115570){if((e115570 instanceof Object)){
var ex__109974__auto__ = e115570;
var statearr_115571_115661 = state_115567;
(statearr_115571_115661[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115567);

return cljs.core.cst$kw$recur;
} else {
throw e115570;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115662 = state_115567;
state_115567 = G__115662;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$index$state_machine__109971__auto__ = function(state_115567){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__109971__auto____1.call(this,state_115567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__109971__auto____0;
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__109971__auto____1;
return fluree$db$index$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_115572 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115572[(6)] = c__110077__auto__);

return statearr_115572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4131__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4131__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_115594){
var state_val_115595 = (state_115594[(1)]);
if((state_val_115595 === (7))){
var inst_115590 = (state_115594[(2)]);
var state_115594__$1 = state_115594;
var statearr_115596_115663 = state_115594__$1;
(statearr_115596_115663[(2)] = inst_115590);


cljs.core.async.impl.ioc_helpers.process_exception(state_115594__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115595 === (1))){
var state_115594__$1 = state_115594;
var statearr_115597_115664 = state_115594__$1;
(statearr_115597_115664[(2)] = null);

(statearr_115597_115664[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115595 === (4))){
var inst_115577 = (state_115594[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115594,(3),Error,null,(2));
var inst_115577__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_115578 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_115577__$1);
var state_115594__$1 = (function (){var statearr_115598 = state_115594;
(statearr_115598[(7)] = inst_115577__$1);

return statearr_115598;
})();
if(cljs.core.truth_(inst_115578)){
var statearr_115599_115665 = state_115594__$1;
(statearr_115599_115665[(1)] = (5));

} else {
var statearr_115600_115666 = state_115594__$1;
(statearr_115600_115666[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115595 === (6))){
var inst_115577 = (state_115594[(7)]);
var inst_115581 = fluree.db.dbproto._resolve(inst_115577);
var state_115594__$1 = state_115594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115594__$1,(9),inst_115581);
} else {
if((state_val_115595 === (3))){
var inst_115573 = (state_115594[(2)]);
var state_115594__$1 = state_115594;
var statearr_115601_115667 = state_115594__$1;
(statearr_115601_115667[(2)] = inst_115573);


cljs.core.async.impl.ioc_helpers.process_exception(state_115594__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115595 === (2))){
var inst_115592 = (state_115594[(2)]);
var state_115594__$1 = state_115594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115594__$1,inst_115592);
} else {
if((state_val_115595 === (9))){
var inst_115583 = (state_115594[(2)]);
var inst_115584 = fluree.db.util.async.throw_err(inst_115583);
var inst_115585 = fluree.db.dbproto._lookup_leaf(inst_115584,flake);
var state_115594__$1 = state_115594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115594__$1,(8),inst_115585);
} else {
if((state_val_115595 === (5))){
var inst_115577 = (state_115594[(7)]);
var state_115594__$1 = state_115594;
var statearr_115602_115668 = state_115594__$1;
(statearr_115602_115668[(2)] = inst_115577);

(statearr_115602_115668[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115595 === (8))){
var inst_115587 = (state_115594[(2)]);
var inst_115588 = fluree.db.util.async.throw_err(inst_115587);
var state_115594__$1 = state_115594;
var statearr_115603_115669 = state_115594__$1;
(statearr_115603_115669[(2)] = inst_115588);

(statearr_115603_115669[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__109971__auto__ = null;
var fluree$db$index$state_machine__109971__auto____0 = (function (){
var statearr_115604 = [null,null,null,null,null,null,null,null];
(statearr_115604[(0)] = fluree$db$index$state_machine__109971__auto__);

(statearr_115604[(1)] = (1));

return statearr_115604;
});
var fluree$db$index$state_machine__109971__auto____1 = (function (state_115594){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115594);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115605){if((e115605 instanceof Object)){
var ex__109974__auto__ = e115605;
var statearr_115606_115670 = state_115594;
(statearr_115606_115670[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115594);

return cljs.core.cst$kw$recur;
} else {
throw e115605;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115671 = state_115594;
state_115594 = G__115671;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$index$state_machine__109971__auto__ = function(state_115594){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__109971__auto____1.call(this,state_115594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__109971__auto____0;
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__109971__auto____1;
return fluree$db$index$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_115607 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115607[(6)] = c__110077__auto__);

return statearr_115607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_115629){
var state_val_115630 = (state_115629[(1)]);
if((state_val_115630 === (7))){
var inst_115625 = (state_115629[(2)]);
var state_115629__$1 = state_115629;
var statearr_115631_115672 = state_115629__$1;
(statearr_115631_115672[(2)] = inst_115625);


cljs.core.async.impl.ioc_helpers.process_exception(state_115629__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115630 === (1))){
var state_115629__$1 = state_115629;
var statearr_115632_115673 = state_115629__$1;
(statearr_115632_115673[(2)] = null);

(statearr_115632_115673[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115630 === (4))){
var inst_115612 = (state_115629[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_115629,(3),Error,null,(2));
var inst_115612__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_115613 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_115612__$1);
var state_115629__$1 = (function (){var statearr_115633 = state_115629;
(statearr_115633[(7)] = inst_115612__$1);

return statearr_115633;
})();
if(cljs.core.truth_(inst_115613)){
var statearr_115634_115674 = state_115629__$1;
(statearr_115634_115674[(1)] = (5));

} else {
var statearr_115635_115675 = state_115629__$1;
(statearr_115635_115675[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_115630 === (6))){
var inst_115612 = (state_115629[(7)]);
var inst_115616 = fluree.db.dbproto._resolve(inst_115612);
var state_115629__$1 = state_115629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115629__$1,(9),inst_115616);
} else {
if((state_val_115630 === (3))){
var inst_115608 = (state_115629[(2)]);
var state_115629__$1 = state_115629;
var statearr_115636_115676 = state_115629__$1;
(statearr_115636_115676[(2)] = inst_115608);


cljs.core.async.impl.ioc_helpers.process_exception(state_115629__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_115630 === (2))){
var inst_115627 = (state_115629[(2)]);
var state_115629__$1 = state_115629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115629__$1,inst_115627);
} else {
if((state_val_115630 === (9))){
var inst_115618 = (state_115629[(2)]);
var inst_115619 = fluree.db.util.async.throw_err(inst_115618);
var inst_115620 = fluree.db.dbproto._lookup_leaf_after(inst_115619,flake);
var state_115629__$1 = state_115629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_115629__$1,(8),inst_115620);
} else {
if((state_val_115630 === (5))){
var inst_115612 = (state_115629[(7)]);
var state_115629__$1 = state_115629;
var statearr_115637_115677 = state_115629__$1;
(statearr_115637_115677[(2)] = inst_115612);

(statearr_115637_115677[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_115630 === (8))){
var inst_115622 = (state_115629[(2)]);
var inst_115623 = fluree.db.util.async.throw_err(inst_115622);
var state_115629__$1 = state_115629;
var statearr_115638_115678 = state_115629__$1;
(statearr_115638_115678[(2)] = inst_115623);

(statearr_115638_115678[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__109971__auto__ = null;
var fluree$db$index$state_machine__109971__auto____0 = (function (){
var statearr_115639 = [null,null,null,null,null,null,null,null];
(statearr_115639[(0)] = fluree$db$index$state_machine__109971__auto__);

(statearr_115639[(1)] = (1));

return statearr_115639;
});
var fluree$db$index$state_machine__109971__auto____1 = (function (state_115629){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115629);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115640){if((e115640 instanceof Object)){
var ex__109974__auto__ = e115640;
var statearr_115641_115679 = state_115629;
(statearr_115641_115679[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115629);

return cljs.core.cst$kw$recur;
} else {
throw e115640;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115680 = state_115629;
state_115629 = G__115680;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$index$state_machine__109971__auto__ = function(state_115629){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__109971__auto____1.call(this,state_115629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__109971__auto____0;
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__109971__auto____1;
return fluree$db$index$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_115642 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115642[(6)] = c__110077__auto__);

return statearr_115642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__115643 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__115643(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this115558,other115559){
var self__ = this;
var this115558__$1 = this;
return (((!((other115559 == null)))) && ((this115558__$1.constructor === other115559.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.block,other115559.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.t,other115559.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.rhs,other115559.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.children,other115559.children)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.config,other115559.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.leftmost_QMARK_,other115559.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115558__$1.__extmap,other115559.__extmap)));
});

fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__115556){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__115644 = cljs.core.keyword_identical_QMARK_;
var expr__115645 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__115647 = cljs.core.cst$kw$block;
var G__115648 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115647,G__115648) : pred__115644.call(null,G__115647,G__115648));
})())){
return (new fluree.db.index.IndexNode(G__115556,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115649 = cljs.core.cst$kw$t;
var G__115650 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115649,G__115650) : pred__115644.call(null,G__115649,G__115650));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__115556,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115651 = cljs.core.cst$kw$rhs;
var G__115652 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115651,G__115652) : pred__115644.call(null,G__115651,G__115652));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__115556,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115653 = cljs.core.cst$kw$children;
var G__115654 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115653,G__115654) : pred__115644.call(null,G__115653,G__115654));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__115556,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115655 = cljs.core.cst$kw$config;
var G__115656 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115655,G__115656) : pred__115644.call(null,G__115655,G__115656));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__115556,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115657 = cljs.core.cst$kw$leftmost_QMARK_;
var G__115658 = expr__115645;
return (pred__115644.cljs$core$IFn$_invoke$arity$2 ? pred__115644.cljs$core$IFn$_invoke$arity$2(G__115657,G__115658) : pred__115644.call(null,G__115657,G__115658));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__115556,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__115556),null));
}
}
}
}
}
}
});

fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
});

fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__115556){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__115556,self__.__extmap,self__.__hash));
});

fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
});

fluree.db.index.IndexNode.cljs$lang$type = true;

fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
});

fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/IndexNode");
});

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__115560){
var extmap__4424__auto__ = (function (){var G__115659 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__115560,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__115560)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__115659);
} else {
return G__115659;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__115560),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__115560),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__115560),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__115560),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__115560),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__115560),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k115682,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__115686 = k115682;
var G__115686__$1 = (((G__115686 instanceof cljs.core.Keyword))?G__115686.fqn:null);
switch (G__115686__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k115682,else__4388__auto__);

}
});

fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__115687){
var vec__115688 = p__115687;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115688,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__115688,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
});

fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__115681){
var self__ = this;
var G__115681__$1 = this;
return (new cljs.core.RecordIter((0),G__115681__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,this$__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,this$__$1){
return (function (state_115692){
var state_val_115693 = (state_115692[(1)]);
if((state_val_115693 === (1))){
var state_115692__$1 = state_115692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115692__$1,this$__$1);
} else {
return null;
}
});})(c__110077__auto__,this$__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,this$__$1){
return (function() {
var fluree$db$index$state_machine__109971__auto__ = null;
var fluree$db$index$state_machine__109971__auto____0 = (function (){
var statearr_115694 = [null,null,null,null,null,null,null];
(statearr_115694[(0)] = fluree$db$index$state_machine__109971__auto__);

(statearr_115694[(1)] = (1));

return statearr_115694;
});
var fluree$db$index$state_machine__109971__auto____1 = (function (state_115692){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115692);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115695){if((e115695 instanceof Object)){
var ex__109974__auto__ = e115695;
var statearr_115696_115725 = state_115692;
(statearr_115696_115725[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115692);

return cljs.core.cst$kw$recur;
} else {
throw e115695;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115726 = state_115692;
state_115692 = G__115726;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$index$state_machine__109971__auto__ = function(state_115692){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__109971__auto____1.call(this,state_115692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__109971__auto____0;
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__109971__auto____1;
return fluree$db$index$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,this$__$1))
})();
var state__110079__auto__ = (function (){var statearr_115697 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115697[(6)] = c__110077__auto__);

return statearr_115697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,this$__$1))
);

return c__110077__auto__;
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
});

fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL;

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
});

fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,root__$1){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,root__$1){
return (function (state_115703){
var state_val_115704 = (state_115703[(1)]);
if((state_val_115704 === (1))){
var inst_115698 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_115699 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_115700 = cljs.core.PersistentHashMap.fromArrays(inst_115698,inst_115699);
var inst_115701 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_115700);
var state_115703__$1 = state_115703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_115703__$1,inst_115701);
} else {
return null;
}
});})(c__110077__auto__,root__$1))
;
return ((function (switch__109970__auto__,c__110077__auto__,root__$1){
return (function() {
var fluree$db$index$state_machine__109971__auto__ = null;
var fluree$db$index$state_machine__109971__auto____0 = (function (){
var statearr_115705 = [null,null,null,null,null,null,null];
(statearr_115705[(0)] = fluree$db$index$state_machine__109971__auto__);

(statearr_115705[(1)] = (1));

return statearr_115705;
});
var fluree$db$index$state_machine__109971__auto____1 = (function (state_115703){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_115703);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e115706){if((e115706 instanceof Object)){
var ex__109974__auto__ = e115706;
var statearr_115707_115727 = state_115703;
(statearr_115707_115727[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_115703);

return cljs.core.cst$kw$recur;
} else {
throw e115706;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__115728 = state_115703;
state_115703 = G__115728;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$index$state_machine__109971__auto__ = function(state_115703){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__109971__auto____1.call(this,state_115703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__109971__auto____0;
fluree$db$index$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__109971__auto____1;
return fluree$db$index$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,root__$1))
})();
var state__110079__auto__ = (function (){var statearr_115708 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_115708[(6)] = c__110077__auto__);

return statearr_115708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,root__$1))
);

return c__110077__auto__;
});

fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__115709 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__115709(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this115683,other115684){
var self__ = this;
var this115683__$1 = this;
return (((!((other115684 == null)))) && ((this115683__$1.constructor === other115684.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.block,other115684.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.t,other115684.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.flakes,other115684.flakes)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.rhs,other115684.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.config,other115684.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this115683__$1.__extmap,other115684.__extmap)));
});

fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__115681){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__115710 = cljs.core.keyword_identical_QMARK_;
var expr__115711 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__115713 = cljs.core.cst$kw$block;
var G__115714 = expr__115711;
return (pred__115710.cljs$core$IFn$_invoke$arity$2 ? pred__115710.cljs$core$IFn$_invoke$arity$2(G__115713,G__115714) : pred__115710.call(null,G__115713,G__115714));
})())){
return (new fluree.db.index.DataNode(G__115681,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115715 = cljs.core.cst$kw$t;
var G__115716 = expr__115711;
return (pred__115710.cljs$core$IFn$_invoke$arity$2 ? pred__115710.cljs$core$IFn$_invoke$arity$2(G__115715,G__115716) : pred__115710.call(null,G__115715,G__115716));
})())){
return (new fluree.db.index.DataNode(self__.block,G__115681,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115717 = cljs.core.cst$kw$flakes;
var G__115718 = expr__115711;
return (pred__115710.cljs$core$IFn$_invoke$arity$2 ? pred__115710.cljs$core$IFn$_invoke$arity$2(G__115717,G__115718) : pred__115710.call(null,G__115717,G__115718));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__115681,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115719 = cljs.core.cst$kw$rhs;
var G__115720 = expr__115711;
return (pred__115710.cljs$core$IFn$_invoke$arity$2 ? pred__115710.cljs$core$IFn$_invoke$arity$2(G__115719,G__115720) : pred__115710.call(null,G__115719,G__115720));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__115681,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__115721 = cljs.core.cst$kw$config;
var G__115722 = expr__115711;
return (pred__115710.cljs$core$IFn$_invoke$arity$2 ? pred__115710.cljs$core$IFn$_invoke$arity$2(G__115721,G__115722) : pred__115710.call(null,G__115721,G__115722));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__115681,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__115681),null));
}
}
}
}
}
});

fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
});

fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__115681){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__115681,self__.__extmap,self__.__hash));
});

fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
});

fluree.db.index.DataNode.cljs$lang$type = true;

fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
});

fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.index/DataNode");
});

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__115685){
var extmap__4424__auto__ = (function (){var G__115723 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__115685,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__115685)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__115723);
} else {
return G__115723;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__115685),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__115685),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__115685),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__115685),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__115685),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
