// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e118441){var e = e118441;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__118442_SHARP_){
var or__4131__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__118442_SHARP_);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__118442_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__118442_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__118442_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__118443_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118443_SHARP_,static_value);
});})(key_as_var,static_value))
);
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__118444_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118444_SHARP_,null);
});})(key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4120__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4131__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__118449 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118449,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118449,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (filter_code,var$,vec__118449,fun,_,filter_fn,key_as_var,static_value){
return (function (p1__118445_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118445_SHARP_,null);
});})(filter_code,var$,vec__118449,fun,_,filter_fn,key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4120__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4120__auto__;
}
})())){
var vec__118452 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118452,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118452,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4131__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (vec__118452,pred,recur_amt,recur_amt__$1,key_as_var,static_value){
return (function (p1__118446_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118446_SHARP_,pred);
});})(vec__118452,pred,recur_amt,recur_amt__$1,key_as_var,static_value))
),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__118447_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118447_SHARP_,fluree.db.query.analytical.safe_read_string(key));
});})(key_as_var,static_value))
);
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,((function (key_as_var,static_value){
return (function (p1__118448_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__118448_SHARP_,key);
});})(key_as_var,static_value))
);

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__118455_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__118455_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (rel_keys,clause_keys){
return (function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
});})(rel_keys,clause_keys))
,cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (a_keys,b_keys){
return (function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
});})(a_keys,b_keys))
,cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4131__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (add_amount > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = fuel;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4120__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__118456 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__118456) : intersecting_vars.call(null,G__118456));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__118459,optional_QMARK_,fuel,max_fuel){
var map__118460 = p__118459;
var map__118460__$1 = (((((!((map__118460 == null))))?(((((map__118460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118460):map__118460);
var res = map__118460__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118460__$1,cljs.core.cst$kw$vars);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__118460,map__118460__$1,res,vars){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__118460,map__118460__$1,res,vars){
return (function (state_118523){
var state_val_118524 = (state_118523[(1)]);
if((state_val_118524 === (7))){
var inst_118519 = (state_118523[(2)]);
var state_118523__$1 = state_118523;
var statearr_118525_118546 = state_118523__$1;
(statearr_118525_118546[(2)] = inst_118519);


cljs.core.async.impl.ioc_helpers.process_exception(state_118523__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (1))){
var state_118523__$1 = state_118523;
var statearr_118526_118547 = state_118523__$1;
(statearr_118526_118547[(2)] = null);

(statearr_118526_118547[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118523,(3),Error,null,(2));
var inst_118466 = (r == null);
var state_118523__$1 = state_118523;
if(cljs.core.truth_(inst_118466)){
var statearr_118527_118548 = state_118523__$1;
(statearr_118527_118548[(1)] = (5));

} else {
var statearr_118528_118549 = state_118523__$1;
(statearr_118528_118549[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (13))){
var inst_118511 = (state_118523[(2)]);
var state_118523__$1 = state_118523;
var statearr_118529_118550 = state_118523__$1;
(statearr_118529_118550[(2)] = inst_118511);

(statearr_118529_118550[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (6))){
var inst_118513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118514 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_118515 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_118514,clause);
var inst_118516 = [null,inst_118515];
var inst_118517 = (new cljs.core.PersistentVector(null,2,(5),inst_118513,inst_118516,null));
var state_118523__$1 = state_118523;
var statearr_118530_118551 = state_118523__$1;
(statearr_118530_118551[(2)] = inst_118517);

(statearr_118530_118551[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (3))){
var inst_118462 = (state_118523[(2)]);
var state_118523__$1 = state_118523;
var statearr_118531_118552 = state_118523__$1;
(statearr_118531_118552[(2)] = inst_118462);


cljs.core.async.impl.ioc_helpers.process_exception(state_118523__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (12))){
var inst_118469 = (state_118523[(7)]);
var inst_118481 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_118482 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_118481);
var inst_118483 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_118469);
var inst_118484 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_118483);
var inst_118485 = cljs.core.set(inst_118484);
var inst_118486 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_118482);
var inst_118487 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_118486);
var inst_118488 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118485,inst_118487);
var inst_118489 = (function (){var all_wd = inst_118469;
var optional = inst_118482;
var all_wd_vars = inst_118485;
var all_vars = inst_118488;
return ((function (all_wd,optional,all_wd_vars,all_vars,inst_118469,inst_118481,inst_118482,inst_118483,inst_118484,inst_118485,inst_118486,inst_118487,inst_118488,state_val_118524,c__110077__auto__,map__118460,map__118460__$1,res,vars){
return (function (p1__118457_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__118457_SHARP_) : all_vars.call(null,p1__118457_SHARP_));
});
;})(all_wd,optional,all_wd_vars,all_vars,inst_118469,inst_118481,inst_118482,inst_118483,inst_118484,inst_118485,inst_118486,inst_118487,inst_118488,state_val_118524,c__110077__auto__,map__118460,map__118460__$1,res,vars))
})();
var inst_118490 = cljs.core.keys(vars);
var inst_118491 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_118489,inst_118490);
var inst_118492 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_118491);
var inst_118493 = cljs.core.set(inst_118492);
var inst_118494 = (function (){var all_wd = inst_118469;
var optional = inst_118482;
var all_wd_vars = inst_118485;
var all_vars = inst_118488;
var intersecting_vars = inst_118493;
return ((function (all_wd,optional,all_wd_vars,all_vars,intersecting_vars,inst_118469,inst_118481,inst_118482,inst_118483,inst_118484,inst_118485,inst_118486,inst_118487,inst_118488,inst_118489,inst_118490,inst_118491,inst_118492,inst_118493,state_val_118524,c__110077__auto__,map__118460,map__118460__$1,res,vars){
return (function (p1__118458_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__118458_SHARP_);
});
;})(all_wd,optional,all_wd_vars,all_vars,intersecting_vars,inst_118469,inst_118481,inst_118482,inst_118483,inst_118484,inst_118485,inst_118486,inst_118487,inst_118488,inst_118489,inst_118490,inst_118491,inst_118492,inst_118493,state_val_118524,c__110077__auto__,map__118460,map__118460__$1,res,vars))
})();
var inst_118495 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_118494,inst_118469);
var inst_118496 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_118495);
var inst_118497 = fluree.db.query.analytical.select_from_tuples(inst_118496,res);
var inst_118498 = fluree.db.query.analytical.replace_vars_wikidata(inst_118469,inst_118493,vars);
var inst_118499 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_118493,inst_118488);
var inst_118500 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_118498,inst_118496,inst_118497,inst_118499,inst_118482);
var state_118523__$1 = state_118523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118523__$1,(14),inst_118500);
} else {
if((state_val_118524 === (2))){
var inst_118521 = (state_118523[(2)]);
var state_118523__$1 = state_118523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118523__$1,inst_118521);
} else {
if((state_val_118524 === (11))){
var inst_118477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118478 = [null,r];
var inst_118479 = (new cljs.core.PersistentVector(null,2,(5),inst_118477,inst_118478,null));
var state_118523__$1 = state_118523;
var statearr_118532_118553 = state_118523__$1;
(statearr_118532_118553[(2)] = inst_118479);

(statearr_118532_118553[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (9))){
var state_118523__$1 = state_118523;
var statearr_118533_118554 = state_118523__$1;
(statearr_118533_118554[(2)] = optional_QMARK_);

(statearr_118533_118554[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (5))){
var inst_118468 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_118469 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_118468);
var state_118523__$1 = (function (){var statearr_118534 = state_118523;
(statearr_118534[(7)] = inst_118469);

return statearr_118534;
})();
if(cljs.core.truth_(optional_QMARK_)){
var statearr_118535_118555 = state_118523__$1;
(statearr_118535_118555[(1)] = (8));

} else {
var statearr_118536_118556 = state_118523__$1;
(statearr_118536_118556[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (14))){
var inst_118502 = (state_118523[(2)]);
var inst_118503 = fluree.db.util.async.throw_err(inst_118502);
var inst_118504 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_118503);
var inst_118505 = cljs.core.count(inst_118504);
var inst_118506 = fluree.db.query.analytical.add_fuel(inst_118505,fuel,max_fuel);
var inst_118507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118508 = [inst_118503,r];
var inst_118509 = (new cljs.core.PersistentVector(null,2,(5),inst_118507,inst_118508,null));
var state_118523__$1 = (function (){var statearr_118537 = state_118523;
(statearr_118537[(8)] = inst_118506);

return statearr_118537;
})();
var statearr_118538_118557 = state_118523__$1;
(statearr_118538_118557[(2)] = inst_118509);

(statearr_118538_118557[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (10))){
var inst_118475 = (state_118523[(2)]);
var state_118523__$1 = state_118523;
if(cljs.core.truth_(inst_118475)){
var statearr_118539_118558 = state_118523__$1;
(statearr_118539_118558[(1)] = (11));

} else {
var statearr_118540_118559 = state_118523__$1;
(statearr_118540_118559[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118524 === (8))){
var inst_118469 = (state_118523[(7)]);
var inst_118471 = cljs.core.empty_QMARK_(inst_118469);
var inst_118472 = (!(inst_118471));
var state_118523__$1 = state_118523;
var statearr_118541_118560 = state_118523__$1;
(statearr_118541_118560[(2)] = inst_118472);

(statearr_118541_118560[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__118460,map__118460__$1,res,vars))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__118460,map__118460__$1,res,vars){
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_118542 = [null,null,null,null,null,null,null,null,null];
(statearr_118542[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__);

(statearr_118542[(1)] = (1));

return statearr_118542;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____1 = (function (state_118523){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118523);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118543){if((e118543 instanceof Object)){
var ex__109974__auto__ = e118543;
var statearr_118544_118561 = state_118523;
(statearr_118544_118561[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118523);

return cljs.core.cst$kw$recur;
} else {
throw e118543;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118562 = state_118523;
state_118523 = G__118562;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__ = function(state_118523){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____1.call(this,state_118523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__118460,map__118460__$1,res,vars))
})();
var state__110079__auto__ = (function (){var statearr_118545 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118545[(6)] = c__110077__auto__);

return statearr_118545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__118460,map__118460__$1,res,vars))
);

return c__110077__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__118564 = arguments.length;
switch (G__118564) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118655){
var state_val_118656 = (state_118655[(1)]);
if((state_val_118656 === (7))){
var inst_118651 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118657_118699 = state_118655__$1;
(statearr_118657_118699[(2)] = inst_118651);


cljs.core.async.impl.ioc_helpers.process_exception(state_118655__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (20))){
var inst_118645 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118658_118700 = state_118655__$1;
(statearr_118658_118700[(2)] = inst_118645);

(statearr_118658_118700[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (27))){
var inst_118627 = (state_118655[(2)]);
var inst_118628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118629 = cljs.core.PersistentVector.EMPTY;
var inst_118630 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_118631 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118629,inst_118630);
var inst_118632 = [inst_118627,inst_118631];
var inst_118633 = (new cljs.core.PersistentVector(null,2,(5),inst_118628,inst_118632,null));
var state_118655__$1 = state_118655;
var statearr_118659_118701 = state_118655__$1;
(statearr_118659_118701[(2)] = inst_118633);

(statearr_118659_118701[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (1))){
var state_118655__$1 = state_118655;
var statearr_118660_118702 = state_118655__$1;
(statearr_118660_118702[(2)] = null);

(statearr_118660_118702[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (24))){
var inst_118612 = (state_118655[(7)]);
var inst_118618 = (state_118655[(2)]);
var inst_118619 = fluree.db.util.async.throw_err(inst_118618);
var state_118655__$1 = (function (){var statearr_118661 = state_118655;
(statearr_118661[(8)] = inst_118619);

return statearr_118661;
})();
if(cljs.core.truth_(inst_118612)){
var statearr_118662_118703 = state_118655__$1;
(statearr_118662_118703[(1)] = (25));

} else {
var statearr_118663_118704 = state_118655__$1;
(statearr_118663_118704[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (4))){
var inst_118569 = (state_118655[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118655,(3),Error,null,(2));
var inst_118569__$1 = cljs.core.first(clause);
var inst_118570 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_118569__$1);
var state_118655__$1 = (function (){var statearr_118664 = state_118655;
(statearr_118664[(9)] = inst_118569__$1);

return statearr_118664;
})();
if(inst_118570){
var statearr_118665_118705 = state_118655__$1;
(statearr_118665_118705[(1)] = (5));

} else {
var statearr_118666_118706 = state_118655__$1;
(statearr_118666_118706[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (15))){
var inst_118602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118603 = ["$wd",clause];
var inst_118604 = (new cljs.core.PersistentVector(null,2,(5),inst_118602,inst_118603,null));
var state_118655__$1 = state_118655;
var statearr_118667_118707 = state_118655__$1;
(statearr_118667_118707[(2)] = inst_118604);

(statearr_118667_118707[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (21))){
var inst_118610 = (state_118655[(10)]);
var inst_118608 = (state_118655[(11)]);
var inst_118612 = fluree.db.query.analytical.parse_block_from_source(inst_118608);
var inst_118613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118614 = [cljs.core.cst$kw$sources,inst_118610];
var inst_118615 = (new cljs.core.PersistentVector(null,2,(5),inst_118613,inst_118614,null));
var inst_118616 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_118615);
var state_118655__$1 = (function (){var statearr_118668 = state_118655;
(statearr_118668[(7)] = inst_118612);

return statearr_118668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118655__$1,(24),inst_118616);
} else {
if((state_val_118656 === (13))){
var state_118655__$1 = state_118655;
var statearr_118669_118708 = state_118655__$1;
(statearr_118669_118708[(2)] = null);

(statearr_118669_118708[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (22))){
var inst_118569 = (state_118655[(9)]);
var inst_118635 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_118569)," is not supported in Fluree"].join('');
var inst_118636 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118637 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_118638 = cljs.core.PersistentHashMap.fromArrays(inst_118636,inst_118637);
var inst_118639 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118635,inst_118638);
var inst_118640 = (function(){throw inst_118639})();
var state_118655__$1 = state_118655;
var statearr_118670_118709 = state_118655__$1;
(statearr_118670_118709[(2)] = inst_118640);

(statearr_118670_118709[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (6))){
var inst_118569 = (state_118655[(9)]);
var inst_118579 = clojure.string.starts_with_QMARK_(inst_118569,"$fdb");
var state_118655__$1 = state_118655;
if(inst_118579){
var statearr_118671_118710 = state_118655__$1;
(statearr_118671_118710[(1)] = (8));

} else {
var statearr_118672_118711 = state_118655__$1;
(statearr_118672_118711[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (28))){
var inst_118623 = (state_118655[(2)]);
var inst_118624 = fluree.db.util.async.throw_err(inst_118623);
var state_118655__$1 = state_118655;
var statearr_118673_118712 = state_118655__$1;
(statearr_118673_118712[(2)] = inst_118624);

(statearr_118673_118712[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (25))){
var inst_118619 = (state_118655[(8)]);
var inst_118612 = (state_118655[(7)]);
var inst_118621 = fluree.db.time_travel.as_of_block(inst_118619,inst_118612);
var state_118655__$1 = state_118655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118655__$1,(28),inst_118621);
} else {
if((state_val_118656 === (17))){
var inst_118647 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118674_118713 = state_118655__$1;
(statearr_118674_118713[(2)] = inst_118647);

(statearr_118674_118713[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (3))){
var inst_118565 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118675_118714 = state_118655__$1;
(statearr_118675_118714[(2)] = inst_118565);


cljs.core.async.impl.ioc_helpers.process_exception(state_118655__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (12))){
var inst_118586 = (state_118655[(12)]);
var inst_118589 = (function(){throw inst_118586})();
var state_118655__$1 = state_118655;
var statearr_118676_118715 = state_118655__$1;
(statearr_118676_118715[(2)] = inst_118589);

(statearr_118676_118715[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (2))){
var inst_118653 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118655__$1,inst_118653);
} else {
if((state_val_118656 === (23))){
var inst_118642 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118677_118716 = state_118655__$1;
(statearr_118677_118716[(2)] = inst_118642);

(statearr_118677_118716[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (19))){
var state_118655__$1 = state_118655;
var statearr_118678_118717 = state_118655__$1;
(statearr_118678_118717[(2)] = null);

(statearr_118678_118717[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (11))){
var inst_118586 = (state_118655[(12)]);
var inst_118585 = (state_118655[(2)]);
var inst_118586__$1 = fluree.db.util.async.throw_err(inst_118585);
var inst_118587 = fluree.db.util.core.exception_QMARK_(inst_118586__$1);
var state_118655__$1 = (function (){var statearr_118679 = state_118655;
(statearr_118679[(12)] = inst_118586__$1);

return statearr_118679;
})();
if(inst_118587){
var statearr_118680_118718 = state_118655__$1;
(statearr_118680_118718[(1)] = (12));

} else {
var statearr_118681_118719 = state_118655__$1;
(statearr_118681_118719[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (9))){
var inst_118569 = (state_118655[(9)]);
var inst_118600 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_118569);
var state_118655__$1 = state_118655;
if(inst_118600){
var statearr_118682_118720 = state_118655__$1;
(statearr_118682_118720[(1)] = (15));

} else {
var statearr_118683_118721 = state_118655__$1;
(statearr_118683_118721[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (5))){
var inst_118572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118573 = cljs.core.PersistentVector.EMPTY;
var inst_118574 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_118575 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118573,inst_118574);
var inst_118576 = [db,inst_118575];
var inst_118577 = (new cljs.core.PersistentVector(null,2,(5),inst_118572,inst_118576,null));
var state_118655__$1 = state_118655;
var statearr_118684_118722 = state_118655__$1;
(statearr_118684_118722[(2)] = inst_118577);

(statearr_118684_118722[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (14))){
var inst_118586 = (state_118655[(12)]);
var inst_118592 = (state_118655[(2)]);
var inst_118593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118594 = cljs.core.PersistentVector.EMPTY;
var inst_118595 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_118596 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_118594,inst_118595);
var inst_118597 = [inst_118586,inst_118596];
var inst_118598 = (new cljs.core.PersistentVector(null,2,(5),inst_118593,inst_118597,null));
var state_118655__$1 = (function (){var statearr_118685 = state_118655;
(statearr_118685[(13)] = inst_118592);

return statearr_118685;
})();
var statearr_118686_118723 = state_118655__$1;
(statearr_118686_118723[(2)] = inst_118598);

(statearr_118686_118723[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (26))){
var inst_118619 = (state_118655[(8)]);
var state_118655__$1 = state_118655;
var statearr_118687_118724 = state_118655__$1;
(statearr_118687_118724[(2)] = inst_118619);

(statearr_118687_118724[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (16))){
var state_118655__$1 = state_118655;
var statearr_118688_118725 = state_118655__$1;
(statearr_118688_118725[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (10))){
var inst_118649 = (state_118655[(2)]);
var state_118655__$1 = state_118655;
var statearr_118690_118726 = state_118655__$1;
(statearr_118690_118726[(2)] = inst_118649);

(statearr_118690_118726[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (18))){
var inst_118610 = (state_118655[(10)]);
var inst_118569 = (state_118655[(9)]);
var inst_118607 = fluree.db.query.analytical.isolate_source_name(inst_118569);
var inst_118608 = fluree.db.query.analytical.isolate_source_block(inst_118569);
var inst_118609 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_118607);
var inst_118610__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_118609);
var state_118655__$1 = (function (){var statearr_118691 = state_118655;
(statearr_118691[(10)] = inst_118610__$1);

(statearr_118691[(11)] = inst_118608);

return statearr_118691;
})();
if(cljs.core.truth_(inst_118610__$1)){
var statearr_118692_118727 = state_118655__$1;
(statearr_118692_118727[(1)] = (21));

} else {
var statearr_118693_118728 = state_118655__$1;
(statearr_118693_118728[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118656 === (8))){
var inst_118569 = (state_118655[(9)]);
var inst_118581 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_118569,(4));
var inst_118582 = fluree.db.query.analytical.parse_block_from_source(inst_118581);
var inst_118583 = fluree.db.time_travel.as_of_block(db,inst_118582);
var state_118655__$1 = state_118655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118655__$1,(11),inst_118583);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$state_machine__109971__auto__ = null;
var fluree$db$query$analytical$state_machine__109971__auto____0 = (function (){
var statearr_118694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118694[(0)] = fluree$db$query$analytical$state_machine__109971__auto__);

(statearr_118694[(1)] = (1));

return statearr_118694;
});
var fluree$db$query$analytical$state_machine__109971__auto____1 = (function (state_118655){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118655);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118695){if((e118695 instanceof Object)){
var ex__109974__auto__ = e118695;
var statearr_118696_118729 = state_118655;
(statearr_118696_118729[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118655);

return cljs.core.cst$kw$recur;
} else {
throw e118695;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118730 = state_118655;
state_118655 = G__118730;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__109971__auto__ = function(state_118655){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__109971__auto____1.call(this,state_118655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__109971__auto____0;
fluree$db$query$analytical$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__109971__auto____1;
return fluree$db$query$analytical$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118697 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118697[(6)] = c__110077__auto__);

return statearr_118697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4;

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__118731){
var vec__118732 = p__118731;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118732,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__118732,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__118735_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__118735_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__118739 = subjects;
var vec__118740 = G__118739;
var seq__118741 = cljs.core.seq(vec__118740);
var first__118742 = cljs.core.first(seq__118741);
var seq__118741__$1 = cljs.core.next(seq__118741);
var subject = first__118742;
var r = seq__118741__$1;
var acc = expanded_map;
var G__118739__$1 = G__118739;
var acc__$1 = acc;
while(true){
var vec__118746 = G__118739__$1;
var seq__118747 = cljs.core.seq(vec__118746);
var first__118748 = cljs.core.first(seq__118747);
var seq__118747__$1 = cljs.core.next(seq__118747);
var subject__$1 = first__118748;
var r__$1 = seq__118747__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__118749 = r__$1;
var G__118750 = acc__$2;
G__118739__$1 = G__118749;
acc__$1 = G__118750;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__118739__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4131__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__118739__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__118739__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__118739__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__118739__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__118739__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__118746,seq__118747,first__118748,seq__118747__$1,subject__$1,r__$1,acc__$2,G__118739,vec__118740,seq__118741,first__118742,seq__118741__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__118751 = r__$1;
var G__118752 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__118739__$1 = G__118751;
acc__$1 = G__118752;
continue;
} else {
var G__118753 = subjects;
var G__118754 = acc_STAR_;
G__118739__$1 = G__118753;
acc__$1 = G__118754;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (subject_vals){
return (function (p1__118755_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__118755_SHARP_],null));
});})(subject_vals))
,subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118841){
var state_val_118842 = (state_118841[(1)]);
if((state_val_118842 === (7))){
var inst_118764 = (state_118841[(2)]);
var inst_118765 = recur_map;
var inst_118766 = (1);
var state_118841__$1 = (function (){var statearr_118843 = state_118841;
(statearr_118843[(7)] = inst_118764);

(statearr_118843[(8)] = inst_118765);

(statearr_118843[(9)] = inst_118766);

return statearr_118843;
})();
var statearr_118844_118881 = state_118841__$1;
(statearr_118844_118881[(2)] = null);

(statearr_118844_118881[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (20))){
var inst_118812 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
var statearr_118845_118882 = state_118841__$1;
(statearr_118845_118882[(2)] = inst_118812);

(statearr_118845_118882[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (1))){
var state_118841__$1 = state_118841;
var statearr_118846_118883 = state_118841__$1;
(statearr_118846_118883[(2)] = null);

(statearr_118846_118883[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (24))){
var inst_118837 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
var statearr_118847_118884 = state_118841__$1;
(statearr_118847_118884[(2)] = inst_118837);


cljs.core.async.impl.ioc_helpers.process_exception(state_118841__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118841,(3),Error,null,(2));
var state_118841__$1 = state_118841;
if(cljs.core.truth_(depth)){
var statearr_118848_118885 = state_118841__$1;
(statearr_118848_118885[(1)] = (5));

} else {
var statearr_118849_118886 = state_118841__$1;
(statearr_118849_118886[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (15))){
var inst_118823 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
var statearr_118850_118887 = state_118841__$1;
(statearr_118850_118887[(2)] = inst_118823);

(statearr_118850_118887[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (21))){
var inst_118791 = (state_118841[(10)]);
var inst_118799 = (state_118841[(11)]);
var inst_118806 = (state_118841[(2)]);
var inst_118807 = fluree.db.util.async.throw_err(inst_118806);
var inst_118808 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_118791,inst_118807);
var inst_118791__$1 = inst_118808;
var inst_118792 = inst_118799;
var state_118841__$1 = (function (){var statearr_118851 = state_118841;
(statearr_118851[(10)] = inst_118791__$1);

(statearr_118851[(12)] = inst_118792);

return statearr_118851;
})();
var statearr_118852_118888 = state_118841__$1;
(statearr_118852_118888[(2)] = null);

(statearr_118852_118888[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (13))){
var inst_118765 = (state_118841[(8)]);
var state_118841__$1 = state_118841;
var statearr_118853_118889 = state_118841__$1;
(statearr_118853_118889[(2)] = inst_118765);

(statearr_118853_118889[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (22))){
var inst_118830 = (state_118841[(13)]);
var state_118841__$1 = state_118841;
var statearr_118854_118890 = state_118841__$1;
(statearr_118854_118890[(2)] = inst_118830);

(statearr_118854_118890[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (6))){
var state_118841__$1 = state_118841;
var statearr_118855_118891 = state_118841__$1;
(statearr_118855_118891[(2)] = (100));

(statearr_118855_118891[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (17))){
var inst_118765 = (state_118841[(8)]);
var inst_118766 = (state_118841[(9)]);
var inst_118814 = (state_118841[(2)]);
var inst_118815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118816 = [(0),(2)];
var inst_118817 = (new cljs.core.PersistentVector(null,2,(5),inst_118815,inst_118816,null));
var inst_118818 = fluree.db.query.analytical.get_ns_arrays(inst_118817,inst_118814);
var inst_118819 = fluree.db.query.analytical.tuples__GT_map(inst_118765,inst_118818);
var inst_118820 = (inst_118766 + (1));
var inst_118765__$1 = inst_118819;
var inst_118766__$1 = inst_118820;
var state_118841__$1 = (function (){var statearr_118856 = state_118841;
(statearr_118856[(8)] = inst_118765__$1);

(statearr_118856[(9)] = inst_118766__$1);

return statearr_118856;
})();
var statearr_118857_118892 = state_118841__$1;
(statearr_118857_118892[(2)] = null);

(statearr_118857_118892[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (3))){
var inst_118757 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
var statearr_118858_118893 = state_118841__$1;
(statearr_118858_118893[(2)] = inst_118757);


cljs.core.async.impl.ioc_helpers.process_exception(state_118841__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (12))){
var inst_118825 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
var statearr_118859_118894 = state_118841__$1;
(statearr_118859_118894[(2)] = inst_118825);

(statearr_118859_118894[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (2))){
var inst_118839 = (state_118841[(2)]);
var state_118841__$1 = state_118841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118841__$1,inst_118839);
} else {
if((state_val_118842 === (23))){
var inst_118829 = (state_118841[(14)]);
var inst_118828 = (state_118841[(15)]);
var inst_118764 = (state_118841[(7)]);
var inst_118830 = (state_118841[(13)]);
var inst_118833 = (function (){var max_depth = inst_118764;
var recur_map__$1 = inst_118829;
var subjects = inst_118828;
var tuples = inst_118830;
return ((function (max_depth,recur_map__$1,subjects,tuples,inst_118829,inst_118828,inst_118764,inst_118830,state_val_118842,c__110077__auto__){
return (function (p1__118756_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__118756_SHARP_)],null));
});
;})(max_depth,recur_map__$1,subjects,tuples,inst_118829,inst_118828,inst_118764,inst_118830,state_val_118842,c__110077__auto__))
})();
var inst_118834 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_118833,inst_118830);
var inst_118835 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_118834);
var state_118841__$1 = state_118841;
var statearr_118860_118895 = state_118841__$1;
(statearr_118860_118895[(2)] = inst_118835);

(statearr_118860_118895[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (19))){
var inst_118791 = (state_118841[(10)]);
var state_118841__$1 = state_118841;
var statearr_118861_118896 = state_118841__$1;
(statearr_118861_118896[(2)] = inst_118791);

(statearr_118861_118896[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (11))){
var inst_118776 = (state_118841[(16)]);
var inst_118765 = (state_118841[(8)]);
var inst_118771 = cljs.core.vals(inst_118765);
var inst_118772 = cljs.core.flatten(inst_118771);
var inst_118773 = cljs.core.set(inst_118772);
var inst_118774 = cljs.core.keys(inst_118765);
var inst_118775 = cljs.core.set(inst_118774);
var inst_118776__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_118773,inst_118775);
var inst_118777 = cljs.core.empty_QMARK_(inst_118776__$1);
var state_118841__$1 = (function (){var statearr_118862 = state_118841;
(statearr_118862[(16)] = inst_118776__$1);

return statearr_118862;
})();
if(inst_118777){
var statearr_118863_118897 = state_118841__$1;
(statearr_118863_118897[(1)] = (13));

} else {
var statearr_118864_118898 = state_118841__$1;
(statearr_118864_118898[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (9))){
var inst_118829 = (state_118841[(14)]);
var inst_118828 = (state_118841[(15)]);
var inst_118827 = (state_118841[(2)]);
var inst_118828__$1 = cljs.core.keys(inst_118827);
var inst_118829__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_118828__$1,inst_118827);
var inst_118830 = fluree.db.query.analytical.recur_map__GT_tuples(inst_118828__$1,inst_118829__$1);
var state_118841__$1 = (function (){var statearr_118865 = state_118841;
(statearr_118865[(14)] = inst_118829__$1);

(statearr_118865[(15)] = inst_118828__$1);

(statearr_118865[(13)] = inst_118830);

return statearr_118865;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_118866_118899 = state_118841__$1;
(statearr_118866_118899[(1)] = (22));

} else {
var statearr_118867_118900 = state_118841__$1;
(statearr_118867_118900[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (5))){
var state_118841__$1 = state_118841;
var statearr_118868_118901 = state_118841__$1;
(statearr_118868_118901[(2)] = depth);

(statearr_118868_118901[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (14))){
var inst_118776 = (state_118841[(16)]);
var inst_118787 = cljs.core.PersistentVector.EMPTY;
var inst_118788 = cljs.core.seq(inst_118776);
var inst_118789 = cljs.core.first(inst_118788);
var inst_118790 = cljs.core.next(inst_118788);
var inst_118791 = inst_118787;
var inst_118792 = inst_118776;
var state_118841__$1 = (function (){var statearr_118869 = state_118841;
(statearr_118869[(17)] = inst_118790);

(statearr_118869[(10)] = inst_118791);

(statearr_118869[(12)] = inst_118792);

(statearr_118869[(18)] = inst_118789);

return statearr_118869;
})();
var statearr_118870_118902 = state_118841__$1;
(statearr_118870_118902[(2)] = null);

(statearr_118870_118902[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (16))){
var inst_118798 = (state_118841[(19)]);
var inst_118792 = (state_118841[(12)]);
var inst_118797 = cljs.core.seq(inst_118792);
var inst_118798__$1 = cljs.core.first(inst_118797);
var inst_118799 = cljs.core.next(inst_118797);
var state_118841__$1 = (function (){var statearr_118871 = state_118841;
(statearr_118871[(19)] = inst_118798__$1);

(statearr_118871[(11)] = inst_118799);

return statearr_118871;
})();
if(cljs.core.truth_(inst_118798__$1)){
var statearr_118872_118903 = state_118841__$1;
(statearr_118872_118903[(1)] = (18));

} else {
var statearr_118873_118904 = state_118841__$1;
(statearr_118873_118904[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (10))){
var inst_118765 = (state_118841[(8)]);
var state_118841__$1 = state_118841;
var statearr_118874_118905 = state_118841__$1;
(statearr_118874_118905[(2)] = inst_118765);

(statearr_118874_118905[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118842 === (18))){
var inst_118798 = (state_118841[(19)]);
var inst_118801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118802 = [inst_118798,predicate];
var inst_118803 = (new cljs.core.PersistentVector(null,2,(5),inst_118801,inst_118802,null));
var inst_118804 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_118803);
var state_118841__$1 = state_118841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118841__$1,(21),inst_118804);
} else {
if((state_val_118842 === (8))){
var inst_118764 = (state_118841[(7)]);
var inst_118766 = (state_118841[(9)]);
var inst_118768 = (inst_118766 >= inst_118764);
var state_118841__$1 = state_118841;
if(cljs.core.truth_(inst_118768)){
var statearr_118875_118906 = state_118841__$1;
(statearr_118875_118906[(1)] = (10));

} else {
var statearr_118876_118907 = state_118841__$1;
(statearr_118876_118907[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____0 = (function (){
var statearr_118877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_118877[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__);

(statearr_118877[(1)] = (1));

return statearr_118877;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____1 = (function (state_118841){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118841);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118878){if((e118878 instanceof Object)){
var ex__109974__auto__ = e118878;
var statearr_118879_118908 = state_118841;
(statearr_118879_118908[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118841);

return cljs.core.cst$kw$recur;
} else {
throw e118878;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118909 = state_118841;
state_118841 = G__118909;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__ = function(state_118841){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____1.call(this,state_118841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118880 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118880[(6)] = c__110077__auto__);

return statearr_118880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__118910,clause,fuel,max_fuel){
var map__118911 = p__118910;
var map__118911__$1 = (((((!((map__118911 == null))))?(((((map__118911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118911):map__118911);
var res = map__118911__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118911__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118911__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118911__$1,cljs.core.cst$kw$vars);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars){
return (function (state_119040){
var state_val_119041 = (state_119040[(1)]);
if((state_val_119041 === (7))){
var inst_118937 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
if(cljs.core.truth_(inst_118937)){
var statearr_119042_119101 = state_119040__$1;
(statearr_119042_119101[(1)] = (11));

} else {
var statearr_119043_119102 = state_119040__$1;
(statearr_119043_119102[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (20))){
var inst_118944 = (state_119040[(7)]);
var inst_119032 = (state_119040[(2)]);
var inst_119033 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_119034 = cljs.core.keys(inst_118944);
var inst_119035 = [inst_119034,vars,inst_119032];
var inst_119036 = cljs.core.PersistentHashMap.fromArrays(inst_119033,inst_119035);
var state_119040__$1 = state_119040;
var statearr_119044_119103 = state_119040__$1;
(statearr_119044_119103[(2)] = inst_119036);


cljs.core.async.impl.ioc_helpers.process_exception(state_119040__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (27))){
var inst_118973 = (state_119040[(8)]);
var inst_119003 = cljs.core.PersistentHashMap.EMPTY;
var inst_119004 = fluree.db.query.analytical.tuples__GT_map(inst_119003,inst_118973);
var state_119040__$1 = state_119040;
var statearr_119045_119104 = state_119040__$1;
(statearr_119045_119104[(2)] = inst_119004);

(statearr_119045_119104[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (1))){
var state_119040__$1 = state_119040;
var statearr_119046_119105 = state_119040__$1;
(statearr_119046_119105[(2)] = null);

(statearr_119046_119105[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (24))){
var state_119040__$1 = state_119040;
var statearr_119047_119106 = state_119040__$1;
(statearr_119047_119106[(2)] = null);

(statearr_119047_119106[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (4))){
var inst_118921 = (state_119040[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119040,(3),Error,null,(2));
var inst_118921__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_118923 = (inst_118921__$1 == null);
var inst_118924 = cljs.core.not(inst_118923);
var state_119040__$1 = (function (){var statearr_119048 = state_119040;
(statearr_119048[(9)] = inst_118921__$1);

return statearr_119048;
})();
if(inst_118924){
var statearr_119049_119107 = state_119040__$1;
(statearr_119049_119107[(1)] = (5));

} else {
var statearr_119050_119108 = state_119040__$1;
(statearr_119050_119108[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (15))){
var inst_118947 = (state_119040[(10)]);
var state_119040__$1 = state_119040;
var statearr_119051_119109 = state_119040__$1;
(statearr_119051_119109[(2)] = inst_118947);

(statearr_119051_119109[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (21))){
var inst_118957 = (state_119040[(11)]);
var inst_118981 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_118957)].join('');
var inst_118982 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118983 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_118984 = cljs.core.PersistentHashMap.fromArrays(inst_118982,inst_118983);
var inst_118985 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118981,inst_118984);
var inst_118986 = (function(){throw inst_118985})();
var state_119040__$1 = state_119040;
var statearr_119052_119110 = state_119040__$1;
(statearr_119052_119110[(2)] = inst_118986);

(statearr_119052_119110[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (31))){
var inst_118975 = (state_119040[(12)]);
var inst_119012 = cljs.core.coll_QMARK_(inst_118975);
var state_119040__$1 = state_119040;
if(inst_119012){
var statearr_119053_119111 = state_119040__$1;
(statearr_119053_119111[(1)] = (33));

} else {
var statearr_119054_119112 = state_119040__$1;
(statearr_119054_119112[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (32))){
var inst_119023 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
var statearr_119055_119113 = state_119040__$1;
(statearr_119055_119113[(2)] = inst_119023);

(statearr_119055_119113[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (33))){
var inst_118973 = (state_119040[(8)]);
var inst_118969 = (state_119040[(13)]);
var inst_119014 = cljs.core.PersistentHashMap.EMPTY;
var inst_119015 = cljs.core.first(inst_118969);
var inst_119016 = cljs.core.first(inst_119015);
var inst_119017 = cljs.core.flatten(inst_118973);
var inst_119018 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_119014,inst_119016,inst_119017);
var state_119040__$1 = state_119040;
var statearr_119056_119114 = state_119040__$1;
(statearr_119056_119114[(2)] = inst_119018);

(statearr_119056_119114[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (13))){
var inst_118944 = (state_119040[(7)]);
var inst_118947 = (state_119040[(10)]);
var inst_118948 = (state_119040[(14)]);
var inst_118959 = (state_119040[(15)]);
var inst_118942 = (state_119040[(2)]);
var inst_118943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118942,cljs.core.cst$kw$search);
var inst_118944__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118942,cljs.core.cst$kw$rel);
var inst_118945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_118942,cljs.core.cst$kw$opts);
var inst_118946 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_118947__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_118945);
var inst_118948__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_118945);
var inst_118950 = (function (){var map__118917 = inst_118942;
var search = inst_118943;
var rel = inst_118944__$1;
var opts = inst_118945;
var common_keys = inst_118946;
var object_fn = inst_118947__$1;
var recur_depth = inst_118948__$1;
return ((function (map__118917,search,rel,opts,common_keys,object_fn,recur_depth,inst_118944,inst_118947,inst_118948,inst_118959,inst_118942,inst_118943,inst_118944__$1,inst_118945,inst_118946,inst_118947__$1,inst_118948__$1,state_val_119041,c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars){
return (function (p__118949,common_key){
var vec__119057 = p__118949;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119057,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119057,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__119060 = cljs.core._EQ_;
var expr__119061 = idx_of;
if(cljs.core.truth_((pred__119060.cljs$core$IFn$_invoke$arity$2 ? pred__119060.cljs$core$IFn$_invoke$arity$2((0),expr__119061) : pred__119060.call(null,(0),expr__119061)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__119060.cljs$core$IFn$_invoke$arity$2 ? pred__119060.cljs$core$IFn$_invoke$arity$2((1),expr__119061) : pred__119060.call(null,(1),expr__119061)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__119060.cljs$core$IFn$_invoke$arity$2 ? pred__119060.cljs$core$IFn$_invoke$arity$2((2),expr__119061) : pred__119060.call(null,(2),expr__119061)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__119061)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4120__auto__ = (!(single_v_QMARK_));
if(and__4120__auto__){
var and__4120__auto____$1 = object_fn;
if(cljs.core.truth_(and__4120__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
;})(map__118917,search,rel,opts,common_keys,object_fn,recur_depth,inst_118944,inst_118947,inst_118948,inst_118959,inst_118942,inst_118943,inst_118944__$1,inst_118945,inst_118946,inst_118947__$1,inst_118948__$1,state_val_119041,c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars))
})();
var inst_118951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_118952 = cljs.core.PersistentHashMap.EMPTY;
var inst_118953 = [inst_118952,inst_118943];
var inst_118954 = (new cljs.core.PersistentVector(null,2,(5),inst_118951,inst_118953,null));
var inst_118955 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_118950,inst_118954,inst_118946);
var inst_118956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118955,(0),null);
var inst_118957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_118955,(1),null);
var inst_118958 = [cljs.core.cst$kw$object_DASH_fn];
var inst_118959__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_118956);
var state_119040__$1 = (function (){var statearr_119063 = state_119040;
(statearr_119063[(7)] = inst_118944__$1);

(statearr_119063[(10)] = inst_118947__$1);

(statearr_119063[(14)] = inst_118948__$1);

(statearr_119063[(16)] = inst_118958);

(statearr_119063[(15)] = inst_118959__$1);

(statearr_119063[(11)] = inst_118957);

return statearr_119063;
})();
if(cljs.core.truth_(inst_118959__$1)){
var statearr_119064_119115 = state_119040__$1;
(statearr_119064_119115[(1)] = (14));

} else {
var statearr_119065_119116 = state_119040__$1;
(statearr_119065_119116[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (22))){
var state_119040__$1 = state_119040;
var statearr_119066_119117 = state_119040__$1;
(statearr_119066_119117[(2)] = null);

(statearr_119066_119117[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (36))){
var inst_119028 = (state_119040[(2)]);
var inst_119029 = fluree.db.util.async.throw_err(inst_119028);
var state_119040__$1 = state_119040;
var statearr_119067_119118 = state_119040__$1;
(statearr_119067_119118[(2)] = inst_119029);

(statearr_119067_119118[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (29))){
var inst_118978 = (state_119040[(17)]);
var inst_118948 = (state_119040[(14)]);
var inst_118977 = (state_119040[(18)]);
var inst_119025 = (state_119040[(2)]);
var inst_119026 = fluree.db.query.analytical.tuples__GT_recur(db,inst_118978,inst_119025,inst_118948,inst_118977);
var state_119040__$1 = state_119040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119040__$1,(36),inst_119026);
} else {
if((state_val_119041 === (6))){
var state_119040__$1 = state_119040;
var statearr_119068_119119 = state_119040__$1;
(statearr_119068_119119[(2)] = false);

(statearr_119068_119119[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (28))){
var inst_118975 = (state_119040[(12)]);
var inst_119006 = typeof inst_118975 === 'number';
var state_119040__$1 = state_119040;
if(cljs.core.truth_(inst_119006)){
var statearr_119069_119120 = state_119040__$1;
(statearr_119069_119120[(1)] = (30));

} else {
var statearr_119070_119121 = state_119040__$1;
(statearr_119070_119121[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (25))){
var inst_118957 = (state_119040[(11)]);
var inst_118994 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_118957)].join('');
var inst_118995 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118996 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_118997 = cljs.core.PersistentHashMap.fromArrays(inst_118995,inst_118996);
var inst_118998 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118994,inst_118997);
var inst_118999 = (function(){throw inst_118998})();
var state_119040__$1 = state_119040;
var statearr_119071_119122 = state_119040__$1;
(statearr_119071_119122[(2)] = inst_118999);

(statearr_119071_119122[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (34))){
var state_119040__$1 = state_119040;
var statearr_119072_119123 = state_119040__$1;
(statearr_119072_119123[(2)] = null);

(statearr_119072_119123[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (17))){
var inst_118944 = (state_119040[(7)]);
var inst_118948 = (state_119040[(14)]);
var inst_118969 = (state_119040[(13)]);
var inst_118968 = (state_119040[(2)]);
var inst_118969__$1 = fluree.db.util.async.throw_err(inst_118968);
var inst_118970 = cljs.core.count(inst_118969__$1);
var inst_118971 = fluree.db.query.analytical.add_fuel(inst_118970,fuel,max_fuel);
var inst_118972 = cljs.core.vals(inst_118944);
var inst_118973 = fluree.db.query.analytical.get_ns_arrays(inst_118972,inst_118969__$1);
var state_119040__$1 = (function (){var statearr_119073 = state_119040;
(statearr_119073[(19)] = inst_118971);

(statearr_119073[(8)] = inst_118973);

(statearr_119073[(13)] = inst_118969__$1);

return statearr_119073;
})();
if(cljs.core.truth_(inst_118948)){
var statearr_119074_119124 = state_119040__$1;
(statearr_119074_119124[(1)] = (18));

} else {
var statearr_119075_119125 = state_119040__$1;
(statearr_119075_119125[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (3))){
var inst_118913 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
var statearr_119076_119126 = state_119040__$1;
(statearr_119076_119126[(2)] = inst_118913);


cljs.core.async.impl.ioc_helpers.process_exception(state_119040__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (12))){
var inst_118921 = (state_119040[(9)]);
var state_119040__$1 = state_119040;
var statearr_119077_119127 = state_119040__$1;
(statearr_119077_119127[(2)] = inst_118921);

(statearr_119077_119127[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (2))){
var inst_119038 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119040__$1,inst_119038);
} else {
if((state_val_119041 === (23))){
var inst_118989 = (state_119040[(2)]);
var inst_118990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_118991 = fluree.db.query.analytical.variable_QMARK_(inst_118990);
var state_119040__$1 = (function (){var statearr_119078 = state_119040;
(statearr_119078[(20)] = inst_118989);

return statearr_119078;
})();
if(cljs.core.truth_(inst_118991)){
var statearr_119079_119128 = state_119040__$1;
(statearr_119079_119128[(1)] = (24));

} else {
var statearr_119080_119129 = state_119040__$1;
(statearr_119080_119129[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (35))){
var inst_119021 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
var statearr_119081_119130 = state_119040__$1;
(statearr_119081_119130[(2)] = inst_119021);

(statearr_119081_119130[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (19))){
var inst_118973 = (state_119040[(8)]);
var state_119040__$1 = state_119040;
var statearr_119082_119131 = state_119040__$1;
(statearr_119082_119131[(2)] = inst_118973);

(statearr_119082_119131[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (11))){
var inst_118921 = (state_119040[(9)]);
var inst_118939 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_118921);
var state_119040__$1 = state_119040;
var statearr_119083_119132 = state_119040__$1;
(statearr_119083_119132[(2)] = inst_118939);

(statearr_119083_119132[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (9))){
var state_119040__$1 = state_119040;
var statearr_119084_119133 = state_119040__$1;
(statearr_119084_119133[(2)] = false);

(statearr_119084_119133[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (5))){
var inst_118921 = (state_119040[(9)]);
var inst_118926 = inst_118921.cljs$lang$protocol_mask$partition0$;
var inst_118927 = (inst_118926 & (64));
var inst_118928 = inst_118921.cljs$core$ISeq$;
var inst_118929 = (cljs.core.PROTOCOL_SENTINEL === inst_118928);
var inst_118930 = ((inst_118927) || (inst_118929));
var state_119040__$1 = state_119040;
if(cljs.core.truth_(inst_118930)){
var statearr_119085_119134 = state_119040__$1;
(statearr_119085_119134[(1)] = (8));

} else {
var statearr_119086_119135 = state_119040__$1;
(statearr_119086_119135[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (14))){
var inst_118959 = (state_119040[(15)]);
var state_119040__$1 = state_119040;
var statearr_119087_119136 = state_119040__$1;
(statearr_119087_119136[(2)] = inst_118959);

(statearr_119087_119136[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (26))){
var inst_118977 = (state_119040[(18)]);
var inst_119001 = (state_119040[(2)]);
var state_119040__$1 = (function (){var statearr_119088 = state_119040;
(statearr_119088[(21)] = inst_119001);

return statearr_119088;
})();
if(cljs.core.truth_(inst_118977)){
var statearr_119089_119137 = state_119040__$1;
(statearr_119089_119137[(1)] = (27));

} else {
var statearr_119090_119138 = state_119040__$1;
(statearr_119090_119138[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (16))){
var inst_118958 = (state_119040[(16)]);
var inst_118957 = (state_119040[(11)]);
var inst_118963 = (state_119040[(2)]);
var inst_118964 = [inst_118963];
var inst_118965 = cljs.core.PersistentHashMap.fromArrays(inst_118958,inst_118964);
var inst_118966 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_118957,inst_118965);
var state_119040__$1 = state_119040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119040__$1,(17),inst_118966);
} else {
if((state_val_119041 === (30))){
var inst_118973 = (state_119040[(8)]);
var inst_118975 = (state_119040[(12)]);
var inst_119008 = cljs.core.PersistentHashMap.EMPTY;
var inst_119009 = cljs.core.flatten(inst_118973);
var inst_119010 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_119008,inst_118975,inst_119009);
var state_119040__$1 = state_119040;
var statearr_119091_119139 = state_119040__$1;
(statearr_119091_119139[(2)] = inst_119010);

(statearr_119091_119139[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (10))){
var inst_118934 = (state_119040[(2)]);
var state_119040__$1 = state_119040;
var statearr_119092_119140 = state_119040__$1;
(statearr_119092_119140[(2)] = inst_118934);

(statearr_119092_119140[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (18))){
var inst_118978 = (state_119040[(17)]);
var inst_118957 = (state_119040[(11)]);
var inst_118975 = cljs.core.first(inst_118957);
var inst_118976 = cljs.core.first(clause);
var inst_118977 = fluree.db.query.analytical.variable_QMARK_(inst_118976);
var inst_118978__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_118957,(1));
var inst_118979 = fluree.db.query.analytical.variable_QMARK_(inst_118978__$1);
var state_119040__$1 = (function (){var statearr_119093 = state_119040;
(statearr_119093[(17)] = inst_118978__$1);

(statearr_119093[(18)] = inst_118977);

(statearr_119093[(12)] = inst_118975);

return statearr_119093;
})();
if(cljs.core.truth_(inst_118979)){
var statearr_119094_119141 = state_119040__$1;
(statearr_119094_119141[(1)] = (21));

} else {
var statearr_119095_119142 = state_119040__$1;
(statearr_119095_119142[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119041 === (8))){
var state_119040__$1 = state_119040;
var statearr_119096_119143 = state_119040__$1;
(statearr_119096_119143[(2)] = true);

(statearr_119096_119143[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars){
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_119097 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119097[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__);

(statearr_119097[(1)] = (1));

return statearr_119097;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____1 = (function (state_119040){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_119040);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e119098){if((e119098 instanceof Object)){
var ex__109974__auto__ = e119098;
var statearr_119099_119144 = state_119040;
(statearr_119099_119144[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119040);

return cljs.core.cst$kw$recur;
} else {
throw e119098;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__119145 = state_119040;
state_119040 = G__119145;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__ = function(state_119040){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____1.call(this,state_119040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars))
})();
var state__110079__auto__ = (function (){var statearr_119100 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_119100[(6)] = c__110077__auto__);

return statearr_119100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__118911,map__118911__$1,res,headers,tuples,vars))
);

return c__110077__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(db,res,clause){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_119241){
var state_val_119242 = (state_119241[(1)]);
if((state_val_119242 === (7))){
var inst_119159 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
if(cljs.core.truth_(inst_119159)){
var statearr_119243_119276 = state_119241__$1;
(statearr_119243_119276[(1)] = (8));

} else {
var statearr_119244_119277 = state_119241__$1;
(statearr_119244_119277[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (20))){
var inst_119206 = (state_119241[(7)]);
var state_119241__$1 = state_119241;
var statearr_119245_119278 = state_119241__$1;
(statearr_119245_119278[(2)] = inst_119206);

(statearr_119245_119278[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (1))){
var state_119241__$1 = state_119241;
var statearr_119246_119279 = state_119241__$1;
(statearr_119246_119279[(2)] = null);

(statearr_119246_119279[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (4))){
var inst_119153 = (state_119241[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119241,(3),Error,null,(2));
var inst_119152 = cljs.core.first(clause);
var inst_119153__$1 = fluree.db.query.analytical.variable_QMARK_(inst_119152);
var inst_119154 = cljs.core.last(clause);
var inst_119155 = fluree.db.query.analytical.variable_QMARK_(inst_119154);
var state_119241__$1 = (function (){var statearr_119247 = state_119241;
(statearr_119247[(9)] = inst_119155);

(statearr_119247[(8)] = inst_119153__$1);

return statearr_119247;
})();
if(cljs.core.truth_(inst_119153__$1)){
var statearr_119248_119280 = state_119241__$1;
(statearr_119248_119280[(1)] = (5));

} else {
var statearr_119249_119281 = state_119241__$1;
(statearr_119249_119281[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (15))){
var inst_119155 = (state_119241[(9)]);
var inst_119153 = (state_119241[(8)]);
var inst_119186 = cljs.core.last(clause);
var inst_119187 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_119186);
var inst_119188 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_119189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_119188,inst_119187);
var inst_119190 = fluree.db.flake.min_subject_id(inst_119187);
var inst_119191 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_119192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119193 = [inst_119153];
var inst_119194 = (new cljs.core.PersistentVector(null,1,(5),inst_119192,inst_119193,null));
var inst_119195 = (function (){var subject_var = inst_119153;
var object_var = inst_119155;
var cid = inst_119187;
var max_sid = inst_119189;
var min_sid = inst_119190;
return ((function (subject_var,object_var,cid,max_sid,min_sid,inst_119155,inst_119153,inst_119186,inst_119187,inst_119188,inst_119189,inst_119190,inst_119191,inst_119192,inst_119193,inst_119194,state_val_119242,c__110077__auto__){
return (function (p1__119147_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__119147_SHARP_);
});
;})(subject_var,object_var,cid,max_sid,min_sid,inst_119155,inst_119153,inst_119186,inst_119187,inst_119188,inst_119189,inst_119190,inst_119191,inst_119192,inst_119193,inst_119194,state_val_119242,c__110077__auto__))
})();
var inst_119196 = (inst_119189 + (1));
var inst_119197 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_119190,inst_119196);
var inst_119198 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_119195,inst_119197);
var inst_119199 = cljs.core.PersistentHashMap.EMPTY;
var inst_119200 = [inst_119194,inst_119198,inst_119199];
var inst_119201 = cljs.core.PersistentHashMap.fromArrays(inst_119191,inst_119200);
var state_119241__$1 = state_119241;
var statearr_119250_119282 = state_119241__$1;
(statearr_119250_119282[(2)] = inst_119201);

(statearr_119250_119282[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (21))){
var inst_119206 = (state_119241[(7)]);
var inst_119210 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_119206);
var state_119241__$1 = state_119241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119241__$1,(23),inst_119210);
} else {
if((state_val_119242 === (13))){
var inst_119235 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
var statearr_119251_119283 = state_119241__$1;
(statearr_119251_119283[(2)] = inst_119235);

(statearr_119251_119283[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (22))){
var inst_119155 = (state_119241[(9)]);
var inst_119215 = (state_119241[(2)]);
var inst_119216 = fluree.db.flake.sid__GT_cid(inst_119215);
var inst_119217 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_119216);
var inst_119218 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_119219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119220 = [inst_119155];
var inst_119221 = (new cljs.core.PersistentVector(null,1,(5),inst_119219,inst_119220,null));
var inst_119222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119224 = [inst_119217];
var inst_119225 = (new cljs.core.PersistentVector(null,1,(5),inst_119223,inst_119224,null));
var inst_119226 = [inst_119225];
var inst_119227 = (new cljs.core.PersistentVector(null,1,(5),inst_119222,inst_119226,null));
var inst_119228 = cljs.core.PersistentHashMap.EMPTY;
var inst_119229 = [inst_119221,inst_119227,inst_119228];
var inst_119230 = cljs.core.PersistentHashMap.fromArrays(inst_119218,inst_119229);
var state_119241__$1 = state_119241;
var statearr_119252_119284 = state_119241__$1;
(statearr_119252_119284[(2)] = inst_119230);

(statearr_119252_119284[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (6))){
var inst_119153 = (state_119241[(8)]);
var state_119241__$1 = state_119241;
var statearr_119253_119285 = state_119241__$1;
(statearr_119253_119285[(2)] = inst_119153);

(statearr_119253_119285[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (17))){
var inst_119206 = (state_119241[(7)]);
var inst_119206__$1 = cljs.core.first(clause);
var inst_119207 = typeof inst_119206__$1 === 'number';
var state_119241__$1 = (function (){var statearr_119254 = state_119241;
(statearr_119254[(7)] = inst_119206__$1);

return statearr_119254;
})();
if(cljs.core.truth_(inst_119207)){
var statearr_119255_119286 = state_119241__$1;
(statearr_119255_119286[(1)] = (20));

} else {
var statearr_119256_119287 = state_119241__$1;
(statearr_119256_119287[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (3))){
var inst_119148 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
var statearr_119257_119288 = state_119241__$1;
(statearr_119257_119288[(2)] = inst_119148);


cljs.core.async.impl.ioc_helpers.process_exception(state_119241__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (12))){
var inst_119155 = (state_119241[(9)]);
var state_119241__$1 = state_119241;
if(cljs.core.truth_(inst_119155)){
var statearr_119258_119289 = state_119241__$1;
(statearr_119258_119289[(1)] = (17));

} else {
var statearr_119259_119290 = state_119241__$1;
(statearr_119259_119290[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (2))){
var inst_119239 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119241__$1,inst_119239);
} else {
if((state_val_119242 === (23))){
var inst_119212 = (state_119241[(2)]);
var inst_119213 = fluree.db.util.async.throw_err(inst_119212);
var state_119241__$1 = state_119241;
var statearr_119260_119291 = state_119241__$1;
(statearr_119260_119291[(2)] = inst_119213);

(statearr_119260_119291[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (19))){
var inst_119233 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
var statearr_119261_119292 = state_119241__$1;
(statearr_119261_119292[(2)] = inst_119233);

(statearr_119261_119292[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (11))){
var inst_119168 = ["_tx",null,"_block",null];
var inst_119169 = (new cljs.core.PersistentArrayMap(null,2,inst_119168,null));
var inst_119170 = (new cljs.core.PersistentHashSet(null,inst_119169,null));
var inst_119171 = cljs.core.last(clause);
var inst_119172 = (inst_119170.cljs$core$IFn$_invoke$arity$1 ? inst_119170.cljs$core$IFn$_invoke$arity$1(inst_119171) : inst_119170.call(null,inst_119171));
var state_119241__$1 = state_119241;
if(cljs.core.truth_(inst_119172)){
var statearr_119262_119293 = state_119241__$1;
(statearr_119262_119293[(1)] = (14));

} else {
var statearr_119263_119294 = state_119241__$1;
(statearr_119263_119294[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (9))){
var inst_119153 = (state_119241[(8)]);
var state_119241__$1 = state_119241;
if(cljs.core.truth_(inst_119153)){
var statearr_119264_119295 = state_119241__$1;
(statearr_119264_119295[(1)] = (11));

} else {
var statearr_119265_119296 = state_119241__$1;
(statearr_119265_119296[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (5))){
var inst_119155 = (state_119241[(9)]);
var state_119241__$1 = state_119241;
var statearr_119266_119297 = state_119241__$1;
(statearr_119266_119297[(2)] = inst_119155);

(statearr_119266_119297[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (14))){
var inst_119155 = (state_119241[(9)]);
var inst_119153 = (state_119241[(8)]);
var inst_119174 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_119175 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_119176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119177 = [inst_119153];
var inst_119178 = (new cljs.core.PersistentVector(null,1,(5),inst_119176,inst_119177,null));
var inst_119179 = (function (){var subject_var = inst_119153;
var object_var = inst_119155;
var min_sid = inst_119174;
var max_sid = (0);
return ((function (subject_var,object_var,min_sid,max_sid,inst_119155,inst_119153,inst_119174,inst_119175,inst_119176,inst_119177,inst_119178,state_val_119242,c__110077__auto__){
return (function (p1__119146_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__119146_SHARP_);
});
;})(subject_var,object_var,min_sid,max_sid,inst_119155,inst_119153,inst_119174,inst_119175,inst_119176,inst_119177,inst_119178,state_val_119242,c__110077__auto__))
})();
var inst_119180 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_119174,(0));
var inst_119181 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_119179,inst_119180);
var inst_119182 = cljs.core.PersistentHashMap.EMPTY;
var inst_119183 = [inst_119178,inst_119181,inst_119182];
var inst_119184 = cljs.core.PersistentHashMap.fromArrays(inst_119175,inst_119183);
var state_119241__$1 = state_119241;
var statearr_119267_119298 = state_119241__$1;
(statearr_119267_119298[(2)] = inst_119184);

(statearr_119267_119298[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (16))){
var inst_119203 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
var statearr_119268_119299 = state_119241__$1;
(statearr_119268_119299[(2)] = inst_119203);

(statearr_119268_119299[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (10))){
var inst_119237 = (state_119241[(2)]);
var state_119241__$1 = state_119241;
var statearr_119269_119300 = state_119241__$1;
(statearr_119269_119300[(2)] = inst_119237);


cljs.core.async.impl.ioc_helpers.process_exception(state_119241__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (18))){
var state_119241__$1 = state_119241;
var statearr_119270_119301 = state_119241__$1;
(statearr_119270_119301[(2)] = null);

(statearr_119270_119301[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119242 === (8))){
var inst_119161 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_119162 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_119163 = cljs.core.PersistentHashMap.fromArrays(inst_119161,inst_119162);
var inst_119164 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_119163);
var inst_119165 = (function(){throw inst_119164})();
var state_119241__$1 = state_119241;
var statearr_119271_119302 = state_119241__$1;
(statearr_119271_119302[(2)] = inst_119165);

(statearr_119271_119302[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_119272 = [null,null,null,null,null,null,null,null,null,null];
(statearr_119272[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__);

(statearr_119272[(1)] = (1));

return statearr_119272;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____1 = (function (state_119241){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_119241);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e119273){if((e119273 instanceof Object)){
var ex__109974__auto__ = e119273;
var statearr_119274_119303 = state_119241;
(statearr_119274_119303[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119241);

return cljs.core.cst$kw$recur;
} else {
throw e119273;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__119304 = state_119241;
state_119241 = G__119304;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__ = function(state_119241){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____1.call(this,state_119241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_119275 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_119275[(6)] = c__110077__auto__);

return statearr_119275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__119311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__119311 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__119311;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4523__auto__ = ((function (mean){
return (function fluree$db$query$analytical$variance_$_iter__119312(s__119313){
return (new cljs.core.LazySeq(null,((function (mean){
return (function (){
var s__119313__$1 = s__119313;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__119313__$1);
if(temp__5735__auto__){
var s__119313__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__119313__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__119313__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__119315 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__119314 = (0);
while(true){
if((i__119314 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__119314);
var delta = (x - mean);
cljs.core.chunk_append(b__119315,(delta * delta));

var G__119317 = (i__119314 + (1));
i__119314 = G__119317;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__119315),fluree$db$query$analytical$variance_$_iter__119312(cljs.core.chunk_rest(s__119313__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__119315),null);
}
} else {
var x = cljs.core.first(s__119313__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__119312(cljs.core.rest(s__119313__$2)));
}
} else {
return null;
}
break;
}
});})(mean))
,null,null));
});})(mean))
;
return iter__4523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__119316 = variance(coll);
return Math.sqrt(G__119316);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4219__auto__ = n;
var y__4220__auto__ = (- n);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
}),(function() {
var G__119318 = null;
var G__119318__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__119318__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__119318 = function(n,coll){
switch(arguments.length){
case 1:
return G__119318__1.call(this,n);
case 2:
return G__119318__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__119318.cljs$core$IFn$_invoke$arity$1 = G__119318__1;
G__119318.cljs$core$IFn$_invoke$arity$2 = G__119318__2;
return G__119318;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__119319 = null;
var G__119319__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__119319__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__119319 = function(n,coll){
switch(arguments.length){
case 1:
return G__119319__1.call(this,n);
case 2:
return G__119319__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__119319.cljs$core$IFn$_invoke$arity$1 = G__119319__1;
G__119319.cljs$core$IFn$_invoke$arity$2 = G__119319__2;
return G__119319;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__119320 = null;
var G__119320__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__119320__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__119320 = function(n,coll){
switch(arguments.length){
case 1:
return G__119320__1.call(this,n);
case 2:
return G__119320__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__119320.cljs$core$IFn$_invoke$arity$1 = G__119320__1;
G__119320.cljs$core$IFn$_invoke$arity$2 = G__119320__2;
return G__119320;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4120__auto__ = typeof x === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4120__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4120__auto__ = typeof x === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4120__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__119321 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119321,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119321,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119321,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return ((function (agg_fn,temp__5733__auto__,list_agg,as_QMARK_,as,func_list,list_count,vec__119321,fun,arg,var$){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
;})(agg_fn,temp__5733__auto__,list_agg,as_QMARK_,as,func_list,list_count,vec__119321,fun,arg,var$))
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__119324 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?((function (distinct_QMARK_,variable,list_agg,as_QMARK_,as,func_list,list_count,vec__119321,fun,arg,var$,agg_fn){
return (function (coll){
var G__119327 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__119327) : agg_fn.call(null,G__119327));
});})(distinct_QMARK_,variable,list_agg,as_QMARK_,as,func_list,list_count,vec__119321,fun,arg,var$,agg_fn))
:agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119324,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119324,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__119328 = agg;
var map__119328__$1 = (((((!((map__119328 == null))))?(((((map__119328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119328.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119328):map__119328);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119328__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119328__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119328__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__119331 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119331,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119331,(1),null);
var map__119334 = res__$1;
var map__119334__$1 = (((((!((map__119334 == null))))?(((((map__119334.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119334.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119334):map__119334);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119334__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119334__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__119331,as,agg_result,map__119334,map__119334__$1,headers,tuples){
return (function (p1__119330_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__119330_SHARP_),agg_result);
});})(vec__119331,as,agg_result,map__119334,map__119334__$1,headers,tuples))
,tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__119336_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__119336_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (a_tuple_part){
return (function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (a_tuple_part){
return (function (p1__119337_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__119337_SHARP_);
});})(a_tuple_part))
,b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = acc;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (a_tuple_part){
return (function (p1__119338_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__119338_SHARP_);
});})(a_tuple_part))
,b_not_idxs)));
} else {
return acc;
}
});})(a_tuple_part))
,null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__119339_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__119339_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv(((function (a_tuple_part){
return (function (p__119342,row,b_tuple){
var vec__119343 = p__119342;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119343,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119343,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__119343,acc,b_rows,a_tuple_part){
return (function (p1__119340_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__119340_SHARP_);
});})(vec__119343,acc,b_rows,a_tuple_part))
,b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = acc;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__119343,acc,b_rows,a_tuple_part){
return (function (p1__119341_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__119341_SHARP_);
});})(vec__119343,acc,b_rows,a_tuple_part))
,b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
});})(a_tuple_part))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__119346_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__119346_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__119347_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__119347_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__119352 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__119354 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__119353 = ((function (G__119354,common_keys,a_idxs,b_idxs){
return (function (p1__119348_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__119348_SHARP_);
});})(G__119354,common_keys,a_idxs,b_idxs))
;
return fexpr__119353(G__119354);
})()),cljs.core.set(b_idxs));
var fexpr__119351 = ((function (G__119352,common_keys,a_idxs,b_idxs){
return (function (p1__119349_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__119349_SHARP_);
});})(G__119352,common_keys,a_idxs,b_idxs))
;
return fexpr__119351(G__119352);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples){
return (function (p1__119350_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__119350_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples))
,b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__119355_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__119355_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__119356_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__119356_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__119361 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__119363 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__119362 = ((function (G__119363,common_keys,a_idxs,b_idxs){
return (function (p1__119357_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__119357_SHARP_);
});})(G__119363,common_keys,a_idxs,b_idxs))
;
return fexpr__119362(G__119363);
})()),cljs.core.set(b_idxs));
var fexpr__119360 = ((function (G__119361,common_keys,a_idxs,b_idxs){
return (function (p1__119358_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__119358_SHARP_);
});})(G__119361,common_keys,a_idxs,b_idxs))
;
return fexpr__119360(G__119361);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4131__auto__ = matches;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples){
return (function (p1__119359_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__119359_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,c_tuples))
,b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys){
return (function (p1__119364_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__119364_SHARP_);
});})(common_keys))
,common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs){
return (function (p1__119365_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__119365_SHARP_);
});})(common_keys,a_idxs))
,common_keys);
var b_not_idxs = (function (){var G__119374 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__119376 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__119375 = ((function (G__119376,common_keys,a_idxs,b_idxs){
return (function (p1__119366_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__119366_SHARP_);
});})(G__119376,common_keys,a_idxs,b_idxs))
;
return fexpr__119375(G__119376);
})()),cljs.core.set(b_idxs));
var fexpr__119373 = ((function (G__119374,common_keys,a_idxs,b_idxs){
return (function (p1__119367_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__119367_SHARP_);
});})(G__119374,common_keys,a_idxs,b_idxs))
;
return fexpr__119373(G__119374);
})();
var vec__119370 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (common_keys,a_idxs,b_idxs,b_not_idxs){
return (function (p__119377,a_tuple){
var vec__119378 = p__119377;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119378,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119378,(1),null);
var vec__119381 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119381,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119381,(1),null);
var matches__$1 = (function (){var or__4131__auto__ = matches;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
});})(common_keys,a_idxs,b_idxs,b_not_idxs))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119370,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119370,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows){
return (function (p1__119368_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__119368_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows))
,b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers){
return (function (p1__119369_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__119369_SHARP_);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers))
,c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs){
return (function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (b_tuple,common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs){
return (function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
});})(b_tuple,common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs))
,b_idxs__GT_c_idxs);
});})(common_keys,a_idxs,b_idxs,b_not_idxs,vec__119370,c_tuples,b_matched_rows,b_unmatched_rows,c_headers,b_idxs__GT_c_idxs))
,b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req)),")"].join('');
var vec__119385 = (function (){var or__4131__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119385,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119385,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (filter_code_req_str,vec__119385,filter_code_req_STAR_,_,filter_code_req_str_STAR_){
return (function (p1__119384_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__119384_SHARP_,filter_code_req_str_STAR_);
});})(filter_code_req_str,vec__119385,filter_code_req_STAR_,_,filter_code_req_str_STAR_))
,tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__119390 = (function (){var or__4131__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119390,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119390,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (var_atom,vec__119390,filt_STAR_,filt_vars,filt_str){
return (function (p1__119388_SHARP_){
return fluree.db.util.core.index_of(headers,p1__119388_SHARP_);
});})(var_atom,vec__119390,filt_STAR_,filt_vars,filt_str))
,cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (var_atom,vec__119390,filt_STAR_,filt_vars,filt_str,filt_vars_idxs){
return (function (acc,clause){
if(cljs.core.every_QMARK_(((function (var_atom,vec__119390,filt_STAR_,filt_vars,filt_str,filt_vars_idxs){
return (function (p1__119389_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__119389_SHARP_);
});})(var_atom,vec__119390,filt_STAR_,filt_vars,filt_str,filt_vars_idxs))
,filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
});})(var_atom,vec__119390,filt_STAR_,filt_vars,filt_str,filt_vars_idxs))
,cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__119393,filters,optional_QMARK_){
var map__119394 = p__119393;
var map__119394__$1 = (((((!((map__119394 == null))))?(((((map__119394.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119394.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119394):map__119394);
var tuple_map = map__119394__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119394__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119394__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119394__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__119396 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119396,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119396,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__119399 = res;
var map__119399__$1 = (((((!((map__119399 == null))))?(((((map__119399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119399.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119399):map__119399);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119399__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119399__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_119454){
var state_val_119455 = (state_119454[(1)]);
if((state_val_119455 === (7))){
var inst_119428 = (state_119454[(7)]);
var inst_119426 = (state_119454[(2)]);
var inst_119427 = fluree.db.util.async.throw_err(inst_119426);
var inst_119428__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119427,(0),null);
var inst_119429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119427,(1),null);
var inst_119430 = (inst_119428__$1 == null);
var state_119454__$1 = (function (){var statearr_119456 = state_119454;
(statearr_119456[(8)] = inst_119429);

(statearr_119456[(7)] = inst_119428__$1);

return statearr_119456;
})();
if(cljs.core.truth_(inst_119430)){
var statearr_119457_119485 = state_119454__$1;
(statearr_119457_119485[(1)] = (8));

} else {
var statearr_119458_119486 = state_119454__$1;
(statearr_119458_119486[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (1))){
var inst_119408 = cljs.core.seq(optional_clauses);
var inst_119409 = cljs.core.first(inst_119408);
var inst_119410 = cljs.core.next(inst_119408);
var inst_119411 = optional_clauses;
var inst_119412 = where_tuples;
var state_119454__$1 = (function (){var statearr_119459 = state_119454;
(statearr_119459[(9)] = inst_119410);

(statearr_119459[(10)] = inst_119411);

(statearr_119459[(11)] = inst_119409);

(statearr_119459[(12)] = inst_119412);

return statearr_119459;
})();
var statearr_119460_119487 = state_119454__$1;
(statearr_119460_119487[(2)] = null);

(statearr_119460_119487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (4))){
var inst_119418 = (state_119454[(13)]);
var inst_119419 = (state_119454[(14)]);
var inst_119412 = (state_119454[(12)]);
var inst_119424 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_119412,inst_119418,inst_119419,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_119412,inst_119418,inst_119419,true,fuel,max_fuel,opts));
var state_119454__$1 = state_119454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119454__$1,(7),inst_119424);
} else {
if((state_val_119455 === (15))){
var state_119454__$1 = state_119454;
var statearr_119461_119488 = state_119454__$1;
(statearr_119461_119488[(2)] = null);

(statearr_119461_119488[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (13))){
var inst_119445 = (state_119454[(2)]);
var state_119454__$1 = state_119454;
var statearr_119462_119489 = state_119454__$1;
(statearr_119462_119489[(2)] = inst_119445);

(statearr_119462_119489[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (6))){
var inst_119450 = (state_119454[(2)]);
var state_119454__$1 = state_119454;
var statearr_119463_119490 = state_119454__$1;
(statearr_119463_119490[(2)] = inst_119450);

(statearr_119463_119490[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (3))){
var inst_119452 = (state_119454[(2)]);
var state_119454__$1 = state_119454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119454__$1,inst_119452);
} else {
if((state_val_119455 === (12))){
var state_119454__$1 = state_119454;
var statearr_119464_119491 = state_119454__$1;
(statearr_119464_119491[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (2))){
var inst_119411 = (state_119454[(10)]);
var inst_119418 = (state_119454[(13)]);
var inst_119417 = cljs.core.seq(inst_119411);
var inst_119418__$1 = cljs.core.first(inst_119417);
var inst_119419 = cljs.core.next(inst_119417);
var state_119454__$1 = (function (){var statearr_119466 = state_119454;
(statearr_119466[(13)] = inst_119418__$1);

(statearr_119466[(14)] = inst_119419);

return statearr_119466;
})();
if(cljs.core.truth_(inst_119418__$1)){
var statearr_119467_119492 = state_119454__$1;
(statearr_119467_119492[(1)] = (4));

} else {
var statearr_119468_119493 = state_119454__$1;
(statearr_119468_119493[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (11))){
var inst_119429 = (state_119454[(8)]);
var inst_119428 = (state_119454[(7)]);
var inst_119411 = inst_119429;
var inst_119412 = inst_119428;
var state_119454__$1 = (function (){var statearr_119469 = state_119454;
(statearr_119469[(10)] = inst_119411);

(statearr_119469[(12)] = inst_119412);

return statearr_119469;
})();
var statearr_119470_119494 = state_119454__$1;
(statearr_119470_119494[(2)] = null);

(statearr_119470_119494[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (9))){
var inst_119418 = (state_119454[(13)]);
var inst_119434 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_119418);
var state_119454__$1 = state_119454;
if(cljs.core.truth_(inst_119434)){
var statearr_119471_119495 = state_119454__$1;
(statearr_119471_119495[(1)] = (11));

} else {
var statearr_119472_119496 = state_119454__$1;
(statearr_119472_119496[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (5))){
var inst_119412 = (state_119454[(12)]);
var state_119454__$1 = state_119454;
var statearr_119473_119497 = state_119454__$1;
(statearr_119473_119497[(2)] = inst_119412);

(statearr_119473_119497[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (14))){
var inst_119429 = (state_119454[(8)]);
var inst_119428 = (state_119454[(7)]);
var inst_119412 = (state_119454[(12)]);
var inst_119439 = fluree.db.query.analytical.left_outer_join(inst_119412,inst_119428);
var inst_119411 = inst_119429;
var inst_119412__$1 = inst_119439;
var state_119454__$1 = (function (){var statearr_119474 = state_119454;
(statearr_119474[(10)] = inst_119411);

(statearr_119474[(12)] = inst_119412__$1);

return statearr_119474;
})();
var statearr_119475_119498 = state_119454__$1;
(statearr_119475_119498[(2)] = null);

(statearr_119475_119498[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (16))){
var inst_119443 = (state_119454[(2)]);
var state_119454__$1 = state_119454;
var statearr_119477_119499 = state_119454__$1;
(statearr_119477_119499[(2)] = inst_119443);

(statearr_119477_119499[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (10))){
var inst_119447 = (state_119454[(2)]);
var state_119454__$1 = state_119454;
var statearr_119478_119500 = state_119454__$1;
(statearr_119478_119500[(2)] = inst_119447);

(statearr_119478_119500[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119455 === (8))){
var inst_119429 = (state_119454[(8)]);
var inst_119412 = (state_119454[(12)]);
var tmp119476 = inst_119412;
var inst_119411 = inst_119429;
var inst_119412__$1 = tmp119476;
var state_119454__$1 = (function (){var statearr_119479 = state_119454;
(statearr_119479[(10)] = inst_119411);

(statearr_119479[(12)] = inst_119412__$1);

return statearr_119479;
})();
var statearr_119480_119501 = state_119454__$1;
(statearr_119480_119501[(2)] = null);

(statearr_119480_119501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____0 = (function (){
var statearr_119481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119481[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__);

(statearr_119481[(1)] = (1));

return statearr_119481;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____1 = (function (state_119454){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_119454);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e119482){if((e119482 instanceof Object)){
var ex__109974__auto__ = e119482;
var statearr_119483_119502 = state_119454;
(statearr_119483_119502[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119454);

return cljs.core.cst$kw$recur;
} else {
throw e119482;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__119503 = state_119454;
state_119454 = G__119503;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__ = function(state_119454){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____1.call(this,state_119454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_119484 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_119484[(6)] = c__110077__auto__);

return statearr_119484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__119505){
var vec__119506 = p__119505;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119506,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__119506,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__119506,var_name,var_val){
return (function (p1__119504_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__119504_SHARP_,var_val);
});})(vec__119506,var_name,var_val))
,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__119510,p__119511,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__119512 = p__119510;
var map__119512__$1 = (((((!((map__119512 == null))))?(((((map__119512.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119512.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119512):map__119512);
var q_map = map__119512__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119512__$1,cljs.core.cst$kw$prefixes);
var map__119513 = p__119511;
var map__119513__$1 = (((((!((map__119513 == null))))?(((((map__119513.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__119513.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__119513):map__119513);
var res = map__119513__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__119513__$1,cljs.core.cst$kw$vars);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars){
return (function (state_119718){
var state_val_119719 = (state_119718[(1)]);
if((state_val_119719 === (7))){
var inst_119714 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119720_119800 = state_119718__$1;
(statearr_119720_119800[(2)] = inst_119714);


cljs.core.async.impl.ioc_helpers.process_exception(state_119718__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (20))){
var inst_119523 = (state_119718[(7)]);
var inst_119552 = (state_119718[(8)]);
var inst_119549 = (state_119718[(9)]);
var inst_119551 = (state_119718[(10)]);
var inst_119547 = (state_119718[(11)]);
var inst_119559 = (state_119718[(12)]);
var inst_119558 = (state_119718[(13)]);
var inst_119550 = (state_119718[(14)]);
var inst_119563 = (state_119718[(2)]);
var inst_119564 = fluree.db.util.async.throw_err(inst_119563);
var inst_119565 = (function (){var seq__119555 = inst_119559;
var first__119546 = inst_119549;
var vec__119554 = inst_119551;
var new_res = inst_119564;
var rest = inst_119559;
var seq__119545 = inst_119550;
var vec__119544 = inst_119547;
var tuples = inst_119552;
var G__119543 = inst_119551;
var pred__119524 = cljs.core._EQ_;
var segment_type = inst_119523;
var expr__119525 = inst_119523;
var first__119556 = inst_119558;
var clause_group = inst_119558;
return ((function (seq__119555,first__119546,vec__119554,new_res,rest,seq__119545,vec__119544,tuples,G__119543,pred__119524,segment_type,expr__119525,first__119556,clause_group,inst_119523,inst_119552,inst_119549,inst_119551,inst_119547,inst_119559,inst_119558,inst_119550,inst_119563,inst_119564,state_val_119719,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars){
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
;})(seq__119555,first__119546,vec__119554,new_res,rest,seq__119545,vec__119544,tuples,G__119543,pred__119524,segment_type,expr__119525,first__119556,clause_group,inst_119523,inst_119552,inst_119549,inst_119551,inst_119547,inst_119559,inst_119558,inst_119550,inst_119563,inst_119564,state_val_119719,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars))
})();
var inst_119566 = cljs.core.keys(vars);
var inst_119567 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_119565,inst_119564,inst_119566);
var inst_119568 = fluree.db.query.analytical.res_absorb_vars(inst_119567);
var state_119718__$1 = (function (){var statearr_119721 = state_119718;
(statearr_119721[(15)] = inst_119568);

return statearr_119721;
})();
if(cljs.core.truth_(inst_119552)){
var statearr_119722_119801 = state_119718__$1;
(statearr_119722_119801[(1)] = (21));

} else {
var statearr_119723_119802 = state_119718__$1;
(statearr_119723_119802[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (58))){
var inst_119688 = (state_119718[(16)]);
var inst_119691 = (state_119718[(2)]);
var inst_119692 = fluree.db.util.async.throw_err(inst_119691);
var inst_119693 = [inst_119692,r];
var inst_119694 = (new cljs.core.PersistentVector(null,2,(5),inst_119688,inst_119693,null));
var state_119718__$1 = state_119718;
var statearr_119724_119803 = state_119718__$1;
(statearr_119724_119803[(2)] = inst_119694);

(statearr_119724_119803[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (27))){
var inst_119599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119600 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_119601 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_119600,optional_QMARK_);
var inst_119602 = [inst_119601,r];
var inst_119603 = (new cljs.core.PersistentVector(null,2,(5),inst_119599,inst_119602,null));
var state_119718__$1 = state_119718;
var statearr_119725_119804 = state_119718__$1;
(statearr_119725_119804[(2)] = inst_119603);

(statearr_119725_119804[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (1))){
var state_119718__$1 = state_119718;
var statearr_119726_119805 = state_119718__$1;
(statearr_119726_119805[(2)] = null);

(statearr_119726_119805[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (24))){
var inst_119523 = (state_119718[(7)]);
var inst_119587 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_119588 = (function (){var segment_type = inst_119523;
var pred__119524 = cljs.core._EQ_;
var expr__119525 = inst_119523;
var bindings = inst_119587;
return ((function (segment_type,pred__119524,expr__119525,bindings,inst_119523,inst_119587,state_val_119719,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars){
return (function (p1__119509_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__119509_SHARP_);
});
;})(segment_type,pred__119524,expr__119525,bindings,inst_119523,inst_119587,state_val_119719,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars))
})();
var inst_119589 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_119588,inst_119587);
var inst_119590 = cljs.core.PersistentHashMap.EMPTY;
var inst_119591 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_119590,inst_119589);
var inst_119592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119593 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_119591);
var inst_119594 = [inst_119593,r];
var inst_119595 = (new cljs.core.PersistentVector(null,2,(5),inst_119592,inst_119594,null));
var state_119718__$1 = state_119718;
var statearr_119727_119806 = state_119718__$1;
(statearr_119727_119806[(2)] = inst_119595);

(statearr_119727_119806[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (55))){
var inst_119671 = (state_119718[(17)]);
var inst_119670 = (state_119718[(18)]);
var inst_119688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119689 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_119670,res,inst_119671,fuel,max_fuel);
var state_119718__$1 = (function (){var statearr_119728 = state_119718;
(statearr_119728[(16)] = inst_119688);

return statearr_119728;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(58),inst_119689);
} else {
if((state_val_119719 === (39))){
var inst_119708 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119729_119807 = state_119718__$1;
(statearr_119729_119807[(2)] = inst_119708);

(statearr_119729_119807[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (46))){
var inst_119704 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119730_119808 = state_119718__$1;
(statearr_119730_119808[(2)] = inst_119704);

(statearr_119730_119808[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119718,(3),Error,null,(2));
var inst_119520 = cljs.core.map_QMARK_(clause);
var state_119718__$1 = state_119718;
if(inst_119520){
var statearr_119731_119809 = state_119718__$1;
(statearr_119731_119809[(1)] = (5));

} else {
var statearr_119732_119810 = state_119718__$1;
(statearr_119732_119810[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (54))){
var inst_119699 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119733_119811 = state_119718__$1;
(statearr_119733_119811[(2)] = inst_119699);

(statearr_119733_119811[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (15))){
var inst_119551 = (state_119718[(10)]);
var inst_119558 = (state_119718[(13)]);
var inst_119557 = cljs.core.seq(inst_119551);
var inst_119558__$1 = cljs.core.first(inst_119557);
var inst_119559 = cljs.core.next(inst_119557);
var state_119718__$1 = (function (){var statearr_119734 = state_119718;
(statearr_119734[(12)] = inst_119559);

(statearr_119734[(13)] = inst_119558__$1);

return statearr_119734;
})();
if(cljs.core.truth_(inst_119558__$1)){
var statearr_119735_119812 = state_119718__$1;
(statearr_119735_119812[(1)] = (17));

} else {
var statearr_119736_119813 = state_119718__$1;
(statearr_119736_119813[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (48))){
var inst_119671 = (state_119718[(17)]);
var inst_119674 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_119671,r,res,optional_QMARK_,fuel,max_fuel);
var state_119718__$1 = state_119718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(51),inst_119674);
} else {
if((state_val_119719 === (50))){
var inst_119701 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119737_119814 = state_119718__$1;
(statearr_119737_119814[(2)] = inst_119701);

(statearr_119737_119814[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (21))){
var inst_119568 = (state_119718[(15)]);
var inst_119552 = (state_119718[(8)]);
var inst_119559 = (state_119718[(12)]);
var inst_119570 = fluree.db.query.analytical.outer_union(inst_119552,inst_119568);
var inst_119551 = inst_119559;
var inst_119552__$1 = inst_119570;
var state_119718__$1 = (function (){var statearr_119738 = state_119718;
(statearr_119738[(8)] = inst_119552__$1);

(statearr_119738[(10)] = inst_119551);

return statearr_119738;
})();
var statearr_119739_119815 = state_119718__$1;
(statearr_119739_119815[(2)] = null);

(statearr_119739_119815[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (31))){
var inst_119628 = cljs.core.count(clause);
var inst_119629 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_119628);
var inst_119630 = cljs.core.second(clause);
var inst_119631 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_119630,"rdf:type");
var inst_119632 = ((inst_119629) && (inst_119631));
var state_119718__$1 = state_119718;
if(cljs.core.truth_(inst_119632)){
var statearr_119740_119816 = state_119718__$1;
(statearr_119740_119816[(1)] = (33));

} else {
var statearr_119741_119817 = state_119718__$1;
(statearr_119741_119817[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (32))){
var inst_119712 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119742_119818 = state_119718__$1;
(statearr_119742_119818[(2)] = inst_119712);

(statearr_119742_119818[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (40))){
var inst_119645 = (state_119718[(19)]);
var inst_119648 = (state_119718[(2)]);
var inst_119649 = fluree.db.util.async.throw_err(inst_119648);
var inst_119650 = [inst_119649,r];
var inst_119651 = (new cljs.core.PersistentVector(null,2,(5),inst_119645,inst_119650,null));
var state_119718__$1 = state_119718;
var statearr_119743_119819 = state_119718__$1;
(statearr_119743_119819[(2)] = inst_119651);

(statearr_119743_119819[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (56))){
var state_119718__$1 = state_119718;
var statearr_119744_119820 = state_119718__$1;
(statearr_119744_119820[(2)] = null);

(statearr_119744_119820[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (33))){
var inst_119634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119635 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_119718__$1 = (function (){var statearr_119745 = state_119718;
(statearr_119745[(20)] = inst_119634);

return statearr_119745;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(36),inst_119635);
} else {
if((state_val_119719 === (13))){
var inst_119523 = (state_119718[(7)]);
var inst_119585 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$bind,inst_119523);
var state_119718__$1 = state_119718;
if(inst_119585){
var statearr_119746_119821 = state_119718__$1;
(statearr_119746_119821[(1)] = (24));

} else {
var statearr_119747_119822 = state_119718__$1;
(statearr_119747_119822[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (22))){
var inst_119568 = (state_119718[(15)]);
var inst_119559 = (state_119718[(12)]);
var inst_119551 = inst_119559;
var inst_119552 = inst_119568;
var state_119718__$1 = (function (){var statearr_119748 = state_119718;
(statearr_119748[(8)] = inst_119552);

(statearr_119748[(10)] = inst_119551);

return statearr_119748;
})();
var statearr_119749_119823 = state_119718__$1;
(statearr_119749_119823[(2)] = null);

(statearr_119749_119823[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (36))){
var inst_119634 = (state_119718[(20)]);
var inst_119637 = (state_119718[(2)]);
var inst_119638 = fluree.db.util.async.throw_err(inst_119637);
var inst_119639 = [inst_119638,r];
var inst_119640 = (new cljs.core.PersistentVector(null,2,(5),inst_119634,inst_119639,null));
var state_119718__$1 = state_119718;
var statearr_119750_119824 = state_119718__$1;
(statearr_119750_119824[(2)] = inst_119640);

(statearr_119750_119824[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (41))){
var inst_119656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119657 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_119658 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_119657);
var inst_119659 = [inst_119658,r];
var inst_119660 = (new cljs.core.PersistentVector(null,2,(5),inst_119656,inst_119659,null));
var state_119718__$1 = state_119718;
var statearr_119751_119825 = state_119718__$1;
(statearr_119751_119825[(2)] = inst_119660);

(statearr_119751_119825[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (43))){
var inst_119706 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119752_119826 = state_119718__$1;
(statearr_119752_119826[(2)] = inst_119706);

(statearr_119752_119826[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (29))){
var inst_119609 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119753_119827 = state_119718__$1;
(statearr_119753_119827[(2)] = inst_119609);

(statearr_119753_119827[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (44))){
var inst_119666 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_119718__$1 = state_119718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(47),inst_119666);
} else {
if((state_val_119719 === (6))){
var inst_119617 = cljs.core.count(clause);
var inst_119618 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_119617);
var inst_119619 = cljs.core.second(clause);
var inst_119620 = clojure.string.starts_with_QMARK_(inst_119619,"fullText:");
var inst_119621 = ((inst_119618) && (inst_119620));
var state_119718__$1 = state_119718;
if(cljs.core.truth_(inst_119621)){
var statearr_119754_119828 = state_119718__$1;
(statearr_119754_119828[(1)] = (30));

} else {
var statearr_119755_119829 = state_119718__$1;
(statearr_119755_119829[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (28))){
var inst_119523 = (state_119718[(7)]);
var inst_119605 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_119523)].join('');
var inst_119606 = (new Error(inst_119605));
var inst_119607 = (function(){throw inst_119606})();
var state_119718__$1 = state_119718;
var statearr_119756_119830 = state_119718__$1;
(statearr_119756_119830[(2)] = inst_119607);

(statearr_119756_119830[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (51))){
var inst_119676 = (state_119718[(2)]);
var inst_119677 = fluree.db.util.async.throw_err(inst_119676);
var state_119718__$1 = state_119718;
var statearr_119757_119831 = state_119718__$1;
(statearr_119757_119831[(2)] = inst_119677);

(statearr_119757_119831[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (25))){
var inst_119523 = (state_119718[(7)]);
var inst_119597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$filter,inst_119523);
var state_119718__$1 = state_119718;
if(inst_119597){
var statearr_119758_119832 = state_119718__$1;
(statearr_119758_119832[(1)] = (27));

} else {
var statearr_119759_119833 = state_119718__$1;
(statearr_119759_119833[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (34))){
var inst_119642 = cljs.core.count(clause);
var inst_119643 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_119642);
var state_119718__$1 = state_119718;
if(inst_119643){
var statearr_119760_119834 = state_119718__$1;
(statearr_119760_119834[(1)] = (37));

} else {
var statearr_119761_119835 = state_119718__$1;
(statearr_119761_119835[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (17))){
var inst_119558 = (state_119718[(13)]);
var inst_119561 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_119558,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_119558,q_map,vars,fuel,max_fuel,opts));
var state_119718__$1 = state_119718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(20),inst_119561);
} else {
if((state_val_119719 === (3))){
var inst_119516 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119762_119836 = state_119718__$1;
(statearr_119762_119836[(2)] = inst_119516);


cljs.core.async.impl.ioc_helpers.process_exception(state_119718__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (12))){
var inst_119547 = (state_119718[(11)]);
var inst_119547__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_119548 = cljs.core.seq(inst_119547__$1);
var inst_119549 = cljs.core.first(inst_119548);
var inst_119550 = cljs.core.next(inst_119548);
var inst_119551 = inst_119547__$1;
var inst_119552 = null;
var state_119718__$1 = (function (){var statearr_119763 = state_119718;
(statearr_119763[(8)] = inst_119552);

(statearr_119763[(9)] = inst_119549);

(statearr_119763[(10)] = inst_119551);

(statearr_119763[(11)] = inst_119547__$1);

(statearr_119763[(14)] = inst_119550);

return statearr_119763;
})();
var statearr_119764_119837 = state_119718__$1;
(statearr_119764_119837[(2)] = null);

(statearr_119764_119837[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (2))){
var inst_119716 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119718__$1,inst_119716);
} else {
if((state_val_119719 === (23))){
var inst_119575 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119765_119838 = state_119718__$1;
(statearr_119765_119838[(2)] = inst_119575);

(statearr_119765_119838[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (47))){
var inst_119670 = (state_119718[(18)]);
var inst_119668 = (state_119718[(2)]);
var inst_119669 = fluree.db.util.async.throw_err(inst_119668);
var inst_119670__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119669,(0),null);
var inst_119671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119669,(1),null);
var inst_119672 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_119670__$1);
var state_119718__$1 = (function (){var statearr_119766 = state_119718;
(statearr_119766[(17)] = inst_119671);

(statearr_119766[(18)] = inst_119670__$1);

return statearr_119766;
})();
if(inst_119672){
var statearr_119767_119839 = state_119718__$1;
(statearr_119767_119839[(1)] = (48));

} else {
var statearr_119768_119840 = state_119718__$1;
(statearr_119768_119840[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (35))){
var inst_119710 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119769_119841 = state_119718__$1;
(statearr_119769_119841[(2)] = inst_119710);

(statearr_119769_119841[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (19))){
var inst_119581 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119770_119842 = state_119718__$1;
(statearr_119770_119842[(2)] = inst_119581);

(statearr_119770_119842[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (57))){
var inst_119697 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119771_119843 = state_119718__$1;
(statearr_119771_119843[(2)] = inst_119697);

(statearr_119771_119843[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (11))){
var inst_119529 = (state_119718[(21)]);
var inst_119533 = (state_119718[(2)]);
var inst_119534 = fluree.db.util.async.throw_err(inst_119533);
var inst_119535 = [inst_119534,r];
var inst_119536 = (new cljs.core.PersistentVector(null,2,(5),inst_119529,inst_119535,null));
var state_119718__$1 = state_119718;
var statearr_119772_119844 = state_119718__$1;
(statearr_119772_119844[(2)] = inst_119536);

(statearr_119772_119844[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (9))){
var inst_119523 = (state_119718[(7)]);
var inst_119538 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$union,inst_119523);
var state_119718__$1 = state_119718;
if(inst_119538){
var statearr_119773_119845 = state_119718__$1;
(statearr_119773_119845[(1)] = (12));

} else {
var statearr_119774_119846 = state_119718__$1;
(statearr_119774_119846[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (5))){
var inst_119523 = (state_119718[(7)]);
var inst_119522 = cljs.core.keys(clause);
var inst_119523__$1 = cljs.core.first(inst_119522);
var inst_119527 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optional,inst_119523__$1);
var state_119718__$1 = (function (){var statearr_119775 = state_119718;
(statearr_119775[(7)] = inst_119523__$1);

return statearr_119775;
})();
if(inst_119527){
var statearr_119776_119847 = state_119718__$1;
(statearr_119776_119847[(1)] = (8));

} else {
var statearr_119777_119848 = state_119718__$1;
(statearr_119777_119848[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (14))){
var inst_119613 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119778_119849 = state_119718__$1;
(statearr_119778_119849[(2)] = inst_119613);

(statearr_119778_119849[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (45))){
var state_119718__$1 = state_119718;
var statearr_119779_119850 = state_119718__$1;
(statearr_119779_119850[(2)] = null);

(statearr_119779_119850[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (53))){
var state_119718__$1 = state_119718;
var statearr_119780_119851 = state_119718__$1;
(statearr_119780_119851[(1)] = (55));



return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (26))){
var inst_119611 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119782_119852 = state_119718__$1;
(statearr_119782_119852[(2)] = inst_119611);

(statearr_119782_119852[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (16))){
var inst_119583 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119783_119853 = state_119718__$1;
(statearr_119783_119853[(2)] = inst_119583);

(statearr_119783_119853[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (38))){
var inst_119653 = cljs.core.count(clause);
var inst_119654 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_119653);
var state_119718__$1 = state_119718;
if(inst_119654){
var statearr_119784_119854 = state_119718__$1;
(statearr_119784_119854[(1)] = (41));

} else {
var statearr_119785_119855 = state_119718__$1;
(statearr_119785_119855[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (30))){
var inst_119623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119624 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_119625 = [inst_119624,r];
var inst_119626 = (new cljs.core.PersistentVector(null,2,(5),inst_119623,inst_119625,null));
var state_119718__$1 = state_119718;
var statearr_119786_119856 = state_119718__$1;
(statearr_119786_119856[(2)] = inst_119626);

(statearr_119786_119856[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (10))){
var inst_119615 = (state_119718[(2)]);
var state_119718__$1 = state_119718;
var statearr_119787_119857 = state_119718__$1;
(statearr_119787_119857[(2)] = inst_119615);

(statearr_119787_119857[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (18))){
var inst_119552 = (state_119718[(8)]);
var inst_119577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119578 = [inst_119552,r];
var inst_119579 = (new cljs.core.PersistentVector(null,2,(5),inst_119577,inst_119578,null));
var state_119718__$1 = state_119718;
var statearr_119788_119858 = state_119718__$1;
(statearr_119788_119858[(2)] = inst_119579);

(statearr_119788_119858[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (52))){
var inst_119671 = (state_119718[(17)]);
var inst_119670 = (state_119718[(18)]);
var inst_119682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119683 = fluree.db.query.analytical.full_text__GT_tuples(inst_119670,res,inst_119671);
var inst_119684 = [inst_119683,r];
var inst_119685 = (new cljs.core.PersistentVector(null,2,(5),inst_119682,inst_119684,null));
var state_119718__$1 = state_119718;
var statearr_119789_119859 = state_119718__$1;
(statearr_119789_119859[(2)] = inst_119685);

(statearr_119789_119859[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (42))){
var state_119718__$1 = state_119718;
var statearr_119790_119860 = state_119718__$1;
(statearr_119790_119860[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_119719 === (37))){
var inst_119645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119646 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_119718__$1 = (function (){var statearr_119792 = state_119718;
(statearr_119792[(19)] = inst_119645);

return statearr_119792;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(40),inst_119646);
} else {
if((state_val_119719 === (8))){
var inst_119529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_119530 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_119531 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_119530,res,fuel,max_fuel,opts);
var state_119718__$1 = (function (){var statearr_119793 = state_119718;
(statearr_119793[(21)] = inst_119529);

return statearr_119793;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119718__$1,(11),inst_119531);
} else {
if((state_val_119719 === (49))){
var inst_119671 = (state_119718[(17)]);
var inst_119679 = cljs.core.second(inst_119671);
var inst_119680 = clojure.string.starts_with_QMARK_(inst_119679,"fullText:");
var state_119718__$1 = state_119718;
if(inst_119680){
var statearr_119794_119861 = state_119718__$1;
(statearr_119794_119861[(1)] = (52));

} else {
var statearr_119795_119862 = state_119718__$1;
(statearr_119795_119862[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars){
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_119796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119796[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__);

(statearr_119796[(1)] = (1));

return statearr_119796;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____1 = (function (state_119718){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_119718);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e119797){if((e119797 instanceof Object)){
var ex__109974__auto__ = e119797;
var statearr_119798_119863 = state_119718;
(statearr_119798_119863[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119718);

return cljs.core.cst$kw$recur;
} else {
throw e119797;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__119864 = state_119718;
state_119718 = G__119864;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__ = function(state_119718){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____1.call(this,state_119718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars))
})();
var state__110079__auto__ = (function (){var statearr_119799 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_119799[(6)] = c__110077__auto__);

return statearr_119799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__119512,map__119512__$1,q_map,prefixes,map__119513,map__119513__$1,res,vars))
);

return c__110077__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__119866 = arguments.length;
switch (G__119866) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_119942){
var state_val_119943 = (state_119942[(1)]);
if((state_val_119943 === (7))){
var inst_119893 = (state_119942[(7)]);
var inst_119892 = (state_119942[(8)]);
var inst_119886 = (state_119942[(9)]);
var inst_119898 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_119886,inst_119892,inst_119893,false,fuel,max_fuel,opts);
var state_119942__$1 = state_119942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_119942__$1,(10),inst_119898);
} else {
if((state_val_119943 === (20))){
var inst_119903 = (state_119942[(10)]);
var inst_119886 = (state_119942[(9)]);
var tmp119944 = inst_119886;
var inst_119885 = inst_119903;
var inst_119886__$1 = tmp119944;
var state_119942__$1 = (function (){var statearr_119945 = state_119942;
(statearr_119945[(11)] = inst_119885);

(statearr_119945[(9)] = inst_119886__$1);

return statearr_119945;
})();
var statearr_119946_119986 = state_119942__$1;
(statearr_119946_119986[(2)] = null);

(statearr_119946_119986[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (1))){
var state_119942__$1 = state_119942;
var statearr_119947_119987 = state_119942__$1;
(statearr_119947_119987[(2)] = null);

(statearr_119947_119987[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (24))){
var state_119942__$1 = state_119942;
var statearr_119948_119988 = state_119942__$1;
(statearr_119948_119988[(2)] = null);

(statearr_119948_119988[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_119942,(3),Error,null,(2));
var inst_119878 = cljs.core.seq(where);
var inst_119879 = cljs.core.first(inst_119878);
var inst_119880 = cljs.core.next(inst_119878);
var inst_119881 = [cljs.core.cst$kw$vars];
var inst_119882 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_119883 = [inst_119882];
var inst_119884 = cljs.core.PersistentHashMap.fromArrays(inst_119881,inst_119883);
var inst_119885 = where;
var inst_119886 = inst_119884;
var state_119942__$1 = (function (){var statearr_119949 = state_119942;
(statearr_119949[(12)] = inst_119880);

(statearr_119949[(11)] = inst_119885);

(statearr_119949[(13)] = inst_119879);

(statearr_119949[(9)] = inst_119886);

return statearr_119949;
})();
var statearr_119950_119989 = state_119942__$1;
(statearr_119950_119989[(2)] = null);

(statearr_119950_119989[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (15))){
var inst_119902 = (state_119942[(14)]);
var inst_119918 = (inst_119902 == null);
var state_119942__$1 = state_119942;
if(cljs.core.truth_(inst_119918)){
var statearr_119951_119990 = state_119942__$1;
(statearr_119951_119990[(1)] = (20));

} else {
var statearr_119952_119991 = state_119942__$1;
(statearr_119952_119991[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (21))){
var state_119942__$1 = state_119942;
var statearr_119953_119992 = state_119942__$1;
(statearr_119953_119992[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (13))){
var inst_119933 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119955_119993 = state_119942__$1;
(statearr_119955_119993[(2)] = inst_119933);

(statearr_119955_119993[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (22))){
var inst_119929 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119956_119994 = state_119942__$1;
(statearr_119956_119994[(2)] = inst_119929);

(statearr_119956_119994[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (6))){
var inst_119938 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119957_119995 = state_119942__$1;
(statearr_119957_119995[(2)] = inst_119938);


cljs.core.async.impl.ioc_helpers.process_exception(state_119942__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (25))){
var inst_119927 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119958_119996 = state_119942__$1;
(statearr_119958_119996[(2)] = inst_119927);

(statearr_119958_119996[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (17))){
var inst_119902 = (state_119942[(14)]);
var state_119942__$1 = state_119942;
var statearr_119959_119997 = state_119942__$1;
(statearr_119959_119997[(2)] = inst_119902);

(statearr_119959_119997[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (3))){
var inst_119867 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119960_119998 = state_119942__$1;
(statearr_119960_119998[(2)] = inst_119867);


cljs.core.async.impl.ioc_helpers.process_exception(state_119942__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (12))){
var inst_119886 = (state_119942[(9)]);
var inst_119909 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_119886,cljs.core.cst$kw$vars);
var inst_119910 = cljs.core.empty_QMARK_(inst_119909);
var state_119942__$1 = state_119942;
if(inst_119910){
var statearr_119961_119999 = state_119942__$1;
(statearr_119961_119999[(1)] = (14));

} else {
var statearr_119962_120000 = state_119942__$1;
(statearr_119962_120000[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (2))){
var inst_119940 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_119942__$1,inst_119940);
} else {
if((state_val_119943 === (23))){
var inst_119902 = (state_119942[(14)]);
var inst_119903 = (state_119942[(10)]);
var inst_119886 = (state_119942[(9)]);
var inst_119923 = fluree.db.query.analytical.inner_join(inst_119886,inst_119902);
var inst_119885 = inst_119903;
var inst_119886__$1 = inst_119923;
var state_119942__$1 = (function (){var statearr_119963 = state_119942;
(statearr_119963[(11)] = inst_119885);

(statearr_119963[(9)] = inst_119886__$1);

return statearr_119963;
})();
var statearr_119964_120001 = state_119942__$1;
(statearr_119964_120001[(2)] = null);

(statearr_119964_120001[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (19))){
var inst_119903 = (state_119942[(10)]);
var inst_119915 = (state_119942[(2)]);
var inst_119885 = inst_119903;
var inst_119886 = inst_119915;
var state_119942__$1 = (function (){var statearr_119965 = state_119942;
(statearr_119965[(11)] = inst_119885);

(statearr_119965[(9)] = inst_119886);

return statearr_119965;
})();
var statearr_119966_120002 = state_119942__$1;
(statearr_119966_120002[(2)] = null);

(statearr_119966_120002[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (11))){
var inst_119902 = (state_119942[(14)]);
var inst_119903 = (state_119942[(10)]);
var inst_119885 = inst_119903;
var inst_119886 = inst_119902;
var state_119942__$1 = (function (){var statearr_119967 = state_119942;
(statearr_119967[(11)] = inst_119885);

(statearr_119967[(9)] = inst_119886);

return statearr_119967;
})();
var statearr_119968_120003 = state_119942__$1;
(statearr_119968_120003[(2)] = null);

(statearr_119968_120003[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (9))){
var inst_119936 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119969_120004 = state_119942__$1;
(statearr_119969_120004[(2)] = inst_119936);

(statearr_119969_120004[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (5))){
var inst_119885 = (state_119942[(11)]);
var inst_119892 = (state_119942[(8)]);
var inst_119891 = cljs.core.seq(inst_119885);
var inst_119892__$1 = cljs.core.first(inst_119891);
var inst_119893 = cljs.core.next(inst_119891);
var state_119942__$1 = (function (){var statearr_119970 = state_119942;
(statearr_119970[(7)] = inst_119893);

(statearr_119970[(8)] = inst_119892__$1);

return statearr_119970;
})();
if(cljs.core.truth_(inst_119892__$1)){
var statearr_119971_120005 = state_119942__$1;
(statearr_119971_120005[(1)] = (7));

} else {
var statearr_119972_120006 = state_119942__$1;
(statearr_119972_120006[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (14))){
var inst_119902 = (state_119942[(14)]);
var state_119942__$1 = state_119942;
if(cljs.core.truth_(inst_119902)){
var statearr_119973_120007 = state_119942__$1;
(statearr_119973_120007[(1)] = (17));

} else {
var statearr_119974_120008 = state_119942__$1;
(statearr_119974_120008[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (16))){
var inst_119931 = (state_119942[(2)]);
var state_119942__$1 = state_119942;
var statearr_119975_120009 = state_119942__$1;
(statearr_119975_120009[(2)] = inst_119931);

(statearr_119975_120009[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (10))){
var inst_119892 = (state_119942[(8)]);
var inst_119900 = (state_119942[(2)]);
var inst_119901 = fluree.db.util.async.throw_err(inst_119900);
var inst_119902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119901,(0),null);
var inst_119903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_119901,(1),null);
var inst_119904 = cljs.core.count(inst_119892);
var inst_119905 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_119904);
var state_119942__$1 = (function (){var statearr_119976 = state_119942;
(statearr_119976[(14)] = inst_119902);

(statearr_119976[(10)] = inst_119903);

return statearr_119976;
})();
if(inst_119905){
var statearr_119977_120010 = state_119942__$1;
(statearr_119977_120010[(1)] = (11));

} else {
var statearr_119978_120011 = state_119942__$1;
(statearr_119978_120011[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (18))){
var inst_119886 = (state_119942[(9)]);
var state_119942__$1 = state_119942;
var statearr_119979_120012 = state_119942__$1;
(statearr_119979_120012[(2)] = inst_119886);

(statearr_119979_120012[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_119943 === (8))){
var inst_119886 = (state_119942[(9)]);
var state_119942__$1 = state_119942;
var statearr_119980_120013 = state_119942__$1;
(statearr_119980_120013[(2)] = inst_119886);

(statearr_119980_120013[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$state_machine__109971__auto__ = null;
var fluree$db$query$analytical$state_machine__109971__auto____0 = (function (){
var statearr_119981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_119981[(0)] = fluree$db$query$analytical$state_machine__109971__auto__);

(statearr_119981[(1)] = (1));

return statearr_119981;
});
var fluree$db$query$analytical$state_machine__109971__auto____1 = (function (state_119942){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_119942);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e119982){if((e119982 instanceof Object)){
var ex__109974__auto__ = e119982;
var statearr_119983_120014 = state_119942;
(statearr_119983_120014[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_119942);

return cljs.core.cst$kw$recur;
} else {
throw e119982;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__120015 = state_119942;
state_119942 = G__120015;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__109971__auto__ = function(state_119942){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__109971__auto____1.call(this,state_119942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__109971__auto____0;
fluree$db$query$analytical$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__109971__auto____1;
return fluree$db$query$analytical$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_119984 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_119984[(6)] = c__110077__auto__);

return statearr_119984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7;

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_120072){
var state_val_120073 = (state_120072[(1)]);
if((state_val_120073 === (7))){
var inst_120036 = (state_120072[(2)]);
var state_120072__$1 = state_120072;
if(cljs.core.truth_(inst_120036)){
var statearr_120074_120106 = state_120072__$1;
(statearr_120074_120106[(1)] = (11));

} else {
var statearr_120075_120107 = state_120072__$1;
(statearr_120075_120107[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (20))){
var inst_120060 = (state_120072[(7)]);
var state_120072__$1 = state_120072;
var statearr_120076_120108 = state_120072__$1;
(statearr_120076_120108[(2)] = inst_120060);

(statearr_120076_120108[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (1))){
var state_120072__$1 = state_120072;
var statearr_120077_120109 = state_120072__$1;
(statearr_120077_120109[(2)] = null);

(statearr_120077_120109[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120072,(3),Error,null,(2));
var inst_120022 = (q_map == null);
var inst_120023 = cljs.core.not(inst_120022);
var state_120072__$1 = state_120072;
if(inst_120023){
var statearr_120078_120110 = state_120072__$1;
(statearr_120078_120110[(1)] = (5));

} else {
var statearr_120079_120111 = state_120072__$1;
(statearr_120079_120111[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (15))){
var inst_120049 = (state_120072[(8)]);
var inst_120044 = (state_120072[(9)]);
var inst_120051 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0));
var inst_120052 = ["The query key: optional should be included in the 'where' array. The top-level 'optional' is being deprecated. Provided: ",inst_120051].join('');
var inst_120053 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_120052], 0));
var inst_120054 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_120044,inst_120049,fuel,max_fuel,opts);
var state_120072__$1 = (function (){var statearr_120080 = state_120072;
(statearr_120080[(10)] = inst_120053);

return statearr_120080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120072__$1,(18),inst_120054);
} else {
if((state_val_120073 === (21))){
var inst_120068 = (state_120072[(2)]);
var state_120072__$1 = state_120072;
var statearr_120081_120112 = state_120072__$1;
(statearr_120081_120112[(2)] = inst_120068);


cljs.core.async.impl.ioc_helpers.process_exception(state_120072__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (13))){
var inst_120041 = (state_120072[(2)]);
var inst_120042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120041,cljs.core.cst$kw$vars);
var inst_120043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120041,cljs.core.cst$kw$where);
var inst_120044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120041,cljs.core.cst$kw$optional);
var inst_120045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120041,cljs.core.cst$kw$filter);
var inst_120046 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_120043,q_map,inst_120042,fuel,max_fuel,opts);
var state_120072__$1 = (function (){var statearr_120082 = state_120072;
(statearr_120082[(11)] = inst_120045);

(statearr_120082[(9)] = inst_120044);

return statearr_120082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120072__$1,(14),inst_120046);
} else {
if((state_val_120073 === (6))){
var state_120072__$1 = state_120072;
var statearr_120083_120113 = state_120072__$1;
(statearr_120083_120113[(2)] = false);

(statearr_120083_120113[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (17))){
var inst_120045 = (state_120072[(11)]);
var inst_120060 = (state_120072[(2)]);
var state_120072__$1 = (function (){var statearr_120084 = state_120072;
(statearr_120084[(7)] = inst_120060);

return statearr_120084;
})();
if(cljs.core.truth_(inst_120045)){
var statearr_120085_120114 = state_120072__$1;
(statearr_120085_120114[(1)] = (19));

} else {
var statearr_120086_120115 = state_120072__$1;
(statearr_120086_120115[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (3))){
var inst_120016 = (state_120072[(2)]);
var state_120072__$1 = state_120072;
var statearr_120087_120116 = state_120072__$1;
(statearr_120087_120116[(2)] = inst_120016);


cljs.core.async.impl.ioc_helpers.process_exception(state_120072__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (12))){
var state_120072__$1 = state_120072;
var statearr_120088_120117 = state_120072__$1;
(statearr_120088_120117[(2)] = q_map);

(statearr_120088_120117[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (2))){
var inst_120070 = (state_120072[(2)]);
var state_120072__$1 = state_120072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120072__$1,inst_120070);
} else {
if((state_val_120073 === (19))){
var inst_120060 = (state_120072[(7)]);
var inst_120045 = (state_120072[(11)]);
var inst_120062 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0));
var inst_120063 = ["The query key: filter should be included in the 'where' array. The top-level 'filter' is being deprecated. Provided: ",inst_120062].join('');
var inst_120064 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_120063], 0));
var inst_120065 = fluree.db.query.analytical.tuples__GT_filtered(inst_120060,inst_120045,null);
var state_120072__$1 = (function (){var statearr_120089 = state_120072;
(statearr_120089[(12)] = inst_120064);

return statearr_120089;
})();
var statearr_120090_120118 = state_120072__$1;
(statearr_120090_120118[(2)] = inst_120065);

(statearr_120090_120118[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (11))){
var inst_120038 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,q_map);
var state_120072__$1 = state_120072;
var statearr_120091_120119 = state_120072__$1;
(statearr_120091_120119[(2)] = inst_120038);

(statearr_120091_120119[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (9))){
var state_120072__$1 = state_120072;
var statearr_120092_120120 = state_120072__$1;
(statearr_120092_120120[(2)] = false);

(statearr_120092_120120[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (5))){
var inst_120025 = q_map.cljs$lang$protocol_mask$partition0$;
var inst_120026 = (inst_120025 & (64));
var inst_120027 = q_map.cljs$core$ISeq$;
var inst_120028 = (cljs.core.PROTOCOL_SENTINEL === inst_120027);
var inst_120029 = ((inst_120026) || (inst_120028));
var state_120072__$1 = state_120072;
if(cljs.core.truth_(inst_120029)){
var statearr_120093_120121 = state_120072__$1;
(statearr_120093_120121[(1)] = (8));

} else {
var statearr_120094_120122 = state_120072__$1;
(statearr_120094_120122[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (14))){
var inst_120044 = (state_120072[(9)]);
var inst_120048 = (state_120072[(2)]);
var inst_120049 = fluree.db.util.async.throw_err(inst_120048);
var state_120072__$1 = (function (){var statearr_120095 = state_120072;
(statearr_120095[(8)] = inst_120049);

return statearr_120095;
})();
if(cljs.core.truth_(inst_120044)){
var statearr_120096_120123 = state_120072__$1;
(statearr_120096_120123[(1)] = (15));

} else {
var statearr_120097_120124 = state_120072__$1;
(statearr_120097_120124[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (16))){
var inst_120049 = (state_120072[(8)]);
var state_120072__$1 = state_120072;
var statearr_120098_120125 = state_120072__$1;
(statearr_120098_120125[(2)] = inst_120049);

(statearr_120098_120125[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (10))){
var inst_120033 = (state_120072[(2)]);
var state_120072__$1 = state_120072;
var statearr_120099_120126 = state_120072__$1;
(statearr_120099_120126[(2)] = inst_120033);

(statearr_120099_120126[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (18))){
var inst_120056 = (state_120072[(2)]);
var inst_120057 = fluree.db.util.async.throw_err(inst_120056);
var state_120072__$1 = state_120072;
var statearr_120100_120127 = state_120072__$1;
(statearr_120100_120127[(2)] = inst_120057);

(statearr_120100_120127[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120073 === (8))){
var state_120072__$1 = state_120072;
var statearr_120101_120128 = state_120072__$1;
(statearr_120101_120128[(2)] = true);

(statearr_120101_120128[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical$q_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__109971__auto____0 = (function (){
var statearr_120102 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120102[(0)] = fluree$db$query$analytical$q_$_state_machine__109971__auto__);

(statearr_120102[(1)] = (1));

return statearr_120102;
});
var fluree$db$query$analytical$q_$_state_machine__109971__auto____1 = (function (state_120072){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_120072);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e120103){if((e120103 instanceof Object)){
var ex__109974__auto__ = e120103;
var statearr_120104_120129 = state_120072;
(statearr_120104_120129[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120072);

return cljs.core.cst$kw$recur;
} else {
throw e120103;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__120130 = state_120072;
state_120072 = G__120130;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__109971__auto__ = function(state_120072){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__109971__auto____1.call(this,state_120072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__109971__auto____0;
fluree$db$query$analytical$q_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__109971__auto____1;
return fluree$db$query$analytical$q_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_120105 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_120105[(6)] = c__110077__auto__);

return statearr_120105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
