// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k126207,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__126211 = k126207;
var G__126211__$1 = (((G__126211 instanceof cljs.core.Keyword))?G__126211.fqn:null);
switch (G__126211__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k126207,else__4388__auto__);

}
});

fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__126212){
var vec__126213 = p__126212;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126213,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126213,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__126206){
var self__ = this;
var G__126206__$1 = this;
return (new cljs.core.RecordIter((0),G__126206__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
});

fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__126216 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__126216(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this126208,other126209){
var self__ = this;
var this126208__$1 = this;
return (((!((other126209 == null)))) && ((this126208__$1.constructor === other126209.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.conn,other126209.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.network,other126209.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.dbid,other126209.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.db_name,other126209.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.update_chan,other126209.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.transact_chan,other126209.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.state,other126209.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.schema_cache,other126209.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.blank_db,other126209.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.close,other126209.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.id,other126209.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this126208__$1.__extmap,other126209.__extmap)));
});

fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__126206){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__126217 = cljs.core.keyword_identical_QMARK_;
var expr__126218 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__126220 = cljs.core.cst$kw$conn;
var G__126221 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126220,G__126221) : pred__126217.call(null,G__126220,G__126221));
})())){
return (new fluree.db.session.DbSession(G__126206,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126222 = cljs.core.cst$kw$network;
var G__126223 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126222,G__126223) : pred__126217.call(null,G__126222,G__126223));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__126206,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126224 = cljs.core.cst$kw$dbid;
var G__126225 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126224,G__126225) : pred__126217.call(null,G__126224,G__126225));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__126206,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126226 = cljs.core.cst$kw$db_DASH_name;
var G__126227 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126226,G__126227) : pred__126217.call(null,G__126226,G__126227));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__126206,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126228 = cljs.core.cst$kw$update_DASH_chan;
var G__126229 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126228,G__126229) : pred__126217.call(null,G__126228,G__126229));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__126206,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126230 = cljs.core.cst$kw$transact_DASH_chan;
var G__126231 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126230,G__126231) : pred__126217.call(null,G__126230,G__126231));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__126206,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126232 = cljs.core.cst$kw$state;
var G__126233 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126232,G__126233) : pred__126217.call(null,G__126232,G__126233));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__126206,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126234 = cljs.core.cst$kw$schema_DASH_cache;
var G__126235 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126234,G__126235) : pred__126217.call(null,G__126234,G__126235));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__126206,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126236 = cljs.core.cst$kw$blank_DASH_db;
var G__126237 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126236,G__126237) : pred__126217.call(null,G__126236,G__126237));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__126206,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126238 = cljs.core.cst$kw$close;
var G__126239 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126238,G__126239) : pred__126217.call(null,G__126238,G__126239));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__126206,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__126240 = cljs.core.cst$kw$id;
var G__126241 = expr__126218;
return (pred__126217.cljs$core$IFn$_invoke$arity$2 ? pred__126217.cljs$core$IFn$_invoke$arity$2(G__126240,G__126241) : pred__126217.call(null,G__126240,G__126241));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__126206,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__126206),null));
}
}
}
}
}
}
}
}
}
}
}
});

fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
});

fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__126206){
var self__ = this;
var this__4384__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__126206,self__.__extmap,self__.__hash));
});

fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
});

fluree.db.session.DbSession.cljs$lang$type = true;

fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
});

fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"fluree.db.session/DbSession");
});

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__126210){
var extmap__4424__auto__ = (function (){var G__126242 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__126210,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__126210)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__126242);
} else {
return G__126242;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__126210),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__126210),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__126244 = session;
var map__126244__$1 = (((((!((map__126244 == null))))?(((((map__126244.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126244.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126244):map__126244);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126244__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126244__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,((function (map__126244,map__126244__$1,network,dbid,cache_key){
return (function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
});})(map__126244,map__126244__$1,network,dbid,cache_key))
);

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___126451 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___126451,pc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___126451,pc){
return (function (state_126385){
var state_val_126386 = (state_126385[(1)]);
if((state_val_126386 === (7))){
var inst_126268 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
if(cljs.core.truth_(inst_126268)){
var statearr_126387_126452 = state_126385__$1;
(statearr_126387_126452[(1)] = (11));

} else {
var statearr_126388_126453 = state_126385__$1;
(statearr_126388_126453[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (20))){
var inst_126295 = (state_126385[(2)]);
var inst_126296 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_126297 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_126298 = cljs.core.PersistentHashMap.fromArrays(inst_126296,inst_126297);
var inst_126299 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_126295,inst_126298);
var inst_126300 = (function(){throw inst_126299})();
var state_126385__$1 = state_126385;
var statearr_126389_126454 = state_126385__$1;
(statearr_126389_126454[(2)] = inst_126300);

(statearr_126389_126454[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (27))){
var inst_126313 = (state_126385[(7)]);
var state_126385__$1 = state_126385;
var statearr_126390_126455 = state_126385__$1;
(statearr_126390_126455[(2)] = inst_126313);

(statearr_126390_126455[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (1))){
var state_126385__$1 = state_126385;
var statearr_126391_126456 = state_126385__$1;
(statearr_126391_126456[(2)] = null);

(statearr_126391_126456[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (24))){
var inst_126370 = (state_126385[(8)]);
var inst_126370__$1 = (state_126385[(2)]);
var inst_126371 = fluree.db.query.schema.schema_map(inst_126370__$1);
var state_126385__$1 = (function (){var statearr_126392 = state_126385;
(statearr_126392[(8)] = inst_126370__$1);

return statearr_126392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(44),inst_126371);
} else {
if((state_val_126386 === (39))){
var inst_126337 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
var statearr_126393_126457 = state_126385__$1;
(statearr_126393_126457[(2)] = inst_126337);

(statearr_126393_126457[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_126385,(3),java.lang.Exception,null,(2));
var inst_126252 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_126254 = (session == null);
var inst_126255 = cljs.core.not(inst_126254);
var state_126385__$1 = (function (){var statearr_126394 = state_126385;
(statearr_126394[(9)] = inst_126252);

return statearr_126394;
})();
if(inst_126255){
var statearr_126395_126458 = state_126385__$1;
(statearr_126395_126458[(1)] = (5));

} else {
var statearr_126396_126459 = state_126385__$1;
(statearr_126396_126459[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (15))){
var inst_126283 = (state_126385[(10)]);
var inst_126288 = cljs.core.empty_QMARK_(inst_126283);
var state_126385__$1 = state_126385;
if(inst_126288){
var statearr_126397_126460 = state_126385__$1;
(statearr_126397_126460[(1)] = (18));

} else {
var statearr_126398_126461 = state_126385__$1;
(statearr_126398_126461[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (21))){
var inst_126283 = (state_126385[(10)]);
var inst_126308 = (state_126385[(11)]);
var inst_126307 = (state_126385[(2)]);
var inst_126308__$1 = fluree.db.util.async.throw_err(inst_126307);
var inst_126309 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_126283);
var state_126385__$1 = (function (){var statearr_126399 = state_126385;
(statearr_126399[(12)] = inst_126309);

(statearr_126399[(11)] = inst_126308__$1);

return statearr_126399;
})();
if(cljs.core.truth_(inst_126308__$1)){
var statearr_126400_126462 = state_126385__$1;
(statearr_126400_126462[(1)] = (22));

} else {
var statearr_126401_126463 = state_126385__$1;
(statearr_126401_126463[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (31))){
var inst_126322 = (state_126385[(13)]);
var inst_126326 = (inst_126322 == null);
var inst_126327 = cljs.core.not(inst_126326);
var state_126385__$1 = state_126385;
if(inst_126327){
var statearr_126402_126464 = state_126385__$1;
(statearr_126402_126464[(1)] = (34));

} else {
var statearr_126403_126465 = state_126385__$1;
(statearr_126403_126465[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (32))){
var inst_126314 = (state_126385[(14)]);
var inst_126275 = (state_126385[(15)]);
var inst_126276 = (state_126385[(16)]);
var inst_126356 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126314)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126275),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126276),"."].join('');
var inst_126357 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_126358 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_126359 = cljs.core.PersistentHashMap.fromArrays(inst_126357,inst_126358);
var inst_126360 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_126356,inst_126359);
var inst_126361 = (function(){throw inst_126360})();
var state_126385__$1 = state_126385;
var statearr_126404_126466 = state_126385__$1;
(statearr_126404_126466[(2)] = inst_126361);

(statearr_126404_126466[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (40))){
var inst_126322 = (state_126385[(13)]);
var inst_126342 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_126322);
var state_126385__$1 = state_126385;
var statearr_126405_126467 = state_126385__$1;
(statearr_126405_126467[(2)] = inst_126342);

(statearr_126405_126467[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (33))){
var inst_126363 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
var statearr_126406_126468 = state_126385__$1;
(statearr_126406_126468[(2)] = inst_126363);

(statearr_126406_126468[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (13))){
var inst_126274 = (state_126385[(17)]);
var inst_126275 = (state_126385[(15)]);
var inst_126276 = (state_126385[(16)]);
var inst_126273 = (state_126385[(2)]);
var inst_126274__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126273,cljs.core.cst$kw$conn);
var inst_126275__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126273,cljs.core.cst$kw$network);
var inst_126276__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126273,cljs.core.cst$kw$dbid);
var inst_126277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_126278 = [inst_126275__$1,inst_126276__$1];
var inst_126279 = (new cljs.core.PersistentVector(null,2,(5),inst_126277,inst_126278,null));
var inst_126280 = fluree.db.operations.ledger_info_async(inst_126274__$1,inst_126279);
var state_126385__$1 = (function (){var statearr_126407 = state_126385;
(statearr_126407[(17)] = inst_126274__$1);

(statearr_126407[(15)] = inst_126275__$1);

(statearr_126407[(16)] = inst_126276__$1);

return statearr_126407;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(14),inst_126280);
} else {
if((state_val_126386 === (22))){
var inst_126308 = (state_126385[(11)]);
var inst_126311 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_126308);
var inst_126312 = (inst_126311 + (1));
var inst_126313 = inst_126308;
var inst_126314 = inst_126312;
var state_126385__$1 = (function (){var statearr_126408 = state_126385;
(statearr_126408[(7)] = inst_126313);

(statearr_126408[(14)] = inst_126314);

return statearr_126408;
})();
var statearr_126409_126469 = state_126385__$1;
(statearr_126409_126469[(2)] = null);

(statearr_126409_126469[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (36))){
var inst_126340 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
if(cljs.core.truth_(inst_126340)){
var statearr_126410_126470 = state_126385__$1;
(statearr_126410_126470[(1)] = (40));

} else {
var statearr_126411_126471 = state_126385__$1;
(statearr_126411_126471[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (41))){
var inst_126322 = (state_126385[(13)]);
var state_126385__$1 = state_126385;
var statearr_126412_126472 = state_126385__$1;
(statearr_126412_126472[(2)] = inst_126322);

(statearr_126412_126472[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (43))){
var inst_126314 = (state_126385[(14)]);
var inst_126351 = (state_126385[(2)]);
var inst_126352 = fluree.db.util.async.throw_err(inst_126351);
var inst_126353 = (inst_126314 + (1));
var inst_126313 = inst_126352;
var inst_126314__$1 = inst_126353;
var state_126385__$1 = (function (){var statearr_126413 = state_126385;
(statearr_126413[(7)] = inst_126313);

(statearr_126413[(14)] = inst_126314__$1);

return statearr_126413;
})();
var statearr_126414_126473 = state_126385__$1;
(statearr_126414_126473[(2)] = null);

(statearr_126414_126473[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (29))){
var inst_126365 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
var statearr_126415_126474 = state_126385__$1;
(statearr_126415_126474[(2)] = inst_126365);

(statearr_126415_126474[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (44))){
var inst_126375 = (state_126385[(18)]);
var inst_126370 = (state_126385[(8)]);
var inst_126373 = (state_126385[(2)]);
var inst_126374 = fluree.db.util.async.throw_err(inst_126373);
var inst_126375__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_126370,cljs.core.cst$kw$schema,inst_126374);
var inst_126376 = fluree.db.query.schema.setting_map(inst_126375__$1);
var state_126385__$1 = (function (){var statearr_126416 = state_126385;
(statearr_126416[(18)] = inst_126375__$1);

return statearr_126416;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(45),inst_126376);
} else {
if((state_val_126386 === (6))){
var state_126385__$1 = state_126385;
var statearr_126417_126475 = state_126385__$1;
(statearr_126417_126475[(2)] = false);

(statearr_126417_126475[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (28))){
var inst_126274 = (state_126385[(17)]);
var inst_126314 = (state_126385[(14)]);
var inst_126275 = (state_126385[(15)]);
var inst_126276 = (state_126385[(16)]);
var inst_126319 = fluree.db.storage.core.read_block(inst_126274,inst_126275,inst_126276,inst_126314);
var state_126385__$1 = state_126385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(30),inst_126319);
} else {
if((state_val_126386 === (25))){
var inst_126309 = (state_126385[(12)]);
var inst_126314 = (state_126385[(14)]);
var inst_126316 = (inst_126314 > inst_126309);
var state_126385__$1 = state_126385;
if(cljs.core.truth_(inst_126316)){
var statearr_126418_126476 = state_126385__$1;
(statearr_126418_126476[(1)] = (27));

} else {
var statearr_126419_126477 = state_126385__$1;
(statearr_126419_126477[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (34))){
var inst_126322 = (state_126385[(13)]);
var inst_126329 = inst_126322.cljs$lang$protocol_mask$partition0$;
var inst_126330 = (inst_126329 & (64));
var inst_126331 = inst_126322.cljs$core$ISeq$;
var inst_126332 = (cljs.core.PROTOCOL_SENTINEL === inst_126331);
var inst_126333 = ((inst_126330) || (inst_126332));
var state_126385__$1 = state_126385;
if(cljs.core.truth_(inst_126333)){
var statearr_126420_126478 = state_126385__$1;
(statearr_126420_126478[(1)] = (37));

} else {
var statearr_126421_126479 = state_126385__$1;
(statearr_126421_126479[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (17))){
var inst_126274 = (state_126385[(17)]);
var inst_126252 = (state_126385[(9)]);
var inst_126275 = (state_126385[(15)]);
var inst_126283 = (state_126385[(10)]);
var inst_126276 = (state_126385[(16)]);
var inst_126303 = (state_126385[(2)]);
var inst_126304 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_126283);
var inst_126305 = fluree.db.storage.core.reify_db(inst_126274,inst_126275,inst_126276,inst_126252,inst_126304);
var state_126385__$1 = (function (){var statearr_126422 = state_126385;
(statearr_126422[(19)] = inst_126303);

return statearr_126422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(21),inst_126305);
} else {
if((state_val_126386 === (3))){
var inst_126246 = (state_126385[(2)]);
var inst_126247 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_126246);
var state_126385__$1 = state_126385;
var statearr_126423_126480 = state_126385__$1;
(statearr_126423_126480[(2)] = inst_126247);


cljs.core.async.impl.ioc_helpers.process_exception(state_126385__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (12))){
var state_126385__$1 = state_126385;
var statearr_126424_126481 = state_126385__$1;
(statearr_126424_126481[(2)] = session);

(statearr_126424_126481[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (2))){
var inst_126383 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_126385__$1,inst_126383);
} else {
if((state_val_126386 === (23))){
var state_126385__$1 = state_126385;
var statearr_126425_126482 = state_126385__$1;
(statearr_126425_126482[(2)] = null);

(statearr_126425_126482[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (35))){
var state_126385__$1 = state_126385;
var statearr_126426_126483 = state_126385__$1;
(statearr_126426_126483[(2)] = false);

(statearr_126426_126483[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (19))){
var inst_126275 = (state_126385[(15)]);
var inst_126283 = (state_126385[(10)]);
var inst_126276 = (state_126385[(16)]);
var inst_126292 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_126283);
var inst_126293 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126275),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126276)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126292),"."].join('');
var state_126385__$1 = state_126385;
var statearr_126427_126484 = state_126385__$1;
(statearr_126427_126484[(2)] = inst_126293);

(statearr_126427_126484[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (11))){
var inst_126270 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_126385__$1 = state_126385;
var statearr_126428_126485 = state_126385__$1;
(statearr_126428_126485[(2)] = inst_126270);

(statearr_126428_126485[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (9))){
var state_126385__$1 = state_126385;
var statearr_126429_126486 = state_126385__$1;
(statearr_126429_126486[(2)] = false);

(statearr_126429_126486[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (5))){
var inst_126257 = session.cljs$lang$protocol_mask$partition0$;
var inst_126258 = (inst_126257 & (64));
var inst_126259 = session.cljs$core$ISeq$;
var inst_126260 = (cljs.core.PROTOCOL_SENTINEL === inst_126259);
var inst_126261 = ((inst_126258) || (inst_126260));
var state_126385__$1 = state_126385;
if(cljs.core.truth_(inst_126261)){
var statearr_126430_126487 = state_126385__$1;
(statearr_126430_126487[(1)] = (8));

} else {
var statearr_126431_126488 = state_126385__$1;
(statearr_126431_126488[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (14))){
var inst_126283 = (state_126385[(10)]);
var inst_126282 = (state_126385[(2)]);
var inst_126283__$1 = fluree.db.util.async.throw_err(inst_126282);
var inst_126284 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_126283__$1);
var inst_126285 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_126284);
var inst_126286 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_126285);
var state_126385__$1 = (function (){var statearr_126432 = state_126385;
(statearr_126432[(10)] = inst_126283__$1);

return statearr_126432;
})();
if(inst_126286){
var statearr_126433_126489 = state_126385__$1;
(statearr_126433_126489[(1)] = (15));

} else {
var statearr_126434_126490 = state_126385__$1;
(statearr_126434_126490[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (45))){
var inst_126375 = (state_126385[(18)]);
var inst_126378 = (state_126385[(2)]);
var inst_126379 = fluree.db.util.async.throw_err(inst_126378);
var inst_126380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_126375,cljs.core.cst$kw$settings,inst_126379);
var inst_126381 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_126380);
var state_126385__$1 = state_126385;
var statearr_126435_126491 = state_126385__$1;
(statearr_126435_126491[(2)] = inst_126381);


cljs.core.async.impl.ioc_helpers.process_exception(state_126385__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (26))){
var inst_126367 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
var statearr_126436_126492 = state_126385__$1;
(statearr_126436_126492[(2)] = inst_126367);

(statearr_126436_126492[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (16))){
var state_126385__$1 = state_126385;
var statearr_126437_126493 = state_126385__$1;
(statearr_126437_126493[(2)] = null);

(statearr_126437_126493[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (38))){
var state_126385__$1 = state_126385;
var statearr_126438_126494 = state_126385__$1;
(statearr_126438_126494[(2)] = false);

(statearr_126438_126494[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (30))){
var inst_126322 = (state_126385[(13)]);
var inst_126321 = (state_126385[(2)]);
var inst_126322__$1 = fluree.db.util.async.throw_err(inst_126321);
var state_126385__$1 = (function (){var statearr_126439 = state_126385;
(statearr_126439[(13)] = inst_126322__$1);

return statearr_126439;
})();
if(cljs.core.truth_(inst_126322__$1)){
var statearr_126440_126495 = state_126385__$1;
(statearr_126440_126495[(1)] = (31));

} else {
var statearr_126441_126496 = state_126385__$1;
(statearr_126441_126496[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (10))){
var inst_126265 = (state_126385[(2)]);
var state_126385__$1 = state_126385;
var statearr_126442_126497 = state_126385__$1;
(statearr_126442_126497[(2)] = inst_126265);

(statearr_126442_126497[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (18))){
var inst_126275 = (state_126385[(15)]);
var inst_126276 = (state_126385[(16)]);
var inst_126290 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126275),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126276)," is not found on this ledger group."].join('');
var state_126385__$1 = state_126385;
var statearr_126443_126498 = state_126385__$1;
(statearr_126443_126498[(2)] = inst_126290);

(statearr_126443_126498[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (42))){
var inst_126313 = (state_126385[(7)]);
var inst_126345 = (state_126385[(2)]);
var inst_126346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126345,cljs.core.cst$kw$flakes);
var inst_126347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126345,cljs.core.cst$kw$block);
var inst_126348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_126345,cljs.core.cst$kw$t);
var inst_126349 = fluree.db.dbproto._with(inst_126313,inst_126347,inst_126346);
var state_126385__$1 = (function (){var statearr_126444 = state_126385;
(statearr_126444[(20)] = inst_126348);

return statearr_126444;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126385__$1,(43),inst_126349);
} else {
if((state_val_126386 === (37))){
var state_126385__$1 = state_126385;
var statearr_126445_126499 = state_126385__$1;
(statearr_126445_126499[(2)] = true);

(statearr_126445_126499[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126386 === (8))){
var state_126385__$1 = state_126385;
var statearr_126446_126500 = state_126385__$1;
(statearr_126446_126500[(2)] = true);

(statearr_126446_126500[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___126451,pc))
;
return ((function (switch__109970__auto__,c__110077__auto___126451,pc){
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____0 = (function (){
var statearr_126447 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_126447[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__);

(statearr_126447[(1)] = (1));

return statearr_126447;
});
var fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____1 = (function (state_126385){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_126385);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e126448){if((e126448 instanceof Object)){
var ex__109974__auto__ = e126448;
var statearr_126449_126501 = state_126385;
(statearr_126449_126501[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_126385);

return cljs.core.cst$kw$recur;
} else {
throw e126448;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126502 = state_126385;
state_126385 = G__126502;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__ = function(state_126385){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____1.call(this,state_126385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__109971__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___126451,pc))
})();
var state__110079__auto__ = (function (){var statearr_126450 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_126450[(6)] = c__110077__auto___126451);

return statearr_126450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___126451,pc))
);


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__126503 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__126503,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__126503;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4120__auto__ = network;
if(cljs.core.truth_(and__4120__auto__)){
return maybe_alias;
} else {
return and__4120__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4613__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__126504 = cljs.core.get_global_hierarchy;
return (fexpr__126504.cljs$core$IFn$_invoke$arity$0 ? fexpr__126504.cljs$core$IFn$_invoke$arity$0() : fexpr__126504.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (_,event_type,___$1){
return event_type;
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,cljs.core.cst$kw$default,hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__126506){
var map__126507 = p__126506;
var map__126507__$1 = (((((!((map__126507 == null))))?(((((map__126507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126507):map__126507);
var data = map__126507__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126507__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126507__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126507__$1,cljs.core.cst$kw$flakes);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes){
return (function (state_126553){
var state_val_126554 = (state_126553[(1)]);
if((state_val_126554 === (7))){
var inst_126517 = (state_126553[(7)]);
var inst_126525 = ((1) + inst_126517);
var inst_126526 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_126525);
var state_126553__$1 = state_126553;
if(inst_126526){
var statearr_126555_126578 = state_126553__$1;
(statearr_126555_126578[(1)] = (9));

} else {
var statearr_126556_126579 = state_126553__$1;
(statearr_126556_126579[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (1))){
var state_126553__$1 = state_126553;
var statearr_126557_126580 = state_126553__$1;
(statearr_126557_126580[(2)] = null);

(statearr_126557_126580[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (4))){
var inst_126513 = (state_126553[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_126553,(3),Error,null,(2));
var inst_126513__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_126553__$1 = (function (){var statearr_126558 = state_126553;
(statearr_126558[(8)] = inst_126513__$1);

return statearr_126558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126553__$1,(5),inst_126513__$1);
} else {
if((state_val_126554 === (13))){
var state_126553__$1 = state_126553;
var statearr_126559_126581 = state_126553__$1;
(statearr_126559_126581[(2)] = null);

(statearr_126559_126581[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (6))){
var inst_126520 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_126521 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_126522 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126520),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126521),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_126523 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126522], 0));
var state_126553__$1 = state_126553;
var statearr_126560_126582 = state_126553__$1;
(statearr_126560_126582[(2)] = inst_126523);

(statearr_126560_126582[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (3))){
var inst_126509 = (state_126553[(2)]);
var state_126553__$1 = state_126553;
var statearr_126561_126583 = state_126553__$1;
(statearr_126561_126583[(2)] = inst_126509);


cljs.core.async.impl.ioc_helpers.process_exception(state_126553__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (12))){
var inst_126517 = (state_126553[(7)]);
var inst_126538 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_126539 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_126540 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126538),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126539),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126517),". Forcing a db reload."].join('');
var inst_126541 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126540], 0));
var inst_126542 = fluree.db.session.reload_db_BANG_(session);
var state_126553__$1 = (function (){var statearr_126562 = state_126553;
(statearr_126562[(9)] = inst_126541);

return statearr_126562;
})();
var statearr_126563_126584 = state_126553__$1;
(statearr_126563_126584[(2)] = inst_126542);

(statearr_126563_126584[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (2))){
var inst_126551 = (state_126553[(2)]);
var state_126553__$1 = state_126553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_126553__$1,inst_126551);
} else {
if((state_val_126554 === (11))){
var inst_126547 = (state_126553[(2)]);
var state_126553__$1 = state_126553;
var statearr_126564_126585 = state_126553__$1;
(statearr_126564_126585[(2)] = inst_126547);

(statearr_126564_126585[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (9))){
var inst_126517 = (state_126553[(7)]);
var inst_126513 = (state_126553[(8)]);
var inst_126516 = (state_126553[(10)]);
var inst_126528 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_126529 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_126530 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126528),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126529),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_126531 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126530], 0));
var inst_126532 = (function (){var current_db_ch = inst_126513;
var current_db = inst_126516;
var current_block = inst_126517;
return ((function (current_db_ch,current_db,current_block,inst_126517,inst_126513,inst_126516,inst_126528,inst_126529,inst_126530,inst_126531,state_val_126554,c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes){
return (function (p1__126505_SHARP_){
if((p1__126505_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__126505_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__126505_SHARP_);
}
});
;})(current_db_ch,current_db,current_block,inst_126517,inst_126513,inst_126516,inst_126528,inst_126529,inst_126530,inst_126531,state_val_126554,c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes))
})();
var inst_126533 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_126532,flakes);
var inst_126534 = fluree.db.dbproto._with(inst_126516,block,inst_126533);
var inst_126535 = fluree.db.session.cas_db_BANG_(session,inst_126513,inst_126534);
var state_126553__$1 = (function (){var statearr_126565 = state_126553;
(statearr_126565[(11)] = inst_126531);

return statearr_126565;
})();
var statearr_126566_126586 = state_126553__$1;
(statearr_126566_126586[(2)] = inst_126535);

(statearr_126566_126586[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (5))){
var inst_126517 = (state_126553[(7)]);
var inst_126516 = (state_126553[(10)]);
var inst_126515 = (state_126553[(2)]);
var inst_126516__$1 = fluree.db.util.async.throw_err(inst_126515);
var inst_126517__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_126516__$1);
var inst_126518 = (block <= inst_126517__$1);
var state_126553__$1 = (function (){var statearr_126567 = state_126553;
(statearr_126567[(7)] = inst_126517__$1);

(statearr_126567[(10)] = inst_126516__$1);

return statearr_126567;
})();
if(cljs.core.truth_(inst_126518)){
var statearr_126568_126587 = state_126553__$1;
(statearr_126568_126587[(1)] = (6));

} else {
var statearr_126569_126588 = state_126553__$1;
(statearr_126569_126588[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (14))){
var inst_126545 = (state_126553[(2)]);
var state_126553__$1 = state_126553;
var statearr_126570_126589 = state_126553__$1;
(statearr_126570_126589[(2)] = inst_126545);

(statearr_126570_126589[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (10))){
var state_126553__$1 = state_126553;
var statearr_126571_126590 = state_126553__$1;
(statearr_126571_126590[(1)] = (12));



return cljs.core.cst$kw$recur;
} else {
if((state_val_126554 === (8))){
var inst_126549 = (state_126553[(2)]);
var state_126553__$1 = state_126553;
var statearr_126573_126591 = state_126553__$1;
(statearr_126573_126591[(2)] = inst_126549);


cljs.core.async.impl.ioc_helpers.process_exception(state_126553__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes){
return (function() {
var fluree$db$session$state_machine__109971__auto__ = null;
var fluree$db$session$state_machine__109971__auto____0 = (function (){
var statearr_126574 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_126574[(0)] = fluree$db$session$state_machine__109971__auto__);

(statearr_126574[(1)] = (1));

return statearr_126574;
});
var fluree$db$session$state_machine__109971__auto____1 = (function (state_126553){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_126553);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e126575){if((e126575 instanceof Object)){
var ex__109974__auto__ = e126575;
var statearr_126576_126592 = state_126553;
(statearr_126576_126592[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_126553);

return cljs.core.cst$kw$recur;
} else {
throw e126575;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126593 = state_126553;
state_126553 = G__126593;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$session$state_machine__109971__auto__ = function(state_126553){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__109971__auto____1.call(this,state_126553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__109971__auto____0;
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__109971__auto____1;
return fluree$db$session$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes))
})();
var state__110079__auto__ = (function (){var statearr_126577 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_126577[(6)] = c__110077__auto__);

return statearr_126577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__126507,map__126507__$1,data,block,t,flakes))
);

return c__110077__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_126600){
var state_val_126601 = (state_126600[(1)]);
if((state_val_126601 === (1))){
var inst_126594 = fluree.db.session.clear_db_BANG_(session);
var inst_126595 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_126596 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_126597 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126595),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_126596)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_126598 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126597], 0));
var state_126600__$1 = (function (){var statearr_126602 = state_126600;
(statearr_126602[(7)] = inst_126594);

(statearr_126602[(8)] = inst_126598);

return statearr_126602;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_126600__$1,true);
} else {
return null;
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$session$state_machine__109971__auto__ = null;
var fluree$db$session$state_machine__109971__auto____0 = (function (){
var statearr_126603 = [null,null,null,null,null,null,null,null,null];
(statearr_126603[(0)] = fluree$db$session$state_machine__109971__auto__);

(statearr_126603[(1)] = (1));

return statearr_126603;
});
var fluree$db$session$state_machine__109971__auto____1 = (function (state_126600){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_126600);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e126604){if((e126604 instanceof Object)){
var ex__109974__auto__ = e126604;
var statearr_126605_126607 = state_126600;
(statearr_126605_126607[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_126600);

return cljs.core.cst$kw$recur;
} else {
throw e126604;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126608 = state_126600;
state_126600 = G__126608;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$session$state_machine__109971__auto__ = function(state_126600){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__109971__auto____1.call(this,state_126600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__109971__auto____0;
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__109971__auto____1;
return fluree$db$session$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_126606 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_126606[(6)] = c__110077__auto__);

return statearr_126606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__126610 = arguments.length;
switch (G__126610) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__126611 = session;
var map__126611__$1 = (((((!((map__126611 == null))))?(((((map__126611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126611.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126611):map__126611);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126611__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__126613_126616 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__126613_126616.cljs$core$IFn$_invoke$arity$3 ? fexpr__126613_126616.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__126613_126616.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__126614_126617 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__126614_126617.cljs$core$IFn$_invoke$arity$0 ? fexpr__126614_126617.cljs$core$IFn$_invoke$arity$0() : fexpr__126614_126617.call(null));
} else {
}

return true;
}
}
});

fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
});

fluree.db.session.close.cljs$lang$maxFixedArity = 2;

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_126667){
var state_val_126668 = (state_126667[(1)]);
if((state_val_126668 === (7))){
var inst_126663 = (state_126667[(2)]);
var state_126667__$1 = state_126667;
var statearr_126669_126693 = state_126667__$1;
(statearr_126669_126693[(2)] = inst_126663);

(statearr_126669_126693[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (1))){
var state_126667__$1 = state_126667;
var statearr_126670_126694 = state_126667__$1;
(statearr_126670_126694[(2)] = null);

(statearr_126670_126694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (4))){
var inst_126621 = (state_126667[(7)]);
var inst_126620 = (state_126667[(2)]);
var inst_126621__$1 = fluree.db.util.async.throw_err(inst_126620);
var inst_126622 = fluree.db.session.from_cache(network,ledger_id);
var inst_126623 = (inst_126621__$1 == null);
var state_126667__$1 = (function (){var statearr_126671 = state_126667;
(statearr_126671[(8)] = inst_126622);

(statearr_126671[(7)] = inst_126621__$1);

return statearr_126671;
})();
if(cljs.core.truth_(inst_126623)){
var statearr_126672_126695 = state_126667__$1;
(statearr_126672_126695[(1)] = (5));

} else {
var statearr_126673_126696 = state_126667__$1;
(statearr_126673_126696[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (15))){
var inst_126621 = (state_126667[(7)]);
var inst_126636 = (state_126667[(2)]);
var inst_126637 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126636,"Exception processing ledger updates for message: ",inst_126621], 0));
var state_126667__$1 = state_126667;
var statearr_126674_126697 = state_126667__$1;
(statearr_126674_126697[(2)] = inst_126637);


cljs.core.async.impl.ioc_helpers.process_exception(state_126667__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (13))){
var inst_126659 = (state_126667[(2)]);
var state_126667__$1 = state_126667;
var statearr_126675_126698 = state_126667__$1;
(statearr_126675_126698[(2)] = inst_126659);

(statearr_126675_126698[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (6))){
var inst_126622 = (state_126667[(8)]);
var inst_126628 = (inst_126622 == null);
var state_126667__$1 = state_126667;
if(cljs.core.truth_(inst_126628)){
var statearr_126676_126699 = state_126667__$1;
(statearr_126676_126699[(1)] = (8));

} else {
var statearr_126677_126700 = state_126667__$1;
(statearr_126677_126700[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (17))){
var inst_126652 = (state_126667[(2)]);
var inst_126653 = fluree.db.util.async.throw_err(inst_126652);
var state_126667__$1 = state_126667;
var statearr_126678_126701 = state_126667__$1;
(statearr_126678_126701[(2)] = inst_126653);


cljs.core.async.impl.ioc_helpers.process_exception(state_126667__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (3))){
var inst_126665 = (state_126667[(2)]);
var state_126667__$1 = state_126667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_126667__$1,inst_126665);
} else {
if((state_val_126668 === (12))){
var state_126667__$1 = state_126667;
var statearr_126679_126702 = state_126667__$1;
(statearr_126679_126702[(2)] = null);

(statearr_126679_126702[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (2))){
var state_126667__$1 = state_126667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126667__$1,(4),update_chan);
} else {
if((state_val_126668 === (11))){
var state_126667__$1 = state_126667;
var statearr_126680_126703 = state_126667__$1;
(statearr_126680_126703[(2)] = null);

(statearr_126680_126703[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (9))){
var state_126667__$1 = state_126667;
var statearr_126681_126704 = state_126667__$1;
(statearr_126681_126704[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (5))){
var inst_126625 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_126626 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126625], 0));
var state_126667__$1 = state_126667;
var statearr_126683_126705 = state_126667__$1;
(statearr_126683_126705[(2)] = inst_126626);

(statearr_126683_126705[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (14))){
var inst_126655 = (state_126667[(2)]);
var state_126667__$1 = (function (){var statearr_126684 = state_126667;
(statearr_126684[(9)] = inst_126655);

return statearr_126684;
})();
var statearr_126685_126706 = state_126667__$1;
(statearr_126685_126706[(2)] = null);

(statearr_126685_126706[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (16))){
var inst_126622 = (state_126667[(8)]);
var inst_126621 = (state_126667[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_126667,(15),java.lang.Exception,null,(14));
var inst_126644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_126621,(0),null);
var inst_126645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_126621,(1),null);
var inst_126646 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_126647 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126621], 0));
var inst_126648 = fluree.db.util.core.trunc(inst_126647,(200));
var inst_126649 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126646,inst_126648], 0));
var inst_126650 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_126622,inst_126644,inst_126645) : fluree.db.session.process_ledger_update.call(null,inst_126622,inst_126644,inst_126645));
var state_126667__$1 = (function (){var statearr_126686 = state_126667;
(statearr_126686[(10)] = inst_126649);

return statearr_126686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126667__$1,(17),inst_126650);
} else {
if((state_val_126668 === (10))){
var inst_126661 = (state_126667[(2)]);
var state_126667__$1 = state_126667;
var statearr_126687_126707 = state_126667__$1;
(statearr_126687_126707[(2)] = inst_126661);

(statearr_126687_126707[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126668 === (8))){
var inst_126621 = (state_126667[(7)]);
var inst_126630 = cljs.core.first(inst_126621);
var inst_126631 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126630], 0));
var inst_126632 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_126631].join('');
var inst_126633 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126632], 0));
var state_126667__$1 = state_126667;
var statearr_126688_126708 = state_126667__$1;
(statearr_126688_126708[(2)] = inst_126633);

(statearr_126688_126708[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____0 = (function (){
var statearr_126689 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_126689[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__);

(statearr_126689[(1)] = (1));

return statearr_126689;
});
var fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____1 = (function (state_126667){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_126667);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e126690){if((e126690 instanceof Object)){
var ex__109974__auto__ = e126690;
var statearr_126691_126709 = state_126667;
(statearr_126691_126709[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_126667);

return cljs.core.cst$kw$recur;
} else {
throw e126690;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126710 = state_126667;
state_126667 = G__126710;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__ = function(state_126667){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____1.call(this,state_126667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__109971__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_126692 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_126692[(6)] = c__110077__auto__);

return statearr_126692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__126711){
var map__126712 = p__126711;
var map__126712__$1 = (((((!((map__126712 == null))))?(((((map__126712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126712):map__126712);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126712__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = ((function (schema_cache,update_chan,transact_chan,state__$1,session,map__126712,map__126712__$1,network,conn,dbid,db,transactor_QMARK_,db_name,state,close,id){
return (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});})(schema_cache,update_chan,transact_chan,state__$1,session,map__126712,map__126712__$1,network,conn,dbid,db,transactor_QMARK_,db_name,state,close,id))
;
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__126717 = block_result;
var map__126717__$1 = (((((!((map__126717 == null))))?(((((map__126717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126717.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126717):map__126717);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126717__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126717__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126717__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126717__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126717__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__126718 = tx_result;
var map__126718__$1 = (((((!((map__126718 == null))))?(((((map__126718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126718.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126718):map__126718);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126718__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126718__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?((function (map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status){
return (function (p1__126714_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__126714_SHARP_.t);
});})(map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status))
:((function (map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status){
return (function (p1__126715_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__126715_SHARP_,(3)));
});})(map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status))
);
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some(((function (map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status,t_filter,response){
return (function (p1__126716_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__126716_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__126716_SHARP_,(2));
} else {
return null;
}
});})(map__126717,map__126717__$1,block,hash,instant,txns,flakes,tx_result,_,map__126718,map__126718__$1,t,status,t_filter,response))
,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__126721 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126721,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126721,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126721,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126721,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4131__auto__ = message;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = fluree.db.util.core.random_uuid();
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__126725 = arguments.length;
switch (G__126725) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__126726){
var map__126727 = p__126726;
var map__126727__$1 = (((((!((map__126727 == null))))?(((((map__126727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__126727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__126727):map__126727);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126727__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126727__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126727__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__126727__$1,cljs.core.cst$kw$jwt);
var vec__126729 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126729,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126729,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126729,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4131__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4131__auto____$1 = state;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__126733_126852 = network;
var G__126734_126853 = ledger_id;
var G__126735_126854 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__126736_126855 = ((function (G__126733_126852,G__126734_126853,G__126735_126854,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt){
return (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5735__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__126737 = cljs.core.seq(tids);
var chunk__126738 = null;
var count__126739 = (0);
var i__126740 = (0);
while(true){
if((i__126740 < count__126739)){
var tid = chunk__126738.cljs$core$IIndexed$_nth$arity$2(null,i__126740);
var temp__5735__auto___126857__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___126857__$1)){
var keyed_callbacks_126858 = temp__5735__auto___126857__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_126859 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__126781_126860 = cljs.core.seq(keyed_callbacks_126858);
var chunk__126782_126861 = null;
var count__126783_126862 = (0);
var i__126784_126863 = (0);
while(true){
if((i__126784_126863 < count__126783_126862)){
var vec__126793_126864 = chunk__126782_126861.cljs$core$IIndexed$_nth$arity$2(null,i__126784_126863);
var k_126865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126793_126864,(0),null);
var f_126866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126793_126864,(1),null);
try{(f_126866.cljs$core$IFn$_invoke$arity$1 ? f_126866.cljs$core$IFn$_invoke$arity$1(tx_response_126859) : f_126866.call(null,tx_response_126859));
}catch (e126796){if((e126796 instanceof java.lang.Exception)){
var e_126867 = e126796;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_126867,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e126796;

}
}

var G__126868 = seq__126781_126860;
var G__126869 = chunk__126782_126861;
var G__126870 = count__126783_126862;
var G__126871 = (i__126784_126863 + (1));
seq__126781_126860 = G__126868;
chunk__126782_126861 = G__126869;
count__126783_126862 = G__126870;
i__126784_126863 = G__126871;
continue;
} else {
var temp__5735__auto___126872__$2 = cljs.core.seq(seq__126781_126860);
if(temp__5735__auto___126872__$2){
var seq__126781_126873__$1 = temp__5735__auto___126872__$2;
if(cljs.core.chunked_seq_QMARK_(seq__126781_126873__$1)){
var c__4550__auto___126874 = cljs.core.chunk_first(seq__126781_126873__$1);
var G__126875 = cljs.core.chunk_rest(seq__126781_126873__$1);
var G__126876 = c__4550__auto___126874;
var G__126877 = cljs.core.count(c__4550__auto___126874);
var G__126878 = (0);
seq__126781_126860 = G__126875;
chunk__126782_126861 = G__126876;
count__126783_126862 = G__126877;
i__126784_126863 = G__126878;
continue;
} else {
var vec__126797_126879 = cljs.core.first(seq__126781_126873__$1);
var k_126880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126797_126879,(0),null);
var f_126881 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126797_126879,(1),null);
try{(f_126881.cljs$core$IFn$_invoke$arity$1 ? f_126881.cljs$core$IFn$_invoke$arity$1(tx_response_126859) : f_126881.call(null,tx_response_126859));
}catch (e126800){if((e126800 instanceof java.lang.Exception)){
var e_126882 = e126800;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_126882,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e126800;

}
}

var G__126883 = cljs.core.next(seq__126781_126873__$1);
var G__126884 = null;
var G__126885 = (0);
var G__126886 = (0);
seq__126781_126860 = G__126883;
chunk__126782_126861 = G__126884;
count__126783_126862 = G__126885;
i__126784_126863 = G__126886;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__126887 = seq__126737;
var G__126888 = chunk__126738;
var G__126889 = count__126739;
var G__126890 = (i__126740 + (1));
seq__126737 = G__126887;
chunk__126738 = G__126888;
count__126739 = G__126889;
i__126740 = G__126890;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__126737);
if(temp__5735__auto____$1){
var seq__126737__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__126737__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__126737__$1);
var G__126891 = cljs.core.chunk_rest(seq__126737__$1);
var G__126892 = c__4550__auto__;
var G__126893 = cljs.core.count(c__4550__auto__);
var G__126894 = (0);
seq__126737 = G__126891;
chunk__126738 = G__126892;
count__126739 = G__126893;
i__126740 = G__126894;
continue;
} else {
var tid = cljs.core.first(seq__126737__$1);
var temp__5735__auto___126895__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5735__auto___126895__$2)){
var keyed_callbacks_126896 = temp__5735__auto___126895__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_126897 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__126801_126898 = cljs.core.seq(keyed_callbacks_126896);
var chunk__126802_126899 = null;
var count__126803_126900 = (0);
var i__126804_126901 = (0);
while(true){
if((i__126804_126901 < count__126803_126900)){
var vec__126813_126902 = chunk__126802_126899.cljs$core$IIndexed$_nth$arity$2(null,i__126804_126901);
var k_126903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126813_126902,(0),null);
var f_126904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126813_126902,(1),null);
try{(f_126904.cljs$core$IFn$_invoke$arity$1 ? f_126904.cljs$core$IFn$_invoke$arity$1(tx_response_126897) : f_126904.call(null,tx_response_126897));
}catch (e126816){if((e126816 instanceof java.lang.Exception)){
var e_126905 = e126816;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_126905,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e126816;

}
}

var G__126906 = seq__126801_126898;
var G__126907 = chunk__126802_126899;
var G__126908 = count__126803_126900;
var G__126909 = (i__126804_126901 + (1));
seq__126801_126898 = G__126906;
chunk__126802_126899 = G__126907;
count__126803_126900 = G__126908;
i__126804_126901 = G__126909;
continue;
} else {
var temp__5735__auto___126910__$3 = cljs.core.seq(seq__126801_126898);
if(temp__5735__auto___126910__$3){
var seq__126801_126911__$1 = temp__5735__auto___126910__$3;
if(cljs.core.chunked_seq_QMARK_(seq__126801_126911__$1)){
var c__4550__auto___126912 = cljs.core.chunk_first(seq__126801_126911__$1);
var G__126913 = cljs.core.chunk_rest(seq__126801_126911__$1);
var G__126914 = c__4550__auto___126912;
var G__126915 = cljs.core.count(c__4550__auto___126912);
var G__126916 = (0);
seq__126801_126898 = G__126913;
chunk__126802_126899 = G__126914;
count__126803_126900 = G__126915;
i__126804_126901 = G__126916;
continue;
} else {
var vec__126817_126917 = cljs.core.first(seq__126801_126911__$1);
var k_126918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126817_126917,(0),null);
var f_126919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__126817_126917,(1),null);
try{(f_126919.cljs$core$IFn$_invoke$arity$1 ? f_126919.cljs$core$IFn$_invoke$arity$1(tx_response_126897) : f_126919.call(null,tx_response_126897));
}catch (e126820){if((e126820 instanceof java.lang.Exception)){
var e_126920 = e126820;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_126920,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
} else {
throw e126820;

}
}

var G__126921 = cljs.core.next(seq__126801_126911__$1);
var G__126922 = null;
var G__126923 = (0);
var G__126924 = (0);
seq__126801_126898 = G__126921;
chunk__126802_126899 = G__126922;
count__126803_126900 = G__126923;
i__126804_126901 = G__126924;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__126925 = cljs.core.next(seq__126737__$1);
var G__126926 = null;
var G__126927 = (0);
var G__126928 = (0);
seq__126737 = G__126925;
chunk__126738 = G__126926;
count__126739 = G__126927;
i__126740 = G__126928;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});})(G__126733_126852,G__126734_126853,G__126735_126854,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt))
;
var fexpr__126732_126856 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__126732_126856.cljs$core$IFn$_invoke$arity$4 ? fexpr__126732_126856.cljs$core$IFn$_invoke$arity$4(G__126733_126852,G__126734_126853,G__126735_126854,G__126736_126855) : fexpr__126732_126856.call(null,G__126733_126852,G__126734_126853,G__126735_126854,G__126736_126855));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_126929 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__110077__auto___126930 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt){
return (function (state_126837){
var state_val_126838 = (state_126837[(1)]);
if((state_val_126838 === (1))){
var state_126837__$1 = state_126837;
var statearr_126839_126931 = state_126837__$1;
(statearr_126839_126931[(2)] = null);

(statearr_126839_126931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126838 === (2))){
var inst_126822 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_126837__$1 = state_126837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_126837__$1,(4),inst_126822);
} else {
if((state_val_126838 === (3))){
var inst_126835 = (state_126837[(2)]);
var state_126837__$1 = state_126837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_126837__$1,inst_126835);
} else {
if((state_val_126838 === (4))){
var inst_126824 = (state_126837[(7)]);
var inst_126824__$1 = (state_126837[(2)]);
var inst_126825 = (inst_126824__$1 == null);
var state_126837__$1 = (function (){var statearr_126840 = state_126837;
(statearr_126840[(7)] = inst_126824__$1);

return statearr_126840;
})();
if(cljs.core.truth_(inst_126825)){
var statearr_126841_126932 = state_126837__$1;
(statearr_126841_126932[(1)] = (5));

} else {
var statearr_126842_126933 = state_126837__$1;
(statearr_126842_126933[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_126838 === (5))){
var inst_126827 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_126828 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_126827], 0));
var state_126837__$1 = state_126837;
var statearr_126843_126934 = state_126837__$1;
(statearr_126843_126934[(2)] = inst_126828);

(statearr_126843_126934[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126838 === (6))){
var inst_126824 = (state_126837[(7)]);
var inst_126830 = (transact_handler_126929.cljs$core$IFn$_invoke$arity$2 ? transact_handler_126929.cljs$core$IFn$_invoke$arity$2(conn,inst_126824) : transact_handler_126929.call(null,conn,inst_126824));
var state_126837__$1 = (function (){var statearr_126844 = state_126837;
(statearr_126844[(8)] = inst_126830);

return statearr_126844;
})();
var statearr_126845_126935 = state_126837__$1;
(statearr_126845_126935[(2)] = null);

(statearr_126845_126935[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_126838 === (7))){
var inst_126833 = (state_126837[(2)]);
var state_126837__$1 = state_126837;
var statearr_126846_126936 = state_126837__$1;
(statearr_126846_126936[(2)] = inst_126833);

(statearr_126846_126936[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt))
;
return ((function (switch__109970__auto__,c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt){
return (function() {
var fluree$db$session$state_machine__109971__auto__ = null;
var fluree$db$session$state_machine__109971__auto____0 = (function (){
var statearr_126847 = [null,null,null,null,null,null,null,null,null];
(statearr_126847[(0)] = fluree$db$session$state_machine__109971__auto__);

(statearr_126847[(1)] = (1));

return statearr_126847;
});
var fluree$db$session$state_machine__109971__auto____1 = (function (state_126837){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_126837);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e126848){if((e126848 instanceof Object)){
var ex__109974__auto__ = e126848;
var statearr_126849_126937 = state_126837;
(statearr_126849_126937[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_126837);

return cljs.core.cst$kw$recur;
} else {
throw e126848;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__126938 = state_126837;
state_126837 = G__126938;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$session$state_machine__109971__auto__ = function(state_126837){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__109971__auto____1.call(this,state_126837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__109971__auto____0;
fluree$db$session$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__109971__auto____1;
return fluree$db$session$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt))
})();
var state__110079__auto__ = (function (){var statearr_126850 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_126850[(6)] = c__110077__auto___126930);

return statearr_126850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___126930,transact_handler_126929,session,new_QMARK_,or__4131__auto__,vec__126729,network,ledger_id,ledger_alias,connect_QMARK___$1,transactor_QMARK_,opts,map__126727,map__126727__$1,state,connect_QMARK_,auth,jwt))
);

} else {
}
} else {
}

return session;
}
});

fluree.db.session.session.cljs$lang$maxFixedArity = 3;

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__126939_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__126939_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__126939_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),((function (db){
return (function (p1__126940_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__126940_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});})(db))
);

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__126943 = arguments.length;
switch (G__126943) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
});

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__126944 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__126944){
return (function (p1__126941_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__126941_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
});})(G__126944))
,G__126944);
} else {
return G__126944;
}
})();
var seq__126945 = cljs.core.seq(sessions);
var chunk__126946 = null;
var count__126947 = (0);
var i__126948 = (0);
while(true){
if((i__126948 < count__126947)){
var session = chunk__126946.cljs$core$IIndexed$_nth$arity$2(null,i__126948);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__126950 = seq__126945;
var G__126951 = chunk__126946;
var G__126952 = count__126947;
var G__126953 = (i__126948 + (1));
seq__126945 = G__126950;
chunk__126946 = G__126951;
count__126947 = G__126952;
i__126948 = G__126953;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__126945);
if(temp__5735__auto__){
var seq__126945__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__126945__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__126945__$1);
var G__126954 = cljs.core.chunk_rest(seq__126945__$1);
var G__126955 = c__4550__auto__;
var G__126956 = cljs.core.count(c__4550__auto__);
var G__126957 = (0);
seq__126945 = G__126954;
chunk__126946 = G__126955;
count__126947 = G__126956;
i__126948 = G__126957;
continue;
} else {
var session = cljs.core.first(seq__126945__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__126958 = cljs.core.next(seq__126945__$1);
var G__126959 = null;
var G__126960 = (0);
var G__126961 = (0);
seq__126945 = G__126958;
chunk__126946 = G__126959;
count__126947 = G__126960;
i__126948 = G__126961;
continue;
}
} else {
return null;
}
}
break;
}
});

fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1;

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
