// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.time_travel');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.range');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
/**
 * Given a duration, returns a ISO-8601 formatted time string of now minus duration
 */
fluree.db.time_travel.duration_parse = (function fluree$db$time_travel$duration_parse(time_str){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Duration timeframes not yet supported in javascript.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_platform_DASH_support], null));
});
fluree.db.time_travel.time_to_t = (function fluree$db$time_travel$time_to_t(db,time_str){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117501){
var state_val_117502 = (state_117501[(1)]);
if((state_val_117502 === (7))){
var inst_117454 = (state_117501[(7)]);
var inst_117452 = (state_117501[(2)]);
var inst_117454__$1 = fluree.db.dbproto._rootdb(db);
var inst_117455 = (inst_117454__$1 == null);
var state_117501__$1 = (function (){var statearr_117503 = state_117501;
(statearr_117503[(8)] = inst_117452);

(statearr_117503[(7)] = inst_117454__$1);

return statearr_117503;
})();
if(cljs.core.truth_(inst_117455)){
var statearr_117504_117538 = state_117501__$1;
(statearr_117504_117538[(1)] = (8));

} else {
var statearr_117505_117539 = state_117501__$1;
(statearr_117505_117539[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (20))){
var inst_117497 = (state_117501[(2)]);
var state_117501__$1 = state_117501;
var statearr_117506_117540 = state_117501__$1;
(statearr_117506_117540[(2)] = inst_117497);


cljs.core.async.impl.ioc_helpers.process_exception(state_117501__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (1))){
var state_117501__$1 = state_117501;
var statearr_117507_117541 = state_117501__$1;
(statearr_117507_117541[(2)] = null);

(statearr_117507_117541[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117501,(3),Error,null,(2));
var inst_117447 = typeof time_str === 'string';
var state_117501__$1 = state_117501;
if(cljs.core.truth_(inst_117447)){
var statearr_117508_117542 = state_117501__$1;
(statearr_117508_117542[(1)] = (5));

} else {
var statearr_117509_117543 = state_117501__$1;
(statearr_117509_117543[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (15))){
var inst_117452 = (state_117501[(8)]);
var inst_117477 = ["There is no data as of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117452)].join('');
var inst_117478 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117479 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_block];
var inst_117480 = cljs.core.PersistentHashMap.fromArrays(inst_117478,inst_117479);
var inst_117481 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117477,inst_117480);
var inst_117482 = (function(){throw inst_117481})();
var state_117501__$1 = state_117501;
var statearr_117510_117544 = state_117501__$1;
(statearr_117510_117544[(2)] = inst_117482);

(statearr_117510_117544[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (21))){
var inst_117487 = (state_117501[(9)]);
var state_117501__$1 = state_117501;
var statearr_117511_117545 = state_117501__$1;
(statearr_117511_117545[(2)] = inst_117487);

(statearr_117511_117545[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (13))){
var inst_117474 = (state_117501[(10)]);
var inst_117474__$1 = (state_117501[(2)]);
var inst_117475 = cljs.core.empty_QMARK_(inst_117474__$1);
var state_117501__$1 = (function (){var statearr_117512 = state_117501;
(statearr_117512[(10)] = inst_117474__$1);

return statearr_117512;
})();
if(inst_117475){
var statearr_117513_117546 = state_117501__$1;
(statearr_117513_117546[(1)] = (15));

} else {
var statearr_117514_117547 = state_117501__$1;
(statearr_117514_117547[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (22))){
var inst_117493 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_117501__$1 = state_117501;
var statearr_117515_117548 = state_117501__$1;
(statearr_117515_117548[(2)] = inst_117493);

(statearr_117515_117548[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (6))){
var state_117501__$1 = state_117501;
var statearr_117516_117549 = state_117501__$1;
(statearr_117516_117549[(2)] = time_str);

(statearr_117516_117549[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (17))){
var inst_117488 = (state_117501[(11)]);
var inst_117487 = (state_117501[(9)]);
var inst_117474 = (state_117501[(10)]);
var inst_117452 = (state_117501[(8)]);
var inst_117485 = (state_117501[(2)]);
var inst_117486 = (function (){var epoch_as_of = inst_117452;
var ts = inst_117474;
var _ = inst_117485;
return ((function (epoch_as_of,ts,_,inst_117488,inst_117487,inst_117474,inst_117452,inst_117485,state_val_117502,c__110077__auto__){
return (function (p1__117442_SHARP_){
return p1__117442_SHARP_.s;
});
;})(epoch_as_of,ts,_,inst_117488,inst_117487,inst_117474,inst_117452,inst_117485,state_val_117502,c__110077__auto__))
})();
var inst_117487__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,inst_117486,inst_117474);
var inst_117488__$1 = inst_117487__$1.s;
var state_117501__$1 = (function (){var statearr_117517 = state_117501;
(statearr_117517[(11)] = inst_117488__$1);

(statearr_117517[(9)] = inst_117487__$1);

return statearr_117517;
})();
if(cljs.core.truth_(inst_117488__$1)){
var statearr_117518_117550 = state_117501__$1;
(statearr_117518_117550[(1)] = (18));

} else {
var statearr_117519_117551 = state_117501__$1;
(statearr_117519_117551[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (3))){
var inst_117443 = (state_117501[(2)]);
var state_117501__$1 = state_117501;
var statearr_117520_117552 = state_117501__$1;
(statearr_117520_117552[(2)] = inst_117443);


cljs.core.async.impl.ioc_helpers.process_exception(state_117501__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (12))){
var inst_117466 = (state_117501[(12)]);
var state_117501__$1 = state_117501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117501__$1,(14),inst_117466);
} else {
if((state_val_117502 === (2))){
var inst_117499 = (state_117501[(2)]);
var state_117501__$1 = state_117501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117501__$1,inst_117499);
} else {
if((state_val_117502 === (23))){
var inst_117495 = (state_117501[(2)]);
var state_117501__$1 = state_117501;
var statearr_117521_117553 = state_117501__$1;
(statearr_117521_117553[(2)] = inst_117495);

(statearr_117521_117553[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (19))){
var inst_117487 = (state_117501[(9)]);
var state_117501__$1 = state_117501;
if(cljs.core.truth_(inst_117487)){
var statearr_117522_117554 = state_117501__$1;
(statearr_117522_117554[(1)] = (21));

} else {
var statearr_117523_117555 = state_117501__$1;
(statearr_117523_117555[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (11))){
var state_117501__$1 = state_117501;
var statearr_117524_117556 = state_117501__$1;
(statearr_117524_117556[(2)] = null);

(statearr_117524_117556[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (9))){
var inst_117452 = (state_117501[(8)]);
var inst_117454 = (state_117501[(7)]);
var inst_117458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117459 = ["_block/instant",(0)];
var inst_117460 = (new cljs.core.PersistentVector(null,2,(5),inst_117458,inst_117459,null));
var inst_117461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117462 = ["_block/instant",inst_117452];
var inst_117463 = (new cljs.core.PersistentVector(null,2,(5),inst_117461,inst_117462,null));
var inst_117464 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(inst_117454,cljs.core.cst$kw$post,cljs.core._GT_,inst_117460,cljs.core._LT_,inst_117463);
var state_117501__$1 = state_117501;
var statearr_117525_117557 = state_117501__$1;
(statearr_117525_117557[(2)] = inst_117464);

(statearr_117525_117557[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (5))){
var inst_117449 = fluree.db.util.core.str__GT_epoch_ms(time_str);
var state_117501__$1 = state_117501;
var statearr_117526_117558 = state_117501__$1;
(statearr_117526_117558[(2)] = inst_117449);

(statearr_117526_117558[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (14))){
var inst_117471 = (state_117501[(2)]);
var inst_117472 = fluree.db.util.async.throw_err(inst_117471);
var state_117501__$1 = state_117501;
var statearr_117527_117559 = state_117501__$1;
(statearr_117527_117559[(2)] = inst_117472);

(statearr_117527_117559[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (16))){
var state_117501__$1 = state_117501;
var statearr_117528_117560 = state_117501__$1;
(statearr_117528_117560[(2)] = null);

(statearr_117528_117560[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (10))){
var inst_117466 = (state_117501[(12)]);
var inst_117466__$1 = (state_117501[(2)]);
var inst_117467 = (inst_117466__$1 == null);
var state_117501__$1 = (function (){var statearr_117529 = state_117501;
(statearr_117529[(12)] = inst_117466__$1);

return statearr_117529;
})();
if(cljs.core.truth_(inst_117467)){
var statearr_117530_117561 = state_117501__$1;
(statearr_117530_117561[(1)] = (11));

} else {
var statearr_117531_117562 = state_117501__$1;
(statearr_117531_117562[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (18))){
var inst_117488 = (state_117501[(11)]);
var state_117501__$1 = state_117501;
var statearr_117532_117563 = state_117501__$1;
(statearr_117532_117563[(2)] = inst_117488);

(statearr_117532_117563[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117502 === (8))){
var state_117501__$1 = state_117501;
var statearr_117533_117564 = state_117501__$1;
(statearr_117533_117564[(2)] = null);

(statearr_117533_117564[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____0 = (function (){
var statearr_117534 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117534[(0)] = fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__);

(statearr_117534[(1)] = (1));

return statearr_117534;
});
var fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____1 = (function (state_117501){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117501);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117535){if((e117535 instanceof Object)){
var ex__109974__auto__ = e117535;
var statearr_117536_117565 = state_117501;
(statearr_117536_117565[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117501);

return cljs.core.cst$kw$recur;
} else {
throw e117535;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117566 = state_117501;
state_117501 = G__117566;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__ = function(state_117501){
switch(arguments.length){
case 0:
return fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____1.call(this,state_117501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____0;
fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$time_to_t_$_state_machine__109971__auto____1;
return fluree$db$time_travel$time_to_t_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117537 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117537[(6)] = c__110077__auto__);

return statearr_117537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.time_travel.t_to_block = (function fluree$db$time_travel$t_to_block(db,t){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117616){
var state_val_117617 = (state_117616[(1)]);
if((state_val_117617 === (7))){
var inst_117587 = (state_117616[(7)]);
var inst_117587__$1 = (state_117616[(2)]);
var inst_117588 = (inst_117587__$1 == null);
var state_117616__$1 = (function (){var statearr_117618 = state_117616;
(statearr_117618[(7)] = inst_117587__$1);

return statearr_117618;
})();
if(cljs.core.truth_(inst_117588)){
var statearr_117619_117650 = state_117616__$1;
(statearr_117619_117650[(1)] = (8));

} else {
var statearr_117620_117651 = state_117616__$1;
(statearr_117620_117651[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (20))){
var inst_117612 = (state_117616[(2)]);
var state_117616__$1 = state_117616;
var statearr_117621_117652 = state_117616__$1;
(statearr_117621_117652[(2)] = inst_117612);


cljs.core.async.impl.ioc_helpers.process_exception(state_117616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (1))){
var state_117616__$1 = state_117616;
var statearr_117622_117653 = state_117616__$1;
(statearr_117622_117653[(2)] = null);

(statearr_117622_117653[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (4))){
var inst_117572 = (state_117616[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117616,(3),Error,null,(2));
var inst_117572__$1 = fluree.db.dbproto._rootdb(db);
var inst_117573 = (inst_117572__$1 == null);
var state_117616__$1 = (function (){var statearr_117623 = state_117616;
(statearr_117623[(8)] = inst_117572__$1);

return statearr_117623;
})();
if(cljs.core.truth_(inst_117573)){
var statearr_117624_117654 = state_117616__$1;
(statearr_117624_117654[(1)] = (5));

} else {
var statearr_117625_117655 = state_117616__$1;
(statearr_117625_117655[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (15))){
var state_117616__$1 = state_117616;
var statearr_117626_117656 = state_117616__$1;
(statearr_117626_117656[(2)] = null);

(statearr_117626_117656[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (13))){
var inst_117595 = (state_117616[(9)]);
var inst_117599 = cljs.core.first(inst_117595);
var state_117616__$1 = state_117616;
var statearr_117627_117657 = state_117616__$1;
(statearr_117627_117657[(2)] = inst_117599);

(statearr_117627_117657[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (6))){
var inst_117572 = (state_117616[(8)]);
var inst_117576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117577 = ["_block/number",t];
var inst_117578 = (new cljs.core.PersistentVector(null,2,(5),inst_117576,inst_117577,null));
var inst_117579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117580 = ["_block/number"];
var inst_117581 = (new cljs.core.PersistentVector(null,1,(5),inst_117579,inst_117580,null));
var inst_117582 = [cljs.core.cst$kw$limit];
var inst_117583 = [(1)];
var inst_117584 = cljs.core.PersistentHashMap.fromArrays(inst_117582,inst_117583);
var inst_117585 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(inst_117572,cljs.core.cst$kw$psot,cljs.core._GT__EQ_,inst_117578,cljs.core._LT__EQ_,inst_117581,inst_117584);
var state_117616__$1 = state_117616;
var statearr_117628_117658 = state_117616__$1;
(statearr_117628_117658[(2)] = inst_117585);

(statearr_117628_117658[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (17))){
var inst_117607 = (state_117616[(10)]);
var inst_117607__$1 = (state_117616[(2)]);
var inst_117608 = (inst_117607__$1 > (1));
var state_117616__$1 = (function (){var statearr_117629 = state_117616;
(statearr_117629[(10)] = inst_117607__$1);

return statearr_117629;
})();
if(cljs.core.truth_(inst_117608)){
var statearr_117630_117659 = state_117616__$1;
(statearr_117630_117659[(1)] = (18));

} else {
var statearr_117631_117660 = state_117616__$1;
(statearr_117631_117660[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (3))){
var inst_117567 = (state_117616[(2)]);
var state_117616__$1 = state_117616;
var statearr_117632_117661 = state_117616__$1;
(statearr_117632_117661[(2)] = inst_117567);


cljs.core.async.impl.ioc_helpers.process_exception(state_117616__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (12))){
var state_117616__$1 = state_117616;
var statearr_117633_117662 = state_117616__$1;
(statearr_117633_117662[(2)] = null);

(statearr_117633_117662[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (2))){
var inst_117614 = (state_117616[(2)]);
var state_117616__$1 = state_117616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117616__$1,inst_117614);
} else {
if((state_val_117617 === (19))){
var state_117616__$1 = state_117616;
var statearr_117634_117663 = state_117616__$1;
(statearr_117634_117663[(2)] = (1));

(statearr_117634_117663[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (11))){
var inst_117592 = (state_117616[(2)]);
var inst_117593 = fluree.db.util.async.throw_err(inst_117592);
var state_117616__$1 = state_117616;
var statearr_117635_117664 = state_117616__$1;
(statearr_117635_117664[(2)] = inst_117593);

(statearr_117635_117664[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (9))){
var inst_117587 = (state_117616[(7)]);
var state_117616__$1 = state_117616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117616__$1,(11),inst_117587);
} else {
if((state_val_117617 === (5))){
var state_117616__$1 = state_117616;
var statearr_117636_117665 = state_117616__$1;
(statearr_117636_117665[(2)] = null);

(statearr_117636_117665[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (14))){
var inst_117601 = (state_117616[(11)]);
var inst_117601__$1 = (state_117616[(2)]);
var inst_117602 = (inst_117601__$1 == null);
var state_117616__$1 = (function (){var statearr_117637 = state_117616;
(statearr_117637[(11)] = inst_117601__$1);

return statearr_117637;
})();
if(cljs.core.truth_(inst_117602)){
var statearr_117638_117666 = state_117616__$1;
(statearr_117638_117666[(1)] = (15));

} else {
var statearr_117639_117667 = state_117616__$1;
(statearr_117639_117667[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (16))){
var inst_117601 = (state_117616[(11)]);
var inst_117605 = inst_117601.o;
var state_117616__$1 = state_117616;
var statearr_117640_117668 = state_117616__$1;
(statearr_117640_117668[(2)] = inst_117605);

(statearr_117640_117668[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (10))){
var inst_117595 = (state_117616[(9)]);
var inst_117595__$1 = (state_117616[(2)]);
var inst_117596 = (inst_117595__$1 == null);
var state_117616__$1 = (function (){var statearr_117641 = state_117616;
(statearr_117641[(9)] = inst_117595__$1);

return statearr_117641;
})();
if(cljs.core.truth_(inst_117596)){
var statearr_117642_117669 = state_117616__$1;
(statearr_117642_117669[(1)] = (12));

} else {
var statearr_117643_117670 = state_117616__$1;
(statearr_117643_117670[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (18))){
var inst_117607 = (state_117616[(10)]);
var state_117616__$1 = state_117616;
var statearr_117644_117671 = state_117616__$1;
(statearr_117644_117671[(2)] = inst_117607);

(statearr_117644_117671[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117617 === (8))){
var state_117616__$1 = state_117616;
var statearr_117645_117672 = state_117616__$1;
(statearr_117645_117672[(2)] = null);

(statearr_117645_117672[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____0 = (function (){
var statearr_117646 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117646[(0)] = fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__);

(statearr_117646[(1)] = (1));

return statearr_117646;
});
var fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____1 = (function (state_117616){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117616);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117647){if((e117647 instanceof Object)){
var ex__109974__auto__ = e117647;
var statearr_117648_117673 = state_117616;
(statearr_117648_117673[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117616);

return cljs.core.cst$kw$recur;
} else {
throw e117647;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117674 = state_117616;
state_117616 = G__117674;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__ = function(state_117616){
switch(arguments.length){
case 0:
return fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____1.call(this,state_117616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____0;
fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$t_to_block_$_state_machine__109971__auto____1;
return fluree$db$time_travel$t_to_block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117649 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117649[(6)] = c__110077__auto__);

return statearr_117649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.time_travel.non_border_t_to_block = (function fluree$db$time_travel$non_border_t_to_block(db,t){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117722){
var state_val_117723 = (state_117722[(1)]);
if((state_val_117723 === (7))){
var inst_117689 = (state_117722[(7)]);
var inst_117689__$1 = (state_117722[(2)]);
var inst_117690 = (inst_117689__$1 == null);
var state_117722__$1 = (function (){var statearr_117724 = state_117722;
(statearr_117724[(7)] = inst_117689__$1);

return statearr_117724;
})();
if(cljs.core.truth_(inst_117690)){
var statearr_117725_117756 = state_117722__$1;
(statearr_117725_117756[(1)] = (8));

} else {
var statearr_117726_117757 = state_117722__$1;
(statearr_117726_117757[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (20))){
var state_117722__$1 = state_117722;
var statearr_117727_117758 = state_117722__$1;
(statearr_117727_117758[(2)] = (1));

(statearr_117727_117758[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (1))){
var state_117722__$1 = state_117722;
var statearr_117728_117759 = state_117722__$1;
(statearr_117728_117759[(2)] = null);

(statearr_117728_117759[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (4))){
var inst_117680 = (state_117722[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117722,(3),Error,null,(2));
var inst_117680__$1 = fluree.db.dbproto._rootdb(db);
var inst_117681 = (inst_117680__$1 == null);
var state_117722__$1 = (function (){var statearr_117729 = state_117722;
(statearr_117729[(8)] = inst_117680__$1);

return statearr_117729;
})();
if(cljs.core.truth_(inst_117681)){
var statearr_117730_117760 = state_117722__$1;
(statearr_117730_117760[(1)] = (5));

} else {
var statearr_117731_117761 = state_117722__$1;
(statearr_117731_117761[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (15))){
var state_117722__$1 = state_117722;
var statearr_117732_117762 = state_117722__$1;
(statearr_117732_117762[(2)] = null);

(statearr_117732_117762[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (21))){
var inst_117718 = (state_117722[(2)]);
var state_117722__$1 = state_117722;
var statearr_117733_117763 = state_117722__$1;
(statearr_117733_117763[(2)] = inst_117718);


cljs.core.async.impl.ioc_helpers.process_exception(state_117722__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (13))){
var inst_117697 = (state_117722[(9)]);
var inst_117701 = cljs.core.first(inst_117697);
var state_117722__$1 = state_117722;
var statearr_117734_117764 = state_117722__$1;
(statearr_117734_117764[(2)] = inst_117701);

(statearr_117734_117764[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (6))){
var inst_117680 = (state_117722[(8)]);
var inst_117684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117685 = [t,"_block/transactions"];
var inst_117686 = (new cljs.core.PersistentVector(null,2,(5),inst_117684,inst_117685,null));
var inst_117687 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_117680,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_117686);
var state_117722__$1 = state_117722;
var statearr_117735_117765 = state_117722__$1;
(statearr_117735_117765[(2)] = inst_117687);

(statearr_117735_117765[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (17))){
var inst_117709 = (state_117722[(2)]);
var inst_117710 = fluree.db.time_travel.t_to_block(db,inst_117709);
var state_117722__$1 = state_117722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117722__$1,(18),inst_117710);
} else {
if((state_val_117723 === (3))){
var inst_117675 = (state_117722[(2)]);
var state_117722__$1 = state_117722;
var statearr_117736_117766 = state_117722__$1;
(statearr_117736_117766[(2)] = inst_117675);


cljs.core.async.impl.ioc_helpers.process_exception(state_117722__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (12))){
var state_117722__$1 = state_117722;
var statearr_117737_117767 = state_117722__$1;
(statearr_117737_117767[(2)] = null);

(statearr_117737_117767[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (2))){
var inst_117720 = (state_117722[(2)]);
var state_117722__$1 = state_117722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117722__$1,inst_117720);
} else {
if((state_val_117723 === (19))){
var inst_117713 = (state_117722[(10)]);
var state_117722__$1 = state_117722;
var statearr_117738_117768 = state_117722__$1;
(statearr_117738_117768[(2)] = inst_117713);

(statearr_117738_117768[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (11))){
var inst_117694 = (state_117722[(2)]);
var inst_117695 = fluree.db.util.async.throw_err(inst_117694);
var state_117722__$1 = state_117722;
var statearr_117739_117769 = state_117722__$1;
(statearr_117739_117769[(2)] = inst_117695);

(statearr_117739_117769[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (9))){
var inst_117689 = (state_117722[(7)]);
var state_117722__$1 = state_117722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117722__$1,(11),inst_117689);
} else {
if((state_val_117723 === (5))){
var state_117722__$1 = state_117722;
var statearr_117740_117770 = state_117722__$1;
(statearr_117740_117770[(2)] = null);

(statearr_117740_117770[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (14))){
var inst_117703 = (state_117722[(11)]);
var inst_117703__$1 = (state_117722[(2)]);
var inst_117704 = (inst_117703__$1 == null);
var state_117722__$1 = (function (){var statearr_117741 = state_117722;
(statearr_117741[(11)] = inst_117703__$1);

return statearr_117741;
})();
if(cljs.core.truth_(inst_117704)){
var statearr_117742_117771 = state_117722__$1;
(statearr_117742_117771[(1)] = (15));

} else {
var statearr_117743_117772 = state_117722__$1;
(statearr_117743_117772[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (16))){
var inst_117703 = (state_117722[(11)]);
var inst_117707 = inst_117703.s;
var state_117722__$1 = state_117722;
var statearr_117744_117773 = state_117722__$1;
(statearr_117744_117773[(2)] = inst_117707);

(statearr_117744_117773[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (10))){
var inst_117697 = (state_117722[(9)]);
var inst_117697__$1 = (state_117722[(2)]);
var inst_117698 = (inst_117697__$1 == null);
var state_117722__$1 = (function (){var statearr_117745 = state_117722;
(statearr_117745[(9)] = inst_117697__$1);

return statearr_117745;
})();
if(cljs.core.truth_(inst_117698)){
var statearr_117746_117774 = state_117722__$1;
(statearr_117746_117774[(1)] = (12));

} else {
var statearr_117747_117775 = state_117722__$1;
(statearr_117747_117775[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (18))){
var inst_117713 = (state_117722[(10)]);
var inst_117712 = (state_117722[(2)]);
var inst_117713__$1 = fluree.db.util.async.throw_err(inst_117712);
var inst_117714 = (inst_117713__$1 > (1));
var state_117722__$1 = (function (){var statearr_117748 = state_117722;
(statearr_117748[(10)] = inst_117713__$1);

return statearr_117748;
})();
if(cljs.core.truth_(inst_117714)){
var statearr_117749_117776 = state_117722__$1;
(statearr_117749_117776[(1)] = (19));

} else {
var statearr_117750_117777 = state_117722__$1;
(statearr_117750_117777[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117723 === (8))){
var state_117722__$1 = state_117722;
var statearr_117751_117778 = state_117722__$1;
(statearr_117751_117778[(2)] = null);

(statearr_117751_117778[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____0 = (function (){
var statearr_117752 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117752[(0)] = fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__);

(statearr_117752[(1)] = (1));

return statearr_117752;
});
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____1 = (function (state_117722){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117722);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117753){if((e117753 instanceof Object)){
var ex__109974__auto__ = e117753;
var statearr_117754_117779 = state_117722;
(statearr_117754_117779[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117722);

return cljs.core.cst$kw$recur;
} else {
throw e117753;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117780 = state_117722;
state_117722 = G__117780;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__ = function(state_117722){
switch(arguments.length){
case 0:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____1.call(this,state_117722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____0;
fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto____1;
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117755 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117755[(6)] = c__110077__auto__);

return statearr_117755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.time_travel.block_to_int_format = (function fluree$db$time_travel$block_to_int_format(db,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117835){
var state_val_117836 = (state_117835[(1)]);
if((state_val_117836 === (7))){
var inst_117831 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
var statearr_117837_117860 = state_117835__$1;
(statearr_117837_117860[(2)] = inst_117831);


cljs.core.async.impl.ioc_helpers.process_exception(state_117835__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (20))){
var inst_117825 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
var statearr_117838_117861 = state_117835__$1;
(statearr_117838_117861[(2)] = inst_117825);

(statearr_117838_117861[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (1))){
var state_117835__$1 = state_117835;
var statearr_117839_117862 = state_117835__$1;
(statearr_117839_117862[(2)] = null);

(statearr_117839_117862[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117835,(3),Error,null,(2));
var inst_117785 = cljs.core.pos_int_QMARK_(block);
var state_117835__$1 = state_117835;
if(inst_117785){
var statearr_117840_117863 = state_117835__$1;
(statearr_117840_117863[(1)] = (5));

} else {
var statearr_117841_117864 = state_117835__$1;
(statearr_117841_117864[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (15))){
var inst_117827 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
var statearr_117842_117865 = state_117835__$1;
(statearr_117842_117865[(2)] = inst_117827);

(statearr_117842_117865[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (13))){
var inst_117806 = fluree.db.time_travel.time_to_t(db,block);
var state_117835__$1 = state_117835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117835__$1,(16),inst_117806);
} else {
if((state_val_117836 === (6))){
var inst_117788 = typeof block === 'string';
var inst_117789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block,(0));
var inst_117790 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_117789);
var inst_117791 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_117790);
var inst_117792 = ((inst_117788) && (inst_117791));
var state_117835__$1 = state_117835;
if(cljs.core.truth_(inst_117792)){
var statearr_117843_117866 = state_117835__$1;
(statearr_117843_117866[(1)] = (8));

} else {
var statearr_117844_117867 = state_117835__$1;
(statearr_117844_117867[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (17))){
var inst_117812 = (state_117835[(2)]);
var inst_117813 = fluree.db.util.async.throw_err(inst_117812);
var state_117835__$1 = state_117835;
var statearr_117845_117868 = state_117835__$1;
(statearr_117845_117868[(2)] = inst_117813);

(statearr_117845_117868[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (3))){
var inst_117781 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
var statearr_117846_117869 = state_117835__$1;
(statearr_117846_117869[(2)] = inst_117781);


cljs.core.async.impl.ioc_helpers.process_exception(state_117835__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (12))){
var inst_117801 = (state_117835[(2)]);
var inst_117802 = fluree.db.util.async.throw_err(inst_117801);
var state_117835__$1 = state_117835;
var statearr_117847_117870 = state_117835__$1;
(statearr_117847_117870[(2)] = inst_117802);

(statearr_117847_117870[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (2))){
var inst_117833 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117835__$1,inst_117833);
} else {
if((state_val_117836 === (19))){
var state_117835__$1 = state_117835;
var statearr_117848_117871 = state_117835__$1;
(statearr_117848_117871[(2)] = null);

(statearr_117848_117871[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (11))){
var inst_117797 = (state_117835[(2)]);
var inst_117798 = fluree.db.util.async.throw_err(inst_117797);
var inst_117799 = fluree.db.time_travel.t_to_block(db,inst_117798);
var state_117835__$1 = state_117835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117835__$1,(12),inst_117799);
} else {
if((state_val_117836 === (9))){
var inst_117804 = typeof block === 'string';
var state_117835__$1 = state_117835;
if(cljs.core.truth_(inst_117804)){
var statearr_117849_117872 = state_117835__$1;
(statearr_117849_117872[(1)] = (13));

} else {
var statearr_117850_117873 = state_117835__$1;
(statearr_117850_117873[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (5))){
var state_117835__$1 = state_117835;
var statearr_117851_117874 = state_117835__$1;
(statearr_117851_117874[(2)] = block);

(statearr_117851_117874[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (14))){
var state_117835__$1 = state_117835;
var statearr_117852_117875 = state_117835__$1;
(statearr_117852_117875[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (16))){
var inst_117808 = (state_117835[(2)]);
var inst_117809 = fluree.db.util.async.throw_err(inst_117808);
var inst_117810 = fluree.db.time_travel.t_to_block(db,inst_117809);
var state_117835__$1 = state_117835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117835__$1,(17),inst_117810);
} else {
if((state_val_117836 === (10))){
var inst_117829 = (state_117835[(2)]);
var state_117835__$1 = state_117835;
var statearr_117854_117876 = state_117835__$1;
(statearr_117854_117876[(2)] = inst_117829);

(statearr_117854_117876[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (18))){
var inst_117816 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_117817 = ["Invalid block key provided: ",inst_117816].join('');
var inst_117818 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117819 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_117820 = cljs.core.PersistentHashMap.fromArrays(inst_117818,inst_117819);
var inst_117821 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117817,inst_117820);
var inst_117822 = (function(){throw inst_117821})();
var state_117835__$1 = state_117835;
var statearr_117855_117877 = state_117835__$1;
(statearr_117855_117877[(2)] = inst_117822);

(statearr_117855_117877[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117836 === (8))){
var inst_117794 = fluree.db.time_travel.duration_parse(block);
var inst_117795 = fluree.db.time_travel.time_to_t(db,inst_117794);
var state_117835__$1 = state_117835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117835__$1,(11),inst_117795);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____0 = (function (){
var statearr_117856 = [null,null,null,null,null,null,null];
(statearr_117856[(0)] = fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__);

(statearr_117856[(1)] = (1));

return statearr_117856;
});
var fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____1 = (function (state_117835){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117835);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117857){if((e117857 instanceof Object)){
var ex__109974__auto__ = e117857;
var statearr_117858_117878 = state_117835;
(statearr_117858_117878[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117835);

return cljs.core.cst$kw$recur;
} else {
throw e117857;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117879 = state_117835;
state_117835 = G__117879;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__ = function(state_117835){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____1.call(this,state_117835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____0;
fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto____1;
return fluree$db$time_travel$block_to_int_format_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117859 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117859[(6)] = c__110077__auto__);

return statearr_117859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.time_travel.block_to_t = (function fluree$db$time_travel$block_to_t(db,block){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_117929){
var state_val_117930 = (state_117929[(1)]);
if((state_val_117930 === (7))){
var inst_117894 = (state_117929[(7)]);
var inst_117894__$1 = (state_117929[(2)]);
var inst_117895 = (inst_117894__$1 == null);
var state_117929__$1 = (function (){var statearr_117931 = state_117929;
(statearr_117931[(7)] = inst_117894__$1);

return statearr_117931;
})();
if(cljs.core.truth_(inst_117895)){
var statearr_117932_117964 = state_117929__$1;
(statearr_117932_117964[(1)] = (8));

} else {
var statearr_117933_117965 = state_117929__$1;
(statearr_117933_117965[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (20))){
var inst_117914 = (state_117929[(8)]);
var inst_117925 = (state_117929[(2)]);
var state_117929__$1 = (function (){var statearr_117934 = state_117929;
(statearr_117934[(9)] = inst_117925);

return statearr_117934;
})();
var statearr_117935_117966 = state_117929__$1;
(statearr_117935_117966[(2)] = inst_117914);


cljs.core.async.impl.ioc_helpers.process_exception(state_117929__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (1))){
var state_117929__$1 = state_117929;
var statearr_117936_117967 = state_117929__$1;
(statearr_117936_117967[(2)] = null);

(statearr_117936_117967[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (4))){
var inst_117885 = (state_117929[(10)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117929,(3),Error,null,(2));
var inst_117885__$1 = fluree.db.dbproto._rootdb(db);
var inst_117886 = (inst_117885__$1 == null);
var state_117929__$1 = (function (){var statearr_117937 = state_117929;
(statearr_117937[(10)] = inst_117885__$1);

return statearr_117937;
})();
if(cljs.core.truth_(inst_117886)){
var statearr_117938_117968 = state_117929__$1;
(statearr_117938_117968[(1)] = (5));

} else {
var statearr_117939_117969 = state_117929__$1;
(statearr_117939_117969[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (15))){
var state_117929__$1 = state_117929;
var statearr_117940_117970 = state_117929__$1;
(statearr_117940_117970[(2)] = null);

(statearr_117940_117970[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (13))){
var inst_117902 = (state_117929[(11)]);
var inst_117906 = cljs.core.first(inst_117902);
var state_117929__$1 = state_117929;
var statearr_117941_117971 = state_117929__$1;
(statearr_117941_117971[(2)] = inst_117906);

(statearr_117941_117971[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (6))){
var inst_117885 = (state_117929[(10)]);
var inst_117889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117890 = ["_block/number",block];
var inst_117891 = (new cljs.core.PersistentVector(null,2,(5),inst_117889,inst_117890,null));
var inst_117892 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_117885,cljs.core.cst$kw$post,cljs.core._EQ_,inst_117891);
var state_117929__$1 = state_117929;
var statearr_117942_117972 = state_117929__$1;
(statearr_117942_117972[(2)] = inst_117892);

(statearr_117942_117972[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (17))){
var inst_117914 = (state_117929[(8)]);
var inst_117914__$1 = (state_117929[(2)]);
var state_117929__$1 = (function (){var statearr_117943 = state_117929;
(statearr_117943[(8)] = inst_117914__$1);

return statearr_117943;
})();
if(cljs.core.truth_(inst_117914__$1)){
var statearr_117944_117973 = state_117929__$1;
(statearr_117944_117973[(1)] = (18));

} else {
var statearr_117945_117974 = state_117929__$1;
(statearr_117945_117974[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (3))){
var inst_117880 = (state_117929[(2)]);
var state_117929__$1 = state_117929;
var statearr_117946_117975 = state_117929__$1;
(statearr_117946_117975[(2)] = inst_117880);


cljs.core.async.impl.ioc_helpers.process_exception(state_117929__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (12))){
var state_117929__$1 = state_117929;
var statearr_117947_117976 = state_117929__$1;
(statearr_117947_117976[(2)] = null);

(statearr_117947_117976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (2))){
var inst_117927 = (state_117929[(2)]);
var state_117929__$1 = state_117929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117929__$1,inst_117927);
} else {
if((state_val_117930 === (19))){
var inst_117917 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_117918 = ["Invalid block key provided: ",inst_117917].join('');
var inst_117919 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117920 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_117921 = cljs.core.PersistentHashMap.fromArrays(inst_117919,inst_117920);
var inst_117922 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_117918,inst_117921);
var inst_117923 = (function(){throw inst_117922})();
var state_117929__$1 = state_117929;
var statearr_117948_117977 = state_117929__$1;
(statearr_117948_117977[(2)] = inst_117923);

(statearr_117948_117977[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (11))){
var inst_117899 = (state_117929[(2)]);
var inst_117900 = fluree.db.util.async.throw_err(inst_117899);
var state_117929__$1 = state_117929;
var statearr_117949_117978 = state_117929__$1;
(statearr_117949_117978[(2)] = inst_117900);

(statearr_117949_117978[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (9))){
var inst_117894 = (state_117929[(7)]);
var state_117929__$1 = state_117929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_117929__$1,(11),inst_117894);
} else {
if((state_val_117930 === (5))){
var state_117929__$1 = state_117929;
var statearr_117950_117979 = state_117929__$1;
(statearr_117950_117979[(2)] = null);

(statearr_117950_117979[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (14))){
var inst_117908 = (state_117929[(12)]);
var inst_117908__$1 = (state_117929[(2)]);
var inst_117909 = (inst_117908__$1 == null);
var state_117929__$1 = (function (){var statearr_117951 = state_117929;
(statearr_117951[(12)] = inst_117908__$1);

return statearr_117951;
})();
if(cljs.core.truth_(inst_117909)){
var statearr_117952_117980 = state_117929__$1;
(statearr_117952_117980[(1)] = (15));

} else {
var statearr_117953_117981 = state_117929__$1;
(statearr_117953_117981[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (16))){
var inst_117908 = (state_117929[(12)]);
var inst_117912 = inst_117908.t;
var state_117929__$1 = state_117929;
var statearr_117954_117982 = state_117929__$1;
(statearr_117954_117982[(2)] = inst_117912);

(statearr_117954_117982[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (10))){
var inst_117902 = (state_117929[(11)]);
var inst_117902__$1 = (state_117929[(2)]);
var inst_117903 = (inst_117902__$1 == null);
var state_117929__$1 = (function (){var statearr_117955 = state_117929;
(statearr_117955[(11)] = inst_117902__$1);

return statearr_117955;
})();
if(cljs.core.truth_(inst_117903)){
var statearr_117956_117983 = state_117929__$1;
(statearr_117956_117983[(1)] = (12));

} else {
var statearr_117957_117984 = state_117929__$1;
(statearr_117957_117984[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (18))){
var state_117929__$1 = state_117929;
var statearr_117958_117985 = state_117929__$1;
(statearr_117958_117985[(2)] = null);

(statearr_117958_117985[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117930 === (8))){
var state_117929__$1 = state_117929;
var statearr_117959_117986 = state_117929__$1;
(statearr_117959_117986[(2)] = null);

(statearr_117959_117986[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____0 = (function (){
var statearr_117960 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_117960[(0)] = fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__);

(statearr_117960[(1)] = (1));

return statearr_117960;
});
var fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____1 = (function (state_117929){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117929);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117961){if((e117961 instanceof Object)){
var ex__109974__auto__ = e117961;
var statearr_117962_117987 = state_117929;
(statearr_117962_117987[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117929);

return cljs.core.cst$kw$recur;
} else {
throw e117961;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117988 = state_117929;
state_117929 = G__117988;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__ = function(state_117929){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____1.call(this,state_117929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____0;
fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_t_$_state_machine__109971__auto____1;
return fluree$db$time_travel$block_to_t_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_117963 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117963[(6)] = c__110077__auto__);

return statearr_117963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Gets the database as-of a specified block. Either block number or a time string in ISO-8601 format.
 *   Returns db as a promise channel
 */
fluree.db.time_travel.as_of_block = (function fluree$db$time_travel$as_of_block(db,block_or_t_or_time){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
try{var c__110077__auto___118086 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___118086,pc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___118086,pc){
return (function (state_118054){
var state_val_118055 = (state_118054[(1)]);
if((state_val_118055 === (7))){
var inst_117993 = (state_118054[(7)]);
var inst_117996 = (state_118054[(2)]);
var inst_117997 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_117993);
var state_118054__$1 = (function (){var statearr_118056 = state_118054;
(statearr_118056[(8)] = inst_117996);

return statearr_118056;
})();
var statearr_118057_118087 = state_118054__$1;
(statearr_118057_118087[(2)] = inst_117997);


cljs.core.async.impl.ioc_helpers.process_exception(state_118054__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (20))){
var inst_118025 = (state_118054[(2)]);
var inst_118026 = fluree.db.util.async.throw_err(inst_118025);
var state_118054__$1 = state_118054;
var statearr_118058_118088 = state_118054__$1;
(statearr_118058_118088[(2)] = inst_118026);

(statearr_118058_118088[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (1))){
var inst_117990 = fluree.db.dbproto._latest_db(db);
var state_118054__$1 = state_118054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118054__$1,(2),inst_117990);
} else {
if((state_val_118055 === (24))){
var inst_118046 = (state_118054[(9)]);
var inst_118049 = (state_118054[(2)]);
var inst_118050 = fluree.db.util.async.throw_err(inst_118049);
var inst_118051 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$t,inst_118046,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,inst_118050], 0));
var inst_118052 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_118051);
var state_118054__$1 = state_118054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118054__$1,inst_118052);
} else {
if((state_val_118055 === (4))){
var inst_118008 = cljs.core.neg_int_QMARK_(block_or_t_or_time);
var state_118054__$1 = state_118054;
if(inst_118008){
var statearr_118059_118089 = state_118054__$1;
(statearr_118059_118089[(1)] = (10));

} else {
var statearr_118060_118090 = state_118054__$1;
(statearr_118060_118090[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (15))){
var inst_118042 = (state_118054[(2)]);
var state_118054__$1 = state_118054;
var statearr_118061_118091 = state_118054__$1;
(statearr_118061_118091[(2)] = inst_118042);

(statearr_118061_118091[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (21))){
var inst_118031 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_or_t_or_time], 0));
var inst_118032 = ["Invalid block key provided: ",inst_118031].join('');
var inst_118033 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118034 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_118035 = cljs.core.PersistentHashMap.fromArrays(inst_118033,inst_118034);
var inst_118036 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118032,inst_118035);
var inst_118037 = (function(){throw inst_118036})();
var state_118054__$1 = state_118054;
var statearr_118062_118092 = state_118054__$1;
(statearr_118062_118092[(2)] = inst_118037);

(statearr_118062_118092[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (13))){
var inst_118013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block_or_t_or_time,(0));
var inst_118014 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_118013);
var inst_118015 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_118014);
var state_118054__$1 = state_118054;
if(inst_118015){
var statearr_118063_118093 = state_118054__$1;
(statearr_118063_118093[(1)] = (16));

} else {
var statearr_118064_118094 = state_118054__$1;
(statearr_118064_118094[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (22))){
var state_118054__$1 = state_118054;
var statearr_118065_118095 = state_118054__$1;
(statearr_118065_118095[(2)] = null);

(statearr_118065_118095[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (6))){
var inst_118006 = (state_118054[(2)]);
var state_118054__$1 = state_118054;
var statearr_118066_118096 = state_118054__$1;
(statearr_118066_118096[(2)] = inst_118006);

(statearr_118066_118096[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (17))){
var inst_117993 = (state_118054[(7)]);
var inst_118023 = fluree.db.time_travel.time_to_t(inst_117993,block_or_t_or_time);
var state_118054__$1 = state_118054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118054__$1,(20),inst_118023);
} else {
if((state_val_118055 === (3))){
var state_118054__$1 = state_118054;
var statearr_118067_118097 = state_118054__$1;
(statearr_118067_118097[(2)] = null);

(statearr_118067_118097[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (12))){
var inst_118044 = (state_118054[(2)]);
var state_118054__$1 = state_118054;
var statearr_118068_118098 = state_118054__$1;
(statearr_118068_118098[(2)] = inst_118044);

(statearr_118068_118098[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (2))){
var inst_117992 = (state_118054[(2)]);
var inst_117993 = fluree.db.util.async.throw_err(inst_117992);
var inst_117994 = cljs.core.pos_int_QMARK_(block_or_t_or_time);
var state_118054__$1 = (function (){var statearr_118069 = state_118054;
(statearr_118069[(7)] = inst_117993);

return statearr_118069;
})();
if(inst_117994){
var statearr_118070_118099 = state_118054__$1;
(statearr_118070_118099[(1)] = (3));

} else {
var statearr_118071_118100 = state_118054__$1;
(statearr_118071_118100[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (23))){
var inst_118040 = (state_118054[(2)]);
var state_118054__$1 = state_118054;
var statearr_118072_118101 = state_118054__$1;
(statearr_118072_118101[(2)] = inst_118040);

(statearr_118072_118101[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (19))){
var inst_118020 = (state_118054[(2)]);
var inst_118021 = fluree.db.util.async.throw_err(inst_118020);
var state_118054__$1 = state_118054;
var statearr_118073_118102 = state_118054__$1;
(statearr_118073_118102[(2)] = inst_118021);

(statearr_118073_118102[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (11))){
var inst_118011 = typeof block_or_t_or_time === 'string';
var state_118054__$1 = state_118054;
if(cljs.core.truth_(inst_118011)){
var statearr_118074_118103 = state_118054__$1;
(statearr_118074_118103[(1)] = (13));

} else {
var statearr_118075_118104 = state_118054__$1;
(statearr_118075_118104[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (9))){
var inst_118003 = (state_118054[(2)]);
var inst_118004 = fluree.db.util.async.throw_err(inst_118003);
var state_118054__$1 = state_118054;
var statearr_118076_118105 = state_118054__$1;
(statearr_118076_118105[(2)] = inst_118004);


cljs.core.async.impl.ioc_helpers.process_exception(state_118054__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (5))){
var inst_117993 = (state_118054[(7)]);
var inst_118046 = (state_118054[(9)]);
var inst_118046__$1 = (state_118054[(2)]);
var inst_118047 = fluree.db.time_travel.t_to_block(inst_117993,inst_118046__$1);
var state_118054__$1 = (function (){var statearr_118077 = state_118054;
(statearr_118077[(9)] = inst_118046__$1);

return statearr_118077;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118054__$1,(24),inst_118047);
} else {
if((state_val_118055 === (14))){
var state_118054__$1 = state_118054;
var statearr_118078_118106 = state_118054__$1;
(statearr_118078_118106[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (16))){
var inst_117993 = (state_118054[(7)]);
var inst_118017 = fluree.db.time_travel.duration_parse(block_or_t_or_time);
var inst_118018 = fluree.db.time_travel.time_to_t(inst_117993,inst_118017);
var state_118054__$1 = state_118054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118054__$1,(19),inst_118018);
} else {
if((state_val_118055 === (10))){
var state_118054__$1 = state_118054;
var statearr_118080_118107 = state_118054__$1;
(statearr_118080_118107[(2)] = block_or_t_or_time);

(statearr_118080_118107[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (18))){
var inst_118028 = (state_118054[(2)]);
var state_118054__$1 = state_118054;
var statearr_118081_118108 = state_118054__$1;
(statearr_118081_118108[(2)] = inst_118028);

(statearr_118081_118108[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118055 === (8))){
var inst_117993 = (state_118054[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118054,(7),java.lang.Exception,null,(6));
var inst_118001 = fluree.db.time_travel.block_to_t(inst_117993,block_or_t_or_time);
var state_118054__$1 = state_118054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118054__$1,(9),inst_118001);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto___118086,pc))
;
return ((function (switch__109970__auto__,c__110077__auto___118086,pc){
return (function() {
var fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__ = null;
var fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____0 = (function (){
var statearr_118082 = [null,null,null,null,null,null,null,null,null,null];
(statearr_118082[(0)] = fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__);

(statearr_118082[(1)] = (1));

return statearr_118082;
});
var fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____1 = (function (state_118054){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118054);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118083){if((e118083 instanceof Object)){
var ex__109974__auto__ = e118083;
var statearr_118084_118109 = state_118054;
(statearr_118084_118109[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118054);

return cljs.core.cst$kw$recur;
} else {
throw e118083;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118110 = state_118054;
state_118054 = G__118110;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__ = function(state_118054){
switch(arguments.length){
case 0:
return fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____1.call(this,state_118054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____0;
fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$as_of_block_$_state_machine__109971__auto____1;
return fluree$db$time_travel$as_of_block_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___118086,pc))
})();
var state__110079__auto__ = (function (){var statearr_118085 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118085[(6)] = c__110077__auto___118086);

return statearr_118085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___118086,pc))
);

}catch (e117989){if((e117989 instanceof java.lang.Exception)){
var e_118111 = e117989;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,e_118111);
} else {
throw e117989;

}
}
return pc;
});
