// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4736__auto__ = [];
var len__4730__auto___126967 = arguments.length;
var i__4731__auto___126968 = (0);
while(true){
if((i__4731__auto___126968 < len__4730__auto___126967)){
args__4736__auto__.push((arguments[i__4731__auto___126968]));

var G__126969 = (i__4731__auto___126968 + (1));
i__4731__auto___126968 = G__126969;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
});

fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq126964){
var G__126965 = cljs.core.first(seq126964);
var seq126964__$1 = cljs.core.next(seq126964);
var G__126966 = cljs.core.first(seq126964__$1);
var seq126964__$2 = cljs.core.next(seq126964__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__126965,G__126966,seq126964__$2);
});

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e126970){if((e126970 instanceof java.lang.Exception)){
var e = e126970;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
} else {
throw e126970;

}
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e126971){if((e126971 instanceof java.lang.Exception)){
var e = e126971;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e126971;

}
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e126972){if((e126972 instanceof java.lang.Exception)){
var e = e126972;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e126972;

}
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e126973){if((e126973 instanceof java.lang.Exception)){
var e = e126973;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
} else {
throw e126973;

}
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e126974){if((e126974 instanceof java.lang.Exception)){
var e = e126974;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
} else {
throw e126974;

}
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4736__auto__ = [];
var len__4730__auto___126977 = arguments.length;
var i__4731__auto___126978 = (0);
while(true){
if((i__4731__auto___126978 < len__4730__auto___126977)){
args__4736__auto__.push((arguments[i__4731__auto___126978]));

var G__126979 = (i__4731__auto___126978 + (1));
i__4731__auto___126978 = G__126979;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e126976){if((e126976 instanceof java.lang.Exception)){
var e = e126976;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e126976;

}
}});

fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq126975){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq126975));
});

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4736__auto__ = [];
var len__4730__auto___126982 = arguments.length;
var i__4731__auto___126983 = (0);
while(true){
if((i__4731__auto___126983 < len__4730__auto___126982)){
args__4736__auto__.push((arguments[i__4731__auto___126983]));

var G__126984 = (i__4731__auto___126983 + (1));
i__4731__auto___126983 = G__126984;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e126981){if((e126981 instanceof java.lang.Exception)){
var e = e126981;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e126981;

}
}});

fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq126980){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq126980));
});

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e126985){if((e126985 instanceof java.lang.Exception)){
var e = e126985;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
} else {
throw e126985;

}
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4736__auto__ = [];
var len__4730__auto___126988 = arguments.length;
var i__4731__auto___126989 = (0);
while(true){
if((i__4731__auto___126989 < len__4730__auto___126988)){
args__4736__auto__.push((arguments[i__4731__auto___126989]));

var G__126990 = (i__4731__auto___126989 + (1));
i__4731__auto___126989 = G__126990;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e126987){if((e126987 instanceof java.lang.Exception)){
var e = e126987;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e126987;

}
}});

fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq126986){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq126986));
});

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e126991){if((e126991 instanceof java.lang.Exception)){
var e = e126991;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
} else {
throw e126991;

}
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e126992){if((e126992 instanceof java.lang.Exception)){
var e = e126992;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
} else {
throw e126992;

}
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4736__auto__ = [];
var len__4730__auto___126995 = arguments.length;
var i__4731__auto___126996 = (0);
while(true){
if((i__4731__auto___126996 < len__4730__auto___126995)){
args__4736__auto__.push((arguments[i__4731__auto___126996]));

var G__126997 = (i__4731__auto___126996 + (1));
i__4731__auto___126996 = G__126997;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e126994){if((e126994 instanceof java.lang.Exception)){
var e = e126994;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e126994;

}
}});

fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq126993){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq126993));
});

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127000 = arguments.length;
var i__4731__auto___127001 = (0);
while(true){
if((i__4731__auto___127001 < len__4730__auto___127000)){
args__4736__auto__.push((arguments[i__4731__auto___127001]));

var G__127002 = (i__4731__auto___127001 + (1));
i__4731__auto___127001 = G__127002;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e126999){if((e126999 instanceof java.lang.Exception)){
var e = e126999;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e126999;

}
}});

fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq126998){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq126998));
});

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127005 = arguments.length;
var i__4731__auto___127006 = (0);
while(true){
if((i__4731__auto___127006 < len__4730__auto___127005)){
args__4736__auto__.push((arguments[i__4731__auto___127006]));

var G__127007 = (i__4731__auto___127006 + (1));
i__4731__auto___127006 = G__127007;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e127004){if((e127004 instanceof java.lang.Exception)){
var e = e127004;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127004;

}
}});

fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq127003){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127003));
});

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127010 = arguments.length;
var i__4731__auto___127011 = (0);
while(true){
if((i__4731__auto___127011 < len__4730__auto___127010)){
args__4736__auto__.push((arguments[i__4731__auto___127011]));

var G__127012 = (i__4731__auto___127011 + (1));
i__4731__auto___127011 = G__127012;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e127009){if((e127009 instanceof java.lang.Exception)){
var e = e127009;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127009;

}
}});

fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq127008){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127008));
});

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127015 = arguments.length;
var i__4731__auto___127016 = (0);
while(true){
if((i__4731__auto___127016 < len__4730__auto___127015)){
args__4736__auto__.push((arguments[i__4731__auto___127016]));

var G__127017 = (i__4731__auto___127016 + (1));
i__4731__auto___127016 = G__127017;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e127014){if((e127014 instanceof java.lang.Exception)){
var e = e127014;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127014;

}
}});

fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq127013){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127013));
});

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127020 = arguments.length;
var i__4731__auto___127021 = (0);
while(true){
if((i__4731__auto___127021 < len__4730__auto___127020)){
args__4736__auto__.push((arguments[i__4731__auto___127021]));

var G__127022 = (i__4731__auto___127021 + (1));
i__4731__auto___127021 = G__127022;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e127019){if((e127019 instanceof java.lang.Exception)){
var e = e127019;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127019;

}
}});

fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq127018){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127018));
});

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__127024 = arguments.length;
switch (G__127024) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127049){
var state_val_127050 = (state_127049[(1)]);
if((state_val_127050 === (1))){
var state_127049__$1 = state_127049;
var statearr_127051_127129 = state_127049__$1;
(statearr_127051_127129[(2)] = null);

(statearr_127051_127129[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127050 === (2))){
var inst_127047 = (state_127049[(2)]);
var state_127049__$1 = state_127049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127049__$1,inst_127047);
} else {
if((state_val_127050 === (3))){
var inst_127025 = (state_127049[(2)]);
var state_127049__$1 = state_127049;
var statearr_127052_127130 = state_127049__$1;
(statearr_127052_127130[(2)] = inst_127025);


cljs.core.async.impl.ioc_helpers.process_exception(state_127049__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127050 === (4))){
var inst_127029 = (state_127049[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127049,(3),Error,null,(2));
var inst_127029__$1 = cljs.core.volatile_BANG_((0));
var inst_127030 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_127031 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_127030,cljs.core.cst$kw$fuel,inst_127029__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_127032 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_127031);
var inst_127033 = fluree.db.query.fql.query(db,inst_127032);
var state_127049__$1 = (function (){var statearr_127053 = state_127049;
(statearr_127053[(7)] = inst_127029__$1);

return statearr_127053;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127049__$1,(5),inst_127033);
} else {
if((state_val_127050 === (5))){
var inst_127035 = (state_127049[(8)]);
var inst_127035__$1 = (state_127049[(2)]);
var inst_127036 = fluree.db.util.core.exception_QMARK_(inst_127035__$1);
var state_127049__$1 = (function (){var statearr_127054 = state_127049;
(statearr_127054[(8)] = inst_127035__$1);

return statearr_127054;
})();
if(inst_127036){
var statearr_127055_127131 = state_127049__$1;
(statearr_127055_127131[(1)] = (6));

} else {
var statearr_127056_127132 = state_127049__$1;
(statearr_127056_127132[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127050 === (6))){
var inst_127035 = (state_127049[(8)]);
var inst_127038 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127035,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_127049__$1 = state_127049;
var statearr_127057_127133 = state_127049__$1;
(statearr_127057_127133[(2)] = inst_127038);

(statearr_127057_127133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127050 === (7))){
var inst_127035 = (state_127049[(8)]);
var inst_127029 = (state_127049[(7)]);
var inst_127040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127041 = cljs.core.deref(inst_127029);
var inst_127042 = [inst_127035,inst_127041];
var inst_127043 = (new cljs.core.PersistentVector(null,2,(5),inst_127040,inst_127042,null));
var state_127049__$1 = state_127049;
var statearr_127058_127134 = state_127049__$1;
(statearr_127058_127134[(2)] = inst_127043);

(statearr_127058_127134[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127050 === (8))){
var inst_127045 = (state_127049[(2)]);
var state_127049__$1 = state_127049;
var statearr_127059_127135 = state_127049__$1;
(statearr_127059_127135[(2)] = inst_127045);


cljs.core.async.impl.ioc_helpers.process_exception(state_127049__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__109971__auto____0 = (function (){
var statearr_127060 = [null,null,null,null,null,null,null,null,null];
(statearr_127060[(0)] = fluree$db$dbfunctions$internal$state_machine__109971__auto__);

(statearr_127060[(1)] = (1));

return statearr_127060;
});
var fluree$db$dbfunctions$internal$state_machine__109971__auto____1 = (function (state_127049){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127049);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127061){if((e127061 instanceof Object)){
var ex__109974__auto__ = e127061;
var statearr_127062_127136 = state_127049;
(statearr_127062_127136[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127049);

return cljs.core.cst$kw$recur;
} else {
throw e127061;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127137 = state_127049;
state_127049 = G__127137;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__109971__auto__ = function(state_127049){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____1.call(this,state_127049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127063 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127063[(6)] = c__110077__auto__);

return statearr_127063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127108){
var state_val_127109 = (state_127108[(1)]);
if((state_val_127109 === (7))){
var inst_127094 = (state_127108[(2)]);
var inst_127095 = fluree.db.query.fql.query(db,inst_127094);
var state_127108__$1 = state_127108;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127108__$1,(8),inst_127095);
} else {
if((state_val_127109 === (1))){
var inst_127064 = typeof select === 'string';
var state_127108__$1 = state_127108;
if(cljs.core.truth_(inst_127064)){
var statearr_127110_127138 = state_127108__$1;
(statearr_127110_127138[(1)] = (2));

} else {
var statearr_127111_127139 = state_127108__$1;
(statearr_127111_127139[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (4))){
var inst_127070 = (state_127108[(7)]);
var inst_127077 = (state_127108[(8)]);
var inst_127069 = (state_127108[(2)]);
var inst_127070__$1 = cljs.core.volatile_BANG_((0));
var inst_127071 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_127072 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_127073 = [inst_127070__$1,(100000)];
var inst_127074 = cljs.core.PersistentHashMap.fromArrays(inst_127072,inst_127073);
var inst_127075 = [inst_127069,from,where,block,limit,inst_127074];
var inst_127076 = cljs.core.PersistentHashMap.fromArrays(inst_127071,inst_127075);
var inst_127077__$1 = fluree.db.util.core.without_nils(inst_127076);
var inst_127078 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_127077__$1);
var inst_127079 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_127077__$1);
var inst_127080 = cljs.core.first(inst_127079);
var inst_127081 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_127080], 0));
var inst_127082 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_127081);
var inst_127083 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_127077__$1);
var inst_127084 = cljs.core.last(inst_127083);
var inst_127085 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_127084], 0));
var inst_127086 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_127085);
var inst_127087 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_127078,inst_127082,inst_127086], 0));
var state_127108__$1 = (function (){var statearr_127112 = state_127108;
(statearr_127112[(7)] = inst_127070__$1);

(statearr_127112[(8)] = inst_127077__$1);

return statearr_127112;
})();
if(cljs.core.truth_(inst_127087)){
var statearr_127113_127140 = state_127108__$1;
(statearr_127113_127140[(1)] = (5));

} else {
var statearr_127114_127141 = state_127108__$1;
(statearr_127114_127141[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (6))){
var inst_127077 = (state_127108[(8)]);
var state_127108__$1 = state_127108;
var statearr_127115_127142 = state_127108__$1;
(statearr_127115_127142[(2)] = inst_127077);

(statearr_127115_127142[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (3))){
var state_127108__$1 = state_127108;
var statearr_127116_127143 = state_127108__$1;
(statearr_127116_127143[(2)] = select);

(statearr_127116_127143[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (2))){
var inst_127066 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_127108__$1 = state_127108;
var statearr_127117_127144 = state_127108__$1;
(statearr_127117_127144[(2)] = inst_127066);

(statearr_127117_127144[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (11))){
var inst_127106 = (state_127108[(2)]);
var state_127108__$1 = state_127108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127108__$1,inst_127106);
} else {
if((state_val_127109 === (9))){
var inst_127097 = (state_127108[(9)]);
var state_127108__$1 = state_127108;
var statearr_127118_127145 = state_127108__$1;
(statearr_127118_127145[(2)] = inst_127097);

(statearr_127118_127145[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (5))){
var inst_127077 = (state_127108[(8)]);
var inst_127089 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_127077);
var inst_127090 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_127089);
var inst_127091 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_127077,cljs.core.cst$kw$where,inst_127090);
var state_127108__$1 = state_127108;
var statearr_127119_127146 = state_127108__$1;
(statearr_127119_127146[(2)] = inst_127091);

(statearr_127119_127146[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (10))){
var inst_127070 = (state_127108[(7)]);
var inst_127097 = (state_127108[(9)]);
var inst_127101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127102 = cljs.core.deref(inst_127070);
var inst_127103 = [inst_127097,inst_127102];
var inst_127104 = (new cljs.core.PersistentVector(null,2,(5),inst_127101,inst_127103,null));
var state_127108__$1 = state_127108;
var statearr_127120_127147 = state_127108__$1;
(statearr_127120_127147[(2)] = inst_127104);

(statearr_127120_127147[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127109 === (8))){
var inst_127097 = (state_127108[(9)]);
var inst_127097__$1 = (state_127108[(2)]);
var inst_127098 = fluree.db.util.core.exception_QMARK_(inst_127097__$1);
var state_127108__$1 = (function (){var statearr_127121 = state_127108;
(statearr_127121[(9)] = inst_127097__$1);

return statearr_127121;
})();
if(inst_127098){
var statearr_127122_127148 = state_127108__$1;
(statearr_127122_127148[(1)] = (9));

} else {
var statearr_127123_127149 = state_127108__$1;
(statearr_127123_127149[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__109971__auto____0 = (function (){
var statearr_127124 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127124[(0)] = fluree$db$dbfunctions$internal$state_machine__109971__auto__);

(statearr_127124[(1)] = (1));

return statearr_127124;
});
var fluree$db$dbfunctions$internal$state_machine__109971__auto____1 = (function (state_127108){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127108);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127125){if((e127125 instanceof Object)){
var ex__109974__auto__ = e127125;
var statearr_127126_127150 = state_127108;
(statearr_127126_127150[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127108);

return cljs.core.cst$kw$recur;
} else {
throw e127125;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127151 = state_127108;
state_127108 = G__127151;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__109971__auto__ = function(state_127108){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____1.call(this,state_127108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127127 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127127[(6)] = c__110077__auto__);

return statearr_127127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6;

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(var$){
var vec__127152 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(var$,/\//);
var coll = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__127152,(0),null);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__127152,(1),null);
var pred__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(pred,(1));
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,"/",pred__$1], 0));
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__127158 = path;
var vec__127159 = G__127158;
var seq__127160 = cljs.core.seq(vec__127159);
var first__127161 = cljs.core.first(seq__127160);
var seq__127160__$1 = cljs.core.next(seq__127160);
var var$ = first__127161;
var r = seq__127160__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__127158__$1 = G__127158;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__127165 = G__127158__$1;
var seq__127166 = cljs.core.seq(vec__127165);
var first__127167 = cljs.core.first(seq__127166);
var seq__127166__$1 = cljs.core.next(seq__127166);
var var$__$1 = first__127167;
var r__$1 = seq__127166__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__127168 = r__$1;
var G__127169 = n__$2;
var G__127170 = next_clauses;
G__127158__$1 = G__127168;
n__$1 = G__127169;
where_clauses__$1 = G__127170;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__127171 = r__$1;
var G__127172 = next_n;
var G__127173 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__127158__$1 = G__127171;
n__$1 = G__127172;
where_clauses__$1 = G__127173;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127204){
var state_val_127205 = (state_127204[(1)]);
if((state_val_127205 === (7))){
var inst_127185 = (state_127204[(7)]);
var inst_127185__$1 = (state_127204[(2)]);
var inst_127186 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_127185__$1,endSubject);
var inst_127187 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_127188 = ["?var1",inst_127186];
var inst_127189 = cljs.core.PersistentHashMap.fromArrays(inst_127187,inst_127188);
var state_127204__$1 = (function (){var statearr_127206 = state_127204;
(statearr_127206[(8)] = inst_127189);

(statearr_127206[(7)] = inst_127185__$1);

return statearr_127206;
})();
var statearr_127207_127221 = state_127204__$1;
(statearr_127207_127221[(2)] = null);

(statearr_127207_127221[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (1))){
var state_127204__$1 = state_127204;
var statearr_127208_127222 = state_127204__$1;
(statearr_127208_127222[(2)] = null);

(statearr_127208_127222[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127204,(3),Error,null,(2));
var inst_127178 = cljs.core.vector_QMARK_(path);
var state_127204__$1 = state_127204;
if(inst_127178){
var statearr_127209_127223 = state_127204__$1;
(statearr_127209_127223[(1)] = (5));

} else {
var statearr_127210_127224 = state_127204__$1;
(statearr_127210_127224[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (6))){
var inst_127181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127182 = [path];
var inst_127183 = (new cljs.core.PersistentVector(null,1,(5),inst_127181,inst_127182,null));
var state_127204__$1 = state_127204;
var statearr_127211_127225 = state_127204__$1;
(statearr_127211_127225[(2)] = inst_127183);

(statearr_127211_127225[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (3))){
var inst_127174 = (state_127204[(2)]);
var state_127204__$1 = state_127204;
var statearr_127212_127226 = state_127204__$1;
(statearr_127212_127226[(2)] = inst_127174);


cljs.core.async.impl.ioc_helpers.process_exception(state_127204__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (2))){
var inst_127202 = (state_127204[(2)]);
var state_127204__$1 = state_127204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127204__$1,inst_127202);
} else {
if((state_val_127205 === (11))){
var inst_127197 = (state_127204[(2)]);
var inst_127198 = fluree.db.util.async.throw_err(inst_127197);
var state_127204__$1 = state_127204;
var statearr_127213_127227 = state_127204__$1;
(statearr_127213_127227[(2)] = inst_127198);


cljs.core.async.impl.ioc_helpers.process_exception(state_127204__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (9))){
var inst_127185 = (state_127204[(7)]);
var inst_127190 = (state_127204[(2)]);
var inst_127191 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127190,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_127185,endSubject], 0));
var state_127204__$1 = state_127204;
var statearr_127214_127228 = state_127204__$1;
(statearr_127214_127228[(2)] = inst_127191);


cljs.core.async.impl.ioc_helpers.process_exception(state_127204__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (5))){
var state_127204__$1 = state_127204;
var statearr_127215_127229 = state_127204__$1;
(statearr_127215_127229[(2)] = path);

(statearr_127215_127229[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127205 === (10))){
var inst_127189 = (state_127204[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127204,(9),java.lang.Exception,null,(8));
var inst_127195 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_127189);
var state_127204__$1 = state_127204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127204__$1,(11),inst_127195);
} else {
if((state_val_127205 === (8))){
var inst_127200 = (state_127204[(2)]);
var state_127204__$1 = state_127204;
var statearr_127216_127230 = state_127204__$1;
(statearr_127216_127230[(2)] = inst_127200);


cljs.core.async.impl.ioc_helpers.process_exception(state_127204__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_127217 = [null,null,null,null,null,null,null,null,null];
(statearr_127217[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__);

(statearr_127217[(1)] = (1));

return statearr_127217;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____1 = (function (state_127204){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127204);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127218){if((e127218 instanceof Object)){
var ex__109974__auto__ = e127218;
var statearr_127219_127231 = state_127204;
(statearr_127219_127231[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127204);

return cljs.core.cst$kw$recur;
} else {
throw e127218;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127232 = state_127204;
state_127204 = G__127232;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__ = function(state_127204){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____1.call(this,state_127204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127220 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127220[(6)] = c__110077__auto__);

return statearr_127220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e127233){if((e127233 instanceof java.lang.Exception)){
var e = e127233;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
} else {
throw e127233;

}
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e127234){if((e127234 instanceof java.lang.Exception)){
var e = e127234;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
} else {
throw e127234;

}
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e127235){if((e127235 instanceof java.lang.Exception)){
var e = e127235;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
} else {
throw e127235;

}
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e127236){if((e127236 instanceof java.lang.Exception)){
var e = e127236;
return fluree.db.dbfunctions.internal.function_error(e,"now");
} else {
throw e127236;

}
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127239 = arguments.length;
var i__4731__auto___127240 = (0);
while(true){
if((i__4731__auto___127240 < len__4730__auto___127239)){
args__4736__auto__.push((arguments[i__4731__auto___127240]));

var G__127241 = (i__4731__auto___127240 + (1));
i__4731__auto___127240 = G__127241;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e127238){if((e127238 instanceof java.lang.Exception)){
var e = e127238;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127238;

}
}});

fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq127237){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127237));
});

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127244 = arguments.length;
var i__4731__auto___127245 = (0);
while(true){
if((i__4731__auto___127245 < len__4730__auto___127244)){
args__4736__auto__.push((arguments[i__4731__auto___127245]));

var G__127246 = (i__4731__auto___127245 + (1));
i__4731__auto___127245 = G__127246;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e127243){if((e127243 instanceof java.lang.Exception)){
var e = e127243;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127243;

}
}});

fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq127242){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127242));
});

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127249 = arguments.length;
var i__4731__auto___127250 = (0);
while(true){
if((i__4731__auto___127250 < len__4730__auto___127249)){
args__4736__auto__.push((arguments[i__4731__auto___127250]));

var G__127251 = (i__4731__auto___127250 + (1));
i__4731__auto___127250 = G__127251;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4131__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e127248){if((e127248 instanceof java.lang.Exception)){
var e = e127248;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127248;

}
}});

fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq127247){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127247));
});

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127254 = arguments.length;
var i__4731__auto___127255 = (0);
while(true){
if((i__4731__auto___127255 < len__4730__auto___127254)){
args__4736__auto__.push((arguments[i__4731__auto___127255]));

var G__127256 = (i__4731__auto___127255 + (1));
i__4731__auto___127255 = G__127256;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e127253){if((e127253 instanceof java.lang.Exception)){
var e = e127253;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127253;

}
}});

fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq127252){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127252));
});

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e127257){if((e127257 instanceof java.lang.Exception)){
var e = e127257;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e127257;

}
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e127258){if((e127258 instanceof java.lang.Exception)){
var e = e127258;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e127258;

}
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e127259){if((e127259 instanceof java.lang.Exception)){
var e = e127259;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
} else {
throw e127259;

}
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e127260){if((e127260 instanceof java.lang.Exception)){
var e = e127260;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
} else {
throw e127260;

}
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e127261){if((e127261 instanceof java.lang.Exception)){
var e = e127261;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
} else {
throw e127261;

}
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__127267 = path;
var vec__127268 = G__127267;
var seq__127269 = cljs.core.seq(vec__127268);
var first__127270 = cljs.core.first(seq__127269);
var seq__127269__$1 = cljs.core.next(seq__127269);
var pred = first__127270;
var r = seq__127269__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__127267__$1 = G__127267;
var subjects__$1 = subjects;
while(true){
var vec__127274 = G__127267__$1;
var seq__127275 = cljs.core.seq(vec__127274);
var first__127276 = cljs.core.first(seq__127275);
var seq__127275__$1 = cljs.core.next(seq__127275);
var pred__$1 = first__127276;
var r__$1 = seq__127275__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__127267__$1,subjects__$1,vec__127274,seq__127275,first__127276,seq__127275__$1,pred__$1,r__$1,subjects__$2,G__127267,vec__127268,seq__127269,first__127270,seq__127269__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__127267__$1,subjects__$1,vec__127274,seq__127275,first__127276,seq__127275__$1,pred__$1,r__$1,subjects__$2,G__127267,vec__127268,seq__127269,first__127270,seq__127269__$1,pred,r,subjects){
return (function (p1__127262_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__127262_SHARP_,pred__$1);
});})(G__127267__$1,subjects__$1,vec__127274,seq__127275,first__127276,seq__127275__$1,pred__$1,r__$1,subjects__$2,G__127267,vec__127268,seq__127269,first__127270,seq__127269__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__127267__$1,subjects__$1,vec__127274,seq__127275,first__127276,seq__127275__$1,pred__$1,r__$1,subjects__$2,G__127267,vec__127268,seq__127269,first__127270,seq__127269__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4120__auto__ = r__$1;
if(and__4120__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4120__auto__;
}
})())){
var G__127277 = r__$1;
var G__127278 = next_subjects;
G__127267__$1 = G__127277;
subjects__$1 = G__127278;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e127263){if((e127263 instanceof java.lang.Exception)){
var e = e127263;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
} else {
throw e127263;

}
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e127279){if((e127279 instanceof java.lang.Exception)){
var e = e127279;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
} else {
throw e127279;

}
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e127280){if((e127280 instanceof java.lang.Exception)){
var e = e127280;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
} else {
throw e127280;

}
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127283 = arguments.length;
var i__4731__auto___127284 = (0);
while(true){
if((i__4731__auto___127284 < len__4730__auto___127283)){
args__4736__auto__.push((arguments[i__4731__auto___127284]));

var G__127285 = (i__4731__auto___127284 + (1));
i__4731__auto___127284 = G__127285;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e127282){if((e127282 instanceof java.lang.Exception)){
var e = e127282;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127282;

}
}});

fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq127281){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127281));
});

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e127286){if((e127286 instanceof java.lang.Exception)){
var e = e127286;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
} else {
throw e127286;

}
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___127289 = arguments.length;
var i__4731__auto___127290 = (0);
while(true){
if((i__4731__auto___127290 < len__4730__auto___127289)){
args__4736__auto__.push((arguments[i__4731__auto___127290]));

var G__127291 = (i__4731__auto___127290 + (1));
i__4731__auto___127290 = G__127291;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e127288){if((e127288 instanceof java.lang.Exception)){
var e = e127288;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
} else {
throw e127288;

}
}});

fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq127287){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq127287));
});

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e127292){if((e127292 instanceof java.lang.Exception)){
var e = e127292;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
} else {
throw e127292;

}
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127341){
var state_val_127342 = (state_127341[(1)]);
if((state_val_127342 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127341,(3),java.lang.Exception,null,(2));
var inst_127304 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127305 = typeof inst_127304 === 'string';
var state_127341__$1 = state_127341;
if(cljs.core.truth_(inst_127305)){
var statearr_127343_127363 = state_127341__$1;
(statearr_127343_127363[(1)] = (8));

} else {
var statearr_127344_127364 = state_127341__$1;
(statearr_127344_127364[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (1))){
var state_127341__$1 = state_127341;
var statearr_127345_127365 = state_127341__$1;
(statearr_127345_127365[(2)] = null);

(statearr_127345_127365[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (4))){
var inst_127300 = (state_127341[(2)]);
var state_127341__$1 = state_127341;
var statearr_127346_127366 = state_127341__$1;
(statearr_127346_127366[(2)] = inst_127300);


cljs.core.async.impl.ioc_helpers.process_exception(state_127341__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (13))){
var inst_127326 = (state_127341[(7)]);
var inst_127330 = inst_127326.o;
var state_127341__$1 = state_127341;
var statearr_127347_127367 = state_127341__$1;
(statearr_127347_127367[(2)] = inst_127330);

(statearr_127347_127367[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (6))){
var inst_127293 = (state_127341[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127341,(5),java.lang.Exception,null,(4));
var inst_127298 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127293,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_127341__$1 = state_127341;
var statearr_127348_127368 = state_127341__$1;
(statearr_127348_127368[(2)] = inst_127298);


cljs.core.async.impl.ioc_helpers.process_exception(state_127341__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (3))){
var inst_127293 = (state_127341[(2)]);
var state_127341__$1 = (function (){var statearr_127349 = state_127341;
(statearr_127349[(8)] = inst_127293);

return statearr_127349;
})();
var statearr_127350_127369 = state_127341__$1;
(statearr_127350_127369[(2)] = null);

(statearr_127350_127369[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (12))){
var state_127341__$1 = state_127341;
var statearr_127351_127370 = state_127341__$1;
(statearr_127351_127370[(2)] = null);

(statearr_127351_127370[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (2))){
var inst_127339 = (state_127341[(2)]);
var state_127341__$1 = state_127341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127341__$1,inst_127339);
} else {
if((state_val_127342 === (11))){
var inst_127326 = (state_127341[(7)]);
var inst_127322 = (state_127341[(2)]);
var inst_127323 = fluree.db.util.async.throw_err(inst_127322);
var inst_127324 = fluree.db.dbfunctions.internal.count(inst_127323);
var inst_127326__$1 = cljs.core.first(inst_127323);
var inst_127327 = (inst_127326__$1 == null);
var state_127341__$1 = (function (){var statearr_127352 = state_127341;
(statearr_127352[(9)] = inst_127324);

(statearr_127352[(7)] = inst_127326__$1);

return statearr_127352;
})();
if(cljs.core.truth_(inst_127327)){
var statearr_127353_127371 = state_127341__$1;
(statearr_127353_127371[(1)] = (12));

} else {
var statearr_127354_127372 = state_127341__$1;
(statearr_127354_127372[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (9))){
var inst_127311 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127312 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_127311);
var inst_127313 = fluree.db.dbfunctions.internal.inc(inst_127312);
var inst_127314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_127311,cljs.core.cst$kw$t,inst_127313);
var inst_127315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127316 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127317 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127318 = [inst_127316,inst_127317];
var inst_127319 = (new cljs.core.PersistentVector(null,2,(5),inst_127315,inst_127318,null));
var inst_127320 = fluree.db.dbproto._search(inst_127314,inst_127319);
var state_127341__$1 = state_127341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127341__$1,(11),inst_127320);
} else {
if((state_val_127342 === (5))){
var inst_127294 = (state_127341[(2)]);
var state_127341__$1 = state_127341;
var statearr_127355_127373 = state_127341__$1;
(statearr_127355_127373[(2)] = inst_127294);


cljs.core.async.impl.ioc_helpers.process_exception(state_127341__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (14))){
var inst_127324 = (state_127341[(9)]);
var inst_127332 = (state_127341[(2)]);
var inst_127333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127334 = [inst_127332,inst_127324];
var inst_127335 = (new cljs.core.PersistentVector(null,2,(5),inst_127333,inst_127334,null));
var state_127341__$1 = state_127341;
var statearr_127356_127374 = state_127341__$1;
(statearr_127356_127374[(2)] = inst_127335);

(statearr_127356_127374[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (10))){
var inst_127337 = (state_127341[(2)]);
var state_127341__$1 = state_127341;
var statearr_127357_127375 = state_127341__$1;
(statearr_127357_127375[(2)] = inst_127337);


cljs.core.async.impl.ioc_helpers.process_exception(state_127341__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127342 === (8))){
var inst_127307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127308 = [null,(0)];
var inst_127309 = (new cljs.core.PersistentVector(null,2,(5),inst_127307,inst_127308,null));
var state_127341__$1 = state_127341;
var statearr_127358_127376 = state_127341__$1;
(statearr_127358_127376[(2)] = inst_127309);

(statearr_127358_127376[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____0 = (function (){
var statearr_127359 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127359[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__);

(statearr_127359[(1)] = (1));

return statearr_127359;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____1 = (function (state_127341){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127341);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127360){if((e127360 instanceof Object)){
var ex__109974__auto__ = e127360;
var statearr_127361_127377 = state_127341;
(statearr_127361_127377[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127341);

return cljs.core.cst$kw$recur;
} else {
throw e127360;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127378 = state_127341;
state_127341 = G__127378;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__ = function(state_127341){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____1.call(this,state_127341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127362 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127362[(6)] = c__110077__auto__);

return statearr_127362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127424){
var state_val_127425 = (state_127424[(1)]);
if((state_val_127425 === (7))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127424,(3),java.lang.Exception,null,(2));
var inst_127393 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_127394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127396 = [null,pred_name,"?o"];
var inst_127397 = (new cljs.core.PersistentVector(null,3,(5),inst_127395,inst_127396,null));
var inst_127398 = [inst_127397];
var inst_127399 = (new cljs.core.PersistentVector(null,1,(5),inst_127394,inst_127398,null));
var inst_127400 = ["?o",inst_127399];
var inst_127401 = cljs.core.PersistentHashMap.fromArrays(inst_127393,inst_127400);
var inst_127402 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_127401);
var state_127424__$1 = state_127424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127424__$1,(8),inst_127402);
} else {
if((state_val_127425 === (1))){
var state_127424__$1 = state_127424;
var statearr_127426_127442 = state_127424__$1;
(statearr_127426_127442[(2)] = null);

(statearr_127426_127442[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (4))){
var inst_127386 = (state_127424[(2)]);
var state_127424__$1 = state_127424;
var statearr_127427_127443 = state_127424__$1;
(statearr_127427_127443[(2)] = inst_127386);


cljs.core.async.impl.ioc_helpers.process_exception(state_127424__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (6))){
var inst_127379 = (state_127424[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127424,(5),java.lang.Exception,null,(4));
var inst_127384 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127379,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var state_127424__$1 = state_127424;
var statearr_127428_127444 = state_127424__$1;
(statearr_127428_127444[(2)] = inst_127384);


cljs.core.async.impl.ioc_helpers.process_exception(state_127424__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (3))){
var inst_127379 = (state_127424[(2)]);
var state_127424__$1 = (function (){var statearr_127429 = state_127424;
(statearr_127429[(7)] = inst_127379);

return statearr_127429;
})();
var statearr_127430_127445 = state_127424__$1;
(statearr_127430_127445[(2)] = null);

(statearr_127430_127445[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (2))){
var inst_127422 = (state_127424[(2)]);
var state_127424__$1 = state_127424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127424__$1,inst_127422);
} else {
if((state_val_127425 === (11))){
var inst_127420 = (state_127424[(2)]);
var state_127424__$1 = state_127424;
var statearr_127431_127446 = state_127424__$1;
(statearr_127431_127446[(2)] = inst_127420);


cljs.core.async.impl.ioc_helpers.process_exception(state_127424__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (9))){
var inst_127407 = (state_127424[(8)]);
var inst_127406 = (state_127424[(9)]);
var inst_127411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127412 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_127406);
var inst_127413 = [inst_127412,inst_127407];
var inst_127414 = (new cljs.core.PersistentVector(null,2,(5),inst_127411,inst_127413,null));
var state_127424__$1 = state_127424;
var statearr_127432_127447 = state_127424__$1;
(statearr_127432_127447[(2)] = inst_127414);

(statearr_127432_127447[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (5))){
var inst_127380 = (state_127424[(2)]);
var state_127424__$1 = state_127424;
var statearr_127433_127448 = state_127424__$1;
(statearr_127433_127448[(2)] = inst_127380);


cljs.core.async.impl.ioc_helpers.process_exception(state_127424__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (10))){
var inst_127407 = (state_127424[(8)]);
var inst_127416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127417 = [null,inst_127407];
var inst_127418 = (new cljs.core.PersistentVector(null,2,(5),inst_127416,inst_127417,null));
var state_127424__$1 = state_127424;
var statearr_127434_127449 = state_127424__$1;
(statearr_127434_127449[(2)] = inst_127418);

(statearr_127434_127449[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127425 === (8))){
var inst_127406 = (state_127424[(9)]);
var inst_127404 = (state_127424[(2)]);
var inst_127405 = fluree.db.util.async.throw_err(inst_127404);
var inst_127406__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127405,(0),null);
var inst_127407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127405,(1),null);
var inst_127408 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_127406__$1);
var inst_127409 = cljs.core.not(inst_127408);
var state_127424__$1 = (function (){var statearr_127435 = state_127424;
(statearr_127435[(8)] = inst_127407);

(statearr_127435[(9)] = inst_127406__$1);

return statearr_127435;
})();
if(inst_127409){
var statearr_127436_127450 = state_127424__$1;
(statearr_127436_127450[(1)] = (9));

} else {
var statearr_127437_127451 = state_127424__$1;
(statearr_127437_127451[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____0 = (function (){
var statearr_127438 = [null,null,null,null,null,null,null,null,null,null];
(statearr_127438[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__);

(statearr_127438[(1)] = (1));

return statearr_127438;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____1 = (function (state_127424){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127424);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127439){if((e127439 instanceof Object)){
var ex__109974__auto__ = e127439;
var statearr_127440_127452 = state_127424;
(statearr_127440_127452[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127424);

return cljs.core.cst$kw$recur;
} else {
throw e127439;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127453 = state_127424;
state_127424 = G__127453;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__ = function(state_127424){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____1.call(this,state_127424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127441 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127441[(6)] = c__110077__auto__);

return statearr_127441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4120__auto__ = typeof email === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4120__auto__;
}
})());
}catch (e127454){if((e127454 instanceof java.lang.Exception)){
var e = e127454;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
} else {
throw e127454;

}
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__127456 = arguments.length;
switch (G__127456) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127519){
var state_val_127520 = (state_127519[(1)]);
if((state_val_127520 === (7))){
var inst_127468 = (state_127519[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127519,(3),java.lang.Exception,null,(2));
var inst_127468__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127519__$1 = (function (){var statearr_127521 = state_127519;
(statearr_127521[(7)] = inst_127468__$1);

return statearr_127521;
})();
if(cljs.core.truth_(inst_127468__$1)){
var statearr_127522_127552 = state_127519__$1;
(statearr_127522_127552[(1)] = (8));

} else {
var statearr_127523_127553 = state_127519__$1;
(statearr_127523_127553[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (20))){
var inst_127507 = (state_127519[(2)]);
var inst_127508 = fluree.db.util.async.throw_err(inst_127507);
var inst_127509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127508,(0),null);
var inst_127510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127508,(1),null);
var inst_127511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127512 = [inst_127509,inst_127510];
var inst_127513 = (new cljs.core.PersistentVector(null,2,(5),inst_127511,inst_127512,null));
var state_127519__$1 = state_127519;
var statearr_127524_127554 = state_127519__$1;
(statearr_127524_127554[(2)] = inst_127513);

(statearr_127524_127554[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (1))){
var state_127519__$1 = state_127519;
var statearr_127525_127555 = state_127519__$1;
(statearr_127525_127555[(2)] = null);

(statearr_127525_127555[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (4))){
var inst_127464 = (state_127519[(2)]);
var state_127519__$1 = state_127519;
var statearr_127526_127556 = state_127519__$1;
(statearr_127526_127556[(2)] = inst_127464);


cljs.core.async.impl.ioc_helpers.process_exception(state_127519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (15))){
var inst_127484 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127485 = fluree.db.dbfunctions.internal.get(inst_127484,cljs.core.cst$kw$_id);
var state_127519__$1 = state_127519;
var statearr_127527_127557 = state_127519__$1;
(statearr_127527_127557[(2)] = inst_127485);

(statearr_127527_127557[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (13))){
var inst_127515 = (state_127519[(2)]);
var state_127519__$1 = state_127519;
var statearr_127528_127558 = state_127519__$1;
(statearr_127528_127558[(2)] = inst_127515);


cljs.core.async.impl.ioc_helpers.process_exception(state_127519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (6))){
var inst_127457 = (state_127519[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127519,(5),java.lang.Exception,null,(4));
var inst_127462 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127457,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_127519__$1 = state_127519;
var statearr_127529_127559 = state_127519__$1;
(statearr_127529_127559[(2)] = inst_127462);


cljs.core.async.impl.ioc_helpers.process_exception(state_127519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (17))){
var inst_127489 = cljs.core.PersistentVector.EMPTY;
var inst_127490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127491 = ["*"];
var inst_127492 = (new cljs.core.PersistentVector(null,1,(5),inst_127490,inst_127491,null));
var inst_127493 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_127494 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_127492,inst_127493);
var inst_127495 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_127489,inst_127494);
var state_127519__$1 = state_127519;
var statearr_127530_127560 = state_127519__$1;
(statearr_127530_127560[(2)] = inst_127495);

(statearr_127530_127560[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (3))){
var inst_127457 = (state_127519[(2)]);
var state_127519__$1 = (function (){var statearr_127531 = state_127519;
(statearr_127531[(8)] = inst_127457);

return statearr_127531;
})();
var statearr_127532_127561 = state_127519__$1;
(statearr_127532_127561[(2)] = null);

(statearr_127532_127561[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (12))){
var inst_127481 = (state_127519[(9)]);
var inst_127480 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127481__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127519__$1 = (function (){var statearr_127533 = state_127519;
(statearr_127533[(9)] = inst_127481__$1);

(statearr_127533[(10)] = inst_127480);

return statearr_127533;
})();
if(cljs.core.truth_(inst_127481__$1)){
var statearr_127534_127562 = state_127519__$1;
(statearr_127534_127562[(1)] = (14));

} else {
var statearr_127535_127563 = state_127519__$1;
(statearr_127535_127563[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (2))){
var inst_127517 = (state_127519[(2)]);
var state_127519__$1 = state_127519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127519__$1,inst_127517);
} else {
if((state_val_127520 === (19))){
var inst_127487 = (state_127519[(11)]);
var inst_127480 = (state_127519[(10)]);
var inst_127501 = (state_127519[(2)]);
var inst_127502 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_127503 = [inst_127501,inst_127487];
var inst_127504 = cljs.core.PersistentHashMap.fromArrays(inst_127502,inst_127503);
var inst_127505 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_127480,inst_127504);
var state_127519__$1 = state_127519;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127519__$1,(20),inst_127505);
} else {
if((state_val_127520 === (11))){
var inst_127475 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127519__$1 = state_127519;
var statearr_127536_127564 = state_127519__$1;
(statearr_127536_127564[(2)] = inst_127475);

(statearr_127536_127564[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (9))){
var inst_127468 = (state_127519[(7)]);
var state_127519__$1 = state_127519;
var statearr_127537_127565 = state_127519__$1;
(statearr_127537_127565[(2)] = inst_127468);

(statearr_127537_127565[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (5))){
var inst_127458 = (state_127519[(2)]);
var state_127519__$1 = state_127519;
var statearr_127538_127566 = state_127519__$1;
(statearr_127538_127566[(2)] = inst_127458);


cljs.core.async.impl.ioc_helpers.process_exception(state_127519__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (14))){
var inst_127481 = (state_127519[(9)]);
var state_127519__$1 = state_127519;
var statearr_127539_127567 = state_127519__$1;
(statearr_127539_127567[(2)] = inst_127481);

(statearr_127539_127567[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (16))){
var inst_127487 = (state_127519[(2)]);
var state_127519__$1 = (function (){var statearr_127540 = state_127519;
(statearr_127540[(11)] = inst_127487);

return statearr_127540;
})();
if(cljs.core.truth_(additional_params)){
var statearr_127541_127568 = state_127519__$1;
(statearr_127541_127568[(1)] = (17));

} else {
var statearr_127542_127569 = state_127519__$1;
(statearr_127542_127569[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (10))){
var inst_127473 = (state_127519[(2)]);
var state_127519__$1 = state_127519;
if(cljs.core.truth_(inst_127473)){
var statearr_127543_127570 = state_127519__$1;
(statearr_127543_127570[(1)] = (11));

} else {
var statearr_127544_127571 = state_127519__$1;
(statearr_127544_127571[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (18))){
var inst_127497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127498 = ["*"];
var inst_127499 = (new cljs.core.PersistentVector(null,1,(5),inst_127497,inst_127498,null));
var state_127519__$1 = state_127519;
var statearr_127545_127572 = state_127519__$1;
(statearr_127545_127572[(2)] = inst_127499);

(statearr_127545_127572[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127520 === (8))){
var inst_127470 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_127519__$1 = state_127519;
var statearr_127546_127573 = state_127519__$1;
(statearr_127546_127573[(2)] = inst_127470);

(statearr_127546_127573[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__109971__auto____0 = (function (){
var statearr_127547 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_127547[(0)] = fluree$db$dbfunctions$internal$state_machine__109971__auto__);

(statearr_127547[(1)] = (1));

return statearr_127547;
});
var fluree$db$dbfunctions$internal$state_machine__109971__auto____1 = (function (state_127519){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127519);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127548){if((e127548 instanceof Object)){
var ex__109974__auto__ = e127548;
var statearr_127549_127574 = state_127519;
(statearr_127549_127574[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127519);

return cljs.core.cst$kw$recur;
} else {
throw e127548;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127575 = state_127519;
state_127519 = G__127575;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__109971__auto__ = function(state_127519){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____1.call(this,state_127519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127550 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127550[(6)] = c__110077__auto__);

return statearr_127550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2;

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__127577 = arguments.length;
switch (G__127577) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127617){
var state_val_127618 = (state_127617[(1)]);
if((state_val_127618 === (1))){
var state_127617__$1 = state_127617;
var statearr_127619_127632 = state_127617__$1;
(statearr_127619_127632[(2)] = null);

(statearr_127619_127632[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127618 === (2))){
var inst_127615 = (state_127617[(2)]);
var state_127617__$1 = state_127617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127617__$1,inst_127615);
} else {
if((state_val_127618 === (3))){
var inst_127578 = (state_127617[(2)]);
var inst_127579 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127578,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_127617__$1 = state_127617;
var statearr_127620_127633 = state_127617__$1;
(statearr_127620_127633[(2)] = inst_127579);


cljs.core.async.impl.ioc_helpers.process_exception(state_127617__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127618 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127617,(3),java.lang.Exception,null,(2));
var inst_127586 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127587 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_127617__$1 = (function (){var statearr_127621 = state_127617;
(statearr_127621[(7)] = inst_127586);

(statearr_127621[(8)] = inst_127587);

return statearr_127621;
})();
if(cljs.core.truth_(additional_params)){
var statearr_127622_127634 = state_127617__$1;
(statearr_127622_127634[(1)] = (5));

} else {
var statearr_127623_127635 = state_127617__$1;
(statearr_127623_127635[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_127618 === (5))){
var inst_127589 = cljs.core.PersistentVector.EMPTY;
var inst_127590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127591 = ["*"];
var inst_127592 = (new cljs.core.PersistentVector(null,1,(5),inst_127590,inst_127591,null));
var inst_127593 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_127594 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_127592,inst_127593);
var inst_127595 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_127589,inst_127594);
var state_127617__$1 = state_127617;
var statearr_127624_127636 = state_127617__$1;
(statearr_127624_127636[(2)] = inst_127595);

(statearr_127624_127636[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127618 === (6))){
var inst_127597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127598 = ["*"];
var inst_127599 = (new cljs.core.PersistentVector(null,1,(5),inst_127597,inst_127598,null));
var state_127617__$1 = state_127617;
var statearr_127625_127637 = state_127617__$1;
(statearr_127625_127637[(2)] = inst_127599);

(statearr_127625_127637[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127618 === (7))){
var inst_127586 = (state_127617[(7)]);
var inst_127587 = (state_127617[(8)]);
var inst_127601 = (state_127617[(2)]);
var inst_127602 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_127603 = [inst_127601,inst_127587];
var inst_127604 = cljs.core.PersistentHashMap.fromArrays(inst_127602,inst_127603);
var inst_127605 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_127586,inst_127604);
var state_127617__$1 = state_127617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127617__$1,(8),inst_127605);
} else {
if((state_val_127618 === (8))){
var inst_127607 = (state_127617[(2)]);
var inst_127608 = fluree.db.util.async.throw_err(inst_127607);
var inst_127609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127608,(0),null);
var inst_127610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127608,(1),null);
var inst_127611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127612 = [inst_127609,inst_127610];
var inst_127613 = (new cljs.core.PersistentVector(null,2,(5),inst_127611,inst_127612,null));
var state_127617__$1 = state_127617;
var statearr_127626_127638 = state_127617__$1;
(statearr_127626_127638[(2)] = inst_127613);


cljs.core.async.impl.ioc_helpers.process_exception(state_127617__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__109971__auto____0 = (function (){
var statearr_127627 = [null,null,null,null,null,null,null,null,null];
(statearr_127627[(0)] = fluree$db$dbfunctions$internal$state_machine__109971__auto__);

(statearr_127627[(1)] = (1));

return statearr_127627;
});
var fluree$db$dbfunctions$internal$state_machine__109971__auto____1 = (function (state_127617){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127617);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127628){if((e127628 instanceof Object)){
var ex__109974__auto__ = e127628;
var statearr_127629_127639 = state_127617;
(statearr_127629_127639[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127617);

return cljs.core.cst$kw$recur;
} else {
throw e127628;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127640 = state_127617;
state_127617 = G__127640;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__109971__auto__ = function(state_127617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__109971__auto____1.call(this,state_127617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127630 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127630[(6)] = c__110077__auto__);

return statearr_127630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2;

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127680){
var state_val_127681 = (state_127680[(1)]);
if((state_val_127681 === (1))){
var state_127680__$1 = state_127680;
var statearr_127682_127689 = state_127680__$1;
(statearr_127682_127689[(2)] = null);

(statearr_127682_127689[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127681 === (2))){
var inst_127678 = (state_127680[(2)]);
var state_127680__$1 = state_127680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127680__$1,inst_127678);
} else {
if((state_val_127681 === (3))){
var inst_127641 = (state_127680[(2)]);
var inst_127642 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_127641,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_127680__$1 = state_127680;
var statearr_127683_127690 = state_127680__$1;
(statearr_127683_127690[(2)] = inst_127642);


cljs.core.async.impl.ioc_helpers.process_exception(state_127680__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127681 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127680,(3),java.lang.Exception,null,(2));
var inst_127649 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from];
var inst_127650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127651 = ["_user/_auth"];
var inst_127652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127653 = ["*"];
var inst_127654 = (new cljs.core.PersistentVector(null,1,(5),inst_127652,inst_127653,null));
var inst_127655 = [inst_127654];
var inst_127656 = cljs.core.PersistentHashMap.fromArrays(inst_127651,inst_127655);
var inst_127657 = [inst_127656];
var inst_127658 = (new cljs.core.PersistentVector(null,1,(5),inst_127650,inst_127657,null));
var inst_127659 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127660 = [inst_127658,inst_127659];
var inst_127661 = cljs.core.PersistentHashMap.fromArrays(inst_127649,inst_127660);
var inst_127662 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127663 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_127662,inst_127661);
var state_127680__$1 = state_127680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127680__$1,(5),inst_127663);
} else {
if((state_val_127681 === (5))){
var inst_127665 = (state_127680[(2)]);
var inst_127666 = fluree.db.util.async.throw_err(inst_127665);
var inst_127667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127666,(0),null);
var inst_127668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_127666,(1),null);
var inst_127669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127670 = ["_user/_auth","_id"];
var inst_127671 = (new cljs.core.PersistentVector(null,2,(5),inst_127669,inst_127670,null));
var inst_127672 = fluree.db.dbfunctions.internal.get_in(inst_127667,inst_127671);
var inst_127673 = cljs.core.first(inst_127672);
var inst_127674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_127675 = [inst_127673,inst_127668];
var inst_127676 = (new cljs.core.PersistentVector(null,2,(5),inst_127674,inst_127675,null));
var state_127680__$1 = state_127680;
var statearr_127684_127691 = state_127680__$1;
(statearr_127684_127691[(2)] = inst_127676);


cljs.core.async.impl.ioc_helpers.process_exception(state_127680__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____0 = (function (){
var statearr_127685 = [null,null,null,null,null,null,null];
(statearr_127685[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__);

(statearr_127685[(1)] = (1));

return statearr_127685;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____1 = (function (state_127680){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127680);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127686){if((e127686 instanceof Object)){
var ex__109974__auto__ = e127686;
var statearr_127687_127692 = state_127680;
(statearr_127687_127692[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127680);

return cljs.core.cst$kw$recur;
} else {
throw e127686;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127693 = state_127680;
state_127680 = G__127693;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__ = function(state_127680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____1.call(this,state_127680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127688 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127688[(6)] = c__110077__auto__);

return statearr_127688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_127707){
var state_val_127708 = (state_127707[(1)]);
if((state_val_127708 === (1))){
var state_127707__$1 = state_127707;
var statearr_127709_127716 = state_127707__$1;
(statearr_127709_127716[(2)] = null);

(statearr_127709_127716[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_127708 === (2))){
var inst_127705 = (state_127707[(2)]);
var state_127707__$1 = state_127707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_127707__$1,inst_127705);
} else {
if((state_val_127708 === (3))){
var inst_127694 = (state_127707[(2)]);
var state_127707__$1 = state_127707;
var statearr_127710_127717 = state_127707__$1;
(statearr_127710_127717[(2)] = inst_127694);


cljs.core.async.impl.ioc_helpers.process_exception(state_127707__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_127708 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_127707,(3),Error,null,(2));
var inst_127698 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127699 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_127700 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_127699,inst_127698);
var state_127707__$1 = state_127707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_127707__$1,(5),inst_127700);
} else {
if((state_val_127708 === (5))){
var inst_127702 = (state_127707[(2)]);
var inst_127703 = fluree.db.util.async.throw_err(inst_127702);
var state_127707__$1 = state_127707;
var statearr_127711_127718 = state_127707__$1;
(statearr_127711_127718[(2)] = inst_127703);


cljs.core.async.impl.ioc_helpers.process_exception(state_127707__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____0 = (function (){
var statearr_127712 = [null,null,null,null,null,null,null];
(statearr_127712[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__);

(statearr_127712[(1)] = (1));

return statearr_127712;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____1 = (function (state_127707){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_127707);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e127713){if((e127713 instanceof Object)){
var ex__109974__auto__ = e127713;
var statearr_127714_127719 = state_127707;
(statearr_127714_127719[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_127707);

return cljs.core.cst$kw$recur;
} else {
throw e127713;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__127720 = state_127707;
state_127707 = G__127720;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__ = function(state_127707){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____1.call(this,state_127707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_127715 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_127715[(6)] = c__110077__auto__);

return statearr_127715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__127721_SHARP_){
return p1__127721_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (trueF){
return (function (p1__127722_SHARP_){
return p1__127722_SHARP_.o;
});})(trueF))
,trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e127723){if((e127723 instanceof java.lang.Exception)){
var e = e127723;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
} else {
throw e127723;

}
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__127724_SHARP_){
return p1__127724_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (falseF){
return (function (p1__127725_SHARP_){
return p1__127725_SHARP_.o;
});})(falseF))
,falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e127726){if((e127726 instanceof java.lang.Exception)){
var e = e127726;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
} else {
throw e127726;

}
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__127728 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__127728);
})() | (0));
return num;
}catch (e127727){if((e127727 instanceof java.lang.Exception)){
var e = e127727;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
} else {
throw e127727;

}
}});
