// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__120384 = null;
var G__120384__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__120384__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__120384__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__120384 = function(result,flake){
switch(arguments.length){
case 0:
return G__120384__0.call(this);
case 1:
return G__120384__1.call(this,result);
case 2:
return G__120384__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__120384.cljs$core$IFn$_invoke$arity$0 = G__120384__0;
G__120384.cljs$core$IFn$_invoke$arity$1 = G__120384__1;
G__120384.cljs$core$IFn$_invoke$arity$2 = G__120384__2;
return G__120384;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__120385 = null;
var G__120385__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__120385__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__120385__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__120385 = function(result,flakes){
switch(arguments.length){
case 0:
return G__120385__0.call(this);
case 1:
return G__120385__1.call(this,result);
case 2:
return G__120385__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__120385.cljs$core$IFn$_invoke$arity$0 = G__120385__0;
G__120385.cljs$core$IFn$_invoke$arity$1 = G__120385__1;
G__120385.cljs$core$IFn$_invoke$arity$2 = G__120385__2;
return G__120385;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4120__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__120387 = res;
var G__120387__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(((function (G__120387){
return (function (p1__120386_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__120386_SHARP_,sortPred);
});})(G__120387))
,fluree.db.query.fql.compare_fn,G__120387):G__120387);
var G__120387__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__120387__$1):G__120387__$1);
var G__120387__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__120387__$2):G__120387__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__120387__$3);
} else {
return G__120387__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__120389 = arguments.length;
switch (G__120389) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_120688){
var state_val_120689 = (state_120688[(1)]);
if((state_val_120689 === (65))){
var state_120688__$1 = state_120688;
if(cljs.core.truth_(componentFollow_QMARK_)){
var statearr_120690_120850 = state_120688__$1;
(statearr_120690_120850[(1)] = (71));

} else {
var statearr_120691_120851 = state_120688__$1;
(statearr_120691_120851[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (70))){
var inst_120417 = (state_120688[(7)]);
var inst_120555 = (state_120688[(2)]);
var inst_120556 = fluree.db.util.async.throw_err(inst_120555);
var inst_120557 = cljs.core._deref(cache);
var inst_120558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120559 = flake.o;
var inst_120560 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_120417);
var inst_120561 = [inst_120559,inst_120560];
var inst_120562 = (new cljs.core.PersistentVector(null,2,(5),inst_120558,inst_120561,null));
var inst_120563 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_120557,inst_120562,inst_120556);
var inst_120564 = cljs.core._vreset_BANG_(cache,inst_120563);
var state_120688__$1 = (function (){var statearr_120692 = state_120688;
(statearr_120692[(8)] = inst_120564);

return statearr_120692;
})();
var statearr_120693_120852 = state_120688__$1;
(statearr_120693_120852[(2)] = inst_120556);

(statearr_120693_120852[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (62))){
var inst_120526 = (state_120688[(9)]);
var state_120688__$1 = state_120688;
var statearr_120694_120853 = state_120688__$1;
(statearr_120694_120853[(2)] = inst_120526);

(statearr_120694_120853[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (74))){
var inst_120417 = (state_120688[(7)]);
var inst_120576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120577 = flake.o;
var inst_120578 = [inst_120577];
var inst_120579 = (new cljs.core.PersistentVector(null,1,(5),inst_120576,inst_120578,null));
var inst_120580 = [cljs.core.cst$kw$limit];
var inst_120581 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_120417);
var inst_120582 = [inst_120581];
var inst_120583 = cljs.core.PersistentHashMap.fromArrays(inst_120580,inst_120582);
var inst_120584 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_120579,inst_120583);
var state_120688__$1 = state_120688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120688__$1,(77),inst_120584);
} else {
if((state_val_120689 === (7))){
var inst_120404 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120404)){
var statearr_120695_120854 = state_120688__$1;
(statearr_120695_120854[(1)] = (8));

} else {
var statearr_120696_120855 = state_120688__$1;
(statearr_120696_120855[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (59))){
var inst_120520 = (state_120688[(10)]);
var state_120688__$1 = state_120688;
var statearr_120697_120856 = state_120688__$1;
(statearr_120697_120856[(2)] = inst_120520);

(statearr_120697_120856[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (86))){
var inst_120605 = (state_120688[(11)]);
var state_120688__$1 = state_120688;
var statearr_120698_120857 = state_120688__$1;
(statearr_120698_120857[(2)] = inst_120605);

(statearr_120698_120857[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (20))){
var inst_120417 = (state_120688[(7)]);
var inst_120433 = inst_120417.cljs$lang$protocol_mask$partition0$;
var inst_120434 = (inst_120433 & (64));
var inst_120435 = inst_120417.cljs$core$ISeq$;
var inst_120436 = (cljs.core.PROTOCOL_SENTINEL === inst_120435);
var inst_120437 = ((inst_120434) || (inst_120436));
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120437)){
var statearr_120699_120858 = state_120688__$1;
(statearr_120699_120858[(1)] = (23));

} else {
var statearr_120700_120859 = state_120688__$1;
(statearr_120700_120859[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (72))){
var state_120688__$1 = state_120688;
var statearr_120701_120860 = state_120688__$1;
(statearr_120701_120860[(2)] = componentFollow_QMARK_);

(statearr_120701_120860[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (58))){
var inst_120520 = (state_120688[(10)]);
var inst_120522 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_120523 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_120522,inst_120520);
var state_120688__$1 = state_120688;
var statearr_120702_120861 = state_120688__$1;
(statearr_120702_120861[(2)] = inst_120523);

(statearr_120702_120861[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (60))){
var inst_120526 = (state_120688[(2)]);
var state_120688__$1 = (function (){var statearr_120703 = state_120688;
(statearr_120703[(9)] = inst_120526);

return statearr_120703;
})();
var statearr_120704_120862 = state_120688__$1;
(statearr_120704_120862[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (27))){
var inst_120417 = (state_120688[(7)]);
var state_120688__$1 = state_120688;
var statearr_120706_120863 = state_120688__$1;
(statearr_120706_120863[(2)] = inst_120417);

(statearr_120706_120863[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (1))){
var state_120688__$1 = state_120688;
var statearr_120707_120864 = state_120688__$1;
(statearr_120707_120864[(2)] = null);

(statearr_120707_120864[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (69))){
var inst_120541 = (state_120688[(12)]);
var inst_120566 = (state_120688[(2)]);
var inst_120567 = [inst_120566,offset_map];
var inst_120568 = (new cljs.core.PersistentVector(null,2,(5),inst_120541,inst_120567,null));
var state_120688__$1 = state_120688;
var statearr_120708_120865 = state_120688__$1;
(statearr_120708_120865[(2)] = inst_120568);

(statearr_120708_120865[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (101))){
var state_120688__$1 = state_120688;
var statearr_120709_120866 = state_120688__$1;
(statearr_120709_120866[(1)] = (103));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (24))){
var state_120688__$1 = state_120688;
var statearr_120711_120867 = state_120688__$1;
(statearr_120711_120867[(2)] = false);

(statearr_120711_120867[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (102))){
var inst_120682 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120712_120868 = state_120688__$1;
(statearr_120712_120868[(2)] = inst_120682);

(statearr_120712_120868[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (55))){
var inst_120644 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120713_120869 = state_120688__$1;
(statearr_120713_120869[(2)] = inst_120644);

(statearr_120713_120869[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (85))){
var inst_120449 = (state_120688[(13)]);
var inst_120451 = (state_120688[(14)]);
var inst_120455 = (state_120688[(15)]);
var inst_120452 = (state_120688[(16)]);
var inst_120454 = (state_120688[(17)]);
var inst_120411 = (state_120688[(18)]);
var inst_120417 = (state_120688[(7)]);
var inst_120428 = (state_120688[(19)]);
var inst_120587 = (state_120688[(20)]);
var inst_120605 = (state_120688[(11)]);
var inst_120450 = (state_120688[(21)]);
var inst_120453 = (state_120688[(22)]);
var inst_120607 = (function (){var p = inst_120455;
var pred_spec__$1 = inst_120411;
var orderBy = inst_120453;
var children = inst_120587;
var multi_QMARK_ = inst_120450;
var G__120599 = inst_120605;
var limit = inst_120452;
var offset = inst_120454;
var map__120394 = inst_120449;
var k = inst_120428;
var pred_spec_SINGLEQUOTE_ = inst_120417;
var ref_QMARK_ = inst_120451;
return ((function (p,pred_spec__$1,orderBy,children,multi_QMARK_,G__120599,limit,offset,map__120394,k,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_120449,inst_120451,inst_120455,inst_120452,inst_120454,inst_120411,inst_120417,inst_120428,inst_120587,inst_120605,inst_120450,inst_120453,state_val_120689,c__110077__auto__){
return (function (n){
var G__120714 = db;
var G__120715 = cache;
var G__120716 = fuel;
var G__120717 = max_fuel;
var G__120718 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__120719 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__120714,G__120715,G__120716,G__120717,G__120718,G__120719) : fluree.db.query.fql.flakes__GT_res.call(null,G__120714,G__120715,G__120716,G__120717,G__120718,G__120719));
});
;})(p,pred_spec__$1,orderBy,children,multi_QMARK_,G__120599,limit,offset,map__120394,k,pred_spec_SINGLEQUOTE_,ref_QMARK_,inst_120449,inst_120451,inst_120455,inst_120452,inst_120454,inst_120411,inst_120417,inst_120428,inst_120587,inst_120605,inst_120450,inst_120453,state_val_120689,c__110077__auto__))
})();
var inst_120608 = (inst_120607.cljs$core$IFn$_invoke$arity$1 ? inst_120607.cljs$core$IFn$_invoke$arity$1(inst_120605) : inst_120607.call(null,inst_120605));
var state_120688__$1 = state_120688;
var statearr_120720_120870 = state_120688__$1;
(statearr_120720_120870[(2)] = inst_120608);

(statearr_120720_120870[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (39))){
var inst_120455 = (state_120688[(15)]);
var inst_120454 = (state_120688[(17)]);
var inst_120474 = (inst_120454 - (1));
var inst_120475 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_120455,inst_120474);
var state_120688__$1 = state_120688;
var statearr_120721_120871 = state_120688__$1;
(statearr_120721_120871[(2)] = inst_120475);

(statearr_120721_120871[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (88))){
var inst_120621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120622 = ["_id"];
var inst_120623 = flake.o;
var inst_120624 = [inst_120623];
var inst_120625 = cljs.core.PersistentHashMap.fromArrays(inst_120622,inst_120624);
var inst_120626 = [inst_120625,offset_map];
var inst_120627 = (new cljs.core.PersistentVector(null,2,(5),inst_120621,inst_120626,null));
var state_120688__$1 = state_120688;
var statearr_120722_120872 = state_120688__$1;
(statearr_120722_120872[(2)] = inst_120627);

(statearr_120722_120872[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (46))){
var inst_120646 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120723_120873 = state_120688__$1;
(statearr_120723_120873[(2)] = inst_120646);

(statearr_120723_120873[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (4))){
var inst_120398 = (state_120688[(23)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_120688,(3),Error,null,(2));
var inst_120398__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_120688__$1 = (function (){var statearr_120724 = state_120688;
(statearr_120724[(23)] = inst_120398__$1);

return statearr_120724;
})();
if(cljs.core.truth_(inst_120398__$1)){
var statearr_120725_120874 = state_120688__$1;
(statearr_120725_120874[(1)] = (5));

} else {
var statearr_120726_120875 = state_120688__$1;
(statearr_120726_120875[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (77))){
var inst_120587 = (state_120688[(20)]);
var inst_120586 = (state_120688[(2)]);
var inst_120587__$1 = fluree.db.util.async.throw_err(inst_120586);
var inst_120588 = cljs.core.empty_QMARK_(inst_120587__$1);
var state_120688__$1 = (function (){var statearr_120727 = state_120688;
(statearr_120727[(20)] = inst_120587__$1);

return statearr_120727;
})();
if(inst_120588){
var statearr_120728_120876 = state_120688__$1;
(statearr_120728_120876[(1)] = (78));

} else {
var statearr_120729_120877 = state_120688__$1;
(statearr_120729_120877[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (95))){
var inst_120652 = (state_120688[(24)]);
var state_120688__$1 = state_120688;
var statearr_120730_120878 = state_120688__$1;
(statearr_120730_120878[(2)] = inst_120652);

(statearr_120730_120878[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (54))){
var inst_120417 = (state_120688[(7)]);
var inst_120539 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120539)){
var statearr_120731_120879 = state_120688__$1;
(statearr_120731_120879[(1)] = (64));

} else {
var statearr_120732_120880 = state_120688__$1;
(statearr_120732_120880[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (92))){
var state_120688__$1 = state_120688;
var statearr_120733_120881 = state_120688__$1;
(statearr_120733_120881[(2)] = null);

(statearr_120733_120881[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (104))){
var state_120688__$1 = state_120688;
var statearr_120734_120882 = state_120688__$1;
(statearr_120734_120882[(2)] = null);

(statearr_120734_120882[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (15))){
var inst_120421 = (state_120688[(25)]);
var inst_120417 = (state_120688[(7)]);
var inst_120421__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = (function (){var statearr_120735 = state_120688;
(statearr_120735[(25)] = inst_120421__$1);

return statearr_120735;
})();
if(cljs.core.truth_(inst_120421__$1)){
var statearr_120736_120883 = state_120688__$1;
(statearr_120736_120883[(1)] = (17));

} else {
var statearr_120737_120884 = state_120688__$1;
(statearr_120737_120884[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (48))){
var inst_120495 = (state_120688[(26)]);
var state_120688__$1 = state_120688;
var statearr_120738_120885 = state_120688__$1;
(statearr_120738_120885[(2)] = inst_120495);

(statearr_120738_120885[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (50))){
var inst_120497 = (state_120688[(27)]);
var state_120688__$1 = state_120688;
var statearr_120739_120886 = state_120688__$1;
(statearr_120739_120886[(2)] = inst_120497);

(statearr_120739_120886[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (75))){
var inst_120451 = (state_120688[(14)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120451)){
var statearr_120740_120887 = state_120688__$1;
(statearr_120740_120887[(1)] = (88));

} else {
var statearr_120741_120888 = state_120688__$1;
(statearr_120741_120888[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (99))){
var inst_120684 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120742_120889 = state_120688__$1;
(statearr_120742_120889[(2)] = inst_120684);


cljs.core.async.impl.ioc_helpers.process_exception(state_120688__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (21))){
var state_120688__$1 = state_120688;
var statearr_120743_120890 = state_120688__$1;
(statearr_120743_120890[(2)] = false);

(statearr_120743_120890[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (31))){
var inst_120467 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120467)){
var statearr_120744_120891 = state_120688__$1;
(statearr_120744_120891[(1)] = (35));

} else {
var statearr_120745_120892 = state_120688__$1;
(statearr_120745_120892[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (32))){
var inst_120455 = (state_120688[(15)]);
var inst_120454 = (state_120688[(17)]);
var inst_120458 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_120454);
var inst_120459 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_120455);
var inst_120460 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_120459);
var inst_120461 = ((inst_120458) && (inst_120460));
var state_120688__$1 = state_120688;
var statearr_120746_120893 = state_120688__$1;
(statearr_120746_120893[(2)] = inst_120461);

(statearr_120746_120893[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (40))){
var inst_120469 = (state_120688[(28)]);
var inst_120477 = (state_120688[(2)]);
var inst_120478 = [null,inst_120477];
var inst_120479 = (new cljs.core.PersistentVector(null,2,(5),inst_120469,inst_120478,null));
var state_120688__$1 = state_120688;
var statearr_120747_120894 = state_120688__$1;
(statearr_120747_120894[(2)] = inst_120479);

(statearr_120747_120894[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (91))){
var inst_120630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120631 = flake.o;
var inst_120632 = [inst_120631,offset_map];
var inst_120633 = (new cljs.core.PersistentVector(null,2,(5),inst_120630,inst_120632,null));
var state_120688__$1 = state_120688;
var statearr_120748_120895 = state_120688__$1;
(statearr_120748_120895[(2)] = inst_120633);

(statearr_120748_120895[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (56))){
var inst_120511 = (state_120688[(29)]);
var inst_120534 = (state_120688[(2)]);
var inst_120535 = fluree.db.util.async.throw_err(inst_120534);
var inst_120536 = [inst_120535,offset_map];
var inst_120537 = (new cljs.core.PersistentVector(null,2,(5),inst_120511,inst_120536,null));
var state_120688__$1 = state_120688;
var statearr_120749_120896 = state_120688__$1;
(statearr_120749_120896[(2)] = inst_120537);

(statearr_120749_120896[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (33))){
var inst_120454 = (state_120688[(17)]);
var state_120688__$1 = state_120688;
var statearr_120750_120897 = state_120688__$1;
(statearr_120750_120897[(2)] = inst_120454);

(statearr_120750_120897[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (13))){
var inst_120418 = (state_120688[(30)]);
var inst_120417 = (state_120688[(7)]);
var inst_120417__$1 = (state_120688[(2)]);
var inst_120418__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_120417__$1);
var state_120688__$1 = (function (){var statearr_120751 = state_120688;
(statearr_120751[(30)] = inst_120418__$1);

(statearr_120751[(7)] = inst_120417__$1);

return statearr_120751;
})();
if(cljs.core.truth_(inst_120418__$1)){
var statearr_120752_120898 = state_120688__$1;
(statearr_120752_120898[(1)] = (14));

} else {
var statearr_120753_120899 = state_120688__$1;
(statearr_120753_120899[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (22))){
var inst_120444 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120444)){
var statearr_120754_120900 = state_120688__$1;
(statearr_120754_120900[(1)] = (26));

} else {
var statearr_120755_120901 = state_120688__$1;
(statearr_120755_120901[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (90))){
var inst_120638 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120756_120902 = state_120688__$1;
(statearr_120756_120902[(2)] = inst_120638);

(statearr_120756_120902[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (36))){
var inst_120450 = (state_120688[(21)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120450)){
var statearr_120757_120903 = state_120688__$1;
(statearr_120757_120903[(1)] = (41));

} else {
var statearr_120758_120904 = state_120688__$1;
(statearr_120758_120904[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (41))){
var inst_120452 = (state_120688[(16)]);
var inst_120428 = (state_120688[(19)]);
var inst_120453 = (state_120688[(22)]);
var inst_120482 = cljs.core.not(inst_120453);
var inst_120483 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_120428);
var inst_120484 = cljs.core.count(inst_120483);
var inst_120485 = (inst_120484 >= inst_120452);
var inst_120486 = ((inst_120482) && (inst_120485));
var state_120688__$1 = state_120688;
var statearr_120759_120905 = state_120688__$1;
(statearr_120759_120905[(2)] = inst_120486);

(statearr_120759_120905[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (89))){
var state_120688__$1 = state_120688;
var statearr_120760_120906 = state_120688__$1;
(statearr_120760_120906[(1)] = (91));



return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (100))){
var inst_120649 = (state_120688[(31)]);
var inst_120650 = (state_120688[(32)]);
var inst_120428 = (state_120688[(19)]);
var inst_120669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_120428,inst_120649);
var inst_120671 = [inst_120670,inst_120650];
var inst_120672 = (new cljs.core.PersistentVector(null,2,(5),inst_120669,inst_120671,null));
var state_120688__$1 = state_120688;
var statearr_120762_120907 = state_120688__$1;
(statearr_120762_120907[(2)] = inst_120672);

(statearr_120762_120907[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (43))){
var inst_120489 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120489)){
var statearr_120763_120908 = state_120688__$1;
(statearr_120763_120908[(1)] = (44));

} else {
var statearr_120764_120909 = state_120688__$1;
(statearr_120764_120909[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (61))){
var inst_120449 = (state_120688[(13)]);
var inst_120451 = (state_120688[(14)]);
var inst_120510 = (state_120688[(33)]);
var inst_120455 = (state_120688[(15)]);
var inst_120452 = (state_120688[(16)]);
var inst_120454 = (state_120688[(17)]);
var inst_120411 = (state_120688[(18)]);
var inst_120417 = (state_120688[(7)]);
var inst_120428 = (state_120688[(19)]);
var inst_120526 = (state_120688[(9)]);
var inst_120450 = (state_120688[(21)]);
var inst_120453 = (state_120688[(22)]);
var inst_120528 = (function (){var p = inst_120455;
var pred_spec__$1 = inst_120411;
var orderBy = inst_120453;
var nested_select_spec = inst_120510;
var multi_QMARK_ = inst_120450;
var limit = inst_120452;
var offset = inst_120454;
var map__120394 = inst_120449;
var k = inst_120428;
var pred_spec_SINGLEQUOTE_ = inst_120417;
var G__120512 = inst_120526;
var ref_QMARK_ = inst_120451;
return ((function (p,pred_spec__$1,orderBy,nested_select_spec,multi_QMARK_,limit,offset,map__120394,k,pred_spec_SINGLEQUOTE_,G__120512,ref_QMARK_,inst_120449,inst_120451,inst_120510,inst_120455,inst_120452,inst_120454,inst_120411,inst_120417,inst_120428,inst_120526,inst_120450,inst_120453,state_val_120689,c__110077__auto__){
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
;})(p,pred_spec__$1,orderBy,nested_select_spec,multi_QMARK_,limit,offset,map__120394,k,pred_spec_SINGLEQUOTE_,G__120512,ref_QMARK_,inst_120449,inst_120451,inst_120510,inst_120455,inst_120452,inst_120454,inst_120411,inst_120417,inst_120428,inst_120526,inst_120450,inst_120453,state_val_120689,c__110077__auto__))
})();
var inst_120529 = (inst_120528.cljs$core$IFn$_invoke$arity$1 ? inst_120528.cljs$core$IFn$_invoke$arity$1(inst_120526) : inst_120528.call(null,inst_120526));
var state_120688__$1 = state_120688;
var statearr_120765_120910 = state_120688__$1;
(statearr_120765_120910[(2)] = inst_120529);

(statearr_120765_120910[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (29))){
var inst_120454 = (state_120688[(17)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120454)){
var statearr_120766_120911 = state_120688__$1;
(statearr_120766_120911[(1)] = (32));

} else {
var statearr_120767_120912 = state_120688__$1;
(statearr_120767_120912[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (44))){
var inst_120491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120492 = [null,offset_map];
var inst_120493 = (new cljs.core.PersistentVector(null,2,(5),inst_120491,inst_120492,null));
var state_120688__$1 = state_120688;
var statearr_120768_120913 = state_120688__$1;
(statearr_120768_120913[(2)] = inst_120493);

(statearr_120768_120913[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (93))){
var inst_120636 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120769_120914 = state_120688__$1;
(statearr_120769_120914[(2)] = inst_120636);

(statearr_120769_120914[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (6))){
var inst_120398 = (state_120688[(23)]);
var state_120688__$1 = state_120688;
var statearr_120770_120915 = state_120688__$1;
(statearr_120770_120915[(2)] = inst_120398);

(statearr_120770_120915[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (28))){
var inst_120449 = (state_120688[(13)]);
var inst_120450 = (state_120688[(21)]);
var inst_120449__$1 = (state_120688[(2)]);
var inst_120450__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_120451 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_120452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$limit);
var inst_120453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$orderBy);
var inst_120454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$offset);
var inst_120455 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120449__$1,cljs.core.cst$kw$p);
var state_120688__$1 = (function (){var statearr_120771 = state_120688;
(statearr_120771[(13)] = inst_120449__$1);

(statearr_120771[(14)] = inst_120451);

(statearr_120771[(15)] = inst_120455);

(statearr_120771[(16)] = inst_120452);

(statearr_120771[(17)] = inst_120454);

(statearr_120771[(21)] = inst_120450__$1);

(statearr_120771[(22)] = inst_120453);

return statearr_120771;
})();
if(cljs.core.truth_(inst_120450__$1)){
var statearr_120772_120916 = state_120688__$1;
(statearr_120772_120916[(1)] = (29));

} else {
var statearr_120773_120917 = state_120688__$1;
(statearr_120773_120917[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (64))){
var inst_120417 = (state_120688[(7)]);
var inst_120548 = (state_120688[(34)]);
var inst_120541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120542 = cljs.core.deref(cache);
var inst_120543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120544 = flake.o;
var inst_120545 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_120417);
var inst_120546 = [inst_120544,inst_120545];
var inst_120547 = (new cljs.core.PersistentVector(null,2,(5),inst_120543,inst_120546,null));
var inst_120548__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_120542,inst_120547);
var state_120688__$1 = (function (){var statearr_120774 = state_120688;
(statearr_120774[(12)] = inst_120541);

(statearr_120774[(34)] = inst_120548__$1);

return statearr_120774;
})();
if(cljs.core.truth_(inst_120548__$1)){
var statearr_120775_120918 = state_120688__$1;
(statearr_120775_120918[(1)] = (67));

} else {
var statearr_120776_120919 = state_120688__$1;
(statearr_120776_120919[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (103))){
var inst_120650 = (state_120688[(32)]);
var inst_120675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120676 = [acc,inst_120650];
var inst_120677 = (new cljs.core.PersistentVector(null,2,(5),inst_120675,inst_120676,null));
var state_120688__$1 = state_120688;
var statearr_120777_120920 = state_120688__$1;
(statearr_120777_120920[(2)] = inst_120677);

(statearr_120777_120920[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (51))){
var inst_120417 = (state_120688[(7)]);
var inst_120500 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = state_120688;
var statearr_120778_120921 = state_120688__$1;
(statearr_120778_120921[(2)] = inst_120500);

(statearr_120778_120921[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (25))){
var inst_120441 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120779_120922 = state_120688__$1;
(statearr_120779_120922[(2)] = inst_120441);

(statearr_120779_120922[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (34))){
var inst_120464 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120780_120923 = state_120688__$1;
(statearr_120780_120923[(2)] = inst_120464);

(statearr_120780_120923[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (17))){
var inst_120421 = (state_120688[(25)]);
var state_120688__$1 = state_120688;
var statearr_120781_120924 = state_120688__$1;
(statearr_120781_120924[(2)] = inst_120421);

(statearr_120781_120924[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (3))){
var inst_120390 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120782_120925 = state_120688__$1;
(statearr_120782_120925[(2)] = inst_120390);


cljs.core.async.impl.ioc_helpers.process_exception(state_120688__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (12))){
var inst_120411 = (state_120688[(18)]);
var inst_120415 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_120411,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_120688__$1 = state_120688;
var statearr_120783_120926 = state_120688__$1;
(statearr_120783_120926[(2)] = inst_120415);

(statearr_120783_120926[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (2))){
var inst_120686 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
return cljs.core.async.impl.ioc_helpers.return_chan(state_120688__$1,inst_120686);
} else {
if((state_val_120689 === (66))){
var inst_120642 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120784_120927 = state_120688__$1;
(statearr_120784_120927[(2)] = inst_120642);

(statearr_120784_120927[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (23))){
var state_120688__$1 = state_120688;
var statearr_120785_120928 = state_120688__$1;
(statearr_120785_120928[(2)] = true);

(statearr_120785_120928[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (47))){
var inst_120417 = (state_120688[(7)]);
var inst_120497 = (state_120688[(27)]);
var inst_120497__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = (function (){var statearr_120786 = state_120688;
(statearr_120786[(27)] = inst_120497__$1);

return statearr_120786;
})();
if(cljs.core.truth_(inst_120497__$1)){
var statearr_120787_120929 = state_120688__$1;
(statearr_120787_120929[(1)] = (50));

} else {
var statearr_120788_120930 = state_120688__$1;
(statearr_120788_120930[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (35))){
var inst_120455 = (state_120688[(15)]);
var inst_120469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_120455);
var state_120688__$1 = (function (){var statearr_120789 = state_120688;
(statearr_120789[(28)] = inst_120469);

return statearr_120789;
})();
if(cljs.core.truth_(inst_120470)){
var statearr_120790_120931 = state_120688__$1;
(statearr_120790_120931[(1)] = (38));

} else {
var statearr_120791_120932 = state_120688__$1;
(statearr_120791_120932[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (82))){
var inst_120587 = (state_120688[(20)]);
var inst_120601 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_120602 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_120601,inst_120587);
var state_120688__$1 = state_120688;
var statearr_120792_120933 = state_120688__$1;
(statearr_120792_120933[(2)] = inst_120602);

(statearr_120792_120933[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (76))){
var inst_120640 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120793_120934 = state_120688__$1;
(statearr_120793_120934[(2)] = inst_120640);

(statearr_120793_120934[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (97))){
var inst_120649 = (state_120688[(31)]);
var inst_120650 = (state_120688[(32)]);
var inst_120428 = (state_120688[(19)]);
var inst_120658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120659 = cljs.core.PersistentVector.EMPTY;
var inst_120660 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_120428,inst_120659);
var inst_120661 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_120660,inst_120649);
var inst_120662 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_120428,inst_120661);
var inst_120663 = [inst_120662,inst_120650];
var inst_120664 = (new cljs.core.PersistentVector(null,2,(5),inst_120658,inst_120663,null));
var state_120688__$1 = state_120688;
var statearr_120794_120935 = state_120688__$1;
(statearr_120794_120935[(2)] = inst_120664);

(statearr_120794_120935[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (19))){
var inst_120426 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120795_120936 = state_120688__$1;
(statearr_120795_120936[(2)] = inst_120426);

(statearr_120795_120936[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (57))){
var inst_120519 = (state_120688[(2)]);
var inst_120520 = fluree.db.util.async.throw_err(inst_120519);
var state_120688__$1 = (function (){var statearr_120796 = state_120688;
(statearr_120796[(10)] = inst_120520);

return statearr_120796;
})();
if(cljs.core.truth_(fuel)){
var statearr_120797_120937 = state_120688__$1;
(statearr_120797_120937[(1)] = (58));

} else {
var statearr_120798_120938 = state_120688__$1;
(statearr_120798_120938[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (68))){
var inst_120417 = (state_120688[(7)]);
var inst_120551 = flake.o;
var inst_120552 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_120417);
var inst_120553 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_120551,inst_120552);
var state_120688__$1 = state_120688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120688__$1,(70),inst_120553);
} else {
if((state_val_120689 === (11))){
var inst_120411 = (state_120688[(18)]);
var state_120688__$1 = state_120688;
var statearr_120799_120939 = state_120688__$1;
(statearr_120799_120939[(2)] = inst_120411);

(statearr_120799_120939[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (9))){
var state_120688__$1 = state_120688;
var statearr_120800_120940 = state_120688__$1;
(statearr_120800_120940[(2)] = pred_spec);

(statearr_120800_120940[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (5))){
var inst_120400 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_120401 = (inst_120400 == null);
var state_120688__$1 = state_120688;
var statearr_120801_120941 = state_120688__$1;
(statearr_120801_120941[(2)] = inst_120401);

(statearr_120801_120941[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (83))){
var inst_120587 = (state_120688[(20)]);
var state_120688__$1 = state_120688;
var statearr_120802_120942 = state_120688__$1;
(statearr_120802_120942[(2)] = inst_120587);

(statearr_120802_120942[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (14))){
var inst_120418 = (state_120688[(30)]);
var state_120688__$1 = state_120688;
var statearr_120803_120943 = state_120688__$1;
(statearr_120803_120943[(2)] = inst_120418);

(statearr_120803_120943[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (45))){
var inst_120495 = (state_120688[(26)]);
var inst_120495__$1 = cljs.core.not(recur_QMARK_);
var state_120688__$1 = (function (){var statearr_120804 = state_120688;
(statearr_120804[(26)] = inst_120495__$1);

return statearr_120804;
})();
if(inst_120495__$1){
var statearr_120805_120944 = state_120688__$1;
(statearr_120805_120944[(1)] = (47));

} else {
var statearr_120806_120945 = state_120688__$1;
(statearr_120806_120945[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (53))){
var inst_120417 = (state_120688[(7)]);
var inst_120507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120508 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_120509 = (new cljs.core.PersistentVector(null,3,(5),inst_120507,inst_120508,null));
var inst_120510 = cljs.core.select_keys(inst_120417,inst_120509);
var inst_120511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120514 = flake.o;
var inst_120515 = [inst_120514];
var inst_120516 = (new cljs.core.PersistentVector(null,1,(5),inst_120513,inst_120515,null));
var inst_120517 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_120516);
var state_120688__$1 = (function (){var statearr_120807 = state_120688;
(statearr_120807[(33)] = inst_120510);

(statearr_120807[(29)] = inst_120511);

return statearr_120807;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120688__$1,(57),inst_120517);
} else {
if((state_val_120689 === (78))){
var inst_120590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_120591 = ["_id"];
var inst_120592 = flake.o;
var inst_120593 = [inst_120592];
var inst_120594 = cljs.core.PersistentHashMap.fromArrays(inst_120591,inst_120593);
var inst_120595 = [inst_120594,offset_map];
var inst_120596 = (new cljs.core.PersistentVector(null,2,(5),inst_120590,inst_120595,null));
var state_120688__$1 = state_120688;
var statearr_120808_120946 = state_120688__$1;
(statearr_120808_120946[(2)] = inst_120596);

(statearr_120808_120946[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (26))){
var inst_120417 = (state_120688[(7)]);
var inst_120446 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_120417);
var state_120688__$1 = state_120688;
var statearr_120809_120947 = state_120688__$1;
(statearr_120809_120947[(2)] = inst_120446);

(statearr_120809_120947[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (16))){
var inst_120417 = (state_120688[(7)]);
var inst_120428 = (state_120688[(2)]);
var inst_120430 = (inst_120417 == null);
var inst_120431 = cljs.core.not(inst_120430);
var state_120688__$1 = (function (){var statearr_120810 = state_120688;
(statearr_120810[(19)] = inst_120428);

return statearr_120810;
})();
if(inst_120431){
var statearr_120811_120948 = state_120688__$1;
(statearr_120811_120948[(1)] = (20));

} else {
var statearr_120812_120949 = state_120688__$1;
(statearr_120812_120949[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (81))){
var inst_120598 = (state_120688[(35)]);
var inst_120613 = (state_120688[(2)]);
var inst_120614 = fluree.db.util.async.throw_err(inst_120613);
var inst_120615 = [inst_120614,offset_map];
var inst_120616 = (new cljs.core.PersistentVector(null,2,(5),inst_120598,inst_120615,null));
var state_120688__$1 = state_120688;
var statearr_120813_120950 = state_120688__$1;
(statearr_120813_120950[(2)] = inst_120616);

(statearr_120813_120950[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (79))){
var inst_120598 = cljs.core.PersistentVector.EMPTY_NODE;
var state_120688__$1 = (function (){var statearr_120814 = state_120688;
(statearr_120814[(35)] = inst_120598);

return statearr_120814;
})();
if(cljs.core.truth_(fuel)){
var statearr_120815_120951 = state_120688__$1;
(statearr_120815_120951[(1)] = (82));

} else {
var statearr_120816_120952 = state_120688__$1;
(statearr_120816_120952[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (38))){
var inst_120455 = (state_120688[(15)]);
var inst_120472 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_120455,cljs.core.dec);
var state_120688__$1 = state_120688;
var statearr_120817_120953 = state_120688__$1;
(statearr_120817_120953[(2)] = inst_120472);

(statearr_120817_120953[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (98))){
var inst_120649 = (state_120688[(31)]);
var inst_120666 = (inst_120649 == null);
var inst_120667 = cljs.core.not(inst_120666);
var state_120688__$1 = state_120688;
if(inst_120667){
var statearr_120818_120954 = state_120688__$1;
(statearr_120818_120954[(1)] = (100));

} else {
var statearr_120819_120955 = state_120688__$1;
(statearr_120819_120955[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (87))){
var inst_120611 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120688__$1,(81),inst_120611);
} else {
if((state_val_120689 === (30))){
var inst_120450 = (state_120688[(21)]);
var state_120688__$1 = state_120688;
var statearr_120820_120956 = state_120688__$1;
(statearr_120820_120956[(2)] = inst_120450);

(statearr_120820_120956[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (73))){
var inst_120574 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120574)){
var statearr_120821_120957 = state_120688__$1;
(statearr_120821_120957[(1)] = (74));

} else {
var statearr_120822_120958 = state_120688__$1;
(statearr_120822_120958[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (96))){
var inst_120656 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120656)){
var statearr_120823_120959 = state_120688__$1;
(statearr_120823_120959[(1)] = (97));

} else {
var statearr_120824_120960 = state_120688__$1;
(statearr_120824_120960[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (10))){
var inst_120411 = (state_120688[(18)]);
var inst_120411__$1 = (state_120688[(2)]);
var inst_120412 = cljs.core.contains_QMARK_(inst_120411__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_120688__$1 = (function (){var statearr_120825 = state_120688;
(statearr_120825[(18)] = inst_120411__$1);

return statearr_120825;
})();
if(inst_120412){
var statearr_120826_120961 = state_120688__$1;
(statearr_120826_120961[(1)] = (11));

} else {
var statearr_120827_120962 = state_120688__$1;
(statearr_120827_120962[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (18))){
var inst_120417 = (state_120688[(7)]);
var inst_120424 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = state_120688;
var statearr_120828_120963 = state_120688__$1;
(statearr_120828_120963[(2)] = inst_120424);

(statearr_120828_120963[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (105))){
var inst_120680 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120829_120964 = state_120688__$1;
(statearr_120829_120964[(2)] = inst_120680);

(statearr_120829_120964[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (52))){
var inst_120502 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120830_120965 = state_120688__$1;
(statearr_120830_120965[(2)] = inst_120502);

(statearr_120830_120965[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (67))){
var inst_120548 = (state_120688[(34)]);
var state_120688__$1 = state_120688;
var statearr_120831_120966 = state_120688__$1;
(statearr_120831_120966[(2)] = inst_120548);

(statearr_120831_120966[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (71))){
var inst_120417 = (state_120688[(7)]);
var inst_120571 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_120417);
var state_120688__$1 = state_120688;
var statearr_120832_120967 = state_120688__$1;
(statearr_120832_120967[(2)] = inst_120571);

(statearr_120832_120967[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (42))){
var inst_120450 = (state_120688[(21)]);
var state_120688__$1 = state_120688;
var statearr_120833_120968 = state_120688__$1;
(statearr_120833_120968[(2)] = inst_120450);

(statearr_120833_120968[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (80))){
var inst_120618 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
var statearr_120834_120969 = state_120688__$1;
(statearr_120834_120969[(2)] = inst_120618);

(statearr_120834_120969[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (37))){
var inst_120649 = (state_120688[(31)]);
var inst_120652 = (state_120688[(24)]);
var inst_120648 = (state_120688[(2)]);
var inst_120649__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120648,(0),null);
var inst_120650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_120648,(1),null);
var inst_120651 = (inst_120649__$1 == null);
var inst_120652__$1 = cljs.core.not(inst_120651);
var state_120688__$1 = (function (){var statearr_120835 = state_120688;
(statearr_120835[(31)] = inst_120649__$1);

(statearr_120835[(32)] = inst_120650);

(statearr_120835[(24)] = inst_120652__$1);

return statearr_120835;
})();
if(inst_120652__$1){
var statearr_120836_120970 = state_120688__$1;
(statearr_120836_120970[(1)] = (94));

} else {
var statearr_120837_120971 = state_120688__$1;
(statearr_120837_120971[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (63))){
var inst_120532 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_120688__$1,(56),inst_120532);
} else {
if((state_val_120689 === (94))){
var inst_120450 = (state_120688[(21)]);
var state_120688__$1 = state_120688;
var statearr_120838_120972 = state_120688__$1;
(statearr_120838_120972[(2)] = inst_120450);

(statearr_120838_120972[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (8))){
var inst_120406 = flake.p;
var inst_120407 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_120408 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_120406,inst_120407);
var state_120688__$1 = state_120688;
var statearr_120839_120973 = state_120688__$1;
(statearr_120839_120973[(2)] = inst_120408);

(statearr_120839_120973[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (49))){
var inst_120505 = (state_120688[(2)]);
var state_120688__$1 = state_120688;
if(cljs.core.truth_(inst_120505)){
var statearr_120840_120974 = state_120688__$1;
(statearr_120840_120974[(1)] = (53));

} else {
var statearr_120841_120975 = state_120688__$1;
(statearr_120841_120975[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_120689 === (84))){
var inst_120605 = (state_120688[(2)]);
var state_120688__$1 = (function (){var statearr_120842 = state_120688;
(statearr_120842[(11)] = inst_120605);

return statearr_120842;
})();
var statearr_120843_120976 = state_120688__$1;
(statearr_120843_120976[(1)] = (85));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$state_machine__109971__auto__ = null;
var fluree$db$query$fql$state_machine__109971__auto____0 = (function (){
var statearr_120845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_120845[(0)] = fluree$db$query$fql$state_machine__109971__auto__);

(statearr_120845[(1)] = (1));

return statearr_120845;
});
var fluree$db$query$fql$state_machine__109971__auto____1 = (function (state_120688){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_120688);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e120846){if((e120846 instanceof Object)){
var ex__109974__auto__ = e120846;
var statearr_120847_120977 = state_120688;
(statearr_120847_120977[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_120688);

return cljs.core.cst$kw$recur;
} else {
throw e120846;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__120978 = state_120688;
state_120688 = G__120978;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__109971__auto__ = function(state_120688){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__109971__auto____1.call(this,state_120688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__109971__auto____0;
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__109971__auto____1;
return fluree$db$query$fql$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_120848 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_120848[(6)] = c__110077__auto__);

return statearr_120848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10;

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,((function (lookup_specs,or__4131__auto__,coll_id){
return (function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
});})(lookup_specs,or__4131__auto__,coll_id))
);
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_121154){
var state_val_121155 = (state_121154[(1)]);
if((state_val_121155 === (7))){
var inst_120994 = (state_121154[(7)]);
var state_121154__$1 = state_121154;
var statearr_121156_121245 = state_121154__$1;
(statearr_121156_121245[(2)] = inst_120994);

(statearr_121156_121245[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (59))){
var inst_121142 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121157_121246 = state_121154__$1;
(statearr_121157_121246[(2)] = inst_121142);

(statearr_121157_121246[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (20))){
var state_121154__$1 = state_121154;
var statearr_121158_121247 = state_121154__$1;
(statearr_121158_121247[(2)] = fuel);

(statearr_121158_121247[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (58))){
var inst_121036 = (state_121154[(8)]);
var state_121154__$1 = state_121154;
var statearr_121159_121248 = state_121154__$1;
(statearr_121159_121248[(2)] = inst_121036);

(statearr_121159_121248[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (27))){
var inst_121034 = (state_121154[(9)]);
var inst_121136 = (state_121154[(2)]);
var state_121154__$1 = (function (){var statearr_121160 = state_121154;
(statearr_121160[(10)] = inst_121136);

return statearr_121160;
})();
if(cljs.core.truth_(inst_121034)){
var statearr_121161_121249 = state_121154__$1;
(statearr_121161_121249[(1)] = (54));

} else {
var statearr_121162_121250 = state_121154__$1;
(statearr_121162_121250[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (1))){
var state_121154__$1 = state_121154;
var statearr_121163_121251 = state_121154__$1;
(statearr_121163_121251[(2)] = null);

(statearr_121163_121251[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (24))){
var state_121154__$1 = state_121154;
var statearr_121164_121252 = state_121154__$1;
(statearr_121164_121252[(2)] = null);

(statearr_121164_121252[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (55))){
var inst_121035 = (state_121154[(11)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121035)){
var statearr_121165_121253 = state_121154__$1;
(statearr_121165_121253[(1)] = (57));

} else {
var statearr_121166_121254 = state_121154__$1;
(statearr_121166_121254[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (39))){
var inst_121093 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121093)){
var statearr_121167_121255 = state_121154__$1;
(statearr_121167_121255[(1)] = (40));

} else {
var statearr_121168_121256 = state_121154__$1;
(statearr_121168_121256[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (46))){
var inst_121105 = (state_121154[(12)]);
var inst_121010 = (state_121154[(13)]);
var inst_121104 = (state_121154[(2)]);
var inst_121105__$1 = fluree.db.util.async.throw_err(inst_121104);
var inst_121106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121107 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_121108 = (new cljs.core.PersistentVector(null,4,(5),inst_121106,inst_121107,null));
var inst_121109 = cljs.core.select_keys(inst_121010,inst_121108);
var inst_121110 = cljs.core.empty_QMARK_(inst_121105__$1);
var state_121154__$1 = (function (){var statearr_121169 = state_121154;
(statearr_121169[(12)] = inst_121105__$1);

(statearr_121169[(14)] = inst_121109);

return statearr_121169;
})();
if(inst_121110){
var statearr_121170_121257 = state_121154__$1;
(statearr_121170_121257[(1)] = (47));

} else {
var statearr_121171_121258 = state_121154__$1;
(statearr_121171_121258[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_121154,(3),Error,null,(2));
var inst_120990 = cljs.core.seq(reverse_refs_specs);
var inst_120991 = cljs.core.first(inst_120990);
var inst_120992 = cljs.core.next(inst_120990);
var inst_120993 = reverse_refs_specs;
var inst_120994 = null;
var state_121154__$1 = (function (){var statearr_121172 = state_121154;
(statearr_121172[(15)] = inst_120991);

(statearr_121172[(7)] = inst_120994);

(statearr_121172[(16)] = inst_120992);

(statearr_121172[(17)] = inst_120993);

return statearr_121172;
})();
var statearr_121173_121259 = state_121154__$1;
(statearr_121173_121259[(2)] = null);

(statearr_121173_121259[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (54))){
var inst_121034 = (state_121154[(9)]);
var state_121154__$1 = state_121154;
var statearr_121174_121260 = state_121154__$1;
(statearr_121174_121260[(2)] = inst_121034);

(statearr_121174_121260[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (15))){
var inst_121023 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121175_121261 = state_121154__$1;
(statearr_121175_121261[(2)] = inst_121023);

(statearr_121175_121261[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (48))){
var state_121154__$1 = state_121154;
if(cljs.core.truth_(fuel)){
var statearr_121176_121262 = state_121154__$1;
(statearr_121176_121262[(1)] = (50));

} else {
var statearr_121177_121263 = state_121154__$1;
(statearr_121177_121263[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (50))){
var inst_121105 = (state_121154[(12)]);
var inst_121114 = cljs.core.count(inst_121105);
var inst_121115 = fluree.db.query.fql.add_fuel(fuel,inst_121114,max_fuel);
var state_121154__$1 = state_121154;
var statearr_121178_121264 = state_121154__$1;
(statearr_121178_121264[(2)] = inst_121115);

(statearr_121178_121264[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (21))){
var inst_121045 = (state_121154[(18)]);
var state_121154__$1 = state_121154;
var statearr_121179_121265 = state_121154__$1;
(statearr_121179_121265[(2)] = inst_121045);

(statearr_121179_121265[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (31))){
var inst_121033 = (state_121154[(19)]);
var inst_121068 = (state_121154[(20)]);
var inst_121081 = (inst_121068 >= inst_121033);
var state_121154__$1 = state_121154;
var statearr_121181_121266 = state_121154__$1;
(statearr_121181_121266[(2)] = inst_121081);

(statearr_121181_121266[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (32))){
var inst_121033 = (state_121154[(19)]);
var state_121154__$1 = state_121154;
var statearr_121182_121267 = state_121154__$1;
(statearr_121182_121267[(2)] = inst_121033);

(statearr_121182_121267[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (40))){
var inst_121076 = (state_121154[(21)]);
var inst_121069 = (state_121154[(22)]);
var inst_121068 = (state_121154[(20)]);
var inst_121095 = (inst_121068 + (1));
var tmp121180 = inst_121069;
var inst_121067 = inst_121076;
var inst_121068__$1 = inst_121095;
var inst_121069__$1 = tmp121180;
var state_121154__$1 = (function (){var statearr_121183 = state_121154;
(statearr_121183[(23)] = inst_121067);

(statearr_121183[(22)] = inst_121069__$1);

(statearr_121183[(20)] = inst_121068__$1);

return statearr_121183;
})();
var statearr_121184_121268 = state_121154__$1;
(statearr_121184_121268[(2)] = null);

(statearr_121184_121268[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (56))){
var inst_121136 = (state_121154[(10)]);
var inst_121001 = (state_121154[(24)]);
var inst_120994 = (state_121154[(7)]);
var inst_121144 = (state_121154[(2)]);
var inst_121145 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_120994,inst_121144,inst_121136);
var inst_120993 = inst_121001;
var inst_120994__$1 = inst_121145;
var state_121154__$1 = (function (){var statearr_121185 = state_121154;
(statearr_121185[(7)] = inst_120994__$1);

(statearr_121185[(17)] = inst_120993);

return statearr_121185;
})();
var statearr_121186_121269 = state_121154__$1;
(statearr_121186_121269[(2)] = null);

(statearr_121186_121269[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (33))){
var inst_121084 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121187_121270 = state_121154__$1;
(statearr_121187_121270[(2)] = inst_121084);

(statearr_121187_121270[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (13))){
var state_121154__$1 = state_121154;
var statearr_121188_121271 = state_121154__$1;
(statearr_121188_121271[(2)] = true);

(statearr_121188_121271[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (22))){
var inst_121049 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121049)){
var statearr_121189_121272 = state_121154__$1;
(statearr_121189_121272[(1)] = (23));

} else {
var statearr_121190_121273 = state_121154__$1;
(statearr_121190_121273[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (36))){
var inst_121134 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121191_121274 = state_121154__$1;
(statearr_121191_121274[(2)] = inst_121134);

(statearr_121191_121274[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (41))){
var state_121154__$1 = state_121154;
var statearr_121192_121275 = state_121154__$1;
(statearr_121192_121275[(1)] = (43));



return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (43))){
var inst_121075 = (state_121154[(25)]);
var inst_121099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121100 = [inst_121075];
var inst_121101 = (new cljs.core.PersistentVector(null,1,(5),inst_121099,inst_121100,null));
var inst_121102 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_121101);
var state_121154__$1 = state_121154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121154__$1,(46),inst_121102);
} else {
if((state_val_121155 === (29))){
var inst_121033 = (state_121154[(19)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121033)){
var statearr_121194_121276 = state_121154__$1;
(statearr_121194_121276[(1)] = (31));

} else {
var statearr_121195_121277 = state_121154__$1;
(statearr_121195_121277[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (44))){
var state_121154__$1 = state_121154;
var statearr_121196_121278 = state_121154__$1;
(statearr_121196_121278[(2)] = null);

(statearr_121196_121278[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (6))){
var inst_121150 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121197_121279 = state_121154__$1;
(statearr_121197_121279[(2)] = inst_121150);


cljs.core.async.impl.ioc_helpers.process_exception(state_121154__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (28))){
var inst_121077 = (state_121154[(26)]);
var state_121154__$1 = state_121154;
var statearr_121198_121280 = state_121154__$1;
(statearr_121198_121280[(2)] = inst_121077);

(statearr_121198_121280[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (51))){
var state_121154__$1 = state_121154;
var statearr_121199_121281 = state_121154__$1;
(statearr_121199_121281[(2)] = null);

(statearr_121199_121281[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (25))){
var inst_121045 = (state_121154[(18)]);
var inst_121055 = (state_121154[(2)]);
var inst_121063 = cljs.core.seq(inst_121045);
var inst_121064 = cljs.core.first(inst_121063);
var inst_121065 = cljs.core.next(inst_121063);
var inst_121066 = cljs.core.PersistentVector.EMPTY;
var inst_121067 = inst_121045;
var inst_121068 = (0);
var inst_121069 = inst_121066;
var state_121154__$1 = (function (){var statearr_121200 = state_121154;
(statearr_121200[(23)] = inst_121067);

(statearr_121200[(27)] = inst_121065);

(statearr_121200[(28)] = inst_121055);

(statearr_121200[(22)] = inst_121069);

(statearr_121200[(20)] = inst_121068);

(statearr_121200[(29)] = inst_121064);

return statearr_121200;
})();
var statearr_121201_121282 = state_121154__$1;
(statearr_121201_121282[(2)] = null);

(statearr_121201_121282[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (34))){
var inst_121069 = (state_121154[(22)]);
var state_121154__$1 = state_121154;
var statearr_121202_121283 = state_121154__$1;
(statearr_121202_121283[(2)] = inst_121069);

(statearr_121202_121283[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (17))){
var inst_121010 = (state_121154[(13)]);
var state_121154__$1 = state_121154;
var statearr_121203_121284 = state_121154__$1;
(statearr_121203_121284[(2)] = inst_121010);

(statearr_121203_121284[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (3))){
var inst_120979 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121204_121285 = state_121154__$1;
(statearr_121204_121285[(2)] = inst_120979);


cljs.core.async.impl.ioc_helpers.process_exception(state_121154__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (12))){
var inst_121026 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121026)){
var statearr_121205_121286 = state_121154__$1;
(statearr_121205_121286[(1)] = (16));

} else {
var statearr_121206_121287 = state_121154__$1;
(statearr_121206_121287[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (2))){
var inst_121152 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_121154__$1,inst_121152);
} else {
if((state_val_121155 === (23))){
var inst_121045 = (state_121154[(18)]);
var inst_121051 = cljs.core.count(inst_121045);
var inst_121052 = fluree.db.query.fql.add_fuel(fuel,inst_121051,max_fuel);
var state_121154__$1 = state_121154;
var statearr_121207_121288 = state_121154__$1;
(statearr_121207_121288[(2)] = inst_121052);

(statearr_121207_121288[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (47))){
var inst_121069 = (state_121154[(22)]);
var state_121154__$1 = state_121154;
var statearr_121208_121289 = state_121154__$1;
(statearr_121208_121289[(2)] = inst_121069);

(statearr_121208_121289[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (35))){
var inst_121032 = (state_121154[(30)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121032)){
var statearr_121209_121290 = state_121154__$1;
(statearr_121209_121290[(1)] = (37));

} else {
var statearr_121210_121291 = state_121154__$1;
(statearr_121210_121291[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (19))){
var inst_121045 = (state_121154[(18)]);
var inst_121042 = (state_121154[(2)]);
var inst_121043 = fluree.db.util.async.throw_err(inst_121042);
var inst_121044 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_121043);
var inst_121045__$1 = cljs.core.not_empty(inst_121044);
var state_121154__$1 = (function (){var statearr_121211 = state_121154;
(statearr_121211[(18)] = inst_121045__$1);

return statearr_121211;
})();
if(cljs.core.truth_(inst_121045__$1)){
var statearr_121212_121292 = state_121154__$1;
(statearr_121212_121292[(1)] = (20));

} else {
var statearr_121213_121293 = state_121154__$1;
(statearr_121213_121293[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (57))){
var inst_121035 = (state_121154[(11)]);
var state_121154__$1 = state_121154;
var statearr_121214_121294 = state_121154__$1;
(statearr_121214_121294[(2)] = inst_121035);

(statearr_121214_121294[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (11))){
var state_121154__$1 = state_121154;
var statearr_121215_121295 = state_121154__$1;
(statearr_121215_121295[(2)] = false);

(statearr_121215_121295[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (9))){
var inst_121148 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121216_121296 = state_121154__$1;
(statearr_121216_121296[(2)] = inst_121148);

(statearr_121216_121296[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (5))){
var inst_121000 = (state_121154[(31)]);
var inst_120993 = (state_121154[(17)]);
var inst_120999 = cljs.core.seq(inst_120993);
var inst_121000__$1 = cljs.core.first(inst_120999);
var inst_121001 = cljs.core.next(inst_120999);
var inst_121002 = cljs.core.not(inst_121000__$1);
var state_121154__$1 = (function (){var statearr_121217 = state_121154;
(statearr_121217[(31)] = inst_121000__$1);

(statearr_121217[(24)] = inst_121001);

return statearr_121217;
})();
if(inst_121002){
var statearr_121218_121297 = state_121154__$1;
(statearr_121218_121297[(1)] = (7));

} else {
var statearr_121219_121298 = state_121154__$1;
(statearr_121219_121298[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (14))){
var state_121154__$1 = state_121154;
var statearr_121220_121299 = state_121154__$1;
(statearr_121220_121299[(2)] = false);

(statearr_121220_121299[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (45))){
var inst_121130 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121221_121300 = state_121154__$1;
(statearr_121221_121300[(2)] = inst_121130);

(statearr_121221_121300[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (53))){
var inst_121069 = (state_121154[(22)]);
var inst_121121 = (state_121154[(2)]);
var inst_121122 = fluree.db.util.async.throw_err(inst_121121);
var inst_121123 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_121069,inst_121122);
var state_121154__$1 = state_121154;
var statearr_121222_121301 = state_121154__$1;
(statearr_121222_121301[(2)] = inst_121123);

(statearr_121222_121301[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (26))){
var inst_121067 = (state_121154[(23)]);
var inst_121075 = (state_121154[(25)]);
var inst_121077 = (state_121154[(26)]);
var inst_121074 = cljs.core.seq(inst_121067);
var inst_121075__$1 = cljs.core.first(inst_121074);
var inst_121076 = cljs.core.next(inst_121074);
var inst_121077__$1 = cljs.core.not(inst_121075__$1);
var state_121154__$1 = (function (){var statearr_121223 = state_121154;
(statearr_121223[(21)] = inst_121076);

(statearr_121223[(25)] = inst_121075__$1);

(statearr_121223[(26)] = inst_121077__$1);

return statearr_121223;
})();
if(inst_121077__$1){
var statearr_121224_121302 = state_121154__$1;
(statearr_121224_121302[(1)] = (28));

} else {
var statearr_121225_121303 = state_121154__$1;
(statearr_121225_121303[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (16))){
var inst_121010 = (state_121154[(13)]);
var inst_121028 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_121010);
var state_121154__$1 = state_121154;
var statearr_121226_121304 = state_121154__$1;
(statearr_121226_121304[(2)] = inst_121028);

(statearr_121226_121304[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (38))){
var inst_121032 = (state_121154[(30)]);
var state_121154__$1 = state_121154;
var statearr_121227_121305 = state_121154__$1;
(statearr_121227_121305[(2)] = inst_121032);

(statearr_121227_121305[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (30))){
var inst_121086 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121086)){
var statearr_121228_121306 = state_121154__$1;
(statearr_121228_121306[(1)] = (34));

} else {
var statearr_121229_121307 = state_121154__$1;
(statearr_121229_121307[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (10))){
var inst_121010 = (state_121154[(13)]);
var inst_121015 = inst_121010.cljs$lang$protocol_mask$partition0$;
var inst_121016 = (inst_121015 & (64));
var inst_121017 = inst_121010.cljs$core$ISeq$;
var inst_121018 = (cljs.core.PROTOCOL_SENTINEL === inst_121017);
var inst_121019 = ((inst_121016) || (inst_121018));
var state_121154__$1 = state_121154;
if(cljs.core.truth_(inst_121019)){
var statearr_121230_121308 = state_121154__$1;
(statearr_121230_121308[(1)] = (13));

} else {
var statearr_121231_121309 = state_121154__$1;
(statearr_121231_121309[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (18))){
var inst_121009 = (state_121154[(32)]);
var inst_121031 = (state_121154[(2)]);
var inst_121032 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121031,cljs.core.cst$kw$offset);
var inst_121033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121031,cljs.core.cst$kw$limit);
var inst_121034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121031,cljs.core.cst$kw$as);
var inst_121035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121031,cljs.core.cst$kw$name);
var inst_121036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121031,cljs.core.cst$kw$p);
var inst_121037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121038 = [subject_id,inst_121009];
var inst_121039 = (new cljs.core.PersistentVector(null,2,(5),inst_121037,inst_121038,null));
var inst_121040 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_121039);
var state_121154__$1 = (function (){var statearr_121232 = state_121154;
(statearr_121232[(9)] = inst_121034);

(statearr_121232[(8)] = inst_121036);

(statearr_121232[(30)] = inst_121032);

(statearr_121232[(19)] = inst_121033);

(statearr_121232[(11)] = inst_121035);

return statearr_121232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121154__$1,(19),inst_121040);
} else {
if((state_val_121155 === (52))){
var inst_121105 = (state_121154[(12)]);
var inst_121109 = (state_121154[(14)]);
var inst_121118 = (state_121154[(2)]);
var inst_121119 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_121109,inst_121105) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_121109,inst_121105));
var state_121154__$1 = (function (){var statearr_121233 = state_121154;
(statearr_121233[(33)] = inst_121118);

return statearr_121233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121154__$1,(53),inst_121119);
} else {
if((state_val_121155 === (42))){
var inst_121132 = (state_121154[(2)]);
var state_121154__$1 = state_121154;
var statearr_121234_121310 = state_121154__$1;
(statearr_121234_121310[(2)] = inst_121132);

(statearr_121234_121310[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (37))){
var inst_121032 = (state_121154[(30)]);
var inst_121068 = (state_121154[(20)]);
var inst_121090 = (inst_121068 < inst_121032);
var state_121154__$1 = state_121154;
var statearr_121235_121311 = state_121154__$1;
(statearr_121235_121311[(2)] = inst_121090);

(statearr_121235_121311[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (8))){
var inst_121000 = (state_121154[(31)]);
var inst_121010 = (state_121154[(13)]);
var inst_121009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121000,(0),null);
var inst_121010__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121000,(1),null);
var inst_121012 = (inst_121010__$1 == null);
var inst_121013 = cljs.core.not(inst_121012);
var state_121154__$1 = (function (){var statearr_121236 = state_121154;
(statearr_121236[(32)] = inst_121009);

(statearr_121236[(13)] = inst_121010__$1);

return statearr_121236;
})();
if(inst_121013){
var statearr_121237_121312 = state_121154__$1;
(statearr_121237_121312[(1)] = (10));

} else {
var statearr_121238_121313 = state_121154__$1;
(statearr_121238_121313[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121155 === (49))){
var inst_121076 = (state_121154[(21)]);
var inst_121068 = (state_121154[(20)]);
var inst_121125 = (state_121154[(2)]);
var inst_121126 = (inst_121068 + (1));
var inst_121067 = inst_121076;
var inst_121068__$1 = inst_121126;
var inst_121069 = inst_121125;
var state_121154__$1 = (function (){var statearr_121239 = state_121154;
(statearr_121239[(23)] = inst_121067);

(statearr_121239[(22)] = inst_121069);

(statearr_121239[(20)] = inst_121068__$1);

return statearr_121239;
})();
var statearr_121240_121314 = state_121154__$1;
(statearr_121240_121314[(2)] = null);

(statearr_121240_121314[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____0 = (function (){
var statearr_121241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121241[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__);

(statearr_121241[(1)] = (1));

return statearr_121241;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____1 = (function (state_121154){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_121154);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e121242){if((e121242 instanceof Object)){
var ex__109974__auto__ = e121242;
var statearr_121243_121315 = state_121154;
(statearr_121243_121315[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_121154);

return cljs.core.cst$kw$recur;
} else {
throw e121242;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__121316 = state_121154;
state_121154 = G__121316;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__ = function(state_121154){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____1.call(this,state_121154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_121244 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_121244[(6)] = c__110077__auto__);

return statearr_121244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null),cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o(f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.cst$kw$depth], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_121430){
var state_val_121431 = (state_121430[(1)]);
if((state_val_121431 === (7))){
var inst_121333 = (state_121430[(7)]);
var state_121430__$1 = state_121430;
var statearr_121432_121481 = state_121430__$1;
(statearr_121432_121481[(2)] = inst_121333);

(statearr_121432_121481[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (20))){
var inst_121377 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
var statearr_121433_121482 = state_121430__$1;
(statearr_121433_121482[(2)] = inst_121377);

(statearr_121433_121482[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (27))){
var inst_121400 = (state_121430[(2)]);
var inst_121401 = fluree.db.util.async.throw_err(inst_121400);
var state_121430__$1 = state_121430;
var statearr_121434_121483 = state_121430__$1;
(statearr_121434_121483[(2)] = inst_121401);

(statearr_121434_121483[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (1))){
var state_121430__$1 = state_121430;
var statearr_121435_121484 = state_121430__$1;
(statearr_121435_121484[(2)] = null);

(statearr_121435_121484[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (24))){
var inst_121333 = (state_121430[(7)]);
var inst_121398 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_121333,pred_spec,f,component_follow_QMARK_,true);
var state_121430__$1 = state_121430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121430__$1,(27),inst_121398);
} else {
if((state_val_121431 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_121430,(3),Error,null,(2));
var inst_121329 = cljs.core.seq(new_child_paths);
var inst_121330 = cljs.core.first(inst_121329);
var inst_121331 = cljs.core.next(inst_121329);
var inst_121332 = new_child_paths;
var inst_121333 = acc;
var state_121430__$1 = (function (){var statearr_121436 = state_121430;
(statearr_121436[(8)] = inst_121330);

(statearr_121436[(7)] = inst_121333);

(statearr_121436[(9)] = inst_121331);

(statearr_121436[(10)] = inst_121332);

return statearr_121436;
})();
var statearr_121437_121485 = state_121430__$1;
(statearr_121437_121485[(2)] = null);

(statearr_121437_121485[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (15))){
var inst_121382 = (state_121430[(11)]);
var inst_121382__$1 = (state_121430[(2)]);
var inst_121383 = cljs.core.count(inst_121382__$1);
var inst_121384 = (inst_121383 > (1));
var state_121430__$1 = (function (){var statearr_121438 = state_121430;
(statearr_121438[(11)] = inst_121382__$1);

return statearr_121438;
})();
if(cljs.core.truth_(inst_121384)){
var statearr_121439_121486 = state_121430__$1;
(statearr_121439_121486[(1)] = (21));

} else {
var statearr_121440_121487 = state_121430__$1;
(statearr_121440_121487[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (21))){
var inst_121382 = (state_121430[(11)]);
var inst_121386 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_121382);
var state_121430__$1 = state_121430;
var statearr_121441_121488 = state_121430__$1;
(statearr_121441_121488[(2)] = inst_121386);

(statearr_121441_121488[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (31))){
var inst_121340 = (state_121430[(12)]);
var inst_121333 = (state_121430[(7)]);
var inst_121420 = (state_121430[(2)]);
var inst_121421 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_121333,inst_121420);
var inst_121332 = inst_121340;
var inst_121333__$1 = inst_121421;
var state_121430__$1 = (function (){var statearr_121442 = state_121430;
(statearr_121442[(7)] = inst_121333__$1);

(statearr_121442[(10)] = inst_121332);

return statearr_121442;
})();
var statearr_121443_121489 = state_121430__$1;
(statearr_121443_121489[(2)] = null);

(statearr_121443_121489[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (13))){
var inst_121351 = (state_121430[(13)]);
var inst_121348 = (state_121430[(14)]);
var inst_121359 = inst_121348;
var inst_121360 = inst_121351;
var state_121430__$1 = (function (){var statearr_121444 = state_121430;
(statearr_121444[(15)] = inst_121360);

(statearr_121444[(16)] = inst_121359);

return statearr_121444;
})();
var statearr_121445_121490 = state_121430__$1;
(statearr_121445_121490[(2)] = null);

(statearr_121445_121490[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (22))){
var inst_121382 = (state_121430[(11)]);
var state_121430__$1 = state_121430;
var statearr_121446_121491 = state_121430__$1;
(statearr_121446_121491[(2)] = inst_121382);

(statearr_121446_121491[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (29))){
var inst_121409 = (state_121430[(17)]);
var state_121430__$1 = state_121430;
var statearr_121447_121492 = state_121430__$1;
(statearr_121447_121492[(2)] = inst_121409);

(statearr_121447_121492[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (6))){
var inst_121426 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
var statearr_121448_121493 = state_121430__$1;
(statearr_121448_121493[(2)] = inst_121426);


cljs.core.async.impl.ioc_helpers.process_exception(state_121430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (28))){
var inst_121405 = (state_121430[(2)]);
var inst_121406 = fluree.db.util.async.throw_err(inst_121405);
var state_121430__$1 = state_121430;
var statearr_121449_121494 = state_121430__$1;
(statearr_121449_121494[(2)] = inst_121406);

(statearr_121449_121494[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (25))){
var inst_121390 = (state_121430[(18)]);
var inst_121403 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_121390,pred_spec,f,component_follow_QMARK_,true);
var state_121430__$1 = state_121430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121430__$1,(28),inst_121403);
} else {
if((state_val_121431 === (17))){
var inst_121379 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
var statearr_121450_121495 = state_121430__$1;
(statearr_121450_121495[(2)] = inst_121379);

(statearr_121450_121495[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (3))){
var inst_121318 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
var statearr_121451_121496 = state_121430__$1;
(statearr_121451_121496[(2)] = inst_121318);


cljs.core.async.impl.ioc_helpers.process_exception(state_121430__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (12))){
var inst_121333 = (state_121430[(7)]);
var inst_121348 = (state_121430[(14)]);
var inst_121348__$1 = (state_121430[(2)]);
var inst_121349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121350 = [k];
var inst_121351 = (new cljs.core.PersistentVector(null,1,(5),inst_121349,inst_121350,null));
var inst_121352 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_121333);
var inst_121353 = fluree.db.query.fql.s(f);
var inst_121354 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_121352,inst_121353);
var inst_121355 = cljs.core.empty_QMARK_(inst_121348__$1);
var inst_121356 = (!(inst_121355));
var inst_121357 = ((inst_121354) && (inst_121356));
var state_121430__$1 = (function (){var statearr_121452 = state_121430;
(statearr_121452[(13)] = inst_121351);

(statearr_121452[(14)] = inst_121348__$1);

return statearr_121452;
})();
if(cljs.core.truth_(inst_121357)){
var statearr_121453_121497 = state_121430__$1;
(statearr_121453_121497[(1)] = (13));

} else {
var statearr_121454_121498 = state_121430__$1;
(statearr_121454_121498[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (2))){
var inst_121428 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_121430__$1,inst_121428);
} else {
if((state_val_121431 === (23))){
var inst_121333 = (state_121430[(7)]);
var inst_121389 = (state_121430[(19)]);
var inst_121389__$1 = (state_121430[(2)]);
var inst_121390 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121333,inst_121389__$1);
var inst_121394 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_121333);
var inst_121395 = fluree.db.query.fql.s(f);
var inst_121396 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_121394,inst_121395);
var state_121430__$1 = (function (){var statearr_121455 = state_121430;
(statearr_121455[(18)] = inst_121390);

(statearr_121455[(19)] = inst_121389__$1);

return statearr_121455;
})();
if(inst_121396){
var statearr_121456_121499 = state_121430__$1;
(statearr_121456_121499[(1)] = (24));

} else {
var statearr_121457_121500 = state_121430__$1;
(statearr_121457_121500[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (19))){
var inst_121368 = (state_121430[(20)]);
var state_121430__$1 = state_121430;
var statearr_121458_121501 = state_121430__$1;
(statearr_121458_121501[(2)] = inst_121368);

(statearr_121458_121501[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (11))){
var inst_121339 = (state_121430[(21)]);
var inst_121346 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_121339);
var state_121430__$1 = state_121430;
var statearr_121459_121502 = state_121430__$1;
(statearr_121459_121502[(2)] = inst_121346);

(statearr_121459_121502[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (9))){
var inst_121424 = (state_121430[(2)]);
var state_121430__$1 = state_121430;
var statearr_121460_121503 = state_121430__$1;
(statearr_121460_121503[(2)] = inst_121424);

(statearr_121460_121503[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (5))){
var inst_121339 = (state_121430[(21)]);
var inst_121332 = (state_121430[(10)]);
var inst_121338 = cljs.core.seq(inst_121332);
var inst_121339__$1 = cljs.core.first(inst_121338);
var inst_121340 = cljs.core.next(inst_121338);
var inst_121341 = cljs.core.not(inst_121339__$1);
var state_121430__$1 = (function (){var statearr_121461 = state_121430;
(statearr_121461[(12)] = inst_121340);

(statearr_121461[(21)] = inst_121339__$1);

return statearr_121461;
})();
if(inst_121341){
var statearr_121462_121504 = state_121430__$1;
(statearr_121462_121504[(1)] = (7));

} else {
var statearr_121463_121505 = state_121430__$1;
(statearr_121463_121505[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (14))){
var inst_121351 = (state_121430[(13)]);
var state_121430__$1 = state_121430;
var statearr_121464_121506 = state_121430__$1;
(statearr_121464_121506[(2)] = inst_121351);

(statearr_121464_121506[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (26))){
var inst_121333 = (state_121430[(7)]);
var inst_121389 = (state_121430[(19)]);
var inst_121408 = (state_121430[(2)]);
var inst_121409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121408,(0),null);
var inst_121410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121408,(1),null);
var inst_121411 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_121333);
var inst_121412 = fluree.db.query.fql.s(f);
var inst_121413 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_121411,inst_121412);
var inst_121414 = cljs.core.empty_QMARK_(inst_121389);
var inst_121415 = ((inst_121413) || (inst_121414));
var state_121430__$1 = (function (){var statearr_121465 = state_121430;
(statearr_121465[(22)] = inst_121410);

(statearr_121465[(17)] = inst_121409);

return statearr_121465;
})();
if(cljs.core.truth_(inst_121415)){
var statearr_121466_121507 = state_121430__$1;
(statearr_121466_121507[(1)] = (29));

} else {
var statearr_121467_121508 = state_121430__$1;
(statearr_121467_121508[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (16))){
var inst_121340 = (state_121430[(12)]);
var inst_121339 = (state_121430[(21)]);
var inst_121330 = (state_121430[(8)]);
var inst_121333 = (state_121430[(7)]);
var inst_121331 = (state_121430[(9)]);
var inst_121332 = (state_121430[(10)]);
var inst_121360 = (state_121430[(15)]);
var inst_121359 = (state_121430[(16)]);
var inst_121362 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121333,inst_121360);
var inst_121363 = (function (){var seq__121327 = inst_121331;
var vec__121326 = new_child_paths;
var first__121337 = inst_121339;
var keys_SINGLEQUOTE_ = inst_121360;
var r = inst_121340;
var child_path = inst_121359;
var G__121325 = inst_121332;
var first__121328 = inst_121330;
var vec__121335 = inst_121332;
var acc__$1 = inst_121333;
var value = inst_121362;
var seq__121336 = inst_121340;
return ((function (seq__121327,vec__121326,first__121337,keys_SINGLEQUOTE_,r,child_path,G__121325,first__121328,vec__121335,acc__$1,value,seq__121336,inst_121340,inst_121339,inst_121330,inst_121333,inst_121331,inst_121332,inst_121360,inst_121359,inst_121362,state_val_121431,c__110077__auto__){
return (function (p1__121317_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(p1__121317_SHARP_),cljs.core.first(child_path));
});
;})(seq__121327,vec__121326,first__121337,keys_SINGLEQUOTE_,r,child_path,G__121325,first__121328,vec__121335,acc__$1,value,seq__121336,inst_121340,inst_121339,inst_121330,inst_121333,inst_121331,inst_121332,inst_121360,inst_121359,inst_121362,state_val_121431,c__110077__auto__))
})();
var inst_121364 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_121363,inst_121362);
var inst_121365 = cljs.core.first(inst_121364);
var inst_121366 = inst_121362.indexOf(inst_121365);
var inst_121367 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_121360,inst_121366);
var inst_121368 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_121367,k);
var inst_121369 = cljs.core.rest(inst_121359);
var inst_121370 = cljs.core.count(inst_121369);
var inst_121371 = (inst_121370 > (0));
var state_121430__$1 = (function (){var statearr_121468 = state_121430;
(statearr_121468[(20)] = inst_121368);

return statearr_121468;
})();
if(cljs.core.truth_(inst_121371)){
var statearr_121469_121509 = state_121430__$1;
(statearr_121469_121509[(1)] = (18));

} else {
var statearr_121470_121510 = state_121430__$1;
(statearr_121470_121510[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (30))){
var inst_121333 = (state_121430[(7)]);
var inst_121389 = (state_121430[(19)]);
var inst_121409 = (state_121430[(17)]);
var inst_121418 = cljs.core.assoc_in(inst_121333,inst_121389,inst_121409);
var state_121430__$1 = state_121430;
var statearr_121471_121511 = state_121430__$1;
(statearr_121471_121511[(2)] = inst_121418);

(statearr_121471_121511[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (10))){
var inst_121339 = (state_121430[(21)]);
var state_121430__$1 = state_121430;
var statearr_121472_121512 = state_121430__$1;
(statearr_121472_121512[(2)] = inst_121339);

(statearr_121472_121512[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (18))){
var inst_121368 = (state_121430[(20)]);
var inst_121359 = (state_121430[(16)]);
var inst_121373 = cljs.core.rest(inst_121359);
var inst_121359__$1 = inst_121373;
var inst_121360 = inst_121368;
var state_121430__$1 = (function (){var statearr_121473 = state_121430;
(statearr_121473[(15)] = inst_121360);

(statearr_121473[(16)] = inst_121359__$1);

return statearr_121473;
})();
var statearr_121474_121513 = state_121430__$1;
(statearr_121474_121513[(2)] = null);

(statearr_121474_121513[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121431 === (8))){
var state_121430__$1 = state_121430;
if(cljs.core.truth_(parent_exists)){
var statearr_121475_121514 = state_121430__$1;
(statearr_121475_121514[(1)] = (10));

} else {
var statearr_121476_121515 = state_121430__$1;
(statearr_121476_121515[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____0 = (function (){
var statearr_121477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121477[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__);

(statearr_121477[(1)] = (1));

return statearr_121477;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____1 = (function (state_121430){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_121430);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e121478){if((e121478 instanceof Object)){
var ex__109974__auto__ = e121478;
var statearr_121479_121516 = state_121430;
(statearr_121479_121516[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_121430);

return cljs.core.cst$kw$recur;
} else {
throw e121478;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__121517 = state_121430;
state_121430 = G__121517;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__ = function(state_121430){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____1.call(this,state_121430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_121480 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_121480[(6)] = c__110077__auto__);

return statearr_121480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_121627){
var state_val_121628 = (state_121627[(1)]);
if((state_val_121628 === (7))){
var inst_121542 = (state_121627[(7)]);
var inst_121538 = (state_121627[(8)]);
var inst_121527 = (state_121627[(9)]);
var inst_121538__$1 = (state_121627[(2)]);
var inst_121539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121540 = [inst_121538__$1,inst_121527];
var inst_121541 = (new cljs.core.PersistentVector(null,2,(5),inst_121539,inst_121540,null));
var inst_121542__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_121541);
var state_121627__$1 = (function (){var statearr_121629 = state_121627;
(statearr_121629[(7)] = inst_121542__$1);

(statearr_121629[(8)] = inst_121538__$1);

return statearr_121629;
})();
if(cljs.core.truth_(inst_121542__$1)){
var statearr_121630_121689 = state_121627__$1;
(statearr_121630_121689[(1)] = (11));

} else {
var statearr_121631_121690 = state_121627__$1;
(statearr_121631_121690[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (20))){
var inst_121569 = (state_121627[(10)]);
var inst_121571 = f.o;
var inst_121572 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_121571,inst_121569);
var state_121627__$1 = state_121627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121627__$1,(23),inst_121572);
} else {
if((state_val_121628 === (27))){
var inst_121589 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
if(cljs.core.truth_(inst_121589)){
var statearr_121632_121691 = state_121627__$1;
(statearr_121632_121691[(1)] = (28));

} else {
var statearr_121633_121692 = state_121627__$1;
(statearr_121633_121692[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (1))){
var state_121627__$1 = state_121627;
var statearr_121634_121693 = state_121627__$1;
(statearr_121634_121693[(2)] = null);

(statearr_121634_121693[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (24))){
var inst_121556 = (state_121627[(11)]);
var inst_121583 = (state_121627[(2)]);
var inst_121584 = fluree.db.util.async.throw_err(inst_121583);
var state_121627__$1 = (function (){var statearr_121635 = state_121627;
(statearr_121635[(12)] = inst_121584);

return statearr_121635;
})();
if(cljs.core.truth_(inst_121556)){
var statearr_121636_121694 = state_121627__$1;
(statearr_121636_121694[(1)] = (25));

} else {
var statearr_121637_121695 = state_121627__$1;
(statearr_121637_121695[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (39))){
var inst_121606 = (state_121627[(13)]);
var state_121627__$1 = state_121627;
var statearr_121638_121696 = state_121627__$1;
(statearr_121638_121696[(2)] = inst_121606);

(statearr_121638_121696[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (4))){
var inst_121528 = (state_121627[(14)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_121627,(3),Error,null,(2));
var inst_121525 = fluree.db.query.fql.s(f);
var inst_121526 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$_id,inst_121525);
var inst_121527 = fluree.db.query.fql.o(f);
var inst_121528__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121627__$1 = (function (){var statearr_121639 = state_121627;
(statearr_121639[(14)] = inst_121528__$1);

(statearr_121639[(15)] = inst_121526);

(statearr_121639[(9)] = inst_121527);

return statearr_121639;
})();
if(cljs.core.truth_(inst_121528__$1)){
var statearr_121640_121697 = state_121627__$1;
(statearr_121640_121697[(1)] = (5));

} else {
var statearr_121641_121698 = state_121627__$1;
(statearr_121641_121698[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (15))){
var inst_121550 = (state_121627[(16)]);
var inst_121559 = cljs.core.not(inst_121550);
var state_121627__$1 = state_121627;
var statearr_121642_121699 = state_121627__$1;
(statearr_121642_121699[(2)] = inst_121559);

(statearr_121642_121699[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (21))){
var state_121627__$1 = state_121627;
var statearr_121643_121700 = state_121627__$1;
(statearr_121643_121700[(2)] = null);

(statearr_121643_121700[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (31))){
var inst_121580 = (state_121627[(17)]);
var inst_121594 = cljs.core.rest(flakes);
var inst_121595 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_121594,inst_121580);
var state_121627__$1 = state_121627;
var statearr_121644_121701 = state_121627__$1;
(statearr_121644_121701[(2)] = inst_121595);

(statearr_121644_121701[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (32))){
var state_121627__$1 = state_121627;
var statearr_121645_121702 = state_121627__$1;
(statearr_121645_121702[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (40))){
var inst_121598 = (state_121627[(18)]);
var inst_121612 = (state_121627[(2)]);
var inst_121613 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_121598,inst_121612);
var state_121627__$1 = state_121627;
var statearr_121647_121703 = state_121627__$1;
(statearr_121647_121703[(2)] = inst_121613);

(statearr_121647_121703[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (33))){
var inst_121618 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
var statearr_121648_121704 = state_121627__$1;
(statearr_121648_121704[(2)] = inst_121618);

(statearr_121648_121704[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (13))){
var inst_121556 = (state_121627[(11)]);
var inst_121549 = (state_121627[(19)]);
var inst_121538 = (state_121627[(8)]);
var inst_121546 = (state_121627[(2)]);
var inst_121547 = fluree.db.query.fql.get_recursion_map_multi(recursion_map,inst_121538,f,select_spec,inst_121546);
var inst_121548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121547,(0),null);
var inst_121549__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121547,(1),null);
var inst_121550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_121547,(2),null);
var inst_121551 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_121552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121553 = [inst_121538,cljs.core.cst$kw$depth];
var inst_121554 = (new cljs.core.PersistentVector(null,2,(5),inst_121552,inst_121553,null));
var inst_121555 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121549__$1,inst_121554);
var inst_121556__$1 = (inst_121551 < inst_121555);
var state_121627__$1 = (function (){var statearr_121649 = state_121627;
(statearr_121649[(11)] = inst_121556__$1);

(statearr_121649[(19)] = inst_121549__$1);

(statearr_121649[(16)] = inst_121550);

(statearr_121649[(20)] = inst_121548);

return statearr_121649;
})();
if(cljs.core.truth_(inst_121556__$1)){
var statearr_121650_121705 = state_121627__$1;
(statearr_121650_121705[(1)] = (14));

} else {
var statearr_121651_121706 = state_121627__$1;
(statearr_121651_121706[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (22))){
var inst_121578 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
var statearr_121652_121707 = state_121627__$1;
(statearr_121652_121707[(2)] = inst_121578);

(statearr_121652_121707[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (36))){
var inst_121616 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
var statearr_121653_121708 = state_121627__$1;
(statearr_121653_121708[(2)] = inst_121616);

(statearr_121653_121708[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (29))){
var inst_121580 = (state_121627[(17)]);
var state_121627__$1 = state_121627;
if(cljs.core.truth_(inst_121580)){
var statearr_121654_121709 = state_121627__$1;
(statearr_121654_121709[(1)] = (31));

} else {
var statearr_121655_121710 = state_121627__$1;
(statearr_121655_121710[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (6))){
var inst_121531 = (state_121627[(21)]);
var inst_121531__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121627__$1 = (function (){var statearr_121656 = state_121627;
(statearr_121656[(21)] = inst_121531__$1);

return statearr_121656;
})();
if(cljs.core.truth_(inst_121531__$1)){
var statearr_121657_121711 = state_121627__$1;
(statearr_121657_121711[(1)] = (8));

} else {
var statearr_121658_121712 = state_121627__$1;
(statearr_121658_121712[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (28))){
var inst_121591 = cljs.core.rest(flakes);
var state_121627__$1 = state_121627;
var statearr_121659_121713 = state_121627__$1;
(statearr_121659_121713[(2)] = inst_121591);

(statearr_121659_121713[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (25))){
var inst_121556 = (state_121627[(11)]);
var state_121627__$1 = state_121627;
var statearr_121660_121714 = state_121627__$1;
(statearr_121660_121714[(2)] = inst_121556);

(statearr_121660_121714[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (34))){
var inst_121527 = (state_121627[(9)]);
var inst_121598 = cljs.core.rest(flakes);
var inst_121600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121601 = [inst_121527];
var inst_121602 = (new cljs.core.PersistentVector(null,1,(5),inst_121600,inst_121601,null));
var inst_121603 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_121602);
var state_121627__$1 = (function (){var statearr_121661 = state_121627;
(statearr_121661[(18)] = inst_121598);

return statearr_121661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121627__$1,(37),inst_121603);
} else {
if((state_val_121628 === (17))){
var state_121627__$1 = state_121627;
var statearr_121662_121715 = state_121627__$1;
(statearr_121662_121715[(2)] = null);

(statearr_121662_121715[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (3))){
var inst_121518 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
var statearr_121663_121716 = state_121627__$1;
(statearr_121663_121716[(2)] = inst_121518);


cljs.core.async.impl.ioc_helpers.process_exception(state_121627__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (12))){
var state_121627__$1 = state_121627;
var statearr_121664_121717 = state_121627__$1;
(statearr_121664_121717[(2)] = false);

(statearr_121664_121717[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (2))){
var inst_121625 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_121627__$1,inst_121625);
} else {
if((state_val_121628 === (23))){
var inst_121574 = (state_121627[(2)]);
var inst_121575 = fluree.db.util.async.throw_err(inst_121574);
var state_121627__$1 = state_121627;
var statearr_121665_121718 = state_121627__$1;
(statearr_121665_121718[(2)] = inst_121575);

(statearr_121665_121718[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (35))){
var state_121627__$1 = state_121627;
var statearr_121666_121719 = state_121627__$1;
(statearr_121666_121719[(2)] = null);

(statearr_121666_121719[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (19))){
var inst_121538 = (state_121627[(8)]);
var inst_121526 = (state_121627[(15)]);
var inst_121548 = (state_121627[(20)]);
var inst_121580 = (state_121627[(2)]);
var inst_121581 = fluree.db.query.fql.add_in_multi_flakes(inst_121526,inst_121548,inst_121538,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_121627__$1 = (function (){var statearr_121667 = state_121627;
(statearr_121667[(17)] = inst_121580);

return statearr_121667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121627__$1,(24),inst_121581);
} else {
if((state_val_121628 === (11))){
var inst_121542 = (state_121627[(7)]);
var state_121627__$1 = state_121627;
var statearr_121668_121720 = state_121627__$1;
(statearr_121668_121720[(2)] = inst_121542);

(statearr_121668_121720[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (9))){
var inst_121534 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121627__$1 = state_121627;
var statearr_121669_121721 = state_121627__$1;
(statearr_121669_121721[(2)] = inst_121534);

(statearr_121669_121721[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (5))){
var inst_121528 = (state_121627[(14)]);
var state_121627__$1 = state_121627;
var statearr_121670_121722 = state_121627__$1;
(statearr_121670_121722[(2)] = inst_121528);

(statearr_121670_121722[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (14))){
var inst_121556 = (state_121627[(11)]);
var state_121627__$1 = state_121627;
var statearr_121671_121723 = state_121627__$1;
(statearr_121671_121723[(2)] = inst_121556);

(statearr_121671_121723[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (26))){
var inst_121550 = (state_121627[(16)]);
var inst_121587 = cljs.core.not(inst_121550);
var state_121627__$1 = state_121627;
var statearr_121672_121724 = state_121627__$1;
(statearr_121672_121724[(2)] = inst_121587);

(statearr_121672_121724[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (16))){
var inst_121561 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
if(cljs.core.truth_(inst_121561)){
var statearr_121673_121725 = state_121627__$1;
(statearr_121673_121725[(1)] = (17));

} else {
var statearr_121674_121726 = state_121627__$1;
(statearr_121674_121726[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (38))){
var inst_121606 = (state_121627[(13)]);
var inst_121608 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_121609 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_121608,inst_121606);
var state_121627__$1 = state_121627;
var statearr_121675_121727 = state_121627__$1;
(statearr_121675_121727[(2)] = inst_121609);

(statearr_121675_121727[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (30))){
var inst_121584 = (state_121627[(12)]);
var inst_121549 = (state_121627[(19)]);
var inst_121620 = (state_121627[(2)]);
var inst_121621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121622 = [inst_121584,inst_121620,inst_121549];
var inst_121623 = (new cljs.core.PersistentVector(null,3,(5),inst_121621,inst_121622,null));
var state_121627__$1 = state_121627;
var statearr_121676_121728 = state_121627__$1;
(statearr_121676_121728[(2)] = inst_121623);


cljs.core.async.impl.ioc_helpers.process_exception(state_121627__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (10))){
var inst_121536 = (state_121627[(2)]);
var state_121627__$1 = state_121627;
var statearr_121677_121729 = state_121627__$1;
(statearr_121677_121729[(2)] = inst_121536);

(statearr_121677_121729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (18))){
var inst_121549 = (state_121627[(19)]);
var inst_121569 = (state_121627[(10)]);
var inst_121564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121565 = f.p;
var inst_121566 = [cljs.core.cst$kw$select_DASH_specs,inst_121565];
var inst_121567 = (new cljs.core.PersistentVector(null,2,(5),inst_121564,inst_121566,null));
var inst_121568 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121549,inst_121567);
var inst_121569__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_121568);
var state_121627__$1 = (function (){var statearr_121678 = state_121627;
(statearr_121678[(10)] = inst_121569__$1);

return statearr_121678;
})();
if(cljs.core.truth_(inst_121569__$1)){
var statearr_121679_121730 = state_121627__$1;
(statearr_121679_121730[(1)] = (20));

} else {
var statearr_121680_121731 = state_121627__$1;
(statearr_121680_121731[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (37))){
var inst_121605 = (state_121627[(2)]);
var inst_121606 = fluree.db.util.async.throw_err(inst_121605);
var state_121627__$1 = (function (){var statearr_121681 = state_121627;
(statearr_121681[(13)] = inst_121606);

return statearr_121681;
})();
if(cljs.core.truth_(fuel)){
var statearr_121682_121732 = state_121627__$1;
(statearr_121682_121732[(1)] = (38));

} else {
var statearr_121683_121733 = state_121627__$1;
(statearr_121683_121733[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121628 === (8))){
var inst_121531 = (state_121627[(21)]);
var state_121627__$1 = state_121627;
var statearr_121684_121734 = state_121627__$1;
(statearr_121684_121734[(2)] = inst_121531);

(statearr_121684_121734[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____0 = (function (){
var statearr_121685 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121685[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__);

(statearr_121685[(1)] = (1));

return statearr_121685;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____1 = (function (state_121627){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_121627);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e121686){if((e121686 instanceof Object)){
var ex__109974__auto__ = e121686;
var statearr_121687_121735 = state_121627;
(statearr_121687_121735[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_121627);

return cljs.core.cst$kw$recur;
} else {
throw e121686;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__121736 = state_121627;
state_121627 = G__121736;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__ = function(state_121627){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____1.call(this,state_121627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_121688 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_121688[(6)] = c__110077__auto__);

return statearr_121688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_(select_spec__$1))?fluree.db.query.fql.full_select_spec(db,cache,select_spec__$1,fluree.db.query.fql.s(f)):select_spec__$1);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s(f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_121896){
var state_val_121897 = (state_121896[(1)]);
if((state_val_121897 === (7))){
var inst_121741 = (state_121896[(7)]);
var inst_121761 = (state_121896[(8)]);
var inst_121753 = (state_121896[(9)]);
var inst_121753__$1 = (state_121896[(2)]);
var inst_121754 = cljs.core.PersistentVector.EMPTY;
var inst_121755 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_121753__$1);
var inst_121756 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_121754,inst_121755);
var inst_121757 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc,inst_121756);
var inst_121758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121759 = [inst_121753__$1,inst_121741];
var inst_121760 = (new cljs.core.PersistentVector(null,2,(5),inst_121758,inst_121759,null));
var inst_121761__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_121760);
var state_121896__$1 = (function (){var statearr_121898 = state_121896;
(statearr_121898[(10)] = inst_121757);

(statearr_121898[(8)] = inst_121761__$1);

(statearr_121898[(9)] = inst_121753__$1);

return statearr_121898;
})();
if(cljs.core.truth_(inst_121761__$1)){
var statearr_121899_121990 = state_121896__$1;
(statearr_121899_121990[(1)] = (11));

} else {
var statearr_121900_121991 = state_121896__$1;
(statearr_121900_121991[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (59))){
var inst_121878 = (state_121896[(11)]);
var state_121896__$1 = state_121896;
var statearr_121901_121992 = state_121896__$1;
(statearr_121901_121992[(2)] = inst_121878);

(statearr_121901_121992[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (20))){
var inst_121785 = (state_121896[(12)]);
var state_121896__$1 = state_121896;
var statearr_121902_121993 = state_121896__$1;
(statearr_121902_121993[(2)] = inst_121785);

(statearr_121902_121993[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (58))){
var inst_121878 = (state_121896[(11)]);
var inst_121880 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_121881 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_121880,inst_121878);
var state_121896__$1 = state_121896;
var statearr_121903_121994 = state_121896__$1;
(statearr_121903_121994[(2)] = inst_121881);

(statearr_121903_121994[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (60))){
var inst_121870 = (state_121896[(13)]);
var inst_121884 = (state_121896[(2)]);
var inst_121885 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_121870,inst_121884);
var state_121896__$1 = state_121896;
var statearr_121904_121995 = state_121896__$1;
(statearr_121904_121995[(2)] = inst_121885);

(statearr_121904_121995[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (27))){
var state_121896__$1 = state_121896;
var statearr_121905_121996 = state_121896__$1;
(statearr_121905_121996[(2)] = null);

(statearr_121905_121996[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (1))){
var state_121896__$1 = state_121896;
var statearr_121906_121997 = state_121896__$1;
(statearr_121906_121997[(2)] = null);

(statearr_121906_121997[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (24))){
var inst_121797 = (state_121896[(14)]);
var inst_121780 = (state_121896[(15)]);
var inst_121792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121793 = f.p;
var inst_121794 = [cljs.core.cst$kw$select_DASH_specs,inst_121793];
var inst_121795 = (new cljs.core.PersistentVector(null,2,(5),inst_121792,inst_121794,null));
var inst_121796 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_121780,inst_121795);
var inst_121797__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_121796);
var state_121896__$1 = (function (){var statearr_121907 = state_121896;
(statearr_121907[(14)] = inst_121797__$1);

return statearr_121907;
})();
if(cljs.core.truth_(inst_121797__$1)){
var statearr_121908_121998 = state_121896__$1;
(statearr_121908_121998[(1)] = (26));

} else {
var statearr_121909_121999 = state_121896__$1;
(statearr_121909_121999[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (55))){
var inst_121741 = (state_121896[(7)]);
var inst_121870 = cljs.core.rest(flakes);
var inst_121872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121873 = [inst_121741];
var inst_121874 = (new cljs.core.PersistentVector(null,1,(5),inst_121872,inst_121873,null));
var inst_121875 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_121874);
var state_121896__$1 = (function (){var statearr_121910 = state_121896;
(statearr_121910[(13)] = inst_121870);

return statearr_121910;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121896__$1,(57),inst_121875);
} else {
if((state_val_121897 === (39))){
var inst_121838 = (state_121896[(16)]);
var inst_121808 = (state_121896[(17)]);
var inst_121753 = (state_121896[(9)]);
var inst_121840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121838,inst_121753);
var inst_121841 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_121840,inst_121808], 0));
var inst_121842 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_121838,inst_121753,inst_121841);
var state_121896__$1 = state_121896;
var statearr_121911_122000 = state_121896__$1;
(statearr_121911_122000[(2)] = inst_121842);

(statearr_121911_122000[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (46))){
var state_121896__$1 = state_121896;
var statearr_121912_122001 = state_121896__$1;
(statearr_121912_122001[(1)] = (48));



return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (4))){
var inst_121743 = (state_121896[(18)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_121896,(3),Error,null,(2));
var inst_121741 = f.o;
var inst_121742 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_121743__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121896__$1 = (function (){var statearr_121914 = state_121896;
(statearr_121914[(19)] = inst_121742);

(statearr_121914[(7)] = inst_121741);

(statearr_121914[(18)] = inst_121743__$1);

return statearr_121914;
})();
if(cljs.core.truth_(inst_121743__$1)){
var statearr_121915_122002 = state_121896__$1;
(statearr_121915_122002[(1)] = (5));

} else {
var statearr_121916_122003 = state_121896__$1;
(statearr_121916_122003[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (54))){
var inst_121868 = cljs.core.rest(flakes);
var state_121896__$1 = state_121896;
var statearr_121917_122004 = state_121896__$1;
(statearr_121917_122004[(2)] = inst_121868);

(statearr_121917_122004[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (15))){
var state_121896__$1 = state_121896;
var statearr_121918_122005 = state_121896__$1;
(statearr_121918_122005[(2)] = recursion_map);

(statearr_121918_122005[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (48))){
var inst_121845 = (state_121896[(20)]);
var inst_121753 = (state_121896[(9)]);
var inst_121852 = cljs.core.PersistentVector.EMPTY;
var inst_121853 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_121753);
var inst_121854 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_121852,inst_121853);
var inst_121855 = cljs.core.assoc_in(acc,inst_121854,inst_121845);
var state_121896__$1 = state_121896;
var statearr_121919_122006 = state_121896__$1;
(statearr_121919_122006[(2)] = inst_121855);

(statearr_121919_122006[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (50))){
var inst_121858 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121920_122007 = state_121896__$1;
(statearr_121920_122007[(2)] = inst_121858);

(statearr_121920_122007[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (21))){
var inst_121765 = (state_121896[(21)]);
var state_121896__$1 = state_121896;
var statearr_121921_122008 = state_121896__$1;
(statearr_121921_122008[(2)] = inst_121765);

(statearr_121921_122008[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (31))){
var inst_121742 = (state_121896[(19)]);
var state_121896__$1 = state_121896;
var statearr_121922_122009 = state_121896__$1;
(statearr_121922_122009[(2)] = inst_121742);

(statearr_121922_122009[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (32))){
var inst_121816 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
if(cljs.core.truth_(inst_121816)){
var statearr_121923_122010 = state_121896__$1;
(statearr_121923_122010[(1)] = (33));

} else {
var statearr_121924_122011 = state_121896__$1;
(statearr_121924_122011[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (40))){
var inst_121838 = (state_121896[(16)]);
var state_121896__$1 = state_121896;
var statearr_121925_122012 = state_121896__$1;
(statearr_121925_122012[(2)] = inst_121838);

(statearr_121925_122012[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (56))){
var inst_121862 = (state_121896[(22)]);
var inst_121780 = (state_121896[(15)]);
var inst_121887 = (state_121896[(2)]);
var inst_121888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121889 = [inst_121862,inst_121887,inst_121780];
var inst_121890 = (new cljs.core.PersistentVector(null,3,(5),inst_121888,inst_121889,null));
var state_121896__$1 = state_121896;
var statearr_121926_122013 = state_121896__$1;
(statearr_121926_122013[(2)] = inst_121890);

(statearr_121926_122013[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (33))){
var inst_121780 = (state_121896[(15)]);
var inst_121818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121819 = cljs.core.rest(flakes);
var inst_121820 = [acc,inst_121819,inst_121780];
var inst_121821 = (new cljs.core.PersistentVector(null,3,(5),inst_121818,inst_121820,null));
var state_121896__$1 = state_121896;
var statearr_121927_122014 = state_121896__$1;
(statearr_121927_122014[(2)] = inst_121821);

(statearr_121927_122014[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (13))){
var inst_121765 = (state_121896[(21)]);
var inst_121765__$1 = (state_121896[(2)]);
var inst_121766 = cljs.core.not(inst_121765__$1);
var state_121896__$1 = (function (){var statearr_121928 = state_121896;
(statearr_121928[(21)] = inst_121765__$1);

return statearr_121928;
})();
if(inst_121766){
var statearr_121929_122015 = state_121896__$1;
(statearr_121929_122015[(1)] = (14));

} else {
var statearr_121930_122016 = state_121896__$1;
(statearr_121930_122016[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (22))){
var inst_121789 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
if(cljs.core.truth_(inst_121789)){
var statearr_121931_122017 = state_121896__$1;
(statearr_121931_122017[(1)] = (23));

} else {
var statearr_121932_122018 = state_121896__$1;
(statearr_121932_122018[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (36))){
var inst_121757 = (state_121896[(10)]);
var inst_121741 = (state_121896[(7)]);
var inst_121753 = (state_121896[(9)]);
var inst_121824 = cljs.core.PersistentVector.EMPTY;
var inst_121825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121757,inst_121753);
var inst_121826 = [cljs.core.cst$kw$_id];
var inst_121827 = [inst_121741];
var inst_121828 = cljs.core.PersistentHashMap.fromArrays(inst_121826,inst_121827);
var inst_121829 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_121825,inst_121828);
var inst_121830 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_121824,inst_121829);
var inst_121831 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_121757,inst_121753,inst_121830);
var state_121896__$1 = state_121896;
var statearr_121933_122019 = state_121896__$1;
(statearr_121933_122019[(2)] = inst_121831);

(statearr_121933_122019[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (41))){
var inst_121765 = (state_121896[(21)]);
var inst_121845 = (state_121896[(2)]);
var inst_121846 = cljs.core.not(inst_121765);
var state_121896__$1 = (function (){var statearr_121934 = state_121896;
(statearr_121934[(20)] = inst_121845);

return statearr_121934;
})();
if(inst_121846){
var statearr_121935_122020 = state_121896__$1;
(statearr_121935_122020[(1)] = (42));

} else {
var statearr_121936_122021 = state_121896__$1;
(statearr_121936_122021[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (43))){
var inst_121765 = (state_121896[(21)]);
var state_121896__$1 = state_121896;
if(cljs.core.truth_(inst_121765)){
var statearr_121937_122022 = state_121896__$1;
(statearr_121937_122022[(1)] = (45));

} else {
var statearr_121938_122023 = state_121896__$1;
(statearr_121938_122023[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (29))){
var inst_121802 = (state_121896[(2)]);
var inst_121803 = fluree.db.util.async.throw_err(inst_121802);
var state_121896__$1 = state_121896;
var statearr_121939_122024 = state_121896__$1;
(statearr_121939_122024[(2)] = inst_121803);

(statearr_121939_122024[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (44))){
var inst_121785 = (state_121896[(12)]);
var inst_121862 = (state_121896[(2)]);
var state_121896__$1 = (function (){var statearr_121940 = state_121896;
(statearr_121940[(22)] = inst_121862);

return statearr_121940;
})();
if(cljs.core.truth_(inst_121785)){
var statearr_121941_122025 = state_121896__$1;
(statearr_121941_122025[(1)] = (51));

} else {
var statearr_121942_122026 = state_121896__$1;
(statearr_121942_122026[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (6))){
var inst_121746 = (state_121896[(23)]);
var inst_121746__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121896__$1 = (function (){var statearr_121943 = state_121896;
(statearr_121943[(23)] = inst_121746__$1);

return statearr_121943;
})();
if(cljs.core.truth_(inst_121746__$1)){
var statearr_121944_122027 = state_121896__$1;
(statearr_121944_122027[(1)] = (8));

} else {
var statearr_121945_122028 = state_121896__$1;
(statearr_121945_122028[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (28))){
var inst_121806 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121946_122029 = state_121896__$1;
(statearr_121946_122029[(2)] = inst_121806);

(statearr_121946_122029[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (51))){
var inst_121785 = (state_121896[(12)]);
var state_121896__$1 = state_121896;
var statearr_121947_122030 = state_121896__$1;
(statearr_121947_122030[(2)] = inst_121785);

(statearr_121947_122030[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (25))){
var inst_121742 = (state_121896[(19)]);
var inst_121808 = (state_121896[(2)]);
var state_121896__$1 = (function (){var statearr_121948 = state_121896;
(statearr_121948[(17)] = inst_121808);

return statearr_121948;
})();
if(cljs.core.truth_(inst_121742)){
var statearr_121949_122031 = state_121896__$1;
(statearr_121949_122031[(1)] = (30));

} else {
var statearr_121950_122032 = state_121896__$1;
(statearr_121950_122032[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (34))){
var inst_121742 = (state_121896[(19)]);
var state_121896__$1 = state_121896;
if(cljs.core.truth_(inst_121742)){
var statearr_121951_122033 = state_121896__$1;
(statearr_121951_122033[(1)] = (36));

} else {
var statearr_121952_122034 = state_121896__$1;
(statearr_121952_122034[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (17))){
var inst_121771 = (state_121896[(24)]);
var state_121896__$1 = state_121896;
var statearr_121953_122035 = state_121896__$1;
(statearr_121953_122035[(2)] = inst_121771);

(statearr_121953_122035[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (3))){
var inst_121737 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121954_122036 = state_121896__$1;
(statearr_121954_122036[(2)] = inst_121737);


cljs.core.async.impl.ioc_helpers.process_exception(state_121896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (12))){
var state_121896__$1 = state_121896;
var statearr_121955_122037 = state_121896__$1;
(statearr_121955_122037[(2)] = false);

(statearr_121955_122037[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (2))){
var inst_121894 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_121896__$1,inst_121894);
} else {
if((state_val_121897 === (23))){
var state_121896__$1 = state_121896;
var statearr_121956_122038 = state_121896__$1;
(statearr_121956_122038[(2)] = null);

(statearr_121956_122038[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (47))){
var inst_121860 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121957_122039 = state_121896__$1;
(statearr_121957_122039[(2)] = inst_121860);

(statearr_121957_122039[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (35))){
var inst_121892 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121958_122040 = state_121896__$1;
(statearr_121958_122040[(2)] = inst_121892);


cljs.core.async.impl.ioc_helpers.process_exception(state_121896__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (19))){
var inst_121785 = (state_121896[(12)]);
var inst_121780 = (state_121896[(15)]);
var inst_121753 = (state_121896[(9)]);
var inst_121780__$1 = (state_121896[(2)]);
var inst_121781 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_121782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121780__$1,inst_121753);
var inst_121783 = cljs.core.vals(inst_121782);
var inst_121784 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,inst_121783);
var inst_121785__$1 = (inst_121781 < inst_121784);
var state_121896__$1 = (function (){var statearr_121959 = state_121896;
(statearr_121959[(12)] = inst_121785__$1);

(statearr_121959[(15)] = inst_121780__$1);

return statearr_121959;
})();
if(cljs.core.truth_(inst_121785__$1)){
var statearr_121960_122041 = state_121896__$1;
(statearr_121960_122041[(1)] = (20));

} else {
var statearr_121961_122042 = state_121896__$1;
(statearr_121961_122042[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (57))){
var inst_121877 = (state_121896[(2)]);
var inst_121878 = fluree.db.util.async.throw_err(inst_121877);
var state_121896__$1 = (function (){var statearr_121962 = state_121896;
(statearr_121962[(11)] = inst_121878);

return statearr_121962;
})();
if(cljs.core.truth_(fuel)){
var statearr_121963_122043 = state_121896__$1;
(statearr_121963_122043[(1)] = (58));

} else {
var statearr_121964_122044 = state_121896__$1;
(statearr_121964_122044[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (11))){
var inst_121761 = (state_121896[(8)]);
var state_121896__$1 = state_121896;
var statearr_121965_122045 = state_121896__$1;
(statearr_121965_122045[(2)] = inst_121761);

(statearr_121965_122045[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (9))){
var inst_121749 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_121896__$1 = state_121896;
var statearr_121966_122046 = state_121896__$1;
(statearr_121966_122046[(2)] = inst_121749);

(statearr_121966_122046[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (5))){
var inst_121743 = (state_121896[(18)]);
var state_121896__$1 = state_121896;
var statearr_121967_122047 = state_121896__$1;
(statearr_121967_122047[(2)] = inst_121743);

(statearr_121967_122047[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (14))){
var inst_121753 = (state_121896[(9)]);
var inst_121768 = fluree.db.query.fql.get_recursion_map(db,recursion_map,select_spec,cache,inst_121753,f);
var state_121896__$1 = state_121896;
var statearr_121968_122048 = state_121896__$1;
(statearr_121968_122048[(2)] = inst_121768);

(statearr_121968_122048[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (45))){
var state_121896__$1 = state_121896;
var statearr_121969_122049 = state_121896__$1;
(statearr_121969_122049[(2)] = acc);

(statearr_121969_122049[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (53))){
var inst_121866 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
if(cljs.core.truth_(inst_121866)){
var statearr_121970_122050 = state_121896__$1;
(statearr_121970_122050[(1)] = (54));

} else {
var statearr_121971_122051 = state_121896__$1;
(statearr_121971_122051[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (26))){
var inst_121797 = (state_121896[(14)]);
var inst_121799 = f.o;
var inst_121800 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_121799,inst_121797);
var state_121896__$1 = state_121896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_121896__$1,(29),inst_121800);
} else {
if((state_val_121897 === (16))){
var inst_121765 = (state_121896[(21)]);
var inst_121771 = (state_121896[(2)]);
var state_121896__$1 = (function (){var statearr_121972 = state_121896;
(statearr_121972[(24)] = inst_121771);

return statearr_121972;
})();
if(cljs.core.truth_(inst_121765)){
var statearr_121973_122052 = state_121896__$1;
(statearr_121973_122052[(1)] = (17));

} else {
var statearr_121974_122053 = state_121896__$1;
(statearr_121974_122053[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (38))){
var inst_121808 = (state_121896[(17)]);
var inst_121838 = (state_121896[(2)]);
var state_121896__$1 = (function (){var statearr_121975 = state_121896;
(statearr_121975[(16)] = inst_121838);

return statearr_121975;
})();
if(cljs.core.truth_(inst_121808)){
var statearr_121976_122054 = state_121896__$1;
(statearr_121976_122054[(1)] = (39));

} else {
var statearr_121977_122055 = state_121896__$1;
(statearr_121977_122055[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (30))){
var inst_121757 = (state_121896[(10)]);
var inst_121753 = (state_121896[(9)]);
var inst_121810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_121757,inst_121753);
var inst_121811 = cljs.core.count(inst_121810);
var inst_121812 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_121813 = (inst_121811 > inst_121812);
var state_121896__$1 = state_121896;
var statearr_121978_122056 = state_121896__$1;
(statearr_121978_122056[(2)] = inst_121813);

(statearr_121978_122056[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (10))){
var inst_121751 = (state_121896[(2)]);
var state_121896__$1 = state_121896;
var statearr_121979_122057 = state_121896__$1;
(statearr_121979_122057[(2)] = inst_121751);

(statearr_121979_122057[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (18))){
var inst_121741 = (state_121896[(7)]);
var inst_121771 = (state_121896[(24)]);
var inst_121753 = (state_121896[(9)]);
var inst_121774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121775 = [inst_121753,inst_121741];
var inst_121776 = (new cljs.core.PersistentVector(null,2,(5),inst_121774,inst_121775,null));
var inst_121777 = ((0) + (1));
var inst_121778 = cljs.core.assoc_in(inst_121771,inst_121776,inst_121777);
var state_121896__$1 = state_121896;
var statearr_121980_122058 = state_121896__$1;
(statearr_121980_122058[(2)] = inst_121778);

(statearr_121980_122058[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (52))){
var inst_121765 = (state_121896[(21)]);
var state_121896__$1 = state_121896;
var statearr_121981_122059 = state_121896__$1;
(statearr_121981_122059[(2)] = inst_121765);

(statearr_121981_122059[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (42))){
var inst_121845 = (state_121896[(20)]);
var state_121896__$1 = state_121896;
var statearr_121982_122060 = state_121896__$1;
(statearr_121982_122060[(2)] = inst_121845);

(statearr_121982_122060[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (37))){
var inst_121757 = (state_121896[(10)]);
var inst_121741 = (state_121896[(7)]);
var inst_121753 = (state_121896[(9)]);
var inst_121833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_121834 = [inst_121753,cljs.core.cst$kw$_id];
var inst_121835 = (new cljs.core.PersistentVector(null,2,(5),inst_121833,inst_121834,null));
var inst_121836 = cljs.core.assoc_in(inst_121757,inst_121835,inst_121741);
var state_121896__$1 = state_121896;
var statearr_121983_122061 = state_121896__$1;
(statearr_121983_122061[(2)] = inst_121836);

(statearr_121983_122061[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (8))){
var inst_121746 = (state_121896[(23)]);
var state_121896__$1 = state_121896;
var statearr_121984_122062 = state_121896__$1;
(statearr_121984_122062[(2)] = inst_121746);

(statearr_121984_122062[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_121897 === (49))){
var state_121896__$1 = state_121896;
var statearr_121985_122063 = state_121896__$1;
(statearr_121985_122063[(2)] = null);

(statearr_121985_122063[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____0 = (function (){
var statearr_121986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_121986[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__);

(statearr_121986[(1)] = (1));

return statearr_121986;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____1 = (function (state_121896){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_121896);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e121987){if((e121987 instanceof Object)){
var ex__109974__auto__ = e121987;
var statearr_121988_122064 = state_121896;
(statearr_121988_122064[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_121896);

return cljs.core.cst$kw$recur;
} else {
throw e121987;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__122065 = state_121896;
state_121896 = G__122065;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__ = function(state_121896){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____1.call(this,state_121896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_121989 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_121989[(6)] = c__110077__auto__);

return statearr_121989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_122249){
var state_val_122250 = (state_122249[(1)]);
if((state_val_122250 === (7))){
var inst_122245 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122251_122331 = state_122249__$1;
(statearr_122251_122331[(2)] = inst_122245);


cljs.core.async.impl.ioc_helpers.process_exception(state_122249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (20))){
var inst_122087 = (state_122249[(7)]);
var inst_122107 = cljs.core.first(flakes);
var inst_122108 = fluree.db.query.fql.s(inst_122107);
var inst_122109 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_122087);
var inst_122110 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_122108,inst_122109);
var state_122249__$1 = state_122249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122249__$1,(23),inst_122110);
} else {
if((state_val_122250 === (27))){
var inst_122136 = (state_122249[(8)]);
var inst_122131 = (state_122249[(9)]);
var inst_122087 = (state_122249[(7)]);
var inst_122120 = (state_122249[(10)]);
var inst_122138 = (state_122249[(11)]);
var inst_122131__$1 = cljs.core.first(inst_122120);
var inst_122132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122133 = inst_122131__$1.p;
var inst_122134 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_122133];
var inst_122135 = (new cljs.core.PersistentVector(null,3,(5),inst_122132,inst_122134,null));
var inst_122136__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_122087,inst_122135);
var inst_122137 = fluree.db.query.fql.component_follow_QMARK_(inst_122136__$1,inst_122087);
var inst_122138__$1 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_122136__$1);
var state_122249__$1 = (function (){var statearr_122252 = state_122249;
(statearr_122252[(8)] = inst_122136__$1);

(statearr_122252[(12)] = inst_122137);

(statearr_122252[(9)] = inst_122131__$1);

(statearr_122252[(11)] = inst_122138__$1);

return statearr_122252;
})();
if(cljs.core.truth_(inst_122138__$1)){
var statearr_122253_122332 = state_122249__$1;
(statearr_122253_122332[(1)] = (29));

} else {
var statearr_122254_122333 = state_122249__$1;
(statearr_122254_122333[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (1))){
var state_122249__$1 = state_122249;
var statearr_122255_122334 = state_122249__$1;
(statearr_122255_122334[(2)] = null);

(statearr_122255_122334[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (24))){
var inst_122120 = (state_122249[(10)]);
var inst_122125 = cljs.core.empty_QMARK_(inst_122120);
var state_122249__$1 = state_122249;
if(inst_122125){
var statearr_122256_122335 = state_122249__$1;
(statearr_122256_122335[(1)] = (26));

} else {
var statearr_122257_122336 = state_122249__$1;
(statearr_122257_122336[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (55))){
var state_122249__$1 = state_122249;
var statearr_122258_122337 = state_122249__$1;
(statearr_122258_122337[(2)] = null);

(statearr_122258_122337[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (39))){
var inst_122154 = (state_122249[(2)]);
var inst_122155 = fluree.db.util.async.throw_err(inst_122154);
var state_122249__$1 = state_122249;
var statearr_122259_122338 = state_122249__$1;
(statearr_122259_122338[(2)] = inst_122155);

(statearr_122259_122338[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (46))){
var inst_122212 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122260_122339 = state_122249__$1;
(statearr_122260_122339[(2)] = inst_122212);

(statearr_122260_122339[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_122249,(3),Error,null,(2));
var inst_122070 = cljs.core.not_empty(flakes);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122070)){
var statearr_122261_122340 = state_122249__$1;
(statearr_122261_122340[(1)] = (5));

} else {
var statearr_122262_122341 = state_122249__$1;
(statearr_122262_122341[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (54))){
var inst_122121 = (state_122249[(13)]);
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122123 = (state_122249[(15)]);
var inst_122202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122203 = cljs.core.rest(inst_122120);
var inst_122204 = [inst_122121,inst_122203,inst_122122,inst_122123];
var inst_122205 = (new cljs.core.PersistentVector(null,4,(5),inst_122202,inst_122204,null));
var state_122249__$1 = state_122249;
var statearr_122263_122342 = state_122249__$1;
(statearr_122263_122342[(2)] = inst_122205);

(statearr_122263_122342[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (15))){
var inst_122087 = (state_122249[(7)]);
var inst_122091 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_122087);
var state_122249__$1 = state_122249;
var statearr_122264_122343 = state_122249__$1;
(statearr_122264_122343[(2)] = inst_122091);

(statearr_122264_122343[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (48))){
var inst_122087 = (state_122249[(7)]);
var inst_122187 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_122087);
var state_122249__$1 = state_122249;
var statearr_122265_122344 = state_122249__$1;
(statearr_122265_122344[(2)] = inst_122187);

(statearr_122265_122344[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (50))){
var inst_122190 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122190)){
var statearr_122266_122345 = state_122249__$1;
(statearr_122266_122345[(1)] = (51));

} else {
var statearr_122267_122346 = state_122249__$1;
(statearr_122267_122346[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (21))){
var inst_122101 = (state_122249[(16)]);
var state_122249__$1 = state_122249;
var statearr_122268_122347 = state_122249__$1;
(statearr_122268_122347[(2)] = inst_122101);

(statearr_122268_122347[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (31))){
var inst_122143 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122143)){
var statearr_122269_122348 = state_122249__$1;
(statearr_122269_122348[(1)] = (32));

} else {
var statearr_122270_122349 = state_122249__$1;
(statearr_122270_122349[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (32))){
var inst_122136 = (state_122249[(8)]);
var inst_122121 = (state_122249[(13)]);
var inst_122131 = (state_122249[(9)]);
var inst_122087 = (state_122249[(7)]);
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122145 = fluree.db.query.fql.flake__GT_recur_multi(db,inst_122131,inst_122136,inst_122122,inst_122120,inst_122121,fuel,max_fuel,inst_122087,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_122249__$1 = state_122249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122249__$1,(35),inst_122145);
} else {
if((state_val_122250 === (40))){
var inst_122136 = (state_122249[(8)]);
var inst_122121 = (state_122249[(13)]);
var inst_122137 = (state_122249[(12)]);
var inst_122131 = (state_122249[(9)]);
var inst_122123 = (state_122249[(15)]);
var inst_122161 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_122121,inst_122136,inst_122131,inst_122137,false,inst_122123);
var state_122249__$1 = state_122249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122249__$1,(43),inst_122161);
} else {
if((state_val_122250 === (56))){
var inst_122208 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122271_122350 = state_122249__$1;
(statearr_122271_122350[(2)] = inst_122208);

(statearr_122271_122350[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (33))){
var inst_122136 = (state_122249[(8)]);
var inst_122150 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_122136);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122150)){
var statearr_122272_122351 = state_122249__$1;
(statearr_122272_122351[(1)] = (36));

} else {
var statearr_122273_122352 = state_122249__$1;
(statearr_122273_122352[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (13))){
var inst_122087 = (state_122249[(7)]);
var inst_122088 = (state_122249[(17)]);
var inst_122087__$1 = (state_122249[(2)]);
var inst_122088__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_122087__$1);
var state_122249__$1 = (function (){var statearr_122274 = state_122249;
(statearr_122274[(7)] = inst_122087__$1);

(statearr_122274[(17)] = inst_122088__$1);

return statearr_122274;
})();
if(cljs.core.truth_(inst_122088__$1)){
var statearr_122275_122353 = state_122249__$1;
(statearr_122275_122353[(1)] = (14));

} else {
var statearr_122276_122354 = state_122249__$1;
(statearr_122276_122354[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (22))){
var inst_122117 = (state_122249[(18)]);
var inst_122117__$1 = (state_122249[(2)]);
var inst_122118 = cljs.core.PersistentHashMap.EMPTY;
var inst_122119 = cljs.core.PersistentHashMap.EMPTY;
var inst_122120 = flakes;
var inst_122121 = inst_122117__$1;
var inst_122122 = inst_122118;
var inst_122123 = inst_122119;
var state_122249__$1 = (function (){var statearr_122277 = state_122249;
(statearr_122277[(13)] = inst_122121);

(statearr_122277[(14)] = inst_122122);

(statearr_122277[(18)] = inst_122117__$1);

(statearr_122277[(10)] = inst_122120);

(statearr_122277[(15)] = inst_122123);

return statearr_122277;
})();
var statearr_122278_122355 = state_122249__$1;
(statearr_122278_122355[(2)] = null);

(statearr_122278_122355[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (36))){
var inst_122136 = (state_122249[(8)]);
var inst_122121 = (state_122249[(13)]);
var inst_122131 = (state_122249[(9)]);
var inst_122087 = (state_122249[(7)]);
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122152 = fluree.db.query.fql.flake__GT_recur(db,inst_122131,inst_122136,inst_122122,inst_122120,inst_122121,fuel,max_fuel,inst_122087,cache);
var state_122249__$1 = state_122249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122249__$1,(39),inst_122152);
} else {
if((state_val_122250 === (41))){
var inst_122087 = (state_122249[(7)]);
var inst_122172 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_122087);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122172)){
var statearr_122279_122356 = state_122249__$1;
(statearr_122279_122356[(1)] = (44));

} else {
var statearr_122280_122357 = state_122249__$1;
(statearr_122280_122357[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (43))){
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122163 = (state_122249[(2)]);
var inst_122164 = fluree.db.util.async.throw_err(inst_122163);
var inst_122165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122164,(0),null);
var inst_122166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122164,(1),null);
var inst_122167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122168 = cljs.core.rest(inst_122120);
var inst_122169 = [inst_122165,inst_122168,inst_122122,inst_122166];
var inst_122170 = (new cljs.core.PersistentVector(null,4,(5),inst_122167,inst_122169,null));
var state_122249__$1 = state_122249;
var statearr_122281_122358 = state_122249__$1;
(statearr_122281_122358[(2)] = inst_122170);

(statearr_122281_122358[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (29))){
var inst_122136 = (state_122249[(8)]);
var inst_122140 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_122136);
var state_122249__$1 = state_122249;
var statearr_122282_122359 = state_122249__$1;
(statearr_122282_122359[(2)] = inst_122140);

(statearr_122282_122359[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (44))){
var inst_122121 = (state_122249[(13)]);
var inst_122137 = (state_122249[(12)]);
var inst_122131 = (state_122249[(9)]);
var inst_122087 = (state_122249[(7)]);
var inst_122174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122175 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_122121,inst_122087,inst_122131,inst_122137,false);
var state_122249__$1 = (function (){var statearr_122283 = state_122249;
(statearr_122283[(19)] = inst_122174);

return statearr_122283;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122249__$1,(47),inst_122175);
} else {
if((state_val_122250 === (6))){
var state_122249__$1 = state_122249;
var statearr_122284_122360 = state_122249__$1;
(statearr_122284_122360[(2)] = null);

(statearr_122284_122360[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (28))){
var inst_122227 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122285_122361 = state_122249__$1;
(statearr_122285_122361[(2)] = inst_122227);

(statearr_122285_122361[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (51))){
var inst_122131 = (state_122249[(9)]);
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122123 = (state_122249[(15)]);
var inst_122192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122193 = ["_id"];
var inst_122194 = inst_122131.s;
var inst_122195 = [inst_122194];
var inst_122196 = cljs.core.PersistentHashMap.fromArrays(inst_122193,inst_122195);
var inst_122197 = cljs.core.rest(inst_122120);
var inst_122198 = [inst_122196,inst_122197,inst_122122,inst_122123];
var inst_122199 = (new cljs.core.PersistentVector(null,4,(5),inst_122192,inst_122198,null));
var state_122249__$1 = state_122249;
var statearr_122286_122362 = state_122249__$1;
(statearr_122286_122362[(2)] = inst_122199);

(statearr_122286_122362[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (25))){
var inst_122087 = (state_122249[(7)]);
var inst_122081 = (state_122249[(20)]);
var inst_122101 = (state_122249[(16)]);
var inst_122117 = (state_122249[(18)]);
var inst_122229 = (state_122249[(2)]);
var inst_122230 = (function (){var top_level_subject = inst_122081;
var select_spec = inst_122087;
var base_acc = inst_122101;
var acc_PLUS_refs = inst_122117;
var result = inst_122229;
return ((function (top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,inst_122087,inst_122081,inst_122101,inst_122117,inst_122229,state_val_122250,c__110077__auto__){
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4131__auto__ = (function (){var and__4120__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4120__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
;})(top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,inst_122087,inst_122081,inst_122101,inst_122117,inst_122229,state_val_122250,c__110077__auto__))
})();
var inst_122231 = cljs.core.PersistentVector.EMPTY;
var inst_122232 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_122087);
var inst_122233 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_122232);
var inst_122234 = cljs.core.vals(inst_122233);
var inst_122235 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_122087);
var inst_122236 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_122235);
var inst_122237 = cljs.core.vals(inst_122236);
var inst_122238 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_122234,inst_122237);
var inst_122239 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_122230,inst_122231,inst_122238);
var inst_122241 = (function (){var top_level_subject = inst_122081;
var select_spec = inst_122087;
var base_acc = inst_122101;
var acc_PLUS_refs = inst_122117;
var result = inst_122229;
var sort_preds = inst_122239;
return ((function (top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,sort_preds,inst_122087,inst_122081,inst_122101,inst_122117,inst_122229,inst_122230,inst_122231,inst_122232,inst_122233,inst_122234,inst_122235,inst_122236,inst_122237,inst_122238,inst_122239,state_val_122250,c__110077__auto__){
return (function (acc,p__122240){
var vec__122287 = p__122240;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122287,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122287,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122287,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122287,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
;})(top_level_subject,select_spec,base_acc,acc_PLUS_refs,result,sort_preds,inst_122087,inst_122081,inst_122101,inst_122117,inst_122229,inst_122230,inst_122231,inst_122232,inst_122233,inst_122234,inst_122235,inst_122236,inst_122237,inst_122238,inst_122239,state_val_122250,c__110077__auto__))
})();
var inst_122242 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_122241,inst_122229,inst_122239);
var state_122249__$1 = state_122249;
var statearr_122290_122363 = state_122249__$1;
(statearr_122290_122363[(2)] = inst_122242);

(statearr_122290_122363[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (34))){
var inst_122131 = (state_122249[(9)]);
var inst_122218 = (state_122249[(2)]);
var inst_122219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122218,(0),null);
var inst_122220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122218,(1),null);
var inst_122221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122218,(2),null);
var inst_122222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122218,(3),null);
var inst_122223 = inst_122131.s;
var inst_122224 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_122219,cljs.core.cst$kw$_id,inst_122223);
var inst_122120 = inst_122220;
var inst_122121 = inst_122224;
var inst_122122 = inst_122221;
var inst_122123 = inst_122222;
var state_122249__$1 = (function (){var statearr_122291 = state_122249;
(statearr_122291[(13)] = inst_122121);

(statearr_122291[(14)] = inst_122122);

(statearr_122291[(10)] = inst_122120);

(statearr_122291[(15)] = inst_122123);

return statearr_122291;
})();
var statearr_122292_122364 = state_122249__$1;
(statearr_122292_122364[(2)] = null);

(statearr_122292_122364[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (17))){
var inst_122081 = (state_122249[(20)]);
var inst_122095 = ["_id"];
var inst_122096 = [inst_122081];
var inst_122097 = cljs.core.PersistentHashMap.fromArrays(inst_122095,inst_122096);
var state_122249__$1 = state_122249;
var statearr_122293_122365 = state_122249__$1;
(statearr_122293_122365[(2)] = inst_122097);

(statearr_122293_122365[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (3))){
var inst_122066 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122294_122366 = state_122249__$1;
(statearr_122294_122366[(2)] = inst_122066);


cljs.core.async.impl.ioc_helpers.process_exception(state_122249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (12))){
var state_122249__$1 = state_122249;
var statearr_122295_122367 = state_122249__$1;
(statearr_122295_122367[(2)] = base_select_spec);

(statearr_122295_122367[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (2))){
var inst_122247 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_122249__$1,inst_122247);
} else {
if((state_val_122250 === (23))){
var inst_122101 = (state_122249[(16)]);
var inst_122112 = (state_122249[(2)]);
var inst_122113 = fluree.db.util.async.throw_err(inst_122112);
var inst_122114 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_122101,inst_122113], 0));
var state_122249__$1 = state_122249;
var statearr_122296_122368 = state_122249__$1;
(statearr_122296_122368[(2)] = inst_122114);

(statearr_122296_122368[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (47))){
var inst_122122 = (state_122249[(14)]);
var inst_122120 = (state_122249[(10)]);
var inst_122174 = (state_122249[(19)]);
var inst_122123 = (state_122249[(15)]);
var inst_122177 = (state_122249[(2)]);
var inst_122178 = fluree.db.util.async.throw_err(inst_122177);
var inst_122179 = cljs.core.first(inst_122178);
var inst_122180 = cljs.core.rest(inst_122120);
var inst_122181 = [inst_122179,inst_122180,inst_122122,inst_122123];
var inst_122182 = (new cljs.core.PersistentVector(null,4,(5),inst_122174,inst_122181,null));
var state_122249__$1 = state_122249;
var statearr_122297_122369 = state_122249__$1;
(statearr_122297_122369[(2)] = inst_122182);

(statearr_122297_122369[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (35))){
var inst_122147 = (state_122249[(2)]);
var inst_122148 = fluree.db.util.async.throw_err(inst_122147);
var state_122249__$1 = state_122249;
var statearr_122298_122370 = state_122249__$1;
(statearr_122298_122370[(2)] = inst_122148);

(statearr_122298_122370[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (19))){
var inst_122087 = (state_122249[(7)]);
var inst_122101 = (state_122249[(2)]);
var inst_122102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122103 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_122104 = (new cljs.core.PersistentVector(null,2,(5),inst_122102,inst_122103,null));
var inst_122105 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_122087,inst_122104);
var state_122249__$1 = (function (){var statearr_122299 = state_122249;
(statearr_122299[(16)] = inst_122101);

return statearr_122299;
})();
if(cljs.core.truth_(inst_122105)){
var statearr_122300_122371 = state_122249__$1;
(statearr_122300_122371[(1)] = (20));

} else {
var statearr_122301_122372 = state_122249__$1;
(statearr_122301_122372[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (11))){
var inst_122081 = (state_122249[(20)]);
var inst_122084 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_122081);
var state_122249__$1 = state_122249;
var statearr_122302_122373 = state_122249__$1;
(statearr_122302_122373[(2)] = inst_122084);

(statearr_122302_122373[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (9))){
var inst_122072 = (state_122249[(2)]);
var inst_122073 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_122072], 0));
var inst_122074 = (function(){throw inst_122072})();
var state_122249__$1 = (function (){var statearr_122303 = state_122249;
(statearr_122303[(21)] = inst_122073);

return statearr_122303;
})();
var statearr_122304_122374 = state_122249__$1;
(statearr_122304_122374[(2)] = inst_122074);


cljs.core.async.impl.ioc_helpers.process_exception(state_122249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (5))){
var state_122249__$1 = state_122249;
var statearr_122305_122375 = state_122249__$1;
(statearr_122305_122375[(2)] = null);

(statearr_122305_122375[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (14))){
var inst_122088 = (state_122249[(17)]);
var state_122249__$1 = state_122249;
var statearr_122306_122376 = state_122249__$1;
(statearr_122306_122376[(2)] = inst_122088);

(statearr_122306_122376[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (45))){
var inst_122087 = (state_122249[(7)]);
var inst_122185 = (state_122249[(22)]);
var inst_122184 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_122087);
var inst_122185__$1 = cljs.core.empty_QMARK_(inst_122184);
var state_122249__$1 = (function (){var statearr_122307 = state_122249;
(statearr_122307[(22)] = inst_122185__$1);

return statearr_122307;
})();
if(inst_122185__$1){
var statearr_122308_122377 = state_122249__$1;
(statearr_122308_122377[(1)] = (48));

} else {
var statearr_122309_122378 = state_122249__$1;
(statearr_122309_122378[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (53))){
var inst_122210 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122310_122379 = state_122249__$1;
(statearr_122310_122379[(2)] = inst_122210);

(statearr_122310_122379[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (26))){
var inst_122121 = (state_122249[(13)]);
var state_122249__$1 = state_122249;
var statearr_122311_122380 = state_122249__$1;
(statearr_122311_122380[(2)] = inst_122121);

(statearr_122311_122380[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (16))){
var inst_122093 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122093)){
var statearr_122312_122381 = state_122249__$1;
(statearr_122312_122381[(1)] = (17));

} else {
var statearr_122313_122382 = state_122249__$1;
(statearr_122313_122382[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (38))){
var inst_122216 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122314_122383 = state_122249__$1;
(statearr_122314_122383[(2)] = inst_122216);

(statearr_122314_122383[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (30))){
var inst_122138 = (state_122249[(11)]);
var state_122249__$1 = state_122249;
var statearr_122315_122384 = state_122249__$1;
(statearr_122315_122384[(2)] = inst_122138);

(statearr_122315_122384[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (10))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_122249,(9),java.lang.Exception,null,(8));
var inst_122078 = cljs.core.first(flakes);
var inst_122079 = fluree.db.query.fql.s(inst_122078);
var state_122249__$1 = state_122249;
var statearr_122316_122385 = state_122249__$1;
(statearr_122316_122385[(2)] = inst_122079);


cljs.core.async.impl.ioc_helpers.process_exception(state_122249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (18))){
var inst_122099 = cljs.core.PersistentHashMap.EMPTY;
var state_122249__$1 = state_122249;
var statearr_122317_122386 = state_122249__$1;
(statearr_122317_122386[(2)] = inst_122099);

(statearr_122317_122386[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (52))){
var state_122249__$1 = state_122249;
var statearr_122318_122387 = state_122249__$1;
(statearr_122318_122387[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (42))){
var inst_122214 = (state_122249[(2)]);
var state_122249__$1 = state_122249;
var statearr_122320_122388 = state_122249__$1;
(statearr_122320_122388[(2)] = inst_122214);

(statearr_122320_122388[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (37))){
var inst_122136 = (state_122249[(8)]);
var state_122249__$1 = state_122249;
if(cljs.core.truth_(inst_122136)){
var statearr_122321_122389 = state_122249__$1;
(statearr_122321_122389[(1)] = (40));

} else {
var statearr_122322_122390 = state_122249__$1;
(statearr_122322_122390[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (8))){
var inst_122081 = (state_122249[(2)]);
var inst_122082 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_122249__$1 = (function (){var statearr_122323 = state_122249;
(statearr_122323[(20)] = inst_122081);

return statearr_122323;
})();
if(cljs.core.truth_(inst_122082)){
var statearr_122324_122391 = state_122249__$1;
(statearr_122324_122391[(1)] = (11));

} else {
var statearr_122325_122392 = state_122249__$1;
(statearr_122325_122392[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122250 === (49))){
var inst_122185 = (state_122249[(22)]);
var state_122249__$1 = state_122249;
var statearr_122326_122393 = state_122249__$1;
(statearr_122326_122393[(2)] = inst_122185);

(statearr_122326_122393[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____0 = (function (){
var statearr_122327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_122327[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__);

(statearr_122327[(1)] = (1));

return statearr_122327;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____1 = (function (state_122249){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_122249);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e122328){if((e122328 instanceof Object)){
var ex__109974__auto__ = e122328;
var statearr_122329_122394 = state_122249;
(statearr_122329_122394[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_122249);

return cljs.core.cst$kw$recur;
} else {
throw e122328;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__122395 = state_122249;
state_122249 = G__122395;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__ = function(state_122249){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____1.call(this,state_122249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_122330 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_122330[(6)] = c__110077__auto__);

return statearr_122330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__122398 = arguments.length;
switch (G__122398) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
});

fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_122437){
var state_val_122438 = (state_122437[(1)]);
if((state_val_122438 === (7))){
var inst_122410 = (state_122437[(2)]);
var state_122437__$1 = (function (){var statearr_122439 = state_122437;
(statearr_122439[(7)] = inst_122410);

return statearr_122439;
})();
if(cljs.core.truth_(offset)){
var statearr_122440_122462 = state_122437__$1;
(statearr_122440_122462[(1)] = (8));

} else {
var statearr_122441_122463 = state_122437__$1;
(statearr_122441_122463[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (1))){
var state_122437__$1 = state_122437;
var statearr_122442_122464 = state_122437__$1;
(statearr_122442_122464[(2)] = null);

(statearr_122442_122464[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_122437,(3),Error,null,(2));
var inst_122404 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_122437__$1 = (function (){var statearr_122443 = state_122437;
(statearr_122443[(8)] = inst_122404);

return statearr_122443;
})();
if(cljs.core.truth_(fuel)){
var statearr_122444_122465 = state_122437__$1;
(statearr_122444_122465[(1)] = (5));

} else {
var statearr_122445_122466 = state_122437__$1;
(statearr_122445_122466[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (13))){
var inst_122422 = (state_122437[(2)]);
var inst_122423 = (function (){return ((function (inst_122422,state_val_122438,c__110077__auto__){
return (function (x){
var and__4120__auto__ = max_fuel;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4120__auto__;
}
});
;})(inst_122422,state_val_122438,c__110077__auto__))
})();
var inst_122424 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_122423);
var inst_122425 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_122422,inst_122424);
var inst_122426 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_122425,flakes);
var inst_122427 = cljs.core.PersistentVector.EMPTY;
var inst_122428 = (function (){var xf = inst_122425;
var flakes_by_sub = inst_122426;
return ((function (xf,flakes_by_sub,inst_122422,inst_122423,inst_122424,inst_122425,inst_122426,inst_122427,state_val_122438,c__110077__auto__){
return (function (p1__122396_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__122396_SHARP_);
});
;})(xf,flakes_by_sub,inst_122422,inst_122423,inst_122424,inst_122425,inst_122426,inst_122427,state_val_122438,c__110077__auto__))
})();
var inst_122429 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_122428,inst_122426);
var inst_122430 = fluree.db.util.async.merge_into_QMARK_(inst_122427,inst_122429);
var state_122437__$1 = state_122437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122437__$1,(14),inst_122430);
} else {
if((state_val_122438 === (6))){
var inst_122404 = (state_122437[(8)]);
var state_122437__$1 = state_122437;
var statearr_122446_122467 = state_122437__$1;
(statearr_122446_122467[(2)] = inst_122404);

(statearr_122446_122467[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (3))){
var inst_122399 = (state_122437[(2)]);
var state_122437__$1 = state_122437;
var statearr_122447_122468 = state_122437__$1;
(statearr_122447_122468[(2)] = inst_122399);


cljs.core.async.impl.ioc_helpers.process_exception(state_122437__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (12))){
var inst_122416 = (state_122437[(9)]);
var state_122437__$1 = state_122437;
var statearr_122448_122469 = state_122437__$1;
(statearr_122448_122469[(2)] = inst_122416);

(statearr_122448_122469[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (2))){
var inst_122435 = (state_122437[(2)]);
var state_122437__$1 = state_122437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_122437__$1,inst_122435);
} else {
if((state_val_122438 === (11))){
var inst_122416 = (state_122437[(9)]);
var inst_122418 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_122419 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_122416,inst_122418);
var state_122437__$1 = state_122437;
var statearr_122449_122470 = state_122437__$1;
(statearr_122449_122470[(2)] = inst_122419);

(statearr_122449_122470[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (9))){
var inst_122410 = (state_122437[(7)]);
var state_122437__$1 = state_122437;
var statearr_122450_122471 = state_122437__$1;
(statearr_122450_122471[(2)] = inst_122410);

(statearr_122450_122471[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (5))){
var inst_122404 = (state_122437[(8)]);
var inst_122406 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_122407 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_122404,inst_122406);
var state_122437__$1 = state_122437;
var statearr_122451_122472 = state_122437__$1;
(statearr_122451_122472[(2)] = inst_122407);

(statearr_122451_122472[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (14))){
var inst_122432 = (state_122437[(2)]);
var inst_122433 = fluree.db.util.async.throw_err(inst_122432);
var state_122437__$1 = state_122437;
var statearr_122452_122473 = state_122437__$1;
(statearr_122452_122473[(2)] = inst_122433);


cljs.core.async.impl.ioc_helpers.process_exception(state_122437__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (10))){
var inst_122416 = (state_122437[(2)]);
var state_122437__$1 = (function (){var statearr_122453 = state_122437;
(statearr_122453[(9)] = inst_122416);

return statearr_122453;
})();
if(cljs.core.truth_(limit)){
var statearr_122454_122474 = state_122437__$1;
(statearr_122454_122474[(1)] = (11));

} else {
var statearr_122455_122475 = state_122437__$1;
(statearr_122455_122475[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122438 === (8))){
var inst_122410 = (state_122437[(7)]);
var inst_122412 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_122413 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_122410,inst_122412);
var state_122437__$1 = state_122437;
var statearr_122456_122476 = state_122437__$1;
(statearr_122456_122476[(2)] = inst_122413);

(statearr_122456_122476[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$state_machine__109971__auto__ = null;
var fluree$db$query$fql$state_machine__109971__auto____0 = (function (){
var statearr_122457 = [null,null,null,null,null,null,null,null,null,null];
(statearr_122457[(0)] = fluree$db$query$fql$state_machine__109971__auto__);

(statearr_122457[(1)] = (1));

return statearr_122457;
});
var fluree$db$query$fql$state_machine__109971__auto____1 = (function (state_122437){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_122437);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e122458){if((e122458 instanceof Object)){
var ex__109974__auto__ = e122458;
var statearr_122459_122477 = state_122437;
(statearr_122459_122477[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_122437);

return cljs.core.cst$kw$recur;
} else {
throw e122458;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__122478 = state_122437;
state_122437 = G__122478;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__109971__auto__ = function(state_122437){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__109971__auto____1.call(this,state_122437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__109971__auto____0;
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__109971__auto____1;
return fluree$db$query$fql$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_122460 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_122460[(6)] = c__110077__auto__);

return statearr_122460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8;

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__122480 = arguments.length;
switch (G__122480) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
});

fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_122558){
var state_val_122559 = (state_122558[(1)]);
if((state_val_122559 === (7))){
var inst_122506 = (state_122558[(7)]);
var state_122558__$1 = state_122558;
var statearr_122560_122600 = state_122558__$1;
(statearr_122560_122600[(2)] = inst_122506);

(statearr_122560_122600[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (20))){
var state_122558__$1 = state_122558;
var statearr_122561_122601 = state_122558__$1;
(statearr_122561_122601[(1)] = (22));



return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (1))){
var state_122558__$1 = state_122558;
var statearr_122563_122602 = state_122558__$1;
(statearr_122563_122602[(2)] = null);

(statearr_122563_122602[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (24))){
var inst_122548 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122564_122603 = state_122558__$1;
(statearr_122564_122603[(2)] = inst_122548);

(statearr_122564_122603[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_122558,(3),Error,null,(2));
var inst_122492 = cljs.core.seq(subjects);
var inst_122493 = cljs.core.first(inst_122492);
var inst_122494 = cljs.core.next(inst_122492);
var inst_122495 = cljs.core.PersistentVector.EMPTY;
var inst_122496 = subjects;
var inst_122497 = (0);
var inst_122498 = inst_122495;
var state_122558__$1 = (function (){var statearr_122565 = state_122558;
(statearr_122565[(8)] = inst_122494);

(statearr_122565[(9)] = inst_122497);

(statearr_122565[(10)] = inst_122498);

(statearr_122565[(11)] = inst_122493);

(statearr_122565[(12)] = inst_122496);

return statearr_122565;
})();
var statearr_122566_122604 = state_122558__$1;
(statearr_122566_122604[(2)] = null);

(statearr_122566_122604[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (15))){
var inst_122552 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122567_122605 = state_122558__$1;
(statearr_122567_122605[(2)] = inst_122552);

(statearr_122567_122605[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (21))){
var inst_122550 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122568_122606 = state_122558__$1;
(statearr_122568_122606[(2)] = inst_122550);

(statearr_122568_122606[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (13))){
var inst_122498 = (state_122558[(10)]);
var state_122558__$1 = state_122558;
var statearr_122569_122607 = state_122558__$1;
(statearr_122569_122607[(2)] = inst_122498);

(statearr_122569_122607[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (22))){
var inst_122494 = (state_122558[(8)]);
var inst_122497 = (state_122558[(9)]);
var inst_122498 = (state_122558[(10)]);
var inst_122493 = (state_122558[(11)]);
var inst_122505 = (state_122558[(13)]);
var inst_122496 = (state_122558[(12)]);
var inst_122504 = (state_122558[(14)]);
var inst_122528 = (inst_122497 + (1));
var inst_122529 = (function (){var vec__122489 = subjects;
var r = inst_122505;
var first__122502 = inst_122504;
var seq__122501 = inst_122505;
var G__122488 = inst_122496;
var acc = inst_122498;
var n = inst_122497;
var seq__122490 = inst_122494;
var s = inst_122504;
var vec__122500 = inst_122496;
var first__122491 = inst_122493;
return ((function (vec__122489,r,first__122502,seq__122501,G__122488,acc,n,seq__122490,s,vec__122500,first__122491,inst_122494,inst_122497,inst_122498,inst_122493,inst_122505,inst_122496,inst_122504,inst_122528,state_val_122559,c__110077__auto__){
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
;})(vec__122489,r,first__122502,seq__122501,G__122488,acc,n,seq__122490,s,vec__122500,first__122491,inst_122494,inst_122497,inst_122498,inst_122493,inst_122505,inst_122496,inst_122504,inst_122528,state_val_122559,c__110077__auto__))
})();
var inst_122530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122531 = [inst_122504];
var inst_122532 = (new cljs.core.PersistentVector(null,1,(5),inst_122530,inst_122531,null));
var inst_122533 = [cljs.core.cst$kw$limit];
var inst_122534 = [limit];
var inst_122535 = cljs.core.PersistentHashMap.fromArrays(inst_122533,inst_122534);
var inst_122536 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_122532,inst_122535);
var state_122558__$1 = (function (){var statearr_122570 = state_122558;
(statearr_122570[(15)] = inst_122529);

(statearr_122570[(16)] = inst_122528);

return statearr_122570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122558__$1,(26),inst_122536);
} else {
if((state_val_122559 === (6))){
var inst_122554 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122571_122608 = state_122558__$1;
(statearr_122571_122608[(2)] = inst_122554);


cljs.core.async.impl.ioc_helpers.process_exception(state_122558__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (25))){
var inst_122528 = (state_122558[(16)]);
var inst_122498 = (state_122558[(10)]);
var inst_122505 = (state_122558[(13)]);
var inst_122542 = (state_122558[(2)]);
var inst_122543 = fluree.db.util.async.throw_err(inst_122542);
var inst_122544 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_122498,inst_122543);
var inst_122496 = inst_122505;
var inst_122497 = inst_122528;
var inst_122498__$1 = inst_122544;
var state_122558__$1 = (function (){var statearr_122572 = state_122558;
(statearr_122572[(9)] = inst_122497);

(statearr_122572[(10)] = inst_122498__$1);

(statearr_122572[(12)] = inst_122496);

return statearr_122572;
})();
var statearr_122573_122609 = state_122558__$1;
(statearr_122573_122609[(2)] = null);

(statearr_122573_122609[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (17))){
var state_122558__$1 = state_122558;
var statearr_122574_122610 = state_122558__$1;
(statearr_122574_122610[(2)] = offset);

(statearr_122574_122610[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (3))){
var inst_122481 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122575_122611 = state_122558__$1;
(statearr_122575_122611[(2)] = inst_122481);


cljs.core.async.impl.ioc_helpers.process_exception(state_122558__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (12))){
var inst_122513 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
var statearr_122576_122612 = state_122558__$1;
(statearr_122576_122612[(2)] = inst_122513);

(statearr_122576_122612[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (2))){
var inst_122556 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_122558__$1,inst_122556);
} else {
if((state_val_122559 === (23))){
var state_122558__$1 = state_122558;
var statearr_122578_122613 = state_122558__$1;
(statearr_122578_122613[(2)] = null);

(statearr_122578_122613[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (19))){
var inst_122497 = (state_122558[(9)]);
var inst_122498 = (state_122558[(10)]);
var inst_122505 = (state_122558[(13)]);
var inst_122524 = (inst_122497 + (1));
var tmp122577 = inst_122498;
var inst_122496 = inst_122505;
var inst_122497__$1 = inst_122524;
var inst_122498__$1 = tmp122577;
var state_122558__$1 = (function (){var statearr_122579 = state_122558;
(statearr_122579[(9)] = inst_122497__$1);

(statearr_122579[(10)] = inst_122498__$1);

(statearr_122579[(12)] = inst_122496);

return statearr_122579;
})();
var statearr_122580_122614 = state_122558__$1;
(statearr_122580_122614[(2)] = null);

(statearr_122580_122614[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (11))){
var state_122558__$1 = state_122558;
var statearr_122581_122615 = state_122558__$1;
(statearr_122581_122615[(2)] = limit);

(statearr_122581_122615[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (9))){
var inst_122515 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
if(cljs.core.truth_(inst_122515)){
var statearr_122582_122616 = state_122558__$1;
(statearr_122582_122616[(1)] = (13));

} else {
var statearr_122583_122617 = state_122558__$1;
(statearr_122583_122617[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (5))){
var inst_122506 = (state_122558[(7)]);
var inst_122496 = (state_122558[(12)]);
var inst_122504 = (state_122558[(14)]);
var inst_122503 = cljs.core.seq(inst_122496);
var inst_122504__$1 = cljs.core.first(inst_122503);
var inst_122505 = cljs.core.next(inst_122503);
var inst_122506__$1 = (inst_122504__$1 == null);
var state_122558__$1 = (function (){var statearr_122584 = state_122558;
(statearr_122584[(7)] = inst_122506__$1);

(statearr_122584[(13)] = inst_122505);

(statearr_122584[(14)] = inst_122504__$1);

return statearr_122584;
})();
if(cljs.core.truth_(inst_122506__$1)){
var statearr_122585_122618 = state_122558__$1;
(statearr_122585_122618[(1)] = (7));

} else {
var statearr_122586_122619 = state_122558__$1;
(statearr_122586_122619[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (14))){
var state_122558__$1 = state_122558;
if(cljs.core.truth_(offset)){
var statearr_122587_122620 = state_122558__$1;
(statearr_122587_122620[(1)] = (16));

} else {
var statearr_122588_122621 = state_122558__$1;
(statearr_122588_122621[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (26))){
var inst_122529 = (state_122558[(15)]);
var inst_122538 = (state_122558[(2)]);
var inst_122539 = fluree.db.util.async.throw_err(inst_122538);
var inst_122540 = (inst_122529.cljs$core$IFn$_invoke$arity$1 ? inst_122529.cljs$core$IFn$_invoke$arity$1(inst_122539) : inst_122529.call(null,inst_122539));
var state_122558__$1 = state_122558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122558__$1,(25),inst_122540);
} else {
if((state_val_122559 === (16))){
var inst_122497 = (state_122558[(9)]);
var inst_122519 = (inst_122497 < offset);
var state_122558__$1 = state_122558;
var statearr_122589_122622 = state_122558__$1;
(statearr_122589_122622[(2)] = inst_122519);

(statearr_122589_122622[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (10))){
var inst_122497 = (state_122558[(9)]);
var inst_122510 = (inst_122497 > limit);
var state_122558__$1 = state_122558;
var statearr_122590_122623 = state_122558__$1;
(statearr_122590_122623[(2)] = inst_122510);

(statearr_122590_122623[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (18))){
var inst_122522 = (state_122558[(2)]);
var state_122558__$1 = state_122558;
if(cljs.core.truth_(inst_122522)){
var statearr_122591_122624 = state_122558__$1;
(statearr_122591_122624[(1)] = (19));

} else {
var statearr_122592_122625 = state_122558__$1;
(statearr_122592_122625[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122559 === (8))){
var state_122558__$1 = state_122558;
if(cljs.core.truth_(limit)){
var statearr_122593_122626 = state_122558__$1;
(statearr_122593_122626[(1)] = (10));

} else {
var statearr_122594_122627 = state_122558__$1;
(statearr_122594_122627[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$state_machine__109971__auto__ = null;
var fluree$db$query$fql$state_machine__109971__auto____0 = (function (){
var statearr_122595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_122595[(0)] = fluree$db$query$fql$state_machine__109971__auto__);

(statearr_122595[(1)] = (1));

return statearr_122595;
});
var fluree$db$query$fql$state_machine__109971__auto____1 = (function (state_122558){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_122558);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e122596){if((e122596 instanceof Object)){
var ex__109974__auto__ = e122596;
var statearr_122597_122628 = state_122558;
(statearr_122597_122628[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_122558);

return cljs.core.cst$kw$recur;
} else {
throw e122596;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__122629 = state_122558;
state_122558 = G__122629;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__109971__auto__ = function(state_122558){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__109971__auto____1.call(this,state_122558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__109971__auto____0;
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__109971__auto____1;
return fluree$db$query$fql$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_122598 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_122598[(6)] = c__110077__auto__);

return statearr_122598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8;

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4131__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__122631 = arguments.length;
switch (G__122631) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
});

fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_122815){
var state_val_122816 = (state_122815[(1)]);
if((state_val_122816 === (7))){
var inst_122811 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122817_122881 = state_122815__$1;
(statearr_122817_122881[(2)] = inst_122811);


cljs.core.async.impl.ioc_helpers.process_exception(state_122815__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (20))){
var inst_122700 = (state_122815[(7)]);
var inst_122709 = (state_122815[(2)]);
var inst_122710 = fluree.db.util.async.throw_err(inst_122709);
var inst_122711 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_122700,inst_122710);
var state_122815__$1 = state_122815;
var statearr_122818_122882 = state_122815__$1;
(statearr_122818_122882[(2)] = inst_122711);

(statearr_122818_122882[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (27))){
var inst_122783 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122819_122883 = state_122815__$1;
(statearr_122819_122883[(2)] = inst_122783);

(statearr_122819_122883[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (1))){
var state_122815__$1 = state_122815;
var statearr_122820_122884 = state_122815__$1;
(statearr_122820_122884[(2)] = null);

(statearr_122820_122884[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (24))){
var inst_122720 = (state_122815[(2)]);
var inst_122721 = fluree.db.util.async.throw_err(inst_122720);
var state_122815__$1 = state_122815;
var statearr_122821_122885 = state_122815__$1;
(statearr_122821_122885[(2)] = inst_122721);

(statearr_122821_122885[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (39))){
var inst_122777 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122822_122886 = state_122815__$1;
(statearr_122822_122886[(2)] = inst_122777);

(statearr_122822_122886[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (46))){
var inst_122804 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122823_122887 = state_122815__$1;
(statearr_122823_122887[(2)] = inst_122804);

(statearr_122823_122887[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (4))){
var inst_122641 = (state_122815[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_122815,(3),Error,null,(2));
var inst_122639 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_122640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122639,(0),null);
var inst_122641__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122639,(1),null);
var inst_122642 = cljs.core.not_empty(inst_122641__$1);
var state_122815__$1 = (function (){var statearr_122824 = state_122815;
(statearr_122824[(8)] = inst_122641__$1);

(statearr_122824[(9)] = inst_122640);

return statearr_122824;
})();
if(cljs.core.truth_(inst_122642)){
var statearr_122825_122888 = state_122815__$1;
(statearr_122825_122888[(1)] = (5));

} else {
var statearr_122826_122889 = state_122815__$1;
(statearr_122826_122889[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (15))){
var inst_122671 = (state_122815[(10)]);
var inst_122685 = (state_122815[(2)]);
var inst_122689 = (cljs.core.not_EQ_ === inst_122671);
var state_122815__$1 = (function (){var statearr_122827 = state_122815;
(statearr_122827[(11)] = inst_122685);

return statearr_122827;
})();
if(inst_122689){
var statearr_122828_122890 = state_122815__$1;
(statearr_122828_122890[(1)] = (16));

} else {
var statearr_122829_122891 = state_122815__$1;
(statearr_122829_122891[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (21))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122716 = [inst_122670,inst_122672];
var inst_122717 = (new cljs.core.PersistentVector(null,2,(5),inst_122715,inst_122716,null));
var inst_122718 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_122717);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(24),inst_122718);
} else {
if((state_val_122816 === (31))){
var inst_122781 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122830_122892 = state_122815__$1;
(statearr_122830_122892[(2)] = inst_122781);

(statearr_122830_122892[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (32))){
var inst_122746 = (state_122815[(2)]);
var inst_122747 = fluree.db.util.async.throw_err(inst_122746);
var state_122815__$1 = state_122815;
var statearr_122831_122893 = state_122815__$1;
(statearr_122831_122893[(2)] = inst_122747);

(statearr_122831_122893[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (40))){
var inst_122772 = (state_122815[(2)]);
var inst_122773 = fluree.db.util.async.throw_err(inst_122772);
var state_122815__$1 = state_122815;
var statearr_122832_122894 = state_122815__$1;
(statearr_122832_122894[(2)] = inst_122773);

(statearr_122832_122894[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (33))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122752 = [inst_122670];
var inst_122753 = (new cljs.core.PersistentVector(null,1,(5),inst_122751,inst_122752,null));
var inst_122754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122755 = [inst_122670,inst_122672];
var inst_122756 = (new cljs.core.PersistentVector(null,2,(5),inst_122754,inst_122755,null));
var inst_122757 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_122753,cljs.core._LT_,inst_122756);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(36),inst_122757);
} else {
if((state_val_122816 === (13))){
var inst_122670 = (state_122815[(12)]);
var inst_122676 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_122670);
var inst_122677 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_122676)].join('');
var inst_122678 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_122679 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_122680 = cljs.core.PersistentHashMap.fromArrays(inst_122678,inst_122679);
var inst_122681 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_122677,inst_122680);
var inst_122682 = (function(){throw inst_122681})();
var state_122815__$1 = state_122815;
var statearr_122833_122895 = state_122815__$1;
(statearr_122833_122895[(2)] = inst_122682);

(statearr_122833_122895[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (22))){
var inst_122671 = (state_122815[(10)]);
var inst_122723 = (cljs.core._GT_ === inst_122671);
var state_122815__$1 = state_122815;
if(inst_122723){
var statearr_122834_122896 = state_122815__$1;
(statearr_122834_122896[(1)] = (25));

} else {
var statearr_122835_122897 = state_122815__$1;
(statearr_122835_122897[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (36))){
var inst_122759 = (state_122815[(2)]);
var inst_122760 = fluree.db.util.async.throw_err(inst_122759);
var state_122815__$1 = state_122815;
var statearr_122836_122898 = state_122815__$1;
(statearr_122836_122898[(2)] = inst_122760);

(statearr_122836_122898[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (41))){
var inst_122640 = (state_122815[(9)]);
var inst_122796 = (state_122815[(14)]);
var inst_122796__$1 = (state_122815[(2)]);
var inst_122797 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_122640);
var inst_122798 = cljs.core.empty_QMARK_(inst_122796__$1);
var inst_122799 = ((inst_122797) && (inst_122798));
var state_122815__$1 = (function (){var statearr_122837 = state_122815;
(statearr_122837[(14)] = inst_122796__$1);

return statearr_122837;
})();
if(cljs.core.truth_(inst_122799)){
var statearr_122838_122899 = state_122815__$1;
(statearr_122838_122899[(1)] = (44));

} else {
var statearr_122839_122900 = state_122815__$1;
(statearr_122839_122900[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (43))){
var inst_122788 = (state_122815[(15)]);
var inst_122656 = (state_122815[(16)]);
var inst_122791 = cljs.core.PersistentHashSet.EMPTY;
var inst_122792 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_122791,inst_122788);
var inst_122793 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_122656,inst_122792);
var state_122815__$1 = state_122815;
var statearr_122840_122901 = state_122815__$1;
(statearr_122840_122901[(2)] = inst_122793);

(statearr_122840_122901[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (29))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122739 = [inst_122670,inst_122672];
var inst_122740 = (new cljs.core.PersistentVector(null,2,(5),inst_122738,inst_122739,null));
var inst_122741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122742 = [inst_122670];
var inst_122743 = (new cljs.core.PersistentVector(null,1,(5),inst_122741,inst_122742,null));
var inst_122744 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_122740,cljs.core._LT__EQ_,inst_122743);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(32),inst_122744);
} else {
if((state_val_122816 === (44))){
var inst_122796 = (state_122815[(14)]);
var state_122815__$1 = state_122815;
var statearr_122841_122902 = state_122815__$1;
(statearr_122841_122902[(2)] = inst_122796);

(statearr_122841_122902[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (6))){
var state_122815__$1 = state_122815;
var statearr_122842_122903 = state_122815__$1;
(statearr_122842_122903[(2)] = null);

(statearr_122842_122903[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (28))){
var inst_122733 = (state_122815[(2)]);
var inst_122734 = fluree.db.util.async.throw_err(inst_122733);
var state_122815__$1 = state_122815;
var statearr_122843_122904 = state_122815__$1;
(statearr_122843_122904[(2)] = inst_122734);

(statearr_122843_122904[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (25))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122726 = [inst_122670,inst_122672];
var inst_122727 = (new cljs.core.PersistentVector(null,2,(5),inst_122725,inst_122726,null));
var inst_122728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122729 = [inst_122670];
var inst_122730 = (new cljs.core.PersistentVector(null,1,(5),inst_122728,inst_122729,null));
var inst_122731 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_122727,cljs.core._LT__EQ_,inst_122730);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(28),inst_122731);
} else {
if((state_val_122816 === (34))){
var inst_122671 = (state_122815[(10)]);
var inst_122762 = (cljs.core._LT__EQ_ === inst_122671);
var state_122815__$1 = state_122815;
if(inst_122762){
var statearr_122844_122905 = state_122815__$1;
(statearr_122844_122905[(1)] = (37));

} else {
var statearr_122845_122906 = state_122815__$1;
(statearr_122845_122906[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (17))){
var inst_122671 = (state_122815[(10)]);
var inst_122713 = (cljs.core._EQ_ === inst_122671);
var state_122815__$1 = state_122815;
if(inst_122713){
var statearr_122846_122907 = state_122815__$1;
(statearr_122846_122907[(1)] = (21));

} else {
var statearr_122847_122908 = state_122815__$1;
(statearr_122847_122908[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (3))){
var inst_122632 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122848_122909 = state_122815__$1;
(statearr_122848_122909[(2)] = inst_122632);


cljs.core.async.impl.ioc_helpers.process_exception(state_122815__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (12))){
var inst_122806 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122849_122910 = state_122815__$1;
(statearr_122849_122910[(2)] = inst_122806);

(statearr_122849_122910[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (2))){
var inst_122813 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_122815__$1,inst_122813);
} else {
if((state_val_122816 === (23))){
var inst_122785 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122850_122911 = state_122815__$1;
(statearr_122850_122911[(2)] = inst_122785);

(statearr_122850_122911[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (35))){
var inst_122779 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122851_122912 = state_122815__$1;
(statearr_122851_122912[(2)] = inst_122779);

(statearr_122851_122912[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (19))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122699 = (state_122815[(2)]);
var inst_122700 = fluree.db.util.async.throw_err(inst_122699);
var inst_122701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122702 = [inst_122670];
var inst_122703 = (new cljs.core.PersistentVector(null,1,(5),inst_122701,inst_122702,null));
var inst_122704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122705 = [inst_122670,inst_122672];
var inst_122706 = (new cljs.core.PersistentVector(null,2,(5),inst_122704,inst_122705,null));
var inst_122707 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_122703,cljs.core._LT_,inst_122706);
var state_122815__$1 = (function (){var statearr_122852 = state_122815;
(statearr_122852[(7)] = inst_122700);

return statearr_122852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(20),inst_122707);
} else {
if((state_val_122816 === (11))){
var inst_122670 = (state_122815[(12)]);
var inst_122662 = (state_122815[(17)]);
var inst_122670__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122662,(0),null);
var inst_122671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122662,(1),null);
var inst_122672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_122662,(2),null);
var inst_122673 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_122670__$1);
var inst_122674 = cljs.core.not(inst_122673);
var state_122815__$1 = (function (){var statearr_122853 = state_122815;
(statearr_122853[(12)] = inst_122670__$1);

(statearr_122853[(10)] = inst_122671);

(statearr_122853[(13)] = inst_122672);

return statearr_122853;
})();
if(inst_122674){
var statearr_122854_122913 = state_122815__$1;
(statearr_122854_122913[(1)] = (13));

} else {
var statearr_122855_122914 = state_122815__$1;
(statearr_122855_122914[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (9))){
var inst_122808 = (state_122815[(2)]);
var state_122815__$1 = state_122815;
var statearr_122856_122915 = state_122815__$1;
(statearr_122856_122915[(2)] = inst_122808);

(statearr_122856_122915[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (5))){
var inst_122641 = (state_122815[(8)]);
var inst_122651 = cljs.core.seq(inst_122641);
var inst_122652 = cljs.core.first(inst_122651);
var inst_122653 = cljs.core.next(inst_122651);
var inst_122654 = cljs.core.PersistentHashSet.EMPTY;
var inst_122655 = inst_122641;
var inst_122656 = inst_122654;
var state_122815__$1 = (function (){var statearr_122857 = state_122815;
(statearr_122857[(16)] = inst_122656);

(statearr_122857[(18)] = inst_122652);

(statearr_122857[(19)] = inst_122653);

(statearr_122857[(20)] = inst_122655);

return statearr_122857;
})();
var statearr_122858_122916 = state_122815__$1;
(statearr_122858_122916[(2)] = null);

(statearr_122858_122916[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (14))){
var state_122815__$1 = state_122815;
var statearr_122859_122917 = state_122815__$1;
(statearr_122859_122917[(2)] = null);

(statearr_122859_122917[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (45))){
var inst_122663 = (state_122815[(21)]);
var inst_122796 = (state_122815[(14)]);
var inst_122655 = inst_122663;
var inst_122656 = inst_122796;
var state_122815__$1 = (function (){var statearr_122860 = state_122815;
(statearr_122860[(16)] = inst_122656);

(statearr_122860[(20)] = inst_122655);

return statearr_122860;
})();
var statearr_122861_122918 = state_122815__$1;
(statearr_122861_122918[(2)] = null);

(statearr_122861_122918[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (26))){
var inst_122671 = (state_122815[(10)]);
var inst_122736 = (cljs.core._GT__EQ_ === inst_122671);
var state_122815__$1 = state_122815;
if(inst_122736){
var statearr_122862_122919 = state_122815__$1;
(statearr_122862_122919[(1)] = (29));

} else {
var statearr_122863_122920 = state_122815__$1;
(statearr_122863_122920[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (16))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122692 = [inst_122670,inst_122672];
var inst_122693 = (new cljs.core.PersistentVector(null,2,(5),inst_122691,inst_122692,null));
var inst_122694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122695 = [inst_122670];
var inst_122696 = (new cljs.core.PersistentVector(null,1,(5),inst_122694,inst_122695,null));
var inst_122697 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_122693,cljs.core._LT__EQ_,inst_122696);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(19),inst_122697);
} else {
if((state_val_122816 === (38))){
var inst_122775 = null;
var state_122815__$1 = state_122815;
var statearr_122864_122921 = state_122815__$1;
(statearr_122864_122921[(2)] = inst_122775);

(statearr_122864_122921[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (30))){
var inst_122671 = (state_122815[(10)]);
var inst_122749 = (cljs.core._LT_ === inst_122671);
var state_122815__$1 = state_122815;
if(inst_122749){
var statearr_122865_122922 = state_122815__$1;
(statearr_122865_122922[(1)] = (33));

} else {
var statearr_122866_122923 = state_122815__$1;
(statearr_122866_122923[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (10))){
var inst_122656 = (state_122815[(16)]);
var state_122815__$1 = state_122815;
var statearr_122867_122924 = state_122815__$1;
(statearr_122867_122924[(2)] = inst_122656);

(statearr_122867_122924[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (18))){
var inst_122640 = (state_122815[(9)]);
var inst_122787 = (state_122815[(2)]);
var inst_122788 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_122787);
var state_122815__$1 = (function (){var statearr_122868 = state_122815;
(statearr_122868[(15)] = inst_122788);

return statearr_122868;
})();
var G__122869_122925 = inst_122640;
var G__122869_122926__$1 = (((G__122869_122925 instanceof cljs.core.Keyword))?G__122869_122925.fqn:null);
switch (G__122869_122926__$1) {
case "or":
var statearr_122870_122928 = state_122815__$1;
(statearr_122870_122928[(1)] = (42));


break;
case "and":
var statearr_122871_122929 = state_122815__$1;
(statearr_122871_122929[(1)] = (43));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__122869_122926__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (42))){
var inst_122788 = (state_122815[(15)]);
var inst_122656 = (state_122815[(16)]);
var inst_122789 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_122656,inst_122788);
var state_122815__$1 = state_122815;
var statearr_122872_122930 = state_122815__$1;
(statearr_122872_122930[(2)] = inst_122789);

(statearr_122872_122930[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122816 === (37))){
var inst_122670 = (state_122815[(12)]);
var inst_122672 = (state_122815[(13)]);
var inst_122764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122765 = [inst_122670];
var inst_122766 = (new cljs.core.PersistentVector(null,1,(5),inst_122764,inst_122765,null));
var inst_122767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_122768 = [inst_122670,inst_122672];
var inst_122769 = (new cljs.core.PersistentVector(null,2,(5),inst_122767,inst_122768,null));
var inst_122770 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_122766,cljs.core._LT__EQ_,inst_122769);
var state_122815__$1 = state_122815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122815__$1,(40),inst_122770);
} else {
if((state_val_122816 === (8))){
var inst_122655 = (state_122815[(20)]);
var inst_122662 = (state_122815[(17)]);
var inst_122661 = cljs.core.seq(inst_122655);
var inst_122662__$1 = cljs.core.first(inst_122661);
var inst_122663 = cljs.core.next(inst_122661);
var inst_122664 = cljs.core.not(inst_122662__$1);
var state_122815__$1 = (function (){var statearr_122873 = state_122815;
(statearr_122873[(21)] = inst_122663);

(statearr_122873[(17)] = inst_122662__$1);

return statearr_122873;
})();
if(inst_122664){
var statearr_122874_122931 = state_122815__$1;
(statearr_122874_122931[(1)] = (10));

} else {
var statearr_122875_122932 = state_122815__$1;
(statearr_122875_122932[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$state_machine__109971__auto__ = null;
var fluree$db$query$fql$state_machine__109971__auto____0 = (function (){
var statearr_122876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_122876[(0)] = fluree$db$query$fql$state_machine__109971__auto__);

(statearr_122876[(1)] = (1));

return statearr_122876;
});
var fluree$db$query$fql$state_machine__109971__auto____1 = (function (state_122815){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_122815);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e122877){if((e122877 instanceof Object)){
var ex__109974__auto__ = e122877;
var statearr_122878_122933 = state_122815;
(statearr_122878_122933[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_122815);

return cljs.core.cst$kw$recur;
} else {
throw e122877;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__122934 = state_122815;
state_122815 = G__122934;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__109971__auto__ = function(state_122815){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__109971__auto____1.call(this,state_122815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__109971__auto____0;
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__109971__auto____1;
return fluree$db$query$fql$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_122879 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_122879[(6)] = c__110077__auto__);

return statearr_122879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3;

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__122936,offset,limit){
var map__122937 = p__122936;
var map__122937__$1 = (((((!((map__122937 == null))))?(((((map__122937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__122937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__122937):map__122937);
var res = map__122937__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__122937__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__122937__$1,cljs.core.cst$kw$tuples);
var vec__122939 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122939,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__122939,(1),null);
var indexOfFind = (function (){var or__4131__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__122942 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(((function (vec__122939,order,var$,indexOfFind,map__122937,map__122937__$1,res,headers,tuples){
return (function (p1__122935_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__122935_SHARP_,indexOfFind);
});})(vec__122939,order,var$,indexOfFind,map__122937,map__122937__$1,res,headers,tuples))
,fluree.db.query.fql.compare_fn,tuples);
var G__122942__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__122942):G__122942);
var G__122942__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__122942__$1):G__122942__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__122942__$2);
} else {
return G__122942__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4131__auto__ = cljs.core.every_QMARK_((function (p1__122943_SHARP_){
return ((typeof p1__122943_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__122943_SHARP_)));
}),select_smt);
if(or__4131__auto__){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_,vars__$1,all_vars){
return (function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
});})(_,vars__$1,all_vars))
,select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_(((function (vars,freqs){
return (function (p1__122944_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__122944_SHARP_);
});})(vars,freqs))
,cljs.core.vals(freqs))){
return vars;
} else {
var G__122948 = vars;
var vec__122949 = G__122948;
var seq__122950 = cljs.core.seq(vec__122949);
var first__122951 = cljs.core.first(seq__122950);
var seq__122950__$1 = cljs.core.next(seq__122950);
var var$ = first__122951;
var r = seq__122950__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__122948__$1 = G__122948;
var all_vars__$1 = all_vars;
while(true){
var vec__122956 = G__122948__$1;
var seq__122957 = cljs.core.seq(vec__122956);
var first__122958 = cljs.core.first(seq__122957);
var seq__122957__$1 = cljs.core.next(seq__122957);
var var$__$1 = first__122958;
var r__$1 = seq__122957__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__122959 = cljs.core.set(all_vars__$2);
return (fexpr__122959.cljs$core$IFn$_invoke$arity$1 ? fexpr__122959.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__122959.call(null,var$__$1));
})())){
var G__122960 = r__$1;
var G__122961 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__122948__$1 = G__122960;
all_vars__$1 = G__122961;
continue;
} else {
var G__122962 = r__$1;
var G__122963 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__122948__$1 = G__122962;
all_vars__$1 = G__122963;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_122997){
var state_val_122998 = (state_122997[(1)]);
if((state_val_122998 === (1))){
var inst_122971 = cljs.core.seq(functionArray);
var inst_122972 = cljs.core.first(inst_122971);
var inst_122973 = cljs.core.next(inst_122971);
var inst_122974 = cljs.core.PersistentVector.EMPTY;
var inst_122975 = functionArray;
var inst_122976 = inst_122974;
var state_122997__$1 = (function (){var statearr_122999 = state_122997;
(statearr_122999[(7)] = inst_122973);

(statearr_122999[(8)] = inst_122976);

(statearr_122999[(9)] = inst_122975);

(statearr_122999[(10)] = inst_122972);

return statearr_122999;
})();
var statearr_123000_123012 = state_122997__$1;
(statearr_123000_123012[(2)] = null);

(statearr_123000_123012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122998 === (2))){
var inst_122982 = (state_122997[(11)]);
var inst_122975 = (state_122997[(9)]);
var inst_122981 = cljs.core.seq(inst_122975);
var inst_122982__$1 = cljs.core.first(inst_122981);
var inst_122983 = cljs.core.next(inst_122981);
var state_122997__$1 = (function (){var statearr_123001 = state_122997;
(statearr_123001[(12)] = inst_122983);

(statearr_123001[(11)] = inst_122982__$1);

return statearr_123001;
})();
if(cljs.core.truth_(inst_122982__$1)){
var statearr_123002_123013 = state_122997__$1;
(statearr_123002_123013[(1)] = (4));

} else {
var statearr_123003_123014 = state_122997__$1;
(statearr_123003_123014[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_122998 === (3))){
var inst_122995 = (state_122997[(2)]);
var state_122997__$1 = state_122997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_122997__$1,inst_122995);
} else {
if((state_val_122998 === (4))){
var inst_122982 = (state_122997[(11)]);
var inst_122985 = (inst_122982.cljs$core$IFn$_invoke$arity$1 ? inst_122982.cljs$core$IFn$_invoke$arity$1(tuple) : inst_122982.call(null,tuple));
var state_122997__$1 = state_122997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_122997__$1,(7),inst_122985);
} else {
if((state_val_122998 === (5))){
var inst_122976 = (state_122997[(8)]);
var state_122997__$1 = state_122997;
var statearr_123004_123015 = state_122997__$1;
(statearr_123004_123015[(2)] = inst_122976);

(statearr_123004_123015[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122998 === (6))){
var inst_122993 = (state_122997[(2)]);
var state_122997__$1 = state_122997;
var statearr_123005_123016 = state_122997__$1;
(statearr_123005_123016[(2)] = inst_122993);

(statearr_123005_123016[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_122998 === (7))){
var inst_122983 = (state_122997[(12)]);
var inst_122976 = (state_122997[(8)]);
var inst_122987 = (state_122997[(2)]);
var inst_122988 = fluree.db.util.async.throw_err(inst_122987);
var inst_122989 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_122976,inst_122988);
var inst_122975 = inst_122983;
var inst_122976__$1 = inst_122989;
var state_122997__$1 = (function (){var statearr_123006 = state_122997;
(statearr_123006[(8)] = inst_122976__$1);

(statearr_123006[(9)] = inst_122975);

return statearr_123006;
})();
var statearr_123007_123017 = state_122997__$1;
(statearr_123007_123017[(2)] = null);

(statearr_123007_123017[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____0 = (function (){
var statearr_123008 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123008[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__);

(statearr_123008[(1)] = (1));

return statearr_123008;
});
var fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____1 = (function (state_122997){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_122997);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123009){if((e123009 instanceof Object)){
var ex__109974__auto__ = e123009;
var statearr_123010_123018 = state_122997;
(statearr_123010_123018[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_122997);

return cljs.core.cst$kw$recur;
} else {
throw e123009;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123019 = state_122997;
state_122997 = G__123019;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__ = function(state_122997){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____1.call(this,state_122997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__109971__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_123011 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123011[(6)] = c__110077__auto__);

return statearr_123011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__123021,headers,vars,opts){
var map__123022 = p__123021;
var map__123022__$1 = (((((!((map__123022 == null))))?(((((map__123022.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123022.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123022):map__123022);
var select_spec = map__123022__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123022__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123022__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123022__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123022__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_123105){
var state_val_123106 = (state_123105[(1)]);
if((state_val_123106 === (7))){
var inst_123032 = (state_123105[(2)]);
var state_123105__$1 = (function (){var statearr_123107 = state_123105;
(statearr_123107[(7)] = inst_123032);

return statearr_123107;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_123108_123221 = state_123105__$1;
(statearr_123108_123221[(1)] = (8));

} else {
var statearr_123109_123222 = state_123105__$1;
(statearr_123109_123222[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (1))){
var state_123105__$1 = state_123105;
var statearr_123110_123223 = state_123105__$1;
(statearr_123110_123223[(2)] = null);

(statearr_123110_123223[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_123105,(3),Error,null,(2));
var state_123105__$1 = state_123105;
if(cljs.core.truth_(prettyPrint)){
var statearr_123111_123224 = state_123105__$1;
(statearr_123111_123224[(1)] = (5));

} else {
var statearr_123112_123225 = state_123105__$1;
(statearr_123112_123225[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (13))){
var inst_123101 = (state_123105[(2)]);
var state_123105__$1 = state_123105;
var statearr_123113_123226 = state_123105__$1;
(statearr_123113_123226[(2)] = inst_123101);


cljs.core.async.impl.ioc_helpers.process_exception(state_123105__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (6))){
var state_123105__$1 = state_123105;
var statearr_123114_123227 = state_123105__$1;
(statearr_123114_123227[(2)] = null);

(statearr_123114_123227[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (3))){
var inst_123024 = (state_123105[(2)]);
var state_123105__$1 = state_123105;
var statearr_123115_123228 = state_123105__$1;
(statearr_123115_123228[(2)] = inst_123024);


cljs.core.async.impl.ioc_helpers.process_exception(state_123105__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (12))){
var inst_123040 = (state_123105[(8)]);
var inst_123032 = (state_123105[(7)]);
var inst_123098 = (function (){var pp = inst_123032;
var functionArray = inst_123040;
return ((function (pp,functionArray,inst_123040,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (pp,functionArray,inst_123040,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (p1__123020_SHARP_){
return (p1__123020_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__123020_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__123020_SHARP_.call(null,tuple));
});})(pp,functionArray,inst_123040,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
,functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
;})(pp,functionArray,inst_123040,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_123099 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_123098,tuples);
var state_123105__$1 = state_123105;
var statearr_123116_123229 = state_123105__$1;
(statearr_123116_123229[(2)] = inst_123099);

(statearr_123116_123229[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (2))){
var inst_123103 = (state_123105[(2)]);
var state_123105__$1 = state_123105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123105__$1,inst_123103);
} else {
if((state_val_123106 === (11))){
var inst_123040 = (state_123105[(8)]);
var inst_123032 = (state_123105[(7)]);
var inst_123091 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_123092 = (function (){var pp = inst_123032;
var functionArray = inst_123040;
var c__110077__auto____$1 = inst_123091;
return ((function (pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_123089){
var state_val_123090 = (state_123089[(1)]);
if((state_val_123090 === (7))){
var inst_123065 = (state_123089[(2)]);
var inst_123066 = fluree.db.util.async.throw_err(inst_123065);
var state_123089__$1 = (function (){var statearr_123117 = state_123089;
(statearr_123117[(7)] = inst_123066);

return statearr_123117;
})();
if(cljs.core.truth_(pp)){
var statearr_123118_123230 = state_123089__$1;
(statearr_123118_123230[(1)] = (8));

} else {
var statearr_123119_123231 = state_123089__$1;
(statearr_123119_123231[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (1))){
var inst_123049 = cljs.core.seq(tuples);
var inst_123050 = cljs.core.first(inst_123049);
var inst_123051 = cljs.core.next(inst_123049);
var inst_123052 = cljs.core.PersistentVector.EMPTY;
var inst_123053 = tuples;
var inst_123054 = inst_123052;
var state_123089__$1 = (function (){var statearr_123120 = state_123089;
(statearr_123120[(8)] = inst_123050);

(statearr_123120[(9)] = inst_123051);

(statearr_123120[(10)] = inst_123054);

(statearr_123120[(11)] = inst_123053);

return statearr_123120;
})();
var statearr_123121_123232 = state_123089__$1;
(statearr_123121_123232[(2)] = null);

(statearr_123121_123232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (4))){
var inst_123060 = (state_123089[(12)]);
var inst_123063 = fluree.db.query.fql.format_tuple(functionArray,inst_123060);
var state_123089__$1 = state_123089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123089__$1,(7),inst_123063);
} else {
if((state_val_123090 === (15))){
var state_123089__$1 = state_123089;
var statearr_123122_123233 = state_123089__$1;
(statearr_123122_123233[(2)] = null);

(statearr_123122_123233[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (13))){
var inst_123078 = (state_123089[(2)]);
var state_123089__$1 = state_123089;
var statearr_123123_123234 = state_123089__$1;
(statearr_123123_123234[(2)] = inst_123078);

(statearr_123123_123234[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (6))){
var inst_123085 = (state_123089[(2)]);
var state_123089__$1 = state_123089;
var statearr_123124_123235 = state_123089__$1;
(statearr_123124_123235[(2)] = inst_123085);

(statearr_123124_123235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (3))){
var inst_123087 = (state_123089[(2)]);
var state_123089__$1 = state_123089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123089__$1,inst_123087);
} else {
if((state_val_123090 === (12))){
var state_123089__$1 = state_123089;
var statearr_123125_123236 = state_123089__$1;
(statearr_123125_123236[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (2))){
var inst_123053 = (state_123089[(11)]);
var inst_123060 = (state_123089[(12)]);
var inst_123059 = cljs.core.seq(inst_123053);
var inst_123060__$1 = cljs.core.first(inst_123059);
var inst_123061 = cljs.core.next(inst_123059);
var state_123089__$1 = (function (){var statearr_123127 = state_123089;
(statearr_123127[(13)] = inst_123061);

(statearr_123127[(12)] = inst_123060__$1);

return statearr_123127;
})();
if(cljs.core.truth_(inst_123060__$1)){
var statearr_123128_123237 = state_123089__$1;
(statearr_123128_123237[(1)] = (4));

} else {
var statearr_123129_123238 = state_123089__$1;
(statearr_123129_123238[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (11))){
var inst_123066 = (state_123089[(7)]);
var state_123089__$1 = state_123089;
var statearr_123130_123239 = state_123089__$1;
(statearr_123130_123239[(2)] = inst_123066);

(statearr_123130_123239[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (9))){
var state_123089__$1 = state_123089;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_123131_123240 = state_123089__$1;
(statearr_123131_123240[(1)] = (11));

} else {
var statearr_123132_123241 = state_123089__$1;
(statearr_123132_123241[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (5))){
var inst_123054 = (state_123089[(10)]);
var state_123089__$1 = state_123089;
var statearr_123133_123242 = state_123089__$1;
(statearr_123133_123242[(2)] = inst_123054);

(statearr_123133_123242[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (14))){
var inst_123066 = (state_123089[(7)]);
var inst_123073 = cljs.core.first(inst_123066);
var state_123089__$1 = state_123089;
var statearr_123134_123243 = state_123089__$1;
(statearr_123134_123243[(2)] = inst_123073);

(statearr_123134_123243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (16))){
var inst_123076 = (state_123089[(2)]);
var state_123089__$1 = state_123089;
var statearr_123135_123244 = state_123089__$1;
(statearr_123135_123244[(2)] = inst_123076);

(statearr_123135_123244[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (10))){
var inst_123061 = (state_123089[(13)]);
var inst_123054 = (state_123089[(10)]);
var inst_123080 = (state_123089[(2)]);
var inst_123081 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_123054,inst_123080);
var inst_123053 = inst_123061;
var inst_123054__$1 = inst_123081;
var state_123089__$1 = (function (){var statearr_123136 = state_123089;
(statearr_123136[(10)] = inst_123054__$1);

(statearr_123136[(11)] = inst_123053);

return statearr_123136;
})();
var statearr_123137_123245 = state_123089__$1;
(statearr_123137_123245[(2)] = null);

(statearr_123137_123245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123090 === (8))){
var inst_123066 = (state_123089[(7)]);
var inst_123068 = cljs.core.zipmap(pp,inst_123066);
var state_123089__$1 = state_123089;
var statearr_123138_123246 = state_123089__$1;
(statearr_123138_123246[(2)] = inst_123068);

(statearr_123138_123246[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__109970__auto__,pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_123139 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123139[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__);

(statearr_123139[(1)] = (1));

return statearr_123139;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1 = (function (state_123089){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123089);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123140){if((e123140 instanceof Object)){
var ex__109974__auto__ = e123140;
var statearr_123141_123247 = state_123089;
(statearr_123141_123247[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123089);

return cljs.core.cst$kw$recur;
} else {
throw e123140;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123248 = state_123089;
state_123089 = G__123248;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = function(state_123089){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1.call(this,state_123089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__110079__auto__ = (function (){var statearr_123142 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123142[(6)] = c__110077__auto____$1);

return statearr_123142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});
;})(pp,functionArray,c__110077__auto____$1,inst_123040,inst_123032,inst_123091,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_123093 = cljs.core.async.impl.dispatch.run(inst_123092);
var state_123105__$1 = (function (){var statearr_123143 = state_123105;
(statearr_123143[(9)] = inst_123093);

return statearr_123143;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123105__$1,(14),inst_123091);
} else {
if((state_val_123106 === (9))){
var inst_123032 = (state_123105[(7)]);
var inst_123037 = (function (){var pp = inst_123032;
return ((function (pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return ((function (val,temp__5733__auto__,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (x){
return val;
});
;})(val,temp__5733__auto__,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return ((function (idx,temp__5733__auto__,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
;})(idx,temp__5733__auto__,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
}
});
;})(pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_123038 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_123037,select);
var state_123105__$1 = state_123105;
var statearr_123144_123249 = state_123105__$1;
(statearr_123144_123249[(2)] = inst_123038);

(statearr_123144_123249[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (5))){
var inst_123029 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_123105__$1 = state_123105;
var statearr_123145_123250 = state_123105__$1;
(statearr_123145_123250[(2)] = inst_123029);

(statearr_123145_123250[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (14))){
var inst_123095 = (state_123105[(2)]);
var inst_123096 = fluree.db.util.async.throw_err(inst_123095);
var state_123105__$1 = state_123105;
var statearr_123146_123251 = state_123105__$1;
(statearr_123146_123251[(2)] = inst_123096);

(statearr_123146_123251[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (10))){
var inst_123040 = (state_123105[(2)]);
var state_123105__$1 = (function (){var statearr_123147 = state_123105;
(statearr_123147[(8)] = inst_123040);

return statearr_123147;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_123148_123252 = state_123105__$1;
(statearr_123148_123252[(1)] = (11));

} else {
var statearr_123149_123253 = state_123105__$1;
(statearr_123149_123253[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123106 === (8))){
var inst_123032 = (state_123105[(7)]);
var inst_123034 = (function (){var pp = inst_123032;
return ((function (pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (select__$1){
var select_val = (function (){var or__4131__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?((function (select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});})(select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?((function (select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
});})(select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?((function (select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
});})(select_val,idx,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
:null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return ((function (select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var c__110077__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_123181){
var state_val_123182 = (state_123181[(1)]);
if((state_val_123182 === (7))){
var inst_123177 = (state_123181[(2)]);
var state_123181__$1 = state_123181;
var statearr_123183_123254 = state_123181__$1;
(statearr_123183_123254[(2)] = inst_123177);


cljs.core.async.impl.ioc_helpers.process_exception(state_123181__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (1))){
var state_123181__$1 = state_123181;
var statearr_123184_123255 = state_123181__$1;
(statearr_123184_123255[(2)] = null);

(statearr_123184_123255[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_123181,(3),Error,null,(2));
var inst_123154 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_123181__$1 = state_123181;
if(cljs.core.truth_(inst_123154)){
var statearr_123185_123256 = state_123181__$1;
(statearr_123185_123256[(1)] = (5));

} else {
var statearr_123186_123257 = state_123181__$1;
(statearr_123186_123257[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (6))){
var state_123181__$1 = state_123181;
var statearr_123187_123258 = state_123181__$1;
(statearr_123187_123258[(2)] = null);

(statearr_123187_123258[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (3))){
var inst_123150 = (state_123181[(2)]);
var state_123181__$1 = state_123181;
var statearr_123188_123259 = state_123181__$1;
(statearr_123188_123259[(2)] = inst_123150);


cljs.core.async.impl.ioc_helpers.process_exception(state_123181__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (2))){
var inst_123179 = (state_123181[(2)]);
var state_123181__$1 = state_123181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123181__$1,inst_123179);
} else {
if((state_val_123182 === (11))){
var inst_123174 = (state_123181[(2)]);
var state_123181__$1 = state_123181;
var statearr_123189_123260 = state_123181__$1;
(statearr_123189_123260[(2)] = inst_123174);

(statearr_123189_123260[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (9))){
var inst_123166 = (state_123181[(7)]);
var state_123181__$1 = state_123181;
var statearr_123190_123261 = state_123181__$1;
(statearr_123190_123261[(2)] = inst_123166);

(statearr_123190_123261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (5))){
var inst_123158 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_123159 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_123160 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_123161 = [inst_123159,inst_123160,opts];
var inst_123162 = cljs.core.PersistentHashMap.fromArrays(inst_123158,inst_123161);
var inst_123163 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_123162) : fluree.db.query.fql.query.call(null,db,inst_123162));
var state_123181__$1 = state_123181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123181__$1,(8),inst_123163);
} else {
if((state_val_123182 === (10))){
var inst_123169 = [cljs.core.cst$kw$_id];
var inst_123170 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_123171 = [inst_123170];
var inst_123172 = cljs.core.PersistentHashMap.fromArrays(inst_123169,inst_123171);
var state_123181__$1 = state_123181;
var statearr_123191_123262 = state_123181__$1;
(statearr_123191_123262[(2)] = inst_123172);

(statearr_123191_123262[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123182 === (8))){
var inst_123166 = (state_123181[(7)]);
var inst_123165 = (state_123181[(2)]);
var inst_123166__$1 = fluree.db.util.async.throw_err(inst_123165);
var state_123181__$1 = (function (){var statearr_123192 = state_123181;
(statearr_123192[(7)] = inst_123166__$1);

return statearr_123192;
})();
if(cljs.core.truth_(inst_123166__$1)){
var statearr_123193_123263 = state_123181__$1;
(statearr_123193_123263[(1)] = (9));

} else {
var statearr_123194_123264 = state_123181__$1;
(statearr_123194_123264[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__109970__auto__,c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_123195 = [null,null,null,null,null,null,null,null];
(statearr_123195[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__);

(statearr_123195[(1)] = (1));

return statearr_123195;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1 = (function (state_123181){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123181);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123196){if((e123196 instanceof Object)){
var ex__109974__auto__ = e123196;
var statearr_123197_123265 = state_123181;
(statearr_123197_123265[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123181);

return cljs.core.cst$kw$recur;
} else {
throw e123196;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123266 = state_123181;
state_123181 = G__123266;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = function(state_123181){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1.call(this,state_123181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__110079__auto__ = (function (){var statearr_123198 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123198[(6)] = c__110077__auto____$1);

return statearr_123198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__110077__auto____$1;
});
;})(select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
} else {
return ((function (select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (tuple){
var c__110077__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function (state_123207){
var state_val_123208 = (state_123207[(1)]);
if((state_val_123208 === (1))){
var state_123207__$1 = state_123207;
var statearr_123209_123267 = state_123207__$1;
(statearr_123209_123267[(2)] = null);

(statearr_123209_123267[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123208 === (2))){
var inst_123205 = (state_123207[(2)]);
var state_123207__$1 = state_123207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123207__$1,inst_123205);
} else {
if((state_val_123208 === (3))){
var inst_123199 = (state_123207[(2)]);
var state_123207__$1 = state_123207;
var statearr_123210_123268 = state_123207__$1;
(statearr_123210_123268[(2)] = inst_123199);


cljs.core.async.impl.ioc_helpers.process_exception(state_123207__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123208 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_123207,(3),Error,null,(2));
var inst_123203 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_123207__$1 = state_123207;
var statearr_123211_123269 = state_123207__$1;
(statearr_123211_123269[(2)] = inst_123203);


cljs.core.async.impl.ioc_helpers.process_exception(state_123207__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__109970__auto__,c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_123212 = [null,null,null,null,null,null,null];
(statearr_123212[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__);

(statearr_123212[(1)] = (1));

return statearr_123212;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1 = (function (state_123207){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123207);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123213){if((e123213 instanceof Object)){
var ex__109974__auto__ = e123213;
var statearr_123214_123270 = state_123207;
(statearr_123214_123270[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123207);

return cljs.core.cst$kw$recur;
} else {
throw e123213;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123271 = state_123207;
state_123207 = G__123271;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = function(state_123207){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1.call(this,state_123207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__110079__auto__ = (function (){var statearr_123215 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123215[(6)] = c__110077__auto____$1);

return statearr_123215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto____$1,select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__110077__auto____$1;
});
;})(select_val,idx,select_fn,pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
}
});
;})(pp,inst_123032,state_val_123106,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var inst_123035 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_123034,select);
var state_123105__$1 = state_123105;
var statearr_123216_123272 = state_123105__$1;
(statearr_123216_123272[(2)] = inst_123035);

(statearr_123216_123272[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_){
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_123217 = [null,null,null,null,null,null,null,null,null,null];
(statearr_123217[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__);

(statearr_123217[(1)] = (1));

return statearr_123217;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1 = (function (state_123105){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123105);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123218){if((e123218 instanceof Object)){
var ex__109974__auto__ = e123218;
var statearr_123219_123273 = state_123105;
(statearr_123219_123273[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123105);

return cljs.core.cst$kw$recur;
} else {
throw e123218;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123274 = state_123105;
state_123105 = G__123274;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__ = function(state_123105){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1.call(this,state_123105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
})();
var state__110079__auto__ = (function (){var statearr_123220 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123220[(6)] = c__110077__auto__);

return statearr_123220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__123022,map__123022__$1,select_spec,prettyPrint,select,inVector_QMARK_,expandMaps_QMARK_))
);

return c__110077__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__123276 = arguments.length;
switch (G__123276) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
});

fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__123277,p__123278,group_limit,opts){
var map__123279 = p__123277;
var map__123279__$1 = (((((!((map__123279 == null))))?(((((map__123279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123279):map__123279);
var res = map__123279__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123279__$1,cljs.core.cst$kw$vars);
var map__123280 = p__123278;
var map__123280__$1 = (((((!((map__123280 == null))))?(((((map__123280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123280.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123280):map__123280);
var select_spec = map__123280__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123280__$1,cljs.core.cst$kw$groupBy);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function (state_123386){
var state_val_123387 = (state_123386[(1)]);
if((state_val_123387 === (7))){
var inst_123292 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
if(cljs.core.truth_(inst_123292)){
var statearr_123388_123459 = state_123386__$1;
(statearr_123388_123459[(1)] = (8));

} else {
var statearr_123389_123460 = state_123386__$1;
(statearr_123389_123460[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (20))){
var state_123386__$1 = state_123386;
var statearr_123390_123461 = state_123386__$1;
(statearr_123390_123461[(2)] = (0));

(statearr_123390_123461[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (27))){
var state_123386__$1 = state_123386;
var statearr_123391_123462 = state_123386__$1;
(statearr_123391_123462[(2)] = false);

(statearr_123391_123462[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (1))){
var state_123386__$1 = state_123386;
var statearr_123392_123463 = state_123386__$1;
(statearr_123392_123463[(2)] = null);

(statearr_123392_123463[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (24))){
var inst_123321 = (state_123386[(7)]);
var state_123386__$1 = state_123386;
var statearr_123393_123464 = state_123386__$1;
(statearr_123393_123464[(2)] = inst_123321);

(statearr_123393_123464[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (39))){
var inst_123325 = (state_123386[(8)]);
var state_123386__$1 = state_123386;
var statearr_123394_123465 = state_123386__$1;
(statearr_123394_123465[(2)] = inst_123325);

(statearr_123394_123465[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (46))){
var inst_123372 = (state_123386[(9)]);
var state_123386__$1 = state_123386;
var statearr_123395_123466 = state_123386__$1;
(statearr_123395_123466[(2)] = inst_123372);

(statearr_123395_123466[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_123386,(3),Error,null,(2));
var state_123386__$1 = state_123386;
if(cljs.core.truth_(aggregates)){
var statearr_123396_123467 = state_123386__$1;
(statearr_123396_123467[(1)] = (5));

} else {
var statearr_123397_123468 = state_123386__$1;
(statearr_123397_123468[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (15))){
var inst_123307 = (state_123386[(10)]);
var state_123386__$1 = state_123386;
var statearr_123398_123469 = state_123386__$1;
(statearr_123398_123469[(2)] = inst_123307);

(statearr_123398_123469[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (21))){
var state_123386__$1 = state_123386;
var statearr_123399_123470 = state_123386__$1;
(statearr_123399_123470[(2)] = offset);

(statearr_123399_123470[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (31))){
var inst_123343 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123400_123471 = state_123386__$1;
(statearr_123400_123471[(2)] = inst_123343);

(statearr_123400_123471[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (32))){
var inst_123330 = (state_123386[(11)]);
var inst_123348 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_123330);
var state_123386__$1 = state_123386;
var statearr_123401_123472 = state_123386__$1;
(statearr_123401_123472[(2)] = inst_123348);

(statearr_123401_123472[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (40))){
var inst_123359 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123402_123473 = state_123386__$1;
(statearr_123402_123473[(2)] = inst_123359);

(statearr_123402_123473[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (33))){
var inst_123330 = (state_123386[(11)]);
var state_123386__$1 = state_123386;
var statearr_123403_123474 = state_123386__$1;
(statearr_123403_123474[(2)] = inst_123330);

(statearr_123403_123474[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (13))){
var inst_123307 = (state_123386[(2)]);
var state_123386__$1 = (function (){var statearr_123404 = state_123386;
(statearr_123404[(10)] = inst_123307);

return statearr_123404;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_123405_123475 = state_123386__$1;
(statearr_123405_123475[(1)] = (14));

} else {
var statearr_123406_123476 = state_123386__$1;
(statearr_123406_123476[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (22))){
var inst_123325 = (state_123386[(2)]);
var state_123386__$1 = (function (){var statearr_123407 = state_123386;
(statearr_123407[(8)] = inst_123325);

return statearr_123407;
})();
if(cljs.core.truth_(orderBy)){
var statearr_123408_123477 = state_123386__$1;
(statearr_123408_123477[(1)] = (23));

} else {
var statearr_123409_123478 = state_123386__$1;
(statearr_123409_123478[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (36))){
var inst_123354 = (state_123386[(12)]);
var state_123386__$1 = state_123386;
var statearr_123410_123479 = state_123386__$1;
(statearr_123410_123479[(2)] = inst_123354);

(statearr_123410_123479[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (41))){
var inst_123325 = (state_123386[(8)]);
var inst_123353 = (state_123386[(13)]);
var inst_123364 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_123325,inst_123353);
var inst_123365 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_123364);
var state_123386__$1 = state_123386;
var statearr_123411_123480 = state_123386__$1;
(statearr_123411_123480[(2)] = inst_123365);

(statearr_123411_123480[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (43))){
var inst_123352 = (state_123386[(14)]);
var inst_123368 = (state_123386[(2)]);
var inst_123369 = fluree.db.query.fql.format_filter_tuples(db,inst_123368,select_spec,inst_123352,vars,opts);
var state_123386__$1 = state_123386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123386__$1,(44),inst_123369);
} else {
if((state_val_123387 === (29))){
var state_123386__$1 = state_123386;
var statearr_123412_123481 = state_123386__$1;
(statearr_123412_123481[(2)] = true);

(statearr_123412_123481[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (44))){
var inst_123371 = (state_123386[(2)]);
var inst_123372 = fluree.db.util.async.throw_err(inst_123371);
var state_123386__$1 = (function (){var statearr_123413 = state_123386;
(statearr_123413[(9)] = inst_123372);

return statearr_123413;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_123414_123482 = state_123386__$1;
(statearr_123414_123482[(1)] = (45));

} else {
var statearr_123415_123483 = state_123386__$1;
(statearr_123415_123483[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (6))){
var state_123386__$1 = state_123386;
var statearr_123416_123484 = state_123386__$1;
(statearr_123416_123484[(2)] = aggregates);

(statearr_123416_123484[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (28))){
var inst_123346 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
if(cljs.core.truth_(inst_123346)){
var statearr_123417_123485 = state_123386__$1;
(statearr_123417_123485[(1)] = (32));

} else {
var statearr_123418_123486 = state_123386__$1;
(statearr_123418_123486[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (25))){
var inst_123330 = (state_123386[(11)]);
var inst_123330__$1 = (state_123386[(2)]);
var inst_123332 = (inst_123330__$1 == null);
var inst_123333 = cljs.core.not(inst_123332);
var state_123386__$1 = (function (){var statearr_123419 = state_123386;
(statearr_123419[(11)] = inst_123330__$1);

return statearr_123419;
})();
if(inst_123333){
var statearr_123420_123487 = state_123386__$1;
(statearr_123420_123487[(1)] = (26));

} else {
var statearr_123421_123488 = state_123386__$1;
(statearr_123421_123488[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (34))){
var inst_123354 = (state_123386[(12)]);
var inst_123351 = (state_123386[(2)]);
var inst_123352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_123351,cljs.core.cst$kw$headers);
var inst_123353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_123351,cljs.core.cst$kw$tuples);
var inst_123354__$1 = cljs.core.not(orderBy);
var state_123386__$1 = (function (){var statearr_123422 = state_123386;
(statearr_123422[(13)] = inst_123353);

(statearr_123422[(12)] = inst_123354__$1);

(statearr_123422[(14)] = inst_123352);

return statearr_123422;
})();
if(inst_123354__$1){
var statearr_123423_123489 = state_123386__$1;
(statearr_123423_123489[(1)] = (35));

} else {
var statearr_123424_123490 = state_123386__$1;
(statearr_123424_123490[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (17))){
var inst_123318 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_123386__$1 = state_123386;
var statearr_123425_123491 = state_123386__$1;
(statearr_123425_123491[(2)] = inst_123318);

(statearr_123425_123491[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (3))){
var inst_123283 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123426_123492 = state_123386__$1;
(statearr_123426_123492[(2)] = inst_123283);


cljs.core.async.impl.ioc_helpers.process_exception(state_123386__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (12))){
var inst_123296 = (state_123386[(15)]);
var state_123386__$1 = state_123386;
var statearr_123427_123493 = state_123386__$1;
(statearr_123427_123493[(2)] = inst_123296);

(statearr_123427_123493[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (2))){
var inst_123384 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123386__$1,inst_123384);
} else {
if((state_val_123387 === (23))){
var inst_123325 = (state_123386[(8)]);
var inst_123321 = (state_123386[(7)]);
var inst_123327 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_123321,inst_123325,group_limit);
var state_123386__$1 = state_123386;
var statearr_123428_123494 = state_123386__$1;
(statearr_123428_123494[(2)] = inst_123327);

(statearr_123428_123494[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (47))){
var inst_123380 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123429_123495 = state_123386__$1;
(statearr_123429_123495[(2)] = inst_123380);

(statearr_123429_123495[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (35))){
var state_123386__$1 = state_123386;
if(cljs.core.truth_(limit)){
var statearr_123430_123496 = state_123386__$1;
(statearr_123430_123496[(1)] = (38));

} else {
var statearr_123431_123497 = state_123386__$1;
(statearr_123431_123497[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (19))){
var inst_123321 = (state_123386[(2)]);
var state_123386__$1 = (function (){var statearr_123432 = state_123386;
(statearr_123432[(7)] = inst_123321);

return statearr_123432;
})();
if(cljs.core.truth_(groupBy)){
var statearr_123433_123498 = state_123386__$1;
(statearr_123433_123498[(1)] = (20));

} else {
var statearr_123434_123499 = state_123386__$1;
(statearr_123434_123499[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (11))){
var inst_123296 = (state_123386[(15)]);
var inst_123298 = cljs.core.first(select);
var inst_123299 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_123298);
var inst_123300 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_123299);
var inst_123301 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_123300,(1));
var inst_123302 = [inst_123301];
var inst_123303 = [inst_123296];
var inst_123304 = cljs.core.PersistentHashMap.fromArrays(inst_123302,inst_123303);
var state_123386__$1 = state_123386;
var statearr_123435_123500 = state_123386__$1;
(statearr_123435_123500[(2)] = inst_123304);

(statearr_123435_123500[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (9))){
var state_123386__$1 = state_123386;
if(cljs.core.truth_(aggregates)){
var statearr_123436_123501 = state_123386__$1;
(statearr_123436_123501[(1)] = (17));

} else {
var statearr_123437_123502 = state_123386__$1;
(statearr_123437_123502[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (5))){
var inst_123288 = cljs.core.count(select);
var inst_123289 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_123288);
var state_123386__$1 = state_123386;
var statearr_123438_123503 = state_123386__$1;
(statearr_123438_123503[(2)] = inst_123289);

(statearr_123438_123503[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (14))){
var inst_123307 = (state_123386[(10)]);
var inst_123309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123310 = [inst_123307];
var inst_123311 = (new cljs.core.PersistentVector(null,1,(5),inst_123309,inst_123310,null));
var state_123386__$1 = state_123386;
var statearr_123439_123504 = state_123386__$1;
(statearr_123439_123504[(2)] = inst_123311);

(statearr_123439_123504[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (45))){
var inst_123372 = (state_123386[(9)]);
var inst_123374 = cljs.core.PersistentVector.EMPTY;
var inst_123375 = cljs.core.PersistentHashSet.EMPTY;
var inst_123376 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_123375,inst_123372);
var inst_123377 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_123374,inst_123376);
var state_123386__$1 = state_123386;
var statearr_123440_123505 = state_123386__$1;
(statearr_123440_123505[(2)] = inst_123377);

(statearr_123440_123505[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (26))){
var inst_123330 = (state_123386[(11)]);
var inst_123335 = inst_123330.cljs$lang$protocol_mask$partition0$;
var inst_123336 = (inst_123335 & (64));
var inst_123337 = inst_123330.cljs$core$ISeq$;
var inst_123338 = (cljs.core.PROTOCOL_SENTINEL === inst_123337);
var inst_123339 = ((inst_123336) || (inst_123338));
var state_123386__$1 = state_123386;
if(cljs.core.truth_(inst_123339)){
var statearr_123441_123506 = state_123386__$1;
(statearr_123441_123506[(1)] = (29));

} else {
var statearr_123442_123507 = state_123386__$1;
(statearr_123442_123507[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (16))){
var inst_123314 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123443_123508 = state_123386__$1;
(statearr_123443_123508[(2)] = inst_123314);

(statearr_123443_123508[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (38))){
var state_123386__$1 = state_123386;
var statearr_123444_123509 = state_123386__$1;
(statearr_123444_123509[(2)] = limit);

(statearr_123444_123509[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (30))){
var state_123386__$1 = state_123386;
var statearr_123445_123510 = state_123386__$1;
(statearr_123445_123510[(2)] = false);

(statearr_123445_123510[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (10))){
var inst_123382 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
var statearr_123446_123511 = state_123386__$1;
(statearr_123446_123511[(2)] = inst_123382);


cljs.core.async.impl.ioc_helpers.process_exception(state_123386__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (18))){
var state_123386__$1 = state_123386;
var statearr_123447_123512 = state_123386__$1;
(statearr_123447_123512[(2)] = res);

(statearr_123447_123512[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (42))){
var inst_123353 = (state_123386[(13)]);
var state_123386__$1 = state_123386;
var statearr_123448_123513 = state_123386__$1;
(statearr_123448_123513[(2)] = inst_123353);

(statearr_123448_123513[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (37))){
var inst_123362 = (state_123386[(2)]);
var state_123386__$1 = state_123386;
if(cljs.core.truth_(inst_123362)){
var statearr_123449_123514 = state_123386__$1;
(statearr_123449_123514[(1)] = (41));

} else {
var statearr_123450_123515 = state_123386__$1;
(statearr_123450_123515[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123387 === (8))){
var inst_123294 = cljs.core.first(aggregates);
var inst_123295 = fluree.db.query.analytical.calculate_aggregate(res,inst_123294);
var inst_123296 = cljs.core.second(inst_123295);
var state_123386__$1 = (function (){var statearr_123451 = state_123386;
(statearr_123451[(15)] = inst_123296);

return statearr_123451;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_123452_123516 = state_123386__$1;
(statearr_123452_123516[(1)] = (11));

} else {
var statearr_123453_123517 = state_123386__$1;
(statearr_123453_123517[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy){
return (function() {
var fluree$db$query$fql$state_machine__109971__auto__ = null;
var fluree$db$query$fql$state_machine__109971__auto____0 = (function (){
var statearr_123454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123454[(0)] = fluree$db$query$fql$state_machine__109971__auto__);

(statearr_123454[(1)] = (1));

return statearr_123454;
});
var fluree$db$query$fql$state_machine__109971__auto____1 = (function (state_123386){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123386);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123455){if((e123455 instanceof Object)){
var ex__109974__auto__ = e123455;
var statearr_123456_123518 = state_123386;
(statearr_123456_123518[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123386);

return cljs.core.cst$kw$recur;
} else {
throw e123455;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123519 = state_123386;
state_123386 = G__123519;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__109971__auto__ = function(state_123386){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__109971__auto____1.call(this,state_123386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__109971__auto____0;
fluree$db$query$fql$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__109971__auto____1;
return fluree$db$query$fql$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
})();
var state__110079__auto__ = (function (){var statearr_123457 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123457[(6)] = c__110077__auto__);

return statearr_123457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__123279,map__123279__$1,res,vars,map__123280,map__123280__$1,select_spec,inVector_QMARK_,select,orderBy,limit,offset,aggregates,prettyPrint,selectDistinct_QMARK_,groupBy))
);

return c__110077__auto__;
});

fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5;

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__123522,groupBy){
var map__123523 = p__123522;
var map__123523__$1 = (((((!((map__123523 == null))))?(((((map__123523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123523):map__123523);
var res = map__123523__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123523__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123523__$1,cljs.core.cst$kw$tuples);
var vec__123525 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__123525,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__123525,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__123525,inVector_QMARK_,groupBy__$1,map__123523,map__123523__$1,res,headers,tuples){
return (function (p1__123520_SHARP_){
return fluree.db.util.core.index_of(headers,p1__123520_SHARP_);
});})(vec__123525,inVector_QMARK_,groupBy__$1,map__123523,map__123523__$1,res,headers,tuples))
,groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__123525,inVector_QMARK_,groupBy__$1,group_idxs,_,map__123523,map__123523__$1,res,headers,tuples){
return (function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__123525,inVector_QMARK_,groupBy__$1,group_idxs,_,map__123523,map__123523__$1,res,headers,tuples){
return (function (p1__123521_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__123521_SHARP_);
});})(vec__123525,inVector_QMARK_,groupBy__$1,group_idxs,_,map__123523,map__123523__$1,res,headers,tuples))
,group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
});})(vec__123525,inVector_QMARK_,groupBy__$1,group_idxs,_,map__123523,map__123523__$1,res,headers,tuples))
,cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__123528,p__123529,opts){
var map__123530 = p__123528;
var map__123530__$1 = (((((!((map__123530 == null))))?(((((map__123530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123530):map__123530);
var res = map__123530__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123530__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123530__$1,cljs.core.cst$kw$vars);
var map__123531 = p__123529;
var map__123531__$1 = (((((!((map__123531 == null))))?(((((map__123531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123531):map__123531);
var select_spec = map__123531__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123531__$1,cljs.core.cst$kw$offset);
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (state_123750){
var state_val_123751 = (state_123750[(1)]);
if((state_val_123751 === (65))){
var inst_123717 = (state_123750[(7)]);
var inst_123716 = (state_123750[(2)]);
var inst_123717__$1 = fluree.db.util.async.throw_err(inst_123716);
var inst_123718 = cljs.core.coll_QMARK_(inst_123717__$1);
var inst_123719 = (!(inst_123718));
var state_123750__$1 = (function (){var statearr_123752 = state_123750;
(statearr_123752[(7)] = inst_123717__$1);

return statearr_123752;
})();
if(inst_123719){
var statearr_123753_123867 = state_123750__$1;
(statearr_123753_123867[(1)] = (66));

} else {
var statearr_123754_123868 = state_123750__$1;
(statearr_123754_123868[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (70))){
var inst_123717 = (state_123750[(7)]);
var state_123750__$1 = state_123750;
var statearr_123755_123869 = state_123750__$1;
(statearr_123755_123869[(2)] = inst_123717);

(statearr_123755_123869[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (62))){
var state_123750__$1 = state_123750;
var statearr_123756_123870 = state_123750__$1;
(statearr_123756_123870[(2)] = (1));

(statearr_123756_123870[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (74))){
var inst_123742 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123757_123871 = state_123750__$1;
(statearr_123757_123871[(2)] = inst_123742);

(statearr_123757_123871[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (7))){
var inst_123746 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123758_123872 = state_123750__$1;
(statearr_123758_123872[(2)] = inst_123746);


cljs.core.async.impl.ioc_helpers.process_exception(state_123750__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (59))){
var inst_123700 = (state_123750[(8)]);
var inst_123586 = (state_123750[(9)]);
var inst_123702 = cljs.core.sorted_map_by(inst_123586);
var inst_123703 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_123702,inst_123700);
var state_123750__$1 = state_123750;
var statearr_123759_123873 = state_123750__$1;
(statearr_123759_123873[(2)] = inst_123703);

(statearr_123759_123873[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (20))){
var inst_123559 = cljs.core.set(groupBy);
var inst_123560 = cljs.core.second(orderBy);
var inst_123561 = (inst_123559.cljs$core$IFn$_invoke$arity$1 ? inst_123559.cljs$core$IFn$_invoke$arity$1(inst_123560) : inst_123559.call(null,inst_123560));
var state_123750__$1 = state_123750;
var statearr_123760_123874 = state_123750__$1;
(statearr_123760_123874[(2)] = inst_123561);

(statearr_123760_123874[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (72))){
var inst_123717 = (state_123750[(7)]);
var inst_123730 = cljs.core.first(inst_123717);
var state_123750__$1 = state_123750;
var statearr_123761_123875 = state_123750__$1;
(statearr_123761_123875[(2)] = inst_123730);

(statearr_123761_123875[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (58))){
var inst_123630 = (state_123750[(10)]);
var inst_123639 = (state_123750[(11)]);
var inst_123682 = (state_123750[(2)]);
var inst_123683 = fluree.db.util.async.throw_err(inst_123682);
var inst_123684 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_123630,inst_123639,inst_123683);
var state_123750__$1 = state_123750;
var statearr_123762_123876 = state_123750__$1;
(statearr_123762_123876[(2)] = inst_123684);

(statearr_123762_123876[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (60))){
var inst_123700 = (state_123750[(8)]);
var state_123750__$1 = state_123750;
var statearr_123763_123877 = state_123750__$1;
(statearr_123763_123877[(2)] = inst_123700);

(statearr_123763_123877[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (27))){
var inst_123567 = (state_123750[(12)]);
var inst_123568 = (state_123750[(13)]);
var inst_123539 = (state_123750[(14)]);
var inst_123573 = (function (){var group_map = inst_123539;
var orderByIdx = inst_123567;
var orderDirection = inst_123568;
return ((function (group_map,orderByIdx,orderDirection,inst_123567,inst_123568,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
;})(group_map,orderByIdx,orderDirection,inst_123567,inst_123568,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_123750__$1 = state_123750;
var statearr_123764_123878 = state_123750__$1;
(statearr_123764_123878[(2)] = inst_123573);

(statearr_123764_123878[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (1))){
var state_123750__$1 = state_123750;
var statearr_123765_123879 = state_123750__$1;
(statearr_123765_123879[(2)] = null);

(statearr_123765_123879[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (69))){
var inst_123717 = (state_123750[(7)]);
var inst_123722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_123723 = [inst_123717];
var inst_123724 = (new cljs.core.PersistentVector(null,1,(5),inst_123722,inst_123723,null));
var state_123750__$1 = state_123750;
var statearr_123766_123880 = state_123750__$1;
(statearr_123766_123880[(2)] = inst_123724);

(statearr_123766_123880[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (24))){
var state_123750__$1 = state_123750;
var statearr_123767_123881 = state_123750__$1;
(statearr_123767_123881[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (55))){
var inst_123657 = (state_123750[(15)]);
var inst_123654 = (state_123750[(16)]);
var inst_123642 = (state_123750[(17)]);
var inst_123677 = cljs.core.count(inst_123642);
var inst_123678 = (inst_123654 - limit);
var inst_123679 = (inst_123677 - inst_123678);
var inst_123680 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_123657,select_spec,inst_123679,opts);
var state_123750__$1 = state_123750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123750__$1,(58),inst_123680);
} else {
if((state_val_123751 === (39))){
var inst_123629 = (state_123750[(18)]);
var inst_123647 = (inst_123629 > (0));
var state_123750__$1 = state_123750;
if(cljs.core.truth_(inst_123647)){
var statearr_123769_123882 = state_123750__$1;
(statearr_123769_123882[(1)] = (41));

} else {
var statearr_123770_123883 = state_123750__$1;
(statearr_123770_123883[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (46))){
var inst_123694 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123771_123884 = state_123750__$1;
(statearr_123771_123884[(2)] = inst_123694);

(statearr_123771_123884[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_123750,(3),Error,null,(2));
var state_123750__$1 = state_123750;
if(cljs.core.truth_(groupBy)){
var statearr_123772_123885 = state_123750__$1;
(statearr_123772_123885[(1)] = (5));

} else {
var statearr_123773_123886 = state_123750__$1;
(statearr_123773_123886[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (77))){
var inst_123740 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123774_123887 = state_123750__$1;
(statearr_123774_123887[(2)] = inst_123740);

(statearr_123774_123887[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (54))){
var inst_123630 = (state_123750[(10)]);
var inst_123639 = (state_123750[(11)]);
var inst_123671 = (state_123750[(2)]);
var inst_123672 = fluree.db.util.async.throw_err(inst_123671);
var inst_123673 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_123630,inst_123639,inst_123672);
var state_123750__$1 = state_123750;
var statearr_123775_123888 = state_123750__$1;
(statearr_123775_123888[(2)] = inst_123673);

(statearr_123775_123888[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (15))){
var state_123750__$1 = state_123750;
var statearr_123777_123889 = state_123750__$1;
(statearr_123777_123889[(2)] = fluree.db.query.fql.compare_fn);

(statearr_123777_123889[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (48))){
var inst_123654 = (state_123750[(16)]);
var inst_123667 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_123654);
var state_123750__$1 = state_123750;
if(inst_123667){
var statearr_123778_123890 = state_123750__$1;
(statearr_123778_123890[(1)] = (51));

} else {
var statearr_123779_123891 = state_123750__$1;
(statearr_123779_123891[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (50))){
var inst_123629 = (state_123750[(18)]);
var inst_123643 = (state_123750[(19)]);
var inst_123640 = (state_123750[(20)]);
var inst_123630 = (state_123750[(10)]);
var inst_123639 = (state_123750[(11)]);
var inst_123654 = (state_123750[(16)]);
var inst_123662 = (state_123750[(2)]);
var inst_123663 = fluree.db.util.async.throw_err(inst_123662);
var inst_123664 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_123630,inst_123639,inst_123663);
var tmp123776 = inst_123629;
var inst_123626 = inst_123640;
var inst_123627 = inst_123643;
var inst_123628 = inst_123654;
var inst_123629__$1 = tmp123776;
var inst_123630__$1 = inst_123664;
var state_123750__$1 = (function (){var statearr_123780 = state_123750;
(statearr_123780[(18)] = inst_123629__$1);

(statearr_123780[(21)] = inst_123628);

(statearr_123780[(10)] = inst_123630__$1);

(statearr_123780[(22)] = inst_123626);

(statearr_123780[(23)] = inst_123627);

return statearr_123780;
})();
var statearr_123781_123892 = state_123750__$1;
(statearr_123781_123892[(2)] = null);

(statearr_123781_123892[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (75))){
var inst_123717 = (state_123750[(7)]);
var inst_123733 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_123717);
var state_123750__$1 = state_123750;
var statearr_123782_123893 = state_123750__$1;
(statearr_123782_123893[(2)] = inst_123733);

(statearr_123782_123893[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (21))){
var state_123750__$1 = state_123750;
var statearr_123783_123894 = state_123750__$1;
(statearr_123783_123894[(2)] = orderBy);

(statearr_123783_123894[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (31))){
var inst_123580 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123784_123895 = state_123750__$1;
(statearr_123784_123895[(2)] = inst_123580);

(statearr_123784_123895[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (32))){
var inst_123539 = (state_123750[(14)]);
var inst_123588 = cljs.core.keys(inst_123539);
var inst_123589 = cljs.core.first(inst_123588);
var inst_123590 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_123591 = cljs.core.vals(inst_123539);
var inst_123592 = cljs.core.first(inst_123591);
var inst_123593 = [headers,vars,inst_123592];
var inst_123594 = cljs.core.PersistentHashMap.fromArrays(inst_123590,inst_123593);
var inst_123595 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_123594,select_spec,limit,opts);
var state_123750__$1 = (function (){var statearr_123785 = state_123750;
(statearr_123785[(24)] = inst_123589);

return statearr_123785;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123750__$1,(35),inst_123595);
} else {
if((state_val_123751 === (40))){
var inst_123698 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123786_123896 = state_123750__$1;
(statearr_123786_123896[(2)] = inst_123698);

(statearr_123786_123896[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (56))){
var state_123750__$1 = state_123750;
var statearr_123787_123897 = state_123750__$1;
(statearr_123787_123897[(2)] = null);

(statearr_123787_123897[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (33))){
var inst_123539 = (state_123750[(14)]);
var inst_123617 = cljs.core.keys(inst_123539);
var inst_123618 = cljs.core.seq(inst_123617);
var inst_123619 = cljs.core.first(inst_123618);
var inst_123620 = cljs.core.next(inst_123618);
var inst_123621 = cljs.core.vals(inst_123539);
var inst_123622 = cljs.core.seq(inst_123621);
var inst_123623 = cljs.core.first(inst_123622);
var inst_123624 = cljs.core.next(inst_123622);
var inst_123625 = cljs.core.PersistentHashMap.EMPTY;
var inst_123626 = inst_123617;
var inst_123627 = inst_123621;
var inst_123628 = (0);
var inst_123629 = offset;
var inst_123630 = inst_123625;
var state_123750__$1 = (function (){var statearr_123788 = state_123750;
(statearr_123788[(25)] = inst_123624);

(statearr_123788[(18)] = inst_123629);

(statearr_123788[(21)] = inst_123628);

(statearr_123788[(26)] = inst_123623);

(statearr_123788[(10)] = inst_123630);

(statearr_123788[(27)] = inst_123620);

(statearr_123788[(22)] = inst_123626);

(statearr_123788[(28)] = inst_123619);

(statearr_123788[(23)] = inst_123627);

return statearr_123788;
})();
var statearr_123789_123898 = state_123750__$1;
(statearr_123789_123898[(2)] = null);

(statearr_123789_123898[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (13))){
var inst_123586 = (state_123750[(2)]);
var state_123750__$1 = (function (){var statearr_123790 = state_123750;
(statearr_123790[(9)] = inst_123586);

return statearr_123790;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_123791_123899 = state_123750__$1;
(statearr_123791_123899[(1)] = (32));

} else {
var statearr_123792_123900 = state_123750__$1;
(statearr_123792_123900[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (22))){
var inst_123564 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
if(cljs.core.truth_(inst_123564)){
var statearr_123795_123901 = state_123750__$1;
(statearr_123795_123901[(1)] = (23));

} else {
var statearr_123796_123902 = state_123750__$1;
(statearr_123796_123902[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (36))){
var inst_123626 = (state_123750[(22)]);
var inst_123627 = (state_123750[(23)]);
var inst_123642 = (state_123750[(17)]);
var inst_123638 = cljs.core.seq(inst_123626);
var inst_123639 = cljs.core.first(inst_123638);
var inst_123640 = cljs.core.next(inst_123638);
var inst_123641 = cljs.core.seq(inst_123627);
var inst_123642__$1 = cljs.core.first(inst_123641);
var inst_123643 = cljs.core.next(inst_123641);
var inst_123644 = (inst_123642__$1 == null);
var state_123750__$1 = (function (){var statearr_123797 = state_123750;
(statearr_123797[(19)] = inst_123643);

(statearr_123797[(20)] = inst_123640);

(statearr_123797[(11)] = inst_123639);

(statearr_123797[(17)] = inst_123642__$1);

return statearr_123797;
})();
if(cljs.core.truth_(inst_123644)){
var statearr_123798_123903 = state_123750__$1;
(statearr_123798_123903[(1)] = (38));

} else {
var statearr_123799_123904 = state_123750__$1;
(statearr_123799_123904[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (41))){
var inst_123629 = (state_123750[(18)]);
var inst_123628 = (state_123750[(21)]);
var inst_123643 = (state_123750[(19)]);
var inst_123640 = (state_123750[(20)]);
var inst_123630 = (state_123750[(10)]);
var inst_123649 = (inst_123629 - (1));
var tmp123793 = inst_123628;
var tmp123794 = inst_123630;
var inst_123626 = inst_123640;
var inst_123627 = inst_123643;
var inst_123628__$1 = tmp123793;
var inst_123629__$1 = inst_123649;
var inst_123630__$1 = tmp123794;
var state_123750__$1 = (function (){var statearr_123800 = state_123750;
(statearr_123800[(18)] = inst_123629__$1);

(statearr_123800[(21)] = inst_123628__$1);

(statearr_123800[(10)] = inst_123630__$1);

(statearr_123800[(22)] = inst_123626);

(statearr_123800[(23)] = inst_123627);

return statearr_123800;
})();
var statearr_123801_123905 = state_123750__$1;
(statearr_123801_123905[(2)] = null);

(statearr_123801_123905[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (43))){
var inst_123696 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123802_123906 = state_123750__$1;
(statearr_123802_123906[(2)] = inst_123696);

(statearr_123802_123906[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (61))){
var inst_123706 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123803_123907 = state_123750__$1;
(statearr_123803_123907[(2)] = inst_123706);

(statearr_123803_123907[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (29))){
var state_123750__$1 = state_123750;
var statearr_123804_123908 = state_123750__$1;
(statearr_123804_123908[(2)] = null);

(statearr_123804_123908[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (44))){
var inst_123628 = (state_123750[(21)]);
var inst_123654 = (state_123750[(16)]);
var inst_123642 = (state_123750[(17)]);
var inst_123653 = cljs.core.count(inst_123642);
var inst_123654__$1 = (inst_123628 + inst_123653);
var inst_123655 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_123656 = [headers,vars,inst_123642];
var inst_123657 = cljs.core.PersistentHashMap.fromArrays(inst_123655,inst_123656);
var inst_123658 = (limit > inst_123654__$1);
var state_123750__$1 = (function (){var statearr_123805 = state_123750;
(statearr_123805[(15)] = inst_123657);

(statearr_123805[(16)] = inst_123654__$1);

return statearr_123805;
})();
if(cljs.core.truth_(inst_123658)){
var statearr_123806_123909 = state_123750__$1;
(statearr_123806_123909[(1)] = (47));

} else {
var statearr_123807_123910 = state_123750__$1;
(statearr_123807_123910[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (6))){
var state_123750__$1 = state_123750;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_123808_123911 = state_123750__$1;
(statearr_123808_123911[(1)] = (62));

} else {
var statearr_123809_123912 = state_123750__$1;
(statearr_123809_123912[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (28))){
var inst_123575 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123810_123913 = state_123750__$1;
(statearr_123810_123913[(2)] = inst_123575);

(statearr_123810_123913[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (64))){
var inst_123713 = (state_123750[(2)]);
var inst_123714 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_123713,opts);
var state_123750__$1 = state_123750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123750__$1,(65),inst_123714);
} else {
if((state_val_123751 === (51))){
var inst_123657 = (state_123750[(15)]);
var inst_123669 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_123657,select_spec,opts);
var state_123750__$1 = state_123750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123750__$1,(54),inst_123669);
} else {
if((state_val_123751 === (25))){
var inst_123582 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123811_123914 = state_123750__$1;
(statearr_123811_123914[(2)] = inst_123582);

(statearr_123811_123914[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (34))){
var inst_123708 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123812_123915 = state_123750__$1;
(statearr_123812_123915[(2)] = inst_123708);

(statearr_123812_123915[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (17))){
var state_123750__$1 = state_123750;
var statearr_123813_123916 = state_123750__$1;
(statearr_123813_123916[(2)] = null);

(statearr_123813_123916[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (3))){
var inst_123534 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123814_123917 = state_123750__$1;
(statearr_123814_123917[(2)] = inst_123534);


cljs.core.async.impl.ioc_helpers.process_exception(state_123750__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (12))){
var inst_123555 = cljs.core.not(orderBy);
var state_123750__$1 = state_123750;
if(inst_123555){
var statearr_123815_123918 = state_123750__$1;
(statearr_123815_123918[(1)] = (17));

} else {
var statearr_123816_123919 = state_123750__$1;
(statearr_123816_123919[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (2))){
var inst_123748 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_123750__$1,inst_123748);
} else {
if((state_val_123751 === (66))){
var state_123750__$1 = state_123750;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_123817_123920 = state_123750__$1;
(statearr_123817_123920[(1)] = (69));

} else {
var statearr_123818_123921 = state_123750__$1;
(statearr_123818_123921[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (23))){
var inst_123568 = (state_123750[(13)]);
var inst_123566 = cljs.core.second(orderBy);
var inst_123567 = fluree.db.util.core.index_of(groupBy,inst_123566);
var inst_123568__$1 = cljs.core.first(orderBy);
var inst_123569 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_123568__$1);
var state_123750__$1 = (function (){var statearr_123819 = state_123750;
(statearr_123819[(12)] = inst_123567);

(statearr_123819[(13)] = inst_123568__$1);

return statearr_123819;
})();
if(inst_123569){
var statearr_123820_123922 = state_123750__$1;
(statearr_123820_123922[(1)] = (26));

} else {
var statearr_123821_123923 = state_123750__$1;
(statearr_123821_123923[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (47))){
var inst_123657 = (state_123750[(15)]);
var inst_123660 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_123657,select_spec,opts);
var state_123750__$1 = state_123750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_123750__$1,(50),inst_123660);
} else {
if((state_val_123751 === (35))){
var inst_123589 = (state_123750[(24)]);
var inst_123597 = (state_123750[(2)]);
var inst_123598 = fluree.db.util.async.throw_err(inst_123597);
var inst_123599 = [inst_123589];
var inst_123600 = [inst_123598];
var inst_123601 = cljs.core.PersistentHashMap.fromArrays(inst_123599,inst_123600);
var state_123750__$1 = state_123750;
var statearr_123822_123924 = state_123750__$1;
(statearr_123822_123924[(2)] = inst_123601);

(statearr_123822_123924[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (76))){
var state_123750__$1 = state_123750;
var statearr_123823_123925 = state_123750__$1;
(statearr_123823_123925[(1)] = (78));



return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (19))){
var inst_123584 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123825_123926 = state_123750__$1;
(statearr_123825_123926[(2)] = inst_123584);

(statearr_123825_123926[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (57))){
var inst_123687 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123826_123927 = state_123750__$1;
(statearr_123826_123927[(2)] = inst_123687);

(statearr_123826_123927[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (68))){
var inst_123744 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123827_123928 = state_123750__$1;
(statearr_123827_123928[(2)] = inst_123744);

(statearr_123827_123928[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (11))){
var inst_123547 = cljs.core.first(orderBy);
var inst_123548 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_123547,"DESC");
var state_123750__$1 = state_123750;
if(inst_123548){
var statearr_123828_123929 = state_123750__$1;
(statearr_123828_123929[(1)] = (14));

} else {
var statearr_123829_123930 = state_123750__$1;
(statearr_123829_123930[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (9))){
var state_123750__$1 = state_123750;
var statearr_123830_123931 = state_123750__$1;
(statearr_123830_123931[(2)] = orderBy);

(statearr_123830_123931[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (5))){
var inst_123539 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_123750__$1 = (function (){var statearr_123831 = state_123750;
(statearr_123831[(14)] = inst_123539);

return statearr_123831;
})();
if(cljs.core.truth_(orderBy)){
var statearr_123832_123932 = state_123750__$1;
(statearr_123832_123932[(1)] = (8));

} else {
var statearr_123833_123933 = state_123750__$1;
(statearr_123833_123933[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (14))){
var inst_123539 = (state_123750[(14)]);
var inst_123550 = (function (){var group_map = inst_123539;
return ((function (group_map,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
;})(group_map,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_123750__$1 = state_123750;
var statearr_123834_123934 = state_123750__$1;
(statearr_123834_123934[(2)] = inst_123550);

(statearr_123834_123934[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (45))){
var state_123750__$1 = state_123750;
var statearr_123835_123935 = state_123750__$1;
(statearr_123835_123935[(2)] = null);

(statearr_123835_123935[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (53))){
var inst_123689 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123836_123936 = state_123750__$1;
(statearr_123836_123936[(2)] = inst_123689);

(statearr_123836_123936[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (78))){
var inst_123717 = (state_123750[(7)]);
var state_123750__$1 = state_123750;
var statearr_123837_123937 = state_123750__$1;
(statearr_123837_123937[(2)] = inst_123717);

(statearr_123837_123937[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (26))){
var inst_123567 = (state_123750[(12)]);
var inst_123568 = (state_123750[(13)]);
var inst_123539 = (state_123750[(14)]);
var inst_123571 = (function (){var group_map = inst_123539;
var orderByIdx = inst_123567;
var orderDirection = inst_123568;
return ((function (group_map,orderByIdx,orderDirection,inst_123567,inst_123568,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
;})(group_map,orderByIdx,orderDirection,inst_123567,inst_123568,inst_123539,state_val_123751,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state_123750__$1 = state_123750;
var statearr_123838_123938 = state_123750__$1;
(statearr_123838_123938[(2)] = inst_123571);

(statearr_123838_123938[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (16))){
var inst_123553 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123839_123939 = state_123750__$1;
(statearr_123839_123939[(2)] = inst_123553);

(statearr_123839_123939[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (79))){
var state_123750__$1 = state_123750;
var statearr_123840_123940 = state_123750__$1;
(statearr_123840_123940[(2)] = null);

(statearr_123840_123940[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (38))){
var inst_123630 = (state_123750[(10)]);
var state_123750__$1 = state_123750;
var statearr_123841_123941 = state_123750__$1;
(statearr_123841_123941[(2)] = inst_123630);

(statearr_123841_123941[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (30))){
var state_123750__$1 = state_123750;
var statearr_123842_123942 = state_123750__$1;
(statearr_123842_123942[(2)] = null);

(statearr_123842_123942[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (73))){
var state_123750__$1 = state_123750;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_123843_123943 = state_123750__$1;
(statearr_123843_123943[(1)] = (75));

} else {
var statearr_123844_123944 = state_123750__$1;
(statearr_123844_123944[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (10))){
var inst_123545 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
if(cljs.core.truth_(inst_123545)){
var statearr_123845_123945 = state_123750__$1;
(statearr_123845_123945[(1)] = (11));

} else {
var statearr_123846_123946 = state_123750__$1;
(statearr_123846_123946[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (18))){
var state_123750__$1 = state_123750;
if(cljs.core.truth_(orderBy)){
var statearr_123847_123947 = state_123750__$1;
(statearr_123847_123947[(1)] = (20));

} else {
var statearr_123848_123948 = state_123750__$1;
(statearr_123848_123948[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (52))){
var inst_123654 = (state_123750[(16)]);
var inst_123675 = (limit < inst_123654);
var state_123750__$1 = state_123750;
if(cljs.core.truth_(inst_123675)){
var statearr_123849_123949 = state_123750__$1;
(statearr_123849_123949[(1)] = (55));

} else {
var statearr_123850_123950 = state_123750__$1;
(statearr_123850_123950[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (67))){
var state_123750__$1 = state_123750;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_123851_123951 = state_123750__$1;
(statearr_123851_123951[(1)] = (72));

} else {
var statearr_123852_123952 = state_123750__$1;
(statearr_123852_123952[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (71))){
var inst_123727 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123853_123953 = state_123750__$1;
(statearr_123853_123953[(2)] = inst_123727);

(statearr_123853_123953[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (42))){
var state_123750__$1 = state_123750;
var statearr_123854_123954 = state_123750__$1;
(statearr_123854_123954[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (80))){
var inst_123738 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123856_123955 = state_123750__$1;
(statearr_123856_123955[(2)] = inst_123738);

(statearr_123856_123955[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (37))){
var inst_123586 = (state_123750[(9)]);
var inst_123700 = (state_123750[(2)]);
var state_123750__$1 = (function (){var statearr_123857 = state_123750;
(statearr_123857[(8)] = inst_123700);

return statearr_123857;
})();
if(cljs.core.truth_(inst_123586)){
var statearr_123858_123956 = state_123750__$1;
(statearr_123858_123956[(1)] = (59));

} else {
var statearr_123859_123957 = state_123750__$1;
(statearr_123859_123957[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (63))){
var state_123750__$1 = state_123750;
var statearr_123860_123958 = state_123750__$1;
(statearr_123860_123958[(2)] = limit);

(statearr_123860_123958[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (8))){
var inst_123541 = cljs.core.second(orderBy);
var inst_123542 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_123541,groupBy);
var state_123750__$1 = state_123750;
var statearr_123861_123959 = state_123750__$1;
(statearr_123861_123959[(2)] = inst_123542);

(statearr_123861_123959[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_123751 === (49))){
var inst_123691 = (state_123750[(2)]);
var state_123750__$1 = state_123750;
var statearr_123862_123960 = state_123750__$1;
(statearr_123862_123960[(2)] = inst_123691);

(statearr_123862_123960[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
;
return ((function (switch__109970__auto__,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset){
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____0 = (function (){
var statearr_123863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_123863[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__);

(statearr_123863[(1)] = (1));

return statearr_123863;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____1 = (function (state_123750){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_123750);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e123864){if((e123864 instanceof Object)){
var ex__109974__auto__ = e123864;
var statearr_123865_123961 = state_123750;
(statearr_123865_123961[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_123750);

return cljs.core.cst$kw$recur;
} else {
throw e123864;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__123962 = state_123750;
state_123750 = G__123962;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__ = function(state_123750){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____1.call(this,state_123750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
})();
var state__110079__auto__ = (function (){var statearr_123866 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_123866[(6)] = c__110077__auto__);

return statearr_123866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,map__123530,map__123530__$1,res,headers,vars,map__123531,map__123531__$1,select_spec,groupBy,orderBy,limit,selectOne_QMARK_,selectDistinct_QMARK_,inVector_QMARK_,offset))
);

return c__110077__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__123965,opts){
var map__123966 = p__123965;
var map__123966__$1 = (((((!((map__123966 == null))))?(((((map__123966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123966):map__123966);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123966__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123966__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123966__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123966__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4131__auto__ = selectOne;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = select;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (select_smt,inVector_QMARK_,select_smt__$1,parsed_select,map__123966,map__123966__$1,selectOne,select,selectDistinct,selectReduced){
return (function (p1__123963_SHARP_){
return cljs.core.contains_QMARK_(p1__123963_SHARP_,cljs.core.cst$kw$code);
});})(select_smt,inVector_QMARK_,select_smt__$1,parsed_select,map__123966,map__123966__$1,selectOne,select,selectDistinct,selectReduced))
,parsed_select);
var expandMap_QMARK_ = cljs.core.some(((function (select_smt,inVector_QMARK_,select_smt__$1,parsed_select,aggregates,map__123966,map__123966__$1,selectOne,select,selectDistinct,selectReduced){
return (function (p1__123964_SHARP_){
return cljs.core.contains_QMARK_(p1__123964_SHARP_,cljs.core.cst$kw$selection);
});})(select_smt,inVector_QMARK_,select_smt__$1,parsed_select,aggregates,map__123966,map__123966__$1,selectOne,select,selectDistinct,selectReduced))
,parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4131__auto__ = typeof orderBy === 'string';
if(or__4131__auto__){
return or__4131__auto__;
} else {
var and__4120__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4120__auto__){
var G__123975 = cljs.core.first(orderBy);
var fexpr__123974 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__123974.cljs$core$IFn$_invoke$arity$1 ? fexpr__123974.cljs$core$IFn$_invoke$arity$1(G__123975) : fexpr__123974.call(null,G__123975));
} else {
return and__4120__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4131__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (100);
}
})(),(function (){var or__4131__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4131__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4131__auto__ = selectDistinct;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__123976,p__123977){
var map__123978 = p__123976;
var map__123978__$1 = (((((!((map__123978 == null))))?(((((map__123978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123978.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123978):map__123978);
var query_map = map__123978__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123978__$1,cljs.core.cst$kw$construct);
var map__123979 = p__123977;
var map__123979__$1 = (((((!((map__123979 == null))))?(((((map__123979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__123979.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__123979):map__123979);
var where_result = map__123979__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123979__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__123979__$1,cljs.core.cst$kw$tuples);
var vec__123982 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples){
return (function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return ((function (index_of,temp__5733__auto__,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples){
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
;})(index_of,temp__5733__auto__,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples))
} else {
return ((function (temp__5733__auto__,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples){
return (function (row){
return construct_item;
});
;})(temp__5733__auto__,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples))
}
});})(map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples))
,construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__123982,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__123982,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__123982,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__123982,fn1,fn2,fn3,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples){
return (function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
});})(vec__123982,fn1,fn2,fn3,map__123978,map__123978__$1,query_map,construct,map__123979,map__123979__$1,where_result,headers,tuples))
,tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_124012){
var state_val_124013 = (state_124012[(1)]);
if((state_val_124013 === (7))){
var state_124012__$1 = state_124012;
var statearr_124014_124030 = state_124012__$1;
(statearr_124014_124030[(1)] = (9));



return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (1))){
var state_124012__$1 = state_124012;
var statearr_124016_124031 = state_124012__$1;
(statearr_124016_124031[(2)] = null);

(statearr_124016_124031[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_124012,(3),Error,null,(2));
var inst_123989 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_124012__$1 = state_124012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124012__$1,(5),inst_123989);
} else {
if((state_val_124013 === (6))){
var inst_123992 = (state_124012[(7)]);
var state_124012__$1 = state_124012;
var statearr_124017_124032 = state_124012__$1;
(statearr_124017_124032[(2)] = inst_123992);

(statearr_124017_124032[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (3))){
var inst_123985 = (state_124012[(2)]);
var state_124012__$1 = state_124012;
var statearr_124018_124033 = state_124012__$1;
(statearr_124018_124033[(2)] = inst_123985);


cljs.core.async.impl.ioc_helpers.process_exception(state_124012__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (12))){
var inst_124002 = (state_124012[(2)]);
var inst_124003 = fluree.db.util.async.throw_err(inst_124002);
var state_124012__$1 = state_124012;
var statearr_124019_124034 = state_124012__$1;
(statearr_124019_124034[(2)] = inst_124003);

(statearr_124019_124034[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (2))){
var inst_124010 = (state_124012[(2)]);
var state_124012__$1 = state_124012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_124012__$1,inst_124010);
} else {
if((state_val_124013 === (11))){
var inst_124006 = (state_124012[(2)]);
var state_124012__$1 = state_124012;
var statearr_124020_124035 = state_124012__$1;
(statearr_124020_124035[(2)] = inst_124006);

(statearr_124020_124035[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (9))){
var inst_123992 = (state_124012[(7)]);
var inst_123997 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_123992);
var inst_123998 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_123992);
var inst_123999 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_123997,inst_123998,query_map,opts);
var inst_124000 = fluree.db.query.fql.process_ad_hoc_res(db,inst_123992,inst_123999,opts);
var state_124012__$1 = state_124012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124012__$1,(12),inst_124000);
} else {
if((state_val_124013 === (5))){
var inst_123992 = (state_124012[(7)]);
var inst_123991 = (state_124012[(2)]);
var inst_123992__$1 = fluree.db.util.async.throw_err(inst_123991);
var inst_123993 = fluree.db.util.core.exception_QMARK_(inst_123992__$1);
var state_124012__$1 = (function (){var statearr_124021 = state_124012;
(statearr_124021[(7)] = inst_123992__$1);

return statearr_124021;
})();
if(inst_123993){
var statearr_124022_124036 = state_124012__$1;
(statearr_124022_124036[(1)] = (6));

} else {
var statearr_124023_124037 = state_124012__$1;
(statearr_124023_124037[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (10))){
var state_124012__$1 = state_124012;
var statearr_124024_124038 = state_124012__$1;
(statearr_124024_124038[(2)] = null);

(statearr_124024_124038[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124013 === (8))){
var inst_124008 = (state_124012[(2)]);
var state_124012__$1 = state_124012;
var statearr_124025_124039 = state_124012__$1;
(statearr_124025_124039[(2)] = inst_124008);


cljs.core.async.impl.ioc_helpers.process_exception(state_124012__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____0 = (function (){
var statearr_124026 = [null,null,null,null,null,null,null,null];
(statearr_124026[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__);

(statearr_124026[(1)] = (1));

return statearr_124026;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____1 = (function (state_124012){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_124012);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e124027){if((e124027 instanceof Object)){
var ex__109974__auto__ = e124027;
var statearr_124028_124040 = state_124012;
(statearr_124028_124040[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_124012);

return cljs.core.cst$kw$recur;
} else {
throw e124027;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__124041 = state_124012;
state_124012 = G__124041;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__ = function(state_124012){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____1.call(this,state_124012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_124029 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_124029[(6)] = c__110077__auto__);

return statearr_124029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__124042 = query_map;
var map__124042__$1 = (((((!((map__124042 == null))))?(((((map__124042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__124042.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__124042):map__124042);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__124042__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4131__auto__ = offset;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
var opts_SINGLEQUOTE__SINGLEQUOTE_ = (cljs.core.truth_(selectOne)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,cljs.core.cst$kw$limit,(1)):opts_SINGLEQUOTE_);
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE__SINGLEQUOTE_);
var fuel = (function (){var or__4131__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.truth_((function (){var or__4131__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
} else {
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function (state_124396){
var state_val_124397 = (state_124396[(1)]);
if((state_val_124397 === (121))){
var inst_124379 = (state_124396[(7)]);
var inst_124381 = cljs.core.coll_QMARK_(inst_124379);
var inst_124382 = fluree.db.util.core.exception_QMARK_(inst_124379);
var inst_124383 = (!(inst_124382));
var inst_124384 = ((inst_124381) && (inst_124383));
var state_124396__$1 = state_124396;
var statearr_124398_124571 = state_124396__$1;
(statearr_124398_124571[(2)] = inst_124384);

(statearr_124398_124571[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (65))){
var inst_124224 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124224)){
var statearr_124399_124572 = state_124396__$1;
(statearr_124399_124572[(1)] = (66));

} else {
var statearr_124400_124573 = state_124396__$1;
(statearr_124400_124573[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (70))){
var inst_124110 = (state_124396[(8)]);
var inst_124108 = (state_124396[(9)]);
var inst_124229 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_124230 = [inst_124108,inst_124110];
var inst_124231 = cljs.core.PersistentHashMap.fromArrays(inst_124229,inst_124230);
var state_124396__$1 = state_124396;
var statearr_124401_124574 = state_124396__$1;
(statearr_124401_124574[(2)] = inst_124231);

(statearr_124401_124574[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (62))){
var inst_124212 = (state_124396[(2)]);
var inst_124213 = fluree.db.util.async.throw_err(inst_124212);
var state_124396__$1 = state_124396;
var statearr_124402_124575 = state_124396__$1;
(statearr_124402_124575[(2)] = inst_124213);

(statearr_124402_124575[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (74))){
var inst_124107 = (state_124396[(10)]);
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124107)){
var statearr_124403_124576 = state_124396__$1;
(statearr_124403_124576[(1)] = (77));

} else {
var statearr_124404_124577 = state_124396__$1;
(statearr_124404_124577[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (110))){
var inst_124312 = (state_124396[(11)]);
var inst_124336 = (state_124396[(2)]);
var inst_124304 = inst_124312;
var inst_124305 = inst_124336;
var state_124396__$1 = (function (){var statearr_124405 = state_124396;
(statearr_124405[(12)] = inst_124305);

(statearr_124405[(13)] = inst_124304);

return statearr_124405;
})();
var statearr_124406_124578 = state_124396__$1;
(statearr_124406_124578[(2)] = null);

(statearr_124406_124578[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (7))){
var inst_124085 = (state_124396[(2)]);
var inst_124087 = (opts_SINGLEQUOTE__SINGLEQUOTE_ == null);
var inst_124088 = cljs.core.not(inst_124087);
var state_124396__$1 = (function (){var statearr_124407 = state_124396;
(statearr_124407[(14)] = inst_124085);

return statearr_124407;
})();
if(inst_124088){
var statearr_124408_124579 = state_124396__$1;
(statearr_124408_124579[(1)] = (14));

} else {
var statearr_124409_124580 = state_124396__$1;
(statearr_124409_124580[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (59))){
var inst_124110 = (state_124396[(8)]);
var inst_124108 = (state_124396[(9)]);
var inst_124197 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_124198 = [inst_124108,inst_124110];
var inst_124199 = cljs.core.PersistentHashMap.fromArrays(inst_124197,inst_124198);
var state_124396__$1 = state_124396;
var statearr_124410_124581 = state_124396__$1;
(statearr_124410_124581[(2)] = inst_124199);

(statearr_124410_124581[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (86))){
var state_124396__$1 = state_124396;
var statearr_124411_124582 = state_124396__$1;
(statearr_124411_124582[(2)] = null);

(statearr_124411_124582[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (20))){
var inst_124103 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts_SINGLEQUOTE__SINGLEQUOTE_);
var state_124396__$1 = state_124396;
var statearr_124412_124583 = state_124396__$1;
(statearr_124412_124583[(2)] = inst_124103);

(statearr_124412_124583[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (72))){
var inst_124118 = (state_124396[(15)]);
var inst_124120 = (state_124396[(16)]);
var inst_124236 = (state_124396[(2)]);
var inst_124237 = fluree.db.util.async.throw_err(inst_124236);
var inst_124238 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_124120,fuel,max_fuel,inst_124118,inst_124237);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(73),inst_124238);
} else {
if((state_val_124397 === (58))){
var inst_124195 = cljs.core.PersistentHashMap.EMPTY;
var state_124396__$1 = state_124396;
var statearr_124413_124584 = state_124396__$1;
(statearr_124413_124584[(2)] = inst_124195);

(statearr_124413_124584[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (60))){
var inst_124201 = (state_124396[(2)]);
var inst_124202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124203 = [from];
var inst_124204 = (new cljs.core.PersistentVector(null,1,(5),inst_124202,inst_124203,null));
var inst_124205 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_124204,inst_124201);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(61),inst_124205);
} else {
if((state_val_124397 === (27))){
var inst_124148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124149 = [null,null];
var inst_124150 = (new cljs.core.PersistentVector(null,2,(5),inst_124148,inst_124149,null));
var state_124396__$1 = state_124396;
var statearr_124414_124585 = state_124396__$1;
(statearr_124414_124585[(2)] = inst_124150);

(statearr_124414_124585[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (1))){
var state_124396__$1 = state_124396;
var statearr_124415_124586 = state_124396__$1;
(statearr_124415_124586[(2)] = null);

(statearr_124415_124586[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (69))){
var inst_124227 = cljs.core.PersistentHashMap.EMPTY;
var state_124396__$1 = state_124396;
var statearr_124416_124587 = state_124396__$1;
(statearr_124416_124587[(2)] = inst_124227);

(statearr_124416_124587[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (101))){
var inst_124311 = (state_124396[(17)]);
var state_124396__$1 = state_124396;
var statearr_124417_124588 = state_124396__$1;
(statearr_124417_124588[(2)] = inst_124311);

(statearr_124417_124588[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (24))){
var inst_124111 = (state_124396[(18)]);
var state_124396__$1 = state_124396;
var statearr_124418_124589 = state_124396__$1;
(statearr_124418_124589[(2)] = inst_124111);

(statearr_124418_124589[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (102))){
var state_124396__$1 = state_124396;
if(cljs.core.truth_(fuel)){
var statearr_124419_124590 = state_124396__$1;
(statearr_124419_124590[(1)] = (104));

} else {
var statearr_124420_124591 = state_124396__$1;
(statearr_124420_124591[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (55))){
var inst_124187 = (state_124396[(19)]);
var inst_124189 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_124190 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_124187,inst_124189);
var state_124396__$1 = state_124396;
var statearr_124421_124592 = state_124396__$1;
(statearr_124421_124592[(2)] = inst_124190);

(statearr_124421_124592[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (85))){
var inst_124268 = (state_124396[(20)]);
var inst_124267 = (state_124396[(2)]);
var inst_124268__$1 = fluree.db.util.async.throw_err(inst_124267);
var inst_124269 = (inst_124268__$1 == null);
var state_124396__$1 = (function (){var statearr_124422 = state_124396;
(statearr_124422[(20)] = inst_124268__$1);

return statearr_124422;
})();
if(cljs.core.truth_(inst_124269)){
var statearr_124423_124593 = state_124396__$1;
(statearr_124423_124593[(1)] = (86));

} else {
var statearr_124424_124594 = state_124396__$1;
(statearr_124424_124594[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (39))){
var inst_124175 = typeof from === 'string';
var inst_124176 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_124177 = clojure.string.includes_QMARK_(inst_124176,"/");
var inst_124178 = ((inst_124175) && (inst_124177));
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124178)){
var statearr_124425_124595 = state_124396__$1;
(statearr_124425_124595[(1)] = (49));

} else {
var statearr_124426_124596 = state_124396__$1;
(statearr_124426_124596[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (88))){
var inst_124110 = (state_124396[(8)]);
var inst_124118 = (state_124396[(15)]);
var inst_124108 = (state_124396[(9)]);
var inst_124120 = (state_124396[(16)]);
var inst_124276 = (state_124396[(2)]);
var inst_124277 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_124120,fuel,max_fuel,inst_124118,inst_124276,inst_124108,inst_124110);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(89),inst_124277);
} else {
if((state_val_124397 === (46))){
var state_124396__$1 = state_124396;
var statearr_124427_124597 = state_124396__$1;
(statearr_124427_124597[(2)] = null);

(statearr_124427_124597[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_124396,(3),Error,null,(2));
var state_124396__$1 = state_124396;
if(cljs.core.truth_(select)){
var statearr_124428_124598 = state_124396__$1;
(statearr_124428_124598[(1)] = (5));

} else {
var statearr_124429_124599 = state_124396__$1;
(statearr_124429_124599[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (77))){
var inst_124246 = cljs.core.PersistentHashMap.EMPTY;
var state_124396__$1 = state_124396;
var statearr_124430_124600 = state_124396__$1;
(statearr_124430_124600[(2)] = inst_124246);

(statearr_124430_124600[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (106))){
var inst_124311 = (state_124396[(17)]);
var inst_124325 = (state_124396[(2)]);
var inst_124326 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_124311,false);
var state_124396__$1 = (function (){var statearr_124431 = state_124396;
(statearr_124431[(21)] = inst_124325);

return statearr_124431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(107),inst_124326);
} else {
if((state_val_124397 === (119))){
var inst_124374 = (state_124396[(22)]);
var state_124396__$1 = state_124396;
var statearr_124432_124601 = state_124396__$1;
(statearr_124432_124601[(2)] = inst_124374);

(statearr_124432_124601[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (95))){
var inst_124364 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124433_124602 = state_124396__$1;
(statearr_124433_124602[(2)] = inst_124364);

(statearr_124433_124602[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (54))){
var inst_124187 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124434 = state_124396;
(statearr_124434[(19)] = inst_124187);

return statearr_124434;
})();
var statearr_124435_124603 = state_124396__$1;
(statearr_124435_124603[(1)] = (55));



return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (92))){
var inst_124280 = (state_124396[(23)]);
var inst_124287 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124437 = state_124396;
(statearr_124437[(24)] = inst_124287);

return statearr_124437;
})();
var statearr_124438_124604 = state_124396__$1;
(statearr_124438_124604[(2)] = inst_124280);

(statearr_124438_124604[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (104))){
var inst_124320 = cljs.core._deref(fuel);
var inst_124321 = (inst_124320 + (1));
var inst_124322 = cljs.core._vreset_BANG_(fuel,inst_124321);
var state_124396__$1 = state_124396;
var statearr_124439_124605 = state_124396__$1;
(statearr_124439_124605[(2)] = inst_124322);

(statearr_124439_124605[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (15))){
var state_124396__$1 = state_124396;
var statearr_124440_124606 = state_124396__$1;
(statearr_124440_124606[(2)] = false);

(statearr_124440_124606[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (48))){
var inst_124110 = (state_124396[(8)]);
var inst_124118 = (state_124396[(15)]);
var inst_124165 = (state_124396[(25)]);
var inst_124120 = (state_124396[(16)]);
var inst_124169 = (state_124396[(2)]);
var inst_124170 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_124120,fuel,max_fuel,inst_124118,inst_124165,inst_124169,inst_124110);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(45),inst_124170);
} else {
if((state_val_124397 === (50))){
var inst_124216 = (state_124396[(26)]);
var inst_124216__$1 = typeof from === 'string';
var state_124396__$1 = (function (){var statearr_124441 = state_124396;
(statearr_124441[(26)] = inst_124216__$1);

return statearr_124441;
})();
if(cljs.core.truth_(inst_124216__$1)){
var statearr_124442_124607 = state_124396__$1;
(statearr_124442_124607[(1)] = (63));

} else {
var statearr_124443_124608 = state_124396__$1;
(statearr_124443_124608[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (116))){
var state_124396__$1 = state_124396;
var statearr_124444_124609 = state_124396__$1;
(statearr_124444_124609[(2)] = null);

(statearr_124444_124609[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (75))){
var inst_124262 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_124396__$1 = state_124396;
if(inst_124262){
var statearr_124445_124610 = state_124396__$1;
(statearr_124445_124610[(1)] = (82));

} else {
var statearr_124446_124611 = state_124396__$1;
(statearr_124446_124611[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (99))){
var inst_124311 = (state_124396[(17)]);
var inst_124316 = cljs.core.int_QMARK_(inst_124311);
var state_124396__$1 = state_124396;
if(inst_124316){
var statearr_124447_124612 = state_124396__$1;
(statearr_124447_124612[(1)] = (101));

} else {
var statearr_124448_124613 = state_124396__$1;
(statearr_124448_124613[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (21))){
var state_124396__$1 = state_124396;
var statearr_124449_124614 = state_124396__$1;
(statearr_124449_124614[(2)] = opts_SINGLEQUOTE__SINGLEQUOTE_);

(statearr_124449_124614[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (31))){
var inst_124146 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124450_124615 = state_124396__$1;
(statearr_124450_124615[(2)] = inst_124146);

(statearr_124450_124615[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (113))){
var inst_124108 = (state_124396[(9)]);
var state_124396__$1 = state_124396;
var statearr_124451_124616 = state_124396__$1;
(statearr_124451_124616[(2)] = inst_124108);

(statearr_124451_124616[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (32))){
var inst_124107 = (state_124396[(10)]);
var inst_124132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124133 = [inst_124107,"ASC"];
var inst_124134 = (new cljs.core.PersistentVector(null,2,(5),inst_124132,inst_124133,null));
var state_124396__$1 = state_124396;
var statearr_124452_124617 = state_124396__$1;
(statearr_124452_124617[(2)] = inst_124134);

(statearr_124452_124617[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (40))){
var inst_124153 = (state_124396[(27)]);
var inst_124374 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124453 = state_124396;
(statearr_124453[(22)] = inst_124374);

return statearr_124453;
})();
if(cljs.core.truth_(inst_124153)){
var statearr_124454_124618 = state_124396__$1;
(statearr_124454_124618[(1)] = (118));

} else {
var statearr_124455_124619 = state_124396__$1;
(statearr_124455_124619[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (91))){
var state_124396__$1 = state_124396;
var statearr_124456_124620 = state_124396__$1;
(statearr_124456_124620[(2)] = null);

(statearr_124456_124620[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (117))){
var inst_124362 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124457_124621 = state_124396__$1;
(statearr_124457_124621[(2)] = inst_124362);

(statearr_124457_124621[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (108))){
var inst_124305 = (state_124396[(12)]);
var inst_124331 = (state_124396[(28)]);
var inst_124333 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_124305,inst_124331);
var state_124396__$1 = state_124396;
var statearr_124458_124622 = state_124396__$1;
(statearr_124458_124622[(2)] = inst_124333);

(statearr_124458_124622[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (56))){
var inst_124187 = (state_124396[(19)]);
var state_124396__$1 = state_124396;
var statearr_124459_124623 = state_124396__$1;
(statearr_124459_124623[(2)] = inst_124187);

(statearr_124459_124623[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (33))){
var state_124396__$1 = state_124396;
var statearr_124460_124624 = state_124396__$1;
(statearr_124460_124624[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (13))){
var inst_124081 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124462_124625 = state_124396__$1;
(statearr_124462_124625[(2)] = inst_124081);

(statearr_124462_124625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (22))){
var inst_124085 = (state_124396[(14)]);
var inst_124109 = (state_124396[(29)]);
var inst_124106 = (state_124396[(2)]);
var inst_124107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124106,cljs.core.cst$kw$orderBy);
var inst_124108 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124106,cljs.core.cst$kw$limit);
var inst_124109__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124106,cljs.core.cst$kw$component);
var inst_124110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_124106,cljs.core.cst$kw$offset);
var inst_124111 = fluree.db.query.fql_parser.parse_db(db,inst_124085,opts_SINGLEQUOTE__SINGLEQUOTE_);
var inst_124112 = (inst_124109__$1 == null);
var inst_124113 = cljs.core.not(inst_124112);
var state_124396__$1 = (function (){var statearr_124463 = state_124396;
(statearr_124463[(8)] = inst_124110);

(statearr_124463[(10)] = inst_124107);

(statearr_124463[(18)] = inst_124111);

(statearr_124463[(29)] = inst_124109__$1);

(statearr_124463[(9)] = inst_124108);

return statearr_124463;
})();
if(inst_124113){
var statearr_124464_124626 = state_124396__$1;
(statearr_124464_124626[(1)] = (23));

} else {
var statearr_124465_124627 = state_124396__$1;
(statearr_124465_124627[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (90))){
var inst_124282 = cljs.core._deref(fuel);
var inst_124283 = (inst_124282 + (1));
var inst_124284 = cljs.core._vreset_BANG_(fuel,inst_124283);
var state_124396__$1 = state_124396;
var statearr_124466_124628 = state_124396__$1;
(statearr_124466_124628[(2)] = inst_124284);

(statearr_124466_124628[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (109))){
var inst_124305 = (state_124396[(12)]);
var state_124396__$1 = state_124396;
var statearr_124467_124629 = state_124396__$1;
(statearr_124467_124629[(2)] = inst_124305);

(statearr_124467_124629[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (36))){
var state_124396__$1 = state_124396;
var statearr_124468_124630 = state_124396__$1;
(statearr_124468_124630[(2)] = null);

(statearr_124468_124630[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (41))){
var state_124396__$1 = state_124396;
var statearr_124469_124631 = state_124396__$1;
(statearr_124469_124631[(2)] = from);

(statearr_124469_124631[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (118))){
var inst_124154 = (state_124396[(30)]);
var inst_124110 = (state_124396[(8)]);
var inst_124108 = (state_124396[(9)]);
var inst_124153 = (state_124396[(27)]);
var inst_124374 = (state_124396[(22)]);
var inst_124376 = fluree.db.query.fql.sort_offset_and_limit_res(inst_124153,inst_124154,inst_124110,inst_124108,inst_124374);
var state_124396__$1 = state_124396;
var statearr_124470_124632 = state_124396__$1;
(statearr_124470_124632[(2)] = inst_124376);

(statearr_124470_124632[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (89))){
var inst_124279 = (state_124396[(2)]);
var inst_124280 = fluree.db.util.async.throw_err(inst_124279);
var state_124396__$1 = (function (){var statearr_124471 = state_124396;
(statearr_124471[(23)] = inst_124280);

return statearr_124471;
})();
if(cljs.core.truth_(fuel)){
var statearr_124472_124633 = state_124396__$1;
(statearr_124472_124633[(1)] = (90));

} else {
var statearr_124473_124634 = state_124396__$1;
(statearr_124473_124634[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (100))){
var inst_124339 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124474_124635 = state_124396__$1;
(statearr_124474_124635[(2)] = inst_124339);

(statearr_124474_124635[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (122))){
var state_124396__$1 = state_124396;
var statearr_124475_124636 = state_124396__$1;
(statearr_124475_124636[(2)] = selectOne);

(statearr_124475_124636[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (43))){
var inst_124161 = (state_124396[(2)]);
var inst_124162 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_124161);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(44),inst_124162);
} else {
if((state_val_124397 === (61))){
var inst_124193 = (state_124396[(31)]);
var inst_124118 = (state_124396[(15)]);
var inst_124108 = (state_124396[(9)]);
var inst_124120 = (state_124396[(16)]);
var inst_124207 = (state_124396[(2)]);
var inst_124208 = fluree.db.util.async.throw_err(inst_124207);
var inst_124209 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_124193,inst_124208);
var inst_124210 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_124120,fuel,max_fuel,inst_124118,inst_124209,inst_124108);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(62),inst_124210);
} else {
if((state_val_124397 === (29))){
var inst_124107 = (state_124396[(10)]);
var inst_124124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124125 = cljs.core.second(inst_124107);
var inst_124126 = cljs.core.first(inst_124107);
var inst_124127 = [inst_124125,inst_124126];
var inst_124128 = (new cljs.core.PersistentVector(null,2,(5),inst_124124,inst_124127,null));
var state_124396__$1 = state_124396;
var statearr_124476_124637 = state_124396__$1;
(statearr_124476_124637[(2)] = inst_124128);

(statearr_124476_124637[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (44))){
var inst_124107 = (state_124396[(10)]);
var inst_124164 = (state_124396[(2)]);
var inst_124165 = fluree.db.util.async.throw_err(inst_124164);
var state_124396__$1 = (function (){var statearr_124477 = state_124396;
(statearr_124477[(25)] = inst_124165);

return statearr_124477;
})();
if(cljs.core.truth_(inst_124107)){
var statearr_124478_124638 = state_124396__$1;
(statearr_124478_124638[(1)] = (46));

} else {
var statearr_124479_124639 = state_124396__$1;
(statearr_124479_124639[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (93))){
var inst_124300 = cljs.core.seq(from);
var inst_124301 = cljs.core.first(inst_124300);
var inst_124302 = cljs.core.next(inst_124300);
var inst_124303 = cljs.core.PersistentVector.EMPTY;
var inst_124304 = from;
var inst_124305 = inst_124303;
var state_124396__$1 = (function (){var statearr_124480 = state_124396;
(statearr_124480[(12)] = inst_124305);

(statearr_124480[(32)] = inst_124301);

(statearr_124480[(13)] = inst_124304);

(statearr_124480[(33)] = inst_124302);

return statearr_124480;
})();
var statearr_124481_124640 = state_124396__$1;
(statearr_124481_124640[(2)] = null);

(statearr_124481_124640[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (6))){
var state_124396__$1 = state_124396;
if(cljs.core.truth_(selectOne)){
var statearr_124482_124641 = state_124396__$1;
(statearr_124482_124641[(1)] = (8));

} else {
var statearr_124483_124642 = state_124396__$1;
(statearr_124483_124642[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (111))){
var inst_124350 = (state_124396[(2)]);
var inst_124351 = fluree.db.util.async.throw_err(inst_124350);
var state_124396__$1 = state_124396;
var statearr_124484_124643 = state_124396__$1;
(statearr_124484_124643[(2)] = inst_124351);

(statearr_124484_124643[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (28))){
var inst_124152 = (state_124396[(2)]);
var inst_124153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_124152,(0),null);
var inst_124154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_124152,(1),null);
var inst_124155 = typeof where === 'string';
var state_124396__$1 = (function (){var statearr_124485 = state_124396;
(statearr_124485[(30)] = inst_124154);

(statearr_124485[(27)] = inst_124153);

return statearr_124485;
})();
if(cljs.core.truth_(inst_124155)){
var statearr_124486_124644 = state_124396__$1;
(statearr_124486_124644[(1)] = (38));

} else {
var statearr_124487_124645 = state_124396__$1;
(statearr_124487_124645[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (64))){
var inst_124216 = (state_124396[(26)]);
var state_124396__$1 = state_124396;
var statearr_124488_124646 = state_124396__$1;
(statearr_124488_124646[(2)] = inst_124216);

(statearr_124488_124646[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (103))){
var inst_124331 = (state_124396[(28)]);
var inst_124331__$1 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124489 = state_124396;
(statearr_124489[(28)] = inst_124331__$1);

return statearr_124489;
})();
if(cljs.core.truth_(inst_124331__$1)){
var statearr_124490_124647 = state_124396__$1;
(statearr_124490_124647[(1)] = (108));

} else {
var statearr_124491_124648 = state_124396__$1;
(statearr_124491_124648[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (51))){
var inst_124372 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124492_124649 = state_124396__$1;
(statearr_124492_124649[(2)] = inst_124372);

(statearr_124492_124649[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (25))){
var inst_124107 = (state_124396[(10)]);
var inst_124118 = (state_124396[(2)]);
var inst_124119 = cljs.core.PersistentHashMap.EMPTY;
var inst_124120 = cljs.core.volatile_BANG_(inst_124119);
var state_124396__$1 = (function (){var statearr_124493 = state_124396;
(statearr_124493[(15)] = inst_124118);

(statearr_124493[(16)] = inst_124120);

return statearr_124493;
})();
if(cljs.core.truth_(inst_124107)){
var statearr_124494_124650 = state_124396__$1;
(statearr_124494_124650[(1)] = (26));

} else {
var statearr_124495_124651 = state_124396__$1;
(statearr_124495_124651[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (34))){
var inst_124144 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124496_124652 = state_124396__$1;
(statearr_124496_124652[(2)] = inst_124144);

(statearr_124496_124652[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (125))){
var inst_124379 = (state_124396[(7)]);
var state_124396__$1 = state_124396;
var statearr_124497_124653 = state_124396__$1;
(statearr_124497_124653[(2)] = inst_124379);

(statearr_124497_124653[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (17))){
var state_124396__$1 = state_124396;
var statearr_124498_124654 = state_124396__$1;
(statearr_124498_124654[(2)] = true);

(statearr_124498_124654[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (3))){
var inst_124061 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124499_124655 = state_124396__$1;
(statearr_124499_124655[(2)] = inst_124061);


cljs.core.async.impl.ioc_helpers.process_exception(state_124396__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (12))){
var inst_124075 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_124076 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_124077 = cljs.core.PersistentHashMap.fromArrays(inst_124075,inst_124076);
var inst_124078 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_124077);
var inst_124079 = (function(){throw inst_124078})();
var state_124396__$1 = state_124396;
var statearr_124500_124656 = state_124396__$1;
(statearr_124500_124656[(2)] = inst_124079);

(statearr_124500_124656[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (2))){
var inst_124394 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_124396__$1,inst_124394);
} else {
if((state_val_124397 === (66))){
var inst_124107 = (state_124396[(10)]);
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124107)){
var statearr_124501_124657 = state_124396__$1;
(statearr_124501_124657[(1)] = (69));

} else {
var statearr_124502_124658 = state_124396__$1;
(statearr_124502_124658[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (107))){
var inst_124328 = (state_124396[(2)]);
var inst_124329 = fluree.db.util.async.throw_err(inst_124328);
var state_124396__$1 = state_124396;
var statearr_124503_124659 = state_124396__$1;
(statearr_124503_124659[(2)] = inst_124329);

(statearr_124503_124659[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (23))){
var inst_124111 = (state_124396[(18)]);
var inst_124109 = (state_124396[(29)]);
var inst_124115 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_124111,cljs.core.cst$kw$componentFollow_QMARK_,inst_124109);
var state_124396__$1 = state_124396;
var statearr_124504_124660 = state_124396__$1;
(statearr_124504_124660[(2)] = inst_124115);

(statearr_124504_124660[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (47))){
var inst_124108 = (state_124396[(9)]);
var state_124396__$1 = state_124396;
var statearr_124505_124661 = state_124396__$1;
(statearr_124505_124661[(2)] = inst_124108);

(statearr_124505_124661[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (35))){
var inst_124137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124138 = [null,null];
var inst_124139 = (new cljs.core.PersistentVector(null,2,(5),inst_124137,inst_124138,null));
var state_124396__$1 = state_124396;
var statearr_124506_124662 = state_124396__$1;
(statearr_124506_124662[(2)] = inst_124139);

(statearr_124506_124662[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (82))){
var inst_124265 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(85),inst_124265);
} else {
if((state_val_124397 === (76))){
var inst_124368 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124507_124663 = state_124396__$1;
(statearr_124507_124663[(2)] = inst_124368);

(statearr_124507_124663[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (97))){
var inst_124107 = (state_124396[(10)]);
var inst_124341 = (state_124396[(2)]);
var inst_124342 = cljs.core.PersistentVector.EMPTY;
var inst_124343 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_124342,inst_124341);
var state_124396__$1 = (function (){var statearr_124508 = state_124396;
(statearr_124508[(34)] = inst_124343);

return statearr_124508;
})();
if(cljs.core.truth_(inst_124107)){
var statearr_124509_124664 = state_124396__$1;
(statearr_124509_124664[(1)] = (112));

} else {
var statearr_124510_124665 = state_124396__$1;
(statearr_124510_124665[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (19))){
var inst_124098 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124511_124666 = state_124396__$1;
(statearr_124511_124666[(2)] = inst_124098);

(statearr_124511_124666[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (57))){
var inst_124107 = (state_124396[(10)]);
var inst_124193 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124512 = state_124396;
(statearr_124512[(31)] = inst_124193);

return statearr_124512;
})();
if(cljs.core.truth_(inst_124107)){
var statearr_124513_124667 = state_124396__$1;
(statearr_124513_124667[(1)] = (58));

} else {
var statearr_124514_124668 = state_124396__$1;
(statearr_124514_124668[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (68))){
var inst_124370 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124515_124669 = state_124396__$1;
(statearr_124515_124669[(2)] = inst_124370);

(statearr_124515_124669[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (11))){
var state_124396__$1 = state_124396;
var statearr_124516_124670 = state_124396__$1;
(statearr_124516_124670[(2)] = selectDistinct);

(statearr_124516_124670[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (115))){
var inst_124354 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_124355 = ["Invalid 'from' in query:",inst_124354].join('');
var inst_124356 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_124357 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_124358 = cljs.core.PersistentHashMap.fromArrays(inst_124356,inst_124357);
var inst_124359 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_124355,inst_124358);
var state_124396__$1 = state_124396;
var statearr_124517_124671 = state_124396__$1;
(statearr_124517_124671[(2)] = inst_124359);

(statearr_124517_124671[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (9))){
var state_124396__$1 = state_124396;
if(cljs.core.truth_(selectDistinct)){
var statearr_124518_124672 = state_124396__$1;
(statearr_124518_124672[(1)] = (11));

} else {
var statearr_124519_124673 = state_124396__$1;
(statearr_124519_124673[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (5))){
var state_124396__$1 = state_124396;
var statearr_124520_124674 = state_124396__$1;
(statearr_124520_124674[(2)] = select);

(statearr_124520_124674[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (112))){
var state_124396__$1 = state_124396;
var statearr_124521_124675 = state_124396__$1;
(statearr_124521_124675[(2)] = null);

(statearr_124521_124675[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (83))){
var inst_124289 = cljs.core.sequential_QMARK_(from);
var inst_124290 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_124291 = ((inst_124289) && (inst_124290));
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124291)){
var statearr_124522_124676 = state_124396__$1;
(statearr_124522_124676[(1)] = (93));

} else {
var statearr_124523_124677 = state_124396__$1;
(statearr_124523_124677[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (14))){
var inst_124090 = opts_SINGLEQUOTE__SINGLEQUOTE_.cljs$lang$protocol_mask$partition0$;
var inst_124091 = (inst_124090 & (64));
var inst_124092 = opts_SINGLEQUOTE__SINGLEQUOTE_.cljs$core$ISeq$;
var inst_124093 = (cljs.core.PROTOCOL_SENTINEL === inst_124092);
var inst_124094 = ((inst_124091) || (inst_124093));
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124094)){
var statearr_124524_124678 = state_124396__$1;
(statearr_124524_124678[(1)] = (17));

} else {
var statearr_124525_124679 = state_124396__$1;
(statearr_124525_124679[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (45))){
var inst_124172 = (state_124396[(2)]);
var inst_124173 = fluree.db.util.async.throw_err(inst_124172);
var state_124396__$1 = state_124396;
var statearr_124526_124680 = state_124396__$1;
(statearr_124526_124680[(2)] = inst_124173);

(statearr_124526_124680[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (53))){
var inst_124181 = (state_124396[(35)]);
var state_124396__$1 = state_124396;
var statearr_124527_124681 = state_124396__$1;
(statearr_124527_124681[(2)] = inst_124181);

(statearr_124527_124681[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (78))){
var inst_124110 = (state_124396[(8)]);
var inst_124108 = (state_124396[(9)]);
var inst_124248 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_124249 = [inst_124108,inst_124110];
var inst_124250 = cljs.core.PersistentHashMap.fromArrays(inst_124248,inst_124249);
var state_124396__$1 = state_124396;
var statearr_124528_124682 = state_124396__$1;
(statearr_124528_124682[(2)] = inst_124250);

(statearr_124528_124682[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (26))){
var inst_124107 = (state_124396[(10)]);
var inst_124122 = cljs.core.vector_QMARK_(inst_124107);
var state_124396__$1 = state_124396;
if(inst_124122){
var statearr_124529_124683 = state_124396__$1;
(statearr_124529_124683[(1)] = (29));

} else {
var statearr_124530_124684 = state_124396__$1;
(statearr_124530_124684[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (123))){
var inst_124387 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124387)){
var statearr_124531_124685 = state_124396__$1;
(statearr_124531_124685[(1)] = (124));

} else {
var statearr_124532_124686 = state_124396__$1;
(statearr_124532_124686[(1)] = (125));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (16))){
var inst_124101 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124101)){
var statearr_124533_124687 = state_124396__$1;
(statearr_124533_124687[(1)] = (20));

} else {
var statearr_124534_124688 = state_124396__$1;
(statearr_124534_124688[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (81))){
var inst_124259 = (state_124396[(2)]);
var inst_124260 = fluree.db.util.async.throw_err(inst_124259);
var state_124396__$1 = state_124396;
var statearr_124535_124689 = state_124396__$1;
(statearr_124535_124689[(2)] = inst_124260);

(statearr_124535_124689[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (120))){
var inst_124379 = (state_124396[(2)]);
var state_124396__$1 = (function (){var statearr_124536 = state_124396;
(statearr_124536[(7)] = inst_124379);

return statearr_124536;
})();
if(cljs.core.truth_(selectOne)){
var statearr_124537_124690 = state_124396__$1;
(statearr_124537_124690[(1)] = (121));

} else {
var statearr_124538_124691 = state_124396__$1;
(statearr_124538_124691[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (79))){
var inst_124252 = (state_124396[(2)]);
var inst_124253 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_124252);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(80),inst_124253);
} else {
if((state_val_124397 === (38))){
var inst_124157 = typeof from === 'string';
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124157)){
var statearr_124539_124692 = state_124396__$1;
(statearr_124539_124692[(1)] = (41));

} else {
var statearr_124540_124693 = state_124396__$1;
(statearr_124540_124693[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (126))){
var inst_124392 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124541_124694 = state_124396__$1;
(statearr_124541_124694[(2)] = inst_124392);


cljs.core.async.impl.ioc_helpers.process_exception(state_124396__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (98))){
var inst_124305 = (state_124396[(12)]);
var state_124396__$1 = state_124396;
var statearr_124542_124695 = state_124396__$1;
(statearr_124542_124695[(2)] = inst_124305);

(statearr_124542_124695[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (124))){
var inst_124379 = (state_124396[(7)]);
var inst_124389 = cljs.core.first(inst_124379);
var state_124396__$1 = state_124396;
var statearr_124543_124696 = state_124396__$1;
(statearr_124543_124696[(2)] = inst_124389);

(statearr_124543_124696[(1)] = (126));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (87))){
var inst_124268 = (state_124396[(20)]);
var inst_124272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_124273 = [inst_124268];
var inst_124274 = (new cljs.core.PersistentVector(null,1,(5),inst_124272,inst_124273,null));
var state_124396__$1 = state_124396;
var statearr_124544_124697 = state_124396__$1;
(statearr_124544_124697[(2)] = inst_124274);

(statearr_124544_124697[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (30))){
var inst_124107 = (state_124396[(10)]);
var inst_124130 = typeof inst_124107 === 'string';
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124130)){
var statearr_124545_124698 = state_124396__$1;
(statearr_124545_124698[(1)] = (32));

} else {
var statearr_124546_124699 = state_124396__$1;
(statearr_124546_124699[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (73))){
var inst_124240 = (state_124396[(2)]);
var inst_124241 = fluree.db.util.async.throw_err(inst_124240);
var state_124396__$1 = state_124396;
var statearr_124547_124700 = state_124396__$1;
(statearr_124547_124700[(2)] = inst_124241);

(statearr_124547_124700[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (96))){
var inst_124304 = (state_124396[(13)]);
var inst_124311 = (state_124396[(17)]);
var inst_124310 = cljs.core.seq(inst_124304);
var inst_124311__$1 = cljs.core.first(inst_124310);
var inst_124312 = cljs.core.next(inst_124310);
var inst_124313 = cljs.core.not(inst_124311__$1);
var state_124396__$1 = (function (){var statearr_124548 = state_124396;
(statearr_124548[(11)] = inst_124312);

(statearr_124548[(17)] = inst_124311__$1);

return statearr_124548;
})();
if(inst_124313){
var statearr_124549_124701 = state_124396__$1;
(statearr_124549_124701[(1)] = (98));

} else {
var statearr_124550_124702 = state_124396__$1;
(statearr_124550_124702[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (10))){
var inst_124083 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124551_124703 = state_124396__$1;
(statearr_124551_124703[(2)] = inst_124083);

(statearr_124551_124703[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (18))){
var state_124396__$1 = state_124396;
var statearr_124552_124704 = state_124396__$1;
(statearr_124552_124704[(2)] = false);

(statearr_124552_124704[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (105))){
var state_124396__$1 = state_124396;
var statearr_124553_124705 = state_124396__$1;
(statearr_124553_124705[(2)] = null);

(statearr_124553_124705[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (52))){
var inst_124181 = (state_124396[(35)]);
var inst_124183 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_124184 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_124181,inst_124183);
var state_124396__$1 = state_124396;
var statearr_124554_124706 = state_124396__$1;
(statearr_124554_124706[(2)] = inst_124184);

(statearr_124554_124706[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (114))){
var inst_124343 = (state_124396[(34)]);
var inst_124110 = (state_124396[(8)]);
var inst_124118 = (state_124396[(15)]);
var inst_124120 = (state_124396[(16)]);
var inst_124347 = (state_124396[(2)]);
var inst_124348 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_124120,fuel,max_fuel,inst_124118,inst_124343,inst_124347,inst_124110);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(111),inst_124348);
} else {
if((state_val_124397 === (67))){
var inst_124243 = typeof from === 'string';
var state_124396__$1 = state_124396;
if(cljs.core.truth_(inst_124243)){
var statearr_124555_124707 = state_124396__$1;
(statearr_124555_124707[(1)] = (74));

} else {
var statearr_124556_124708 = state_124396__$1;
(statearr_124556_124708[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (71))){
var inst_124233 = (state_124396[(2)]);
var inst_124234 = fluree.db.query.range._block_or_tx_collection(db,inst_124233);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(72),inst_124234);
} else {
if((state_val_124397 === (42))){
var state_124396__$1 = state_124396;
var statearr_124557_124709 = state_124396__$1;
(statearr_124557_124709[(2)] = null);

(statearr_124557_124709[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (80))){
var inst_124118 = (state_124396[(15)]);
var inst_124120 = (state_124396[(16)]);
var inst_124255 = (state_124396[(2)]);
var inst_124256 = fluree.db.util.async.throw_err(inst_124255);
var inst_124257 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_124120,fuel,max_fuel,inst_124118,inst_124256);
var state_124396__$1 = state_124396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_124396__$1,(81),inst_124257);
} else {
if((state_val_124397 === (37))){
var inst_124142 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124558_124710 = state_124396__$1;
(statearr_124558_124710[(2)] = inst_124142);

(statearr_124558_124710[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (63))){
var inst_124218 = ["_tx",null,"_block",null];
var inst_124219 = (new cljs.core.PersistentArrayMap(null,2,inst_124218,null));
var inst_124220 = (new cljs.core.PersistentHashSet(null,inst_124219,null));
var inst_124221 = (inst_124220.cljs$core$IFn$_invoke$arity$1 ? inst_124220.cljs$core$IFn$_invoke$arity$1(from) : inst_124220.call(null,from));
var state_124396__$1 = state_124396;
var statearr_124559_124711 = state_124396__$1;
(statearr_124559_124711[(2)] = inst_124221);

(statearr_124559_124711[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (94))){
var state_124396__$1 = state_124396;
var statearr_124560_124712 = state_124396__$1;
(statearr_124560_124712[(1)] = (115));



return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (8))){
var state_124396__$1 = state_124396;
var statearr_124562_124713 = state_124396__$1;
(statearr_124562_124713[(2)] = selectOne);

(statearr_124562_124713[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (49))){
var inst_124181 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_124396__$1 = (function (){var statearr_124563 = state_124396;
(statearr_124563[(35)] = inst_124181);

return statearr_124563;
})();
if(cljs.core.truth_(fuel)){
var statearr_124564_124714 = state_124396__$1;
(statearr_124564_124714[(1)] = (52));

} else {
var statearr_124565_124715 = state_124396__$1;
(statearr_124565_124715[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_124397 === (84))){
var inst_124366 = (state_124396[(2)]);
var state_124396__$1 = state_124396;
var statearr_124566_124716 = state_124396__$1;
(statearr_124566_124716[(2)] = inst_124366);

(statearr_124566_124716[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
;
return ((function (switch__109970__auto__,c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_){
return (function() {
var fluree$db$query$fql$query_$_state_machine__109971__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__109971__auto____0 = (function (){
var statearr_124567 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_124567[(0)] = fluree$db$query$fql$query_$_state_machine__109971__auto__);

(statearr_124567[(1)] = (1));

return statearr_124567;
});
var fluree$db$query$fql$query_$_state_machine__109971__auto____1 = (function (state_124396){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_124396);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e124568){if((e124568 instanceof Object)){
var ex__109974__auto__ = e124568;
var statearr_124569_124717 = state_124396;
(statearr_124569_124717[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_124396);

return cljs.core.cst$kw$recur;
} else {
throw e124568;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__124718 = state_124396;
state_124396 = G__124718;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__109971__auto__ = function(state_124396){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__109971__auto____1.call(this,state_124396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__109971__auto____0;
fluree$db$query$fql$query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__109971__auto____1;
return fluree$db$query$fql$query_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
})();
var state__110079__auto__ = (function (){var statearr_124570 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_124570[(6)] = c__110077__auto__);

return statearr_124570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,max_fuel,fuel,map__124042,map__124042__$1,select,orderBy,where,limit,offset,component,selectDistinct,prettyPrint,selectOne,from,opts,groupBy,opts_SINGLEQUOTE_,opts_SINGLEQUOTE__SINGLEQUOTE_))
);

return c__110077__auto__;
}

});
