// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4131__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__112665 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112665,(5),null);
var G__112668 = idx;
var G__112668__$1 = (((G__112668 instanceof cljs.core.Keyword))?G__112668.fqn:null);
switch (G__112668__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__112668__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__112670 = idx;
var G__112670__$1 = (((G__112670 instanceof cljs.core.Keyword))?G__112670.fqn:null);
switch (G__112670__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__112670__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__112672 = idx;
var G__112672__$1 = (((G__112672 instanceof cljs.core.Keyword))?G__112672.fqn:null);
switch (G__112672__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__112672__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__112675 = arguments.length;
switch (G__112675) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__112676 = (function (){var pred__112679 = cljs.core.identical_QMARK_;
var expr__112680 = test;
if(cljs.core.truth_((pred__112679.cljs$core$IFn$_invoke$arity$2 ? pred__112679.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__112680) : pred__112679.call(null,cljs.core._EQ_,expr__112680)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__112679.cljs$core$IFn$_invoke$arity$2 ? pred__112679.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__112680) : pred__112679.call(null,cljs.core._LT_,expr__112680)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__112679.cljs$core$IFn$_invoke$arity$2 ? pred__112679.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__112680) : pred__112679.call(null,cljs.core._LT__EQ_,expr__112680)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__112679.cljs$core$IFn$_invoke$arity$2 ? pred__112679.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__112680) : pred__112679.call(null,cljs.core._GT_,expr__112680)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__112679.cljs$core$IFn$_invoke$arity$2 ? pred__112679.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__112680) : pred__112679.call(null,cljs.core._GT__EQ_,expr__112680)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__112680)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112676,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112676,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112676,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__112676,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_112890){
var state_val_112891 = (state_112890[(1)]);
if((state_val_112891 === (65))){
var inst_112851 = (state_112890[(7)]);
var inst_112844 = (state_112890[(8)]);
var inst_112843 = (state_112890[(9)]);
var inst_112858 = (inst_112843 + (1));
var tmp112892 = inst_112844;
var inst_112842 = inst_112851;
var inst_112843__$1 = inst_112858;
var inst_112844__$1 = tmp112892;
var state_112890__$1 = (function (){var statearr_112893 = state_112890;
(statearr_112893[(8)] = inst_112844__$1);

(statearr_112893[(10)] = inst_112842);

(statearr_112893[(9)] = inst_112843__$1);

return statearr_112893;
})();
var statearr_112894_113001 = state_112890__$1;
(statearr_112894_113001[(2)] = null);

(statearr_112894_113001[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (70))){
var inst_112865 = (state_112890[(11)]);
var state_112890__$1 = state_112890;
var statearr_112895_113002 = state_112890__$1;
(statearr_112895_113002[(2)] = inst_112865);

(statearr_112895_113002[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (62))){
var inst_112784 = (state_112890[(12)]);
var inst_112842 = (state_112890[(10)]);
var inst_112843 = (state_112890[(9)]);
var inst_112849 = cljs.core.seq(inst_112842);
var inst_112850 = cljs.core.first(inst_112849);
var inst_112851 = cljs.core.next(inst_112849);
var inst_112852 = (inst_112850 == null);
var inst_112853 = (inst_112843 > inst_112784);
var inst_112854 = ((inst_112852) || (inst_112853));
var state_112890__$1 = (function (){var statearr_112896 = state_112890;
(statearr_112896[(7)] = inst_112851);

return statearr_112896;
})();
if(cljs.core.truth_(inst_112854)){
var statearr_112897_113003 = state_112890__$1;
(statearr_112897_113003[(1)] = (64));

} else {
var statearr_112898_113004 = state_112890__$1;
(statearr_112898_113004[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (7))){
var inst_112700 = (state_112890[(13)]);
var inst_112714 = (state_112890[(2)]);
var inst_112715 = fluree.db.util.core.pred_ident_QMARK_(inst_112700);
var state_112890__$1 = (function (){var statearr_112899 = state_112890;
(statearr_112899[(14)] = inst_112714);

return statearr_112899;
})();
if(inst_112715){
var statearr_112900_113005 = state_112890__$1;
(statearr_112900_113005[(1)] = (9));

} else {
var statearr_112901_113006 = state_112890__$1;
(statearr_112901_113006[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (59))){
var inst_112784 = (state_112890[(12)]);
var inst_112812 = (state_112890[(15)]);
var inst_112811 = (state_112890[(16)]);
var inst_112825 = (state_112890[(17)]);
var inst_112828 = (inst_112784 - inst_112811);
var inst_112829 = fluree.db.flake.take(inst_112828,inst_112825);
var inst_112830 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_112829,inst_112812);
var state_112890__$1 = state_112890;
var statearr_112902_113007 = state_112890__$1;
(statearr_112902_113007[(2)] = inst_112830);

(statearr_112902_113007[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (20))){
var inst_112737 = (state_112890[(2)]);
var inst_112738 = fluree.db.util.async.throw_err(inst_112737);
var state_112890__$1 = state_112890;
var statearr_112903_113008 = state_112890__$1;
(statearr_112903_113008[(2)] = inst_112738);

(statearr_112903_113008[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (72))){
var inst_112884 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112904_113009 = state_112890__$1;
(statearr_112904_113009[(2)] = inst_112884);

(statearr_112904_113009[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (58))){
var inst_112810 = (state_112890[(18)]);
var inst_112825 = (state_112890[(2)]);
var inst_112826 = fluree.db.dbproto._rhs(inst_112810);
var state_112890__$1 = (function (){var statearr_112905 = state_112890;
(statearr_112905[(19)] = inst_112826);

(statearr_112905[(17)] = inst_112825);

return statearr_112905;
})();
var statearr_112906_113010 = state_112890__$1;
(statearr_112906_113010[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (60))){
var inst_112811 = (state_112890[(16)]);
var inst_112825 = (state_112890[(17)]);
var inst_112839 = cljs.core.seq(inst_112825);
var inst_112840 = cljs.core.first(inst_112839);
var inst_112841 = cljs.core.next(inst_112839);
var inst_112842 = inst_112825;
var inst_112843 = inst_112811;
var inst_112844 = inst_112825;
var state_112890__$1 = (function (){var statearr_112908 = state_112890;
(statearr_112908[(20)] = inst_112841);

(statearr_112908[(8)] = inst_112844);

(statearr_112908[(21)] = inst_112840);

(statearr_112908[(10)] = inst_112842);

(statearr_112908[(9)] = inst_112843);

return statearr_112908;
})();
var statearr_112909_113011 = state_112890__$1;
(statearr_112909_113011[(2)] = null);

(statearr_112909_113011[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (27))){
var inst_112741 = (state_112890[(22)]);
var state_112890__$1 = state_112890;
var statearr_112910_113012 = state_112890__$1;
(statearr_112910_113012[(2)] = inst_112741);

(statearr_112910_113012[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (1))){
var state_112890__$1 = state_112890;
var statearr_112911_113013 = state_112890__$1;
(statearr_112911_113013[(2)] = null);

(statearr_112911_113013[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (69))){
var inst_112874 = (state_112890[(2)]);
var inst_112875 = cljs.core.not(inst_112874);
var state_112890__$1 = state_112890;
if(inst_112875){
var statearr_112912_113014 = state_112890__$1;
(statearr_112912_113014[(1)] = (70));

} else {
var statearr_112913_113015 = state_112890__$1;
(statearr_112913_113015[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (24))){
var state_112890__$1 = state_112890;
var statearr_112914_113016 = state_112890__$1;
(statearr_112914_113016[(2)] = (-1));

(statearr_112914_113016[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (55))){
var inst_112817 = (state_112890[(23)]);
var inst_112779 = (state_112890[(24)]);
var inst_112778 = (state_112890[(25)]);
var inst_112816 = (state_112890[(2)]);
var inst_112817__$1 = fluree.db.util.async.throw_err(inst_112816);
var inst_112818 = fluree.db.flake.subrange(inst_112817__$1,start_test,inst_112778,end_test,inst_112779);
var inst_112819 = fluree.db.query.range.value_with_nil_pred(idx,inst_112778,inst_112779);
var state_112890__$1 = (function (){var statearr_112915 = state_112890;
(statearr_112915[(26)] = inst_112818);

(statearr_112915[(23)] = inst_112817__$1);

return statearr_112915;
})();
if(inst_112819){
var statearr_112916_113017 = state_112890__$1;
(statearr_112916_113017[(1)] = (56));

} else {
var statearr_112917_113018 = state_112890__$1;
(statearr_112917_113018[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (39))){
var inst_112705 = (state_112890[(27)]);
var state_112890__$1 = state_112890;
var statearr_112918_113019 = state_112890__$1;
(statearr_112918_113019[(2)] = inst_112705);

(statearr_112918_113019[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (46))){
var state_112890__$1 = state_112890;
var statearr_112919_113020 = state_112890__$1;
(statearr_112919_113020[(2)] = fluree.db.util.core.max_long);

(statearr_112919_113020[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (4))){
var inst_112692 = (state_112890[(28)]);
var inst_112699 = (state_112890[(29)]);
var inst_112693 = (state_112890[(30)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_112890,(3),Error,null,(2));
var inst_112692__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_112693__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(0),null);
var inst_112694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(1),null);
var inst_112695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(2),null);
var inst_112696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(3),null);
var inst_112697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(4),null);
var inst_112698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112692__$1,(5),null);
var inst_112699__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_112700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(0),null);
var inst_112701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(1),null);
var inst_112702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(2),null);
var inst_112703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(3),null);
var inst_112704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(4),null);
var inst_112705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_112699__$1,(5),null);
var inst_112706 = fluree.db.util.core.pred_ident_QMARK_(inst_112693__$1);
var state_112890__$1 = (function (){var statearr_112920 = state_112890;
(statearr_112920[(28)] = inst_112692__$1);

(statearr_112920[(31)] = inst_112703);

(statearr_112920[(32)] = inst_112704);

(statearr_112920[(13)] = inst_112700);

(statearr_112920[(27)] = inst_112705);

(statearr_112920[(33)] = inst_112701);

(statearr_112920[(34)] = inst_112698);

(statearr_112920[(29)] = inst_112699__$1);

(statearr_112920[(30)] = inst_112693__$1);

(statearr_112920[(35)] = inst_112697);

(statearr_112920[(36)] = inst_112694);

(statearr_112920[(37)] = inst_112695);

(statearr_112920[(38)] = inst_112702);

(statearr_112920[(39)] = inst_112696);

return statearr_112920;
})();
if(inst_112706){
var statearr_112921_113021 = state_112890__$1;
(statearr_112921_113021[(1)] = (5));

} else {
var statearr_112922_113022 = state_112890__$1;
(statearr_112922_113022[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (54))){
var inst_112886 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112923_113023 = state_112890__$1;
(statearr_112923_113023[(2)] = inst_112886);


cljs.core.async.impl.ioc_helpers.process_exception(state_112890__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (15))){
var inst_112702 = (state_112890[(38)]);
var inst_112732 = (state_112890[(2)]);
var inst_112733 = fluree.db.util.core.pred_ident_QMARK_(inst_112702);
var state_112890__$1 = (function (){var statearr_112924 = state_112890;
(statearr_112924[(40)] = inst_112732);

return statearr_112924;
})();
if(inst_112733){
var statearr_112925_113024 = state_112890__$1;
(statearr_112925_113024[(1)] = (17));

} else {
var statearr_112926_113025 = state_112890__$1;
(statearr_112926_113025[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (48))){
var inst_112790 = (state_112890[(41)]);
var state_112890__$1 = state_112890;
var statearr_112927_113026 = state_112890__$1;
(statearr_112927_113026[(2)] = inst_112790);

(statearr_112927_113026[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (50))){
var inst_112795 = (state_112890[(2)]);
var inst_112796 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_112797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112798 = [cljs.core.cst$kw$novelty,idx];
var inst_112799 = (new cljs.core.PersistentVector(null,2,(5),inst_112797,inst_112798,null));
var inst_112800 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_112799);
var inst_112801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_112802 = fluree.db.dbproto._resolve(inst_112801);
var state_112890__$1 = (function (){var statearr_112928 = state_112890;
(statearr_112928[(42)] = inst_112800);

(statearr_112928[(43)] = inst_112795);

(statearr_112928[(44)] = inst_112796);

return statearr_112928;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(51),inst_112802);
} else {
if((state_val_112891 === (21))){
var inst_112732 = (state_112890[(40)]);
var state_112890__$1 = state_112890;
var statearr_112929_113027 = state_112890__$1;
(statearr_112929_113027[(2)] = inst_112732);

(statearr_112929_113027[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (31))){
var inst_112701 = (state_112890[(33)]);
var state_112890__$1 = state_112890;
var statearr_112930_113028 = state_112890__$1;
(statearr_112930_113028[(2)] = inst_112701);

(statearr_112930_113028[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (32))){
var inst_112698 = (state_112890[(34)]);
var inst_112759 = (state_112890[(2)]);
var state_112890__$1 = (function (){var statearr_112931 = state_112890;
(statearr_112931[(45)] = inst_112759);

return statearr_112931;
})();
if(cljs.core.truth_(inst_112698)){
var statearr_112932_113029 = state_112890__$1;
(statearr_112932_113029[(1)] = (33));

} else {
var statearr_112933_113030 = state_112890__$1;
(statearr_112933_113030[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (40))){
var inst_112771 = (cljs.core._LT__EQ_ === end_test);
var state_112890__$1 = state_112890;
if(cljs.core.truth_(inst_112771)){
var statearr_112934_113031 = state_112890__$1;
(statearr_112934_113031[(1)] = (42));

} else {
var statearr_112935_113032 = state_112890__$1;
(statearr_112935_113032[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (56))){
var inst_112789 = (state_112890[(46)]);
var inst_112692 = (state_112890[(28)]);
var inst_112805 = (state_112890[(47)]);
var inst_112723 = (state_112890[(48)]);
var inst_112784 = (state_112890[(12)]);
var inst_112732 = (state_112890[(40)]);
var inst_112812 = (state_112890[(15)]);
var inst_112759 = (state_112890[(45)]);
var inst_112800 = (state_112890[(42)]);
var inst_112818 = (state_112890[(26)]);
var inst_112703 = (state_112890[(31)]);
var inst_112750 = (state_112890[(49)]);
var inst_112704 = (state_112890[(32)]);
var inst_112777 = (state_112890[(50)]);
var inst_112811 = (state_112890[(16)]);
var inst_112785 = (state_112890[(51)]);
var inst_112768 = (state_112890[(52)]);
var inst_112810 = (state_112890[(18)]);
var inst_112817 = (state_112890[(23)]);
var inst_112714 = (state_112890[(14)]);
var inst_112795 = (state_112890[(43)]);
var inst_112699 = (state_112890[(29)]);
var inst_112779 = (state_112890[(24)]);
var inst_112778 = (state_112890[(25)]);
var inst_112741 = (state_112890[(22)]);
var inst_112697 = (state_112890[(35)]);
var inst_112696 = (state_112890[(39)]);
var inst_112796 = (state_112890[(44)]);
var inst_112821 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_112810;
var flakes = inst_112817;
var s1 = inst_112714;
var o2 = inst_112741;
var t1 = inst_112696;
var i = inst_112811;
var m1 = inst_112768;
var root_node = inst_112805;
var to_t = inst_112796;
var s2 = inst_112723;
var p2 = inst_112759;
var permissions = inst_112785;
var limit = inst_112784;
var vec__112686 = inst_112692;
var start_flake = inst_112778;
var acc = inst_112812;
var t2 = inst_112703;
var op1 = inst_112697;
var o1 = inst_112732;
var end_flake = inst_112779;
var base_result = inst_112818;
var p1 = inst_112750;
var vec__112689 = inst_112699;
var idx_compare = inst_112789;
var op2 = inst_112704;
var from_t = inst_112795;
var m2 = inst_112777;
var novelty = inst_112800;
return ((function (no_filter_QMARK_,next_node,flakes,s1,o2,t1,i,m1,root_node,to_t,s2,p2,permissions,limit,vec__112686,start_flake,acc,t2,op1,o1,end_flake,base_result,p1,vec__112689,idx_compare,op2,from_t,m2,novelty,inst_112789,inst_112692,inst_112805,inst_112723,inst_112784,inst_112732,inst_112812,inst_112759,inst_112800,inst_112818,inst_112703,inst_112750,inst_112704,inst_112777,inst_112811,inst_112785,inst_112768,inst_112810,inst_112817,inst_112714,inst_112795,inst_112699,inst_112779,inst_112778,inst_112741,inst_112697,inst_112696,inst_112796,state_val_112891,c__110077__auto__){
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
;})(no_filter_QMARK_,next_node,flakes,s1,o2,t1,i,m1,root_node,to_t,s2,p2,permissions,limit,vec__112686,start_flake,acc,t2,op1,o1,end_flake,base_result,p1,vec__112689,idx_compare,op2,from_t,m2,novelty,inst_112789,inst_112692,inst_112805,inst_112723,inst_112784,inst_112732,inst_112812,inst_112759,inst_112800,inst_112818,inst_112703,inst_112750,inst_112704,inst_112777,inst_112811,inst_112785,inst_112768,inst_112810,inst_112817,inst_112714,inst_112795,inst_112699,inst_112779,inst_112778,inst_112741,inst_112697,inst_112696,inst_112796,state_val_112891,c__110077__auto__))
})();
var inst_112822 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_112821,inst_112818,inst_112818);
var state_112890__$1 = state_112890;
var statearr_112936_113033 = state_112890__$1;
(statearr_112936_113033[(2)] = inst_112822);

(statearr_112936_113033[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (33))){
var inst_112698 = (state_112890[(34)]);
var state_112890__$1 = state_112890;
var statearr_112937_113034 = state_112890__$1;
(statearr_112937_113034[(2)] = inst_112698);

(statearr_112937_113034[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (13))){
var inst_112695 = (state_112890[(37)]);
var inst_112726 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_112695);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(16),inst_112726);
} else {
if((state_val_112891 === (22))){
var inst_112742 = (state_112890[(53)]);
var state_112890__$1 = state_112890;
var statearr_112938_113035 = state_112890__$1;
(statearr_112938_113035[(2)] = inst_112742);

(statearr_112938_113035[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (36))){
var state_112890__$1 = state_112890;
var statearr_112939_113036 = state_112890__$1;
(statearr_112939_113036[(2)] = fluree.db.util.core.min_integer);

(statearr_112939_113036[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (41))){
var inst_112780 = (state_112890[(54)]);
var inst_112723 = (state_112890[(48)]);
var inst_112732 = (state_112890[(40)]);
var inst_112759 = (state_112890[(45)]);
var inst_112703 = (state_112890[(31)]);
var inst_112750 = (state_112890[(49)]);
var inst_112704 = (state_112890[(32)]);
var inst_112777 = (state_112890[(50)]);
var inst_112768 = (state_112890[(52)]);
var inst_112714 = (state_112890[(14)]);
var inst_112741 = (state_112890[(22)]);
var inst_112697 = (state_112890[(35)]);
var inst_112696 = (state_112890[(39)]);
var inst_112777__$1 = (state_112890[(2)]);
var inst_112778 = fluree.db.flake.__GT_Flake(inst_112714,inst_112750,inst_112732,inst_112696,inst_112697,inst_112768);
var inst_112779 = fluree.db.flake.__GT_Flake(inst_112723,inst_112759,inst_112741,inst_112703,inst_112704,inst_112777__$1);
var inst_112780__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_112890__$1 = (function (){var statearr_112940 = state_112890;
(statearr_112940[(54)] = inst_112780__$1);

(statearr_112940[(50)] = inst_112777__$1);

(statearr_112940[(24)] = inst_112779);

(statearr_112940[(25)] = inst_112778);

return statearr_112940;
})();
if(cljs.core.truth_(inst_112780__$1)){
var statearr_112941_113037 = state_112890__$1;
(statearr_112941_113037[(1)] = (45));

} else {
var statearr_112942_113038 = state_112890__$1;
(statearr_112942_113038[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (43))){
var state_112890__$1 = state_112890;
var statearr_112943_113039 = state_112890__$1;
(statearr_112943_113039[(2)] = fluree.db.util.core.min_integer);

(statearr_112943_113039[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (61))){
var inst_112865 = (state_112890[(11)]);
var inst_112826 = (state_112890[(19)]);
var inst_112865__$1 = (state_112890[(2)]);
var inst_112866 = cljs.core.count(inst_112865__$1);
var state_112890__$1 = (function (){var statearr_112944 = state_112890;
(statearr_112944[(11)] = inst_112865__$1);

(statearr_112944[(55)] = inst_112866);

return statearr_112944;
})();
if(cljs.core.truth_(inst_112826)){
var statearr_112945_113040 = state_112890__$1;
(statearr_112945_113040[(1)] = (67));

} else {
var statearr_112946_113041 = state_112890__$1;
(statearr_112946_113041[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (29))){
var inst_112755 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
if(cljs.core.truth_(inst_112755)){
var statearr_112947_113042 = state_112890__$1;
(statearr_112947_113042[(1)] = (30));

} else {
var statearr_112948_113043 = state_112890__$1;
(statearr_112948_113043[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (44))){
var inst_112775 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112949_113044 = state_112890__$1;
(statearr_112949_113044[(2)] = inst_112775);

(statearr_112949_113044[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (6))){
var inst_112693 = (state_112890[(30)]);
var state_112890__$1 = state_112890;
var statearr_112950_113045 = state_112890__$1;
(statearr_112950_113045[(2)] = inst_112693);

(statearr_112950_113045[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (28))){
var inst_112751 = (state_112890[(56)]);
var state_112890__$1 = state_112890;
var statearr_112951_113046 = state_112890__$1;
(statearr_112951_113046[(2)] = inst_112751);

(statearr_112951_113046[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (64))){
var inst_112812 = (state_112890[(15)]);
var inst_112844 = (state_112890[(8)]);
var inst_112856 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_112844,inst_112812);
var state_112890__$1 = state_112890;
var statearr_112952_113047 = state_112890__$1;
(statearr_112952_113047[(2)] = inst_112856);

(statearr_112952_113047[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (51))){
var inst_112805 = (state_112890[(47)]);
var inst_112778 = (state_112890[(25)]);
var inst_112804 = (state_112890[(2)]);
var inst_112805__$1 = fluree.db.util.async.throw_err(inst_112804);
var inst_112806 = fluree.db.dbproto._lookup_leaf(inst_112805__$1,inst_112778);
var state_112890__$1 = (function (){var statearr_112953 = state_112890;
(statearr_112953[(47)] = inst_112805__$1);

return statearr_112953;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(52),inst_112806);
} else {
if((state_val_112891 === (25))){
var inst_112694 = (state_112890[(36)]);
var state_112890__$1 = state_112890;
var statearr_112954_113048 = state_112890__$1;
(statearr_112954_113048[(2)] = inst_112694);

(statearr_112954_113048[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (34))){
var inst_112762 = (cljs.core._GT__EQ_ === start_test);
var state_112890__$1 = state_112890;
if(cljs.core.truth_(inst_112762)){
var statearr_112955_113049 = state_112890__$1;
(statearr_112955_113049[(1)] = (36));

} else {
var statearr_112956_113050 = state_112890__$1;
(statearr_112956_113050[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (17))){
var inst_112702 = (state_112890[(38)]);
var inst_112735 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_112702);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(20),inst_112735);
} else {
if((state_val_112891 === (3))){
var inst_112682 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112957_113051 = state_112890__$1;
(statearr_112957_113051[(2)] = inst_112682);


cljs.core.async.impl.ioc_helpers.process_exception(state_112890__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (12))){
var inst_112719 = (state_112890[(2)]);
var inst_112720 = fluree.db.util.async.throw_err(inst_112719);
var state_112890__$1 = state_112890;
var statearr_112958_113052 = state_112890__$1;
(statearr_112958_113052[(2)] = inst_112720);

(statearr_112958_113052[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (2))){
var inst_112888 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_112890__$1,inst_112888);
} else {
if((state_val_112891 === (66))){
var inst_112861 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112959_113053 = state_112890__$1;
(statearr_112959_113053[(2)] = inst_112861);

(statearr_112959_113053[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (23))){
var inst_112746 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
if(cljs.core.truth_(inst_112746)){
var statearr_112960_113054 = state_112890__$1;
(statearr_112960_113054[(1)] = (24));

} else {
var statearr_112961_113055 = state_112890__$1;
(statearr_112961_113055[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (47))){
var inst_112790 = (state_112890[(41)]);
var inst_112784 = (state_112890[(2)]);
var inst_112785 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_112786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_112787 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_112788 = (new cljs.core.PersistentVector(null,3,(5),inst_112786,inst_112787,null));
var inst_112789 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_112788);
var inst_112790__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_112890__$1 = (function (){var statearr_112962 = state_112890;
(statearr_112962[(46)] = inst_112789);

(statearr_112962[(12)] = inst_112784);

(statearr_112962[(51)] = inst_112785);

(statearr_112962[(41)] = inst_112790__$1);

return statearr_112962;
})();
if(cljs.core.truth_(inst_112790__$1)){
var statearr_112963_113056 = state_112890__$1;
(statearr_112963_113056[(1)] = (48));

} else {
var statearr_112964_113057 = state_112890__$1;
(statearr_112964_113057[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (35))){
var inst_112705 = (state_112890[(27)]);
var inst_112768 = (state_112890[(2)]);
var state_112890__$1 = (function (){var statearr_112965 = state_112890;
(statearr_112965[(52)] = inst_112768);

return statearr_112965;
})();
if(cljs.core.truth_(inst_112705)){
var statearr_112966_113058 = state_112890__$1;
(statearr_112966_113058[(1)] = (39));

} else {
var statearr_112967_113059 = state_112890__$1;
(statearr_112967_113059[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (19))){
var inst_112742 = (state_112890[(53)]);
var inst_112694 = (state_112890[(36)]);
var inst_112741 = (state_112890[(2)]);
var inst_112742__$1 = (inst_112694 == null);
var state_112890__$1 = (function (){var statearr_112968 = state_112890;
(statearr_112968[(53)] = inst_112742__$1);

(statearr_112968[(22)] = inst_112741);

return statearr_112968;
})();
if(cljs.core.truth_(inst_112742__$1)){
var statearr_112969_113060 = state_112890__$1;
(statearr_112969_113060[(1)] = (21));

} else {
var statearr_112970_113061 = state_112890__$1;
(statearr_112970_113061[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (57))){
var inst_112818 = (state_112890[(26)]);
var state_112890__$1 = state_112890;
var statearr_112971_113062 = state_112890__$1;
(statearr_112971_113062[(2)] = inst_112818);

(statearr_112971_113062[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (68))){
var inst_112826 = (state_112890[(19)]);
var state_112890__$1 = state_112890;
var statearr_112972_113063 = state_112890__$1;
(statearr_112972_113063[(2)] = inst_112826);

(statearr_112972_113063[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (11))){
var inst_112695 = (state_112890[(37)]);
var inst_112723 = (state_112890[(2)]);
var inst_112724 = fluree.db.util.core.pred_ident_QMARK_(inst_112695);
var state_112890__$1 = (function (){var statearr_112973 = state_112890;
(statearr_112973[(48)] = inst_112723);

return statearr_112973;
})();
if(inst_112724){
var statearr_112974_113064 = state_112890__$1;
(statearr_112974_113064[(1)] = (13));

} else {
var statearr_112975_113065 = state_112890__$1;
(statearr_112975_113065[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (9))){
var inst_112700 = (state_112890[(13)]);
var inst_112717 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_112700);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(12),inst_112717);
} else {
if((state_val_112891 === (5))){
var inst_112693 = (state_112890[(30)]);
var inst_112708 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_112693);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(8),inst_112708);
} else {
if((state_val_112891 === (14))){
var inst_112695 = (state_112890[(37)]);
var state_112890__$1 = state_112890;
var statearr_112976_113066 = state_112890__$1;
(statearr_112976_113066[(2)] = inst_112695);

(statearr_112976_113066[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (45))){
var inst_112780 = (state_112890[(54)]);
var state_112890__$1 = state_112890;
var statearr_112977_113067 = state_112890__$1;
(statearr_112977_113067[(2)] = inst_112780);

(statearr_112977_113067[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (53))){
var inst_112800 = (state_112890[(42)]);
var inst_112810 = (state_112890[(18)]);
var inst_112795 = (state_112890[(43)]);
var inst_112796 = (state_112890[(44)]);
var inst_112814 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_112810,inst_112795,inst_112796,inst_112800);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(55),inst_112814);
} else {
if((state_val_112891 === (26))){
var inst_112701 = (state_112890[(33)]);
var inst_112751 = (state_112890[(56)]);
var inst_112750 = (state_112890[(2)]);
var inst_112751__$1 = (inst_112701 == null);
var state_112890__$1 = (function (){var statearr_112978 = state_112890;
(statearr_112978[(49)] = inst_112750);

(statearr_112978[(56)] = inst_112751__$1);

return statearr_112978;
})();
if(cljs.core.truth_(inst_112751__$1)){
var statearr_112979_113068 = state_112890__$1;
(statearr_112979_113068[(1)] = (27));

} else {
var statearr_112980_113069 = state_112890__$1;
(statearr_112980_113069[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (16))){
var inst_112728 = (state_112890[(2)]);
var inst_112729 = fluree.db.util.async.throw_err(inst_112728);
var state_112890__$1 = state_112890;
var statearr_112981_113070 = state_112890__$1;
(statearr_112981_113070[(2)] = inst_112729);

(statearr_112981_113070[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (38))){
var inst_112766 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112982_113071 = state_112890__$1;
(statearr_112982_113071[(2)] = inst_112766);

(statearr_112982_113071[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (30))){
var state_112890__$1 = state_112890;
var statearr_112983_113072 = state_112890__$1;
(statearr_112983_113072[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_112983_113072[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (73))){
var inst_112865 = (state_112890[(11)]);
var inst_112866 = (state_112890[(55)]);
var inst_112880 = (state_112890[(2)]);
var inst_112881 = fluree.db.util.async.throw_err(inst_112880);
var inst_112810 = inst_112881;
var inst_112811 = inst_112866;
var inst_112812 = inst_112865;
var state_112890__$1 = (function (){var statearr_112984 = state_112890;
(statearr_112984[(15)] = inst_112812);

(statearr_112984[(16)] = inst_112811);

(statearr_112984[(18)] = inst_112810);

return statearr_112984;
})();
var statearr_112985_113073 = state_112890__$1;
(statearr_112985_113073[(2)] = null);

(statearr_112985_113073[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (10))){
var inst_112700 = (state_112890[(13)]);
var state_112890__$1 = state_112890;
var statearr_112986_113074 = state_112890__$1;
(statearr_112986_113074[(2)] = inst_112700);

(statearr_112986_113074[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (18))){
var inst_112702 = (state_112890[(38)]);
var state_112890__$1 = state_112890;
var statearr_112987_113075 = state_112890__$1;
(statearr_112987_113075[(2)] = inst_112702);

(statearr_112987_113075[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (52))){
var inst_112808 = (state_112890[(2)]);
var inst_112809 = fluree.db.util.async.throw_err(inst_112808);
var inst_112810 = inst_112809;
var inst_112811 = (0);
var inst_112812 = null;
var state_112890__$1 = (function (){var statearr_112988 = state_112890;
(statearr_112988[(15)] = inst_112812);

(statearr_112988[(16)] = inst_112811);

(statearr_112988[(18)] = inst_112810);

return statearr_112988;
})();
var statearr_112989_113076 = state_112890__$1;
(statearr_112989_113076[(2)] = null);

(statearr_112989_113076[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (67))){
var inst_112789 = (state_112890[(46)]);
var inst_112784 = (state_112890[(12)]);
var inst_112866 = (state_112890[(55)]);
var inst_112779 = (state_112890[(24)]);
var inst_112826 = (state_112890[(19)]);
var inst_112868 = (inst_112789.cljs$core$IFn$_invoke$arity$2 ? inst_112789.cljs$core$IFn$_invoke$arity$2(inst_112826,inst_112779) : inst_112789.call(null,inst_112826,inst_112779));
var inst_112869 = (inst_112868 < (0));
var inst_112870 = (inst_112866 < inst_112784);
var inst_112871 = ((inst_112869) && (inst_112870));
var state_112890__$1 = state_112890;
var statearr_112990_113077 = state_112890__$1;
(statearr_112990_113077[(2)] = inst_112871);

(statearr_112990_113077[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (71))){
var inst_112805 = (state_112890[(47)]);
var inst_112826 = (state_112890[(19)]);
var inst_112878 = fluree.db.dbproto._lookup_leaf(inst_112805,inst_112826);
var state_112890__$1 = state_112890;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_112890__$1,(73),inst_112878);
} else {
if((state_val_112891 === (42))){
var state_112890__$1 = state_112890;
var statearr_112991_113078 = state_112890__$1;
(statearr_112991_113078[(2)] = (2147483647));

(statearr_112991_113078[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (37))){
var state_112890__$1 = state_112890;
var statearr_112992_113079 = state_112890__$1;
(statearr_112992_113079[(2)] = (2147483647));

(statearr_112992_113079[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (63))){
var inst_112863 = (state_112890[(2)]);
var state_112890__$1 = state_112890;
var statearr_112993_113080 = state_112890__$1;
(statearr_112993_113080[(2)] = inst_112863);

(statearr_112993_113080[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (8))){
var inst_112710 = (state_112890[(2)]);
var inst_112711 = fluree.db.util.async.throw_err(inst_112710);
var state_112890__$1 = state_112890;
var statearr_112994_113081 = state_112890__$1;
(statearr_112994_113081[(2)] = inst_112711);

(statearr_112994_113081[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_112891 === (49))){
var inst_112793 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_112890__$1 = state_112890;
var statearr_112995_113082 = state_112890__$1;
(statearr_112995_113082[(2)] = inst_112793);

(statearr_112995_113082[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$state_machine__109971__auto__ = null;
var fluree$db$query$range$state_machine__109971__auto____0 = (function (){
var statearr_112996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_112996[(0)] = fluree$db$query$range$state_machine__109971__auto__);

(statearr_112996[(1)] = (1));

return statearr_112996;
});
var fluree$db$query$range$state_machine__109971__auto____1 = (function (state_112890){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_112890);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e112997){if((e112997 instanceof Object)){
var ex__109974__auto__ = e112997;
var statearr_112998_113083 = state_112890;
(statearr_112998_113083[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_112890);

return cljs.core.cst$kw$recur;
} else {
throw e112997;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__113084 = state_112890;
state_112890 = G__113084;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__109971__auto__ = function(state_112890){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__109971__auto____1.call(this,state_112890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__109971__auto____0;
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__109971__auto____1;
return fluree$db$query$range$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_112999 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_112999[(6)] = c__110077__auto__);

return statearr_112999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7;

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_113131){
var state_val_113132 = (state_113131[(1)]);
if((state_val_113132 === (7))){
var state_113131__$1 = state_113131;
var statearr_113133_113151 = state_113131__$1;
(statearr_113133_113151[(2)] = (0));

(statearr_113133_113151[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (1))){
var inst_113092 = cljs.core.seq(subject_groups);
var inst_113093 = cljs.core.first(inst_113092);
var inst_113094 = cljs.core.next(inst_113092);
var inst_113095 = cljs.core.PersistentVector.EMPTY;
var inst_113096 = subject_groups;
var inst_113097 = flake_start;
var inst_113098 = subject_start;
var inst_113099 = inst_113095;
var state_113131__$1 = (function (){var statearr_113134 = state_113131;
(statearr_113134[(7)] = inst_113098);

(statearr_113134[(8)] = inst_113097);

(statearr_113134[(9)] = inst_113099);

(statearr_113134[(10)] = inst_113096);

(statearr_113134[(11)] = inst_113093);

(statearr_113134[(12)] = inst_113094);

return statearr_113134;
})();
var statearr_113135_113152 = state_113131__$1;
(statearr_113135_113152[(2)] = null);

(statearr_113135_113152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (4))){
var inst_113098 = (state_113131[(7)]);
var inst_113097 = (state_113131[(8)]);
var inst_113099 = (state_113131[(9)]);
var inst_113112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113113 = [inst_113097,inst_113098,inst_113099];
var inst_113114 = (new cljs.core.PersistentVector(null,3,(5),inst_113112,inst_113113,null));
var state_113131__$1 = state_113131;
var statearr_113136_113153 = state_113131__$1;
(statearr_113136_113153[(2)] = inst_113114);

(statearr_113136_113153[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (6))){
var inst_113127 = (state_113131[(2)]);
var state_113131__$1 = state_113131;
var statearr_113137_113154 = state_113131__$1;
(statearr_113137_113154[(2)] = inst_113127);

(statearr_113137_113154[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (3))){
var inst_113129 = (state_113131[(2)]);
var state_113131__$1 = state_113131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113131__$1,inst_113129);
} else {
if((state_val_113132 === (2))){
var inst_113098 = (state_113131[(7)]);
var inst_113097 = (state_113131[(8)]);
var inst_113096 = (state_113131[(10)]);
var inst_113105 = (state_113131[(13)]);
var inst_113104 = cljs.core.seq(inst_113096);
var inst_113105__$1 = cljs.core.first(inst_113104);
var inst_113106 = cljs.core.next(inst_113104);
var inst_113107 = (inst_113105__$1 == null);
var inst_113108 = (inst_113097 >= flake_limit);
var inst_113109 = (inst_113098 >= subject_limit);
var inst_113110 = ((inst_113107) || (inst_113108) || (inst_113109));
var state_113131__$1 = (function (){var statearr_113138 = state_113131;
(statearr_113138[(14)] = inst_113106);

(statearr_113138[(13)] = inst_113105__$1);

return statearr_113138;
})();
if(cljs.core.truth_(inst_113110)){
var statearr_113139_113155 = state_113131__$1;
(statearr_113139_113155[(1)] = (4));

} else {
var statearr_113140_113156 = state_113131__$1;
(statearr_113140_113156[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (9))){
var inst_113098 = (state_113131[(7)]);
var inst_113097 = (state_113131[(8)]);
var inst_113106 = (state_113131[(14)]);
var inst_113099 = (state_113131[(9)]);
var inst_113116 = (state_113131[(15)]);
var inst_113105 = (state_113131[(13)]);
var inst_113121 = (state_113131[(2)]);
var inst_113122 = (inst_113097 + inst_113116);
var inst_113123 = (inst_113098 + inst_113121);
var inst_113124 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113099,inst_113105);
var inst_113096 = inst_113106;
var inst_113097__$1 = inst_113122;
var inst_113098__$1 = inst_113123;
var inst_113099__$1 = inst_113124;
var state_113131__$1 = (function (){var statearr_113141 = state_113131;
(statearr_113141[(7)] = inst_113098__$1);

(statearr_113141[(8)] = inst_113097__$1);

(statearr_113141[(9)] = inst_113099__$1);

(statearr_113141[(10)] = inst_113096);

return statearr_113141;
})();
var statearr_113142_113157 = state_113131__$1;
(statearr_113142_113157[(2)] = null);

(statearr_113142_113157[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (5))){
var inst_113116 = (state_113131[(15)]);
var inst_113105 = (state_113131[(13)]);
var inst_113116__$1 = cljs.core.count(inst_113105);
var inst_113117 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_113116__$1);
var state_113131__$1 = (function (){var statearr_113143 = state_113131;
(statearr_113143[(15)] = inst_113116__$1);

return statearr_113143;
})();
if(inst_113117){
var statearr_113144_113158 = state_113131__$1;
(statearr_113144_113158[(1)] = (7));

} else {
var statearr_113145_113159 = state_113131__$1;
(statearr_113145_113159[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113132 === (8))){
var state_113131__$1 = state_113131;
var statearr_113146_113160 = state_113131__$1;
(statearr_113146_113160[(2)] = (1));

(statearr_113146_113160[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____0 = (function (){
var statearr_113147 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113147[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__);

(statearr_113147[(1)] = (1));

return statearr_113147;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____1 = (function (state_113131){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_113131);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e113148){if((e113148 instanceof Object)){
var ex__109974__auto__ = e113148;
var statearr_113149_113161 = state_113131;
(statearr_113149_113161[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113131);

return cljs.core.cst$kw$recur;
} else {
throw e113148;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__113162 = state_113131;
state_113131 = G__113162;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__ = function(state_113131){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____1.call(this,state_113131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_113150 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_113150[(6)] = c__110077__auto__);

return statearr_113150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_113202){
var state_val_113203 = (state_113202[(1)]);
if((state_val_113203 === (7))){
var inst_113198 = (state_113202[(2)]);
var state_113202__$1 = state_113202;
var statearr_113204_113229 = state_113202__$1;
(statearr_113204_113229[(2)] = inst_113198);


cljs.core.async.impl.ioc_helpers.process_exception(state_113202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (1))){
var state_113202__$1 = state_113202;
var statearr_113205_113230 = state_113202__$1;
(statearr_113205_113230[(2)] = null);

(statearr_113205_113230[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113202,(3),Error,null,(2));
var inst_113167 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_113202__$1 = state_113202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113202__$1,(5),inst_113167);
} else {
if((state_val_113203 === (15))){
var inst_113185 = (state_113202[(7)]);
var inst_113187 = fluree.db.dbproto._lookup_leaf(root_node,inst_113185);
var state_113202__$1 = state_113202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113202__$1,(18),inst_113187);
} else {
if((state_val_113203 === (13))){
var inst_113171 = (state_113202[(8)]);
var inst_113185 = (state_113202[(7)]);
var inst_113185__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_113171);
var state_113202__$1 = (function (){var statearr_113206 = state_113202;
(statearr_113206[(7)] = inst_113185__$1);

return statearr_113206;
})();
if(cljs.core.truth_(inst_113185__$1)){
var statearr_113207_113231 = state_113202__$1;
(statearr_113207_113231[(1)] = (15));

} else {
var statearr_113208_113232 = state_113202__$1;
(statearr_113208_113232[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (6))){
var state_113202__$1 = state_113202;
var statearr_113209_113233 = state_113202__$1;
(statearr_113209_113233[(2)] = null);

(statearr_113209_113233[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (17))){
var inst_113194 = (state_113202[(2)]);
var state_113202__$1 = state_113202;
var statearr_113210_113234 = state_113202__$1;
(statearr_113210_113234[(2)] = inst_113194);

(statearr_113210_113234[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (3))){
var inst_113163 = (state_113202[(2)]);
var state_113202__$1 = state_113202;
var statearr_113211_113235 = state_113202__$1;
(statearr_113211_113235[(2)] = inst_113163);


cljs.core.async.impl.ioc_helpers.process_exception(state_113202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (12))){
var inst_113182 = (state_113202[(9)]);
var state_113202__$1 = state_113202;
var statearr_113212_113236 = state_113202__$1;
(statearr_113212_113236[(2)] = inst_113182);

(statearr_113212_113236[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (2))){
var inst_113200 = (state_113202[(2)]);
var state_113202__$1 = state_113202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113202__$1,inst_113200);
} else {
if((state_val_113203 === (11))){
var inst_113179 = (state_113202[(2)]);
var inst_113180 = fluree.db.util.async.throw_err(inst_113179);
var state_113202__$1 = state_113202;
var statearr_113213_113237 = state_113202__$1;
(statearr_113213_113237[(2)] = inst_113180);


cljs.core.async.impl.ioc_helpers.process_exception(state_113202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (9))){
var inst_113173 = (state_113202[(2)]);
var state_113202__$1 = (function (){var statearr_113214 = state_113202;
(statearr_113214[(10)] = inst_113173);

return statearr_113214;
})();
var statearr_113215_113238 = state_113202__$1;
(statearr_113215_113238[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_113202__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (5))){
var inst_113169 = (state_113202[(2)]);
var inst_113170 = fluree.db.util.async.throw_err(inst_113169);
var inst_113171 = inst_113170;
var state_113202__$1 = (function (){var statearr_113216 = state_113202;
(statearr_113216[(8)] = inst_113171);

return statearr_113216;
})();
var statearr_113217_113239 = state_113202__$1;
(statearr_113217_113239[(2)] = null);

(statearr_113217_113239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (14))){
var inst_113196 = (state_113202[(2)]);
var state_113202__$1 = state_113202;
var statearr_113218_113240 = state_113202__$1;
(statearr_113218_113240[(2)] = inst_113196);

(statearr_113218_113240[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (16))){
var state_113202__$1 = state_113202;
var statearr_113219_113241 = state_113202__$1;
(statearr_113219_113241[(2)] = null);

(statearr_113219_113241[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (10))){
var inst_113171 = (state_113202[(8)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113202,(9),java.lang.Exception,null,(8));
var inst_113177 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_113171,t,novelty,fast_forward_db_QMARK_);
var state_113202__$1 = state_113202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113202__$1,(11),inst_113177);
} else {
if((state_val_113203 === (18))){
var inst_113189 = (state_113202[(2)]);
var inst_113190 = fluree.db.util.async.throw_err(inst_113189);
var inst_113171 = inst_113190;
var state_113202__$1 = (function (){var statearr_113220 = state_113202;
(statearr_113220[(8)] = inst_113171);

return statearr_113220;
})();
var statearr_113221_113242 = state_113202__$1;
(statearr_113221_113242[(2)] = null);

(statearr_113221_113242[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113203 === (8))){
var inst_113182 = (state_113202[(9)]);
var inst_113182__$1 = (state_113202[(2)]);
var state_113202__$1 = (function (){var statearr_113222 = state_113202;
(statearr_113222[(9)] = inst_113182__$1);

return statearr_113222;
})();
if(cljs.core.truth_(inst_113182__$1)){
var statearr_113223_113243 = state_113202__$1;
(statearr_113223_113243[(1)] = (12));

} else {
var statearr_113224_113244 = state_113202__$1;
(statearr_113224_113244[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____0 = (function (){
var statearr_113225 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_113225[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__);

(statearr_113225[(1)] = (1));

return statearr_113225;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____1 = (function (state_113202){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_113202);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e113226){if((e113226 instanceof Object)){
var ex__109974__auto__ = e113226;
var statearr_113227_113245 = state_113202;
(statearr_113227_113245[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113202);

return cljs.core.cst$kw$recur;
} else {
throw e113226;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__113246 = state_113202;
state_113202 = G__113246;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__ = function(state_113202){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____1.call(this,state_113202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_113228 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_113228[(6)] = c__110077__auto__);

return statearr_113228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__113253 = arguments.length;
switch (G__113253) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__113254 = (function (){var pred__113257 = cljs.core.identical_QMARK_;
var expr__113258 = test;
if(cljs.core.truth_((pred__113257.cljs$core$IFn$_invoke$arity$2 ? pred__113257.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__113258) : pred__113257.call(null,cljs.core._EQ_,expr__113258)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__113257.cljs$core$IFn$_invoke$arity$2 ? pred__113257.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__113258) : pred__113257.call(null,cljs.core._LT_,expr__113258)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__113257.cljs$core$IFn$_invoke$arity$2 ? pred__113257.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__113258) : pred__113257.call(null,cljs.core._LT__EQ_,expr__113258)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__113257.cljs$core$IFn$_invoke$arity$2 ? pred__113257.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__113258) : pred__113257.call(null,cljs.core._GT_,expr__113258)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__113257.cljs$core$IFn$_invoke$arity$2 ? pred__113257.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__113258) : pred__113257.call(null,cljs.core._GT__EQ_,expr__113258)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__113258)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113254,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113254,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113254,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__113254,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_113651){
var state_val_113652 = (state_113651[(1)]);
if((state_val_113652 === (121))){
var inst_113624 = (state_113651[(7)]);
var inst_113624__$1 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113653 = state_113651;
(statearr_113653[(7)] = inst_113624__$1);

return statearr_113653;
})();
if(cljs.core.truth_(inst_113624__$1)){
var statearr_113654_113853 = state_113651__$1;
(statearr_113654_113853[(1)] = (122));

} else {
var statearr_113655_113854 = state_113651__$1;
(statearr_113655_113854[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (65))){
var inst_113420 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113656_113855 = state_113651__$1;
(statearr_113656_113855[(2)] = inst_113420);

(statearr_113656_113855[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (70))){
var state_113651__$1 = state_113651;
var statearr_113657_113856 = state_113651__$1;
(statearr_113657_113856[(2)] = false);

(statearr_113657_113856[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (62))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113282 = (state_113651[(11)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113386 = (state_113651[(14)]);
var inst_113324 = (state_113651[(15)]);
var inst_113290 = (state_113651[(16)]);
var inst_113404 = (state_113651[(17)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113422__$1 = (state_113651[(2)]);
var inst_113423 = fluree.db.flake.__GT_Flake(inst_113324,inst_113395,inst_113377,inst_113282,inst_113283,inst_113413);
var inst_113424 = fluree.db.flake.__GT_Flake(inst_113333,inst_113404,inst_113386,inst_113289,inst_113290,inst_113422__$1);
var inst_113426 = (opts == null);
var inst_113427 = cljs.core.not(inst_113426);
var state_113651__$1 = (function (){var statearr_113658 = state_113651;
(statearr_113658[(20)] = inst_113423);

(statearr_113658[(13)] = inst_113422__$1);

(statearr_113658[(21)] = inst_113424);

return statearr_113658;
})();
if(inst_113427){
var statearr_113659_113857 = state_113651__$1;
(statearr_113659_113857[(1)] = (66));

} else {
var statearr_113660_113858 = state_113651__$1;
(statearr_113660_113858[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (74))){
var inst_113445 = (state_113651[(22)]);
var inst_113447 = (state_113651[(23)]);
var inst_113445__$1 = (state_113651[(2)]);
var inst_113446 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_113445__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_113447__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113445__$1,cljs.core.cst$kw$limit);
var inst_113448 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_113445__$1,cljs.core.cst$kw$offset,(0));
var state_113651__$1 = (function (){var statearr_113661 = state_113651;
(statearr_113661[(24)] = inst_113446);

(statearr_113661[(25)] = inst_113448);

(statearr_113661[(22)] = inst_113445__$1);

(statearr_113661[(23)] = inst_113447__$1);

return statearr_113661;
})();
if(cljs.core.truth_(inst_113447__$1)){
var statearr_113662_113859 = state_113651__$1;
(statearr_113662_113859[(1)] = (75));

} else {
var statearr_113663_113860 = state_113651__$1;
(statearr_113663_113860[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (110))){
var inst_113446 = (state_113651[(24)]);
var inst_113546 = (state_113651[(26)]);
var inst_113479 = (state_113651[(27)]);
var inst_113452 = (state_113651[(28)]);
var inst_113478 = (state_113651[(29)]);
var inst_113595 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_113546,inst_113478,inst_113479,inst_113446,inst_113452);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(118),inst_113595);
} else {
if((state_val_113652 === (130))){
var inst_113613 = (state_113651[(30)]);
var inst_113632 = (state_113651[(31)]);
var inst_113615 = (state_113651[(32)]);
var inst_113612 = (state_113651[(33)]);
var inst_113614 = (state_113651[(34)]);
var inst_113476 = inst_113632;
var inst_113477 = inst_113612;
var inst_113478 = inst_113613;
var inst_113479 = inst_113614;
var inst_113480 = inst_113615;
var state_113651__$1 = (function (){var statearr_113664 = state_113651;
(statearr_113664[(27)] = inst_113479);

(statearr_113664[(35)] = inst_113476);

(statearr_113664[(36)] = inst_113480);

(statearr_113664[(29)] = inst_113478);

(statearr_113664[(37)] = inst_113477);

return statearr_113664;
})();
var statearr_113665_113861 = state_113651__$1;
(statearr_113665_113861[(2)] = null);

(statearr_113665_113861[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (128))){
var inst_113636 = (state_113651[(2)]);
var inst_113637 = cljs.core.not(inst_113636);
var state_113651__$1 = state_113651;
if(inst_113637){
var statearr_113666_113862 = state_113651__$1;
(statearr_113666_113862[(1)] = (129));

} else {
var statearr_113667_113863 = state_113651__$1;
(statearr_113667_113863[(1)] = (130));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (7))){
var inst_113307 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113307)){
var statearr_113668_113864 = state_113651__$1;
(statearr_113668_113864[(1)] = (11));

} else {
var statearr_113669_113865 = state_113651__$1;
(statearr_113669_113865[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (59))){
var inst_113411 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113670_113866 = state_113651__$1;
(statearr_113670_113866[(2)] = inst_113411);

(statearr_113670_113866[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (86))){
var inst_113486 = (state_113651[(38)]);
var state_113651__$1 = state_113651;
var statearr_113671_113867 = state_113651__$1;
(statearr_113671_113867[(2)] = inst_113486);

(statearr_113671_113867[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (20))){
var inst_113281 = (state_113651[(39)]);
var inst_113333 = (state_113651[(2)]);
var inst_113334 = cljs.core.boolean_QMARK_(inst_113281);
var state_113651__$1 = (function (){var statearr_113672 = state_113651;
(statearr_113672[(9)] = inst_113333);

return statearr_113672;
})();
if(inst_113334){
var statearr_113673_113868 = state_113651__$1;
(statearr_113673_113868[(1)] = (22));

} else {
var statearr_113674_113869 = state_113651__$1;
(statearr_113674_113869[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (72))){
var inst_113442 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_113651__$1 = state_113651;
var statearr_113675_113870 = state_113651__$1;
(statearr_113675_113870[(2)] = inst_113442);

(statearr_113675_113870[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (58))){
var state_113651__$1 = state_113651;
var statearr_113676_113871 = state_113651__$1;
(statearr_113676_113871[(2)] = (2147483647));

(statearr_113676_113871[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (60))){
var inst_113291 = (state_113651[(40)]);
var state_113651__$1 = state_113651;
var statearr_113677_113872 = state_113651__$1;
(statearr_113677_113872[(2)] = inst_113291);

(statearr_113677_113872[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (27))){
var inst_113345 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113678_113873 = state_113651__$1;
(statearr_113678_113873[(2)] = inst_113345);

(statearr_113678_113873[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (1))){
var state_113651__$1 = state_113651;
var statearr_113679_113874 = state_113651__$1;
(statearr_113679_113874[(2)] = null);

(statearr_113679_113874[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (69))){
var state_113651__$1 = state_113651;
var statearr_113680_113875 = state_113651__$1;
(statearr_113680_113875[(2)] = true);

(statearr_113680_113875[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (101))){
var inst_113515 = (state_113651[(41)]);
var state_113651__$1 = state_113651;
var statearr_113681_113876 = state_113651__$1;
(statearr_113681_113876[(2)] = inst_113515);

(statearr_113681_113876[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (24))){
var inst_113347 = (state_113651[(42)]);
var inst_113347__$1 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113682 = state_113651;
(statearr_113682[(42)] = inst_113347__$1);

return statearr_113682;
})();
if(cljs.core.truth_(inst_113347__$1)){
var statearr_113683_113877 = state_113651__$1;
(statearr_113683_113877[(1)] = (31));

} else {
var statearr_113684_113878 = state_113651__$1;
(statearr_113684_113878[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (102))){
var inst_113519 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113685_113879 = state_113651__$1;
(statearr_113685_113879[(2)] = inst_113519);

(statearr_113685_113879[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (55))){
var inst_113407 = (cljs.core._GT__EQ_ === start_test);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113407)){
var statearr_113686_113880 = state_113651__$1;
(statearr_113686_113880[(1)] = (57));

} else {
var statearr_113687_113881 = state_113651__$1;
(statearr_113687_113881[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (85))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113473 = (state_113651[(43)]);
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113446 = (state_113651[(24)]);
var inst_113282 = (state_113651[(11)]);
var inst_113486 = (state_113651[(38)]);
var inst_113423 = (state_113651[(20)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113479 = (state_113651[(27)]);
var inst_113386 = (state_113651[(14)]);
var inst_113365 = (state_113651[(47)]);
var inst_113445 = (state_113651[(22)]);
var inst_113424 = (state_113651[(21)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113368 = (state_113651[(49)]);
var inst_113476 = (state_113651[(35)]);
var inst_113458 = (state_113651[(50)]);
var inst_113453 = (state_113651[(51)]);
var inst_113312 = (state_113651[(52)]);
var inst_113404 = (state_113651[(17)]);
var inst_113452 = (state_113651[(28)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113469 = (state_113651[(54)]);
var inst_113313 = (state_113651[(55)]);
var inst_113454 = (state_113651[(56)]);
var inst_113278 = (state_113651[(57)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113364 = (state_113651[(58)]);
var inst_113477 = (state_113651[(37)]);
var inst_113490 = (function (){var no_filter_QMARK_ = true;
var t = inst_113459;
var max_limit_QMARK_ = inst_113453;
var next_node = inst_113476;
var map__113277 = inst_113445;
var fast_forward_db_QMARK_ = inst_113464;
var s1 = inst_113324;
var o2 = inst_113386;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var i = inst_113478;
var vec__113274 = inst_113365;
var m1 = inst_113413;
var root_node = inst_113469;
var s2 = inst_113333;
var p2 = inst_113404;
var G__113487 = inst_113486;
var permissions = inst_113454;
var limit = inst_113452;
var start_flake = inst_113423;
var flake_limit = inst_113446;
var offset = inst_113477;
var vec__113267 = inst_113285;
var acc = inst_113480;
var vec__113271 = inst_113364;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113377;
var end_flake = inst_113424;
var base_result = inst_113486;
var s = inst_113479;
var node_start = inst_113473;
var p1 = inst_113395;
var subject_fn = inst_113313;
var object_fn = inst_113368;
var idx_compare = inst_113458;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113422;
var novelty = inst_113463;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__){
return (function (p1__113247_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__113247_SHARP_.o,start_flake.o);
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__))
})();
var inst_113491 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_113490,inst_113486);
var state_113651__$1 = state_113651;
var statearr_113688_113882 = state_113651__$1;
(statearr_113688_113882[(2)] = inst_113491);

(statearr_113688_113882[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (39))){
var inst_113367 = (state_113651[(59)]);
var state_113651__$1 = state_113651;
var statearr_113689_113883 = state_113651__$1;
(statearr_113689_113883[(2)] = inst_113367);

(statearr_113689_113883[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (88))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113473 = (state_113651[(43)]);
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113446 = (state_113651[(24)]);
var inst_113282 = (state_113651[(11)]);
var inst_113486 = (state_113651[(38)]);
var inst_113423 = (state_113651[(20)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113479 = (state_113651[(27)]);
var inst_113386 = (state_113651[(14)]);
var inst_113365 = (state_113651[(47)]);
var inst_113445 = (state_113651[(22)]);
var inst_113424 = (state_113651[(21)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113368 = (state_113651[(49)]);
var inst_113476 = (state_113651[(35)]);
var inst_113458 = (state_113651[(50)]);
var inst_113453 = (state_113651[(51)]);
var inst_113312 = (state_113651[(52)]);
var inst_113404 = (state_113651[(17)]);
var inst_113452 = (state_113651[(28)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113494 = (state_113651[(60)]);
var inst_113469 = (state_113651[(54)]);
var inst_113313 = (state_113651[(55)]);
var inst_113454 = (state_113651[(56)]);
var inst_113278 = (state_113651[(57)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113364 = (state_113651[(58)]);
var inst_113477 = (state_113651[(37)]);
var inst_113496 = (function (){var no_filter_QMARK_ = true;
var t = inst_113459;
var max_limit_QMARK_ = inst_113453;
var next_node = inst_113476;
var map__113277 = inst_113445;
var fast_forward_db_QMARK_ = inst_113464;
var s1 = inst_113324;
var o2 = inst_113386;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var i = inst_113478;
var vec__113274 = inst_113365;
var m1 = inst_113413;
var root_node = inst_113469;
var s2 = inst_113333;
var p2 = inst_113404;
var G__113487 = inst_113494;
var permissions = inst_113454;
var limit = inst_113452;
var start_flake = inst_113423;
var flake_limit = inst_113446;
var offset = inst_113477;
var vec__113267 = inst_113285;
var acc = inst_113480;
var vec__113271 = inst_113364;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113377;
var end_flake = inst_113424;
var base_result = inst_113486;
var s = inst_113479;
var node_start = inst_113473;
var p1 = inst_113395;
var subject_fn = inst_113313;
var object_fn = inst_113368;
var idx_compare = inst_113458;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113422;
var novelty = inst_113463;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113494,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__){
return (function (p1__113248_SHARP_){
var G__113690 = p1__113248_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__113690) : subject_fn.call(null,G__113690));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113494,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__))
})();
var inst_113497 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_113496,inst_113494);
var state_113651__$1 = state_113651;
var statearr_113691_113884 = state_113651__$1;
(statearr_113691_113884[(2)] = inst_113497);

(statearr_113691_113884[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (46))){
var inst_113280 = (state_113651[(61)]);
var state_113651__$1 = state_113651;
var statearr_113692_113885 = state_113651__$1;
(statearr_113692_113885[(2)] = inst_113280);

(statearr_113692_113885[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (4))){
var inst_113285 = (state_113651[(53)]);
var inst_113278 = (state_113651[(57)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_113651,(3),Error,null,(2));
var inst_113278__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_113279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(0),null);
var inst_113280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(1),null);
var inst_113281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(2),null);
var inst_113282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(3),null);
var inst_113283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(4),null);
var inst_113284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113278__$1,(5),null);
var inst_113285__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_113286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(0),null);
var inst_113287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(1),null);
var inst_113288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(2),null);
var inst_113289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(3),null);
var inst_113290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(4),null);
var inst_113291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113285__$1,(5),null);
var inst_113293 = (opts == null);
var inst_113294 = cljs.core.not(inst_113293);
var state_113651__$1 = (function (){var statearr_113693 = state_113651;
(statearr_113693[(62)] = inst_113284);

(statearr_113693[(63)] = inst_113287);

(statearr_113693[(39)] = inst_113281);

(statearr_113693[(64)] = inst_113288);

(statearr_113693[(11)] = inst_113282);

(statearr_113693[(65)] = inst_113279);

(statearr_113693[(61)] = inst_113280);

(statearr_113693[(16)] = inst_113290);

(statearr_113693[(18)] = inst_113283);

(statearr_113693[(19)] = inst_113289);

(statearr_113693[(53)] = inst_113285__$1);

(statearr_113693[(40)] = inst_113291);

(statearr_113693[(57)] = inst_113278__$1);

(statearr_113693[(66)] = inst_113286);

return statearr_113693;
})();
if(inst_113294){
var statearr_113694_113886 = state_113651__$1;
(statearr_113694_113886[(1)] = (5));

} else {
var statearr_113695_113887 = state_113651__$1;
(statearr_113695_113887[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (77))){
var inst_113452 = (state_113651[(28)]);
var inst_113452__$1 = (state_113651[(2)]);
var inst_113453 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_113452__$1,fluree.db.util.core.max_long);
var inst_113454 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_113455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113456 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_113457 = (new cljs.core.PersistentVector(null,3,(5),inst_113455,inst_113456,null));
var inst_113458 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_113457);
var inst_113459 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_113460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113461 = [cljs.core.cst$kw$novelty,idx];
var inst_113462 = (new cljs.core.PersistentVector(null,2,(5),inst_113460,inst_113461,null));
var inst_113463 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_113462);
var inst_113464 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_113465 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_113466 = fluree.db.dbproto._resolve(inst_113465);
var state_113651__$1 = (function (){var statearr_113696 = state_113651;
(statearr_113696[(44)] = inst_113464);

(statearr_113696[(45)] = inst_113459);

(statearr_113696[(46)] = inst_113463);

(statearr_113696[(50)] = inst_113458);

(statearr_113696[(51)] = inst_113453);

(statearr_113696[(28)] = inst_113452__$1);

(statearr_113696[(56)] = inst_113454);

return statearr_113696;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(78),inst_113466);
} else {
if((state_val_113652 === (106))){
var inst_113535 = (state_113651[(67)]);
var inst_113479 = (state_113651[(27)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113477 = (state_113651[(37)]);
var inst_113538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113539 = (inst_113477 - inst_113535);
var inst_113540 = [inst_113539,inst_113478,inst_113479,inst_113480];
var inst_113541 = (new cljs.core.PersistentVector(null,4,(5),inst_113538,inst_113540,null));
var state_113651__$1 = state_113651;
var statearr_113697_113888 = state_113651__$1;
(statearr_113697_113888[(2)] = inst_113541);

(statearr_113697_113888[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (119))){
var inst_113613 = (state_113651[(30)]);
var inst_113446 = (state_113651[(24)]);
var inst_113424 = (state_113651[(21)]);
var inst_113458 = (state_113651[(50)]);
var inst_113452 = (state_113651[(28)]);
var inst_113614 = (state_113651[(34)]);
var inst_113513 = (state_113651[(68)]);
var inst_113617 = (inst_113458.cljs$core$IFn$_invoke$arity$2 ? inst_113458.cljs$core$IFn$_invoke$arity$2(inst_113513,inst_113424) : inst_113458.call(null,inst_113513,inst_113424));
var inst_113618 = (inst_113617 < (0));
var inst_113619 = (inst_113613 < inst_113446);
var inst_113620 = (inst_113614 < inst_113452);
var inst_113621 = ((inst_113618) && (inst_113619) && (inst_113620));
var state_113651__$1 = state_113651;
var statearr_113698_113889 = state_113651__$1;
(statearr_113698_113889[(2)] = inst_113621);

(statearr_113698_113889[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (95))){
var inst_113506 = (state_113651[(69)]);
var state_113651__$1 = state_113651;
var statearr_113699_113890 = state_113651__$1;
(statearr_113699_113890[(2)] = inst_113506);

(statearr_113699_113890[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (54))){
var inst_113284 = (state_113651[(62)]);
var state_113651__$1 = state_113651;
var statearr_113700_113891 = state_113651__$1;
(statearr_113700_113891[(2)] = inst_113284);

(statearr_113700_113891[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (92))){
var inst_113500 = (state_113651[(70)]);
var state_113651__$1 = state_113651;
var statearr_113701_113892 = state_113651__$1;
(statearr_113701_113892[(2)] = inst_113500);

(statearr_113701_113892[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (104))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113473 = (state_113651[(43)]);
var inst_113464 = (state_113651[(44)]);
var inst_113534 = (state_113651[(71)]);
var inst_113535 = (state_113651[(67)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113446 = (state_113651[(24)]);
var inst_113282 = (state_113651[(11)]);
var inst_113486 = (state_113651[(38)]);
var inst_113423 = (state_113651[(20)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113479 = (state_113651[(27)]);
var inst_113386 = (state_113651[(14)]);
var inst_113365 = (state_113651[(47)]);
var inst_113445 = (state_113651[(22)]);
var inst_113424 = (state_113651[(21)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113368 = (state_113651[(49)]);
var inst_113476 = (state_113651[(35)]);
var inst_113458 = (state_113651[(50)]);
var inst_113453 = (state_113651[(51)]);
var inst_113312 = (state_113651[(52)]);
var inst_113404 = (state_113651[(17)]);
var inst_113452 = (state_113651[(28)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113469 = (state_113651[(54)]);
var inst_113313 = (state_113651[(55)]);
var inst_113513 = (state_113651[(68)]);
var inst_113512 = (state_113651[(72)]);
var inst_113454 = (state_113651[(56)]);
var inst_113278 = (state_113651[(57)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113364 = (state_113651[(58)]);
var inst_113477 = (state_113651[(37)]);
var inst_113533 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_113512;
var t = inst_113459;
var max_limit_QMARK_ = inst_113453;
var next_node = inst_113476;
var map__113277 = inst_113445;
var fast_forward_db_QMARK_ = inst_113464;
var s1 = inst_113324;
var o2 = inst_113386;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var i = inst_113478;
var rhs = inst_113513;
var vec__113274 = inst_113365;
var m1 = inst_113413;
var root_node = inst_113469;
var s2 = inst_113333;
var p2 = inst_113404;
var permissions = inst_113454;
var limit = inst_113452;
var start_flake = inst_113423;
var flake_limit = inst_113446;
var offset = inst_113477;
var vec__113267 = inst_113285;
var acc = inst_113480;
var vec__113271 = inst_113364;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113377;
var end_flake = inst_113424;
var base_result = inst_113486;
var s = inst_113479;
var node_start = inst_113473;
var p1 = inst_113395;
var subject_fn = inst_113313;
var object_fn = inst_113368;
var idx_compare = inst_113458;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113422;
var novelty = inst_113463;
return ((function (no_filter_QMARK_,base_result_SINGLEQUOTE_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,rhs,vec__113274,m1,root_node,s2,p2,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113534,inst_113535,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113513,inst_113512,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__){
return (function (p1__113251_SHARP_){
return p1__113251_SHARP_.s;
});
;})(no_filter_QMARK_,base_result_SINGLEQUOTE_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,rhs,vec__113274,m1,root_node,s2,p2,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113534,inst_113535,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113513,inst_113512,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__))
})();
var inst_113534__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_113533,inst_113512);
var inst_113535__$1 = cljs.core.count(inst_113534__$1);
var inst_113536 = (inst_113477 > inst_113535__$1);
var state_113651__$1 = (function (){var statearr_113702 = state_113651;
(statearr_113702[(71)] = inst_113534__$1);

(statearr_113702[(67)] = inst_113535__$1);

return statearr_113702;
})();
if(cljs.core.truth_(inst_113536)){
var statearr_113703_113893 = state_113651__$1;
(statearr_113703_113893[(1)] = (106));

} else {
var statearr_113704_113894 = state_113651__$1;
(statearr_113704_113894[(1)] = (107));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (15))){
var inst_113279 = (state_113651[(65)]);
var state_113651__$1 = state_113651;
var statearr_113705_113895 = state_113651__$1;
(statearr_113705_113895[(2)] = inst_113279);

(statearr_113705_113895[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (48))){
var inst_113386 = (state_113651[(14)]);
var state_113651__$1 = state_113651;
var statearr_113706_113896 = state_113651__$1;
(statearr_113706_113896[(2)] = inst_113386);

(statearr_113706_113896[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (50))){
var inst_113400 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113400)){
var statearr_113707_113897 = state_113651__$1;
(statearr_113707_113897[(1)] = (51));

} else {
var statearr_113708_113898 = state_113651__$1;
(statearr_113708_113898[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (116))){
var inst_113574 = (state_113651[(73)]);
var inst_113572 = (state_113651[(74)]);
var inst_113584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113585 = [inst_113574,inst_113572];
var inst_113586 = (new cljs.core.PersistentVector(null,2,(5),inst_113584,inst_113585,null));
var state_113651__$1 = state_113651;
var statearr_113709_113899 = state_113651__$1;
(statearr_113709_113899[(2)] = inst_113586);

(statearr_113709_113899[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (75))){
var inst_113447 = (state_113651[(23)]);
var state_113651__$1 = state_113651;
var statearr_113710_113900 = state_113651__$1;
(statearr_113710_113900[(2)] = inst_113447);

(statearr_113710_113900[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (99))){
var inst_113522 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113522)){
var statearr_113711_113901 = state_113651__$1;
(statearr_113711_113901[(1)] = (103));

} else {
var statearr_113712_113902 = state_113651__$1;
(statearr_113712_113902[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (21))){
var inst_113329 = (state_113651[(2)]);
var inst_113330 = fluree.db.util.async.throw_err(inst_113329);
var state_113651__$1 = state_113651;
var statearr_113713_113903 = state_113651__$1;
(statearr_113713_113903[(2)] = inst_113330);

(statearr_113713_113903[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (31))){
var inst_113333 = (state_113651[(9)]);
var inst_113284 = (state_113651[(62)]);
var inst_113287 = (state_113651[(63)]);
var inst_113281 = (state_113651[(39)]);
var inst_113288 = (state_113651[(64)]);
var inst_113282 = (state_113651[(11)]);
var inst_113280 = (state_113651[(61)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113347 = (state_113651[(42)]);
var inst_113312 = (state_113651[(52)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113315 = (state_113651[(75)]);
var inst_113291 = (state_113651[(40)]);
var inst_113313 = (state_113651[(55)]);
var inst_113278 = (state_113651[(57)]);
var inst_113349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113351 = [null,null];
var inst_113352 = (new cljs.core.PersistentVector(null,2,(5),inst_113350,inst_113351,null));
var inst_113353 = (function (){var bool = inst_113347;
var temp__5733__auto__ = inst_113347;
var s1 = inst_113324;
var o2 = inst_113288;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var m1 = inst_113284;
var s2 = inst_113333;
var p2 = inst_113287;
var vec__113267 = inst_113285;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113281;
var p1 = inst_113280;
var subject_fn = inst_113313;
var object_fn = inst_113315;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113291;
return ((function (bool,temp__5733__auto__,s1,o2,t1,predicate_fn,m1,s2,p2,vec__113267,t2,map__113270,op1,o1,p1,subject_fn,object_fn,vec__113264,op2,m2,inst_113333,inst_113284,inst_113287,inst_113281,inst_113288,inst_113282,inst_113280,inst_113324,inst_113314,inst_113290,inst_113347,inst_113312,inst_113283,inst_113289,inst_113285,inst_113315,inst_113291,inst_113313,inst_113278,inst_113349,inst_113350,inst_113351,inst_113352,state_val_113652,c__110077__auto__){
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
;})(bool,temp__5733__auto__,s1,o2,t1,predicate_fn,m1,s2,p2,vec__113267,t2,map__113270,op1,o1,p1,subject_fn,object_fn,vec__113264,op2,m2,inst_113333,inst_113284,inst_113287,inst_113281,inst_113288,inst_113282,inst_113280,inst_113324,inst_113314,inst_113290,inst_113347,inst_113312,inst_113283,inst_113289,inst_113285,inst_113315,inst_113291,inst_113313,inst_113278,inst_113349,inst_113350,inst_113351,inst_113352,state_val_113652,c__110077__auto__))
})();
var inst_113354 = [inst_113352,inst_113353];
var inst_113355 = (new cljs.core.PersistentVector(null,2,(5),inst_113349,inst_113354,null));
var state_113651__$1 = state_113651;
var statearr_113714_113904 = state_113651__$1;
(statearr_113714_113904[(2)] = inst_113355);

(statearr_113714_113904[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (113))){
var inst_113555 = (state_113651[(76)]);
var inst_113564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113565 = [inst_113555,inst_113555];
var inst_113566 = (new cljs.core.PersistentVector(null,2,(5),inst_113564,inst_113565,null));
var state_113651__$1 = state_113651;
var statearr_113715_113905 = state_113651__$1;
(statearr_113715_113905[(2)] = inst_113566);

(statearr_113715_113905[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (32))){
var inst_113281 = (state_113651[(39)]);
var inst_113288 = (state_113651[(64)]);
var inst_113315 = (state_113651[(75)]);
var inst_113357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113359 = [inst_113281,inst_113288];
var inst_113360 = (new cljs.core.PersistentVector(null,2,(5),inst_113358,inst_113359,null));
var inst_113361 = [inst_113360,inst_113315];
var inst_113362 = (new cljs.core.PersistentVector(null,2,(5),inst_113357,inst_113361,null));
var state_113651__$1 = state_113651;
var statearr_113716_113906 = state_113651__$1;
(statearr_113716_113906[(2)] = inst_113362);

(statearr_113716_113906[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (40))){
var inst_113387 = (state_113651[(77)]);
var inst_113280 = (state_113651[(61)]);
var inst_113386 = (state_113651[(2)]);
var inst_113387__$1 = (inst_113280 == null);
var state_113651__$1 = (function (){var statearr_113717 = state_113651;
(statearr_113717[(77)] = inst_113387__$1);

(statearr_113717[(14)] = inst_113386);

return statearr_113717;
})();
if(cljs.core.truth_(inst_113387__$1)){
var statearr_113718_113907 = state_113651__$1;
(statearr_113718_113907[(1)] = (42));

} else {
var statearr_113719_113908 = state_113651__$1;
(statearr_113719_113908[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (129))){
var inst_113615 = (state_113651[(32)]);
var state_113651__$1 = state_113651;
var statearr_113720_113909 = state_113651__$1;
(statearr_113720_113909[(2)] = inst_113615);

(statearr_113720_113909[(1)] = (131));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (91))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113473 = (state_113651[(43)]);
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113446 = (state_113651[(24)]);
var inst_113282 = (state_113651[(11)]);
var inst_113486 = (state_113651[(38)]);
var inst_113423 = (state_113651[(20)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113479 = (state_113651[(27)]);
var inst_113500 = (state_113651[(70)]);
var inst_113386 = (state_113651[(14)]);
var inst_113365 = (state_113651[(47)]);
var inst_113445 = (state_113651[(22)]);
var inst_113424 = (state_113651[(21)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113368 = (state_113651[(49)]);
var inst_113476 = (state_113651[(35)]);
var inst_113458 = (state_113651[(50)]);
var inst_113453 = (state_113651[(51)]);
var inst_113312 = (state_113651[(52)]);
var inst_113404 = (state_113651[(17)]);
var inst_113452 = (state_113651[(28)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113469 = (state_113651[(54)]);
var inst_113313 = (state_113651[(55)]);
var inst_113454 = (state_113651[(56)]);
var inst_113278 = (state_113651[(57)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113364 = (state_113651[(58)]);
var inst_113477 = (state_113651[(37)]);
var inst_113502 = (function (){var no_filter_QMARK_ = true;
var t = inst_113459;
var max_limit_QMARK_ = inst_113453;
var next_node = inst_113476;
var map__113277 = inst_113445;
var fast_forward_db_QMARK_ = inst_113464;
var s1 = inst_113324;
var o2 = inst_113386;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var i = inst_113478;
var vec__113274 = inst_113365;
var m1 = inst_113413;
var root_node = inst_113469;
var s2 = inst_113333;
var p2 = inst_113404;
var G__113487 = inst_113500;
var permissions = inst_113454;
var limit = inst_113452;
var start_flake = inst_113423;
var flake_limit = inst_113446;
var offset = inst_113477;
var vec__113267 = inst_113285;
var acc = inst_113480;
var vec__113271 = inst_113364;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113377;
var end_flake = inst_113424;
var base_result = inst_113486;
var s = inst_113479;
var node_start = inst_113473;
var p1 = inst_113395;
var subject_fn = inst_113313;
var object_fn = inst_113368;
var idx_compare = inst_113458;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113422;
var novelty = inst_113463;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113500,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__){
return (function (p1__113249_SHARP_){
var G__113721 = p1__113249_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__113721) : predicate_fn.call(null,G__113721));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113500,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__))
})();
var inst_113503 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_113502,inst_113500);
var state_113651__$1 = state_113651;
var statearr_113722_113910 = state_113651__$1;
(statearr_113722_113910[(2)] = inst_113503);

(statearr_113722_113910[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (117))){
var inst_113569 = (state_113651[(78)]);
var inst_113588 = (state_113651[(2)]);
var inst_113589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113588,(0),null);
var inst_113590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113588,(1),null);
var inst_113591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113592 = [inst_113589,inst_113569,inst_113590];
var inst_113593 = (new cljs.core.PersistentVector(null,3,(5),inst_113591,inst_113592,null));
var state_113651__$1 = state_113651;
var statearr_113723_113911 = state_113651__$1;
(statearr_113723_113911[(2)] = inst_113593);

(statearr_113723_113911[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (108))){
var inst_113609 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113724_113912 = state_113651__$1;
(statearr_113724_113912[(2)] = inst_113609);

(statearr_113724_113912[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (56))){
var inst_113291 = (state_113651[(40)]);
var inst_113413 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113725 = state_113651;
(statearr_113725[(12)] = inst_113413);

return statearr_113725;
})();
if(cljs.core.truth_(inst_113291)){
var statearr_113726_113913 = state_113651__$1;
(statearr_113726_113913[(1)] = (60));

} else {
var statearr_113727_113914 = state_113651__$1;
(statearr_113727_113914[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (33))){
var inst_113365 = (state_113651[(47)]);
var inst_113366 = (state_113651[(79)]);
var inst_113364 = (state_113651[(58)]);
var inst_113364__$1 = (state_113651[(2)]);
var inst_113365__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113364__$1,(0),null);
var inst_113366__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113365__$1,(0),null);
var inst_113367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113365__$1,(1),null);
var inst_113368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113364__$1,(1),null);
var inst_113369 = fluree.db.util.core.pred_ident_QMARK_(inst_113366__$1);
var state_113651__$1 = (function (){var statearr_113728 = state_113651;
(statearr_113728[(47)] = inst_113365__$1);

(statearr_113728[(49)] = inst_113368);

(statearr_113728[(59)] = inst_113367);

(statearr_113728[(79)] = inst_113366__$1);

(statearr_113728[(58)] = inst_113364__$1);

return statearr_113728;
})();
if(inst_113369){
var statearr_113729_113915 = state_113651__$1;
(statearr_113729_113915[(1)] = (34));

} else {
var statearr_113730_113916 = state_113651__$1;
(statearr_113730_113916[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (13))){
var inst_113279 = (state_113651[(65)]);
var inst_113312 = (state_113651[(52)]);
var inst_113312__$1 = (state_113651[(2)]);
var inst_113313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113312__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_113314 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113312__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_113315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_113312__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_113316 = fluree.db.util.core.pred_ident_QMARK_(inst_113279);
var state_113651__$1 = (function (){var statearr_113731 = state_113651;
(statearr_113731[(48)] = inst_113314);

(statearr_113731[(52)] = inst_113312__$1);

(statearr_113731[(75)] = inst_113315);

(statearr_113731[(55)] = inst_113313);

return statearr_113731;
})();
if(inst_113316){
var statearr_113732_113917 = state_113651__$1;
(statearr_113732_113917[(1)] = (14));

} else {
var statearr_113733_113918 = state_113651__$1;
(statearr_113733_113918[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (22))){
var inst_113281 = (state_113651[(39)]);
var state_113651__$1 = state_113651;
var statearr_113734_113919 = state_113651__$1;
(statearr_113734_113919[(2)] = inst_113281);

(statearr_113734_113919[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (90))){
var inst_113314 = (state_113651[(48)]);
var inst_113500 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113735 = state_113651;
(statearr_113735[(70)] = inst_113500);

return statearr_113735;
})();
if(cljs.core.truth_(inst_113314)){
var statearr_113736_113920 = state_113651__$1;
(statearr_113736_113920[(1)] = (91));

} else {
var statearr_113737_113921 = state_113651__$1;
(statearr_113737_113921[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (109))){
var inst_113546 = (state_113651[(26)]);
var inst_113479 = (state_113651[(27)]);
var inst_113554 = (state_113651[(80)]);
var inst_113555 = (state_113651[(76)]);
var inst_113452 = (state_113651[(28)]);
var inst_113556 = (state_113651[(81)]);
var inst_113554__$1 = cljs.core.count(inst_113546);
var inst_113555__$1 = (inst_113479 + inst_113554__$1);
var inst_113556__$1 = (inst_113555__$1 - inst_113452);
var inst_113557 = cljs.core.pos_int_QMARK_(inst_113556__$1);
var state_113651__$1 = (function (){var statearr_113738 = state_113651;
(statearr_113738[(80)] = inst_113554__$1);

(statearr_113738[(76)] = inst_113555__$1);

(statearr_113738[(81)] = inst_113556__$1);

return statearr_113738;
})();
if(inst_113557){
var statearr_113739_113922 = state_113651__$1;
(statearr_113739_113922[(1)] = (112));

} else {
var statearr_113740_113923 = state_113651__$1;
(statearr_113740_113923[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (36))){
var inst_113367 = (state_113651[(59)]);
var inst_113377 = (state_113651[(2)]);
var inst_113378 = fluree.db.util.core.pred_ident_QMARK_(inst_113367);
var state_113651__$1 = (function (){var statearr_113741 = state_113651;
(statearr_113741[(10)] = inst_113377);

return statearr_113741;
})();
if(inst_113378){
var statearr_113742_113924 = state_113651__$1;
(statearr_113742_113924[(1)] = (38));

} else {
var statearr_113743_113925 = state_113651__$1;
(statearr_113743_113925[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (41))){
var inst_113382 = (state_113651[(2)]);
var inst_113383 = fluree.db.util.async.throw_err(inst_113382);
var state_113651__$1 = state_113651;
var statearr_113744_113926 = state_113651__$1;
(statearr_113744_113926[(2)] = inst_113383);

(statearr_113744_113926[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (118))){
var inst_113597 = (state_113651[(2)]);
var inst_113598 = fluree.db.util.async.throw_err(inst_113597);
var state_113651__$1 = state_113651;
var statearr_113745_113927 = state_113651__$1;
(statearr_113745_113927[(2)] = inst_113598);

(statearr_113745_113927[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (89))){
var inst_113494 = (state_113651[(60)]);
var state_113651__$1 = state_113651;
var statearr_113746_113928 = state_113651__$1;
(statearr_113746_113928[(2)] = inst_113494);

(statearr_113746_113928[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (100))){
var state_113651__$1 = state_113651;
var statearr_113747_113929 = state_113651__$1;
(statearr_113747_113929[(2)] = true);

(statearr_113747_113929[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (131))){
var inst_113642 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113748_113930 = state_113651__$1;
(statearr_113748_113930[(2)] = inst_113642);

(statearr_113748_113930[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (122))){
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113469 = (state_113651[(54)]);
var inst_113513 = (state_113651[(68)]);
var inst_113626 = fluree.db.query.range.find_next_valid_node(inst_113469,inst_113513,inst_113459,inst_113463,inst_113464);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(125),inst_113626);
} else {
if((state_val_113652 === (43))){
var inst_113387 = (state_113651[(77)]);
var state_113651__$1 = state_113651;
var statearr_113749_113931 = state_113651__$1;
(statearr_113749_113931[(2)] = inst_113387);

(statearr_113749_113931[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (61))){
var inst_113416 = (cljs.core._LT__EQ_ === end_test);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113416)){
var statearr_113750_113932 = state_113651__$1;
(statearr_113750_113932[(1)] = (63));

} else {
var statearr_113751_113933 = state_113651__$1;
(statearr_113751_113933[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (29))){
var state_113651__$1 = state_113651;
var statearr_113752_113934 = state_113651__$1;
(statearr_113752_113934[(2)] = null);

(statearr_113752_113934[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (44))){
var inst_113391 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113391)){
var statearr_113753_113935 = state_113651__$1;
(statearr_113753_113935[(1)] = (45));

} else {
var statearr_113754_113936 = state_113651__$1;
(statearr_113754_113936[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (93))){
var inst_113368 = (state_113651[(49)]);
var inst_113506 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113755 = state_113651;
(statearr_113755[(69)] = inst_113506);

return statearr_113755;
})();
if(cljs.core.truth_(inst_113368)){
var statearr_113756_113937 = state_113651__$1;
(statearr_113756_113937[(1)] = (94));

} else {
var statearr_113757_113938 = state_113651__$1;
(statearr_113757_113938[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (6))){
var state_113651__$1 = state_113651;
var statearr_113758_113939 = state_113651__$1;
(statearr_113758_113939[(2)] = false);

(statearr_113758_113939[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (111))){
var inst_113480 = (state_113651[(36)]);
var inst_113600 = (state_113651[(2)]);
var inst_113601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113600,(0),null);
var inst_113602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113600,(1),null);
var inst_113603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113600,(2),null);
var inst_113604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113605 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113480,inst_113603);
var inst_113606 = [(0),inst_113601,inst_113602,inst_113605];
var inst_113607 = (new cljs.core.PersistentVector(null,4,(5),inst_113604,inst_113606,null));
var state_113651__$1 = state_113651;
var statearr_113759_113940 = state_113651__$1;
(statearr_113759_113940[(2)] = inst_113607);

(statearr_113759_113940[(1)] = (108));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (28))){
var state_113651__$1 = state_113651;
var statearr_113760_113941 = state_113651__$1;
(statearr_113760_113941[(2)] = null);

(statearr_113760_113941[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (64))){
var state_113651__$1 = state_113651;
var statearr_113761_113942 = state_113651__$1;
(statearr_113761_113942[(2)] = fluree.db.util.core.min_integer);

(statearr_113761_113942[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (103))){
var inst_113446 = (state_113651[(24)]);
var inst_113479 = (state_113651[(27)]);
var inst_113512 = (state_113651[(72)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113524 = cljs.core.count(inst_113512);
var inst_113525 = (inst_113446 - inst_113478);
var inst_113526 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_113525,inst_113512);
var inst_113527 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_113480,inst_113526);
var inst_113528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113529 = (inst_113478 + inst_113524);
var inst_113530 = [(0),inst_113529,inst_113479,inst_113527];
var inst_113531 = (new cljs.core.PersistentVector(null,4,(5),inst_113528,inst_113530,null));
var state_113651__$1 = state_113651;
var statearr_113762_113943 = state_113651__$1;
(statearr_113762_113943[(2)] = inst_113531);

(statearr_113762_113943[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (51))){
var state_113651__$1 = state_113651;
var statearr_113763_113944 = state_113651__$1;
(statearr_113763_113944[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_113763_113944[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (25))){
var inst_113288 = (state_113651[(64)]);
var state_113651__$1 = state_113651;
var statearr_113764_113945 = state_113651__$1;
(statearr_113764_113945[(2)] = inst_113288);

(statearr_113764_113945[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (34))){
var inst_113366 = (state_113651[(79)]);
var inst_113371 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_113366);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(37),inst_113371);
} else {
if((state_val_113652 === (125))){
var inst_113628 = (state_113651[(2)]);
var inst_113629 = fluree.db.util.async.throw_err(inst_113628);
var state_113651__$1 = state_113651;
var statearr_113765_113946 = state_113651__$1;
(statearr_113765_113946[(2)] = inst_113629);

(statearr_113765_113946[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (17))){
var inst_113320 = (state_113651[(2)]);
var inst_113321 = fluree.db.util.async.throw_err(inst_113320);
var state_113651__$1 = state_113651;
var statearr_113766_113947 = state_113651__$1;
(statearr_113766_113947[(2)] = inst_113321);

(statearr_113766_113947[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (3))){
var inst_113260 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113767_113948 = state_113651__$1;
(statearr_113767_113948[(2)] = inst_113260);


cljs.core.async.impl.ioc_helpers.process_exception(state_113651__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (12))){
var state_113651__$1 = state_113651;
var statearr_113768_113949 = state_113651__$1;
(statearr_113768_113949[(2)] = opts);

(statearr_113768_113949[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (2))){
var inst_113649 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_113651__$1,inst_113649);
} else {
if((state_val_113652 === (66))){
var inst_113429 = opts.cljs$lang$protocol_mask$partition0$;
var inst_113430 = (inst_113429 & (64));
var inst_113431 = opts.cljs$core$ISeq$;
var inst_113432 = (cljs.core.PROTOCOL_SENTINEL === inst_113431);
var inst_113433 = ((inst_113430) || (inst_113432));
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113433)){
var statearr_113769_113950 = state_113651__$1;
(statearr_113769_113950[(1)] = (69));

} else {
var statearr_113770_113951 = state_113651__$1;
(statearr_113770_113951[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (107))){
var inst_113534 = (state_113651[(71)]);
var inst_113477 = (state_113651[(37)]);
var inst_113546 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_113477,inst_113534);
var state_113651__$1 = (function (){var statearr_113771 = state_113651;
(statearr_113771[(26)] = inst_113546);

return statearr_113771;
})();
var statearr_113772_113952 = state_113651__$1;
(statearr_113772_113952[(1)] = (109));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (23))){
var inst_113288 = (state_113651[(64)]);
var inst_113337 = cljs.core.boolean_QMARK_(inst_113288);
var state_113651__$1 = state_113651;
if(inst_113337){
var statearr_113774_113953 = state_113651__$1;
(statearr_113774_113953[(1)] = (25));

} else {
var statearr_113775_113954 = state_113651__$1;
(statearr_113775_113954[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (47))){
var inst_113396 = (state_113651[(82)]);
var inst_113287 = (state_113651[(63)]);
var inst_113395 = (state_113651[(2)]);
var inst_113396__$1 = (inst_113287 == null);
var state_113651__$1 = (function (){var statearr_113776 = state_113651;
(statearr_113776[(8)] = inst_113395);

(statearr_113776[(82)] = inst_113396__$1);

return statearr_113776;
})();
if(cljs.core.truth_(inst_113396__$1)){
var statearr_113777_113955 = state_113651__$1;
(statearr_113777_113955[(1)] = (48));

} else {
var statearr_113778_113956 = state_113651__$1;
(statearr_113778_113956[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (35))){
var inst_113366 = (state_113651[(79)]);
var state_113651__$1 = state_113651;
var statearr_113779_113957 = state_113651__$1;
(statearr_113779_113957[(2)] = inst_113366);

(statearr_113779_113957[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (127))){
var inst_113624 = (state_113651[(7)]);
var state_113651__$1 = state_113651;
var statearr_113780_113958 = state_113651__$1;
(statearr_113780_113958[(2)] = inst_113624);

(statearr_113780_113958[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (82))){
var inst_113647 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113781_113959 = state_113651__$1;
(statearr_113781_113959[(2)] = inst_113647);


cljs.core.async.impl.ioc_helpers.process_exception(state_113651__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (76))){
var state_113651__$1 = state_113651;
var statearr_113782_113960 = state_113651__$1;
(statearr_113782_113960[(2)] = fluree.db.util.core.max_long);

(statearr_113782_113960[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (97))){
var inst_113515 = (state_113651[(41)]);
var inst_113477 = (state_113651[(37)]);
var inst_113515__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_113477);
var state_113651__$1 = (function (){var statearr_113783 = state_113651;
(statearr_113783[(41)] = inst_113515__$1);

return statearr_113783;
})();
if(inst_113515__$1){
var statearr_113784_113961 = state_113651__$1;
(statearr_113784_113961[(1)] = (100));

} else {
var statearr_113785_113962 = state_113651__$1;
(statearr_113785_113962[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (19))){
var inst_113286 = (state_113651[(66)]);
var state_113651__$1 = state_113651;
var statearr_113786_113963 = state_113651__$1;
(statearr_113786_113963[(2)] = inst_113286);

(statearr_113786_113963[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (57))){
var state_113651__$1 = state_113651;
var statearr_113787_113964 = state_113651__$1;
(statearr_113787_113964[(2)] = fluree.db.util.core.min_integer);

(statearr_113787_113964[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (68))){
var inst_113440 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113440)){
var statearr_113788_113965 = state_113651__$1;
(statearr_113788_113965[(1)] = (72));

} else {
var statearr_113789_113966 = state_113651__$1;
(statearr_113789_113966[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (11))){
var inst_113309 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,opts);
var state_113651__$1 = state_113651;
var statearr_113790_113967 = state_113651__$1;
(statearr_113790_113967[(2)] = inst_113309);

(statearr_113790_113967[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (115))){
var inst_113574 = (state_113651[(73)]);
var inst_113446 = (state_113651[(24)]);
var inst_113573 = (state_113651[(83)]);
var inst_113572 = (state_113651[(74)]);
var inst_113577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113578 = (inst_113574 - inst_113446);
var inst_113579 = (inst_113573 - inst_113578);
var inst_113580 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_113579,inst_113572);
var inst_113581 = [inst_113446,inst_113580];
var inst_113582 = (new cljs.core.PersistentVector(null,2,(5),inst_113577,inst_113581,null));
var state_113651__$1 = state_113651;
var statearr_113791_113968 = state_113651__$1;
(statearr_113791_113968[(2)] = inst_113582);

(statearr_113791_113968[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (9))){
var state_113651__$1 = state_113651;
var statearr_113792_113969 = state_113651__$1;
(statearr_113792_113969[(2)] = false);

(statearr_113792_113969[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (5))){
var inst_113296 = opts.cljs$lang$protocol_mask$partition0$;
var inst_113297 = (inst_113296 & (64));
var inst_113298 = opts.cljs$core$ISeq$;
var inst_113299 = (cljs.core.PROTOCOL_SENTINEL === inst_113298);
var inst_113300 = ((inst_113297) || (inst_113299));
var state_113651__$1 = state_113651;
if(cljs.core.truth_(inst_113300)){
var statearr_113793_113970 = state_113651__$1;
(statearr_113793_113970[(1)] = (8));

} else {
var statearr_113794_113971 = state_113651__$1;
(statearr_113794_113971[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (112))){
var inst_113554 = (state_113651[(80)]);
var inst_113452 = (state_113651[(28)]);
var inst_113556 = (state_113651[(81)]);
var inst_113559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_113560 = (inst_113554 - inst_113556);
var inst_113561 = [inst_113452,inst_113560];
var inst_113562 = (new cljs.core.PersistentVector(null,2,(5),inst_113559,inst_113561,null));
var state_113651__$1 = state_113651;
var statearr_113795_113972 = state_113651__$1;
(statearr_113795_113972[(2)] = inst_113562);

(statearr_113795_113972[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (83))){
var inst_113423 = (state_113651[(20)]);
var inst_113424 = (state_113651[(21)]);
var inst_113476 = (state_113651[(35)]);
var inst_113485 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_113476);
var inst_113486 = fluree.db.flake.subrange(inst_113485,start_test,inst_113423,end_test,inst_113424);
var inst_113488 = fluree.db.query.range.value_with_nil_pred(idx,inst_113423,inst_113424);
var state_113651__$1 = (function (){var statearr_113796 = state_113651;
(statearr_113796[(38)] = inst_113486);

return statearr_113796;
})();
if(inst_113488){
var statearr_113797_113973 = state_113651__$1;
(statearr_113797_113973[(1)] = (85));

} else {
var statearr_113798_113974 = state_113651__$1;
(statearr_113798_113974[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (14))){
var inst_113279 = (state_113651[(65)]);
var inst_113318 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_113279);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(17),inst_113318);
} else {
if((state_val_113652 === (45))){
var state_113651__$1 = state_113651;
var statearr_113799_113975 = state_113651__$1;
(statearr_113799_113975[(2)] = (-1));

(statearr_113799_113975[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (53))){
var inst_113284 = (state_113651[(62)]);
var inst_113404 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113800 = state_113651;
(statearr_113800[(17)] = inst_113404);

return statearr_113800;
})();
if(cljs.core.truth_(inst_113284)){
var statearr_113801_113976 = state_113651__$1;
(statearr_113801_113976[(1)] = (54));

} else {
var statearr_113802_113977 = state_113651__$1;
(statearr_113802_113977[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (78))){
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113423 = (state_113651[(20)]);
var inst_113469 = (state_113651[(54)]);
var inst_113468 = (state_113651[(2)]);
var inst_113469__$1 = fluree.db.util.async.throw_err(inst_113468);
var inst_113470 = fluree.db.query.range.find_next_valid_node(inst_113469__$1,inst_113423,inst_113459,inst_113463,inst_113464);
var state_113651__$1 = (function (){var statearr_113803 = state_113651;
(statearr_113803[(54)] = inst_113469__$1);

return statearr_113803;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(79),inst_113470);
} else {
if((state_val_113652 === (26))){
var state_113651__$1 = state_113651;
var statearr_113804_113978 = state_113651__$1;
(statearr_113804_113978[(1)] = (28));



return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (123))){
var state_113651__$1 = state_113651;
var statearr_113806_113979 = state_113651__$1;
(statearr_113806_113979[(2)] = null);

(statearr_113806_113979[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (16))){
var inst_113286 = (state_113651[(66)]);
var inst_113324 = (state_113651[(2)]);
var inst_113325 = fluree.db.util.core.pred_ident_QMARK_(inst_113286);
var state_113651__$1 = (function (){var statearr_113807 = state_113651;
(statearr_113807[(15)] = inst_113324);

return statearr_113807;
})();
if(inst_113325){
var statearr_113808_113980 = state_113651__$1;
(statearr_113808_113980[(1)] = (18));

} else {
var statearr_113809_113981 = state_113651__$1;
(statearr_113809_113981[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (81))){
var state_113651__$1 = state_113651;
var statearr_113810_113982 = state_113651__$1;
(statearr_113810_113982[(2)] = null);

(statearr_113810_113982[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (120))){
var inst_113513 = (state_113651[(68)]);
var state_113651__$1 = state_113651;
var statearr_113811_113983 = state_113651__$1;
(statearr_113811_113983[(2)] = inst_113513);

(statearr_113811_113983[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (79))){
var inst_113473 = (state_113651[(43)]);
var inst_113472 = (state_113651[(2)]);
var inst_113473__$1 = fluree.db.util.async.throw_err(inst_113472);
var state_113651__$1 = (function (){var statearr_113812 = state_113651;
(statearr_113812[(43)] = inst_113473__$1);

return statearr_113812;
})();
if(cljs.core.truth_(inst_113473__$1)){
var statearr_113813_113984 = state_113651__$1;
(statearr_113813_113984[(1)] = (80));

} else {
var statearr_113814_113985 = state_113651__$1;
(statearr_113814_113985[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (38))){
var inst_113367 = (state_113651[(59)]);
var inst_113380 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_113367);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(41),inst_113380);
} else {
if((state_val_113652 === (126))){
var inst_113632 = (state_113651[(31)]);
var state_113651__$1 = state_113651;
var statearr_113815_113986 = state_113651__$1;
(statearr_113815_113986[(2)] = inst_113632);

(statearr_113815_113986[(1)] = (128));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (98))){
var inst_113453 = (state_113651[(51)]);
var state_113651__$1 = state_113651;
var statearr_113816_113987 = state_113651__$1;
(statearr_113816_113987[(2)] = inst_113453);

(statearr_113816_113987[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (124))){
var inst_113624 = (state_113651[(7)]);
var inst_113632 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113817 = state_113651;
(statearr_113817[(31)] = inst_113632);

return statearr_113817;
})();
if(cljs.core.truth_(inst_113624)){
var statearr_113818_113988 = state_113651__$1;
(statearr_113818_113988[(1)] = (126));

} else {
var statearr_113819_113989 = state_113651__$1;
(statearr_113819_113989[(1)] = (127));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (87))){
var inst_113313 = (state_113651[(55)]);
var inst_113494 = (state_113651[(2)]);
var state_113651__$1 = (function (){var statearr_113820 = state_113651;
(statearr_113820[(60)] = inst_113494);

return statearr_113820;
})();
if(cljs.core.truth_(inst_113313)){
var statearr_113821_113990 = state_113651__$1;
(statearr_113821_113990[(1)] = (88));

} else {
var statearr_113822_113991 = state_113651__$1;
(statearr_113822_113991[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (30))){
var inst_113343 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113823_113992 = state_113651__$1;
(statearr_113823_113992[(2)] = inst_113343);

(statearr_113823_113992[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (73))){
var state_113651__$1 = state_113651;
var statearr_113824_113993 = state_113651__$1;
(statearr_113824_113993[(2)] = opts);

(statearr_113824_113993[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (96))){
var inst_113476 = (state_113651[(35)]);
var inst_113453 = (state_113651[(51)]);
var inst_113512 = (state_113651[(2)]);
var inst_113513 = fluree.db.dbproto._rhs(inst_113476);
var state_113651__$1 = (function (){var statearr_113825 = state_113651;
(statearr_113825[(68)] = inst_113513);

(statearr_113825[(72)] = inst_113512);

return statearr_113825;
})();
if(cljs.core.truth_(inst_113453)){
var statearr_113826_113994 = state_113651__$1;
(statearr_113826_113994[(1)] = (97));

} else {
var statearr_113827_113995 = state_113651__$1;
(statearr_113827_113995[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (10))){
var inst_113304 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113828_113996 = state_113651__$1;
(statearr_113828_113996[(2)] = inst_113304);

(statearr_113828_113996[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (18))){
var inst_113286 = (state_113651[(66)]);
var inst_113327 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_113286);
var state_113651__$1 = state_113651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_113651__$1,(21),inst_113327);
} else {
if((state_val_113652 === (105))){
var inst_113513 = (state_113651[(68)]);
var inst_113611 = (state_113651[(2)]);
var inst_113612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113611,(0),null);
var inst_113613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113611,(1),null);
var inst_113614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113611,(2),null);
var inst_113615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113611,(3),null);
var state_113651__$1 = (function (){var statearr_113829 = state_113651;
(statearr_113829[(30)] = inst_113613);

(statearr_113829[(32)] = inst_113615);

(statearr_113829[(33)] = inst_113612);

(statearr_113829[(34)] = inst_113614);

return statearr_113829;
})();
if(cljs.core.truth_(inst_113513)){
var statearr_113830_113997 = state_113651__$1;
(statearr_113830_113997[(1)] = (119));

} else {
var statearr_113831_113998 = state_113651__$1;
(statearr_113831_113998[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (52))){
var inst_113287 = (state_113651[(63)]);
var state_113651__$1 = state_113651;
var statearr_113832_113999 = state_113651__$1;
(statearr_113832_113999[(2)] = inst_113287);

(statearr_113832_113999[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (114))){
var inst_113574 = (state_113651[(73)]);
var inst_113446 = (state_113651[(24)]);
var inst_113546 = (state_113651[(26)]);
var inst_113573 = (state_113651[(83)]);
var inst_113478 = (state_113651[(29)]);
var inst_113572 = (state_113651[(74)]);
var inst_113568 = (state_113651[(2)]);
var inst_113569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113568,(0),null);
var inst_113570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_113568,(1),null);
var inst_113571 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_113570,inst_113546);
var inst_113572__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_113571);
var inst_113573__$1 = cljs.core.count(inst_113572__$1);
var inst_113574__$1 = (inst_113478 + inst_113573__$1);
var inst_113575 = (inst_113574__$1 > inst_113446);
var state_113651__$1 = (function (){var statearr_113833 = state_113651;
(statearr_113833[(73)] = inst_113574__$1);

(statearr_113833[(83)] = inst_113573__$1);

(statearr_113833[(78)] = inst_113569);

(statearr_113833[(74)] = inst_113572__$1);

return statearr_113833;
})();
if(cljs.core.truth_(inst_113575)){
var statearr_113834_114000 = state_113651__$1;
(statearr_113834_114000[(1)] = (115));

} else {
var statearr_113835_114001 = state_113651__$1;
(statearr_113835_114001[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (67))){
var state_113651__$1 = state_113651;
var statearr_113836_114002 = state_113651__$1;
(statearr_113836_114002[(2)] = false);

(statearr_113836_114002[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (71))){
var inst_113437 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113837_114003 = state_113651__$1;
(statearr_113837_114003[(2)] = inst_113437);

(statearr_113837_114003[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (42))){
var inst_113377 = (state_113651[(10)]);
var state_113651__$1 = state_113651;
var statearr_113838_114004 = state_113651__$1;
(statearr_113838_114004[(2)] = inst_113377);

(statearr_113838_114004[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (80))){
var inst_113473 = (state_113651[(43)]);
var inst_113448 = (state_113651[(25)]);
var inst_113475 = cljs.core.PersistentVector.EMPTY;
var inst_113476 = inst_113473;
var inst_113477 = inst_113448;
var inst_113478 = (0);
var inst_113479 = (0);
var inst_113480 = inst_113475;
var state_113651__$1 = (function (){var statearr_113839 = state_113651;
(statearr_113839[(27)] = inst_113479);

(statearr_113839[(35)] = inst_113476);

(statearr_113839[(36)] = inst_113480);

(statearr_113839[(29)] = inst_113478);

(statearr_113839[(37)] = inst_113477);

return statearr_113839;
})();
var statearr_113840_114005 = state_113651__$1;
(statearr_113840_114005[(2)] = null);

(statearr_113840_114005[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (37))){
var inst_113373 = (state_113651[(2)]);
var inst_113374 = fluree.db.util.async.throw_err(inst_113373);
var state_113651__$1 = state_113651;
var statearr_113841_114006 = state_113651__$1;
(statearr_113841_114006[(2)] = inst_113374);

(statearr_113841_114006[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (63))){
var state_113651__$1 = state_113651;
var statearr_113842_114007 = state_113651__$1;
(statearr_113842_114007[(2)] = (2147483647));

(statearr_113842_114007[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (94))){
var inst_113395 = (state_113651[(8)]);
var inst_113333 = (state_113651[(9)]);
var inst_113377 = (state_113651[(10)]);
var inst_113473 = (state_113651[(43)]);
var inst_113464 = (state_113651[(44)]);
var inst_113459 = (state_113651[(45)]);
var inst_113463 = (state_113651[(46)]);
var inst_113446 = (state_113651[(24)]);
var inst_113282 = (state_113651[(11)]);
var inst_113486 = (state_113651[(38)]);
var inst_113423 = (state_113651[(20)]);
var inst_113413 = (state_113651[(12)]);
var inst_113422 = (state_113651[(13)]);
var inst_113479 = (state_113651[(27)]);
var inst_113386 = (state_113651[(14)]);
var inst_113365 = (state_113651[(47)]);
var inst_113445 = (state_113651[(22)]);
var inst_113424 = (state_113651[(21)]);
var inst_113324 = (state_113651[(15)]);
var inst_113314 = (state_113651[(48)]);
var inst_113290 = (state_113651[(16)]);
var inst_113368 = (state_113651[(49)]);
var inst_113476 = (state_113651[(35)]);
var inst_113458 = (state_113651[(50)]);
var inst_113453 = (state_113651[(51)]);
var inst_113312 = (state_113651[(52)]);
var inst_113404 = (state_113651[(17)]);
var inst_113452 = (state_113651[(28)]);
var inst_113283 = (state_113651[(18)]);
var inst_113289 = (state_113651[(19)]);
var inst_113285 = (state_113651[(53)]);
var inst_113469 = (state_113651[(54)]);
var inst_113506 = (state_113651[(69)]);
var inst_113313 = (state_113651[(55)]);
var inst_113454 = (state_113651[(56)]);
var inst_113278 = (state_113651[(57)]);
var inst_113480 = (state_113651[(36)]);
var inst_113478 = (state_113651[(29)]);
var inst_113364 = (state_113651[(58)]);
var inst_113477 = (state_113651[(37)]);
var inst_113508 = (function (){var no_filter_QMARK_ = true;
var t = inst_113459;
var max_limit_QMARK_ = inst_113453;
var next_node = inst_113476;
var map__113277 = inst_113445;
var fast_forward_db_QMARK_ = inst_113464;
var s1 = inst_113324;
var o2 = inst_113386;
var t1 = inst_113282;
var predicate_fn = inst_113314;
var i = inst_113478;
var vec__113274 = inst_113365;
var m1 = inst_113413;
var root_node = inst_113469;
var s2 = inst_113333;
var p2 = inst_113404;
var G__113487 = inst_113506;
var permissions = inst_113454;
var limit = inst_113452;
var start_flake = inst_113423;
var flake_limit = inst_113446;
var offset = inst_113477;
var vec__113267 = inst_113285;
var acc = inst_113480;
var vec__113271 = inst_113364;
var t2 = inst_113289;
var map__113270 = inst_113312;
var op1 = inst_113283;
var o1 = inst_113377;
var end_flake = inst_113424;
var base_result = inst_113486;
var s = inst_113479;
var node_start = inst_113473;
var p1 = inst_113395;
var subject_fn = inst_113313;
var object_fn = inst_113368;
var idx_compare = inst_113458;
var vec__113264 = inst_113278;
var op2 = inst_113290;
var m2 = inst_113422;
var novelty = inst_113463;
return ((function (no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113506,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__){
return (function (p1__113250_SHARP_){
var G__113843 = p1__113250_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__113843) : object_fn.call(null,G__113843));
});
;})(no_filter_QMARK_,t,max_limit_QMARK_,next_node,map__113277,fast_forward_db_QMARK_,s1,o2,t1,predicate_fn,i,vec__113274,m1,root_node,s2,p2,G__113487,permissions,limit,start_flake,flake_limit,offset,vec__113267,acc,vec__113271,t2,map__113270,op1,o1,end_flake,base_result,s,node_start,p1,subject_fn,object_fn,idx_compare,vec__113264,op2,m2,novelty,inst_113395,inst_113333,inst_113377,inst_113473,inst_113464,inst_113459,inst_113463,inst_113446,inst_113282,inst_113486,inst_113423,inst_113413,inst_113422,inst_113479,inst_113386,inst_113365,inst_113445,inst_113424,inst_113324,inst_113314,inst_113290,inst_113368,inst_113476,inst_113458,inst_113453,inst_113312,inst_113404,inst_113452,inst_113283,inst_113289,inst_113285,inst_113469,inst_113506,inst_113313,inst_113454,inst_113278,inst_113480,inst_113478,inst_113364,inst_113477,state_val_113652,c__110077__auto__))
})();
var inst_113509 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_113508,inst_113506);
var state_113651__$1 = state_113651;
var statearr_113844_114008 = state_113651__$1;
(statearr_113844_114008[(2)] = inst_113509);

(statearr_113844_114008[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (8))){
var state_113651__$1 = state_113651;
var statearr_113845_114009 = state_113651__$1;
(statearr_113845_114009[(2)] = true);

(statearr_113845_114009[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (49))){
var inst_113396 = (state_113651[(82)]);
var state_113651__$1 = state_113651;
var statearr_113846_114010 = state_113651__$1;
(statearr_113846_114010[(2)] = inst_113396);

(statearr_113846_114010[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_113652 === (84))){
var inst_113644 = (state_113651[(2)]);
var state_113651__$1 = state_113651;
var statearr_113847_114011 = state_113651__$1;
(statearr_113847_114011[(2)] = inst_113644);

(statearr_113847_114011[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$state_machine__109971__auto__ = null;
var fluree$db$query$range$state_machine__109971__auto____0 = (function (){
var statearr_113848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_113848[(0)] = fluree$db$query$range$state_machine__109971__auto__);

(statearr_113848[(1)] = (1));

return statearr_113848;
});
var fluree$db$query$range$state_machine__109971__auto____1 = (function (state_113651){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_113651);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e113849){if((e113849 instanceof Object)){
var ex__109974__auto__ = e113849;
var statearr_113850_114012 = state_113651;
(statearr_113850_114012[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_113651);

return cljs.core.cst$kw$recur;
} else {
throw e113849;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114013 = state_113651;
state_113651 = G__114013;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__109971__auto__ = function(state_113651){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__109971__auto____1.call(this,state_113651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__109971__auto____0;
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__109971__auto____1;
return fluree$db$query$range$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_113851 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_113851[(6)] = c__110077__auto__);

return statearr_113851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7;

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114068){
var state_val_114069 = (state_114068[(1)]);
if((state_val_114069 === (7))){
var inst_114032 = (state_114068[(7)]);
var inst_114042 = (state_114068[(8)]);
var inst_114040 = fluree.db.flake.Flake__GT_parts(inst_114032);
var inst_114041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(0),null);
var inst_114042__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(1),null);
var inst_114043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(2),null);
var inst_114044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(3),null);
var inst_114045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(4),null);
var inst_114046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_114040,(5),null);
var inst_114047 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_114043,inst_114042__$1);
var state_114068__$1 = (function (){var statearr_114070 = state_114068;
(statearr_114070[(9)] = inst_114045);

(statearr_114070[(10)] = inst_114046);

(statearr_114070[(11)] = inst_114041);

(statearr_114070[(12)] = inst_114044);

(statearr_114070[(8)] = inst_114042__$1);

return statearr_114070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114068__$1,(10),inst_114047);
} else {
if((state_val_114069 === (1))){
var inst_114021 = cljs.core.seq(flakes);
var inst_114022 = cljs.core.first(inst_114021);
var inst_114023 = cljs.core.next(inst_114021);
var inst_114024 = cljs.core.PersistentVector.EMPTY;
var inst_114025 = flakes;
var inst_114026 = inst_114024;
var state_114068__$1 = (function (){var statearr_114071 = state_114068;
(statearr_114071[(13)] = inst_114025);

(statearr_114071[(14)] = inst_114026);

(statearr_114071[(15)] = inst_114023);

(statearr_114071[(16)] = inst_114022);

return statearr_114071;
})();
var statearr_114072_114089 = state_114068__$1;
(statearr_114072_114089[(2)] = null);

(statearr_114072_114089[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (4))){
var inst_114032 = (state_114068[(7)]);
var inst_114035 = fluree.db.query.range.is_tag_flake_QMARK_(inst_114032);
var state_114068__$1 = state_114068;
if(inst_114035){
var statearr_114073_114090 = state_114068__$1;
(statearr_114073_114090[(1)] = (7));

} else {
var statearr_114074_114091 = state_114068__$1;
(statearr_114074_114091[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (6))){
var inst_114064 = (state_114068[(2)]);
var state_114068__$1 = state_114068;
var statearr_114075_114092 = state_114068__$1;
(statearr_114075_114092[(2)] = inst_114064);

(statearr_114075_114092[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (3))){
var inst_114066 = (state_114068[(2)]);
var state_114068__$1 = state_114068;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114068__$1,inst_114066);
} else {
if((state_val_114069 === (2))){
var inst_114025 = (state_114068[(13)]);
var inst_114032 = (state_114068[(7)]);
var inst_114031 = cljs.core.seq(inst_114025);
var inst_114032__$1 = cljs.core.first(inst_114031);
var inst_114033 = cljs.core.next(inst_114031);
var state_114068__$1 = (function (){var statearr_114076 = state_114068;
(statearr_114076[(7)] = inst_114032__$1);

(statearr_114076[(17)] = inst_114033);

return statearr_114076;
})();
if(cljs.core.truth_(inst_114032__$1)){
var statearr_114077_114093 = state_114068__$1;
(statearr_114077_114093[(1)] = (4));

} else {
var statearr_114078_114094 = state_114068__$1;
(statearr_114078_114094[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (9))){
var inst_114061 = (state_114068[(2)]);
var state_114068__$1 = state_114068;
var statearr_114079_114095 = state_114068__$1;
(statearr_114079_114095[(2)] = inst_114061);

(statearr_114079_114095[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (5))){
var inst_114026 = (state_114068[(14)]);
var state_114068__$1 = state_114068;
var statearr_114080_114096 = state_114068__$1;
(statearr_114080_114096[(2)] = inst_114026);

(statearr_114080_114096[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (10))){
var inst_114045 = (state_114068[(9)]);
var inst_114046 = (state_114068[(10)]);
var inst_114041 = (state_114068[(11)]);
var inst_114044 = (state_114068[(12)]);
var inst_114042 = (state_114068[(8)]);
var inst_114033 = (state_114068[(17)]);
var inst_114026 = (state_114068[(14)]);
var inst_114049 = (state_114068[(2)]);
var inst_114050 = fluree.db.util.async.throw_err(inst_114049);
var inst_114051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114052 = [inst_114041,inst_114042,inst_114050,inst_114044,inst_114045,inst_114046];
var inst_114053 = (new cljs.core.PersistentVector(null,6,(5),inst_114051,inst_114052,null));
var inst_114054 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_114053);
var inst_114055 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114026,inst_114054);
var inst_114025 = inst_114033;
var inst_114026__$1 = inst_114055;
var state_114068__$1 = (function (){var statearr_114081 = state_114068;
(statearr_114081[(13)] = inst_114025);

(statearr_114081[(14)] = inst_114026__$1);

return statearr_114081;
})();
var statearr_114082_114097 = state_114068__$1;
(statearr_114082_114097[(2)] = null);

(statearr_114082_114097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114069 === (8))){
var inst_114032 = (state_114068[(7)]);
var inst_114033 = (state_114068[(17)]);
var inst_114026 = (state_114068[(14)]);
var inst_114058 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_114026,inst_114032);
var inst_114025 = inst_114033;
var inst_114026__$1 = inst_114058;
var state_114068__$1 = (function (){var statearr_114083 = state_114068;
(statearr_114083[(13)] = inst_114025);

(statearr_114083[(14)] = inst_114026__$1);

return statearr_114083;
})();
var statearr_114084_114098 = state_114068__$1;
(statearr_114084_114098[(2)] = null);

(statearr_114084_114098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____0 = (function (){
var statearr_114085 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114085[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__);

(statearr_114085[(1)] = (1));

return statearr_114085;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____1 = (function (state_114068){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114068);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114086){if((e114086 instanceof Object)){
var ex__109974__auto__ = e114086;
var statearr_114087_114099 = state_114068;
(statearr_114087_114099[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114068);

return cljs.core.cst$kw$recur;
} else {
throw e114086;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114100 = state_114068;
state_114068 = G__114100;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__ = function(state_114068){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____1.call(this,state_114068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114088 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114088[(6)] = c__110077__auto__);

return statearr_114088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__114102 = arguments.length;
switch (G__114102) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
});

fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114249){
var state_val_114250 = (state_114249[(1)]);
if((state_val_114250 === (62))){
var inst_114245 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114251_114335 = state_114249__$1;
(statearr_114251_114335[(2)] = inst_114245);


cljs.core.async.impl.ioc_helpers.process_exception(state_114249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (7))){
var inst_114120 = (state_114249[(7)]);
var inst_114120__$1 = (state_114249[(2)]);
var state_114249__$1 = (function (){var statearr_114252 = state_114249;
(statearr_114252[(7)] = inst_114120__$1);

return statearr_114252;
})();
if(cljs.core.truth_(inst_114120__$1)){
var statearr_114253_114336 = state_114249__$1;
(statearr_114253_114336[(1)] = (8));

} else {
var statearr_114254_114337 = state_114249__$1;
(statearr_114254_114337[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (59))){
var inst_114225 = (state_114249[(2)]);
var inst_114226 = fluree.db.util.async.throw_err(inst_114225);
var state_114249__$1 = state_114249;
var statearr_114255_114338 = state_114249__$1;
(statearr_114255_114338[(2)] = inst_114226);

(statearr_114255_114338[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (20))){
var inst_114146 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114256_114339 = state_114249__$1;
(statearr_114256_114339[(2)] = inst_114146);

(statearr_114256_114339[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (58))){
var inst_114229 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114257_114340 = state_114249__$1;
(statearr_114257_114340[(2)] = inst_114229);

(statearr_114257_114340[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (60))){
var inst_114237 = (state_114249[(8)]);
var inst_114239 = fluree.db.query.range.coerce_tag_flakes(db,inst_114237);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(63),inst_114239);
} else {
if((state_val_114250 === (27))){
var inst_114111 = (state_114249[(9)]);
var state_114249__$1 = state_114249;
var statearr_114258_114341 = state_114249__$1;
(statearr_114258_114341[(2)] = inst_114111);

(statearr_114258_114341[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (1))){
var state_114249__$1 = state_114249;
var statearr_114259_114342 = state_114249__$1;
(statearr_114259_114342[(2)] = null);

(statearr_114259_114342[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (24))){
var inst_114120 = (state_114249[(7)]);
var inst_114237 = (state_114249[(2)]);
var state_114249__$1 = (function (){var statearr_114260 = state_114249;
(statearr_114260[(8)] = inst_114237);

return statearr_114260;
})();
if(cljs.core.truth_(inst_114120)){
var statearr_114261_114343 = state_114249__$1;
(statearr_114261_114343[(1)] = (60));

} else {
var statearr_114262_114344 = state_114249__$1;
(statearr_114262_114344[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (55))){
var inst_114216 = (state_114249[(2)]);
var inst_114217 = fluree.db.util.async.throw_err(inst_114216);
var state_114249__$1 = state_114249;
var statearr_114263_114345 = state_114249__$1;
(statearr_114263_114345[(2)] = inst_114217);

(statearr_114263_114345[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (39))){
var inst_114114 = (state_114249[(10)]);
var inst_114185 = (state_114249[(11)]);
var inst_114185__$1 = cljs.core.not(inst_114114);
var state_114249__$1 = (function (){var statearr_114264 = state_114249;
(statearr_114264[(11)] = inst_114185__$1);

return statearr_114264;
})();
if(inst_114185__$1){
var statearr_114265_114346 = state_114249__$1;
(statearr_114265_114346[(1)] = (42));

} else {
var statearr_114266_114347 = state_114249__$1;
(statearr_114266_114347[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (46))){
var inst_114111 = (state_114249[(9)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114111)){
var statearr_114267_114348 = state_114249__$1;
(statearr_114267_114348[(1)] = (52));

} else {
var statearr_114268_114349 = state_114249__$1;
(statearr_114268_114349[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (4))){
var inst_114111 = (state_114249[(9)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114249,(3),Error,null,(2));
var inst_114110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(0),null);
var inst_114111__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(1),null);
var inst_114112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(2),null);
var inst_114113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(fparts,(3),null);
var inst_114114 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_114111__$1);
var state_114249__$1 = (function (){var statearr_114269 = state_114249;
(statearr_114269[(12)] = inst_114110);

(statearr_114269[(13)] = inst_114112);

(statearr_114269[(14)] = inst_114113);

(statearr_114269[(10)] = inst_114114);

(statearr_114269[(9)] = inst_114111__$1);

return statearr_114269;
})();
if(cljs.core.truth_(inst_114111__$1)){
var statearr_114270_114350 = state_114249__$1;
(statearr_114270_114350[(1)] = (5));

} else {
var statearr_114271_114351 = state_114249__$1;
(statearr_114271_114351[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (54))){
var inst_114231 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114272_114352 = state_114249__$1;
(statearr_114272_114352[(2)] = inst_114231);

(statearr_114272_114352[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (15))){
var inst_114112 = (state_114249[(13)]);
var inst_114136 = typeof inst_114112 === 'string';
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114136)){
var statearr_114273_114353 = state_114249__$1;
(statearr_114273_114353[(1)] = (18));

} else {
var statearr_114274_114354 = state_114249__$1;
(statearr_114274_114354[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (48))){
var inst_114110 = (state_114249[(12)]);
var inst_114125 = (state_114249[(15)]);
var inst_114150 = (state_114249[(16)]);
var inst_114120 = (state_114249[(7)]);
var inst_114113 = (state_114249[(14)]);
var inst_114114 = (state_114249[(10)]);
var inst_114194 = (state_114249[(17)]);
var inst_114111 = (state_114249[(9)]);
var inst_114196 = (function (){var obj_fn = inst_114194;
var t = inst_114113;
var temp__5733__auto__ = inst_114194;
var p = inst_114111;
var idx_predicate_QMARK_ = inst_114114;
var o = inst_114150;
var tag_predicate_QMARK_ = inst_114120;
var s = inst_114110;
var o_coerce_QMARK_ = inst_114125;
var vec__114107 = fparts;
return ((function (obj_fn,t,temp__5733__auto__,p,idx_predicate_QMARK_,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,vec__114107,inst_114110,inst_114125,inst_114150,inst_114120,inst_114113,inst_114114,inst_114194,inst_114111,state_val_114250,c__110077__auto__){
return (function (x){
var and__4120__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4120__auto__;
}
});
;})(obj_fn,t,temp__5733__auto__,p,idx_predicate_QMARK_,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,vec__114107,inst_114110,inst_114125,inst_114150,inst_114120,inst_114113,inst_114114,inst_114194,inst_114111,state_val_114250,c__110077__auto__))
})();
var state_114249__$1 = state_114249;
var statearr_114275_114355 = state_114249__$1;
(statearr_114275_114355[(2)] = inst_114196);

(statearr_114275_114355[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (50))){
var inst_114110 = (state_114249[(12)]);
var inst_114113 = (state_114249[(14)]);
var inst_114111 = (state_114249[(9)]);
var inst_114200 = (state_114249[(2)]);
var inst_114201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114202 = [inst_114111,inst_114110,null,inst_114113];
var inst_114203 = (new cljs.core.PersistentVector(null,4,(5),inst_114201,inst_114202,null));
var inst_114204 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_114200);
var inst_114205 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_114203,inst_114204);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(51),inst_114205);
} else {
if((state_val_114250 === (21))){
var inst_114142 = (state_114249[(2)]);
var inst_114143 = fluree.db.util.async.throw_err(inst_114142);
var state_114249__$1 = state_114249;
var statearr_114276_114356 = state_114249__$1;
(statearr_114276_114356[(2)] = inst_114143);

(statearr_114276_114356[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (31))){
var inst_114171 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114277_114357 = state_114249__$1;
(statearr_114277_114357[(2)] = inst_114171);

(statearr_114277_114357[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (32))){
var inst_114150 = (state_114249[(16)]);
var inst_114164 = cljs.core.fn_QMARK_(inst_114150);
var inst_114165 = (!(inst_114164));
var state_114249__$1 = state_114249;
var statearr_114278_114358 = state_114249__$1;
(statearr_114278_114358[(2)] = inst_114165);

(statearr_114278_114358[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (40))){
var inst_114111 = (state_114249[(9)]);
var state_114249__$1 = state_114249;
var statearr_114279_114359 = state_114249__$1;
(statearr_114279_114359[(2)] = inst_114111);

(statearr_114279_114359[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (56))){
var inst_114110 = (state_114249[(12)]);
var inst_114150 = (state_114249[(16)]);
var inst_114113 = (state_114249[(14)]);
var inst_114111 = (state_114249[(9)]);
var inst_114220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114221 = [inst_114150,inst_114111,inst_114110,inst_114113];
var inst_114222 = (new cljs.core.PersistentVector(null,4,(5),inst_114220,inst_114221,null));
var inst_114223 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_114222,opts);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(59),inst_114223);
} else {
if((state_val_114250 === (33))){
var inst_114114 = (state_114249[(10)]);
var state_114249__$1 = state_114249;
var statearr_114280_114360 = state_114249__$1;
(statearr_114280_114360[(2)] = inst_114114);

(statearr_114280_114360[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (13))){
var inst_114110 = (state_114249[(12)]);
var inst_114150 = (state_114249[(2)]);
var state_114249__$1 = (function (){var statearr_114281 = state_114249;
(statearr_114281[(16)] = inst_114150);

return statearr_114281;
})();
if(cljs.core.truth_(inst_114110)){
var statearr_114282_114361 = state_114249__$1;
(statearr_114282_114361[(1)] = (22));

} else {
var statearr_114283_114362 = state_114249__$1;
(statearr_114283_114362[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (22))){
var inst_114110 = (state_114249[(12)]);
var inst_114150 = (state_114249[(16)]);
var inst_114113 = (state_114249[(14)]);
var inst_114111 = (state_114249[(9)]);
var inst_114152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114153 = [inst_114110,inst_114111,inst_114150,inst_114113];
var inst_114154 = (new cljs.core.PersistentVector(null,4,(5),inst_114152,inst_114153,null));
var inst_114155 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_114154,opts);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(25),inst_114155);
} else {
if((state_val_114250 === (36))){
var inst_114111 = (state_114249[(9)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114111)){
var statearr_114284_114363 = state_114249__$1;
(statearr_114284_114363[(1)] = (39));

} else {
var statearr_114285_114364 = state_114249__$1;
(statearr_114285_114364[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (41))){
var inst_114192 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114192)){
var statearr_114286_114365 = state_114249__$1;
(statearr_114286_114365[(1)] = (45));

} else {
var statearr_114287_114366 = state_114249__$1;
(statearr_114287_114366[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (43))){
var inst_114185 = (state_114249[(11)]);
var state_114249__$1 = state_114249;
var statearr_114288_114367 = state_114249__$1;
(statearr_114288_114367[(2)] = inst_114185);

(statearr_114288_114367[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (61))){
var inst_114237 = (state_114249[(8)]);
var state_114249__$1 = state_114249;
var statearr_114289_114368 = state_114249__$1;
(statearr_114289_114368[(2)] = inst_114237);

(statearr_114289_114368[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (29))){
var inst_114114 = (state_114249[(10)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114114)){
var statearr_114290_114369 = state_114249__$1;
(statearr_114290_114369[(1)] = (32));

} else {
var statearr_114291_114370 = state_114249__$1;
(statearr_114291_114370[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (44))){
var inst_114189 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114292_114371 = state_114249__$1;
(statearr_114292_114371[(2)] = inst_114189);

(statearr_114292_114371[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (6))){
var state_114249__$1 = state_114249;
var statearr_114293_114372 = state_114249__$1;
(statearr_114293_114372[(2)] = false);

(statearr_114293_114372[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (28))){
var inst_114174 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114174)){
var statearr_114294_114373 = state_114249__$1;
(statearr_114294_114373[(1)] = (35));

} else {
var statearr_114295_114374 = state_114249__$1;
(statearr_114295_114374[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (51))){
var inst_114207 = (state_114249[(2)]);
var inst_114208 = fluree.db.util.async.throw_err(inst_114207);
var state_114249__$1 = state_114249;
var statearr_114296_114375 = state_114249__$1;
(statearr_114296_114375[(2)] = inst_114208);

(statearr_114296_114375[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (25))){
var inst_114157 = (state_114249[(2)]);
var inst_114158 = fluree.db.util.async.throw_err(inst_114157);
var state_114249__$1 = state_114249;
var statearr_114297_114376 = state_114249__$1;
(statearr_114297_114376[(2)] = inst_114158);

(statearr_114297_114376[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (34))){
var inst_114168 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114298_114377 = state_114249__$1;
(statearr_114298_114377[(2)] = inst_114168);

(statearr_114298_114377[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (17))){
var inst_114133 = (state_114249[(2)]);
var inst_114134 = fluree.db.util.async.throw_err(inst_114133);
var state_114249__$1 = state_114249;
var statearr_114299_114378 = state_114249__$1;
(statearr_114299_114378[(2)] = inst_114134);

(statearr_114299_114378[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (3))){
var inst_114103 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114300_114379 = state_114249__$1;
(statearr_114300_114379[(2)] = inst_114103);


cljs.core.async.impl.ioc_helpers.process_exception(state_114249__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (12))){
var inst_114112 = (state_114249[(13)]);
var inst_114129 = fluree.db.query.range.tag_string_QMARK_(inst_114112);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114129)){
var statearr_114301_114380 = state_114249__$1;
(statearr_114301_114380[(1)] = (14));

} else {
var statearr_114302_114381 = state_114249__$1;
(statearr_114302_114381[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (2))){
var inst_114247 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114249__$1,inst_114247);
} else {
if((state_val_114250 === (23))){
var inst_114111 = (state_114249[(9)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114111)){
var statearr_114303_114382 = state_114249__$1;
(statearr_114303_114382[(1)] = (26));

} else {
var statearr_114304_114383 = state_114249__$1;
(statearr_114304_114383[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (47))){
var inst_114233 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114305_114384 = state_114249__$1;
(statearr_114305_114384[(2)] = inst_114233);

(statearr_114305_114384[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (35))){
var inst_114110 = (state_114249[(12)]);
var inst_114150 = (state_114249[(16)]);
var inst_114113 = (state_114249[(14)]);
var inst_114111 = (state_114249[(9)]);
var inst_114176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114177 = [inst_114111,inst_114150,inst_114110,inst_114113];
var inst_114178 = (new cljs.core.PersistentVector(null,4,(5),inst_114176,inst_114177,null));
var inst_114179 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_114178,opts);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(38),inst_114179);
} else {
if((state_val_114250 === (19))){
var state_114249__$1 = state_114249;
var statearr_114306_114385 = state_114249__$1;
(statearr_114306_114385[(2)] = null);

(statearr_114306_114385[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (57))){
var state_114249__$1 = state_114249;
var statearr_114307_114386 = state_114249__$1;
(statearr_114307_114386[(2)] = null);

(statearr_114307_114386[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (11))){
var inst_114112 = (state_114249[(13)]);
var state_114249__$1 = state_114249;
var statearr_114308_114387 = state_114249__$1;
(statearr_114308_114387[(2)] = inst_114112);

(statearr_114308_114387[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (9))){
var inst_114120 = (state_114249[(7)]);
var state_114249__$1 = state_114249;
var statearr_114309_114388 = state_114249__$1;
(statearr_114309_114388[(2)] = inst_114120);

(statearr_114309_114388[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (5))){
var inst_114111 = (state_114249[(9)]);
var inst_114116 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_114111);
var inst_114117 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_114116);
var state_114249__$1 = state_114249;
var statearr_114310_114389 = state_114249__$1;
(statearr_114310_114389[(2)] = inst_114117);

(statearr_114310_114389[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (14))){
var inst_114112 = (state_114249[(13)]);
var inst_114131 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_114112);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(17),inst_114131);
} else {
if((state_val_114250 === (45))){
var inst_114194 = (state_114249[(17)]);
var inst_114194__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_114249__$1 = (function (){var statearr_114311 = state_114249;
(statearr_114311[(17)] = inst_114194__$1);

return statearr_114311;
})();
if(cljs.core.truth_(inst_114194__$1)){
var statearr_114312_114390 = state_114249__$1;
(statearr_114312_114390[(1)] = (48));

} else {
var statearr_114313_114391 = state_114249__$1;
(statearr_114313_114391[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (53))){
var inst_114150 = (state_114249[(16)]);
var state_114249__$1 = state_114249;
if(cljs.core.truth_(inst_114150)){
var statearr_114314_114392 = state_114249__$1;
(statearr_114314_114392[(1)] = (56));

} else {
var statearr_114315_114393 = state_114249__$1;
(statearr_114315_114393[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (26))){
var inst_114150 = (state_114249[(16)]);
var inst_114161 = (state_114249[(18)]);
var inst_114161__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_114150);
var state_114249__$1 = (function (){var statearr_114316 = state_114249;
(statearr_114316[(18)] = inst_114161__$1);

return statearr_114316;
})();
if(inst_114161__$1){
var statearr_114317_114394 = state_114249__$1;
(statearr_114317_114394[(1)] = (29));

} else {
var statearr_114318_114395 = state_114249__$1;
(statearr_114318_114395[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (16))){
var inst_114148 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114319_114396 = state_114249__$1;
(statearr_114319_114396[(2)] = inst_114148);

(statearr_114319_114396[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (38))){
var inst_114181 = (state_114249[(2)]);
var inst_114182 = fluree.db.util.async.throw_err(inst_114181);
var state_114249__$1 = state_114249;
var statearr_114320_114397 = state_114249__$1;
(statearr_114320_114397[(2)] = inst_114182);

(statearr_114320_114397[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (30))){
var inst_114161 = (state_114249[(18)]);
var state_114249__$1 = state_114249;
var statearr_114321_114398 = state_114249__$1;
(statearr_114321_114398[(2)] = inst_114161);

(statearr_114321_114398[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (10))){
var inst_114125 = (state_114249[(15)]);
var inst_114125__$1 = (state_114249[(2)]);
var inst_114126 = cljs.core.not(inst_114125__$1);
var state_114249__$1 = (function (){var statearr_114322 = state_114249;
(statearr_114322[(15)] = inst_114125__$1);

return statearr_114322;
})();
if(inst_114126){
var statearr_114323_114399 = state_114249__$1;
(statearr_114323_114399[(1)] = (11));

} else {
var statearr_114324_114400 = state_114249__$1;
(statearr_114324_114400[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (18))){
var inst_114112 = (state_114249[(13)]);
var inst_114111 = (state_114249[(9)]);
var inst_114138 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_114111);
var inst_114139 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_114138),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_114112)].join('');
var inst_114140 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_114139);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(21),inst_114140);
} else {
if((state_val_114250 === (52))){
var inst_114110 = (state_114249[(12)]);
var inst_114150 = (state_114249[(16)]);
var inst_114113 = (state_114249[(14)]);
var inst_114111 = (state_114249[(9)]);
var inst_114211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114212 = [inst_114111,inst_114110,inst_114150,inst_114113];
var inst_114213 = (new cljs.core.PersistentVector(null,4,(5),inst_114211,inst_114212,null));
var inst_114214 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_114213,opts);
var state_114249__$1 = state_114249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114249__$1,(55),inst_114214);
} else {
if((state_val_114250 === (42))){
var inst_114150 = (state_114249[(16)]);
var state_114249__$1 = state_114249;
var statearr_114325_114401 = state_114249__$1;
(statearr_114325_114401[(2)] = inst_114150);

(statearr_114325_114401[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (37))){
var inst_114235 = (state_114249[(2)]);
var state_114249__$1 = state_114249;
var statearr_114326_114402 = state_114249__$1;
(statearr_114326_114402[(2)] = inst_114235);

(statearr_114326_114402[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (63))){
var inst_114241 = (state_114249[(2)]);
var inst_114242 = fluree.db.util.async.throw_err(inst_114241);
var state_114249__$1 = state_114249;
var statearr_114327_114403 = state_114249__$1;
(statearr_114327_114403[(2)] = inst_114242);

(statearr_114327_114403[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (8))){
var inst_114112 = (state_114249[(13)]);
var inst_114122 = typeof inst_114112 === 'string';
var state_114249__$1 = state_114249;
var statearr_114328_114404 = state_114249__$1;
(statearr_114328_114404[(2)] = inst_114122);

(statearr_114328_114404[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114250 === (49))){
var inst_114110 = (state_114249[(12)]);
var inst_114125 = (state_114249[(15)]);
var inst_114150 = (state_114249[(16)]);
var inst_114120 = (state_114249[(7)]);
var inst_114113 = (state_114249[(14)]);
var inst_114114 = (state_114249[(10)]);
var inst_114194 = (state_114249[(17)]);
var inst_114111 = (state_114249[(9)]);
var inst_114198 = (function (){var t = inst_114113;
var temp__5733__auto__ = inst_114194;
var p = inst_114111;
var idx_predicate_QMARK_ = inst_114114;
var o = inst_114150;
var tag_predicate_QMARK_ = inst_114120;
var s = inst_114110;
var o_coerce_QMARK_ = inst_114125;
var vec__114107 = fparts;
return ((function (t,temp__5733__auto__,p,idx_predicate_QMARK_,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,vec__114107,inst_114110,inst_114125,inst_114150,inst_114120,inst_114113,inst_114114,inst_114194,inst_114111,state_val_114250,c__110077__auto__){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
;})(t,temp__5733__auto__,p,idx_predicate_QMARK_,o,tag_predicate_QMARK_,s,o_coerce_QMARK_,vec__114107,inst_114110,inst_114125,inst_114150,inst_114120,inst_114113,inst_114114,inst_114194,inst_114111,state_val_114250,c__110077__auto__))
})();
var state_114249__$1 = state_114249;
var statearr_114329_114405 = state_114249__$1;
(statearr_114329_114405[(2)] = inst_114198);

(statearr_114329_114405[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$state_machine__109971__auto__ = null;
var fluree$db$query$range$state_machine__109971__auto____0 = (function (){
var statearr_114330 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_114330[(0)] = fluree$db$query$range$state_machine__109971__auto__);

(statearr_114330[(1)] = (1));

return statearr_114330;
});
var fluree$db$query$range$state_machine__109971__auto____1 = (function (state_114249){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114249);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114331){if((e114331 instanceof Object)){
var ex__109974__auto__ = e114331;
var statearr_114332_114406 = state_114249;
(statearr_114332_114406[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114249);

return cljs.core.cst$kw$recur;
} else {
throw e114331;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114407 = state_114249;
state_114249 = G__114407;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__109971__auto__ = function(state_114249){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__109971__auto____1.call(this,state_114249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__109971__auto____0;
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__109971__auto____1;
return fluree$db$query$range$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114333 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114333[(6)] = c__110077__auto__);

return statearr_114333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.range.search.cljs$lang$maxFixedArity = 3;

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__114409 = arguments.length;
switch (G__114409) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
});

fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_114441){
var state_val_114442 = (state_114441[(1)]);
if((state_val_114442 === (1))){
var state_114441__$1 = state_114441;
var statearr_114443_114456 = state_114441__$1;
(statearr_114443_114456[(2)] = null);

(statearr_114443_114456[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114442 === (2))){
var inst_114439 = (state_114441[(2)]);
var state_114441__$1 = state_114441;
return cljs.core.async.impl.ioc_helpers.return_chan(state_114441__$1,inst_114439);
} else {
if((state_val_114442 === (3))){
var inst_114410 = (state_114441[(2)]);
var state_114441__$1 = state_114441;
var statearr_114444_114457 = state_114441__$1;
(statearr_114444_114457[(2)] = inst_114410);


cljs.core.async.impl.ioc_helpers.process_exception(state_114441__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114442 === (4))){
var inst_114414 = (state_114441[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_114441,(3),java.lang.Exception,null,(2));
var inst_114414__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_114441__$1 = (function (){var statearr_114445 = state_114441;
(statearr_114445[(7)] = inst_114414__$1);

return statearr_114445;
})();
if(cljs.core.truth_(inst_114414__$1)){
var statearr_114446_114458 = state_114441__$1;
(statearr_114446_114458[(1)] = (5));

} else {
var statearr_114447_114459 = state_114441__$1;
(statearr_114447_114459[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_114442 === (5))){
var inst_114414 = (state_114441[(7)]);
var inst_114416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114417 = fluree.db.flake.max_subject_id(inst_114414);
var inst_114418 = [inst_114417];
var inst_114419 = (new cljs.core.PersistentVector(null,1,(5),inst_114416,inst_114418,null));
var inst_114420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_114421 = fluree.db.flake.min_subject_id(inst_114414);
var inst_114422 = [inst_114421];
var inst_114423 = (new cljs.core.PersistentVector(null,1,(5),inst_114420,inst_114422,null));
var inst_114424 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_114419,cljs.core._LT__EQ_,inst_114423,opts);
var state_114441__$1 = state_114441;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_114441__$1,(8),inst_114424);
} else {
if((state_val_114442 === (6))){
var inst_114429 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_114430 = ["Invalid collection name: ",inst_114429].join('');
var inst_114431 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_114432 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_114433 = cljs.core.PersistentHashMap.fromArrays(inst_114431,inst_114432);
var inst_114434 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_114430,inst_114433);
var inst_114435 = (function(){throw inst_114434})();
var state_114441__$1 = state_114441;
var statearr_114448_114460 = state_114441__$1;
(statearr_114448_114460[(2)] = inst_114435);

(statearr_114448_114460[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_114442 === (7))){
var inst_114437 = (state_114441[(2)]);
var state_114441__$1 = state_114441;
var statearr_114449_114461 = state_114441__$1;
(statearr_114449_114461[(2)] = inst_114437);


cljs.core.async.impl.ioc_helpers.process_exception(state_114441__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_114442 === (8))){
var inst_114426 = (state_114441[(2)]);
var inst_114427 = fluree.db.util.async.throw_err(inst_114426);
var state_114441__$1 = state_114441;
var statearr_114450_114462 = state_114441__$1;
(statearr_114450_114462[(2)] = inst_114427);

(statearr_114450_114462[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$range$state_machine__109971__auto__ = null;
var fluree$db$query$range$state_machine__109971__auto____0 = (function (){
var statearr_114451 = [null,null,null,null,null,null,null,null];
(statearr_114451[(0)] = fluree$db$query$range$state_machine__109971__auto__);

(statearr_114451[(1)] = (1));

return statearr_114451;
});
var fluree$db$query$range$state_machine__109971__auto____1 = (function (state_114441){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_114441);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e114452){if((e114452 instanceof Object)){
var ex__109974__auto__ = e114452;
var statearr_114453_114463 = state_114441;
(statearr_114453_114463[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_114441);

return cljs.core.cst$kw$recur;
} else {
throw e114452;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__114464 = state_114441;
state_114441 = G__114464;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__109971__auto__ = function(state_114441){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__109971__auto____1.call(this,state_114441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__109971__auto____0;
fluree$db$query$range$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__109971__auto____1;
return fluree$db$query$range$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_114454 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_114454[(6)] = c__110077__auto__);

return statearr_114454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3;

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__114468 = flakes;
var vec__114469 = G__114468;
var seq__114470 = cljs.core.seq(vec__114469);
var first__114471 = cljs.core.first(seq__114470);
var seq__114470__$1 = cljs.core.next(seq__114470);
var flake_SINGLEQUOTE_ = first__114471;
var r = seq__114470__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__114468__$1 = G__114468;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__114478 = G__114468__$1;
var seq__114479 = cljs.core.seq(vec__114478);
var first__114480 = cljs.core.first(seq__114479);
var seq__114479__$1 = cljs.core.next(seq__114479);
var flake_SINGLEQUOTE___$1 = first__114480;
var r__$1 = seq__114479__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e114482){if((e114482 instanceof java.lang.Exception)){
var e = e114482;
return null;
} else {
throw e114482;

}
}})();
var map__114481 = cmd_map;
var map__114481__$1 = (((((!((map__114481 == null))))?(((((map__114481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114481):map__114481);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114481__$1,cljs.core.cst$kw$expire);
var G__114484 = r__$1;
var G__114485 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__114468__$1 = G__114484;
result_STAR___$1 = G__114485;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__114494 = blocks;
var vec__114495 = G__114494;
var seq__114496 = cljs.core.seq(vec__114495);
var first__114497 = cljs.core.first(seq__114496);
var seq__114496__$1 = cljs.core.next(seq__114496);
var block_SINGLEQUOTE_ = first__114497;
var r = seq__114496__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__114494__$1 = G__114494;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__114503 = G__114494__$1;
var seq__114504 = cljs.core.seq(vec__114503);
var first__114505 = cljs.core.first(seq__114504);
var seq__114504__$1 = cljs.core.next(seq__114504);
var block_SINGLEQUOTE___$1 = first__114505;
var r__$1 = seq__114504__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__114506 = block_SINGLEQUOTE___$1;
var map__114506__$1 = (((((!((map__114506 == null))))?(((((map__114506.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__114506.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__114506):map__114506);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114506__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114506__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__114506__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__114486_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__114486_SHARP_.p,(2))){
return p1__114486_SHARP_.o;
} else {
return null;
}
});})(G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__114487_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__114487_SHARP_.p,(1))){
return p1__114487_SHARP_.o;
} else {
return null;
}
});})(G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__114488_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__114488_SHARP_.p,(5))){
return p1__114488_SHARP_.o;
} else {
return null;
}
});})(G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,instant,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__114489_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__114489_SHARP_.p,(7))){
return p1__114489_SHARP_.o;
} else {
return null;
}
});})(G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,instant,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__114490_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__114490_SHARP_.p,(106));
});})(G__114494__$1,result_STAR___$1,map__114506,map__114506__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__114503,seq__114504,first__114505,seq__114504__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__114494,vec__114495,seq__114496,first__114497,seq__114496__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__114508 = r__$1;
var G__114509 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__114494__$1 = G__114508;
result_STAR___$1 = G__114509;
continue;
}
break;
}
});
